
module ol_vamp_4_pphjjj2_hggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G6tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,66) :: G0
  complex(REALKIND), dimension(4,5,4,308) :: G1
  complex(REALKIND), dimension(4,15,4,570) :: G2
  complex(REALKIND), dimension(4,35,4,360) :: G3
  complex(REALKIND), dimension(4,70,4,176) :: G4
  complex(REALKIND), dimension(4,126,4,48) :: G5
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
  complex(REALKIND), pointer :: G6tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,159,32))
    allocate(G4tensorhel(70,104,32))
    allocate(G5tensorhel(126,64,32))
    allocate(G6tensorhel(210,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)
  G6tensor => G6tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,2),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,223),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,224),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,3))
  call loop_QS_A(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,225),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,62),MT,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,229),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,7))
  call loop_QS_A(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,230),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,62),MT,G2(:,:,:,9))
  call loop_QS_A(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,231),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,62),MT,G2(:,:,:,11))
  call loop_QS_A(G2(:,:,:,11),wf(:,0),G2(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,235),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,236),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,62),MT,G2(:,:,:,15))
  call loop_QS_A(G2(:,:,:,15),wf(:,0),G2(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,237),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,62),MT,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,241),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,19))
  call loop_QS_A(G2(:,:,:,19),wf(:,0),G2(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,242),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,21))
  call loop_QS_A(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,243),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,62),MT,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,0),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,58),MT,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-2),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,58),MT,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,-2),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,62),MT,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,58),MT,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-2),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,62),MT,G3(:,:,:,5))
  call loop_QS_A(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,6),MT,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,2),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,62),MT,G3(:,:,:,7))
  call loop_QS_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_QV_A(G2(:,:,:,31),wf(:,4),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,62),MT,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,0),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_QV_A(G2(:,:,:,31),wf(:,5),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,62),MT,G3(:,:,:,11))
  call loop_QS_A(G3(:,:,:,11),wf(:,0),G3(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,31),wf(:,166),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,62),MT,G3(:,:,:,13))
  call loop_QS_A(G3(:,:,:,13),wf(:,0),G3(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_QV_A(G2(:,:,:,31),wf(:,101),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,30),MT,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-5),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,62),MT,G4(:,:,:,1))
  call loop_QS_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,38),MT,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,101),G3(:,:,:,18))
  call loop_Q_A(G3(:,:,:,18),Q(:,62),MT,G4(:,:,:,3))
  call loop_QS_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_QV_A(G3(:,:,:,17),wf(:,-4),G3(:,:,:,19))
  call loop_Q_A(G3(:,:,:,19),Q(:,54),MT,G4(:,:,:,5))
  call loop_QV_A(G4(:,:,:,5),wf(:,-3),G4(:,:,:,6))
  call loop_Q_A(G4(:,:,:,6),Q(:,62),MT,G5(:,:,:,1))
  call loop_QS_A(G5(:,:,:,1),wf(:,0),G5(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,2),Q(:,63),MT,G6tensor(:,1))
  call loop_QV_A(G3(:,:,:,17),wf(:,-3),G3(:,:,:,20))
  call loop_Q_A(G3(:,:,:,20),Q(:,46),MT,G4(:,:,:,7))
  call loop_QV_A(G4(:,:,:,7),wf(:,-4),G4(:,:,:,8))
  call loop_Q_A(G4(:,:,:,8),Q(:,62),MT,G5(:,:,:,3))
  call loop_QS_A(G5(:,:,:,3),wf(:,0),G5(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,4),Q(:,63),MT,G6tensor(:,2))
  call loop_QV_A(G2(:,:,:,31),wf(:,169),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,62),MT,G3(:,:,:,21))
  call loop_QS_A(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,31),wf(:,109),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,46),MT,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,62),MT,G4(:,:,:,9))
  call loop_QS_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,31),wf(:,-4),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,22),MT,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,109),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,62),MT,G4(:,:,:,11))
  call loop_QS_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,4))
  call loop_QV_A(G3(:,:,:,25),wf(:,-5),G3(:,:,:,27))
  call loop_Q_A(G3(:,:,:,27),Q(:,54),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,-3),G4(:,:,:,14))
  call loop_Q_A(G4(:,:,:,14),Q(:,62),MT,G5(:,:,:,5))
  call loop_QS_A(G5(:,:,:,5),wf(:,0),G5(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,6),Q(:,63),MT,G6tensor(:,3))
  call loop_QV_A(G3(:,:,:,25),wf(:,-3),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,30),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,-5),G4(:,:,:,16))
  call loop_Q_A(G4(:,:,:,16),Q(:,62),MT,G5(:,:,:,7))
  call loop_QS_A(G5(:,:,:,7),wf(:,0),G5(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,8),Q(:,63),MT,G6tensor(:,4))
  call loop_QV_A(G2(:,:,:,31),wf(:,171),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,62),MT,G3(:,:,:,29))
  call loop_QS_A(G3(:,:,:,29),wf(:,0),G3(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,9))
  call loop_QV_A(G2(:,:,:,31),wf(:,119),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,54),MT,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,62),MT,G4(:,:,:,17))
  call loop_QS_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,63),MT,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,31),wf(:,-3),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,14),MT,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,119),G3(:,:,:,34))
  call loop_Q_A(G3(:,:,:,34),Q(:,62),MT,G4(:,:,:,19))
  call loop_QS_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,63),MT,G5tensor(:,6))
  call loop_QV_A(G3(:,:,:,33),wf(:,-5),G3(:,:,:,35))
  call loop_Q_A(G3(:,:,:,35),Q(:,46),MT,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,-4),G4(:,:,:,22))
  call loop_Q_A(G4(:,:,:,22),Q(:,62),MT,G5(:,:,:,9))
  call loop_QS_A(G5(:,:,:,9),wf(:,0),G5(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,10),Q(:,63),MT,G6tensor(:,5))
  call loop_QV_A(G3(:,:,:,33),wf(:,-4),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,30),MT,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,-5),G4(:,:,:,24))
  call loop_Q_A(G4(:,:,:,24),Q(:,62),MT,G5(:,:,:,11))
  call loop_QS_A(G5(:,:,:,11),wf(:,0),G5(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,12),Q(:,63),MT,G6tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,253),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,62),MT,G2(:,:,:,44))
  call loop_QS_A(G2(:,:,:,44),wf(:,0),G2(:,:,:,45),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,254),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,46))
  call loop_QS_A(G2(:,:,:,46),wf(:,0),G2(:,:,:,47),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,255),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,62),MT,G2(:,:,:,48))
  call loop_QS_A(G2(:,:,:,48),wf(:,0),G2(:,:,:,49),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,259),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,62),MT,G2(:,:,:,50))
  call loop_QS_A(G2(:,:,:,50),wf(:,0),G2(:,:,:,51),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,260),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,52))
  call loop_QS_A(G2(:,:,:,52),wf(:,0),G2(:,:,:,53),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,261),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,62),MT,G2(:,:,:,54))
  call loop_QS_A(G2(:,:,:,54),wf(:,0),G2(:,:,:,55),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,265),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,62),MT,G2(:,:,:,56))
  call loop_QS_A(G2(:,:,:,56),wf(:,0),G2(:,:,:,57),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,266),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,62),MT,G2(:,:,:,58))
  call loop_QS_A(G2(:,:,:,58),wf(:,0),G2(:,:,:,59),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,267),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,62),MT,G2(:,:,:,60))
  call loop_QS_A(G2(:,:,:,60),wf(:,0),G2(:,:,:,61),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,19),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,54),MT,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-3),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,62),MT,G3(:,:,:,37))
  call loop_QS_A(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,21),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,54),MT,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,-3),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,62),MT,G3(:,:,:,39))
  call loop_QS_A(G3(:,:,:,39),wf(:,0),G3(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,22),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,54),MT,G2(:,:,:,66))
  call loop_QV_A(G2(:,:,:,66),wf(:,-3),G2(:,:,:,67))
  call loop_Q_A(G2(:,:,:,67),Q(:,62),MT,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,0),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,-3),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,10),MT,G2(:,:,:,68))
  call loop_QV_A(G2(:,:,:,68),wf(:,19),G2(:,:,:,69))
  call loop_Q_A(G2(:,:,:,69),Q(:,62),MT,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,13))
  call loop_QV_A(G2(:,:,:,68),wf(:,21),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,62),MT,G3(:,:,:,45))
  call loop_QS_A(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MT,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,68),wf(:,22),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,62),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,15))
  call loop_QV_A(G2(:,:,:,68),wf(:,175),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,62),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,68),wf(:,76),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,30),MT,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,-5),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,62),MT,G4(:,:,:,25))
  call loop_QS_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,68),wf(:,-5),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,42),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,76),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,62),MT,G4(:,:,:,27))
  call loop_QS_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G3(:,:,:,53),wf(:,-4),G3(:,:,:,55))
  call loop_Q_A(G3(:,:,:,55),Q(:,58),MT,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,-2),G4(:,:,:,30))
  call loop_Q_A(G4(:,:,:,30),Q(:,62),MT,G5(:,:,:,13))
  call loop_QS_A(G5(:,:,:,13),wf(:,0),G5(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,14),Q(:,63),MT,G6tensor(:,7))
  call loop_QV_A(G3(:,:,:,53),wf(:,-2),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,46),MT,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,-4),G4(:,:,:,32))
  call loop_Q_A(G4(:,:,:,32),Q(:,62),MT,G5(:,:,:,15))
  call loop_QS_A(G5(:,:,:,15),wf(:,0),G5(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,16),Q(:,63),MT,G6tensor(:,8))
  call loop_QV_A(G2(:,:,:,68),wf(:,178),G2(:,:,:,75))
  call loop_Q_A(G2(:,:,:,75),Q(:,62),MT,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,0),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,68),wf(:,84),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,46),MT,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_Q_A(G3(:,:,:,60),Q(:,62),MT,G4(:,:,:,33))
  call loop_QS_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,68),wf(:,-4),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,26),MT,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,84),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,62),MT,G4(:,:,:,35))
  call loop_QS_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,10))
  call loop_QV_A(G3(:,:,:,61),wf(:,-5),G3(:,:,:,63))
  call loop_Q_A(G3(:,:,:,63),Q(:,58),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,-2),G4(:,:,:,38))
  call loop_Q_A(G4(:,:,:,38),Q(:,62),MT,G5(:,:,:,17))
  call loop_QS_A(G5(:,:,:,17),wf(:,0),G5(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,18),Q(:,63),MT,G6tensor(:,9))
  call loop_QV_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,30),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,-5),G4(:,:,:,40))
  call loop_Q_A(G4(:,:,:,40),Q(:,62),MT,G5(:,:,:,19))
  call loop_QS_A(G5(:,:,:,19),wf(:,0),G5(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,20),Q(:,63),MT,G6tensor(:,10))
  call loop_QV_A(G2(:,:,:,68),wf(:,180),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,62),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,68),wf(:,119),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,58),MT,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-2),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,62),MT,G4(:,:,:,41))
  call loop_QS_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,63),MT,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,68),wf(:,-2),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,14),MT,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,119),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,62),MT,G4(:,:,:,43))
  call loop_QS_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,63),MT,G5tensor(:,12))
  call loop_QV_A(G3(:,:,:,69),wf(:,-5),G3(:,:,:,71))
  call loop_Q_A(G3(:,:,:,71),Q(:,46),MT,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,-4),G4(:,:,:,46))
  call loop_Q_A(G4(:,:,:,46),Q(:,62),MT,G5(:,:,:,21))
  call loop_QS_A(G5(:,:,:,21),wf(:,0),G5(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,22),Q(:,63),MT,G6tensor(:,11))
  call loop_QV_A(G3(:,:,:,69),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,30),MT,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,-5),G4(:,:,:,48))
  call loop_Q_A(G4(:,:,:,48),Q(:,62),MT,G5(:,:,:,23))
  call loop_QS_A(G5(:,:,:,23),wf(:,0),G5(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,24),Q(:,63),MT,G6tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,274),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,62),MT,G2(:,:,:,81))
  call loop_QS_A(G2(:,:,:,81),wf(:,0),G2(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),MT,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,1),wf(:,275),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,62),MT,G2(:,:,:,83))
  call loop_QS_A(G2(:,:,:,83),wf(:,0),G2(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,1),wf(:,276),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,62),MT,G2(:,:,:,85))
  call loop_QS_A(G2(:,:,:,85),wf(:,0),G2(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,1),wf(:,280),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,62),MT,G2(:,:,:,87))
  call loop_QS_A(G2(:,:,:,87),wf(:,0),G2(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,1),wf(:,281),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,62),MT,G2(:,:,:,89))
  call loop_QS_A(G2(:,:,:,89),wf(:,0),G2(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,1),wf(:,282),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,62),MT,G2(:,:,:,91))
  call loop_QS_A(G2(:,:,:,91),wf(:,0),G2(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,1),wf(:,30),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,46),MT,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,62),MT,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,0),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,32),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,46),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-4),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,62),MT,G3(:,:,:,75))
  call loop_QS_A(G3(:,:,:,75),wf(:,0),G3(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,33),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,46),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,62),MT,G3(:,:,:,77))
  call loop_QS_A(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,18),MT,G2(:,:,:,99))
  call loop_QV_A(G2(:,:,:,99),wf(:,30),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,62),MT,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,0),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,99),wf(:,32),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,62),MT,G3(:,:,:,81))
  call loop_QS_A(G3(:,:,:,81),wf(:,0),G3(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G2(:,:,:,99),wf(:,33),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,62),MT,G3(:,:,:,83))
  call loop_QS_A(G3(:,:,:,83),wf(:,0),G3(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G2(:,:,:,99),wf(:,183),G2(:,:,:,103))
  call loop_Q_A(G2(:,:,:,103),Q(:,62),MT,G3(:,:,:,85))
  call loop_QS_A(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),MT,G4tensor(:,25))
  call loop_QV_A(G2(:,:,:,99),wf(:,65),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,30),MT,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-5),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,62),MT,G4(:,:,:,49))
  call loop_QS_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,99),wf(:,-5),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,50),MT,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,65),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,62),MT,G4(:,:,:,51))
  call loop_QS_A(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,14))
  call loop_QV_A(G3(:,:,:,89),wf(:,-3),G3(:,:,:,91))
  call loop_Q_A(G3(:,:,:,91),Q(:,58),MT,G4(:,:,:,53))
  call loop_QV_A(G4(:,:,:,53),wf(:,-2),G4(:,:,:,54))
  call loop_Q_A(G4(:,:,:,54),Q(:,62),MT,G5(:,:,:,25))
  call loop_QS_A(G5(:,:,:,25),wf(:,0),G5(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,26),Q(:,63),MT,G6tensor(:,13))
  call loop_QV_A(G3(:,:,:,89),wf(:,-2),G3(:,:,:,92))
  call loop_Q_A(G3(:,:,:,92),Q(:,54),MT,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,-3),G4(:,:,:,56))
  call loop_Q_A(G4(:,:,:,56),Q(:,62),MT,G5(:,:,:,27))
  call loop_QS_A(G5(:,:,:,27),wf(:,0),G5(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,28),Q(:,63),MT,G6tensor(:,14))
  call loop_QV_A(G2(:,:,:,99),wf(:,191),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,62),MT,G3(:,:,:,93))
  call loop_QS_A(G3(:,:,:,93),wf(:,0),G3(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,63),MT,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,99),wf(:,84),G2(:,:,:,107))
  call loop_Q_A(G2(:,:,:,107),Q(:,54),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-3),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,62),MT,G4(:,:,:,57))
  call loop_QS_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MT,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,99),wf(:,-3),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,26),MT,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,84),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,62),MT,G4(:,:,:,59))
  call loop_QS_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MT,G5tensor(:,16))
  call loop_QV_A(G3(:,:,:,97),wf(:,-5),G3(:,:,:,99))
  call loop_Q_A(G3(:,:,:,99),Q(:,58),MT,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,-2),G4(:,:,:,62))
  call loop_Q_A(G4(:,:,:,62),Q(:,62),MT,G5(:,:,:,29))
  call loop_QS_A(G5(:,:,:,29),wf(:,0),G5(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,30),Q(:,63),MT,G6tensor(:,15))
  call loop_QV_A(G3(:,:,:,97),wf(:,-2),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,30),MT,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,-5),G4(:,:,:,64))
  call loop_Q_A(G4(:,:,:,64),Q(:,62),MT,G5(:,:,:,31))
  call loop_QS_A(G5(:,:,:,31),wf(:,0),G5(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,32),Q(:,63),MT,G6tensor(:,16))
  call loop_QV_A(G2(:,:,:,99),wf(:,193),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,62),MT,G3(:,:,:,101))
  call loop_QS_A(G3(:,:,:,101),wf(:,0),G3(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,27))
  call loop_QV_A(G2(:,:,:,99),wf(:,109),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,58),MT,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-2),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,62),MT,G4(:,:,:,65))
  call loop_QS_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,63),MT,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,99),wf(:,-2),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,22),MT,G3(:,:,:,105))
  call loop_QV_A(G3(:,:,:,105),wf(:,109),G3(:,:,:,106))
  call loop_Q_A(G3(:,:,:,106),Q(:,62),MT,G4(:,:,:,67))
  call loop_QS_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G3(:,:,:,105),wf(:,-5),G3(:,:,:,107))
  call loop_Q_A(G3(:,:,:,107),Q(:,54),MT,G4(:,:,:,69))
  call loop_QV_A(G4(:,:,:,69),wf(:,-3),G4(:,:,:,70))
  call loop_Q_A(G4(:,:,:,70),Q(:,62),MT,G5(:,:,:,33))
  call loop_QS_A(G5(:,:,:,33),wf(:,0),G5(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,34),Q(:,63),MT,G6tensor(:,17))
  call loop_QV_A(G3(:,:,:,105),wf(:,-3),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,30),MT,G4(:,:,:,71))
  call loop_QV_A(G4(:,:,:,71),wf(:,-5),G4(:,:,:,72))
  call loop_Q_A(G4(:,:,:,72),Q(:,62),MT,G5(:,:,:,35))
  call loop_QS_A(G5(:,:,:,35),wf(:,0),G5(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,36),Q(:,63),MT,G6tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,286),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,62),MT,G2(:,:,:,112))
  call loop_QS_A(G2(:,:,:,112),wf(:,0),G2(:,:,:,113),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,1),wf(:,287),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,62),MT,G2(:,:,:,114))
  call loop_QS_A(G2(:,:,:,114),wf(:,0),G2(:,:,:,115),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,1),wf(:,288),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,62),MT,G2(:,:,:,116))
  call loop_QS_A(G2(:,:,:,116),wf(:,0),G2(:,:,:,117),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,1),wf(:,38),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,30),MT,G2(:,:,:,118))
  call loop_QV_A(G2(:,:,:,118),wf(:,-5),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,62),MT,G3(:,:,:,109))
  call loop_QS_A(G3(:,:,:,109),wf(:,0),G3(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G1(:,:,:,1),wf(:,40),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,30),MT,G2(:,:,:,120))
  call loop_QV_A(G2(:,:,:,120),wf(:,-5),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,62),MT,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,0),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MT,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,1),wf(:,41),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,30),MT,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,-5),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,62),MT,G3(:,:,:,113))
  call loop_QS_A(G3(:,:,:,113),wf(:,0),G3(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,63),MT,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,34),MT,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,38),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,62),MT,G3(:,:,:,115))
  call loop_QS_A(G3(:,:,:,115),wf(:,0),G3(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,63),MT,G4tensor(:,31))
  call loop_QV_A(G2(:,:,:,124),wf(:,40),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,62),MT,G3(:,:,:,117))
  call loop_QS_A(G3(:,:,:,117),wf(:,0),G3(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,63),MT,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,124),wf(:,41),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,62),MT,G3(:,:,:,119))
  call loop_QS_A(G3(:,:,:,119),wf(:,0),G3(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G2(:,:,:,124),wf(:,186),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,62),MT,G3(:,:,:,121))
  call loop_QS_A(G3(:,:,:,121),wf(:,0),G3(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,124),wf(:,65),G2(:,:,:,129))
  call loop_Q_A(G2(:,:,:,129),Q(:,46),MT,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,62),MT,G4(:,:,:,73))
  call loop_QS_A(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,124),wf(:,-4),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,50),MT,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,65),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,62),MT,G4(:,:,:,75))
  call loop_QS_A(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G3(:,:,:,125),wf(:,-3),G3(:,:,:,127))
  call loop_Q_A(G3(:,:,:,127),Q(:,58),MT,G4(:,:,:,77))
  call loop_QV_A(G4(:,:,:,77),wf(:,-2),G4(:,:,:,78))
  call loop_Q_A(G4(:,:,:,78),Q(:,62),MT,G5(:,:,:,37))
  call loop_QS_A(G5(:,:,:,37),wf(:,0),G5(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,38),Q(:,63),MT,G6tensor(:,19))
  call loop_QV_A(G3(:,:,:,125),wf(:,-2),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,54),MT,G4(:,:,:,79))
  call loop_QV_A(G4(:,:,:,79),wf(:,-3),G4(:,:,:,80))
  call loop_Q_A(G4(:,:,:,80),Q(:,62),MT,G5(:,:,:,39))
  call loop_QS_A(G5(:,:,:,39),wf(:,0),G5(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,40),Q(:,63),MT,G6tensor(:,20))
  call loop_QV_A(G2(:,:,:,124),wf(:,195),G2(:,:,:,131))
  call loop_Q_A(G2(:,:,:,131),Q(:,62),MT,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,0),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,124),wf(:,76),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,54),MT,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-3),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,62),MT,G4(:,:,:,81))
  call loop_QS_A(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,63),MT,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,124),wf(:,-3),G2(:,:,:,133))
  call loop_Q_A(G2(:,:,:,133),Q(:,42),MT,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,76),G3(:,:,:,134))
  call loop_Q_A(G3(:,:,:,134),Q(:,62),MT,G4(:,:,:,83))
  call loop_QS_A(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,63),MT,G5tensor(:,22))
  call loop_QV_A(G3(:,:,:,133),wf(:,-4),G3(:,:,:,135))
  call loop_Q_A(G3(:,:,:,135),Q(:,58),MT,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,-2),G4(:,:,:,86))
  call loop_Q_A(G4(:,:,:,86),Q(:,62),MT,G5(:,:,:,41))
  call loop_QS_A(G5(:,:,:,41),wf(:,0),G5(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,42),Q(:,63),MT,G6tensor(:,21))
  call loop_QV_A(G3(:,:,:,133),wf(:,-2),G3(:,:,:,136))
  call loop_Q_A(G3(:,:,:,136),Q(:,46),MT,G4(:,:,:,87))
  call loop_QV_A(G4(:,:,:,87),wf(:,-4),G4(:,:,:,88))
  call loop_Q_A(G4(:,:,:,88),Q(:,62),MT,G5(:,:,:,43))
  call loop_QS_A(G5(:,:,:,43),wf(:,0),G5(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,44),Q(:,63),MT,G6tensor(:,22))
  call loop_QV_A(G2(:,:,:,124),wf(:,199),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,62),MT,G3(:,:,:,137))
  call loop_QS_A(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,124),wf(:,101),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,58),MT,G3(:,:,:,139))
  call loop_QV_A(G3(:,:,:,139),wf(:,-2),G3(:,:,:,140))
  call loop_Q_A(G3(:,:,:,140),Q(:,62),MT,G4(:,:,:,89))
  call loop_QS_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,124),wf(:,-2),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,38),MT,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,101),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,62),MT,G4(:,:,:,91))
  call loop_QS_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,24))
  call loop_QV_A(G3(:,:,:,141),wf(:,-4),G3(:,:,:,143))
  call loop_Q_A(G3(:,:,:,143),Q(:,54),MT,G4(:,:,:,93))
  call loop_QV_A(G4(:,:,:,93),wf(:,-3),G4(:,:,:,94))
  call loop_Q_A(G4(:,:,:,94),Q(:,62),MT,G5(:,:,:,45))
  call loop_QS_A(G5(:,:,:,45),wf(:,0),G5(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,46),Q(:,63),MT,G6tensor(:,23))
  call loop_QV_A(G3(:,:,:,141),wf(:,-3),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,46),MT,G4(:,:,:,95))
  call loop_QV_A(G4(:,:,:,95),wf(:,-4),G4(:,:,:,96))
  call loop_Q_A(G4(:,:,:,96),Q(:,62),MT,G5(:,:,:,47))
  call loop_QS_A(G5(:,:,:,47),wf(:,0),G5(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,48),Q(:,63),MT,G6tensor(:,24))
  call loop_QV_A(G1(:,:,:,1),wf(:,381),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,137))
  call loop_QS_A(G2(:,:,:,137),wf(:,0),G2(:,:,:,138),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),MT,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,1),wf(:,119),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,50),MT,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,65),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,62),MT,G3(:,:,:,145))
  call loop_QS_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,139),wf(:,-3),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,58),MT,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,-2),G3(:,:,:,148))
  call loop_Q_A(G3(:,:,:,148),Q(:,62),MT,G4(:,:,:,97))
  call loop_QS_A(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,63),MT,G5tensor(:,25))
  call loop_QV_A(G2(:,:,:,139),wf(:,-2),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,54),MT,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-3),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,62),MT,G4(:,:,:,99))
  call loop_QS_A(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,63),MT,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,1),wf(:,65),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,14),MT,G2(:,:,:,143))
  call loop_QV_A(G2(:,:,:,143),wf(:,119),G2(:,:,:,144))
  call loop_Q_A(G2(:,:,:,144),Q(:,62),MT,G3(:,:,:,151))
  call loop_QS_A(G3(:,:,:,151),wf(:,0),G3(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,63),MT,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,143),wf(:,-5),G2(:,:,:,145))
  call loop_Q_A(G2(:,:,:,145),Q(:,46),MT,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-4),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,62),MT,G4(:,:,:,101))
  call loop_QS_A(G4(:,:,:,101),wf(:,0),G4(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,63),MT,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,143),wf(:,-4),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,30),MT,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,-5),G3(:,:,:,156))
  call loop_Q_A(G3(:,:,:,156),Q(:,62),MT,G4(:,:,:,103))
  call loop_QS_A(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,63),MT,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,1),wf(:,386),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,62),MT,G2(:,:,:,147))
  call loop_QS_A(G2(:,:,:,147),wf(:,0),G2(:,:,:,148),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,1),wf(:,186),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,30),MT,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,-5),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,62),MT,G3(:,:,:,157))
  call loop_QS_A(G3(:,:,:,157),wf(:,0),G3(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,63),MT,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,1),wf(:,387),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,62),MT,G2(:,:,:,151))
  call loop_QS_A(G2(:,:,:,151),wf(:,0),G2(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,1),wf(:,183),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,46),MT,G2(:,:,:,153))
  call loop_QV_A(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154))
  call loop_Q_A(G2(:,:,:,154),Q(:,62),MT,G3(:,:,:,159))
  call loop_QS_A(G3(:,:,:,159),wf(:,0),G3(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,63),MT,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,1),wf(:,397),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,62),MT,G2(:,:,:,155))
  call loop_QS_A(G2(:,:,:,155),wf(:,0),G2(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,1),wf(:,109),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,42),MT,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,76),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,62),MT,G3(:,:,:,161))
  call loop_QS_A(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,63),MT,G4tensor(:,41))
  call loop_QV_A(G2(:,:,:,157),wf(:,-4),G2(:,:,:,159))
  call loop_Q_A(G2(:,:,:,159),Q(:,58),MT,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,-2),G3(:,:,:,164))
  call loop_Q_A(G3(:,:,:,164),Q(:,62),MT,G4(:,:,:,105))
  call loop_QS_A(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,63),MT,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,157),wf(:,-2),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,46),MT,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-4),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,62),MT,G4(:,:,:,107))
  call loop_QS_A(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),MT,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,1),wf(:,76),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,22),MT,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,109),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,62),MT,G3(:,:,:,167))
  call loop_QS_A(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,42))
  call loop_QV_A(G2(:,:,:,161),wf(:,-5),G2(:,:,:,163))
  call loop_Q_A(G2(:,:,:,163),Q(:,54),MT,G3(:,:,:,169))
  call loop_QV_A(G3(:,:,:,169),wf(:,-3),G3(:,:,:,170))
  call loop_Q_A(G3(:,:,:,170),Q(:,62),MT,G4(:,:,:,109))
  call loop_QS_A(G4(:,:,:,109),wf(:,0),G4(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,63),MT,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,161),wf(:,-3),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,30),MT,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-5),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,62),MT,G4(:,:,:,111))
  call loop_QS_A(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,63),MT,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,1),wf(:,402),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,62),MT,G2(:,:,:,165))
  call loop_QS_A(G2(:,:,:,165),wf(:,0),G2(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,1),wf(:,195),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,30),MT,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,62),MT,G3(:,:,:,173))
  call loop_QS_A(G3(:,:,:,173),wf(:,0),G3(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,63),MT,G4tensor(:,43))
  call loop_QV_A(G1(:,:,:,1),wf(:,403),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,62),MT,G2(:,:,:,169))
  call loop_QS_A(G2(:,:,:,169),wf(:,0),G2(:,:,:,170),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,63),MT,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,1),wf(:,175),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,54),MT,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-3),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,62),MT,G3(:,:,:,175))
  call loop_QS_A(G3(:,:,:,175),wf(:,0),G3(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),MT,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,1),wf(:,405),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,173))
  call loop_QS_A(G2(:,:,:,173),wf(:,0),G2(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,1),wf(:,101),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,26),MT,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,84),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,62),MT,G3(:,:,:,177))
  call loop_QS_A(G3(:,:,:,177),wf(:,0),G3(:,:,:,178),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,63),MT,G4tensor(:,45))
  call loop_QV_A(G2(:,:,:,175),wf(:,-5),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,58),MT,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,-2),G3(:,:,:,180))
  call loop_Q_A(G3(:,:,:,180),Q(:,62),MT,G4(:,:,:,113))
  call loop_QS_A(G4(:,:,:,113),wf(:,0),G4(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,63),MT,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,175),wf(:,-2),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,30),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-5),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,62),MT,G4(:,:,:,115))
  call loop_QS_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,1),wf(:,84),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,38),MT,G2(:,:,:,179))
  call loop_QV_A(G2(:,:,:,179),wf(:,101),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,62),MT,G3(:,:,:,183))
  call loop_QS_A(G3(:,:,:,183),wf(:,0),G3(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,63),MT,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,179),wf(:,-4),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,54),MT,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,-3),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,62),MT,G4(:,:,:,117))
  call loop_QS_A(G4(:,:,:,117),wf(:,0),G4(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,63),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,179),wf(:,-3),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,46),MT,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,-4),G3(:,:,:,188))
  call loop_Q_A(G3(:,:,:,188),Q(:,62),MT,G4(:,:,:,119))
  call loop_QS_A(G4(:,:,:,119),wf(:,0),G4(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,63),MT,G5tensor(:,36))
  call loop_QV_A(G1(:,:,:,1),wf(:,410),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,62),MT,G2(:,:,:,183))
  call loop_QS_A(G2(:,:,:,183),wf(:,0),G2(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,184),Q(:,63),MT,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,1),wf(:,199),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,30),MT,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-5),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,62),MT,G3(:,:,:,189))
  call loop_QS_A(G3(:,:,:,189),wf(:,0),G3(:,:,:,190),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,1),wf(:,411),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,62),MT,G2(:,:,:,187))
  call loop_QS_A(G2(:,:,:,187),wf(:,0),G2(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,1),wf(:,166),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,58),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-2),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,62),MT,G3(:,:,:,191))
  call loop_QS_A(G3(:,:,:,191),wf(:,0),G3(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,63),MT,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,1),wf(:,422),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,191))
  call loop_QS_A(G2(:,:,:,191),wf(:,0),G2(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,1),wf(:,191),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,46),MT,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,-4),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,62),MT,G3(:,:,:,193))
  call loop_QS_A(G3(:,:,:,193),wf(:,0),G3(:,:,:,194),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,63),MT,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,1),wf(:,423),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,62),MT,G2(:,:,:,195))
  call loop_QS_A(G2(:,:,:,195),wf(:,0),G2(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,41))
  call loop_QV_A(G1(:,:,:,1),wf(:,178),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,54),MT,G2(:,:,:,197))
  call loop_QV_A(G2(:,:,:,197),wf(:,-3),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,62),MT,G3(:,:,:,195))
  call loop_QS_A(G3(:,:,:,195),wf(:,0),G3(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,63),MT,G4tensor(:,50))
  call loop_QV_A(G1(:,:,:,1),wf(:,428),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,199))
  call loop_QS_A(G2(:,:,:,199),wf(:,0),G2(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G1(:,:,:,1),wf(:,193),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,46),MT,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-4),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,62),MT,G3(:,:,:,197))
  call loop_QS_A(G3(:,:,:,197),wf(:,0),G3(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,63),MT,G4tensor(:,51))
  call loop_QV_A(G1(:,:,:,1),wf(:,429),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,62),MT,G2(:,:,:,203))
  call loop_QS_A(G2(:,:,:,203),wf(:,0),G2(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,1),wf(:,169),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,58),MT,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-2),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,62),MT,G3(:,:,:,199))
  call loop_QS_A(G3(:,:,:,199),wf(:,0),G3(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,63),MT,G4tensor(:,52))
  call loop_QV_A(G1(:,:,:,1),wf(:,434),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,0),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,1),wf(:,435),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,209))
  call loop_QS_A(G2(:,:,:,209),wf(:,0),G2(:,:,:,210),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,210),Q(:,63),MT,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,1),wf(:,180),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,54),MT,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-3),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,62),MT,G3(:,:,:,201))
  call loop_QS_A(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,1),wf(:,171),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,58),MT,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,-2),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,62),MT,G3(:,:,:,203))
  call loop_QS_A(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,247),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,30),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,62),MT,G2(:,:,:,215))
  call loop_QS_A(G2(:,:,:,215),wf(:,0),G2(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,248),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,30),MT,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,-5),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,62),MT,G2(:,:,:,217))
  call loop_QS_A(G2(:,:,:,217),wf(:,0),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,249),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,219))
  call loop_QS_A(G2(:,:,:,219),wf(:,0),G2(:,:,:,220),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,247),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,30),MT,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,-5),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,62),MT,G2(:,:,:,221))
  call loop_AS_Q(G2(:,:,:,221),wf(:,0),G2(:,:,:,222),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,222),Q(:,63),MT,G3tensor(:,49))
  call loop_AV_Q(G0(:,:,:,1),wf(:,248),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,30),MT,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-5),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,223))
  call loop_AS_Q(G2(:,:,:,223),wf(:,0),G2(:,:,:,224),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,249),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,30),MT,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-5),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,62),MT,G2(:,:,:,225))
  call loop_AS_Q(G2(:,:,:,225),wf(:,0),G2(:,:,:,226),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,93))
  call loop_AV_Q(G1(:,:,:,93),wf(:,19),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,227))
  call loop_AS_Q(G2(:,:,:,227),wf(:,0),G2(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,63),MT,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,93),wf(:,21),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,62),MT,G2(:,:,:,229))
  call loop_AS_Q(G2(:,:,:,229),wf(:,0),G2(:,:,:,230),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,230),Q(:,63),MT,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,93),wf(:,22),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,231))
  call loop_AS_Q(G2(:,:,:,231),wf(:,0),G2(:,:,:,232),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,63),MT,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,93),wf(:,175),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,62),MT,G2(:,:,:,233))
  call loop_AS_Q(G2(:,:,:,233),wf(:,0),G2(:,:,:,234),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,234),Q(:,63),MT,G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,93),wf(:,76),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,30),MT,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-5),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,62),MT,G3(:,:,:,205))
  call loop_AS_Q(G3(:,:,:,205),wf(:,0),G3(:,:,:,206),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-5),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,42),MT,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,76),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,62),MT,G3(:,:,:,207))
  call loop_AS_Q(G3(:,:,:,207),wf(:,0),G3(:,:,:,208),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-2),G2(:,:,:,239))
  call loop_A_Q(G2(:,:,:,239),Q(:,46),MT,G3(:,:,:,209))
  call loop_AV_Q(G3(:,:,:,209),wf(:,-4),G3(:,:,:,210))
  call loop_A_Q(G3(:,:,:,210),Q(:,62),MT,G4(:,:,:,121))
  call loop_AS_Q(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,63),MT,G5tensor(:,37))
  call loop_AV_Q(G1(:,:,:,93),wf(:,178),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MT,G2(:,:,:,240))
  call loop_AS_Q(G2(:,:,:,240),wf(:,0),G2(:,:,:,241),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,241),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,93),wf(:,84),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,46),MT,G2(:,:,:,242))
  call loop_AV_Q(G2(:,:,:,242),wf(:,-4),G2(:,:,:,243))
  call loop_A_Q(G2(:,:,:,243),Q(:,62),MT,G3(:,:,:,211))
  call loop_AS_Q(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-4),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,26),MT,G2(:,:,:,244))
  call loop_AV_Q(G2(:,:,:,244),wf(:,84),G2(:,:,:,245))
  call loop_A_Q(G2(:,:,:,245),Q(:,62),MT,G3(:,:,:,213))
  call loop_AS_Q(G3(:,:,:,213),wf(:,0),G3(:,:,:,214),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,63),MT,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,244),wf(:,-2),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,30),MT,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-5),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,62),MT,G4(:,:,:,123))
  call loop_AS_Q(G4(:,:,:,123),wf(:,0),G4(:,:,:,124),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,63),MT,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,93),wf(:,180),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,62),MT,G2(:,:,:,247))
  call loop_AS_Q(G2(:,:,:,247),wf(:,0),G2(:,:,:,248),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-2),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,14),MT,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,119),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,62),MT,G3(:,:,:,217))
  call loop_AS_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,63),MT,G4tensor(:,59))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-5),G2(:,:,:,251))
  call loop_A_Q(G2(:,:,:,251),Q(:,46),MT,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-4),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,62),MT,G4(:,:,:,125))
  call loop_AS_Q(G4(:,:,:,125),wf(:,0),G4(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,63),MT,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-4),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,30),MT,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-5),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,62),MT,G4(:,:,:,127))
  call loop_AS_Q(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,63),MT,G5tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,10),MT,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,19),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,62),MT,G2(:,:,:,253))
  call loop_QS_A(G2(:,:,:,253),wf(:,0),G2(:,:,:,254),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,254),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,105),wf(:,21),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,255))
  call loop_QS_A(G2(:,:,:,255),wf(:,0),G2(:,:,:,256),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,105),wf(:,22),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,62),MT,G2(:,:,:,257))
  call loop_QS_A(G2(:,:,:,257),wf(:,0),G2(:,:,:,258),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,258),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,105),wf(:,175),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,62),MT,G2(:,:,:,259))
  call loop_QS_A(G2(:,:,:,259),wf(:,0),G2(:,:,:,260),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,105),wf(:,76),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,30),MT,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,-5),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,62),MT,G3(:,:,:,223))
  call loop_QS_A(G3(:,:,:,223),wf(:,0),G3(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,63),MT,G4tensor(:,60))
  call loop_QV_A(G1(:,:,:,105),wf(:,-5),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,42),MT,G2(:,:,:,263))
  call loop_QV_A(G2(:,:,:,263),wf(:,76),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,62),MT,G3(:,:,:,225))
  call loop_QS_A(G3(:,:,:,225),wf(:,0),G3(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,63),MT,G4tensor(:,61))
  call loop_QV_A(G2(:,:,:,263),wf(:,-2),G2(:,:,:,265))
  call loop_Q_A(G2(:,:,:,265),Q(:,46),MT,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-4),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,62),MT,G4(:,:,:,129))
  call loop_QS_A(G4(:,:,:,129),wf(:,0),G4(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,63),MT,G5tensor(:,41))
  call loop_QV_A(G1(:,:,:,105),wf(:,178),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,266))
  call loop_QS_A(G2(:,:,:,266),wf(:,0),G2(:,:,:,267),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,105),wf(:,84),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,46),MT,G2(:,:,:,268))
  call loop_QV_A(G2(:,:,:,268),wf(:,-4),G2(:,:,:,269))
  call loop_Q_A(G2(:,:,:,269),Q(:,62),MT,G3(:,:,:,229))
  call loop_QS_A(G3(:,:,:,229),wf(:,0),G3(:,:,:,230),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,63),MT,G4tensor(:,62))
  call loop_QV_A(G1(:,:,:,105),wf(:,-4),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,26),MT,G2(:,:,:,270))
  call loop_QV_A(G2(:,:,:,270),wf(:,84),G2(:,:,:,271))
  call loop_Q_A(G2(:,:,:,271),Q(:,62),MT,G3(:,:,:,231))
  call loop_QS_A(G3(:,:,:,231),wf(:,0),G3(:,:,:,232),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,270),wf(:,-2),G2(:,:,:,272))
  call loop_Q_A(G2(:,:,:,272),Q(:,30),MT,G3(:,:,:,233))
  call loop_QV_A(G3(:,:,:,233),wf(:,-5),G3(:,:,:,234))
  call loop_Q_A(G3(:,:,:,234),Q(:,62),MT,G4(:,:,:,131))
  call loop_QS_A(G4(:,:,:,131),wf(:,0),G4(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,63),MT,G5tensor(:,42))
  call loop_QV_A(G1(:,:,:,105),wf(:,180),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,62),MT,G2(:,:,:,273))
  call loop_QS_A(G2(:,:,:,273),wf(:,0),G2(:,:,:,274),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,274),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,105),wf(:,-2),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,14),MT,G2(:,:,:,275))
  call loop_QV_A(G2(:,:,:,275),wf(:,119),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,62),MT,G3(:,:,:,235))
  call loop_QS_A(G3(:,:,:,235),wf(:,0),G3(:,:,:,236),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,275),wf(:,-5),G2(:,:,:,277))
  call loop_Q_A(G2(:,:,:,277),Q(:,46),MT,G3(:,:,:,237))
  call loop_QV_A(G3(:,:,:,237),wf(:,-4),G3(:,:,:,238))
  call loop_Q_A(G3(:,:,:,238),Q(:,62),MT,G4(:,:,:,133))
  call loop_QS_A(G4(:,:,:,133),wf(:,0),G4(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,63),MT,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,275),wf(:,-4),G2(:,:,:,278))
  call loop_Q_A(G2(:,:,:,278),Q(:,30),MT,G3(:,:,:,239))
  call loop_QV_A(G3(:,:,:,239),wf(:,-5),G3(:,:,:,240))
  call loop_Q_A(G3(:,:,:,240),Q(:,62),MT,G4(:,:,:,135))
  call loop_QS_A(G4(:,:,:,135),wf(:,0),G4(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,63),MT,G5tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,268),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,30),MT,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,62),MT,G2(:,:,:,279))
  call loop_QS_A(G2(:,:,:,279),wf(:,0),G2(:,:,:,280),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,269),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,30),MT,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,62),MT,G2(:,:,:,281))
  call loop_QS_A(G2(:,:,:,281),wf(:,0),G2(:,:,:,282),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,270),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,30),MT,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,62),MT,G2(:,:,:,283))
  call loop_QS_A(G2(:,:,:,283),wf(:,0),G2(:,:,:,284),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,284),Q(:,63),MT,G3tensor(:,66))
  call loop_AV_Q(G0(:,:,:,1),wf(:,268),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,30),MT,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,-5),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,285))
  call loop_AS_Q(G2(:,:,:,285),wf(:,0),G2(:,:,:,286),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,63),MT,G3tensor(:,67))
  call loop_AV_Q(G0(:,:,:,1),wf(:,269),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,30),MT,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,62),MT,G2(:,:,:,287))
  call loop_AS_Q(G2(:,:,:,287),wf(:,0),G2(:,:,:,288),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G0(:,:,:,1),wf(:,270),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,30),MT,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,289))
  call loop_AS_Q(G2(:,:,:,289),wf(:,0),G2(:,:,:,290),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,69))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,18),MT,G1(:,:,:,129))
  call loop_AV_Q(G1(:,:,:,129),wf(:,30),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,62),MT,G2(:,:,:,291))
  call loop_AS_Q(G2(:,:,:,291),wf(:,0),G2(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G1(:,:,:,129),wf(:,32),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),MT,G2(:,:,:,293))
  call loop_AS_Q(G2(:,:,:,293),wf(:,0),G2(:,:,:,294),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,71))
  call loop_AV_Q(G1(:,:,:,129),wf(:,33),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,62),MT,G2(:,:,:,295))
  call loop_AS_Q(G2(:,:,:,295),wf(:,0),G2(:,:,:,296),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G1(:,:,:,129),wf(:,183),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,62),MT,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,0),G2(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,129),wf(:,65),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,30),MT,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-5),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,62),MT,G3(:,:,:,241))
  call loop_AS_Q(G3(:,:,:,241),wf(:,0),G3(:,:,:,242),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,63),MT,G4tensor(:,65))
  call loop_AV_Q(G1(:,:,:,129),wf(:,191),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,62),MT,G2(:,:,:,301))
  call loop_AS_Q(G2(:,:,:,301),wf(:,0),G2(:,:,:,302),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,63),MT,G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-3),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,26),MT,G2(:,:,:,303))
  call loop_AV_Q(G2(:,:,:,303),wf(:,84),G2(:,:,:,304))
  call loop_A_Q(G2(:,:,:,304),Q(:,62),MT,G3(:,:,:,243))
  call loop_AS_Q(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,63),MT,G4tensor(:,66))
  call loop_AV_Q(G2(:,:,:,303),wf(:,-2),G2(:,:,:,305))
  call loop_A_Q(G2(:,:,:,305),Q(:,30),MT,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-5),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,62),MT,G4(:,:,:,137))
  call loop_AS_Q(G4(:,:,:,137),wf(:,0),G4(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,63),MT,G5tensor(:,45))
  call loop_AV_Q(G1(:,:,:,129),wf(:,193),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,62),MT,G2(:,:,:,306))
  call loop_AS_Q(G2(:,:,:,306),wf(:,0),G2(:,:,:,307),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,307),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-2),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,22),MT,G2(:,:,:,308))
  call loop_AV_Q(G2(:,:,:,308),wf(:,109),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,62),MT,G3(:,:,:,247))
  call loop_AS_Q(G3(:,:,:,247),wf(:,0),G3(:,:,:,248),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,63),MT,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,308),wf(:,-3),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,30),MT,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,-5),G3(:,:,:,250))
  call loop_A_Q(G3(:,:,:,250),Q(:,62),MT,G4(:,:,:,139))
  call loop_AS_Q(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,63),MT,G5tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,18),MT,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,30),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,62),MT,G2(:,:,:,311))
  call loop_QS_A(G2(:,:,:,311),wf(:,0),G2(:,:,:,312),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,63),MT,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,139),wf(:,32),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,62),MT,G2(:,:,:,313))
  call loop_QS_A(G2(:,:,:,313),wf(:,0),G2(:,:,:,314),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,314),Q(:,63),MT,G3tensor(:,77))
  call loop_QV_A(G1(:,:,:,139),wf(:,33),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,62),MT,G2(:,:,:,315))
  call loop_QS_A(G2(:,:,:,315),wf(:,0),G2(:,:,:,316),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,316),Q(:,63),MT,G3tensor(:,78))
  call loop_QV_A(G1(:,:,:,139),wf(:,183),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,62),MT,G2(:,:,:,317))
  call loop_QS_A(G2(:,:,:,317),wf(:,0),G2(:,:,:,318),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,318),Q(:,63),MT,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,139),wf(:,65),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,30),MT,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,62),MT,G3(:,:,:,251))
  call loop_QS_A(G3(:,:,:,251),wf(:,0),G3(:,:,:,252),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,63),MT,G4tensor(:,68))
  call loop_QV_A(G1(:,:,:,139),wf(:,191),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,62),MT,G2(:,:,:,321))
  call loop_QS_A(G2(:,:,:,321),wf(:,0),G2(:,:,:,322),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,322),Q(:,63),MT,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,139),wf(:,-3),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,26),MT,G2(:,:,:,323))
  call loop_QV_A(G2(:,:,:,323),wf(:,84),G2(:,:,:,324))
  call loop_Q_A(G2(:,:,:,324),Q(:,62),MT,G3(:,:,:,253))
  call loop_QS_A(G3(:,:,:,253),wf(:,0),G3(:,:,:,254),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,63),MT,G4tensor(:,69))
  call loop_QV_A(G2(:,:,:,323),wf(:,-2),G2(:,:,:,325))
  call loop_Q_A(G2(:,:,:,325),Q(:,30),MT,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-5),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,62),MT,G4(:,:,:,141))
  call loop_QS_A(G4(:,:,:,141),wf(:,0),G4(:,:,:,142),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,63),MT,G5tensor(:,47))
  call loop_QV_A(G1(:,:,:,139),wf(:,193),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,62),MT,G2(:,:,:,326))
  call loop_QS_A(G2(:,:,:,326),wf(:,0),G2(:,:,:,327),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,327),Q(:,63),MT,G3tensor(:,81))
  call loop_QV_A(G1(:,:,:,139),wf(:,-2),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,22),MT,G2(:,:,:,328))
  call loop_QV_A(G2(:,:,:,328),wf(:,109),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,62),MT,G3(:,:,:,257))
  call loop_QS_A(G3(:,:,:,257),wf(:,0),G3(:,:,:,258),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,63),MT,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,328),wf(:,-3),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,30),MT,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,-5),G3(:,:,:,260))
  call loop_Q_A(G3(:,:,:,260),Q(:,62),MT,G4(:,:,:,143))
  call loop_QS_A(G4(:,:,:,143),wf(:,0),G4(:,:,:,144),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,63),MT,G5tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,28),MT,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,37),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,62),MT,G2(:,:,:,331))
  call loop_QS_A(G2(:,:,:,331),wf(:,0),G2(:,:,:,332),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,332),Q(:,63),MT,G3tensor(:,82))
  call loop_QV_A(G1(:,:,:,149),wf(:,-1),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,30),MT,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,-5),G2(:,:,:,334))
  call loop_Q_A(G2(:,:,:,334),Q(:,62),MT,G3(:,:,:,261))
  call loop_QS_A(G3(:,:,:,261),wf(:,0),G3(:,:,:,262),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,63),MT,G4tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,28),MT,G1(:,:,:,152))
  call loop_QV_A(G1(:,:,:,152),wf(:,37),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,62),MT,G2(:,:,:,335))
  call loop_QS_A(G2(:,:,:,335),wf(:,0),G2(:,:,:,336),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,336),Q(:,63),MT,G3tensor(:,83))
  call loop_QV_A(G1(:,:,:,152),wf(:,-1),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,30),MT,G2(:,:,:,337))
  call loop_QV_A(G2(:,:,:,337),wf(:,-5),G2(:,:,:,338))
  call loop_Q_A(G2(:,:,:,338),Q(:,62),MT,G3(:,:,:,263))
  call loop_QS_A(G3(:,:,:,263),wf(:,0),G3(:,:,:,264),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,264),Q(:,63),MT,G4tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,28),MT,G1(:,:,:,155))
  call loop_QV_A(G1(:,:,:,155),wf(:,37),G1(:,:,:,156))
  call loop_Q_A(G1(:,:,:,156),Q(:,62),MT,G2(:,:,:,339))
  call loop_QS_A(G2(:,:,:,339),wf(:,0),G2(:,:,:,340),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,63),MT,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,155),wf(:,-1),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,30),MT,G2(:,:,:,341))
  call loop_QV_A(G2(:,:,:,341),wf(:,-5),G2(:,:,:,342))
  call loop_Q_A(G2(:,:,:,342),Q(:,62),MT,G3(:,:,:,265))
  call loop_QS_A(G3(:,:,:,265),wf(:,0),G3(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,63),MT,G4tensor(:,73))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,28),MT,G1(:,:,:,158))
  call loop_AV_Q(G1(:,:,:,158),wf(:,37),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,62),MT,G2(:,:,:,343))
  call loop_AS_Q(G2(:,:,:,343),wf(:,0),G2(:,:,:,344),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,344),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,158),wf(:,-1),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,30),MT,G2(:,:,:,345))
  call loop_AV_Q(G2(:,:,:,345),wf(:,-5),G2(:,:,:,346))
  call loop_A_Q(G2(:,:,:,346),Q(:,62),MT,G3(:,:,:,267))
  call loop_AS_Q(G3(:,:,:,267),wf(:,0),G3(:,:,:,268),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,63),MT,G4tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,40),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,28),MT,G1(:,:,:,161))
  call loop_AV_Q(G1(:,:,:,161),wf(:,37),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,62),MT,G2(:,:,:,347))
  call loop_AS_Q(G2(:,:,:,347),wf(:,0),G2(:,:,:,348),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,348),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,161),wf(:,-1),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,30),MT,G2(:,:,:,349))
  call loop_AV_Q(G2(:,:,:,349),wf(:,-5),G2(:,:,:,350))
  call loop_A_Q(G2(:,:,:,350),Q(:,62),MT,G3(:,:,:,269))
  call loop_AS_Q(G3(:,:,:,269),wf(:,0),G3(:,:,:,270),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,63),MT,G4tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,28),MT,G1(:,:,:,164))
  call loop_AV_Q(G1(:,:,:,164),wf(:,37),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,62),MT,G2(:,:,:,351))
  call loop_AS_Q(G2(:,:,:,351),wf(:,0),G2(:,:,:,352),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,352),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,164),wf(:,-1),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,30),MT,G2(:,:,:,353))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-5),G2(:,:,:,354))
  call loop_A_Q(G2(:,:,:,354),Q(:,62),MT,G3(:,:,:,271))
  call loop_AS_Q(G3(:,:,:,271),wf(:,0),G3(:,:,:,272),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,63),MT,G4tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,283),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,30),MT,G1(:,:,:,167))
  call loop_QV_A(G1(:,:,:,167),wf(:,-5),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,62),MT,G2(:,:,:,355))
  call loop_QS_A(G2(:,:,:,355),wf(:,0),G2(:,:,:,356),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,356),Q(:,63),MT,G3tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,284),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,30),MT,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,62),MT,G2(:,:,:,357))
  call loop_QS_A(G2(:,:,:,357),wf(:,0),G2(:,:,:,358),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,358),Q(:,63),MT,G3tensor(:,89))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,30),MT,G1(:,:,:,171))
  call loop_QV_A(G1(:,:,:,171),wf(:,-5),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,62),MT,G2(:,:,:,359))
  call loop_QS_A(G2(:,:,:,359),wf(:,0),G2(:,:,:,360),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,63),MT,G3tensor(:,90))
  call loop_AV_Q(G0(:,:,:,1),wf(:,283),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,30),MT,G1(:,:,:,173))
  call loop_AV_Q(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,62),MT,G2(:,:,:,361))
  call loop_AS_Q(G2(:,:,:,361),wf(:,0),G2(:,:,:,362),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,362),Q(:,63),MT,G3tensor(:,91))
  call loop_AV_Q(G0(:,:,:,1),wf(:,284),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,30),MT,G1(:,:,:,175))
  call loop_AV_Q(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,62),MT,G2(:,:,:,363))
  call loop_AS_Q(G2(:,:,:,363),wf(:,0),G2(:,:,:,364),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,364),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G0(:,:,:,1),wf(:,285),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,30),MT,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,62),MT,G2(:,:,:,365))
  call loop_AS_Q(G2(:,:,:,365),wf(:,0),G2(:,:,:,366),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,366),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G0(:,:,:,1),wf(:,292),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,30),MT,G1(:,:,:,179))
  call loop_QV_A(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,62),MT,G2(:,:,:,367))
  call loop_QS_A(G2(:,:,:,367),wf(:,0),G2(:,:,:,368),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,368),Q(:,63),MT,G3tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,293),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,30),MT,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,62),MT,G2(:,:,:,369))
  call loop_QS_A(G2(:,:,:,369),wf(:,0),G2(:,:,:,370),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,370),Q(:,63),MT,G3tensor(:,95))
  call loop_QV_A(G0(:,:,:,1),wf(:,294),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,30),MT,G1(:,:,:,183))
  call loop_QV_A(G1(:,:,:,183),wf(:,-5),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,62),MT,G2(:,:,:,371))
  call loop_QS_A(G2(:,:,:,371),wf(:,0),G2(:,:,:,372),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,372),Q(:,63),MT,G3tensor(:,96))
  call loop_AV_Q(G0(:,:,:,1),wf(:,292),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,30),MT,G1(:,:,:,185))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-5),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,62),MT,G2(:,:,:,373))
  call loop_AS_Q(G2(:,:,:,373),wf(:,0),G2(:,:,:,374),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,374),Q(:,63),MT,G3tensor(:,97))
  call loop_AV_Q(G0(:,:,:,1),wf(:,293),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,30),MT,G1(:,:,:,187))
  call loop_AV_Q(G1(:,:,:,187),wf(:,-5),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,62),MT,G2(:,:,:,375))
  call loop_AS_Q(G2(:,:,:,375),wf(:,0),G2(:,:,:,376),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,376),Q(:,63),MT,G3tensor(:,98))
  call loop_AV_Q(G0(:,:,:,1),wf(:,294),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,30),MT,G1(:,:,:,189))
  call loop_AV_Q(G1(:,:,:,189),wf(:,-5),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,62),MT,G2(:,:,:,377))
  call loop_AS_Q(G2(:,:,:,377),wf(:,0),G2(:,:,:,378),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,378),Q(:,63),MT,G3tensor(:,99))
  call loop_AV_Q(G0(:,:,:,1),wf(:,65),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,12),MT,G1(:,:,:,191))
  call loop_AV_Q(G1(:,:,:,191),wf(:,66),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,379))
  call loop_AS_Q(G2(:,:,:,379),wf(:,0),G2(:,:,:,380),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,380),Q(:,63),MT,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,191),wf(:,68),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,62),MT,G2(:,:,:,381))
  call loop_AS_Q(G2(:,:,:,381),wf(:,0),G2(:,:,:,382),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,382),Q(:,63),MT,G3tensor(:,101))
  call loop_AV_Q(G1(:,:,:,191),wf(:,69),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,62),MT,G2(:,:,:,383))
  call loop_AS_Q(G2(:,:,:,383),wf(:,0),G2(:,:,:,384),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,384),Q(:,63),MT,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,191),wf(:,184),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,62),MT,G2(:,:,:,385))
  call loop_AS_Q(G2(:,:,:,385),wf(:,0),G2(:,:,:,386),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,386),Q(:,63),MT,G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,191),wf(:,29),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,30),MT,G2(:,:,:,387))
  call loop_AV_Q(G2(:,:,:,387),wf(:,-5),G2(:,:,:,388))
  call loop_A_Q(G2(:,:,:,388),Q(:,62),MT,G3(:,:,:,273))
  call loop_AS_Q(G3(:,:,:,273),wf(:,0),G3(:,:,:,274),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,63),MT,G4tensor(:,77))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-5),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,44),MT,G2(:,:,:,389))
  call loop_AV_Q(G2(:,:,:,389),wf(:,29),G2(:,:,:,390))
  call loop_A_Q(G2(:,:,:,390),Q(:,62),MT,G3(:,:,:,275))
  call loop_AS_Q(G3(:,:,:,275),wf(:,0),G3(:,:,:,276),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,63),MT,G4tensor(:,78))
  call loop_AV_Q(G2(:,:,:,389),wf(:,-1),G2(:,:,:,391))
  call loop_A_Q(G2(:,:,:,391),Q(:,46),MT,G3(:,:,:,277))
  call loop_AV_Q(G3(:,:,:,277),wf(:,-4),G3(:,:,:,278))
  call loop_A_Q(G3(:,:,:,278),Q(:,62),MT,G4(:,:,:,145))
  call loop_AS_Q(G4(:,:,:,145),wf(:,0),G4(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,63),MT,G5tensor(:,49))
  call loop_AV_Q(G1(:,:,:,191),wf(:,187),G1(:,:,:,198))
  call loop_A_Q(G1(:,:,:,198),Q(:,62),MT,G2(:,:,:,392))
  call loop_AS_Q(G2(:,:,:,392),wf(:,0),G2(:,:,:,393),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,393),Q(:,63),MT,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,191),wf(:,37),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,46),MT,G2(:,:,:,394))
  call loop_AV_Q(G2(:,:,:,394),wf(:,-4),G2(:,:,:,395))
  call loop_A_Q(G2(:,:,:,395),Q(:,62),MT,G3(:,:,:,279))
  call loop_AS_Q(G3(:,:,:,279),wf(:,0),G3(:,:,:,280),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,63),MT,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-4),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,28),MT,G2(:,:,:,396))
  call loop_AV_Q(G2(:,:,:,396),wf(:,37),G2(:,:,:,397))
  call loop_A_Q(G2(:,:,:,397),Q(:,62),MT,G3(:,:,:,281))
  call loop_AS_Q(G3(:,:,:,281),wf(:,0),G3(:,:,:,282),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,63),MT,G4tensor(:,80))
  call loop_AV_Q(G2(:,:,:,396),wf(:,-1),G2(:,:,:,398))
  call loop_A_Q(G2(:,:,:,398),Q(:,30),MT,G3(:,:,:,283))
  call loop_AV_Q(G3(:,:,:,283),wf(:,-5),G3(:,:,:,284))
  call loop_A_Q(G3(:,:,:,284),Q(:,62),MT,G4(:,:,:,147))
  call loop_AS_Q(G4(:,:,:,147),wf(:,0),G4(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,63),MT,G5tensor(:,50))
  call loop_AV_Q(G1(:,:,:,191),wf(:,188),G1(:,:,:,201))
  call loop_A_Q(G1(:,:,:,201),Q(:,62),MT,G2(:,:,:,399))
  call loop_AS_Q(G2(:,:,:,399),wf(:,0),G2(:,:,:,400),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,400),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-1),G1(:,:,:,202))
  call loop_A_Q(G1(:,:,:,202),Q(:,14),MT,G2(:,:,:,401))
  call loop_AV_Q(G2(:,:,:,401),wf(:,119),G2(:,:,:,402))
  call loop_A_Q(G2(:,:,:,402),Q(:,62),MT,G3(:,:,:,285))
  call loop_AS_Q(G3(:,:,:,285),wf(:,0),G3(:,:,:,286),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,286),Q(:,63),MT,G4tensor(:,81))
  call loop_AV_Q(G2(:,:,:,401),wf(:,-5),G2(:,:,:,403))
  call loop_A_Q(G2(:,:,:,403),Q(:,46),MT,G3(:,:,:,287))
  call loop_AV_Q(G3(:,:,:,287),wf(:,-4),G3(:,:,:,288))
  call loop_A_Q(G3(:,:,:,288),Q(:,62),MT,G4(:,:,:,149))
  call loop_AS_Q(G4(:,:,:,149),wf(:,0),G4(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,63),MT,G5tensor(:,51))
  call loop_AV_Q(G2(:,:,:,401),wf(:,-4),G2(:,:,:,404))
  call loop_A_Q(G2(:,:,:,404),Q(:,30),MT,G3(:,:,:,289))
  call loop_AV_Q(G3(:,:,:,289),wf(:,-5),G3(:,:,:,290))
  call loop_A_Q(G3(:,:,:,290),Q(:,62),MT,G4(:,:,:,151))
  call loop_AS_Q(G4(:,:,:,151),wf(:,0),G4(:,:,:,152),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,63),MT,G5tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,12),MT,G1(:,:,:,203))
  call loop_QV_A(G1(:,:,:,203),wf(:,66),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,62),MT,G2(:,:,:,405))
  call loop_QS_A(G2(:,:,:,405),wf(:,0),G2(:,:,:,406),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,406),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G1(:,:,:,203),wf(:,68),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,62),MT,G2(:,:,:,407))
  call loop_QS_A(G2(:,:,:,407),wf(:,0),G2(:,:,:,408),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,408),Q(:,63),MT,G3tensor(:,107))
  call loop_QV_A(G1(:,:,:,203),wf(:,69),G1(:,:,:,206))
  call loop_Q_A(G1(:,:,:,206),Q(:,62),MT,G2(:,:,:,409))
  call loop_QS_A(G2(:,:,:,409),wf(:,0),G2(:,:,:,410),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,410),Q(:,63),MT,G3tensor(:,108))
  call loop_QV_A(G1(:,:,:,203),wf(:,184),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,62),MT,G2(:,:,:,411))
  call loop_QS_A(G2(:,:,:,411),wf(:,0),G2(:,:,:,412),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,412),Q(:,63),MT,G3tensor(:,109))
  call loop_QV_A(G1(:,:,:,203),wf(:,29),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,30),MT,G2(:,:,:,413))
  call loop_QV_A(G2(:,:,:,413),wf(:,-5),G2(:,:,:,414))
  call loop_Q_A(G2(:,:,:,414),Q(:,62),MT,G3(:,:,:,291))
  call loop_QS_A(G3(:,:,:,291),wf(:,0),G3(:,:,:,292),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,292),Q(:,63),MT,G4tensor(:,82))
  call loop_QV_A(G1(:,:,:,203),wf(:,-5),G1(:,:,:,209))
  call loop_Q_A(G1(:,:,:,209),Q(:,44),MT,G2(:,:,:,415))
  call loop_QV_A(G2(:,:,:,415),wf(:,29),G2(:,:,:,416))
  call loop_Q_A(G2(:,:,:,416),Q(:,62),MT,G3(:,:,:,293))
  call loop_QS_A(G3(:,:,:,293),wf(:,0),G3(:,:,:,294),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,294),Q(:,63),MT,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,415),wf(:,-1),G2(:,:,:,417))
  call loop_Q_A(G2(:,:,:,417),Q(:,46),MT,G3(:,:,:,295))
  call loop_QV_A(G3(:,:,:,295),wf(:,-4),G3(:,:,:,296))
  call loop_Q_A(G3(:,:,:,296),Q(:,62),MT,G4(:,:,:,153))
  call loop_QS_A(G4(:,:,:,153),wf(:,0),G4(:,:,:,154),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,154),Q(:,63),MT,G5tensor(:,53))
  call loop_QV_A(G1(:,:,:,203),wf(:,187),G1(:,:,:,210))
  call loop_Q_A(G1(:,:,:,210),Q(:,62),MT,G2(:,:,:,418))
  call loop_QS_A(G2(:,:,:,418),wf(:,0),G2(:,:,:,419),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,419),Q(:,63),MT,G3tensor(:,110))
  call loop_QV_A(G1(:,:,:,203),wf(:,37),G1(:,:,:,211))
  call loop_Q_A(G1(:,:,:,211),Q(:,46),MT,G2(:,:,:,420))
  call loop_QV_A(G2(:,:,:,420),wf(:,-4),G2(:,:,:,421))
  call loop_Q_A(G2(:,:,:,421),Q(:,62),MT,G3(:,:,:,297))
  call loop_QS_A(G3(:,:,:,297),wf(:,0),G3(:,:,:,298),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,298),Q(:,63),MT,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,203),wf(:,-4),G1(:,:,:,212))
  call loop_Q_A(G1(:,:,:,212),Q(:,28),MT,G2(:,:,:,422))
  call loop_QV_A(G2(:,:,:,422),wf(:,37),G2(:,:,:,423))
  call loop_Q_A(G2(:,:,:,423),Q(:,62),MT,G3(:,:,:,299))
  call loop_QS_A(G3(:,:,:,299),wf(:,0),G3(:,:,:,300),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,300),Q(:,63),MT,G4tensor(:,85))
  call loop_QV_A(G2(:,:,:,422),wf(:,-1),G2(:,:,:,424))
  call loop_Q_A(G2(:,:,:,424),Q(:,30),MT,G3(:,:,:,301))
  call loop_QV_A(G3(:,:,:,301),wf(:,-5),G3(:,:,:,302))
  call loop_Q_A(G3(:,:,:,302),Q(:,62),MT,G4(:,:,:,155))
  call loop_QS_A(G4(:,:,:,155),wf(:,0),G4(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,156),Q(:,63),MT,G5tensor(:,54))
  call loop_QV_A(G1(:,:,:,203),wf(:,188),G1(:,:,:,213))
  call loop_Q_A(G1(:,:,:,213),Q(:,62),MT,G2(:,:,:,425))
  call loop_QS_A(G2(:,:,:,425),wf(:,0),G2(:,:,:,426),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,426),Q(:,63),MT,G3tensor(:,111))
  call loop_QV_A(G1(:,:,:,203),wf(:,-1),G1(:,:,:,214))
  call loop_Q_A(G1(:,:,:,214),Q(:,14),MT,G2(:,:,:,427))
  call loop_QV_A(G2(:,:,:,427),wf(:,119),G2(:,:,:,428))
  call loop_Q_A(G2(:,:,:,428),Q(:,62),MT,G3(:,:,:,303))
  call loop_QS_A(G3(:,:,:,303),wf(:,0),G3(:,:,:,304),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,304),Q(:,63),MT,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,427),wf(:,-5),G2(:,:,:,429))
  call loop_Q_A(G2(:,:,:,429),Q(:,46),MT,G3(:,:,:,305))
  call loop_QV_A(G3(:,:,:,305),wf(:,-4),G3(:,:,:,306))
  call loop_Q_A(G3(:,:,:,306),Q(:,62),MT,G4(:,:,:,157))
  call loop_QS_A(G4(:,:,:,157),wf(:,0),G4(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,63),MT,G5tensor(:,55))
  call loop_QV_A(G2(:,:,:,427),wf(:,-4),G2(:,:,:,430))
  call loop_Q_A(G2(:,:,:,430),Q(:,30),MT,G3(:,:,:,307))
  call loop_QV_A(G3(:,:,:,307),wf(:,-5),G3(:,:,:,308))
  call loop_Q_A(G3(:,:,:,308),Q(:,62),MT,G4(:,:,:,159))
  call loop_QS_A(G4(:,:,:,159),wf(:,0),G4(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,63),MT,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,313),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,30),MT,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,-5),G1(:,:,:,216))
  call loop_Q_A(G1(:,:,:,216),Q(:,62),MT,G2(:,:,:,431))
  call loop_QS_A(G2(:,:,:,431),wf(:,0),G2(:,:,:,432),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,432),Q(:,63),MT,G3tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,314),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,30),MT,G1(:,:,:,217))
  call loop_QV_A(G1(:,:,:,217),wf(:,-5),G1(:,:,:,218))
  call loop_Q_A(G1(:,:,:,218),Q(:,62),MT,G2(:,:,:,433))
  call loop_QS_A(G2(:,:,:,433),wf(:,0),G2(:,:,:,434),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,434),Q(:,63),MT,G3tensor(:,113))
  call loop_QV_A(G0(:,:,:,1),wf(:,315),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,30),MT,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,-5),G1(:,:,:,220))
  call loop_Q_A(G1(:,:,:,220),Q(:,62),MT,G2(:,:,:,435))
  call loop_QS_A(G2(:,:,:,435),wf(:,0),G2(:,:,:,436),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,436),Q(:,63),MT,G3tensor(:,114))
  call loop_AV_Q(G0(:,:,:,1),wf(:,313),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,30),MT,G1(:,:,:,221))
  call loop_AV_Q(G1(:,:,:,221),wf(:,-5),G1(:,:,:,222))
  call loop_A_Q(G1(:,:,:,222),Q(:,62),MT,G2(:,:,:,437))
  call loop_AS_Q(G2(:,:,:,437),wf(:,0),G2(:,:,:,438),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,438),Q(:,63),MT,G3tensor(:,115))
  call loop_AV_Q(G0(:,:,:,1),wf(:,314),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,30),MT,G1(:,:,:,223))
  call loop_AV_Q(G1(:,:,:,223),wf(:,-5),G1(:,:,:,224))
  call loop_A_Q(G1(:,:,:,224),Q(:,62),MT,G2(:,:,:,439))
  call loop_AS_Q(G2(:,:,:,439),wf(:,0),G2(:,:,:,440),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,440),Q(:,63),MT,G3tensor(:,116))
  call loop_AV_Q(G0(:,:,:,1),wf(:,315),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,30),MT,G1(:,:,:,225))
  call loop_AV_Q(G1(:,:,:,225),wf(:,-5),G1(:,:,:,226))
  call loop_A_Q(G1(:,:,:,226),Q(:,62),MT,G2(:,:,:,441))
  call loop_AS_Q(G2(:,:,:,441),wf(:,0),G2(:,:,:,442),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,442),Q(:,63),MT,G3tensor(:,117))
  call loop_AV_Q(G0(:,:,:,1),wf(:,76),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,20),MT,G1(:,:,:,227))
  call loop_AV_Q(G1(:,:,:,227),wf(:,77),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,62),MT,G2(:,:,:,443))
  call loop_AS_Q(G2(:,:,:,443),wf(:,0),G2(:,:,:,444),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,444),Q(:,63),MT,G3tensor(:,118))
  call loop_AV_Q(G1(:,:,:,227),wf(:,79),G1(:,:,:,229))
  call loop_A_Q(G1(:,:,:,229),Q(:,62),MT,G2(:,:,:,445))
  call loop_AS_Q(G2(:,:,:,445),wf(:,0),G2(:,:,:,446),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,446),Q(:,63),MT,G3tensor(:,119))
  call loop_AV_Q(G1(:,:,:,227),wf(:,80),G1(:,:,:,230))
  call loop_A_Q(G1(:,:,:,230),Q(:,62),MT,G2(:,:,:,447))
  call loop_AS_Q(G2(:,:,:,447),wf(:,0),G2(:,:,:,448),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,448),Q(:,63),MT,G3tensor(:,120))
  call loop_AV_Q(G1(:,:,:,227),wf(:,176),G1(:,:,:,231))
  call loop_A_Q(G1(:,:,:,231),Q(:,62),MT,G2(:,:,:,449))
  call loop_AS_Q(G2(:,:,:,449),wf(:,0),G2(:,:,:,450),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,450),Q(:,63),MT,G3tensor(:,121))
  call loop_AV_Q(G1(:,:,:,227),wf(:,18),G1(:,:,:,232))
  call loop_A_Q(G1(:,:,:,232),Q(:,30),MT,G2(:,:,:,451))
  call loop_AV_Q(G2(:,:,:,451),wf(:,-5),G2(:,:,:,452))
  call loop_A_Q(G2(:,:,:,452),Q(:,62),MT,G3(:,:,:,309))
  call loop_AS_Q(G3(:,:,:,309),wf(:,0),G3(:,:,:,310),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,63),MT,G4tensor(:,87))
  call loop_AV_Q(G1(:,:,:,227),wf(:,196),G1(:,:,:,233))
  call loop_A_Q(G1(:,:,:,233),Q(:,62),MT,G2(:,:,:,453))
  call loop_AS_Q(G2(:,:,:,453),wf(:,0),G2(:,:,:,454),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,454),Q(:,63),MT,G3tensor(:,122))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-3),G1(:,:,:,234))
  call loop_A_Q(G1(:,:,:,234),Q(:,28),MT,G2(:,:,:,455))
  call loop_AV_Q(G2(:,:,:,455),wf(:,37),G2(:,:,:,456))
  call loop_A_Q(G2(:,:,:,456),Q(:,62),MT,G3(:,:,:,311))
  call loop_AS_Q(G3(:,:,:,311),wf(:,0),G3(:,:,:,312),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,312),Q(:,63),MT,G4tensor(:,88))
  call loop_AV_Q(G2(:,:,:,455),wf(:,-1),G2(:,:,:,457))
  call loop_A_Q(G2(:,:,:,457),Q(:,30),MT,G3(:,:,:,313))
  call loop_AV_Q(G3(:,:,:,313),wf(:,-5),G3(:,:,:,314))
  call loop_A_Q(G3(:,:,:,314),Q(:,62),MT,G4(:,:,:,161))
  call loop_AS_Q(G4(:,:,:,161),wf(:,0),G4(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,162),Q(:,63),MT,G5tensor(:,57))
  call loop_AV_Q(G1(:,:,:,227),wf(:,197),G1(:,:,:,235))
  call loop_A_Q(G1(:,:,:,235),Q(:,62),MT,G2(:,:,:,458))
  call loop_AS_Q(G2(:,:,:,458),wf(:,0),G2(:,:,:,459),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,459),Q(:,63),MT,G3tensor(:,123))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-1),G1(:,:,:,236))
  call loop_A_Q(G1(:,:,:,236),Q(:,22),MT,G2(:,:,:,460))
  call loop_AV_Q(G2(:,:,:,460),wf(:,109),G2(:,:,:,461))
  call loop_A_Q(G2(:,:,:,461),Q(:,62),MT,G3(:,:,:,315))
  call loop_AS_Q(G3(:,:,:,315),wf(:,0),G3(:,:,:,316),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,63),MT,G4tensor(:,89))
  call loop_AV_Q(G2(:,:,:,460),wf(:,-3),G2(:,:,:,462))
  call loop_A_Q(G2(:,:,:,462),Q(:,30),MT,G3(:,:,:,317))
  call loop_AV_Q(G3(:,:,:,317),wf(:,-5),G3(:,:,:,318))
  call loop_A_Q(G3(:,:,:,318),Q(:,62),MT,G4(:,:,:,163))
  call loop_AS_Q(G4(:,:,:,163),wf(:,0),G4(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,63),MT,G5tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,76),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,20),MT,G1(:,:,:,237))
  call loop_QV_A(G1(:,:,:,237),wf(:,77),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,62),MT,G2(:,:,:,463))
  call loop_QS_A(G2(:,:,:,463),wf(:,0),G2(:,:,:,464),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,464),Q(:,63),MT,G3tensor(:,124))
  call loop_QV_A(G1(:,:,:,237),wf(:,79),G1(:,:,:,239))
  call loop_Q_A(G1(:,:,:,239),Q(:,62),MT,G2(:,:,:,465))
  call loop_QS_A(G2(:,:,:,465),wf(:,0),G2(:,:,:,466),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,466),Q(:,63),MT,G3tensor(:,125))
  call loop_QV_A(G1(:,:,:,237),wf(:,80),G1(:,:,:,240))
  call loop_Q_A(G1(:,:,:,240),Q(:,62),MT,G2(:,:,:,467))
  call loop_QS_A(G2(:,:,:,467),wf(:,0),G2(:,:,:,468),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,468),Q(:,63),MT,G3tensor(:,126))
  call loop_QV_A(G1(:,:,:,237),wf(:,176),G1(:,:,:,241))
  call loop_Q_A(G1(:,:,:,241),Q(:,62),MT,G2(:,:,:,469))
  call loop_QS_A(G2(:,:,:,469),wf(:,0),G2(:,:,:,470),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,470),Q(:,63),MT,G3tensor(:,127))
  call loop_QV_A(G1(:,:,:,237),wf(:,18),G1(:,:,:,242))
  call loop_Q_A(G1(:,:,:,242),Q(:,30),MT,G2(:,:,:,471))
  call loop_QV_A(G2(:,:,:,471),wf(:,-5),G2(:,:,:,472))
  call loop_Q_A(G2(:,:,:,472),Q(:,62),MT,G3(:,:,:,319))
  call loop_QS_A(G3(:,:,:,319),wf(:,0),G3(:,:,:,320),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,320),Q(:,63),MT,G4tensor(:,90))
  call loop_QV_A(G1(:,:,:,237),wf(:,196),G1(:,:,:,243))
  call loop_Q_A(G1(:,:,:,243),Q(:,62),MT,G2(:,:,:,473))
  call loop_QS_A(G2(:,:,:,473),wf(:,0),G2(:,:,:,474),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,474),Q(:,63),MT,G3tensor(:,128))
  call loop_QV_A(G1(:,:,:,237),wf(:,-3),G1(:,:,:,244))
  call loop_Q_A(G1(:,:,:,244),Q(:,28),MT,G2(:,:,:,475))
  call loop_QV_A(G2(:,:,:,475),wf(:,37),G2(:,:,:,476))
  call loop_Q_A(G2(:,:,:,476),Q(:,62),MT,G3(:,:,:,321))
  call loop_QS_A(G3(:,:,:,321),wf(:,0),G3(:,:,:,322),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,63),MT,G4tensor(:,91))
  call loop_QV_A(G2(:,:,:,475),wf(:,-1),G2(:,:,:,477))
  call loop_Q_A(G2(:,:,:,477),Q(:,30),MT,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,-5),G3(:,:,:,324))
  call loop_Q_A(G3(:,:,:,324),Q(:,62),MT,G4(:,:,:,165))
  call loop_QS_A(G4(:,:,:,165),wf(:,0),G4(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,166),Q(:,63),MT,G5tensor(:,59))
  call loop_QV_A(G1(:,:,:,237),wf(:,197),G1(:,:,:,245))
  call loop_Q_A(G1(:,:,:,245),Q(:,62),MT,G2(:,:,:,478))
  call loop_QS_A(G2(:,:,:,478),wf(:,0),G2(:,:,:,479),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,479),Q(:,63),MT,G3tensor(:,129))
  call loop_QV_A(G1(:,:,:,237),wf(:,-1),G1(:,:,:,246))
  call loop_Q_A(G1(:,:,:,246),Q(:,22),MT,G2(:,:,:,480))
  call loop_QV_A(G2(:,:,:,480),wf(:,109),G2(:,:,:,481))
  call loop_Q_A(G2(:,:,:,481),Q(:,62),MT,G3(:,:,:,325))
  call loop_QS_A(G3(:,:,:,325),wf(:,0),G3(:,:,:,326),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,326),Q(:,63),MT,G4tensor(:,92))
  call loop_QV_A(G2(:,:,:,480),wf(:,-3),G2(:,:,:,482))
  call loop_Q_A(G2(:,:,:,482),Q(:,30),MT,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,-5),G3(:,:,:,328))
  call loop_Q_A(G3(:,:,:,328),Q(:,62),MT,G4(:,:,:,167))
  call loop_QS_A(G4(:,:,:,167),wf(:,0),G4(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,168),Q(:,63),MT,G5tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,26),MT,G1(:,:,:,247))
  call loop_QV_A(G1(:,:,:,247),wf(:,84),G1(:,:,:,248))
  call loop_Q_A(G1(:,:,:,248),Q(:,62),MT,G2(:,:,:,483))
  call loop_QS_A(G2(:,:,:,483),wf(:,0),G2(:,:,:,484),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,484),Q(:,63),MT,G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,247),wf(:,-2),G1(:,:,:,249))
  call loop_Q_A(G1(:,:,:,249),Q(:,30),MT,G2(:,:,:,485))
  call loop_QV_A(G2(:,:,:,485),wf(:,-5),G2(:,:,:,486))
  call loop_Q_A(G2(:,:,:,486),Q(:,62),MT,G3(:,:,:,329))
  call loop_QS_A(G3(:,:,:,329),wf(:,0),G3(:,:,:,330),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,330),Q(:,63),MT,G4tensor(:,93))
  call loop_QV_A(G0(:,:,:,1),wf(:,87),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,26),MT,G1(:,:,:,250))
  call loop_QV_A(G1(:,:,:,250),wf(:,84),G1(:,:,:,251))
  call loop_Q_A(G1(:,:,:,251),Q(:,62),MT,G2(:,:,:,487))
  call loop_QS_A(G2(:,:,:,487),wf(:,0),G2(:,:,:,488),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,488),Q(:,63),MT,G3tensor(:,131))
  call loop_QV_A(G1(:,:,:,250),wf(:,-2),G1(:,:,:,252))
  call loop_Q_A(G1(:,:,:,252),Q(:,30),MT,G2(:,:,:,489))
  call loop_QV_A(G2(:,:,:,489),wf(:,-5),G2(:,:,:,490))
  call loop_Q_A(G2(:,:,:,490),Q(:,62),MT,G3(:,:,:,331))
  call loop_QS_A(G3(:,:,:,331),wf(:,0),G3(:,:,:,332),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,63),MT,G4tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,88),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,26),MT,G1(:,:,:,253))
  call loop_QV_A(G1(:,:,:,253),wf(:,84),G1(:,:,:,254))
  call loop_Q_A(G1(:,:,:,254),Q(:,62),MT,G2(:,:,:,491))
  call loop_QS_A(G2(:,:,:,491),wf(:,0),G2(:,:,:,492),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,492),Q(:,63),MT,G3tensor(:,132))
  call loop_QV_A(G1(:,:,:,253),wf(:,-2),G1(:,:,:,255))
  call loop_Q_A(G1(:,:,:,255),Q(:,30),MT,G2(:,:,:,493))
  call loop_QV_A(G2(:,:,:,493),wf(:,-5),G2(:,:,:,494))
  call loop_Q_A(G2(:,:,:,494),Q(:,62),MT,G3(:,:,:,333))
  call loop_QS_A(G3(:,:,:,333),wf(:,0),G3(:,:,:,334),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,63),MT,G4tensor(:,95))
  call loop_AV_Q(G0(:,:,:,1),wf(:,85),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,26),MT,G1(:,:,:,256))
  call loop_AV_Q(G1(:,:,:,256),wf(:,84),G1(:,:,:,257))
  call loop_A_Q(G1(:,:,:,257),Q(:,62),MT,G2(:,:,:,495))
  call loop_AS_Q(G2(:,:,:,495),wf(:,0),G2(:,:,:,496),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,496),Q(:,63),MT,G3tensor(:,133))
  call loop_AV_Q(G1(:,:,:,256),wf(:,-2),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,30),MT,G2(:,:,:,497))
  call loop_AV_Q(G2(:,:,:,497),wf(:,-5),G2(:,:,:,498))
  call loop_A_Q(G2(:,:,:,498),Q(:,62),MT,G3(:,:,:,335))
  call loop_AS_Q(G3(:,:,:,335),wf(:,0),G3(:,:,:,336),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,336),Q(:,63),MT,G4tensor(:,96))
  call loop_AV_Q(G0(:,:,:,1),wf(:,87),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,26),MT,G1(:,:,:,259))
  call loop_AV_Q(G1(:,:,:,259),wf(:,84),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,62),MT,G2(:,:,:,499))
  call loop_AS_Q(G2(:,:,:,499),wf(:,0),G2(:,:,:,500),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,500),Q(:,63),MT,G3tensor(:,134))
  call loop_AV_Q(G1(:,:,:,259),wf(:,-2),G1(:,:,:,261))
  call loop_A_Q(G1(:,:,:,261),Q(:,30),MT,G2(:,:,:,501))
  call loop_AV_Q(G2(:,:,:,501),wf(:,-5),G2(:,:,:,502))
  call loop_A_Q(G2(:,:,:,502),Q(:,62),MT,G3(:,:,:,337))
  call loop_AS_Q(G3(:,:,:,337),wf(:,0),G3(:,:,:,338),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,63),MT,G4tensor(:,97))
  call loop_AV_Q(G0(:,:,:,1),wf(:,88),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,26),MT,G1(:,:,:,262))
  call loop_AV_Q(G1(:,:,:,262),wf(:,84),G1(:,:,:,263))
  call loop_A_Q(G1(:,:,:,263),Q(:,62),MT,G2(:,:,:,503))
  call loop_AS_Q(G2(:,:,:,503),wf(:,0),G2(:,:,:,504),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,504),Q(:,63),MT,G3tensor(:,135))
  call loop_AV_Q(G1(:,:,:,262),wf(:,-2),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,30),MT,G2(:,:,:,505))
  call loop_AV_Q(G2(:,:,:,505),wf(:,-5),G2(:,:,:,506))
  call loop_A_Q(G2(:,:,:,506),Q(:,62),MT,G3(:,:,:,339))
  call loop_AS_Q(G3(:,:,:,339),wf(:,0),G3(:,:,:,340),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,340),Q(:,63),MT,G4tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,328),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,30),MT,G1(:,:,:,265))
  call loop_QV_A(G1(:,:,:,265),wf(:,-5),G1(:,:,:,266))
  call loop_Q_A(G1(:,:,:,266),Q(:,62),MT,G2(:,:,:,507))
  call loop_QS_A(G2(:,:,:,507),wf(:,0),G2(:,:,:,508),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,508),Q(:,63),MT,G3tensor(:,136))
  call loop_QV_A(G0(:,:,:,1),wf(:,329),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,30),MT,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,-5),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,62),MT,G2(:,:,:,509))
  call loop_QS_A(G2(:,:,:,509),wf(:,0),G2(:,:,:,510),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,510),Q(:,63),MT,G3tensor(:,137))
  call loop_QV_A(G0(:,:,:,1),wf(:,330),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,30),MT,G1(:,:,:,269))
  call loop_QV_A(G1(:,:,:,269),wf(:,-5),G1(:,:,:,270))
  call loop_Q_A(G1(:,:,:,270),Q(:,62),MT,G2(:,:,:,511))
  call loop_QS_A(G2(:,:,:,511),wf(:,0),G2(:,:,:,512),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,512),Q(:,63),MT,G3tensor(:,138))
  call loop_AV_Q(G0(:,:,:,1),wf(:,328),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,30),MT,G1(:,:,:,271))
  call loop_AV_Q(G1(:,:,:,271),wf(:,-5),G1(:,:,:,272))
  call loop_A_Q(G1(:,:,:,272),Q(:,62),MT,G2(:,:,:,513))
  call loop_AS_Q(G2(:,:,:,513),wf(:,0),G2(:,:,:,514),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,514),Q(:,63),MT,G3tensor(:,139))
  call loop_AV_Q(G0(:,:,:,1),wf(:,329),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,30),MT,G1(:,:,:,273))
  call loop_AV_Q(G1(:,:,:,273),wf(:,-5),G1(:,:,:,274))
  call loop_A_Q(G1(:,:,:,274),Q(:,62),MT,G2(:,:,:,515))
  call loop_AS_Q(G2(:,:,:,515),wf(:,0),G2(:,:,:,516),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,516),Q(:,63),MT,G3tensor(:,140))
  call loop_AV_Q(G0(:,:,:,1),wf(:,330),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,30),MT,G1(:,:,:,275))
  call loop_AV_Q(G1(:,:,:,275),wf(:,-5),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,62),MT,G2(:,:,:,517))
  call loop_AS_Q(G2(:,:,:,517),wf(:,0),G2(:,:,:,518),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,518),Q(:,63),MT,G3tensor(:,141))
  call loop_QV_A(G0(:,:,:,1),wf(:,334),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,30),MT,G1(:,:,:,277))
  call loop_QV_A(G1(:,:,:,277),wf(:,-5),G1(:,:,:,278))
  call loop_Q_A(G1(:,:,:,278),Q(:,62),MT,G2(:,:,:,519))
  call loop_QS_A(G2(:,:,:,519),wf(:,0),G2(:,:,:,520),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,520),Q(:,63),MT,G3tensor(:,142))
  call loop_QV_A(G0(:,:,:,1),wf(:,335),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,30),MT,G1(:,:,:,279))
  call loop_QV_A(G1(:,:,:,279),wf(:,-5),G1(:,:,:,280))
  call loop_Q_A(G1(:,:,:,280),Q(:,62),MT,G2(:,:,:,521))
  call loop_QS_A(G2(:,:,:,521),wf(:,0),G2(:,:,:,522),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,522),Q(:,63),MT,G3tensor(:,143))
  call loop_QV_A(G0(:,:,:,1),wf(:,336),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,30),MT,G1(:,:,:,281))
  call loop_QV_A(G1(:,:,:,281),wf(:,-5),G1(:,:,:,282))
  call loop_Q_A(G1(:,:,:,282),Q(:,62),MT,G2(:,:,:,523))
  call loop_QS_A(G2(:,:,:,523),wf(:,0),G2(:,:,:,524),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,524),Q(:,63),MT,G3tensor(:,144))
  call loop_AV_Q(G0(:,:,:,1),wf(:,334),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,30),MT,G1(:,:,:,283))
  call loop_AV_Q(G1(:,:,:,283),wf(:,-5),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,62),MT,G2(:,:,:,525))
  call loop_AS_Q(G2(:,:,:,525),wf(:,0),G2(:,:,:,526),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,526),Q(:,63),MT,G3tensor(:,145))
  call loop_AV_Q(G0(:,:,:,1),wf(:,335),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,30),MT,G1(:,:,:,285))
  call loop_AV_Q(G1(:,:,:,285),wf(:,-5),G1(:,:,:,286))
  call loop_A_Q(G1(:,:,:,286),Q(:,62),MT,G2(:,:,:,527))
  call loop_AS_Q(G2(:,:,:,527),wf(:,0),G2(:,:,:,528),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,528),Q(:,63),MT,G3tensor(:,146))
  call loop_AV_Q(G0(:,:,:,1),wf(:,336),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,30),MT,G1(:,:,:,287))
  call loop_AV_Q(G1(:,:,:,287),wf(:,-5),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,62),MT,G2(:,:,:,529))
  call loop_AS_Q(G2(:,:,:,529),wf(:,0),G2(:,:,:,530),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,530),Q(:,63),MT,G3tensor(:,147))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,24),MT,G1(:,:,:,289))
  call loop_AV_Q(G1(:,:,:,289),wf(:,102),G1(:,:,:,290))
  call loop_A_Q(G1(:,:,:,290),Q(:,62),MT,G2(:,:,:,531))
  call loop_AS_Q(G2(:,:,:,531),wf(:,0),G2(:,:,:,532),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,532),Q(:,63),MT,G3tensor(:,148))
  call loop_AV_Q(G1(:,:,:,289),wf(:,104),G1(:,:,:,291))
  call loop_A_Q(G1(:,:,:,291),Q(:,62),MT,G2(:,:,:,533))
  call loop_AS_Q(G2(:,:,:,533),wf(:,0),G2(:,:,:,534),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,534),Q(:,63),MT,G3tensor(:,149))
  call loop_AV_Q(G1(:,:,:,289),wf(:,105),G1(:,:,:,292))
  call loop_A_Q(G1(:,:,:,292),Q(:,62),MT,G2(:,:,:,535))
  call loop_AS_Q(G2(:,:,:,535),wf(:,0),G2(:,:,:,536),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,536),Q(:,63),MT,G3tensor(:,150))
  call loop_AV_Q(G1(:,:,:,289),wf(:,167),G1(:,:,:,293))
  call loop_A_Q(G1(:,:,:,293),Q(:,62),MT,G2(:,:,:,537))
  call loop_AS_Q(G2(:,:,:,537),wf(:,0),G2(:,:,:,538),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,538),Q(:,63),MT,G3tensor(:,151))
  call loop_AV_Q(G1(:,:,:,289),wf(:,1),G1(:,:,:,294))
  call loop_A_Q(G1(:,:,:,294),Q(:,30),MT,G2(:,:,:,539))
  call loop_AV_Q(G2(:,:,:,539),wf(:,-5),G2(:,:,:,540))
  call loop_A_Q(G2(:,:,:,540),Q(:,62),MT,G3(:,:,:,341))
  call loop_AS_Q(G3(:,:,:,341),wf(:,0),G3(:,:,:,342),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,342),Q(:,63),MT,G4tensor(:,99))
  call loop_AV_Q(G1(:,:,:,289),wf(:,200),G1(:,:,:,295))
  call loop_A_Q(G1(:,:,:,295),Q(:,62),MT,G2(:,:,:,541))
  call loop_AS_Q(G2(:,:,:,541),wf(:,0),G2(:,:,:,542),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,542),Q(:,63),MT,G3tensor(:,152))
  call loop_AV_Q(G1(:,:,:,289),wf(:,-2),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,28),MT,G2(:,:,:,543))
  call loop_AV_Q(G2(:,:,:,543),wf(:,37),G2(:,:,:,544))
  call loop_A_Q(G2(:,:,:,544),Q(:,62),MT,G3(:,:,:,343))
  call loop_AS_Q(G3(:,:,:,343),wf(:,0),G3(:,:,:,344),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,344),Q(:,63),MT,G4tensor(:,100))
  call loop_AV_Q(G2(:,:,:,543),wf(:,-1),G2(:,:,:,545))
  call loop_A_Q(G2(:,:,:,545),Q(:,30),MT,G3(:,:,:,345))
  call loop_AV_Q(G3(:,:,:,345),wf(:,-5),G3(:,:,:,346))
  call loop_A_Q(G3(:,:,:,346),Q(:,62),MT,G4(:,:,:,169))
  call loop_AS_Q(G4(:,:,:,169),wf(:,0),G4(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,170),Q(:,63),MT,G5tensor(:,61))
  call loop_AV_Q(G1(:,:,:,289),wf(:,202),G1(:,:,:,297))
  call loop_A_Q(G1(:,:,:,297),Q(:,62),MT,G2(:,:,:,546))
  call loop_AS_Q(G2(:,:,:,546),wf(:,0),G2(:,:,:,547),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,547),Q(:,63),MT,G3tensor(:,153))
  call loop_AV_Q(G1(:,:,:,289),wf(:,-1),G1(:,:,:,298))
  call loop_A_Q(G1(:,:,:,298),Q(:,26),MT,G2(:,:,:,548))
  call loop_AV_Q(G2(:,:,:,548),wf(:,84),G2(:,:,:,549))
  call loop_A_Q(G2(:,:,:,549),Q(:,62),MT,G3(:,:,:,347))
  call loop_AS_Q(G3(:,:,:,347),wf(:,0),G3(:,:,:,348),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,348),Q(:,63),MT,G4tensor(:,101))
  call loop_AV_Q(G2(:,:,:,548),wf(:,-2),G2(:,:,:,550))
  call loop_A_Q(G2(:,:,:,550),Q(:,30),MT,G3(:,:,:,349))
  call loop_AV_Q(G3(:,:,:,349),wf(:,-5),G3(:,:,:,350))
  call loop_A_Q(G3(:,:,:,350),Q(:,62),MT,G4(:,:,:,171))
  call loop_AS_Q(G4(:,:,:,171),wf(:,0),G4(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,172),Q(:,63),MT,G5tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,24),MT,G1(:,:,:,299))
  call loop_QV_A(G1(:,:,:,299),wf(:,102),G1(:,:,:,300))
  call loop_Q_A(G1(:,:,:,300),Q(:,62),MT,G2(:,:,:,551))
  call loop_QS_A(G2(:,:,:,551),wf(:,0),G2(:,:,:,552),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,552),Q(:,63),MT,G3tensor(:,154))
  call loop_QV_A(G1(:,:,:,299),wf(:,104),G1(:,:,:,301))
  call loop_Q_A(G1(:,:,:,301),Q(:,62),MT,G2(:,:,:,553))
  call loop_QS_A(G2(:,:,:,553),wf(:,0),G2(:,:,:,554),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,554),Q(:,63),MT,G3tensor(:,155))
  call loop_QV_A(G1(:,:,:,299),wf(:,105),G1(:,:,:,302))
  call loop_Q_A(G1(:,:,:,302),Q(:,62),MT,G2(:,:,:,555))
  call loop_QS_A(G2(:,:,:,555),wf(:,0),G2(:,:,:,556),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,556),Q(:,63),MT,G3tensor(:,156))
  call loop_QV_A(G1(:,:,:,299),wf(:,167),G1(:,:,:,303))
  call loop_Q_A(G1(:,:,:,303),Q(:,62),MT,G2(:,:,:,557))
  call loop_QS_A(G2(:,:,:,557),wf(:,0),G2(:,:,:,558),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,558),Q(:,63),MT,G3tensor(:,157))
  call loop_QV_A(G1(:,:,:,299),wf(:,1),G1(:,:,:,304))
  call loop_Q_A(G1(:,:,:,304),Q(:,30),MT,G2(:,:,:,559))
  call loop_QV_A(G2(:,:,:,559),wf(:,-5),G2(:,:,:,560))
  call loop_Q_A(G2(:,:,:,560),Q(:,62),MT,G3(:,:,:,351))
  call loop_QS_A(G3(:,:,:,351),wf(:,0),G3(:,:,:,352),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,352),Q(:,63),MT,G4tensor(:,102))
  call loop_QV_A(G1(:,:,:,299),wf(:,200),G1(:,:,:,305))
  call loop_Q_A(G1(:,:,:,305),Q(:,62),MT,G2(:,:,:,561))
  call loop_QS_A(G2(:,:,:,561),wf(:,0),G2(:,:,:,562),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,562),Q(:,63),MT,G3tensor(:,158))
  call loop_QV_A(G1(:,:,:,299),wf(:,-2),G1(:,:,:,306))
  call loop_Q_A(G1(:,:,:,306),Q(:,28),MT,G2(:,:,:,563))
  call loop_QV_A(G2(:,:,:,563),wf(:,37),G2(:,:,:,564))
  call loop_Q_A(G2(:,:,:,564),Q(:,62),MT,G3(:,:,:,353))
  call loop_QS_A(G3(:,:,:,353),wf(:,0),G3(:,:,:,354),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,354),Q(:,63),MT,G4tensor(:,103))
  call loop_QV_A(G2(:,:,:,563),wf(:,-1),G2(:,:,:,565))
  call loop_Q_A(G2(:,:,:,565),Q(:,30),MT,G3(:,:,:,355))
  call loop_QV_A(G3(:,:,:,355),wf(:,-5),G3(:,:,:,356))
  call loop_Q_A(G3(:,:,:,356),Q(:,62),MT,G4(:,:,:,173))
  call loop_QS_A(G4(:,:,:,173),wf(:,0),G4(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,63),MT,G5tensor(:,63))
  call loop_QV_A(G1(:,:,:,299),wf(:,202),G1(:,:,:,307))
  call loop_Q_A(G1(:,:,:,307),Q(:,62),MT,G2(:,:,:,566))
  call loop_QS_A(G2(:,:,:,566),wf(:,0),G2(:,:,:,567),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,567),Q(:,63),MT,G3tensor(:,159))
  call loop_QV_A(G1(:,:,:,299),wf(:,-1),G1(:,:,:,308))
  call loop_Q_A(G1(:,:,:,308),Q(:,26),MT,G2(:,:,:,568))
  call loop_QV_A(G2(:,:,:,568),wf(:,84),G2(:,:,:,569))
  call loop_Q_A(G2(:,:,:,569),Q(:,62),MT,G3(:,:,:,357))
  call loop_QS_A(G3(:,:,:,357),wf(:,0),G3(:,:,:,358),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,358),Q(:,63),MT,G4tensor(:,104))
  call loop_QV_A(G2(:,:,:,568),wf(:,-2),G2(:,:,:,570))
  call loop_Q_A(G2(:,:,:,570),Q(:,30),MT,G3(:,:,:,359))
  call loop_QV_A(G3(:,:,:,359),wf(:,-5),G3(:,:,:,360))
  call loop_Q_A(G3(:,:,:,360),Q(:,62),MT,G4(:,:,:,175))
  call loop_QS_A(G4(:,:,:,175),wf(:,0),G4(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,63),MT,G5tensor(:,64))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(254)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(256)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(258)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(260)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(1) = M(1) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(3) = M(3) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(5) = M(5) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(6) = M(6) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(2) = M(2) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(4) = M(4) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(6) = M(6) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(2) = M(2) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(3) = M(3) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(4) = M(4) + (f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(5) = M(5) + (-f(3) * den(2)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(10) = M(10) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(16) = M(16) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(22) = M(22) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(24) = M(24) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(10) = M(10) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(12) = M(12) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(18) = M(18) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(24) = M(24) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(12) = M(12) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(16) = M(16) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(18) = M(18) + (f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(22) = M(22) + (-f(3) * den(2)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(4) = M(4) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(262)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(9) = M(9) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(11) = M(11) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(14) = M(14) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(20) = M(20) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,52),T3sum(1:35,7))
  M(4) = M(4) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(7) = M(7) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(8) = M(8) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(10) = M(10) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(12) = M(12) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(17) = M(17) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(23) = M(23) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,53),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(9) = M(9) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(11) = M(11) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(14) = M(14) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(20) = M(20) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,54),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(9) = M(9) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(11) = M(11) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(14) = M(14) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(20) = M(20) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,7))
  M(4) = M(4) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(7) = M(7) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(8) = M(8) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(10) = M(10) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(12) = M(12) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(17) = M(17) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(23) = M(23) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(9) = M(9) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(11) = M(11) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(14) = M(14) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(20) = M(20) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,60),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(7) = M(7) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,10),T4sum(1:70,4))
  M(9) = M(9) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,10),T4sum(1:70,4))
  M(11) = M(11) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,10),T4sum(1:70,4))
  M(12) = M(12) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,10),T4sum(1:70,4))
  M(7) = M(7) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(8) = M(8) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(10) = M(10) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(12) = M(12) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(8) = M(8) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,12),T4sum(1:70,4))
  M(9) = M(9) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,12),T4sum(1:70,4))
  M(10) = M(10) + (f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,12),T4sum(1:70,4))
  M(11) = M(11) + (-f(3) * den(11)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,12),T4sum(1:70,4))
  M(4) = M(4) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,13),T4sum(1:70,5))
  M(14) = M(14) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,13),T4sum(1:70,5))
  M(20) = M(20) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,13),T4sum(1:70,5))
  M(23) = M(23) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,13),T4sum(1:70,5))
  M(4) = M(4) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,14),T4sum(1:70,5))
  M(6) = M(6) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,14),T4sum(1:70,5))
  M(17) = M(17) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,14),T4sum(1:70,5))
  M(23) = M(23) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,14),T4sum(1:70,5))
  M(6) = M(6) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,15),T4sum(1:70,5))
  M(14) = M(14) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,15),T4sum(1:70,5))
  M(17) = M(17) + (f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,15),T4sum(1:70,5))
  M(20) = M(20) + (-f(3) * den(11)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,15),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,64),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,65),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,66),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(8) = M(8) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(15) = M(15) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(17) = M(17) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(19) = M(19) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,70),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(11) = M(11) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(13) = M(13) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(14) = M(14) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(18) = M(18) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(21) = M(21) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,71),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(8) = M(8) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(15) = M(15) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(17) = M(17) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(19) = M(19) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(8) = M(8) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(15) = M(15) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(17) = M(17) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(19) = M(19) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,76),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(11) = M(11) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(13) = M(13) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(14) = M(14) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(18) = M(18) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(21) = M(21) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,77),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(8) = M(8) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(15) = M(15) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(17) = M(17) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(19) = M(19) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,78),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(271)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(273)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(13) = M(13) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,19),T4sum(1:70,7))
  M(15) = M(15) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,19),T4sum(1:70,7))
  M(17) = M(17) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,19),T4sum(1:70,7))
  M(18) = M(18) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,19),T4sum(1:70,7))
  M(13) = M(13) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,20),T4sum(1:70,7))
  M(14) = M(14) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,20),T4sum(1:70,7))
  M(16) = M(16) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,20),T4sum(1:70,7))
  M(18) = M(18) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,20),T4sum(1:70,7))
  M(14) = M(14) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,21),T4sum(1:70,7))
  M(15) = M(15) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,21),T4sum(1:70,7))
  M(16) = M(16) + (f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,21),T4sum(1:70,7))
  M(17) = M(17) + (-f(3) * den(16)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,21),T4sum(1:70,7))
  M(2) = M(2) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(8) = M(8) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(19) = M(19) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(21) = M(21) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(2) = M(2) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,23),T4sum(1:70,8))
  M(5) = M(5) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,23),T4sum(1:70,8))
  M(11) = M(11) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,23),T4sum(1:70,8))
  M(21) = M(21) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,23),T4sum(1:70,8))
  M(5) = M(5) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,24),T4sum(1:70,8))
  M(8) = M(8) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,24),T4sum(1:70,8))
  M(11) = M(11) + (f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,24),T4sum(1:70,8))
  M(19) = M(19) + (-f(3) * den(16)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,24),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,82),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,85),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,86),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,87),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,91),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,92),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,93),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(275)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(19) = M(19) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(21) = M(21) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(23) = M(23) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(24) = M(24) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(19) = M(19) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(20) = M(20) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(22) = M(22) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(24) = M(24) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(20) = M(20) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,10))
  M(21) = M(21) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,10))
  M(22) = M(22) + (f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,10))
  M(23) = M(23) + (-f(3) * den(20)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,10))
  M(1) = M(1) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,31),T4sum(1:70,11))
  M(7) = M(7) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,31),T4sum(1:70,11))
  M(13) = M(13) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,31),T4sum(1:70,11))
  M(15) = M(15) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,31),T4sum(1:70,11))
  M(1) = M(1) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,11))
  M(3) = M(3) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,11))
  M(9) = M(9) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,11))
  M(15) = M(15) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,11))
  M(3) = M(3) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,11))
  M(7) = M(7) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,11))
  M(9) = M(9) + (f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,11))
  M(13) = M(13) + (-f(3) * den(20)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,11))
  M(1) = M(1) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,71),T4sum(1:70,12))
  M(7) = M(7) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,71),T4sum(1:70,12))
  M(13) = M(13) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,71),T4sum(1:70,12))
  M(15) = M(15) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,71),T4sum(1:70,12))
  M(1) = M(1) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,72),T4sum(1:70,12))
  M(3) = M(3) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,72),T4sum(1:70,12))
  M(9) = M(9) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,72),T4sum(1:70,12))
  M(15) = M(15) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,72),T4sum(1:70,12))
  M(3) = M(3) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,73),T4sum(1:70,12))
  M(7) = M(7) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,73),T4sum(1:70,12))
  M(9) = M(9) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,73),T4sum(1:70,12))
  M(13) = M(13) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,73),T4sum(1:70,12))
  M(19) = M(19) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,74),T4sum(1:70,12))
  M(21) = M(21) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,74),T4sum(1:70,12))
  M(23) = M(23) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,74),T4sum(1:70,12))
  M(24) = M(24) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,74),T4sum(1:70,12))
  M(19) = M(19) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,75),T4sum(1:70,12))
  M(20) = M(20) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,75),T4sum(1:70,12))
  M(22) = M(22) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,75),T4sum(1:70,12))
  M(24) = M(24) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,75),T4sum(1:70,12))
  M(20) = M(20) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,76),T4sum(1:70,12))
  M(21) = M(21) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,76),T4sum(1:70,12))
  M(22) = M(22) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,76),T4sum(1:70,12))
  M(23) = M(23) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,76),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,94),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,95),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,96),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(13) = M(13) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(15) = M(15) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(19) = M(19) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(21) = M(21) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,100),T3sum(1:35,10))
  M(1) = M(1) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(2) = M(2) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(7) = M(7) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(8) = M(8) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(17) = M(17) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(18) = M(18) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(23) = M(23) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(24) = M(24) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,101),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(13) = M(13) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(15) = M(15) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(19) = M(19) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(21) = M(21) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,102),T3sum(1:35,10))
  M(2) = M(2) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(13) = M(13) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(15) = M(15) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(19) = M(19) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(21) = M(21) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,10))
  M(1) = M(1) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(2) = M(2) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(7) = M(7) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(8) = M(8) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(17) = M(17) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(18) = M(18) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(23) = M(23) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(24) = M(24) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(13) = M(13) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(15) = M(15) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(19) = M(19) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(21) = M(21) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,10))
  M(4) = M(4) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,117),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(7) = M(7) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(9) = M(9) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(20) = M(20) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(23) = M(23) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,118),T3sum(1:35,11))
  M(3) = M(3) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(4) = M(4) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(11) = M(11) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(12) = M(12) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(13) = M(13) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(14) = M(14) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(21) = M(21) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(22) = M(22) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,119),T3sum(1:35,11))
  M(3) = M(3) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(7) = M(7) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(9) = M(9) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(20) = M(20) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(23) = M(23) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,120),T3sum(1:35,11))
  M(4) = M(4) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(7) = M(7) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(9) = M(9) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(20) = M(20) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(23) = M(23) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,124),T3sum(1:35,11))
  M(3) = M(3) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(4) = M(4) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(11) = M(11) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(12) = M(12) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(13) = M(13) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(14) = M(14) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(21) = M(21) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(22) = M(22) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,125),T3sum(1:35,11))
  M(3) = M(3) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(7) = M(7) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(9) = M(9) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(20) = M(20) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(23) = M(23) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,126),T3sum(1:35,11))
  M(6) = M(6) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(8) = M(8) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(11) = M(11) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(14) = M(14) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(17) = M(17) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,130),T3sum(1:35,12))
  M(5) = M(5) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(6) = M(6) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(9) = M(9) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(10) = M(10) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(15) = M(15) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(16) = M(16) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(19) = M(19) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(20) = M(20) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,131),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(8) = M(8) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(11) = M(11) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(14) = M(14) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(17) = M(17) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,132),T3sum(1:35,12))
  M(6) = M(6) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(8) = M(8) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(11) = M(11) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(14) = M(14) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(17) = M(17) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,133),T3sum(1:35,12))
  M(5) = M(5) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(6) = M(6) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(9) = M(9) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(10) = M(10) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(15) = M(15) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(16) = M(16) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(19) = M(19) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(20) = M(20) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,134),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(8) = M(8) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(11) = M(11) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(14) = M(14) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(17) = M(17) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,135),T3sum(1:35,12))
  M(6) = M(6) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,139),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,140),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,141),T3sum(1:35,3))
  M(10) = M(10) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,93),T4sum(1:70,21))
  M(11) = M(11) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,93),T4sum(1:70,21))
  M(17) = M(17) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,93),T4sum(1:70,21))
  M(20) = M(20) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,93),T4sum(1:70,21))
  M(10) = M(10) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,94),T4sum(1:70,21))
  M(16) = M(16) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,94),T4sum(1:70,21))
  M(19) = M(19) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,94),T4sum(1:70,21))
  M(20) = M(20) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,94),T4sum(1:70,21))
  M(11) = M(11) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,95),T4sum(1:70,21))
  M(16) = M(16) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,95),T4sum(1:70,21))
  M(17) = M(17) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,95),T4sum(1:70,21))
  M(19) = M(19) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,95),T4sum(1:70,21))
  M(6) = M(6) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,96),T4sum(1:70,21))
  M(8) = M(8) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,96),T4sum(1:70,21))
  M(9) = M(9) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,96),T4sum(1:70,21))
  M(14) = M(14) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,96),T4sum(1:70,21))
  M(5) = M(5) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,97),T4sum(1:70,21))
  M(6) = M(6) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,97),T4sum(1:70,21))
  M(9) = M(9) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,97),T4sum(1:70,21))
  M(15) = M(15) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,97),T4sum(1:70,21))
  M(5) = M(5) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,98),T4sum(1:70,21))
  M(8) = M(8) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,98),T4sum(1:70,21))
  M(14) = M(14) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,98),T4sum(1:70,21))
  M(15) = M(15) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,98),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,142),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,143),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,144),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,145),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,146),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,147),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(3) = M(3) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(5) = M(5) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(22) = M(22) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(24) = M(24) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,148),T3sum(1:35,13))
  M(5) = M(5) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(6) = M(6) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(9) = M(9) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(10) = M(10) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(15) = M(15) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(16) = M(16) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(19) = M(19) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(20) = M(20) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,149),T3sum(1:35,13))
  M(1) = M(1) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(3) = M(3) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(22) = M(22) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(24) = M(24) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,150),T3sum(1:35,13))
  M(1) = M(1) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(3) = M(3) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(5) = M(5) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(22) = M(22) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(24) = M(24) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,154),T3sum(1:35,13))
  M(5) = M(5) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(6) = M(6) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(9) = M(9) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(10) = M(10) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(15) = M(15) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(16) = M(16) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(19) = M(19) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(20) = M(20) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,155),T3sum(1:35,13))
  M(1) = M(1) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(3) = M(3) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(22) = M(22) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(24) = M(24) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,156),T3sum(1:35,13))
  M(1) = M(1) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(3) = M(3) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(5) = M(5) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(22) = M(22) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(24) = M(24) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,151),T3sum(1:35,13))
  M(1) = M(1) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(3) = M(3) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(5) = M(5) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(22) = M(22) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(24) = M(24) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,157),T3sum(1:35,13))
  M(1) = M(1) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,102),T4sum(1:70,32))
  M(3) = M(3) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,102),T4sum(1:70,32))
  M(10) = M(10) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,102),T4sum(1:70,32))
  M(16) = M(16) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,102),T4sum(1:70,32))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,99),T4sum(1:70,32))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,99),T4sum(1:70,32))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,99),T4sum(1:70,32))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_2,G4tensor(:,99),T4sum(1:70,32))
  M(4) = M(4) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(7) = M(7) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(9) = M(9) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(20) = M(20) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(23) = M(23) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,121),T3sum(1:35,11))
  M(4) = M(4) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(7) = M(7) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(9) = M(9) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(20) = M(20) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(23) = M(23) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,127),T3sum(1:35,11))
  M(4) = M(4) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(9) = M(9) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(11) = M(11) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(14) = M(14) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(20) = M(20) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,55),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(9) = M(9) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(11) = M(11) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(14) = M(14) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(20) = M(20) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,61),T3sum(1:35,7))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,60),T4sum(1:70,40))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,60),T4sum(1:70,40))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,60),T4sum(1:70,40))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,60),T4sum(1:70,40))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,55),T4sum(1:70,40))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,55),T4sum(1:70,40))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,55),T4sum(1:70,40))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_2,G4tensor(:,55),T4sum(1:70,40))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,90),T4sum(1:70,41))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,90),T4sum(1:70,41))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,90),T4sum(1:70,41))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,90),T4sum(1:70,41))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,87),T4sum(1:70,41))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,87),T4sum(1:70,41))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,87),T4sum(1:70,41))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_2,G4tensor(:,87),T4sum(1:70,41))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,56),T4sum(1:70,42))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,56),T4sum(1:70,42))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,56),T4sum(1:70,42))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,56),T4sum(1:70,42))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,61),T4sum(1:70,42))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,61),T4sum(1:70,42))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,61),T4sum(1:70,42))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_2,G4tensor(:,61),T4sum(1:70,42))
  M(6) = M(6) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(9) = M(9) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(11) = M(11) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(14) = M(14) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(20) = M(20) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,56),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(9) = M(9) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(11) = M(11) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(14) = M(14) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(20) = M(20) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,62),T3sum(1:35,7))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,62),T4sum(1:70,43))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,62),T4sum(1:70,43))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,62),T4sum(1:70,43))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,62),T4sum(1:70,43))
  M(6) = M(6) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,57),T4sum(1:70,43))
  M(8) = M(8) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,57),T4sum(1:70,43))
  M(11) = M(11) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,57),T4sum(1:70,43))
  M(20) = M(20) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_2,G4tensor(:,57),T4sum(1:70,43))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,58),T4sum(1:70,45))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,58),T4sum(1:70,45))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,58),T4sum(1:70,45))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,58),T4sum(1:70,45))
  M(6) = M(6) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,63),T4sum(1:70,45))
  M(8) = M(8) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,63),T4sum(1:70,45))
  M(11) = M(11) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,63),T4sum(1:70,45))
  M(20) = M(20) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_2,G4tensor(:,63),T4sum(1:70,45))
  M(4) = M(4) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(7) = M(7) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(8) = M(8) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(17) = M(17) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(23) = M(23) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,63),T3sum(1:35,7))
  M(4) = M(4) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,59),T4sum(1:70,48))
  M(6) = M(6) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,59),T4sum(1:70,48))
  M(7) = M(7) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,59),T4sum(1:70,48))
  M(8) = M(8) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,59),T4sum(1:70,48))
  M(10) = M(10) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,64),T4sum(1:70,48))
  M(12) = M(12) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,64),T4sum(1:70,48))
  M(17) = M(17) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,64),T4sum(1:70,48))
  M(23) = M(23) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_2,G4tensor(:,64),T4sum(1:70,48))
  M(9) = M(9) + (CI*f(2) * den(10)) * TI2_call(5,momenta_188,masses2_3,G5tensor(:,41),T5sum(1:126,21))
  M(14) = M(14) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_188,masses2_3,G5tensor(:,41),T5sum(1:126,21))
  M(11) = M(11) + (CI*f(2) * den(10)) * TI2_call(5,momenta_188,masses2_3,G5tensor(:,37),T5sum(1:126,21))
  M(20) = M(20) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_188,masses2_3,G5tensor(:,37),T5sum(1:126,21))
  M(10) = M(10) + (CI*f(2) * den(10)) * TI2_call(5,momenta_186,masses2_3,G5tensor(:,43),T5sum(1:126,22))
  M(17) = M(17) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_186,masses2_3,G5tensor(:,43),T5sum(1:126,22))
  M(6) = M(6) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_186,masses2_3,G5tensor(:,39),T5sum(1:126,22))
  M(8) = M(8) + (CI*f(2) * den(10)) * TI2_call(5,momenta_186,masses2_3,G5tensor(:,39),T5sum(1:126,22))
  M(11) = M(11) + (CI*f(2) * den(10)) * TI2_call(5,momenta_187,masses2_3,G5tensor(:,42),T5sum(1:126,23))
  M(20) = M(20) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_187,masses2_3,G5tensor(:,42),T5sum(1:126,23))
  M(9) = M(9) + (CI*f(2) * den(10)) * TI2_call(5,momenta_187,masses2_3,G5tensor(:,38),T5sum(1:126,23))
  M(14) = M(14) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_187,masses2_3,G5tensor(:,38),T5sum(1:126,23))
  M(12) = M(12) + (CI*f(2) * den(10)) * TI2_call(5,momenta_185,masses2_3,G5tensor(:,44),T5sum(1:126,24))
  M(23) = M(23) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_185,masses2_3,G5tensor(:,44),T5sum(1:126,24))
  M(4) = M(4) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_185,masses2_3,G5tensor(:,40),T5sum(1:126,24))
  M(7) = M(7) + (CI*f(2) * den(10)) * TI2_call(5,momenta_185,masses2_3,G5tensor(:,40),T5sum(1:126,24))
  M(2) = M(2) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(13) = M(13) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(15) = M(15) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(19) = M(19) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(21) = M(21) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,10))
  M(2) = M(2) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(13) = M(13) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(15) = M(15) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(19) = M(19) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(21) = M(21) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,10))
  M(2) = M(2) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(8) = M(8) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(15) = M(15) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(17) = M(17) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(19) = M(19) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,73),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(8) = M(8) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(15) = M(15) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(17) = M(17) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(19) = M(19) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,79),T3sum(1:35,8))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,68),T4sum(1:70,49))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,68),T4sum(1:70,49))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,68),T4sum(1:70,49))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,68),T4sum(1:70,49))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,65),T4sum(1:70,49))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,65),T4sum(1:70,49))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,65),T4sum(1:70,49))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_2,G4tensor(:,65),T4sum(1:70,49))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,82),T4sum(1:70,50))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,82),T4sum(1:70,50))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,82),T4sum(1:70,50))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,82),T4sum(1:70,50))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,77),T4sum(1:70,50))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,77),T4sum(1:70,50))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,77),T4sum(1:70,50))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_2,G4tensor(:,77),T4sum(1:70,50))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,83),T4sum(1:70,51))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,83),T4sum(1:70,51))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,83),T4sum(1:70,51))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,83),T4sum(1:70,51))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,78),T4sum(1:70,51))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,78),T4sum(1:70,51))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,78),T4sum(1:70,51))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_2,G4tensor(:,78),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(13) = M(13) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(15) = M(15) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(19) = M(19) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(21) = M(21) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(13) = M(13) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(15) = M(15) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(19) = M(19) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(21) = M(21) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,10))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,84),T4sum(1:70,53))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,84),T4sum(1:70,53))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,84),T4sum(1:70,53))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,84),T4sum(1:70,53))
  M(13) = M(13) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,79),T4sum(1:70,53))
  M(15) = M(15) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,79),T4sum(1:70,53))
  M(23) = M(23) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,79),T4sum(1:70,53))
  M(24) = M(24) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_2,G4tensor(:,79),T4sum(1:70,53))
  M(13) = M(13) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,85),T4sum(1:70,54))
  M(15) = M(15) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,85),T4sum(1:70,54))
  M(23) = M(23) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,85),T4sum(1:70,54))
  M(24) = M(24) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,85),T4sum(1:70,54))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,80),T4sum(1:70,54))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,80),T4sum(1:70,54))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,80),T4sum(1:70,54))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_2,G4tensor(:,80),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(2) = M(2) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(2) = M(2) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(7) = M(7) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(8) = M(8) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(17) = M(17) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(18) = M(18) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(23) = M(23) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(24) = M(24) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,10))
  M(1) = M(1) + (CI*f(2) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(329)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(1) = M(1) + (-f(3) * den(328)) * TI2_call(4,momenta_27,masses2_2,G4tensor(:,37),T4sum(1:70,55))
  M(2) = M(2) + (f(3) * den(328)) * TI2_call(4,momenta_27,masses2_2,G4tensor(:,37),T4sum(1:70,55))
  M(7) = M(7) + (f(3) * den(328)) * TI2_call(4,momenta_27,masses2_2,G4tensor(:,37),T4sum(1:70,55))
  M(8) = M(8) + (-f(3) * den(328)) * TI2_call(4,momenta_27,masses2_2,G4tensor(:,37),T4sum(1:70,55))
  M(17) = M(17) + (-f(3) * den(328)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,38),T4sum(1:70,56))
  M(18) = M(18) + (f(3) * den(328)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,38),T4sum(1:70,56))
  M(23) = M(23) + (f(3) * den(328)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,38),T4sum(1:70,56))
  M(24) = M(24) + (-f(3) * den(328)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,38),T4sum(1:70,56))
  M(17) = M(17) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,81),T4sum(1:70,57))
  M(18) = M(18) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,81),T4sum(1:70,57))
  M(23) = M(23) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,81),T4sum(1:70,57))
  M(24) = M(24) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,81),T4sum(1:70,57))
  M(1) = M(1) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,86),T4sum(1:70,57))
  M(2) = M(2) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,86),T4sum(1:70,57))
  M(7) = M(7) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,86),T4sum(1:70,57))
  M(8) = M(8) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_2,G4tensor(:,86),T4sum(1:70,57))
  M(1) = M(1) + (CI*f(2) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(334)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(19) = M(19) + (-f(3) * den(139)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(21) = M(21) + (f(3) * den(139)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(23) = M(23) + (f(3) * den(139)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(24) = M(24) + (-f(3) * den(139)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(1) = M(1) + (-f(3) * den(139)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,34),T4sum(1:70,11))
  M(7) = M(7) + (f(3) * den(139)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,34),T4sum(1:70,11))
  M(13) = M(13) + (f(3) * den(139)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,34),T4sum(1:70,11))
  M(15) = M(15) + (-f(3) * den(139)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,34),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(2)) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(335)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(13) = M(13) + (-f(3) * den(134)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,40),T4sum(1:70,7))
  M(15) = M(15) + (f(3) * den(134)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,40),T4sum(1:70,7))
  M(17) = M(17) + (f(3) * den(134)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,40),T4sum(1:70,7))
  M(18) = M(18) + (-f(3) * den(134)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,40),T4sum(1:70,7))
  M(2) = M(2) + (-f(3) * den(134)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,25),T4sum(1:70,8))
  M(8) = M(8) + (f(3) * den(134)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,25),T4sum(1:70,8))
  M(19) = M(19) + (f(3) * den(134)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,25),T4sum(1:70,8))
  M(21) = M(21) + (-f(3) * den(134)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,25),T4sum(1:70,8))
  M(13) = M(13) + (CI*f(2) * den(33)) * TI2_call(5,momenta_117,masses2_3,G5tensor(:,19),T5sum(1:126,25))
  M(15) = M(15) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_117,masses2_3,G5tensor(:,19),T5sum(1:126,25))
  M(17) = M(17) + (CI*f(2) * den(33)) * TI2_call(5,momenta_104,masses2_3,G5tensor(:,27),T5sum(1:126,26))
  M(18) = M(18) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_104,masses2_3,G5tensor(:,27),T5sum(1:126,26))
  M(19) = M(19) + (CI*f(2) * den(33)) * TI2_call(5,momenta_107,masses2_3,G5tensor(:,13),T5sum(1:126,27))
  M(21) = M(21) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_107,masses2_3,G5tensor(:,13),T5sum(1:126,27))
  M(23) = M(23) + (CI*f(2) * den(33)) * TI2_call(5,momenta_103,masses2_3,G5tensor(:,28),T5sum(1:126,28))
  M(24) = M(24) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_103,masses2_3,G5tensor(:,28),T5sum(1:126,28))
  M(2) = M(2) + (CI*f(2) * den(33)) * TI2_call(5,momenta_108,masses2_3,G5tensor(:,14),T5sum(1:126,29))
  M(8) = M(8) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_108,masses2_3,G5tensor(:,14),T5sum(1:126,29))
  M(1) = M(1) + (CI*f(2) * den(33)) * TI2_call(5,momenta_118,masses2_3,G5tensor(:,20),T5sum(1:126,30))
  M(7) = M(7) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_118,masses2_3,G5tensor(:,20),T5sum(1:126,30))
  M(19) = M(19) + (CI*f(2) * den(33)) * TI2_call(5,momenta_192,masses2_3,G5tensor(:,53),T5sum(1:126,33))
  M(21) = M(21) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_192,masses2_3,G5tensor(:,53),T5sum(1:126,33))
  M(13) = M(13) + (CI*f(2) * den(33)) * TI2_call(5,momenta_192,masses2_3,G5tensor(:,49),T5sum(1:126,33))
  M(15) = M(15) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_192,masses2_3,G5tensor(:,49),T5sum(1:126,33))
  M(1) = M(1) + (CI*f(2) * den(33)) * TI2_call(5,momenta_190,masses2_3,G5tensor(:,55),T5sum(1:126,34))
  M(7) = M(7) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_190,masses2_3,G5tensor(:,55),T5sum(1:126,34))
  M(23) = M(23) + (CI*f(2) * den(33)) * TI2_call(5,momenta_190,masses2_3,G5tensor(:,51),T5sum(1:126,34))
  M(24) = M(24) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_190,masses2_3,G5tensor(:,51),T5sum(1:126,34))
  M(13) = M(13) + (CI*f(2) * den(33)) * TI2_call(5,momenta_191,masses2_3,G5tensor(:,54),T5sum(1:126,35))
  M(15) = M(15) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_191,masses2_3,G5tensor(:,54),T5sum(1:126,35))
  M(19) = M(19) + (CI*f(2) * den(33)) * TI2_call(5,momenta_191,masses2_3,G5tensor(:,50),T5sum(1:126,35))
  M(21) = M(21) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_191,masses2_3,G5tensor(:,50),T5sum(1:126,35))
  M(2) = M(2) + (CI*f(2) * den(33)) * TI2_call(5,momenta_189,masses2_3,G5tensor(:,56),T5sum(1:126,36))
  M(8) = M(8) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_189,masses2_3,G5tensor(:,56),T5sum(1:126,36))
  M(17) = M(17) + (CI*f(2) * den(33)) * TI2_call(5,momenta_189,masses2_3,G5tensor(:,52),T5sum(1:126,36))
  M(18) = M(18) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_189,masses2_3,G5tensor(:,52),T5sum(1:126,36))
  M(5) = M(5) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(8) = M(8) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(15) = M(15) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(17) = M(17) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(19) = M(19) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,74),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(8) = M(8) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(15) = M(15) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(17) = M(17) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(19) = M(19) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,80),T3sum(1:35,8))
  M(8) = M(8) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,66),T4sum(1:70,60))
  M(11) = M(11) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,66),T4sum(1:70,60))
  M(15) = M(15) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,66),T4sum(1:70,60))
  M(16) = M(16) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,66),T4sum(1:70,60))
  M(5) = M(5) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,69),T4sum(1:70,60))
  M(14) = M(14) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,69),T4sum(1:70,60))
  M(17) = M(17) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,69),T4sum(1:70,60))
  M(19) = M(19) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_2,G4tensor(:,69),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(11) = M(11) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(13) = M(13) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(14) = M(14) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(21) = M(21) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(2) = M(2) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,67),T4sum(1:70,63))
  M(5) = M(5) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,67),T4sum(1:70,63))
  M(13) = M(13) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,67),T4sum(1:70,63))
  M(14) = M(14) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,67),T4sum(1:70,63))
  M(11) = M(11) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,70),T4sum(1:70,63))
  M(16) = M(16) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,70),T4sum(1:70,63))
  M(18) = M(18) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,70),T4sum(1:70,63))
  M(21) = M(21) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_2,G4tensor(:,70),T4sum(1:70,63))
  M(17) = M(17) + (CI*f(2) * den(15)) * TI2_call(5,momenta_206,masses2_3,G5tensor(:,47),T5sum(1:126,47))
  M(19) = M(19) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_206,masses2_3,G5tensor(:,47),T5sum(1:126,47))
  M(8) = M(8) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_206,masses2_3,G5tensor(:,45),T5sum(1:126,47))
  M(15) = M(15) + (CI*f(2) * den(15)) * TI2_call(5,momenta_206,masses2_3,G5tensor(:,45),T5sum(1:126,47))
  M(18) = M(18) + (CI*f(2) * den(15)) * TI2_call(5,momenta_205,masses2_3,G5tensor(:,48),T5sum(1:126,48))
  M(21) = M(21) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_205,masses2_3,G5tensor(:,48),T5sum(1:126,48))
  M(2) = M(2) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_205,masses2_3,G5tensor(:,46),T5sum(1:126,48))
  M(13) = M(13) + (CI*f(2) * den(15)) * TI2_call(5,momenta_205,masses2_3,G5tensor(:,46),T5sum(1:126,48))
  M(3) = M(3) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(7) = M(7) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(9) = M(9) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(20) = M(20) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(23) = M(23) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,122),T3sum(1:35,11))
  M(3) = M(3) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(7) = M(7) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(9) = M(9) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(20) = M(20) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(23) = M(23) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,128),T3sum(1:35,11))
  M(7) = M(7) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,91),T4sum(1:70,66))
  M(9) = M(9) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,91),T4sum(1:70,66))
  M(21) = M(21) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,91),T4sum(1:70,66))
  M(22) = M(22) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,91),T4sum(1:70,66))
  M(3) = M(3) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,88),T4sum(1:70,66))
  M(13) = M(13) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,88),T4sum(1:70,66))
  M(20) = M(20) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,88),T4sum(1:70,66))
  M(23) = M(23) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_2,G4tensor(:,88),T4sum(1:70,66))
  M(3) = M(3) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(4) = M(4) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,129),T3sum(1:35,11))
  M(3) = M(3) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(4) = M(4) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(11) = M(11) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(12) = M(12) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(13) = M(13) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(14) = M(14) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(21) = M(21) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(22) = M(22) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,123),T3sum(1:35,11))
  M(3) = M(3) + (CI*f(2) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(349)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(3) = M(3) + (-f(3) * den(348)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,41),T4sum(1:70,67))
  M(4) = M(4) + (f(3) * den(348)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,41),T4sum(1:70,67))
  M(13) = M(13) + (f(3) * den(348)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,41),T4sum(1:70,67))
  M(14) = M(14) + (-f(3) * den(348)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,41),T4sum(1:70,67))
  M(11) = M(11) + (-f(3) * den(348)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,42),T4sum(1:70,68))
  M(12) = M(12) + (f(3) * den(348)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,42),T4sum(1:70,68))
  M(21) = M(21) + (f(3) * den(348)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,42),T4sum(1:70,68))
  M(22) = M(22) + (-f(3) * den(348)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,42),T4sum(1:70,68))
  M(11) = M(11) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,89),T4sum(1:70,69))
  M(12) = M(12) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,89),T4sum(1:70,69))
  M(21) = M(21) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,89),T4sum(1:70,69))
  M(22) = M(22) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,89),T4sum(1:70,69))
  M(3) = M(3) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,92),T4sum(1:70,69))
  M(4) = M(4) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,92),T4sum(1:70,69))
  M(13) = M(13) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,92),T4sum(1:70,69))
  M(14) = M(14) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_2,G4tensor(:,92),T4sum(1:70,69))
  M(3) = M(3) + (-(CI*f(2)) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(354)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(20) = M(20) + (f(3) * den(166)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,43),T4sum(1:70,10))
  M(21) = M(21) + (-f(3) * den(166)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,43),T4sum(1:70,10))
  M(22) = M(22) + (f(3) * den(166)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,43),T4sum(1:70,10))
  M(23) = M(23) + (-f(3) * den(166)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,43),T4sum(1:70,10))
  M(3) = M(3) + (f(3) * den(166)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,11))
  M(7) = M(7) + (-f(3) * den(166)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,11))
  M(9) = M(9) + (f(3) * den(166)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,11))
  M(13) = M(13) + (-f(3) * den(166)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(2)) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(355)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(7) = M(7) + (-f(3) * den(112)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,44),T4sum(1:70,4))
  M(9) = M(9) + (f(3) * den(112)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,44),T4sum(1:70,4))
  M(11) = M(11) + (f(3) * den(112)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,44),T4sum(1:70,4))
  M(12) = M(12) + (-f(3) * den(112)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,44),T4sum(1:70,4))
  M(4) = M(4) + (-f(3) * den(112)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,5))
  M(14) = M(14) + (f(3) * den(112)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,5))
  M(20) = M(20) + (f(3) * den(112)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,5))
  M(23) = M(23) + (-f(3) * den(112)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,5))
  M(7) = M(7) + (CI*f(2) * den(38)) * TI2_call(5,momenta_119,masses2_3,G5tensor(:,21),T5sum(1:126,49))
  M(9) = M(9) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_119,masses2_3,G5tensor(:,21),T5sum(1:126,49))
  M(11) = M(11) + (CI*f(2) * den(38)) * TI2_call(5,momenta_112,masses2_3,G5tensor(:,31),T5sum(1:126,50))
  M(12) = M(12) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_112,masses2_3,G5tensor(:,31),T5sum(1:126,50))
  M(20) = M(20) + (CI*f(2) * den(38)) * TI2_call(5,momenta_99,masses2_3,G5tensor(:,7),T5sum(1:126,51))
  M(23) = M(23) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_99,masses2_3,G5tensor(:,7),T5sum(1:126,51))
  M(21) = M(21) + (CI*f(2) * den(38)) * TI2_call(5,momenta_111,masses2_3,G5tensor(:,32),T5sum(1:126,52))
  M(22) = M(22) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_111,masses2_3,G5tensor(:,32),T5sum(1:126,52))
  M(4) = M(4) + (CI*f(2) * den(38)) * TI2_call(5,momenta_100,masses2_3,G5tensor(:,8),T5sum(1:126,53))
  M(14) = M(14) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_100,masses2_3,G5tensor(:,8),T5sum(1:126,53))
  M(3) = M(3) + (CI*f(2) * den(38)) * TI2_call(5,momenta_116,masses2_3,G5tensor(:,22),T5sum(1:126,54))
  M(13) = M(13) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_116,masses2_3,G5tensor(:,22),T5sum(1:126,54))
  M(7) = M(7) + (CI*f(2) * den(38)) * TI2_call(5,momenta_208,masses2_3,G5tensor(:,59),T5sum(1:126,59))
  M(9) = M(9) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_208,masses2_3,G5tensor(:,59),T5sum(1:126,59))
  M(20) = M(20) + (CI*f(2) * den(38)) * TI2_call(5,momenta_208,masses2_3,G5tensor(:,57),T5sum(1:126,59))
  M(23) = M(23) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_208,masses2_3,G5tensor(:,57),T5sum(1:126,59))
  M(4) = M(4) + (CI*f(2) * den(38)) * TI2_call(5,momenta_207,masses2_3,G5tensor(:,60),T5sum(1:126,60))
  M(14) = M(14) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_207,masses2_3,G5tensor(:,60),T5sum(1:126,60))
  M(11) = M(11) + (CI*f(2) * den(38)) * TI2_call(5,momenta_207,masses2_3,G5tensor(:,58),T5sum(1:126,60))
  M(12) = M(12) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_207,masses2_3,G5tensor(:,58),T5sum(1:126,60))
  M(1) = M(1) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(3) = M(3) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(22) = M(22) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(24) = M(24) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,158),T3sum(1:35,13))
  M(1) = M(1) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(3) = M(3) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(22) = M(22) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(24) = M(24) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,152),T3sum(1:35,13))
  M(1) = M(1) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,103),T4sum(1:70,72))
  M(3) = M(3) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,103),T4sum(1:70,72))
  M(19) = M(19) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,103),T4sum(1:70,72))
  M(20) = M(20) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,103),T4sum(1:70,72))
  M(9) = M(9) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,100),T4sum(1:70,72))
  M(15) = M(15) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,100),T4sum(1:70,72))
  M(22) = M(22) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,100),T4sum(1:70,72))
  M(24) = M(24) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_2,G4tensor(:,100),T4sum(1:70,72))
  M(5) = M(5) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,159),T3sum(1:35,13))
  M(5) = M(5) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(15) = M(15) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(16) = M(16) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(19) = M(19) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,153),T3sum(1:35,13))
  M(5) = M(5) + (-(CI*f(2)) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(359)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(5) = M(5) + (-f(3) * den(358)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,45),T4sum(1:70,73))
  M(6) = M(6) + (f(3) * den(358)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,45),T4sum(1:70,73))
  M(19) = M(19) + (f(3) * den(358)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,45),T4sum(1:70,73))
  M(20) = M(20) + (-f(3) * den(358)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,45),T4sum(1:70,73))
  M(9) = M(9) + (-f(3) * den(358)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,46),T4sum(1:70,74))
  M(10) = M(10) + (f(3) * den(358)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,46),T4sum(1:70,74))
  M(15) = M(15) + (f(3) * den(358)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,46),T4sum(1:70,74))
  M(16) = M(16) + (-f(3) * den(358)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,46),T4sum(1:70,74))
  M(9) = M(9) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,104),T4sum(1:70,75))
  M(10) = M(10) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,104),T4sum(1:70,75))
  M(15) = M(15) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,104),T4sum(1:70,75))
  M(16) = M(16) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,104),T4sum(1:70,75))
  M(5) = M(5) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,101),T4sum(1:70,75))
  M(6) = M(6) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,101),T4sum(1:70,75))
  M(19) = M(19) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,101),T4sum(1:70,75))
  M(20) = M(20) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_2,G4tensor(:,101),T4sum(1:70,75))
  M(1) = M(1) + (CI*f(2) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(364)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(19) = M(19) + (-f(3) * den(176)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,47),T4sum(1:70,10))
  M(20) = M(20) + (f(3) * den(176)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,47),T4sum(1:70,10))
  M(22) = M(22) + (f(3) * den(176)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,47),T4sum(1:70,10))
  M(24) = M(24) + (-f(3) * den(176)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,47),T4sum(1:70,10))
  M(1) = M(1) + (-f(3) * den(176)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(3) = M(3) + (f(3) * den(176)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(9) = M(9) + (f(3) * den(176)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(15) = M(15) + (-f(3) * den(176)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(2) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(365)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(1) = M(1) + (-f(3) * den(86)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,48),T4sum(1:70,1))
  M(3) = M(3) + (f(3) * den(86)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,48),T4sum(1:70,1))
  M(5) = M(5) + (f(3) * den(86)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,48),T4sum(1:70,1))
  M(6) = M(6) + (-f(3) * den(86)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,48),T4sum(1:70,1))
  M(10) = M(10) + (-f(3) * den(86)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,7),T4sum(1:70,2))
  M(16) = M(16) + (f(3) * den(86)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,7),T4sum(1:70,2))
  M(22) = M(22) + (f(3) * den(86)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,7),T4sum(1:70,2))
  M(24) = M(24) + (-f(3) * den(86)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(2) * den(51)) * TI2_call(5,momenta_120,masses2_3,G5tensor(:,23),T5sum(1:126,61))
  M(3) = M(3) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_120,masses2_3,G5tensor(:,23),T5sum(1:126,61))
  M(5) = M(5) + (CI*f(2) * den(51)) * TI2_call(5,momenta_114,masses2_3,G5tensor(:,33),T5sum(1:126,62))
  M(6) = M(6) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_114,masses2_3,G5tensor(:,33),T5sum(1:126,62))
  M(22) = M(22) + (CI*f(2) * den(51)) * TI2_call(5,momenta_93,masses2_3,G5tensor(:,1),T5sum(1:126,63))
  M(24) = M(24) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_93,masses2_3,G5tensor(:,1),T5sum(1:126,63))
  M(19) = M(19) + (CI*f(2) * den(51)) * TI2_call(5,momenta_113,masses2_3,G5tensor(:,34),T5sum(1:126,64))
  M(20) = M(20) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_113,masses2_3,G5tensor(:,34),T5sum(1:126,64))
  M(10) = M(10) + (CI*f(2) * den(51)) * TI2_call(5,momenta_94,masses2_3,G5tensor(:,2),T5sum(1:126,65))
  M(16) = M(16) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_94,masses2_3,G5tensor(:,2),T5sum(1:126,65))
  M(9) = M(9) + (CI*f(2) * den(51)) * TI2_call(5,momenta_115,masses2_3,G5tensor(:,24),T5sum(1:126,66))
  M(15) = M(15) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_115,masses2_3,G5tensor(:,24),T5sum(1:126,66))
  M(1) = M(1) + (CI*f(2) * den(51)) * TI2_call(5,momenta_210,masses2_3,G5tensor(:,63),T5sum(1:126,71))
  M(3) = M(3) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_210,masses2_3,G5tensor(:,63),T5sum(1:126,71))
  M(22) = M(22) + (CI*f(2) * den(51)) * TI2_call(5,momenta_210,masses2_3,G5tensor(:,61),T5sum(1:126,71))
  M(24) = M(24) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_210,masses2_3,G5tensor(:,61),T5sum(1:126,71))
  M(10) = M(10) + (CI*f(2) * den(51)) * TI2_call(5,momenta_209,masses2_3,G5tensor(:,64),T5sum(1:126,72))
  M(16) = M(16) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_209,masses2_3,G5tensor(:,64),T5sum(1:126,72))
  M(5) = M(5) + (CI*f(2) * den(51)) * TI2_call(5,momenta_209,masses2_3,G5tensor(:,62),T5sum(1:126,72))
  M(6) = M(6) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_209,masses2_3,G5tensor(:,62),T5sum(1:126,72))
  M(5) = M(5) + (CI*f(2) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(376)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(14) = M(14) + (f(3) * den(156)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,49),T4sum(1:70,7))
  M(15) = M(15) + (-f(3) * den(156)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,49),T4sum(1:70,7))
  M(16) = M(16) + (f(3) * den(156)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,49),T4sum(1:70,7))
  M(17) = M(17) + (-f(3) * den(156)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,49),T4sum(1:70,7))
  M(5) = M(5) + (f(3) * den(156)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,26),T4sum(1:70,8))
  M(8) = M(8) + (-f(3) * den(156)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,26),T4sum(1:70,8))
  M(11) = M(11) + (f(3) * den(156)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,26),T4sum(1:70,8))
  M(19) = M(19) + (-f(3) * den(156)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,26),T4sum(1:70,8))
  M(6) = M(6) + (CI*f(2) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(377)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(8) = M(8) + (f(3) * den(117)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,50),T4sum(1:70,4))
  M(9) = M(9) + (-f(3) * den(117)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,50),T4sum(1:70,4))
  M(10) = M(10) + (f(3) * den(117)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,50),T4sum(1:70,4))
  M(11) = M(11) + (-f(3) * den(117)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,50),T4sum(1:70,4))
  M(6) = M(6) + (f(3) * den(117)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,5))
  M(14) = M(14) + (-f(3) * den(117)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,5))
  M(17) = M(17) + (f(3) * den(117)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,5))
  M(20) = M(20) + (-f(3) * den(117)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,5))
  M(8) = M(8) + (CI*f(2) * den(42)) * TI2_call(5,momenta_109,masses2_3,G5tensor(:,15),T5sum(1:126,85))
  M(11) = M(11) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_109,masses2_3,G5tensor(:,15),T5sum(1:126,85))
  M(9) = M(9) + (CI*f(2) * den(42)) * TI2_call(5,momenta_122,masses2_3,G5tensor(:,35),T5sum(1:126,86))
  M(10) = M(10) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_122,masses2_3,G5tensor(:,35),T5sum(1:126,86))
  M(14) = M(14) + (CI*f(2) * den(42)) * TI2_call(5,momenta_101,masses2_3,G5tensor(:,9),T5sum(1:126,87))
  M(17) = M(17) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_101,masses2_3,G5tensor(:,9),T5sum(1:126,87))
  M(15) = M(15) + (CI*f(2) * den(42)) * TI2_call(5,momenta_121,masses2_3,G5tensor(:,36),T5sum(1:126,88))
  M(16) = M(16) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_121,masses2_3,G5tensor(:,36),T5sum(1:126,88))
  M(6) = M(6) + (CI*f(2) * den(42)) * TI2_call(5,momenta_98,masses2_3,G5tensor(:,10),T5sum(1:126,89))
  M(20) = M(20) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_98,masses2_3,G5tensor(:,10),T5sum(1:126,89))
  M(5) = M(5) + (CI*f(2) * den(42)) * TI2_call(5,momenta_106,masses2_3,G5tensor(:,16),T5sum(1:126,90))
  M(19) = M(19) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_106,masses2_3,G5tensor(:,16),T5sum(1:126,90))
  M(2) = M(2) + (-(CI*f(2)) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(382)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(13) = M(13) + (-f(3) * den(160)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(14) = M(14) + (f(3) * den(160)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(16) = M(16) + (f(3) * den(160)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(18) = M(18) + (-f(3) * den(160)) * TI2_call(4,momenta_26,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(2) = M(2) + (-f(3) * den(160)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,27),T4sum(1:70,8))
  M(5) = M(5) + (f(3) * den(160)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,27),T4sum(1:70,8))
  M(11) = M(11) + (f(3) * den(160)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,27),T4sum(1:70,8))
  M(21) = M(21) + (-f(3) * den(160)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,27),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(2)) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(383)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(2) = M(2) + (f(3) * den(91)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,52),T4sum(1:70,1))
  M(3) = M(3) + (-f(3) * den(91)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,52),T4sum(1:70,1))
  M(4) = M(4) + (f(3) * den(91)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,52),T4sum(1:70,1))
  M(5) = M(5) + (-f(3) * den(91)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,52),T4sum(1:70,1))
  M(12) = M(12) + (f(3) * den(91)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(16) = M(16) + (-f(3) * den(91)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(18) = M(18) + (f(3) * den(91)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(22) = M(22) + (-f(3) * den(91)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(2) * den(55)) * TI2_call(5,momenta_110,masses2_3,G5tensor(:,17),T5sum(1:126,97))
  M(5) = M(5) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_110,masses2_3,G5tensor(:,17),T5sum(1:126,97))
  M(3) = M(3) + (CI*f(2) * den(55)) * TI2_call(5,momenta_124,masses2_3,G5tensor(:,29),T5sum(1:126,98))
  M(4) = M(4) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_124,masses2_3,G5tensor(:,29),T5sum(1:126,98))
  M(16) = M(16) + (CI*f(2) * den(55)) * TI2_call(5,momenta_95,masses2_3,G5tensor(:,3),T5sum(1:126,99))
  M(18) = M(18) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_95,masses2_3,G5tensor(:,3),T5sum(1:126,99))
  M(13) = M(13) + (CI*f(2) * den(55)) * TI2_call(5,momenta_123,masses2_3,G5tensor(:,30),T5sum(1:126,100))
  M(14) = M(14) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_123,masses2_3,G5tensor(:,30),T5sum(1:126,100))
  M(12) = M(12) + (CI*f(2) * den(55)) * TI2_call(5,momenta_92,masses2_3,G5tensor(:,4),T5sum(1:126,101))
  M(22) = M(22) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_92,masses2_3,G5tensor(:,4),T5sum(1:126,101))
  M(11) = M(11) + (CI*f(2) * den(55)) * TI2_call(5,momenta_105,masses2_3,G5tensor(:,18),T5sum(1:126,102))
  M(21) = M(21) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_105,masses2_3,G5tensor(:,18),T5sum(1:126,102))
  M(4) = M(4) + (-(CI*f(2)) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(388)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(389)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,6))
  M(7) = M(7) + (-f(3) * den(121)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,53),T4sum(1:70,4))
  M(8) = M(8) + (f(3) * den(121)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,53),T4sum(1:70,4))
  M(10) = M(10) + (f(3) * den(121)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,53),T4sum(1:70,4))
  M(12) = M(12) + (-f(3) * den(121)) * TI2_call(4,momenta_28,masses2_2,G4tensor(:,53),T4sum(1:70,4))
  M(4) = M(4) + (-f(3) * den(121)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,5))
  M(6) = M(6) + (f(3) * den(121)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,5))
  M(17) = M(17) + (f(3) * den(121)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,5))
  M(23) = M(23) + (-f(3) * den(121)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,5))
  M(1) = M(1) + (-f(3) * den(95)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,54),T4sum(1:70,1))
  M(2) = M(2) + (f(3) * den(95)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,54),T4sum(1:70,1))
  M(4) = M(4) + (f(3) * den(95)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,54),T4sum(1:70,1))
  M(6) = M(6) + (-f(3) * den(95)) * TI2_call(4,momenta_29,masses2_2,G4tensor(:,54),T4sum(1:70,1))
  M(10) = M(10) + (-f(3) * den(95)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(12) = M(12) + (f(3) * den(95)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(18) = M(18) + (f(3) * den(95)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(24) = M(24) + (-f(3) * den(95)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(4) = M(4) + (CI*f(2) * den(61)) * TI2_call(5,momenta_102,masses2_3,G5tensor(:,11),T5sum(1:126,109))
  M(6) = M(6) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_102,masses2_3,G5tensor(:,11),T5sum(1:126,109))
  M(1) = M(1) + (CI*f(2) * den(61)) * TI2_call(5,momenta_126,masses2_3,G5tensor(:,25),T5sum(1:126,110))
  M(2) = M(2) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_126,masses2_3,G5tensor(:,25),T5sum(1:126,110))
  M(10) = M(10) + (CI*f(2) * den(61)) * TI2_call(5,momenta_96,masses2_3,G5tensor(:,5),T5sum(1:126,111))
  M(12) = M(12) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_96,masses2_3,G5tensor(:,5),T5sum(1:126,111))
  M(7) = M(7) + (CI*f(2) * den(61)) * TI2_call(5,momenta_125,masses2_3,G5tensor(:,26),T5sum(1:126,112))
  M(8) = M(8) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_125,masses2_3,G5tensor(:,26),T5sum(1:126,112))
  M(18) = M(18) + (CI*f(2) * den(61)) * TI2_call(5,momenta_91,masses2_3,G5tensor(:,6),T5sum(1:126,113))
  M(24) = M(24) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_91,masses2_3,G5tensor(:,6),T5sum(1:126,113))
  M(17) = M(17) + (CI*f(2) * den(61)) * TI2_call(5,momenta_97,masses2_3,G5tensor(:,12),T5sum(1:126,114))
  M(23) = M(23) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_97,masses2_3,G5tensor(:,12),T5sum(1:126,114))
  M(4) = M(4) + (-f(3)) * TI2_call(6,momenta_222,masses2_4,G6tensor(:,7),T6sum(1:210,1))
  M(6) = M(6) + (-f(3)) * TI2_call(6,momenta_220,masses2_4,G6tensor(:,9),T6sum(1:210,2))
  M(2) = M(2) + (-f(3)) * TI2_call(6,momenta_228,masses2_4,G6tensor(:,13),T6sum(1:210,3))
  M(5) = M(5) + (-f(3)) * TI2_call(6,momenta_226,masses2_4,G6tensor(:,15),T6sum(1:210,4))
  M(1) = M(1) + (-f(3)) * TI2_call(6,momenta_234,masses2_4,G6tensor(:,19),T6sum(1:210,5))
  M(3) = M(3) + (-f(3)) * TI2_call(6,momenta_232,masses2_4,G6tensor(:,21),T6sum(1:210,6))
  M(12) = M(12) + (-f(3)) * TI2_call(6,momenta_214,masses2_4,G6tensor(:,3),T6sum(1:210,7))
  M(10) = M(10) + (-f(3)) * TI2_call(6,momenta_216,masses2_4,G6tensor(:,1),T6sum(1:210,8))
  M(8) = M(8) + (-f(3)) * TI2_call(6,momenta_227,masses2_4,G6tensor(:,14),T6sum(1:210,9))
  M(11) = M(11) + (-f(3)) * TI2_call(6,momenta_224,masses2_4,G6tensor(:,17),T6sum(1:210,10))
  M(7) = M(7) + (-f(3)) * TI2_call(6,momenta_233,masses2_4,G6tensor(:,20),T6sum(1:210,11))
  M(9) = M(9) + (-f(3)) * TI2_call(6,momenta_230,masses2_4,G6tensor(:,23),T6sum(1:210,12))
  M(18) = M(18) + (-f(3)) * TI2_call(6,momenta_212,masses2_4,G6tensor(:,5),T6sum(1:210,13))
  M(16) = M(16) + (-f(3)) * TI2_call(6,momenta_215,masses2_4,G6tensor(:,2),T6sum(1:210,14))
  M(17) = M(17) + (-f(3)) * TI2_call(6,momenta_218,masses2_4,G6tensor(:,11),T6sum(1:210,15))
  M(14) = M(14) + (-f(3)) * TI2_call(6,momenta_221,masses2_4,G6tensor(:,8),T6sum(1:210,16))
  M(13) = M(13) + (-f(3)) * TI2_call(6,momenta_231,masses2_4,G6tensor(:,22),T6sum(1:210,17))
  M(15) = M(15) + (-f(3)) * TI2_call(6,momenta_229,masses2_4,G6tensor(:,24),T6sum(1:210,18))
  M(24) = M(24) + (-f(3)) * TI2_call(6,momenta_211,masses2_4,G6tensor(:,6),T6sum(1:210,19))
  M(22) = M(22) + (-f(3)) * TI2_call(6,momenta_213,masses2_4,G6tensor(:,4),T6sum(1:210,20))
  M(23) = M(23) + (-f(3)) * TI2_call(6,momenta_217,masses2_4,G6tensor(:,12),T6sum(1:210,21))
  M(20) = M(20) + (-f(3)) * TI2_call(6,momenta_219,masses2_4,G6tensor(:,10),T6sum(1:210,22))
  M(21) = M(21) + (-f(3)) * TI2_call(6,momenta_223,masses2_4,G6tensor(:,18),T6sum(1:210,23))
  M(19) = M(19) + (-f(3)) * TI2_call(6,momenta_225,masses2_4,G6tensor(:,16),T6sum(1:210,24))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)
  deallocate(G6tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_4_pphjjj2_hggggg_1_/**/REALKIND
