
module ol_vamp_3_pphjjj2_hggggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G6tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,19) :: G0
  complex(REALKIND), dimension(4,5,4,192) :: G1
  complex(REALKIND), dimension(4,15,4,426) :: G2
  complex(REALKIND), dimension(4,35,4,264) :: G3
  complex(REALKIND), dimension(4,70,4,120) :: G4
  complex(REALKIND), dimension(4,126,4,24) :: G5
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
  complex(REALKIND), pointer :: G6tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,126,32))
    allocate(G4tensorhel(70,78,32))
    allocate(G5tensorhel(126,48,32))
    allocate(G6tensorhel(210,12,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)
  G6tensor => G6tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,214),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,62),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,215),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,62),MB,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,216),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,62),MB,G2(:,:,:,5))
  call loop_AS_Q(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,244),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),MB,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,245),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,62),MB,G2(:,:,:,9))
  call loop_AS_Q(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,246),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,62),MB,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,0),G2(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,271),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),MB,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,272),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),MB,G2(:,:,:,15))
  call loop_AS_Q(G2(:,:,:,15),wf(:,0),G2(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,273),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,62),MB,G2(:,:,:,17))
  call loop_AS_Q(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,277),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,62),MB,G2(:,:,:,19))
  call loop_AS_Q(G2(:,:,:,19),wf(:,0),G2(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,278),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MB,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,279),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,62),MB,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,0),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,18),MB,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,30),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,62),MB,G3(:,:,:,1))
  call loop_AS_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,25),wf(:,32),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,62),MB,G3(:,:,:,3))
  call loop_AS_Q(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MB,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,25),wf(:,33),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,62),MB,G3(:,:,:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,25),wf(:,183),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,62),MB,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,25),wf(:,65),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,30),MB,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,62),MB,G4(:,:,:,1))
  call loop_AS_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MB,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,25),wf(:,191),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,62),MB,G3(:,:,:,11))
  call loop_AS_Q(G3(:,:,:,11),wf(:,0),G3(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,26),MB,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,84),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,62),MB,G4(:,:,:,3))
  call loop_AS_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MB,G5tensor(:,2))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,30),MB,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,-5),G4(:,:,:,6))
  call loop_A_Q(G4(:,:,:,6),Q(:,62),MB,G5(:,:,:,1))
  call loop_AS_Q(G5(:,:,:,1),wf(:,0),G5(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,2),Q(:,63),MB,G6tensor(:,1))
  call loop_AV_Q(G2(:,:,:,25),wf(:,193),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,62),MB,G3(:,:,:,16))
  call loop_AS_Q(G3(:,:,:,16),wf(:,0),G3(:,:,:,17),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,63),MB,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,22),MB,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,109),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,62),MB,G4(:,:,:,7))
  call loop_AS_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MB,G5tensor(:,3))
  call loop_AV_Q(G3(:,:,:,18),wf(:,-3),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,30),MB,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,-5),G4(:,:,:,10))
  call loop_A_Q(G4(:,:,:,10),Q(:,62),MB,G5(:,:,:,3))
  call loop_AS_Q(G5(:,:,:,3),wf(:,0),G5(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,4),Q(:,63),MB,G6tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,289),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MB,G2(:,:,:,35))
  call loop_AS_Q(G2(:,:,:,35),wf(:,0),G2(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,63),MB,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,290),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,62),MB,G2(:,:,:,37))
  call loop_AS_Q(G2(:,:,:,37),wf(:,0),G2(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,291),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MB,G2(:,:,:,39))
  call loop_AS_Q(G2(:,:,:,39),wf(:,0),G2(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,316),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),MB,G2(:,:,:,41))
  call loop_AS_Q(G2(:,:,:,41),wf(:,0),G2(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,317),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),MB,G2(:,:,:,43))
  call loop_AS_Q(G2(:,:,:,43),wf(:,0),G2(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,63),MB,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,318),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,62),MB,G2(:,:,:,45))
  call loop_AS_Q(G2(:,:,:,45),wf(:,0),G2(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,322),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,62),MB,G2(:,:,:,47))
  call loop_AS_Q(G2(:,:,:,47),wf(:,0),G2(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MB,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,1),wf(:,323),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,62),MB,G2(:,:,:,49))
  call loop_AS_Q(G2(:,:,:,49),wf(:,0),G2(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,1),wf(:,324),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,62),MB,G2(:,:,:,51))
  call loop_AS_Q(G2(:,:,:,51),wf(:,0),G2(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,20),MB,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,77),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,62),MB,G3(:,:,:,21))
  call loop_AS_Q(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,53),wf(:,79),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,62),MB,G3(:,:,:,23))
  call loop_AS_Q(G3(:,:,:,23),wf(:,0),G3(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,53),wf(:,80),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,62),MB,G3(:,:,:,25))
  call loop_AS_Q(G3(:,:,:,25),wf(:,0),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,9))
  call loop_AV_Q(G2(:,:,:,53),wf(:,176),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,62),MB,G3(:,:,:,27))
  call loop_AS_Q(G3(:,:,:,27),wf(:,0),G3(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,53),wf(:,18),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,30),MB,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,62),MB,G4(:,:,:,11))
  call loop_AS_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,63),MB,G5tensor(:,4))
  call loop_AV_Q(G2(:,:,:,53),wf(:,196),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,62),MB,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-3),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,28),MB,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,37),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,62),MB,G4(:,:,:,13))
  call loop_AS_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,63),MB,G5tensor(:,5))
  call loop_AV_Q(G3(:,:,:,33),wf(:,-1),G3(:,:,:,35))
  call loop_A_Q(G3(:,:,:,35),Q(:,30),MB,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,-5),G4(:,:,:,16))
  call loop_A_Q(G4(:,:,:,16),Q(:,62),MB,G5(:,:,:,5))
  call loop_AS_Q(G5(:,:,:,5),wf(:,0),G5(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,6),Q(:,63),MB,G6tensor(:,3))
  call loop_AV_Q(G2(:,:,:,53),wf(:,197),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,62),MB,G3(:,:,:,36))
  call loop_AS_Q(G3(:,:,:,36),wf(:,0),G3(:,:,:,37),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,63),MB,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-1),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,22),MB,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,109),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,62),MB,G4(:,:,:,17))
  call loop_AS_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,6))
  call loop_AV_Q(G3(:,:,:,38),wf(:,-3),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,30),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,-5),G4(:,:,:,20))
  call loop_A_Q(G4(:,:,:,20),Q(:,62),MB,G5(:,:,:,7))
  call loop_AS_Q(G5(:,:,:,7),wf(:,0),G5(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,8),Q(:,63),MB,G6tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,337),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,62),MB,G2(:,:,:,63))
  call loop_AS_Q(G2(:,:,:,63),wf(:,0),G2(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MB,G3tensor(:,22))
  call loop_AV_Q(G1(:,:,:,1),wf(:,338),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),MB,G2(:,:,:,65))
  call loop_AS_Q(G2(:,:,:,65),wf(:,0),G2(:,:,:,66),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,1),wf(:,339),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,62),MB,G2(:,:,:,67))
  call loop_AS_Q(G2(:,:,:,67),wf(:,0),G2(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,343),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,62),MB,G2(:,:,:,69))
  call loop_AS_Q(G2(:,:,:,69),wf(:,0),G2(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,344),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,62),MB,G2(:,:,:,71))
  call loop_AS_Q(G2(:,:,:,71),wf(:,0),G2(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,26))
  call loop_AV_Q(G1(:,:,:,1),wf(:,345),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,62),MB,G2(:,:,:,73))
  call loop_AS_Q(G2(:,:,:,73),wf(:,0),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,24),MB,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,102),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,62),MB,G3(:,:,:,41))
  call loop_AS_Q(G3(:,:,:,41),wf(:,0),G3(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,13))
  call loop_AV_Q(G2(:,:,:,75),wf(:,104),G2(:,:,:,77))
  call loop_A_Q(G2(:,:,:,77),Q(:,62),MB,G3(:,:,:,43))
  call loop_AS_Q(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,75),wf(:,105),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,62),MB,G3(:,:,:,45))
  call loop_AS_Q(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),MB,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,75),wf(:,167),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,62),MB,G3(:,:,:,47))
  call loop_AS_Q(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,75),wf(:,1),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,30),MB,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,-5),G3(:,:,:,50))
  call loop_A_Q(G3(:,:,:,50),Q(:,62),MB,G4(:,:,:,21))
  call loop_AS_Q(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,75),wf(:,200),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,62),MB,G3(:,:,:,51))
  call loop_AS_Q(G3(:,:,:,51),wf(:,0),G3(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),MB,G4tensor(:,17))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-2),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,28),MB,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,37),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,62),MB,G4(:,:,:,23))
  call loop_AS_Q(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,8))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-1),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,30),MB,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,-5),G4(:,:,:,26))
  call loop_A_Q(G4(:,:,:,26),Q(:,62),MB,G5(:,:,:,9))
  call loop_AS_Q(G5(:,:,:,9),wf(:,0),G5(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,10),Q(:,63),MB,G6tensor(:,5))
  call loop_AV_Q(G2(:,:,:,75),wf(:,202),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,62),MB,G3(:,:,:,56))
  call loop_AS_Q(G3(:,:,:,56),wf(:,0),G3(:,:,:,57),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,63),MB,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-1),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,26),MB,G3(:,:,:,58))
  call loop_AV_Q(G3(:,:,:,58),wf(:,84),G3(:,:,:,59))
  call loop_A_Q(G3(:,:,:,59),Q(:,62),MB,G4(:,:,:,27))
  call loop_AS_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,9))
  call loop_AV_Q(G3(:,:,:,58),wf(:,-2),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,30),MB,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,-5),G4(:,:,:,30))
  call loop_A_Q(G4(:,:,:,30),Q(:,62),MB,G5(:,:,:,11))
  call loop_AS_Q(G5(:,:,:,11),wf(:,0),G5(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,12),Q(:,63),MB,G6tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,358),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,62),MB,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,0),G2(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),MB,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,1),wf(:,359),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,62),MB,G2(:,:,:,87))
  call loop_AS_Q(G2(:,:,:,87),wf(:,0),G2(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,1),wf(:,360),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,62),MB,G2(:,:,:,89))
  call loop_AS_Q(G2(:,:,:,89),wf(:,0),G2(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,1),wf(:,120),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,30),MB,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,62),MB,G3(:,:,:,61))
  call loop_AS_Q(G3(:,:,:,61),wf(:,0),G3(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,63),MB,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,1),wf(:,122),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,30),MB,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,62),MB,G3(:,:,:,63))
  call loop_AS_Q(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,20))
  call loop_AV_Q(G1(:,:,:,1),wf(:,123),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,30),MB,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,62),MB,G3(:,:,:,65))
  call loop_AS_Q(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),MB,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,1),wf(:,362),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,62),MB,G2(:,:,:,97))
  call loop_AS_Q(G2(:,:,:,97),wf(:,0),G2(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),MB,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,22),MB,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,109),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,62),MB,G3(:,:,:,67))
  call loop_AS_Q(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,63),MB,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-3),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,30),MB,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,62),MB,G4(:,:,:,31))
  call loop_AS_Q(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,365),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,62),MB,G2(:,:,:,102))
  call loop_AS_Q(G2(:,:,:,102),wf(:,0),G2(:,:,:,103),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,63),MB,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,1),wf(:,172),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,30),MB,G2(:,:,:,104))
  call loop_AV_Q(G2(:,:,:,104),wf(:,-5),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,62),MB,G3(:,:,:,71))
  call loop_AS_Q(G3(:,:,:,71),wf(:,0),G3(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),MB,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,1),wf(:,368),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,62),MB,G2(:,:,:,106))
  call loop_AS_Q(G2(:,:,:,106),wf(:,0),G2(:,:,:,107),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,63),MB,G3tensor(:,33))
  call loop_AV_Q(G1(:,:,:,1),wf(:,371),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,62),MB,G2(:,:,:,108))
  call loop_AS_Q(G2(:,:,:,108),wf(:,0),G2(:,:,:,109),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,18),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,26),MB,G2(:,:,:,110))
  call loop_AV_Q(G2(:,:,:,110),wf(:,84),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,62),MB,G3(:,:,:,73))
  call loop_AS_Q(G3(:,:,:,73),wf(:,0),G3(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,63),MB,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-2),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,30),MB,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-5),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,62),MB,G4(:,:,:,33))
  call loop_AS_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MB,G5tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,374),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,62),MB,G2(:,:,:,113))
  call loop_AS_Q(G2(:,:,:,113),wf(:,0),G2(:,:,:,114),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),MB,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,1),wf(:,181),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,30),MB,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),MB,G3(:,:,:,77))
  call loop_AS_Q(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,63),MB,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,377),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,62),MB,G2(:,:,:,117))
  call loop_AS_Q(G2(:,:,:,117),wf(:,0),G2(:,:,:,118),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),MB,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,1),wf(:,380),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,62),MB,G2(:,:,:,119))
  call loop_AS_Q(G2(:,:,:,119),wf(:,0),G2(:,:,:,120),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,63),MB,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,1),wf(:,65),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,28),MB,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,37),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,62),MB,G3(:,:,:,79))
  call loop_AS_Q(G3(:,:,:,79),wf(:,0),G3(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,63),MB,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-1),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,30),MB,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-5),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,62),MB,G4(:,:,:,35))
  call loop_AS_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),MB,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,383),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,62),MB,G2(:,:,:,124))
  call loop_AS_Q(G2(:,:,:,124),wf(:,0),G2(:,:,:,125),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,125),Q(:,63),MB,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,1),wf(:,189),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,30),MB,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-5),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,62),MB,G3(:,:,:,83))
  call loop_AS_Q(G3(:,:,:,83),wf(:,0),G3(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,385),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,62),MB,G2(:,:,:,128))
  call loop_AS_Q(G2(:,:,:,128),wf(:,0),G2(:,:,:,129),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),MB,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,1),wf(:,412),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,62),MB,G2(:,:,:,130))
  call loop_AS_Q(G2(:,:,:,130),wf(:,0),G2(:,:,:,131),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,63),MB,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,414),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,62),MB,G2(:,:,:,132))
  call loop_AS_Q(G2(:,:,:,132),wf(:,0),G2(:,:,:,133),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,1),wf(:,418),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,62),MB,G2(:,:,:,134))
  call loop_AS_Q(G2(:,:,:,134),wf(:,0),G2(:,:,:,135),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,1),wf(:,420),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,62),MB,G2(:,:,:,136))
  call loop_AS_Q(G2(:,:,:,136),wf(:,0),G2(:,:,:,137),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,1),wf(:,424),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,62),MB,G2(:,:,:,138))
  call loop_AS_Q(G2(:,:,:,138),wf(:,0),G2(:,:,:,139),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,63),MB,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,1),wf(:,425),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,62),MB,G2(:,:,:,140))
  call loop_AS_Q(G2(:,:,:,140),wf(:,0),G2(:,:,:,141),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,63),MB,G3tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MB,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,214),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,62),MB,G2(:,:,:,142))
  call loop_QS_A(G2(:,:,:,142),wf(:,0),G2(:,:,:,143),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),MB,G3tensor(:,46))
  call loop_QV_A(G1(:,:,:,59),wf(:,215),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,62),MB,G2(:,:,:,144))
  call loop_QS_A(G2(:,:,:,144),wf(:,0),G2(:,:,:,145),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),MB,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,59),wf(:,216),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,62),MB,G2(:,:,:,146))
  call loop_QS_A(G2(:,:,:,146),wf(:,0),G2(:,:,:,147),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),MB,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,59),wf(:,244),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,62),MB,G2(:,:,:,148))
  call loop_QS_A(G2(:,:,:,148),wf(:,0),G2(:,:,:,149),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,63),MB,G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,59),wf(:,245),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,62),MB,G2(:,:,:,150))
  call loop_QS_A(G2(:,:,:,150),wf(:,0),G2(:,:,:,151),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,63),MB,G3tensor(:,50))
  call loop_QV_A(G1(:,:,:,59),wf(:,246),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,62),MB,G2(:,:,:,152))
  call loop_QS_A(G2(:,:,:,152),wf(:,0),G2(:,:,:,153),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,63),MB,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,59),wf(:,271),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,62),MB,G2(:,:,:,154))
  call loop_QS_A(G2(:,:,:,154),wf(:,0),G2(:,:,:,155),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,155),Q(:,63),MB,G3tensor(:,52))
  call loop_QV_A(G1(:,:,:,59),wf(:,272),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,62),MB,G2(:,:,:,156))
  call loop_QS_A(G2(:,:,:,156),wf(:,0),G2(:,:,:,157),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,157),Q(:,63),MB,G3tensor(:,53))
  call loop_QV_A(G1(:,:,:,59),wf(:,273),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,62),MB,G2(:,:,:,158))
  call loop_QS_A(G2(:,:,:,158),wf(:,0),G2(:,:,:,159),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G1(:,:,:,59),wf(:,277),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,62),MB,G2(:,:,:,160))
  call loop_QS_A(G2(:,:,:,160),wf(:,0),G2(:,:,:,161),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,63),MB,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,59),wf(:,278),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,62),MB,G2(:,:,:,162))
  call loop_QS_A(G2(:,:,:,162),wf(:,0),G2(:,:,:,163),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,63),MB,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,59),wf(:,279),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,62),MB,G2(:,:,:,164))
  call loop_QS_A(G2(:,:,:,164),wf(:,0),G2(:,:,:,165),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,63),MB,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,59),wf(:,-1),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,18),MB,G2(:,:,:,166))
  call loop_QV_A(G2(:,:,:,166),wf(:,30),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,62),MB,G3(:,:,:,85))
  call loop_QS_A(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),MB,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,166),wf(:,32),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,62),MB,G3(:,:,:,87))
  call loop_QS_A(G3(:,:,:,87),wf(:,0),G3(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,29))
  call loop_QV_A(G2(:,:,:,166),wf(:,33),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,62),MB,G3(:,:,:,89))
  call loop_QS_A(G3(:,:,:,89),wf(:,0),G3(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,63),MB,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,166),wf(:,183),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,62),MB,G3(:,:,:,91))
  call loop_QS_A(G3(:,:,:,91),wf(:,0),G3(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),MB,G4tensor(:,31))
  call loop_QV_A(G2(:,:,:,166),wf(:,65),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,30),MB,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-5),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,62),MB,G4(:,:,:,37))
  call loop_QS_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MB,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,166),wf(:,191),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,62),MB,G3(:,:,:,95))
  call loop_QS_A(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MB,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,166),wf(:,-3),G2(:,:,:,173))
  call loop_Q_A(G2(:,:,:,173),Q(:,26),MB,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,84),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,62),MB,G4(:,:,:,39))
  call loop_QS_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MB,G5tensor(:,14))
  call loop_QV_A(G3(:,:,:,97),wf(:,-2),G3(:,:,:,99))
  call loop_Q_A(G3(:,:,:,99),Q(:,30),MB,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,-5),G4(:,:,:,42))
  call loop_Q_A(G4(:,:,:,42),Q(:,62),MB,G5(:,:,:,13))
  call loop_QS_A(G5(:,:,:,13),wf(:,0),G5(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,14),Q(:,63),MB,G6tensor(:,7))
  call loop_QV_A(G2(:,:,:,166),wf(:,193),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,62),MB,G3(:,:,:,100))
  call loop_QS_A(G3(:,:,:,100),wf(:,0),G3(:,:,:,101),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,63),MB,G4tensor(:,33))
  call loop_QV_A(G2(:,:,:,166),wf(:,-2),G2(:,:,:,175))
  call loop_Q_A(G2(:,:,:,175),Q(:,22),MB,G3(:,:,:,102))
  call loop_QV_A(G3(:,:,:,102),wf(:,109),G3(:,:,:,103))
  call loop_Q_A(G3(:,:,:,103),Q(:,62),MB,G4(:,:,:,43))
  call loop_QS_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,63),MB,G5tensor(:,15))
  call loop_QV_A(G3(:,:,:,102),wf(:,-3),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,30),MB,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,-5),G4(:,:,:,46))
  call loop_Q_A(G4(:,:,:,46),Q(:,62),MB,G5(:,:,:,15))
  call loop_QS_A(G5(:,:,:,15),wf(:,0),G5(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,16),Q(:,63),MB,G6tensor(:,8))
  call loop_QV_A(G1(:,:,:,59),wf(:,289),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,62),MB,G2(:,:,:,176))
  call loop_QS_A(G2(:,:,:,176),wf(:,0),G2(:,:,:,177),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,177),Q(:,63),MB,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,59),wf(:,290),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,62),MB,G2(:,:,:,178))
  call loop_QS_A(G2(:,:,:,178),wf(:,0),G2(:,:,:,179),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,179),Q(:,63),MB,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,291),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,62),MB,G2(:,:,:,180))
  call loop_QS_A(G2(:,:,:,180),wf(:,0),G2(:,:,:,181),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,181),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,59),wf(:,316),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,62),MB,G2(:,:,:,182))
  call loop_QS_A(G2(:,:,:,182),wf(:,0),G2(:,:,:,183),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,183),Q(:,63),MB,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,59),wf(:,317),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,62),MB,G2(:,:,:,184))
  call loop_QS_A(G2(:,:,:,184),wf(:,0),G2(:,:,:,185),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,185),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,59),wf(:,318),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,62),MB,G2(:,:,:,186))
  call loop_QS_A(G2(:,:,:,186),wf(:,0),G2(:,:,:,187),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,187),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,59),wf(:,322),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,62),MB,G2(:,:,:,188))
  call loop_QS_A(G2(:,:,:,188),wf(:,0),G2(:,:,:,189),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,189),Q(:,63),MB,G3tensor(:,64))
  call loop_QV_A(G1(:,:,:,59),wf(:,323),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,62),MB,G2(:,:,:,190))
  call loop_QS_A(G2(:,:,:,190),wf(:,0),G2(:,:,:,191),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,191),Q(:,63),MB,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,59),wf(:,324),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,62),MB,G2(:,:,:,192))
  call loop_QS_A(G2(:,:,:,192),wf(:,0),G2(:,:,:,193),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,193),Q(:,63),MB,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,59),wf(:,-2),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,20),MB,G2(:,:,:,194))
  call loop_QV_A(G2(:,:,:,194),wf(:,77),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,62),MB,G3(:,:,:,105))
  call loop_QS_A(G3(:,:,:,105),wf(:,0),G3(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,63),MB,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,194),wf(:,79),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,62),MB,G3(:,:,:,107))
  call loop_QS_A(G3(:,:,:,107),wf(:,0),G3(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,63),MB,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,194),wf(:,80),G2(:,:,:,197))
  call loop_Q_A(G2(:,:,:,197),Q(:,62),MB,G3(:,:,:,109))
  call loop_QS_A(G3(:,:,:,109),wf(:,0),G3(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MB,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,194),wf(:,176),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,62),MB,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,0),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,194),wf(:,18),G2(:,:,:,199))
  call loop_Q_A(G2(:,:,:,199),Q(:,30),MB,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-5),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,62),MB,G4(:,:,:,47))
  call loop_QS_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,63),MB,G5tensor(:,16))
  call loop_QV_A(G2(:,:,:,194),wf(:,196),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,62),MB,G3(:,:,:,115))
  call loop_QS_A(G3(:,:,:,115),wf(:,0),G3(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,63),MB,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,194),wf(:,-3),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,28),MB,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,37),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,62),MB,G4(:,:,:,49))
  call loop_QS_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MB,G5tensor(:,17))
  call loop_QV_A(G3(:,:,:,117),wf(:,-1),G3(:,:,:,119))
  call loop_Q_A(G3(:,:,:,119),Q(:,30),MB,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,-5),G4(:,:,:,52))
  call loop_Q_A(G4(:,:,:,52),Q(:,62),MB,G5(:,:,:,17))
  call loop_QS_A(G5(:,:,:,17),wf(:,0),G5(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,18),Q(:,63),MB,G6tensor(:,9))
  call loop_QV_A(G2(:,:,:,194),wf(:,197),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,62),MB,G3(:,:,:,120))
  call loop_QS_A(G3(:,:,:,120),wf(:,0),G3(:,:,:,121),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,121),Q(:,63),MB,G4tensor(:,39))
  call loop_QV_A(G2(:,:,:,194),wf(:,-1),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,22),MB,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,109),G3(:,:,:,123))
  call loop_Q_A(G3(:,:,:,123),Q(:,62),MB,G4(:,:,:,53))
  call loop_QS_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MB,G5tensor(:,18))
  call loop_QV_A(G3(:,:,:,122),wf(:,-3),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,30),MB,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,-5),G4(:,:,:,56))
  call loop_Q_A(G4(:,:,:,56),Q(:,62),MB,G5(:,:,:,19))
  call loop_QS_A(G5(:,:,:,19),wf(:,0),G5(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,20),Q(:,63),MB,G6tensor(:,10))
  call loop_QV_A(G1(:,:,:,59),wf(:,337),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,62),MB,G2(:,:,:,204))
  call loop_QS_A(G2(:,:,:,204),wf(:,0),G2(:,:,:,205),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,205),Q(:,63),MB,G3tensor(:,67))
  call loop_QV_A(G1(:,:,:,59),wf(:,338),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,62),MB,G2(:,:,:,206))
  call loop_QS_A(G2(:,:,:,206),wf(:,0),G2(:,:,:,207),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,207),Q(:,63),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,59),wf(:,339),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,62),MB,G2(:,:,:,208))
  call loop_QS_A(G2(:,:,:,208),wf(:,0),G2(:,:,:,209),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,63),MB,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,59),wf(:,343),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,62),MB,G2(:,:,:,210))
  call loop_QS_A(G2(:,:,:,210),wf(:,0),G2(:,:,:,211),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,211),Q(:,63),MB,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,59),wf(:,344),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,62),MB,G2(:,:,:,212))
  call loop_QS_A(G2(:,:,:,212),wf(:,0),G2(:,:,:,213),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,213),Q(:,63),MB,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,59),wf(:,345),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,62),MB,G2(:,:,:,214))
  call loop_QS_A(G2(:,:,:,214),wf(:,0),G2(:,:,:,215),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,215),Q(:,63),MB,G3tensor(:,72))
  call loop_QV_A(G1(:,:,:,59),wf(:,-3),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,24),MB,G2(:,:,:,216))
  call loop_QV_A(G2(:,:,:,216),wf(:,102),G2(:,:,:,217))
  call loop_Q_A(G2(:,:,:,217),Q(:,62),MB,G3(:,:,:,125))
  call loop_QS_A(G3(:,:,:,125),wf(:,0),G3(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,63),MB,G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,216),wf(:,104),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,62),MB,G3(:,:,:,127))
  call loop_QS_A(G3(:,:,:,127),wf(:,0),G3(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,63),MB,G4tensor(:,41))
  call loop_QV_A(G2(:,:,:,216),wf(:,105),G2(:,:,:,219))
  call loop_Q_A(G2(:,:,:,219),Q(:,62),MB,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,0),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,63),MB,G4tensor(:,42))
  call loop_QV_A(G2(:,:,:,216),wf(:,167),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,62),MB,G3(:,:,:,131))
  call loop_QS_A(G3(:,:,:,131),wf(:,0),G3(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,63),MB,G4tensor(:,43))
  call loop_QV_A(G2(:,:,:,216),wf(:,1),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,30),MB,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,-5),G3(:,:,:,134))
  call loop_Q_A(G3(:,:,:,134),Q(:,62),MB,G4(:,:,:,57))
  call loop_QS_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MB,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,216),wf(:,200),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,62),MB,G3(:,:,:,135))
  call loop_QS_A(G3(:,:,:,135),wf(:,0),G3(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,63),MB,G4tensor(:,44))
  call loop_QV_A(G2(:,:,:,216),wf(:,-2),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,28),MB,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,37),G3(:,:,:,138))
  call loop_Q_A(G3(:,:,:,138),Q(:,62),MB,G4(:,:,:,59))
  call loop_QS_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,20))
  call loop_QV_A(G3(:,:,:,137),wf(:,-1),G3(:,:,:,139))
  call loop_Q_A(G3(:,:,:,139),Q(:,30),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,-5),G4(:,:,:,62))
  call loop_Q_A(G4(:,:,:,62),Q(:,62),MB,G5(:,:,:,21))
  call loop_QS_A(G5(:,:,:,21),wf(:,0),G5(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,22),Q(:,63),MB,G6tensor(:,11))
  call loop_QV_A(G2(:,:,:,216),wf(:,202),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,62),MB,G3(:,:,:,140))
  call loop_QS_A(G3(:,:,:,140),wf(:,0),G3(:,:,:,141),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,63),MB,G4tensor(:,45))
  call loop_QV_A(G2(:,:,:,216),wf(:,-1),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,26),MB,G3(:,:,:,142))
  call loop_QV_A(G3(:,:,:,142),wf(:,84),G3(:,:,:,143))
  call loop_Q_A(G3(:,:,:,143),Q(:,62),MB,G4(:,:,:,63))
  call loop_QS_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,63),MB,G5tensor(:,21))
  call loop_QV_A(G3(:,:,:,142),wf(:,-2),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,30),MB,G4(:,:,:,65))
  call loop_QV_A(G4(:,:,:,65),wf(:,-5),G4(:,:,:,66))
  call loop_Q_A(G4(:,:,:,66),Q(:,62),MB,G5(:,:,:,23))
  call loop_QS_A(G5(:,:,:,23),wf(:,0),G5(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,24),Q(:,63),MB,G6tensor(:,12))
  call loop_QV_A(G1(:,:,:,59),wf(:,358),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,62),MB,G2(:,:,:,226))
  call loop_QS_A(G2(:,:,:,226),wf(:,0),G2(:,:,:,227),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,227),Q(:,63),MB,G3tensor(:,73))
  call loop_QV_A(G1(:,:,:,59),wf(:,359),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,62),MB,G2(:,:,:,228))
  call loop_QS_A(G2(:,:,:,228),wf(:,0),G2(:,:,:,229),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,229),Q(:,63),MB,G3tensor(:,74))
  call loop_QV_A(G1(:,:,:,59),wf(:,360),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,62),MB,G2(:,:,:,230))
  call loop_QS_A(G2(:,:,:,230),wf(:,0),G2(:,:,:,231),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,231),Q(:,63),MB,G3tensor(:,75))
  call loop_QV_A(G1(:,:,:,59),wf(:,120),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,30),MB,G2(:,:,:,232))
  call loop_QV_A(G2(:,:,:,232),wf(:,-5),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,62),MB,G3(:,:,:,145))
  call loop_QS_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,63),MB,G4tensor(:,46))
  call loop_QV_A(G1(:,:,:,59),wf(:,122),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,30),MB,G2(:,:,:,234))
  call loop_QV_A(G2(:,:,:,234),wf(:,-5),G2(:,:,:,235))
  call loop_Q_A(G2(:,:,:,235),Q(:,62),MB,G3(:,:,:,147))
  call loop_QS_A(G3(:,:,:,147),wf(:,0),G3(:,:,:,148),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,63),MB,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,59),wf(:,123),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,30),MB,G2(:,:,:,236))
  call loop_QV_A(G2(:,:,:,236),wf(:,-5),G2(:,:,:,237))
  call loop_Q_A(G2(:,:,:,237),Q(:,62),MB,G3(:,:,:,149))
  call loop_QS_A(G3(:,:,:,149),wf(:,0),G3(:,:,:,150),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,63),MB,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,59),wf(:,362),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,62),MB,G2(:,:,:,238))
  call loop_QS_A(G2(:,:,:,238),wf(:,0),G2(:,:,:,239),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,239),Q(:,63),MB,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,59),wf(:,1),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,22),MB,G2(:,:,:,240))
  call loop_QV_A(G2(:,:,:,240),wf(:,109),G2(:,:,:,241))
  call loop_Q_A(G2(:,:,:,241),Q(:,62),MB,G3(:,:,:,151))
  call loop_QS_A(G3(:,:,:,151),wf(:,0),G3(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,63),MB,G4tensor(:,49))
  call loop_QV_A(G2(:,:,:,240),wf(:,-3),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,30),MB,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-5),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,62),MB,G4(:,:,:,67))
  call loop_QS_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,59),wf(:,365),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,62),MB,G2(:,:,:,243))
  call loop_QS_A(G2(:,:,:,243),wf(:,0),G2(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MB,G3tensor(:,77))
  call loop_QV_A(G1(:,:,:,59),wf(:,172),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,30),MB,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,-5),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,62),MB,G3(:,:,:,155))
  call loop_QS_A(G3(:,:,:,155),wf(:,0),G3(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),MB,G4tensor(:,50))
  call loop_QV_A(G1(:,:,:,59),wf(:,368),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,62),MB,G2(:,:,:,247))
  call loop_QS_A(G2(:,:,:,247),wf(:,0),G2(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MB,G3tensor(:,78))
  call loop_QV_A(G1(:,:,:,59),wf(:,371),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,62),MB,G2(:,:,:,249))
  call loop_QS_A(G2(:,:,:,249),wf(:,0),G2(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,250),Q(:,63),MB,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,59),wf(:,18),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,26),MB,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,84),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,62),MB,G3(:,:,:,157))
  call loop_QS_A(G3(:,:,:,157),wf(:,0),G3(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,63),MB,G4tensor(:,51))
  call loop_QV_A(G2(:,:,:,251),wf(:,-2),G2(:,:,:,253))
  call loop_Q_A(G2(:,:,:,253),Q(:,30),MB,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-5),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,62),MB,G4(:,:,:,69))
  call loop_QS_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,63),MB,G5tensor(:,23))
  call loop_QV_A(G1(:,:,:,59),wf(:,374),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,62),MB,G2(:,:,:,254))
  call loop_QS_A(G2(:,:,:,254),wf(:,0),G2(:,:,:,255),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,255),Q(:,63),MB,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,59),wf(:,181),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,30),MB,G2(:,:,:,256))
  call loop_QV_A(G2(:,:,:,256),wf(:,-5),G2(:,:,:,257))
  call loop_Q_A(G2(:,:,:,257),Q(:,62),MB,G3(:,:,:,161))
  call loop_QS_A(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,63),MB,G4tensor(:,52))
  call loop_QV_A(G1(:,:,:,59),wf(:,377),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,62),MB,G2(:,:,:,258))
  call loop_QS_A(G2(:,:,:,258),wf(:,0),G2(:,:,:,259),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,259),Q(:,63),MB,G3tensor(:,81))
  call loop_QV_A(G1(:,:,:,59),wf(:,380),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,62),MB,G2(:,:,:,260))
  call loop_QS_A(G2(:,:,:,260),wf(:,0),G2(:,:,:,261),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,261),Q(:,63),MB,G3tensor(:,82))
  call loop_QV_A(G1(:,:,:,59),wf(:,65),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,28),MB,G2(:,:,:,262))
  call loop_QV_A(G2(:,:,:,262),wf(:,37),G2(:,:,:,263))
  call loop_Q_A(G2(:,:,:,263),Q(:,62),MB,G3(:,:,:,163))
  call loop_QS_A(G3(:,:,:,163),wf(:,0),G3(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,63),MB,G4tensor(:,53))
  call loop_QV_A(G2(:,:,:,262),wf(:,-1),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,30),MB,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-5),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,62),MB,G4(:,:,:,71))
  call loop_QS_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,63),MB,G5tensor(:,24))
  call loop_QV_A(G1(:,:,:,59),wf(:,383),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,62),MB,G2(:,:,:,265))
  call loop_QS_A(G2(:,:,:,265),wf(:,0),G2(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,63),MB,G3tensor(:,83))
  call loop_QV_A(G1(:,:,:,59),wf(:,189),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,30),MB,G2(:,:,:,267))
  call loop_QV_A(G2(:,:,:,267),wf(:,-5),G2(:,:,:,268))
  call loop_Q_A(G2(:,:,:,268),Q(:,62),MB,G3(:,:,:,167))
  call loop_QS_A(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),MB,G4tensor(:,54))
  call loop_QV_A(G1(:,:,:,59),wf(:,385),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,62),MB,G2(:,:,:,269))
  call loop_QS_A(G2(:,:,:,269),wf(:,0),G2(:,:,:,270),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,63),MB,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,59),wf(:,412),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,62),MB,G2(:,:,:,271))
  call loop_QS_A(G2(:,:,:,271),wf(:,0),G2(:,:,:,272),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,272),Q(:,63),MB,G3tensor(:,85))
  call loop_QV_A(G1(:,:,:,59),wf(:,414),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,62),MB,G2(:,:,:,273))
  call loop_QS_A(G2(:,:,:,273),wf(:,0),G2(:,:,:,274),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,274),Q(:,63),MB,G3tensor(:,86))
  call loop_QV_A(G1(:,:,:,59),wf(:,418),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,62),MB,G2(:,:,:,275))
  call loop_QS_A(G2(:,:,:,275),wf(:,0),G2(:,:,:,276),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,276),Q(:,63),MB,G3tensor(:,87))
  call loop_QV_A(G1(:,:,:,59),wf(:,420),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,62),MB,G2(:,:,:,277))
  call loop_QS_A(G2(:,:,:,277),wf(:,0),G2(:,:,:,278),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,278),Q(:,63),MB,G3tensor(:,88))
  call loop_QV_A(G1(:,:,:,59),wf(:,424),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,62),MB,G2(:,:,:,279))
  call loop_QS_A(G2(:,:,:,279),wf(:,0),G2(:,:,:,280),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,63),MB,G3tensor(:,89))
  call loop_QV_A(G1(:,:,:,59),wf(:,425),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,62),MB,G2(:,:,:,281))
  call loop_QS_A(G2(:,:,:,281),wf(:,0),G2(:,:,:,282),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,63),MB,G3tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,217),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,30),MT,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,62),MT,G2(:,:,:,283))
  call loop_QS_A(G2(:,:,:,283),wf(:,0),G2(:,:,:,284),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,284),Q(:,63),MT,G3tensor(:,91))
  call loop_QV_A(G0(:,:,:,1),wf(:,218),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,62),MT,G2(:,:,:,285))
  call loop_QS_A(G2(:,:,:,285),wf(:,0),G2(:,:,:,286),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,63),MT,G3tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,219),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,30),MT,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,62),MT,G2(:,:,:,287))
  call loop_QS_A(G2(:,:,:,287),wf(:,0),G2(:,:,:,288),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,93))
  call loop_AV_Q(G0(:,:,:,1),wf(:,217),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,30),MT,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,-5),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,289))
  call loop_AS_Q(G2(:,:,:,289),wf(:,0),G2(:,:,:,290),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,94))
  call loop_AV_Q(G0(:,:,:,1),wf(:,218),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,30),MT,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,62),MT,G2(:,:,:,291))
  call loop_AS_Q(G2(:,:,:,291),wf(:,0),G2(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,95))
  call loop_AV_Q(G0(:,:,:,1),wf(:,219),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,293))
  call loop_AS_Q(G2(:,:,:,293),wf(:,0),G2(:,:,:,294),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,217),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,30),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,-5),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,62),MB,G2(:,:,:,295))
  call loop_QS_A(G2(:,:,:,295),wf(:,0),G2(:,:,:,296),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,296),Q(:,63),MB,G3tensor(:,97))
  call loop_QV_A(G0(:,:,:,1),wf(:,218),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,30),MB,G1(:,:,:,131))
  call loop_QV_A(G1(:,:,:,131),wf(:,-5),G1(:,:,:,132))
  call loop_Q_A(G1(:,:,:,132),Q(:,62),MB,G2(:,:,:,297))
  call loop_QS_A(G2(:,:,:,297),wf(:,0),G2(:,:,:,298),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,298),Q(:,63),MB,G3tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,219),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,30),MB,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,62),MB,G2(:,:,:,299))
  call loop_QS_A(G2(:,:,:,299),wf(:,0),G2(:,:,:,300),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,63),MB,G3tensor(:,99))
  call loop_AV_Q(G0(:,:,:,1),wf(:,217),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,30),MB,G1(:,:,:,135))
  call loop_AV_Q(G1(:,:,:,135),wf(:,-5),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,62),MB,G2(:,:,:,301))
  call loop_AS_Q(G2(:,:,:,301),wf(:,0),G2(:,:,:,302),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,63),MB,G3tensor(:,100))
  call loop_AV_Q(G0(:,:,:,1),wf(:,218),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,30),MB,G1(:,:,:,137))
  call loop_AV_Q(G1(:,:,:,137),wf(:,-5),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,62),MB,G2(:,:,:,303))
  call loop_AS_Q(G2(:,:,:,303),wf(:,0),G2(:,:,:,304),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,304),Q(:,63),MB,G3tensor(:,101))
  call loop_AV_Q(G0(:,:,:,1),wf(:,219),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,30),MB,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-5),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,62),MB,G2(:,:,:,305))
  call loop_AS_Q(G2(:,:,:,305),wf(:,0),G2(:,:,:,306),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,306),Q(:,63),MB,G3tensor(:,102))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,6),MT,G1(:,:,:,141))
  call loop_AV_Q(G1(:,:,:,141),wf(:,2),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,62),MT,G2(:,:,:,307))
  call loop_AS_Q(G2(:,:,:,307),wf(:,0),G2(:,:,:,308),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,308),Q(:,63),MT,G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,141),wf(:,4),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,62),MT,G2(:,:,:,309))
  call loop_AS_Q(G2(:,:,:,309),wf(:,0),G2(:,:,:,310),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,310),Q(:,63),MT,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,141),wf(:,5),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,311))
  call loop_AS_Q(G2(:,:,:,311),wf(:,0),G2(:,:,:,312),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,312),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G1(:,:,:,141),wf(:,166),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,62),MT,G2(:,:,:,313))
  call loop_AS_Q(G2(:,:,:,313),wf(:,0),G2(:,:,:,314),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,314),Q(:,63),MT,G3tensor(:,106))
  call loop_AV_Q(G1(:,:,:,141),wf(:,101),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,30),MT,G2(:,:,:,315))
  call loop_AV_Q(G2(:,:,:,315),wf(:,-5),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,62),MT,G3(:,:,:,169))
  call loop_AS_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,141),wf(:,-5),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,38),MT,G2(:,:,:,317))
  call loop_AV_Q(G2(:,:,:,317),wf(:,101),G2(:,:,:,318))
  call loop_A_Q(G2(:,:,:,318),Q(:,62),MT,G3(:,:,:,171))
  call loop_AS_Q(G3(:,:,:,171),wf(:,0),G3(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,317),wf(:,-4),G2(:,:,:,319))
  call loop_A_Q(G2(:,:,:,319),Q(:,54),MT,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-3),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,62),MT,G4(:,:,:,73))
  call loop_AS_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,317),wf(:,-3),G2(:,:,:,320))
  call loop_A_Q(G2(:,:,:,320),Q(:,46),MT,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,-4),G3(:,:,:,176))
  call loop_A_Q(G3(:,:,:,176),Q(:,62),MT,G4(:,:,:,75))
  call loop_AS_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,141),wf(:,169),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,62),MT,G2(:,:,:,321))
  call loop_AS_Q(G2(:,:,:,321),wf(:,0),G2(:,:,:,322),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,322),Q(:,63),MT,G3tensor(:,107))
  call loop_AV_Q(G1(:,:,:,141),wf(:,109),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,46),MT,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-4),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,62),MT,G3(:,:,:,177))
  call loop_AS_Q(G3(:,:,:,177),wf(:,0),G3(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,141),wf(:,-4),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,22),MT,G2(:,:,:,325))
  call loop_AV_Q(G2(:,:,:,325),wf(:,109),G2(:,:,:,326))
  call loop_A_Q(G2(:,:,:,326),Q(:,62),MT,G3(:,:,:,179))
  call loop_AS_Q(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),MT,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-5),G2(:,:,:,327))
  call loop_A_Q(G2(:,:,:,327),Q(:,54),MT,G3(:,:,:,181))
  call loop_AV_Q(G3(:,:,:,181),wf(:,-3),G3(:,:,:,182))
  call loop_A_Q(G3(:,:,:,182),Q(:,62),MT,G4(:,:,:,77))
  call loop_AS_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-3),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,30),MT,G3(:,:,:,183))
  call loop_AV_Q(G3(:,:,:,183),wf(:,-5),G3(:,:,:,184))
  call loop_A_Q(G3(:,:,:,184),Q(:,62),MT,G4(:,:,:,79))
  call loop_AS_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,141),wf(:,171),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,62),MT,G2(:,:,:,329))
  call loop_AS_Q(G2(:,:,:,329),wf(:,0),G2(:,:,:,330),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,330),Q(:,63),MT,G3tensor(:,108))
  call loop_AV_Q(G1(:,:,:,141),wf(:,119),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,54),MT,G2(:,:,:,331))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-3),G2(:,:,:,332))
  call loop_A_Q(G2(:,:,:,332),Q(:,62),MT,G3(:,:,:,185))
  call loop_AS_Q(G3(:,:,:,185),wf(:,0),G3(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,63),MT,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,141),wf(:,-3),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,14),MT,G2(:,:,:,333))
  call loop_AV_Q(G2(:,:,:,333),wf(:,119),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,62),MT,G3(:,:,:,187))
  call loop_AS_Q(G3(:,:,:,187),wf(:,0),G3(:,:,:,188),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,188),Q(:,63),MT,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,333),wf(:,-5),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,46),MT,G3(:,:,:,189))
  call loop_AV_Q(G3(:,:,:,189),wf(:,-4),G3(:,:,:,190))
  call loop_A_Q(G3(:,:,:,190),Q(:,62),MT,G4(:,:,:,81))
  call loop_AS_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),MT,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,333),wf(:,-4),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,30),MT,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-5),G3(:,:,:,192))
  call loop_A_Q(G3(:,:,:,192),Q(:,62),MT,G4(:,:,:,83))
  call loop_AS_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),MT,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,6),MT,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,2),G1(:,:,:,155))
  call loop_Q_A(G1(:,:,:,155),Q(:,62),MT,G2(:,:,:,337))
  call loop_QS_A(G2(:,:,:,337),wf(:,0),G2(:,:,:,338),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),MT,G3tensor(:,109))
  call loop_QV_A(G1(:,:,:,154),wf(:,4),G1(:,:,:,156))
  call loop_Q_A(G1(:,:,:,156),Q(:,62),MT,G2(:,:,:,339))
  call loop_QS_A(G2(:,:,:,339),wf(:,0),G2(:,:,:,340),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,63),MT,G3tensor(:,110))
  call loop_QV_A(G1(:,:,:,154),wf(:,5),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,62),MT,G2(:,:,:,341))
  call loop_QS_A(G2(:,:,:,341),wf(:,0),G2(:,:,:,342),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,63),MT,G3tensor(:,111))
  call loop_QV_A(G1(:,:,:,154),wf(:,166),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,62),MT,G2(:,:,:,343))
  call loop_QS_A(G2(:,:,:,343),wf(:,0),G2(:,:,:,344),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,344),Q(:,63),MT,G3tensor(:,112))
  call loop_QV_A(G1(:,:,:,154),wf(:,101),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,30),MT,G2(:,:,:,345))
  call loop_QV_A(G2(:,:,:,345),wf(:,-5),G2(:,:,:,346))
  call loop_Q_A(G2(:,:,:,346),Q(:,62),MT,G3(:,:,:,193))
  call loop_QS_A(G3(:,:,:,193),wf(:,0),G3(:,:,:,194),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,63),MT,G4tensor(:,61))
  call loop_QV_A(G1(:,:,:,154),wf(:,-5),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,38),MT,G2(:,:,:,347))
  call loop_QV_A(G2(:,:,:,347),wf(:,101),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,62),MT,G3(:,:,:,195))
  call loop_QS_A(G3(:,:,:,195),wf(:,0),G3(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,63),MT,G4tensor(:,62))
  call loop_QV_A(G2(:,:,:,347),wf(:,-4),G2(:,:,:,349))
  call loop_Q_A(G2(:,:,:,349),Q(:,54),MT,G3(:,:,:,197))
  call loop_QV_A(G3(:,:,:,197),wf(:,-3),G3(:,:,:,198))
  call loop_Q_A(G3(:,:,:,198),Q(:,62),MT,G4(:,:,:,85))
  call loop_QS_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,347),wf(:,-3),G2(:,:,:,350))
  call loop_Q_A(G2(:,:,:,350),Q(:,46),MT,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,-4),G3(:,:,:,200))
  call loop_Q_A(G3(:,:,:,200),Q(:,62),MT,G4(:,:,:,87))
  call loop_QS_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,63),MT,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,154),wf(:,169),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,62),MT,G2(:,:,:,351))
  call loop_QS_A(G2(:,:,:,351),wf(:,0),G2(:,:,:,352),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,352),Q(:,63),MT,G3tensor(:,113))
  call loop_QV_A(G1(:,:,:,154),wf(:,109),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,46),MT,G2(:,:,:,353))
  call loop_QV_A(G2(:,:,:,353),wf(:,-4),G2(:,:,:,354))
  call loop_Q_A(G2(:,:,:,354),Q(:,62),MT,G3(:,:,:,201))
  call loop_QS_A(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,154),wf(:,-4),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,22),MT,G2(:,:,:,355))
  call loop_QV_A(G2(:,:,:,355),wf(:,109),G2(:,:,:,356))
  call loop_Q_A(G2(:,:,:,356),Q(:,62),MT,G3(:,:,:,203))
  call loop_QS_A(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,355),wf(:,-5),G2(:,:,:,357))
  call loop_Q_A(G2(:,:,:,357),Q(:,54),MT,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,-3),G3(:,:,:,206))
  call loop_Q_A(G3(:,:,:,206),Q(:,62),MT,G4(:,:,:,89))
  call loop_QS_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,355),wf(:,-3),G2(:,:,:,358))
  call loop_Q_A(G2(:,:,:,358),Q(:,30),MT,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,-5),G3(:,:,:,208))
  call loop_Q_A(G3(:,:,:,208),Q(:,62),MT,G4(:,:,:,91))
  call loop_QS_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,154),wf(:,171),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,62),MT,G2(:,:,:,359))
  call loop_QS_A(G2(:,:,:,359),wf(:,0),G2(:,:,:,360),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,63),MT,G3tensor(:,114))
  call loop_QV_A(G1(:,:,:,154),wf(:,119),G1(:,:,:,165))
  call loop_Q_A(G1(:,:,:,165),Q(:,54),MT,G2(:,:,:,361))
  call loop_QV_A(G2(:,:,:,361),wf(:,-3),G2(:,:,:,362))
  call loop_Q_A(G2(:,:,:,362),Q(:,62),MT,G3(:,:,:,209))
  call loop_QS_A(G3(:,:,:,209),wf(:,0),G3(:,:,:,210),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,63),MT,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,154),wf(:,-3),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,14),MT,G2(:,:,:,363))
  call loop_QV_A(G2(:,:,:,363),wf(:,119),G2(:,:,:,364))
  call loop_Q_A(G2(:,:,:,364),Q(:,62),MT,G3(:,:,:,211))
  call loop_QS_A(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,63),MT,G4tensor(:,66))
  call loop_QV_A(G2(:,:,:,363),wf(:,-5),G2(:,:,:,365))
  call loop_Q_A(G2(:,:,:,365),Q(:,46),MT,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-4),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,62),MT,G4(:,:,:,93))
  call loop_QS_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,363),wf(:,-4),G2(:,:,:,366))
  call loop_Q_A(G2(:,:,:,366),Q(:,30),MT,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-5),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,62),MT,G4(:,:,:,95))
  call loop_QS_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,6),MB,G1(:,:,:,167))
  call loop_AV_Q(G1(:,:,:,167),wf(:,2),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,62),MB,G2(:,:,:,367))
  call loop_AS_Q(G2(:,:,:,367),wf(:,0),G2(:,:,:,368),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,368),Q(:,63),MB,G3tensor(:,115))
  call loop_AV_Q(G1(:,:,:,167),wf(:,4),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,62),MB,G2(:,:,:,369))
  call loop_AS_Q(G2(:,:,:,369),wf(:,0),G2(:,:,:,370),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,370),Q(:,63),MB,G3tensor(:,116))
  call loop_AV_Q(G1(:,:,:,167),wf(:,5),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,62),MB,G2(:,:,:,371))
  call loop_AS_Q(G2(:,:,:,371),wf(:,0),G2(:,:,:,372),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,372),Q(:,63),MB,G3tensor(:,117))
  call loop_AV_Q(G1(:,:,:,167),wf(:,166),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,62),MB,G2(:,:,:,373))
  call loop_AS_Q(G2(:,:,:,373),wf(:,0),G2(:,:,:,374),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,374),Q(:,63),MB,G3tensor(:,118))
  call loop_AV_Q(G1(:,:,:,167),wf(:,101),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,30),MB,G2(:,:,:,375))
  call loop_AV_Q(G2(:,:,:,375),wf(:,-5),G2(:,:,:,376))
  call loop_A_Q(G2(:,:,:,376),Q(:,62),MB,G3(:,:,:,217))
  call loop_AS_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,63),MB,G4tensor(:,67))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-5),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,38),MB,G2(:,:,:,377))
  call loop_AV_Q(G2(:,:,:,377),wf(:,101),G2(:,:,:,378))
  call loop_A_Q(G2(:,:,:,378),Q(:,62),MB,G3(:,:,:,219))
  call loop_AS_Q(G3(:,:,:,219),wf(:,0),G3(:,:,:,220),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,63),MB,G4tensor(:,68))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-4),G2(:,:,:,379))
  call loop_A_Q(G2(:,:,:,379),Q(:,54),MB,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-3),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,62),MB,G4(:,:,:,97))
  call loop_AS_Q(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,63),MB,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-3),G2(:,:,:,380))
  call loop_A_Q(G2(:,:,:,380),Q(:,46),MB,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-4),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,62),MB,G4(:,:,:,99))
  call loop_AS_Q(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,63),MB,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,167),wf(:,169),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,62),MB,G2(:,:,:,381))
  call loop_AS_Q(G2(:,:,:,381),wf(:,0),G2(:,:,:,382),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,382),Q(:,63),MB,G3tensor(:,119))
  call loop_AV_Q(G1(:,:,:,167),wf(:,109),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,46),MB,G2(:,:,:,383))
  call loop_AV_Q(G2(:,:,:,383),wf(:,-4),G2(:,:,:,384))
  call loop_A_Q(G2(:,:,:,384),Q(:,62),MB,G3(:,:,:,225))
  call loop_AS_Q(G3(:,:,:,225),wf(:,0),G3(:,:,:,226),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,63),MB,G4tensor(:,69))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-4),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,22),MB,G2(:,:,:,385))
  call loop_AV_Q(G2(:,:,:,385),wf(:,109),G2(:,:,:,386))
  call loop_A_Q(G2(:,:,:,386),Q(:,62),MB,G3(:,:,:,227))
  call loop_AS_Q(G3(:,:,:,227),wf(:,0),G3(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,63),MB,G4tensor(:,70))
  call loop_AV_Q(G2(:,:,:,385),wf(:,-5),G2(:,:,:,387))
  call loop_A_Q(G2(:,:,:,387),Q(:,54),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,-3),G3(:,:,:,230))
  call loop_A_Q(G3(:,:,:,230),Q(:,62),MB,G4(:,:,:,101))
  call loop_AS_Q(G4(:,:,:,101),wf(:,0),G4(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,63),MB,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,385),wf(:,-3),G2(:,:,:,388))
  call loop_A_Q(G2(:,:,:,388),Q(:,30),MB,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-5),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,62),MB,G4(:,:,:,103))
  call loop_AS_Q(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,63),MB,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,167),wf(:,171),G1(:,:,:,177))
  call loop_A_Q(G1(:,:,:,177),Q(:,62),MB,G2(:,:,:,389))
  call loop_AS_Q(G2(:,:,:,389),wf(:,0),G2(:,:,:,390),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,390),Q(:,63),MB,G3tensor(:,120))
  call loop_AV_Q(G1(:,:,:,167),wf(:,119),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,54),MB,G2(:,:,:,391))
  call loop_AV_Q(G2(:,:,:,391),wf(:,-3),G2(:,:,:,392))
  call loop_A_Q(G2(:,:,:,392),Q(:,62),MB,G3(:,:,:,233))
  call loop_AS_Q(G3(:,:,:,233),wf(:,0),G3(:,:,:,234),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,63),MB,G4tensor(:,71))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-3),G1(:,:,:,179))
  call loop_A_Q(G1(:,:,:,179),Q(:,14),MB,G2(:,:,:,393))
  call loop_AV_Q(G2(:,:,:,393),wf(:,119),G2(:,:,:,394))
  call loop_A_Q(G2(:,:,:,394),Q(:,62),MB,G3(:,:,:,235))
  call loop_AS_Q(G3(:,:,:,235),wf(:,0),G3(:,:,:,236),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,63),MB,G4tensor(:,72))
  call loop_AV_Q(G2(:,:,:,393),wf(:,-5),G2(:,:,:,395))
  call loop_A_Q(G2(:,:,:,395),Q(:,46),MB,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-4),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,62),MB,G4(:,:,:,105))
  call loop_AS_Q(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,63),MB,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,393),wf(:,-4),G2(:,:,:,396))
  call loop_A_Q(G2(:,:,:,396),Q(:,30),MB,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-5),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,62),MB,G4(:,:,:,107))
  call loop_AS_Q(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,63),MB,G5tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,6),MB,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,2),G1(:,:,:,181))
  call loop_Q_A(G1(:,:,:,181),Q(:,62),MB,G2(:,:,:,397))
  call loop_QS_A(G2(:,:,:,397),wf(:,0),G2(:,:,:,398),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,63),MB,G3tensor(:,121))
  call loop_QV_A(G1(:,:,:,180),wf(:,4),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,62),MB,G2(:,:,:,399))
  call loop_QS_A(G2(:,:,:,399),wf(:,0),G2(:,:,:,400),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,400),Q(:,63),MB,G3tensor(:,122))
  call loop_QV_A(G1(:,:,:,180),wf(:,5),G1(:,:,:,183))
  call loop_Q_A(G1(:,:,:,183),Q(:,62),MB,G2(:,:,:,401))
  call loop_QS_A(G2(:,:,:,401),wf(:,0),G2(:,:,:,402),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,402),Q(:,63),MB,G3tensor(:,123))
  call loop_QV_A(G1(:,:,:,180),wf(:,166),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,62),MB,G2(:,:,:,403))
  call loop_QS_A(G2(:,:,:,403),wf(:,0),G2(:,:,:,404),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,404),Q(:,63),MB,G3tensor(:,124))
  call loop_QV_A(G1(:,:,:,180),wf(:,101),G1(:,:,:,185))
  call loop_Q_A(G1(:,:,:,185),Q(:,30),MB,G2(:,:,:,405))
  call loop_QV_A(G2(:,:,:,405),wf(:,-5),G2(:,:,:,406))
  call loop_Q_A(G2(:,:,:,406),Q(:,62),MB,G3(:,:,:,241))
  call loop_QS_A(G3(:,:,:,241),wf(:,0),G3(:,:,:,242),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,63),MB,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,180),wf(:,-5),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,38),MB,G2(:,:,:,407))
  call loop_QV_A(G2(:,:,:,407),wf(:,101),G2(:,:,:,408))
  call loop_Q_A(G2(:,:,:,408),Q(:,62),MB,G3(:,:,:,243))
  call loop_QS_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,63),MB,G4tensor(:,74))
  call loop_QV_A(G2(:,:,:,407),wf(:,-4),G2(:,:,:,409))
  call loop_Q_A(G2(:,:,:,409),Q(:,54),MB,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-3),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,62),MB,G4(:,:,:,109))
  call loop_QS_A(G4(:,:,:,109),wf(:,0),G4(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,63),MB,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,407),wf(:,-3),G2(:,:,:,410))
  call loop_Q_A(G2(:,:,:,410),Q(:,46),MB,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-4),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,62),MB,G4(:,:,:,111))
  call loop_QS_A(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,63),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,180),wf(:,169),G1(:,:,:,187))
  call loop_Q_A(G1(:,:,:,187),Q(:,62),MB,G2(:,:,:,411))
  call loop_QS_A(G2(:,:,:,411),wf(:,0),G2(:,:,:,412),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,412),Q(:,63),MB,G3tensor(:,125))
  call loop_QV_A(G1(:,:,:,180),wf(:,109),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,46),MB,G2(:,:,:,413))
  call loop_QV_A(G2(:,:,:,413),wf(:,-4),G2(:,:,:,414))
  call loop_Q_A(G2(:,:,:,414),Q(:,62),MB,G3(:,:,:,249))
  call loop_QS_A(G3(:,:,:,249),wf(:,0),G3(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,63),MB,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,180),wf(:,-4),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,22),MB,G2(:,:,:,415))
  call loop_QV_A(G2(:,:,:,415),wf(:,109),G2(:,:,:,416))
  call loop_Q_A(G2(:,:,:,416),Q(:,62),MB,G3(:,:,:,251))
  call loop_QS_A(G3(:,:,:,251),wf(:,0),G3(:,:,:,252),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,63),MB,G4tensor(:,76))
  call loop_QV_A(G2(:,:,:,415),wf(:,-5),G2(:,:,:,417))
  call loop_Q_A(G2(:,:,:,417),Q(:,54),MB,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,-3),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,62),MB,G4(:,:,:,113))
  call loop_QS_A(G4(:,:,:,113),wf(:,0),G4(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,63),MB,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,415),wf(:,-3),G2(:,:,:,418))
  call loop_Q_A(G2(:,:,:,418),Q(:,30),MB,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-5),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,62),MB,G4(:,:,:,115))
  call loop_QS_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MB,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,180),wf(:,171),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,62),MB,G2(:,:,:,419))
  call loop_QS_A(G2(:,:,:,419),wf(:,0),G2(:,:,:,420),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,420),Q(:,63),MB,G3tensor(:,126))
  call loop_QV_A(G1(:,:,:,180),wf(:,119),G1(:,:,:,191))
  call loop_Q_A(G1(:,:,:,191),Q(:,54),MB,G2(:,:,:,421))
  call loop_QV_A(G2(:,:,:,421),wf(:,-3),G2(:,:,:,422))
  call loop_Q_A(G2(:,:,:,422),Q(:,62),MB,G3(:,:,:,257))
  call loop_QS_A(G3(:,:,:,257),wf(:,0),G3(:,:,:,258),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,63),MB,G4tensor(:,77))
  call loop_QV_A(G1(:,:,:,180),wf(:,-3),G1(:,:,:,192))
  call loop_Q_A(G1(:,:,:,192),Q(:,14),MB,G2(:,:,:,423))
  call loop_QV_A(G2(:,:,:,423),wf(:,119),G2(:,:,:,424))
  call loop_Q_A(G2(:,:,:,424),Q(:,62),MB,G3(:,:,:,259))
  call loop_QS_A(G3(:,:,:,259),wf(:,0),G3(:,:,:,260),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,63),MB,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,423),wf(:,-5),G2(:,:,:,425))
  call loop_Q_A(G2(:,:,:,425),Q(:,46),MB,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-4),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,62),MB,G4(:,:,:,117))
  call loop_QS_A(G4(:,:,:,117),wf(:,0),G4(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,63),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,423),wf(:,-4),G2(:,:,:,426))
  call loop_Q_A(G2(:,:,:,426),Q(:,30),MB,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,62),MB,G4(:,:,:,119))
  call loop_QS_A(G4(:,:,:,119),wf(:,0),G4(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,63),MB,G5tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,91),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,92),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,93),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,94),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,95),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(250)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,96),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(3) = M(3) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(5) = M(5) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(16) = M(16) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(22) = M(22) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,103),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(4) = M(4) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(10) = M(10) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(12) = M(12) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(18) = M(18) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(24) = M(24) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(5) = M(5) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(16) = M(16) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(22) = M(22) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(3) = M(3) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(5) = M(5) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(16) = M(16) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(22) = M(22) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,109),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(4) = M(4) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(10) = M(10) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(12) = M(12) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(18) = M(18) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(24) = M(24) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,110),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(5) = M(5) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(16) = M(16) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(22) = M(22) + (-(CI*f(5)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,111),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(3) = M(3) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(22) = M(22) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,115),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(4) = M(4) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(10) = M(10) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(12) = M(12) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(18) = M(18) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(24) = M(24) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,116),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(22) = M(22) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(3) = M(3) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(22) = M(22) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,121),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(4) = M(4) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(10) = M(10) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(12) = M(12) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(18) = M(18) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(24) = M(24) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,122),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(22) = M(22) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,123),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(2) = M(2) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,1),T4sum(1:70,18))
  M(8) = M(8) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,1),T4sum(1:70,18))
  M(19) = M(19) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,1),T4sum(1:70,18))
  M(21) = M(21) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,1),T4sum(1:70,18))
  M(2) = M(2) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,2),T4sum(1:70,18))
  M(5) = M(5) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,2),T4sum(1:70,18))
  M(11) = M(11) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,2),T4sum(1:70,18))
  M(21) = M(21) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,2),T4sum(1:70,18))
  M(5) = M(5) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,3),T4sum(1:70,18))
  M(8) = M(8) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,3),T4sum(1:70,18))
  M(11) = M(11) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,3),T4sum(1:70,18))
  M(19) = M(19) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,3),T4sum(1:70,18))
  M(13) = M(13) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,28),T4sum(1:70,18))
  M(15) = M(15) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,28),T4sum(1:70,18))
  M(17) = M(17) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,28),T4sum(1:70,18))
  M(18) = M(18) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,28),T4sum(1:70,18))
  M(13) = M(13) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,29),T4sum(1:70,18))
  M(14) = M(14) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,29),T4sum(1:70,18))
  M(16) = M(16) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,29),T4sum(1:70,18))
  M(18) = M(18) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,29),T4sum(1:70,18))
  M(14) = M(14) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,30),T4sum(1:70,18))
  M(15) = M(15) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,30),T4sum(1:70,18))
  M(16) = M(16) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,30),T4sum(1:70,18))
  M(17) = M(17) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,30),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(9) = M(9) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,7),T4sum(1:70,36))
  M(12) = M(12) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,7),T4sum(1:70,36))
  M(14) = M(14) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,7),T4sum(1:70,36))
  M(23) = M(23) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,7),T4sum(1:70,36))
  M(12) = M(12) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,8),T4sum(1:70,36))
  M(13) = M(13) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,8),T4sum(1:70,36))
  M(14) = M(14) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,8),T4sum(1:70,36))
  M(22) = M(22) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,8),T4sum(1:70,36))
  M(9) = M(9) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,9),T4sum(1:70,36))
  M(13) = M(13) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,9),T4sum(1:70,36))
  M(22) = M(22) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,9),T4sum(1:70,36))
  M(23) = M(23) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,9),T4sum(1:70,36))
  M(4) = M(4) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,34),T4sum(1:70,36))
  M(7) = M(7) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,34),T4sum(1:70,36))
  M(11) = M(11) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,34),T4sum(1:70,36))
  M(20) = M(20) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,34),T4sum(1:70,36))
  M(3) = M(3) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,35),T4sum(1:70,36))
  M(4) = M(4) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,35),T4sum(1:70,36))
  M(11) = M(11) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,35),T4sum(1:70,36))
  M(21) = M(21) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,35),T4sum(1:70,36))
  M(3) = M(3) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,36),T4sum(1:70,36))
  M(7) = M(7) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,36),T4sum(1:70,36))
  M(20) = M(20) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,36),T4sum(1:70,36))
  M(21) = M(21) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,36),T4sum(1:70,36))
  M(2) = M(2) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(11) = M(11) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(13) = M(13) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(14) = M(14) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(21) = M(21) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,69),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,70),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,71),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,72),T3sum(1:35,4))
  M(3) = M(3) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,13),T4sum(1:70,48))
  M(6) = M(6) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,13),T4sum(1:70,48))
  M(16) = M(16) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,13),T4sum(1:70,48))
  M(24) = M(24) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,13),T4sum(1:70,48))
  M(6) = M(6) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,14),T4sum(1:70,48))
  M(15) = M(15) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,14),T4sum(1:70,48))
  M(16) = M(16) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,14),T4sum(1:70,48))
  M(20) = M(20) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,14),T4sum(1:70,48))
  M(3) = M(3) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,15),T4sum(1:70,48))
  M(15) = M(15) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,15),T4sum(1:70,48))
  M(20) = M(20) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,15),T4sum(1:70,48))
  M(24) = M(24) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,15),T4sum(1:70,48))
  M(1) = M(1) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,40),T4sum(1:70,48))
  M(5) = M(5) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,40),T4sum(1:70,48))
  M(10) = M(10) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,40),T4sum(1:70,48))
  M(22) = M(22) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,40),T4sum(1:70,48))
  M(5) = M(5) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,41),T4sum(1:70,48))
  M(9) = M(9) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,41),T4sum(1:70,48))
  M(10) = M(10) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,41),T4sum(1:70,48))
  M(19) = M(19) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,41),T4sum(1:70,48))
  M(1) = M(1) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,42),T4sum(1:70,48))
  M(9) = M(9) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,42),T4sum(1:70,48))
  M(19) = M(19) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,42),T4sum(1:70,48))
  M(22) = M(22) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,42),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,73),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,74),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,75),T3sum(1:35,4))
  M(2) = M(2) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,19),T4sum(1:70,56))
  M(6) = M(6) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,19),T4sum(1:70,56))
  M(12) = M(12) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,19),T4sum(1:70,56))
  M(24) = M(24) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,19),T4sum(1:70,56))
  M(2) = M(2) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,20),T4sum(1:70,56))
  M(8) = M(8) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,20),T4sum(1:70,56))
  M(23) = M(23) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,20),T4sum(1:70,56))
  M(24) = M(24) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,20),T4sum(1:70,56))
  M(6) = M(6) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,21),T4sum(1:70,56))
  M(8) = M(8) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,21),T4sum(1:70,56))
  M(12) = M(12) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,21),T4sum(1:70,56))
  M(23) = M(23) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,21),T4sum(1:70,56))
  M(1) = M(1) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,46),T4sum(1:70,56))
  M(4) = M(4) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,46),T4sum(1:70,56))
  M(10) = M(10) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,46),T4sum(1:70,56))
  M(18) = M(18) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,46),T4sum(1:70,56))
  M(1) = M(1) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,47),T4sum(1:70,56))
  M(7) = M(7) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,47),T4sum(1:70,56))
  M(17) = M(17) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,47),T4sum(1:70,56))
  M(18) = M(18) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,47),T4sum(1:70,56))
  M(4) = M(4) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,48),T4sum(1:70,56))
  M(7) = M(7) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,48),T4sum(1:70,56))
  M(10) = M(10) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,48),T4sum(1:70,56))
  M(17) = M(17) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,48),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(3) = M(3) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(5) = M(5) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(16) = M(16) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(22) = M(22) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(3) = M(3) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(5) = M(5) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(16) = M(16) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(22) = M(22) + (CI*f(5) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(87)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,112),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(3) = M(3) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(22) = M(22) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(3) = M(3) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(5) = M(5) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(16) = M(16) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(22) = M(22) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,124),T3sum(1:35,8))
  M(5) = M(5) + (-f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,61),T4sum(1:70,61))
  M(6) = M(6) + (f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,61),T4sum(1:70,61))
  M(22) = M(22) + (f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,61),T4sum(1:70,61))
  M(24) = M(24) + (-f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,61),T4sum(1:70,61))
  M(1) = M(1) + (-f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,55),T4sum(1:70,61))
  M(3) = M(3) + (f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,55),T4sum(1:70,61))
  M(10) = M(10) + (f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,55),T4sum(1:70,61))
  M(16) = M(16) + (-f(6) * den(300)) * TI2_call(4,momenta_45,masses2_4,G4tensor(:,55),T4sum(1:70,61))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,73),T4sum(1:70,62))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,73),T4sum(1:70,62))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,73),T4sum(1:70,62))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,73),T4sum(1:70,62))
  M(1) = M(1) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,67),T4sum(1:70,62))
  M(3) = M(3) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,67),T4sum(1:70,62))
  M(10) = M(10) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,67),T4sum(1:70,62))
  M(16) = M(16) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_3,G4tensor(:,67),T4sum(1:70,62))
  M(5) = M(5) + (-f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,56),T4sum(1:70,65))
  M(6) = M(6) + (f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,56),T4sum(1:70,65))
  M(22) = M(22) + (f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,56),T4sum(1:70,65))
  M(24) = M(24) + (-f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,56),T4sum(1:70,65))
  M(1) = M(1) + (-f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,62),T4sum(1:70,65))
  M(3) = M(3) + (f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,62),T4sum(1:70,65))
  M(10) = M(10) + (f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,62),T4sum(1:70,65))
  M(16) = M(16) + (-f(6) * den(300)) * TI2_call(4,momenta_46,masses2_4,G4tensor(:,62),T4sum(1:70,65))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,68),T4sum(1:70,66))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,68),T4sum(1:70,66))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,68),T4sum(1:70,66))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,68),T4sum(1:70,66))
  M(1) = M(1) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,74),T4sum(1:70,66))
  M(3) = M(3) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,74),T4sum(1:70,66))
  M(10) = M(10) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,74),T4sum(1:70,66))
  M(16) = M(16) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_3,G4tensor(:,74),T4sum(1:70,66))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(5) = M(5) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(16) = M(16) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(22) = M(22) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,107),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(5) = M(5) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(16) = M(16) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(22) = M(22) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,113),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(22) = M(22) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,119),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(5) = M(5) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(16) = M(16) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(22) = M(22) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,125),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,76),T3sum(1:35,4))
  M(3) = M(3) + (-f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,63),T4sum(1:70,67))
  M(4) = M(4) + (f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,63),T4sum(1:70,67))
  M(16) = M(16) + (f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,63),T4sum(1:70,67))
  M(18) = M(18) + (-f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,63),T4sum(1:70,67))
  M(2) = M(2) + (-f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,57),T4sum(1:70,67))
  M(5) = M(5) + (f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,57),T4sum(1:70,67))
  M(12) = M(12) + (f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,57),T4sum(1:70,67))
  M(22) = M(22) + (-f(6) * den(302)) * TI2_call(4,momenta_47,masses2_4,G4tensor(:,57),T4sum(1:70,67))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,75),T4sum(1:70,68))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,75),T4sum(1:70,68))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,75),T4sum(1:70,68))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,75),T4sum(1:70,68))
  M(2) = M(2) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,69),T4sum(1:70,68))
  M(5) = M(5) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,69),T4sum(1:70,68))
  M(12) = M(12) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,69),T4sum(1:70,68))
  M(22) = M(22) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_3,G4tensor(:,69),T4sum(1:70,68))
  M(2) = M(2) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,22),T4sum(1:70,70))
  M(5) = M(5) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,22),T4sum(1:70,70))
  M(12) = M(12) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,22),T4sum(1:70,70))
  M(22) = M(22) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,22),T4sum(1:70,70))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,49),T4sum(1:70,70))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,49),T4sum(1:70,70))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,49),T4sum(1:70,70))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_3,G4tensor(:,49),T4sum(1:70,70))
  M(3) = M(3) + (-f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,58),T4sum(1:70,71))
  M(4) = M(4) + (f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,58),T4sum(1:70,71))
  M(16) = M(16) + (f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,58),T4sum(1:70,71))
  M(18) = M(18) + (-f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,58),T4sum(1:70,71))
  M(2) = M(2) + (-f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,64),T4sum(1:70,71))
  M(5) = M(5) + (f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,64),T4sum(1:70,71))
  M(12) = M(12) + (f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,64),T4sum(1:70,71))
  M(22) = M(22) + (-f(6) * den(302)) * TI2_call(4,momenta_44,masses2_4,G4tensor(:,64),T4sum(1:70,71))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,70),T4sum(1:70,72))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,70),T4sum(1:70,72))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,70),T4sum(1:70,72))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,70),T4sum(1:70,72))
  M(2) = M(2) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,76),T4sum(1:70,72))
  M(5) = M(5) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,76),T4sum(1:70,72))
  M(12) = M(12) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,76),T4sum(1:70,72))
  M(22) = M(22) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_3,G4tensor(:,76),T4sum(1:70,72))
  M(1) = M(1) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,108),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(6) = M(6) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(10) = M(10) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(12) = M(12) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(18) = M(18) + (CI*f(5) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(24) = M(24) + (-(CI*f(5)) * den(96)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,114),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,120),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(6) = M(6) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(10) = M(10) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(12) = M(12) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(18) = M(18) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(24) = M(24) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,126),T3sum(1:35,8))
  M(1) = M(1) + (-f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,65),T4sum(1:70,73))
  M(2) = M(2) + (f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,65),T4sum(1:70,73))
  M(10) = M(10) + (f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,65),T4sum(1:70,73))
  M(12) = M(12) + (-f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,65),T4sum(1:70,73))
  M(4) = M(4) + (-f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,59),T4sum(1:70,73))
  M(6) = M(6) + (f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,59),T4sum(1:70,73))
  M(18) = M(18) + (f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,59),T4sum(1:70,73))
  M(24) = M(24) + (-f(6) * den(304)) * TI2_call(4,momenta_48,masses2_4,G4tensor(:,59),T4sum(1:70,73))
  M(1) = M(1) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,77),T4sum(1:70,74))
  M(2) = M(2) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,77),T4sum(1:70,74))
  M(10) = M(10) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,77),T4sum(1:70,74))
  M(12) = M(12) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,77),T4sum(1:70,74))
  M(4) = M(4) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,71),T4sum(1:70,74))
  M(6) = M(6) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,71),T4sum(1:70,74))
  M(18) = M(18) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,71),T4sum(1:70,74))
  M(24) = M(24) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_3,G4tensor(:,71),T4sum(1:70,74))
  M(1) = M(1) + (-f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,60),T4sum(1:70,77))
  M(2) = M(2) + (f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,60),T4sum(1:70,77))
  M(10) = M(10) + (f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,60),T4sum(1:70,77))
  M(12) = M(12) + (-f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,60),T4sum(1:70,77))
  M(4) = M(4) + (-f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,66),T4sum(1:70,77))
  M(6) = M(6) + (f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,66),T4sum(1:70,77))
  M(18) = M(18) + (f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,66),T4sum(1:70,77))
  M(24) = M(24) + (-f(6) * den(304)) * TI2_call(4,momenta_43,masses2_4,G4tensor(:,66),T4sum(1:70,77))
  M(1) = M(1) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,72),T4sum(1:70,78))
  M(2) = M(2) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,72),T4sum(1:70,78))
  M(10) = M(10) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,72),T4sum(1:70,78))
  M(12) = M(12) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,72),T4sum(1:70,78))
  M(4) = M(4) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,78),T4sum(1:70,78))
  M(6) = M(6) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,78),T4sum(1:70,78))
  M(18) = M(18) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,78),T4sum(1:70,78))
  M(24) = M(24) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_3,G4tensor(:,78),T4sum(1:70,78))
  M(1) = M(1) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,77),T3sum(1:35,4))
  M(2) = M(2) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,23),T4sum(1:70,56))
  M(6) = M(6) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,23),T4sum(1:70,56))
  M(12) = M(12) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,23),T4sum(1:70,56))
  M(24) = M(24) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,23),T4sum(1:70,56))
  M(1) = M(1) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,50),T4sum(1:70,56))
  M(4) = M(4) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,50),T4sum(1:70,56))
  M(10) = M(10) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,50),T4sum(1:70,56))
  M(18) = M(18) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,50),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,78),T3sum(1:35,4))
  M(3) = M(3) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,16),T4sum(1:70,48))
  M(6) = M(6) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,16),T4sum(1:70,48))
  M(16) = M(16) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,16),T4sum(1:70,48))
  M(24) = M(24) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,16),T4sum(1:70,48))
  M(1) = M(1) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,43),T4sum(1:70,48))
  M(5) = M(5) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,43),T4sum(1:70,48))
  M(10) = M(10) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,43),T4sum(1:70,48))
  M(22) = M(22) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,43),T4sum(1:70,48))
  M(1) = M(1) + (CI*f(5) * den(1)) * TI2_call(5,momenta_162,masses2_6,G5tensor(:,31),T5sum(1:126,9))
  M(10) = M(10) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_162,masses2_6,G5tensor(:,31),T5sum(1:126,9))
  M(6) = M(6) + (CI*f(5) * den(1)) * TI2_call(5,momenta_162,masses2_6,G5tensor(:,25),T5sum(1:126,9))
  M(24) = M(24) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_162,masses2_6,G5tensor(:,25),T5sum(1:126,9))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_162,masses2_5,G5tensor(:,43),T5sum(1:126,10))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_162,masses2_5,G5tensor(:,43),T5sum(1:126,10))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(5,momenta_162,masses2_5,G5tensor(:,37),T5sum(1:126,10))
  M(24) = M(24) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_162,masses2_5,G5tensor(:,37),T5sum(1:126,10))
  M(2) = M(2) + (CI*f(5) * den(1)) * TI2_call(5,momenta_160,masses2_6,G5tensor(:,33),T5sum(1:126,11))
  M(12) = M(12) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_160,masses2_6,G5tensor(:,33),T5sum(1:126,11))
  M(4) = M(4) + (CI*f(5) * den(1)) * TI2_call(5,momenta_160,masses2_6,G5tensor(:,27),T5sum(1:126,11))
  M(18) = M(18) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_160,masses2_6,G5tensor(:,27),T5sum(1:126,11))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_160,masses2_5,G5tensor(:,45),T5sum(1:126,12))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_160,masses2_5,G5tensor(:,45),T5sum(1:126,12))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_160,masses2_5,G5tensor(:,39),T5sum(1:126,12))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_160,masses2_5,G5tensor(:,39),T5sum(1:126,12))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(5,momenta_202,masses2_5,G5tensor(:,7),T5sum(1:126,14))
  M(24) = M(24) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_202,masses2_5,G5tensor(:,7),T5sum(1:126,14))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_202,masses2_5,G5tensor(:,19),T5sum(1:126,14))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_202,masses2_5,G5tensor(:,19),T5sum(1:126,14))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_199,masses2_5,G5tensor(:,10),T5sum(1:126,16))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_199,masses2_5,G5tensor(:,10),T5sum(1:126,16))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_199,masses2_5,G5tensor(:,22),T5sum(1:126,16))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_199,masses2_5,G5tensor(:,22),T5sum(1:126,16))
  M(3) = M(3) + (CI*f(5) * den(1)) * TI2_call(5,momenta_161,masses2_6,G5tensor(:,32),T5sum(1:126,17))
  M(16) = M(16) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_161,masses2_6,G5tensor(:,32),T5sum(1:126,17))
  M(5) = M(5) + (CI*f(5) * den(1)) * TI2_call(5,momenta_161,masses2_6,G5tensor(:,26),T5sum(1:126,17))
  M(22) = M(22) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_161,masses2_6,G5tensor(:,26),T5sum(1:126,17))
  M(3) = M(3) + (CI*f(2) * den(1)) * TI2_call(5,momenta_161,masses2_5,G5tensor(:,44),T5sum(1:126,18))
  M(16) = M(16) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_161,masses2_5,G5tensor(:,44),T5sum(1:126,18))
  M(5) = M(5) + (CI*f(2) * den(1)) * TI2_call(5,momenta_161,masses2_5,G5tensor(:,38),T5sum(1:126,18))
  M(22) = M(22) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_161,masses2_5,G5tensor(:,38),T5sum(1:126,18))
  M(4) = M(4) + (CI*f(5) * den(1)) * TI2_call(5,momenta_158,masses2_6,G5tensor(:,35),T5sum(1:126,19))
  M(18) = M(18) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_158,masses2_6,G5tensor(:,35),T5sum(1:126,19))
  M(2) = M(2) + (CI*f(5) * den(1)) * TI2_call(5,momenta_158,masses2_6,G5tensor(:,29),T5sum(1:126,19))
  M(12) = M(12) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_158,masses2_6,G5tensor(:,29),T5sum(1:126,19))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_158,masses2_5,G5tensor(:,47),T5sum(1:126,20))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_158,masses2_5,G5tensor(:,47),T5sum(1:126,20))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_158,masses2_5,G5tensor(:,41),T5sum(1:126,20))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_158,masses2_5,G5tensor(:,41),T5sum(1:126,20))
  M(5) = M(5) + (CI*f(5) * den(1)) * TI2_call(5,momenta_159,masses2_6,G5tensor(:,34),T5sum(1:126,21))
  M(22) = M(22) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_159,masses2_6,G5tensor(:,34),T5sum(1:126,21))
  M(3) = M(3) + (CI*f(5) * den(1)) * TI2_call(5,momenta_159,masses2_6,G5tensor(:,28),T5sum(1:126,21))
  M(16) = M(16) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_159,masses2_6,G5tensor(:,28),T5sum(1:126,21))
  M(5) = M(5) + (CI*f(2) * den(1)) * TI2_call(5,momenta_159,masses2_5,G5tensor(:,46),T5sum(1:126,22))
  M(22) = M(22) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_159,masses2_5,G5tensor(:,46),T5sum(1:126,22))
  M(3) = M(3) + (CI*f(2) * den(1)) * TI2_call(5,momenta_159,masses2_5,G5tensor(:,40),T5sum(1:126,22))
  M(16) = M(16) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_159,masses2_5,G5tensor(:,40),T5sum(1:126,22))
  M(6) = M(6) + (CI*f(5) * den(1)) * TI2_call(5,momenta_157,masses2_6,G5tensor(:,36),T5sum(1:126,23))
  M(24) = M(24) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_157,masses2_6,G5tensor(:,36),T5sum(1:126,23))
  M(1) = M(1) + (CI*f(5) * den(1)) * TI2_call(5,momenta_157,masses2_6,G5tensor(:,30),T5sum(1:126,23))
  M(10) = M(10) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_157,masses2_6,G5tensor(:,30),T5sum(1:126,23))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(5,momenta_157,masses2_5,G5tensor(:,48),T5sum(1:126,24))
  M(24) = M(24) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_157,masses2_5,G5tensor(:,48),T5sum(1:126,24))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_157,masses2_5,G5tensor(:,42),T5sum(1:126,24))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_157,masses2_5,G5tensor(:,42),T5sum(1:126,24))
  M(6) = M(6) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(6) = M(6) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,24),T4sum(1:70,88))
  M(8) = M(8) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,24),T4sum(1:70,88))
  M(11) = M(11) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,24),T4sum(1:70,88))
  M(20) = M(20) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,24),T4sum(1:70,88))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,51),T4sum(1:70,88))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,51),T4sum(1:70,88))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,51),T4sum(1:70,88))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_3,G4tensor(:,51),T4sum(1:70,88))
  M(4) = M(4) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(6) = M(6) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,25),T4sum(1:70,56))
  M(8) = M(8) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,25),T4sum(1:70,56))
  M(12) = M(12) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,25),T4sum(1:70,56))
  M(23) = M(23) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,25),T4sum(1:70,56))
  M(4) = M(4) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,52),T4sum(1:70,56))
  M(7) = M(7) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,52),T4sum(1:70,56))
  M(10) = M(10) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,52),T4sum(1:70,56))
  M(17) = M(17) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,52),T4sum(1:70,56))
  M(4) = M(4) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(9) = M(9) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(20) = M(20) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(9) = M(9) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,10),T4sum(1:70,36))
  M(12) = M(12) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,10),T4sum(1:70,36))
  M(14) = M(14) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,10),T4sum(1:70,36))
  M(23) = M(23) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,10),T4sum(1:70,36))
  M(4) = M(4) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,37),T4sum(1:70,36))
  M(7) = M(7) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,37),T4sum(1:70,36))
  M(11) = M(11) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,37),T4sum(1:70,36))
  M(20) = M(20) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,37),T4sum(1:70,36))
  M(12) = M(12) + (CI*f(2) * den(10)) * TI2_call(5,momenta_198,masses2_5,G5tensor(:,4),T5sum(1:126,38))
  M(23) = M(23) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_198,masses2_5,G5tensor(:,4),T5sum(1:126,38))
  M(4) = M(4) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_198,masses2_5,G5tensor(:,16),T5sum(1:126,38))
  M(7) = M(7) + (CI*f(2) * den(10)) * TI2_call(5,momenta_198,masses2_5,G5tensor(:,16),T5sum(1:126,38))
  M(6) = M(6) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_203,masses2_5,G5tensor(:,11),T5sum(1:126,40))
  M(8) = M(8) + (CI*f(2) * den(10)) * TI2_call(5,momenta_203,masses2_5,G5tensor(:,11),T5sum(1:126,40))
  M(10) = M(10) + (CI*f(2) * den(10)) * TI2_call(5,momenta_203,masses2_5,G5tensor(:,23),T5sum(1:126,40))
  M(17) = M(17) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_203,masses2_5,G5tensor(:,23),T5sum(1:126,40))
  M(1) = M(1) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(13) = M(13) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,26),T4sum(1:70,104))
  M(15) = M(15) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,26),T4sum(1:70,104))
  M(23) = M(23) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,26),T4sum(1:70,104))
  M(24) = M(24) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,26),T4sum(1:70,104))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,53),T4sum(1:70,104))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,53),T4sum(1:70,104))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,53),T4sum(1:70,104))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_3,G4tensor(:,53),T4sum(1:70,104))
  M(1) = M(1) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(7) = M(7) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(23) = M(23) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(2) = M(2) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,27),T4sum(1:70,56))
  M(8) = M(8) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,27),T4sum(1:70,56))
  M(23) = M(23) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,27),T4sum(1:70,56))
  M(24) = M(24) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,27),T4sum(1:70,56))
  M(1) = M(1) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,54),T4sum(1:70,56))
  M(7) = M(7) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,54),T4sum(1:70,56))
  M(17) = M(17) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,54),T4sum(1:70,56))
  M(18) = M(18) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_3,G4tensor(:,54),T4sum(1:70,56))
  M(2) = M(2) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(8) = M(8) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(15) = M(15) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(17) = M(17) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(19) = M(19) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(2) = M(2) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,4),T4sum(1:70,18))
  M(8) = M(8) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,4),T4sum(1:70,18))
  M(19) = M(19) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,4),T4sum(1:70,18))
  M(21) = M(21) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,4),T4sum(1:70,18))
  M(13) = M(13) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,31),T4sum(1:70,18))
  M(15) = M(15) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,31),T4sum(1:70,18))
  M(17) = M(17) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,31),T4sum(1:70,18))
  M(18) = M(18) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,31),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(2) * den(33)) * TI2_call(5,momenta_195,masses2_5,G5tensor(:,1),T5sum(1:126,62))
  M(8) = M(8) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_195,masses2_5,G5tensor(:,1),T5sum(1:126,62))
  M(17) = M(17) + (CI*f(2) * den(33)) * TI2_call(5,momenta_195,masses2_5,G5tensor(:,13),T5sum(1:126,62))
  M(18) = M(18) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_195,masses2_5,G5tensor(:,13),T5sum(1:126,62))
  M(23) = M(23) + (CI*f(2) * den(33)) * TI2_call(5,momenta_204,masses2_5,G5tensor(:,12),T5sum(1:126,64))
  M(24) = M(24) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_204,masses2_5,G5tensor(:,12),T5sum(1:126,64))
  M(1) = M(1) + (CI*f(2) * den(33)) * TI2_call(5,momenta_204,masses2_5,G5tensor(:,24),T5sum(1:126,64))
  M(7) = M(7) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_204,masses2_5,G5tensor(:,24),T5sum(1:126,64))
  M(1) = M(1) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(3) = M(3) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,17),T4sum(1:70,48))
  M(15) = M(15) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,17),T4sum(1:70,48))
  M(20) = M(20) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,17),T4sum(1:70,48))
  M(24) = M(24) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,17),T4sum(1:70,48))
  M(1) = M(1) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,44),T4sum(1:70,48))
  M(9) = M(9) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,44),T4sum(1:70,48))
  M(19) = M(19) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,44),T4sum(1:70,48))
  M(22) = M(22) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,44),T4sum(1:70,48))
  M(3) = M(3) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(7) = M(7) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(23) = M(23) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(9) = M(9) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,11),T4sum(1:70,36))
  M(13) = M(13) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,11),T4sum(1:70,36))
  M(22) = M(22) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,11),T4sum(1:70,36))
  M(23) = M(23) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,11),T4sum(1:70,36))
  M(3) = M(3) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,38),T4sum(1:70,36))
  M(7) = M(7) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,38),T4sum(1:70,36))
  M(20) = M(20) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,38),T4sum(1:70,36))
  M(21) = M(21) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,38),T4sum(1:70,36))
  M(13) = M(13) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_197,masses2_5,G5tensor(:,5),T5sum(1:126,166))
  M(23) = M(23) + (CI*f(2) * den(19)) * TI2_call(5,momenta_197,masses2_5,G5tensor(:,5),T5sum(1:126,166))
  M(7) = M(7) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_197,masses2_5,G5tensor(:,17),T5sum(1:126,166))
  M(21) = M(21) + (CI*f(2) * den(19)) * TI2_call(5,momenta_197,masses2_5,G5tensor(:,17),T5sum(1:126,166))
  M(15) = M(15) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_201,masses2_5,G5tensor(:,8),T5sum(1:126,168))
  M(24) = M(24) + (CI*f(2) * den(19)) * TI2_call(5,momenta_201,masses2_5,G5tensor(:,8),T5sum(1:126,168))
  M(1) = M(1) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_201,masses2_5,G5tensor(:,20),T5sum(1:126,168))
  M(19) = M(19) + (CI*f(2) * den(19)) * TI2_call(5,momenta_201,masses2_5,G5tensor(:,20),T5sum(1:126,168))
  M(5) = M(5) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(9) = M(9) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(20) = M(20) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(6) = M(6) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,18),T4sum(1:70,48))
  M(15) = M(15) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,18),T4sum(1:70,48))
  M(16) = M(16) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,18),T4sum(1:70,48))
  M(20) = M(20) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,18),T4sum(1:70,48))
  M(5) = M(5) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,45),T4sum(1:70,48))
  M(9) = M(9) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,45),T4sum(1:70,48))
  M(10) = M(10) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,45),T4sum(1:70,48))
  M(19) = M(19) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_3,G4tensor(:,45),T4sum(1:70,48))
  M(5) = M(5) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(8) = M(8) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(15) = M(15) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(17) = M(17) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(19) = M(19) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(5) = M(5) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,5),T4sum(1:70,18))
  M(8) = M(8) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,5),T4sum(1:70,18))
  M(11) = M(11) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,5),T4sum(1:70,18))
  M(19) = M(19) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,5),T4sum(1:70,18))
  M(14) = M(14) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,32),T4sum(1:70,18))
  M(15) = M(15) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,32),T4sum(1:70,18))
  M(16) = M(16) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,32),T4sum(1:70,18))
  M(17) = M(17) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,32),T4sum(1:70,18))
  M(8) = M(8) + (CI*f(2) * den(42)) * TI2_call(5,momenta_194,masses2_5,G5tensor(:,2),T5sum(1:126,190))
  M(11) = M(11) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_194,masses2_5,G5tensor(:,2),T5sum(1:126,190))
  M(14) = M(14) + (CI*f(2) * den(42)) * TI2_call(5,momenta_194,masses2_5,G5tensor(:,14),T5sum(1:126,190))
  M(17) = M(17) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_194,masses2_5,G5tensor(:,14),T5sum(1:126,190))
  M(6) = M(6) + (CI*f(2) * den(42)) * TI2_call(5,momenta_200,masses2_5,G5tensor(:,9),T5sum(1:126,192))
  M(20) = M(20) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_200,masses2_5,G5tensor(:,9),T5sum(1:126,192))
  M(9) = M(9) + (CI*f(2) * den(42)) * TI2_call(5,momenta_200,masses2_5,G5tensor(:,21),T5sum(1:126,192))
  M(10) = M(10) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_200,masses2_5,G5tensor(:,21),T5sum(1:126,192))
  M(3) = M(3) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(11) = M(11) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(13) = M(13) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(14) = M(14) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(21) = M(21) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(12) = M(12) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,12),T4sum(1:70,36))
  M(13) = M(13) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,12),T4sum(1:70,36))
  M(14) = M(14) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,12),T4sum(1:70,36))
  M(22) = M(22) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,12),T4sum(1:70,36))
  M(3) = M(3) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,39),T4sum(1:70,36))
  M(4) = M(4) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,39),T4sum(1:70,36))
  M(11) = M(11) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,39),T4sum(1:70,36))
  M(21) = M(21) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_3,G4tensor(:,39),T4sum(1:70,36))
  M(2) = M(2) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,6),T4sum(1:70,18))
  M(5) = M(5) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,6),T4sum(1:70,18))
  M(11) = M(11) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,6),T4sum(1:70,18))
  M(21) = M(21) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,6),T4sum(1:70,18))
  M(13) = M(13) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,33),T4sum(1:70,18))
  M(14) = M(14) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,33),T4sum(1:70,18))
  M(16) = M(16) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,33),T4sum(1:70,18))
  M(18) = M(18) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_3,G4tensor(:,33),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(2) * den(55)) * TI2_call(5,momenta_193,masses2_5,G5tensor(:,3),T5sum(1:126,214))
  M(5) = M(5) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_193,masses2_5,G5tensor(:,3),T5sum(1:126,214))
  M(16) = M(16) + (CI*f(2) * den(55)) * TI2_call(5,momenta_193,masses2_5,G5tensor(:,15),T5sum(1:126,214))
  M(18) = M(18) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_193,masses2_5,G5tensor(:,15),T5sum(1:126,214))
  M(12) = M(12) + (CI*f(2) * den(55)) * TI2_call(5,momenta_196,masses2_5,G5tensor(:,6),T5sum(1:126,216))
  M(22) = M(22) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_196,masses2_5,G5tensor(:,6),T5sum(1:126,216))
  M(3) = M(3) + (CI*f(2) * den(55)) * TI2_call(5,momenta_196,masses2_5,G5tensor(:,18),T5sum(1:126,216))
  M(4) = M(4) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_196,masses2_5,G5tensor(:,18),T5sum(1:126,216))
  M(12) = M(12) + (-f(3)) * TI2_call(6,momenta_267,masses2_7,G6tensor(:,4),T6sum(1:210,110))
  M(4) = M(4) + (-f(3)) * TI2_call(6,momenta_267,masses2_7,G6tensor(:,10),T6sum(1:210,110))
  M(6) = M(6) + (-f(3)) * TI2_call(6,momenta_269,masses2_7,G6tensor(:,6),T6sum(1:210,112))
  M(10) = M(10) + (-f(3)) * TI2_call(6,momenta_269,masses2_7,G6tensor(:,12),T6sum(1:210,112))
  M(2) = M(2) + (-f(3)) * TI2_call(6,momenta_265,masses2_7,G6tensor(:,2),T6sum(1:210,114))
  M(18) = M(18) + (-f(3)) * TI2_call(6,momenta_265,masses2_7,G6tensor(:,8),T6sum(1:210,114))
  M(24) = M(24) + (-f(3)) * TI2_call(6,momenta_270,masses2_7,G6tensor(:,5),T6sum(1:210,116))
  M(1) = M(1) + (-f(3)) * TI2_call(6,momenta_270,masses2_7,G6tensor(:,11),T6sum(1:210,116))
  M(8) = M(8) + (-f(3)) * TI2_call(6,momenta_266,masses2_7,G6tensor(:,1),T6sum(1:210,118))
  M(17) = M(17) + (-f(3)) * TI2_call(6,momenta_266,masses2_7,G6tensor(:,7),T6sum(1:210,118))
  M(23) = M(23) + (-f(3)) * TI2_call(6,momenta_268,masses2_7,G6tensor(:,3),T6sum(1:210,120))
  M(7) = M(7) + (-f(3)) * TI2_call(6,momenta_268,masses2_7,G6tensor(:,9),T6sum(1:210,120))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)
  deallocate(G6tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_3_pphjjj2_hggggg_2_/**/REALKIND
