
module ol_vamp_3_pphjjj2_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G0tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_bbxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_bbxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_bbxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_bbxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,73) :: G0
  complex(REALKIND), dimension(4,5,4,176) :: G1
  complex(REALKIND), dimension(4,15,4,180) :: G2
  complex(REALKIND), dimension(4,35,4,115) :: G3
  complex(REALKIND), dimension(4,70,4,51) :: G4
  complex(REALKIND), dimension(4,126,4,12) :: G5
  complex(REALKIND), pointer :: G0tensor(:,:)
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G0tensorhel(1,18,32))
    allocate(G1tensorhel(5,72,32))
    allocate(G2tensorhel(15,79,32))
    allocate(G3tensorhel(35,57,32))
    allocate(G4tensorhel(70,31,32))
    allocate(G5tensorhel(126,12,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G0tensor => G0tensorhel(:,:,hel)
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-3),Q(:,8),G1(:,:,:,1))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-5),wf(:,-4),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,1))
  call loop_VQ_A(G1(:,:,:,2),wf(:,3),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,61),MB,G2(:,:,:,1))
  call check_last_QA_V(l_switch,G2(:,:,:,1),wf(:,-1),G2tensor(:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,2),wf(:,8),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,62),MB,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,4))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-1),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,58),MB,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4),gH)
  call loop_A_Q(G2(:,:,:,4),Q(:,62),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-4),wf(:,-5),G1(:,:,:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,5))
  call loop_VQ_A(G1(:,:,:,6),wf(:,3),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,61),MB,G2(:,:,:,5))
  call check_last_QA_V(l_switch,G2(:,:,:,5),wf(:,-1),G2tensor(:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,6),wf(:,8),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),MB,G2(:,:,:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,6),wf(:,-1),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,58),MB,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8),gH)
  call loop_A_Q(G2(:,:,:,8),Q(:,62),MB,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-5),wf(:,-4),G1(:,:,:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,9))
  call loop_VQ_A(G1(:,:,:,10),wf(:,3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,61),MB,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,10),wf(:,8),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MB,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,10),wf(:,-1),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,58),MB,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,-2),G2(:,:,:,12),gH)
  call loop_A_Q(G2(:,:,:,12),Q(:,62),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,3))
  call loop_VA_Q(G1(:,:,:,1),wf(:,155),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,58),MB,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,3),G2tensor(:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14),gH)
  call loop_A_Q(G2(:,:,:,14),Q(:,62),MB,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,4))
  call loop_UV_W(G1(:,:,:,1),Q(:,8),wf(:,-5),Q(:,32),G2(:,:,:,15))
  call loop_VA_Q(G2(:,:,:,15),wf(:,22),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,58),MB,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,3),G3tensor(:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6),gH)
  call loop_A_Q(G3(:,:,:,6),Q(:,62),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_UV_W(G2(:,:,:,15),Q(:,40),wf(:,-4),Q(:,16),G3(:,:,:,7))
  call check_last_UV_W(l_switch,G3(:,:,:,7),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,2))
  call loop_VQ_A(G3(:,:,:,7),wf(:,3),G3(:,:,:,8))
  call loop_Q_A(G3(:,:,:,8),Q(:,61),MB,G4(:,:,:,2))
  call check_last_QA_V(l_switch,G4(:,:,:,2),wf(:,-1),G4tensor(:,3))
  call check_last_UV_W(l_switch,G3(:,:,:,7),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,4))
  call loop_VA_Q(G3(:,:,:,7),wf(:,8),G3(:,:,:,9))
  call loop_A_Q(G3(:,:,:,9),Q(:,62),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,5))
  call loop_VA_Q(G3(:,:,:,7),wf(:,-1),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,58),MB,G4(:,:,:,4))
  call loop_AS_Q(G4(:,:,:,4),wf(:,-2),G4(:,:,:,5),gH)
  call loop_A_Q(G4(:,:,:,5),Q(:,62),MB,G5(:,:,:,1))
  call check_last_AQ_V(l_switch,G5(:,:,:,1),wf(:,0),G5tensor(:,1))
  call loop_VQ_A(G2(:,:,:,15),wf(:,16),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,61),MB,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-1),G3tensor(:,6))
  call loop_VQ_A(G2(:,:,:,15),wf(:,3),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,45),MB,G3(:,:,:,12))
  call loop_QV_A(G3(:,:,:,12),wf(:,-4),G3(:,:,:,13))
  call loop_Q_A(G3(:,:,:,13),Q(:,61),MB,G4(:,:,:,6))
  call check_last_QA_V(l_switch,G4(:,:,:,6),wf(:,-1),G4tensor(:,6))
  call loop_VQ_A(G2(:,:,:,15),wf(:,55),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,57),MB,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,8),G3tensor(:,7))
  call loop_QS_A(G3(:,:,:,14),wf(:,-2),G3(:,:,:,15),gH)
  call loop_Q_A(G3(:,:,:,15),Q(:,61),MB,G4(:,:,:,7))
  call check_last_QA_V(l_switch,G4(:,:,:,7),wf(:,-1),G4tensor(:,7))
  call loop_VA_Q(G2(:,:,:,15),wf(:,53),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,62),MB,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,8))
  call loop_VA_Q(G2(:,:,:,15),wf(:,8),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,46),MB,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,62),MB,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,8))
  call loop_VQ_A(G2(:,:,:,15),wf(:,81),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,61),MB,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-1),G3tensor(:,9))
  call loop_VA_Q(G2(:,:,:,15),wf(:,77),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,62),MB,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,0),G3tensor(:,10))
  call loop_VA_Q(G2(:,:,:,15),wf(:,-1),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,42),MB,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,58),MB,G4(:,:,:,9))
  call loop_AS_Q(G4(:,:,:,9),wf(:,-2),G4(:,:,:,10),gH)
  call loop_A_Q(G4(:,:,:,10),Q(:,62),MB,G5(:,:,:,2))
  call check_last_AQ_V(l_switch,G5(:,:,:,2),wf(:,0),G5tensor(:,2))
  call loop_AS_Q(G3(:,:,:,21),wf(:,-2),G3(:,:,:,23),gH)
  call loop_A_Q(G3(:,:,:,23),Q(:,46),MB,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,-4),G4(:,:,:,12))
  call loop_A_Q(G4(:,:,:,12),Q(:,62),MB,G5(:,:,:,3))
  call check_last_AQ_V(l_switch,G5(:,:,:,3),wf(:,0),G5tensor(:,3))
  call loop_VA_Q(G1(:,:,:,1),wf(:,22),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,26),MB,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,58),MB,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,3),G3tensor(:,11))
  call loop_AS_Q(G3(:,:,:,24),wf(:,-2),G3(:,:,:,25),gH)
  call loop_A_Q(G3(:,:,:,25),Q(:,62),MB,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,9))
  call loop_AS_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,27),gH)
  call loop_A_Q(G2(:,:,:,27),Q(:,30),MB,G3(:,:,:,26))
  call loop_AV_Q(G3(:,:,:,26),wf(:,-5),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,62),MB,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,10))
  call loop_VA_Q(G1(:,:,:,1),wf(:,158),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,58),MB,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,3),G2tensor(:,14))
  call loop_AS_Q(G2(:,:,:,28),wf(:,-2),G2(:,:,:,29),gH)
  call loop_A_Q(G2(:,:,:,29),Q(:,62),MB,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,12))
  call loop_UV_W(G1(:,:,:,1),Q(:,8),wf(:,-4),Q(:,16),G2(:,:,:,30))
  call loop_VA_Q(G2(:,:,:,30),wf(:,31),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,58),MB,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,3),G3tensor(:,13))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call loop_A_Q(G3(:,:,:,30),Q(:,62),MB,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,0),G4tensor(:,11))
  call loop_UV_W(G2(:,:,:,30),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,31))
  call check_last_UV_W(l_switch,G3(:,:,:,31),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,12))
  call loop_VQ_A(G3(:,:,:,31),wf(:,3),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,61),MB,G4(:,:,:,16))
  call check_last_QA_V(l_switch,G4(:,:,:,16),wf(:,-1),G4tensor(:,13))
  call check_last_UV_W(l_switch,G3(:,:,:,31),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,14))
  call loop_VA_Q(G3(:,:,:,31),wf(:,8),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),MB,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,15))
  call loop_VA_Q(G3(:,:,:,31),wf(:,-1),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,58),MB,G4(:,:,:,18))
  call loop_AS_Q(G4(:,:,:,18),wf(:,-2),G4(:,:,:,19),gH)
  call loop_A_Q(G4(:,:,:,19),Q(:,62),MB,G5(:,:,:,4))
  call check_last_AQ_V(l_switch,G5(:,:,:,4),wf(:,0),G5tensor(:,4))
  call loop_VQ_A(G2(:,:,:,30),wf(:,130),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,61),MB,G3(:,:,:,35))
  call check_last_QA_V(l_switch,G3(:,:,:,35),wf(:,-1),G3tensor(:,14))
  call loop_VQ_A(G2(:,:,:,30),wf(:,3),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,29),MB,G3(:,:,:,36))
  call loop_QV_A(G3(:,:,:,36),wf(:,-5),G3(:,:,:,37))
  call loop_Q_A(G3(:,:,:,37),Q(:,61),MB,G4(:,:,:,20))
  call check_last_QA_V(l_switch,G4(:,:,:,20),wf(:,-1),G4tensor(:,16))
  call loop_VQ_A(G2(:,:,:,30),wf(:,63),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,57),MB,G3(:,:,:,38))
  call check_last_QA_V(l_switch,G3(:,:,:,38),wf(:,8),G3tensor(:,15))
  call loop_QS_A(G3(:,:,:,38),wf(:,-2),G3(:,:,:,39),gH)
  call loop_Q_A(G3(:,:,:,39),Q(:,61),MB,G4(:,:,:,21))
  call check_last_QA_V(l_switch,G4(:,:,:,21),wf(:,-1),G4tensor(:,17))
  call loop_VA_Q(G2(:,:,:,30),wf(:,173),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,62),MB,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,16))
  call loop_VA_Q(G2(:,:,:,30),wf(:,8),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,30),MB,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-5),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,62),MB,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,0),G4tensor(:,18))
  call loop_VQ_A(G2(:,:,:,30),wf(:,85),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,61),MB,G3(:,:,:,43))
  call check_last_QA_V(l_switch,G3(:,:,:,43),wf(:,-1),G3tensor(:,17))
  call loop_VA_Q(G2(:,:,:,30),wf(:,79),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,62),MB,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,0),G3tensor(:,18))
  call loop_VA_Q(G2(:,:,:,30),wf(:,-1),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,26),MB,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,58),MB,G4(:,:,:,23))
  call loop_AS_Q(G4(:,:,:,23),wf(:,-2),G4(:,:,:,24),gH)
  call loop_A_Q(G4(:,:,:,24),Q(:,62),MB,G5(:,:,:,5))
  call check_last_AQ_V(l_switch,G5(:,:,:,5),wf(:,0),G5tensor(:,5))
  call loop_AS_Q(G3(:,:,:,45),wf(:,-2),G3(:,:,:,47),gH)
  call loop_A_Q(G3(:,:,:,47),Q(:,30),MB,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,-5),G4(:,:,:,26))
  call loop_A_Q(G4(:,:,:,26),Q(:,62),MB,G5(:,:,:,6))
  call check_last_AQ_V(l_switch,G5(:,:,:,6),wf(:,0),G5tensor(:,6))
  call loop_VA_Q(G1(:,:,:,1),wf(:,31),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,42),MB,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-4),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,58),MB,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,3),G3tensor(:,19))
  call loop_AS_Q(G3(:,:,:,48),wf(:,-2),G3(:,:,:,49),gH)
  call loop_A_Q(G3(:,:,:,49),Q(:,62),MB,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,0),G4tensor(:,19))
  call loop_AS_Q(G2(:,:,:,40),wf(:,-2),G2(:,:,:,42),gH)
  call loop_A_Q(G2(:,:,:,42),Q(:,46),MB,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-4),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,62),MB,G4(:,:,:,28))
  call check_last_AQ_V(l_switch,G4(:,:,:,28),wf(:,0),G4tensor(:,20))
  call loop_UV_W(G1(:,:,:,1),Q(:,8),wf(:,11),Q(:,48),G2(:,:,:,43))
  call check_last_UV_W(l_switch,G2(:,:,:,43),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,20))
  call loop_VQ_A(G2(:,:,:,43),wf(:,3),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,61),MB,G3(:,:,:,52))
  call check_last_QA_V(l_switch,G3(:,:,:,52),wf(:,-1),G3tensor(:,21))
  call check_last_UV_W(l_switch,G2(:,:,:,43),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,22))
  call loop_VA_Q(G2(:,:,:,43),wf(:,8),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,62),MB,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,23))
  call loop_VA_Q(G2(:,:,:,43),wf(:,-1),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,58),MB,G3(:,:,:,54))
  call loop_AS_Q(G3(:,:,:,54),wf(:,-2),G3(:,:,:,55),gH)
  call loop_A_Q(G3(:,:,:,55),Q(:,62),MB,G4(:,:,:,29))
  call check_last_AQ_V(l_switch,G4(:,:,:,29),wf(:,0),G4tensor(:,21))
  call loop_VA_Q(G1(:,:,:,1),wf(:,44),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,58),MB,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,3),G2tensor(:,15))
  call loop_AS_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48),gH)
  call loop_A_Q(G2(:,:,:,48),Q(:,62),MB,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,24))
  call loop_VQ_A(G1(:,:,:,1),wf(:,300),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,61),MB,G2(:,:,:,49))
  call check_last_QA_V(l_switch,G2(:,:,:,49),wf(:,-1),G2tensor(:,16))
  call loop_VQ_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,13),MB,G2(:,:,:,50))
  call loop_QV_A(G2(:,:,:,50),wf(:,11),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,61),MB,G3(:,:,:,57))
  call check_last_QA_V(l_switch,G3(:,:,:,57),wf(:,-1),G3tensor(:,25))
  call loop_QV_A(G2(:,:,:,50),wf(:,-5),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,45),MB,G3(:,:,:,58))
  call loop_QV_A(G3(:,:,:,58),wf(:,-4),G3(:,:,:,59))
  call loop_Q_A(G3(:,:,:,59),Q(:,61),MB,G4(:,:,:,30))
  call check_last_QA_V(l_switch,G4(:,:,:,30),wf(:,-1),G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,50),wf(:,-4),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,29),MB,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,-5),G3(:,:,:,61))
  call loop_Q_A(G3(:,:,:,61),Q(:,61),MB,G4(:,:,:,31))
  call check_last_QA_V(l_switch,G4(:,:,:,31),wf(:,-1),G4tensor(:,23))
  call loop_VQ_A(G1(:,:,:,1),wf(:,417),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,61),MB,G2(:,:,:,54))
  call check_last_QA_V(l_switch,G2(:,:,:,54),wf(:,-1),G2tensor(:,17))
  call loop_VQ_A(G1(:,:,:,1),wf(:,16),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,29),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,61),MB,G3(:,:,:,62))
  call check_last_QA_V(l_switch,G3(:,:,:,62),wf(:,-1),G3tensor(:,26))
  call loop_VQ_A(G1(:,:,:,1),wf(:,422),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,61),MB,G2(:,:,:,57))
  call check_last_QA_V(l_switch,G2(:,:,:,57),wf(:,-1),G2tensor(:,18))
  call loop_VQ_A(G1(:,:,:,1),wf(:,130),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,45),MB,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,-4),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,61),MB,G3(:,:,:,63))
  call check_last_QA_V(l_switch,G3(:,:,:,63),wf(:,-1),G3tensor(:,27))
  call loop_VQ_A(G1(:,:,:,1),wf(:,188),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,57),MB,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,8),G2tensor(:,19))
  call loop_QS_A(G2(:,:,:,60),wf(:,-2),G2(:,:,:,61),gH)
  call loop_Q_A(G2(:,:,:,61),Q(:,61),MB,G3(:,:,:,64))
  call check_last_QA_V(l_switch,G3(:,:,:,64),wf(:,-1),G3tensor(:,28))
  call loop_VQ_A(G1(:,:,:,1),wf(:,55),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,25),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-5),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,57),MB,G3(:,:,:,65))
  call check_last_QA_V(l_switch,G3(:,:,:,65),wf(:,8),G3tensor(:,29))
  call loop_QS_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66),gH)
  call loop_Q_A(G3(:,:,:,66),Q(:,61),MB,G4(:,:,:,32))
  call check_last_QA_V(l_switch,G4(:,:,:,32),wf(:,-1),G4tensor(:,24))
  call loop_QS_A(G2(:,:,:,62),wf(:,-2),G2(:,:,:,64),gH)
  call loop_Q_A(G2(:,:,:,64),Q(:,29),MB,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,61),MB,G4(:,:,:,33))
  call check_last_QA_V(l_switch,G4(:,:,:,33),wf(:,-1),G4tensor(:,25))
  call loop_VQ_A(G1(:,:,:,1),wf(:,190),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,57),MB,G2(:,:,:,65))
  call check_last_QA_V(l_switch,G2(:,:,:,65),wf(:,8),G2tensor(:,20))
  call loop_QS_A(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66),gH)
  call loop_Q_A(G2(:,:,:,66),Q(:,61),MB,G3(:,:,:,69))
  call check_last_QA_V(l_switch,G3(:,:,:,69),wf(:,-1),G3tensor(:,30))
  call loop_VQ_A(G1(:,:,:,1),wf(:,63),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,41),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-4),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,57),MB,G3(:,:,:,70))
  call check_last_QA_V(l_switch,G3(:,:,:,70),wf(:,8),G3tensor(:,31))
  call loop_QS_A(G3(:,:,:,70),wf(:,-2),G3(:,:,:,71),gH)
  call loop_Q_A(G3(:,:,:,71),Q(:,61),MB,G4(:,:,:,34))
  call check_last_QA_V(l_switch,G4(:,:,:,34),wf(:,-1),G4tensor(:,26))
  call loop_QS_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,69),gH)
  call loop_Q_A(G2(:,:,:,69),Q(:,45),MB,G3(:,:,:,72))
  call loop_QV_A(G3(:,:,:,72),wf(:,-4),G3(:,:,:,73))
  call loop_Q_A(G3(:,:,:,73),Q(:,61),MB,G4(:,:,:,35))
  call check_last_QA_V(l_switch,G4(:,:,:,35),wf(:,-1),G4tensor(:,27))
  call loop_VQ_A(G1(:,:,:,1),wf(:,73),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,57),MB,G2(:,:,:,70))
  call check_last_QA_V(l_switch,G2(:,:,:,70),wf(:,8),G2tensor(:,21))
  call loop_QS_A(G2(:,:,:,70),wf(:,-2),G2(:,:,:,71),gH)
  call loop_Q_A(G2(:,:,:,71),Q(:,61),MB,G3(:,:,:,74))
  call check_last_QA_V(l_switch,G3(:,:,:,74),wf(:,-1),G3tensor(:,32))
  call loop_VA_Q(G1(:,:,:,1),wf(:,345),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,62),MB,G2(:,:,:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,72),wf(:,0),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,1),wf(:,8),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,14),MB,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,11),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,62),MB,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,0),G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-5),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,46),MB,G3(:,:,:,76))
  call loop_AV_Q(G3(:,:,:,76),wf(:,-4),G3(:,:,:,77))
  call loop_A_Q(G3(:,:,:,77),Q(:,62),MB,G4(:,:,:,36))
  call check_last_AQ_V(l_switch,G4(:,:,:,36),wf(:,0),G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-4),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,30),MB,G3(:,:,:,78))
  call loop_AV_Q(G3(:,:,:,78),wf(:,-5),G3(:,:,:,79))
  call loop_A_Q(G3(:,:,:,79),Q(:,62),MB,G4(:,:,:,37))
  call check_last_AQ_V(l_switch,G4(:,:,:,37),wf(:,0),G4tensor(:,29))
  call loop_VA_Q(G1(:,:,:,1),wf(:,436),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,62),MB,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,0),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,30),MB,G2(:,:,:,78))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-5),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,62),MB,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,34))
  call loop_VA_Q(G1(:,:,:,1),wf(:,440),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,62),MB,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,24))
  call loop_VA_Q(G1(:,:,:,1),wf(:,173),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,46),MB,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,62),MB,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,0),G3tensor(:,35))
  call loop_VQ_A(G1(:,:,:,1),wf(:,481),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,61),MB,G2(:,:,:,83))
  call check_last_QA_V(l_switch,G2(:,:,:,83),wf(:,-1),G2tensor(:,25))
  call loop_VQ_A(G1(:,:,:,1),wf(:,81),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,29),MB,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,-5),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,61),MB,G3(:,:,:,82))
  call check_last_QA_V(l_switch,G3(:,:,:,82),wf(:,-1),G3tensor(:,36))
  call loop_VQ_A(G1(:,:,:,1),wf(:,489),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,61),MB,G2(:,:,:,86))
  call check_last_QA_V(l_switch,G2(:,:,:,86),wf(:,-1),G2tensor(:,26))
  call loop_VA_Q(G1(:,:,:,1),wf(:,500),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,62),MB,G2(:,:,:,87))
  call check_last_AQ_V(l_switch,G2(:,:,:,87),wf(:,0),G2tensor(:,27))
  call loop_VA_Q(G1(:,:,:,1),wf(:,77),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,30),MB,G2(:,:,:,88))
  call loop_AV_Q(G2(:,:,:,88),wf(:,-5),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,62),MB,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,0),G3tensor(:,37))
  call loop_VA_Q(G1(:,:,:,1),wf(:,506),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,62),MB,G2(:,:,:,90))
  call check_last_AQ_V(l_switch,G2(:,:,:,90),wf(:,0),G2tensor(:,28))
  call loop_VQ_A(G1(:,:,:,1),wf(:,529),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,61),MB,G2(:,:,:,91))
  call check_last_QA_V(l_switch,G2(:,:,:,91),wf(:,-1),G2tensor(:,29))
  call loop_VQ_A(G1(:,:,:,1),wf(:,85),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,45),MB,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,-4),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,61),MB,G3(:,:,:,84))
  call check_last_QA_V(l_switch,G3(:,:,:,84),wf(:,-1),G3tensor(:,38))
  call loop_VQ_A(G1(:,:,:,1),wf(:,537),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,61),MB,G2(:,:,:,94))
  call check_last_QA_V(l_switch,G2(:,:,:,94),wf(:,-1),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,1),wf(:,548),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,62),MB,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,0),G2tensor(:,31))
  call loop_VA_Q(G1(:,:,:,1),wf(:,79),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,46),MB,G2(:,:,:,96))
  call loop_AV_Q(G2(:,:,:,96),wf(:,-4),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,62),MB,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,0),G3tensor(:,39))
  call loop_VA_Q(G1(:,:,:,1),wf(:,554),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,62),MB,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,0),G2tensor(:,32))
  call loop_VQ_A(G1(:,:,:,1),wf(:,574),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,61),MB,G2(:,:,:,99))
  call check_last_QA_V(l_switch,G2(:,:,:,99),wf(:,-1),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,1),wf(:,580),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,62),MB,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,0),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,10),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,11),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,58),MB,G3(:,:,:,86))
  call loop_AS_Q(G3(:,:,:,86),wf(:,-2),G3(:,:,:,87),gH)
  call loop_A_Q(G3(:,:,:,87),Q(:,62),MB,G4(:,:,:,38))
  call check_last_AQ_V(l_switch,G4(:,:,:,38),wf(:,0),G4tensor(:,30))
  call loop_AS_Q(G2(:,:,:,101),wf(:,-2),G2(:,:,:,103),gH)
  call loop_A_Q(G2(:,:,:,103),Q(:,14),MB,G3(:,:,:,88))
  call loop_AV_Q(G3(:,:,:,88),wf(:,11),G3(:,:,:,89))
  call loop_A_Q(G3(:,:,:,89),Q(:,62),MB,G4(:,:,:,39))
  call check_last_AQ_V(l_switch,G4(:,:,:,39),wf(:,0),G4tensor(:,31))
  call loop_AV_Q(G3(:,:,:,88),wf(:,-5),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,46),MB,G4(:,:,:,40))
  call loop_AV_Q(G4(:,:,:,40),wf(:,-4),G4(:,:,:,41))
  call loop_A_Q(G4(:,:,:,41),Q(:,62),MB,G5(:,:,:,7))
  call check_last_AQ_V(l_switch,G5(:,:,:,7),wf(:,0),G5tensor(:,7))
  call loop_AV_Q(G3(:,:,:,88),wf(:,-4),G3(:,:,:,91))
  call loop_A_Q(G3(:,:,:,91),Q(:,30),MB,G4(:,:,:,42))
  call loop_AV_Q(G4(:,:,:,42),wf(:,-5),G4(:,:,:,43))
  call loop_A_Q(G4(:,:,:,43),Q(:,62),MB,G5(:,:,:,8))
  call check_last_AQ_V(l_switch,G5(:,:,:,8),wf(:,0),G5tensor(:,8))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-4),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,26),MB,G3(:,:,:,92))
  call loop_AV_Q(G3(:,:,:,92),wf(:,-5),G3(:,:,:,93))
  call loop_A_Q(G3(:,:,:,93),Q(:,58),MB,G4(:,:,:,44))
  call loop_AS_Q(G4(:,:,:,44),wf(:,-2),G4(:,:,:,45),gH)
  call loop_A_Q(G4(:,:,:,45),Q(:,62),MB,G5(:,:,:,9))
  call check_last_AQ_V(l_switch,G5(:,:,:,9),wf(:,0),G5tensor(:,9))
  call loop_AS_Q(G3(:,:,:,92),wf(:,-2),G3(:,:,:,94),gH)
  call loop_A_Q(G3(:,:,:,94),Q(:,30),MB,G4(:,:,:,46))
  call loop_AV_Q(G4(:,:,:,46),wf(:,-5),G4(:,:,:,47))
  call loop_A_Q(G4(:,:,:,47),Q(:,62),MB,G5(:,:,:,10))
  call check_last_AQ_V(l_switch,G5(:,:,:,10),wf(:,0),G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-5),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,42),MB,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,58),MB,G4(:,:,:,48))
  call loop_AS_Q(G4(:,:,:,48),wf(:,-2),G4(:,:,:,49),gH)
  call loop_A_Q(G4(:,:,:,49),Q(:,62),MB,G5(:,:,:,11))
  call check_last_AQ_V(l_switch,G5(:,:,:,11),wf(:,0),G5tensor(:,11))
  call loop_AS_Q(G3(:,:,:,95),wf(:,-2),G3(:,:,:,97),gH)
  call loop_A_Q(G3(:,:,:,97),Q(:,46),MB,G4(:,:,:,50))
  call loop_AV_Q(G4(:,:,:,50),wf(:,-4),G4(:,:,:,51))
  call loop_A_Q(G4(:,:,:,51),Q(:,62),MB,G5(:,:,:,12))
  call check_last_AQ_V(l_switch,G5(:,:,:,12),wf(:,0),G5tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-3),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,22),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,58),MB,G1(:,:,:,51))
  call check_last_AQ_V(l_switch,G1(:,:,:,51),wf(:,3),G1tensor(:,1))
  call loop_AS_Q(G1(:,:,:,51),wf(:,-2),G1(:,:,:,52),gH)
  call loop_A_Q(G1(:,:,:,52),Q(:,62),MB,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,0),G2tensor(:,35))
  call loop_VQ_A(G0(:,:,:,2),wf(:,16),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,61),MB,G1(:,:,:,53))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,-1),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,2),wf(:,3),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,45),MB,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,-4),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,61),MB,G2(:,:,:,107))
  call check_last_QA_V(l_switch,G2(:,:,:,107),wf(:,-1),G2tensor(:,36))
  call loop_UV_W(G0(:,:,:,2),Q(:,40),wf(:,-4),Q(:,16),G1(:,:,:,56))
  call loop_VQ_A(G1(:,:,:,56),wf(:,3),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,61),MB,G2(:,:,:,108))
  call check_last_QA_V(l_switch,G2(:,:,:,108),wf(:,-1),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,56),wf(:,8),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,62),MB,G2(:,:,:,109))
  call check_last_AQ_V(l_switch,G2(:,:,:,109),wf(:,0),G2tensor(:,38))
  call loop_VA_Q(G1(:,:,:,56),wf(:,-1),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,58),MB,G2(:,:,:,110))
  call loop_AS_Q(G2(:,:,:,110),wf(:,-2),G2(:,:,:,111),gH)
  call loop_A_Q(G2(:,:,:,111),Q(:,62),MB,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,0),G3tensor(:,40))
  call loop_VQ_A(G0(:,:,:,2),wf(:,55),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,57),MB,G1(:,:,:,60))
  call check_last_QA_V(l_switch,G1(:,:,:,60),wf(:,8),G1tensor(:,3))
  call loop_QS_A(G1(:,:,:,60),wf(:,-2),G1(:,:,:,61),gH)
  call loop_Q_A(G1(:,:,:,61),Q(:,61),MB,G2(:,:,:,112))
  call check_last_QA_V(l_switch,G2(:,:,:,112),wf(:,-1),G2tensor(:,39))
  call loop_VA_Q(G0(:,:,:,2),wf(:,53),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,62),MB,G1(:,:,:,62))
  call check_last_AQ_V(l_switch,G1(:,:,:,62),wf(:,0),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,2),wf(:,8),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,46),MB,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-4),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,62),MB,G2(:,:,:,113))
  call check_last_AQ_V(l_switch,G2(:,:,:,113),wf(:,0),G2tensor(:,40))
  call loop_VQ_A(G0(:,:,:,2),wf(:,81),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,61),MB,G1(:,:,:,65))
  call check_last_QA_V(l_switch,G1(:,:,:,65),wf(:,-1),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,2),wf(:,77),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,62),MB,G1(:,:,:,66))
  call check_last_AQ_V(l_switch,G1(:,:,:,66),wf(:,0),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-1),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,42),MB,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-4),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,58),MB,G2(:,:,:,114))
  call loop_AS_Q(G2(:,:,:,114),wf(:,-2),G2(:,:,:,115),gH)
  call loop_A_Q(G2(:,:,:,115),Q(:,62),MB,G3(:,:,:,99))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,0),G3tensor(:,41))
  call loop_AS_Q(G1(:,:,:,67),wf(:,-2),G1(:,:,:,69),gH)
  call loop_A_Q(G1(:,:,:,69),Q(:,46),MB,G2(:,:,:,116))
  call loop_AV_Q(G2(:,:,:,116),wf(:,-4),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,62),MB,G3(:,:,:,100))
  call check_last_AQ_V(l_switch,G3(:,:,:,100),wf(:,0),G3tensor(:,42))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,-4),wf(:,4),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,4),wf(:,-4),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,2),wf(:,-4),wf(:,4),G0tensor(:,3))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,-4),wf(:,9),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,9),wf(:,-4),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,2),wf(:,-4),wf(:,9),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,23),Q(:,23),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,406),Q(:,23),G1tensor(:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,413),Q(:,23),G1tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,56),Q(:,23),G1tensor(:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,424),Q(:,23),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,427),Q(:,23),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,477),Q(:,23),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,40),wf(:,494),Q(:,23),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-5),G0(:,:,:,12))
  call loop_VA_Q(G0(:,:,:,12),wf(:,22),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,58),MB,G1(:,:,:,70))
  call check_last_AQ_V(l_switch,G1(:,:,:,70),wf(:,3),G1tensor(:,15))
  call loop_AS_Q(G1(:,:,:,70),wf(:,-2),G1(:,:,:,71),gH)
  call loop_A_Q(G1(:,:,:,71),Q(:,62),MB,G2(:,:,:,118))
  call check_last_AQ_V(l_switch,G2(:,:,:,118),wf(:,0),G2tensor(:,41))
  call loop_VQ_A(G0(:,:,:,12),wf(:,16),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,61),MB,G1(:,:,:,72))
  call check_last_QA_V(l_switch,G1(:,:,:,72),wf(:,-1),G1tensor(:,16))
  call loop_VQ_A(G0(:,:,:,12),wf(:,3),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,45),MB,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,-4),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,61),MB,G2(:,:,:,119))
  call check_last_QA_V(l_switch,G2(:,:,:,119),wf(:,-1),G2tensor(:,42))
  call loop_UV_W(G0(:,:,:,12),Q(:,40),wf(:,-4),Q(:,16),G1(:,:,:,75))
  call loop_VQ_A(G1(:,:,:,75),wf(:,3),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,61),MB,G2(:,:,:,120))
  call check_last_QA_V(l_switch,G2(:,:,:,120),wf(:,-1),G2tensor(:,43))
  call loop_VA_Q(G1(:,:,:,75),wf(:,8),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,62),MB,G2(:,:,:,121))
  call check_last_AQ_V(l_switch,G2(:,:,:,121),wf(:,0),G2tensor(:,44))
  call loop_VA_Q(G1(:,:,:,75),wf(:,-1),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,58),MB,G2(:,:,:,122))
  call loop_AS_Q(G2(:,:,:,122),wf(:,-2),G2(:,:,:,123),gH)
  call loop_A_Q(G2(:,:,:,123),Q(:,62),MB,G3(:,:,:,101))
  call check_last_AQ_V(l_switch,G3(:,:,:,101),wf(:,0),G3tensor(:,43))
  call loop_VQ_A(G0(:,:,:,12),wf(:,55),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,57),MB,G1(:,:,:,79))
  call check_last_QA_V(l_switch,G1(:,:,:,79),wf(:,8),G1tensor(:,17))
  call loop_QS_A(G1(:,:,:,79),wf(:,-2),G1(:,:,:,80),gH)
  call loop_Q_A(G1(:,:,:,80),Q(:,61),MB,G2(:,:,:,124))
  call check_last_QA_V(l_switch,G2(:,:,:,124),wf(:,-1),G2tensor(:,45))
  call loop_VA_Q(G0(:,:,:,12),wf(:,53),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,62),MB,G1(:,:,:,81))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,0),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,12),wf(:,8),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,46),MB,G1(:,:,:,82))
  call loop_AV_Q(G1(:,:,:,82),wf(:,-4),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,62),MB,G2(:,:,:,125))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,0),G2tensor(:,46))
  call loop_VQ_A(G0(:,:,:,12),wf(:,81),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,61),MB,G1(:,:,:,84))
  call check_last_QA_V(l_switch,G1(:,:,:,84),wf(:,-1),G1tensor(:,19))
  call loop_VA_Q(G0(:,:,:,12),wf(:,77),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,62),MB,G1(:,:,:,85))
  call check_last_AQ_V(l_switch,G1(:,:,:,85),wf(:,0),G1tensor(:,20))
  call loop_VA_Q(G0(:,:,:,12),wf(:,-1),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,42),MB,G1(:,:,:,86))
  call loop_AV_Q(G1(:,:,:,86),wf(:,-4),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,58),MB,G2(:,:,:,126))
  call loop_AS_Q(G2(:,:,:,126),wf(:,-2),G2(:,:,:,127),gH)
  call loop_A_Q(G2(:,:,:,127),Q(:,62),MB,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,44))
  call loop_AS_Q(G1(:,:,:,86),wf(:,-2),G1(:,:,:,88),gH)
  call loop_A_Q(G1(:,:,:,88),Q(:,46),MB,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-4),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,62),MB,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,45))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-4),wf(:,4),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,4),wf(:,-4),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,12),wf(:,-4),wf(:,4),G0tensor(:,9))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-4),wf(:,9),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,9),wf(:,-4),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,12),wf(:,-4),wf(:,9),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,23),Q(:,23),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,406),Q(:,23),G1tensor(:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,413),Q(:,23),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,56),Q(:,23),G1tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,424),Q(:,23),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,427),Q(:,23),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,477),Q(:,23),G1tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,40),wf(:,494),Q(:,23),G1tensor(:,28))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-3),G0(:,:,:,22))
  call loop_VA_Q(G0(:,:,:,22),wf(:,22),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,58),MB,G1(:,:,:,89))
  call check_last_AQ_V(l_switch,G1(:,:,:,89),wf(:,3),G1tensor(:,29))
  call loop_AS_Q(G1(:,:,:,89),wf(:,-2),G1(:,:,:,90),gH)
  call loop_A_Q(G1(:,:,:,90),Q(:,62),MB,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,0),G2tensor(:,47))
  call loop_VQ_A(G0(:,:,:,22),wf(:,16),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,61),MB,G1(:,:,:,91))
  call check_last_QA_V(l_switch,G1(:,:,:,91),wf(:,-1),G1tensor(:,30))
  call loop_VQ_A(G0(:,:,:,22),wf(:,3),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,45),MB,G1(:,:,:,92))
  call loop_QV_A(G1(:,:,:,92),wf(:,-4),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,61),MB,G2(:,:,:,131))
  call check_last_QA_V(l_switch,G2(:,:,:,131),wf(:,-1),G2tensor(:,48))
  call loop_UV_W(G0(:,:,:,22),Q(:,40),wf(:,-4),Q(:,16),G1(:,:,:,94))
  call loop_VQ_A(G1(:,:,:,94),wf(:,3),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,61),MB,G2(:,:,:,132))
  call check_last_QA_V(l_switch,G2(:,:,:,132),wf(:,-1),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,94),wf(:,8),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MB,G2(:,:,:,133))
  call check_last_AQ_V(l_switch,G2(:,:,:,133),wf(:,0),G2tensor(:,50))
  call loop_VA_Q(G1(:,:,:,94),wf(:,-1),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,58),MB,G2(:,:,:,134))
  call loop_AS_Q(G2(:,:,:,134),wf(:,-2),G2(:,:,:,135),gH)
  call loop_A_Q(G2(:,:,:,135),Q(:,62),MB,G3(:,:,:,104))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,0),G3tensor(:,46))
  call loop_VQ_A(G0(:,:,:,22),wf(:,55),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,57),MB,G1(:,:,:,98))
  call check_last_QA_V(l_switch,G1(:,:,:,98),wf(:,8),G1tensor(:,31))
  call loop_QS_A(G1(:,:,:,98),wf(:,-2),G1(:,:,:,99),gH)
  call loop_Q_A(G1(:,:,:,99),Q(:,61),MB,G2(:,:,:,136))
  call check_last_QA_V(l_switch,G2(:,:,:,136),wf(:,-1),G2tensor(:,51))
  call loop_VA_Q(G0(:,:,:,22),wf(:,53),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,62),MB,G1(:,:,:,100))
  call check_last_AQ_V(l_switch,G1(:,:,:,100),wf(:,0),G1tensor(:,32))
  call loop_VA_Q(G0(:,:,:,22),wf(:,8),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,46),MB,G1(:,:,:,101))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-4),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,62),MB,G2(:,:,:,137))
  call check_last_AQ_V(l_switch,G2(:,:,:,137),wf(:,0),G2tensor(:,52))
  call loop_VQ_A(G0(:,:,:,22),wf(:,81),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,61),MB,G1(:,:,:,103))
  call check_last_QA_V(l_switch,G1(:,:,:,103),wf(:,-1),G1tensor(:,33))
  call loop_VA_Q(G0(:,:,:,22),wf(:,77),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,62),MB,G1(:,:,:,104))
  call check_last_AQ_V(l_switch,G1(:,:,:,104),wf(:,0),G1tensor(:,34))
  call loop_VA_Q(G0(:,:,:,22),wf(:,-1),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,42),MB,G1(:,:,:,105))
  call loop_AV_Q(G1(:,:,:,105),wf(:,-4),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,58),MB,G2(:,:,:,138))
  call loop_AS_Q(G2(:,:,:,138),wf(:,-2),G2(:,:,:,139),gH)
  call loop_A_Q(G2(:,:,:,139),Q(:,62),MB,G3(:,:,:,105))
  call check_last_AQ_V(l_switch,G3(:,:,:,105),wf(:,0),G3tensor(:,47))
  call loop_AS_Q(G1(:,:,:,105),wf(:,-2),G1(:,:,:,107),gH)
  call loop_A_Q(G1(:,:,:,107),Q(:,46),MB,G2(:,:,:,140))
  call loop_AV_Q(G2(:,:,:,140),wf(:,-4),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,62),MB,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,0),G3tensor(:,48))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,4),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,4),wf(:,-4),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,4),G0tensor(:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,9),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,9),wf(:,-4),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,9),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,23),Q(:,23),G1tensor(:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,406),Q(:,23),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,413),Q(:,23),G1tensor(:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,56),Q(:,23),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,424),Q(:,23),G1tensor(:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,427),Q(:,23),G1tensor(:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,477),Q(:,23),G1tensor(:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,40),wf(:,494),Q(:,23),G1tensor(:,42))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,11),G0(:,:,:,32))
  call loop_VQ_A(G0(:,:,:,32),wf(:,3),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,61),MB,G1(:,:,:,108))
  call check_last_QA_V(l_switch,G1(:,:,:,108),wf(:,-1),G1tensor(:,43))
  call loop_VA_Q(G0(:,:,:,32),wf(:,8),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,62),MB,G1(:,:,:,109))
  call check_last_AQ_V(l_switch,G1(:,:,:,109),wf(:,0),G1tensor(:,44))
  call loop_VA_Q(G0(:,:,:,32),wf(:,-1),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,58),MB,G1(:,:,:,110))
  call loop_AS_Q(G1(:,:,:,110),wf(:,-2),G1(:,:,:,111),gH)
  call loop_A_Q(G1(:,:,:,111),Q(:,62),MB,G2(:,:,:,142))
  call check_last_AQ_V(l_switch,G2(:,:,:,142),wf(:,0),G2tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,46))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,-3),G0(:,:,:,36))
  call loop_VQ_A(G0(:,:,:,36),wf(:,3),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,61),MB,G1(:,:,:,112))
  call check_last_QA_V(l_switch,G1(:,:,:,112),wf(:,-1),G1tensor(:,47))
  call loop_VA_Q(G0(:,:,:,36),wf(:,8),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,62),MB,G1(:,:,:,113))
  call check_last_AQ_V(l_switch,G1(:,:,:,113),wf(:,0),G1tensor(:,48))
  call loop_VA_Q(G0(:,:,:,36),wf(:,-1),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,58),MB,G1(:,:,:,114))
  call loop_AS_Q(G1(:,:,:,114),wf(:,-2),G1(:,:,:,115),gH)
  call loop_A_Q(G1(:,:,:,115),Q(:,62),MB,G2(:,:,:,143))
  call check_last_AQ_V(l_switch,G2(:,:,:,143),wf(:,0),G2tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,50))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,11),G0(:,:,:,40))
  call loop_VQ_A(G0(:,:,:,40),wf(:,3),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,61),MB,G1(:,:,:,116))
  call check_last_QA_V(l_switch,G1(:,:,:,116),wf(:,-1),G1tensor(:,51))
  call loop_VA_Q(G0(:,:,:,40),wf(:,8),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,62),MB,G1(:,:,:,117))
  call check_last_AQ_V(l_switch,G1(:,:,:,117),wf(:,0),G1tensor(:,52))
  call loop_VA_Q(G0(:,:,:,40),wf(:,-1),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,58),MB,G1(:,:,:,118))
  call loop_AS_Q(G1(:,:,:,118),wf(:,-2),G1(:,:,:,119),gH)
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MB,G2(:,:,:,144))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,0),G2tensor(:,55))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,54))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,44))
  call loop_VA_Q(G0(:,:,:,44),wf(:,31),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,58),MB,G1(:,:,:,120))
  call check_last_AQ_V(l_switch,G1(:,:,:,120),wf(:,3),G1tensor(:,55))
  call loop_AS_Q(G1(:,:,:,120),wf(:,-2),G1(:,:,:,121),gH)
  call loop_A_Q(G1(:,:,:,121),Q(:,62),MB,G2(:,:,:,145))
  call check_last_AQ_V(l_switch,G2(:,:,:,145),wf(:,0),G2tensor(:,56))
  call loop_UV_W(G0(:,:,:,44),Q(:,24),wf(:,-5),Q(:,32),G1(:,:,:,122))
  call check_last_UV_W(l_switch,G1(:,:,:,122),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,57))
  call loop_VQ_A(G1(:,:,:,122),wf(:,3),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,61),MB,G2(:,:,:,146))
  call check_last_QA_V(l_switch,G2(:,:,:,146),wf(:,-1),G2tensor(:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,122),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,59))
  call loop_VA_Q(G1(:,:,:,122),wf(:,8),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MB,G2(:,:,:,147))
  call check_last_AQ_V(l_switch,G2(:,:,:,147),wf(:,0),G2tensor(:,60))
  call loop_VA_Q(G1(:,:,:,122),wf(:,-1),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,58),MB,G2(:,:,:,148))
  call loop_AS_Q(G2(:,:,:,148),wf(:,-2),G2(:,:,:,149),gH)
  call loop_A_Q(G2(:,:,:,149),Q(:,62),MB,G3(:,:,:,107))
  call check_last_AQ_V(l_switch,G3(:,:,:,107),wf(:,0),G3tensor(:,49))
  call loop_VQ_A(G0(:,:,:,44),wf(:,130),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,61),MB,G1(:,:,:,126))
  call check_last_QA_V(l_switch,G1(:,:,:,126),wf(:,-1),G1tensor(:,56))
  call loop_VQ_A(G0(:,:,:,44),wf(:,3),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,29),MB,G1(:,:,:,127))
  call loop_QV_A(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,61),MB,G2(:,:,:,150))
  call check_last_QA_V(l_switch,G2(:,:,:,150),wf(:,-1),G2tensor(:,61))
  call loop_VQ_A(G0(:,:,:,44),wf(:,63),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,57),MB,G1(:,:,:,129))
  call check_last_QA_V(l_switch,G1(:,:,:,129),wf(:,8),G1tensor(:,57))
  call loop_QS_A(G1(:,:,:,129),wf(:,-2),G1(:,:,:,130),gH)
  call loop_Q_A(G1(:,:,:,130),Q(:,61),MB,G2(:,:,:,151))
  call check_last_QA_V(l_switch,G2(:,:,:,151),wf(:,-1),G2tensor(:,62))
  call loop_VA_Q(G0(:,:,:,44),wf(:,173),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,62),MB,G1(:,:,:,131))
  call check_last_AQ_V(l_switch,G1(:,:,:,131),wf(:,0),G1tensor(:,58))
  call loop_VA_Q(G0(:,:,:,44),wf(:,8),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,30),MB,G1(:,:,:,132))
  call loop_AV_Q(G1(:,:,:,132),wf(:,-5),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,62),MB,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,0),G2tensor(:,63))
  call loop_VQ_A(G0(:,:,:,44),wf(:,85),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,61),MB,G1(:,:,:,134))
  call check_last_QA_V(l_switch,G1(:,:,:,134),wf(:,-1),G1tensor(:,59))
  call loop_VA_Q(G0(:,:,:,44),wf(:,79),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,62),MB,G1(:,:,:,135))
  call check_last_AQ_V(l_switch,G1(:,:,:,135),wf(:,0),G1tensor(:,60))
  call loop_VA_Q(G0(:,:,:,44),wf(:,-1),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,26),MB,G1(:,:,:,136))
  call loop_AV_Q(G1(:,:,:,136),wf(:,-5),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,58),MB,G2(:,:,:,153))
  call loop_AS_Q(G2(:,:,:,153),wf(:,-2),G2(:,:,:,154),gH)
  call loop_A_Q(G2(:,:,:,154),Q(:,62),MB,G3(:,:,:,108))
  call check_last_AQ_V(l_switch,G3(:,:,:,108),wf(:,0),G3tensor(:,50))
  call loop_AS_Q(G1(:,:,:,136),wf(:,-2),G1(:,:,:,138),gH)
  call loop_A_Q(G1(:,:,:,138),Q(:,30),MB,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,62),MB,G3(:,:,:,109))
  call check_last_AQ_V(l_switch,G3(:,:,:,109),wf(:,0),G3tensor(:,51))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-4),G0(:,:,:,54))
  call loop_VA_Q(G0(:,:,:,54),wf(:,31),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,58),MB,G1(:,:,:,139))
  call check_last_AQ_V(l_switch,G1(:,:,:,139),wf(:,3),G1tensor(:,61))
  call loop_AS_Q(G1(:,:,:,139),wf(:,-2),G1(:,:,:,140),gH)
  call loop_A_Q(G1(:,:,:,140),Q(:,62),MB,G2(:,:,:,157))
  call check_last_AQ_V(l_switch,G2(:,:,:,157),wf(:,0),G2tensor(:,64))
  call loop_UV_W(G0(:,:,:,54),Q(:,24),wf(:,-5),Q(:,32),G1(:,:,:,141))
  call check_last_UV_W(l_switch,G1(:,:,:,141),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,65))
  call loop_VQ_A(G1(:,:,:,141),wf(:,3),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,61),MB,G2(:,:,:,158))
  call check_last_QA_V(l_switch,G2(:,:,:,158),wf(:,-1),G2tensor(:,66))
  call check_last_UV_W(l_switch,G1(:,:,:,141),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,67))
  call loop_VA_Q(G1(:,:,:,141),wf(:,8),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,62),MB,G2(:,:,:,159))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,0),G2tensor(:,68))
  call loop_VA_Q(G1(:,:,:,141),wf(:,-1),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,58),MB,G2(:,:,:,160))
  call loop_AS_Q(G2(:,:,:,160),wf(:,-2),G2(:,:,:,161),gH)
  call loop_A_Q(G2(:,:,:,161),Q(:,62),MB,G3(:,:,:,110))
  call check_last_AQ_V(l_switch,G3(:,:,:,110),wf(:,0),G3tensor(:,52))
  call loop_VQ_A(G0(:,:,:,54),wf(:,130),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,61),MB,G1(:,:,:,145))
  call check_last_QA_V(l_switch,G1(:,:,:,145),wf(:,-1),G1tensor(:,62))
  call loop_VQ_A(G0(:,:,:,54),wf(:,3),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,29),MB,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,-5),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,61),MB,G2(:,:,:,162))
  call check_last_QA_V(l_switch,G2(:,:,:,162),wf(:,-1),G2tensor(:,69))
  call loop_VQ_A(G0(:,:,:,54),wf(:,63),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,57),MB,G1(:,:,:,148))
  call check_last_QA_V(l_switch,G1(:,:,:,148),wf(:,8),G1tensor(:,63))
  call loop_QS_A(G1(:,:,:,148),wf(:,-2),G1(:,:,:,149),gH)
  call loop_Q_A(G1(:,:,:,149),Q(:,61),MB,G2(:,:,:,163))
  call check_last_QA_V(l_switch,G2(:,:,:,163),wf(:,-1),G2tensor(:,70))
  call loop_VA_Q(G0(:,:,:,54),wf(:,173),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,62),MB,G1(:,:,:,150))
  call check_last_AQ_V(l_switch,G1(:,:,:,150),wf(:,0),G1tensor(:,64))
  call loop_VA_Q(G0(:,:,:,54),wf(:,8),G0(:,:,:,60))
  call loop_A_Q(G0(:,:,:,60),Q(:,30),MB,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,62),MB,G2(:,:,:,164))
  call check_last_AQ_V(l_switch,G2(:,:,:,164),wf(:,0),G2tensor(:,71))
  call loop_VQ_A(G0(:,:,:,54),wf(:,85),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,61),MB,G1(:,:,:,153))
  call check_last_QA_V(l_switch,G1(:,:,:,153),wf(:,-1),G1tensor(:,65))
  call loop_VA_Q(G0(:,:,:,54),wf(:,79),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,62),MB,G1(:,:,:,154))
  call check_last_AQ_V(l_switch,G1(:,:,:,154),wf(:,0),G1tensor(:,66))
  call loop_VA_Q(G0(:,:,:,54),wf(:,-1),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,26),MB,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,58),MB,G2(:,:,:,165))
  call loop_AS_Q(G2(:,:,:,165),wf(:,-2),G2(:,:,:,166),gH)
  call loop_A_Q(G2(:,:,:,166),Q(:,62),MB,G3(:,:,:,111))
  call check_last_AQ_V(l_switch,G3(:,:,:,111),wf(:,0),G3tensor(:,53))
  call loop_AS_Q(G1(:,:,:,155),wf(:,-2),G1(:,:,:,157),gH)
  call loop_A_Q(G1(:,:,:,157),Q(:,30),MB,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,62),MB,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,0),G3tensor(:,54))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,64))
  call loop_VA_Q(G0(:,:,:,64),wf(:,31),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,58),MB,G1(:,:,:,158))
  call check_last_AQ_V(l_switch,G1(:,:,:,158),wf(:,3),G1tensor(:,67))
  call loop_AS_Q(G1(:,:,:,158),wf(:,-2),G1(:,:,:,159),gH)
  call loop_A_Q(G1(:,:,:,159),Q(:,62),MB,G2(:,:,:,169))
  call check_last_AQ_V(l_switch,G2(:,:,:,169),wf(:,0),G2tensor(:,72))
  call loop_UV_W(G0(:,:,:,64),Q(:,24),wf(:,-5),Q(:,32),G1(:,:,:,160))
  call check_last_UV_W(l_switch,G1(:,:,:,160),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,73))
  call loop_VQ_A(G1(:,:,:,160),wf(:,3),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,61),MB,G2(:,:,:,170))
  call check_last_QA_V(l_switch,G2(:,:,:,170),wf(:,-1),G2tensor(:,74))
  call check_last_UV_W(l_switch,G1(:,:,:,160),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,160),wf(:,8),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,62),MB,G2(:,:,:,171))
  call check_last_AQ_V(l_switch,G2(:,:,:,171),wf(:,0),G2tensor(:,76))
  call loop_VA_Q(G1(:,:,:,160),wf(:,-1),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,58),MB,G2(:,:,:,172))
  call loop_AS_Q(G2(:,:,:,172),wf(:,-2),G2(:,:,:,173),gH)
  call loop_A_Q(G2(:,:,:,173),Q(:,62),MB,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,0),G3tensor(:,55))
  call loop_VQ_A(G0(:,:,:,64),wf(:,130),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,61),MB,G1(:,:,:,164))
  call check_last_QA_V(l_switch,G1(:,:,:,164),wf(:,-1),G1tensor(:,68))
  call loop_VQ_A(G0(:,:,:,64),wf(:,3),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,29),MB,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,-5),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,61),MB,G2(:,:,:,174))
  call check_last_QA_V(l_switch,G2(:,:,:,174),wf(:,-1),G2tensor(:,77))
  call loop_VQ_A(G0(:,:,:,64),wf(:,63),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,57),MB,G1(:,:,:,167))
  call check_last_QA_V(l_switch,G1(:,:,:,167),wf(:,8),G1tensor(:,69))
  call loop_QS_A(G1(:,:,:,167),wf(:,-2),G1(:,:,:,168),gH)
  call loop_Q_A(G1(:,:,:,168),Q(:,61),MB,G2(:,:,:,175))
  call check_last_QA_V(l_switch,G2(:,:,:,175),wf(:,-1),G2tensor(:,78))
  call loop_VA_Q(G0(:,:,:,64),wf(:,173),G0(:,:,:,69))
  call loop_A_Q(G0(:,:,:,69),Q(:,62),MB,G1(:,:,:,169))
  call check_last_AQ_V(l_switch,G1(:,:,:,169),wf(:,0),G1tensor(:,70))
  call loop_VA_Q(G0(:,:,:,64),wf(:,8),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,30),MB,G1(:,:,:,170))
  call loop_AV_Q(G1(:,:,:,170),wf(:,-5),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,62),MB,G2(:,:,:,176))
  call check_last_AQ_V(l_switch,G2(:,:,:,176),wf(:,0),G2tensor(:,79))
  call loop_VQ_A(G0(:,:,:,64),wf(:,85),G0(:,:,:,71))
  call loop_Q_A(G0(:,:,:,71),Q(:,61),MB,G1(:,:,:,172))
  call check_last_QA_V(l_switch,G1(:,:,:,172),wf(:,-1),G1tensor(:,71))
  call loop_VA_Q(G0(:,:,:,64),wf(:,79),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,62),MB,G1(:,:,:,173))
  call check_last_AQ_V(l_switch,G1(:,:,:,173),wf(:,0),G1tensor(:,72))
  call loop_VA_Q(G0(:,:,:,64),wf(:,-1),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,26),MB,G1(:,:,:,174))
  call loop_AV_Q(G1(:,:,:,174),wf(:,-5),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,58),MB,G2(:,:,:,177))
  call loop_AS_Q(G2(:,:,:,177),wf(:,-2),G2(:,:,:,178),gH)
  call loop_A_Q(G2(:,:,:,178),Q(:,62),MB,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,56))
  call loop_AS_Q(G1(:,:,:,174),wf(:,-2),G1(:,:,:,176),gH)
  call loop_A_Q(G1(:,:,:,176),Q(:,30),MB,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-5),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,62),MB,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,0),G3tensor(:,57))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,1),T3sum(1:15,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,5),T3sum(1:15,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,9),T3sum(1:15,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,9),T3sum(1:15,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,9),T3sum(1:15,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,9),T3sum(1:15,11))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,2),T3sum(1:15,12))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,2),T3sum(1:15,12))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,2),T3sum(1:15,12))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,2),T3sum(1:15,12))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,2),T3sum(1:15,12))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,6),T3sum(1:15,12))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,6),T3sum(1:15,12))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,6),T3sum(1:15,12))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,6),T3sum(1:15,12))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,6),T3sum(1:15,12))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,10),T3sum(1:15,12))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,10),T3sum(1:15,12))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,10),T3sum(1:15,12))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_164,masses2_16,G2tensor(:,10),T3sum(1:15,12))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,1),T2sum(1:5,4))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,1),T2sum(1:5,4))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,15),T2sum(1:5,4))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,15),T2sum(1:5,4))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,29),T2sum(1:5,4))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(18)) * TI2_call(1,momenta_96,masses2_9,G1tensor(:,29),T2sum(1:5,4))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,2),T2sum(1:5,5))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,2),T2sum(1:5,5))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,16),T2sum(1:5,5))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,16),T2sum(1:5,5))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,30),T2sum(1:5,5))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,30),T2sum(1:5,5))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,36),T3sum(1:15,18))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,36),T3sum(1:15,18))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,36),T3sum(1:15,18))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,42),T3sum(1:15,18))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,42),T3sum(1:15,18))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,42),T3sum(1:15,18))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,48),T3sum(1:15,18))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_284,masses2_15,G2tensor(:,48),T3sum(1:15,18))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,37),T3sum(1:15,19))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,37),T3sum(1:15,19))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,37),T3sum(1:15,19))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,37),T3sum(1:15,19))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,37),T3sum(1:15,19))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,43),T3sum(1:15,19))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,43),T3sum(1:15,19))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,43),T3sum(1:15,19))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,43),T3sum(1:15,19))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,43),T3sum(1:15,19))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,49),T3sum(1:15,19))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,49),T3sum(1:15,19))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,49),T3sum(1:15,19))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_286,masses2_16,G2tensor(:,49),T3sum(1:15,19))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,55),T2sum(1:5,6))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,55),T2sum(1:5,6))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,61),T2sum(1:5,6))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,61),T2sum(1:5,6))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,67),T2sum(1:5,6))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(1,momenta_64,masses2_9,G1tensor(:,67),T2sum(1:5,6))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,57),T3sum(1:15,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,65),T3sum(1:15,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,73),T3sum(1:15,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,73),T3sum(1:15,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,73),T3sum(1:15,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,73),T3sum(1:15,20))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,56),T2sum(1:5,7))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,56),T2sum(1:5,7))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,62),T2sum(1:5,7))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,62),T2sum(1:5,7))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,68),T2sum(1:5,7))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,68),T2sum(1:5,7))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,61),T3sum(1:15,22))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,61),T3sum(1:15,22))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,61),T3sum(1:15,22))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,69),T3sum(1:15,22))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,69),T3sum(1:15,22))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,69),T3sum(1:15,22))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,77),T3sum(1:15,22))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_230,masses2_15,G2tensor(:,77),T3sum(1:15,22))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,58),T3sum(1:15,23))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,58),T3sum(1:15,23))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,58),T3sum(1:15,23))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,58),T3sum(1:15,23))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,58),T3sum(1:15,23))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,66),T3sum(1:15,23))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,66),T3sum(1:15,23))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,66),T3sum(1:15,23))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,66),T3sum(1:15,23))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,66),T3sum(1:15,23))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,74),T3sum(1:15,23))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,74),T3sum(1:15,23))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,74),T3sum(1:15,23))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_232,masses2_16,G2tensor(:,74),T3sum(1:15,23))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,3),T3sum(1:15,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,7),T3sum(1:15,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,11),T3sum(1:15,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,11),T3sum(1:15,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,11),T3sum(1:15,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_25,masses2_10,G2tensor(:,11),T3sum(1:15,11))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,4),T3sum(1:15,24))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,4),T3sum(1:15,24))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,4),T3sum(1:15,24))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,4),T3sum(1:15,24))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,4),T3sum(1:15,24))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,8),T3sum(1:15,24))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,8),T3sum(1:15,24))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,8),T3sum(1:15,24))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,8),T3sum(1:15,24))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,8),T3sum(1:15,24))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,12),T3sum(1:15,24))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,12),T3sum(1:15,24))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,12),T3sum(1:15,24))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_165,masses2_16,G2tensor(:,12),T3sum(1:15,24))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,3),T2sum(1:5,12))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,3),T2sum(1:5,12))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,17),T2sum(1:5,12))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,17),T2sum(1:5,12))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,31),T2sum(1:5,12))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(55)) * TI2_call(1,momenta_95,masses2_9,G1tensor(:,31),T2sum(1:5,12))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,4),T2sum(1:5,13))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,4),T2sum(1:5,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,18),T2sum(1:5,13))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,18),T2sum(1:5,13))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,32),T2sum(1:5,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(52)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,32),T2sum(1:5,13))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,40),T3sum(1:15,28))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,40),T3sum(1:15,28))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,40),T3sum(1:15,28))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,46),T3sum(1:15,28))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,46),T3sum(1:15,28))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,46),T3sum(1:15,28))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,52),T3sum(1:15,28))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_285,masses2_15,G2tensor(:,52),T3sum(1:15,28))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,38),T3sum(1:15,29))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,38),T3sum(1:15,29))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,38),T3sum(1:15,29))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,38),T3sum(1:15,29))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,38),T3sum(1:15,29))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,44),T3sum(1:15,29))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,44),T3sum(1:15,29))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,44),T3sum(1:15,29))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,44),T3sum(1:15,29))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,44),T3sum(1:15,29))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,50),T3sum(1:15,29))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,50),T3sum(1:15,29))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,50),T3sum(1:15,29))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_287,masses2_16,G2tensor(:,50),T3sum(1:15,29))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,57),T2sum(1:5,14))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,57),T2sum(1:5,14))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,63),T2sum(1:5,14))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,63),T2sum(1:5,14))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,69),T2sum(1:5,14))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(1,momenta_63,masses2_9,G1tensor(:,69),T2sum(1:5,14))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,59),T3sum(1:15,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,67),T3sum(1:15,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,75),T3sum(1:15,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,75),T3sum(1:15,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,75),T3sum(1:15,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_62,masses2_10,G2tensor(:,75),T3sum(1:15,20))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,58),T2sum(1:5,15))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,58),T2sum(1:5,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,64),T2sum(1:5,15))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,64),T2sum(1:5,15))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,70),T2sum(1:5,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,70),T2sum(1:5,15))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,63),T3sum(1:15,31))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,63),T3sum(1:15,31))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,63),T3sum(1:15,31))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,71),T3sum(1:15,31))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,71),T3sum(1:15,31))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,71),T3sum(1:15,31))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,79),T3sum(1:15,31))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_231,masses2_15,G2tensor(:,79),T3sum(1:15,31))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,60),T3sum(1:15,32))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,60),T3sum(1:15,32))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,60),T3sum(1:15,32))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,60),T3sum(1:15,32))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,60),T3sum(1:15,32))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,68),T3sum(1:15,32))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,68),T3sum(1:15,32))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,68),T3sum(1:15,32))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,68),T3sum(1:15,32))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,68),T3sum(1:15,32))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,76),T3sum(1:15,32))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,76),T3sum(1:15,32))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,76),T3sum(1:15,32))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_233,masses2_16,G2tensor(:,76),T3sum(1:15,32))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,1),T4sum(1:35,1))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,1),T4sum(1:35,1))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,1),T4sum(1:35,1))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,1),T4sum(1:35,1))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,1),T4sum(1:35,1))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,2),T4sum(1:35,1))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,2),T4sum(1:35,1))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,2),T4sum(1:35,1))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,2),T4sum(1:35,1))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,2),T4sum(1:35,1))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,3),T4sum(1:35,1))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,3),T4sum(1:35,1))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,3),T4sum(1:35,1))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_371,masses2_22,G3tensor(:,3),T4sum(1:35,1))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,5),T2sum(1:5,5))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,5),T2sum(1:5,5))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,19),T2sum(1:5,5))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,19),T2sum(1:5,5))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,33),T2sum(1:5,5))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(89)) * TI2_call(1,momenta_97,masses2_9,G1tensor(:,33),T2sum(1:5,5))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,39),T3sum(1:15,36))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,39),T3sum(1:15,36))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,45),T3sum(1:15,36))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,45),T3sum(1:15,36))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,51),T3sum(1:15,36))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_288,masses2_15,G2tensor(:,51),T3sum(1:15,36))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,6),T2sum(1:5,13))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,6),T2sum(1:5,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,20),T2sum(1:5,13))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,20),T2sum(1:5,13))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,34),T2sum(1:5,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(82)) * TI2_call(1,momenta_98,masses2_9,G1tensor(:,34),T2sum(1:5,13))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,35),T3sum(1:15,37))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,35),T3sum(1:15,37))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,41),T3sum(1:15,37))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,41),T3sum(1:15,37))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,47),T3sum(1:15,37))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_289,masses2_15,G2tensor(:,47),T3sum(1:15,37))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,53),T3sum(1:15,35))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,53),T3sum(1:15,35))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,53),T3sum(1:15,35))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,53),T3sum(1:15,35))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,54),T3sum(1:15,35))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,54),T3sum(1:15,35))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,54),T3sum(1:15,35))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,54),T3sum(1:15,35))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,55),T3sum(1:15,35))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,55),T3sum(1:15,35))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,55),T3sum(1:15,35))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,55),T3sum(1:15,35))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,40),T4sum(1:35,6))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,40),T4sum(1:35,6))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,40),T4sum(1:35,6))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,40),T4sum(1:35,6))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,40),T4sum(1:35,6))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,43),T4sum(1:35,6))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,43),T4sum(1:35,6))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,43),T4sum(1:35,6))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,43),T4sum(1:35,6))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,43),T4sum(1:35,6))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,46),T4sum(1:35,6))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,46),T4sum(1:35,6))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,46),T4sum(1:35,6))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_469,masses2_22,G3tensor(:,46),T4sum(1:35,6))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,41),T4sum(1:35,7))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,41),T4sum(1:35,7))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,41),T4sum(1:35,7))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,44),T4sum(1:35,7))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,44),T4sum(1:35,7))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,44),T4sum(1:35,7))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,47),T4sum(1:35,7))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_468,masses2_21,G3tensor(:,47),T4sum(1:35,7))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,42),T4sum(1:35,8))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,42),T4sum(1:35,8))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,42),T4sum(1:35,8))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,45),T4sum(1:35,8))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,45),T4sum(1:35,8))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,45),T4sum(1:35,8))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,48),T4sum(1:35,8))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_467,masses2_21,G3tensor(:,48),T4sum(1:35,8))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,59),T2sum(1:5,7))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,59),T2sum(1:5,7))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,65),T2sum(1:5,7))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,65),T2sum(1:5,7))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,71),T2sum(1:5,7))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(1,momenta_66,masses2_9,G1tensor(:,71),T2sum(1:5,7))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,62),T3sum(1:15,38))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,62),T3sum(1:15,38))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,70),T3sum(1:15,38))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,70),T3sum(1:15,38))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,78),T3sum(1:15,38))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(2,momenta_234,masses2_15,G2tensor(:,78),T3sum(1:15,38))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,60),T2sum(1:5,15))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,60),T2sum(1:5,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,66),T2sum(1:5,15))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,66),T2sum(1:5,15))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,72),T2sum(1:5,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(1,momenta_67,masses2_9,G1tensor(:,72),T2sum(1:5,15))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,56),T3sum(1:15,39))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,56),T3sum(1:15,39))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,64),T3sum(1:15,39))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,64),T3sum(1:15,39))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,72),T3sum(1:15,39))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_235,masses2_15,G2tensor(:,72),T3sum(1:15,39))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,49),T4sum(1:35,10))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,49),T4sum(1:35,10))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,49),T4sum(1:35,10))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,49),T4sum(1:35,10))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,49),T4sum(1:35,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,52),T4sum(1:35,10))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,52),T4sum(1:35,10))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,52),T4sum(1:35,10))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,52),T4sum(1:35,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,52),T4sum(1:35,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,55),T4sum(1:35,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,55),T4sum(1:35,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,55),T4sum(1:35,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_427,masses2_22,G3tensor(:,55),T4sum(1:35,10))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,50),T4sum(1:35,11))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,50),T4sum(1:35,11))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,50),T4sum(1:35,11))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,53),T4sum(1:35,11))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,53),T4sum(1:35,11))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,53),T4sum(1:35,11))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,56),T4sum(1:35,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_426,masses2_21,G3tensor(:,56),T4sum(1:35,11))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,51),T4sum(1:35,12))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,51),T4sum(1:35,12))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,51),T4sum(1:35,12))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,54),T4sum(1:35,12))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,54),T4sum(1:35,12))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,54),T4sum(1:35,12))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,57),T4sum(1:35,12))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_425,masses2_21,G3tensor(:,57),T4sum(1:35,12))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(153)) * TI2_call(2,momenta_27,masses2_9,G2tensor(:,13),T2sum(1:15,34))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_155,masses2_16,G3tensor(:,5),T3sum(1:35,59))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_155,masses2_16,G3tensor(:,5),T3sum(1:35,59))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_149,masses2_15,G3tensor(:,11),T3sum(1:35,63))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(156)) * TI2_call(2,momenta_27,masses2_9,G2tensor(:,14),T2sum(1:15,34))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_144,masses2_16,G3tensor(:,13),T3sum(1:35,72))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_144,masses2_16,G3tensor(:,13),T3sum(1:35,72))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_160,masses2_15,G3tensor(:,19),T3sum(1:35,76))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,20),T3sum(1:35,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,20),T3sum(1:35,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,20),T3sum(1:35,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,20),T3sum(1:35,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(44)) * TI2_call(2,momenta_27,masses2_9,G2tensor(:,15),T2sum(1:15,34))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(44)) * TI2_call(2,momenta_27,masses2_9,G2tensor(:,15),T2sum(1:15,34))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(266)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,16),T2sum(1:15,48))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(266)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,16),T2sum(1:15,48))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_164,masses2_16,G3tensor(:,21),T3sum(1:35,12))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_164,masses2_16,G3tensor(:,21),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_164,masses2_16,G3tensor(:,21),T3sum(1:35,12))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_164,masses2_16,G3tensor(:,21),T3sum(1:35,12))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(264)) * TI2_call(3,momenta_140,masses2_15,G3tensor(:,25),T3sum(1:35,85))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_140,masses2_15,G3tensor(:,25),T3sum(1:35,85))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,12),T4sum(1:70,52))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,2),T4sum(1:70,55))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(481)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,17),T2sum(1:15,48))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_151,masses2_15,G3tensor(:,26),T3sum(1:35,94))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_157,masses2_16,G3tensor(:,6),T3sum(1:35,96))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_157,masses2_16,G3tensor(:,6),T3sum(1:35,96))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(484)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,18),T2sum(1:15,48))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_162,masses2_15,G3tensor(:,27),T3sum(1:35,100))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_146,masses2_16,G3tensor(:,14),T3sum(1:35,102))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_146,masses2_16,G3tensor(:,14),T3sum(1:35,102))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_361,masses2_22,G4tensor(:,6),T4sum(1:70,59))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_361,masses2_22,G4tensor(:,6),T4sum(1:70,59))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_361,masses2_22,G4tensor(:,6),T4sum(1:70,59))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_346,masses2_21,G4tensor(:,22),T4sum(1:70,60))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_346,masses2_21,G4tensor(:,22),T4sum(1:70,60))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_350,masses2_22,G4tensor(:,16),T4sum(1:70,63))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_350,masses2_22,G4tensor(:,16),T4sum(1:70,63))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_350,masses2_22,G4tensor(:,16),T4sum(1:70,63))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_345,masses2_21,G4tensor(:,23),T4sum(1:70,64))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_345,masses2_21,G4tensor(:,23),T4sum(1:70,64))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_352,masses2_23,G4tensor(:,13),T4sum(1:70,67))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_352,masses2_23,G4tensor(:,13),T4sum(1:70,67))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_352,masses2_23,G4tensor(:,13),T4sum(1:70,67))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_352,masses2_23,G4tensor(:,13),T4sum(1:70,67))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_352,masses2_23,G4tensor(:,13),T4sum(1:70,67))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_363,masses2_23,G4tensor(:,3),T4sum(1:70,69))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_363,masses2_23,G4tensor(:,3),T4sum(1:70,69))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_363,masses2_23,G4tensor(:,3),T4sum(1:70,69))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_363,masses2_23,G4tensor(:,3),T4sum(1:70,69))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_363,masses2_23,G4tensor(:,3),T4sum(1:70,69))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(166)) * TI2_call(2,momenta_26,masses2_9,G2tensor(:,19),T2sum(1:15,60))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(55)) * TI2_call(3,momenta_154,masses2_16,G3tensor(:,7),T3sum(1:35,114))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(55)) * TI2_call(3,momenta_154,masses2_16,G3tensor(:,7),T3sum(1:35,114))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(55)) * TI2_call(3,momenta_148,masses2_15,G3tensor(:,29),T3sum(1:35,116))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(169)) * TI2_call(2,momenta_26,masses2_9,G2tensor(:,20),T2sum(1:15,60))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_143,masses2_16,G3tensor(:,15),T3sum(1:35,123))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_143,masses2_16,G3tensor(:,15),T3sum(1:35,123))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_159,masses2_15,G3tensor(:,31),T3sum(1:35,125))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,22),T3sum(1:35,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,22),T3sum(1:35,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,22),T3sum(1:35,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,22),T3sum(1:35,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(79)) * TI2_call(2,momenta_26,masses2_9,G2tensor(:,21),T2sum(1:15,60))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(79)) * TI2_call(2,momenta_26,masses2_9,G2tensor(:,21),T2sum(1:15,60))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(336)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,22),T2sum(1:15,78))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(336)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,22),T2sum(1:15,78))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_165,masses2_16,G3tensor(:,23),T3sum(1:35,24))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_165,masses2_16,G3tensor(:,23),T3sum(1:35,24))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_165,masses2_16,G3tensor(:,23),T3sum(1:35,24))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_165,masses2_16,G3tensor(:,23),T3sum(1:35,24))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_141,masses2_15,G3tensor(:,33),T3sum(1:35,130))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(334)) * TI2_call(3,momenta_141,masses2_15,G3tensor(:,33),T3sum(1:35,130))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,14),T4sum(1:70,52))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,4),T4sum(1:70,55))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(494)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,23),T2sum(1:15,78))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_152,masses2_15,G3tensor(:,34),T3sum(1:35,139))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_158,masses2_16,G3tensor(:,8),T3sum(1:35,141))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_158,masses2_16,G3tensor(:,8),T3sum(1:35,141))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(496)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,24),T2sum(1:15,78))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_163,masses2_15,G3tensor(:,35),T3sum(1:35,145))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_147,masses2_16,G3tensor(:,16),T3sum(1:35,147))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_147,masses2_16,G3tensor(:,16),T3sum(1:35,147))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_362,masses2_22,G4tensor(:,8),T4sum(1:70,83))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_362,masses2_22,G4tensor(:,8),T4sum(1:70,83))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_362,masses2_22,G4tensor(:,8),T4sum(1:70,83))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_348,masses2_21,G4tensor(:,28),T4sum(1:70,84))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_348,masses2_21,G4tensor(:,28),T4sum(1:70,84))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_351,masses2_22,G4tensor(:,18),T4sum(1:70,87))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_351,masses2_22,G4tensor(:,18),T4sum(1:70,87))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_351,masses2_22,G4tensor(:,18),T4sum(1:70,87))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_347,masses2_21,G4tensor(:,29),T4sum(1:70,88))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_347,masses2_21,G4tensor(:,29),T4sum(1:70,88))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_353,masses2_23,G4tensor(:,15),T4sum(1:70,91))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_353,masses2_23,G4tensor(:,15),T4sum(1:70,91))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_353,masses2_23,G4tensor(:,15),T4sum(1:70,91))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_353,masses2_23,G4tensor(:,15),T4sum(1:70,91))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_353,masses2_23,G4tensor(:,15),T4sum(1:70,91))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_364,masses2_23,G4tensor(:,5),T4sum(1:70,93))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_364,masses2_23,G4tensor(:,5),T4sum(1:70,93))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_364,masses2_23,G4tensor(:,5),T4sum(1:70,93))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_364,masses2_23,G4tensor(:,5),T4sum(1:70,93))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_364,masses2_23,G4tensor(:,5),T4sum(1:70,93))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(528)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,25),T2sum(1:15,48))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_151,masses2_15,G3tensor(:,36),T3sum(1:35,94))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_157,masses2_16,G3tensor(:,9),T3sum(1:35,96))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_157,masses2_16,G3tensor(:,9),T3sum(1:35,96))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(533)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,26),T2sum(1:15,48))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_166,masses2_15,G3tensor(:,28),T3sum(1:35,183))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_357,masses2_21,G4tensor(:,24),T4sum(1:70,130))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_365,masses2_22,G4tensor(:,7),T4sum(1:70,131))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_365,masses2_22,G4tensor(:,7),T4sum(1:70,131))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_356,masses2_21,G4tensor(:,25),T4sum(1:70,137))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(542)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,27),T2sum(1:15,78))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(82)) * TI2_call(3,momenta_152,masses2_15,G3tensor(:,37),T3sum(1:35,139))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(82)) * TI2_call(3,momenta_158,masses2_16,G3tensor(:,10),T3sum(1:35,141))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(82)) * TI2_call(3,momenta_158,masses2_16,G3tensor(:,10),T3sum(1:35,141))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(545)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,28),T2sum(1:15,78))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(152)) * TI2_call(3,momenta_167,masses2_15,G3tensor(:,4),T3sum(1:35,191))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_359,masses2_21,G4tensor(:,9),T4sum(1:70,142))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_366,masses2_22,G4tensor(:,1),T4sum(1:70,143))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_366,masses2_22,G4tensor(:,1),T4sum(1:70,143))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_358,masses2_21,G4tensor(:,10),T4sum(1:70,149))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(559)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,29),T2sum(1:15,48))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_162,masses2_15,G3tensor(:,38),T3sum(1:35,100))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_146,masses2_16,G3tensor(:,17),T3sum(1:35,102))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_146,masses2_16,G3tensor(:,17),T3sum(1:35,102))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(564)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,30),T2sum(1:15,48))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(168)) * TI2_call(3,momenta_166,masses2_15,G3tensor(:,30),T3sum(1:35,183))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_368,masses2_21,G4tensor(:,26),T4sum(1:70,162))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_354,masses2_22,G4tensor(:,17),T4sum(1:70,163))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_354,masses2_22,G4tensor(:,17),T4sum(1:70,163))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_367,masses2_21,G4tensor(:,27),T4sum(1:70,169))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(572)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,31),T2sum(1:15,78))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_163,masses2_15,G3tensor(:,39),T3sum(1:35,145))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_147,masses2_16,G3tensor(:,18),T3sum(1:35,147))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_147,masses2_16,G3tensor(:,18),T3sum(1:35,147))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(575)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,32),T2sum(1:15,78))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(155)) * TI2_call(3,momenta_167,masses2_15,G3tensor(:,12),T3sum(1:35,191))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_370,masses2_21,G4tensor(:,19),T4sum(1:70,174))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_355,masses2_22,G4tensor(:,11),T4sum(1:70,175))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_355,masses2_22,G4tensor(:,11),T4sum(1:70,175))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_369,masses2_21,G4tensor(:,20),T4sum(1:70,181))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(587)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,33),T2sum(1:15,48))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(587)) * TI2_call(2,momenta_29,masses2_9,G2tensor(:,33),T2sum(1:15,48))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(78)) * TI2_call(3,momenta_166,masses2_15,G3tensor(:,32),T3sum(1:35,183))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(78)) * TI2_call(3,momenta_166,masses2_15,G3tensor(:,32),T3sum(1:35,183))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(590)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,34),T2sum(1:15,78))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(590)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,34),T2sum(1:15,78))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(43)) * TI2_call(3,momenta_167,masses2_15,G3tensor(:,24),T3sum(1:35,191))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(43)) * TI2_call(3,momenta_167,masses2_15,G3tensor(:,24),T3sum(1:35,191))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_371,masses2_22,G4tensor(:,21),T4sum(1:70,1))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_371,masses2_22,G4tensor(:,21),T4sum(1:70,1))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_371,masses2_22,G4tensor(:,21),T4sum(1:70,1))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_371,masses2_22,G4tensor(:,21),T4sum(1:70,1))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_342,masses2_21,G4tensor(:,30),T4sum(1:70,200))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(7)) * TI2_call(4,momenta_342,masses2_21,G4tensor(:,30),T4sum(1:70,200))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_341,masses2_21,G4tensor(:,31),T4sum(1:70,201))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(7)) * TI2_call(4,momenta_341,masses2_21,G4tensor(:,31),T4sum(1:70,201))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_508,masses2_27,G5tensor(:,1),T5sum(1:126,49))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_508,masses2_27,G5tensor(:,1),T5sum(1:126,49))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_508,masses2_27,G5tensor(:,1),T5sum(1:126,49))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_508,masses2_27,G5tensor(:,1),T5sum(1:126,49))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_508,masses2_27,G5tensor(:,1),T5sum(1:126,49))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_505,masses2_27,G5tensor(:,4),T5sum(1:126,50))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_505,masses2_27,G5tensor(:,4),T5sum(1:126,50))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_505,masses2_27,G5tensor(:,4),T5sum(1:126,50))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_505,masses2_27,G5tensor(:,4),T5sum(1:126,50))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_505,masses2_27,G5tensor(:,4),T5sum(1:126,50))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_500,masses2_25,G5tensor(:,9),T5sum(1:126,51))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_500,masses2_25,G5tensor(:,9),T5sum(1:126,51))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_502,masses2_25,G5tensor(:,11),T5sum(1:126,52))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_502,masses2_25,G5tensor(:,11),T5sum(1:126,52))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_507,masses2_26,G5tensor(:,2),T5sum(1:126,53))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_507,masses2_26,G5tensor(:,2),T5sum(1:126,53))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_507,masses2_26,G5tensor(:,2),T5sum(1:126,53))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_504,masses2_26,G5tensor(:,5),T5sum(1:126,54))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_504,masses2_26,G5tensor(:,5),T5sum(1:126,54))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_504,masses2_26,G5tensor(:,5),T5sum(1:126,54))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_498,masses2_25,G5tensor(:,7),T5sum(1:126,67))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_498,masses2_25,G5tensor(:,7),T5sum(1:126,67))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_506,masses2_26,G5tensor(:,3),T5sum(1:126,70))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_506,masses2_26,G5tensor(:,3),T5sum(1:126,70))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_506,masses2_26,G5tensor(:,3),T5sum(1:126,70))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_501,masses2_25,G5tensor(:,12),T5sum(1:126,71))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_501,masses2_25,G5tensor(:,12),T5sum(1:126,71))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_497,masses2_25,G5tensor(:,8),T5sum(1:126,73))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_497,masses2_25,G5tensor(:,8),T5sum(1:126,73))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_503,masses2_26,G5tensor(:,6),T5sum(1:126,75))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_503,masses2_26,G5tensor(:,6),T5sum(1:126,75))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_503,masses2_26,G5tensor(:,6),T5sum(1:126,75))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_499,masses2_25,G5tensor(:,10),T5sum(1:126,77))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_499,masses2_25,G5tensor(:,10),T5sum(1:126,77))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,1),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,7),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,13),T2sum(1:1,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,13),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,13),T2sum(1:1,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,13),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,2),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,8),T2sum(1:1,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,14),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,14),T2sum(1:1,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,14),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,14),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,3),T2sum(1:1,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,3),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,3),T2sum(1:1,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,3),T2sum(1:1,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,9),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,9),T2sum(1:1,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,9),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,9),T2sum(1:1,86))
  M(2) = M(2) + (-3*f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,15),T2sum(1:1,86))
  M(3) = M(3) + (3*f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,15),T2sum(1:1,86))
  M(4) = M(4) + (-3*f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,15),T2sum(1:1,86))
  M(5) = M(5) + (3*f(17) * den(30)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,15),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,4),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,10),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,16),T2sum(1:1,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,16),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,16),T2sum(1:1,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,16),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,5),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,11),T2sum(1:1,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,17),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,17),T2sum(1:1,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,17),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,17),T2sum(1:1,86))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,6),T2sum(1:1,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,6),T2sum(1:1,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,6),T2sum(1:1,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,6),T2sum(1:1,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,12),T2sum(1:1,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,12),T2sum(1:1,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,12),T2sum(1:1,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,12),T2sum(1:1,86))
  M(2) = M(2) + (-3*f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,18),T2sum(1:1,86))
  M(3) = M(3) + (3*f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,18),T2sum(1:1,86))
  M(4) = M(4) + (-3*f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,18),T2sum(1:1,86))
  M(5) = M(5) + (3*f(17) * den(65)) * TI2_call(0,momenta_7,masses2_4,G0tensor(:,18),T2sum(1:1,86))
  M(3) = M(3) + ((3*CI*f(15))/2._/**/REALKIND * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,7),T2sum(1:5,86))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,7),T2sum(1:5,86))
  M(3) = M(3) + ((-3*CI*f(15))/2._/**/REALKIND * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,21),T2sum(1:5,86))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,21),T2sum(1:5,86))
  M(3) = M(3) + (-3*CI*f(15) * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,35),T2sum(1:5,86))
  M(4) = M(4) + (3*CI*f(15) * den(287)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,35),T2sum(1:5,86))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(1) = M(1) + (-3*f(17) * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(2) = M(2) + (3*f(17) * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(4) = M(4) + (3*f(17) * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(6) = M(6) + (-3*f(17) * den(41)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,8),T2sum(1:5,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,8),T2sum(1:5,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,8),T2sum(1:5,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,8),T2sum(1:5,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,22),T2sum(1:5,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,22),T2sum(1:5,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,22),T2sum(1:5,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,22),T2sum(1:5,86))
  M(2) = M(2) + (-3*f(17) * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,36),T2sum(1:5,86))
  M(3) = M(3) + (3*f(17) * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,36),T2sum(1:5,86))
  M(4) = M(4) + (-3*f(17) * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,36),T2sum(1:5,86))
  M(5) = M(5) + (3*f(17) * den(474)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,36),T2sum(1:5,86))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,9),T2sum(1:5,86))
  M(5) = M(5) + ((-3*CI*f(15))/2._/**/REALKIND * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,9),T2sum(1:5,86))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,23),T2sum(1:5,86))
  M(5) = M(5) + ((3*CI*f(15))/2._/**/REALKIND * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,23),T2sum(1:5,86))
  M(2) = M(2) + (-3*CI*f(15) * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,37),T2sum(1:5,86))
  M(5) = M(5) + (3*CI*f(15) * den(479)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,37),T2sum(1:5,86))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,10),T2sum(1:5,86))
  M(5) = M(5) + ((-3*CI*f(15))/2._/**/REALKIND * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,10),T2sum(1:5,86))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,24),T2sum(1:5,86))
  M(5) = M(5) + ((3*CI*f(15))/2._/**/REALKIND * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,24),T2sum(1:5,86))
  M(2) = M(2) + (-3*CI*f(15) * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,38),T2sum(1:5,86))
  M(5) = M(5) + (3*CI*f(15) * den(358)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,38),T2sum(1:5,86))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(1) = M(1) + (-3*f(17) * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(2) = M(2) + (3*f(17) * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(4) = M(4) + (3*f(17) * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(6) = M(6) + (-3*f(17) * den(76)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,11),T2sum(1:5,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,11),T2sum(1:5,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,11),T2sum(1:5,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,11),T2sum(1:5,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,25),T2sum(1:5,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,25),T2sum(1:5,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,25),T2sum(1:5,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,25),T2sum(1:5,86))
  M(2) = M(2) + (-3*f(17) * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,39),T2sum(1:5,86))
  M(3) = M(3) + (3*f(17) * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,39),T2sum(1:5,86))
  M(4) = M(4) + (-3*f(17) * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,39),T2sum(1:5,86))
  M(5) = M(5) + (3*f(17) * den(486)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,39),T2sum(1:5,86))
  M(3) = M(3) + ((3*CI*f(15))/2._/**/REALKIND * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(3) = M(3) + ((-3*CI*f(15))/2._/**/REALKIND * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,26),T2sum(1:5,86))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,26),T2sum(1:5,86))
  M(3) = M(3) + (-3*CI*f(15) * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,40),T2sum(1:5,86))
  M(4) = M(4) + (3*CI*f(15) * den(489)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,40),T2sum(1:5,86))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(5) = M(5) + ((-3*CI*f(15))/2._/**/REALKIND * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,27),T2sum(1:5,86))
  M(5) = M(5) + ((3*CI*f(15))/2._/**/REALKIND * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,27),T2sum(1:5,86))
  M(2) = M(2) + (-3*CI*f(15) * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,41),T2sum(1:5,86))
  M(5) = M(5) + (3*CI*f(15) * den(526)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,41),T2sum(1:5,86))
  M(3) = M(3) + ((3*CI*f(15))/2._/**/REALKIND * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(3) = M(3) + ((-3*CI*f(15))/2._/**/REALKIND * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,28),T2sum(1:5,86))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,28),T2sum(1:5,86))
  M(3) = M(3) + (-3*CI*f(15) * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,42),T2sum(1:5,86))
  M(4) = M(4) + (3*CI*f(15) * den(538)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,42),T2sum(1:5,86))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G0tensorhel)
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_3_pphjjj2_bbxhggg_1_/**/REALKIND
