
module ol_vamp_3_pphjjj2_bbbxbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_bbbxbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_bbbxbxhg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_bbbxbxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_bbbxbxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,70) :: G0
  complex(REALKIND), dimension(4,5,4,346) :: G1
  complex(REALKIND), dimension(4,15,4,423) :: G2
  complex(REALKIND), dimension(4,35,4,156) :: G3
  complex(REALKIND), dimension(4,70,4,29) :: G4
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,36,32))
    allocate(G2tensorhel(15,145,32))
    allocate(G3tensorhel(35,154,32))
    allocate(G4tensorhel(70,29,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,17),MB,G1(:,:,:,1))
  call loop_QA_V(G1(:,:,:,1),wf(:,5),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,57),wf(:,24),Q(:,6),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,61),MB,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-1),G2tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,49),MB,G2(:,:,:,2))
  call check_last_QA_V(l_switch,G2(:,:,:,2),wf(:,31),G2tensor(:,3))
  call loop_QV_A(G2(:,:,:,2),wf(:,24),G2(:,:,:,3))
  call loop_Q_A(G2(:,:,:,3),Q(:,55),MB,G3(:,:,:,1))
  call check_last_QA_V(l_switch,G3(:,:,:,1),wf(:,-3),G3tensor(:,1))
  call check_last_QA_V(l_switch,G2(:,:,:,2),wf(:,60),G2tensor(:,4))
  call loop_QV_A(G2(:,:,:,2),wf(:,55),G2(:,:,:,4))
  call loop_Q_A(G2(:,:,:,4),Q(:,59),MB,G3(:,:,:,2))
  call check_last_QA_V(l_switch,G3(:,:,:,2),wf(:,-2),G3tensor(:,2))
  call loop_QA_V(G2(:,:,:,2),wf(:,-3),G2(:,:,:,5))
  call loop_VA_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,61),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-1),G3tensor(:,3))
  call loop_QA_V(G2(:,:,:,2),wf(:,-2),G2(:,:,:,7))
  call loop_VA_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,61),MB,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-1),G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,28),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,55),MB,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-3),G2tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,24),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,23),MB,G2(:,:,:,10))
  call loop_QV_A(G2(:,:,:,10),wf(:,-5),G2(:,:,:,11))
  call loop_Q_A(G2(:,:,:,11),Q(:,55),MB,G3(:,:,:,5))
  call check_last_QA_V(l_switch,G3(:,:,:,5),wf(:,-3),G3tensor(:,5))
  call loop_QA_V(G1(:,:,:,1),wf(:,-3),G1(:,:,:,7))
  call loop_UV_W(G1(:,:,:,7),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,12))
  call check_last_UV_W(l_switch,G2(:,:,:,12),Q(:,57),wf(:,24),Q(:,6),G3tensor(:,6))
  call loop_VA_Q(G2(:,:,:,12),wf(:,-2),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,61),MB,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,7))
  call loop_VQ_A(G1(:,:,:,7),wf(:,14),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,59),MB,G2(:,:,:,14))
  call check_last_QA_V(l_switch,G2(:,:,:,14),wf(:,-2),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,7),wf(:,41),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,61),MB,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,-1),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,7),wf(:,-2),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,29),MB,G2(:,:,:,16))
  call loop_AV_Q(G2(:,:,:,16),wf(:,-5),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,61),MB,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,8))
  call loop_QA_V(G1(:,:,:,1),wf(:,41),G1(:,:,:,11))
  call check_last_UV_W(l_switch,G1(:,:,:,11),Q(:,53),wf(:,55),Q(:,10),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,11),wf(:,-3),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,61),MB,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-1),G2tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,58),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,59),MB,G2(:,:,:,19))
  call check_last_QA_V(l_switch,G2(:,:,:,19),wf(:,-2),G2tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,55),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,27),MB,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,-5),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,59),MB,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,-2),G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,66),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,55),MB,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,-3),G2tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,65),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,59),MB,G2(:,:,:,23))
  call check_last_QA_V(l_switch,G2(:,:,:,23),wf(:,-2),G2tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,67),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,55),MB,G2(:,:,:,24))
  call check_last_QA_V(l_switch,G2(:,:,:,24),wf(:,-3),G2tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,68),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,59),MB,G2(:,:,:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,25),wf(:,-2),G2tensor(:,14))
  call loop_QA_V(G1(:,:,:,1),wf(:,-2),G1(:,:,:,19))
  call loop_VA_Q(G1(:,:,:,19),wf(:,5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,61),MB,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,15))
  call loop_UV_W(G1(:,:,:,19),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,27))
  call loop_VA_Q(G2(:,:,:,27),wf(:,-3),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,61),MB,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-1),G3tensor(:,10))
  call loop_VA_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,29),MB,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,61),MB,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,11))
  call loop_AV_Q(G0(:,:,:,1),wf(:,27),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,25),ZERO,G1(:,:,:,22))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,57),ZERO,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,24),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),ZERO,G3tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,27),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,25),MT,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-5),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,57),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,24),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,27),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,25),ZERO,G1(:,:,:,26))
  call loop_QV_A(G1(:,:,:,26),wf(:,-5),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,57),ZERO,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,24),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),ZERO,G3tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,27),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,25),MT,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,57),MT,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,24),G2(:,:,:,38))
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G0(:,:,:,1),wf(:,27),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,25),MB,G1(:,:,:,30))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,57),MB,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,24),G2(:,:,:,40))
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,27),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,25),MB,G1(:,:,:,32))
  call loop_QV_A(G1(:,:,:,32),wf(:,-5),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,57),MB,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,24),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,17))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,27),G1(:,:,:,34))
  call loop_DV_C(G1(:,:,:,34),Q(:,25),wf(:,-5),G2(:,:,:,43))
  call check_last_DV_C(l_switch,G2(:,:,:,43),Q(:,57),wf(:,24),G3tensor(:,18))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,27),Q(:,25),G1(:,:,:,35))
  call loop_CV_D(G1(:,:,:,35),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,44))
  call check_last_CV_D(l_switch,G2(:,:,:,44),Q(:,57),wf(:,24),Q(:,6),G3tensor(:,19))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,27),Q(:,25),G1(:,:,:,36))
  call loop_UV_W(G1(:,:,:,36),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,45))
  call check_last_UV_W(l_switch,G2(:,:,:,45),Q(:,57),wf(:,24),Q(:,6),G3tensor(:,20))
  call loop_VA_Q(G2(:,:,:,45),wf(:,-2),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,61),MB,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,-1),G3tensor(:,21))
  call loop_VQ_A(G1(:,:,:,36),wf(:,14),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,59),MB,G2(:,:,:,47))
  call check_last_QA_V(l_switch,G2(:,:,:,47),wf(:,-2),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,36),wf(:,41),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,61),MB,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,-1),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,36),wf(:,-2),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,29),MB,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-5),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,61),MB,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-1),G3tensor(:,22))
  call loop_VQ_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,49),MB,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,24),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,55),MB,G2(:,:,:,51))
  call check_last_QA_V(l_switch,G2(:,:,:,51),wf(:,-3),G2tensor(:,18))
  call loop_QV_A(G1(:,:,:,40),wf(:,55),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,59),MB,G2(:,:,:,52))
  call check_last_QA_V(l_switch,G2(:,:,:,52),wf(:,-2),G2tensor(:,19))
  call loop_QA_V(G1(:,:,:,40),wf(:,-3),G1(:,:,:,43))
  call loop_VA_Q(G1(:,:,:,43),wf(:,-2),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,61),MB,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,-1),G2tensor(:,20))
  call loop_QA_V(G1(:,:,:,40),wf(:,-2),G1(:,:,:,45))
  call loop_VA_Q(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,61),MB,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,-1),G2tensor(:,21))
  call check_last_QA_V(l_switch,G1(:,:,:,40),wf(:,31),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,40),wf(:,60),G1tensor(:,2))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,38),G1(:,:,:,47))
  call loop_VQ_A(G1(:,:,:,47),wf(:,25),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,55),MB,G2(:,:,:,55))
  call check_last_QA_V(l_switch,G2(:,:,:,55),wf(:,-3),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,47),wf(:,15),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,62),MB,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,0),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,47),wf(:,-3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,46),MB,G2(:,:,:,57))
  call loop_AS_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58),gH)
  call loop_A_Q(G2(:,:,:,58),Q(:,62),MB,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,38),wf(:,27),Q(:,25),G2tensor(:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,38),wf(:,37),Q(:,25),G2tensor(:,25))
  call loop_VQ_A(G0(:,:,:,1),wf(:,253),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,23),MB,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,-5),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,55),MB,G2(:,:,:,59))
  call check_last_QA_V(l_switch,G2(:,:,:,59),wf(:,-3),G2tensor(:,26))
  call loop_VQ_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,33),MB,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,24),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,39),MB,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,15),G2tensor(:,27))
  call loop_QS_A(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61),gH)
  call loop_Q_A(G2(:,:,:,61),Q(:,55),MB,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,-3),G3tensor(:,24))
  call loop_QS_A(G1(:,:,:,53),wf(:,-4),G1(:,:,:,55),gH)
  call loop_Q_A(G1(:,:,:,55),Q(:,49),MB,G2(:,:,:,62))
  call check_last_QA_V(l_switch,G2(:,:,:,62),wf(:,31),G2tensor(:,28))
  call loop_QV_A(G2(:,:,:,62),wf(:,24),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,55),MB,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-3),G3tensor(:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,62),wf(:,60),G2tensor(:,29))
  call loop_QV_A(G2(:,:,:,62),wf(:,55),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,59),MB,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,26))
  call loop_QA_V(G2(:,:,:,62),wf(:,-3),G2(:,:,:,65))
  call loop_VA_Q(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,61),MB,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,27))
  call loop_QA_V(G2(:,:,:,62),wf(:,-2),G2(:,:,:,67))
  call loop_VA_Q(G2(:,:,:,67),wf(:,-3),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,61),MB,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-1),G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,53),wf(:,55),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,43),MB,G2(:,:,:,69))
  call check_last_QA_V(l_switch,G2(:,:,:,69),wf(:,48),G2tensor(:,30))
  call loop_QS_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70),gH)
  call loop_Q_A(G2(:,:,:,70),Q(:,59),MB,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,53),wf(:,45),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,55),MB,G2(:,:,:,71))
  call check_last_QA_V(l_switch,G2(:,:,:,71),wf(:,-3),G2tensor(:,31))
  call loop_QV_A(G1(:,:,:,53),wf(:,10),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,59),MB,G2(:,:,:,72))
  call check_last_QA_V(l_switch,G2(:,:,:,72),wf(:,-2),G2tensor(:,32))
  call loop_QA_V(G1(:,:,:,53),wf(:,-3),G1(:,:,:,59))
  call loop_VQ_A(G1(:,:,:,59),wf(:,4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,59),MB,G2(:,:,:,73))
  call check_last_QA_V(l_switch,G2(:,:,:,73),wf(:,-2),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,59),wf(:,48),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,61),MB,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,-1),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,59),wf(:,-2),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,45),MB,G2(:,:,:,75))
  call loop_AS_Q(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76),gH)
  call loop_A_Q(G2(:,:,:,76),Q(:,61),MB,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-1),G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,53),wf(:,53),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,55),MB,G2(:,:,:,77))
  call check_last_QA_V(l_switch,G2(:,:,:,77),wf(:,-3),G2tensor(:,35))
  call loop_QA_V(G1(:,:,:,53),wf(:,48),G1(:,:,:,64))
  call loop_VA_Q(G1(:,:,:,64),wf(:,-3),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,61),MB,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,-1),G2tensor(:,36))
  call loop_QV_A(G1(:,:,:,53),wf(:,20),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,59),MB,G2(:,:,:,79))
  call check_last_QA_V(l_switch,G2(:,:,:,79),wf(:,-2),G2tensor(:,37))
  call loop_QA_V(G1(:,:,:,53),wf(:,15),G1(:,:,:,67))
  call loop_VA_Q(G1(:,:,:,67),wf(:,-2),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,61),MB,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,-1),G2tensor(:,38))
  call loop_QA_V(G1(:,:,:,53),wf(:,-2),G1(:,:,:,69))
  call loop_VA_Q(G1(:,:,:,69),wf(:,15),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,61),MB,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-1),G2tensor(:,39))
  call loop_VA_Q(G1(:,:,:,69),wf(:,-3),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,45),MB,G2(:,:,:,82))
  call loop_AS_Q(G2(:,:,:,82),wf(:,-4),G2(:,:,:,83),gH)
  call loop_A_Q(G2(:,:,:,83),Q(:,61),MB,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,-1),G3tensor(:,31))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,263),G1tensor(:,3))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,351),G1tensor(:,4))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,307),G1tensor(:,5))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,379),G1tensor(:,6))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,401),G1tensor(:,7))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,404),G1tensor(:,8))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,417),G1tensor(:,9))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,429),G1tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,25),ZERO,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,-5),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,57),ZERO,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,24),G2(:,:,:,85))
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,25),MT,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,-5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,57),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,24),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,25),ZERO,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-5),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,57),ZERO,G2(:,:,:,88))
  call loop_AV_Q(G2(:,:,:,88),wf(:,24),G2(:,:,:,89))
  call check_last_A_Q(l_switch,G2(:,:,:,89),Q(:,63),ZERO,G3tensor(:,34))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,25),MT,G1(:,:,:,78))
  call loop_AV_Q(G1(:,:,:,78),wf(:,-5),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,57),MT,G2(:,:,:,90))
  call loop_AV_Q(G2(:,:,:,90),wf(:,24),G2(:,:,:,91))
  call check_last_A_Q(l_switch,G2(:,:,:,91),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,25),MB,G1(:,:,:,80))
  call loop_QV_A(G1(:,:,:,80),wf(:,-5),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,57),MB,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,24),G2(:,:,:,93))
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,63),MB,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,25),MB,G1(:,:,:,82))
  call loop_AV_Q(G1(:,:,:,82),wf(:,-5),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,57),MB,G2(:,:,:,94))
  call loop_AV_Q(G2(:,:,:,94),wf(:,24),G2(:,:,:,95))
  call check_last_A_Q(l_switch,G2(:,:,:,95),Q(:,63),MB,G3tensor(:,37))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,25),G1(:,:,:,84))
  call loop_CV_D(G1(:,:,:,84),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,96))
  call check_last_CV_D(l_switch,G2(:,:,:,96),Q(:,57),wf(:,24),Q(:,6),G3tensor(:,38))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,37),G1(:,:,:,85))
  call loop_DV_C(G1(:,:,:,85),Q(:,25),wf(:,-5),G2(:,:,:,97))
  call check_last_DV_C(l_switch,G2(:,:,:,97),Q(:,57),wf(:,24),G3tensor(:,39))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,25),G1(:,:,:,86))
  call loop_UV_W(G1(:,:,:,86),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,98))
  call check_last_UV_W(l_switch,G2(:,:,:,98),Q(:,57),wf(:,24),Q(:,6),G3tensor(:,40))
  call loop_VA_Q(G2(:,:,:,98),wf(:,-2),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,61),MB,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-1),G3tensor(:,41))
  call loop_VQ_A(G1(:,:,:,86),wf(:,14),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,59),MB,G2(:,:,:,100))
  call check_last_QA_V(l_switch,G2(:,:,:,100),wf(:,-2),G2tensor(:,40))
  call loop_VA_Q(G1(:,:,:,86),wf(:,41),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,61),MB,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-1),G2tensor(:,41))
  call loop_VA_Q(G1(:,:,:,86),wf(:,-2),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,29),MB,G2(:,:,:,102))
  call loop_AV_Q(G2(:,:,:,102),wf(:,-5),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,61),MB,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,-1),G3tensor(:,42))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,24),Q(:,6),G1(:,:,:,90))
  call loop_VA_Q(G1(:,:,:,90),wf(:,144),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,62),MB,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,0),G2tensor(:,42))
  call loop_VA_Q(G1(:,:,:,90),wf(:,15),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,30),MB,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,62),MB,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,0),G3tensor(:,43))
  call loop_UV_W(G1(:,:,:,90),Q(:,6),wf(:,-5),Q(:,32),G2(:,:,:,107))
  call loop_VA_Q(G2(:,:,:,107),wf(:,15),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,62),MB,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,0),G3tensor(:,44))
  call loop_VA_Q(G2(:,:,:,107),wf(:,-3),G2(:,:,:,109))
  call loop_A_Q(G2(:,:,:,109),Q(:,46),MB,G3(:,:,:,26))
  call loop_AS_Q(G3(:,:,:,26),wf(:,-4),G3(:,:,:,27),gH)
  call loop_A_Q(G3(:,:,:,27),Q(:,62),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_VA_Q(G1(:,:,:,90),wf(:,148),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,62),MB,G2(:,:,:,110))
  call check_last_AQ_V(l_switch,G2(:,:,:,110),wf(:,0),G2tensor(:,43))
  call loop_VA_Q(G1(:,:,:,90),wf(:,5),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,46),MB,G2(:,:,:,111))
  call loop_AS_Q(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112),gH)
  call loop_A_Q(G2(:,:,:,112),Q(:,62),MB,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,45))
  call loop_VA_Q(G1(:,:,:,90),wf(:,-3),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,14),MB,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-5),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,46),MB,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-4),G3(:,:,:,30),gH)
  call loop_A_Q(G3(:,:,:,30),Q(:,62),MB,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AS_Q(G2(:,:,:,113),wf(:,-4),G2(:,:,:,115),gH)
  call loop_A_Q(G2(:,:,:,115),Q(:,30),MB,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,-5),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,62),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,263),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,30),MB,G1(:,:,:,96))
  call loop_AV_Q(G1(:,:,:,96),wf(:,-5),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,62),MB,G2(:,:,:,116))
  call check_last_AQ_V(l_switch,G2(:,:,:,116),wf(:,0),G2tensor(:,44))
  call loop_VQ_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,49),MB,G1(:,:,:,98))
  call loop_QV_A(G1(:,:,:,98),wf(:,24),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,55),MB,G2(:,:,:,117))
  call check_last_QA_V(l_switch,G2(:,:,:,117),wf(:,-3),G2tensor(:,45))
  call loop_QV_A(G1(:,:,:,98),wf(:,55),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,59),MB,G2(:,:,:,118))
  call check_last_QA_V(l_switch,G2(:,:,:,118),wf(:,-2),G2tensor(:,46))
  call loop_QA_V(G1(:,:,:,98),wf(:,-3),G1(:,:,:,101))
  call loop_VA_Q(G1(:,:,:,101),wf(:,-2),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,61),MB,G2(:,:,:,119))
  call check_last_AQ_V(l_switch,G2(:,:,:,119),wf(:,-1),G2tensor(:,47))
  call loop_QA_V(G1(:,:,:,98),wf(:,-2),G1(:,:,:,103))
  call loop_VA_Q(G1(:,:,:,103),wf(:,-3),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,61),MB,G2(:,:,:,120))
  call check_last_AQ_V(l_switch,G2(:,:,:,120),wf(:,-1),G2tensor(:,48))
  call check_last_QA_V(l_switch,G1(:,:,:,98),wf(:,31),G1tensor(:,11))
  call check_last_QA_V(l_switch,G1(:,:,:,98),wf(:,60),G1tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,265),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,39),MB,G1(:,:,:,105))
  call loop_QS_A(G1(:,:,:,105),wf(:,-4),G1(:,:,:,106),gH)
  call loop_Q_A(G1(:,:,:,106),Q(:,55),MB,G2(:,:,:,121))
  call check_last_QA_V(l_switch,G2(:,:,:,121),wf(:,-3),G2tensor(:,49))
  call check_last_QA_V(l_switch,G1(:,:,:,105),wf(:,15),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,250),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,46),MB,G1(:,:,:,107))
  call loop_AS_Q(G1(:,:,:,107),wf(:,-4),G1(:,:,:,108),gH)
  call loop_A_Q(G1(:,:,:,108),Q(:,62),MB,G2(:,:,:,122))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,0),G2tensor(:,50))
  call check_last_AQ_V(l_switch,G1(:,:,:,107),wf(:,25),G1tensor(:,14))
  call loop_VQ_A(G0(:,:,:,1),wf(:,344),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,23),MB,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,-5),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,55),MB,G2(:,:,:,123))
  call check_last_QA_V(l_switch,G2(:,:,:,123),wf(:,-3),G2tensor(:,51))
  call loop_VQ_A(G0(:,:,:,1),wf(:,346),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,39),MB,G1(:,:,:,111))
  call loop_QS_A(G1(:,:,:,111),wf(:,-4),G1(:,:,:,112),gH)
  call loop_Q_A(G1(:,:,:,112),Q(:,55),MB,G2(:,:,:,124))
  call check_last_QA_V(l_switch,G2(:,:,:,124),wf(:,-3),G2tensor(:,52))
  call check_last_QA_V(l_switch,G1(:,:,:,111),wf(:,15),G1tensor(:,15))
  call loop_VQ_A(G0(:,:,:,1),wf(:,349),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,39),MB,G1(:,:,:,113))
  call loop_QS_A(G1(:,:,:,113),wf(:,-4),G1(:,:,:,114),gH)
  call loop_Q_A(G1(:,:,:,114),Q(:,55),MB,G2(:,:,:,125))
  call check_last_QA_V(l_switch,G2(:,:,:,125),wf(:,-3),G2tensor(:,53))
  call check_last_QA_V(l_switch,G1(:,:,:,113),wf(:,15),G1tensor(:,16))
  call loop_VA_Q(G0(:,:,:,1),wf(:,351),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,30),MB,G1(:,:,:,115))
  call loop_AV_Q(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,62),MB,G2(:,:,:,126))
  call check_last_AQ_V(l_switch,G2(:,:,:,126),wf(:,0),G2tensor(:,54))
  call loop_VA_Q(G0(:,:,:,1),wf(:,353),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,46),MB,G1(:,:,:,117))
  call loop_AS_Q(G1(:,:,:,117),wf(:,-4),G1(:,:,:,118),gH)
  call loop_A_Q(G1(:,:,:,118),Q(:,62),MB,G2(:,:,:,127))
  call check_last_AQ_V(l_switch,G2(:,:,:,127),wf(:,0),G2tensor(:,55))
  call check_last_AQ_V(l_switch,G1(:,:,:,117),wf(:,25),G1tensor(:,17))
  call loop_VA_Q(G0(:,:,:,1),wf(:,31),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,14),MB,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,46),MB,G2(:,:,:,128))
  call loop_AS_Q(G2(:,:,:,128),wf(:,-4),G2(:,:,:,129),gH)
  call loop_A_Q(G2(:,:,:,129),Q(:,62),MB,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,0),G3tensor(:,46))
  call loop_AS_Q(G1(:,:,:,119),wf(:,-4),G1(:,:,:,121),gH)
  call loop_A_Q(G1(:,:,:,121),Q(:,30),MB,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-5),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,62),MB,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,0),G3tensor(:,47))
  call loop_VA_Q(G0(:,:,:,1),wf(:,355),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,46),MB,G1(:,:,:,122))
  call loop_AS_Q(G1(:,:,:,122),wf(:,-4),G1(:,:,:,123),gH)
  call loop_A_Q(G1(:,:,:,123),Q(:,62),MB,G2(:,:,:,132))
  call check_last_AQ_V(l_switch,G2(:,:,:,132),wf(:,0),G2tensor(:,56))
  call check_last_AQ_V(l_switch,G1(:,:,:,122),wf(:,25),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,36),MB,G1(:,:,:,124))
  call loop_AV_Q(G1(:,:,:,124),wf(:,39),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,45),MB,G2(:,:,:,133))
  call check_last_AQ_V(l_switch,G2(:,:,:,133),wf(:,4),G2tensor(:,57))
  call loop_AS_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134),gH)
  call loop_A_Q(G2(:,:,:,134),Q(:,61),MB,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-1),G3tensor(:,48))
  call loop_AS_Q(G1(:,:,:,124),wf(:,-4),G1(:,:,:,126),gH)
  call loop_A_Q(G1(:,:,:,126),Q(:,52),MB,G2(:,:,:,135))
  call check_last_AQ_V(l_switch,G2(:,:,:,135),wf(:,52),G2tensor(:,58))
  call loop_AV_Q(G2(:,:,:,135),wf(:,39),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,61),MB,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,-1),G3tensor(:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,135),wf(:,63),G2tensor(:,59))
  call loop_AV_Q(G2(:,:,:,135),wf(:,55),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,62),MB,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,0),G3tensor(:,50))
  call loop_AQ_V(G2(:,:,:,135),wf(:,-1),G2(:,:,:,138))
  call loop_VA_Q(G2(:,:,:,138),wf(:,-3),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,62),MB,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,0),G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,124),wf(:,55),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,46),MB,G2(:,:,:,140))
  call check_last_AQ_V(l_switch,G2(:,:,:,140),wf(:,25),G2tensor(:,60))
  call loop_AS_Q(G2(:,:,:,140),wf(:,-4),G2(:,:,:,141),gH)
  call loop_A_Q(G2(:,:,:,141),Q(:,62),MB,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,0),G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,124),wf(:,27),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,61),MB,G2(:,:,:,142))
  call check_last_AQ_V(l_switch,G2(:,:,:,142),wf(:,-1),G2tensor(:,61))
  call loop_AQ_V(G1(:,:,:,124),wf(:,25),G1(:,:,:,129))
  call loop_VA_Q(G1(:,:,:,129),wf(:,-3),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,61),MB,G2(:,:,:,143))
  call check_last_AQ_V(l_switch,G2(:,:,:,143),wf(:,-1),G2tensor(:,62))
  call loop_AV_Q(G1(:,:,:,124),wf(:,10),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),MB,G2(:,:,:,144))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,0),G2tensor(:,63))
  call loop_AQ_V(G1(:,:,:,124),wf(:,4),G1(:,:,:,132))
  call loop_VA_Q(G1(:,:,:,132),wf(:,-3),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,62),MB,G2(:,:,:,145))
  call check_last_AQ_V(l_switch,G2(:,:,:,145),wf(:,0),G2tensor(:,64))
  call loop_AV_Q(G1(:,:,:,124),wf(:,37),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,61),MB,G2(:,:,:,146))
  call check_last_AQ_V(l_switch,G2(:,:,:,146),wf(:,-1),G2tensor(:,65))
  call loop_AV_Q(G1(:,:,:,124),wf(:,20),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,62),MB,G2(:,:,:,147))
  call check_last_AQ_V(l_switch,G2(:,:,:,147),wf(:,0),G2tensor(:,66))
  call loop_AQ_V(G1(:,:,:,124),wf(:,-1),G1(:,:,:,136))
  call loop_VA_Q(G1(:,:,:,136),wf(:,15),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,62),MB,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,0),G2tensor(:,67))
  call loop_VA_Q(G1(:,:,:,136),wf(:,-3),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,46),MB,G2(:,:,:,149))
  call loop_AS_Q(G2(:,:,:,149),wf(:,-4),G2(:,:,:,150),gH)
  call loop_A_Q(G2(:,:,:,150),Q(:,62),MB,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,53))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,277),G1tensor(:,19))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,358),G1tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,300),G1tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,372),G1tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,390),G1tensor(:,23))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,399),G1tensor(:,24))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,421),G1tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,124),wf(:,423),G1tensor(:,26))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,41),G1(:,:,:,139))
  call loop_VQ_A(G1(:,:,:,139),wf(:,4),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,59),MB,G2(:,:,:,151))
  call check_last_QA_V(l_switch,G2(:,:,:,151),wf(:,-2),G2tensor(:,68))
  call loop_VA_Q(G1(:,:,:,139),wf(:,48),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,61),MB,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,-1),G2tensor(:,69))
  call loop_VA_Q(G1(:,:,:,139),wf(:,-2),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,45),MB,G2(:,:,:,153))
  call loop_AS_Q(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154),gH)
  call loop_A_Q(G2(:,:,:,154),Q(:,61),MB,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,-1),G3tensor(:,54))
  call check_last_UV_W(l_switch,G1(:,:,:,139),Q(:,41),wf(:,45),Q(:,22),G2tensor(:,70))
  call check_last_UV_W(l_switch,G1(:,:,:,139),Q(:,41),wf(:,53),Q(:,22),G2tensor(:,71))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,22),ZERO,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,54),ZERO,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,39),G2(:,:,:,156))
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),ZERO,G3tensor(:,55))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,22),MT,G1(:,:,:,145))
  call loop_AV_Q(G1(:,:,:,145),wf(:,-5),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,54),MT,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,39),G2(:,:,:,158))
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,22),ZERO,G1(:,:,:,147))
  call loop_QV_A(G1(:,:,:,147),wf(:,-5),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,54),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,39),G2(:,:,:,160))
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),ZERO,G3tensor(:,57))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,22),MT,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,-5),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,54),MT,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,39),G2(:,:,:,162))
  call check_last_Q_A(l_switch,G2(:,:,:,162),Q(:,63),MT,G3tensor(:,58))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,22),MB,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,54),MB,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,39),G2(:,:,:,164))
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,59))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,22),MB,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,54),MB,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,39),G2(:,:,:,166))
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),MB,G3tensor(:,60))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,45),G1(:,:,:,155))
  call loop_DV_C(G1(:,:,:,155),Q(:,22),wf(:,-5),G2(:,:,:,167))
  call check_last_DV_C(l_switch,G2(:,:,:,167),Q(:,54),wf(:,39),G3tensor(:,61))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,22),G1(:,:,:,156))
  call loop_CV_D(G1(:,:,:,156),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,168))
  call check_last_CV_D(l_switch,G2(:,:,:,168),Q(:,54),wf(:,39),Q(:,9),G3tensor(:,62))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,22),G1(:,:,:,157))
  call loop_UV_W(G1(:,:,:,157),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,169))
  call check_last_UV_W(l_switch,G2(:,:,:,169),Q(:,54),wf(:,39),Q(:,9),G3tensor(:,63))
  call loop_VA_Q(G2(:,:,:,169),wf(:,-3),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,62),MB,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,64))
  call loop_VQ_A(G1(:,:,:,157),wf(:,33),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,55),MB,G2(:,:,:,171))
  call check_last_QA_V(l_switch,G2(:,:,:,171),wf(:,-3),G2tensor(:,72))
  call loop_VA_Q(G1(:,:,:,157),wf(:,5),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,62),MB,G2(:,:,:,172))
  call check_last_AQ_V(l_switch,G2(:,:,:,172),wf(:,0),G2tensor(:,73))
  call loop_VA_Q(G1(:,:,:,157),wf(:,-3),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,30),MB,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,62),MB,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,65))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,39),Q(:,9),G1(:,:,:,161))
  call loop_VQ_A(G1(:,:,:,161),wf(:,89),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,59),MB,G2(:,:,:,175))
  call check_last_QA_V(l_switch,G2(:,:,:,175),wf(:,-2),G2tensor(:,74))
  call loop_VQ_A(G1(:,:,:,161),wf(:,4),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,27),MB,G2(:,:,:,176))
  call loop_QV_A(G2(:,:,:,176),wf(:,-5),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,59),MB,G3(:,:,:,44))
  call check_last_QA_V(l_switch,G3(:,:,:,44),wf(:,-2),G3tensor(:,66))
  call loop_UV_W(G1(:,:,:,161),Q(:,9),wf(:,-5),Q(:,32),G2(:,:,:,178))
  call loop_VQ_A(G2(:,:,:,178),wf(:,4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,59),MB,G3(:,:,:,45))
  call check_last_QA_V(l_switch,G3(:,:,:,45),wf(:,-2),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,178),wf(:,48),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,61),MB,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,-1),G3tensor(:,68))
  call loop_VA_Q(G2(:,:,:,178),wf(:,-2),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,45),MB,G3(:,:,:,47))
  call loop_AS_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48),gH)
  call loop_A_Q(G3(:,:,:,48),Q(:,61),MB,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,-1),G4tensor(:,4))
  call loop_VA_Q(G1(:,:,:,161),wf(:,157),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,61),MB,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,-1),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,161),wf(:,48),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,29),MB,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,61),MB,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,-1),G3tensor(:,69))
  call loop_VQ_A(G1(:,:,:,161),wf(:,92),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,59),MB,G2(:,:,:,185))
  call check_last_QA_V(l_switch,G2(:,:,:,185),wf(:,-2),G2tensor(:,76))
  call loop_VQ_A(G1(:,:,:,161),wf(:,14),G1(:,:,:,167))
  call loop_Q_A(G1(:,:,:,167),Q(:,43),MB,G2(:,:,:,186))
  call loop_QS_A(G2(:,:,:,186),wf(:,-4),G2(:,:,:,187),gH)
  call loop_Q_A(G2(:,:,:,187),Q(:,59),MB,G3(:,:,:,50))
  call check_last_QA_V(l_switch,G3(:,:,:,50),wf(:,-2),G3tensor(:,70))
  call loop_VA_Q(G1(:,:,:,161),wf(:,159),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,61),MB,G2(:,:,:,188))
  call check_last_AQ_V(l_switch,G2(:,:,:,188),wf(:,-1),G2tensor(:,77))
  call loop_VA_Q(G1(:,:,:,161),wf(:,41),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,45),MB,G2(:,:,:,189))
  call loop_AS_Q(G2(:,:,:,189),wf(:,-4),G2(:,:,:,190),gH)
  call loop_A_Q(G2(:,:,:,190),Q(:,61),MB,G3(:,:,:,51))
  call check_last_AQ_V(l_switch,G3(:,:,:,51),wf(:,-1),G3tensor(:,71))
  call loop_VA_Q(G1(:,:,:,161),wf(:,-2),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,13),MB,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-5),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,45),MB,G3(:,:,:,52))
  call loop_AS_Q(G3(:,:,:,52),wf(:,-4),G3(:,:,:,53),gH)
  call loop_A_Q(G3(:,:,:,53),Q(:,61),MB,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,-1),G4tensor(:,5))
  call loop_AS_Q(G2(:,:,:,191),wf(:,-4),G2(:,:,:,193),gH)
  call loop_A_Q(G2(:,:,:,193),Q(:,29),MB,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-5),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,61),MB,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-1),G4tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,277),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,27),MB,G1(:,:,:,171))
  call loop_QV_A(G1(:,:,:,171),wf(:,-5),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,59),MB,G2(:,:,:,194))
  call check_last_QA_V(l_switch,G2(:,:,:,194),wf(:,-2),G2tensor(:,78))
  call loop_VA_Q(G0(:,:,:,1),wf(:,48),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,20),MB,G1(:,:,:,173))
  call loop_AQ_V(G1(:,:,:,173),wf(:,14),G1(:,:,:,174))
  call check_last_UV_W(l_switch,G1(:,:,:,174),Q(:,54),wf(:,39),Q(:,9),G2tensor(:,79))
  call loop_VA_Q(G1(:,:,:,174),wf(:,-3),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,62),MB,G2(:,:,:,195))
  call check_last_AQ_V(l_switch,G2(:,:,:,195),wf(:,0),G2tensor(:,80))
  call loop_AV_Q(G1(:,:,:,173),wf(:,-5),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,52),MB,G2(:,:,:,196))
  call check_last_AQ_V(l_switch,G2(:,:,:,196),wf(:,52),G2tensor(:,81))
  call loop_AV_Q(G2(:,:,:,196),wf(:,39),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,61),MB,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,-1),G3tensor(:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,196),wf(:,63),G2tensor(:,82))
  call loop_AV_Q(G2(:,:,:,196),wf(:,55),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,62),MB,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,73))
  call loop_AQ_V(G2(:,:,:,196),wf(:,-1),G2(:,:,:,199))
  call loop_VA_Q(G2(:,:,:,199),wf(:,-3),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,62),MB,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,0),G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,173),wf(:,46),G1(:,:,:,177))
  call loop_A_Q(G1(:,:,:,177),Q(:,61),MB,G2(:,:,:,201))
  call check_last_AQ_V(l_switch,G2(:,:,:,201),wf(:,-1),G2tensor(:,83))
  call loop_AV_Q(G1(:,:,:,173),wf(:,39),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,29),MB,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-5),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,61),MB,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,-1),G3tensor(:,75))
  call loop_AQ_V(G1(:,:,:,173),wf(:,33),G1(:,:,:,179))
  call check_last_UV_W(l_switch,G1(:,:,:,179),Q(:,53),wf(:,55),Q(:,10),G2tensor(:,84))
  call loop_VA_Q(G1(:,:,:,179),wf(:,-3),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,61),MB,G2(:,:,:,204))
  call check_last_AQ_V(l_switch,G2(:,:,:,204),wf(:,-1),G2tensor(:,85))
  call loop_AV_Q(G1(:,:,:,173),wf(:,58),G1(:,:,:,181))
  call loop_A_Q(G1(:,:,:,181),Q(:,62),MB,G2(:,:,:,205))
  call check_last_AQ_V(l_switch,G2(:,:,:,205),wf(:,0),G2tensor(:,86))
  call loop_AV_Q(G1(:,:,:,173),wf(:,55),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,30),MB,G2(:,:,:,206))
  call loop_AV_Q(G2(:,:,:,206),wf(:,-5),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,62),MB,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,0),G3tensor(:,76))
  call loop_AV_Q(G1(:,:,:,173),wf(:,70),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,61),MB,G2(:,:,:,208))
  call check_last_AQ_V(l_switch,G2(:,:,:,208),wf(:,-1),G2tensor(:,87))
  call loop_AV_Q(G1(:,:,:,173),wf(:,65),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,62),MB,G2(:,:,:,209))
  call check_last_AQ_V(l_switch,G2(:,:,:,209),wf(:,0),G2tensor(:,88))
  call loop_AV_Q(G1(:,:,:,173),wf(:,72),G1(:,:,:,185))
  call loop_A_Q(G1(:,:,:,185),Q(:,61),MB,G2(:,:,:,210))
  call check_last_AQ_V(l_switch,G2(:,:,:,210),wf(:,-1),G2tensor(:,89))
  call loop_AV_Q(G1(:,:,:,173),wf(:,68),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,62),MB,G2(:,:,:,211))
  call check_last_AQ_V(l_switch,G2(:,:,:,211),wf(:,0),G2tensor(:,90))
  call loop_AQ_V(G1(:,:,:,173),wf(:,-1),G1(:,:,:,187))
  call loop_VA_Q(G1(:,:,:,187),wf(:,5),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,62),MB,G2(:,:,:,212))
  call check_last_AQ_V(l_switch,G2(:,:,:,212),wf(:,0),G2tensor(:,91))
  call loop_UV_W(G1(:,:,:,187),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,213))
  call loop_VA_Q(G2(:,:,:,213),wf(:,-3),G2(:,:,:,214))
  call loop_A_Q(G2(:,:,:,214),Q(:,62),MB,G3(:,:,:,61))
  call check_last_AQ_V(l_switch,G3(:,:,:,61),wf(:,0),G3tensor(:,77))
  call loop_VA_Q(G1(:,:,:,187),wf(:,-3),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,30),MB,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-5),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,62),MB,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,0),G3tensor(:,78))
  call loop_AV_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,22),ZERO,G1(:,:,:,190))
  call loop_AV_Q(G1(:,:,:,190),wf(:,-5),G1(:,:,:,191))
  call loop_A_Q(G1(:,:,:,191),Q(:,54),ZERO,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,39),G2(:,:,:,218))
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,63),ZERO,G3tensor(:,79))
  call loop_AV_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,22),MT,G1(:,:,:,192))
  call loop_AV_Q(G1(:,:,:,192),wf(:,-5),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,54),MT,G2(:,:,:,219))
  call loop_AV_Q(G2(:,:,:,219),wf(:,39),G2(:,:,:,220))
  call check_last_A_Q(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,22),ZERO,G1(:,:,:,194))
  call loop_QV_A(G1(:,:,:,194),wf(:,-5),G1(:,:,:,195))
  call loop_Q_A(G1(:,:,:,195),Q(:,54),ZERO,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,39),G2(:,:,:,222))
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,63),ZERO,G3tensor(:,81))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,22),MT,G1(:,:,:,196))
  call loop_QV_A(G1(:,:,:,196),wf(:,-5),G1(:,:,:,197))
  call loop_Q_A(G1(:,:,:,197),Q(:,54),MT,G2(:,:,:,223))
  call loop_QV_A(G2(:,:,:,223),wf(:,39),G2(:,:,:,224))
  call check_last_Q_A(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,22),MB,G1(:,:,:,198))
  call loop_AV_Q(G1(:,:,:,198),wf(:,-5),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,54),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,39),G2(:,:,:,226))
  call check_last_A_Q(l_switch,G2(:,:,:,226),Q(:,63),MB,G3tensor(:,83))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,22),MB,G1(:,:,:,200))
  call loop_QV_A(G1(:,:,:,200),wf(:,-5),G1(:,:,:,201))
  call loop_Q_A(G1(:,:,:,201),Q(:,54),MB,G2(:,:,:,227))
  call loop_QV_A(G2(:,:,:,227),wf(:,39),G2(:,:,:,228))
  call check_last_Q_A(l_switch,G2(:,:,:,228),Q(:,63),MB,G3tensor(:,84))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,53),G1(:,:,:,202))
  call loop_DV_C(G1(:,:,:,202),Q(:,22),wf(:,-5),G2(:,:,:,229))
  call check_last_DV_C(l_switch,G2(:,:,:,229),Q(:,54),wf(:,39),G3tensor(:,85))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,53),Q(:,22),G1(:,:,:,203))
  call loop_CV_D(G1(:,:,:,203),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,230))
  call check_last_CV_D(l_switch,G2(:,:,:,230),Q(:,54),wf(:,39),Q(:,9),G3tensor(:,86))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,53),Q(:,22),G1(:,:,:,204))
  call loop_UV_W(G1(:,:,:,204),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,231))
  call check_last_UV_W(l_switch,G2(:,:,:,231),Q(:,54),wf(:,39),Q(:,9),G3tensor(:,87))
  call loop_VA_Q(G2(:,:,:,231),wf(:,-3),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,62),MB,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,0),G3tensor(:,88))
  call loop_VQ_A(G1(:,:,:,204),wf(:,33),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,55),MB,G2(:,:,:,233))
  call check_last_QA_V(l_switch,G2(:,:,:,233),wf(:,-3),G2tensor(:,92))
  call loop_VA_Q(G1(:,:,:,204),wf(:,5),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,62),MB,G2(:,:,:,234))
  call check_last_AQ_V(l_switch,G2(:,:,:,234),wf(:,0),G2tensor(:,93))
  call loop_VA_Q(G1(:,:,:,204),wf(:,-3),G1(:,:,:,207))
  call loop_A_Q(G1(:,:,:,207),Q(:,30),MB,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-5),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,62),MB,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,0),G3tensor(:,89))
  call loop_VA_Q(G0(:,:,:,1),wf(:,157),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,52),MB,G1(:,:,:,208))
  call loop_AV_Q(G1(:,:,:,208),wf(:,39),G1(:,:,:,209))
  call loop_A_Q(G1(:,:,:,209),Q(:,61),MB,G2(:,:,:,237))
  call check_last_AQ_V(l_switch,G2(:,:,:,237),wf(:,-1),G2tensor(:,94))
  call loop_AV_Q(G1(:,:,:,208),wf(:,55),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,62),MB,G2(:,:,:,238))
  call check_last_AQ_V(l_switch,G2(:,:,:,238),wf(:,0),G2tensor(:,95))
  call loop_AQ_V(G1(:,:,:,208),wf(:,-1),G1(:,:,:,211))
  call loop_VA_Q(G1(:,:,:,211),wf(:,-3),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,62),MB,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,0),G2tensor(:,96))
  call check_last_AQ_V(l_switch,G1(:,:,:,208),wf(:,52),G1tensor(:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,208),wf(:,63),G1tensor(:,28))
  call loop_VA_Q(G0(:,:,:,1),wf(:,285),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,29),MB,G1(:,:,:,213))
  call loop_AV_Q(G1(:,:,:,213),wf(:,-5),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,61),MB,G2(:,:,:,240))
  call check_last_AQ_V(l_switch,G2(:,:,:,240),wf(:,-1),G2tensor(:,97))
  call loop_VQ_A(G0(:,:,:,1),wf(:,287),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,43),MB,G1(:,:,:,215))
  call loop_QS_A(G1(:,:,:,215),wf(:,-4),G1(:,:,:,216),gH)
  call loop_Q_A(G1(:,:,:,216),Q(:,59),MB,G2(:,:,:,241))
  call check_last_QA_V(l_switch,G2(:,:,:,241),wf(:,-2),G2tensor(:,98))
  call check_last_QA_V(l_switch,G1(:,:,:,215),wf(:,48),G1tensor(:,29))
  call loop_VA_Q(G0(:,:,:,1),wf(:,159),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,52),MB,G1(:,:,:,217))
  call loop_AV_Q(G1(:,:,:,217),wf(:,39),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,61),MB,G2(:,:,:,242))
  call check_last_AQ_V(l_switch,G2(:,:,:,242),wf(:,-1),G2tensor(:,99))
  call loop_AV_Q(G1(:,:,:,217),wf(:,55),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,62),MB,G2(:,:,:,243))
  call check_last_AQ_V(l_switch,G2(:,:,:,243),wf(:,0),G2tensor(:,100))
  call loop_AQ_V(G1(:,:,:,217),wf(:,-1),G1(:,:,:,220))
  call loop_VA_Q(G1(:,:,:,220),wf(:,-3),G1(:,:,:,221))
  call loop_A_Q(G1(:,:,:,221),Q(:,62),MB,G2(:,:,:,244))
  call check_last_AQ_V(l_switch,G2(:,:,:,244),wf(:,0),G2tensor(:,101))
  call check_last_AQ_V(l_switch,G1(:,:,:,217),wf(:,52),G1tensor(:,30))
  call check_last_AQ_V(l_switch,G1(:,:,:,217),wf(:,63),G1tensor(:,31))
  call loop_VA_Q(G0(:,:,:,1),wf(:,275),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,45),MB,G1(:,:,:,222))
  call loop_AS_Q(G1(:,:,:,222),wf(:,-4),G1(:,:,:,223),gH)
  call loop_A_Q(G1(:,:,:,223),Q(:,61),MB,G2(:,:,:,245))
  call check_last_AQ_V(l_switch,G2(:,:,:,245),wf(:,-1),G2tensor(:,102))
  call check_last_AQ_V(l_switch,G1(:,:,:,222),wf(:,4),G1tensor(:,32))
  call loop_VQ_A(G0(:,:,:,1),wf(:,358),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,27),MB,G1(:,:,:,224))
  call loop_QV_A(G1(:,:,:,224),wf(:,-5),G1(:,:,:,225))
  call loop_Q_A(G1(:,:,:,225),Q(:,59),MB,G2(:,:,:,246))
  call check_last_QA_V(l_switch,G2(:,:,:,246),wf(:,-2),G2tensor(:,103))
  call loop_VQ_A(G0(:,:,:,1),wf(:,360),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,43),MB,G1(:,:,:,226))
  call loop_QS_A(G1(:,:,:,226),wf(:,-4),G1(:,:,:,227),gH)
  call loop_Q_A(G1(:,:,:,227),Q(:,59),MB,G2(:,:,:,247))
  call check_last_QA_V(l_switch,G2(:,:,:,247),wf(:,-2),G2tensor(:,104))
  call check_last_QA_V(l_switch,G1(:,:,:,226),wf(:,48),G1tensor(:,33))
  call loop_VQ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,11),MB,G1(:,:,:,228))
  call loop_QV_A(G1(:,:,:,228),wf(:,-5),G1(:,:,:,229))
  call loop_Q_A(G1(:,:,:,229),Q(:,43),MB,G2(:,:,:,248))
  call loop_QS_A(G2(:,:,:,248),wf(:,-4),G2(:,:,:,249),gH)
  call loop_Q_A(G2(:,:,:,249),Q(:,59),MB,G3(:,:,:,65))
  call check_last_QA_V(l_switch,G3(:,:,:,65),wf(:,-2),G3tensor(:,90))
  call loop_QS_A(G1(:,:,:,228),wf(:,-4),G1(:,:,:,230),gH)
  call loop_Q_A(G1(:,:,:,230),Q(:,27),MB,G2(:,:,:,250))
  call loop_QV_A(G2(:,:,:,250),wf(:,-5),G2(:,:,:,251))
  call loop_Q_A(G2(:,:,:,251),Q(:,59),MB,G3(:,:,:,66))
  call check_last_QA_V(l_switch,G3(:,:,:,66),wf(:,-2),G3tensor(:,91))
  call loop_VA_Q(G0(:,:,:,1),wf(:,363),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,29),MB,G1(:,:,:,231))
  call loop_AV_Q(G1(:,:,:,231),wf(:,-5),G1(:,:,:,232))
  call loop_A_Q(G1(:,:,:,232),Q(:,61),MB,G2(:,:,:,252))
  call check_last_AQ_V(l_switch,G2(:,:,:,252),wf(:,-1),G2tensor(:,105))
  call loop_VA_Q(G0(:,:,:,1),wf(:,365),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,45),MB,G1(:,:,:,233))
  call loop_AS_Q(G1(:,:,:,233),wf(:,-4),G1(:,:,:,234),gH)
  call loop_A_Q(G1(:,:,:,234),Q(:,61),MB,G2(:,:,:,253))
  call check_last_AQ_V(l_switch,G2(:,:,:,253),wf(:,-1),G2tensor(:,106))
  call check_last_AQ_V(l_switch,G1(:,:,:,233),wf(:,4),G1tensor(:,34))
  call loop_VA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,13),MB,G1(:,:,:,235))
  call loop_AV_Q(G1(:,:,:,235),wf(:,-5),G1(:,:,:,236))
  call loop_A_Q(G1(:,:,:,236),Q(:,45),MB,G2(:,:,:,254))
  call loop_AS_Q(G2(:,:,:,254),wf(:,-4),G2(:,:,:,255),gH)
  call loop_A_Q(G2(:,:,:,255),Q(:,61),MB,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,-1),G3tensor(:,92))
  call loop_AS_Q(G1(:,:,:,235),wf(:,-4),G1(:,:,:,237),gH)
  call loop_A_Q(G1(:,:,:,237),Q(:,29),MB,G2(:,:,:,256))
  call loop_AV_Q(G2(:,:,:,256),wf(:,-5),G2(:,:,:,257))
  call loop_A_Q(G2(:,:,:,257),Q(:,61),MB,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,-1),G3tensor(:,93))
  call loop_VQ_A(G0(:,:,:,1),wf(:,367),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,43),MB,G1(:,:,:,238))
  call loop_QS_A(G1(:,:,:,238),wf(:,-4),G1(:,:,:,239),gH)
  call loop_Q_A(G1(:,:,:,239),Q(:,59),MB,G2(:,:,:,258))
  call check_last_QA_V(l_switch,G2(:,:,:,258),wf(:,-2),G2tensor(:,107))
  call check_last_QA_V(l_switch,G1(:,:,:,238),wf(:,48),G1tensor(:,35))
  call loop_VA_Q(G0(:,:,:,1),wf(:,369),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,45),MB,G1(:,:,:,240))
  call loop_AS_Q(G1(:,:,:,240),wf(:,-4),G1(:,:,:,241),gH)
  call loop_A_Q(G1(:,:,:,241),Q(:,61),MB,G2(:,:,:,259))
  call check_last_AQ_V(l_switch,G2(:,:,:,259),wf(:,-1),G2tensor(:,108))
  call check_last_AQ_V(l_switch,G1(:,:,:,240),wf(:,4),G1tensor(:,36))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,4),MB,G1(:,:,:,242))
  call loop_AV_Q(G1(:,:,:,242),wf(:,46),G1(:,:,:,243))
  call loop_A_Q(G1(:,:,:,243),Q(:,45),MB,G2(:,:,:,260))
  call loop_AS_Q(G2(:,:,:,260),wf(:,-4),G2(:,:,:,261),gH)
  call loop_A_Q(G2(:,:,:,261),Q(:,61),MB,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,-1),G3tensor(:,94))
  call loop_AS_Q(G1(:,:,:,242),wf(:,-4),G1(:,:,:,244),gH)
  call loop_A_Q(G1(:,:,:,244),Q(:,20),MB,G2(:,:,:,262))
  call loop_AV_Q(G2(:,:,:,262),wf(:,46),G2(:,:,:,263))
  call loop_A_Q(G2(:,:,:,263),Q(:,61),MB,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,-1),G3tensor(:,95))
  call loop_AV_Q(G2(:,:,:,262),wf(:,39),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,29),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,61),MB,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-1),G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,262),wf(:,-5),G2(:,:,:,265))
  call loop_A_Q(G2(:,:,:,265),Q(:,52),MB,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,39),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,61),MB,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-1),G4tensor(:,8))
  call loop_AV_Q(G3(:,:,:,73),wf(:,55),G3(:,:,:,75))
  call loop_A_Q(G3(:,:,:,75),Q(:,62),MB,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,9))
  call loop_AQ_V(G3(:,:,:,73),wf(:,-1),G3(:,:,:,76))
  call loop_VA_Q(G3(:,:,:,76),wf(:,-3),G3(:,:,:,77))
  call loop_A_Q(G3(:,:,:,77),Q(:,62),MB,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,262),wf(:,58),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,62),MB,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,0),G3tensor(:,96))
  call loop_AV_Q(G2(:,:,:,262),wf(:,55),G2(:,:,:,267))
  call loop_A_Q(G2(:,:,:,267),Q(:,30),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,62),MB,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,262),wf(:,70),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,61),MB,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,-1),G3tensor(:,97))
  call loop_AQ_V(G2(:,:,:,262),wf(:,33),G2(:,:,:,269))
  call loop_VA_Q(G2(:,:,:,269),wf(:,-3),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,61),MB,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,-1),G3tensor(:,98))
  call loop_AV_Q(G2(:,:,:,262),wf(:,65),G2(:,:,:,271))
  call loop_A_Q(G2(:,:,:,271),Q(:,62),MB,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,0),G3tensor(:,99))
  call loop_AQ_V(G2(:,:,:,262),wf(:,14),G2(:,:,:,272))
  call loop_VA_Q(G2(:,:,:,272),wf(:,-3),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,62),MB,G3(:,:,:,84))
  call check_last_AQ_V(l_switch,G3(:,:,:,84),wf(:,0),G3tensor(:,100))
  call loop_AV_Q(G2(:,:,:,262),wf(:,72),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,61),MB,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,-1),G3tensor(:,101))
  call loop_AV_Q(G2(:,:,:,262),wf(:,68),G2(:,:,:,275))
  call loop_A_Q(G2(:,:,:,275),Q(:,62),MB,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,0),G3tensor(:,102))
  call loop_AQ_V(G2(:,:,:,262),wf(:,-1),G2(:,:,:,276))
  call loop_VA_Q(G2(:,:,:,276),wf(:,5),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,62),MB,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,0),G3tensor(:,103))
  call loop_UV_W(G2(:,:,:,276),Q(:,22),wf(:,-5),Q(:,32),G3(:,:,:,88))
  call loop_VA_Q(G3(:,:,:,88),wf(:,-3),G3(:,:,:,89))
  call loop_A_Q(G3(:,:,:,89),Q(:,62),MB,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,12))
  call loop_VA_Q(G2(:,:,:,276),wf(:,-3),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,30),MB,G3(:,:,:,90))
  call loop_AV_Q(G3(:,:,:,90),wf(:,-5),G3(:,:,:,91))
  call loop_A_Q(G3(:,:,:,91),Q(:,62),MB,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,242),wf(:,-5),G1(:,:,:,245))
  call loop_A_Q(G1(:,:,:,245),Q(:,36),MB,G2(:,:,:,279))
  call loop_AV_Q(G2(:,:,:,279),wf(:,39),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,45),MB,G3(:,:,:,92))
  call loop_AS_Q(G3(:,:,:,92),wf(:,-4),G3(:,:,:,93),gH)
  call loop_A_Q(G3(:,:,:,93),Q(:,61),MB,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,-1),G4tensor(:,14))
  call loop_AS_Q(G2(:,:,:,279),wf(:,-4),G2(:,:,:,281),gH)
  call loop_A_Q(G2(:,:,:,281),Q(:,52),MB,G3(:,:,:,94))
  call loop_AV_Q(G3(:,:,:,94),wf(:,39),G3(:,:,:,95))
  call loop_A_Q(G3(:,:,:,95),Q(:,61),MB,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,-1),G4tensor(:,15))
  call loop_AV_Q(G3(:,:,:,94),wf(:,55),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,62),MB,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,16))
  call loop_AQ_V(G3(:,:,:,94),wf(:,-1),G3(:,:,:,97))
  call loop_VA_Q(G3(:,:,:,97),wf(:,-3),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,62),MB,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,17))
  call loop_AV_Q(G2(:,:,:,279),wf(:,55),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,46),MB,G3(:,:,:,99))
  call loop_AS_Q(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100),gH)
  call loop_A_Q(G3(:,:,:,100),Q(:,62),MB,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,0),G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,279),wf(:,27),G2(:,:,:,283))
  call loop_A_Q(G2(:,:,:,283),Q(:,61),MB,G3(:,:,:,101))
  call check_last_AQ_V(l_switch,G3(:,:,:,101),wf(:,-1),G3tensor(:,104))
  call loop_AQ_V(G2(:,:,:,279),wf(:,25),G2(:,:,:,284))
  call loop_VA_Q(G2(:,:,:,284),wf(:,-3),G2(:,:,:,285))
  call loop_A_Q(G2(:,:,:,285),Q(:,61),MB,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,-1),G3tensor(:,105))
  call loop_AV_Q(G2(:,:,:,279),wf(:,10),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,62),MB,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,106))
  call loop_AQ_V(G2(:,:,:,279),wf(:,4),G2(:,:,:,287))
  call loop_VA_Q(G2(:,:,:,287),wf(:,-3),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,62),MB,G3(:,:,:,104))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,0),G3tensor(:,107))
  call loop_AV_Q(G2(:,:,:,279),wf(:,37),G2(:,:,:,289))
  call loop_A_Q(G2(:,:,:,289),Q(:,61),MB,G3(:,:,:,105))
  call check_last_AQ_V(l_switch,G3(:,:,:,105),wf(:,-1),G3tensor(:,108))
  call loop_AV_Q(G2(:,:,:,279),wf(:,20),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,62),MB,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,0),G3tensor(:,109))
  call loop_AQ_V(G2(:,:,:,279),wf(:,-1),G2(:,:,:,291))
  call loop_VA_Q(G2(:,:,:,291),wf(:,15),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,62),MB,G3(:,:,:,107))
  call check_last_AQ_V(l_switch,G3(:,:,:,107),wf(:,0),G3tensor(:,110))
  call loop_VA_Q(G2(:,:,:,291),wf(:,-3),G2(:,:,:,293))
  call loop_A_Q(G2(:,:,:,293),Q(:,46),MB,G3(:,:,:,108))
  call loop_AS_Q(G3(:,:,:,108),wf(:,-4),G3(:,:,:,109),gH)
  call loop_A_Q(G3(:,:,:,109),Q(:,62),MB,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,0),G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,242),wf(:,39),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,13),MB,G2(:,:,:,294))
  call loop_AV_Q(G2(:,:,:,294),wf(:,-5),G2(:,:,:,295))
  call loop_A_Q(G2(:,:,:,295),Q(:,45),MB,G3(:,:,:,110))
  call loop_AS_Q(G3(:,:,:,110),wf(:,-4),G3(:,:,:,111),gH)
  call loop_A_Q(G3(:,:,:,111),Q(:,61),MB,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,-1),G4tensor(:,20))
  call loop_AS_Q(G2(:,:,:,294),wf(:,-4),G2(:,:,:,296),gH)
  call loop_A_Q(G2(:,:,:,296),Q(:,29),MB,G3(:,:,:,112))
  call loop_AV_Q(G3(:,:,:,112),wf(:,-5),G3(:,:,:,113))
  call loop_A_Q(G3(:,:,:,113),Q(:,61),MB,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,-1),G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,242),wf(:,58),G1(:,:,:,247))
  call loop_A_Q(G1(:,:,:,247),Q(:,46),MB,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,-4),G2(:,:,:,298),gH)
  call loop_A_Q(G2(:,:,:,298),Q(:,62),MB,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,111))
  call loop_AV_Q(G1(:,:,:,242),wf(:,55),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,14),MB,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-5),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,46),MB,G3(:,:,:,115))
  call loop_AS_Q(G3(:,:,:,115),wf(:,-4),G3(:,:,:,116),gH)
  call loop_A_Q(G3(:,:,:,116),Q(:,62),MB,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,0),G4tensor(:,22))
  call loop_AS_Q(G2(:,:,:,299),wf(:,-4),G2(:,:,:,301),gH)
  call loop_A_Q(G2(:,:,:,301),Q(:,30),MB,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-5),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,62),MB,G4(:,:,:,23))
  call check_last_AQ_V(l_switch,G4(:,:,:,23),wf(:,0),G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,242),wf(:,251),G1(:,:,:,249))
  call loop_A_Q(G1(:,:,:,249),Q(:,61),MB,G2(:,:,:,302))
  call check_last_AQ_V(l_switch,G2(:,:,:,302),wf(:,-1),G2tensor(:,109))
  call loop_AQ_V(G1(:,:,:,242),wf(:,25),G1(:,:,:,250))
  call loop_VA_Q(G1(:,:,:,250),wf(:,5),G1(:,:,:,251))
  call loop_A_Q(G1(:,:,:,251),Q(:,61),MB,G2(:,:,:,303))
  call check_last_AQ_V(l_switch,G2(:,:,:,303),wf(:,-1),G2tensor(:,110))
  call loop_UV_W(G1(:,:,:,250),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,304))
  call loop_VA_Q(G2(:,:,:,304),wf(:,-3),G2(:,:,:,305))
  call loop_A_Q(G2(:,:,:,305),Q(:,61),MB,G3(:,:,:,119))
  call check_last_AQ_V(l_switch,G3(:,:,:,119),wf(:,-1),G3tensor(:,112))
  call loop_VA_Q(G1(:,:,:,250),wf(:,-3),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,29),MB,G2(:,:,:,306))
  call loop_AV_Q(G2(:,:,:,306),wf(:,-5),G2(:,:,:,307))
  call loop_A_Q(G2(:,:,:,307),Q(:,61),MB,G3(:,:,:,120))
  call check_last_AQ_V(l_switch,G3(:,:,:,120),wf(:,-1),G3tensor(:,113))
  call loop_AV_Q(G1(:,:,:,242),wf(:,393),G1(:,:,:,253))
  call loop_A_Q(G1(:,:,:,253),Q(:,61),MB,G2(:,:,:,308))
  call check_last_AQ_V(l_switch,G2(:,:,:,308),wf(:,-1),G2tensor(:,111))
  call loop_AV_Q(G1(:,:,:,242),wf(:,27),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,29),MB,G2(:,:,:,309))
  call loop_AV_Q(G2(:,:,:,309),wf(:,-5),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,61),MB,G3(:,:,:,121))
  call check_last_AQ_V(l_switch,G3(:,:,:,121),wf(:,-1),G3tensor(:,114))
  call loop_AV_Q(G1(:,:,:,242),wf(:,395),G1(:,:,:,255))
  call loop_A_Q(G1(:,:,:,255),Q(:,61),MB,G2(:,:,:,311))
  call check_last_AQ_V(l_switch,G2(:,:,:,311),wf(:,-1),G2tensor(:,112))
  call loop_AQ_V(G1(:,:,:,242),wf(:,109),G1(:,:,:,256))
  call loop_VA_Q(G1(:,:,:,256),wf(:,-3),G1(:,:,:,257))
  call loop_A_Q(G1(:,:,:,257),Q(:,61),MB,G2(:,:,:,312))
  call check_last_AQ_V(l_switch,G2(:,:,:,312),wf(:,-1),G2tensor(:,113))
  call loop_AV_Q(G1(:,:,:,242),wf(:,218),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,62),MB,G2(:,:,:,313))
  call check_last_AQ_V(l_switch,G2(:,:,:,313),wf(:,0),G2tensor(:,114))
  call loop_AQ_V(G1(:,:,:,242),wf(:,4),G1(:,:,:,259))
  call loop_VA_Q(G1(:,:,:,259),wf(:,5),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,62),MB,G2(:,:,:,314))
  call check_last_AQ_V(l_switch,G2(:,:,:,314),wf(:,0),G2tensor(:,115))
  call loop_UV_W(G1(:,:,:,259),Q(:,22),wf(:,-5),Q(:,32),G2(:,:,:,315))
  call loop_VA_Q(G2(:,:,:,315),wf(:,-3),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,62),MB,G3(:,:,:,122))
  call check_last_AQ_V(l_switch,G3(:,:,:,122),wf(:,0),G3tensor(:,115))
  call loop_VA_Q(G1(:,:,:,259),wf(:,-3),G1(:,:,:,261))
  call loop_A_Q(G1(:,:,:,261),Q(:,30),MB,G2(:,:,:,317))
  call loop_AV_Q(G2(:,:,:,317),wf(:,-5),G2(:,:,:,318))
  call loop_A_Q(G2(:,:,:,318),Q(:,62),MB,G3(:,:,:,123))
  call check_last_AQ_V(l_switch,G3(:,:,:,123),wf(:,0),G3tensor(:,116))
  call loop_AV_Q(G1(:,:,:,242),wf(:,405),G1(:,:,:,262))
  call loop_A_Q(G1(:,:,:,262),Q(:,62),MB,G2(:,:,:,319))
  call check_last_AQ_V(l_switch,G2(:,:,:,319),wf(:,0),G2tensor(:,116))
  call loop_AV_Q(G1(:,:,:,242),wf(:,10),G1(:,:,:,263))
  call loop_A_Q(G1(:,:,:,263),Q(:,30),MB,G2(:,:,:,320))
  call loop_AV_Q(G2(:,:,:,320),wf(:,-5),G2(:,:,:,321))
  call loop_A_Q(G2(:,:,:,321),Q(:,62),MB,G3(:,:,:,124))
  call check_last_AQ_V(l_switch,G3(:,:,:,124),wf(:,0),G3tensor(:,117))
  call loop_AV_Q(G1(:,:,:,242),wf(:,407),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,62),MB,G2(:,:,:,322))
  call check_last_AQ_V(l_switch,G2(:,:,:,322),wf(:,0),G2tensor(:,117))
  call loop_AQ_V(G1(:,:,:,242),wf(:,89),G1(:,:,:,265))
  call loop_VA_Q(G1(:,:,:,265),wf(:,-3),G1(:,:,:,266))
  call loop_A_Q(G1(:,:,:,266),Q(:,62),MB,G2(:,:,:,323))
  call check_last_AQ_V(l_switch,G2(:,:,:,323),wf(:,0),G2tensor(:,118))
  call loop_AV_Q(G1(:,:,:,242),wf(:,264),G1(:,:,:,267))
  call loop_A_Q(G1(:,:,:,267),Q(:,61),MB,G2(:,:,:,324))
  call check_last_AQ_V(l_switch,G2(:,:,:,324),wf(:,-1),G2tensor(:,119))
  call loop_AQ_V(G1(:,:,:,242),wf(:,33),G1(:,:,:,268))
  call loop_VA_Q(G1(:,:,:,268),wf(:,15),G1(:,:,:,269))
  call loop_A_Q(G1(:,:,:,269),Q(:,61),MB,G2(:,:,:,325))
  call check_last_AQ_V(l_switch,G2(:,:,:,325),wf(:,-1),G2tensor(:,120))
  call loop_VA_Q(G1(:,:,:,268),wf(:,-3),G1(:,:,:,270))
  call loop_A_Q(G1(:,:,:,270),Q(:,45),MB,G2(:,:,:,326))
  call loop_AS_Q(G2(:,:,:,326),wf(:,-4),G2(:,:,:,327),gH)
  call loop_A_Q(G2(:,:,:,327),Q(:,61),MB,G3(:,:,:,125))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,-1),G3tensor(:,118))
  call loop_AV_Q(G1(:,:,:,242),wf(:,232),G1(:,:,:,271))
  call loop_A_Q(G1(:,:,:,271),Q(:,62),MB,G2(:,:,:,328))
  call check_last_AQ_V(l_switch,G2(:,:,:,328),wf(:,0),G2tensor(:,121))
  call loop_AQ_V(G1(:,:,:,242),wf(:,14),G1(:,:,:,272))
  call loop_VA_Q(G1(:,:,:,272),wf(:,15),G1(:,:,:,273))
  call loop_A_Q(G1(:,:,:,273),Q(:,62),MB,G2(:,:,:,329))
  call check_last_AQ_V(l_switch,G2(:,:,:,329),wf(:,0),G2tensor(:,122))
  call loop_VA_Q(G1(:,:,:,272),wf(:,-3),G1(:,:,:,274))
  call loop_A_Q(G1(:,:,:,274),Q(:,46),MB,G2(:,:,:,330))
  call loop_AS_Q(G2(:,:,:,330),wf(:,-4),G2(:,:,:,331),gH)
  call loop_A_Q(G2(:,:,:,331),Q(:,62),MB,G3(:,:,:,126))
  call check_last_AQ_V(l_switch,G3(:,:,:,126),wf(:,0),G3tensor(:,119))
  call loop_AV_Q(G1(:,:,:,242),wf(:,426),G1(:,:,:,275))
  call loop_A_Q(G1(:,:,:,275),Q(:,61),MB,G2(:,:,:,332))
  call check_last_AQ_V(l_switch,G2(:,:,:,332),wf(:,-1),G2tensor(:,123))
  call loop_AV_Q(G1(:,:,:,242),wf(:,37),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,29),MB,G2(:,:,:,333))
  call loop_AV_Q(G2(:,:,:,333),wf(:,-5),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,61),MB,G3(:,:,:,127))
  call check_last_AQ_V(l_switch,G3(:,:,:,127),wf(:,-1),G3tensor(:,120))
  call loop_AV_Q(G1(:,:,:,242),wf(:,427),G1(:,:,:,277))
  call loop_A_Q(G1(:,:,:,277),Q(:,61),MB,G2(:,:,:,335))
  call check_last_AQ_V(l_switch,G2(:,:,:,335),wf(:,-1),G2tensor(:,124))
  call loop_AV_Q(G1(:,:,:,242),wf(:,430),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,62),MB,G2(:,:,:,336))
  call check_last_AQ_V(l_switch,G2(:,:,:,336),wf(:,0),G2tensor(:,125))
  call loop_AV_Q(G1(:,:,:,242),wf(:,20),G1(:,:,:,279))
  call loop_A_Q(G1(:,:,:,279),Q(:,30),MB,G2(:,:,:,337))
  call loop_AV_Q(G2(:,:,:,337),wf(:,-5),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,62),MB,G3(:,:,:,128))
  call check_last_AQ_V(l_switch,G3(:,:,:,128),wf(:,0),G3tensor(:,121))
  call loop_AV_Q(G1(:,:,:,242),wf(:,431),G1(:,:,:,280))
  call loop_A_Q(G1(:,:,:,280),Q(:,62),MB,G2(:,:,:,339))
  call check_last_AQ_V(l_switch,G2(:,:,:,339),wf(:,0),G2tensor(:,126))
  call loop_AQ_V(G1(:,:,:,242),wf(:,-1),G1(:,:,:,281))
  call loop_VA_Q(G1(:,:,:,281),wf(:,144),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,62),MB,G2(:,:,:,340))
  call check_last_AQ_V(l_switch,G2(:,:,:,340),wf(:,0),G2tensor(:,127))
  call loop_VA_Q(G1(:,:,:,281),wf(:,15),G1(:,:,:,283))
  call loop_A_Q(G1(:,:,:,283),Q(:,30),MB,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-5),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,62),MB,G3(:,:,:,129))
  call check_last_AQ_V(l_switch,G3(:,:,:,129),wf(:,0),G3tensor(:,122))
  call loop_UV_W(G1(:,:,:,281),Q(:,6),wf(:,-5),Q(:,32),G2(:,:,:,343))
  call loop_VA_Q(G2(:,:,:,343),wf(:,15),G2(:,:,:,344))
  call loop_A_Q(G2(:,:,:,344),Q(:,62),MB,G3(:,:,:,130))
  call check_last_AQ_V(l_switch,G3(:,:,:,130),wf(:,0),G3tensor(:,123))
  call loop_VA_Q(G2(:,:,:,343),wf(:,-3),G2(:,:,:,345))
  call loop_A_Q(G2(:,:,:,345),Q(:,46),MB,G3(:,:,:,131))
  call loop_AS_Q(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132),gH)
  call loop_A_Q(G3(:,:,:,132),Q(:,62),MB,G4(:,:,:,24))
  call check_last_AQ_V(l_switch,G4(:,:,:,24),wf(:,0),G4tensor(:,24))
  call loop_VA_Q(G1(:,:,:,281),wf(:,148),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,62),MB,G2(:,:,:,346))
  call check_last_AQ_V(l_switch,G2(:,:,:,346),wf(:,0),G2tensor(:,128))
  call loop_VA_Q(G1(:,:,:,281),wf(:,5),G1(:,:,:,285))
  call loop_A_Q(G1(:,:,:,285),Q(:,46),MB,G2(:,:,:,347))
  call loop_AS_Q(G2(:,:,:,347),wf(:,-4),G2(:,:,:,348),gH)
  call loop_A_Q(G2(:,:,:,348),Q(:,62),MB,G3(:,:,:,133))
  call check_last_AQ_V(l_switch,G3(:,:,:,133),wf(:,0),G3tensor(:,124))
  call loop_VA_Q(G1(:,:,:,281),wf(:,-3),G1(:,:,:,286))
  call loop_A_Q(G1(:,:,:,286),Q(:,14),MB,G2(:,:,:,349))
  call loop_AV_Q(G2(:,:,:,349),wf(:,-5),G2(:,:,:,350))
  call loop_A_Q(G2(:,:,:,350),Q(:,46),MB,G3(:,:,:,134))
  call loop_AS_Q(G3(:,:,:,134),wf(:,-4),G3(:,:,:,135),gH)
  call loop_A_Q(G3(:,:,:,135),Q(:,62),MB,G4(:,:,:,25))
  call check_last_AQ_V(l_switch,G4(:,:,:,25),wf(:,0),G4tensor(:,25))
  call loop_AS_Q(G2(:,:,:,349),wf(:,-4),G2(:,:,:,351),gH)
  call loop_A_Q(G2(:,:,:,351),Q(:,30),MB,G3(:,:,:,136))
  call loop_AV_Q(G3(:,:,:,136),wf(:,-5),G3(:,:,:,137))
  call loop_A_Q(G3(:,:,:,137),Q(:,62),MB,G4(:,:,:,26))
  call check_last_AQ_V(l_switch,G4(:,:,:,26),wf(:,0),G4tensor(:,26))
  call loop_AV_Q(G1(:,:,:,242),wf(:,70),G1(:,:,:,287))
  call loop_A_Q(G1(:,:,:,287),Q(:,45),MB,G2(:,:,:,352))
  call loop_AS_Q(G2(:,:,:,352),wf(:,-4),G2(:,:,:,353),gH)
  call loop_A_Q(G2(:,:,:,353),Q(:,61),MB,G3(:,:,:,138))
  call check_last_AQ_V(l_switch,G3(:,:,:,138),wf(:,-1),G3tensor(:,125))
  call loop_AV_Q(G1(:,:,:,242),wf(:,441),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,61),MB,G2(:,:,:,354))
  call check_last_AQ_V(l_switch,G2(:,:,:,354),wf(:,-1),G2tensor(:,129))
  call loop_AQ_V(G1(:,:,:,242),wf(:,111),G1(:,:,:,289))
  call loop_VA_Q(G1(:,:,:,289),wf(:,-3),G1(:,:,:,290))
  call loop_A_Q(G1(:,:,:,290),Q(:,61),MB,G2(:,:,:,355))
  call check_last_AQ_V(l_switch,G2(:,:,:,355),wf(:,-1),G2tensor(:,130))
  call loop_AV_Q(G1(:,:,:,242),wf(:,65),G1(:,:,:,291))
  call loop_A_Q(G1(:,:,:,291),Q(:,46),MB,G2(:,:,:,356))
  call loop_AS_Q(G2(:,:,:,356),wf(:,-4),G2(:,:,:,357),gH)
  call loop_A_Q(G2(:,:,:,357),Q(:,62),MB,G3(:,:,:,139))
  call check_last_AQ_V(l_switch,G3(:,:,:,139),wf(:,0),G3tensor(:,126))
  call loop_AV_Q(G1(:,:,:,242),wf(:,451),G1(:,:,:,292))
  call loop_A_Q(G1(:,:,:,292),Q(:,62),MB,G2(:,:,:,358))
  call check_last_AQ_V(l_switch,G2(:,:,:,358),wf(:,0),G2tensor(:,131))
  call loop_AQ_V(G1(:,:,:,242),wf(:,92),G1(:,:,:,293))
  call loop_VA_Q(G1(:,:,:,293),wf(:,-3),G1(:,:,:,294))
  call loop_A_Q(G1(:,:,:,294),Q(:,62),MB,G2(:,:,:,359))
  call check_last_AQ_V(l_switch,G2(:,:,:,359),wf(:,0),G2tensor(:,132))
  call loop_AV_Q(G1(:,:,:,242),wf(:,72),G1(:,:,:,295))
  call loop_A_Q(G1(:,:,:,295),Q(:,45),MB,G2(:,:,:,360))
  call loop_AS_Q(G2(:,:,:,360),wf(:,-4),G2(:,:,:,361),gH)
  call loop_A_Q(G2(:,:,:,361),Q(:,61),MB,G3(:,:,:,140))
  call check_last_AQ_V(l_switch,G3(:,:,:,140),wf(:,-1),G3tensor(:,127))
  call loop_AV_Q(G1(:,:,:,242),wf(:,468),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,61),MB,G2(:,:,:,362))
  call check_last_AQ_V(l_switch,G2(:,:,:,362),wf(:,-1),G2tensor(:,133))
  call loop_AV_Q(G1(:,:,:,242),wf(:,68),G1(:,:,:,297))
  call loop_A_Q(G1(:,:,:,297),Q(:,46),MB,G2(:,:,:,363))
  call loop_AS_Q(G2(:,:,:,363),wf(:,-4),G2(:,:,:,364),gH)
  call loop_A_Q(G2(:,:,:,364),Q(:,62),MB,G3(:,:,:,141))
  call check_last_AQ_V(l_switch,G3(:,:,:,141),wf(:,0),G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,242),wf(:,471),G1(:,:,:,298))
  call loop_A_Q(G1(:,:,:,298),Q(:,62),MB,G2(:,:,:,365))
  call check_last_AQ_V(l_switch,G2(:,:,:,365),wf(:,0),G2tensor(:,134))
  call loop_AV_Q(G0(:,:,:,1),wf(:,57),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,21),ZERO,G1(:,:,:,299))
  call loop_AV_Q(G1(:,:,:,299),wf(:,-5),G1(:,:,:,300))
  call loop_A_Q(G1(:,:,:,300),Q(:,53),ZERO,G2(:,:,:,366))
  call loop_AV_Q(G2(:,:,:,366),wf(:,55),G2(:,:,:,367))
  call check_last_A_Q(l_switch,G2(:,:,:,367),Q(:,63),ZERO,G3tensor(:,129))
  call loop_AV_Q(G0(:,:,:,1),wf(:,57),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,21),MT,G1(:,:,:,301))
  call loop_AV_Q(G1(:,:,:,301),wf(:,-5),G1(:,:,:,302))
  call loop_A_Q(G1(:,:,:,302),Q(:,53),MT,G2(:,:,:,368))
  call loop_AV_Q(G2(:,:,:,368),wf(:,55),G2(:,:,:,369))
  call check_last_A_Q(l_switch,G2(:,:,:,369),Q(:,63),MT,G3tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,21),ZERO,G1(:,:,:,303))
  call loop_QV_A(G1(:,:,:,303),wf(:,-5),G1(:,:,:,304))
  call loop_Q_A(G1(:,:,:,304),Q(:,53),ZERO,G2(:,:,:,370))
  call loop_QV_A(G2(:,:,:,370),wf(:,55),G2(:,:,:,371))
  call check_last_Q_A(l_switch,G2(:,:,:,371),Q(:,63),ZERO,G3tensor(:,131))
  call loop_QV_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,21),MT,G1(:,:,:,305))
  call loop_QV_A(G1(:,:,:,305),wf(:,-5),G1(:,:,:,306))
  call loop_Q_A(G1(:,:,:,306),Q(:,53),MT,G2(:,:,:,372))
  call loop_QV_A(G2(:,:,:,372),wf(:,55),G2(:,:,:,373))
  call check_last_Q_A(l_switch,G2(:,:,:,373),Q(:,63),MT,G3tensor(:,132))
  call loop_AV_Q(G0(:,:,:,1),wf(:,57),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,21),MB,G1(:,:,:,307))
  call loop_AV_Q(G1(:,:,:,307),wf(:,-5),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,53),MB,G2(:,:,:,374))
  call loop_AV_Q(G2(:,:,:,374),wf(:,55),G2(:,:,:,375))
  call check_last_A_Q(l_switch,G2(:,:,:,375),Q(:,63),MB,G3tensor(:,133))
  call loop_QV_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,21),MB,G1(:,:,:,309))
  call loop_QV_A(G1(:,:,:,309),wf(:,-5),G1(:,:,:,310))
  call loop_Q_A(G1(:,:,:,310),Q(:,53),MB,G2(:,:,:,376))
  call loop_QV_A(G2(:,:,:,376),wf(:,55),G2(:,:,:,377))
  call check_last_Q_A(l_switch,G2(:,:,:,377),Q(:,63),MB,G3tensor(:,134))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,57),G1(:,:,:,311))
  call loop_DV_C(G1(:,:,:,311),Q(:,21),wf(:,-5),G2(:,:,:,378))
  call check_last_DV_C(l_switch,G2(:,:,:,378),Q(:,53),wf(:,55),G3tensor(:,135))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,57),Q(:,21),G1(:,:,:,312))
  call loop_CV_D(G1(:,:,:,312),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,379))
  call check_last_CV_D(l_switch,G2(:,:,:,379),Q(:,53),wf(:,55),Q(:,10),G3tensor(:,136))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,57),Q(:,21),G1(:,:,:,313))
  call loop_UV_W(G1(:,:,:,313),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,380))
  call check_last_UV_W(l_switch,G2(:,:,:,380),Q(:,53),wf(:,55),Q(:,10),G3tensor(:,137))
  call loop_VA_Q(G2(:,:,:,380),wf(:,-3),G2(:,:,:,381))
  call loop_A_Q(G2(:,:,:,381),Q(:,61),MB,G3(:,:,:,142))
  call check_last_AQ_V(l_switch,G3(:,:,:,142),wf(:,-1),G3tensor(:,138))
  call loop_VQ_A(G1(:,:,:,313),wf(:,14),G1(:,:,:,314))
  call loop_Q_A(G1(:,:,:,314),Q(:,55),MB,G2(:,:,:,382))
  call check_last_QA_V(l_switch,G2(:,:,:,382),wf(:,-3),G2tensor(:,135))
  call loop_VA_Q(G1(:,:,:,313),wf(:,5),G1(:,:,:,315))
  call loop_A_Q(G1(:,:,:,315),Q(:,61),MB,G2(:,:,:,383))
  call check_last_AQ_V(l_switch,G2(:,:,:,383),wf(:,-1),G2tensor(:,136))
  call loop_VA_Q(G1(:,:,:,313),wf(:,-3),G1(:,:,:,316))
  call loop_A_Q(G1(:,:,:,316),Q(:,29),MB,G2(:,:,:,384))
  call loop_AV_Q(G2(:,:,:,384),wf(:,-5),G2(:,:,:,385))
  call loop_A_Q(G2(:,:,:,385),Q(:,61),MB,G3(:,:,:,143))
  call check_last_AQ_V(l_switch,G3(:,:,:,143),wf(:,-1),G3tensor(:,139))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,55),Q(:,10),G1(:,:,:,317))
  call loop_VQ_A(G1(:,:,:,317),wf(:,109),G1(:,:,:,318))
  call loop_Q_A(G1(:,:,:,318),Q(:,59),MB,G2(:,:,:,386))
  call check_last_QA_V(l_switch,G2(:,:,:,386),wf(:,-2),G2tensor(:,137))
  call loop_VQ_A(G1(:,:,:,317),wf(:,25),G1(:,:,:,319))
  call loop_Q_A(G1(:,:,:,319),Q(:,27),MB,G2(:,:,:,387))
  call loop_QV_A(G2(:,:,:,387),wf(:,-5),G2(:,:,:,388))
  call loop_Q_A(G2(:,:,:,388),Q(:,59),MB,G3(:,:,:,144))
  call check_last_QA_V(l_switch,G3(:,:,:,144),wf(:,-2),G3tensor(:,140))
  call loop_UV_W(G1(:,:,:,317),Q(:,10),wf(:,-5),Q(:,32),G2(:,:,:,389))
  call loop_VQ_A(G2(:,:,:,389),wf(:,25),G2(:,:,:,390))
  call loop_Q_A(G2(:,:,:,390),Q(:,59),MB,G3(:,:,:,145))
  call check_last_QA_V(l_switch,G3(:,:,:,145),wf(:,-2),G3tensor(:,141))
  call loop_VA_Q(G2(:,:,:,389),wf(:,48),G2(:,:,:,391))
  call loop_A_Q(G2(:,:,:,391),Q(:,62),MB,G3(:,:,:,146))
  call check_last_AQ_V(l_switch,G3(:,:,:,146),wf(:,0),G3tensor(:,142))
  call loop_VA_Q(G2(:,:,:,389),wf(:,-2),G2(:,:,:,392))
  call loop_A_Q(G2(:,:,:,392),Q(:,46),MB,G3(:,:,:,147))
  call loop_AS_Q(G3(:,:,:,147),wf(:,-4),G3(:,:,:,148),gH)
  call loop_A_Q(G3(:,:,:,148),Q(:,62),MB,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,0),G4tensor(:,27))
  call loop_VA_Q(G1(:,:,:,317),wf(:,157),G1(:,:,:,320))
  call loop_A_Q(G1(:,:,:,320),Q(:,62),MB,G2(:,:,:,393))
  call check_last_AQ_V(l_switch,G2(:,:,:,393),wf(:,0),G2tensor(:,138))
  call loop_VA_Q(G1(:,:,:,317),wf(:,48),G1(:,:,:,321))
  call loop_A_Q(G1(:,:,:,321),Q(:,30),MB,G2(:,:,:,394))
  call loop_AV_Q(G2(:,:,:,394),wf(:,-5),G2(:,:,:,395))
  call loop_A_Q(G2(:,:,:,395),Q(:,62),MB,G3(:,:,:,149))
  call check_last_AQ_V(l_switch,G3(:,:,:,149),wf(:,0),G3tensor(:,143))
  call loop_VQ_A(G1(:,:,:,317),wf(:,111),G1(:,:,:,322))
  call loop_Q_A(G1(:,:,:,322),Q(:,59),MB,G2(:,:,:,396))
  call check_last_QA_V(l_switch,G2(:,:,:,396),wf(:,-2),G2tensor(:,139))
  call loop_VQ_A(G1(:,:,:,317),wf(:,33),G1(:,:,:,323))
  call loop_Q_A(G1(:,:,:,323),Q(:,43),MB,G2(:,:,:,397))
  call loop_QS_A(G2(:,:,:,397),wf(:,-4),G2(:,:,:,398),gH)
  call loop_Q_A(G2(:,:,:,398),Q(:,59),MB,G3(:,:,:,150))
  call check_last_QA_V(l_switch,G3(:,:,:,150),wf(:,-2),G3tensor(:,144))
  call loop_VA_Q(G1(:,:,:,317),wf(:,159),G1(:,:,:,324))
  call loop_A_Q(G1(:,:,:,324),Q(:,62),MB,G2(:,:,:,399))
  call check_last_AQ_V(l_switch,G2(:,:,:,399),wf(:,0),G2tensor(:,140))
  call loop_VA_Q(G1(:,:,:,317),wf(:,41),G1(:,:,:,325))
  call loop_A_Q(G1(:,:,:,325),Q(:,46),MB,G2(:,:,:,400))
  call loop_AS_Q(G2(:,:,:,400),wf(:,-4),G2(:,:,:,401),gH)
  call loop_A_Q(G2(:,:,:,401),Q(:,62),MB,G3(:,:,:,151))
  call check_last_AQ_V(l_switch,G3(:,:,:,151),wf(:,0),G3tensor(:,145))
  call loop_VA_Q(G1(:,:,:,317),wf(:,-2),G1(:,:,:,326))
  call loop_A_Q(G1(:,:,:,326),Q(:,14),MB,G2(:,:,:,402))
  call loop_AV_Q(G2(:,:,:,402),wf(:,-5),G2(:,:,:,403))
  call loop_A_Q(G2(:,:,:,403),Q(:,46),MB,G3(:,:,:,152))
  call loop_AS_Q(G3(:,:,:,152),wf(:,-4),G3(:,:,:,153),gH)
  call loop_A_Q(G3(:,:,:,153),Q(:,62),MB,G4(:,:,:,28))
  call check_last_AQ_V(l_switch,G4(:,:,:,28),wf(:,0),G4tensor(:,28))
  call loop_AS_Q(G2(:,:,:,402),wf(:,-4),G2(:,:,:,404),gH)
  call loop_A_Q(G2(:,:,:,404),Q(:,30),MB,G3(:,:,:,154))
  call loop_AV_Q(G3(:,:,:,154),wf(:,-5),G3(:,:,:,155))
  call loop_A_Q(G3(:,:,:,155),Q(:,62),MB,G4(:,:,:,29))
  call check_last_AQ_V(l_switch,G4(:,:,:,29),wf(:,0),G4tensor(:,29))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,42),G1(:,:,:,327))
  call loop_VQ_A(G1(:,:,:,327),wf(:,25),G1(:,:,:,328))
  call loop_Q_A(G1(:,:,:,328),Q(:,59),MB,G2(:,:,:,405))
  call check_last_QA_V(l_switch,G2(:,:,:,405),wf(:,-2),G2tensor(:,141))
  call loop_VA_Q(G1(:,:,:,327),wf(:,48),G1(:,:,:,329))
  call loop_A_Q(G1(:,:,:,329),Q(:,62),MB,G2(:,:,:,406))
  call check_last_AQ_V(l_switch,G2(:,:,:,406),wf(:,0),G2tensor(:,142))
  call loop_VA_Q(G1(:,:,:,327),wf(:,-2),G1(:,:,:,330))
  call loop_A_Q(G1(:,:,:,330),Q(:,46),MB,G2(:,:,:,407))
  call loop_AS_Q(G2(:,:,:,407),wf(:,-4),G2(:,:,:,408),gH)
  call loop_A_Q(G2(:,:,:,408),Q(:,62),MB,G3(:,:,:,156))
  call check_last_AQ_V(l_switch,G3(:,:,:,156),wf(:,0),G3tensor(:,146))
  call check_last_UV_W(l_switch,G1(:,:,:,327),Q(:,42),wf(:,57),Q(:,21),G2tensor(:,143))
  call check_last_UV_W(l_switch,G1(:,:,:,327),Q(:,42),wf(:,64),Q(:,21),G2tensor(:,144))
  call loop_VQ_A(G0(:,:,:,1),wf(:,300),G0(:,:,:,64))
  call loop_Q_A(G0(:,:,:,64),Q(:,27),MB,G1(:,:,:,331))
  call loop_QV_A(G1(:,:,:,331),wf(:,-5),G1(:,:,:,332))
  call loop_Q_A(G1(:,:,:,332),Q(:,59),MB,G2(:,:,:,409))
  call check_last_QA_V(l_switch,G2(:,:,:,409),wf(:,-2),G2tensor(:,145))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,21),ZERO,G1(:,:,:,333))
  call loop_QV_A(G1(:,:,:,333),wf(:,-5),G1(:,:,:,334))
  call loop_Q_A(G1(:,:,:,334),Q(:,53),ZERO,G2(:,:,:,410))
  call loop_QV_A(G2(:,:,:,410),wf(:,55),G2(:,:,:,411))
  call check_last_Q_A(l_switch,G2(:,:,:,411),Q(:,63),ZERO,G3tensor(:,147))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,21),MT,G1(:,:,:,335))
  call loop_QV_A(G1(:,:,:,335),wf(:,-5),G1(:,:,:,336))
  call loop_Q_A(G1(:,:,:,336),Q(:,53),MT,G2(:,:,:,412))
  call loop_QV_A(G2(:,:,:,412),wf(:,55),G2(:,:,:,413))
  call check_last_Q_A(l_switch,G2(:,:,:,413),Q(:,63),MT,G3tensor(:,148))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,21),ZERO,G1(:,:,:,337))
  call loop_AV_Q(G1(:,:,:,337),wf(:,-5),G1(:,:,:,338))
  call loop_A_Q(G1(:,:,:,338),Q(:,53),ZERO,G2(:,:,:,414))
  call loop_AV_Q(G2(:,:,:,414),wf(:,55),G2(:,:,:,415))
  call check_last_A_Q(l_switch,G2(:,:,:,415),Q(:,63),ZERO,G3tensor(:,149))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,68))
  call loop_A_Q(G0(:,:,:,68),Q(:,21),MT,G1(:,:,:,339))
  call loop_AV_Q(G1(:,:,:,339),wf(:,-5),G1(:,:,:,340))
  call loop_A_Q(G1(:,:,:,340),Q(:,53),MT,G2(:,:,:,416))
  call loop_AV_Q(G2(:,:,:,416),wf(:,55),G2(:,:,:,417))
  call check_last_A_Q(l_switch,G2(:,:,:,417),Q(:,63),MT,G3tensor(:,150))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,21),MB,G1(:,:,:,341))
  call loop_QV_A(G1(:,:,:,341),wf(:,-5),G1(:,:,:,342))
  call loop_Q_A(G1(:,:,:,342),Q(:,53),MB,G2(:,:,:,418))
  call loop_QV_A(G2(:,:,:,418),wf(:,55),G2(:,:,:,419))
  call check_last_Q_A(l_switch,G2(:,:,:,419),Q(:,63),MB,G3tensor(:,151))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,21),MB,G1(:,:,:,343))
  call loop_AV_Q(G1(:,:,:,343),wf(:,-5),G1(:,:,:,344))
  call loop_A_Q(G1(:,:,:,344),Q(:,53),MB,G2(:,:,:,420))
  call loop_AV_Q(G2(:,:,:,420),wf(:,55),G2(:,:,:,421))
  call check_last_A_Q(l_switch,G2(:,:,:,421),Q(:,63),MB,G3tensor(:,152))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,64),Q(:,21),G1(:,:,:,345))
  call loop_CV_D(G1(:,:,:,345),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,422))
  call check_last_CV_D(l_switch,G2(:,:,:,422),Q(:,53),wf(:,55),Q(:,10),G3tensor(:,153))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,64),G1(:,:,:,346))
  call loop_DV_C(G1(:,:,:,346),Q(:,21),wf(:,-5),G2(:,:,:,423))
  call check_last_DV_C(l_switch,G2(:,:,:,423),Q(:,53),wf(:,55),G3tensor(:,154))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(3) = M(3) + ((CI*f(13))/4._/**/REALKIND * den(489)) * TI2_call(2,momenta_42,masses2_7,G2tensor(:,1),T2sum(1:15,36))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(489)) * TI2_call(2,momenta_42,masses2_7,G2tensor(:,1),T2sum(1:15,36))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,13),T3sum(1:35,45))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,13),T3sum(1:35,45))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,13),T3sum(1:35,45))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,15),T3sum(1:35,45))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,15),T3sum(1:35,45))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,15),T3sum(1:35,45))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,12),T3sum(1:35,44))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,16),T3sum(1:35,46))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,16),T3sum(1:35,46))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,16),T3sum(1:35,46))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,14),T3sum(1:35,44))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,17),T3sum(1:35,46))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,17),T3sum(1:35,46))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,17),T3sum(1:35,46))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,18),T3sum(1:35,44))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,18),T3sum(1:35,44))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,19),T3sum(1:35,44))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,19),T3sum(1:35,44))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,20),T3sum(1:35,44))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(29)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,20),T3sum(1:35,44))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(136)) * TI2_call(2,momenta_115,masses2_6,G2tensor(:,18),T2sum(1:15,37))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(136)) * TI2_call(2,momenta_115,masses2_6,G2tensor(:,18),T2sum(1:15,37))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(32)) * TI2_call(2,momenta_39,masses2_6,G2tensor(:,3),T2sum(1:15,39))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(32)) * TI2_call(2,momenta_39,masses2_6,G2tensor(:,3),T2sum(1:15,39))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND * den(137)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,5),T2sum(1:15,41))
  M(4) = M(4) + (-(CI*f(13))/12._/**/REALKIND * den(137)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,5),T2sum(1:15,41))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(137)) * TI2_call(2,momenta_100,masses2_9,G2tensor(:,22),T2sum(1:15,3))
  M(4) = M(4) + ((-3*f(15))/4._/**/REALKIND * den(137)) * TI2_call(2,momenta_100,masses2_9,G2tensor(:,22),T2sum(1:15,3))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(240)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,26),T2sum(1:15,20))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(240)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,26),T2sum(1:15,20))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_208,masses2_12,G3tensor(:,5),T3sum(1:35,47))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(25)) * TI2_call(3,momenta_208,masses2_12,G3tensor(:,5),T3sum(1:35,47))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(25)) * TI2_call(3,momenta_208,masses2_12,G3tensor(:,5),T3sum(1:35,47))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,6),T3sum(1:35,48))
  M(3) = M(3) + (-(f(15)/4._/**/REALKIND) * den(25)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,6),T3sum(1:35,48))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,6),T3sum(1:35,48))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(25)) * TI2_call(3,momenta_213,masses2_12,G3tensor(:,1),T3sum(1:35,51))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_213,masses2_12,G3tensor(:,1),T3sum(1:35,51))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(25)) * TI2_call(3,momenta_213,masses2_12,G3tensor(:,1),T3sum(1:35,51))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(490)) * TI2_call(2,momenta_83,masses2_6,G2tensor(:,27),T2sum(1:15,42))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(490)) * TI2_call(2,momenta_83,masses2_6,G2tensor(:,27),T2sum(1:15,42))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,33),T3sum(1:35,45))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,33),T3sum(1:35,45))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,33),T3sum(1:35,45))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,35),T3sum(1:35,45))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,35),T3sum(1:35,45))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_8,G3tensor(:,35),T3sum(1:35,45))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,32),T3sum(1:35,44))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,36),T3sum(1:35,46))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,36),T3sum(1:35,46))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,36),T3sum(1:35,46))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,34),T3sum(1:35,44))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,37),T3sum(1:35,46))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,37),T3sum(1:35,46))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(39)) * TI2_call(3,momenta_66,masses2_5,G3tensor(:,37),T3sum(1:35,46))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,38),T3sum(1:35,44))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,38),T3sum(1:35,44))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,39),T3sum(1:35,44))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,39),T3sum(1:35,44))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,40),T3sum(1:35,44))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(39)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,40),T3sum(1:35,44))
  M(1) = M(1) + ((-3*f(15))/4._/**/REALKIND * den(175)) * TI2_call(2,momenta_101,masses2_9,G2tensor(:,23),T2sum(1:15,4))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(175)) * TI2_call(2,momenta_101,masses2_9,G2tensor(:,23),T2sum(1:15,4))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(174)) * TI2_call(2,momenta_25,masses2_9,G2tensor(:,42),T2sum(1:15,46))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(174)) * TI2_call(2,momenta_25,masses2_9,G2tensor(:,42),T2sum(1:15,46))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(252)) * TI2_call(2,momenta_74,masses2_6,G2tensor(:,44),T2sum(1:15,47))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(252)) * TI2_call(2,momenta_74,masses2_6,G2tensor(:,44),T2sum(1:15,47))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(250)) * TI2_call(3,momenta_153,masses2_17,G3tensor(:,43),T3sum(1:35,53))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(250)) * TI2_call(3,momenta_154,masses2_18,G3tensor(:,44),T3sum(1:35,58))
  M(3) = M(3) + (-(f(15)/4._/**/REALKIND) * den(250)) * TI2_call(3,momenta_154,masses2_18,G3tensor(:,44),T3sum(1:35,58))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(250)) * TI2_call(3,momenta_154,masses2_18,G3tensor(:,44),T3sum(1:35,58))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(139)) * TI2_call(2,momenta_115,masses2_6,G2tensor(:,45),T2sum(1:15,37))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(139)) * TI2_call(2,momenta_115,masses2_6,G2tensor(:,45),T2sum(1:15,37))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(40)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,28),T2sum(1:15,49))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(40)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,28),T2sum(1:15,49))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(257)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,49),T2sum(1:15,32))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(257)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,49),T2sum(1:15,32))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(34)) * TI2_call(3,momenta_276,masses2_12,G3tensor(:,24),T3sum(1:35,59))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(34)) * TI2_call(3,momenta_276,masses2_12,G3tensor(:,24),T3sum(1:35,59))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(34)) * TI2_call(3,momenta_280,masses2_12,G3tensor(:,25),T3sum(1:35,61))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(34)) * TI2_call(3,momenta_280,masses2_12,G3tensor(:,25),T3sum(1:35,61))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(176)) * TI2_call(2,momenta_25,masses2_9,G2tensor(:,43),T2sum(1:15,46))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(176)) * TI2_call(2,momenta_25,masses2_9,G2tensor(:,43),T2sum(1:15,46))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(234)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,50),T2sum(1:15,50))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(234)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,50),T2sum(1:15,50))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(232)) * TI2_call(3,momenta_155,masses2_17,G3tensor(:,45),T3sum(1:35,62))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(232)) * TI2_call(3,momenta_155,masses2_17,G3tensor(:,45),T3sum(1:35,62))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(408)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,51),T2sum(1:15,20))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(408)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,51),T2sum(1:15,20))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(409)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,52),T2sum(1:15,32))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(409)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,52),T2sum(1:15,32))
  M(1) = M(1) + ((-2*CI*f(13))/3._/**/REALKIND * den(411)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,53),T2sum(1:15,32))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(411)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,53),T2sum(1:15,32))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(412)) * TI2_call(2,momenta_74,masses2_6,G2tensor(:,54),T2sum(1:15,47))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(412)) * TI2_call(2,momenta_74,masses2_6,G2tensor(:,54),T2sum(1:15,47))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(413)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,55),T2sum(1:15,50))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(413)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,55),T2sum(1:15,50))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(31)) * TI2_call(3,momenta_204,masses2_12,G3tensor(:,46),T3sum(1:35,66))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(31)) * TI2_call(3,momenta_204,masses2_12,G3tensor(:,46),T3sum(1:35,66))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(31)) * TI2_call(3,momenta_203,masses2_12,G3tensor(:,47),T3sum(1:35,67))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(31)) * TI2_call(3,momenta_203,masses2_12,G3tensor(:,47),T3sum(1:35,67))
  M(1) = M(1) + ((-2*CI*f(13))/3._/**/REALKIND * den(414)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,56),T2sum(1:15,50))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(414)) * TI2_call(2,momenta_114,masses2_6,G2tensor(:,56),T2sum(1:15,50))
  M(1) = M(1) + ((-3*f(15))/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_301,masses2_17,G3tensor(:,23),T3sum(1:35,2))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_301,masses2_17,G3tensor(:,23),T3sum(1:35,2))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(24)) * TI2_call(4,momenta_369,masses2_25,G4tensor(:,1),T4sum(1:70,33))
  M(3) = M(3) + (-(f(15)/4._/**/REALKIND) * den(24)) * TI2_call(4,momenta_369,masses2_25,G4tensor(:,1),T4sum(1:70,33))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(24)) * TI2_call(4,momenta_369,masses2_25,G4tensor(:,1),T4sum(1:70,33))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(24)) * TI2_call(4,momenta_368,masses2_23,G4tensor(:,2),T4sum(1:70,34))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(24)) * TI2_call(4,momenta_367,masses2_23,G4tensor(:,3),T4sum(1:70,36))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(491)) * TI2_call(2,momenta_93,masses2_6,G2tensor(:,57),T2sum(1:15,51))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(491)) * TI2_call(2,momenta_93,masses2_6,G2tensor(:,57),T2sum(1:15,51))
  M(1) = M(1) + ((-3*f(15))/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,68),T2sum(1:15,5))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,68),T2sum(1:15,5))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,56),T3sum(1:35,71))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,56),T3sum(1:35,71))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,56),T3sum(1:35,71))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,58),T3sum(1:35,71))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,58),T3sum(1:35,71))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,58),T3sum(1:35,71))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,55),T3sum(1:35,70))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,59),T3sum(1:35,72))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,59),T3sum(1:35,72))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,59),T3sum(1:35,72))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,57),T3sum(1:35,70))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,60),T3sum(1:35,72))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,60),T3sum(1:35,72))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(50)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,60),T3sum(1:35,72))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,61),T3sum(1:35,70))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,61),T3sum(1:35,70))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,62),T3sum(1:35,70))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,62),T3sum(1:35,70))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,63),T3sum(1:35,70))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(50)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,63),T3sum(1:35,70))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(149)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,74),T2sum(1:15,55))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(149)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,74),T2sum(1:15,55))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(280)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,78),T2sum(1:15,56))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(280)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,78),T2sum(1:15,56))
  M(3) = M(3) + ((CI*f(13))/4._/**/REALKIND * den(44)) * TI2_call(3,momenta_184,masses2_17,G3tensor(:,66),T3sum(1:35,73))
  M(2) = M(2) + (-(f(15)/4._/**/REALKIND) * den(44)) * TI2_call(3,momenta_187,masses2_18,G3tensor(:,67),T3sum(1:35,78))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(44)) * TI2_call(3,momenta_187,masses2_18,G3tensor(:,67),T3sum(1:35,78))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(44)) * TI2_call(3,momenta_187,masses2_18,G3tensor(:,67),T3sum(1:35,78))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(492)) * TI2_call(2,momenta_51,masses2_7,G2tensor(:,79),T2sum(1:15,59))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(492)) * TI2_call(2,momenta_51,masses2_7,G2tensor(:,79),T2sum(1:15,59))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(56)) * TI2_call(2,momenta_49,masses2_6,G2tensor(:,81),T2sum(1:15,60))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(56)) * TI2_call(2,momenta_49,masses2_6,G2tensor(:,81),T2sum(1:15,60))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(164)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,83),T2sum(1:15,62))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(164)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,83),T2sum(1:15,62))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(164)) * TI2_call(2,momenta_109,masses2_9,G2tensor(:,69),T2sum(1:15,6))
  M(4) = M(4) + ((-3*f(15))/4._/**/REALKIND * den(164)) * TI2_call(2,momenta_109,masses2_9,G2tensor(:,69),T2sum(1:15,6))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,80),T3sum(1:35,71))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,80),T3sum(1:35,71))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,80),T3sum(1:35,71))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,82),T3sum(1:35,71))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,82),T3sum(1:35,71))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,82),T3sum(1:35,71))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,79),T3sum(1:35,70))
  M(1) = M(1) + (-(f(18)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,83),T3sum(1:35,72))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,83),T3sum(1:35,72))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,83),T3sum(1:35,72))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(3) = M(3) + (f(19)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(4) = M(4) + (-(f(19)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,81),T3sum(1:35,70))
  M(2) = M(2) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,84),T3sum(1:35,72))
  M(3) = M(3) + (f(18)/12._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,84),T3sum(1:35,72))
  M(4) = M(4) + (-(f(18)/4._/**/REALKIND) * den(58)) * TI2_call(3,momenta_57,masses2_5,G3tensor(:,84),T3sum(1:35,72))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,85),T3sum(1:35,70))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,85),T3sum(1:35,70))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,86),T3sum(1:35,70))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,86),T3sum(1:35,70))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,87),T3sum(1:35,70))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(58)) * TI2_call(3,momenta_57,masses2_10,G3tensor(:,87),T3sum(1:35,70))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(167)) * TI2_call(2,momenta_119,masses2_6,G2tensor(:,94),T2sum(1:15,63))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(167)) * TI2_call(2,momenta_119,masses2_6,G2tensor(:,94),T2sum(1:15,63))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(167)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,75),T2sum(1:15,64))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(167)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,75),T2sum(1:15,64))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(293)) * TI2_call(2,momenta_73,masses2_6,G2tensor(:,97),T2sum(1:15,29))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(293)) * TI2_call(2,momenta_73,masses2_6,G2tensor(:,97),T2sum(1:15,29))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(292)) * TI2_call(3,momenta_185,masses2_17,G3tensor(:,69),T3sum(1:35,79))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(292)) * TI2_call(3,momenta_228,masses2_12,G3tensor(:,75),T3sum(1:35,81))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(292)) * TI2_call(3,momenta_228,masses2_12,G3tensor(:,75),T3sum(1:35,81))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(292)) * TI2_call(3,momenta_228,masses2_12,G3tensor(:,75),T3sum(1:35,81))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(292)) * TI2_call(3,momenta_230,masses2_12,G3tensor(:,72),T3sum(1:35,83))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(292)) * TI2_call(3,momenta_230,masses2_12,G3tensor(:,72),T3sum(1:35,83))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(292)) * TI2_call(3,momenta_230,masses2_12,G3tensor(:,72),T3sum(1:35,83))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(292)) * TI2_call(3,momenta_188,masses2_18,G3tensor(:,68),T3sum(1:35,84))
  M(2) = M(2) + (-(f(15)/4._/**/REALKIND) * den(292)) * TI2_call(3,momenta_188,masses2_18,G3tensor(:,68),T3sum(1:35,84))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(292)) * TI2_call(3,momenta_188,masses2_18,G3tensor(:,68),T3sum(1:35,84))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(150)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,76),T2sum(1:15,55))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(150)) * TI2_call(2,momenta_30,masses2_9,G2tensor(:,76),T2sum(1:15,55))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(296)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,98),T2sum(1:15,65))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(296)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,98),T2sum(1:15,65))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(52)) * TI2_call(3,momenta_189,masses2_17,G3tensor(:,70),T3sum(1:35,85))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(52)) * TI2_call(3,momenta_189,masses2_17,G3tensor(:,70),T3sum(1:35,85))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(60)) * TI2_call(2,momenta_95,masses2_6,G2tensor(:,58),T2sum(1:15,66))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(60)) * TI2_call(2,momenta_95,masses2_6,G2tensor(:,58),T2sum(1:15,66))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(169)) * TI2_call(2,momenta_119,masses2_6,G2tensor(:,99),T2sum(1:15,63))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(169)) * TI2_call(2,momenta_119,masses2_6,G2tensor(:,99),T2sum(1:15,63))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(169)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,77),T2sum(1:15,64))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(169)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,77),T2sum(1:15,64))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(277)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,102),T2sum(1:15,34))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(277)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,102),T2sum(1:15,34))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(276)) * TI2_call(3,momenta_190,masses2_17,G3tensor(:,71),T3sum(1:35,88))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(276)) * TI2_call(3,momenta_190,masses2_17,G3tensor(:,71),T3sum(1:35,88))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(276)) * TI2_call(3,momenta_294,masses2_12,G3tensor(:,48),T3sum(1:35,89))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(276)) * TI2_call(3,momenta_294,masses2_12,G3tensor(:,48),T3sum(1:35,89))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(276)) * TI2_call(3,momenta_296,masses2_12,G3tensor(:,49),T3sum(1:35,90))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(276)) * TI2_call(3,momenta_296,masses2_12,G3tensor(:,49),T3sum(1:35,90))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(416)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,103),T2sum(1:15,56))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(416)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,103),T2sum(1:15,56))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(417)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,104),T2sum(1:15,65))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(417)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,104),T2sum(1:15,65))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(55)) * TI2_call(3,momenta_200,masses2_12,G3tensor(:,90),T3sum(1:35,92))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(55)) * TI2_call(3,momenta_200,masses2_12,G3tensor(:,90),T3sum(1:35,92))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(55)) * TI2_call(3,momenta_199,masses2_12,G3tensor(:,91),T3sum(1:35,93))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(55)) * TI2_call(3,momenta_199,masses2_12,G3tensor(:,91),T3sum(1:35,93))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(419)) * TI2_call(2,momenta_73,masses2_6,G2tensor(:,105),T2sum(1:15,29))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(419)) * TI2_call(2,momenta_73,masses2_6,G2tensor(:,105),T2sum(1:15,29))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(420)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,106),T2sum(1:15,34))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(420)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,106),T2sum(1:15,34))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(46)) * TI2_call(3,momenta_202,masses2_12,G3tensor(:,92),T3sum(1:35,36))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(46)) * TI2_call(3,momenta_202,masses2_12,G3tensor(:,92),T3sum(1:35,36))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(46)) * TI2_call(3,momenta_201,masses2_12,G3tensor(:,93),T3sum(1:35,37))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(46)) * TI2_call(3,momenta_201,masses2_12,G3tensor(:,93),T3sum(1:35,37))
  M(1) = M(1) + ((2*CI*f(13))/3._/**/REALKIND * den(421)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,107),T2sum(1:15,65))
  M(4) = M(4) + ((-2*CI*f(13))/3._/**/REALKIND * den(421)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,107),T2sum(1:15,65))
  M(1) = M(1) + ((2*CI*f(13))/3._/**/REALKIND * den(422)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,108),T2sum(1:15,34))
  M(4) = M(4) + ((-2*CI*f(13))/3._/**/REALKIND * den(422)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,108),T2sum(1:15,34))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(122)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,94),T3sum(1:35,94))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(122)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,94),T3sum(1:35,94))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(122)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,95),T3sum(1:35,95))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(122)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,95),T3sum(1:35,95))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(122)) * TI2_call(3,momenta_309,masses2_17,G3tensor(:,54),T3sum(1:35,3))
  M(4) = M(4) + ((-3*f(15))/4._/**/REALKIND * den(122)) * TI2_call(3,momenta_309,masses2_17,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_356,masses2_19,G4tensor(:,14),T4sum(1:70,37))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_356,masses2_19,G4tensor(:,14),T4sum(1:70,37))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_356,masses2_19,G4tensor(:,14),T4sum(1:70,37))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_341,masses2_19,G4tensor(:,20),T4sum(1:70,38))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_341,masses2_19,G4tensor(:,20),T4sum(1:70,38))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_341,masses2_19,G4tensor(:,20),T4sum(1:70,38))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_345,masses2_19,G4tensor(:,7),T4sum(1:70,39))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_345,masses2_19,G4tensor(:,7),T4sum(1:70,39))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_345,masses2_19,G4tensor(:,7),T4sum(1:70,39))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_340,masses2_19,G4tensor(:,21),T4sum(1:70,40))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_340,masses2_19,G4tensor(:,21),T4sum(1:70,40))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_340,masses2_19,G4tensor(:,21),T4sum(1:70,40))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_347,masses2_19,G4tensor(:,8),T4sum(1:70,41))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_347,masses2_19,G4tensor(:,8),T4sum(1:70,41))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_347,masses2_19,G4tensor(:,8),T4sum(1:70,41))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(42)) * TI2_call(4,momenta_358,masses2_19,G4tensor(:,15),T4sum(1:70,42))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(4,momenta_358,masses2_19,G4tensor(:,15),T4sum(1:70,42))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_358,masses2_19,G4tensor(:,15),T4sum(1:70,42))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_399,masses2_25,G4tensor(:,4),T4sum(1:70,45))
  M(2) = M(2) + (-(f(15)/4._/**/REALKIND) * den(42)) * TI2_call(4,momenta_399,masses2_25,G4tensor(:,4),T4sum(1:70,45))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_399,masses2_25,G4tensor(:,4),T4sum(1:70,45))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_398,masses2_23,G4tensor(:,5),T4sum(1:70,46))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(42)) * TI2_call(4,momenta_397,masses2_23,G4tensor(:,6),T4sum(1:70,48))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(493)) * TI2_call(2,momenta_94,masses2_6,G2tensor(:,60),T2sum(1:15,67))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(493)) * TI2_call(2,momenta_94,masses2_6,G2tensor(:,60),T2sum(1:15,67))
  M(1) = M(1) + (-(CI*f(13))/4._/**/REALKIND * den(493)) * TI2_call(2,momenta_40,masses2_7,G2tensor(:,8),T2sum(1:15,68))
  M(2) = M(2) + ((3*CI*f(13))/4._/**/REALKIND * den(493)) * TI2_call(2,momenta_40,masses2_7,G2tensor(:,8),T2sum(1:15,68))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,130),T3sum(1:35,97))
  M(2) = M(2) + (f(18)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,130),T3sum(1:35,97))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,130),T3sum(1:35,97))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(3) = M(3) + (f(19)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,132),T3sum(1:35,97))
  M(3) = M(3) + (f(18)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,132),T3sum(1:35,97))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,132),T3sum(1:35,97))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,129),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,133),T3sum(1:35,98))
  M(2) = M(2) + (f(18)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,133),T3sum(1:35,98))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,133),T3sum(1:35,98))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(3) = M(3) + (f(19)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,131),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,134),T3sum(1:35,98))
  M(3) = M(3) + (f(18)/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,134),T3sum(1:35,98))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(66)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,134),T3sum(1:35,98))
  M(2) = M(2) + ((-3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,135),T3sum(1:35,96))
  M(3) = M(3) + ((3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,135),T3sum(1:35,96))
  M(2) = M(2) + ((3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,136),T3sum(1:35,96))
  M(3) = M(3) + ((-3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,136),T3sum(1:35,96))
  M(2) = M(2) + ((3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,137),T3sum(1:35,96))
  M(3) = M(3) + ((-3*CI*f(13))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,137),T3sum(1:35,96))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(151)) * TI2_call(2,momenta_116,masses2_6,G2tensor(:,19),T2sum(1:15,69))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(151)) * TI2_call(2,momenta_116,masses2_6,G2tensor(:,19),T2sum(1:15,69))
  M(1) = M(1) + (-(CI*f(13))/4._/**/REALKIND * den(151)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,137),T2sum(1:15,70))
  M(3) = M(3) + ((3*CI*f(13))/4._/**/REALKIND * den(151)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,137),T2sum(1:15,70))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(68)) * TI2_call(2,momenta_39,masses2_6,G2tensor(:,4),T2sum(1:15,39))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(68)) * TI2_call(2,momenta_39,masses2_6,G2tensor(:,4),T2sum(1:15,39))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(152)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,10),T2sum(1:15,71))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(152)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,10),T2sum(1:15,71))
  M(2) = M(2) + ((3*f(15))/4._/**/REALKIND * den(152)) * TI2_call(2,momenta_110,masses2_9,G2tensor(:,141),T2sum(1:15,7))
  M(3) = M(3) + ((-3*f(15))/4._/**/REALKIND * den(152)) * TI2_call(2,momenta_110,masses2_9,G2tensor(:,141),T2sum(1:15,7))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(319)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,145),T2sum(1:15,56))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(319)) * TI2_call(2,momenta_72,masses2_6,G2tensor(:,145),T2sum(1:15,56))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(62)) * TI2_call(3,momenta_212,masses2_12,G3tensor(:,9),T3sum(1:35,99))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(62)) * TI2_call(3,momenta_212,masses2_12,G3tensor(:,9),T3sum(1:35,99))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(62)) * TI2_call(3,momenta_212,masses2_12,G3tensor(:,9),T3sum(1:35,99))
  M(4) = M(4) + (-(CI*f(13))/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_192,masses2_17,G3tensor(:,140),T3sum(1:35,101))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(62)) * TI2_call(3,momenta_214,masses2_12,G3tensor(:,2),T3sum(1:35,103))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(62)) * TI2_call(3,momenta_214,masses2_12,G3tensor(:,2),T3sum(1:35,103))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(62)) * TI2_call(3,momenta_214,masses2_12,G3tensor(:,2),T3sum(1:35,103))
  M(1) = M(1) + (f(15)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_195,masses2_18,G3tensor(:,141),T3sum(1:35,104))
  M(3) = M(3) + ((-3*f(15))/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_195,masses2_18,G3tensor(:,141),T3sum(1:35,104))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(62)) * TI2_call(3,momenta_195,masses2_18,G3tensor(:,141),T3sum(1:35,104))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(494)) * TI2_call(2,momenta_84,masses2_6,G2tensor(:,30),T2sum(1:15,72))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(494)) * TI2_call(2,momenta_84,masses2_6,G2tensor(:,30),T2sum(1:15,72))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(494)) * TI2_call(2,momenta_50,masses2_7,G2tensor(:,84),T2sum(1:15,73))
  M(3) = M(3) + ((-3*CI*f(13))/4._/**/REALKIND * den(494)) * TI2_call(2,momenta_50,masses2_7,G2tensor(:,84),T2sum(1:15,73))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(72)) * TI2_call(2,momenta_49,masses2_6,G2tensor(:,82),T2sum(1:15,60))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(72)) * TI2_call(2,momenta_49,masses2_6,G2tensor(:,82),T2sum(1:15,60))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(3) = M(3) + (f(19)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,148),T3sum(1:35,97))
  M(3) = M(3) + (f(18)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,148),T3sum(1:35,97))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,148),T3sum(1:35,97))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,150),T3sum(1:35,97))
  M(2) = M(2) + (f(18)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,150),T3sum(1:35,97))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_8,G3tensor(:,150),T3sum(1:35,97))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(3) = M(3) + (f(19)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,147),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,151),T3sum(1:35,98))
  M(3) = M(3) + (f(18)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,151),T3sum(1:35,98))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,151),T3sum(1:35,98))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(4) = M(4) + (-(f(19)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,149),T3sum(1:35,96))
  M(1) = M(1) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,152),T3sum(1:35,98))
  M(2) = M(2) + (f(18)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,152),T3sum(1:35,98))
  M(4) = M(4) + (-(f(18)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_54,masses2_5,G3tensor(:,152),T3sum(1:35,98))
  M(2) = M(2) + ((3*CI*f(13))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,153),T3sum(1:35,96))
  M(3) = M(3) + ((-3*CI*f(13))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,153),T3sum(1:35,96))
  M(2) = M(2) + ((-3*CI*f(13))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,154),T3sum(1:35,96))
  M(3) = M(3) + ((3*CI*f(13))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_54,masses2_10,G3tensor(:,154),T3sum(1:35,96))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(178)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,86),T2sum(1:15,74))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(178)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,86),T2sum(1:15,74))
  M(2) = M(2) + ((-3*f(15))/4._/**/REALKIND * den(178)) * TI2_call(2,momenta_111,masses2_9,G2tensor(:,142),T2sum(1:15,8))
  M(3) = M(3) + ((3*f(15))/4._/**/REALKIND * den(178)) * TI2_call(2,momenta_111,masses2_9,G2tensor(:,142),T2sum(1:15,8))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(177)) * TI2_call(2,momenta_120,masses2_6,G2tensor(:,95),T2sum(1:15,75))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(177)) * TI2_call(2,momenta_120,masses2_6,G2tensor(:,95),T2sum(1:15,75))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(177)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,138),T2sum(1:15,76))
  M(2) = M(2) + ((-3*CI*f(13))/4._/**/REALKIND * den(177)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,138),T2sum(1:15,76))
  M(4) = M(4) + ((CI*f(13))/4._/**/REALKIND * den(328)) * TI2_call(3,momenta_193,masses2_17,G3tensor(:,143),T3sum(1:35,105))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(328)) * TI2_call(3,momenta_229,masses2_12,G3tensor(:,76),T3sum(1:35,107))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(328)) * TI2_call(3,momenta_229,masses2_12,G3tensor(:,76),T3sum(1:35,107))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(328)) * TI2_call(3,momenta_229,masses2_12,G3tensor(:,76),T3sum(1:35,107))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(328)) * TI2_call(3,momenta_231,masses2_12,G3tensor(:,73),T3sum(1:35,109))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(328)) * TI2_call(3,momenta_231,masses2_12,G3tensor(:,73),T3sum(1:35,109))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(328)) * TI2_call(3,momenta_231,masses2_12,G3tensor(:,73),T3sum(1:35,109))
  M(1) = M(1) + (f(15)/4._/**/REALKIND * den(328)) * TI2_call(3,momenta_196,masses2_18,G3tensor(:,142),T3sum(1:35,110))
  M(2) = M(2) + ((-3*f(15))/4._/**/REALKIND * den(328)) * TI2_call(3,momenta_196,masses2_18,G3tensor(:,142),T3sum(1:35,110))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(328)) * TI2_call(3,momenta_196,masses2_18,G3tensor(:,142),T3sum(1:35,110))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(153)) * TI2_call(2,momenta_116,masses2_6,G2tensor(:,46),T2sum(1:15,69))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(153)) * TI2_call(2,momenta_116,masses2_6,G2tensor(:,46),T2sum(1:15,69))
  M(1) = M(1) + (-(CI*f(13))/4._/**/REALKIND * den(153)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,139),T2sum(1:15,70))
  M(3) = M(3) + ((3*CI*f(13))/4._/**/REALKIND * den(153)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,139),T2sum(1:15,70))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(75)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,29),T2sum(1:15,49))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(75)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,29),T2sum(1:15,49))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(69)) * TI2_call(3,momenta_279,masses2_12,G3tensor(:,29),T3sum(1:35,111))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(69)) * TI2_call(3,momenta_279,masses2_12,G3tensor(:,29),T3sum(1:35,111))
  M(1) = M(1) + (-(CI*f(13))/4._/**/REALKIND * den(69)) * TI2_call(3,momenta_197,masses2_17,G3tensor(:,144),T3sum(1:35,112))
  M(3) = M(3) + ((3*CI*f(13))/4._/**/REALKIND * den(69)) * TI2_call(3,momenta_197,masses2_17,G3tensor(:,144),T3sum(1:35,112))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(69)) * TI2_call(3,momenta_281,masses2_12,G3tensor(:,26),T3sum(1:35,113))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(69)) * TI2_call(3,momenta_281,masses2_12,G3tensor(:,26),T3sum(1:35,113))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(76)) * TI2_call(2,momenta_95,masses2_6,G2tensor(:,59),T2sum(1:15,66))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(76)) * TI2_call(2,momenta_95,masses2_6,G2tensor(:,59),T2sum(1:15,66))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(179)) * TI2_call(2,momenta_120,masses2_6,G2tensor(:,100),T2sum(1:15,75))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(179)) * TI2_call(2,momenta_120,masses2_6,G2tensor(:,100),T2sum(1:15,75))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(179)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,140),T2sum(1:15,76))
  M(2) = M(2) + ((-3*CI*f(13))/4._/**/REALKIND * den(179)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,140),T2sum(1:15,76))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(312)) * TI2_call(3,momenta_198,masses2_17,G3tensor(:,145),T3sum(1:35,114))
  M(2) = M(2) + ((-3*CI*f(13))/4._/**/REALKIND * den(312)) * TI2_call(3,momenta_198,masses2_17,G3tensor(:,145),T3sum(1:35,114))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(312)) * TI2_call(3,momenta_295,masses2_12,G3tensor(:,52),T3sum(1:35,115))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(312)) * TI2_call(3,momenta_295,masses2_12,G3tensor(:,52),T3sum(1:35,115))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(312)) * TI2_call(3,momenta_297,masses2_12,G3tensor(:,50),T3sum(1:35,116))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(312)) * TI2_call(3,momenta_297,masses2_12,G3tensor(:,50),T3sum(1:35,116))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(105)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,111),T3sum(1:35,117))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(105)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,111),T3sum(1:35,117))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(105)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,96),T3sum(1:35,118))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(105)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,96),T3sum(1:35,118))
  M(2) = M(2) + ((-3*f(15))/4._/**/REALKIND * den(105)) * TI2_call(3,momenta_310,masses2_17,G3tensor(:,146),T3sum(1:35,4))
  M(3) = M(3) + ((3*f(15))/4._/**/REALKIND * den(105)) * TI2_call(3,momenta_310,masses2_17,G3tensor(:,146),T3sum(1:35,4))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_357,masses2_19,G4tensor(:,18),T4sum(1:70,49))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_357,masses2_19,G4tensor(:,18),T4sum(1:70,49))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_357,masses2_19,G4tensor(:,18),T4sum(1:70,49))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_343,masses2_19,G4tensor(:,22),T4sum(1:70,50))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_343,masses2_19,G4tensor(:,22),T4sum(1:70,50))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_343,masses2_19,G4tensor(:,22),T4sum(1:70,50))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_346,masses2_19,G4tensor(:,11),T4sum(1:70,51))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_346,masses2_19,G4tensor(:,11),T4sum(1:70,51))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_346,masses2_19,G4tensor(:,11),T4sum(1:70,51))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_342,masses2_19,G4tensor(:,23),T4sum(1:70,52))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_342,masses2_19,G4tensor(:,23),T4sum(1:70,52))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_342,masses2_19,G4tensor(:,23),T4sum(1:70,52))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_348,masses2_19,G4tensor(:,9),T4sum(1:70,53))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_348,masses2_19,G4tensor(:,9),T4sum(1:70,53))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_348,masses2_19,G4tensor(:,9),T4sum(1:70,53))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(61)) * TI2_call(4,momenta_359,masses2_19,G4tensor(:,16),T4sum(1:70,54))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(61)) * TI2_call(4,momenta_359,masses2_19,G4tensor(:,16),T4sum(1:70,54))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_359,masses2_19,G4tensor(:,16),T4sum(1:70,54))
  M(1) = M(1) + (f(15)/4._/**/REALKIND * den(61)) * TI2_call(4,momenta_402,masses2_25,G4tensor(:,27),T4sum(1:70,57))
  M(2) = M(2) + ((-3*f(15))/4._/**/REALKIND * den(61)) * TI2_call(4,momenta_402,masses2_25,G4tensor(:,27),T4sum(1:70,57))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(61)) * TI2_call(4,momenta_402,masses2_25,G4tensor(:,27),T4sum(1:70,57))
  M(4) = M(4) + ((CI*f(13))/4._/**/REALKIND * den(61)) * TI2_call(4,momenta_401,masses2_23,G4tensor(:,28),T4sum(1:70,58))
  M(4) = M(4) + ((CI*f(13))/4._/**/REALKIND * den(61)) * TI2_call(4,momenta_400,masses2_23,G4tensor(:,29),T4sum(1:70,60))
  M(2) = M(2) + ((3*CI*f(13))/4._/**/REALKIND * den(77)) * TI2_call(2,momenta_55,masses2_9,G2tensor(:,135),T2sum(1:15,78))
  M(4) = M(4) + (-(CI*f(13))/4._/**/REALKIND * den(77)) * TI2_call(2,momenta_55,masses2_9,G2tensor(:,135),T2sum(1:15,78))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(154)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,16),T2sum(1:15,80))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(154)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,16),T2sum(1:15,80))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(80)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,11),T2sum(1:15,41))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(80)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,11),T2sum(1:15,41))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(155)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,12),T2sum(1:15,71))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(155)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,12),T2sum(1:15,71))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(495)) * TI2_call(2,momenta_210,masses2_14,G2tensor(:,6),T2sum(1:15,84))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(495)) * TI2_call(2,momenta_210,masses2_14,G2tensor(:,6),T2sum(1:15,84))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(170)) * TI2_call(2,momenta_96,masses2_6,G2tensor(:,61),T2sum(1:15,85))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(170)) * TI2_call(2,momenta_96,masses2_6,G2tensor(:,61),T2sum(1:15,85))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(170)) * TI2_call(2,momenta_68,masses2_9,G2tensor(:,17),T2sum(1:15,86))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(170)) * TI2_call(2,momenta_68,masses2_9,G2tensor(:,17),T2sum(1:15,86))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,13),T2sum(1:15,41))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(82)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,13),T2sum(1:15,41))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(315)) * TI2_call(2,momenta_215,masses2_14,G2tensor(:,9),T2sum(1:15,88))
  M(2) = M(2) + (f(15)/6._/**/REALKIND * den(315)) * TI2_call(2,momenta_215,masses2_14,G2tensor(:,9),T2sum(1:15,88))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(315)) * TI2_call(2,momenta_298,masses2_14,G2tensor(:,62),T2sum(1:15,89))
  M(2) = M(2) + ((-7*f(15))/12._/**/REALKIND * den(315)) * TI2_call(2,momenta_298,masses2_14,G2tensor(:,62),T2sum(1:15,89))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(315)) * TI2_call(2,momenta_211,masses2_14,G2tensor(:,7),T2sum(1:15,91))
  M(2) = M(2) + ((5*f(15))/18._/**/REALKIND * den(315)) * TI2_call(2,momenta_211,masses2_14,G2tensor(:,7),T2sum(1:15,91))
  M(3) = M(3) + ((-3*CI*f(13))/4._/**/REALKIND * den(171)) * TI2_call(2,momenta_56,masses2_9,G2tensor(:,136),T2sum(1:15,93))
  M(4) = M(4) + ((CI*f(13))/4._/**/REALKIND * den(171)) * TI2_call(2,momenta_56,masses2_9,G2tensor(:,136),T2sum(1:15,93))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(85)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,14),T2sum(1:15,71))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(85)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,14),T2sum(1:15,71))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(238)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,109),T2sum(1:15,94))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(238)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,109),T2sum(1:15,94))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(236)) * TI2_call(2,momenta_216,masses2_14,G2tensor(:,2),T2sum(1:15,95))
  M(4) = M(4) + (-(f(15)/6._/**/REALKIND) * den(236)) * TI2_call(2,momenta_216,masses2_14,G2tensor(:,2),T2sum(1:15,95))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(236)) * TI2_call(2,momenta_138,masses2_14,G2tensor(:,110),T2sum(1:15,97))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(236)) * TI2_call(2,momenta_138,masses2_14,G2tensor(:,110),T2sum(1:15,97))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(236)) * TI2_call(2,momenta_207,masses2_14,G2tensor(:,15),T2sum(1:15,98))
  M(4) = M(4) + ((-5*f(15))/18._/**/REALKIND * den(236)) * TI2_call(2,momenta_207,masses2_14,G2tensor(:,15),T2sum(1:15,98))
  M(1) = M(1) + (-(f(15)/4._/**/REALKIND) * den(65)) * TI2_call(3,momenta_235,masses2_18,G3tensor(:,138),T3sum(1:35,122))
  M(3) = M(3) + ((-3*f(15))/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_235,masses2_18,G3tensor(:,138),T3sum(1:35,122))
  M(4) = M(4) + (f(15)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_235,masses2_18,G3tensor(:,138),T3sum(1:35,122))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_234,masses2_17,G3tensor(:,139),T3sum(1:35,123))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(436)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,111),T2sum(1:15,94))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(436)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,111),T2sum(1:15,94))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(28)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,114),T3sum(1:35,125))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,114),T3sum(1:35,125))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(28)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,114),T3sum(1:35,125))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(28)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,104),T3sum(1:35,127))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(28)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,104),T3sum(1:35,127))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,104),T3sum(1:35,127))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,21),T3sum(1:35,128))
  M(2) = M(2) + (-(f(15)/4._/**/REALKIND) * den(28)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,21),T3sum(1:35,128))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,21),T3sum(1:35,128))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_245,masses2_17,G3tensor(:,22),T3sum(1:35,129))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(438)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,112),T2sum(1:15,94))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(438)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,112),T2sum(1:15,94))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(135)) * TI2_call(2,momenta_148,masses2_14,G2tensor(:,113),T2sum(1:15,100))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(135)) * TI2_call(2,momenta_148,masses2_14,G2tensor(:,113),T2sum(1:15,100))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(135)) * TI2_call(2,momenta_312,masses2_14,G2tensor(:,20),T2sum(1:15,101))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(135)) * TI2_call(2,momenta_312,masses2_14,G2tensor(:,20),T2sum(1:15,101))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(135)) * TI2_call(2,momenta_311,masses2_14,G2tensor(:,21),T2sum(1:15,102))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(135)) * TI2_call(2,momenta_311,masses2_14,G2tensor(:,21),T2sum(1:15,102))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(23)) * TI2_call(3,momenta_360,masses2_20,G3tensor(:,105),T3sum(1:35,131))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_360,masses2_20,G3tensor(:,105),T3sum(1:35,131))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_360,masses2_20,G3tensor(:,105),T3sum(1:35,131))
  M(2) = M(2) + (-(CI*f(13))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_352,masses2_22,G3tensor(:,112),T3sum(1:35,134))
  M(3) = M(3) + ((-2*CI*f(13))/3._/**/REALKIND * den(23)) * TI2_call(3,momenta_352,masses2_22,G3tensor(:,112),T3sum(1:35,134))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_351,masses2_21,G3tensor(:,113),T3sum(1:35,136))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_351,masses2_21,G3tensor(:,113),T3sum(1:35,136))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(23)) * TI2_call(3,momenta_351,masses2_21,G3tensor(:,113),T3sum(1:35,136))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_408,masses2_20,G3tensor(:,3),T3sum(1:35,138))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_408,masses2_20,G3tensor(:,3),T3sum(1:35,138))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(23)) * TI2_call(3,momenta_408,masses2_20,G3tensor(:,3),T3sum(1:35,138))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_408,masses2_20,G3tensor(:,3),T3sum(1:35,138))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_406,masses2_22,G3tensor(:,7),T3sum(1:35,139))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_406,masses2_22,G3tensor(:,7),T3sum(1:35,139))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_406,masses2_22,G3tensor(:,7),T3sum(1:35,139))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_406,masses2_22,G3tensor(:,7),T3sum(1:35,139))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(23)) * TI2_call(3,momenta_407,masses2_20,G3tensor(:,4),T3sum(1:35,143))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_407,masses2_20,G3tensor(:,4),T3sum(1:35,143))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_407,masses2_20,G3tensor(:,4),T3sum(1:35,143))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(23)) * TI2_call(3,momenta_407,masses2_20,G3tensor(:,4),T3sum(1:35,143))
  M(1) = M(1) + ((CI*f(13))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_404,masses2_22,G3tensor(:,10),T3sum(1:35,144))
  M(2) = M(2) + (-(CI*f(13))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_404,masses2_22,G3tensor(:,10),T3sum(1:35,144))
  M(3) = M(3) + ((CI*f(13))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_404,masses2_22,G3tensor(:,10),T3sum(1:35,144))
  M(4) = M(4) + (-(CI*f(13))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_404,masses2_22,G3tensor(:,10),T3sum(1:35,144))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_405,masses2_21,G3tensor(:,8),T3sum(1:35,145))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(23)) * TI2_call(3,momenta_405,masses2_21,G3tensor(:,8),T3sum(1:35,145))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_405,masses2_21,G3tensor(:,8),T3sum(1:35,145))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_405,masses2_21,G3tensor(:,8),T3sum(1:35,145))
  M(1) = M(1) + (-(f(15)/4._/**/REALKIND) * den(23)) * TI2_call(3,momenta_403,masses2_21,G3tensor(:,11),T3sum(1:35,146))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_403,masses2_21,G3tensor(:,11),T3sum(1:35,146))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_403,masses2_21,G3tensor(:,11),T3sum(1:35,146))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(23)) * TI2_call(3,momenta_403,masses2_21,G3tensor(:,11),T3sum(1:35,146))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(89)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,31),T2sum(1:15,103))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(89)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,31),T2sum(1:15,103))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_58,masses2_9,G2tensor(:,72),T2sum(1:15,104))
  M(3) = M(3) + ((CI*f(13))/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_58,masses2_9,G2tensor(:,72),T2sum(1:15,104))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(157)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,32),T2sum(1:15,105))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(157)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,32),T2sum(1:15,105))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(496)) * TI2_call(2,momenta_277,masses2_14,G2tensor(:,33),T2sum(1:15,110))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(496)) * TI2_call(2,momenta_277,masses2_14,G2tensor(:,33),T2sum(1:15,110))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(180)) * TI2_call(2,momenta_97,masses2_6,G2tensor(:,63),T2sum(1:15,111))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(180)) * TI2_call(2,momenta_97,masses2_6,G2tensor(:,63),T2sum(1:15,111))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(272)) * TI2_call(2,momenta_299,masses2_14,G2tensor(:,64),T2sum(1:15,115))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(272)) * TI2_call(2,momenta_299,masses2_14,G2tensor(:,64),T2sum(1:15,115))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(181)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,73),T2sum(1:15,119))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(181)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,73),T2sum(1:15,119))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(190)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,114),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(190)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,114),T2sum(1:15,120))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(188)) * TI2_call(2,momenta_139,masses2_14,G2tensor(:,115),T2sum(1:15,123))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(188)) * TI2_call(2,momenta_139,masses2_14,G2tensor(:,115),T2sum(1:15,123))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(49)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,64),T3sum(1:35,150))
  M(3) = M(3) + (-(f(15)/4._/**/REALKIND) * den(49)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,64),T3sum(1:35,150))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(49)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,64),T3sum(1:35,150))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(49)) * TI2_call(3,momenta_236,masses2_17,G3tensor(:,65),T3sum(1:35,151))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(444)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,116),T2sum(1:15,120))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(444)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,116),T2sum(1:15,120))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(10)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,117),T3sum(1:35,153))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(10)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,117),T3sum(1:35,153))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(10)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,117),T3sum(1:35,153))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(10)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,106),T3sum(1:35,155))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(10)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,106),T3sum(1:35,155))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(10)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,106),T3sum(1:35,155))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(446)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,117),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(446)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,117),T2sum(1:15,120))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(118)) * TI2_call(2,momenta_149,masses2_14,G2tensor(:,118),T2sum(1:15,126))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(118)) * TI2_call(2,momenta_149,masses2_14,G2tensor(:,118),T2sum(1:15,126))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_361,masses2_20,G3tensor(:,107),T3sum(1:35,159))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_361,masses2_20,G3tensor(:,107),T3sum(1:35,159))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_361,masses2_20,G3tensor(:,107),T3sum(1:35,159))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_354,masses2_22,G3tensor(:,115),T3sum(1:35,162))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(2)) * TI2_call(3,momenta_354,masses2_22,G3tensor(:,115),T3sum(1:35,162))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_353,masses2_21,G3tensor(:,116),T3sum(1:35,164))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_353,masses2_21,G3tensor(:,116),T3sum(1:35,164))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_353,masses2_21,G3tensor(:,116),T3sum(1:35,164))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(172)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,87),T2sum(1:15,62))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(172)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,87),T2sum(1:15,62))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(95)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,35),T2sum(1:15,103))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(95)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,35),T2sum(1:15,103))
  M(1) = M(1) + ((-3*CI*f(13))/4._/**/REALKIND * den(95)) * TI2_call(2,momenta_58,masses2_9,G2tensor(:,92),T2sum(1:15,104))
  M(3) = M(3) + ((CI*f(13))/4._/**/REALKIND * den(95)) * TI2_call(2,momenta_58,masses2_9,G2tensor(:,92),T2sum(1:15,104))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(331)) * TI2_call(2,momenta_282,masses2_14,G2tensor(:,36),T2sum(1:15,129))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(331)) * TI2_call(2,momenta_282,masses2_14,G2tensor(:,36),T2sum(1:15,129))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(331)) * TI2_call(2,momenta_232,masses2_14,G2tensor(:,85),T2sum(1:15,130))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(331)) * TI2_call(2,momenta_232,masses2_14,G2tensor(:,85),T2sum(1:15,130))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(331)) * TI2_call(2,momenta_278,masses2_14,G2tensor(:,34),T2sum(1:15,132))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(331)) * TI2_call(2,momenta_278,masses2_14,G2tensor(:,34),T2sum(1:15,132))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(182)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,88),T2sum(1:15,74))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(182)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,88),T2sum(1:15,74))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(289)) * TI2_call(2,momenta_233,masses2_14,G2tensor(:,80),T2sum(1:15,134))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(289)) * TI2_call(2,momenta_233,masses2_14,G2tensor(:,80),T2sum(1:15,134))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(98)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,89),T2sum(1:15,62))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(98)) * TI2_call(2,momenta_52,masses2_6,G2tensor(:,89),T2sum(1:15,62))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(184)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,93),T2sum(1:15,119))
  M(4) = M(4) + ((3*CI*f(13))/4._/**/REALKIND * den(184)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,93),T2sum(1:15,119))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(183)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,90),T2sum(1:15,74))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(183)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,90),T2sum(1:15,74))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(497)) * TI2_call(2,momenta_227,masses2_14,G2tensor(:,91),T2sum(1:15,140))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(497)) * TI2_call(2,momenta_227,masses2_14,G2tensor(:,91),T2sum(1:15,140))
  M(2) = M(2) + (f(15)/4._/**/REALKIND * den(57)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,88),T3sum(1:35,150))
  M(3) = M(3) + (-(f(15)/4._/**/REALKIND) * den(57)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,88),T3sum(1:35,150))
  M(4) = M(4) + ((3*f(15))/4._/**/REALKIND * den(57)) * TI2_call(3,momenta_237,masses2_18,G3tensor(:,88),T3sum(1:35,150))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(57)) * TI2_call(3,momenta_236,masses2_17,G3tensor(:,89),T3sum(1:35,151))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(166)) * TI2_call(2,momenta_315,masses2_14,G2tensor(:,96),T2sum(1:15,143))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(166)) * TI2_call(2,momenta_315,masses2_14,G2tensor(:,96),T2sum(1:15,143))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(51)) * TI2_call(3,momenta_417,masses2_20,G3tensor(:,74),T3sum(1:35,184))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(51)) * TI2_call(3,momenta_417,masses2_20,G3tensor(:,74),T3sum(1:35,184))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(51)) * TI2_call(3,momenta_417,masses2_20,G3tensor(:,74),T3sum(1:35,184))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND * den(51)) * TI2_call(3,momenta_416,masses2_22,G3tensor(:,77),T3sum(1:35,187))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(51)) * TI2_call(3,momenta_416,masses2_22,G3tensor(:,77),T3sum(1:35,187))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(51)) * TI2_call(3,momenta_415,masses2_21,G3tensor(:,78),T3sum(1:35,189))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(51)) * TI2_call(3,momenta_415,masses2_21,G3tensor(:,78),T3sum(1:35,189))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(51)) * TI2_call(3,momenta_415,masses2_21,G3tensor(:,78),T3sum(1:35,189))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(99)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,37),T2sum(1:15,105))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(99)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,37),T2sum(1:15,105))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(255)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,119),T2sum(1:15,94))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(255)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,119),T2sum(1:15,94))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(254)) * TI2_call(2,momenta_283,masses2_14,G2tensor(:,38),T2sum(1:15,145))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(254)) * TI2_call(2,momenta_283,masses2_14,G2tensor(:,38),T2sum(1:15,145))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(254)) * TI2_call(2,momenta_144,masses2_14,G2tensor(:,120),T2sum(1:15,147))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(254)) * TI2_call(2,momenta_144,masses2_14,G2tensor(:,120),T2sum(1:15,147))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(254)) * TI2_call(2,momenta_275,masses2_14,G2tensor(:,39),T2sum(1:15,148))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(254)) * TI2_call(2,momenta_275,masses2_14,G2tensor(:,39),T2sum(1:15,148))
  M(2) = M(2) + ((CI*f(13))/4._/**/REALKIND * den(100)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,40),T2sum(1:15,80))
  M(4) = M(4) + ((-3*CI*f(13))/4._/**/REALKIND * den(100)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,40),T2sum(1:15,80))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(208)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,121),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(208)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,121),T2sum(1:15,120))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(207)) * TI2_call(2,momenta_145,masses2_14,G2tensor(:,122),T2sum(1:15,151))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(207)) * TI2_call(2,momenta_145,masses2_14,G2tensor(:,122),T2sum(1:15,151))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(102)) * TI2_call(2,momenta_96,masses2_6,G2tensor(:,65),T2sum(1:15,85))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(102)) * TI2_call(2,momenta_96,masses2_6,G2tensor(:,65),T2sum(1:15,85))
  M(1) = M(1) + ((3*CI*f(13))/4._/**/REALKIND * den(102)) * TI2_call(2,momenta_68,masses2_9,G2tensor(:,41),T2sum(1:15,86))
  M(2) = M(2) + (-(CI*f(13))/4._/**/REALKIND * den(102)) * TI2_call(2,momenta_68,masses2_9,G2tensor(:,41),T2sum(1:15,86))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(186)) * TI2_call(2,momenta_97,masses2_6,G2tensor(:,66),T2sum(1:15,111))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(186)) * TI2_call(2,momenta_97,masses2_6,G2tensor(:,66),T2sum(1:15,111))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(498)) * TI2_call(2,momenta_293,masses2_14,G2tensor(:,67),T2sum(1:15,156))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(498)) * TI2_call(2,momenta_293,masses2_14,G2tensor(:,67),T2sum(1:15,156))
  M(1) = M(1) + (-(CI*f(13))/12._/**/REALKIND * den(458)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,123),T2sum(1:15,94))
  M(4) = M(4) + ((CI*f(13))/12._/**/REALKIND * den(458)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,123),T2sum(1:15,94))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(38)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,120),T3sum(1:35,125))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(38)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,120),T3sum(1:35,125))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(38)) * TI2_call(3,momenta_140,masses2_12,G3tensor(:,120),T3sum(1:35,125))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(38)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,108),T3sum(1:35,127))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(38)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,108),T3sum(1:35,127))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(38)) * TI2_call(3,momenta_142,masses2_12,G3tensor(:,108),T3sum(1:35,127))
  M(1) = M(1) + ((3*f(15))/4._/**/REALKIND * den(38)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,41),T3sum(1:35,128))
  M(2) = M(2) + (-(f(15)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,41),T3sum(1:35,128))
  M(3) = M(3) + (f(15)/4._/**/REALKIND * den(38)) * TI2_call(3,momenta_246,masses2_18,G3tensor(:,41),T3sum(1:35,128))
  M(3) = M(3) + (-(CI*f(13))/4._/**/REALKIND * den(38)) * TI2_call(3,momenta_245,masses2_17,G3tensor(:,42),T3sum(1:35,129))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(459)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,124),T2sum(1:15,94))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(459)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,124),T2sum(1:15,94))
  M(2) = M(2) + ((CI*f(13))/12._/**/REALKIND * den(461)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,125),T2sum(1:15,120))
  M(3) = M(3) + (-(CI*f(13))/12._/**/REALKIND * den(461)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,125),T2sum(1:15,120))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(19)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,121),T3sum(1:35,153))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(19)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,121),T3sum(1:35,153))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(19)) * TI2_call(3,momenta_141,masses2_12,G3tensor(:,121),T3sum(1:35,153))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(19)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,109),T3sum(1:35,155))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(19)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,109),T3sum(1:35,155))
  M(4) = M(4) + (-(f(15)/4._/**/REALKIND) * den(19)) * TI2_call(3,momenta_143,masses2_12,G3tensor(:,109),T3sum(1:35,155))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(462)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,126),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(462)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,126),T2sum(1:15,120))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(160)) * TI2_call(2,momenta_135,masses2_14,G2tensor(:,127),T2sum(1:15,160))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(160)) * TI2_call(2,momenta_135,masses2_14,G2tensor(:,127),T2sum(1:15,160))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_337,masses2_21,G3tensor(:,122),T3sum(1:35,197))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_337,masses2_21,G3tensor(:,122),T3sum(1:35,197))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_337,masses2_21,G3tensor(:,122),T3sum(1:35,197))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_338,masses2_22,G3tensor(:,123),T3sum(1:35,201))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(13)) * TI2_call(3,momenta_338,masses2_22,G3tensor(:,123),T3sum(1:35,201))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_355,masses2_20,G3tensor(:,110),T3sum(1:35,202))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_355,masses2_20,G3tensor(:,110),T3sum(1:35,202))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_355,masses2_20,G3tensor(:,110),T3sum(1:35,202))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(128)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,125),T3sum(1:35,94))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(128)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,125),T3sum(1:35,94))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(128)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,97),T3sum(1:35,95))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(128)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,97),T3sum(1:35,95))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND) * den(468)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,129),T2sum(1:15,94))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(468)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,129),T2sum(1:15,94))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(138)) * TI2_call(2,momenta_148,masses2_14,G2tensor(:,130),T2sum(1:15,100))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(138)) * TI2_call(2,momenta_148,masses2_14,G2tensor(:,130),T2sum(1:15,100))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(138)) * TI2_call(2,momenta_312,masses2_14,G2tensor(:,47),T2sum(1:15,101))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(138)) * TI2_call(2,momenta_312,masses2_14,G2tensor(:,47),T2sum(1:15,101))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(138)) * TI2_call(2,momenta_311,masses2_14,G2tensor(:,48),T2sum(1:15,102))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(138)) * TI2_call(2,momenta_311,masses2_14,G2tensor(:,48),T2sum(1:15,102))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(33)) * TI2_call(3,momenta_349,masses2_20,G3tensor(:,98),T3sum(1:35,207))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_349,masses2_20,G3tensor(:,98),T3sum(1:35,207))
  M(1) = M(1) + (-(f(15)/36._/**/REALKIND) * den(33)) * TI2_call(3,momenta_362,masses2_21,G3tensor(:,118),T3sum(1:35,209))
  M(3) = M(3) + ((-7*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_362,masses2_21,G3tensor(:,118),T3sum(1:35,209))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(33)) * TI2_call(3,momenta_452,masses2_20,G3tensor(:,27),T3sum(1:35,210))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(33)) * TI2_call(3,momenta_452,masses2_20,G3tensor(:,27),T3sum(1:35,210))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(33)) * TI2_call(3,momenta_451,masses2_20,G3tensor(:,28),T3sum(1:35,212))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(33)) * TI2_call(3,momenta_451,masses2_20,G3tensor(:,28),T3sum(1:35,212))
  M(1) = M(1) + (-(f(15)/6._/**/REALKIND) * den(33)) * TI2_call(3,momenta_450,masses2_21,G3tensor(:,30),T3sum(1:35,213))
  M(3) = M(3) + ((5*f(15))/18._/**/REALKIND * den(33)) * TI2_call(3,momenta_450,masses2_21,G3tensor(:,30),T3sum(1:35,213))
  M(1) = M(1) + ((-5*f(15))/18._/**/REALKIND * den(33)) * TI2_call(3,momenta_449,masses2_21,G3tensor(:,31),T3sum(1:35,214))
  M(3) = M(3) + (f(15)/6._/**/REALKIND * den(33)) * TI2_call(3,momenta_449,masses2_21,G3tensor(:,31),T3sum(1:35,214))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(110)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,126),T3sum(1:35,117))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(110)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,126),T3sum(1:35,117))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(110)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,99),T3sum(1:35,118))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(110)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,99),T3sum(1:35,118))
  M(2) = M(2) + (f(15)/12._/**/REALKIND * den(474)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,131),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(474)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,131),T2sum(1:15,120))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(120)) * TI2_call(2,momenta_149,masses2_14,G2tensor(:,132),T2sum(1:15,126))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(120)) * TI2_call(2,momenta_149,masses2_14,G2tensor(:,132),T2sum(1:15,126))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(12)) * TI2_call(3,momenta_350,masses2_20,G3tensor(:,100),T3sum(1:35,215))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(12)) * TI2_call(3,momenta_350,masses2_20,G3tensor(:,100),T3sum(1:35,215))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(12)) * TI2_call(3,momenta_363,masses2_21,G3tensor(:,119),T3sum(1:35,217))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(12)) * TI2_call(3,momenta_363,masses2_21,G3tensor(:,119),T3sum(1:35,217))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(168)) * TI2_call(2,momenta_315,masses2_14,G2tensor(:,101),T2sum(1:15,143))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(168)) * TI2_call(2,momenta_315,masses2_14,G2tensor(:,101),T2sum(1:15,143))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(43)) * TI2_call(3,momenta_458,masses2_20,G3tensor(:,51),T3sum(1:35,228))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(43)) * TI2_call(3,momenta_458,masses2_20,G3tensor(:,51),T3sum(1:35,228))
  M(1) = M(1) + ((7*f(15))/12._/**/REALKIND * den(43)) * TI2_call(3,momenta_457,masses2_21,G3tensor(:,53),T3sum(1:35,230))
  M(2) = M(2) + (f(15)/36._/**/REALKIND * den(43)) * TI2_call(3,momenta_457,masses2_21,G3tensor(:,53),T3sum(1:35,230))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(93)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,127),T3sum(1:35,94))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(93)) * TI2_call(3,momenta_146,masses2_12,G3tensor(:,127),T3sum(1:35,94))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(93)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,101),T3sum(1:35,95))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(93)) * TI2_call(3,momenta_136,masses2_12,G3tensor(:,101),T3sum(1:35,95))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(484)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,133),T2sum(1:15,94))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND) * den(484)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,133),T2sum(1:15,94))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(84)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,128),T3sum(1:35,117))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(84)) * TI2_call(3,momenta_147,masses2_12,G3tensor(:,128),T3sum(1:35,117))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(84)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,102),T3sum(1:35,118))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(84)) * TI2_call(3,momenta_137,masses2_12,G3tensor(:,102),T3sum(1:35,118))
  M(3) = M(3) + (f(15)/12._/**/REALKIND * den(486)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,134),T2sum(1:15,120))
  M(4) = M(4) + (-(f(15)/36._/**/REALKIND) * den(486)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,134),T2sum(1:15,120))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(162)) * TI2_call(2,momenta_135,masses2_14,G2tensor(:,128),T2sum(1:15,160))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(162)) * TI2_call(2,momenta_135,masses2_14,G2tensor(:,128),T2sum(1:15,160))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(3)) * TI2_call(3,momenta_339,masses2_21,G3tensor(:,124),T3sum(1:35,235))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(3)) * TI2_call(3,momenta_339,masses2_21,G3tensor(:,124),T3sum(1:35,235))
  M(3) = M(3) + (f(15)/36._/**/REALKIND * den(3)) * TI2_call(3,momenta_344,masses2_20,G3tensor(:,103),T3sum(1:35,237))
  M(4) = M(4) + ((7*f(15))/12._/**/REALKIND * den(3)) * TI2_call(3,momenta_344,masses2_20,G3tensor(:,103),T3sum(1:35,237))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_484,masses2_26,G4tensor(:,17),T4sum(1:70,79))
  M(2) = M(2) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_484,masses2_26,G4tensor(:,17),T4sum(1:70,79))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_484,masses2_26,G4tensor(:,17),T4sum(1:70,79))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_482,masses2_26,G4tensor(:,10),T4sum(1:70,80))
  M(2) = M(2) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_482,masses2_26,G4tensor(:,10),T4sum(1:70,80))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_482,masses2_26,G4tensor(:,10),T4sum(1:70,80))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND) * TI2_call(4,momenta_481,masses2_28,G4tensor(:,12),T4sum(1:70,81))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND) * TI2_call(4,momenta_481,masses2_28,G4tensor(:,12),T4sum(1:70,81))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_478,masses2_29,G4tensor(:,25),T4sum(1:70,83))
  M(3) = M(3) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_478,masses2_29,G4tensor(:,25),T4sum(1:70,83))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_478,masses2_29,G4tensor(:,25),T4sum(1:70,83))
  M(1) = M(1) + ((CI*f(13))/12._/**/REALKIND) * TI2_call(4,momenta_479,masses2_30,G4tensor(:,24),T4sum(1:70,84))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND) * TI2_call(4,momenta_479,masses2_30,G4tensor(:,24),T4sum(1:70,84))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_483,masses2_27,G4tensor(:,19),T4sum(1:70,85))
  M(2) = M(2) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_483,masses2_27,G4tensor(:,19),T4sum(1:70,85))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_483,masses2_27,G4tensor(:,19),T4sum(1:70,85))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_477,masses2_29,G4tensor(:,26),T4sum(1:70,86))
  M(3) = M(3) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_477,masses2_29,G4tensor(:,26),T4sum(1:70,86))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_477,masses2_29,G4tensor(:,26),T4sum(1:70,86))
  M(1) = M(1) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_480,masses2_27,G4tensor(:,13),T4sum(1:70,88))
  M(3) = M(3) + (f(15)/36._/**/REALKIND) * TI2_call(4,momenta_480,masses2_27,G4tensor(:,13),T4sum(1:70,88))
  M(4) = M(4) + (-(f(15)/12._/**/REALKIND)) * TI2_call(4,momenta_480,masses2_27,G4tensor(:,13),T4sum(1:70,88))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(235)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,14),T1sum(1:5,8))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(235)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,14),T1sum(1:5,8))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_6,masses2_4,G2tensor(:,24),T2sum(1:15,164))
  M(4) = M(4) + ((3*CI*f(12))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_6,masses2_4,G2tensor(:,24),T2sum(1:15,164))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(249)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,1),T1sum(1:5,9))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(249)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,1),T1sum(1:5,9))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(513)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,17),T1sum(1:5,8))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(513)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,17),T1sum(1:5,8))
  M(1) = M(1) + ((-2*CI*f(13))/3._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,18),T1sum(1:5,8))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_2,G1tensor(:,18),T1sum(1:5,8))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(258)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,13),T1sum(1:5,5))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(258)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,13),T1sum(1:5,5))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(253)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,3),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(253)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,3),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(515)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,15),T1sum(1:5,5))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(515)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,15),T1sum(1:5,5))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(262)) * TI2_call(2,momenta_6,masses2_4,G2tensor(:,25),T2sum(1:15,164))
  M(4) = M(4) + ((3*CI*f(12))/2._/**/REALKIND * den(262)) * TI2_call(2,momenta_6,masses2_4,G2tensor(:,25),T2sum(1:15,164))
  M(1) = M(1) + ((-2*CI*f(13))/3._/**/REALKIND * den(517)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,16),T1sum(1:5,5))
  M(4) = M(4) + ((2*CI*f(13))/3._/**/REALKIND * den(517)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,16),T1sum(1:5,5))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(268)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,11),T1sum(1:5,9))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(268)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,11),T1sum(1:5,9))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(520)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,4),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(520)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,4),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(281)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,19),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(281)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,19),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(278)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,32),T1sum(1:5,3))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(278)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,32),T1sum(1:5,3))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(523)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,34),T1sum(1:5,3))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(523)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,34),T1sum(1:5,3))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(288)) * TI2_call(2,momenta_9,masses2_4,G2tensor(:,70),T2sum(1:15,166))
  M(4) = M(4) + ((-3*CI*f(12))/2._/**/REALKIND * den(288)) * TI2_call(2,momenta_9,masses2_4,G2tensor(:,70),T2sum(1:15,166))
  M(1) = M(1) + ((2*CI*f(13))/3._/**/REALKIND * den(524)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,36),T1sum(1:5,3))
  M(4) = M(4) + ((-2*CI*f(13))/3._/**/REALKIND * den(524)) * TI2_call(1,momenta_12,masses2_2,G1tensor(:,36),T1sum(1:5,3))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(297)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,29),T1sum(1:5,12))
  M(4) = M(4) + ((2*f(15))/3._/**/REALKIND * den(297)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,29),T1sum(1:5,12))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(527)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,33),T1sum(1:5,12))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(527)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,33),T1sum(1:5,12))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(302)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,27),T1sum(1:5,13))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(302)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,27),T1sum(1:5,13))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(303)) * TI2_call(2,momenta_9,masses2_4,G2tensor(:,71),T2sum(1:15,166))
  M(4) = M(4) + ((-3*CI*f(12))/2._/**/REALKIND * den(303)) * TI2_call(2,momenta_9,masses2_4,G2tensor(:,71),T2sum(1:15,166))
  M(1) = M(1) + ((2*CI*f(13))/3._/**/REALKIND * den(528)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,35),T1sum(1:5,12))
  M(4) = M(4) + ((-2*CI*f(13))/3._/**/REALKIND * den(528)) * TI2_call(1,momenta_11,masses2_2,G1tensor(:,35),T1sum(1:5,12))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(533)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,20),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(533)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,20),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(309)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,30),T1sum(1:5,13))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(309)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,30),T1sum(1:5,13))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(320)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,21),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(320)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,21),T1sum(1:5,11))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(326)) * TI2_call(2,momenta_10,masses2_4,G2tensor(:,143),T2sum(1:15,168))
  M(3) = M(3) + ((3*CI*f(12))/2._/**/REALKIND * den(326)) * TI2_call(2,momenta_10,masses2_4,G2tensor(:,143),T2sum(1:15,168))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(327)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,2),T1sum(1:5,9))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(327)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,2),T1sum(1:5,9))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(330)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,5),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(330)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,5),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(338)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,28),T1sum(1:5,13))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(338)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,28),T1sum(1:5,13))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(339)) * TI2_call(2,momenta_10,masses2_4,G2tensor(:,144),T2sum(1:15,168))
  M(3) = M(3) + ((3*CI*f(12))/2._/**/REALKIND * den(339)) * TI2_call(2,momenta_10,masses2_4,G2tensor(:,144),T2sum(1:15,168))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(344)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,12),T1sum(1:5,9))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(344)) * TI2_call(1,momenta_14,masses2_2,G1tensor(:,12),T1sum(1:5,9))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(544)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,6),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(544)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,6),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(545)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,22),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(545)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,22),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(346)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,31),T1sum(1:5,13))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(346)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,31),T1sum(1:5,13))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(551)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,23),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(551)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,23),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(557)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,7),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(557)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,7),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(558)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,8),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(558)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,8),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(560)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,24),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(560)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,24),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(564)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,9),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/9._/**/REALKIND * den(564)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,9),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(572)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,10),T1sum(1:5,10))
  M(3) = M(3) + ((-2*f(15))/3._/**/REALKIND * den(572)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,10),T1sum(1:5,10))
  M(1) = M(1) + ((2*f(15))/3._/**/REALKIND * den(576)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,25),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/9._/**/REALKIND * den(576)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,25),T1sum(1:5,11))
  M(1) = M(1) + ((2*f(15))/9._/**/REALKIND * den(578)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,26),T1sum(1:5,11))
  M(2) = M(2) + ((-2*f(15))/3._/**/REALKIND * den(578)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,26),T1sum(1:5,11))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_3_pphjjj2_bbbxbxhg_1_/**/REALKIND
