
module ol_vamp_2_pphjjj2_hggggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G6tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,4) :: G0
  complex(REALKIND), dimension(4,5,4,183) :: G1
  complex(REALKIND), dimension(4,15,4,456) :: G2
  complex(REALKIND), dimension(4,35,4,306) :: G3
  complex(REALKIND), dimension(4,70,4,140) :: G4
  complex(REALKIND), dimension(4,126,4,48) :: G5
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
  complex(REALKIND), pointer :: G6tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,135,32))
    allocate(G4tensorhel(70,95,32))
    allocate(G5tensorhel(126,46,32))
    allocate(G6tensorhel(210,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)
  G6tensor => G6tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,8),MB,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,211),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,62),MB,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,212),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,62),MB,G2(:,:,:,3))
  call loop_QS_A(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,213),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,62),MB,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,250),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,62),MB,G2(:,:,:,7))
  call loop_QS_A(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,251),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,62),MB,G2(:,:,:,9))
  call loop_QS_A(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,252),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,62),MB,G2(:,:,:,11))
  call loop_QS_A(G2(:,:,:,11),wf(:,0),G2(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,256),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,62),MB,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,257),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,62),MB,G2(:,:,:,15))
  call loop_QS_A(G2(:,:,:,15),wf(:,0),G2(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,258),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,62),MB,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,262),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,62),MB,G2(:,:,:,19))
  call loop_QS_A(G2(:,:,:,19),wf(:,0),G2(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,263),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,62),MB,G2(:,:,:,21))
  call loop_QS_A(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,264),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,62),MB,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,0),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,-1),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,10),MB,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,19),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,62),MB,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,21),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,62),MB,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MB,G4tensor(:,2))
  call loop_QV_A(G2(:,:,:,25),wf(:,22),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,62),MB,G3(:,:,:,5))
  call loop_QS_A(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_QV_A(G2(:,:,:,25),wf(:,175),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,62),MB,G3(:,:,:,7))
  call loop_QS_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_QV_A(G2(:,:,:,25),wf(:,76),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,30),MB,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_Q_A(G3(:,:,:,10),Q(:,62),MB,G4(:,:,:,1))
  call loop_QS_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,63),MB,G5tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,-5),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,42),MB,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,76),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,62),MB,G4(:,:,:,3))
  call loop_QS_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,63),MB,G5tensor(:,2))
  call loop_QV_A(G3(:,:,:,11),wf(:,-2),G3(:,:,:,13))
  call loop_Q_A(G3(:,:,:,13),Q(:,46),MB,G4(:,:,:,5))
  call loop_QV_A(G4(:,:,:,5),wf(:,-4),G4(:,:,:,6))
  call loop_Q_A(G4(:,:,:,6),Q(:,62),MB,G5(:,:,:,1))
  call loop_QS_A(G5(:,:,:,1),wf(:,0),G5(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,2),Q(:,63),MB,G6tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,178),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,62),MB,G3(:,:,:,14))
  call loop_QS_A(G3(:,:,:,14),wf(:,0),G3(:,:,:,15),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),MB,G4tensor(:,5))
  call loop_QV_A(G2(:,:,:,25),wf(:,84),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,46),MB,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,-4),G3(:,:,:,17))
  call loop_Q_A(G3(:,:,:,17),Q(:,62),MB,G4(:,:,:,7))
  call loop_QS_A(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,63),MB,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,25),wf(:,-4),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,26),MB,G3(:,:,:,18))
  call loop_QV_A(G3(:,:,:,18),wf(:,84),G3(:,:,:,19))
  call loop_Q_A(G3(:,:,:,19),Q(:,62),MB,G4(:,:,:,9))
  call loop_QS_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MB,G5tensor(:,4))
  call loop_QV_A(G3(:,:,:,18),wf(:,-2),G3(:,:,:,20))
  call loop_Q_A(G3(:,:,:,20),Q(:,30),MB,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,-5),G4(:,:,:,12))
  call loop_Q_A(G4(:,:,:,12),Q(:,62),MB,G5(:,:,:,3))
  call loop_QS_A(G5(:,:,:,3),wf(:,0),G5(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,4),Q(:,63),MB,G6tensor(:,2))
  call loop_QV_A(G2(:,:,:,25),wf(:,180),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,62),MB,G3(:,:,:,21))
  call loop_QS_A(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,25),wf(:,-2),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,14),MB,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,119),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,62),MB,G4(:,:,:,13))
  call loop_QS_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MB,G5tensor(:,5))
  call loop_QV_A(G3(:,:,:,23),wf(:,-5),G3(:,:,:,25))
  call loop_Q_A(G3(:,:,:,25),Q(:,46),MB,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,-4),G4(:,:,:,16))
  call loop_Q_A(G4(:,:,:,16),Q(:,62),MB,G5(:,:,:,5))
  call loop_QS_A(G5(:,:,:,5),wf(:,0),G5(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,6),Q(:,63),MB,G6tensor(:,3))
  call loop_QV_A(G3(:,:,:,23),wf(:,-4),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,30),MB,G4(:,:,:,17))
  call loop_QV_A(G4(:,:,:,17),wf(:,-5),G4(:,:,:,18))
  call loop_Q_A(G4(:,:,:,18),Q(:,62),MB,G5(:,:,:,7))
  call loop_QS_A(G5(:,:,:,7),wf(:,0),G5(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,8),Q(:,63),MB,G6tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,295),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,62),MB,G2(:,:,:,37))
  call loop_QS_A(G2(:,:,:,37),wf(:,0),G2(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,296),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,62),MB,G2(:,:,:,39))
  call loop_QS_A(G2(:,:,:,39),wf(:,0),G2(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,297),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,62),MB,G2(:,:,:,41))
  call loop_QS_A(G2(:,:,:,41),wf(:,0),G2(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,301),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,62),MB,G2(:,:,:,43))
  call loop_QS_A(G2(:,:,:,43),wf(:,0),G2(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),MB,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,302),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,62),MB,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,0),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,303),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,62),MB,G2(:,:,:,47))
  call loop_QS_A(G2(:,:,:,47),wf(:,0),G2(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),MB,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,307),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,62),MB,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,0),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,308),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,62),MB,G2(:,:,:,51))
  call loop_QS_A(G2(:,:,:,51),wf(:,0),G2(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,309),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,62),MB,G2(:,:,:,53))
  call loop_QS_A(G2(:,:,:,53),wf(:,0),G2(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,12),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,66),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,62),MB,G3(:,:,:,27))
  call loop_QS_A(G3(:,:,:,27),wf(:,0),G3(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,7))
  call loop_QV_A(G2(:,:,:,55),wf(:,68),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,62),MB,G3(:,:,:,29))
  call loop_QS_A(G3(:,:,:,29),wf(:,0),G3(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,55),wf(:,69),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,62),MB,G3(:,:,:,31))
  call loop_QS_A(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,9))
  call loop_QV_A(G2(:,:,:,55),wf(:,184),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,62),MB,G3(:,:,:,33))
  call loop_QS_A(G3(:,:,:,33),wf(:,0),G3(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),MB,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,55),wf(:,29),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,30),MB,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-5),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,62),MB,G4(:,:,:,19))
  call loop_QS_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,6))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,61))
  call loop_Q_A(G2(:,:,:,61),Q(:,44),MB,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,29),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,62),MB,G4(:,:,:,21))
  call loop_QS_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,7))
  call loop_QV_A(G3(:,:,:,37),wf(:,-1),G3(:,:,:,39))
  call loop_Q_A(G3(:,:,:,39),Q(:,46),MB,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,-4),G4(:,:,:,24))
  call loop_Q_A(G4(:,:,:,24),Q(:,62),MB,G5(:,:,:,9))
  call loop_QS_A(G5(:,:,:,9),wf(:,0),G5(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,10),Q(:,63),MB,G6tensor(:,5))
  call loop_QV_A(G2(:,:,:,55),wf(:,187),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,62),MB,G3(:,:,:,40))
  call loop_QS_A(G3(:,:,:,40),wf(:,0),G3(:,:,:,41),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,41),Q(:,63),MB,G4tensor(:,11))
  call loop_QV_A(G2(:,:,:,55),wf(:,37),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,46),MB,G3(:,:,:,42))
  call loop_QV_A(G3(:,:,:,42),wf(:,-4),G3(:,:,:,43))
  call loop_Q_A(G3(:,:,:,43),Q(:,62),MB,G4(:,:,:,25))
  call loop_QS_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MB,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,55),wf(:,-4),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,28),MB,G3(:,:,:,44))
  call loop_QV_A(G3(:,:,:,44),wf(:,37),G3(:,:,:,45))
  call loop_Q_A(G3(:,:,:,45),Q(:,62),MB,G4(:,:,:,27))
  call loop_QS_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,9))
  call loop_QV_A(G3(:,:,:,44),wf(:,-1),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),MB,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,-5),G4(:,:,:,30))
  call loop_Q_A(G4(:,:,:,30),Q(:,62),MB,G5(:,:,:,11))
  call loop_QS_A(G5(:,:,:,11),wf(:,0),G5(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,12),Q(:,63),MB,G6tensor(:,6))
  call loop_QV_A(G2(:,:,:,55),wf(:,188),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,62),MB,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,55),wf(:,-1),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,14),MB,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,119),G3(:,:,:,50))
  call loop_Q_A(G3(:,:,:,50),Q(:,62),MB,G4(:,:,:,31))
  call loop_QS_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,10))
  call loop_QV_A(G3(:,:,:,49),wf(:,-5),G3(:,:,:,51))
  call loop_Q_A(G3(:,:,:,51),Q(:,46),MB,G4(:,:,:,33))
  call loop_QV_A(G4(:,:,:,33),wf(:,-4),G4(:,:,:,34))
  call loop_Q_A(G4(:,:,:,34),Q(:,62),MB,G5(:,:,:,13))
  call loop_QS_A(G5(:,:,:,13),wf(:,0),G5(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,14),Q(:,63),MB,G6tensor(:,7))
  call loop_QV_A(G3(:,:,:,49),wf(:,-4),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,30),MB,G4(:,:,:,35))
  call loop_QV_A(G4(:,:,:,35),wf(:,-5),G4(:,:,:,36))
  call loop_Q_A(G4(:,:,:,36),Q(:,62),MB,G5(:,:,:,15))
  call loop_QS_A(G5(:,:,:,15),wf(:,0),G5(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,16),Q(:,63),MB,G6tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,340),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,62),MB,G2(:,:,:,67))
  call loop_QS_A(G2(:,:,:,67),wf(:,0),G2(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,1),wf(:,341),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,62),MB,G2(:,:,:,69))
  call loop_QS_A(G2(:,:,:,69),wf(:,0),G2(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,1),wf(:,342),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,62),MB,G2(:,:,:,71))
  call loop_QS_A(G2(:,:,:,71),wf(:,0),G2(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,1),wf(:,346),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,62),MB,G2(:,:,:,73))
  call loop_QS_A(G2(:,:,:,73),wf(:,0),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,1),wf(:,347),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,62),MB,G2(:,:,:,75))
  call loop_QS_A(G2(:,:,:,75),wf(:,0),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,1),wf(:,348),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,62),MB,G2(:,:,:,77))
  call loop_QS_A(G2(:,:,:,77),wf(:,0),G2(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,1),wf(:,102),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,46),MB,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,62),MB,G3(:,:,:,53))
  call loop_QS_A(G3(:,:,:,53),wf(:,0),G3(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),MB,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,104),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,46),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,62),MB,G3(:,:,:,55))
  call loop_QS_A(G3(:,:,:,55),wf(:,0),G3(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,63),MB,G4tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,105),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,46),MB,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,62),MB,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,0),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MB,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,24),MB,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,102),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,62),MB,G3(:,:,:,59))
  call loop_QS_A(G3(:,:,:,59),wf(:,0),G3(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MB,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,85),wf(:,104),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,62),MB,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,0),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MB,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,85),wf(:,105),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,62),MB,G3(:,:,:,63))
  call loop_QS_A(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,85),wf(:,167),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,62),MB,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MB,G4tensor(:,19))
  call loop_QV_A(G2(:,:,:,85),wf(:,1),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,30),MB,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,62),MB,G4(:,:,:,37))
  call loop_QS_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MB,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,85),wf(:,200),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,62),MB,G3(:,:,:,69))
  call loop_QS_A(G3(:,:,:,69),wf(:,0),G3(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,63),MB,G4tensor(:,20))
  call loop_QV_A(G2(:,:,:,85),wf(:,-2),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,28),MB,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,37),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,62),MB,G4(:,:,:,39))
  call loop_QS_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MB,G5tensor(:,12))
  call loop_QV_A(G3(:,:,:,71),wf(:,-1),G3(:,:,:,73))
  call loop_Q_A(G3(:,:,:,73),Q(:,30),MB,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,-5),G4(:,:,:,42))
  call loop_Q_A(G4(:,:,:,42),Q(:,62),MB,G5(:,:,:,17))
  call loop_QS_A(G5(:,:,:,17),wf(:,0),G5(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,18),Q(:,63),MB,G6tensor(:,9))
  call loop_QV_A(G2(:,:,:,85),wf(:,202),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,62),MB,G3(:,:,:,74))
  call loop_QS_A(G3(:,:,:,74),wf(:,0),G3(:,:,:,75),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,63),MB,G4tensor(:,21))
  call loop_QV_A(G2(:,:,:,85),wf(:,-1),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,26),MB,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,84),G3(:,:,:,77))
  call loop_Q_A(G3(:,:,:,77),Q(:,62),MB,G4(:,:,:,43))
  call loop_QS_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,63),MB,G5tensor(:,13))
  call loop_QV_A(G3(:,:,:,76),wf(:,-2),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),MB,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,-5),G4(:,:,:,46))
  call loop_Q_A(G4(:,:,:,46),Q(:,62),MB,G5(:,:,:,19))
  call loop_QS_A(G5(:,:,:,19),wf(:,0),G5(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,20),Q(:,63),MB,G6tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,352),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,62),MB,G2(:,:,:,95))
  call loop_QS_A(G2(:,:,:,95),wf(:,0),G2(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,1),wf(:,353),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,62),MB,G2(:,:,:,97))
  call loop_QS_A(G2(:,:,:,97),wf(:,0),G2(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,63),MB,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,1),wf(:,354),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,62),MB,G2(:,:,:,99))
  call loop_QS_A(G2(:,:,:,99),wf(:,0),G2(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,1),wf(:,110),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,30),MB,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,62),MB,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,0),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),MB,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,1),wf(:,112),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,30),MB,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,-5),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,62),MB,G3(:,:,:,81))
  call loop_QS_A(G3(:,:,:,81),wf(:,0),G3(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,1),wf(:,113),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,30),MB,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,62),MB,G3(:,:,:,83))
  call loop_QS_A(G3(:,:,:,83),wf(:,0),G3(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,40),MB,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,110),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,62),MB,G3(:,:,:,85))
  call loop_QS_A(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),MB,G4tensor(:,25))
  call loop_QV_A(G2(:,:,:,107),wf(:,112),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,62),MB,G3(:,:,:,87))
  call loop_QS_A(G3(:,:,:,87),wf(:,0),G3(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,107),wf(:,113),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,62),MB,G3(:,:,:,89))
  call loop_QS_A(G3(:,:,:,89),wf(:,0),G3(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,63),MB,G4tensor(:,27))
  call loop_QV_A(G2(:,:,:,107),wf(:,170),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,62),MB,G3(:,:,:,91))
  call loop_QS_A(G3(:,:,:,91),wf(:,0),G3(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),MB,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,107),wf(:,1),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,46),MB,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-4),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,62),MB,G4(:,:,:,47))
  call loop_QS_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,63),MB,G5tensor(:,14))
  call loop_QV_A(G2(:,:,:,107),wf(:,194),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,62),MB,G3(:,:,:,95))
  call loop_QS_A(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MB,G4tensor(:,29))
  call loop_QV_A(G2(:,:,:,107),wf(:,-2),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,44),MB,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,29),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,62),MB,G4(:,:,:,49))
  call loop_QS_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MB,G5tensor(:,15))
  call loop_QV_A(G3(:,:,:,97),wf(:,-1),G3(:,:,:,99))
  call loop_Q_A(G3(:,:,:,99),Q(:,46),MB,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,-4),G4(:,:,:,52))
  call loop_Q_A(G4(:,:,:,52),Q(:,62),MB,G5(:,:,:,21))
  call loop_QS_A(G5(:,:,:,21),wf(:,0),G5(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,22),Q(:,63),MB,G6tensor(:,11))
  call loop_QV_A(G2(:,:,:,107),wf(:,198),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,62),MB,G3(:,:,:,100))
  call loop_QS_A(G3(:,:,:,100),wf(:,0),G3(:,:,:,101),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,63),MB,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,107),wf(:,-1),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,42),MB,G3(:,:,:,102))
  call loop_QV_A(G3(:,:,:,102),wf(:,76),G3(:,:,:,103))
  call loop_Q_A(G3(:,:,:,103),Q(:,62),MB,G4(:,:,:,53))
  call loop_QS_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MB,G5tensor(:,16))
  call loop_QV_A(G3(:,:,:,102),wf(:,-2),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,46),MB,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,-4),G4(:,:,:,56))
  call loop_Q_A(G4(:,:,:,56),Q(:,62),MB,G5(:,:,:,23))
  call loop_QS_A(G5(:,:,:,23),wf(:,0),G5(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,24),Q(:,63),MB,G6tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,363),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,62),MB,G2(:,:,:,117))
  call loop_QS_A(G2(:,:,:,117),wf(:,0),G2(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,1),wf(:,1),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,14),MB,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,119),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,62),MB,G3(:,:,:,105))
  call loop_QS_A(G3(:,:,:,105),wf(:,0),G3(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,63),MB,G4tensor(:,31))
  call loop_QV_A(G2(:,:,:,119),wf(:,-5),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,46),MB,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,62),MB,G4(:,:,:,57))
  call loop_QS_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MB,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,119),wf(:,-4),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,30),MB,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,62),MB,G4(:,:,:,59))
  call loop_QS_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,367),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,62),MB,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,0),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MB,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,1),wf(:,170),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,30),MB,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-5),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,62),MB,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,0),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,32))
  call loop_QV_A(G1(:,:,:,1),wf(:,369),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,62),MB,G2(:,:,:,127))
  call loop_QS_A(G2(:,:,:,127),wf(:,0),G2(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,63),MB,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,1),wf(:,167),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,46),MB,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,-4),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,62),MB,G3(:,:,:,113))
  call loop_QS_A(G3(:,:,:,113),wf(:,0),G3(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,63),MB,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,1),wf(:,388),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,62),MB,G2(:,:,:,131))
  call loop_QS_A(G2(:,:,:,131),wf(:,0),G2(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,63),MB,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,1),wf(:,84),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,44),MB,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,29),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,62),MB,G3(:,:,:,115))
  call loop_QS_A(G3(:,:,:,115),wf(:,0),G3(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,63),MB,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,133),wf(:,-1),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,46),MB,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-4),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,62),MB,G4(:,:,:,61))
  call loop_QS_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,63),MB,G5tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,29),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,26),MB,G2(:,:,:,136))
  call loop_QV_A(G2(:,:,:,136),wf(:,84),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,62),MB,G3(:,:,:,119))
  call loop_QS_A(G3(:,:,:,119),wf(:,0),G3(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MB,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,136),wf(:,-2),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,30),MB,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,-5),G3(:,:,:,122))
  call loop_Q_A(G3(:,:,:,122),Q(:,62),MB,G4(:,:,:,63))
  call loop_QS_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,63),MB,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,391),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,62),MB,G2(:,:,:,139))
  call loop_QS_A(G2(:,:,:,139),wf(:,0),G2(:,:,:,140),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,63),MB,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,1),wf(:,194),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,30),MB,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,-5),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,62),MB,G3(:,:,:,123))
  call loop_QS_A(G3(:,:,:,123),wf(:,0),G3(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,63),MB,G4tensor(:,36))
  call loop_QV_A(G1(:,:,:,1),wf(:,394),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,62),MB,G2(:,:,:,143))
  call loop_QS_A(G2(:,:,:,143),wf(:,0),G2(:,:,:,144),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,63),MB,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,1),wf(:,396),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,62),MB,G2(:,:,:,145))
  call loop_QS_A(G2(:,:,:,145),wf(:,0),G2(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,63),MB,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,1),wf(:,76),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,28),MB,G2(:,:,:,147))
  call loop_QV_A(G2(:,:,:,147),wf(:,37),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,62),MB,G3(:,:,:,125))
  call loop_QS_A(G3(:,:,:,125),wf(:,0),G3(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,63),MB,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,147),wf(:,-1),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,30),MB,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-5),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,62),MB,G4(:,:,:,65))
  call loop_QS_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,63),MB,G5tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,37),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,42),MB,G2(:,:,:,150))
  call loop_QV_A(G2(:,:,:,150),wf(:,76),G2(:,:,:,151))
  call loop_Q_A(G2(:,:,:,151),Q(:,62),MB,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,0),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,63),MB,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,150),wf(:,-2),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,46),MB,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,62),MB,G4(:,:,:,67))
  call loop_QS_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,1),wf(:,399),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,62),MB,G2(:,:,:,153))
  call loop_QS_A(G2(:,:,:,153),wf(:,0),G2(:,:,:,154),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,1),wf(:,198),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,30),MB,G2(:,:,:,155))
  call loop_QV_A(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_Q_A(G2(:,:,:,156),Q(:,62),MB,G3(:,:,:,133))
  call loop_QS_A(G3(:,:,:,133),wf(:,0),G3(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,63),MB,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,1),wf(:,401),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,62),MB,G2(:,:,:,157))
  call loop_QS_A(G2(:,:,:,157),wf(:,0),G2(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,63),MB,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,1),wf(:,413),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,62),MB,G2(:,:,:,159))
  call loop_QS_A(G2(:,:,:,159),wf(:,0),G2(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),MB,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,1),wf(:,200),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,46),MB,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,-4),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,62),MB,G3(:,:,:,135))
  call loop_QS_A(G3(:,:,:,135),wf(:,0),G3(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,63),MB,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,1),wf(:,416),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,62),MB,G2(:,:,:,163))
  call loop_QS_A(G2(:,:,:,163),wf(:,0),G2(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,41))
  call loop_QV_A(G1(:,:,:,1),wf(:,419),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,62),MB,G2(:,:,:,165))
  call loop_QS_A(G2(:,:,:,165),wf(:,0),G2(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),MB,G3tensor(:,42))
  call loop_QV_A(G1(:,:,:,1),wf(:,202),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,46),MB,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-4),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,62),MB,G3(:,:,:,137))
  call loop_QS_A(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),MB,G4tensor(:,41))
  call loop_QV_A(G1(:,:,:,1),wf(:,421),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,62),MB,G2(:,:,:,169))
  call loop_QS_A(G2(:,:,:,169),wf(:,0),G2(:,:,:,170),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,63),MB,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,1),wf(:,430),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,62),MB,G2(:,:,:,171))
  call loop_QS_A(G2(:,:,:,171),wf(:,0),G2(:,:,:,172),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,172),Q(:,63),MB,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,1),wf(:,431),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,62),MB,G2(:,:,:,173))
  call loop_QS_A(G2(:,:,:,173),wf(:,0),G2(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,63),MB,G3tensor(:,45))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,214),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,175))
  call loop_AS_Q(G2(:,:,:,175),wf(:,0),G2(:,:,:,176),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,63),MT,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,68),wf(:,215),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,62),MT,G2(:,:,:,177))
  call loop_AS_Q(G2(:,:,:,177),wf(:,0),G2(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,63),MT,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,68),wf(:,216),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,62),MT,G2(:,:,:,179))
  call loop_AS_Q(G2(:,:,:,179),wf(:,0),G2(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,68),wf(:,244),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,62),MT,G2(:,:,:,181))
  call loop_AS_Q(G2(:,:,:,181),wf(:,0),G2(:,:,:,182),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,63),MT,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,68),wf(:,245),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,183))
  call loop_AS_Q(G2(:,:,:,183),wf(:,0),G2(:,:,:,184),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,63),MT,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,68),wf(:,246),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,62),MT,G2(:,:,:,185))
  call loop_AS_Q(G2(:,:,:,185),wf(:,0),G2(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,68),wf(:,271),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,62),MT,G2(:,:,:,187))
  call loop_AS_Q(G2(:,:,:,187),wf(:,0),G2(:,:,:,188),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,68),wf(:,272),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,62),MT,G2(:,:,:,189))
  call loop_AS_Q(G2(:,:,:,189),wf(:,0),G2(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,68),wf(:,273),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,191))
  call loop_AS_Q(G2(:,:,:,191),wf(:,0),G2(:,:,:,192),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,68),wf(:,277),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,193))
  call loop_AS_Q(G2(:,:,:,193),wf(:,0),G2(:,:,:,194),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,194),Q(:,63),MT,G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,68),wf(:,278),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,62),MT,G2(:,:,:,195))
  call loop_AS_Q(G2(:,:,:,195),wf(:,0),G2(:,:,:,196),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,68),wf(:,279),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,62),MT,G2(:,:,:,197))
  call loop_AS_Q(G2(:,:,:,197),wf(:,0),G2(:,:,:,198),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-1),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,18),MT,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,30),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,62),MT,G3(:,:,:,139))
  call loop_AS_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,199),wf(:,32),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,62),MT,G3(:,:,:,141))
  call loop_AS_Q(G3(:,:,:,141),wf(:,0),G3(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,63),MT,G4tensor(:,43))
  call loop_AV_Q(G2(:,:,:,199),wf(:,33),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,62),MT,G3(:,:,:,143))
  call loop_AS_Q(G3(:,:,:,143),wf(:,0),G3(:,:,:,144),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,144),Q(:,63),MT,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,199),wf(:,183),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,62),MT,G3(:,:,:,145))
  call loop_AS_Q(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,199),wf(:,65),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,30),MT,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-5),G3(:,:,:,148))
  call loop_A_Q(G3(:,:,:,148),Q(:,62),MT,G4(:,:,:,69))
  call loop_AS_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,199),wf(:,191),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,62),MT,G3(:,:,:,149))
  call loop_AS_Q(G3(:,:,:,149),wf(:,0),G3(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,63),MT,G4tensor(:,46))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-3),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,26),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,84),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,62),MT,G4(:,:,:,71))
  call loop_AS_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,63),MT,G5tensor(:,24))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-2),G3(:,:,:,153))
  call loop_A_Q(G3(:,:,:,153),Q(:,30),MT,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,-5),G4(:,:,:,74))
  call loop_A_Q(G4(:,:,:,74),Q(:,62),MT,G5(:,:,:,25))
  call loop_AS_Q(G5(:,:,:,25),wf(:,0),G5(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,26),Q(:,63),MT,G6tensor(:,13))
  call loop_AV_Q(G2(:,:,:,199),wf(:,193),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,62),MT,G3(:,:,:,154))
  call loop_AS_Q(G3(:,:,:,154),wf(:,0),G3(:,:,:,155),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,155),Q(:,63),MT,G4tensor(:,47))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-2),G2(:,:,:,208))
  call loop_A_Q(G2(:,:,:,208),Q(:,22),MT,G3(:,:,:,156))
  call loop_AV_Q(G3(:,:,:,156),wf(:,109),G3(:,:,:,157))
  call loop_A_Q(G3(:,:,:,157),Q(:,62),MT,G4(:,:,:,75))
  call loop_AS_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G3(:,:,:,156),wf(:,-3),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,30),MT,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,-5),G4(:,:,:,78))
  call loop_A_Q(G4(:,:,:,78),Q(:,62),MT,G5(:,:,:,27))
  call loop_AS_Q(G5(:,:,:,27),wf(:,0),G5(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,28),Q(:,63),MT,G6tensor(:,14))
  call loop_AV_Q(G1(:,:,:,68),wf(:,289),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,62),MT,G2(:,:,:,209))
  call loop_AS_Q(G2(:,:,:,209),wf(:,0),G2(:,:,:,210),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,63),MT,G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,68),wf(:,290),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,62),MT,G2(:,:,:,211))
  call loop_AS_Q(G2(:,:,:,211),wf(:,0),G2(:,:,:,212),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,212),Q(:,63),MT,G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,68),wf(:,291),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,62),MT,G2(:,:,:,213))
  call loop_AS_Q(G2(:,:,:,213),wf(:,0),G2(:,:,:,214),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,63),MT,G3tensor(:,60))
  call loop_AV_Q(G1(:,:,:,68),wf(:,316),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,62),MT,G2(:,:,:,215))
  call loop_AS_Q(G2(:,:,:,215),wf(:,0),G2(:,:,:,216),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,63),MT,G3tensor(:,61))
  call loop_AV_Q(G1(:,:,:,68),wf(:,317),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,217))
  call loop_AS_Q(G2(:,:,:,217),wf(:,0),G2(:,:,:,218),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,62))
  call loop_AV_Q(G1(:,:,:,68),wf(:,318),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,62),MT,G2(:,:,:,219))
  call loop_AS_Q(G2(:,:,:,219),wf(:,0),G2(:,:,:,220),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,63))
  call loop_AV_Q(G1(:,:,:,68),wf(:,322),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,62),MT,G2(:,:,:,221))
  call loop_AS_Q(G2(:,:,:,221),wf(:,0),G2(:,:,:,222),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,222),Q(:,63),MT,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,68),wf(:,323),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,62),MT,G2(:,:,:,223))
  call loop_AS_Q(G2(:,:,:,223),wf(:,0),G2(:,:,:,224),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,65))
  call loop_AV_Q(G1(:,:,:,68),wf(:,324),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,225))
  call loop_AS_Q(G2(:,:,:,225),wf(:,0),G2(:,:,:,226),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,66))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-2),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,20),MT,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,77),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,62),MT,G3(:,:,:,159))
  call loop_AS_Q(G3(:,:,:,159),wf(:,0),G3(:,:,:,160),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,63),MT,G4tensor(:,48))
  call loop_AV_Q(G2(:,:,:,227),wf(:,79),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,62),MT,G3(:,:,:,161))
  call loop_AS_Q(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),MT,G4tensor(:,49))
  call loop_AV_Q(G2(:,:,:,227),wf(:,80),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,62),MT,G3(:,:,:,163))
  call loop_AS_Q(G3(:,:,:,163),wf(:,0),G3(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,63),MT,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,227),wf(:,176),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,62),MT,G3(:,:,:,165))
  call loop_AS_Q(G3(:,:,:,165),wf(:,0),G3(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,51))
  call loop_AV_Q(G2(:,:,:,227),wf(:,18),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,30),MT,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,-5),G3(:,:,:,168))
  call loop_A_Q(G3(:,:,:,168),Q(:,62),MT,G4(:,:,:,79))
  call loop_AS_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G2(:,:,:,227),wf(:,196),G2(:,:,:,233))
  call loop_A_Q(G2(:,:,:,233),Q(:,62),MT,G3(:,:,:,169))
  call loop_AS_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-3),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,28),MT,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,37),G3(:,:,:,172))
  call loop_A_Q(G3(:,:,:,172),Q(:,62),MT,G4(:,:,:,81))
  call loop_AS_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G3(:,:,:,171),wf(:,-1),G3(:,:,:,173))
  call loop_A_Q(G3(:,:,:,173),Q(:,30),MT,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,-5),G4(:,:,:,84))
  call loop_A_Q(G4(:,:,:,84),Q(:,62),MT,G5(:,:,:,29))
  call loop_AS_Q(G5(:,:,:,29),wf(:,0),G5(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,30),Q(:,63),MT,G6tensor(:,15))
  call loop_AV_Q(G2(:,:,:,227),wf(:,197),G2(:,:,:,235))
  call loop_A_Q(G2(:,:,:,235),Q(:,62),MT,G3(:,:,:,174))
  call loop_AS_Q(G3(:,:,:,174),wf(:,0),G3(:,:,:,175),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,175),Q(:,63),MT,G4tensor(:,53))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-1),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,22),MT,G3(:,:,:,176))
  call loop_AV_Q(G3(:,:,:,176),wf(:,109),G3(:,:,:,177))
  call loop_A_Q(G3(:,:,:,177),Q(:,62),MT,G4(:,:,:,85))
  call loop_AS_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G3(:,:,:,176),wf(:,-3),G3(:,:,:,178))
  call loop_A_Q(G3(:,:,:,178),Q(:,30),MT,G4(:,:,:,87))
  call loop_AV_Q(G4(:,:,:,87),wf(:,-5),G4(:,:,:,88))
  call loop_A_Q(G4(:,:,:,88),Q(:,62),MT,G5(:,:,:,31))
  call loop_AS_Q(G5(:,:,:,31),wf(:,0),G5(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,32),Q(:,63),MT,G6tensor(:,16))
  call loop_AV_Q(G1(:,:,:,68),wf(:,337),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,62),MT,G2(:,:,:,237))
  call loop_AS_Q(G2(:,:,:,237),wf(:,0),G2(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,238),Q(:,63),MT,G3tensor(:,67))
  call loop_AV_Q(G1(:,:,:,68),wf(:,338),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,62),MT,G2(:,:,:,239))
  call loop_AS_Q(G2(:,:,:,239),wf(:,0),G2(:,:,:,240),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,240),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,339),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,241))
  call loop_AS_Q(G2(:,:,:,241),wf(:,0),G2(:,:,:,242),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,63),MT,G3tensor(:,69))
  call loop_AV_Q(G1(:,:,:,68),wf(:,343),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,62),MT,G2(:,:,:,243))
  call loop_AS_Q(G2(:,:,:,243),wf(:,0),G2(:,:,:,244),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,244),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G1(:,:,:,68),wf(:,344),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,245))
  call loop_AS_Q(G2(:,:,:,245),wf(:,0),G2(:,:,:,246),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,246),Q(:,63),MT,G3tensor(:,71))
  call loop_AV_Q(G1(:,:,:,68),wf(:,345),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,62),MT,G2(:,:,:,247))
  call loop_AS_Q(G2(:,:,:,247),wf(:,0),G2(:,:,:,248),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-3),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,24),MT,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,102),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,62),MT,G3(:,:,:,179))
  call loop_AS_Q(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),MT,G4tensor(:,54))
  call loop_AV_Q(G2(:,:,:,249),wf(:,104),G2(:,:,:,251))
  call loop_A_Q(G2(:,:,:,251),Q(:,62),MT,G3(:,:,:,181))
  call loop_AS_Q(G3(:,:,:,181),wf(:,0),G3(:,:,:,182),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,182),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G2(:,:,:,249),wf(:,105),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,62),MT,G3(:,:,:,183))
  call loop_AS_Q(G3(:,:,:,183),wf(:,0),G3(:,:,:,184),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,184),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,249),wf(:,167),G2(:,:,:,253))
  call loop_A_Q(G2(:,:,:,253),Q(:,62),MT,G3(:,:,:,185))
  call loop_AS_Q(G3(:,:,:,185),wf(:,0),G3(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G2(:,:,:,249),wf(:,1),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,30),MT,G3(:,:,:,187))
  call loop_AV_Q(G3(:,:,:,187),wf(:,-5),G3(:,:,:,188))
  call loop_A_Q(G3(:,:,:,188),Q(:,62),MT,G4(:,:,:,89))
  call loop_AS_Q(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,249),wf(:,200),G2(:,:,:,255))
  call loop_A_Q(G2(:,:,:,255),Q(:,62),MT,G3(:,:,:,189))
  call loop_AS_Q(G3(:,:,:,189),wf(:,0),G3(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-2),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,28),MT,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,37),G3(:,:,:,192))
  call loop_A_Q(G3(:,:,:,192),Q(:,62),MT,G4(:,:,:,91))
  call loop_AS_Q(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,30))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-1),G3(:,:,:,193))
  call loop_A_Q(G3(:,:,:,193),Q(:,30),MT,G4(:,:,:,93))
  call loop_AV_Q(G4(:,:,:,93),wf(:,-5),G4(:,:,:,94))
  call loop_A_Q(G4(:,:,:,94),Q(:,62),MT,G5(:,:,:,33))
  call loop_AS_Q(G5(:,:,:,33),wf(:,0),G5(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,34),Q(:,63),MT,G6tensor(:,17))
  call loop_AV_Q(G2(:,:,:,249),wf(:,202),G2(:,:,:,257))
  call loop_A_Q(G2(:,:,:,257),Q(:,62),MT,G3(:,:,:,194))
  call loop_AS_Q(G3(:,:,:,194),wf(:,0),G3(:,:,:,195),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,195),Q(:,63),MT,G4tensor(:,59))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-1),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,26),MT,G3(:,:,:,196))
  call loop_AV_Q(G3(:,:,:,196),wf(:,84),G3(:,:,:,197))
  call loop_A_Q(G3(:,:,:,197),Q(:,62),MT,G4(:,:,:,95))
  call loop_AS_Q(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,31))
  call loop_AV_Q(G3(:,:,:,196),wf(:,-2),G3(:,:,:,198))
  call loop_A_Q(G3(:,:,:,198),Q(:,30),MT,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,-5),G4(:,:,:,98))
  call loop_A_Q(G4(:,:,:,98),Q(:,62),MT,G5(:,:,:,35))
  call loop_AS_Q(G5(:,:,:,35),wf(:,0),G5(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,36),Q(:,63),MT,G6tensor(:,18))
  call loop_AV_Q(G1(:,:,:,68),wf(:,358),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,62),MT,G2(:,:,:,259))
  call loop_AS_Q(G2(:,:,:,259),wf(:,0),G2(:,:,:,260),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,68),wf(:,359),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MT,G2(:,:,:,261))
  call loop_AS_Q(G2(:,:,:,261),wf(:,0),G2(:,:,:,262),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,63),MT,G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,68),wf(:,360),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,62),MT,G2(:,:,:,263))
  call loop_AS_Q(G2(:,:,:,263),wf(:,0),G2(:,:,:,264),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G1(:,:,:,68),wf(:,120),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,30),MT,G2(:,:,:,265))
  call loop_AV_Q(G2(:,:,:,265),wf(:,-5),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,62),MT,G3(:,:,:,199))
  call loop_AS_Q(G3(:,:,:,199),wf(:,0),G3(:,:,:,200),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,63),MT,G4tensor(:,60))
  call loop_AV_Q(G1(:,:,:,68),wf(:,122),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,30),MT,G2(:,:,:,267))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-5),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,62),MT,G3(:,:,:,201))
  call loop_AS_Q(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,61))
  call loop_AV_Q(G1(:,:,:,68),wf(:,123),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,30),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-5),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,62),MT,G3(:,:,:,203))
  call loop_AS_Q(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,62))
  call loop_AV_Q(G1(:,:,:,68),wf(:,362),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,62),MT,G2(:,:,:,271))
  call loop_AS_Q(G2(:,:,:,271),wf(:,0),G2(:,:,:,272),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,272),Q(:,63),MT,G3tensor(:,76))
  call loop_AV_Q(G1(:,:,:,68),wf(:,1),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,22),MT,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,109),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,62),MT,G3(:,:,:,205))
  call loop_AS_Q(G3(:,:,:,205),wf(:,0),G3(:,:,:,206),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,63),MT,G4tensor(:,63))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-3),G2(:,:,:,275))
  call loop_A_Q(G2(:,:,:,275),Q(:,30),MT,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-5),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,62),MT,G4(:,:,:,99))
  call loop_AS_Q(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,63),MT,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,68),wf(:,365),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,276))
  call loop_AS_Q(G2(:,:,:,276),wf(:,0),G2(:,:,:,277),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,277),Q(:,63),MT,G3tensor(:,77))
  call loop_AV_Q(G1(:,:,:,68),wf(:,172),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,30),MT,G2(:,:,:,278))
  call loop_AV_Q(G2(:,:,:,278),wf(:,-5),G2(:,:,:,279))
  call loop_A_Q(G2(:,:,:,279),Q(:,62),MT,G3(:,:,:,209))
  call loop_AS_Q(G3(:,:,:,209),wf(:,0),G3(:,:,:,210),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,63),MT,G4tensor(:,64))
  call loop_AV_Q(G1(:,:,:,68),wf(:,368),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,62),MT,G2(:,:,:,280))
  call loop_AS_Q(G2(:,:,:,280),wf(:,0),G2(:,:,:,281),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,281),Q(:,63),MT,G3tensor(:,78))
  call loop_AV_Q(G1(:,:,:,68),wf(:,371),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,62),MT,G2(:,:,:,282))
  call loop_AS_Q(G2(:,:,:,282),wf(:,0),G2(:,:,:,283),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,283),Q(:,63),MT,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,68),wf(:,18),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,26),MT,G2(:,:,:,284))
  call loop_AV_Q(G2(:,:,:,284),wf(:,84),G2(:,:,:,285))
  call loop_A_Q(G2(:,:,:,285),Q(:,62),MT,G3(:,:,:,211))
  call loop_AS_Q(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,63),MT,G4tensor(:,65))
  call loop_AV_Q(G2(:,:,:,284),wf(:,-2),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,30),MT,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-5),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,62),MT,G4(:,:,:,101))
  call loop_AS_Q(G4(:,:,:,101),wf(:,0),G4(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,63),MT,G5tensor(:,33))
  call loop_AV_Q(G1(:,:,:,68),wf(:,374),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,287))
  call loop_AS_Q(G2(:,:,:,287),wf(:,0),G2(:,:,:,288),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,68),wf(:,181),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,30),MT,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,-5),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,62),MT,G3(:,:,:,215))
  call loop_AS_Q(G3(:,:,:,215),wf(:,0),G3(:,:,:,216),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,216),Q(:,63),MT,G4tensor(:,66))
  call loop_AV_Q(G1(:,:,:,68),wf(:,377),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,62),MT,G2(:,:,:,291))
  call loop_AS_Q(G2(:,:,:,291),wf(:,0),G2(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,68),wf(:,380),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,62),MT,G2(:,:,:,293))
  call loop_AS_Q(G2(:,:,:,293),wf(:,0),G2(:,:,:,294),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,68),wf(:,65),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,28),MT,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,37),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,62),MT,G3(:,:,:,217))
  call loop_AS_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,63),MT,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-1),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,30),MT,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-5),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,62),MT,G4(:,:,:,103))
  call loop_AS_Q(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,63),MT,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,68),wf(:,383),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,62),MT,G2(:,:,:,298))
  call loop_AS_Q(G2(:,:,:,298),wf(:,0),G2(:,:,:,299),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,299),Q(:,63),MT,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,68),wf(:,189),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,30),MT,G2(:,:,:,300))
  call loop_AV_Q(G2(:,:,:,300),wf(:,-5),G2(:,:,:,301))
  call loop_A_Q(G2(:,:,:,301),Q(:,62),MT,G3(:,:,:,221))
  call loop_AS_Q(G3(:,:,:,221),wf(:,0),G3(:,:,:,222),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,63),MT,G4tensor(:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,385),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,302))
  call loop_AS_Q(G2(:,:,:,302),wf(:,0),G2(:,:,:,303),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,303),Q(:,63),MT,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,68),wf(:,412),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,62),MT,G2(:,:,:,304))
  call loop_AS_Q(G2(:,:,:,304),wf(:,0),G2(:,:,:,305),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,305),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,68),wf(:,414),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,62),MT,G2(:,:,:,306))
  call loop_AS_Q(G2(:,:,:,306),wf(:,0),G2(:,:,:,307),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,307),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,68),wf(:,418),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,62),MT,G2(:,:,:,308))
  call loop_AS_Q(G2(:,:,:,308),wf(:,0),G2(:,:,:,309),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,309),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,68),wf(:,420),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,62),MT,G2(:,:,:,310))
  call loop_AS_Q(G2(:,:,:,310),wf(:,0),G2(:,:,:,311),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,311),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,68),wf(:,424),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,312))
  call loop_AS_Q(G2(:,:,:,312),wf(:,0),G2(:,:,:,313),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,313),Q(:,63),MT,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,68),wf(:,425),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,62),MT,G2(:,:,:,314))
  call loop_AS_Q(G2(:,:,:,314),wf(:,0),G2(:,:,:,315),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,315),Q(:,63),MT,G3tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,16),MT,G1(:,:,:,126))
  call loop_QV_A(G1(:,:,:,126),wf(:,214),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,62),MT,G2(:,:,:,316))
  call loop_QS_A(G2(:,:,:,316),wf(:,0),G2(:,:,:,317),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,317),Q(:,63),MT,G3tensor(:,91))
  call loop_QV_A(G1(:,:,:,126),wf(:,215),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,318))
  call loop_QS_A(G2(:,:,:,318),wf(:,0),G2(:,:,:,319),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,319),Q(:,63),MT,G3tensor(:,92))
  call loop_QV_A(G1(:,:,:,126),wf(:,216),G1(:,:,:,129))
  call loop_Q_A(G1(:,:,:,129),Q(:,62),MT,G2(:,:,:,320))
  call loop_QS_A(G2(:,:,:,320),wf(:,0),G2(:,:,:,321),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,321),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G1(:,:,:,126),wf(:,244),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,62),MT,G2(:,:,:,322))
  call loop_QS_A(G2(:,:,:,322),wf(:,0),G2(:,:,:,323),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,323),Q(:,63),MT,G3tensor(:,94))
  call loop_QV_A(G1(:,:,:,126),wf(:,245),G1(:,:,:,131))
  call loop_Q_A(G1(:,:,:,131),Q(:,62),MT,G2(:,:,:,324))
  call loop_QS_A(G2(:,:,:,324),wf(:,0),G2(:,:,:,325),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,325),Q(:,63),MT,G3tensor(:,95))
  call loop_QV_A(G1(:,:,:,126),wf(:,246),G1(:,:,:,132))
  call loop_Q_A(G1(:,:,:,132),Q(:,62),MT,G2(:,:,:,326))
  call loop_QS_A(G2(:,:,:,326),wf(:,0),G2(:,:,:,327),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,327),Q(:,63),MT,G3tensor(:,96))
  call loop_QV_A(G1(:,:,:,126),wf(:,271),G1(:,:,:,133))
  call loop_Q_A(G1(:,:,:,133),Q(:,62),MT,G2(:,:,:,328))
  call loop_QS_A(G2(:,:,:,328),wf(:,0),G2(:,:,:,329),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,329),Q(:,63),MT,G3tensor(:,97))
  call loop_QV_A(G1(:,:,:,126),wf(:,272),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,62),MT,G2(:,:,:,330))
  call loop_QS_A(G2(:,:,:,330),wf(:,0),G2(:,:,:,331),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,331),Q(:,63),MT,G3tensor(:,98))
  call loop_QV_A(G1(:,:,:,126),wf(:,273),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,62),MT,G2(:,:,:,332))
  call loop_QS_A(G2(:,:,:,332),wf(:,0),G2(:,:,:,333),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,333),Q(:,63),MT,G3tensor(:,99))
  call loop_QV_A(G1(:,:,:,126),wf(:,277),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,62),MT,G2(:,:,:,334))
  call loop_QS_A(G2(:,:,:,334),wf(:,0),G2(:,:,:,335),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,335),Q(:,63),MT,G3tensor(:,100))
  call loop_QV_A(G1(:,:,:,126),wf(:,278),G1(:,:,:,137))
  call loop_Q_A(G1(:,:,:,137),Q(:,62),MT,G2(:,:,:,336))
  call loop_QS_A(G2(:,:,:,336),wf(:,0),G2(:,:,:,337),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,337),Q(:,63),MT,G3tensor(:,101))
  call loop_QV_A(G1(:,:,:,126),wf(:,279),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,62),MT,G2(:,:,:,338))
  call loop_QS_A(G2(:,:,:,338),wf(:,0),G2(:,:,:,339),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,339),Q(:,63),MT,G3tensor(:,102))
  call loop_QV_A(G1(:,:,:,126),wf(:,-1),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,18),MT,G2(:,:,:,340))
  call loop_QV_A(G2(:,:,:,340),wf(:,30),G2(:,:,:,341))
  call loop_Q_A(G2(:,:,:,341),Q(:,62),MT,G3(:,:,:,223))
  call loop_QS_A(G3(:,:,:,223),wf(:,0),G3(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,63),MT,G4tensor(:,69))
  call loop_QV_A(G2(:,:,:,340),wf(:,32),G2(:,:,:,342))
  call loop_Q_A(G2(:,:,:,342),Q(:,62),MT,G3(:,:,:,225))
  call loop_QS_A(G3(:,:,:,225),wf(:,0),G3(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,63),MT,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,340),wf(:,33),G2(:,:,:,343))
  call loop_Q_A(G2(:,:,:,343),Q(:,62),MT,G3(:,:,:,227))
  call loop_QS_A(G3(:,:,:,227),wf(:,0),G3(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,63),MT,G4tensor(:,71))
  call loop_QV_A(G2(:,:,:,340),wf(:,183),G2(:,:,:,344))
  call loop_Q_A(G2(:,:,:,344),Q(:,62),MT,G3(:,:,:,229))
  call loop_QS_A(G3(:,:,:,229),wf(:,0),G3(:,:,:,230),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,63),MT,G4tensor(:,72))
  call loop_QV_A(G2(:,:,:,340),wf(:,65),G2(:,:,:,345))
  call loop_Q_A(G2(:,:,:,345),Q(:,30),MT,G3(:,:,:,231))
  call loop_QV_A(G3(:,:,:,231),wf(:,-5),G3(:,:,:,232))
  call loop_Q_A(G3(:,:,:,232),Q(:,62),MT,G4(:,:,:,105))
  call loop_QS_A(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,63),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,340),wf(:,191),G2(:,:,:,346))
  call loop_Q_A(G2(:,:,:,346),Q(:,62),MT,G3(:,:,:,233))
  call loop_QS_A(G3(:,:,:,233),wf(:,0),G3(:,:,:,234),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,234),Q(:,63),MT,G4tensor(:,73))
  call loop_QV_A(G2(:,:,:,340),wf(:,-3),G2(:,:,:,347))
  call loop_Q_A(G2(:,:,:,347),Q(:,26),MT,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,84),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,62),MT,G4(:,:,:,107))
  call loop_QS_A(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),MT,G5tensor(:,36))
  call loop_QV_A(G3(:,:,:,235),wf(:,-2),G3(:,:,:,237))
  call loop_Q_A(G3(:,:,:,237),Q(:,30),MT,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,-5),G4(:,:,:,110))
  call loop_Q_A(G4(:,:,:,110),Q(:,62),MT,G5(:,:,:,37))
  call loop_QS_A(G5(:,:,:,37),wf(:,0),G5(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,38),Q(:,63),MT,G6tensor(:,19))
  call loop_QV_A(G2(:,:,:,340),wf(:,193),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,62),MT,G3(:,:,:,238))
  call loop_QS_A(G3(:,:,:,238),wf(:,0),G3(:,:,:,239),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,239),Q(:,63),MT,G4tensor(:,74))
  call loop_QV_A(G2(:,:,:,340),wf(:,-2),G2(:,:,:,349))
  call loop_Q_A(G2(:,:,:,349),Q(:,22),MT,G3(:,:,:,240))
  call loop_QV_A(G3(:,:,:,240),wf(:,109),G3(:,:,:,241))
  call loop_Q_A(G3(:,:,:,241),Q(:,62),MT,G4(:,:,:,111))
  call loop_QS_A(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,63),MT,G5tensor(:,37))
  call loop_QV_A(G3(:,:,:,240),wf(:,-3),G3(:,:,:,242))
  call loop_Q_A(G3(:,:,:,242),Q(:,30),MT,G4(:,:,:,113))
  call loop_QV_A(G4(:,:,:,113),wf(:,-5),G4(:,:,:,114))
  call loop_Q_A(G4(:,:,:,114),Q(:,62),MT,G5(:,:,:,39))
  call loop_QS_A(G5(:,:,:,39),wf(:,0),G5(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,40),Q(:,63),MT,G6tensor(:,20))
  call loop_QV_A(G1(:,:,:,126),wf(:,289),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,62),MT,G2(:,:,:,350))
  call loop_QS_A(G2(:,:,:,350),wf(:,0),G2(:,:,:,351),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,351),Q(:,63),MT,G3tensor(:,103))
  call loop_QV_A(G1(:,:,:,126),wf(:,290),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,62),MT,G2(:,:,:,352))
  call loop_QS_A(G2(:,:,:,352),wf(:,0),G2(:,:,:,353),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,353),Q(:,63),MT,G3tensor(:,104))
  call loop_QV_A(G1(:,:,:,126),wf(:,291),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,62),MT,G2(:,:,:,354))
  call loop_QS_A(G2(:,:,:,354),wf(:,0),G2(:,:,:,355),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,355),Q(:,63),MT,G3tensor(:,105))
  call loop_QV_A(G1(:,:,:,126),wf(:,316),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,62),MT,G2(:,:,:,356))
  call loop_QS_A(G2(:,:,:,356),wf(:,0),G2(:,:,:,357),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,357),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G1(:,:,:,126),wf(:,317),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,358))
  call loop_QS_A(G2(:,:,:,358),wf(:,0),G2(:,:,:,359),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,359),Q(:,63),MT,G3tensor(:,107))
  call loop_QV_A(G1(:,:,:,126),wf(:,318),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,62),MT,G2(:,:,:,360))
  call loop_QS_A(G2(:,:,:,360),wf(:,0),G2(:,:,:,361),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,361),Q(:,63),MT,G3tensor(:,108))
  call loop_QV_A(G1(:,:,:,126),wf(:,322),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,362))
  call loop_QS_A(G2(:,:,:,362),wf(:,0),G2(:,:,:,363),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,363),Q(:,63),MT,G3tensor(:,109))
  call loop_QV_A(G1(:,:,:,126),wf(:,323),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,62),MT,G2(:,:,:,364))
  call loop_QS_A(G2(:,:,:,364),wf(:,0),G2(:,:,:,365),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,365),Q(:,63),MT,G3tensor(:,110))
  call loop_QV_A(G1(:,:,:,126),wf(:,324),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,62),MT,G2(:,:,:,366))
  call loop_QS_A(G2(:,:,:,366),wf(:,0),G2(:,:,:,367),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,367),Q(:,63),MT,G3tensor(:,111))
  call loop_QV_A(G1(:,:,:,126),wf(:,-2),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,20),MT,G2(:,:,:,368))
  call loop_QV_A(G2(:,:,:,368),wf(:,77),G2(:,:,:,369))
  call loop_Q_A(G2(:,:,:,369),Q(:,62),MT,G3(:,:,:,243))
  call loop_QS_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,63),MT,G4tensor(:,75))
  call loop_QV_A(G2(:,:,:,368),wf(:,79),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,62),MT,G3(:,:,:,245))
  call loop_QS_A(G3(:,:,:,245),wf(:,0),G3(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,63),MT,G4tensor(:,76))
  call loop_QV_A(G2(:,:,:,368),wf(:,80),G2(:,:,:,371))
  call loop_Q_A(G2(:,:,:,371),Q(:,62),MT,G3(:,:,:,247))
  call loop_QS_A(G3(:,:,:,247),wf(:,0),G3(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,248),Q(:,63),MT,G4tensor(:,77))
  call loop_QV_A(G2(:,:,:,368),wf(:,176),G2(:,:,:,372))
  call loop_Q_A(G2(:,:,:,372),Q(:,62),MT,G3(:,:,:,249))
  call loop_QS_A(G3(:,:,:,249),wf(:,0),G3(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,63),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,368),wf(:,18),G2(:,:,:,373))
  call loop_Q_A(G2(:,:,:,373),Q(:,30),MT,G3(:,:,:,251))
  call loop_QV_A(G3(:,:,:,251),wf(:,-5),G3(:,:,:,252))
  call loop_Q_A(G3(:,:,:,252),Q(:,62),MT,G4(:,:,:,115))
  call loop_QS_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,368),wf(:,196),G2(:,:,:,374))
  call loop_Q_A(G2(:,:,:,374),Q(:,62),MT,G3(:,:,:,253))
  call loop_QS_A(G3(:,:,:,253),wf(:,0),G3(:,:,:,254),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,63),MT,G4tensor(:,79))
  call loop_QV_A(G2(:,:,:,368),wf(:,-3),G2(:,:,:,375))
  call loop_Q_A(G2(:,:,:,375),Q(:,28),MT,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,37),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,62),MT,G4(:,:,:,117))
  call loop_QS_A(G4(:,:,:,117),wf(:,0),G4(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,63),MT,G5tensor(:,39))
  call loop_QV_A(G3(:,:,:,255),wf(:,-1),G3(:,:,:,257))
  call loop_Q_A(G3(:,:,:,257),Q(:,30),MT,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,-5),G4(:,:,:,120))
  call loop_Q_A(G4(:,:,:,120),Q(:,62),MT,G5(:,:,:,41))
  call loop_QS_A(G5(:,:,:,41),wf(:,0),G5(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,42),Q(:,63),MT,G6tensor(:,21))
  call loop_QV_A(G2(:,:,:,368),wf(:,197),G2(:,:,:,376))
  call loop_Q_A(G2(:,:,:,376),Q(:,62),MT,G3(:,:,:,258))
  call loop_QS_A(G3(:,:,:,258),wf(:,0),G3(:,:,:,259),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,259),Q(:,63),MT,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,368),wf(:,-1),G2(:,:,:,377))
  call loop_Q_A(G2(:,:,:,377),Q(:,22),MT,G3(:,:,:,260))
  call loop_QV_A(G3(:,:,:,260),wf(:,109),G3(:,:,:,261))
  call loop_Q_A(G3(:,:,:,261),Q(:,62),MT,G4(:,:,:,121))
  call loop_QS_A(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,63),MT,G5tensor(:,40))
  call loop_QV_A(G3(:,:,:,260),wf(:,-3),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,30),MT,G4(:,:,:,123))
  call loop_QV_A(G4(:,:,:,123),wf(:,-5),G4(:,:,:,124))
  call loop_Q_A(G4(:,:,:,124),Q(:,62),MT,G5(:,:,:,43))
  call loop_QS_A(G5(:,:,:,43),wf(:,0),G5(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,44),Q(:,63),MT,G6tensor(:,22))
  call loop_QV_A(G1(:,:,:,126),wf(:,337),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,62),MT,G2(:,:,:,378))
  call loop_QS_A(G2(:,:,:,378),wf(:,0),G2(:,:,:,379),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,379),Q(:,63),MT,G3tensor(:,112))
  call loop_QV_A(G1(:,:,:,126),wf(:,338),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,62),MT,G2(:,:,:,380))
  call loop_QS_A(G2(:,:,:,380),wf(:,0),G2(:,:,:,381),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,381),Q(:,63),MT,G3tensor(:,113))
  call loop_QV_A(G1(:,:,:,126),wf(:,339),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,62),MT,G2(:,:,:,382))
  call loop_QS_A(G2(:,:,:,382),wf(:,0),G2(:,:,:,383),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,383),Q(:,63),MT,G3tensor(:,114))
  call loop_QV_A(G1(:,:,:,126),wf(:,343),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,62),MT,G2(:,:,:,384))
  call loop_QS_A(G2(:,:,:,384),wf(:,0),G2(:,:,:,385),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,385),Q(:,63),MT,G3tensor(:,115))
  call loop_QV_A(G1(:,:,:,126),wf(:,344),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,62),MT,G2(:,:,:,386))
  call loop_QS_A(G2(:,:,:,386),wf(:,0),G2(:,:,:,387),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,387),Q(:,63),MT,G3tensor(:,116))
  call loop_QV_A(G1(:,:,:,126),wf(:,345),G1(:,:,:,155))
  call loop_Q_A(G1(:,:,:,155),Q(:,62),MT,G2(:,:,:,388))
  call loop_QS_A(G2(:,:,:,388),wf(:,0),G2(:,:,:,389),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,389),Q(:,63),MT,G3tensor(:,117))
  call loop_QV_A(G1(:,:,:,126),wf(:,-3),G1(:,:,:,156))
  call loop_Q_A(G1(:,:,:,156),Q(:,24),MT,G2(:,:,:,390))
  call loop_QV_A(G2(:,:,:,390),wf(:,102),G2(:,:,:,391))
  call loop_Q_A(G2(:,:,:,391),Q(:,62),MT,G3(:,:,:,263))
  call loop_QS_A(G3(:,:,:,263),wf(:,0),G3(:,:,:,264),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,264),Q(:,63),MT,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,390),wf(:,104),G2(:,:,:,392))
  call loop_Q_A(G2(:,:,:,392),Q(:,62),MT,G3(:,:,:,265))
  call loop_QS_A(G3(:,:,:,265),wf(:,0),G3(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,63),MT,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,390),wf(:,105),G2(:,:,:,393))
  call loop_Q_A(G2(:,:,:,393),Q(:,62),MT,G3(:,:,:,267))
  call loop_QS_A(G3(:,:,:,267),wf(:,0),G3(:,:,:,268),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,63),MT,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,390),wf(:,167),G2(:,:,:,394))
  call loop_Q_A(G2(:,:,:,394),Q(:,62),MT,G3(:,:,:,269))
  call loop_QS_A(G3(:,:,:,269),wf(:,0),G3(:,:,:,270),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,270),Q(:,63),MT,G4tensor(:,84))
  call loop_QV_A(G2(:,:,:,390),wf(:,1),G2(:,:,:,395))
  call loop_Q_A(G2(:,:,:,395),Q(:,30),MT,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-5),G3(:,:,:,272))
  call loop_Q_A(G3(:,:,:,272),Q(:,62),MT,G4(:,:,:,125))
  call loop_QS_A(G4(:,:,:,125),wf(:,0),G4(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,63),MT,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,390),wf(:,200),G2(:,:,:,396))
  call loop_Q_A(G2(:,:,:,396),Q(:,62),MT,G3(:,:,:,273))
  call loop_QS_A(G3(:,:,:,273),wf(:,0),G3(:,:,:,274),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,63),MT,G4tensor(:,85))
  call loop_QV_A(G2(:,:,:,390),wf(:,-2),G2(:,:,:,397))
  call loop_Q_A(G2(:,:,:,397),Q(:,28),MT,G3(:,:,:,275))
  call loop_QV_A(G3(:,:,:,275),wf(:,37),G3(:,:,:,276))
  call loop_Q_A(G3(:,:,:,276),Q(:,62),MT,G4(:,:,:,127))
  call loop_QS_A(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,63),MT,G5tensor(:,42))
  call loop_QV_A(G3(:,:,:,275),wf(:,-1),G3(:,:,:,277))
  call loop_Q_A(G3(:,:,:,277),Q(:,30),MT,G4(:,:,:,129))
  call loop_QV_A(G4(:,:,:,129),wf(:,-5),G4(:,:,:,130))
  call loop_Q_A(G4(:,:,:,130),Q(:,62),MT,G5(:,:,:,45))
  call loop_QS_A(G5(:,:,:,45),wf(:,0),G5(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,46),Q(:,63),MT,G6tensor(:,23))
  call loop_QV_A(G2(:,:,:,390),wf(:,202),G2(:,:,:,398))
  call loop_Q_A(G2(:,:,:,398),Q(:,62),MT,G3(:,:,:,278))
  call loop_QS_A(G3(:,:,:,278),wf(:,0),G3(:,:,:,279),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,279),Q(:,63),MT,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,390),wf(:,-1),G2(:,:,:,399))
  call loop_Q_A(G2(:,:,:,399),Q(:,26),MT,G3(:,:,:,280))
  call loop_QV_A(G3(:,:,:,280),wf(:,84),G3(:,:,:,281))
  call loop_Q_A(G3(:,:,:,281),Q(:,62),MT,G4(:,:,:,131))
  call loop_QS_A(G4(:,:,:,131),wf(:,0),G4(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,63),MT,G5tensor(:,43))
  call loop_QV_A(G3(:,:,:,280),wf(:,-2),G3(:,:,:,282))
  call loop_Q_A(G3(:,:,:,282),Q(:,30),MT,G4(:,:,:,133))
  call loop_QV_A(G4(:,:,:,133),wf(:,-5),G4(:,:,:,134))
  call loop_Q_A(G4(:,:,:,134),Q(:,62),MT,G5(:,:,:,47))
  call loop_QS_A(G5(:,:,:,47),wf(:,0),G5(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,48),Q(:,63),MT,G6tensor(:,24))
  call loop_QV_A(G1(:,:,:,126),wf(:,358),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,62),MT,G2(:,:,:,400))
  call loop_QS_A(G2(:,:,:,400),wf(:,0),G2(:,:,:,401),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,401),Q(:,63),MT,G3tensor(:,118))
  call loop_QV_A(G1(:,:,:,126),wf(:,359),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,62),MT,G2(:,:,:,402))
  call loop_QS_A(G2(:,:,:,402),wf(:,0),G2(:,:,:,403),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,403),Q(:,63),MT,G3tensor(:,119))
  call loop_QV_A(G1(:,:,:,126),wf(:,360),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,62),MT,G2(:,:,:,404))
  call loop_QS_A(G2(:,:,:,404),wf(:,0),G2(:,:,:,405),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,405),Q(:,63),MT,G3tensor(:,120))
  call loop_QV_A(G1(:,:,:,126),wf(:,120),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,30),MT,G2(:,:,:,406))
  call loop_QV_A(G2(:,:,:,406),wf(:,-5),G2(:,:,:,407))
  call loop_Q_A(G2(:,:,:,407),Q(:,62),MT,G3(:,:,:,283))
  call loop_QS_A(G3(:,:,:,283),wf(:,0),G3(:,:,:,284),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,63),MT,G4tensor(:,87))
  call loop_QV_A(G1(:,:,:,126),wf(:,122),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,30),MT,G2(:,:,:,408))
  call loop_QV_A(G2(:,:,:,408),wf(:,-5),G2(:,:,:,409))
  call loop_Q_A(G2(:,:,:,409),Q(:,62),MT,G3(:,:,:,285))
  call loop_QS_A(G3(:,:,:,285),wf(:,0),G3(:,:,:,286),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,286),Q(:,63),MT,G4tensor(:,88))
  call loop_QV_A(G1(:,:,:,126),wf(:,123),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,30),MT,G2(:,:,:,410))
  call loop_QV_A(G2(:,:,:,410),wf(:,-5),G2(:,:,:,411))
  call loop_Q_A(G2(:,:,:,411),Q(:,62),MT,G3(:,:,:,287))
  call loop_QS_A(G3(:,:,:,287),wf(:,0),G3(:,:,:,288),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,288),Q(:,63),MT,G4tensor(:,89))
  call loop_QV_A(G1(:,:,:,126),wf(:,362),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,62),MT,G2(:,:,:,412))
  call loop_QS_A(G2(:,:,:,412),wf(:,0),G2(:,:,:,413),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,413),Q(:,63),MT,G3tensor(:,121))
  call loop_QV_A(G1(:,:,:,126),wf(:,1),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,22),MT,G2(:,:,:,414))
  call loop_QV_A(G2(:,:,:,414),wf(:,109),G2(:,:,:,415))
  call loop_Q_A(G2(:,:,:,415),Q(:,62),MT,G3(:,:,:,289))
  call loop_QS_A(G3(:,:,:,289),wf(:,0),G3(:,:,:,290),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,63),MT,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,414),wf(:,-3),G2(:,:,:,416))
  call loop_Q_A(G2(:,:,:,416),Q(:,30),MT,G3(:,:,:,291))
  call loop_QV_A(G3(:,:,:,291),wf(:,-5),G3(:,:,:,292))
  call loop_Q_A(G3(:,:,:,292),Q(:,62),MT,G4(:,:,:,135))
  call loop_QS_A(G4(:,:,:,135),wf(:,0),G4(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,63),MT,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,126),wf(:,365),G1(:,:,:,165))
  call loop_Q_A(G1(:,:,:,165),Q(:,62),MT,G2(:,:,:,417))
  call loop_QS_A(G2(:,:,:,417),wf(:,0),G2(:,:,:,418),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,418),Q(:,63),MT,G3tensor(:,122))
  call loop_QV_A(G1(:,:,:,126),wf(:,172),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,30),MT,G2(:,:,:,419))
  call loop_QV_A(G2(:,:,:,419),wf(:,-5),G2(:,:,:,420))
  call loop_Q_A(G2(:,:,:,420),Q(:,62),MT,G3(:,:,:,293))
  call loop_QS_A(G3(:,:,:,293),wf(:,0),G3(:,:,:,294),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,294),Q(:,63),MT,G4tensor(:,91))
  call loop_QV_A(G1(:,:,:,126),wf(:,368),G1(:,:,:,167))
  call loop_Q_A(G1(:,:,:,167),Q(:,62),MT,G2(:,:,:,421))
  call loop_QS_A(G2(:,:,:,421),wf(:,0),G2(:,:,:,422),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,422),Q(:,63),MT,G3tensor(:,123))
  call loop_QV_A(G1(:,:,:,126),wf(:,371),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,62),MT,G2(:,:,:,423))
  call loop_QS_A(G2(:,:,:,423),wf(:,0),G2(:,:,:,424),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,424),Q(:,63),MT,G3tensor(:,124))
  call loop_QV_A(G1(:,:,:,126),wf(:,18),G1(:,:,:,169))
  call loop_Q_A(G1(:,:,:,169),Q(:,26),MT,G2(:,:,:,425))
  call loop_QV_A(G2(:,:,:,425),wf(:,84),G2(:,:,:,426))
  call loop_Q_A(G2(:,:,:,426),Q(:,62),MT,G3(:,:,:,295))
  call loop_QS_A(G3(:,:,:,295),wf(:,0),G3(:,:,:,296),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,296),Q(:,63),MT,G4tensor(:,92))
  call loop_QV_A(G2(:,:,:,425),wf(:,-2),G2(:,:,:,427))
  call loop_Q_A(G2(:,:,:,427),Q(:,30),MT,G3(:,:,:,297))
  call loop_QV_A(G3(:,:,:,297),wf(:,-5),G3(:,:,:,298))
  call loop_Q_A(G3(:,:,:,298),Q(:,62),MT,G4(:,:,:,137))
  call loop_QS_A(G4(:,:,:,137),wf(:,0),G4(:,:,:,138),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,63),MT,G5tensor(:,45))
  call loop_QV_A(G1(:,:,:,126),wf(:,374),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,62),MT,G2(:,:,:,428))
  call loop_QS_A(G2(:,:,:,428),wf(:,0),G2(:,:,:,429),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,429),Q(:,63),MT,G3tensor(:,125))
  call loop_QV_A(G1(:,:,:,126),wf(:,181),G1(:,:,:,171))
  call loop_Q_A(G1(:,:,:,171),Q(:,30),MT,G2(:,:,:,430))
  call loop_QV_A(G2(:,:,:,430),wf(:,-5),G2(:,:,:,431))
  call loop_Q_A(G2(:,:,:,431),Q(:,62),MT,G3(:,:,:,299))
  call loop_QS_A(G3(:,:,:,299),wf(:,0),G3(:,:,:,300),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,300),Q(:,63),MT,G4tensor(:,93))
  call loop_QV_A(G1(:,:,:,126),wf(:,377),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,62),MT,G2(:,:,:,432))
  call loop_QS_A(G2(:,:,:,432),wf(:,0),G2(:,:,:,433),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,433),Q(:,63),MT,G3tensor(:,126))
  call loop_QV_A(G1(:,:,:,126),wf(:,380),G1(:,:,:,173))
  call loop_Q_A(G1(:,:,:,173),Q(:,62),MT,G2(:,:,:,434))
  call loop_QS_A(G2(:,:,:,434),wf(:,0),G2(:,:,:,435),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,435),Q(:,63),MT,G3tensor(:,127))
  call loop_QV_A(G1(:,:,:,126),wf(:,65),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,28),MT,G2(:,:,:,436))
  call loop_QV_A(G2(:,:,:,436),wf(:,37),G2(:,:,:,437))
  call loop_Q_A(G2(:,:,:,437),Q(:,62),MT,G3(:,:,:,301))
  call loop_QS_A(G3(:,:,:,301),wf(:,0),G3(:,:,:,302),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,302),Q(:,63),MT,G4tensor(:,94))
  call loop_QV_A(G2(:,:,:,436),wf(:,-1),G2(:,:,:,438))
  call loop_Q_A(G2(:,:,:,438),Q(:,30),MT,G3(:,:,:,303))
  call loop_QV_A(G3(:,:,:,303),wf(:,-5),G3(:,:,:,304))
  call loop_Q_A(G3(:,:,:,304),Q(:,62),MT,G4(:,:,:,139))
  call loop_QS_A(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,63),MT,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,126),wf(:,383),G1(:,:,:,175))
  call loop_Q_A(G1(:,:,:,175),Q(:,62),MT,G2(:,:,:,439))
  call loop_QS_A(G2(:,:,:,439),wf(:,0),G2(:,:,:,440),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,440),Q(:,63),MT,G3tensor(:,128))
  call loop_QV_A(G1(:,:,:,126),wf(:,189),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,30),MT,G2(:,:,:,441))
  call loop_QV_A(G2(:,:,:,441),wf(:,-5),G2(:,:,:,442))
  call loop_Q_A(G2(:,:,:,442),Q(:,62),MT,G3(:,:,:,305))
  call loop_QS_A(G3(:,:,:,305),wf(:,0),G3(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,306),Q(:,63),MT,G4tensor(:,95))
  call loop_QV_A(G1(:,:,:,126),wf(:,385),G1(:,:,:,177))
  call loop_Q_A(G1(:,:,:,177),Q(:,62),MT,G2(:,:,:,443))
  call loop_QS_A(G2(:,:,:,443),wf(:,0),G2(:,:,:,444),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,444),Q(:,63),MT,G3tensor(:,129))
  call loop_QV_A(G1(:,:,:,126),wf(:,412),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,62),MT,G2(:,:,:,445))
  call loop_QS_A(G2(:,:,:,445),wf(:,0),G2(:,:,:,446),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,446),Q(:,63),MT,G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,126),wf(:,414),G1(:,:,:,179))
  call loop_Q_A(G1(:,:,:,179),Q(:,62),MT,G2(:,:,:,447))
  call loop_QS_A(G2(:,:,:,447),wf(:,0),G2(:,:,:,448),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,448),Q(:,63),MT,G3tensor(:,131))
  call loop_QV_A(G1(:,:,:,126),wf(:,418),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,62),MT,G2(:,:,:,449))
  call loop_QS_A(G2(:,:,:,449),wf(:,0),G2(:,:,:,450),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,450),Q(:,63),MT,G3tensor(:,132))
  call loop_QV_A(G1(:,:,:,126),wf(:,420),G1(:,:,:,181))
  call loop_Q_A(G1(:,:,:,181),Q(:,62),MT,G2(:,:,:,451))
  call loop_QS_A(G2(:,:,:,451),wf(:,0),G2(:,:,:,452),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,452),Q(:,63),MT,G3tensor(:,133))
  call loop_QV_A(G1(:,:,:,126),wf(:,424),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,62),MT,G2(:,:,:,453))
  call loop_QS_A(G2(:,:,:,453),wf(:,0),G2(:,:,:,454),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,454),Q(:,63),MT,G3tensor(:,134))
  call loop_QV_A(G1(:,:,:,126),wf(:,425),G1(:,:,:,183))
  call loop_Q_A(G1(:,:,:,183),Q(:,62),MT,G2(:,:,:,455))
  call loop_QS_A(G2(:,:,:,455),wf(:,0),G2(:,:,:,456),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,456),Q(:,63),MT,G3tensor(:,135))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(246)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(248)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,49),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,50),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,51),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(261)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(263)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(265)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(267)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(7) = M(7) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,1),T4sum(1:70,12))
  M(9) = M(9) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,1),T4sum(1:70,12))
  M(11) = M(11) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,1),T4sum(1:70,12))
  M(12) = M(12) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,1),T4sum(1:70,12))
  M(7) = M(7) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,2),T4sum(1:70,12))
  M(8) = M(8) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,2),T4sum(1:70,12))
  M(10) = M(10) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,2),T4sum(1:70,12))
  M(12) = M(12) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,2),T4sum(1:70,12))
  M(8) = M(8) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,3),T4sum(1:70,12))
  M(9) = M(9) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,3),T4sum(1:70,12))
  M(10) = M(10) + (f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,3),T4sum(1:70,12))
  M(11) = M(11) + (-f(3) * den(11)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,3),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,52),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(270)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,55),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,56),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,57),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(272)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,42),T4sum(1:70,17))
  M(8) = M(8) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,42),T4sum(1:70,17))
  M(19) = M(19) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,42),T4sum(1:70,17))
  M(21) = M(21) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,42),T4sum(1:70,17))
  M(2) = M(2) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,43),T4sum(1:70,17))
  M(5) = M(5) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,43),T4sum(1:70,17))
  M(11) = M(11) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,43),T4sum(1:70,17))
  M(21) = M(21) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,43),T4sum(1:70,17))
  M(5) = M(5) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,44),T4sum(1:70,17))
  M(8) = M(8) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,44),T4sum(1:70,17))
  M(11) = M(11) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,44),T4sum(1:70,17))
  M(19) = M(19) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,44),T4sum(1:70,17))
  M(13) = M(13) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,69),T4sum(1:70,17))
  M(15) = M(15) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,69),T4sum(1:70,17))
  M(17) = M(17) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,69),T4sum(1:70,17))
  M(18) = M(18) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,69),T4sum(1:70,17))
  M(13) = M(13) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,70),T4sum(1:70,17))
  M(14) = M(14) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,70),T4sum(1:70,17))
  M(16) = M(16) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,70),T4sum(1:70,17))
  M(18) = M(18) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,70),T4sum(1:70,17))
  M(14) = M(14) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,71),T4sum(1:70,17))
  M(15) = M(15) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,71),T4sum(1:70,17))
  M(16) = M(16) + (f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,71),T4sum(1:70,17))
  M(17) = M(17) + (-f(6) * den(16)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,71),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,58),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,59),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,60),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(276)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(278)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(280)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(282)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(2) = M(2) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,7),T4sum(1:70,30))
  M(13) = M(13) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,7),T4sum(1:70,30))
  M(17) = M(17) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,7),T4sum(1:70,30))
  M(19) = M(19) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,7),T4sum(1:70,30))
  M(1) = M(1) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,8),T4sum(1:70,30))
  M(2) = M(2) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,8),T4sum(1:70,30))
  M(17) = M(17) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,8),T4sum(1:70,30))
  M(23) = M(23) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,8),T4sum(1:70,30))
  M(1) = M(1) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,9),T4sum(1:70,30))
  M(13) = M(13) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,9),T4sum(1:70,30))
  M(19) = M(19) + (-f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,9),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(34)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,9),T4sum(1:70,30))
  M(6) = M(6) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,61),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,62),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,63),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(285)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,64),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,65),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,66),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,109),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,110),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(287)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(9) = M(9) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,48),T4sum(1:70,35))
  M(12) = M(12) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,48),T4sum(1:70,35))
  M(14) = M(14) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,48),T4sum(1:70,35))
  M(23) = M(23) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,48),T4sum(1:70,35))
  M(12) = M(12) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,49),T4sum(1:70,35))
  M(13) = M(13) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,49),T4sum(1:70,35))
  M(14) = M(14) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,49),T4sum(1:70,35))
  M(22) = M(22) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,49),T4sum(1:70,35))
  M(9) = M(9) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,50),T4sum(1:70,35))
  M(13) = M(13) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,50),T4sum(1:70,35))
  M(22) = M(22) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,50),T4sum(1:70,35))
  M(23) = M(23) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,50),T4sum(1:70,35))
  M(4) = M(4) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,75),T4sum(1:70,35))
  M(7) = M(7) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,75),T4sum(1:70,35))
  M(11) = M(11) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,75),T4sum(1:70,35))
  M(20) = M(20) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,75),T4sum(1:70,35))
  M(3) = M(3) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,76),T4sum(1:70,35))
  M(4) = M(4) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,76),T4sum(1:70,35))
  M(11) = M(11) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,76),T4sum(1:70,35))
  M(21) = M(21) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,76),T4sum(1:70,35))
  M(3) = M(3) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,77),T4sum(1:70,35))
  M(7) = M(7) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,77),T4sum(1:70,35))
  M(20) = M(20) + (-f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,77),T4sum(1:70,35))
  M(21) = M(21) + (f(6) * den(39)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,77),T4sum(1:70,35))
  M(2) = M(2) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,67),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,68),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,69),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(292)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(293)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,70),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,71),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,72),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(294)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(295)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,13),T4sum(1:70,44))
  M(5) = M(5) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,13),T4sum(1:70,44))
  M(10) = M(10) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,13),T4sum(1:70,44))
  M(22) = M(22) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,13),T4sum(1:70,44))
  M(5) = M(5) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,14),T4sum(1:70,44))
  M(9) = M(9) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,14),T4sum(1:70,44))
  M(10) = M(10) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,14),T4sum(1:70,44))
  M(19) = M(19) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,14),T4sum(1:70,44))
  M(1) = M(1) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,15),T4sum(1:70,44))
  M(9) = M(9) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,15),T4sum(1:70,44))
  M(19) = M(19) + (f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,15),T4sum(1:70,44))
  M(22) = M(22) + (-f(3) * den(52)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,15),T4sum(1:70,44))
  M(3) = M(3) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,16),T4sum(1:70,46))
  M(6) = M(6) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,16),T4sum(1:70,46))
  M(16) = M(16) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,16),T4sum(1:70,46))
  M(24) = M(24) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,16),T4sum(1:70,46))
  M(6) = M(6) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,17),T4sum(1:70,46))
  M(15) = M(15) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,17),T4sum(1:70,46))
  M(16) = M(16) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,17),T4sum(1:70,46))
  M(20) = M(20) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,17),T4sum(1:70,46))
  M(3) = M(3) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,18),T4sum(1:70,46))
  M(15) = M(15) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,18),T4sum(1:70,46))
  M(20) = M(20) + (f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,18),T4sum(1:70,46))
  M(24) = M(24) + (-f(3) * den(52)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,18),T4sum(1:70,46))
  M(3) = M(3) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,54),T4sum(1:70,47))
  M(6) = M(6) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,54),T4sum(1:70,47))
  M(16) = M(16) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,54),T4sum(1:70,47))
  M(24) = M(24) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,54),T4sum(1:70,47))
  M(6) = M(6) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,55),T4sum(1:70,47))
  M(15) = M(15) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,55),T4sum(1:70,47))
  M(16) = M(16) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,55),T4sum(1:70,47))
  M(20) = M(20) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,55),T4sum(1:70,47))
  M(3) = M(3) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,56),T4sum(1:70,47))
  M(15) = M(15) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,56),T4sum(1:70,47))
  M(20) = M(20) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,56),T4sum(1:70,47))
  M(24) = M(24) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,56),T4sum(1:70,47))
  M(1) = M(1) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,81),T4sum(1:70,47))
  M(5) = M(5) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,81),T4sum(1:70,47))
  M(10) = M(10) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,81),T4sum(1:70,47))
  M(22) = M(22) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,81),T4sum(1:70,47))
  M(5) = M(5) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,82),T4sum(1:70,47))
  M(9) = M(9) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,82),T4sum(1:70,47))
  M(10) = M(10) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,82),T4sum(1:70,47))
  M(19) = M(19) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,82),T4sum(1:70,47))
  M(1) = M(1) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,83),T4sum(1:70,47))
  M(9) = M(9) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,83),T4sum(1:70,47))
  M(19) = M(19) + (f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,83),T4sum(1:70,47))
  M(22) = M(22) + (-f(6) * den(52)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,83),T4sum(1:70,47))
  M(2) = M(2) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(297)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(2) = M(2) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,22),T4sum(1:70,50))
  M(3) = M(3) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,22),T4sum(1:70,50))
  M(12) = M(12) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,22),T4sum(1:70,50))
  M(16) = M(16) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,22),T4sum(1:70,50))
  M(3) = M(3) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,23),T4sum(1:70,50))
  M(11) = M(11) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,23),T4sum(1:70,50))
  M(12) = M(12) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,23),T4sum(1:70,50))
  M(13) = M(13) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,23),T4sum(1:70,50))
  M(2) = M(2) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,24),T4sum(1:70,50))
  M(11) = M(11) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,24),T4sum(1:70,50))
  M(13) = M(13) + (f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,24),T4sum(1:70,50))
  M(16) = M(16) + (-f(3) * den(56)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,24),T4sum(1:70,50))
  M(4) = M(4) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,25),T4sum(1:70,52))
  M(5) = M(5) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,25),T4sum(1:70,52))
  M(18) = M(18) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,25),T4sum(1:70,52))
  M(22) = M(22) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,25),T4sum(1:70,52))
  M(4) = M(4) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,26),T4sum(1:70,52))
  M(14) = M(14) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,26),T4sum(1:70,52))
  M(21) = M(21) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,26),T4sum(1:70,52))
  M(22) = M(22) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,26),T4sum(1:70,52))
  M(5) = M(5) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,27),T4sum(1:70,52))
  M(14) = M(14) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,27),T4sum(1:70,52))
  M(18) = M(18) + (-f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,27),T4sum(1:70,52))
  M(21) = M(21) + (f(3) * den(56)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,27),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(299)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,60),T4sum(1:70,55))
  M(6) = M(6) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,60),T4sum(1:70,55))
  M(12) = M(12) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,60),T4sum(1:70,55))
  M(24) = M(24) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,60),T4sum(1:70,55))
  M(2) = M(2) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,61),T4sum(1:70,55))
  M(8) = M(8) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,61),T4sum(1:70,55))
  M(23) = M(23) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,61),T4sum(1:70,55))
  M(24) = M(24) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,61),T4sum(1:70,55))
  M(6) = M(6) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,62),T4sum(1:70,55))
  M(8) = M(8) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,62),T4sum(1:70,55))
  M(12) = M(12) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,62),T4sum(1:70,55))
  M(23) = M(23) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,62),T4sum(1:70,55))
  M(1) = M(1) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,87),T4sum(1:70,55))
  M(4) = M(4) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,87),T4sum(1:70,55))
  M(10) = M(10) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,87),T4sum(1:70,55))
  M(18) = M(18) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,87),T4sum(1:70,55))
  M(1) = M(1) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,88),T4sum(1:70,55))
  M(7) = M(7) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,88),T4sum(1:70,55))
  M(17) = M(17) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,88),T4sum(1:70,55))
  M(18) = M(18) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,88),T4sum(1:70,55))
  M(4) = M(4) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,89),T4sum(1:70,55))
  M(7) = M(7) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,89),T4sum(1:70,55))
  M(10) = M(10) + (-f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,89),T4sum(1:70,55))
  M(17) = M(17) + (f(6) * den(62)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,89),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(303)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,63),T4sum(1:70,69))
  M(5) = M(5) + (f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,63),T4sum(1:70,69))
  M(12) = M(12) + (f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,63),T4sum(1:70,69))
  M(22) = M(22) + (-f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,63),T4sum(1:70,69))
  M(3) = M(3) + (-f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,90),T4sum(1:70,69))
  M(4) = M(4) + (f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,90),T4sum(1:70,69))
  M(16) = M(16) + (f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,90),T4sum(1:70,69))
  M(18) = M(18) + (-f(6) * den(302)) * TI2_call(4,momenta_74,masses2_4,G4tensor(:,90),T4sum(1:70,69))
  M(1) = M(1) + (-(CI*f(2)) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(305)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(304)) * TI2_call(4,momenta_51,masses2_3,G4tensor(:,31),T4sum(1:70,76))
  M(2) = M(2) + (f(3) * den(304)) * TI2_call(4,momenta_51,masses2_3,G4tensor(:,31),T4sum(1:70,76))
  M(10) = M(10) + (f(3) * den(304)) * TI2_call(4,momenta_51,masses2_3,G4tensor(:,31),T4sum(1:70,76))
  M(12) = M(12) + (-f(3) * den(304)) * TI2_call(4,momenta_51,masses2_3,G4tensor(:,31),T4sum(1:70,76))
  M(1) = M(1) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(307)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,64),T4sum(1:70,55))
  M(6) = M(6) + (f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,64),T4sum(1:70,55))
  M(12) = M(12) + (f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,64),T4sum(1:70,55))
  M(24) = M(24) + (-f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,64),T4sum(1:70,55))
  M(1) = M(1) + (-f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,91),T4sum(1:70,55))
  M(4) = M(4) + (f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,91),T4sum(1:70,55))
  M(10) = M(10) + (f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,91),T4sum(1:70,55))
  M(18) = M(18) + (-f(6) * den(97)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,91),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(2) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(309)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(2) = M(2) + (f(3) * den(93)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,32),T4sum(1:70,50))
  M(3) = M(3) + (-f(3) * den(93)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,32),T4sum(1:70,50))
  M(12) = M(12) + (-f(3) * den(93)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,32),T4sum(1:70,50))
  M(16) = M(16) + (f(3) * den(93)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,32),T4sum(1:70,50))
  M(4) = M(4) + (-f(3) * den(93)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,28),T4sum(1:70,52))
  M(5) = M(5) + (f(3) * den(93)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,28),T4sum(1:70,52))
  M(18) = M(18) + (f(3) * den(93)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,28),T4sum(1:70,52))
  M(22) = M(22) + (-f(3) * den(93)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,28),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(5) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(310)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(311)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(88)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,33),T4sum(1:70,44))
  M(5) = M(5) + (-f(3) * den(88)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,33),T4sum(1:70,44))
  M(10) = M(10) + (-f(3) * den(88)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,33),T4sum(1:70,44))
  M(22) = M(22) + (f(3) * den(88)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,33),T4sum(1:70,44))
  M(3) = M(3) + (f(3) * den(88)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,19),T4sum(1:70,46))
  M(6) = M(6) + (-f(3) * den(88)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,19),T4sum(1:70,46))
  M(16) = M(16) + (-f(3) * den(88)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,19),T4sum(1:70,46))
  M(24) = M(24) + (f(3) * den(88)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,19),T4sum(1:70,46))
  M(3) = M(3) + (f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,57),T4sum(1:70,47))
  M(6) = M(6) + (-f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,57),T4sum(1:70,47))
  M(16) = M(16) + (-f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,57),T4sum(1:70,47))
  M(24) = M(24) + (f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,57),T4sum(1:70,47))
  M(1) = M(1) + (f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,84),T4sum(1:70,47))
  M(5) = M(5) + (-f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,84),T4sum(1:70,47))
  M(10) = M(10) + (-f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,84),T4sum(1:70,47))
  M(22) = M(22) + (f(6) * den(88)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,84),T4sum(1:70,47))
  M(5) = M(5) + (CI*f(2) * den(1)) * TI2_call(5,momenta_182,masses2_5,G5tensor(:,14),T5sum(1:126,2))
  M(22) = M(22) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_182,masses2_5,G5tensor(:,14),T5sum(1:126,2))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_174,masses2_5,G5tensor(:,17),T5sum(1:126,4))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_174,masses2_5,G5tensor(:,17),T5sum(1:126,4))
  M(3) = M(3) + (CI*f(2) * den(1)) * TI2_call(5,momenta_177,masses2_5,G5tensor(:,11),T5sum(1:126,6))
  M(16) = M(16) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_177,masses2_5,G5tensor(:,11),T5sum(1:126,6))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_173,masses2_5,G5tensor(:,18),T5sum(1:126,8))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_173,masses2_5,G5tensor(:,18),T5sum(1:126,8))
  M(6) = M(6) + (CI*f(5) * den(1)) * TI2_call(5,momenta_202,masses2_6,G5tensor(:,29),T5sum(1:126,13))
  M(24) = M(24) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_202,masses2_6,G5tensor(:,29),T5sum(1:126,13))
  M(1) = M(1) + (CI*f(5) * den(1)) * TI2_call(5,momenta_202,masses2_6,G5tensor(:,41),T5sum(1:126,13))
  M(10) = M(10) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_202,masses2_6,G5tensor(:,41),T5sum(1:126,13))
  M(2) = M(2) + (CI*f(5) * den(1)) * TI2_call(5,momenta_199,masses2_6,G5tensor(:,32),T5sum(1:126,15))
  M(12) = M(12) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_199,masses2_6,G5tensor(:,32),T5sum(1:126,15))
  M(4) = M(4) + (CI*f(5) * den(1)) * TI2_call(5,momenta_199,masses2_6,G5tensor(:,44),T5sum(1:126,15))
  M(18) = M(18) + (-(CI*f(5)) * den(1)) * TI2_call(5,momenta_199,masses2_6,G5tensor(:,44),T5sum(1:126,15))
  M(6) = M(6) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(315)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(6) = M(6) + (f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,65),T4sum(1:70,87))
  M(8) = M(8) + (-f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,65),T4sum(1:70,87))
  M(11) = M(11) + (f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,65),T4sum(1:70,87))
  M(20) = M(20) + (-f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,65),T4sum(1:70,87))
  M(9) = M(9) + (-f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,92),T4sum(1:70,87))
  M(10) = M(10) + (f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,92),T4sum(1:70,87))
  M(14) = M(14) + (f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,92),T4sum(1:70,87))
  M(17) = M(17) + (-f(6) * den(314)) * TI2_call(4,momenta_76,masses2_4,G4tensor(:,92),T4sum(1:70,87))
  M(4) = M(4) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(319)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(6) = M(6) + (-f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,66),T4sum(1:70,55))
  M(8) = M(8) + (f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,66),T4sum(1:70,55))
  M(12) = M(12) + (-f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,66),T4sum(1:70,55))
  M(23) = M(23) + (f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,66),T4sum(1:70,55))
  M(4) = M(4) + (-f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,93),T4sum(1:70,55))
  M(7) = M(7) + (f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,93),T4sum(1:70,55))
  M(10) = M(10) + (-f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,93),T4sum(1:70,55))
  M(17) = M(17) + (f(6) * den(123)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,93),T4sum(1:70,55))
  M(4) = M(4) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(5) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(322)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(9) = M(9) + (f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,51),T4sum(1:70,35))
  M(12) = M(12) + (-f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,51),T4sum(1:70,35))
  M(14) = M(14) + (-f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,51),T4sum(1:70,35))
  M(23) = M(23) + (f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,51),T4sum(1:70,35))
  M(4) = M(4) + (-f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,78),T4sum(1:70,35))
  M(7) = M(7) + (f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,78),T4sum(1:70,35))
  M(11) = M(11) + (-f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,78),T4sum(1:70,35))
  M(20) = M(20) + (f(6) * den(114)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,78),T4sum(1:70,35))
  M(12) = M(12) + (CI*f(5) * den(10)) * TI2_call(5,momenta_198,masses2_6,G5tensor(:,26),T5sum(1:126,37))
  M(23) = M(23) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_198,masses2_6,G5tensor(:,26),T5sum(1:126,37))
  M(4) = M(4) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_198,masses2_6,G5tensor(:,38),T5sum(1:126,37))
  M(7) = M(7) + (CI*f(5) * den(10)) * TI2_call(5,momenta_198,masses2_6,G5tensor(:,38),T5sum(1:126,37))
  M(6) = M(6) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_203,masses2_6,G5tensor(:,33),T5sum(1:126,39))
  M(8) = M(8) + (CI*f(5) * den(10)) * TI2_call(5,momenta_203,masses2_6,G5tensor(:,33),T5sum(1:126,39))
  M(10) = M(10) + (CI*f(5) * den(10)) * TI2_call(5,momenta_203,masses2_6,G5tensor(:,45),T5sum(1:126,39))
  M(17) = M(17) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_203,masses2_6,G5tensor(:,45),T5sum(1:126,39))
  M(1) = M(1) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(5)) * den(327)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,127),T3sum(1:35,3))
  M(13) = M(13) + (f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,67),T4sum(1:70,103))
  M(15) = M(15) + (-f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,67),T4sum(1:70,103))
  M(23) = M(23) + (-f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,67),T4sum(1:70,103))
  M(24) = M(24) + (f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,67),T4sum(1:70,103))
  M(1) = M(1) + (f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,94),T4sum(1:70,103))
  M(7) = M(7) + (-f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,94),T4sum(1:70,103))
  M(19) = M(19) + (-f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,94),T4sum(1:70,103))
  M(21) = M(21) + (f(6) * den(326)) * TI2_call(4,momenta_77,masses2_4,G4tensor(:,94),T4sum(1:70,103))
  M(1) = M(1) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(5)) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(331)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,128),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,68),T4sum(1:70,55))
  M(8) = M(8) + (f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,68),T4sum(1:70,55))
  M(23) = M(23) + (f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,68),T4sum(1:70,55))
  M(24) = M(24) + (-f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,68),T4sum(1:70,55))
  M(1) = M(1) + (-f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,95),T4sum(1:70,55))
  M(7) = M(7) + (f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,95),T4sum(1:70,55))
  M(17) = M(17) + (f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,95),T4sum(1:70,55))
  M(18) = M(18) + (-f(6) * den(145)) * TI2_call(4,momenta_78,masses2_4,G4tensor(:,95),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(5)) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(333)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,129),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(8) = M(8) + (f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(19) = M(19) + (f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(21) = M(21) + (-f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(13) = M(13) + (-f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,72),T4sum(1:70,17))
  M(15) = M(15) + (f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,72),T4sum(1:70,17))
  M(17) = M(17) + (f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,72),T4sum(1:70,17))
  M(18) = M(18) + (-f(6) * den(134)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,72),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(5) * den(33)) * TI2_call(5,momenta_195,masses2_6,G5tensor(:,23),T5sum(1:126,61))
  M(8) = M(8) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_195,masses2_6,G5tensor(:,23),T5sum(1:126,61))
  M(17) = M(17) + (CI*f(5) * den(33)) * TI2_call(5,momenta_195,masses2_6,G5tensor(:,35),T5sum(1:126,61))
  M(18) = M(18) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_195,masses2_6,G5tensor(:,35),T5sum(1:126,61))
  M(23) = M(23) + (CI*f(5) * den(33)) * TI2_call(5,momenta_204,masses2_6,G5tensor(:,34),T5sum(1:126,63))
  M(24) = M(24) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_204,masses2_6,G5tensor(:,34),T5sum(1:126,63))
  M(1) = M(1) + (CI*f(5) * den(33)) * TI2_call(5,momenta_204,masses2_6,G5tensor(:,46),T5sum(1:126,63))
  M(7) = M(7) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_204,masses2_6,G5tensor(:,46),T5sum(1:126,63))
  M(5) = M(5) + (-(CI*f(2)) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(337)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(5) = M(5) + (f(3) * den(336)) * TI2_call(4,momenta_58,masses2_3,G4tensor(:,34),T4sum(1:70,116))
  M(14) = M(14) + (-f(3) * den(336)) * TI2_call(4,momenta_58,masses2_3,G4tensor(:,34),T4sum(1:70,116))
  M(17) = M(17) + (f(3) * den(336)) * TI2_call(4,momenta_58,masses2_3,G4tensor(:,34),T4sum(1:70,116))
  M(19) = M(19) + (-f(3) * den(336)) * TI2_call(4,momenta_58,masses2_3,G4tensor(:,34),T4sum(1:70,116))
  M(8) = M(8) + (f(3) * den(336)) * TI2_call(4,momenta_53,masses2_3,G4tensor(:,35),T4sum(1:70,118))
  M(11) = M(11) + (-f(3) * den(336)) * TI2_call(4,momenta_53,masses2_3,G4tensor(:,35),T4sum(1:70,118))
  M(15) = M(15) + (-f(3) * den(336)) * TI2_call(4,momenta_53,masses2_3,G4tensor(:,35),T4sum(1:70,118))
  M(16) = M(16) + (f(3) * den(336)) * TI2_call(4,momenta_53,masses2_3,G4tensor(:,35),T4sum(1:70,118))
  M(2) = M(2) + (-(CI*f(2)) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(341)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(2) = M(2) + (-f(3) * den(162)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,36),T4sum(1:70,50))
  M(11) = M(11) + (f(3) * den(162)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,36),T4sum(1:70,50))
  M(13) = M(13) + (f(3) * den(162)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,36),T4sum(1:70,50))
  M(16) = M(16) + (-f(3) * den(162)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,36),T4sum(1:70,50))
  M(5) = M(5) + (-f(3) * den(162)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,29),T4sum(1:70,52))
  M(14) = M(14) + (f(3) * den(162)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,29),T4sum(1:70,52))
  M(18) = M(18) + (-f(3) * den(162)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,29),T4sum(1:70,52))
  M(21) = M(21) + (f(3) * den(162)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,29),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(2)) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(344)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(2) = M(2) + (-f(3) * den(136)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,10),T4sum(1:70,30))
  M(13) = M(13) + (f(3) * den(136)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,10),T4sum(1:70,30))
  M(17) = M(17) + (-f(3) * den(136)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,10),T4sum(1:70,30))
  M(19) = M(19) + (f(3) * den(136)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,10),T4sum(1:70,30))
  M(2) = M(2) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_170,masses2_5,G5tensor(:,6),T5sum(1:126,86))
  M(13) = M(13) + (CI*f(2) * den(15)) * TI2_call(5,momenta_170,masses2_5,G5tensor(:,6),T5sum(1:126,86))
  M(11) = M(11) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_178,masses2_5,G5tensor(:,20),T5sum(1:126,88))
  M(16) = M(16) + (CI*f(2) * den(15)) * TI2_call(5,momenta_178,masses2_5,G5tensor(:,20),T5sum(1:126,88))
  M(17) = M(17) + (CI*f(2) * den(15)) * TI2_call(5,momenta_171,masses2_5,G5tensor(:,7),T5sum(1:126,90))
  M(19) = M(19) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_171,masses2_5,G5tensor(:,7),T5sum(1:126,90))
  M(5) = M(5) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_181,masses2_5,G5tensor(:,15),T5sum(1:126,92))
  M(14) = M(14) + (CI*f(2) * den(15)) * TI2_call(5,momenta_181,masses2_5,G5tensor(:,15),T5sum(1:126,92))
  M(3) = M(3) + (CI*f(2) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(347)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(3) = M(3) + (f(3) * den(346)) * TI2_call(4,momenta_54,masses2_3,G4tensor(:,37),T4sum(1:70,128))
  M(13) = M(13) + (-f(3) * den(346)) * TI2_call(4,momenta_54,masses2_3,G4tensor(:,37),T4sum(1:70,128))
  M(20) = M(20) + (-f(3) * den(346)) * TI2_call(4,momenta_54,masses2_3,G4tensor(:,37),T4sum(1:70,128))
  M(23) = M(23) + (f(3) * den(346)) * TI2_call(4,momenta_54,masses2_3,G4tensor(:,37),T4sum(1:70,128))
  M(7) = M(7) + (f(3) * den(346)) * TI2_call(4,momenta_57,masses2_3,G4tensor(:,38),T4sum(1:70,130))
  M(9) = M(9) + (-f(3) * den(346)) * TI2_call(4,momenta_57,masses2_3,G4tensor(:,38),T4sum(1:70,130))
  M(21) = M(21) + (-f(3) * den(346)) * TI2_call(4,momenta_57,masses2_3,G4tensor(:,38),T4sum(1:70,130))
  M(22) = M(22) + (f(3) * den(346)) * TI2_call(4,momenta_57,masses2_3,G4tensor(:,38),T4sum(1:70,130))
  M(3) = M(3) + (-(CI*f(2)) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(351)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(3) = M(3) + (-f(3) * den(172)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,39),T4sum(1:70,50))
  M(11) = M(11) + (f(3) * den(172)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,39),T4sum(1:70,50))
  M(12) = M(12) + (-f(3) * den(172)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,39),T4sum(1:70,50))
  M(13) = M(13) + (f(3) * den(172)) * TI2_call(4,momenta_55,masses2_3,G4tensor(:,39),T4sum(1:70,50))
  M(4) = M(4) + (-f(3) * den(172)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,30),T4sum(1:70,52))
  M(14) = M(14) + (f(3) * den(172)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,30),T4sum(1:70,52))
  M(21) = M(21) + (f(3) * den(172)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,30),T4sum(1:70,52))
  M(22) = M(22) + (-f(3) * den(172)) * TI2_call(4,momenta_56,masses2_3,G4tensor(:,30),T4sum(1:70,52))
  M(4) = M(4) + (CI*f(2) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(353)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(7) = M(7) + (-f(3) * den(112)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,4),T4sum(1:70,12))
  M(9) = M(9) + (f(3) * den(112)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,4),T4sum(1:70,12))
  M(11) = M(11) + (f(3) * den(112)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,4),T4sum(1:70,12))
  M(12) = M(12) + (-f(3) * den(112)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,4),T4sum(1:70,12))
  M(11) = M(11) + (CI*f(2) * den(38)) * TI2_call(5,momenta_165,masses2_5,G5tensor(:,1),T5sum(1:126,110))
  M(12) = M(12) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_165,masses2_5,G5tensor(:,1),T5sum(1:126,110))
  M(3) = M(3) + (CI*f(2) * den(38)) * TI2_call(5,momenta_179,masses2_5,G5tensor(:,21),T5sum(1:126,112))
  M(13) = M(13) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_179,masses2_5,G5tensor(:,21),T5sum(1:126,112))
  M(7) = M(7) + (CI*f(2) * den(38)) * TI2_call(5,momenta_166,masses2_5,G5tensor(:,2),T5sum(1:126,114))
  M(9) = M(9) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_166,masses2_5,G5tensor(:,2),T5sum(1:126,114))
  M(21) = M(21) + (CI*f(2) * den(38)) * TI2_call(5,momenta_180,masses2_5,G5tensor(:,16),T5sum(1:126,116))
  M(22) = M(22) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_180,masses2_5,G5tensor(:,16),T5sum(1:126,116))
  M(1) = M(1) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(5) * den(366)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,130),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(367)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(178)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,40),T4sum(1:70,44))
  M(9) = M(9) + (f(3) * den(178)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,40),T4sum(1:70,44))
  M(19) = M(19) + (f(3) * den(178)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,40),T4sum(1:70,44))
  M(22) = M(22) + (-f(3) * den(178)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,40),T4sum(1:70,44))
  M(3) = M(3) + (-f(3) * den(178)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,20),T4sum(1:70,46))
  M(15) = M(15) + (f(3) * den(178)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,20),T4sum(1:70,46))
  M(20) = M(20) + (f(3) * den(178)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,20),T4sum(1:70,46))
  M(24) = M(24) + (-f(3) * den(178)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,20),T4sum(1:70,46))
  M(3) = M(3) + (-f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,58),T4sum(1:70,47))
  M(15) = M(15) + (f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,58),T4sum(1:70,47))
  M(20) = M(20) + (f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,58),T4sum(1:70,47))
  M(24) = M(24) + (-f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,58),T4sum(1:70,47))
  M(1) = M(1) + (-f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,85),T4sum(1:70,47))
  M(9) = M(9) + (f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,85),T4sum(1:70,47))
  M(19) = M(19) + (f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,85),T4sum(1:70,47))
  M(22) = M(22) + (-f(6) * den(178)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,85),T4sum(1:70,47))
  M(3) = M(3) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(5) * den(368)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,131),T3sum(1:35,3))
  M(9) = M(9) + (-f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,52),T4sum(1:70,35))
  M(13) = M(13) + (f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,52),T4sum(1:70,35))
  M(22) = M(22) + (f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,52),T4sum(1:70,35))
  M(23) = M(23) + (-f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,52),T4sum(1:70,35))
  M(3) = M(3) + (f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,79),T4sum(1:70,35))
  M(7) = M(7) + (-f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,79),T4sum(1:70,35))
  M(20) = M(20) + (-f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,79),T4sum(1:70,35))
  M(21) = M(21) + (f(6) * den(168)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,79),T4sum(1:70,35))
  M(1) = M(1) + (CI*f(2) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(370)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(141)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,11),T4sum(1:70,30))
  M(13) = M(13) + (-f(3) * den(141)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,11),T4sum(1:70,30))
  M(19) = M(19) + (-f(3) * den(141)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,11),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(141)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,11),T4sum(1:70,30))
  M(1) = M(1) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_172,masses2_5,G5tensor(:,8),T5sum(1:126,158))
  M(19) = M(19) + (CI*f(2) * den(19)) * TI2_call(5,momenta_172,masses2_5,G5tensor(:,8),T5sum(1:126,158))
  M(9) = M(9) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_183,masses2_5,G5tensor(:,22),T5sum(1:126,160))
  M(22) = M(22) + (CI*f(2) * den(19)) * TI2_call(5,momenta_183,masses2_5,G5tensor(:,22),T5sum(1:126,160))
  M(13) = M(13) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_169,masses2_5,G5tensor(:,9),T5sum(1:126,162))
  M(23) = M(23) + (CI*f(2) * den(19)) * TI2_call(5,momenta_169,masses2_5,G5tensor(:,9),T5sum(1:126,162))
  M(3) = M(3) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_176,masses2_5,G5tensor(:,12),T5sum(1:126,164))
  M(20) = M(20) + (CI*f(2) * den(19)) * TI2_call(5,momenta_176,masses2_5,G5tensor(:,12),T5sum(1:126,164))
  M(13) = M(13) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_197,masses2_6,G5tensor(:,27),T5sum(1:126,165))
  M(23) = M(23) + (CI*f(5) * den(19)) * TI2_call(5,momenta_197,masses2_6,G5tensor(:,27),T5sum(1:126,165))
  M(7) = M(7) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_197,masses2_6,G5tensor(:,39),T5sum(1:126,165))
  M(21) = M(21) + (CI*f(5) * den(19)) * TI2_call(5,momenta_197,masses2_6,G5tensor(:,39),T5sum(1:126,165))
  M(15) = M(15) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_201,masses2_6,G5tensor(:,30),T5sum(1:126,167))
  M(24) = M(24) + (CI*f(5) * den(19)) * TI2_call(5,momenta_201,masses2_6,G5tensor(:,30),T5sum(1:126,167))
  M(1) = M(1) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_201,masses2_6,G5tensor(:,42),T5sum(1:126,167))
  M(19) = M(19) + (CI*f(5) * den(19)) * TI2_call(5,momenta_201,masses2_6,G5tensor(:,42),T5sum(1:126,167))
  M(5) = M(5) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(9) = M(9) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(20) = M(20) + (-(CI*f(5)) * den(372)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,132),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(373)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(5) = M(5) + (-f(3) * den(182)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,41),T4sum(1:70,44))
  M(9) = M(9) + (f(3) * den(182)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,41),T4sum(1:70,44))
  M(10) = M(10) + (-f(3) * den(182)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,41),T4sum(1:70,44))
  M(19) = M(19) + (f(3) * den(182)) * TI2_call(4,momenta_59,masses2_3,G4tensor(:,41),T4sum(1:70,44))
  M(6) = M(6) + (-f(3) * den(182)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,21),T4sum(1:70,46))
  M(15) = M(15) + (f(3) * den(182)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,21),T4sum(1:70,46))
  M(16) = M(16) + (-f(3) * den(182)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,21),T4sum(1:70,46))
  M(20) = M(20) + (f(3) * den(182)) * TI2_call(4,momenta_52,masses2_3,G4tensor(:,21),T4sum(1:70,46))
  M(6) = M(6) + (-f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,59),T4sum(1:70,47))
  M(15) = M(15) + (f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,59),T4sum(1:70,47))
  M(16) = M(16) + (-f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,59),T4sum(1:70,47))
  M(20) = M(20) + (f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,59),T4sum(1:70,47))
  M(5) = M(5) + (-f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,86),T4sum(1:70,47))
  M(9) = M(9) + (f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,86),T4sum(1:70,47))
  M(10) = M(10) + (-f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,86),T4sum(1:70,47))
  M(19) = M(19) + (f(6) * den(182)) * TI2_call(4,momenta_75,masses2_4,G4tensor(:,86),T4sum(1:70,47))
  M(5) = M(5) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(15) = M(15) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(5)) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(19) = M(19) + (CI*f(5) * den(374)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,133),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(375)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(5) = M(5) + (f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,46),T4sum(1:70,17))
  M(8) = M(8) + (-f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,46),T4sum(1:70,17))
  M(11) = M(11) + (f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,46),T4sum(1:70,17))
  M(19) = M(19) + (-f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,46),T4sum(1:70,17))
  M(14) = M(14) + (f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,73),T4sum(1:70,17))
  M(15) = M(15) + (-f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,73),T4sum(1:70,17))
  M(16) = M(16) + (f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,73),T4sum(1:70,17))
  M(17) = M(17) + (-f(6) * den(156)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,73),T4sum(1:70,17))
  M(8) = M(8) + (f(3) * den(117)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,5),T4sum(1:70,12))
  M(9) = M(9) + (-f(3) * den(117)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,5),T4sum(1:70,12))
  M(10) = M(10) + (f(3) * den(117)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,5),T4sum(1:70,12))
  M(11) = M(11) + (-f(3) * den(117)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,5),T4sum(1:70,12))
  M(9) = M(9) + (CI*f(2) * den(42)) * TI2_call(5,momenta_167,masses2_5,G5tensor(:,3),T5sum(1:126,182))
  M(10) = M(10) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_167,masses2_5,G5tensor(:,3),T5sum(1:126,182))
  M(5) = M(5) + (CI*f(2) * den(42)) * TI2_call(5,momenta_184,masses2_5,G5tensor(:,19),T5sum(1:126,184))
  M(19) = M(19) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_184,masses2_5,G5tensor(:,19),T5sum(1:126,184))
  M(8) = M(8) + (CI*f(2) * den(42)) * TI2_call(5,momenta_164,masses2_5,G5tensor(:,4),T5sum(1:126,186))
  M(11) = M(11) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_164,masses2_5,G5tensor(:,4),T5sum(1:126,186))
  M(15) = M(15) + (CI*f(2) * den(42)) * TI2_call(5,momenta_175,masses2_5,G5tensor(:,13),T5sum(1:126,188))
  M(16) = M(16) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_175,masses2_5,G5tensor(:,13),T5sum(1:126,188))
  M(8) = M(8) + (CI*f(5) * den(42)) * TI2_call(5,momenta_194,masses2_6,G5tensor(:,24),T5sum(1:126,189))
  M(11) = M(11) + (-(CI*f(5)) * den(42)) * TI2_call(5,momenta_194,masses2_6,G5tensor(:,24),T5sum(1:126,189))
  M(14) = M(14) + (CI*f(5) * den(42)) * TI2_call(5,momenta_194,masses2_6,G5tensor(:,36),T5sum(1:126,189))
  M(17) = M(17) + (-(CI*f(5)) * den(42)) * TI2_call(5,momenta_194,masses2_6,G5tensor(:,36),T5sum(1:126,189))
  M(6) = M(6) + (CI*f(5) * den(42)) * TI2_call(5,momenta_200,masses2_6,G5tensor(:,31),T5sum(1:126,191))
  M(20) = M(20) + (-(CI*f(5)) * den(42)) * TI2_call(5,momenta_200,masses2_6,G5tensor(:,31),T5sum(1:126,191))
  M(9) = M(9) + (CI*f(5) * den(42)) * TI2_call(5,momenta_200,masses2_6,G5tensor(:,43),T5sum(1:126,191))
  M(10) = M(10) + (-(CI*f(5)) * den(42)) * TI2_call(5,momenta_200,masses2_6,G5tensor(:,43),T5sum(1:126,191))
  M(3) = M(3) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(5)) * den(378)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,134),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(5)) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(5) * den(379)) * TI2_call(3,momenta_8,masses2_2,G3tensor(:,135),T3sum(1:35,3))
  M(12) = M(12) + (-f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,53),T4sum(1:70,35))
  M(13) = M(13) + (f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,53),T4sum(1:70,35))
  M(14) = M(14) + (-f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,53),T4sum(1:70,35))
  M(22) = M(22) + (f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,53),T4sum(1:70,35))
  M(3) = M(3) + (f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,80),T4sum(1:70,35))
  M(4) = M(4) + (-f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,80),T4sum(1:70,35))
  M(11) = M(11) + (-f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,80),T4sum(1:70,35))
  M(21) = M(21) + (f(6) * den(170)) * TI2_call(4,momenta_73,masses2_4,G4tensor(:,80),T4sum(1:70,35))
  M(2) = M(2) + (-f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,47),T4sum(1:70,17))
  M(5) = M(5) + (f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,47),T4sum(1:70,17))
  M(11) = M(11) + (f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,47),T4sum(1:70,17))
  M(21) = M(21) + (-f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,47),T4sum(1:70,17))
  M(13) = M(13) + (-f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,74),T4sum(1:70,17))
  M(14) = M(14) + (f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,74),T4sum(1:70,17))
  M(16) = M(16) + (f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,74),T4sum(1:70,17))
  M(18) = M(18) + (-f(6) * den(160)) * TI2_call(4,momenta_72,masses2_4,G4tensor(:,74),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(5) * den(55)) * TI2_call(5,momenta_193,masses2_6,G5tensor(:,25),T5sum(1:126,213))
  M(5) = M(5) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_193,masses2_6,G5tensor(:,25),T5sum(1:126,213))
  M(16) = M(16) + (CI*f(5) * den(55)) * TI2_call(5,momenta_193,masses2_6,G5tensor(:,37),T5sum(1:126,213))
  M(18) = M(18) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_193,masses2_6,G5tensor(:,37),T5sum(1:126,213))
  M(12) = M(12) + (CI*f(5) * den(55)) * TI2_call(5,momenta_196,masses2_6,G5tensor(:,28),T5sum(1:126,215))
  M(22) = M(22) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_196,masses2_6,G5tensor(:,28),T5sum(1:126,215))
  M(3) = M(3) + (CI*f(5) * den(55)) * TI2_call(5,momenta_196,masses2_6,G5tensor(:,40),T5sum(1:126,215))
  M(4) = M(4) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_196,masses2_6,G5tensor(:,40),T5sum(1:126,215))
  M(1) = M(1) + (CI*f(2) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(384)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(385)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(143)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,12),T4sum(1:70,30))
  M(2) = M(2) + (-f(3) * den(143)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,12),T4sum(1:70,30))
  M(17) = M(17) + (-f(3) * den(143)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,12),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(143)) * TI2_call(4,momenta_50,masses2_3,G4tensor(:,12),T4sum(1:70,30))
  M(7) = M(7) + (-f(3) * den(121)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(8) = M(8) + (f(3) * den(121)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(10) = M(10) + (f(3) * den(121)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(12) = M(12) + (-f(3) * den(121)) * TI2_call(4,momenta_49,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(10) = M(10) + (CI*f(2) * den(61)) * TI2_call(5,momenta_163,masses2_5,G5tensor(:,5),T5sum(1:126,238))
  M(12) = M(12) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_163,masses2_5,G5tensor(:,5),T5sum(1:126,238))
  M(1) = M(1) + (CI*f(2) * den(61)) * TI2_call(5,momenta_168,masses2_5,G5tensor(:,10),T5sum(1:126,240))
  M(2) = M(2) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_168,masses2_5,G5tensor(:,10),T5sum(1:126,240))
  M(10) = M(10) + (-f(3)) * TI2_call(6,momenta_254,masses2_7,G6tensor(:,3),T6sum(1:210,86))
  M(5) = M(5) + (-f(3)) * TI2_call(6,momenta_264,masses2_7,G6tensor(:,11),T6sum(1:210,88))
  M(1) = M(1) + (-f(3)) * TI2_call(6,momenta_258,masses2_7,G6tensor(:,7),T6sum(1:210,90))
  M(22) = M(22) + (-f(3)) * TI2_call(6,momenta_263,masses2_7,G6tensor(:,12),T6sum(1:210,92))
  M(9) = M(9) + (-f(3)) * TI2_call(6,momenta_256,masses2_7,G6tensor(:,1),T6sum(1:210,94))
  M(19) = M(19) + (-f(3)) * TI2_call(6,momenta_260,masses2_7,G6tensor(:,5),T6sum(1:210,96))
  M(12) = M(12) + (-f(3)) * TI2_call(6,momenta_253,masses2_7,G6tensor(:,4),T6sum(1:210,98))
  M(2) = M(2) + (-f(3)) * TI2_call(6,momenta_257,masses2_7,G6tensor(:,8),T6sum(1:210,100))
  M(16) = M(16) + (-f(3)) * TI2_call(6,momenta_261,masses2_7,G6tensor(:,10),T6sum(1:210,102))
  M(3) = M(3) + (-f(3)) * TI2_call(6,momenta_262,masses2_7,G6tensor(:,9),T6sum(1:210,104))
  M(11) = M(11) + (-f(3)) * TI2_call(6,momenta_255,masses2_7,G6tensor(:,2),T6sum(1:210,106))
  M(13) = M(13) + (-f(3)) * TI2_call(6,momenta_259,masses2_7,G6tensor(:,6),T6sum(1:210,108))
  M(12) = M(12) + (-f(6)) * TI2_call(6,momenta_267,masses2_8,G6tensor(:,16),T6sum(1:210,109))
  M(4) = M(4) + (-f(6)) * TI2_call(6,momenta_267,masses2_8,G6tensor(:,22),T6sum(1:210,109))
  M(6) = M(6) + (-f(6)) * TI2_call(6,momenta_269,masses2_8,G6tensor(:,18),T6sum(1:210,111))
  M(10) = M(10) + (-f(6)) * TI2_call(6,momenta_269,masses2_8,G6tensor(:,24),T6sum(1:210,111))
  M(2) = M(2) + (-f(6)) * TI2_call(6,momenta_265,masses2_8,G6tensor(:,14),T6sum(1:210,113))
  M(18) = M(18) + (-f(6)) * TI2_call(6,momenta_265,masses2_8,G6tensor(:,20),T6sum(1:210,113))
  M(24) = M(24) + (-f(6)) * TI2_call(6,momenta_270,masses2_8,G6tensor(:,17),T6sum(1:210,115))
  M(1) = M(1) + (-f(6)) * TI2_call(6,momenta_270,masses2_8,G6tensor(:,23),T6sum(1:210,115))
  M(8) = M(8) + (-f(6)) * TI2_call(6,momenta_266,masses2_8,G6tensor(:,13),T6sum(1:210,117))
  M(17) = M(17) + (-f(6)) * TI2_call(6,momenta_266,masses2_8,G6tensor(:,19),T6sum(1:210,117))
  M(23) = M(23) + (-f(6)) * TI2_call(6,momenta_268,masses2_8,G6tensor(:,15),T6sum(1:210,119))
  M(7) = M(7) + (-f(6)) * TI2_call(6,momenta_268,masses2_8,G6tensor(:,21),T6sum(1:210,119))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)
  deallocate(G6tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphjjj2_hggggg_2_/**/REALKIND
