
module ol_vamp_2_pphjjj2_hggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G6tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,170) :: G1
  complex(REALKIND), dimension(4,15,4,409) :: G2
  complex(REALKIND), dimension(4,35,4,306) :: G3
  complex(REALKIND), dimension(4,70,4,156) :: G4
  complex(REALKIND), dimension(4,126,4,48) :: G5
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
  complex(REALKIND), pointer :: G6tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,108,32))
    allocate(G4tensorhel(70,87,32))
    allocate(G5tensorhel(126,54,32))
    allocate(G6tensorhel(210,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)
  G6tensor => G6tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,214),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,215),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,3))
  call loop_QS_A(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,216),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,62),MT,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,244),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,7))
  call loop_QS_A(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,245),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,62),MT,G2(:,:,:,9))
  call loop_QS_A(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,246),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,62),MT,G2(:,:,:,11))
  call loop_QS_A(G2(:,:,:,11),wf(:,0),G2(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,271),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,272),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,62),MT,G2(:,:,:,15))
  call loop_QS_A(G2(:,:,:,15),wf(:,0),G2(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,273),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,62),MT,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,277),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,19))
  call loop_QS_A(G2(:,:,:,19),wf(:,0),G2(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,278),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,21))
  call loop_QS_A(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,279),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,62),MT,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,0),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,-1),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,18),MT,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,30),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,32),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,62),MT,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G2(:,:,:,25),wf(:,33),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,62),MT,G3(:,:,:,5))
  call loop_QS_A(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_QV_A(G2(:,:,:,25),wf(:,183),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,62),MT,G3(:,:,:,7))
  call loop_QS_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_QV_A(G2(:,:,:,25),wf(:,65),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,30),MT,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_Q_A(G3(:,:,:,10),Q(:,62),MT,G4(:,:,:,1))
  call loop_QS_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,191),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,62),MT,G3(:,:,:,11))
  call loop_QS_A(G3(:,:,:,11),wf(:,0),G3(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,5))
  call loop_QV_A(G2(:,:,:,25),wf(:,-3),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,26),MT,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,84),G3(:,:,:,14))
  call loop_Q_A(G3(:,:,:,14),Q(:,62),MT,G4(:,:,:,3))
  call loop_QS_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_QV_A(G3(:,:,:,13),wf(:,-2),G3(:,:,:,15))
  call loop_Q_A(G3(:,:,:,15),Q(:,30),MT,G4(:,:,:,5))
  call loop_QV_A(G4(:,:,:,5),wf(:,-5),G4(:,:,:,6))
  call loop_Q_A(G4(:,:,:,6),Q(:,62),MT,G5(:,:,:,1))
  call loop_QS_A(G5(:,:,:,1),wf(:,0),G5(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,2),Q(:,63),MT,G6tensor(:,1))
  call loop_QV_A(G2(:,:,:,25),wf(:,193),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,62),MT,G3(:,:,:,16))
  call loop_QS_A(G3(:,:,:,16),wf(:,0),G3(:,:,:,17),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),MT,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,25),wf(:,-2),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,22),MT,G3(:,:,:,18))
  call loop_QV_A(G3(:,:,:,18),wf(:,109),G3(:,:,:,19))
  call loop_Q_A(G3(:,:,:,19),Q(:,62),MT,G4(:,:,:,7))
  call loop_QS_A(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,3))
  call loop_QV_A(G3(:,:,:,18),wf(:,-3),G3(:,:,:,20))
  call loop_Q_A(G3(:,:,:,20),Q(:,30),MT,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,-5),G4(:,:,:,10))
  call loop_Q_A(G4(:,:,:,10),Q(:,62),MT,G5(:,:,:,3))
  call loop_QS_A(G5(:,:,:,3),wf(:,0),G5(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,4),Q(:,63),MT,G6tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,289),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,62),MT,G2(:,:,:,35))
  call loop_QS_A(G2(:,:,:,35),wf(:,0),G2(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,290),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,62),MT,G2(:,:,:,37))
  call loop_QS_A(G2(:,:,:,37),wf(:,0),G2(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,291),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,39))
  call loop_QS_A(G2(:,:,:,39),wf(:,0),G2(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,316),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,62),MT,G2(:,:,:,41))
  call loop_QS_A(G2(:,:,:,41),wf(:,0),G2(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,317),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,43))
  call loop_QS_A(G2(:,:,:,43),wf(:,0),G2(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,318),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,62),MT,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,0),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,322),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,62),MT,G2(:,:,:,47))
  call loop_QS_A(G2(:,:,:,47),wf(:,0),G2(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,323),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,0),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,324),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,62),MT,G2(:,:,:,51))
  call loop_QS_A(G2(:,:,:,51),wf(:,0),G2(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,20),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,77),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,62),MT,G3(:,:,:,21))
  call loop_QS_A(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,7))
  call loop_QV_A(G2(:,:,:,53),wf(:,79),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,62),MT,G3(:,:,:,23))
  call loop_QS_A(G3(:,:,:,23),wf(:,0),G3(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,53),wf(:,80),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,62),MT,G3(:,:,:,25))
  call loop_QS_A(G3(:,:,:,25),wf(:,0),G3(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MT,G4tensor(:,9))
  call loop_QV_A(G2(:,:,:,53),wf(:,176),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,62),MT,G3(:,:,:,27))
  call loop_QS_A(G3(:,:,:,27),wf(:,0),G3(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,53),wf(:,18),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,30),MT,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,62),MT,G4(:,:,:,11))
  call loop_QS_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,4))
  call loop_QV_A(G2(:,:,:,53),wf(:,196),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,62),MT,G3(:,:,:,31))
  call loop_QS_A(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,11))
  call loop_QV_A(G2(:,:,:,53),wf(:,-3),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,28),MT,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,37),G3(:,:,:,34))
  call loop_Q_A(G3(:,:,:,34),Q(:,62),MT,G4(:,:,:,13))
  call loop_QS_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,5))
  call loop_QV_A(G3(:,:,:,33),wf(:,-1),G3(:,:,:,35))
  call loop_Q_A(G3(:,:,:,35),Q(:,30),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,-5),G4(:,:,:,16))
  call loop_Q_A(G4(:,:,:,16),Q(:,62),MT,G5(:,:,:,5))
  call loop_QS_A(G5(:,:,:,5),wf(:,0),G5(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,6),Q(:,63),MT,G6tensor(:,3))
  call loop_QV_A(G2(:,:,:,53),wf(:,197),G2(:,:,:,61))
  call loop_Q_A(G2(:,:,:,61),Q(:,62),MT,G3(:,:,:,36))
  call loop_QS_A(G3(:,:,:,36),wf(:,0),G3(:,:,:,37),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,37),Q(:,63),MT,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,53),wf(:,-1),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,22),MT,G3(:,:,:,38))
  call loop_QV_A(G3(:,:,:,38),wf(:,109),G3(:,:,:,39))
  call loop_Q_A(G3(:,:,:,39),Q(:,62),MT,G4(:,:,:,17))
  call loop_QS_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,63),MT,G5tensor(:,6))
  call loop_QV_A(G3(:,:,:,38),wf(:,-3),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,30),MT,G4(:,:,:,19))
  call loop_QV_A(G4(:,:,:,19),wf(:,-5),G4(:,:,:,20))
  call loop_Q_A(G4(:,:,:,20),Q(:,62),MT,G5(:,:,:,7))
  call loop_QS_A(G5(:,:,:,7),wf(:,0),G5(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,8),Q(:,63),MT,G6tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,337),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,62),MT,G2(:,:,:,63))
  call loop_QS_A(G2(:,:,:,63),wf(:,0),G2(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,1),wf(:,338),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,62),MT,G2(:,:,:,65))
  call loop_QS_A(G2(:,:,:,65),wf(:,0),G2(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,1),wf(:,339),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,62),MT,G2(:,:,:,67))
  call loop_QS_A(G2(:,:,:,67),wf(:,0),G2(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,1),wf(:,343),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,62),MT,G2(:,:,:,69))
  call loop_QS_A(G2(:,:,:,69),wf(:,0),G2(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,1),wf(:,344),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,62),MT,G2(:,:,:,71))
  call loop_QS_A(G2(:,:,:,71),wf(:,0),G2(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,1),wf(:,345),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,62),MT,G2(:,:,:,73))
  call loop_QS_A(G2(:,:,:,73),wf(:,0),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,1),wf(:,-3),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,24),MT,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,102),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,62),MT,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,0),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,13))
  call loop_QV_A(G2(:,:,:,75),wf(:,104),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,62),MT,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,75),wf(:,105),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,62),MT,G3(:,:,:,45))
  call loop_QS_A(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MT,G4tensor(:,15))
  call loop_QV_A(G2(:,:,:,75),wf(:,167),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,62),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,75),wf(:,1),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,30),MT,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,-5),G3(:,:,:,50))
  call loop_Q_A(G3(:,:,:,50),Q(:,62),MT,G4(:,:,:,21))
  call loop_QS_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,75),wf(:,200),G2(:,:,:,81))
  call loop_Q_A(G2(:,:,:,81),Q(:,62),MT,G3(:,:,:,51))
  call loop_QS_A(G3(:,:,:,51),wf(:,0),G3(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,75),wf(:,-2),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,28),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,37),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,62),MT,G4(:,:,:,23))
  call loop_QS_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G3(:,:,:,53),wf(:,-1),G3(:,:,:,55))
  call loop_Q_A(G3(:,:,:,55),Q(:,30),MT,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,-5),G4(:,:,:,26))
  call loop_Q_A(G4(:,:,:,26),Q(:,62),MT,G5(:,:,:,9))
  call loop_QS_A(G5(:,:,:,9),wf(:,0),G5(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,10),Q(:,63),MT,G6tensor(:,5))
  call loop_QV_A(G2(:,:,:,75),wf(:,202),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,62),MT,G3(:,:,:,56))
  call loop_QS_A(G3(:,:,:,56),wf(:,0),G3(:,:,:,57),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,75),wf(:,-1),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,26),MT,G3(:,:,:,58))
  call loop_QV_A(G3(:,:,:,58),wf(:,84),G3(:,:,:,59))
  call loop_Q_A(G3(:,:,:,59),Q(:,62),MT,G4(:,:,:,27))
  call loop_QS_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MT,G5tensor(:,9))
  call loop_QV_A(G3(:,:,:,58),wf(:,-2),G3(:,:,:,60))
  call loop_Q_A(G3(:,:,:,60),Q(:,30),MT,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,-5),G4(:,:,:,30))
  call loop_Q_A(G4(:,:,:,30),Q(:,62),MT,G5(:,:,:,11))
  call loop_QS_A(G5(:,:,:,11),wf(:,0),G5(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,12),Q(:,63),MT,G6tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,358),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,62),MT,G2(:,:,:,85))
  call loop_QS_A(G2(:,:,:,85),wf(:,0),G2(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,1),wf(:,359),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,62),MT,G2(:,:,:,87))
  call loop_QS_A(G2(:,:,:,87),wf(:,0),G2(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,1),wf(:,360),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,62),MT,G2(:,:,:,89))
  call loop_QS_A(G2(:,:,:,89),wf(:,0),G2(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,1),wf(:,120),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,30),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,62),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,0),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,122),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,30),MT,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,62),MT,G3(:,:,:,63))
  call loop_QS_A(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,123),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,30),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,62),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,362),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,62),MT,G2(:,:,:,97))
  call loop_QS_A(G2(:,:,:,97),wf(:,0),G2(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,63),MT,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,1),wf(:,1),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,22),MT,G2(:,:,:,99))
  call loop_QV_A(G2(:,:,:,99),wf(:,109),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,62),MT,G3(:,:,:,67))
  call loop_QS_A(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,99),wf(:,-3),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,30),MT,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,62),MT,G4(:,:,:,31))
  call loop_QS_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MT,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,365),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,62),MT,G2(:,:,:,102))
  call loop_QS_A(G2(:,:,:,102),wf(:,0),G2(:,:,:,103),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,1),wf(:,172),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,30),MT,G2(:,:,:,104))
  call loop_QV_A(G2(:,:,:,104),wf(:,-5),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,62),MT,G3(:,:,:,71))
  call loop_QS_A(G3(:,:,:,71),wf(:,0),G3(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,1),wf(:,368),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,62),MT,G2(:,:,:,106))
  call loop_QS_A(G2(:,:,:,106),wf(:,0),G2(:,:,:,107),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,1),wf(:,371),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,62),MT,G2(:,:,:,108))
  call loop_QS_A(G2(:,:,:,108),wf(:,0),G2(:,:,:,109),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,109),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,1),wf(:,18),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,26),MT,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,84),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,62),MT,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,0),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G2(:,:,:,110),wf(:,-2),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,30),MT,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-5),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,62),MT,G4(:,:,:,33))
  call loop_QS_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,374),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,62),MT,G2(:,:,:,113))
  call loop_QS_A(G2(:,:,:,113),wf(:,0),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,1),wf(:,181),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,30),MT,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,62),MT,G3(:,:,:,77))
  call loop_QS_A(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),MT,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,1),wf(:,377),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,62),MT,G2(:,:,:,117))
  call loop_QS_A(G2(:,:,:,117),wf(:,0),G2(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),MT,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,1),wf(:,380),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,119))
  call loop_QS_A(G2(:,:,:,119),wf(:,0),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,1),wf(:,65),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,28),MT,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,37),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,62),MT,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,0),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),MT,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,121),wf(:,-1),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,30),MT,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-5),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,62),MT,G4(:,:,:,35))
  call loop_QS_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,383),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,62),MT,G2(:,:,:,124))
  call loop_QS_A(G2(:,:,:,124),wf(:,0),G2(:,:,:,125),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,125),Q(:,63),MT,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,1),wf(:,189),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,30),MT,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,-5),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,62),MT,G3(:,:,:,83))
  call loop_QS_A(G3(:,:,:,83),wf(:,0),G3(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,63),MT,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,1),wf(:,385),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,62),MT,G2(:,:,:,128))
  call loop_QS_A(G2(:,:,:,128),wf(:,0),G2(:,:,:,129),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,63),MT,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,1),wf(:,412),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,62),MT,G2(:,:,:,130))
  call loop_QS_A(G2(:,:,:,130),wf(:,0),G2(:,:,:,131),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,63),MT,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,1),wf(:,414),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,62),MT,G2(:,:,:,132))
  call loop_QS_A(G2(:,:,:,132),wf(:,0),G2(:,:,:,133),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,63),MT,G3tensor(:,41))
  call loop_QV_A(G1(:,:,:,1),wf(:,418),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,62),MT,G2(:,:,:,134))
  call loop_QS_A(G2(:,:,:,134),wf(:,0),G2(:,:,:,135),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G1(:,:,:,1),wf(:,420),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,62),MT,G2(:,:,:,136))
  call loop_QS_A(G2(:,:,:,136),wf(:,0),G2(:,:,:,137),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,63),MT,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,1),wf(:,424),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,62),MT,G2(:,:,:,138))
  call loop_QS_A(G2(:,:,:,138),wf(:,0),G2(:,:,:,139),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,1),wf(:,425),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,62),MT,G2(:,:,:,140))
  call loop_QS_A(G2(:,:,:,140),wf(:,0),G2(:,:,:,141),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,63),MT,G3tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,217),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,30),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-5),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,62),MT,G2(:,:,:,142))
  call loop_QS_A(G2(:,:,:,142),wf(:,0),G2(:,:,:,143),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,218),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,30),MT,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,144))
  call loop_QS_A(G2(:,:,:,144),wf(:,0),G2(:,:,:,145),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),MT,G3tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,219),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,62),MT,G2(:,:,:,146))
  call loop_QS_A(G2(:,:,:,146),wf(:,0),G2(:,:,:,147),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,217),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,30),MT,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-5),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,62),MT,G2(:,:,:,148))
  call loop_AS_Q(G2(:,:,:,148),wf(:,0),G2(:,:,:,149),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,149),Q(:,63),MT,G3tensor(:,49))
  call loop_AV_Q(G0(:,:,:,1),wf(:,218),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,30),MT,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,62),MT,G2(:,:,:,150))
  call loop_AS_Q(G2(:,:,:,150),wf(:,0),G2(:,:,:,151),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,151),Q(:,63),MT,G3tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,219),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,30),MT,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,62),MT,G2(:,:,:,152))
  call loop_AS_Q(G2(:,:,:,152),wf(:,0),G2(:,:,:,153),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,6),MT,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,2),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,62),MT,G2(:,:,:,154))
  call loop_AS_Q(G2(:,:,:,154),wf(:,0),G2(:,:,:,155),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,63),MT,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,71),wf(:,4),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,156))
  call loop_AS_Q(G2(:,:,:,156),wf(:,0),G2(:,:,:,157),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,63),MT,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,71),wf(:,5),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,62),MT,G2(:,:,:,158))
  call loop_AS_Q(G2(:,:,:,158),wf(:,0),G2(:,:,:,159),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),MT,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,71),wf(:,166),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,62),MT,G2(:,:,:,160))
  call loop_AS_Q(G2(:,:,:,160),wf(:,0),G2(:,:,:,161),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,161),Q(:,63),MT,G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,71),wf(:,101),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,30),MT,G2(:,:,:,162))
  call loop_AV_Q(G2(:,:,:,162),wf(:,-5),G2(:,:,:,163))
  call loop_A_Q(G2(:,:,:,163),Q(:,62),MT,G3(:,:,:,85))
  call loop_AS_Q(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),MT,G4tensor(:,28))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-5),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,38),MT,G2(:,:,:,164))
  call loop_AV_Q(G2(:,:,:,164),wf(:,101),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,62),MT,G3(:,:,:,87))
  call loop_AS_Q(G3(:,:,:,87),wf(:,0),G3(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),MT,G4tensor(:,29))
  call loop_AV_Q(G2(:,:,:,164),wf(:,-4),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,54),MT,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,62),MT,G4(:,:,:,37))
  call loop_AS_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,164),wf(:,-3),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,46),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-4),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,62),MT,G4(:,:,:,39))
  call loop_AS_Q(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,71),wf(:,169),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,168))
  call loop_AS_Q(G2(:,:,:,168),wf(:,0),G2(:,:,:,169),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,169),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,71),wf(:,109),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,46),MT,G2(:,:,:,170))
  call loop_AV_Q(G2(:,:,:,170),wf(:,-4),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,62),MT,G3(:,:,:,93))
  call loop_AS_Q(G3(:,:,:,93),wf(:,0),G3(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),MT,G4tensor(:,30))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-4),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,22),MT,G2(:,:,:,172))
  call loop_AV_Q(G2(:,:,:,172),wf(:,109),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,62),MT,G3(:,:,:,95))
  call loop_AS_Q(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,54),MT,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-3),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,62),MT,G4(:,:,:,41))
  call loop_AS_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MT,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-3),G2(:,:,:,175))
  call loop_A_Q(G2(:,:,:,175),Q(:,30),MT,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,-5),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,62),MT,G4(:,:,:,43))
  call loop_AS_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MT,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,71),wf(:,171),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,62),MT,G2(:,:,:,176))
  call loop_AS_Q(G2(:,:,:,176),wf(:,0),G2(:,:,:,177),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,63),MT,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,71),wf(:,119),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,54),MT,G2(:,:,:,178))
  call loop_AV_Q(G2(:,:,:,178),wf(:,-3),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,62),MT,G3(:,:,:,101))
  call loop_AS_Q(G3(:,:,:,101),wf(:,0),G3(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,32))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-3),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,14),MT,G2(:,:,:,180))
  call loop_AV_Q(G2(:,:,:,180),wf(:,119),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,62),MT,G3(:,:,:,103))
  call loop_AS_Q(G3(:,:,:,103),wf(:,0),G3(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,63),MT,G4tensor(:,33))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-5),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,46),MT,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-4),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,62),MT,G4(:,:,:,45))
  call loop_AS_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),MT,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-4),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,30),MT,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-5),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,62),MT,G4(:,:,:,47))
  call loop_AS_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,6),MT,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,2),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,62),MT,G2(:,:,:,184))
  call loop_QS_A(G2(:,:,:,184),wf(:,0),G2(:,:,:,185),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,185),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,84),wf(:,4),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,186))
  call loop_QS_A(G2(:,:,:,186),wf(:,0),G2(:,:,:,187),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,187),Q(:,63),MT,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,84),wf(:,5),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,62),MT,G2(:,:,:,188))
  call loop_QS_A(G2(:,:,:,188),wf(:,0),G2(:,:,:,189),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,189),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,84),wf(:,166),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,62),MT,G2(:,:,:,190))
  call loop_QS_A(G2(:,:,:,190),wf(:,0),G2(:,:,:,191),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,191),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,84),wf(:,101),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,30),MT,G2(:,:,:,192))
  call loop_QV_A(G2(:,:,:,192),wf(:,-5),G2(:,:,:,193))
  call loop_Q_A(G2(:,:,:,193),Q(:,62),MT,G3(:,:,:,109))
  call loop_QS_A(G3(:,:,:,109),wf(:,0),G3(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G1(:,:,:,84),wf(:,-5),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,38),MT,G2(:,:,:,194))
  call loop_QV_A(G2(:,:,:,194),wf(:,101),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,62),MT,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,0),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,194),wf(:,-4),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,54),MT,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-3),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,62),MT,G4(:,:,:,49))
  call loop_QS_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,194),wf(:,-3),G2(:,:,:,197))
  call loop_Q_A(G2(:,:,:,197),Q(:,46),MT,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,-4),G3(:,:,:,116))
  call loop_Q_A(G3(:,:,:,116),Q(:,62),MT,G4(:,:,:,51))
  call loop_QS_A(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,84),wf(:,169),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,62),MT,G2(:,:,:,198))
  call loop_QS_A(G2(:,:,:,198),wf(:,0),G2(:,:,:,199),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,199),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,84),wf(:,109),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,46),MT,G2(:,:,:,200))
  call loop_QV_A(G2(:,:,:,200),wf(:,-4),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,62),MT,G3(:,:,:,117))
  call loop_QS_A(G3(:,:,:,117),wf(:,0),G3(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,63),MT,G4tensor(:,36))
  call loop_QV_A(G1(:,:,:,84),wf(:,-4),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,22),MT,G2(:,:,:,202))
  call loop_QV_A(G2(:,:,:,202),wf(:,109),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,62),MT,G3(:,:,:,119))
  call loop_QS_A(G3(:,:,:,119),wf(:,0),G3(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MT,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,202),wf(:,-5),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,54),MT,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,-3),G3(:,:,:,122))
  call loop_Q_A(G3(:,:,:,122),Q(:,62),MT,G4(:,:,:,53))
  call loop_QS_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,202),wf(:,-3),G2(:,:,:,205))
  call loop_Q_A(G2(:,:,:,205),Q(:,30),MT,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-5),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,62),MT,G4(:,:,:,55))
  call loop_QS_A(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,84),wf(:,171),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,206))
  call loop_QS_A(G2(:,:,:,206),wf(:,0),G2(:,:,:,207),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,207),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,84),wf(:,119),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,54),MT,G2(:,:,:,208))
  call loop_QV_A(G2(:,:,:,208),wf(:,-3),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,62),MT,G3(:,:,:,125))
  call loop_QS_A(G3(:,:,:,125),wf(:,0),G3(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,63),MT,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,84),wf(:,-3),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,14),MT,G2(:,:,:,210))
  call loop_QV_A(G2(:,:,:,210),wf(:,119),G2(:,:,:,211))
  call loop_Q_A(G2(:,:,:,211),Q(:,62),MT,G3(:,:,:,127))
  call loop_QS_A(G3(:,:,:,127),wf(:,0),G3(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,63),MT,G4tensor(:,39))
  call loop_QV_A(G2(:,:,:,210),wf(:,-5),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,46),MT,G3(:,:,:,129))
  call loop_QV_A(G3(:,:,:,129),wf(:,-4),G3(:,:,:,130))
  call loop_Q_A(G3(:,:,:,130),Q(:,62),MT,G4(:,:,:,57))
  call loop_QS_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,210),wf(:,-4),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,30),MT,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-5),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,62),MT,G4(:,:,:,59))
  call loop_QS_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MT,G5tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,4),MT,G1(:,:,:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,220),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,62),MT,G2(:,:,:,214))
  call loop_AS_Q(G2(:,:,:,214),wf(:,0),G2(:,:,:,215),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,63),MT,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,97),wf(:,221),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,62),MT,G2(:,:,:,216))
  call loop_AS_Q(G2(:,:,:,216),wf(:,0),G2(:,:,:,217),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,217),Q(:,63),MT,G3tensor(:,65))
  call loop_AV_Q(G1(:,:,:,97),wf(:,222),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MT,G2(:,:,:,218))
  call loop_AS_Q(G2(:,:,:,218),wf(:,0),G2(:,:,:,219),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,63),MT,G3tensor(:,66))
  call loop_AV_Q(G1(:,:,:,97),wf(:,226),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,62),MT,G2(:,:,:,220))
  call loop_AS_Q(G2(:,:,:,220),wf(:,0),G2(:,:,:,221),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,221),Q(:,63),MT,G3tensor(:,67))
  call loop_AV_Q(G1(:,:,:,97),wf(:,227),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,62),MT,G2(:,:,:,222))
  call loop_AS_Q(G2(:,:,:,222),wf(:,0),G2(:,:,:,223),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,223),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,97),wf(:,228),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,62),MT,G2(:,:,:,224))
  call loop_AS_Q(G2(:,:,:,224),wf(:,0),G2(:,:,:,225),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,225),Q(:,63),MT,G3tensor(:,69))
  call loop_AV_Q(G1(:,:,:,97),wf(:,232),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,62),MT,G2(:,:,:,226))
  call loop_AS_Q(G2(:,:,:,226),wf(:,0),G2(:,:,:,227),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,227),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G1(:,:,:,97),wf(:,233),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,62),MT,G2(:,:,:,228))
  call loop_AS_Q(G2(:,:,:,228),wf(:,0),G2(:,:,:,229),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,229),Q(:,63),MT,G3tensor(:,71))
  call loop_AV_Q(G1(:,:,:,97),wf(:,234),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,62),MT,G2(:,:,:,230))
  call loop_AS_Q(G2(:,:,:,230),wf(:,0),G2(:,:,:,231),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,231),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G1(:,:,:,97),wf(:,238),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,232))
  call loop_AS_Q(G2(:,:,:,232),wf(:,0),G2(:,:,:,233),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,233),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,97),wf(:,239),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,62),MT,G2(:,:,:,234))
  call loop_AS_Q(G2(:,:,:,234),wf(:,0),G2(:,:,:,235),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,235),Q(:,63),MT,G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,97),wf(:,240),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,62),MT,G2(:,:,:,236))
  call loop_AS_Q(G2(:,:,:,236),wf(:,0),G2(:,:,:,237),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,237),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-1),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,6),MT,G2(:,:,:,238))
  call loop_AV_Q(G2(:,:,:,238),wf(:,2),G2(:,:,:,239))
  call loop_A_Q(G2(:,:,:,239),Q(:,62),MT,G3(:,:,:,133))
  call loop_AS_Q(G3(:,:,:,133),wf(:,0),G3(:,:,:,134),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,63),MT,G4tensor(:,40))
  call loop_AV_Q(G2(:,:,:,238),wf(:,4),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,62),MT,G3(:,:,:,135))
  call loop_AS_Q(G3(:,:,:,135),wf(:,0),G3(:,:,:,136),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,63),MT,G4tensor(:,41))
  call loop_AV_Q(G2(:,:,:,238),wf(:,5),G2(:,:,:,241))
  call loop_A_Q(G2(:,:,:,241),Q(:,62),MT,G3(:,:,:,137))
  call loop_AS_Q(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,238),wf(:,166),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,62),MT,G3(:,:,:,139))
  call loop_AS_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,63),MT,G4tensor(:,43))
  call loop_AV_Q(G2(:,:,:,238),wf(:,101),G2(:,:,:,243))
  call loop_A_Q(G2(:,:,:,243),Q(:,30),MT,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-5),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,62),MT,G4(:,:,:,61))
  call loop_AS_Q(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,238),wf(:,-5),G2(:,:,:,244))
  call loop_A_Q(G2(:,:,:,244),Q(:,38),MT,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,101),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,62),MT,G4(:,:,:,63))
  call loop_AS_Q(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,145))
  call loop_A_Q(G3(:,:,:,145),Q(:,54),MT,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,-3),G4(:,:,:,66))
  call loop_A_Q(G4(:,:,:,66),Q(:,62),MT,G5(:,:,:,13))
  call loop_AS_Q(G5(:,:,:,13),wf(:,0),G5(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,14),Q(:,63),MT,G6tensor(:,7))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-3),G3(:,:,:,146))
  call loop_A_Q(G3(:,:,:,146),Q(:,46),MT,G4(:,:,:,67))
  call loop_AV_Q(G4(:,:,:,67),wf(:,-4),G4(:,:,:,68))
  call loop_A_Q(G4(:,:,:,68),Q(:,62),MT,G5(:,:,:,15))
  call loop_AS_Q(G5(:,:,:,15),wf(:,0),G5(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,16),Q(:,63),MT,G6tensor(:,8))
  call loop_AV_Q(G2(:,:,:,238),wf(:,169),G2(:,:,:,245))
  call loop_A_Q(G2(:,:,:,245),Q(:,62),MT,G3(:,:,:,147))
  call loop_AS_Q(G3(:,:,:,147),wf(:,0),G3(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,63),MT,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,238),wf(:,109),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,46),MT,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-4),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,62),MT,G4(:,:,:,69))
  call loop_AS_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,238),wf(:,-4),G2(:,:,:,247))
  call loop_A_Q(G2(:,:,:,247),Q(:,22),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,109),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,62),MT,G4(:,:,:,71))
  call loop_AS_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-5),G3(:,:,:,153))
  call loop_A_Q(G3(:,:,:,153),Q(:,54),MT,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,-3),G4(:,:,:,74))
  call loop_A_Q(G4(:,:,:,74),Q(:,62),MT,G5(:,:,:,17))
  call loop_AS_Q(G5(:,:,:,17),wf(:,0),G5(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,18),Q(:,63),MT,G6tensor(:,9))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-3),G3(:,:,:,154))
  call loop_A_Q(G3(:,:,:,154),Q(:,30),MT,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,-5),G4(:,:,:,76))
  call loop_A_Q(G4(:,:,:,76),Q(:,62),MT,G5(:,:,:,19))
  call loop_AS_Q(G5(:,:,:,19),wf(:,0),G5(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,20),Q(:,63),MT,G6tensor(:,10))
  call loop_AV_Q(G2(:,:,:,238),wf(:,171),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,62),MT,G3(:,:,:,155))
  call loop_AS_Q(G3(:,:,:,155),wf(:,0),G3(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,63),MT,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,238),wf(:,119),G2(:,:,:,249))
  call loop_A_Q(G2(:,:,:,249),Q(:,54),MT,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-3),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,62),MT,G4(:,:,:,77))
  call loop_AS_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,63),MT,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,238),wf(:,-3),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,14),MT,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,119),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,62),MT,G4(:,:,:,79))
  call loop_AS_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,30))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-5),G3(:,:,:,161))
  call loop_A_Q(G3(:,:,:,161),Q(:,46),MT,G4(:,:,:,81))
  call loop_AV_Q(G4(:,:,:,81),wf(:,-4),G4(:,:,:,82))
  call loop_A_Q(G4(:,:,:,82),Q(:,62),MT,G5(:,:,:,21))
  call loop_AS_Q(G5(:,:,:,21),wf(:,0),G5(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,22),Q(:,63),MT,G6tensor(:,11))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-4),G3(:,:,:,162))
  call loop_A_Q(G3(:,:,:,162),Q(:,30),MT,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,-5),G4(:,:,:,84))
  call loop_A_Q(G4(:,:,:,84),Q(:,62),MT,G5(:,:,:,23))
  call loop_AS_Q(G5(:,:,:,23),wf(:,0),G5(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,24),Q(:,63),MT,G6tensor(:,12))
  call loop_AV_Q(G1(:,:,:,97),wf(:,298),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,62),MT,G2(:,:,:,251))
  call loop_AS_Q(G2(:,:,:,251),wf(:,0),G2(:,:,:,252),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),MT,G3tensor(:,76))
  call loop_AV_Q(G1(:,:,:,97),wf(:,299),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,253))
  call loop_AS_Q(G2(:,:,:,253),wf(:,0),G2(:,:,:,254),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,63),MT,G3tensor(:,77))
  call loop_AV_Q(G1(:,:,:,97),wf(:,300),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,62),MT,G2(:,:,:,255))
  call loop_AS_Q(G2(:,:,:,255),wf(:,0),G2(:,:,:,256),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,78))
  call loop_AV_Q(G1(:,:,:,97),wf(:,304),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,62),MT,G2(:,:,:,257))
  call loop_AS_Q(G2(:,:,:,257),wf(:,0),G2(:,:,:,258),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,63),MT,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,97),wf(:,305),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,62),MT,G2(:,:,:,259))
  call loop_AS_Q(G2(:,:,:,259),wf(:,0),G2(:,:,:,260),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,97),wf(:,306),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,62),MT,G2(:,:,:,261))
  call loop_AS_Q(G2(:,:,:,261),wf(:,0),G2(:,:,:,262),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,63),MT,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,97),wf(:,310),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,62),MT,G2(:,:,:,263))
  call loop_AS_Q(G2(:,:,:,263),wf(:,0),G2(:,:,:,264),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,97),wf(:,311),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,62),MT,G2(:,:,:,265))
  call loop_AS_Q(G2(:,:,:,265),wf(:,0),G2(:,:,:,266),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,266),Q(:,63),MT,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,97),wf(:,312),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,267))
  call loop_AS_Q(G2(:,:,:,267),wf(:,0),G2(:,:,:,268),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,268),Q(:,63),MT,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,97),wf(:,66),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,54),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-3),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,62),MT,G3(:,:,:,163))
  call loop_AS_Q(G3(:,:,:,163),wf(:,0),G3(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,63),MT,G4tensor(:,46))
  call loop_AV_Q(G1(:,:,:,97),wf(:,68),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,54),MT,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-3),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,62),MT,G3(:,:,:,165))
  call loop_AS_Q(G3(:,:,:,165),wf(:,0),G3(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,97),wf(:,69),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,54),MT,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-3),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,62),MT,G3(:,:,:,167))
  call loop_AS_Q(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,48))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-3),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,12),MT,G2(:,:,:,275))
  call loop_AV_Q(G2(:,:,:,275),wf(:,66),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,62),MT,G3(:,:,:,169))
  call loop_AS_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,49))
  call loop_AV_Q(G2(:,:,:,275),wf(:,68),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,62),MT,G3(:,:,:,171))
  call loop_AS_Q(G3(:,:,:,171),wf(:,0),G3(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,275),wf(:,69),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,62),MT,G3(:,:,:,173))
  call loop_AS_Q(G3(:,:,:,173),wf(:,0),G3(:,:,:,174),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,174),Q(:,63),MT,G4tensor(:,51))
  call loop_AV_Q(G2(:,:,:,275),wf(:,184),G2(:,:,:,279))
  call loop_A_Q(G2(:,:,:,279),Q(:,62),MT,G3(:,:,:,175))
  call loop_AS_Q(G3(:,:,:,175),wf(:,0),G3(:,:,:,176),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,176),Q(:,63),MT,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,275),wf(:,29),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,30),MT,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,-5),G3(:,:,:,178))
  call loop_A_Q(G3(:,:,:,178),Q(:,62),MT,G4(:,:,:,85))
  call loop_AS_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-5),G2(:,:,:,281))
  call loop_A_Q(G2(:,:,:,281),Q(:,44),MT,G3(:,:,:,179))
  call loop_AV_Q(G3(:,:,:,179),wf(:,29),G3(:,:,:,180))
  call loop_A_Q(G3(:,:,:,180),Q(:,62),MT,G4(:,:,:,87))
  call loop_AS_Q(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,63),MT,G5tensor(:,32))
  call loop_AV_Q(G3(:,:,:,179),wf(:,-1),G3(:,:,:,181))
  call loop_A_Q(G3(:,:,:,181),Q(:,46),MT,G4(:,:,:,89))
  call loop_AV_Q(G4(:,:,:,89),wf(:,-4),G4(:,:,:,90))
  call loop_A_Q(G4(:,:,:,90),Q(:,62),MT,G5(:,:,:,25))
  call loop_AS_Q(G5(:,:,:,25),wf(:,0),G5(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,26),Q(:,63),MT,G6tensor(:,13))
  call loop_AV_Q(G2(:,:,:,275),wf(:,187),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,62),MT,G3(:,:,:,182))
  call loop_AS_Q(G3(:,:,:,182),wf(:,0),G3(:,:,:,183),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,183),Q(:,63),MT,G4tensor(:,53))
  call loop_AV_Q(G2(:,:,:,275),wf(:,37),G2(:,:,:,283))
  call loop_A_Q(G2(:,:,:,283),Q(:,46),MT,G3(:,:,:,184))
  call loop_AV_Q(G3(:,:,:,184),wf(:,-4),G3(:,:,:,185))
  call loop_A_Q(G3(:,:,:,185),Q(:,62),MT,G4(:,:,:,91))
  call loop_AS_Q(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-4),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,28),MT,G3(:,:,:,186))
  call loop_AV_Q(G3(:,:,:,186),wf(:,37),G3(:,:,:,187))
  call loop_A_Q(G3(:,:,:,187),Q(:,62),MT,G4(:,:,:,93))
  call loop_AS_Q(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,34))
  call loop_AV_Q(G3(:,:,:,186),wf(:,-1),G3(:,:,:,188))
  call loop_A_Q(G3(:,:,:,188),Q(:,30),MT,G4(:,:,:,95))
  call loop_AV_Q(G4(:,:,:,95),wf(:,-5),G4(:,:,:,96))
  call loop_A_Q(G4(:,:,:,96),Q(:,62),MT,G5(:,:,:,27))
  call loop_AS_Q(G5(:,:,:,27),wf(:,0),G5(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,28),Q(:,63),MT,G6tensor(:,14))
  call loop_AV_Q(G2(:,:,:,275),wf(:,188),G2(:,:,:,285))
  call loop_A_Q(G2(:,:,:,285),Q(:,62),MT,G3(:,:,:,189))
  call loop_AS_Q(G3(:,:,:,189),wf(:,0),G3(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,54))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-1),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,14),MT,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,119),G3(:,:,:,192))
  call loop_A_Q(G3(:,:,:,192),Q(:,62),MT,G4(:,:,:,97))
  call loop_AS_Q(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,63),MT,G5tensor(:,35))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-5),G3(:,:,:,193))
  call loop_A_Q(G3(:,:,:,193),Q(:,46),MT,G4(:,:,:,99))
  call loop_AV_Q(G4(:,:,:,99),wf(:,-4),G4(:,:,:,100))
  call loop_A_Q(G4(:,:,:,100),Q(:,62),MT,G5(:,:,:,29))
  call loop_AS_Q(G5(:,:,:,29),wf(:,0),G5(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,30),Q(:,63),MT,G6tensor(:,15))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-4),G3(:,:,:,194))
  call loop_A_Q(G3(:,:,:,194),Q(:,30),MT,G4(:,:,:,101))
  call loop_AV_Q(G4(:,:,:,101),wf(:,-5),G4(:,:,:,102))
  call loop_A_Q(G4(:,:,:,102),Q(:,62),MT,G5(:,:,:,31))
  call loop_AS_Q(G5(:,:,:,31),wf(:,0),G5(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,32),Q(:,63),MT,G6tensor(:,16))
  call loop_AV_Q(G1(:,:,:,97),wf(:,319),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,287))
  call loop_AS_Q(G2(:,:,:,287),wf(:,0),G2(:,:,:,288),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,97),wf(:,320),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,62),MT,G2(:,:,:,289))
  call loop_AS_Q(G2(:,:,:,289),wf(:,0),G2(:,:,:,290),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,97),wf(:,321),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,62),MT,G2(:,:,:,291))
  call loop_AS_Q(G2(:,:,:,291),wf(:,0),G2(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,97),wf(:,325),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,62),MT,G2(:,:,:,293))
  call loop_AS_Q(G2(:,:,:,293),wf(:,0),G2(:,:,:,294),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,97),wf(:,326),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,295))
  call loop_AS_Q(G2(:,:,:,295),wf(:,0),G2(:,:,:,296),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),MT,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,97),wf(:,327),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,62),MT,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,0),G2(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,90))
  call loop_AV_Q(G1(:,:,:,97),wf(:,77),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,46),MT,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-4),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,62),MT,G3(:,:,:,195))
  call loop_AS_Q(G3(:,:,:,195),wf(:,0),G3(:,:,:,196),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,97),wf(:,79),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,46),MT,G2(:,:,:,301))
  call loop_AV_Q(G2(:,:,:,301),wf(:,-4),G2(:,:,:,302))
  call loop_A_Q(G2(:,:,:,302),Q(:,62),MT,G3(:,:,:,197))
  call loop_AS_Q(G3(:,:,:,197),wf(:,0),G3(:,:,:,198),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G1(:,:,:,97),wf(:,80),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,46),MT,G2(:,:,:,303))
  call loop_AV_Q(G2(:,:,:,303),wf(:,-4),G2(:,:,:,304))
  call loop_A_Q(G2(:,:,:,304),Q(:,62),MT,G3(:,:,:,199))
  call loop_AS_Q(G3(:,:,:,199),wf(:,0),G3(:,:,:,200),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-4),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,20),MT,G2(:,:,:,305))
  call loop_AV_Q(G2(:,:,:,305),wf(:,77),G2(:,:,:,306))
  call loop_A_Q(G2(:,:,:,306),Q(:,62),MT,G3(:,:,:,201))
  call loop_AS_Q(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,305),wf(:,79),G2(:,:,:,307))
  call loop_A_Q(G2(:,:,:,307),Q(:,62),MT,G3(:,:,:,203))
  call loop_AS_Q(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,59))
  call loop_AV_Q(G2(:,:,:,305),wf(:,80),G2(:,:,:,308))
  call loop_A_Q(G2(:,:,:,308),Q(:,62),MT,G3(:,:,:,205))
  call loop_AS_Q(G3(:,:,:,205),wf(:,0),G3(:,:,:,206),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,63),MT,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,305),wf(:,176),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,62),MT,G3(:,:,:,207))
  call loop_AS_Q(G3(:,:,:,207),wf(:,0),G3(:,:,:,208),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,63),MT,G4tensor(:,61))
  call loop_AV_Q(G2(:,:,:,305),wf(:,18),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,30),MT,G3(:,:,:,209))
  call loop_AV_Q(G3(:,:,:,209),wf(:,-5),G3(:,:,:,210))
  call loop_A_Q(G3(:,:,:,210),Q(:,62),MT,G4(:,:,:,103))
  call loop_AS_Q(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,63),MT,G5tensor(:,36))
  call loop_AV_Q(G2(:,:,:,305),wf(:,-5),G2(:,:,:,311))
  call loop_A_Q(G2(:,:,:,311),Q(:,52),MT,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,18),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,62),MT,G4(:,:,:,105))
  call loop_AS_Q(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,63),MT,G5tensor(:,37))
  call loop_AV_Q(G3(:,:,:,211),wf(:,-1),G3(:,:,:,213))
  call loop_A_Q(G3(:,:,:,213),Q(:,54),MT,G4(:,:,:,107))
  call loop_AV_Q(G4(:,:,:,107),wf(:,-3),G4(:,:,:,108))
  call loop_A_Q(G4(:,:,:,108),Q(:,62),MT,G5(:,:,:,33))
  call loop_AS_Q(G5(:,:,:,33),wf(:,0),G5(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,34),Q(:,63),MT,G6tensor(:,17))
  call loop_AV_Q(G2(:,:,:,305),wf(:,196),G2(:,:,:,312))
  call loop_A_Q(G2(:,:,:,312),Q(:,62),MT,G3(:,:,:,214))
  call loop_AS_Q(G3(:,:,:,214),wf(:,0),G3(:,:,:,215),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,215),Q(:,63),MT,G4tensor(:,62))
  call loop_AV_Q(G2(:,:,:,305),wf(:,37),G2(:,:,:,313))
  call loop_A_Q(G2(:,:,:,313),Q(:,54),MT,G3(:,:,:,216))
  call loop_AV_Q(G3(:,:,:,216),wf(:,-3),G3(:,:,:,217))
  call loop_A_Q(G3(:,:,:,217),Q(:,62),MT,G4(:,:,:,109))
  call loop_AS_Q(G4(:,:,:,109),wf(:,0),G4(:,:,:,110),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,63),MT,G5tensor(:,38))
  call loop_AV_Q(G2(:,:,:,305),wf(:,-3),G2(:,:,:,314))
  call loop_A_Q(G2(:,:,:,314),Q(:,28),MT,G3(:,:,:,218))
  call loop_AV_Q(G3(:,:,:,218),wf(:,37),G3(:,:,:,219))
  call loop_A_Q(G3(:,:,:,219),Q(:,62),MT,G4(:,:,:,111))
  call loop_AS_Q(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,63),MT,G5tensor(:,39))
  call loop_AV_Q(G3(:,:,:,218),wf(:,-1),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,30),MT,G4(:,:,:,113))
  call loop_AV_Q(G4(:,:,:,113),wf(:,-5),G4(:,:,:,114))
  call loop_A_Q(G4(:,:,:,114),Q(:,62),MT,G5(:,:,:,35))
  call loop_AS_Q(G5(:,:,:,35),wf(:,0),G5(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,36),Q(:,63),MT,G6tensor(:,18))
  call loop_AV_Q(G2(:,:,:,305),wf(:,197),G2(:,:,:,315))
  call loop_A_Q(G2(:,:,:,315),Q(:,62),MT,G3(:,:,:,221))
  call loop_AS_Q(G3(:,:,:,221),wf(:,0),G3(:,:,:,222),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,63),MT,G4tensor(:,63))
  call loop_AV_Q(G2(:,:,:,305),wf(:,-1),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,22),MT,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,109),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,62),MT,G4(:,:,:,115))
  call loop_AS_Q(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,40))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-5),G3(:,:,:,225))
  call loop_A_Q(G3(:,:,:,225),Q(:,54),MT,G4(:,:,:,117))
  call loop_AV_Q(G4(:,:,:,117),wf(:,-3),G4(:,:,:,118))
  call loop_A_Q(G4(:,:,:,118),Q(:,62),MT,G5(:,:,:,37))
  call loop_AS_Q(G5(:,:,:,37),wf(:,0),G5(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,38),Q(:,63),MT,G6tensor(:,19))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-3),G3(:,:,:,226))
  call loop_A_Q(G3(:,:,:,226),Q(:,30),MT,G4(:,:,:,119))
  call loop_AV_Q(G4(:,:,:,119),wf(:,-5),G4(:,:,:,120))
  call loop_A_Q(G4(:,:,:,120),Q(:,62),MT,G5(:,:,:,39))
  call loop_AS_Q(G5(:,:,:,39),wf(:,0),G5(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,40),Q(:,63),MT,G6tensor(:,20))
  call loop_AV_Q(G1(:,:,:,97),wf(:,331),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,62),MT,G2(:,:,:,317))
  call loop_AS_Q(G2(:,:,:,317),wf(:,0),G2(:,:,:,318),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,318),Q(:,63),MT,G3tensor(:,91))
  call loop_AV_Q(G1(:,:,:,97),wf(:,332),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,62),MT,G2(:,:,:,319))
  call loop_AS_Q(G2(:,:,:,319),wf(:,0),G2(:,:,:,320),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,320),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G1(:,:,:,97),wf(:,333),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,62),MT,G2(:,:,:,321))
  call loop_AS_Q(G2(:,:,:,321),wf(:,0),G2(:,:,:,322),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,322),Q(:,63),MT,G3tensor(:,93))
  call loop_AV_Q(G1(:,:,:,97),wf(:,85),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,30),MT,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-5),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,62),MT,G3(:,:,:,227))
  call loop_AS_Q(G3(:,:,:,227),wf(:,0),G3(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,63),MT,G4tensor(:,64))
  call loop_AV_Q(G1(:,:,:,97),wf(:,87),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,30),MT,G2(:,:,:,325))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-5),G2(:,:,:,326))
  call loop_A_Q(G2(:,:,:,326),Q(:,62),MT,G3(:,:,:,229))
  call loop_AS_Q(G3(:,:,:,229),wf(:,0),G3(:,:,:,230),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,63),MT,G4tensor(:,65))
  call loop_AV_Q(G1(:,:,:,97),wf(:,88),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,30),MT,G2(:,:,:,327))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-5),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,62),MT,G3(:,:,:,231))
  call loop_AS_Q(G3(:,:,:,231),wf(:,0),G3(:,:,:,232),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,232),Q(:,63),MT,G4tensor(:,66))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-5),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,36),MT,G2(:,:,:,329))
  call loop_AV_Q(G2(:,:,:,329),wf(:,85),G2(:,:,:,330))
  call loop_A_Q(G2(:,:,:,330),Q(:,62),MT,G3(:,:,:,233))
  call loop_AS_Q(G3(:,:,:,233),wf(:,0),G3(:,:,:,234),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,63),MT,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,329),wf(:,87),G2(:,:,:,331))
  call loop_A_Q(G2(:,:,:,331),Q(:,62),MT,G3(:,:,:,235))
  call loop_AS_Q(G3(:,:,:,235),wf(:,0),G3(:,:,:,236),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,63),MT,G4tensor(:,68))
  call loop_AV_Q(G2(:,:,:,329),wf(:,88),G2(:,:,:,332))
  call loop_A_Q(G2(:,:,:,332),Q(:,62),MT,G3(:,:,:,237))
  call loop_AS_Q(G3(:,:,:,237),wf(:,0),G3(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,63),MT,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,329),wf(:,179),G2(:,:,:,333))
  call loop_A_Q(G2(:,:,:,333),Q(:,62),MT,G3(:,:,:,239))
  call loop_AS_Q(G3(:,:,:,239),wf(:,0),G3(:,:,:,240),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,63),MT,G4tensor(:,70))
  call loop_AV_Q(G2(:,:,:,329),wf(:,18),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,46),MT,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,-4),G3(:,:,:,242))
  call loop_A_Q(G3(:,:,:,242),Q(:,62),MT,G4(:,:,:,121))
  call loop_AS_Q(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,63),MT,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-4),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,52),MT,G3(:,:,:,243))
  call loop_AV_Q(G3(:,:,:,243),wf(:,18),G3(:,:,:,244))
  call loop_A_Q(G3(:,:,:,244),Q(:,62),MT,G4(:,:,:,123))
  call loop_AS_Q(G4(:,:,:,123),wf(:,0),G4(:,:,:,124),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,63),MT,G5tensor(:,42))
  call loop_AV_Q(G3(:,:,:,243),wf(:,-1),G3(:,:,:,245))
  call loop_A_Q(G3(:,:,:,245),Q(:,54),MT,G4(:,:,:,125))
  call loop_AV_Q(G4(:,:,:,125),wf(:,-3),G4(:,:,:,126))
  call loop_A_Q(G4(:,:,:,126),Q(:,62),MT,G5(:,:,:,41))
  call loop_AS_Q(G5(:,:,:,41),wf(:,0),G5(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,42),Q(:,63),MT,G6tensor(:,21))
  call loop_AV_Q(G2(:,:,:,329),wf(:,192),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,62),MT,G3(:,:,:,246))
  call loop_AS_Q(G3(:,:,:,246),wf(:,0),G3(:,:,:,247),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,247),Q(:,63),MT,G4tensor(:,71))
  call loop_AV_Q(G2(:,:,:,329),wf(:,29),G2(:,:,:,337))
  call loop_A_Q(G2(:,:,:,337),Q(:,54),MT,G3(:,:,:,248))
  call loop_AV_Q(G3(:,:,:,248),wf(:,-3),G3(:,:,:,249))
  call loop_A_Q(G3(:,:,:,249),Q(:,62),MT,G4(:,:,:,127))
  call loop_AS_Q(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,63),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-3),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,44),MT,G3(:,:,:,250))
  call loop_AV_Q(G3(:,:,:,250),wf(:,29),G3(:,:,:,251))
  call loop_A_Q(G3(:,:,:,251),Q(:,62),MT,G4(:,:,:,129))
  call loop_AS_Q(G4(:,:,:,129),wf(:,0),G4(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,63),MT,G5tensor(:,44))
  call loop_AV_Q(G3(:,:,:,250),wf(:,-1),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,46),MT,G4(:,:,:,131))
  call loop_AV_Q(G4(:,:,:,131),wf(:,-4),G4(:,:,:,132))
  call loop_A_Q(G4(:,:,:,132),Q(:,62),MT,G5(:,:,:,43))
  call loop_AS_Q(G5(:,:,:,43),wf(:,0),G5(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,44),Q(:,63),MT,G6tensor(:,22))
  call loop_AV_Q(G2(:,:,:,329),wf(:,201),G2(:,:,:,339))
  call loop_A_Q(G2(:,:,:,339),Q(:,62),MT,G3(:,:,:,253))
  call loop_AS_Q(G3(:,:,:,253),wf(:,0),G3(:,:,:,254),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,63),MT,G4tensor(:,72))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-1),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,38),MT,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,101),G3(:,:,:,256))
  call loop_A_Q(G3(:,:,:,256),Q(:,62),MT,G4(:,:,:,133))
  call loop_AS_Q(G4(:,:,:,133),wf(:,0),G4(:,:,:,134),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,63),MT,G5tensor(:,45))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-4),G3(:,:,:,257))
  call loop_A_Q(G3(:,:,:,257),Q(:,54),MT,G4(:,:,:,135))
  call loop_AV_Q(G4(:,:,:,135),wf(:,-3),G4(:,:,:,136))
  call loop_A_Q(G4(:,:,:,136),Q(:,62),MT,G5(:,:,:,45))
  call loop_AS_Q(G5(:,:,:,45),wf(:,0),G5(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,46),Q(:,63),MT,G6tensor(:,23))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-3),G3(:,:,:,258))
  call loop_A_Q(G3(:,:,:,258),Q(:,46),MT,G4(:,:,:,137))
  call loop_AV_Q(G4(:,:,:,137),wf(:,-4),G4(:,:,:,138))
  call loop_A_Q(G4(:,:,:,138),Q(:,62),MT,G5(:,:,:,47))
  call loop_AS_Q(G5(:,:,:,47),wf(:,0),G5(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,48),Q(:,63),MT,G6tensor(:,24))
  call loop_AV_Q(G1(:,:,:,97),wf(:,372),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,62),MT,G2(:,:,:,341))
  call loop_AS_Q(G2(:,:,:,341),wf(:,0),G2(:,:,:,342),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,342),Q(:,63),MT,G3tensor(:,94))
  call loop_AV_Q(G1(:,:,:,97),wf(:,119),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,52),MT,G2(:,:,:,343))
  call loop_AV_Q(G2(:,:,:,343),wf(:,18),G2(:,:,:,344))
  call loop_A_Q(G2(:,:,:,344),Q(:,62),MT,G3(:,:,:,259))
  call loop_AS_Q(G3(:,:,:,259),wf(:,0),G3(:,:,:,260),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,63),MT,G4tensor(:,73))
  call loop_AV_Q(G2(:,:,:,343),wf(:,-1),G2(:,:,:,345))
  call loop_A_Q(G2(:,:,:,345),Q(:,54),MT,G3(:,:,:,261))
  call loop_AV_Q(G3(:,:,:,261),wf(:,-3),G3(:,:,:,262))
  call loop_A_Q(G3(:,:,:,262),Q(:,62),MT,G4(:,:,:,139))
  call loop_AS_Q(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,63),MT,G5tensor(:,46))
  call loop_AV_Q(G1(:,:,:,97),wf(:,18),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,14),MT,G2(:,:,:,346))
  call loop_AV_Q(G2(:,:,:,346),wf(:,119),G2(:,:,:,347))
  call loop_A_Q(G2(:,:,:,347),Q(:,62),MT,G3(:,:,:,263))
  call loop_AS_Q(G3(:,:,:,263),wf(:,0),G3(:,:,:,264),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,63),MT,G4tensor(:,74))
  call loop_AV_Q(G2(:,:,:,346),wf(:,-5),G2(:,:,:,348))
  call loop_A_Q(G2(:,:,:,348),Q(:,46),MT,G3(:,:,:,265))
  call loop_AV_Q(G3(:,:,:,265),wf(:,-4),G3(:,:,:,266))
  call loop_A_Q(G3(:,:,:,266),Q(:,62),MT,G4(:,:,:,141))
  call loop_AS_Q(G4(:,:,:,141),wf(:,0),G4(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,63),MT,G5tensor(:,47))
  call loop_AV_Q(G2(:,:,:,346),wf(:,-4),G2(:,:,:,349))
  call loop_A_Q(G2(:,:,:,349),Q(:,30),MT,G3(:,:,:,267))
  call loop_AV_Q(G3(:,:,:,267),wf(:,-5),G3(:,:,:,268))
  call loop_A_Q(G3(:,:,:,268),Q(:,62),MT,G4(:,:,:,143))
  call loop_AS_Q(G4(:,:,:,143),wf(:,0),G4(:,:,:,144),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,63),MT,G5tensor(:,48))
  call loop_AV_Q(G1(:,:,:,97),wf(:,376),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,350))
  call loop_AS_Q(G2(:,:,:,350),wf(:,0),G2(:,:,:,351),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,351),Q(:,63),MT,G3tensor(:,95))
  call loop_AV_Q(G1(:,:,:,97),wf(:,179),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,30),MT,G2(:,:,:,352))
  call loop_AV_Q(G2(:,:,:,352),wf(:,-5),G2(:,:,:,353))
  call loop_A_Q(G2(:,:,:,353),Q(:,62),MT,G3(:,:,:,269))
  call loop_AS_Q(G3(:,:,:,269),wf(:,0),G3(:,:,:,270),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,63),MT,G4tensor(:,75))
  call loop_AV_Q(G1(:,:,:,97),wf(:,378),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,354))
  call loop_AS_Q(G2(:,:,:,354),wf(:,0),G2(:,:,:,355),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,355),Q(:,63),MT,G3tensor(:,96))
  call loop_AV_Q(G1(:,:,:,97),wf(:,176),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,46),MT,G2(:,:,:,356))
  call loop_AV_Q(G2(:,:,:,356),wf(:,-4),G2(:,:,:,357))
  call loop_A_Q(G2(:,:,:,357),Q(:,62),MT,G3(:,:,:,271))
  call loop_AS_Q(G3(:,:,:,271),wf(:,0),G3(:,:,:,272),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,63),MT,G4tensor(:,76))
  call loop_AV_Q(G1(:,:,:,97),wf(:,389),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,62),MT,G2(:,:,:,358))
  call loop_AS_Q(G2(:,:,:,358),wf(:,0),G2(:,:,:,359),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,359),Q(:,63),MT,G3tensor(:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,109),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,44),MT,G2(:,:,:,360))
  call loop_AV_Q(G2(:,:,:,360),wf(:,29),G2(:,:,:,361))
  call loop_A_Q(G2(:,:,:,361),Q(:,62),MT,G3(:,:,:,273))
  call loop_AS_Q(G3(:,:,:,273),wf(:,0),G3(:,:,:,274),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,63),MT,G4tensor(:,77))
  call loop_AV_Q(G2(:,:,:,360),wf(:,-1),G2(:,:,:,362))
  call loop_A_Q(G2(:,:,:,362),Q(:,46),MT,G3(:,:,:,275))
  call loop_AV_Q(G3(:,:,:,275),wf(:,-4),G3(:,:,:,276))
  call loop_A_Q(G3(:,:,:,276),Q(:,62),MT,G4(:,:,:,145))
  call loop_AS_Q(G4(:,:,:,145),wf(:,0),G4(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,63),MT,G5tensor(:,49))
  call loop_AV_Q(G1(:,:,:,97),wf(:,29),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,22),MT,G2(:,:,:,363))
  call loop_AV_Q(G2(:,:,:,363),wf(:,109),G2(:,:,:,364))
  call loop_A_Q(G2(:,:,:,364),Q(:,62),MT,G3(:,:,:,277))
  call loop_AS_Q(G3(:,:,:,277),wf(:,0),G3(:,:,:,278),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,63),MT,G4tensor(:,78))
  call loop_AV_Q(G2(:,:,:,363),wf(:,-5),G2(:,:,:,365))
  call loop_A_Q(G2(:,:,:,365),Q(:,54),MT,G3(:,:,:,279))
  call loop_AV_Q(G3(:,:,:,279),wf(:,-3),G3(:,:,:,280))
  call loop_A_Q(G3(:,:,:,280),Q(:,62),MT,G4(:,:,:,147))
  call loop_AS_Q(G4(:,:,:,147),wf(:,0),G4(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,63),MT,G5tensor(:,50))
  call loop_AV_Q(G2(:,:,:,363),wf(:,-3),G2(:,:,:,366))
  call loop_A_Q(G2(:,:,:,366),Q(:,30),MT,G3(:,:,:,281))
  call loop_AV_Q(G3(:,:,:,281),wf(:,-5),G3(:,:,:,282))
  call loop_A_Q(G3(:,:,:,282),Q(:,62),MT,G4(:,:,:,149))
  call loop_AS_Q(G4(:,:,:,149),wf(:,0),G4(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,63),MT,G5tensor(:,51))
  call loop_AV_Q(G1(:,:,:,97),wf(:,393),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,62),MT,G2(:,:,:,367))
  call loop_AS_Q(G2(:,:,:,367),wf(:,0),G2(:,:,:,368),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,368),Q(:,63),MT,G3tensor(:,98))
  call loop_AV_Q(G1(:,:,:,97),wf(:,192),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,30),MT,G2(:,:,:,369))
  call loop_AV_Q(G2(:,:,:,369),wf(:,-5),G2(:,:,:,370))
  call loop_A_Q(G2(:,:,:,370),Q(:,62),MT,G3(:,:,:,283))
  call loop_AS_Q(G3(:,:,:,283),wf(:,0),G3(:,:,:,284),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,284),Q(:,63),MT,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,97),wf(:,395),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,62),MT,G2(:,:,:,371))
  call loop_AS_Q(G2(:,:,:,371),wf(:,0),G2(:,:,:,372),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,372),Q(:,63),MT,G3tensor(:,99))
  call loop_AV_Q(G1(:,:,:,97),wf(:,184),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,54),MT,G2(:,:,:,373))
  call loop_AV_Q(G2(:,:,:,373),wf(:,-3),G2(:,:,:,374))
  call loop_A_Q(G2(:,:,:,374),Q(:,62),MT,G3(:,:,:,285))
  call loop_AS_Q(G3(:,:,:,285),wf(:,0),G3(:,:,:,286),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,286),Q(:,63),MT,G4tensor(:,80))
  call loop_AV_Q(G1(:,:,:,97),wf(:,404),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,62),MT,G2(:,:,:,375))
  call loop_AS_Q(G2(:,:,:,375),wf(:,0),G2(:,:,:,376),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,376),Q(:,63),MT,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,97),wf(:,101),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,28),MT,G2(:,:,:,377))
  call loop_AV_Q(G2(:,:,:,377),wf(:,37),G2(:,:,:,378))
  call loop_A_Q(G2(:,:,:,378),Q(:,62),MT,G3(:,:,:,287))
  call loop_AS_Q(G3(:,:,:,287),wf(:,0),G3(:,:,:,288),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,63),MT,G4tensor(:,81))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-1),G2(:,:,:,379))
  call loop_A_Q(G2(:,:,:,379),Q(:,30),MT,G3(:,:,:,289))
  call loop_AV_Q(G3(:,:,:,289),wf(:,-5),G3(:,:,:,290))
  call loop_A_Q(G3(:,:,:,290),Q(:,62),MT,G4(:,:,:,151))
  call loop_AS_Q(G4(:,:,:,151),wf(:,0),G4(:,:,:,152),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,63),MT,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,97),wf(:,37),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,38),MT,G2(:,:,:,380))
  call loop_AV_Q(G2(:,:,:,380),wf(:,101),G2(:,:,:,381))
  call loop_A_Q(G2(:,:,:,381),Q(:,62),MT,G3(:,:,:,291))
  call loop_AS_Q(G3(:,:,:,291),wf(:,0),G3(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,63),MT,G4tensor(:,82))
  call loop_AV_Q(G2(:,:,:,380),wf(:,-4),G2(:,:,:,382))
  call loop_A_Q(G2(:,:,:,382),Q(:,54),MT,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-3),G3(:,:,:,294))
  call loop_A_Q(G3(:,:,:,294),Q(:,62),MT,G4(:,:,:,153))
  call loop_AS_Q(G4(:,:,:,153),wf(:,0),G4(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,63),MT,G5tensor(:,53))
  call loop_AV_Q(G2(:,:,:,380),wf(:,-3),G2(:,:,:,383))
  call loop_A_Q(G2(:,:,:,383),Q(:,46),MT,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,-4),G3(:,:,:,296))
  call loop_A_Q(G3(:,:,:,296),Q(:,62),MT,G4(:,:,:,155))
  call loop_AS_Q(G4(:,:,:,155),wf(:,0),G4(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,63),MT,G5tensor(:,54))
  call loop_AV_Q(G1(:,:,:,97),wf(:,408),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,62),MT,G2(:,:,:,384))
  call loop_AS_Q(G2(:,:,:,384),wf(:,0),G2(:,:,:,385),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,385),Q(:,63),MT,G3tensor(:,101))
  call loop_AV_Q(G1(:,:,:,97),wf(:,201),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,30),MT,G2(:,:,:,386))
  call loop_AV_Q(G2(:,:,:,386),wf(:,-5),G2(:,:,:,387))
  call loop_A_Q(G2(:,:,:,387),Q(:,62),MT,G3(:,:,:,297))
  call loop_AS_Q(G3(:,:,:,297),wf(:,0),G3(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,63),MT,G4tensor(:,83))
  call loop_AV_Q(G1(:,:,:,97),wf(:,409),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,62),MT,G2(:,:,:,388))
  call loop_AS_Q(G2(:,:,:,388),wf(:,0),G2(:,:,:,389),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,389),Q(:,63),MT,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,97),wf(:,415),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,62),MT,G2(:,:,:,390))
  call loop_AS_Q(G2(:,:,:,390),wf(:,0),G2(:,:,:,391),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,391),Q(:,63),MT,G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,97),wf(:,196),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,46),MT,G2(:,:,:,392))
  call loop_AV_Q(G2(:,:,:,392),wf(:,-4),G2(:,:,:,393))
  call loop_A_Q(G2(:,:,:,393),Q(:,62),MT,G3(:,:,:,299))
  call loop_AS_Q(G3(:,:,:,299),wf(:,0),G3(:,:,:,300),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,63),MT,G4tensor(:,84))
  call loop_AV_Q(G1(:,:,:,97),wf(:,417),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,62),MT,G2(:,:,:,394))
  call loop_AS_Q(G2(:,:,:,394),wf(:,0),G2(:,:,:,395),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,395),Q(:,63),MT,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,97),wf(:,187),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,54),MT,G2(:,:,:,396))
  call loop_AV_Q(G2(:,:,:,396),wf(:,-3),G2(:,:,:,397))
  call loop_A_Q(G2(:,:,:,397),Q(:,62),MT,G3(:,:,:,301))
  call loop_AS_Q(G3(:,:,:,301),wf(:,0),G3(:,:,:,302),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,302),Q(:,63),MT,G4tensor(:,85))
  call loop_AV_Q(G1(:,:,:,97),wf(:,426),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,62),MT,G2(:,:,:,398))
  call loop_AS_Q(G2(:,:,:,398),wf(:,0),G2(:,:,:,399),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,399),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G1(:,:,:,97),wf(:,197),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,46),MT,G2(:,:,:,400))
  call loop_AV_Q(G2(:,:,:,400),wf(:,-4),G2(:,:,:,401))
  call loop_A_Q(G2(:,:,:,401),Q(:,62),MT,G3(:,:,:,303))
  call loop_AS_Q(G3(:,:,:,303),wf(:,0),G3(:,:,:,304),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,63),MT,G4tensor(:,86))
  call loop_AV_Q(G1(:,:,:,97),wf(:,427),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,62),MT,G2(:,:,:,402))
  call loop_AS_Q(G2(:,:,:,402),wf(:,0),G2(:,:,:,403),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,403),Q(:,63),MT,G3tensor(:,106))
  call loop_AV_Q(G1(:,:,:,97),wf(:,432),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,62),MT,G2(:,:,:,404))
  call loop_AS_Q(G2(:,:,:,404),wf(:,0),G2(:,:,:,405),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,405),Q(:,63),MT,G3tensor(:,107))
  call loop_AV_Q(G1(:,:,:,97),wf(:,433),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,62),MT,G2(:,:,:,406))
  call loop_AS_Q(G2(:,:,:,406),wf(:,0),G2(:,:,:,407),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,407),Q(:,63),MT,G3tensor(:,108))
  call loop_AV_Q(G1(:,:,:,97),wf(:,188),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,54),MT,G2(:,:,:,408))
  call loop_AV_Q(G2(:,:,:,408),wf(:,-3),G2(:,:,:,409))
  call loop_A_Q(G2(:,:,:,409),Q(:,62),MT,G3(:,:,:,305))
  call loop_AS_Q(G3(:,:,:,305),wf(:,0),G3(:,:,:,306),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,63),MT,G4tensor(:,87))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(248)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(250)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(10) = M(10) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(12) = M(12) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(18) = M(18) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(24) = M(24) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(6) = M(6) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(252)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,73),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,74),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,75),T3sum(1:35,5))
  M(10) = M(10) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,40),T4sum(1:70,3))
  M(16) = M(16) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,40),T4sum(1:70,3))
  M(22) = M(22) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,40),T4sum(1:70,3))
  M(24) = M(24) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,40),T4sum(1:70,3))
  M(10) = M(10) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,41),T4sum(1:70,3))
  M(12) = M(12) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,41),T4sum(1:70,3))
  M(18) = M(18) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,41),T4sum(1:70,3))
  M(24) = M(24) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,41),T4sum(1:70,3))
  M(12) = M(12) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(16) = M(16) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(18) = M(18) + (f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(22) = M(22) + (-f(3) * den(2)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(4) = M(4) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,5),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(261)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(270)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(272)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(13) = M(13) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,1),T4sum(1:70,9))
  M(15) = M(15) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,1),T4sum(1:70,9))
  M(17) = M(17) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,1),T4sum(1:70,9))
  M(18) = M(18) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,1),T4sum(1:70,9))
  M(13) = M(13) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,2),T4sum(1:70,9))
  M(14) = M(14) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,2),T4sum(1:70,9))
  M(16) = M(16) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,2),T4sum(1:70,9))
  M(18) = M(18) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,2),T4sum(1:70,9))
  M(14) = M(14) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,3),T4sum(1:70,9))
  M(15) = M(15) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,3),T4sum(1:70,9))
  M(16) = M(16) + (f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,3),T4sum(1:70,9))
  M(17) = M(17) + (-f(3) * den(16)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,3),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(276)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,76),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,77),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,78),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,79),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,80),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(8) = M(8) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,46),T4sum(1:70,13))
  M(15) = M(15) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,46),T4sum(1:70,13))
  M(18) = M(18) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,46),T4sum(1:70,13))
  M(21) = M(21) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,46),T4sum(1:70,13))
  M(7) = M(7) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,47),T4sum(1:70,13))
  M(8) = M(8) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,47),T4sum(1:70,13))
  M(18) = M(18) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,47),T4sum(1:70,13))
  M(24) = M(24) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,47),T4sum(1:70,13))
  M(7) = M(7) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,48),T4sum(1:70,13))
  M(15) = M(15) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,48),T4sum(1:70,13))
  M(21) = M(21) + (-f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,48),T4sum(1:70,13))
  M(24) = M(24) + (f(3) * den(34)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,48),T4sum(1:70,13))
  M(2) = M(2) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,49),T4sum(1:70,14))
  M(13) = M(13) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,49),T4sum(1:70,14))
  M(17) = M(17) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,49),T4sum(1:70,14))
  M(19) = M(19) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,49),T4sum(1:70,14))
  M(1) = M(1) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,50),T4sum(1:70,14))
  M(2) = M(2) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,50),T4sum(1:70,14))
  M(17) = M(17) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,50),T4sum(1:70,14))
  M(23) = M(23) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,50),T4sum(1:70,14))
  M(1) = M(1) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,51),T4sum(1:70,14))
  M(13) = M(13) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,51),T4sum(1:70,14))
  M(19) = M(19) + (-f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,51),T4sum(1:70,14))
  M(23) = M(23) + (f(3) * den(34)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,51),T4sum(1:70,14))
  M(6) = M(6) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(285)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(286)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(287)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(288)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(9) = M(9) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,55),T4sum(1:70,16))
  M(12) = M(12) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,55),T4sum(1:70,16))
  M(14) = M(14) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,55),T4sum(1:70,16))
  M(23) = M(23) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,55),T4sum(1:70,16))
  M(12) = M(12) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,56),T4sum(1:70,16))
  M(13) = M(13) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,56),T4sum(1:70,16))
  M(14) = M(14) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,56),T4sum(1:70,16))
  M(22) = M(22) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,56),T4sum(1:70,16))
  M(9) = M(9) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,57),T4sum(1:70,16))
  M(13) = M(13) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,57),T4sum(1:70,16))
  M(22) = M(22) + (f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,57),T4sum(1:70,16))
  M(23) = M(23) + (-f(3) * den(39)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,57),T4sum(1:70,16))
  M(4) = M(4) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,58),T4sum(1:70,17))
  M(7) = M(7) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,58),T4sum(1:70,17))
  M(11) = M(11) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,58),T4sum(1:70,17))
  M(20) = M(20) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,58),T4sum(1:70,17))
  M(3) = M(3) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,59),T4sum(1:70,17))
  M(4) = M(4) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,59),T4sum(1:70,17))
  M(11) = M(11) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,59),T4sum(1:70,17))
  M(21) = M(21) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,59),T4sum(1:70,17))
  M(3) = M(3) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,60),T4sum(1:70,17))
  M(7) = M(7) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,60),T4sum(1:70,17))
  M(20) = M(20) + (-f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,60),T4sum(1:70,17))
  M(21) = M(21) + (f(3) * den(39)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,60),T4sum(1:70,17))
  M(4) = M(4) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,7),T4sum(1:70,18))
  M(7) = M(7) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,7),T4sum(1:70,18))
  M(11) = M(11) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,7),T4sum(1:70,18))
  M(20) = M(20) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,7),T4sum(1:70,18))
  M(3) = M(3) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,8),T4sum(1:70,18))
  M(4) = M(4) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,8),T4sum(1:70,18))
  M(11) = M(11) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,8),T4sum(1:70,18))
  M(21) = M(21) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,8),T4sum(1:70,18))
  M(3) = M(3) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,9),T4sum(1:70,18))
  M(7) = M(7) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,9),T4sum(1:70,18))
  M(20) = M(20) + (-f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,9),T4sum(1:70,18))
  M(21) = M(21) + (f(3) * den(39)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,9),T4sum(1:70,18))
  M(6) = M(6) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(290)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(10) = M(10) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,64),T4sum(1:70,19))
  M(11) = M(11) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,64),T4sum(1:70,19))
  M(17) = M(17) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,64),T4sum(1:70,19))
  M(20) = M(20) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,64),T4sum(1:70,19))
  M(10) = M(10) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,65),T4sum(1:70,19))
  M(16) = M(16) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,65),T4sum(1:70,19))
  M(19) = M(19) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,65),T4sum(1:70,19))
  M(20) = M(20) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,65),T4sum(1:70,19))
  M(11) = M(11) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,66),T4sum(1:70,19))
  M(16) = M(16) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,66),T4sum(1:70,19))
  M(17) = M(17) + (-f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,66),T4sum(1:70,19))
  M(19) = M(19) + (f(3) * den(43)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,66),T4sum(1:70,19))
  M(6) = M(6) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,67),T4sum(1:70,20))
  M(8) = M(8) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,67),T4sum(1:70,20))
  M(9) = M(9) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,67),T4sum(1:70,20))
  M(14) = M(14) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,67),T4sum(1:70,20))
  M(5) = M(5) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,68),T4sum(1:70,20))
  M(6) = M(6) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,68),T4sum(1:70,20))
  M(9) = M(9) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,68),T4sum(1:70,20))
  M(15) = M(15) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,68),T4sum(1:70,20))
  M(5) = M(5) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,69),T4sum(1:70,20))
  M(8) = M(8) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,69),T4sum(1:70,20))
  M(14) = M(14) + (-f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,69),T4sum(1:70,20))
  M(15) = M(15) + (f(3) * den(43)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,69),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(11) = M(11) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(13) = M(13) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(14) = M(14) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(21) = M(21) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(292)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(5) = M(5) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(16) = M(16) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(294)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,13),T4sum(1:70,24))
  M(5) = M(5) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,13),T4sum(1:70,24))
  M(10) = M(10) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,13),T4sum(1:70,24))
  M(22) = M(22) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,13),T4sum(1:70,24))
  M(5) = M(5) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,14),T4sum(1:70,24))
  M(9) = M(9) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,14),T4sum(1:70,24))
  M(10) = M(10) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,14),T4sum(1:70,24))
  M(19) = M(19) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,14),T4sum(1:70,24))
  M(1) = M(1) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,15),T4sum(1:70,24))
  M(9) = M(9) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,15),T4sum(1:70,24))
  M(19) = M(19) + (f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,15),T4sum(1:70,24))
  M(22) = M(22) + (-f(3) * den(52)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,15),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(18) = M(18) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(299)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,19),T4sum(1:70,28))
  M(4) = M(4) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,19),T4sum(1:70,28))
  M(10) = M(10) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,19),T4sum(1:70,28))
  M(18) = M(18) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,19),T4sum(1:70,28))
  M(1) = M(1) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,20),T4sum(1:70,28))
  M(7) = M(7) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,20),T4sum(1:70,28))
  M(17) = M(17) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,20),T4sum(1:70,28))
  M(18) = M(18) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,20),T4sum(1:70,28))
  M(4) = M(4) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,21),T4sum(1:70,28))
  M(7) = M(7) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,21),T4sum(1:70,28))
  M(10) = M(10) + (-f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,21),T4sum(1:70,28))
  M(17) = M(17) + (f(3) * den(62)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,21),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(16) = M(16) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(22) = M(22) + (CI*f(2) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(87)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,34),T4sum(1:70,31))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,34),T4sum(1:70,31))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,34),T4sum(1:70,31))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,34),T4sum(1:70,31))
  M(1) = M(1) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,28),T4sum(1:70,31))
  M(3) = M(3) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,28),T4sum(1:70,31))
  M(10) = M(10) + (f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,28),T4sum(1:70,31))
  M(16) = M(16) + (-f(3) * den(300)) * TI2_call(4,momenta_45,masses2_2,G4tensor(:,28),T4sum(1:70,31))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,29),T4sum(1:70,33))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,29),T4sum(1:70,33))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,29),T4sum(1:70,33))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,29),T4sum(1:70,33))
  M(1) = M(1) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,35),T4sum(1:70,33))
  M(3) = M(3) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,35),T4sum(1:70,33))
  M(10) = M(10) + (f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,35),T4sum(1:70,33))
  M(16) = M(16) + (-f(3) * den(300)) * TI2_call(4,momenta_46,masses2_2,G4tensor(:,35),T4sum(1:70,33))
  M(2) = M(2) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(3) = M(3) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(5) = M(5) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(16) = M(16) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(22) = M(22) + (-(CI*f(2)) * den(92)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(303)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,36),T4sum(1:70,34))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,36),T4sum(1:70,34))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,36),T4sum(1:70,34))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,36),T4sum(1:70,34))
  M(2) = M(2) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,30),T4sum(1:70,34))
  M(5) = M(5) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,30),T4sum(1:70,34))
  M(12) = M(12) + (f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,30),T4sum(1:70,34))
  M(22) = M(22) + (-f(3) * den(302)) * TI2_call(4,momenta_47,masses2_2,G4tensor(:,30),T4sum(1:70,34))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_2,G4tensor(:,22),T4sum(1:70,35))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_2,G4tensor(:,22),T4sum(1:70,35))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_74,masses2_2,G4tensor(:,22),T4sum(1:70,35))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_74,masses2_2,G4tensor(:,22),T4sum(1:70,35))
  M(3) = M(3) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,31),T4sum(1:70,36))
  M(4) = M(4) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,31),T4sum(1:70,36))
  M(16) = M(16) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,31),T4sum(1:70,36))
  M(18) = M(18) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,31),T4sum(1:70,36))
  M(2) = M(2) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,37),T4sum(1:70,36))
  M(5) = M(5) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,37),T4sum(1:70,36))
  M(12) = M(12) + (f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,37),T4sum(1:70,36))
  M(22) = M(22) + (-f(3) * den(302)) * TI2_call(4,momenta_44,masses2_2,G4tensor(:,37),T4sum(1:70,36))
  M(1) = M(1) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(6) = M(6) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(10) = M(10) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(12) = M(12) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(18) = M(18) + (CI*f(2) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(24) = M(24) + (-(CI*f(2)) * den(96)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(1) = M(1) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,38),T4sum(1:70,37))
  M(2) = M(2) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,38),T4sum(1:70,37))
  M(10) = M(10) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,38),T4sum(1:70,37))
  M(12) = M(12) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,38),T4sum(1:70,37))
  M(4) = M(4) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,32),T4sum(1:70,37))
  M(6) = M(6) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,32),T4sum(1:70,37))
  M(18) = M(18) + (f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,32),T4sum(1:70,37))
  M(24) = M(24) + (-f(3) * den(304)) * TI2_call(4,momenta_48,masses2_2,G4tensor(:,32),T4sum(1:70,37))
  M(1) = M(1) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,33),T4sum(1:70,39))
  M(2) = M(2) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,33),T4sum(1:70,39))
  M(10) = M(10) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,33),T4sum(1:70,39))
  M(12) = M(12) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,33),T4sum(1:70,39))
  M(4) = M(4) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,39),T4sum(1:70,39))
  M(6) = M(6) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,39),T4sum(1:70,39))
  M(18) = M(18) + (f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,39),T4sum(1:70,39))
  M(24) = M(24) + (-f(3) * den(304)) * TI2_call(4,momenta_43,masses2_2,G4tensor(:,39),T4sum(1:70,39))
  M(1) = M(1) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(12) = M(12) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(307)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,23),T4sum(1:70,28))
  M(4) = M(4) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,23),T4sum(1:70,28))
  M(10) = M(10) + (f(3) * den(97)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,23),T4sum(1:70,28))
  M(18) = M(18) + (-f(3) * den(97)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,23),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(22) = M(22) + (CI*f(2) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(310)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,16),T4sum(1:70,24))
  M(5) = M(5) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,16),T4sum(1:70,24))
  M(10) = M(10) + (-f(3) * den(88)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,16),T4sum(1:70,24))
  M(22) = M(22) + (f(3) * den(88)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,16),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_162,masses2_3,G5tensor(:,19),T5sum(1:126,5))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_162,masses2_3,G5tensor(:,19),T5sum(1:126,5))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(5,momenta_162,masses2_3,G5tensor(:,13),T5sum(1:126,5))
  M(24) = M(24) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_162,masses2_3,G5tensor(:,13),T5sum(1:126,5))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_160,masses2_3,G5tensor(:,21),T5sum(1:126,6))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_160,masses2_3,G5tensor(:,21),T5sum(1:126,6))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_160,masses2_3,G5tensor(:,15),T5sum(1:126,6))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_160,masses2_3,G5tensor(:,15),T5sum(1:126,6))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_202,masses2_3,G5tensor(:,7),T5sum(1:126,7))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_202,masses2_3,G5tensor(:,7),T5sum(1:126,7))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_199,masses2_3,G5tensor(:,10),T5sum(1:126,8))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_199,masses2_3,G5tensor(:,10),T5sum(1:126,8))
  M(3) = M(3) + (CI*f(2) * den(1)) * TI2_call(5,momenta_161,masses2_3,G5tensor(:,20),T5sum(1:126,9))
  M(16) = M(16) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_161,masses2_3,G5tensor(:,20),T5sum(1:126,9))
  M(5) = M(5) + (CI*f(2) * den(1)) * TI2_call(5,momenta_161,masses2_3,G5tensor(:,14),T5sum(1:126,9))
  M(22) = M(22) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_161,masses2_3,G5tensor(:,14),T5sum(1:126,9))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(5,momenta_158,masses2_3,G5tensor(:,23),T5sum(1:126,10))
  M(18) = M(18) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_158,masses2_3,G5tensor(:,23),T5sum(1:126,10))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(5,momenta_158,masses2_3,G5tensor(:,17),T5sum(1:126,10))
  M(12) = M(12) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_158,masses2_3,G5tensor(:,17),T5sum(1:126,10))
  M(5) = M(5) + (CI*f(2) * den(1)) * TI2_call(5,momenta_159,masses2_3,G5tensor(:,22),T5sum(1:126,11))
  M(22) = M(22) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_159,masses2_3,G5tensor(:,22),T5sum(1:126,11))
  M(3) = M(3) + (CI*f(2) * den(1)) * TI2_call(5,momenta_159,masses2_3,G5tensor(:,16),T5sum(1:126,11))
  M(16) = M(16) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_159,masses2_3,G5tensor(:,16),T5sum(1:126,11))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(5,momenta_157,masses2_3,G5tensor(:,24),T5sum(1:126,12))
  M(24) = M(24) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_157,masses2_3,G5tensor(:,24),T5sum(1:126,12))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(5,momenta_157,masses2_3,G5tensor(:,18),T5sum(1:126,12))
  M(10) = M(10) + (-(CI*f(2)) * den(1)) * TI2_call(5,momenta_157,masses2_3,G5tensor(:,18),T5sum(1:126,12))
  M(6) = M(6) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(10) = M(10) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(315)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_2,G4tensor(:,24),T4sum(1:70,44))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_2,G4tensor(:,24),T4sum(1:70,44))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_76,masses2_2,G4tensor(:,24),T4sum(1:70,44))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_76,masses2_2,G4tensor(:,24),T4sum(1:70,44))
  M(4) = M(4) + (CI*f(2) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(317)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(4) = M(4) + (f(3) * den(316)) * TI2_call(4,momenta_41,masses2_2,G4tensor(:,73),T4sum(1:70,46))
  M(6) = M(6) + (-f(3) * den(316)) * TI2_call(4,momenta_41,masses2_2,G4tensor(:,73),T4sum(1:70,46))
  M(7) = M(7) + (-f(3) * den(316)) * TI2_call(4,momenta_41,masses2_2,G4tensor(:,73),T4sum(1:70,46))
  M(8) = M(8) + (f(3) * den(316)) * TI2_call(4,momenta_41,masses2_2,G4tensor(:,73),T4sum(1:70,46))
  M(10) = M(10) + (-f(3) * den(316)) * TI2_call(4,momenta_32,masses2_2,G4tensor(:,74),T4sum(1:70,47))
  M(12) = M(12) + (f(3) * den(316)) * TI2_call(4,momenta_32,masses2_2,G4tensor(:,74),T4sum(1:70,47))
  M(17) = M(17) + (f(3) * den(316)) * TI2_call(4,momenta_32,masses2_2,G4tensor(:,74),T4sum(1:70,47))
  M(23) = M(23) + (-f(3) * den(316)) * TI2_call(4,momenta_32,masses2_2,G4tensor(:,74),T4sum(1:70,47))
  M(4) = M(4) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(319)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(4) = M(4) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,25),T4sum(1:70,28))
  M(7) = M(7) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,25),T4sum(1:70,28))
  M(10) = M(10) + (-f(3) * den(123)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,25),T4sum(1:70,28))
  M(17) = M(17) + (f(3) * den(123)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,25),T4sum(1:70,28))
  M(6) = M(6) + (-(CI*f(2)) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(2) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(2)) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(321)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(10) = M(10) + (-f(3) * den(119)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,75),T4sum(1:70,19))
  M(11) = M(11) + (f(3) * den(119)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,75),T4sum(1:70,19))
  M(17) = M(17) + (f(3) * den(119)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,75),T4sum(1:70,19))
  M(20) = M(20) + (-f(3) * den(119)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,75),T4sum(1:70,19))
  M(6) = M(6) + (-f(3) * den(119)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,70),T4sum(1:70,20))
  M(8) = M(8) + (f(3) * den(119)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,70),T4sum(1:70,20))
  M(9) = M(9) + (-f(3) * den(119)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,70),T4sum(1:70,20))
  M(14) = M(14) + (f(3) * den(119)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,70),T4sum(1:70,20))
  M(4) = M(4) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(9) = M(9) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(20) = M(20) + (CI*f(2) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(322)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(2) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(2)) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(2) * den(323)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(9) = M(9) + (f(3) * den(114)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,76),T4sum(1:70,16))
  M(12) = M(12) + (-f(3) * den(114)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,76),T4sum(1:70,16))
  M(14) = M(14) + (-f(3) * den(114)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,76),T4sum(1:70,16))
  M(23) = M(23) + (f(3) * den(114)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,76),T4sum(1:70,16))
  M(4) = M(4) + (-f(3) * den(114)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,61),T4sum(1:70,17))
  M(7) = M(7) + (f(3) * den(114)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,61),T4sum(1:70,17))
  M(11) = M(11) + (-f(3) * den(114)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,61),T4sum(1:70,17))
  M(20) = M(20) + (f(3) * den(114)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,61),T4sum(1:70,17))
  M(4) = M(4) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,10),T4sum(1:70,18))
  M(7) = M(7) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,10),T4sum(1:70,18))
  M(11) = M(11) + (-f(3) * den(114)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,10),T4sum(1:70,18))
  M(20) = M(20) + (f(3) * den(114)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,10),T4sum(1:70,18))
  M(9) = M(9) + (CI*f(2) * den(10)) * TI2_call(5,momenta_150,masses2_3,G5tensor(:,41),T5sum(1:126,13))
  M(14) = M(14) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_150,masses2_3,G5tensor(:,41),T5sum(1:126,13))
  M(12) = M(12) + (CI*f(2) * den(10)) * TI2_call(5,momenta_139,masses2_3,G5tensor(:,47),T5sum(1:126,14))
  M(23) = M(23) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_139,masses2_3,G5tensor(:,47),T5sum(1:126,14))
  M(11) = M(11) + (CI*f(2) * den(10)) * TI2_call(5,momenta_142,masses2_3,G5tensor(:,36),T5sum(1:126,15))
  M(20) = M(20) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_142,masses2_3,G5tensor(:,36),T5sum(1:126,15))
  M(10) = M(10) + (CI*f(2) * den(10)) * TI2_call(5,momenta_138,masses2_3,G5tensor(:,48),T5sum(1:126,16))
  M(17) = M(17) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_138,masses2_3,G5tensor(:,48),T5sum(1:126,16))
  M(4) = M(4) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_143,masses2_3,G5tensor(:,37),T5sum(1:126,17))
  M(7) = M(7) + (CI*f(2) * den(10)) * TI2_call(5,momenta_143,masses2_3,G5tensor(:,37),T5sum(1:126,17))
  M(6) = M(6) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_151,masses2_3,G5tensor(:,42),T5sum(1:126,18))
  M(8) = M(8) + (CI*f(2) * den(10)) * TI2_call(5,momenta_151,masses2_3,G5tensor(:,42),T5sum(1:126,18))
  M(4) = M(4) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_198,masses2_3,G5tensor(:,4),T5sum(1:126,19))
  M(7) = M(7) + (CI*f(2) * den(10)) * TI2_call(5,momenta_198,masses2_3,G5tensor(:,4),T5sum(1:126,19))
  M(10) = M(10) + (CI*f(2) * den(10)) * TI2_call(5,momenta_203,masses2_3,G5tensor(:,11),T5sum(1:126,20))
  M(17) = M(17) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_203,masses2_3,G5tensor(:,11),T5sum(1:126,20))
  M(1) = M(1) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(24) = M(24) + (-(CI*f(2)) * den(327)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_2,G4tensor(:,26),T4sum(1:70,52))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_2,G4tensor(:,26),T4sum(1:70,52))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_77,masses2_2,G4tensor(:,26),T4sum(1:70,52))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_77,masses2_2,G4tensor(:,26),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(7) = M(7) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(23) = M(23) + (-(CI*f(2)) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(331)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,27),T4sum(1:70,28))
  M(7) = M(7) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,27),T4sum(1:70,28))
  M(17) = M(17) + (f(3) * den(145)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,27),T4sum(1:70,28))
  M(18) = M(18) + (-f(3) * den(145)) * TI2_call(4,momenta_78,masses2_2,G4tensor(:,27),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(8) = M(8) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(15) = M(15) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(17) = M(17) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(19) = M(19) + (-(CI*f(2)) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(333)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(13) = M(13) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,4),T4sum(1:70,9))
  M(15) = M(15) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,4),T4sum(1:70,9))
  M(17) = M(17) + (f(3) * den(134)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,4),T4sum(1:70,9))
  M(18) = M(18) + (-f(3) * den(134)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,4),T4sum(1:70,9))
  M(17) = M(17) + (CI*f(2) * den(33)) * TI2_call(5,momenta_195,masses2_3,G5tensor(:,1),T5sum(1:126,31))
  M(18) = M(18) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_195,masses2_3,G5tensor(:,1),T5sum(1:126,31))
  M(1) = M(1) + (CI*f(2) * den(33)) * TI2_call(5,momenta_204,masses2_3,G5tensor(:,12),T5sum(1:126,32))
  M(7) = M(7) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_204,masses2_3,G5tensor(:,12),T5sum(1:126,32))
  M(2) = M(2) + (CI*f(2) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(2)) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(2) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(339)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(2) = M(2) + (f(3) * den(338)) * TI2_call(4,momenta_39,masses2_2,G4tensor(:,77),T4sum(1:70,61))
  M(5) = M(5) + (-f(3) * den(338)) * TI2_call(4,momenta_39,masses2_2,G4tensor(:,77),T4sum(1:70,61))
  M(13) = M(13) + (-f(3) * den(338)) * TI2_call(4,momenta_39,masses2_2,G4tensor(:,77),T4sum(1:70,61))
  M(14) = M(14) + (f(3) * den(338)) * TI2_call(4,momenta_39,masses2_2,G4tensor(:,77),T4sum(1:70,61))
  M(11) = M(11) + (f(3) * den(338)) * TI2_call(4,momenta_34,masses2_2,G4tensor(:,78),T4sum(1:70,62))
  M(16) = M(16) + (-f(3) * den(338)) * TI2_call(4,momenta_34,masses2_2,G4tensor(:,78),T4sum(1:70,62))
  M(18) = M(18) + (f(3) * den(338)) * TI2_call(4,momenta_34,masses2_2,G4tensor(:,78),T4sum(1:70,62))
  M(21) = M(21) + (-f(3) * den(338)) * TI2_call(4,momenta_34,masses2_2,G4tensor(:,78),T4sum(1:70,62))
  M(5) = M(5) + (CI*f(2) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(343)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(11) = M(11) + (-f(3) * den(158)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,79),T4sum(1:70,19))
  M(16) = M(16) + (f(3) * den(158)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,79),T4sum(1:70,19))
  M(17) = M(17) + (-f(3) * den(158)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,79),T4sum(1:70,19))
  M(19) = M(19) + (f(3) * den(158)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,79),T4sum(1:70,19))
  M(5) = M(5) + (f(3) * den(158)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,71),T4sum(1:70,20))
  M(8) = M(8) + (-f(3) * den(158)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,71),T4sum(1:70,20))
  M(14) = M(14) + (-f(3) * den(158)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,71),T4sum(1:70,20))
  M(15) = M(15) + (f(3) * den(158)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,71),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(2) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(2)) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(2) * den(345)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,5))
  M(8) = M(8) + (-f(3) * den(136)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,80),T4sum(1:70,13))
  M(15) = M(15) + (f(3) * den(136)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,80),T4sum(1:70,13))
  M(18) = M(18) + (-f(3) * den(136)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,80),T4sum(1:70,13))
  M(21) = M(21) + (f(3) * den(136)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,80),T4sum(1:70,13))
  M(2) = M(2) + (-f(3) * den(136)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,52),T4sum(1:70,14))
  M(13) = M(13) + (f(3) * den(136)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,52),T4sum(1:70,14))
  M(17) = M(17) + (-f(3) * den(136)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,52),T4sum(1:70,14))
  M(19) = M(19) + (f(3) * den(136)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,52),T4sum(1:70,14))
  M(8) = M(8) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_152,masses2_3,G5tensor(:,43),T5sum(1:126,37))
  M(15) = M(15) + (CI*f(2) * den(15)) * TI2_call(5,momenta_152,masses2_3,G5tensor(:,43),T5sum(1:126,37))
  M(18) = M(18) + (CI*f(2) * den(15)) * TI2_call(5,momenta_146,masses2_3,G5tensor(:,50),T5sum(1:126,38))
  M(21) = M(21) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_146,masses2_3,G5tensor(:,50),T5sum(1:126,38))
  M(17) = M(17) + (CI*f(2) * den(15)) * TI2_call(5,momenta_135,masses2_3,G5tensor(:,31),T5sum(1:126,39))
  M(19) = M(19) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_135,masses2_3,G5tensor(:,31),T5sum(1:126,39))
  M(11) = M(11) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_145,masses2_3,G5tensor(:,51),T5sum(1:126,40))
  M(16) = M(16) + (CI*f(2) * den(15)) * TI2_call(5,momenta_145,masses2_3,G5tensor(:,51),T5sum(1:126,40))
  M(2) = M(2) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_136,masses2_3,G5tensor(:,32),T5sum(1:126,41))
  M(13) = M(13) + (CI*f(2) * den(15)) * TI2_call(5,momenta_136,masses2_3,G5tensor(:,32),T5sum(1:126,41))
  M(5) = M(5) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_149,masses2_3,G5tensor(:,44),T5sum(1:126,42))
  M(14) = M(14) + (CI*f(2) * den(15)) * TI2_call(5,momenta_149,masses2_3,G5tensor(:,44),T5sum(1:126,42))
  M(1) = M(1) + (-(CI*f(2)) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(2) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(2)) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(357)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,5))
  M(1) = M(1) + (f(3) * den(356)) * TI2_call(4,momenta_35,masses2_2,G4tensor(:,81),T4sum(1:70,70))
  M(3) = M(3) + (-f(3) * den(356)) * TI2_call(4,momenta_35,masses2_2,G4tensor(:,81),T4sum(1:70,70))
  M(19) = M(19) + (-f(3) * den(356)) * TI2_call(4,momenta_35,masses2_2,G4tensor(:,81),T4sum(1:70,70))
  M(20) = M(20) + (f(3) * den(356)) * TI2_call(4,momenta_35,masses2_2,G4tensor(:,81),T4sum(1:70,70))
  M(9) = M(9) + (f(3) * den(356)) * TI2_call(4,momenta_38,masses2_2,G4tensor(:,82),T4sum(1:70,71))
  M(15) = M(15) + (-f(3) * den(356)) * TI2_call(4,momenta_38,masses2_2,G4tensor(:,82),T4sum(1:70,71))
  M(22) = M(22) + (-f(3) * den(356)) * TI2_call(4,momenta_38,masses2_2,G4tensor(:,82),T4sum(1:70,71))
  M(24) = M(24) + (f(3) * den(356)) * TI2_call(4,momenta_38,masses2_2,G4tensor(:,82),T4sum(1:70,71))
  M(5) = M(5) + (CI*f(2) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(2) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(2)) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(362)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,5))
  M(10) = M(10) + (-f(3) * den(180)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,83),T4sum(1:70,19))
  M(16) = M(16) + (f(3) * den(180)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,83),T4sum(1:70,19))
  M(19) = M(19) + (f(3) * den(180)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,83),T4sum(1:70,19))
  M(20) = M(20) + (-f(3) * den(180)) * TI2_call(4,momenta_36,masses2_2,G4tensor(:,83),T4sum(1:70,19))
  M(5) = M(5) + (f(3) * den(180)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,72),T4sum(1:70,20))
  M(6) = M(6) + (-f(3) * den(180)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,72),T4sum(1:70,20))
  M(9) = M(9) + (-f(3) * den(180)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,72),T4sum(1:70,20))
  M(15) = M(15) + (f(3) * den(180)) * TI2_call(4,momenta_37,masses2_2,G4tensor(:,72),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(2)) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(2) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(2) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(2)) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(2)) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(363)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,5))
  M(10) = M(10) + (-f(3) * den(86)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,43),T4sum(1:70,3))
  M(16) = M(16) + (f(3) * den(86)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,43),T4sum(1:70,3))
  M(22) = M(22) + (f(3) * den(86)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,43),T4sum(1:70,3))
  M(24) = M(24) + (-f(3) * den(86)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,43),T4sum(1:70,3))
  M(10) = M(10) + (CI*f(2) * den(51)) * TI2_call(5,momenta_129,masses2_3,G5tensor(:,25),T5sum(1:126,67))
  M(16) = M(16) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_129,masses2_3,G5tensor(:,25),T5sum(1:126,67))
  M(19) = M(19) + (CI*f(2) * den(51)) * TI2_call(5,momenta_147,masses2_3,G5tensor(:,52),T5sum(1:126,68))
  M(20) = M(20) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_147,masses2_3,G5tensor(:,52),T5sum(1:126,68))
  M(22) = M(22) + (CI*f(2) * den(51)) * TI2_call(5,momenta_130,masses2_3,G5tensor(:,26),T5sum(1:126,69))
  M(24) = M(24) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_130,masses2_3,G5tensor(:,26),T5sum(1:126,69))
  M(9) = M(9) + (CI*f(2) * den(51)) * TI2_call(5,momenta_148,masses2_3,G5tensor(:,45),T5sum(1:126,70))
  M(15) = M(15) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_148,masses2_3,G5tensor(:,45),T5sum(1:126,70))
  M(1) = M(1) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(24) = M(24) + (CI*f(2) * den(366)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,17),T4sum(1:70,24))
  M(9) = M(9) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,17),T4sum(1:70,24))
  M(19) = M(19) + (f(3) * den(178)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,17),T4sum(1:70,24))
  M(22) = M(22) + (-f(3) * den(178)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,17),T4sum(1:70,24))
  M(3) = M(3) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(7) = M(7) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(23) = M(23) + (CI*f(2) * den(368)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(2)) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(2) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(369)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,5))
  M(9) = M(9) + (-f(3) * den(168)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,84),T4sum(1:70,16))
  M(13) = M(13) + (f(3) * den(168)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,84),T4sum(1:70,16))
  M(22) = M(22) + (f(3) * den(168)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,84),T4sum(1:70,16))
  M(23) = M(23) + (-f(3) * den(168)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,84),T4sum(1:70,16))
  M(3) = M(3) + (f(3) * den(168)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,62),T4sum(1:70,17))
  M(7) = M(7) + (-f(3) * den(168)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,62),T4sum(1:70,17))
  M(20) = M(20) + (-f(3) * den(168)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,62),T4sum(1:70,17))
  M(21) = M(21) + (f(3) * den(168)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,62),T4sum(1:70,17))
  M(3) = M(3) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,11),T4sum(1:70,18))
  M(7) = M(7) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,11),T4sum(1:70,18))
  M(20) = M(20) + (-f(3) * den(168)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,11),T4sum(1:70,18))
  M(21) = M(21) + (f(3) * den(168)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,11),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(2)) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(2)) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(2) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(371)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,5))
  M(7) = M(7) + (f(3) * den(141)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,85),T4sum(1:70,13))
  M(15) = M(15) + (-f(3) * den(141)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,85),T4sum(1:70,13))
  M(21) = M(21) + (-f(3) * den(141)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,85),T4sum(1:70,13))
  M(24) = M(24) + (f(3) * den(141)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,85),T4sum(1:70,13))
  M(1) = M(1) + (f(3) * den(141)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,53),T4sum(1:70,14))
  M(13) = M(13) + (-f(3) * den(141)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,53),T4sum(1:70,14))
  M(19) = M(19) + (-f(3) * den(141)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,53),T4sum(1:70,14))
  M(23) = M(23) + (f(3) * den(141)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,53),T4sum(1:70,14))
  M(7) = M(7) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_144,masses2_3,G5tensor(:,38),T5sum(1:126,73))
  M(21) = M(21) + (CI*f(2) * den(19)) * TI2_call(5,momenta_144,masses2_3,G5tensor(:,38),T5sum(1:126,73))
  M(15) = M(15) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_154,masses2_3,G5tensor(:,53),T5sum(1:126,74))
  M(24) = M(24) + (CI*f(2) * den(19)) * TI2_call(5,momenta_154,masses2_3,G5tensor(:,53),T5sum(1:126,74))
  M(13) = M(13) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_137,masses2_3,G5tensor(:,33),T5sum(1:126,75))
  M(23) = M(23) + (CI*f(2) * den(19)) * TI2_call(5,momenta_137,masses2_3,G5tensor(:,33),T5sum(1:126,75))
  M(9) = M(9) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_153,masses2_3,G5tensor(:,54),T5sum(1:126,76))
  M(22) = M(22) + (CI*f(2) * den(19)) * TI2_call(5,momenta_153,masses2_3,G5tensor(:,54),T5sum(1:126,76))
  M(1) = M(1) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_134,masses2_3,G5tensor(:,34),T5sum(1:126,77))
  M(19) = M(19) + (CI*f(2) * den(19)) * TI2_call(5,momenta_134,masses2_3,G5tensor(:,34),T5sum(1:126,77))
  M(3) = M(3) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_141,masses2_3,G5tensor(:,39),T5sum(1:126,78))
  M(20) = M(20) + (CI*f(2) * den(19)) * TI2_call(5,momenta_141,masses2_3,G5tensor(:,39),T5sum(1:126,78))
  M(7) = M(7) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_197,masses2_3,G5tensor(:,5),T5sum(1:126,83))
  M(21) = M(21) + (CI*f(2) * den(19)) * TI2_call(5,momenta_197,masses2_3,G5tensor(:,5),T5sum(1:126,83))
  M(1) = M(1) + (-(CI*f(2)) * den(19)) * TI2_call(5,momenta_201,masses2_3,G5tensor(:,8),T5sum(1:126,84))
  M(19) = M(19) + (CI*f(2) * den(19)) * TI2_call(5,momenta_201,masses2_3,G5tensor(:,8),T5sum(1:126,84))
  M(5) = M(5) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(6) = M(6) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(9) = M(9) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(10) = M(10) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(20) = M(20) + (-(CI*f(2)) * den(372)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(5) = M(5) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,18),T4sum(1:70,24))
  M(9) = M(9) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,18),T4sum(1:70,24))
  M(10) = M(10) + (-f(3) * den(182)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,18),T4sum(1:70,24))
  M(19) = M(19) + (f(3) * den(182)) * TI2_call(4,momenta_75,masses2_2,G4tensor(:,18),T4sum(1:70,24))
  M(5) = M(5) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(8) = M(8) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(15) = M(15) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(17) = M(17) + (-(CI*f(2)) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(19) = M(19) + (CI*f(2) * den(374)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(14) = M(14) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,5),T4sum(1:70,9))
  M(15) = M(15) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,5),T4sum(1:70,9))
  M(16) = M(16) + (f(3) * den(156)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,5),T4sum(1:70,9))
  M(17) = M(17) + (-f(3) * den(156)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,5),T4sum(1:70,9))
  M(14) = M(14) + (CI*f(2) * den(42)) * TI2_call(5,momenta_194,masses2_3,G5tensor(:,2),T5sum(1:126,95))
  M(17) = M(17) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_194,masses2_3,G5tensor(:,2),T5sum(1:126,95))
  M(9) = M(9) + (CI*f(2) * den(42)) * TI2_call(5,momenta_200,masses2_3,G5tensor(:,9),T5sum(1:126,96))
  M(10) = M(10) + (-(CI*f(2)) * den(42)) * TI2_call(5,momenta_200,masses2_3,G5tensor(:,9),T5sum(1:126,96))
  M(3) = M(3) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(12) = M(12) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(22) = M(22) + (-(CI*f(2)) * den(378)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(11) = M(11) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(13) = M(13) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(14) = M(14) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(16) = M(16) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(18) = M(18) + (-(CI*f(2)) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(21) = M(21) + (CI*f(2) * den(379)) * TI2_call(3,momenta_8,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(2)) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(2) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(2) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(2)) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(2)) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(380)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,5))
  M(12) = M(12) + (-f(3) * den(170)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,86),T4sum(1:70,16))
  M(13) = M(13) + (f(3) * den(170)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,86),T4sum(1:70,16))
  M(14) = M(14) + (-f(3) * den(170)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,86),T4sum(1:70,16))
  M(22) = M(22) + (f(3) * den(170)) * TI2_call(4,momenta_40,masses2_2,G4tensor(:,86),T4sum(1:70,16))
  M(3) = M(3) + (f(3) * den(170)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,63),T4sum(1:70,17))
  M(4) = M(4) + (-f(3) * den(170)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,63),T4sum(1:70,17))
  M(11) = M(11) + (-f(3) * den(170)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,63),T4sum(1:70,17))
  M(21) = M(21) + (f(3) * den(170)) * TI2_call(4,momenta_33,masses2_2,G4tensor(:,63),T4sum(1:70,17))
  M(3) = M(3) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,12),T4sum(1:70,18))
  M(4) = M(4) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,12),T4sum(1:70,18))
  M(11) = M(11) + (-f(3) * den(170)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,12),T4sum(1:70,18))
  M(21) = M(21) + (f(3) * den(170)) * TI2_call(4,momenta_73,masses2_2,G4tensor(:,12),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(2) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(2)) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(2)) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(2) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(2) * den(381)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,5))
  M(13) = M(13) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(14) = M(14) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(16) = M(16) + (f(3) * den(160)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(18) = M(18) + (-f(3) * den(160)) * TI2_call(4,momenta_72,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(12) = M(12) + (f(3) * den(91)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,44),T4sum(1:70,3))
  M(16) = M(16) + (-f(3) * den(91)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,44),T4sum(1:70,3))
  M(18) = M(18) + (f(3) * den(91)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,44),T4sum(1:70,3))
  M(22) = M(22) + (-f(3) * den(91)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,44),T4sum(1:70,3))
  M(12) = M(12) + (CI*f(2) * den(55)) * TI2_call(5,momenta_131,masses2_3,G5tensor(:,27),T5sum(1:126,103))
  M(22) = M(22) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_131,masses2_3,G5tensor(:,27),T5sum(1:126,103))
  M(13) = M(13) + (CI*f(2) * den(55)) * TI2_call(5,momenta_155,masses2_3,G5tensor(:,49),T5sum(1:126,104))
  M(14) = M(14) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_155,masses2_3,G5tensor(:,49),T5sum(1:126,104))
  M(16) = M(16) + (CI*f(2) * den(55)) * TI2_call(5,momenta_128,masses2_3,G5tensor(:,28),T5sum(1:126,105))
  M(18) = M(18) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_128,masses2_3,G5tensor(:,28),T5sum(1:126,105))
  M(11) = M(11) + (CI*f(2) * den(55)) * TI2_call(5,momenta_140,masses2_3,G5tensor(:,40),T5sum(1:126,106))
  M(21) = M(21) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_140,masses2_3,G5tensor(:,40),T5sum(1:126,106))
  M(16) = M(16) + (CI*f(2) * den(55)) * TI2_call(5,momenta_193,masses2_3,G5tensor(:,3),T5sum(1:126,107))
  M(18) = M(18) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_193,masses2_3,G5tensor(:,3),T5sum(1:126,107))
  M(3) = M(3) + (CI*f(2) * den(55)) * TI2_call(5,momenta_196,masses2_3,G5tensor(:,6),T5sum(1:126,108))
  M(4) = M(4) + (-(CI*f(2)) * den(55)) * TI2_call(5,momenta_196,masses2_3,G5tensor(:,6),T5sum(1:126,108))
  M(1) = M(1) + (-(CI*f(2)) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(2) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(2)) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(2) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(2)) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(386)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(2)) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(2) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(2) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(2)) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(2)) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(2) * den(387)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,5))
  M(7) = M(7) + (f(3) * den(143)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,87),T4sum(1:70,13))
  M(8) = M(8) + (-f(3) * den(143)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,87),T4sum(1:70,13))
  M(18) = M(18) + (-f(3) * den(143)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,87),T4sum(1:70,13))
  M(24) = M(24) + (f(3) * den(143)) * TI2_call(4,momenta_42,masses2_2,G4tensor(:,87),T4sum(1:70,13))
  M(1) = M(1) + (f(3) * den(143)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,54),T4sum(1:70,14))
  M(2) = M(2) + (-f(3) * den(143)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,54),T4sum(1:70,14))
  M(17) = M(17) + (-f(3) * den(143)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,54),T4sum(1:70,14))
  M(23) = M(23) + (f(3) * den(143)) * TI2_call(4,momenta_31,masses2_2,G4tensor(:,54),T4sum(1:70,14))
  M(10) = M(10) + (-f(3) * den(95)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,45),T4sum(1:70,3))
  M(12) = M(12) + (f(3) * den(95)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,45),T4sum(1:70,3))
  M(18) = M(18) + (f(3) * den(95)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,45),T4sum(1:70,3))
  M(24) = M(24) + (-f(3) * den(95)) * TI2_call(4,momenta_30,masses2_2,G4tensor(:,45),T4sum(1:70,3))
  M(18) = M(18) + (CI*f(2) * den(61)) * TI2_call(5,momenta_132,masses2_3,G5tensor(:,29),T5sum(1:126,115))
  M(24) = M(24) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_132,masses2_3,G5tensor(:,29),T5sum(1:126,115))
  M(7) = M(7) + (CI*f(2) * den(61)) * TI2_call(5,momenta_156,masses2_3,G5tensor(:,46),T5sum(1:126,116))
  M(8) = M(8) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_156,masses2_3,G5tensor(:,46),T5sum(1:126,116))
  M(10) = M(10) + (CI*f(2) * den(61)) * TI2_call(5,momenta_127,masses2_3,G5tensor(:,30),T5sum(1:126,117))
  M(12) = M(12) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_127,masses2_3,G5tensor(:,30),T5sum(1:126,117))
  M(17) = M(17) + (CI*f(2) * den(61)) * TI2_call(5,momenta_133,masses2_3,G5tensor(:,35),T5sum(1:126,118))
  M(23) = M(23) + (-(CI*f(2)) * den(61)) * TI2_call(5,momenta_133,masses2_3,G5tensor(:,35),T5sum(1:126,118))
  M(18) = M(18) + (-f(3)) * TI2_call(6,momenta_238,masses2_4,G6tensor(:,9),T6sum(1:210,25))
  M(24) = M(24) + (-f(3)) * TI2_call(6,momenta_240,masses2_4,G6tensor(:,7),T6sum(1:210,26))
  M(8) = M(8) + (-f(3)) * TI2_call(6,momenta_252,masses2_4,G6tensor(:,21),T6sum(1:210,27))
  M(7) = M(7) + (-f(3)) * TI2_call(6,momenta_248,masses2_4,G6tensor(:,17),T6sum(1:210,28))
  M(21) = M(21) + (-f(3)) * TI2_call(6,momenta_246,masses2_4,G6tensor(:,19),T6sum(1:210,29))
  M(15) = M(15) + (-f(3)) * TI2_call(6,momenta_250,masses2_4,G6tensor(:,23),T6sum(1:210,30))
  M(12) = M(12) + (-f(3)) * TI2_call(6,momenta_236,masses2_4,G6tensor(:,11),T6sum(1:210,31))
  M(22) = M(22) + (-f(3)) * TI2_call(6,momenta_239,masses2_4,G6tensor(:,8),T6sum(1:210,32))
  M(14) = M(14) + (-f(3)) * TI2_call(6,momenta_251,masses2_4,G6tensor(:,22),T6sum(1:210,33))
  M(23) = M(23) + (-f(3)) * TI2_call(6,momenta_242,masses2_4,G6tensor(:,15),T6sum(1:210,34))
  M(9) = M(9) + (-f(3)) * TI2_call(6,momenta_249,masses2_4,G6tensor(:,24),T6sum(1:210,35))
  M(13) = M(13) + (-f(3)) * TI2_call(6,momenta_244,masses2_4,G6tensor(:,13),T6sum(1:210,36))
  M(10) = M(10) + (-f(3)) * TI2_call(6,momenta_235,masses2_4,G6tensor(:,12),T6sum(1:210,37))
  M(16) = M(16) + (-f(3)) * TI2_call(6,momenta_237,masses2_4,G6tensor(:,10),T6sum(1:210,38))
  M(17) = M(17) + (-f(3)) * TI2_call(6,momenta_241,masses2_4,G6tensor(:,16),T6sum(1:210,39))
  M(11) = M(11) + (-f(3)) * TI2_call(6,momenta_245,masses2_4,G6tensor(:,20),T6sum(1:210,40))
  M(20) = M(20) + (-f(3)) * TI2_call(6,momenta_247,masses2_4,G6tensor(:,18),T6sum(1:210,41))
  M(19) = M(19) + (-f(3)) * TI2_call(6,momenta_243,masses2_4,G6tensor(:,14),T6sum(1:210,42))
  M(4) = M(4) + (-f(3)) * TI2_call(6,momenta_267,masses2_4,G6tensor(:,4),T6sum(1:210,55))
  M(10) = M(10) + (-f(3)) * TI2_call(6,momenta_269,masses2_4,G6tensor(:,6),T6sum(1:210,56))
  M(18) = M(18) + (-f(3)) * TI2_call(6,momenta_265,masses2_4,G6tensor(:,2),T6sum(1:210,57))
  M(1) = M(1) + (-f(3)) * TI2_call(6,momenta_270,masses2_4,G6tensor(:,5),T6sum(1:210,58))
  M(17) = M(17) + (-f(3)) * TI2_call(6,momenta_266,masses2_4,G6tensor(:,1),T6sum(1:210,59))
  M(7) = M(7) + (-f(3)) * TI2_call(6,momenta_268,masses2_4,G6tensor(:,3),T6sum(1:210,60))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)
  deallocate(G6tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphjjj2_hggggg_1_/**/REALKIND
