
module ol_vamp_2_pphjjj2_ddxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_ddxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_ddxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_ddxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_ddxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,76) :: G0
  complex(REALKIND), dimension(4,5,4,180) :: G1
  complex(REALKIND), dimension(4,15,4,210) :: G2
  complex(REALKIND), dimension(4,35,4,60) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,75,32))
    allocate(G4tensorhel(70,30,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,11),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,27),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,59),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,43),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,-4),G2(:,:,:,4))
  call loop_Q_A(G2(:,:,:,4),Q(:,59),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,27),MT,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,-5),G2(:,:,:,6))
  call loop_Q_A(G2(:,:,:,6),Q(:,59),MT,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,11),MB,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,27),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,59),MB,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-5),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,43),MB,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,59),MB,G3(:,:,:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,27),MB,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,59),MB,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,11),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,27),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,59),MB,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,9),wf(:,-5),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,43),MB,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-4),G2(:,:,:,16))
  call loop_Q_A(G2(:,:,:,16),Q(:,59),MB,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,9),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,27),MB,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-5),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,59),MB,G3(:,:,:,11))
  call loop_QS_A(G3(:,:,:,11),wf(:,-2),G3(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,99),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,27),MT,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,59),MT,G2(:,:,:,19))
  call loop_QS_A(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,99),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,27),MT,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,59),MT,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,-2),G2(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,99),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,27),MB,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,59),MB,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,-2),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,99),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,27),MB,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),MB,G2(:,:,:,25))
  call loop_AS_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,27),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,59),MT,G2(:,:,:,27))
  call loop_QS_A(G2(:,:,:,27),wf(:,-2),G2(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,27),MT,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-5),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),MT,G2(:,:,:,29))
  call loop_AS_Q(G2(:,:,:,29),wf(:,-2),G2(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,27),MB,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,59),MB,G2(:,:,:,31))
  call loop_QS_A(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,27),MB,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,59),MB,G2(:,:,:,33))
  call loop_AS_Q(G2(:,:,:,33),wf(:,-2),G2(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,27),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,59),MT,G2(:,:,:,35))
  call loop_QS_A(G2(:,:,:,35),wf(:,-2),G2(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,27),MT,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,59),MT,G2(:,:,:,37))
  call loop_AS_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,27),MB,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,-5),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,59),MB,G2(:,:,:,39))
  call loop_QS_A(G2(:,:,:,39),wf(:,-2),G2(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,27),MB,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,59),MB,G2(:,:,:,41))
  call loop_AS_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,15))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,11),MT,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,27),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,59),MT,G2(:,:,:,43))
  call loop_AS_Q(G2(:,:,:,43),wf(:,-2),G2(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-5),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,43),MT,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,59),MT,G3(:,:,:,13))
  call loop_AS_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,27),MT,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,59),MT,G3(:,:,:,15))
  call loop_AS_Q(G3(:,:,:,15),wf(:,-2),G3(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,11),MT,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,27),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,59),MT,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,-2),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,41),wf(:,-5),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,43),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,59),MT,G3(:,:,:,17))
  call loop_QS_A(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,41),wf(:,-4),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,27),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-5),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,59),MT,G3(:,:,:,19))
  call loop_QS_A(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,11),MB,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,27),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,59),MB,G2(:,:,:,55))
  call loop_AS_Q(G2(:,:,:,55),wf(:,-2),G2(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-5),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,43),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,59),MB,G3(:,:,:,21))
  call loop_AS_Q(G3(:,:,:,21),wf(:,-2),G3(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-4),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,27),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,59),MB,G3(:,:,:,23))
  call loop_AS_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,11),MB,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,27),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,59),MB,G2(:,:,:,61))
  call loop_QS_A(G2(:,:,:,61),wf(:,-2),G2(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,49),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,43),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,59),MB,G3(:,:,:,25))
  call loop_QS_A(G3(:,:,:,25),wf(:,-2),G3(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,49),wf(:,-4),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,27),MB,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,59),MB,G3(:,:,:,27))
  call loop_QS_A(G3(:,:,:,27),wf(:,-2),G3(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,105),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,27),MT,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),MT,G2(:,:,:,67))
  call loop_QS_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,105),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,27),MT,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,59),MT,G2(:,:,:,69))
  call loop_AS_Q(G2(:,:,:,69),wf(:,-2),G2(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,105),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,27),MB,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,-5),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,59),MB,G2(:,:,:,71))
  call loop_QS_A(G2(:,:,:,71),wf(:,-2),G2(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,105),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,27),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-5),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),MB,G2(:,:,:,73))
  call loop_AS_Q(G2(:,:,:,73),wf(:,-2),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,23))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,27),MT,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,59),MT,G2(:,:,:,75))
  call loop_QS_A(G2(:,:,:,75),wf(:,-2),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,108),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,27),MT,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,59),MT,G2(:,:,:,77))
  call loop_AS_Q(G2(:,:,:,77),wf(:,-2),G2(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,27),MB,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-5),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,59),MB,G2(:,:,:,79))
  call loop_QS_A(G2(:,:,:,79),wf(:,-2),G2(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MB,G3tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,108),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,27),MB,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,59),MB,G2(:,:,:,81))
  call loop_AS_Q(G2(:,:,:,81),wf(:,-2),G2(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,27),MT,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,59),MT,G2(:,:,:,83))
  call loop_QS_A(G2(:,:,:,83),wf(:,-2),G2(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,27),MT,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-5),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,59),MT,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,-2),G2(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,27),MB,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,-5),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,59),MB,G2(:,:,:,87))
  call loop_QS_A(G2(:,:,:,87),wf(:,-2),G2(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,27),MB,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),MB,G2(:,:,:,89))
  call loop_AS_Q(G2(:,:,:,89),wf(:,-2),G2(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,59),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,11),MT,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,27),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,59),MT,G2(:,:,:,91))
  call loop_AS_Q(G2(:,:,:,91),wf(:,-2),G2(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,43),MT,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,59),MT,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,27),MT,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,59),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,-2),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,11),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,27),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,59),MT,G2(:,:,:,97))
  call loop_QS_A(G2(:,:,:,97),wf(:,-2),G2(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,43),MT,G2(:,:,:,99))
  call loop_QV_A(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,59),MT,G3(:,:,:,33))
  call loop_QS_A(G3(:,:,:,33),wf(:,-2),G3(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,17))
  call loop_QV_A(G1(:,:,:,81),wf(:,-4),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,27),MT,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,59),MT,G3(:,:,:,35))
  call loop_QS_A(G3(:,:,:,35),wf(:,-2),G3(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,59),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,11),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,27),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,59),MB,G2(:,:,:,103))
  call loop_AS_Q(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,43),MB,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-4),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,59),MB,G3(:,:,:,37))
  call loop_AS_Q(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-4),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,27),MB,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-5),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,59),MB,G3(:,:,:,39))
  call loop_AS_Q(G3(:,:,:,39),wf(:,-2),G3(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,11),MB,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,27),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,59),MB,G2(:,:,:,109))
  call loop_QS_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MB,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,89),wf(:,-5),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,43),MB,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,59),MB,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,89),wf(:,-4),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,27),MB,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,59),MB,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,27),MT,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,-5),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,59),MT,G2(:,:,:,115))
  call loop_QS_A(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,111),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,27),MT,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-5),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,59),MT,G2(:,:,:,117))
  call loop_AS_Q(G2(:,:,:,117),wf(:,-2),G2(:,:,:,118),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,27),MB,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,-5),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,59),MB,G2(:,:,:,119))
  call loop_QS_A(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MB,G3tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,111),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,27),MB,G1(:,:,:,99))
  call loop_AV_Q(G1(:,:,:,99),wf(:,-5),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,59),MB,G2(:,:,:,121))
  call loop_AS_Q(G2(:,:,:,121),wf(:,-2),G2(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,63),MB,G3tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,114),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,27),MT,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,59),MT,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,114),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,27),MT,G1(:,:,:,103))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-5),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,59),MT,G2(:,:,:,125))
  call loop_AS_Q(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,114),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,27),MB,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,59),MB,G2(:,:,:,127))
  call loop_QS_A(G2(:,:,:,127),wf(:,-2),G2(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,114),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,27),MB,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,59),MB,G2(:,:,:,129))
  call loop_AS_Q(G2(:,:,:,129),wf(:,-2),G2(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G0(:,:,:,1),wf(:,69),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,19),MT,G1(:,:,:,109))
  call loop_AV_Q(G1(:,:,:,109),wf(:,23),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,59),MT,G2(:,:,:,131))
  call loop_AS_Q(G2(:,:,:,131),wf(:,-2),G2(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),MT,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,109),wf(:,-3),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,27),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,59),MT,G3(:,:,:,45))
  call loop_AS_Q(G3(:,:,:,45),wf(:,-2),G3(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,19),MT,G1(:,:,:,112))
  call loop_QV_A(G1(:,:,:,112),wf(:,23),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,59),MT,G2(:,:,:,135))
  call loop_QS_A(G2(:,:,:,135),wf(:,-2),G2(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),MT,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,112),wf(:,-3),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,27),MT,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-5),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,59),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,69),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,19),MB,G1(:,:,:,115))
  call loop_AV_Q(G1(:,:,:,115),wf(:,23),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,59),MB,G2(:,:,:,139))
  call loop_AS_Q(G2(:,:,:,139),wf(:,-2),G2(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),MB,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,115),wf(:,-3),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,27),MB,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,-5),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,59),MB,G3(:,:,:,49))
  call loop_AS_Q(G3(:,:,:,49),wf(:,-2),G3(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,63),MB,G4tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,19),MB,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,23),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,59),MB,G2(:,:,:,143))
  call loop_QS_A(G2(:,:,:,143),wf(:,-2),G2(:,:,:,144),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,63),MB,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,118),wf(:,-3),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,27),MB,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-5),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,59),MB,G3(:,:,:,51))
  call loop_QS_A(G3(:,:,:,51),wf(:,-2),G3(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MB,G4tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,27),MT,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,59),MT,G2(:,:,:,147))
  call loop_QS_A(G2(:,:,:,147),wf(:,-2),G2(:,:,:,148),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,117),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,27),MT,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,-5),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,59),MT,G2(:,:,:,149))
  call loop_AS_Q(G2(:,:,:,149),wf(:,-2),G2(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,63),MT,G3tensor(:,49))
  call loop_QV_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,27),MB,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,59),MB,G2(:,:,:,151))
  call loop_QS_A(G2(:,:,:,151),wf(:,-2),G2(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,63),MB,G3tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,117),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,27),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,59),MB,G2(:,:,:,153))
  call loop_AS_Q(G2(:,:,:,153),wf(:,-2),G2(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,51))
  call loop_QV_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,27),MT,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,-5),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,59),MT,G2(:,:,:,155))
  call loop_QS_A(G2(:,:,:,155),wf(:,-2),G2(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,63),MT,G3tensor(:,52))
  call loop_AV_Q(G0(:,:,:,1),wf(:,120),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,27),MT,G1(:,:,:,131))
  call loop_AV_Q(G1(:,:,:,131),wf(:,-5),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,59),MT,G2(:,:,:,157))
  call loop_AS_Q(G2(:,:,:,157),wf(:,-2),G2(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MT,G3tensor(:,53))
  call loop_QV_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,27),MB,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,59),MB,G2(:,:,:,159))
  call loop_QS_A(G2(:,:,:,159),wf(:,-2),G2(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),MB,G3tensor(:,54))
  call loop_AV_Q(G0(:,:,:,1),wf(:,120),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,27),MB,G1(:,:,:,135))
  call loop_AV_Q(G1(:,:,:,135),wf(:,-5),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,59),MB,G2(:,:,:,161))
  call loop_AS_Q(G2(:,:,:,161),wf(:,-2),G2(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),MB,G3tensor(:,55))
  call loop_AV_Q(G0(:,:,:,1),wf(:,71),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,19),MT,G1(:,:,:,137))
  call loop_AV_Q(G1(:,:,:,137),wf(:,23),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,59),MT,G2(:,:,:,163))
  call loop_AS_Q(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,137),wf(:,-3),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,27),MT,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-5),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,59),MT,G3(:,:,:,53))
  call loop_AS_Q(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,19),MT,G1(:,:,:,140))
  call loop_QV_A(G1(:,:,:,140),wf(:,23),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,59),MT,G2(:,:,:,167))
  call loop_QS_A(G2(:,:,:,167),wf(:,-2),G2(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,63),MT,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,140),wf(:,-3),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,27),MT,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-5),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,59),MT,G3(:,:,:,55))
  call loop_QS_A(G3(:,:,:,55),wf(:,-2),G3(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,63),MT,G4tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,71),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,19),MB,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,23),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,59),MB,G2(:,:,:,171))
  call loop_AS_Q(G2(:,:,:,171),wf(:,-2),G2(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,63),MB,G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-3),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,27),MB,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,59),MB,G3(:,:,:,57))
  call loop_AS_Q(G3(:,:,:,57),wf(:,-2),G3(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MB,G4tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,19),MB,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,23),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,59),MB,G2(:,:,:,175))
  call loop_QS_A(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,176),Q(:,63),MB,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,146),wf(:,-3),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,27),MB,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,-5),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,59),MB,G3(:,:,:,59))
  call loop_QS_A(G3(:,:,:,59),wf(:,-2),G3(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MB,G4tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,123),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,27),MT,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,-5),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,59),MT,G2(:,:,:,179))
  call loop_QS_A(G2(:,:,:,179),wf(:,-2),G2(:,:,:,180),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,180),Q(:,63),MT,G3tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,123),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,27),MT,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,59),MT,G2(:,:,:,181))
  call loop_AS_Q(G2(:,:,:,181),wf(:,-2),G2(:,:,:,182),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G0(:,:,:,1),wf(:,123),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,27),MB,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,59),MB,G2(:,:,:,183))
  call loop_QS_A(G2(:,:,:,183),wf(:,-2),G2(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,184),Q(:,63),MB,G3tensor(:,62))
  call loop_AV_Q(G0(:,:,:,1),wf(:,123),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,27),MB,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,59),MB,G2(:,:,:,185))
  call loop_AS_Q(G2(:,:,:,185),wf(:,-2),G2(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,27),MT,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,-5),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,59),MT,G2(:,:,:,187))
  call loop_QS_A(G2(:,:,:,187),wf(:,-2),G2(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,126),G0(:,:,:,66))
  call loop_A_Q(G0(:,:,:,66),Q(:,27),MT,G1(:,:,:,159))
  call loop_AV_Q(G1(:,:,:,159),wf(:,-5),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,59),MT,G2(:,:,:,189))
  call loop_AS_Q(G2(:,:,:,189),wf(:,-2),G2(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,27),MB,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,-5),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,59),MB,G2(:,:,:,191))
  call loop_QS_A(G2(:,:,:,191),wf(:,-2),G2(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),MB,G3tensor(:,66))
  call loop_AV_Q(G0(:,:,:,1),wf(:,126),G0(:,:,:,68))
  call loop_A_Q(G0(:,:,:,68),Q(:,27),MB,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-5),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,59),MB,G2(:,:,:,193))
  call loop_AS_Q(G2(:,:,:,193),wf(:,-2),G2(:,:,:,194),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,194),Q(:,63),MB,G3tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,129),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,27),MT,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,-5),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,59),MT,G2(:,:,:,195))
  call loop_QS_A(G2(:,:,:,195),wf(:,-2),G2(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G0(:,:,:,1),wf(:,129),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,27),MT,G1(:,:,:,167))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-5),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,59),MT,G2(:,:,:,197))
  call loop_AS_Q(G2(:,:,:,197),wf(:,-2),G2(:,:,:,198),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,129),G0(:,:,:,71))
  call loop_Q_A(G0(:,:,:,71),Q(:,27),MB,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,59),MB,G2(:,:,:,199))
  call loop_QS_A(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MB,G3tensor(:,70))
  call loop_AV_Q(G0(:,:,:,1),wf(:,129),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,27),MB,G1(:,:,:,171))
  call loop_AV_Q(G1(:,:,:,171),wf(:,-5),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,59),MB,G2(:,:,:,201))
  call loop_AS_Q(G2(:,:,:,201),wf(:,-2),G2(:,:,:,202),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,63),MB,G3tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,131),G0(:,:,:,73))
  call loop_Q_A(G0(:,:,:,73),Q(:,27),MT,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,59),MT,G2(:,:,:,203))
  call loop_QS_A(G2(:,:,:,203),wf(:,-2),G2(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,131),G0(:,:,:,74))
  call loop_A_Q(G0(:,:,:,74),Q(:,27),MT,G1(:,:,:,175))
  call loop_AV_Q(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,59),MT,G2(:,:,:,205))
  call loop_AS_Q(G2(:,:,:,205),wf(:,-2),G2(:,:,:,206),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,63),MT,G3tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,131),G0(:,:,:,75))
  call loop_Q_A(G0(:,:,:,75),Q(:,27),MB,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,59),MB,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,-2),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MB,G3tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,131),G0(:,:,:,76))
  call loop_A_Q(G0(:,:,:,76),Q(:,27),MB,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,59),MB,G2(:,:,:,209))
  call loop_AS_Q(G2(:,:,:,209),wf(:,-2),G2(:,:,:,210),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,63),MB,G3tensor(:,75))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,1),T4sum(1:70,21))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,1),T4sum(1:70,21))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,5),T4sum(1:70,22))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,5),T4sum(1:70,22))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,3),T4sum(1:70,22))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,3),T4sum(1:70,22))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,2),T4sum(1:70,23))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,2),T4sum(1:70,23))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,6),T4sum(1:70,24))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,6),T4sum(1:70,24))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,4),T4sum(1:70,24))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,4),T4sum(1:70,24))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,13))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,13))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,14))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,14))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,9),T4sum(1:70,21))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,9),T4sum(1:70,21))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,7),T4sum(1:70,21))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,7),T4sum(1:70,21))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,13),T4sum(1:70,22))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,13),T4sum(1:70,22))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,11),T4sum(1:70,22))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,11),T4sum(1:70,22))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,10),T4sum(1:70,23))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,10),T4sum(1:70,23))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,8),T4sum(1:70,23))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,8),T4sum(1:70,23))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,14),T4sum(1:70,24))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,14),T4sum(1:70,24))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,12),T4sum(1:70,24))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,12),T4sum(1:70,24))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,25),T3sum(1:35,5))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,28),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,29),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,13))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,13))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,33),T3sum(1:35,13))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,33),T3sum(1:35,13))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,14))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,14))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,14))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,14))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,36),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,36),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,37),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,37),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,17),T4sum(1:70,21))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,17),T4sum(1:70,21))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,15),T4sum(1:70,21))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,15),T4sum(1:70,21))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,21),T4sum(1:70,22))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,21),T4sum(1:70,22))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,19),T4sum(1:70,22))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_3,G4tensor(:,19),T4sum(1:70,22))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,18),T4sum(1:70,23))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,18),T4sum(1:70,23))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,16),T4sum(1:70,23))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,16),T4sum(1:70,23))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,22),T4sum(1:70,24))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,22),T4sum(1:70,24))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,20),T4sum(1:70,24))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_3,G4tensor(:,20),T4sum(1:70,24))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,40),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,41),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,43),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,44),T3sum(1:35,11))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,44),T3sum(1:35,11))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,45),T3sum(1:35,11))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,45),T3sum(1:35,11))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,46),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,46),T3sum(1:35,12))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,47),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,47),T3sum(1:35,12))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,49),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,49),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,6))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,51),T3sum(1:35,6))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,51),T3sum(1:35,6))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,24),T4sum(1:70,29))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,24),T4sum(1:70,29))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,23),T4sum(1:70,29))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,23),T4sum(1:70,29))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,26),T4sum(1:70,30))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,26),T4sum(1:70,30))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,25),T4sum(1:70,30))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,25),T4sum(1:70,30))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,52),T3sum(1:35,5))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,53),T3sum(1:35,5))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,54),T3sum(1:35,6))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,55),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,56),T3sum(1:35,11))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,56),T3sum(1:35,11))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,57),T3sum(1:35,11))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,57),T3sum(1:35,11))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,12))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,12))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,12))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,59),T3sum(1:35,12))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,61),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,61),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,28),T4sum(1:70,29))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,28),T4sum(1:70,29))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,27),T4sum(1:70,29))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,27),T4sum(1:70,29))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,30),T4sum(1:70,30))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,30),T4sum(1:70,30))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,29),T4sum(1:70,30))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,29),T4sum(1:70,30))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,64),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,65),T3sum(1:35,5))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,66),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,67),T3sum(1:35,6))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,73),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,73),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,6))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphjjj2_ddxhggg_1_/**/REALKIND
