
module ol_vamp_2_pphjjj2_ddxbbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_ddxbbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_ddxbbxhg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_ddxbbxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_ddxbbxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,3) :: G0
  complex(REALKIND), dimension(4,5,4,7) :: G1
  complex(REALKIND), pointer :: G2tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G2tensorhel(15,6,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G2tensor => G2tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,35),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,10),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),MT,G2tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,20),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,63),MT,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,35),MB,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,10),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),MB,G2tensor(:,3))
  call loop_QV_A(G1(:,:,:,4),wf(:,20),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),MB,G2tensor(:,4))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,35),G1(:,:,:,7))
  call check_last_CV_D(l_switch,G1(:,:,:,7),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,5))
  call check_last_CV_D(l_switch,G1(:,:,:,7),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,6))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,1),T2sum(1:15,55))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(122)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,1),T2sum(1:15,55))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,3),T2sum(1:15,56))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(122)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,3),T2sum(1:15,56))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,5),T2sum(1:15,52))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,5),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,2),T2sum(1:15,55))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(128)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,2),T2sum(1:15,55))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,4),T2sum(1:15,56))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(128)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,4),T2sum(1:15,56))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,6),T2sum(1:15,52))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,6),T2sum(1:15,52))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G2tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphjjj2_ddxbbxhg_1_/**/REALKIND
