
module ol_vamp_2_pphjjj2_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G0tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_bbxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_bbxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_bbxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_bbxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,61) :: G0
  complex(REALKIND), dimension(4,5,4,179) :: G1
  complex(REALKIND), dimension(4,15,4,245) :: G2
  complex(REALKIND), dimension(4,35,4,178) :: G3
  complex(REALKIND), dimension(4,70,4,87) :: G4
  complex(REALKIND), dimension(4,126,4,12) :: G5
  complex(REALKIND), pointer :: G0tensor(:,:)
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G0tensorhel(1,18,32))
    allocate(G1tensorhel(5,66,32))
    allocate(G2tensorhel(15,81,32))
    allocate(G3tensorhel(35,84,32))
    allocate(G4tensorhel(70,47,32))
    allocate(G5tensorhel(126,30,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G0tensor => G0tensorhel(:,:,hel)
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,2),gH)
  call loop_A_Q(G0(:,:,:,2),Q(:,4),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,60),MT,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,86),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,86),G2(:,:,:,4))
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,86),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,33),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,60),MT,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,86),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,36),MT,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,30),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,86),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-3),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,44),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-4),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,86),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,52),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-3),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,60),MT,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,86),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,30),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,28),MT,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,60),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,86),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,39),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,86),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,20),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,21),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,60),MT,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,86),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-3),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,28),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-5),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,86),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-5),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,52),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-3),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,86),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,21),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,44),MT,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,60),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,86),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,42),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,60),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,86),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,12),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,11),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,60),MT,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,86),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,28),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,60),MT,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,86),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,44),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,60),MT,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,86),G4(:,:,:,12))
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,11),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,52),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-3),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,60),MT,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,86),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,6))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,3),gH)
  call loop_Q_A(G0(:,:,:,3),Q(:,4),MB,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,60),MB,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,86),G2(:,:,:,32))
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,14),wf(:,5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,60),MB,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,86),G2(:,:,:,34))
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,14),wf(:,6),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,60),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,86),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MB,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,14),wf(:,33),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,60),MB,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,86),G2(:,:,:,38))
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,14),wf(:,-5),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,36),MB,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,30),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,60),MB,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,86),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,7))
  call loop_QV_A(G2(:,:,:,39),wf(:,-3),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,44),MB,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-4),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,60),MB,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,86),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MB,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,52),MB,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-3),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,60),MB,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,86),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MB,G5tensor(:,8))
  call loop_QV_A(G1(:,:,:,14),wf(:,30),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,28),MB,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,60),MB,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,86),G3(:,:,:,32))
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,8))
  call loop_QV_A(G1(:,:,:,14),wf(:,39),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,60),MB,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,86),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,14),wf(:,-4),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,20),MB,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,21),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,60),MB,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,86),G3(:,:,:,34))
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),MB,G4tensor(:,9))
  call loop_QV_A(G2(:,:,:,47),wf(:,-3),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,28),MB,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-5),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,60),MB,G4(:,:,:,17))
  call loop_QV_A(G4(:,:,:,17),wf(:,86),G4(:,:,:,18))
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,52),MB,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-3),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,60),MB,G4(:,:,:,19))
  call loop_QV_A(G4(:,:,:,19),wf(:,86),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,14),wf(:,21),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,44),MB,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,60),MB,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,86),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,14),wf(:,42),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,60),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,86),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,14),wf(:,-3),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,12),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,11),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,60),MB,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,86),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,11))
  call loop_QV_A(G2(:,:,:,55),wf(:,-4),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,28),MB,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-5),G3(:,:,:,44))
  call loop_Q_A(G3(:,:,:,44),Q(:,60),MB,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,86),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,44),MB,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,60),MB,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,86),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_QV_A(G1(:,:,:,14),wf(:,11),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,52),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,60),MB,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,86),G3(:,:,:,48))
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,12))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,4),gH)
  call loop_A_Q(G0(:,:,:,4),Q(:,4),MB,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,2),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,60),MB,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,86),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,27),wf(:,5),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,60),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,86),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,27),wf(:,6),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,60),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,86),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,27),wf(:,33),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,60),MB,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,86),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,36),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,30),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,60),MB,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,86),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,63),MB,G4tensor(:,13))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-3),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,44),MB,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,60),MB,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,86),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,63),MB,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,52),MB,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-3),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,60),MB,G4(:,:,:,27))
  call loop_AV_Q(G4(:,:,:,27),wf(:,86),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,27),wf(:,30),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,28),MB,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-5),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,60),MB,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,86),G3(:,:,:,56))
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,63),MB,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,27),wf(:,39),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,60),MB,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,86),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,20),MB,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,21),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,60),MB,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,86),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MB,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-3),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,28),MB,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-5),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,60),MB,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,86),G4(:,:,:,30))
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,63),MB,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,52),MB,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-3),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,60),MB,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,86),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,27),wf(:,21),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,44),MB,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,60),MB,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,86),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,27),wf(:,42),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,60),MB,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,86),G2(:,:,:,84))
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),MB,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-3),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,12),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,11),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,60),MB,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,86),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),MB,G4tensor(:,17))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-4),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,28),MB,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,60),MB,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,86),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MB,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-5),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,44),MB,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,60),MB,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,86),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),MB,G5tensor(:,18))
  call loop_AV_Q(G1(:,:,:,27),wf(:,11),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,52),MB,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-3),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,60),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,86),G3(:,:,:,72))
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),MB,G4tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,5))
  call loop_VA_Q(G0(:,:,:,5),wf(:,12),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,58),MB,G1(:,:,:,40))
  call check_last_AQ_V(l_switch,G1(:,:,:,40),wf(:,3),G1tensor(:,1))
  call loop_AS_Q(G1(:,:,:,40),wf(:,-2),G1(:,:,:,41),gH)
  call loop_A_Q(G1(:,:,:,41),Q(:,62),MB,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,0),G2tensor(:,1))
  call loop_VQ_A(G0(:,:,:,5),wf(:,26),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,61),MB,G1(:,:,:,42))
  call check_last_QA_V(l_switch,G1(:,:,:,42),wf(:,-1),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,5),wf(:,3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,53),MB,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,61),MB,G2(:,:,:,92))
  call check_last_QA_V(l_switch,G2(:,:,:,92),wf(:,-1),G2tensor(:,2))
  call loop_UV_W(G0(:,:,:,5),Q(:,48),wf(:,-3),Q(:,8),G1(:,:,:,45))
  call loop_VQ_A(G1(:,:,:,45),wf(:,3),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,61),MB,G2(:,:,:,93))
  call check_last_QA_V(l_switch,G2(:,:,:,93),wf(:,-1),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,45),wf(:,8),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,62),MB,G2(:,:,:,94))
  call check_last_AQ_V(l_switch,G2(:,:,:,94),wf(:,0),G2tensor(:,4))
  call loop_VA_Q(G1(:,:,:,45),wf(:,-1),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,58),MB,G2(:,:,:,95))
  call loop_AS_Q(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96),gH)
  call loop_A_Q(G2(:,:,:,96),Q(:,62),MB,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,0),G3tensor(:,19))
  call loop_VQ_A(G0(:,:,:,5),wf(:,46),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,57),MB,G1(:,:,:,49))
  call check_last_QA_V(l_switch,G1(:,:,:,49),wf(:,8),G1tensor(:,3))
  call loop_QS_A(G1(:,:,:,49),wf(:,-2),G1(:,:,:,50),gH)
  call loop_Q_A(G1(:,:,:,50),Q(:,61),MB,G2(:,:,:,97))
  call check_last_QA_V(l_switch,G2(:,:,:,97),wf(:,-1),G2tensor(:,5))
  call loop_VA_Q(G0(:,:,:,5),wf(:,61),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,62),MB,G1(:,:,:,51))
  call check_last_AQ_V(l_switch,G1(:,:,:,51),wf(:,0),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,5),wf(:,8),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,54),MB,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-3),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,62),MB,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,0),G2tensor(:,6))
  call loop_VQ_A(G0(:,:,:,5),wf(:,75),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,61),MB,G1(:,:,:,54))
  call check_last_QA_V(l_switch,G1(:,:,:,54),wf(:,-1),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,5),wf(:,83),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,62),MB,G1(:,:,:,55))
  call check_last_AQ_V(l_switch,G1(:,:,:,55),wf(:,0),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,5),wf(:,-1),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,50),MB,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-3),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,58),MB,G2(:,:,:,99))
  call loop_AS_Q(G2(:,:,:,99),wf(:,-2),G2(:,:,:,100),gH)
  call loop_A_Q(G2(:,:,:,100),Q(:,62),MB,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,0),G3tensor(:,20))
  call loop_AS_Q(G1(:,:,:,56),wf(:,-2),G1(:,:,:,58),gH)
  call loop_A_Q(G1(:,:,:,58),Q(:,54),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,62),MB,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,0),G3tensor(:,21))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,4),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,4),wf(:,-3),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,4),G0tensor(:,3))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,9),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,9),wf(:,-3),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,9),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,13),Q(:,15),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,405),Q(:,15),G1tensor(:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,408),Q(:,15),G1tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,47),Q(:,15),G1tensor(:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,423),Q(:,15),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,426),Q(:,15),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,443),Q(:,15),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,460),Q(:,15),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-5),G0(:,:,:,15))
  call loop_VA_Q(G0(:,:,:,15),wf(:,12),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,58),MB,G1(:,:,:,59))
  call check_last_AQ_V(l_switch,G1(:,:,:,59),wf(:,3),G1tensor(:,15))
  call loop_AS_Q(G1(:,:,:,59),wf(:,-2),G1(:,:,:,60),gH)
  call loop_A_Q(G1(:,:,:,60),Q(:,62),MB,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,0),G2tensor(:,7))
  call loop_VQ_A(G0(:,:,:,15),wf(:,26),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,61),MB,G1(:,:,:,61))
  call check_last_QA_V(l_switch,G1(:,:,:,61),wf(:,-1),G1tensor(:,16))
  call loop_VQ_A(G0(:,:,:,15),wf(:,3),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,53),MB,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,-3),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,61),MB,G2(:,:,:,104))
  call check_last_QA_V(l_switch,G2(:,:,:,104),wf(:,-1),G2tensor(:,8))
  call loop_UV_W(G0(:,:,:,15),Q(:,48),wf(:,-3),Q(:,8),G1(:,:,:,64))
  call loop_VQ_A(G1(:,:,:,64),wf(:,3),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,61),MB,G2(:,:,:,105))
  call check_last_QA_V(l_switch,G2(:,:,:,105),wf(:,-1),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,64),wf(:,8),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,62),MB,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,0),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,64),wf(:,-1),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,58),MB,G2(:,:,:,107))
  call loop_AS_Q(G2(:,:,:,107),wf(:,-2),G2(:,:,:,108),gH)
  call loop_A_Q(G2(:,:,:,108),Q(:,62),MB,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,22))
  call loop_VQ_A(G0(:,:,:,15),wf(:,46),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,57),MB,G1(:,:,:,68))
  call check_last_QA_V(l_switch,G1(:,:,:,68),wf(:,8),G1tensor(:,17))
  call loop_QS_A(G1(:,:,:,68),wf(:,-2),G1(:,:,:,69),gH)
  call loop_Q_A(G1(:,:,:,69),Q(:,61),MB,G2(:,:,:,109))
  call check_last_QA_V(l_switch,G2(:,:,:,109),wf(:,-1),G2tensor(:,11))
  call loop_VA_Q(G0(:,:,:,15),wf(:,61),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,62),MB,G1(:,:,:,70))
  call check_last_AQ_V(l_switch,G1(:,:,:,70),wf(:,0),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,15),wf(:,8),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,54),MB,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-3),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,62),MB,G2(:,:,:,110))
  call check_last_AQ_V(l_switch,G2(:,:,:,110),wf(:,0),G2tensor(:,12))
  call loop_VQ_A(G0(:,:,:,15),wf(:,75),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,61),MB,G1(:,:,:,73))
  call check_last_QA_V(l_switch,G1(:,:,:,73),wf(:,-1),G1tensor(:,19))
  call loop_VA_Q(G0(:,:,:,15),wf(:,83),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,62),MB,G1(:,:,:,74))
  call check_last_AQ_V(l_switch,G1(:,:,:,74),wf(:,0),G1tensor(:,20))
  call loop_VA_Q(G0(:,:,:,15),wf(:,-1),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,50),MB,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,58),MB,G2(:,:,:,111))
  call loop_AS_Q(G2(:,:,:,111),wf(:,-2),G2(:,:,:,112),gH)
  call loop_A_Q(G2(:,:,:,112),Q(:,62),MB,G3(:,:,:,77))
  call check_last_AQ_V(l_switch,G3(:,:,:,77),wf(:,0),G3tensor(:,23))
  call loop_AS_Q(G1(:,:,:,75),wf(:,-2),G1(:,:,:,77),gH)
  call loop_A_Q(G1(:,:,:,77),Q(:,54),MB,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,62),MB,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,0),G3tensor(:,24))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,4),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,4),wf(:,-3),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,4),G0tensor(:,9))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,9),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,9),wf(:,-3),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,9),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,13),Q(:,15),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,405),Q(:,15),G1tensor(:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,408),Q(:,15),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,47),Q(:,15),G1tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,423),Q(:,15),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,426),Q(:,15),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,443),Q(:,15),G1tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,48),wf(:,460),Q(:,15),G1tensor(:,28))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,25))
  call loop_VA_Q(G0(:,:,:,25),wf(:,12),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,58),MB,G1(:,:,:,78))
  call check_last_AQ_V(l_switch,G1(:,:,:,78),wf(:,3),G1tensor(:,29))
  call loop_AS_Q(G1(:,:,:,78),wf(:,-2),G1(:,:,:,79),gH)
  call loop_A_Q(G1(:,:,:,79),Q(:,62),MB,G2(:,:,:,115))
  call check_last_AQ_V(l_switch,G2(:,:,:,115),wf(:,0),G2tensor(:,13))
  call loop_VQ_A(G0(:,:,:,25),wf(:,26),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,61),MB,G1(:,:,:,80))
  call check_last_QA_V(l_switch,G1(:,:,:,80),wf(:,-1),G1tensor(:,30))
  call loop_VQ_A(G0(:,:,:,25),wf(:,3),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,53),MB,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,-3),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,61),MB,G2(:,:,:,116))
  call check_last_QA_V(l_switch,G2(:,:,:,116),wf(:,-1),G2tensor(:,14))
  call loop_UV_W(G0(:,:,:,25),Q(:,48),wf(:,-3),Q(:,8),G1(:,:,:,83))
  call loop_VQ_A(G1(:,:,:,83),wf(:,3),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,61),MB,G2(:,:,:,117))
  call check_last_QA_V(l_switch,G2(:,:,:,117),wf(:,-1),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,83),wf(:,8),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,62),MB,G2(:,:,:,118))
  call check_last_AQ_V(l_switch,G2(:,:,:,118),wf(:,0),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,83),wf(:,-1),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,58),MB,G2(:,:,:,119))
  call loop_AS_Q(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120),gH)
  call loop_A_Q(G2(:,:,:,120),Q(:,62),MB,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,0),G3tensor(:,25))
  call loop_VQ_A(G0(:,:,:,25),wf(:,46),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,57),MB,G1(:,:,:,87))
  call check_last_QA_V(l_switch,G1(:,:,:,87),wf(:,8),G1tensor(:,31))
  call loop_QS_A(G1(:,:,:,87),wf(:,-2),G1(:,:,:,88),gH)
  call loop_Q_A(G1(:,:,:,88),Q(:,61),MB,G2(:,:,:,121))
  call check_last_QA_V(l_switch,G2(:,:,:,121),wf(:,-1),G2tensor(:,17))
  call loop_VA_Q(G0(:,:,:,25),wf(:,61),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,62),MB,G1(:,:,:,89))
  call check_last_AQ_V(l_switch,G1(:,:,:,89),wf(:,0),G1tensor(:,32))
  call loop_VA_Q(G0(:,:,:,25),wf(:,8),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,54),MB,G1(:,:,:,90))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-3),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,62),MB,G2(:,:,:,122))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,0),G2tensor(:,18))
  call loop_VQ_A(G0(:,:,:,25),wf(:,75),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,61),MB,G1(:,:,:,92))
  call check_last_QA_V(l_switch,G1(:,:,:,92),wf(:,-1),G1tensor(:,33))
  call loop_VA_Q(G0(:,:,:,25),wf(:,83),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,62),MB,G1(:,:,:,93))
  call check_last_AQ_V(l_switch,G1(:,:,:,93),wf(:,0),G1tensor(:,34))
  call loop_VA_Q(G0(:,:,:,25),wf(:,-1),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,50),MB,G1(:,:,:,94))
  call loop_AV_Q(G1(:,:,:,94),wf(:,-3),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,58),MB,G2(:,:,:,123))
  call loop_AS_Q(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124),gH)
  call loop_A_Q(G2(:,:,:,124),Q(:,62),MB,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,26))
  call loop_AS_Q(G1(:,:,:,94),wf(:,-2),G1(:,:,:,96),gH)
  call loop_A_Q(G1(:,:,:,96),Q(:,54),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-3),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,62),MB,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,0),G3tensor(:,27))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-3),wf(:,4),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,4),wf(:,-3),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-3),wf(:,4),G0tensor(:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-3),wf(:,9),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,9),wf(:,-3),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-3),wf(:,9),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,13),Q(:,15),G1tensor(:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,405),Q(:,15),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,408),Q(:,15),G1tensor(:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,47),Q(:,15),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,423),Q(:,15),G1tensor(:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,426),Q(:,15),G1tensor(:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,443),Q(:,15),G1tensor(:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,48),wf(:,460),Q(:,15),G1tensor(:,42))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,30),G0(:,:,:,35))
  call loop_VQ_A(G0(:,:,:,35),wf(:,3),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,61),MB,G1(:,:,:,97))
  call check_last_QA_V(l_switch,G1(:,:,:,97),wf(:,-1),G1tensor(:,43))
  call loop_VA_Q(G0(:,:,:,35),wf(:,8),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,62),MB,G1(:,:,:,98))
  call check_last_AQ_V(l_switch,G1(:,:,:,98),wf(:,0),G1tensor(:,44))
  call loop_VA_Q(G0(:,:,:,35),wf(:,-1),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,58),MB,G1(:,:,:,99))
  call loop_AS_Q(G1(:,:,:,99),wf(:,-2),G1(:,:,:,100),gH)
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MB,G2(:,:,:,127))
  call check_last_AQ_V(l_switch,G2(:,:,:,127),wf(:,0),G2tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,46))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,-5),G0(:,:,:,39))
  call loop_VQ_A(G0(:,:,:,39),wf(:,3),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,61),MB,G1(:,:,:,101))
  call check_last_QA_V(l_switch,G1(:,:,:,101),wf(:,-1),G1tensor(:,47))
  call loop_VA_Q(G0(:,:,:,39),wf(:,8),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,62),MB,G1(:,:,:,102))
  call check_last_AQ_V(l_switch,G1(:,:,:,102),wf(:,0),G1tensor(:,48))
  call loop_VA_Q(G0(:,:,:,39),wf(:,-1),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,58),MB,G1(:,:,:,103))
  call loop_AS_Q(G1(:,:,:,103),wf(:,-2),G1(:,:,:,104),gH)
  call loop_A_Q(G1(:,:,:,104),Q(:,62),MB,G2(:,:,:,128))
  call check_last_AQ_V(l_switch,G2(:,:,:,128),wf(:,0),G2tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,50))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,30),G0(:,:,:,43))
  call loop_VQ_A(G0(:,:,:,43),wf(:,3),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,61),MB,G1(:,:,:,105))
  call check_last_QA_V(l_switch,G1(:,:,:,105),wf(:,-1),G1tensor(:,51))
  call loop_VA_Q(G0(:,:,:,43),wf(:,8),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,62),MB,G1(:,:,:,106))
  call check_last_AQ_V(l_switch,G1(:,:,:,106),wf(:,0),G1tensor(:,52))
  call loop_VA_Q(G0(:,:,:,43),wf(:,-1),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,58),MB,G1(:,:,:,107))
  call loop_AS_Q(G1(:,:,:,107),wf(:,-2),G1(:,:,:,108),gH)
  call loop_A_Q(G1(:,:,:,108),Q(:,62),MB,G2(:,:,:,129))
  call check_last_AQ_V(l_switch,G2(:,:,:,129),wf(:,0),G2tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,54))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,109))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,-5),wf(:,4),G1(:,:,:,110))
  call check_last_UV_W(l_switch,G1(:,:,:,110),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,22))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,4),wf(:,-5),G1(:,:,:,111))
  call check_last_UV_W(l_switch,G1(:,:,:,111),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,23))
  call loop_GGG_G_23(G1(:,:,:,109),wf(:,-5),wf(:,4),G1(:,:,:,112))
  call check_last_UV_W(l_switch,G1(:,:,:,112),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,24))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,130))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,130),wf(:,-3),wf(:,4),G2tensor(:,25))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,130),wf(:,4),wf(:,-3),G2tensor(:,26))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,130),wf(:,-3),wf(:,4),G2tensor(:,27))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,130),wf(:,-3),wf(:,9),G2tensor(:,28))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,130),wf(:,9),wf(:,-3),G2tensor(:,29))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,130),wf(:,-3),wf(:,9),G2tensor(:,30))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,13),Q(:,15),G3tensor(:,28))
  call loop_VA_Q(G2(:,:,:,130),wf(:,12),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,58),MB,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,3),G3tensor(:,29))
  call loop_AS_Q(G3(:,:,:,82),wf(:,-2),G3(:,:,:,83),gH)
  call loop_A_Q(G3(:,:,:,83),Q(:,62),MB,G4(:,:,:,37))
  call check_last_AQ_V(l_switch,G4(:,:,:,37),wf(:,0),G4tensor(:,19))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,405),Q(:,15),G3tensor(:,30))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,408),Q(:,15),G3tensor(:,31))
  call loop_VQ_A(G2(:,:,:,130),wf(:,26),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,61),MB,G3(:,:,:,84))
  call check_last_QA_V(l_switch,G3(:,:,:,84),wf(:,-1),G3tensor(:,32))
  call loop_VQ_A(G2(:,:,:,130),wf(:,3),G2(:,:,:,133))
  call loop_Q_A(G2(:,:,:,133),Q(:,53),MB,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-3),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,61),MB,G4(:,:,:,38))
  call check_last_QA_V(l_switch,G4(:,:,:,38),wf(:,-1),G4tensor(:,20))
  call loop_UV_W(G2(:,:,:,130),Q(:,48),wf(:,-3),Q(:,8),G3(:,:,:,87))
  call loop_VQ_A(G3(:,:,:,87),wf(:,3),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,61),MB,G4(:,:,:,39))
  call check_last_QA_V(l_switch,G4(:,:,:,39),wf(:,-1),G4tensor(:,21))
  call loop_VA_Q(G3(:,:,:,87),wf(:,8),G3(:,:,:,89))
  call loop_A_Q(G3(:,:,:,89),Q(:,62),MB,G4(:,:,:,40))
  call check_last_AQ_V(l_switch,G4(:,:,:,40),wf(:,0),G4tensor(:,22))
  call loop_VA_Q(G3(:,:,:,87),wf(:,-1),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,58),MB,G4(:,:,:,41))
  call loop_AS_Q(G4(:,:,:,41),wf(:,-2),G4(:,:,:,42),gH)
  call loop_A_Q(G4(:,:,:,42),Q(:,62),MB,G5(:,:,:,1))
  call check_last_AQ_V(l_switch,G5(:,:,:,1),wf(:,0),G5tensor(:,19))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,47),Q(:,15),G3tensor(:,33))
  call loop_VQ_A(G2(:,:,:,130),wf(:,46),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,57),MB,G3(:,:,:,91))
  call check_last_QA_V(l_switch,G3(:,:,:,91),wf(:,8),G3tensor(:,34))
  call loop_QS_A(G3(:,:,:,91),wf(:,-2),G3(:,:,:,92),gH)
  call loop_Q_A(G3(:,:,:,92),Q(:,61),MB,G4(:,:,:,43))
  call check_last_QA_V(l_switch,G4(:,:,:,43),wf(:,-1),G4tensor(:,23))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,423),Q(:,15),G3tensor(:,35))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,426),Q(:,15),G3tensor(:,36))
  call loop_VA_Q(G2(:,:,:,130),wf(:,61),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,62),MB,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,0),G3tensor(:,37))
  call loop_VA_Q(G2(:,:,:,130),wf(:,8),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,54),MB,G3(:,:,:,94))
  call loop_AV_Q(G3(:,:,:,94),wf(:,-3),G3(:,:,:,95))
  call loop_A_Q(G3(:,:,:,95),Q(:,62),MB,G4(:,:,:,44))
  call check_last_AQ_V(l_switch,G4(:,:,:,44),wf(:,0),G4tensor(:,24))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,443),Q(:,15),G3tensor(:,38))
  call loop_VQ_A(G2(:,:,:,130),wf(:,75),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,61),MB,G3(:,:,:,96))
  call check_last_QA_V(l_switch,G3(:,:,:,96),wf(:,-1),G3tensor(:,39))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,48),wf(:,460),Q(:,15),G3tensor(:,40))
  call loop_VA_Q(G2(:,:,:,130),wf(:,83),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,62),MB,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,0),G3tensor(:,41))
  call loop_VA_Q(G2(:,:,:,130),wf(:,-1),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,50),MB,G3(:,:,:,98))
  call loop_AV_Q(G3(:,:,:,98),wf(:,-3),G3(:,:,:,99))
  call loop_A_Q(G3(:,:,:,99),Q(:,58),MB,G4(:,:,:,45))
  call loop_AS_Q(G4(:,:,:,45),wf(:,-2),G4(:,:,:,46),gH)
  call loop_A_Q(G4(:,:,:,46),Q(:,62),MB,G5(:,:,:,2))
  call check_last_AQ_V(l_switch,G5(:,:,:,2),wf(:,0),G5tensor(:,20))
  call loop_AS_Q(G3(:,:,:,98),wf(:,-2),G3(:,:,:,100),gH)
  call loop_A_Q(G3(:,:,:,100),Q(:,54),MB,G4(:,:,:,47))
  call loop_AV_Q(G4(:,:,:,47),wf(:,-3),G4(:,:,:,48))
  call loop_A_Q(G4(:,:,:,48),Q(:,62),MB,G5(:,:,:,3))
  call check_last_AQ_V(l_switch,G5(:,:,:,3),wf(:,0),G5tensor(:,21))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,-5),wf(:,-3),G1(:,:,:,113))
  call check_last_UV_W(l_switch,G1(:,:,:,113),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,31))
  call loop_VQ_A(G1(:,:,:,113),wf(:,3),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,61),MB,G2(:,:,:,140))
  call check_last_QA_V(l_switch,G2(:,:,:,140),wf(:,-1),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,113),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,113),wf(:,8),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,62),MB,G2(:,:,:,141))
  call check_last_AQ_V(l_switch,G2(:,:,:,141),wf(:,0),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,113),wf(:,-1),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,58),MB,G2(:,:,:,142))
  call loop_AS_Q(G2(:,:,:,142),wf(:,-2),G2(:,:,:,143),gH)
  call loop_A_Q(G2(:,:,:,143),Q(:,62),MB,G3(:,:,:,101))
  call check_last_AQ_V(l_switch,G3(:,:,:,101),wf(:,0),G3tensor(:,42))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,-3),wf(:,-5),G1(:,:,:,117))
  call check_last_UV_W(l_switch,G1(:,:,:,117),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,35))
  call loop_VQ_A(G1(:,:,:,117),wf(:,3),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,61),MB,G2(:,:,:,144))
  call check_last_QA_V(l_switch,G2(:,:,:,144),wf(:,-1),G2tensor(:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,117),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,117),wf(:,8),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MB,G2(:,:,:,145))
  call check_last_AQ_V(l_switch,G2(:,:,:,145),wf(:,0),G2tensor(:,38))
  call loop_VA_Q(G1(:,:,:,117),wf(:,-1),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,58),MB,G2(:,:,:,146))
  call loop_AS_Q(G2(:,:,:,146),wf(:,-2),G2(:,:,:,147),gH)
  call loop_A_Q(G2(:,:,:,147),Q(:,62),MB,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,43))
  call loop_GGG_G_23(G1(:,:,:,109),wf(:,-5),wf(:,-3),G1(:,:,:,121))
  call check_last_UV_W(l_switch,G1(:,:,:,121),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,39))
  call loop_VQ_A(G1(:,:,:,121),wf(:,3),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,61),MB,G2(:,:,:,148))
  call check_last_QA_V(l_switch,G2(:,:,:,148),wf(:,-1),G2tensor(:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,121),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,41))
  call loop_VA_Q(G1(:,:,:,121),wf(:,8),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,62),MB,G2(:,:,:,149))
  call check_last_AQ_V(l_switch,G2(:,:,:,149),wf(:,0),G2tensor(:,42))
  call loop_VA_Q(G1(:,:,:,121),wf(:,-1),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,58),MB,G2(:,:,:,150))
  call loop_AS_Q(G2(:,:,:,150),wf(:,-2),G2(:,:,:,151),gH)
  call loop_A_Q(G2(:,:,:,151),Q(:,62),MB,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,44))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,-5),wf(:,9),G1(:,:,:,125))
  call check_last_UV_W(l_switch,G1(:,:,:,125),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,43))
  call loop_GGG_G_12(G1(:,:,:,109),wf(:,9),wf(:,-5),G1(:,:,:,126))
  call check_last_UV_W(l_switch,G1(:,:,:,126),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,44))
  call loop_GGG_G_23(G1(:,:,:,109),wf(:,-5),wf(:,9),G1(:,:,:,127))
  call check_last_UV_W(l_switch,G1(:,:,:,127),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,45))
  call loop_VQ_A(G1(:,:,:,109),wf(:,130),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,53),MB,G2(:,:,:,152))
  call check_last_QA_V(l_switch,G2(:,:,:,152),wf(:,12),G2tensor(:,46))
  call loop_QV_A(G2(:,:,:,152),wf(:,-3),G2(:,:,:,153))
  call loop_Q_A(G2(:,:,:,153),Q(:,61),MB,G3(:,:,:,104))
  call check_last_QA_V(l_switch,G3(:,:,:,104),wf(:,-1),G3tensor(:,45))
  call loop_VA_Q(G1(:,:,:,109),wf(:,132),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,58),MB,G2(:,:,:,154))
  call check_last_AQ_V(l_switch,G2(:,:,:,154),wf(:,3),G2tensor(:,47))
  call loop_AS_Q(G2(:,:,:,154),wf(:,-2),G2(:,:,:,155),gH)
  call loop_A_Q(G2(:,:,:,155),Q(:,62),MB,G3(:,:,:,105))
  call check_last_AQ_V(l_switch,G3(:,:,:,105),wf(:,0),G3tensor(:,46))
  call loop_VA_Q(G1(:,:,:,109),wf(:,12),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,26),MB,G2(:,:,:,156))
  call loop_AV_Q(G2(:,:,:,156),wf(:,-5),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,58),MB,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,3),G3tensor(:,47))
  call loop_AS_Q(G3(:,:,:,106),wf(:,-2),G3(:,:,:,107),gH)
  call loop_A_Q(G3(:,:,:,107),Q(:,62),MB,G4(:,:,:,49))
  call check_last_AQ_V(l_switch,G4(:,:,:,49),wf(:,0),G4tensor(:,25))
  call loop_AS_Q(G2(:,:,:,156),wf(:,-2),G2(:,:,:,158),gH)
  call loop_A_Q(G2(:,:,:,158),Q(:,30),MB,G3(:,:,:,108))
  call loop_AV_Q(G3(:,:,:,108),wf(:,-5),G3(:,:,:,109))
  call loop_A_Q(G3(:,:,:,109),Q(:,62),MB,G4(:,:,:,50))
  call check_last_AQ_V(l_switch,G4(:,:,:,50),wf(:,0),G4tensor(:,26))
  call loop_VA_Q(G1(:,:,:,109),wf(:,31),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,50),MB,G2(:,:,:,159))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,26),G2tensor(:,48))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-3),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,58),MB,G3(:,:,:,110))
  call check_last_AQ_V(l_switch,G3(:,:,:,110),wf(:,3),G3tensor(:,48))
  call loop_AS_Q(G3(:,:,:,110),wf(:,-2),G3(:,:,:,111),gH)
  call loop_A_Q(G3(:,:,:,111),Q(:,62),MB,G4(:,:,:,51))
  call check_last_AQ_V(l_switch,G4(:,:,:,51),wf(:,0),G4tensor(:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,75),G2tensor(:,49))
  call loop_AS_Q(G2(:,:,:,159),wf(:,-2),G2(:,:,:,161),gH)
  call loop_A_Q(G2(:,:,:,161),Q(:,54),MB,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,46),G3tensor(:,49))
  call loop_AV_Q(G3(:,:,:,112),wf(:,-3),G3(:,:,:,113))
  call loop_A_Q(G3(:,:,:,113),Q(:,62),MB,G4(:,:,:,52))
  call check_last_AQ_V(l_switch,G4(:,:,:,52),wf(:,0),G4tensor(:,28))
  call loop_VA_Q(G1(:,:,:,109),wf(:,38),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,58),MB,G2(:,:,:,162))
  call check_last_AQ_V(l_switch,G2(:,:,:,162),wf(:,3),G2tensor(:,50))
  call loop_AS_Q(G2(:,:,:,162),wf(:,-2),G2(:,:,:,163),gH)
  call loop_A_Q(G2(:,:,:,163),Q(:,62),MB,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,50))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,32),Q(:,39),G2(:,:,:,164))
  call check_last_UV_W(l_switch,G2(:,:,:,164),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,51))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,-3),Q(:,8),G2(:,:,:,165))
  call loop_VA_Q(G2(:,:,:,165),wf(:,31),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,58),MB,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,3),G3tensor(:,52))
  call loop_AS_Q(G3(:,:,:,115),wf(:,-2),G3(:,:,:,116),gH)
  call loop_A_Q(G3(:,:,:,116),Q(:,62),MB,G4(:,:,:,53))
  call check_last_AQ_V(l_switch,G4(:,:,:,53),wf(:,0),G4tensor(:,29))
  call loop_UV_W(G2(:,:,:,165),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,117))
  call check_last_UV_W(l_switch,G3(:,:,:,117),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,30))
  call loop_VQ_A(G3(:,:,:,117),wf(:,3),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,61),MB,G4(:,:,:,54))
  call check_last_QA_V(l_switch,G4(:,:,:,54),wf(:,-1),G4tensor(:,31))
  call check_last_UV_W(l_switch,G3(:,:,:,117),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,32))
  call loop_VA_Q(G3(:,:,:,117),wf(:,8),G3(:,:,:,119))
  call loop_A_Q(G3(:,:,:,119),Q(:,62),MB,G4(:,:,:,55))
  call check_last_AQ_V(l_switch,G4(:,:,:,55),wf(:,0),G4tensor(:,33))
  call loop_VA_Q(G3(:,:,:,117),wf(:,-1),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,58),MB,G4(:,:,:,56))
  call loop_AS_Q(G4(:,:,:,56),wf(:,-2),G4(:,:,:,57),gH)
  call loop_A_Q(G4(:,:,:,57),Q(:,62),MB,G5(:,:,:,4))
  call check_last_AQ_V(l_switch,G5(:,:,:,4),wf(:,0),G5tensor(:,22))
  call loop_VQ_A(G2(:,:,:,165),wf(:,130),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,61),MB,G3(:,:,:,121))
  call check_last_QA_V(l_switch,G3(:,:,:,121),wf(:,-1),G3tensor(:,53))
  call loop_VQ_A(G2(:,:,:,165),wf(:,3),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,29),MB,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,-5),G3(:,:,:,123))
  call loop_Q_A(G3(:,:,:,123),Q(:,61),MB,G4(:,:,:,58))
  call check_last_QA_V(l_switch,G4(:,:,:,58),wf(:,-1),G4tensor(:,34))
  call loop_VQ_A(G2(:,:,:,165),wf(:,63),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,57),MB,G3(:,:,:,124))
  call check_last_QA_V(l_switch,G3(:,:,:,124),wf(:,8),G3tensor(:,54))
  call loop_QS_A(G3(:,:,:,124),wf(:,-2),G3(:,:,:,125),gH)
  call loop_Q_A(G3(:,:,:,125),Q(:,61),MB,G4(:,:,:,59))
  call check_last_QA_V(l_switch,G4(:,:,:,59),wf(:,-1),G4tensor(:,35))
  call loop_VA_Q(G2(:,:,:,165),wf(:,173),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,62),MB,G3(:,:,:,126))
  call check_last_AQ_V(l_switch,G3(:,:,:,126),wf(:,0),G3tensor(:,55))
  call loop_VA_Q(G2(:,:,:,165),wf(:,8),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,30),MB,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-5),G3(:,:,:,128))
  call loop_A_Q(G3(:,:,:,128),Q(:,62),MB,G4(:,:,:,60))
  call check_last_AQ_V(l_switch,G4(:,:,:,60),wf(:,0),G4tensor(:,36))
  call loop_VQ_A(G2(:,:,:,165),wf(:,85),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,61),MB,G3(:,:,:,129))
  call check_last_QA_V(l_switch,G3(:,:,:,129),wf(:,-1),G3tensor(:,56))
  call loop_VA_Q(G2(:,:,:,165),wf(:,79),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,62),MB,G3(:,:,:,130))
  call check_last_AQ_V(l_switch,G3(:,:,:,130),wf(:,0),G3tensor(:,57))
  call loop_VA_Q(G2(:,:,:,165),wf(:,-1),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,26),MB,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-5),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,58),MB,G4(:,:,:,61))
  call loop_AS_Q(G4(:,:,:,61),wf(:,-2),G4(:,:,:,62),gH)
  call loop_A_Q(G4(:,:,:,62),Q(:,62),MB,G5(:,:,:,5))
  call check_last_AQ_V(l_switch,G5(:,:,:,5),wf(:,0),G5tensor(:,23))
  call loop_AS_Q(G3(:,:,:,131),wf(:,-2),G3(:,:,:,133),gH)
  call loop_A_Q(G3(:,:,:,133),Q(:,30),MB,G4(:,:,:,63))
  call loop_AV_Q(G4(:,:,:,63),wf(:,-5),G4(:,:,:,64))
  call loop_A_Q(G4(:,:,:,64),Q(:,62),MB,G5(:,:,:,6))
  call check_last_AQ_V(l_switch,G5(:,:,:,6),wf(:,0),G5tensor(:,24))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,21),Q(:,40),G2(:,:,:,175))
  call check_last_UV_W(l_switch,G2(:,:,:,175),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,58))
  call loop_VQ_A(G2(:,:,:,175),wf(:,3),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,61),MB,G3(:,:,:,134))
  call check_last_QA_V(l_switch,G3(:,:,:,134),wf(:,-1),G3tensor(:,59))
  call check_last_UV_W(l_switch,G2(:,:,:,175),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,60))
  call loop_VA_Q(G2(:,:,:,175),wf(:,8),G2(:,:,:,177))
  call loop_A_Q(G2(:,:,:,177),Q(:,62),MB,G3(:,:,:,135))
  call check_last_AQ_V(l_switch,G3(:,:,:,135),wf(:,0),G3tensor(:,61))
  call loop_VA_Q(G2(:,:,:,175),wf(:,-1),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,58),MB,G3(:,:,:,136))
  call loop_AS_Q(G3(:,:,:,136),wf(:,-2),G3(:,:,:,137),gH)
  call loop_A_Q(G3(:,:,:,137),Q(:,62),MB,G4(:,:,:,65))
  call check_last_AQ_V(l_switch,G4(:,:,:,65),wf(:,0),G4tensor(:,37))
  call loop_VA_Q(G1(:,:,:,109),wf(:,41),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,58),MB,G2(:,:,:,179))
  call check_last_AQ_V(l_switch,G2(:,:,:,179),wf(:,3),G2tensor(:,51))
  call loop_AS_Q(G2(:,:,:,179),wf(:,-2),G2(:,:,:,180),gH)
  call loop_A_Q(G2(:,:,:,180),Q(:,62),MB,G3(:,:,:,138))
  call check_last_AQ_V(l_switch,G3(:,:,:,138),wf(:,0),G3tensor(:,62))
  call loop_VQ_A(G1(:,:,:,109),wf(:,314),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,61),MB,G2(:,:,:,181))
  call check_last_QA_V(l_switch,G2(:,:,:,181),wf(:,-1),G2tensor(:,52))
  call loop_VQ_A(G1(:,:,:,109),wf(:,3),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,21),MB,G2(:,:,:,182))
  call loop_QV_A(G2(:,:,:,182),wf(:,21),G2(:,:,:,183))
  call loop_Q_A(G2(:,:,:,183),Q(:,61),MB,G3(:,:,:,139))
  call check_last_QA_V(l_switch,G3(:,:,:,139),wf(:,-1),G3tensor(:,63))
  call loop_QV_A(G2(:,:,:,182),wf(:,-5),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,53),MB,G3(:,:,:,140))
  call loop_QV_A(G3(:,:,:,140),wf(:,-3),G3(:,:,:,141))
  call loop_Q_A(G3(:,:,:,141),Q(:,61),MB,G4(:,:,:,66))
  call check_last_QA_V(l_switch,G4(:,:,:,66),wf(:,-1),G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,182),wf(:,-3),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,29),MB,G3(:,:,:,142))
  call loop_QV_A(G3(:,:,:,142),wf(:,-5),G3(:,:,:,143))
  call loop_Q_A(G3(:,:,:,143),Q(:,61),MB,G4(:,:,:,67))
  call check_last_QA_V(l_switch,G4(:,:,:,67),wf(:,-1),G4tensor(:,39))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,407),Q(:,39),G2(:,:,:,186))
  call check_last_UV_W(l_switch,G2(:,:,:,186),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,64))
  call loop_VQ_A(G1(:,:,:,109),wf(:,412),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,61),MB,G2(:,:,:,187))
  call check_last_QA_V(l_switch,G2(:,:,:,187),wf(:,-1),G2tensor(:,53))
  call loop_VQ_A(G1(:,:,:,109),wf(:,26),G1(:,:,:,137))
  call loop_Q_A(G1(:,:,:,137),Q(:,29),MB,G2(:,:,:,188))
  call loop_QV_A(G2(:,:,:,188),wf(:,-5),G2(:,:,:,189))
  call loop_Q_A(G2(:,:,:,189),Q(:,61),MB,G3(:,:,:,144))
  call check_last_QA_V(l_switch,G3(:,:,:,144),wf(:,-1),G3tensor(:,65))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,418),Q(:,39),G2(:,:,:,190))
  call check_last_UV_W(l_switch,G2(:,:,:,190),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,66))
  call loop_VQ_A(G1(:,:,:,109),wf(:,420),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,61),MB,G2(:,:,:,191))
  call check_last_QA_V(l_switch,G2(:,:,:,191),wf(:,-1),G2tensor(:,54))
  call loop_VQ_A(G1(:,:,:,109),wf(:,171),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,57),MB,G2(:,:,:,192))
  call check_last_QA_V(l_switch,G2(:,:,:,192),wf(:,8),G2tensor(:,55))
  call loop_QS_A(G2(:,:,:,192),wf(:,-2),G2(:,:,:,193),gH)
  call loop_Q_A(G2(:,:,:,193),Q(:,61),MB,G3(:,:,:,145))
  call check_last_QA_V(l_switch,G3(:,:,:,145),wf(:,-1),G3tensor(:,67))
  call loop_VA_Q(G1(:,:,:,109),wf(:,173),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,54),MB,G2(:,:,:,194))
  call check_last_AQ_V(l_switch,G2(:,:,:,194),wf(:,46),G2tensor(:,56))
  call loop_AV_Q(G2(:,:,:,194),wf(:,-3),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,62),MB,G3(:,:,:,146))
  call check_last_AQ_V(l_switch,G3(:,:,:,146),wf(:,0),G3tensor(:,68))
  call loop_VQ_A(G1(:,:,:,109),wf(:,46),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,25),MB,G2(:,:,:,196))
  call loop_QV_A(G2(:,:,:,196),wf(:,-5),G2(:,:,:,197))
  call loop_Q_A(G2(:,:,:,197),Q(:,57),MB,G3(:,:,:,147))
  call check_last_QA_V(l_switch,G3(:,:,:,147),wf(:,8),G3tensor(:,69))
  call loop_QS_A(G3(:,:,:,147),wf(:,-2),G3(:,:,:,148),gH)
  call loop_Q_A(G3(:,:,:,148),Q(:,61),MB,G4(:,:,:,68))
  call check_last_QA_V(l_switch,G4(:,:,:,68),wf(:,-1),G4tensor(:,40))
  call loop_QS_A(G2(:,:,:,196),wf(:,-2),G2(:,:,:,198),gH)
  call loop_Q_A(G2(:,:,:,198),Q(:,29),MB,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-5),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,61),MB,G4(:,:,:,69))
  call check_last_QA_V(l_switch,G4(:,:,:,69),wf(:,-1),G4tensor(:,41))
  call loop_VQ_A(G1(:,:,:,109),wf(:,68),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,57),MB,G2(:,:,:,199))
  call check_last_QA_V(l_switch,G2(:,:,:,199),wf(:,8),G2tensor(:,57))
  call loop_QS_A(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200),gH)
  call loop_Q_A(G2(:,:,:,200),Q(:,61),MB,G3(:,:,:,151))
  call check_last_QA_V(l_switch,G3(:,:,:,151),wf(:,-1),G3tensor(:,70))
  call loop_VQ_A(G1(:,:,:,109),wf(:,63),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,49),MB,G2(:,:,:,201))
  call check_last_QA_V(l_switch,G2(:,:,:,201),wf(:,61),G2tensor(:,58))
  call loop_QV_A(G2(:,:,:,201),wf(:,-3),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,57),MB,G3(:,:,:,152))
  call check_last_QA_V(l_switch,G3(:,:,:,152),wf(:,8),G3tensor(:,71))
  call loop_QS_A(G3(:,:,:,152),wf(:,-2),G3(:,:,:,153),gH)
  call loop_Q_A(G3(:,:,:,153),Q(:,61),MB,G4(:,:,:,70))
  call check_last_QA_V(l_switch,G4(:,:,:,70),wf(:,-1),G4tensor(:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,201),wf(:,83),G2tensor(:,59))
  call loop_QS_A(G2(:,:,:,201),wf(:,-2),G2(:,:,:,203),gH)
  call loop_Q_A(G2(:,:,:,203),Q(:,53),MB,G3(:,:,:,154))
  call check_last_QA_V(l_switch,G3(:,:,:,154),wf(:,12),G3tensor(:,72))
  call loop_QV_A(G3(:,:,:,154),wf(:,-3),G3(:,:,:,155))
  call loop_Q_A(G3(:,:,:,155),Q(:,61),MB,G4(:,:,:,71))
  call check_last_QA_V(l_switch,G4(:,:,:,71),wf(:,-1),G4tensor(:,43))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,64),Q(:,39),G2(:,:,:,204))
  call check_last_UV_W(l_switch,G2(:,:,:,204),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,73))
  call loop_VQ_A(G1(:,:,:,109),wf(:,71),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,57),MB,G2(:,:,:,205))
  call check_last_QA_V(l_switch,G2(:,:,:,205),wf(:,8),G2tensor(:,60))
  call loop_QS_A(G2(:,:,:,205),wf(:,-2),G2(:,:,:,206),gH)
  call loop_Q_A(G2(:,:,:,206),Q(:,61),MB,G3(:,:,:,156))
  call check_last_QA_V(l_switch,G3(:,:,:,156),wf(:,-1),G3tensor(:,74))
  call loop_VA_Q(G1(:,:,:,109),wf(:,358),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,62),MB,G2(:,:,:,207))
  call check_last_AQ_V(l_switch,G2(:,:,:,207),wf(:,0),G2tensor(:,61))
  call loop_VA_Q(G1(:,:,:,109),wf(:,8),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,22),MB,G2(:,:,:,208))
  call loop_AV_Q(G2(:,:,:,208),wf(:,21),G2(:,:,:,209))
  call loop_A_Q(G2(:,:,:,209),Q(:,62),MB,G3(:,:,:,157))
  call check_last_AQ_V(l_switch,G3(:,:,:,157),wf(:,0),G3tensor(:,75))
  call loop_AV_Q(G2(:,:,:,208),wf(:,-5),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,54),MB,G3(:,:,:,158))
  call loop_AV_Q(G3(:,:,:,158),wf(:,-3),G3(:,:,:,159))
  call loop_A_Q(G3(:,:,:,159),Q(:,62),MB,G4(:,:,:,72))
  call check_last_AQ_V(l_switch,G4(:,:,:,72),wf(:,0),G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,208),wf(:,-3),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,30),MB,G3(:,:,:,160))
  call loop_AV_Q(G3(:,:,:,160),wf(:,-5),G3(:,:,:,161))
  call loop_A_Q(G3(:,:,:,161),Q(:,62),MB,G4(:,:,:,73))
  call check_last_AQ_V(l_switch,G4(:,:,:,73),wf(:,0),G4tensor(:,45))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,425),Q(:,39),G2(:,:,:,212))
  call check_last_UV_W(l_switch,G2(:,:,:,212),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,76))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,428),Q(:,39),G2(:,:,:,213))
  call check_last_UV_W(l_switch,G2(:,:,:,213),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,77))
  call loop_VA_Q(G1(:,:,:,109),wf(:,432),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,62),MB,G2(:,:,:,214))
  call check_last_AQ_V(l_switch,G2(:,:,:,214),wf(:,0),G2tensor(:,62))
  call loop_VA_Q(G1(:,:,:,109),wf(:,61),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,30),MB,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-5),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,62),MB,G3(:,:,:,162))
  call check_last_AQ_V(l_switch,G3(:,:,:,162),wf(:,0),G3tensor(:,78))
  call loop_VA_Q(G1(:,:,:,109),wf(:,438),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,62),MB,G2(:,:,:,217))
  call check_last_AQ_V(l_switch,G2(:,:,:,217),wf(:,0),G2tensor(:,63))
  call loop_VA_Q(G1(:,:,:,109),wf(:,79),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,54),MB,G2(:,:,:,218))
  call check_last_AQ_V(l_switch,G2(:,:,:,218),wf(:,46),G2tensor(:,64))
  call loop_AV_Q(G2(:,:,:,218),wf(:,-3),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,62),MB,G3(:,:,:,163))
  call check_last_AQ_V(l_switch,G3(:,:,:,163),wf(:,0),G3tensor(:,79))
  call loop_VQ_A(G1(:,:,:,109),wf(:,447),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,61),MB,G2(:,:,:,220))
  call check_last_QA_V(l_switch,G2(:,:,:,220),wf(:,-1),G2tensor(:,65))
  call loop_VQ_A(G1(:,:,:,109),wf(:,75),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,29),MB,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,-5),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,61),MB,G3(:,:,:,164))
  call check_last_QA_V(l_switch,G3(:,:,:,164),wf(:,-1),G3tensor(:,80))
  call loop_VQ_A(G1(:,:,:,109),wf(:,455),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,61),MB,G2(:,:,:,223))
  call check_last_QA_V(l_switch,G2(:,:,:,223),wf(:,-1),G2tensor(:,66))
  call loop_VQ_A(G1(:,:,:,109),wf(:,85),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,53),MB,G2(:,:,:,224))
  call check_last_QA_V(l_switch,G2(:,:,:,224),wf(:,12),G2tensor(:,67))
  call loop_QV_A(G2(:,:,:,224),wf(:,-3),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,61),MB,G3(:,:,:,165))
  call check_last_QA_V(l_switch,G3(:,:,:,165),wf(:,-1),G3tensor(:,81))
  call loop_VA_Q(G1(:,:,:,109),wf(:,466),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,62),MB,G2(:,:,:,226))
  call check_last_AQ_V(l_switch,G2(:,:,:,226),wf(:,0),G2tensor(:,68))
  call loop_VA_Q(G1(:,:,:,109),wf(:,83),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,30),MB,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-5),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,62),MB,G3(:,:,:,166))
  call check_last_AQ_V(l_switch,G3(:,:,:,166),wf(:,0),G3tensor(:,82))
  call loop_VA_Q(G1(:,:,:,109),wf(:,472),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,62),MB,G2(:,:,:,229))
  call check_last_AQ_V(l_switch,G2(:,:,:,229),wf(:,0),G2tensor(:,69))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,525),Q(:,39),G2(:,:,:,230))
  call check_last_UV_W(l_switch,G2(:,:,:,230),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,83))
  call loop_VQ_A(G1(:,:,:,109),wf(:,527),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,61),MB,G2(:,:,:,231))
  call check_last_QA_V(l_switch,G2(:,:,:,231),wf(:,-1),G2tensor(:,70))
  call loop_VQ_A(G1(:,:,:,109),wf(:,532),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,61),MB,G2(:,:,:,232))
  call check_last_QA_V(l_switch,G2(:,:,:,232),wf(:,-1),G2tensor(:,71))
  call loop_UV_W(G1(:,:,:,109),Q(:,16),wf(:,542),Q(:,39),G2(:,:,:,233))
  call check_last_UV_W(l_switch,G2(:,:,:,233),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,84))
  call loop_VA_Q(G1(:,:,:,109),wf(:,546),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,62),MB,G2(:,:,:,234))
  call check_last_AQ_V(l_switch,G2(:,:,:,234),wf(:,0),G2tensor(:,72))
  call loop_VA_Q(G1(:,:,:,109),wf(:,550),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,62),MB,G2(:,:,:,235))
  call check_last_AQ_V(l_switch,G2(:,:,:,235),wf(:,0),G2tensor(:,73))
  call loop_VQ_A(G1(:,:,:,109),wf(:,560),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,61),MB,G2(:,:,:,236))
  call check_last_QA_V(l_switch,G2(:,:,:,236),wf(:,-1),G2tensor(:,74))
  call loop_VA_Q(G1(:,:,:,109),wf(:,566),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,62),MB,G2(:,:,:,237))
  call check_last_AQ_V(l_switch,G2(:,:,:,237),wf(:,0),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,109),wf(:,-1),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,18),MB,G2(:,:,:,238))
  call loop_AV_Q(G2(:,:,:,238),wf(:,21),G2(:,:,:,239))
  call loop_A_Q(G2(:,:,:,239),Q(:,58),MB,G3(:,:,:,167))
  call loop_AS_Q(G3(:,:,:,167),wf(:,-2),G3(:,:,:,168),gH)
  call loop_A_Q(G3(:,:,:,168),Q(:,62),MB,G4(:,:,:,74))
  call check_last_AQ_V(l_switch,G4(:,:,:,74),wf(:,0),G4tensor(:,46))
  call loop_AS_Q(G2(:,:,:,238),wf(:,-2),G2(:,:,:,240),gH)
  call loop_A_Q(G2(:,:,:,240),Q(:,22),MB,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,21),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,62),MB,G4(:,:,:,75))
  call check_last_AQ_V(l_switch,G4(:,:,:,75),wf(:,0),G4tensor(:,47))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-5),G3(:,:,:,171))
  call loop_A_Q(G3(:,:,:,171),Q(:,54),MB,G4(:,:,:,76))
  call loop_AV_Q(G4(:,:,:,76),wf(:,-3),G4(:,:,:,77))
  call loop_A_Q(G4(:,:,:,77),Q(:,62),MB,G5(:,:,:,7))
  call check_last_AQ_V(l_switch,G5(:,:,:,7),wf(:,0),G5tensor(:,25))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-3),G3(:,:,:,172))
  call loop_A_Q(G3(:,:,:,172),Q(:,30),MB,G4(:,:,:,78))
  call loop_AV_Q(G4(:,:,:,78),wf(:,-5),G4(:,:,:,79))
  call loop_A_Q(G4(:,:,:,79),Q(:,62),MB,G5(:,:,:,8))
  call check_last_AQ_V(l_switch,G5(:,:,:,8),wf(:,0),G5tensor(:,26))
  call loop_AV_Q(G2(:,:,:,238),wf(:,-3),G2(:,:,:,241))
  call loop_A_Q(G2(:,:,:,241),Q(:,26),MB,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-5),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,58),MB,G4(:,:,:,80))
  call loop_AS_Q(G4(:,:,:,80),wf(:,-2),G4(:,:,:,81),gH)
  call loop_A_Q(G4(:,:,:,81),Q(:,62),MB,G5(:,:,:,9))
  call check_last_AQ_V(l_switch,G5(:,:,:,9),wf(:,0),G5tensor(:,27))
  call loop_AS_Q(G3(:,:,:,173),wf(:,-2),G3(:,:,:,175),gH)
  call loop_A_Q(G3(:,:,:,175),Q(:,30),MB,G4(:,:,:,82))
  call loop_AV_Q(G4(:,:,:,82),wf(:,-5),G4(:,:,:,83))
  call loop_A_Q(G4(:,:,:,83),Q(:,62),MB,G5(:,:,:,10))
  call check_last_AQ_V(l_switch,G5(:,:,:,10),wf(:,0),G5tensor(:,28))
  call loop_AV_Q(G2(:,:,:,238),wf(:,-5),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,50),MB,G3(:,:,:,176))
  call loop_AV_Q(G3(:,:,:,176),wf(:,-3),G3(:,:,:,177))
  call loop_A_Q(G3(:,:,:,177),Q(:,58),MB,G4(:,:,:,84))
  call loop_AS_Q(G4(:,:,:,84),wf(:,-2),G4(:,:,:,85),gH)
  call loop_A_Q(G4(:,:,:,85),Q(:,62),MB,G5(:,:,:,11))
  call check_last_AQ_V(l_switch,G5(:,:,:,11),wf(:,0),G5tensor(:,29))
  call loop_AS_Q(G3(:,:,:,176),wf(:,-2),G3(:,:,:,178),gH)
  call loop_A_Q(G3(:,:,:,178),Q(:,54),MB,G4(:,:,:,86))
  call loop_AV_Q(G4(:,:,:,86),wf(:,-3),G4(:,:,:,87))
  call loop_A_Q(G4(:,:,:,87),Q(:,62),MB,G5(:,:,:,12))
  call check_last_AQ_V(l_switch,G5(:,:,:,12),wf(:,0),G5tensor(:,30))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,21),G0(:,:,:,47))
  call loop_VQ_A(G0(:,:,:,47),wf(:,3),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,61),MB,G1(:,:,:,165))
  call check_last_QA_V(l_switch,G1(:,:,:,165),wf(:,-1),G1tensor(:,55))
  call loop_VA_Q(G0(:,:,:,47),wf(:,8),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,62),MB,G1(:,:,:,166))
  call check_last_AQ_V(l_switch,G1(:,:,:,166),wf(:,0),G1tensor(:,56))
  call loop_VA_Q(G0(:,:,:,47),wf(:,-1),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,58),MB,G1(:,:,:,167))
  call loop_AS_Q(G1(:,:,:,167),wf(:,-2),G1(:,:,:,168),gH)
  call loop_A_Q(G1(:,:,:,168),Q(:,62),MB,G2(:,:,:,243))
  call check_last_AQ_V(l_switch,G2(:,:,:,243),wf(:,0),G2tensor(:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,58))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,21),wf(:,-4),G0(:,:,:,51))
  call loop_VQ_A(G0(:,:,:,51),wf(:,3),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,61),MB,G1(:,:,:,169))
  call check_last_QA_V(l_switch,G1(:,:,:,169),wf(:,-1),G1tensor(:,59))
  call loop_VA_Q(G0(:,:,:,51),wf(:,8),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,62),MB,G1(:,:,:,170))
  call check_last_AQ_V(l_switch,G1(:,:,:,170),wf(:,0),G1tensor(:,60))
  call loop_VA_Q(G0(:,:,:,51),wf(:,-1),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,58),MB,G1(:,:,:,171))
  call loop_AS_Q(G1(:,:,:,171),wf(:,-2),G1(:,:,:,172),gH)
  call loop_A_Q(G1(:,:,:,172),Q(:,62),MB,G2(:,:,:,244))
  call check_last_AQ_V(l_switch,G2(:,:,:,244),wf(:,0),G2tensor(:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,62))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,21),G0(:,:,:,55))
  call loop_VQ_A(G0(:,:,:,55),wf(:,3),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,61),MB,G1(:,:,:,173))
  call check_last_QA_V(l_switch,G1(:,:,:,173),wf(:,-1),G1tensor(:,63))
  call loop_VA_Q(G0(:,:,:,55),wf(:,8),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,62),MB,G1(:,:,:,174))
  call check_last_AQ_V(l_switch,G1(:,:,:,174),wf(:,0),G1tensor(:,64))
  call loop_VA_Q(G0(:,:,:,55),wf(:,-1),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,58),MB,G1(:,:,:,175))
  call loop_AS_Q(G1(:,:,:,175),wf(:,-2),G1(:,:,:,176),gH)
  call loop_A_Q(G1(:,:,:,176),Q(:,62),MB,G2(:,:,:,245))
  call check_last_AQ_V(l_switch,G2(:,:,:,245),wf(:,0),G2tensor(:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,56),wf(:,4),Q(:,7),G1tensor(:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,56),wf(:,9),Q(:,7),G1tensor(:,66))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,4),G0(:,:,:,59))
  call loop_UV_W(G0(:,:,:,59),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,177))
  call check_last_UV_W(l_switch,G1(:,:,:,177),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-4),G0(:,:,:,60))
  call loop_UV_W(G0(:,:,:,60),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,178))
  call check_last_UV_W(l_switch,G1(:,:,:,178),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,80))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,4),G0(:,:,:,61))
  call loop_UV_W(G0(:,:,:,61),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,179))
  call check_last_UV_W(l_switch,G1(:,:,:,179),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,81))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,1),T3sum(1:35,7))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,1),T3sum(1:35,7))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,1),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,1),T3sum(1:35,7))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,2),T3sum(1:35,7))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,2),T3sum(1:35,7))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,2),T3sum(1:35,7))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,2),T3sum(1:35,7))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,3),T3sum(1:35,7))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,3),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,3),T3sum(1:35,7))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,3),T3sum(1:35,7))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,7),T3sum(1:35,8))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,7),T3sum(1:35,8))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,7),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,7),T3sum(1:35,8))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,8),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,8),T3sum(1:35,8))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,8),T3sum(1:35,8))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,8),T3sum(1:35,8))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,9),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,9),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,9),T3sum(1:35,8))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,9),T3sum(1:35,8))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,13),T3sum(1:35,8))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,13),T3sum(1:35,8))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,13),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,13),T3sum(1:35,8))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,14),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,14),T3sum(1:35,8))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,14),T3sum(1:35,8))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,14),T3sum(1:35,8))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,15),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,15),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,15),T3sum(1:35,8))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,15),T3sum(1:35,8))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,1),T2sum(1:5,1))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,1),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,15),T2sum(1:5,1))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,15),T2sum(1:5,1))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,29),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(8)) * TI2_call(1,momenta_106,masses2_9,G1tensor(:,29),T2sum(1:5,1))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,43),T2sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,47),T2sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,51),T2sum(1:5,2))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,22),T3sum(1:15,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,23),T3sum(1:15,9))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,24),T3sum(1:15,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,24),T3sum(1:15,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,24),T3sum(1:15,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,24),T3sum(1:15,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,55),T2sum(1:5,2))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,55),T2sum(1:5,2))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,55),T2sum(1:5,2))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,55),T2sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,59),T2sum(1:5,2))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,59),T2sum(1:5,2))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,59),T2sum(1:5,2))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,59),T2sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,63),T2sum(1:5,2))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,63),T2sum(1:5,2))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,63),T2sum(1:5,2))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(1,momenta_115,masses2_9,G1tensor(:,63),T2sum(1:5,2))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,79),T3sum(1:15,10))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,80),T3sum(1:15,10))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,81),T3sum(1:15,10))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,81),T3sum(1:15,10))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,81),T3sum(1:15,10))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_61,masses2_10,G2tensor(:,81),T3sum(1:15,10))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,2),T2sum(1:5,3))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,2),T2sum(1:5,3))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,16),T2sum(1:5,3))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,16),T2sum(1:5,3))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,30),T2sum(1:5,3))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,30),T2sum(1:5,3))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,2),T3sum(1:15,13))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,2),T3sum(1:15,13))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,2),T3sum(1:15,13))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,8),T3sum(1:15,13))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,8),T3sum(1:15,13))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,8),T3sum(1:15,13))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,14),T3sum(1:15,13))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_294,masses2_15,G2tensor(:,14),T3sum(1:15,13))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,3),T3sum(1:15,14))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,3),T3sum(1:15,14))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,3),T3sum(1:15,14))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,3),T3sum(1:15,14))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,3),T3sum(1:15,14))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,9),T3sum(1:15,14))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,9),T3sum(1:15,14))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,9),T3sum(1:15,14))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,9),T3sum(1:15,14))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,9),T3sum(1:15,14))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,15),T3sum(1:15,14))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,15),T3sum(1:15,14))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,15),T3sum(1:15,14))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_296,masses2_16,G2tensor(:,15),T3sum(1:15,14))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,25),T3sum(1:15,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,26),T3sum(1:15,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,27),T3sum(1:15,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,27),T3sum(1:15,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,27),T3sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,27),T3sum(1:15,15))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,31),T3sum(1:15,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,35),T3sum(1:15,16))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,39),T3sum(1:15,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,39),T3sum(1:15,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,39),T3sum(1:15,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,39),T3sum(1:15,16))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,32),T3sum(1:15,17))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,32),T3sum(1:15,17))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,32),T3sum(1:15,17))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,32),T3sum(1:15,17))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,32),T3sum(1:15,17))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,36),T3sum(1:15,17))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,36),T3sum(1:15,17))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,36),T3sum(1:15,17))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,36),T3sum(1:15,17))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,36),T3sum(1:15,17))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,40),T3sum(1:15,17))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,40),T3sum(1:15,17))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,40),T3sum(1:15,17))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_206,masses2_16,G2tensor(:,40),T3sum(1:15,17))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,3),T2sum(1:5,9))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,3),T2sum(1:5,9))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,17),T2sum(1:5,9))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,17),T2sum(1:5,9))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,31),T2sum(1:5,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(46)) * TI2_call(1,momenta_105,masses2_9,G1tensor(:,31),T2sum(1:5,9))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,44),T2sum(1:5,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,48),T2sum(1:5,10))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,52),T2sum(1:5,10))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,43),T3sum(1:15,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,44),T3sum(1:15,9))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,45),T3sum(1:15,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,45),T3sum(1:15,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,45),T3sum(1:15,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_41,masses2_10,G2tensor(:,45),T3sum(1:15,9))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,56),T2sum(1:5,10))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,56),T2sum(1:5,10))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,56),T2sum(1:5,10))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,56),T2sum(1:5,10))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,60),T2sum(1:5,10))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,60),T2sum(1:5,10))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,60),T2sum(1:5,10))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,60),T2sum(1:5,10))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,64),T2sum(1:5,10))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,64),T2sum(1:5,10))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,64),T2sum(1:5,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(1,momenta_116,masses2_9,G1tensor(:,64),T2sum(1:5,10))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,4),T2sum(1:5,11))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,4),T2sum(1:5,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,18),T2sum(1:5,11))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,18),T2sum(1:5,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,32),T2sum(1:5,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(60)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,32),T2sum(1:5,11))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,6),T3sum(1:15,25))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,6),T3sum(1:15,25))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,6),T3sum(1:15,25))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,12),T3sum(1:15,25))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,12),T3sum(1:15,25))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,12),T3sum(1:15,25))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,18),T3sum(1:15,25))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(2,momenta_295,masses2_15,G2tensor(:,18),T3sum(1:15,25))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,4),T3sum(1:15,26))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,4),T3sum(1:15,26))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,4),T3sum(1:15,26))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,4),T3sum(1:15,26))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,4),T3sum(1:15,26))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,10),T3sum(1:15,26))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,10),T3sum(1:15,26))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,10),T3sum(1:15,26))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,10),T3sum(1:15,26))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,10),T3sum(1:15,26))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,16),T3sum(1:15,26))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,16),T3sum(1:15,26))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,16),T3sum(1:15,26))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_297,masses2_16,G2tensor(:,16),T3sum(1:15,26))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,28),T3sum(1:15,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,29),T3sum(1:15,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,30),T3sum(1:15,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,30),T3sum(1:15,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,30),T3sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,30),T3sum(1:15,15))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,33),T3sum(1:15,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,37),T3sum(1:15,16))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,41),T3sum(1:15,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,41),T3sum(1:15,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,41),T3sum(1:15,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(2,momenta_42,masses2_10,G2tensor(:,41),T3sum(1:15,16))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,34),T3sum(1:15,27))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,34),T3sum(1:15,27))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,34),T3sum(1:15,27))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,34),T3sum(1:15,27))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,34),T3sum(1:15,27))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,38),T3sum(1:15,27))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,38),T3sum(1:15,27))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,38),T3sum(1:15,27))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,38),T3sum(1:15,27))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,38),T3sum(1:15,27))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,42),T3sum(1:15,27))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,42),T3sum(1:15,27))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,42),T3sum(1:15,27))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(2,momenta_207,masses2_16,G2tensor(:,42),T3sum(1:15,27))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,5),T2sum(1:5,3))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,5),T2sum(1:5,3))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,19),T2sum(1:5,3))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,19),T2sum(1:5,3))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,33),T2sum(1:5,3))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(80)) * TI2_call(1,momenta_107,masses2_9,G1tensor(:,33),T2sum(1:5,3))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,5),T3sum(1:15,33))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,5),T3sum(1:15,33))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,11),T3sum(1:15,33))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,11),T3sum(1:15,33))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,17),T3sum(1:15,33))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(45)) * TI2_call(2,momenta_298,masses2_15,G2tensor(:,17),T3sum(1:15,33))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,6),T2sum(1:5,11))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,6),T2sum(1:5,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,20),T2sum(1:5,11))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,20),T2sum(1:5,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,34),T2sum(1:5,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(91)) * TI2_call(1,momenta_108,masses2_9,G1tensor(:,34),T2sum(1:5,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,1),T3sum(1:15,34))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,1),T3sum(1:15,34))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,7),T3sum(1:15,34))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,7),T3sum(1:15,34))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,13),T3sum(1:15,34))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_299,masses2_15,G2tensor(:,13),T3sum(1:15,34))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,19),T3sum(1:15,35))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,19),T3sum(1:15,35))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,19),T3sum(1:15,35))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,19),T3sum(1:15,35))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,20),T3sum(1:15,35))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,20),T3sum(1:15,35))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,20),T3sum(1:15,35))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,20),T3sum(1:15,35))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,21),T3sum(1:15,35))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,21),T3sum(1:15,35))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,21),T3sum(1:15,35))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,21),T3sum(1:15,35))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,76),T3sum(1:15,35))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,76),T3sum(1:15,35))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,76),T3sum(1:15,35))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,76),T3sum(1:15,35))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,77),T3sum(1:15,35))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,77),T3sum(1:15,35))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,77),T3sum(1:15,35))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,77),T3sum(1:15,35))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,78),T3sum(1:15,35))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,78),T3sum(1:15,35))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,78),T3sum(1:15,35))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_304,masses2_15,G2tensor(:,78),T3sum(1:15,35))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,19),T4sum(1:35,2))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,19),T4sum(1:35,2))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,19),T4sum(1:35,2))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,19),T4sum(1:35,2))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,19),T4sum(1:35,2))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,22),T4sum(1:35,2))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,22),T4sum(1:35,2))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,22),T4sum(1:35,2))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,22),T4sum(1:35,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,22),T4sum(1:35,2))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,25),T4sum(1:35,2))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,25),T4sum(1:35,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,25),T4sum(1:35,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_472,masses2_22,G3tensor(:,25),T4sum(1:35,2))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,20),T4sum(1:35,3))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,20),T4sum(1:35,3))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,20),T4sum(1:35,3))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,23),T4sum(1:35,3))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,23),T4sum(1:35,3))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,23),T4sum(1:35,3))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,26),T4sum(1:35,3))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_471,masses2_21,G3tensor(:,26),T4sum(1:35,3))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,21),T4sum(1:35,4))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,21),T4sum(1:35,4))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,21),T4sum(1:35,4))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,24),T4sum(1:35,4))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,24),T4sum(1:35,4))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,24),T4sum(1:35,4))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,27),T4sum(1:35,4))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND)) * TI2_call(3,momenta_470,masses2_21,G3tensor(:,27),T4sum(1:35,4))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,42),T4sum(1:35,5))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,42),T4sum(1:35,5))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,42),T4sum(1:35,5))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,42),T4sum(1:35,5))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,42),T4sum(1:35,5))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,43),T4sum(1:35,5))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,43),T4sum(1:35,5))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,43),T4sum(1:35,5))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,43),T4sum(1:35,5))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,43),T4sum(1:35,5))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,44),T4sum(1:35,5))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,44),T4sum(1:35,5))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,44),T4sum(1:35,5))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(3,momenta_412,masses2_22,G3tensor(:,44),T4sum(1:35,5))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,4),T3sum(1:35,7))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,4),T3sum(1:35,7))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,4),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,4),T3sum(1:35,7))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,10),T3sum(1:35,8))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,10),T3sum(1:35,8))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,10),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,10),T3sum(1:35,8))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,16),T3sum(1:35,8))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,16),T3sum(1:35,8))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,16),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,16),T3sum(1:35,8))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,1),T4sum(1:70,13))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,1),T4sum(1:70,13))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,1),T4sum(1:70,13))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,1),T4sum(1:70,13))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,13),T4sum(1:70,14))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,13),T4sum(1:70,14))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,13),T4sum(1:70,14))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,13),T4sum(1:70,14))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,7),T4sum(1:70,14))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,7),T4sum(1:70,14))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,7),T4sum(1:70,14))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_11,G4tensor(:,7),T4sum(1:70,14))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,2),T4sum(1:70,17))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,2),T4sum(1:70,17))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,2),T4sum(1:70,17))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,2),T4sum(1:70,17))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,8),T4sum(1:70,18))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,8),T4sum(1:70,18))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,8),T4sum(1:70,18))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,8),T4sum(1:70,18))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,14),T4sum(1:70,18))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,14),T4sum(1:70,18))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,14),T4sum(1:70,18))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_11,G4tensor(:,14),T4sum(1:70,18))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,5),T3sum(1:35,7))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,5),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,5),T3sum(1:35,7))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,5),T3sum(1:35,7))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,11),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,11),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,11),T3sum(1:35,8))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,11),T3sum(1:35,8))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,17),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,17),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,17),T3sum(1:35,8))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,17),T3sum(1:35,8))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,3),T4sum(1:70,19))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,3),T4sum(1:70,19))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,3),T4sum(1:70,19))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,3),T4sum(1:70,19))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,15),T4sum(1:70,20))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,15),T4sum(1:70,20))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,15),T4sum(1:70,20))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,15),T4sum(1:70,20))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,9),T4sum(1:70,20))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,9),T4sum(1:70,20))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,9),T4sum(1:70,20))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_11,G4tensor(:,9),T4sum(1:70,20))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,4),T4sum(1:70,23))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,4),T4sum(1:70,23))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,4),T4sum(1:70,23))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,4),T4sum(1:70,23))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,10),T4sum(1:70,24))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,10),T4sum(1:70,24))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,10),T4sum(1:70,24))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,10),T4sum(1:70,24))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,16),T4sum(1:70,24))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,16),T4sum(1:70,24))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,16),T4sum(1:70,24))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_11,G4tensor(:,16),T4sum(1:70,24))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,6),T3sum(1:35,7))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,6),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,6),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,6),T3sum(1:35,7))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,12),T3sum(1:35,8))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,12),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,12),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,12),T3sum(1:35,8))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,5),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,5),T4sum(1:70,25))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,5),T4sum(1:70,25))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,5),T4sum(1:70,25))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,17),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,17),T4sum(1:70,26))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,17),T4sum(1:70,26))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,17),T4sum(1:70,26))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,11),T4sum(1:70,26))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,11),T4sum(1:70,26))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,11),T4sum(1:70,26))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_11,G4tensor(:,11),T4sum(1:70,26))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,6),T4sum(1:70,29))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,6),T4sum(1:70,29))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,6),T4sum(1:70,29))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,6),T4sum(1:70,29))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,12),T4sum(1:70,30))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,12),T4sum(1:70,30))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,12),T4sum(1:70,30))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,12),T4sum(1:70,30))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,18),T4sum(1:70,30))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,18),T4sum(1:70,30))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,18),T4sum(1:70,30))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_11,G4tensor(:,18),T4sum(1:70,30))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_323,masses2_20,G5tensor(:,5),T5sum(1:126,9))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_323,masses2_20,G5tensor(:,5),T5sum(1:126,9))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_323,masses2_18,G5tensor(:,17),T5sum(1:126,10))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_323,masses2_18,G5tensor(:,17),T5sum(1:126,10))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_323,masses2_18,G5tensor(:,11),T5sum(1:126,10))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_323,masses2_18,G5tensor(:,11),T5sum(1:126,10))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_324,masses2_20,G5tensor(:,6),T5sum(1:126,11))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_324,masses2_20,G5tensor(:,6),T5sum(1:126,11))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_324,masses2_18,G5tensor(:,18),T5sum(1:126,12))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_324,masses2_18,G5tensor(:,18),T5sum(1:126,12))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_324,masses2_18,G5tensor(:,12),T5sum(1:126,12))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_324,masses2_18,G5tensor(:,12),T5sum(1:126,12))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_325,masses2_20,G5tensor(:,3),T5sum(1:126,17))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_325,masses2_20,G5tensor(:,3),T5sum(1:126,17))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_325,masses2_18,G5tensor(:,15),T5sum(1:126,18))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_325,masses2_18,G5tensor(:,15),T5sum(1:126,18))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_325,masses2_18,G5tensor(:,9),T5sum(1:126,18))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_325,masses2_18,G5tensor(:,9),T5sum(1:126,18))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_326,masses2_20,G5tensor(:,4),T5sum(1:126,19))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_326,masses2_20,G5tensor(:,4),T5sum(1:126,19))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_326,masses2_18,G5tensor(:,16),T5sum(1:126,20))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_326,masses2_18,G5tensor(:,16),T5sum(1:126,20))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_326,masses2_18,G5tensor(:,10),T5sum(1:126,20))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_326,masses2_18,G5tensor(:,10),T5sum(1:126,20))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_327,masses2_20,G5tensor(:,1),T5sum(1:126,21))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_327,masses2_20,G5tensor(:,1),T5sum(1:126,21))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_327,masses2_18,G5tensor(:,13),T5sum(1:126,22))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_327,masses2_18,G5tensor(:,13),T5sum(1:126,22))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_327,masses2_18,G5tensor(:,7),T5sum(1:126,22))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_327,masses2_18,G5tensor(:,7),T5sum(1:126,22))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_328,masses2_20,G5tensor(:,2),T5sum(1:126,23))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_328,masses2_20,G5tensor(:,2),T5sum(1:126,23))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_328,masses2_18,G5tensor(:,14),T5sum(1:126,24))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_328,masses2_18,G5tensor(:,14),T5sum(1:126,24))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_328,masses2_18,G5tensor(:,8),T5sum(1:126,24))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_328,masses2_18,G5tensor(:,8),T5sum(1:126,24))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(144)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,46),T2sum(1:15,23))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(146)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,47),T2sum(1:15,27))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,28),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,28),T3sum(1:35,15))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_197,masses2_16,G3tensor(:,29),T3sum(1:35,51))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_197,masses2_16,G3tensor(:,29),T3sum(1:35,51))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_192,masses2_15,G3tensor(:,47),T3sum(1:35,55))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(34)) * TI2_call(2,momenta_38,masses2_9,G2tensor(:,48),T2sum(1:15,40))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(37)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,50),T2sum(1:15,27))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,51),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,51),T3sum(1:35,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_187,masses2_16,G3tensor(:,52),T3sum(1:35,74))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_187,masses2_16,G3tensor(:,52),T3sum(1:35,74))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_203,masses2_15,G3tensor(:,48),T3sum(1:35,75))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,58),T3sum(1:35,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,58),T3sum(1:35,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,58),T3sum(1:35,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,58),T3sum(1:35,16))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(40)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,51),T2sum(1:15,27))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(40)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,51),T2sum(1:15,27))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(284)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,52),T2sum(1:15,45))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(284)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,52),T2sum(1:15,45))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_206,masses2_16,G3tensor(:,59),T3sum(1:35,17))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_206,masses2_16,G3tensor(:,59),T3sum(1:35,17))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_206,masses2_16,G3tensor(:,59),T3sum(1:35,17))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_206,masses2_16,G3tensor(:,59),T3sum(1:35,17))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_183,masses2_15,G3tensor(:,63),T3sum(1:35,80))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(282)) * TI2_call(3,momenta_183,masses2_15,G3tensor(:,63),T3sum(1:35,80))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,30),T3sum(1:35,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,30),T3sum(1:35,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,30),T3sum(1:35,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,30),T3sum(1:35,15))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(7) = M(7) + (f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(8) = M(8) + (f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(9) = M(9) + (f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,30),T4sum(1:70,49))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,31),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,31),T3sum(1:35,15))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(478)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,53),T2sum(1:15,45))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_194,masses2_15,G3tensor(:,65),T3sum(1:35,88))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_198,masses2_16,G3tensor(:,32),T3sum(1:35,90))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_198,masses2_16,G3tensor(:,32),T3sum(1:35,90))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,66),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,66),T3sum(1:35,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(483)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,54),T2sum(1:15,45))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_204,masses2_15,G3tensor(:,45),T3sum(1:35,99))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_189,masses2_16,G3tensor(:,53),T3sum(1:35,104))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_189,masses2_16,G3tensor(:,53),T3sum(1:35,104))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_388,masses2_21,G4tensor(:,38),T4sum(1:70,58))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_388,masses2_21,G4tensor(:,38),T4sum(1:70,58))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_402,masses2_22,G4tensor(:,20),T4sum(1:70,61))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_402,masses2_22,G4tensor(:,20),T4sum(1:70,61))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_402,masses2_22,G4tensor(:,20),T4sum(1:70,61))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_392,masses2_22,G4tensor(:,34),T4sum(1:70,71))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_392,masses2_22,G4tensor(:,34),T4sum(1:70,71))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_392,masses2_22,G4tensor(:,34),T4sum(1:70,71))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_387,masses2_21,G4tensor(:,39),T4sum(1:70,72))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_387,masses2_21,G4tensor(:,39),T4sum(1:70,72))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_394,masses2_23,G4tensor(:,31),T4sum(1:70,75))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_394,masses2_23,G4tensor(:,31),T4sum(1:70,75))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_394,masses2_23,G4tensor(:,31),T4sum(1:70,75))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_394,masses2_23,G4tensor(:,31),T4sum(1:70,75))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_394,masses2_23,G4tensor(:,31),T4sum(1:70,75))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_404,masses2_23,G4tensor(:,21),T4sum(1:70,77))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_404,masses2_23,G4tensor(:,21),T4sum(1:70,77))
  M(8) = M(8) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_404,masses2_23,G4tensor(:,21),T4sum(1:70,77))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_404,masses2_23,G4tensor(:,21),T4sum(1:70,77))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_404,masses2_23,G4tensor(:,21),T4sum(1:70,77))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(158)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,55),T2sum(1:15,53))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,56),T2sum(1:15,57))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(46)) * TI2_call(3,momenta_196,masses2_16,G3tensor(:,34),T3sum(1:35,108))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(46)) * TI2_call(3,momenta_196,masses2_16,G3tensor(:,34),T3sum(1:35,108))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(46)) * TI2_call(3,momenta_191,masses2_15,G3tensor(:,69),T3sum(1:35,110))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(71)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,57),T2sum(1:15,53))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(72)) * TI2_call(2,momenta_37,masses2_9,G2tensor(:,58),T2sum(1:15,70))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,73),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,73),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_186,masses2_16,G3tensor(:,54),T3sum(1:35,121))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_186,masses2_16,G3tensor(:,54),T3sum(1:35,121))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_201,masses2_15,G3tensor(:,71),T3sum(1:35,124))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(75)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,60),T2sum(1:15,53))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(75)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,60),T2sum(1:15,53))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(353)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,61),T2sum(1:15,75))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(353)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,61),T2sum(1:15,75))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_207,masses2_16,G3tensor(:,61),T3sum(1:35,27))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_207,masses2_16,G3tensor(:,61),T3sum(1:35,27))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_207,masses2_16,G3tensor(:,61),T3sum(1:35,27))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_207,masses2_16,G3tensor(:,61),T3sum(1:35,27))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(351)) * TI2_call(3,momenta_184,masses2_15,G3tensor(:,75),T3sum(1:35,127))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_184,masses2_15,G3tensor(:,75),T3sum(1:35,127))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,76),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,76),T3sum(1:35,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,76),T3sum(1:35,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,76),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(7) = M(7) + (f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(8) = M(8) + (f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(9) = M(9) + (f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,32),T4sum(1:70,49))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,77),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,77),T3sum(1:35,9))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(492)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,62),T2sum(1:15,75))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(60)) * TI2_call(3,momenta_195,masses2_15,G3tensor(:,78),T3sum(1:35,133))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(60)) * TI2_call(3,momenta_199,masses2_16,G3tensor(:,37),T3sum(1:35,135))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(60)) * TI2_call(3,momenta_199,masses2_16,G3tensor(:,37),T3sum(1:35,135))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(495)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,63),T2sum(1:15,75))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_205,masses2_15,G3tensor(:,68),T3sum(1:35,144))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_190,masses2_16,G3tensor(:,55),T3sum(1:35,149))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_190,masses2_16,G3tensor(:,55),T3sum(1:35,149))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_390,masses2_21,G4tensor(:,44),T4sum(1:70,82))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_390,masses2_21,G4tensor(:,44),T4sum(1:70,82))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_403,masses2_22,G4tensor(:,24),T4sum(1:70,85))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_403,masses2_22,G4tensor(:,24),T4sum(1:70,85))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_403,masses2_22,G4tensor(:,24),T4sum(1:70,85))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_393,masses2_22,G4tensor(:,36),T4sum(1:70,95))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND) * den(4)) * TI2_call(4,momenta_393,masses2_22,G4tensor(:,36),T4sum(1:70,95))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_393,masses2_22,G4tensor(:,36),T4sum(1:70,95))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_389,masses2_21,G4tensor(:,45),T4sum(1:70,96))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_389,masses2_21,G4tensor(:,45),T4sum(1:70,96))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_395,masses2_23,G4tensor(:,33),T4sum(1:70,99))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_395,masses2_23,G4tensor(:,33),T4sum(1:70,99))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_395,masses2_23,G4tensor(:,33),T4sum(1:70,99))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_395,masses2_23,G4tensor(:,33),T4sum(1:70,99))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_395,masses2_23,G4tensor(:,33),T4sum(1:70,99))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_405,masses2_23,G4tensor(:,22),T4sum(1:70,101))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_405,masses2_23,G4tensor(:,22),T4sum(1:70,101))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_405,masses2_23,G4tensor(:,22),T4sum(1:70,101))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_405,masses2_23,G4tensor(:,22),T4sum(1:70,101))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(4)) * TI2_call(4,momenta_405,masses2_23,G4tensor(:,22),T4sum(1:70,101))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(84)) * TI2_call(2,momenta_38,masses2_9,G2tensor(:,49),T2sum(1:15,40))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(87)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,64),T2sum(1:15,57))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(182)) * TI2_call(3,momenta_202,masses2_15,G3tensor(:,49),T3sum(1:35,155))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(503)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,65),T2sum(1:15,45))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_194,masses2_15,G3tensor(:,80),T3sum(1:35,88))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_198,masses2_16,G3tensor(:,39),T3sum(1:35,90))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_198,masses2_16,G3tensor(:,39),T3sum(1:35,90))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(508)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,66),T2sum(1:15,45))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_208,masses2_15,G3tensor(:,67),T3sum(1:35,161))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_399,masses2_21,G4tensor(:,40),T4sum(1:70,106))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_406,masses2_22,G4tensor(:,23),T4sum(1:70,107))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_406,masses2_22,G4tensor(:,23),T4sum(1:70,107))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_398,masses2_21,G4tensor(:,41),T4sum(1:70,113))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(95)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,67),T2sum(1:15,23))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(96)) * TI2_call(2,momenta_37,masses2_9,G2tensor(:,59),T2sum(1:15,70))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(198)) * TI2_call(3,momenta_200,masses2_15,G3tensor(:,72),T3sum(1:35,169))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(518)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,68),T2sum(1:15,75))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_195,masses2_15,G3tensor(:,82),T3sum(1:35,133))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_199,masses2_16,G3tensor(:,41),T3sum(1:35,135))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_199,masses2_16,G3tensor(:,41),T3sum(1:35,135))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(521)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,69),T2sum(1:15,75))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(145)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,46),T3sum(1:35,175))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_401,masses2_21,G4tensor(:,25),T4sum(1:70,118))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_407,masses2_22,G4tensor(:,19),T4sum(1:70,119))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_407,masses2_22,G4tensor(:,19),T4sum(1:70,119))
  M(9) = M(9) + (-(CI*f(16))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_400,masses2_21,G4tensor(:,26),T4sum(1:70,125))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(558)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,70),T2sum(1:15,45))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_204,masses2_15,G3tensor(:,81),T3sum(1:35,99))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_189,masses2_16,G3tensor(:,56),T3sum(1:35,104))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(94)) * TI2_call(3,momenta_189,masses2_16,G3tensor(:,56),T3sum(1:35,104))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(561)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,71),T2sum(1:15,45))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_208,masses2_15,G3tensor(:,70),T3sum(1:35,161))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_409,masses2_21,G4tensor(:,42),T4sum(1:70,164))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_396,masses2_22,G4tensor(:,35),T4sum(1:70,165))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_396,masses2_22,G4tensor(:,35),T4sum(1:70,165))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND * den(62)) * TI2_call(4,momenta_408,masses2_21,G4tensor(:,43),T4sum(1:70,168))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,84),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,84),T3sum(1:35,9))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(571)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,72),T2sum(1:15,75))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_205,masses2_15,G3tensor(:,79),T3sum(1:35,144))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_190,masses2_16,G3tensor(:,57),T3sum(1:35,149))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_190,masses2_16,G3tensor(:,57),T3sum(1:35,149))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(573)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,73),T2sum(1:15,75))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(36)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,50),T3sum(1:35,175))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_411,masses2_21,G4tensor(:,27),T4sum(1:70,176))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_397,masses2_22,G4tensor(:,29),T4sum(1:70,177))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_397,masses2_22,G4tensor(:,29),T4sum(1:70,177))
  M(7) = M(7) + (-(CI*f(16))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_410,masses2_21,G4tensor(:,28),T4sum(1:70,180))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(579)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,74),T2sum(1:15,45))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(579)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,74),T2sum(1:15,45))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(74)) * TI2_call(3,momenta_208,masses2_15,G3tensor(:,74),T3sum(1:35,161))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(74)) * TI2_call(3,momenta_208,masses2_15,G3tensor(:,74),T3sum(1:35,161))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(582)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,75),T2sum(1:15,75))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(582)) * TI2_call(2,momenta_47,masses2_9,G2tensor(:,75),T2sum(1:15,75))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,62),T3sum(1:35,175))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_209,masses2_15,G3tensor(:,62),T3sum(1:35,175))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_412,masses2_22,G4tensor(:,37),T4sum(1:70,5))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_412,masses2_22,G4tensor(:,37),T4sum(1:70,5))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_412,masses2_22,G4tensor(:,37),T4sum(1:70,5))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_412,masses2_22,G4tensor(:,37),T4sum(1:70,5))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(17)) * TI2_call(4,momenta_385,masses2_21,G4tensor(:,46),T4sum(1:70,192))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_385,masses2_21,G4tensor(:,46),T4sum(1:70,192))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(17)) * TI2_call(4,momenta_384,masses2_21,G4tensor(:,47),T4sum(1:70,193))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_384,masses2_21,G4tensor(:,47),T4sum(1:70,193))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_520,masses2_27,G5tensor(:,19),T5sum(1:126,55))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_520,masses2_27,G5tensor(:,19),T5sum(1:126,55))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_520,masses2_27,G5tensor(:,19),T5sum(1:126,55))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_520,masses2_27,G5tensor(:,19),T5sum(1:126,55))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_520,masses2_27,G5tensor(:,19),T5sum(1:126,55))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_517,masses2_27,G5tensor(:,22),T5sum(1:126,56))
  M(7) = M(7) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_517,masses2_27,G5tensor(:,22),T5sum(1:126,56))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_517,masses2_27,G5tensor(:,22),T5sum(1:126,56))
  M(9) = M(9) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_517,masses2_27,G5tensor(:,22),T5sum(1:126,56))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_517,masses2_27,G5tensor(:,22),T5sum(1:126,56))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_512,masses2_25,G5tensor(:,27),T5sum(1:126,57))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_512,masses2_25,G5tensor(:,27),T5sum(1:126,57))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_519,masses2_26,G5tensor(:,20),T5sum(1:126,58))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_519,masses2_26,G5tensor(:,20),T5sum(1:126,58))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_519,masses2_26,G5tensor(:,20),T5sum(1:126,58))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_516,masses2_26,G5tensor(:,23),T5sum(1:126,59))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_516,masses2_26,G5tensor(:,23),T5sum(1:126,59))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_516,masses2_26,G5tensor(:,23),T5sum(1:126,59))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_514,masses2_25,G5tensor(:,29),T5sum(1:126,60))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_514,masses2_25,G5tensor(:,29),T5sum(1:126,60))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_510,masses2_25,G5tensor(:,25),T5sum(1:126,68))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_510,masses2_25,G5tensor(:,25),T5sum(1:126,68))
  M(7) = M(7) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_518,masses2_26,G5tensor(:,21),T5sum(1:126,69))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_518,masses2_26,G5tensor(:,21),T5sum(1:126,69))
  M(10) = M(10) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_518,masses2_26,G5tensor(:,21),T5sum(1:126,69))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_513,masses2_25,G5tensor(:,30),T5sum(1:126,72))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_513,masses2_25,G5tensor(:,30),T5sum(1:126,72))
  M(8) = M(8) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_515,masses2_26,G5tensor(:,24),T5sum(1:126,80))
  M(9) = M(9) + (-(f(18)/2._/**/REALKIND)) * TI2_call(5,momenta_515,masses2_26,G5tensor(:,24),T5sum(1:126,80))
  M(11) = M(11) + (f(18)/2._/**/REALKIND) * TI2_call(5,momenta_515,masses2_26,G5tensor(:,24),T5sum(1:126,80))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_509,masses2_25,G5tensor(:,26),T5sum(1:126,81))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_509,masses2_25,G5tensor(:,26),T5sum(1:126,81))
  M(8) = M(8) + ((CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_511,masses2_25,G5tensor(:,28),T5sum(1:126,83))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND) * TI2_call(5,momenta_511,masses2_25,G5tensor(:,28),T5sum(1:126,83))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,1),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,2),T2sum(1:1,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,3),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,3),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,3),T2sum(1:1,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,3),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,7),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,8),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,9),T2sum(1:1,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,9),T2sum(1:1,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,9),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,9),T2sum(1:1,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,13),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,13),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,13),T2sum(1:1,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,13),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,14),T2sum(1:1,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,14),T2sum(1:1,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,14),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,14),T2sum(1:1,87))
  M(1) = M(1) + (3*f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,15),T2sum(1:1,87))
  M(2) = M(2) + (-3*f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,15),T2sum(1:1,87))
  M(4) = M(4) + (-3*f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,15),T2sum(1:1,87))
  M(6) = M(6) + (3*f(17) * den(30)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,15),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,4),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,5),T2sum(1:1,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,6),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,6),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,6),T2sum(1:1,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,6),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,10),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(7) = M(7) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(8) = M(8) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(9) = M(9) + (f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(10) = M(10) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(11) = M(11) + (-(f(17)/2._/**/REALKIND) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,11),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,12),T2sum(1:1,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,12),T2sum(1:1,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,12),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,12),T2sum(1:1,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,16),T2sum(1:1,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,16),T2sum(1:1,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,16),T2sum(1:1,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,16),T2sum(1:1,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,17),T2sum(1:1,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,17),T2sum(1:1,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,17),T2sum(1:1,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,17),T2sum(1:1,87))
  M(1) = M(1) + (3*f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,18),T2sum(1:1,87))
  M(2) = M(2) + (-3*f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,18),T2sum(1:1,87))
  M(4) = M(4) + (-3*f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,18),T2sum(1:1,87))
  M(6) = M(6) + (3*f(17) * den(65)) * TI2_call(0,momenta_13,masses2_4,G0tensor(:,18),T2sum(1:1,87))
  M(1) = M(1) + ((3*CI*f(15))/2._/**/REALKIND * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,7),T2sum(1:5,87))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,7),T2sum(1:5,87))
  M(1) = M(1) + ((-3*CI*f(15))/2._/**/REALKIND * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,21),T2sum(1:5,87))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,21),T2sum(1:5,87))
  M(1) = M(1) + (-3*CI*f(15) * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,35),T2sum(1:5,87))
  M(2) = M(2) + (3*CI*f(15) * den(269)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,35),T2sum(1:5,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,45),T2sum(1:5,88))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,49),T2sum(1:5,88))
  M(1) = M(1) + (3*f(17) * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(3) = M(3) + (-3*f(17) * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(5) = M(5) + (-3*f(17) * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(6) = M(6) + (3*f(17) * den(31)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,53),T2sum(1:5,88))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,57),T2sum(1:5,88))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,57),T2sum(1:5,88))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,57),T2sum(1:5,88))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,57),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,61),T2sum(1:5,88))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,61),T2sum(1:5,88))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,61),T2sum(1:5,88))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,61),T2sum(1:5,88))
  M(2) = M(2) + (3*f(17) * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,65),T2sum(1:5,88))
  M(3) = M(3) + (-3*f(17) * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,65),T2sum(1:5,88))
  M(4) = M(4) + (3*f(17) * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,65),T2sum(1:5,88))
  M(5) = M(5) + (-3*f(17) * den(38)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,65),T2sum(1:5,88))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,8),T2sum(1:5,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,8),T2sum(1:5,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,8),T2sum(1:5,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,8),T2sum(1:5,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,22),T2sum(1:5,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,22),T2sum(1:5,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,22),T2sum(1:5,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,22),T2sum(1:5,87))
  M(1) = M(1) + (3*f(17) * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,36),T2sum(1:5,87))
  M(2) = M(2) + (-3*f(17) * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,36),T2sum(1:5,87))
  M(4) = M(4) + (-3*f(17) * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,36),T2sum(1:5,87))
  M(6) = M(6) + (3*f(17) * den(473)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,36),T2sum(1:5,87))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,9),T2sum(1:5,87))
  M(6) = M(6) + ((-3*CI*f(15))/2._/**/REALKIND * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,9),T2sum(1:5,87))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,23),T2sum(1:5,87))
  M(6) = M(6) + ((3*CI*f(15))/2._/**/REALKIND * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,23),T2sum(1:5,87))
  M(4) = M(4) + (-3*CI*f(15) * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,37),T2sum(1:5,87))
  M(6) = M(6) + (3*CI*f(15) * den(476)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,37),T2sum(1:5,87))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,10),T2sum(1:5,87))
  M(6) = M(6) + ((-3*CI*f(15))/2._/**/REALKIND * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,10),T2sum(1:5,87))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,24),T2sum(1:5,87))
  M(6) = M(6) + ((3*CI*f(15))/2._/**/REALKIND * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,24),T2sum(1:5,87))
  M(4) = M(4) + (-3*CI*f(15) * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,38),T2sum(1:5,87))
  M(6) = M(6) + (3*CI*f(15) * den(341)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,38),T2sum(1:5,87))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,46),T2sum(1:5,88))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,50),T2sum(1:5,88))
  M(1) = M(1) + (3*f(17) * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(3) = M(3) + (-3*f(17) * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(5) = M(5) + (-3*f(17) * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(6) = M(6) + (3*f(17) * den(66)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,54),T2sum(1:5,88))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,58),T2sum(1:5,88))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,58),T2sum(1:5,88))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,58),T2sum(1:5,88))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,58),T2sum(1:5,88))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,62),T2sum(1:5,88))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,62),T2sum(1:5,88))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,62),T2sum(1:5,88))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,62),T2sum(1:5,88))
  M(2) = M(2) + (3*f(17) * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,66),T2sum(1:5,88))
  M(3) = M(3) + (-3*f(17) * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,66),T2sum(1:5,88))
  M(4) = M(4) + (3*f(17) * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,66),T2sum(1:5,88))
  M(5) = M(5) + (-3*f(17) * den(73)) * TI2_call(1,momenta_19,masses2_4,G1tensor(:,66),T2sum(1:5,88))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,11),T2sum(1:5,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,11),T2sum(1:5,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,11),T2sum(1:5,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,11),T2sum(1:5,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,25),T2sum(1:5,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,25),T2sum(1:5,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,25),T2sum(1:5,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,25),T2sum(1:5,87))
  M(1) = M(1) + (3*f(17) * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,39),T2sum(1:5,87))
  M(2) = M(2) + (-3*f(17) * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,39),T2sum(1:5,87))
  M(4) = M(4) + (-3*f(17) * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,39),T2sum(1:5,87))
  M(6) = M(6) + (3*f(17) * den(485)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,39),T2sum(1:5,87))
  M(1) = M(1) + ((3*CI*f(15))/2._/**/REALKIND * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,12),T2sum(1:5,87))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,12),T2sum(1:5,87))
  M(1) = M(1) + ((-3*CI*f(15))/2._/**/REALKIND * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,26),T2sum(1:5,87))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,26),T2sum(1:5,87))
  M(1) = M(1) + (-3*CI*f(15) * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,40),T2sum(1:5,87))
  M(2) = M(2) + (3*CI*f(15) * den(488)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,40),T2sum(1:5,87))
  M(4) = M(4) + ((3*CI*f(15))/2._/**/REALKIND * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,13),T2sum(1:5,87))
  M(6) = M(6) + ((-3*CI*f(15))/2._/**/REALKIND * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,13),T2sum(1:5,87))
  M(4) = M(4) + ((-3*CI*f(15))/2._/**/REALKIND * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,27),T2sum(1:5,87))
  M(6) = M(6) + ((3*CI*f(15))/2._/**/REALKIND * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,27),T2sum(1:5,87))
  M(4) = M(4) + (-3*CI*f(15) * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,41),T2sum(1:5,87))
  M(6) = M(6) + (3*CI*f(15) * den(501)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,41),T2sum(1:5,87))
  M(1) = M(1) + ((3*CI*f(15))/2._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,14),T2sum(1:5,87))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,14),T2sum(1:5,87))
  M(1) = M(1) + ((-3*CI*f(15))/2._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,28),T2sum(1:5,87))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,28),T2sum(1:5,87))
  M(1) = M(1) + (-3*CI*f(15) * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,42),T2sum(1:5,87))
  M(2) = M(2) + (3*CI*f(15) * den(514)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,42),T2sum(1:5,87))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G0tensorhel)
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphjjj2_bbxhggg_1_/**/REALKIND
