
module ol_vamp_1_pphjjj2_uuxddxhg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_uuxddxhg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_uuxddxhg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_uuxddxhg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_uuxddxhg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,9) :: G0
  complex(REALKIND), dimension(4,5,4,48) :: G1
  complex(REALKIND), dimension(4,15,4,96) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,44,32))
    allocate(G4tensorhel(70,12,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2),gH)
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,51),MT,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,2),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,8),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,5),wf(:,33),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,5),wf(:,35),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,36),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,5),wf(:,38),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,28),MT,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,60),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,60),MT,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,14),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,23),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,51),MT,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,2),G2(:,:,:,18))
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,26),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,51),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,2),G2(:,:,:,20))
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,11))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3),gH)
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,3),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,51),MT,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,2),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,10),wf(:,5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,60),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,1),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,48),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,8),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,25),wf(:,33),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,25),wf(:,35),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G2(:,:,:,25),wf(:,36),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,25),wf(:,38),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,10),wf(:,2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,28),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,60),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,10),wf(:,11),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,1),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,10),wf(:,14),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,1),G2(:,:,:,36))
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,10),wf(:,23),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,51),MT,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,2),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,10),wf(:,26),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,51),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,2),G2(:,:,:,40))
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,22))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4),gH)
  call loop_Q_A(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,3),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,51),MB,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,2),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,19),wf(:,5),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,60),MB,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,1),G2(:,:,:,44))
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),MB,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,48),MB,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,8),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,25))
  call loop_QV_A(G2(:,:,:,45),wf(:,33),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G2(:,:,:,45),wf(:,35),G2(:,:,:,48))
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G2(:,:,:,45),wf(:,36),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,45),wf(:,38),G2(:,:,:,50))
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,19),wf(:,2),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,28),MB,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,60),MB,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,19),wf(:,11),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,60),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,1),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,19),wf(:,14),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,60),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,1),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,19),wf(:,23),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,51),MB,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,2),G2(:,:,:,58))
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MB,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,19),wf(:,26),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,51),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,2),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MB,G3tensor(:,33))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,3),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,51),MB,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,2),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,28),wf(:,5),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,60),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,1),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MB,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,48),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,8),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,65),wf(:,33),G2(:,:,:,67))
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),MB,G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,65),wf(:,35),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,38))
  call loop_AV_Q(G2(:,:,:,65),wf(:,36),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,63),MB,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,65),wf(:,38),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,28),wf(:,2),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,28),MB,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,60),MB,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,28),wf(:,11),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,60),MB,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,1),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,28),wf(:,14),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,60),MB,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,1),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,28),wf(:,23),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,51),MB,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,2),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,28),wf(:,26),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,51),MB,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,2),G2(:,:,:,80))
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,63),MB,G3tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,12),MT,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,44),MT,G2(:,:,:,81))
  call loop_QS_A(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82),gH)
  call loop_Q_A(G2(:,:,:,82),Q(:,60),MT,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_QS_A(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39),gH)
  call loop_Q_A(G1(:,:,:,39),Q(:,28),MT,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,60),MT,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,12),MT,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,44),MT,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,-4),G2(:,:,:,86),gH)
  call loop_A_Q(G2(:,:,:,86),Q(:,60),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_AS_Q(G1(:,:,:,40),wf(:,-4),G1(:,:,:,42),gH)
  call loop_A_Q(G1(:,:,:,42),Q(:,28),MT,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,60),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,12),MB,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,-5),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,44),MB,G2(:,:,:,89))
  call loop_QS_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90),gH)
  call loop_Q_A(G2(:,:,:,90),Q(:,60),MB,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MB,G4tensor(:,9))
  call loop_QS_A(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45),gH)
  call loop_Q_A(G1(:,:,:,45),Q(:,28),MB,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,60),MB,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MB,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MB,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-5),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,44),MB,G2(:,:,:,93))
  call loop_AS_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94),gH)
  call loop_A_Q(G2(:,:,:,94),Q(:,60),MB,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,11))
  call loop_AS_Q(G1(:,:,:,46),wf(:,-4),G1(:,:,:,48),gH)
  call loop_A_Q(G1(:,:,:,48),Q(:,28),MB,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,60),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,5),T4sum(1:70,1))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,7),T4sum(1:70,1))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,7),T4sum(1:70,1))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,9),T4sum(1:70,2))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,9),T4sum(1:70,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,11),T4sum(1:70,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,11),T4sum(1:70,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,12),T4sum(1:70,4))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,12),T4sum(1:70,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,12),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,10),T4sum(1:70,4))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,10),T4sum(1:70,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,10),T4sum(1:70,4))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,3),T4sum(1:70,6))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,3),T4sum(1:70,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,3),T4sum(1:70,6))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,4),T4sum(1:70,6))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,4),T4sum(1:70,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,4),T4sum(1:70,6))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,3))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_uuxddxhg_2_/**/REALKIND
