
module ol_vamp_1_pphjjj2_uuxddxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_uuxddxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_uuxddxhg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_uuxddxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_uuxddxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,5) :: G0
  complex(REALKIND), dimension(4,5,4,24) :: G1
  complex(REALKIND), dimension(4,15,4,48) :: G2
  complex(REALKIND), dimension(4,35,4,12) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,22,32))
    allocate(G4tensorhel(70,6,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2),gH)
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,51),MT,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,2),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,8),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,5),wf(:,33),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,5),wf(:,35),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,36),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,5),wf(:,38),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,28),MT,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,60),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,60),MT,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,14),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,23),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,51),MT,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,2),G2(:,:,:,18))
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,26),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,51),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,2),G2(:,:,:,20))
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,11))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3),gH)
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,3),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,51),MT,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,2),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,10),wf(:,5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,60),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,1),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,48),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,8),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,25),wf(:,33),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,25),wf(:,35),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G2(:,:,:,25),wf(:,36),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,25),wf(:,38),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,10),wf(:,2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,28),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,60),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,10),wf(:,11),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,1),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,10),wf(:,14),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,1),G2(:,:,:,36))
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,10),wf(:,23),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,51),MT,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,2),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,10),wf(:,26),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,51),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,2),G2(:,:,:,40))
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,44),MT,G2(:,:,:,41))
  call loop_QS_A(G2(:,:,:,41),wf(:,-4),G2(:,:,:,42),gH)
  call loop_Q_A(G2(:,:,:,42),Q(:,60),MT,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_QS_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21),gH)
  call loop_Q_A(G1(:,:,:,21),Q(:,28),MT,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,60),MT,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,12),MT,G1(:,:,:,22))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,44),MT,G2(:,:,:,45))
  call loop_AS_Q(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46),gH)
  call loop_A_Q(G2(:,:,:,46),Q(:,60),MT,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_AS_Q(G1(:,:,:,22),wf(:,-4),G1(:,:,:,24),gH)
  call loop_A_Q(G1(:,:,:,24),Q(:,28),MT,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,60),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,2),T4sum(1:70,3))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,2),T4sum(1:70,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(10)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,2),T4sum(1:70,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(14)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(17)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/12._/**/REALKIND * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(29)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,3))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_uuxddxhg_1_/**/REALKIND
