
module ol_vamp_1_pphjjj2_ddxhggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_ddxhggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_ddxhggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_ddxhggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_ddxhggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,38) :: G0
  complex(REALKIND), dimension(4,5,4,328) :: G1
  complex(REALKIND), dimension(4,15,4,654) :: G2
  complex(REALKIND), dimension(4,35,4,324) :: G3
  complex(REALKIND), dimension(4,70,4,96) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,201,32))
    allocate(G4tensorhel(70,114,32))
    allocate(G5tensorhel(126,48,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,15),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,59),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,16),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,59),MT,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,59),MT,G2(:,:,:,5))
  call loop_AS_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,98),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,59),MT,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,12),MT,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,27),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,28),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,44),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,60),MT,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,1),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,102),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,59),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,24),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,27),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,59),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,40),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,24),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,59),MT,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,3))
  call loop_AS_Q(G2(:,:,:,17),wf(:,-2),G2(:,:,:,19),gH)
  call loop_A_Q(G2(:,:,:,19),Q(:,44),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,69),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,59),MT,G3(:,:,:,13))
  call loop_AS_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,17),wf(:,71),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,59),MT,G3(:,:,:,15))
  call loop_AS_Q(G3(:,:,:,15),wf(:,-2),G3(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,104),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,59),MT,G2(:,:,:,22))
  call loop_AS_Q(G2(:,:,:,22),wf(:,-2),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,19),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,43),MT,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-4),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,59),MT,G3(:,:,:,17))
  call loop_AS_Q(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,24),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,19),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,59),MT,G3(:,:,:,19))
  call loop_AS_Q(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,7))
  call loop_AS_Q(G2(:,:,:,26),wf(:,-2),G2(:,:,:,28),gH)
  call loop_A_Q(G2(:,:,:,28),Q(:,28),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-5),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,1),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G2(:,:,:,26),wf(:,73),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,59),MT,G3(:,:,:,23))
  call loop_AS_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,26),wf(:,74),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,59),MT,G3(:,:,:,25))
  call loop_AS_Q(G3(:,:,:,25),wf(:,-2),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,83),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,59),MT,G2(:,:,:,31))
  call loop_AS_Q(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,118),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,59),MT,G2(:,:,:,33))
  call loop_AS_Q(G2(:,:,:,33),wf(:,-2),G2(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,69),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,27),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,59),MT,G3(:,:,:,27))
  call loop_AS_Q(G3(:,:,:,27),wf(:,-2),G3(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,122),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,59),MT,G2(:,:,:,37))
  call loop_AS_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,87),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,59),MT,G2(:,:,:,39))
  call loop_AS_Q(G2(:,:,:,39),wf(:,-2),G2(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,124),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,59),MT,G2(:,:,:,41))
  call loop_AS_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,71),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,27),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,59),MT,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,128),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),MT,G2(:,:,:,45))
  call loop_AS_Q(G2(:,:,:,45),wf(:,-2),G2(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,133),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,59),MT,G2(:,:,:,47))
  call loop_AS_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,73),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,43),MT,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,59),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,-2),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,137),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),MT,G2(:,:,:,51))
  call loop_AS_Q(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,139),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),MT,G2(:,:,:,53))
  call loop_AS_Q(G2(:,:,:,53),wf(:,-2),G2(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,74),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,43),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-4),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,59),MT,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,-2),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,143),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,59),MT,G2(:,:,:,57))
  call loop_AS_Q(G2(:,:,:,57),wf(:,-2),G2(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,147),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),MT,G2(:,:,:,59))
  call loop_AS_Q(G2(:,:,:,59),wf(:,-2),G2(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,149),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,59),MT,G2(:,:,:,61))
  call loop_AS_Q(G2(:,:,:,61),wf(:,-2),G2(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,8),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,15),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,59),MT,G2(:,:,:,63))
  call loop_QS_A(G2(:,:,:,63),wf(:,-2),G2(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,29),wf(:,16),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,59),MT,G2(:,:,:,65))
  call loop_QS_A(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,29),wf(:,17),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,59),MT,G2(:,:,:,67))
  call loop_QS_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,29),wf(:,98),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,59),MT,G2(:,:,:,69))
  call loop_QS_A(G2(:,:,:,69),wf(:,-2),G2(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,22))
  call loop_QS_A(G1(:,:,:,29),wf(:,-2),G1(:,:,:,34),gH)
  call loop_Q_A(G1(:,:,:,34),Q(:,12),MT,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,27),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,60),MT,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,71),wf(:,-4),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,28),MT,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,60),MT,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,71),wf(:,-5),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,44),MT,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,60),MT,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,1),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,6))
  call loop_QV_A(G1(:,:,:,29),wf(:,102),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,59),MT,G2(:,:,:,75))
  call loop_QS_A(G2(:,:,:,75),wf(:,-2),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,29),wf(:,24),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,27),MT,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-5),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,59),MT,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,40),MT,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,24),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,59),MT,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,16))
  call loop_QS_A(G2(:,:,:,79),wf(:,-2),G2(:,:,:,81),gH)
  call loop_Q_A(G2(:,:,:,81),Q(:,44),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,60),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,1),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,79),wf(:,69),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,59),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,79),wf(:,71),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,59),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,-2),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G1(:,:,:,29),wf(:,104),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,59),MT,G2(:,:,:,84))
  call loop_QS_A(G2(:,:,:,84),wf(:,-2),G2(:,:,:,85),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,29),wf(:,19),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,43),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,59),MT,G3(:,:,:,51))
  call loop_QS_A(G3(:,:,:,51),wf(:,-2),G3(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,24),MT,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,19),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,59),MT,G3(:,:,:,53))
  call loop_QS_A(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,20))
  call loop_QS_A(G2(:,:,:,88),wf(:,-2),G2(:,:,:,90),gH)
  call loop_Q_A(G2(:,:,:,90),Q(:,28),MT,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-5),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,60),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,1),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,88),wf(:,73),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,59),MT,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,-2),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G2(:,:,:,88),wf(:,74),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,59),MT,G3(:,:,:,59))
  call loop_QS_A(G3(:,:,:,59),wf(:,-2),G3(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,29),wf(:,83),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,59),MT,G2(:,:,:,93))
  call loop_QS_A(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,29),wf(:,118),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,59),MT,G2(:,:,:,95))
  call loop_QS_A(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,29),wf(:,69),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,27),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,59),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,29),wf(:,122),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,59),MT,G2(:,:,:,99))
  call loop_QS_A(G2(:,:,:,99),wf(:,-2),G2(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,29),wf(:,87),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,59),MT,G2(:,:,:,101))
  call loop_QS_A(G2(:,:,:,101),wf(:,-2),G2(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,29),wf(:,124),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,59),MT,G2(:,:,:,103))
  call loop_QS_A(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,71),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,27),MT,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,59),MT,G3(:,:,:,63))
  call loop_QS_A(G3(:,:,:,63),wf(:,-2),G3(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,29),wf(:,128),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,59),MT,G2(:,:,:,107))
  call loop_QS_A(G2(:,:,:,107),wf(:,-2),G2(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,29),wf(:,133),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,59),MT,G2(:,:,:,109))
  call loop_QS_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,29),wf(:,73),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,43),MT,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,59),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,29),wf(:,137),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,59),MT,G2(:,:,:,113))
  call loop_QS_A(G2(:,:,:,113),wf(:,-2),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,29),wf(:,139),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,59),MT,G2(:,:,:,115))
  call loop_QS_A(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,29),wf(:,74),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,43),MT,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,59),MT,G3(:,:,:,67))
  call loop_QS_A(G3(:,:,:,67),wf(:,-2),G3(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,29),wf(:,143),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),MT,G2(:,:,:,119))
  call loop_QS_A(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,29),wf(:,147),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,59),MT,G2(:,:,:,121))
  call loop_QS_A(G2(:,:,:,121),wf(:,-2),G2(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,122),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,29),wf(:,149),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,59),MT,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,8),MB,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,15),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,59),MB,G2(:,:,:,125))
  call loop_AS_Q(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MB,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,57),wf(:,16),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,59),MB,G2(:,:,:,127))
  call loop_AS_Q(G2(:,:,:,127),wf(:,-2),G2(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,63),MB,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,57),wf(:,17),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),MB,G2(:,:,:,129))
  call loop_AS_Q(G2(:,:,:,129),wf(:,-2),G2(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MB,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,57),wf(:,98),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,59),MB,G2(:,:,:,131))
  call loop_AS_Q(G2(:,:,:,131),wf(:,-2),G2(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),MB,G3tensor(:,40))
  call loop_AS_Q(G1(:,:,:,57),wf(:,-2),G1(:,:,:,62),gH)
  call loop_A_Q(G1(:,:,:,62),Q(:,12),MB,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,27),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,60),MB,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,1),G3(:,:,:,70))
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),MB,G4tensor(:,27))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,28),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,60),MB,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,1),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,44),MB,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-4),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,60),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,1),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,57),wf(:,102),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,59),MB,G2(:,:,:,137))
  call loop_AS_Q(G2(:,:,:,137),wf(:,-2),G2(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,57),wf(:,24),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,27),MB,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-5),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,59),MB,G3(:,:,:,75))
  call loop_AS_Q(G3(:,:,:,75),wf(:,-2),G3(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MB,G4tensor(:,28))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-5),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,40),MB,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,24),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,59),MB,G3(:,:,:,77))
  call loop_AS_Q(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,63),MB,G4tensor(:,29))
  call loop_AS_Q(G2(:,:,:,141),wf(:,-2),G2(:,:,:,143),gH)
  call loop_A_Q(G2(:,:,:,143),Q(:,44),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,60),MB,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,141),wf(:,69),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,59),MB,G3(:,:,:,81))
  call loop_AS_Q(G3(:,:,:,81),wf(:,-2),G3(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,141),wf(:,71),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,59),MB,G3(:,:,:,83))
  call loop_AS_Q(G3(:,:,:,83),wf(:,-2),G3(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,57),wf(:,104),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,59),MB,G2(:,:,:,146))
  call loop_AS_Q(G2(:,:,:,146),wf(:,-2),G2(:,:,:,147),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,147),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,57),wf(:,19),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,43),MB,G2(:,:,:,148))
  call loop_AV_Q(G2(:,:,:,148),wf(:,-4),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,59),MB,G3(:,:,:,85))
  call loop_AS_Q(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),MB,G4tensor(:,32))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-4),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,24),MB,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,19),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,59),MB,G3(:,:,:,87))
  call loop_AS_Q(G3(:,:,:,87),wf(:,-2),G3(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,33))
  call loop_AS_Q(G2(:,:,:,150),wf(:,-2),G2(:,:,:,152),gH)
  call loop_A_Q(G2(:,:,:,152),Q(:,28),MB,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,60),MB,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,1),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,150),wf(:,73),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,59),MB,G3(:,:,:,91))
  call loop_AS_Q(G3(:,:,:,91),wf(:,-2),G3(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,63),MB,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,150),wf(:,74),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,59),MB,G3(:,:,:,93))
  call loop_AS_Q(G3(:,:,:,93),wf(:,-2),G3(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),MB,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,57),wf(:,83),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,59),MB,G2(:,:,:,155))
  call loop_AS_Q(G2(:,:,:,155),wf(:,-2),G2(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,57),wf(:,118),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,59),MB,G2(:,:,:,157))
  call loop_AS_Q(G2(:,:,:,157),wf(:,-2),G2(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MB,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,57),wf(:,69),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,27),MB,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,59),MB,G3(:,:,:,95))
  call loop_AS_Q(G3(:,:,:,95),wf(:,-2),G3(:,:,:,96),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),MB,G4tensor(:,36))
  call loop_AV_Q(G1(:,:,:,57),wf(:,122),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,59),MB,G2(:,:,:,161))
  call loop_AS_Q(G2(:,:,:,161),wf(:,-2),G2(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),MB,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,57),wf(:,87),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,59),MB,G2(:,:,:,163))
  call loop_AS_Q(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,57),wf(:,124),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,59),MB,G2(:,:,:,165))
  call loop_AS_Q(G2(:,:,:,165),wf(:,-2),G2(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,166),Q(:,63),MB,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,57),wf(:,71),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,27),MB,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,59),MB,G3(:,:,:,97))
  call loop_AS_Q(G3(:,:,:,97),wf(:,-2),G3(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,63),MB,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,57),wf(:,128),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),MB,G2(:,:,:,169))
  call loop_AS_Q(G2(:,:,:,169),wf(:,-2),G2(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,170),Q(:,63),MB,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,57),wf(:,133),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,59),MB,G2(:,:,:,171))
  call loop_AS_Q(G2(:,:,:,171),wf(:,-2),G2(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,63),MB,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,57),wf(:,73),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,43),MB,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-4),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,59),MB,G3(:,:,:,99))
  call loop_AS_Q(G3(:,:,:,99),wf(:,-2),G3(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,63),MB,G4tensor(:,38))
  call loop_AV_Q(G1(:,:,:,57),wf(:,137),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,59),MB,G2(:,:,:,175))
  call loop_AS_Q(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,63),MB,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,57),wf(:,139),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,59),MB,G2(:,:,:,177))
  call loop_AS_Q(G2(:,:,:,177),wf(:,-2),G2(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,63),MB,G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,57),wf(:,74),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,43),MB,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-4),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,59),MB,G3(:,:,:,101))
  call loop_AS_Q(G3(:,:,:,101),wf(:,-2),G3(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),MB,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,57),wf(:,143),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,59),MB,G2(:,:,:,181))
  call loop_AS_Q(G2(:,:,:,181),wf(:,-2),G2(:,:,:,182),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,63),MB,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,57),wf(:,147),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,59),MB,G2(:,:,:,183))
  call loop_AS_Q(G2(:,:,:,183),wf(:,-2),G2(:,:,:,184),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,63),MB,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,57),wf(:,149),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,59),MB,G2(:,:,:,185))
  call loop_AS_Q(G2(:,:,:,185),wf(:,-2),G2(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,8),MB,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,15),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,59),MB,G2(:,:,:,187))
  call loop_QS_A(G2(:,:,:,187),wf(:,-2),G2(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,188),Q(:,63),MB,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,85),wf(:,16),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,59),MB,G2(:,:,:,189))
  call loop_QS_A(G2(:,:,:,189),wf(:,-2),G2(:,:,:,190),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,190),Q(:,63),MB,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,85),wf(:,17),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,59),MB,G2(:,:,:,191))
  call loop_QS_A(G2(:,:,:,191),wf(:,-2),G2(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),MB,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,85),wf(:,98),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,59),MB,G2(:,:,:,193))
  call loop_QS_A(G2(:,:,:,193),wf(:,-2),G2(:,:,:,194),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,63),MB,G3tensor(:,58))
  call loop_QS_A(G1(:,:,:,85),wf(:,-2),G1(:,:,:,90),gH)
  call loop_Q_A(G1(:,:,:,90),Q(:,12),MB,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,27),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,60),MB,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,1),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,63),MB,G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,195),wf(:,-4),G2(:,:,:,197))
  call loop_Q_A(G2(:,:,:,197),Q(:,28),MB,G3(:,:,:,105))
  call loop_QV_A(G3(:,:,:,105),wf(:,-5),G3(:,:,:,106))
  call loop_Q_A(G3(:,:,:,106),Q(:,60),MB,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MB,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,195),wf(:,-5),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,44),MB,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,60),MB,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,1),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,85),wf(:,102),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,59),MB,G2(:,:,:,199))
  call loop_QS_A(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MB,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,85),wf(:,24),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,27),MB,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-5),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,59),MB,G3(:,:,:,109))
  call loop_QS_A(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MB,G4tensor(:,41))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,40),MB,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,24),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,59),MB,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,-2),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,42))
  call loop_QS_A(G2(:,:,:,203),wf(:,-2),G2(:,:,:,205),gH)
  call loop_Q_A(G2(:,:,:,205),Q(:,44),MB,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-4),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,60),MB,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,1),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),MB,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,203),wf(:,69),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,59),MB,G3(:,:,:,115))
  call loop_QS_A(G3(:,:,:,115),wf(:,-2),G3(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,63),MB,G4tensor(:,43))
  call loop_QV_A(G2(:,:,:,203),wf(:,71),G2(:,:,:,207))
  call loop_Q_A(G2(:,:,:,207),Q(:,59),MB,G3(:,:,:,117))
  call loop_QS_A(G3(:,:,:,117),wf(:,-2),G3(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,63),MB,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,85),wf(:,104),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,59),MB,G2(:,:,:,208))
  call loop_QS_A(G2(:,:,:,208),wf(:,-2),G2(:,:,:,209),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,85),wf(:,19),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,43),MB,G2(:,:,:,210))
  call loop_QV_A(G2(:,:,:,210),wf(:,-4),G2(:,:,:,211))
  call loop_Q_A(G2(:,:,:,211),Q(:,59),MB,G3(:,:,:,119))
  call loop_QS_A(G3(:,:,:,119),wf(:,-2),G3(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MB,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,24),MB,G2(:,:,:,212))
  call loop_QV_A(G2(:,:,:,212),wf(:,19),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,59),MB,G3(:,:,:,121))
  call loop_QS_A(G3(:,:,:,121),wf(:,-2),G3(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,63),MB,G4tensor(:,46))
  call loop_QS_A(G2(:,:,:,212),wf(:,-2),G2(:,:,:,214),gH)
  call loop_Q_A(G2(:,:,:,214),Q(:,28),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-5),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,60),MB,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,16))
  call loop_QV_A(G2(:,:,:,212),wf(:,73),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,59),MB,G3(:,:,:,125))
  call loop_QS_A(G3(:,:,:,125),wf(:,-2),G3(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,63),MB,G4tensor(:,47))
  call loop_QV_A(G2(:,:,:,212),wf(:,74),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,59),MB,G3(:,:,:,127))
  call loop_QS_A(G3(:,:,:,127),wf(:,-2),G3(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,63),MB,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,85),wf(:,83),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,59),MB,G2(:,:,:,217))
  call loop_QS_A(G2(:,:,:,217),wf(:,-2),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MB,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,85),wf(:,118),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,59),MB,G2(:,:,:,219))
  call loop_QS_A(G2(:,:,:,219),wf(:,-2),G2(:,:,:,220),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,85),wf(:,69),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,27),MB,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,-5),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,59),MB,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,-2),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,63),MB,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,85),wf(:,122),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,59),MB,G2(:,:,:,223))
  call loop_QS_A(G2(:,:,:,223),wf(:,-2),G2(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,224),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,85),wf(:,87),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,59),MB,G2(:,:,:,225))
  call loop_QS_A(G2(:,:,:,225),wf(:,-2),G2(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,63),MB,G3tensor(:,64))
  call loop_QV_A(G1(:,:,:,85),wf(:,124),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,59),MB,G2(:,:,:,227))
  call loop_QS_A(G2(:,:,:,227),wf(:,-2),G2(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,228),Q(:,63),MB,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,85),wf(:,71),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,27),MB,G2(:,:,:,229))
  call loop_QV_A(G2(:,:,:,229),wf(:,-5),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,59),MB,G3(:,:,:,131))
  call loop_QS_A(G3(:,:,:,131),wf(:,-2),G3(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,63),MB,G4tensor(:,50))
  call loop_QV_A(G1(:,:,:,85),wf(:,128),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,59),MB,G2(:,:,:,231))
  call loop_QS_A(G2(:,:,:,231),wf(:,-2),G2(:,:,:,232),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,232),Q(:,63),MB,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,85),wf(:,133),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,59),MB,G2(:,:,:,233))
  call loop_QS_A(G2(:,:,:,233),wf(:,-2),G2(:,:,:,234),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,234),Q(:,63),MB,G3tensor(:,67))
  call loop_QV_A(G1(:,:,:,85),wf(:,73),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,43),MB,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,-4),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,59),MB,G3(:,:,:,133))
  call loop_QS_A(G3(:,:,:,133),wf(:,-2),G3(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,63),MB,G4tensor(:,51))
  call loop_QV_A(G1(:,:,:,85),wf(:,137),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,59),MB,G2(:,:,:,237))
  call loop_QS_A(G2(:,:,:,237),wf(:,-2),G2(:,:,:,238),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,238),Q(:,63),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,85),wf(:,139),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,59),MB,G2(:,:,:,239))
  call loop_QS_A(G2(:,:,:,239),wf(:,-2),G2(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,63),MB,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,85),wf(:,74),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,43),MB,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-4),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,59),MB,G3(:,:,:,135))
  call loop_QS_A(G3(:,:,:,135),wf(:,-2),G3(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,63),MB,G4tensor(:,52))
  call loop_QV_A(G1(:,:,:,85),wf(:,143),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,59),MB,G2(:,:,:,243))
  call loop_QS_A(G2(:,:,:,243),wf(:,-2),G2(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MB,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,85),wf(:,147),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,59),MB,G2(:,:,:,245))
  call loop_QS_A(G2(:,:,:,245),wf(:,-2),G2(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,63),MB,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,85),wf(:,149),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,59),MB,G2(:,:,:,247))
  call loop_QS_A(G2(:,:,:,247),wf(:,-2),G2(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MB,G3tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),MT,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,11),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,59),MT,G2(:,:,:,249))
  call loop_AS_Q(G2(:,:,:,249),wf(:,-2),G2(:,:,:,250),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,113),wf(:,12),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,59),MT,G2(:,:,:,251))
  call loop_AS_Q(G2(:,:,:,251),wf(:,-2),G2(:,:,:,252),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),MT,G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,113),wf(:,13),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,59),MT,G2(:,:,:,253))
  call loop_AS_Q(G2(:,:,:,253),wf(:,-2),G2(:,:,:,254),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G1(:,:,:,113),wf(:,97),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,59),MT,G2(:,:,:,255))
  call loop_AS_Q(G2(:,:,:,255),wf(:,-2),G2(:,:,:,256),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,76))
  call loop_AS_Q(G1(:,:,:,113),wf(:,-2),G1(:,:,:,118),gH)
  call loop_A_Q(G1(:,:,:,118),Q(:,20),MT,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,23),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,60),MT,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,1),G3(:,:,:,138))
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,53))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-3),G2(:,:,:,259))
  call loop_A_Q(G2(:,:,:,259),Q(:,28),MT,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-5),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,60),MT,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,1),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,17))
  call loop_AV_Q(G1(:,:,:,113),wf(:,100),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,59),MT,G2(:,:,:,260))
  call loop_AS_Q(G2(:,:,:,260),wf(:,-2),G2(:,:,:,261),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,261),Q(:,63),MT,G3tensor(:,77))
  call loop_AV_Q(G1(:,:,:,113),wf(:,28),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,27),MT,G2(:,:,:,262))
  call loop_AV_Q(G2(:,:,:,262),wf(:,-5),G2(:,:,:,263))
  call loop_A_Q(G2(:,:,:,263),Q(:,59),MT,G3(:,:,:,141))
  call loop_AS_Q(G3(:,:,:,141),wf(:,-2),G3(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,63),MT,G4tensor(:,54))
  call loop_AV_Q(G1(:,:,:,113),wf(:,103),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,59),MT,G2(:,:,:,264))
  call loop_AS_Q(G2(:,:,:,264),wf(:,-2),G2(:,:,:,265),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,265),Q(:,63),MT,G3tensor(:,78))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-3),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,24),MT,G2(:,:,:,266))
  call loop_AV_Q(G2(:,:,:,266),wf(:,19),G2(:,:,:,267))
  call loop_A_Q(G2(:,:,:,267),Q(:,59),MT,G3(:,:,:,143))
  call loop_AS_Q(G3(:,:,:,143),wf(:,-2),G3(:,:,:,144),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,144),Q(:,63),MT,G4tensor(:,55))
  call loop_AS_Q(G2(:,:,:,266),wf(:,-2),G2(:,:,:,268),gH)
  call loop_A_Q(G2(:,:,:,268),Q(:,28),MT,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,-5),G3(:,:,:,146))
  call loop_A_Q(G3(:,:,:,146),Q(:,60),MT,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,1),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,18))
  call loop_AV_Q(G2(:,:,:,266),wf(:,73),G2(:,:,:,269))
  call loop_A_Q(G2(:,:,:,269),Q(:,59),MT,G3(:,:,:,147))
  call loop_AS_Q(G3(:,:,:,147),wf(:,-2),G3(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,266),wf(:,74),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,59),MT,G3(:,:,:,149))
  call loop_AS_Q(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,113),wf(:,50),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,59),MT,G2(:,:,:,271))
  call loop_AS_Q(G2(:,:,:,271),wf(:,-2),G2(:,:,:,272),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,272),Q(:,63),MT,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,113),wf(:,106),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,59),MT,G2(:,:,:,273))
  call loop_AS_Q(G2(:,:,:,273),wf(:,-2),G2(:,:,:,274),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,274),Q(:,63),MT,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,113),wf(:,44),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,27),MT,G2(:,:,:,275))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-5),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,59),MT,G3(:,:,:,151))
  call loop_AS_Q(G3(:,:,:,151),wf(:,-2),G3(:,:,:,152),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,63),MT,G4tensor(:,58))
  call loop_AV_Q(G1(:,:,:,113),wf(:,110),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,59),MT,G2(:,:,:,277))
  call loop_AS_Q(G2(:,:,:,277),wf(:,-2),G2(:,:,:,278),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,278),Q(:,63),MT,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,113),wf(:,65),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,59),MT,G2(:,:,:,279))
  call loop_AS_Q(G2(:,:,:,279),wf(:,-2),G2(:,:,:,280),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,280),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,113),wf(:,112),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,59),MT,G2(:,:,:,281))
  call loop_AS_Q(G2(:,:,:,281),wf(:,-2),G2(:,:,:,282),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,63),MT,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,113),wf(:,59),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,27),MT,G2(:,:,:,283))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-5),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,59),MT,G3(:,:,:,153))
  call loop_AS_Q(G3(:,:,:,153),wf(:,-2),G3(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,63),MT,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,113),wf(:,116),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,59),MT,G2(:,:,:,285))
  call loop_AS_Q(G2(:,:,:,285),wf(:,-2),G2(:,:,:,286),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,63),MT,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,113),wf(:,132),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,59),MT,G2(:,:,:,287))
  call loop_AS_Q(G2(:,:,:,287),wf(:,-2),G2(:,:,:,288),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,113),wf(:,135),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,59),MT,G2(:,:,:,289))
  call loop_AS_Q(G2(:,:,:,289),wf(:,-2),G2(:,:,:,290),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,113),wf(:,138),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,59),MT,G2(:,:,:,291))
  call loop_AS_Q(G2(:,:,:,291),wf(:,-2),G2(:,:,:,292),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,113),wf(:,141),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,59),MT,G2(:,:,:,293))
  call loop_AS_Q(G2(:,:,:,293),wf(:,-2),G2(:,:,:,294),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,113),wf(:,144),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,59),MT,G2(:,:,:,295))
  call loop_AS_Q(G2(:,:,:,295),wf(:,-2),G2(:,:,:,296),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),MT,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,113),wf(:,146),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,59),MT,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,-2),G2(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),MT,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,11),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,59),MT,G2(:,:,:,299))
  call loop_QS_A(G2(:,:,:,299),wf(:,-2),G2(:,:,:,300),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,63),MT,G3tensor(:,91))
  call loop_QV_A(G1(:,:,:,137),wf(:,12),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,59),MT,G2(:,:,:,301))
  call loop_QS_A(G2(:,:,:,301),wf(:,-2),G2(:,:,:,302),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,302),Q(:,63),MT,G3tensor(:,92))
  call loop_QV_A(G1(:,:,:,137),wf(:,13),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,59),MT,G2(:,:,:,303))
  call loop_QS_A(G2(:,:,:,303),wf(:,-2),G2(:,:,:,304),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,304),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G1(:,:,:,137),wf(:,97),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,59),MT,G2(:,:,:,305))
  call loop_QS_A(G2(:,:,:,305),wf(:,-2),G2(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,63),MT,G3tensor(:,94))
  call loop_QS_A(G1(:,:,:,137),wf(:,-2),G1(:,:,:,142),gH)
  call loop_Q_A(G1(:,:,:,142),Q(:,20),MT,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,23),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,60),MT,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,1),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),MT,G4tensor(:,60))
  call loop_QV_A(G2(:,:,:,307),wf(:,-3),G2(:,:,:,309))
  call loop_Q_A(G2(:,:,:,309),Q(:,28),MT,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,-5),G3(:,:,:,158))
  call loop_Q_A(G3(:,:,:,158),Q(:,60),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,1),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G1(:,:,:,137),wf(:,100),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,59),MT,G2(:,:,:,310))
  call loop_QS_A(G2(:,:,:,310),wf(:,-2),G2(:,:,:,311),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,311),Q(:,63),MT,G3tensor(:,95))
  call loop_QV_A(G1(:,:,:,137),wf(:,28),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,27),MT,G2(:,:,:,312))
  call loop_QV_A(G2(:,:,:,312),wf(:,-5),G2(:,:,:,313))
  call loop_Q_A(G2(:,:,:,313),Q(:,59),MT,G3(:,:,:,159))
  call loop_QS_A(G3(:,:,:,159),wf(:,-2),G3(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,63),MT,G4tensor(:,61))
  call loop_QV_A(G1(:,:,:,137),wf(:,103),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,59),MT,G2(:,:,:,314))
  call loop_QS_A(G2(:,:,:,314),wf(:,-2),G2(:,:,:,315),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,315),Q(:,63),MT,G3tensor(:,96))
  call loop_QV_A(G1(:,:,:,137),wf(:,-3),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,24),MT,G2(:,:,:,316))
  call loop_QV_A(G2(:,:,:,316),wf(:,19),G2(:,:,:,317))
  call loop_Q_A(G2(:,:,:,317),Q(:,59),MT,G3(:,:,:,161))
  call loop_QS_A(G3(:,:,:,161),wf(:,-2),G3(:,:,:,162),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,63),MT,G4tensor(:,62))
  call loop_QS_A(G2(:,:,:,316),wf(:,-2),G2(:,:,:,318),gH)
  call loop_Q_A(G2(:,:,:,318),Q(:,28),MT,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,-5),G3(:,:,:,164))
  call loop_Q_A(G3(:,:,:,164),Q(:,60),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,1),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G2(:,:,:,316),wf(:,73),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,59),MT,G3(:,:,:,165))
  call loop_QS_A(G3(:,:,:,165),wf(:,-2),G3(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,316),wf(:,74),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,59),MT,G3(:,:,:,167))
  call loop_QS_A(G3(:,:,:,167),wf(:,-2),G3(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G1(:,:,:,137),wf(:,50),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,59),MT,G2(:,:,:,321))
  call loop_QS_A(G2(:,:,:,321),wf(:,-2),G2(:,:,:,322),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,322),Q(:,63),MT,G3tensor(:,97))
  call loop_QV_A(G1(:,:,:,137),wf(:,106),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,59),MT,G2(:,:,:,323))
  call loop_QS_A(G2(:,:,:,323),wf(:,-2),G2(:,:,:,324),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,324),Q(:,63),MT,G3tensor(:,98))
  call loop_QV_A(G1(:,:,:,137),wf(:,44),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,27),MT,G2(:,:,:,325))
  call loop_QV_A(G2(:,:,:,325),wf(:,-5),G2(:,:,:,326))
  call loop_Q_A(G2(:,:,:,326),Q(:,59),MT,G3(:,:,:,169))
  call loop_QS_A(G3(:,:,:,169),wf(:,-2),G3(:,:,:,170),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,137),wf(:,110),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,59),MT,G2(:,:,:,327))
  call loop_QS_A(G2(:,:,:,327),wf(:,-2),G2(:,:,:,328),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,328),Q(:,63),MT,G3tensor(:,99))
  call loop_QV_A(G1(:,:,:,137),wf(:,65),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,59),MT,G2(:,:,:,329))
  call loop_QS_A(G2(:,:,:,329),wf(:,-2),G2(:,:,:,330),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,330),Q(:,63),MT,G3tensor(:,100))
  call loop_QV_A(G1(:,:,:,137),wf(:,112),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,59),MT,G2(:,:,:,331))
  call loop_QS_A(G2(:,:,:,331),wf(:,-2),G2(:,:,:,332),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,332),Q(:,63),MT,G3tensor(:,101))
  call loop_QV_A(G1(:,:,:,137),wf(:,59),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,27),MT,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,-5),G2(:,:,:,334))
  call loop_Q_A(G2(:,:,:,334),Q(:,59),MT,G3(:,:,:,171))
  call loop_QS_A(G3(:,:,:,171),wf(:,-2),G3(:,:,:,172),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,66))
  call loop_QV_A(G1(:,:,:,137),wf(:,116),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,59),MT,G2(:,:,:,335))
  call loop_QS_A(G2(:,:,:,335),wf(:,-2),G2(:,:,:,336),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,336),Q(:,63),MT,G3tensor(:,102))
  call loop_QV_A(G1(:,:,:,137),wf(:,132),G1(:,:,:,155))
  call loop_Q_A(G1(:,:,:,155),Q(:,59),MT,G2(:,:,:,337))
  call loop_QS_A(G2(:,:,:,337),wf(:,-2),G2(:,:,:,338),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),MT,G3tensor(:,103))
  call loop_QV_A(G1(:,:,:,137),wf(:,135),G1(:,:,:,156))
  call loop_Q_A(G1(:,:,:,156),Q(:,59),MT,G2(:,:,:,339))
  call loop_QS_A(G2(:,:,:,339),wf(:,-2),G2(:,:,:,340),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,63),MT,G3tensor(:,104))
  call loop_QV_A(G1(:,:,:,137),wf(:,138),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,59),MT,G2(:,:,:,341))
  call loop_QS_A(G2(:,:,:,341),wf(:,-2),G2(:,:,:,342),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,63),MT,G3tensor(:,105))
  call loop_QV_A(G1(:,:,:,137),wf(:,141),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,59),MT,G2(:,:,:,343))
  call loop_QS_A(G2(:,:,:,343),wf(:,-2),G2(:,:,:,344),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,344),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G1(:,:,:,137),wf(:,144),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,59),MT,G2(:,:,:,345))
  call loop_QS_A(G2(:,:,:,345),wf(:,-2),G2(:,:,:,346),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,346),Q(:,63),MT,G3tensor(:,107))
  call loop_QV_A(G1(:,:,:,137),wf(:,146),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,59),MT,G2(:,:,:,347))
  call loop_QS_A(G2(:,:,:,347),wf(:,-2),G2(:,:,:,348),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,348),Q(:,63),MT,G3tensor(:,108))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,16),MB,G1(:,:,:,161))
  call loop_AV_Q(G1(:,:,:,161),wf(:,11),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,59),MB,G2(:,:,:,349))
  call loop_AS_Q(G2(:,:,:,349),wf(:,-2),G2(:,:,:,350),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,350),Q(:,63),MB,G3tensor(:,109))
  call loop_AV_Q(G1(:,:,:,161),wf(:,12),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,59),MB,G2(:,:,:,351))
  call loop_AS_Q(G2(:,:,:,351),wf(:,-2),G2(:,:,:,352),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,352),Q(:,63),MB,G3tensor(:,110))
  call loop_AV_Q(G1(:,:,:,161),wf(:,13),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,59),MB,G2(:,:,:,353))
  call loop_AS_Q(G2(:,:,:,353),wf(:,-2),G2(:,:,:,354),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,354),Q(:,63),MB,G3tensor(:,111))
  call loop_AV_Q(G1(:,:,:,161),wf(:,97),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,59),MB,G2(:,:,:,355))
  call loop_AS_Q(G2(:,:,:,355),wf(:,-2),G2(:,:,:,356),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,356),Q(:,63),MB,G3tensor(:,112))
  call loop_AS_Q(G1(:,:,:,161),wf(:,-2),G1(:,:,:,166),gH)
  call loop_A_Q(G1(:,:,:,166),Q(:,20),MB,G2(:,:,:,357))
  call loop_AV_Q(G2(:,:,:,357),wf(:,23),G2(:,:,:,358))
  call loop_A_Q(G2(:,:,:,358),Q(:,60),MB,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,1),G3(:,:,:,174))
  call check_last_A_Q(l_switch,G3(:,:,:,174),Q(:,63),MB,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,357),wf(:,-3),G2(:,:,:,359))
  call loop_A_Q(G2(:,:,:,359),Q(:,28),MB,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,-5),G3(:,:,:,176))
  call loop_A_Q(G3(:,:,:,176),Q(:,60),MB,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,1),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MB,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,161),wf(:,100),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,59),MB,G2(:,:,:,360))
  call loop_AS_Q(G2(:,:,:,360),wf(:,-2),G2(:,:,:,361),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,361),Q(:,63),MB,G3tensor(:,113))
  call loop_AV_Q(G1(:,:,:,161),wf(:,28),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,27),MB,G2(:,:,:,362))
  call loop_AV_Q(G2(:,:,:,362),wf(:,-5),G2(:,:,:,363))
  call loop_A_Q(G2(:,:,:,363),Q(:,59),MB,G3(:,:,:,177))
  call loop_AS_Q(G3(:,:,:,177),wf(:,-2),G3(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,63),MB,G4tensor(:,68))
  call loop_AV_Q(G1(:,:,:,161),wf(:,103),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,59),MB,G2(:,:,:,364))
  call loop_AS_Q(G2(:,:,:,364),wf(:,-2),G2(:,:,:,365),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,365),Q(:,63),MB,G3tensor(:,114))
  call loop_AV_Q(G1(:,:,:,161),wf(:,-3),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,24),MB,G2(:,:,:,366))
  call loop_AV_Q(G2(:,:,:,366),wf(:,19),G2(:,:,:,367))
  call loop_A_Q(G2(:,:,:,367),Q(:,59),MB,G3(:,:,:,179))
  call loop_AS_Q(G3(:,:,:,179),wf(:,-2),G3(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),MB,G4tensor(:,69))
  call loop_AS_Q(G2(:,:,:,366),wf(:,-2),G2(:,:,:,368),gH)
  call loop_A_Q(G2(:,:,:,368),Q(:,28),MB,G3(:,:,:,181))
  call loop_AV_Q(G3(:,:,:,181),wf(:,-5),G3(:,:,:,182))
  call loop_A_Q(G3(:,:,:,182),Q(:,60),MB,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,1),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MB,G5tensor(:,22))
  call loop_AV_Q(G2(:,:,:,366),wf(:,73),G2(:,:,:,369))
  call loop_A_Q(G2(:,:,:,369),Q(:,59),MB,G3(:,:,:,183))
  call loop_AS_Q(G3(:,:,:,183),wf(:,-2),G3(:,:,:,184),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,184),Q(:,63),MB,G4tensor(:,70))
  call loop_AV_Q(G2(:,:,:,366),wf(:,74),G2(:,:,:,370))
  call loop_A_Q(G2(:,:,:,370),Q(:,59),MB,G3(:,:,:,185))
  call loop_AS_Q(G3(:,:,:,185),wf(:,-2),G3(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,63),MB,G4tensor(:,71))
  call loop_AV_Q(G1(:,:,:,161),wf(:,50),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,59),MB,G2(:,:,:,371))
  call loop_AS_Q(G2(:,:,:,371),wf(:,-2),G2(:,:,:,372),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,372),Q(:,63),MB,G3tensor(:,115))
  call loop_AV_Q(G1(:,:,:,161),wf(:,106),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,59),MB,G2(:,:,:,373))
  call loop_AS_Q(G2(:,:,:,373),wf(:,-2),G2(:,:,:,374),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,374),Q(:,63),MB,G3tensor(:,116))
  call loop_AV_Q(G1(:,:,:,161),wf(:,44),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,27),MB,G2(:,:,:,375))
  call loop_AV_Q(G2(:,:,:,375),wf(:,-5),G2(:,:,:,376))
  call loop_A_Q(G2(:,:,:,376),Q(:,59),MB,G3(:,:,:,187))
  call loop_AS_Q(G3(:,:,:,187),wf(:,-2),G3(:,:,:,188),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,188),Q(:,63),MB,G4tensor(:,72))
  call loop_AV_Q(G1(:,:,:,161),wf(:,110),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,59),MB,G2(:,:,:,377))
  call loop_AS_Q(G2(:,:,:,377),wf(:,-2),G2(:,:,:,378),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,378),Q(:,63),MB,G3tensor(:,117))
  call loop_AV_Q(G1(:,:,:,161),wf(:,65),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,59),MB,G2(:,:,:,379))
  call loop_AS_Q(G2(:,:,:,379),wf(:,-2),G2(:,:,:,380),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,380),Q(:,63),MB,G3tensor(:,118))
  call loop_AV_Q(G1(:,:,:,161),wf(:,112),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,59),MB,G2(:,:,:,381))
  call loop_AS_Q(G2(:,:,:,381),wf(:,-2),G2(:,:,:,382),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,382),Q(:,63),MB,G3tensor(:,119))
  call loop_AV_Q(G1(:,:,:,161),wf(:,59),G1(:,:,:,177))
  call loop_A_Q(G1(:,:,:,177),Q(:,27),MB,G2(:,:,:,383))
  call loop_AV_Q(G2(:,:,:,383),wf(:,-5),G2(:,:,:,384))
  call loop_A_Q(G2(:,:,:,384),Q(:,59),MB,G3(:,:,:,189))
  call loop_AS_Q(G3(:,:,:,189),wf(:,-2),G3(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MB,G4tensor(:,73))
  call loop_AV_Q(G1(:,:,:,161),wf(:,116),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,59),MB,G2(:,:,:,385))
  call loop_AS_Q(G2(:,:,:,385),wf(:,-2),G2(:,:,:,386),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,386),Q(:,63),MB,G3tensor(:,120))
  call loop_AV_Q(G1(:,:,:,161),wf(:,132),G1(:,:,:,179))
  call loop_A_Q(G1(:,:,:,179),Q(:,59),MB,G2(:,:,:,387))
  call loop_AS_Q(G2(:,:,:,387),wf(:,-2),G2(:,:,:,388),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,388),Q(:,63),MB,G3tensor(:,121))
  call loop_AV_Q(G1(:,:,:,161),wf(:,135),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,59),MB,G2(:,:,:,389))
  call loop_AS_Q(G2(:,:,:,389),wf(:,-2),G2(:,:,:,390),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,390),Q(:,63),MB,G3tensor(:,122))
  call loop_AV_Q(G1(:,:,:,161),wf(:,138),G1(:,:,:,181))
  call loop_A_Q(G1(:,:,:,181),Q(:,59),MB,G2(:,:,:,391))
  call loop_AS_Q(G2(:,:,:,391),wf(:,-2),G2(:,:,:,392),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,63),MB,G3tensor(:,123))
  call loop_AV_Q(G1(:,:,:,161),wf(:,141),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,59),MB,G2(:,:,:,393))
  call loop_AS_Q(G2(:,:,:,393),wf(:,-2),G2(:,:,:,394),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,394),Q(:,63),MB,G3tensor(:,124))
  call loop_AV_Q(G1(:,:,:,161),wf(:,144),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,59),MB,G2(:,:,:,395))
  call loop_AS_Q(G2(:,:,:,395),wf(:,-2),G2(:,:,:,396),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,396),Q(:,63),MB,G3tensor(:,125))
  call loop_AV_Q(G1(:,:,:,161),wf(:,146),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,59),MB,G2(:,:,:,397))
  call loop_AS_Q(G2(:,:,:,397),wf(:,-2),G2(:,:,:,398),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,398),Q(:,63),MB,G3tensor(:,126))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,16),MB,G1(:,:,:,185))
  call loop_QV_A(G1(:,:,:,185),wf(:,11),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,59),MB,G2(:,:,:,399))
  call loop_QS_A(G2(:,:,:,399),wf(:,-2),G2(:,:,:,400),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,400),Q(:,63),MB,G3tensor(:,127))
  call loop_QV_A(G1(:,:,:,185),wf(:,12),G1(:,:,:,187))
  call loop_Q_A(G1(:,:,:,187),Q(:,59),MB,G2(:,:,:,401))
  call loop_QS_A(G2(:,:,:,401),wf(:,-2),G2(:,:,:,402),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,402),Q(:,63),MB,G3tensor(:,128))
  call loop_QV_A(G1(:,:,:,185),wf(:,13),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,59),MB,G2(:,:,:,403))
  call loop_QS_A(G2(:,:,:,403),wf(:,-2),G2(:,:,:,404),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,404),Q(:,63),MB,G3tensor(:,129))
  call loop_QV_A(G1(:,:,:,185),wf(:,97),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,59),MB,G2(:,:,:,405))
  call loop_QS_A(G2(:,:,:,405),wf(:,-2),G2(:,:,:,406),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,406),Q(:,63),MB,G3tensor(:,130))
  call loop_QS_A(G1(:,:,:,185),wf(:,-2),G1(:,:,:,190),gH)
  call loop_Q_A(G1(:,:,:,190),Q(:,20),MB,G2(:,:,:,407))
  call loop_QV_A(G2(:,:,:,407),wf(:,23),G2(:,:,:,408))
  call loop_Q_A(G2(:,:,:,408),Q(:,60),MB,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,1),G3(:,:,:,192))
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,63),MB,G4tensor(:,74))
  call loop_QV_A(G2(:,:,:,407),wf(:,-3),G2(:,:,:,409))
  call loop_Q_A(G2(:,:,:,409),Q(:,28),MB,G3(:,:,:,193))
  call loop_QV_A(G3(:,:,:,193),wf(:,-5),G3(:,:,:,194))
  call loop_Q_A(G3(:,:,:,194),Q(:,60),MB,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,1),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,63),MB,G5tensor(:,23))
  call loop_QV_A(G1(:,:,:,185),wf(:,100),G1(:,:,:,191))
  call loop_Q_A(G1(:,:,:,191),Q(:,59),MB,G2(:,:,:,410))
  call loop_QS_A(G2(:,:,:,410),wf(:,-2),G2(:,:,:,411),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,411),Q(:,63),MB,G3tensor(:,131))
  call loop_QV_A(G1(:,:,:,185),wf(:,28),G1(:,:,:,192))
  call loop_Q_A(G1(:,:,:,192),Q(:,27),MB,G2(:,:,:,412))
  call loop_QV_A(G2(:,:,:,412),wf(:,-5),G2(:,:,:,413))
  call loop_Q_A(G2(:,:,:,413),Q(:,59),MB,G3(:,:,:,195))
  call loop_QS_A(G3(:,:,:,195),wf(:,-2),G3(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,63),MB,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,185),wf(:,103),G1(:,:,:,193))
  call loop_Q_A(G1(:,:,:,193),Q(:,59),MB,G2(:,:,:,414))
  call loop_QS_A(G2(:,:,:,414),wf(:,-2),G2(:,:,:,415),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,415),Q(:,63),MB,G3tensor(:,132))
  call loop_QV_A(G1(:,:,:,185),wf(:,-3),G1(:,:,:,194))
  call loop_Q_A(G1(:,:,:,194),Q(:,24),MB,G2(:,:,:,416))
  call loop_QV_A(G2(:,:,:,416),wf(:,19),G2(:,:,:,417))
  call loop_Q_A(G2(:,:,:,417),Q(:,59),MB,G3(:,:,:,197))
  call loop_QS_A(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,63),MB,G4tensor(:,76))
  call loop_QS_A(G2(:,:,:,416),wf(:,-2),G2(:,:,:,418),gH)
  call loop_Q_A(G2(:,:,:,418),Q(:,28),MB,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_Q_A(G3(:,:,:,200),Q(:,60),MB,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,1),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,63),MB,G5tensor(:,24))
  call loop_QV_A(G2(:,:,:,416),wf(:,73),G2(:,:,:,419))
  call loop_Q_A(G2(:,:,:,419),Q(:,59),MB,G3(:,:,:,201))
  call loop_QS_A(G3(:,:,:,201),wf(:,-2),G3(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,63),MB,G4tensor(:,77))
  call loop_QV_A(G2(:,:,:,416),wf(:,74),G2(:,:,:,420))
  call loop_Q_A(G2(:,:,:,420),Q(:,59),MB,G3(:,:,:,203))
  call loop_QS_A(G3(:,:,:,203),wf(:,-2),G3(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,63),MB,G4tensor(:,78))
  call loop_QV_A(G1(:,:,:,185),wf(:,50),G1(:,:,:,195))
  call loop_Q_A(G1(:,:,:,195),Q(:,59),MB,G2(:,:,:,421))
  call loop_QS_A(G2(:,:,:,421),wf(:,-2),G2(:,:,:,422),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,422),Q(:,63),MB,G3tensor(:,133))
  call loop_QV_A(G1(:,:,:,185),wf(:,106),G1(:,:,:,196))
  call loop_Q_A(G1(:,:,:,196),Q(:,59),MB,G2(:,:,:,423))
  call loop_QS_A(G2(:,:,:,423),wf(:,-2),G2(:,:,:,424),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,424),Q(:,63),MB,G3tensor(:,134))
  call loop_QV_A(G1(:,:,:,185),wf(:,44),G1(:,:,:,197))
  call loop_Q_A(G1(:,:,:,197),Q(:,27),MB,G2(:,:,:,425))
  call loop_QV_A(G2(:,:,:,425),wf(:,-5),G2(:,:,:,426))
  call loop_Q_A(G2(:,:,:,426),Q(:,59),MB,G3(:,:,:,205))
  call loop_QS_A(G3(:,:,:,205),wf(:,-2),G3(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,63),MB,G4tensor(:,79))
  call loop_QV_A(G1(:,:,:,185),wf(:,110),G1(:,:,:,198))
  call loop_Q_A(G1(:,:,:,198),Q(:,59),MB,G2(:,:,:,427))
  call loop_QS_A(G2(:,:,:,427),wf(:,-2),G2(:,:,:,428),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,428),Q(:,63),MB,G3tensor(:,135))
  call loop_QV_A(G1(:,:,:,185),wf(:,65),G1(:,:,:,199))
  call loop_Q_A(G1(:,:,:,199),Q(:,59),MB,G2(:,:,:,429))
  call loop_QS_A(G2(:,:,:,429),wf(:,-2),G2(:,:,:,430),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,430),Q(:,63),MB,G3tensor(:,136))
  call loop_QV_A(G1(:,:,:,185),wf(:,112),G1(:,:,:,200))
  call loop_Q_A(G1(:,:,:,200),Q(:,59),MB,G2(:,:,:,431))
  call loop_QS_A(G2(:,:,:,431),wf(:,-2),G2(:,:,:,432),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,432),Q(:,63),MB,G3tensor(:,137))
  call loop_QV_A(G1(:,:,:,185),wf(:,59),G1(:,:,:,201))
  call loop_Q_A(G1(:,:,:,201),Q(:,27),MB,G2(:,:,:,433))
  call loop_QV_A(G2(:,:,:,433),wf(:,-5),G2(:,:,:,434))
  call loop_Q_A(G2(:,:,:,434),Q(:,59),MB,G3(:,:,:,207))
  call loop_QS_A(G3(:,:,:,207),wf(:,-2),G3(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,63),MB,G4tensor(:,80))
  call loop_QV_A(G1(:,:,:,185),wf(:,116),G1(:,:,:,202))
  call loop_Q_A(G1(:,:,:,202),Q(:,59),MB,G2(:,:,:,435))
  call loop_QS_A(G2(:,:,:,435),wf(:,-2),G2(:,:,:,436),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,436),Q(:,63),MB,G3tensor(:,138))
  call loop_QV_A(G1(:,:,:,185),wf(:,132),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,59),MB,G2(:,:,:,437))
  call loop_QS_A(G2(:,:,:,437),wf(:,-2),G2(:,:,:,438),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,438),Q(:,63),MB,G3tensor(:,139))
  call loop_QV_A(G1(:,:,:,185),wf(:,135),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,59),MB,G2(:,:,:,439))
  call loop_QS_A(G2(:,:,:,439),wf(:,-2),G2(:,:,:,440),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,440),Q(:,63),MB,G3tensor(:,140))
  call loop_QV_A(G1(:,:,:,185),wf(:,138),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,59),MB,G2(:,:,:,441))
  call loop_QS_A(G2(:,:,:,441),wf(:,-2),G2(:,:,:,442),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,442),Q(:,63),MB,G3tensor(:,141))
  call loop_QV_A(G1(:,:,:,185),wf(:,141),G1(:,:,:,206))
  call loop_Q_A(G1(:,:,:,206),Q(:,59),MB,G2(:,:,:,443))
  call loop_QS_A(G2(:,:,:,443),wf(:,-2),G2(:,:,:,444),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,444),Q(:,63),MB,G3tensor(:,142))
  call loop_QV_A(G1(:,:,:,185),wf(:,144),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,59),MB,G2(:,:,:,445))
  call loop_QS_A(G2(:,:,:,445),wf(:,-2),G2(:,:,:,446),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,446),Q(:,63),MB,G3tensor(:,143))
  call loop_QV_A(G1(:,:,:,185),wf(:,146),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,59),MB,G2(:,:,:,447))
  call loop_QS_A(G2(:,:,:,447),wf(:,-2),G2(:,:,:,448),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,448),Q(:,63),MB,G3tensor(:,144))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,27),MT,G1(:,:,:,209))
  call loop_QV_A(G1(:,:,:,209),wf(:,-5),G1(:,:,:,210))
  call loop_Q_A(G1(:,:,:,210),Q(:,59),MT,G2(:,:,:,449))
  call loop_QS_A(G2(:,:,:,449),wf(:,-2),G2(:,:,:,450),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,450),Q(:,63),MT,G3tensor(:,145))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,27),MT,G1(:,:,:,211))
  call loop_QV_A(G1(:,:,:,211),wf(:,-5),G1(:,:,:,212))
  call loop_Q_A(G1(:,:,:,212),Q(:,59),MT,G2(:,:,:,451))
  call loop_QS_A(G2(:,:,:,451),wf(:,-2),G2(:,:,:,452),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,452),Q(:,63),MT,G3tensor(:,146))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,27),MT,G1(:,:,:,213))
  call loop_QV_A(G1(:,:,:,213),wf(:,-5),G1(:,:,:,214))
  call loop_Q_A(G1(:,:,:,214),Q(:,59),MT,G2(:,:,:,453))
  call loop_QS_A(G2(:,:,:,453),wf(:,-2),G2(:,:,:,454),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,454),Q(:,63),MT,G3tensor(:,147))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,27),MT,G1(:,:,:,215))
  call loop_AV_Q(G1(:,:,:,215),wf(:,-5),G1(:,:,:,216))
  call loop_A_Q(G1(:,:,:,216),Q(:,59),MT,G2(:,:,:,455))
  call loop_AS_Q(G2(:,:,:,455),wf(:,-2),G2(:,:,:,456),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,456),Q(:,63),MT,G3tensor(:,148))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,27),MT,G1(:,:,:,217))
  call loop_AV_Q(G1(:,:,:,217),wf(:,-5),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,59),MT,G2(:,:,:,457))
  call loop_AS_Q(G2(:,:,:,457),wf(:,-2),G2(:,:,:,458),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,458),Q(:,63),MT,G3tensor(:,149))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,27),MT,G1(:,:,:,219))
  call loop_AV_Q(G1(:,:,:,219),wf(:,-5),G1(:,:,:,220))
  call loop_A_Q(G1(:,:,:,220),Q(:,59),MT,G2(:,:,:,459))
  call loop_AS_Q(G2(:,:,:,459),wf(:,-2),G2(:,:,:,460),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,460),Q(:,63),MT,G3tensor(:,150))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,27),MB,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,-5),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,59),MB,G2(:,:,:,461))
  call loop_QS_A(G2(:,:,:,461),wf(:,-2),G2(:,:,:,462),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,462),Q(:,63),MB,G3tensor(:,151))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,27),MB,G1(:,:,:,223))
  call loop_QV_A(G1(:,:,:,223),wf(:,-5),G1(:,:,:,224))
  call loop_Q_A(G1(:,:,:,224),Q(:,59),MB,G2(:,:,:,463))
  call loop_QS_A(G2(:,:,:,463),wf(:,-2),G2(:,:,:,464),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,464),Q(:,63),MB,G3tensor(:,152))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,27),MB,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,-5),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,59),MB,G2(:,:,:,465))
  call loop_QS_A(G2(:,:,:,465),wf(:,-2),G2(:,:,:,466),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,466),Q(:,63),MB,G3tensor(:,153))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,27),MB,G1(:,:,:,227))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-5),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,59),MB,G2(:,:,:,467))
  call loop_AS_Q(G2(:,:,:,467),wf(:,-2),G2(:,:,:,468),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,468),Q(:,63),MB,G3tensor(:,154))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,27),MB,G1(:,:,:,229))
  call loop_AV_Q(G1(:,:,:,229),wf(:,-5),G1(:,:,:,230))
  call loop_A_Q(G1(:,:,:,230),Q(:,59),MB,G2(:,:,:,469))
  call loop_AS_Q(G2(:,:,:,469),wf(:,-2),G2(:,:,:,470),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,470),Q(:,63),MB,G3tensor(:,155))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,27),MB,G1(:,:,:,231))
  call loop_AV_Q(G1(:,:,:,231),wf(:,-5),G1(:,:,:,232))
  call loop_A_Q(G1(:,:,:,232),Q(:,59),MB,G2(:,:,:,471))
  call loop_AS_Q(G2(:,:,:,471),wf(:,-2),G2(:,:,:,472),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,472),Q(:,63),MB,G3tensor(:,156))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,22),gH)
  call loop_Q_A(G0(:,:,:,22),Q(:,4),MT,G1(:,:,:,233))
  call loop_QV_A(G1(:,:,:,233),wf(:,2),G1(:,:,:,234))
  call loop_Q_A(G1(:,:,:,234),Q(:,60),MT,G2(:,:,:,473))
  call loop_QV_A(G2(:,:,:,473),wf(:,1),G2(:,:,:,474))
  call check_last_Q_A(l_switch,G2(:,:,:,474),Q(:,63),MT,G3tensor(:,157))
  call loop_QV_A(G1(:,:,:,233),wf(:,4),G1(:,:,:,235))
  call loop_Q_A(G1(:,:,:,235),Q(:,60),MT,G2(:,:,:,475))
  call loop_QV_A(G2(:,:,:,475),wf(:,1),G2(:,:,:,476))
  call check_last_Q_A(l_switch,G2(:,:,:,476),Q(:,63),MT,G3tensor(:,158))
  call loop_QV_A(G1(:,:,:,233),wf(:,5),G1(:,:,:,236))
  call loop_Q_A(G1(:,:,:,236),Q(:,60),MT,G2(:,:,:,477))
  call loop_QV_A(G2(:,:,:,477),wf(:,1),G2(:,:,:,478))
  call check_last_Q_A(l_switch,G2(:,:,:,478),Q(:,63),MT,G3tensor(:,159))
  call loop_QV_A(G1(:,:,:,233),wf(:,21),G1(:,:,:,237))
  call loop_Q_A(G1(:,:,:,237),Q(:,60),MT,G2(:,:,:,479))
  call loop_QV_A(G2(:,:,:,479),wf(:,1),G2(:,:,:,480))
  call check_last_Q_A(l_switch,G2(:,:,:,480),Q(:,63),MT,G3tensor(:,160))
  call loop_QV_A(G1(:,:,:,233),wf(:,-5),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,36),MT,G2(:,:,:,481))
  call loop_QV_A(G2(:,:,:,481),wf(:,18),G2(:,:,:,482))
  call loop_Q_A(G2(:,:,:,482),Q(:,60),MT,G3(:,:,:,209))
  call loop_QV_A(G3(:,:,:,209),wf(:,1),G3(:,:,:,210))
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,63),MT,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,481),wf(:,-3),G2(:,:,:,483))
  call loop_Q_A(G2(:,:,:,483),Q(:,44),MT,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,-4),G3(:,:,:,212))
  call loop_Q_A(G3(:,:,:,212),Q(:,60),MT,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,1),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,25))
  call loop_QV_A(G2(:,:,:,481),wf(:,-4),G2(:,:,:,484))
  call loop_Q_A(G2(:,:,:,484),Q(:,52),MT,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-3),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,60),MT,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,1),G4(:,:,:,52))
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,233),wf(:,18),G1(:,:,:,239))
  call loop_Q_A(G1(:,:,:,239),Q(:,28),MT,G2(:,:,:,485))
  call loop_QV_A(G2(:,:,:,485),wf(:,-5),G2(:,:,:,486))
  call loop_Q_A(G2(:,:,:,486),Q(:,60),MT,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,1),G3(:,:,:,216))
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,63),MT,G4tensor(:,82))
  call loop_QV_A(G1(:,:,:,233),wf(:,26),G1(:,:,:,240))
  call loop_Q_A(G1(:,:,:,240),Q(:,60),MT,G2(:,:,:,487))
  call loop_QV_A(G2(:,:,:,487),wf(:,1),G2(:,:,:,488))
  call check_last_Q_A(l_switch,G2(:,:,:,488),Q(:,63),MT,G3tensor(:,161))
  call loop_QV_A(G1(:,:,:,233),wf(:,-4),G1(:,:,:,241))
  call loop_Q_A(G1(:,:,:,241),Q(:,20),MT,G2(:,:,:,489))
  call loop_QV_A(G2(:,:,:,489),wf(:,23),G2(:,:,:,490))
  call loop_Q_A(G2(:,:,:,490),Q(:,60),MT,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,1),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,63),MT,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,489),wf(:,-3),G2(:,:,:,491))
  call loop_Q_A(G2(:,:,:,491),Q(:,28),MT,G3(:,:,:,219))
  call loop_QV_A(G3(:,:,:,219),wf(:,-5),G3(:,:,:,220))
  call loop_Q_A(G3(:,:,:,220),Q(:,60),MT,G4(:,:,:,53))
  call loop_QV_A(G4(:,:,:,53),wf(:,1),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,489),wf(:,-5),G2(:,:,:,492))
  call loop_Q_A(G2(:,:,:,492),Q(:,52),MT,G3(:,:,:,221))
  call loop_QV_A(G3(:,:,:,221),wf(:,-3),G3(:,:,:,222))
  call loop_Q_A(G3(:,:,:,222),Q(:,60),MT,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,1),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,233),wf(:,23),G1(:,:,:,242))
  call loop_Q_A(G1(:,:,:,242),Q(:,44),MT,G2(:,:,:,493))
  call loop_QV_A(G2(:,:,:,493),wf(:,-4),G2(:,:,:,494))
  call loop_Q_A(G2(:,:,:,494),Q(:,60),MT,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,1),G3(:,:,:,224))
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,63),MT,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,233),wf(:,30),G1(:,:,:,243))
  call loop_Q_A(G1(:,:,:,243),Q(:,60),MT,G2(:,:,:,495))
  call loop_QV_A(G2(:,:,:,495),wf(:,1),G2(:,:,:,496))
  call check_last_Q_A(l_switch,G2(:,:,:,496),Q(:,63),MT,G3tensor(:,162))
  call loop_QV_A(G1(:,:,:,233),wf(:,-3),G1(:,:,:,244))
  call loop_Q_A(G1(:,:,:,244),Q(:,12),MT,G2(:,:,:,497))
  call loop_QV_A(G2(:,:,:,497),wf(:,27),G2(:,:,:,498))
  call loop_Q_A(G2(:,:,:,498),Q(:,60),MT,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,1),G3(:,:,:,226))
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,63),MT,G4tensor(:,85))
  call loop_QV_A(G2(:,:,:,497),wf(:,-4),G2(:,:,:,499))
  call loop_Q_A(G2(:,:,:,499),Q(:,28),MT,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-5),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,60),MT,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,1),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MT,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,497),wf(:,-5),G2(:,:,:,500))
  call loop_Q_A(G2(:,:,:,500),Q(:,44),MT,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,-4),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,60),MT,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,1),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MT,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,233),wf(:,27),G1(:,:,:,245))
  call loop_Q_A(G1(:,:,:,245),Q(:,52),MT,G2(:,:,:,501))
  call loop_QV_A(G2(:,:,:,501),wf(:,-3),G2(:,:,:,502))
  call loop_Q_A(G2(:,:,:,502),Q(:,60),MT,G3(:,:,:,231))
  call loop_QV_A(G3(:,:,:,231),wf(:,1),G3(:,:,:,232))
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,63),MT,G4tensor(:,86))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,23),gH)
  call loop_A_Q(G0(:,:,:,23),Q(:,4),MT,G1(:,:,:,246))
  call loop_AV_Q(G1(:,:,:,246),wf(:,2),G1(:,:,:,247))
  call loop_A_Q(G1(:,:,:,247),Q(:,60),MT,G2(:,:,:,503))
  call loop_AV_Q(G2(:,:,:,503),wf(:,1),G2(:,:,:,504))
  call check_last_A_Q(l_switch,G2(:,:,:,504),Q(:,63),MT,G3tensor(:,163))
  call loop_AV_Q(G1(:,:,:,246),wf(:,4),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,60),MT,G2(:,:,:,505))
  call loop_AV_Q(G2(:,:,:,505),wf(:,1),G2(:,:,:,506))
  call check_last_A_Q(l_switch,G2(:,:,:,506),Q(:,63),MT,G3tensor(:,164))
  call loop_AV_Q(G1(:,:,:,246),wf(:,5),G1(:,:,:,249))
  call loop_A_Q(G1(:,:,:,249),Q(:,60),MT,G2(:,:,:,507))
  call loop_AV_Q(G2(:,:,:,507),wf(:,1),G2(:,:,:,508))
  call check_last_A_Q(l_switch,G2(:,:,:,508),Q(:,63),MT,G3tensor(:,165))
  call loop_AV_Q(G1(:,:,:,246),wf(:,21),G1(:,:,:,250))
  call loop_A_Q(G1(:,:,:,250),Q(:,60),MT,G2(:,:,:,509))
  call loop_AV_Q(G2(:,:,:,509),wf(:,1),G2(:,:,:,510))
  call check_last_A_Q(l_switch,G2(:,:,:,510),Q(:,63),MT,G3tensor(:,166))
  call loop_AV_Q(G1(:,:,:,246),wf(:,-5),G1(:,:,:,251))
  call loop_A_Q(G1(:,:,:,251),Q(:,36),MT,G2(:,:,:,511))
  call loop_AV_Q(G2(:,:,:,511),wf(:,18),G2(:,:,:,512))
  call loop_A_Q(G2(:,:,:,512),Q(:,60),MT,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,1),G3(:,:,:,234))
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,63),MT,G4tensor(:,87))
  call loop_AV_Q(G2(:,:,:,511),wf(:,-3),G2(:,:,:,513))
  call loop_A_Q(G2(:,:,:,513),Q(:,44),MT,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,-4),G3(:,:,:,236))
  call loop_A_Q(G3(:,:,:,236),Q(:,60),MT,G4(:,:,:,61))
  call loop_AV_Q(G4(:,:,:,61),wf(:,1),G4(:,:,:,62))
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,63),MT,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,511),wf(:,-4),G2(:,:,:,514))
  call loop_A_Q(G2(:,:,:,514),Q(:,52),MT,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-3),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,60),MT,G4(:,:,:,63))
  call loop_AV_Q(G4(:,:,:,63),wf(:,1),G4(:,:,:,64))
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,63),MT,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,246),wf(:,18),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,28),MT,G2(:,:,:,515))
  call loop_AV_Q(G2(:,:,:,515),wf(:,-5),G2(:,:,:,516))
  call loop_A_Q(G2(:,:,:,516),Q(:,60),MT,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,1),G3(:,:,:,240))
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,63),MT,G4tensor(:,88))
  call loop_AV_Q(G1(:,:,:,246),wf(:,26),G1(:,:,:,253))
  call loop_A_Q(G1(:,:,:,253),Q(:,60),MT,G2(:,:,:,517))
  call loop_AV_Q(G2(:,:,:,517),wf(:,1),G2(:,:,:,518))
  call check_last_A_Q(l_switch,G2(:,:,:,518),Q(:,63),MT,G3tensor(:,167))
  call loop_AV_Q(G1(:,:,:,246),wf(:,-4),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,20),MT,G2(:,:,:,519))
  call loop_AV_Q(G2(:,:,:,519),wf(:,23),G2(:,:,:,520))
  call loop_A_Q(G2(:,:,:,520),Q(:,60),MT,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,1),G3(:,:,:,242))
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,63),MT,G4tensor(:,89))
  call loop_AV_Q(G2(:,:,:,519),wf(:,-3),G2(:,:,:,521))
  call loop_A_Q(G2(:,:,:,521),Q(:,28),MT,G3(:,:,:,243))
  call loop_AV_Q(G3(:,:,:,243),wf(:,-5),G3(:,:,:,244))
  call loop_A_Q(G3(:,:,:,244),Q(:,60),MT,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,1),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,63),MT,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,519),wf(:,-5),G2(:,:,:,522))
  call loop_A_Q(G2(:,:,:,522),Q(:,52),MT,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-3),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,60),MT,G4(:,:,:,67))
  call loop_AV_Q(G4(:,:,:,67),wf(:,1),G4(:,:,:,68))
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,63),MT,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,246),wf(:,23),G1(:,:,:,255))
  call loop_A_Q(G1(:,:,:,255),Q(:,44),MT,G2(:,:,:,523))
  call loop_AV_Q(G2(:,:,:,523),wf(:,-4),G2(:,:,:,524))
  call loop_A_Q(G2(:,:,:,524),Q(:,60),MT,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,1),G3(:,:,:,248))
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,63),MT,G4tensor(:,90))
  call loop_AV_Q(G1(:,:,:,246),wf(:,30),G1(:,:,:,256))
  call loop_A_Q(G1(:,:,:,256),Q(:,60),MT,G2(:,:,:,525))
  call loop_AV_Q(G2(:,:,:,525),wf(:,1),G2(:,:,:,526))
  call check_last_A_Q(l_switch,G2(:,:,:,526),Q(:,63),MT,G3tensor(:,168))
  call loop_AV_Q(G1(:,:,:,246),wf(:,-3),G1(:,:,:,257))
  call loop_A_Q(G1(:,:,:,257),Q(:,12),MT,G2(:,:,:,527))
  call loop_AV_Q(G2(:,:,:,527),wf(:,27),G2(:,:,:,528))
  call loop_A_Q(G2(:,:,:,528),Q(:,60),MT,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,1),G3(:,:,:,250))
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,63),MT,G4tensor(:,91))
  call loop_AV_Q(G2(:,:,:,527),wf(:,-4),G2(:,:,:,529))
  call loop_A_Q(G2(:,:,:,529),Q(:,28),MT,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-5),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,60),MT,G4(:,:,:,69))
  call loop_AV_Q(G4(:,:,:,69),wf(:,1),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MT,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,527),wf(:,-5),G2(:,:,:,530))
  call loop_A_Q(G2(:,:,:,530),Q(:,44),MT,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,-4),G3(:,:,:,254))
  call loop_A_Q(G3(:,:,:,254),Q(:,60),MT,G4(:,:,:,71))
  call loop_AV_Q(G4(:,:,:,71),wf(:,1),G4(:,:,:,72))
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,63),MT,G5tensor(:,36))
  call loop_AV_Q(G1(:,:,:,246),wf(:,27),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,52),MT,G2(:,:,:,531))
  call loop_AV_Q(G2(:,:,:,531),wf(:,-3),G2(:,:,:,532))
  call loop_A_Q(G2(:,:,:,532),Q(:,60),MT,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,1),G3(:,:,:,256))
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,63),MT,G4tensor(:,92))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,24),gH)
  call loop_Q_A(G0(:,:,:,24),Q(:,4),MB,G1(:,:,:,259))
  call loop_QV_A(G1(:,:,:,259),wf(:,2),G1(:,:,:,260))
  call loop_Q_A(G1(:,:,:,260),Q(:,60),MB,G2(:,:,:,533))
  call loop_QV_A(G2(:,:,:,533),wf(:,1),G2(:,:,:,534))
  call check_last_Q_A(l_switch,G2(:,:,:,534),Q(:,63),MB,G3tensor(:,169))
  call loop_QV_A(G1(:,:,:,259),wf(:,4),G1(:,:,:,261))
  call loop_Q_A(G1(:,:,:,261),Q(:,60),MB,G2(:,:,:,535))
  call loop_QV_A(G2(:,:,:,535),wf(:,1),G2(:,:,:,536))
  call check_last_Q_A(l_switch,G2(:,:,:,536),Q(:,63),MB,G3tensor(:,170))
  call loop_QV_A(G1(:,:,:,259),wf(:,5),G1(:,:,:,262))
  call loop_Q_A(G1(:,:,:,262),Q(:,60),MB,G2(:,:,:,537))
  call loop_QV_A(G2(:,:,:,537),wf(:,1),G2(:,:,:,538))
  call check_last_Q_A(l_switch,G2(:,:,:,538),Q(:,63),MB,G3tensor(:,171))
  call loop_QV_A(G1(:,:,:,259),wf(:,21),G1(:,:,:,263))
  call loop_Q_A(G1(:,:,:,263),Q(:,60),MB,G2(:,:,:,539))
  call loop_QV_A(G2(:,:,:,539),wf(:,1),G2(:,:,:,540))
  call check_last_Q_A(l_switch,G2(:,:,:,540),Q(:,63),MB,G3tensor(:,172))
  call loop_QV_A(G1(:,:,:,259),wf(:,-5),G1(:,:,:,264))
  call loop_Q_A(G1(:,:,:,264),Q(:,36),MB,G2(:,:,:,541))
  call loop_QV_A(G2(:,:,:,541),wf(:,18),G2(:,:,:,542))
  call loop_Q_A(G2(:,:,:,542),Q(:,60),MB,G3(:,:,:,257))
  call loop_QV_A(G3(:,:,:,257),wf(:,1),G3(:,:,:,258))
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,63),MB,G4tensor(:,93))
  call loop_QV_A(G2(:,:,:,541),wf(:,-3),G2(:,:,:,543))
  call loop_Q_A(G2(:,:,:,543),Q(:,44),MB,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,-4),G3(:,:,:,260))
  call loop_Q_A(G3(:,:,:,260),Q(:,60),MB,G4(:,:,:,73))
  call loop_QV_A(G4(:,:,:,73),wf(:,1),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,63),MB,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,541),wf(:,-4),G2(:,:,:,544))
  call loop_Q_A(G2(:,:,:,544),Q(:,52),MB,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-3),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,60),MB,G4(:,:,:,75))
  call loop_QV_A(G4(:,:,:,75),wf(:,1),G4(:,:,:,76))
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,63),MB,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,259),wf(:,18),G1(:,:,:,265))
  call loop_Q_A(G1(:,:,:,265),Q(:,28),MB,G2(:,:,:,545))
  call loop_QV_A(G2(:,:,:,545),wf(:,-5),G2(:,:,:,546))
  call loop_Q_A(G2(:,:,:,546),Q(:,60),MB,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,1),G3(:,:,:,264))
  call check_last_Q_A(l_switch,G3(:,:,:,264),Q(:,63),MB,G4tensor(:,94))
  call loop_QV_A(G1(:,:,:,259),wf(:,26),G1(:,:,:,266))
  call loop_Q_A(G1(:,:,:,266),Q(:,60),MB,G2(:,:,:,547))
  call loop_QV_A(G2(:,:,:,547),wf(:,1),G2(:,:,:,548))
  call check_last_Q_A(l_switch,G2(:,:,:,548),Q(:,63),MB,G3tensor(:,173))
  call loop_QV_A(G1(:,:,:,259),wf(:,-4),G1(:,:,:,267))
  call loop_Q_A(G1(:,:,:,267),Q(:,20),MB,G2(:,:,:,549))
  call loop_QV_A(G2(:,:,:,549),wf(:,23),G2(:,:,:,550))
  call loop_Q_A(G2(:,:,:,550),Q(:,60),MB,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,1),G3(:,:,:,266))
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,63),MB,G4tensor(:,95))
  call loop_QV_A(G2(:,:,:,549),wf(:,-3),G2(:,:,:,551))
  call loop_Q_A(G2(:,:,:,551),Q(:,28),MB,G3(:,:,:,267))
  call loop_QV_A(G3(:,:,:,267),wf(:,-5),G3(:,:,:,268))
  call loop_Q_A(G3(:,:,:,268),Q(:,60),MB,G4(:,:,:,77))
  call loop_QV_A(G4(:,:,:,77),wf(:,1),G4(:,:,:,78))
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,63),MB,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,549),wf(:,-5),G2(:,:,:,552))
  call loop_Q_A(G2(:,:,:,552),Q(:,52),MB,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-3),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,60),MB,G4(:,:,:,79))
  call loop_QV_A(G4(:,:,:,79),wf(:,1),G4(:,:,:,80))
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,63),MB,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,259),wf(:,23),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,44),MB,G2(:,:,:,553))
  call loop_QV_A(G2(:,:,:,553),wf(:,-4),G2(:,:,:,554))
  call loop_Q_A(G2(:,:,:,554),Q(:,60),MB,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,1),G3(:,:,:,272))
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,63),MB,G4tensor(:,96))
  call loop_QV_A(G1(:,:,:,259),wf(:,30),G1(:,:,:,269))
  call loop_Q_A(G1(:,:,:,269),Q(:,60),MB,G2(:,:,:,555))
  call loop_QV_A(G2(:,:,:,555),wf(:,1),G2(:,:,:,556))
  call check_last_Q_A(l_switch,G2(:,:,:,556),Q(:,63),MB,G3tensor(:,174))
  call loop_QV_A(G1(:,:,:,259),wf(:,-3),G1(:,:,:,270))
  call loop_Q_A(G1(:,:,:,270),Q(:,12),MB,G2(:,:,:,557))
  call loop_QV_A(G2(:,:,:,557),wf(:,27),G2(:,:,:,558))
  call loop_Q_A(G2(:,:,:,558),Q(:,60),MB,G3(:,:,:,273))
  call loop_QV_A(G3(:,:,:,273),wf(:,1),G3(:,:,:,274))
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,63),MB,G4tensor(:,97))
  call loop_QV_A(G2(:,:,:,557),wf(:,-4),G2(:,:,:,559))
  call loop_Q_A(G2(:,:,:,559),Q(:,28),MB,G3(:,:,:,275))
  call loop_QV_A(G3(:,:,:,275),wf(:,-5),G3(:,:,:,276))
  call loop_Q_A(G3(:,:,:,276),Q(:,60),MB,G4(:,:,:,81))
  call loop_QV_A(G4(:,:,:,81),wf(:,1),G4(:,:,:,82))
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,63),MB,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,557),wf(:,-5),G2(:,:,:,560))
  call loop_Q_A(G2(:,:,:,560),Q(:,44),MB,G3(:,:,:,277))
  call loop_QV_A(G3(:,:,:,277),wf(:,-4),G3(:,:,:,278))
  call loop_Q_A(G3(:,:,:,278),Q(:,60),MB,G4(:,:,:,83))
  call loop_QV_A(G4(:,:,:,83),wf(:,1),G4(:,:,:,84))
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,63),MB,G5tensor(:,42))
  call loop_QV_A(G1(:,:,:,259),wf(:,27),G1(:,:,:,271))
  call loop_Q_A(G1(:,:,:,271),Q(:,52),MB,G2(:,:,:,561))
  call loop_QV_A(G2(:,:,:,561),wf(:,-3),G2(:,:,:,562))
  call loop_Q_A(G2(:,:,:,562),Q(:,60),MB,G3(:,:,:,279))
  call loop_QV_A(G3(:,:,:,279),wf(:,1),G3(:,:,:,280))
  call check_last_Q_A(l_switch,G3(:,:,:,280),Q(:,63),MB,G4tensor(:,98))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,25),gH)
  call loop_A_Q(G0(:,:,:,25),Q(:,4),MB,G1(:,:,:,272))
  call loop_AV_Q(G1(:,:,:,272),wf(:,2),G1(:,:,:,273))
  call loop_A_Q(G1(:,:,:,273),Q(:,60),MB,G2(:,:,:,563))
  call loop_AV_Q(G2(:,:,:,563),wf(:,1),G2(:,:,:,564))
  call check_last_A_Q(l_switch,G2(:,:,:,564),Q(:,63),MB,G3tensor(:,175))
  call loop_AV_Q(G1(:,:,:,272),wf(:,4),G1(:,:,:,274))
  call loop_A_Q(G1(:,:,:,274),Q(:,60),MB,G2(:,:,:,565))
  call loop_AV_Q(G2(:,:,:,565),wf(:,1),G2(:,:,:,566))
  call check_last_A_Q(l_switch,G2(:,:,:,566),Q(:,63),MB,G3tensor(:,176))
  call loop_AV_Q(G1(:,:,:,272),wf(:,5),G1(:,:,:,275))
  call loop_A_Q(G1(:,:,:,275),Q(:,60),MB,G2(:,:,:,567))
  call loop_AV_Q(G2(:,:,:,567),wf(:,1),G2(:,:,:,568))
  call check_last_A_Q(l_switch,G2(:,:,:,568),Q(:,63),MB,G3tensor(:,177))
  call loop_AV_Q(G1(:,:,:,272),wf(:,21),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,60),MB,G2(:,:,:,569))
  call loop_AV_Q(G2(:,:,:,569),wf(:,1),G2(:,:,:,570))
  call check_last_A_Q(l_switch,G2(:,:,:,570),Q(:,63),MB,G3tensor(:,178))
  call loop_AV_Q(G1(:,:,:,272),wf(:,-5),G1(:,:,:,277))
  call loop_A_Q(G1(:,:,:,277),Q(:,36),MB,G2(:,:,:,571))
  call loop_AV_Q(G2(:,:,:,571),wf(:,18),G2(:,:,:,572))
  call loop_A_Q(G2(:,:,:,572),Q(:,60),MB,G3(:,:,:,281))
  call loop_AV_Q(G3(:,:,:,281),wf(:,1),G3(:,:,:,282))
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,63),MB,G4tensor(:,99))
  call loop_AV_Q(G2(:,:,:,571),wf(:,-3),G2(:,:,:,573))
  call loop_A_Q(G2(:,:,:,573),Q(:,44),MB,G3(:,:,:,283))
  call loop_AV_Q(G3(:,:,:,283),wf(:,-4),G3(:,:,:,284))
  call loop_A_Q(G3(:,:,:,284),Q(:,60),MB,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,1),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MB,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,571),wf(:,-4),G2(:,:,:,574))
  call loop_A_Q(G2(:,:,:,574),Q(:,52),MB,G3(:,:,:,285))
  call loop_AV_Q(G3(:,:,:,285),wf(:,-3),G3(:,:,:,286))
  call loop_A_Q(G3(:,:,:,286),Q(:,60),MB,G4(:,:,:,87))
  call loop_AV_Q(G4(:,:,:,87),wf(:,1),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,63),MB,G5tensor(:,44))
  call loop_AV_Q(G1(:,:,:,272),wf(:,18),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,28),MB,G2(:,:,:,575))
  call loop_AV_Q(G2(:,:,:,575),wf(:,-5),G2(:,:,:,576))
  call loop_A_Q(G2(:,:,:,576),Q(:,60),MB,G3(:,:,:,287))
  call loop_AV_Q(G3(:,:,:,287),wf(:,1),G3(:,:,:,288))
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,63),MB,G4tensor(:,100))
  call loop_AV_Q(G1(:,:,:,272),wf(:,26),G1(:,:,:,279))
  call loop_A_Q(G1(:,:,:,279),Q(:,60),MB,G2(:,:,:,577))
  call loop_AV_Q(G2(:,:,:,577),wf(:,1),G2(:,:,:,578))
  call check_last_A_Q(l_switch,G2(:,:,:,578),Q(:,63),MB,G3tensor(:,179))
  call loop_AV_Q(G1(:,:,:,272),wf(:,-4),G1(:,:,:,280))
  call loop_A_Q(G1(:,:,:,280),Q(:,20),MB,G2(:,:,:,579))
  call loop_AV_Q(G2(:,:,:,579),wf(:,23),G2(:,:,:,580))
  call loop_A_Q(G2(:,:,:,580),Q(:,60),MB,G3(:,:,:,289))
  call loop_AV_Q(G3(:,:,:,289),wf(:,1),G3(:,:,:,290))
  call check_last_A_Q(l_switch,G3(:,:,:,290),Q(:,63),MB,G4tensor(:,101))
  call loop_AV_Q(G2(:,:,:,579),wf(:,-3),G2(:,:,:,581))
  call loop_A_Q(G2(:,:,:,581),Q(:,28),MB,G3(:,:,:,291))
  call loop_AV_Q(G3(:,:,:,291),wf(:,-5),G3(:,:,:,292))
  call loop_A_Q(G3(:,:,:,292),Q(:,60),MB,G4(:,:,:,89))
  call loop_AV_Q(G4(:,:,:,89),wf(:,1),G4(:,:,:,90))
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MB,G5tensor(:,45))
  call loop_AV_Q(G2(:,:,:,579),wf(:,-5),G2(:,:,:,582))
  call loop_A_Q(G2(:,:,:,582),Q(:,52),MB,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-3),G3(:,:,:,294))
  call loop_A_Q(G3(:,:,:,294),Q(:,60),MB,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,1),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MB,G5tensor(:,46))
  call loop_AV_Q(G1(:,:,:,272),wf(:,23),G1(:,:,:,281))
  call loop_A_Q(G1(:,:,:,281),Q(:,44),MB,G2(:,:,:,583))
  call loop_AV_Q(G2(:,:,:,583),wf(:,-4),G2(:,:,:,584))
  call loop_A_Q(G2(:,:,:,584),Q(:,60),MB,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,1),G3(:,:,:,296))
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,63),MB,G4tensor(:,102))
  call loop_AV_Q(G1(:,:,:,272),wf(:,30),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,60),MB,G2(:,:,:,585))
  call loop_AV_Q(G2(:,:,:,585),wf(:,1),G2(:,:,:,586))
  call check_last_A_Q(l_switch,G2(:,:,:,586),Q(:,63),MB,G3tensor(:,180))
  call loop_AV_Q(G1(:,:,:,272),wf(:,-3),G1(:,:,:,283))
  call loop_A_Q(G1(:,:,:,283),Q(:,12),MB,G2(:,:,:,587))
  call loop_AV_Q(G2(:,:,:,587),wf(:,27),G2(:,:,:,588))
  call loop_A_Q(G2(:,:,:,588),Q(:,60),MB,G3(:,:,:,297))
  call loop_AV_Q(G3(:,:,:,297),wf(:,1),G3(:,:,:,298))
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,63),MB,G4tensor(:,103))
  call loop_AV_Q(G2(:,:,:,587),wf(:,-4),G2(:,:,:,589))
  call loop_A_Q(G2(:,:,:,589),Q(:,28),MB,G3(:,:,:,299))
  call loop_AV_Q(G3(:,:,:,299),wf(:,-5),G3(:,:,:,300))
  call loop_A_Q(G3(:,:,:,300),Q(:,60),MB,G4(:,:,:,93))
  call loop_AV_Q(G4(:,:,:,93),wf(:,1),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,63),MB,G5tensor(:,47))
  call loop_AV_Q(G2(:,:,:,587),wf(:,-5),G2(:,:,:,590))
  call loop_A_Q(G2(:,:,:,590),Q(:,44),MB,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-4),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,60),MB,G4(:,:,:,95))
  call loop_AV_Q(G4(:,:,:,95),wf(:,1),G4(:,:,:,96))
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MB,G5tensor(:,48))
  call loop_AV_Q(G1(:,:,:,272),wf(:,27),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,52),MB,G2(:,:,:,591))
  call loop_AV_Q(G2(:,:,:,591),wf(:,-3),G2(:,:,:,592))
  call loop_A_Q(G2(:,:,:,592),Q(:,60),MB,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,1),G3(:,:,:,304))
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,63),MB,G4tensor(:,104))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,24),MT,G1(:,:,:,285))
  call loop_AV_Q(G1(:,:,:,285),wf(:,19),G1(:,:,:,286))
  call loop_A_Q(G1(:,:,:,286),Q(:,59),MT,G2(:,:,:,593))
  call loop_AS_Q(G2(:,:,:,593),wf(:,-2),G2(:,:,:,594),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,594),Q(:,63),MT,G3tensor(:,181))
  call loop_AS_Q(G1(:,:,:,285),wf(:,-2),G1(:,:,:,287),gH)
  call loop_A_Q(G1(:,:,:,287),Q(:,28),MT,G2(:,:,:,595))
  call loop_AV_Q(G2(:,:,:,595),wf(:,-5),G2(:,:,:,596))
  call loop_A_Q(G2(:,:,:,596),Q(:,60),MT,G3(:,:,:,305))
  call loop_AV_Q(G3(:,:,:,305),wf(:,1),G3(:,:,:,306))
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,63),MT,G4tensor(:,105))
  call loop_AV_Q(G1(:,:,:,285),wf(:,73),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,59),MT,G2(:,:,:,597))
  call loop_AS_Q(G2(:,:,:,597),wf(:,-2),G2(:,:,:,598),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,598),Q(:,63),MT,G3tensor(:,182))
  call loop_AV_Q(G1(:,:,:,285),wf(:,74),G1(:,:,:,289))
  call loop_A_Q(G1(:,:,:,289),Q(:,59),MT,G2(:,:,:,599))
  call loop_AS_Q(G2(:,:,:,599),wf(:,-2),G2(:,:,:,600),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,600),Q(:,63),MT,G3tensor(:,183))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,24),MT,G1(:,:,:,290))
  call loop_QV_A(G1(:,:,:,290),wf(:,19),G1(:,:,:,291))
  call loop_Q_A(G1(:,:,:,291),Q(:,59),MT,G2(:,:,:,601))
  call loop_QS_A(G2(:,:,:,601),wf(:,-2),G2(:,:,:,602),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,602),Q(:,63),MT,G3tensor(:,184))
  call loop_QS_A(G1(:,:,:,290),wf(:,-2),G1(:,:,:,292),gH)
  call loop_Q_A(G1(:,:,:,292),Q(:,28),MT,G2(:,:,:,603))
  call loop_QV_A(G2(:,:,:,603),wf(:,-5),G2(:,:,:,604))
  call loop_Q_A(G2(:,:,:,604),Q(:,60),MT,G3(:,:,:,307))
  call loop_QV_A(G3(:,:,:,307),wf(:,1),G3(:,:,:,308))
  call check_last_Q_A(l_switch,G3(:,:,:,308),Q(:,63),MT,G4tensor(:,106))
  call loop_QV_A(G1(:,:,:,290),wf(:,73),G1(:,:,:,293))
  call loop_Q_A(G1(:,:,:,293),Q(:,59),MT,G2(:,:,:,605))
  call loop_QS_A(G2(:,:,:,605),wf(:,-2),G2(:,:,:,606),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,606),Q(:,63),MT,G3tensor(:,185))
  call loop_QV_A(G1(:,:,:,290),wf(:,74),G1(:,:,:,294))
  call loop_Q_A(G1(:,:,:,294),Q(:,59),MT,G2(:,:,:,607))
  call loop_QS_A(G2(:,:,:,607),wf(:,-2),G2(:,:,:,608),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,608),Q(:,63),MT,G3tensor(:,186))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,24),MB,G1(:,:,:,295))
  call loop_AV_Q(G1(:,:,:,295),wf(:,19),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,59),MB,G2(:,:,:,609))
  call loop_AS_Q(G2(:,:,:,609),wf(:,-2),G2(:,:,:,610),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,610),Q(:,63),MB,G3tensor(:,187))
  call loop_AS_Q(G1(:,:,:,295),wf(:,-2),G1(:,:,:,297),gH)
  call loop_A_Q(G1(:,:,:,297),Q(:,28),MB,G2(:,:,:,611))
  call loop_AV_Q(G2(:,:,:,611),wf(:,-5),G2(:,:,:,612))
  call loop_A_Q(G2(:,:,:,612),Q(:,60),MB,G3(:,:,:,309))
  call loop_AV_Q(G3(:,:,:,309),wf(:,1),G3(:,:,:,310))
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,63),MB,G4tensor(:,107))
  call loop_AV_Q(G1(:,:,:,295),wf(:,73),G1(:,:,:,298))
  call loop_A_Q(G1(:,:,:,298),Q(:,59),MB,G2(:,:,:,613))
  call loop_AS_Q(G2(:,:,:,613),wf(:,-2),G2(:,:,:,614),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,614),Q(:,63),MB,G3tensor(:,188))
  call loop_AV_Q(G1(:,:,:,295),wf(:,74),G1(:,:,:,299))
  call loop_A_Q(G1(:,:,:,299),Q(:,59),MB,G2(:,:,:,615))
  call loop_AS_Q(G2(:,:,:,615),wf(:,-2),G2(:,:,:,616),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,616),Q(:,63),MB,G3tensor(:,189))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,24),MB,G1(:,:,:,300))
  call loop_QV_A(G1(:,:,:,300),wf(:,19),G1(:,:,:,301))
  call loop_Q_A(G1(:,:,:,301),Q(:,59),MB,G2(:,:,:,617))
  call loop_QS_A(G2(:,:,:,617),wf(:,-2),G2(:,:,:,618),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,618),Q(:,63),MB,G3tensor(:,190))
  call loop_QS_A(G1(:,:,:,300),wf(:,-2),G1(:,:,:,302),gH)
  call loop_Q_A(G1(:,:,:,302),Q(:,28),MB,G2(:,:,:,619))
  call loop_QV_A(G2(:,:,:,619),wf(:,-5),G2(:,:,:,620))
  call loop_Q_A(G2(:,:,:,620),Q(:,60),MB,G3(:,:,:,311))
  call loop_QV_A(G3(:,:,:,311),wf(:,1),G3(:,:,:,312))
  call check_last_Q_A(l_switch,G3(:,:,:,312),Q(:,63),MB,G4tensor(:,108))
  call loop_QV_A(G1(:,:,:,300),wf(:,73),G1(:,:,:,303))
  call loop_Q_A(G1(:,:,:,303),Q(:,59),MB,G2(:,:,:,621))
  call loop_QS_A(G2(:,:,:,621),wf(:,-2),G2(:,:,:,622),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,622),Q(:,63),MB,G3tensor(:,191))
  call loop_QV_A(G1(:,:,:,300),wf(:,74),G1(:,:,:,304))
  call loop_Q_A(G1(:,:,:,304),Q(:,59),MB,G2(:,:,:,623))
  call loop_QS_A(G2(:,:,:,623),wf(:,-2),G2(:,:,:,624),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,624),Q(:,63),MB,G3tensor(:,192))
  call loop_QV_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,27),MT,G1(:,:,:,305))
  call loop_QV_A(G1(:,:,:,305),wf(:,-5),G1(:,:,:,306))
  call loop_Q_A(G1(:,:,:,306),Q(:,59),MT,G2(:,:,:,625))
  call loop_QS_A(G2(:,:,:,625),wf(:,-2),G2(:,:,:,626),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,626),Q(:,63),MT,G3tensor(:,193))
  call loop_AV_Q(G0(:,:,:,1),wf(:,96),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,27),MT,G1(:,:,:,307))
  call loop_AV_Q(G1(:,:,:,307),wf(:,-5),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,59),MT,G2(:,:,:,627))
  call loop_AS_Q(G2(:,:,:,627),wf(:,-2),G2(:,:,:,628),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,628),Q(:,63),MT,G3tensor(:,194))
  call loop_QV_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,27),MB,G1(:,:,:,309))
  call loop_QV_A(G1(:,:,:,309),wf(:,-5),G1(:,:,:,310))
  call loop_Q_A(G1(:,:,:,310),Q(:,59),MB,G2(:,:,:,629))
  call loop_QS_A(G2(:,:,:,629),wf(:,-2),G2(:,:,:,630),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,630),Q(:,63),MB,G3tensor(:,195))
  call loop_AV_Q(G0(:,:,:,1),wf(:,96),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,27),MB,G1(:,:,:,311))
  call loop_AV_Q(G1(:,:,:,311),wf(:,-5),G1(:,:,:,312))
  call loop_A_Q(G1(:,:,:,312),Q(:,59),MB,G2(:,:,:,631))
  call loop_AS_Q(G2(:,:,:,631),wf(:,-2),G2(:,:,:,632),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,632),Q(:,63),MB,G3tensor(:,196))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,19),MT,G1(:,:,:,313))
  call loop_QV_A(G1(:,:,:,313),wf(:,23),G1(:,:,:,314))
  call loop_Q_A(G1(:,:,:,314),Q(:,59),MT,G2(:,:,:,633))
  call loop_QS_A(G2(:,:,:,633),wf(:,-2),G2(:,:,:,634),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,634),Q(:,63),MT,G3tensor(:,197))
  call loop_QV_A(G1(:,:,:,313),wf(:,-3),G1(:,:,:,315))
  call loop_Q_A(G1(:,:,:,315),Q(:,27),MT,G2(:,:,:,635))
  call loop_QV_A(G2(:,:,:,635),wf(:,-5),G2(:,:,:,636))
  call loop_Q_A(G2(:,:,:,636),Q(:,59),MT,G3(:,:,:,313))
  call loop_QS_A(G3(:,:,:,313),wf(:,-2),G3(:,:,:,314),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,314),Q(:,63),MT,G4tensor(:,109))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,19),MT,G1(:,:,:,316))
  call loop_AV_Q(G1(:,:,:,316),wf(:,23),G1(:,:,:,317))
  call loop_A_Q(G1(:,:,:,317),Q(:,59),MT,G2(:,:,:,637))
  call loop_AS_Q(G2(:,:,:,637),wf(:,-2),G2(:,:,:,638),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,638),Q(:,63),MT,G3tensor(:,198))
  call loop_AV_Q(G1(:,:,:,316),wf(:,-3),G1(:,:,:,318))
  call loop_A_Q(G1(:,:,:,318),Q(:,27),MT,G2(:,:,:,639))
  call loop_AV_Q(G2(:,:,:,639),wf(:,-5),G2(:,:,:,640))
  call loop_A_Q(G2(:,:,:,640),Q(:,59),MT,G3(:,:,:,315))
  call loop_AS_Q(G3(:,:,:,315),wf(:,-2),G3(:,:,:,316),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,63),MT,G4tensor(:,110))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,19),MB,G1(:,:,:,319))
  call loop_QV_A(G1(:,:,:,319),wf(:,23),G1(:,:,:,320))
  call loop_Q_A(G1(:,:,:,320),Q(:,59),MB,G2(:,:,:,641))
  call loop_QS_A(G2(:,:,:,641),wf(:,-2),G2(:,:,:,642),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,642),Q(:,63),MB,G3tensor(:,199))
  call loop_QV_A(G1(:,:,:,319),wf(:,-3),G1(:,:,:,321))
  call loop_Q_A(G1(:,:,:,321),Q(:,27),MB,G2(:,:,:,643))
  call loop_QV_A(G2(:,:,:,643),wf(:,-5),G2(:,:,:,644))
  call loop_Q_A(G2(:,:,:,644),Q(:,59),MB,G3(:,:,:,317))
  call loop_QS_A(G3(:,:,:,317),wf(:,-2),G3(:,:,:,318),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,318),Q(:,63),MB,G4tensor(:,111))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,19),MB,G1(:,:,:,322))
  call loop_AV_Q(G1(:,:,:,322),wf(:,23),G1(:,:,:,323))
  call loop_A_Q(G1(:,:,:,323),Q(:,59),MB,G2(:,:,:,645))
  call loop_AS_Q(G2(:,:,:,645),wf(:,-2),G2(:,:,:,646),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,646),Q(:,63),MB,G3tensor(:,200))
  call loop_AV_Q(G1(:,:,:,322),wf(:,-3),G1(:,:,:,324))
  call loop_A_Q(G1(:,:,:,324),Q(:,27),MB,G2(:,:,:,647))
  call loop_AV_Q(G2(:,:,:,647),wf(:,-5),G2(:,:,:,648))
  call loop_A_Q(G2(:,:,:,648),Q(:,59),MB,G3(:,:,:,319))
  call loop_AS_Q(G3(:,:,:,319),wf(:,-2),G3(:,:,:,320),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,320),Q(:,63),MB,G4tensor(:,112))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,11),MT,G1(:,:,:,325))
  call loop_AV_Q(G1(:,:,:,325),wf(:,27),G1(:,:,:,326))
  call loop_A_Q(G1(:,:,:,326),Q(:,59),MT,G2(:,:,:,649))
  call loop_AS_Q(G2(:,:,:,649),wf(:,-2),G2(:,:,:,650),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,650),Q(:,63),MT,G3tensor(:,201))
  call loop_AV_Q(G1(:,:,:,325),wf(:,-5),G1(:,:,:,327))
  call loop_A_Q(G1(:,:,:,327),Q(:,43),MT,G2(:,:,:,651))
  call loop_AV_Q(G2(:,:,:,651),wf(:,-4),G2(:,:,:,652))
  call loop_A_Q(G2(:,:,:,652),Q(:,59),MT,G3(:,:,:,321))
  call loop_AS_Q(G3(:,:,:,321),wf(:,-2),G3(:,:,:,322),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,322),Q(:,63),MT,G4tensor(:,113))
  call loop_AV_Q(G1(:,:,:,325),wf(:,-4),G1(:,:,:,328))
  call loop_A_Q(G1(:,:,:,328),Q(:,27),MT,G2(:,:,:,653))
  call loop_AV_Q(G2(:,:,:,653),wf(:,-5),G2(:,:,:,654))
  call loop_A_Q(G2(:,:,:,654),Q(:,59),MT,G3(:,:,:,323))
  call loop_AS_Q(G3(:,:,:,323),wf(:,-2),G3(:,:,:,324),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,63),MT,G4tensor(:,114))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,127),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,127),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,127),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,127),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,128),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,128),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,128),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,128),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,129),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,129),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,129),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,129),T3sum(1:35,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,145),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,145),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,145),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,145),T3sum(1:35,5))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,5))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,5))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,147),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,147),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,147),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,147),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,5))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,5))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,149),T3sum(1:35,5))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,149),T3sum(1:35,5))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,149),T3sum(1:35,5))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,149),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,150),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,150),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,150),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,150),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,151),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,151),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,151),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,151),T3sum(1:35,6))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,152),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,152),T3sum(1:35,6))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,152),T3sum(1:35,6))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,152),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,153),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,153),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,153),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,153),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,154),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,154),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,154),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,154),T3sum(1:35,6))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,155),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,155),T3sum(1:35,6))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,155),T3sum(1:35,6))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,155),T3sum(1:35,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,156),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,156),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,156),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,156),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,157),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,157),T3sum(1:35,7))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,157),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,157),T3sum(1:35,7))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,158),T3sum(1:35,7))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,158),T3sum(1:35,7))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,158),T3sum(1:35,7))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,158),T3sum(1:35,7))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,159),T3sum(1:35,7))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,159),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,159),T3sum(1:35,7))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,159),T3sum(1:35,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,163),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,163),T3sum(1:35,7))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,163),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,163),T3sum(1:35,7))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,164),T3sum(1:35,7))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,164),T3sum(1:35,7))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,164),T3sum(1:35,7))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,164),T3sum(1:35,7))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,165),T3sum(1:35,7))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,165),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,165),T3sum(1:35,7))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,165),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,169),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,169),T3sum(1:35,8))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,169),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,169),T3sum(1:35,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,170),T3sum(1:35,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,170),T3sum(1:35,8))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,170),T3sum(1:35,8))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,170),T3sum(1:35,8))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,171),T3sum(1:35,8))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,171),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,171),T3sum(1:35,8))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,171),T3sum(1:35,8))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,175),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,175),T3sum(1:35,8))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,175),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,175),T3sum(1:35,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,176),T3sum(1:35,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,176),T3sum(1:35,8))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,176),T3sum(1:35,8))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,176),T3sum(1:35,8))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,177),T3sum(1:35,8))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,177),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,177),T3sum(1:35,8))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,177),T3sum(1:35,8))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,181),T3sum(1:35,9))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,181),T3sum(1:35,9))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,181),T3sum(1:35,9))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,181),T3sum(1:35,9))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,184),T3sum(1:35,9))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,184),T3sum(1:35,9))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,184),T3sum(1:35,9))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,184),T3sum(1:35,9))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,187),T3sum(1:35,10))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,187),T3sum(1:35,10))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,187),T3sum(1:35,10))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,187),T3sum(1:35,10))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,190),T3sum(1:35,10))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,190),T3sum(1:35,10))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,190),T3sum(1:35,10))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,190),T3sum(1:35,10))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,160),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,160),T3sum(1:35,7))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,160),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,160),T3sum(1:35,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,166),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,166),T3sum(1:35,7))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,166),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,166),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,172),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,172),T3sum(1:35,8))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,172),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,172),T3sum(1:35,8))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,178),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,178),T3sum(1:35,8))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,178),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,178),T3sum(1:35,8))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,193),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,193),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,193),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,193),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,194),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,194),T3sum(1:35,5))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,194),T3sum(1:35,5))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,194),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,195),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,195),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,195),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,195),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,196),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,196),T3sum(1:35,6))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,196),T3sum(1:35,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,196),T3sum(1:35,6))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,87),T4sum(1:70,1))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,87),T4sum(1:70,1))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,87),T4sum(1:70,1))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,87),T4sum(1:70,1))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,81),T4sum(1:70,1))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,81),T4sum(1:70,1))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,81),T4sum(1:70,1))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,81),T4sum(1:70,1))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,99),T4sum(1:70,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,99),T4sum(1:70,2))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,99),T4sum(1:70,2))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,99),T4sum(1:70,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,93),T4sum(1:70,2))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,93),T4sum(1:70,2))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,93),T4sum(1:70,2))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,93),T4sum(1:70,2))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,105),T4sum(1:70,3))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,105),T4sum(1:70,3))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,105),T4sum(1:70,3))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,105),T4sum(1:70,3))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,106),T4sum(1:70,3))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,106),T4sum(1:70,3))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,106),T4sum(1:70,3))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,106),T4sum(1:70,3))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,107),T4sum(1:70,4))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,107),T4sum(1:70,4))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,107),T4sum(1:70,4))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,107),T4sum(1:70,4))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,108),T4sum(1:70,4))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,108),T4sum(1:70,4))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,108),T4sum(1:70,4))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_3,G4tensor(:,108),T4sum(1:70,4))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,82),T4sum(1:70,5))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,82),T4sum(1:70,5))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,82),T4sum(1:70,5))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,82),T4sum(1:70,5))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,88),T4sum(1:70,5))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,88),T4sum(1:70,5))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,88),T4sum(1:70,5))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,88),T4sum(1:70,5))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,94),T4sum(1:70,6))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,94),T4sum(1:70,6))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,94),T4sum(1:70,6))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,94),T4sum(1:70,6))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,100),T4sum(1:70,6))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,100),T4sum(1:70,6))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,100),T4sum(1:70,6))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,100),T4sum(1:70,6))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,197),T3sum(1:35,11))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,197),T3sum(1:35,11))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,197),T3sum(1:35,11))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,197),T3sum(1:35,11))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,198),T3sum(1:35,11))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,198),T3sum(1:35,11))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,198),T3sum(1:35,11))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,198),T3sum(1:35,11))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,199),T3sum(1:35,12))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,199),T3sum(1:35,12))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,199),T3sum(1:35,12))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,199),T3sum(1:35,12))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,200),T3sum(1:35,12))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,200),T3sum(1:35,12))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,200),T3sum(1:35,12))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,200),T3sum(1:35,12))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,161),T3sum(1:35,7))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,161),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,161),T3sum(1:35,7))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,161),T3sum(1:35,7))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,167),T3sum(1:35,7))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,167),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,167),T3sum(1:35,7))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,167),T3sum(1:35,7))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,173),T3sum(1:35,8))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,173),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,173),T3sum(1:35,8))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,173),T3sum(1:35,8))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,179),T3sum(1:35,8))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,179),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,179),T3sum(1:35,8))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,179),T3sum(1:35,8))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,130),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,130),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,130),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,130),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,89),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,89),T4sum(1:70,7))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,89),T4sum(1:70,7))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,89),T4sum(1:70,7))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,83),T4sum(1:70,7))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,83),T4sum(1:70,7))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,83),T4sum(1:70,7))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,83),T4sum(1:70,7))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,101),T4sum(1:70,8))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,101),T4sum(1:70,8))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,101),T4sum(1:70,8))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,101),T4sum(1:70,8))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,95),T4sum(1:70,8))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,95),T4sum(1:70,8))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,95),T4sum(1:70,8))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,95),T4sum(1:70,8))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,53),T4sum(1:70,9))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,53),T4sum(1:70,9))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,53),T4sum(1:70,9))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,53),T4sum(1:70,9))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,74),T4sum(1:70,10))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,74),T4sum(1:70,10))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,74),T4sum(1:70,10))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,74),T4sum(1:70,10))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,67),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,67),T4sum(1:70,10))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,67),T4sum(1:70,10))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_3,G4tensor(:,67),T4sum(1:70,10))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,84),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,84),T4sum(1:70,11))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,84),T4sum(1:70,11))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,84),T4sum(1:70,11))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,90),T4sum(1:70,11))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,90),T4sum(1:70,11))
  M(10) = M(10) + ((CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,90),T4sum(1:70,11))
  M(11) = M(11) + (-(CI*f(7))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,90),T4sum(1:70,11))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,96),T4sum(1:70,12))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,96),T4sum(1:70,12))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,96),T4sum(1:70,12))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,96),T4sum(1:70,12))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,102),T4sum(1:70,12))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,102),T4sum(1:70,12))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,102),T4sum(1:70,12))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,102),T4sum(1:70,12))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,201),T3sum(1:35,13))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,201),T3sum(1:35,13))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,201),T3sum(1:35,13))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,201),T3sum(1:35,13))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,162),T3sum(1:35,7))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,162),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,162),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,162),T3sum(1:35,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,168),T3sum(1:35,7))
  M(2) = M(2) + (f(8)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,168),T3sum(1:35,7))
  M(4) = M(4) + (f(8)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,168),T3sum(1:35,7))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,168),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,174),T3sum(1:35,8))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,174),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,174),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,174),T3sum(1:35,8))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,180),T3sum(1:35,8))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,180),T3sum(1:35,8))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,180),T3sum(1:35,8))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,180),T3sum(1:35,8))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,91),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,91),T4sum(1:70,13))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,91),T4sum(1:70,13))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,91),T4sum(1:70,13))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,85),T4sum(1:70,13))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,85),T4sum(1:70,13))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,85),T4sum(1:70,13))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,85),T4sum(1:70,13))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,103),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,103),T4sum(1:70,14))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,103),T4sum(1:70,14))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,103),T4sum(1:70,14))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,97),T4sum(1:70,14))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,97),T4sum(1:70,14))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,97),T4sum(1:70,14))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,97),T4sum(1:70,14))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,14),T4sum(1:70,15))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,14),T4sum(1:70,15))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,14),T4sum(1:70,15))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,14),T4sum(1:70,15))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,1),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,1),T4sum(1:70,15))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,1),T4sum(1:70,15))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,1),T4sum(1:70,15))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,40),T4sum(1:70,16))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,40),T4sum(1:70,16))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,40),T4sum(1:70,16))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,40),T4sum(1:70,16))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,27),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,27),T4sum(1:70,16))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,27),T4sum(1:70,16))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,27),T4sum(1:70,16))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,86),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,86),T4sum(1:70,17))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,86),T4sum(1:70,17))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,86),T4sum(1:70,17))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,17))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,17))
  M(10) = M(10) + (-(CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,17))
  M(11) = M(11) + ((CI*f(7))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,17))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,98),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,98),T4sum(1:70,18))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,98),T4sum(1:70,18))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,98),T4sum(1:70,18))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,104),T4sum(1:70,18))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,104),T4sum(1:70,18))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,104),T4sum(1:70,18))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,104),T4sum(1:70,18))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,113),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,113),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,113),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,113),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,131),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,131),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,131),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,131),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,54),T4sum(1:70,19))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,54),T4sum(1:70,19))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,61),T4sum(1:70,19))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,61),T4sum(1:70,19))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,68),T4sum(1:70,20))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,68),T4sum(1:70,20))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,75),T4sum(1:70,20))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,75),T4sum(1:70,20))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,113),T4sum(1:70,21))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,113),T4sum(1:70,21))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,114),T4sum(1:70,23))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,114),T4sum(1:70,23))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,2),T4sum(1:70,25))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,2),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,15),T4sum(1:70,25))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,15),T4sum(1:70,25))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,28),T4sum(1:70,26))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,28),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,41),T4sum(1:70,26))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,41),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,3),T4sum(1:70,27))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,3),T4sum(1:70,27))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,16),T4sum(1:70,27))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,16),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,29),T4sum(1:70,28))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,29),T4sum(1:70,28))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,42),T4sum(1:70,28))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,42),T4sum(1:70,28))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,109),T4sum(1:70,29))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,109),T4sum(1:70,29))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,110),T4sum(1:70,29))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,110),T4sum(1:70,29))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,111),T4sum(1:70,30))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,111),T4sum(1:70,30))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,112),T4sum(1:70,30))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_3,G4tensor(:,112),T4sum(1:70,30))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(5) = M(5) + (f(8)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,114),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,114),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,114),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,114),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,132),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,132),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,132),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,132),T3sum(1:35,4))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(6) = M(6) + (f(8)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,6),T4sum(1:70,31))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,6),T4sum(1:70,31))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,19),T4sum(1:70,31))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,19),T4sum(1:70,31))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,32),T4sum(1:70,32))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,32),T4sum(1:70,32))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,45),T4sum(1:70,32))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,45),T4sum(1:70,32))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,7),T4sum(1:70,33))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,7),T4sum(1:70,33))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,33),T4sum(1:70,34))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,33),T4sum(1:70,34))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,46),T4sum(1:70,34))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,46),T4sum(1:70,34))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,55),T4sum(1:70,35))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,55),T4sum(1:70,35))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,62),T4sum(1:70,35))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,62),T4sum(1:70,35))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,69),T4sum(1:70,36))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,69),T4sum(1:70,36))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,76),T4sum(1:70,36))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,76),T4sum(1:70,36))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_6,G5tensor(:,17),T5sum(1:126,1))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_6,G5tensor(:,17),T5sum(1:126,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_6,G5tensor(:,19),T5sum(1:126,1))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_6,G5tensor(:,19),T5sum(1:126,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_5,G5tensor(:,21),T5sum(1:126,2))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_5,G5tensor(:,21),T5sum(1:126,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_5,G5tensor(:,23),T5sum(1:126,2))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_5,G5tensor(:,23),T5sum(1:126,2))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_6,G5tensor(:,5),T5sum(1:126,3))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_6,G5tensor(:,5),T5sum(1:126,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_6,G5tensor(:,1),T5sum(1:126,3))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_6,G5tensor(:,1),T5sum(1:126,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_5,G5tensor(:,13),T5sum(1:126,4))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_5,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_5,G5tensor(:,9),T5sum(1:126,4))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_5,G5tensor(:,9),T5sum(1:126,4))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_6,G5tensor(:,20),T5sum(1:126,5))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_6,G5tensor(:,20),T5sum(1:126,5))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_6,G5tensor(:,18),T5sum(1:126,5))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_6,G5tensor(:,18),T5sum(1:126,5))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_5,G5tensor(:,24),T5sum(1:126,6))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_5,G5tensor(:,24),T5sum(1:126,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_5,G5tensor(:,22),T5sum(1:126,6))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_5,G5tensor(:,22),T5sum(1:126,6))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_6,G5tensor(:,6),T5sum(1:126,7))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_6,G5tensor(:,6),T5sum(1:126,7))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_6,G5tensor(:,2),T5sum(1:126,7))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_6,G5tensor(:,2),T5sum(1:126,7))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_5,G5tensor(:,14),T5sum(1:126,8))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_5,G5tensor(:,14),T5sum(1:126,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_5,G5tensor(:,10),T5sum(1:126,8))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_5,G5tensor(:,10),T5sum(1:126,8))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,35),T5sum(1:126,9))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,35),T5sum(1:126,9))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,29),T5sum(1:126,9))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,29),T5sum(1:126,9))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_5,G5tensor(:,47),T5sum(1:126,10))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_5,G5tensor(:,47),T5sum(1:126,10))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_5,G5tensor(:,41),T5sum(1:126,10))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_5,G5tensor(:,41),T5sum(1:126,10))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,36),T5sum(1:126,11))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,36),T5sum(1:126,11))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,30),T5sum(1:126,11))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,30),T5sum(1:126,11))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_5,G5tensor(:,48),T5sum(1:126,12))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_5,G5tensor(:,48),T5sum(1:126,12))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_5,G5tensor(:,42),T5sum(1:126,12))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_5,G5tensor(:,42),T5sum(1:126,12))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_6,G5tensor(:,8),T5sum(1:126,13))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_6,G5tensor(:,8),T5sum(1:126,13))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_6,G5tensor(:,4),T5sum(1:126,13))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_6,G5tensor(:,4),T5sum(1:126,13))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_5,G5tensor(:,16),T5sum(1:126,14))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_5,G5tensor(:,16),T5sum(1:126,14))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_5,G5tensor(:,12),T5sum(1:126,14))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_5,G5tensor(:,12),T5sum(1:126,14))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_6,G5tensor(:,3),T5sum(1:126,15))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_6,G5tensor(:,3),T5sum(1:126,15))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_6,G5tensor(:,7),T5sum(1:126,15))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_6,G5tensor(:,7),T5sum(1:126,15))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_5,G5tensor(:,11),T5sum(1:126,16))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_5,G5tensor(:,11),T5sum(1:126,16))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_5,G5tensor(:,15),T5sum(1:126,16))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_5,G5tensor(:,15),T5sum(1:126,16))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_6,G5tensor(:,33),T5sum(1:126,17))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_6,G5tensor(:,33),T5sum(1:126,17))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_6,G5tensor(:,27),T5sum(1:126,17))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_6,G5tensor(:,27),T5sum(1:126,17))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_5,G5tensor(:,45),T5sum(1:126,18))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_5,G5tensor(:,45),T5sum(1:126,18))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_5,G5tensor(:,39),T5sum(1:126,18))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_5,G5tensor(:,39),T5sum(1:126,18))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_6,G5tensor(:,34),T5sum(1:126,19))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_6,G5tensor(:,34),T5sum(1:126,19))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_6,G5tensor(:,28),T5sum(1:126,19))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_6,G5tensor(:,28),T5sum(1:126,19))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_5,G5tensor(:,46),T5sum(1:126,20))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_5,G5tensor(:,46),T5sum(1:126,20))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_5,G5tensor(:,40),T5sum(1:126,20))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_5,G5tensor(:,40),T5sum(1:126,20))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_6,G5tensor(:,31),T5sum(1:126,21))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_6,G5tensor(:,31),T5sum(1:126,21))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_6,G5tensor(:,25),T5sum(1:126,21))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_6,G5tensor(:,25),T5sum(1:126,21))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_5,G5tensor(:,43),T5sum(1:126,22))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_5,G5tensor(:,43),T5sum(1:126,22))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_5,G5tensor(:,37),T5sum(1:126,22))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_5,G5tensor(:,37),T5sum(1:126,22))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_6,G5tensor(:,32),T5sum(1:126,23))
  M(11) = M(11) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_6,G5tensor(:,32),T5sum(1:126,23))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_6,G5tensor(:,26),T5sum(1:126,23))
  M(10) = M(10) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_6,G5tensor(:,26),T5sum(1:126,23))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_5,G5tensor(:,44),T5sum(1:126,24))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_5,G5tensor(:,44),T5sum(1:126,24))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_5,G5tensor(:,38),T5sum(1:126,24))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_5,G5tensor(:,38),T5sum(1:126,24))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,97),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,115),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,133),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,98),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,116),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,116),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,134),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,134),T3sum(1:35,4))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,58),T4sum(1:70,19))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,58),T4sum(1:70,19))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,65),T4sum(1:70,19))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,65),T4sum(1:70,19))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,72),T4sum(1:70,20))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,72),T4sum(1:70,20))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,79),T4sum(1:70,20))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,79),T4sum(1:70,20))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,99),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,117),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,135),T3sum(1:35,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,100),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,118),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,136),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,101),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,119),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,119),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,137),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,137),T3sum(1:35,4))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,59),T4sum(1:70,19))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,59),T4sum(1:70,19))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,66),T4sum(1:70,19))
  M(9) = M(9) + (f(8)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,66),T4sum(1:70,19))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,73),T4sum(1:70,20))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,73),T4sum(1:70,20))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,80),T4sum(1:70,20))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_3,G4tensor(:,80),T4sum(1:70,20))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,102),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,120),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,138),T3sum(1:35,4))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,10),T4sum(1:70,25))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,10),T4sum(1:70,25))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,23),T4sum(1:70,25))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,23),T4sum(1:70,25))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,36),T4sum(1:70,26))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,36),T4sum(1:70,26))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,49),T4sum(1:70,26))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,49),T4sum(1:70,26))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,4),T4sum(1:70,27))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,4),T4sum(1:70,27))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,17),T4sum(1:70,27))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,17),T4sum(1:70,27))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,30),T4sum(1:70,28))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,30),T4sum(1:70,28))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,43),T4sum(1:70,28))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,43),T4sum(1:70,28))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,11),T4sum(1:70,25))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,11),T4sum(1:70,25))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,24),T4sum(1:70,25))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,24),T4sum(1:70,25))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,37),T4sum(1:70,26))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,37),T4sum(1:70,26))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,50),T4sum(1:70,26))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_3,G4tensor(:,50),T4sum(1:70,26))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,5),T4sum(1:70,27))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,5),T4sum(1:70,27))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,18),T4sum(1:70,27))
  M(8) = M(8) + (f(8)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,18),T4sum(1:70,27))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,31),T4sum(1:70,28))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,31),T4sum(1:70,28))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,44),T4sum(1:70,28))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_3,G4tensor(:,44),T4sum(1:70,28))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(4) = M(4) + (-(f(8)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,185),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,185),T3sum(1:35,9))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,182),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,182),T3sum(1:35,9))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,191),T3sum(1:35,10))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,191),T3sum(1:35,10))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,188),T3sum(1:35,10))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,188),T3sum(1:35,10))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,186),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,186),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,183),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,183),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,192),T3sum(1:35,10))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,192),T3sum(1:35,10))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,189),T3sum(1:35,10))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,189),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(7))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,103),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,121),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,121),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,139),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,139),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(7))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,12),T4sum(1:70,31))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,12),T4sum(1:70,31))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,25),T4sum(1:70,31))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,25),T4sum(1:70,31))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,38),T4sum(1:70,32))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,38),T4sum(1:70,32))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,51),T4sum(1:70,32))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,51),T4sum(1:70,32))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,8),T4sum(1:70,33))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,8),T4sum(1:70,33))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,34),T4sum(1:70,34))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,34),T4sum(1:70,34))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,47),T4sum(1:70,34))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,47),T4sum(1:70,34))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,56),T4sum(1:70,35))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,56),T4sum(1:70,35))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,63),T4sum(1:70,35))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,63),T4sum(1:70,35))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,70),T4sum(1:70,36))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,70),T4sum(1:70,36))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,77),T4sum(1:70,36))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,77),T4sum(1:70,36))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(3) = M(3) + (-(f(8)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,104),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,122),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,140),T3sum(1:35,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(7))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,105),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,123),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,123),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,141),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,141),T3sum(1:35,4))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(7))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,13),T4sum(1:70,31))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,13),T4sum(1:70,31))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,26),T4sum(1:70,31))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,26),T4sum(1:70,31))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,39),T4sum(1:70,32))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,39),T4sum(1:70,32))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,52),T4sum(1:70,32))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_3,G4tensor(:,52),T4sum(1:70,32))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,9),T4sum(1:70,33))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,9),T4sum(1:70,33))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,35),T4sum(1:70,34))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,35),T4sum(1:70,34))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,48),T4sum(1:70,34))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,48),T4sum(1:70,34))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,57),T4sum(1:70,35))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,57),T4sum(1:70,35))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,64),T4sum(1:70,35))
  M(7) = M(7) + (f(8)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,64),T4sum(1:70,35))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,71),T4sum(1:70,36))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,71),T4sum(1:70,36))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,78),T4sum(1:70,36))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_3,G4tensor(:,78),T4sum(1:70,36))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(5) = M(5) + (-(f(8)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,106),T3sum(1:35,3))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,124),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,142),T3sum(1:35,4))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(6) = M(6) + (-(f(8)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(7))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(7))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,107),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,125),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,125),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,143),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,143),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(7))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(7))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,108),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,126),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,126),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,144),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,144),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(7))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(7))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(7))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_ddxhggg_2_/**/REALKIND
