
module ol_vamp_1_pphjjj2_ddxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_ddxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_ddxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_ddxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_ddxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,57) :: G0
  complex(REALKIND), dimension(4,5,4,254) :: G1
  complex(REALKIND), dimension(4,15,4,432) :: G2
  complex(REALKIND), dimension(4,35,4,192) :: G3
  complex(REALKIND), dimension(4,70,4,48) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,138,32))
    allocate(G4tensorhel(70,72,32))
    allocate(G5tensorhel(126,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,15),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,59),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,16),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,59),MT,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,59),MT,G2(:,:,:,5))
  call loop_AS_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,98),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,59),MT,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,12),MT,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,27),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,28),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,44),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,60),MT,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,1),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,102),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,59),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,24),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,27),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,59),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,40),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,24),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,59),MT,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,3))
  call loop_AS_Q(G2(:,:,:,17),wf(:,-2),G2(:,:,:,19),gH)
  call loop_A_Q(G2(:,:,:,19),Q(:,44),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,69),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,59),MT,G3(:,:,:,13))
  call loop_AS_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,17),wf(:,71),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,59),MT,G3(:,:,:,15))
  call loop_AS_Q(G3(:,:,:,15),wf(:,-2),G3(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,104),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,59),MT,G2(:,:,:,22))
  call loop_AS_Q(G2(:,:,:,22),wf(:,-2),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,19),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,43),MT,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-4),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,59),MT,G3(:,:,:,17))
  call loop_AS_Q(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,24),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,19),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,59),MT,G3(:,:,:,19))
  call loop_AS_Q(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,7))
  call loop_AS_Q(G2(:,:,:,26),wf(:,-2),G2(:,:,:,28),gH)
  call loop_A_Q(G2(:,:,:,28),Q(:,28),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-5),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,1),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G2(:,:,:,26),wf(:,73),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,59),MT,G3(:,:,:,23))
  call loop_AS_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,26),wf(:,74),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,59),MT,G3(:,:,:,25))
  call loop_AS_Q(G3(:,:,:,25),wf(:,-2),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,83),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,59),MT,G2(:,:,:,31))
  call loop_AS_Q(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,118),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,59),MT,G2(:,:,:,33))
  call loop_AS_Q(G2(:,:,:,33),wf(:,-2),G2(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,69),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,27),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,59),MT,G3(:,:,:,27))
  call loop_AS_Q(G3(:,:,:,27),wf(:,-2),G3(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,122),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,59),MT,G2(:,:,:,37))
  call loop_AS_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,87),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,59),MT,G2(:,:,:,39))
  call loop_AS_Q(G2(:,:,:,39),wf(:,-2),G2(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,124),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,59),MT,G2(:,:,:,41))
  call loop_AS_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,71),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,27),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,59),MT,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,128),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),MT,G2(:,:,:,45))
  call loop_AS_Q(G2(:,:,:,45),wf(:,-2),G2(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,133),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,59),MT,G2(:,:,:,47))
  call loop_AS_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,73),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,43),MT,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,59),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,-2),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,137),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),MT,G2(:,:,:,51))
  call loop_AS_Q(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,139),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),MT,G2(:,:,:,53))
  call loop_AS_Q(G2(:,:,:,53),wf(:,-2),G2(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,74),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,43),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-4),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,59),MT,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,-2),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,143),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,59),MT,G2(:,:,:,57))
  call loop_AS_Q(G2(:,:,:,57),wf(:,-2),G2(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,147),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),MT,G2(:,:,:,59))
  call loop_AS_Q(G2(:,:,:,59),wf(:,-2),G2(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,149),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,59),MT,G2(:,:,:,61))
  call loop_AS_Q(G2(:,:,:,61),wf(:,-2),G2(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,8),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,15),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,59),MT,G2(:,:,:,63))
  call loop_QS_A(G2(:,:,:,63),wf(:,-2),G2(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,29),wf(:,16),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,59),MT,G2(:,:,:,65))
  call loop_QS_A(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,29),wf(:,17),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,59),MT,G2(:,:,:,67))
  call loop_QS_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,29),wf(:,98),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,59),MT,G2(:,:,:,69))
  call loop_QS_A(G2(:,:,:,69),wf(:,-2),G2(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,22))
  call loop_QS_A(G1(:,:,:,29),wf(:,-2),G1(:,:,:,34),gH)
  call loop_Q_A(G1(:,:,:,34),Q(:,12),MT,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,27),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,60),MT,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,71),wf(:,-4),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,28),MT,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,60),MT,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,71),wf(:,-5),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,44),MT,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,60),MT,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,1),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,6))
  call loop_QV_A(G1(:,:,:,29),wf(:,102),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,59),MT,G2(:,:,:,75))
  call loop_QS_A(G2(:,:,:,75),wf(:,-2),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,29),wf(:,24),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,27),MT,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-5),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,59),MT,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,40),MT,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,24),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,59),MT,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,16))
  call loop_QS_A(G2(:,:,:,79),wf(:,-2),G2(:,:,:,81),gH)
  call loop_Q_A(G2(:,:,:,81),Q(:,44),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,60),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,1),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,79),wf(:,69),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,59),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,79),wf(:,71),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,59),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,-2),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G1(:,:,:,29),wf(:,104),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,59),MT,G2(:,:,:,84))
  call loop_QS_A(G2(:,:,:,84),wf(:,-2),G2(:,:,:,85),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,29),wf(:,19),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,43),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,59),MT,G3(:,:,:,51))
  call loop_QS_A(G3(:,:,:,51),wf(:,-2),G3(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,24),MT,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,19),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,59),MT,G3(:,:,:,53))
  call loop_QS_A(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,20))
  call loop_QS_A(G2(:,:,:,88),wf(:,-2),G2(:,:,:,90),gH)
  call loop_Q_A(G2(:,:,:,90),Q(:,28),MT,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-5),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,60),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,1),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,88),wf(:,73),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,59),MT,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,-2),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G2(:,:,:,88),wf(:,74),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,59),MT,G3(:,:,:,59))
  call loop_QS_A(G3(:,:,:,59),wf(:,-2),G3(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,29),wf(:,83),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,59),MT,G2(:,:,:,93))
  call loop_QS_A(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,29),wf(:,118),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,59),MT,G2(:,:,:,95))
  call loop_QS_A(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,29),wf(:,69),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,27),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,59),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,29),wf(:,122),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,59),MT,G2(:,:,:,99))
  call loop_QS_A(G2(:,:,:,99),wf(:,-2),G2(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,29),wf(:,87),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,59),MT,G2(:,:,:,101))
  call loop_QS_A(G2(:,:,:,101),wf(:,-2),G2(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,29),wf(:,124),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,59),MT,G2(:,:,:,103))
  call loop_QS_A(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,71),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,27),MT,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,59),MT,G3(:,:,:,63))
  call loop_QS_A(G3(:,:,:,63),wf(:,-2),G3(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,29),wf(:,128),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,59),MT,G2(:,:,:,107))
  call loop_QS_A(G2(:,:,:,107),wf(:,-2),G2(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,29),wf(:,133),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,59),MT,G2(:,:,:,109))
  call loop_QS_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,29),wf(:,73),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,43),MT,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,59),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,29),wf(:,137),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,59),MT,G2(:,:,:,113))
  call loop_QS_A(G2(:,:,:,113),wf(:,-2),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,29),wf(:,139),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,59),MT,G2(:,:,:,115))
  call loop_QS_A(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,29),wf(:,74),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,43),MT,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,59),MT,G3(:,:,:,67))
  call loop_QS_A(G3(:,:,:,67),wf(:,-2),G3(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,29),wf(:,143),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),MT,G2(:,:,:,119))
  call loop_QS_A(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,29),wf(:,147),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,59),MT,G2(:,:,:,121))
  call loop_QS_A(G2(:,:,:,121),wf(:,-2),G2(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,122),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,29),wf(:,149),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,59),MT,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MT,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,11),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,59),MT,G2(:,:,:,125))
  call loop_AS_Q(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,57),wf(:,12),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,59),MT,G2(:,:,:,127))
  call loop_AS_Q(G2(:,:,:,127),wf(:,-2),G2(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,57),wf(:,13),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),MT,G2(:,:,:,129))
  call loop_AS_Q(G2(:,:,:,129),wf(:,-2),G2(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,57),wf(:,97),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,59),MT,G2(:,:,:,131))
  call loop_AS_Q(G2(:,:,:,131),wf(:,-2),G2(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),MT,G3tensor(:,40))
  call loop_AS_Q(G1(:,:,:,57),wf(:,-2),G1(:,:,:,62),gH)
  call loop_A_Q(G1(:,:,:,62),Q(:,20),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,23),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,60),MT,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,1),G3(:,:,:,70))
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),MT,G4tensor(:,27))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-3),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,28),MT,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,60),MT,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,1),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MT,G5tensor(:,9))
  call loop_AV_Q(G1(:,:,:,57),wf(:,100),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,59),MT,G2(:,:,:,136))
  call loop_AS_Q(G2(:,:,:,136),wf(:,-2),G2(:,:,:,137),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,57),wf(:,28),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,27),MT,G2(:,:,:,138))
  call loop_AV_Q(G2(:,:,:,138),wf(:,-5),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,59),MT,G3(:,:,:,73))
  call loop_AS_Q(G3(:,:,:,73),wf(:,-2),G3(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,28))
  call loop_AV_Q(G1(:,:,:,57),wf(:,103),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,59),MT,G2(:,:,:,140))
  call loop_AS_Q(G2(:,:,:,140),wf(:,-2),G2(:,:,:,141),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,63),MT,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-3),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,24),MT,G2(:,:,:,142))
  call loop_AV_Q(G2(:,:,:,142),wf(:,19),G2(:,:,:,143))
  call loop_A_Q(G2(:,:,:,143),Q(:,59),MT,G3(:,:,:,75))
  call loop_AS_Q(G3(:,:,:,75),wf(:,-2),G3(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,29))
  call loop_AS_Q(G2(:,:,:,142),wf(:,-2),G2(:,:,:,144),gH)
  call loop_A_Q(G2(:,:,:,144),Q(:,28),MT,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-5),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,60),MT,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,1),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MT,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,142),wf(:,73),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,59),MT,G3(:,:,:,79))
  call loop_AS_Q(G3(:,:,:,79),wf(:,-2),G3(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,63),MT,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,142),wf(:,74),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,59),MT,G3(:,:,:,81))
  call loop_AS_Q(G3(:,:,:,81),wf(:,-2),G3(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,57),wf(:,50),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,59),MT,G2(:,:,:,147))
  call loop_AS_Q(G2(:,:,:,147),wf(:,-2),G2(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),MT,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,57),wf(:,106),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,59),MT,G2(:,:,:,149))
  call loop_AS_Q(G2(:,:,:,149),wf(:,-2),G2(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,63),MT,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,57),wf(:,44),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,27),MT,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-5),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,59),MT,G3(:,:,:,83))
  call loop_AS_Q(G3(:,:,:,83),wf(:,-2),G3(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MT,G4tensor(:,32))
  call loop_AV_Q(G1(:,:,:,57),wf(:,110),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,59),MT,G2(:,:,:,153))
  call loop_AS_Q(G2(:,:,:,153),wf(:,-2),G2(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),MT,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,57),wf(:,65),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,59),MT,G2(:,:,:,155))
  call loop_AS_Q(G2(:,:,:,155),wf(:,-2),G2(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),MT,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,57),wf(:,112),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,59),MT,G2(:,:,:,157))
  call loop_AS_Q(G2(:,:,:,157),wf(:,-2),G2(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MT,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,57),wf(:,59),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,27),MT,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,59),MT,G3(:,:,:,85))
  call loop_AS_Q(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),MT,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,57),wf(:,116),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,59),MT,G2(:,:,:,161))
  call loop_AS_Q(G2(:,:,:,161),wf(:,-2),G2(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,57),wf(:,132),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,59),MT,G2(:,:,:,163))
  call loop_AS_Q(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MT,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,57),wf(:,135),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),MT,G2(:,:,:,165))
  call loop_AS_Q(G2(:,:,:,165),wf(:,-2),G2(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,166),Q(:,63),MT,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,57),wf(:,138),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,59),MT,G2(:,:,:,167))
  call loop_AS_Q(G2(:,:,:,167),wf(:,-2),G2(:,:,:,168),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,168),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,57),wf(:,141),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,59),MT,G2(:,:,:,169))
  call loop_AS_Q(G2(:,:,:,169),wf(:,-2),G2(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,170),Q(:,63),MT,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,57),wf(:,144),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,59),MT,G2(:,:,:,171))
  call loop_AS_Q(G2(:,:,:,171),wf(:,-2),G2(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,63),MT,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,57),wf(:,146),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,59),MT,G2(:,:,:,173))
  call loop_AS_Q(G2(:,:,:,173),wf(:,-2),G2(:,:,:,174),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,174),Q(:,63),MT,G3tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,11),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,59),MT,G2(:,:,:,175))
  call loop_QS_A(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,176),Q(:,63),MT,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,81),wf(:,12),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,59),MT,G2(:,:,:,177))
  call loop_QS_A(G2(:,:,:,177),wf(:,-2),G2(:,:,:,178),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,178),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,81),wf(:,13),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,59),MT,G2(:,:,:,179))
  call loop_QS_A(G2(:,:,:,179),wf(:,-2),G2(:,:,:,180),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,180),Q(:,63),MT,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,81),wf(:,97),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,59),MT,G2(:,:,:,181))
  call loop_QS_A(G2(:,:,:,181),wf(:,-2),G2(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,182),Q(:,63),MT,G3tensor(:,58))
  call loop_QS_A(G1(:,:,:,81),wf(:,-2),G1(:,:,:,86),gH)
  call loop_Q_A(G1(:,:,:,86),Q(:,20),MT,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,23),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,60),MT,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,1),G3(:,:,:,88))
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,183),wf(:,-3),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,28),MT,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,60),MT,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MT,G5tensor(:,11))
  call loop_QV_A(G1(:,:,:,81),wf(:,100),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,59),MT,G2(:,:,:,186))
  call loop_QS_A(G2(:,:,:,186),wf(:,-2),G2(:,:,:,187),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,187),Q(:,63),MT,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,81),wf(:,28),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,27),MT,G2(:,:,:,188))
  call loop_QV_A(G2(:,:,:,188),wf(:,-5),G2(:,:,:,189))
  call loop_Q_A(G2(:,:,:,189),Q(:,59),MT,G3(:,:,:,91))
  call loop_QS_A(G3(:,:,:,91),wf(:,-2),G3(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,81),wf(:,103),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,59),MT,G2(:,:,:,190))
  call loop_QS_A(G2(:,:,:,190),wf(:,-2),G2(:,:,:,191),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,191),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,81),wf(:,-3),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,24),MT,G2(:,:,:,192))
  call loop_QV_A(G2(:,:,:,192),wf(:,19),G2(:,:,:,193))
  call loop_Q_A(G2(:,:,:,193),Q(:,59),MT,G3(:,:,:,93))
  call loop_QS_A(G3(:,:,:,93),wf(:,-2),G3(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,63),MT,G4tensor(:,36))
  call loop_QS_A(G2(:,:,:,192),wf(:,-2),G2(:,:,:,194),gH)
  call loop_Q_A(G2(:,:,:,194),Q(:,28),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-5),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,60),MT,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,1),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MT,G5tensor(:,12))
  call loop_QV_A(G2(:,:,:,192),wf(:,73),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,59),MT,G3(:,:,:,97))
  call loop_QS_A(G3(:,:,:,97),wf(:,-2),G3(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,63),MT,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,192),wf(:,74),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,59),MT,G3(:,:,:,99))
  call loop_QS_A(G3(:,:,:,99),wf(:,-2),G3(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),MT,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,81),wf(:,50),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,59),MT,G2(:,:,:,197))
  call loop_QS_A(G2(:,:,:,197),wf(:,-2),G2(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,81),wf(:,106),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,59),MT,G2(:,:,:,199))
  call loop_QS_A(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,81),wf(:,44),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,27),MT,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-5),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,59),MT,G3(:,:,:,101))
  call loop_QS_A(G3(:,:,:,101),wf(:,-2),G3(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,81),wf(:,110),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,59),MT,G2(:,:,:,203))
  call loop_QS_A(G2(:,:,:,203),wf(:,-2),G2(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,81),wf(:,65),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,59),MT,G2(:,:,:,205))
  call loop_QS_A(G2(:,:,:,205),wf(:,-2),G2(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,206),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G1(:,:,:,81),wf(:,112),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,59),MT,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,-2),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,81),wf(:,59),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,27),MT,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,59),MT,G3(:,:,:,103))
  call loop_QS_A(G3(:,:,:,103),wf(:,-2),G3(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,63),MT,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,81),wf(:,116),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,59),MT,G2(:,:,:,211))
  call loop_QS_A(G2(:,:,:,211),wf(:,-2),G2(:,:,:,212),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,212),Q(:,63),MT,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,81),wf(:,132),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,59),MT,G2(:,:,:,213))
  call loop_QS_A(G2(:,:,:,213),wf(:,-2),G2(:,:,:,214),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,214),Q(:,63),MT,G3tensor(:,67))
  call loop_QV_A(G1(:,:,:,81),wf(:,135),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,59),MT,G2(:,:,:,215))
  call loop_QS_A(G2(:,:,:,215),wf(:,-2),G2(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,81),wf(:,138),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,59),MT,G2(:,:,:,217))
  call loop_QS_A(G2(:,:,:,217),wf(:,-2),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,81),wf(:,141),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,59),MT,G2(:,:,:,219))
  call loop_QS_A(G2(:,:,:,219),wf(:,-2),G2(:,:,:,220),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,81),wf(:,144),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,59),MT,G2(:,:,:,221))
  call loop_QS_A(G2(:,:,:,221),wf(:,-2),G2(:,:,:,222),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,63),MT,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,81),wf(:,146),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,59),MT,G2(:,:,:,223))
  call loop_QS_A(G2(:,:,:,223),wf(:,-2),G2(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,27),MT,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,59),MT,G2(:,:,:,225))
  call loop_QS_A(G2(:,:,:,225),wf(:,-2),G2(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,27),MT,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,59),MT,G2(:,:,:,227))
  call loop_QS_A(G2(:,:,:,227),wf(:,-2),G2(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,228),Q(:,63),MT,G3tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,27),MT,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,-5),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,59),MT,G2(:,:,:,229))
  call loop_QS_A(G2(:,:,:,229),wf(:,-2),G2(:,:,:,230),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,230),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,27),MT,G1(:,:,:,111))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,59),MT,G2(:,:,:,231))
  call loop_AS_Q(G2(:,:,:,231),wf(:,-2),G2(:,:,:,232),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,63),MT,G3tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,27),MT,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,59),MT,G2(:,:,:,233))
  call loop_AS_Q(G2(:,:,:,233),wf(:,-2),G2(:,:,:,234),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,234),Q(:,63),MT,G3tensor(:,77))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,27),MT,G1(:,:,:,115))
  call loop_AV_Q(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,59),MT,G2(:,:,:,235))
  call loop_AS_Q(G2(:,:,:,235),wf(:,-2),G2(:,:,:,236),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,236),Q(:,63),MT,G3tensor(:,78))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12),gH)
  call loop_Q_A(G0(:,:,:,12),Q(:,4),MT,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,2),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,60),MT,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,1),G2(:,:,:,238))
  call check_last_Q_A(l_switch,G2(:,:,:,238),Q(:,63),MT,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,117),wf(:,4),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,60),MT,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,1),G2(:,:,:,240))
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,63),MT,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,117),wf(:,5),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,60),MT,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,1),G2(:,:,:,242))
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,63),MT,G3tensor(:,81))
  call loop_QV_A(G1(:,:,:,117),wf(:,21),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,60),MT,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,1),G2(:,:,:,244))
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MT,G3tensor(:,82))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,36),MT,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,18),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,60),MT,G3(:,:,:,105))
  call loop_QV_A(G3(:,:,:,105),wf(:,1),G3(:,:,:,106))
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,63),MT,G4tensor(:,41))
  call loop_QV_A(G2(:,:,:,245),wf(:,-3),G2(:,:,:,247))
  call loop_Q_A(G2(:,:,:,247),Q(:,44),MT,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,60),MT,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MT,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,245),wf(:,-4),G2(:,:,:,248))
  call loop_Q_A(G2(:,:,:,248),Q(:,52),MT,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-3),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,60),MT,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,1),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MT,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,117),wf(:,18),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,28),MT,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,-5),G2(:,:,:,250))
  call loop_Q_A(G2(:,:,:,250),Q(:,60),MT,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,1),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MT,G4tensor(:,42))
  call loop_QV_A(G1(:,:,:,117),wf(:,26),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,60),MT,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,1),G2(:,:,:,252))
  call check_last_Q_A(l_switch,G2(:,:,:,252),Q(:,63),MT,G3tensor(:,83))
  call loop_QV_A(G1(:,:,:,117),wf(:,-4),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,20),MT,G2(:,:,:,253))
  call loop_QV_A(G2(:,:,:,253),wf(:,23),G2(:,:,:,254))
  call loop_Q_A(G2(:,:,:,254),Q(:,60),MT,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,1),G3(:,:,:,114))
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,63),MT,G4tensor(:,43))
  call loop_QV_A(G2(:,:,:,253),wf(:,-3),G2(:,:,:,255))
  call loop_Q_A(G2(:,:,:,255),Q(:,28),MT,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,-5),G3(:,:,:,116))
  call loop_Q_A(G3(:,:,:,116),Q(:,60),MT,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,1),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),MT,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,253),wf(:,-5),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,52),MT,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-3),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,60),MT,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MT,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,117),wf(:,23),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,44),MT,G2(:,:,:,257))
  call loop_QV_A(G2(:,:,:,257),wf(:,-4),G2(:,:,:,258))
  call loop_Q_A(G2(:,:,:,258),Q(:,60),MT,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,1),G3(:,:,:,120))
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MT,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,117),wf(:,30),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,60),MT,G2(:,:,:,259))
  call loop_QV_A(G2(:,:,:,259),wf(:,1),G2(:,:,:,260))
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,117),wf(:,-3),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,12),MT,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,27),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,60),MT,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,1),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,63),MT,G4tensor(:,45))
  call loop_QV_A(G2(:,:,:,261),wf(:,-4),G2(:,:,:,263))
  call loop_Q_A(G2(:,:,:,263),Q(:,28),MT,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-5),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,60),MT,G4(:,:,:,33))
  call loop_QV_A(G4(:,:,:,33),wf(:,1),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,261),wf(:,-5),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,44),MT,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-4),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,60),MT,G4(:,:,:,35))
  call loop_QV_A(G4(:,:,:,35),wf(:,1),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G1(:,:,:,117),wf(:,27),G1(:,:,:,129))
  call loop_Q_A(G1(:,:,:,129),Q(:,52),MT,G2(:,:,:,265))
  call loop_QV_A(G2(:,:,:,265),wf(:,-3),G2(:,:,:,266))
  call loop_Q_A(G2(:,:,:,266),Q(:,60),MT,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,1),G3(:,:,:,128))
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,63),MT,G4tensor(:,46))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13),gH)
  call loop_A_Q(G0(:,:,:,13),Q(:,4),MT,G1(:,:,:,130))
  call loop_AV_Q(G1(:,:,:,130),wf(:,2),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,60),MT,G2(:,:,:,267))
  call loop_AV_Q(G2(:,:,:,267),wf(:,1),G2(:,:,:,268))
  call check_last_A_Q(l_switch,G2(:,:,:,268),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,130),wf(:,4),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,60),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,1),G2(:,:,:,270))
  call check_last_A_Q(l_switch,G2(:,:,:,270),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,130),wf(:,5),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,60),MT,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,1),G2(:,:,:,272))
  call check_last_A_Q(l_switch,G2(:,:,:,272),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,130),wf(:,21),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,60),MT,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,1),G2(:,:,:,274))
  call check_last_A_Q(l_switch,G2(:,:,:,274),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,130),wf(:,-5),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,36),MT,G2(:,:,:,275))
  call loop_AV_Q(G2(:,:,:,275),wf(:,18),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,60),MT,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,1),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,63),MT,G4tensor(:,47))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-3),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,44),MT,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,60),MT,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,1),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-4),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,52),MT,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-3),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,60),MT,G4(:,:,:,39))
  call loop_AV_Q(G4(:,:,:,39),wf(:,1),G4(:,:,:,40))
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,130),wf(:,18),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,28),MT,G2(:,:,:,279))
  call loop_AV_Q(G2(:,:,:,279),wf(:,-5),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,60),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,1),G3(:,:,:,136))
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,63),MT,G4tensor(:,48))
  call loop_AV_Q(G1(:,:,:,130),wf(:,26),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,60),MT,G2(:,:,:,281))
  call loop_AV_Q(G2(:,:,:,281),wf(:,1),G2(:,:,:,282))
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,63),MT,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,130),wf(:,-4),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,20),MT,G2(:,:,:,283))
  call loop_AV_Q(G2(:,:,:,283),wf(:,23),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,60),MT,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,1),G3(:,:,:,138))
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,49))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-3),G2(:,:,:,285))
  call loop_A_Q(G2(:,:,:,285),Q(:,28),MT,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-5),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,60),MT,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,1),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MT,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-5),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,52),MT,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,60),MT,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,1),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MT,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,130),wf(:,23),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,44),MT,G2(:,:,:,287))
  call loop_AV_Q(G2(:,:,:,287),wf(:,-4),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,60),MT,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,1),G3(:,:,:,144))
  call check_last_A_Q(l_switch,G3(:,:,:,144),Q(:,63),MT,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,130),wf(:,30),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,60),MT,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,1),G2(:,:,:,290))
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,90))
  call loop_AV_Q(G1(:,:,:,130),wf(:,-3),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,12),MT,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,27),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,60),MT,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,1),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,51))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-4),G2(:,:,:,293))
  call loop_A_Q(G2(:,:,:,293),Q(:,28),MT,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-5),G3(:,:,:,148))
  call loop_A_Q(G3(:,:,:,148),Q(:,60),MT,G4(:,:,:,45))
  call loop_AV_Q(G4(:,:,:,45),wf(:,1),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-5),G2(:,:,:,294))
  call loop_A_Q(G2(:,:,:,294),Q(:,44),MT,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-4),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,60),MT,G4(:,:,:,47))
  call loop_AV_Q(G4(:,:,:,47),wf(:,1),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),MT,G5tensor(:,24))
  call loop_AV_Q(G1(:,:,:,130),wf(:,27),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,52),MT,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-3),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,60),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,1),G3(:,:,:,152))
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,63),MT,G4tensor(:,52))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,24),MT,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,19),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,59),MT,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,-2),G2(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,91))
  call loop_AS_Q(G1(:,:,:,143),wf(:,-2),G1(:,:,:,145),gH)
  call loop_A_Q(G1(:,:,:,145),Q(:,28),MT,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-5),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,60),MT,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,1),G3(:,:,:,154))
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,63),MT,G4tensor(:,53))
  call loop_AV_Q(G1(:,:,:,143),wf(:,73),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,59),MT,G2(:,:,:,301))
  call loop_AS_Q(G2(:,:,:,301),wf(:,-2),G2(:,:,:,302),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G1(:,:,:,143),wf(:,74),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,59),MT,G2(:,:,:,303))
  call loop_AS_Q(G2(:,:,:,303),wf(:,-2),G2(:,:,:,304),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,304),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,24),MT,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,19),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,59),MT,G2(:,:,:,305))
  call loop_QS_A(G2(:,:,:,305),wf(:,-2),G2(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,63),MT,G3tensor(:,94))
  call loop_QS_A(G1(:,:,:,148),wf(:,-2),G1(:,:,:,150),gH)
  call loop_Q_A(G1(:,:,:,150),Q(:,28),MT,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-5),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,60),MT,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,1),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),MT,G4tensor(:,54))
  call loop_QV_A(G1(:,:,:,148),wf(:,73),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,59),MT,G2(:,:,:,309))
  call loop_QS_A(G2(:,:,:,309),wf(:,-2),G2(:,:,:,310),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,63),MT,G3tensor(:,95))
  call loop_QV_A(G1(:,:,:,148),wf(:,74),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,59),MT,G2(:,:,:,311))
  call loop_QS_A(G2(:,:,:,311),wf(:,-2),G2(:,:,:,312),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,63),MT,G3tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,27),MT,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,59),MT,G2(:,:,:,313))
  call loop_QS_A(G2(:,:,:,313),wf(:,-2),G2(:,:,:,314),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,314),Q(:,63),MT,G3tensor(:,97))
  call loop_AV_Q(G0(:,:,:,1),wf(:,96),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,27),MT,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,59),MT,G2(:,:,:,315))
  call loop_AS_Q(G2(:,:,:,315),wf(:,-2),G2(:,:,:,316),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,316),Q(:,63),MT,G3tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,19),MT,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,23),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,59),MT,G2(:,:,:,317))
  call loop_QS_A(G2(:,:,:,317),wf(:,-2),G2(:,:,:,318),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,318),Q(:,63),MT,G3tensor(:,99))
  call loop_QV_A(G1(:,:,:,157),wf(:,-3),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,27),MT,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,59),MT,G3(:,:,:,157))
  call loop_QS_A(G3(:,:,:,157),wf(:,-2),G3(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,19),MT,G1(:,:,:,160))
  call loop_AV_Q(G1(:,:,:,160),wf(:,23),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,59),MT,G2(:,:,:,321))
  call loop_AS_Q(G2(:,:,:,321),wf(:,-2),G2(:,:,:,322),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,322),Q(:,63),MT,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,160),wf(:,-3),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,27),MT,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-5),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,59),MT,G3(:,:,:,159))
  call loop_AS_Q(G3(:,:,:,159),wf(:,-2),G3(:,:,:,160),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,63),MT,G4tensor(:,56))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,11),MT,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,27),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,59),MT,G2(:,:,:,325))
  call loop_AS_Q(G2(:,:,:,325),wf(:,-2),G2(:,:,:,326),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,326),Q(:,63),MT,G3tensor(:,101))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-5),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,43),MT,G2(:,:,:,327))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-4),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,59),MT,G3(:,:,:,161))
  call loop_AS_Q(G3(:,:,:,161),wf(:,-2),G3(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),MT,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-4),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,27),MT,G2(:,:,:,329))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-5),G2(:,:,:,330))
  call loop_A_Q(G2(:,:,:,330),Q(:,59),MT,G3(:,:,:,163))
  call loop_AS_Q(G3(:,:,:,163),wf(:,-2),G3(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,63),MT,G4tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,11),MT,G1(:,:,:,167))
  call loop_QV_A(G1(:,:,:,167),wf(:,27),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,59),MT,G2(:,:,:,331))
  call loop_QS_A(G2(:,:,:,331),wf(:,-2),G2(:,:,:,332),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,332),Q(:,63),MT,G3tensor(:,102))
  call loop_QV_A(G1(:,:,:,167),wf(:,-5),G1(:,:,:,169))
  call loop_Q_A(G1(:,:,:,169),Q(:,43),MT,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,-4),G2(:,:,:,334))
  call loop_Q_A(G2(:,:,:,334),Q(:,59),MT,G3(:,:,:,165))
  call loop_QS_A(G3(:,:,:,165),wf(:,-2),G3(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,59))
  call loop_QV_A(G1(:,:,:,167),wf(:,-4),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,27),MT,G2(:,:,:,335))
  call loop_QV_A(G2(:,:,:,335),wf(:,-5),G2(:,:,:,336))
  call loop_Q_A(G2(:,:,:,336),Q(:,59),MT,G3(:,:,:,167))
  call loop_QS_A(G3(:,:,:,167),wf(:,-2),G3(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,99),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,27),MT,G1(:,:,:,171))
  call loop_QV_A(G1(:,:,:,171),wf(:,-5),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,59),MT,G2(:,:,:,337))
  call loop_QS_A(G2(:,:,:,337),wf(:,-2),G2(:,:,:,338),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),MT,G3tensor(:,103))
  call loop_AV_Q(G0(:,:,:,1),wf(:,99),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,27),MT,G1(:,:,:,173))
  call loop_AV_Q(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,59),MT,G2(:,:,:,339))
  call loop_AS_Q(G2(:,:,:,339),wf(:,-2),G2(:,:,:,340),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,340),Q(:,63),MT,G3tensor(:,104))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,27),MT,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,59),MT,G2(:,:,:,341))
  call loop_QS_A(G2(:,:,:,341),wf(:,-2),G2(:,:,:,342),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,27),MT,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,59),MT,G2(:,:,:,343))
  call loop_AS_Q(G2(:,:,:,343),wf(:,-2),G2(:,:,:,344),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,344),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,27),MT,G1(:,:,:,179))
  call loop_QV_A(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,59),MT,G2(:,:,:,345))
  call loop_QS_A(G2(:,:,:,345),wf(:,-2),G2(:,:,:,346),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,346),Q(:,63),MT,G3tensor(:,107))
  call loop_AV_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,27),MT,G1(:,:,:,181))
  call loop_AV_Q(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,59),MT,G2(:,:,:,347))
  call loop_AS_Q(G2(:,:,:,347),wf(:,-2),G2(:,:,:,348),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,348),Q(:,63),MT,G3tensor(:,108))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,11),MT,G1(:,:,:,183))
  call loop_AV_Q(G1(:,:,:,183),wf(:,27),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,59),MT,G2(:,:,:,349))
  call loop_AS_Q(G2(:,:,:,349),wf(:,-2),G2(:,:,:,350),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,350),Q(:,63),MT,G3tensor(:,109))
  call loop_AV_Q(G1(:,:,:,183),wf(:,-5),G1(:,:,:,185))
  call loop_A_Q(G1(:,:,:,185),Q(:,43),MT,G2(:,:,:,351))
  call loop_AV_Q(G2(:,:,:,351),wf(:,-4),G2(:,:,:,352))
  call loop_A_Q(G2(:,:,:,352),Q(:,59),MT,G3(:,:,:,169))
  call loop_AS_Q(G3(:,:,:,169),wf(:,-2),G3(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,61))
  call loop_AV_Q(G1(:,:,:,183),wf(:,-4),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,27),MT,G2(:,:,:,353))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-5),G2(:,:,:,354))
  call loop_A_Q(G2(:,:,:,354),Q(:,59),MT,G3(:,:,:,171))
  call loop_AS_Q(G3(:,:,:,171),wf(:,-2),G3(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,11),MT,G1(:,:,:,187))
  call loop_QV_A(G1(:,:,:,187),wf(:,27),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,59),MT,G2(:,:,:,355))
  call loop_QS_A(G2(:,:,:,355),wf(:,-2),G2(:,:,:,356),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,356),Q(:,63),MT,G3tensor(:,110))
  call loop_QV_A(G1(:,:,:,187),wf(:,-5),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,43),MT,G2(:,:,:,357))
  call loop_QV_A(G2(:,:,:,357),wf(:,-4),G2(:,:,:,358))
  call loop_Q_A(G2(:,:,:,358),Q(:,59),MT,G3(:,:,:,173))
  call loop_QS_A(G3(:,:,:,173),wf(:,-2),G3(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,187),wf(:,-4),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,27),MT,G2(:,:,:,359))
  call loop_QV_A(G2(:,:,:,359),wf(:,-5),G2(:,:,:,360))
  call loop_Q_A(G2(:,:,:,360),Q(:,59),MT,G3(:,:,:,175))
  call loop_QS_A(G3(:,:,:,175),wf(:,-2),G3(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,105),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,27),MT,G1(:,:,:,191))
  call loop_QV_A(G1(:,:,:,191),wf(:,-5),G1(:,:,:,192))
  call loop_Q_A(G1(:,:,:,192),Q(:,59),MT,G2(:,:,:,361))
  call loop_QS_A(G2(:,:,:,361),wf(:,-2),G2(:,:,:,362),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,362),Q(:,63),MT,G3tensor(:,111))
  call loop_AV_Q(G0(:,:,:,1),wf(:,105),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,27),MT,G1(:,:,:,193))
  call loop_AV_Q(G1(:,:,:,193),wf(:,-5),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,59),MT,G2(:,:,:,363))
  call loop_AS_Q(G2(:,:,:,363),wf(:,-2),G2(:,:,:,364),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,364),Q(:,63),MT,G3tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,27),MT,G1(:,:,:,195))
  call loop_QV_A(G1(:,:,:,195),wf(:,-5),G1(:,:,:,196))
  call loop_Q_A(G1(:,:,:,196),Q(:,59),MT,G2(:,:,:,365))
  call loop_QS_A(G2(:,:,:,365),wf(:,-2),G2(:,:,:,366),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,366),Q(:,63),MT,G3tensor(:,113))
  call loop_AV_Q(G0(:,:,:,1),wf(:,108),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,27),MT,G1(:,:,:,197))
  call loop_AV_Q(G1(:,:,:,197),wf(:,-5),G1(:,:,:,198))
  call loop_A_Q(G1(:,:,:,198),Q(:,59),MT,G2(:,:,:,367))
  call loop_AS_Q(G2(:,:,:,367),wf(:,-2),G2(:,:,:,368),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,368),Q(:,63),MT,G3tensor(:,114))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,27),MT,G1(:,:,:,199))
  call loop_QV_A(G1(:,:,:,199),wf(:,-5),G1(:,:,:,200))
  call loop_Q_A(G1(:,:,:,200),Q(:,59),MT,G2(:,:,:,369))
  call loop_QS_A(G2(:,:,:,369),wf(:,-2),G2(:,:,:,370),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,370),Q(:,63),MT,G3tensor(:,115))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,27),MT,G1(:,:,:,201))
  call loop_AV_Q(G1(:,:,:,201),wf(:,-5),G1(:,:,:,202))
  call loop_A_Q(G1(:,:,:,202),Q(:,59),MT,G2(:,:,:,371))
  call loop_AS_Q(G2(:,:,:,371),wf(:,-2),G2(:,:,:,372),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,372),Q(:,63),MT,G3tensor(:,116))
  call loop_AV_Q(G0(:,:,:,1),wf(:,59),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,11),MT,G1(:,:,:,203))
  call loop_AV_Q(G1(:,:,:,203),wf(:,27),G1(:,:,:,204))
  call loop_A_Q(G1(:,:,:,204),Q(:,59),MT,G2(:,:,:,373))
  call loop_AS_Q(G2(:,:,:,373),wf(:,-2),G2(:,:,:,374),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,374),Q(:,63),MT,G3tensor(:,117))
  call loop_AV_Q(G1(:,:,:,203),wf(:,-5),G1(:,:,:,205))
  call loop_A_Q(G1(:,:,:,205),Q(:,43),MT,G2(:,:,:,375))
  call loop_AV_Q(G2(:,:,:,375),wf(:,-4),G2(:,:,:,376))
  call loop_A_Q(G2(:,:,:,376),Q(:,59),MT,G3(:,:,:,177))
  call loop_AS_Q(G3(:,:,:,177),wf(:,-2),G3(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,63),MT,G4tensor(:,65))
  call loop_AV_Q(G1(:,:,:,203),wf(:,-4),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,27),MT,G2(:,:,:,377))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-5),G2(:,:,:,378))
  call loop_A_Q(G2(:,:,:,378),Q(:,59),MT,G3(:,:,:,179))
  call loop_AS_Q(G3(:,:,:,179),wf(:,-2),G3(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),MT,G4tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,11),MT,G1(:,:,:,207))
  call loop_QV_A(G1(:,:,:,207),wf(:,27),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,59),MT,G2(:,:,:,379))
  call loop_QS_A(G2(:,:,:,379),wf(:,-2),G2(:,:,:,380),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,380),Q(:,63),MT,G3tensor(:,118))
  call loop_QV_A(G1(:,:,:,207),wf(:,-5),G1(:,:,:,209))
  call loop_Q_A(G1(:,:,:,209),Q(:,43),MT,G2(:,:,:,381))
  call loop_QV_A(G2(:,:,:,381),wf(:,-4),G2(:,:,:,382))
  call loop_Q_A(G2(:,:,:,382),Q(:,59),MT,G3(:,:,:,181))
  call loop_QS_A(G3(:,:,:,181),wf(:,-2),G3(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,63),MT,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,207),wf(:,-4),G1(:,:,:,210))
  call loop_Q_A(G1(:,:,:,210),Q(:,27),MT,G2(:,:,:,383))
  call loop_QV_A(G2(:,:,:,383),wf(:,-5),G2(:,:,:,384))
  call loop_Q_A(G2(:,:,:,384),Q(:,59),MT,G3(:,:,:,183))
  call loop_QS_A(G3(:,:,:,183),wf(:,-2),G3(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,63),MT,G4tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,27),MT,G1(:,:,:,211))
  call loop_QV_A(G1(:,:,:,211),wf(:,-5),G1(:,:,:,212))
  call loop_Q_A(G1(:,:,:,212),Q(:,59),MT,G2(:,:,:,385))
  call loop_QS_A(G2(:,:,:,385),wf(:,-2),G2(:,:,:,386),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,386),Q(:,63),MT,G3tensor(:,119))
  call loop_AV_Q(G0(:,:,:,1),wf(:,111),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,27),MT,G1(:,:,:,213))
  call loop_AV_Q(G1(:,:,:,213),wf(:,-5),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,59),MT,G2(:,:,:,387))
  call loop_AS_Q(G2(:,:,:,387),wf(:,-2),G2(:,:,:,388),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,388),Q(:,63),MT,G3tensor(:,120))
  call loop_QV_A(G0(:,:,:,1),wf(:,114),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,27),MT,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,-5),G1(:,:,:,216))
  call loop_Q_A(G1(:,:,:,216),Q(:,59),MT,G2(:,:,:,389))
  call loop_QS_A(G2(:,:,:,389),wf(:,-2),G2(:,:,:,390),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,390),Q(:,63),MT,G3tensor(:,121))
  call loop_AV_Q(G0(:,:,:,1),wf(:,114),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,27),MT,G1(:,:,:,217))
  call loop_AV_Q(G1(:,:,:,217),wf(:,-5),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,59),MT,G2(:,:,:,391))
  call loop_AS_Q(G2(:,:,:,391),wf(:,-2),G2(:,:,:,392),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,63),MT,G3tensor(:,122))
  call loop_AV_Q(G0(:,:,:,1),wf(:,69),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,19),MT,G1(:,:,:,219))
  call loop_AV_Q(G1(:,:,:,219),wf(:,23),G1(:,:,:,220))
  call loop_A_Q(G1(:,:,:,220),Q(:,59),MT,G2(:,:,:,393))
  call loop_AS_Q(G2(:,:,:,393),wf(:,-2),G2(:,:,:,394),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,394),Q(:,63),MT,G3tensor(:,123))
  call loop_AV_Q(G1(:,:,:,219),wf(:,-3),G1(:,:,:,221))
  call loop_A_Q(G1(:,:,:,221),Q(:,27),MT,G2(:,:,:,395))
  call loop_AV_Q(G2(:,:,:,395),wf(:,-5),G2(:,:,:,396))
  call loop_A_Q(G2(:,:,:,396),Q(:,59),MT,G3(:,:,:,185))
  call loop_AS_Q(G3(:,:,:,185),wf(:,-2),G3(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,63),MT,G4tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,19),MT,G1(:,:,:,222))
  call loop_QV_A(G1(:,:,:,222),wf(:,23),G1(:,:,:,223))
  call loop_Q_A(G1(:,:,:,223),Q(:,59),MT,G2(:,:,:,397))
  call loop_QS_A(G2(:,:,:,397),wf(:,-2),G2(:,:,:,398),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,63),MT,G3tensor(:,124))
  call loop_QV_A(G1(:,:,:,222),wf(:,-3),G1(:,:,:,224))
  call loop_Q_A(G1(:,:,:,224),Q(:,27),MT,G2(:,:,:,399))
  call loop_QV_A(G2(:,:,:,399),wf(:,-5),G2(:,:,:,400))
  call loop_Q_A(G2(:,:,:,400),Q(:,59),MT,G3(:,:,:,187))
  call loop_QS_A(G3(:,:,:,187),wf(:,-2),G3(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,63),MT,G4tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,27),MT,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,-5),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,59),MT,G2(:,:,:,401))
  call loop_QS_A(G2(:,:,:,401),wf(:,-2),G2(:,:,:,402),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,402),Q(:,63),MT,G3tensor(:,125))
  call loop_AV_Q(G0(:,:,:,1),wf(:,117),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,27),MT,G1(:,:,:,227))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-5),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,59),MT,G2(:,:,:,403))
  call loop_AS_Q(G2(:,:,:,403),wf(:,-2),G2(:,:,:,404),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,404),Q(:,63),MT,G3tensor(:,126))
  call loop_QV_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,27),MT,G1(:,:,:,229))
  call loop_QV_A(G1(:,:,:,229),wf(:,-5),G1(:,:,:,230))
  call loop_Q_A(G1(:,:,:,230),Q(:,59),MT,G2(:,:,:,405))
  call loop_QS_A(G2(:,:,:,405),wf(:,-2),G2(:,:,:,406),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,406),Q(:,63),MT,G3tensor(:,127))
  call loop_AV_Q(G0(:,:,:,1),wf(:,120),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,27),MT,G1(:,:,:,231))
  call loop_AV_Q(G1(:,:,:,231),wf(:,-5),G1(:,:,:,232))
  call loop_A_Q(G1(:,:,:,232),Q(:,59),MT,G2(:,:,:,407))
  call loop_AS_Q(G2(:,:,:,407),wf(:,-2),G2(:,:,:,408),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,408),Q(:,63),MT,G3tensor(:,128))
  call loop_AV_Q(G0(:,:,:,1),wf(:,71),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,19),MT,G1(:,:,:,233))
  call loop_AV_Q(G1(:,:,:,233),wf(:,23),G1(:,:,:,234))
  call loop_A_Q(G1(:,:,:,234),Q(:,59),MT,G2(:,:,:,409))
  call loop_AS_Q(G2(:,:,:,409),wf(:,-2),G2(:,:,:,410),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,410),Q(:,63),MT,G3tensor(:,129))
  call loop_AV_Q(G1(:,:,:,233),wf(:,-3),G1(:,:,:,235))
  call loop_A_Q(G1(:,:,:,235),Q(:,27),MT,G2(:,:,:,411))
  call loop_AV_Q(G2(:,:,:,411),wf(:,-5),G2(:,:,:,412))
  call loop_A_Q(G2(:,:,:,412),Q(:,59),MT,G3(:,:,:,189))
  call loop_AS_Q(G3(:,:,:,189),wf(:,-2),G3(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,19),MT,G1(:,:,:,236))
  call loop_QV_A(G1(:,:,:,236),wf(:,23),G1(:,:,:,237))
  call loop_Q_A(G1(:,:,:,237),Q(:,59),MT,G2(:,:,:,413))
  call loop_QS_A(G2(:,:,:,413),wf(:,-2),G2(:,:,:,414),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,414),Q(:,63),MT,G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,236),wf(:,-3),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,27),MT,G2(:,:,:,415))
  call loop_QV_A(G2(:,:,:,415),wf(:,-5),G2(:,:,:,416))
  call loop_Q_A(G2(:,:,:,416),Q(:,59),MT,G3(:,:,:,191))
  call loop_QS_A(G3(:,:,:,191),wf(:,-2),G3(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,63),MT,G4tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,123),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,27),MT,G1(:,:,:,239))
  call loop_QV_A(G1(:,:,:,239),wf(:,-5),G1(:,:,:,240))
  call loop_Q_A(G1(:,:,:,240),Q(:,59),MT,G2(:,:,:,417))
  call loop_QS_A(G2(:,:,:,417),wf(:,-2),G2(:,:,:,418),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,418),Q(:,63),MT,G3tensor(:,131))
  call loop_AV_Q(G0(:,:,:,1),wf(:,123),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,27),MT,G1(:,:,:,241))
  call loop_AV_Q(G1(:,:,:,241),wf(:,-5),G1(:,:,:,242))
  call loop_A_Q(G1(:,:,:,242),Q(:,59),MT,G2(:,:,:,419))
  call loop_AS_Q(G2(:,:,:,419),wf(:,-2),G2(:,:,:,420),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,420),Q(:,63),MT,G3tensor(:,132))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,27),MT,G1(:,:,:,243))
  call loop_QV_A(G1(:,:,:,243),wf(:,-5),G1(:,:,:,244))
  call loop_Q_A(G1(:,:,:,244),Q(:,59),MT,G2(:,:,:,421))
  call loop_QS_A(G2(:,:,:,421),wf(:,-2),G2(:,:,:,422),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,422),Q(:,63),MT,G3tensor(:,133))
  call loop_AV_Q(G0(:,:,:,1),wf(:,126),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,27),MT,G1(:,:,:,245))
  call loop_AV_Q(G1(:,:,:,245),wf(:,-5),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,59),MT,G2(:,:,:,423))
  call loop_AS_Q(G2(:,:,:,423),wf(:,-2),G2(:,:,:,424),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,424),Q(:,63),MT,G3tensor(:,134))
  call loop_QV_A(G0(:,:,:,1),wf(:,129),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,27),MT,G1(:,:,:,247))
  call loop_QV_A(G1(:,:,:,247),wf(:,-5),G1(:,:,:,248))
  call loop_Q_A(G1(:,:,:,248),Q(:,59),MT,G2(:,:,:,425))
  call loop_QS_A(G2(:,:,:,425),wf(:,-2),G2(:,:,:,426),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,426),Q(:,63),MT,G3tensor(:,135))
  call loop_AV_Q(G0(:,:,:,1),wf(:,129),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,27),MT,G1(:,:,:,249))
  call loop_AV_Q(G1(:,:,:,249),wf(:,-5),G1(:,:,:,250))
  call loop_A_Q(G1(:,:,:,250),Q(:,59),MT,G2(:,:,:,427))
  call loop_AS_Q(G2(:,:,:,427),wf(:,-2),G2(:,:,:,428),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,428),Q(:,63),MT,G3tensor(:,136))
  call loop_QV_A(G0(:,:,:,1),wf(:,131),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,27),MT,G1(:,:,:,251))
  call loop_QV_A(G1(:,:,:,251),wf(:,-5),G1(:,:,:,252))
  call loop_Q_A(G1(:,:,:,252),Q(:,59),MT,G2(:,:,:,429))
  call loop_QS_A(G2(:,:,:,429),wf(:,-2),G2(:,:,:,430),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,430),Q(:,63),MT,G3tensor(:,137))
  call loop_AV_Q(G0(:,:,:,1),wf(:,131),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,27),MT,G1(:,:,:,253))
  call loop_AV_Q(G1(:,:,:,253),wf(:,-5),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,59),MT,G2(:,:,:,431))
  call loop_AS_Q(G2(:,:,:,431),wf(:,-2),G2(:,:,:,432),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,432),Q(:,63),MT,G3tensor(:,138))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(121)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(123)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,73),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,73),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,73),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,73),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,3))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,3))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,74),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(125)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(13)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,97),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,98),T3sum(1:35,3))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,47),T4sum(1:70,1))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,47),T4sum(1:70,1))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,47),T4sum(1:70,1))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,47),T4sum(1:70,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,41),T4sum(1:70,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,41),T4sum(1:70,1))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,41),T4sum(1:70,1))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,41),T4sum(1:70,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,53),T4sum(1:70,2))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,53),T4sum(1:70,2))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,53),T4sum(1:70,2))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,53),T4sum(1:70,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,54),T4sum(1:70,2))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,54),T4sum(1:70,2))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,54),T4sum(1:70,2))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_25,masses2_2,G4tensor(:,54),T4sum(1:70,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,42),T4sum(1:70,3))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,48),T4sum(1:70,3))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,48),T4sum(1:70,3))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,48),T4sum(1:70,3))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(126)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,48),T4sum(1:70,3))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(20)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,49),T4sum(1:70,4))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,49),T4sum(1:70,4))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,49),T4sum(1:70,4))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,49),T4sum(1:70,4))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,43),T4sum(1:70,4))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,43),T4sum(1:70,4))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,43),T4sum(1:70,4))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,43),T4sum(1:70,4))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,34),T4sum(1:70,5))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,34),T4sum(1:70,5))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,34),T4sum(1:70,5))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,34),T4sum(1:70,5))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_21,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,44),T4sum(1:70,6))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,44),T4sum(1:70,6))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,44),T4sum(1:70,6))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,44),T4sum(1:70,6))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,50),T4sum(1:70,6))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,50),T4sum(1:70,6))
  M(10) = M(10) + ((CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,50),T4sum(1:70,6))
  M(11) = M(11) + (-(CI*f(3))/6._/**/REALKIND * den(128)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,50),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,101),T3sum(1:35,7))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,101),T3sum(1:35,7))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,101),T3sum(1:35,7))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,101),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,102),T3sum(1:35,7))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,102),T3sum(1:35,7))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,102),T3sum(1:35,7))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,102),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,51),T4sum(1:70,7))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,45),T4sum(1:70,7))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,45),T4sum(1:70,7))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,45),T4sum(1:70,7))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,45),T4sum(1:70,7))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,1),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,1),T4sum(1:70,8))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,1),T4sum(1:70,8))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,1),T4sum(1:70,8))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,46),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,46),T4sum(1:70,9))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,46),T4sum(1:70,9))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,46),T4sum(1:70,9))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,52),T4sum(1:70,9))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,52),T4sum(1:70,9))
  M(10) = M(10) + (-(CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,52),T4sum(1:70,9))
  M(11) = M(11) + ((CI*f(3))/6._/**/REALKIND * den(130)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,52),T4sum(1:70,9))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,103),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,103),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,103),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,103),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,104),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,104),T3sum(1:35,3))
  M(4) = M(4) + (f(4)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,104),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(132)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,104),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,28),T4sum(1:70,10))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,35),T4sum(1:70,10))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,59),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,59),T4sum(1:70,11))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,57),T4sum(1:70,11))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,57),T4sum(1:70,11))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,60),T4sum(1:70,12))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,60),T4sum(1:70,12))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,58),T4sum(1:70,12))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,58),T4sum(1:70,12))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,105),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,105),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,105),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,105),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,106),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,106),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,106),T3sum(1:35,3))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(134)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,106),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,2),T4sum(1:70,13))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,2),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,15),T4sum(1:70,13))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,15),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,3),T4sum(1:70,14))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,3),T4sum(1:70,14))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,14))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,16),T4sum(1:70,14))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,55),T4sum(1:70,15))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,55),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,56),T4sum(1:70,15))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(19)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,56),T4sum(1:70,15))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(5) = M(5) + (f(4)/2._/**/REALKIND * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(136)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(6) = M(6) + (f(4)/2._/**/REALKIND * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,6),T4sum(1:70,16))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,6),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,19),T4sum(1:70,16))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,19),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,7),T4sum(1:70,17))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,7),T4sum(1:70,17))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,20),T4sum(1:70,17))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,20),T4sum(1:70,17))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,18))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,29),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,36),T4sum(1:70,18))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(12)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,36),T4sum(1:70,18))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_3,G5tensor(:,9),T5sum(1:126,1))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_3,G5tensor(:,9),T5sum(1:126,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_36,masses2_3,G5tensor(:,11),T5sum(1:126,1))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_36,masses2_3,G5tensor(:,11),T5sum(1:126,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_3,G5tensor(:,5),T5sum(1:126,2))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_3,G5tensor(:,5),T5sum(1:126,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_32,masses2_3,G5tensor(:,1),T5sum(1:126,2))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_32,masses2_3,G5tensor(:,1),T5sum(1:126,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_3,G5tensor(:,12),T5sum(1:126,3))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_3,G5tensor(:,12),T5sum(1:126,3))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_37,masses2_3,G5tensor(:,10),T5sum(1:126,3))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_37,masses2_3,G5tensor(:,10),T5sum(1:126,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_3,G5tensor(:,6),T5sum(1:126,4))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_3,G5tensor(:,6),T5sum(1:126,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_33,masses2_3,G5tensor(:,2),T5sum(1:126,4))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_33,masses2_3,G5tensor(:,2),T5sum(1:126,4))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,23),T5sum(1:126,5))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,23),T5sum(1:126,5))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,17),T5sum(1:126,5))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,17),T5sum(1:126,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,24),T5sum(1:126,6))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,24),T5sum(1:126,6))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,18),T5sum(1:126,6))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,18),T5sum(1:126,6))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_3,G5tensor(:,8),T5sum(1:126,7))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_3,G5tensor(:,8),T5sum(1:126,7))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_34,masses2_3,G5tensor(:,4),T5sum(1:126,7))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_34,masses2_3,G5tensor(:,4),T5sum(1:126,7))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_3,G5tensor(:,3),T5sum(1:126,8))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_3,G5tensor(:,3),T5sum(1:126,8))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_35,masses2_3,G5tensor(:,7),T5sum(1:126,8))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_35,masses2_3,G5tensor(:,7),T5sum(1:126,8))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_3,G5tensor(:,21),T5sum(1:126,9))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_3,G5tensor(:,21),T5sum(1:126,9))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_28,masses2_3,G5tensor(:,15),T5sum(1:126,9))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_28,masses2_3,G5tensor(:,15),T5sum(1:126,9))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_29,masses2_3,G5tensor(:,16),T5sum(1:126,10))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_29,masses2_3,G5tensor(:,16),T5sum(1:126,10))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_3,G5tensor(:,19),T5sum(1:126,11))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_3,G5tensor(:,19),T5sum(1:126,11))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_30,masses2_3,G5tensor(:,13),T5sum(1:126,11))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_30,masses2_3,G5tensor(:,13),T5sum(1:126,11))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_3,G5tensor(:,20),T5sum(1:126,12))
  M(11) = M(11) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_3,G5tensor(:,20),T5sum(1:126,12))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(5,momenta_31,masses2_3,G5tensor(:,14),T5sum(1:126,12))
  M(10) = M(10) + (f(4)/6._/**/REALKIND * den(1)) * TI2_call(5,momenta_31,masses2_3,G5tensor(:,14),T5sum(1:126,12))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,107),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(138)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,108),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(139)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,109),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,109),T3sum(1:35,7))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,110),T3sum(1:35,7))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(47)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,110),T3sum(1:35,7))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,111),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,111),T3sum(1:35,3))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,112),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,10))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,32),T4sum(1:70,10))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,39),T4sum(1:70,10))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,63),T4sum(1:70,11))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,63),T4sum(1:70,11))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,61),T4sum(1:70,11))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,61),T4sum(1:70,11))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,64),T4sum(1:70,12))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,64),T4sum(1:70,12))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,62),T4sum(1:70,12))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(46)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,62),T4sum(1:70,12))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,113),T3sum(1:35,3))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(143)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,114),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(145)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,115),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,116),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,117),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(64)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,118),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,119),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,119),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,120),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,120),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,10))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,33),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,40),T4sum(1:70,10))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_23,masses2_2,G4tensor(:,40),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,67),T4sum(1:70,11))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,67),T4sum(1:70,11))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,65),T4sum(1:70,11))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_20,masses2_2,G4tensor(:,65),T4sum(1:70,11))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,68),T4sum(1:70,12))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,68),T4sum(1:70,12))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(63)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,66),T4sum(1:70,12))
  M(9) = M(9) + (f(4)/6._/**/REALKIND * den(63)) * TI2_call(4,momenta_19,masses2_2,G4tensor(:,66),T4sum(1:70,12))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,121),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(152)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,122),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,1))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(77)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,3))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,3))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,1))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,10),T4sum(1:70,13))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,10),T4sum(1:70,13))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,23),T4sum(1:70,13))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,23),T4sum(1:70,13))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,4),T4sum(1:70,14))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,4),T4sum(1:70,14))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,14))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,17),T4sum(1:70,14))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,70),T4sum(1:70,15))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,70),T4sum(1:70,15))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(76)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,69),T4sum(1:70,15))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(76)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,69),T4sum(1:70,15))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,127),T3sum(1:35,3))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(160)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,128),T3sum(1:35,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(162)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(163)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,129),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,129),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,130),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,130),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,131),T3sum(1:35,3))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,131),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,132),T3sum(1:35,3))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(164)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,132),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(165)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,11),T4sum(1:70,13))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,11),T4sum(1:70,13))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,24),T4sum(1:70,13))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_16,masses2_2,G4tensor(:,24),T4sum(1:70,13))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,5),T4sum(1:70,14))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,5),T4sum(1:70,14))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,14))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_17,masses2_2,G4tensor(:,18),T4sum(1:70,14))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,72),T4sum(1:70,15))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,72),T4sum(1:70,15))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(80)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,71),T4sum(1:70,15))
  M(8) = M(8) + (f(4)/6._/**/REALKIND * den(80)) * TI2_call(4,momenta_24,masses2_2,G4tensor(:,71),T4sum(1:70,15))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,133),T3sum(1:35,3))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,134),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(4) = M(4) + (-(f(4)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,135),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,135),T3sum(1:35,3))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,136),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(173)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(174)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,31),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(3))/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,31),T3sum(1:35,1))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,12),T4sum(1:70,16))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,12),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,25),T4sum(1:70,16))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,25),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,8),T4sum(1:70,17))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,8),T4sum(1:70,17))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,21),T4sum(1:70,17))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,21),T4sum(1:70,17))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,18))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,30),T4sum(1:70,18))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,37),T4sum(1:70,18))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(84)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,37),T4sum(1:70,18))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(3) = M(3) + (-(f(4)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,68),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,32),T3sum(1:35,1))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(6) = M(6) + ((CI*f(3))/2._/**/REALKIND * den(180)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,13),T4sum(1:70,16))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,13),T4sum(1:70,16))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,26),T4sum(1:70,16))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_18,masses2_2,G4tensor(:,26),T4sum(1:70,16))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,9),T4sum(1:70,17))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,9),T4sum(1:70,17))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,22),T4sum(1:70,17))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,22),T4sum(1:70,17))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,31),T4sum(1:70,18))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,31),T4sum(1:70,18))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(86)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,38),T4sum(1:70,18))
  M(7) = M(7) + (f(4)/6._/**/REALKIND * den(86)) * TI2_call(4,momenta_22,masses2_2,G4tensor(:,38),T4sum(1:70,18))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(5) = M(5) + (-(f(4)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,70),T3sum(1:35,2))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,1))
  M(6) = M(6) + (-(f(4)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(3))/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,72),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(3))/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,72),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(3))/2._/**/REALKIND * den(191)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,1))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_ddxhggg_1_/**/REALKIND
