
module ol_vamp_1_pphjjj2_ddxbbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_ddxbbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_ddxbbxhg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_ddxbbxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_ddxbbxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,108) :: G0
  complex(REALKIND), dimension(4,5,4,357) :: G1
  complex(REALKIND), dimension(4,15,4,342) :: G2
  complex(REALKIND), dimension(4,35,4,121) :: G3
  complex(REALKIND), dimension(4,70,4,18) :: G4
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,52,32))
    allocate(G2tensorhel(15,167,32))
    allocate(G3tensorhel(35,131,32))
    allocate(G4tensorhel(70,34,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,2))
  call loop_VQ_A(G0(:,:,:,2),wf(:,4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,55),MB,G1(:,:,:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,-3),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,2),wf(:,15),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,59),MB,G1(:,:,:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,2),wf(:,-2),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,43),MB,G1(:,:,:,3))
  call loop_AS_Q(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4),gH)
  call loop_A_Q(G1(:,:,:,4),Q(:,59),MB,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-2),G2tensor(:,1))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,35),wf(:,10),Q(:,28),G1tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,35),wf(:,20),Q(:,28),G1tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-5),G0(:,:,:,6))
  call loop_VQ_A(G0(:,:,:,6),wf(:,4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,55),MB,G1(:,:,:,5))
  call check_last_QA_V(l_switch,G1(:,:,:,5),wf(:,-3),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,6),wf(:,15),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,59),MB,G1(:,:,:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,6),wf(:,-2),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-3),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,43),MB,G1(:,:,:,7))
  call loop_AS_Q(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gH)
  call loop_A_Q(G1(:,:,:,8),Q(:,59),MB,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,-2),G2tensor(:,2))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,35),wf(:,10),Q(:,28),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,35),wf(:,20),Q(:,28),G1tensor(:,8))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,10))
  call loop_VQ_A(G0(:,:,:,10),wf(:,4),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,55),MB,G1(:,:,:,9))
  call check_last_QA_V(l_switch,G1(:,:,:,9),wf(:,-3),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,10),wf(:,15),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,59),MB,G1(:,:,:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,10),wf(:,-2),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,10),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,43),MB,G1(:,:,:,11))
  call loop_AS_Q(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12),gH)
  call loop_A_Q(G1(:,:,:,12),Q(:,59),MB,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-2),G2tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,35),wf(:,10),Q(:,28),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,35),wf(:,20),Q(:,28),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,10),G0(:,:,:,14))
  call loop_VA_Q(G0(:,:,:,14),wf(:,-1),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,62),ZERO,G1(:,:,:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,13),wf(:,0),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,10),wf(:,-5),G0(:,:,:,16))
  call loop_VA_Q(G0(:,:,:,16),wf(:,-1),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,62),ZERO,G1(:,:,:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,14),wf(:,0),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,16))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,10),G0(:,:,:,18))
  call loop_VA_Q(G0(:,:,:,18),wf(:,-1),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,62),ZERO,G1(:,:,:,15))
  call check_last_AQ_V(l_switch,G1(:,:,:,15),wf(:,0),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,20),G0(:,:,:,20))
  call loop_VA_Q(G0(:,:,:,20),wf(:,-1),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,62),ZERO,G1(:,:,:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,16),wf(:,0),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,-5),G0(:,:,:,22))
  call loop_VA_Q(G0(:,:,:,22),wf(:,-1),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,62),ZERO,G1(:,:,:,17))
  call check_last_AQ_V(l_switch,G1(:,:,:,17),wf(:,0),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,20),G0(:,:,:,24))
  call loop_VA_Q(G0(:,:,:,24),wf(:,-1),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,62),ZERO,G1(:,:,:,18))
  call check_last_AQ_V(l_switch,G1(:,:,:,18),wf(:,0),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,24))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,26),gH)
  call loop_Q_A(G0(:,:,:,26),Q(:,16),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,11),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,51),MT,G2(:,:,:,4))
  call loop_QV_A(G2(:,:,:,4),wf(:,29),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,19),wf(:,31),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,60),MT,G2(:,:,:,6))
  call loop_QV_A(G2(:,:,:,6),wf(:,1),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,48),MT,G2(:,:,:,8))
  call loop_QV_A(G2(:,:,:,8),wf(:,34),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,8),wf(:,131),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,8),wf(:,136),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,8),wf(:,145),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,8),wf(:,147),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,19),wf(:,29),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,28),MT,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-5),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,60),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,19),wf(:,41),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,60),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,1),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,19),wf(:,43),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,60),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,1),G2(:,:,:,19))
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,19),wf(:,25),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,51),MT,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,29),G2(:,:,:,21))
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,19),wf(:,28),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,51),MT,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,29),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,11))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,27),gH)
  call loop_A_Q(G0(:,:,:,27),Q(:,16),MT,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,11),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,51),MT,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,29),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,28),wf(:,31),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,60),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,1),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,48),MT,G2(:,:,:,28))
  call loop_AV_Q(G2(:,:,:,28),wf(:,34),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,28),wf(:,131),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,28),wf(:,136),G2(:,:,:,31))
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G2(:,:,:,28),wf(:,145),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,28),wf(:,147),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,28),wf(:,29),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,28),MT,G2(:,:,:,34))
  call loop_AV_Q(G2(:,:,:,34),wf(:,-5),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,60),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,28),wf(:,41),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,60),MT,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,1),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,63),MT,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,28),wf(:,43),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,60),MT,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,1),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,28),wf(:,25),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,51),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,29),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,28),wf(:,28),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,51),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,29),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,22))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,28),gH)
  call loop_Q_A(G0(:,:,:,28),Q(:,16),MB,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,11),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,51),MB,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,29),G2(:,:,:,45))
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),MB,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,37),wf(:,31),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,60),MB,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,1),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),MB,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,48),MB,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,34),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MB,G3tensor(:,25))
  call loop_QV_A(G2(:,:,:,48),wf(:,131),G2(:,:,:,50))
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G2(:,:,:,48),wf(:,136),G2(:,:,:,51))
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G2(:,:,:,48),wf(:,145),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,48),wf(:,147),G2(:,:,:,53))
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,63),MB,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,37),wf(:,29),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,28),MB,G2(:,:,:,54))
  call loop_QV_A(G2(:,:,:,54),wf(:,-5),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,60),MB,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,37),wf(:,41),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,60),MB,G2(:,:,:,56))
  call loop_QV_A(G2(:,:,:,56),wf(:,1),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,37),wf(:,43),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,60),MB,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,1),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,37),wf(:,25),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,51),MB,G2(:,:,:,60))
  call loop_QV_A(G2(:,:,:,60),wf(:,29),G2(:,:,:,61))
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),MB,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,37),wf(:,28),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,51),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,29),G2(:,:,:,63))
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,63),MB,G3tensor(:,33))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,29),gH)
  call loop_A_Q(G0(:,:,:,29),Q(:,16),MB,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,11),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,51),MB,G2(:,:,:,64))
  call loop_AV_Q(G2(:,:,:,64),wf(:,29),G2(:,:,:,65))
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,46),wf(:,31),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,60),MB,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,1),G2(:,:,:,67))
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),MB,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-5),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,48),MB,G2(:,:,:,68))
  call loop_AV_Q(G2(:,:,:,68),wf(:,34),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,63),MB,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,68),wf(:,131),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,68),wf(:,136),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,63),MB,G3tensor(:,38))
  call loop_AV_Q(G2(:,:,:,68),wf(:,145),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,68),wf(:,147),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,63),MB,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,46),wf(:,29),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,28),MB,G2(:,:,:,74))
  call loop_AV_Q(G2(:,:,:,74),wf(:,-5),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,60),MB,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,46),wf(:,41),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,60),MB,G2(:,:,:,76))
  call loop_AV_Q(G2(:,:,:,76),wf(:,1),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,46),wf(:,43),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,60),MB,G2(:,:,:,78))
  call loop_AV_Q(G2(:,:,:,78),wf(:,1),G2(:,:,:,79))
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,46),wf(:,25),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,51),MB,G2(:,:,:,80))
  call loop_AV_Q(G2(:,:,:,80),wf(:,29),G2(:,:,:,81))
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,46),wf(:,28),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,51),MB,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,29),G2(:,:,:,83))
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,63),MB,G3tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,12),MT,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,44),MT,G2(:,:,:,84))
  call loop_QS_A(G2(:,:,:,84),wf(:,-4),G2(:,:,:,85),gH)
  call loop_Q_A(G2(:,:,:,85),Q(:,60),MT,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_QS_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57),gH)
  call loop_Q_A(G1(:,:,:,57),Q(:,28),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-5),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,60),MT,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,12),MT,G1(:,:,:,58))
  call loop_AV_Q(G1(:,:,:,58),wf(:,-5),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,44),MT,G2(:,:,:,88))
  call loop_AS_Q(G2(:,:,:,88),wf(:,-4),G2(:,:,:,89),gH)
  call loop_A_Q(G2(:,:,:,89),Q(:,60),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_AS_Q(G1(:,:,:,58),wf(:,-4),G1(:,:,:,60),gH)
  call loop_A_Q(G1(:,:,:,60),Q(:,28),MT,G2(:,:,:,90))
  call loop_AV_Q(G2(:,:,:,90),wf(:,-5),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,60),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,12),MB,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,44),MB,G2(:,:,:,92))
  call loop_QS_A(G2(:,:,:,92),wf(:,-4),G2(:,:,:,93),gH)
  call loop_Q_A(G2(:,:,:,93),Q(:,60),MB,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MB,G4tensor(:,9))
  call loop_QS_A(G1(:,:,:,61),wf(:,-4),G1(:,:,:,63),gH)
  call loop_Q_A(G1(:,:,:,63),Q(:,28),MB,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,-5),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,60),MB,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MB,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,12),MB,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,44),MB,G2(:,:,:,96))
  call loop_AS_Q(G2(:,:,:,96),wf(:,-4),G2(:,:,:,97),gH)
  call loop_A_Q(G2(:,:,:,97),Q(:,60),MB,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,11))
  call loop_AS_Q(G1(:,:,:,64),wf(:,-4),G1(:,:,:,66),gH)
  call loop_A_Q(G1(:,:,:,66),Q(:,28),MB,G2(:,:,:,98))
  call loop_AV_Q(G2(:,:,:,98),wf(:,-5),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,60),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,40),MB,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,1),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,43),MB,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,4),G2tensor(:,4))
  call loop_AS_Q(G2(:,:,:,100),wf(:,-4),G2(:,:,:,101),gH)
  call loop_A_Q(G2(:,:,:,101),Q(:,59),MB,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-2),G3tensor(:,45))
  call loop_AS_Q(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69),gH)
  call loop_A_Q(G1(:,:,:,69),Q(:,56),MB,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,19),G2tensor(:,5))
  call loop_AV_Q(G2(:,:,:,102),wf(:,1),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,59),MB,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,-2),G3tensor(:,46))
  call loop_AQ_V(G2(:,:,:,102),wf(:,-2),G2(:,:,:,104))
  call loop_VA_Q(G2(:,:,:,104),wf(:,-1),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,62),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,0),G3tensor(:,47))
  call loop_AQ_V(G1(:,:,:,67),wf(:,4),G1(:,:,:,70))
  call loop_VA_Q(G1(:,:,:,70),wf(:,-1),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,62),ZERO,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,0),G2tensor(:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,67),wf(:,99),G1tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,67),wf(:,133),G1tensor(:,26))
  call loop_VQ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,20),MB,G1(:,:,:,72))
  call loop_QA_V(G1(:,:,:,72),wf(:,5),G1(:,:,:,73))
  call check_last_UV_W(l_switch,G1(:,:,:,73),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,73),wf(:,-1),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,62),ZERO,G2(:,:,:,107))
  call check_last_AQ_V(l_switch,G2(:,:,:,107),wf(:,0),G2tensor(:,8))
  call loop_QV_A(G1(:,:,:,72),wf(:,-5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,52),MB,G2(:,:,:,108))
  call check_last_QA_V(l_switch,G2(:,:,:,108),wf(:,9),G2tensor(:,9))
  call loop_QV_A(G2(:,:,:,108),wf(:,1),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,55),MB,G3(:,:,:,28))
  call check_last_QA_V(l_switch,G3(:,:,:,28),wf(:,-3),G3tensor(:,48))
  call loop_QA_V(G2(:,:,:,108),wf(:,-3),G2(:,:,:,110))
  call loop_VA_Q(G2(:,:,:,110),wf(:,-1),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,62),ZERO,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,72),wf(:,11),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,55),MB,G2(:,:,:,112))
  call check_last_QA_V(l_switch,G2(:,:,:,112),wf(:,-3),G2tensor(:,10))
  call loop_QV_A(G1(:,:,:,72),wf(:,1),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,23),MB,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,55),MB,G3(:,:,:,30))
  call check_last_QA_V(l_switch,G3(:,:,:,30),wf(:,-3),G3tensor(:,50))
  call loop_QA_V(G1(:,:,:,72),wf(:,-3),G1(:,:,:,78))
  call loop_UV_W(G1(:,:,:,78),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,115))
  call check_last_UV_W(l_switch,G2(:,:,:,115),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,51))
  call loop_VA_Q(G2(:,:,:,115),wf(:,-1),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),ZERO,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,52))
  call loop_VQ_A(G1(:,:,:,78),wf(:,24),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,61),ZERO,G2(:,:,:,117))
  call check_last_QA_V(l_switch,G2(:,:,:,117),wf(:,-1),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,78),wf(:,27),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,62),ZERO,G2(:,:,:,118))
  call check_last_AQ_V(l_switch,G2(:,:,:,118),wf(:,0),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,78),wf(:,-1),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,30),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,62),ZERO,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,0),G3tensor(:,53))
  call loop_QV_A(G1(:,:,:,72),wf(:,25),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,55),MB,G2(:,:,:,121))
  call check_last_QA_V(l_switch,G2(:,:,:,121),wf(:,-3),G2tensor(:,13))
  call loop_QV_A(G1(:,:,:,72),wf(:,28),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,55),MB,G2(:,:,:,122))
  call check_last_QA_V(l_switch,G2(:,:,:,122),wf(:,-3),G2tensor(:,14))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-5),Q(:,32),G1(:,:,:,84))
  call loop_VQ_A(G1(:,:,:,84),wf(:,4),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,52),MB,G2(:,:,:,123))
  call check_last_QA_V(l_switch,G2(:,:,:,123),wf(:,9),G2tensor(:,15))
  call loop_QV_A(G2(:,:,:,123),wf(:,1),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,55),MB,G3(:,:,:,33))
  call check_last_QA_V(l_switch,G3(:,:,:,33),wf(:,-3),G3tensor(:,54))
  call loop_QA_V(G2(:,:,:,123),wf(:,-3),G2(:,:,:,125))
  call loop_VA_Q(G2(:,:,:,125),wf(:,-1),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,62),ZERO,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,0),G3tensor(:,55))
  call loop_VQ_A(G1(:,:,:,84),wf(:,99),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,55),MB,G2(:,:,:,127))
  call check_last_QA_V(l_switch,G2(:,:,:,127),wf(:,-3),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,84),wf(:,15),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,56),MB,G2(:,:,:,128))
  call check_last_AQ_V(l_switch,G2(:,:,:,128),wf(:,19),G2tensor(:,17))
  call loop_AV_Q(G2(:,:,:,128),wf(:,1),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,59),MB,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-2),G3tensor(:,56))
  call loop_AQ_V(G2(:,:,:,128),wf(:,-2),G2(:,:,:,130))
  call loop_VA_Q(G2(:,:,:,130),wf(:,-1),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,62),ZERO,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,0),G3tensor(:,57))
  call loop_VA_Q(G1(:,:,:,84),wf(:,110),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,59),MB,G2(:,:,:,132))
  call check_last_AQ_V(l_switch,G2(:,:,:,132),wf(:,-2),G2tensor(:,18))
  call loop_VQ_A(G1(:,:,:,84),wf(:,133),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,55),MB,G2(:,:,:,133))
  call check_last_QA_V(l_switch,G2(:,:,:,133),wf(:,-3),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,84),wf(:,-3),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,40),MB,G2(:,:,:,134))
  call loop_AS_Q(G2(:,:,:,134),wf(:,-4),G2(:,:,:,135),gH)
  call loop_A_Q(G2(:,:,:,135),Q(:,56),MB,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,19),G3tensor(:,58))
  call loop_AV_Q(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,59),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,-2),G4tensor(:,13))
  call loop_AQ_V(G3(:,:,:,37),wf(:,-2),G3(:,:,:,39))
  call loop_VA_Q(G3(:,:,:,39),wf(:,-1),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,62),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,134),wf(:,1),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,43),MB,G3(:,:,:,41))
  call loop_AS_Q(G3(:,:,:,41),wf(:,-4),G3(:,:,:,42),gH)
  call loop_A_Q(G3(:,:,:,42),Q(:,59),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-2),G4tensor(:,15))
  call loop_AQ_V(G2(:,:,:,134),wf(:,4),G2(:,:,:,137))
  call loop_VA_Q(G2(:,:,:,137),wf(:,-1),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,62),ZERO,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,59))
  call loop_VA_Q(G1(:,:,:,84),wf(:,138),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,59),MB,G2(:,:,:,139))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,-2),G2tensor(:,20))
  call loop_VA_Q(G1(:,:,:,84),wf(:,9),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,43),MB,G2(:,:,:,140))
  call loop_AS_Q(G2(:,:,:,140),wf(:,-4),G2(:,:,:,141),gH)
  call loop_A_Q(G2(:,:,:,141),Q(:,59),MB,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,-2),G3tensor(:,60))
  call loop_VQ_A(G1(:,:,:,84),wf(:,149),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,61),ZERO,G2(:,:,:,142))
  call check_last_QA_V(l_switch,G2(:,:,:,142),wf(:,-1),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,84),wf(:,151),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,62),ZERO,G2(:,:,:,143))
  call check_last_AQ_V(l_switch,G2(:,:,:,143),wf(:,0),G2tensor(:,22))
  call loop_UV_W(G1(:,:,:,84),Q(:,32),wf(:,10),Q(:,28),G2(:,:,:,144))
  call loop_VA_Q(G2(:,:,:,144),wf(:,-1),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,62),ZERO,G3(:,:,:,45))
  call check_last_AQ_V(l_switch,G3(:,:,:,45),wf(:,0),G3tensor(:,61))
  call loop_VA_Q(G1(:,:,:,84),wf(:,-1),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,34),ZERO,G2(:,:,:,146))
  call loop_AV_Q(G2(:,:,:,146),wf(:,10),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,62),ZERO,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,0),G3tensor(:,62))
  call loop_AV_Q(G2(:,:,:,146),wf(:,20),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,62),ZERO,G3(:,:,:,47))
  call check_last_AQ_V(l_switch,G3(:,:,:,47),wf(:,0),G3tensor(:,63))
  call loop_VQ_A(G1(:,:,:,84),wf(:,155),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,61),ZERO,G2(:,:,:,149))
  call check_last_QA_V(l_switch,G2(:,:,:,149),wf(:,-1),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,84),wf(:,157),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,62),ZERO,G2(:,:,:,150))
  call check_last_AQ_V(l_switch,G2(:,:,:,150),wf(:,0),G2tensor(:,24))
  call loop_UV_W(G1(:,:,:,84),Q(:,32),wf(:,20),Q(:,28),G2(:,:,:,151))
  call loop_VA_Q(G2(:,:,:,151),wf(:,-1),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,62),ZERO,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,0),G3tensor(:,64))
  call loop_VQ_A(G1(:,:,:,84),wf(:,-2),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,36),MB,G2(:,:,:,153))
  call loop_QA_V(G2(:,:,:,153),wf(:,15),G2(:,:,:,154))
  call loop_VA_Q(G2(:,:,:,154),wf(:,-1),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,62),ZERO,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,0),G3tensor(:,65))
  call loop_QS_A(G2(:,:,:,153),wf(:,-4),G2(:,:,:,156),gH)
  call loop_Q_A(G2(:,:,:,156),Q(:,52),MB,G3(:,:,:,50))
  call loop_QA_V(G3(:,:,:,50),wf(:,-3),G3(:,:,:,51))
  call loop_VA_Q(G3(:,:,:,51),wf(:,-1),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,62),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,84),wf(:,1),wf(:,10),G1tensor(:,27))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,84),wf(:,10),wf(:,1),G1tensor(:,28))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,84),wf(:,1),wf(:,10),G1tensor(:,29))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,84),wf(:,1),wf(:,20),G1tensor(:,30))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,84),wf(:,20),wf(:,1),G1tensor(:,31))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,84),wf(:,1),wf(:,20),G1tensor(:,32))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,35),G1(:,:,:,99))
  call loop_VQ_A(G1(:,:,:,99),wf(:,4),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,55),MB,G2(:,:,:,157))
  call check_last_QA_V(l_switch,G2(:,:,:,157),wf(:,-3),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,99),wf(:,15),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,59),MB,G2(:,:,:,158))
  call check_last_AQ_V(l_switch,G2(:,:,:,158),wf(:,-2),G2tensor(:,26))
  call loop_VA_Q(G1(:,:,:,99),wf(:,-3),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,43),MB,G2(:,:,:,159))
  call loop_AS_Q(G2(:,:,:,159),wf(:,-4),G2(:,:,:,160),gH)
  call loop_A_Q(G2(:,:,:,160),Q(:,59),MB,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,-2),G3tensor(:,66))
  call check_last_UV_W(l_switch,G1(:,:,:,99),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,99),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,28),ZERO,G1(:,:,:,103))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-5),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,60),ZERO,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,1),G2(:,:,:,162))
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),ZERO,G3tensor(:,67))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,28),MT,G1(:,:,:,105))
  call loop_AV_Q(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,60),MT,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,1),G2(:,:,:,164))
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,28),ZERO,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,60),ZERO,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,1),G2(:,:,:,166))
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),ZERO,G3tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,28),MT,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,-5),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,60),MT,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,1),G2(:,:,:,168))
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,28),MB,G1(:,:,:,111))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,60),MB,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,1),G2(:,:,:,170))
  call check_last_A_Q(l_switch,G2(:,:,:,170),Q(:,63),MB,G3tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,28),MB,G1(:,:,:,113))
  call loop_QV_A(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,60),MB,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,1),G2(:,:,:,172))
  call check_last_Q_A(l_switch,G2(:,:,:,172),Q(:,63),MB,G3tensor(:,72))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,10),G1(:,:,:,115))
  call loop_DV_C(G1(:,:,:,115),Q(:,28),wf(:,-5),G2(:,:,:,173))
  call check_last_DV_C(l_switch,G2(:,:,:,173),Q(:,60),wf(:,1),G3tensor(:,73))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,28),G1(:,:,:,116))
  call loop_CV_D(G1(:,:,:,116),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,174))
  call check_last_CV_D(l_switch,G2(:,:,:,174),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,74))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,28),G1(:,:,:,117))
  call loop_UV_W(G1(:,:,:,117),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,175))
  call check_last_UV_W(l_switch,G2(:,:,:,175),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,75))
  call loop_VA_Q(G2(:,:,:,175),wf(:,-1),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,62),ZERO,G3(:,:,:,54))
  call check_last_AQ_V(l_switch,G3(:,:,:,54),wf(:,0),G3tensor(:,76))
  call loop_VQ_A(G1(:,:,:,117),wf(:,24),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,61),ZERO,G2(:,:,:,177))
  call check_last_QA_V(l_switch,G2(:,:,:,177),wf(:,-1),G2tensor(:,29))
  call loop_VA_Q(G1(:,:,:,117),wf(:,27),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),ZERO,G2(:,:,:,178))
  call check_last_AQ_V(l_switch,G2(:,:,:,178),wf(:,0),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,117),wf(:,-1),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,30),ZERO,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-5),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,62),ZERO,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,0),G3tensor(:,77))
  call loop_VQ_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,52),MB,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,1),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,55),MB,G2(:,:,:,181))
  call check_last_QA_V(l_switch,G2(:,:,:,181),wf(:,-3),G2tensor(:,31))
  call loop_QA_V(G1(:,:,:,121),wf(:,-3),G1(:,:,:,123))
  call loop_VA_Q(G1(:,:,:,123),wf(:,-1),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),ZERO,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,0),G2tensor(:,32))
  call check_last_QA_V(l_switch,G1(:,:,:,121),wf(:,9),G1tensor(:,33))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,8),MB,G1(:,:,:,125))
  call loop_AQ_V(G1(:,:,:,125),wf(:,49),G1(:,:,:,126))
  call check_last_UV_W(l_switch,G1(:,:,:,126),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,126),wf(:,-1),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,62),ZERO,G2(:,:,:,183))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,0),G2tensor(:,34))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,40),MB,G2(:,:,:,184))
  call loop_AQ_V(G2(:,:,:,184),wf(:,4),G2(:,:,:,185))
  call check_last_UV_W(l_switch,G2(:,:,:,185),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,78))
  call loop_VA_Q(G2(:,:,:,185),wf(:,-1),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,62),ZERO,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,79))
  call loop_AS_Q(G2(:,:,:,184),wf(:,-4),G2(:,:,:,187),gH)
  call loop_A_Q(G2(:,:,:,187),Q(:,56),MB,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,19),G3tensor(:,80))
  call loop_AV_Q(G3(:,:,:,57),wf(:,1),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,59),MB,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,-2),G4tensor(:,17))
  call loop_AQ_V(G3(:,:,:,57),wf(:,-2),G3(:,:,:,59))
  call loop_VA_Q(G3(:,:,:,59),wf(:,-1),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,62),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,184),wf(:,1),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,43),MB,G3(:,:,:,61))
  call loop_AS_Q(G3(:,:,:,61),wf(:,-4),G3(:,:,:,62),gH)
  call loop_A_Q(G3(:,:,:,62),Q(:,59),MB,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-2),G4tensor(:,19))
  call loop_AQ_V(G1(:,:,:,125),wf(:,4),G1(:,:,:,129))
  call loop_UV_W(G1(:,:,:,129),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,189))
  call check_last_UV_W(l_switch,G2(:,:,:,189),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,81))
  call loop_VA_Q(G2(:,:,:,189),wf(:,-1),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,62),ZERO,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,0),G3tensor(:,82))
  call loop_VQ_A(G1(:,:,:,129),wf(:,24),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,61),ZERO,G2(:,:,:,191))
  call check_last_QA_V(l_switch,G2(:,:,:,191),wf(:,-1),G2tensor(:,35))
  call loop_VA_Q(G1(:,:,:,129),wf(:,27),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),ZERO,G2(:,:,:,192))
  call check_last_AQ_V(l_switch,G2(:,:,:,192),wf(:,0),G2tensor(:,36))
  call loop_VA_Q(G1(:,:,:,129),wf(:,-1),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,30),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-5),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,62),ZERO,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,0),G3tensor(:,83))
  call loop_AQ_V(G1(:,:,:,125),wf(:,52),G1(:,:,:,133))
  call check_last_UV_W(l_switch,G1(:,:,:,133),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,133),wf(:,-1),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,62),ZERO,G2(:,:,:,195))
  call check_last_AQ_V(l_switch,G2(:,:,:,195),wf(:,0),G2tensor(:,38))
  call loop_AS_Q(G1(:,:,:,125),wf(:,-4),G1(:,:,:,135),gH)
  call loop_A_Q(G1(:,:,:,135),Q(:,24),MB,G2(:,:,:,196))
  call loop_AQ_V(G2(:,:,:,196),wf(:,14),G2(:,:,:,197))
  call check_last_UV_W(l_switch,G2(:,:,:,197),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,84))
  call loop_VA_Q(G2(:,:,:,197),wf(:,-1),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,62),ZERO,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,0),G3tensor(:,85))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-5),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,56),MB,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,19),G3tensor(:,86))
  call loop_AV_Q(G3(:,:,:,66),wf(:,1),G3(:,:,:,67))
  call loop_A_Q(G3(:,:,:,67),Q(:,59),MB,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-2),G4tensor(:,20))
  call loop_AQ_V(G3(:,:,:,66),wf(:,-2),G3(:,:,:,68))
  call loop_VA_Q(G3(:,:,:,68),wf(:,-1),G3(:,:,:,69))
  call loop_A_Q(G3(:,:,:,69),Q(:,62),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,21))
  call loop_AV_Q(G2(:,:,:,196),wf(:,11),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,59),MB,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,-2),G3tensor(:,87))
  call loop_AV_Q(G2(:,:,:,196),wf(:,1),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,27),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,59),MB,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,-2),G4tensor(:,22))
  call loop_AQ_V(G2(:,:,:,196),wf(:,-2),G2(:,:,:,202))
  call loop_UV_W(G2(:,:,:,202),Q(:,28),wf(:,-5),Q(:,32),G3(:,:,:,73))
  call check_last_UV_W(l_switch,G3(:,:,:,73),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,23))
  call loop_VA_Q(G3(:,:,:,73),wf(:,-1),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,62),ZERO,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,24))
  call loop_VQ_A(G2(:,:,:,202),wf(:,24),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,61),ZERO,G3(:,:,:,75))
  call check_last_QA_V(l_switch,G3(:,:,:,75),wf(:,-1),G3tensor(:,88))
  call loop_VA_Q(G2(:,:,:,202),wf(:,27),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,62),ZERO,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,89))
  call loop_VA_Q(G2(:,:,:,202),wf(:,-1),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,30),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-5),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,62),ZERO,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,25))
  call loop_AV_Q(G2(:,:,:,196),wf(:,25),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,59),MB,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,-2),G3tensor(:,90))
  call loop_AV_Q(G2(:,:,:,196),wf(:,28),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,59),MB,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,-2),G3tensor(:,91))
  call loop_AV_Q(G1(:,:,:,125),wf(:,11),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,43),MB,G2(:,:,:,208))
  call loop_AS_Q(G2(:,:,:,208),wf(:,-4),G2(:,:,:,209),gH)
  call loop_A_Q(G2(:,:,:,209),Q(:,59),MB,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,-2),G3tensor(:,92))
  call loop_AV_Q(G1(:,:,:,125),wf(:,1),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,11),MB,G2(:,:,:,210))
  call loop_AV_Q(G2(:,:,:,210),wf(:,-5),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,43),MB,G3(:,:,:,82))
  call loop_AS_Q(G3(:,:,:,82),wf(:,-4),G3(:,:,:,83),gH)
  call loop_A_Q(G3(:,:,:,83),Q(:,59),MB,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,-2),G4tensor(:,26))
  call loop_AS_Q(G2(:,:,:,210),wf(:,-4),G2(:,:,:,212),gH)
  call loop_A_Q(G2(:,:,:,212),Q(:,27),MB,G3(:,:,:,84))
  call loop_AV_Q(G3(:,:,:,84),wf(:,-5),G3(:,:,:,85))
  call loop_A_Q(G3(:,:,:,85),Q(:,59),MB,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,-2),G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,125),wf(:,25),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,43),MB,G2(:,:,:,213))
  call loop_AS_Q(G2(:,:,:,213),wf(:,-4),G2(:,:,:,214),gH)
  call loop_A_Q(G2(:,:,:,214),Q(:,59),MB,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,-2),G3tensor(:,93))
  call loop_AV_Q(G1(:,:,:,125),wf(:,28),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,43),MB,G2(:,:,:,215))
  call loop_AS_Q(G2(:,:,:,215),wf(:,-4),G2(:,:,:,216),gH)
  call loop_A_Q(G2(:,:,:,216),Q(:,59),MB,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,-2),G3tensor(:,94))
  call loop_VQ_A(G0(:,:,:,1),wf(:,99),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,23),MB,G1(:,:,:,140))
  call loop_QV_A(G1(:,:,:,140),wf(:,-5),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,55),MB,G2(:,:,:,217))
  call check_last_QA_V(l_switch,G2(:,:,:,217),wf(:,-3),G2tensor(:,39))
  call loop_VQ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,36),MB,G1(:,:,:,142))
  call loop_QV_A(G1(:,:,:,142),wf(:,1),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,39),MB,G2(:,:,:,218))
  call check_last_QA_V(l_switch,G2(:,:,:,218),wf(:,15),G2tensor(:,40))
  call loop_QS_A(G2(:,:,:,218),wf(:,-4),G2(:,:,:,219),gH)
  call loop_Q_A(G2(:,:,:,219),Q(:,55),MB,G3(:,:,:,88))
  call check_last_QA_V(l_switch,G3(:,:,:,88),wf(:,-3),G3tensor(:,95))
  call loop_QS_A(G1(:,:,:,142),wf(:,-4),G1(:,:,:,144),gH)
  call loop_Q_A(G1(:,:,:,144),Q(:,52),MB,G2(:,:,:,220))
  call check_last_QA_V(l_switch,G2(:,:,:,220),wf(:,9),G2tensor(:,41))
  call loop_QV_A(G2(:,:,:,220),wf(:,1),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,55),MB,G3(:,:,:,89))
  call check_last_QA_V(l_switch,G3(:,:,:,89),wf(:,-3),G3tensor(:,96))
  call loop_QA_V(G2(:,:,:,220),wf(:,-3),G2(:,:,:,222))
  call loop_VA_Q(G2(:,:,:,222),wf(:,-1),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,62),ZERO,G3(:,:,:,90))
  call check_last_AQ_V(l_switch,G3(:,:,:,90),wf(:,0),G3tensor(:,97))
  call loop_QA_V(G1(:,:,:,142),wf(:,15),G1(:,:,:,145))
  call loop_VA_Q(G1(:,:,:,145),wf(:,-1),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,62),ZERO,G2(:,:,:,224))
  call check_last_AQ_V(l_switch,G2(:,:,:,224),wf(:,0),G2tensor(:,42))
  call check_last_QA_V(l_switch,G1(:,:,:,142),wf(:,110),G1tensor(:,34))
  call check_last_QA_V(l_switch,G1(:,:,:,142),wf(:,138),G1tensor(:,35))
  call loop_VA_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,24),MB,G1(:,:,:,147))
  call loop_AQ_V(G1(:,:,:,147),wf(:,14),G1(:,:,:,148))
  call check_last_UV_W(l_switch,G1(:,:,:,148),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,43))
  call loop_VA_Q(G1(:,:,:,148),wf(:,-1),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,62),ZERO,G2(:,:,:,225))
  call check_last_AQ_V(l_switch,G2(:,:,:,225),wf(:,0),G2tensor(:,44))
  call loop_AV_Q(G1(:,:,:,147),wf(:,-5),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,56),MB,G2(:,:,:,226))
  call check_last_AQ_V(l_switch,G2(:,:,:,226),wf(:,19),G2tensor(:,45))
  call loop_AV_Q(G2(:,:,:,226),wf(:,1),G2(:,:,:,227))
  call loop_A_Q(G2(:,:,:,227),Q(:,59),MB,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,-2),G3tensor(:,98))
  call loop_AQ_V(G2(:,:,:,226),wf(:,-2),G2(:,:,:,228))
  call loop_VA_Q(G2(:,:,:,228),wf(:,-1),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,62),ZERO,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,0),G3tensor(:,99))
  call loop_AV_Q(G1(:,:,:,147),wf(:,11),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,59),MB,G2(:,:,:,230))
  call check_last_AQ_V(l_switch,G2(:,:,:,230),wf(:,-2),G2tensor(:,46))
  call loop_AV_Q(G1(:,:,:,147),wf(:,1),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,27),MB,G2(:,:,:,231))
  call loop_AV_Q(G2(:,:,:,231),wf(:,-5),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,59),MB,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,-2),G3tensor(:,100))
  call loop_AQ_V(G1(:,:,:,147),wf(:,-2),G1(:,:,:,153))
  call loop_UV_W(G1(:,:,:,153),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,233))
  call check_last_UV_W(l_switch,G2(:,:,:,233),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,101))
  call loop_VA_Q(G2(:,:,:,233),wf(:,-1),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,62),ZERO,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,0),G3tensor(:,102))
  call loop_VQ_A(G1(:,:,:,153),wf(:,24),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,61),ZERO,G2(:,:,:,235))
  call check_last_QA_V(l_switch,G2(:,:,:,235),wf(:,-1),G2tensor(:,47))
  call loop_VA_Q(G1(:,:,:,153),wf(:,27),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,62),ZERO,G2(:,:,:,236))
  call check_last_AQ_V(l_switch,G2(:,:,:,236),wf(:,0),G2tensor(:,48))
  call loop_VA_Q(G1(:,:,:,153),wf(:,-1),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,30),ZERO,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-5),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,62),ZERO,G3(:,:,:,95))
  call check_last_AQ_V(l_switch,G3(:,:,:,95),wf(:,0),G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,147),wf(:,25),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,59),MB,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,-2),G2tensor(:,49))
  call loop_AV_Q(G1(:,:,:,147),wf(:,28),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,59),MB,G2(:,:,:,240))
  call check_last_AQ_V(l_switch,G2(:,:,:,240),wf(:,-2),G2tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,28),ZERO,G1(:,:,:,159))
  call loop_AV_Q(G1(:,:,:,159),wf(:,-5),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,60),ZERO,G2(:,:,:,241))
  call loop_AV_Q(G2(:,:,:,241),wf(:,1),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,63),ZERO,G3tensor(:,104))
  call loop_AV_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,28),MT,G1(:,:,:,161))
  call loop_AV_Q(G1(:,:,:,161),wf(:,-5),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,60),MT,G2(:,:,:,243))
  call loop_AV_Q(G2(:,:,:,243),wf(:,1),G2(:,:,:,244))
  call check_last_A_Q(l_switch,G2(:,:,:,244),Q(:,63),MT,G3tensor(:,105))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,28),ZERO,G1(:,:,:,163))
  call loop_QV_A(G1(:,:,:,163),wf(:,-5),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,60),ZERO,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,1),G2(:,:,:,246))
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,63),ZERO,G3tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,28),MT,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,-5),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,60),MT,G2(:,:,:,247))
  call loop_QV_A(G2(:,:,:,247),wf(:,1),G2(:,:,:,248))
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,107))
  call loop_AV_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,28),MB,G1(:,:,:,167))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-5),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,60),MB,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,1),G2(:,:,:,250))
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,63),MB,G3tensor(:,108))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,28),MB,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,60),MB,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,1),G2(:,:,:,252))
  call check_last_Q_A(l_switch,G2(:,:,:,252),Q(:,63),MB,G3tensor(:,109))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,20),G1(:,:,:,171))
  call loop_DV_C(G1(:,:,:,171),Q(:,28),wf(:,-5),G2(:,:,:,253))
  call check_last_DV_C(l_switch,G2(:,:,:,253),Q(:,60),wf(:,1),G3tensor(:,110))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,28),G1(:,:,:,172))
  call loop_CV_D(G1(:,:,:,172),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,254))
  call check_last_CV_D(l_switch,G2(:,:,:,254),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,111))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,28),G1(:,:,:,173))
  call loop_UV_W(G1(:,:,:,173),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,255))
  call check_last_UV_W(l_switch,G2(:,:,:,255),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,112))
  call loop_VA_Q(G2(:,:,:,255),wf(:,-1),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,62),ZERO,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,0),G3tensor(:,113))
  call loop_VQ_A(G1(:,:,:,173),wf(:,24),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,61),ZERO,G2(:,:,:,257))
  call check_last_QA_V(l_switch,G2(:,:,:,257),wf(:,-1),G2tensor(:,51))
  call loop_VA_Q(G1(:,:,:,173),wf(:,27),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,62),ZERO,G2(:,:,:,258))
  call check_last_AQ_V(l_switch,G2(:,:,:,258),wf(:,0),G2tensor(:,52))
  call loop_VA_Q(G1(:,:,:,173),wf(:,-1),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,30),ZERO,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-5),G2(:,:,:,260))
  call loop_A_Q(G2(:,:,:,260),Q(:,62),ZERO,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,0),G3tensor(:,114))
  call loop_VA_Q(G0(:,:,:,1),wf(:,60),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,56),MB,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,1),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,59),MB,G2(:,:,:,261))
  call check_last_AQ_V(l_switch,G2(:,:,:,261),wf(:,-2),G2tensor(:,53))
  call loop_AQ_V(G1(:,:,:,177),wf(:,-2),G1(:,:,:,179))
  call loop_VA_Q(G1(:,:,:,179),wf(:,-1),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,62),ZERO,G2(:,:,:,262))
  call check_last_AQ_V(l_switch,G2(:,:,:,262),wf(:,0),G2tensor(:,54))
  call check_last_AQ_V(l_switch,G1(:,:,:,177),wf(:,19),G1tensor(:,36))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,4),MB,G1(:,:,:,181))
  call loop_QA_V(G1(:,:,:,181),wf(:,60),G1(:,:,:,182))
  call check_last_UV_W(l_switch,G1(:,:,:,182),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,55))
  call loop_VA_Q(G1(:,:,:,182),wf(:,-1),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,62),ZERO,G2(:,:,:,263))
  call check_last_AQ_V(l_switch,G2(:,:,:,263),wf(:,0),G2tensor(:,56))
  call loop_QV_A(G1(:,:,:,181),wf(:,-5),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,36),MB,G2(:,:,:,264))
  call loop_QA_V(G2(:,:,:,264),wf(:,15),G2(:,:,:,265))
  call check_last_UV_W(l_switch,G2(:,:,:,265),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,115))
  call loop_VA_Q(G2(:,:,:,265),wf(:,-1),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,62),ZERO,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,0),G3tensor(:,116))
  call loop_QS_A(G2(:,:,:,264),wf(:,-4),G2(:,:,:,267),gH)
  call loop_Q_A(G2(:,:,:,267),Q(:,52),MB,G3(:,:,:,99))
  call loop_QA_V(G3(:,:,:,99),wf(:,-3),G3(:,:,:,100))
  call check_last_UV_W(l_switch,G3(:,:,:,100),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,28))
  call loop_VA_Q(G3(:,:,:,100),wf(:,-1),G3(:,:,:,101))
  call loop_A_Q(G3(:,:,:,101),Q(:,62),ZERO,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,0),G4tensor(:,29))
  call loop_QA_V(G1(:,:,:,181),wf(:,15),G1(:,:,:,185))
  call loop_UV_W(G1(:,:,:,185),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,268))
  call check_last_UV_W(l_switch,G2(:,:,:,268),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,117))
  call loop_VA_Q(G2(:,:,:,268),wf(:,-1),G2(:,:,:,269))
  call loop_A_Q(G2(:,:,:,269),Q(:,62),ZERO,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,118))
  call loop_VQ_A(G1(:,:,:,185),wf(:,24),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,61),ZERO,G2(:,:,:,270))
  call check_last_QA_V(l_switch,G2(:,:,:,270),wf(:,-1),G2tensor(:,57))
  call loop_VA_Q(G1(:,:,:,185),wf(:,27),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,62),ZERO,G2(:,:,:,271))
  call check_last_AQ_V(l_switch,G2(:,:,:,271),wf(:,0),G2tensor(:,58))
  call loop_VA_Q(G1(:,:,:,185),wf(:,-1),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,30),ZERO,G2(:,:,:,272))
  call loop_AV_Q(G2(:,:,:,272),wf(:,-5),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,62),ZERO,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,119))
  call loop_QA_V(G1(:,:,:,181),wf(:,64),G1(:,:,:,189))
  call check_last_UV_W(l_switch,G1(:,:,:,189),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,59))
  call loop_VA_Q(G1(:,:,:,189),wf(:,-1),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,62),ZERO,G2(:,:,:,274))
  call check_last_AQ_V(l_switch,G2(:,:,:,274),wf(:,0),G2tensor(:,60))
  call loop_QS_A(G1(:,:,:,181),wf(:,-4),G1(:,:,:,191),gH)
  call loop_Q_A(G1(:,:,:,191),Q(:,20),MB,G2(:,:,:,275))
  call loop_QA_V(G2(:,:,:,275),wf(:,5),G2(:,:,:,276))
  call check_last_UV_W(l_switch,G2(:,:,:,276),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,120))
  call loop_VA_Q(G2(:,:,:,276),wf(:,-1),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,62),ZERO,G3(:,:,:,104))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,0),G3tensor(:,121))
  call loop_QA_V(G2(:,:,:,275),wf(:,-3),G2(:,:,:,278))
  call loop_UV_W(G2(:,:,:,278),Q(:,28),wf(:,-5),Q(:,32),G3(:,:,:,105))
  call check_last_UV_W(l_switch,G3(:,:,:,105),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,30))
  call loop_VA_Q(G3(:,:,:,105),wf(:,-1),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,62),ZERO,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,31))
  call loop_VQ_A(G2(:,:,:,278),wf(:,24),G2(:,:,:,279))
  call loop_Q_A(G2(:,:,:,279),Q(:,61),ZERO,G3(:,:,:,107))
  call check_last_QA_V(l_switch,G3(:,:,:,107),wf(:,-1),G3tensor(:,122))
  call loop_VA_Q(G2(:,:,:,278),wf(:,27),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,62),ZERO,G3(:,:,:,108))
  call check_last_AQ_V(l_switch,G3(:,:,:,108),wf(:,0),G3tensor(:,123))
  call loop_VA_Q(G2(:,:,:,278),wf(:,-1),G2(:,:,:,281))
  call loop_A_Q(G2(:,:,:,281),Q(:,30),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,62),ZERO,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,275),wf(:,-5),G2(:,:,:,282))
  call loop_Q_A(G2(:,:,:,282),Q(:,52),MB,G3(:,:,:,111))
  call loop_QA_V(G3(:,:,:,111),wf(:,-3),G3(:,:,:,112))
  call check_last_UV_W(l_switch,G3(:,:,:,112),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,33))
  call loop_VA_Q(G3(:,:,:,112),wf(:,-1),G3(:,:,:,113))
  call loop_A_Q(G3(:,:,:,113),Q(:,62),ZERO,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,0),G4tensor(:,34))
  call loop_VA_Q(G0(:,:,:,1),wf(:,110),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,27),MB,G1(:,:,:,192))
  call loop_AV_Q(G1(:,:,:,192),wf(:,-5),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,59),MB,G2(:,:,:,283))
  call check_last_AQ_V(l_switch,G2(:,:,:,283),wf(:,-2),G2tensor(:,61))
  call loop_VQ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,52),MB,G1(:,:,:,194))
  call loop_QV_A(G1(:,:,:,194),wf(:,1),G1(:,:,:,195))
  call loop_Q_A(G1(:,:,:,195),Q(:,55),MB,G2(:,:,:,284))
  call check_last_QA_V(l_switch,G2(:,:,:,284),wf(:,-3),G2tensor(:,62))
  call loop_QA_V(G1(:,:,:,194),wf(:,-3),G1(:,:,:,196))
  call loop_VA_Q(G1(:,:,:,196),wf(:,-1),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,62),ZERO,G2(:,:,:,285))
  call check_last_AQ_V(l_switch,G2(:,:,:,285),wf(:,0),G2tensor(:,63))
  call check_last_QA_V(l_switch,G1(:,:,:,194),wf(:,9),G1tensor(:,37))
  call loop_VQ_A(G0(:,:,:,1),wf(:,112),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,39),MB,G1(:,:,:,198))
  call loop_QS_A(G1(:,:,:,198),wf(:,-4),G1(:,:,:,199),gH)
  call loop_Q_A(G1(:,:,:,199),Q(:,55),MB,G2(:,:,:,286))
  call check_last_QA_V(l_switch,G2(:,:,:,286),wf(:,-3),G2tensor(:,64))
  call check_last_QA_V(l_switch,G1(:,:,:,198),wf(:,15),G1tensor(:,38))
  call loop_VA_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,56),MB,G1(:,:,:,200))
  call loop_AV_Q(G1(:,:,:,200),wf(:,1),G1(:,:,:,201))
  call loop_A_Q(G1(:,:,:,201),Q(:,59),MB,G2(:,:,:,287))
  call check_last_AQ_V(l_switch,G2(:,:,:,287),wf(:,-2),G2tensor(:,65))
  call loop_AQ_V(G1(:,:,:,200),wf(:,-2),G1(:,:,:,202))
  call loop_VA_Q(G1(:,:,:,202),wf(:,-1),G1(:,:,:,203))
  call loop_A_Q(G1(:,:,:,203),Q(:,62),ZERO,G2(:,:,:,288))
  call check_last_AQ_V(l_switch,G2(:,:,:,288),wf(:,0),G2tensor(:,66))
  call check_last_AQ_V(l_switch,G1(:,:,:,200),wf(:,19),G1tensor(:,39))
  call loop_VA_Q(G0(:,:,:,1),wf(:,97),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,43),MB,G1(:,:,:,204))
  call loop_AS_Q(G1(:,:,:,204),wf(:,-4),G1(:,:,:,205),gH)
  call loop_A_Q(G1(:,:,:,205),Q(:,59),MB,G2(:,:,:,289))
  call check_last_AQ_V(l_switch,G2(:,:,:,289),wf(:,-2),G2tensor(:,67))
  call check_last_AQ_V(l_switch,G1(:,:,:,204),wf(:,4),G1tensor(:,40))
  call loop_VQ_A(G0(:,:,:,1),wf(:,133),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,23),MB,G1(:,:,:,206))
  call loop_QV_A(G1(:,:,:,206),wf(:,-5),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,55),MB,G2(:,:,:,290))
  call check_last_QA_V(l_switch,G2(:,:,:,290),wf(:,-3),G2tensor(:,68))
  call loop_VQ_A(G0(:,:,:,1),wf(:,135),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,39),MB,G1(:,:,:,208))
  call loop_QS_A(G1(:,:,:,208),wf(:,-4),G1(:,:,:,209),gH)
  call loop_Q_A(G1(:,:,:,209),Q(:,55),MB,G2(:,:,:,291))
  call check_last_QA_V(l_switch,G2(:,:,:,291),wf(:,-3),G2tensor(:,69))
  call check_last_QA_V(l_switch,G1(:,:,:,208),wf(:,15),G1tensor(:,41))
  call loop_VA_Q(G0(:,:,:,1),wf(:,138),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,27),MB,G1(:,:,:,210))
  call loop_AV_Q(G1(:,:,:,210),wf(:,-5),G1(:,:,:,211))
  call loop_A_Q(G1(:,:,:,211),Q(:,59),MB,G2(:,:,:,292))
  call check_last_AQ_V(l_switch,G2(:,:,:,292),wf(:,-2),G2tensor(:,70))
  call loop_VA_Q(G0(:,:,:,1),wf(:,140),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,43),MB,G1(:,:,:,212))
  call loop_AS_Q(G1(:,:,:,212),wf(:,-4),G1(:,:,:,213),gH)
  call loop_A_Q(G1(:,:,:,213),Q(:,59),MB,G2(:,:,:,293))
  call check_last_AQ_V(l_switch,G2(:,:,:,293),wf(:,-2),G2tensor(:,71))
  call check_last_AQ_V(l_switch,G1(:,:,:,212),wf(:,4),G1tensor(:,42))
  call loop_VA_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,11),MB,G1(:,:,:,214))
  call loop_AV_Q(G1(:,:,:,214),wf(:,-5),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,43),MB,G2(:,:,:,294))
  call loop_AS_Q(G2(:,:,:,294),wf(:,-4),G2(:,:,:,295),gH)
  call loop_A_Q(G2(:,:,:,295),Q(:,59),MB,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,-2),G3tensor(:,124))
  call loop_AS_Q(G1(:,:,:,214),wf(:,-4),G1(:,:,:,216),gH)
  call loop_A_Q(G1(:,:,:,216),Q(:,27),MB,G2(:,:,:,296))
  call loop_AV_Q(G2(:,:,:,296),wf(:,-5),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,59),MB,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,-2),G3tensor(:,125))
  call loop_VQ_A(G0(:,:,:,1),wf(:,142),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,39),MB,G1(:,:,:,217))
  call loop_QS_A(G1(:,:,:,217),wf(:,-4),G1(:,:,:,218),gH)
  call loop_Q_A(G1(:,:,:,218),Q(:,55),MB,G2(:,:,:,298))
  call check_last_QA_V(l_switch,G2(:,:,:,298),wf(:,-3),G2tensor(:,72))
  call check_last_QA_V(l_switch,G1(:,:,:,217),wf(:,15),G1tensor(:,43))
  call loop_VA_Q(G0(:,:,:,1),wf(:,144),G0(:,:,:,66))
  call loop_A_Q(G0(:,:,:,66),Q(:,43),MB,G1(:,:,:,219))
  call loop_AS_Q(G1(:,:,:,219),wf(:,-4),G1(:,:,:,220),gH)
  call loop_A_Q(G1(:,:,:,220),Q(:,59),MB,G2(:,:,:,299))
  call check_last_AQ_V(l_switch,G2(:,:,:,299),wf(:,-2),G2tensor(:,73))
  call check_last_AQ_V(l_switch,G1(:,:,:,219),wf(:,4),G1tensor(:,44))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,35),G1(:,:,:,221))
  call loop_VQ_A(G1(:,:,:,221),wf(:,4),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,55),MB,G2(:,:,:,300))
  call check_last_QA_V(l_switch,G2(:,:,:,300),wf(:,-3),G2tensor(:,74))
  call loop_VA_Q(G1(:,:,:,221),wf(:,15),G1(:,:,:,223))
  call loop_A_Q(G1(:,:,:,223),Q(:,59),MB,G2(:,:,:,301))
  call check_last_AQ_V(l_switch,G2(:,:,:,301),wf(:,-2),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,221),wf(:,-3),G1(:,:,:,224))
  call loop_A_Q(G1(:,:,:,224),Q(:,43),MB,G2(:,:,:,302))
  call loop_AS_Q(G2(:,:,:,302),wf(:,-4),G2(:,:,:,303),gH)
  call loop_A_Q(G2(:,:,:,303),Q(:,59),MB,G3(:,:,:,116))
  call check_last_AQ_V(l_switch,G3(:,:,:,116),wf(:,-2),G3tensor(:,126))
  call check_last_UV_W(l_switch,G1(:,:,:,221),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,76))
  call check_last_UV_W(l_switch,G1(:,:,:,221),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,77))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,33),ZERO,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,10),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,61),ZERO,G2(:,:,:,304))
  call check_last_QA_V(l_switch,G2(:,:,:,304),wf(:,-1),G2tensor(:,78))
  call loop_QV_A(G1(:,:,:,225),wf(:,20),G1(:,:,:,227))
  call loop_Q_A(G1(:,:,:,227),Q(:,61),ZERO,G2(:,:,:,305))
  call check_last_QA_V(l_switch,G2(:,:,:,305),wf(:,-1),G2tensor(:,79))
  call check_last_QA_V(l_switch,G1(:,:,:,225),wf(:,151),G1tensor(:,45))
  call check_last_QA_V(l_switch,G1(:,:,:,225),wf(:,157),G1tensor(:,46))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,35),G1(:,:,:,228))
  call loop_VQ_A(G1(:,:,:,228),wf(:,4),G1(:,:,:,229))
  call loop_Q_A(G1(:,:,:,229),Q(:,55),MB,G2(:,:,:,306))
  call check_last_QA_V(l_switch,G2(:,:,:,306),wf(:,-3),G2tensor(:,80))
  call loop_VA_Q(G1(:,:,:,228),wf(:,15),G1(:,:,:,230))
  call loop_A_Q(G1(:,:,:,230),Q(:,59),MB,G2(:,:,:,307))
  call check_last_AQ_V(l_switch,G2(:,:,:,307),wf(:,-2),G2tensor(:,81))
  call loop_VA_Q(G1(:,:,:,228),wf(:,-3),G1(:,:,:,231))
  call loop_A_Q(G1(:,:,:,231),Q(:,43),MB,G2(:,:,:,308))
  call loop_AS_Q(G2(:,:,:,308),wf(:,-4),G2(:,:,:,309),gH)
  call loop_A_Q(G2(:,:,:,309),Q(:,59),MB,G3(:,:,:,117))
  call check_last_AQ_V(l_switch,G3(:,:,:,117),wf(:,-2),G3tensor(:,127))
  call check_last_UV_W(l_switch,G1(:,:,:,228),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,82))
  call check_last_UV_W(l_switch,G1(:,:,:,228),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,83))
  call loop_VA_Q(G0(:,:,:,1),wf(:,27),G0(:,:,:,68))
  call loop_A_Q(G0(:,:,:,68),Q(:,34),ZERO,G1(:,:,:,232))
  call loop_AV_Q(G1(:,:,:,232),wf(:,10),G1(:,:,:,233))
  call loop_A_Q(G1(:,:,:,233),Q(:,62),ZERO,G2(:,:,:,310))
  call check_last_AQ_V(l_switch,G2(:,:,:,310),wf(:,0),G2tensor(:,84))
  call loop_AV_Q(G1(:,:,:,232),wf(:,20),G1(:,:,:,234))
  call loop_A_Q(G1(:,:,:,234),Q(:,62),ZERO,G2(:,:,:,311))
  call check_last_AQ_V(l_switch,G2(:,:,:,311),wf(:,0),G2tensor(:,85))
  call check_last_AQ_V(l_switch,G1(:,:,:,232),wf(:,149),G1tensor(:,47))
  call check_last_AQ_V(l_switch,G1(:,:,:,232),wf(:,155),G1tensor(:,48))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,69))
  call loop_A_Q(G0(:,:,:,69),Q(:,2),ZERO,G1(:,:,:,235))
  call loop_AV_Q(G1(:,:,:,235),wf(:,93),G1(:,:,:,236))
  call loop_A_Q(G1(:,:,:,236),Q(:,62),ZERO,G2(:,:,:,312))
  call check_last_AQ_V(l_switch,G2(:,:,:,312),wf(:,0),G2tensor(:,86))
  call loop_AV_Q(G1(:,:,:,235),wf(:,152),G1(:,:,:,237))
  call loop_A_Q(G1(:,:,:,237),Q(:,62),ZERO,G2(:,:,:,313))
  call check_last_AQ_V(l_switch,G2(:,:,:,313),wf(:,0),G2tensor(:,87))
  call loop_AV_Q(G1(:,:,:,235),wf(:,10),G1(:,:,:,238))
  call loop_A_Q(G1(:,:,:,238),Q(:,30),ZERO,G2(:,:,:,314))
  call loop_AV_Q(G2(:,:,:,314),wf(:,-5),G2(:,:,:,315))
  call loop_A_Q(G2(:,:,:,315),Q(:,62),ZERO,G3(:,:,:,118))
  call check_last_AQ_V(l_switch,G3(:,:,:,118),wf(:,0),G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,235),wf(:,-5),G1(:,:,:,239))
  call loop_A_Q(G1(:,:,:,239),Q(:,34),ZERO,G2(:,:,:,316))
  call loop_AV_Q(G2(:,:,:,316),wf(:,10),G2(:,:,:,317))
  call loop_A_Q(G2(:,:,:,317),Q(:,62),ZERO,G3(:,:,:,119))
  call check_last_AQ_V(l_switch,G3(:,:,:,119),wf(:,0),G3tensor(:,129))
  call loop_AV_Q(G2(:,:,:,316),wf(:,20),G2(:,:,:,318))
  call loop_A_Q(G2(:,:,:,318),Q(:,62),ZERO,G3(:,:,:,120))
  call check_last_AQ_V(l_switch,G3(:,:,:,120),wf(:,0),G3tensor(:,130))
  call loop_AV_Q(G1(:,:,:,235),wf(:,153),G1(:,:,:,240))
  call loop_A_Q(G1(:,:,:,240),Q(:,62),ZERO,G2(:,:,:,319))
  call check_last_AQ_V(l_switch,G2(:,:,:,319),wf(:,0),G2tensor(:,88))
  call loop_AV_Q(G1(:,:,:,235),wf(:,107),G1(:,:,:,241))
  call loop_A_Q(G1(:,:,:,241),Q(:,62),ZERO,G2(:,:,:,320))
  call check_last_AQ_V(l_switch,G2(:,:,:,320),wf(:,0),G2tensor(:,89))
  call loop_AV_Q(G1(:,:,:,235),wf(:,158),G1(:,:,:,242))
  call loop_A_Q(G1(:,:,:,242),Q(:,62),ZERO,G2(:,:,:,321))
  call check_last_AQ_V(l_switch,G2(:,:,:,321),wf(:,0),G2tensor(:,90))
  call loop_AV_Q(G1(:,:,:,235),wf(:,20),G1(:,:,:,243))
  call loop_A_Q(G1(:,:,:,243),Q(:,30),ZERO,G2(:,:,:,322))
  call loop_AV_Q(G2(:,:,:,322),wf(:,-5),G2(:,:,:,323))
  call loop_A_Q(G2(:,:,:,323),Q(:,62),ZERO,G3(:,:,:,121))
  call check_last_AQ_V(l_switch,G3(:,:,:,121),wf(:,0),G3tensor(:,131))
  call loop_AV_Q(G1(:,:,:,235),wf(:,159),G1(:,:,:,244))
  call loop_A_Q(G1(:,:,:,244),Q(:,62),ZERO,G2(:,:,:,324))
  call check_last_AQ_V(l_switch,G2(:,:,:,324),wf(:,0),G2tensor(:,91))
  call loop_AV_Q(G1(:,:,:,235),wf(:,168),G1(:,:,:,245))
  call loop_A_Q(G1(:,:,:,245),Q(:,62),ZERO,G2(:,:,:,325))
  call check_last_AQ_V(l_switch,G2(:,:,:,325),wf(:,0),G2tensor(:,92))
  call loop_AV_Q(G1(:,:,:,235),wf(:,169),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,62),ZERO,G2(:,:,:,326))
  call check_last_AQ_V(l_switch,G2(:,:,:,326),wf(:,0),G2tensor(:,93))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,93),Q(:,60),G1(:,:,:,247))
  call loop_VA_Q(G1(:,:,:,247),wf(:,-1),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,62),ZERO,G2(:,:,:,327))
  call check_last_AQ_V(l_switch,G2(:,:,:,327),wf(:,0),G2tensor(:,94))
  call check_last_UV_W(l_switch,G1(:,:,:,247),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,95))
  call loop_VQ_A(G0(:,:,:,1),wf(:,149),G0(:,:,:,70))
  call loop_Q_A(G0(:,:,:,70),Q(:,29),ZERO,G1(:,:,:,249))
  call loop_QV_A(G1(:,:,:,249),wf(:,-5),G1(:,:,:,250))
  call loop_Q_A(G1(:,:,:,250),Q(:,61),ZERO,G2(:,:,:,328))
  call check_last_QA_V(l_switch,G2(:,:,:,328),wf(:,-1),G2tensor(:,96))
  call loop_VA_Q(G0(:,:,:,1),wf(:,151),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,30),ZERO,G1(:,:,:,251))
  call loop_AV_Q(G1(:,:,:,251),wf(:,-5),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,62),ZERO,G2(:,:,:,329))
  call check_last_AQ_V(l_switch,G2(:,:,:,329),wf(:,0),G2tensor(:,97))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,152),Q(:,60),G1(:,:,:,253))
  call loop_VA_Q(G1(:,:,:,253),wf(:,-1),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,62),ZERO,G2(:,:,:,330))
  call check_last_AQ_V(l_switch,G2(:,:,:,330),wf(:,0),G2tensor(:,98))
  call check_last_UV_W(l_switch,G1(:,:,:,253),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,99))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,153),Q(:,60),G1(:,:,:,255))
  call loop_VA_Q(G1(:,:,:,255),wf(:,-1),G1(:,:,:,256))
  call loop_A_Q(G1(:,:,:,256),Q(:,62),ZERO,G2(:,:,:,331))
  call check_last_AQ_V(l_switch,G2(:,:,:,331),wf(:,0),G2tensor(:,100))
  call check_last_UV_W(l_switch,G1(:,:,:,255),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,101))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,107),Q(:,60),G1(:,:,:,257))
  call loop_VA_Q(G1(:,:,:,257),wf(:,-1),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,62),ZERO,G2(:,:,:,332))
  call check_last_AQ_V(l_switch,G2(:,:,:,332),wf(:,0),G2tensor(:,102))
  call check_last_UV_W(l_switch,G1(:,:,:,257),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,103))
  call loop_VQ_A(G0(:,:,:,1),wf(:,155),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,29),ZERO,G1(:,:,:,259))
  call loop_QV_A(G1(:,:,:,259),wf(:,-5),G1(:,:,:,260))
  call loop_Q_A(G1(:,:,:,260),Q(:,61),ZERO,G2(:,:,:,333))
  call check_last_QA_V(l_switch,G2(:,:,:,333),wf(:,-1),G2tensor(:,104))
  call loop_VA_Q(G0(:,:,:,1),wf(:,157),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,30),ZERO,G1(:,:,:,261))
  call loop_AV_Q(G1(:,:,:,261),wf(:,-5),G1(:,:,:,262))
  call loop_A_Q(G1(:,:,:,262),Q(:,62),ZERO,G2(:,:,:,334))
  call check_last_AQ_V(l_switch,G2(:,:,:,334),wf(:,0),G2tensor(:,105))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,158),Q(:,60),G1(:,:,:,263))
  call loop_VA_Q(G1(:,:,:,263),wf(:,-1),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,62),ZERO,G2(:,:,:,335))
  call check_last_AQ_V(l_switch,G2(:,:,:,335),wf(:,0),G2tensor(:,106))
  call check_last_UV_W(l_switch,G1(:,:,:,263),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,107))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,159),Q(:,60),G1(:,:,:,265))
  call loop_VA_Q(G1(:,:,:,265),wf(:,-1),G1(:,:,:,266))
  call loop_A_Q(G1(:,:,:,266),Q(:,62),ZERO,G2(:,:,:,336))
  call check_last_AQ_V(l_switch,G2(:,:,:,336),wf(:,0),G2tensor(:,108))
  call check_last_UV_W(l_switch,G1(:,:,:,265),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,109))
  call loop_VQ_A(G0(:,:,:,1),wf(:,161),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,39),MB,G1(:,:,:,267))
  call loop_QS_A(G1(:,:,:,267),wf(:,-4),G1(:,:,:,268),gH)
  call loop_Q_A(G1(:,:,:,268),Q(:,55),MB,G2(:,:,:,337))
  call check_last_QA_V(l_switch,G2(:,:,:,337),wf(:,-3),G2tensor(:,110))
  call check_last_QA_V(l_switch,G1(:,:,:,267),wf(:,15),G1tensor(:,49))
  call loop_VA_Q(G0(:,:,:,1),wf(:,163),G0(:,:,:,75))
  call loop_A_Q(G0(:,:,:,75),Q(:,43),MB,G1(:,:,:,269))
  call loop_AS_Q(G1(:,:,:,269),wf(:,-4),G1(:,:,:,270),gH)
  call loop_A_Q(G1(:,:,:,270),Q(:,59),MB,G2(:,:,:,338))
  call check_last_AQ_V(l_switch,G2(:,:,:,338),wf(:,-2),G2tensor(:,111))
  call check_last_AQ_V(l_switch,G1(:,:,:,269),wf(:,4),G1tensor(:,50))
  call loop_VQ_A(G0(:,:,:,1),wf(:,165),G0(:,:,:,76))
  call loop_Q_A(G0(:,:,:,76),Q(:,39),MB,G1(:,:,:,271))
  call loop_QS_A(G1(:,:,:,271),wf(:,-4),G1(:,:,:,272),gH)
  call loop_Q_A(G1(:,:,:,272),Q(:,55),MB,G2(:,:,:,339))
  call check_last_QA_V(l_switch,G2(:,:,:,339),wf(:,-3),G2tensor(:,112))
  call check_last_QA_V(l_switch,G1(:,:,:,271),wf(:,15),G1tensor(:,51))
  call loop_VA_Q(G0(:,:,:,1),wf(:,167),G0(:,:,:,77))
  call loop_A_Q(G0(:,:,:,77),Q(:,43),MB,G1(:,:,:,273))
  call loop_AS_Q(G1(:,:,:,273),wf(:,-4),G1(:,:,:,274),gH)
  call loop_A_Q(G1(:,:,:,274),Q(:,59),MB,G2(:,:,:,340))
  call check_last_AQ_V(l_switch,G2(:,:,:,340),wf(:,-2),G2tensor(:,113))
  call check_last_AQ_V(l_switch,G1(:,:,:,273),wf(:,4),G1tensor(:,52))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,168),Q(:,60),G1(:,:,:,275))
  call loop_VA_Q(G1(:,:,:,275),wf(:,-1),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,62),ZERO,G2(:,:,:,341))
  call check_last_AQ_V(l_switch,G2(:,:,:,341),wf(:,0),G2tensor(:,114))
  call check_last_UV_W(l_switch,G1(:,:,:,275),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,115))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,169),Q(:,60),G1(:,:,:,277))
  call loop_VA_Q(G1(:,:,:,277),wf(:,-1),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,62),ZERO,G2(:,:,:,342))
  call check_last_AQ_V(l_switch,G2(:,:,:,342),wf(:,0),G2tensor(:,116))
  call check_last_UV_W(l_switch,G1(:,:,:,277),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,117))
  call loop_QV_A(G0(:,:,:,1),wf(:,93),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,60),ZERO,G1(:,:,:,279))
  call loop_QV_A(G1(:,:,:,279),wf(:,1),G1(:,:,:,280))
  call check_last_Q_A(l_switch,G1(:,:,:,280),Q(:,63),ZERO,G2tensor(:,118))
  call loop_QV_A(G0(:,:,:,1),wf(:,93),G0(:,:,:,79))
  call loop_Q_A(G0(:,:,:,79),Q(:,60),MT,G1(:,:,:,281))
  call loop_QV_A(G1(:,:,:,281),wf(:,1),G1(:,:,:,282))
  call check_last_Q_A(l_switch,G1(:,:,:,282),Q(:,63),MT,G2tensor(:,119))
  call loop_QV_A(G0(:,:,:,1),wf(:,93),G0(:,:,:,80))
  call loop_Q_A(G0(:,:,:,80),Q(:,60),MB,G1(:,:,:,283))
  call loop_QV_A(G1(:,:,:,283),wf(:,1),G1(:,:,:,284))
  call check_last_Q_A(l_switch,G1(:,:,:,284),Q(:,63),MB,G2tensor(:,120))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,93),Q(:,60),G1(:,:,:,285))
  call check_last_CV_D(l_switch,G1(:,:,:,285),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,121))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,81))
  call loop_Q_A(G0(:,:,:,81),Q(:,35),ZERO,G1(:,:,:,286))
  call loop_QV_A(G1(:,:,:,286),wf(:,10),G1(:,:,:,287))
  call check_last_Q_A(l_switch,G1(:,:,:,287),Q(:,63),ZERO,G2tensor(:,122))
  call loop_QV_A(G1(:,:,:,286),wf(:,20),G1(:,:,:,288))
  call check_last_Q_A(l_switch,G1(:,:,:,288),Q(:,63),ZERO,G2tensor(:,123))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,82))
  call loop_Q_A(G0(:,:,:,82),Q(:,35),MT,G1(:,:,:,289))
  call loop_QV_A(G1(:,:,:,289),wf(:,10),G1(:,:,:,290))
  call check_last_Q_A(l_switch,G1(:,:,:,290),Q(:,63),MT,G2tensor(:,124))
  call loop_QV_A(G1(:,:,:,289),wf(:,20),G1(:,:,:,291))
  call check_last_Q_A(l_switch,G1(:,:,:,291),Q(:,63),MT,G2tensor(:,125))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,83))
  call loop_Q_A(G0(:,:,:,83),Q(:,35),MB,G1(:,:,:,292))
  call loop_QV_A(G1(:,:,:,292),wf(:,10),G1(:,:,:,293))
  call check_last_Q_A(l_switch,G1(:,:,:,293),Q(:,63),MB,G2tensor(:,126))
  call loop_QV_A(G1(:,:,:,292),wf(:,20),G1(:,:,:,294))
  call check_last_Q_A(l_switch,G1(:,:,:,294),Q(:,63),MB,G2tensor(:,127))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,35),G1(:,:,:,295))
  call check_last_CV_D(l_switch,G1(:,:,:,295),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,128))
  call check_last_CV_D(l_switch,G1(:,:,:,295),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,129))
  call loop_QV_A(G0(:,:,:,1),wf(:,152),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,60),ZERO,G1(:,:,:,296))
  call loop_QV_A(G1(:,:,:,296),wf(:,1),G1(:,:,:,297))
  call check_last_Q_A(l_switch,G1(:,:,:,297),Q(:,63),ZERO,G2tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,152),G0(:,:,:,85))
  call loop_Q_A(G0(:,:,:,85),Q(:,60),MT,G1(:,:,:,298))
  call loop_QV_A(G1(:,:,:,298),wf(:,1),G1(:,:,:,299))
  call check_last_Q_A(l_switch,G1(:,:,:,299),Q(:,63),MT,G2tensor(:,131))
  call loop_QV_A(G0(:,:,:,1),wf(:,152),G0(:,:,:,86))
  call loop_Q_A(G0(:,:,:,86),Q(:,60),MB,G1(:,:,:,300))
  call loop_QV_A(G1(:,:,:,300),wf(:,1),G1(:,:,:,301))
  call check_last_Q_A(l_switch,G1(:,:,:,301),Q(:,63),MB,G2tensor(:,132))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,152),Q(:,60),G1(:,:,:,302))
  call check_last_CV_D(l_switch,G1(:,:,:,302),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,133))
  call loop_QV_A(G0(:,:,:,1),wf(:,153),G0(:,:,:,87))
  call loop_Q_A(G0(:,:,:,87),Q(:,60),ZERO,G1(:,:,:,303))
  call loop_QV_A(G1(:,:,:,303),wf(:,1),G1(:,:,:,304))
  call check_last_Q_A(l_switch,G1(:,:,:,304),Q(:,63),ZERO,G2tensor(:,134))
  call loop_QV_A(G0(:,:,:,1),wf(:,153),G0(:,:,:,88))
  call loop_Q_A(G0(:,:,:,88),Q(:,60),MT,G1(:,:,:,305))
  call loop_QV_A(G1(:,:,:,305),wf(:,1),G1(:,:,:,306))
  call check_last_Q_A(l_switch,G1(:,:,:,306),Q(:,63),MT,G2tensor(:,135))
  call loop_QV_A(G0(:,:,:,1),wf(:,153),G0(:,:,:,89))
  call loop_Q_A(G0(:,:,:,89),Q(:,60),MB,G1(:,:,:,307))
  call loop_QV_A(G1(:,:,:,307),wf(:,1),G1(:,:,:,308))
  call check_last_Q_A(l_switch,G1(:,:,:,308),Q(:,63),MB,G2tensor(:,136))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,153),Q(:,60),G1(:,:,:,309))
  call check_last_CV_D(l_switch,G1(:,:,:,309),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,137))
  call loop_QV_A(G0(:,:,:,1),wf(:,107),G0(:,:,:,90))
  call loop_Q_A(G0(:,:,:,90),Q(:,60),ZERO,G1(:,:,:,310))
  call loop_QV_A(G1(:,:,:,310),wf(:,1),G1(:,:,:,311))
  call check_last_Q_A(l_switch,G1(:,:,:,311),Q(:,63),ZERO,G2tensor(:,138))
  call loop_QV_A(G0(:,:,:,1),wf(:,107),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,60),MT,G1(:,:,:,312))
  call loop_QV_A(G1(:,:,:,312),wf(:,1),G1(:,:,:,313))
  call check_last_Q_A(l_switch,G1(:,:,:,313),Q(:,63),MT,G2tensor(:,139))
  call loop_QV_A(G0(:,:,:,1),wf(:,107),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,60),MB,G1(:,:,:,314))
  call loop_QV_A(G1(:,:,:,314),wf(:,1),G1(:,:,:,315))
  call check_last_Q_A(l_switch,G1(:,:,:,315),Q(:,63),MB,G2tensor(:,140))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,107),Q(:,60),G1(:,:,:,316))
  call check_last_CV_D(l_switch,G1(:,:,:,316),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,141))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,93))
  call loop_Q_A(G0(:,:,:,93),Q(:,60),ZERO,G1(:,:,:,317))
  call loop_QV_A(G1(:,:,:,317),wf(:,1),G1(:,:,:,318))
  call check_last_Q_A(l_switch,G1(:,:,:,318),Q(:,63),ZERO,G2tensor(:,142))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,94))
  call loop_Q_A(G0(:,:,:,94),Q(:,60),MT,G1(:,:,:,319))
  call loop_QV_A(G1(:,:,:,319),wf(:,1),G1(:,:,:,320))
  call check_last_Q_A(l_switch,G1(:,:,:,320),Q(:,63),MT,G2tensor(:,143))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,95))
  call loop_Q_A(G0(:,:,:,95),Q(:,60),MB,G1(:,:,:,321))
  call loop_QV_A(G1(:,:,:,321),wf(:,1),G1(:,:,:,322))
  call check_last_Q_A(l_switch,G1(:,:,:,322),Q(:,63),MB,G2tensor(:,144))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,158),Q(:,60),G1(:,:,:,323))
  call check_last_CV_D(l_switch,G1(:,:,:,323),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,145))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,60),ZERO,G1(:,:,:,324))
  call loop_QV_A(G1(:,:,:,324),wf(:,1),G1(:,:,:,325))
  call check_last_Q_A(l_switch,G1(:,:,:,325),Q(:,63),ZERO,G2tensor(:,146))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,97))
  call loop_Q_A(G0(:,:,:,97),Q(:,60),MT,G1(:,:,:,326))
  call loop_QV_A(G1(:,:,:,326),wf(:,1),G1(:,:,:,327))
  call check_last_Q_A(l_switch,G1(:,:,:,327),Q(:,63),MT,G2tensor(:,147))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,98))
  call loop_Q_A(G0(:,:,:,98),Q(:,60),MB,G1(:,:,:,328))
  call loop_QV_A(G1(:,:,:,328),wf(:,1),G1(:,:,:,329))
  call check_last_Q_A(l_switch,G1(:,:,:,329),Q(:,63),MB,G2tensor(:,148))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,159),Q(:,60),G1(:,:,:,330))
  call check_last_CV_D(l_switch,G1(:,:,:,330),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,149))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,60),ZERO,G1(:,:,:,331))
  call loop_QV_A(G1(:,:,:,331),wf(:,1),G1(:,:,:,332))
  call check_last_Q_A(l_switch,G1(:,:,:,332),Q(:,63),ZERO,G2tensor(:,150))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,100))
  call loop_Q_A(G0(:,:,:,100),Q(:,60),MT,G1(:,:,:,333))
  call loop_QV_A(G1(:,:,:,333),wf(:,1),G1(:,:,:,334))
  call check_last_Q_A(l_switch,G1(:,:,:,334),Q(:,63),MT,G2tensor(:,151))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,101))
  call loop_Q_A(G0(:,:,:,101),Q(:,60),MB,G1(:,:,:,335))
  call loop_QV_A(G1(:,:,:,335),wf(:,1),G1(:,:,:,336))
  call check_last_Q_A(l_switch,G1(:,:,:,336),Q(:,63),MB,G2tensor(:,152))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,168),Q(:,60),G1(:,:,:,337))
  call check_last_CV_D(l_switch,G1(:,:,:,337),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,153))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,60),ZERO,G1(:,:,:,338))
  call loop_QV_A(G1(:,:,:,338),wf(:,1),G1(:,:,:,339))
  call check_last_Q_A(l_switch,G1(:,:,:,339),Q(:,63),ZERO,G2tensor(:,154))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,103))
  call loop_Q_A(G0(:,:,:,103),Q(:,60),MT,G1(:,:,:,340))
  call loop_QV_A(G1(:,:,:,340),wf(:,1),G1(:,:,:,341))
  call check_last_Q_A(l_switch,G1(:,:,:,341),Q(:,63),MT,G2tensor(:,155))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,104))
  call loop_Q_A(G0(:,:,:,104),Q(:,60),MB,G1(:,:,:,342))
  call loop_QV_A(G1(:,:,:,342),wf(:,1),G1(:,:,:,343))
  call check_last_Q_A(l_switch,G1(:,:,:,343),Q(:,63),MB,G2tensor(:,156))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,169),Q(:,60),G1(:,:,:,344))
  call check_last_CV_D(l_switch,G1(:,:,:,344),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,157))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,105))
  call loop_Q_A(G0(:,:,:,105),Q(:,35),ZERO,G1(:,:,:,345))
  call loop_QV_A(G1(:,:,:,345),wf(:,10),G1(:,:,:,346))
  call check_last_Q_A(l_switch,G1(:,:,:,346),Q(:,63),ZERO,G2tensor(:,158))
  call loop_QV_A(G1(:,:,:,345),wf(:,20),G1(:,:,:,347))
  call check_last_Q_A(l_switch,G1(:,:,:,347),Q(:,63),ZERO,G2tensor(:,159))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,106))
  call loop_Q_A(G0(:,:,:,106),Q(:,35),MT,G1(:,:,:,348))
  call loop_QV_A(G1(:,:,:,348),wf(:,10),G1(:,:,:,349))
  call check_last_Q_A(l_switch,G1(:,:,:,349),Q(:,63),MT,G2tensor(:,160))
  call loop_QV_A(G1(:,:,:,348),wf(:,20),G1(:,:,:,350))
  call check_last_Q_A(l_switch,G1(:,:,:,350),Q(:,63),MT,G2tensor(:,161))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,107))
  call loop_Q_A(G0(:,:,:,107),Q(:,35),MB,G1(:,:,:,351))
  call loop_QV_A(G1(:,:,:,351),wf(:,10),G1(:,:,:,352))
  call check_last_Q_A(l_switch,G1(:,:,:,352),Q(:,63),MB,G2tensor(:,162))
  call loop_QV_A(G1(:,:,:,351),wf(:,20),G1(:,:,:,353))
  call check_last_Q_A(l_switch,G1(:,:,:,353),Q(:,63),MB,G2tensor(:,163))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,35),G1(:,:,:,354))
  call check_last_CV_D(l_switch,G1(:,:,:,354),Q(:,35),wf(:,10),Q(:,28),G2tensor(:,164))
  call check_last_CV_D(l_switch,G1(:,:,:,354),Q(:,35),wf(:,20),Q(:,28),G2tensor(:,165))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,108))
  call loop_Q_A(G0(:,:,:,108),Q(:,35),ZERO,G1(:,:,:,355))
  call loop_QV_A(G1(:,:,:,355),wf(:,10),G1(:,:,:,356))
  call check_last_Q_A(l_switch,G1(:,:,:,356),Q(:,63),ZERO,G2tensor(:,166))
  call loop_QV_A(G1(:,:,:,355),wf(:,20),G1(:,:,:,357))
  call check_last_Q_A(l_switch,G1(:,:,:,357),Q(:,63),ZERO,G2tensor(:,167))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,1),T2sum(1:5,1))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,1),T2sum(1:5,1))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,1),T2sum(1:5,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,5),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,5),T2sum(1:5,1))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,5),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,9),T2sum(1:5,1))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(1,momenta_39,masses2_9,G1tensor(:,9),T2sum(1:5,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,2),T2sum(1:5,2))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,2),T2sum(1:5,2))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,2),T2sum(1:5,2))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,6),T2sum(1:5,2))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,6),T2sum(1:5,2))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,6),T2sum(1:5,2))
  M(2) = M(2) + ((-3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,10),T2sum(1:5,2))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(1,momenta_40,masses2_9,G1tensor(:,10),T2sum(1:5,2))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,1),T3sum(1:15,1))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,1),T3sum(1:15,1))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,1),T3sum(1:15,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,2),T3sum(1:15,1))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,2),T3sum(1:15,1))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,2),T3sum(1:15,1))
  M(2) = M(2) + ((-3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,3),T3sum(1:15,1))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(2,momenta_93,masses2_16,G2tensor(:,3),T3sum(1:15,1))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,13),T2sum(1:5,3))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,13),T2sum(1:5,3))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,13),T2sum(1:5,3))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,15),T2sum(1:5,3))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,15),T2sum(1:5,3))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,15),T2sum(1:5,3))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,17),T2sum(1:5,3))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,17),T2sum(1:5,3))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,19),T2sum(1:5,3))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,19),T2sum(1:5,3))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,19),T2sum(1:5,3))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,21),T2sum(1:5,3))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,21),T2sum(1:5,3))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,21),T2sum(1:5,3))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,23),T2sum(1:5,3))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(1,momenta_49,masses2_10,G1tensor(:,23),T2sum(1:5,3))
  M(2) = M(2) + ((CI*f(24))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,1),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(24))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(24))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,12),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(24))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,12),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,23),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,23),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,34),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(34)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,34),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(24))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,2),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(24))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,2),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(24))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(24))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,24),T3sum(1:35,5))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,35),T3sum(1:35,5))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,35),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(24))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,14),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(24))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,14),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(24))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,3),T3sum(1:35,6))
  M(3) = M(3) + ((CI*f(24))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,3),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,36),T3sum(1:35,7))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,36),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,25),T3sum(1:35,7))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,25),T3sum(1:35,7))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,5),T4sum(1:70,1))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,7),T4sum(1:70,1))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,7),T4sum(1:70,1))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_15,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,9),T4sum(1:70,2))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,9),T4sum(1:70,2))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,11),T4sum(1:70,2))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,11),T4sum(1:70,2))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_71,masses2_11,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,8),T4sum(1:70,3))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,8),T4sum(1:70,3))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,6),T4sum(1:70,3))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,6),T4sum(1:70,3))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_15,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,12),T4sum(1:70,4))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,12),T4sum(1:70,4))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,12),T4sum(1:70,4))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,10),T4sum(1:70,4))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,10),T4sum(1:70,4))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_70,masses2_11,G4tensor(:,10),T4sum(1:70,4))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,1),T4sum(1:70,5))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,1),T4sum(1:70,5))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,1),T4sum(1:70,5))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,2),T4sum(1:70,5))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,2),T4sum(1:70,5))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_15,G4tensor(:,2),T4sum(1:70,5))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,3),T4sum(1:70,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,3),T4sum(1:70,6))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,3),T4sum(1:70,6))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,4),T4sum(1:70,6))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,4),T4sum(1:70,6))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(39)) * TI2_call(4,momenta_72,masses2_11,G4tensor(:,4),T4sum(1:70,6))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(160)) * TI2_call(2,momenta_44,masses2_6,G2tensor(:,4),T2sum(1:15,4))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(160)) * TI2_call(2,momenta_44,masses2_6,G2tensor(:,4),T2sum(1:15,4))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(160)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,7),T2sum(1:15,5))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(160)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,7),T2sum(1:15,5))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(8)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,9),T2sum(1:15,6))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(8)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,9),T2sum(1:15,6))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,15),T2sum(1:15,7))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_31,masses2_9,G2tensor(:,15),T2sum(1:15,7))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(49)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,10),T2sum(1:15,8))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(49)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,10),T2sum(1:15,8))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(49)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,25),T2sum(1:15,1))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(49)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,25),T2sum(1:15,1))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,68),T3sum(1:35,9))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,68),T3sum(1:35,9))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,68),T3sum(1:35,9))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,70),T3sum(1:35,9))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,70),T3sum(1:35,9))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,70),T3sum(1:35,9))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,67),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,71),T3sum(1:35,10))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,71),T3sum(1:35,10))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,71),T3sum(1:35,10))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,72),T3sum(1:35,10))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,72),T3sum(1:35,10))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,72),T3sum(1:35,10))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,73),T3sum(1:35,8))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,73),T3sum(1:35,8))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,74),T3sum(1:35,8))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,74),T3sum(1:35,8))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,75),T3sum(1:35,8))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(11)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(51)) * TI2_call(2,momenta_47,masses2_6,G2tensor(:,31),T2sum(1:15,9))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(51)) * TI2_call(2,momenta_47,masses2_6,G2tensor(:,31),T2sum(1:15,9))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(51)) * TI2_call(2,momenta_14,masses2_7,G2tensor(:,33),T2sum(1:15,10))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(51)) * TI2_call(2,momenta_14,masses2_7,G2tensor(:,33),T2sum(1:15,10))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(81)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,39),T2sum(1:15,11))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(81)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,39),T2sum(1:15,11))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(81)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,16),T2sum(1:15,12))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(81)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,16),T2sum(1:15,12))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_65,masses2_13,G3tensor(:,78),T3sum(1:35,11))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_90,masses2_16,G3tensor(:,54),T3sum(1:35,12))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_73,masses2_12,G3tensor(:,50),T3sum(1:35,13))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(4)) * TI2_call(3,momenta_73,masses2_12,G3tensor(:,50),T3sum(1:35,13))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(4)) * TI2_call(3,momenta_73,masses2_12,G3tensor(:,50),T3sum(1:35,13))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_74,masses2_14,G3tensor(:,51),T3sum(1:35,14))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_74,masses2_14,G3tensor(:,51),T3sum(1:35,14))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(4)) * TI2_call(3,momenta_74,masses2_14,G3tensor(:,51),T3sum(1:35,14))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_77,masses2_12,G3tensor(:,48),T3sum(1:35,15))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(4)) * TI2_call(3,momenta_77,masses2_12,G3tensor(:,48),T3sum(1:35,15))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(4)) * TI2_call(3,momenta_77,masses2_12,G3tensor(:,48),T3sum(1:35,15))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_61,masses2_14,G3tensor(:,81),T3sum(1:35,16))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(4)) * TI2_call(3,momenta_61,masses2_14,G3tensor(:,81),T3sum(1:35,16))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(4)) * TI2_call(3,momenta_61,masses2_14,G3tensor(:,81),T3sum(1:35,16))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(161)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,40),T2sum(1:15,13))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(161)) * TI2_call(2,momenta_41,masses2_6,G2tensor(:,40),T2sum(1:15,13))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(161)) * TI2_call(2,momenta_24,masses2_7,G2tensor(:,43),T2sum(1:15,14))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(161)) * TI2_call(2,momenta_24,masses2_7,G2tensor(:,43),T2sum(1:15,14))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(18)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,45),T2sum(1:15,15))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(18)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,45),T2sum(1:15,15))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,17),T2sum(1:15,16))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_33,masses2_9,G2tensor(:,17),T2sum(1:15,16))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(54)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,46),T2sum(1:15,17))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(54)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,46),T2sum(1:15,17))
  M(2) = M(2) + ((-3*f(17))/4._/**/REALKIND * den(54)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,26),T2sum(1:15,2))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(54)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,26),T2sum(1:15,2))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,105),T3sum(1:35,9))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,105),T3sum(1:35,9))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,105),T3sum(1:35,9))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,107),T3sum(1:35,9))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,107),T3sum(1:35,9))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_8,G3tensor(:,107),T3sum(1:35,9))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,104),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,108),T3sum(1:35,10))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,108),T3sum(1:35,10))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,108),T3sum(1:35,10))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,106),T3sum(1:35,8))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,109),T3sum(1:35,10))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,109),T3sum(1:35,10))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_5,G3tensor(:,109),T3sum(1:35,10))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,110),T3sum(1:35,8))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,110),T3sum(1:35,8))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,111),T3sum(1:35,8))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,111),T3sum(1:35,8))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,112),T3sum(1:35,8))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(20)) * TI2_call(3,momenta_26,masses2_10,G3tensor(:,112),T3sum(1:35,8))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(57)) * TI2_call(2,momenta_48,masses2_6,G2tensor(:,53),T2sum(1:15,18))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(57)) * TI2_call(2,momenta_48,masses2_6,G2tensor(:,53),T2sum(1:15,18))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(57)) * TI2_call(2,momenta_13,masses2_7,G2tensor(:,55),T2sum(1:15,19))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(57)) * TI2_call(2,momenta_13,masses2_7,G2tensor(:,55),T2sum(1:15,19))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(96)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,61),T2sum(1:15,20))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(96)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,61),T2sum(1:15,20))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(96)) * TI2_call(2,momenta_34,masses2_9,G2tensor(:,18),T2sum(1:15,21))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(96)) * TI2_call(2,momenta_34,masses2_9,G2tensor(:,18),T2sum(1:15,21))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_56,masses2_13,G3tensor(:,115),T3sum(1:35,17))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_91,masses2_16,G3tensor(:,56),T3sum(1:35,18))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_79,masses2_12,G3tensor(:,100),T3sum(1:35,19))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(94)) * TI2_call(3,momenta_79,masses2_12,G3tensor(:,100),T3sum(1:35,19))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(94)) * TI2_call(3,momenta_79,masses2_12,G3tensor(:,100),T3sum(1:35,19))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_80,masses2_14,G3tensor(:,101),T3sum(1:35,20))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_80,masses2_14,G3tensor(:,101),T3sum(1:35,20))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(94)) * TI2_call(3,momenta_80,masses2_14,G3tensor(:,101),T3sum(1:35,20))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_83,masses2_12,G3tensor(:,98),T3sum(1:35,21))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(94)) * TI2_call(3,momenta_83,masses2_12,G3tensor(:,98),T3sum(1:35,21))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(94)) * TI2_call(3,momenta_83,masses2_12,G3tensor(:,98),T3sum(1:35,21))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_53,masses2_14,G3tensor(:,117),T3sum(1:35,22))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(94)) * TI2_call(3,momenta_53,masses2_14,G3tensor(:,117),T3sum(1:35,22))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(94)) * TI2_call(3,momenta_53,masses2_14,G3tensor(:,117),T3sum(1:35,22))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(21)) * TI2_call(2,momenta_42,masses2_6,G2tensor(:,41),T2sum(1:15,22))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(21)) * TI2_call(2,momenta_42,masses2_6,G2tensor(:,41),T2sum(1:15,22))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,8),T3sum(1:35,4))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,8),T3sum(1:35,4))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,19),T3sum(1:35,4))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,19),T3sum(1:35,4))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,30),T3sum(1:35,5))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,30),T3sum(1:35,5))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(42)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,41),T3sum(1:35,5))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(42)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,41),T3sum(1:35,5))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(53)) * TI2_call(2,momenta_47,masses2_6,G2tensor(:,62),T2sum(1:15,9))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(53)) * TI2_call(2,momenta_47,masses2_6,G2tensor(:,62),T2sum(1:15,9))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(53)) * TI2_call(2,momenta_14,masses2_7,G2tensor(:,37),T2sum(1:15,10))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(53)) * TI2_call(2,momenta_14,masses2_7,G2tensor(:,37),T2sum(1:15,10))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(99)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,64),T2sum(1:15,23))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(99)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,64),T2sum(1:15,23))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_60,masses2_13,G3tensor(:,84),T3sum(1:35,23))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_60,masses2_13,G3tensor(:,84),T3sum(1:35,23))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_94,masses2_12,G3tensor(:,95),T3sum(1:35,24))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(14)) * TI2_call(3,momenta_94,masses2_12,G3tensor(:,95),T3sum(1:35,24))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_95,masses2_12,G3tensor(:,96),T3sum(1:35,25))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(14)) * TI2_call(3,momenta_95,masses2_12,G3tensor(:,96),T3sum(1:35,25))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(22)) * TI2_call(2,momenta_45,masses2_6,G2tensor(:,5),T2sum(1:15,24))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(22)) * TI2_call(2,momenta_45,masses2_6,G2tensor(:,5),T2sum(1:15,24))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(44)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,9),T3sum(1:35,4))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(44)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,9),T3sum(1:35,4))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(44)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,20),T3sum(1:35,4))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(44)) * TI2_call(3,momenta_17,masses2_8,G3tensor(:,20),T3sum(1:35,4))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(44)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,31),T3sum(1:35,5))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(44)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,31),T3sum(1:35,5))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(44)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,42),T3sum(1:35,5))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(44)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,42),T3sum(1:35,5))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(59)) * TI2_call(2,momenta_48,masses2_6,G2tensor(:,65),T2sum(1:15,18))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(59)) * TI2_call(2,momenta_48,masses2_6,G2tensor(:,65),T2sum(1:15,18))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(59)) * TI2_call(2,momenta_13,masses2_7,G2tensor(:,59),T2sum(1:15,19))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(59)) * TI2_call(2,momenta_13,masses2_7,G2tensor(:,59),T2sum(1:15,19))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(78)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,67),T2sum(1:15,25))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(78)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,67),T2sum(1:15,25))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_52,masses2_13,G3tensor(:,120),T3sum(1:35,26))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_52,masses2_13,G3tensor(:,120),T3sum(1:35,26))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_97,masses2_12,G3tensor(:,45),T3sum(1:35,27))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(76)) * TI2_call(3,momenta_97,masses2_12,G3tensor(:,45),T3sum(1:35,27))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_98,masses2_12,G3tensor(:,46),T3sum(1:35,28))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(76)) * TI2_call(3,momenta_98,masses2_12,G3tensor(:,46),T3sum(1:35,28))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(132)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,15),T3sum(1:35,6))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,15),T3sum(1:35,6))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(132)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,4),T3sum(1:35,6))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,4),T3sum(1:35,6))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(132)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,37),T3sum(1:35,7))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,37),T3sum(1:35,7))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(132)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,26),T3sum(1:35,7))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,26),T3sum(1:35,7))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(133)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,68),T2sum(1:15,11))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(133)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,68),T2sum(1:15,11))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(133)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,19),T2sum(1:15,12))
  M(4) = M(4) + ((CI*f(15))/4._/**/REALKIND * den(133)) * TI2_call(2,momenta_32,masses2_9,G2tensor(:,19),T2sum(1:15,12))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(134)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,69),T2sum(1:15,23))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(134)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,69),T2sum(1:15,23))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_88,masses2_16,G3tensor(:,58),T3sum(1:35,29))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_88,masses2_16,G3tensor(:,58),T3sum(1:35,29))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_58,masses2_12,G3tensor(:,86),T3sum(1:35,30))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(17)) * TI2_call(3,momenta_58,masses2_12,G3tensor(:,86),T3sum(1:35,30))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_64,masses2_12,G3tensor(:,80),T3sum(1:35,31))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(17)) * TI2_call(3,momenta_64,masses2_12,G3tensor(:,80),T3sum(1:35,31))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(135)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,16),T3sum(1:35,6))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(135)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,16),T3sum(1:35,6))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(135)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,5),T3sum(1:35,6))
  M(4) = M(4) + (f(25)/12._/**/REALKIND * den(135)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,5),T3sum(1:35,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(135)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,38),T3sum(1:35,7))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(135)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,38),T3sum(1:35,7))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(135)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,27),T3sum(1:35,7))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(135)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,27),T3sum(1:35,7))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(136)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,70),T2sum(1:15,20))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(136)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,70),T2sum(1:15,20))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(136)) * TI2_call(2,momenta_34,masses2_9,G2tensor(:,20),T2sum(1:15,21))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(136)) * TI2_call(2,momenta_34,masses2_9,G2tensor(:,20),T2sum(1:15,21))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(137)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,71),T2sum(1:15,25))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(137)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,71),T2sum(1:15,25))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(7)) * TI2_call(3,momenta_89,masses2_16,G3tensor(:,60),T3sum(1:35,32))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(7)) * TI2_call(3,momenta_89,masses2_16,G3tensor(:,60),T3sum(1:35,32))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(7)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,124),T3sum(1:35,33))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(7)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,124),T3sum(1:35,33))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(7)) * TI2_call(3,momenta_68,masses2_12,G3tensor(:,125),T3sum(1:35,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(7)) * TI2_call(3,momenta_68,masses2_12,G3tensor(:,125),T3sum(1:35,34))
  M(2) = M(2) + ((-2*CI*f(15))/3._/**/REALKIND * den(138)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,72),T2sum(1:15,23))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(138)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,72),T2sum(1:15,23))
  M(2) = M(2) + ((-2*CI*f(15))/3._/**/REALKIND * den(139)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,73),T2sum(1:15,25))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(139)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,73),T2sum(1:15,25))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,92),T3sum(1:35,35))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,92),T3sum(1:35,35))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,87),T3sum(1:35,36))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(33)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,87),T3sum(1:35,36))
  M(2) = M(2) + ((-3*f(17))/4._/**/REALKIND * den(33)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,66),T3sum(1:35,1))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(33)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,66),T3sum(1:35,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_121,masses2_18,G4tensor(:,19),T4sum(1:70,7))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_121,masses2_18,G4tensor(:,19),T4sum(1:70,7))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_121,masses2_18,G4tensor(:,19),T4sum(1:70,7))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_112,masses2_18,G4tensor(:,26),T4sum(1:70,8))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_112,masses2_18,G4tensor(:,26),T4sum(1:70,8))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_112,masses2_18,G4tensor(:,26),T4sum(1:70,8))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_113,masses2_18,G4tensor(:,22),T4sum(1:70,9))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_113,masses2_18,G4tensor(:,22),T4sum(1:70,9))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_113,masses2_18,G4tensor(:,22),T4sum(1:70,9))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_111,masses2_18,G4tensor(:,27),T4sum(1:70,10))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_111,masses2_18,G4tensor(:,27),T4sum(1:70,10))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_111,masses2_18,G4tensor(:,27),T4sum(1:70,10))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_117,masses2_18,G4tensor(:,20),T4sum(1:70,11))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_117,masses2_18,G4tensor(:,20),T4sum(1:70,11))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_117,masses2_18,G4tensor(:,20),T4sum(1:70,11))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_122,masses2_18,G4tensor(:,17),T4sum(1:70,12))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(1)) * TI2_call(4,momenta_122,masses2_18,G4tensor(:,17),T4sum(1:70,12))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(1)) * TI2_call(4,momenta_122,masses2_18,G4tensor(:,17),T4sum(1:70,12))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_114,masses2_20,G4tensor(:,23),T4sum(1:70,13))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_114,masses2_20,G4tensor(:,23),T4sum(1:70,13))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(1)) * TI2_call(4,momenta_114,masses2_20,G4tensor(:,23),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_131,masses2_22,G4tensor(:,15),T4sum(1:70,14))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_102,masses2_20,G4tensor(:,30),T4sum(1:70,15))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_102,masses2_20,G4tensor(:,30),T4sum(1:70,15))
  M(4) = M(4) + (-(f(17)/4._/**/REALKIND) * den(1)) * TI2_call(4,momenta_102,masses2_20,G4tensor(:,30),T4sum(1:70,15))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_105,masses2_19,G4tensor(:,33),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_132,masses2_22,G4tensor(:,13),T4sum(1:70,17))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(1)) * TI2_call(4,momenta_109,masses2_19,G4tensor(:,28),T4sum(1:70,18))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(60)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,21),T3sum(1:35,2))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(60)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(60)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,10),T3sum(1:35,2))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(60)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(60)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,43),T3sum(1:35,3))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(60)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(60)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,32),T3sum(1:35,3))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(60)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(61)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,22),T3sum(1:35,2))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(61)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(61)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,11),T3sum(1:35,2))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(61)) * TI2_call(3,momenta_16,masses2_8,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(61)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,44),T3sum(1:35,3))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(61)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(61)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,33),T3sum(1:35,3))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(61)) * TI2_call(3,momenta_16,masses2_5,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(140)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,17),T3sum(1:35,6))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(140)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,17),T3sum(1:35,6))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(140)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,6),T3sum(1:35,6))
  M(2) = M(2) + (-(f(25)/4._/**/REALKIND) * den(140)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,6),T3sum(1:35,6))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(140)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,39),T3sum(1:35,7))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(140)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,39),T3sum(1:35,7))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(140)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,28),T3sum(1:35,7))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(140)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,28),T3sum(1:35,7))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(143)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,18),T3sum(1:35,6))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(143)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,18),T3sum(1:35,6))
  M(1) = M(1) + (f(25)/12._/**/REALKIND * den(143)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,7),T3sum(1:35,6))
  M(3) = M(3) + (-(f(25)/4._/**/REALKIND) * den(143)) * TI2_call(3,momenta_15,masses2_8,G3tensor(:,7),T3sum(1:35,6))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(143)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,40),T3sum(1:35,7))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(143)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,40),T3sum(1:35,7))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(143)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,29),T3sum(1:35,7))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(143)) * TI2_call(3,momenta_15,masses2_5,G3tensor(:,29),T3sum(1:35,7))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(26)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,13),T2sum(1:15,8))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(26)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,13),T2sum(1:15,8))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(26)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,74),T2sum(1:15,1))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(26)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,74),T2sum(1:15,1))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(68)) * TI2_call(2,momenta_37,masses2_10,G2tensor(:,78),T2sum(1:15,26))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(68)) * TI2_call(2,momenta_37,masses2_10,G2tensor(:,78),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(68)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,29),T2sum(1:15,27))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(68)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,29),T2sum(1:15,27))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(162)) * TI2_call(2,momenta_62,masses2_14,G2tensor(:,35),T2sum(1:15,28))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(162)) * TI2_call(2,momenta_62,masses2_14,G2tensor(:,35),T2sum(1:15,28))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(162)) * TI2_call(2,momenta_75,masses2_14,G2tensor(:,11),T2sum(1:15,29))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(162)) * TI2_call(2,momenta_75,masses2_14,G2tensor(:,11),T2sum(1:15,29))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(29)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,14),T2sum(1:15,8))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(29)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,14),T2sum(1:15,8))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(29)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,80),T2sum(1:15,1))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(29)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,80),T2sum(1:15,1))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(70)) * TI2_call(2,momenta_38,masses2_10,G2tensor(:,84),T2sum(1:15,30))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(70)) * TI2_call(2,momenta_38,masses2_10,G2tensor(:,84),T2sum(1:15,30))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(70)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,30),T2sum(1:15,31))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(70)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,30),T2sum(1:15,31))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(163)) * TI2_call(2,momenta_63,masses2_14,G2tensor(:,36),T2sum(1:15,32))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(163)) * TI2_call(2,momenta_63,masses2_14,G2tensor(:,36),T2sum(1:15,32))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(163)) * TI2_call(2,momenta_76,masses2_14,G2tensor(:,12),T2sum(1:15,33))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(163)) * TI2_call(2,momenta_76,masses2_14,G2tensor(:,12),T2sum(1:15,33))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(74)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,86),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(74)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,86),T2sum(1:15,34))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(74)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,94),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(74)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,94),T2sum(1:15,3))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(72)) * TI2_call(2,momenta_78,masses2_14,G2tensor(:,8),T2sum(1:15,35))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(72)) * TI2_call(2,momenta_78,masses2_14,G2tensor(:,8),T2sum(1:15,35))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(72)) * TI2_call(2,momenta_99,masses2_14,G2tensor(:,6),T2sum(1:15,36))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(72)) * TI2_call(2,momenta_99,masses2_14,G2tensor(:,6),T2sum(1:15,36))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(145)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,96),T2sum(1:15,37))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(145)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,96),T2sum(1:15,37))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(145)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,21),T2sum(1:15,38))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(145)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,21),T2sum(1:15,38))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(147)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,97),T2sum(1:15,39))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(147)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,97),T2sum(1:15,39))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(147)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,22),T2sum(1:15,40))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(147)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,22),T2sum(1:15,40))
  M(2) = M(2) + (-(CI*f(15))/12._/**/REALKIND * den(148)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,87),T2sum(1:15,34))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(148)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,87),T2sum(1:15,34))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,98),T2sum(1:15,3))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,98),T2sum(1:15,3))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(10)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,128),T3sum(1:35,37))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(10)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,128),T3sum(1:35,37))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,128),T3sum(1:35,37))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(10)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,61),T3sum(1:35,38))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,61),T3sum(1:35,38))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,61),T3sum(1:35,38))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(10)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,129),T3sum(1:35,39))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(10)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,129),T3sum(1:35,39))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,129),T3sum(1:35,39))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(10)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,76),T3sum(1:35,40))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,76),T3sum(1:35,40))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,76),T3sum(1:35,40))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_85,masses2_17,G3tensor(:,77),T3sum(1:35,41))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(10)) * TI2_call(3,momenta_87,masses2_17,G3tensor(:,62),T3sum(1:35,42))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(149)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,88),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(149)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,88),T2sum(1:15,34))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(149)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,100),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(149)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,100),T2sum(1:15,3))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(50)) * TI2_call(2,momenta_67,masses2_14,G2tensor(:,34),T2sum(1:15,41))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(50)) * TI2_call(2,momenta_67,masses2_14,G2tensor(:,34),T2sum(1:15,41))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(50)) * TI2_call(2,momenta_100,masses2_14,G2tensor(:,32),T2sum(1:15,42))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(50)) * TI2_call(2,momenta_100,masses2_14,G2tensor(:,32),T2sum(1:15,42))
  M(2) = M(2) + ((2*CI*f(15))/3._/**/REALKIND * den(2)) * TI2_call(3,momenta_120,masses2_21,G3tensor(:,82),T3sum(1:35,43))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_120,masses2_21,G3tensor(:,82),T3sum(1:35,43))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_123,masses2_20,G3tensor(:,79),T3sum(1:35,44))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_123,masses2_20,G3tensor(:,79),T3sum(1:35,44))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_123,masses2_20,G3tensor(:,79),T3sum(1:35,44))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_134,masses2_23,G3tensor(:,55),T3sum(1:35,45))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_134,masses2_23,G3tensor(:,55),T3sum(1:35,45))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_134,masses2_23,G3tensor(:,55),T3sum(1:35,45))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_134,masses2_23,G3tensor(:,55),T3sum(1:35,45))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_133,masses2_23,G3tensor(:,59),T3sum(1:35,46))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(2)) * TI2_call(3,momenta_133,masses2_23,G3tensor(:,59),T3sum(1:35,46))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_126,masses2_20,G3tensor(:,49),T3sum(1:35,47))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_126,masses2_20,G3tensor(:,49),T3sum(1:35,47))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_126,masses2_20,G3tensor(:,49),T3sum(1:35,47))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_126,masses2_20,G3tensor(:,49),T3sum(1:35,47))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_125,masses2_21,G3tensor(:,52),T3sum(1:35,48))
  M(2) = M(2) + (-(CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_125,masses2_21,G3tensor(:,52),T3sum(1:35,48))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(2)) * TI2_call(3,momenta_125,masses2_21,G3tensor(:,52),T3sum(1:35,48))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_125,masses2_21,G3tensor(:,52),T3sum(1:35,48))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_119,masses2_21,G3tensor(:,83),T3sum(1:35,49))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_119,masses2_21,G3tensor(:,83),T3sum(1:35,49))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_119,masses2_21,G3tensor(:,83),T3sum(1:35,49))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(2)) * TI2_call(3,momenta_124,masses2_21,G3tensor(:,53),T3sum(1:35,50))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_124,masses2_21,G3tensor(:,53),T3sum(1:35,50))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(2)) * TI2_call(3,momenta_124,masses2_21,G3tensor(:,53),T3sum(1:35,50))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(2)) * TI2_call(3,momenta_124,masses2_21,G3tensor(:,53),T3sum(1:35,50))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(30)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,49),T2sum(1:15,17))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(30)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,49),T2sum(1:15,17))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,75),T2sum(1:15,2))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,75),T2sum(1:15,2))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(69)) * TI2_call(2,momenta_37,masses2_10,G2tensor(:,79),T2sum(1:15,26))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(69)) * TI2_call(2,momenta_37,masses2_10,G2tensor(:,79),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,51),T2sum(1:15,27))
  M(3) = M(3) + ((-3*CI*f(15))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,51),T2sum(1:15,27))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(164)) * TI2_call(2,momenta_54,masses2_14,G2tensor(:,57),T2sum(1:15,43))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(164)) * TI2_call(2,momenta_54,masses2_14,G2tensor(:,57),T2sum(1:15,43))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(164)) * TI2_call(2,momenta_81,masses2_14,G2tensor(:,47),T2sum(1:15,44))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(164)) * TI2_call(2,momenta_81,masses2_14,G2tensor(:,47),T2sum(1:15,44))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(31)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,50),T2sum(1:15,17))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(31)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,50),T2sum(1:15,17))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(31)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,81),T2sum(1:15,2))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(31)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,81),T2sum(1:15,2))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(71)) * TI2_call(2,momenta_38,masses2_10,G2tensor(:,85),T2sum(1:15,30))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(71)) * TI2_call(2,momenta_38,masses2_10,G2tensor(:,85),T2sum(1:15,30))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(71)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,52),T2sum(1:15,31))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(71)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,52),T2sum(1:15,31))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(165)) * TI2_call(2,momenta_55,masses2_14,G2tensor(:,58),T2sum(1:15,45))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(165)) * TI2_call(2,momenta_55,masses2_14,G2tensor(:,58),T2sum(1:15,45))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(165)) * TI2_call(2,momenta_82,masses2_14,G2tensor(:,48),T2sum(1:15,46))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(165)) * TI2_call(2,momenta_82,masses2_14,G2tensor(:,48),T2sum(1:15,46))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(92)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,89),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(92)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,89),T2sum(1:15,34))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(92)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,102),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(92)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,102),T2sum(1:15,3))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(91)) * TI2_call(2,momenta_96,masses2_14,G2tensor(:,42),T2sum(1:15,47))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(91)) * TI2_call(2,momenta_96,masses2_14,G2tensor(:,42),T2sum(1:15,47))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(91)) * TI2_call(2,momenta_84,masses2_14,G2tensor(:,44),T2sum(1:15,48))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(91)) * TI2_call(2,momenta_84,masses2_14,G2tensor(:,44),T2sum(1:15,48))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(150)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,104),T2sum(1:15,37))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(150)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,104),T2sum(1:15,37))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(150)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,23),T2sum(1:15,38))
  M(2) = M(2) + ((-3*CI*f(15))/4._/**/REALKIND * den(150)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,23),T2sum(1:15,38))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(151)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,105),T2sum(1:15,39))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(151)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,105),T2sum(1:15,39))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(151)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,24),T2sum(1:15,40))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(151)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,24),T2sum(1:15,40))
  M(2) = M(2) + (-(CI*f(15))/12._/**/REALKIND * den(152)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,90),T2sum(1:15,34))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(152)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,90),T2sum(1:15,34))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(152)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,106),T2sum(1:15,3))
  M(3) = M(3) + ((-3*f(17))/4._/**/REALKIND * den(152)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,106),T2sum(1:15,3))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(19)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,131),T3sum(1:35,37))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(19)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,131),T3sum(1:35,37))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_50,masses2_17,G3tensor(:,131),T3sum(1:35,37))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(19)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,64),T3sum(1:35,38))
  M(3) = M(3) + ((3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,64),T3sum(1:35,38))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_92,masses2_17,G3tensor(:,64),T3sum(1:35,38))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(19)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,130),T3sum(1:35,39))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(19)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,130),T3sum(1:35,39))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_51,masses2_17,G3tensor(:,130),T3sum(1:35,39))
  M(1) = M(1) + (-(f(17)/4._/**/REALKIND) * den(19)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,113),T3sum(1:35,40))
  M(2) = M(2) + ((3*f(17))/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,113),T3sum(1:35,40))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_86,masses2_17,G3tensor(:,113),T3sum(1:35,40))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_85,masses2_17,G3tensor(:,114),T3sum(1:35,41))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(19)) * TI2_call(3,momenta_87,masses2_17,G3tensor(:,63),T3sum(1:35,42))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(153)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,91),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(153)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,91),T2sum(1:15,34))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(153)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,108),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(153)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,108),T2sum(1:15,3))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(56)) * TI2_call(2,momenta_57,masses2_14,G2tensor(:,56),T2sum(1:15,49))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(56)) * TI2_call(2,momenta_57,masses2_14,G2tensor(:,56),T2sum(1:15,49))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(56)) * TI2_call(2,momenta_101,masses2_14,G2tensor(:,54),T2sum(1:15,50))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(56)) * TI2_call(2,momenta_101,masses2_14,G2tensor(:,54),T2sum(1:15,50))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_108,masses2_21,G3tensor(:,118),T3sum(1:35,51))
  M(2) = M(2) + (-(CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_108,masses2_21,G3tensor(:,118),T3sum(1:35,51))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_108,masses2_21,G3tensor(:,118),T3sum(1:35,51))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_108,masses2_21,G3tensor(:,118),T3sum(1:35,51))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_110,masses2_20,G3tensor(:,116),T3sum(1:35,52))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_110,masses2_20,G3tensor(:,116),T3sum(1:35,52))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_110,masses2_20,G3tensor(:,116),T3sum(1:35,52))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_110,masses2_20,G3tensor(:,116),T3sum(1:35,52))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_135,masses2_23,G3tensor(:,57),T3sum(1:35,53))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(13)) * TI2_call(3,momenta_135,masses2_23,G3tensor(:,57),T3sum(1:35,53))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_130,masses2_23,G3tensor(:,65),T3sum(1:35,54))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_130,masses2_23,G3tensor(:,65),T3sum(1:35,54))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_130,masses2_23,G3tensor(:,65),T3sum(1:35,54))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_130,masses2_23,G3tensor(:,65),T3sum(1:35,54))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_129,masses2_20,G3tensor(:,99),T3sum(1:35,55))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_129,masses2_20,G3tensor(:,99),T3sum(1:35,55))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_129,masses2_20,G3tensor(:,99),T3sum(1:35,55))
  M(2) = M(2) + ((2*CI*f(15))/3._/**/REALKIND * den(13)) * TI2_call(3,momenta_128,masses2_21,G3tensor(:,102),T3sum(1:35,56))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND * den(13)) * TI2_call(3,momenta_128,masses2_21,G3tensor(:,102),T3sum(1:35,56))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_107,masses2_21,G3tensor(:,119),T3sum(1:35,57))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_107,masses2_21,G3tensor(:,119),T3sum(1:35,57))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_107,masses2_21,G3tensor(:,119),T3sum(1:35,57))
  M(4) = M(4) + (f(17)/4._/**/REALKIND * den(13)) * TI2_call(3,momenta_107,masses2_21,G3tensor(:,119),T3sum(1:35,57))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(13)) * TI2_call(3,momenta_127,masses2_21,G3tensor(:,103),T3sum(1:35,58))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_127,masses2_21,G3tensor(:,103),T3sum(1:35,58))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(13)) * TI2_call(3,momenta_127,masses2_21,G3tensor(:,103),T3sum(1:35,58))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(154)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,110),T2sum(1:15,23))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(154)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,110),T2sum(1:15,23))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(155)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,111),T2sum(1:15,25))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(155)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,111),T2sum(1:15,25))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(25)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,93),T3sum(1:35,35))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(25)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,93),T3sum(1:35,35))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(25)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,90),T3sum(1:35,36))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(25)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,90),T3sum(1:35,36))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,126),T3sum(1:35,1))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(25)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,126),T3sum(1:35,1))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(23)) * TI2_call(3,momenta_103,masses2_20,G3tensor(:,122),T3sum(1:35,59))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(23)) * TI2_call(3,momenta_103,masses2_20,G3tensor(:,122),T3sum(1:35,59))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(23)) * TI2_call(3,momenta_115,masses2_20,G3tensor(:,88),T3sum(1:35,60))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(23)) * TI2_call(3,momenta_115,masses2_20,G3tensor(:,88),T3sum(1:35,60))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(156)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,112),T2sum(1:15,23))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(156)) * TI2_call(2,momenta_43,masses2_6,G2tensor(:,112),T2sum(1:15,23))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(157)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,113),T2sum(1:15,25))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(157)) * TI2_call(2,momenta_46,masses2_6,G2tensor(:,113),T2sum(1:15,25))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(28)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,94),T3sum(1:35,35))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(28)) * TI2_call(3,momenta_66,masses2_12,G3tensor(:,94),T3sum(1:35,35))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(28)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,91),T3sum(1:35,36))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(28)) * TI2_call(3,momenta_59,masses2_12,G3tensor(:,91),T3sum(1:35,36))
  M(1) = M(1) + (-(CI*f(15))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,127),T3sum(1:35,1))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_93,masses2_16,G3tensor(:,127),T3sum(1:35,1))
  M(1) = M(1) + ((5*f(17))/18._/**/REALKIND * den(27)) * TI2_call(3,momenta_104,masses2_20,G3tensor(:,123),T3sum(1:35,61))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(27)) * TI2_call(3,momenta_104,masses2_20,G3tensor(:,123),T3sum(1:35,61))
  M(1) = M(1) + (f(17)/36._/**/REALKIND * den(27)) * TI2_call(3,momenta_116,masses2_20,G3tensor(:,89),T3sum(1:35,62))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(27)) * TI2_call(3,momenta_116,masses2_20,G3tensor(:,89),T3sum(1:35,62))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(158)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,92),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(158)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,92),T2sum(1:15,34))
  M(2) = M(2) + ((3*CI*f(15))/4._/**/REALKIND * den(158)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,114),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(158)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,114),T2sum(1:15,3))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(52)) * TI2_call(2,momenta_67,masses2_14,G2tensor(:,38),T2sum(1:15,41))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(52)) * TI2_call(2,momenta_67,masses2_14,G2tensor(:,38),T2sum(1:15,41))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(52)) * TI2_call(2,momenta_100,masses2_14,G2tensor(:,63),T2sum(1:15,42))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(52)) * TI2_call(2,momenta_100,masses2_14,G2tensor(:,63),T2sum(1:15,42))
  M(2) = M(2) + ((7*f(17))/12._/**/REALKIND * den(12)) * TI2_call(3,momenta_118,masses2_20,G3tensor(:,85),T3sum(1:35,63))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(12)) * TI2_call(3,momenta_118,masses2_20,G3tensor(:,85),T3sum(1:35,63))
  M(2) = M(2) + (-(f(17)/6._/**/REALKIND) * den(12)) * TI2_call(3,momenta_136,masses2_20,G3tensor(:,97),T3sum(1:35,64))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(12)) * TI2_call(3,momenta_136,masses2_20,G3tensor(:,97),T3sum(1:35,64))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND) * den(159)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,93),T2sum(1:15,34))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(159)) * TI2_call(2,momenta_12,masses2_10,G2tensor(:,93),T2sum(1:15,34))
  M(3) = M(3) + ((3*CI*f(15))/4._/**/REALKIND * den(159)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,116),T2sum(1:15,3))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND * den(159)) * TI2_call(2,momenta_49,masses2_10,G2tensor(:,116),T2sum(1:15,3))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(58)) * TI2_call(2,momenta_57,masses2_14,G2tensor(:,60),T2sum(1:15,49))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(58)) * TI2_call(2,momenta_57,masses2_14,G2tensor(:,60),T2sum(1:15,49))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(58)) * TI2_call(2,momenta_101,masses2_14,G2tensor(:,66),T2sum(1:15,50))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(58)) * TI2_call(2,momenta_101,masses2_14,G2tensor(:,66),T2sum(1:15,50))
  M(3) = M(3) + (-(f(17)/6._/**/REALKIND) * den(3)) * TI2_call(3,momenta_106,masses2_20,G3tensor(:,121),T3sum(1:35,65))
  M(4) = M(4) + ((5*f(17))/18._/**/REALKIND * den(3)) * TI2_call(3,momenta_106,masses2_20,G3tensor(:,121),T3sum(1:35,65))
  M(3) = M(3) + ((7*f(17))/12._/**/REALKIND * den(3)) * TI2_call(3,momenta_137,masses2_20,G3tensor(:,47),T3sum(1:35,66))
  M(4) = M(4) + (f(17)/36._/**/REALKIND * den(3)) * TI2_call(3,momenta_137,masses2_20,G3tensor(:,47),T3sum(1:35,66))
  M(1) = M(1) + (f(17)/4._/**/REALKIND) * TI2_call(4,momenta_140,masses2_24,G4tensor(:,34),T4sum(1:70,19))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_140,masses2_24,G4tensor(:,34),T4sum(1:70,19))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_140,masses2_24,G4tensor(:,34),T4sum(1:70,19))
  M(4) = M(4) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_140,masses2_24,G4tensor(:,34),T4sum(1:70,19))
  M(1) = M(1) + (f(17)/4._/**/REALKIND) * TI2_call(4,momenta_141,masses2_24,G4tensor(:,29),T4sum(1:70,20))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_141,masses2_24,G4tensor(:,29),T4sum(1:70,20))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_141,masses2_24,G4tensor(:,29),T4sum(1:70,20))
  M(4) = M(4) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_141,masses2_24,G4tensor(:,29),T4sum(1:70,20))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND) * TI2_call(4,momenta_139,masses2_25,G4tensor(:,31),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_139,masses2_25,G4tensor(:,31),T4sum(1:70,21))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_139,masses2_25,G4tensor(:,31),T4sum(1:70,21))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND) * TI2_call(4,momenta_139,masses2_25,G4tensor(:,31),T4sum(1:70,21))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_145,masses2_24,G4tensor(:,18),T4sum(1:70,22))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_145,masses2_24,G4tensor(:,18),T4sum(1:70,22))
  M(4) = M(4) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_145,masses2_24,G4tensor(:,18),T4sum(1:70,22))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_144,masses2_24,G4tensor(:,21),T4sum(1:70,23))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_144,masses2_24,G4tensor(:,21),T4sum(1:70,23))
  M(4) = M(4) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_144,masses2_24,G4tensor(:,21),T4sum(1:70,23))
  M(2) = M(2) + ((2*CI*f(15))/3._/**/REALKIND) * TI2_call(4,momenta_143,masses2_25,G4tensor(:,24),T4sum(1:70,24))
  M(3) = M(3) + ((CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_143,masses2_25,G4tensor(:,24),T4sum(1:70,24))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_147,masses2_26,G4tensor(:,14),T4sum(1:70,25))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND) * TI2_call(4,momenta_147,masses2_26,G4tensor(:,14),T4sum(1:70,25))
  M(1) = M(1) + ((CI*f(15))/4._/**/REALKIND) * TI2_call(4,momenta_146,masses2_26,G4tensor(:,16),T4sum(1:70,26))
  M(2) = M(2) + ((CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_146,masses2_26,G4tensor(:,16),T4sum(1:70,26))
  M(3) = M(3) + (-(CI*f(15))/12._/**/REALKIND) * TI2_call(4,momenta_146,masses2_26,G4tensor(:,16),T4sum(1:70,26))
  M(4) = M(4) + (-(CI*f(15))/4._/**/REALKIND) * TI2_call(4,momenta_146,masses2_26,G4tensor(:,16),T4sum(1:70,26))
  M(1) = M(1) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_138,masses2_25,G4tensor(:,32),T4sum(1:70,27))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_138,masses2_25,G4tensor(:,32),T4sum(1:70,27))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_138,masses2_25,G4tensor(:,32),T4sum(1:70,27))
  M(4) = M(4) + (f(17)/4._/**/REALKIND) * TI2_call(4,momenta_138,masses2_25,G4tensor(:,32),T4sum(1:70,27))
  M(1) = M(1) + (f(17)/36._/**/REALKIND) * TI2_call(4,momenta_142,masses2_25,G4tensor(:,25),T4sum(1:70,28))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_142,masses2_25,G4tensor(:,25),T4sum(1:70,28))
  M(3) = M(3) + (-(f(17)/12._/**/REALKIND)) * TI2_call(4,momenta_142,masses2_25,G4tensor(:,25),T4sum(1:70,28))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,27),T1sum(1:5,1))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,27),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,28),T1sum(1:5,1))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,28),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,29),T1sum(1:5,1))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,29),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,14),T2sum(1:5,51))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,14),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,16),T2sum(1:5,51))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,16),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,18),T2sum(1:5,51))
  M(3) = M(3) + ((-3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,18),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,3),T2sum(1:5,52))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,3),T2sum(1:5,52))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,7),T2sum(1:5,52))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,7),T2sum(1:5,52))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,11),T2sum(1:5,52))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(11)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,11),T2sum(1:5,52))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,30),T1sum(1:5,1))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,30),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,31),T1sum(1:5,1))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,31),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,32),T1sum(1:5,1))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_1,masses2_4,G1tensor(:,32),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,20),T2sum(1:5,51))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,20),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,22),T2sum(1:5,51))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,22),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,24),T2sum(1:5,51))
  M(3) = M(3) + ((-3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_11,masses2_4,G1tensor(:,24),T2sum(1:5,51))
  M(2) = M(2) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,4),T2sum(1:5,52))
  M(3) = M(3) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,4),T2sum(1:5,52))
  M(2) = M(2) + ((-3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,8),T2sum(1:5,52))
  M(3) = M(3) + ((3*CI*f(14))/4._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,8),T2sum(1:5,52))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,12),T2sum(1:5,52))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(20)) * TI2_call(1,momenta_4,masses2_4,G1tensor(:,12),T2sum(1:5,52))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(82)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,25),T1sum(1:5,2))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(82)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,25),T1sum(1:5,2))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,40),T1sum(1:5,3))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,40),T1sum(1:5,3))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,118),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,118),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(75)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,119),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,119),T2sum(1:15,53))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,118),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,118),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(75)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,120),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,120),T2sum(1:15,54))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,121),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,121),T2sum(1:15,51))
  M(3) = M(3) + ((3*f(16))/2._/**/REALKIND * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,95),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(75)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,95),T2sum(1:15,51))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(89)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,33),T1sum(1:5,4))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(89)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,33),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(166)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,42),T1sum(1:5,3))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(166)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,42),T1sum(1:5,3))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,122),T2sum(1:15,52))
  M(3) = M(3) + (-(CI*f(19))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,122),T2sum(1:15,52))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,124),T2sum(1:15,55))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,124),T2sum(1:15,55))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,122),T2sum(1:15,52))
  M(3) = M(3) + (-(CI*f(19))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,122),T2sum(1:15,52))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,126),T2sum(1:15,56))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,126),T2sum(1:15,56))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,128),T2sum(1:15,52))
  M(3) = M(3) + ((-3*CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,128),T2sum(1:15,52))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,27),T2sum(1:15,52))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(90)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,27),T2sum(1:15,52))
  M(2) = M(2) + ((-2*CI*f(15))/3._/**/REALKIND * den(167)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,44),T1sum(1:5,3))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(167)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,44),T1sum(1:5,3))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,130),T2sum(1:15,51))
  M(3) = M(3) + ((CI*f(19))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,130),T2sum(1:15,51))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,131),T2sum(1:15,53))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,131),T2sum(1:15,53))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,130),T2sum(1:15,51))
  M(3) = M(3) + ((CI*f(19))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,130),T2sum(1:15,51))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,132),T2sum(1:15,54))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,132),T2sum(1:15,54))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,133),T2sum(1:15,51))
  M(3) = M(3) + ((3*CI*f(15))/2._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,133),T2sum(1:15,51))
  M(2) = M(2) + ((3*CI*f(14))/2._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,99),T2sum(1:15,51))
  M(3) = M(3) + ((-3*CI*f(14))/2._/**/REALKIND * den(168)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,99),T2sum(1:15,51))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,134),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,134),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(169)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,135),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,135),T2sum(1:15,53))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,134),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,134),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(169)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,136),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,136),T2sum(1:15,54))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,137),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,137),T2sum(1:15,51))
  M(2) = M(2) + ((3*f(16))/2._/**/REALKIND * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,101),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(169)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,101),T2sum(1:15,51))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(100)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,38),T1sum(1:5,5))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(100)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,38),T1sum(1:5,5))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(97)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,34),T1sum(1:5,6))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(97)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,34),T1sum(1:5,6))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,138),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,138),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(93)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,139),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,139),T2sum(1:15,53))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,138),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,138),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(93)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,140),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,140),T2sum(1:15,54))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,141),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,141),T2sum(1:15,51))
  M(2) = M(2) + ((3*f(16))/2._/**/REALKIND * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,103),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(93)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,103),T2sum(1:15,51))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(170)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,41),T1sum(1:5,5))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(170)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,41),T1sum(1:5,5))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(105)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,36),T1sum(1:5,7))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(105)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,36),T1sum(1:5,7))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,123),T2sum(1:15,52))
  M(3) = M(3) + (-(CI*f(19))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,123),T2sum(1:15,52))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,125),T2sum(1:15,55))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,125),T2sum(1:15,55))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,123),T2sum(1:15,52))
  M(3) = M(3) + (-(CI*f(19))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,123),T2sum(1:15,52))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,127),T2sum(1:15,56))
  M(3) = M(3) + (-(CI*f(18))/4._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,127),T2sum(1:15,56))
  M(2) = M(2) + ((3*CI*f(15))/2._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,129),T2sum(1:15,52))
  M(3) = M(3) + ((-3*CI*f(15))/2._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,129),T2sum(1:15,52))
  M(2) = M(2) + ((-3*CI*f(14))/2._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,28),T2sum(1:15,52))
  M(3) = M(3) + ((3*CI*f(14))/2._/**/REALKIND * den(106)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,28),T2sum(1:15,52))
  M(2) = M(2) + ((-2*CI*f(15))/3._/**/REALKIND * den(171)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,43),T1sum(1:5,5))
  M(3) = M(3) + ((2*CI*f(15))/3._/**/REALKIND * den(171)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,43),T1sum(1:5,5))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,142),T2sum(1:15,51))
  M(3) = M(3) + ((CI*f(19))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,142),T2sum(1:15,51))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,143),T2sum(1:15,53))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,143),T2sum(1:15,53))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,142),T2sum(1:15,51))
  M(3) = M(3) + ((CI*f(19))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,142),T2sum(1:15,51))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,144),T2sum(1:15,54))
  M(3) = M(3) + ((CI*f(18))/4._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,144),T2sum(1:15,54))
  M(2) = M(2) + ((-3*CI*f(15))/2._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,145),T2sum(1:15,51))
  M(3) = M(3) + ((3*CI*f(15))/2._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,145),T2sum(1:15,51))
  M(2) = M(2) + ((3*CI*f(14))/2._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,107),T2sum(1:15,51))
  M(3) = M(3) + ((-3*CI*f(14))/2._/**/REALKIND * den(172)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,107),T2sum(1:15,51))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,146),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,146),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(173)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,147),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,147),T2sum(1:15,53))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,146),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,146),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(173)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,148),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,148),T2sum(1:15,54))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,149),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,149),T2sum(1:15,51))
  M(3) = M(3) + ((3*f(16))/2._/**/REALKIND * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,109),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(173)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,109),T2sum(1:15,51))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(111)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,37),T1sum(1:5,4))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(111)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,37),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(174)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,35),T1sum(1:5,6))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(174)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,35),T1sum(1:5,6))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,150),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,150),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(175)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,151),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,151),T2sum(1:15,53))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,150),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,150),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(175)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,152),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,152),T2sum(1:15,54))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,153),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,153),T2sum(1:15,51))
  M(2) = M(2) + ((3*f(16))/2._/**/REALKIND * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,115),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(175)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,115),T2sum(1:15,51))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(176)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,26),T1sum(1:5,2))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(176)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,26),T1sum(1:5,2))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(113)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,39),T1sum(1:5,7))
  M(4) = M(4) + ((-2*f(17))/9._/**/REALKIND * den(113)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,39),T1sum(1:5,7))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,154),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,154),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(177)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,155),T2sum(1:15,53))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_3,G2tensor(:,155),T2sum(1:15,53))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,154),T2sum(1:15,51))
  M(4) = M(4) + (f(21)/12._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,154),T2sum(1:15,51))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(177)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,156),T2sum(1:15,54))
  M(4) = M(4) + (f(20)/12._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_1,G2tensor(:,156),T2sum(1:15,54))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,157),T2sum(1:15,51))
  M(4) = M(4) + (f(17)/2._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,157),T2sum(1:15,51))
  M(3) = M(3) + ((3*f(16))/2._/**/REALKIND * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,117),T2sum(1:15,51))
  M(4) = M(4) + (-(f(16)/2._/**/REALKIND) * den(177)) * TI2_call(2,momenta_11,masses2_4,G2tensor(:,117),T2sum(1:15,51))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(178)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,50),T1sum(1:5,3))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(178)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,50),T1sum(1:5,3))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,158),T2sum(1:15,52))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,158),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,160),T2sum(1:15,55))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(118)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,160),T2sum(1:15,55))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,158),T2sum(1:15,52))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,158),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,162),T2sum(1:15,56))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(118)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,162),T2sum(1:15,56))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,164),T2sum(1:15,52))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,164),T2sum(1:15,52))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,76),T2sum(1:15,52))
  M(3) = M(3) + ((3*f(16))/2._/**/REALKIND * den(118)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,76),T2sum(1:15,52))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(179)) * TI2_call(1,momenta_2,masses2_4,G1tensor(:,45),T1sum(1:5,8))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(179)) * TI2_call(1,momenta_2,masses2_4,G1tensor(:,45),T1sum(1:5,8))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(180)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,52),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(180)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,52),T1sum(1:5,3))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,166),T2sum(1:15,52))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,166),T2sum(1:15,52))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,166),T2sum(1:15,52))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,166),T2sum(1:15,52))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,82),T2sum(1:15,52))
  M(2) = M(2) + ((3*f(16))/2._/**/REALKIND * den(122)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,82),T2sum(1:15,52))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(181)) * TI2_call(1,momenta_3,masses2_4,G1tensor(:,47),T1sum(1:5,9))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(181)) * TI2_call(1,momenta_3,masses2_4,G1tensor(:,47),T1sum(1:5,9))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(182)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,49),T1sum(1:5,5))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(182)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,49),T1sum(1:5,5))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,159),T2sum(1:15,52))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,159),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,161),T2sum(1:15,55))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(125)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,161),T2sum(1:15,55))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,159),T2sum(1:15,52))
  M(3) = M(3) + (-(f(21)/4._/**/REALKIND) * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,159),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,163),T2sum(1:15,56))
  M(3) = M(3) + (-(f(20)/4._/**/REALKIND) * den(125)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,163),T2sum(1:15,56))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,165),T2sum(1:15,52))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,165),T2sum(1:15,52))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,77),T2sum(1:15,52))
  M(3) = M(3) + ((3*f(16))/2._/**/REALKIND * den(125)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,77),T2sum(1:15,52))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(183)) * TI2_call(1,momenta_2,masses2_4,G1tensor(:,46),T1sum(1:5,8))
  M(3) = M(3) + ((2*f(17))/3._/**/REALKIND * den(183)) * TI2_call(1,momenta_2,masses2_4,G1tensor(:,46),T1sum(1:5,8))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(184)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,51),T1sum(1:5,5))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(184)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,51),T1sum(1:5,5))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,167),T2sum(1:15,52))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,167),T2sum(1:15,52))
  M(1) = M(1) + (f(21)/12._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,167),T2sum(1:15,52))
  M(2) = M(2) + (-(f(21)/4._/**/REALKIND) * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,167),T2sum(1:15,52))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,83),T2sum(1:15,52))
  M(2) = M(2) + ((3*f(16))/2._/**/REALKIND * den(128)) * TI2_call(2,momenta_4,masses2_4,G2tensor(:,83),T2sum(1:15,52))
  M(1) = M(1) + ((-2*f(17))/9._/**/REALKIND * den(185)) * TI2_call(1,momenta_3,masses2_4,G1tensor(:,48),T1sum(1:5,9))
  M(2) = M(2) + ((2*f(17))/3._/**/REALKIND * den(185)) * TI2_call(1,momenta_3,masses2_4,G1tensor(:,48),T1sum(1:5,9))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_ddxbbxhg_1_/**/REALKIND
