
module ol_vamp_1_pphjjj2_dddxdxhg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_dddxdxhg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_dddxdxhg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_dddxdxhg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_dddxdxhg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,13) :: G0
  complex(REALKIND), dimension(4,5,4,88) :: G1
  complex(REALKIND), dimension(4,15,4,188) :: G2
  complex(REALKIND), dimension(4,35,4,48) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,88,32))
    allocate(G4tensorhel(70,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2),gH)
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,53),MT,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,2),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,58),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,8),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,5),wf(:,50),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,5),wf(:,52),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,27),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,5),wf(:,53),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,5),wf(:,55),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,5),wf(:,56),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G2(:,:,:,5),wf(:,58),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,5),wf(:,59),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,5),wf(:,61),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,26),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,-5),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,58),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,58),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,1),G2(:,:,:,19))
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,14),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,58),MT,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,1),G2(:,:,:,21))
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,23),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,57),MT,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,22),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,25),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,54),MT,G2(:,:,:,24))
  call loop_QV_A(G2(:,:,:,24),wf(:,21),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,21),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,25),MT,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-5),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,57),MT,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,22),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,30),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,57),MT,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,22),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,31),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,57),MT,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,22),G2(:,:,:,31))
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,37),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,54),MT,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,21),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,40),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,54),MT,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,21),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,45),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,53),MT,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,2),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,46),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,53),MT,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,2),G2(:,:,:,39))
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),MT,G3tensor(:,22))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3),gH)
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,53),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,2),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MT,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,58),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,1),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,48),MT,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,8),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,25))
  call loop_AV_Q(G2(:,:,:,44),wf(:,50),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,44),wf(:,52),G2(:,:,:,47))
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,44),wf(:,27),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,44),wf(:,53),G2(:,:,:,49))
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,63),MT,G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,44),wf(:,55),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,44),wf(:,56),G2(:,:,:,51))
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,44),wf(:,58),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G2(:,:,:,44),wf(:,59),G2(:,:,:,53))
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,44),wf(:,61),G2(:,:,:,54))
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,26),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,58),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,17),wf(:,11),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,58),MT,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,17),wf(:,14),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,58),MT,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,1),G2(:,:,:,60))
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,17),wf(:,23),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,57),MT,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,22),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,17),wf(:,25),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,54),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,21),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,17),wf(:,21),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,25),MT,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,57),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,22),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,17),wf(:,30),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,57),MT,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,22),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,17),wf(:,31),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,57),MT,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,22),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,17),wf(:,37),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,54),MT,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,21),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,17),wf(:,40),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,54),MT,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,21),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,17),wf(:,45),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,53),MT,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,2),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,17),wf(:,46),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,53),MT,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,2),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),MT,G3tensor(:,44))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4),gH)
  call loop_Q_A(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,3),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,53),MB,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,2),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MB,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,33),wf(:,5),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,58),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,1),G2(:,:,:,82))
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),MB,G3tensor(:,46))
  call loop_QV_A(G1(:,:,:,33),wf(:,-5),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,48),MB,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,8),G2(:,:,:,84))
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),MB,G3tensor(:,47))
  call loop_QV_A(G2(:,:,:,83),wf(:,50),G2(:,:,:,85))
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,63),MB,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,83),wf(:,52),G2(:,:,:,86))
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),MB,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,83),wf(:,27),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),MB,G3tensor(:,50))
  call loop_QV_A(G2(:,:,:,83),wf(:,53),G2(:,:,:,88))
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,51))
  call loop_QV_A(G2(:,:,:,83),wf(:,55),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,63),MB,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,83),wf(:,56),G2(:,:,:,90))
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,53))
  call loop_QV_A(G2(:,:,:,83),wf(:,58),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,83),wf(:,59),G2(:,:,:,92))
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MB,G3tensor(:,55))
  call loop_QV_A(G2(:,:,:,83),wf(:,61),G2(:,:,:,93))
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,63),MB,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,33),wf(:,2),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,26),MB,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,-5),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,58),MB,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,33),wf(:,11),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,58),MB,G2(:,:,:,96))
  call loop_QV_A(G2(:,:,:,96),wf(:,1),G2(:,:,:,97))
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,63),MB,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,33),wf(:,14),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,58),MB,G2(:,:,:,98))
  call loop_QV_A(G2(:,:,:,98),wf(:,1),G2(:,:,:,99))
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,63),MB,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,33),wf(:,23),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,57),MB,G2(:,:,:,100))
  call loop_QV_A(G2(:,:,:,100),wf(:,22),G2(:,:,:,101))
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,63),MB,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,33),wf(:,25),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,54),MB,G2(:,:,:,102))
  call loop_QV_A(G2(:,:,:,102),wf(:,21),G2(:,:,:,103))
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,33),wf(:,21),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,25),MB,G2(:,:,:,104))
  call loop_QV_A(G2(:,:,:,104),wf(:,-5),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,57),MB,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,22),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G1(:,:,:,33),wf(:,30),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,57),MB,G2(:,:,:,106))
  call loop_QV_A(G2(:,:,:,106),wf(:,22),G2(:,:,:,107))
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,63),MB,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,33),wf(:,31),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,57),MB,G2(:,:,:,108))
  call loop_QV_A(G2(:,:,:,108),wf(:,22),G2(:,:,:,109))
  call check_last_Q_A(l_switch,G2(:,:,:,109),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,33),wf(:,37),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,54),MB,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,21),G2(:,:,:,111))
  call check_last_Q_A(l_switch,G2(:,:,:,111),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,33),wf(:,40),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,54),MB,G2(:,:,:,112))
  call loop_QV_A(G2(:,:,:,112),wf(:,21),G2(:,:,:,113))
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,63),MB,G3tensor(:,64))
  call loop_QV_A(G1(:,:,:,33),wf(:,45),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,53),MB,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,2),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,63),MB,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,33),wf(:,46),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,53),MB,G2(:,:,:,116))
  call loop_QV_A(G2(:,:,:,116),wf(:,2),G2(:,:,:,117))
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,63),MB,G3tensor(:,66))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,53),MB,G2(:,:,:,118))
  call loop_AV_Q(G2(:,:,:,118),wf(:,2),G2(:,:,:,119))
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,63),MB,G3tensor(:,67))
  call loop_AV_Q(G1(:,:,:,49),wf(:,5),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,58),MB,G2(:,:,:,120))
  call loop_AV_Q(G2(:,:,:,120),wf(:,1),G2(:,:,:,121))
  call check_last_A_Q(l_switch,G2(:,:,:,121),Q(:,63),MB,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-5),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,48),MB,G2(:,:,:,122))
  call loop_AV_Q(G2(:,:,:,122),wf(:,8),G2(:,:,:,123))
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,63),MB,G3tensor(:,69))
  call loop_AV_Q(G2(:,:,:,122),wf(:,50),G2(:,:,:,124))
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,63),MB,G3tensor(:,70))
  call loop_AV_Q(G2(:,:,:,122),wf(:,52),G2(:,:,:,125))
  call check_last_A_Q(l_switch,G2(:,:,:,125),Q(:,63),MB,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,122),wf(:,27),G2(:,:,:,126))
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MB,G3tensor(:,72))
  call loop_AV_Q(G2(:,:,:,122),wf(:,53),G2(:,:,:,127))
  call check_last_A_Q(l_switch,G2(:,:,:,127),Q(:,63),MB,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,122),wf(:,55),G2(:,:,:,128))
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,63),MB,G3tensor(:,74))
  call loop_AV_Q(G2(:,:,:,122),wf(:,56),G2(:,:,:,129))
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),MB,G3tensor(:,75))
  call loop_AV_Q(G2(:,:,:,122),wf(:,58),G2(:,:,:,130))
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MB,G3tensor(:,76))
  call loop_AV_Q(G2(:,:,:,122),wf(:,59),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,63),MB,G3tensor(:,77))
  call loop_AV_Q(G2(:,:,:,122),wf(:,61),G2(:,:,:,132))
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),MB,G3tensor(:,78))
  call loop_AV_Q(G1(:,:,:,49),wf(:,2),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,26),MB,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,58),MB,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MB,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,49),wf(:,11),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,58),MB,G2(:,:,:,135))
  call loop_AV_Q(G2(:,:,:,135),wf(:,1),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),MB,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,49),wf(:,14),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,58),MB,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,1),G2(:,:,:,138))
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MB,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,49),wf(:,23),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,57),MB,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,22),G2(:,:,:,140))
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),MB,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,49),wf(:,25),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,54),MB,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,21),G2(:,:,:,142))
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,63),MB,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,49),wf(:,21),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,25),MB,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-5),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,57),MB,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,22),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MB,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,49),wf(:,30),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,57),MB,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,22),G2(:,:,:,146))
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,63),MB,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,49),wf(:,31),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,57),MB,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,22),G2(:,:,:,148))
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),MB,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,49),wf(:,37),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,54),MB,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,21),G2(:,:,:,150))
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,63),MB,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,49),wf(:,40),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,54),MB,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,21),G2(:,:,:,152))
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,63),MB,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,49),wf(:,45),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,53),MB,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,2),G2(:,:,:,154))
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,49),wf(:,46),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,53),MB,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,2),G2(:,:,:,156))
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),MB,G3tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,10),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-5),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,42),MT,G2(:,:,:,157))
  call loop_QS_A(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158),gH)
  call loop_Q_A(G2(:,:,:,158),Q(:,58),MT,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_QS_A(G1(:,:,:,65),wf(:,-4),G1(:,:,:,67),gH)
  call loop_Q_A(G1(:,:,:,67),Q(:,26),MT,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,58),MT,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,10),MT,G1(:,:,:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-5),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,42),MT,G2(:,:,:,161))
  call loop_AS_Q(G2(:,:,:,161),wf(:,-4),G2(:,:,:,162),gH)
  call loop_A_Q(G2(:,:,:,162),Q(:,58),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,11))
  call loop_AS_Q(G1(:,:,:,68),wf(:,-4),G1(:,:,:,70),gH)
  call loop_A_Q(G1(:,:,:,70),Q(:,26),MT,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-5),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,58),MT,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,10),MB,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-5),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,42),MB,G2(:,:,:,165))
  call loop_QS_A(G2(:,:,:,165),wf(:,-4),G2(:,:,:,166),gH)
  call loop_Q_A(G2(:,:,:,166),Q(:,58),MB,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,13))
  call loop_QS_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,73),gH)
  call loop_Q_A(G1(:,:,:,73),Q(:,26),MB,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,58),MB,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,1),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MB,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-5),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,42),MB,G2(:,:,:,169))
  call loop_AS_Q(G2(:,:,:,169),wf(:,-4),G2(:,:,:,170),gH)
  call loop_A_Q(G2(:,:,:,170),Q(:,58),MB,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,15))
  call loop_AS_Q(G1(:,:,:,74),wf(:,-4),G1(:,:,:,76),gH)
  call loop_A_Q(G1(:,:,:,76),Q(:,26),MB,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,58),MB,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,1),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,9),MT,G1(:,:,:,77))
  call loop_AS_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,78),gH)
  call loop_A_Q(G1(:,:,:,78),Q(:,25),MT,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,57),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,22),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,41),MT,G2(:,:,:,175))
  call loop_AS_Q(G2(:,:,:,175),wf(:,-4),G2(:,:,:,176),gH)
  call loop_A_Q(G2(:,:,:,176),Q(:,57),MT,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,22),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,9),MT,G1(:,:,:,80))
  call loop_QS_A(G1(:,:,:,80),wf(:,-4),G1(:,:,:,81),gH)
  call loop_Q_A(G1(:,:,:,81),Q(:,25),MT,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,-5),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,57),MT,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,22),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,80),wf(:,-5),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,41),MT,G2(:,:,:,179))
  call loop_QS_A(G2(:,:,:,179),wf(:,-4),G2(:,:,:,180),gH)
  call loop_Q_A(G2(:,:,:,180),Q(:,57),MT,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,22),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,9),MB,G1(:,:,:,83))
  call loop_AS_Q(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84),gH)
  call loop_A_Q(G1(:,:,:,84),Q(:,25),MB,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-5),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,57),MB,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,22),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-5),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,41),MB,G2(:,:,:,183))
  call loop_AS_Q(G2(:,:,:,183),wf(:,-4),G2(:,:,:,184),gH)
  call loop_A_Q(G2(:,:,:,184),Q(:,57),MB,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,22),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,9),MB,G1(:,:,:,86))
  call loop_QS_A(G1(:,:,:,86),wf(:,-4),G1(:,:,:,87),gH)
  call loop_Q_A(G1(:,:,:,87),Q(:,25),MB,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-5),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,57),MB,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,22),G3(:,:,:,46))
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MB,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,86),wf(:,-5),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,41),MB,G2(:,:,:,187))
  call loop_QS_A(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188),gH)
  call loop_Q_A(G2(:,:,:,188),Q(:,57),MB,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,22),G3(:,:,:,48))
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,24))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(7))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,24),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,24),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(7))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(7))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,9),T4sum(1:70,1))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,9),T4sum(1:70,1))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,11),T4sum(1:70,1))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,11),T4sum(1:70,1))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,13),T4sum(1:70,2))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,13),T4sum(1:70,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,13),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,15),T4sum(1:70,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,15),T4sum(1:70,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,15),T4sum(1:70,2))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,16),T4sum(1:70,4))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,16),T4sum(1:70,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,16),T4sum(1:70,4))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,14),T4sum(1:70,4))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,14),T4sum(1:70,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,14),T4sum(1:70,4))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,5),T4sum(1:70,6))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,5),T4sum(1:70,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,5),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,7),T4sum(1:70,6))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,7),T4sum(1:70,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,7),T4sum(1:70,6))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,35),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,35),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,79),T3sum(1:35,4))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,14),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,14),T3sum(1:35,3))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,36),T3sum(1:35,3))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,36),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,80),T3sum(1:35,4))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,6))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(7))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,15),T3sum(1:35,7))
  M(4) = M(4) + ((CI*f(7))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,15),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(7))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,37),T3sum(1:35,7))
  M(4) = M(4) + ((CI*f(7))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,37),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,8))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,59),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + ((CI*f(7))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(7))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(1) = M(1) + ((CI*f(7))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(7))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(1) = M(1) + ((CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,10))
  M(4) = M(4) + (-(CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,10))
  M(1) = M(1) + ((CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,82),T3sum(1:35,10))
  M(4) = M(4) + (-(CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,82),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(7))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(7))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(7))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(4) = M(4) + ((CI*f(7))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,6))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,6))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,17),T4sum(1:70,7))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,17),T4sum(1:70,7))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,17),T4sum(1:70,7))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,19),T4sum(1:70,7))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,19),T4sum(1:70,7))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,19),T4sum(1:70,7))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,21),T4sum(1:70,8))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,21),T4sum(1:70,8))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,21),T4sum(1:70,8))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,23),T4sum(1:70,8))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,23),T4sum(1:70,8))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,23),T4sum(1:70,8))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,20),T4sum(1:70,9))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,20),T4sum(1:70,9))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,20),T4sum(1:70,9))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,18),T4sum(1:70,9))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,18),T4sum(1:70,9))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,18),T4sum(1:70,9))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,24),T4sum(1:70,10))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,24),T4sum(1:70,10))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,24),T4sum(1:70,10))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,22),T4sum(1:70,10))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,22),T4sum(1:70,10))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,22),T4sum(1:70,10))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,4),T4sum(1:70,11))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,4),T4sum(1:70,11))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,4),T4sum(1:70,11))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,2),T4sum(1:70,11))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,2),T4sum(1:70,11))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,2),T4sum(1:70,11))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,8),T4sum(1:70,12))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,8),T4sum(1:70,12))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,8),T4sum(1:70,12))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,6),T4sum(1:70,12))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,17),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,17),T3sum(1:35,7))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,39),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,39),T3sum(1:35,7))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,61),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,61),T3sum(1:35,8))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,83),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,83),T3sum(1:35,8))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,40),T3sum(1:35,7))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,40),T3sum(1:35,7))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,18),T3sum(1:35,7))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,18),T3sum(1:35,7))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,84),T3sum(1:35,8))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,84),T3sum(1:35,8))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,62),T3sum(1:35,8))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,62),T3sum(1:35,8))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,6))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,10))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,10))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,85),T3sum(1:35,10))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,85),T3sum(1:35,10))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,10))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,10))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,86),T3sum(1:35,10))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,86),T3sum(1:35,10))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,6))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(4) = M(4) + (-(f(8)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,6))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,1))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,2))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,1))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (f(8)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,6))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,6))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,5))
  M(1) = M(1) + (-(f(8)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(3) = M(3) + (f(8)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,6))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,6))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_dddxdxhg_2_/**/REALKIND
