
module ol_vamp_1_pphjjj2_dddxdxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_dddxdxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_dddxdxhg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_dddxdxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_dddxdxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,7) :: G0
  complex(REALKIND), dimension(4,5,4,44) :: G1
  complex(REALKIND), dimension(4,15,4,94) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,44,32))
    allocate(G4tensorhel(70,12,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2),gH)
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,53),MT,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,2),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,58),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,8),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,5),wf(:,50),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,5),wf(:,52),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,27),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,5),wf(:,53),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,5),wf(:,55),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,5),wf(:,56),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G2(:,:,:,5),wf(:,58),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,5),wf(:,59),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,5),wf(:,61),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,26),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,-5),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,58),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,58),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,1),G2(:,:,:,19))
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,1),wf(:,14),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,58),MT,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,1),G2(:,:,:,21))
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,1),wf(:,23),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,57),MT,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,22),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,1),wf(:,25),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,54),MT,G2(:,:,:,24))
  call loop_QV_A(G2(:,:,:,24),wf(:,21),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,21),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,25),MT,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-5),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,57),MT,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,22),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,30),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,57),MT,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,22),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,31),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,57),MT,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,22),G2(:,:,:,31))
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,63),MT,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,1),wf(:,37),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,54),MT,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,21),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,1),wf(:,40),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,54),MT,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,21),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,1),wf(:,45),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,53),MT,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,2),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,1),wf(:,46),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,53),MT,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,2),G2(:,:,:,39))
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),MT,G3tensor(:,22))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3),gH)
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,53),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,2),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MT,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,58),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,1),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,48),MT,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,8),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,25))
  call loop_AV_Q(G2(:,:,:,44),wf(:,50),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,44),wf(:,52),G2(:,:,:,47))
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,44),wf(:,27),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,44),wf(:,53),G2(:,:,:,49))
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,63),MT,G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,44),wf(:,55),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,44),wf(:,56),G2(:,:,:,51))
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,44),wf(:,58),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G2(:,:,:,44),wf(:,59),G2(:,:,:,53))
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,44),wf(:,61),G2(:,:,:,54))
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,26),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,58),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,17),wf(:,11),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,58),MT,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,17),wf(:,14),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,58),MT,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,1),G2(:,:,:,60))
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,17),wf(:,23),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,57),MT,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,22),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,17),wf(:,25),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,54),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,21),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,17),wf(:,21),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,25),MT,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,57),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,22),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,17),wf(:,30),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,57),MT,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,22),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,17),wf(:,31),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,57),MT,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,22),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,17),wf(:,37),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,54),MT,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,21),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,17),wf(:,40),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,54),MT,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,21),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,17),wf(:,45),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,53),MT,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,2),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,17),wf(:,46),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,53),MT,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,2),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,10),MT,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,-5),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,42),MT,G2(:,:,:,79))
  call loop_QS_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80),gH)
  call loop_Q_A(G2(:,:,:,80),Q(:,58),MT,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_QS_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,35),gH)
  call loop_Q_A(G1(:,:,:,35),Q(:,26),MT,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,58),MT,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,10),MT,G1(:,:,:,36))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-5),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,42),MT,G2(:,:,:,83))
  call loop_AS_Q(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84),gH)
  call loop_A_Q(G2(:,:,:,84),Q(:,58),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_AS_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,38),gH)
  call loop_A_Q(G1(:,:,:,38),Q(:,26),MT,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-5),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,58),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,9),MT,G1(:,:,:,39))
  call loop_AS_Q(G1(:,:,:,39),wf(:,-4),G1(:,:,:,40),gH)
  call loop_A_Q(G1(:,:,:,40),Q(:,25),MT,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,57),MT,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,22),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,41),MT,G2(:,:,:,89))
  call loop_AS_Q(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90),gH)
  call loop_A_Q(G2(:,:,:,90),Q(:,57),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,22),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,9),MT,G1(:,:,:,42))
  call loop_QS_A(G1(:,:,:,42),wf(:,-4),G1(:,:,:,43),gH)
  call loop_Q_A(G1(:,:,:,43),Q(:,25),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,57),MT,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,22),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,42),wf(:,-5),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,41),MT,G2(:,:,:,93))
  call loop_QS_A(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94),gH)
  call loop_Q_A(G2(:,:,:,94),Q(:,57),MT,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,22),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(3) = M(3) + ((CI*f(3))/4._/**/REALKIND * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,2),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(8)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(3))/4._/**/REALKIND * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,7),T4sum(1:70,1))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,7),T4sum(1:70,1))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,1),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,3),T4sum(1:70,3))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,3),T4sum(1:70,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(10)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,3),T4sum(1:70,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(14)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(17)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/12._/**/REALKIND) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(28)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,16),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,16),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(3))/4._/**/REALKIND * den(31)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,3))
  M(4) = M(4) + ((CI*f(3))/4._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,9),T4sum(1:70,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,9),T4sum(1:70,4))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,11),T4sum(1:70,4))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,12),T4sum(1:70,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,12),T4sum(1:70,5))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,12),T4sum(1:70,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,10),T4sum(1:70,5))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,10),T4sum(1:70,5))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,10),T4sum(1:70,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,4),T4sum(1:70,6))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,4),T4sum(1:70,6))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,4),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(32)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(36)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(38)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/12._/**/REALKIND * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,5))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,5))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(45)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,5))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(48)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,5))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/12._/**/REALKIND * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(4) = M(4) + (-(f(4)/4._/**/REALKIND) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,1))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(54)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,1))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(56)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (f(4)/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/12._/**/REALKIND) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(3) = M(3) + (f(4)/4._/**/REALKIND * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,3))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_dddxdxhg_1_/**/REALKIND
