
module ol_vamp_1_pphjjj2_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_bbxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_bbxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_bbxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_bbxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,22) :: G0
  complex(REALKIND), dimension(4,5,4,289) :: G1
  complex(REALKIND), dimension(4,15,4,638) :: G2
  complex(REALKIND), dimension(4,35,4,268) :: G3
  complex(REALKIND), dimension(4,70,4,60) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,242,32))
    allocate(G4tensorhel(70,110,32))
    allocate(G5tensorhel(126,30,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,97),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,59),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,98),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,59),MT,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,99),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,59),MT,G2(:,:,:,5))
  call loop_AS_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,398),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,59),MT,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,12),MT,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,11),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,86),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,28),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,86),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,44),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,60),MT,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,86),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,402),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,59),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,114),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,27),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,59),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,40),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,114),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,59),MT,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,3))
  call loop_AS_Q(G2(:,:,:,17),wf(:,-2),G2(:,:,:,19),gH)
  call loop_A_Q(G2(:,:,:,19),Q(:,44),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,86),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,56),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,4),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G3(:,:,:,13),wf(:,9),G3(:,:,:,15))
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,17),wf(:,216),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,59),MT,G3(:,:,:,16))
  call loop_AS_Q(G3(:,:,:,16),wf(:,-2),G3(:,:,:,17),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,17),wf(:,217),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,59),MT,G3(:,:,:,18))
  call loop_AS_Q(G3(:,:,:,18),wf(:,-2),G3(:,:,:,19),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,63),MT,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,404),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,59),MT,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,-2),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,111),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,43),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,59),MT,G3(:,:,:,20))
  call loop_AS_Q(G3(:,:,:,20),wf(:,-2),G3(:,:,:,21),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,24),MT,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,111),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,59),MT,G3(:,:,:,22))
  call loop_AS_Q(G3(:,:,:,22),wf(:,-2),G3(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,63),MT,G4tensor(:,9))
  call loop_AS_Q(G2(:,:,:,27),wf(:,-2),G2(:,:,:,29),gH)
  call loop_A_Q(G2(:,:,:,29),Q(:,28),MT,G3(:,:,:,24))
  call loop_AV_Q(G3(:,:,:,24),wf(:,-5),G3(:,:,:,25))
  call loop_A_Q(G3(:,:,:,25),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,86),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-5),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,56),MT,G3(:,:,:,26))
  call loop_AV_Q(G3(:,:,:,26),wf(:,4),G3(:,:,:,27))
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G3(:,:,:,26),wf(:,9),G3(:,:,:,28))
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,27),wf(:,218),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,59),MT,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,27),wf(:,219),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,59),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,-2),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,11),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,56),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,4),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,33),wf(:,9),G2(:,:,:,35))
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,220),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,59),MT,G2(:,:,:,36))
  call loop_AS_Q(G2(:,:,:,36),wf(:,-2),G2(:,:,:,37),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,476),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,59),MT,G2(:,:,:,38))
  call loop_AS_Q(G2(:,:,:,38),wf(:,-2),G2(:,:,:,39),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,216),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,27),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-5),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,59),MT,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,-2),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,487),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,59),MT,G2(:,:,:,42))
  call loop_AS_Q(G2(:,:,:,42),wf(:,-2),G2(:,:,:,43),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,223),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,59),MT,G2(:,:,:,44))
  call loop_AS_Q(G2(:,:,:,44),wf(:,-2),G2(:,:,:,45),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,493),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,59),MT,G2(:,:,:,46))
  call loop_AS_Q(G2(:,:,:,46),wf(:,-2),G2(:,:,:,47),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,217),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,27),MT,G2(:,:,:,48))
  call loop_AV_Q(G2(:,:,:,48),wf(:,-5),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,59),MT,G3(:,:,:,35))
  call loop_AS_Q(G3(:,:,:,35),wf(:,-2),G3(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,496),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,59),MT,G2(:,:,:,50))
  call loop_AS_Q(G2(:,:,:,50),wf(:,-2),G2(:,:,:,51),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,524),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,59),MT,G2(:,:,:,52))
  call loop_AS_Q(G2(:,:,:,52),wf(:,-2),G2(:,:,:,53),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,218),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,43),MT,G2(:,:,:,54))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-4),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,59),MT,G3(:,:,:,37))
  call loop_AS_Q(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,535),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),MT,G2(:,:,:,56))
  call loop_AS_Q(G2(:,:,:,56),wf(:,-2),G2(:,:,:,57),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,541),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,59),MT,G2(:,:,:,58))
  call loop_AS_Q(G2(:,:,:,58),wf(:,-2),G2(:,:,:,59),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,219),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,43),MT,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,59),MT,G3(:,:,:,39))
  call loop_AS_Q(G3(:,:,:,39),wf(:,-2),G3(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,544),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),MT,G2(:,:,:,62))
  call loop_AS_Q(G2(:,:,:,62),wf(:,-2),G2(:,:,:,63),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,571),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,59),MT,G2(:,:,:,64))
  call loop_AS_Q(G2(:,:,:,64),wf(:,-2),G2(:,:,:,65),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,63),MT,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,1),wf(:,572),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,59),MT,G2(:,:,:,66))
  call loop_AS_Q(G2(:,:,:,66),wf(:,-2),G2(:,:,:,67),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,8),MT,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,97),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,59),MT,G2(:,:,:,68))
  call loop_QS_A(G2(:,:,:,68),wf(:,-2),G2(:,:,:,69),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,30),wf(:,98),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,59),MT,G2(:,:,:,70))
  call loop_QS_A(G2(:,:,:,70),wf(:,-2),G2(:,:,:,71),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),MT,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,30),wf(:,99),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,59),MT,G2(:,:,:,72))
  call loop_QS_A(G2(:,:,:,72),wf(:,-2),G2(:,:,:,73),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,30),wf(:,398),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,59),MT,G2(:,:,:,74))
  call loop_QS_A(G2(:,:,:,74),wf(:,-2),G2(:,:,:,75),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),MT,G3tensor(:,24))
  call loop_QS_A(G1(:,:,:,30),wf(:,-2),G1(:,:,:,35),gH)
  call loop_Q_A(G1(:,:,:,35),Q(:,12),MT,G2(:,:,:,76))
  call loop_QV_A(G2(:,:,:,76),wf(:,11),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,60),MT,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,86),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,76),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,28),MT,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-5),G3(:,:,:,44))
  call loop_Q_A(G3(:,:,:,44),Q(:,60),MT,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,86),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,76),wf(:,-5),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,44),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,60),MT,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,86),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,6))
  call loop_QV_A(G1(:,:,:,30),wf(:,402),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,59),MT,G2(:,:,:,80))
  call loop_QS_A(G2(:,:,:,80),wf(:,-2),G2(:,:,:,81),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,30),wf(:,114),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,27),MT,G2(:,:,:,82))
  call loop_QV_A(G2(:,:,:,82),wf(:,-5),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,59),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,30),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,40),MT,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,114),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,59),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,-2),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,20))
  call loop_QS_A(G2(:,:,:,84),wf(:,-2),G2(:,:,:,86),gH)
  call loop_Q_A(G2(:,:,:,86),Q(:,44),MT,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,60),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,86),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,84),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,56),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,4),G3(:,:,:,54))
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G3(:,:,:,53),wf(:,9),G3(:,:,:,55))
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,84),wf(:,216),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,59),MT,G3(:,:,:,56))
  call loop_QS_A(G3(:,:,:,56),wf(:,-2),G3(:,:,:,57),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G2(:,:,:,84),wf(:,217),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,59),MT,G3(:,:,:,58))
  call loop_QS_A(G3(:,:,:,58),wf(:,-2),G3(:,:,:,59),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,59),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,30),wf(:,404),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,59),MT,G2(:,:,:,90))
  call loop_QS_A(G2(:,:,:,90),wf(:,-2),G2(:,:,:,91),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,30),wf(:,111),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,43),MT,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,-4),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,59),MT,G3(:,:,:,60))
  call loop_QS_A(G3(:,:,:,60),wf(:,-2),G3(:,:,:,61),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MT,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,30),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,24),MT,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,111),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,59),MT,G3(:,:,:,62))
  call loop_QS_A(G3(:,:,:,62),wf(:,-2),G3(:,:,:,63),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,63),MT,G4tensor(:,26))
  call loop_QS_A(G2(:,:,:,94),wf(:,-2),G2(:,:,:,96),gH)
  call loop_Q_A(G2(:,:,:,96),Q(:,28),MT,G3(:,:,:,64))
  call loop_QV_A(G3(:,:,:,64),wf(:,-5),G3(:,:,:,65))
  call loop_Q_A(G3(:,:,:,65),Q(:,60),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,86),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,94),wf(:,-5),G2(:,:,:,97))
  call loop_Q_A(G2(:,:,:,97),Q(:,56),MT,G3(:,:,:,66))
  call loop_QV_A(G3(:,:,:,66),wf(:,4),G3(:,:,:,67))
  call check_last_Q_A(l_switch,G3(:,:,:,67),Q(:,63),MT,G4tensor(:,27))
  call loop_QV_A(G3(:,:,:,66),wf(:,9),G3(:,:,:,68))
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,94),wf(:,218),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,59),MT,G3(:,:,:,69))
  call loop_QS_A(G3(:,:,:,69),wf(:,-2),G3(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,63),MT,G4tensor(:,29))
  call loop_QV_A(G2(:,:,:,94),wf(:,219),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,59),MT,G3(:,:,:,71))
  call loop_QS_A(G3(:,:,:,71),wf(:,-2),G3(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,11),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,56),MT,G2(:,:,:,100))
  call loop_QV_A(G2(:,:,:,100),wf(:,4),G2(:,:,:,101))
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G2(:,:,:,100),wf(:,9),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,30),wf(:,220),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,59),MT,G2(:,:,:,103))
  call loop_QS_A(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G1(:,:,:,30),wf(:,476),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,59),MT,G2(:,:,:,105))
  call loop_QS_A(G2(:,:,:,105),wf(:,-2),G2(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,216),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,27),MT,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-5),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,59),MT,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,-2),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,30),wf(:,487),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,59),MT,G2(:,:,:,109))
  call loop_QS_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,30),wf(:,223),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,59),MT,G2(:,:,:,111))
  call loop_QS_A(G2(:,:,:,111),wf(:,-2),G2(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,30),wf(:,493),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,59),MT,G2(:,:,:,113))
  call loop_QS_A(G2(:,:,:,113),wf(:,-2),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,30),wf(:,217),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,27),MT,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,59),MT,G3(:,:,:,75))
  call loop_QS_A(G3(:,:,:,75),wf(:,-2),G3(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,32))
  call loop_QV_A(G1(:,:,:,30),wf(:,496),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,59),MT,G2(:,:,:,117))
  call loop_QS_A(G2(:,:,:,117),wf(:,-2),G2(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,30),wf(:,524),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,59),MT,G2(:,:,:,119))
  call loop_QS_A(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,30),wf(:,218),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,43),MT,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,-4),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,59),MT,G3(:,:,:,77))
  call loop_QS_A(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,30),wf(:,535),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,59),MT,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,30),wf(:,541),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),MT,G2(:,:,:,125))
  call loop_QS_A(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,30),wf(:,219),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,43),MT,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,-4),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,59),MT,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,-2),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G1(:,:,:,30),wf(:,544),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,59),MT,G2(:,:,:,129))
  call loop_QS_A(G2(:,:,:,129),wf(:,-2),G2(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,63),MT,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,30),wf(:,571),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,59),MT,G2(:,:,:,131))
  call loop_QS_A(G2(:,:,:,131),wf(:,-2),G2(:,:,:,132),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,63),MT,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,30),wf(:,572),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,59),MT,G2(:,:,:,133))
  call loop_QS_A(G2(:,:,:,133),wf(:,-2),G2(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,8),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,97),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),MB,G2(:,:,:,135))
  call loop_AS_Q(G2(:,:,:,135),wf(:,-2),G2(:,:,:,136),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,59),wf(:,98),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,59),MB,G2(:,:,:,137))
  call loop_AS_Q(G2(:,:,:,137),wf(:,-2),G2(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MB,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,59),wf(:,99),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,59),MB,G2(:,:,:,139))
  call loop_AS_Q(G2(:,:,:,139),wf(:,-2),G2(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,59),wf(:,398),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,59),MB,G2(:,:,:,141))
  call loop_AS_Q(G2(:,:,:,141),wf(:,-2),G2(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,63),MB,G3tensor(:,44))
  call loop_AS_Q(G1(:,:,:,59),wf(:,-2),G1(:,:,:,64),gH)
  call loop_A_Q(G1(:,:,:,64),Q(:,12),MB,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,11),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,60),MB,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,86),G3(:,:,:,82))
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,35))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-4),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,28),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-5),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,60),MB,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,86),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-5),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,44),MB,G3(:,:,:,85))
  call loop_AV_Q(G3(:,:,:,85),wf(:,-4),G3(:,:,:,86))
  call loop_A_Q(G3(:,:,:,86),Q(:,60),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,86),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,59),wf(:,402),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,59),MB,G2(:,:,:,147))
  call loop_AS_Q(G2(:,:,:,147),wf(:,-2),G2(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),MB,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,59),wf(:,114),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,27),MB,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-5),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,59),MB,G3(:,:,:,87))
  call loop_AS_Q(G3(:,:,:,87),wf(:,-2),G3(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,36))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-5),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,40),MB,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,114),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,59),MB,G3(:,:,:,89))
  call loop_AS_Q(G3(:,:,:,89),wf(:,-2),G3(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,63),MB,G4tensor(:,37))
  call loop_AS_Q(G2(:,:,:,151),wf(:,-2),G2(:,:,:,153),gH)
  call loop_A_Q(G2(:,:,:,153),Q(:,44),MB,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-4),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,60),MB,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,86),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-4),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,56),MB,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,4),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),MB,G4tensor(:,38))
  call loop_AV_Q(G3(:,:,:,93),wf(:,9),G3(:,:,:,95))
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,63),MB,G4tensor(:,39))
  call loop_AV_Q(G2(:,:,:,151),wf(:,216),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,59),MB,G3(:,:,:,96))
  call loop_AS_Q(G3(:,:,:,96),wf(:,-2),G3(:,:,:,97),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,97),Q(:,63),MB,G4tensor(:,40))
  call loop_AV_Q(G2(:,:,:,151),wf(:,217),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,59),MB,G3(:,:,:,98))
  call loop_AS_Q(G3(:,:,:,98),wf(:,-2),G3(:,:,:,99),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,99),Q(:,63),MB,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,59),wf(:,404),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,59),MB,G2(:,:,:,157))
  call loop_AS_Q(G2(:,:,:,157),wf(:,-2),G2(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MB,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,59),wf(:,111),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,43),MB,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-4),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,59),MB,G3(:,:,:,100))
  call loop_AS_Q(G3(:,:,:,100),wf(:,-2),G3(:,:,:,101),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,101),Q(:,63),MB,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-4),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,24),MB,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,111),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,59),MB,G3(:,:,:,102))
  call loop_AS_Q(G3(:,:,:,102),wf(:,-2),G3(:,:,:,103),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,63),MB,G4tensor(:,43))
  call loop_AS_Q(G2(:,:,:,161),wf(:,-2),G2(:,:,:,163),gH)
  call loop_A_Q(G2(:,:,:,163),Q(:,28),MB,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,-5),G3(:,:,:,105))
  call loop_A_Q(G3(:,:,:,105),Q(:,60),MB,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,86),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-5),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,56),MB,G3(:,:,:,106))
  call loop_AV_Q(G3(:,:,:,106),wf(:,4),G3(:,:,:,107))
  call check_last_A_Q(l_switch,G3(:,:,:,107),Q(:,63),MB,G4tensor(:,44))
  call loop_AV_Q(G3(:,:,:,106),wf(:,9),G3(:,:,:,108))
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,63),MB,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,161),wf(:,218),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,59),MB,G3(:,:,:,109))
  call loop_AS_Q(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,63),MB,G4tensor(:,46))
  call loop_AV_Q(G2(:,:,:,161),wf(:,219),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,59),MB,G3(:,:,:,111))
  call loop_AS_Q(G3(:,:,:,111),wf(:,-2),G3(:,:,:,112),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,59),wf(:,11),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,56),MB,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,4),G2(:,:,:,168))
  call check_last_A_Q(l_switch,G2(:,:,:,168),Q(:,63),MB,G3tensor(:,47))
  call loop_AV_Q(G2(:,:,:,167),wf(:,9),G2(:,:,:,169))
  call check_last_A_Q(l_switch,G2(:,:,:,169),Q(:,63),MB,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,59),wf(:,220),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,59),MB,G2(:,:,:,170))
  call loop_AS_Q(G2(:,:,:,170),wf(:,-2),G2(:,:,:,171),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,171),Q(:,63),MB,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,59),wf(:,476),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,59),MB,G2(:,:,:,172))
  call loop_AS_Q(G2(:,:,:,172),wf(:,-2),G2(:,:,:,173),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,173),Q(:,63),MB,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,59),wf(:,216),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,27),MB,G2(:,:,:,174))
  call loop_AV_Q(G2(:,:,:,174),wf(:,-5),G2(:,:,:,175))
  call loop_A_Q(G2(:,:,:,175),Q(:,59),MB,G3(:,:,:,113))
  call loop_AS_Q(G3(:,:,:,113),wf(:,-2),G3(:,:,:,114),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,63),MB,G4tensor(:,48))
  call loop_AV_Q(G1(:,:,:,59),wf(:,487),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,59),MB,G2(:,:,:,176))
  call loop_AS_Q(G2(:,:,:,176),wf(:,-2),G2(:,:,:,177),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,63),MB,G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,59),wf(:,223),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),MB,G2(:,:,:,178))
  call loop_AS_Q(G2(:,:,:,178),wf(:,-2),G2(:,:,:,179),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,179),Q(:,63),MB,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,59),wf(:,493),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,59),MB,G2(:,:,:,180))
  call loop_AS_Q(G2(:,:,:,180),wf(:,-2),G2(:,:,:,181),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,63),MB,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,59),wf(:,217),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,27),MB,G2(:,:,:,182))
  call loop_AV_Q(G2(:,:,:,182),wf(:,-5),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,59),MB,G3(:,:,:,115))
  call loop_AS_Q(G3(:,:,:,115),wf(:,-2),G3(:,:,:,116),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,63),MB,G4tensor(:,49))
  call loop_AV_Q(G1(:,:,:,59),wf(:,496),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,59),MB,G2(:,:,:,184))
  call loop_AS_Q(G2(:,:,:,184),wf(:,-2),G2(:,:,:,185),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,63),MB,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,59),wf(:,524),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,59),MB,G2(:,:,:,186))
  call loop_AS_Q(G2(:,:,:,186),wf(:,-2),G2(:,:,:,187),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,63),MB,G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,59),wf(:,218),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,43),MB,G2(:,:,:,188))
  call loop_AV_Q(G2(:,:,:,188),wf(:,-4),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,59),MB,G3(:,:,:,117))
  call loop_AS_Q(G3(:,:,:,117),wf(:,-2),G3(:,:,:,118),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,63),MB,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,59),wf(:,535),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,59),MB,G2(:,:,:,190))
  call loop_AS_Q(G2(:,:,:,190),wf(:,-2),G2(:,:,:,191),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,191),Q(:,63),MB,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,59),wf(:,541),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,59),MB,G2(:,:,:,192))
  call loop_AS_Q(G2(:,:,:,192),wf(:,-2),G2(:,:,:,193),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,193),Q(:,63),MB,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,59),wf(:,219),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,43),MB,G2(:,:,:,194))
  call loop_AV_Q(G2(:,:,:,194),wf(:,-4),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,59),MB,G3(:,:,:,119))
  call loop_AS_Q(G3(:,:,:,119),wf(:,-2),G3(:,:,:,120),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,63),MB,G4tensor(:,51))
  call loop_AV_Q(G1(:,:,:,59),wf(:,544),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,59),MB,G2(:,:,:,196))
  call loop_AS_Q(G2(:,:,:,196),wf(:,-2),G2(:,:,:,197),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,197),Q(:,63),MB,G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,59),wf(:,571),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,59),MB,G2(:,:,:,198))
  call loop_AS_Q(G2(:,:,:,198),wf(:,-2),G2(:,:,:,199),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,199),Q(:,63),MB,G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,572),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,59),MB,G2(:,:,:,200))
  call loop_AS_Q(G2(:,:,:,200),wf(:,-2),G2(:,:,:,201),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,201),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,8),MB,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,97),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,59),MB,G2(:,:,:,202))
  call loop_QS_A(G2(:,:,:,202),wf(:,-2),G2(:,:,:,203),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,203),Q(:,63),MB,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,88),wf(:,98),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,59),MB,G2(:,:,:,204))
  call loop_QS_A(G2(:,:,:,204),wf(:,-2),G2(:,:,:,205),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,205),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,88),wf(:,99),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,59),MB,G2(:,:,:,206))
  call loop_QS_A(G2(:,:,:,206),wf(:,-2),G2(:,:,:,207),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,207),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,88),wf(:,398),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,59),MB,G2(:,:,:,208))
  call loop_QS_A(G2(:,:,:,208),wf(:,-2),G2(:,:,:,209),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,63),MB,G3tensor(:,64))
  call loop_QS_A(G1(:,:,:,88),wf(:,-2),G1(:,:,:,93),gH)
  call loop_Q_A(G1(:,:,:,93),Q(:,12),MB,G2(:,:,:,210))
  call loop_QV_A(G2(:,:,:,210),wf(:,11),G2(:,:,:,211))
  call loop_Q_A(G2(:,:,:,211),Q(:,60),MB,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,86),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,63),MB,G4tensor(:,52))
  call loop_QV_A(G2(:,:,:,210),wf(:,-4),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,28),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-5),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,60),MB,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,86),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MB,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,210),wf(:,-5),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,44),MB,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-4),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,60),MB,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,86),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,88),wf(:,402),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,59),MB,G2(:,:,:,214))
  call loop_QS_A(G2(:,:,:,214),wf(:,-2),G2(:,:,:,215),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,215),Q(:,63),MB,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,88),wf(:,114),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,27),MB,G2(:,:,:,216))
  call loop_QV_A(G2(:,:,:,216),wf(:,-5),G2(:,:,:,217))
  call loop_Q_A(G2(:,:,:,217),Q(:,59),MB,G3(:,:,:,127))
  call loop_QS_A(G3(:,:,:,127),wf(:,-2),G3(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,63),MB,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,88),wf(:,-5),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,40),MB,G2(:,:,:,218))
  call loop_QV_A(G2(:,:,:,218),wf(:,114),G2(:,:,:,219))
  call loop_Q_A(G2(:,:,:,219),Q(:,59),MB,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,-2),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,63),MB,G4tensor(:,54))
  call loop_QS_A(G2(:,:,:,218),wf(:,-2),G2(:,:,:,220),gH)
  call loop_Q_A(G2(:,:,:,220),Q(:,44),MB,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,60),MB,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,86),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),MB,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,218),wf(:,-4),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,56),MB,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,4),G3(:,:,:,134))
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,63),MB,G4tensor(:,55))
  call loop_QV_A(G3(:,:,:,133),wf(:,9),G3(:,:,:,135))
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,63),MB,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,218),wf(:,216),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,59),MB,G3(:,:,:,136))
  call loop_QS_A(G3(:,:,:,136),wf(:,-2),G3(:,:,:,137),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,63),MB,G4tensor(:,57))
  call loop_QV_A(G2(:,:,:,218),wf(:,217),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,59),MB,G3(:,:,:,138))
  call loop_QS_A(G3(:,:,:,138),wf(:,-2),G3(:,:,:,139),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,63),MB,G4tensor(:,58))
  call loop_QV_A(G1(:,:,:,88),wf(:,404),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,59),MB,G2(:,:,:,224))
  call loop_QS_A(G2(:,:,:,224),wf(:,-2),G2(:,:,:,225),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,225),Q(:,63),MB,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,88),wf(:,111),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,43),MB,G2(:,:,:,226))
  call loop_QV_A(G2(:,:,:,226),wf(:,-4),G2(:,:,:,227))
  call loop_Q_A(G2(:,:,:,227),Q(:,59),MB,G3(:,:,:,140))
  call loop_QS_A(G3(:,:,:,140),wf(:,-2),G3(:,:,:,141),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,63),MB,G4tensor(:,59))
  call loop_QV_A(G1(:,:,:,88),wf(:,-4),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,24),MB,G2(:,:,:,228))
  call loop_QV_A(G2(:,:,:,228),wf(:,111),G2(:,:,:,229))
  call loop_Q_A(G2(:,:,:,229),Q(:,59),MB,G3(:,:,:,142))
  call loop_QS_A(G3(:,:,:,142),wf(:,-2),G3(:,:,:,143),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,63),MB,G4tensor(:,60))
  call loop_QS_A(G2(:,:,:,228),wf(:,-2),G2(:,:,:,230),gH)
  call loop_Q_A(G2(:,:,:,230),Q(:,28),MB,G3(:,:,:,144))
  call loop_QV_A(G3(:,:,:,144),wf(:,-5),G3(:,:,:,145))
  call loop_Q_A(G3(:,:,:,145),Q(:,60),MB,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,86),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,16))
  call loop_QV_A(G2(:,:,:,228),wf(:,-5),G2(:,:,:,231))
  call loop_Q_A(G2(:,:,:,231),Q(:,56),MB,G3(:,:,:,146))
  call loop_QV_A(G3(:,:,:,146),wf(:,4),G3(:,:,:,147))
  call check_last_Q_A(l_switch,G3(:,:,:,147),Q(:,63),MB,G4tensor(:,61))
  call loop_QV_A(G3(:,:,:,146),wf(:,9),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,63),MB,G4tensor(:,62))
  call loop_QV_A(G2(:,:,:,228),wf(:,218),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,59),MB,G3(:,:,:,149))
  call loop_QS_A(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,63),MB,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,228),wf(:,219),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,59),MB,G3(:,:,:,151))
  call loop_QS_A(G3(:,:,:,151),wf(:,-2),G3(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,63),MB,G4tensor(:,64))
  call loop_QV_A(G1(:,:,:,88),wf(:,11),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,56),MB,G2(:,:,:,234))
  call loop_QV_A(G2(:,:,:,234),wf(:,4),G2(:,:,:,235))
  call check_last_Q_A(l_switch,G2(:,:,:,235),Q(:,63),MB,G3tensor(:,67))
  call loop_QV_A(G2(:,:,:,234),wf(:,9),G2(:,:,:,236))
  call check_last_Q_A(l_switch,G2(:,:,:,236),Q(:,63),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,88),wf(:,220),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,59),MB,G2(:,:,:,237))
  call loop_QS_A(G2(:,:,:,237),wf(:,-2),G2(:,:,:,238),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,238),Q(:,63),MB,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,88),wf(:,476),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,59),MB,G2(:,:,:,239))
  call loop_QS_A(G2(:,:,:,239),wf(:,-2),G2(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,63),MB,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,88),wf(:,216),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,27),MB,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-5),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,59),MB,G3(:,:,:,153))
  call loop_QS_A(G3(:,:,:,153),wf(:,-2),G3(:,:,:,154),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,63),MB,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,88),wf(:,487),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,59),MB,G2(:,:,:,243))
  call loop_QS_A(G2(:,:,:,243),wf(:,-2),G2(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MB,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,88),wf(:,223),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,59),MB,G2(:,:,:,245))
  call loop_QS_A(G2(:,:,:,245),wf(:,-2),G2(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,63),MB,G3tensor(:,72))
  call loop_QV_A(G1(:,:,:,88),wf(:,493),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,59),MB,G2(:,:,:,247))
  call loop_QS_A(G2(:,:,:,247),wf(:,-2),G2(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MB,G3tensor(:,73))
  call loop_QV_A(G1(:,:,:,88),wf(:,217),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,27),MB,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,-5),G2(:,:,:,250))
  call loop_Q_A(G2(:,:,:,250),Q(:,59),MB,G3(:,:,:,155))
  call loop_QS_A(G3(:,:,:,155),wf(:,-2),G3(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),MB,G4tensor(:,66))
  call loop_QV_A(G1(:,:,:,88),wf(:,496),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,59),MB,G2(:,:,:,251))
  call loop_QS_A(G2(:,:,:,251),wf(:,-2),G2(:,:,:,252),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,252),Q(:,63),MB,G3tensor(:,74))
  call loop_QV_A(G1(:,:,:,88),wf(:,524),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,59),MB,G2(:,:,:,253))
  call loop_QS_A(G2(:,:,:,253),wf(:,-2),G2(:,:,:,254),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,254),Q(:,63),MB,G3tensor(:,75))
  call loop_QV_A(G1(:,:,:,88),wf(:,218),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,43),MB,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,-4),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,59),MB,G3(:,:,:,157))
  call loop_QS_A(G3(:,:,:,157),wf(:,-2),G3(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,63),MB,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,88),wf(:,535),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,59),MB,G2(:,:,:,257))
  call loop_QS_A(G2(:,:,:,257),wf(:,-2),G2(:,:,:,258),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,258),Q(:,63),MB,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,88),wf(:,541),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,59),MB,G2(:,:,:,259))
  call loop_QS_A(G2(:,:,:,259),wf(:,-2),G2(:,:,:,260),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,63),MB,G3tensor(:,77))
  call loop_QV_A(G1(:,:,:,88),wf(:,219),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,43),MB,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,-4),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,59),MB,G3(:,:,:,159))
  call loop_QS_A(G3(:,:,:,159),wf(:,-2),G3(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,63),MB,G4tensor(:,68))
  call loop_QV_A(G1(:,:,:,88),wf(:,544),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,59),MB,G2(:,:,:,263))
  call loop_QS_A(G2(:,:,:,263),wf(:,-2),G2(:,:,:,264),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,63),MB,G3tensor(:,78))
  call loop_QV_A(G1(:,:,:,88),wf(:,571),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,59),MB,G2(:,:,:,265))
  call loop_QS_A(G2(:,:,:,265),wf(:,-2),G2(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,63),MB,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,88),wf(:,572),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,59),MB,G2(:,:,:,267))
  call loop_QS_A(G2(:,:,:,267),wf(:,-2),G2(:,:,:,268),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,63),MB,G3tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),MT,G1(:,:,:,117))
  call loop_AV_Q(G1(:,:,:,117),wf(:,93),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,59),MT,G2(:,:,:,269))
  call loop_AS_Q(G2(:,:,:,269),wf(:,-2),G2(:,:,:,270),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,270),Q(:,63),MT,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,117),wf(:,94),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,59),MT,G2(:,:,:,271))
  call loop_AS_Q(G2(:,:,:,271),wf(:,-2),G2(:,:,:,272),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,272),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,117),wf(:,95),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,59),MT,G2(:,:,:,273))
  call loop_AS_Q(G2(:,:,:,273),wf(:,-2),G2(:,:,:,274),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,274),Q(:,63),MT,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,117),wf(:,397),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,59),MT,G2(:,:,:,275))
  call loop_AS_Q(G2(:,:,:,275),wf(:,-2),G2(:,:,:,276),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,276),Q(:,63),MT,G3tensor(:,84))
  call loop_AS_Q(G1(:,:,:,117),wf(:,-2),G1(:,:,:,122),gH)
  call loop_A_Q(G1(:,:,:,122),Q(:,20),MT,G2(:,:,:,277))
  call loop_AV_Q(G2(:,:,:,277),wf(:,21),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,60),MT,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,86),G3(:,:,:,162))
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),MT,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,277),wf(:,-3),G2(:,:,:,279))
  call loop_A_Q(G2(:,:,:,279),Q(:,28),MT,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-5),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,60),MT,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,86),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,17))
  call loop_AV_Q(G1(:,:,:,117),wf(:,400),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,59),MT,G2(:,:,:,280))
  call loop_AS_Q(G2(:,:,:,280),wf(:,-2),G2(:,:,:,281),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,281),Q(:,63),MT,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,117),wf(:,116),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,27),MT,G2(:,:,:,282))
  call loop_AV_Q(G2(:,:,:,282),wf(:,-5),G2(:,:,:,283))
  call loop_A_Q(G2(:,:,:,283),Q(:,59),MT,G3(:,:,:,165))
  call loop_AS_Q(G3(:,:,:,165),wf(:,-2),G3(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,70))
  call loop_AV_Q(G1(:,:,:,117),wf(:,403),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,59),MT,G2(:,:,:,284))
  call loop_AS_Q(G2(:,:,:,284),wf(:,-2),G2(:,:,:,285),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,285),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,117),wf(:,-3),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,24),MT,G2(:,:,:,286))
  call loop_AV_Q(G2(:,:,:,286),wf(:,111),G2(:,:,:,287))
  call loop_A_Q(G2(:,:,:,287),Q(:,59),MT,G3(:,:,:,167))
  call loop_AS_Q(G3(:,:,:,167),wf(:,-2),G3(:,:,:,168),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,71))
  call loop_AS_Q(G2(:,:,:,286),wf(:,-2),G2(:,:,:,288),gH)
  call loop_A_Q(G2(:,:,:,288),Q(:,28),MT,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-5),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,60),MT,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,86),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,18))
  call loop_AV_Q(G2(:,:,:,286),wf(:,-5),G2(:,:,:,289))
  call loop_A_Q(G2(:,:,:,289),Q(:,56),MT,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,4),G3(:,:,:,172))
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,72))
  call loop_AV_Q(G3(:,:,:,171),wf(:,9),G3(:,:,:,173))
  call check_last_A_Q(l_switch,G3(:,:,:,173),Q(:,63),MT,G4tensor(:,73))
  call loop_AV_Q(G2(:,:,:,286),wf(:,218),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,59),MT,G3(:,:,:,174))
  call loop_AS_Q(G3(:,:,:,174),wf(:,-2),G3(:,:,:,175),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,175),Q(:,63),MT,G4tensor(:,74))
  call loop_AV_Q(G2(:,:,:,286),wf(:,219),G2(:,:,:,291))
  call loop_A_Q(G2(:,:,:,291),Q(:,59),MT,G3(:,:,:,176))
  call loop_AS_Q(G3(:,:,:,176),wf(:,-2),G3(:,:,:,177),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,177),Q(:,63),MT,G4tensor(:,75))
  call loop_AV_Q(G1(:,:,:,117),wf(:,-5),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,48),MT,G2(:,:,:,292))
  call loop_AV_Q(G2(:,:,:,292),wf(:,13),G2(:,:,:,293))
  call check_last_A_Q(l_switch,G2(:,:,:,293),Q(:,63),MT,G3tensor(:,87))
  call loop_AV_Q(G2(:,:,:,292),wf(:,405),G2(:,:,:,294))
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G2(:,:,:,292),wf(:,408),G2(:,:,:,295))
  call check_last_A_Q(l_switch,G2(:,:,:,295),Q(:,63),MT,G3tensor(:,89))
  call loop_AV_Q(G2(:,:,:,292),wf(:,47),G2(:,:,:,296))
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),MT,G3tensor(:,90))
  call loop_AV_Q(G2(:,:,:,292),wf(:,423),G2(:,:,:,297))
  call check_last_A_Q(l_switch,G2(:,:,:,297),Q(:,63),MT,G3tensor(:,91))
  call loop_AV_Q(G2(:,:,:,292),wf(:,426),G2(:,:,:,298))
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,292),wf(:,443),G2(:,:,:,299))
  call check_last_A_Q(l_switch,G2(:,:,:,299),Q(:,63),MT,G3tensor(:,93))
  call loop_AV_Q(G2(:,:,:,292),wf(:,460),G2(:,:,:,300))
  call check_last_A_Q(l_switch,G2(:,:,:,300),Q(:,63),MT,G3tensor(:,94))
  call loop_AV_Q(G1(:,:,:,117),wf(:,32),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,55),MT,G2(:,:,:,301))
  call loop_AV_Q(G2(:,:,:,301),wf(:,-3),G2(:,:,:,302))
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,63),MT,G3tensor(:,95))
  call loop_AV_Q(G1(:,:,:,117),wf(:,21),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,56),MT,G2(:,:,:,303))
  call loop_AV_Q(G2(:,:,:,303),wf(:,4),G2(:,:,:,304))
  call check_last_A_Q(l_switch,G2(:,:,:,304),Q(:,63),MT,G3tensor(:,96))
  call loop_AV_Q(G2(:,:,:,303),wf(:,9),G2(:,:,:,305))
  call check_last_A_Q(l_switch,G2(:,:,:,305),Q(:,63),MT,G3tensor(:,97))
  call loop_AV_Q(G1(:,:,:,117),wf(:,407),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,55),MT,G2(:,:,:,306))
  call loop_AV_Q(G2(:,:,:,306),wf(:,-3),G2(:,:,:,307))
  call check_last_A_Q(l_switch,G2(:,:,:,307),Q(:,63),MT,G3tensor(:,98))
  call loop_AV_Q(G1(:,:,:,117),wf(:,418),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,55),MT,G2(:,:,:,308))
  call loop_AV_Q(G2(:,:,:,308),wf(:,-3),G2(:,:,:,309))
  call check_last_A_Q(l_switch,G2(:,:,:,309),Q(:,63),MT,G3tensor(:,99))
  call loop_AV_Q(G1(:,:,:,117),wf(:,64),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,55),MT,G2(:,:,:,310))
  call loop_AV_Q(G2(:,:,:,310),wf(:,-3),G2(:,:,:,311))
  call check_last_A_Q(l_switch,G2(:,:,:,311),Q(:,63),MT,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,117),wf(:,425),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,55),MT,G2(:,:,:,312))
  call loop_AV_Q(G2(:,:,:,312),wf(:,-3),G2(:,:,:,313))
  call check_last_A_Q(l_switch,G2(:,:,:,313),Q(:,63),MT,G3tensor(:,101))
  call loop_AV_Q(G1(:,:,:,117),wf(:,428),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,55),MT,G2(:,:,:,314))
  call loop_AV_Q(G2(:,:,:,314),wf(:,-3),G2(:,:,:,315))
  call check_last_A_Q(l_switch,G2(:,:,:,315),Q(:,63),MT,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,117),wf(:,203),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,59),MT,G2(:,:,:,316))
  call loop_AS_Q(G2(:,:,:,316),wf(:,-2),G2(:,:,:,317),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,317),Q(:,63),MT,G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,117),wf(:,442),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,59),MT,G2(:,:,:,318))
  call loop_AS_Q(G2(:,:,:,318),wf(:,-2),G2(:,:,:,319),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,319),Q(:,63),MT,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,117),wf(:,200),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,27),MT,G2(:,:,:,320))
  call loop_AV_Q(G2(:,:,:,320),wf(:,-5),G2(:,:,:,321))
  call loop_A_Q(G2(:,:,:,321),Q(:,59),MT,G3(:,:,:,178))
  call loop_AS_Q(G3(:,:,:,178),wf(:,-2),G3(:,:,:,179),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,179),Q(:,63),MT,G4tensor(:,76))
  call loop_AV_Q(G1(:,:,:,117),wf(:,453),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,59),MT,G2(:,:,:,322))
  call loop_AS_Q(G2(:,:,:,322),wf(:,-2),G2(:,:,:,323),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,323),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G1(:,:,:,117),wf(:,213),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,59),MT,G2(:,:,:,324))
  call loop_AS_Q(G2(:,:,:,324),wf(:,-2),G2(:,:,:,325),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,325),Q(:,63),MT,G3tensor(:,106))
  call loop_AV_Q(G1(:,:,:,117),wf(:,459),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,59),MT,G2(:,:,:,326))
  call loop_AS_Q(G2(:,:,:,326),wf(:,-2),G2(:,:,:,327),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,327),Q(:,63),MT,G3tensor(:,107))
  call loop_AV_Q(G1(:,:,:,117),wf(:,210),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,27),MT,G2(:,:,:,328))
  call loop_AV_Q(G2(:,:,:,328),wf(:,-5),G2(:,:,:,329))
  call loop_A_Q(G2(:,:,:,329),Q(:,59),MT,G3(:,:,:,180))
  call loop_AS_Q(G3(:,:,:,180),wf(:,-2),G3(:,:,:,181),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,181),Q(:,63),MT,G4tensor(:,77))
  call loop_AV_Q(G1(:,:,:,117),wf(:,462),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,59),MT,G2(:,:,:,330))
  call loop_AS_Q(G2(:,:,:,330),wf(:,-2),G2(:,:,:,331),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,331),Q(:,63),MT,G3tensor(:,108))
  call loop_AV_Q(G1(:,:,:,117),wf(:,523),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,59),MT,G2(:,:,:,332))
  call loop_AS_Q(G2(:,:,:,332),wf(:,-2),G2(:,:,:,333),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,333),Q(:,63),MT,G3tensor(:,109))
  call loop_AV_Q(G1(:,:,:,117),wf(:,525),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,55),MT,G2(:,:,:,334))
  call loop_AV_Q(G2(:,:,:,334),wf(:,-3),G2(:,:,:,335))
  call check_last_A_Q(l_switch,G2(:,:,:,335),Q(:,63),MT,G3tensor(:,110))
  call loop_AV_Q(G1(:,:,:,117),wf(:,530),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,59),MT,G2(:,:,:,336))
  call loop_AS_Q(G2(:,:,:,336),wf(:,-2),G2(:,:,:,337),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,337),Q(:,63),MT,G3tensor(:,111))
  call loop_AV_Q(G1(:,:,:,117),wf(:,540),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,59),MT,G2(:,:,:,338))
  call loop_AS_Q(G2(:,:,:,338),wf(:,-2),G2(:,:,:,339),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,339),Q(:,63),MT,G3tensor(:,112))
  call loop_AV_Q(G1(:,:,:,117),wf(:,542),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,55),MT,G2(:,:,:,340))
  call loop_AV_Q(G2(:,:,:,340),wf(:,-3),G2(:,:,:,341))
  call check_last_A_Q(l_switch,G2(:,:,:,341),Q(:,63),MT,G3tensor(:,113))
  call loop_AV_Q(G1(:,:,:,117),wf(:,543),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,59),MT,G2(:,:,:,342))
  call loop_AS_Q(G2(:,:,:,342),wf(:,-2),G2(:,:,:,343),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,343),Q(:,63),MT,G3tensor(:,114))
  call loop_AV_Q(G1(:,:,:,117),wf(:,557),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,59),MT,G2(:,:,:,344))
  call loop_AS_Q(G2(:,:,:,344),wf(:,-2),G2(:,:,:,345),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,345),Q(:,63),MT,G3tensor(:,115))
  call loop_AV_Q(G1(:,:,:,117),wf(:,558),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,59),MT,G2(:,:,:,346))
  call loop_AS_Q(G2(:,:,:,346),wf(:,-2),G2(:,:,:,347),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,347),Q(:,63),MT,G3tensor(:,116))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),MT,G1(:,:,:,151))
  call loop_QV_A(G1(:,:,:,151),wf(:,93),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,59),MT,G2(:,:,:,348))
  call loop_QS_A(G2(:,:,:,348),wf(:,-2),G2(:,:,:,349),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,349),Q(:,63),MT,G3tensor(:,117))
  call loop_QV_A(G1(:,:,:,151),wf(:,94),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,59),MT,G2(:,:,:,350))
  call loop_QS_A(G2(:,:,:,350),wf(:,-2),G2(:,:,:,351),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,351),Q(:,63),MT,G3tensor(:,118))
  call loop_QV_A(G1(:,:,:,151),wf(:,95),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,59),MT,G2(:,:,:,352))
  call loop_QS_A(G2(:,:,:,352),wf(:,-2),G2(:,:,:,353),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,353),Q(:,63),MT,G3tensor(:,119))
  call loop_QV_A(G1(:,:,:,151),wf(:,397),G1(:,:,:,155))
  call loop_Q_A(G1(:,:,:,155),Q(:,59),MT,G2(:,:,:,354))
  call loop_QS_A(G2(:,:,:,354),wf(:,-2),G2(:,:,:,355),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,355),Q(:,63),MT,G3tensor(:,120))
  call loop_QS_A(G1(:,:,:,151),wf(:,-2),G1(:,:,:,156),gH)
  call loop_Q_A(G1(:,:,:,156),Q(:,20),MT,G2(:,:,:,356))
  call loop_QV_A(G2(:,:,:,356),wf(:,21),G2(:,:,:,357))
  call loop_Q_A(G2(:,:,:,357),Q(:,60),MT,G3(:,:,:,182))
  call loop_QV_A(G3(:,:,:,182),wf(:,86),G3(:,:,:,183))
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,63),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,356),wf(:,-3),G2(:,:,:,358))
  call loop_Q_A(G2(:,:,:,358),Q(:,28),MT,G3(:,:,:,184))
  call loop_QV_A(G3(:,:,:,184),wf(:,-5),G3(:,:,:,185))
  call loop_Q_A(G3(:,:,:,185),Q(:,60),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,86),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G1(:,:,:,151),wf(:,400),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,59),MT,G2(:,:,:,359))
  call loop_QS_A(G2(:,:,:,359),wf(:,-2),G2(:,:,:,360),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,63),MT,G3tensor(:,121))
  call loop_QV_A(G1(:,:,:,151),wf(:,116),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,27),MT,G2(:,:,:,361))
  call loop_QV_A(G2(:,:,:,361),wf(:,-5),G2(:,:,:,362))
  call loop_Q_A(G2(:,:,:,362),Q(:,59),MT,G3(:,:,:,186))
  call loop_QS_A(G3(:,:,:,186),wf(:,-2),G3(:,:,:,187),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,63),MT,G4tensor(:,79))
  call loop_QV_A(G1(:,:,:,151),wf(:,403),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,59),MT,G2(:,:,:,363))
  call loop_QS_A(G2(:,:,:,363),wf(:,-2),G2(:,:,:,364),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,364),Q(:,63),MT,G3tensor(:,122))
  call loop_QV_A(G1(:,:,:,151),wf(:,-3),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,24),MT,G2(:,:,:,365))
  call loop_QV_A(G2(:,:,:,365),wf(:,111),G2(:,:,:,366))
  call loop_Q_A(G2(:,:,:,366),Q(:,59),MT,G3(:,:,:,188))
  call loop_QS_A(G3(:,:,:,188),wf(:,-2),G3(:,:,:,189),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,63),MT,G4tensor(:,80))
  call loop_QS_A(G2(:,:,:,365),wf(:,-2),G2(:,:,:,367),gH)
  call loop_Q_A(G2(:,:,:,367),Q(:,28),MT,G3(:,:,:,190))
  call loop_QV_A(G3(:,:,:,190),wf(:,-5),G3(:,:,:,191))
  call loop_Q_A(G3(:,:,:,191),Q(:,60),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,86),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G2(:,:,:,365),wf(:,-5),G2(:,:,:,368))
  call loop_Q_A(G2(:,:,:,368),Q(:,56),MT,G3(:,:,:,192))
  call loop_QV_A(G3(:,:,:,192),wf(:,4),G3(:,:,:,193))
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,63),MT,G4tensor(:,81))
  call loop_QV_A(G3(:,:,:,192),wf(:,9),G3(:,:,:,194))
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,63),MT,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,365),wf(:,218),G2(:,:,:,369))
  call loop_Q_A(G2(:,:,:,369),Q(:,59),MT,G3(:,:,:,195))
  call loop_QS_A(G3(:,:,:,195),wf(:,-2),G3(:,:,:,196),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,63),MT,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,365),wf(:,219),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,59),MT,G3(:,:,:,197))
  call loop_QS_A(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,63),MT,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,151),wf(:,-5),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,48),MT,G2(:,:,:,371))
  call loop_QV_A(G2(:,:,:,371),wf(:,13),G2(:,:,:,372))
  call check_last_Q_A(l_switch,G2(:,:,:,372),Q(:,63),MT,G3tensor(:,123))
  call loop_QV_A(G2(:,:,:,371),wf(:,405),G2(:,:,:,373))
  call check_last_Q_A(l_switch,G2(:,:,:,373),Q(:,63),MT,G3tensor(:,124))
  call loop_QV_A(G2(:,:,:,371),wf(:,408),G2(:,:,:,374))
  call check_last_Q_A(l_switch,G2(:,:,:,374),Q(:,63),MT,G3tensor(:,125))
  call loop_QV_A(G2(:,:,:,371),wf(:,47),G2(:,:,:,375))
  call check_last_Q_A(l_switch,G2(:,:,:,375),Q(:,63),MT,G3tensor(:,126))
  call loop_QV_A(G2(:,:,:,371),wf(:,423),G2(:,:,:,376))
  call check_last_Q_A(l_switch,G2(:,:,:,376),Q(:,63),MT,G3tensor(:,127))
  call loop_QV_A(G2(:,:,:,371),wf(:,426),G2(:,:,:,377))
  call check_last_Q_A(l_switch,G2(:,:,:,377),Q(:,63),MT,G3tensor(:,128))
  call loop_QV_A(G2(:,:,:,371),wf(:,443),G2(:,:,:,378))
  call check_last_Q_A(l_switch,G2(:,:,:,378),Q(:,63),MT,G3tensor(:,129))
  call loop_QV_A(G2(:,:,:,371),wf(:,460),G2(:,:,:,379))
  call check_last_Q_A(l_switch,G2(:,:,:,379),Q(:,63),MT,G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,151),wf(:,32),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,55),MT,G2(:,:,:,380))
  call loop_QV_A(G2(:,:,:,380),wf(:,-3),G2(:,:,:,381))
  call check_last_Q_A(l_switch,G2(:,:,:,381),Q(:,63),MT,G3tensor(:,131))
  call loop_QV_A(G1(:,:,:,151),wf(:,21),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,56),MT,G2(:,:,:,382))
  call loop_QV_A(G2(:,:,:,382),wf(:,4),G2(:,:,:,383))
  call check_last_Q_A(l_switch,G2(:,:,:,383),Q(:,63),MT,G3tensor(:,132))
  call loop_QV_A(G2(:,:,:,382),wf(:,9),G2(:,:,:,384))
  call check_last_Q_A(l_switch,G2(:,:,:,384),Q(:,63),MT,G3tensor(:,133))
  call loop_QV_A(G1(:,:,:,151),wf(:,407),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,55),MT,G2(:,:,:,385))
  call loop_QV_A(G2(:,:,:,385),wf(:,-3),G2(:,:,:,386))
  call check_last_Q_A(l_switch,G2(:,:,:,386),Q(:,63),MT,G3tensor(:,134))
  call loop_QV_A(G1(:,:,:,151),wf(:,418),G1(:,:,:,165))
  call loop_Q_A(G1(:,:,:,165),Q(:,55),MT,G2(:,:,:,387))
  call loop_QV_A(G2(:,:,:,387),wf(:,-3),G2(:,:,:,388))
  call check_last_Q_A(l_switch,G2(:,:,:,388),Q(:,63),MT,G3tensor(:,135))
  call loop_QV_A(G1(:,:,:,151),wf(:,64),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,55),MT,G2(:,:,:,389))
  call loop_QV_A(G2(:,:,:,389),wf(:,-3),G2(:,:,:,390))
  call check_last_Q_A(l_switch,G2(:,:,:,390),Q(:,63),MT,G3tensor(:,136))
  call loop_QV_A(G1(:,:,:,151),wf(:,425),G1(:,:,:,167))
  call loop_Q_A(G1(:,:,:,167),Q(:,55),MT,G2(:,:,:,391))
  call loop_QV_A(G2(:,:,:,391),wf(:,-3),G2(:,:,:,392))
  call check_last_Q_A(l_switch,G2(:,:,:,392),Q(:,63),MT,G3tensor(:,137))
  call loop_QV_A(G1(:,:,:,151),wf(:,428),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,55),MT,G2(:,:,:,393))
  call loop_QV_A(G2(:,:,:,393),wf(:,-3),G2(:,:,:,394))
  call check_last_Q_A(l_switch,G2(:,:,:,394),Q(:,63),MT,G3tensor(:,138))
  call loop_QV_A(G1(:,:,:,151),wf(:,203),G1(:,:,:,169))
  call loop_Q_A(G1(:,:,:,169),Q(:,59),MT,G2(:,:,:,395))
  call loop_QS_A(G2(:,:,:,395),wf(:,-2),G2(:,:,:,396),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,396),Q(:,63),MT,G3tensor(:,139))
  call loop_QV_A(G1(:,:,:,151),wf(:,442),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,59),MT,G2(:,:,:,397))
  call loop_QS_A(G2(:,:,:,397),wf(:,-2),G2(:,:,:,398),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,63),MT,G3tensor(:,140))
  call loop_QV_A(G1(:,:,:,151),wf(:,200),G1(:,:,:,171))
  call loop_Q_A(G1(:,:,:,171),Q(:,27),MT,G2(:,:,:,399))
  call loop_QV_A(G2(:,:,:,399),wf(:,-5),G2(:,:,:,400))
  call loop_Q_A(G2(:,:,:,400),Q(:,59),MT,G3(:,:,:,199))
  call loop_QS_A(G3(:,:,:,199),wf(:,-2),G3(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,63),MT,G4tensor(:,85))
  call loop_QV_A(G1(:,:,:,151),wf(:,453),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,59),MT,G2(:,:,:,401))
  call loop_QS_A(G2(:,:,:,401),wf(:,-2),G2(:,:,:,402),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,402),Q(:,63),MT,G3tensor(:,141))
  call loop_QV_A(G1(:,:,:,151),wf(:,213),G1(:,:,:,173))
  call loop_Q_A(G1(:,:,:,173),Q(:,59),MT,G2(:,:,:,403))
  call loop_QS_A(G2(:,:,:,403),wf(:,-2),G2(:,:,:,404),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,404),Q(:,63),MT,G3tensor(:,142))
  call loop_QV_A(G1(:,:,:,151),wf(:,459),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,59),MT,G2(:,:,:,405))
  call loop_QS_A(G2(:,:,:,405),wf(:,-2),G2(:,:,:,406),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,406),Q(:,63),MT,G3tensor(:,143))
  call loop_QV_A(G1(:,:,:,151),wf(:,210),G1(:,:,:,175))
  call loop_Q_A(G1(:,:,:,175),Q(:,27),MT,G2(:,:,:,407))
  call loop_QV_A(G2(:,:,:,407),wf(:,-5),G2(:,:,:,408))
  call loop_Q_A(G2(:,:,:,408),Q(:,59),MT,G3(:,:,:,201))
  call loop_QS_A(G3(:,:,:,201),wf(:,-2),G3(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,86))
  call loop_QV_A(G1(:,:,:,151),wf(:,462),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,59),MT,G2(:,:,:,409))
  call loop_QS_A(G2(:,:,:,409),wf(:,-2),G2(:,:,:,410),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,410),Q(:,63),MT,G3tensor(:,144))
  call loop_QV_A(G1(:,:,:,151),wf(:,523),G1(:,:,:,177))
  call loop_Q_A(G1(:,:,:,177),Q(:,59),MT,G2(:,:,:,411))
  call loop_QS_A(G2(:,:,:,411),wf(:,-2),G2(:,:,:,412),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,412),Q(:,63),MT,G3tensor(:,145))
  call loop_QV_A(G1(:,:,:,151),wf(:,525),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,55),MT,G2(:,:,:,413))
  call loop_QV_A(G2(:,:,:,413),wf(:,-3),G2(:,:,:,414))
  call check_last_Q_A(l_switch,G2(:,:,:,414),Q(:,63),MT,G3tensor(:,146))
  call loop_QV_A(G1(:,:,:,151),wf(:,530),G1(:,:,:,179))
  call loop_Q_A(G1(:,:,:,179),Q(:,59),MT,G2(:,:,:,415))
  call loop_QS_A(G2(:,:,:,415),wf(:,-2),G2(:,:,:,416),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,416),Q(:,63),MT,G3tensor(:,147))
  call loop_QV_A(G1(:,:,:,151),wf(:,540),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,59),MT,G2(:,:,:,417))
  call loop_QS_A(G2(:,:,:,417),wf(:,-2),G2(:,:,:,418),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,418),Q(:,63),MT,G3tensor(:,148))
  call loop_QV_A(G1(:,:,:,151),wf(:,542),G1(:,:,:,181))
  call loop_Q_A(G1(:,:,:,181),Q(:,55),MT,G2(:,:,:,419))
  call loop_QV_A(G2(:,:,:,419),wf(:,-3),G2(:,:,:,420))
  call check_last_Q_A(l_switch,G2(:,:,:,420),Q(:,63),MT,G3tensor(:,149))
  call loop_QV_A(G1(:,:,:,151),wf(:,543),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,59),MT,G2(:,:,:,421))
  call loop_QS_A(G2(:,:,:,421),wf(:,-2),G2(:,:,:,422),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,422),Q(:,63),MT,G3tensor(:,150))
  call loop_QV_A(G1(:,:,:,151),wf(:,557),G1(:,:,:,183))
  call loop_Q_A(G1(:,:,:,183),Q(:,59),MT,G2(:,:,:,423))
  call loop_QS_A(G2(:,:,:,423),wf(:,-2),G2(:,:,:,424),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,424),Q(:,63),MT,G3tensor(:,151))
  call loop_QV_A(G1(:,:,:,151),wf(:,558),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,59),MT,G2(:,:,:,425))
  call loop_QS_A(G2(:,:,:,425),wf(:,-2),G2(:,:,:,426),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,426),Q(:,63),MT,G3tensor(:,152))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,16),MB,G1(:,:,:,185))
  call loop_AV_Q(G1(:,:,:,185),wf(:,93),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,59),MB,G2(:,:,:,427))
  call loop_AS_Q(G2(:,:,:,427),wf(:,-2),G2(:,:,:,428),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,428),Q(:,63),MB,G3tensor(:,153))
  call loop_AV_Q(G1(:,:,:,185),wf(:,94),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,59),MB,G2(:,:,:,429))
  call loop_AS_Q(G2(:,:,:,429),wf(:,-2),G2(:,:,:,430),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,430),Q(:,63),MB,G3tensor(:,154))
  call loop_AV_Q(G1(:,:,:,185),wf(:,95),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,59),MB,G2(:,:,:,431))
  call loop_AS_Q(G2(:,:,:,431),wf(:,-2),G2(:,:,:,432),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,432),Q(:,63),MB,G3tensor(:,155))
  call loop_AV_Q(G1(:,:,:,185),wf(:,397),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,59),MB,G2(:,:,:,433))
  call loop_AS_Q(G2(:,:,:,433),wf(:,-2),G2(:,:,:,434),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,434),Q(:,63),MB,G3tensor(:,156))
  call loop_AS_Q(G1(:,:,:,185),wf(:,-2),G1(:,:,:,190),gH)
  call loop_A_Q(G1(:,:,:,190),Q(:,20),MB,G2(:,:,:,435))
  call loop_AV_Q(G2(:,:,:,435),wf(:,21),G2(:,:,:,436))
  call loop_A_Q(G2(:,:,:,436),Q(:,60),MB,G3(:,:,:,203))
  call loop_AV_Q(G3(:,:,:,203),wf(:,86),G3(:,:,:,204))
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,63),MB,G4tensor(:,87))
  call loop_AV_Q(G2(:,:,:,435),wf(:,-3),G2(:,:,:,437))
  call loop_A_Q(G2(:,:,:,437),Q(:,28),MB,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,60),MB,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,86),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MB,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,185),wf(:,400),G1(:,:,:,191))
  call loop_A_Q(G1(:,:,:,191),Q(:,59),MB,G2(:,:,:,438))
  call loop_AS_Q(G2(:,:,:,438),wf(:,-2),G2(:,:,:,439),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,439),Q(:,63),MB,G3tensor(:,157))
  call loop_AV_Q(G1(:,:,:,185),wf(:,116),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,27),MB,G2(:,:,:,440))
  call loop_AV_Q(G2(:,:,:,440),wf(:,-5),G2(:,:,:,441))
  call loop_A_Q(G2(:,:,:,441),Q(:,59),MB,G3(:,:,:,207))
  call loop_AS_Q(G3(:,:,:,207),wf(:,-2),G3(:,:,:,208),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,63),MB,G4tensor(:,88))
  call loop_AV_Q(G1(:,:,:,185),wf(:,403),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,59),MB,G2(:,:,:,442))
  call loop_AS_Q(G2(:,:,:,442),wf(:,-2),G2(:,:,:,443),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,443),Q(:,63),MB,G3tensor(:,158))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-3),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,24),MB,G2(:,:,:,444))
  call loop_AV_Q(G2(:,:,:,444),wf(:,111),G2(:,:,:,445))
  call loop_A_Q(G2(:,:,:,445),Q(:,59),MB,G3(:,:,:,209))
  call loop_AS_Q(G3(:,:,:,209),wf(:,-2),G3(:,:,:,210),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,63),MB,G4tensor(:,89))
  call loop_AS_Q(G2(:,:,:,444),wf(:,-2),G2(:,:,:,446),gH)
  call loop_A_Q(G2(:,:,:,446),Q(:,28),MB,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,-5),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,60),MB,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,86),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MB,G5tensor(:,22))
  call loop_AV_Q(G2(:,:,:,444),wf(:,-5),G2(:,:,:,447))
  call loop_A_Q(G2(:,:,:,447),Q(:,56),MB,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,4),G3(:,:,:,214))
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,63),MB,G4tensor(:,90))
  call loop_AV_Q(G3(:,:,:,213),wf(:,9),G3(:,:,:,215))
  call check_last_A_Q(l_switch,G3(:,:,:,215),Q(:,63),MB,G4tensor(:,91))
  call loop_AV_Q(G2(:,:,:,444),wf(:,218),G2(:,:,:,448))
  call loop_A_Q(G2(:,:,:,448),Q(:,59),MB,G3(:,:,:,216))
  call loop_AS_Q(G3(:,:,:,216),wf(:,-2),G3(:,:,:,217),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,217),Q(:,63),MB,G4tensor(:,92))
  call loop_AV_Q(G2(:,:,:,444),wf(:,219),G2(:,:,:,449))
  call loop_A_Q(G2(:,:,:,449),Q(:,59),MB,G3(:,:,:,218))
  call loop_AS_Q(G3(:,:,:,218),wf(:,-2),G3(:,:,:,219),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,219),Q(:,63),MB,G4tensor(:,93))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-5),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,48),MB,G2(:,:,:,450))
  call loop_AV_Q(G2(:,:,:,450),wf(:,13),G2(:,:,:,451))
  call check_last_A_Q(l_switch,G2(:,:,:,451),Q(:,63),MB,G3tensor(:,159))
  call loop_AV_Q(G2(:,:,:,450),wf(:,405),G2(:,:,:,452))
  call check_last_A_Q(l_switch,G2(:,:,:,452),Q(:,63),MB,G3tensor(:,160))
  call loop_AV_Q(G2(:,:,:,450),wf(:,408),G2(:,:,:,453))
  call check_last_A_Q(l_switch,G2(:,:,:,453),Q(:,63),MB,G3tensor(:,161))
  call loop_AV_Q(G2(:,:,:,450),wf(:,47),G2(:,:,:,454))
  call check_last_A_Q(l_switch,G2(:,:,:,454),Q(:,63),MB,G3tensor(:,162))
  call loop_AV_Q(G2(:,:,:,450),wf(:,423),G2(:,:,:,455))
  call check_last_A_Q(l_switch,G2(:,:,:,455),Q(:,63),MB,G3tensor(:,163))
  call loop_AV_Q(G2(:,:,:,450),wf(:,426),G2(:,:,:,456))
  call check_last_A_Q(l_switch,G2(:,:,:,456),Q(:,63),MB,G3tensor(:,164))
  call loop_AV_Q(G2(:,:,:,450),wf(:,443),G2(:,:,:,457))
  call check_last_A_Q(l_switch,G2(:,:,:,457),Q(:,63),MB,G3tensor(:,165))
  call loop_AV_Q(G2(:,:,:,450),wf(:,460),G2(:,:,:,458))
  call check_last_A_Q(l_switch,G2(:,:,:,458),Q(:,63),MB,G3tensor(:,166))
  call loop_AV_Q(G1(:,:,:,185),wf(:,32),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,55),MB,G2(:,:,:,459))
  call loop_AV_Q(G2(:,:,:,459),wf(:,-3),G2(:,:,:,460))
  call check_last_A_Q(l_switch,G2(:,:,:,460),Q(:,63),MB,G3tensor(:,167))
  call loop_AV_Q(G1(:,:,:,185),wf(:,21),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,56),MB,G2(:,:,:,461))
  call loop_AV_Q(G2(:,:,:,461),wf(:,4),G2(:,:,:,462))
  call check_last_A_Q(l_switch,G2(:,:,:,462),Q(:,63),MB,G3tensor(:,168))
  call loop_AV_Q(G2(:,:,:,461),wf(:,9),G2(:,:,:,463))
  call check_last_A_Q(l_switch,G2(:,:,:,463),Q(:,63),MB,G3tensor(:,169))
  call loop_AV_Q(G1(:,:,:,185),wf(:,407),G1(:,:,:,198))
  call loop_A_Q(G1(:,:,:,198),Q(:,55),MB,G2(:,:,:,464))
  call loop_AV_Q(G2(:,:,:,464),wf(:,-3),G2(:,:,:,465))
  call check_last_A_Q(l_switch,G2(:,:,:,465),Q(:,63),MB,G3tensor(:,170))
  call loop_AV_Q(G1(:,:,:,185),wf(:,418),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,55),MB,G2(:,:,:,466))
  call loop_AV_Q(G2(:,:,:,466),wf(:,-3),G2(:,:,:,467))
  call check_last_A_Q(l_switch,G2(:,:,:,467),Q(:,63),MB,G3tensor(:,171))
  call loop_AV_Q(G1(:,:,:,185),wf(:,64),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,55),MB,G2(:,:,:,468))
  call loop_AV_Q(G2(:,:,:,468),wf(:,-3),G2(:,:,:,469))
  call check_last_A_Q(l_switch,G2(:,:,:,469),Q(:,63),MB,G3tensor(:,172))
  call loop_AV_Q(G1(:,:,:,185),wf(:,425),G1(:,:,:,201))
  call loop_A_Q(G1(:,:,:,201),Q(:,55),MB,G2(:,:,:,470))
  call loop_AV_Q(G2(:,:,:,470),wf(:,-3),G2(:,:,:,471))
  call check_last_A_Q(l_switch,G2(:,:,:,471),Q(:,63),MB,G3tensor(:,173))
  call loop_AV_Q(G1(:,:,:,185),wf(:,428),G1(:,:,:,202))
  call loop_A_Q(G1(:,:,:,202),Q(:,55),MB,G2(:,:,:,472))
  call loop_AV_Q(G2(:,:,:,472),wf(:,-3),G2(:,:,:,473))
  call check_last_A_Q(l_switch,G2(:,:,:,473),Q(:,63),MB,G3tensor(:,174))
  call loop_AV_Q(G1(:,:,:,185),wf(:,203),G1(:,:,:,203))
  call loop_A_Q(G1(:,:,:,203),Q(:,59),MB,G2(:,:,:,474))
  call loop_AS_Q(G2(:,:,:,474),wf(:,-2),G2(:,:,:,475),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,475),Q(:,63),MB,G3tensor(:,175))
  call loop_AV_Q(G1(:,:,:,185),wf(:,442),G1(:,:,:,204))
  call loop_A_Q(G1(:,:,:,204),Q(:,59),MB,G2(:,:,:,476))
  call loop_AS_Q(G2(:,:,:,476),wf(:,-2),G2(:,:,:,477),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,477),Q(:,63),MB,G3tensor(:,176))
  call loop_AV_Q(G1(:,:,:,185),wf(:,200),G1(:,:,:,205))
  call loop_A_Q(G1(:,:,:,205),Q(:,27),MB,G2(:,:,:,478))
  call loop_AV_Q(G2(:,:,:,478),wf(:,-5),G2(:,:,:,479))
  call loop_A_Q(G2(:,:,:,479),Q(:,59),MB,G3(:,:,:,220))
  call loop_AS_Q(G3(:,:,:,220),wf(:,-2),G3(:,:,:,221),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,221),Q(:,63),MB,G4tensor(:,94))
  call loop_AV_Q(G1(:,:,:,185),wf(:,453),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,59),MB,G2(:,:,:,480))
  call loop_AS_Q(G2(:,:,:,480),wf(:,-2),G2(:,:,:,481),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,481),Q(:,63),MB,G3tensor(:,177))
  call loop_AV_Q(G1(:,:,:,185),wf(:,213),G1(:,:,:,207))
  call loop_A_Q(G1(:,:,:,207),Q(:,59),MB,G2(:,:,:,482))
  call loop_AS_Q(G2(:,:,:,482),wf(:,-2),G2(:,:,:,483),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,483),Q(:,63),MB,G3tensor(:,178))
  call loop_AV_Q(G1(:,:,:,185),wf(:,459),G1(:,:,:,208))
  call loop_A_Q(G1(:,:,:,208),Q(:,59),MB,G2(:,:,:,484))
  call loop_AS_Q(G2(:,:,:,484),wf(:,-2),G2(:,:,:,485),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,485),Q(:,63),MB,G3tensor(:,179))
  call loop_AV_Q(G1(:,:,:,185),wf(:,210),G1(:,:,:,209))
  call loop_A_Q(G1(:,:,:,209),Q(:,27),MB,G2(:,:,:,486))
  call loop_AV_Q(G2(:,:,:,486),wf(:,-5),G2(:,:,:,487))
  call loop_A_Q(G2(:,:,:,487),Q(:,59),MB,G3(:,:,:,222))
  call loop_AS_Q(G3(:,:,:,222),wf(:,-2),G3(:,:,:,223),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,223),Q(:,63),MB,G4tensor(:,95))
  call loop_AV_Q(G1(:,:,:,185),wf(:,462),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,59),MB,G2(:,:,:,488))
  call loop_AS_Q(G2(:,:,:,488),wf(:,-2),G2(:,:,:,489),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,489),Q(:,63),MB,G3tensor(:,180))
  call loop_AV_Q(G1(:,:,:,185),wf(:,523),G1(:,:,:,211))
  call loop_A_Q(G1(:,:,:,211),Q(:,59),MB,G2(:,:,:,490))
  call loop_AS_Q(G2(:,:,:,490),wf(:,-2),G2(:,:,:,491),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,491),Q(:,63),MB,G3tensor(:,181))
  call loop_AV_Q(G1(:,:,:,185),wf(:,525),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,55),MB,G2(:,:,:,492))
  call loop_AV_Q(G2(:,:,:,492),wf(:,-3),G2(:,:,:,493))
  call check_last_A_Q(l_switch,G2(:,:,:,493),Q(:,63),MB,G3tensor(:,182))
  call loop_AV_Q(G1(:,:,:,185),wf(:,530),G1(:,:,:,213))
  call loop_A_Q(G1(:,:,:,213),Q(:,59),MB,G2(:,:,:,494))
  call loop_AS_Q(G2(:,:,:,494),wf(:,-2),G2(:,:,:,495),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,495),Q(:,63),MB,G3tensor(:,183))
  call loop_AV_Q(G1(:,:,:,185),wf(:,540),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,59),MB,G2(:,:,:,496))
  call loop_AS_Q(G2(:,:,:,496),wf(:,-2),G2(:,:,:,497),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,497),Q(:,63),MB,G3tensor(:,184))
  call loop_AV_Q(G1(:,:,:,185),wf(:,542),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,55),MB,G2(:,:,:,498))
  call loop_AV_Q(G2(:,:,:,498),wf(:,-3),G2(:,:,:,499))
  call check_last_A_Q(l_switch,G2(:,:,:,499),Q(:,63),MB,G3tensor(:,185))
  call loop_AV_Q(G1(:,:,:,185),wf(:,543),G1(:,:,:,216))
  call loop_A_Q(G1(:,:,:,216),Q(:,59),MB,G2(:,:,:,500))
  call loop_AS_Q(G2(:,:,:,500),wf(:,-2),G2(:,:,:,501),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,501),Q(:,63),MB,G3tensor(:,186))
  call loop_AV_Q(G1(:,:,:,185),wf(:,557),G1(:,:,:,217))
  call loop_A_Q(G1(:,:,:,217),Q(:,59),MB,G2(:,:,:,502))
  call loop_AS_Q(G2(:,:,:,502),wf(:,-2),G2(:,:,:,503),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,503),Q(:,63),MB,G3tensor(:,187))
  call loop_AV_Q(G1(:,:,:,185),wf(:,558),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,59),MB,G2(:,:,:,504))
  call loop_AS_Q(G2(:,:,:,504),wf(:,-2),G2(:,:,:,505),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,505),Q(:,63),MB,G3tensor(:,188))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,16),MB,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,93),G1(:,:,:,220))
  call loop_Q_A(G1(:,:,:,220),Q(:,59),MB,G2(:,:,:,506))
  call loop_QS_A(G2(:,:,:,506),wf(:,-2),G2(:,:,:,507),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,507),Q(:,63),MB,G3tensor(:,189))
  call loop_QV_A(G1(:,:,:,219),wf(:,94),G1(:,:,:,221))
  call loop_Q_A(G1(:,:,:,221),Q(:,59),MB,G2(:,:,:,508))
  call loop_QS_A(G2(:,:,:,508),wf(:,-2),G2(:,:,:,509),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,509),Q(:,63),MB,G3tensor(:,190))
  call loop_QV_A(G1(:,:,:,219),wf(:,95),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,59),MB,G2(:,:,:,510))
  call loop_QS_A(G2(:,:,:,510),wf(:,-2),G2(:,:,:,511),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,511),Q(:,63),MB,G3tensor(:,191))
  call loop_QV_A(G1(:,:,:,219),wf(:,397),G1(:,:,:,223))
  call loop_Q_A(G1(:,:,:,223),Q(:,59),MB,G2(:,:,:,512))
  call loop_QS_A(G2(:,:,:,512),wf(:,-2),G2(:,:,:,513),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,513),Q(:,63),MB,G3tensor(:,192))
  call loop_QS_A(G1(:,:,:,219),wf(:,-2),G1(:,:,:,224),gH)
  call loop_Q_A(G1(:,:,:,224),Q(:,20),MB,G2(:,:,:,514))
  call loop_QV_A(G2(:,:,:,514),wf(:,21),G2(:,:,:,515))
  call loop_Q_A(G2(:,:,:,515),Q(:,60),MB,G3(:,:,:,224))
  call loop_QV_A(G3(:,:,:,224),wf(:,86),G3(:,:,:,225))
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,63),MB,G4tensor(:,96))
  call loop_QV_A(G2(:,:,:,514),wf(:,-3),G2(:,:,:,516))
  call loop_Q_A(G2(:,:,:,516),Q(:,28),MB,G3(:,:,:,226))
  call loop_QV_A(G3(:,:,:,226),wf(:,-5),G3(:,:,:,227))
  call loop_Q_A(G3(:,:,:,227),Q(:,60),MB,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,86),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,63),MB,G5tensor(:,23))
  call loop_QV_A(G1(:,:,:,219),wf(:,400),G1(:,:,:,225))
  call loop_Q_A(G1(:,:,:,225),Q(:,59),MB,G2(:,:,:,517))
  call loop_QS_A(G2(:,:,:,517),wf(:,-2),G2(:,:,:,518),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,518),Q(:,63),MB,G3tensor(:,193))
  call loop_QV_A(G1(:,:,:,219),wf(:,116),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,27),MB,G2(:,:,:,519))
  call loop_QV_A(G2(:,:,:,519),wf(:,-5),G2(:,:,:,520))
  call loop_Q_A(G2(:,:,:,520),Q(:,59),MB,G3(:,:,:,228))
  call loop_QS_A(G3(:,:,:,228),wf(:,-2),G3(:,:,:,229),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,63),MB,G4tensor(:,97))
  call loop_QV_A(G1(:,:,:,219),wf(:,403),G1(:,:,:,227))
  call loop_Q_A(G1(:,:,:,227),Q(:,59),MB,G2(:,:,:,521))
  call loop_QS_A(G2(:,:,:,521),wf(:,-2),G2(:,:,:,522),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,522),Q(:,63),MB,G3tensor(:,194))
  call loop_QV_A(G1(:,:,:,219),wf(:,-3),G1(:,:,:,228))
  call loop_Q_A(G1(:,:,:,228),Q(:,24),MB,G2(:,:,:,523))
  call loop_QV_A(G2(:,:,:,523),wf(:,111),G2(:,:,:,524))
  call loop_Q_A(G2(:,:,:,524),Q(:,59),MB,G3(:,:,:,230))
  call loop_QS_A(G3(:,:,:,230),wf(:,-2),G3(:,:,:,231),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,63),MB,G4tensor(:,98))
  call loop_QS_A(G2(:,:,:,523),wf(:,-2),G2(:,:,:,525),gH)
  call loop_Q_A(G2(:,:,:,525),Q(:,28),MB,G3(:,:,:,232))
  call loop_QV_A(G3(:,:,:,232),wf(:,-5),G3(:,:,:,233))
  call loop_Q_A(G3(:,:,:,233),Q(:,60),MB,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,86),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,63),MB,G5tensor(:,24))
  call loop_QV_A(G2(:,:,:,523),wf(:,-5),G2(:,:,:,526))
  call loop_Q_A(G2(:,:,:,526),Q(:,56),MB,G3(:,:,:,234))
  call loop_QV_A(G3(:,:,:,234),wf(:,4),G3(:,:,:,235))
  call check_last_Q_A(l_switch,G3(:,:,:,235),Q(:,63),MB,G4tensor(:,99))
  call loop_QV_A(G3(:,:,:,234),wf(:,9),G3(:,:,:,236))
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,63),MB,G4tensor(:,100))
  call loop_QV_A(G2(:,:,:,523),wf(:,218),G2(:,:,:,527))
  call loop_Q_A(G2(:,:,:,527),Q(:,59),MB,G3(:,:,:,237))
  call loop_QS_A(G3(:,:,:,237),wf(:,-2),G3(:,:,:,238),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,63),MB,G4tensor(:,101))
  call loop_QV_A(G2(:,:,:,523),wf(:,219),G2(:,:,:,528))
  call loop_Q_A(G2(:,:,:,528),Q(:,59),MB,G3(:,:,:,239))
  call loop_QS_A(G3(:,:,:,239),wf(:,-2),G3(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,240),Q(:,63),MB,G4tensor(:,102))
  call loop_QV_A(G1(:,:,:,219),wf(:,-5),G1(:,:,:,229))
  call loop_Q_A(G1(:,:,:,229),Q(:,48),MB,G2(:,:,:,529))
  call loop_QV_A(G2(:,:,:,529),wf(:,13),G2(:,:,:,530))
  call check_last_Q_A(l_switch,G2(:,:,:,530),Q(:,63),MB,G3tensor(:,195))
  call loop_QV_A(G2(:,:,:,529),wf(:,405),G2(:,:,:,531))
  call check_last_Q_A(l_switch,G2(:,:,:,531),Q(:,63),MB,G3tensor(:,196))
  call loop_QV_A(G2(:,:,:,529),wf(:,408),G2(:,:,:,532))
  call check_last_Q_A(l_switch,G2(:,:,:,532),Q(:,63),MB,G3tensor(:,197))
  call loop_QV_A(G2(:,:,:,529),wf(:,47),G2(:,:,:,533))
  call check_last_Q_A(l_switch,G2(:,:,:,533),Q(:,63),MB,G3tensor(:,198))
  call loop_QV_A(G2(:,:,:,529),wf(:,423),G2(:,:,:,534))
  call check_last_Q_A(l_switch,G2(:,:,:,534),Q(:,63),MB,G3tensor(:,199))
  call loop_QV_A(G2(:,:,:,529),wf(:,426),G2(:,:,:,535))
  call check_last_Q_A(l_switch,G2(:,:,:,535),Q(:,63),MB,G3tensor(:,200))
  call loop_QV_A(G2(:,:,:,529),wf(:,443),G2(:,:,:,536))
  call check_last_Q_A(l_switch,G2(:,:,:,536),Q(:,63),MB,G3tensor(:,201))
  call loop_QV_A(G2(:,:,:,529),wf(:,460),G2(:,:,:,537))
  call check_last_Q_A(l_switch,G2(:,:,:,537),Q(:,63),MB,G3tensor(:,202))
  call loop_QV_A(G1(:,:,:,219),wf(:,32),G1(:,:,:,230))
  call loop_Q_A(G1(:,:,:,230),Q(:,55),MB,G2(:,:,:,538))
  call loop_QV_A(G2(:,:,:,538),wf(:,-3),G2(:,:,:,539))
  call check_last_Q_A(l_switch,G2(:,:,:,539),Q(:,63),MB,G3tensor(:,203))
  call loop_QV_A(G1(:,:,:,219),wf(:,21),G1(:,:,:,231))
  call loop_Q_A(G1(:,:,:,231),Q(:,56),MB,G2(:,:,:,540))
  call loop_QV_A(G2(:,:,:,540),wf(:,4),G2(:,:,:,541))
  call check_last_Q_A(l_switch,G2(:,:,:,541),Q(:,63),MB,G3tensor(:,204))
  call loop_QV_A(G2(:,:,:,540),wf(:,9),G2(:,:,:,542))
  call check_last_Q_A(l_switch,G2(:,:,:,542),Q(:,63),MB,G3tensor(:,205))
  call loop_QV_A(G1(:,:,:,219),wf(:,407),G1(:,:,:,232))
  call loop_Q_A(G1(:,:,:,232),Q(:,55),MB,G2(:,:,:,543))
  call loop_QV_A(G2(:,:,:,543),wf(:,-3),G2(:,:,:,544))
  call check_last_Q_A(l_switch,G2(:,:,:,544),Q(:,63),MB,G3tensor(:,206))
  call loop_QV_A(G1(:,:,:,219),wf(:,418),G1(:,:,:,233))
  call loop_Q_A(G1(:,:,:,233),Q(:,55),MB,G2(:,:,:,545))
  call loop_QV_A(G2(:,:,:,545),wf(:,-3),G2(:,:,:,546))
  call check_last_Q_A(l_switch,G2(:,:,:,546),Q(:,63),MB,G3tensor(:,207))
  call loop_QV_A(G1(:,:,:,219),wf(:,64),G1(:,:,:,234))
  call loop_Q_A(G1(:,:,:,234),Q(:,55),MB,G2(:,:,:,547))
  call loop_QV_A(G2(:,:,:,547),wf(:,-3),G2(:,:,:,548))
  call check_last_Q_A(l_switch,G2(:,:,:,548),Q(:,63),MB,G3tensor(:,208))
  call loop_QV_A(G1(:,:,:,219),wf(:,425),G1(:,:,:,235))
  call loop_Q_A(G1(:,:,:,235),Q(:,55),MB,G2(:,:,:,549))
  call loop_QV_A(G2(:,:,:,549),wf(:,-3),G2(:,:,:,550))
  call check_last_Q_A(l_switch,G2(:,:,:,550),Q(:,63),MB,G3tensor(:,209))
  call loop_QV_A(G1(:,:,:,219),wf(:,428),G1(:,:,:,236))
  call loop_Q_A(G1(:,:,:,236),Q(:,55),MB,G2(:,:,:,551))
  call loop_QV_A(G2(:,:,:,551),wf(:,-3),G2(:,:,:,552))
  call check_last_Q_A(l_switch,G2(:,:,:,552),Q(:,63),MB,G3tensor(:,210))
  call loop_QV_A(G1(:,:,:,219),wf(:,203),G1(:,:,:,237))
  call loop_Q_A(G1(:,:,:,237),Q(:,59),MB,G2(:,:,:,553))
  call loop_QS_A(G2(:,:,:,553),wf(:,-2),G2(:,:,:,554),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,554),Q(:,63),MB,G3tensor(:,211))
  call loop_QV_A(G1(:,:,:,219),wf(:,442),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,59),MB,G2(:,:,:,555))
  call loop_QS_A(G2(:,:,:,555),wf(:,-2),G2(:,:,:,556),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,556),Q(:,63),MB,G3tensor(:,212))
  call loop_QV_A(G1(:,:,:,219),wf(:,200),G1(:,:,:,239))
  call loop_Q_A(G1(:,:,:,239),Q(:,27),MB,G2(:,:,:,557))
  call loop_QV_A(G2(:,:,:,557),wf(:,-5),G2(:,:,:,558))
  call loop_Q_A(G2(:,:,:,558),Q(:,59),MB,G3(:,:,:,241))
  call loop_QS_A(G3(:,:,:,241),wf(:,-2),G3(:,:,:,242),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,63),MB,G4tensor(:,103))
  call loop_QV_A(G1(:,:,:,219),wf(:,453),G1(:,:,:,240))
  call loop_Q_A(G1(:,:,:,240),Q(:,59),MB,G2(:,:,:,559))
  call loop_QS_A(G2(:,:,:,559),wf(:,-2),G2(:,:,:,560),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,560),Q(:,63),MB,G3tensor(:,213))
  call loop_QV_A(G1(:,:,:,219),wf(:,213),G1(:,:,:,241))
  call loop_Q_A(G1(:,:,:,241),Q(:,59),MB,G2(:,:,:,561))
  call loop_QS_A(G2(:,:,:,561),wf(:,-2),G2(:,:,:,562),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,562),Q(:,63),MB,G3tensor(:,214))
  call loop_QV_A(G1(:,:,:,219),wf(:,459),G1(:,:,:,242))
  call loop_Q_A(G1(:,:,:,242),Q(:,59),MB,G2(:,:,:,563))
  call loop_QS_A(G2(:,:,:,563),wf(:,-2),G2(:,:,:,564),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,564),Q(:,63),MB,G3tensor(:,215))
  call loop_QV_A(G1(:,:,:,219),wf(:,210),G1(:,:,:,243))
  call loop_Q_A(G1(:,:,:,243),Q(:,27),MB,G2(:,:,:,565))
  call loop_QV_A(G2(:,:,:,565),wf(:,-5),G2(:,:,:,566))
  call loop_Q_A(G2(:,:,:,566),Q(:,59),MB,G3(:,:,:,243))
  call loop_QS_A(G3(:,:,:,243),wf(:,-2),G3(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,63),MB,G4tensor(:,104))
  call loop_QV_A(G1(:,:,:,219),wf(:,462),G1(:,:,:,244))
  call loop_Q_A(G1(:,:,:,244),Q(:,59),MB,G2(:,:,:,567))
  call loop_QS_A(G2(:,:,:,567),wf(:,-2),G2(:,:,:,568),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,568),Q(:,63),MB,G3tensor(:,216))
  call loop_QV_A(G1(:,:,:,219),wf(:,523),G1(:,:,:,245))
  call loop_Q_A(G1(:,:,:,245),Q(:,59),MB,G2(:,:,:,569))
  call loop_QS_A(G2(:,:,:,569),wf(:,-2),G2(:,:,:,570),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,570),Q(:,63),MB,G3tensor(:,217))
  call loop_QV_A(G1(:,:,:,219),wf(:,525),G1(:,:,:,246))
  call loop_Q_A(G1(:,:,:,246),Q(:,55),MB,G2(:,:,:,571))
  call loop_QV_A(G2(:,:,:,571),wf(:,-3),G2(:,:,:,572))
  call check_last_Q_A(l_switch,G2(:,:,:,572),Q(:,63),MB,G3tensor(:,218))
  call loop_QV_A(G1(:,:,:,219),wf(:,530),G1(:,:,:,247))
  call loop_Q_A(G1(:,:,:,247),Q(:,59),MB,G2(:,:,:,573))
  call loop_QS_A(G2(:,:,:,573),wf(:,-2),G2(:,:,:,574),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,574),Q(:,63),MB,G3tensor(:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,540),G1(:,:,:,248))
  call loop_Q_A(G1(:,:,:,248),Q(:,59),MB,G2(:,:,:,575))
  call loop_QS_A(G2(:,:,:,575),wf(:,-2),G2(:,:,:,576),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,576),Q(:,63),MB,G3tensor(:,220))
  call loop_QV_A(G1(:,:,:,219),wf(:,542),G1(:,:,:,249))
  call loop_Q_A(G1(:,:,:,249),Q(:,55),MB,G2(:,:,:,577))
  call loop_QV_A(G2(:,:,:,577),wf(:,-3),G2(:,:,:,578))
  call check_last_Q_A(l_switch,G2(:,:,:,578),Q(:,63),MB,G3tensor(:,221))
  call loop_QV_A(G1(:,:,:,219),wf(:,543),G1(:,:,:,250))
  call loop_Q_A(G1(:,:,:,250),Q(:,59),MB,G2(:,:,:,579))
  call loop_QS_A(G2(:,:,:,579),wf(:,-2),G2(:,:,:,580),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,580),Q(:,63),MB,G3tensor(:,222))
  call loop_QV_A(G1(:,:,:,219),wf(:,557),G1(:,:,:,251))
  call loop_Q_A(G1(:,:,:,251),Q(:,59),MB,G2(:,:,:,581))
  call loop_QS_A(G2(:,:,:,581),wf(:,-2),G2(:,:,:,582),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,582),Q(:,63),MB,G3tensor(:,223))
  call loop_QV_A(G1(:,:,:,219),wf(:,558),G1(:,:,:,252))
  call loop_Q_A(G1(:,:,:,252),Q(:,59),MB,G2(:,:,:,583))
  call loop_QS_A(G2(:,:,:,583),wf(:,-2),G2(:,:,:,584),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,584),Q(:,63),MB,G3tensor(:,224))
  call loop_QV_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,27),MT,G1(:,:,:,253))
  call loop_QV_A(G1(:,:,:,253),wf(:,-5),G1(:,:,:,254))
  call loop_Q_A(G1(:,:,:,254),Q(:,59),MT,G2(:,:,:,585))
  call loop_QS_A(G2(:,:,:,585),wf(:,-2),G2(:,:,:,586),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,586),Q(:,63),MT,G3tensor(:,225))
  call loop_QV_A(G0(:,:,:,1),wf(:,90),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,27),MT,G1(:,:,:,255))
  call loop_QV_A(G1(:,:,:,255),wf(:,-5),G1(:,:,:,256))
  call loop_Q_A(G1(:,:,:,256),Q(:,59),MT,G2(:,:,:,587))
  call loop_QS_A(G2(:,:,:,587),wf(:,-2),G2(:,:,:,588),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,588),Q(:,63),MT,G3tensor(:,226))
  call loop_QV_A(G0(:,:,:,1),wf(:,91),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,27),MT,G1(:,:,:,257))
  call loop_QV_A(G1(:,:,:,257),wf(:,-5),G1(:,:,:,258))
  call loop_Q_A(G1(:,:,:,258),Q(:,59),MT,G2(:,:,:,589))
  call loop_QS_A(G2(:,:,:,589),wf(:,-2),G2(:,:,:,590),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,590),Q(:,63),MT,G3tensor(:,227))
  call loop_AV_Q(G0(:,:,:,1),wf(:,89),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,27),MT,G1(:,:,:,259))
  call loop_AV_Q(G1(:,:,:,259),wf(:,-5),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,59),MT,G2(:,:,:,591))
  call loop_AS_Q(G2(:,:,:,591),wf(:,-2),G2(:,:,:,592),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,592),Q(:,63),MT,G3tensor(:,228))
  call loop_AV_Q(G0(:,:,:,1),wf(:,90),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,27),MT,G1(:,:,:,261))
  call loop_AV_Q(G1(:,:,:,261),wf(:,-5),G1(:,:,:,262))
  call loop_A_Q(G1(:,:,:,262),Q(:,59),MT,G2(:,:,:,593))
  call loop_AS_Q(G2(:,:,:,593),wf(:,-2),G2(:,:,:,594),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,594),Q(:,63),MT,G3tensor(:,229))
  call loop_AV_Q(G0(:,:,:,1),wf(:,91),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,27),MT,G1(:,:,:,263))
  call loop_AV_Q(G1(:,:,:,263),wf(:,-5),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,59),MT,G2(:,:,:,595))
  call loop_AS_Q(G2(:,:,:,595),wf(:,-2),G2(:,:,:,596),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,596),Q(:,63),MT,G3tensor(:,230))
  call loop_QV_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,27),MB,G1(:,:,:,265))
  call loop_QV_A(G1(:,:,:,265),wf(:,-5),G1(:,:,:,266))
  call loop_Q_A(G1(:,:,:,266),Q(:,59),MB,G2(:,:,:,597))
  call loop_QS_A(G2(:,:,:,597),wf(:,-2),G2(:,:,:,598),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,598),Q(:,63),MB,G3tensor(:,231))
  call loop_QV_A(G0(:,:,:,1),wf(:,90),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,27),MB,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,-5),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,59),MB,G2(:,:,:,599))
  call loop_QS_A(G2(:,:,:,599),wf(:,-2),G2(:,:,:,600),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,600),Q(:,63),MB,G3tensor(:,232))
  call loop_QV_A(G0(:,:,:,1),wf(:,91),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,27),MB,G1(:,:,:,269))
  call loop_QV_A(G1(:,:,:,269),wf(:,-5),G1(:,:,:,270))
  call loop_Q_A(G1(:,:,:,270),Q(:,59),MB,G2(:,:,:,601))
  call loop_QS_A(G2(:,:,:,601),wf(:,-2),G2(:,:,:,602),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,602),Q(:,63),MB,G3tensor(:,233))
  call loop_AV_Q(G0(:,:,:,1),wf(:,89),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,27),MB,G1(:,:,:,271))
  call loop_AV_Q(G1(:,:,:,271),wf(:,-5),G1(:,:,:,272))
  call loop_A_Q(G1(:,:,:,272),Q(:,59),MB,G2(:,:,:,603))
  call loop_AS_Q(G2(:,:,:,603),wf(:,-2),G2(:,:,:,604),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,604),Q(:,63),MB,G3tensor(:,234))
  call loop_AV_Q(G0(:,:,:,1),wf(:,90),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,27),MB,G1(:,:,:,273))
  call loop_AV_Q(G1(:,:,:,273),wf(:,-5),G1(:,:,:,274))
  call loop_A_Q(G1(:,:,:,274),Q(:,59),MB,G2(:,:,:,605))
  call loop_AS_Q(G2(:,:,:,605),wf(:,-2),G2(:,:,:,606),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,606),Q(:,63),MB,G3tensor(:,235))
  call loop_AV_Q(G0(:,:,:,1),wf(:,91),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,27),MB,G1(:,:,:,275))
  call loop_AV_Q(G1(:,:,:,275),wf(:,-5),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,59),MB,G2(:,:,:,607))
  call loop_AS_Q(G2(:,:,:,607),wf(:,-2),G2(:,:,:,608),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,608),Q(:,63),MB,G3tensor(:,236))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,22),gH)
  call loop_Q_A(G0(:,:,:,22),Q(:,4),MT,G1(:,:,:,277))
  call loop_QV_A(G1(:,:,:,277),wf(:,2),G1(:,:,:,278))
  call loop_Q_A(G1(:,:,:,278),Q(:,60),MT,G2(:,:,:,609))
  call loop_QV_A(G2(:,:,:,609),wf(:,86),G2(:,:,:,610))
  call check_last_Q_A(l_switch,G2(:,:,:,610),Q(:,63),MT,G3tensor(:,237))
  call loop_QV_A(G1(:,:,:,277),wf(:,5),G1(:,:,:,279))
  call loop_Q_A(G1(:,:,:,279),Q(:,60),MT,G2(:,:,:,611))
  call loop_QV_A(G2(:,:,:,611),wf(:,86),G2(:,:,:,612))
  call check_last_Q_A(l_switch,G2(:,:,:,612),Q(:,63),MT,G3tensor(:,238))
  call loop_QV_A(G1(:,:,:,277),wf(:,6),G1(:,:,:,280))
  call loop_Q_A(G1(:,:,:,280),Q(:,60),MT,G2(:,:,:,613))
  call loop_QV_A(G2(:,:,:,613),wf(:,86),G2(:,:,:,614))
  call check_last_Q_A(l_switch,G2(:,:,:,614),Q(:,63),MT,G3tensor(:,239))
  call loop_QV_A(G1(:,:,:,277),wf(:,33),G1(:,:,:,281))
  call loop_Q_A(G1(:,:,:,281),Q(:,60),MT,G2(:,:,:,615))
  call loop_QV_A(G2(:,:,:,615),wf(:,86),G2(:,:,:,616))
  call check_last_Q_A(l_switch,G2(:,:,:,616),Q(:,63),MT,G3tensor(:,240))
  call loop_QV_A(G1(:,:,:,277),wf(:,-5),G1(:,:,:,282))
  call loop_Q_A(G1(:,:,:,282),Q(:,36),MT,G2(:,:,:,617))
  call loop_QV_A(G2(:,:,:,617),wf(:,30),G2(:,:,:,618))
  call loop_Q_A(G2(:,:,:,618),Q(:,60),MT,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,86),G3(:,:,:,246))
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,63),MT,G4tensor(:,105))
  call loop_QV_A(G2(:,:,:,617),wf(:,-3),G2(:,:,:,619))
  call loop_Q_A(G2(:,:,:,619),Q(:,44),MT,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-4),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,60),MT,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,86),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,25))
  call loop_QV_A(G2(:,:,:,617),wf(:,-4),G2(:,:,:,620))
  call loop_Q_A(G2(:,:,:,620),Q(:,52),MT,G3(:,:,:,249))
  call loop_QV_A(G3(:,:,:,249),wf(:,-3),G3(:,:,:,250))
  call loop_Q_A(G3(:,:,:,250),Q(:,60),MT,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,86),G4(:,:,:,52))
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,277),wf(:,30),G1(:,:,:,283))
  call loop_Q_A(G1(:,:,:,283),Q(:,28),MT,G2(:,:,:,621))
  call loop_QV_A(G2(:,:,:,621),wf(:,-5),G2(:,:,:,622))
  call loop_Q_A(G2(:,:,:,622),Q(:,60),MT,G3(:,:,:,251))
  call loop_QV_A(G3(:,:,:,251),wf(:,86),G3(:,:,:,252))
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,63),MT,G4tensor(:,106))
  call loop_QV_A(G1(:,:,:,277),wf(:,39),G1(:,:,:,284))
  call loop_Q_A(G1(:,:,:,284),Q(:,60),MT,G2(:,:,:,623))
  call loop_QV_A(G2(:,:,:,623),wf(:,86),G2(:,:,:,624))
  call check_last_Q_A(l_switch,G2(:,:,:,624),Q(:,63),MT,G3tensor(:,241))
  call loop_QV_A(G1(:,:,:,277),wf(:,-4),G1(:,:,:,285))
  call loop_Q_A(G1(:,:,:,285),Q(:,20),MT,G2(:,:,:,625))
  call loop_QV_A(G2(:,:,:,625),wf(:,21),G2(:,:,:,626))
  call loop_Q_A(G2(:,:,:,626),Q(:,60),MT,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,86),G3(:,:,:,254))
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,63),MT,G4tensor(:,107))
  call loop_QV_A(G2(:,:,:,625),wf(:,-3),G2(:,:,:,627))
  call loop_Q_A(G2(:,:,:,627),Q(:,28),MT,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-5),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,60),MT,G4(:,:,:,53))
  call loop_QV_A(G4(:,:,:,53),wf(:,86),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,625),wf(:,-5),G2(:,:,:,628))
  call loop_Q_A(G2(:,:,:,628),Q(:,52),MT,G3(:,:,:,257))
  call loop_QV_A(G3(:,:,:,257),wf(:,-3),G3(:,:,:,258))
  call loop_Q_A(G3(:,:,:,258),Q(:,60),MT,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,86),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,277),wf(:,21),G1(:,:,:,286))
  call loop_Q_A(G1(:,:,:,286),Q(:,44),MT,G2(:,:,:,629))
  call loop_QV_A(G2(:,:,:,629),wf(:,-4),G2(:,:,:,630))
  call loop_Q_A(G2(:,:,:,630),Q(:,60),MT,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,86),G3(:,:,:,260))
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,63),MT,G4tensor(:,108))
  call loop_QV_A(G1(:,:,:,277),wf(:,42),G1(:,:,:,287))
  call loop_Q_A(G1(:,:,:,287),Q(:,60),MT,G2(:,:,:,631))
  call loop_QV_A(G2(:,:,:,631),wf(:,86),G2(:,:,:,632))
  call check_last_Q_A(l_switch,G2(:,:,:,632),Q(:,63),MT,G3tensor(:,242))
  call loop_QV_A(G1(:,:,:,277),wf(:,-3),G1(:,:,:,288))
  call loop_Q_A(G1(:,:,:,288),Q(:,12),MT,G2(:,:,:,633))
  call loop_QV_A(G2(:,:,:,633),wf(:,11),G2(:,:,:,634))
  call loop_Q_A(G2(:,:,:,634),Q(:,60),MT,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,86),G3(:,:,:,262))
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,63),MT,G4tensor(:,109))
  call loop_QV_A(G2(:,:,:,633),wf(:,-4),G2(:,:,:,635))
  call loop_Q_A(G2(:,:,:,635),Q(:,28),MT,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,60),MT,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,86),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MT,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,633),wf(:,-5),G2(:,:,:,636))
  call loop_Q_A(G2(:,:,:,636),Q(:,44),MT,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-4),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,60),MT,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,86),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MT,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,277),wf(:,11),G1(:,:,:,289))
  call loop_Q_A(G1(:,:,:,289),Q(:,52),MT,G2(:,:,:,637))
  call loop_QV_A(G2(:,:,:,637),wf(:,-3),G2(:,:,:,638))
  call loop_Q_A(G2(:,:,:,638),Q(:,60),MT,G3(:,:,:,267))
  call loop_QV_A(G3(:,:,:,267),wf(:,86),G3(:,:,:,268))
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,63),MT,G4tensor(:,110))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,1),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,1),T3sum(1:35,1))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,2),T3sum(1:35,1))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,3),T3sum(1:35,1))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,3),T3sum(1:35,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,3),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,21),T3sum(1:35,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,21),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,21),T3sum(1:35,1))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,22),T3sum(1:35,1))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,22),T3sum(1:35,1))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,23),T3sum(1:35,1))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,23),T3sum(1:35,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,23),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,41),T3sum(1:35,2))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,41),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,41),T3sum(1:35,2))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,42),T3sum(1:35,2))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,42),T3sum(1:35,2))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,42),T3sum(1:35,2))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,43),T3sum(1:35,2))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,43),T3sum(1:35,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,43),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,43),T3sum(1:35,2))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,61),T3sum(1:35,2))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,61),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,61),T3sum(1:35,2))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,61),T3sum(1:35,2))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,62),T3sum(1:35,2))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,62),T3sum(1:35,2))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,62),T3sum(1:35,2))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,62),T3sum(1:35,2))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,63),T3sum(1:35,2))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,63),T3sum(1:35,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,63),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(456)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,63),T3sum(1:35,2))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,81),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,81),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,81),T3sum(1:35,3))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,81),T3sum(1:35,3))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,82),T3sum(1:35,3))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,82),T3sum(1:35,3))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,82),T3sum(1:35,3))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,83),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,83),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,83),T3sum(1:35,3))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,117),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,117),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,117),T3sum(1:35,3))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,117),T3sum(1:35,3))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,118),T3sum(1:35,3))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,118),T3sum(1:35,3))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,118),T3sum(1:35,3))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,118),T3sum(1:35,3))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,119),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,119),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,119),T3sum(1:35,3))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,119),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,153),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,153),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,153),T3sum(1:35,4))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,153),T3sum(1:35,4))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,154),T3sum(1:35,4))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,154),T3sum(1:35,4))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,154),T3sum(1:35,4))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,154),T3sum(1:35,4))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,155),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,155),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,155),T3sum(1:35,4))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,155),T3sum(1:35,4))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,189),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,189),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,189),T3sum(1:35,4))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,189),T3sum(1:35,4))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,190),T3sum(1:35,4))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,190),T3sum(1:35,4))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,190),T3sum(1:35,4))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,190),T3sum(1:35,4))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,191),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,191),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,191),T3sum(1:35,4))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(458)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,191),T3sum(1:35,4))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,225),T3sum(1:35,5))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,225),T3sum(1:35,5))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,225),T3sum(1:35,5))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,225),T3sum(1:35,5))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,226),T3sum(1:35,5))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,226),T3sum(1:35,5))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,226),T3sum(1:35,5))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,226),T3sum(1:35,5))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,227),T3sum(1:35,5))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,227),T3sum(1:35,5))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,227),T3sum(1:35,5))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,227),T3sum(1:35,5))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,228),T3sum(1:35,5))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,228),T3sum(1:35,5))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,228),T3sum(1:35,5))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,228),T3sum(1:35,5))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,229),T3sum(1:35,5))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,229),T3sum(1:35,5))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,229),T3sum(1:35,5))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,229),T3sum(1:35,5))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,230),T3sum(1:35,5))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,230),T3sum(1:35,5))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,230),T3sum(1:35,5))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,230),T3sum(1:35,5))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,231),T3sum(1:35,6))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,231),T3sum(1:35,6))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,231),T3sum(1:35,6))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,231),T3sum(1:35,6))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,232),T3sum(1:35,6))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,232),T3sum(1:35,6))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,232),T3sum(1:35,6))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,232),T3sum(1:35,6))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,233),T3sum(1:35,6))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,233),T3sum(1:35,6))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,233),T3sum(1:35,6))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,233),T3sum(1:35,6))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,234),T3sum(1:35,6))
  M(2) = M(2) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,234),T3sum(1:35,6))
  M(4) = M(4) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,234),T3sum(1:35,6))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,234),T3sum(1:35,6))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,235),T3sum(1:35,6))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,235),T3sum(1:35,6))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,235),T3sum(1:35,6))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,235),T3sum(1:35,6))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,236),T3sum(1:35,6))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,236),T3sum(1:35,6))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,236),T3sum(1:35,6))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(460)) * TI2_call(3,momenta_70,masses2_5,G3tensor(:,236),T3sum(1:35,6))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,237),T3sum(1:35,7))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,237),T3sum(1:35,7))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,237),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,237),T3sum(1:35,7))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,238),T3sum(1:35,7))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,238),T3sum(1:35,7))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,238),T3sum(1:35,7))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,238),T3sum(1:35,7))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,239),T3sum(1:35,7))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,239),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,239),T3sum(1:35,7))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(107)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,239),T3sum(1:35,7))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,240),T3sum(1:35,7))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,240),T3sum(1:35,7))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,240),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(118)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,240),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,105),T4sum(1:70,13))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,105),T4sum(1:70,13))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,105),T4sum(1:70,13))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_124,masses2_14,G4tensor(:,105),T4sum(1:70,13))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,106),T4sum(1:70,17))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,106),T4sum(1:70,17))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,106),T4sum(1:70,17))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(461)) * TI2_call(4,momenta_123,masses2_14,G4tensor(:,106),T4sum(1:70,17))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,241),T3sum(1:35,7))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,241),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,241),T3sum(1:35,7))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(124)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,241),T3sum(1:35,7))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,84),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,84),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,84),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,84),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,120),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,120),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,120),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,120),T3sum(1:35,3))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,156),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,156),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,156),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,156),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,192),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,192),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,192),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(464)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,192),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,107),T4sum(1:70,19))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,107),T4sum(1:70,19))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,107),T4sum(1:70,19))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_122,masses2_14,G4tensor(:,107),T4sum(1:70,19))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,78),T4sum(1:70,21))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,78),T4sum(1:70,21))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,78),T4sum(1:70,21))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,78),T4sum(1:70,21))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,69),T4sum(1:70,21))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,69),T4sum(1:70,21))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,69),T4sum(1:70,21))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_14,G4tensor(:,69),T4sum(1:70,21))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,96),T4sum(1:70,22))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,96),T4sum(1:70,22))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,96),T4sum(1:70,22))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,96),T4sum(1:70,22))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,87),T4sum(1:70,22))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,87),T4sum(1:70,22))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,87),T4sum(1:70,22))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_182,masses2_11,G4tensor(:,87),T4sum(1:70,22))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,108),T4sum(1:70,23))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,108),T4sum(1:70,23))
  M(10) = M(10) + ((CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,108),T4sum(1:70,23))
  M(11) = M(11) + (-(CI*f(25))/6._/**/REALKIND * den(463)) * TI2_call(4,momenta_125,masses2_14,G4tensor(:,108),T4sum(1:70,23))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,242),T3sum(1:35,7))
  M(2) = M(2) + (f(26)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,242),T3sum(1:35,7))
  M(4) = M(4) + (f(26)/2._/**/REALKIND * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,242),T3sum(1:35,7))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(129)) * TI2_call(3,momenta_22,masses2_8,G3tensor(:,242),T3sum(1:35,7))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,4),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,4),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,24),T3sum(1:35,1))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,24),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,24),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,44),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,44),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,64),T3sum(1:35,2))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,64),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,64),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(466)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,64),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,109),T4sum(1:70,25))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,109),T4sum(1:70,25))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,109),T4sum(1:70,25))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_121,masses2_14,G4tensor(:,109),T4sum(1:70,25))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,18),T4sum(1:70,27))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,18),T4sum(1:70,27))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,18),T4sum(1:70,27))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,18),T4sum(1:70,27))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,1),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,1),T4sum(1:70,27))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,1),T4sum(1:70,27))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_14,G4tensor(:,1),T4sum(1:70,27))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,52),T4sum(1:70,28))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,52),T4sum(1:70,28))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,52),T4sum(1:70,28))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,52),T4sum(1:70,28))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,35),T4sum(1:70,28))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,35),T4sum(1:70,28))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,35),T4sum(1:70,28))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_139,masses2_11,G4tensor(:,35),T4sum(1:70,28))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,110),T4sum(1:70,29))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,110),T4sum(1:70,29))
  M(10) = M(10) + (-(CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,110),T4sum(1:70,29))
  M(11) = M(11) + ((CI*f(25))/6._/**/REALKIND * den(465)) * TI2_call(4,momenta_126,masses2_14,G4tensor(:,110),T4sum(1:70,29))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,85),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,85),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,85),T3sum(1:35,3))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,121),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,121),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,121),T3sum(1:35,3))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,121),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,157),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,157),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,157),T3sum(1:35,4))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,157),T3sum(1:35,4))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,193),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,193),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,193),T3sum(1:35,4))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(468)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,193),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,70),T4sum(1:70,31))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,70),T4sum(1:70,31))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,79),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,79),T4sum(1:70,31))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,88),T4sum(1:70,32))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,88),T4sum(1:70,32))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,97),T4sum(1:70,32))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(126)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,97),T4sum(1:70,32))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,5),T3sum(1:35,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,5),T3sum(1:35,1))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,25),T3sum(1:35,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,25),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,25),T3sum(1:35,1))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,25),T3sum(1:35,1))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,45),T3sum(1:35,2))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,45),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,45),T3sum(1:35,2))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,45),T3sum(1:35,2))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,65),T3sum(1:35,2))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,65),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,65),T3sum(1:35,2))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(470)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,65),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,2),T4sum(1:70,37))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,2),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,19),T4sum(1:70,37))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,19),T4sum(1:70,37))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,36),T4sum(1:70,38))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,36),T4sum(1:70,38))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,53),T4sum(1:70,38))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,53),T4sum(1:70,38))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,3),T4sum(1:70,39))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,3),T4sum(1:70,39))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,20),T4sum(1:70,39))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,20),T4sum(1:70,39))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,37),T4sum(1:70,40))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,37),T4sum(1:70,40))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,54),T4sum(1:70,40))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(121)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,54),T4sum(1:70,40))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,86),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,86),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,86),T3sum(1:35,3))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,86),T3sum(1:35,3))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,122),T3sum(1:35,3))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,122),T3sum(1:35,3))
  M(5) = M(5) + (f(26)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,122),T3sum(1:35,3))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,122),T3sum(1:35,3))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,158),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,158),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,158),T3sum(1:35,4))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,158),T3sum(1:35,4))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,194),T3sum(1:35,4))
  M(3) = M(3) + (f(21)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,194),T3sum(1:35,4))
  M(5) = M(5) + (f(21)/2._/**/REALKIND * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,194),T3sum(1:35,4))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(471)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,194),T3sum(1:35,4))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,6),T3sum(1:35,1))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,6),T3sum(1:35,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,6),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,26),T3sum(1:35,1))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,26),T3sum(1:35,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,26),T3sum(1:35,1))
  M(6) = M(6) + (f(26)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,46),T3sum(1:35,2))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,46),T3sum(1:35,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,46),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,66),T3sum(1:35,2))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,66),T3sum(1:35,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,66),T3sum(1:35,2))
  M(6) = M(6) + (f(21)/2._/**/REALKIND * den(472)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,66),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,8),T4sum(1:70,43))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,8),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,25),T4sum(1:70,43))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,25),T4sum(1:70,43))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,42),T4sum(1:70,44))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,42),T4sum(1:70,44))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,59),T4sum(1:70,44))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,59),T4sum(1:70,44))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,9),T4sum(1:70,45))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,9),T4sum(1:70,45))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,26),T4sum(1:70,45))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,26),T4sum(1:70,45))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,43),T4sum(1:70,46))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,43),T4sum(1:70,46))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,60),T4sum(1:70,46))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,60),T4sum(1:70,46))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,71),T4sum(1:70,47))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,71),T4sum(1:70,47))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,80),T4sum(1:70,47))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,80),T4sum(1:70,47))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,89),T4sum(1:70,48))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,89),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,98),T4sum(1:70,48))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(115)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,98),T4sum(1:70,48))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_386,masses2_20,G5tensor(:,17),T5sum(1:126,1))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_386,masses2_20,G5tensor(:,17),T5sum(1:126,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_386,masses2_20,G5tensor(:,19),T5sum(1:126,1))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_386,masses2_20,G5tensor(:,19),T5sum(1:126,1))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_386,masses2_18,G5tensor(:,21),T5sum(1:126,2))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_386,masses2_18,G5tensor(:,21),T5sum(1:126,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_386,masses2_18,G5tensor(:,23),T5sum(1:126,2))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_386,masses2_18,G5tensor(:,23),T5sum(1:126,2))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_343,masses2_20,G5tensor(:,5),T5sum(1:126,3))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_343,masses2_20,G5tensor(:,5),T5sum(1:126,3))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_343,masses2_20,G5tensor(:,1),T5sum(1:126,3))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_343,masses2_20,G5tensor(:,1),T5sum(1:126,3))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_343,masses2_18,G5tensor(:,13),T5sum(1:126,4))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_343,masses2_18,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_343,masses2_18,G5tensor(:,9),T5sum(1:126,4))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_343,masses2_18,G5tensor(:,9),T5sum(1:126,4))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_391,masses2_20,G5tensor(:,20),T5sum(1:126,5))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_391,masses2_20,G5tensor(:,20),T5sum(1:126,5))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_391,masses2_20,G5tensor(:,18),T5sum(1:126,5))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_391,masses2_20,G5tensor(:,18),T5sum(1:126,5))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_391,masses2_18,G5tensor(:,24),T5sum(1:126,6))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_391,masses2_18,G5tensor(:,24),T5sum(1:126,6))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_391,masses2_18,G5tensor(:,22),T5sum(1:126,6))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_391,masses2_18,G5tensor(:,22),T5sum(1:126,6))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_344,masses2_20,G5tensor(:,6),T5sum(1:126,7))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_344,masses2_20,G5tensor(:,6),T5sum(1:126,7))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_344,masses2_20,G5tensor(:,2),T5sum(1:126,7))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_344,masses2_20,G5tensor(:,2),T5sum(1:126,7))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_344,masses2_18,G5tensor(:,14),T5sum(1:126,8))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_344,masses2_18,G5tensor(:,14),T5sum(1:126,8))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_344,masses2_18,G5tensor(:,10),T5sum(1:126,8))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_344,masses2_18,G5tensor(:,10),T5sum(1:126,8))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_323,masses2_20,G5tensor(:,29),T5sum(1:126,9))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_323,masses2_20,G5tensor(:,29),T5sum(1:126,9))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_324,masses2_20,G5tensor(:,30),T5sum(1:126,11))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_324,masses2_20,G5tensor(:,30),T5sum(1:126,11))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_349,masses2_20,G5tensor(:,8),T5sum(1:126,13))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_349,masses2_20,G5tensor(:,8),T5sum(1:126,13))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_349,masses2_20,G5tensor(:,4),T5sum(1:126,13))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_349,masses2_20,G5tensor(:,4),T5sum(1:126,13))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_349,masses2_18,G5tensor(:,16),T5sum(1:126,14))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_349,masses2_18,G5tensor(:,16),T5sum(1:126,14))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_349,masses2_18,G5tensor(:,12),T5sum(1:126,14))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_349,masses2_18,G5tensor(:,12),T5sum(1:126,14))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_360,masses2_20,G5tensor(:,3),T5sum(1:126,15))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_360,masses2_20,G5tensor(:,3),T5sum(1:126,15))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_360,masses2_20,G5tensor(:,7),T5sum(1:126,15))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_360,masses2_20,G5tensor(:,7),T5sum(1:126,15))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_360,masses2_18,G5tensor(:,11),T5sum(1:126,16))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_360,masses2_18,G5tensor(:,11),T5sum(1:126,16))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_360,masses2_18,G5tensor(:,15),T5sum(1:126,16))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_360,masses2_18,G5tensor(:,15),T5sum(1:126,16))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_325,masses2_20,G5tensor(:,27),T5sum(1:126,17))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_325,masses2_20,G5tensor(:,27),T5sum(1:126,17))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_326,masses2_20,G5tensor(:,28),T5sum(1:126,19))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_326,masses2_20,G5tensor(:,28),T5sum(1:126,19))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_327,masses2_20,G5tensor(:,25),T5sum(1:126,21))
  M(11) = M(11) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_327,masses2_20,G5tensor(:,25),T5sum(1:126,21))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(106)) * TI2_call(5,momenta_328,masses2_20,G5tensor(:,26),T5sum(1:126,23))
  M(10) = M(10) + (f(26)/6._/**/REALKIND * den(106)) * TI2_call(5,momenta_328,masses2_20,G5tensor(:,26),T5sum(1:126,23))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,87),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,87),T3sum(1:35,48))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,123),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,123),T3sum(1:35,48))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,159),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,159),T3sum(1:35,49))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,195),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,195),T3sum(1:35,49))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,95),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,95),T3sum(1:35,69))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,131),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,131),T3sum(1:35,69))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,167),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,167),T3sum(1:35,70))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,203),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,203),T3sum(1:35,70))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,132),T3sum(1:35,77))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,132),T3sum(1:35,77))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,132),T3sum(1:35,77))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,132),T3sum(1:35,77))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,96),T3sum(1:35,77))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,96),T3sum(1:35,77))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,96),T3sum(1:35,77))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,96),T3sum(1:35,77))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,204),T3sum(1:35,78))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,204),T3sum(1:35,78))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,204),T3sum(1:35,78))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,204),T3sum(1:35,78))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,168),T3sum(1:35,78))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,168),T3sum(1:35,78))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,168),T3sum(1:35,78))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,168),T3sum(1:35,78))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,27),T3sum(1:35,82))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,27),T3sum(1:35,82))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,27),T3sum(1:35,82))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,27),T3sum(1:35,82))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,7),T3sum(1:35,82))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,7),T3sum(1:35,82))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,7),T3sum(1:35,82))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,7),T3sum(1:35,82))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,67),T3sum(1:35,83))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,67),T3sum(1:35,83))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,67),T3sum(1:35,83))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,67),T3sum(1:35,83))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,47),T3sum(1:35,83))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,47),T3sum(1:35,83))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,47),T3sum(1:35,83))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,47),T3sum(1:35,83))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,88),T3sum(1:35,48))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,88),T3sum(1:35,48))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,124),T3sum(1:35,48))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,124),T3sum(1:35,48))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,160),T3sum(1:35,49))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,160),T3sum(1:35,49))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,196),T3sum(1:35,49))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,196),T3sum(1:35,49))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,98),T3sum(1:35,69))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,98),T3sum(1:35,69))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,134),T3sum(1:35,69))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,134),T3sum(1:35,69))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,170),T3sum(1:35,70))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,170),T3sum(1:35,70))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,206),T3sum(1:35,70))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,206),T3sum(1:35,70))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,81),T4sum(1:70,50))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,81),T4sum(1:70,50))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,72),T4sum(1:70,50))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,72),T4sum(1:70,50))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,99),T4sum(1:70,51))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,99),T4sum(1:70,51))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,90),T4sum(1:70,51))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,90),T4sum(1:70,51))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,10),T4sum(1:70,53))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,10),T4sum(1:70,53))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,27),T4sum(1:70,53))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,27),T4sum(1:70,53))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,44),T4sum(1:70,54))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,44),T4sum(1:70,54))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,61),T4sum(1:70,54))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,61),T4sum(1:70,54))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,4),T4sum(1:70,56))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,4),T4sum(1:70,56))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,21),T4sum(1:70,56))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,21),T4sum(1:70,56))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,38),T4sum(1:70,57))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,38),T4sum(1:70,57))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,55),T4sum(1:70,57))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,55),T4sum(1:70,57))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,89),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,89),T3sum(1:35,48))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,125),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,125),T3sum(1:35,48))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,161),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,161),T3sum(1:35,49))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,197),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,197),T3sum(1:35,49))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,99),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,99),T3sum(1:35,69))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,135),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,135),T3sum(1:35,69))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,171),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,171),T3sum(1:35,70))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,207),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,207),T3sum(1:35,70))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,90),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,90),T3sum(1:35,48))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,126),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,126),T3sum(1:35,48))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,162),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,162),T3sum(1:35,49))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,198),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,198),T3sum(1:35,49))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,100),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,100),T3sum(1:35,69))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,136),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,136),T3sum(1:35,69))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,172),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,172),T3sum(1:35,70))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,208),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,208),T3sum(1:35,70))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,133),T3sum(1:35,77))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,133),T3sum(1:35,77))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,133),T3sum(1:35,77))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,133),T3sum(1:35,77))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,97),T3sum(1:35,77))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,97),T3sum(1:35,77))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,97),T3sum(1:35,77))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_8,G3tensor(:,97),T3sum(1:35,77))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,205),T3sum(1:35,78))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,205),T3sum(1:35,78))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,205),T3sum(1:35,78))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,205),T3sum(1:35,78))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,169),T3sum(1:35,78))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,169),T3sum(1:35,78))
  M(10) = M(10) + ((CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,169),T3sum(1:35,78))
  M(11) = M(11) + (-(CI*f(19))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_5,G3tensor(:,169),T3sum(1:35,78))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,28),T3sum(1:35,82))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,28),T3sum(1:35,82))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,28),T3sum(1:35,82))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,28),T3sum(1:35,82))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,8),T3sum(1:35,82))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,8),T3sum(1:35,82))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,8),T3sum(1:35,82))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_8,G3tensor(:,8),T3sum(1:35,82))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,68),T3sum(1:35,83))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,68),T3sum(1:35,83))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,68),T3sum(1:35,83))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,68),T3sum(1:35,83))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,48),T3sum(1:35,83))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,48),T3sum(1:35,83))
  M(10) = M(10) + (-(CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,48),T3sum(1:35,83))
  M(11) = M(11) + ((CI*f(19))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_5,G3tensor(:,48),T3sum(1:35,83))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,91),T3sum(1:35,48))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,91),T3sum(1:35,48))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,127),T3sum(1:35,48))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,127),T3sum(1:35,48))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,163),T3sum(1:35,49))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,163),T3sum(1:35,49))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,199),T3sum(1:35,49))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,199),T3sum(1:35,49))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,101),T3sum(1:35,69))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,101),T3sum(1:35,69))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,137),T3sum(1:35,69))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,137),T3sum(1:35,69))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,173),T3sum(1:35,70))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,173),T3sum(1:35,70))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,209),T3sum(1:35,70))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,209),T3sum(1:35,70))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,82),T4sum(1:70,50))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,82),T4sum(1:70,50))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,73),T4sum(1:70,50))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_14,G4tensor(:,73),T4sum(1:70,50))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,100),T4sum(1:70,51))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,100),T4sum(1:70,51))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,91),T4sum(1:70,51))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_11,G4tensor(:,91),T4sum(1:70,51))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,11),T4sum(1:70,53))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,11),T4sum(1:70,53))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,28),T4sum(1:70,53))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_14,G4tensor(:,28),T4sum(1:70,53))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,45),T4sum(1:70,54))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,45),T4sum(1:70,54))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,62),T4sum(1:70,54))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_11,G4tensor(:,62),T4sum(1:70,54))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,5),T4sum(1:70,56))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,5),T4sum(1:70,56))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,22),T4sum(1:70,56))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_14,G4tensor(:,22),T4sum(1:70,56))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,39),T4sum(1:70,57))
  M(11) = M(11) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,39),T4sum(1:70,57))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,56),T4sum(1:70,57))
  M(10) = M(10) + (f(21)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_11,G4tensor(:,56),T4sum(1:70,57))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,92),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,92),T3sum(1:35,48))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,128),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,128),T3sum(1:35,48))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,164),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,164),T3sum(1:35,49))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,200),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,200),T3sum(1:35,49))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,102),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,102),T3sum(1:35,69))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,138),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,138),T3sum(1:35,69))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,174),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,174),T3sum(1:35,70))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,210),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,210),T3sum(1:35,70))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(498)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,103),T3sum(1:35,3))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(498)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,139),T3sum(1:35,3))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(498)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,175),T3sum(1:35,4))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(498)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,211),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,104),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,104),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,140),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,140),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,176),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,176),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,212),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(500)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,212),T3sum(1:35,4))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(177)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,76),T4sum(1:70,31))
  M(9) = M(9) + (f(26)/6._/**/REALKIND * den(177)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,76),T4sum(1:70,31))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(177)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,85),T4sum(1:70,31))
  M(9) = M(9) + (f(26)/6._/**/REALKIND * den(177)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,85),T4sum(1:70,31))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(177)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,94),T4sum(1:70,32))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(177)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,94),T4sum(1:70,32))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(177)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,103),T4sum(1:70,32))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(177)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,103),T4sum(1:70,32))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,93),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,93),T3sum(1:35,48))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,129),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,129),T3sum(1:35,48))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,165),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,165),T3sum(1:35,49))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,201),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,201),T3sum(1:35,49))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(507)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,105),T3sum(1:35,3))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(507)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,141),T3sum(1:35,3))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(507)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,177),T3sum(1:35,4))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(507)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,213),T3sum(1:35,4))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(511)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,106),T3sum(1:35,3))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(511)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,142),T3sum(1:35,3))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(511)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,178),T3sum(1:35,4))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(511)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,214),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,107),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,107),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,143),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,143),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,179),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,179),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,215),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(513)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,215),T3sum(1:35,4))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(193)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,77),T4sum(1:70,31))
  M(9) = M(9) + (f(26)/6._/**/REALKIND * den(193)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,77),T4sum(1:70,31))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(193)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,86),T4sum(1:70,31))
  M(9) = M(9) + (f(26)/6._/**/REALKIND * den(193)) * TI2_call(4,momenta_193,masses2_14,G4tensor(:,86),T4sum(1:70,31))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(193)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,95),T4sum(1:70,32))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(193)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,95),T4sum(1:70,32))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(193)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,104),T4sum(1:70,32))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(193)) * TI2_call(4,momenta_193,masses2_11,G4tensor(:,104),T4sum(1:70,32))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,94),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,94),T3sum(1:35,48))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,130),T3sum(1:35,48))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_8,G3tensor(:,130),T3sum(1:35,48))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,166),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,166),T3sum(1:35,49))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,202),T3sum(1:35,49))
  M(9) = M(9) + (f(21)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_5,G3tensor(:,202),T3sum(1:35,49))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(516)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,108),T3sum(1:35,3))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(516)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,144),T3sum(1:35,3))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(516)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,180),T3sum(1:35,4))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(516)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,216),T3sum(1:35,4))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(523)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,9),T3sum(1:35,1))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(523)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,29),T3sum(1:35,1))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(523)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,49),T3sum(1:35,2))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(523)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,69),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,10),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,30),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,30),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,50),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,50),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,70),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(525)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,70),T3sum(1:35,2))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,14),T4sum(1:70,37))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,14),T4sum(1:70,37))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,31),T4sum(1:70,37))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,31),T4sum(1:70,37))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,48),T4sum(1:70,38))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,48),T4sum(1:70,38))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,65),T4sum(1:70,38))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,65),T4sum(1:70,38))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,6),T4sum(1:70,39))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,6),T4sum(1:70,39))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,23),T4sum(1:70,39))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,23),T4sum(1:70,39))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,40),T4sum(1:70,40))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,40),T4sum(1:70,40))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(205)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,57),T4sum(1:70,40))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(205)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,57),T4sum(1:70,40))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(532)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(f(26)/2._/**/REALKIND) * den(532)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,31),T3sum(1:35,1))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(532)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,51),T3sum(1:35,2))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(532)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,71),T3sum(1:35,2))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(535)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,12),T3sum(1:35,1))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(535)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,32),T3sum(1:35,1))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(535)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,52),T3sum(1:35,2))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(535)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,72),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,13),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,13),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,33),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,33),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,53),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,53),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,73),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(537)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,73),T3sum(1:35,2))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,15),T4sum(1:70,37))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,15),T4sum(1:70,37))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,32),T4sum(1:70,37))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_150,masses2_14,G4tensor(:,32),T4sum(1:70,37))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,49),T4sum(1:70,38))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,49),T4sum(1:70,38))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,66),T4sum(1:70,38))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_150,masses2_11,G4tensor(:,66),T4sum(1:70,38))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,7),T4sum(1:70,39))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,7),T4sum(1:70,39))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,24),T4sum(1:70,39))
  M(8) = M(8) + (f(26)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_156,masses2_14,G4tensor(:,24),T4sum(1:70,39))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,41),T4sum(1:70,40))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,41),T4sum(1:70,40))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(211)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,58),T4sum(1:70,40))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(211)) * TI2_call(4,momenta_156,masses2_11,G4tensor(:,58),T4sum(1:70,40))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(540)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,14),T3sum(1:35,1))
  M(4) = M(4) + (-(f(26)/2._/**/REALKIND) * den(540)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,34),T3sum(1:35,1))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(540)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,54),T3sum(1:35,2))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(540)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,74),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,109),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,109),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(25))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,145),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,145),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,181),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,181),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(19))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,217),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(555)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,217),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,15),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,35),T3sum(1:35,1))
  M(3) = M(3) + (-(CI*f(25))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,35),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,55),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,75),T3sum(1:35,2))
  M(3) = M(3) + (-(CI*f(19))/2._/**/REALKIND * den(556)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,75),T3sum(1:35,2))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,16),T4sum(1:70,43))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,16),T4sum(1:70,43))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,33),T4sum(1:70,43))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,33),T4sum(1:70,43))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,50),T4sum(1:70,44))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,50),T4sum(1:70,44))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,67),T4sum(1:70,44))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,67),T4sum(1:70,44))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,12),T4sum(1:70,45))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,12),T4sum(1:70,45))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,29),T4sum(1:70,45))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,29),T4sum(1:70,45))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,46),T4sum(1:70,46))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,46),T4sum(1:70,46))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,63),T4sum(1:70,46))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,63),T4sum(1:70,46))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,74),T4sum(1:70,47))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,74),T4sum(1:70,47))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,83),T4sum(1:70,47))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,83),T4sum(1:70,47))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,92),T4sum(1:70,48))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,92),T4sum(1:70,48))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(215)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,101),T4sum(1:70,48))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(215)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,101),T4sum(1:70,48))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,110),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,110),T3sum(1:35,69))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,146),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,146),T3sum(1:35,69))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,182),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,182),T3sum(1:35,70))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,218),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,218),T3sum(1:35,70))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(560)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,111),T3sum(1:35,3))
  M(3) = M(3) + (-(f(26)/2._/**/REALKIND) * den(560)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,147),T3sum(1:35,3))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(560)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,183),T3sum(1:35,4))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(560)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,219),T3sum(1:35,4))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(563)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(26)/2._/**/REALKIND) * den(563)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,36),T3sum(1:35,1))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(563)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(563)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,76),T3sum(1:35,2))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,112),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,112),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,148),T3sum(1:35,3))
  M(6) = M(6) + ((CI*f(25))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,148),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,184),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,184),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,220),T3sum(1:35,4))
  M(6) = M(6) + ((CI*f(19))/2._/**/REALKIND * den(566)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,220),T3sum(1:35,4))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,17),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,17),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(25))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,37),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,37),T3sum(1:35,1))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,57),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,57),T3sum(1:35,2))
  M(5) = M(5) + ((CI*f(19))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,77),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(567)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,77),T3sum(1:35,2))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,17),T4sum(1:70,43))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,17),T4sum(1:70,43))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,34),T4sum(1:70,43))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_161,masses2_14,G4tensor(:,34),T4sum(1:70,43))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,51),T4sum(1:70,44))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,51),T4sum(1:70,44))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,68),T4sum(1:70,44))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_161,masses2_11,G4tensor(:,68),T4sum(1:70,44))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,13),T4sum(1:70,45))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,13),T4sum(1:70,45))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,30),T4sum(1:70,45))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_145,masses2_14,G4tensor(:,30),T4sum(1:70,45))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,47),T4sum(1:70,46))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,47),T4sum(1:70,46))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,64),T4sum(1:70,46))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_145,masses2_11,G4tensor(:,64),T4sum(1:70,46))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,75),T4sum(1:70,47))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,75),T4sum(1:70,47))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,84),T4sum(1:70,47))
  M(7) = M(7) + (f(26)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_188,masses2_14,G4tensor(:,84),T4sum(1:70,47))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,93),T4sum(1:70,48))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,93),T4sum(1:70,48))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(217)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,102),T4sum(1:70,48))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(217)) * TI2_call(4,momenta_188,masses2_11,G4tensor(:,102),T4sum(1:70,48))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,113),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,113),T3sum(1:35,69))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,149),T3sum(1:35,69))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_8,G3tensor(:,149),T3sum(1:35,69))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,185),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,185),T3sum(1:35,70))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,221),T3sum(1:35,70))
  M(7) = M(7) + (f(21)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_5,G3tensor(:,221),T3sum(1:35,70))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(569)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,114),T3sum(1:35,3))
  M(5) = M(5) + (-(f(26)/2._/**/REALKIND) * den(569)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,150),T3sum(1:35,3))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(569)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,186),T3sum(1:35,4))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(569)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,222),T3sum(1:35,4))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(570)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,18),T3sum(1:35,1))
  M(6) = M(6) + (-(f(26)/2._/**/REALKIND) * den(570)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,38),T3sum(1:35,1))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(570)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,58),T3sum(1:35,2))
  M(6) = M(6) + (-(f(21)/2._/**/REALKIND) * den(570)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,78),T3sum(1:35,2))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,115),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,115),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(25))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,151),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(25))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,151),T3sum(1:35,3))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,187),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,187),T3sum(1:35,4))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,223),T3sum(1:35,4))
  M(4) = M(4) + (-(CI*f(19))/2._/**/REALKIND * den(577)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,223),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,116),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,116),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(25))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,152),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(25))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_8,G3tensor(:,152),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,188),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,188),T3sum(1:35,4))
  M(2) = M(2) + ((CI*f(19))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,224),T3sum(1:35,4))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(578)) * TI2_call(3,momenta_45,masses2_5,G3tensor(:,224),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,19),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(25))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,39),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(25))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,39),T3sum(1:35,1))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,59),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,59),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(19))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,79),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(585)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,79),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,20),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,20),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(25))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,40),T3sum(1:35,1))
  M(6) = M(6) + (-(CI*f(25))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_8,G3tensor(:,40),T3sum(1:35,1))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,60),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,60),T3sum(1:35,2))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,80),T3sum(1:35,2))
  M(6) = M(6) + (-(CI*f(19))/2._/**/REALKIND * den(586)) * TI2_call(3,momenta_28,masses2_5,G3tensor(:,80),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphjjj2_bbxhggg_1_/**/REALKIND
