
module ol_colourmatrix_pphjjj2_dddxdxhg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,4), KL(0,4), KL2(92,4), KL2ct(92,4), KL2ct2(92,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  36,  12,  12,   0]
  KL2( 2,:) = [  12,  36,   0,  12]
  KL2( 3,:) = [  12,   0,  36,  12]
  KL2( 4,:) = [   0,  12,  12,  36]
  KL2( 5,:) = [  48,  16,  16,   0]
  KL2( 6,:) = [  16,  48,   0,  16]
  KL2( 7,:) = [  16,   0,  48,  16]
  KL2( 8,:) = [   0,  16,  16,  48]
  KL2( 9,:) = [   0,  16,  -2,   6]
  KL2(10,:) = [  16,   0,   6,  -2]
  KL2(11,:) = [  -2,   6,   0,  16]
  KL2(12,:) = [   6,  -2,  16,   0]
  KL2(13,:) = [  48,  16,  16,   0]
  KL2(14,:) = [  16,  48,   0,  16]
  KL2(15,:) = [  16,   0,  48,  16]
  KL2(16,:) = [   0,  16,  16,  48]
  KL2(17,:) = [   6,   2,   2,   0]
  KL2(18,:) = [   2,   0,  -6, -16]
  KL2(19,:) = [   2,  -6,   0, -16]
  KL2(20,:) = [   0, -16, -16, -48]
  KL2(21,:) = [   0,   2, -16,  -6]
  KL2(22,:) = [   2,   6,   0,   2]
  KL2(23,:) = [ -16,   0, -48, -16]
  KL2(24,:) = [  -6,   2, -16,   0]
  KL2(25,:) = [  48,  16,  16,   0]
  KL2(26,:) = [  16,  48,   0,  16]
  KL2(27,:) = [  16,   0,  48,  16]
  KL2(28,:) = [   0,  16,  16,  48]
  KL2(29,:) = [   0, -16,   2,  -6]
  KL2(30,:) = [ -16, -48,   0, -16]
  KL2(31,:) = [   2,   0,   6,   2]
  KL2(32,:) = [  -6, -16,   2,   0]
  KL2(33,:) = [ -48, -16, -16,   0]
  KL2(34,:) = [ -16,   0,  -6,   2]
  KL2(35,:) = [ -16,  -6,   0,   2]
  KL2(36,:) = [   0,   2,   2,   6]
  KL2(37,:) = [   0,  -2,  16,   6]
  KL2(38,:) = [  -2,   0,   6,  16]
  KL2(39,:) = [  16,   6,   0,  -2]
  KL2(40,:) = [   6,  16,  -2,   0]
  KL2(41,:) = [  48,  16,  16,   0]
  KL2(42,:) = [  16,  48,   0,  16]
  KL2(43,:) = [  16,   0,  48,  16]
  KL2(44,:) = [   0,  16,  16,  48]
  KL2(45,:) = [   0,   0,   0,   0]
  KL2(46,:) = [   0,   0,   0,   0]
  KL2(47,:) = [   0,   0,   0,   0]
  KL2(48,:) = [   0,   0,   0,   0]
  KL2(49,:) = [   0,   0,   0,   0]
  KL2(50,:) = [   0,   0,   0,   0]
  KL2(51,:) = [   0,   0,   0,   0]
  KL2(52,:) = [   0,   0,   0,   0]
  KL2(53,:) = [   0,   0,   0,   0]
  KL2(54,:) = [   0,   0,   0,   0]
  KL2(55,:) = [   0,   0,   0,   0]
  KL2(56,:) = [   0,   0,   0,   0]
  KL2(57,:) = [   0,   0,   0,   0]
  KL2(58,:) = [   0,   0,   0,   0]
  KL2(59,:) = [   0,   0,   0,   0]
  KL2(60,:) = [   0,   0,   0,   0]
  KL2(61,:) = [   0,   0,   0,   0]
  KL2(62,:) = [   0,   0,   0,   0]
  KL2(63,:) = [   0,   0,   0,   0]
  KL2(64,:) = [   0,   0,   0,   0]
  KL2(65,:) = [ -54, -18, -18,   0]
  KL2(66,:) = [ -18,   0,   0,  18]
  KL2(67,:) = [ -18,   0, -54, -18]
  KL2(68,:) = [   0,  18, -18,   0]
  KL2(69,:) = [   0, -18,  18,   0]
  KL2(70,:) = [ -18, -54,   0, -18]
  KL2(71,:) = [  18,   0,   0, -18]
  KL2(72,:) = [   0, -18, -18, -54]
  KL2(73,:) = [ -54, -18, -18,   0]
  KL2(74,:) = [ -18, -54,   0, -18]
  KL2(75,:) = [ -18,   0,   0,  18]
  KL2(76,:) = [   0, -18,  18,   0]
  KL2(77,:) = [   0,  18, -18,   0]
  KL2(78,:) = [  18,   0,   0, -18]
  KL2(79,:) = [ -18,   0, -54, -18]
  KL2(80,:) = [   0, -18, -18, -54]
  KL2(81,:) = [   0,   0,   0,   0]
  KL2(82,:) = [   0,   0,   0,   0]
  KL2(83,:) = [   0,   0,   0,   0]
  KL2(84,:) = [   0,   0,   0,   0]
  KL2(85,:) = [ 108,  36,  36,   0]
  KL2(86,:) = [  36, 108,   0,  36]
  KL2(87,:) = [  36,   0, 108,  36]
  KL2(88,:) = [   0,  36,  36, 108]
  KL2(89,:) = [   0,   0,   0,   0]
  KL2(90,:) = [   0,   0,   0,   0]
  KL2(91,:) = [   0,   0,   0,   0]
  KL2(92,:) = [   0,   0,   0,   0]
  KL2 = (1._/**/REALKIND / 3) * KL2

  KL2ct( 1,:) = [  36,  12,  12,   0]
  KL2ct( 2,:) = [  12,  36,   0,  12]
  KL2ct( 3,:) = [  12,   0,  36,  12]
  KL2ct( 4,:) = [   0,  12,  12,  36]
  KL2ct( 5,:) = [  48,  16,  16,   0]
  KL2ct( 6,:) = [  16,  48,   0,  16]
  KL2ct( 7,:) = [  16,   0,  48,  16]
  KL2ct( 8,:) = [   0,  16,  16,  48]
  KL2ct( 9,:) = [   0,  16,  -2,   6]
  KL2ct(10,:) = [  16,   0,   6,  -2]
  KL2ct(11,:) = [  -2,   6,   0,  16]
  KL2ct(12,:) = [   6,  -2,  16,   0]
  KL2ct(13,:) = [  48,  16,  16,   0]
  KL2ct(14,:) = [  16,  48,   0,  16]
  KL2ct(15,:) = [  16,   0,  48,  16]
  KL2ct(16,:) = [   0,  16,  16,  48]
  KL2ct(17,:) = [   6,   2,   2,   0]
  KL2ct(18,:) = [   2,   0,  -6, -16]
  KL2ct(19,:) = [   2,  -6,   0, -16]
  KL2ct(20,:) = [   0, -16, -16, -48]
  KL2ct(21,:) = [   0,   2, -16,  -6]
  KL2ct(22,:) = [   2,   6,   0,   2]
  KL2ct(23,:) = [ -16,   0, -48, -16]
  KL2ct(24,:) = [  -6,   2, -16,   0]
  KL2ct(25,:) = [  48,  16,  16,   0]
  KL2ct(26,:) = [  16,  48,   0,  16]
  KL2ct(27,:) = [  16,   0,  48,  16]
  KL2ct(28,:) = [   0,  16,  16,  48]
  KL2ct(29,:) = [   0, -16,   2,  -6]
  KL2ct(30,:) = [ -16, -48,   0, -16]
  KL2ct(31,:) = [   2,   0,   6,   2]
  KL2ct(32,:) = [  -6, -16,   2,   0]
  KL2ct(33,:) = [ -48, -16, -16,   0]
  KL2ct(34,:) = [ -16,   0,  -6,   2]
  KL2ct(35,:) = [ -16,  -6,   0,   2]
  KL2ct(36,:) = [   0,   2,   2,   6]
  KL2ct(37,:) = [   0,  -2,  16,   6]
  KL2ct(38,:) = [  -2,   0,   6,  16]
  KL2ct(39,:) = [  16,   6,   0,  -2]
  KL2ct(40,:) = [   6,  16,  -2,   0]
  KL2ct(41,:) = [  48,  16,  16,   0]
  KL2ct(42,:) = [  16,  48,   0,  16]
  KL2ct(43,:) = [  16,   0,  48,  16]
  KL2ct(44,:) = [   0,  16,  16,  48]
  KL2ct(45,:) = [   0,   0,   0,   0]
  KL2ct(46,:) = [   0,   0,   0,   0]
  KL2ct(47,:) = [   0,   0,   0,   0]
  KL2ct(48,:) = [   0,   0,   0,   0]
  KL2ct(49,:) = [   0,   0,   0,   0]
  KL2ct(50,:) = [   0,   0,   0,   0]
  KL2ct(51,:) = [   0,   0,   0,   0]
  KL2ct(52,:) = [   0,   0,   0,   0]
  KL2ct(53,:) = [   0,   0,   0,   0]
  KL2ct(54,:) = [   0,   0,   0,   0]
  KL2ct(55,:) = [   0,   0,   0,   0]
  KL2ct(56,:) = [   0,   0,   0,   0]
  KL2ct(57,:) = [   0,   0,   0,   0]
  KL2ct(58,:) = [   0,   0,   0,   0]
  KL2ct(59,:) = [   0,   0,   0,   0]
  KL2ct(60,:) = [   0,   0,   0,   0]
  KL2ct(61,:) = [   0,   0,   0,   0]
  KL2ct(62,:) = [   0,   0,   0,   0]
  KL2ct(63,:) = [   0,   0,   0,   0]
  KL2ct(64,:) = [   0,   0,   0,   0]
  KL2ct(65,:) = [ -54, -18, -18,   0]
  KL2ct(66,:) = [ -18,   0,   0,  18]
  KL2ct(67,:) = [ -18,   0, -54, -18]
  KL2ct(68,:) = [   0,  18, -18,   0]
  KL2ct(69,:) = [   0, -18,  18,   0]
  KL2ct(70,:) = [ -18, -54,   0, -18]
  KL2ct(71,:) = [  18,   0,   0, -18]
  KL2ct(72,:) = [   0, -18, -18, -54]
  KL2ct(73,:) = [ -54, -18, -18,   0]
  KL2ct(74,:) = [ -18, -54,   0, -18]
  KL2ct(75,:) = [ -18,   0,   0,  18]
  KL2ct(76,:) = [   0, -18,  18,   0]
  KL2ct(77,:) = [   0,  18, -18,   0]
  KL2ct(78,:) = [  18,   0,   0, -18]
  KL2ct(79,:) = [ -18,   0, -54, -18]
  KL2ct(80,:) = [   0, -18, -18, -54]
  KL2ct(81,:) = [   0,   0,   0,   0]
  KL2ct(82,:) = [   0,   0,   0,   0]
  KL2ct(83,:) = [   0,   0,   0,   0]
  KL2ct(84,:) = [   0,   0,   0,   0]
  KL2ct(85,:) = [ 108,  36,  36,   0]
  KL2ct(86,:) = [  36, 108,   0,  36]
  KL2ct(87,:) = [  36,   0, 108,  36]
  KL2ct(88,:) = [   0,  36,  36, 108]
  KL2ct(89,:) = [   0,   0,   0,   0]
  KL2ct(90,:) = [   0,   0,   0,   0]
  KL2ct(91,:) = [   0,   0,   0,   0]
  KL2ct(92,:) = [   0,   0,   0,   0]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [  36,  12,  12,   0]
  KL2ct2( 2,:) = [  12,  36,   0,  12]
  KL2ct2( 3,:) = [  12,   0,  36,  12]
  KL2ct2( 4,:) = [   0,  12,  12,  36]
  KL2ct2( 5,:) = [  48,  16,  16,   0]
  KL2ct2( 6,:) = [  16,  48,   0,  16]
  KL2ct2( 7,:) = [  16,   0,  48,  16]
  KL2ct2( 8,:) = [   0,  16,  16,  48]
  KL2ct2( 9,:) = [   0,  16,  -2,   6]
  KL2ct2(10,:) = [  16,   0,   6,  -2]
  KL2ct2(11,:) = [  -2,   6,   0,  16]
  KL2ct2(12,:) = [   6,  -2,  16,   0]
  KL2ct2(13,:) = [  48,  16,  16,   0]
  KL2ct2(14,:) = [  16,  48,   0,  16]
  KL2ct2(15,:) = [  16,   0,  48,  16]
  KL2ct2(16,:) = [   0,  16,  16,  48]
  KL2ct2(17,:) = [   6,   2,   2,   0]
  KL2ct2(18,:) = [   2,   0,  -6, -16]
  KL2ct2(19,:) = [   2,  -6,   0, -16]
  KL2ct2(20,:) = [   0, -16, -16, -48]
  KL2ct2(21,:) = [   0,   2, -16,  -6]
  KL2ct2(22,:) = [   2,   6,   0,   2]
  KL2ct2(23,:) = [ -16,   0, -48, -16]
  KL2ct2(24,:) = [  -6,   2, -16,   0]
  KL2ct2(25,:) = [  48,  16,  16,   0]
  KL2ct2(26,:) = [  16,  48,   0,  16]
  KL2ct2(27,:) = [  16,   0,  48,  16]
  KL2ct2(28,:) = [   0,  16,  16,  48]
  KL2ct2(29,:) = [   0, -16,   2,  -6]
  KL2ct2(30,:) = [ -16, -48,   0, -16]
  KL2ct2(31,:) = [   2,   0,   6,   2]
  KL2ct2(32,:) = [  -6, -16,   2,   0]
  KL2ct2(33,:) = [ -48, -16, -16,   0]
  KL2ct2(34,:) = [ -16,   0,  -6,   2]
  KL2ct2(35,:) = [ -16,  -6,   0,   2]
  KL2ct2(36,:) = [   0,   2,   2,   6]
  KL2ct2(37,:) = [   0,  -2,  16,   6]
  KL2ct2(38,:) = [  -2,   0,   6,  16]
  KL2ct2(39,:) = [  16,   6,   0,  -2]
  KL2ct2(40,:) = [   6,  16,  -2,   0]
  KL2ct2(41,:) = [  48,  16,  16,   0]
  KL2ct2(42,:) = [  16,  48,   0,  16]
  KL2ct2(43,:) = [  16,   0,  48,  16]
  KL2ct2(44,:) = [   0,  16,  16,  48]
  KL2ct2(45,:) = [   0,   0,   0,   0]
  KL2ct2(46,:) = [   0,   0,   0,   0]
  KL2ct2(47,:) = [   0,   0,   0,   0]
  KL2ct2(48,:) = [   0,   0,   0,   0]
  KL2ct2(49,:) = [   0,   0,   0,   0]
  KL2ct2(50,:) = [   0,   0,   0,   0]
  KL2ct2(51,:) = [   0,   0,   0,   0]
  KL2ct2(52,:) = [   0,   0,   0,   0]
  KL2ct2(53,:) = [   0,   0,   0,   0]
  KL2ct2(54,:) = [   0,   0,   0,   0]
  KL2ct2(55,:) = [   0,   0,   0,   0]
  KL2ct2(56,:) = [   0,   0,   0,   0]
  KL2ct2(57,:) = [   0,   0,   0,   0]
  KL2ct2(58,:) = [   0,   0,   0,   0]
  KL2ct2(59,:) = [   0,   0,   0,   0]
  KL2ct2(60,:) = [   0,   0,   0,   0]
  KL2ct2(61,:) = [   0,   0,   0,   0]
  KL2ct2(62,:) = [   0,   0,   0,   0]
  KL2ct2(63,:) = [   0,   0,   0,   0]
  KL2ct2(64,:) = [   0,   0,   0,   0]
  KL2ct2(65,:) = [ -54, -18, -18,   0]
  KL2ct2(66,:) = [ -18,   0,   0,  18]
  KL2ct2(67,:) = [ -18,   0, -54, -18]
  KL2ct2(68,:) = [   0,  18, -18,   0]
  KL2ct2(69,:) = [   0, -18,  18,   0]
  KL2ct2(70,:) = [ -18, -54,   0, -18]
  KL2ct2(71,:) = [  18,   0,   0, -18]
  KL2ct2(72,:) = [   0, -18, -18, -54]
  KL2ct2(73,:) = [ -54, -18, -18,   0]
  KL2ct2(74,:) = [ -18, -54,   0, -18]
  KL2ct2(75,:) = [ -18,   0,   0,  18]
  KL2ct2(76,:) = [   0, -18,  18,   0]
  KL2ct2(77,:) = [   0,  18, -18,   0]
  KL2ct2(78,:) = [  18,   0,   0, -18]
  KL2ct2(79,:) = [ -18,   0, -54, -18]
  KL2ct2(80,:) = [   0, -18, -18, -54]
  KL2ct2(81,:) = [   0,   0,   0,   0]
  KL2ct2(82,:) = [   0,   0,   0,   0]
  KL2ct2(83,:) = [   0,   0,   0,   0]
  KL2ct2(84,:) = [   0,   0,   0,   0]
  KL2ct2(85,:) = [ 108,  36,  36,   0]
  KL2ct2(86,:) = [  36, 108,   0,  36]
  KL2ct2(87,:) = [  36,   0, 108,  36]
  KL2ct2(88,:) = [   0,  36,  36, 108]
  KL2ct2(89,:) = [   0,   0,   0,   0]
  KL2ct2(90,:) = [   0,   0,   0,   0]
  KL2ct2(91,:) = [   0,   0,   0,   0]
  KL2ct2(92,:) = [   0,   0,   0,   0]
  KL2ct2 = (1._/**/REALKIND / 3) * KL2ct2


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphjjj2_dddxdxhg_2_/**/REALKIND



module ol_forced_parameters_pphjjj2_dddxdxhg_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphjjj2_dddxdxhg_2_/**/REALKIND

module ol_loop_pphjjj2_dddxdxhg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(8), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:61)
  ! denominators
  complex(REALKIND), save :: den(76)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,32), Mct(4,32), Mcol_loop(4,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f(2) = (countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f(3) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f(4) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f(5) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(6) = (countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(7) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(8) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(0), M2(4)
  complex(REALKIND) :: A(44)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,3))
  call counter_SG_G(wf(:,-4),wf(:,2),wf(:,4))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,-5),Q(:,32),wf(:,5))
  call counter_SG_G(wf(:,-4),wf(:,1),wf(:,6))
  call counter_SG_G(wf(:,-4),wf(:,-5),wf(:,7))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,8))
  call vert_VQ_A(wf(:,-5),wf(:,-1),wf(:,9))
  call prop_Q_A(wf(:,9),Q(:,34),ZERO,0_intkind1,wf(:,10))
  call vert_QA_V(wf(:,10),wf(:,-3),wf(:,11))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,12))
  call prop_A_Q(wf(:,12),Q(:,40),ZERO,0_intkind1,wf(:,13))
  call vert_QA_V(wf(:,-1),wf(:,13),wf(:,14))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,15))
  call vert_AV_Q(wf(:,-3),wf(:,7),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,7),ZERO,0_intkind1,wf(:,17))
  call vert_VQ_A(wf(:,7),wf(:,-1),wf(:,18))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,50),ZERO,0_intkind1,wf(:,20))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,21))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,22))
  call vert_UV_W(wf(:,21),Q(:,9),wf(:,-5),Q(:,32),wf(:,23))
  call counter_SG_G(wf(:,-4),wf(:,22),wf(:,24))
  call vert_UV_W(wf(:,22),Q(:,6),wf(:,-5),Q(:,32),wf(:,25))
  call counter_SG_G(wf(:,-4),wf(:,21),wf(:,26))
  call vert_UV_W(wf(:,22),Q(:,6),wf(:,21),Q(:,9),wf(:,27))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,28))
  call prop_Q_A(wf(:,28),Q(:,33),ZERO,0_intkind1,wf(:,29))
  call vert_QA_V(wf(:,29),wf(:,-3),wf(:,30))
  call vert_QA_V(wf(:,0),wf(:,13),wf(:,31))
  call vert_VQ_A(wf(:,22),wf(:,0),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,7),ZERO,0_intkind1,wf(:,33))
  call vert_VQ_A(wf(:,7),wf(:,0),wf(:,34))
  call vert_AV_Q(wf(:,-3),wf(:,22),wf(:,35))
  call prop_Q_A(wf(:,34),Q(:,49),ZERO,0_intkind1,wf(:,36))
  call vert_QA_V(wf(:,10),wf(:,-2),wf(:,37))
  call vert_AV_Q(wf(:,-2),wf(:,-5),wf(:,38))
  call prop_A_Q(wf(:,38),Q(:,36),ZERO,0_intkind1,wf(:,39))
  call vert_QA_V(wf(:,-1),wf(:,39),wf(:,40))
  call vert_VQ_A(wf(:,21),wf(:,-1),wf(:,41))
  call vert_AV_Q(wf(:,-2),wf(:,7),wf(:,42))
  call prop_Q_A(wf(:,41),Q(:,11),ZERO,0_intkind1,wf(:,43))
  call vert_AV_Q(wf(:,-2),wf(:,21),wf(:,44))
  call vert_QA_V(wf(:,29),wf(:,-2),wf(:,45))
  call vert_QA_V(wf(:,0),wf(:,39),wf(:,46))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,11),ZERO,0_intkind1,wf(:,48))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,49))
  call vert_QA_V(wf(:,17),wf(:,-3),wf(:,50))
  call prop_A_Q(wf(:,19),Q(:,13),ZERO,0_intkind1,wf(:,51))
  call vert_QA_V(wf(:,-1),wf(:,51),wf(:,52))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,53))
  call prop_A_Q(wf(:,35),Q(:,14),ZERO,0_intkind1,wf(:,54))
  call vert_QA_V(wf(:,0),wf(:,54),wf(:,55))
  call vert_QA_V(wf(:,43),wf(:,-2),wf(:,56))
  call prop_A_Q(wf(:,44),Q(:,13),ZERO,0_intkind1,wf(:,57))
  call vert_QA_V(wf(:,-1),wf(:,57),wf(:,58))
  call vert_QA_V(wf(:,48),wf(:,-2),wf(:,59))
  call prop_A_Q(wf(:,49),Q(:,14),ZERO,0_intkind1,wf(:,60))
  call vert_QA_V(wf(:,0),wf(:,60),wf(:,61))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,10))
  den(3) = 1 / (Q(5,37))
  den(6) = 1 / (Q(5,42))
  den(9) = 1 / (Q(5,48))
  den(12) = 1 / (Q(5,34))
  den(15) = 1 / (Q(5,40))
  den(18) = 1 / (Q(5,7))
  den(21) = 1 / (Q(5,50))
  den(24) = 1 / (Q(5,9))
  den(25) = 1 / (Q(5,6))
  den(26) = 1 / (Q(5,41))
  den(29) = 1 / (Q(5,38))
  den(34) = 1 / (Q(5,33))
  den(41) = 1 / (Q(5,49))
  den(46) = 1 / (Q(5,36))
  den(49) = 1 / (Q(5,11))
  den(60) = 1 / (Q(5,15))
  den(63) = 1 / (Q(5,13))
  den(68) = 1 / (Q(5,14))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(1)*den(7)
  den(10) = den(1)*den(2)
  den(11) = den(9)*den(10)
  den(13) = den(6)*den(12)
  den(14) = den(1)*den(13)
  den(16) = den(6)*den(15)
  den(17) = den(1)*den(16)
  den(19) = den(1)*den(18)
  den(20) = den(9)*den(19)
  den(22) = den(9)*den(21)
  den(23) = den(1)*den(22)
  den(27) = den(24)*den(26)
  den(28) = den(25)*den(27)
  den(30) = den(25)*den(29)
  den(31) = den(24)*den(30)
  den(32) = den(24)*den(25)
  den(33) = den(9)*den(32)
  den(35) = den(26)*den(34)
  den(36) = den(25)*den(35)
  den(37) = den(15)*den(26)
  den(38) = den(25)*den(37)
  den(39) = den(18)*den(25)
  den(40) = den(9)*den(39)
  den(42) = den(9)*den(41)
  den(43) = den(25)*den(42)
  den(44) = den(12)*den(29)
  den(45) = den(24)*den(44)
  den(47) = den(29)*den(46)
  den(48) = den(24)*den(47)
  den(50) = den(24)*den(49)
  den(51) = den(9)*den(50)
  den(52) = den(22)*den(24)
  den(53) = den(3)*den(34)
  den(54) = den(2)*den(53)
  den(55) = den(3)*den(46)
  den(56) = den(2)*den(55)
  den(57) = den(2)*den(49)
  den(58) = den(9)*den(57)
  den(59) = den(2)*den(42)
  den(61) = den(10)*den(60)
  den(62) = den(19)*den(60)
  den(64) = den(1)*den(63)
  den(65) = den(60)*den(64)
  den(66) = den(32)*den(60)
  den(67) = den(39)*den(60)
  den(69) = den(25)*den(68)
  den(70) = den(60)*den(69)
  den(71) = den(50)*den(60)
  den(72) = den(24)*den(63)
  den(73) = den(60)*den(72)
  den(74) = den(57)*den(60)
  den(75) = den(2)*den(68)
  den(76) = den(60)*den(75)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(44)


  A(1) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(3) = cont_VV(wf(:,5),wf(:,6)) * den(8)
  A(4) = cont_VV(wf(:,5),wf(:,6)) * den(8)
  A(5) = cont_VV(wf(:,7),wf(:,8)) * den(11)
  A(6) = cont_VV(wf(:,7),wf(:,8)) * den(11)
  A(7) = cont_VV(wf(:,6),wf(:,11)) * den(14)
  A(8) = cont_VV(wf(:,6),wf(:,11)) * den(14)
  A(9) = cont_VV(wf(:,6),wf(:,14)) * den(17)
  A(10) = cont_VV(wf(:,6),wf(:,14)) * den(17)
  A(11) = cont_QA(wf(:,16),wf(:,17)) * den(20)
  A(12) = cont_QA(wf(:,16),wf(:,17)) * den(20)
  A(13) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(14) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(15) = cont_VV(wf(:,23),wf(:,24)) * den(28)
  A(16) = cont_VV(wf(:,23),wf(:,24)) * den(28)
  A(17) = cont_VV(wf(:,25),wf(:,26)) * den(31)
  A(18) = cont_VV(wf(:,25),wf(:,26)) * den(31)
  A(19) = cont_VV(wf(:,7),wf(:,27)) * den(33)
  A(20) = cont_VV(wf(:,7),wf(:,27)) * den(33)
  A(21) = cont_VV(wf(:,24),wf(:,30)) * den(36)
  A(22) = cont_VV(wf(:,24),wf(:,30)) * den(36)
  A(23) = cont_VV(wf(:,24),wf(:,31)) * den(38)
  A(24) = cont_VV(wf(:,24),wf(:,31)) * den(38)
  A(25) = cont_QA(wf(:,16),wf(:,33)) * den(40)
  A(26) = cont_QA(wf(:,16),wf(:,33)) * den(40)
  A(27) = cont_QA(wf(:,35),wf(:,36)) * den(43)
  A(28) = cont_QA(wf(:,35),wf(:,36)) * den(43)
  A(29) = cont_VV(wf(:,26),wf(:,37)) * den(45)
  A(30) = cont_VV(wf(:,26),wf(:,37)) * den(45)
  A(31) = cont_VV(wf(:,26),wf(:,40)) * den(48)
  A(32) = cont_VV(wf(:,26),wf(:,40)) * den(48)
  A(33) = cont_QA(wf(:,42),wf(:,43)) * den(51)
  A(34) = cont_QA(wf(:,42),wf(:,43)) * den(51)
  A(35) = cont_QA(wf(:,20),wf(:,44)) * den(52)
  A(36) = cont_QA(wf(:,20),wf(:,44)) * den(52)
  A(37) = cont_VV(wf(:,4),wf(:,45)) * den(54)
  A(38) = cont_VV(wf(:,4),wf(:,45)) * den(54)
  A(39) = cont_VV(wf(:,4),wf(:,46)) * den(56)
  A(40) = cont_VV(wf(:,4),wf(:,46)) * den(56)
  A(41) = cont_QA(wf(:,42),wf(:,48)) * den(58)
  A(42) = cont_QA(wf(:,42),wf(:,48)) * den(58)
  A(43) = cont_QA(wf(:,36),wf(:,49)) * den(59)
  A(44) = cont_QA(wf(:,36),wf(:,49)) * den(59)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(44)
  complex(REALKIND), intent(out) :: M1(0), M2(4)


  M2(1) = ((A(22)+A(28)+A(32)+A(34))*f(1))/2._/**/REALKIND+((A(38)+A(40)+A(42)+A(44))*f(1))/6._/**/REALKIND+(CI*(-A(16)+A(18) &
       -A(20))*f(2))/2._/**/REALKIND+((A(21)+A(27)+A(31)+A(33))*f(5))/2._/**/REALKIND+((A(37)+A(39)+A(41) &
       +A(43))*f(5))/6._/**/REALKIND+(CI*(-A(15)+A(17)-A(19))*f(6))/2._/**/REALKIND
  M2(2) = ((-A(30)-A(32)-A(34)-A(36))*f(1))/6._/**/REALKIND+((-A(8)-A(14)-A(40)-A(42))*f(1))/2._/**/REALKIND+(CI*(-A(2)+A(4) &
       +A(6))*f(2))/2._/**/REALKIND+((-A(29)-A(31)-A(33)-A(35))*f(5))/6._/**/REALKIND+((-A(7)-A(13)-A(39) &
       -A(41))*f(5))/2._/**/REALKIND+(CI*(-A(1)+A(3)+A(5))*f(6))/2._/**/REALKIND
  M2(3) = ((-A(22)-A(24)-A(26)-A(28))*f(1))/6._/**/REALKIND+((-A(10)-A(12)-A(38)-A(44))*f(1))/2._/**/REALKIND+(CI*(A(2)-A(4) &
       -A(6))*f(2))/2._/**/REALKIND+((-A(21)-A(23)-A(25)-A(27))*f(5))/6._/**/REALKIND+((-A(9)-A(11)-A(37) &
       -A(43))*f(5))/2._/**/REALKIND+(CI*(A(1)-A(3)-A(5))*f(6))/2._/**/REALKIND
  M2(4) = ((A(8)+A(10)+A(12)+A(14))*f(1))/6._/**/REALKIND+((A(24)+A(26)+A(30)+A(36))*f(1))/2._/**/REALKIND+(CI*(A(16)-A(18) &
       +A(20))*f(2))/2._/**/REALKIND+((A(7)+A(9)+A(11)+A(13))*f(5))/6._/**/REALKIND+((A(23)+A(25)+A(29) &
       +A(35))*f(5))/2._/**/REALKIND+(CI*(A(15)-A(17)+A(19))*f(6))/2._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pphjjj2_dddxdxhg_2_/**/REALKIND
