
module ol_colourmatrix_pphj2_aagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,1), KL(0,1), KL2(12,1), KL2ct(12,1), KL2ct2(12,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  2]
  KL2( 2,:) = [  0]
  KL2( 3,:) = [  0]
  KL2( 4,:) = [  0]
  KL2( 5,:) = [  0]
  KL2( 6,:) = [  0]
  KL2( 7,:) = [  6]
  KL2( 8,:) = [  0]
  KL2( 9,:) = [  0]
  KL2(10,:) = [ -6]
  KL2(11,:) = [  6]
  KL2(12,:) = [  2]

  KL2ct( 1,:) = [  2]
  KL2ct( 2,:) = [  0]
  KL2ct( 3,:) = [  0]
  KL2ct( 4,:) = [  0]
  KL2ct( 5,:) = [  0]
  KL2ct( 6,:) = [  0]
  KL2ct( 7,:) = [  6]
  KL2ct( 8,:) = [  0]
  KL2ct( 9,:) = [  0]
  KL2ct(10,:) = [ -6]
  KL2ct(11,:) = [  6]
  KL2ct(12,:) = [  2]

  KL2ct2( 1,:) = [  2]
  KL2ct2( 2,:) = [  0]
  KL2ct2( 3,:) = [  0]
  KL2ct2( 4,:) = [  0]
  KL2ct2( 5,:) = [  0]
  KL2ct2( 6,:) = [  0]
  KL2ct2( 7,:) = [  6]
  KL2ct2( 8,:) = [  0]
  KL2ct2( 9,:) = [  0]
  KL2ct2(10,:) = [ -6]
  KL2ct2(11,:) = [  6]
  KL2ct2(12,:) = [  2]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphj2_aagg_1_/**/REALKIND



module ol_forced_parameters_pphj2_aagg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (YB /= 0) write(*,101) 'YB = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphj2_aagg_1_/**/REALKIND

module ol_loop_pphj2_aagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(2), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-4+1:2)
  ! denominators
  complex(REALKIND), save :: den(1)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,16), Mct(1,16), Mcol_loop(1,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (CI*countertermnorm*ctHGG*eQED*gQCD**2*MT*YT)/MQ2sum
    f(2) = (eQED*gQCD**2*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,4)
  integer,           intent(in)  :: H(4)
  integer,           intent(in), optional  :: POLSEL(4)
  complex(REALKIND), intent(out) :: M1(0), M2(1)
  complex(REALKIND) :: A(1)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_V(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_V(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))

  else
    call pol_wf_V(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_V(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)

  end if

  ! internal WFs
  call vert_GG_H(wf(:,0),Q(:,1),wf(:,-1),Q(:,2),wf(:,1))
  call counter_GG_S(wf(:,-2),wf(:,-3),wf(:,2))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MH2)

  ! denominators

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(1)


  A(1) = cont_SS(wf(:,1),wf(:,2)) * den(1)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(1)
  complex(REALKIND), intent(out) :: M1(0), M2(1)


  M2(1) = -2*A(1)*f(1)

end subroutine colourvectors

end module ol_loop_pphj2_aagg_1_/**/REALKIND
