
module ol_vamp_1_pphbb_bbxhgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphbb_bbxhgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphbb_bbxhgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphbb_bbxhgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphbb_bbxhgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphbb_bbxhgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphbb_bbxhgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,2,4,1,8],[0,nMB,nMB,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,2,8,1,4],[nMB,0,0,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(8),n2h8(7))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,1,4,2,8],[0,nMB,nMB,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,1,4,8,2],[0,nMB,nMB,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,1,8,2,4],[nMB,0,0,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(11),n2h8(8))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,1,8,4,2],[0,nMB,nMB,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AS_Q(ntryL,G1H8(1),ex3(:),G1H8(13),ngH,m3h1x8(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(13),20,nMB,G2H8(1),n2h8(9))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QS_A(ntryL,G1H8(3),ex3(:),G1H8(1),ngH,m3h1x8(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(2),n2h8(10))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G1H8(5),ex1(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G1H8(6),ex1(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(5),18,nMB,G2H4(1),n2h4(1))
  call Hloop_QA_V(ntryL,G1H8(8),ex2(:),G1H4(5),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(6),17,nMB,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(6),m3h2x4(:,8),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(6),17,nMB,G2H4(3),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H8(11),ex1(:),G1H4(6),m3h2x4(:,9),heltab2x8(:,:,11))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(7),m3h2x4(:,10),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(7),17,nMB,G2H4(4),n2h4(4))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(5),m3h2x4(:,11),heltab2x8(:,:,13))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(1),n2h2(1))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(6),m3h2x4(:,12),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(2),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(3),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(4),ex2(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(4),n2h2(4))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(8),4)
  call HG1shiftOLR(G1H4(1),8,4)
  call Hloop_UV_W(ntryL,G1H4(5),18,ex4(:),8,G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(5),G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(9),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(3),mass5set(:,2),  & 
G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(15),2,4)
  call Hloop_UV_W(ntryL,G1H4(6),17,ex4(:),8,G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,2),  & 
G1H4(6),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hloop_AS_Q(ntryL,G1H4(7),ex3(:),G1H4(25),ngH,m3h1x4(:,1),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(25),22,nMB,G2H4(1),n2h4(5))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1),-8,ex4(:),8,G2H2(7),m3h2x2(:,7),heltab2x4(:,:,8))
call signflip_OLR(G2H2(7))
  call Hloop_AS_Q(ntryL,G1H4(3),ex3(:),G1H4(7),ngH,m3h1x4(:,2),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMB,G2H4(2),n2h4(7))
  call Hloop_AS_Q(ntryL,G1H4(4),ex3(:),G1H4(25),ngH,m3h1x4(:,3),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(25),22,nMB,G2H4(3),n2h4(8))
  call Hloop_AS_Q(ntryL,G1H4(8),ex3(:),G1H4(1),ngH,m3h1x4(:,4),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(4),n2h4(9))
  call Hloop_QS_A(ntryL,G1H4(5),ex3(:),G1H4(3),ngH,m3h1x4(:,5),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(3),21,nMB,G2H4(7),n2h4(10))
call HGT_raise_alpha_OLR(G1H4(9),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(9),-8,ex4(:),8,G2H2(8),m3h2x2(:,8),heltab2x4(:,:,13))
call signflip_OLR(G2H2(8))
  call Hloop_QS_A(ntryL,G1H4(11),ex3(:),G1H4(7),ngH,m3h1x4(:,6),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(7),21,nMB,G2H4(8),n2h4(12))
  call Hloop_QS_A(ntryL,G1H4(12),ex3(:),G1H4(4),ngH,m3h1x4(:,7),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(4),21,nMB,G2H4(9),n2h4(13))
  call Hloop_QS_A(ntryL,G1H4(13),ex3(:),G1H4(25),ngH,m3h1x4(:,8),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(10),n2h4(14))
  call Hloop_QS_A(ntryL,G1H4(14),ex3(:),G1H4(8),ngH,m3h1x4(:,9),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(8),21,nMB,G2H4(11),n2h4(15))
call HGT_raise_alpha_OLR(G1H4(15),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,18))
  call Hloop_QS_A(ntryL,G1H4(17),ex3(:),G1H4(1),ngH,m3h1x4(:,10),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(12),n2h4(17))
  call Hloop_QS_A(ntryL,G1H4(18),ex3(:),G1H4(5),ngH,m3h1x4(:,11),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(5),21,nMB,G2H4(13),n2h4(18))
  call Hloop_QS_A(ntryL,G1H4(19),ex3(:),G1H4(3),ngH,m3h1x4(:,12),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(3),21,nMB,G2H4(14),n2h4(19))
  call Hloop_QV_A(ntryL,G1H4(6),ex4(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(2),25,nMB,G2H2(9),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex2(:),G1H2(2),m3h2x2(:,11),heltab2x4(:,:,23))
  call Hloop_QV_A(ntryL,G1H4(22),ex4(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(3),25,nMB,G2H2(10),n2h2(6))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(3),25,nMB,G2H2(11),n2h2(7))
  call Hloop_QV_A(ntryL,G1H4(24),ex4(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),25,nMB,G2H2(12),n2h2(8))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(5),mass5set(:,3),  & 
G1H4(9),G1H4(11),G1H4(7),G1H4(12),G1H4(4),G1H4(13),4)
  call HG1shiftOLR(G1H4(11),8,4)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(6),mass5set(:,4),  & 
G1H2(3),G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(4),8,2)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(7),mass5set(:,3),  & 
G1H4(25),G1H4(14),G1H4(8),G1H4(15),G1H4(17),G1H4(1),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(8),mass5set(:,4),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(9),mass5set(:,4),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(10),mass5set(:,4),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(11),mass5set(:,5),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),4,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(12),mass5set(:,5),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hloop_AQ_V(ntryL,G2H4(1),ex1(:),G2H2(1),m3h2x2(:,15),heltab2x4(:,:,27))
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(2),m3h2x2(:,16),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(3),m3h2x2(:,17),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(4),m3h2x2(:,18),heltab2x4(:,:,30))
  call Hloop_QA_V(ntryL,G2H4(9),ex2(:),G2H2(5),m3h2x2(:,19),heltab2x4(:,:,31))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(6),m3h2x2(:,20),heltab2x4(:,:,32))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,2),  & 
G1H4(18),G1H4(5),G1H4(19),G1H4(3),G1H4(6),G1H4(20),4)
  call HG1shiftOLR(G1H4(5),2,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(1),mass4set(:,1),  & 
G1H4(22),G1H4(23),G1H4(24),G1H4(26),G1H4(27),4)
  call HG1shiftOLR(G1H4(23),2,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(2),mass4set(:,1),  & 
G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(29),10,4)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(4),mass5set(:,2),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),2,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(1),mass4set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),2)
  call HG1shiftOLR(G1H2(46),2,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(3),mass4set(:,1),  & 
G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(51),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(44)])
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(43),m3h2x2(:,21),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMB,G2H2(9),n2h2(9))
call HGT_OLR(G1H4(11),1,1,4)
call HGT_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(11),-8,nMB,G2H4(5),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(11),m3h2x2(:,22),heltab2x4(:,:,34))
  call Hloop_VA_Q(ntryL,G1H4(4),ex2(:),G1H2(44),m3h2x2(:,23),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMB,G2H2(12),n2h2(10))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(43),m3h2x2(:,24),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMB,G2H2(13),n2h2(11))
  call Hloop_QS_A(ntryL,G1H2(3),ex3(:),G1H2(44),ngH,m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(14),n2h2(12))
call HGT_OLR(G1H2(4),1,1,2)
call HGT_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(4),-8,nMB,G2H2(15),n2h2(13))
  call Hloop_AV_Q(ntryL,G2H2(15),ex4(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,2))
  call Hloop_QS_A(ntryL,G1H2(7),ex3(:),G1H2(43),ngH,m3h1x2(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(15),n2h2(14))
  call Hloop_QS_A(ntryL,G1H2(8),ex3(:),G1H2(3),ngH,m3h1x2(:,3),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(16),n2h2(15))
  call Hloop_VQ_A(ntryL,G1H4(25),ex1(:),G1H2(44),m3h2x2(:,25),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(17),n2h2(16))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-8,nMB,G2H4(6),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(18),m3h2x2(:,26),heltab2x4(:,:,38))
  call Hloop_VQ_A(ntryL,G1H4(17),ex1(:),G1H2(4),m3h2x2(:,27),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(19),n2h2(17))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(7),m3h2x2(:,28),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(20),n2h2(18))
  call Hloop_QV_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,5))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(2),n2h1(1))
call HGT_OLR(G1H2(10),1,1,2)
call HGT_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(10),-4,nMB,G2H2(21),n2h2(19))
  call Hloop_AS_Q(ntryL,G2H2(21),ex3(:),G2H2(22),ngH,m3h1x2(:,4),heltab2x2(:,:,6))
  call Hloop_QV_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(3),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,8))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(4),n2h1(3))
  call Hloop_AS_Q(ntryL,G1H2(15),ex3(:),G1H2(43),ngH,m3h1x2(:,5),heltab2x2(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMB,G2H2(21),n2h2(20))
call HGT_OLR(G1H2(16),1,1,2)
call HGT_invQ_OLR(G1H2(16),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(16),-8,nMB,G2H2(23),n2h2(21))
  call Hloop_QV_A(ntryL,G2H2(23),ex4(:),G2H1(5),m3h2x1(:,5),heltab2x2(:,:,10))
  call Hloop_AS_Q(ntryL,G1H2(19),ex3(:),G1H2(8),ngH,m3h1x2(:,6),heltab2x2(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(8),23,nMB,G2H2(23),n2h2(22))
  call Hloop_AS_Q(ntryL,G1H2(20),ex3(:),G1H2(3),ngH,m3h1x2(:,7),heltab2x2(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMB,G2H2(24),n2h2(23))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(6),n2h1(4))
call HGT_OLR(G1H2(22),1,1,2)
call HGT_invQ_OLR(G1H2(22),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(22),-4,nMB,G2H2(25),n2h2(24))
  call Hloop_QS_A(ntryL,G2H2(25),ex3(:),G2H2(26),ngH,m3h1x2(:,8),heltab2x2(:,:,14))
  call Hloop_AV_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(7),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(8),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(9),n2h1(7))
call HGT_OLR(G1H2(28),1,1,2)
call HGT_invQ_OLR(G1H2(28),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(28),-4,nMB,G2H2(25),n2h2(25))
  call Hloop_AS_Q(ntryL,G2H2(25),ex3(:),G2H2(27),ngH,m3h1x2(:,9),heltab2x2(:,:,18))
  call Hloop_VQ_A(ntryL,G1H2(31),ex1(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,19))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(10),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(32),ex1(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,20))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(11),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(33),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(12),n2h1(10))
call HGT_OLR(G1H2(34),1,1,2)
call HGT_invQ_OLR(G1H2(34),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(34),-4,nMB,G2H2(25),n2h2(26))
  call Hloop_QS_A(ntryL,G2H2(25),ex3(:),G2H2(28),ngH,m3h1x2(:,10),heltab2x2(:,:,22))
  call Hloop_VA_Q(ntryL,G1H2(37),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,23))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(13),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(38),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,24))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(14),n2h1(12))
  call Hloop_QV_A(ntryL,G1H4(18),ex4(:),G1H2(44),m3h2x2(:,29),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(44),29,nMB,G2H2(25),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(5),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(4),m3h2x2(:,30),heltab2x4(:,:,42))
  call Hloop_QV_A(ntryL,G1H4(22),ex4(:),G1H2(7),m3h2x2(:,31),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(29),n2h2(28))
  call Hloop_QV_A(ntryL,G1H4(28),ex4(:),G1H2(9),m3h2x2(:,32),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(9),29,nMB,G2H2(30),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(23),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(23),ex2(:),G1H2(10),m3h2x2(:,33),heltab2x4(:,:,45))
  call Hloop_QV_A(ntryL,G1H4(27),ex4(:),G1H2(13),m3h2x2(:,34),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(13),29,nMB,G2H2(31),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(29),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(29),ex2(:),G1H2(14),m3h2x2(:,35),heltab2x4(:,:,47))
  call Hloop_QV_A(ntryL,G1H4(32),ex4(:),G1H2(15),m3h2x2(:,36),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(15),29,nMB,G2H2(32),n2h2(31))
  call Hloop_QS_A(ntryL,G1H2(39),ex3(:),G1H2(43),ngH,m3h1x2(:,11),heltab2x2(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(43),29,nMB,G2H2(33),n2h2(32))
call HGT_raise_alpha_OLR(G1H2(40),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(40),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,26))
  call Hloop_QS_A(ntryL,G1H2(45),ex3(:),G1H2(16),ngH,m3h1x2(:,12),heltab2x2(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(34),n2h2(34))
  call Hloop_QS_A(ntryL,G1H2(50),ex3(:),G1H2(19),ngH,m3h1x2(:,13),heltab2x2(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(19),29,nMB,G2H2(35),n2h2(35))
call HGT_raise_alpha_OLR(G1H2(46),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(46),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(46),ex2(:),G1H1(2),m3h2x1(:,16),heltab2x2(:,:,29))
  call Hloop_QS_A(ntryL,G1H2(49),ex3(:),G1H2(8),ngH,m3h1x2(:,14),heltab2x2(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(8),29,nMB,G2H2(36),n2h2(37))
call HGT_raise_alpha_OLR(G1H2(51),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(51),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(51),ex2(:),G1H1(3),m3h2x1(:,17),heltab2x2(:,:,31))
  call Hloop_QS_A(ntryL,G1H2(54),ex3(:),G1H2(20),ngH,m3h1x2(:,15),heltab2x2(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(20),29,nMB,G2H2(37),n2h2(39))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(3),G1H2(21),G1H2(22),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(21),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,1),  & 
G1H2(28),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(31),9,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(44),G1H2(7),G1H2(9),G1H2(13),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(2),mass4set(:,1),  & 
G1H2(15),G1H2(39),G1H2(43),G1H2(40),G1H2(45),2)
  call HG1shiftOLR(G1H2(39),10,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,3),  & 
G1H2(16),G1H2(50),G1H2(19),G1H2(46),G1H2(49),G1H2(8),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(5),mass4set(:,2),  & 
G1H2(51),G1H2(54),G1H2(20),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(54),10,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(6),mass5set(:,4),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(6),mass4set(:,3),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(64),12,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(7),mass5set(:,3),  & 
G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(69),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(7),mass4set(:,2),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(75),9,2)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(8),mass5set(:,4),  & 
G1H1(4),G1H1(5),G1H1(6),G1H1(7),G1H1(8),G1H1(9),1)
  call HG1shiftOLR(G1H1(5),4,1)
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(6),mass4set(:,3),  & 
G1H1(10),G1H1(11),G1H1(12),G1H1(13),G1H1(14),1)
  call HG1shiftOLR(G1H1(11),12,1)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(9),mass5set(:,4),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(8),mass4set(:,3),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(86),12,2)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(10),mass5set(:,4),  & 
G1H1(15),G1H1(16),G1H1(17),G1H1(18),G1H1(19),G1H1(20),1)
  call HG1shiftOLR(G1H1(16),4,1)
  call Hotf_4pt_reduction(G2H1(8),RedSet_4(8),mass4set(:,3),  & 
G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),1)
  call HG1shiftOLR(G1H1(22),12,1)
  call Hotf_5pt_reduction(G2H1(9),RedSet_5(11),mass5set(:,5),  & 
G1H1(26),G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),1)
  call HG1shiftOLR(G1H1(27),4,1)
  call Hotf_4pt_reduction(G2H1(11),RedSet_4(9),mass4set(:,4),  & 
G1H1(32),G1H1(33),G1H1(34),G1H1(35),G1H1(36),1)
  call HG1shiftOLR(G1H1(33),5,1)
  call Hotf_5pt_reduction(G2H1(12),RedSet_5(12),mass5set(:,5),  & 
G1H1(37),G1H1(38),G1H1(39),G1H1(40),G1H1(41),G1H1(42),1)
  call HG1shiftOLR(G1H1(38),4,1)
  call Hotf_4pt_reduction(G2H1(14),RedSet_4(3),mass4set(:,4),  & 
G1H1(43),G1H1(44),G1H1(45),G1H1(46),G1H1(47),1)
  call HG1shiftOLR(G1H1(44),6,1)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(1),m3h2x1(:,18),heltab2x2(:,:,33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(2),m3h2x1(:,19),heltab2x2(:,:,34))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex2(:),G2tensor(3),m3h2x1(:,20),heltab2x2(:,:,35))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex2(:),G2tensor(4),m3h2x1(:,21),heltab2x2(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(10),[G1H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(21),[G1H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(32),[G1H1(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(43),[G1H1(42)])
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(3),23,ex4(:),8,G2tensor(5),m3h2x1(:,22),heltab2x2(:,:,37))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),0,ex4(:),8,G2tensor(6),m3h2x1(:,23),heltab2x2(:,:,38))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),23,ex4(:),8,G2tensor(7),m3h2x1(:,24),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),1,ex4(:),8,G2tensor(8),m3h2x1(:,25),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(37),23,ex4(:),8,G2tensor(9),m3h2x1(:,26),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),0,ex4(:),8,G2tensor(10),m3h2x1(:,27),heltab2x2(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(11),m3h2x1(:,28),heltab2x2(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(39),2,ex4(:),8,G2tensor(12),m3h2x1(:,29),heltab2x2(:,:,44))
  call Hloop_AV_Q(ntryL,G1H2(16),ex4(:),G1H1(9),m3h2x1(:,30),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(13),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(20),m3h2x1(:,31),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(14),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(51),ex4(:),G1H1(31),m3h2x1(:,32),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(15),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(54),ex4(:),G1H1(42),m3h2x1(:,33),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),10,nMB,G2tensor(16),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(9),m3h2x1(:,34),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(17),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(58),ex4(:),G1H1(20),m3h2x1(:,35),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(18),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(31),m3h2x1(:,36),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(19),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(42),m3h2x1(:,37),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(20),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(9),m3h2x1(:,38),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(21),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(20),m3h2x1(:,39),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(22),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(31),m3h2x1(:,40),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(23),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(42),m3h2x1(:,41),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),9,nMB,G2tensor(24),n2h1(28))
  call Hloop_QS_A(ntryL,G1H1(4),ex3(:),G1H1(9),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(25),n2h1(29))
  call Hloop_QS_A(ntryL,G1H1(5),ex3(:),G1H1(20),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),4,nMB,G2tensor(26),n2h1(30))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(31),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(27),n2h1(31))
  call Hloop_QS_A(ntryL,G1H1(11),ex3(:),G1H1(42),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(28),n2h1(32))
  call Hloop_AV_Q(ntryL,G1H2(79),ex4(:),G1H1(4),m3h2x1(:,42),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(29),n2h1(33))
  call Hloop_AV_Q(ntryL,G1H2(80),ex4(:),G1H1(9),m3h2x1(:,43),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),8,nMB,G2tensor(30),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(5),m3h2x1(:,44),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(31),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H2(86),ex4(:),G1H1(20),m3h2x1(:,45),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),12,nMB,G2tensor(32),n2h1(36))
  call Hloop_AS_Q(ntryL,G1H1(15),ex3(:),G1H1(10),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(33),n2h1(37))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(31),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),4,nMB,G2tensor(34),n2h1(38))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(11),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),31,nMB,G2tensor(35),n2h1(39))
  call Hloop_AS_Q(ntryL,G1H1(22),ex3(:),G1H1(42),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(36),n2h1(40))
  call Hloop_QS_A(ntryL,G1H1(26),ex3(:),G1H1(4),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(37),n2h1(41))
  call Hloop_QS_A(ntryL,G1H1(27),ex3(:),G1H1(9),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),4,nMB,G2tensor(38),n2h1(42))
  call Hloop_QS_A(ntryL,G1H1(32),ex3(:),G1H1(5),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(39),n2h1(43))
  call Hloop_QS_A(ntryL,G1H1(33),ex3(:),G1H1(20),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),5,nMB,G2tensor(40),n2h1(44))
  call Hloop_AS_Q(ntryL,G1H1(37),ex3(:),G1H1(15),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),31,nMB,G2tensor(41),n2h1(45))
  call Hloop_AS_Q(ntryL,G1H1(38),ex3(:),G1H1(10),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),4,nMB,G2tensor(42),n2h1(46))
  call Hloop_AS_Q(ntryL,G1H1(43),ex3(:),G1H1(16),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(43),n2h1(47))
  call Hloop_AS_Q(ntryL,G1H1(44),ex3(:),G1H1(31),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),6,nMB,G2tensor(44),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(9),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(10),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(11),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(12),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[24,1,4,2],[0,nMB,nMB,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex5(:),ex4(:),G0H4(1),m4h2x2x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[24,1,4,2],[0,nMB,nMB,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex5(:),G0H4(2),m4h2x2x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[24,1,4,2],[0,nMB,nMB,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex5(:),ex4(:),G0H4(3),m4h2x2x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[16,3,8,4],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMC,G1H8(13),n2h8(11))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(2),n2h8(12))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[16,3,8,4],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMC,G1H8(3),n2h8(13))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(1),n2h8(14))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(4),n2h8(15))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(5),n2h8(16))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[16,3,4,8],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMC,G1H8(6),n2h8(17))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(7),n2h8(18))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[16,3,4,8],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMC,G1H8(8),n2h8(19))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(9),n2h8(20))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(10),n2h8(21))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(11),n2h8(22))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[16,4,3,8],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMC,G1H8(12),n2h8(23))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(14),n2h8(24))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(19)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[16,4,3,8],[nMC,nMC,nMC,nMC],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMC,G1H8(15),n2h8(25))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(16),n2h8(26))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(17),n2h8(27))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(18),n2h8(28))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[16,2,8,5],[0,nMB,nMB,0],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(19),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[16,2,8,5],[nMB,0,0,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(20),n2h8(29))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(21),n2h8(30))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[16,5,2,8],[0,nMB,0,0],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(22),m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(23),n2h8(31))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[16,2,5,8],[0,nMB,0,0],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(24),m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[16,1,8,6],[0,nMB,nMB,0],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(25),m3h2x8(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[16,1,8,6],[nMB,0,0,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(26),n2h8(32))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(27),n2h8(33))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[16,6,1,8],[0,nMB,0,0],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(28),m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(29),n2h8(34))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[16,1,6,8],[0,nMB,0,0],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(30),m3h2x8(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[16,2,4,9],[0,nMB,nMB,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(31),m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(32),n2h8(35))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(33),n2h8(36))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[16,1,4,10],[0,nMB,nMB,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(34),m3h2x8(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(35),n2h8(37))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(36),n2h8(38))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[17,4,2,8],[nMB,nMB,0,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H16(1),wf4(:,12),G0H4(4),m3h4x4(:,1),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H4(4),17,nMB,G1H4(6),n2h4(26))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,12),G0H4(4),m3h4x4(:,2),heltab2x16(:,:,50))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,12),G0H4(5),m3h4x4(:,3),heltab2x16(:,:,51))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[18,4,1,8],[nMB,nMB,0,0],4,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(6),m3h4x4(:,4),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H4(6),18,nMB,G1H4(20),n2h4(27))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,5),G0H4(6),m3h4x4(:,5),heltab2x16(:,:,53))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,5),G0H4(7),m3h4x4(:,6),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[24,2,1,4],[nMB,0,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,7),G0H4(8),m3h4x4(:,7),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(8),24,nMB,G1H4(9),n2h4(28))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[24,1,2,4],[nMB,0,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,7),G0H4(8),m3h4x4(:,8),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H4(8),24,nMB,G1H4(11),n2h4(29))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[24,1,4,2],[0,nMB,nMB,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,7),24,G1H4(4),m3h4x4(:,9),heltab2x16(:,:,57))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G0H4(3),G0H4(2),G0H4(1)])
  call Hloop_AS_Q(ntryL,G1H4(20),ex3(:),G1H4(13),ngH,m3h1x4(:,13),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(13),22,nMB,G2H4(1),n2h4(30))
  call Hloop_QS_A(ntryL,G1H4(6),ex3(:),G1H4(25),ngH,m3h1x4(:,14),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(3),n2h4(31))
  call Hloop_QS_A(ntryL,G1H4(16),ex3(:),G1H4(14),ngH,m3h1x4(:,15),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(14),21,nMB,G2H4(4),n2h4(32))
  call Hloop_QV_A(ntryL,G1H4(21),ex4(:),G1H2(27),m3h2x2(:,37),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(27),25,nMB,G2H2(1),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(13),m3h2x2(:,38),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(13),25,nMB,G2H2(3),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,16),G1H2(8),m3h4x2(:,1),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(8),19,nMC,G2H2(4),n2h2(42))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,16),G1H2(62),m3h4x2(:,2),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(62),19,nMT,G2H2(6),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,16),G1H2(73),m3h4x2(:,3),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(73),19,nMC,G2H2(9),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,16),G1H2(84),m3h4x2(:,4),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(84),19,nMT,G2H2(13),n2h2(45))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,16),G1H2(3),m3h4x2(:,5),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(3),19,nMB,G2H2(14),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,16),G1H2(21),m3h4x2(:,6),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(21),19,nMB,G2H2(16),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,16),G1H2(28),m3h4x2(:,7),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(28),19,nMC,G2H2(17),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,16),G1H2(31),m3h4x2(:,8),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(31),19,nMT,G2H2(20),n2h2(49))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,16),G1H2(37),m3h4x2(:,9),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(37),19,nMC,G2H2(21),n2h2(50))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,16),G1H2(38),m3h4x2(:,10),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(38),19,nMT,G2H2(24),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,16),G1H2(15),m3h4x2(:,11),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(15),19,nMB,G2H2(25),n2h2(52))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,16),G1H2(39),m3h4x2(:,12),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(39),19,nMB,G2H2(30),n2h2(53))
  call Hloop_QS_A(ntryL,G1H8(12),ex3(:),G1H8(13),ngH,m3h1x8(:,3),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMC,G2H8(1),n2h8(39))
  call Hloop_QS_A(ntryL,G1H8(14),ex3(:),G1H8(2),ngH,m3h1x8(:,4),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMT,G2H8(2),n2h8(40))
  call Hloop_AS_Q(ntryL,G1H8(15),ex3(:),G1H8(3),ngH,m3h1x8(:,5),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMC,G2H8(3),n2h8(41))
  call Hloop_AS_Q(ntryL,G1H8(16),ex3(:),G1H8(1),ngH,m3h1x8(:,6),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(42))
  call Hloop_QS_A(ntryL,G1H8(17),ex3(:),G1H8(4),ngH,m3h1x8(:,7),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMB,G2H8(5),n2h8(43))
  call Hloop_AS_Q(ntryL,G1H8(18),ex3(:),G1H8(5),ngH,m3h1x8(:,8),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMB,G2H8(6),n2h8(44))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(17),m3h2x4(:,13),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(17),18,nMB,G2H4(7),n2h4(33))
  call Hloop_QA_V(ntryL,G1H8(20),ex2(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G1H8(21),wf2(:,2),G1H4(18),m3h2x4(:,15),heltab2x8(:,:,35))
  call Hloop_VQ_A(ntryL,G1H8(22),wf2(:,2),G1H4(5),m3h2x4(:,16),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(5),21,nMB,G2H4(9),n2h4(34))
  call Hloop_QA_V(ntryL,G1H8(23),ex2(:),G1H4(22),m3h2x4(:,17),heltab2x8(:,:,37))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(28),m3h2x4(:,18),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(28),18,nMB,G2H4(10),n2h4(35))
  call Hloop_VQ_A(ntryL,G1H8(25),ex1(:),G1H4(23),m3h2x4(:,19),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(23),17,nMB,G2H4(11),n2h4(36))
  call Hloop_AQ_V(ntryL,G1H8(26),ex1(:),G1H4(27),m3h2x4(:,20),heltab2x8(:,:,40))
  call Hloop_QA_V(ntryL,G1H8(27),wf2(:,4),G1H4(29),m3h2x4(:,21),heltab2x8(:,:,41))
  call Hloop_VA_Q(ntryL,G1H8(28),wf2(:,4),G1H4(32),m3h2x4(:,22),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(32),22,nMB,G2H4(13),n2h4(37))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(2),m3h2x4(:,23),heltab2x8(:,:,43))
  call Hloop_VQ_A(ntryL,G1H8(30),ex1(:),G1H4(10),m3h2x4(:,24),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(10),17,nMB,G2H4(14),n2h4(38))
  call Hloop_VA_Q(ntryL,G1H8(31),ex2(:),G1H4(20),m3h2x4(:,25),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(20),18,nMB,G2H4(5),n2h4(39))
  call Hloop_QS_A(ntryL,G1H8(32),ex3(:),G1H8(6),ngH,m3h1x8(:,9),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(7),n2h8(45))
  call Hloop_QA_V(ntryL,G1H8(33),ex2(:),G1H4(13),m3h2x4(:,26),heltab2x8(:,:,47))
  call Hloop_VQ_A(ntryL,G1H8(34),ex1(:),G1H4(6),m3h2x4(:,27),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(6),17,nMB,G2H4(6),n2h4(40))
  call Hloop_AS_Q(ntryL,G1H8(35),ex3(:),G1H8(7),ngH,m3h1x8(:,10),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(7),20,nMB,G2H8(8),n2h8(46))
  call Hloop_AQ_V(ntryL,G1H8(36),ex1(:),G1H4(25),m3h2x4(:,28),heltab2x8(:,:,50))
  call Hloop_VA_Q(ntryL,G0H4(4),ex2(:),G0H2(1),m3h2x2(:,39),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G0H2(1),19,nMB,G1H2(16),n2h2(54))
  call Hloop_VA_Q(ntryL,G0H4(5),ex2(:),G0H2(1),m3h2x2(:,40),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G0H2(1),19,nMB,G1H2(50),n2h2(55))
  call Hloop_VQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),m3h2x2(:,41),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G0H2(1),19,nMB,G1H2(51),n2h2(56))
  call Hloop_VQ_A(ntryL,G0H4(7),ex1(:),G0H2(1),m3h2x2(:,42),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G0H2(1),19,nMB,G1H2(54),n2h2(57))
  call Hloop_QA_V(ntryL,G1H4(9),ex2(:),G1H2(57),m3h2x2(:,43),heltab2x4(:,:,58))
  call Hloop_AQ_V(ntryL,G1H4(11),ex1(:),G1H2(58),m3h2x2(:,44),heltab2x4(:,:,59))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(2)])
call HGT_lower_alpha_OLR(G2H2(8),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(8),2,5,2)
call HGT_lower_alpha_OLR(G2H2(8),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(5)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(11)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(41)])
call HGT_lower_alpha_OLR(G2H2(7),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(7),2,5,2)
call HGT_lower_alpha_OLR(G2H2(7),6,15,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(47),mass4set(:,1),  & 
G1H2(63),G1H2(64),G1H2(68),G1H2(69),G1H2(74),2)
  call HG1shiftOLR(G1H2(64),1,2)
  call Hloop_AQ_V(ntryL,G2H4(13),ex1(:),G2H2(33),m3h2x2(:,45),heltab2x4(:,:,60))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(48),mass4set(:,1),  & 
G1H2(75),G1H2(79),G1H2(80),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(79),2,2)
  call Hloop_QA_V(ntryL,G2H4(9),ex2(:),G2H2(35),m3h2x2(:,46),heltab2x4(:,:,61))
  call Hloop_QS_A(ntryL,G1H2(1),ex3(:),G1H2(27),ngH,m3h1x2(:,16),heltab2x2(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMB,G2H2(3),n2h2(58))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(11),mass4set(:,1),  & 
G1H4(16),G1H4(14),G1H4(21),G1H4(4),G1H4(17),4)
  call HG1shiftOLR(G1H4(14),2,4)
  call Hloop_QV_A(ntryL,G1H2(2),ex4(:),G1H1(21),m3h2x1(:,46),heltab2x2(:,:,62))
  call Hloop_Q_A(ntryL,G1H1(21),27,nMB,G2H1(2),n2h1(49))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(14),mass4set(:,1),  & 
G1H2(13),G1H2(8),G1H2(62),G1H2(73),G1H2(84),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(3),m3h2x2(:,47),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMB,G2H2(7),n2h2(59))
  call Hloop_VA_Q(ntryL,G1H4(18),ex2(:),G1H2(21),m3h2x2(:,48),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(21),23,nMB,G2H2(8),n2h2(60))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(28),mass4set(:,5),  & 
G1H2(28),G1H2(31),G1H2(37),G1H2(38),G1H2(15),G0H2(1),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hloop_VQ_A(ntryL,G1H4(8),ex1(:),G1H2(39),m3h2x2(:,49),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMB,G2H2(10),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H4(29),ex1(:),G1H2(5),m3h2x2(:,50),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(30),n2h2(62))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(33),mass4set(:,5),  & 
G1H2(51),G1H2(11),G1H2(54),G1H2(42),G1H2(6),G0H2(2),2)
  call HG1shiftOLR(G1H2(11),4,2)
  call Hloop_AS_Q(ntryL,G1H2(16),ex3(:),G1H2(12),ngH,m3h1x2(:,17),heltab2x2(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(12),23,nMB,G2H2(14),n2h2(63))
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(28),mass4set(:,5),  & 
G1H2(17),G1H2(18),G1H2(23),G1H2(24),G1H2(41),G0H2(3),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(11),m3h2x1(:,47),heltab2x2(:,:,64))
  call Hloop_A_Q(ntryL,G1H1(11),27,nMB,G2H1(4),n2h1(50))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(33),mass4set(:,5),  & 
G1H2(1),G1H2(27),G1H2(2),G1H2(3),G1H2(21),G0H2(4),2)
  call HG1shiftOLR(G1H2(27),4,2)
  call Hloop_VQ_A(ntryL,G1H2(29),ex1(:),G1H1(22),m3h2x1(:,48),heltab2x2(:,:,65))
  call Hloop_Q_A(ntryL,G1H1(22),27,nMB,G2H1(6),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(30),ex1(:),G1H1(42),m3h2x1(:,49),heltab2x2(:,:,66))
  call Hloop_Q_A(ntryL,G1H1(42),27,nMB,G2H1(8),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(26),m3h2x1(:,50),heltab2x2(:,:,67))
  call Hloop_A_Q(ntryL,G1H1(26),27,nMB,G2H1(9),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(4),m3h2x1(:,51),heltab2x2(:,:,68))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(11),n2h1(54))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(10),mass4set(:,6),  & 
G1H4(5),G1H4(28),G1H4(23),G1H4(32),G1H4(10),4)
  call HG1shiftOLR(G1H4(28),2,4)
  call Hloop_QV_A(ntryL,G1H4(24),ex4(:),G1H2(39),m3h2x2(:,51),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMB,G2H2(25),n2h2(64))
  call Hloop_QV_A(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,52),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(16),n2h2(65))
  call Hloop_QV_A(ntryL,G1H4(30),ex4(:),G1H2(16),m3h2x2(:,53),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(38),n2h2(66))
  call Hloop_QV_A(ntryL,G1H4(31),ex4(:),G1H2(12),m3h2x2(:,54),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(39),n2h2(67))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(13),mass4set(:,6),  & 
G1H2(50),G1H2(29),G1H2(30),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(29),2,2)
  call Hloop_QS_A(ntryL,G1H2(47),ex3(:),G1H2(39),ngH,m3h1x2(:,18),heltab2x2(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMB,G2H2(1),n2h2(68))
  call Hloop_QS_A(ntryL,G1H2(48),ex3(:),G1H2(5),ngH,m3h1x2(:,19),heltab2x2(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(40),n2h2(69))
  call Hloop_QS_A(ntryL,G1H2(52),ex3(:),G1H2(16),ngH,m3h1x2(:,20),heltab2x2(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(41),n2h2(70))
  call Hloop_QS_A(ntryL,G1H2(53),ex3(:),G1H2(12),ngH,m3h1x2(:,21),heltab2x2(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(42),n2h2(71))
  call Hloop_AQ_V(ntryL,G2H4(1),ex1(:),G2H2(43),m3h2x2(:,55),heltab2x4(:,:,70))
  call Hloop_QA_V(ntryL,G2H4(3),ex2(:),G2H2(44),m3h2x2(:,56),heltab2x4(:,:,71))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(33),mass4set(:,7),  & 
G1H2(47),G1H2(39),G1H2(48),G1H2(5),G1H2(52),G0H2(5),2)
  call HG1shiftOLR(G1H2(39),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(33),mass4set(:,8),  & 
G1H2(16),G1H2(53),G1H2(12),G1H2(90),G1H2(91),G0H2(6),2)
  call HG1shiftOLR(G1H2(53),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(33),mass4set(:,7),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),G0H2(7),2)
  call HG1shiftOLR(G1H2(93),4,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(33),mass4set(:,8),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G0H2(8),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(28),mass4set(:,7),  & 
G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),G0H2(9),2)
  call HG1shiftOLR(G1H2(103),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(28),mass4set(:,8),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G0H2(10),2)
  call HG1shiftOLR(G1H2(108),8,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(28),mass4set(:,7),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),G0H2(11),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(28),mass4set(:,8),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G0H2(12),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(25),mass4set(:,7),  & 
G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),G0H8(1),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(25),mass4set(:,8),  & 
G1H8(13),G1H8(14),G1H8(2),G1H8(15),G1H8(3),G0H8(2),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(25),mass4set(:,7),  & 
G1H8(16),G1H8(1),G1H8(17),G1H8(4),G1H8(18),G0H8(3),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(25),mass4set(:,8),  & 
G1H8(5),G1H8(19),G1H8(20),G1H8(21),G1H8(22),G0H8(4),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(25),mass4set(:,5),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),G0H8(5),8)
  call HG1shiftOLR(G1H8(24),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(25),mass4set(:,5),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),G0H8(6),8)
  call HG1shiftOLR(G1H8(29),8,8)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(9),mass4set(:,1),  & 
G1H4(20),G1H4(6),G1H4(9),G1H4(11),G1H4(3),4)
  call HG1shiftOLR(G1H4(6),5,4)
  call Hloop_UV_W(ntryL,G1H4(1),18,ex4(:),8,G2H2(4),m3h2x2(:,57),heltab2x4(:,:,72))
  call Hloop_VQ_A(ntryL,G1H4(22),wf2(:,2),G1H2(122),m3h2x2(:,58),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(122),23,nMB,G2H2(6),n2h2(72))
  call Hloop_AQ_V(ntryL,G2H4(10),wf2(:,2),G2H2(9),m3h2x2(:,59),heltab2x4(:,:,74))
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(3),mass4set(:,1),  & 
G1H4(12),G1H4(15),G1H4(19),G1H4(7),G1H4(18),4)
  call HG1shiftOLR(G1H4(15),6,4)
  call Hloop_UV_W(ntryL,G1H4(27),17,ex4(:),8,G2H2(13),m3h2x2(:,60),heltab2x4(:,:,75))
  call Hloop_VA_Q(ntryL,G1H4(2),wf2(:,4),G1H2(122),m3h2x2(:,61),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(122),23,nMB,G2H2(17),n2h2(73))
  call Hloop_QA_V(ntryL,G2H4(14),wf2(:,4),G2H2(20),m3h2x2(:,62),heltab2x4(:,:,77))
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(4),mass4set(:,1),  & 
G1H4(8),G1H4(29),G1H4(24),G1H4(26),G1H4(30),4)
  call HG1shiftOLR(G1H4(29),9,4)
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(2),m3h2x4(:,29),heltab2x8(:,:,51))
  call Hloop_VQ_A(ntryL,G1H4(13),wf4(:,10),G1H1(27),m3h4x1(:,1),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H1(27),27,nMB,G2H1(12),n2h1(55))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(2),mass4set(:,1),  & 
G1H4(31),G1H4(1),G1H4(22),G1H4(27),G1H4(2),4)
  call HG1shiftOLR(G1H4(1),10,4)
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(8),m3h2x4(:,30),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H4(25),wf4(:,2),G1H1(9),m3h4x1(:,2),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H1(9),27,nMB,G2H1(14),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(57),ex1(:),G1H1(32),m3h2x1(:,52),heltab2x2(:,:,73))
  call Hloop_Q_A(ntryL,G1H1(32),27,nMB,G2H1(15),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H2(58),ex2(:),G1H1(5),m3h2x1(:,53),heltab2x2(:,:,74))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(16),n2h1(58))
  call Hloop_AS_Q(ntryL,G1H2(63),ex3(:),G1H2(122),ngH,m3h1x2(:,22),heltab2x2(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(122),30,nMB,G2H2(21),n2h2(74))
call HGT_raise_alpha_OLR(G1H2(64),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(64),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(64),ex1(:),G1H1(33),m3h2x1(:,54),heltab2x2(:,:,76))
  call Hloop_AS_Q(ntryL,G1H2(69),ex3(:),G1H2(57),ngH,m3h1x2(:,23),heltab2x2(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(57),30,nMB,G2H2(24),n2h2(76))
  call Hloop_AS_Q(ntryL,G1H2(74),ex3(:),G1H2(58),ngH,m3h1x2(:,24),heltab2x2(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(58),30,nMB,G2H2(45),n2h2(77))
  call Hloop_QS_A(ntryL,G1H2(75),ex3(:),G1H2(63),ngH,m3h1x2(:,25),heltab2x2(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(63),29,nMB,G2H2(46),n2h2(78))
call HGT_raise_alpha_OLR(G1H2(79),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(79),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(79),ex2(:),G1H1(20),m3h2x1(:,55),heltab2x2(:,:,80))
  call Hloop_QS_A(ntryL,G1H2(85),ex3(:),G1H2(122),ngH,m3h1x2(:,26),heltab2x2(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(122),29,nMB,G2H2(47),n2h2(80))
  call Hloop_QS_A(ntryL,G1H2(86),ex3(:),G1H2(64),ngH,m3h1x2(:,27),heltab2x2(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(64),29,nMB,G2H2(48),n2h2(81))
  call Hloop_QV_A(ntryL,G1H4(16),ex4(:),G1H2(69),m3h2x2(:,63),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(69),29,nMB,G2H2(49),n2h2(82))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex2(:),G1H2(57),m3h2x2(:,64),heltab2x4(:,:,81))
  call Hloop_QV_A(ntryL,G1H4(4),ex4(:),G1H2(74),m3h2x2(:,65),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(74),29,nMB,G2H2(50),n2h2(83))
  call Hloop_QV_A(ntryL,G1H4(17),ex4(:),G1H2(58),m3h2x2(:,66),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(58),29,nMB,G2H2(51),n2h2(84))
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(75),ngH,m3h1x2(:,28),heltab2x2(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(75),29,nMB,G2H2(52),n2h2(85))
call HGT_raise_alpha_OLR(G1H2(8),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(37),m3h2x1(:,56),heltab2x2(:,:,84))
  call Hloop_QS_A(ntryL,G1H2(73),ex3(:),G1H2(63),ngH,m3h1x2(:,29),heltab2x2(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(63),29,nMB,G2H2(53),n2h2(87))
  call Hloop_QS_A(ntryL,G1H2(84),ex3(:),G1H2(79),ngH,m3h1x2(:,30),heltab2x2(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(79),29,nMB,G2H2(54),n2h2(88))
  call Hloop_QS_A(ntryL,G1H2(28),ex3(:),G1H2(85),ngH,m3h1x2(:,31),heltab2x2(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(85),23,nMB,G2H2(55),n2h2(89))
call HGT_OLR(G1H2(31),1,1,2)
call HGT_invQ_OLR(G1H2(31),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(31),-8,nMB,G2H2(56),n2h2(90))
  call Hloop_AV_Q(ntryL,G2H2(56),ex4(:),G2H1(17),m3h2x1(:,57),heltab2x2(:,:,88))
  call Hloop_QS_A(ntryL,G1H2(38),ex3(:),G1H2(122),ngH,m3h1x2(:,32),heltab2x2(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(122),23,nMB,G2H2(56),n2h2(91))
  call Hloop_QS_A(ntryL,G1H2(15),ex3(:),G1H2(86),ngH,m3h1x2(:,33),heltab2x2(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(86),23,nMB,G2H2(57),n2h2(92))
  call Hloop_QS_A(ntryL,G0H2(1),ex3(:),G0H2(13),ngH,m3h1x2(:,34),heltab2x2(:,:,91))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMB,G1H2(64),n2h2(93))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(15),m3h2x1(:,58),heltab2x2(:,:,92))
  call Hloop_Q_A(ntryL,G1H1(15),27,nMB,G2H1(18),n2h1(59))
call HGT_OLR(G1H2(11),1,1,2)
call HGT_invQ_OLR(G1H2(11),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(11),-4,nMB,G2H2(58),n2h2(94))
  call Hloop_AS_Q(ntryL,G2H2(58),ex3(:),G2H2(59),ngH,m3h1x2(:,35),heltab2x2(:,:,93))
  call Hloop_QV_A(ntryL,G1H2(42),ex4(:),G1H1(38),m3h2x1(:,59),heltab2x2(:,:,94))
  call Hloop_Q_A(ntryL,G1H1(38),27,nMB,G2H1(19),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(6),ex4(:),G1H1(10),m3h2x1(:,60),heltab2x2(:,:,95))
  call Hloop_Q_A(ntryL,G1H1(10),27,nMB,G2H1(20),n2h1(61))
  call Hloop_QV_A(ntryL,G0H2(2),ex4(:),G0H1(1),m3h2x1(:,61),heltab2x2(:,:,96))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(43),n2h1(62))
  call Hloop_AS_Q(ntryL,G1H2(17),ex3(:),G1H2(69),ngH,m3h1x2(:,36),heltab2x2(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(69),23,nMB,G2H2(58),n2h2(95))
call HGT_OLR(G1H2(18),1,1,2)
call HGT_invQ_OLR(G1H2(18),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(18),-8,nMB,G2H2(60),n2h2(96))
  call Hloop_QV_A(ntryL,G2H2(60),ex4(:),G2H1(21),m3h2x1(:,62),heltab2x2(:,:,98))
  call Hloop_AS_Q(ntryL,G1H2(24),ex3(:),G1H2(74),ngH,m3h1x2(:,37),heltab2x2(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(74),23,nMB,G2H2(60),n2h2(97))
  call Hloop_AS_Q(ntryL,G1H2(41),ex3(:),G1H2(58),ngH,m3h1x2(:,38),heltab2x2(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(58),23,nMB,G2H2(61),n2h2(98))
  call Hloop_AS_Q(ntryL,G0H2(3),ex3(:),G0H2(1),ngH,m3h1x2(:,39),heltab2x2(:,:,101))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(13),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H2(1),ex4(:),G1H1(16),m3h2x1(:,63),heltab2x2(:,:,102))
  call Hloop_A_Q(ntryL,G1H1(16),27,nMB,G2H1(22),n2h1(63))
call HGT_OLR(G1H2(27),1,1,2)
call HGT_invQ_OLR(G1H2(27),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(27),-4,nMB,G2H2(62),n2h2(100))
  call Hloop_QS_A(ntryL,G2H2(62),ex3(:),G2H2(63),ngH,m3h1x2(:,40),heltab2x2(:,:,103))
  call Hloop_AV_Q(ntryL,G1H2(3),ex4(:),G1H1(44),m3h2x1(:,64),heltab2x2(:,:,104))
  call Hloop_A_Q(ntryL,G1H1(44),27,nMB,G2H1(23),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(31),m3h2x1(:,65),heltab2x2(:,:,105))
  call Hloop_A_Q(ntryL,G1H1(31),27,nMB,G2H1(24),n2h1(65))
  call Hloop_AV_Q(ntryL,G0H2(4),ex4(:),G0H1(1),m3h2x1(:,66),heltab2x2(:,:,106))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(21),n2h1(66))
  call Hloop_QV_A(ntryL,G1H4(5),ex4(:),G1H2(75),m3h2x2(:,67),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(75),29,nMB,G2H2(62),n2h2(101))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(8),m3h2x2(:,68),heltab2x4(:,:,85))
  call Hloop_QV_A(ntryL,G1H4(32),ex4(:),G1H2(73),m3h2x2(:,69),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(73),29,nMB,G2H2(64),n2h2(102))
  call Hloop_QV_A(ntryL,G1H4(10),ex4(:),G1H2(63),m3h2x2(:,70),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(63),29,nMB,G2H2(65),n2h2(103))
  call Hloop_QS_A(ntryL,G1H2(50),ex3(:),G1H2(84),ngH,m3h1x2(:,41),heltab2x2(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(84),29,nMB,G2H2(66),n2h2(104))
call HGT_raise_alpha_OLR(G1H2(29),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(29),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(29),ex2(:),G1H1(11),m3h2x1(:,67),heltab2x2(:,:,108))
  call Hloop_QS_A(ntryL,G1H2(35),ex3(:),G1H2(79),ngH,m3h1x2(:,42),heltab2x2(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(79),29,nMB,G2H2(67),n2h2(106))
  call Hloop_QS_A(ntryL,G1H2(36),ex3(:),G1H2(28),ngH,m3h1x2(:,43),heltab2x2(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(28),29,nMB,G2H2(68),n2h2(107))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(22),m3h2x1(:,68),heltab2x2(:,:,111))
  call Hloop_Q_A(ntryL,G1H1(22),27,nMC,G2H1(25),n2h1(67))
call HGT_OLR(G1H2(39),1,1,2)
call HGT_invQ_OLR(G1H2(39),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(39),-4,nMC,G2H2(69),n2h2(108))
  call Hloop_AS_Q(ntryL,G2H2(69),ex3(:),G2H2(70),ngH,m3h1x2(:,44),heltab2x2(:,:,112))
  call Hloop_QV_A(ntryL,G1H2(5),ex4(:),G1H1(42),m3h2x1(:,69),heltab2x2(:,:,113))
  call Hloop_Q_A(ntryL,G1H1(42),27,nMC,G2H1(26),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(26),m3h2x1(:,70),heltab2x2(:,:,114))
  call Hloop_Q_A(ntryL,G1H1(26),27,nMC,G2H1(27),n2h1(69))
  call Hloop_QV_A(ntryL,G0H2(5),ex4(:),G0H1(1),m3h2x1(:,71),heltab2x2(:,:,115))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMC,G1H1(4),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(16),ex4(:),G1H1(27),m3h2x1(:,72),heltab2x2(:,:,116))
  call Hloop_Q_A(ntryL,G1H1(27),27,nMT,G2H1(28),n2h1(71))
call HGT_OLR(G1H2(53),1,1,2)
call HGT_invQ_OLR(G1H2(53),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(53),-4,nMT,G2H2(69),n2h2(109))
  call Hloop_AS_Q(ntryL,G2H2(69),ex3(:),G2H2(71),ngH,m3h1x2(:,45),heltab2x2(:,:,117))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(9),m3h2x1(:,73),heltab2x2(:,:,118))
  call Hloop_Q_A(ntryL,G1H1(9),27,nMT,G2H1(29),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(32),m3h2x1(:,74),heltab2x2(:,:,119))
  call Hloop_Q_A(ntryL,G1H1(32),27,nMT,G2H1(30),n2h1(73))
  call Hloop_QV_A(ntryL,G0H2(6),ex4(:),G0H1(1),m3h2x1(:,75),heltab2x2(:,:,120))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(5),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(92),ex4(:),G1H1(15),m3h2x1(:,76),heltab2x2(:,:,121))
  call Hloop_A_Q(ntryL,G1H1(15),27,nMC,G2H1(31),n2h1(75))
call HGT_OLR(G1H2(93),1,1,2)
call HGT_invQ_OLR(G1H2(93),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(93),-4,nMC,G2H2(69),n2h2(110))
  call Hloop_QS_A(ntryL,G2H2(69),ex3(:),G2H2(72),ngH,m3h1x2(:,46),heltab2x2(:,:,122))
  call Hloop_AV_Q(ntryL,G1H2(95),ex4(:),G1H1(38),m3h2x1(:,77),heltab2x2(:,:,123))
  call Hloop_A_Q(ntryL,G1H1(38),27,nMC,G2H1(32),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(96),ex4(:),G1H1(10),m3h2x1(:,78),heltab2x2(:,:,124))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMC,G2H1(33),n2h1(77))
  call Hloop_AV_Q(ntryL,G0H2(7),ex4(:),G0H1(1),m3h2x1(:,79),heltab2x2(:,:,125))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMC,G1H1(16),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(97),ex4(:),G1H1(44),m3h2x1(:,80),heltab2x2(:,:,126))
  call Hloop_A_Q(ntryL,G1H1(44),27,nMT,G2H1(34),n2h1(79))
call HGT_OLR(G1H2(98),1,1,2)
call HGT_invQ_OLR(G1H2(98),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(98),-4,nMT,G2H2(69),n2h2(111))
  call Hloop_QS_A(ntryL,G2H2(69),ex3(:),G2H2(73),ngH,m3h1x2(:,47),heltab2x2(:,:,127))
  call Hloop_AV_Q(ntryL,G1H2(100),ex4(:),G1H1(31),m3h2x1(:,81),heltab2x2(:,:,128))
  call Hloop_A_Q(ntryL,G1H1(31),27,nMT,G2H1(35),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(22),m3h2x1(:,82),heltab2x2(:,:,129))
  call Hloop_A_Q(ntryL,G1H1(22),27,nMT,G2H1(36),n2h1(81))
  call Hloop_AV_Q(ntryL,G0H2(8),ex4(:),G0H1(1),m3h2x1(:,83),heltab2x2(:,:,130))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(42),n2h1(82))
  call Hloop_AS_Q(ntryL,G1H2(102),ex3(:),G1H2(85),ngH,m3h1x2(:,48),heltab2x2(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(85),23,nMC,G2H2(69),n2h2(112))
call HGT_OLR(G1H2(103),1,1,2)
call HGT_invQ_OLR(G1H2(103),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(103),-8,nMC,G2H2(74),n2h2(113))
  call Hloop_QV_A(ntryL,G2H2(74),ex4(:),G2H1(37),m3h2x1(:,84),heltab2x2(:,:,132))
  call Hloop_AS_Q(ntryL,G1H2(105),ex3(:),G1H2(31),ngH,m3h1x2(:,49),heltab2x2(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(31),23,nMC,G2H2(74),n2h2(114))
  call Hloop_AS_Q(ntryL,G1H2(106),ex3(:),G1H2(38),ngH,m3h1x2(:,50),heltab2x2(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMC,G2H2(75),n2h2(115))
  call Hloop_AS_Q(ntryL,G0H2(9),ex3(:),G0H2(13),ngH,m3h1x2(:,51),heltab2x2(:,:,135))
  call Hloop_A_Q(ntryL,G0H2(13),23,nMC,G1H2(122),n2h2(116))
  call Hloop_AS_Q(ntryL,G1H2(107),ex3(:),G1H2(15),ngH,m3h1x2(:,52),heltab2x2(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(15),23,nMT,G2H2(76),n2h2(117))
call HGT_OLR(G1H2(108),1,1,2)
call HGT_invQ_OLR(G1H2(108),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(108),-8,nMT,G2H2(77),n2h2(118))
  call Hloop_QV_A(ntryL,G2H2(77),ex4(:),G2H1(38),m3h2x1(:,85),heltab2x2(:,:,137))
  call Hloop_AS_Q(ntryL,G1H2(110),ex3(:),G1H2(86),ngH,m3h1x2(:,53),heltab2x2(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(86),23,nMT,G2H2(77),n2h2(119))
  call Hloop_AS_Q(ntryL,G1H2(111),ex3(:),G1H2(51),ngH,m3h1x2(:,54),heltab2x2(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(51),23,nMT,G2H2(78),n2h2(120))
  call Hloop_AS_Q(ntryL,G0H2(10),ex3(:),G0H2(2),ngH,m3h1x2(:,55),heltab2x2(:,:,140))
  call Hloop_A_Q(ntryL,G0H2(2),23,nMT,G1H2(11),n2h2(121))
  call Hloop_QS_A(ntryL,G1H2(112),ex3(:),G1H2(42),ngH,m3h1x2(:,56),heltab2x2(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMC,G2H2(79),n2h2(122))
call HGT_OLR(G1H2(113),1,1,2)
call HGT_invQ_OLR(G1H2(113),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(113),-8,nMC,G2H2(80),n2h2(123))
  call Hloop_AV_Q(ntryL,G2H2(80),ex4(:),G2H1(39),m3h2x1(:,86),heltab2x2(:,:,142))
  call Hloop_QS_A(ntryL,G1H2(115),ex3(:),G1H2(6),ngH,m3h1x2(:,57),heltab2x2(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMC,G2H2(80),n2h2(124))
  call Hloop_QS_A(ntryL,G1H2(116),ex3(:),G1H2(17),ngH,m3h1x2(:,58),heltab2x2(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMC,G2H2(81),n2h2(125))
  call Hloop_QS_A(ntryL,G0H2(11),ex3(:),G0H2(3),ngH,m3h1x2(:,59),heltab2x2(:,:,145))
  call Hloop_Q_A(ntryL,G0H2(3),23,nMC,G1H2(69),n2h2(126))
  call Hloop_QS_A(ntryL,G1H2(117),ex3(:),G1H2(18),ngH,m3h1x2(:,60),heltab2x2(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(18),23,nMT,G2H2(82),n2h2(127))
call HGT_OLR(G1H2(118),1,1,2)
call HGT_invQ_OLR(G1H2(118),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(118),-8,nMT,G2H2(83),n2h2(128))
  call Hloop_AV_Q(ntryL,G2H2(83),ex4(:),G2H1(40),m3h2x1(:,87),heltab2x2(:,:,147))
  call Hloop_QS_A(ntryL,G1H2(120),ex3(:),G1H2(24),ngH,m3h1x2(:,61),heltab2x2(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMT,G2H2(83),n2h2(129))
  call Hloop_QS_A(ntryL,G1H2(121),ex3(:),G1H2(74),ngH,m3h1x2(:,62),heltab2x2(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(74),23,nMT,G2H2(84),n2h2(130))
  call Hloop_QS_A(ntryL,G0H2(12),ex3(:),G0H2(1),ngH,m3h1x2(:,63),heltab2x2(:,:,150))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(41),n2h2(131))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,16),G1H2(58),m3h4x2(:,13),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMC,G2H2(85),n2h2(132))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(9),-8,nMC,G2H8(1),n2h8(47))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(13),m3h2x4(:,31),heltab2x8(:,:,54))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,16),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMC,G2H2(86),n2h2(133))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,16),G1H2(27),m3h4x2(:,15),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMC,G2H2(87),n2h2(134))
  call Hloop_QV_A(ntryL,G0H8(1),wf4(:,16),G0H2(4),m3h4x2(:,16),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G0H2(4),23,nMC,G1H2(3),n2h2(135))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,16),G1H2(21),m3h4x2(:,17),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(88),n2h2(136))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-8,nMT,G2H8(2),n2h8(48))
  call Hloop_AV_Q(ntryL,G2H8(2),ex4(:),G2H4(9),m3h2x4(:,32),heltab2x8(:,:,59))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,16),G1H2(75),m3h4x2(:,18),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(75),23,nMT,G2H2(89),n2h2(137))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,16),G1H2(73),m3h4x2(:,19),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(73),23,nMT,G2H2(90),n2h2(138))
  call Hloop_QV_A(ntryL,G0H8(2),wf4(:,16),G0H2(5),m3h4x2(:,20),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G0H2(5),23,nMT,G1H2(63),n2h2(139))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,16),G1H2(50),m3h4x2(:,21),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(50),23,nMC,G2H2(91),n2h2(140))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-8,nMC,G2H8(3),n2h8(49))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(12),m3h2x4(:,33),heltab2x8(:,:,64))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,16),G1H2(84),m3h4x2(:,22),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(84),23,nMC,G2H2(92),n2h2(141))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,16),G1H2(29),m3h4x2(:,23),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMC,G2H2(93),n2h2(142))
  call Hloop_AV_Q(ntryL,G0H8(3),wf4(:,16),G0H2(6),m3h4x2(:,24),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G0H2(6),23,nMC,G1H2(35),n2h2(143))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,16),G1H2(79),m3h4x2(:,25),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(79),23,nMT,G2H2(94),n2h2(144))
call HGT_OLR(G1H8(19),1,1,8)
call HGT_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(19),-8,nMT,G2H8(4),n2h8(50))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(4),m3h2x4(:,34),heltab2x8(:,:,69))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,16),G1H2(36),m3h4x2(:,26),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(36),23,nMT,G2H2(95),n2h2(145))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,16),G1H2(28),m3h4x2(:,27),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMT,G2H2(96),n2h2(146))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,16),G0H2(7),m3h4x2(:,28),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G0H2(7),23,nMT,G1H2(47),n2h2(147))
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,16),G1H2(39),m3h4x2(:,29),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMB,G2H2(97),n2h2(148))
call HGT_OLR(G1H8(24),1,1,8)
call HGT_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(24),-8,nMB,G2H8(5),n2h8(51))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(1),m3h2x4(:,35),heltab2x8(:,:,74))
  call Hloop_QV_A(ntryL,G1H8(26),wf4(:,16),G1H2(5),m3h4x2(:,30),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(98),n2h2(149))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,16),G1H2(52),m3h4x2(:,31),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(52),23,nMB,G2H2(99),n2h2(150))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,16),G0H2(8),m3h4x2(:,32),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G0H2(8),23,nMB,G1H2(16),n2h2(151))
  call Hloop_AV_Q(ntryL,G1H8(28),wf4(:,16),G1H2(53),m3h4x2(:,33),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMB,G2H2(100),n2h2(152))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(29),-8,nMB,G2H8(6),n2h8(52))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(3),m3h2x4(:,36),heltab2x8(:,:,79))
  call Hloop_AV_Q(ntryL,G1H8(31),wf4(:,16),G1H2(90),m3h4x2(:,34),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(90),23,nMB,G2H2(101),n2h2(153))
  call Hloop_AV_Q(ntryL,G1H8(32),wf4(:,16),G1H2(91),m3h4x2(:,35),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(91),23,nMB,G2H2(102),n2h2(154))
  call Hloop_AV_Q(ntryL,G0H8(6),wf4(:,16),G0H2(9),m3h4x2(:,36),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G0H2(9),23,nMB,G1H2(92),n2h2(155))
  call Hloop_AV_Q(ntryL,G1H4(20),ex4(:),G1H2(93),m3h2x2(:,71),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(93),26,nMB,G2H2(103),n2h2(156))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(6),wf2(:,2),G1H2(95),m3h2x2(:,72),heltab2x4(:,:,89))
  call Hloop_AV_Q(ntryL,G1H4(11),ex4(:),G1H2(96),m3h2x2(:,73),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(96),26,nMB,G2H2(104),n2h2(157))
  call Hloop_AV_Q(ntryL,G1H4(3),ex4(:),G1H2(97),m3h2x2(:,74),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(97),26,nMB,G2H2(105),n2h2(158))
  call Hloop_QV_A(ntryL,G1H4(12),ex4(:),G1H2(98),m3h2x2(:,75),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(98),25,nMB,G2H2(106),n2h2(159))
call HGT_raise_alpha_OLR(G1H4(15),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(15),wf2(:,4),G1H2(100),m3h2x2(:,76),heltab2x4(:,:,93))
  call Hloop_QV_A(ntryL,G1H4(7),ex4(:),G1H2(101),m3h2x2(:,77),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(101),25,nMB,G2H2(107),n2h2(160))
  call Hloop_QV_A(ntryL,G1H4(18),ex4(:),G1H2(102),m3h2x2(:,78),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(102),25,nMB,G2H2(108),n2h2(161))
  call Hloop_AS_Q(ntryL,G1H4(8),ex3(:),G1H4(13),ngH,m3h1x4(:,16),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(13),22,nMB,G2H4(7),n2h4(45))
call HGT_raise_alpha_OLR(G1H4(29),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(29),wf4(:,10),G1H1(26),m3h4x1(:,3),heltab2x4(:,:,97))
  call Hloop_AS_Q(ntryL,G1H4(26),ex3(:),G1H4(25),ngH,m3h1x4(:,17),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(25),22,nMB,G2H4(10),n2h4(47))
  call Hloop_AS_Q(ntryL,G1H4(30),ex3(:),G1H4(16),ngH,m3h1x4(:,18),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(16),22,nMB,G2H4(11),n2h4(48))
  call Hloop_QS_A(ntryL,G1H4(31),ex3(:),G1H4(14),ngH,m3h1x4(:,19),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(14),21,nMB,G2H4(14),n2h4(49))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(1),wf4(:,2),G1H1(27),m3h4x1(:,4),heltab2x4(:,:,101))
  call Hloop_QS_A(ntryL,G1H4(27),ex3(:),G1H4(4),ngH,m3h1x4(:,20),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(4),21,nMB,G2H4(5),n2h4(51))
  call Hloop_QS_A(ntryL,G1H4(2),ex3(:),G1H4(17),ngH,m3h1x4(:,21),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(6),n2h4(52))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(2),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(5),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(12),G1H2(49)])
call HGT_OLR(G2H1(1),1,1,1)
call HGT_invQ_OLR(G2H1(1),2,5,1)
call HGT_OLR(G2H1(1),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G2H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(15),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(19),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(70)])
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G2H1(10),G2H1(3),G1H1(30),G1H1(8)])
call HGT_OLR(G2H1(5),1,1,1)
call HGT_invQ_OLR(G2H1(5),2,5,1)
call HGT_OLR(G2H1(5),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G2H1(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(23),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(19)])
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(14),[G2H1(13),G2H1(7),G1H1(41),G1H1(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(59)])
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(29)])
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(36),G2H2(32),G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(6)])
call HGT_w2_OLR(G1H1(1),1,1,1)
call HGT_w2_invQ_OLR(G1H1(1),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(1)])
call HGT_w2_OLR(G1H1(2),1,1,1)
call HGT_w2_invQ_OLR(G1H1(2),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(2),[G1H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(20),[G1H1(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(36),[G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G1H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(47),[G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(42)])
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(18),mass4set(:,9),  & 
G1H2(85),G1H2(103),G1H2(105),G1H2(31),G1H2(106),2)
  call HG1shiftOLR(G1H2(103),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(22),mass4set(:,9),  & 
G1H2(38),G1H2(107),G1H2(15),G1H2(108),G1H2(110),2)
  call HG1shiftOLR(G1H2(107),8,2)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(49),mass4set(:,2),  & 
G1H2(86),G1H2(111),G1H2(51),G1H2(112),G1H2(42),2)
  call HG1shiftOLR(G1H2(111),2,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(25),mass4set(:,5),  & 
G1H2(113),G1H2(115),G1H2(6),G1H2(116),G1H2(17),2)
  call HG1shiftOLR(G1H2(115),8,2)
  call Hotf_4pt_reduction(G2H1(1),RedSet_4(50),mass4set(:,3),  & 
G1H1(9),G1H1(32),G1H1(15),G1H1(38),G1H1(10),1)
  call HG1shiftOLR(G1H1(32),4,1)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(18),mass4set(:,3),  & 
G1H2(117),G1H2(18),G1H2(118),G1H2(120),G1H2(24),2)
  call HG1shiftOLR(G1H2(18),8,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(51),mass4set(:,2),  & 
G1H2(121),G1H2(74),G1H2(58),G1H2(1),G1H2(27),2)
  call HG1shiftOLR(G1H2(74),1,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(25),mass4set(:,5),  & 
G1H2(21),G1H2(75),G1H2(73),G1H2(50),G1H2(84),2)
  call HG1shiftOLR(G1H2(75),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(30),mass4set(:,3),  & 
G1H2(29),G1H2(79),G1H2(36),G1H2(28),G1H2(39),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(34),mass4set(:,3),  & 
G1H1(44),G1H1(31),G1H1(22),G1H1(30),G1H1(8),1)
  call HG1shiftOLR(G1H1(31),4,1)
  call Hotf_4pt_reduction(G2H1(5),RedSet_4(52),mass4set(:,3),  & 
G1H1(41),G1H1(19),G1H1(6),G1H1(1),G1H1(12),1)
  call HG1shiftOLR(G1H1(19),4,1)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(22),mass4set(:,3),  & 
G1H2(5),G1H2(52),G1H2(53),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(24),mass4set(:,3),  & 
G1H2(93),G1H2(96),G1H2(97),G1H2(98),G1H2(101),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_4pt_reduction(G2H1(14),RedSet_4(39),mass4set(:,3),  & 
G1H1(7),G1H1(13),G1H1(14),G1H1(17),G1H1(18),1)
  call HG1shiftOLR(G1H1(13),4,1)
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(53),mass4set(:,4),  & 
G1H2(102),G1H2(26),G1H2(9),G1H2(49),G1H2(61),2)
  call HG1shiftOLR(G1H2(26),1,2)
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(54),mass4set(:,4),  & 
G1H2(72),G1H2(70),G1H2(83),G1H2(19),G1H2(59),2)
  call HG1shiftOLR(G1H2(70),2,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(27),mass4set(:,10),  & 
G1H2(4),G1H2(65),G1H2(22),G1H2(25),G1H2(44),2)
  call HG1shiftOLR(G1H2(65),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex2(:),G2tensor(1),m3h2x1(:,88),heltab2x2(:,:,151))
  call Hloop_QV_A(ntryL,G1H2(10),ex4(:),G1H1(24),m3h2x1(:,89),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(3),n2h1(83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex2(:),G2tensor(5),m3h2x1(:,90),heltab2x2(:,:,153))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(14),ex4(:),G1H1(25),m3h2x1(:,91),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),8,nMB,G2tensor(9),n2h1(84))
  call Hotf_4pt_reduction(G2H1(2),RedSet_4(32),mass4set(:,10),  & 
G1H1(28),G1H1(29),G1H1(39),G1H1(40),G1H1(24),1)
  call HG1shiftOLR(G1H1(29),4,1)
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(25),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(13),n2h1(85))
call HGT_w2_OLR(G1H1(3),1,1,1)
call HGT_w2_invQ_OLR(G1H1(3),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(3),ex3(:),G1H1(2),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),4,nMB,G2tensor(17),n2h1(86))
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(16),mass4set(:,11),  & 
G1H2(7),G1H2(46),G1H2(56),G1H2(60),G1H2(66),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(17),mass4set(:,9),  & 
G1H2(71),G1H2(78),G1H2(81),G1H2(82),G1H2(88),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),23,ex4(:),8,G2tensor(21),m3h2x1(:,92),heltab2x2(:,:,155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(33),23,ex4(:),8,G2tensor(25),m3h2x1(:,93),heltab2x2(:,:,156))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),23,ex4(:),8,G2tensor(29),m3h2x1(:,94),heltab2x2(:,:,157))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(20),mass4set(:,11),  & 
G1H2(10),G1H2(14),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(21),mass4set(:,9),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(43),23,ex4(:),8,G2tensor(33),m3h2x1(:,95),heltab2x2(:,:,158))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),23,ex4(:),8,G2tensor(37),m3h2x1(:,96),heltab2x2(:,:,159))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(45),23,ex4(:),8,G2tensor(41),m3h2x1(:,97),heltab2x2(:,:,160))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(21),mass4set(:,3),  & 
G1H2(43),G1H2(40),G1H2(45),G1H2(128),G1H2(129),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(25),m3h2x1(:,98),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(45),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(3),m3h2x1(:,99),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(46),n2h1(88))
  call Hloop_AV_Q(ntryL,G2H2(102),ex4(:),G2H1(15),m3h2x1(:,100),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(1),n2h1(89))
  call Hotf_4pt_reduction(G2H2(55),RedSet_4(28),mass4set(:,5),  & 
G1H2(20),G1H2(55),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(55),8,2)
  call Hloop_QV_A(ntryL,G2H2(57),ex4(:),G2H1(10),m3h2x1(:,101),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMB,G3tensor(2),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(2),m3h2x1(:,102),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(47),n2h1(91))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(17),mass4set(:,3),  & 
G1H2(67),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),8,2)
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(25),m3h2x1(:,103),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(48),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(3),m3h2x1(:,104),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(49),n2h1(93))
  call Hloop_QV_A(ntryL,G2H2(99),ex4(:),G2H1(3),m3h2x1(:,105),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMB,G3tensor(3),n2h1(94))
  call Hotf_4pt_reduction(G2H1(18),RedSet_4(33),mass4set(:,5),  & 
G1H1(2),G1H1(25),G1H1(3),G1H1(48),G1H1(49),1)
  call HG1shiftOLR(G1H1(25),4,1)
  call Hloop_QS_A(ntryL,G2H1(20),ex3(:),G2H1(16),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nMB,G3tensor(4),n2h1(95))
  call Hloop_QS_A(ntryL,G1H1(36),ex3(:),G1H1(50),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(50),n2h1(96))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(36),mass4set(:,10),  & 
G1H2(76),G1H2(77),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(28),mass4set(:,5),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(141),8,2)
  call Hloop_AV_Q(ntryL,G1H2(87),ex4(:),G1H1(36),m3h2x1(:,106),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nMB,G2tensor(51),n2h1(97))
  call Hloop_AV_Q(ntryL,G2H2(61),ex4(:),G2H1(13),m3h2x1(:,107),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nMB,G3tensor(5),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(89),ex4(:),G1H1(50),m3h2x1(:,108),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(52),n2h1(99))
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(38),mass4set(:,10),  & 
G1H1(36),G1H1(50),G1H1(51),G1H1(52),G1H1(53),1)
  call HG1shiftOLR(G1H1(50),4,1)
  call Hotf_4pt_reduction(G2H1(22),RedSet_4(33),mass4set(:,5),  & 
G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),1)
  call HG1shiftOLR(G1H1(55),4,1)
  call Hloop_AS_Q(ntryL,G1H1(23),ex3(:),G1H1(59),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),31,nMB,G2tensor(53),n2h1(100))
  call Hloop_AS_Q(ntryL,G2H1(24),ex3(:),G2H1(7),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(6),n2h1(101))
  call Hloop_AS_Q(ntryL,G1H1(47),ex3(:),G1H1(23),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(54),n2h1(102))
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(41),mass4set(:,12),  & 
G1H1(59),G1H1(47),G1H1(23),G1H1(60),G1H1(61),1)
  call HG1shiftOLR(G1H1(47),4,1)
  call Hotf_4pt_reduction(G2H1(8),RedSet_4(42),mass4set(:,3),  & 
G1H1(62),G1H1(63),G1H1(64),G1H1(65),G1H1(66),1)
  call HG1shiftOLR(G1H1(63),4,1)
  call Hloop_QS_A(ntryL,G1H1(34),ex3(:),G1H1(67),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(67),31,nMB,G2tensor(55),n2h1(103))
  call Hloop_QS_A(ntryL,G1H1(35),ex3(:),G1H1(34),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(56),n2h1(104))
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(44),mass4set(:,12),  & 
G1H1(67),G1H1(35),G1H1(34),G1H1(68),G1H1(69),1)
  call HG1shiftOLR(G1H1(35),4,1)
  call Hotf_4pt_reduction(G2H1(11),RedSet_4(45),mass4set(:,3),  & 
G1H1(70),G1H1(71),G1H1(72),G1H1(73),G1H1(74),1)
  call HG1shiftOLR(G1H1(71),4,1)
  call Hloop_AS_Q(ntryL,G1H1(45),ex3(:),G1H1(75),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(75),31,nMB,G2tensor(57),n2h1(105))
  call Hloop_AS_Q(ntryL,G1H1(46),ex3(:),G1H1(45),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(45),31,nMB,G2tensor(58),n2h1(106))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(65),ex2(:),G2tensor(59),m3h2x1(:,109),heltab2x2(:,:,172))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex2(:),G2tensor(60),m3h2x1(:,110),heltab2x2(:,:,173))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex2(:),G2tensor(61),m3h2x1(:,111),heltab2x2(:,:,174))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(62),m3h2x1(:,112),heltab2x2(:,:,175))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(9),mass4set(:,4),  & 
G1H2(87),G1H2(89),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(89),5,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(3),mass4set(:,4),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(149),6,2)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(7),mass4set(:,2),  & 
G1H4(5),G1H4(28),G1H4(32),G1H4(10),G1H4(20),4)
  call HG1shiftOLR(G1H4(28),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(5),mass4set(:,2),  & 
G1H4(6),G1H4(11),G1H4(3),G1H4(12),G1H4(15),4)
  call HG1shiftOLR(G1H4(11),10,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex1(:),G2tensor(63),m3h2x1(:,113),heltab2x2(:,:,176))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(45),ex1(:),G2tensor(64),m3h2x1(:,114),heltab2x2(:,:,177))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex2(:),G2tensor(65),m3h2x1(:,115),heltab2x2(:,:,178))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex2(:),G2tensor(66),m3h2x1(:,116),heltab2x2(:,:,179))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex2(:),G2tensor(67),m3h2x1(:,117),heltab2x2(:,:,180))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex2(:),G2tensor(68),m3h2x1(:,118),heltab2x2(:,:,181))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(75),m3h2x1(:,119),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(75),31,nMB,G2tensor(69),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(43),ex3(:),G1H1(46),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(46),31,nMB,G2tensor(70),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(13),ex4(:),G1H1(45),m3h2x1(:,120),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(45),31,nMB,G2tensor(71),n2h1(109))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(75),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(75),31,nMB,G2tensor(72),n2h1(110))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex2(:),G2tensor(73),m3h2x1(:,121),heltab2x2(:,:,184))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(66),ex2(:),G2tensor(74),m3h2x1(:,122),heltab2x2(:,:,185))
  call Hotf_4pt_reduction(G2H1(25),RedSet_4(33),mass4set(:,7),  & 
G1H1(43),G1H1(46),G1H1(45),G1H1(21),G1H1(75),1)
  call HG1shiftOLR(G1H1(46),4,1)
  call Hloop_QS_A(ntryL,G2H1(27),ex3(:),G2H1(1),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMC,G3tensor(7),n2h1(111))
  call Hloop_QS_A(ntryL,G1H1(4),ex3(:),G1H1(76),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(76),31,nMC,G2tensor(75),n2h1(112))
  call Hotf_4pt_reduction(G2H1(28),RedSet_4(33),mass4set(:,8),  & 
G1H1(4),G1H1(76),G1H1(77),G1H1(78),G1H1(79),1)
  call HG1shiftOLR(G1H1(76),4,1)
  call Hloop_QS_A(ntryL,G2H1(30),ex3(:),G2H1(12),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(8),n2h1(113))
  call Hloop_QS_A(ntryL,G1H1(5),ex3(:),G1H1(80),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(80),31,nMT,G2tensor(76),n2h1(114))
  call Hotf_4pt_reduction(G2H1(31),RedSet_4(33),mass4set(:,7),  & 
G1H1(5),G1H1(80),G1H1(81),G1H1(82),G1H1(83),1)
  call HG1shiftOLR(G1H1(80),4,1)
  call Hloop_AS_Q(ntryL,G2H1(33),ex3(:),G2H1(5),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),31,nMC,G3tensor(9),n2h1(115))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(84),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(84),31,nMC,G2tensor(77),n2h1(116))
  call Hotf_4pt_reduction(G2H1(34),RedSet_4(33),mass4set(:,8),  & 
G1H1(16),G1H1(84),G1H1(85),G1H1(86),G1H1(87),1)
  call HG1shiftOLR(G1H1(84),4,1)
  call Hloop_AS_Q(ntryL,G2H1(36),ex3(:),G2H1(14),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,nMT,G3tensor(10),n2h1(117))
  call Hloop_AS_Q(ntryL,G1H1(42),ex3(:),G1H1(88),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(78),n2h1(118))
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(28),mass4set(:,7),  & 
G1H2(64),G1H2(13),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hloop_AV_Q(ntryL,G2H2(75),ex4(:),G2H1(2),m3h2x1(:,123),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMC,G3tensor(11),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(122),ex4(:),G1H1(42),m3h2x1(:,124),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMC,G2tensor(79),n2h1(120))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(28),mass4set(:,8),  & 
G1H2(122),G1H2(156),G1H2(157),G1H2(158),G1H2(159),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hloop_AV_Q(ntryL,G2H2(78),ex4(:),G2H1(15),m3h2x1(:,125),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMT,G3tensor(12),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H2(11),ex4(:),G1H1(88),m3h2x1(:,126),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(80),n2h1(122))
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(28),mass4set(:,7),  & 
G1H2(11),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(160),8,2)
  call Hloop_QV_A(ntryL,G2H2(81),ex4(:),G2H1(10),m3h2x1(:,127),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMC,G3tensor(13),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(42),m3h2x1(:,128),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMC,G2tensor(81),n2h1(124))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(28),mass4set(:,8),  & 
G1H2(69),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hloop_QV_A(ntryL,G2H2(84),ex4(:),G2H1(3),m3h2x1(:,129),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(14),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(41),ex4(:),G1H1(88),m3h2x1(:,130),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(82),n2h1(126))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(25),mass4set(:,7),  & 
G1H2(41),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hloop_QV_A(ntryL,G2H2(87),ex4(:),G2H1(18),m3h2x1(:,131),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(18),31,nMC,G3tensor(15),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(3),ex4(:),G1H1(42),m3h2x1(:,132),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMC,G2tensor(83),n2h1(128))
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(25),mass4set(:,8),  & 
G1H2(3),G1H2(172),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(172),8,2)
  call Hloop_QV_A(ntryL,G2H2(90),ex4(:),G2H1(20),m3h2x1(:,133),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(16),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(88),m3h2x1(:,134),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(84),n2h1(130))
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(25),mass4set(:,7),  & 
G1H2(63),G1H2(176),G1H2(177),G1H2(178),G1H2(179),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hloop_AV_Q(ntryL,G2H2(93),ex4(:),G2H1(16),m3h2x1(:,135),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nMC,G3tensor(17),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(42),m3h2x1(:,136),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMC,G2tensor(85),n2h1(132))
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(25),mass4set(:,8),  & 
G1H2(35),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(180),8,2)
  call Hloop_AV_Q(ntryL,G2H2(96),ex4(:),G2H1(13),m3h2x1(:,137),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nMT,G3tensor(18),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(47),ex4(:),G1H1(88),m3h2x1(:,138),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(86),n2h1(134))
  call Hloop_QV_A(ntryL,G1H2(16),ex4(:),G1H1(42),m3h2x1(:,139),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(87),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(92),ex4(:),G1H1(88),m3h2x1(:,140),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(88),n2h1(136))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(103),wf2(:,2),G2tensor(89),m3h2x1(:,141),heltab2x2(:,:,204))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(105),wf2(:,2),G2tensor(90),m3h2x1(:,142),heltab2x2(:,:,205))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),wf2(:,4),G2tensor(91),m3h2x1(:,143),heltab2x2(:,:,206))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),wf2(:,4),G2tensor(92),m3h2x1(:,144),heltab2x2(:,:,207))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(7),wf4(:,10),G2tensor(93),m3h4x1(:,5),heltab2x4(:,:,104))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(11),wf4(:,10),G2tensor(94),m3h4x1(:,6),heltab2x4(:,:,105))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(14),wf4(:,2),G2tensor(95),m3h4x1(:,7),heltab2x4(:,:,106))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(6),wf4(:,2),G2tensor(96),m3h4x1(:,8),heltab2x4(:,:,107))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(85),23,ex4(:),8,G2tensor(97),m3h2x1(:,145),heltab2x2(:,:,208))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(103),0,ex4(:),8,G2tensor(98),m3h2x1(:,146),heltab2x2(:,:,209))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(106),23,ex4(:),8,G2tensor(99),m3h2x1(:,147),heltab2x2(:,:,210))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),23,ex4(:),8,G2tensor(100),m3h2x1(:,148),heltab2x2(:,:,211))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(107),0,ex4(:),8,G2tensor(101),m3h2x1(:,149),heltab2x2(:,:,212))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(110),23,ex4(:),8,G2tensor(102),m3h2x1(:,150),heltab2x2(:,:,213))
  call Hloop_VA_Q(ntryL,G1H2(86),ex2(:),G1H1(42),m3h2x1(:,151),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(103),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(111),ex2(:),G1H1(88),m3h2x1(:,152),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),2,nMB,G2tensor(104),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(42),ex2(:),G1H1(42),m3h2x1(:,153),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(105),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(88),m3h2x1(:,154),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(106),n2h1(142))
  call Hloop_AV_Q(ntryL,G1H2(115),ex4(:),G1H1(42),m3h2x1(:,155),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),8,nMB,G2tensor(107),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(17),ex4(:),G1H1(88),m3h2x1(:,156),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(108),n2h1(144))
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(42),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(109),n2h1(145))
  call Hloop_QS_A(ntryL,G1H1(32),ex3(:),G1H1(88),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),4,nMB,G2tensor(110),n2h1(146))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(9),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(111),n2h1(147))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(42),m3h2x1(:,157),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(112),n2h1(148))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(32),m3h2x1(:,158),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),8,nMB,G2tensor(113),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(88),m3h2x1(:,159),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(114),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(121),ex1(:),G1H1(10),m3h2x1(:,160),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(115),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H2(74),ex1(:),G1H1(9),m3h2x1(:,161),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),1,nMB,G2tensor(116),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(42),m3h2x1(:,162),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(117),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(21),ex4(:),G1H1(32),m3h2x1(:,163),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(118),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(88),m3h2x1(:,164),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),8,nMB,G2tensor(119),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(84),ex4(:),G1H1(10),m3h2x1(:,165),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(120),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(9),m3h2x1(:,166),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(121),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(42),m3h2x1(:,167),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),8,nMB,G2tensor(122),n2h1(158))
  call Hloop_QV_A(ntryL,G1H2(39),ex4(:),G1H1(32),m3h2x1(:,168),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(123),n2h1(159))
  call Hloop_QS_A(ntryL,G1H1(44),ex3(:),G1H1(88),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(124),n2h1(160))
  call Hloop_QS_A(ntryL,G1H1(31),ex3(:),G1H1(10),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),4,nMB,G2tensor(125),n2h1(161))
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(9),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(126),n2h1(162))
  call Hloop_AS_Q(ntryL,G1H1(41),ex3(:),G1H1(42),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(127),n2h1(163))
  call Hloop_AS_Q(ntryL,G1H1(19),ex3(:),G1H1(32),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),4,nMB,G2tensor(128),n2h1(164))
  call Hloop_AS_Q(ntryL,G1H1(12),ex3(:),G1H1(44),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(129),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(5),ex4(:),G1H1(88),m3h2x1(:,169),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(130),n2h1(166))
  call Hloop_AV_Q(ntryL,G1H2(52),ex4(:),G1H1(31),m3h2x1(:,170),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),8,nMB,G2tensor(131),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(10),m3h2x1(:,171),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(132),n2h1(168))
  call Hloop_AV_Q(ntryL,G1H2(93),ex4(:),G1H1(8),m3h2x1(:,172),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(133),n2h1(169))
  call Hloop_AV_Q(ntryL,G1H2(96),ex4(:),G1H1(9),m3h2x1(:,173),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),8,nMB,G2tensor(134),n2h1(170))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(41),m3h2x1(:,174),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(135),n2h1(171))
  call Hloop_AS_Q(ntryL,G1H1(7),ex3(:),G1H1(42),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(136),n2h1(172))
  call Hloop_AS_Q(ntryL,G1H1(13),ex3(:),G1H1(19),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),4,nMB,G2tensor(137),n2h1(173))
  call Hloop_AS_Q(ntryL,G1H1(18),ex3(:),G1H1(32),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(138),n2h1(174))
  call Hloop_VQ_A(ntryL,G1H2(102),ex1(:),G1H1(12),m3h2x1(:,175),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(139),n2h1(175))
  call Hloop_VQ_A(ntryL,G1H2(26),ex1(:),G1H1(44),m3h2x1(:,176),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),1,nMB,G2tensor(140),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(61),ex1(:),G1H1(88),m3h2x1(:,177),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(141),n2h1(177))
  call Hloop_VA_Q(ntryL,G1H2(72),ex2(:),G1H1(31),m3h2x1(:,178),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(142),n2h1(178))
  call Hloop_VA_Q(ntryL,G1H2(70),ex2(:),G1H1(10),m3h2x1(:,179),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),2,nMB,G2tensor(143),n2h1(179))
  call Hloop_VA_Q(ntryL,G1H2(59),ex2(:),G1H1(8),m3h2x1(:,180),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(144),n2h1(180))
  call Hloop_QV_A(ntryL,G1H2(4),ex4(:),G1H1(9),m3h2x1(:,181),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(145),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(65),ex4(:),G1H1(41),m3h2x1(:,182),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),8,nMB,G2tensor(146),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(7),m3h2x1(:,183),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),31,nMB,G2tensor(147),n2h1(183))
  call Hloop_QS_A(ntryL,G1H1(28),ex3(:),G1H1(42),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(148),n2h1(184))
  call Hloop_QS_A(ntryL,G1H1(29),ex3(:),G1H1(13),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),4,nMB,G2tensor(149),n2h1(185))
  call Hloop_QS_A(ntryL,G1H1(24),ex3(:),G1H1(19),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(150),n2h1(186))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(7),23,ex4(:),8,G2tensor(151),m3h2x1(:,184),heltab2x2(:,:,247))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(46),0,ex4(:),8,G2tensor(152),m3h2x1(:,185),heltab2x2(:,:,248))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(66),23,ex4(:),8,G2tensor(153),m3h2x1(:,186),heltab2x2(:,:,249))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(71),23,ex4(:),8,G2tensor(154),m3h2x1(:,187),heltab2x2(:,:,250))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(78),0,ex4(:),8,G2tensor(155),m3h2x1(:,188),heltab2x2(:,:,251))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(156),m3h2x1(:,189),heltab2x2(:,:,252))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),23,ex4(:),8,G2tensor(157),m3h2x1(:,190),heltab2x2(:,:,253))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),0,ex4(:),8,G2tensor(158),m3h2x1(:,191),heltab2x2(:,:,254))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),23,ex4(:),8,G2tensor(159),m3h2x1(:,192),heltab2x2(:,:,255))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(123),23,ex4(:),8,G2tensor(160),m3h2x1(:,193),heltab2x2(:,:,256))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),0,ex4(:),8,G2tensor(161),m3h2x1(:,194),heltab2x2(:,:,257))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(127),23,ex4(:),8,G2tensor(162),m3h2x1(:,195),heltab2x2(:,:,258))
  call Hloop_AV_Q(ntryL,G1H2(43),ex4(:),G1H1(18),m3h2x1(:,196),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(163),n2h1(191))
  call Hloop_AV_Q(ntryL,G1H2(40),ex4(:),G1H1(32),m3h2x1(:,197),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),8,nMB,G2tensor(164),n2h1(192))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(12),m3h2x1(:,198),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(165),n2h1(193))
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(44),m3h2x1(:,199),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(166),n2h1(194))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(88),m3h2x1(:,200),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),8,nMB,G2tensor(167),n2h1(195))
  call Hloop_QV_A(ntryL,G1H2(132),ex4(:),G1H1(31),m3h2x1(:,201),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(168),n2h1(196))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(10),m3h2x1(:,202),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(169),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(8),m3h2x1(:,203),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),8,nMB,G2tensor(170),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(9),m3h2x1(:,204),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(171),n2h1(199))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(41),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(172),n2h1(200))
  call Hloop_QS_A(ntryL,G1H1(25),ex3(:),G1H1(7),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),4,nMB,G2tensor(173),n2h1(201))
  call Hloop_QS_A(ntryL,G1H1(49),ex3(:),G1H1(28),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(174),n2h1(202))
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(42),m3h2x1(:,205),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(175),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H2(77),ex4(:),G1H1(29),m3h2x1(:,206),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),8,nMB,G2tensor(176),n2h1(204))
  call Hloop_AV_Q(ntryL,G1H2(139),ex4(:),G1H1(13),m3h2x1(:,207),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(177),n2h1(205))
  call Hloop_AV_Q(ntryL,G1H2(140),ex4(:),G1H1(24),m3h2x1(:,208),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(178),n2h1(206))
  call Hloop_AV_Q(ntryL,G1H2(141),ex4(:),G1H1(19),m3h2x1(:,209),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(179),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(18),m3h2x1(:,210),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(180),n2h1(208))
  call Hloop_AS_Q(ntryL,G1H1(36),ex3(:),G1H1(32),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(181),n2h1(209))
  call Hloop_AS_Q(ntryL,G1H1(50),ex3(:),G1H1(12),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),4,nMB,G2tensor(182),n2h1(210))
  call Hloop_AS_Q(ntryL,G1H1(53),ex3(:),G1H1(44),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(183),n2h1(211))
  call Hloop_AS_Q(ntryL,G1H1(54),ex3(:),G1H1(88),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(184),n2h1(212))
  call Hloop_AS_Q(ntryL,G1H1(55),ex3(:),G1H1(31),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),4,nMB,G2tensor(185),n2h1(213))
  call Hloop_AS_Q(ntryL,G1H1(58),ex3(:),G1H1(10),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(186),n2h1(214))
  call Hloop_QS_A(ntryL,G1H1(59),ex3(:),G1H1(8),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(187),n2h1(215))
  call Hloop_QS_A(ntryL,G1H1(47),ex3(:),G1H1(9),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),4,nMB,G2tensor(188),n2h1(216))
  call Hloop_QS_A(ntryL,G1H1(61),ex3(:),G1H1(2),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(189),n2h1(217))
  call Hloop_QS_A(ntryL,G1H1(62),ex3(:),G1H1(41),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(190),n2h1(218))
  call Hloop_QS_A(ntryL,G1H1(63),ex3(:),G1H1(25),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),4,nMB,G2tensor(191),n2h1(219))
  call Hloop_QS_A(ntryL,G1H1(66),ex3(:),G1H1(7),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),31,nMB,G2tensor(192),n2h1(220))
  call Hloop_AS_Q(ntryL,G1H1(67),ex3(:),G1H1(49),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(49),31,nMB,G2tensor(193),n2h1(221))
  call Hloop_AS_Q(ntryL,G1H1(35),ex3(:),G1H1(28),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),4,nMB,G2tensor(194),n2h1(222))
  call Hloop_AS_Q(ntryL,G1H1(69),ex3(:),G1H1(42),ngH,m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(195),n2h1(223))
  call Hloop_AS_Q(ntryL,G1H1(70),ex3(:),G1H1(29),ngH,m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,nMB,G2tensor(196),n2h1(224))
  call Hloop_AS_Q(ntryL,G1H1(71),ex3(:),G1H1(13),ngH,m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),4,nMB,G2tensor(197),n2h1(225))
  call Hloop_AS_Q(ntryL,G1H1(74),ex3(:),G1H1(24),ngH,m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(198),n2h1(226))
  call Hloop_VQ_A(ntryL,G1H2(87),wf2(:,2),G1H1(19),m3h2x1(:,211),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(199),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H2(89),wf2(:,2),G1H1(18),m3h2x1(:,212),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),5,nMB,G2tensor(200),n2h1(228))
  call Hloop_VQ_A(ntryL,G1H2(147),wf2(:,2),G1H1(36),m3h2x1(:,213),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),31,nMB,G2tensor(201),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H2(148),wf2(:,4),G1H1(32),m3h2x1(:,214),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(202),n2h1(230))
  call Hloop_VA_Q(ntryL,G1H2(149),wf2(:,4),G1H1(50),m3h2x1(:,215),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),6,nMB,G2tensor(203),n2h1(231))
  call Hloop_VA_Q(ntryL,G1H2(152),wf2(:,4),G1H1(12),m3h2x1(:,216),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(204),n2h1(232))
  call Hloop_VQ_A(ntryL,G1H4(5),wf4(:,10),G1H1(53),m3h4x1(:,9),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(53),31,nMB,G2tensor(205),n2h1(233))
  call Hloop_VQ_A(ntryL,G1H4(28),wf4(:,10),G1H1(44),m3h4x1(:,10),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),9,nMB,G2tensor(206),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H4(20),wf4(:,10),G1H1(54),m3h4x1(:,11),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),31,nMB,G2tensor(207),n2h1(235))
  call Hloop_VA_Q(ntryL,G1H4(6),wf4(:,2),G1H1(88),m3h4x1(:,12),heltab2x4(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMB,G2tensor(208),n2h1(236))
  call Hloop_VA_Q(ntryL,G1H4(11),wf4(:,2),G1H1(55),m3h4x1(:,13),heltab2x4(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(55),10,nMB,G2tensor(209),n2h1(237))
  call Hloop_VA_Q(ntryL,G1H4(15),wf4(:,2),G1H1(31),m3h4x1(:,14),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(210),n2h1(238))
  call Hloop_QS_A(ntryL,G1H1(43),ex3(:),G1H1(58),ngH,m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(58),31,nMC,G2tensor(211),n2h1(239))
  call Hloop_QS_A(ntryL,G1H1(46),ex3(:),G1H1(10),ngH,m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),4,nMC,G2tensor(212),n2h1(240))
  call Hloop_QS_A(ntryL,G1H1(75),ex3(:),G1H1(59),ngH,m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),31,nMC,G2tensor(213),n2h1(241))
  call Hloop_QS_A(ntryL,G1H1(4),ex3(:),G1H1(8),ngH,m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMT,G2tensor(214),n2h1(242))
  call Hloop_QS_A(ntryL,G1H1(76),ex3(:),G1H1(47),ngH,m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),4,nMT,G2tensor(215),n2h1(243))
  call Hloop_QS_A(ntryL,G1H1(79),ex3(:),G1H1(9),ngH,m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(216),n2h1(244))
  call Hloop_AS_Q(ntryL,G1H1(5),ex3(:),G1H1(61),ngH,m3h1x1(:,80),heltab2x1(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),31,nMC,G2tensor(217),n2h1(245))
  call Hloop_AS_Q(ntryL,G1H1(80),ex3(:),G1H1(2),ngH,m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),4,nMC,G2tensor(218),n2h1(246))
  call Hloop_AS_Q(ntryL,G1H1(83),ex3(:),G1H1(62),ngH,m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),31,nMC,G2tensor(219),n2h1(247))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(41),ngH,m3h1x1(:,83),heltab2x1(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMT,G2tensor(220),n2h1(248))
  call Hloop_AS_Q(ntryL,G1H1(84),ex3(:),G1H1(63),ngH,m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(63),4,nMT,G2tensor(221),n2h1(249))
  call Hloop_AS_Q(ntryL,G1H1(87),ex3(:),G1H1(25),ngH,m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMT,G2tensor(222),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(66),m3h2x1(:,217),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),31,nMC,G2tensor(223),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(13),ex4(:),G1H1(7),m3h2x1(:,218),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),8,nMC,G2tensor(224),n2h1(252))
  call Hloop_AV_Q(ntryL,G1H2(155),ex4(:),G1H1(67),m3h2x1(:,219),heltab2x2(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(67),31,nMC,G2tensor(225),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(122),ex4(:),G1H1(49),m3h2x1(:,220),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(49),31,nMT,G2tensor(226),n2h1(254))
  call Hloop_AV_Q(ntryL,G1H2(156),ex4(:),G1H1(35),m3h2x1(:,221),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),8,nMT,G2tensor(227),n2h1(255))
  call Hloop_AV_Q(ntryL,G1H2(159),ex4(:),G1H1(28),m3h2x1(:,222),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(228),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(11),ex4(:),G1H1(69),m3h2x1(:,223),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(69),31,nMC,G2tensor(229),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(160),ex4(:),G1H1(42),m3h2x1(:,224),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),8,nMC,G2tensor(230),n2h1(258))
  call Hloop_QV_A(ntryL,G1H2(163),ex4(:),G1H1(70),m3h2x1(:,225),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(70),31,nMC,G2tensor(231),n2h1(259))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(29),m3h2x1(:,226),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,nMT,G2tensor(232),n2h1(260))
  call Hloop_QV_A(ntryL,G1H2(164),ex4(:),G1H1(71),m3h2x1(:,227),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),8,nMT,G2tensor(233),n2h1(261))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(13),m3h2x1(:,228),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(234),n2h1(262))
  call Hloop_QV_A(ntryL,G1H2(41),ex4(:),G1H1(74),m3h2x1(:,229),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(74),31,nMC,G2tensor(235),n2h1(263))
  call Hloop_QV_A(ntryL,G1H2(168),ex4(:),G1H1(24),m3h2x1(:,230),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),8,nMC,G2tensor(236),n2h1(264))
  call Hloop_QV_A(ntryL,G1H2(171),ex4(:),G1H1(19),m3h2x1(:,231),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMC,G2tensor(237),n2h1(265))
  call Hloop_QV_A(ntryL,G1H2(3),ex4(:),G1H1(18),m3h2x1(:,232),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),31,nMT,G2tensor(238),n2h1(266))
  call Hloop_QV_A(ntryL,G1H2(172),ex4(:),G1H1(36),m3h2x1(:,233),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),8,nMT,G2tensor(239),n2h1(267))
  call Hloop_QV_A(ntryL,G1H2(175),ex4(:),G1H1(32),m3h2x1(:,234),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMT,G2tensor(240),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H2(63),ex4(:),G1H1(50),m3h2x1(:,235),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),31,nMC,G2tensor(241),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(176),ex4(:),G1H1(12),m3h2x1(:,236),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),8,nMC,G2tensor(242),n2h1(270))
  call Hloop_AV_Q(ntryL,G1H2(179),ex4(:),G1H1(53),m3h2x1(:,237),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),31,nMC,G2tensor(243),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(44),m3h2x1(:,238),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMT,G2tensor(244),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(180),ex4(:),G1H1(54),m3h2x1(:,239),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(54),8,nMT,G2tensor(245),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(183),ex4(:),G1H1(88),m3h2x1(:,240),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(246),n2h1(274))
  call ol_merge_tensors(G2tensor(95),[G2tensor(11),G2tensor(2),G1tensor(24),G1tensor(6)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(208),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(18),G1tensor(32)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(19),G1tensor(48),G1tensor(36)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(23),G1tensor(42)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(26),G1tensor(44),G1tensor(39)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(30),G1tensor(50)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(31),G1tensor(60),G1tensor(54)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(34),G1tensor(56),G1tensor(27)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(38),G1tensor(62)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(39),G1tensor(66)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(42),G1tensor(68)])
  call ol_merge_tensors(G2tensor(202),[G2tensor(43),G1tensor(72)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(33),G1tensor(2)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(45),G1tensor(8)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(106),G1tensor(41),G1tensor(29)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(166),G1tensor(52),G1tensor(34)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(172),G1tensor(58),G1tensor(46)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(65),G1tensor(47)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(71),G1tensor(59)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(69)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(70)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(75)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(76)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(79)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(80)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(83)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(84)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(87)])
  call ol_merge_tensors(G2tensor(217),[G2tensor(211)])
  call ol_merge_tensors(G2tensor(220),[G2tensor(214)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(223)])
  call ol_merge_tensors(G2tensor(232),[G2tensor(226)])
  call ol_merge_tensors(G2tensor(241),[G2tensor(235)])
  call ol_merge_tensors(G2tensor(244),[G2tensor(238)])
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),10)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),6)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(47),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(24),G1tensor(6),G1tensor(12))
  call G_TensorShift(G1tensor(67),1)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(4),mass4set(:,1),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(26),G1tensor(30))
  call G_TensorShift(G1tensor(18),9)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(48),mass4set(:,1),  & 
G1tensor(32),G1tensor(48),G1tensor(36),G1tensor(38),G1tensor(42))
  call G_TensorShift(G1tensor(48),2)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(49),mass4set(:,2),  & 
G1tensor(44),G1tensor(39),G1tensor(50),G1tensor(60),G1tensor(54))
  call G_TensorShift(G1tensor(39),2)
  call Hotf_4pt_reduction_last(G2tensor(208),RedSet_4(5),mass4set(:,2),  & 
G1tensor(56),G1tensor(27),G1tensor(62),G1tensor(66),G1tensor(68))
  call G_TensorShift(G1tensor(27),10)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(50),mass4set(:,3),  & 
G1tensor(72),G1tensor(33),G1tensor(2),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(33),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(6),mass4set(:,3),  & 
G1tensor(11),G1tensor(5),G1tensor(45),G1tensor(8),G1tensor(9))
  call G_TensorShift(G1tensor(5),12)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(51),mass4set(:,2),  & 
G1tensor(10),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(21))
  call G_TensorShift(G1tensor(15),1)
  call Hotf_4pt_reduction_last(G2tensor(205),RedSet_4(7),mass4set(:,2),  & 
G1tensor(22),G1tensor(23),G1tensor(28),G1tensor(41),G1tensor(29))
  call G_TensorShift(G1tensor(23),9)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(30),mass4set(:,3),  & 
G1tensor(52),G1tensor(34),G1tensor(35),G1tensor(40),G1tensor(58))
  call G_TensorShift(G1tensor(34),8)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(52),mass4set(:,3),  & 
G1tensor(46),G1tensor(65),G1tensor(47),G1tensor(51),G1tensor(53))
  call G_TensorShift(G1tensor(65),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(8),mass4set(:,3),  & 
G1tensor(57),G1tensor(71),G1tensor(59),G1tensor(63),G1tensor(64))
  call G_TensorShift(G1tensor(71),12)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(24),mass4set(:,3),  & 
G1tensor(69),G1tensor(70),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(70),8)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(53),mass4set(:,4),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),1)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(9),mass4set(:,4),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),5)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(54),mass4set(:,4),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(3),mass4set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),6)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(27),mass4set(:,10),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(10),mass4set(:,6),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),2)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(11),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),2)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),2)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(32),mass4set(:,10),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),4)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(13),mass4set(:,6),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(14),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(16),mass4set(:,11),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(17),mass4set(:,9),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(18),mass4set(:,9),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(20),mass4set(:,11),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(21),mass4set(:,9),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(22),mass4set(:,9),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(163),RedSet_4(21),mass4set(:,3),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(25),mass4set(:,5),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(28),mass4set(:,5),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(18),mass4set(:,3),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(17),mass4set(:,3),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(33),mass4set(:,5),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(34),mass4set(:,3),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(36),mass4set(:,10),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(22),mass4set(:,3),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(38),mass4set(:,10),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),4)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(39),mass4set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(41),mass4set(:,12),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),4)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(42),mass4set(:,3),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),4)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(44),mass4set(:,12),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),4)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(45),mass4set(:,3),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(28),mass4set(:,5),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240),G0tensor(1))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(33),mass4set(:,5),  & 
G1tensor(236),G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G0tensor(2))
  call G_TensorShift(G1tensor(241),4)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(33),mass4set(:,7),  & 
G1tensor(236),G1tensor(245),G1tensor(246),G1tensor(247),G1tensor(248),G0tensor(3))
  call G_TensorShift(G1tensor(245),4)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(33),mass4set(:,8),  & 
G1tensor(236),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252),G0tensor(4))
  call G_TensorShift(G1tensor(249),4)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(28),mass4set(:,7),  & 
G1tensor(236),G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G0tensor(5))
  call G_TensorShift(G1tensor(253),8)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(28),mass4set(:,8),  & 
G1tensor(236),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260),G0tensor(6))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(25),mass4set(:,7),  & 
G1tensor(236),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G0tensor(7))
  call G_TensorShift(G1tensor(261),8)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(25),mass4set(:,8),  & 
G1tensor(236),G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G0tensor(8))
  call G_TensorShift(G1tensor(265),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(25),mass4set(:,5),  & 
G1tensor(236),G1tensor(269),G1tensor(270),G1tensor(271),G1tensor(272),G0tensor(9))
  call G_TensorShift(G1tensor(269),8)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(9),mass4set(:,1),  & 
G1tensor(236),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(273),5)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(33),mass4set(:,7),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281))
  call G_TensorShift(G1tensor(278),4)
  call Hotf_4pt_reduction_last(G2tensor(220),RedSet_4(33),mass4set(:,8),  & 
G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286))
  call G_TensorShift(G1tensor(283),4)
  call Hotf_4pt_reduction_last(G2tensor(229),RedSet_4(28),mass4set(:,7),  & 
G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290),G1tensor(291))
  call G_TensorShift(G1tensor(288),8)
  call Hotf_4pt_reduction_last(G2tensor(232),RedSet_4(28),mass4set(:,8),  & 
G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295),G1tensor(296))
  call G_TensorShift(G1tensor(293),8)
  call Hotf_4pt_reduction_last(G2tensor(241),RedSet_4(25),mass4set(:,7),  & 
G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300),G1tensor(301))
  call G_TensorShift(G1tensor(298),8)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(25),mass4set(:,8),  & 
G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(303),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(47),mass4set(:,1),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(4),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(48),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(49),mass4set(:,2),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(5),mass4set(:,2),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(50),mass4set(:,3),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(6),mass4set(:,3),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(51),mass4set(:,2),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(7),mass4set(:,2),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(30),mass4set(:,3),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(52),mass4set(:,3),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(8),mass4set(:,3),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(24),mass4set(:,3),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(53),mass4set(:,4),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(9),mass4set(:,4),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(54),mass4set(:,4),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(3),mass4set(:,4),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(27),mass4set(:,10),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(10),mass4set(:,6),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(11),mass4set(:,1),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(1),mass4set(:,1),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(32),mass4set(:,10),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(13),mass4set(:,6),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(14),mass4set(:,1),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(16),mass4set(:,11),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(17),mass4set(:,9),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(18),mass4set(:,9),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(20),mass4set(:,11),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(21),mass4set(:,9),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(22),mass4set(:,9),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(21),mass4set(:,3),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(25),mass4set(:,5),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(28),mass4set(:,5),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(18),mass4set(:,3),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(17),mass4set(:,3),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(33),mass4set(:,5),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(34),mass4set(:,3),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(36),mass4set(:,10),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(22),mass4set(:,3),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(38),mass4set(:,10),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(39),mass4set(:,3),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(41),mass4set(:,12),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(42),mass4set(:,3),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(44),mass4set(:,12),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(45),mass4set(:,3),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(9),mass4set(:,1),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(277),RedSet_4(33),mass4set(:,7),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(282),RedSet_4(33),mass4set(:,8),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(287),RedSet_4(28),mass4set(:,7),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(292),RedSet_4(28),mass4set(:,8),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(297),RedSet_4(25),mass4set(:,7),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(302),RedSet_4(25),mass4set(:,8),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])



end subroutine vamp_1

end module ol_vamp_1_pphbb_bbxhgg_1_/**/REALKIND
