
module ol_vamp_1_ppattj_ttxaggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppattj_ttxaggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppattj_ttxaggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppattj_ttxaggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppattj_ttxaggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppattj_ttxaggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppattj_ttxaggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(11,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,1,4,2,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(6)*M(6,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,4,1,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,1,8,2,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(27),n2h32(25))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,8,1,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(28),n2h32(26))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,16,4,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,16,8,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(30),n2h32(27))
  Gcoeff(:)%j = (c(6)*M(2,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,8,2,4,1,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(6)*M(5,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,4,1,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,1,16,2,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(33),n2h32(28))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,2,8,4,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,2,8,16,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(35),n2h32(29))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,2,16,1,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(36),n2h32(30))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,4,2,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,4,2,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,4,8,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,4,16,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,1,4,16,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,1,4,8,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,2,8,1,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(43),n2h32(31))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,2,16,1,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(44),n2h32(32))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,4,8,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,2,4,16,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,2,8,1,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(47),n2h32(33))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,16,1,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(48),n2h32(34))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,1,8,2,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(49),n2h32(35))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,1,8,4,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,8,16,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(51),n2h32(36))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,8,16,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,8,2,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(53),n2h32(37))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,1,8,4,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,16,4,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,16,8,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(56),n2h32(38))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,1,16,2,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(57),n2h32(39))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,1,16,8,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,16,2,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(59),n2h32(40))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,16,4,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nMT,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,nMT,G2H16(3),n2h16(3))
  call Hloop_AV_Q(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(4),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex4(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(3),40,nMT,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(9),ex3(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,nMT,G2H16(7),n2h16(7))
  call Hloop_QV_A(ntryL,G1H32(10),ex3(:),G1H16(3),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex2(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(13),ex4(:),G1H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),40,nMT,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(11),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(5),36,nMT,G2H16(12),n2h16(12))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(10),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(11),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(12),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_UV_W(ntryL,G1H32(25),32,ex4(:),8,G2H16(13),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_VA_Q(ntryL,G1H32(26),ex2(:),G1H16(13),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(13),34,nMT,G2H16(14),n2h16(13))
  call Hloop_AV_Q(ntryL,G1H32(27),ex3(:),G1H16(13),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(13),36,nMT,G2H16(15),n2h16(14))
  call Hloop_QA_V(ntryL,G1H32(28),ex2(:),G1H16(13),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_VA_Q(ntryL,G1H32(29),ex2(:),G1H16(14),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(14),34,nMT,G2H16(16),n2h16(15))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_UV_W(ntryL,G1H32(31),32,ex4(:),8,G2H16(17),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(15),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(15),34,nMT,G2H16(18),n2h16(16))
  call Hloop_AV_Q(ntryL,G1H32(33),ex3(:),G1H16(15),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(15),36,nMT,G2H16(19),n2h16(17))
  call Hloop_VA_Q(ntryL,G1H32(34),ex2(:),G1H16(15),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(15),34,nMT,G2H16(20),n2h16(18))
  call Hloop_QA_V(ntryL,G1H32(35),ex2(:),G1H16(15),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_QA_V(ntryL,G1H32(36),ex2(:),G1H16(16),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_VQ_A(ntryL,G1H32(37),ex1(:),G1H16(17),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(21),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(17),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(22),n2h16(20))
  call Hloop_VQ_A(ntryL,G1H32(39),ex1(:),G1H16(17),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(23),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(17),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(24),n2h16(22))
  call Hloop_VQ_A(ntryL,G1H32(41),ex1(:),G1H16(17),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(25),n2h16(23))
  call Hloop_VQ_A(ntryL,G1H32(42),ex1(:),G1H16(17),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(26),n2h16(24))
  call Hloop_QV_A(ntryL,G1H32(43),ex3(:),G1H16(17),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(17),36,nMT,G2H16(27),n2h16(25))
  call Hloop_QV_A(ntryL,G1H32(44),ex3(:),G1H16(17),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(17),36,nMT,G2H16(28),n2h16(26))
  call Hloop_VA_Q(ntryL,G1H32(45),ex2(:),G1H16(17),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(17),34,nMT,G2H16(29),n2h16(27))
  call Hloop_VA_Q(ntryL,G1H32(46),ex2(:),G1H16(17),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(17),34,nMT,G2H16(30),n2h16(28))
  call Hloop_QA_V(ntryL,G1H32(47),ex2(:),G1H16(17),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_QA_V(ntryL,G1H32(48),ex2(:),G1H16(18),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H32(49),ex1(:),G1H16(19),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_VQ_A(ntryL,G1H32(50),ex1(:),G1H16(20),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H16(20),33,nMT,G2H16(31),n2h16(29))
  call Hloop_AQ_V(ntryL,G1H32(51),ex1(:),G1H16(20),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_VQ_A(ntryL,G1H32(52),ex1(:),G1H16(21),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(21),33,nMT,G2H16(32),n2h16(30))
  call Hloop_AQ_V(ntryL,G1H32(53),ex1(:),G1H16(21),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_VQ_A(ntryL,G1H32(54),ex1(:),G1H16(22),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H16(22),33,nMT,G2H16(33),n2h16(31))
  call Hloop_VQ_A(ntryL,G1H32(55),ex1(:),G1H16(22),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(22),33,nMT,G2H16(34),n2h16(32))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(22),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_V(ntryL,G1H32(57),ex1(:),G1H16(23),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_VQ_A(ntryL,G1H32(58),ex1(:),G1H16(24),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H16(24),33,nMT,G2H16(35),n2h16(33))
  call Hloop_AQ_V(ntryL,G1H32(59),ex1(:),G1H16(24),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_VQ_A(ntryL,G1H32(60),ex1(:),G1H16(25),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(25),33,nMT,G2H16(36),n2h16(34))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),16,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(4),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(5),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(5),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(31),G1H16(32),G1H16(33),G1H16(34),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(3),mass5set(:,1),  & 
G1H16(35),G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),16)
  call HG1shiftOLR(G1H16(36),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(8),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(9),n2h8(4))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex2(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(45),G1H16(46),G1H16(47),G1H16(48),G1H16(49),G1H16(50),16)
  call HG1shiftOLR(G1H16(46),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(6),mass5set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G1H16(56),16)
  call HG1shiftOLR(G1H16(52),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(11),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(12),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(13),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(14),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(15),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(16),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(17),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(18),n2h8(12))
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(7),mass5set(:,2),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(6),16,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(8),mass5set(:,3),  & 
G1H16(11),G1H16(12),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(12),16,16)
  call Hloop_AQ_V(ntryL,G2H16(15),ex1(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_UV_W(ntryL,G1H16(13),34,ex4(:),8,G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(9),mass5set(:,4),  & 
G1H16(13),G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),16)
  call HG1shiftOLR(G1H16(61),8,16)
  call Hloop_UV_W(ntryL,G1H16(14),34,ex5(:),16,G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(10),mass5set(:,2),  & 
G1H16(14),G1H16(66),G1H16(67),G1H16(68),G1H16(69),G1H16(70),16)
  call HG1shiftOLR(G1H16(66),16,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(8),mass5set(:,3),  & 
G1H16(71),G1H16(72),G1H16(73),G1H16(74),G1H16(75),G1H16(76),16)
  call HG1shiftOLR(G1H16(72),8,16)
  call Hloop_AQ_V(ntryL,G2H16(19),ex1(:),G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(11),mass5set(:,4),  & 
G1H16(77),G1H16(78),G1H16(79),G1H16(80),G1H16(81),G1H16(82),16)
  call HG1shiftOLR(G1H16(78),16,16)
  call Hloop_UV_W(ntryL,G1H16(15),34,ex4(:),8,G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_UV_W(ntryL,G1H16(16),34,ex5(:),16,G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(12),mass5set(:,3),  & 
G1H16(15),G1H16(16),G1H16(83),G1H16(84),G1H16(85),G1H16(86),16)
  call HG1shiftOLR(G1H16(16),16,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(12),mass5set(:,3),  & 
G1H16(87),G1H16(88),G1H16(89),G1H16(90),G1H16(91),G1H16(92),16)
  call HG1shiftOLR(G1H16(88),8,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(13),mass5set(:,4),  & 
G1H16(93),G1H16(94),G1H16(95),G1H16(96),G1H16(97),G1H16(98),16)
  call HG1shiftOLR(G1H16(94),16,16)
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(14),mass5set(:,4),  & 
G1H16(99),G1H16(100),G1H16(101),G1H16(102),G1H16(103),G1H16(104),16)
  call HG1shiftOLR(G1H16(100),8,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(14),mass5set(:,4),  & 
G1H16(105),G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),16)
  call HG1shiftOLR(G1H16(106),2,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(13),mass5set(:,4),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G1H16(116),16)
  call HG1shiftOLR(G1H16(112),2,16)
  call Hloop_QA_V(ntryL,G2H16(27),ex2(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G2H16(28),ex2(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(15),mass5set(:,4),  & 
G1H16(117),G1H16(118),G1H16(119),G1H16(120),G1H16(121),G1H16(122),16)
  call HG1shiftOLR(G1H16(118),16,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(16),mass5set(:,4),  & 
G1H16(123),G1H16(124),G1H16(125),G1H16(126),G1H16(127),G1H16(128),16)
  call HG1shiftOLR(G1H16(124),8,16)
  call Hloop_UV_W(ntryL,G1H16(17),34,ex4(:),8,G2H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_UV_W(ntryL,G1H16(18),34,ex5(:),16,G2H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_UV_W(ntryL,G1H16(19),33,ex4(:),8,G2H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(17),mass5set(:,4),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(129),G1H16(130),G1H16(131),16)
  call HG1shiftOLR(G1H16(18),16,16)
  call Hloop_UV_W(ntryL,G1H16(20),33,ex4(:),8,G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(18),mass5set(:,4),  & 
G1H16(20),G1H16(132),G1H16(133),G1H16(134),G1H16(135),G1H16(136),16)
  call HG1shiftOLR(G1H16(132),2,16)
  call Hloop_UV_W(ntryL,G1H16(21),33,ex4(:),8,G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(17),mass5set(:,4),  & 
G1H16(21),G1H16(137),G1H16(138),G1H16(139),G1H16(140),G1H16(141),16)
  call HG1shiftOLR(G1H16(137),2,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(19),mass5set(:,4),  & 
G1H16(142),G1H16(143),G1H16(144),G1H16(145),G1H16(146),G1H16(147),16)
  call HG1shiftOLR(G1H16(143),8,16)
  call Hloop_UV_W(ntryL,G1H16(22),33,ex5(:),16,G2H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_UV_W(ntryL,G1H16(23),33,ex5(:),16,G2H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(20),mass5set(:,4),  & 
G1H16(22),G1H16(23),G1H16(148),G1H16(149),G1H16(150),G1H16(151),16)
  call HG1shiftOLR(G1H16(23),2,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,ex5(:),16,G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(19),mass5set(:,4),  & 
G1H16(24),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G1H16(156),16)
  call HG1shiftOLR(G1H16(152),2,16)
  call Hloop_AV_Q(ntryL,G1H16(25),ex3(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(35),n2h8(13))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-16,nMT,G2H16(1),n2h16(35))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AV_Q(ntryL,G1H16(28),ex3(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(37),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(29),ex3(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(38),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(30),ex3(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(39),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(40),n2h8(17))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,nMT,G2H16(2),n2h16(36))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_AV_Q(ntryL,G1H16(32),ex4(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(42),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(33),ex4(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(43),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(34),ex4(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(44),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(35),ex5(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(45),n2h8(21))
call HGT_OLR(G1H16(36),1,1,16)
call HGT_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(36),-8,nMT,G2H16(3),n2h16(37))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QV_A(ntryL,G1H16(38),ex5(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(47),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(48),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(49),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(50),n2h8(25))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,nMT,G2H16(4),n2h16(38))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QV_A(ntryL,G1H16(42),ex3(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(52),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(43),ex3(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(53),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(44),ex3(:),G1H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(54),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(45),ex4(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(55),n2h8(29))
call HGT_OLR(G1H16(46),1,1,16)
call HGT_invQ_OLR(G1H16(46),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(46),-16,nMT,G2H16(5),n2h16(39))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(56),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_QV_A(ntryL,G1H16(48),ex4(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(57),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(49),ex4(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(58),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(50),ex4(:),G1H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(59),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H16(51),ex5(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(60),n2h8(33))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(52),-8,nMT,G2H16(6),n2h16(40))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AV_Q(ntryL,G1H16(54),ex5(:),G1H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(62),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(55),ex5(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(63),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(56),ex5(:),G1H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(64),n2h8(36))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(65),n2h8(37))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(6),-16,ex5(:),16,G2H8(66),m3h2x8(:,66),heltab2x16(:,:,66))
call signflip_OLR(G2H8(66))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(67),n2h8(38))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(68),n2h8(39))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(69),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(70),n2h8(41))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(12),-16,ex5(:),16,G2H8(71),m3h2x8(:,71),heltab2x16(:,:,71))
call signflip_OLR(G2H8(71))
  call Hloop_AV_Q(ntryL,G1H16(58),ex3(:),G1H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(72),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H16(59),ex3(:),G1H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(73),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(74),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H16(13),ex5(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(75),n2h8(45))
call HGT_raise_alpha_OLR(G1H16(61),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(61),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(61),-8,ex4(:),8,G2H8(76),m3h2x8(:,76),heltab2x16(:,:,76))
call signflip_OLR(G2H8(76))
  call Hloop_AV_Q(ntryL,G1H16(63),ex5(:),G1H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(77),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(64),ex5(:),G1H8(1),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(78),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(65),ex5(:),G1H8(1),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(79),n2h8(48))
  call Hloop_VA_Q(ntryL,G1H16(14),ex2(:),G1H8(1),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(80),n2h8(49))
call HGT_raise_alpha_OLR(G1H16(66),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(66),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(66),-16,ex5(:),16,G2H8(81),m3h2x8(:,81),heltab2x16(:,:,81))
call signflip_OLR(G2H8(81))
  call Hloop_VA_Q(ntryL,G1H16(68),ex2(:),G1H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(82),n2h8(50))
  call Hloop_VA_Q(ntryL,G1H16(69),ex2(:),G1H8(1),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(83),n2h8(51))
  call Hloop_VA_Q(ntryL,G1H16(70),ex2(:),G1H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(84),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H16(71),ex3(:),G1H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(85),n2h8(53))
call HGT_raise_alpha_OLR(G1H16(72),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(72),-8,ex4(:),8,G2H8(86),m3h2x8(:,86),heltab2x16(:,:,86))
call signflip_OLR(G2H8(86))
  call Hloop_AV_Q(ntryL,G1H16(74),ex3(:),G1H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(87),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(75),ex3(:),G1H8(1),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(88),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(76),ex3(:),G1H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(89),n2h8(56))
  call Hloop_AV_Q(ntryL,G1H16(77),ex4(:),G1H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(90),n2h8(57))
call HGT_raise_alpha_OLR(G1H16(78),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(78),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(78),-16,ex5(:),16,G2H8(91),m3h2x8(:,91),heltab2x16(:,:,91))
call signflip_OLR(G2H8(91))
  call Hloop_AV_Q(ntryL,G1H16(80),ex4(:),G1H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(92),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H16(81),ex4(:),G1H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(93),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(82),ex4(:),G1H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(94),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(95),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(16),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(16),-16,ex5(:),16,G2H8(96),m3h2x8(:,96),heltab2x16(:,:,96))
call signflip_OLR(G2H8(96))
  call Hloop_QV_A(ntryL,G1H16(84),ex3(:),G1H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(97),n2h8(62))
  call Hloop_QV_A(ntryL,G1H16(85),ex3(:),G1H8(1),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(98),n2h8(63))
  call Hloop_QV_A(ntryL,G1H16(86),ex3(:),G1H8(1),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(99),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(87),ex3(:),G1H8(1),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(100),n2h8(65))
call HGT_raise_alpha_OLR(G1H16(88),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(88),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(88),-8,ex4(:),8,G2H8(101),m3h2x8(:,101),heltab2x16(:,:,101))
call signflip_OLR(G2H8(101))
  call Hloop_QV_A(ntryL,G1H16(90),ex3(:),G1H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(102),n2h8(66))
  call Hloop_QV_A(ntryL,G1H16(91),ex3(:),G1H8(1),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(103),n2h8(67))
  call Hloop_QV_A(ntryL,G1H16(92),ex3(:),G1H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(104),n2h8(68))
  call Hloop_QV_A(ntryL,G1H16(93),ex3(:),G1H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(105),n2h8(69))
call HGT_raise_alpha_OLR(G1H16(94),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(94),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(94),-16,ex5(:),16,G2H8(106),m3h2x8(:,106),heltab2x16(:,:,106))
call signflip_OLR(G2H8(106))
  call Hloop_QV_A(ntryL,G1H16(96),ex3(:),G1H8(1),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(107),n2h8(70))
  call Hloop_QV_A(ntryL,G1H16(97),ex3(:),G1H8(1),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(108),n2h8(71))
  call Hloop_QV_A(ntryL,G1H16(98),ex3(:),G1H8(1),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(109),n2h8(72))
  call Hloop_QV_A(ntryL,G1H16(99),ex3(:),G1H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(110),n2h8(73))
call HGT_raise_alpha_OLR(G1H16(100),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(100),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(100),-8,ex4(:),8,G2H8(111),m3h2x8(:,111),heltab2x16(:,:,111))
call signflip_OLR(G2H8(111))
  call Hloop_QV_A(ntryL,G1H16(102),ex3(:),G1H8(1),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(112),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(103),ex3(:),G1H8(1),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(113),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(104),ex3(:),G1H8(1),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(114),n2h8(76))
  call Hloop_QV_A(ntryL,G1H16(105),ex3(:),G1H8(1),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(115),n2h8(77))
call HGT_raise_alpha_OLR(G1H16(106),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(106),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(106),ex2(:),G1H8(1),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_QV_A(ntryL,G1H16(108),ex3(:),G1H8(2),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(116),n2h8(78))
  call Hloop_QV_A(ntryL,G1H16(109),ex3(:),G1H8(2),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(117),n2h8(79))
  call Hloop_QV_A(ntryL,G1H16(110),ex3(:),G1H8(2),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(118),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(111),ex3(:),G1H8(2),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(119),n2h8(81))
call HGT_raise_alpha_OLR(G1H16(112),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(112),ex2(:),G1H8(2),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QV_A(ntryL,G1H16(114),ex3(:),G1H8(3),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(120),n2h8(82))
  call Hloop_QV_A(ntryL,G1H16(115),ex3(:),G1H8(3),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(121),n2h8(83))
  call Hloop_QV_A(ntryL,G1H16(116),ex3(:),G1H8(3),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(122),n2h8(84))
  call Hloop_AV_Q(ntryL,G1H16(117),ex3(:),G1H8(3),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(123),n2h8(85))
call HGT_raise_alpha_OLR(G1H16(118),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(118),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(118),-16,ex5(:),16,G2H8(124),m3h2x8(:,126),heltab2x16(:,:,126))
call signflip_OLR(G2H8(124))
  call Hloop_AV_Q(ntryL,G1H16(120),ex3(:),G1H8(3),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(125),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H16(121),ex3(:),G1H8(3),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(126),n2h8(87))
  call Hloop_AV_Q(ntryL,G1H16(122),ex3(:),G1H8(3),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(127),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H16(123),ex3(:),G1H8(3),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(128),n2h8(89))
call HGT_raise_alpha_OLR(G1H16(124),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(124),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(124),-8,ex4(:),8,G2H8(129),m3h2x8(:,131),heltab2x16(:,:,131))
call signflip_OLR(G2H8(129))
  call Hloop_AV_Q(ntryL,G1H16(126),ex3(:),G1H8(3),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(130),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H16(127),ex3(:),G1H8(3),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(131),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H16(128),ex3(:),G1H8(3),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(132),n2h8(92))
  call Hloop_QV_A(ntryL,G1H16(17),ex4(:),G1H8(3),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(133),n2h8(93))
call HGT_raise_alpha_OLR(G1H16(18),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(18),-16,ex5(:),16,G2H8(134),m3h2x8(:,136),heltab2x16(:,:,136))
call signflip_OLR(G2H8(134))
  call Hloop_QV_A(ntryL,G1H16(129),ex4(:),G1H8(3),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(135),n2h8(94))
  call Hloop_QV_A(ntryL,G1H16(130),ex4(:),G1H8(3),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(136),n2h8(95))
  call Hloop_QV_A(ntryL,G1H16(131),ex4(:),G1H8(3),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(137),n2h8(96))
  call Hloop_QV_A(ntryL,G1H16(20),ex4(:),G1H8(3),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(138),n2h8(97))
call HGT_raise_alpha_OLR(G1H16(132),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(132),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(132),ex2(:),G1H8(3),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_QV_A(ntryL,G1H16(134),ex4(:),G1H8(4),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(139),n2h8(98))
  call Hloop_QV_A(ntryL,G1H16(135),ex4(:),G1H8(4),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(140),n2h8(99))
  call Hloop_QV_A(ntryL,G1H16(136),ex4(:),G1H8(4),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(141),n2h8(100))
  call Hloop_QV_A(ntryL,G1H16(21),ex4(:),G1H8(4),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(142),n2h8(101))
call HGT_raise_alpha_OLR(G1H16(137),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(137),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(137),ex2(:),G1H8(4),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_QV_A(ntryL,G1H16(139),ex4(:),G1H8(5),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(143),n2h8(102))
  call Hloop_QV_A(ntryL,G1H16(140),ex4(:),G1H8(5),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(144),n2h8(103))
  call Hloop_QV_A(ntryL,G1H16(141),ex4(:),G1H8(5),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(145),n2h8(104))
  call Hloop_QV_A(ntryL,G1H16(142),ex5(:),G1H8(5),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(146),n2h8(105))
call HGT_raise_alpha_OLR(G1H16(143),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(143),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(143),-8,ex4(:),8,G2H8(147),m3h2x8(:,151),heltab2x16(:,:,151))
call signflip_OLR(G2H8(147))
  call Hloop_QV_A(ntryL,G1H16(145),ex5(:),G1H8(5),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(148),n2h8(106))
  call Hloop_QV_A(ntryL,G1H16(146),ex5(:),G1H8(5),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(149),n2h8(107))
  call Hloop_QV_A(ntryL,G1H16(147),ex5(:),G1H8(5),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(150),n2h8(108))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(5),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(151),n2h8(109))
call HGT_raise_alpha_OLR(G1H16(23),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(23),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(23),ex2(:),G1H8(5),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(149),ex5(:),G1H8(6),m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(152),n2h8(110))
  call Hloop_QV_A(ntryL,G1H16(150),ex5(:),G1H8(6),m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(153),n2h8(111))
  call Hloop_QV_A(ntryL,G1H16(151),ex5(:),G1H8(6),m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(154),n2h8(112))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(6),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(155),n2h8(113))
call HGT_raise_alpha_OLR(G1H16(152),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(152),ex2(:),G1H8(6),m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_QV_A(ntryL,G1H16(154),ex5(:),G1H8(7),m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(156),n2h8(114))
  call Hloop_QV_A(ntryL,G1H16(155),ex5(:),G1H8(7),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(157),n2h8(115))
  call Hloop_QV_A(ntryL,G1H16(156),ex5(:),G1H8(7),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(158),n2h8(116))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(21),mass5set(:,5),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(22),mass5set(:,5),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(22),mass5set(:,5),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(23),mass5set(:,6),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(23),mass5set(:,6),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(24),mass5set(:,5),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(25),mass5set(:,5),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(26),mass5set(:,6),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(26),mass5set(:,6),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(25),mass5set(:,5),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(27),mass5set(:,6),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(27),mass5set(:,6),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(28),mass5set(:,6),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(28),mass5set(:,6),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(29),mass5set(:,6),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(29),mass5set(:,6),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(30),mass5set(:,6),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(30),mass5set(:,6),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(31),mass5set(:,7),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(32),mass5set(:,8),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),16,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(33),mass5set(:,9),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(34),mass5set(:,7),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(35),mass5set(:,9),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),4,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(36),mass5set(:,8),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(37),mass5set(:,7),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(38),mass5set(:,7),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(32),mass5set(:,8),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),4,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(36),mass5set(:,8),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),4,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(39),mass5set(:,8),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),16,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(18),mass5set(:,9),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(39),mass5set(:,8),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(20),mass5set(:,9),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),4,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(40),mass5set(:,8),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),8,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(40),mass5set(:,8),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),4,8)
  call Hloop_AQ_V(ntryL,G2H8(35),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(38),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(39),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(45),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(50),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(53),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(54),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(55),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(58),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(59),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(60),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(63),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(64),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(7),mass5set(:,2),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),16,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(41),mass5set(:,10),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),16,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(42),mass5set(:,10),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),16,8)
  call Hloop_AQ_V(ntryL,G2H8(70),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(73),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(74),ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(9),mass5set(:,4),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(43),mass5set(:,3),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(79),RedSet_5(44),mass5set(:,3),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(80),RedSet_5(10),mass5set(:,2),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),16,8)
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(45),mass5set(:,10),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),16,8)
  call Hotf_5pt_reduction(G2H8(84),RedSet_5(46),mass5set(:,10),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),16,8)
  call Hloop_AQ_V(ntryL,G2H8(85),ex1(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(88),ex1(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(89),ex1(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(90),RedSet_5(11),mass5set(:,4),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),16,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(47),mass5set(:,3),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),16,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(48),mass5set(:,3),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),16,8)
  call Hloop_QA_V(ntryL,G2H8(95),ex2(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(98),ex2(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(99),ex2(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G2H8(100),ex2(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G2H8(103),ex2(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H8(104),ex2(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(13),mass5set(:,4),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),16,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(49),mass5set(:,3),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),16,8)
  call Hotf_5pt_reduction(G2H8(109),RedSet_5(50),mass5set(:,3),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),16,8)
  call Hotf_5pt_reduction(G2H8(110),RedSet_5(14),mass5set(:,4),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),8,8)
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(51),mass5set(:,3),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),8,8)
  call Hotf_5pt_reduction(G2H8(114),RedSet_5(52),mass5set(:,3),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),8,8)
  call Hotf_5pt_reduction(G2H8(115),RedSet_5(14),mass5set(:,4),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),2,8)
  call Hotf_5pt_reduction(G2H8(117),RedSet_5(53),mass5set(:,4),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),2,8)
  call Hotf_5pt_reduction(G2H8(118),RedSet_5(54),mass5set(:,4),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(332),2,8)
  call Hotf_5pt_reduction(G2H8(119),RedSet_5(13),mass5set(:,4),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),2,8)
  call Hotf_5pt_reduction(G2H8(121),RedSet_5(55),mass5set(:,4),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),G1H8(348),8)
  call HG1shiftOLR(G1H8(344),2,8)
  call Hotf_5pt_reduction(G2H8(122),RedSet_5(54),mass5set(:,4),  & 
G1H8(349),G1H8(350),G1H8(351),G1H8(352),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(350),2,8)
  call Hotf_5pt_reduction(G2H8(123),RedSet_5(15),mass5set(:,4),  & 
G1H8(355),G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),8)
  call HG1shiftOLR(G1H8(356),16,8)
  call Hotf_5pt_reduction(G2H8(126),RedSet_5(47),mass5set(:,3),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),8)
  call HG1shiftOLR(G1H8(362),16,8)
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(56),mass5set(:,3),  & 
G1H8(367),G1H8(368),G1H8(369),G1H8(370),G1H8(371),G1H8(372),8)
  call HG1shiftOLR(G1H8(368),16,8)
  call Hotf_5pt_reduction(G2H8(128),RedSet_5(16),mass5set(:,4),  & 
G1H8(373),G1H8(374),G1H8(375),G1H8(376),G1H8(377),G1H8(378),8)
  call HG1shiftOLR(G1H8(374),8,8)
  call Hotf_5pt_reduction(G2H8(131),RedSet_5(43),mass5set(:,3),  & 
G1H8(379),G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(380),8,8)
  call Hotf_5pt_reduction(G2H8(132),RedSet_5(57),mass5set(:,3),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),8,8)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(17),mass5set(:,4),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(392),16,8)
  call Hotf_5pt_reduction(G2H8(136),RedSet_5(49),mass5set(:,3),  & 
G1H8(397),G1H8(398),G1H8(399),G1H8(400),G1H8(401),G1H8(402),8)
  call HG1shiftOLR(G1H8(398),16,8)
  call Hotf_5pt_reduction(G2H8(137),RedSet_5(58),mass5set(:,3),  & 
G1H8(403),G1H8(404),G1H8(405),G1H8(406),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(404),16,8)
  call Hotf_5pt_reduction(G2H8(138),RedSet_5(18),mass5set(:,4),  & 
G1H8(409),G1H8(410),G1H8(411),G1H8(412),G1H8(413),G1H8(414),8)
  call HG1shiftOLR(G1H8(410),2,8)
  call Hotf_5pt_reduction(G2H8(140),RedSet_5(59),mass5set(:,4),  & 
G1H8(415),G1H8(416),G1H8(417),G1H8(418),G1H8(419),G1H8(420),8)
  call HG1shiftOLR(G1H8(416),2,8)
  call Hotf_5pt_reduction(G2H8(141),RedSet_5(60),mass5set(:,4),  & 
G1H8(421),G1H8(422),G1H8(423),G1H8(424),G1H8(425),G1H8(426),8)
  call HG1shiftOLR(G1H8(422),2,8)
  call Hotf_5pt_reduction(G2H8(142),RedSet_5(17),mass5set(:,4),  & 
G1H8(427),G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(428),2,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(55),mass5set(:,4),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),2,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(60),mass5set(:,4),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),G1H8(444),8)
  call HG1shiftOLR(G1H8(440),2,8)
  call Hotf_5pt_reduction(G2H8(146),RedSet_5(19),mass5set(:,4),  & 
G1H8(445),G1H8(446),G1H8(447),G1H8(448),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(446),8,8)
  call Hotf_5pt_reduction(G2H8(149),RedSet_5(51),mass5set(:,3),  & 
G1H8(451),G1H8(452),G1H8(453),G1H8(454),G1H8(455),G1H8(456),8)
  call HG1shiftOLR(G1H8(452),8,8)
  call Hotf_5pt_reduction(G2H8(150),RedSet_5(61),mass5set(:,3),  & 
G1H8(457),G1H8(458),G1H8(459),G1H8(460),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(458),8,8)
  call Hotf_5pt_reduction(G2H8(151),RedSet_5(20),mass5set(:,4),  & 
G1H8(463),G1H8(464),G1H8(465),G1H8(466),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(464),2,8)
  call Hotf_5pt_reduction(G2H8(153),RedSet_5(59),mass5set(:,4),  & 
G1H8(469),G1H8(470),G1H8(471),G1H8(472),G1H8(473),G1H8(474),8)
  call HG1shiftOLR(G1H8(470),2,8)
  call Hotf_5pt_reduction(G2H8(154),RedSet_5(62),mass5set(:,4),  & 
G1H8(475),G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(476),2,8)
  call Hotf_5pt_reduction(G2H8(155),RedSet_5(19),mass5set(:,4),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),2,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(53),mass5set(:,4),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),G1H8(492),8)
  call HG1shiftOLR(G1H8(488),2,8)
  call Hotf_5pt_reduction(G2H8(158),RedSet_5(62),mass5set(:,4),  & 
G1H8(493),G1H8(494),G1H8(495),G1H8(496),G1H8(497),G1H8(498),8)
  call HG1shiftOLR(G1H8(494),2,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(217),[G1H8(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(223),[G1H8(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(235),[G1H8(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(241),[G1H8(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(253),[G1H8(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(259),[G1H8(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(271),[G1H8(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(277),[G1H8(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(289),[G1H8(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(295),[G1H8(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(307),[G1H8(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(313),[G1H8(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(331),[G1H8(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(343),[G1H8(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(349),[G1H8(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(361),[G1H8(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(367),[G1H8(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(379),[G1H8(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(385),[G1H8(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(397),[G1H8(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(403),[G1H8(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(415),[G1H8(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(421),[G1H8(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(433),[G1H8(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(439),[G1H8(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(451),[G1H8(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(457),[G1H8(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(469),[G1H8(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(475),[G1H8(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(487),[G1H8(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(493),[G1H8(486)])
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(31),n2h4(1))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nMT,G2H8(1),n2h8(117))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(33),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(34),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(35),n2h4(4))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,nMT,G2H8(2),n2h8(118))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(37),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(38),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(39),n2h4(7))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-8,nMT,G2H8(3),n2h8(119))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(41),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(42),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(43),n2h4(10))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,nMT,G2H8(4),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(45),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(46),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(47),n2h4(13))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,nMT,G2H8(5),n2h8(121))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(49),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(50),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(51),n2h4(16))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-16,nMT,G2H8(6),n2h8(122))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(53),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(54),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(55),n2h4(19))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,nMT,G2H8(7),n2h8(123))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(57),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(58),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(59),n2h4(22))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-16,nMT,G2H8(8),n2h8(124))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(61),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(62),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(55),ex4(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(63),n2h4(25))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-4,nMT,G2H8(9),n2h8(125))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(59),ex4(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(65),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(60),ex4(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(66),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(67),n2h4(28))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,nMT,G2H8(10),n2h8(126))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_VQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(69),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(66),ex1(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(70),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(71),n2h4(31))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-8,nMT,G2H8(11),n2h8(127))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(73),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(74),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(75),n2h4(34))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-4,nMT,G2H8(12),n2h8(128))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(77),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(78),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(79),n2h4(37))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-16,nMT,G2H8(13),n2h8(129))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(83),ex3(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(81),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(82),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(85),ex3(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(83),n2h4(40))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,nMT,G2H8(14),n2h8(130))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(89),ex3(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(85),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(90),ex3(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(86),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(91),ex4(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(87),n2h4(43))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-16,nMT,G2H8(15),n2h8(131))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(89),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(90),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(97),ex4(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(91),n2h4(46))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-4,nMT,G2H8(16),n2h8(132))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_AV_Q(ntryL,G1H8(101),ex4(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(93),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(102),ex4(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(94),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(95),n2h4(49))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,nMT,G2H8(17),n2h8(133))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(97),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(98),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(109),ex5(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(99),n2h4(52))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-4,nMT,G2H8(18),n2h8(134))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_AV_Q(ntryL,G1H8(113),ex5(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(101),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(114),ex5(:),G1H4(1),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(102),n2h4(54))
  call Hloop_UV_W(ntryL,G1H8(115),37,ex4(:),8,G2H4(103),m3h2x4(:,103),heltab2x8(:,:,103))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(116),-16,nMT,G2H8(19),n2h8(135))
  call Hloop_QV_A(ntryL,G2H8(19),ex5(:),G2H4(104),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_UV_W(ntryL,G1H8(119),37,ex4(:),8,G2H4(105),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_UV_W(ntryL,G1H8(120),37,ex4(:),8,G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_VQ_A(ntryL,G1H8(121),ex1(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(107),n2h4(55))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-16,nMT,G2H8(20),n2h8(136))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(108),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_VQ_A(ntryL,G1H8(125),ex1(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(109),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H8(126),ex1(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(110),n2h4(57))
  call Hloop_UV_W(ntryL,G1H8(127),50,ex4(:),8,G2H4(111),m3h2x4(:,111),heltab2x8(:,:,111))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-4,nMT,G2H8(21),n2h8(137))
  call Hloop_AV_Q(ntryL,G2H8(21),ex3(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_UV_W(ntryL,G1H8(131),50,ex4(:),8,G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_UV_W(ntryL,G1H8(132),50,ex4(:),8,G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_UV_W(ntryL,G1H8(133),37,ex5(:),16,G2H4(115),m3h2x4(:,115),heltab2x8(:,:,115))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(134),-8,nMT,G2H8(22),n2h8(138))
  call Hloop_QV_A(ntryL,G2H8(22),ex4(:),G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_UV_W(ntryL,G1H8(137),37,ex5(:),16,G2H4(117),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_UV_W(ntryL,G1H8(138),37,ex5(:),16,G2H4(118),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_UV_W(ntryL,G1H8(139),42,ex5(:),16,G2H4(119),m3h2x4(:,119),heltab2x8(:,:,119))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(140),-4,nMT,G2H8(23),n2h8(139))
  call Hloop_AV_Q(ntryL,G2H8(23),ex3(:),G2H4(120),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_UV_W(ntryL,G1H8(143),42,ex5(:),16,G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_UV_W(ntryL,G1H8(144),42,ex5(:),16,G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_VQ_A(ntryL,G1H8(145),ex1(:),G1H4(1),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(123),n2h4(58))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(146),-8,nMT,G2H8(24),n2h8(140))
  call Hloop_AV_Q(ntryL,G2H8(24),ex4(:),G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_VQ_A(ntryL,G1H8(149),ex1(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(125),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H8(150),ex1(:),G1H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(126),n2h4(60))
  call Hloop_UV_W(ntryL,G1H8(151),38,ex4(:),8,G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(152),-16,nMT,G2H8(25),n2h8(141))
  call Hloop_AV_Q(ntryL,G2H8(25),ex5(:),G2H4(128),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_UV_W(ntryL,G1H8(155),38,ex4(:),8,G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_UV_W(ntryL,G1H8(156),38,ex4(:),8,G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H8(157),38,ex5(:),16,G2H4(131),m3h2x4(:,131),heltab2x8(:,:,131))
call HGT_OLR(G1H8(158),1,1,8)
call HGT_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(158),-8,nMT,G2H8(26),n2h8(142))
  call Hloop_AV_Q(ntryL,G2H8(26),ex4(:),G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_UV_W(ntryL,G1H8(161),38,ex5(:),16,G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_UV_W(ntryL,G1H8(162),38,ex5(:),16,G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_VQ_A(ntryL,G1H8(163),ex1(:),G1H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(135),n2h4(61))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(164),-4,nMT,G2H8(27),n2h8(143))
  call Hloop_AV_Q(ntryL,G2H8(27),ex3(:),G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_VQ_A(ntryL,G1H8(167),ex1(:),G1H4(1),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(137),n2h4(62))
  call Hloop_VQ_A(ntryL,G1H8(168),ex1(:),G1H4(1),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(138),n2h4(63))
  call Hloop_VQ_A(ntryL,G1H8(169),ex1(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(139),n2h4(64))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(170),-4,nMT,G2H8(28),n2h8(144))
  call Hloop_AV_Q(ntryL,G2H8(28),ex3(:),G2H4(140),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_VQ_A(ntryL,G1H8(173),ex1(:),G1H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(141),n2h4(65))
  call Hloop_VQ_A(ntryL,G1H8(174),ex1(:),G1H4(1),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(142),n2h4(66))
  call Hloop_VA_Q(ntryL,G1H8(175),ex2(:),G1H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(143),n2h4(67))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-16,nMT,G2H8(29),n2h8(145))
  call Hloop_QV_A(ntryL,G2H8(29),ex5(:),G2H4(144),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_VA_Q(ntryL,G1H8(179),ex2(:),G1H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(145),n2h4(68))
  call Hloop_VA_Q(ntryL,G1H8(180),ex2(:),G1H4(1),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(146),n2h4(69))
  call Hloop_UV_W(ntryL,G1H8(181),41,ex5(:),16,G2H4(147),m3h2x4(:,147),heltab2x8(:,:,147))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(182),-4,nMT,G2H8(30),n2h8(146))
  call Hloop_QV_A(ntryL,G2H8(30),ex3(:),G2H4(148),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_UV_W(ntryL,G1H8(185),41,ex5(:),16,G2H4(149),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_UV_W(ntryL,G1H8(186),41,ex5(:),16,G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_VA_Q(ntryL,G1H8(187),ex2(:),G1H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(151),n2h4(70))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(188),-4,nMT,G2H8(31),n2h8(147))
  call Hloop_QV_A(ntryL,G2H8(31),ex3(:),G2H4(152),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_VA_Q(ntryL,G1H8(191),ex2(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(153),n2h4(71))
  call Hloop_VA_Q(ntryL,G1H8(192),ex2(:),G1H4(1),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(154),n2h4(72))
  call Hloop_UV_W(ntryL,G1H8(193),49,ex4(:),8,G2H4(155),m3h2x4(:,155),heltab2x8(:,:,155))
call HGT_OLR(G1H8(194),1,1,8)
call HGT_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(194),-4,nMT,G2H8(32),n2h8(148))
  call Hloop_QV_A(ntryL,G2H8(32),ex3(:),G2H4(156),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_UV_W(ntryL,G1H8(197),49,ex4(:),8,G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_UV_W(ntryL,G1H8(198),49,ex4(:),8,G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_VA_Q(ntryL,G1H8(199),ex2(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(159),n2h4(73))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(200),-8,nMT,G2H8(33),n2h8(149))
  call Hloop_QV_A(ntryL,G2H8(33),ex4(:),G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_VA_Q(ntryL,G1H8(203),ex2(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(161),n2h4(74))
  call Hloop_VA_Q(ntryL,G1H8(204),ex2(:),G1H4(1),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(162),n2h4(75))
  call Hloop_VA_Q(ntryL,G1H8(205),ex2(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(163),n2h4(76))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(206),-4,nMT,G2H8(34),n2h8(150))
  call Hloop_QV_A(ntryL,G2H8(34),ex3(:),G2H4(164),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_VA_Q(ntryL,G1H8(209),ex2(:),G1H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(165),n2h4(77))
  call Hloop_VA_Q(ntryL,G1H8(210),ex2(:),G1H4(1),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(166),n2h4(78))
  call Hloop_QV_A(ntryL,G1H8(211),ex3(:),G1H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(167),n2h4(79))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(212),-16,ex5(:),16,G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
call signflip_OLR(G2H4(168))
  call Hloop_QV_A(ntryL,G1H8(217),ex3(:),G1H4(1),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(169),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(223),ex3(:),G1H4(1),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(170),n2h4(81))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(218),-16,ex5(:),16,G2H4(171),m3h2x4(:,171),heltab2x8(:,:,171))
call signflip_OLR(G2H4(171))
  call Hloop_QV_A(ntryL,G1H8(221),ex3(:),G1H4(1),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(172),n2h4(82))
  call Hloop_QV_A(ntryL,G1H8(222),ex3(:),G1H4(1),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(173),n2h4(83))
call HGT_raise_alpha_OLR(G1H8(224),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(224),-16,ex5(:),16,G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
call signflip_OLR(G2H4(174))
  call Hloop_QV_A(ntryL,G1H8(227),ex3(:),G1H4(1),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(175),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(228),ex3(:),G1H4(1),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(176),n2h4(85))
  call Hloop_AV_Q(ntryL,G1H8(229),ex3(:),G1H4(1),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(177),n2h4(86))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(230),-8,ex4(:),8,G2H4(178),m3h2x4(:,178),heltab2x8(:,:,178))
call signflip_OLR(G2H4(178))
  call Hloop_AV_Q(ntryL,G1H8(235),ex3(:),G1H4(1),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(179),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H8(241),ex3(:),G1H4(1),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(180),n2h4(88))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(236),-8,ex4(:),8,G2H4(181),m3h2x4(:,181),heltab2x8(:,:,181))
call signflip_OLR(G2H4(181))
  call Hloop_AV_Q(ntryL,G1H8(239),ex3(:),G1H4(1),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(182),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H8(240),ex3(:),G1H4(1),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(183),n2h4(90))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(242),-8,ex4(:),8,G2H4(184),m3h2x4(:,184),heltab2x8(:,:,184))
call signflip_OLR(G2H4(184))
  call Hloop_AV_Q(ntryL,G1H8(245),ex3(:),G1H4(1),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(185),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H8(246),ex3(:),G1H4(1),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(186),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H8(247),ex3(:),G1H4(1),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(187),n2h4(93))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(248),-16,ex5(:),16,G2H4(188),m3h2x4(:,188),heltab2x8(:,:,188))
call signflip_OLR(G2H4(188))
  call Hloop_AV_Q(ntryL,G1H8(253),ex3(:),G1H4(1),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(189),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(259),ex3(:),G1H4(1),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(190),n2h4(95))
call HGT_raise_alpha_OLR(G1H8(254),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(254),-16,ex5(:),16,G2H4(191),m3h2x4(:,191),heltab2x8(:,:,191))
call signflip_OLR(G2H4(191))
  call Hloop_AV_Q(ntryL,G1H8(257),ex3(:),G1H4(1),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(192),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H8(258),ex3(:),G1H4(1),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(193),n2h4(97))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(260),-16,ex5(:),16,G2H4(194),m3h2x4(:,194),heltab2x8(:,:,194))
call signflip_OLR(G2H4(194))
  call Hloop_AV_Q(ntryL,G1H8(263),ex3(:),G1H4(1),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(195),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H8(264),ex3(:),G1H4(1),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(196),n2h4(99))
  call Hloop_AV_Q(ntryL,G1H8(265),ex3(:),G1H4(1),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(197),n2h4(100))
call HGT_raise_alpha_OLR(G1H8(266),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(266),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(266),-16,ex5(:),16,G2H4(198),m3h2x4(:,198),heltab2x8(:,:,198))
call signflip_OLR(G2H4(198))
  call Hloop_AV_Q(ntryL,G1H8(271),ex3(:),G1H4(1),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(199),n2h4(101))
  call Hloop_AV_Q(ntryL,G1H8(277),ex3(:),G1H4(1),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(200),n2h4(102))
call HGT_raise_alpha_OLR(G1H8(272),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(272),-16,ex5(:),16,G2H4(201),m3h2x4(:,201),heltab2x8(:,:,201))
call signflip_OLR(G2H4(201))
  call Hloop_AV_Q(ntryL,G1H8(275),ex3(:),G1H4(1),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(202),n2h4(103))
  call Hloop_AV_Q(ntryL,G1H8(276),ex3(:),G1H4(1),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(203),n2h4(104))
call HGT_raise_alpha_OLR(G1H8(278),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(278),-16,ex5(:),16,G2H4(204),m3h2x4(:,204),heltab2x8(:,:,204))
call signflip_OLR(G2H4(204))
  call Hloop_AV_Q(ntryL,G1H8(281),ex3(:),G1H4(1),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(205),n2h4(105))
  call Hloop_AV_Q(ntryL,G1H8(282),ex3(:),G1H4(1),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(206),n2h4(106))
  call Hloop_QV_A(ntryL,G1H8(283),ex4(:),G1H4(1),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(207),n2h4(107))
call HGT_raise_alpha_OLR(G1H8(284),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(284),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(284),-16,ex5(:),16,G2H4(208),m3h2x4(:,208),heltab2x8(:,:,208))
call signflip_OLR(G2H4(208))
  call Hloop_QV_A(ntryL,G1H8(289),ex4(:),G1H4(1),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(209),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(295),ex4(:),G1H4(1),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(210),n2h4(109))
call HGT_raise_alpha_OLR(G1H8(290),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(290),-16,ex5(:),16,G2H4(211),m3h2x4(:,211),heltab2x8(:,:,211))
call signflip_OLR(G2H4(211))
  call Hloop_QV_A(ntryL,G1H8(293),ex4(:),G1H4(1),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(212),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(294),ex4(:),G1H4(1),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(213),n2h4(111))
call HGT_raise_alpha_OLR(G1H8(296),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(296),-16,ex5(:),16,G2H4(214),m3h2x4(:,214),heltab2x8(:,:,214))
call signflip_OLR(G2H4(214))
  call Hloop_QV_A(ntryL,G1H8(299),ex4(:),G1H4(1),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(215),n2h4(112))
  call Hloop_QV_A(ntryL,G1H8(300),ex4(:),G1H4(1),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(216),n2h4(113))
  call Hloop_QV_A(ntryL,G1H8(301),ex5(:),G1H4(1),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(217),n2h4(114))
call HGT_raise_alpha_OLR(G1H8(302),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(302),-8,ex4(:),8,G2H4(218),m3h2x4(:,218),heltab2x8(:,:,218))
call signflip_OLR(G2H4(218))
  call Hloop_QV_A(ntryL,G1H8(307),ex5(:),G1H4(1),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(219),n2h4(115))
  call Hloop_QV_A(ntryL,G1H8(313),ex5(:),G1H4(1),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(220),n2h4(116))
call HGT_raise_alpha_OLR(G1H8(308),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(308),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(308),-8,ex4(:),8,G2H4(221),m3h2x4(:,221),heltab2x8(:,:,221))
call signflip_OLR(G2H4(221))
  call Hloop_QV_A(ntryL,G1H8(311),ex5(:),G1H4(1),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(222),n2h4(117))
  call Hloop_QV_A(ntryL,G1H8(312),ex5(:),G1H4(1),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(223),n2h4(118))
call HGT_raise_alpha_OLR(G1H8(314),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(314),-8,ex4(:),8,G2H4(224),m3h2x4(:,224),heltab2x8(:,:,224))
call signflip_OLR(G2H4(224))
  call Hloop_QV_A(ntryL,G1H8(317),ex5(:),G1H4(1),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(225),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(318),ex5(:),G1H4(1),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(226),n2h4(120))
  call Hloop_QV_A(ntryL,G1H8(319),ex5(:),G1H4(1),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(227),n2h4(121))
call HGT_raise_alpha_OLR(G1H8(320),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(320),ex2(:),G1H4(1),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_QV_A(ntryL,G1H8(325),ex5(:),G1H4(2),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(228),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(331),ex5(:),G1H4(2),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(229),n2h4(123))
call HGT_raise_alpha_OLR(G1H8(326),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(326),ex2(:),G1H4(2),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_QV_A(ntryL,G1H8(329),ex5(:),G1H4(3),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(230),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(330),ex5(:),G1H4(3),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(231),n2h4(125))
call HGT_raise_alpha_OLR(G1H8(332),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(332),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(332),ex2(:),G1H4(3),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_QV_A(ntryL,G1H8(335),ex5(:),G1H4(4),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(232),n2h4(126))
  call Hloop_QV_A(ntryL,G1H8(336),ex5(:),G1H4(4),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(233),n2h4(127))
  call Hloop_QV_A(ntryL,G1H8(337),ex4(:),G1H4(4),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(4),45,nMT,G2H4(234),n2h4(128))
call HGT_raise_alpha_OLR(G1H8(338),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(338),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(338),ex2(:),G1H4(4),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_QV_A(ntryL,G1H8(343),ex4(:),G1H4(5),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(235),n2h4(129))
  call Hloop_QV_A(ntryL,G1H8(349),ex4(:),G1H4(5),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(236),n2h4(130))
call HGT_raise_alpha_OLR(G1H8(344),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(344),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(344),ex2(:),G1H4(5),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_QV_A(ntryL,G1H8(347),ex4(:),G1H4(6),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(237),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(348),ex4(:),G1H4(6),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(238),n2h4(132))
call HGT_raise_alpha_OLR(G1H8(350),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(350),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(350),ex2(:),G1H4(6),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_QV_A(ntryL,G1H8(353),ex4(:),G1H4(7),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(239),n2h4(133))
  call Hloop_QV_A(ntryL,G1H8(354),ex4(:),G1H4(7),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(240),n2h4(134))
  call Hloop_AV_Q(ntryL,G1H8(355),ex4(:),G1H4(7),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(241),n2h4(135))
call HGT_raise_alpha_OLR(G1H8(356),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(356),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(356),-16,ex5(:),16,G2H4(242),m3h2x4(:,248),heltab2x8(:,:,248))
call signflip_OLR(G2H4(242))
  call Hloop_AV_Q(ntryL,G1H8(361),ex4(:),G1H4(7),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(243),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H8(367),ex4(:),G1H4(7),m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(244),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(362),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(362),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(362),-16,ex5(:),16,G2H4(245),m3h2x4(:,251),heltab2x8(:,:,251))
call signflip_OLR(G2H4(245))
  call Hloop_AV_Q(ntryL,G1H8(365),ex4(:),G1H4(7),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(246),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H8(366),ex4(:),G1H4(7),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(247),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(368),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(368),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(368),-16,ex5(:),16,G2H4(248),m3h2x4(:,254),heltab2x8(:,:,254))
call signflip_OLR(G2H4(248))
  call Hloop_AV_Q(ntryL,G1H8(371),ex4(:),G1H4(7),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(249),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H8(372),ex4(:),G1H4(7),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(250),n2h4(141))
  call Hloop_AV_Q(ntryL,G1H8(373),ex5(:),G1H4(7),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(251),n2h4(142))
call HGT_raise_alpha_OLR(G1H8(374),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(374),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(374),-8,ex4(:),8,G2H4(252),m3h2x4(:,258),heltab2x8(:,:,258))
call signflip_OLR(G2H4(252))
  call Hloop_AV_Q(ntryL,G1H8(379),ex5(:),G1H4(7),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(253),n2h4(143))
  call Hloop_AV_Q(ntryL,G1H8(385),ex5(:),G1H4(7),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(254),n2h4(144))
call HGT_raise_alpha_OLR(G1H8(380),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(380),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(380),-8,ex4(:),8,G2H4(255),m3h2x4(:,261),heltab2x8(:,:,261))
call signflip_OLR(G2H4(255))
  call Hloop_AV_Q(ntryL,G1H8(383),ex5(:),G1H4(7),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(256),n2h4(145))
  call Hloop_AV_Q(ntryL,G1H8(384),ex5(:),G1H4(7),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(257),n2h4(146))
call HGT_raise_alpha_OLR(G1H8(386),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(386),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(386),-8,ex4(:),8,G2H4(258),m3h2x4(:,264),heltab2x8(:,:,264))
call signflip_OLR(G2H4(258))
  call Hloop_AV_Q(ntryL,G1H8(389),ex5(:),G1H4(7),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(259),n2h4(147))
  call Hloop_AV_Q(ntryL,G1H8(390),ex5(:),G1H4(7),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(260),n2h4(148))
  call Hloop_QV_A(ntryL,G1H8(391),ex3(:),G1H4(7),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(261),n2h4(149))
call HGT_raise_alpha_OLR(G1H8(392),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(392),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(392),-16,ex5(:),16,G2H4(262),m3h2x4(:,268),heltab2x8(:,:,268))
call signflip_OLR(G2H4(262))
  call Hloop_QV_A(ntryL,G1H8(397),ex3(:),G1H4(7),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(263),n2h4(150))
  call Hloop_QV_A(ntryL,G1H8(403),ex3(:),G1H4(7),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(264),n2h4(151))
call HGT_raise_alpha_OLR(G1H8(398),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(398),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(398),-16,ex5(:),16,G2H4(265),m3h2x4(:,271),heltab2x8(:,:,271))
call signflip_OLR(G2H4(265))
  call Hloop_QV_A(ntryL,G1H8(401),ex3(:),G1H4(7),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(266),n2h4(152))
  call Hloop_QV_A(ntryL,G1H8(402),ex3(:),G1H4(7),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(267),n2h4(153))
call HGT_raise_alpha_OLR(G1H8(404),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(404),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(404),-16,ex5(:),16,G2H4(268),m3h2x4(:,274),heltab2x8(:,:,274))
call signflip_OLR(G2H4(268))
  call Hloop_QV_A(ntryL,G1H8(407),ex3(:),G1H4(7),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(269),n2h4(154))
  call Hloop_QV_A(ntryL,G1H8(408),ex3(:),G1H4(7),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(270),n2h4(155))
  call Hloop_QV_A(ntryL,G1H8(409),ex5(:),G1H4(7),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G1H4(7),57,nMT,G2H4(271),n2h4(156))
call HGT_raise_alpha_OLR(G1H8(410),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(410),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(410),ex2(:),G1H4(7),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_QV_A(ntryL,G1H8(415),ex5(:),G1H4(8),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(272),n2h4(157))
  call Hloop_QV_A(ntryL,G1H8(421),ex5(:),G1H4(8),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(273),n2h4(158))
call HGT_raise_alpha_OLR(G1H8(416),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(416),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(416),ex2(:),G1H4(8),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_QV_A(ntryL,G1H8(419),ex5(:),G1H4(9),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(9),57,nMT,G2H4(274),n2h4(159))
  call Hloop_QV_A(ntryL,G1H8(420),ex5(:),G1H4(9),m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(9),57,nMT,G2H4(275),n2h4(160))
call HGT_raise_alpha_OLR(G1H8(422),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(422),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(422),ex2(:),G1H4(9),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_QV_A(ntryL,G1H8(425),ex5(:),G1H4(10),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(10),57,nMT,G2H4(276),n2h4(161))
  call Hloop_QV_A(ntryL,G1H8(426),ex5(:),G1H4(10),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(10),57,nMT,G2H4(277),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(427),ex3(:),G1H4(10),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(10),45,nMT,G2H4(278),n2h4(163))
call HGT_raise_alpha_OLR(G1H8(428),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(428),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(428),ex2(:),G1H4(10),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_QV_A(ntryL,G1H8(433),ex3(:),G1H4(11),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(11),45,nMT,G2H4(279),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(439),ex3(:),G1H4(11),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(11),45,nMT,G2H4(280),n2h4(165))
call HGT_raise_alpha_OLR(G1H8(434),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(434),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(434),ex2(:),G1H4(11),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_QV_A(ntryL,G1H8(437),ex3(:),G1H4(12),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H4(12),45,nMT,G2H4(281),n2h4(166))
  call Hloop_QV_A(ntryL,G1H8(438),ex3(:),G1H4(12),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(12),45,nMT,G2H4(282),n2h4(167))
call HGT_raise_alpha_OLR(G1H8(440),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(440),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(440),ex2(:),G1H4(12),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_QV_A(ntryL,G1H8(443),ex3(:),G1H4(13),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(283),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(444),ex3(:),G1H4(13),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(284),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(445),ex3(:),G1H4(13),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(285),n2h4(170))
call HGT_raise_alpha_OLR(G1H8(446),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(446),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(446),-8,ex4(:),8,G2H4(286),m3h2x4(:,298),heltab2x8(:,:,298))
call signflip_OLR(G2H4(286))
  call Hloop_QV_A(ntryL,G1H8(451),ex3(:),G1H4(13),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(287),n2h4(171))
  call Hloop_QV_A(ntryL,G1H8(457),ex3(:),G1H4(13),m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(288),n2h4(172))
call HGT_raise_alpha_OLR(G1H8(452),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(452),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(452),-8,ex4(:),8,G2H4(289),m3h2x4(:,301),heltab2x8(:,:,301))
call signflip_OLR(G2H4(289))
  call Hloop_QV_A(ntryL,G1H8(455),ex3(:),G1H4(13),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(290),n2h4(173))
  call Hloop_QV_A(ntryL,G1H8(456),ex3(:),G1H4(13),m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(291),n2h4(174))
call HGT_raise_alpha_OLR(G1H8(458),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(458),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(458),-8,ex4(:),8,G2H4(292),m3h2x4(:,304),heltab2x8(:,:,304))
call signflip_OLR(G2H4(292))
  call Hloop_QV_A(ntryL,G1H8(461),ex3(:),G1H4(13),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(293),n2h4(175))
  call Hloop_QV_A(ntryL,G1H8(462),ex3(:),G1H4(13),m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMT,G2H4(294),n2h4(176))
  call Hloop_QV_A(ntryL,G1H8(463),ex4(:),G1H4(13),m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(13),57,nMT,G2H4(295),n2h4(177))
call HGT_raise_alpha_OLR(G1H8(464),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(464),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(464),ex2(:),G1H4(13),m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_QV_A(ntryL,G1H8(469),ex4(:),G1H4(14),m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(14),57,nMT,G2H4(296),n2h4(178))
  call Hloop_QV_A(ntryL,G1H8(475),ex4(:),G1H4(14),m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(14),57,nMT,G2H4(297),n2h4(179))
call HGT_raise_alpha_OLR(G1H8(470),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(470),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(470),ex2(:),G1H4(14),m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_QV_A(ntryL,G1H8(473),ex4(:),G1H4(15),m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H4(15),57,nMT,G2H4(298),n2h4(180))
  call Hloop_QV_A(ntryL,G1H8(474),ex4(:),G1H4(15),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G1H4(15),57,nMT,G2H4(299),n2h4(181))
call HGT_raise_alpha_OLR(G1H8(476),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(476),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(476),ex2(:),G1H4(15),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_QV_A(ntryL,G1H8(479),ex4(:),G1H4(16),m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H4(16),57,nMT,G2H4(300),n2h4(182))
  call Hloop_QV_A(ntryL,G1H8(480),ex4(:),G1H4(16),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(16),57,nMT,G2H4(301),n2h4(183))
  call Hloop_QV_A(ntryL,G1H8(481),ex3(:),G1H4(16),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G1H4(16),53,nMT,G2H4(302),n2h4(184))
call HGT_raise_alpha_OLR(G1H8(482),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(482),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(482),ex2(:),G1H4(16),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_QV_A(ntryL,G1H8(487),ex3(:),G1H4(17),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(303),n2h4(185))
  call Hloop_QV_A(ntryL,G1H8(493),ex3(:),G1H4(17),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(304),n2h4(186))
call HGT_raise_alpha_OLR(G1H8(488),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(488),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(488),ex2(:),G1H4(17),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_QV_A(ntryL,G1H8(491),ex3(:),G1H4(18),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_Q_A(ntryL,G1H4(18),53,nMT,G2H4(305),n2h4(187))
  call Hloop_QV_A(ntryL,G1H8(492),ex3(:),G1H4(18),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(18),53,nMT,G2H4(306),n2h4(188))
call HGT_raise_alpha_OLR(G1H8(494),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(494),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(494),ex2(:),G1H4(18),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_QV_A(ntryL,G1H8(497),ex3(:),G1H4(19),m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G1H4(19),53,nMT,G2H4(307),n2h4(189))
  call Hloop_QV_A(ntryL,G1H8(498),ex3(:),G1H4(19),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G1H4(19),53,nMT,G2H4(308),n2h4(190))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(63),mass5set(:,11),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(64),mass5set(:,11),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(65),mass5set(:,11),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(63),mass5set(:,11),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(64),mass5set(:,11),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(65),mass5set(:,11),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,3),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(56),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(8),mass5set(:,3),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(57),mass5set(:,3),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(12),mass5set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(50),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(12),mass5set(:,3),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(52),mass5set(:,3),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(21),mass5set(:,5),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(46),mass5set(:,5),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(22),mass5set(:,5),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(66),mass5set(:,5),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(22),mass5set(:,5),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(67),mass5set(:,5),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(23),mass5set(:,6),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(68),mass5set(:,6),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(23),mass5set(:,6),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(69),mass5set(:,6),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(24),mass5set(:,5),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(42),mass5set(:,5),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),16,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(25),mass5set(:,5),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),16,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(70),mass5set(:,5),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(26),mass5set(:,6),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(68),mass5set(:,6),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),16,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(26),mass5set(:,6),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(71),mass5set(:,6),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(25),mass5set(:,5),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),8,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(72),mass5set(:,5),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),8,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(27),mass5set(:,6),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(69),mass5set(:,6),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),8,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(27),mass5set(:,6),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),4,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(71),mass5set(:,6),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),4,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(28),mass5set(:,6),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),16,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(73),mass5set(:,6),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),16,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(28),mass5set(:,6),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),8,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(74),mass5set(:,6),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(29),mass5set(:,6),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),16,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(73),mass5set(:,6),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),16,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(29),mass5set(:,6),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),4,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(75),mass5set(:,6),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),4,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(30),mass5set(:,6),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),8,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(74),mass5set(:,6),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(30),mass5set(:,6),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),4,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(75),mass5set(:,6),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),4,4)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(31),mass5set(:,7),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),16,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(66),mass5set(:,5),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),16,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(32),mass5set(:,8),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),16,4)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(48),mass5set(:,8),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),16,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(33),mass5set(:,9),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),4,4)
  call Hotf_5pt_reduction(G2H4(114),RedSet_5(76),mass5set(:,8),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),4,4)
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(34),mass5set(:,7),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G1H4(396),4)
  call HG1shiftOLR(G1H4(392),8,4)
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(67),mass5set(:,5),  & 
G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),G1H4(402),4)
  call HG1shiftOLR(G1H4(398),8,4)
  call Hotf_5pt_reduction(G2H4(119),RedSet_5(35),mass5set(:,9),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),4,4)
  call Hotf_5pt_reduction(G2H4(122),RedSet_5(77),mass5set(:,8),  & 
G1H4(409),G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),4)
  call HG1shiftOLR(G1H4(410),4,4)
  call Hotf_5pt_reduction(G2H4(123),RedSet_5(36),mass5set(:,8),  & 
G1H4(415),G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(416),8,4)
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(44),mass5set(:,8),  & 
G1H4(421),G1H4(422),G1H4(423),G1H4(424),G1H4(425),G1H4(426),4)
  call HG1shiftOLR(G1H4(422),8,4)
  call Hotf_5pt_reduction(G2H4(127),RedSet_5(37),mass5set(:,7),  & 
G1H4(427),G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(428),16,4)
  call Hotf_5pt_reduction(G2H4(130),RedSet_5(70),mass5set(:,5),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),16,4)
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(38),mass5set(:,7),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G1H4(444),4)
  call HG1shiftOLR(G1H4(440),8,4)
  call Hotf_5pt_reduction(G2H4(134),RedSet_5(72),mass5set(:,5),  & 
G1H4(445),G1H4(446),G1H4(447),G1H4(448),G1H4(449),G1H4(450),4)
  call HG1shiftOLR(G1H4(446),8,4)
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(32),mass5set(:,8),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),4,4)
  call Hotf_5pt_reduction(G2H4(138),RedSet_5(77),mass5set(:,8),  & 
G1H4(457),G1H4(458),G1H4(459),G1H4(460),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(458),4,4)
  call Hotf_5pt_reduction(G2H4(139),RedSet_5(36),mass5set(:,8),  & 
G1H4(463),G1H4(464),G1H4(465),G1H4(466),G1H4(467),G1H4(468),4)
  call HG1shiftOLR(G1H4(464),4,4)
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(76),mass5set(:,8),  & 
G1H4(469),G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),4)
  call HG1shiftOLR(G1H4(470),4,4)
  call Hotf_5pt_reduction(G2H4(143),RedSet_5(39),mass5set(:,8),  & 
G1H4(475),G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),4)
  call HG1shiftOLR(G1H4(476),16,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(58),mass5set(:,8),  & 
G1H4(481),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),16,4)
  call Hotf_5pt_reduction(G2H4(147),RedSet_5(18),mass5set(:,9),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G1H4(492),4)
  call HG1shiftOLR(G1H4(488),4,4)
  call Hotf_5pt_reduction(G2H4(150),RedSet_5(78),mass5set(:,8),  & 
G1H4(493),G1H4(494),G1H4(495),G1H4(496),G1H4(497),G1H4(498),4)
  call HG1shiftOLR(G1H4(494),4,4)
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(39),mass5set(:,8),  & 
G1H4(499),G1H4(500),G1H4(501),G1H4(502),G1H4(503),G1H4(504),4)
  call HG1shiftOLR(G1H4(500),4,4)
  call Hotf_5pt_reduction(G2H4(154),RedSet_5(78),mass5set(:,8),  & 
G1H4(505),G1H4(506),G1H4(507),G1H4(508),G1H4(509),G1H4(510),4)
  call HG1shiftOLR(G1H4(506),4,4)
  call Hotf_5pt_reduction(G2H4(155),RedSet_5(20),mass5set(:,9),  & 
G1H4(511),G1H4(512),G1H4(513),G1H4(514),G1H4(515),G1H4(516),4)
  call HG1shiftOLR(G1H4(512),4,4)
  call Hotf_5pt_reduction(G2H4(158),RedSet_5(79),mass5set(:,8),  & 
G1H4(517),G1H4(518),G1H4(519),G1H4(520),G1H4(521),G1H4(522),4)
  call HG1shiftOLR(G1H4(518),4,4)
  call Hotf_5pt_reduction(G2H4(159),RedSet_5(40),mass5set(:,8),  & 
G1H4(523),G1H4(524),G1H4(525),G1H4(526),G1H4(527),G1H4(528),4)
  call HG1shiftOLR(G1H4(524),8,4)
  call Hotf_5pt_reduction(G2H4(162),RedSet_5(61),mass5set(:,8),  & 
G1H4(529),G1H4(530),G1H4(531),G1H4(532),G1H4(533),G1H4(534),4)
  call HG1shiftOLR(G1H4(530),8,4)
  call Hotf_5pt_reduction(G2H4(163),RedSet_5(40),mass5set(:,8),  & 
G1H4(535),G1H4(536),G1H4(537),G1H4(538),G1H4(539),G1H4(540),4)
  call HG1shiftOLR(G1H4(536),4,4)
  call Hotf_5pt_reduction(G2H4(166),RedSet_5(79),mass5set(:,8),  & 
G1H4(541),G1H4(542),G1H4(543),G1H4(544),G1H4(545),G1H4(546),4)
  call HG1shiftOLR(G1H4(542),4,4)
  call Hloop_QA_V(ntryL,G2H4(167),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(170),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(176),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(177),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(180),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(186),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(187),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(190),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(196),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(197),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(200),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(206),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(207),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(210),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(216),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(217),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(220),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(226),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(227),RedSet_5(14),mass5set(:,4),  & 
G1H4(547),G1H4(548),G1H4(549),G1H4(550),G1H4(551),G1H4(552),4)
  call HG1shiftOLR(G1H4(548),2,4)
  call Hotf_5pt_reduction(G2H4(229),RedSet_5(54),mass5set(:,4),  & 
G1H4(553),G1H4(554),G1H4(555),G1H4(556),G1H4(557),G1H4(558),4)
  call HG1shiftOLR(G1H4(554),2,4)
  call Hotf_4pt_reduction(G2H4(233),RedSet_4(1),mass4set(:,1),  & 
G1H4(559),G1H4(560),G1H4(561),G1H4(562),G1H4(563),4)
  call HG1shiftOLR(G1H4(560),26,4)
  call Hotf_5pt_reduction(G2H4(234),RedSet_5(13),mass5set(:,4),  & 
G1H4(564),G1H4(565),G1H4(566),G1H4(567),G1H4(568),G1H4(569),4)
  call HG1shiftOLR(G1H4(565),2,4)
  call Hotf_5pt_reduction(G2H4(236),RedSet_5(54),mass5set(:,4),  & 
G1H4(570),G1H4(571),G1H4(572),G1H4(573),G1H4(574),G1H4(575),4)
  call HG1shiftOLR(G1H4(571),2,4)
  call Hotf_4pt_reduction(G2H4(240),RedSet_4(1),mass4set(:,1),  & 
G1H4(576),G1H4(577),G1H4(578),G1H4(579),G1H4(580),4)
  call HG1shiftOLR(G1H4(577),26,4)
  call Hloop_AQ_V(ntryL,G2H4(241),ex1(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(244),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(250),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(251),ex1(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(254),ex1(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(260),ex1(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(261),ex2(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(264),ex2(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H4(270),ex2(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H4(271),RedSet_5(18),mass5set(:,4),  & 
G1H4(581),G1H4(582),G1H4(583),G1H4(584),G1H4(585),G1H4(586),4)
  call HG1shiftOLR(G1H4(582),2,4)
  call Hotf_5pt_reduction(G2H4(273),RedSet_5(60),mass5set(:,4),  & 
G1H4(587),G1H4(588),G1H4(589),G1H4(590),G1H4(591),G1H4(592),4)
  call HG1shiftOLR(G1H4(588),2,4)
  call Hotf_4pt_reduction(G2H4(277),RedSet_4(2),mass4set(:,1),  & 
G1H4(593),G1H4(594),G1H4(595),G1H4(596),G1H4(597),4)
  call HG1shiftOLR(G1H4(594),22,4)
  call Hotf_5pt_reduction(G2H4(278),RedSet_5(17),mass5set(:,4),  & 
G1H4(598),G1H4(599),G1H4(600),G1H4(601),G1H4(602),G1H4(603),4)
  call HG1shiftOLR(G1H4(599),2,4)
  call Hotf_5pt_reduction(G2H4(280),RedSet_5(60),mass5set(:,4),  & 
G1H4(604),G1H4(605),G1H4(606),G1H4(607),G1H4(608),G1H4(609),4)
  call HG1shiftOLR(G1H4(605),2,4)
  call Hotf_4pt_reduction(G2H4(284),RedSet_4(2),mass4set(:,1),  & 
G1H4(610),G1H4(611),G1H4(612),G1H4(613),G1H4(614),4)
  call HG1shiftOLR(G1H4(611),22,4)
  call Hloop_QA_V(ntryL,G2H4(285),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(288),ex2(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(294),ex2(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H4(295),RedSet_5(20),mass5set(:,4),  & 
G1H4(615),G1H4(616),G1H4(617),G1H4(618),G1H4(619),G1H4(620),4)
  call HG1shiftOLR(G1H4(616),2,4)
  call Hotf_5pt_reduction(G2H4(297),RedSet_5(62),mass5set(:,4),  & 
G1H4(621),G1H4(622),G1H4(623),G1H4(624),G1H4(625),G1H4(626),4)
  call HG1shiftOLR(G1H4(622),2,4)
  call Hotf_4pt_reduction(G2H4(301),RedSet_4(3),mass4set(:,1),  & 
G1H4(627),G1H4(628),G1H4(629),G1H4(630),G1H4(631),4)
  call HG1shiftOLR(G1H4(628),14,4)
  call Hotf_5pt_reduction(G2H4(302),RedSet_5(19),mass5set(:,4),  & 
G1H4(632),G1H4(633),G1H4(634),G1H4(635),G1H4(636),G1H4(637),4)
  call HG1shiftOLR(G1H4(633),2,4)
  call Hotf_5pt_reduction(G2H4(304),RedSet_5(62),mass5set(:,4),  & 
G1H4(638),G1H4(639),G1H4(640),G1H4(641),G1H4(642),G1H4(643),4)
  call HG1shiftOLR(G1H4(639),2,4)
  call Hotf_4pt_reduction(G2H4(308),RedSet_4(3),mass4set(:,1),  & 
G1H4(644),G1H4(645),G1H4(646),G1H4(647),G1H4(648),4)
  call HG1shiftOLR(G1H4(645),14,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(313),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(325),[G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(337),[G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(361),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(373),[G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(385),[G1H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(397),[G1H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(409),[G1H4(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(421),[G1H4(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(433),[G1H4(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(445),[G1H4(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(457),[G1H4(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(469),[G1H4(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(481),[G1H4(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(493),[G1H4(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(505),[G1H4(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(517),[G1H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(529),[G1H4(528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(541),[G1H4(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(553),[G1H4(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(559),[G1H4(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(570),[G1H4(569)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(576),[G1H4(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(587),[G1H4(586)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(593),[G1H4(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(604),[G1H4(603)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(610),[G1H4(609)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(621),[G1H4(620)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(627),[G1H4(626)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(638),[G1H4(637)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(644),[G1H4(643)])
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(31),n2h2(1))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,nMT,G2H4(1),n2h4(191))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(33),n2h2(2))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,nMT,G2H4(3),n2h4(192))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(35),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(36),n2h2(4))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,nMT,G2H4(4),n2h4(193))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntryL,G1H4(37),ex2(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(38),n2h2(5))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,nMT,G2H4(6),n2h4(194))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(42),ex2(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(40),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(41),n2h2(7))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,nMT,G2H4(7),n2h4(195))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(43),n2h2(8))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-8,nMT,G2H4(9),n2h4(196))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(45),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(46),n2h2(10))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,nMT,G2H4(10),n2h4(197))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(48),n2h2(11))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,nMT,G2H4(12),n2h4(198))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(50),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(67),ex1(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(51),n2h2(13))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-16,nMT,G2H4(13),n2h4(199))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(53),n2h2(14))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,nMT,G2H4(15),n2h4(200))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(55),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(79),ex2(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(56),n2h2(16))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-8,nMT,G2H4(16),n2h4(201))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H4(85),ex2(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(58),n2h2(17))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-8,nMT,G2H4(18),n2h4(202))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_VA_Q(ntryL,G1H4(90),ex2(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(60),n2h2(18))
  call Hloop_UV_W(ntryL,G1H4(91),39,ex4(:),8,G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(92),-16,ex5(:),16,G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
call signflip_OLR(G2H2(62))
  call Hloop_UV_W(ntryL,G1H4(97),39,ex4(:),8,G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(98),-16,ex5(:),16,G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
call signflip_OLR(G2H2(64))
  call Hloop_UV_W(ntryL,G1H4(102),39,ex4(:),8,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_UV_W(ntryL,G1H4(103),39,ex5(:),16,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(104),-8,ex4(:),8,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
call signflip_OLR(G2H2(67))
  call Hloop_UV_W(ntryL,G1H4(109),39,ex5(:),16,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(110),-8,ex4(:),8,G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
call signflip_OLR(G2H2(69))
  call Hloop_UV_W(ntryL,G1H4(114),39,ex5(:),16,G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UV_W(ntryL,G1H4(115),39,ex4(:),8,G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(116),-16,ex5(:),16,G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
call signflip_OLR(G2H2(72))
  call Hloop_UV_W(ntryL,G1H4(121),39,ex4(:),8,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(122),-16,ex5(:),16,G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
call signflip_OLR(G2H2(74))
  call Hloop_UV_W(ntryL,G1H4(126),39,ex4(:),8,G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_UV_W(ntryL,G1H4(127),39,ex5(:),16,G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(128),-8,ex4(:),8,G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
call signflip_OLR(G2H2(77))
  call Hloop_UV_W(ntryL,G1H4(133),39,ex5(:),16,G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(134),-8,ex4(:),8,G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
call signflip_OLR(G2H2(79))
  call Hloop_UV_W(ntryL,G1H4(138),39,ex5(:),16,G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QV_A(ntryL,G1H4(139),ex3(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(81),n2h2(19))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(140),-16,nMT,G2H4(19),n2h4(211))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(145),ex3(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(83),n2h2(20))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-16,nMT,G2H4(21),n2h4(212))
  call Hloop_AV_Q(ntryL,G2H4(21),ex5(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(150),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(85),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(86),n2h2(22))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-16,nMT,G2H4(22),n2h4(213))
  call Hloop_QV_A(ntryL,G2H4(22),ex5(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AV_Q(ntryL,G1H4(157),ex4(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(88),n2h2(23))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(158),-16,nMT,G2H4(24),n2h4(214))
  call Hloop_QV_A(ntryL,G2H4(24),ex5(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_AV_Q(ntryL,G1H4(162),ex4(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(90),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(163),ex5(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(91),n2h2(25))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(164),-8,nMT,G2H4(25),n2h4(215))
  call Hloop_QV_A(ntryL,G2H4(25),ex4(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(93),n2h2(26))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(170),-8,nMT,G2H4(27),n2h4(216))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AV_Q(ntryL,G1H4(174),ex5(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(95),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(175),ex4(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(96),n2h2(28))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-16,nMT,G2H4(28),n2h4(217))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QV_A(ntryL,G1H4(181),ex4(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(98),n2h2(29))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-16,nMT,G2H4(30),n2h4(218))
  call Hloop_AV_Q(ntryL,G2H4(30),ex5(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QV_A(ntryL,G1H4(186),ex4(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(100),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(187),ex5(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(101),n2h2(31))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-8,nMT,G2H4(31),n2h4(219))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(193),ex5(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(103),n2h2(32))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-8,nMT,G2H4(34),n2h4(220))
  call Hloop_AV_Q(ntryL,G2H4(34),ex4(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_QV_A(ntryL,G1H4(198),ex5(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(105),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(199),ex3(:),G1H2(1),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(106),n2h2(34))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-16,nMT,G2H4(35),n2h4(221))
  call Hloop_QV_A(ntryL,G2H4(35),ex5(:),G2H2(107),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AV_Q(ntryL,G1H4(205),ex3(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(108),n2h2(35))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(206),-16,nMT,G2H4(38),n2h4(222))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AV_Q(ntryL,G1H4(210),ex3(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(110),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(211),ex4(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(111),n2h2(37))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(212),-16,nMT,G2H4(39),n2h4(223))
  call Hloop_AV_Q(ntryL,G2H4(39),ex5(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntryL,G1H4(217),ex4(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(113),n2h2(38))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)



end subroutine vamp_1

end module ol_vamp_1_ppattj_ttxaggg_1_/**/REALKIND
