
module ol_vamp_3_ppattj_uuxttxag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppattj_uuxttxag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppattj_uuxttxag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppattj_uuxttxag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppattj_uuxttxag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppattj_uuxttxag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppattj_uuxttxag_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(4,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_Q_A(ntryL,G1H16(45),33,0,G2H16(19),n2h16(77))
  call Hloop_QA_V(ntryL,G1H32(81),ex2(:),G1H16(50),m3h2x16(:,108),heltab2x32(:,:,151))
  call Hloop_VA_Q(ntryL,G1H32(82),ex2(:),G1H16(29),m3h2x16(:,109),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(29),34,0,G2H16(20),n2h16(78))
  call Hloop_AQ_V(ntryL,G1H32(83),ex1(:),G1H16(13),m3h2x16(:,110),heltab2x32(:,:,153))
  call Hloop_VQ_A(ntryL,G1H32(84),ex1(:),G1H16(2),m3h2x16(:,111),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G1H16(2),33,0,G2H16(21),n2h16(79))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,180),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G0H4(1),58,0,G1H4(143),n2h4(174))
  call Hloop_VQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,181),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(144),n2h4(175))
  call ol_merge(ntryL,G1H4(219),[G1H4(129)])
call HGT_w2_OLR(G1H4(42),1,1,4)
call HGT_w2_invQ_OLR(G1H4(42),2,5,4)
  call ol_merge(ntryL,G1H4(42),[G1H4(219)])
  call ol_merge(ntryL,G2H4(71),[G2H4(74),G2H4(56),G1H4(218),G1H4(158),G1H4(46),G1H4(142)])
  call ol_merge(ntryL,G1H4(169),[G1H4(21)])
call HGT_w2_OLR(G1H4(53),1,1,4)
call HGT_w2_invQ_OLR(G1H4(53),2,5,4)
  call ol_merge(ntryL,G1H4(53),[G1H4(169)])
  call ol_merge(ntryL,G2H4(60),[G1H4(167),G1H4(60),G1H4(16)])
call HGT_lower_alpha_w2_OLR(G2H4(64),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(64),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(64),6,15,4)
  call ol_merge(ntryL,G2H4(64),[G2H4(68)])
  call ol_merge(ntryL,G2H4(63),[G1H4(217)])
call HGT_lower_alpha_w2_OLR(G2H4(69),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(69),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(69),6,15,4)
  call ol_merge(ntryL,G2H4(69),[G2H4(63)])
  call ol_merge(ntryL,G2H8(16),[G1H8(120)])
  call ol_merge(ntryL,G1H8(82),[G1H8(45)])
call HGT_w2_OLR(G1H8(14),1,1,8)
call HGT_w2_invQ_OLR(G1H8(14),2,5,8)
  call ol_merge(ntryL,G1H8(14),[G1H8(82)])
  call ol_merge(ntryL,G2H4(67),[G1H4(72)])
call HGT_lower_alpha_OLR(G2H4(77),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(77),2,5,4)
call HGT_lower_alpha_OLR(G2H4(77),6,15,4)
  call ol_merge(ntryL,G2H4(77),[G2H4(67)])
  call ol_merge(ntryL,G1H8(91),[G1H8(6)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntryL,G1H8(4),[G1H8(91)])
  call ol_merge(ntryL,G2H8(40),[G1H8(136)])
call HGT_lower_alpha_OLR(G2H4(78),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(78),2,5,4)
call HGT_lower_alpha_OLR(G2H4(78),6,15,4)
  call ol_merge(ntryL,G2H4(78),[G1H4(57)])
  call ol_merge(ntryL,G1H8(92),[G1H8(19)])
call HGT_w2_OLR(G1H8(44),1,1,8)
call HGT_w2_invQ_OLR(G1H8(44),2,5,8)
  call ol_merge(ntryL,G1H8(44),[G1H8(92)])
  call ol_merge(ntryL,G2H4(80),[G1H4(234)])
  call ol_merge(ntryL,G1H4(92),[G1H4(107)])
  call ol_merge(ntryL,G1H4(73),[G1H4(116),G1H4(137),G1H4(108)])
  call ol_merge(ntryL,G1H4(2),[G1H4(120)])
  call ol_merge(ntryL,G1H4(155),[G1H4(26),G1H4(70),G1H4(124)])
  call ol_merge(ntryL,G1H4(44),[G1H4(136)])
  call ol_merge(ntryL,G1H4(149),[G1H4(58)])
  call ol_merge(ntryL,G1H4(89),[G1H4(130)])
  call ol_merge(ntryL,G1H4(25),[G1H4(12)])
  call ol_merge(ntryL,G1H4(176),[G1H4(41)])
  call ol_merge(ntryL,G1H4(180),[G1H4(59)])
  call ol_merge(ntryL,G2H4(3),[G1H4(175),G1H4(99),G1H4(88)])
  call ol_merge(ntryL,G2H4(4),[G1H4(179),G1H4(166),G1H4(105)])
  call ol_merge(ntryL,G1H4(203),[G1H4(184),G1H4(13)])
  call ol_merge(ntryL,G1H4(200),[G1H4(190),G1H4(9)])
  call ol_merge(ntryL,G1H4(101),[G1H4(33)])
  call ol_merge(ntryL,G1H4(112),[G1H4(196),G1H4(37)])
  call ol_merge(ntryL,G1H4(236),[G1H4(55)])
  call ol_merge(ntryL,G1H4(102),[G1H4(202),G1H4(56)])
  call ol_merge(ntryL,G1H4(126),[G1H4(140),G1H4(91)])
  call ol_merge(ntryL,G1H4(131),[G1H4(20),G1H4(1)])
  call ol_merge(ntryL,G1H4(119),[G1H4(63),G1H4(30)])
  call ol_merge(ntryL,G1H4(125),[G1H4(154),G1H4(87)])
  call ol_merge(ntryL,G1H4(224),[G1H4(163)])
  call ol_merge(ntryL,G1H4(204),[G1H4(183)])
  call ol_merge(ntryL,G1H8(81),[G1H8(27)])
  call ol_merge(ntryL,G2H8(32),[G1H8(29)])
  call ol_merge(ntryL,G1H4(235),[G1H4(189)])
  call ol_merge(ntryL,G2H8(2),[G1H8(46)])
  call ol_merge(ntryL,G2H8(5),[G1H8(10)])
  call ol_merge(ntryL,G1H4(113),[G1H4(195)])
  call ol_merge(ntryL,G1H8(87),[G1H8(18)])
  call ol_merge(ntryL,G2H8(7),[G1H8(41)])
  call ol_merge(ntryL,G1H8(88),[G1H8(7)])
  call ol_merge(ntryL,G2H8(18),[G1H8(20)])
  call ol_merge(ntryL,G1H4(114),[G1H4(201)])
  call ol_merge(ntryL,G2H8(26),[G1H8(25)])
  call ol_merge(ntryL,G1H8(99),[G1H8(30)])
  call ol_merge(ntryL,G2H8(41),[G1H8(54),G1H8(22)])
  call ol_merge(ntryL,G1H8(97),[G1H8(53)])
  call ol_merge(ntryL,G1H8(109),[G1H8(59)])
  call ol_merge(ntryL,G2H8(43),[G1H8(66),G1H8(60)])
  call ol_merge(ntryL,G1H8(105),[G1H8(65)])
  call ol_merge(ntryL,G1H8(115),[G1H8(71)])
  call ol_merge(ntryL,G2H8(33),[G1H8(78),G1H8(72)])
  call ol_merge(ntryL,G1H8(111),[G1H8(77)])
  call ol_merge(ntryL,G1H8(112),[G1H8(83)])
  call ol_merge(ntryL,G2H8(12),[G1H8(90),G1H8(84)])
  call ol_merge(ntryL,G1H8(116),[G1H8(89)])
  call ol_merge(ntryL,G1H8(124),[G1H8(95)])
  call ol_merge(ntryL,G2H8(38),[G1H8(102),G1H8(96)])
  call ol_merge(ntryL,G1H8(123),[G1H8(101)])
  call ol_merge(ntryL,G1H8(128),[G1H8(107)])
  call ol_merge(ntryL,G2H8(35),[G1H8(114),G1H8(108)])
  call ol_merge(ntryL,G1H8(127),[G1H8(113)])
  call ol_merge(ntryL,G1H4(229),[G1H4(208)])
  call ol_merge(ntryL,G2H8(25),[G1H8(119)])
  call ol_merge(ntryL,G2H8(28),[G1H8(135)])
  call ol_merge(ntryL,G2H4(66),[G1H4(233)])
  call Hloop_VQ_A(ntryL,G1H4(42),ex3(:),G1H2(282),m3h2x2(:,281),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(282),47,nMT,G2H2(2),n2h2(221))
call Hotf_4pt_reduction(G2H4(71),RedSet_4(54),mass4set(:,2),  & 
G1H4(148),G1H4(82),G1H4(94),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(82),8,4)
  call Hloop_VA_Q(ntryL,G1H4(53),ex4(:),G1H2(294),m3h2x2(:,282),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(294),47,nMT,G2H2(4),n2h2(222))
call Hotf_4pt_reduction(G2H4(60),RedSet_4(68),mass4set(:,2),  & 
G1H4(10),G1H4(11),G1H4(17),G1H4(18),G1H4(206),4)
call HG1shiftOLR(G1H4(11),4,4)
call Hotf_4pt_reduction(G2H4(64),RedSet_4(327),mass4set(:,8),  & 
G1H4(209),G1H4(211),G1H4(214),G1H4(215),G1H4(216),4)
call HG1shiftOLR(G1H4(211),4,4)
  call Hloop_AQ_V(ntryL,G2H4(65),ex3(:),G2H2(6),m3h2x2(:,283),heltab2x4(:,:,339))
call Hotf_4pt_reduction(G2H4(69),RedSet_4(293),mass4set(:,8),  & 
G1H4(221),G1H4(226),G1H4(222),G1H4(225),G1H4(227),4)
call HG1shiftOLR(G1H4(226),8,4)
  call Hloop_QA_V(ntryL,G2H4(70),ex4(:),G2H2(8),m3h2x2(:,284),heltab2x4(:,:,340))
call HGT_w2_OLR(G1H8(50),1,1,8)
call HGT_w2_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(50),ex5(:),G1H4(230),m3h2x4(:,182),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(230),60,nMT,G2H4(72),n2h4(176))
call Hotf_4pt_reduction(G2H8(16),RedSet_4(291),mass4set(:,2),  & 
G1H8(133),G1H8(134),G1H8(139),G1H8(144),G1H8(140),8)
call HG1shiftOLR(G1H8(134),8,8)
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,1),G1H2(324),m3h4x2(:,49),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(324),47,nMT,G2H2(46),n2h2(223))
call Hotf_4pt_reduction(G2H4(77),RedSet_4(240),mass4set(:,3),  & 
G1H4(231),G1H4(232),G1H4(237),G1H4(242),G1H4(238),4)
call HG1shiftOLR(G1H4(232),2,4)
  call Hloop_QA_V(ntryL,G2H8(36),ex2(:),G2H4(73),m3h2x4(:,183),heltab2x8(:,:,232))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(241),m3h2x4(:,184),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(241),51,0,G2H4(75),n2h4(177))
call Hotf_4pt_reduction(G2H8(40),RedSet_4(296),mass4set(:,3),  & 
G1H8(143),G1H8(145),G1H8(148),G1H8(52),G1H8(137),8)
call HG1shiftOLR(G1H8(145),2,8)
call Hotf_4pt_reduction(G2H4(78),RedSet_4(244),mass4set(:,3),  & 
G1H4(243),G1H4(246),G1H4(62),G1H4(97),G1H4(173),4)
call HG1shiftOLR(G1H4(246),1,4)
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(76),m3h2x4(:,185),heltab2x8(:,:,234))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,12),G1H2(342),m3h4x2(:,50),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(342),47,0,G2H2(47),n2h2(224))
call Hotf_4pt_reduction(G2H4(80),RedSet_4(299),mass4set(:,3),  & 
G1H4(185),G1H4(66),G1H4(71),G1H4(84),G1H4(90),4)
call HG1shiftOLR(G1H4(66),2,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex3(:),G1H2(372),m3h2x2(:,285),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(372),55,nMT,G2H2(49),n2h2(225))
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(383),m3h2x2(:,286),heltab2x4(:,:,342))
  call Hloop_Q_A(ntryL,G1H2(383),55,nMT,G2H2(50),n2h2(226))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(414),m3h2x2(:,287),heltab2x4(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(414),59,nMT,G2H2(52),n2h2(227))
  call Hloop_VA_Q(ntryL,G1H4(155),ex4(:),G1H2(425),m3h2x2(:,288),heltab2x4(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(425),59,nMT,G2H2(53),n2h2(228))
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(436),m3h2x2(:,289),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(436),55,nMT,G2H2(55),n2h2(229))
  call Hloop_VA_Q(ntryL,G1H4(149),ex4(:),G1H2(447),m3h2x2(:,290),heltab2x4(:,:,346))
  call Hloop_A_Q(ntryL,G1H2(447),59,nMT,G2H2(56),n2h2(230))
  call Hloop_QV_A(ntryL,G1H4(89),ex5(:),G1H2(458),m3h2x2(:,291),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(458),55,nMT,G2H2(88),n2h2(231))
  call Hloop_AV_Q(ntryL,G1H4(25),ex5(:),G1H2(469),m3h2x2(:,292),heltab2x4(:,:,348))
  call Hloop_A_Q(ntryL,G1H2(469),59,nMT,G2H2(90),n2h2(232))
  call Hloop_QV_A(ntryL,G1H4(176),ex5(:),G1H2(480),m3h2x2(:,293),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(480),55,nMT,G2H2(87),n2h2(233))
  call Hloop_AV_Q(ntryL,G1H4(180),ex5(:),G1H2(491),m3h2x2(:,294),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(491),59,nMT,G2H2(89),n2h2(234))
  call Hloop_QV_A(ntryL,G1H4(76),ex5(:),G1H2(107),m3h2x2(:,295),heltab2x4(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(107),61,0,G2H2(10),n2h2(235))
call Hotf_4pt_reduction(G2H4(3),RedSet_4(49),mass4set(:,2),  & 
G1H4(95),G1H4(93),G1H4(7),G1H4(36),G1H4(40),4)
call HG1shiftOLR(G1H4(93),8,4)
  call Hloop_AV_Q(ntryL,G1H4(69),ex5(:),G1H2(22),m3h2x2(:,296),heltab2x4(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(22),62,0,G2H2(11),n2h2(236))
call Hotf_4pt_reduction(G2H4(4),RedSet_4(63),mass4set(:,2),  & 
G1H4(35),G1H4(141),G1H4(15),G1H4(31),G1H4(45),4)
call HG1shiftOLR(G1H4(141),4,4)
  call Hloop_VQ_A(ntryL,G1H4(203),ex3(:),G1H2(46),m3h2x2(:,297),heltab2x4(:,:,353))
  call Hloop_Q_A(ntryL,G1H2(46),47,nMT,G2H2(13),n2h2(237))
  call Hloop_VA_Q(ntryL,G1H4(200),ex4(:),G1H2(52),m3h2x2(:,298),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(52),47,nMT,G2H2(14),n2h2(238))
  call Hloop_VQ_A(ntryL,G1H4(101),ex1(:),G1H2(58),m3h2x2(:,299),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(58),47,0,G2H2(16),n2h2(239))
  call Hloop_VQ_A(ntryL,G1H4(112),ex1(:),G1H2(82),m3h2x2(:,300),heltab2x4(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(82),47,0,G2H2(17),n2h2(240))
  call Hloop_VA_Q(ntryL,G1H4(236),ex2(:),G1H2(88),m3h2x2(:,301),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(88),47,0,G2H2(19),n2h2(241))
  call Hloop_VA_Q(ntryL,G1H4(102),ex2(:),G1H2(1),m3h2x2(:,302),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(242))
  call Hloop_VQ_A(ntryL,G1H4(126),ex3(:),G1H2(19),m3h2x2(:,303),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(22),n2h2(243))
  call Hloop_VA_Q(ntryL,G1H4(131),ex4(:),G1H2(7),m3h2x2(:,304),heltab2x4(:,:,360))
  call Hloop_A_Q(ntryL,G1H2(7),59,nMT,G2H2(23),n2h2(244))
  call Hloop_VQ_A(ntryL,G1H4(119),ex3(:),G1H2(43),m3h2x2(:,305),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMT,G2H2(25),n2h2(245))
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(55),m3h2x2(:,306),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(55),59,nMT,G2H2(26),n2h2(246))
  call Hloop_QV_A(ntryL,G1H4(162),ex5(:),G1H2(13),m3h2x2(:,307),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(28),n2h2(247))
  call Hloop_QV_A(ntryL,G1H4(224),ex5(:),G1H2(49),m3h2x2(:,308),heltab2x4(:,:,364))
  call Hloop_Q_A(ntryL,G1H2(49),55,nMT,G2H2(29),n2h2(248))
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(25),m3h2x2(:,309),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(25),59,nMT,G2H2(31),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H4(172),ex5(:),G1H2(26),m3h2x2(:,310),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(26),59,nMT,G2H2(32),n2h2(250))
  call Hloop_VQ_A(ntryL,G1H4(204),ex3(:),G1H2(27),m3h2x2(:,311),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(27),47,nMT,G2H2(77),n2h2(251))
  call Hloop_AV_Q(ntryL,G1H8(81),wf4(:,1),G1H2(38),m3h4x2(:,51),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(38),47,nMT,G2H2(34),n2h2(252))
call Hotf_4pt_reduction(G2H8(32),RedSet_4(309),mass4set(:,4),  & 
G1H8(47),G1H8(49),G1H8(23),G1H8(48),G1H8(121),G0H8(9),8)
call HG1shiftOLR(G1H8(49),16,8)
  call Hloop_VA_Q(ntryL,G1H4(235),ex4(:),G1H2(39),m3h2x2(:,312),heltab2x4(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(39),47,nMT,G2H2(35),n2h2(253))
call Hotf_4pt_reduction(G2H8(2),RedSet_4(309),mass4set(:,4),  & 
G1H8(51),G1H8(122),G1H8(42),G1H8(138),G1H8(36),G0H8(10),8)
call HG1shiftOLR(G1H8(122),16,8)
call Hotf_4pt_reduction(G2H8(5),RedSet_4(235),mass4set(:,3),  & 
G1H8(21),G1H8(33),G1H8(34),G1H8(39),G1H8(40),G0H8(3),8)
call HG1shiftOLR(G1H8(33),12,8)
  call Hloop_VQ_A(ntryL,G1H4(113),ex1(:),G1H2(44),m3h2x2(:,313),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(78),n2h2(254))
  call Hloop_AV_Q(ntryL,G1H8(87),ex5(:),G1H4(49),m3h2x4(:,186),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(49),51,0,G2H4(79),n2h4(178))
call Hotf_4pt_reduction(G2H8(7),RedSet_4(235),mass4set(:,3),  & 
G1H8(16),G1H8(9),G1H8(17),G1H8(31),G1H8(1),G0H8(2),8)
call HG1shiftOLR(G1H8(9),12,8)
  call Hloop_AV_Q(ntryL,G1H8(88),wf4(:,12),G1H2(63),m3h4x2(:,52),heltab2x8(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(63),47,0,G2H2(37),n2h2(255))
call Hotf_4pt_reduction(G2H8(18),RedSet_4(306),mass4set(:,3),  & 
G1H8(2),G1H8(3),G1H8(28),G1H8(26),G1H8(24),G0H8(1),8)
call HG1shiftOLR(G1H8(3),16,8)
  call Hloop_VA_Q(ntryL,G1H4(114),ex2(:),G1H2(51),m3h2x2(:,314),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(51),47,0,G2H2(38),n2h2(256))
call Hotf_4pt_reduction(G2H8(26),RedSet_4(306),mass4set(:,3),  & 
G1H8(32),G1H8(37),G1H8(38),G1H8(55),G1H8(56),G0H8(6),8)
call HG1shiftOLR(G1H8(37),16,8)
  call Hloop_VA_Q(ntryL,G1H8(99),ex2(:),G1H4(67),m3h2x4(:,187),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(67),46,0,G2H4(81),n2h4(179))
call Hotf_4pt_reduction(G2H8(41),RedSet_4(238),mass4set(:,3),  & 
G1H8(57),G1H8(58),G1H8(61),G1H8(62),G1H8(63),8)
call HG1shiftOLR(G1H8(58),17,8)
  call Hloop_VA_Q(ntryL,G1H8(97),ex2(:),G1H4(68),m3h2x4(:,188),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(68),46,0,G2H4(82),n2h4(180))
  call Hloop_VQ_A(ntryL,G1H8(109),ex1(:),G1H4(104),m3h2x4(:,189),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(104),45,0,G2H4(22),n2h4(181))
call Hotf_4pt_reduction(G2H8(43),RedSet_4(239),mass4set(:,3),  & 
G1H8(64),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
call HG1shiftOLR(G1H8(67),18,8)
  call Hloop_VQ_A(ntryL,G1H8(105),ex1(:),G1H4(134),m3h2x4(:,190),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(134),45,0,G2H4(25),n2h4(182))
  call Hloop_VA_Q(ntryL,G1H8(115),ex4(:),G1H4(110),m3h2x4(:,191),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(110),43,nMT,G2H4(28),n2h4(183))
call Hotf_4pt_reduction(G2H8(33),RedSet_4(70),mass4set(:,1),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(79),8)
call HG1shiftOLR(G1H8(74),20,8)
  call Hloop_VA_Q(ntryL,G1H8(111),ex4(:),G1H4(139),m3h2x4(:,192),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(139),43,nMT,G2H4(31),n2h4(184))
  call Hloop_VQ_A(ntryL,G1H8(112),wf4(:,4),G1H2(56),m3h4x2(:,53),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(56),55,nMT,G2H2(79),n2h2(257))
call Hotf_4pt_reduction(G2H8(12),RedSet_4(55),mass4set(:,1),  & 
G1H8(80),G1H8(12),G1H8(15),G1H8(85),G1H8(86),8)
call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_VQ_A(ntryL,G1H8(116),wf4(:,4),G1H2(81),m3h4x2(:,54),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(81),55,nMT,G2H2(40),n2h2(258))
  call Hloop_VQ_A(ntryL,G1H8(124),ex3(:),G1H4(3),m3h2x4(:,193),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(3),39,nMT,G2H4(34),n2h4(185))
call Hotf_4pt_reduction(G2H8(38),RedSet_4(56),mass4set(:,1),  & 
G1H8(8),G1H8(13),G1H8(5),G1H8(11),G1H8(43),8)
call HG1shiftOLR(G1H8(13),24,8)
  call Hloop_VQ_A(ntryL,G1H8(123),ex3(:),G1H4(4),m3h2x4(:,194),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(4),39,nMT,G2H4(38),n2h4(186))
  call Hloop_VA_Q(ntryL,G1H8(128),wf4(:,9),G1H2(69),m3h4x2(:,55),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(69),59,nMT,G2H2(41),n2h2(259))
call Hotf_4pt_reduction(G2H8(35),RedSet_4(69),mass4set(:,1),  & 
G1H8(35),G1H8(120),G1H8(45),G1H8(82),G1H8(6),8)
call HG1shiftOLR(G1H8(120),4,8)
  call Hloop_VA_Q(ntryL,G1H8(127),wf4(:,9),G1H2(73),m3h4x2(:,56),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(73),59,nMT,G2H2(80),n2h2(260))
  call Hloop_QV_A(ntryL,G1H4(207),ex5(:),G1H2(79),m3h2x2(:,315),heltab2x4(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(79),55,nMT,G2H2(43),n2h2(261))
  call Hloop_QV_A(ntryL,G1H4(229),ex5(:),G1H2(80),m3h2x2(:,316),heltab2x4(:,:,372))
  call Hloop_Q_A(ntryL,G1H2(80),55,nMT,G2H2(44),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H4(212),ex5(:),G1H2(85),m3h2x2(:,317),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(85),59,nMT,G2H2(1),n2h2(263))
  call Hloop_AV_Q(ntryL,G1H4(213),ex5(:),G1H2(110),m3h2x2(:,318),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(110),59,nMT,G2H2(220),n2h2(264))
call Hotf_4pt_reduction(G2H8(25),RedSet_4(290),mass4set(:,8),  & 
G1H8(91),G1H8(136),G1H8(19),G1H8(92),G1H8(27),8)
call HG1shiftOLR(G1H8(136),8,8)
  call Hloop_QV_A(ntryL,G1H8(125),wf4(:,1),G1H2(111),m3h4x2(:,57),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(111),55,nMT,G2H2(222),n2h2(265))
  call Hloop_QV_A(ntryL,G1H8(126),wf4(:,1),G1H2(112),m3h4x2(:,58),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(112),55,nMT,G2H2(3),n2h2(266))
  call Hloop_QV_A(ntryL,G1H8(130),wf4(:,1),G1H2(116),m3h4x2(:,59),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(116),55,nMT,G2H2(226),n2h2(267))
  call Hloop_QV_A(ntryL,G1H8(131),wf4(:,1),G1H2(117),m3h4x2(:,60),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(117),55,nMT,G2H2(228),n2h2(268))
  call Hloop_QV_A(ntryL,G1H4(223),ex5(:),G1H2(118),m3h2x2(:,319),heltab2x4(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(118),55,nMT,G2H2(5),n2h2(269))
  call Hloop_QV_A(ntryL,G1H4(228),ex5(:),G1H2(122),m3h2x2(:,320),heltab2x4(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(122),55,nMT,G2H2(217),n2h2(270))
call Hotf_4pt_reduction(G2H8(28),RedSet_4(295),mass4set(:,3),  & 
G1H8(29),G1H8(46),G1H8(10),G1H8(18),G1H8(41),8)
call HG1shiftOLR(G1H8(46),2,8)
  call Hloop_QV_A(ntryL,G1H8(141),wf4(:,12),G1H2(123),m3h4x2(:,61),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(123),61,0,G2H2(219),n2h2(271))
  call Hloop_QV_A(ntryL,G1H8(142),wf4(:,12),G1H2(124),m3h4x2(:,62),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(124),61,0,G2H2(7),n2h2(272))
  call Hloop_QV_A(ntryL,G1H8(146),wf4(:,12),G1H2(128),m3h4x2(:,63),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(128),61,0,G2H2(223),n2h2(273))
  call Hloop_QV_A(ntryL,G1H8(147),wf4(:,12),G1H2(129),m3h4x2(:,64),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(129),61,0,G2H2(225),n2h2(274))
call Hotf_4pt_reduction(G2H4(66),RedSet_4(298),mass4set(:,3),  & 
G1H4(32),G1H4(28),G1H4(38),G1H4(74),G1H4(75),4)
call HG1shiftOLR(G1H4(28),2,4)
  call Hloop_QV_A(ntryL,G1H4(239),ex5(:),G1H2(130),m3h2x2(:,321),heltab2x4(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(130),61,0,G2H2(81),n2h2(275))
  call Hloop_QV_A(ntryL,G1H4(240),ex5(:),G1H2(134),m3h2x2(:,322),heltab2x4(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(134),61,0,G2H2(9),n2h2(276))
  call Hloop_QV_A(ntryL,G1H4(244),ex5(:),G1H2(135),m3h2x2(:,323),heltab2x4(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(135),61,0,G2H2(82),n2h2(277))
  call Hloop_QV_A(ntryL,G1H4(245),ex5(:),G1H2(136),m3h2x2(:,324),heltab2x4(:,:,380))
  call Hloop_Q_A(ntryL,G1H2(136),61,0,G2H2(83),n2h2(278))
  call Hloop_AQ_V(ntryL,G2H4(58),ex3(:),G2H2(12),m3h2x2(:,325),heltab2x4(:,:,381))
  call Hloop_QA_V(ntryL,G2H4(62),ex4(:),G2H2(84),m3h2x2(:,326),heltab2x4(:,:,382))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(54),m3h2x4(:,195),heltab2x8(:,:,259))
  call Hloop_AQ_V(ntryL,G2H8(29),ex1(:),G2H4(37),m3h2x4(:,196),heltab2x8(:,:,260))
call Hotf_4pt_reduction(G2H8(31),RedSet_4(309),mass4set(:,3),  & 
G1H8(7),G1H8(20),G1H8(25),G1H8(30),G1H8(54),G0H8(5),8)
call HG1shiftOLR(G1H8(20),16,8)
call Hotf_4pt_reduction(G2H8(1),RedSet_4(309),mass4set(:,3),  & 
G1H8(22),G1H8(53),G1H8(59),G1H8(66),G1H8(60),G0H8(4),8)
call HG1shiftOLR(G1H8(53),16,8)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(309),mass4set(:,9),  & 
G1H8(65),G1H8(71),G1H8(78),G1H8(72),G1H8(77),G0H8(11),8)
call HG1shiftOLR(G1H8(71),16,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(309),mass4set(:,9),  & 
G1H8(83),G1H8(90),G1H8(84),G1H8(89),G1H8(95),G0H8(12),8)
call HG1shiftOLR(G1H8(90),16,8)
call Hotf_4pt_reduction(G2H8(22),RedSet_4(306),mass4set(:,4),  & 
G1H8(102),G1H8(96),G1H8(101),G1H8(107),G1H8(114),G0H8(7),8)
call HG1shiftOLR(G1H8(96),16,8)
call Hotf_4pt_reduction(G2H8(30),RedSet_4(306),mass4set(:,4),  & 
G1H8(108),G1H8(113),G1H8(119),G1H8(135),G1H8(50),G0H8(8),8)
call HG1shiftOLR(G1H8(113),16,8)
call Hotf_4pt_reduction(G2H8(14),RedSet_4(306),mass4set(:,9),  & 
G1H8(14),G1H8(4),G1H8(44),G1H8(81),G1H8(87),G0H8(13),8)
call HG1shiftOLR(G1H8(4),16,8)
call Hotf_4pt_reduction(G2H8(13),RedSet_4(306),mass4set(:,9),  & 
G1H8(88),G1H8(99),G1H8(97),G1H8(109),G1H8(105),G0H8(14),8)
call HG1shiftOLR(G1H8(99),16,8)
call Hotf_4pt_reduction(G2H8(6),RedSet_4(235),mass4set(:,4),  & 
G1H8(115),G1H8(111),G1H8(112),G1H8(116),G1H8(124),G0H8(15),8)
call HG1shiftOLR(G1H8(111),12,8)
call Hotf_4pt_reduction(G2H8(8),RedSet_4(235),mass4set(:,4),  & 
G1H8(123),G1H8(128),G1H8(127),G1H8(125),G1H8(126),G0H8(16),8)
call HG1shiftOLR(G1H8(128),12,8)
call Hotf_4pt_reduction(G2H8(9),RedSet_4(235),mass4set(:,9),  & 
G1H8(130),G1H8(131),G1H8(141),G1H8(142),G1H8(146),G0H8(17),8)
call HG1shiftOLR(G1H8(131),12,8)
call Hotf_4pt_reduction(G2H8(10),RedSet_4(235),mass4set(:,9),  & 
G1H8(147),G1H8(149),G1H8(150),G1H8(151),G1H8(152),G0H8(18),8)
call HG1shiftOLR(G1H8(149),12,8)
  call Hloop_UV_W(ntryL,G1H16(28),40,wf4(:,1),3,G2H4(10),m3h4x4(:,30),heltab2x16(:,:,170))
call Hotf_4pt_reduction(G2H16(1),RedSet_4(155),mass4set(:,2),  & 
G1H16(4),G1H16(9),G1H16(33),G1H16(35),G1H16(11),16)
call HG1shiftOLR(G1H16(9),20,16)
  call Hloop_AQ_V(ntryL,G2H8(11),wf4(:,4),G2H2(15),m3h4x2(:,65),heltab2x8(:,:,261))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(13),m3h2x4(:,197),heltab2x8(:,:,262))
  call Hloop_UV_W(ntryL,G1H16(30),36,wf4(:,1),3,G2H4(16),m3h4x4(:,31),heltab2x16(:,:,171))
call Hotf_4pt_reduction(G2H16(2),RedSet_4(169),mass4set(:,2),  & 
G1H16(16),G1H16(36),G1H16(15),G1H16(21),G1H16(40),16)
call HG1shiftOLR(G1H16(36),24,16)
  call Hloop_QA_V(ntryL,G2H8(34),wf4(:,9),G2H2(85),m3h4x2(:,66),heltab2x8(:,:,263))
  call Hloop_AQ_V(ntryL,G2H8(37),ex3(:),G2H4(19),m3h2x4(:,198),heltab2x8(:,:,264))
  call Hloop_VQ_A(ntryL,G1H16(1),wf8(:,8),G1H2(140),m3h8x2(:,1),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(140),47,nMT,G2H2(86),n2h2(279))
call Hotf_4pt_reduction(G2H16(3),RedSet_4(234),mass4set(:,2),  & 
G1H16(42),G1H16(44),G1H16(10),G1H16(20),G1H16(47),16)
call HG1shiftOLR(G1H16(44),11,16)
  call Hloop_VA_Q(ntryL,G1H16(5),wf8(:,3),G1H2(141),m3h8x2(:,2),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(141),47,nMT,G2H2(18),n2h2(280))
  call Hloop_VQ_A(ntryL,G1H16(6),wf4(:,13),G1H4(151),m3h4x4(:,32),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(151),51,0,G2H4(35),n2h4(187))
  call Hloop_AQ_V(ntryL,G2H16(4),wf4(:,13),G2H4(21),m3h4x4(:,33),heltab2x16(:,:,175))
  call Hloop_UV_W(ntryL,G1H16(31),34,wf4(:,12),12,G2H4(39),m3h4x4(:,34),heltab2x16(:,:,176))
call Hotf_4pt_reduction(G2H16(5),RedSet_4(199),mass4set(:,3),  & 
G1H16(22),G1H16(51),G1H16(8),G1H16(7),G1H16(19),16)
call HG1shiftOLR(G1H16(51),17,16)
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(43),m3h2x4(:,199),heltab2x8(:,:,265))
  call Hloop_VA_Q(ntryL,G1H16(34),wf4(:,18),G1H4(152),m3h4x4(:,35),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(152),51,0,G2H4(23),n2h4(188))
  call Hloop_QA_V(ntryL,G2H16(6),wf4(:,18),G2H4(49),m3h4x4(:,36),heltab2x16(:,:,178))
  call Hloop_UV_W(ntryL,G1H16(14),33,wf4(:,12),12,G2H4(8),m3h4x4(:,37),heltab2x16(:,:,179))
call Hotf_4pt_reduction(G2H16(7),RedSet_4(213),mass4set(:,3),  & 
G1H16(18),G1H16(53),G1H16(3),G1H16(12),G1H16(23),16)
call HG1shiftOLR(G1H16(53),18,16)
  call Hloop_AQ_V(ntryL,G2H8(42),ex1(:),G2H4(51),m3h2x4(:,200),heltab2x8(:,:,266))
call Hotf_4pt_reduction(G2H16(8),RedSet_4(13),mass4set(:,3),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(45),G1H16(29),16)
call HG1shiftOLR(G1H16(26),13,16)
  call Hloop_VQ_A(ntryL,G1H16(17),wf8(:,20),G1H2(142),m3h8x2(:,3),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(142),47,0,G2H2(21),n2h2(281))
call Hotf_4pt_reduction(G2H16(9),RedSet_4(37),mass4set(:,3),  & 
G1H16(2),G1H16(28),G1H16(30),G1H16(1),G1H16(5),16)
call HG1shiftOLR(G1H16(28),14,16)
  call Hloop_VA_Q(ntryL,G1H16(37),wf8(:,16),G1H2(146),m3h8x2(:,4),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(146),47,0,G2H2(133),n2h2(282))
  call Hloop_AQ_V(ntryL,G1H8(93),ex3(:),G1H4(98),m3h2x4(:,201),heltab2x8(:,:,267))
  call Hloop_QA_V(ntryL,G1H8(94),ex4(:),G1H4(109),m3h2x4(:,202),heltab2x8(:,:,268))
  call Hloop_AQ_V(ntryL,G1H8(98),wf4(:,13),G1H2(147),m3h4x2(:,67),heltab2x8(:,:,269))
  call Hloop_AQ_V(ntryL,G1H8(100),wf4(:,13),G1H2(148),m3h4x2(:,68),heltab2x8(:,:,270))
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(93),m3h2x8(:,141),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(93),44,nMT,G2H8(45),n2h8(187))
  call Hloop_QA_V(ntryL,G2H16(10),ex4(:),G2H8(46),m3h2x8(:,142),heltab2x16(:,:,183))
  call Hloop_VQ_A(ntryL,G1H16(41),ex3(:),G1H8(94),m3h2x8(:,143),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H8(94),44,nMT,G2H8(17),n2h8(188))
  call Hloop_AQ_V(ntryL,G2H16(11),ex3(:),G2H8(19),m3h2x8(:,144),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G1H16(43),36,wf8(:,12),19,G2H2(24),m3h8x2(:,5),heltab2x16(:,:,186))
call Hotf_4pt_reduction(G2H16(12),RedSet_4(101),mass4set(:,2),  & 
G1H16(6),G1H16(31),G1H16(34),G1H16(14),G1H16(17),16)
call HG1shiftOLR(G1H16(31),8,16)
  call Hloop_QA_V(ntryL,G1H8(103),ex4(:),G1H4(111),m3h2x4(:,203),heltab2x8(:,:,271))
  call Hloop_AQ_V(ntryL,G1H8(104),ex3(:),G1H4(165),m3h2x4(:,204),heltab2x8(:,:,272))
  call Hloop_QA_V(ntryL,G1H8(106),wf4(:,18),G1H2(152),m3h4x2(:,69),heltab2x8(:,:,273))
  call Hloop_QA_V(ntryL,G1H8(110),wf4(:,18),G1H2(153),m3h4x2(:,70),heltab2x8(:,:,274))
  call Hloop_VA_Q(ntryL,G1H16(46),ex4(:),G1H8(98),m3h2x8(:,145),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(98),44,nMT,G2H8(20),n2h8(189))
  call Hloop_QA_V(ntryL,G2H16(13),ex4(:),G2H8(21),m3h2x8(:,146),heltab2x16(:,:,188))
  call Hloop_VQ_A(ntryL,G1H16(48),ex3(:),G1H8(100),m3h2x8(:,147),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(100),44,nMT,G2H8(23),n2h8(190))
  call Hloop_AQ_V(ntryL,G2H16(14),ex3(:),G2H8(24),m3h2x8(:,148),heltab2x16(:,:,190))
  call Hloop_UV_W(ntryL,G1H16(49),36,wf8(:,17),19,G2H2(137),m3h8x2(:,6),heltab2x16(:,:,191))
call Hotf_4pt_reduction(G2H16(15),RedSet_4(101),mass4set(:,2),  & 
G1H16(37),G1H16(38),G1H16(41),G1H16(43),G1H16(46),16)
call HG1shiftOLR(G1H16(38),8,16)
  call Hloop_AQ_V(ntryL,G1H8(117),ex1(:),G1H4(123),m3h2x4(:,205),heltab2x8(:,:,275))
  call Hloop_QA_V(ntryL,G1H8(118),ex2(:),G1H4(174),m3h2x4(:,206),heltab2x8(:,:,276))
  call Hloop_VA_Q(ntryL,G1H16(52),ex2(:),G1H8(93),m3h2x8(:,149),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H8(93),35,0,G2H8(16),n2h8(191))
  call Hloop_QA_V(ntryL,G2H16(16),ex2(:),G2H8(36),m3h2x8(:,150),heltab2x16(:,:,193))
  call Hloop_VQ_A(ntryL,G1H16(32),ex1(:),G1H8(94),m3h2x8(:,151),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(94),35,0,G2H8(40),n2h8(192))
  call Hloop_AQ_V(ntryL,G2H16(17),ex1(:),G2H8(44),m3h2x8(:,152),heltab2x16(:,:,195))
  call Hloop_UV_W(ntryL,G1H16(24),33,wf8(:,4),28,G2H2(27),m3h8x2(:,7),heltab2x16(:,:,196))
call Hotf_4pt_reduction(G2H16(18),RedSet_4(115),mass4set(:,3),  & 
G1H16(48),G1H16(49),G1H16(52),G1H16(32),G1H16(24),16)
call HG1shiftOLR(G1H16(49),2,16)
  call Hloop_AQ_V(ntryL,G1H4(132),ex1(:),G1H2(154),m3h2x2(:,327),heltab2x4(:,:,383))
  call Hloop_QA_V(ntryL,G1H4(138),ex2(:),G1H2(158),m3h2x2(:,328),heltab2x4(:,:,384))
  call Hloop_QA_V(ntryL,G1H8(129),ex2(:),G1H4(135),m3h2x4(:,207),heltab2x8(:,:,277))
  call Hloop_AQ_V(ntryL,G1H8(132),ex1(:),G1H4(181),m3h2x4(:,208),heltab2x8(:,:,278))
  call Hloop_VA_Q(ntryL,G1H16(39),ex2(:),G1H8(103),m3h2x8(:,153),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H8(103),35,0,G2H8(32),n2h8(193))
  call Hloop_QA_V(ntryL,G2H16(19),ex2(:),G2H8(2),m3h2x8(:,154),heltab2x16(:,:,198))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(104),m3h2x8(:,155),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(104),35,0,G2H8(5),n2h8(194))
  call Hloop_AQ_V(ntryL,G2H16(20),ex1(:),G2H8(7),m3h2x8(:,156),heltab2x16(:,:,200))
  call Hloop_UV_W(ntryL,G1H16(13),33,wf8(:,9),28,G2H2(30),m3h8x2(:,8),heltab2x16(:,:,201))
call Hotf_4pt_reduction(G2H16(21),RedSet_4(115),mass4set(:,3),  & 
G1H16(39),G1H16(50),G1H16(13),G1H16(54),G1H16(55),16)
call HG1shiftOLR(G1H16(50),2,16)
  call Hloop_AQ_V(ntryL,G1H4(143),ex1(:),G1H2(159),m3h2x2(:,329),heltab2x4(:,:,385))
  call Hloop_QA_V(ntryL,G1H4(144),ex2(:),G1H2(160),m3h2x2(:,330),heltab2x4(:,:,386))
  call Hloop_QV_A(ntryL,G1H4(148),ex5(:),G1H2(164),m3h2x2(:,331),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(164),55,nMT,G2H2(33),n2h2(283))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(82),ex4(:),G1H2(165),m3h2x2(:,332),heltab2x4(:,:,388))
  call Hloop_QV_A(ntryL,G1H4(5),ex5(:),G1H2(166),m3h2x2(:,333),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(166),55,nMT,G2H2(36),n2h2(284))
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(170),m3h2x2(:,334),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(170),55,nMT,G2H2(141),n2h2(285))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(171),m3h2x2(:,335),heltab2x4(:,:,391))
  call Hloop_A_Q(ntryL,G1H2(171),59,nMT,G2H2(39),n2h2(286))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(172),m3h2x2(:,336),heltab2x4(:,:,392))
  call Hloop_AV_Q(ntryL,G1H4(18),ex5(:),G1H2(176),m3h2x2(:,337),heltab2x4(:,:,393))
  call Hloop_A_Q(ntryL,G1H2(176),59,nMT,G2H2(42),n2h2(287))
  call Hloop_AV_Q(ntryL,G1H4(206),ex5(:),G1H2(2),m3h2x2(:,338),heltab2x4(:,:,394))
  call Hloop_A_Q(ntryL,G1H2(2),59,nMT,G2H2(145),n2h2(288))
  call Hloop_AV_Q(ntryL,G1H4(209),ex5(:),G1H2(177),m3h2x2(:,339),heltab2x4(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(177),59,nMT,G2H2(45),n2h2(289))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(211),ex3(:),G1H2(181),m3h2x2(:,340),heltab2x4(:,:,396))
  call Hloop_AV_Q(ntryL,G1H4(215),ex5(:),G1H2(4),m3h2x2(:,341),heltab2x4(:,:,397))
  call Hloop_A_Q(ntryL,G1H2(4),59,nMT,G2H2(48),n2h2(290))
  call Hloop_AV_Q(ntryL,G1H4(216),ex5(:),G1H2(182),m3h2x2(:,342),heltab2x4(:,:,398))
  call Hloop_A_Q(ntryL,G1H2(182),59,nMT,G2H2(51),n2h2(291))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(186),m3h2x2(:,343),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(186),55,nMT,G2H2(54),n2h2(292))
call HGT_raise_alpha_OLR(G1H4(226),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(226),ex4(:),G1H2(6),m3h2x2(:,344),heltab2x4(:,:,400))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(187),m3h2x2(:,345),heltab2x4(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(187),55,nMT,G2H2(91),n2h2(293))
  call Hloop_QV_A(ntryL,G1H4(227),ex5(:),G1H2(191),m3h2x2(:,346),heltab2x4(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(191),55,nMT,G2H2(93),n2h2(294))
  call Hloop_QV_A(ntryL,G1H8(133),wf4(:,1),G1H2(8),m3h4x2(:,71),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(94),n2h2(295))
call HGT_raise_alpha_OLR(G1H8(134),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(134),ex4(:),G1H4(186),m3h2x4(:,209),heltab2x8(:,:,280))
  call Hloop_QV_A(ntryL,G1H8(144),wf4(:,1),G1H2(192),m3h4x2(:,72),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(192),55,nMT,G2H2(96),n2h2(296))
  call Hloop_QV_A(ntryL,G1H8(140),wf4(:,1),G1H2(196),m3h4x2(:,73),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(196),55,nMT,G2H2(97),n2h2(297))
  call Hloop_QV_A(ntryL,G1H4(231),ex5(:),G1H2(10),m3h2x2(:,347),heltab2x4(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(10),61,0,G2H2(99),n2h2(298))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(232),ex2(:),G1H2(197),m3h2x2(:,348),heltab2x4(:,:,404))
  call Hloop_QV_A(ntryL,G1H4(242),ex5(:),G1H2(201),m3h2x2(:,349),heltab2x4(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(201),61,0,G2H2(100),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(238),ex5(:),G1H2(12),m3h2x2(:,350),heltab2x4(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(12),61,0,G2H2(102),n2h2(300))
  call Hloop_QV_A(ntryL,G1H8(143),wf4(:,12),G1H2(202),m3h4x2(:,74),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(202),61,0,G2H2(103),n2h2(301))
call HGT_raise_alpha_OLR(G1H8(145),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(145),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(145),ex2(:),G1H4(187),m3h2x4(:,210),heltab2x8(:,:,284))
  call Hloop_QV_A(ntryL,G1H8(52),wf4(:,12),G1H2(206),m3h4x2(:,75),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(206),61,0,G2H2(105),n2h2(302))
  call Hloop_QV_A(ntryL,G1H8(137),wf4(:,12),G1H2(14),m3h4x2(:,76),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(14),61,0,G2H2(106),n2h2(303))
  call Hloop_AV_Q(ntryL,G1H4(243),ex5(:),G1H2(207),m3h2x2(:,351),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G1H2(207),62,0,G2H2(108),n2h2(304))
call HGT_raise_alpha_OLR(G1H4(246),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(246),ex1(:),G1H2(211),m3h2x2(:,352),heltab2x4(:,:,408))
  call Hloop_AV_Q(ntryL,G1H4(97),ex5(:),G1H2(16),m3h2x2(:,353),heltab2x4(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(16),62,0,G2H2(109),n2h2(305))
  call Hloop_AV_Q(ntryL,G1H4(173),ex5(:),G1H2(212),m3h2x2(:,354),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(212),62,0,G2H2(111),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(185),ex5(:),G1H2(216),m3h2x2(:,355),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(216),61,0,G2H2(112),n2h2(307))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(66),ex2(:),G1H2(217),m3h2x2(:,356),heltab2x4(:,:,412))
  call Hloop_QV_A(ntryL,G1H4(84),ex5(:),G1H2(218),m3h2x2(:,357),heltab2x4(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(218),61,0,G2H2(114),n2h2(308))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(222),m3h2x2(:,358),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(222),61,0,G2H2(115),n2h2(309))
  call Hloop_QV_A(ntryL,G1H4(95),ex5(:),G1H2(223),m3h2x2(:,359),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(223),55,nMT,G2H2(117),n2h2(310))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(93),ex4(:),G1H2(224),m3h2x2(:,360),heltab2x4(:,:,416))
  call Hloop_QV_A(ntryL,G1H4(36),ex5(:),G1H2(228),m3h2x2(:,361),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(228),55,nMT,G2H2(118),n2h2(311))
  call Hloop_QV_A(ntryL,G1H4(40),ex5(:),G1H2(229),m3h2x2(:,362),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(229),55,nMT,G2H2(120),n2h2(312))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(230),m3h2x2(:,363),heltab2x4(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(230),59,nMT,G2H2(121),n2h2(313))
call HGT_raise_alpha_OLR(G1H4(141),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(141),ex3(:),G1H2(234),m3h2x2(:,364),heltab2x4(:,:,420))
  call Hloop_AV_Q(ntryL,G1H4(31),ex5(:),G1H2(235),m3h2x2(:,365),heltab2x4(:,:,421))
  call Hloop_A_Q(ntryL,G1H2(235),59,nMT,G2H2(123),n2h2(314))
  call Hloop_AV_Q(ntryL,G1H4(45),ex5(:),G1H2(236),m3h2x2(:,366),heltab2x4(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(236),59,nMT,G2H2(124),n2h2(315))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,1),G1H2(240),m3h4x2(:,77),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(240),47,nMT,G2H2(126),n2h2(316))
call HGT_OLR(G1H8(49),1,1,8)
call HGT_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(49),-16,nMT,G2H8(18),n2h8(197))
  call Hloop_QV_A(ntryL,G2H8(18),ex5(:),G2H4(42),m3h2x4(:,211),heltab2x8(:,:,288))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,1),G1H2(241),m3h4x2(:,78),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(241),47,nMT,G2H2(127),n2h2(317))
  call Hloop_AV_Q(ntryL,G1H8(121),wf4(:,1),G1H2(242),m3h4x2(:,79),heltab2x8(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(242),47,nMT,G2H2(129),n2h2(318))
  call Hloop_AV_Q(ntryL,G0H8(9),wf4(:,1),G0H2(1),m3h4x2(:,80),heltab2x8(:,:,291))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMT,G1H2(246),n2h2(319))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,1),G1H2(247),m3h4x2(:,81),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(247),47,nMT,G2H2(130),n2h2(320))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-16,nMT,G2H8(26),n2h8(198))
  call Hloop_AV_Q(ntryL,G2H8(26),ex5(:),G2H4(46),m3h2x4(:,212),heltab2x8(:,:,293))
  call Hloop_QV_A(ntryL,G1H8(138),wf4(:,1),G1H2(248),m3h4x2(:,82),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(248),47,nMT,G2H2(132),n2h2(321))
  call Hloop_QV_A(ntryL,G1H8(36),wf4(:,1),G1H2(252),m3h4x2(:,83),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(252),47,nMT,G2H2(136),n2h2(322))
  call Hloop_QV_A(ntryL,G0H8(10),wf4(:,1),G0H2(1),m3h4x2(:,84),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMT,G1H2(253),n2h2(323))
  call Hloop_QV_A(ntryL,G1H8(21),ex5(:),G1H4(159),m3h2x4(:,213),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(159),51,0,G2H4(1),n2h4(198))
call HGT_OLR(G1H8(33),1,1,8)
call HGT_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(33),-12,0,G2H8(41),n2h8(199))
  call Hloop_AV_Q(ntryL,G2H8(41),wf4(:,12),G2H2(140),m3h4x2(:,85),heltab2x8(:,:,298))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(160),m3h2x4(:,214),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(160),51,0,G2H4(5),n2h4(199))
  call Hloop_QV_A(ntryL,G1H8(40),ex5(:),G1H4(168),m3h2x4(:,215),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(168),51,0,G2H4(40),n2h4(200))
  call Hloop_QV_A(ntryL,G0H8(3),ex5(:),G0H4(1),m3h2x4(:,216),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(193),n2h4(201))
  call Hloop_AV_Q(ntryL,G1H8(16),ex5(:),G1H4(194),m3h2x4(:,217),heltab2x8(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(194),51,0,G2H4(41),n2h4(202))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(9),-12,0,G2H8(43),n2h8(200))
  call Hloop_QV_A(ntryL,G2H8(43),wf4(:,12),G2H2(144),m3h4x2(:,86),heltab2x8(:,:,303))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(197),m3h2x4(:,218),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(197),51,0,G2H4(17),n2h4(203))
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(198),m3h2x4(:,219),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(198),51,0,G2H4(20),n2h4(204))
  call Hloop_AV_Q(ntryL,G0H8(2),ex5(:),G0H4(1),m3h2x4(:,220),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(220),n2h4(205))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,12),G1H2(254),m3h4x2(:,87),heltab2x8(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(254),47,0,G2H2(148),n2h2(324))
call HGT_OLR(G1H8(3),1,1,8)
call HGT_invQ_OLR(G1H8(3),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(3),-16,0,G2H8(33),n2h8(201))
  call Hloop_QV_A(ntryL,G2H8(33),ex5(:),G2H4(55),m3h2x4(:,221),heltab2x8(:,:,308))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,12),G1H2(258),m3h4x2(:,88),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(258),47,0,G2H2(149),n2h2(325))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,12),G1H2(259),m3h4x2(:,89),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(259),47,0,G2H2(151),n2h2(326))
  call Hloop_AV_Q(ntryL,G0H8(1),wf4(:,12),G0H2(1),m3h4x2(:,90),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(260),n2h2(327))
  call Hloop_QV_A(ntryL,G1H8(32),wf4(:,12),G1H2(264),m3h4x2(:,91),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(264),47,0,G2H2(152),n2h2(328))
call HGT_OLR(G1H8(37),1,1,8)
call HGT_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(37),-16,0,G2H8(12),n2h8(202))
  call Hloop_AV_Q(ntryL,G2H8(12),ex5(:),G2H4(59),m3h2x4(:,222),heltab2x8(:,:,313))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,12),G1H2(265),m3h4x2(:,92),heltab2x8(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(265),47,0,G2H2(154),n2h2(329))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,12),G1H2(266),m3h4x2(:,93),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(266),47,0,G2H2(155),n2h2(330))
  call Hloop_QV_A(ntryL,G0H8(6),wf4(:,12),G0H2(1),m3h4x2(:,94),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(270),n2h2(331))
  call Hloop_VA_Q(ntryL,G1H8(57),ex2(:),G1H4(199),m3h2x4(:,223),heltab2x8(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(199),46,0,G2H4(61),n2h4(206))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(58),wf4(:,13),G1H2(271),m3h4x2(:,95),heltab2x8(:,:,318))
  call Hloop_VA_Q(ntryL,G1H8(62),ex2(:),G1H4(129),m3h2x4(:,224),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(129),46,0,G2H4(26),n2h4(207))
  call Hloop_VA_Q(ntryL,G1H8(63),ex2(:),G1H4(219),m3h2x4(:,225),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G1H4(219),46,0,G2H4(9),n2h4(208))
  call Hloop_VQ_A(ntryL,G1H8(64),ex1(:),G1H4(218),m3h2x4(:,226),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(218),45,0,G2H4(15),n2h4(209))
call HGT_raise_alpha_OLR(G1H8(67),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(67),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(67),wf4(:,18),G1H2(272),m3h4x2(:,96),heltab2x8(:,:,322))
  call Hloop_VQ_A(ntryL,G1H8(69),ex1(:),G1H4(158),m3h2x4(:,227),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(158),45,0,G2H4(18),n2h4(210))
  call Hloop_VQ_A(ntryL,G1H8(70),ex1(:),G1H4(46),m3h2x4(:,228),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(46),45,0,G2H4(29),n2h4(211))
  call Hloop_VA_Q(ntryL,G1H8(73),ex4(:),G1H4(142),m3h2x4(:,229),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(142),43,nMT,G2H4(30),n2h4(212))
call HGT_raise_alpha_OLR(G1H8(74),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(74),wf4(:,4),G1H2(276),m3h4x2(:,97),heltab2x8(:,:,326))
  call Hloop_VA_Q(ntryL,G1H8(76),ex4(:),G1H4(21),m3h2x4(:,230),heltab2x8(:,:,327))
  call Hloop_A_Q(ntryL,G1H4(21),43,nMT,G2H4(33),n2h4(213))
  call Hloop_VA_Q(ntryL,G1H8(79),ex4(:),G1H4(169),m3h2x4(:,231),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(169),43,nMT,G2H4(36),n2h4(214))
  call Hloop_VQ_A(ntryL,G1H8(80),wf4(:,4),G1H2(277),m3h4x2(:,98),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G1H2(277),55,nMT,G2H2(157),n2h2(332))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(167),m3h2x4(:,232),heltab2x8(:,:,330))
  call Hloop_VQ_A(ntryL,G1H8(85),wf4(:,4),G1H2(278),m3h4x2(:,99),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(278),55,nMT,G2H2(158),n2h2(333))
  call Hloop_VQ_A(ntryL,G1H8(86),wf4(:,4),G1H2(389),m3h4x2(:,100),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G1H2(389),55,nMT,G2H2(160),n2h2(334))
  call Hloop_VQ_A(ntryL,G1H8(8),ex3(:),G1H4(60),m3h2x4(:,233),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(60),39,nMT,G2H4(48),n2h4(215))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),wf4(:,9),G1H2(283),m3h4x2(:,101),heltab2x8(:,:,334))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(16),m3h2x4(:,234),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(16),39,nMT,G2H4(74),n2h4(216))
  call Hloop_VQ_A(ntryL,G1H8(43),ex3(:),G1H4(217),m3h2x4(:,235),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(217),39,nMT,G2H4(56),n2h4(217))
  call Hloop_VA_Q(ntryL,G1H8(35),wf4(:,9),G1H2(284),m3h4x2(:,102),heltab2x8(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(284),59,nMT,G2H2(161),n2h2(335))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(120),ex3(:),G1H4(72),m3h2x4(:,236),heltab2x8(:,:,338))
  call Hloop_VA_Q(ntryL,G1H8(82),wf4(:,9),G1H2(288),m3h4x2(:,103),heltab2x8(:,:,339))
  call Hloop_A_Q(ntryL,G1H2(288),59,nMT,G2H2(163),n2h2(336))
  call Hloop_VA_Q(ntryL,G1H8(6),wf4(:,9),G1H2(289),m3h4x2(:,104),heltab2x8(:,:,340))
  call Hloop_A_Q(ntryL,G1H2(289),59,nMT,G2H2(164),n2h2(337))
  call Hloop_QV_A(ntryL,G1H8(91),wf4(:,1),G1H2(290),m3h4x2(:,105),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(290),55,nMT,G2H2(166),n2h2(338))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(136),ex4(:),G1H4(57),m3h2x4(:,237),heltab2x8(:,:,342))
  call Hloop_QV_A(ntryL,G1H8(92),wf4(:,1),G1H2(394),m3h4x2(:,106),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(394),55,nMT,G2H2(167),n2h2(339))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,1),G1H2(295),m3h4x2(:,107),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G1H2(295),55,nMT,G2H2(169),n2h2(340))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,12),G1H2(296),m3h4x2(:,108),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(296),61,0,G2H2(170),n2h2(341))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(46),ex2(:),G1H4(234),m3h2x4(:,238),heltab2x8(:,:,346))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,12),G1H2(300),m3h4x2(:,109),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(300),61,0,G2H2(172),n2h2(342))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,12),G1H2(301),m3h4x2(:,110),heltab2x8(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(301),61,0,G2H2(173),n2h2(343))
  call Hloop_QV_A(ntryL,G1H4(32),ex5(:),G1H2(302),m3h2x2(:,367),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(302),61,0,G2H2(175),n2h2(344))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(306),m3h2x2(:,368),heltab2x4(:,:,424))
  call Hloop_QV_A(ntryL,G1H4(74),ex5(:),G1H2(307),m3h2x2(:,369),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(307),61,0,G2H2(177),n2h2(345))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(308),m3h2x2(:,370),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(308),61,0,G2H2(179),n2h2(346))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,1),G1H2(312),m3h4x2(:,111),heltab2x8(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(312),47,0,G2H2(181),n2h2(347))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,0,G2H8(38),n2h8(211))
  call Hloop_QV_A(ntryL,G2H8(38),ex5(:),G2H4(68),m3h2x4(:,239),heltab2x8(:,:,350))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,1),G1H2(313),m3h4x2(:,112),heltab2x8(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(313),47,0,G2H2(183),n2h2(348))
  call Hloop_AV_Q(ntryL,G1H8(54),wf4(:,1),G1H2(314),m3h4x2(:,113),heltab2x8(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(314),47,0,G2H2(184),n2h2(349))
  call Hloop_AV_Q(ntryL,G0H8(5),wf4(:,1),G0H2(1),m3h4x2(:,114),heltab2x8(:,:,353))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(318),n2h2(350))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,1),G1H2(319),m3h4x2(:,115),heltab2x8(:,:,354))
  call Hloop_Q_A(ntryL,G1H2(319),47,0,G2H2(186),n2h2(351))
call HGT_OLR(G1H8(53),1,1,8)
call HGT_invQ_OLR(G1H8(53),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(53),-16,0,G2H8(35),n2h8(212))
  call Hloop_AV_Q(ntryL,G2H8(35),ex5(:),G2H4(63),m3h2x4(:,240),heltab2x8(:,:,355))
  call Hloop_QV_A(ntryL,G1H8(66),wf4(:,1),G1H2(320),m3h4x2(:,116),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(320),47,0,G2H2(187),n2h2(352))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,1),G1H2(399),m3h4x2(:,117),heltab2x8(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(399),47,0,G2H2(190),n2h2(353))
  call Hloop_QV_A(ntryL,G0H8(4),wf4(:,1),G0H2(1),m3h4x2(:,118),heltab2x8(:,:,358))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(325),n2h2(354))
  call Hloop_AV_Q(ntryL,G1H8(65),wf4(:,1),G1H2(326),m3h4x2(:,119),heltab2x8(:,:,359))
  call Hloop_A_Q(ntryL,G1H2(326),47,nMB,G2H2(191),n2h2(355))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(71),-16,nMB,G2H8(25),n2h8(213))
  call Hloop_QV_A(ntryL,G2H8(25),ex5(:),G2H4(67),m3h2x4(:,241),heltab2x8(:,:,360))
  call Hloop_AV_Q(ntryL,G1H8(72),wf4(:,1),G1H2(330),m3h4x2(:,120),heltab2x8(:,:,361))
  call Hloop_A_Q(ntryL,G1H2(330),47,nMB,G2H2(193),n2h2(356))
  call Hloop_AV_Q(ntryL,G1H8(77),wf4(:,1),G1H2(331),m3h4x2(:,121),heltab2x8(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(331),47,nMB,G2H2(194),n2h2(357))
  call Hloop_AV_Q(ntryL,G0H8(11),wf4(:,1),G0H2(1),m3h4x2(:,122),heltab2x8(:,:,363))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(332),n2h2(358))
  call Hloop_QV_A(ntryL,G1H8(83),wf4(:,1),G1H2(336),m3h4x2(:,123),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G1H2(336),47,nMB,G2H2(197),n2h2(359))
call HGT_OLR(G1H8(90),1,1,8)
call HGT_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(90),-16,nMB,G2H8(28),n2h8(214))
  call Hloop_AV_Q(ntryL,G2H8(28),ex5(:),G2H4(71),m3h2x4(:,242),heltab2x8(:,:,365))
  call Hloop_QV_A(ntryL,G1H8(89),wf4(:,1),G1H2(337),m3h4x2(:,124),heltab2x8(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(337),47,nMB,G2H2(198),n2h2(360))
  call Hloop_QV_A(ntryL,G1H8(95),wf4(:,1),G1H2(338),m3h4x2(:,125),heltab2x8(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(338),47,nMB,G2H2(200),n2h2(361))
  call Hloop_QV_A(ntryL,G0H8(12),wf4(:,1),G0H2(1),m3h4x2(:,126),heltab2x8(:,:,368))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(404),n2h2(362))
  call Hloop_AV_Q(ntryL,G1H8(102),wf4(:,12),G1H2(343),m3h4x2(:,127),heltab2x8(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(343),47,nMT,G2H2(202),n2h2(363))
call HGT_OLR(G1H8(96),1,1,8)
call HGT_invQ_OLR(G1H8(96),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(96),-16,nMT,G2H8(27),n2h8(215))
  call Hloop_QV_A(ntryL,G2H8(27),ex5(:),G2H4(60),m3h2x4(:,243),heltab2x8(:,:,370))
  call Hloop_AV_Q(ntryL,G1H8(107),wf4(:,12),G1H2(344),m3h4x2(:,128),heltab2x8(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(344),47,nMT,G2H2(205),n2h2(364))
  call Hloop_AV_Q(ntryL,G1H8(114),wf4(:,12),G1H2(348),m3h4x2(:,129),heltab2x8(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(348),47,nMT,G2H2(207),n2h2(365))
  call Hloop_AV_Q(ntryL,G0H8(7),wf4(:,12),G0H2(1),m3h4x2(:,130),heltab2x8(:,:,373))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMT,G1H2(349),n2h2(366))
  call Hloop_QV_A(ntryL,G1H8(108),wf4(:,12),G1H2(350),m3h4x2(:,131),heltab2x8(:,:,374))
  call Hloop_Q_A(ntryL,G1H2(350),47,nMT,G2H2(209),n2h2(367))
call HGT_OLR(G1H8(113),1,1,8)
call HGT_invQ_OLR(G1H8(113),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(113),-16,nMT,G2H8(29),n2h8(216))
  call Hloop_AV_Q(ntryL,G2H8(29),ex5(:),G2H4(64),m3h2x4(:,244),heltab2x8(:,:,375))
  call Hloop_QV_A(ntryL,G1H8(135),wf4(:,12),G1H2(354),m3h4x2(:,132),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(354),47,nMT,G2H2(210),n2h2(368))
  call Hloop_QV_A(ntryL,G1H8(50),wf4(:,12),G1H2(355),m3h4x2(:,133),heltab2x8(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(355),47,nMT,G2H2(213),n2h2(369))
  call Hloop_QV_A(ntryL,G0H8(8),wf4(:,12),G0H2(1),m3h4x2(:,134),heltab2x8(:,:,378))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMT,G1H2(356),n2h2(370))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,12),G1H2(360),m3h4x2(:,135),heltab2x8(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(360),47,nMB,G2H2(214),n2h2(371))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-16,nMB,G2H8(31),n2h8(217))
  call Hloop_QV_A(ntryL,G2H8(31),ex5(:),G2H4(65),m3h2x4(:,245),heltab2x8(:,:,380))
  call Hloop_AV_Q(ntryL,G1H8(81),wf4(:,12),G1H2(361),m3h4x2(:,136),heltab2x8(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(361),47,nMB,G2H2(216),n2h2(372))
  call Hloop_AV_Q(ntryL,G1H8(87),wf4(:,12),G1H2(362),m3h4x2(:,137),heltab2x8(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(362),47,nMB,G2H2(231),n2h2(373))
  call Hloop_AV_Q(ntryL,G0H8(13),wf4(:,12),G0H2(1),m3h4x2(:,138),heltab2x8(:,:,383))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(366),n2h2(374))
  call Hloop_QV_A(ntryL,G1H8(88),wf4(:,12),G1H2(367),m3h4x2(:,139),heltab2x8(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(367),47,nMB,G2H2(233),n2h2(375))
call HGT_OLR(G1H8(99),1,1,8)
call HGT_invQ_OLR(G1H8(99),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(99),-16,nMB,G2H8(1),n2h8(218))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(69),m3h2x4(:,246),heltab2x8(:,:,385))
  call Hloop_QV_A(ntryL,G1H8(109),wf4(:,12),G1H2(368),m3h4x2(:,140),heltab2x8(:,:,386))
  call Hloop_Q_A(ntryL,G1H2(368),47,nMB,G2H2(236),n2h2(376))
  call Hloop_QV_A(ntryL,G1H8(105),wf4(:,12),G1H2(373),m3h4x2(:,141),heltab2x8(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(373),47,nMB,G2H2(238),n2h2(377))
  call Hloop_QV_A(ntryL,G0H8(14),wf4(:,12),G0H2(1),m3h4x2(:,142),heltab2x8(:,:,388))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(374),n2h2(378))
  call Hloop_QV_A(ntryL,G1H8(115),ex5(:),G1H4(107),m3h2x4(:,247),heltab2x8(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(107),51,nMT,G2H4(70),n2h4(219))
call HGT_OLR(G1H8(111),1,1,8)
call HGT_invQ_OLR(G1H8(111),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(111),-12,nMT,G2H8(3),n2h8(219))
  call Hloop_AV_Q(ntryL,G2H8(3),wf4(:,12),G2H2(241),m3h4x2(:,143),heltab2x8(:,:,390))
  call Hloop_QV_A(ntryL,G1H8(116),ex5(:),G1H4(116),m3h2x4(:,248),heltab2x8(:,:,391))
  call Hloop_Q_A(ntryL,G1H4(116),51,nMT,G2H4(77),n2h4(220))
  call Hloop_QV_A(ntryL,G1H8(124),ex5(:),G1H4(137),m3h2x4(:,249),heltab2x8(:,:,392))
  call Hloop_Q_A(ntryL,G1H4(137),51,nMT,G2H4(78),n2h4(221))
  call Hloop_QV_A(ntryL,G0H8(15),ex5(:),G0H4(1),m3h2x4(:,250),heltab2x8(:,:,393))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(108),n2h4(222))
  call Hloop_AV_Q(ntryL,G1H8(123),ex5(:),G1H4(120),m3h2x4(:,251),heltab2x8(:,:,394))
  call Hloop_A_Q(ntryL,G1H4(120),51,nMT,G2H4(80),n2h4(223))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(128),-12,nMT,G2H8(4),n2h8(220))
  call Hloop_QV_A(ntryL,G2H8(4),wf4(:,12),G2H2(243),m3h4x2(:,144),heltab2x8(:,:,395))
  call Hloop_AV_Q(ntryL,G1H8(125),ex5(:),G1H4(26),m3h2x4(:,252),heltab2x8(:,:,396))
  call Hloop_A_Q(ntryL,G1H4(26),51,nMT,G2H4(3),n2h4(224))
  call Hloop_AV_Q(ntryL,G1H8(126),ex5(:),G1H4(70),m3h2x4(:,253),heltab2x8(:,:,397))
  call Hloop_A_Q(ntryL,G1H4(70),51,nMT,G2H4(4),n2h4(225))
  call Hloop_AV_Q(ntryL,G0H8(16),ex5(:),G0H4(1),m3h2x4(:,254),heltab2x8(:,:,398))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(124),n2h4(226))
  call Hloop_QV_A(ntryL,G1H8(130),ex5(:),G1H4(136),m3h2x4(:,255),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H4(136),51,nMB,G2H4(66),n2h4(227))
call HGT_OLR(G1H8(131),1,1,8)
call HGT_invQ_OLR(G1H8(131),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(131),-12,nMB,G2H8(22),n2h8(221))
  call Hloop_AV_Q(ntryL,G2H8(22),wf4(:,12),G2H2(246),m3h4x2(:,145),heltab2x8(:,:,400))
  call Hloop_QV_A(ntryL,G1H8(142),ex5(:),G1H4(58),m3h2x4(:,256),heltab2x8(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(58),51,nMB,G2H4(58),n2h4(228))
  call Hloop_QV_A(ntryL,G1H8(146),ex5(:),G1H4(130),m3h2x4(:,257),heltab2x8(:,:,402))
  call Hloop_Q_A(ntryL,G1H4(130),51,nMB,G2H4(62),n2h4(229))
  call Hloop_QV_A(ntryL,G0H8(17),ex5(:),G0H4(1),m3h2x4(:,258),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(12),n2h4(230))
  call Hloop_AV_Q(ntryL,G1H8(147),ex5(:),G1H4(41),m3h2x4(:,259),heltab2x8(:,:,404))
  call Hloop_A_Q(ntryL,G1H4(41),51,nMB,G2H4(83),n2h4(231))
call HGT_OLR(G1H8(149),1,1,8)
call HGT_invQ_OLR(G1H8(149),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(149),-12,nMB,G2H8(30),n2h8(222))
  call Hloop_QV_A(ntryL,G2H8(30),wf4(:,12),G2H2(248),m3h4x2(:,146),heltab2x8(:,:,405))
  call Hloop_AV_Q(ntryL,G1H8(151),ex5(:),G1H4(59),m3h2x4(:,260),heltab2x8(:,:,406))
  call Hloop_A_Q(ntryL,G1H4(59),51,nMB,G2H4(84),n2h4(232))
  call Hloop_AV_Q(ntryL,G1H8(152),ex5(:),G1H4(175),m3h2x4(:,261),heltab2x8(:,:,407))
  call Hloop_A_Q(ntryL,G1H4(175),51,nMB,G2H4(85),n2h4(233))
  call Hloop_AV_Q(ntryL,G0H8(18),ex5(:),G0H4(1),m3h2x4(:,262),heltab2x8(:,:,408))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMB,G1H4(99),n2h4(234))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(88),m3h4x4(:,38),heltab2x16(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(88),43,nMT,G2H4(86),n2h4(235))
call HGT_raise_alpha_OLR(G1H16(9),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(9),wf4(:,4),G1H4(179),m3h4x4(:,39),heltab2x16(:,:,203))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,1),G1H4(166),m3h4x4(:,40),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(166),43,nMT,G2H4(87),n2h4(236))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(105),m3h4x4(:,41),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(105),43,nMT,G2H4(88),n2h4(237))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,1),G1H4(184),m3h4x4(:,42),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(184),39,nMT,G2H4(89),n2h4(238))
call HGT_raise_alpha_OLR(G1H16(36),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(36),wf4(:,9),G1H4(13),m3h4x4(:,43),heltab2x16(:,:,207))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,1),G1H4(190),m3h4x4(:,44),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(190),39,nMT,G2H4(90),n2h4(239))
  call Hloop_QV_A(ntryL,G1H16(40),wf4(:,1),G1H4(9),m3h4x4(:,45),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(9),39,nMT,G2H4(91),n2h4(240))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(106),m3h2x8(:,157),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H8(106),52,nMT,G2H8(14),n2h8(223))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(44),wf8(:,3),G1H2(378),m3h8x2(:,9),heltab2x16(:,:,211))
  call Hloop_QV_A(ntryL,G1H16(20),ex5(:),G1H8(110),m3h2x8(:,158),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(110),52,nMT,G2H8(13),n2h8(224))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(98),m3h2x8(:,159),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H8(98),52,nMT,G2H8(6),n2h8(225))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,12),G1H4(33),m3h4x4(:,46),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(92),n2h4(241))
call HGT_raise_alpha_OLR(G1H16(51),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(51),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(51),wf4(:,13),G1H4(196),m3h4x4(:,47),heltab2x16(:,:,215))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,12),G1H4(37),m3h4x4(:,48),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(93),n2h4(242))
  call Hloop_AV_Q(ntryL,G1H16(19),wf4(:,12),G1H4(55),m3h4x4(:,49),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(55),46,0,G2H4(94),n2h4(243))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,12),G1H4(202),m3h4x4(:,50),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(202),45,0,G2H4(95),n2h4(244))
call HGT_raise_alpha_OLR(G1H16(53),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(53),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(53),wf4(:,18),G1H4(56),m3h4x4(:,51),heltab2x16(:,:,219))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,12),G1H4(140),m3h4x4(:,52),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(140),45,0,G2H4(96),n2h4(245))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,12),G1H4(91),m3h4x4(:,53),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(91),45,0,G2H4(97),n2h4(246))
  call Hloop_AV_Q(ntryL,G1H16(25),ex5(:),G1H8(100),m3h2x8(:,160),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H8(100),50,0,G2H8(8),n2h8(226))
call HGT_raise_alpha_OLR(G1H16(26),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(26),wf8(:,20),G1H2(379),m3h8x2(:,10),heltab2x16(:,:,223))
  call Hloop_AV_Q(ntryL,G1H16(45),ex5(:),G1H8(117),m3h2x8(:,161),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(117),50,0,G2H8(9),n2h8(227))
  call Hloop_AV_Q(ntryL,G1H16(29),ex5(:),G1H8(118),m3h2x8(:,162),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(118),50,0,G2H8(10),n2h8(228))
  call Hloop_QV_A(ntryL,G1H16(2),ex5(:),G1H8(93),m3h2x8(:,163),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(93),49,0,G2H8(11),n2h8(229))
call HGT_raise_alpha_OLR(G1H16(28),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(28),wf8(:,16),G1H2(384),m3h8x2(:,11),heltab2x16(:,:,227))
  call Hloop_QV_A(ntryL,G1H16(1),ex5(:),G1H8(94),m3h2x8(:,164),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(94),49,0,G2H8(15),n2h8(230))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(129),m3h2x8(:,165),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(129),49,0,G2H8(34),n2h8(231))
  call Hloop_QV_A(ntryL,G1H16(6),wf8(:,12),G1H2(385),m3h8x2(:,12),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(385),55,nMT,G2H2(251),n2h2(379))
call HGT_raise_alpha_OLR(G1H16(31),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(31),ex4(:),G1H8(132),m3h2x8(:,166),heltab2x16(:,:,231))
  call Hloop_QV_A(ntryL,G1H16(14),wf8(:,12),G1H2(390),m3h8x2(:,13),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(390),55,nMT,G2H2(252),n2h2(380))
  call Hloop_QV_A(ntryL,G1H16(17),wf8(:,12),G1H2(395),m3h8x2(:,14),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(395),55,nMT,G2H2(253),n2h2(381))
  call Hloop_QV_A(ntryL,G1H16(37),wf8(:,17),G1H2(400),m3h8x2(:,15),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(400),55,nMT,G2H2(254),n2h2(382))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(103),m3h2x8(:,167),heltab2x16(:,:,235))
  call Hloop_QV_A(ntryL,G1H16(43),wf8(:,17),G1H2(405),m3h8x2(:,16),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(405),55,nMT,G2H2(255),n2h2(383))
  call Hloop_QV_A(ntryL,G1H16(46),wf8(:,17),G1H2(409),m3h8x2(:,17),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(409),55,nMT,G2H2(256),n2h2(384))
  call Hloop_QV_A(ntryL,G1H16(48),wf8(:,4),G1H2(410),m3h8x2(:,18),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(410),61,0,G2H2(257),n2h2(385))
call HGT_raise_alpha_OLR(G1H16(49),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(104),m3h2x8(:,168),heltab2x16(:,:,239))
  call Hloop_QV_A(ntryL,G1H16(32),wf8(:,4),G1H2(415),m3h8x2(:,19),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(415),61,0,G2H2(258),n2h2(386))
  call Hloop_QV_A(ntryL,G1H16(24),wf8(:,4),G1H2(416),m3h8x2(:,20),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(416),61,0,G2H2(259),n2h2(387))
  call Hloop_QV_A(ntryL,G1H16(39),wf8(:,9),G1H2(420),m3h8x2(:,21),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(420),61,0,G2H2(260),n2h2(388))
call HGT_raise_alpha_OLR(G1H16(50),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(50),ex2(:),G1H8(133),m3h2x8(:,169),heltab2x16(:,:,243))
  call Hloop_QV_A(ntryL,G1H16(54),wf8(:,9),G1H2(421),m3h8x2(:,22),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(421),61,0,G2H2(261),n2h2(389))
  call Hloop_QV_A(ntryL,G1H16(55),wf8(:,9),G1H2(426),m3h8x2(:,23),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(426),61,0,G2H2(262),n2h2(390))
  call ol_merge(ntryL,G2H2(150),[G2H2(57)])
  call ol_merge(ntryL,G2H2(153),[G2H2(58)])
  call ol_merge(ntryL,G2H2(221),[G2H2(110),G2H2(98),G2H2(70),G2H2(59)])
  call ol_merge(ntryL,G2H2(156),[G2H2(60)])
  call ol_merge(ntryL,G2H2(159),[G2H2(61)])
  call ol_merge(ntryL,G2H2(227),[G2H2(113),G2H2(101),G2H2(72),G2H2(62)])
  call ol_merge(ntryL,G2H2(162),[G2H2(63)])
  call ol_merge(ntryL,G2H2(165),[G2H2(64)])
  call ol_merge(ntryL,G2H2(218),[G2H2(116),G2H2(104),G2H2(74),G2H2(65)])
  call ol_merge(ntryL,G2H2(168),[G2H2(66)])
  call ol_merge(ntryL,G2H2(171),[G2H2(67)])
  call ol_merge(ntryL,G2H2(224),[G2H2(119),G2H2(107),G2H2(76),G2H2(68)])
  call ol_merge(ntryL,G2H2(40),[G2H2(125),G2H2(69)])
  call ol_merge(ntryL,G2H2(80),[G2H2(131),G2H2(71)])
  call ol_merge(ntryL,G2H2(79),[G2H2(182),G2H2(73)])
  call ol_merge(ntryL,G2H2(41),[G2H2(185),G2H2(75)])
  call ol_merge(ntryL,G2H2(15),[G2H2(92),G1H2(371)])
  call ol_merge(ntryL,G2H2(85),[G2H2(95),G1H2(382)])
  call ol_merge(ntryL,G2H4(49),[G2H4(47),G1H4(61)])
  call ol_merge(ntryL,G2H4(21),[G2H4(52),G1H4(157)])
  call ol_merge(ntryL,G1H2(148),[G1H2(175)])
call HGT_w2_OLR(G1H2(54),1,1,2)
call HGT_w2_invQ_OLR(G1H2(54),2,5,2)
  call ol_merge(ntryL,G1H2(54),[G1H2(148)])
  call ol_merge(ntryL,G1H2(147),[G1H2(180),G1H2(31)])
call HGT_w2_OLR(G1H2(66),1,1,2)
call HGT_w2_invQ_OLR(G1H2(66),2,5,2)
  call ol_merge(ntryL,G1H2(66),[G1H2(147)])
  call ol_merge(ntryL,G1H2(153),[G1H2(185)])
call HGT_w2_OLR(G1H2(78),1,1,2)
call HGT_w2_invQ_OLR(G1H2(78),2,5,2)
  call ol_merge(ntryL,G1H2(78),[G1H2(153)])
  call ol_merge(ntryL,G1H2(152),[G1H2(190),G1H2(28)])
call HGT_w2_OLR(G1H2(18),1,1,2)
call HGT_w2_invQ_OLR(G1H2(18),2,5,2)
  call ol_merge(ntryL,G1H2(18),[G1H2(152)])
  call ol_merge(ntryL,G1H2(195),[G1H2(32)])
call HGT_w2_OLR(G1H2(30),1,1,2)
call HGT_w2_invQ_OLR(G1H2(30),2,5,2)
  call ol_merge(ntryL,G1H2(30),[G1H2(195)])
  call ol_merge(ntryL,G1H2(200),[G1H2(119)])
call HGT_w2_OLR(G1H2(42),1,1,2)
call HGT_w2_invQ_OLR(G1H2(42),2,5,2)
  call ol_merge(ntryL,G1H2(42),[G1H2(200)])
  call ol_merge(ntryL,G1H2(205),[G1H2(86)])
call HGT_w2_OLR(G1H2(59),1,1,2)
call HGT_w2_invQ_OLR(G1H2(59),2,5,2)
  call ol_merge(ntryL,G1H2(59),[G1H2(205)])
  call ol_merge(ntryL,G1H2(210),[G1H2(62)])
call HGT_w2_OLR(G1H2(72),1,1,2)
call HGT_w2_invQ_OLR(G1H2(72),2,5,2)
  call ol_merge(ntryL,G1H2(72),[G1H2(210)])
  call ol_merge(ntryL,G1H2(315),[G1H2(309)])
call HGT_w2_OLR(G1H2(17),1,1,2)
call HGT_w2_invQ_OLR(G1H2(17),2,5,2)
  call ol_merge(ntryL,G1H2(17),[G1H2(315)])
  call ol_merge(ntryL,G1H2(273),[G1H2(193)])
call HGT_w2_OLR(G1H2(35),1,1,2)
call HGT_w2_invQ_OLR(G1H2(35),2,5,2)
  call ol_merge(ntryL,G1H2(35),[G1H2(273)])
  call ol_merge(ntryL,G1H2(363),[G1H2(357)])
call HGT_w2_OLR(G1H2(48),1,1,2)
call HGT_w2_invQ_OLR(G1H2(48),2,5,2)
  call ol_merge(ntryL,G1H2(48),[G1H2(363)])
  call ol_merge(ntryL,G1H2(303),[G1H2(198)])
call HGT_w2_OLR(G1H2(71),1,1,2)
call HGT_w2_invQ_OLR(G1H2(71),2,5,2)
  call ol_merge(ntryL,G1H2(71),[G1H2(303)])
  call ol_merge(ntryL,G1H2(75),[G1H2(21)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,G2H2(134),[G1H2(75)])
  call ol_merge(ntryL,G2H2(86),[G2H2(199),G2H2(135),G1H2(446),G1H2(281),G1H2(109),G1H2(37)])
  call ol_merge(ntryL,G1H2(115),[G1H2(50)])
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call ol_merge(ntryL,G2H2(138),[G1H2(115)])
  call ol_merge(ntryL,G2H2(18),[G2H2(192),G2H2(139),G1H2(424),G1H2(293),G1H2(121),G1H2(68)])
  call ol_merge(ntryL,G1H2(151),[G1H2(127)])
call HGT_OLR(G2H2(142),1,1,2)
call HGT_invQ_OLR(G2H2(142),2,5,2)
call HGT_OLR(G2H2(142),6,15,2)
  call ol_merge(ntryL,G2H2(142),[G1H2(151)])
  call ol_merge(ntryL,G2H2(21),[G2H2(215),G2H2(143),G1H2(490),G1H2(323),G1H2(157),G1H2(133)])
  call ol_merge(ntryL,G1H2(163),[G1H2(139)])
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,G2H2(146),[G1H2(163)])
  call ol_merge(ntryL,G2H2(133),[G2H2(208),G2H2(147),G1H2(468),G1H2(341),G1H2(169),G1H2(145)])
call HGT_w2_OLR(G1H2(23),1,1,2)
call HGT_w2_invQ_OLR(G1H2(23),2,5,2)
  call ol_merge(ntryL,G1H2(23),[G1H2(173)])
call HGT_w2_OLR(G1H2(41),1,1,2)
call HGT_w2_invQ_OLR(G1H2(41),2,5,2)
  call ol_merge(ntryL,G1H2(41),[G1H2(174)])
  call ol_merge(ntryL,G1H2(243),[G1H2(178)])
call HGT_w2_OLR(G1H2(65),1,1,2)
call HGT_w2_invQ_OLR(G1H2(65),2,5,2)
  call ol_merge(ntryL,G1H2(65),[G1H2(243)])
  call ol_merge(ntryL,G1H2(249),[G1H2(179)])
call HGT_w2_OLR(G1H2(24),1,1,2)
call HGT_w2_invQ_OLR(G1H2(24),2,5,2)
  call ol_merge(ntryL,G1H2(24),[G1H2(249)])
call HGT_w2_OLR(G1H2(53),1,1,2)
call HGT_w2_invQ_OLR(G1H2(53),2,5,2)
  call ol_merge(ntryL,G1H2(53),[G1H2(183)])
call HGT_w2_OLR(G1H2(84),1,1,2)
call HGT_w2_invQ_OLR(G1H2(84),2,5,2)
  call ol_merge(ntryL,G1H2(84),[G1H2(184)])
  call ol_merge(ntryL,G1H2(213),[G1H2(188)])
call HGT_w2_OLR(G1H2(60),1,1,2)
call HGT_w2_invQ_OLR(G1H2(60),2,5,2)
  call ol_merge(ntryL,G1H2(60),[G1H2(213)])
  call ol_merge(ntryL,G1H2(219),[G1H2(189)])
call HGT_w2_OLR(G1H2(36),1,1,2)
call HGT_w2_invQ_OLR(G1H2(36),2,5,2)
  call ol_merge(ntryL,G1H2(36),[G1H2(219)])
  call ol_merge(ntryL,G2H2(2),[G1H2(279),G1H2(204),G1H2(194)])
call HGT_w2_OLR(G1H2(29),1,1,2)
call HGT_w2_invQ_OLR(G1H2(29),2,5,2)
  call ol_merge(ntryL,G2H2(2),[G1H2(29)])
  call ol_merge(ntryL,G2H2(157),[G2H2(174)])
call HGT_w2_OLR(G1H2(83),1,1,2)
call HGT_w2_invQ_OLR(G1H2(83),2,5,2)
  call ol_merge(ntryL,G1H2(83),[G1H2(391)])
  call ol_merge(ntryL,G2H2(160),[G2H2(229),G2H2(176)])
  call ol_merge(ntryL,G2H2(4),[G1H2(291),G1H2(209),G1H2(199)])
call HGT_w2_OLR(G1H2(47),1,1,2)
call HGT_w2_invQ_OLR(G1H2(47),2,5,2)
  call ol_merge(ntryL,G2H2(4),[G1H2(47)])
  call ol_merge(ntryL,G2H2(161),[G2H2(178)])
call HGT_w2_OLR(G1H2(77),1,1,2)
call HGT_w2_invQ_OLR(G1H2(77),2,5,2)
  call ol_merge(ntryL,G1H2(77),[G1H2(396)])
  call ol_merge(ntryL,G2H2(164),[G2H2(230),G2H2(180)])
  call ol_merge(ntryL,G1H2(297),[G1H2(203)])
call HGT_w2_OLR(G1H2(89),1,1,2)
call HGT_w2_invQ_OLR(G1H2(89),2,5,2)
  call ol_merge(ntryL,G1H2(89),[G1H2(297)])
  call ol_merge(ntryL,G1H2(285),[G1H2(208)])
call HGT_w2_OLR(G1H2(90),1,1,2)
call HGT_w2_invQ_OLR(G1H2(90),2,5,2)
  call ol_merge(ntryL,G1H2(90),[G1H2(285)])
  call ol_merge(ntryL,G2H2(209),[G2H2(189),G1H2(413)])
  call ol_merge(ntryL,G2H2(202),[G2H2(196),G1H2(435)])
  call ol_merge(ntryL,G2H2(78),[G1H2(455)])
call HGT_OLR(G2H2(201),1,1,2)
call HGT_invQ_OLR(G2H2(201),2,5,2)
call HGT_OLR(G2H2(201),6,15,2)
  call ol_merge(ntryL,G2H2(201),[G2H2(78)])
  call ol_merge(ntryL,G2H4(35),[G2H4(50),G1H4(170)])
  call ol_merge(ntryL,G2H2(186),[G2H2(204),G1H2(457)])
  call ol_merge(ntryL,G2H2(38),[G1H2(477)])
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call ol_merge(ntryL,G2H2(206),[G2H2(38)])
  call ol_merge(ntryL,G2H4(23),[G2H4(2),G1H4(147)])
  call ol_merge(ntryL,G2H2(181),[G2H2(212),G1H2(479)])
call HGT_w2_OLR(G1H2(91),1,1,2)
call HGT_w2_invQ_OLR(G1H2(91),2,5,2)
  call ol_merge(ntryL,G1H2(91),[G1H2(161)])
call HGT_w2_OLR(G1H2(92),1,1,2)
call HGT_w2_invQ_OLR(G1H2(92),2,5,2)
  call ol_merge(ntryL,G1H2(92),[G1H2(137)])
call HGT_w2_OLR(G1H2(93),1,1,2)
call HGT_w2_invQ_OLR(G1H2(93),2,5,2)
  call ol_merge(ntryL,G1H2(93),[G1H2(125)])
call HGT_w2_OLR(G1H2(94),1,1,2)
call HGT_w2_invQ_OLR(G1H2(94),2,5,2)
  call ol_merge(ntryL,G1H2(94),[G1H2(149)])
  call ol_merge(ntryL,G1H2(154),[G1H2(113)])
call HGT_w2_OLR(G1H2(95),1,1,2)
call HGT_w2_invQ_OLR(G1H2(95),2,5,2)
  call ol_merge(ntryL,G1H2(95),[G1H2(154)])
  call ol_merge(ntryL,G1H2(158),[G1H2(57)])
call HGT_w2_OLR(G1H2(96),1,1,2)
call HGT_w2_invQ_OLR(G1H2(96),2,5,2)
  call ol_merge(ntryL,G1H2(96),[G1H2(158)])
  call ol_merge(ntryL,G1H4(174),[G1H4(51)])
call HGT_w2_OLR(G1H4(106),1,1,4)
call HGT_w2_invQ_OLR(G1H4(106),2,5,4)
  call ol_merge(ntryL,G1H4(106),[G1H4(174)])
  call ol_merge(ntryL,G1H4(123),[G1H4(79)])
call HGT_w2_OLR(G1H4(118),1,1,4)
call HGT_w2_invQ_OLR(G1H4(118),2,5,4)
  call ol_merge(ntryL,G1H4(118),[G1H4(123)])
  call ol_merge(ntryL,G1H2(159),[G1H2(15)])
call HGT_w2_OLR(G1H2(97),1,1,2)
call HGT_w2_invQ_OLR(G1H2(97),2,5,2)
  call ol_merge(ntryL,G1H2(97),[G1H2(159)])
  call ol_merge(ntryL,G1H2(160),[G1H2(74)])
call HGT_w2_OLR(G1H2(98),1,1,2)
call HGT_w2_invQ_OLR(G1H2(98),2,5,2)
  call ol_merge(ntryL,G1H2(98),[G1H2(160)])
  call ol_merge(ntryL,G1H4(135),[G1H4(146)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,G1H4(22),[G1H4(135)])
  call ol_merge(ntryL,G1H4(181),[G1H4(8)])
call HGT_w2_OLR(G1H4(23),1,1,4)
call HGT_w2_invQ_OLR(G1H4(23),2,5,4)
  call ol_merge(ntryL,G1H4(23),[G1H4(181)])
call HGT_w2_OLR(G1H4(47),1,1,4)
call HGT_w2_invQ_OLR(G1H4(47),2,5,4)
  call ol_merge(ntryL,G2H4(72),[G1H4(47)])
  call ol_merge(ntryL,G2H2(254),[G2H2(251),G2H2(237),G2H2(232)])
  call ol_merge(ntryL,G2H2(256),[G2H2(253),G2H2(240),G2H2(239),G2H2(235),G2H2(234)])
  call ol_merge(ntryL,G2H2(46),[G1H2(444)])
call HGT_w2_OLR(G1H2(101),1,1,2)
call HGT_w2_invQ_OLR(G1H2(101),2,5,2)
  call ol_merge(ntryL,G2H2(46),[G1H2(101)])
call HGT_w2_OLR(G1H2(102),1,1,2)
call HGT_w2_invQ_OLR(G1H2(102),2,5,2)
  call ol_merge(ntryL,G1H2(102),[G1H2(450)])
  call ol_merge(ntryL,G2H4(75),[G1H4(121)])
call HGT_w2_OLR(G1H4(54),1,1,4)
call HGT_w2_invQ_OLR(G1H4(54),2,5,4)
  call ol_merge(ntryL,G2H4(75),[G1H4(54)])
  call ol_merge(ntryL,G2H2(260),[G2H2(257),G2H2(247),G2H2(242)])
call HGT_w2_OLR(G1H4(64),1,1,4)
call HGT_w2_invQ_OLR(G1H4(64),2,5,4)
  call ol_merge(ntryL,G1H4(64),[G1H4(177)])
  call ol_merge(ntryL,G2H2(262),[G2H2(259),G2H2(250),G2H2(249),G2H2(245),G2H2(244)])
  call ol_merge(ntryL,G2H2(47),[G1H2(488)])
call HGT_w2_OLR(G1H2(104),1,1,2)
call HGT_w2_invQ_OLR(G1H2(104),2,5,2)
  call ol_merge(ntryL,G2H2(47),[G1H2(104)])
call HGT_w2_OLR(G1H2(105),1,1,2)
call HGT_w2_invQ_OLR(G1H2(105),2,5,2)
  call ol_merge(ntryL,G1H2(105),[G1H2(494)])
  call ol_merge(ntryL,G1H2(215),[G1H2(34)])
  call ol_merge(ntryL,G2H2(137),[G2H2(24),G1H2(251),G1H2(221),G1H2(5),G1H2(40)])
  call ol_merge(ntryL,G1H2(227),[G1H2(64)])
  call ol_merge(ntryL,G1H2(233),[G1H2(70)])
  call ol_merge(ntryL,G2H2(30),[G2H2(27),G1H2(269),G1H2(239),G1H2(11),G1H2(76)])
  call ol_merge(ntryL,G1H2(245),[G1H2(3)])
  call ol_merge(ntryL,G1H2(257),[G1H2(9)])
  call ol_merge(ntryL,G1H2(263),[G1H2(61)])
  call ol_merge(ntryL,G1H2(275),[G1H2(33)])
  call ol_merge(ntryL,G1H2(287),[G1H2(67)])
  call ol_merge(ntryL,G1H2(299),[G1H2(108)])
  call ol_merge(ntryL,G1H2(305),[G1H2(120)])
  call ol_merge(ntryL,G1H2(311),[G1H2(131)])
  call ol_merge(ntryL,G1H2(317),[G1H2(132)])
  call ol_merge(ntryL,G1H2(329),[G1H2(143)])
  call ol_merge(ntryL,G1H2(335),[G1H2(144)])
  call ol_merge(ntryL,G1H2(347),[G1H2(155)])
  call ol_merge(ntryL,G1H2(353),[G1H2(156)])
  call ol_merge(ntryL,G1H2(359),[G1H2(167)])
  call ol_merge(ntryL,G1H2(365),[G1H2(168)])
  call ol_merge(ntryL,G1H2(220),[G1H2(214)])
  call ol_merge(ntryL,G1H2(231),[G1H2(225)])
  call ol_merge(ntryL,G1H2(237),[G1H2(226)])
  call ol_merge(ntryL,G1H2(238),[G1H2(232)])
  call ol_merge(ntryL,G1H2(250),[G1H2(244)])
  call ol_merge(ntryL,G1H2(261),[G1H2(255)])
  call ol_merge(ntryL,G1H2(267),[G1H2(256)])
  call ol_merge(ntryL,G1H2(268),[G1H2(262)])
  call ol_merge(ntryL,G2H2(13),[G1H2(412),G1H2(298),G1H2(280),G1H2(274)])
  call ol_merge(ntryL,G2H2(14),[G1H2(434),G1H2(304),G1H2(292),G1H2(286)])
  call ol_merge(ntryL,G2H2(16),[G1H2(346),G1H2(321),G1H2(310)])
  call ol_merge(ntryL,G2H2(17),[G1H2(456),G1H2(352),G1H2(322),G1H2(316)])
  call ol_merge(ntryL,G1H2(333),[G1H2(327)])
  call ol_merge(ntryL,G2H2(19),[G1H2(358),G1H2(339),G1H2(328)])
  call ol_merge(ntryL,G2H2(20),[G1H2(478),G1H2(364),G1H2(340),G1H2(334)])
  call ol_merge(ntryL,G1H2(351),[G1H2(345)])
  call ol_merge(ntryL,G1H4(109),[G1H4(77)])
  call ol_merge(ntryL,G2H4(39),[G1H4(81),G1H4(83)])
  call ol_merge(ntryL,G1H4(98),[G1H4(96)])
  call ol_merge(ntryL,G1H4(111),[G1H4(34)])
  call ol_merge(ntryL,G2H4(8),[G1H4(27),G1H4(19)])
  call ol_merge(ntryL,G1H4(165),[G1H4(103)])
  call ol_merge(ntryL,G2H4(10),[G1H4(128),G1H4(43)])
  call ol_merge(ntryL,G2H4(16),[G1H4(29),G1H4(127)])
  call ol_merge(ntryL,G2H2(12),[G1H2(369)])
  call ol_merge(ntryL,G2H2(6),[G1H2(370)])
  call ol_merge(ntryL,G2H2(84),[G1H2(380)])
  call ol_merge(ntryL,G2H2(8),[G1H2(381)])
  call ol_merge(ntryL,G2H4(54),[G1H4(24)])
  call ol_merge(ntryL,G2H4(73),[G1H4(50)])
  call ol_merge(ntryL,G2H4(37),[G1H4(153)])
  call ol_merge(ntryL,G2H4(76),[G1H4(156)])
  call ol_merge(ntryL,G1H2(418),[G1H2(392)])
  call ol_merge(ntryL,G1H2(452),[G1H2(393)])
  call ol_merge(ntryL,G1H2(440),[G1H2(397)])
  call ol_merge(ntryL,G1H2(430),[G1H2(398)])
  call ol_merge(ntryL,G1H2(462),[G1H2(402)])
  call ol_merge(ntryL,G1H2(496),[G1H2(403)])
  call ol_merge(ntryL,G1H2(484),[G1H2(407)])
  call ol_merge(ntryL,G1H2(474),[G1H2(408)])
  call ol_merge(ntryL,G2H2(77),[G1H2(411)])
  call ol_merge(ntryL,G2H2(213),[G1H2(419)])
  call ol_merge(ntryL,G2H2(34),[G1H2(422)])
  call ol_merge(ntryL,G2H2(126),[G1H2(423)])
  call ol_merge(ntryL,G2H2(129),[G1H2(429)])
  call ol_merge(ntryL,G2H2(35),[G1H2(433)])
  call ol_merge(ntryL,G2H2(207),[G1H2(441)])
  call ol_merge(ntryL,G2H2(130),[G1H2(445)])
  call ol_merge(ntryL,G2H2(136),[G1H2(451)])
  call ol_merge(ntryL,G2H4(1),[G1H4(210)])
  call ol_merge(ntryL,G2H4(40),[G1H4(178)])
  call ol_merge(ntryL,G2H2(190),[G1H2(463)])
  call ol_merge(ntryL,G2H4(79),[G1H4(182)])
  call ol_merge(ntryL,G2H4(41),[G1H4(145)])
  call ol_merge(ntryL,G2H4(20),[G1H4(191)])
  call ol_merge(ntryL,G2H2(37),[G1H2(466)])
  call ol_merge(ntryL,G2H2(148),[G1H2(467)])
  call ol_merge(ntryL,G2H2(151),[G1H2(473)])
  call ol_merge(ntryL,G2H2(184),[G1H2(485)])
  call ol_merge(ntryL,G2H2(152),[G1H2(489)])
  call ol_merge(ntryL,G2H2(155),[G1H2(495)])
  call ol_merge(ntryL,G2H2(120),[G2H2(43)])
  call ol_merge(ntryL,G2H2(141),[G2H2(44)])
  call ol_merge(ntryL,G2H2(124),[G2H2(1)])
  call ol_merge(ntryL,G2H2(145),[G2H2(220)])
  call ol_merge(ntryL,G2H2(169),[G2H2(226)])
  call ol_merge(ntryL,G2H2(97),[G2H2(228)])
  call ol_merge(ntryL,G2H2(93),[G2H2(217)])
  call ol_merge(ntryL,G2H2(173),[G2H2(223)])
  call ol_merge(ntryL,G2H2(106),[G2H2(225)])
  call ol_merge(ntryL,G2H2(179),[G2H2(82)])
  call ol_merge(ntryL,G2H2(115),[G2H2(83)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(150),ex4(:),G2tensor(10),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(153),ex4(:),G2tensor(12),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(221),ex4(:),G2tensor(14),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(156),ex3(:),G2tensor(16),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(159),ex3(:),G2tensor(18),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(227),ex3(:),G2tensor(20),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(162),ex4(:),G2tensor(22),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(165),ex4(:),G2tensor(24),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(218),ex4(:),G2tensor(26),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(168),ex3(:),G2tensor(28),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(171),ex3(:),G2tensor(30),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(224),ex3(:),G2tensor(32),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(53),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(80),ex3(:),G2tensor(55),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(57),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex3(:),G2tensor(59),m3h2x1(:,334),heltab2x2(:,:,334))
call Hotf_4pt_reduction(G2H2(15),RedSet_4(55),mass4set(:,6),  & 
G1H2(427),G1H2(431),G1H2(432),G1H2(437),G1H2(438),2)
call HG1shiftOLR(G1H2(431),8,2)
call Hotf_4pt_reduction(G2H2(85),RedSet_4(69),mass4set(:,6),  & 
G1H2(442),G1H2(443),G1H2(448),G1H2(449),G1H2(453),2)
call HG1shiftOLR(G1H2(443),4,2)
call Hotf_4pt_reduction(G2H4(49),RedSet_4(35),mass4set(:,3),  & 
G1H4(20),G1H4(1),G1H4(63),G1H4(30),G1H4(154),4)
call HG1shiftOLR(G1H4(1),12,4)
call Hotf_4pt_reduction(G2H4(21),RedSet_4(11),mass4set(:,3),  & 
G1H4(87),G1H4(163),G1H4(183),G1H4(189),G1H4(195),4)
call HG1shiftOLR(G1H4(163),12,4)
  call Hloop_VQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(121),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(127),n2h1(276))
  call Hloop_VQ_A(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(133),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(139),n2h1(278))
  call Hloop_QV_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(145),n2h1(279))
  call Hloop_AV_Q(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(151),n2h1(280))
  call Hloop_QV_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(157),n2h1(281))
  call Hloop_AV_Q(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(163),n2h1(282))
  call Hloop_QV_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(283))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(122),ex2(:),G2tensor(61),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hloop_QV_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(285))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex1(:),G2tensor(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hloop_AV_Q(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(172),n2h1(286))
call Hotf_4pt_reduction(G2H2(134),RedSet_4(250),mass4set(:,5),  & 
G1H2(454),G1H2(459),G1H2(460),G1H2(464),G1H2(465),2)
call HG1shiftOLR(G1H2(459),4,2)
call Hotf_4pt_reduction(G2H2(86),RedSet_4(154),mass4set(:,7),  & 
G1H2(470),G1H2(471),G1H2(475),G1H2(476),G1H2(481),2)
call HG1shiftOLR(G1H2(471),16,2)
call Hotf_4pt_reduction(G2H2(138),RedSet_4(254),mass4set(:,5),  & 
G1H2(482),G1H2(486),G1H2(487),G1H2(492),G1H2(493),2)
call HG1shiftOLR(G1H2(486),8,2)
call Hotf_4pt_reduction(G2H2(18),RedSet_4(168),mass4set(:,7),  & 
G1H2(282),G1H2(294),G1H2(324),G1H2(342),G1H2(372),2)
call HG1shiftOLR(G1H2(294),16,2)
call Hotf_4pt_reduction(G2H2(142),RedSet_4(264),mass4set(:,3),  & 
G1H2(383),G1H2(414),G1H2(425),G1H2(436),G1H2(447),2)
call HG1shiftOLR(G1H2(414),1,2)
call Hotf_4pt_reduction(G2H2(21),RedSet_4(198),mass4set(:,3),  & 
G1H2(458),G1H2(469),G1H2(480),G1H2(491),G1H2(107),2)
call HG1shiftOLR(G1H2(469),16,2)
call Hotf_4pt_reduction(G2H2(146),RedSet_4(268),mass4set(:,3),  & 
G1H2(22),G1H2(46),G1H2(52),G1H2(58),G1H2(82),2)
call HG1shiftOLR(G1H2(46),2,2)
call Hotf_4pt_reduction(G2H2(133),RedSet_4(212),mass4set(:,3),  & 
G1H2(88),G1H2(1),G1H2(19),G1H2(7),G1H2(43),2)
call HG1shiftOLR(G1H2(1),16,2)
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(287))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(288))
  call Hloop_VA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(4),n2h1(290))
  call Hloop_VQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(175),n2h1(291))
  call Hloop_VQ_A(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(69),n2h1(292))
  call Hloop_VA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(293))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(294))
call Hotf_4pt_reduction(G2H2(2),RedSet_4(147),mass4set(:,10),  & 
G1H2(55),G1H2(13),G1H2(49),G1H2(25),G1H2(26),2)
call HG1shiftOLR(G1H2(13),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(157),ex4(:),G2tensor(7),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hloop_QV_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(178),n2h1(295))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(160),ex4(:),G2tensor(73),m3h2x1(:,359),heltab2x2(:,:,359))
call Hotf_4pt_reduction(G2H2(4),RedSet_4(161),mass4set(:,10),  & 
G1H2(27),G1H2(38),G1H2(39),G1H2(44),G1H2(63),2)
call HG1shiftOLR(G1H2(38),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(161),ex3(:),G2tensor(75),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hloop_AV_Q(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(43),n2h1(296))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(164),ex3(:),G2tensor(11),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hloop_QV_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(181),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(77),n2h1(298))
call HGT_OLR(G2H2(188),1,1,2)
call HGT_invQ_OLR(G2H2(188),2,5,2)
call HGT_OLR(G2H2(188),6,15,2)
call Hotf_4pt_reduction(G2H2(188),RedSet_4(328),mass4set(:,6),  & 
G1H2(51),G1H2(56),G1H2(81),G1H2(69),G1H2(73),2)
call HG1shiftOLR(G1H2(56),4,2)
call Hotf_4pt_reduction(G2H2(209),RedSet_4(306),mass4set(:,4),  & 
G1H2(79),G1H2(80),G1H2(85),G1H2(110),G1H2(111),2)
call HG1shiftOLR(G1H2(80),16,2)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
call Hotf_4pt_reduction(G2H4(7),RedSet_4(329),mass4set(:,7),  & 
G1H4(201),G1H4(208),G1H4(233),G1H4(42),G1H4(53),4)
call HG1shiftOLR(G1H4(208),3,4)
call HGT_OLR(G2H2(195),1,1,2)
call HGT_invQ_OLR(G2H2(195),2,5,2)
call HGT_OLR(G2H2(195),6,15,2)
call Hotf_4pt_reduction(G2H2(195),RedSet_4(330),mass4set(:,6),  & 
G1H2(112),G1H2(116),G1H2(117),G1H2(118),G1H2(122),2)
call HG1shiftOLR(G1H2(116),8,2)
call Hotf_4pt_reduction(G2H2(202),RedSet_4(306),mass4set(:,4),  & 
G1H2(123),G1H2(124),G1H2(128),G1H2(129),G1H2(130),2)
call HG1shiftOLR(G1H2(124),16,2)
call HGT_OLR(G2H4(53),1,1,4)
call HGT_invQ_OLR(G2H4(53),2,5,4)
call HGT_OLR(G2H4(53),6,15,4)
call Hotf_4pt_reduction(G2H4(53),RedSet_4(331),mass4set(:,7),  & 
G1H4(230),G1H4(241),G1H4(92),G1H4(73),G1H4(2),4)
call HG1shiftOLR(G1H4(241),3,4)
call Hotf_4pt_reduction(G2H2(201),RedSet_4(317),mass4set(:,3),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(140),G1H2(141),2)
call HG1shiftOLR(G1H2(135),16,2)
call Hotf_4pt_reduction(G2H4(35),RedSet_4(11),mass4set(:,3),  & 
G1H4(155),G1H4(44),G1H4(149),G1H4(89),G1H4(25),4)
call HG1shiftOLR(G1H4(44),12,4)
call HGT_OLR(G2H2(203),1,1,2)
call HGT_invQ_OLR(G2H2(203),2,5,2)
call HGT_OLR(G2H2(203),6,15,2)
call Hotf_4pt_reduction(G2H2(203),RedSet_4(332),mass4set(:,3),  & 
G1H2(142),G1H2(146),G1H2(164),G1H2(166),G1H2(170),2)
call HG1shiftOLR(G1H2(146),1,2)
call Hotf_4pt_reduction(G2H2(186),RedSet_4(309),mass4set(:,3),  & 
G1H2(171),G1H2(176),G1H2(2),G1H2(177),G1H2(4),2)
call HG1shiftOLR(G1H2(176),16,2)
call Hotf_4pt_reduction(G2H2(206),RedSet_4(323),mass4set(:,3),  & 
G1H2(182),G1H2(186),G1H2(187),G1H2(191),G1H2(8),2)
call HG1shiftOLR(G1H2(186),16,2)
call Hotf_4pt_reduction(G2H4(23),RedSet_4(35),mass4set(:,3),  & 
G1H4(176),G1H4(180),G1H4(76),G1H4(69),G1H4(203),4)
call HG1shiftOLR(G1H4(180),12,4)
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
call Hotf_4pt_reduction(G2H4(6),RedSet_4(333),mass4set(:,3),  & 
G1H4(200),G1H4(101),G1H4(112),G1H4(236),G1H4(102),4)
call HG1shiftOLR(G1H4(101),12,4)
call HGT_OLR(G2H2(211),1,1,2)
call HGT_invQ_OLR(G2H2(211),2,5,2)
call HGT_OLR(G2H2(211),6,15,2)
call Hotf_4pt_reduction(G2H2(211),RedSet_4(334),mass4set(:,3),  & 
G1H2(192),G1H2(196),G1H2(10),G1H2(201),G1H2(12),2)
call HG1shiftOLR(G1H2(196),2,2)
call Hotf_4pt_reduction(G2H2(181),RedSet_4(309),mass4set(:,3),  & 
G1H2(202),G1H2(206),G1H2(14),G1H2(207),G1H2(16),2)
call HG1shiftOLR(G1H2(206),16,2)
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
call Hotf_4pt_reduction(G2H4(11),RedSet_4(335),mass4set(:,3),  & 
G1H4(126),G1H4(131),G1H4(119),G1H4(125),G1H4(162),4)
call HG1shiftOLR(G1H4(131),12,4)
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(299))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(14),wf4(:,13),G2tensor(17),m3h4x1(:,57),heltab2x4(:,:,427))
  call Hloop_VA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(300))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(44),wf4(:,13),G2tensor(79),m3h4x1(:,58),heltab2x4(:,:,428))
  call Hloop_VQ_A(ntryL,G1H2(93),ex1(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(301))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(57),wf4(:,18),G2tensor(23),m3h4x1(:,59),heltab2x4(:,:,429))
  call Hloop_VQ_A(ntryL,G1H2(94),ex1(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(302))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(24),wf4(:,18),G2tensor(81),m3h4x1(:,60),heltab2x4(:,:,430))
  call Hloop_VA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(303))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,4),G2tensor(29),m3h4x1(:,61),heltab2x4(:,:,431))
  call Hloop_VA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(190),n2h1(304))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(27),wf4(:,4),G2tensor(83),m3h4x1(:,62),heltab2x4(:,:,432))
  call Hloop_VQ_A(ntryL,G1H4(106),wf4(:,4),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(305))
  call Hloop_VQ_A(ntryL,G1H4(118),wf4(:,4),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(34),n2h1(306))
  call Hloop_VQ_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(193),n2h1(307))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(32),wf4(:,9),G2tensor(196),m3h4x1(:,65),heltab2x4(:,:,435))
  call Hloop_VQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(109),n2h1(308))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(45),wf4(:,9),G2tensor(199),m3h4x1(:,66),heltab2x4(:,:,436))
  call Hloop_VA_Q(ntryL,G1H4(22),wf4(:,9),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(202),n2h1(309))
  call Hloop_VA_Q(ntryL,G1H4(23),wf4(:,9),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(205),n2h1(310))
call HGT_w2_OLR(G1H2(99),1,1,2)
call HGT_w2_invQ_OLR(G1H2(99),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(112),n2h1(311))
call HGT_w2_OLR(G1H2(100),1,1,2)
call HGT_w2_invQ_OLR(G1H2(100),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(208),n2h1(312))
call Hotf_4pt_reduction(G2H4(72),RedSet_4(336),mass4set(:,11),  & 
G1H4(224),G1H4(171),G1H4(172),G1H4(204),G1H4(235),4)
call HG1shiftOLR(G1H4(171),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(254),ex4(:),G2tensor(211),m3h2x1(:,375),heltab2x2(:,:,375))
call HGT_w2_OLR(G1H4(48),1,1,4)
call HGT_w2_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,1),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(313))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(256),ex4(:),G2tensor(214),m3h2x1(:,376),heltab2x2(:,:,376))
call HGT_w2_OLR(G1H4(52),1,1,4)
call HGT_w2_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(52),wf4(:,1),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(217),n2h1(314))
call Hotf_4pt_reduction(G2H2(46),RedSet_4(313),mass4set(:,11),  & 
G1H2(212),G1H2(216),G1H2(218),G1H2(222),G1H2(223),2)
call HG1shiftOLR(G1H2(216),16,2)
  call Hloop_QV_A(ntryL,G1H2(102),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(220),n2h1(315))
call HGT_w2_OLR(G1H2(103),1,1,2)
call HGT_w2_invQ_OLR(G1H2(103),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(118),n2h1(316))
call Hotf_4pt_reduction(G2H4(75),RedSet_4(315),mass4set(:,3),  & 
G1H4(113),G1H4(49),G1H4(114),G1H4(67),G1H4(68),4)
call HG1shiftOLR(G1H4(49),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(260),ex2(:),G2tensor(223),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,12),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(317))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(262),ex2(:),G2tensor(124),m3h2x1(:,380),heltab2x2(:,:,380))
call HGT_w2_OLR(G1H4(65),1,1,4)
call HGT_w2_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,12),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(229),n2h1(318))
call Hotf_4pt_reduction(G2H2(47),RedSet_4(325),mass4set(:,3),  & 
G1H2(228),G1H2(229),G1H2(230),G1H2(235),G1H2(236),2)
call HG1shiftOLR(G1H2(229),16,2)
  call Hloop_QV_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(319))
call HGT_w2_OLR(G1H2(106),1,1,2)
call HGT_w2_invQ_OLR(G1H2(106),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(320))
  call Hloop_VA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(235),n2h1(321))
call Hotf_4pt_reduction(G2H2(137),RedSet_4(101),mass4set(:,5),  & 
G1H2(240),G1H2(241),G1H2(242),G1H2(247),G1H2(248),2)
call HG1shiftOLR(G1H2(241),8,2)
  call Hloop_VA_Q(ntryL,G1H2(227),ex2(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(322))
  call Hloop_VA_Q(ntryL,G1H2(233),ex2(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(323))
call Hotf_4pt_reduction(G2H2(30),RedSet_4(115),mass4set(:,3),  & 
G1H2(252),G1H2(254),G1H2(258),G1H2(259),G1H2(264),2)
call HG1shiftOLR(G1H2(254),2,2)
  call Hloop_VA_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(142),n2h1(324))
  call Hloop_VA_Q(ntryL,G1H2(257),ex2(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(325))
  call Hloop_VA_Q(ntryL,G1H2(263),ex2(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(326))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(247),n2h1(327))
  call Hloop_QV_A(ntryL,G1H2(275),ex5(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(148),n2h1(328))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(250),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(287),ex5(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(253),n2h1(330))
  call Hloop_VQ_A(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(256),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(299),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(154),n2h1(332))
  call Hloop_VA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(259),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(262),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(126),ex1(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(336))
  call Hloop_QV_A(ntryL,G1H2(317),ex5(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(337))
  call Hloop_VA_Q(ntryL,G1H2(138),ex2(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(338))
  call Hloop_AV_Q(ntryL,G1H2(329),ex5(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(339))
  call Hloop_AV_Q(ntryL,G1H2(335),ex5(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(340))
  call Hloop_VQ_A(ntryL,G1H2(150),ex1(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(341))
  call Hloop_QV_A(ntryL,G1H2(347),ex5(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(342))
  call Hloop_QV_A(ntryL,G1H2(353),ex5(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(343))
  call Hloop_VA_Q(ntryL,G1H2(162),ex2(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(359),ex5(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(346))
  call Hloop_VA_Q(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(101),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(231),ex2(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H2(237),ex2(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(349))
  call Hloop_VA_Q(ntryL,G1H2(238),ex2(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(350))
  call Hloop_VA_Q(ntryL,G1H2(250),ex4(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(271),n2h1(351))
  call Hloop_VA_Q(ntryL,G1H2(261),ex2(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(352))
  call Hloop_VA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(353))
  call Hloop_VA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(354))
call Hotf_4pt_reduction(G2H2(13),RedSet_4(150),mass4set(:,7),  & 
G1H2(265),G1H2(266),G1H2(277),G1H2(278),G1H2(389),2)
call HG1shiftOLR(G1H2(266),16,2)
call Hotf_4pt_reduction(G2H2(14),RedSet_4(164),mass4set(:,7),  & 
G1H2(284),G1H2(288),G1H2(289),G1H2(290),G1H2(394),2)
call HG1shiftOLR(G1H2(288),16,2)
call Hotf_4pt_reduction(G2H2(16),RedSet_4(191),mass4set(:,3),  & 
G1H2(295),G1H2(296),G1H2(300),G1H2(301),G1H2(302),2)
call HG1shiftOLR(G1H2(296),16,2)
call Hotf_4pt_reduction(G2H2(17),RedSet_4(195),mass4set(:,3),  & 
G1H2(307),G1H2(308),G1H2(312),G1H2(313),G1H2(314),2)
call HG1shiftOLR(G1H2(308),16,2)
  call Hloop_AV_Q(ntryL,G1H2(333),ex5(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(355))
call Hotf_4pt_reduction(G2H2(19),RedSet_4(205),mass4set(:,3),  & 
G1H2(319),G1H2(320),G1H2(399),G1H2(326),G1H2(330),2)
call HG1shiftOLR(G1H2(320),16,2)
call Hotf_4pt_reduction(G2H2(20),RedSet_4(209),mass4set(:,3),  & 
G1H2(331),G1H2(336),G1H2(337),G1H2(338),G1H2(343),2)
call HG1shiftOLR(G1H2(336),16,2)
  call Hloop_QV_A(ntryL,G1H2(351),ex5(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(356))
  call Hloop_VQ_A(ntryL,G1H4(109),wf4(:,13),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(357))
  call Hloop_VQ_A(ntryL,G1H4(78),wf4(:,13),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(358))
call Hotf_4pt_reduction(G2H4(39),RedSet_4(199),mass4set(:,3),  & 
G1H4(104),G1H4(134),G1H4(110),G1H4(139),G1H4(3),4)
call HG1shiftOLR(G1H4(134),17,4)
  call Hloop_VQ_A(ntryL,G1H4(98),wf4(:,13),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(359))
  call Hloop_VQ_A(ntryL,G1H4(100),wf4(:,13),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(360))
  call Hloop_VA_Q(ntryL,G1H4(111),wf4(:,18),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(303),n2h1(361))
  call Hloop_VA_Q(ntryL,G1H4(117),wf4(:,18),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(362))
call Hotf_4pt_reduction(G2H4(8),RedSet_4(213),mass4set(:,3),  & 
G1H4(4),G1H4(207),G1H4(229),G1H4(212),G1H4(213),4)
call HG1shiftOLR(G1H4(207),18,4)
  call Hloop_VA_Q(ntryL,G1H4(165),wf4(:,18),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(315),n2h1(363))
  call Hloop_VA_Q(ntryL,G1H4(115),wf4(:,18),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(364))
  call Hloop_VQ_A(ntryL,G1H4(39),wf4(:,4),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(323),n2h1(365))
call Hotf_4pt_reduction(G2H4(10),RedSet_4(155),mass4set(:,5),  & 
G1H4(223),G1H4(228),G1H4(239),G1H4(240),G1H4(244),4)
call HG1shiftOLR(G1H4(228),20,4)
  call Hloop_VQ_A(ntryL,G1H4(80),wf4(:,4),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(327),n2h1(366))
  call Hloop_VA_Q(ntryL,G1H4(122),wf4(:,9),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(331),n2h1(367))
call Hotf_4pt_reduction(G2H4(16),RedSet_4(169),mass4set(:,5),  & 
G1H4(245),G1H4(151),G1H4(152),G1H4(132),G1H4(138),4)
call HG1shiftOLR(G1H4(151),24,4)
  call Hloop_VA_Q(ntryL,G1H4(14),wf4(:,9),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(335),n2h1(368))
call Hotf_4pt_reduction(G2H2(12),RedSet_4(301),mass4set(:,6),  & 
G1H2(344),G1H2(348),G1H2(350),G1H2(354),G1H2(355),2)
call HG1shiftOLR(G1H2(348),8,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(6),mass4set(:,6),  & 
G1H2(360),G1H2(361),G1H2(362),G1H2(367),G1H2(368),2)
call HG1shiftOLR(G1H2(361),8,2)
  call Hloop_VA_Q(ntryL,G1H2(375),ex4(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(339),n2h1(369))
  call Hloop_VA_Q(ntryL,G1H2(376),ex4(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(343),n2h1(370))
  call Hloop_VA_Q(ntryL,G1H2(377),ex4(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(347),n2h1(371))
call Hotf_4pt_reduction(G2H2(84),RedSet_4(303),mass4set(:,6),  & 
G1H2(373),G1H2(385),G1H2(390),G1H2(395),G1H2(400),2)
call HG1shiftOLR(G1H2(385),4,2)
call Hotf_4pt_reduction(G2H2(8),RedSet_4(20),mass4set(:,6),  & 
G1H2(405),G1H2(409),G1H2(410),G1H2(415),G1H2(416),2)
call HG1shiftOLR(G1H2(409),4,2)
  call Hloop_VQ_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(351),n2h1(372))
  call Hloop_VQ_A(ntryL,G1H2(387),ex3(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(355),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H2(388),ex3(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(356),n2h1(374))
call Hotf_4pt_reduction(G2H4(54),RedSet_4(29),mass4set(:,3),  & 
G1H4(143),G1H4(144),G1H4(148),G1H4(82),G1H4(5),4)
call HG1shiftOLR(G1H4(144),12,4)
call Hotf_4pt_reduction(G2H4(73),RedSet_4(32),mass4set(:,3),  & 
G1H4(6),G1H4(10),G1H4(11),G1H4(18),G1H4(206),4)
call HG1shiftOLR(G1H4(10),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(85),51,wf4(:,12),12,G2tensor(357),m3h4x1(:,85),heltab2x4(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(86),51,wf4(:,12),12,G2tensor(358),m3h4x1(:,86),heltab2x4(:,:,456))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(150),51,wf4(:,12),12,G2tensor(359),m3h4x1(:,87),heltab2x4(:,:,457))
call Hotf_4pt_reduction(G2H4(37),RedSet_4(4),mass4set(:,3),  & 
G1H4(209),G1H4(211),G1H4(215),G1H4(216),G1H4(221),4)
call HG1shiftOLR(G1H4(211),12,4)
call Hotf_4pt_reduction(G2H4(76),RedSet_4(8),mass4set(:,3),  & 
G1H4(226),G1H4(225),G1H4(227),G1H4(231),G1H4(232),4)
call HG1shiftOLR(G1H4(225),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(205),51,wf4(:,12),12,G2tensor(360),m3h4x1(:,88),heltab2x4(:,:,458))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(161),51,wf4(:,12),12,G2tensor(361),m3h4x1(:,89),heltab2x4(:,:,459))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(164),51,wf4(:,12),12,G2tensor(362),m3h4x1(:,90),heltab2x4(:,:,460))
  call Hloop_QV_A(ntryL,G1H2(418),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(363),n2h1(375))
  call Hloop_QV_A(ntryL,G1H2(452),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(364),n2h1(376))
  call Hloop_AV_Q(ntryL,G1H2(440),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(365),n2h1(377))
  call Hloop_AV_Q(ntryL,G1H2(430),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(366),n2h1(378))
  call Hloop_QV_A(ntryL,G1H2(401),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(379))
  call Hloop_QV_A(ntryL,G1H2(462),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(380))
  call Hloop_QV_A(ntryL,G1H2(496),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(369),n2h1(381))
  call Hloop_AV_Q(ntryL,G1H2(406),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(370),n2h1(382))
  call Hloop_AV_Q(ntryL,G1H2(484),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(383))
  call Hloop_AV_Q(ntryL,G1H2(474),ex5(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(372),n2h1(384))
call Hotf_4pt_reduction(G2H2(77),RedSet_4(305),mass4set(:,7),  & 
G1H2(420),G1H2(421),G1H2(426),G1H2(371),G1H2(382),2)
call HG1shiftOLR(G1H2(421),16,2)
  call Hloop_QV_A(ntryL,G1H2(417),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(373),n2h1(385))
  call Hloop_QV_A(ntryL,G2H2(213),ex5(:),G2H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(1),n2h1(386))
call Hotf_4pt_reduction(G2H2(34),RedSet_4(308),mass4set(:,11),  & 
G1H2(175),G1H2(148),G1H2(180),G1H2(31),G1H2(147),2)
call HG1shiftOLR(G1H2(148),16,2)
call Hotf_4pt_reduction(G2H2(126),RedSet_4(309),mass4set(:,4),  & 
G1H2(185),G1H2(153),G1H2(190),G1H2(28),G1H2(152),2)
call HG1shiftOLR(G1H2(153),16,2)
  call Hloop_AV_Q(ntryL,G1H2(428),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(374),n2h1(387))
  call Hloop_AV_Q(ntryL,G2H2(129),ex5(:),G2H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(2),n2h1(388))
call Hotf_4pt_reduction(G2H2(35),RedSet_4(311),mass4set(:,7),  & 
G1H2(32),G1H2(195),G1H2(119),G1H2(200),G1H2(86),2)
call HG1shiftOLR(G1H2(195),16,2)
  call Hloop_AV_Q(ntryL,G1H2(439),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(375),n2h1(389))
  call Hloop_AV_Q(ntryL,G2H2(207),ex5(:),G2H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(3),n2h1(390))
call Hotf_4pt_reduction(G2H2(130),RedSet_4(309),mass4set(:,4),  & 
G1H2(205),G1H2(62),G1H2(210),G1H2(309),G1H2(315),2)
call HG1shiftOLR(G1H2(62),16,2)
  call Hloop_QV_A(ntryL,G2H2(136),ex5(:),G2H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(4),n2h1(391))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(235),mass4set(:,3),  & 
G1H4(242),G1H4(238),G1H4(243),G1H4(246),G1H4(97),4)
call HG1shiftOLR(G1H4(238),12,4)
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,12),G2H1(1),m3h4x1(:,91),heltab2x4(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(5),n2h1(392))
  call Hloop_QV_A(ntryL,G1H4(133),wf4(:,12),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(393))
  call Hloop_QV_A(ntryL,G1H2(461),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(394))
  call Hloop_QV_A(ntryL,G2H2(190),ex5(:),G2H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(395))
call Hotf_4pt_reduction(G2H4(79),RedSet_4(319),mass4set(:,3),  & 
G1H4(173),G1H4(185),G1H4(66),G1H4(84),G1H4(90),4)
call HG1shiftOLR(G1H4(185),12,4)
call Hotf_4pt_reduction(G2H4(41),RedSet_4(235),mass4set(:,3),  & 
G1H4(95),G1H4(93),G1H4(36),G1H4(40),G1H4(35),4)
call HG1shiftOLR(G1H4(93),12,4)
  call Hloop_AV_Q(ntryL,G1H4(188),wf4(:,12),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(378),n2h1(396))
  call Hloop_AV_Q(ntryL,G2H4(20),wf4(:,12),G2H1(1),m3h4x1(:,94),heltab2x4(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(397))
  call Hloop_AV_Q(ntryL,G1H4(192),wf4(:,12),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(379),n2h1(398))
call Hotf_4pt_reduction(G2H2(37),RedSet_4(321),mass4set(:,3),  & 
G1H2(193),G1H2(273),G1H2(357),G1H2(363),G1H2(198),2)
call HG1shiftOLR(G1H2(273),16,2)
call Hotf_4pt_reduction(G2H2(148),RedSet_4(306),mass4set(:,3),  & 
G1H2(303),G1H2(21),G1H2(75),G1H2(446),G1H2(281),2)
call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_AV_Q(ntryL,G1H2(472),ex5(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(380),n2h1(399))
  call Hloop_AV_Q(ntryL,G2H2(151),ex5(:),G2H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(400))
  call Hloop_AV_Q(ntryL,G1H2(483),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(381),n2h1(401))
  call Hloop_AV_Q(ntryL,G2H2(184),ex5(:),G2H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(9),n2h1(402))
call Hotf_4pt_reduction(G2H2(152),RedSet_4(306),mass4set(:,3),  & 
G1H2(109),G1H2(37),G1H2(50),G1H2(115),G1H2(424),2)
call HG1shiftOLR(G1H2(37),16,2)
  call Hloop_QV_A(ntryL,G2H2(155),ex5(:),G2H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(10),n2h1(403))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(382),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(383),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(384),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(385),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(386),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(56),ex3(:),G2tensor(387),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(388),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(389),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(390),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(89),ex3(:),G2tensor(391),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(392),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex1(:),G2tensor(393),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(394),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(395),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(396),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(397),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(81),wf4(:,13),G2tensor(398),m3h4x1(:,96),heltab2x4(:,:,466))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(82),wf4(:,13),G2tensor(399),m3h4x1(:,97),heltab2x4(:,:,467))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(22),wf4(:,18),G2tensor(400),m3h4x1(:,98),heltab2x4(:,:,468))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(25),wf4(:,18),G2tensor(401),m3h4x1(:,99),heltab2x4(:,:,469))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(28),wf4(:,4),G2tensor(402),m3h4x1(:,100),heltab2x4(:,:,470))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(31),wf4(:,4),G2tensor(403),m3h4x1(:,101),heltab2x4(:,:,471))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(34),wf4(:,9),G2tensor(404),m3h4x1(:,102),heltab2x4(:,:,472))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(38),wf4(:,9),G2tensor(405),m3h4x1(:,103),heltab2x4(:,:,473))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex4(:),G2tensor(406),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(141),ex4(:),G2tensor(407),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(124),ex3(:),G2tensor(408),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(145),ex3(:),G2tensor(409),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(169),ex4(:),G2tensor(410),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(97),ex4(:),G2tensor(411),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(93),ex4(:),G2tensor(412),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(173),ex2(:),G2tensor(413),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(414),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(179),ex2(:),G2tensor(415),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex2(:),G2tensor(416),m3h2x1(:,475),heltab2x2(:,:,475))
call Hotf_4pt_reduction(G2H4(13),RedSet_4(70),mass4set(:,6),  & 
G1H4(141),G1H4(31),G1H4(45),G1H4(159),G1H4(160),4)
call HG1shiftOLR(G1H4(31),20,4)
call Hotf_4pt_reduction(G2H4(19),RedSet_4(56),mass4set(:,6),  & 
G1H4(168),G1H4(194),G1H4(197),G1H4(198),G1H4(199),4)
call HG1shiftOLR(G1H4(194),24,4)
call Hotf_4pt_reduction(G2H4(43),RedSet_4(238),mass4set(:,3),  & 
G1H4(129),G1H4(219),G1H4(218),G1H4(158),G1H4(46),4)
call HG1shiftOLR(G1H4(219),17,4)
call Hotf_4pt_reduction(G2H4(51),RedSet_4(239),mass4set(:,3),  & 
G1H4(142),G1H4(21),G1H4(169),G1H4(60),G1H4(16),4)
call HG1shiftOLR(G1H4(21),18,4)
call Hotf_4pt_reduction(G2H8(45),RedSet_4(236),mass4set(:,7),  & 
G1H8(134),G1H8(144),G1H8(140),G1H8(143),G1H8(145),8)
call HG1shiftOLR(G1H8(144),19,8)
call Hotf_4pt_reduction(G2H8(46),RedSet_4(236),mass4set(:,12),  & 
G1H8(52),G1H8(137),G1H8(47),G1H8(49),G1H8(48),8)
call HG1shiftOLR(G1H8(137),19,8)
call Hotf_4pt_reduction(G2H8(17),RedSet_4(237),mass4set(:,7),  & 
G1H8(121),G1H8(51),G1H8(122),G1H8(138),G1H8(36),8)
call HG1shiftOLR(G1H8(51),19,8)
call Hotf_4pt_reduction(G2H8(19),RedSet_4(237),mass4set(:,12),  & 
G1H8(21),G1H8(33),G1H8(39),G1H8(40),G1H8(16),8)
call HG1shiftOLR(G1H8(33),19,8)
call Hotf_4pt_reduction(G2H8(20),RedSet_4(236),mass4set(:,7),  & 
G1H8(9),G1H8(31),G1H8(1),G1H8(2),G1H8(3),8)
call HG1shiftOLR(G1H8(31),19,8)
call Hotf_4pt_reduction(G2H8(21),RedSet_4(236),mass4set(:,12),  & 
G1H8(26),G1H8(24),G1H8(32),G1H8(37),G1H8(55),8)
call HG1shiftOLR(G1H8(24),19,8)
call Hotf_4pt_reduction(G2H8(23),RedSet_4(237),mass4set(:,7),  & 
G1H8(56),G1H8(57),G1H8(58),G1H8(62),G1H8(63),8)
call HG1shiftOLR(G1H8(57),19,8)
call Hotf_4pt_reduction(G2H8(24),RedSet_4(237),mass4set(:,12),  & 
G1H8(64),G1H8(67),G1H8(69),G1H8(70),G1H8(73),8)
call HG1shiftOLR(G1H8(67),19,8)
call Hotf_4pt_reduction(G2H8(16),RedSet_4(82),mass4set(:,3),  & 
G1H8(74),G1H8(76),G1H8(79),G1H8(80),G1H8(12),8)
call HG1shiftOLR(G1H8(76),28,8)
call Hotf_4pt_reduction(G2H8(36),RedSet_4(82),mass4set(:,3),  & 
G1H8(85),G1H8(86),G1H8(8),G1H8(13),G1H8(11),8)
call HG1shiftOLR(G1H8(86),28,8)
call Hotf_4pt_reduction(G2H8(40),RedSet_4(60),mass4set(:,3),  & 
G1H8(43),G1H8(35),G1H8(120),G1H8(82),G1H8(6),8)
call HG1shiftOLR(G1H8(35),28,8)
call Hotf_4pt_reduction(G2H8(44),RedSet_4(60),mass4set(:,3),  & 
G1H8(91),G1H8(136),G1H8(92),G1H8(27),G1H8(29),8)
call HG1shiftOLR(G1H8(136),28,8)
call Hotf_4pt_reduction(G2H8(32),RedSet_4(82),mass4set(:,3),  & 
G1H8(46),G1H8(18),G1H8(41),G1H8(7),G1H8(20),8)
call HG1shiftOLR(G1H8(18),28,8)
call Hotf_4pt_reduction(G2H8(2),RedSet_4(82),mass4set(:,3),  & 
G1H8(30),G1H8(54),G1H8(22),G1H8(53),G1H8(66),8)
call HG1shiftOLR(G1H8(54),28,8)
call Hotf_4pt_reduction(G2H8(5),RedSet_4(60),mass4set(:,3),  & 
G1H8(60),G1H8(65),G1H8(71),G1H8(72),G1H8(77),8)
call HG1shiftOLR(G1H8(65),28,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(60),mass4set(:,3),  & 
G1H8(83),G1H8(90),G1H8(89),G1H8(95),G1H8(102),8)
call HG1shiftOLR(G1H8(90),28,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(417),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(418),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(45),ex3(:),G2tensor(419),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(51),ex3(:),G2tensor(420),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(421),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(94),ex4(:),G2tensor(422),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex2(:),G2tensor(423),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex2(:),G2tensor(424),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(103),ex2(:),G2tensor(425),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(108),ex1(:),G2tensor(426),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(111),ex1(:),G2tensor(427),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(112),ex2(:),G2tensor(428),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(429),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(121),ex3(:),G2tensor(430),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hloop_AV_Q(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(431),n2h1(404))
  call Hloop_QV_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(432),n2h1(405))
  call Hloop_QV_A(ntryL,G1H4(193),wf4(:,12),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(433),n2h1(406))
  call Hloop_AV_Q(ntryL,G1H4(220),wf4(:,12),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(407))
  call Hloop_AV_Q(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(435),n2h1(408))
  call Hloop_QV_A(ntryL,G1H2(270),ex5(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(436),n2h1(409))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(61),wf4(:,13),G2tensor(437),m3h4x1(:,106),heltab2x4(:,:,476))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(9),wf4(:,13),G2tensor(438),m3h4x1(:,107),heltab2x4(:,:,477))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(15),wf4(:,18),G2tensor(439),m3h4x1(:,108),heltab2x4(:,:,478))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(29),wf4(:,18),G2tensor(440),m3h4x1(:,109),heltab2x4(:,:,479))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(30),wf4(:,4),G2tensor(441),m3h4x1(:,110),heltab2x4(:,:,480))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(36),wf4(:,4),G2tensor(442),m3h4x1(:,111),heltab2x4(:,:,481))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(48),wf4(:,9),G2tensor(443),m3h4x1(:,112),heltab2x4(:,:,482))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(56),wf4(:,9),G2tensor(444),m3h4x1(:,113),heltab2x4(:,:,483))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(166),ex4(:),G2tensor(445),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(170),ex2(:),G2tensor(446),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(175),ex2(:),G2tensor(447),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hloop_AV_Q(ntryL,G1H2(318),ex5(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(448),n2h1(410))
  call Hloop_QV_A(ntryL,G1H2(325),ex5(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(449),n2h1(411))
call Hotf_4pt_reduction(G2H2(191),RedSet_4(309),mass4set(:,9),  & 
G1H2(293),G1H2(121),G1H2(68),G1H2(127),G1H2(151),2)
call HG1shiftOLR(G1H2(121),16,2)
  call Hloop_AV_Q(ntryL,G2H2(194),ex5(:),G2H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(11),n2h1(412))
  call Hloop_AV_Q(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(450),n2h1(413))
call Hotf_4pt_reduction(G2H2(197),RedSet_4(309),mass4set(:,9),  & 
G1H2(490),G1H2(323),G1H2(157),G1H2(133),G1H2(139),2)
call HG1shiftOLR(G1H2(323),16,2)
  call Hloop_QV_A(ntryL,G2H2(200),ex5(:),G2H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(12),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(451),n2h1(415))
  call Hloop_AV_Q(ntryL,G1H2(349),ex5(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(452),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(356),ex5(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(453),n2h1(417))
call Hotf_4pt_reduction(G2H2(214),RedSet_4(306),mass4set(:,9),  & 
G1H2(163),G1H2(468),G1H2(341),G1H2(169),G1H2(145),2)
call HG1shiftOLR(G1H2(468),16,2)
  call Hloop_AV_Q(ntryL,G2H2(231),ex5(:),G2H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(13),n2h1(418))
  call Hloop_AV_Q(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(454),n2h1(419))
call Hotf_4pt_reduction(G2H2(233),RedSet_4(306),mass4set(:,9),  & 
G1H2(173),G1H2(174),G1H2(178),G1H2(243),G1H2(179),2)
call HG1shiftOLR(G1H2(174),16,2)
  call Hloop_QV_A(ntryL,G2H2(238),ex5(:),G2H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(14),n2h1(420))
  call Hloop_QV_A(ntryL,G1H2(374),ex5(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(455),n2h1(421))
call Hotf_4pt_reduction(G2H4(70),RedSet_4(235),mass4set(:,4),  & 
G1H4(217),G1H4(32),G1H4(28),G1H4(74),G1H4(75),4)
call HG1shiftOLR(G1H4(32),12,4)
  call Hloop_QV_A(ntryL,G2H4(78),wf4(:,12),G2H1(1),m3h4x1(:,114),heltab2x4(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(15),n2h1(422))
  call Hloop_QV_A(ntryL,G1H4(108),wf4(:,12),G1H1(1),m3h4x1(:,115),heltab2x4(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(456),n2h1(423))
call Hotf_4pt_reduction(G2H4(80),RedSet_4(235),mass4set(:,4),  & 
G1H4(107),G1H4(116),G1H4(137),G1H4(120),G1H4(26),4)
call HG1shiftOLR(G1H4(116),12,4)
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,12),G2H1(1),m3h4x1(:,116),heltab2x4(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(16),n2h1(424))
  call Hloop_AV_Q(ntryL,G1H4(124),wf4(:,12),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(457),n2h1(425))
call Hotf_4pt_reduction(G2H4(66),RedSet_4(235),mass4set(:,9),  & 
G1H4(70),G1H4(136),G1H4(58),G1H4(130),G1H4(41),4)
call HG1shiftOLR(G1H4(136),12,4)
  call Hloop_QV_A(ntryL,G2H4(62),wf4(:,12),G2H1(1),m3h4x1(:,118),heltab2x4(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(17),n2h1(426))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,12),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(458),n2h1(427))
call Hotf_4pt_reduction(G2H4(83),RedSet_4(235),mass4set(:,9),  & 
G1H4(59),G1H4(175),G1H4(88),G1H4(166),G1H4(105),4)
call HG1shiftOLR(G1H4(175),12,4)
  call Hloop_AV_Q(ntryL,G2H4(85),wf4(:,12),G2H1(1),m3h4x1(:,120),heltab2x4(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(18),n2h1(428))
  call Hloop_AV_Q(ntryL,G1H4(99),wf4(:,12),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(459),n2h1(429))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(86),wf4(:,4),G2tensor(460),m3h4x1(:,122),heltab2x4(:,:,492))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(88),wf4(:,4),G2tensor(461),m3h4x1(:,123),heltab2x4(:,:,493))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(89),wf4(:,9),G2tensor(462),m3h4x1(:,124),heltab2x4(:,:,494))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(91),wf4(:,9),G2tensor(463),m3h4x1(:,125),heltab2x4(:,:,495))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(14),wf8(:,3),G2tensor(464),m3h8x1(:,1),heltab2x8(:,:,409))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,3),G2tensor(465),m3h8x1(:,2),heltab2x8(:,:,410))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(92),wf4(:,13),G2tensor(466),m3h4x1(:,126),heltab2x4(:,:,496))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(94),wf4(:,13),G2tensor(467),m3h4x1(:,127),heltab2x4(:,:,497))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(95),wf4(:,18),G2tensor(468),m3h4x1(:,128),heltab2x4(:,:,498))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(97),wf4(:,18),G2tensor(469),m3h4x1(:,129),heltab2x4(:,:,499))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,20),G2tensor(470),m3h8x1(:,3),heltab2x8(:,:,411))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(10),wf8(:,20),G2tensor(471),m3h8x1(:,4),heltab2x8(:,:,412))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(11),wf8(:,16),G2tensor(472),m3h8x1(:,5),heltab2x8(:,:,413))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(34),wf8(:,16),G2tensor(473),m3h8x1(:,6),heltab2x8(:,:,414))
  call Hloop_VA_Q(ntryL,G1H2(427),ex4(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(474),n2h1(430))
  call Hloop_VA_Q(ntryL,G1H2(431),ex4(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(475),n2h1(431))
  call Hloop_VA_Q(ntryL,G1H2(438),ex4(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(476),n2h1(432))
  call Hloop_VQ_A(ntryL,G1H2(442),ex3(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(477),n2h1(433))
  call Hloop_VQ_A(ntryL,G1H2(443),ex3(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(478),n2h1(434))
  call Hloop_VQ_A(ntryL,G1H2(453),ex3(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(479),n2h1(435))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),51,wf4(:,12),12,G2tensor(480),m3h4x1(:,130),heltab2x4(:,:,500))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),0,wf4(:,12),12,G2tensor(481),m3h4x1(:,131),heltab2x4(:,:,501))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(154),51,wf4(:,12),12,G2tensor(482),m3h4x1(:,132),heltab2x4(:,:,502))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(87),51,wf4(:,12),12,G2tensor(483),m3h4x1(:,133),heltab2x4(:,:,503))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(163),0,wf4(:,12),12,G2tensor(484),m3h4x1(:,134),heltab2x4(:,:,504))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(195),51,wf4(:,12),12,G2tensor(485),m3h4x1(:,135),heltab2x4(:,:,505))
  call Hloop_VQ_A(ntryL,G1H2(454),ex3(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(486),n2h1(438))
  call Hloop_VQ_A(ntryL,G1H2(459),ex3(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(487),n2h1(439))
  call Hloop_VQ_A(ntryL,G1H2(465),ex3(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(488),n2h1(440))
  call Hloop_QV_A(ntryL,G1H2(470),ex5(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(489),n2h1(441))
  call Hloop_QV_A(ntryL,G1H2(471),ex5(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(490),n2h1(442))
  call Hloop_QV_A(ntryL,G1H2(481),ex5(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(491),n2h1(443))
  call Hloop_VA_Q(ntryL,G1H2(482),ex4(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(492),n2h1(444))
  call Hloop_VA_Q(ntryL,G1H2(486),ex4(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(493),n2h1(445))
  call Hloop_VA_Q(ntryL,G1H2(493),ex4(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(494),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(495),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H2(294),ex5(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(496),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H2(372),ex5(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(497),n2h1(449))
  call Hloop_VQ_A(ntryL,G1H2(383),ex1(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(498),n2h1(450))
  call Hloop_VQ_A(ntryL,G1H2(414),ex1(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(499),n2h1(451))
  call Hloop_VQ_A(ntryL,G1H2(447),ex1(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(500),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(458),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(501),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(469),ex5(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(502),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(107),ex5(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(503),n2h1(455))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(504),n2h1(456))
  call Hloop_VA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(505),n2h1(457))
  call Hloop_VA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(506),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(507),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(508),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(509),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(510),n2h1(462))
  call Hloop_QV_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(511),n2h1(463))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(512),n2h1(464))
  call Hloop_AV_Q(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(513),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(514),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(515),n2h1(467))
  call Hloop_VQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(516),n2h1(468))
  call Hloop_VQ_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(517),n2h1(469))
  call Hloop_VQ_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(518),n2h1(470))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(519),n2h1(471))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(520),n2h1(472))
  call Hloop_QV_A(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(521),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H4(201),wf4(:,1),G1H1(1),m3h4x1(:,136),heltab2x4(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(522),n2h1(474))
  call Hloop_AV_Q(ntryL,G1H4(208),wf4(:,1),G1H1(1),m3h4x1(:,137),heltab2x4(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(523),n2h1(475))
  call Hloop_AV_Q(ntryL,G1H4(53),wf4(:,1),G1H1(1),m3h4x1(:,138),heltab2x4(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(524),n2h1(476))
  call Hloop_VA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(525),n2h1(477))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(526),n2h1(478))
  call Hloop_VA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(527),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(528),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(529),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(530),n2h1(482))
  call Hloop_QV_A(ntryL,G1H4(230),wf4(:,1),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(531),n2h1(483))
  call Hloop_QV_A(ntryL,G1H4(241),wf4(:,1),G1H1(1),m3h4x1(:,140),heltab2x4(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(532),n2h1(484))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,141),heltab2x4(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(533),n2h1(485))
  call Hloop_QV_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(534),n2h1(486))
  call Hloop_QV_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(535),n2h1(487))
  call Hloop_QV_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(536),n2h1(488))
  call Hloop_QV_A(ntryL,G1H4(155),wf4(:,12),G1H1(1),m3h4x1(:,142),heltab2x4(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(537),n2h1(489))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,12),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(538),n2h1(490))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,12),G1H1(1),m3h4x1(:,144),heltab2x4(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(539),n2h1(491))
  call Hloop_VQ_A(ntryL,G1H2(142),ex1(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(540),n2h1(492))
  call Hloop_VQ_A(ntryL,G1H2(146),ex1(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(541),n2h1(493))
  call Hloop_VQ_A(ntryL,G1H2(170),ex1(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(542),n2h1(494))
  call Hloop_QV_A(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(543),n2h1(495))
  call Hloop_QV_A(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(544),n2h1(496))
  call Hloop_QV_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(545),n2h1(497))
  call Hloop_AV_Q(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(546),n2h1(498))
  call Hloop_AV_Q(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(547),n2h1(499))
  call Hloop_AV_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(548),n2h1(500))
  call Hloop_AV_Q(ntryL,G1H4(176),wf4(:,12),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(549),n2h1(501))
  call Hloop_AV_Q(ntryL,G1H4(180),wf4(:,12),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(550),n2h1(502))
  call Hloop_AV_Q(ntryL,G1H4(203),wf4(:,12),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(551),n2h1(503))
  call Hloop_AV_Q(ntryL,G1H4(200),wf4(:,12),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(552),n2h1(504))
  call Hloop_AV_Q(ntryL,G1H4(101),wf4(:,12),G1H1(1),m3h4x1(:,149),heltab2x4(:,:,519))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(553),n2h1(505))
  call Hloop_AV_Q(ntryL,G1H4(102),wf4(:,12),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(554),n2h1(506))
  call Hloop_VA_Q(ntryL,G1H2(192),ex2(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(555),n2h1(507))
  call Hloop_VA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(556),n2h1(508))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(557),n2h1(509))
  call Hloop_AV_Q(ntryL,G1H2(202),ex5(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(558),n2h1(510))
  call Hloop_AV_Q(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(559),n2h1(511))
  call Hloop_AV_Q(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(560),n2h1(512))
  call Hloop_QV_A(ntryL,G1H4(126),wf4(:,12),G1H1(1),m3h4x1(:,151),heltab2x4(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(561),n2h1(513))
  call Hloop_QV_A(ntryL,G1H4(131),wf4(:,12),G1H1(1),m3h4x1(:,152),heltab2x4(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(562),n2h1(514))
  call Hloop_QV_A(ntryL,G1H4(162),wf4(:,12),G1H1(1),m3h4x1(:,153),heltab2x4(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(563),n2h1(515))
  call Hloop_QV_A(ntryL,G1H4(224),wf4(:,1),G1H1(1),m3h4x1(:,154),heltab2x4(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(564),n2h1(516))
  call Hloop_QV_A(ntryL,G1H4(171),wf4(:,1),G1H1(1),m3h4x1(:,155),heltab2x4(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(565),n2h1(517))
  call Hloop_QV_A(ntryL,G1H4(235),wf4(:,1),G1H1(1),m3h4x1(:,156),heltab2x4(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(566),n2h1(518))
  call Hloop_QV_A(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(567),n2h1(519))
  call Hloop_QV_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(568),n2h1(520))
  call Hloop_QV_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(569),n2h1(521))
  call Hloop_QV_A(ntryL,G1H4(113),wf4(:,12),G1H1(1),m3h4x1(:,157),heltab2x4(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(570),n2h1(522))
  call Hloop_QV_A(ntryL,G1H4(49),wf4(:,12),G1H1(1),m3h4x1(:,158),heltab2x4(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(571),n2h1(523))
  call Hloop_QV_A(ntryL,G1H4(68),wf4(:,12),G1H1(1),m3h4x1(:,159),heltab2x4(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(572),n2h1(524))
  call Hloop_QV_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(573),n2h1(525))
  call Hloop_QV_A(ntryL,G1H2(229),ex5(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(574),n2h1(526))
  call Hloop_QV_A(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(575),n2h1(527))
  call Hloop_VA_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(576),n2h1(528))
  call Hloop_VA_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(577),n2h1(529))
  call Hloop_VA_Q(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(578),n2h1(530))
  call Hloop_VA_Q(ntryL,G1H2(252),ex2(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(579),n2h1(531))
  call Hloop_VA_Q(ntryL,G1H2(254),ex2(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(580),n2h1(532))
  call Hloop_VA_Q(ntryL,G1H2(264),ex2(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(581),n2h1(533))
  call Hloop_QV_A(ntryL,G1H2(265),ex5(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(582),n2h1(534))
  call Hloop_QV_A(ntryL,G1H2(266),ex5(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(583),n2h1(535))
  call Hloop_QV_A(ntryL,G1H2(389),ex5(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))



end subroutine vamp_3

end module ol_vamp_3_ppattj_uuxttxag_1_/**/REALKIND
