
module ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(6,6), K2(6,11), KL(6,11), Cas(6)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 64, -8, -8,  1,  1, 10]
  K1(2,:) = [ -8, 64,  1, 10, -8,  1]
  K1(3,:) = [ -8,  1, 64, -8, 10,  1]
  K1(4,:) = [  1, 10, -8, 64,  1, -8]
  K1(5,:) = [  1, -8, 10,  1, 64, -8]
  K1(6,:) = [ 10,  1,  1, -8, -8, 64]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL
  Cas = 0
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND



module ol_forced_parameters_ppattj_ttxaggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppattj_ttxaggg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppattj_ttxaggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(632)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,58), wf8(8,240), wf16(16,270), wf64(64,450)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(24), c(29)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(11,64), M0M1_hel_cc(11,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppattj_ttxaggg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppattj_ttxaggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppattj_ttxaggg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED*gQCD**3)/3._/**/REALKIND
    f( 2) = (2*eQED*gQCD**3)/3._/**/REALKIND
    f( 3) = (2*CI*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED*gQCD**5
    f( 5) = (2*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 6) = countertermnorm*eQED*gQCD**5
    f( 7) = (2*CI*countertermnorm*ctGtt*eQED*gQCD**5)/3._/**/REALKIND
    f( 8) = (2*countertermnorm*ctGtt*eQED*gQCD**5)/3._/**/REALKIND
    f( 9) = (2*CI*countertermnorm*ctVtt*eQED*gQCD**5)/3._/**/REALKIND
    f(10) = (2*countertermnorm*ctVtt*eQED*gQCD**5)/3._/**/REALKIND
    f(11) = (2*CI*countertermnorm*ctVVV*eQED*gQCD**5)/3._/**/REALKIND
    f(12) = (2*countertermnorm*ctVVV*eQED*gQCD**5)/3._/**/REALKIND
    f(13) = (2*CI*countertermnorm*ctVVVV*eQED*gQCD**5)/3._/**/REALKIND
    f(14) = (2*CI*countertermnorm*eQED*gQCD**5*R2GGGG)/3._/**/REALKIND
    f(15) = (CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(16) = (2*CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(17) = (eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(18) = (2*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(19) = (CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(20) = (2*CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(21) = (4*CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(22) = (eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(23) = (2*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(24) = (4*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND

  c = [ 9*CI*f(15), 18*CI*f(15), CI*f(16), 3*CI*f(16), 8*CI*f(16), 9*CI*f(16), 18*CI*f(16), 3*f(17), 6*f(17), 9*f(17), 18*f(17) &
    , f(18), 3*f(18), 6*f(18), 8*f(18), 9*f(18), 18*f(18), CI*f(19), 3*CI*f(19), CI*f(20), 3*CI*f(20), CI*f(21), 3*CI*f(21), f(22) &
    , 3*f(22), f(23), 3*f(23), f(24), 3*f(24) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MT2)+L(6,5))
  den(2) = 1 /((L(5,56))+L(6,56))
  den(4) = 1 /((L(5,6) - MT2)+L(6,6))
  den(6) = 1 /((L(5,10) - MT2)+L(6,10))
  den(7) = 1 /((L(5,48))+L(6,48))
  den(10) = 1 /((L(5,21) - MT2)+L(6,21))
  den(13) = 1 /((L(5,26) - MT2)+L(6,26))
  den(16) = 1 /((L(5,18) - MT2)+L(6,18))
  den(17) = 1 /((L(5,40))+L(6,40))
  den(20) = 1 /((L(5,13) - MT2)+L(6,13))
  den(25) = 1 /((L(5,34) - MT2)+L(6,34))
  den(26) = 1 /((L(5,24))+L(6,24))
  den(29) = 1 /((L(5,7))+L(6,7))
  den(35) = 1 /((L(5,42) - MT2)+L(6,42))
  den(42) = 1 /((L(5,50) - MT2)+L(6,50))
  den(45) = 1 /((L(5,9) - MT2)+L(6,9))
  den(48) = 1 /((L(5,25) - MT2)+L(6,25))
  den(51) = 1 /((L(5,22) - MT2)+L(6,22))
  den(54) = 1 /((L(5,17) - MT2)+L(6,17))
  den(59) = 1 /((L(5,14) - MT2)+L(6,14))
  den(62) = 1 /((L(5,33) - MT2)+L(6,33))
  den(69) = 1 /((L(5,41) - MT2)+L(6,41))
  den(77) = 1 /((L(5,49) - MT2)+L(6,49))
  den(85) = 1 /((L(5,38) - MT2)+L(6,38))
  den(93) = 1 /((L(5,37) - MT2)+L(6,37))
  den(106) = 1 /((L(5,3))+L(6,3))
  den(109) = 1 /((L(5,52))+L(6,52))
  den(112) = 1 /((L(5,44))+L(6,44))
  den(114) = 1 /((L(5,28))+L(6,28))
  den(126) = 1 /((L(5,58) - MT2)+L(6,58))
  den(140) = 1 /((L(5,57) - MT2)+L(6,57))
  den(187) = 1 /((L(5,53) - MT2)+L(6,53))
  den(190) = 1 /((L(5,15))+L(6,15))
  den(205) = 1 /((L(5,45) - MT2)+L(6,45))
  den(208) = 1 /((L(5,23))+L(6,23))
  den(222) = 1 /((L(5,29) - MT2)+L(6,29))
  den(225) = 1 /((L(5,39))+L(6,39))
  den(257) = 1 /((L(5,54) - MT2)+L(6,54))
  den(274) = 1 /((L(5,46) - MT2)+L(6,46))
  den(290) = 1 /((L(5,30) - MT2)+L(6,30))
  den(377) = 1 /((L(5,51))+L(6,51))
  den(379) = 1 /((L(5,43))+L(6,43))
  den(381) = 1 /((L(5,27))+L(6,27))
  den(383) = 1 /((L(5,35))+L(6,35))
  den(386) = 1 /((L(5,19))+L(6,19))
  den(389) = 1 /((L(5,11))+L(6,11))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(8) = den(1)*den(6)
  den(9) = den(7)*den(8)
  den(11) = den(1)*den(10)
  den(12) = den(6)*den(11)
  den(14) = den(6)*den(13)
  den(15) = den(1)*den(14)
  den(18) = den(1)*den(16)
  den(19) = den(17)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(16)*den(21)
  den(23) = den(13)*den(16)
  den(24) = den(1)*den(23)
  den(27) = den(1)*den(25)
  den(28) = den(26)*den(27)
  den(30) = den(1)*den(29)
  den(31) = den(26)*den(30)
  den(32) = den(13)*den(26)
  den(33) = den(1)*den(32)
  den(34) = den(21)*den(25)
  den(36) = den(25)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(17)*den(30)
  den(39) = den(17)*den(35)
  den(40) = den(1)*den(39)
  den(41) = den(7)*den(30)
  den(43) = den(7)*den(42)
  den(44) = den(1)*den(43)
  den(46) = den(4)*den(45)
  den(47) = den(7)*den(46)
  den(49) = den(45)*den(48)
  den(50) = den(4)*den(49)
  den(52) = den(4)*den(51)
  den(53) = den(45)*den(52)
  den(55) = den(4)*den(54)
  den(56) = den(17)*den(55)
  den(57) = den(48)*den(54)
  den(58) = den(4)*den(57)
  den(60) = den(4)*den(59)
  den(61) = den(54)*den(60)
  den(63) = den(4)*den(62)
  den(64) = den(26)*den(63)
  den(65) = den(4)*den(29)
  den(66) = den(26)*den(65)
  den(67) = den(26)*den(48)
  den(68) = den(4)*den(67)
  den(70) = den(62)*den(69)
  den(71) = den(4)*den(70)
  den(72) = den(60)*den(62)
  den(73) = den(17)*den(65)
  den(74) = den(17)*den(69)
  den(75) = den(4)*den(74)
  den(76) = den(7)*den(65)
  den(78) = den(7)*den(77)
  den(79) = den(4)*den(78)
  den(80) = den(20)*den(45)
  den(81) = den(16)*den(80)
  den(82) = den(16)*den(51)
  den(83) = den(45)*den(82)
  den(84) = den(25)*den(80)
  den(86) = den(25)*den(85)
  den(87) = den(45)*den(86)
  den(88) = den(43)*den(45)
  den(89) = den(10)*den(54)
  den(90) = den(6)*den(89)
  den(91) = den(6)*den(59)
  den(92) = den(54)*den(91)
  den(94) = den(62)*den(93)
  den(95) = den(6)*den(94)
  den(96) = den(62)*den(91)
  den(97) = den(6)*den(78)
  den(98) = den(25)*den(89)
  den(99) = den(54)*den(86)
  den(100) = den(39)*den(54)
  den(101) = den(16)*den(94)
  den(102) = den(62)*den(82)
  den(103) = den(16)*den(74)
  den(104) = den(32)*den(62)
  den(105) = den(25)*den(67)
  den(107) = den(26)*den(106)
  den(108) = den(17)*den(106)
  den(110) = den(106)*den(109)
  den(111) = den(7)*den(106)
  den(113) = den(106)*den(112)
  den(115) = den(106)*den(114)
  den(116) = den(45)*den(109)
  den(117) = den(6)*den(109)
  den(118) = den(54)*den(112)
  den(119) = den(16)*den(112)
  den(120) = den(62)*den(114)
  den(121) = den(25)*den(114)
  den(122) = den(1)*den(93)
  den(123) = den(6)*den(122)
  den(124) = den(6)*den(35)
  den(125) = den(1)*den(124)
  den(127) = den(2)*den(126)
  den(128) = den(1)*den(127)
  den(129) = den(2)*den(30)
  den(130) = den(16)*den(122)
  den(131) = den(16)*den(42)
  den(132) = den(1)*den(131)
  den(133) = den(11)*den(25)
  den(134) = den(25)*den(42)
  den(135) = den(1)*den(134)
  den(136) = den(45)*den(69)
  den(137) = den(4)*den(136)
  den(138) = den(4)*den(85)
  den(139) = den(45)*den(138)
  den(141) = den(2)*den(140)
  den(142) = den(4)*den(141)
  den(143) = den(2)*den(65)
  den(144) = den(54)*den(77)
  den(145) = den(4)*den(144)
  den(146) = den(54)*den(138)
  den(147) = den(62)*den(77)
  den(148) = den(4)*den(147)
  den(149) = den(52)*den(62)
  den(150) = den(16)*den(136)
  den(151) = den(45)*den(131)
  den(152) = den(25)*den(49)
  den(153) = den(45)*den(134)
  den(154) = den(6)*den(144)
  den(155) = den(54)*den(124)
  den(156) = den(6)*den(147)
  den(157) = den(14)*den(62)
  den(158) = den(25)*den(57)
  den(159) = den(36)*den(54)
  den(160) = den(16)*den(70)
  den(161) = den(23)*den(62)
  den(162) = den(26)*den(122)
  den(163) = den(2)*den(26)
  den(164) = den(1)*den(163)
  den(165) = den(11)*den(17)
  den(166) = den(2)*den(17)
  den(167) = den(1)*den(166)
  den(168) = den(7)*den(21)
  den(169) = den(2)*den(7)
  den(170) = den(1)*den(169)
  den(171) = den(7)*den(80)
  den(172) = den(17)*den(89)
  den(173) = den(26)*den(94)
  den(174) = den(4)*den(163)
  den(175) = den(26)*den(138)
  den(176) = den(4)*den(166)
  den(177) = den(17)*den(52)
  den(178) = den(4)*den(169)
  den(179) = den(7)*den(60)
  den(180) = den(7)*den(91)
  den(181) = den(17)*den(82)
  den(182) = den(26)*den(86)
  den(183) = den(6)*den(7)
  den(184) = den(126)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(1)*den(7)
  den(188) = den(186)*den(187)
  den(189) = den(6)*den(188)
  den(191) = den(8)*den(190)
  den(192) = den(7)*den(191)
  den(193) = den(1)**2
  den(194) = den(124)*den(193)
  den(195) = den(14)*den(193)
  den(196) = den(6)**2
  den(197) = den(122)*den(196)
  den(198) = den(11)*den(196)
  den(199) = den(11)*den(124)
  den(200) = den(14)*den(122)
  den(201) = den(16)*den(17)
  den(202) = den(126)*den(201)
  den(203) = den(1)*den(202)
  den(204) = den(1)*den(17)
  den(206) = den(204)*den(205)
  den(207) = den(16)*den(206)
  den(209) = den(18)*den(208)
  den(210) = den(17)*den(209)
  den(211) = den(131)*den(193)
  den(212) = den(23)*den(193)
  den(213) = den(16)**2
  den(214) = den(122)*den(213)
  den(215) = den(21)*den(213)
  den(216) = den(21)*den(131)
  den(217) = den(23)*den(122)
  den(218) = den(25)*den(26)
  den(219) = den(126)*den(218)
  den(220) = den(1)*den(219)
  den(221) = den(1)*den(26)
  den(223) = den(221)*den(222)
  den(224) = den(25)*den(223)
  den(226) = den(27)*den(225)
  den(227) = den(26)*den(226)
  den(228) = den(163)*den(193)
  den(229) = den(32)*den(193)
  den(230) = den(26)**2
  den(231) = den(122)*den(230)
  den(232) = den(30)*den(163)
  den(233) = den(32)*den(122)
  den(234) = den(30)*den(230)
  den(235) = den(134)*den(193)
  den(236) = den(36)*den(193)
  den(237) = den(25)**2
  den(238) = den(11)*den(237)
  den(239) = den(21)*den(237)
  den(240) = den(21)*den(134)
  den(241) = den(11)*den(36)
  den(242) = den(166)*den(193)
  den(243) = den(39)*den(193)
  den(244) = den(17)**2
  den(245) = den(11)*den(244)
  den(246) = den(30)*den(166)
  den(247) = den(11)*den(39)
  den(248) = den(30)*den(244)
  den(249) = den(169)*den(193)
  den(250) = den(43)*den(193)
  den(251) = den(30)*den(169)
  den(252) = den(21)*den(43)
  den(253) = den(7)**2
  den(254) = den(21)*den(253)
  den(255) = den(30)*den(253)
  den(256) = den(4)*den(7)
  den(258) = den(256)*den(257)
  den(259) = den(45)*den(258)
  den(260) = den(7)*den(45)
  den(261) = den(140)*den(260)
  den(262) = den(4)*den(261)
  den(263) = den(46)*den(190)
  den(264) = den(7)*den(263)
  den(265) = den(45)**2
  den(266) = den(138)*den(265)
  den(267) = den(52)*den(265)
  den(268) = den(4)**2
  den(269) = den(136)*den(268)
  den(270) = den(49)*den(268)
  den(271) = den(49)*den(138)
  den(272) = den(52)*den(136)
  den(273) = den(4)*den(17)
  den(275) = den(273)*den(274)
  den(276) = den(54)*den(275)
  den(277) = den(17)*den(54)
  den(278) = den(140)*den(277)
  den(279) = den(4)*den(278)
  den(280) = den(55)*den(208)
  den(281) = den(17)*den(280)
  den(282) = den(54)**2
  den(283) = den(138)*den(282)
  den(284) = den(60)*den(282)
  den(285) = den(144)*den(268)
  den(286) = den(57)*den(268)
  den(287) = den(57)*den(138)
  den(288) = den(60)*den(144)
  den(289) = den(4)*den(26)
  den(291) = den(289)*den(290)
  den(292) = den(62)*den(291)
  den(293) = den(26)*den(62)
  den(294) = den(140)*den(293)
  den(295) = den(4)*den(294)
  den(296) = den(63)*den(225)
  den(297) = den(26)*den(296)
  den(298) = den(163)*den(268)
  den(299) = den(138)*den(230)
  den(300) = den(65)*den(163)
  den(301) = den(67)*den(138)
  den(302) = den(67)*den(268)
  den(303) = den(65)*den(230)
  den(304) = den(62)**2
  den(305) = den(52)*den(304)
  den(306) = den(60)*den(304)
  den(307) = den(147)*den(268)
  den(308) = den(70)*den(268)
  den(309) = den(52)*den(70)
  den(310) = den(60)*den(147)
  den(311) = den(166)*den(268)
  den(312) = den(52)*den(244)
  den(313) = den(65)*den(166)
  den(314) = den(52)*den(74)
  den(315) = den(74)*den(268)
  den(316) = den(65)*den(244)
  den(317) = den(169)*den(268)
  den(318) = den(65)*den(169)
  den(319) = den(60)*den(78)
  den(320) = den(60)*den(253)
  den(321) = den(78)*den(268)
  den(322) = den(65)*den(253)
  den(323) = den(131)*den(265)
  den(324) = den(82)*den(265)
  den(325) = den(136)*den(213)
  den(326) = den(80)*den(213)
  den(327) = den(80)*den(131)
  den(328) = den(82)*den(136)
  den(329) = den(134)*den(265)
  den(330) = den(86)*den(265)
  den(331) = den(49)*den(237)
  den(332) = den(80)*den(237)
  den(333) = den(80)*den(134)
  den(334) = den(49)*den(86)
  den(335) = den(43)*den(265)
  den(336) = den(43)*den(80)
  den(337) = den(80)*den(253)
  den(338) = den(124)*den(282)
  den(339) = den(91)*den(282)
  den(340) = den(144)*den(196)
  den(341) = den(89)*den(196)
  den(342) = den(89)*den(124)
  den(343) = den(91)*den(144)
  den(344) = den(14)*den(304)
  den(345) = den(91)*den(304)
  den(346) = den(147)*den(196)
  den(347) = den(94)*den(196)
  den(348) = den(14)*den(94)
  den(349) = den(91)*den(147)
  den(350) = den(78)*den(91)
  den(351) = den(91)*den(253)
  den(352) = den(78)*den(196)
  den(353) = den(36)*den(282)
  den(354) = den(86)*den(282)
  den(355) = den(57)*den(237)
  den(356) = den(89)*den(237)
  den(357) = den(36)*den(89)
  den(358) = den(57)*den(86)
  den(359) = den(39)*den(282)
  den(360) = den(39)*den(89)
  den(361) = den(89)*den(244)
  den(362) = den(23)*den(304)
  den(363) = den(82)*den(304)
  den(364) = den(70)*den(213)
  den(365) = den(94)*den(213)
  den(366) = den(23)*den(94)
  den(367) = den(70)*den(82)
  den(368) = den(74)*den(82)
  den(369) = den(82)*den(244)
  den(370) = den(74)*den(213)
  den(371) = den(32)*den(304)
  den(372) = den(32)*den(94)
  den(373) = den(94)*den(230)
  den(374) = den(67)*den(86)
  den(375) = den(86)*den(230)
  den(376) = den(67)*den(237)
  den(378) = den(106)*den(377)
  den(380) = den(106)*den(379)
  den(382) = den(106)*den(381)
  den(384) = den(106)*den(383)
  den(385) = den(107)*den(381)
  den(387) = den(106)*den(386)
  den(388) = den(108)*den(379)
  den(390) = den(106)*den(389)
  den(391) = den(111)*den(377)
  den(392) = den(381)*den(390)
  den(393) = den(379)*den(390)
  den(394) = den(381)*den(387)
  den(395) = den(377)*den(387)
  den(396) = den(379)*den(384)
  den(397) = den(377)*den(384)
  den(398) = den(30)*den(190)
  den(399) = den(30)*den(208)
  den(400) = den(30)*den(225)
  den(401) = den(21)*den(190)
  den(402) = den(21)*den(222)
  den(403) = den(21)*den(205)
  den(404) = den(11)*den(208)
  den(405) = den(11)*den(222)
  den(406) = den(11)*den(187)
  den(407) = den(122)*den(225)
  den(408) = den(122)*den(205)
  den(409) = den(122)*den(187)
  den(410) = den(65)*den(190)
  den(411) = den(65)*den(208)
  den(412) = den(65)*den(225)
  den(413) = den(60)*den(190)
  den(414) = den(52)*den(208)
  den(415) = den(138)*den(225)
  den(416) = den(60)*den(290)
  den(417) = den(60)*den(274)
  den(418) = den(52)*den(290)
  den(419) = den(52)*den(257)
  den(420) = den(138)*den(274)
  den(421) = den(138)*den(257)
  den(422) = den(16)*den(45)
  den(423) = den(381)*den(422)
  den(424) = den(25)*den(45)
  den(425) = den(379)*den(424)
  den(426) = den(45)*den(389)
  den(427) = den(381)*den(426)
  den(428) = den(379)*den(426)
  den(429) = den(80)*den(190)
  den(430) = den(80)*den(222)
  den(431) = den(80)*den(205)
  den(432) = den(49)*den(381)
  den(433) = den(49)*den(222)
  den(434) = den(49)*den(140)
  den(435) = den(136)*den(379)
  den(436) = den(136)*den(205)
  den(437) = den(136)*den(140)
  den(438) = den(6)*den(54)
  den(439) = den(381)*den(438)
  den(440) = den(6)*den(62)
  den(441) = den(379)*den(440)
  den(442) = den(6)*den(389)
  den(443) = den(381)*den(442)
  den(444) = den(379)*den(442)
  den(445) = den(91)*den(190)
  den(446) = den(14)*den(381)
  den(447) = den(124)*den(379)
  den(448) = den(91)*den(290)
  den(449) = den(91)*den(274)
  den(450) = den(14)*den(290)
  den(451) = den(14)*den(126)
  den(452) = den(124)*den(274)
  den(453) = den(124)*den(126)
  den(454) = den(25)*den(54)
  den(455) = den(377)*den(454)
  den(456) = den(54)*den(386)
  den(457) = den(381)*den(456)
  den(458) = den(377)*den(456)
  den(459) = den(89)*den(208)
  den(460) = den(89)*den(222)
  den(461) = den(89)*den(187)
  den(462) = den(57)*den(381)
  den(463) = den(57)*den(222)
  den(464) = den(57)*den(140)
  den(465) = den(144)*den(377)
  den(466) = den(144)*den(187)
  den(467) = den(140)*den(144)
  den(468) = den(16)*den(62)
  den(469) = den(377)*den(468)
  den(470) = den(16)*den(386)
  den(471) = den(381)*den(470)
  den(472) = den(377)*den(470)
  den(473) = den(82)*den(208)
  den(474) = den(23)*den(381)
  den(475) = den(131)*den(377)
  den(476) = den(82)*den(290)
  den(477) = den(82)*den(257)
  den(478) = den(23)*den(290)
  den(479) = den(23)*den(126)
  den(480) = den(131)*den(257)
  den(481) = den(126)*den(131)
  den(482) = den(62)*den(383)
  den(483) = den(25)*den(383)
  den(484) = den(67)*den(381)
  den(485) = den(32)*den(381)
  den(486) = den(67)*den(222)
  den(487) = den(67)*den(140)
  den(488) = den(140)*den(163)
  den(489) = den(32)*den(290)
  den(490) = den(32)*den(126)
  den(491) = den(126)*den(163)
  den(492) = den(379)*den(482)
  den(493) = den(377)*den(482)
  den(494) = den(94)*den(225)
  den(495) = den(94)*den(205)
  den(496) = den(94)*den(187)
  den(497) = den(70)*den(379)
  den(498) = den(70)*den(205)
  den(499) = den(70)*den(140)
  den(500) = den(147)*den(377)
  den(501) = den(147)*den(187)
  den(502) = den(140)*den(147)
  den(503) = den(379)*den(483)
  den(504) = den(377)*den(483)
  den(505) = den(86)*den(225)
  den(506) = den(36)*den(379)
  den(507) = den(134)*den(377)
  den(508) = den(86)*den(274)
  den(509) = den(86)*den(257)
  den(510) = den(36)*den(274)
  den(511) = den(36)*den(126)
  den(512) = den(134)*den(257)
  den(513) = den(126)*den(134)
  den(514) = den(74)*den(379)
  den(515) = den(39)*den(379)
  den(516) = den(74)*den(205)
  den(517) = den(74)*den(140)
  den(518) = den(140)*den(166)
  den(519) = den(39)*den(274)
  den(520) = den(39)*den(126)
  den(521) = den(126)*den(166)
  den(522) = den(78)*den(377)
  den(523) = den(43)*den(377)
  den(524) = den(78)*den(187)
  den(525) = den(78)*den(140)
  den(526) = den(140)*den(169)
  den(527) = den(43)*den(257)
  den(528) = den(43)*den(126)
  den(529) = den(126)*den(169)
  den(530) = den(2)*den(106)
  den(531) = den(26)*den(384)
  den(532) = den(106)*den(163)
  den(533) = den(17)*den(387)
  den(534) = den(106)*den(166)
  den(535) = den(7)*den(390)
  den(536) = den(106)*den(169)
  den(537) = den(1)*den(6)*den(7)
  den(538) = den(1)*den(16)*den(17)
  den(539) = den(1)*den(25)*den(26)
  den(540) = den(4)*den(7)*den(45)
  den(541) = den(4)*den(17)*den(54)
  den(542) = den(4)*den(26)*den(62)
  den(543) = den(7)*den(426)
  den(544) = den(7)*den(442)
  den(545) = den(17)*den(456)
  den(546) = den(17)*den(470)
  den(547) = den(26)*den(482)
  den(548) = den(26)*den(483)
  den(549) = den(6)*den(406)
  den(550) = den(6)*den(409)
  den(551) = den(1)*den(451)
  den(552) = den(1)*den(453)
  den(553) = den(16)*den(403)
  den(554) = den(16)*den(408)
  den(555) = den(1)*den(479)
  den(556) = den(1)*den(481)
  den(557) = den(26)*den(400)
  den(558) = den(26)*den(407)
  den(559) = den(1)*den(490)
  den(560) = den(1)*den(491)
  den(561) = den(25)*den(402)
  den(562) = den(25)*den(405)
  den(563) = den(1)*den(511)
  den(564) = den(1)*den(513)
  den(565) = den(17)*den(399)
  den(566) = den(17)*den(404)
  den(567) = den(1)*den(520)
  den(568) = den(1)*den(521)
  den(569) = den(7)*den(398)
  den(570) = den(7)*den(401)
  den(571) = den(1)*den(528)
  den(572) = den(1)*den(529)
  den(573) = den(4)*den(434)
  den(574) = den(4)*den(437)
  den(575) = den(45)*den(419)
  den(576) = den(45)*den(421)
  den(577) = den(4)*den(464)
  den(578) = den(4)*den(467)
  den(579) = den(54)*den(417)
  den(580) = den(54)*den(420)
  den(581) = den(26)*den(412)
  den(582) = den(4)*den(487)
  den(583) = den(26)*den(415)
  den(584) = den(4)*den(488)
  den(585) = den(4)*den(499)
  den(586) = den(4)*den(502)
  den(587) = den(62)*den(416)
  den(588) = den(62)*den(418)
  den(589) = den(17)*den(411)
  den(590) = den(4)*den(517)
  den(591) = den(17)*den(414)
  den(592) = den(4)*den(518)
  den(593) = den(7)*den(410)
  den(594) = den(4)*den(525)
  den(595) = den(7)*den(413)
  den(596) = den(4)*den(526)
  den(597) = den(16)*den(431)
  den(598) = den(16)*den(436)
  den(599) = den(45)*den(477)
  den(600) = den(45)*den(480)
  den(601) = den(25)*den(430)
  den(602) = den(25)*den(433)
  den(603) = den(45)*den(509)
  den(604) = den(45)*den(512)
  den(605) = den(7)*den(429)
  den(606) = den(45)*den(527)
  den(607) = den(6)*den(461)
  den(608) = den(6)*den(466)
  den(609) = den(54)*den(449)
  den(610) = den(54)*den(452)
  den(611) = den(6)*den(496)
  den(612) = den(6)*den(501)
  den(613) = den(62)*den(448)
  den(614) = den(62)*den(450)
  den(615) = den(6)*den(524)
  den(616) = den(7)*den(445)
  den(617) = den(25)*den(460)
  den(618) = den(25)*den(463)
  den(619) = den(54)*den(508)
  den(620) = den(54)*den(510)
  den(621) = den(17)*den(459)
  den(622) = den(54)*den(519)
  den(623) = den(16)*den(495)
  den(624) = den(16)*den(498)
  den(625) = den(62)*den(476)
  den(626) = den(62)*den(478)
  den(627) = den(16)*den(516)
  den(628) = den(17)*den(473)
  den(629) = den(26)*den(494)
  den(630) = den(62)*den(489)
  den(631) = den(25)*den(486)
  den(632) = den(26)*den(505)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppattj_ttxaggg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top gamma glue glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppattj_ttxaggg_1, only: external_perm_ppattj_ttxaggg_1, &
    & external_perm_inv_ppattj_ttxaggg_1, extcomb_perm_ppattj_ttxaggg_1, &
    & average_factor_ppattj_ttxaggg_1
  use ol_external_ppattj_ttxaggg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppattj_ttxaggg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppattj_ttxaggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(6), M2(11)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,64)
  type(Hpolcont) :: M1helarray_ct(11,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs, ind_cc_comb(9)

  type(Hpolcont) :: A(64,450)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(450)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppattj_ttxaggg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_GGG_G(ntry, ex4(:), ex5(:), ex6(:), wf8(:,1), n4(:,1), t4x8(:,:,1))
  call prop_Q_A(ntry, wf4(:,1), 5, MT, 1_intkind1, wf4(:,2), n2(1))
  call vert_QA_V(ntry, wf4(:,2), ex2(:), wf8(:,2), n3(:,2), t3x8(:,:,1))
  call vert_GGG_G(ntry, ex5(:), ex6(:), ex4(:), wf8(:,3), n4(:,2), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex6(:), ex4(:), ex5(:), wf8(:,4), n4(:,3), t4x8(:,:,3))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,3), n3(:,3), t3x4(:,:,2))
  call prop_A_Q(ntry, wf4(:,3), 6, MT, 1_intkind1, wf4(:,4), n2(2))
  call vert_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,5), n3(:,4), t3x8(:,:,2))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,5), n3(:,5), t3x4(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,6), n3(:,6), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,5), 10, MT, 1_intkind1, wf4(:,7), n2(3))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,7), wf16(:,1), n3(:,7), t3x16(:,:,1))
  call vert_VQ_A(ntry, ex5(:), wf4(:,2), wf8(:,6), n3(:,8), t3x8(:,:,3))
  call vert_AV_Q(ntry, wf4(:,7), ex6(:), wf8(:,7), n3(:,9), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,6), 21, MT, 1_intkind1, wf8(:,8), n2(4))
  call vert_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,9), n3(:,10), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex6(:), wf4(:,2), wf8(:,10), n3(:,11), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,9), 26, MT, 1_intkind1, wf8(:,11), n2(5))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,8), n3(:,12), t3x4(:,:,5))
  call vert_UV_W(ntry, ex4(:), 8, ex6(:), 32, wf4(:,9), n3(:,13), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,8), 18, MT, 1_intkind1, wf4(:,10), n2(6))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,10), wf16(:,2), n3(:,14), t3x16(:,:,2))
  call vert_VQ_A(ntry, ex4(:), wf4(:,2), wf8(:,12), n3(:,15), t3x8(:,:,7))
  call vert_AV_Q(ntry, wf4(:,10), ex6(:), wf8(:,13), n3(:,16), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,12), 13, MT, 1_intkind1, wf8(:,14), n2(7))
  call vert_AV_Q(ntry, wf4(:,10), ex4(:), wf8(:,15), n3(:,17), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,15), 26, MT, 1_intkind1, wf8(:,16), n2(8))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,11), n3(:,18), t3x4(:,:,7))
  call vert_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,12), n3(:,19), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,11), 34, MT, 1_intkind1, wf4(:,13), n2(9))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,13), wf16(:,3), n3(:,20), t3x16(:,:,3))
  call vert_UV_W(ntry, wf4(:,12), 24, ex6(:), 32, wf8(:,17), n3(:,21), t3x8(:,:,10))
  call vert_AV_Q(ntry, ex2(:), wf4(:,12), wf8(:,18), n3(:,22), t3x8(:,:,11))
  call prop_A_Q(ntry, wf8(:,18), 26, MT, 1_intkind1, wf8(:,19), n2(10))
  call vert_AV_Q(ntry, wf4(:,13), ex5(:), wf8(:,20), n3(:,23), t3x8(:,:,12))
  call vert_AV_Q(ntry, wf4(:,13), ex4(:), wf8(:,21), n3(:,24), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,21), 42, MT, 1_intkind1, wf8(:,22), n2(11))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,9), 40, wf8(:,23), n3(:,25), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex2(:), wf4(:,9), wf8(:,24), n3(:,26), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,24), 42, MT, 1_intkind1, wf8(:,25), n2(12))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,6), 48, wf8(:,26), n3(:,27), t3x8(:,:,16))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,27), n3(:,28), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,27), 50, MT, 1_intkind1, wf8(:,28), n2(13))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,14), n3(:,29), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,14), 9, MT, 1_intkind1, wf4(:,15), n2(14))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,4), wf16(:,4), n3(:,30), t3x16(:,:,4))
  call vert_VQ_A(ntry, ex5(:), wf4(:,15), wf8(:,29), n3(:,31), t3x8(:,:,18))
  call vert_AV_Q(ntry, wf4(:,4), ex6(:), wf8(:,30), n3(:,32), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,29), 25, MT, 1_intkind1, wf8(:,31), n2(15))
  call vert_AV_Q(ntry, wf4(:,4), ex5(:), wf8(:,32), n3(:,33), t3x8(:,:,20))
  call vert_VQ_A(ntry, ex6(:), wf4(:,15), wf8(:,33), n3(:,34), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,32), 22, MT, 1_intkind1, wf8(:,34), n2(16))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,16), n3(:,35), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,16), 17, MT, 1_intkind1, wf4(:,17), n2(17))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,4), wf16(:,5), n3(:,36), t3x16(:,:,5))
  call vert_VQ_A(ntry, ex4(:), wf4(:,17), wf8(:,35), n3(:,37), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,35), 25, MT, 1_intkind1, wf8(:,36), n2(18))
  call vert_AV_Q(ntry, wf4(:,4), ex4(:), wf8(:,37), n3(:,38), t3x8(:,:,23))
  call vert_VQ_A(ntry, ex6(:), wf4(:,17), wf8(:,38), n3(:,39), t3x8(:,:,24))
  call prop_A_Q(ntry, wf8(:,37), 14, MT, 1_intkind1, wf8(:,39), n2(19))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,18), n3(:,40), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,18), 33, MT, 1_intkind1, wf4(:,19), n2(20))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,4), wf16(:,6), n3(:,41), t3x16(:,:,6))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,40), n3(:,42), t3x8(:,:,25))
  call prop_Q_A(ntry, wf8(:,40), 25, MT, 1_intkind1, wf8(:,41), n2(21))
  call vert_VQ_A(ntry, ex4(:), wf4(:,19), wf8(:,42), n3(:,43), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,42), 41, MT, 1_intkind1, wf8(:,43), n2(22))
  call vert_VQ_A(ntry, ex5(:), wf4(:,19), wf8(:,44), n3(:,44), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,45), n3(:,45), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,45), 41, MT, 1_intkind1, wf8(:,46), n2(23))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,47), n3(:,46), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,47), 49, MT, 1_intkind1, wf8(:,48), n2(24))
  call vert_VQ_A(ntry, ex3(:), wf4(:,15), wf8(:,49), n3(:,47), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,49), 13, MT, 1_intkind1, wf8(:,50), n2(25))
  call vert_AV_Q(ntry, wf4(:,10), ex3(:), wf8(:,51), n3(:,48), t3x8(:,:,31))
  call prop_A_Q(ntry, wf8(:,51), 22, MT, 1_intkind1, wf8(:,52), n2(26))
  call vert_AV_Q(ntry, wf4(:,13), ex3(:), wf8(:,53), n3(:,49), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,53), 38, MT, 1_intkind1, wf8(:,54), n2(27))
  call vert_VQ_A(ntry, ex3(:), wf4(:,17), wf8(:,55), n3(:,50), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,55), 21, MT, 1_intkind1, wf8(:,56), n2(28))
  call vert_AV_Q(ntry, wf4(:,7), ex3(:), wf8(:,57), n3(:,51), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,57), 14, MT, 1_intkind1, wf8(:,58), n2(29))
  call vert_VQ_A(ntry, ex3(:), wf4(:,19), wf8(:,59), n3(:,52), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,59), 37, MT, 1_intkind1, wf8(:,60), n2(30))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,20), n3(:,53), t3x4(:,:,12))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), wf4(:,20), ex6(:), wf16(:,7), n4(:,4), t4x16(:,:,1))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex6(:), wf4(:,20), wf16(:,8), n4(:,5), t4x16(:,:,2))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), wf4(:,20), ex5(:), wf16(:,9), n4(:,6), t4x16(:,:,3))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex5(:), wf4(:,20), wf16(:,10), n4(:,7), t4x16(:,:,4))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex5(:), ex6(:), wf8(:,61), n4(:,8), t4x8(:,:,4))
  call vert_UV_W(ntry, wf4(:,20), 3, ex4(:), 8, wf8(:,62), n3(:,54), t3x8(:,:,36))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex6(:), ex5(:), wf8(:,63), n4(:,9), t4x8(:,:,5))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), wf4(:,20), ex4(:), wf16(:,11), n4(:,10), t4x16(:,:,5))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex4(:), wf4(:,20), wf16(:,12), n4(:,11), t4x16(:,:,6))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex4(:), ex6(:), wf8(:,64), n4(:,12), t4x8(:,:,6))
  call vert_UV_W(ntry, wf4(:,20), 3, ex5(:), 16, wf8(:,65), n3(:,55), t3x8(:,:,37))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex6(:), ex4(:), wf8(:,66), n4(:,13), t4x8(:,:,7))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex4(:), ex5(:), wf8(:,67), n4(:,14), t4x8(:,:,8))
  call vert_UV_W(ntry, wf4(:,20), 3, ex6(:), 32, wf8(:,68), n3(:,56), t3x8(:,:,38))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex5(:), ex4(:), wf8(:,69), n4(:,15), t4x8(:,:,9))
  call counter_GGG_G(ntry, ex4(:), ex5(:), ex6(:), wf8(:,70), n4(:,16), t4x8(:,:,10))
  call counter_GGG_G(ntry, ex5(:), ex6(:), ex4(:), wf8(:,71), n4(:,17), t4x8(:,:,11))
  call counter_GGG_G(ntry, ex6(:), ex4(:), ex5(:), wf8(:,72), n4(:,18), t4x8(:,:,12))
  call vert_QA_V(ntry, wf4(:,15), ex2(:), wf8(:,73), n3(:,57), t3x8(:,:,39))
  call vert_QA_V(ntry, ex1(:), wf4(:,7), wf8(:,74), n3(:,58), t3x8(:,:,40))
  call vert_QA_V(ntry, wf4(:,17), ex2(:), wf8(:,75), n3(:,59), t3x8(:,:,41))
  call vert_QA_V(ntry, ex1(:), wf4(:,10), wf8(:,76), n3(:,60), t3x8(:,:,42))
  call vert_QA_V(ntry, wf4(:,19), ex2(:), wf8(:,77), n3(:,61), t3x8(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf4(:,13), wf8(:,78), n3(:,62), t3x8(:,:,44))
  call counter_QA_V(ntry, wf4(:,2), ex2(:), wf8(:,79), n3(:,63), t3x8(:,:,45))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,21), n3(:,64), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,21), 6, MT, 1_intkind1, wf4(:,22), n2(31))
  call vert_QA_V(ntry, ex1(:), wf4(:,22), wf8(:,80), n3(:,65), t3x8(:,:,46))
  call counter_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,81), n3(:,66), t3x8(:,:,47))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,23), n3(:,67), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,23), 5, MT, 1_intkind1, wf4(:,24), n2(32))
  call vert_QA_V(ntry, wf4(:,24), ex2(:), wf8(:,82), n3(:,68), t3x8(:,:,48))
  call counter_QA_V(ntry, wf4(:,2), wf4(:,7), wf16(:,13), n3(:,69), t3x16(:,:,7))
  call counter_AV_Q(ntry, wf4(:,7), ex6(:), wf8(:,83), n3(:,70), t3x8(:,:,49))
  call counter_VQ_A(ntry, ex6(:), wf4(:,2), wf8(:,84), n3(:,71), t3x8(:,:,50))
  call counter_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,85), n3(:,72), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,10), 37, MT, 1_intkind1, wf8(:,86), n2(33))
  call counter_VQ_A(ntry, ex5(:), wf4(:,2), wf8(:,87), n3(:,73), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,7), 42, MT, 1_intkind1, wf8(:,88), n2(34))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,25), n3(:,74), t3x4(:,:,15))
  call counter_QA_V(ntry, wf4(:,2), wf4(:,10), wf16(:,14), n3(:,75), t3x16(:,:,8))
  call counter_AV_Q(ntry, wf4(:,10), ex6(:), wf8(:,89), n3(:,76), t3x8(:,:,53))
  call counter_QA_V(ntry, wf4(:,2), wf4(:,13), wf16(:,15), n3(:,77), t3x16(:,:,9))
  call counter_UV_W(ntry, wf4(:,12), 24, ex6(:), 32, wf8(:,90), n3(:,78), t3x8(:,:,54))
  call counter_AV_Q(ntry, wf4(:,13), ex5(:), wf8(:,91), n3(:,79), t3x8(:,:,55))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,9), 40, wf8(:,92), n3(:,80), t3x8(:,:,56))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,25), 48, wf8(:,93), n3(:,81), t3x8(:,:,57))
  call vert_AV_Q(ntry, ex2(:), wf4(:,25), wf8(:,94), n3(:,82), t3x8(:,:,58))
  call prop_A_Q(ntry, wf8(:,94), 50, MT, 1_intkind1, wf8(:,95), n2(35))
  call vert_AV_Q(ntry, ex2(:), wf8(:,1), wf16(:,16), n3(:,83), t3x16(:,:,10))
  call counter_Q_A(cttt,6,ntry, wf4(:,2), 5, wf4(:,26), n2(36))
  call prop_A_Q(ntry, wf16(:,16), 58, MT, 1_intkind1, wf16(:,17), n2(37))
  call vert_AV_Q(ntry, ex2(:), wf8(:,3), wf16(:,18), n3(:,84), t3x16(:,:,11))
  call prop_A_Q(ntry, wf16(:,18), 58, MT, 1_intkind1, wf16(:,19), n2(38))
  call vert_AV_Q(ntry, ex2(:), wf8(:,4), wf16(:,20), n3(:,85), t3x16(:,:,12))
  call prop_A_Q(ntry, wf16(:,20), 58, MT, 1_intkind1, wf16(:,21), n2(39))
  call counter_V_V(ctGG,21,ntry, wf8(:,1), 56, wf8(:,96), n2(40))
  call counter_V_V(ctGG,21,ntry, wf8(:,3), 56, wf8(:,97), n2(41))
  call counter_V_V(ctGG,21,ntry, wf8(:,4), 56, wf8(:,98), n2(42))
  call counter_AV_Q(ntry, wf4(:,10), ex4(:), wf8(:,99), n3(:,86), t3x8(:,:,59))
  call counter_VQ_A(ntry, ex4(:), wf4(:,2), wf8(:,100), n3(:,87), t3x8(:,:,60))
  call prop_A_Q(ntry, wf8(:,13), 50, MT, 1_intkind1, wf8(:,101), n2(43))
  call counter_UV_W(ntry, ex4(:), 8, ex6(:), 32, wf4(:,27), n3(:,88), t3x4(:,:,16))
  call counter_AV_Q(ntry, wf4(:,13), ex4(:), wf8(:,102), n3(:,89), t3x8(:,:,61))
  call prop_A_Q(ntry, wf8(:,20), 50, MT, 1_intkind1, wf8(:,103), n2(44))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,6), 48, wf8(:,104), n3(:,90), t3x8(:,:,62))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,27), 40, wf8(:,105), n3(:,91), t3x8(:,:,63))
  call vert_AV_Q(ntry, ex2(:), wf4(:,27), wf8(:,106), n3(:,92), t3x8(:,:,64))
  call prop_A_Q(ntry, wf8(:,106), 42, MT, 1_intkind1, wf8(:,107), n2(45))
  call counter_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,28), n3(:,93), t3x4(:,:,17))
  call vert_UV_W(ntry, wf4(:,28), 24, ex6(:), 32, wf8(:,108), n3(:,94), t3x8(:,:,65))
  call vert_AV_Q(ntry, ex2(:), wf4(:,28), wf8(:,109), n3(:,95), t3x8(:,:,66))
  call prop_A_Q(ntry, wf8(:,109), 26, MT, 1_intkind1, wf8(:,110), n2(46))
  call counter_QA_V(ntry, wf4(:,15), wf4(:,4), wf16(:,22), n3(:,96), t3x16(:,:,13))
  call counter_AV_Q(ntry, wf4(:,4), ex6(:), wf8(:,111), n3(:,97), t3x8(:,:,67))
  call counter_VQ_A(ntry, ex6(:), wf4(:,15), wf8(:,112), n3(:,98), t3x8(:,:,68))
  call counter_AV_Q(ntry, wf4(:,4), ex5(:), wf8(:,113), n3(:,99), t3x8(:,:,69))
  call prop_Q_A(ntry, wf8(:,33), 41, MT, 1_intkind1, wf8(:,114), n2(47))
  call counter_VQ_A(ntry, ex5(:), wf4(:,15), wf8(:,115), n3(:,100), t3x8(:,:,70))
  call prop_A_Q(ntry, wf8(:,30), 38, MT, 1_intkind1, wf8(:,116), n2(48))
  call counter_QA_V(ntry, wf4(:,17), wf4(:,4), wf16(:,23), n3(:,101), t3x16(:,:,14))
  call counter_VQ_A(ntry, ex6(:), wf4(:,17), wf8(:,117), n3(:,102), t3x8(:,:,71))
  call counter_QA_V(ntry, wf4(:,19), wf4(:,4), wf16(:,24), n3(:,103), t3x16(:,:,15))
  call counter_VQ_A(ntry, ex5(:), wf4(:,19), wf8(:,118), n3(:,104), t3x8(:,:,72))
  call vert_VQ_A(ntry, wf4(:,25), ex1(:), wf8(:,119), n3(:,105), t3x8(:,:,73))
  call prop_Q_A(ntry, wf8(:,119), 49, MT, 1_intkind1, wf8(:,120), n2(49))
  call vert_VQ_A(ntry, wf8(:,1), ex1(:), wf16(:,25), n3(:,106), t3x16(:,:,16))
  call counter_A_Q(cttt,6,ntry, wf4(:,4), 6, wf4(:,29), n2(50))
  call prop_Q_A(ntry, wf16(:,25), 57, MT, 1_intkind1, wf16(:,26), n2(51))
  call vert_VQ_A(ntry, wf8(:,3), ex1(:), wf16(:,27), n3(:,107), t3x16(:,:,17))
  call prop_Q_A(ntry, wf16(:,27), 57, MT, 1_intkind1, wf16(:,28), n2(52))
  call vert_VQ_A(ntry, wf8(:,4), ex1(:), wf16(:,29), n3(:,108), t3x16(:,:,18))
  call prop_Q_A(ntry, wf16(:,29), 57, MT, 1_intkind1, wf16(:,30), n2(53))
  call counter_AV_Q(ntry, wf4(:,4), ex4(:), wf8(:,121), n3(:,109), t3x8(:,:,74))
  call prop_Q_A(ntry, wf8(:,38), 49, MT, 1_intkind1, wf8(:,122), n2(54))
  call counter_VQ_A(ntry, ex4(:), wf4(:,17), wf8(:,123), n3(:,110), t3x8(:,:,75))
  call prop_Q_A(ntry, wf8(:,44), 49, MT, 1_intkind1, wf8(:,124), n2(55))
  call counter_VQ_A(ntry, ex4(:), wf4(:,19), wf8(:,125), n3(:,111), t3x8(:,:,76))
  call vert_VQ_A(ntry, wf4(:,27), ex1(:), wf8(:,126), n3(:,112), t3x8(:,:,77))
  call prop_Q_A(ntry, wf8(:,126), 41, MT, 1_intkind1, wf8(:,127), n2(56))
  call vert_VQ_A(ntry, wf4(:,28), ex1(:), wf8(:,128), n3(:,113), t3x8(:,:,78))
  call prop_Q_A(ntry, wf8(:,128), 25, MT, 1_intkind1, wf8(:,129), n2(57))
  call counter_AV_Q(ntry, wf4(:,10), ex3(:), wf8(:,130), n3(:,114), t3x8(:,:,79))
  call counter_VQ_A(ntry, ex3(:), wf4(:,15), wf8(:,131), n3(:,115), t3x8(:,:,80))
  call counter_AV_Q(ntry, wf4(:,13), ex3(:), wf8(:,132), n3(:,116), t3x8(:,:,81))
  call counter_AV_Q(ntry, wf4(:,7), ex3(:), wf8(:,133), n3(:,117), t3x8(:,:,82))
  call counter_VQ_A(ntry, ex3(:), wf4(:,17), wf8(:,134), n3(:,118), t3x8(:,:,83))
  call counter_VQ_A(ntry, ex3(:), wf4(:,19), wf8(:,135), n3(:,119), t3x8(:,:,84))
  call counter_AV_Q(ntry, ex2(:), wf4(:,12), wf8(:,136), n3(:,120), t3x8(:,:,85))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,30), n3(:,121), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,30), 34, MT, 1_intkind1, wf4(:,31), n2(58))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,31), wf16(:,31), n3(:,122), t3x16(:,:,19))
  call counter_AV_Q(ntry, ex2(:), wf4(:,9), wf8(:,137), n3(:,123), t3x8(:,:,86))
  call counter_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,138), n3(:,124), t3x8(:,:,87))
  call vert_AV_Q(ntry, wf4(:,31), ex5(:), wf8(:,139), n3(:,125), t3x8(:,:,88))
  call vert_AV_Q(ntry, wf4(:,31), ex4(:), wf8(:,140), n3(:,126), t3x8(:,:,89))
  call prop_A_Q(ntry, wf8(:,140), 42, MT, 1_intkind1, wf8(:,141), n2(59))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,32), n3(:,127), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,32), 18, MT, 1_intkind1, wf4(:,33), n2(60))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,33), wf16(:,32), n3(:,128), t3x16(:,:,20))
  call vert_AV_Q(ntry, wf4(:,33), ex6(:), wf8(:,142), n3(:,129), t3x8(:,:,90))
  call vert_AV_Q(ntry, wf4(:,33), ex4(:), wf8(:,143), n3(:,130), t3x8(:,:,91))
  call prop_A_Q(ntry, wf8(:,143), 26, MT, 1_intkind1, wf8(:,144), n2(61))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,34), n3(:,131), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,34), 10, MT, 1_intkind1, wf4(:,35), n2(62))
  call vert_QA_V(ntry, wf4(:,2), wf4(:,35), wf16(:,33), n3(:,132), t3x16(:,:,21))
  call vert_AV_Q(ntry, wf4(:,35), ex6(:), wf8(:,145), n3(:,133), t3x8(:,:,92))
  call vert_AV_Q(ntry, wf4(:,35), ex5(:), wf8(:,146), n3(:,134), t3x8(:,:,93))
  call prop_A_Q(ntry, wf8(:,146), 26, MT, 1_intkind1, wf8(:,147), n2(63))
  call vert_AV_Q(ntry, wf4(:,31), ex3(:), wf8(:,148), n3(:,135), t3x8(:,:,94))
  call prop_A_Q(ntry, wf8(:,148), 38, MT, 1_intkind1, wf8(:,149), n2(64))
  call vert_AV_Q(ntry, wf4(:,33), ex3(:), wf8(:,150), n3(:,136), t3x8(:,:,95))
  call prop_A_Q(ntry, wf8(:,150), 22, MT, 1_intkind1, wf8(:,151), n2(65))
  call vert_AV_Q(ntry, wf4(:,35), ex3(:), wf8(:,152), n3(:,137), t3x8(:,:,96))
  call prop_A_Q(ntry, wf8(:,152), 14, MT, 1_intkind1, wf8(:,153), n2(66))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,22), wf16(:,34), n3(:,138), t3x16(:,:,22))
  call vert_AV_Q(ntry, wf4(:,22), ex6(:), wf8(:,154), n3(:,139), t3x8(:,:,97))
  call vert_AV_Q(ntry, wf4(:,22), ex5(:), wf8(:,155), n3(:,140), t3x8(:,:,98))
  call prop_A_Q(ntry, wf8(:,155), 22, MT, 1_intkind1, wf8(:,156), n2(67))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,22), wf16(:,35), n3(:,141), t3x16(:,:,23))
  call vert_AV_Q(ntry, wf4(:,22), ex4(:), wf8(:,157), n3(:,142), t3x8(:,:,99))
  call prop_A_Q(ntry, wf8(:,157), 14, MT, 1_intkind1, wf8(:,158), n2(68))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,22), wf16(:,36), n3(:,143), t3x16(:,:,24))
  call counter_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,159), n3(:,144), t3x8(:,:,100))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,36), n3(:,145), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,36), 33, MT, 1_intkind1, wf4(:,37), n2(69))
  call vert_QA_V(ntry, wf4(:,37), wf4(:,4), wf16(:,37), n3(:,146), t3x16(:,:,25))
  call counter_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,160), n3(:,147), t3x8(:,:,101))
  call counter_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,161), n3(:,148), t3x8(:,:,102))
  call vert_VQ_A(ntry, ex4(:), wf4(:,37), wf8(:,162), n3(:,149), t3x8(:,:,103))
  call prop_Q_A(ntry, wf8(:,162), 41, MT, 1_intkind1, wf8(:,163), n2(70))
  call vert_VQ_A(ntry, ex5(:), wf4(:,37), wf8(:,164), n3(:,150), t3x8(:,:,104))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,38), n3(:,151), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,38), 17, MT, 1_intkind1, wf4(:,39), n2(71))
  call vert_QA_V(ntry, wf4(:,39), wf4(:,4), wf16(:,38), n3(:,152), t3x16(:,:,26))
  call vert_VQ_A(ntry, ex4(:), wf4(:,39), wf8(:,165), n3(:,153), t3x8(:,:,105))
  call prop_Q_A(ntry, wf8(:,165), 25, MT, 1_intkind1, wf8(:,166), n2(72))
  call vert_VQ_A(ntry, ex6(:), wf4(:,39), wf8(:,167), n3(:,154), t3x8(:,:,106))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,40), n3(:,155), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,40), 9, MT, 1_intkind1, wf4(:,41), n2(73))
  call vert_QA_V(ntry, wf4(:,41), wf4(:,4), wf16(:,39), n3(:,156), t3x16(:,:,27))
  call vert_VQ_A(ntry, ex5(:), wf4(:,41), wf8(:,168), n3(:,157), t3x8(:,:,107))
  call prop_Q_A(ntry, wf8(:,168), 25, MT, 1_intkind1, wf8(:,169), n2(74))
  call vert_VQ_A(ntry, ex6(:), wf4(:,41), wf8(:,170), n3(:,158), t3x8(:,:,108))
  call vert_VQ_A(ntry, ex3(:), wf4(:,37), wf8(:,171), n3(:,159), t3x8(:,:,109))
  call prop_Q_A(ntry, wf8(:,171), 37, MT, 1_intkind1, wf8(:,172), n2(75))
  call vert_VQ_A(ntry, ex3(:), wf4(:,39), wf8(:,173), n3(:,160), t3x8(:,:,110))
  call prop_Q_A(ntry, wf8(:,173), 21, MT, 1_intkind1, wf8(:,174), n2(76))
  call vert_VQ_A(ntry, ex3(:), wf4(:,41), wf8(:,175), n3(:,161), t3x8(:,:,111))
  call prop_Q_A(ntry, wf8(:,175), 13, MT, 1_intkind1, wf8(:,176), n2(77))
  call vert_QA_V(ntry, wf4(:,24), wf4(:,7), wf16(:,40), n3(:,162), t3x16(:,:,28))
  call vert_VQ_A(ntry, ex5(:), wf4(:,24), wf8(:,177), n3(:,163), t3x8(:,:,112))
  call prop_Q_A(ntry, wf8(:,177), 21, MT, 1_intkind1, wf8(:,178), n2(78))
  call vert_VQ_A(ntry, ex6(:), wf4(:,24), wf8(:,179), n3(:,164), t3x8(:,:,113))
  call vert_QA_V(ntry, wf4(:,24), wf4(:,10), wf16(:,41), n3(:,165), t3x16(:,:,29))
  call vert_VQ_A(ntry, ex4(:), wf4(:,24), wf8(:,180), n3(:,166), t3x8(:,:,114))
  call prop_Q_A(ntry, wf8(:,180), 13, MT, 1_intkind1, wf8(:,181), n2(79))
  call vert_QA_V(ntry, wf4(:,24), wf4(:,13), wf16(:,42), n3(:,167), t3x16(:,:,30))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,6), wf16(:,43), n3(:,168), t3x16(:,:,31))
  call prop_A_Q(ntry, wf16(:,43), 58, MT, 1_intkind1, wf16(:,44), n2(80))
  call vert_VQ_A(ntry, wf4(:,6), wf4(:,2), wf16(:,45), n3(:,169), t3x16(:,:,32))
  call counter_A_Q(cttt,6,ntry, wf4(:,7), 10, wf4(:,42), n2(81))
  call prop_Q_A(ntry, wf16(:,45), 53, MT, 1_intkind1, wf16(:,46), n2(82))
  call counter_V_V(ctGG,21,ntry, wf4(:,6), 48, wf4(:,43), n2(83))
  call prop_Q_A(ntry, wf4(:,26), 5, MT, 1_intkind1, wf4(:,44), n2(84))
  call vert_VQ_A(ntry, ex5(:), wf4(:,44), wf8(:,182), n3(:,170), t3x8(:,:,115))
  call vert_VQ_A(ntry, ex6(:), wf4(:,44), wf8(:,183), n3(:,171), t3x8(:,:,116))
  call prop_A_Q(ntry, wf4(:,42), 10, MT, 1_intkind1, wf4(:,45), n2(85))
  call vert_AV_Q(ntry, wf4(:,45), ex5(:), wf8(:,184), n3(:,172), t3x8(:,:,117))
  call vert_AV_Q(ntry, wf4(:,45), ex6(:), wf8(:,185), n3(:,173), t3x8(:,:,118))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 21, wf8(:,186), n2(86))
  call counter_A_Q(cttt,6,ntry, wf8(:,11), 26, wf8(:,187), n2(87))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,9), wf16(:,47), n3(:,174), t3x16(:,:,33))
  call prop_A_Q(ntry, wf16(:,47), 58, MT, 1_intkind1, wf16(:,48), n2(88))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,2), wf16(:,49), n3(:,175), t3x16(:,:,34))
  call counter_A_Q(cttt,6,ntry, wf4(:,10), 18, wf4(:,46), n2(89))
  call prop_Q_A(ntry, wf16(:,49), 45, MT, 1_intkind1, wf16(:,50), n2(90))
  call counter_V_V(ctGG,21,ntry, wf4(:,9), 40, wf4(:,47), n2(91))
  call vert_VQ_A(ntry, ex4(:), wf4(:,44), wf8(:,188), n3(:,176), t3x8(:,:,119))
  call prop_A_Q(ntry, wf4(:,46), 18, MT, 1_intkind1, wf4(:,48), n2(92))
  call vert_AV_Q(ntry, wf4(:,48), ex4(:), wf8(:,189), n3(:,177), t3x8(:,:,120))
  call vert_AV_Q(ntry, wf4(:,48), ex6(:), wf8(:,190), n3(:,178), t3x8(:,:,121))
  call counter_Q_A(cttt,6,ntry, wf8(:,14), 13, wf8(:,191), n2(93))
  call counter_A_Q(cttt,6,ntry, wf8(:,16), 26, wf8(:,192), n2(94))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,12), wf16(:,51), n3(:,179), t3x16(:,:,35))
  call prop_A_Q(ntry, wf16(:,51), 58, MT, 1_intkind1, wf16(:,52), n2(95))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,2), wf16(:,53), n3(:,180), t3x16(:,:,36))
  call counter_A_Q(cttt,6,ntry, wf4(:,13), 34, wf4(:,49), n2(96))
  call prop_Q_A(ntry, wf16(:,53), 29, MT, 1_intkind1, wf16(:,54), n2(97))
  call counter_V_V(ctGG,21,ntry, wf4(:,12), 24, wf4(:,50), n2(98))
  call vert_QA_V(ntry, wf4(:,44), ex2(:), wf8(:,193), n3(:,181), t3x8(:,:,122))
  call vert_AV_Q(ntry, ex2(:), wf4(:,50), wf8(:,194), n3(:,182), t3x8(:,:,123))
  call counter_V_V(ctGG,21,ntry, wf8(:,2), 7, wf8(:,195), n2(99))
  call counter_A_Q(cttt,6,ntry, wf8(:,19), 26, wf8(:,196), n2(100))
  call vert_UV_W(ntry, wf4(:,50), 24, ex6(:), 32, wf8(:,197), n3(:,183), t3x8(:,:,124))
  call prop_A_Q(ntry, wf4(:,49), 34, MT, 1_intkind1, wf4(:,51), n2(101))
  call vert_AV_Q(ntry, wf4(:,51), ex4(:), wf8(:,198), n3(:,184), t3x8(:,:,125))
  call vert_AV_Q(ntry, wf4(:,51), ex5(:), wf8(:,199), n3(:,185), t3x8(:,:,126))
  call counter_A_Q(cttt,6,ntry, wf8(:,22), 42, wf8(:,200), n2(102))
  call vert_AV_Q(ntry, ex2(:), wf4(:,47), wf8(:,201), n3(:,186), t3x8(:,:,127))
  call counter_A_Q(cttt,6,ntry, wf8(:,25), 42, wf8(:,202), n2(103))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,47), 40, wf8(:,203), n3(:,187), t3x8(:,:,128))
  call counter_A_Q(cttt,6,ntry, wf8(:,28), 50, wf8(:,204), n2(104))
  call vert_AV_Q(ntry, ex2(:), wf4(:,43), wf8(:,205), n3(:,188), t3x8(:,:,129))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,43), 48, wf8(:,206), n3(:,189), t3x8(:,:,130))
  call vert_AV_Q(ntry, wf4(:,4), wf4(:,6), wf16(:,55), n3(:,190), t3x16(:,:,37))
  call counter_Q_A(cttt,6,ntry, wf4(:,15), 9, wf4(:,52), n2(105))
  call prop_A_Q(ntry, wf16(:,55), 54, MT, 1_intkind1, wf16(:,56), n2(106))
  call vert_VQ_A(ntry, wf4(:,6), wf4(:,15), wf16(:,57), n3(:,191), t3x16(:,:,38))
  call prop_Q_A(ntry, wf16(:,57), 57, MT, 1_intkind1, wf16(:,58), n2(107))
  call prop_Q_A(ntry, wf4(:,52), 9, MT, 1_intkind1, wf4(:,53), n2(108))
  call vert_VQ_A(ntry, ex5(:), wf4(:,53), wf8(:,207), n3(:,192), t3x8(:,:,131))
  call vert_VQ_A(ntry, ex6(:), wf4(:,53), wf8(:,208), n3(:,193), t3x8(:,:,132))
  call prop_A_Q(ntry, wf4(:,29), 6, MT, 1_intkind1, wf4(:,54), n2(109))
  call vert_AV_Q(ntry, wf4(:,54), ex5(:), wf8(:,209), n3(:,194), t3x8(:,:,133))
  call vert_AV_Q(ntry, wf4(:,54), ex6(:), wf8(:,210), n3(:,195), t3x8(:,:,134))
  call counter_Q_A(cttt,6,ntry, wf8(:,31), 25, wf8(:,211), n2(110))
  call counter_A_Q(cttt,6,ntry, wf8(:,34), 22, wf8(:,212), n2(111))
  call vert_AV_Q(ntry, wf4(:,4), wf4(:,9), wf16(:,59), n3(:,196), t3x16(:,:,39))
  call counter_Q_A(cttt,6,ntry, wf4(:,17), 17, wf4(:,55), n2(112))
  call prop_A_Q(ntry, wf16(:,59), 46, MT, 1_intkind1, wf16(:,60), n2(113))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,17), wf16(:,61), n3(:,197), t3x16(:,:,40))
  call prop_Q_A(ntry, wf16(:,61), 57, MT, 1_intkind1, wf16(:,62), n2(114))
  call prop_Q_A(ntry, wf4(:,55), 17, MT, 1_intkind1, wf4(:,56), n2(115))
  call vert_VQ_A(ntry, ex4(:), wf4(:,56), wf8(:,213), n3(:,198), t3x8(:,:,135))
  call vert_VQ_A(ntry, ex6(:), wf4(:,56), wf8(:,214), n3(:,199), t3x8(:,:,136))
  call vert_AV_Q(ntry, wf4(:,54), ex4(:), wf8(:,215), n3(:,200), t3x8(:,:,137))
  call counter_Q_A(cttt,6,ntry, wf8(:,36), 25, wf8(:,216), n2(116))
  call counter_A_Q(cttt,6,ntry, wf8(:,39), 14, wf8(:,217), n2(117))
  call vert_AV_Q(ntry, wf4(:,4), wf4(:,12), wf16(:,63), n3(:,201), t3x16(:,:,41))
  call counter_Q_A(cttt,6,ntry, wf4(:,19), 33, wf4(:,57), n2(118))
  call prop_A_Q(ntry, wf16(:,63), 30, MT, 1_intkind1, wf16(:,64), n2(119))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,19), wf16(:,65), n3(:,202), t3x16(:,:,42))
  call prop_Q_A(ntry, wf16(:,65), 57, MT, 1_intkind1, wf16(:,66), n2(120))
  call vert_QA_V(ntry, ex1(:), wf4(:,54), wf8(:,218), n3(:,203), t3x8(:,:,138))
  call vert_VQ_A(ntry, wf4(:,50), ex1(:), wf8(:,219), n3(:,204), t3x8(:,:,139))
  call counter_V_V(ctGG,21,ntry, wf8(:,5), 7, wf8(:,220), n2(121))
  call counter_Q_A(cttt,6,ntry, wf8(:,41), 25, wf8(:,221), n2(122))
  call prop_Q_A(ntry, wf4(:,57), 33, MT, 1_intkind1, wf4(:,58), n2(123))
  call vert_VQ_A(ntry, ex4(:), wf4(:,58), wf8(:,222), n3(:,205), t3x8(:,:,140))
  call vert_VQ_A(ntry, ex5(:), wf4(:,58), wf8(:,223), n3(:,206), t3x8(:,:,141))
  call counter_Q_A(cttt,6,ntry, wf8(:,43), 41, wf8(:,224), n2(124))
  call vert_VQ_A(ntry, wf4(:,47), ex1(:), wf8(:,225), n3(:,207), t3x8(:,:,142))
  call counter_Q_A(cttt,6,ntry, wf8(:,46), 41, wf8(:,226), n2(125))
  call counter_Q_A(cttt,6,ntry, wf8(:,48), 49, wf8(:,227), n2(126))
  call vert_VQ_A(ntry, wf4(:,43), ex1(:), wf8(:,228), n3(:,208), t3x8(:,:,143))
  call vert_VQ_A(ntry, ex3(:), wf4(:,53), wf8(:,229), n3(:,209), t3x8(:,:,144))
  call vert_AV_Q(ntry, wf4(:,48), ex3(:), wf8(:,230), n3(:,210), t3x8(:,:,145))
  call counter_Q_A(cttt,6,ntry, wf8(:,50), 13, wf8(:,231), n2(127))
  call counter_A_Q(cttt,6,ntry, wf8(:,52), 22, wf8(:,232), n2(128))
  call vert_AV_Q(ntry, wf4(:,51), ex3(:), wf8(:,233), n3(:,211), t3x8(:,:,146))
  call counter_A_Q(cttt,6,ntry, wf8(:,54), 38, wf8(:,234), n2(129))
  call vert_VQ_A(ntry, ex3(:), wf4(:,56), wf8(:,235), n3(:,212), t3x8(:,:,147))
  call vert_AV_Q(ntry, wf4(:,45), ex3(:), wf8(:,236), n3(:,213), t3x8(:,:,148))
  call counter_Q_A(cttt,6,ntry, wf8(:,56), 21, wf8(:,237), n2(130))
  call counter_A_Q(cttt,6,ntry, wf8(:,58), 14, wf8(:,238), n2(131))
  call vert_VQ_A(ntry, ex3(:), wf4(:,58), wf8(:,239), n3(:,214), t3x8(:,:,149))
  call counter_Q_A(cttt,6,ntry, wf8(:,60), 37, wf8(:,240), n2(132))
  call vert_GGG_G(ntry, wf4(:,20), ex5(:), ex6(:), wf16(:,67), n4(:,19), t4x16(:,:,7))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,20), wf16(:,68), n4(:,20), t4x16(:,:,8))
  call vert_GGG_G(ntry, ex6(:), wf4(:,20), ex5(:), wf16(:,69), n4(:,21), t4x16(:,:,9))
  call vert_GGG_G(ntry, wf4(:,20), ex4(:), ex6(:), wf16(:,70), n4(:,22), t4x16(:,:,10))
  call vert_GGG_G(ntry, ex4(:), ex6(:), wf4(:,20), wf16(:,71), n4(:,23), t4x16(:,:,11))
  call vert_GGG_G(ntry, ex6(:), wf4(:,20), ex4(:), wf16(:,72), n4(:,24), t4x16(:,:,12))
  call vert_GGG_G(ntry, wf4(:,20), ex4(:), ex5(:), wf16(:,73), n4(:,25), t4x16(:,:,13))
  call vert_GGG_G(ntry, ex4(:), ex5(:), wf4(:,20), wf16(:,74), n4(:,26), t4x16(:,:,14))
  call vert_GGG_G(ntry, ex5(:), wf4(:,20), ex4(:), wf16(:,75), n4(:,27), t4x16(:,:,15))
  call vert_UV_W(ntry, wf4(:,20), 3, wf4(:,12), 24, wf16(:,76), n3(:,215), t3x16(:,:,43))
  call vert_UV_W(ntry, wf4(:,20), 3, wf4(:,9), 40, wf16(:,77), n3(:,216), t3x16(:,:,44))
  call vert_UV_W(ntry, wf4(:,20), 3, wf4(:,6), 48, wf16(:,78), n3(:,217), t3x16(:,:,45))
  call vert_UV_W(ntry, wf8(:,62), 11, ex5(:), 16, wf16(:,79), n3(:,218), t3x16(:,:,46))
  call vert_UV_W(ntry, wf8(:,62), 11, ex6(:), 32, wf16(:,80), n3(:,219), t3x16(:,:,47))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,65), 19, wf16(:,81), n3(:,220), t3x16(:,:,48))
  call vert_UV_W(ntry, wf8(:,65), 19, ex6(:), 32, wf16(:,82), n3(:,221), t3x16(:,:,49))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,68), 35, wf16(:,83), n3(:,222), t3x16(:,:,50))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,68), 35, wf16(:,84), n3(:,223), t3x16(:,:,51))
  call vert_UV_W(ntry, wf8(:,2), 7, ex4(:), 8, wf16(:,85), n3(:,224), t3x16(:,:,52))
  call vert_UV_W(ntry, wf8(:,2), 7, ex5(:), 16, wf16(:,86), n3(:,225), t3x16(:,:,53))
  call vert_UV_W(ntry, wf8(:,2), 7, ex6(:), 32, wf16(:,87), n3(:,226), t3x16(:,:,54))
  call vert_QA_V(ntry, wf8(:,14), ex2(:), wf16(:,88), n3(:,227), t3x16(:,:,55))
  call vert_VQ_A(ntry, ex5(:), wf8(:,14), wf16(:,89), n3(:,228), t3x16(:,:,56))
  call prop_Q_A(ntry, wf16(:,89), 29, MT, 1_intkind1, wf16(:,90), n2(133))
  call vert_VQ_A(ntry, ex6(:), wf8(:,14), wf16(:,91), n3(:,229), t3x16(:,:,57))
  call prop_Q_A(ntry, wf16(:,91), 45, MT, 1_intkind1, wf16(:,92), n2(134))
  call vert_QA_V(ntry, wf8(:,8), ex2(:), wf16(:,93), n3(:,230), t3x16(:,:,58))
  call vert_VQ_A(ntry, ex4(:), wf8(:,8), wf16(:,94), n3(:,231), t3x16(:,:,59))
  call prop_Q_A(ntry, wf16(:,94), 29, MT, 1_intkind1, wf16(:,95), n2(135))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,96), n3(:,232), t3x16(:,:,60))
  call prop_Q_A(ntry, wf16(:,96), 53, MT, 1_intkind1, wf16(:,97), n2(136))
  call vert_QA_V(ntry, wf8(:,86), ex2(:), wf16(:,98), n3(:,233), t3x16(:,:,61))
  call vert_VQ_A(ntry, ex4(:), wf8(:,86), wf16(:,99), n3(:,234), t3x16(:,:,62))
  call prop_Q_A(ntry, wf16(:,99), 45, MT, 1_intkind1, wf16(:,100), n2(137))
  call vert_VQ_A(ntry, ex5(:), wf8(:,86), wf16(:,101), n3(:,235), t3x16(:,:,63))
  call prop_Q_A(ntry, wf16(:,101), 53, MT, 1_intkind1, wf16(:,102), n2(138))
  call vert_UV_W(ntry, wf8(:,5), 7, ex4(:), 8, wf16(:,103), n3(:,236), t3x16(:,:,64))
  call vert_UV_W(ntry, wf8(:,5), 7, ex5(:), 16, wf16(:,104), n3(:,237), t3x16(:,:,65))
  call vert_UV_W(ntry, wf8(:,5), 7, ex6(:), 32, wf16(:,105), n3(:,238), t3x16(:,:,66))
  call vert_QA_V(ntry, ex1(:), wf8(:,39), wf16(:,106), n3(:,239), t3x16(:,:,67))
  call vert_QA_V(ntry, ex1(:), wf8(:,34), wf16(:,107), n3(:,240), t3x16(:,:,68))
  call vert_QA_V(ntry, ex1(:), wf8(:,116), wf16(:,108), n3(:,241), t3x16(:,:,69))
  call vert_AV_Q(ntry, wf8(:,39), ex5(:), wf16(:,109), n3(:,242), t3x16(:,:,70))
  call prop_A_Q(ntry, wf16(:,109), 30, MT, 1_intkind1, wf16(:,110), n2(139))
  call vert_AV_Q(ntry, wf8(:,39), ex6(:), wf16(:,111), n3(:,243), t3x16(:,:,71))
  call prop_A_Q(ntry, wf16(:,111), 46, MT, 1_intkind1, wf16(:,112), n2(140))
  call vert_AV_Q(ntry, wf8(:,34), ex4(:), wf16(:,113), n3(:,244), t3x16(:,:,72))
  call prop_A_Q(ntry, wf16(:,113), 30, MT, 1_intkind1, wf16(:,114), n2(141))
  call vert_AV_Q(ntry, wf8(:,34), ex6(:), wf16(:,115), n3(:,245), t3x16(:,:,73))
  call prop_A_Q(ntry, wf16(:,115), 54, MT, 1_intkind1, wf16(:,116), n2(142))
  call vert_AV_Q(ntry, wf8(:,116), ex4(:), wf16(:,117), n3(:,246), t3x16(:,:,74))
  call prop_A_Q(ntry, wf16(:,117), 46, MT, 1_intkind1, wf16(:,118), n2(143))
  call vert_AV_Q(ntry, wf8(:,116), ex5(:), wf16(:,119), n3(:,247), t3x16(:,:,75))
  call prop_A_Q(ntry, wf16(:,119), 54, MT, 1_intkind1, wf16(:,120), n2(144))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,10), wf16(:,121), n3(:,248), t3x16(:,:,76))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,13), wf16(:,122), n3(:,249), t3x16(:,:,77))
  call vert_UV_W(ntry, wf8(:,73), 11, ex5(:), 16, wf16(:,123), n3(:,250), t3x16(:,:,78))
  call vert_UV_W(ntry, wf8(:,73), 11, ex6(:), 32, wf16(:,124), n3(:,251), t3x16(:,:,79))
  call vert_QA_V(ntry, wf8(:,50), ex2(:), wf16(:,125), n3(:,252), t3x16(:,:,80))
  call vert_VQ_A(ntry, ex5(:), wf8(:,50), wf16(:,126), n3(:,253), t3x16(:,:,81))
  call prop_Q_A(ntry, wf16(:,126), 29, MT, 1_intkind1, wf16(:,127), n2(145))
  call vert_VQ_A(ntry, ex6(:), wf8(:,50), wf16(:,128), n3(:,254), t3x16(:,:,82))
  call prop_Q_A(ntry, wf16(:,128), 45, MT, 1_intkind1, wf16(:,129), n2(146))
  call vert_QA_V(ntry, wf8(:,31), ex2(:), wf16(:,130), n3(:,255), t3x16(:,:,83))
  call vert_VQ_A(ntry, ex3(:), wf8(:,31), wf16(:,131), n3(:,256), t3x16(:,:,84))
  call prop_Q_A(ntry, wf16(:,131), 29, MT, 1_intkind1, wf16(:,132), n2(147))
  call vert_VQ_A(ntry, ex6(:), wf8(:,31), wf16(:,133), n3(:,257), t3x16(:,:,85))
  call prop_Q_A(ntry, wf16(:,133), 57, MT, 1_intkind1, wf16(:,134), n2(148))
  call vert_QA_V(ntry, wf8(:,114), ex2(:), wf16(:,135), n3(:,258), t3x16(:,:,86))
  call vert_VQ_A(ntry, ex3(:), wf8(:,114), wf16(:,136), n3(:,259), t3x16(:,:,87))
  call prop_Q_A(ntry, wf16(:,136), 45, MT, 1_intkind1, wf16(:,137), n2(149))
  call vert_VQ_A(ntry, ex5(:), wf8(:,114), wf16(:,138), n3(:,260), t3x16(:,:,88))
  call prop_Q_A(ntry, wf16(:,138), 57, MT, 1_intkind1, wf16(:,139), n2(150))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,7), wf16(:,140), n3(:,261), t3x16(:,:,89))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,7), wf16(:,141), n3(:,262), t3x16(:,:,90))
  call vert_UV_W(ntry, wf8(:,74), 11, ex5(:), 16, wf16(:,142), n3(:,263), t3x16(:,:,91))
  call vert_UV_W(ntry, wf8(:,74), 11, ex6(:), 32, wf16(:,143), n3(:,264), t3x16(:,:,92))
  call vert_QA_V(ntry, ex1(:), wf8(:,58), wf16(:,144), n3(:,265), t3x16(:,:,93))
  call vert_QA_V(ntry, ex1(:), wf8(:,11), wf16(:,145), n3(:,266), t3x16(:,:,94))
  call vert_QA_V(ntry, ex1(:), wf8(:,88), wf16(:,146), n3(:,267), t3x16(:,:,95))
  call vert_AV_Q(ntry, wf8(:,58), ex5(:), wf16(:,147), n3(:,268), t3x16(:,:,96))
  call prop_A_Q(ntry, wf16(:,147), 30, MT, 1_intkind1, wf16(:,148), n2(151))
  call vert_AV_Q(ntry, wf8(:,58), ex6(:), wf16(:,149), n3(:,269), t3x16(:,:,97))
  call prop_A_Q(ntry, wf16(:,149), 46, MT, 1_intkind1, wf16(:,150), n2(152))
  call vert_AV_Q(ntry, wf8(:,11), ex3(:), wf16(:,151), n3(:,270), t3x16(:,:,98))
  call prop_A_Q(ntry, wf16(:,151), 30, MT, 1_intkind1, wf16(:,152), n2(153))
  call vert_AV_Q(ntry, wf8(:,11), ex6(:), wf16(:,153), n3(:,271), t3x16(:,:,99))
  call prop_A_Q(ntry, wf16(:,153), 58, MT, 1_intkind1, wf16(:,154), n2(154))
  call vert_AV_Q(ntry, wf8(:,88), ex3(:), wf16(:,155), n3(:,272), t3x16(:,:,100))
  call prop_A_Q(ntry, wf16(:,155), 46, MT, 1_intkind1, wf16(:,156), n2(155))
  call vert_AV_Q(ntry, wf8(:,88), ex5(:), wf16(:,157), n3(:,273), t3x16(:,:,101))
  call prop_A_Q(ntry, wf16(:,157), 58, MT, 1_intkind1, wf16(:,158), n2(156))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,13), wf16(:,159), n3(:,274), t3x16(:,:,102))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,75), 19, wf16(:,160), n3(:,275), t3x16(:,:,103))
  call vert_UV_W(ntry, wf8(:,75), 19, ex6(:), 32, wf16(:,161), n3(:,276), t3x16(:,:,104))
  call vert_QA_V(ntry, wf8(:,56), ex2(:), wf16(:,162), n3(:,277), t3x16(:,:,105))
  call vert_VQ_A(ntry, ex4(:), wf8(:,56), wf16(:,163), n3(:,278), t3x16(:,:,106))
  call prop_Q_A(ntry, wf16(:,163), 29, MT, 1_intkind1, wf16(:,164), n2(157))
  call vert_VQ_A(ntry, ex6(:), wf8(:,56), wf16(:,165), n3(:,279), t3x16(:,:,107))
  call prop_Q_A(ntry, wf16(:,165), 53, MT, 1_intkind1, wf16(:,166), n2(158))
  call vert_QA_V(ntry, wf8(:,36), ex2(:), wf16(:,167), n3(:,280), t3x16(:,:,108))
  call vert_VQ_A(ntry, ex3(:), wf8(:,36), wf16(:,168), n3(:,281), t3x16(:,:,109))
  call prop_Q_A(ntry, wf16(:,168), 29, MT, 1_intkind1, wf16(:,169), n2(159))
  call vert_VQ_A(ntry, ex6(:), wf8(:,36), wf16(:,170), n3(:,282), t3x16(:,:,110))
  call prop_Q_A(ntry, wf16(:,170), 57, MT, 1_intkind1, wf16(:,171), n2(160))
  call vert_QA_V(ntry, wf8(:,122), ex2(:), wf16(:,172), n3(:,283), t3x16(:,:,111))
  call vert_VQ_A(ntry, ex3(:), wf8(:,122), wf16(:,173), n3(:,284), t3x16(:,:,112))
  call prop_Q_A(ntry, wf16(:,173), 53, MT, 1_intkind1, wf16(:,174), n2(161))
  call vert_VQ_A(ntry, ex4(:), wf8(:,122), wf16(:,175), n3(:,285), t3x16(:,:,113))
  call prop_Q_A(ntry, wf16(:,175), 57, MT, 1_intkind1, wf16(:,176), n2(162))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,10), wf16(:,177), n3(:,286), t3x16(:,:,114))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,76), 19, wf16(:,178), n3(:,287), t3x16(:,:,115))
  call vert_UV_W(ntry, wf8(:,76), 19, ex6(:), 32, wf16(:,179), n3(:,288), t3x16(:,:,116))
  call vert_QA_V(ntry, ex1(:), wf8(:,52), wf16(:,180), n3(:,289), t3x16(:,:,117))
  call vert_QA_V(ntry, ex1(:), wf8(:,16), wf16(:,181), n3(:,290), t3x16(:,:,118))
  call vert_QA_V(ntry, ex1(:), wf8(:,101), wf16(:,182), n3(:,291), t3x16(:,:,119))
  call vert_AV_Q(ntry, wf8(:,52), ex4(:), wf16(:,183), n3(:,292), t3x16(:,:,120))
  call prop_A_Q(ntry, wf16(:,183), 30, MT, 1_intkind1, wf16(:,184), n2(163))
  call vert_AV_Q(ntry, wf8(:,52), ex6(:), wf16(:,185), n3(:,293), t3x16(:,:,121))
  call prop_A_Q(ntry, wf16(:,185), 54, MT, 1_intkind1, wf16(:,186), n2(164))
  call vert_AV_Q(ntry, wf8(:,16), ex3(:), wf16(:,187), n3(:,294), t3x16(:,:,122))
  call prop_A_Q(ntry, wf16(:,187), 30, MT, 1_intkind1, wf16(:,188), n2(165))
  call vert_AV_Q(ntry, wf8(:,16), ex6(:), wf16(:,189), n3(:,295), t3x16(:,:,123))
  call prop_A_Q(ntry, wf16(:,189), 58, MT, 1_intkind1, wf16(:,190), n2(166))
  call vert_AV_Q(ntry, wf8(:,101), ex3(:), wf16(:,191), n3(:,296), t3x16(:,:,124))
  call prop_A_Q(ntry, wf16(:,191), 54, MT, 1_intkind1, wf16(:,192), n2(167))
  call vert_AV_Q(ntry, wf8(:,101), ex4(:), wf16(:,193), n3(:,297), t3x16(:,:,125))
  call prop_A_Q(ntry, wf16(:,193), 58, MT, 1_intkind1, wf16(:,194), n2(168))
  call vert_QA_V(ntry, wf8(:,41), ex2(:), wf16(:,195), n3(:,298), t3x16(:,:,126))
  call vert_QA_V(ntry, ex1(:), wf8(:,19), wf16(:,196), n3(:,299), t3x16(:,:,127))
  call vert_VQ_A(ntry, ex3(:), wf8(:,41), wf16(:,197), n3(:,300), t3x16(:,:,128))
  call prop_Q_A(ntry, wf16(:,197), 29, MT, 1_intkind1, wf16(:,198), n2(169))
  call vert_VQ_A(ntry, ex6(:), wf8(:,41), wf16(:,199), n3(:,301), t3x16(:,:,129))
  call prop_Q_A(ntry, wf16(:,199), 57, MT, 1_intkind1, wf16(:,200), n2(170))
  call vert_VQ_A(ntry, wf8(:,17), ex1(:), wf16(:,201), n3(:,302), t3x16(:,:,130))
  call prop_Q_A(ntry, wf16(:,201), 57, MT, 1_intkind1, wf16(:,202), n2(171))
  call vert_AV_Q(ntry, wf8(:,19), ex3(:), wf16(:,203), n3(:,303), t3x16(:,:,131))
  call prop_A_Q(ntry, wf16(:,203), 30, MT, 1_intkind1, wf16(:,204), n2(172))
  call vert_AV_Q(ntry, wf8(:,19), ex6(:), wf16(:,205), n3(:,304), t3x16(:,:,132))
  call prop_A_Q(ntry, wf16(:,205), 58, MT, 1_intkind1, wf16(:,206), n2(173))
  call vert_AV_Q(ntry, ex2(:), wf8(:,17), wf16(:,207), n3(:,305), t3x16(:,:,133))
  call prop_A_Q(ntry, wf16(:,207), 58, MT, 1_intkind1, wf16(:,208), n2(174))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,77), 35, wf16(:,209), n3(:,306), t3x16(:,:,134))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,77), 35, wf16(:,210), n3(:,307), t3x16(:,:,135))
  call vert_QA_V(ntry, wf8(:,60), ex2(:), wf16(:,211), n3(:,308), t3x16(:,:,136))
  call vert_VQ_A(ntry, ex4(:), wf8(:,60), wf16(:,212), n3(:,309), t3x16(:,:,137))
  call prop_Q_A(ntry, wf16(:,212), 45, MT, 1_intkind1, wf16(:,213), n2(175))
  call vert_VQ_A(ntry, ex5(:), wf8(:,60), wf16(:,214), n3(:,310), t3x16(:,:,138))
  call prop_Q_A(ntry, wf16(:,214), 53, MT, 1_intkind1, wf16(:,215), n2(176))
  call vert_QA_V(ntry, wf8(:,43), ex2(:), wf16(:,216), n3(:,311), t3x16(:,:,139))
  call vert_VQ_A(ntry, ex3(:), wf8(:,43), wf16(:,217), n3(:,312), t3x16(:,:,140))
  call prop_Q_A(ntry, wf16(:,217), 45, MT, 1_intkind1, wf16(:,218), n2(177))
  call vert_VQ_A(ntry, ex5(:), wf8(:,43), wf16(:,219), n3(:,313), t3x16(:,:,141))
  call prop_Q_A(ntry, wf16(:,219), 57, MT, 1_intkind1, wf16(:,220), n2(178))
  call vert_QA_V(ntry, wf8(:,124), ex2(:), wf16(:,221), n3(:,314), t3x16(:,:,142))
  call vert_VQ_A(ntry, ex3(:), wf8(:,124), wf16(:,222), n3(:,315), t3x16(:,:,143))
  call prop_Q_A(ntry, wf16(:,222), 53, MT, 1_intkind1, wf16(:,223), n2(179))
  call vert_VQ_A(ntry, ex4(:), wf8(:,124), wf16(:,224), n3(:,316), t3x16(:,:,144))
  call prop_Q_A(ntry, wf16(:,224), 57, MT, 1_intkind1, wf16(:,225), n2(180))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,78), 35, wf16(:,226), n3(:,317), t3x16(:,:,145))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,78), 35, wf16(:,227), n3(:,318), t3x16(:,:,146))
  call vert_QA_V(ntry, ex1(:), wf8(:,54), wf16(:,228), n3(:,319), t3x16(:,:,147))
  call vert_QA_V(ntry, ex1(:), wf8(:,22), wf16(:,229), n3(:,320), t3x16(:,:,148))
  call vert_QA_V(ntry, ex1(:), wf8(:,103), wf16(:,230), n3(:,321), t3x16(:,:,149))
  call vert_AV_Q(ntry, wf8(:,54), ex4(:), wf16(:,231), n3(:,322), t3x16(:,:,150))
  call prop_A_Q(ntry, wf16(:,231), 46, MT, 1_intkind1, wf16(:,232), n2(181))
  call vert_AV_Q(ntry, wf8(:,54), ex5(:), wf16(:,233), n3(:,323), t3x16(:,:,151))
  call prop_A_Q(ntry, wf16(:,233), 54, MT, 1_intkind1, wf16(:,234), n2(182))
  call vert_AV_Q(ntry, wf8(:,22), ex3(:), wf16(:,235), n3(:,324), t3x16(:,:,152))
  call prop_A_Q(ntry, wf16(:,235), 46, MT, 1_intkind1, wf16(:,236), n2(183))
  call vert_AV_Q(ntry, wf8(:,22), ex5(:), wf16(:,237), n3(:,325), t3x16(:,:,153))
  call prop_A_Q(ntry, wf16(:,237), 58, MT, 1_intkind1, wf16(:,238), n2(184))
  call vert_AV_Q(ntry, wf8(:,103), ex3(:), wf16(:,239), n3(:,326), t3x16(:,:,154))
  call prop_A_Q(ntry, wf16(:,239), 54, MT, 1_intkind1, wf16(:,240), n2(185))
  call vert_AV_Q(ntry, wf8(:,103), ex4(:), wf16(:,241), n3(:,327), t3x16(:,:,155))
  call prop_A_Q(ntry, wf16(:,241), 58, MT, 1_intkind1, wf16(:,242), n2(186))
  call vert_QA_V(ntry, wf8(:,46), ex2(:), wf16(:,243), n3(:,328), t3x16(:,:,156))
  call vert_QA_V(ntry, ex1(:), wf8(:,25), wf16(:,244), n3(:,329), t3x16(:,:,157))
  call vert_VQ_A(ntry, ex3(:), wf8(:,46), wf16(:,245), n3(:,330), t3x16(:,:,158))
  call prop_Q_A(ntry, wf16(:,245), 45, MT, 1_intkind1, wf16(:,246), n2(187))
  call vert_VQ_A(ntry, ex5(:), wf8(:,46), wf16(:,247), n3(:,331), t3x16(:,:,159))
  call prop_Q_A(ntry, wf16(:,247), 57, MT, 1_intkind1, wf16(:,248), n2(188))
  call vert_VQ_A(ntry, wf8(:,23), ex1(:), wf16(:,249), n3(:,332), t3x16(:,:,160))
  call prop_Q_A(ntry, wf16(:,249), 57, MT, 1_intkind1, wf16(:,250), n2(189))
  call vert_AV_Q(ntry, wf8(:,25), ex3(:), wf16(:,251), n3(:,333), t3x16(:,:,161))
  call prop_A_Q(ntry, wf16(:,251), 46, MT, 1_intkind1, wf16(:,252), n2(190))
  call vert_AV_Q(ntry, wf8(:,25), ex5(:), wf16(:,253), n3(:,334), t3x16(:,:,162))
  call prop_A_Q(ntry, wf16(:,253), 58, MT, 1_intkind1, wf16(:,254), n2(191))
  call vert_AV_Q(ntry, ex2(:), wf8(:,23), wf16(:,255), n3(:,335), t3x16(:,:,163))
  call prop_A_Q(ntry, wf16(:,255), 58, MT, 1_intkind1, wf16(:,256), n2(192))
  call vert_QA_V(ntry, wf8(:,48), ex2(:), wf16(:,257), n3(:,336), t3x16(:,:,164))
  call vert_QA_V(ntry, ex1(:), wf8(:,28), wf16(:,258), n3(:,337), t3x16(:,:,165))
  call vert_VQ_A(ntry, ex3(:), wf8(:,48), wf16(:,259), n3(:,338), t3x16(:,:,166))
  call prop_Q_A(ntry, wf16(:,259), 53, MT, 1_intkind1, wf16(:,260), n2(193))
  call vert_VQ_A(ntry, ex4(:), wf8(:,48), wf16(:,261), n3(:,339), t3x16(:,:,167))
  call prop_Q_A(ntry, wf16(:,261), 57, MT, 1_intkind1, wf16(:,262), n2(194))
  call vert_VQ_A(ntry, wf8(:,26), ex1(:), wf16(:,263), n3(:,340), t3x16(:,:,168))
  call prop_Q_A(ntry, wf16(:,263), 57, MT, 1_intkind1, wf16(:,264), n2(195))
  call vert_AV_Q(ntry, wf8(:,28), ex3(:), wf16(:,265), n3(:,341), t3x16(:,:,169))
  call prop_A_Q(ntry, wf16(:,265), 54, MT, 1_intkind1, wf16(:,266), n2(196))
  call vert_AV_Q(ntry, wf8(:,28), ex4(:), wf16(:,267), n3(:,342), t3x16(:,:,170))
  call prop_A_Q(ntry, wf16(:,267), 58, MT, 1_intkind1, wf16(:,268), n2(197))
  call vert_AV_Q(ntry, ex2(:), wf8(:,26), wf16(:,269), n3(:,343), t3x16(:,:,171))
  call prop_A_Q(ntry, wf16(:,269), 58, MT, 1_intkind1, wf16(:,270), n2(198))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppattj_ttxaggg_1(extcombs(k))
  end do




  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf8(:,1), wf8(:,2), A(:,1), n3(:,344), t3x64(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,345), t3x64(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,4), A(:,3), n3(:,346), t3x64(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,5), A(:,4), n3(:,347), t3x64(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,5), A(:,5), n3(:,348), t3x64(:,:,5), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,5), A(:,6), n3(:,349), t3x64(:,:,6), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,1), A(:,7), n3(:,350), t3x64(:,:,7), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,8), A(:,8), n3(:,351), t3x64(:,:,8), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,11), A(:,9), n3(:,352), t3x64(:,:,9), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,2), A(:,10), n3(:,353), t3x64(:,:,10), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,14), A(:,11), n3(:,354), t3x64(:,:,11), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,16), A(:,12), n3(:,355), t3x64(:,:,12), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,3), A(:,13), n3(:,356), t3x64(:,:,13), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,17), A(:,14), n3(:,357), t3x64(:,:,14), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,19), A(:,15), n3(:,358), t3x64(:,:,15), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,20), A(:,16), n3(:,359), t3x64(:,:,16), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,22), A(:,17), n3(:,360), t3x64(:,:,17), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,23), A(:,18), n3(:,361), t3x64(:,:,18), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,25), A(:,19), n3(:,362), t3x64(:,:,19), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,26), A(:,20), n3(:,363), t3x64(:,:,20), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,28), A(:,21), n3(:,364), t3x64(:,:,21), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,4), A(:,22), n3(:,365), t3x64(:,:,22), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,31), A(:,23), n3(:,366), t3x64(:,:,23), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,34), A(:,24), n3(:,367), t3x64(:,:,24), nhel, den(53))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,5), A(:,25), n3(:,368), t3x64(:,:,25), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,36), A(:,26), n3(:,369), t3x64(:,:,26), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,39), A(:,27), n3(:,370), t3x64(:,:,27), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,6), A(:,28), n3(:,371), t3x64(:,:,28), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,17), A(:,29), n3(:,372), t3x64(:,:,29), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,41), A(:,30), n3(:,373), t3x64(:,:,30), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,43), A(:,31), n3(:,374), t3x64(:,:,31), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,44), A(:,32), n3(:,375), t3x64(:,:,32), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,23), A(:,33), n3(:,376), t3x64(:,:,33), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,46), A(:,34), n3(:,377), t3x64(:,:,34), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,26), A(:,35), n3(:,378), t3x64(:,:,35), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,48), A(:,36), n3(:,379), t3x64(:,:,36), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,50), A(:,37), n3(:,380), t3x64(:,:,37), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,52), A(:,38), n3(:,381), t3x64(:,:,38), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,50), A(:,39), n3(:,382), t3x64(:,:,39), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,54), A(:,40), n3(:,383), t3x64(:,:,40), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,49), A(:,41), n3(:,384), t3x64(:,:,41), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,56), A(:,42), n3(:,385), t3x64(:,:,42), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,58), A(:,43), n3(:,386), t3x64(:,:,43), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,60), A(:,44), n3(:,387), t3x64(:,:,44), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,58), A(:,45), n3(:,388), t3x64(:,:,45), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,57), A(:,46), n3(:,389), t3x64(:,:,46), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,56), A(:,47), n3(:,390), t3x64(:,:,47), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,54), A(:,48), n3(:,391), t3x64(:,:,48), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,55), A(:,49), n3(:,392), t3x64(:,:,49), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,60), A(:,50), n3(:,393), t3x64(:,:,50), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,52), A(:,51), n3(:,394), t3x64(:,:,51), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,51), A(:,52), n3(:,395), t3x64(:,:,52), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,59), A(:,53), n3(:,396), t3x64(:,:,53), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,53), A(:,54), n3(:,397), t3x64(:,:,54), nhel, den(105))

    call Hcont_VV(nsync, wf4(:,12), wf16(:,7), A(:,55), n3(:,398), t3x64(:,:,55), nhel, den(107))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,8), A(:,56), n3(:,399), t3x64(:,:,56), nhel, den(107))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,9), A(:,57), n3(:,400), t3x64(:,:,57), nhel, den(108))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,10), A(:,58), n3(:,401), t3x64(:,:,58), nhel, den(108))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,62), A(:,59), n3(:,402), t3x64(:,:,59), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,63), A(:,60), n3(:,403), t3x64(:,:,60), nhel, den(110))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,11), A(:,61), n3(:,404), t3x64(:,:,61), nhel, den(111))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,12), A(:,62), n3(:,405), t3x64(:,:,62), nhel, den(111))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,65), A(:,63), n3(:,406), t3x64(:,:,63), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,66), A(:,64), n3(:,407), t3x64(:,:,64), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,68), A(:,65), n3(:,408), t3x64(:,:,65), nhel, den(115))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,69), A(:,66), n3(:,409), t3x64(:,:,66), nhel, den(115))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,70), A(:,67), n3(:,410), t3x64(:,:,67), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,71), A(:,68), n3(:,411), t3x64(:,:,68), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,72), A(:,69), n3(:,412), t3x64(:,:,69), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,70), A(:,70), n3(:,413), t3x64(:,:,70), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,71), A(:,71), n3(:,414), t3x64(:,:,71), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,72), A(:,72), n3(:,415), t3x64(:,:,72), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,70), A(:,73), n3(:,416), t3x64(:,:,73), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,71), A(:,74), n3(:,417), t3x64(:,:,74), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,72), A(:,75), n3(:,418), t3x64(:,:,75), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,70), A(:,76), n3(:,419), t3x64(:,:,76), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,71), A(:,77), n3(:,420), t3x64(:,:,77), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,72), A(:,78), n3(:,421), t3x64(:,:,78), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,73), A(:,79), n3(:,422), t3x64(:,:,79), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,73), A(:,80), n3(:,423), t3x64(:,:,80), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,74), A(:,81), n3(:,424), t3x64(:,:,81), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,74), A(:,82), n3(:,425), t3x64(:,:,82), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,75), A(:,83), n3(:,426), t3x64(:,:,83), nhel, den(118))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,75), A(:,84), n3(:,427), t3x64(:,:,84), nhel, den(118))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,76), A(:,85), n3(:,428), t3x64(:,:,85), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,76), A(:,86), n3(:,429), t3x64(:,:,86), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,77), A(:,87), n3(:,430), t3x64(:,:,87), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,77), A(:,88), n3(:,431), t3x64(:,:,88), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,78), A(:,89), n3(:,432), t3x64(:,:,89), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,78), A(:,90), n3(:,433), t3x64(:,:,90), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,79), A(:,91), n3(:,434), t3x64(:,:,91), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,79), A(:,92), n3(:,435), t3x64(:,:,92), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,79), A(:,93), n3(:,436), t3x64(:,:,93), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,80), A(:,94), n3(:,437), t3x64(:,:,94), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,80), A(:,95), n3(:,438), t3x64(:,:,95), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,80), A(:,96), n3(:,439), t3x64(:,:,96), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,81), A(:,97), n3(:,440), t3x64(:,:,97), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,81), A(:,98), n3(:,441), t3x64(:,:,98), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,81), A(:,99), n3(:,442), t3x64(:,:,99), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,82), A(:,100), n3(:,443), t3x64(:,:,100), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,82), A(:,101), n3(:,444), t3x64(:,:,101), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,82), A(:,102), n3(:,445), t3x64(:,:,102), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,13), A(:,103), n3(:,446), t3x64(:,:,103), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,83), A(:,104), n3(:,447), t3x64(:,:,104), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,84), A(:,105), n3(:,448), t3x64(:,:,105), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,86), A(:,106), n3(:,449), t3x64(:,:,106), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,88), A(:,107), n3(:,450), t3x64(:,:,107), nhel, den(125))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,25), A(:,108), n3(:,451), t3x64(:,:,108), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,14), A(:,109), n3(:,452), t3x64(:,:,109), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,89), A(:,110), n3(:,453), t3x64(:,:,110), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,84), A(:,111), n3(:,454), t3x64(:,:,111), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,15), A(:,112), n3(:,455), t3x64(:,:,112), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,90), A(:,113), n3(:,456), t3x64(:,:,113), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,84), A(:,114), n3(:,457), t3x64(:,:,114), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,91), A(:,115), n3(:,458), t3x64(:,:,115), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,87), A(:,116), n3(:,459), t3x64(:,:,116), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,92), A(:,117), n3(:,460), t3x64(:,:,117), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,87), A(:,118), n3(:,461), t3x64(:,:,118), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,93), A(:,119), n3(:,462), t3x64(:,:,119), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,95), A(:,120), n3(:,463), t3x64(:,:,120), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,17), A(:,121), n3(:,464), t3x64(:,:,121), nhel, den(128))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,19), A(:,122), n3(:,465), t3x64(:,:,122), nhel, den(128))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,21), A(:,123), n3(:,466), t3x64(:,:,123), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,96), A(:,124), n3(:,467), t3x64(:,:,124), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,97), A(:,125), n3(:,468), t3x64(:,:,125), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,98), A(:,126), n3(:,469), t3x64(:,:,126), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,99), A(:,127), n3(:,470), t3x64(:,:,127), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,101), A(:,128), n3(:,471), t3x64(:,:,128), nhel, den(132))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,27), A(:,129), n3(:,472), t3x64(:,:,129), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,102), A(:,130), n3(:,473), t3x64(:,:,130), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,103), A(:,131), n3(:,474), t3x64(:,:,131), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,104), A(:,132), n3(:,475), t3x64(:,:,132), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,100), A(:,133), n3(:,476), t3x64(:,:,133), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,105), A(:,134), n3(:,477), t3x64(:,:,134), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,107), A(:,135), n3(:,478), t3x64(:,:,135), nhel, den(40))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,28), A(:,136), n3(:,479), t3x64(:,:,136), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,108), A(:,137), n3(:,480), t3x64(:,:,137), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,110), A(:,138), n3(:,481), t3x64(:,:,138), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,22), A(:,139), n3(:,482), t3x64(:,:,139), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,111), A(:,140), n3(:,483), t3x64(:,:,140), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,112), A(:,141), n3(:,484), t3x64(:,:,141), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,114), A(:,142), n3(:,485), t3x64(:,:,142), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,116), A(:,143), n3(:,486), t3x64(:,:,143), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,25), A(:,144), n3(:,487), t3x64(:,:,144), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,23), A(:,145), n3(:,488), t3x64(:,:,145), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,111), A(:,146), n3(:,489), t3x64(:,:,146), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,117), A(:,147), n3(:,490), t3x64(:,:,147), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,24), A(:,148), n3(:,491), t3x64(:,:,148), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,90), A(:,149), n3(:,492), t3x64(:,:,149), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,111), A(:,150), n3(:,493), t3x64(:,:,150), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,113), A(:,151), n3(:,494), t3x64(:,:,151), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,118), A(:,152), n3(:,495), t3x64(:,:,152), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,92), A(:,153), n3(:,496), t3x64(:,:,153), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,113), A(:,154), n3(:,497), t3x64(:,:,154), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,93), A(:,155), n3(:,498), t3x64(:,:,155), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,120), A(:,156), n3(:,499), t3x64(:,:,156), nhel, den(79))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,26), A(:,157), n3(:,500), t3x64(:,:,157), nhel, den(142))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,28), A(:,158), n3(:,501), t3x64(:,:,158), nhel, den(142))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,30), A(:,159), n3(:,502), t3x64(:,:,159), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,96), A(:,160), n3(:,503), t3x64(:,:,160), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,97), A(:,161), n3(:,504), t3x64(:,:,161), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,98), A(:,162), n3(:,505), t3x64(:,:,162), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,122), A(:,163), n3(:,506), t3x64(:,:,163), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,123), A(:,164), n3(:,507), t3x64(:,:,164), nhel, den(146))
    call Hcont_VV(nsync, wf16(:,5), wf4(:,27), A(:,165), n3(:,508), t3x64(:,:,165), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,124), A(:,166), n3(:,509), t3x64(:,:,166), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,125), A(:,167), n3(:,510), t3x64(:,:,167), nhel, den(149))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,104), A(:,168), n3(:,511), t3x64(:,:,168), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,121), A(:,169), n3(:,512), t3x64(:,:,169), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,105), A(:,170), n3(:,513), t3x64(:,:,170), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,127), A(:,171), n3(:,514), t3x64(:,:,171), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,28), A(:,172), n3(:,515), t3x64(:,:,172), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,108), A(:,173), n3(:,516), t3x64(:,:,173), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,129), A(:,174), n3(:,517), t3x64(:,:,174), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,89), A(:,175), n3(:,518), t3x64(:,:,175), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,112), A(:,176), n3(:,519), t3x64(:,:,176), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,91), A(:,177), n3(:,520), t3x64(:,:,177), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,115), A(:,178), n3(:,521), t3x64(:,:,178), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,95), A(:,179), n3(:,522), t3x64(:,:,179), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,83), A(:,180), n3(:,523), t3x64(:,:,180), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,117), A(:,181), n3(:,524), t3x64(:,:,181), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,85), A(:,182), n3(:,525), t3x64(:,:,182), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,118), A(:,183), n3(:,526), t3x64(:,:,183), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,120), A(:,184), n3(:,527), t3x64(:,:,184), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,102), A(:,185), n3(:,528), t3x64(:,:,185), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,123), A(:,186), n3(:,529), t3x64(:,:,186), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,55), wf8(:,107), A(:,187), n3(:,530), t3x64(:,:,187), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,99), A(:,188), n3(:,531), t3x64(:,:,188), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,125), A(:,189), n3(:,532), t3x64(:,:,189), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,127), A(:,190), n3(:,533), t3x64(:,:,190), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,110), A(:,191), n3(:,534), t3x64(:,:,191), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,129), A(:,192), n3(:,535), t3x64(:,:,192), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,130), A(:,193), n3(:,536), t3x64(:,:,193), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,131), A(:,194), n3(:,537), t3x64(:,:,194), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,132), A(:,195), n3(:,538), t3x64(:,:,195), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,131), A(:,196), n3(:,539), t3x64(:,:,196), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,131), A(:,197), n3(:,540), t3x64(:,:,197), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,133), A(:,198), n3(:,541), t3x64(:,:,198), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,134), A(:,199), n3(:,542), t3x64(:,:,199), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,133), A(:,200), n3(:,543), t3x64(:,:,200), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,135), A(:,201), n3(:,544), t3x64(:,:,201), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,133), A(:,202), n3(:,545), t3x64(:,:,202), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,132), A(:,203), n3(:,546), t3x64(:,:,203), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,134), A(:,204), n3(:,547), t3x64(:,:,204), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,134), A(:,205), n3(:,548), t3x64(:,:,205), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,130), A(:,206), n3(:,549), t3x64(:,:,206), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,135), A(:,207), n3(:,550), t3x64(:,:,207), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,130), A(:,208), n3(:,551), t3x64(:,:,208), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,135), A(:,209), n3(:,552), t3x64(:,:,209), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,132), A(:,210), n3(:,553), t3x64(:,:,210), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,136), A(:,211), n3(:,554), t3x64(:,:,211), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,79), A(:,212), n3(:,555), t3x64(:,:,212), nhel, den(164))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,31), A(:,213), n3(:,556), t3x64(:,:,213), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,137), A(:,214), n3(:,557), t3x64(:,:,214), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,79), A(:,215), n3(:,558), t3x64(:,:,215), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,138), A(:,216), n3(:,559), t3x64(:,:,216), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,79), A(:,217), n3(:,560), t3x64(:,:,217), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,139), A(:,218), n3(:,561), t3x64(:,:,218), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,141), A(:,219), n3(:,562), t3x64(:,:,219), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,32), A(:,220), n3(:,563), t3x64(:,:,220), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,142), A(:,221), n3(:,564), t3x64(:,:,221), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,144), A(:,222), n3(:,565), t3x64(:,:,222), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,33), A(:,223), n3(:,566), t3x64(:,:,223), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,145), A(:,224), n3(:,567), t3x64(:,:,224), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,147), A(:,225), n3(:,568), t3x64(:,:,225), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,138), A(:,226), n3(:,569), t3x64(:,:,226), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,139), A(:,227), n3(:,570), t3x64(:,:,227), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,149), A(:,228), n3(:,571), t3x64(:,:,228), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,142), A(:,229), n3(:,572), t3x64(:,:,229), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,151), A(:,230), n3(:,573), t3x64(:,:,230), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,137), A(:,231), n3(:,574), t3x64(:,:,231), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,140), A(:,232), n3(:,575), t3x64(:,:,232), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,149), A(:,233), n3(:,576), t3x64(:,:,233), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,136), A(:,234), n3(:,577), t3x64(:,:,234), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,148), A(:,235), n3(:,578), t3x64(:,:,235), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,143), A(:,236), n3(:,579), t3x64(:,:,236), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,151), A(:,237), n3(:,580), t3x64(:,:,237), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,150), A(:,238), n3(:,581), t3x64(:,:,238), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,145), A(:,239), n3(:,582), t3x64(:,:,239), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,153), A(:,240), n3(:,583), t3x64(:,:,240), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,146), A(:,241), n3(:,584), t3x64(:,:,241), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,153), A(:,242), n3(:,585), t3x64(:,:,242), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,152), A(:,243), n3(:,586), t3x64(:,:,243), nhel, den(97))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,34), A(:,244), n3(:,587), t3x64(:,:,244), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,154), A(:,245), n3(:,588), t3x64(:,:,245), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,156), A(:,246), n3(:,589), t3x64(:,:,246), nhel, den(53))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,35), A(:,247), n3(:,590), t3x64(:,:,247), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,154), A(:,248), n3(:,591), t3x64(:,:,248), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,158), A(:,249), n3(:,592), t3x64(:,:,249), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,36), A(:,250), n3(:,593), t3x64(:,:,250), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,154), A(:,251), n3(:,594), t3x64(:,:,251), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,80), A(:,252), n3(:,595), t3x64(:,:,252), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,155), A(:,253), n3(:,596), t3x64(:,:,253), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,158), A(:,254), n3(:,597), t3x64(:,:,254), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,155), A(:,255), n3(:,598), t3x64(:,:,255), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,80), A(:,256), n3(:,599), t3x64(:,:,256), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,157), A(:,257), n3(:,600), t3x64(:,:,257), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,80), A(:,258), n3(:,601), t3x64(:,:,258), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,81), A(:,259), n3(:,602), t3x64(:,:,259), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,159), A(:,260), n3(:,603), t3x64(:,:,260), nhel, den(175))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,37), A(:,261), n3(:,604), t3x64(:,:,261), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,81), A(:,262), n3(:,605), t3x64(:,:,262), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,160), A(:,263), n3(:,606), t3x64(:,:,263), nhel, den(177))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,81), A(:,264), n3(:,607), t3x64(:,:,264), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,161), A(:,265), n3(:,608), t3x64(:,:,265), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,163), A(:,266), n3(:,609), t3x64(:,:,266), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,164), A(:,267), n3(:,610), t3x64(:,:,267), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,38), A(:,268), n3(:,611), t3x64(:,:,268), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,166), A(:,269), n3(:,612), t3x64(:,:,269), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,167), A(:,270), n3(:,613), t3x64(:,:,270), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,39), A(:,271), n3(:,614), t3x64(:,:,271), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,169), A(:,272), n3(:,615), t3x64(:,:,272), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,170), A(:,273), n3(:,616), t3x64(:,:,273), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,161), A(:,274), n3(:,617), t3x64(:,:,274), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,172), A(:,275), n3(:,618), t3x64(:,:,275), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,164), A(:,276), n3(:,619), t3x64(:,:,276), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,174), A(:,277), n3(:,620), t3x64(:,:,277), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,167), A(:,278), n3(:,621), t3x64(:,:,278), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,160), A(:,279), n3(:,622), t3x64(:,:,279), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,172), A(:,280), n3(:,623), t3x64(:,:,280), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,162), A(:,281), n3(:,624), t3x64(:,:,281), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,159), A(:,282), n3(:,625), t3x64(:,:,282), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,171), A(:,283), n3(:,626), t3x64(:,:,283), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,174), A(:,284), n3(:,627), t3x64(:,:,284), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,165), A(:,285), n3(:,628), t3x64(:,:,285), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,173), A(:,286), n3(:,629), t3x64(:,:,286), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,176), A(:,287), n3(:,630), t3x64(:,:,287), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,170), A(:,288), n3(:,631), t3x64(:,:,288), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,176), A(:,289), n3(:,632), t3x64(:,:,289), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,168), A(:,290), n3(:,633), t3x64(:,:,290), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,175), A(:,291), n3(:,634), t3x64(:,:,291), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,6), wf16(:,40), A(:,292), n3(:,635), t3x64(:,:,292), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,178), A(:,293), n3(:,636), t3x64(:,:,293), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,179), A(:,294), n3(:,637), t3x64(:,:,294), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,9), wf16(:,41), A(:,295), n3(:,638), t3x64(:,:,295), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,181), A(:,296), n3(:,639), t3x64(:,:,296), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,179), A(:,297), n3(:,640), t3x64(:,:,297), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,42), A(:,298), n3(:,641), t3x64(:,:,298), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,82), A(:,299), n3(:,642), t3x64(:,:,299), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,179), A(:,300), n3(:,643), t3x64(:,:,300), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,181), A(:,301), n3(:,644), t3x64(:,:,301), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,177), A(:,302), n3(:,645), t3x64(:,:,302), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,82), A(:,303), n3(:,646), t3x64(:,:,303), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,177), A(:,304), n3(:,647), t3x64(:,:,304), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,82), A(:,305), n3(:,648), t3x64(:,:,305), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,180), A(:,306), n3(:,649), t3x64(:,:,306), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,44), A(:,307), n3(:,650), t3x64(:,:,307), nhel, den(185))
    call Hcont_QA(nsync, wf4(:,42), wf16(:,46), A(:,308), n3(:,651), t3x64(:,:,308), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,43), A(:,309), n3(:,652), t3x64(:,:,309), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,182), A(:,310), n3(:,653), t3x64(:,:,310), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,183), A(:,311), n3(:,654), t3x64(:,:,311), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,184), A(:,312), n3(:,655), t3x64(:,:,312), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,185), A(:,313), n3(:,656), t3x64(:,:,313), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,186), A(:,314), n3(:,657), t3x64(:,:,314), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,187), A(:,315), n3(:,658), t3x64(:,:,315), nhel, den(200))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,48), A(:,316), n3(:,659), t3x64(:,:,316), nhel, den(203))
    call Hcont_QA(nsync, wf4(:,46), wf16(:,50), A(:,317), n3(:,660), t3x64(:,:,317), nhel, den(207))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,47), A(:,318), n3(:,661), t3x64(:,:,318), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,188), A(:,319), n3(:,662), t3x64(:,:,319), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,183), A(:,320), n3(:,663), t3x64(:,:,320), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,189), A(:,321), n3(:,664), t3x64(:,:,321), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,190), A(:,322), n3(:,665), t3x64(:,:,322), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,191), A(:,323), n3(:,666), t3x64(:,:,323), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,192), A(:,324), n3(:,667), t3x64(:,:,324), nhel, den(217))
    call Hcont_QA(nsync, wf4(:,26), wf16(:,52), A(:,325), n3(:,668), t3x64(:,:,325), nhel, den(220))
    call Hcont_QA(nsync, wf4(:,49), wf16(:,54), A(:,326), n3(:,669), t3x64(:,:,326), nhel, den(224))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,50), A(:,327), n3(:,670), t3x64(:,:,327), nhel, den(227))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,193), A(:,328), n3(:,671), t3x64(:,:,328), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,183), A(:,329), n3(:,672), t3x64(:,:,329), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,194), A(:,330), n3(:,673), t3x64(:,:,330), nhel, den(231))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,195), A(:,331), n3(:,674), t3x64(:,:,331), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,196), A(:,332), n3(:,675), t3x64(:,:,332), nhel, den(233))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,197), A(:,333), n3(:,676), t3x64(:,:,333), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,188), A(:,334), n3(:,677), t3x64(:,:,334), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,182), A(:,335), n3(:,678), t3x64(:,:,335), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,198), A(:,336), n3(:,679), t3x64(:,:,336), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,199), A(:,337), n3(:,680), t3x64(:,:,337), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,191), A(:,338), n3(:,681), t3x64(:,:,338), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,200), A(:,339), n3(:,682), t3x64(:,:,339), nhel, den(241))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,193), A(:,340), n3(:,683), t3x64(:,:,340), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,182), A(:,341), n3(:,684), t3x64(:,:,341), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,201), A(:,342), n3(:,685), t3x64(:,:,342), nhel, den(245))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,195), A(:,343), n3(:,686), t3x64(:,:,343), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,202), A(:,344), n3(:,687), t3x64(:,:,344), nhel, den(247))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,203), A(:,345), n3(:,688), t3x64(:,:,345), nhel, den(248))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,193), A(:,346), n3(:,689), t3x64(:,:,346), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,188), A(:,347), n3(:,690), t3x64(:,:,347), nhel, den(250))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,195), A(:,348), n3(:,691), t3x64(:,:,348), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,204), A(:,349), n3(:,692), t3x64(:,:,349), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,205), A(:,350), n3(:,693), t3x64(:,:,350), nhel, den(254))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,206), A(:,351), n3(:,694), t3x64(:,:,351), nhel, den(255))
    call Hcont_QA(nsync, wf4(:,52), wf16(:,56), A(:,352), n3(:,695), t3x64(:,:,352), nhel, den(259))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,58), A(:,353), n3(:,696), t3x64(:,:,353), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,43), A(:,354), n3(:,697), t3x64(:,:,354), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,207), A(:,355), n3(:,698), t3x64(:,:,355), nhel, den(266))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,208), A(:,356), n3(:,699), t3x64(:,:,356), nhel, den(267))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,209), A(:,357), n3(:,700), t3x64(:,:,357), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,210), A(:,358), n3(:,701), t3x64(:,:,358), nhel, den(270))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,211), A(:,359), n3(:,702), t3x64(:,:,359), nhel, den(271))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,212), A(:,360), n3(:,703), t3x64(:,:,360), nhel, den(272))
    call Hcont_QA(nsync, wf4(:,55), wf16(:,60), A(:,361), n3(:,704), t3x64(:,:,361), nhel, den(276))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,62), A(:,362), n3(:,705), t3x64(:,:,362), nhel, den(279))
    call Hcont_VV(nsync, wf16(:,5), wf4(:,47), A(:,363), n3(:,706), t3x64(:,:,363), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,213), A(:,364), n3(:,707), t3x64(:,:,364), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,214), A(:,365), n3(:,708), t3x64(:,:,365), nhel, den(284))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,215), A(:,366), n3(:,709), t3x64(:,:,366), nhel, den(285))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,210), A(:,367), n3(:,710), t3x64(:,:,367), nhel, den(286))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,216), A(:,368), n3(:,711), t3x64(:,:,368), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,217), A(:,369), n3(:,712), t3x64(:,:,369), nhel, den(288))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,64), A(:,370), n3(:,713), t3x64(:,:,370), nhel, den(292))
    call Hcont_QA(nsync, wf4(:,29), wf16(:,66), A(:,371), n3(:,714), t3x64(:,:,371), nhel, den(295))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,50), A(:,372), n3(:,715), t3x64(:,:,372), nhel, den(297))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,218), A(:,373), n3(:,716), t3x64(:,:,373), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,219), A(:,374), n3(:,717), t3x64(:,:,374), nhel, den(299))
    call Hcont_VV(nsync, wf8(:,17), wf8(:,220), A(:,375), n3(:,718), t3x64(:,:,375), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,116), wf8(:,221), A(:,376), n3(:,719), t3x64(:,:,376), nhel, den(301))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,210), A(:,377), n3(:,720), t3x64(:,:,377), nhel, den(302))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,197), A(:,378), n3(:,721), t3x64(:,:,378), nhel, den(303))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,222), A(:,379), n3(:,722), t3x64(:,:,379), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,223), A(:,380), n3(:,723), t3x64(:,:,380), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,215), A(:,381), n3(:,724), t3x64(:,:,381), nhel, den(307))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,209), A(:,382), n3(:,725), t3x64(:,:,382), nhel, den(308))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,224), A(:,383), n3(:,726), t3x64(:,:,383), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,217), A(:,384), n3(:,727), t3x64(:,:,384), nhel, den(310))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,218), A(:,385), n3(:,728), t3x64(:,:,385), nhel, den(311))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,225), A(:,386), n3(:,729), t3x64(:,:,386), nhel, den(312))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,220), A(:,387), n3(:,730), t3x64(:,:,387), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,226), A(:,388), n3(:,731), t3x64(:,:,388), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,209), A(:,389), n3(:,732), t3x64(:,:,389), nhel, den(315))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,203), A(:,390), n3(:,733), t3x64(:,:,390), nhel, den(316))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,218), A(:,391), n3(:,734), t3x64(:,:,391), nhel, den(317))
    call Hcont_VV(nsync, wf8(:,26), wf8(:,220), A(:,392), n3(:,735), t3x64(:,:,392), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,227), A(:,393), n3(:,736), t3x64(:,:,393), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,228), A(:,394), n3(:,737), t3x64(:,:,394), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,215), A(:,395), n3(:,738), t3x64(:,:,395), nhel, den(321))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,206), A(:,396), n3(:,739), t3x64(:,:,396), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,229), A(:,397), n3(:,740), t3x64(:,:,397), nhel, den(323))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,208), A(:,398), n3(:,741), t3x64(:,:,398), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,230), A(:,399), n3(:,742), t3x64(:,:,399), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,190), A(:,400), n3(:,743), t3x64(:,:,400), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,231), A(:,401), n3(:,744), t3x64(:,:,401), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,232), A(:,402), n3(:,745), t3x64(:,:,402), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,229), A(:,403), n3(:,746), t3x64(:,:,403), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,207), A(:,404), n3(:,747), t3x64(:,:,404), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,233), A(:,405), n3(:,748), t3x64(:,:,405), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,199), A(:,406), n3(:,749), t3x64(:,:,406), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,231), A(:,407), n3(:,750), t3x64(:,:,407), nhel, den(333))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,234), A(:,408), n3(:,751), t3x64(:,:,408), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,229), A(:,409), n3(:,752), t3x64(:,:,409), nhel, den(335))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,204), A(:,410), n3(:,753), t3x64(:,:,410), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,205), A(:,411), n3(:,754), t3x64(:,:,411), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,235), A(:,412), n3(:,755), t3x64(:,:,412), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,214), A(:,413), n3(:,756), t3x64(:,:,413), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,236), A(:,414), n3(:,757), t3x64(:,:,414), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,185), A(:,415), n3(:,758), t3x64(:,:,415), nhel, den(341))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,237), A(:,416), n3(:,759), t3x64(:,:,416), nhel, den(342))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,238), A(:,417), n3(:,760), t3x64(:,:,417), nhel, den(343))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,239), A(:,418), n3(:,761), t3x64(:,:,418), nhel, den(344))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,223), A(:,419), n3(:,762), t3x64(:,:,419), nhel, den(345))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,236), A(:,420), n3(:,763), t3x64(:,:,420), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,184), A(:,421), n3(:,764), t3x64(:,:,421), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,240), A(:,422), n3(:,765), t3x64(:,:,422), nhel, den(348))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,238), A(:,423), n3(:,766), t3x64(:,:,423), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,227), A(:,424), n3(:,767), t3x64(:,:,424), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,228), A(:,425), n3(:,768), t3x64(:,:,425), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,236), A(:,426), n3(:,769), t3x64(:,:,426), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,235), A(:,427), n3(:,770), t3x64(:,:,427), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,213), A(:,428), n3(:,771), t3x64(:,:,428), nhel, den(354))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,233), A(:,429), n3(:,772), t3x64(:,:,429), nhel, den(355))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,198), A(:,430), n3(:,773), t3x64(:,:,430), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,237), A(:,431), n3(:,774), t3x64(:,:,431), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,234), A(:,432), n3(:,775), t3x64(:,:,432), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,235), A(:,433), n3(:,776), t3x64(:,:,433), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,202), A(:,434), n3(:,777), t3x64(:,:,434), nhel, den(360))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,201), A(:,435), n3(:,778), t3x64(:,:,435), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,239), A(:,436), n3(:,779), t3x64(:,:,436), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,222), A(:,437), n3(:,780), t3x64(:,:,437), nhel, den(363))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,230), A(:,438), n3(:,781), t3x64(:,:,438), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,189), A(:,439), n3(:,782), t3x64(:,:,439), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,240), A(:,440), n3(:,783), t3x64(:,:,440), nhel, den(366))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,232), A(:,441), n3(:,784), t3x64(:,:,441), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,226), A(:,442), n3(:,785), t3x64(:,:,442), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,225), A(:,443), n3(:,786), t3x64(:,:,443), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,230), A(:,444), n3(:,787), t3x64(:,:,444), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,239), A(:,445), n3(:,788), t3x64(:,:,445), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,196), A(:,446), n3(:,789), t3x64(:,:,446), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,194), A(:,447), n3(:,790), t3x64(:,:,447), nhel, den(373))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,221), A(:,448), n3(:,791), t3x64(:,:,448), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,219), A(:,449), n3(:,792), t3x64(:,:,449), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,233), A(:,450), n3(:,793), t3x64(:,:,450), nhel, den(376))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(11) ! M1helarray(11,64)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,9)%j+A(j,14)%j+A(j,20)%j+A(j,29)%j+A(j,32)%j+A(j,35)%j+A(j,44)%j &
       +A(j,45)%j)*f(1)+CI*(A(j,7)%j+A(j,15)%j+A(j,28)%j+A(j,36)%j+A(j,46)%j+A(j,53)%j)*f(2)
  M1(2)%j = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,8)%j-A(j,18)%j-A(j,20)%j+A(j,27)%j-A(j,33)%j-A(j,35)%j+A(j,42)%j &
       +A(j,43)%j)*f(1)+CI*(-A(j,7)%j+A(j,19)%j+A(j,25)%j-A(j,36)%j-A(j,46)%j+A(j,49)%j)*f(2)
  M1(3)%j = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j+A(j,12)%j-A(j,14)%j+A(j,18)%j-A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,50)%j &
       +A(j,51)%j)*f(1)+CI*(A(j,10)%j-A(j,15)%j-A(j,28)%j+A(j,34)%j+A(j,52)%j-A(j,53)%j)*f(2)
  M1(4)%j = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,11)%j-A(j,18)%j-A(j,20)%j+A(j,24)%j-A(j,33)%j-A(j,35)%j+A(j,37)%j &
       +A(j,38)%j)*f(1)+CI*(-A(j,10)%j+A(j,21)%j+A(j,22)%j-A(j,34)%j+A(j,41)%j-A(j,52)%j)*f(2)
  M1(5)%j = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j-A(j,14)%j+A(j,17)%j+A(j,18)%j+A(j,26)%j-A(j,29)%j+A(j,33)%j+A(j,47)%j &
       +A(j,48)%j)*f(1)+CI*(A(j,13)%j-A(j,19)%j-A(j,25)%j+A(j,30)%j-A(j,49)%j+A(j,54)%j)*f(2)
  M1(6)%j = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,14)%j+A(j,16)%j+A(j,20)%j+A(j,23)%j+A(j,29)%j+A(j,35)%j+A(j,39)%j &
       +A(j,40)%j)*f(1)+CI*(-A(j,13)%j-A(j,21)%j-A(j,22)%j-A(j,30)%j-A(j,41)%j-A(j,54)%j)*f(2)

  M2( 1)%j = (-A(j,121)%j+A(j,122)%j-A(j,124)%j+A(j,125)%j-A(j,157)%j+A(j,158)%j-A(j,160)%j+A(j,161)%j-A(j,311)%j-A(j,312)%j &
        -A(j,315)%j-A(j,328)%j-A(j,331)%j-A(j,333)%j-A(j,346)%j-A(j,348)%j-A(j,351)%j-A(j,373)%j-A(j,375)%j-A(j,378)%j-A(j,380)%j &
        -A(j,381)%j-A(j,384)%j-A(j,391)%j-A(j,392)%j-A(j,396)%j-A(j,418)%j-A(j,419)%j-A(j,420)%j-A(j,421)%j-A(j,422)%j &
        -A(j,423)%j)*f(3)+((-A(j,81)%j-A(j,87)%j)*f(4))/2._/**/REALKIND+CI*(-A(j,307)%j-A(j,308)%j-A(j,309)%j-A(j,329)%j &
        -A(j,330)%j-A(j,332)%j-A(j,370)%j-A(j,371)%j-A(j,372)%j-A(j,393)%j-A(j,394)%j-A(j,395)%j-A(j,424)%j-A(j,425)%j-A(j,426)%j &
        -A(j,445)%j-A(j,446)%j-A(j,447)%j)*f(5)+(CI*(-A(j,56)%j-A(j,59)%j-A(j,61)%j+A(j,65)%j)*f(6))/2._/**/REALKIND+(A(j,91)%j &
        -A(j,92)%j+A(j,97)%j-A(j,98)%j+A(j,105)%j+A(j,106)%j+A(j,152)%j+A(j,166)%j+A(j,182)%j+A(j,183)%j+A(j,212)%j+A(j,217)%j &
        +A(j,225)%j+A(j,241)%j+A(j,242)%j+A(j,259)%j+A(j,264)%j+A(j,267)%j+A(j,275)%j+A(j,276)%j)*f(7)+CI*(A(j,103)%j+A(j,114)%j &
        +A(j,148)%j+A(j,169)%j+A(j,211)%j+A(j,223)%j+A(j,234)%j+A(j,243)%j+A(j,261)%j+A(j,265)%j+A(j,274)%j+A(j,283)%j)*f(8) &
        +(A(j,94)%j-A(j,95)%j+A(j,100)%j-A(j,101)%j+A(j,200)%j+A(j,201)%j+A(j,252)%j+A(j,254)%j+A(j,258)%j+A(j,294)%j+A(j,299)%j &
        +A(j,305)%j)*f(9)+CI*(A(j,202)%j+A(j,209)%j+A(j,250)%j+A(j,257)%j+A(j,292)%j+A(j,300)%j)*f(10)+(A(j,113)%j+A(j,119)%j &
        +A(j,132)%j+A(j,137)%j+A(j,149)%j+A(j,155)%j+A(j,168)%j+A(j,173)%j)*f(11)+CI*(A(j,108)%j+A(j,138)%j+A(j,156)%j+A(j,172)%j &
        +A(j,184)%j+A(j,191)%j)*f(12)+(-A(j,67)%j-A(j,68)%j-A(j,73)%j-A(j,74)%j)*f(13)+2*(A(j,69)%j+A(j,75)%j)*f(13) &
        +(19*(A(j,70)%j+A(j,71)%j+A(j,76)%j+A(j,77)%j)*f(14))/2._/**/REALKIND+18*(-A(j,72)%j-A(j,78)%j)*f(14)
  M2( 2)%j = (-A(j,122)%j+A(j,123)%j-A(j,125)%j+A(j,126)%j-A(j,158)%j+A(j,159)%j-A(j,161)%j+A(j,162)%j-A(j,310)%j-A(j,313)%j &
        -A(j,314)%j+A(j,340)%j+A(j,343)%j+A(j,345)%j+A(j,346)%j+A(j,348)%j+A(j,351)%j-A(j,365)%j-A(j,366)%j-A(j,369)%j+A(j,385)%j &
        +A(j,387)%j+A(j,390)%j+A(j,391)%j+A(j,392)%j+A(j,396)%j-A(j,412)%j-A(j,413)%j-A(j,414)%j-A(j,415)%j-A(j,416)%j &
        -A(j,417)%j)*f(3)+((-A(j,82)%j-A(j,83)%j)*f(4))/2._/**/REALKIND+CI*(A(j,307)%j+A(j,308)%j+A(j,309)%j-A(j,341)%j-A(j,342)%j &
        -A(j,344)%j-A(j,361)%j-A(j,362)%j-A(j,363)%j+A(j,393)%j+A(j,394)%j+A(j,395)%j+A(j,424)%j+A(j,425)%j+A(j,426)%j-A(j,433)%j &
        -A(j,434)%j-A(j,435)%j)*f(5)+(CI*(-A(j,58)%j-A(j,60)%j+A(j,61)%j+A(j,63)%j)*f(6))/2._/**/REALKIND+(A(j,92)%j-A(j,93)%j &
        +A(j,98)%j-A(j,99)%j+A(j,104)%j+A(j,107)%j+A(j,147)%j+A(j,163)%j+A(j,180)%j+A(j,181)%j-A(j,215)%j-A(j,217)%j+A(j,224)%j &
        +A(j,239)%j+A(j,240)%j-A(j,262)%j-A(j,264)%j+A(j,270)%j+A(j,277)%j+A(j,278)%j)*f(7)+CI*(-A(j,103)%j+A(j,118)%j+A(j,145)%j &
        -A(j,169)%j+A(j,214)%j-A(j,223)%j+A(j,231)%j-A(j,243)%j-A(j,265)%j+A(j,268)%j-A(j,274)%j+A(j,286)%j)*f(8)+(A(j,95)%j &
        -A(j,96)%j+A(j,101)%j-A(j,102)%j+A(j,198)%j+A(j,199)%j+A(j,249)%j-A(j,256)%j-A(j,258)%j+A(j,293)%j-A(j,303)%j &
        -A(j,305)%j)*f(9)+CI*(-A(j,202)%j+A(j,205)%j+A(j,247)%j-A(j,257)%j-A(j,292)%j+A(j,304)%j)*f(10)+(-A(j,117)%j-A(j,119)%j &
        -A(j,132)%j-A(j,134)%j-A(j,153)%j-A(j,155)%j-A(j,168)%j-A(j,170)%j)*f(11)+CI*(-A(j,108)%j+A(j,135)%j-A(j,156)%j+A(j,165)%j &
        -A(j,184)%j+A(j,187)%j)*f(12)+2*(A(j,67)%j+A(j,73)%j)*f(13)+(-A(j,68)%j-A(j,69)%j-A(j,74)%j-A(j,75)%j)*f(13)+18*( &
        -A(j,70)%j-A(j,76)%j)*f(14)+(19*(A(j,71)%j+A(j,72)%j+A(j,77)%j+A(j,78)%j)*f(14))/2._/**/REALKIND
  M2( 3)%j = (A(j,121)%j-A(j,123)%j+A(j,124)%j-A(j,126)%j+A(j,157)%j-A(j,159)%j+A(j,160)%j-A(j,162)%j-A(j,320)%j-A(j,321)%j &
        -A(j,324)%j+A(j,328)%j+A(j,331)%j+A(j,333)%j-A(j,340)%j-A(j,343)%j-A(j,345)%j+A(j,373)%j+A(j,375)%j+A(j,378)%j-A(j,379)%j &
        -A(j,382)%j-A(j,383)%j-A(j,385)%j-A(j,387)%j-A(j,390)%j-A(j,436)%j-A(j,437)%j-A(j,438)%j-A(j,439)%j-A(j,440)%j &
        -A(j,441)%j)*f(3)+((-A(j,85)%j-A(j,88)%j)*f(4))/2._/**/REALKIND+CI*(-A(j,316)%j-A(j,317)%j-A(j,318)%j+A(j,329)%j &
        +A(j,330)%j+A(j,332)%j+A(j,370)%j+A(j,371)%j+A(j,372)%j-A(j,386)%j-A(j,388)%j-A(j,389)%j-A(j,442)%j-A(j,443)%j-A(j,444)%j &
        +A(j,445)%j+A(j,446)%j+A(j,447)%j)*f(5)+(CI*(A(j,56)%j-A(j,57)%j-A(j,63)%j+A(j,66)%j)*f(6))/2._/**/REALKIND+(-A(j,91)%j &
        +A(j,93)%j-A(j,97)%j+A(j,99)%j+A(j,111)%j+A(j,127)%j+A(j,151)%j+A(j,167)%j+A(j,188)%j+A(j,189)%j-A(j,212)%j+A(j,215)%j &
        +A(j,222)%j+A(j,236)%j+A(j,237)%j-A(j,259)%j+A(j,262)%j+A(j,266)%j+A(j,280)%j+A(j,281)%j)*f(7)+CI*(A(j,109)%j-A(j,114)%j &
        -A(j,148)%j+A(j,154)%j-A(j,211)%j+A(j,220)%j-A(j,234)%j+A(j,238)%j-A(j,261)%j+A(j,263)%j+A(j,279)%j-A(j,283)%j)*f(8)+( &
        -A(j,94)%j+A(j,96)%j-A(j,100)%j+A(j,102)%j+A(j,206)%j+A(j,207)%j-A(j,252)%j+A(j,253)%j+A(j,256)%j+A(j,297)%j-A(j,299)%j &
        +A(j,303)%j)*f(9)+CI*(A(j,208)%j-A(j,209)%j-A(j,250)%j+A(j,255)%j+A(j,295)%j-A(j,300)%j)*f(10)+(-A(j,113)%j+A(j,117)%j &
        +A(j,134)%j-A(j,137)%j-A(j,149)%j+A(j,153)%j+A(j,170)%j-A(j,173)%j)*f(11)+CI*(A(j,129)%j-A(j,138)%j+A(j,171)%j-A(j,172)%j &
        +A(j,190)%j-A(j,191)%j)*f(12)+2*(A(j,68)%j+A(j,74)%j)*f(13)+(-A(j,67)%j-A(j,69)%j-A(j,73)%j-A(j,75)%j)*f(13)+18*( &
        -A(j,71)%j-A(j,77)%j)*f(14)+(19*(A(j,70)%j+A(j,72)%j+A(j,76)%j+A(j,78)%j)*f(14))/2._/**/REALKIND
  M2( 4)%j = (-A(j,122)%j+A(j,123)%j-A(j,125)%j+A(j,126)%j-A(j,158)%j+A(j,159)%j-A(j,161)%j+A(j,162)%j-A(j,319)%j-A(j,322)%j &
        -A(j,323)%j+A(j,340)%j+A(j,343)%j+A(j,345)%j+A(j,346)%j+A(j,348)%j+A(j,351)%j-A(j,356)%j-A(j,357)%j-A(j,360)%j+A(j,385)%j &
        +A(j,387)%j+A(j,390)%j+A(j,391)%j+A(j,392)%j+A(j,396)%j-A(j,397)%j-A(j,398)%j-A(j,399)%j-A(j,400)%j-A(j,401)%j &
        -A(j,402)%j)*f(3)+((-A(j,79)%j-A(j,86)%j)*f(4))/2._/**/REALKIND+CI*(A(j,316)%j+A(j,317)%j+A(j,318)%j-A(j,347)%j-A(j,349)%j &
        -A(j,350)%j-A(j,352)%j-A(j,353)%j-A(j,354)%j+A(j,386)%j+A(j,388)%j+A(j,389)%j-A(j,409)%j-A(j,410)%j-A(j,411)%j+A(j,442)%j &
        +A(j,443)%j+A(j,444)%j)*f(5)+(CI*(A(j,57)%j+A(j,59)%j-A(j,62)%j-A(j,64)%j)*f(6))/2._/**/REALKIND+(A(j,92)%j-A(j,93)%j &
        +A(j,98)%j-A(j,99)%j+A(j,110)%j+A(j,128)%j+A(j,141)%j+A(j,142)%j+A(j,175)%j+A(j,176)%j-A(j,215)%j-A(j,217)%j+A(j,221)%j &
        +A(j,229)%j+A(j,230)%j-A(j,262)%j-A(j,264)%j+A(j,273)%j+A(j,287)%j+A(j,288)%j)*f(7)+CI*(-A(j,109)%j+A(j,133)%j+A(j,139)%j &
        -A(j,154)%j+A(j,216)%j-A(j,220)%j+A(j,226)%j-A(j,238)%j-A(j,263)%j+A(j,271)%j-A(j,279)%j+A(j,291)%j)*f(8)+(A(j,95)%j &
        -A(j,96)%j+A(j,101)%j-A(j,102)%j+A(j,193)%j+A(j,194)%j+A(j,246)%j-A(j,256)%j-A(j,258)%j+A(j,296)%j-A(j,303)%j &
        -A(j,305)%j)*f(9)+CI*(A(j,197)%j-A(j,208)%j+A(j,244)%j-A(j,255)%j-A(j,295)%j+A(j,306)%j)*f(10)+(-A(j,117)%j-A(j,119)%j &
        -A(j,132)%j-A(j,134)%j-A(j,153)%j-A(j,155)%j-A(j,168)%j-A(j,170)%j)*f(11)+CI*(A(j,120)%j-A(j,129)%j+A(j,144)%j-A(j,171)%j &
        +A(j,179)%j-A(j,190)%j)*f(12)+2*(A(j,67)%j+A(j,73)%j)*f(13)+(-A(j,68)%j-A(j,69)%j-A(j,74)%j-A(j,75)%j)*f(13)+18*( &
        -A(j,70)%j-A(j,76)%j)*f(14)+(19*(A(j,71)%j+A(j,72)%j+A(j,77)%j+A(j,78)%j)*f(14))/2._/**/REALKIND
  M2( 5)%j = (A(j,121)%j-A(j,123)%j+A(j,124)%j-A(j,126)%j+A(j,157)%j-A(j,159)%j+A(j,160)%j-A(j,162)%j+A(j,328)%j+A(j,331)%j &
        +A(j,333)%j-A(j,335)%j-A(j,336)%j-A(j,339)%j-A(j,340)%j-A(j,343)%j-A(j,345)%j-A(j,364)%j-A(j,367)%j-A(j,368)%j+A(j,373)%j &
        +A(j,375)%j+A(j,378)%j-A(j,385)%j-A(j,387)%j-A(j,390)%j-A(j,427)%j-A(j,428)%j-A(j,429)%j-A(j,430)%j-A(j,431)%j &
        -A(j,432)%j)*f(3)+((-A(j,84)%j-A(j,89)%j)*f(4))/2._/**/REALKIND+CI*(-A(j,325)%j-A(j,326)%j-A(j,327)%j+A(j,341)%j &
        +A(j,342)%j+A(j,344)%j+A(j,361)%j+A(j,362)%j+A(j,363)%j-A(j,374)%j-A(j,376)%j-A(j,377)%j+A(j,433)%j+A(j,434)%j+A(j,435)%j &
        -A(j,448)%j-A(j,449)%j-A(j,450)%j)*f(5)+(CI*(-A(j,55)%j+A(j,58)%j+A(j,64)%j-A(j,65)%j)*f(6))/2._/**/REALKIND+(-A(j,91)%j &
        +A(j,93)%j-A(j,97)%j+A(j,99)%j+A(j,116)%j+A(j,130)%j+A(j,146)%j+A(j,164)%j+A(j,185)%j+A(j,186)%j-A(j,212)%j+A(j,215)%j &
        +A(j,219)%j+A(j,232)%j+A(j,233)%j-A(j,259)%j+A(j,262)%j+A(j,269)%j+A(j,284)%j+A(j,285)%j)*f(7)+CI*(A(j,112)%j-A(j,118)%j &
        -A(j,145)%j+A(j,150)%j+A(j,213)%j-A(j,214)%j-A(j,231)%j+A(j,235)%j+A(j,260)%j-A(j,268)%j+A(j,282)%j-A(j,286)%j)*f(8)+( &
        -A(j,94)%j+A(j,96)%j-A(j,100)%j+A(j,102)%j+A(j,203)%j+A(j,204)%j+A(j,248)%j-A(j,252)%j+A(j,256)%j-A(j,299)%j+A(j,302)%j &
        +A(j,303)%j)*f(9)+CI*(-A(j,205)%j+A(j,210)%j-A(j,247)%j+A(j,251)%j+A(j,298)%j-A(j,304)%j)*f(10)+(-A(j,113)%j+A(j,117)%j &
        +A(j,134)%j-A(j,137)%j-A(j,149)%j+A(j,153)%j+A(j,170)%j-A(j,173)%j)*f(11)+CI*(-A(j,135)%j+A(j,136)%j-A(j,165)%j+A(j,174)%j &
        -A(j,187)%j+A(j,192)%j)*f(12)+2*(A(j,68)%j+A(j,74)%j)*f(13)+(-A(j,67)%j-A(j,69)%j-A(j,73)%j-A(j,75)%j)*f(13)+18*( &
        -A(j,71)%j-A(j,77)%j)*f(14)+(19*(A(j,70)%j+A(j,72)%j+A(j,76)%j+A(j,78)%j)*f(14))/2._/**/REALKIND
  M2( 6)%j = (-A(j,121)%j+A(j,122)%j-A(j,124)%j+A(j,125)%j-A(j,157)%j+A(j,158)%j-A(j,160)%j+A(j,161)%j-A(j,328)%j-A(j,331)%j &
        -A(j,333)%j-A(j,334)%j-A(j,337)%j-A(j,338)%j-A(j,346)%j-A(j,348)%j-A(j,351)%j-A(j,355)%j-A(j,358)%j-A(j,359)%j-A(j,373)%j &
        -A(j,375)%j-A(j,378)%j-A(j,391)%j-A(j,392)%j-A(j,396)%j-A(j,403)%j-A(j,404)%j-A(j,405)%j-A(j,406)%j-A(j,407)%j &
        -A(j,408)%j)*f(3)+((-A(j,80)%j-A(j,90)%j)*f(4))/2._/**/REALKIND+CI*(A(j,325)%j+A(j,326)%j+A(j,327)%j+A(j,347)%j+A(j,349)%j &
        +A(j,350)%j+A(j,352)%j+A(j,353)%j+A(j,354)%j+A(j,374)%j+A(j,376)%j+A(j,377)%j+A(j,409)%j+A(j,410)%j+A(j,411)%j+A(j,448)%j &
        +A(j,449)%j+A(j,450)%j)*f(5)+(CI*(A(j,55)%j+A(j,60)%j+A(j,62)%j-A(j,66)%j)*f(6))/2._/**/REALKIND+(A(j,91)%j-A(j,92)%j &
        +A(j,97)%j-A(j,98)%j+A(j,115)%j+A(j,131)%j+A(j,140)%j+A(j,143)%j+A(j,177)%j+A(j,178)%j+A(j,212)%j+A(j,217)%j+A(j,218)%j &
        +A(j,227)%j+A(j,228)%j+A(j,259)%j+A(j,264)%j+A(j,272)%j+A(j,289)%j+A(j,290)%j)*f(7)+CI*(-A(j,112)%j-A(j,133)%j-A(j,139)%j &
        -A(j,150)%j-A(j,213)%j-A(j,216)%j-A(j,226)%j-A(j,235)%j-A(j,260)%j-A(j,271)%j-A(j,282)%j-A(j,291)%j)*f(8)+(A(j,94)%j &
        -A(j,95)%j+A(j,100)%j-A(j,101)%j+A(j,195)%j+A(j,196)%j+A(j,245)%j+A(j,252)%j+A(j,258)%j+A(j,299)%j+A(j,301)%j &
        +A(j,305)%j)*f(9)+CI*(-A(j,197)%j-A(j,210)%j-A(j,244)%j-A(j,251)%j-A(j,298)%j-A(j,306)%j)*f(10)+(A(j,113)%j+A(j,119)%j &
        +A(j,132)%j+A(j,137)%j+A(j,149)%j+A(j,155)%j+A(j,168)%j+A(j,173)%j)*f(11)+CI*(-A(j,120)%j-A(j,136)%j-A(j,144)%j-A(j,174)%j &
        -A(j,179)%j-A(j,192)%j)*f(12)+(-A(j,67)%j-A(j,68)%j-A(j,73)%j-A(j,74)%j)*f(13)+2*(A(j,69)%j+A(j,75)%j)*f(13) &
        +(19*(A(j,70)%j+A(j,71)%j+A(j,76)%j+A(j,77)%j)*f(14))/2._/**/REALKIND+18*(-A(j,72)%j-A(j,78)%j)*f(14)
  M2( 7)%j = ((A(j,87)%j+A(j,88)%j+A(j,89)%j+A(j,90)%j)*f(4))/6._/**/REALKIND+(2*(-A(j,70)%j-A(j,71)%j-A(j,72)%j-A(j,76)%j &
        -A(j,77)%j-A(j,78)%j)*f(14))/3._/**/REALKIND
  M2( 8)%j = ((A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j)*f(4))/6._/**/REALKIND+(2*(-A(j,70)%j-A(j,71)%j-A(j,72)%j-A(j,76)%j &
        -A(j,77)%j-A(j,78)%j)*f(14))/3._/**/REALKIND
  M2( 9)%j = ((A(j,79)%j+A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(4))/6._/**/REALKIND+(2*(-A(j,70)%j-A(j,71)%j-A(j,72)%j-A(j,76)%j &
        -A(j,77)%j-A(j,78)%j)*f(14))/3._/**/REALKIND
  M2(10)%j = (CI*(A(j,55)%j+A(j,56)%j-A(j,57)%j-A(j,58)%j+A(j,61)%j+A(j,62)%j)*f(6))/6._/**/REALKIND+((-A(j,70)%j-A(j,71)%j &
        -A(j,72)%j-A(j,76)%j-A(j,77)%j-A(j,78)%j)*f(14))/3._/**/REALKIND
  M2(11)%j = (CI*(-A(j,55)%j-A(j,56)%j+A(j,57)%j+A(j,58)%j-A(j,61)%j-A(j,62)%j)*f(6))/6._/**/REALKIND+((-A(j,70)%j-A(j,71)%j &
        -A(j,72)%j-A(j,76)%j-A(j,77)%j-A(j,78)%j)*f(14))/3._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(11)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 11
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 1-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
	      M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppattj_ttxaggg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(11)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 11 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppattj_ttxaggg_1_/**/REALKIND
