
module ol_vamp_1_ppajjj_uuxccxag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajjj_uuxccxag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajjj_uuxccxag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajjj_uuxccxag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppajjj_uuxccxag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajjj_uuxccxag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajjj_uuxccxag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,2,1,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,1,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(3))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,2,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(4))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,1,2,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,1,2,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,1,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(5))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,8,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(6))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,16,1,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,4,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(7))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,4,16,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(8))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(9))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,4,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(10))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,16,1,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,1,8,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(11))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,1,8,16,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(12))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,16,2,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,16,2,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_V(ntryL,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_VA_Q(ntryL,G1H32(3),ex2(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(3),34,0,G2H16(1),n2h16(1))
  call Hloop_QA_V(ntryL,G1H32(4),ex4(:),G1H16(3),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_V(ntryL,G1H32(5),ex3(:),G1H16(4),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_VA_Q(ntryL,G1H32(6),ex2(:),G1H16(5),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(5),34,0,G2H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G1H32(7),ex1(:),G1H16(5),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(5),33,0,G2H16(3),n2h16(3))
  call Hloop_VQ_A(ntryL,G1H32(8),ex1(:),G1H16(5),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(5),33,0,G2H16(4),n2h16(4))
  call Hloop_AQ_V(ntryL,G1H32(9),ex3(:),G1H16(5),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_QA_V(ntryL,G1H32(10),ex2(:),G1H16(6),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_VA_Q(ntryL,G1H32(11),ex2(:),G1H16(7),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(7),34,0,G2H16(5),n2h16(5))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(7),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G1H32(13),ex1(:),G1H16(8),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex3(:),G1H16(9),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_QA_V(ntryL,G1H32(15),ex2(:),G1H16(10),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_VA_Q(ntryL,G1H32(16),ex2(:),G1H16(11),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(11),34,0,G2H16(6),n2h16(6))
  call Hloop_AQ_V(ntryL,G1H32(17),ex1(:),G1H16(11),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_V(ntryL,G1H32(18),ex1(:),G1H16(12),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(13),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(13),33,0,G2H16(7),n2h16(7))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(13),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(13),33,0,G2H16(8),n2h16(8))
  call Hloop_VA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(4),n2h8(3))
  call Hloop_VA_Q(ntryL,G1H16(4),ex2(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(5),n2h8(4))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(3),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_V(ntryL,G2H16(4),ex2(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(9),n2h8(5))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(10),n2h8(6))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(1),mass5set(:,1),  & 
G1H16(13),G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(11),n2h8(7))
  call Hloop_VQ_A(ntryL,G1H16(8),ex3(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(12),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(13),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(10),ex3(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),38,0,G2H8(14),n2h8(10))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(1),mass5set(:,1),  & 
G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(14),16)
  call HG1shiftOLR(G1H16(7),4,16)
  call Hloop_VA_Q(ntryL,G1H16(11),ex4(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(15),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex4(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(16),n2h8(12))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(11),G1H16(12),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(12),8,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),4,16)
  call Hloop_AV_Q(ntryL,G1H16(13),ex5(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(17),n2h8(13))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AV_Q(ntryL,G1H16(3),ex5(:),G1H8(2),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(18),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(4),ex5(:),G1H8(2),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(19),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(5),ex5(:),G1H8(2),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(20),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(2),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(21),n2h8(17))
call HGT_raise_alpha_OLR(G1H16(7),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(2),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AV_Q(ntryL,G1H16(9),ex5(:),G1H8(3),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(22),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(3),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(23),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(14),ex5(:),G1H8(3),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(24),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(3),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(25),n2h8(21))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(12),ex4(:),G1H8(3),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(4),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(26),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(4),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(27),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(18),ex5(:),G1H8(4),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(28),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(19),ex5(:),G1H8(4),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(29),n2h8(25))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(4),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(5),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(30),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(5),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(31),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(5),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(32),n2h8(28))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(3),mass5set(:,1),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(4),mass5set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(12),4,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(5),mass5set(:,1),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(6),mass5set(:,1),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(24),4,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(7),mass5set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(30),8,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(11),ex4(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(8),mass5set(:,1),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(36),2,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(9),mass5set(:,1),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hloop_QA_V(ntryL,G2H8(14),ex4(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(15),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(10),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),2,8)
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G2H8(20),ex1(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G2H8(21),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G2H8(23),ex1(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G2H8(24),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(25),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_V(ntryL,G2H8(28),ex2(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_V(ntryL,G2H8(29),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G2H8(32),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(21),n2h4(1))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(9),ex3(:),G1H4(2),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(22),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(10),ex3(:),G1H4(2),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(23),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(11),ex4(:),G1H4(2),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(2),43,0,G2H4(24),n2h4(4))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(2),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(3),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(3),43,0,G2H4(25),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(16),ex4(:),G1H4(3),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(3),43,0,G2H4(26),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(17),ex3(:),G1H4(3),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(27),n2h4(7))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(3),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_VQ_A(ntryL,G1H8(21),ex3(:),G1H4(4),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(28),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(22),ex3(:),G1H4(4),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(29),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(4),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(4),43,0,G2H4(30),n2h4(10))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex3(:),G1H4(4),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_VA_Q(ntryL,G1H8(27),ex4(:),G1H4(5),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(5),43,0,G2H4(31),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(28),ex4(:),G1H4(5),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(5),43,0,G2H4(32),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(29),ex5(:),G1H4(5),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(33),n2h4(13))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(30),-8,0,G2H8(1),n2h8(33))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(34),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(5),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(35),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(34),ex5(:),G1H4(5),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(36),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(5),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(37),n2h4(16))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-2,0,G2H8(2),n2h8(34))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(38),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(5),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(39),n2h4(17))
  call Hloop_QV_A(ntryL,G1H8(40),ex5(:),G1H4(5),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(40),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(5),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(41),n2h4(19))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(42),-8,0,G2H8(3),n2h8(35))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(42),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AV_Q(ntryL,G1H8(45),ex5(:),G1H4(5),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(43),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(46),ex5(:),G1H4(5),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(44),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(5),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(5),57,0,G2H4(45),n2h4(22))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-2,0,G2H8(4),n2h8(36))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(46),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(51),ex5(:),G1H4(5),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(5),57,0,G2H4(47),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H8(52),ex5(:),G1H4(5),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(5),57,0,G2H4(48),n2h4(24))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(11),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(12),mass5set(:,1),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(13),mass5set(:,1),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(14),mass5set(:,1),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(15),mass5set(:,1),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(16),mass5set(:,1),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(17),mass5set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(18),mass5set(:,1),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(1),mass5set(:,1),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(19),mass5set(:,1),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(1),mass5set(:,1),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(20),mass5set(:,1),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,1),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(21),mass5set(:,1),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(2),mass5set(:,1),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(22),mass5set(:,1),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(3),mass5set(:,1),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),8,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(23),mass5set(:,1),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(4),mass5set(:,1),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(24),mass5set(:,1),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),4,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(5),mass5set(:,1),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),8,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(25),mass5set(:,1),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(6),mass5set(:,1),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),4,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(26),mass5set(:,1),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),4,4)
  call Hloop_QA_V(ntryL,G2H4(33),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(36),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(37),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(40),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(41),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(44),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(45),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(48),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(142)])
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(9),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(6),-16,0,G2H4(1),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(11),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(12),n2h2(3))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-16,0,G2H4(2),n2h4(26))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(14),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(15),n2h2(5))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-16,0,G2H4(3),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(22),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(18),n2h2(7))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-16,0,G2H4(4),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(28),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(29),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(21),n2h2(9))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-16,0,G2H4(5),n2h4(29))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(34),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(10))
  call Hloop_VA_Q(ntryL,G1H4(35),ex2(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(24),n2h2(11))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(36),-16,0,G2H4(6),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_VA_Q(ntryL,G1H4(40),ex2(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(26),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(27),n2h2(13))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(42),-16,0,G2H4(7),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(7),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(46),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(30),n2h2(15))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-16,0,G2H4(8),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VA_Q(ntryL,G1H4(52),ex2(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(32),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(53),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(33),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VQ_A(ntryL,G1H4(59),ex3(:),G1H2(2),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(34),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(60),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(60),ex4(:),G1H2(2),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VQ_A(ntryL,G1H4(64),ex3(:),G1H2(3),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(35),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(65),ex4(:),G1H2(3),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(36),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(66),ex3(:),G1H2(3),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(71),ex4(:),G1H2(4),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(4),59,0,G2H2(37),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(72),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(72),ex3(:),G1H2(4),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VA_Q(ntryL,G1H4(76),ex4(:),G1H2(5),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(5),59,0,G2H2(38),n2h2(22))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(5),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(39),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(78),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(78),ex4(:),G1H2(5),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(83),ex3(:),G1H2(6),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(40),n2h2(24))
call HGT_raise_alpha_OLR(G1H4(84),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(6),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(88),ex3(:),G1H2(7),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(41),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(89),ex4(:),G1H2(7),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(7),59,0,G2H2(42),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(90),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(90),ex3(:),G1H2(7),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VA_Q(ntryL,G1H4(95),ex4(:),G1H2(8),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(8),59,0,G2H2(43),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(96),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(96),ex3(:),G1H2(8),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_VA_Q(ntryL,G1H4(100),ex4(:),G1H2(9),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(9),59,0,G2H2(44),n2h2(28))
  call Hloop_QV_A(ntryL,G1H4(101),ex5(:),G1H2(9),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(45),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(102),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(9),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(107),ex5(:),G1H2(10),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(10),55,0,G2H2(46),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(108),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(108),ex4(:),G1H2(10),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_QV_A(ntryL,G1H4(112),ex5(:),G1H2(11),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(47),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H4(113),ex5(:),G1H2(11),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(11),59,0,G2H2(48),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(114),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(114),ex3(:),G1H2(11),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(119),ex5(:),G1H2(12),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(12),59,0,G2H2(49),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(120),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(120),ex3(:),G1H2(12),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AV_Q(ntryL,G1H4(124),ex5(:),G1H2(13),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(13),59,0,G2H2(50),n2h2(34))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(13),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(13),55,0,G2H2(51),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(126),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(126),ex4(:),G1H2(13),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(131),ex5(:),G1H2(14),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(14),55,0,G2H2(52),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(132),ex4(:),G1H2(14),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(136),ex5(:),G1H2(15),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(53),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H4(137),ex5(:),G1H2(15),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(15),59,0,G2H2(54),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(138),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(138),ex3(:),G1H2(15),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AV_Q(ntryL,G1H4(143),ex5(:),G1H2(16),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(16),59,0,G2H2(55),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(144),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(144),ex3(:),G1H2(16),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AV_Q(ntryL,G1H4(148),ex5(:),G1H2(17),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(17),59,0,G2H2(56),n2h2(40))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,1),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(8),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),2,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,1),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),2,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(11),mass5set(:,1),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(12),mass5set(:,1),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(13),mass5set(:,1),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(14),mass5set(:,1),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(15),mass5set(:,1),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(16),mass5set(:,1),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(17),mass5set(:,1),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(18),mass5set(:,1),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(12),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(16),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(5),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(6),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(11),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(12),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(13),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(14),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(15),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(16),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(17),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(18),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(13))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(14))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(15))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(16))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(17))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(18))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(20))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(21))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(22))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(23))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(24))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(25))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(26))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(27))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(28))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,4,8,17],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(29))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,8,4,2,17],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,2,17,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(30))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,8,4,17],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(31))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,8,2,17],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,17,2,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(32))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,2,17,8,4],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,2,17,4,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,4,8,18],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,4,1,18],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,1,18,8],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(34))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,8,4,18],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(35))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,8,1,18],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,4,18,1,8],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(36))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,18,8,4],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,18,4,8],[0,0,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(42),n2h32(37))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(38))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(39))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(40))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(50),n2h32(41))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(51),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(42))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(43))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(44))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[33,8,4,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[33,2,4,16,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[33,4,8,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(2),m3h4x16(:,3),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[33,2,8,16,4],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(1),n2h16(14))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[34,8,4,1,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,5),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[34,1,4,16,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,6),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(3),n2h16(15))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[34,4,8,1,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,7),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[34,1,8,16,4],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,8),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(5),34,0,G1H16(4),n2h16(16))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,9),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,10),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,11),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,12),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,13),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,14),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,15),heltab2x64(:,:,91))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,16),heltab2x64(:,:,92))
  call Hloop_AV_Q(ntryL,G1H16(2),ex5(:),G1H8(5),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(5),50,0,G2H8(5),n2h8(37))
  call Hloop_AV_Q(ntryL,G1H16(8),ex5(:),G1H8(6),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(6),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(15),ex5(:),G1H8(9),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(9),49,0,G2H8(7),n2h8(39))
  call Hloop_QV_A(ntryL,G1H16(21),ex5(:),G1H8(10),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(10),49,0,G2H8(8),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(11),m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(11),35,0,G2H8(9),n2h8(41))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,1),G1H8(12),m3h4x8(:,2),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(12),35,0,G2H8(10),n2h8(42))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(15),m3h4x8(:,3),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(15),35,0,G2H8(11),n2h8(43))
  call Hloop_AQ_V(ntryL,G1H32(4),ex3(:),G1H16(5),m3h2x16(:,21),heltab2x32(:,:,24))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(16),m3h4x8(:,4),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(16),35,0,G2H8(12),n2h8(44))
  call Hloop_QA_V(ntryL,G1H32(6),ex4(:),G1H16(6),m3h2x16(:,22),heltab2x32(:,:,26))
  call Hloop_UV_W(ntryL,G1H32(7),32,wf4(:,1),3,G2H8(13),m3h4x8(:,5),heltab2x32(:,:,27))
  call Hloop_VQ_A(ntryL,G1H32(8),ex3(:),G1H16(7),m3h2x16(:,23),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(7),36,0,G2H16(1),n2h16(17))
  call Hloop_UV_W(ntryL,G1H32(9),32,wf4(:,1),3,G2H8(14),m3h4x8(:,6),heltab2x32(:,:,29))
  call Hloop_QA_V(ntryL,G1H32(10),ex4(:),G1H16(9),m3h2x16(:,24),heltab2x32(:,:,30))
  call Hloop_VQ_A(ntryL,G1H32(11),ex3(:),G1H16(10),m3h2x16(:,25),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(10),36,0,G2H16(2),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H32(12),ex3(:),G1H16(14),m3h2x16(:,26),heltab2x32(:,:,32))
  call Hloop_QA_V(ntryL,G1H32(13),ex2(:),G1H16(11),m3h2x16(:,27),heltab2x32(:,:,33))
  call Hloop_QV_A(ntryL,G1H32(14),wf4(:,12),G1H8(17),m3h4x8(:,7),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(17),44,0,G2H8(15),n2h8(45))
  call Hloop_AQ_V(ntryL,G1H32(15),ex1(:),G1H16(12),m3h2x16(:,28),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(16),m3h2x16(:,29),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,12),G1H8(18),m3h4x8(:,8),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(16),n2h8(46))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(17),m3h2x16(:,30),heltab2x32(:,:,38))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(18),m3h2x16(:,31),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(18),33,0,G2H16(3),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(19),m3h2x16(:,32),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(19),33,0,G2H16(4),n2h16(20))
  call Hloop_VA_Q(ntryL,G1H32(21),ex2(:),G1H16(20),m3h2x16(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(20),34,0,G2H16(5),n2h16(21))
  call Hloop_QA_V(ntryL,G1H32(22),ex2(:),G1H16(22),m3h2x16(:,34),heltab2x32(:,:,42))
  call Hloop_VQ_A(ntryL,G1H32(23),ex1(:),G1H16(23),m3h2x16(:,35),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(6),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(24),m3h2x16(:,36),heltab2x32(:,:,44))
  call Hloop_QA_V(ntryL,G1H32(25),ex2(:),G1H16(2),m3h2x16(:,37),heltab2x32(:,:,45))
  call Hloop_VA_Q(ntryL,G1H32(26),ex4(:),G1H16(8),m3h2x16(:,38),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(8),40,0,G2H16(7),n2h16(23))
  call Hloop_AQ_V(ntryL,G1H32(27),ex3(:),G1H16(15),m3h2x16(:,39),heltab2x32(:,:,47))
  call Hloop_QA_V(ntryL,G1H32(28),ex2(:),G1H16(21),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_VQ_A(ntryL,G1H32(29),ex3(:),G1H16(7),m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(7),36,0,G2H16(8),n2h16(24))
  call Hloop_AQ_V(ntryL,G1H32(30),ex3(:),G1H16(10),m3h2x16(:,42),heltab2x32(:,:,50))
  call Hloop_VA_Q(ntryL,G1H32(31),ex2(:),G1H16(18),m3h2x16(:,43),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H16(18),34,0,G2H16(9),n2h16(25))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(19),m3h2x16(:,44),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(10),n2h16(26))
  call Hloop_AQ_V(ntryL,G1H32(33),ex1(:),G1H16(20),m3h2x16(:,45),heltab2x32(:,:,53))
  call Hloop_VA_Q(ntryL,G1H32(34),ex4(:),G1H16(23),m3h2x16(:,46),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(23),40,0,G2H16(11),n2h16(27))
  call Hloop_AQ_V(ntryL,G1H32(35),ex3(:),G1H16(8),m3h2x16(:,47),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(7),m3h2x16(:,48),heltab2x32(:,:,56))
  call Hloop_VQ_A(ntryL,G1H32(37),ex3(:),G1H16(18),m3h2x16(:,49),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H16(18),36,0,G2H16(12),n2h16(28))
  call Hloop_AQ_V(ntryL,G1H32(38),ex3(:),G1H16(19),m3h2x16(:,50),heltab2x32(:,:,58))
  call Hloop_VQ_A(ntryL,G1H32(39),ex1(:),G1H16(23),m3h2x16(:,51),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(13),n2h16(29))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(18),m3h2x16(:,52),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(18),33,0,G2H16(14),n2h16(30))
  call Hloop_VA_Q(ntryL,G1H32(41),ex2(:),G1H16(23),m3h2x16(:,53),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(23),34,0,G2H16(15),n2h16(31))
  call Hloop_QA_V(ntryL,G1H32(42),ex4(:),G1H16(18),m3h2x16(:,54),heltab2x32(:,:,62))
  call Hloop_VQ_A(ntryL,G1H32(43),ex1(:),G1H16(23),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(16),n2h16(32))
  call Hloop_VQ_A(ntryL,G1H32(44),ex1(:),G1H16(23),m3h2x16(:,56),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(17),n2h16(33))
  call Hloop_QA_V(ntryL,G1H32(45),ex4(:),G1H16(23),m3h2x16(:,57),heltab2x32(:,:,65))
  call Hloop_VA_Q(ntryL,G1H32(46),ex2(:),G1H16(25),m3h2x16(:,58),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(25),34,0,G2H16(18),n2h16(34))
  call Hloop_AQ_V(ntryL,G1H32(47),ex1(:),G1H16(25),m3h2x16(:,59),heltab2x32(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(26),m3h2x16(:,60),heltab2x32(:,:,68))
  call Hloop_VA_Q(ntryL,G1H32(49),ex2(:),G1H16(27),m3h2x16(:,61),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(27),34,0,G2H16(19),n2h16(35))
  call Hloop_AQ_V(ntryL,G1H32(50),ex3(:),G1H16(27),m3h2x16(:,62),heltab2x32(:,:,70))
  call Hloop_VQ_A(ntryL,G1H32(51),ex1(:),G1H16(28),m3h2x16(:,63),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(28),33,0,G2H16(20),n2h16(36))
  call Hloop_VQ_A(ntryL,G1H32(52),ex1(:),G1H16(28),m3h2x16(:,64),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(28),33,0,G2H16(21),n2h16(37))
  call Hloop_AQ_V(ntryL,G1H32(53),ex3(:),G1H16(28),m3h2x16(:,65),heltab2x32(:,:,73))
  call Hloop_VA_Q(ntryL,G1H32(54),ex2(:),G1H16(29),m3h2x16(:,66),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(29),34,0,G2H16(22),n2h16(38))
  call Hloop_AQ_V(ntryL,G1H32(55),ex1(:),G1H16(29),m3h2x16(:,67),heltab2x32(:,:,75))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(30),m3h2x16(:,68),heltab2x32(:,:,76))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(1),41,0,G1H8(21),n2h8(47))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(22),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_VQ_A(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(23),n2h8(48))
  call Hloop_QA_V(ntryL,G1H16(1),ex2(:),G1H8(24),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_VA_Q(ntryL,G0H16(3),ex4(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(27),n2h8(49))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(28),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_VQ_A(ntryL,G0H16(4),ex3(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(1),38,0,G1H8(29),n2h8(50))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(30),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_VA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(33),n2h8(51))
  call Hloop_VQ_A(ntryL,G0H16(6),ex1(:),G0H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(34),n2h8(52))
  call Hloop_VA_Q(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(35),n2h8(53))
  call Hloop_VQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(36),n2h8(54))
  call Hloop_VA_Q(ntryL,G0H16(9),ex2(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(39),n2h8(55))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(40),n2h8(56))
  call Hloop_VA_Q(ntryL,G0H16(11),ex2(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(41),n2h8(57))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(42),n2h8(58))
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(43)])
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(35)])
call HGT_w2_OLR(G1H8(3),1,1,8)
call HGT_w2_invQ_OLR(G1H8(3),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(31)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(20),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(26),G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(25)])
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(58),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(58),58,0,G2H4(9),n2h4(49))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(11),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(70),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(70),54,0,G2H4(12),n2h4(50))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(14),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(82),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(82),57,0,G2H4(15),n2h4(51))
  call Hloop_QA_V(ntryL,G2H8(26),ex2(:),G2H4(17),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(94),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(94),53,0,G2H4(18),n2h4(52))
  call Hloop_QA_V(ntryL,G2H8(30),ex2(:),G2H4(20),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_VQ_A(ntryL,G1H8(28),ex3(:),G1H4(106),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(106),39,0,G2H4(21),n2h4(53))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(27),mass5set(:,1),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hloop_VA_Q(ntryL,G1H8(30),ex4(:),G1H4(118),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(118),43,0,G2H4(23),n2h4(54))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(28),mass5set(:,1),  & 
G1H8(5),G1H8(6),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(6),4,8)
  call Hloop_VQ_A(ntryL,G1H8(22),ex3(:),G1H4(130),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(130),39,0,G2H4(24),n2h4(55))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(142),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(142),43,0,G2H4(26),n2h4(56))
  call Hloop_QV_A(ntryL,G1H8(32),ex5(:),G1H4(5),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(27),n2h4(57))
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(6),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(6),53,0,G2H4(29),n2h4(58))
  call Hloop_QV_A(ntryL,G1H8(38),ex5(:),G1H4(10),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(10),53,0,G2H4(30),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H8(44),ex5(:),G1H4(11),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(11),54,0,G2H4(32),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H8(49),ex5(:),G1H4(12),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(12),57,0,G2H4(33),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(16),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(16),57,0,G2H4(36),n2h4(62))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(37),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(40),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(41),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_QA_V(ntryL,G2H8(8),ex2(:),G2H4(44),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(29),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(41),G1H8(43),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_QA_V(ntryL,G2H8(10),ex4(:),G2H4(45),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(30),mass5set(:,1),  & 
G1H8(35),G1H8(42),G1H8(31),G1H8(36),G1H8(7),G1H8(20),8)
  call HG1shiftOLR(G1H8(42),4,8)
  call Hloop_VA_Q(ntryL,G1H16(5),ex4(:),G1H8(8),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(8),44,0,G2H8(17),n2h8(59))
  call Hloop_AQ_V(ntryL,G2H8(12),ex3(:),G2H4(48),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(6),ex3(:),G1H8(13),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(13),44,0,G2H8(19),n2h8(60))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(31),mass5set(:,1),  & 
G1H16(13),G1H16(1),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_UV_W(ntryL,G1H16(9),40,wf4(:,1),3,G2H4(1),m3h4x4(:,1),heltab2x16(:,:,59))
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(32),mass5set(:,1),  & 
G1H16(9),G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),16)
  call HG1shiftOLR(G1H16(31),8,16)
  call Hloop_UV_W(ntryL,G1H16(14),36,wf4(:,1),3,G2H4(2),m3h4x4(:,2),heltab2x16(:,:,60))
  call Hloop_VQ_A(ntryL,G1H16(11),ex1(:),G1H8(26),m3h2x8(:,59),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(26),35,0,G2H8(20),n2h8(61))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(3),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(14),m3h2x8(:,60),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(14),35,0,G2H8(21),n2h8(62))
  call Hloop_VA_Q(ntryL,G1H16(16),ex2(:),G1H8(19),m3h2x8(:,61),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(23),n2h8(63))
  call Hloop_AQ_V(ntryL,G2H8(16),ex1(:),G2H4(4),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VQ_A(ntryL,G1H16(17),ex1(:),G1H8(25),m3h2x8(:,62),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(25),35,0,G2H8(24),n2h8(64))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(2),mass5set(:,1),  & 
G1H16(14),G1H16(11),G1H16(12),G1H16(16),G1H16(17),G1H16(36),16)
  call HG1shiftOLR(G1H16(11),12,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(33),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),2,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(1),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),12,16)
  call Hloop_UV_W(ntryL,G1H16(22),34,wf4(:,12),12,G2H4(5),m3h4x4(:,3),heltab2x16(:,:,65))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(34),mass5set(:,1),  & 
G1H16(22),G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),16)
  call HG1shiftOLR(G1H16(49),2,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,wf4(:,12),12,G2H4(6),m3h4x4(:,4),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),38,0,G2H8(25),n2h8(65))
  call Hloop_AQ_V(ntryL,G2H16(7),ex3(:),G2H8(27),m3h2x8(:,64),heltab2x16(:,:,68))
  call Hloop_VA_Q(ntryL,G1H16(15),ex2(:),G1H8(2),m3h2x8(:,65),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(28),n2h8(66))
  call Hloop_VA_Q(ntryL,G1H16(21),ex4(:),G1H8(3),m3h2x8(:,66),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(3),42,0,G2H8(29),n2h8(67))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(31),m3h2x8(:,67),heltab2x16(:,:,71))
  call Hloop_VQ_A(ntryL,G1H16(10),wf4(:,13),G1H4(17),m3h4x4(:,5),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(17),53,0,G2H4(7),n2h4(63))
  call Hloop_AQ_V(ntryL,G2H16(9),wf4(:,13),G2H4(8),m3h4x4(:,6),heltab2x16(:,:,73))
  call Hloop_AQ_V(ntryL,G2H16(10),wf4(:,13),G2H4(49),m3h4x4(:,7),heltab2x16(:,:,74))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(4),m3h2x8(:,68),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(4),37,0,G2H8(32),n2h8(68))
  call Hloop_AQ_V(ntryL,G2H16(11),ex3(:),G2H8(1),m3h2x8(:,69),heltab2x16(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(28),m3h2x8(:,70),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(28),37,0,G2H8(2),n2h8(69))
  call Hloop_VA_Q(ntryL,G1H16(7),ex4(:),G1H8(30),m3h2x8(:,71),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(30),41,0,G2H8(3),n2h8(70))
  call Hloop_QA_V(ntryL,G2H16(12),ex4(:),G2H8(4),m3h2x8(:,72),heltab2x16(:,:,79))
  call Hloop_VA_Q(ntryL,G1H16(19),wf4(:,18),G1H4(18),m3h4x4(:,8),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(50),n2h4(64))
  call Hloop_QA_V(ntryL,G2H16(13),wf4(:,18),G2H4(51),m3h4x4(:,9),heltab2x16(:,:,81))
  call Hloop_QA_V(ntryL,G2H16(14),wf4(:,18),G2H4(52),m3h4x4(:,10),heltab2x16(:,:,82))
  call Hloop_AQ_V(ntryL,G2H16(15),ex1(:),G2H8(18),m3h2x8(:,73),heltab2x16(:,:,83))
  call Hloop_VQ_A(ntryL,G1H16(18),ex1(:),G1H8(22),m3h2x8(:,74),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(22),41,0,G2H8(22),n2h8(71))
  call Hloop_QA_V(ntryL,G2H16(16),ex2(:),G2H8(26),m3h2x8(:,75),heltab2x16(:,:,85))
  call Hloop_QA_V(ntryL,G2H16(17),ex2(:),G2H8(30),m3h2x8(:,76),heltab2x16(:,:,86))
  call Hloop_VA_Q(ntryL,G1H16(23),ex2(:),G1H8(24),m3h2x8(:,77),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(24),42,0,G2H8(14),n2h8(72))
  call Hloop_AQ_V(ntryL,G2H16(18),ex1(:),G2H8(13),m3h2x8(:,78),heltab2x16(:,:,88))
  call Hloop_VA_Q(ntryL,G1H16(25),ex4(:),G1H8(32),m3h2x8(:,79),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(32),41,0,G2H8(5),n2h8(73))
  call Hloop_VQ_A(ntryL,G1H16(26),wf4(:,4),G1H4(22),m3h4x4(:,11),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(22),53,0,G2H4(53),n2h4(65))
  call Hloop_AQ_V(ntryL,G2H16(19),ex1(:),G2H8(6),m3h2x8(:,80),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G1H16(27),ex1(:),G1H8(37),m3h2x8(:,81),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(7),n2h8(74))
  call Hloop_QA_V(ntryL,G2H16(20),ex2(:),G2H8(8),m3h2x8(:,82),heltab2x16(:,:,93))
  call Hloop_QA_V(ntryL,G2H16(21),ex2(:),G2H8(9),m3h2x8(:,83),heltab2x16(:,:,94))
  call Hloop_VA_Q(ntryL,G1H16(28),ex2(:),G1H8(38),m3h2x8(:,84),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(38),38,0,G2H8(10),n2h8(75))
  call Hloop_AQ_V(ntryL,G2H16(22),ex1(:),G2H8(11),m3h2x8(:,85),heltab2x16(:,:,96))
  call Hloop_VQ_A(ntryL,G1H16(29),ex3(:),G1H8(44),m3h2x8(:,86),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(44),37,0,G2H8(12),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H16(30),wf4(:,9),G1H4(23),m3h4x4(:,12),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(23),57,0,G2H4(54),n2h4(66))
  call Hloop_AQ_V(ntryL,G1H8(21),ex3(:),G1H4(24),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_QA_V(ntryL,G1H8(23),ex4(:),G1H4(28),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AQ_V(ntryL,G1H8(27),ex3(:),G1H4(29),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_V(ntryL,G1H8(29),ex4(:),G1H4(30),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_AQ_V(ntryL,G1H8(33),ex1(:),G1H4(34),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_V(ntryL,G1H8(34),ex2(:),G1H4(35),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AQ_V(ntryL,G1H8(39),ex1(:),G1H4(36),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_V(ntryL,G1H8(40),ex2(:),G1H4(40),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_VQ_A(ntryL,G1H8(45),ex3(:),G1H4(41),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(41),39,0,G2H4(55),n2h4(67))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(46),ex4(:),G1H4(42),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_VQ_A(ntryL,G1H8(48),ex3(:),G1H4(46),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(46),39,0,G2H4(56),n2h4(68))
  call Hloop_VQ_A(ntryL,G1H8(51),ex3(:),G1H4(47),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(47),39,0,G2H4(57),n2h4(69))
  call Hloop_VQ_A(ntryL,G1H8(52),ex3(:),G1H4(48),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(48),39,0,G2H4(58),n2h4(70))
  call Hloop_VA_Q(ntryL,G1H8(5),ex4(:),G1H4(52),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(52),43,0,G2H4(59),n2h4(71))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(53),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_VA_Q(ntryL,G1H8(10),ex4(:),G1H4(54),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(54),43,0,G2H4(60),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(11),ex4(:),G1H4(59),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(59),43,0,G2H4(61),n2h4(73))
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(60),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(60),43,0,G2H4(62),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(64),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(64),51,0,G2H4(63),n2h4(75))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-8,0,G2H8(15),n2h8(79))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(64),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AV_Q(ntryL,G1H8(18),ex5(:),G1H4(65),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(65),51,0,G2H4(65),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(66),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(66),51,0,G2H4(66),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(71),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(71),51,0,G2H4(67),n2h4(78))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(72),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(72),51,0,G2H4(68),n2h4(79))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(42),-4,0,G2H8(16),n2h8(80))
  call Hloop_AQ_V(ntryL,G2H8(16),ex3(:),G2H4(69),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(76),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(76),51,0,G2H4(70),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(77),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(77),51,0,G2H4(71),n2h4(81))
  call Hloop_QV_A(ntryL,G1H8(20),ex5(:),G1H4(78),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(78),51,0,G2H4(72),n2h4(82))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(49),m3h2x8(:,87),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(49),52,0,G2H8(15),n2h8(81))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(50),m3h2x8(:,88),heltab2x16(:,:,100))
  call Hloop_QV_A(ntryL,G1H16(4),ex5(:),G1H8(8),m3h2x8(:,89),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(8),52,0,G2H8(16),n2h8(82))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(13),m3h2x8(:,90),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(13),52,0,G2H8(33),n2h8(83))
  call Hloop_QV_A(ntryL,G1H16(6),ex5(:),G1H8(26),m3h2x8(:,91),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(26),52,0,G2H8(34),n2h8(84))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,1),G1H4(83),m3h4x4(:,13),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(83),39,0,G2H4(73),n2h4(83))
call HGT_raise_alpha_OLR(G1H16(31),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(31),ex4(:),G1H8(14),m3h2x8(:,92),heltab2x16(:,:,105))
  call Hloop_QV_A(ntryL,G1H16(33),wf4(:,1),G1H4(84),m3h4x4(:,14),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(84),39,0,G2H4(74),n2h4(84))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,1),G1H4(88),m3h4x4(:,15),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(88),39,0,G2H4(75),n2h4(85))
  call Hloop_QV_A(ntryL,G1H16(35),wf4(:,1),G1H4(89),m3h4x4(:,16),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(89),39,0,G2H4(76),n2h4(86))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(19),m3h2x8(:,93),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(35),n2h8(85))
call HGT_raise_alpha_OLR(G1H16(11),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(11),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(11),-12,wf4(:,12),12,G2H4(77),m3h4x4(:,17),heltab2x16(:,:,110))
call signflip_OLR(G2H4(77))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(25),m3h2x8(:,94),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(25),49,0,G2H8(36),n2h8(86))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(37),n2h8(87))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(2),m3h2x8(:,96),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(2),49,0,G2H8(38),n2h8(88))
  call Hloop_QV_A(ntryL,G1H16(37),ex5(:),G1H8(3),m3h2x8(:,97),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(39),n2h8(89))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(38),ex2(:),G1H8(4),m3h2x8(:,98),heltab2x16(:,:,115))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(28),m3h2x8(:,99),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(28),49,0,G2H8(40),n2h8(90))
  call Hloop_QV_A(ntryL,G1H16(41),ex5(:),G1H8(30),m3h2x8(:,100),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(30),49,0,G2H8(41),n2h8(91))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(22),m3h2x8(:,101),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(22),49,0,G2H8(42),n2h8(92))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(24),m3h2x8(:,102),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(24),50,0,G2H8(43),n2h8(93))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(44),-12,wf4(:,12),12,G2H4(78),m3h4x4(:,18),heltab2x16(:,:,120))
call signflip_OLR(G2H4(78))
  call Hloop_AV_Q(ntryL,G1H16(46),ex5(:),G1H8(32),m3h2x8(:,103),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(32),50,0,G2H8(44),n2h8(94))
  call Hloop_AV_Q(ntryL,G1H16(47),ex5(:),G1H8(37),m3h2x8(:,104),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(37),50,0,G2H8(45),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(38),m3h2x8(:,105),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(38),50,0,G2H8(46),n2h8(96))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,12),G1H4(90),m3h4x4(:,19),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(90),45,0,G2H4(79),n2h4(87))
call HGT_raise_alpha_OLR(G1H16(49),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(44),m3h2x8(:,106),heltab2x16(:,:,125))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,12),G1H4(95),m3h4x4(:,20),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(95),45,0,G2H4(80),n2h4(88))
  call Hloop_QV_A(ntryL,G1H16(52),wf4(:,12),G1H4(96),m3h4x4(:,21),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(96),45,0,G2H4(81),n2h4(89))
  call Hloop_QV_A(ntryL,G1H16(53),wf4(:,12),G1H4(100),m3h4x4(:,22),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(100),45,0,G2H4(82),n2h4(90))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(10),G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(13),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(16),G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(19),G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(7)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(25)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(19)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(13)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(103)])
call HGT_lower_alpha_w2_OLR(G2H4(38),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(38),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(38),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(115)])
call HGT_lower_alpha_w2_OLR(G2H4(46),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(46),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(46),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(21),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(27),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(45),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(51),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(128),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(134),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(140),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(146),G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(139)])
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(35),mass5set(:,1),  & 
G1H4(101),G1H4(102),G1H4(107),G1H4(108),G1H4(112),G1H4(113),4)
  call HG1shiftOLR(G1H4(102),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(36),mass5set(:,1),  & 
G1H4(114),G1H4(119),G1H4(120),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(119),4,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(37),mass5set(:,1),  & 
G1H4(131),G1H4(132),G1H4(136),G1H4(137),G1H4(138),G1H4(143),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(38),mass5set(:,1),  & 
G1H4(144),G1H4(148),G1H4(58),G1H4(70),G1H4(82),G1H4(94),4)
  call HG1shiftOLR(G1H4(148),4,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(17),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(17),47,0,G2H2(1),n2h2(41))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(39),mass5set(:,1),  & 
G1H4(106),G1H4(118),G1H4(130),G1H4(142),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(118),8,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(18),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(18),47,0,G2H2(3),n2h2(42))
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(40),mass5set(:,1),  & 
G1H4(10),G1H4(11),G1H4(12),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(11),4,4)
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(23),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(23),47,0,G2H2(5),n2h2(43))
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(41),mass5set(:,1),  & 
G1H4(22),G1H4(23),G1H4(41),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(24),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(24),47,0,G2H2(7),n2h2(44))
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(42),mass5set(:,1),  & 
G1H4(52),G1H4(54),G1H4(59),G1H4(60),G1H4(64),G1H4(65),4)
  call HG1shiftOLR(G1H4(54),4,4)
call HGT_lower_alpha_w2_OLR(G2H4(34),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(34),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(34),6,15,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(43),mass5set(:,1),  & 
G1H4(66),G1H4(71),G1H4(72),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(71),2,4)
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(9),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(44),mass5set(:,1),  & 
G1H4(83),G1H4(84),G1H4(88),G1H4(89),G1H4(90),G1H4(95),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hloop_QA_V(ntryL,G2H4(53),ex4(:),G2H2(12),m3h2x2(:,78),heltab2x4(:,:,78))
call HGT_lower_alpha_w2_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(42),6,15,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(45),mass5set(:,1),  & 
G1H4(96),G1H4(100),G1H4(57),G1H4(69),G1H4(81),G1H4(93),4)
  call HG1shiftOLR(G1H4(100),1,4)
  call Hloop_AQ_V(ntryL,G2H4(50),ex1(:),G2H2(15),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(46),mass5set(:,1),  & 
G1H4(7),G1H4(36),G1H4(105),G1H4(25),G1H4(34),G1H4(117),4)
  call HG1shiftOLR(G1H4(36),4,4)
  call Hloop_AQ_V(ntryL,G2H4(54),ex3(:),G2H2(18),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(29),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(21),n2h2(45))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(47),mass5set(:,1),  & 
G1H4(19),G1H4(40),G1H4(129),G1H4(13),G1H4(35),G1H4(141),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(30),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(30),47,0,G2H2(24),n2h2(46))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(48),mass5set(:,1),  & 
G1H4(103),G1H4(115),G1H4(21),G1H4(9),G1H4(27),G1H4(15),4)
  call HG1shiftOLR(G1H4(115),16,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(35),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(35),47,0,G2H2(27),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(36),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(36),47,0,G2H2(30),n2h2(48))
  call Hloop_VQ_A(ntryL,G1H4(29),ex1(:),G1H2(41),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(41),47,0,G2H2(33),n2h2(49))
  call Hloop_VQ_A(ntryL,G1H4(32),ex1(:),G1H2(42),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(42),47,0,G2H2(36),n2h2(50))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(49),mass5set(:,1),  & 
G1H4(31),G1H4(45),G1H4(33),G1H4(37),G1H4(51),G1H4(39),4)
  call HG1shiftOLR(G1H4(45),16,4)
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(47),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(39),n2h2(51))
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(48),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(42),n2h2(52))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(50),mass5set(:,1),  & 
G1H4(43),G1H4(49),G1H4(55),G1H4(56),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(49),16,4)
  call Hloop_VQ_A(ntryL,G1H4(30),ex1(:),G1H2(53),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(53),47,0,G2H2(45),n2h2(53))
  call Hloop_VQ_A(ntryL,G1H4(44),ex1(:),G1H2(54),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(54),47,0,G2H2(48),n2h2(54))
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(59),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(59),47,0,G2H2(51),n2h2(55))
  call Hloop_VA_Q(ntryL,G1H4(50),ex2(:),G1H2(60),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(60),47,0,G2H2(54),n2h2(56))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(51),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(91),G1H4(92),G1H4(128),G1H4(104),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(52),mass5set(:,1),  & 
G1H4(134),G1H4(110),G1H4(140),G1H4(116),G1H4(146),G1H4(122),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(65),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(65),55,0,G2H2(57),n2h2(57))
  call Hloop_VQ_A(ntryL,G1H4(62),ex3(:),G1H2(66),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(66),55,0,G2H2(58),n2h2(58))
  call Hloop_VQ_A(ntryL,G1H4(63),ex3(:),G1H2(71),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(71),55,0,G2H2(59),n2h2(59))
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(53),mass5set(:,1),  & 
G1H4(127),G1H4(139),G1H4(1),G1H4(2),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(139),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(54),mass5set(:,1),  & 
G1H4(8),G1H4(14),G1H4(20),G1H4(26),G1H4(29),G1H4(32),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hloop_VA_Q(ntryL,G1H4(73),ex4(:),G1H2(72),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(72),59,0,G2H2(60),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(77),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(61),n2h2(61))
  call Hloop_VA_Q(ntryL,G1H4(75),ex4(:),G1H2(78),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(78),59,0,G2H2(62),n2h2(62))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(55),mass5set(:,1),  & 
G1H4(28),G1H4(38),G1H4(30),G1H4(44),G1H4(24),G1H4(50),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(56),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(73),G1H4(74),G1H4(75),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_VQ_A(ntryL,G1H4(85),ex3(:),G1H2(83),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(63),n2h2(63))
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(84),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(84),55,0,G2H2(64),n2h2(64))
  call Hloop_VQ_A(ntryL,G1H4(87),ex3(:),G1H2(17),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(17),55,0,G2H2(65),n2h2(65))
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(57),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(149),G1H4(150),G1H4(151),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(58),mass5set(:,1),  & 
G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(153),4,4)
  call Hloop_VA_Q(ntryL,G1H4(97),ex4(:),G1H2(18),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(18),59,0,G2H2(66),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(23),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(23),59,0,G2H2(67),n2h2(67))
  call Hloop_VA_Q(ntryL,G1H4(99),ex4(:),G1H2(24),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(24),59,0,G2H2(68),n2h2(68))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(27),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hloop_QV_A(ntryL,G1H4(109),ex5(:),G1H2(29),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(69),n2h2(69))
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(55),mass4set(:,1),  & 
G1H4(109),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(161),8,4)
  call Hloop_QV_A(ntryL,G1H4(111),ex5(:),G1H2(30),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(30),55,0,G2H2(70),n2h2(70))
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(28),mass5set(:,1),  & 
G1H4(111),G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),4)
  call HG1shiftOLR(G1H4(165),4,4)
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(35),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(35),59,0,G2H2(71),n2h2(71))
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(69),mass4set(:,1),  & 
G1H4(121),G1H4(170),G1H4(171),G1H4(172),G1H4(173),4)
  call HG1shiftOLR(G1H4(170),4,4)
  call Hloop_AV_Q(ntryL,G1H4(123),ex5(:),G1H2(36),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(36),59,0,G2H2(72),n2h2(72))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(59),mass5set(:,1),  & 
G1H4(123),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),8,4)
  call Hloop_QV_A(ntryL,G1H4(133),ex5(:),G1H2(41),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(41),55,0,G2H2(73),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(135),ex5(:),G1H2(42),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(74),n2h2(74))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(60),mass5set(:,1),  & 
G1H4(133),G1H4(135),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(135),4,4)
  call Hloop_AV_Q(ntryL,G1H4(145),ex5(:),G1H2(47),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(47),59,0,G2H2(75),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(147),ex5(:),G1H2(48),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(48),59,0,G2H2(76),n2h2(76))
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(77),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_AQ_V(ntryL,G2H4(12),ex1(:),G2H2(78),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QA_V(ntryL,G2H4(15),ex2(:),G2H2(79),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_QA_V(ntryL,G2H4(18),ex2(:),G2H2(80),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QA_V(ntryL,G2H4(27),ex2(:),G2H2(81),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_V(ntryL,G2H4(29),ex4(:),G2H2(82),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QA_V(ntryL,G2H4(30),ex4(:),G2H2(83),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AQ_V(ntryL,G2H4(32),ex1(:),G2H2(84),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_AQ_V(ntryL,G2H4(33),ex3(:),G2H2(85),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_AQ_V(ntryL,G2H4(36),ex3(:),G2H2(86),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(61),mass5set(:,1),  & 
G1H4(145),G1H4(147),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(147),16,4)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(62),mass5set(:,1),  & 
G1H8(21),G1H8(23),G1H8(27),G1H8(29),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(23),16,8)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(63),mass5set(:,1),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),16,4)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(64),mass5set(:,1),  & 
G1H8(39),G1H8(40),G1H8(45),G1H8(46),G1H8(48),G1H8(51),8)
  call HG1shiftOLR(G1H8(40),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(65),mass5set(:,1),  & 
G1H8(52),G1H8(5),G1H8(6),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(5),12,8)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(66),mass5set(:,1),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),16,4)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(67),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(18),G1H8(41),G1H8(43),G1H8(35),8)
  call HG1shiftOLR(G1H8(16),12,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(68),mass5set(:,1),  & 
G1H8(42),G1H8(36),G1H8(7),G1H8(20),G1H8(49),G1H8(8),8)
  call HG1shiftOLR(G1H8(36),16,8)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(69),mass5set(:,1),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(70),mass5set(:,1),  & 
G1H8(13),G1H8(26),G1H8(19),G1H8(25),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(10),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(71),mass5set(:,1),  & 
G1H8(3),G1H8(28),G1H8(30),G1H8(22),G1H8(24),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),17,8)
  call Hloop_AQ_V(ntryL,G2H8(28),wf4(:,13),G2H2(87),m3h4x2(:,1),heltab2x8(:,:,108))
  call Hloop_AQ_V(ntryL,G2H8(29),ex3(:),G2H4(13),m3h2x4(:,108),heltab2x8(:,:,109))
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(72),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(38),17,8)
  call Hloop_QA_V(ntryL,G2H8(32),ex4(:),G2H4(16),m3h2x4(:,109),heltab2x8(:,:,110))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(73),mass5set(:,1),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),18,8)
  call Hloop_QA_V(ntryL,G2H8(2),wf4(:,18),G2H2(88),m3h4x2(:,2),heltab2x8(:,:,111))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(19),m3h2x4(:,110),heltab2x8(:,:,112))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(74),mass5set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),18,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(4),mass5set(:,1),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),20,8)
  call Hloop_QA_V(ntryL,G2H8(22),ex2(:),G2H4(35),m3h2x4(:,111),heltab2x8(:,:,113))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(6),mass5set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),20,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(25),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(21),m3h2x4(:,112),heltab2x8(:,:,114))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(23),mass5set(:,1),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(88),8,8)
  call Hloop_AQ_V(ntryL,G2H8(5),wf4(:,4),G2H2(89),m3h4x2(:,3),heltab2x8(:,:,115))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(3),mass5set(:,1),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(94),24,8)
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(39),m3h2x4(:,113),heltab2x8(:,:,116))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(5),mass5set(:,1),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),8)
  call HG1shiftOLR(G1H8(100),24,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(26),mass5set(:,1),  & 
G1H8(105),G1H8(106),G1H8(107),G1H8(108),G1H8(109),G1H8(110),8)
  call HG1shiftOLR(G1H8(106),4,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(43),m3h2x4(:,114),heltab2x8(:,:,117))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(24),mass5set(:,1),  & 
G1H8(111),G1H8(112),G1H8(113),G1H8(114),G1H8(115),G1H8(116),8)
  call HG1shiftOLR(G1H8(112),4,8)
  call Hloop_QA_V(ntryL,G2H8(12),wf4(:,9),G2H2(90),m3h4x2(:,4),heltab2x8(:,:,118))
  call Hotf_4pt_reduction(G2H4(58),RedSet_4(56),mass4set(:,1),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),4)
  call HG1shiftOLR(G1H4(206),24,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(70),mass4set(:,1),  & 
G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(211),20,4)
  call Hloop_AQ_V(ntryL,G2H4(63),ex3(:),G2H2(91),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_AQ_V(ntryL,G2H4(66),ex3(:),G2H2(92),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_AQ_V(ntryL,G2H4(67),ex3(:),G2H2(93),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_QA_V(ntryL,G2H4(68),ex4(:),G2H2(94),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_QA_V(ntryL,G2H4(71),ex4(:),G2H2(95),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_QA_V(ntryL,G2H4(72),ex4(:),G2H2(96),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(31),mass5set(:,1),  & 
G1H8(117),G1H8(118),G1H8(119),G1H8(120),G1H8(121),G1H8(122),8)
  call HG1shiftOLR(G1H8(118),8,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(101),mass4set(:,1),  & 
G1H8(123),G1H8(124),G1H8(125),G1H8(126),G1H8(127),8)
  call HG1shiftOLR(G1H8(124),8,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(234),mass4set(:,1),  & 
G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(129),11,8)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(32),mass5set(:,1),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),8,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(101),mass4set(:,1),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),4)
  call HG1shiftOLR(G1H4(222),8,4)
  call Hotf_4pt_reduction(G2H4(76),RedSet_4(169),mass4set(:,1),  & 
G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(227),24,4)
  call Hloop_QA_V(ntryL,G2H8(35),ex2(:),G2H4(23),m3h2x4(:,115),heltab2x8(:,:,119))
  call Hloop_QA_V(ntryL,G2H8(37),ex2(:),G2H4(47),m3h2x4(:,116),heltab2x8(:,:,120))
  call Hloop_QA_V(ntryL,G2H8(38),ex2(:),G2H4(49),m3h2x4(:,117),heltab2x8(:,:,121))
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(33),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),2,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(115),mass4set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),8)
  call HG1shiftOLR(G1H8(140),2,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(37),mass4set(:,1),  & 
G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
  call HG1shiftOLR(G1H8(145),14,8)
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(8),m3h2x4(:,118),heltab2x8(:,:,122))
  call Hloop_AQ_V(ntryL,G2H8(45),ex1(:),G2H4(52),m3h2x4(:,119),heltab2x8(:,:,123))
  call Hloop_AQ_V(ntryL,G2H8(46),ex1(:),G2H4(51),m3h2x4(:,120),heltab2x8(:,:,124))
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(34),mass5set(:,1),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(235),G1H4(236),4)
  call HG1shiftOLR(G1H4(232),2,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(115),mass4set(:,1),  & 
G1H4(237),G1H4(238),G1H4(239),G1H4(240),G1H4(241),4)
  call HG1shiftOLR(G1H4(238),2,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(213),mass4set(:,1),  & 
G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(243),18,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(123),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(221),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(226),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(236)])
  call Hloop_VQ_A(ntryL,G1H4(101),ex3(:),G1H2(53),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(97),n2h2(77))
call HGT_raise_alpha_OLR(G1H4(102),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(54),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_VQ_A(ntryL,G1H4(112),ex3(:),G1H2(59),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(59),55,0,G2H2(98),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(113),ex3(:),G1H2(60),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(60),55,0,G2H2(99),n2h2(79))
  call Hloop_VA_Q(ntryL,G1H4(114),ex4(:),G1H2(65),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(65),59,0,G2H2(100),n2h2(80))
call HGT_raise_alpha_OLR(G1H4(119),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(119),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(119),ex3(:),G1H2(66),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(71),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(71),59,0,G2H2(101),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(126),ex4(:),G1H2(72),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(72),59,0,G2H2(102),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(131),ex3(:),G1H2(77),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(77),55,0,G2H2(103),n2h2(83))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(132),ex4(:),G1H2(78),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_VQ_A(ntryL,G1H4(138),ex3(:),G1H2(83),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(104),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(143),ex3(:),G1H2(84),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(84),55,0,G2H2(105),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(144),ex4(:),G1H2(17),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(17),59,0,G2H2(106),n2h2(86))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(148),ex3(:),G1H2(18),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_VA_Q(ntryL,G1H4(82),ex4(:),G1H2(23),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(23),59,0,G2H2(107),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(94),ex4(:),G1H2(24),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(24),59,0,G2H2(108),n2h2(88))
  call Hloop_QV_A(ntryL,G1H4(106),ex5(:),G1H2(29),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(109),n2h2(89))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(118),ex4(:),G1H2(30),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_QV_A(ntryL,G1H4(5),ex5(:),G1H2(35),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(35),55,0,G2H2(110),n2h2(90))
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(36),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(111),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(41),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(41),59,0,G2H2(112),n2h2(92))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(42),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_AV_Q(ntryL,G1H4(17),ex5(:),G1H2(47),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(47),59,0,G2H2(113),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(18),ex5(:),G1H2(48),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(48),59,0,G2H2(114),n2h2(94))
  call Hloop_QV_A(ntryL,G1H4(22),ex5(:),G1H2(53),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(115),n2h2(95))
call HGT_raise_alpha_OLR(G1H4(23),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(59),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_QV_A(ntryL,G1H4(47),ex5(:),G1H2(60),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(60),55,0,G2H2(116),n2h2(96))
  call Hloop_QV_A(ntryL,G1H4(48),ex5(:),G1H2(65),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(65),55,0,G2H2(117),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H4(52),ex5(:),G1H2(71),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(71),59,0,G2H2(118),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(54),ex3(:),G1H2(72),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_AV_Q(ntryL,G1H4(64),ex5(:),G1H2(77),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(119),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H4(65),ex5(:),G1H2(83),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(83),59,0,G2H2(120),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(66),ex5(:),G1H2(84),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(84),61,0,G2H2(121),n2h2(101))
call HGT_raise_alpha_OLR(G1H4(71),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(71),ex2(:),G1H2(17),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_QV_A(ntryL,G1H4(77),ex5(:),G1H2(23),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(23),61,0,G2H2(122),n2h2(102))
  call Hloop_QV_A(ntryL,G1H4(78),ex5(:),G1H2(24),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(24),61,0,G2H2(123),n2h2(103))
  call Hloop_QV_A(ntryL,G1H4(83),ex5(:),G1H2(29),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(124),n2h2(104))
call HGT_raise_alpha_OLR(G1H4(84),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(35),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(36),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(125),n2h2(105))
  call Hloop_QV_A(ntryL,G1H4(95),ex5(:),G1H2(41),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(41),55,0,G2H2(126),n2h2(106))
  call Hloop_AV_Q(ntryL,G1H4(96),ex5(:),G1H2(47),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(47),62,0,G2H2(127),n2h2(107))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(100),ex1(:),G1H2(48),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_AV_Q(ntryL,G1H4(81),ex5(:),G1H2(53),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(53),62,0,G2H2(128),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H4(93),ex5(:),G1H2(60),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(60),62,0,G2H2(129),n2h2(109))
  call Hloop_AV_Q(ntryL,G1H4(7),ex5(:),G1H2(65),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(65),59,0,G2H2(130),n2h2(110))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(36),ex3(:),G1H2(71),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_AV_Q(ntryL,G1H4(34),ex5(:),G1H2(77),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(131),n2h2(111))
  call Hloop_AV_Q(ntryL,G1H4(117),ex5(:),G1H2(83),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(83),59,0,G2H2(132),n2h2(112))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(84),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(84),47,0,G2H2(133),n2h2(113))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-16,0,G2H4(22),n2h4(103))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(134),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_VQ_A(ntryL,G1H4(35),ex3(:),G1H2(23),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(23),47,0,G2H2(135),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(141),ex3(:),G1H2(24),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(24),47,0,G2H2(136),n2h2(115))
  call Hloop_VA_Q(ntryL,G1H4(103),ex4(:),G1H2(29),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(29),47,0,G2H2(137),n2h2(116))
call HGT_OLR(G1H4(115),1,1,4)
call HGT_invQ_OLR(G1H4(115),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(115),-16,0,G2H4(25),n2h4(104))
  call Hloop_QV_A(ntryL,G2H4(25),ex5(:),G2H2(138),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(36),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(36),47,0,G2H2(139),n2h2(117))
  call Hloop_VA_Q(ntryL,G1H4(15),ex4(:),G1H2(41),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(41),47,0,G2H2(140),n2h2(118))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(47),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(47),47,0,G2H2(141),n2h2(119))
call HGT_OLR(G1H4(45),1,1,4)
call HGT_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(45),-16,0,G2H4(28),n2h4(105))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(142),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(51),ex1(:),G1H2(53),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(53),47,0,G2H2(143),n2h2(120))
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(60),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(60),47,0,G2H2(144),n2h2(121))
  call Hloop_VA_Q(ntryL,G1H4(43),ex2(:),G1H2(65),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(65),47,0,G2H2(145),n2h2(122))
call HGT_OLR(G1H4(49),1,1,4)
call HGT_invQ_OLR(G1H4(49),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(49),-16,0,G2H4(31),n2h4(106))
  call Hloop_QV_A(ntryL,G2H4(31),ex5(:),G2H2(146),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_VA_Q(ntryL,G1H4(67),ex2(:),G1H2(77),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(77),47,0,G2H2(147),n2h2(123))
  call Hloop_VA_Q(ntryL,G1H4(68),ex2(:),G1H2(83),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(83),47,0,G2H2(148),n2h2(124))
  call Hloop_VQ_A(ntryL,G1H4(79),ex3(:),G1H2(84),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(84),55,0,G2H2(149),n2h2(125))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(23),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_VQ_A(ntryL,G1H4(128),ex3(:),G1H2(24),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(24),55,0,G2H2(150),n2h2(126))
  call Hloop_VQ_A(ntryL,G1H4(104),ex3(:),G1H2(29),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(151),n2h2(127))
  call Hloop_VQ_A(ntryL,G1H4(134),ex3(:),G1H2(36),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(152),n2h2(128))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(110),ex4(:),G1H2(41),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_VQ_A(ntryL,G1H4(146),ex3(:),G1H2(47),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(47),55,0,G2H2(153),n2h2(129))
  call Hloop_VQ_A(ntryL,G1H4(122),ex3(:),G1H2(53),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(154),n2h2(130))
  call Hloop_VA_Q(ntryL,G1H4(127),ex4(:),G1H2(60),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(60),59,0,G2H2(155),n2h2(131))
call HGT_raise_alpha_OLR(G1H4(139),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(139),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(139),ex3(:),G1H2(65),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(77),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(156),n2h2(132))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(83),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(83),59,0,G2H2(157),n2h2(133))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(84),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(84),59,0,G2H2(158),n2h2(134))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(24),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_VA_Q(ntryL,G1H4(29),ex4(:),G1H2(29),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(29),59,0,G2H2(159),n2h2(135))
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(36),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(36),59,0,G2H2(160),n2h2(136))
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(47),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(47),55,0,G2H2(161),n2h2(137))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex4(:),G1H2(53),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_VQ_A(ntryL,G1H4(24),ex3(:),G1H2(60),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(60),55,0,G2H2(162),n2h2(138))
  call Hloop_VQ_A(ntryL,G1H4(50),ex3(:),G1H2(77),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(77),55,0,G2H2(163),n2h2(139))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(83),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(164),n2h2(140))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(84),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_VQ_A(ntryL,G1H4(74),ex3(:),G1H2(29),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(165),n2h2(141))
  call Hloop_VQ_A(ntryL,G1H4(75),ex3(:),G1H2(36),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(166),n2h2(142))
  call Hloop_VA_Q(ntryL,G1H4(85),ex4(:),G1H2(47),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(47),59,0,G2H2(167),n2h2(143))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(60),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_VA_Q(ntryL,G1H4(150),ex4(:),G1H2(77),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(168),n2h2(144))
  call Hloop_VA_Q(ntryL,G1H4(151),ex4(:),G1H2(83),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(83),59,0,G2H2(169),n2h2(145))
  call Hloop_VA_Q(ntryL,G1H4(152),ex4(:),G1H2(29),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(29),59,0,G2H2(170),n2h2(146))
call HGT_raise_alpha_OLR(G1H4(153),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(153),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(153),ex3(:),G1H2(36),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VA_Q(ntryL,G1H4(156),ex4(:),G1H2(47),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(47),59,0,G2H2(171),n2h2(147))
  call Hloop_VA_Q(ntryL,G1H4(157),ex4(:),G1H2(77),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(172),n2h2(148))
  call Hloop_QV_A(ntryL,G1H4(97),ex5(:),G1H2(83),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(173),n2h2(149))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(29),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_QV_A(ntryL,G1H4(109),ex5(:),G1H2(47),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(47),55,0,G2H2(174),n2h2(150))
  call Hloop_QV_A(ntryL,G1H4(205),ex5(:),G1H2(77),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(77),55,0,G2H2(175),n2h2(151))
call HGT_raise_alpha_OLR(G1H4(161),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(161),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(161),ex4(:),G1H2(83),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_QV_A(ntryL,G1H4(164),ex5(:),G1H2(47),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(47),55,0,G2H2(176),n2h2(152))
  call Hloop_AV_Q(ntryL,G1H4(111),ex5(:),G1H2(77),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(177),n2h2(153))
call HGT_raise_alpha_OLR(G1H4(165),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(165),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(165),ex3(:),G1H2(47),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(77),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(178),n2h2(154))
  call Hloop_AV_Q(ntryL,G1H4(210),ex5(:),G1H2(77),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(77),59,0,G2H2(179),n2h2(155))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(170),ex3(:),G1H2(77),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AV_Q(ntryL,G1H4(173),ex5(:),G1H2(89),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(89),59,0,G2H2(180),n2h2(156))
  call Hloop_QV_A(ntryL,G1H4(123),ex5(:),G1H2(89),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(89),55,0,G2H2(181),n2h2(157))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(174),ex4(:),G1H2(89),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(90),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(90),55,0,G2H2(182),n2h2(158))
  call Hloop_QV_A(ntryL,G1H4(178),ex5(:),G1H2(90),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(90),55,0,G2H2(183),n2h2(159))
  call Hloop_AV_Q(ntryL,G1H4(133),ex5(:),G1H2(90),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(90),59,0,G2H2(184),n2h2(160))
call HGT_raise_alpha_OLR(G1H4(135),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(135),ex3(:),G1H2(90),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_AV_Q(ntryL,G1H4(181),ex5(:),G1H2(91),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(91),59,0,G2H2(185),n2h2(161))
  call Hloop_AV_Q(ntryL,G1H4(182),ex5(:),G1H2(91),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(91),59,0,G2H2(186),n2h2(162))
  call Hloop_VQ_A(ntryL,G1H4(145),ex3(:),G1H2(91),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(187),n2h2(163))
call HGT_OLR(G1H4(147),1,1,4)
call HGT_invQ_OLR(G1H4(147),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(147),-16,0,G2H4(34),n2h4(121))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(188),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_VQ_A(ntryL,G1H4(185),ex3(:),G1H2(91),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(189),n2h2(164))
  call Hloop_VQ_A(ntryL,G1H4(186),ex3(:),G1H2(91),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(190),n2h2(165))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(91),m3h4x2(:,5),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(191),n2h2(166))
call HGT_OLR(G1H8(23),1,1,8)
call HGT_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(23),-16,0,G2H8(17),n2h8(97))
  call Hloop_QV_A(ntryL,G2H8(17),ex5(:),G2H4(7),m3h2x4(:,121),heltab2x8(:,:,126))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,1),G1H2(91),m3h4x2(:,6),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(192),n2h2(167))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,1),G1H2(91),m3h4x2(:,7),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(193),n2h2(168))
  call Hloop_VA_Q(ntryL,G1H4(187),ex4(:),G1H2(91),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(194),n2h2(169))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(188),-16,0,G2H4(38),n2h4(122))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(195),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_VA_Q(ntryL,G1H4(191),ex4(:),G1H2(91),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(196),n2h2(170))
  call Hloop_VA_Q(ntryL,G1H4(192),ex4(:),G1H2(91),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(197),n2h2(171))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,1),G1H2(91),m3h4x2(:,8),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(198),n2h2(172))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(40),-16,0,G2H8(19),n2h8(98))
  call Hloop_AV_Q(ntryL,G2H8(19),ex5(:),G2H4(53),m3h2x4(:,122),heltab2x8(:,:,130))
  call Hloop_QV_A(ntryL,G1H8(48),wf4(:,1),G1H2(91),m3h4x2(:,9),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(199),n2h2(173))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,1),G1H2(91),m3h4x2(:,10),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(200),n2h2(174))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(159),m3h2x4(:,123),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(159),51,0,G2H4(42),n2h4(123))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(5),-12,0,G2H8(20),n2h8(99))
  call Hloop_AV_Q(ntryL,G2H8(20),wf4(:,12),G2H2(201),m3h4x2(:,11),heltab2x8(:,:,134))
  call Hloop_QV_A(ntryL,G1H8(11),ex5(:),G1H4(160),m3h2x4(:,124),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(160),51,0,G2H4(50),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(12),ex5(:),G1H4(168),m3h2x4(:,125),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(168),51,0,G2H4(46),n2h4(125))
  call Hloop_VQ_A(ntryL,G1H4(193),ex1(:),G1H2(91),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(202),n2h2(175))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-16,0,G2H4(54),n2h4(126))
  call Hloop_AV_Q(ntryL,G2H4(54),ex5(:),G2H2(203),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_VQ_A(ntryL,G1H4(197),ex1(:),G1H2(91),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(204),n2h2(176))
  call Hloop_VQ_A(ntryL,G1H4(198),ex1(:),G1H2(91),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(205),n2h2(177))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(169),m3h2x4(:,126),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(169),51,0,G2H4(1),n2h4(127))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-12,0,G2H8(21),n2h8(100))
  call Hloop_QV_A(ntryL,G2H8(21),wf4(:,12),G2H2(206),m3h4x2(:,12),heltab2x8(:,:,138))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(219),m3h2x4(:,127),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(219),51,0,G2H4(2),n2h4(128))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(220),m3h2x4(:,128),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(220),51,0,G2H4(5),n2h4(129))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,12),G1H2(91),m3h4x2(:,13),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(207),n2h2(178))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-16,0,G2H8(23),n2h8(101))
  call Hloop_QV_A(ntryL,G2H8(23),ex5(:),G2H4(6),m3h2x4(:,129),heltab2x8(:,:,142))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,12),G1H2(91),m3h4x2(:,14),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(208),n2h2(179))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,12),G1H2(91),m3h4x2(:,15),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(209),n2h2(180))
  call Hloop_VA_Q(ntryL,G1H4(199),ex2(:),G1H2(91),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(210),n2h2(181))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-16,0,G2H4(37),n2h4(130))
  call Hloop_QV_A(ntryL,G2H4(37),ex5(:),G2H2(211),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_VA_Q(ntryL,G1H4(203),ex2(:),G1H2(91),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(212),n2h2(182))
  call Hloop_VA_Q(ntryL,G1H4(204),ex2(:),G1H2(91),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(213),n2h2(183))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,12),G1H2(91),m3h4x2(:,16),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(214),n2h2(184))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,0,G2H8(24),n2h8(102))
  call Hloop_AV_Q(ntryL,G2H8(24),ex5(:),G2H4(11),m3h2x4(:,130),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,12),G1H2(91),m3h4x2(:,17),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(215),n2h2(185))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,12),G1H2(91),m3h4x2(:,18),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(216),n2h2(186))
  call Hloop_VA_Q(ntryL,G1H8(3),ex2(:),G1H4(235),m3h2x4(:,131),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(235),46,0,G2H4(40),n2h4(131))
call HGT_raise_alpha_OLR(G1H8(28),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(28),wf4(:,13),G1H2(91),m3h4x2(:,19),heltab2x8(:,:,150))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(236),m3h2x4(:,132),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(236),46,0,G2H4(14),n2h4(132))
  call Hloop_VA_Q(ntryL,G1H8(32),ex2(:),G1H4(101),m3h2x4(:,133),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(101),46,0,G2H4(41),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(102),m3h2x4(:,134),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(102),46,0,G2H4(17),n2h4(134))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(38),wf4(:,13),G1H2(92),m3h4x2(:,20),heltab2x8(:,:,154))
  call Hloop_VA_Q(ntryL,G1H8(55),ex2(:),G1H4(112),m3h2x4(:,135),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(112),46,0,G2H4(44),n2h4(135))
  call Hloop_VA_Q(ntryL,G1H8(56),ex2(:),G1H4(113),m3h2x4(:,136),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(113),46,0,G2H4(20),n2h4(136))
  call Hloop_VQ_A(ntryL,G1H8(57),ex1(:),G1H4(114),m3h2x4(:,137),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(114),45,0,G2H4(55),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(58),wf4(:,18),G1H2(93),m3h4x2(:,21),heltab2x8(:,:,158))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(119),m3h2x4(:,138),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(119),45,0,G2H4(57),n2h4(138))
  call Hloop_VQ_A(ntryL,G1H8(62),ex1(:),G1H4(125),m3h2x4(:,139),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(125),45,0,G2H4(59),n2h4(139))
  call Hloop_VQ_A(ntryL,G1H8(63),ex1(:),G1H4(126),m3h2x4(:,140),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(126),45,0,G2H4(61),n2h4(140))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(64),wf4(:,18),G1H2(94),m3h4x2(:,22),heltab2x8(:,:,162))
  call Hloop_VQ_A(ntryL,G1H8(67),ex1(:),G1H4(131),m3h2x4(:,141),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(131),45,0,G2H4(24),n2h4(141))
  call Hloop_VQ_A(ntryL,G1H8(68),ex1(:),G1H4(132),m3h2x4(:,142),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(132),45,0,G2H4(26),n2h4(142))
  call Hloop_VA_Q(ntryL,G1H8(69),ex4(:),G1H4(138),m3h2x4(:,143),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(138),43,0,G2H4(9),n2h4(143))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(70),wf4(:,4),G1H2(95),m3h4x2(:,23),heltab2x8(:,:,166))
  call Hloop_VA_Q(ntryL,G1H8(73),ex4(:),G1H4(143),m3h2x4(:,144),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(143),43,0,G2H4(12),n2h4(144))
  call Hloop_VA_Q(ntryL,G1H8(74),ex4(:),G1H4(144),m3h2x4(:,145),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(144),43,0,G2H4(15),n2h4(145))
  call Hloop_VA_Q(ntryL,G1H8(75),ex4(:),G1H4(148),m3h2x4(:,146),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(148),43,0,G2H4(18),n2h4(146))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(76),wf4(:,4),G1H2(96),m3h4x2(:,24),heltab2x8(:,:,170))
  call Hloop_VA_Q(ntryL,G1H8(79),ex4(:),G1H4(82),m3h2x4(:,147),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(82),43,0,G2H4(27),n2h4(147))
  call Hloop_VA_Q(ntryL,G1H8(80),ex4(:),G1H4(94),m3h2x4(:,148),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(94),43,0,G2H4(29),n2h4(148))
  call Hloop_VQ_A(ntryL,G1H8(81),wf4(:,4),G1H2(97),m3h4x2(:,25),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(217),n2h2(187))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex4(:),G1H4(106),m3h2x4(:,149),heltab2x8(:,:,174))
  call Hloop_VQ_A(ntryL,G1H8(85),wf4(:,4),G1H2(97),m3h4x2(:,26),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(218),n2h2(188))
  call Hloop_VQ_A(ntryL,G1H8(86),wf4(:,4),G1H2(97),m3h4x2(:,27),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(219),n2h2(189))
  call Hloop_VQ_A(ntryL,G1H8(87),wf4(:,4),G1H2(97),m3h4x2(:,28),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(220),n2h2(190))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(88),ex4(:),G1H4(118),m3h2x4(:,150),heltab2x8(:,:,178))
  call Hloop_VQ_A(ntryL,G1H8(91),wf4(:,4),G1H2(97),m3h4x2(:,29),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(221),n2h2(191))
  call Hloop_VQ_A(ntryL,G1H8(92),wf4(:,4),G1H2(97),m3h4x2(:,30),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(222),n2h2(192))
  call Hloop_VQ_A(ntryL,G1H8(93),ex3(:),G1H4(5),m3h2x4(:,151),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(30),n2h4(149))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(94),wf4(:,9),G1H2(97),m3h4x2(:,31),heltab2x8(:,:,182))
  call Hloop_VQ_A(ntryL,G1H8(97),ex3(:),G1H4(6),m3h2x4(:,152),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(6),39,0,G2H4(32),n2h4(150))
  call Hloop_VQ_A(ntryL,G1H8(98),ex3(:),G1H4(10),m3h2x4(:,153),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(10),39,0,G2H4(33),n2h4(151))
  call Hloop_VQ_A(ntryL,G1H8(99),ex3(:),G1H4(11),m3h2x4(:,154),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(11),39,0,G2H4(36),n2h4(152))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(100),wf4(:,9),G1H2(98),m3h4x2(:,32),heltab2x8(:,:,186))
  call Hloop_VQ_A(ntryL,G1H8(103),ex3(:),G1H4(17),m3h2x4(:,155),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(17),39,0,G2H4(45),n2h4(153))
  call Hloop_VQ_A(ntryL,G1H8(104),ex3(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(18),39,0,G2H4(48),n2h4(154))
  call Hloop_VA_Q(ntryL,G1H8(105),wf4(:,9),G1H2(99),m3h4x2(:,33),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(223),n2h2(193))
call HGT_raise_alpha_OLR(G1H8(106),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(106),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(106),ex3(:),G1H4(22),m3h2x4(:,157),heltab2x8(:,:,190))
  call Hloop_VA_Q(ntryL,G1H8(109),wf4(:,9),G1H2(99),m3h4x2(:,34),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(224),n2h2(194))
  call Hloop_VA_Q(ntryL,G1H8(110),wf4(:,9),G1H2(99),m3h4x2(:,35),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(225),n2h2(195))
  call Hloop_VA_Q(ntryL,G1H8(111),wf4(:,9),G1H2(99),m3h4x2(:,36),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(226),n2h2(196))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(112),ex3(:),G1H4(23),m3h2x4(:,158),heltab2x8(:,:,194))
  call Hloop_VA_Q(ntryL,G1H8(115),wf4(:,9),G1H2(99),m3h4x2(:,37),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(227),n2h2(197))
  call Hloop_VA_Q(ntryL,G1H8(116),wf4(:,9),G1H2(99),m3h4x2(:,38),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(99),59,0,G2H2(228),n2h2(198))
call HGT_raise_alpha_OLR(G1H4(206),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(206),ex4(:),G1H2(99),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_QV_A(ntryL,G1H4(209),ex5(:),G1H2(100),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(100),55,0,G2H2(229),n2h2(199))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(211),ex3(:),G1H2(100),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_AV_Q(ntryL,G1H4(214),ex5(:),G1H2(101),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(101),59,0,G2H2(230),n2h2(200))
  call Hloop_QV_A(ntryL,G1H8(117),wf4(:,1),G1H2(101),m3h4x2(:,39),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(231),n2h2(201))
call HGT_raise_alpha_OLR(G1H8(118),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(118),ex4(:),G1H4(47),m3h2x4(:,159),heltab2x8(:,:,198))
  call Hloop_QV_A(ntryL,G1H8(123),wf4(:,1),G1H2(101),m3h4x2(:,40),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(232),n2h2(202))
  call Hloop_QV_A(ntryL,G1H8(128),wf4(:,1),G1H2(101),m3h4x2(:,41),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(233),n2h2(203))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(124),ex4(:),G1H4(48),m3h2x4(:,160),heltab2x8(:,:,201))
  call Hloop_QV_A(ntryL,G1H8(127),wf4(:,1),G1H2(101),m3h4x2(:,42),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(234),n2h2(204))
call HGT_raise_alpha_OLR(G1H8(129),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(129),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(129),ex4(:),G1H4(52),m3h2x4(:,161),heltab2x8(:,:,203))
  call Hloop_QV_A(ntryL,G1H8(132),wf4(:,1),G1H2(101),m3h4x2(:,43),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(235),n2h2(205))
  call Hloop_QV_A(ntryL,G1H4(215),ex5(:),G1H2(101),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(236),n2h2(206))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(216),ex4(:),G1H2(101),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(102),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(102),55,0,G2H2(237),n2h2(207))
  call Hloop_QV_A(ntryL,G1H4(226),ex5(:),G1H2(102),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(102),55,0,G2H2(238),n2h2(208))
call HGT_raise_alpha_OLR(G1H4(222),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(222),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(222),ex4(:),G1H2(102),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(103),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(103),55,0,G2H2(239),n2h2(209))
call HGT_raise_alpha_OLR(G1H4(227),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(227),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(227),ex4(:),G1H2(103),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_QV_A(ntryL,G1H4(230),ex5(:),G1H2(104),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(104),55,0,G2H2(240),n2h2(210))
  call Hloop_QV_A(ntryL,G1H8(133),wf4(:,12),G1H2(104),m3h4x2(:,44),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(241),n2h2(211))
call HGT_raise_alpha_OLR(G1H8(134),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(134),ex2(:),G1H4(54),m3h2x4(:,162),heltab2x8(:,:,206))
  call Hloop_QV_A(ntryL,G1H8(139),wf4(:,12),G1H2(104),m3h4x2(:,45),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(242),n2h2(212))
  call Hloop_QV_A(ntryL,G1H8(144),wf4(:,12),G1H2(104),m3h4x2(:,46),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(243),n2h2(213))
call HGT_raise_alpha_OLR(G1H8(140),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(140),ex2(:),G1H4(64),m3h2x4(:,163),heltab2x8(:,:,209))
  call Hloop_QV_A(ntryL,G1H8(143),wf4(:,12),G1H2(104),m3h4x2(:,47),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(244),n2h2(214))
call HGT_raise_alpha_OLR(G1H8(145),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(145),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(145),ex2(:),G1H4(65),m3h2x4(:,164),heltab2x8(:,:,211))
  call Hloop_QV_A(ntryL,G1H8(148),wf4(:,12),G1H2(104),m3h4x2(:,48),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(245),n2h2(215))
  call Hloop_QV_A(ntryL,G1H4(231),ex5(:),G1H2(104),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(246),n2h2(216))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(232),ex2(:),G1H2(104),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_QV_A(ntryL,G1H4(237),ex5(:),G1H2(105),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(105),61,0,G2H2(247),n2h2(217))
  call Hloop_QV_A(ntryL,G1H4(242),ex5(:),G1H2(105),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(105),61,0,G2H2(248),n2h2(218))
call HGT_raise_alpha_OLR(G1H4(238),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(238),ex2(:),G1H2(105),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_QV_A(ntryL,G1H4(241),ex5(:),G1H2(106),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(106),61,0,G2H2(249),n2h2(219))
call HGT_raise_alpha_OLR(G1H4(243),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(243),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(243),ex2(:),G1H2(106),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_QV_A(ntryL,G1H4(246),ex5(:),G1H2(107),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(107),61,0,G2H2(250),n2h2(220))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(2),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(4),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(6),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(8),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(88)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(31)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(3)])
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(19)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(43)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(220),[G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(61)])
call HGT_w2_OLR(G1H2(11),1,1,2)
call HGT_w2_invQ_OLR(G1H2(11),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(55)])
call HGT_w2_OLR(G1H2(13),1,1,2)
call HGT_w2_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(217),[G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(49)])
call HGT_w2_OLR(G1H2(15),1,1,2)
call HGT_w2_invQ_OLR(G1H2(15),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(223),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(57),G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G1H2(63),G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G1H2(81),G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G1H2(87),G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(86)])
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(75),mass5set(:,1),  & 
G1H2(107),G1H2(22),G1H2(28),G1H2(34),G1H2(40),G1H2(46),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(76),mass5set(:,1),  & 
G1H2(52),G1H2(58),G1H2(64),G1H2(70),G1H2(76),G1H2(82),2)
  call HG1shiftOLR(G1H2(58),2,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(77),mass5set(:,1),  & 
G1H2(88),G1H2(1),G1H2(31),G1H2(3),G1H2(5),G1H2(19),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(78),mass5set(:,1),  & 
G1H2(7),G1H2(43),G1H2(9),G1H2(61),G1H2(11),G1H2(55),2)
  call HG1shiftOLR(G1H2(43),2,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(79),mass5set(:,1),  & 
G1H2(13),G1H2(49),G1H2(15),G1H2(20),G1H2(21),G1H2(25),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(80),mass5set(:,1),  & 
G1H2(26),G1H2(27),G1H2(32),G1H2(33),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(27),16,2)
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(81),mass5set(:,1),  & 
G1H2(39),G1H2(44),G1H2(57),G1H2(45),G1H2(50),G1H2(63),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(82),mass5set(:,1),  & 
G1H2(51),G1H2(56),G1H2(62),G1H2(67),G1H2(68),G1H2(81),2)
  call HG1shiftOLR(G1H2(56),16,2)
call HGT_OLR(G2H2(16),1,1,2)
call HGT_invQ_OLR(G2H2(16),2,5,2)
call HGT_OLR(G2H2(16),6,15,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(83),mass5set(:,1),  & 
G1H2(69),G1H2(73),G1H2(74),G1H2(87),G1H2(75),G1H2(79),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(84),mass5set(:,1),  & 
G1H2(80),G1H2(85),G1H2(86),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(85),16,2)
call HGT_OLR(G2H2(19),1,1,2)
call HGT_invQ_OLR(G2H2(19),2,5,2)
call HGT_OLR(G2H2(19),6,15,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(85),mass5set(:,1),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),8,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(86),mass5set(:,1),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(118),16,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(87),mass5set(:,1),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),1,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(88),mass5set(:,1),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),16,2)
call HGT_OLR(G2H2(25),1,1,2)
call HGT_invQ_OLR(G2H2(25),2,5,2)
call HGT_OLR(G2H2(25),6,15,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(89),mass5set(:,1),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(136),2,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(90),mass5set(:,1),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(142),16,2)
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(91),mass5set(:,1),  & 
G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(148),1,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(92),mass5set(:,1),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(154),16,2)
call HGT_OLR(G2H2(31),1,1,2)
call HGT_invQ_OLR(G2H2(31),2,5,2)
call HGT_OLR(G2H2(31),6,15,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(93),mass5set(:,1),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(160),2,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(94),mass5set(:,1),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(166),16,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(95),mass5set(:,1),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(172),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(1),m3h2x1(:,33),heltab2x2(:,:,33))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(3),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(96),mass5set(:,1),  & 
G1H2(2),G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),2)
  call HG1shiftOLR(G1H2(177),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(4),m3h2x1(:,36),heltab2x2(:,:,36))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(26))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex3(:),G2tensor(6),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(97),mass5set(:,1),  & 
G1H2(4),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(7),m3h2x1(:,39),heltab2x2(:,:,39))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(9),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(98),mass5set(:,1),  & 
G1H2(6),G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),2)
  call HG1shiftOLR(G1H2(187),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(43),ex3(:),G2tensor(11),m3h2x1(:,42),heltab2x2(:,:,42))
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(44),ex3(:),G2tensor(15),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(99),mass5set(:,1),  & 
G1H2(8),G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(192),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(220),ex4(:),G2tensor(17),m3h2x1(:,45),heltab2x2(:,:,45))
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(29))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(222),ex4(:),G2tensor(21),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(100),mass5set(:,1),  & 
G1H2(10),G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),2)
  call HG1shiftOLR(G1H2(197),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(226),ex3(:),G2tensor(23),m3h2x1(:,48),heltab2x2(:,:,48))
call HGT_w2_OLR(G1H2(12),1,1,2)
call HGT_w2_invQ_OLR(G1H2(12),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(30))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(228),ex3(:),G2tensor(27),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(101),mass5set(:,1),  & 
G1H2(12),G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(202),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(217),ex4(:),G2tensor(29),m3h2x1(:,51),heltab2x2(:,:,51))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(219),ex4(:),G2tensor(33),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(102),mass5set(:,1),  & 
G1H2(14),G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(207),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(223),ex3(:),G2tensor(34),m3h2x1(:,54),heltab2x2(:,:,54))
call HGT_w2_OLR(G1H2(16),1,1,2)
call HGT_w2_invQ_OLR(G1H2(16),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(32))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(225),ex3(:),G2tensor(36),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(103),mass5set(:,1),  & 
G1H2(16),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(104),mass5set(:,1),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(105),mass5set(:,1),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),2,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(106),mass5set(:,1),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),2,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(107),mass5set(:,1),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),2,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(108),mass5set(:,1),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(109),mass5set(:,1),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),8,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(110),mass5set(:,1),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),2,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(111),mass5set(:,1),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),2,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(112),mass5set(:,1),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),2,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(113),mass5set(:,1),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),16,2)
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(47),mass5set(:,1),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(114),mass5set(:,1),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(48),mass5set(:,1),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(115),mass5set(:,1),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(116),mass5set(:,1),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(117),mass5set(:,1),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(118),mass5set(:,1),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),16,2)
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(49),mass5set(:,1),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(119),mass5set(:,1),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(120),mass5set(:,1),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(50),mass5set(:,1),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(121),mass5set(:,1),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(122),mass5set(:,1),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(123),mass5set(:,1),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(124),mass5set(:,1),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),16,2)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(17),mass5set(:,1),  & 
G1H4(66),G1H4(71),G1H4(77),G1H4(78),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(71),17,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(15),mass5set(:,1),  & 
G1H4(90),G1H4(95),G1H4(96),G1H4(100),G1H4(81),G1H4(93),4)
  call HG1shiftOLR(G1H4(95),17,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(16),mass5set(:,1),  & 
G1H4(7),G1H4(36),G1H4(34),G1H4(117),G1H4(19),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),18,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(18),mass5set(:,1),  & 
G1H4(35),G1H4(141),G1H4(103),G1H4(115),G1H4(27),G1H4(15),4)
  call HG1shiftOLR(G1H4(141),18,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(13),mass5set(:,1),  & 
G1H4(31),G1H4(45),G1H4(51),G1H4(39),G1H4(43),G1H4(49),4)
  call HG1shiftOLR(G1H4(45),20,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(11),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(79),G1H4(80),G1H4(128),G1H4(104),4)
  call HG1shiftOLR(G1H4(68),20,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(12),mass5set(:,1),  & 
G1H4(134),G1H4(110),G1H4(146),G1H4(122),G1H4(127),G1H4(139),4)
  call HG1shiftOLR(G1H4(110),24,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(14),mass5set(:,1),  & 
G1H4(3),G1H4(4),G1H4(8),G1H4(14),G1H4(29),G1H4(32),4)
  call HG1shiftOLR(G1H4(4),24,4)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(29),mass5set(:,1),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),8,2)
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(235),mass4set(:,1),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),12,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(30),mass5set(:,1),  & 
G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),2)
  call HG1shiftOLR(G1H2(379),4,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(235),mass4set(:,1),  & 
G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(385),12,2)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(2),mass5set(:,1),  & 
G1H4(28),G1H4(38),G1H4(24),G1H4(50),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(38),12,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(37),mass4set(:,1),  & 
G1H4(74),G1H4(75),G1H4(85),G1H4(86),G1H4(150),4)
  call HG1shiftOLR(G1H4(75),14,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(1),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(156),G1H4(157),G1H4(97),4)
  call HG1shiftOLR(G1H4(152),12,4)
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(13),mass4set(:,1),  & 
G1H4(98),G1H4(109),G1H4(205),G1H4(161),G1H4(164),4)
  call HG1shiftOLR(G1H4(109),13,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(97),ex4(:),G2tensor(37),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex4(:),G2tensor(38),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(100),ex3(:),G2tensor(39),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(102),ex3(:),G2tensor(40),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(103),ex4(:),G2tensor(41),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(105),ex4(:),G2tensor(42),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(106),ex3(:),G2tensor(43),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(108),ex3(:),G2tensor(44),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(109),ex4(:),G2tensor(45),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(111),ex4(:),G2tensor(46),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(112),ex3(:),G2tensor(47),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(114),ex3(:),G2tensor(48),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex4(:),G2tensor(49),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(50),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(118),ex3(:),G2tensor(51),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(120),ex3(:),G2tensor(52),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(121),ex2(:),G2tensor(53),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(123),ex2(:),G2tensor(54),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(124),ex4(:),G2tensor(55),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(126),ex4(:),G2tensor(56),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(127),ex1(:),G2tensor(57),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(129),ex1(:),G2tensor(58),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(130),ex3(:),G2tensor(59),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(132),ex3(:),G2tensor(60),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(155),mass4set(:,1),  & 
G1H2(389),G1H2(390),G1H2(391),G1H2(392),G1H2(393),2)
  call HG1shiftOLR(G1H2(390),20,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(169),mass4set(:,1),  & 
G1H2(394),G1H2(395),G1H2(396),G1H2(397),G1H2(398),2)
  call HG1shiftOLR(G1H2(395),24,2)
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(199),mass4set(:,1),  & 
G1H2(399),G1H2(400),G1H2(401),G1H2(402),G1H2(403),2)
  call HG1shiftOLR(G1H2(400),17,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(213),mass4set(:,1),  & 
G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(405),18,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(149),ex4(:),G2tensor(61),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(151),ex4(:),G2tensor(62),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(152),ex4(:),G2tensor(63),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(154),ex4(:),G2tensor(64),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(155),ex3(:),G2tensor(65),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(157),ex3(:),G2tensor(66),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(158),ex3(:),G2tensor(67),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(160),ex3(:),G2tensor(68),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(161),ex4(:),G2tensor(69),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(163),ex4(:),G2tensor(70),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(164),ex4(:),G2tensor(71),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(166),ex4(:),G2tensor(72),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(167),ex3(:),G2tensor(73),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(169),ex3(:),G2tensor(74),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(170),ex3(:),G2tensor(75),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(172),ex3(:),G2tensor(76),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(173),ex4(:),G2tensor(77),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(175),ex4(:),G2tensor(78),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(177),ex3(:),G2tensor(79),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(179),ex3(:),G2tensor(80),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(181),ex4(:),G2tensor(81),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(183),ex4(:),G2tensor(82),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(184),ex3(:),G2tensor(83),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(186),ex3(:),G2tensor(84),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hotf_5pt_reduction(G2H2(187),RedSet_5(61),mass5set(:,1),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),16,2)
  call Hotf_4pt_reduction(G2H2(190),RedSet_4(70),mass4set(:,1),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),2)
  call HG1shiftOLR(G1H2(416),20,2)
  call Hotf_5pt_reduction(G2H2(191),RedSet_5(62),mass5set(:,1),  & 
G1H2(420),G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),2)
  call HG1shiftOLR(G1H2(421),16,2)
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(236),mass4set(:,1),  & 
G1H2(426),G1H2(427),G1H2(428),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(427),19,2)
  call Hotf_5pt_reduction(G2H2(194),RedSet_5(63),mass5set(:,1),  & 
G1H2(431),G1H2(432),G1H2(433),G1H2(434),G1H2(435),G1H2(436),2)
  call HG1shiftOLR(G1H2(432),16,2)
  call Hotf_4pt_reduction(G2H2(197),RedSet_4(56),mass4set(:,1),  & 
G1H2(437),G1H2(438),G1H2(439),G1H2(440),G1H2(441),2)
  call HG1shiftOLR(G1H2(438),24,2)
  call Hotf_5pt_reduction(G2H2(198),RedSet_5(64),mass5set(:,1),  & 
G1H2(442),G1H2(443),G1H2(444),G1H2(445),G1H2(446),G1H2(447),2)
  call HG1shiftOLR(G1H2(443),16,2)
  call Hotf_4pt_reduction(G2H2(200),RedSet_4(237),mass4set(:,1),  & 
G1H2(448),G1H2(449),G1H2(450),G1H2(451),G1H2(452),2)
  call HG1shiftOLR(G1H2(449),19,2)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(65),mass5set(:,1),  & 
G1H4(111),G1H4(165),G1H4(121),G1H4(210),G1H4(170),G1H4(173),4)
  call HG1shiftOLR(G1H4(165),12,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(60),mass4set(:,1),  & 
G1H4(123),G1H4(174),G1H4(177),G1H4(178),G1H4(133),4)
  call HG1shiftOLR(G1H4(174),28,4)
  call Hotf_5pt_reduction(G2H2(202),RedSet_5(66),mass5set(:,1),  & 
G1H2(453),G1H2(454),G1H2(455),G1H2(456),G1H2(457),G1H2(458),2)
  call HG1shiftOLR(G1H2(454),16,2)
  call Hotf_4pt_reduction(G2H2(205),RedSet_4(238),mass4set(:,1),  & 
G1H2(459),G1H2(460),G1H2(461),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(460),17,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(67),mass5set(:,1),  & 
G1H4(135),G1H4(181),G1H4(182),G1H4(145),G1H4(147),G1H4(185),4)
  call HG1shiftOLR(G1H4(181),12,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(82),mass4set(:,1),  & 
G1H4(186),G1H4(187),G1H4(188),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(187),28,4)
  call Hotf_5pt_reduction(G2H2(207),RedSet_5(68),mass5set(:,1),  & 
G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),G1H2(469),2)
  call HG1shiftOLR(G1H2(465),16,2)
  call Hotf_4pt_reduction(G2H2(209),RedSet_4(82),mass4set(:,1),  & 
G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(471),28,2)
  call Hotf_5pt_reduction(G2H2(210),RedSet_5(69),mass5set(:,1),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),16,2)
  call Hotf_4pt_reduction(G2H2(213),RedSet_4(239),mass4set(:,1),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),2)
  call HG1shiftOLR(G1H2(482),18,2)
  call Hotf_5pt_reduction(G2H2(214),RedSet_5(70),mass5set(:,1),  & 
G1H2(486),G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),2)
  call HG1shiftOLR(G1H2(487),16,2)
  call Hotf_4pt_reduction(G2H2(216),RedSet_4(60),mass4set(:,1),  & 
G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(493),28,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(40),wf4(:,13),G2tensor(85),m3h4x1(:,1),heltab2x4(:,:,281))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(41),wf4(:,13),G2tensor(86),m3h4x1(:,2),heltab2x4(:,:,282))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(17),wf4(:,13),G2tensor(87),m3h4x1(:,3),heltab2x4(:,:,283))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(20),wf4(:,13),G2tensor(88),m3h4x1(:,4),heltab2x4(:,:,284))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(55),wf4(:,18),G2tensor(89),m3h4x1(:,5),heltab2x4(:,:,285))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(59),wf4(:,18),G2tensor(90),m3h4x1(:,6),heltab2x4(:,:,286))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(61),wf4(:,18),G2tensor(91),m3h4x1(:,7),heltab2x4(:,:,287))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(26),wf4(:,18),G2tensor(92),m3h4x1(:,8),heltab2x4(:,:,288))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(9),wf4(:,4),G2tensor(93),m3h4x1(:,9),heltab2x4(:,:,289))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(15),wf4(:,4),G2tensor(94),m3h4x1(:,10),heltab2x4(:,:,290))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(18),wf4(:,4),G2tensor(95),m3h4x1(:,11),heltab2x4(:,:,291))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(29),wf4(:,4),G2tensor(96),m3h4x1(:,12),heltab2x4(:,:,292))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(30),wf4(:,9),G2tensor(97),m3h4x1(:,13),heltab2x4(:,:,293))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(33),wf4(:,9),G2tensor(98),m3h4x1(:,14),heltab2x4(:,:,294))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(36),wf4(:,9),G2tensor(99),m3h4x1(:,15),heltab2x4(:,:,295))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(48),wf4(:,9),G2tensor(100),m3h4x1(:,16),heltab2x4(:,:,296))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(231),ex4(:),G2tensor(101),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(233),ex4(:),G2tensor(102),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(236),ex4(:),G2tensor(103),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(238),ex4(:),G2tensor(104),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(241),ex2(:),G2tensor(105),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(243),ex2(:),G2tensor(106),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(246),ex2(:),G2tensor(107),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(248),ex2(:),G2tensor(108),m3h2x1(:,112),heltab2x2(:,:,112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(389),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(394),[G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(399),[G1H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(373),[G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(384),[G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(415),[G1H2(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(426),[G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(437),[G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(448),[G1H2(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(459),[G1H2(458)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(470),[G1H2(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(481),[G1H2(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(492),[G1H2(491)])
  call Hloop_VA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(110),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(35))
  call Hloop_VA_Q(ntryL,G1H2(52),ex2(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(36))
  call Hloop_VA_Q(ntryL,G1H2(58),ex2(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(113),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(116),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(119),n2h1(43))
  call Hloop_VA_Q(ntryL,G1H2(55),ex2(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(122),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(125),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(128),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(131),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(134),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(79),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(137),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(140),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(117),ex5(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(143),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(123),ex1(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(124),ex1(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(146),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(128),ex1(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(149),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(135),ex2(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(136),ex2(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(152),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(140),ex2(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(155),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(147),ex1(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(148),ex1(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(158),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(152),ex1(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(153),ex5(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(161),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(160),ex2(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(164),n2h1(88))
  call Hloop_VA_Q(ntryL,G1H2(164),ex2(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(165),ex5(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(167),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(171),ex3(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(170),n2h1(94))
  call Hloop_VQ_A(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(173),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(176),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(187),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(179),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(192),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(182),n2h1(106))
  call Hloop_QV_A(ntryL,G1H2(196),ex5(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(197),ex5(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(185),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(201),ex5(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(202),ex5(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(188),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(191),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(117))
  call Hloop_VA_Q(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(194),n2h1(118))
  call Hloop_VA_Q(ntryL,G1H2(216),ex4(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(119))
  call Hloop_VA_Q(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(120))
  call Hloop_VA_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(197),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(122))
  call Hloop_VA_Q(ntryL,G1H2(223),ex2(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(123))
  call Hloop_VA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(200),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(228),ex2(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H2(229),ex2(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(202),n2h1(126))
  call Hloop_VA_Q(ntryL,G1H2(230),ex2(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(203),n2h1(127))
  call Hloop_VA_Q(ntryL,G1H2(234),ex2(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(128))
  call Hloop_VA_Q(ntryL,G1H2(235),ex2(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(129))
  call Hloop_VA_Q(ntryL,G1H2(236),ex2(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(206),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H2(240),ex2(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(131))
  call Hloop_VA_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(208),n2h1(132))
  call Hloop_VA_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(209),n2h1(133))
  call Hloop_VA_Q(ntryL,G1H2(246),ex4(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(247),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(211),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(212),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(252),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(213),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(253),ex2(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(214),n2h1(138))
  call Hloop_VA_Q(ntryL,G1H2(254),ex2(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(215),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(258),ex2(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(216),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(259),ex2(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H2(260),ex2(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(218),n2h1(142))
  call Hloop_VA_Q(ntryL,G1H2(264),ex2(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(219),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(265),ex2(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(220),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(266),ex2(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(221),n2h1(145))
  call Hloop_VA_Q(ntryL,G1H2(270),ex2(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(146))
  call Hloop_QV_A(ntryL,G1H2(271),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(223),n2h1(147))
  call Hloop_QV_A(ntryL,G1H2(272),ex5(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(224),n2h1(148))
  call Hloop_QV_A(ntryL,G1H2(276),ex5(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(225),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(278),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(227),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(389),ex5(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(228),n2h1(152))
  call Hloop_AV_Q(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(229),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H2(284),ex5(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(230),n2h1(154))
  call Hloop_AV_Q(ntryL,G1H2(288),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(155))
  call Hloop_AV_Q(ntryL,G1H2(289),ex5(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(156))
  call Hloop_AV_Q(ntryL,G1H2(290),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(233),n2h1(157))
  call Hloop_AV_Q(ntryL,G1H2(394),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(234),n2h1(158))
  call Hloop_QV_A(ntryL,G1H2(295),ex5(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(296),ex5(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(236),n2h1(160))
  call Hloop_QV_A(ntryL,G1H2(300),ex5(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(161))
  call Hloop_AV_Q(ntryL,G1H2(301),ex5(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(302),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(239),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(307),ex5(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(308),ex5(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(242),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(312),ex5(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(313),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(245),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(318),ex5(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(319),ex5(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(171))
  call Hloop_QV_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(248),n2h1(172))
  call Hloop_QV_A(ntryL,G1H2(399),ex5(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(325),ex5(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(174))
  call Hloop_AV_Q(ntryL,G1H2(326),ex5(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(251),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H2(330),ex5(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(252),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(253),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(254),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H2(336),ex5(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(255),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(256),n2h1(180))
  call Hloop_AV_Q(ntryL,G1H2(338),ex5(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(257),n2h1(181))
  call Hloop_AV_Q(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(258),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(343),ex5(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(259),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(260),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(348),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(261),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(349),ex5(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(186))
  call Hloop_QV_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(263),n2h1(187))
  call Hloop_QV_A(ntryL,G1H2(354),ex5(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(264),n2h1(188))
  call Hloop_AV_Q(ntryL,G1H2(355),ex5(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(189))
  call Hloop_AV_Q(ntryL,G1H2(356),ex5(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(266),n2h1(190))
  call Hloop_AV_Q(ntryL,G1H2(360),ex5(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(267),n2h1(191))
  call Hloop_AV_Q(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(192))
  call Hloop_AV_Q(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(269),n2h1(193))
  call Hloop_AV_Q(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(270),n2h1(194))
  call Hloop_VQ_A(ntryL,G1H4(66),wf4(:,13),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(271),n2h1(195))
  call Hloop_VQ_A(ntryL,G1H4(71),wf4(:,13),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(272),n2h1(196))
  call Hloop_VQ_A(ntryL,G1H4(84),wf4(:,13),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(197))
  call Hloop_VQ_A(ntryL,G1H4(90),wf4(:,13),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H4(95),wf4(:,13),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(275),n2h1(199))
  call Hloop_VQ_A(ntryL,G1H4(93),wf4(:,13),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(276),n2h1(200))
  call Hloop_VA_Q(ntryL,G1H4(7),wf4(:,18),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(201))
  call Hloop_VA_Q(ntryL,G1H4(36),wf4(:,18),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(278),n2h1(202))
  call Hloop_VA_Q(ntryL,G1H4(40),wf4(:,18),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(279),n2h1(203))
  call Hloop_VA_Q(ntryL,G1H4(35),wf4(:,18),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(204))
  call Hloop_VA_Q(ntryL,G1H4(141),wf4(:,18),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(281),n2h1(205))
  call Hloop_VA_Q(ntryL,G1H4(15),wf4(:,18),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(282),n2h1(206))
  call Hloop_VQ_A(ntryL,G1H4(31),wf4(:,4),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(207))
  call Hloop_VQ_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(284),n2h1(208))
  call Hloop_VQ_A(ntryL,G1H4(49),wf4(:,4),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(285),n2h1(209))
  call Hloop_VQ_A(ntryL,G1H4(67),wf4(:,4),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(210))
  call Hloop_VQ_A(ntryL,G1H4(68),wf4(:,4),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(287),n2h1(211))
  call Hloop_VQ_A(ntryL,G1H4(104),wf4(:,4),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(288),n2h1(212))
  call Hloop_VA_Q(ntryL,G1H4(134),wf4(:,9),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(213))
  call Hloop_VA_Q(ntryL,G1H4(110),wf4(:,9),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(290),n2h1(214))
  call Hloop_VA_Q(ntryL,G1H4(139),wf4(:,9),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(291),n2h1(215))
  call Hloop_VA_Q(ntryL,G1H4(3),wf4(:,9),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(216))
  call Hloop_VA_Q(ntryL,G1H4(4),wf4(:,9),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(293),n2h1(217))
  call Hloop_VA_Q(ntryL,G1H4(32),wf4(:,9),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(294),n2h1(218))
  call Hloop_VA_Q(ntryL,G1H2(367),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(219))
  call Hloop_VA_Q(ntryL,G1H2(368),ex4(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(296),n2h1(220))
  call Hloop_VA_Q(ntryL,G1H2(373),ex4(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(297),n2h1(221))
  call Hloop_VA_Q(ntryL,G1H2(374),ex4(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(298),n2h1(222))
  call Hloop_VQ_A(ntryL,G1H2(378),ex3(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(223))
  call Hloop_VQ_A(ntryL,G1H2(379),ex3(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(300),n2h1(224))
  call Hloop_VQ_A(ntryL,G1H2(384),ex3(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(301),n2h1(225))
  call Hloop_VQ_A(ntryL,G1H2(385),ex3(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(302),n2h1(226))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(28),51,wf4(:,12),12,G2tensor(303),m3h4x1(:,41),heltab2x4(:,:,321))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(38),0,wf4(:,12),12,G2tensor(304),m3h4x1(:,42),heltab2x4(:,:,322))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(74),51,wf4(:,12),12,G2tensor(305),m3h4x1(:,43),heltab2x4(:,:,323))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(75),2,wf4(:,12),12,G2tensor(306),m3h4x1(:,44),heltab2x4(:,:,324))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(151),51,wf4(:,12),12,G2tensor(307),m3h4x1(:,45),heltab2x4(:,:,325))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(152),0,wf4(:,12),12,G2tensor(308),m3h4x1(:,46),heltab2x4(:,:,326))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(98),51,wf4(:,12),12,G2tensor(309),m3h4x1(:,47),heltab2x4(:,:,327))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(109),1,wf4(:,12),12,G2tensor(310),m3h4x1(:,48),heltab2x4(:,:,328))
  call Hloop_QV_A(ntryL,G1H2(390),ex5(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(311),n2h1(231))
  call Hloop_AV_Q(ntryL,G1H2(395),ex5(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(312),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(400),ex5(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(313),n2h1(233))
  call Hloop_AV_Q(ntryL,G1H2(405),ex5(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(314),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(409),ex5(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(315),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(410),ex5(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(316),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(415),ex5(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(416),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(318),n2h1(238))
  call Hloop_AV_Q(ntryL,G1H2(420),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H2(421),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(320),n2h1(240))
  call Hloop_AV_Q(ntryL,G1H2(426),ex5(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(321),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H2(427),ex5(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(322),n2h1(242))
  call Hloop_AV_Q(ntryL,G1H2(431),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(243))
  call Hloop_AV_Q(ntryL,G1H2(432),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(324),n2h1(244))
  call Hloop_AV_Q(ntryL,G1H2(437),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(245))
  call Hloop_AV_Q(ntryL,G1H2(438),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(326),n2h1(246))
  call Hloop_QV_A(ntryL,G1H2(442),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(327),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(443),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(328),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(448),ex5(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(249))
  call Hloop_QV_A(ntryL,G1H2(449),ex5(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(330),n2h1(250))
  call Hloop_QV_A(ntryL,G1H4(111),wf4(:,12),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(331),n2h1(251))
  call Hloop_QV_A(ntryL,G1H4(165),wf4(:,12),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(332),n2h1(252))
  call Hloop_QV_A(ntryL,G1H4(123),wf4(:,12),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(333),n2h1(253))
  call Hloop_QV_A(ntryL,G1H4(174),wf4(:,12),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(334),n2h1(254))
  call Hloop_QV_A(ntryL,G1H2(453),ex5(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(255))
  call Hloop_QV_A(ntryL,G1H2(454),ex5(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(336),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(459),ex5(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(337),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(460),ex5(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(338),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H4(135),wf4(:,12),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(339),n2h1(259))
  call Hloop_AV_Q(ntryL,G1H4(181),wf4(:,12),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(340),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H4(186),wf4(:,12),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H4(187),wf4(:,12),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(342),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(464),ex5(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(465),ex5(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(344),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(470),ex5(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(345),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(471),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(346),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(475),ex5(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(267))
  call Hloop_AV_Q(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(348),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H2(481),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(349),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(482),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(350),n2h1(270))
  call Hloop_QV_A(ntryL,G1H2(486),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(351),n2h1(271))
  call Hloop_QV_A(ntryL,G1H2(487),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(352),n2h1(272))
  call Hloop_QV_A(ntryL,G1H2(492),ex5(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(273))
  call Hloop_QV_A(ntryL,G1H2(493),ex5(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(354),n2h1(274))
  call ol_merge_tensors(G2tensor(53),[G2tensor(10),G1tensor(50)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(12),G1tensor(56),G1tensor(27)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(14),G1tensor(62)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(16),G1tensor(68),G1tensor(33)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(18),G1tensor(74)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(20),G1tensor(80)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(22),G1tensor(86)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(24),G1tensor(92)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(26),G1tensor(98)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(28),G1tensor(104)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(30),G1tensor(110)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(32),G1tensor(116)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(63),G1tensor(8)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(51),G1tensor(20)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(75),G1tensor(26)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(40),G1tensor(28)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(93),G1tensor(32)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(87),G1tensor(38)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(81),G1tensor(44)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(66)])
  call ol_merge_tensors(G2tensor(214),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(220),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(223),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(226),[G1tensor(89),G1tensor(77)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(229),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(232),[G1tensor(95),G1tensor(83)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(235),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(238),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(241),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(244),[G1tensor(100)])
  call ol_merge_tensors(G2tensor(247),[G1tensor(113),G1tensor(101)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(250),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(253),[G1tensor(106)])
  call ol_merge_tensors(G2tensor(256),[G1tensor(119),G1tensor(107)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(259),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(262),[G1tensor(112)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(265),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(268),[G1tensor(118)])
  call ol_merge_tensors(G2tensor(166),[G1tensor(120)])
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(43),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(44),mass5set(:,1),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(45),mass5set(:,1),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),1)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(46),mass5set(:,1),  & 
G1tensor(109),G1tensor(115),G1tensor(50),G1tensor(56),G1tensor(27),G1tensor(62))
  call G_TensorShift(G1tensor(115),4)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(79),mass5set(:,1),  & 
G1tensor(68),G1tensor(33),G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(92))
  call G_TensorShift(G1tensor(33),4)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(81),mass5set(:,1),  & 
G1tensor(98),G1tensor(104),G1tensor(110),G1tensor(116),G1tensor(2),G1tensor(3))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(83),mass5set(:,1),  & 
G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(63),G1tensor(8),G1tensor(9))
  call G_TensorShift(G1tensor(5),4)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(85),mass5set(:,1),  & 
G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(14),G1tensor(15),G1tensor(16))
  call G_TensorShift(G1tensor(11),8)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(87),mass5set(:,1),  & 
G1tensor(17),G1tensor(18),G1tensor(51),G1tensor(20),G1tensor(21),G1tensor(22))
  call G_TensorShift(G1tensor(18),1)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(89),mass5set(:,1),  & 
G1tensor(23),G1tensor(24),G1tensor(75),G1tensor(26),G1tensor(40),G1tensor(28))
  call G_TensorShift(G1tensor(24),2)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(91),mass5set(:,1),  & 
G1tensor(29),G1tensor(30),G1tensor(93),G1tensor(32),G1tensor(46),G1tensor(34))
  call G_TensorShift(G1tensor(30),1)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(93),mass5set(:,1),  & 
G1tensor(35),G1tensor(36),G1tensor(87),G1tensor(38),G1tensor(39),G1tensor(41))
  call G_TensorShift(G1tensor(36),2)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(95),mass5set(:,1),  & 
G1tensor(42),G1tensor(81),G1tensor(44),G1tensor(45),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(81),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(51),mass5set(:,1),  & 
G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(59))
  call G_TensorShift(G1tensor(53),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(52),mass5set(:,1),  & 
G1tensor(60),G1tensor(64),G1tensor(65),G1tensor(66),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(64),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(35),mass5set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(76),G1tensor(89),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(19),mass5set(:,1),  & 
G1tensor(82),G1tensor(95),G1tensor(83),G1tensor(84),G1tensor(88),G1tensor(90))
  call G_TensorShift(G1tensor(95),8)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(96),mass5set(:,1),  & 
G1tensor(94),G1tensor(96),G1tensor(99),G1tensor(100),G1tensor(113),G1tensor(101))
  call G_TensorShift(G1tensor(96),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(53),mass5set(:,1),  & 
G1tensor(102),G1tensor(105),G1tensor(106),G1tensor(119),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(105),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(54),mass5set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(114),G1tensor(117),G1tensor(118),G1tensor(120))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(36),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(20),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(97),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(55),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(56),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(37),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(21),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(178),RedSet_5(98),mass5set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(57),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(58),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(38),mass5set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(22),mass5set(:,1),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(99),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(27),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(39),mass5set(:,1),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(23),mass5set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(184),RedSet_5(100),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(28),mass5set(:,1),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(40),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(24),mass5set(:,1),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(101),mass5set(:,1),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(59),mass5set(:,1),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(41),mass5set(:,1),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(25),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(190),RedSet_5(102),mass5set(:,1),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(60),mass5set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(42),mass5set(:,1),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),4)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(26),mass5set(:,1),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),4)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(103),mass5set(:,1),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(104),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(75),mass5set(:,1),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(105),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),2)
  call Hotf_5pt_reduction_last(G2tensor(202),RedSet_5(106),mass5set(:,1),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),2)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(107),mass5set(:,1),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),2)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(76),mass5set(:,1),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),2)
  call Hotf_5pt_reduction_last(G2tensor(208),RedSet_5(108),mass5set(:,1),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(109),mass5set(:,1),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(77),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_5pt_reduction_last(G2tensor(214),RedSet_5(110),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),2)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(111),mass5set(:,1),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),2)
  call Hotf_5pt_reduction_last(G2tensor(220),RedSet_5(112),mass5set(:,1),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),2)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(78),mass5set(:,1),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),2)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(113),mass5set(:,1),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(226),RedSet_5(47),mass5set(:,1),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(80),mass5set(:,1),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(114),mass5set(:,1),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(232),RedSet_5(48),mass5set(:,1),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(82),mass5set(:,1),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(235),RedSet_5(115),mass5set(:,1),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(84),mass5set(:,1),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(238),RedSet_5(116),mass5set(:,1),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(86),mass5set(:,1),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),16)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(117),mass5set(:,1),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),16)
  call Hotf_5pt_reduction_last(G2tensor(244),RedSet_5(118),mass5set(:,1),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(49),mass5set(:,1),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),16)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(88),mass5set(:,1),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),16)
  call Hotf_5pt_reduction_last(G2tensor(250),RedSet_5(119),mass5set(:,1),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),16)
  call Hotf_5pt_reduction_last(G2tensor(253),RedSet_5(120),mass5set(:,1),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(256),RedSet_5(50),mass5set(:,1),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(154),RedSet_5(90),mass5set(:,1),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(121),mass5set(:,1),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_5pt_reduction_last(G2tensor(262),RedSet_5(122),mass5set(:,1),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),16)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(92),mass5set(:,1),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),16)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(123),mass5set(:,1),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),16)
  call Hotf_5pt_reduction_last(G2tensor(268),RedSet_5(124),mass5set(:,1),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),16)
  call Hotf_5pt_reduction_last(G2tensor(166),RedSet_5(94),mass5set(:,1),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(71),mass5set(:,1),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),17)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(72),mass5set(:,1),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),17)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(73),mass5set(:,1),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),18)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(74),mass5set(:,1),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),18)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(4),mass5set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),20)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(6),mass5set(:,1),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),20)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(3),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),24)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(5),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),24)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(31),mass5set(:,1),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),8)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(32),mass5set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(33),mass5set(:,1),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),2)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(34),mass5set(:,1),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),2)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(17),mass5set(:,1),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),17)
  call Hotf_5pt_reduction_last(G2tensor(274),RedSet_5(15),mass5set(:,1),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),17)
  call Hotf_5pt_reduction_last(G2tensor(277),RedSet_5(16),mass5set(:,1),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),18)
  call Hotf_5pt_reduction_last(G2tensor(280),RedSet_5(18),mass5set(:,1),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),18)
  call Hotf_5pt_reduction_last(G2tensor(283),RedSet_5(13),mass5set(:,1),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),20)
  call Hotf_5pt_reduction_last(G2tensor(286),RedSet_5(11),mass5set(:,1),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),20)
  call Hotf_5pt_reduction_last(G2tensor(289),RedSet_5(12),mass5set(:,1),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),24)
  call Hotf_5pt_reduction_last(G2tensor(292),RedSet_5(14),mass5set(:,1),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),24)
  call Hotf_5pt_reduction_last(G2tensor(295),RedSet_5(29),mass5set(:,1),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),8)
  call Hotf_5pt_reduction_last(G2tensor(299),RedSet_5(30),mass5set(:,1),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),4)
  call Hotf_5pt_reduction_last(G2tensor(303),RedSet_5(2),mass5set(:,1),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),12)
  call Hotf_5pt_reduction_last(G2tensor(307),RedSet_5(1),mass5set(:,1),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),12)
  call Hotf_5pt_reduction_last(G2tensor(315),RedSet_5(61),mass5set(:,1),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),16)
  call Hotf_5pt_reduction_last(G2tensor(319),RedSet_5(62),mass5set(:,1),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),16)
  call Hotf_5pt_reduction_last(G2tensor(323),RedSet_5(63),mass5set(:,1),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),16)
  call Hotf_5pt_reduction_last(G2tensor(327),RedSet_5(64),mass5set(:,1),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),16)
  call Hotf_5pt_reduction_last(G2tensor(331),RedSet_5(65),mass5set(:,1),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),12)
  call Hotf_5pt_reduction_last(G2tensor(335),RedSet_5(66),mass5set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_5pt_reduction_last(G2tensor(339),RedSet_5(67),mass5set(:,1),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),12)
  call Hotf_5pt_reduction_last(G2tensor(343),RedSet_5(68),mass5set(:,1),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(347),RedSet_5(69),mass5set(:,1),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),16)
  call Hotf_5pt_reduction_last(G2tensor(351),RedSet_5(70),mass5set(:,1),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),16)
  call ol_merge_tensors(T1sum(21),[G1tensor(1)])
  call ol_merge_tensors(T1sum(22),[G1tensor(37)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(109)])
  call ol_merge_tensors(T1sum(25),[G1tensor(68)])
  call ol_merge_tensors(T1sum(26),[G1tensor(98)])
  call ol_merge_tensors(T1sum(27),[G1tensor(4)])
  call ol_merge_tensors(T1sum(28),[G1tensor(10)])
  call ol_merge_tensors(T1sum(29),[G1tensor(17)])
  call ol_merge_tensors(T1sum(30),[G1tensor(23)])
  call ol_merge_tensors(T1sum(31),[G1tensor(29)])
  call ol_merge_tensors(T1sum(32),[G1tensor(35)])
  call ol_merge_tensors(T1sum(33),[G1tensor(42)])
  call ol_merge_tensors(T1sum(34),[G1tensor(52)])
  call ol_merge_tensors(T1sum(35),[G1tensor(60)])
  call ol_merge_tensors(T1sum(36),[G1tensor(71)])
  call ol_merge_tensors(T1sum(37),[G1tensor(82)])
  call ol_merge_tensors(T1sum(38),[G1tensor(94)])
  call ol_merge_tensors(T1sum(39),[G1tensor(102)])
  call ol_merge_tensors(T1sum(40),[G1tensor(111)])
  call ol_merge_tensors(T1sum(41),[G1tensor(121)])
  call ol_merge_tensors(T1sum(42),[G1tensor(127)])
  call ol_merge_tensors(T1sum(43),[G1tensor(133)])
  call ol_merge_tensors(T1sum(44),[G1tensor(139)])
  call ol_merge_tensors(T1sum(45),[G1tensor(145)])
  call ol_merge_tensors(T1sum(46),[G1tensor(151)])
  call ol_merge_tensors(T1sum(47),[G1tensor(157)])
  call ol_merge_tensors(T1sum(48),[G1tensor(163)])
  call ol_merge_tensors(T1sum(49),[G1tensor(169)])
  call ol_merge_tensors(T1sum(50),[G1tensor(175)])
  call ol_merge_tensors(T1sum(51),[G1tensor(181)])
  call ol_merge_tensors(T1sum(52),[G1tensor(187)])
  call ol_merge_tensors(T1sum(53),[G1tensor(193)])
  call ol_merge_tensors(T1sum(54),[G1tensor(199)])
  call ol_merge_tensors(T1sum(55),[G1tensor(205)])
  call ol_merge_tensors(T1sum(56),[G1tensor(211)])
  call ol_merge_tensors(T1sum(57),[G1tensor(217)])
  call ol_merge_tensors(T1sum(58),[G1tensor(223)])
  call ol_merge_tensors(T1sum(59),[G1tensor(229)])
  call ol_merge_tensors(T1sum(60),[G1tensor(235)])
  call ol_merge_tensors(T1sum(61),[G1tensor(241)])
  call ol_merge_tensors(T1sum(62),[G1tensor(247)])
  call ol_merge_tensors(T1sum(63),[G1tensor(253)])
  call ol_merge_tensors(T1sum(64),[G1tensor(259)])
  call ol_merge_tensors(T1sum(65),[G1tensor(265)])
  call ol_merge_tensors(T1sum(66),[G1tensor(271)])
  call ol_merge_tensors(T1sum(67),[G1tensor(277)])
  call ol_merge_tensors(T1sum(68),[G1tensor(283)])
  call ol_merge_tensors(T1sum(69),[G1tensor(289)])
  call ol_merge_tensors(T1sum(70),[G1tensor(295)])
  call ol_merge_tensors(T1sum(71),[G1tensor(301)])
  call ol_merge_tensors(T1sum(72),[G1tensor(307)])
  call ol_merge_tensors(T1sum(73),[G1tensor(313)])
  call ol_merge_tensors(T1sum(74),[G1tensor(319)])
  call ol_merge_tensors(T1sum(75),[G1tensor(325)])
  call ol_merge_tensors(T1sum(76),[G1tensor(331)])
  call ol_merge_tensors(T1sum(77),[G1tensor(337)])
  call ol_merge_tensors(T1sum(78),[G1tensor(343)])
  call ol_merge_tensors(T1sum(79),[G1tensor(349)])
  call ol_merge_tensors(T1sum(80),[G1tensor(355)])
  call ol_merge_tensors(T1sum(81),[G1tensor(361)])
  call ol_merge_tensors(T1sum(82),[G1tensor(367)])
  call ol_merge_tensors(T1sum(83),[G1tensor(373)])
  call ol_merge_tensors(T1sum(84),[G1tensor(379)])
  call ol_merge_tensors(T1sum(85),[G1tensor(385)])
  call ol_merge_tensors(T1sum(86),[G1tensor(391)])
  call ol_merge_tensors(T1sum(87),[G1tensor(397)])
  call ol_merge_tensors(T1sum(88),[G1tensor(403)])
  call ol_merge_tensors(T1sum(89),[G1tensor(409)])
  call ol_merge_tensors(T1sum(90),[G1tensor(415)])
  call ol_merge_tensors(T1sum(91),[G1tensor(421)])
  call ol_merge_tensors(T1sum(92),[G1tensor(427)])
  call ol_merge_tensors(T1sum(93),[G1tensor(433)])
  call ol_merge_tensors(T1sum(94),[G1tensor(439)])
  call ol_merge_tensors(T1sum(95),[G1tensor(445)])
  call ol_merge_tensors(T1sum(96),[G1tensor(451)])
  call ol_merge_tensors(T1sum(97),[G1tensor(457)])
  call ol_merge_tensors(T1sum(98),[G1tensor(463)])
  call ol_merge_tensors(T1sum(99),[G1tensor(469)])
  call ol_merge_tensors(T1sum(100),[G1tensor(475)])
  call ol_merge_tensors(T1sum(101),[G1tensor(481)])
  call ol_merge_tensors(T1sum(102),[G1tensor(487)])
  call ol_merge_tensors(T1sum(103),[G1tensor(493)])
  call ol_merge_tensors(T1sum(104),[G1tensor(499)])
  call ol_merge_tensors(T1sum(105),[G1tensor(505)])
  call ol_merge_tensors(T1sum(106),[G1tensor(511)])
  call ol_merge_tensors(T1sum(107),[G1tensor(517)])
  call ol_merge_tensors(T1sum(108),[G1tensor(523)])
  call ol_merge_tensors(T1sum(109),[G1tensor(529)])
  call ol_merge_tensors(T1sum(110),[G1tensor(535)])
  call ol_merge_tensors(T1sum(111),[G1tensor(541)])
  call ol_merge_tensors(T1sum(112),[G1tensor(547)])
  call ol_merge_tensors(T1sum(113),[G1tensor(553)])
  call ol_merge_tensors(T1sum(114),[G1tensor(559)])
  call ol_merge_tensors(T1sum(115),[G1tensor(565)])
  call ol_merge_tensors(T1sum(116),[G1tensor(571)])
  call ol_merge_tensors(T1sum(117),[G1tensor(577)])
  call ol_merge_tensors(T1sum(118),[G1tensor(583)])
  call ol_merge_tensors(T1sum(119),[G1tensor(589)])
  call ol_merge_tensors(T1sum(120),[G1tensor(595)])
  call ol_merge_tensors(T1sum(121),[G1tensor(601)])
  call ol_merge_tensors(T1sum(122),[G1tensor(607)])
  call ol_merge_tensors(T1sum(123),[G1tensor(613)])
  call ol_merge_tensors(T1sum(124),[G1tensor(619)])
  call ol_merge_tensors(T1sum(125),[G1tensor(625)])
  call ol_merge_tensors(T1sum(126),[G1tensor(631)])
  call ol_merge_tensors(T1sum(127),[G1tensor(637)])
  call ol_merge_tensors(T1sum(128),[G1tensor(643)])
  call ol_merge_tensors(T1sum(129),[G1tensor(649)])
  call ol_merge_tensors(T1sum(130),[G1tensor(655)])
  call ol_merge_tensors(T1sum(131),[G1tensor(661)])
  call ol_merge_tensors(T1sum(132),[G1tensor(667)])
  call ol_merge_tensors(T1sum(133),[G1tensor(673)])
  call ol_merge_tensors(T1sum(134),[G1tensor(679)])
  call ol_merge_tensors(T1sum(135),[G1tensor(685)])
  call ol_merge_tensors(T1sum(136),[G1tensor(691)])
  call ol_merge_tensors(T1sum(137),[G1tensor(697)])
  call ol_merge_tensors(T1sum(138),[G1tensor(703)])
  call ol_merge_tensors(T1sum(139),[G1tensor(709)])
  call ol_merge_tensors(T1sum(140),[G1tensor(715)])
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[35,4,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(1),m4h2x4x8(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[35,4,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(2),m4h4x2x8(:,1),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[35,4,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(3),m4h2x4x8(:,2),heltab3x64(:,:,3))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[44,1,16,2],[0,0,0,0],5,1,wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(4),m4h2x4x8(:,3),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[44,1,16,2],[0,0,0,0],5,1,wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,12),ex6(:),G0H8(5),m4h4x2x8(:,2),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[44,1,16,2],[0,0,0,0],5,1,wf4(:,12))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(6),m4h2x4x8(:,4),heltab3x64(:,:,6))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,12,3,16],[0,0,0,0],4,2,wf4(:,12),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(45))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,12,3,16],[0,0,0,0],4,2,wf4(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(46))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,12,3,16],[0,0,0,0],4,2,wf4(:,12),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(47))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,12,3,16],[0,0,0,0],4,2,wf4(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(48))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(49))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(50))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(51))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(52))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(53))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(54))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(55))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(24)*(-M(1,:)%j-M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(56))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(57))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,90),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(58))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,92),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(59))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,94),heltab2x64(:,:,110))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(60))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,96),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(61))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,98),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(62))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,100),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[36,3,8,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[36,3,16,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,18),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(24),n2h16(45))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[36,8,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,19),heltab2x64(:,:,119))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[40,3,4,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,20),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[40,3,16,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,21),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(5),40,0,G1H16(2),n2h16(46))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[40,4,3,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,22),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,7,16,8],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,101),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,7,8,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(63))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,8,7,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(27),n2h32(64))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,104),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(29),n2h32(65))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,106),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(66))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[35,8,4,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(7),m3h8x8(:,1),heltab2x64(:,:,129))
  call Hloop_Q_A(ntryL,G0H8(7),35,0,G1H8(121),n2h8(121))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[35,4,8,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(7),m3h8x8(:,2),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(7),35,0,G1H8(122),n2h8(122))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[35,4,16,8],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(137),m3h8x8(:,3),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,2,17,12],[0,0,0,0],4,2,wf4(:,13),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,132))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(67))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,2,17,12],[0,0,0,0],4,2,wf4(:,13),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,108),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,2,12,17],[0,0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,109),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(68))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,2,12,17],[0,0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,110),heltab2x64(:,:,135))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,12,2,17],[0,0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(35),n2h32(69))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,12,2,17],[0,0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,112),heltab2x64(:,:,137))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,1,18,12],[0,0,0,0],4,2,wf4(:,18),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(70))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,1,18,12],[0,0,0,0],4,2,wf4(:,18),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,114),heltab2x64(:,:,139))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,1,12,18],[0,0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(71))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,1,12,18],[0,0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,116),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,12,1,18],[0,0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(72))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,12,1,18],[0,0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,118),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[33,2,16,12],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(7),m3h4x16(:,23),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[33,12,2,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(8),m3h4x16(:,24),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[33,2,12,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(9),m3h4x16(:,25),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[34,1,16,12],[0,0,0,0],4,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(10),m3h4x16(:,26),heltab2x64(:,:,147))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[34,12,1,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(11),m3h4x16(:,27),heltab2x64(:,:,148))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[34,1,12,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(12),m3h4x16(:,28),heltab2x64(:,:,149))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,2,16,13],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,119),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,13,2,16],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(44),n2h32(73))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,2,13,16],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,121),heltab2x64(:,:,152))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(74))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,1,16,14],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,122),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,14,1,16],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,123),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(75))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,1,14,16],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,124),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(76))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[44,2,1,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(7),m3h8x8(:,4),heltab2x64(:,:,156))
  call Hloop_Q_A(ntryL,G0H8(7),44,0,G1H8(138),n2h8(123))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[44,1,2,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,13),G0H8(7),m3h8x8(:,5),heltab2x64(:,:,157))
  call Hloop_A_Q(ntryL,G0H8(7),44,0,G1H8(21),n2h8(124))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[44,1,16,2],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(23),m3h8x8(:,6),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[34,8,4,17],[0,0,0,0],4,2,wf4(:,14),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(2),m3h4x16(:,29),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[34,4,8,17],[0,0,0,0],4,2,wf4(:,14),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,30),heltab2x64(:,:,160))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[36,8,2,17],[0,0,0,0],4,2,wf4(:,8),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,31),heltab2x64(:,:,161))
  call Hloop_Q_A(ntryL,G0H16(13),36,0,G1H16(15),n2h16(47))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[36,2,17,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,32),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[40,4,2,17],[0,0,0,0],4,2,wf4(:,5),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,33),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(14),40,0,G1H16(21),n2h16(48))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[40,2,17,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,34),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,4,8,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,125),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(77))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,4,8,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,126),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,8,4,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,127),heltab2x64(:,:,167))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(51),n2h32(78))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,8,4,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,128),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,4,19,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,129),heltab2x64(:,:,169))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(79))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,4,19,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,130),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[49,2,4,8],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,61),G0H8(7),m3h8x8(:,7),heltab2x64(:,:,171))
  call Hloop_Q_A(ntryL,G0H8(7),49,0,G1H8(33),n2h8(125))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[49,2,8,4],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,61),G0H8(7),m3h8x8(:,8),heltab2x64(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(7),49,0,G1H8(34),n2h8(126))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[33,4,8,18],[0,0,0,0],4,2,wf4(:,17),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(15),m3h4x16(:,35),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[33,8,4,18],[0,0,0,0],4,2,wf4(:,17),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(16),m3h4x16(:,36),heltab2x64(:,:,174))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[36,8,1,18],[0,0,0,0],4,2,wf4(:,8),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(17),m3h4x16(:,37),heltab2x64(:,:,175))
  call Hloop_Q_A(ntryL,G0H16(17),36,0,G1H16(10),n2h16(49))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[36,1,18,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(17),m3h4x16(:,38),heltab2x64(:,:,176))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[40,4,1,18],[0,0,0,0],4,2,wf4(:,5),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,39),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(20),n2h16(50))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[40,1,18,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,40),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,4,8,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,131),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(80))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,4,8,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,132),heltab2x64(:,:,180))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,8,4,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,133),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(57),n2h32(81))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,8,4,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,134),heltab2x64(:,:,182))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,4,19,8],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,135),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(82))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,4,19,8],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,136),heltab2x64(:,:,184))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[50,1,4,8],[0,0,0,0],4,1,wf8(:,71))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,71),G0H8(7),m3h8x8(:,9),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(39),n2h8(127))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[50,1,8,4],[0,0,0,0],4,1,wf8(:,71))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,71),G0H8(7),m3h8x8(:,10),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(40),n2h8(128))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[33,2,8,20],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,41),heltab2x64(:,:,187))
  call Hloop_Q_A(ntryL,G0H16(19),33,0,G1H16(8),n2h16(51))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[33,2,20,8],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,42),heltab2x64(:,:,188))
  call Hloop_Q_A(ntryL,G0H16(19),33,0,G1H16(7),n2h16(52))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[34,1,8,20],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(19),m3h4x16(:,43),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(19),n2h16(53))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[34,1,20,8],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(19),m3h4x16(:,44),heltab2x64(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(18),n2h16(54))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[40,2,1,20],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,45),heltab2x64(:,:,191))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[40,1,2,20],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,46),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,1,2,28],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,137),heltab2x64(:,:,193))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(83))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,1,2,28],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,138),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,2,1,28],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,139),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(63),n2h32(84))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,2,1,28],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,140),heltab2x64(:,:,196))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,1,28,2],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,141),heltab2x64(:,:,197))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(65),n2h32(85))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,1,28,2],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,142),heltab2x64(:,:,198))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[52,2,1,8],[0,0,0,0],4,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,34),G0H8(7),m3h8x8(:,11),heltab2x64(:,:,199))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[52,1,2,8],[0,0,0,0],4,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,34),G0H8(8),m3h8x8(:,12),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[33,2,4,24],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(21),m3h4x16(:,47),heltab2x64(:,:,201))
  call Hloop_Q_A(ntryL,G0H16(21),33,0,G1H16(23),n2h16(55))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[33,2,24,4],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(21),m3h4x16(:,48),heltab2x64(:,:,202))
  call Hloop_Q_A(ntryL,G0H16(21),33,0,G1H16(25),n2h16(56))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[34,1,4,24],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(21),m3h4x16(:,49),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H16(21),34,0,G1H16(26),n2h16(57))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[34,1,24,4],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(21),m3h4x16(:,50),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(21),34,0,G1H16(27),n2h16(58))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[36,1,2,24],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(21),m3h4x16(:,51),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[36,2,1,24],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(22),m3h4x16(:,52),heltab2x64(:,:,206))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,1,2,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,143),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(67),n2h32(86))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,1,2,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,144),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,1,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,145),heltab2x64(:,:,209))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(69),n2h32(87))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,1,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,146),heltab2x64(:,:,210))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,1,28,2],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,147),heltab2x64(:,:,211))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(88))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,1,28,2],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,148),heltab2x64(:,:,212))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[56,2,1,4],[0,0,0,0],4,1,wf8(:,41))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,41),G0H8(9),m3h8x8(:,13),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[56,1,2,4],[0,0,0,0],4,1,wf8(:,41))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,41),G0H8(10),m3h8x8(:,14),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[35,8,4,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(11),m3h8x8(:,15),heltab2x64(:,:,215))
  call Hloop_Q_A(ntryL,G0H8(11),35,0,G1H8(48),n2h8(129))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[35,4,8,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,25),G0H8(11),m3h8x8(:,16),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H8(11),35,0,G1H8(51),n2h8(130))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[35,4,16,8],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,25),35,G1H8(52),m3h8x8(:,17),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[49,2,4,8],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,63),G0H8(11),m3h8x8(:,18),heltab2x64(:,:,218))
  call Hloop_Q_A(ntryL,G0H8(11),49,0,G1H8(5),n2h8(131))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[49,2,8,4],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,63),G0H8(11),m3h8x8(:,19),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G0H8(11),49,0,G1H8(11),n2h8(132))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[35,8,4,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,26),G0H8(11),m3h8x8(:,20),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G0H8(11),35,0,G1H8(12),n2h8(133))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[35,4,8,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,26),G0H8(11),m3h8x8(:,21),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G0H8(11),35,0,G1H8(15),n2h8(134))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[35,4,16,8],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,26),35,G1H8(16),m3h8x8(:,22),heltab2x64(:,:,222))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[50,1,4,8],[0,0,0,0],4,1,wf8(:,72))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,72),G0H8(11),m3h8x8(:,23),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G0H8(11),50,0,G1H8(43),n2h8(135))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[50,1,8,4],[0,0,0,0],4,1,wf8(:,72))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,72),G0H8(11),m3h8x8(:,24),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G0H8(11),50,0,G1H8(35),n2h8(136))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[44,2,1,16],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(11),m3h8x8(:,25),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H8(11),44,0,G1H8(42),n2h8(137))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[44,1,2,16],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,23),G0H8(11),m3h8x8(:,26),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H8(11),44,0,G1H8(36),n2h8(138))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[44,1,16,2],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),44,G1H8(49),m3h8x8(:,27),heltab2x64(:,:,227))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[52,2,1,8],[0,0,0,0],4,1,wf8(:,35))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,35),G0H8(11),m3h8x8(:,28),heltab2x64(:,:,228))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[52,1,2,8],[0,0,0,0],4,1,wf8(:,35))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,35),G0H8(12),m3h8x8(:,29),heltab2x64(:,:,229))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[44,2,1,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(13),m3h8x8(:,30),heltab2x64(:,:,230))
  call Hloop_Q_A(ntryL,G0H8(13),44,0,G1H8(8),n2h8(139))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[44,1,2,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,24),G0H8(13),m3h8x8(:,31),heltab2x64(:,:,231))
  call Hloop_A_Q(ntryL,G0H8(13),44,0,G1H8(13),n2h8(140))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[44,1,16,2],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),44,G1H8(26),m3h8x8(:,32),heltab2x64(:,:,232))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[56,2,1,4],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(13),m3h8x8(:,33),heltab2x64(:,:,233))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[56,1,2,4],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(14),m3h8x8(:,34),heltab2x64(:,:,234))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(52),G1H8(137),G1H8(47),G0H8(3),G0H8(2) &
    ,G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(49),G1H8(23),G0H8(6),G0H8(5),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(3),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(48),G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(51),G1H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(42),G1H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(36),G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(10)])
  call Hloop_VQ_A(ntryL,G1H8(16),ex3(:),G1H4(159),m3h2x4(:,165),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(159),39,0,G2H4(3),n2h4(163))
  call Hloop_VA_Q(ntryL,G1H8(9),ex4(:),G1H4(160),m3h2x4(:,166),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(160),43,0,G2H4(4),n2h4(164))
  call Hloop_AV_Q(ntryL,G1H8(17),ex5(:),G1H4(168),m3h2x4(:,167),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(168),51,0,G2H4(58),n2h4(165))
  call Hloop_QV_A(ntryL,G1H8(31),ex5(:),G1H4(193),m3h2x4(:,168),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(193),51,0,G2H4(62),n2h4(166))
  call Hloop_QV_A(ntryL,G1H16(3),ex5(:),G1H8(1),m3h2x8(:,107),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(1),52,0,G2H8(25),n2h8(141))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,1),G1H4(194),m3h4x4(:,23),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(194),39,0,G2H4(63),n2h4(167))
  call Hloop_QV_A(ntryL,G1H16(12),ex5(:),G1H8(2),m3h2x8(:,108),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H8(2),49,0,G2H8(27),n2h8(142))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(3),m3h2x8(:,109),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(28),n2h8(143))
  call Hloop_AV_Q(ntryL,G1H16(45),ex5(:),G1H8(28),m3h2x8(:,110),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(28),50,0,G2H8(29),n2h8(144))
  call Hloop_QV_A(ntryL,G1H16(50),wf4(:,12),G1H4(197),m3h4x4(:,24),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(197),45,0,G2H4(66),n2h4(168))
  call Hloop_VQ_A(ntryL,G1H8(26),ex1(:),G1H4(198),m3h2x4(:,169),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(198),45,0,G2H4(67),n2h4(169))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,12),G1H8(24),m3h4x8(:,9),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(24),44,0,G2H8(31),n2h8(145))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,12),G1H8(32),m3h4x8(:,10),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(32),44,0,G2H8(32),n2h8(146))
  call Hloop_AV_Q(ntryL,G1H32(7),wf4(:,1),G1H8(37),m3h4x8(:,11),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(37),35,0,G2H8(1),n2h8(147))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,1),G1H8(38),m3h4x8(:,12),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(38),35,0,G2H8(2),n2h8(148))
  call Hloop_QV_A(ntryL,G1H32(11),wf4(:,1),G1H8(55),m3h4x8(:,13),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(55),35,0,G2H8(3),n2h8(149))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,1),G1H8(56),m3h4x8(:,14),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(56),35,0,G2H8(4),n2h8(150))
  call Hloop_QA_V(ntryL,G1H32(13),ex4(:),G1H16(28),m3h2x16(:,69),heltab2x32(:,:,83))
  call Hloop_VA_Q(ntryL,G1H32(14),ex4(:),G1H16(29),m3h2x16(:,70),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H16(29),40,0,G2H16(1),n2h16(59))
  call Hloop_AV_Q(ntryL,G1H32(15),wf4(:,1),G1H8(57),m3h4x8(:,15),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(57),35,0,G2H8(18),n2h8(151))
  call Hloop_UV_W(ntryL,G1H32(16),32,wf4(:,1),3,G2H8(22),m3h4x8(:,16),heltab2x32(:,:,86))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,1),G1H8(58),m3h4x8(:,17),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(58),35,0,G2H8(26),n2h8(152))
  call Hloop_UV_W(ntryL,G1H32(18),32,wf4(:,1),3,G2H8(30),m3h4x8(:,18),heltab2x32(:,:,88))
  call Hloop_AQ_V(ntryL,G1H32(19),ex3(:),G1H16(30),m3h2x16(:,71),heltab2x32(:,:,89))
  call Hloop_VQ_A(ntryL,G1H32(20),ex3(:),G1H16(13),m3h2x16(:,72),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(13),36,0,G2H16(2),n2h16(60))
  call Hloop_QV_A(ntryL,G1H32(21),wf4(:,1),G1H8(61),m3h4x8(:,19),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(61),35,0,G2H8(14),n2h8(153))
  call Hloop_UV_W(ntryL,G1H32(22),32,wf4(:,1),3,G2H8(13),m3h4x8(:,20),heltab2x32(:,:,92))
  call Hloop_AV_Q(ntryL,G1H32(23),wf4(:,1),G1H8(62),m3h4x8(:,21),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(62),35,0,G2H8(5),n2h8(154))
  call Hloop_UV_W(ntryL,G1H32(24),32,wf4(:,1),3,G2H8(6),m3h4x8(:,22),heltab2x32(:,:,94))
  call Hloop_UV_W(ntryL,G0H16(1),36,wf4(:,1),3,G1H4(169),m3h4x4(:,25),heltab2x16(:,:,135))
  call Hloop_VA_Q(ntryL,G0H16(3),ex4(:),G0H8(3),m3h2x8(:,111),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(63),n2h8(155))
  call Hloop_UV_W(ntryL,G0H16(4),40,wf4(:,1),3,G1H4(219),m3h4x4(:,26),heltab2x16(:,:,137))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(220),m3h4x4(:,27),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(220),43,0,G2H4(68),n2h4(170))
  call Hloop_VQ_A(ntryL,G0H16(6),ex3(:),G0H8(2),m3h2x8(:,112),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H8(2),44,0,G1H8(64),n2h8(156))
  call Hloop_VQ_A(ntryL,G1H32(25),wf8(:,8),G1H4(199),m3h8x4(:,1),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(199),39,0,G2H4(71),n2h4(171))
  call Hloop_AQ_V(ntryL,G1H32(26),wf8(:,8),G1H4(200),m3h8x4(:,2),heltab2x32(:,:,96))
  call Hloop_QA_V(ntryL,G1H32(27),ex4(:),G1H16(1),m3h2x16(:,73),heltab2x32(:,:,97))
  call Hloop_VQ_A(ntryL,G1H32(28),ex3(:),G1H16(4),m3h2x16(:,74),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(4),36,0,G2H16(3),n2h16(61))
  call Hloop_QA_V(ntryL,G1H32(29),wf8(:,3),G1H4(203),m3h8x4(:,3),heltab2x32(:,:,99))
  call Hloop_AQ_V(ntryL,G1H32(30),ex3(:),G1H16(5),m3h2x16(:,75),heltab2x32(:,:,100))
  call Hloop_QA_V(ntryL,G1H8(12),ex4(:),G1H4(204),m3h2x4(:,170),heltab2x8(:,:,218))
  call Hloop_AQ_V(ntryL,G1H8(15),ex3(:),G1H4(235),m3h2x4(:,171),heltab2x8(:,:,219))
  call Hloop_QA_V(ntryL,G1H32(31),ex2(:),G1H16(6),m3h2x16(:,76),heltab2x32(:,:,101))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(9),m3h2x16(:,77),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H16(9),34,0,G2H16(4),n2h16(62))
  call Hloop_QA_V(ntryL,G1H32(33),ex2(:),G1H16(31),m3h2x16(:,78),heltab2x32(:,:,103))
  call Hloop_VA_Q(ntryL,G1H32(34),ex2(:),G1H16(33),m3h2x16(:,79),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H16(33),34,0,G2H16(5),n2h16(63))
  call Hloop_QV_A(ntryL,G1H32(35),wf4(:,12),G1H8(67),m3h4x8(:,23),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(67),44,0,G2H8(7),n2h8(157))
  call Hloop_UV_W(ntryL,G1H32(36),32,wf4(:,12),12,G2H8(8),m3h4x8(:,24),heltab2x32(:,:,106))
  call Hloop_AQ_V(ntryL,G1H32(37),ex1(:),G1H16(34),m3h2x16(:,80),heltab2x32(:,:,107))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(35),m3h2x16(:,81),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G1H16(35),33,0,G2H16(6),n2h16(64))
  call Hloop_AQ_V(ntryL,G1H32(39),ex1(:),G1H16(14),m3h2x16(:,82),heltab2x32(:,:,109))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(11),m3h2x16(:,83),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G1H16(11),33,0,G2H16(7),n2h16(65))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,12),G1H8(68),m3h4x8(:,25),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(68),44,0,G2H8(9),n2h8(158))
  call Hloop_UV_W(ntryL,G1H32(42),32,wf4(:,12),12,G2H8(10),m3h4x8(:,26),heltab2x32(:,:,112))
  call Hloop_VA_Q(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,113),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(69),n2h8(159))
  call Hloop_UV_W(ntryL,G0H16(8),33,wf4(:,12),12,G1H4(236),m3h4x4(:,28),heltab2x16(:,:,141))
  call Hloop_VA_Q(ntryL,G0H16(9),ex2(:),G0H8(6),m3h2x8(:,114),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(70),n2h8(160))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(5),m3h2x8(:,115),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G0H8(5),35,0,G1H8(73),n2h8(161))
  call Hloop_UV_W(ntryL,G0H16(11),34,wf4(:,12),12,G1H4(101),m3h4x4(:,29),heltab2x16(:,:,144))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(4),m3h2x8(:,116),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H8(4),35,0,G1H8(74),n2h8(162))
  call Hloop_VA_Q(ntryL,G1H32(43),ex2(:),G1H16(16),m3h2x16(:,84),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H16(16),34,0,G2H16(8),n2h16(66))
  call Hloop_AQ_V(ntryL,G1H32(44),wf8(:,20),G1H4(102),m3h8x4(:,4),heltab2x32(:,:,114))
  call Hloop_QA_V(ntryL,G1H32(45),ex2(:),G1H16(17),m3h2x16(:,85),heltab2x32(:,:,115))
  call Hloop_VQ_A(ntryL,G1H32(46),ex1(:),G1H16(36),m3h2x16(:,86),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(36),33,0,G2H16(9),n2h16(67))
  call Hloop_QA_V(ntryL,G1H32(47),wf8(:,16),G1H4(112),m3h8x4(:,5),heltab2x32(:,:,117))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(37),m3h2x16(:,87),heltab2x32(:,:,118))
  call Hloop_QA_V(ntryL,G1H8(8),ex2(:),G1H4(113),m3h2x4(:,172),heltab2x8(:,:,220))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(114),m3h2x4(:,173),heltab2x8(:,:,221))
  call Hloop_VA_Q(ntryL,G0H16(2),ex4(:),G0H8(7),m3h2x8(:,117),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(7),42,0,G1H8(75),n2h8(163))
  call Hloop_VQ_A(ntryL,G0H16(5),ex3(:),G0H8(8),m3h2x8(:,118),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H8(8),38,0,G1H8(76),n2h8(164))
  call Hloop_QA_V(ntryL,G1H16(15),ex4(:),G1H8(79),m3h2x8(:,119),heltab2x16(:,:,148))
  call Hloop_VA_Q(ntryL,G0H16(13),ex2(:),G0H8(9),m3h2x8(:,120),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H8(9),38,0,G1H8(80),n2h8(165))
  call Hloop_AQ_V(ntryL,G1H16(21),ex3(:),G1H8(81),m3h2x8(:,121),heltab2x16(:,:,150))
  call Hloop_VA_Q(ntryL,G0H16(14),ex2(:),G0H8(10),m3h2x8(:,122),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G0H8(10),42,0,G1H8(82),n2h8(166))
  call Hloop_AQ_V(ntryL,G1H32(49),ex3(:),G1H16(38),m3h2x16(:,88),heltab2x32(:,:,119))
  call Hloop_VQ_A(ntryL,G1H32(50),ex3(:),G1H16(40),m3h2x16(:,89),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H16(40),36,0,G2H16(10),n2h16(68))
  call Hloop_QA_V(ntryL,G1H32(51),ex4(:),G1H16(41),m3h2x16(:,90),heltab2x32(:,:,121))
  call Hloop_VA_Q(ntryL,G1H32(52),ex4(:),G1H16(42),m3h2x16(:,91),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H16(42),40,0,G2H16(11),n2h16(69))
  call Hloop_AQ_V(ntryL,G1H32(53),ex3(:),G1H16(43),m3h2x16(:,92),heltab2x32(:,:,123))
  call Hloop_VQ_A(ntryL,G1H32(54),ex3(:),G1H16(44),m3h2x16(:,93),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G1H16(44),36,0,G2H16(12),n2h16(70))
  call Hloop_QA_V(ntryL,G1H8(5),ex2(:),G1H4(119),m3h2x4(:,174),heltab2x8(:,:,222))
  call Hloop_QA_V(ntryL,G1H8(11),ex2(:),G1H4(125),m3h2x4(:,175),heltab2x8(:,:,223))
  call Hloop_VQ_A(ntryL,G0H16(15),ex3(:),G0H8(3),m3h2x8(:,123),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(3),37,0,G1H8(85),n2h8(167))
  call Hloop_VA_Q(ntryL,G0H16(16),ex4(:),G0H8(2),m3h2x8(:,124),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(2),41,0,G1H8(86),n2h8(168))
  call Hloop_QA_V(ntryL,G1H16(10),ex4(:),G1H8(87),m3h2x8(:,125),heltab2x16(:,:,154))
  call Hloop_VQ_A(ntryL,G0H16(17),ex1(:),G0H8(1),m3h2x8(:,126),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(88),n2h8(169))
  call Hloop_AQ_V(ntryL,G1H16(20),ex3(:),G1H8(91),m3h2x8(:,127),heltab2x16(:,:,156))
  call Hloop_VQ_A(ntryL,G0H16(18),ex1(:),G0H8(6),m3h2x8(:,128),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G0H8(6),41,0,G1H8(92),n2h8(170))
  call Hloop_AQ_V(ntryL,G1H32(55),ex3(:),G1H16(46),m3h2x16(:,94),heltab2x32(:,:,125))
  call Hloop_VQ_A(ntryL,G1H32(56),ex3(:),G1H16(47),m3h2x16(:,95),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G1H16(47),36,0,G2H16(13),n2h16(71))
  call Hloop_QA_V(ntryL,G1H32(57),ex4(:),G1H16(48),m3h2x16(:,96),heltab2x32(:,:,127))
  call Hloop_VA_Q(ntryL,G1H32(58),ex4(:),G1H16(22),m3h2x16(:,97),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H16(22),40,0,G2H16(14),n2h16(72))
  call Hloop_AQ_V(ntryL,G1H32(59),ex3(:),G1H16(49),m3h2x16(:,98),heltab2x32(:,:,129))
  call Hloop_VQ_A(ntryL,G1H32(60),ex3(:),G1H16(51),m3h2x16(:,99),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(51),36,0,G2H16(15),n2h16(73))
  call Hloop_AQ_V(ntryL,G1H8(43),ex1(:),G1H4(126),m3h2x4(:,176),heltab2x8(:,:,224))
  call Hloop_AQ_V(ntryL,G1H8(35),ex1(:),G1H4(131),m3h2x4(:,177),heltab2x8(:,:,225))
  call Hloop_QA_V(ntryL,G1H16(8),ex2(:),G1H8(93),m3h2x8(:,129),heltab2x16(:,:,158))
  call Hloop_QA_V(ntryL,G1H16(7),ex2(:),G1H8(94),m3h2x8(:,130),heltab2x16(:,:,159))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(97),m3h2x8(:,131),heltab2x16(:,:,160))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(98),m3h2x8(:,132),heltab2x16(:,:,161))
  call Hloop_VA_Q(ntryL,G0H16(19),ex2(:),G0H8(5),m3h2x8(:,133),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H8(5),42,0,G1H8(99),n2h8(171))
  call Hloop_VQ_A(ntryL,G0H16(20),ex1(:),G0H8(4),m3h2x8(:,134),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G0H8(4),41,0,G1H8(100),n2h8(172))
  call Hloop_AQ_V(ntryL,G1H32(61),ex1(:),G1H16(52),m3h2x16(:,100),heltab2x32(:,:,131))
  call Hloop_VQ_A(ntryL,G1H32(62),ex1(:),G1H16(53),m3h2x16(:,101),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(53),33,0,G2H16(16),n2h16(74))
  call Hloop_QA_V(ntryL,G1H32(63),ex2(:),G1H16(32),m3h2x16(:,102),heltab2x32(:,:,133))
  call Hloop_VA_Q(ntryL,G1H32(64),ex2(:),G1H16(3),m3h2x16(:,103),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G1H16(3),34,0,G2H16(17),n2h16(75))
  call Hloop_AQ_V(ntryL,G1H32(65),ex1(:),G1H16(24),m3h2x16(:,104),heltab2x32(:,:,135))
  call Hloop_VQ_A(ntryL,G1H32(66),ex1(:),G1H16(12),m3h2x16(:,105),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G1H16(12),33,0,G2H16(18),n2h16(76))
  call Hloop_VA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),m3h2x4(:,178),heltab2x8(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(132),n2h4(172))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,179),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G0H4(1),53,0,G1H4(138),n2h4(173))
  call Hloop_QA_V(ntryL,G1H16(23),ex2(:),G1H8(103),m3h2x8(:,135),heltab2x16(:,:,164))
  call Hloop_QA_V(ntryL,G1H16(25),ex2(:),G1H8(104),m3h2x8(:,136),heltab2x16(:,:,165))
  call Hloop_AQ_V(ntryL,G1H16(26),ex1(:),G1H8(105),m3h2x8(:,137),heltab2x16(:,:,166))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(106),m3h2x8(:,138),heltab2x16(:,:,167))
  call Hloop_VQ_A(ntryL,G0H16(21),ex1(:),G0H8(7),m3h2x8(:,139),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(7),37,0,G1H8(109),n2h8(173))
  call Hloop_VA_Q(ntryL,G0H16(22),ex2(:),G0H8(8),m3h2x8(:,140),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G0H8(8),38,0,G1H8(110),n2h8(174))
  call Hloop_AQ_V(ntryL,G1H32(67),ex1(:),G1H16(39),m3h2x16(:,106),heltab2x32(:,:,137))
  call Hloop_VQ_A(ntryL,G1H32(68),ex1(:),G1H16(45),m3h2x16(:,107),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G1H16(45),33,0,G2H16(19),n2h16(77))
  call Hloop_QA_V(ntryL,G1H32(69),ex2(:),G1H16(50),m3h2x16(:,108),heltab2x32(:,:,139))
  call Hloop_VA_Q(ntryL,G1H32(70),ex2(:),G1H16(29),m3h2x16(:,109),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G1H16(29),34,0,G2H16(20),n2h16(78))
  call Hloop_AQ_V(ntryL,G1H32(71),ex1(:),G1H16(13),m3h2x16(:,110),heltab2x32(:,:,141))
  call Hloop_VQ_A(ntryL,G1H32(72),ex1(:),G1H16(2),m3h2x16(:,111),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G1H16(2),33,0,G2H16(21),n2h16(79))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,180),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G0H4(1),58,0,G1H4(143),n2h4(174))
  call Hloop_VQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,181),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(144),n2h4(175))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(219),[G1H4(129)])
call HGT_w2_OLR(G1H4(42),1,1,4)
call HGT_w2_invQ_OLR(G1H4(42),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(74),G2H4(56),G1H4(218),G1H4(158),G1H4(46) &
    ,G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(21)])
call HGT_w2_OLR(G1H4(53),1,1,4)
call HGT_w2_invQ_OLR(G1H4(53),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(167),G1H4(60),G1H4(16)])
call HGT_lower_alpha_w2_OLR(G2H4(64),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(64),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(64),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G1H4(217)])
call HGT_lower_alpha_w2_OLR(G2H4(69),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(69),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(69),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(45)])
call HGT_w2_OLR(G1H8(14),1,1,8)
call HGT_w2_invQ_OLR(G1H8(14),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(72)])
call HGT_lower_alpha_OLR(G2H4(77),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(77),2,5,4)
call HGT_lower_alpha_OLR(G2H4(77),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(6)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(136)])
call HGT_lower_alpha_OLR(G2H4(78),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(78),2,5,4)
call HGT_lower_alpha_OLR(G2H4(78),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(19)])
call HGT_w2_OLR(G1H8(44),1,1,8)
call HGT_w2_invQ_OLR(G1H8(44),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(116),G1H4(137),G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(155),[G1H4(26),G1H4(70),G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(149),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(176),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(175),G1H4(99),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(179),G1H4(166),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(203),[G1H4(184),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(190),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(196),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(202),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(140),G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(20),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(63),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(154),G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(69),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(81),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(54),G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(66),G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G1H8(78),G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(93),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G1H8(90),G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(105),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(102),G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(114),G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(233)])
  call Hloop_VQ_A(ntryL,G1H4(42),ex3(:),G1H2(282),m3h2x2(:,281),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(282),47,0,G2H2(2),n2h2(221))
  call Hotf_4pt_reduction(G2H4(71),RedSet_4(54),mass4set(:,1),  & 
G1H4(148),G1H4(82),G1H4(94),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hloop_VA_Q(ntryL,G1H4(53),ex4(:),G1H2(294),m3h2x2(:,282),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(294),47,0,G2H2(4),n2h2(222))
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(68),mass4set(:,1),  & 
G1H4(10),G1H4(11),G1H4(17),G1H4(18),G1H4(206),4)
  call HG1shiftOLR(G1H4(11),4,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(327),mass4set(:,1),  & 
G1H4(209),G1H4(211),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(211),4,4)
  call Hloop_AQ_V(ntryL,G2H4(65),ex3(:),G2H2(6),m3h2x2(:,283),heltab2x4(:,:,339))
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(293),mass4set(:,1),  & 
G1H4(221),G1H4(226),G1H4(222),G1H4(225),G1H4(227),4)
  call HG1shiftOLR(G1H4(226),8,4)
  call Hloop_QA_V(ntryL,G2H4(70),ex4(:),G2H2(8),m3h2x2(:,284),heltab2x4(:,:,340))
call HGT_w2_OLR(G1H8(50),1,1,8)
call HGT_w2_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(50),ex5(:),G1H4(230),m3h2x4(:,182),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(230),60,0,G2H4(72),n2h4(176))
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(291),mass4set(:,1),  & 
G1H8(111),G1H8(112),G1H8(115),G1H8(116),G1H8(117),8)
  call HG1shiftOLR(G1H8(112),8,8)
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,1),G1H2(324),m3h4x2(:,49),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(324),47,0,G2H2(46),n2h2(223))
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(240),mass4set(:,1),  & 
G1H4(231),G1H4(232),G1H4(237),G1H4(242),G1H4(238),4)
  call HG1shiftOLR(G1H4(232),2,4)
  call Hloop_QA_V(ntryL,G2H8(36),ex2(:),G2H4(73),m3h2x4(:,183),heltab2x8(:,:,232))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(241),m3h2x4(:,184),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(241),51,0,G2H4(75),n2h4(177))
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(296),mass4set(:,1),  & 
G1H8(118),G1H8(123),G1H8(128),G1H8(124),G1H8(127),8)
  call HG1shiftOLR(G1H8(123),2,8)
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(244),mass4set(:,1),  & 
G1H4(243),G1H4(246),G1H4(62),G1H4(97),G1H4(173),4)
  call HG1shiftOLR(G1H4(246),1,4)
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(76),m3h2x4(:,185),heltab2x8(:,:,234))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,12),G1H2(342),m3h4x2(:,50),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(342),47,0,G2H2(47),n2h2(224))
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(299),mass4set(:,1),  & 
G1H4(185),G1H4(66),G1H4(71),G1H4(84),G1H4(90),4)
  call HG1shiftOLR(G1H4(66),2,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex3(:),G1H2(372),m3h2x2(:,285),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(372),55,0,G2H2(49),n2h2(225))
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(383),m3h2x2(:,286),heltab2x4(:,:,342))
  call Hloop_Q_A(ntryL,G1H2(383),55,0,G2H2(50),n2h2(226))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(414),m3h2x2(:,287),heltab2x4(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(414),59,0,G2H2(52),n2h2(227))
  call Hloop_VA_Q(ntryL,G1H4(155),ex4(:),G1H2(425),m3h2x2(:,288),heltab2x4(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(425),59,0,G2H2(53),n2h2(228))
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(436),m3h2x2(:,289),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(436),55,0,G2H2(55),n2h2(229))
  call Hloop_VA_Q(ntryL,G1H4(149),ex4(:),G1H2(447),m3h2x2(:,290),heltab2x4(:,:,346))
  call Hloop_A_Q(ntryL,G1H2(447),59,0,G2H2(56),n2h2(230))
  call Hloop_QV_A(ntryL,G1H4(89),ex5(:),G1H2(458),m3h2x2(:,291),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(458),55,0,G2H2(88),n2h2(231))
  call Hloop_AV_Q(ntryL,G1H4(25),ex5(:),G1H2(469),m3h2x2(:,292),heltab2x4(:,:,348))
  call Hloop_A_Q(ntryL,G1H2(469),59,0,G2H2(90),n2h2(232))
  call Hloop_QV_A(ntryL,G1H4(176),ex5(:),G1H2(480),m3h2x2(:,293),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(480),55,0,G2H2(87),n2h2(233))
  call Hloop_AV_Q(ntryL,G1H4(180),ex5(:),G1H2(491),m3h2x2(:,294),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(491),59,0,G2H2(89),n2h2(234))
  call Hloop_QV_A(ntryL,G1H4(76),ex5(:),G1H2(107),m3h2x2(:,295),heltab2x4(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(107),61,0,G2H2(10),n2h2(235))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(49),mass4set(:,1),  & 
G1H4(95),G1H4(93),G1H4(7),G1H4(36),G1H4(40),4)
  call HG1shiftOLR(G1H4(93),8,4)
  call Hloop_AV_Q(ntryL,G1H4(69),ex5(:),G1H2(22),m3h2x2(:,296),heltab2x4(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(22),62,0,G2H2(11),n2h2(236))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(63),mass4set(:,1),  & 
G1H4(35),G1H4(141),G1H4(15),G1H4(31),G1H4(45),4)
  call HG1shiftOLR(G1H4(141),4,4)
  call Hloop_VQ_A(ntryL,G1H4(203),ex3(:),G1H2(46),m3h2x2(:,297),heltab2x4(:,:,353))
  call Hloop_Q_A(ntryL,G1H2(46),47,0,G2H2(13),n2h2(237))
  call Hloop_VA_Q(ntryL,G1H4(200),ex4(:),G1H2(52),m3h2x2(:,298),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(52),47,0,G2H2(14),n2h2(238))
  call Hloop_VQ_A(ntryL,G1H4(101),ex1(:),G1H2(58),m3h2x2(:,299),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(58),47,0,G2H2(16),n2h2(239))
  call Hloop_VQ_A(ntryL,G1H4(112),ex1(:),G1H2(82),m3h2x2(:,300),heltab2x4(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(82),47,0,G2H2(17),n2h2(240))
  call Hloop_VA_Q(ntryL,G1H4(236),ex2(:),G1H2(88),m3h2x2(:,301),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(88),47,0,G2H2(19),n2h2(241))
  call Hloop_VA_Q(ntryL,G1H4(102),ex2(:),G1H2(1),m3h2x2(:,302),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(242))
  call Hloop_VQ_A(ntryL,G1H4(126),ex3(:),G1H2(19),m3h2x2(:,303),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(22),n2h2(243))
  call Hloop_VA_Q(ntryL,G1H4(131),ex4(:),G1H2(7),m3h2x2(:,304),heltab2x4(:,:,360))
  call Hloop_A_Q(ntryL,G1H2(7),59,0,G2H2(23),n2h2(244))
  call Hloop_VQ_A(ntryL,G1H4(119),ex3(:),G1H2(43),m3h2x2(:,305),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(43),55,0,G2H2(25),n2h2(245))
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(55),m3h2x2(:,306),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(55),59,0,G2H2(26),n2h2(246))
  call Hloop_QV_A(ntryL,G1H4(162),ex5(:),G1H2(13),m3h2x2(:,307),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(13),55,0,G2H2(28),n2h2(247))
  call Hloop_QV_A(ntryL,G1H4(224),ex5(:),G1H2(49),m3h2x2(:,308),heltab2x4(:,:,364))
  call Hloop_Q_A(ntryL,G1H2(49),55,0,G2H2(29),n2h2(248))
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(25),m3h2x2(:,309),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(25),59,0,G2H2(31),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H4(172),ex5(:),G1H2(26),m3h2x2(:,310),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(26),59,0,G2H2(32),n2h2(250))
  call Hloop_VQ_A(ntryL,G1H4(204),ex3(:),G1H2(27),m3h2x2(:,311),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(27),47,0,G2H2(77),n2h2(251))
  call Hloop_AV_Q(ntryL,G1H8(63),wf4(:,1),G1H2(38),m3h4x2(:,51),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(34),n2h2(252))
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(309),mass4set(:,1),  & 
G1H8(129),G1H8(132),G1H8(133),G1H8(134),G1H8(139),G0H8(9),8)
  call HG1shiftOLR(G1H8(132),16,8)
  call Hloop_VA_Q(ntryL,G1H4(235),ex4(:),G1H2(39),m3h2x2(:,312),heltab2x4(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(39),47,0,G2H2(35),n2h2(253))
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(309),mass4set(:,1),  & 
G1H8(144),G1H8(140),G1H8(143),G1H8(145),G1H8(148),G0H8(10),8)
  call HG1shiftOLR(G1H8(140),16,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(235),mass4set(:,1),  & 
G1H8(52),G1H8(137),G1H8(47),G1H8(49),G1H8(23),G0H8(3),8)
  call HG1shiftOLR(G1H8(137),12,8)
  call Hloop_VQ_A(ntryL,G1H4(113),ex1(:),G1H2(44),m3h2x2(:,313),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(78),n2h2(254))
  call Hloop_AV_Q(ntryL,G1H8(69),ex5(:),G1H4(49),m3h2x4(:,186),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(49),51,0,G2H4(79),n2h4(178))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(235),mass4set(:,1),  & 
G1H8(48),G1H8(121),G1H8(51),G1H8(122),G1H8(42),G0H8(2),8)
  call HG1shiftOLR(G1H8(121),12,8)
  call Hloop_AV_Q(ntryL,G1H8(70),wf4(:,12),G1H2(63),m3h4x2(:,52),heltab2x8(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(63),47,0,G2H2(37),n2h2(255))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(306),mass4set(:,1),  & 
G1H8(138),G1H8(36),G1H8(21),G1H8(33),G1H8(34),G0H8(1),8)
  call HG1shiftOLR(G1H8(36),16,8)
  call Hloop_VA_Q(ntryL,G1H4(114),ex2(:),G1H2(51),m3h2x2(:,314),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(51),47,0,G2H2(38),n2h2(256))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(306),mass4set(:,1),  & 
G1H8(39),G1H8(40),G1H8(16),G1H8(9),G1H8(17),G0H8(6),8)
  call HG1shiftOLR(G1H8(40),16,8)
  call Hloop_VA_Q(ntryL,G1H8(81),ex2(:),G1H4(67),m3h2x4(:,187),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(67),46,0,G2H4(81),n2h4(179))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(238),mass4set(:,1),  & 
G1H8(31),G1H8(1),G1H8(2),G1H8(3),G1H8(28),8)
  call HG1shiftOLR(G1H8(1),17,8)
  call Hloop_VA_Q(ntryL,G1H8(79),ex2(:),G1H4(68),m3h2x4(:,188),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(68),46,0,G2H4(82),n2h4(180))
  call Hloop_VQ_A(ntryL,G1H8(91),ex1(:),G1H4(104),m3h2x4(:,189),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(104),45,0,G2H4(22),n2h4(181))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(239),mass4set(:,1),  & 
G1H8(26),G1H8(24),G1H8(32),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(24),18,8)
  call Hloop_VQ_A(ntryL,G1H8(87),ex1(:),G1H4(134),m3h2x4(:,190),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(134),45,0,G2H4(25),n2h4(182))
  call Hloop_VA_Q(ntryL,G1H8(97),ex4(:),G1H4(110),m3h2x4(:,191),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(110),43,0,G2H4(28),n2h4(183))
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(70),mass4set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(61),8)
  call HG1shiftOLR(G1H8(56),20,8)
  call Hloop_VA_Q(ntryL,G1H8(93),ex4(:),G1H4(139),m3h2x4(:,192),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(139),43,0,G2H4(31),n2h4(184))
  call Hloop_VQ_A(ntryL,G1H8(94),wf4(:,4),G1H2(56),m3h4x2(:,53),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(56),55,0,G2H2(79),n2h2(257))
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(55),mass4set(:,1),  & 
G1H8(62),G1H8(12),G1H8(15),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_VQ_A(ntryL,G1H8(98),wf4(:,4),G1H2(81),m3h4x2(:,54),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(81),55,0,G2H2(40),n2h2(258))
  call Hloop_VQ_A(ntryL,G1H8(105),ex3(:),G1H4(3),m3h2x4(:,193),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(34),n2h4(185))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(56),mass4set(:,1),  & 
G1H8(8),G1H8(13),G1H8(5),G1H8(11),G1H8(43),8)
  call HG1shiftOLR(G1H8(13),24,8)
  call Hloop_VQ_A(ntryL,G1H8(103),ex3(:),G1H4(4),m3h2x4(:,194),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(38),n2h4(186))
  call Hloop_VA_Q(ntryL,G1H8(104),wf4(:,9),G1H2(69),m3h4x2(:,55),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(69),59,0,G2H2(41),n2h2(259))
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(69),mass4set(:,1),  & 
G1H8(35),G1H8(120),G1H8(45),G1H8(64),G1H8(6),8)
  call HG1shiftOLR(G1H8(120),4,8)
  call Hloop_VA_Q(ntryL,G1H8(106),wf4(:,9),G1H2(73),m3h4x2(:,56),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(73),59,0,G2H2(80),n2h2(260))
  call Hloop_QV_A(ntryL,G1H4(207),ex5(:),G1H2(79),m3h2x2(:,315),heltab2x4(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(79),55,0,G2H2(43),n2h2(261))
  call Hloop_QV_A(ntryL,G1H4(229),ex5(:),G1H2(80),m3h2x2(:,316),heltab2x4(:,:,372))
  call Hloop_Q_A(ntryL,G1H2(80),55,0,G2H2(44),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H4(212),ex5(:),G1H2(85),m3h2x2(:,317),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(85),59,0,G2H2(1),n2h2(263))
  call Hloop_AV_Q(ntryL,G1H4(213),ex5(:),G1H2(110),m3h2x2(:,318),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(110),59,0,G2H2(220),n2h2(264))
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(290),mass4set(:,1),  & 
G1H8(73),G1H8(136),G1H8(19),G1H8(74),G1H8(27),8)
  call HG1shiftOLR(G1H8(136),8,8)
  call Hloop_QV_A(ntryL,G1H8(125),wf4(:,1),G1H2(111),m3h4x2(:,57),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(111),55,0,G2H2(222),n2h2(265))
  call Hloop_QV_A(ntryL,G1H8(126),wf4(:,1),G1H2(112),m3h4x2(:,58),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(112),55,0,G2H2(3),n2h2(266))
  call Hloop_QV_A(ntryL,G1H8(130),wf4(:,1),G1H2(116),m3h4x2(:,59),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(116),55,0,G2H2(226),n2h2(267))
  call Hloop_QV_A(ntryL,G1H8(131),wf4(:,1),G1H2(117),m3h4x2(:,60),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(117),55,0,G2H2(228),n2h2(268))
  call Hloop_QV_A(ntryL,G1H4(223),ex5(:),G1H2(118),m3h2x2(:,319),heltab2x4(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(5),n2h2(269))
  call Hloop_QV_A(ntryL,G1H4(228),ex5(:),G1H2(122),m3h2x2(:,320),heltab2x4(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(217),n2h2(270))
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(295),mass4set(:,1),  & 
G1H8(29),G1H8(46),G1H8(10),G1H8(18),G1H8(41),8)
  call HG1shiftOLR(G1H8(46),2,8)
  call Hloop_QV_A(ntryL,G1H8(141),wf4(:,12),G1H2(123),m3h4x2(:,61),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(123),61,0,G2H2(219),n2h2(271))
  call Hloop_QV_A(ntryL,G1H8(142),wf4(:,12),G1H2(124),m3h4x2(:,62),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(124),61,0,G2H2(7),n2h2(272))
  call Hloop_QV_A(ntryL,G1H8(146),wf4(:,12),G1H2(128),m3h4x2(:,63),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(128),61,0,G2H2(223),n2h2(273))
  call Hloop_QV_A(ntryL,G1H8(147),wf4(:,12),G1H2(129),m3h4x2(:,64),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(129),61,0,G2H2(225),n2h2(274))
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(298),mass4set(:,1),  & 
G1H4(32),G1H4(28),G1H4(38),G1H4(74),G1H4(75),4)
  call HG1shiftOLR(G1H4(28),2,4)
  call Hloop_QV_A(ntryL,G1H4(239),ex5(:),G1H2(130),m3h2x2(:,321),heltab2x4(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(130),61,0,G2H2(81),n2h2(275))
  call Hloop_QV_A(ntryL,G1H4(240),ex5(:),G1H2(134),m3h2x2(:,322),heltab2x4(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(134),61,0,G2H2(9),n2h2(276))
  call Hloop_QV_A(ntryL,G1H4(244),ex5(:),G1H2(135),m3h2x2(:,323),heltab2x4(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(135),61,0,G2H2(82),n2h2(277))
  call Hloop_QV_A(ntryL,G1H4(245),ex5(:),G1H2(136),m3h2x2(:,324),heltab2x4(:,:,380))
  call Hloop_Q_A(ntryL,G1H2(136),61,0,G2H2(83),n2h2(278))
  call Hloop_AQ_V(ntryL,G2H4(58),ex3(:),G2H2(12),m3h2x2(:,325),heltab2x4(:,:,381))
  call Hloop_QA_V(ntryL,G2H4(62),ex4(:),G2H2(84),m3h2x2(:,326),heltab2x4(:,:,382))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(54),m3h2x4(:,195),heltab2x8(:,:,259))
  call Hloop_AQ_V(ntryL,G2H8(29),ex1(:),G2H4(37),m3h2x4(:,196),heltab2x8(:,:,260))
  call Hloop_UV_W(ntryL,G1H16(28),40,wf4(:,1),3,G2H4(10),m3h4x4(:,30),heltab2x16(:,:,170))
  call Hotf_4pt_reduction(G2H16(1),RedSet_4(155),mass4set(:,1),  & 
G1H16(4),G1H16(9),G1H16(33),G1H16(35),G1H16(11),16)
  call HG1shiftOLR(G1H16(9),20,16)
  call Hloop_AQ_V(ntryL,G2H8(18),wf4(:,4),G2H2(15),m3h4x2(:,65),heltab2x8(:,:,261))
  call Hloop_QA_V(ntryL,G2H8(26),ex4(:),G2H4(13),m3h2x4(:,197),heltab2x8(:,:,262))
  call Hloop_UV_W(ntryL,G1H16(30),36,wf4(:,1),3,G2H4(16),m3h4x4(:,31),heltab2x16(:,:,171))
  call Hotf_4pt_reduction(G2H16(2),RedSet_4(169),mass4set(:,1),  & 
G1H16(16),G1H16(36),G1H16(15),G1H16(21),G1H16(40),16)
  call HG1shiftOLR(G1H16(36),24,16)
  call Hloop_QA_V(ntryL,G2H8(14),wf4(:,9),G2H2(85),m3h4x2(:,66),heltab2x8(:,:,263))
  call Hloop_AQ_V(ntryL,G2H8(5),ex3(:),G2H4(19),m3h2x4(:,198),heltab2x8(:,:,264))
  call Hloop_VQ_A(ntryL,G1H16(1),wf8(:,8),G1H2(140),m3h8x2(:,1),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(86),n2h2(279))
  call Hotf_4pt_reduction(G2H16(3),RedSet_4(234),mass4set(:,1),  & 
G1H16(42),G1H16(44),G1H16(10),G1H16(20),G1H16(47),16)
  call HG1shiftOLR(G1H16(44),11,16)
  call Hloop_VA_Q(ntryL,G1H16(5),wf8(:,3),G1H2(141),m3h8x2(:,2),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(141),47,0,G2H2(18),n2h2(280))
  call Hloop_VQ_A(ntryL,G1H16(6),wf4(:,13),G1H4(151),m3h4x4(:,32),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(151),51,0,G2H4(35),n2h4(187))
  call Hloop_AQ_V(ntryL,G2H16(4),wf4(:,13),G2H4(21),m3h4x4(:,33),heltab2x16(:,:,175))
  call Hloop_UV_W(ntryL,G1H16(31),34,wf4(:,12),12,G2H4(39),m3h4x4(:,34),heltab2x16(:,:,176))
  call Hotf_4pt_reduction(G2H16(5),RedSet_4(199),mass4set(:,1),  & 
G1H16(22),G1H16(51),G1H16(8),G1H16(7),G1H16(19),16)
  call HG1shiftOLR(G1H16(51),17,16)
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(43),m3h2x4(:,199),heltab2x8(:,:,265))
  call Hloop_VA_Q(ntryL,G1H16(34),wf4(:,18),G1H4(152),m3h4x4(:,35),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(152),51,0,G2H4(23),n2h4(188))
  call Hloop_QA_V(ntryL,G2H16(6),wf4(:,18),G2H4(49),m3h4x4(:,36),heltab2x16(:,:,178))
  call Hloop_UV_W(ntryL,G1H16(14),33,wf4(:,12),12,G2H4(8),m3h4x4(:,37),heltab2x16(:,:,179))
  call Hotf_4pt_reduction(G2H16(7),RedSet_4(213),mass4set(:,1),  & 
G1H16(18),G1H16(53),G1H16(3),G1H16(12),G1H16(23),16)
  call HG1shiftOLR(G1H16(53),18,16)
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(51),m3h2x4(:,200),heltab2x8(:,:,266))
  call Hotf_4pt_reduction(G2H16(8),RedSet_4(13),mass4set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(45),G1H16(29),16)
  call HG1shiftOLR(G1H16(26),13,16)
  call Hloop_VQ_A(ntryL,G1H16(17),wf8(:,20),G1H2(142),m3h8x2(:,3),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(142),47,0,G2H2(21),n2h2(281))
  call Hotf_4pt_reduction(G2H16(9),RedSet_4(37),mass4set(:,1),  & 
G1H16(2),G1H16(28),G1H16(30),G1H16(1),G1H16(5),16)
  call HG1shiftOLR(G1H16(28),14,16)
  call Hloop_VA_Q(ntryL,G1H16(37),wf8(:,16),G1H2(146),m3h8x2(:,4),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(146),47,0,G2H2(133),n2h2(282))
  call Hloop_AQ_V(ntryL,G1H8(75),ex3(:),G1H4(98),m3h2x4(:,201),heltab2x8(:,:,267))
  call Hloop_QA_V(ntryL,G1H8(76),ex4(:),G1H4(109),m3h2x4(:,202),heltab2x8(:,:,268))
  call Hloop_AQ_V(ntryL,G1H8(80),wf4(:,13),G1H2(147),m3h4x2(:,67),heltab2x8(:,:,269))
  call Hloop_AQ_V(ntryL,G1H8(82),wf4(:,13),G1H2(148),m3h4x2(:,68),heltab2x8(:,:,270))
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(7),m3h2x8(:,141),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(7),44,0,G2H8(11),n2h8(175))
  call Hloop_QA_V(ntryL,G2H16(10),ex4(:),G2H8(12),m3h2x8(:,142),heltab2x16(:,:,183))
  call Hloop_VQ_A(ntryL,G1H16(41),ex3(:),G1H8(20),m3h2x8(:,143),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H8(20),44,0,G2H8(15),n2h8(176))
  call Hloop_AQ_V(ntryL,G2H16(11),ex3(:),G2H8(33),m3h2x8(:,144),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G1H16(43),36,wf8(:,12),19,G2H2(24),m3h8x2(:,5),heltab2x16(:,:,186))
  call Hotf_4pt_reduction(G2H16(12),RedSet_4(101),mass4set(:,1),  & 
G1H16(6),G1H16(31),G1H16(34),G1H16(14),G1H16(17),16)
  call HG1shiftOLR(G1H16(31),8,16)
  call Hloop_QA_V(ntryL,G1H8(85),ex4(:),G1H4(111),m3h2x4(:,203),heltab2x8(:,:,271))
  call Hloop_AQ_V(ntryL,G1H8(86),ex3(:),G1H4(165),m3h2x4(:,204),heltab2x8(:,:,272))
  call Hloop_QA_V(ntryL,G1H8(88),wf4(:,18),G1H2(152),m3h4x2(:,69),heltab2x8(:,:,273))
  call Hloop_QA_V(ntryL,G1H8(92),wf4(:,18),G1H2(153),m3h4x2(:,70),heltab2x8(:,:,274))
  call Hloop_VA_Q(ntryL,G1H16(46),ex4(:),G1H8(25),m3h2x8(:,145),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(25),44,0,G2H8(34),n2h8(177))
  call Hloop_QA_V(ntryL,G2H16(13),ex4(:),G2H8(35),m3h2x8(:,146),heltab2x16(:,:,188))
  call Hloop_VQ_A(ntryL,G1H16(48),ex3(:),G1H8(30),m3h2x8(:,147),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(30),44,0,G2H8(37),n2h8(178))
  call Hloop_AQ_V(ntryL,G2H16(14),ex3(:),G2H8(38),m3h2x8(:,148),heltab2x16(:,:,190))
  call Hloop_UV_W(ntryL,G1H16(49),36,wf8(:,17),19,G2H2(137),m3h8x2(:,6),heltab2x16(:,:,191))
  call Hotf_4pt_reduction(G2H16(15),RedSet_4(101),mass4set(:,1),  & 
G1H16(37),G1H16(38),G1H16(41),G1H16(43),G1H16(46),16)
  call HG1shiftOLR(G1H16(38),8,16)
  call Hloop_AQ_V(ntryL,G1H8(99),ex1(:),G1H4(123),m3h2x4(:,205),heltab2x8(:,:,275))
  call Hloop_QA_V(ntryL,G1H8(100),ex2(:),G1H4(174),m3h2x4(:,206),heltab2x8(:,:,276))
  call Hloop_VA_Q(ntryL,G1H16(52),ex2(:),G1H8(54),m3h2x8(:,149),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H8(54),35,0,G2H8(39),n2h8(179))
  call Hloop_QA_V(ntryL,G2H16(16),ex2(:),G2H8(41),m3h2x8(:,150),heltab2x16(:,:,193))
  call Hloop_VQ_A(ntryL,G1H16(32),ex1(:),G1H8(22),m3h2x8(:,151),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(22),35,0,G2H8(42),n2h8(180))
  call Hloop_AQ_V(ntryL,G2H16(17),ex1(:),G2H8(43),m3h2x8(:,152),heltab2x16(:,:,195))
  call Hloop_UV_W(ntryL,G1H16(24),33,wf8(:,4),28,G2H2(27),m3h8x2(:,7),heltab2x16(:,:,196))
  call Hotf_4pt_reduction(G2H16(18),RedSet_4(115),mass4set(:,1),  & 
G1H16(48),G1H16(49),G1H16(52),G1H16(32),G1H16(24),16)
  call HG1shiftOLR(G1H16(49),2,16)
  call Hloop_AQ_V(ntryL,G1H4(132),ex1(:),G1H2(154),m3h2x2(:,327),heltab2x4(:,:,383))
  call Hloop_QA_V(ntryL,G1H4(138),ex2(:),G1H2(158),m3h2x2(:,328),heltab2x4(:,:,384))
  call Hloop_QA_V(ntryL,G1H8(109),ex2(:),G1H4(135),m3h2x4(:,207),heltab2x8(:,:,277))
  call Hloop_AQ_V(ntryL,G1H8(110),ex1(:),G1H4(181),m3h2x4(:,208),heltab2x8(:,:,278))
  call Hloop_VA_Q(ntryL,G1H16(39),ex2(:),G1H8(53),m3h2x8(:,153),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H8(53),35,0,G2H8(45),n2h8(181))
  call Hloop_QA_V(ntryL,G2H16(19),ex2(:),G2H8(46),m3h2x8(:,154),heltab2x16(:,:,198))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(59),m3h2x8(:,155),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(59),35,0,G2H8(17),n2h8(182))
  call Hloop_AQ_V(ntryL,G2H16(20),ex1(:),G2H8(19),m3h2x8(:,156),heltab2x16(:,:,200))
  call Hloop_UV_W(ntryL,G1H16(13),33,wf8(:,9),28,G2H2(30),m3h8x2(:,8),heltab2x16(:,:,201))
  call Hotf_4pt_reduction(G2H16(21),RedSet_4(115),mass4set(:,1),  & 
G1H16(39),G1H16(50),G1H16(13),G1H16(54),G1H16(55),16)
  call HG1shiftOLR(G1H16(50),2,16)
  call Hloop_AQ_V(ntryL,G1H4(143),ex1(:),G1H2(159),m3h2x2(:,329),heltab2x4(:,:,385))
  call Hloop_QA_V(ntryL,G1H4(144),ex2(:),G1H2(160),m3h2x2(:,330),heltab2x4(:,:,386))
  call Hloop_QV_A(ntryL,G1H4(148),ex5(:),G1H2(164),m3h2x2(:,331),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(164),55,0,G2H2(33),n2h2(283))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(82),ex4(:),G1H2(165),m3h2x2(:,332),heltab2x4(:,:,388))
  call Hloop_QV_A(ntryL,G1H4(5),ex5(:),G1H2(166),m3h2x2(:,333),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(166),55,0,G2H2(36),n2h2(284))
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(170),m3h2x2(:,334),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(170),55,0,G2H2(141),n2h2(285))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(171),m3h2x2(:,335),heltab2x4(:,:,391))
  call Hloop_A_Q(ntryL,G1H2(171),59,0,G2H2(39),n2h2(286))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(172),m3h2x2(:,336),heltab2x4(:,:,392))
  call Hloop_AV_Q(ntryL,G1H4(18),ex5(:),G1H2(176),m3h2x2(:,337),heltab2x4(:,:,393))
  call Hloop_A_Q(ntryL,G1H2(176),59,0,G2H2(42),n2h2(287))
  call Hloop_AV_Q(ntryL,G1H4(206),ex5(:),G1H2(2),m3h2x2(:,338),heltab2x4(:,:,394))
  call Hloop_A_Q(ntryL,G1H2(2),59,0,G2H2(145),n2h2(288))
  call Hloop_AV_Q(ntryL,G1H4(209),ex5(:),G1H2(177),m3h2x2(:,339),heltab2x4(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(177),59,0,G2H2(45),n2h2(289))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(211),ex3(:),G1H2(181),m3h2x2(:,340),heltab2x4(:,:,396))
  call Hloop_AV_Q(ntryL,G1H4(215),ex5(:),G1H2(4),m3h2x2(:,341),heltab2x4(:,:,397))
  call Hloop_A_Q(ntryL,G1H2(4),59,0,G2H2(48),n2h2(290))
  call Hloop_AV_Q(ntryL,G1H4(216),ex5(:),G1H2(182),m3h2x2(:,342),heltab2x4(:,:,398))
  call Hloop_A_Q(ntryL,G1H2(182),59,0,G2H2(51),n2h2(291))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(186),m3h2x2(:,343),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(186),55,0,G2H2(54),n2h2(292))
call HGT_raise_alpha_OLR(G1H4(226),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(226),ex4(:),G1H2(6),m3h2x2(:,344),heltab2x4(:,:,400))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(187),m3h2x2(:,345),heltab2x4(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(187),55,0,G2H2(91),n2h2(293))
  call Hloop_QV_A(ntryL,G1H4(227),ex5(:),G1H2(191),m3h2x2(:,346),heltab2x4(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(191),55,0,G2H2(93),n2h2(294))
  call Hloop_QV_A(ntryL,G1H8(111),wf4(:,1),G1H2(8),m3h4x2(:,71),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(94),n2h2(295))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(112),ex4(:),G1H4(186),m3h2x4(:,209),heltab2x8(:,:,280))
  call Hloop_QV_A(ntryL,G1H8(116),wf4(:,1),G1H2(192),m3h4x2(:,72),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(96),n2h2(296))
  call Hloop_QV_A(ntryL,G1H8(117),wf4(:,1),G1H2(196),m3h4x2(:,73),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(196),55,0,G2H2(97),n2h2(297))
  call Hloop_QV_A(ntryL,G1H4(231),ex5(:),G1H2(10),m3h2x2(:,347),heltab2x4(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(10),61,0,G2H2(99),n2h2(298))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(232),ex2(:),G1H2(197),m3h2x2(:,348),heltab2x4(:,:,404))
  call Hloop_QV_A(ntryL,G1H4(242),ex5(:),G1H2(201),m3h2x2(:,349),heltab2x4(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(201),61,0,G2H2(100),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(238),ex5(:),G1H2(12),m3h2x2(:,350),heltab2x4(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(12),61,0,G2H2(102),n2h2(300))
  call Hloop_QV_A(ntryL,G1H8(118),wf4(:,12),G1H2(202),m3h4x2(:,74),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(202),61,0,G2H2(103),n2h2(301))
call HGT_raise_alpha_OLR(G1H8(123),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(123),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(123),ex2(:),G1H4(187),m3h2x4(:,210),heltab2x8(:,:,284))
  call Hloop_QV_A(ntryL,G1H8(124),wf4(:,12),G1H2(206),m3h4x2(:,75),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(206),61,0,G2H2(105),n2h2(302))
  call Hloop_QV_A(ntryL,G1H8(127),wf4(:,12),G1H2(14),m3h4x2(:,76),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(14),61,0,G2H2(106),n2h2(303))
  call Hloop_AV_Q(ntryL,G1H4(243),ex5(:),G1H2(207),m3h2x2(:,351),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G1H2(207),62,0,G2H2(108),n2h2(304))
call HGT_raise_alpha_OLR(G1H4(246),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(246),ex1(:),G1H2(211),m3h2x2(:,352),heltab2x4(:,:,408))
  call Hloop_AV_Q(ntryL,G1H4(97),ex5(:),G1H2(16),m3h2x2(:,353),heltab2x4(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(16),62,0,G2H2(109),n2h2(305))
  call Hloop_AV_Q(ntryL,G1H4(173),ex5(:),G1H2(212),m3h2x2(:,354),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(212),62,0,G2H2(111),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(185),ex5(:),G1H2(216),m3h2x2(:,355),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(216),61,0,G2H2(112),n2h2(307))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(66),ex2(:),G1H2(217),m3h2x2(:,356),heltab2x4(:,:,412))
  call Hloop_QV_A(ntryL,G1H4(84),ex5(:),G1H2(218),m3h2x2(:,357),heltab2x4(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(218),61,0,G2H2(114),n2h2(308))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(222),m3h2x2(:,358),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(222),61,0,G2H2(115),n2h2(309))
  call Hloop_QV_A(ntryL,G1H4(95),ex5(:),G1H2(223),m3h2x2(:,359),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(223),55,0,G2H2(117),n2h2(310))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(93),ex4(:),G1H2(224),m3h2x2(:,360),heltab2x4(:,:,416))
  call Hloop_QV_A(ntryL,G1H4(36),ex5(:),G1H2(228),m3h2x2(:,361),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(228),55,0,G2H2(118),n2h2(311))
  call Hloop_QV_A(ntryL,G1H4(40),ex5(:),G1H2(229),m3h2x2(:,362),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(229),55,0,G2H2(120),n2h2(312))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(230),m3h2x2(:,363),heltab2x4(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(230),59,0,G2H2(121),n2h2(313))
call HGT_raise_alpha_OLR(G1H4(141),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(141),ex3(:),G1H2(234),m3h2x2(:,364),heltab2x4(:,:,420))
  call Hloop_AV_Q(ntryL,G1H4(31),ex5(:),G1H2(235),m3h2x2(:,365),heltab2x4(:,:,421))
  call Hloop_A_Q(ntryL,G1H2(235),59,0,G2H2(123),n2h2(314))
  call Hloop_AV_Q(ntryL,G1H4(45),ex5(:),G1H2(236),m3h2x2(:,366),heltab2x4(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(236),59,0,G2H2(124),n2h2(315))
  call Hloop_AV_Q(ntryL,G1H8(129),wf4(:,1),G1H2(240),m3h4x2(:,77),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(240),47,0,G2H2(126),n2h2(316))
call HGT_OLR(G1H8(132),1,1,8)
call HGT_invQ_OLR(G1H8(132),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(132),-16,0,G2H8(20),n2h8(185))
  call Hloop_QV_A(ntryL,G2H8(20),ex5(:),G2H4(42),m3h2x4(:,211),heltab2x8(:,:,288))
  call Hloop_AV_Q(ntryL,G1H8(134),wf4(:,1),G1H2(241),m3h4x2(:,78),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(241),47,0,G2H2(127),n2h2(317))
  call Hloop_AV_Q(ntryL,G1H8(139),wf4(:,1),G1H2(242),m3h4x2(:,79),heltab2x8(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(242),47,0,G2H2(129),n2h2(318))
  call Hloop_AV_Q(ntryL,G0H8(9),wf4(:,1),G0H2(1),m3h4x2(:,80),heltab2x8(:,:,291))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(246),n2h2(319))
  call Hloop_QV_A(ntryL,G1H8(144),wf4(:,1),G1H2(247),m3h4x2(:,81),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(247),47,0,G2H2(130),n2h2(320))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(140),-16,0,G2H8(21),n2h8(186))
  call Hloop_AV_Q(ntryL,G2H8(21),ex5(:),G2H4(46),m3h2x4(:,212),heltab2x8(:,:,293))
  call Hloop_QV_A(ntryL,G1H8(145),wf4(:,1),G1H2(248),m3h4x2(:,82),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(248),47,0,G2H2(132),n2h2(321))
  call Hloop_QV_A(ntryL,G1H8(148),wf4(:,1),G1H2(252),m3h4x2(:,83),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(252),47,0,G2H2(136),n2h2(322))
  call Hloop_QV_A(ntryL,G0H8(10),wf4(:,1),G0H2(1),m3h4x2(:,84),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(253),n2h2(323))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(159),m3h2x4(:,213),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(159),51,0,G2H4(1),n2h4(198))
call HGT_OLR(G1H8(137),1,1,8)
call HGT_invQ_OLR(G1H8(137),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(137),-12,0,G2H8(23),n2h8(187))
  call Hloop_AV_Q(ntryL,G2H8(23),wf4(:,12),G2H2(140),m3h4x2(:,85),heltab2x8(:,:,298))
  call Hloop_QV_A(ntryL,G1H8(49),ex5(:),G1H4(160),m3h2x4(:,214),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(160),51,0,G2H4(5),n2h4(199))
  call Hloop_QV_A(ntryL,G1H8(23),ex5(:),G1H4(168),m3h2x4(:,215),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(168),51,0,G2H4(40),n2h4(200))
  call Hloop_QV_A(ntryL,G0H8(3),ex5(:),G0H4(1),m3h2x4(:,216),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(193),n2h4(201))
  call Hloop_AV_Q(ntryL,G1H8(48),ex5(:),G1H4(194),m3h2x4(:,217),heltab2x8(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(194),51,0,G2H4(41),n2h4(202))
call HGT_OLR(G1H8(121),1,1,8)
call HGT_invQ_OLR(G1H8(121),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(121),-12,0,G2H8(24),n2h8(188))
  call Hloop_QV_A(ntryL,G2H8(24),wf4(:,12),G2H2(144),m3h4x2(:,86),heltab2x8(:,:,303))
  call Hloop_AV_Q(ntryL,G1H8(122),ex5(:),G1H4(197),m3h2x4(:,218),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(197),51,0,G2H4(17),n2h4(203))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(198),m3h2x4(:,219),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(198),51,0,G2H4(20),n2h4(204))
  call Hloop_AV_Q(ntryL,G0H8(2),ex5(:),G0H4(1),m3h2x4(:,220),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(220),n2h4(205))
  call Hloop_AV_Q(ntryL,G1H8(138),wf4(:,12),G1H2(254),m3h4x2(:,87),heltab2x8(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(254),47,0,G2H2(148),n2h2(324))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-16,0,G2H8(16),n2h8(189))
  call Hloop_QV_A(ntryL,G2H8(16),ex5(:),G2H4(55),m3h2x4(:,221),heltab2x8(:,:,308))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,12),G1H2(258),m3h4x2(:,88),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(258),47,0,G2H2(149),n2h2(325))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,12),G1H2(259),m3h4x2(:,89),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(259),47,0,G2H2(151),n2h2(326))
  call Hloop_AV_Q(ntryL,G0H8(1),wf4(:,12),G0H2(1),m3h4x2(:,90),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(260),n2h2(327))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,12),G1H2(264),m3h4x2(:,91),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(264),47,0,G2H2(152),n2h2(328))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(40),-16,0,G2H8(36),n2h8(190))
  call Hloop_AV_Q(ntryL,G2H8(36),ex5(:),G2H4(59),m3h2x4(:,222),heltab2x8(:,:,313))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,12),G1H2(265),m3h4x2(:,92),heltab2x8(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(265),47,0,G2H2(154),n2h2(329))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,12),G1H2(266),m3h4x2(:,93),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(266),47,0,G2H2(155),n2h2(330))
  call Hloop_QV_A(ntryL,G0H8(6),wf4(:,12),G0H2(1),m3h4x2(:,94),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(270),n2h2(331))
  call Hloop_VA_Q(ntryL,G1H8(31),ex2(:),G1H4(199),m3h2x4(:,223),heltab2x8(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(199),46,0,G2H4(61),n2h4(206))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(1),wf4(:,13),G1H2(271),m3h4x2(:,95),heltab2x8(:,:,318))
  call Hloop_VA_Q(ntryL,G1H8(3),ex2(:),G1H4(129),m3h2x4(:,224),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(129),46,0,G2H4(26),n2h4(207))
  call Hloop_VA_Q(ntryL,G1H8(28),ex2(:),G1H4(219),m3h2x4(:,225),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G1H4(219),46,0,G2H4(9),n2h4(208))
  call Hloop_VQ_A(ntryL,G1H8(26),ex1(:),G1H4(218),m3h2x4(:,226),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(218),45,0,G2H4(15),n2h4(209))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(24),wf4(:,18),G1H2(272),m3h4x2(:,96),heltab2x8(:,:,322))
  call Hloop_VQ_A(ntryL,G1H8(37),ex1(:),G1H4(158),m3h2x4(:,227),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(158),45,0,G2H4(18),n2h4(210))
  call Hloop_VQ_A(ntryL,G1H8(38),ex1(:),G1H4(46),m3h2x4(:,228),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(46),45,0,G2H4(29),n2h4(211))
  call Hloop_VA_Q(ntryL,G1H8(55),ex4(:),G1H4(142),m3h2x4(:,229),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(142),43,0,G2H4(30),n2h4(212))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(56),wf4(:,4),G1H2(276),m3h4x2(:,97),heltab2x8(:,:,326))
  call Hloop_VA_Q(ntryL,G1H8(58),ex4(:),G1H4(21),m3h2x4(:,230),heltab2x8(:,:,327))
  call Hloop_A_Q(ntryL,G1H4(21),43,0,G2H4(33),n2h4(213))
  call Hloop_VA_Q(ntryL,G1H8(61),ex4(:),G1H4(169),m3h2x4(:,231),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(169),43,0,G2H4(36),n2h4(214))
  call Hloop_VQ_A(ntryL,G1H8(62),wf4(:,4),G1H2(277),m3h4x2(:,98),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G1H2(277),55,0,G2H2(157),n2h2(332))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(167),m3h2x4(:,232),heltab2x8(:,:,330))
  call Hloop_VQ_A(ntryL,G1H8(67),wf4(:,4),G1H2(278),m3h4x2(:,99),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(278),55,0,G2H2(158),n2h2(333))
  call Hloop_VQ_A(ntryL,G1H8(68),wf4(:,4),G1H2(389),m3h4x2(:,100),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G1H2(389),55,0,G2H2(160),n2h2(334))
  call Hloop_VQ_A(ntryL,G1H8(8),ex3(:),G1H4(60),m3h2x4(:,233),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(60),39,0,G2H4(48),n2h4(215))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),wf4(:,9),G1H2(283),m3h4x2(:,101),heltab2x8(:,:,334))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(16),m3h2x4(:,234),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(16),39,0,G2H4(74),n2h4(216))
  call Hloop_VQ_A(ntryL,G1H8(43),ex3(:),G1H4(217),m3h2x4(:,235),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(217),39,0,G2H4(56),n2h4(217))
  call Hloop_VA_Q(ntryL,G1H8(35),wf4(:,9),G1H2(284),m3h4x2(:,102),heltab2x8(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(284),59,0,G2H2(161),n2h2(335))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(120),ex3(:),G1H4(72),m3h2x4(:,236),heltab2x8(:,:,338))
  call Hloop_VA_Q(ntryL,G1H8(64),wf4(:,9),G1H2(288),m3h4x2(:,103),heltab2x8(:,:,339))
  call Hloop_A_Q(ntryL,G1H2(288),59,0,G2H2(163),n2h2(336))
  call Hloop_VA_Q(ntryL,G1H8(6),wf4(:,9),G1H2(289),m3h4x2(:,104),heltab2x8(:,:,340))
  call Hloop_A_Q(ntryL,G1H2(289),59,0,G2H2(164),n2h2(337))
  call Hloop_QV_A(ntryL,G1H8(73),wf4(:,1),G1H2(290),m3h4x2(:,105),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(290),55,0,G2H2(166),n2h2(338))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(136),ex4(:),G1H4(57),m3h2x4(:,237),heltab2x8(:,:,342))
  call Hloop_QV_A(ntryL,G1H8(74),wf4(:,1),G1H2(394),m3h4x2(:,106),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(394),55,0,G2H2(167),n2h2(339))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,1),G1H2(295),m3h4x2(:,107),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G1H2(295),55,0,G2H2(169),n2h2(340))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,12),G1H2(296),m3h4x2(:,108),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(296),61,0,G2H2(170),n2h2(341))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(46),ex2(:),G1H4(234),m3h2x4(:,238),heltab2x8(:,:,346))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,12),G1H2(300),m3h4x2(:,109),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(300),61,0,G2H2(172),n2h2(342))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,12),G1H2(301),m3h4x2(:,110),heltab2x8(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(301),61,0,G2H2(173),n2h2(343))
  call Hloop_QV_A(ntryL,G1H4(32),ex5(:),G1H2(302),m3h2x2(:,367),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(302),61,0,G2H2(175),n2h2(344))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(306),m3h2x2(:,368),heltab2x4(:,:,424))
  call Hloop_QV_A(ntryL,G1H4(74),ex5(:),G1H2(307),m3h2x2(:,369),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(307),61,0,G2H2(177),n2h2(345))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(308),m3h2x2(:,370),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(308),61,0,G2H2(179),n2h2(346))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(107),m3h4x4(:,38),heltab2x16(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(107),43,0,G2H4(68),n2h4(219))
call HGT_raise_alpha_OLR(G1H16(9),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(9),wf4(:,4),G1H4(116),m3h4x4(:,39),heltab2x16(:,:,203))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,1),G1H4(137),m3h4x4(:,40),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(137),43,0,G2H4(63),n2h4(220))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(108),m3h4x4(:,41),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(108),43,0,G2H4(67),n2h4(221))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,1),G1H4(120),m3h4x4(:,42),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(120),39,0,G2H4(71),n2h4(222))
call HGT_raise_alpha_OLR(G1H16(36),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(36),wf4(:,9),G1H4(26),m3h4x4(:,43),heltab2x16(:,:,207))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,1),G1H4(70),m3h4x4(:,44),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(70),39,0,G2H4(60),n2h4(223))
  call Hloop_QV_A(ntryL,G1H16(40),wf4(:,1),G1H4(124),m3h4x4(:,45),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(124),39,0,G2H4(64),n2h4(224))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(66),m3h2x8(:,157),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H8(66),52,0,G2H8(40),n2h8(199))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(44),wf8(:,3),G1H2(312),m3h8x2(:,9),heltab2x16(:,:,211))
  call Hloop_QV_A(ntryL,G1H16(20),ex5(:),G1H8(60),m3h2x8(:,158),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(60),52,0,G2H8(44),n2h8(200))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(65),m3h2x8(:,159),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H8(65),52,0,G2H8(31),n2h8(201))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,12),G1H4(136),m3h4x4(:,46),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(136),46,0,G2H4(65),n2h4(225))
call HGT_raise_alpha_OLR(G1H16(51),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(51),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(51),wf4(:,13),G1H4(58),m3h4x4(:,47),heltab2x16(:,:,215))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,12),G1H4(130),m3h4x4(:,48),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(130),46,0,G2H4(69),n2h4(226))
  call Hloop_AV_Q(ntryL,G1H16(19),wf4(:,12),G1H4(12),m3h4x4(:,49),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(12),46,0,G2H4(70),n2h4(227))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,12),G1H4(41),m3h4x4(:,50),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(41),45,0,G2H4(77),n2h4(228))
call HGT_raise_alpha_OLR(G1H16(53),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(53),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(53),wf4(:,18),G1H4(59),m3h4x4(:,51),heltab2x16(:,:,219))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,12),G1H4(175),m3h4x4(:,52),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(175),45,0,G2H4(78),n2h4(229))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,12),G1H4(99),m3h4x4(:,53),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(99),45,0,G2H4(80),n2h4(230))
  call Hloop_AV_Q(ntryL,G1H16(25),ex5(:),G1H8(71),m3h2x8(:,160),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H8(71),50,0,G2H8(32),n2h8(202))
call HGT_raise_alpha_OLR(G1H16(26),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(26),wf8(:,20),G1H2(313),m3h8x2(:,10),heltab2x16(:,:,223))
  call Hloop_AV_Q(ntryL,G1H16(45),ex5(:),G1H8(78),m3h2x8(:,161),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(78),50,0,G2H8(3),n2h8(203))
  call Hloop_AV_Q(ntryL,G1H16(29),ex5(:),G1H8(72),m3h2x8(:,162),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(72),50,0,G2H8(4),n2h8(204))
  call Hloop_QV_A(ntryL,G1H16(2),ex5(:),G1H8(77),m3h2x8(:,163),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(77),49,0,G2H8(1),n2h8(205))
call HGT_raise_alpha_OLR(G1H16(28),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(28),wf8(:,16),G1H2(314),m3h8x2(:,11),heltab2x16(:,:,227))
  call Hloop_QV_A(ntryL,G1H16(1),ex5(:),G1H8(83),m3h2x8(:,164),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(83),49,0,G2H8(2),n2h8(206))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(90),m3h2x8(:,165),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(90),49,0,G2H8(8),n2h8(207))
  call Hloop_QV_A(ntryL,G1H16(6),wf8(:,12),G1H2(318),m3h8x2(:,12),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(318),55,0,G2H2(181),n2h2(347))
call HGT_raise_alpha_OLR(G1H16(31),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(31),ex4(:),G1H8(84),m3h2x8(:,166),heltab2x16(:,:,231))
  call Hloop_QV_A(ntryL,G1H16(14),wf8(:,12),G1H2(319),m3h8x2(:,13),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(319),55,0,G2H2(183),n2h2(348))
  call Hloop_QV_A(ntryL,G1H16(17),wf8(:,12),G1H2(320),m3h8x2(:,14),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(320),55,0,G2H2(184),n2h2(349))
  call Hloop_QV_A(ntryL,G1H16(37),wf8(:,17),G1H2(399),m3h8x2(:,15),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(399),55,0,G2H2(186),n2h2(350))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(89),m3h2x8(:,167),heltab2x16(:,:,235))
  call Hloop_QV_A(ntryL,G1H16(43),wf8(:,17),G1H2(325),m3h8x2(:,16),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(325),55,0,G2H2(187),n2h2(351))
  call Hloop_QV_A(ntryL,G1H16(46),wf8(:,17),G1H2(326),m3h8x2(:,17),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(326),55,0,G2H2(190),n2h2(352))
  call Hloop_QV_A(ntryL,G1H16(48),wf8(:,4),G1H2(330),m3h8x2(:,18),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(330),61,0,G2H2(191),n2h2(353))
call HGT_raise_alpha_OLR(G1H16(49),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(95),m3h2x8(:,168),heltab2x16(:,:,239))
  call Hloop_QV_A(ntryL,G1H16(32),wf8(:,4),G1H2(331),m3h8x2(:,19),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(331),61,0,G2H2(193),n2h2(354))
  call Hloop_QV_A(ntryL,G1H16(24),wf8(:,4),G1H2(332),m3h8x2(:,20),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(332),61,0,G2H2(194),n2h2(355))
  call Hloop_QV_A(ntryL,G1H16(39),wf8(:,9),G1H2(336),m3h8x2(:,21),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(336),61,0,G2H2(197),n2h2(356))
call HGT_raise_alpha_OLR(G1H16(50),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(50),ex2(:),G1H8(102),m3h2x8(:,169),heltab2x16(:,:,243))
  call Hloop_QV_A(ntryL,G1H16(54),wf8(:,9),G1H2(337),m3h8x2(:,22),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(337),61,0,G2H2(198),n2h2(357))
  call Hloop_QV_A(ntryL,G1H16(55),wf8(:,9),G1H2(338),m3h8x2(:,23),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(338),61,0,G2H2(200),n2h2(358))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G2H2(110),G2H2(98),G2H2(70),G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G2H2(113),G2H2(101),G2H2(72),G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(218),[G2H2(116),G2H2(104),G2H2(74),G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G2H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G2H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(224),[G2H2(119),G2H2(107),G2H2(76),G2H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(125),G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(131),G2H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(182),G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(185),G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(92),G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(95),G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(47),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(52),G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(175)])
call HGT_w2_OLR(G1H2(54),1,1,2)
call HGT_w2_invQ_OLR(G1H2(54),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(147),[G1H2(180),G1H2(31)])
call HGT_w2_OLR(G1H2(66),1,1,2)
call HGT_w2_invQ_OLR(G1H2(66),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(185)])
call HGT_w2_OLR(G1H2(78),1,1,2)
call HGT_w2_invQ_OLR(G1H2(78),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(190),G1H2(28)])
call HGT_w2_OLR(G1H2(18),1,1,2)
call HGT_w2_invQ_OLR(G1H2(18),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(195),[G1H2(32)])
call HGT_w2_OLR(G1H2(30),1,1,2)
call HGT_w2_invQ_OLR(G1H2(30),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(200),[G1H2(119)])
call HGT_w2_OLR(G1H2(42),1,1,2)
call HGT_w2_invQ_OLR(G1H2(42),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(86)])
call HGT_w2_OLR(G1H2(59),1,1,2)
call HGT_w2_invQ_OLR(G1H2(59),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(210),[G1H2(62)])
call HGT_w2_OLR(G1H2(72),1,1,2)
call HGT_w2_invQ_OLR(G1H2(72),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(315),[G1H2(309)])
call HGT_w2_OLR(G1H2(17),1,1,2)
call HGT_w2_invQ_OLR(G1H2(17),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(193)])
call HGT_w2_OLR(G1H2(35),1,1,2)
call HGT_w2_invQ_OLR(G1H2(35),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(363),[G1H2(357)])
call HGT_w2_OLR(G1H2(48),1,1,2)
call HGT_w2_invQ_OLR(G1H2(48),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(198)])
call HGT_w2_OLR(G1H2(71),1,1,2)
call HGT_w2_invQ_OLR(G1H2(71),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(21)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(199),G2H2(135),G1H2(446),G1H2(281),G1H2(109) &
    ,G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(50)])
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(192),G2H2(139),G1H2(424),G1H2(293),G1H2(121) &
    ,G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(127)])
call HGT_OLR(G2H2(142),1,1,2)
call HGT_invQ_OLR(G2H2(142),2,5,2)
call HGT_OLR(G2H2(142),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(215),G2H2(143),G1H2(490),G1H2(323),G1H2(157) &
    ,G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(139)])
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(208),G2H2(147),G1H2(468),G1H2(341),G1H2(169) &
    ,G1H2(145)])
call HGT_w2_OLR(G1H2(23),1,1,2)
call HGT_w2_invQ_OLR(G1H2(23),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(173)])
call HGT_w2_OLR(G1H2(41),1,1,2)
call HGT_w2_invQ_OLR(G1H2(41),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(178)])
call HGT_w2_OLR(G1H2(65),1,1,2)
call HGT_w2_invQ_OLR(G1H2(65),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(249),[G1H2(179)])
call HGT_w2_OLR(G1H2(24),1,1,2)
call HGT_w2_invQ_OLR(G1H2(24),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(249)])
call HGT_w2_OLR(G1H2(53),1,1,2)
call HGT_w2_invQ_OLR(G1H2(53),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(183)])
call HGT_w2_OLR(G1H2(84),1,1,2)
call HGT_w2_invQ_OLR(G1H2(84),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(213),[G1H2(188)])
call HGT_w2_OLR(G1H2(60),1,1,2)
call HGT_w2_invQ_OLR(G1H2(60),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(189)])
call HGT_w2_OLR(G1H2(36),1,1,2)
call HGT_w2_invQ_OLR(G1H2(36),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(279),G1H2(204),G1H2(194)])
call HGT_w2_OLR(G1H2(29),1,1,2)
call HGT_w2_invQ_OLR(G1H2(29),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(174)])
call HGT_w2_OLR(G1H2(83),1,1,2)
call HGT_w2_invQ_OLR(G1H2(83),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(229),G2H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(291),G1H2(209),G1H2(199)])
call HGT_w2_OLR(G1H2(47),1,1,2)
call HGT_w2_invQ_OLR(G1H2(47),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G2H2(178)])
call HGT_w2_OLR(G1H2(77),1,1,2)
call HGT_w2_invQ_OLR(G1H2(77),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(230),G2H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(297),[G1H2(203)])
call HGT_w2_OLR(G1H2(89),1,1,2)
call HGT_w2_invQ_OLR(G1H2(89),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(208)])
call HGT_w2_OLR(G1H2(90),1,1,2)
call HGT_w2_invQ_OLR(G1H2(90),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(189),G1H2(489),G1H2(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(196),G1H2(467),G1H2(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(455)])
call HGT_OLR(G2H2(201),1,1,2)
call HGT_invQ_OLR(G2H2(201),2,5,2)
call HGT_OLR(G2H2(201),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(50),G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G2H2(204),G1H2(457),G1H2(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(477)])
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(206),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(2),G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(212),G1H2(479),G1H2(423)])
call HGT_w2_OLR(G1H2(91),1,1,2)
call HGT_w2_invQ_OLR(G1H2(91),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(161)])
call HGT_w2_OLR(G1H2(92),1,1,2)
call HGT_w2_invQ_OLR(G1H2(92),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(92),[G1H2(137)])
call HGT_w2_OLR(G1H2(93),1,1,2)
call HGT_w2_invQ_OLR(G1H2(93),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(125)])
call HGT_w2_OLR(G1H2(94),1,1,2)
call HGT_w2_invQ_OLR(G1H2(94),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(94),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(113)])
call HGT_w2_OLR(G1H2(95),1,1,2)
call HGT_w2_invQ_OLR(G1H2(95),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(158),[G1H2(57)])
call HGT_w2_OLR(G1H2(96),1,1,2)
call HGT_w2_invQ_OLR(G1H2(96),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(51)])
call HGT_w2_OLR(G1H4(106),1,1,4)
call HGT_w2_invQ_OLR(G1H4(106),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(79)])
call HGT_w2_OLR(G1H4(118),1,1,4)
call HGT_w2_invQ_OLR(G1H4(118),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(15)])
call HGT_w2_OLR(G1H2(97),1,1,2)
call HGT_w2_invQ_OLR(G1H2(97),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(160),[G1H2(74)])
call HGT_w2_OLR(G1H2(98),1,1,2)
call HGT_w2_invQ_OLR(G1H2(98),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(146)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(8)])
call HGT_w2_OLR(G1H4(23),1,1,4)
call HGT_w2_invQ_OLR(G1H4(23),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(181)])
call HGT_w2_OLR(G1H4(47),1,1,4)
call HGT_w2_invQ_OLR(G1H4(47),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G2H2(181),G2H2(237),G2H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G2H2(184),G2H2(240),G2H2(239),G2H2(235) &
    ,G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(444)])
call HGT_w2_OLR(G1H2(101),1,1,2)
call HGT_w2_invQ_OLR(G1H2(101),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(101)])
call HGT_w2_OLR(G1H2(102),1,1,2)
call HGT_w2_invQ_OLR(G1H2(102),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G1H4(121)])
call HGT_w2_OLR(G1H4(54),1,1,4)
call HGT_w2_invQ_OLR(G1H4(54),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(191),G2H2(247),G2H2(242)])
call HGT_w2_OLR(G1H4(64),1,1,4)
call HGT_w2_invQ_OLR(G1H4(64),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G2H2(194),G2H2(250),G2H2(249),G2H2(245) &
    ,G2H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(488)])
call HGT_w2_OLR(G1H2(104),1,1,2)
call HGT_w2_invQ_OLR(G1H2(104),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(104)])
call HGT_w2_OLR(G1H2(105),1,1,2)
call HGT_w2_invQ_OLR(G1H2(105),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(494)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(215),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G2H2(24),G1H2(251),G1H2(221),G1H2(5),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(27),G1H2(269),G1H2(239),G1H2(11),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(245),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(257),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(317),[G1H2(275),G1H2(132),G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(335),[G1H2(287),G1H2(144),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(305),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(311),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(353),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(359),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(365),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(220),[G1H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(231),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(237),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(238),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(261),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(412),G1H2(298),G1H2(280),G1H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(434),G1H2(304),G1H2(292),G1H2(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(346),G1H2(321),G1H2(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(456),G1H2(352),G1H2(322),G1H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(333),[G1H2(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(358),G1H2(339),G1H2(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(478),G1H2(364),G1H2(340),G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(351),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(81),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(27),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(128),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(29),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G1H2(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(418),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(452),[G1H2(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(440),[G1H2(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(430),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(462),[G1H2(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(496),[G1H2(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(484),[G1H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(474),[G1H2(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G1H2(495),G1H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(485),G1H2(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(151),[G1H2(473),G1H2(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(463),G1H2(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G2H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G2H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(83)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(150),ex4(:),G2tensor(10),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(153),ex4(:),G2tensor(12),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(221),ex4(:),G2tensor(14),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(156),ex3(:),G2tensor(16),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(159),ex3(:),G2tensor(18),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(227),ex3(:),G2tensor(20),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(162),ex4(:),G2tensor(22),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(165),ex4(:),G2tensor(24),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(218),ex4(:),G2tensor(26),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(168),ex3(:),G2tensor(28),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(171),ex3(:),G2tensor(30),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(224),ex3(:),G2tensor(32),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(53),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(80),ex3(:),G2tensor(55),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(57),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex3(:),G2tensor(59),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(55),mass4set(:,1),  & 
G1H2(404),G1H2(343),G1H2(344),G1H2(348),G1H2(349),2)
  call HG1shiftOLR(G1H2(343),8,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(69),mass4set(:,1),  & 
G1H2(350),G1H2(354),G1H2(355),G1H2(356),G1H2(360),2)
  call HG1shiftOLR(G1H2(354),4,2)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(35),mass4set(:,1),  & 
G1H4(88),G1H4(179),G1H4(166),G1H4(105),G1H4(184),4)
  call HG1shiftOLR(G1H4(179),12,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(11),mass4set(:,1),  & 
G1H4(13),G1H4(190),G1H4(9),G1H4(33),G1H4(196),4)
  call HG1shiftOLR(G1H4(190),12,4)
  call Hloop_VQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(276))
  call Hloop_VQ_A(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(278))
  call Hloop_QV_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(279))
  call Hloop_AV_Q(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(280))
  call Hloop_QV_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(281))
  call Hloop_AV_Q(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(282))
  call Hloop_QV_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(283))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(122),ex2(:),G2tensor(61),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hloop_QV_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(285))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex1(:),G2tensor(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hloop_AV_Q(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(286))
  call Hotf_4pt_reduction(G2H2(134),RedSet_4(250),mass4set(:,1),  & 
G1H2(361),G1H2(362),G1H2(366),G1H2(367),G1H2(368),2)
  call HG1shiftOLR(G1H2(362),4,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(154),mass4set(:,1),  & 
G1H2(373),G1H2(374),G1H2(378),G1H2(379),G1H2(384),2)
  call HG1shiftOLR(G1H2(374),16,2)
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(254),mass4set(:,1),  & 
G1H2(385),G1H2(390),G1H2(395),G1H2(400),G1H2(405),2)
  call HG1shiftOLR(G1H2(390),8,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(168),mass4set(:,1),  & 
G1H2(409),G1H2(410),G1H2(415),G1H2(416),G1H2(420),2)
  call HG1shiftOLR(G1H2(410),16,2)
  call Hotf_4pt_reduction(G2H2(142),RedSet_4(264),mass4set(:,1),  & 
G1H2(421),G1H2(426),G1H2(427),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(426),1,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(198),mass4set(:,1),  & 
G1H2(437),G1H2(438),G1H2(442),G1H2(443),G1H2(448),2)
  call HG1shiftOLR(G1H2(438),16,2)
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(268),mass4set(:,1),  & 
G1H2(449),G1H2(453),G1H2(454),G1H2(459),G1H2(460),2)
  call HG1shiftOLR(G1H2(453),2,2)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(212),mass4set(:,1),  & 
G1H2(464),G1H2(465),G1H2(470),G1H2(471),G1H2(475),2)
  call HG1shiftOLR(G1H2(465),16,2)
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(287))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(288))
  call Hloop_VA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(290))
  call Hloop_VQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(291))
  call Hloop_VQ_A(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(292))
  call Hloop_VA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(293))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(294))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(147),mass4set(:,1),  & 
G1H2(476),G1H2(481),G1H2(482),G1H2(486),G1H2(487),2)
  call HG1shiftOLR(G1H2(481),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(157),ex4(:),G2tensor(7),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hloop_QV_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(295))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(160),ex4(:),G2tensor(73),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(161),mass4set(:,1),  & 
G1H2(492),G1H2(493),G1H2(282),G1H2(294),G1H2(324),2)
  call HG1shiftOLR(G1H2(493),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(161),ex3(:),G2tensor(75),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hloop_AV_Q(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(296))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(164),ex3(:),G2tensor(11),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hloop_QV_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(298))
call HGT_OLR(G2H2(188),1,1,2)
call HGT_invQ_OLR(G2H2(188),2,5,2)
call HGT_OLR(G2H2(188),6,15,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(328),mass4set(:,1),  & 
G1H2(342),G1H2(372),G1H2(383),G1H2(414),G1H2(425),2)
  call HG1shiftOLR(G1H2(372),4,2)
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(306),mass4set(:,1),  & 
G1H2(436),G1H2(447),G1H2(458),G1H2(469),G1H2(480),2)
  call HG1shiftOLR(G1H2(447),16,2)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(329),mass4set(:,1),  & 
G1H4(37),G1H4(55),G1H4(202),G1H4(56),G1H4(140),4)
  call HG1shiftOLR(G1H4(55),3,4)
call HGT_OLR(G2H2(195),1,1,2)
call HGT_invQ_OLR(G2H2(195),2,5,2)
call HGT_OLR(G2H2(195),6,15,2)
  call Hotf_4pt_reduction(G2H2(195),RedSet_4(330),mass4set(:,1),  & 
G1H2(491),G1H2(107),G1H2(22),G1H2(46),G1H2(52),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(306),mass4set(:,1),  & 
G1H2(58),G1H2(82),G1H2(88),G1H2(1),G1H2(19),2)
  call HG1shiftOLR(G1H2(82),16,2)
call HGT_OLR(G2H4(53),1,1,4)
call HGT_invQ_OLR(G2H4(53),2,5,4)
call HGT_OLR(G2H4(53),6,15,4)
  call Hotf_4pt_reduction(G2H4(53),RedSet_4(331),mass4set(:,1),  & 
G1H4(91),G1H4(20),G1H4(1),G1H4(63),G1H4(30),4)
  call HG1shiftOLR(G1H4(20),3,4)
  call Hotf_4pt_reduction(G2H2(201),RedSet_4(317),mass4set(:,1),  & 
G1H2(7),G1H2(43),G1H2(55),G1H2(13),G1H2(49),2)
  call HG1shiftOLR(G1H2(43),16,2)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(11),mass4set(:,1),  & 
G1H4(154),G1H4(87),G1H4(163),G1H4(183),G1H4(189),4)
  call HG1shiftOLR(G1H4(87),12,4)
call HGT_OLR(G2H2(203),1,1,2)
call HGT_invQ_OLR(G2H2(203),2,5,2)
call HGT_OLR(G2H2(203),6,15,2)
  call Hotf_4pt_reduction(G2H2(203),RedSet_4(332),mass4set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(26),1,2)
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(309),mass4set(:,1),  & 
G1H2(44),G1H2(63),G1H2(51),G1H2(56),G1H2(81),2)
  call HG1shiftOLR(G1H2(63),16,2)
  call Hotf_4pt_reduction(G2H2(206),RedSet_4(323),mass4set(:,1),  & 
G1H2(69),G1H2(73),G1H2(79),G1H2(80),G1H2(85),2)
  call HG1shiftOLR(G1H2(73),16,2)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(35),mass4set(:,1),  & 
G1H4(195),G1H4(201),G1H4(208),G1H4(233),G1H4(42),4)
  call HG1shiftOLR(G1H4(201),12,4)
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(333),mass4set(:,1),  & 
G1H4(53),G1H4(230),G1H4(241),G1H4(92),G1H4(73),4)
  call HG1shiftOLR(G1H4(230),12,4)
call HGT_OLR(G2H2(211),1,1,2)
call HGT_invQ_OLR(G2H2(211),2,5,2)
call HGT_OLR(G2H2(211),6,15,2)
  call Hotf_4pt_reduction(G2H2(211),RedSet_4(334),mass4set(:,1),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(111),2,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(309),mass4set(:,1),  & 
G1H2(118),G1H2(122),G1H2(123),G1H2(124),G1H2(128),2)
  call HG1shiftOLR(G1H2(122),16,2)
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(335),mass4set(:,1),  & 
G1H4(2),G1H4(155),G1H4(44),G1H4(149),G1H4(89),4)
  call HG1shiftOLR(G1H4(155),12,4)
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(299))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(14),wf4(:,13),G2tensor(17),m3h4x1(:,57),heltab2x4(:,:,427))
  call Hloop_VA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(300))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(44),wf4(:,13),G2tensor(79),m3h4x1(:,58),heltab2x4(:,:,428))
  call Hloop_VQ_A(ntryL,G1H2(93),ex1(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(301))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(57),wf4(:,18),G2tensor(23),m3h4x1(:,59),heltab2x4(:,:,429))
  call Hloop_VQ_A(ntryL,G1H2(94),ex1(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(302))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(24),wf4(:,18),G2tensor(81),m3h4x1(:,60),heltab2x4(:,:,430))
  call Hloop_VA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(303))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,4),G2tensor(29),m3h4x1(:,61),heltab2x4(:,:,431))
  call Hloop_VA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(304))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(27),wf4(:,4),G2tensor(83),m3h4x1(:,62),heltab2x4(:,:,432))
  call Hloop_VQ_A(ntryL,G1H4(106),wf4(:,4),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(305))
  call Hloop_VQ_A(ntryL,G1H4(118),wf4(:,4),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(306))
  call Hloop_VQ_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(307))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(32),wf4(:,9),G2tensor(196),m3h4x1(:,65),heltab2x4(:,:,435))
  call Hloop_VQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(308))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(45),wf4(:,9),G2tensor(199),m3h4x1(:,66),heltab2x4(:,:,436))
  call Hloop_VA_Q(ntryL,G1H4(22),wf4(:,9),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(202),n2h1(309))
  call Hloop_VA_Q(ntryL,G1H4(23),wf4(:,9),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(310))
call HGT_w2_OLR(G1H2(99),1,1,2)
call HGT_w2_invQ_OLR(G1H2(99),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(112),n2h1(311))
call HGT_w2_OLR(G1H2(100),1,1,2)
call HGT_w2_invQ_OLR(G1H2(100),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(208),n2h1(312))
  call Hotf_4pt_reduction(G2H4(72),RedSet_4(336),mass4set(:,1),  & 
G1H4(25),G1H4(176),G1H4(180),G1H4(76),G1H4(69),4)
  call HG1shiftOLR(G1H4(176),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(186),ex4(:),G2tensor(211),m3h2x1(:,375),heltab2x2(:,:,375))
call HGT_w2_OLR(G1H4(48),1,1,4)
call HGT_w2_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,1),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(313))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(190),ex4(:),G2tensor(214),m3h2x1(:,376),heltab2x2(:,:,376))
call HGT_w2_OLR(G1H4(52),1,1,4)
call HGT_w2_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(52),wf4(:,1),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(217),n2h1(314))
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(313),mass4set(:,1),  & 
G1H2(129),G1H2(130),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(130),16,2)
  call Hloop_QV_A(ntryL,G1H2(102),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(220),n2h1(315))
call HGT_w2_OLR(G1H2(103),1,1,2)
call HGT_w2_invQ_OLR(G1H2(103),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(118),n2h1(316))
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(315),mass4set(:,1),  & 
G1H4(203),G1H4(200),G1H4(101),G1H4(112),G1H4(236),4)
  call HG1shiftOLR(G1H4(200),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(197),ex2(:),G2tensor(223),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,12),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(317))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(200),ex2(:),G2tensor(124),m3h2x1(:,380),heltab2x2(:,:,380))
call HGT_w2_OLR(G1H4(65),1,1,4)
call HGT_w2_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,12),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(229),n2h1(318))
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(325),mass4set(:,1),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(146),G1H2(164),2)
  call HG1shiftOLR(G1H2(141),16,2)
  call Hloop_QV_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(319))
call HGT_w2_OLR(G1H2(106),1,1,2)
call HGT_w2_invQ_OLR(G1H2(106),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(320))
  call Hloop_VA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(321))
  call Hotf_4pt_reduction(G2H2(137),RedSet_4(101),mass4set(:,1),  & 
G1H2(166),G1H2(170),G1H2(171),G1H2(176),G1H2(2),2)
  call HG1shiftOLR(G1H2(170),8,2)
  call Hloop_VA_Q(ntryL,G1H2(227),ex2(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(322))
  call Hloop_VA_Q(ntryL,G1H2(233),ex2(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(323))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(115),mass4set(:,1),  & 
G1H2(177),G1H2(4),G1H2(182),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(4),2,2)
  call Hloop_VA_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(324))
  call Hloop_VA_Q(ntryL,G1H2(257),ex2(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(325))
  call Hloop_VA_Q(ntryL,G1H2(263),ex2(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(326))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(327))
  call Hloop_QV_A(ntryL,G1H2(317),ex5(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(328))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(335),ex5(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(253),n2h1(330))
  call Hloop_VQ_A(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(256),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(299),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(332))
  call Hloop_VA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(259),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(126),ex1(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(336))
  call Hloop_VA_Q(ntryL,G1H2(138),ex2(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(337))
  call Hloop_AV_Q(ntryL,G1H2(329),ex5(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(338))
  call Hloop_VQ_A(ntryL,G1H2(150),ex1(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(339))
  call Hloop_QV_A(ntryL,G1H2(347),ex5(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(340))
  call Hloop_QV_A(ntryL,G1H2(353),ex5(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(341))
  call Hloop_VA_Q(ntryL,G1H2(162),ex2(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(359),ex5(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(344))
  call Hloop_VA_Q(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(345))
  call Hloop_VA_Q(ntryL,G1H2(231),ex2(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(346))
  call Hloop_VA_Q(ntryL,G1H2(237),ex2(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(238),ex2(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H2(250),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(349))
  call Hloop_VA_Q(ntryL,G1H2(261),ex2(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(350))
  call Hloop_VA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(271),n2h1(351))
  call Hloop_VA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(352))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(150),mass4set(:,1),  & 
G1H2(191),G1H2(8),G1H2(192),G1H2(196),G1H2(10),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(164),mass4set(:,1),  & 
G1H2(201),G1H2(12),G1H2(202),G1H2(206),G1H2(14),2)
  call HG1shiftOLR(G1H2(12),16,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(191),mass4set(:,1),  & 
G1H2(207),G1H2(16),G1H2(212),G1H2(216),G1H2(218),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(195),mass4set(:,1),  & 
G1H2(222),G1H2(223),G1H2(228),G1H2(229),G1H2(230),2)
  call HG1shiftOLR(G1H2(223),16,2)
  call Hloop_AV_Q(ntryL,G1H2(333),ex5(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(353))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(205),mass4set(:,1),  & 
G1H2(235),G1H2(236),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(236),16,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(209),mass4set(:,1),  & 
G1H2(247),G1H2(248),G1H2(252),G1H2(254),G1H2(258),2)
  call HG1shiftOLR(G1H2(248),16,2)
  call Hloop_QV_A(ntryL,G1H2(351),ex5(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(354))
  call Hloop_VQ_A(ntryL,G1H4(109),wf4(:,13),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(355))
  call Hloop_VQ_A(ntryL,G1H4(78),wf4(:,13),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(356))
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(199),mass4set(:,1),  & 
G1H4(102),G1H4(126),G1H4(131),G1H4(119),G1H4(125),4)
  call HG1shiftOLR(G1H4(126),17,4)
  call Hloop_VQ_A(ntryL,G1H4(98),wf4(:,13),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(357))
  call Hloop_VQ_A(ntryL,G1H4(100),wf4(:,13),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(358))
  call Hloop_VA_Q(ntryL,G1H4(111),wf4(:,18),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(359))
  call Hloop_VA_Q(ntryL,G1H4(117),wf4(:,18),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(360))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(213),mass4set(:,1),  & 
G1H4(162),G1H4(224),G1H4(171),G1H4(172),G1H4(204),4)
  call HG1shiftOLR(G1H4(224),18,4)
  call Hloop_VA_Q(ntryL,G1H4(165),wf4(:,18),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(303),n2h1(361))
  call Hloop_VA_Q(ntryL,G1H4(115),wf4(:,18),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(362))
  call Hloop_VQ_A(ntryL,G1H4(39),wf4(:,4),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(315),n2h1(363))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(155),mass4set(:,1),  & 
G1H4(235),G1H4(113),G1H4(49),G1H4(114),G1H4(67),4)
  call HG1shiftOLR(G1H4(113),20,4)
  call Hloop_VQ_A(ntryL,G1H4(80),wf4(:,4),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(364))
  call Hloop_VA_Q(ntryL,G1H4(122),wf4(:,9),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(365))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(169),mass4set(:,1),  & 
G1H4(68),G1H4(104),G1H4(134),G1H4(110),G1H4(139),4)
  call HG1shiftOLR(G1H4(104),24,4)
  call Hloop_VA_Q(ntryL,G1H4(14),wf4(:,9),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(327),n2h1(366))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(301),mass4set(:,1),  & 
G1H2(259),G1H2(264),G1H2(265),G1H2(266),G1H2(277),2)
  call HG1shiftOLR(G1H2(264),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(6),mass4set(:,1),  & 
G1H2(278),G1H2(389),G1H2(284),G1H2(288),G1H2(289),2)
  call HG1shiftOLR(G1H2(389),8,2)
  call Hloop_VA_Q(ntryL,G1H2(375),ex4(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(331),n2h1(367))
  call Hloop_VA_Q(ntryL,G1H2(376),ex4(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(368))
  call Hloop_VA_Q(ntryL,G1H2(377),ex4(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(339),n2h1(369))
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(303),mass4set(:,1),  & 
G1H2(290),G1H2(394),G1H2(295),G1H2(296),G1H2(300),2)
  call HG1shiftOLR(G1H2(394),4,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(20),mass4set(:,1),  & 
G1H2(301),G1H2(302),G1H2(307),G1H2(308),G1H2(318),2)
  call HG1shiftOLR(G1H2(302),4,2)
  call Hloop_VQ_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(370))
  call Hloop_VQ_A(ntryL,G1H2(387),ex3(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(371))
  call Hloop_VQ_A(ntryL,G1H2(388),ex3(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(351),n2h1(372))
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(29),mass4set(:,1),  & 
G1H4(3),G1H4(4),G1H4(207),G1H4(229),G1H4(212),4)
  call HG1shiftOLR(G1H4(4),12,4)
  call Hotf_4pt_reduction(G2H4(73),RedSet_4(32),mass4set(:,1),  & 
G1H4(213),G1H4(223),G1H4(228),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(223),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(85),51,wf4(:,12),12,G2tensor(355),m3h4x1(:,85),heltab2x4(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(86),51,wf4(:,12),12,G2tensor(356),m3h4x1(:,86),heltab2x4(:,:,456))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(150),51,wf4(:,12),12,G2tensor(357),m3h4x1(:,87),heltab2x4(:,:,457))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(4),mass4set(:,1),  & 
G1H4(244),G1H4(245),G1H4(151),G1H4(152),G1H4(132),4)
  call HG1shiftOLR(G1H4(245),12,4)
  call Hotf_4pt_reduction(G2H4(76),RedSet_4(8),mass4set(:,1),  & 
G1H4(138),G1H4(143),G1H4(144),G1H4(148),G1H4(82),4)
  call HG1shiftOLR(G1H4(143),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(205),51,wf4(:,12),12,G2tensor(358),m3h4x1(:,88),heltab2x4(:,:,458))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(161),51,wf4(:,12),12,G2tensor(359),m3h4x1(:,89),heltab2x4(:,:,459))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(164),51,wf4(:,12),12,G2tensor(360),m3h4x1(:,90),heltab2x4(:,:,460))
  call Hloop_QV_A(ntryL,G1H2(418),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(361),n2h1(373))
  call Hloop_QV_A(ntryL,G1H2(452),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(374))
  call Hloop_AV_Q(ntryL,G1H2(440),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(363),n2h1(375))
  call Hloop_AV_Q(ntryL,G1H2(430),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(364),n2h1(376))
  call Hloop_QV_A(ntryL,G1H2(401),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(377))
  call Hloop_QV_A(ntryL,G1H2(462),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(366),n2h1(378))
  call Hloop_QV_A(ntryL,G1H2(496),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(379))
  call Hloop_AV_Q(ntryL,G1H2(406),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(380))
  call Hloop_AV_Q(ntryL,G1H2(484),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(369),n2h1(381))
  call Hloop_AV_Q(ntryL,G1H2(474),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(370),n2h1(382))
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(305),mass4set(:,1),  & 
G1H2(319),G1H2(320),G1H2(399),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hloop_QV_A(ntryL,G1H2(417),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(383))
  call Hloop_QV_A(ntryL,G2H2(155),ex5(:),G2H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(384))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(308),mass4set(:,1),  & 
G1H2(330),G1H2(331),G1H2(332),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(331),16,2)
  call Hloop_AV_Q(ntryL,G1H2(428),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(372),n2h1(385))
  call Hloop_AV_Q(ntryL,G2H2(129),ex5(:),G2H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(386))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(311),mass4set(:,1),  & 
G1H2(338),G1H2(371),G1H2(382),G1H2(175),G1H2(148),2)
  call HG1shiftOLR(G1H2(371),16,2)
  call Hloop_AV_Q(ntryL,G1H2(439),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(373),n2h1(387))
  call Hloop_AV_Q(ntryL,G2H2(151),ex5(:),G2H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(388))
  call Hloop_QV_A(ntryL,G2H2(136),ex5(:),G2H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(4),n2h1(389))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(235),mass4set(:,1),  & 
G1H4(5),G1H4(6),G1H4(10),G1H4(11),G1H4(18),4)
  call HG1shiftOLR(G1H4(6),12,4)
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,12),G2H1(1),m3h4x1(:,91),heltab2x4(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(5),n2h1(390))
  call Hloop_QV_A(ntryL,G1H4(133),wf4(:,12),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(391))
  call Hloop_QV_A(ntryL,G1H2(461),ex5(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(375),n2h1(392))
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(319),mass4set(:,1),  & 
G1H4(206),G1H4(209),G1H4(211),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(209),12,4)
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(235),mass4set(:,1),  & 
G1H4(221),G1H4(226),G1H4(225),G1H4(227),G1H4(231),4)
  call HG1shiftOLR(G1H4(226),12,4)
  call Hloop_AV_Q(ntryL,G1H4(188),wf4(:,12),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(393))
  call Hloop_AV_Q(ntryL,G2H4(20),wf4(:,12),G2H1(1),m3h4x1(:,94),heltab2x4(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(394))
  call Hloop_AV_Q(ntryL,G1H4(192),wf4(:,12),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(395))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(321),mass4set(:,1),  & 
G1H2(180),G1H2(31),G1H2(147),G1H2(185),G1H2(153),2)
  call HG1shiftOLR(G1H2(31),16,2)
  call Hloop_AV_Q(ntryL,G1H2(472),ex5(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(378),n2h1(396))
  call Hloop_AV_Q(ntryL,G1H2(483),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(379),n2h1(397))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(380),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(381),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(382),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(383),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(384),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(56),ex3(:),G2tensor(385),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(386),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(387),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(388),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(89),ex3(:),G2tensor(389),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(390),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex1(:),G2tensor(391),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(392),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(393),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(394),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(395),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(81),wf4(:,13),G2tensor(396),m3h4x1(:,96),heltab2x4(:,:,466))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(82),wf4(:,13),G2tensor(397),m3h4x1(:,97),heltab2x4(:,:,467))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(22),wf4(:,18),G2tensor(398),m3h4x1(:,98),heltab2x4(:,:,468))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(25),wf4(:,18),G2tensor(399),m3h4x1(:,99),heltab2x4(:,:,469))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(28),wf4(:,4),G2tensor(400),m3h4x1(:,100),heltab2x4(:,:,470))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(31),wf4(:,4),G2tensor(401),m3h4x1(:,101),heltab2x4(:,:,471))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(34),wf4(:,9),G2tensor(402),m3h4x1(:,102),heltab2x4(:,:,472))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(38),wf4(:,9),G2tensor(403),m3h4x1(:,103),heltab2x4(:,:,473))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex4(:),G2tensor(404),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(141),ex4(:),G2tensor(405),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(124),ex3(:),G2tensor(406),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(145),ex3(:),G2tensor(407),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(169),ex4(:),G2tensor(408),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(97),ex4(:),G2tensor(409),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(93),ex4(:),G2tensor(410),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(173),ex2(:),G2tensor(411),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(412),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(179),ex2(:),G2tensor(413),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex2(:),G2tensor(414),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(70),mass4set(:,1),  & 
G1H4(232),G1H4(242),G1H4(238),G1H4(243),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),20,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(56),mass4set(:,1),  & 
G1H4(97),G1H4(173),G1H4(185),G1H4(66),G1H4(84),4)
  call HG1shiftOLR(G1H4(173),24,4)
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(238),mass4set(:,1),  & 
G1H4(90),G1H4(95),G1H4(93),G1H4(36),G1H4(40),4)
  call HG1shiftOLR(G1H4(95),17,4)
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(239),mass4set(:,1),  & 
G1H4(35),G1H4(141),G1H4(31),G1H4(45),G1H4(159),4)
  call HG1shiftOLR(G1H4(141),18,4)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(236),mass4set(:,1),  & 
G1H8(96),G1H8(101),G1H8(107),G1H8(114),G1H8(108),8)
  call HG1shiftOLR(G1H8(101),19,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(236),mass4set(:,1),  & 
G1H8(113),G1H8(119),G1H8(135),G1H8(50),G1H8(14),8)
  call HG1shiftOLR(G1H8(119),19,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(237),mass4set(:,1),  & 
G1H8(4),G1H8(44),G1H8(63),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(44),19,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(237),mass4set(:,1),  & 
G1H8(81),G1H8(79),G1H8(91),G1H8(87),G1H8(97),8)
  call HG1shiftOLR(G1H8(79),19,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(236),mass4set(:,1),  & 
G1H8(93),G1H8(94),G1H8(98),G1H8(105),G1H8(103),8)
  call HG1shiftOLR(G1H8(94),19,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(236),mass4set(:,1),  & 
G1H8(104),G1H8(106),G1H8(125),G1H8(126),G1H8(130),8)
  call HG1shiftOLR(G1H8(106),19,8)
  call Hotf_4pt_reduction(G2H8(37),RedSet_4(237),mass4set(:,1),  & 
G1H8(131),G1H8(141),G1H8(142),G1H8(146),G1H8(147),8)
  call HG1shiftOLR(G1H8(141),19,8)
  call Hotf_4pt_reduction(G2H8(38),RedSet_4(237),mass4set(:,1),  & 
G1H8(75),G1H8(76),G1H8(80),G1H8(82),G1H8(7),8)
  call HG1shiftOLR(G1H8(76),19,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(82),mass4set(:,1),  & 
G1H8(20),G1H8(85),G1H8(86),G1H8(88),G1H8(92),8)
  call HG1shiftOLR(G1H8(85),28,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(82),mass4set(:,1),  & 
G1H8(25),G1H8(30),G1H8(99),G1H8(100),G1H8(54),8)
  call HG1shiftOLR(G1H8(30),28,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(60),mass4set(:,1),  & 
G1H8(22),G1H8(109),G1H8(110),G1H8(53),G1H8(59),8)
  call HG1shiftOLR(G1H8(109),28,8)
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(60),mass4set(:,1),  & 
G1H8(111),G1H8(112),G1H8(116),G1H8(117),G1H8(118),8)
  call HG1shiftOLR(G1H8(112),28,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(82),mass4set(:,1),  & 
G1H8(123),G1H8(124),G1H8(127),G1H8(129),G1H8(132),8)
  call HG1shiftOLR(G1H8(124),28,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(82),mass4set(:,1),  & 
G1H8(134),G1H8(139),G1H8(144),G1H8(140),G1H8(145),8)
  call HG1shiftOLR(G1H8(139),28,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(60),mass4set(:,1),  & 
G1H8(148),G1H8(52),G1H8(137),G1H8(49),G1H8(23),8)
  call HG1shiftOLR(G1H8(52),28,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(60),mass4set(:,1),  & 
G1H8(48),G1H8(121),G1H8(122),G1H8(42),G1H8(138),8)
  call HG1shiftOLR(G1H8(121),28,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(415),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(416),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(45),ex3(:),G2tensor(417),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(51),ex3(:),G2tensor(418),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(419),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(94),ex4(:),G2tensor(420),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex2(:),G2tensor(421),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex2(:),G2tensor(422),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(103),ex2(:),G2tensor(423),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(108),ex1(:),G2tensor(424),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(111),ex1(:),G2tensor(425),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(112),ex2(:),G2tensor(426),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(427),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(121),ex3(:),G2tensor(428),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hloop_AV_Q(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(429),n2h1(398))
  call Hloop_QV_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(430),n2h1(399))
  call Hloop_QV_A(ntryL,G1H4(193),wf4(:,12),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(431),n2h1(400))
  call Hloop_AV_Q(ntryL,G1H4(220),wf4(:,12),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(432),n2h1(401))
  call Hloop_AV_Q(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(433),n2h1(402))
  call Hloop_QV_A(ntryL,G1H2(270),ex5(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(403))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(61),wf4(:,13),G2tensor(435),m3h4x1(:,106),heltab2x4(:,:,476))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(9),wf4(:,13),G2tensor(436),m3h4x1(:,107),heltab2x4(:,:,477))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(15),wf4(:,18),G2tensor(437),m3h4x1(:,108),heltab2x4(:,:,478))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(29),wf4(:,18),G2tensor(438),m3h4x1(:,109),heltab2x4(:,:,479))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(30),wf4(:,4),G2tensor(439),m3h4x1(:,110),heltab2x4(:,:,480))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(36),wf4(:,4),G2tensor(440),m3h4x1(:,111),heltab2x4(:,:,481))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(48),wf4(:,9),G2tensor(441),m3h4x1(:,112),heltab2x4(:,:,482))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(56),wf4(:,9),G2tensor(442),m3h4x1(:,113),heltab2x4(:,:,483))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(166),ex4(:),G2tensor(443),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(170),ex2(:),G2tensor(444),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(175),ex2(:),G2tensor(445),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(68),wf4(:,4),G2tensor(446),m3h4x1(:,114),heltab2x4(:,:,484))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(67),wf4(:,4),G2tensor(447),m3h4x1(:,115),heltab2x4(:,:,485))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(71),wf4(:,9),G2tensor(448),m3h4x1(:,116),heltab2x4(:,:,486))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(64),wf4(:,9),G2tensor(449),m3h4x1(:,117),heltab2x4(:,:,487))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(40),wf8(:,3),G2tensor(450),m3h8x1(:,1),heltab2x8(:,:,349))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(31),wf8(:,3),G2tensor(451),m3h8x1(:,2),heltab2x8(:,:,350))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(65),wf4(:,13),G2tensor(452),m3h4x1(:,118),heltab2x4(:,:,488))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(70),wf4(:,13),G2tensor(453),m3h4x1(:,119),heltab2x4(:,:,489))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(77),wf4(:,18),G2tensor(454),m3h4x1(:,120),heltab2x4(:,:,490))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(80),wf4(:,18),G2tensor(455),m3h4x1(:,121),heltab2x4(:,:,491))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(32),wf8(:,20),G2tensor(456),m3h8x1(:,3),heltab2x8(:,:,351))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,20),G2tensor(457),m3h8x1(:,4),heltab2x8(:,:,352))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,16),G2tensor(458),m3h8x1(:,5),heltab2x8(:,:,353))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,16),G2tensor(459),m3h8x1(:,6),heltab2x8(:,:,354))
  call Hloop_VA_Q(ntryL,G1H2(404),ex4(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(460),n2h1(404))
  call Hloop_VA_Q(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(461),n2h1(405))
  call Hloop_VA_Q(ntryL,G1H2(349),ex4(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(462),n2h1(406))
  call Hloop_VQ_A(ntryL,G1H2(350),ex3(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(463),n2h1(407))
  call Hloop_VQ_A(ntryL,G1H2(354),ex3(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(464),n2h1(408))
  call Hloop_VQ_A(ntryL,G1H2(360),ex3(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(465),n2h1(409))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(88),51,wf4(:,12),12,G2tensor(466),m3h4x1(:,122),heltab2x4(:,:,492))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(179),0,wf4(:,12),12,G2tensor(467),m3h4x1(:,123),heltab2x4(:,:,493))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(184),51,wf4(:,12),12,G2tensor(468),m3h4x1(:,124),heltab2x4(:,:,494))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(13),51,wf4(:,12),12,G2tensor(469),m3h4x1(:,125),heltab2x4(:,:,495))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(190),0,wf4(:,12),12,G2tensor(470),m3h4x1(:,126),heltab2x4(:,:,496))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(196),51,wf4(:,12),12,G2tensor(471),m3h4x1(:,127),heltab2x4(:,:,497))
  call Hloop_VQ_A(ntryL,G1H2(361),ex3(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(472),n2h1(412))
  call Hloop_VQ_A(ntryL,G1H2(362),ex3(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(473),n2h1(413))
  call Hloop_VQ_A(ntryL,G1H2(368),ex3(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(474),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(373),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(475),n2h1(415))
  call Hloop_QV_A(ntryL,G1H2(374),ex5(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(476),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(384),ex5(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(477),n2h1(417))
  call Hloop_VA_Q(ntryL,G1H2(385),ex4(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(478),n2h1(418))
  call Hloop_VA_Q(ntryL,G1H2(390),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(479),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H2(405),ex4(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(480),n2h1(420))
  call Hloop_AV_Q(ntryL,G1H2(409),ex5(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(481),n2h1(421))
  call Hloop_AV_Q(ntryL,G1H2(410),ex5(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(482),n2h1(422))
  call Hloop_AV_Q(ntryL,G1H2(420),ex5(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(483),n2h1(423))
  call Hloop_VQ_A(ntryL,G1H2(421),ex1(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(484),n2h1(424))
  call Hloop_VQ_A(ntryL,G1H2(426),ex1(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(485),n2h1(425))
  call Hloop_VQ_A(ntryL,G1H2(432),ex1(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(486),n2h1(426))
  call Hloop_QV_A(ntryL,G1H2(437),ex5(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(487),n2h1(427))
  call Hloop_QV_A(ntryL,G1H2(438),ex5(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(488),n2h1(428))
  call Hloop_QV_A(ntryL,G1H2(448),ex5(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(489),n2h1(429))
  call Hloop_VA_Q(ntryL,G1H2(449),ex2(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(490),n2h1(430))
  call Hloop_VA_Q(ntryL,G1H2(453),ex2(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(491),n2h1(431))
  call Hloop_VA_Q(ntryL,G1H2(460),ex2(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(492),n2h1(432))
  call Hloop_AV_Q(ntryL,G1H2(464),ex5(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(493),n2h1(433))
  call Hloop_AV_Q(ntryL,G1H2(465),ex5(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(494),n2h1(434))
  call Hloop_AV_Q(ntryL,G1H2(475),ex5(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(495),n2h1(435))
  call Hloop_QV_A(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(496),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(481),ex5(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(497),n2h1(437))
  call Hloop_QV_A(ntryL,G1H2(487),ex5(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(498),n2h1(438))
  call Hloop_AV_Q(ntryL,G1H2(492),ex5(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(499),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H2(493),ex5(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(500),n2h1(440))
  call Hloop_AV_Q(ntryL,G1H2(324),ex5(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(501),n2h1(441))
  call Hloop_VQ_A(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(502),n2h1(442))
  call Hloop_VQ_A(ntryL,G1H2(372),ex3(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(503),n2h1(443))
  call Hloop_VQ_A(ntryL,G1H2(425),ex3(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(504),n2h1(444))
  call Hloop_QV_A(ntryL,G1H2(436),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(505),n2h1(445))
  call Hloop_QV_A(ntryL,G1H2(447),ex5(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(506),n2h1(446))
  call Hloop_QV_A(ntryL,G1H2(480),ex5(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(507),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H4(37),wf4(:,1),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(508),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H4(55),wf4(:,1),G1H1(1),m3h4x1(:,129),heltab2x4(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,0,G2tensor(509),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H4(140),wf4(:,1),G1H1(1),m3h4x1(:,130),heltab2x4(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(510),n2h1(450))
  call Hloop_VA_Q(ntryL,G1H2(491),ex4(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(511),n2h1(451))
  call Hloop_VA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(512),n2h1(452))
  call Hloop_VA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(513),n2h1(453))
  call Hloop_AV_Q(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(514),n2h1(454))
  call Hloop_AV_Q(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(515),n2h1(455))
  call Hloop_AV_Q(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(516),n2h1(456))
  call Hloop_QV_A(ntryL,G1H4(91),wf4(:,1),G1H1(1),m3h4x1(:,131),heltab2x4(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(517),n2h1(457))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,1),G1H1(1),m3h4x1(:,132),heltab2x4(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(518),n2h1(458))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,133),heltab2x4(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(519),n2h1(459))
  call Hloop_QV_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(520),n2h1(460))
  call Hloop_QV_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(521),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(522),n2h1(462))
  call Hloop_QV_A(ntryL,G1H4(154),wf4(:,12),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(523),n2h1(463))
  call Hloop_QV_A(ntryL,G1H4(87),wf4(:,12),G1H1(1),m3h4x1(:,135),heltab2x4(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(524),n2h1(464))
  call Hloop_QV_A(ntryL,G1H4(189),wf4(:,12),G1H1(1),m3h4x1(:,136),heltab2x4(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(525),n2h1(465))
  call Hloop_VQ_A(ntryL,G1H2(25),ex1(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(526),n2h1(466))
  call Hloop_VQ_A(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(527),n2h1(467))
  call Hloop_VQ_A(ntryL,G1H2(39),ex1(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(528),n2h1(468))
  call Hloop_QV_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(529),n2h1(469))
  call Hloop_QV_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(530),n2h1(470))
  call Hloop_QV_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(531),n2h1(471))
  call Hloop_AV_Q(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(532),n2h1(472))
  call Hloop_AV_Q(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(533),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(534),n2h1(474))
  call Hloop_AV_Q(ntryL,G1H4(195),wf4(:,12),G1H1(1),m3h4x1(:,137),heltab2x4(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(535),n2h1(475))
  call Hloop_AV_Q(ntryL,G1H4(201),wf4(:,12),G1H1(1),m3h4x1(:,138),heltab2x4(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(536),n2h1(476))
  call Hloop_AV_Q(ntryL,G1H4(42),wf4(:,12),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(537),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H4(53),wf4(:,12),G1H1(1),m3h4x1(:,140),heltab2x4(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(538),n2h1(478))
  call Hloop_AV_Q(ntryL,G1H4(230),wf4(:,12),G1H1(1),m3h4x1(:,141),heltab2x4(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(539),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,12),G1H1(1),m3h4x1(:,142),heltab2x4(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(540),n2h1(480))
  call Hloop_VA_Q(ntryL,G1H2(110),ex2(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(541),n2h1(481))
  call Hloop_VA_Q(ntryL,G1H2(111),ex2(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(542),n2h1(482))
  call Hloop_VA_Q(ntryL,G1H2(117),ex2(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(543),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(544),n2h1(484))
  call Hloop_AV_Q(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(545),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(546),n2h1(486))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,12),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(547),n2h1(487))
  call Hloop_QV_A(ntryL,G1H4(155),wf4(:,12),G1H1(1),m3h4x1(:,144),heltab2x4(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(548),n2h1(488))
  call Hloop_QV_A(ntryL,G1H4(89),wf4(:,12),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(549),n2h1(489))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,1),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(550),n2h1(490))
  call Hloop_QV_A(ntryL,G1H4(176),wf4(:,1),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(551),n2h1(491))
  call Hloop_QV_A(ntryL,G1H4(69),wf4(:,1),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(552),n2h1(492))
  call Hloop_QV_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(553),n2h1(493))
  call Hloop_QV_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(554),n2h1(494))
  call Hloop_QV_A(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(555),n2h1(495))
  call Hloop_QV_A(ntryL,G1H4(203),wf4(:,12),G1H1(1),m3h4x1(:,149),heltab2x4(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(556),n2h1(496))
  call Hloop_QV_A(ntryL,G1H4(200),wf4(:,12),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(557),n2h1(497))
  call Hloop_QV_A(ntryL,G1H4(236),wf4(:,12),G1H1(1),m3h4x1(:,151),heltab2x4(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(558),n2h1(498))
  call Hloop_QV_A(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(559),n2h1(499))
  call Hloop_QV_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(560),n2h1(500))
  call Hloop_QV_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(561),n2h1(501))
  call Hloop_VA_Q(ntryL,G1H2(166),ex4(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(562),n2h1(502))
  call Hloop_VA_Q(ntryL,G1H2(170),ex4(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(563),n2h1(503))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(564),n2h1(504))
  call Hloop_VA_Q(ntryL,G1H2(177),ex2(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(565),n2h1(505))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(566),n2h1(506))
  call Hloop_VA_Q(ntryL,G1H2(187),ex2(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(567),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(191),ex5(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(568),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(569),n2h1(509))
  call Hloop_QV_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(570),n2h1(510))
  call Hloop_AV_Q(ntryL,G1H2(201),ex5(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(571),n2h1(511))
  call Hloop_AV_Q(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(572),n2h1(512))
  call Hloop_AV_Q(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(573),n2h1(513))
  call Hloop_QV_A(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(574),n2h1(514))
  call Hloop_QV_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(575),n2h1(515))
  call Hloop_QV_A(ntryL,G1H2(218),ex5(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(576),n2h1(516))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(577),n2h1(517))
  call Hloop_QV_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(578),n2h1(518))
  call Hloop_QV_A(ntryL,G1H2(230),ex5(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(579),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(235),ex5(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(580),n2h1(520))
  call Hloop_AV_Q(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(581),n2h1(521))
  call Hloop_AV_Q(ntryL,G1H2(242),ex5(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(582),n2h1(522))
  call Hloop_AV_Q(ntryL,G1H2(247),ex5(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(583),n2h1(523))
  call Hloop_AV_Q(ntryL,G1H2(248),ex5(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(584),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(585),n2h1(525))
  call Hloop_VQ_A(ntryL,G1H4(102),wf4(:,13),G1H1(1),m3h4x1(:,152),heltab2x4(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(586),n2h1(526))
  call Hloop_VQ_A(ntryL,G1H4(126),wf4(:,13),G1H1(1),m3h4x1(:,153),heltab2x4(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(587),n2h1(527))
  call Hloop_VQ_A(ntryL,G1H4(125),wf4(:,13),G1H1(1),m3h4x1(:,154),heltab2x4(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(588),n2h1(528))
  call Hloop_VA_Q(ntryL,G1H4(162),wf4(:,18),G1H1(1),m3h4x1(:,155),heltab2x4(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(589),n2h1(529))
  call Hloop_VA_Q(ntryL,G1H4(224),wf4(:,18),G1H1(1),m3h4x1(:,156),heltab2x4(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(590),n2h1(530))
  call Hloop_VA_Q(ntryL,G1H4(204),wf4(:,18),G1H1(1),m3h4x1(:,157),heltab2x4(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(591),n2h1(531))
  call Hloop_VQ_A(ntryL,G1H4(235),wf4(:,4),G1H1(1),m3h4x1(:,158),heltab2x4(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(592),n2h1(532))
  call Hloop_VQ_A(ntryL,G1H4(113),wf4(:,4),G1H1(1),m3h4x1(:,159),heltab2x4(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(593),n2h1(533))
  call Hloop_VQ_A(ntryL,G1H4(67),wf4(:,4),G1H1(1),m3h4x1(:,160),heltab2x4(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(594),n2h1(534))
  call Hloop_VA_Q(ntryL,G1H4(68),wf4(:,9),G1H1(1),m3h4x1(:,161),heltab2x4(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(595),n2h1(535))
  call Hloop_VA_Q(ntryL,G1H4(104),wf4(:,9),G1H1(1),m3h4x1(:,162),heltab2x4(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(596),n2h1(536))
  call Hloop_VA_Q(ntryL,G1H4(139),wf4(:,9),G1H1(1),m3h4x1(:,163),heltab2x4(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(597),n2h1(537))
  call Hloop_VA_Q(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(598),n2h1(538))
  call Hloop_VA_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(599),n2h1(539))
  call Hloop_VA_Q(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(600),n2h1(540))
  call Hloop_VA_Q(ntryL,G1H2(278),ex4(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(601),n2h1(541))
  call Hloop_VA_Q(ntryL,G1H2(389),ex4(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(602),n2h1(542))
  call Hloop_VA_Q(ntryL,G1H2(289),ex4(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(603),n2h1(543))
  call Hloop_VQ_A(ntryL,G1H2(290),ex3(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(604),n2h1(544))
  call Hloop_VQ_A(ntryL,G1H2(394),ex3(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(605),n2h1(545))
  call Hloop_VQ_A(ntryL,G1H2(300),ex3(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(606),n2h1(546))
  call Hloop_VQ_A(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(607),n2h1(547))
  call Hloop_VQ_A(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(608),n2h1(548))
  call Hloop_VQ_A(ntryL,G1H2(318),ex3(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(609),n2h1(549))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),51,wf4(:,12),12,G2tensor(610),m3h4x1(:,164),heltab2x4(:,:,534))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),0,wf4(:,12),12,G2tensor(611),m3h4x1(:,165),heltab2x4(:,:,535))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(212),51,wf4(:,12),12,G2tensor(612),m3h4x1(:,166),heltab2x4(:,:,536))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(213),51,wf4(:,12),12,G2tensor(613),m3h4x1(:,167),heltab2x4(:,:,537))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(223),0,wf4(:,12),12,G2tensor(614),m3h4x1(:,168),heltab2x4(:,:,538))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(240),51,wf4(:,12),12,G2tensor(615),m3h4x1(:,169),heltab2x4(:,:,539))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(244),51,wf4(:,12),12,G2tensor(616),m3h4x1(:,170),heltab2x4(:,:,540))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(245),0,wf4(:,12),12,G2tensor(617),m3h4x1(:,171),heltab2x4(:,:,541))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(132),51,wf4(:,12),12,G2tensor(618),m3h4x1(:,172),heltab2x4(:,:,542))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),51,wf4(:,12),12,G2tensor(619),m3h4x1(:,173),heltab2x4(:,:,543))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(143),0,wf4(:,12),12,G2tensor(620),m3h4x1(:,174),heltab2x4(:,:,544))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(82),51,wf4(:,12),12,G2tensor(621),m3h4x1(:,175),heltab2x4(:,:,545))
  call Hloop_QV_A(ntryL,G1H2(319),ex5(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(622),n2h1(554))
  call Hloop_QV_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(623),n2h1(555))
  call Hloop_QV_A(ntryL,G1H2(326),ex5(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(624),n2h1(556))
  call Hloop_AV_Q(ntryL,G1H2(330),ex5(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(625),n2h1(557))
  call Hloop_AV_Q(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(626),n2h1(558))
  call Hloop_AV_Q(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(627),n2h1(559))
  call Hloop_AV_Q(ntryL,G1H2(338),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(628),n2h1(560))
  call Hloop_AV_Q(ntryL,G1H2(371),ex5(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(629),n2h1(561))
  call Hloop_AV_Q(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(630),n2h1(562))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,12),G1H1(1),m3h4x1(:,176),heltab2x4(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(631),n2h1(563))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,12),G1H1(1),m3h4x1(:,177),heltab2x4(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(632),n2h1(564))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,12),G1H1(1),m3h4x1(:,178),heltab2x4(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(633),n2h1(565))
  call Hloop_AV_Q(ntryL,G1H4(206),wf4(:,12),G1H1(1),m3h4x1(:,179),heltab2x4(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(634),n2h1(566))
  call Hloop_AV_Q(ntryL,G1H4(209),wf4(:,12),G1H1(1),m3h4x1(:,180),heltab2x4(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(635),n2h1(567))
  call Hloop_AV_Q(ntryL,G1H4(216),wf4(:,12),G1H1(1),m3h4x1(:,181),heltab2x4(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(636),n2h1(568))
  call Hloop_AV_Q(ntryL,G1H4(221),wf4(:,12),G1H1(1),m3h4x1(:,182),heltab2x4(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(637),n2h1(569))
  call Hloop_AV_Q(ntryL,G1H4(226),wf4(:,12),G1H1(1),m3h4x1(:,183),heltab2x4(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(638),n2h1(570))
  call Hloop_AV_Q(ntryL,G1H4(231),wf4(:,12),G1H1(1),m3h4x1(:,184),heltab2x4(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(639),n2h1(571))
  call Hloop_AV_Q(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(640),n2h1(572))
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(641),n2h1(573))
  call Hloop_AV_Q(ntryL,G1H2(153),ex5(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(642),n2h1(574))
  call Hloop_VQ_A(ntryL,G1H4(232),wf4(:,4),G1H1(1),m3h4x1(:,185),heltab2x4(:,:,555))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(643),n2h1(575))
  call Hloop_VQ_A(ntryL,G1H4(242),wf4(:,4),G1H1(1),m3h4x1(:,186),heltab2x4(:,:,556))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(644),n2h1(576))
  call Hloop_VQ_A(ntryL,G1H4(246),wf4(:,4),G1H1(1),m3h4x1(:,187),heltab2x4(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(645),n2h1(577))
  call Hloop_VA_Q(ntryL,G1H4(97),wf4(:,9),G1H1(1),m3h4x1(:,188),heltab2x4(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(646),n2h1(578))
  call Hloop_VA_Q(ntryL,G1H4(173),wf4(:,9),G1H1(1),m3h4x1(:,189),heltab2x4(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(647),n2h1(579))
  call Hloop_VA_Q(ntryL,G1H4(84),wf4(:,9),G1H1(1),m3h4x1(:,190),heltab2x4(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(648),n2h1(580))
  call Hloop_VQ_A(ntryL,G1H4(90),wf4(:,13),G1H1(1),m3h4x1(:,191),heltab2x4(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(649),n2h1(581))
  call Hloop_VQ_A(ntryL,G1H4(95),wf4(:,13),G1H1(1),m3h4x1(:,192),heltab2x4(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(650),n2h1(582))
  call Hloop_VQ_A(ntryL,G1H4(40),wf4(:,13),G1H1(1),m3h4x1(:,193),heltab2x4(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(651),n2h1(583))
  call Hloop_VA_Q(ntryL,G1H4(35),wf4(:,18),G1H1(1),m3h4x1(:,194),heltab2x4(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(652),n2h1(584))
  call Hloop_VA_Q(ntryL,G1H4(141),wf4(:,18),G1H1(1),m3h4x1(:,195),heltab2x4(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(653),n2h1(585))
  call Hloop_VA_Q(ntryL,G1H4(159),wf4(:,18),G1H1(1),m3h4x1(:,196),heltab2x4(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(654),n2h1(586))
  call Hloop_AV_Q(ntryL,G1H8(96),wf8(:,12),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(655),n2h1(587))
  call Hloop_AV_Q(ntryL,G1H8(101),wf8(:,12),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(656),n2h1(588))
  call Hloop_AV_Q(ntryL,G1H8(108),wf8(:,12),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(657),n2h1(589))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(113),44,wf8(:,12),19,G2tensor(658),m3h8x1(:,10),heltab2x8(:,:,358))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(119),0,wf8(:,12),19,G2tensor(659),m3h8x1(:,11),heltab2x8(:,:,359))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(14),44,wf8(:,12),19,G2tensor(660),m3h8x1(:,12),heltab2x8(:,:,360))
  call Hloop_QV_A(ntryL,G1H8(4),wf8(:,12),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(661),n2h1(591))
  call Hloop_QV_A(ntryL,G1H8(44),wf8(:,12),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(662),n2h1(592))
  call Hloop_QV_A(ntryL,G1H8(70),wf8(:,12),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(663),n2h1(593))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(81),44,wf8(:,12),19,G2tensor(664),m3h8x1(:,16),heltab2x8(:,:,364))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(79),0,wf8(:,12),19,G2tensor(665),m3h8x1(:,17),heltab2x8(:,:,365))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(97),44,wf8(:,12),19,G2tensor(666),m3h8x1(:,18),heltab2x8(:,:,366))
  call Hloop_AV_Q(ntryL,G1H8(93),wf8(:,17),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(667),n2h1(595))
  call Hloop_AV_Q(ntryL,G1H8(94),wf8(:,17),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(668),n2h1(596))
  call Hloop_AV_Q(ntryL,G1H8(103),wf8(:,17),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(669),n2h1(597))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(104),44,wf8(:,17),19,G2tensor(670),m3h8x1(:,22),heltab2x8(:,:,370))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(106),0,wf8(:,17),19,G2tensor(671),m3h8x1(:,23),heltab2x8(:,:,371))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(130),44,wf8(:,17),19,G2tensor(672),m3h8x1(:,24),heltab2x8(:,:,372))
  call Hloop_QV_A(ntryL,G1H8(131),wf8(:,17),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(673),n2h1(599))
  call Hloop_QV_A(ntryL,G1H8(141),wf8(:,17),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(674),n2h1(600))
  call Hloop_QV_A(ntryL,G1H8(147),wf8(:,17),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(675),n2h1(601))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(75),44,wf8(:,17),19,G2tensor(676),m3h8x1(:,28),heltab2x8(:,:,376))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(76),0,wf8(:,17),19,G2tensor(677),m3h8x1(:,29),heltab2x8(:,:,377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(7),44,wf8(:,17),19,G2tensor(678),m3h8x1(:,30),heltab2x8(:,:,378))
  call Hloop_AV_Q(ntryL,G1H8(20),wf8(:,4),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(679),n2h1(603))
  call Hloop_AV_Q(ntryL,G1H8(85),wf8(:,4),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(680),n2h1(604))
  call Hloop_AV_Q(ntryL,G1H8(92),wf8(:,4),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(681),n2h1(605))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(25),35,wf8(:,4),28,G2tensor(682),m3h8x1(:,34),heltab2x8(:,:,382))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(30),0,wf8(:,4),28,G2tensor(683),m3h8x1(:,35),heltab2x8(:,:,383))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(54),35,wf8(:,4),28,G2tensor(684),m3h8x1(:,36),heltab2x8(:,:,384))
  call Hloop_QV_A(ntryL,G1H8(22),wf8(:,4),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(685),n2h1(607))
  call Hloop_QV_A(ntryL,G1H8(109),wf8(:,4),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(686),n2h1(608))
  call Hloop_QV_A(ntryL,G1H8(59),wf8(:,4),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(687),n2h1(609))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(111),35,wf8(:,4),28,G2tensor(688),m3h8x1(:,40),heltab2x8(:,:,388))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(112),0,wf8(:,4),28,G2tensor(689),m3h8x1(:,41),heltab2x8(:,:,389))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(118),35,wf8(:,4),28,G2tensor(690),m3h8x1(:,42),heltab2x8(:,:,390))
  call Hloop_AV_Q(ntryL,G1H8(123),wf8(:,9),G1H1(1),m3h8x1(:,43),heltab2x8(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(691),n2h1(611))
  call Hloop_AV_Q(ntryL,G1H8(124),wf8(:,9),G1H1(1),m3h8x1(:,44),heltab2x8(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(692),n2h1(612))
  call Hloop_AV_Q(ntryL,G1H8(132),wf8(:,9),G1H1(1),m3h8x1(:,45),heltab2x8(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(693),n2h1(613))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(134),35,wf8(:,9),28,G2tensor(694),m3h8x1(:,46),heltab2x8(:,:,394))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(139),0,wf8(:,9),28,G2tensor(695),m3h8x1(:,47),heltab2x8(:,:,395))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(145),35,wf8(:,9),28,G2tensor(696),m3h8x1(:,48),heltab2x8(:,:,396))
  call Hloop_QV_A(ntryL,G1H8(148),wf8(:,9),G1H1(1),m3h8x1(:,49),heltab2x8(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(697),n2h1(615))
  call Hloop_QV_A(ntryL,G1H8(52),wf8(:,9),G1H1(1),m3h8x1(:,50),heltab2x8(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(698),n2h1(616))
  call Hloop_QV_A(ntryL,G1H8(23),wf8(:,9),G1H1(1),m3h8x1(:,51),heltab2x8(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(699),n2h1(617))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(48),35,wf8(:,9),28,G2tensor(700),m3h8x1(:,52),heltab2x8(:,:,400))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(121),0,wf8(:,9),28,G2tensor(701),m3h8x1(:,53),heltab2x8(:,:,401))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(138),35,wf8(:,9),28,G2tensor(702),m3h8x1(:,54),heltab2x8(:,:,402))
  call ol_merge_tensors(G2tensor(171),[G2tensor(2),G1tensor(95),G1tensor(48)])
  call ol_merge_tensors(G2tensor(456),[G2tensor(309),G2tensor(6),G2tensor(3),G1tensor(660),G1tensor(132),G1tensor(90)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(5),G1tensor(128),G1tensor(101)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(8),G1tensor(158),G1tensor(138)])
  call ol_merge_tensors(G2tensor(458),[G2tensor(305),G2tensor(106),G2tensor(15),G2tensor(9),G1tensor(654),G1tensor(582) &
    ,G1tensor(192),G1tensor(162)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(13),G1tensor(188),G1tensor(168)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(183),G2tensor(19),G1tensor(621),G1tensor(212),G1tensor(198)])
  call ol_merge_tensors(G2tensor(700),[G2tensor(697),G2tensor(688),G2tensor(685),G2tensor(353),G2tensor(333),G2tensor(98) &
    ,G2tensor(94),G2tensor(27),G2tensor(21),G1tensor(720),G1tensor(690),G1tensor(558),G1tensor(546),G1tensor(240),G1tensor(216)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(186),G2tensor(25),G1tensor(633),G1tensor(236),G1tensor(222)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(189),G2tensor(31),G1tensor(615),G1tensor(260),G1tensor(246)])
  call ol_merge_tensors(G2tensor(694),[G2tensor(691),G2tensor(682),G2tensor(679),G2tensor(345),G2tensor(341),G2tensor(100) &
    ,G2tensor(96),G2tensor(36),G2tensor(33),G1tensor(708),G1tensor(702),G1tensor(564),G1tensor(552),G1tensor(288),G1tensor(264)])
  call ol_merge_tensors(G2tensor(202),[G2tensor(192),G2tensor(35),G1tensor(627),G1tensor(284),G1tensor(270)])
  call ol_merge_tensors(G2tensor(523),[G2tensor(469),G2tensor(40),G2tensor(38),G1tensor(689),G1tensor(659),G1tensor(126) &
    ,G1tensor(78)])
  call ol_merge_tensors(G2tensor(535),[G2tensor(466),G2tensor(44),G2tensor(42),G1tensor(701),G1tensor(653),G1tensor(186) &
    ,G1tensor(156)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(46),G1tensor(557),G1tensor(210)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(48),G1tensor(545),G1tensor(234)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(50),G1tensor(563),G1tensor(258)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(52),G1tensor(551),G1tensor(282)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(110),G2tensor(54),G1tensor(531),G1tensor(302),G1tensor(31)])
  call ol_merge_tensors(G2tensor(402),[G2tensor(113),G2tensor(56),G1tensor(555),G1tensor(326),G1tensor(67)])
  call ol_merge_tensors(G2tensor(396),[G2tensor(116),G2tensor(58),G1tensor(519),G1tensor(344),G1tensor(103)])
  call ol_merge_tensors(G2tensor(400),[G2tensor(119),G2tensor(60),G1tensor(543),G1tensor(368),G1tensor(62)])
  call ol_merge_tensors(G2tensor(616),[G2tensor(66),G2tensor(62),G1tensor(657),G1tensor(108),G1tensor(59)])
  call ol_merge_tensors(G2tensor(619),[G2tensor(68),G2tensor(64),G1tensor(658),G1tensor(120),G1tensor(70)])
  call ol_merge_tensors(G2tensor(610),[G2tensor(74),G2tensor(70),G1tensor(651),G1tensor(174),G1tensor(144)])
  call ol_merge_tensors(G2tensor(613),[G2tensor(76),G2tensor(72),G1tensor(652),G1tensor(180),G1tensor(150)])
  call ol_merge_tensors(G2tensor(646),[G2tensor(441),G2tensor(325),G2tensor(78),G1tensor(678),G1tensor(562),G1tensor(556) &
    ,G1tensor(204)])
  call ol_merge_tensors(G2tensor(643),[G2tensor(439),G2tensor(317),G2tensor(80),G1tensor(666),G1tensor(550),G1tensor(544) &
    ,G1tensor(228)])
  call ol_merge_tensors(G2tensor(403),[G2tensor(82),G1tensor(561),G1tensor(252)])
  call ol_merge_tensors(G2tensor(401),[G2tensor(84),G1tensor(549),G1tensor(276)])
  call ol_merge_tensors(G2tensor(676),[G2tensor(673),G2tensor(664),G2tensor(661),G2tensor(329),G2tensor(90),G2tensor(86) &
    ,G1tensor(684),G1tensor(534),G1tensor(522)])
  call ol_merge_tensors(G2tensor(670),[G2tensor(667),G2tensor(658),G2tensor(655),G2tensor(321),G2tensor(92),G2tensor(88) &
    ,G1tensor(672),G1tensor(540),G1tensor(528)])
  call ol_merge_tensors(G2tensor(450),[G2tensor(102),G1tensor(570)])
  call ol_merge_tensors(G2tensor(595),[G2tensor(448),G2tensor(234),G2tensor(104),G1tensor(635),G1tensor(629),G1tensor(576) &
    ,G1tensor(402)])
  call ol_merge_tensors(G2tensor(589),[G2tensor(454),G2tensor(258),G2tensor(108),G1tensor(611),G1tensor(605),G1tensor(588) &
    ,G1tensor(474)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(132),G2tensor(111),G1tensor(630),G1tensor(408),G1tensor(306)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(156),G2tensor(114),G1tensor(606),G1tensor(480),G1tensor(330)])
  call ol_merge_tensors(G2tensor(294),[G2tensor(144),G2tensor(117),G1tensor(636),G1tensor(432),G1tensor(348)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(168),G2tensor(120),G1tensor(612),G1tensor(516),G1tensor(372)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(122),G1tensor(620),G1tensor(33)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(123),G1tensor(386),G1tensor(92)])
  call ol_merge_tensors(G2tensor(288),[G2tensor(126),G1tensor(624),G1tensor(390)])
  call ol_merge_tensors(G2tensor(290),[G2tensor(128),G1tensor(626),G1tensor(104)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(129),G1tensor(404),G1tensor(3)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(134),G1tensor(614),G1tensor(5)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(135),G1tensor(416),G1tensor(9)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(138),G1tensor(618),G1tensor(420)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(140),G1tensor(632),G1tensor(11)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(141),G1tensor(428),G1tensor(16)])
  call ol_merge_tensors(G2tensor(395),[G2tensor(275),G2tensor(146),G1tensor(596),G1tensor(177),G1tensor(171),G1tensor(18)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(147),G1tensor(452),G1tensor(22)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(150),G1tensor(600),G1tensor(456)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(278),G2tensor(152),G1tensor(602),G1tensor(65),G1tensor(54),G1tensor(24)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(153),G1tensor(476),G1tensor(28)])
  call ol_merge_tensors(G2tensor(394),[G2tensor(272),G2tensor(158),G1tensor(590),G1tensor(147),G1tensor(141),G1tensor(30)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(159),G1tensor(494),G1tensor(34)])
  call ol_merge_tensors(G2tensor(273),[G2tensor(162),G1tensor(594),G1tensor(498)])
  call ol_merge_tensors(G2tensor(393),[G2tensor(281),G2tensor(164),G1tensor(608),G1tensor(114),G1tensor(106),G1tensor(36)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(165),G1tensor(512),G1tensor(41)])
  call ol_merge_tensors(G2tensor(424),[G2tensor(308),G2tensor(173),G2tensor(170),G1tensor(656),G1tensor(96),G1tensor(81) &
    ,G1tensor(85)])
  call ol_merge_tensors(G2tensor(421),[G2tensor(304),G2tensor(179),G2tensor(176),G1tensor(650),G1tensor(164),G1tensor(134) &
    ,G1tensor(13)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(182),G1tensor(554),G1tensor(194),G1tensor(74)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(185),G1tensor(542),G1tensor(218),G1tensor(12)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(188),G1tensor(560),G1tensor(242),G1tensor(6)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(191),G1tensor(548),G1tensor(266),G1tensor(110)])
  call ol_merge_tensors(G2tensor(390),[G2tensor(194),G1tensor(290),G1tensor(19)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(195),G1tensor(318),G1tensor(294)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(197),G1tensor(296),G1tensor(25)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(300)])
  call ol_merge_tensors(G2tensor(427),[G2tensor(200),G1tensor(308),G1tensor(249),G1tensor(201),G1tensor(49)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(312)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(203),G1tensor(314),G1tensor(207),G1tensor(55)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(206),G1tensor(320),G1tensor(213),G1tensor(61)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(324)])
  call ol_merge_tensors(G2tensor(391),[G2tensor(209),G1tensor(332),G1tensor(91)])
  call ol_merge_tensors(G2tensor(210),[G1tensor(336)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(212),G1tensor(338),G1tensor(97)])
  call ol_merge_tensors(G2tensor(213),[G1tensor(342)])
  call ol_merge_tensors(G2tensor(428),[G2tensor(215),G1tensor(350),G1tensor(273),G1tensor(225),G1tensor(50)])
  call ol_merge_tensors(G2tensor(216),[G1tensor(354)])
  call ol_merge_tensors(G2tensor(387),[G2tensor(218),G1tensor(356),G1tensor(231),G1tensor(56)])
  call ol_merge_tensors(G2tensor(219),[G1tensor(360)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(221),G1tensor(362),G1tensor(237),G1tensor(27)])
  call ol_merge_tensors(G2tensor(222),[G1tensor(366)])
  call ol_merge_tensors(G2tensor(247),[G2tensor(224),G1tensor(374),G1tensor(80)])
  call ol_merge_tensors(G2tensor(319),[G2tensor(225),G1tensor(622),G1tensor(378)])
  call ol_merge_tensors(G2tensor(472),[G2tensor(227),G1tensor(380),G1tensor(8),G1tensor(86)])
  call ol_merge_tensors(G2tensor(592),[G2tensor(446),G2tensor(228),G1tensor(623),G1tensor(617),G1tensor(384)])
  call ol_merge_tensors(G2tensor(250),[G2tensor(230),G1tensor(392),G1tensor(116)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(231),G1tensor(628),G1tensor(396)])
  call ol_merge_tensors(G2tensor(478),[G2tensor(233),G1tensor(398),G1tensor(15),G1tensor(2)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(236),G1tensor(410),G1tensor(63)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(237),G1tensor(616),G1tensor(414)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(239),G1tensor(422),G1tensor(14)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(240),G1tensor(634),G1tensor(426)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(242),G1tensor(530),G1tensor(434),G1tensor(51)])
  call ol_merge_tensors(G2tensor(289),[G2tensor(243),G1tensor(597),G1tensor(438)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(245),G1tensor(440),G1tensor(20)])
  call ol_merge_tensors(G2tensor(292),[G2tensor(246),G1tensor(598),G1tensor(444)])
  call ol_merge_tensors(G2tensor(484),[G2tensor(248),G1tensor(446),G1tensor(46),G1tensor(21)])
  call ol_merge_tensors(G2tensor(586),[G2tensor(452),G2tensor(249),G1tensor(599),G1tensor(593),G1tensor(450)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(251),G1tensor(524),G1tensor(458),G1tensor(75)])
  call ol_merge_tensors(G2tensor(295),[G2tensor(252),G1tensor(603),G1tensor(462)])
  call ol_merge_tensors(G2tensor(268),[G2tensor(254),G1tensor(464),G1tensor(26)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(255),G1tensor(604),G1tensor(468)])
  call ol_merge_tensors(G2tensor(490),[G2tensor(257),G1tensor(470),G1tensor(39),G1tensor(40)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(260),G1tensor(536),G1tensor(482),G1tensor(93)])
  call ol_merge_tensors(G2tensor(283),[G2tensor(261),G1tensor(591),G1tensor(486)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(263),G1tensor(488),G1tensor(32)])
  call ol_merge_tensors(G2tensor(286),[G2tensor(264),G1tensor(592),G1tensor(492)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(266),G1tensor(518),G1tensor(500),G1tensor(87)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(267),G1tensor(609),G1tensor(504)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(269),G1tensor(506),G1tensor(38)])
  call ol_merge_tensors(G2tensor(307),[G2tensor(270),G1tensor(610),G1tensor(510)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(296),G1tensor(638)])
  call ol_merge_tensors(G2tensor(637),[G2tensor(631),G2tensor(301),G2tensor(297),G1tensor(700),G1tensor(688),G1tensor(648) &
    ,G1tensor(642)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(300),G1tensor(644),G1tensor(573)])
  call ol_merge_tensors(G2tensor(502),[G2tensor(316),G1tensor(662)])
  call ol_merge_tensors(G2tensor(508),[G2tensor(320),G1tensor(668)])
  call ol_merge_tensors(G2tensor(511),[G2tensor(324),G1tensor(674)])
  call ol_merge_tensors(G2tensor(517),[G2tensor(328),G1tensor(680)])
  call ol_merge_tensors(G2tensor(520),[G2tensor(332),G1tensor(693),G1tensor(686)])
  call ol_merge_tensors(G2tensor(526),[G2tensor(336),G1tensor(692)])
  call ol_merge_tensors(G2tensor(649),[G2tensor(435),G2tensor(337),G1tensor(696),G1tensor(526),G1tensor(520)])
  call ol_merge_tensors(G2tensor(532),[G2tensor(340),G1tensor(711),G1tensor(698)])
  call ol_merge_tensors(G2tensor(538),[G2tensor(344),G1tensor(704)])
  call ol_merge_tensors(G2tensor(541),[G2tensor(348),G1tensor(710)])
  call ol_merge_tensors(G2tensor(652),[G2tensor(437),G2tensor(349),G1tensor(714),G1tensor(538),G1tensor(532)])
  call ol_merge_tensors(G2tensor(547),[G2tensor(352),G1tensor(716)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(441),G1tensor(435),G1tensor(7)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(375),G1tensor(195),G1tensor(43)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(507),G1tensor(501),G1tensor(79)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(423),G1tensor(219),G1tensor(115)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(53),G1tensor(44)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(64),G1tensor(45)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(72),G1tensor(47)])
  call ol_merge_tensors(G2tensor(380),[G1tensor(76),G1tensor(57)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(83),G1tensor(58)])
  call ol_merge_tensors(G2tensor(601),[G2tensor(381),G1tensor(640),G1tensor(154),G1tensor(148),G1tensor(89),G1tensor(66)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(84),G1tensor(69)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(215),G1tensor(209),G1tensor(88),G1tensor(77)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(333),G1tensor(105),G1tensor(99)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(339),G1tensor(112),G1tensor(100)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(345),G1tensor(122),G1tensor(113)])
  call ol_merge_tensors(G2tensor(382),[G1tensor(123),G1tensor(119)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(129),G1tensor(107)])
  call ol_merge_tensors(G2tensor(607),[G2tensor(383),G1tensor(646),G1tensor(184),G1tensor(178),G1tensor(124),G1tensor(117)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(130),G1tensor(118)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(239),G1tensor(233),G1tensor(131),G1tensor(125)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(140),G1tensor(135)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(146),G1tensor(136)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(152),G1tensor(137)])
  call ol_merge_tensors(G2tensor(384),[G1tensor(153),G1tensor(142)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(159),G1tensor(143)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(160),G1tensor(149)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(263),G1tensor(257),G1tensor(161),G1tensor(155)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(291),G1tensor(170),G1tensor(165)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(297),G1tensor(176),G1tensor(166)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(303),G1tensor(182),G1tensor(167)])
  call ol_merge_tensors(G2tensor(385),[G1tensor(183),G1tensor(172)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(189),G1tensor(173)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(190),G1tensor(179)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(287),G1tensor(281),G1tensor(191),G1tensor(185)])
  call ol_merge_tensors(G2tensor(496),[G1tensor(381),G1tensor(244),G1tensor(200),G1tensor(196)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(387),G1tensor(206),G1tensor(197)])
  call ol_merge_tensors(G2tensor(415),[G1tensor(574),G1tensor(256),G1tensor(208),G1tensor(202)])
  call ol_merge_tensors(G2tensor(460),[G2tensor(7),G1tensor(641),G1tensor(262),G1tensor(214),G1tensor(203)])
  call ol_merge_tensors(G2tensor(499),[G1tensor(399),G1tensor(268),G1tensor(224),G1tensor(220)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(429),G1tensor(230),G1tensor(221)])
  call ol_merge_tensors(G2tensor(416),[G1tensor(280),G1tensor(232),G1tensor(226)])
  call ol_merge_tensors(G2tensor(463),[G2tensor(75),G1tensor(647),G1tensor(286),G1tensor(238),G1tensor(227)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(411),G1tensor(248),G1tensor(243)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(417),G1tensor(254),G1tensor(245)])
  call ol_merge_tensors(G2tensor(388),[G1tensor(255),G1tensor(250)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(261),G1tensor(251)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(393),G1tensor(272),G1tensor(267)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(405),G1tensor(278),G1tensor(269)])
  call ol_merge_tensors(G2tensor(389),[G1tensor(279),G1tensor(274)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(285),G1tensor(275)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(298),G1tensor(292)])
  call ol_merge_tensors(G2tensor(235),[G1tensor(304),G1tensor(293)])
  call ol_merge_tensors(G2tensor(562),[G2tensor(211),G1tensor(575),G1tensor(569),G1tensor(347),G1tensor(341),G1tensor(305) &
    ,G1tensor(299)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(315),G1tensor(309)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(321),G1tensor(310)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(327),G1tensor(311)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(322),G1tensor(316)])
  call ol_merge_tensors(G2tensor(238),[G1tensor(328),G1tensor(317)])
  call ol_merge_tensors(G2tensor(565),[G2tensor(223),G1tensor(587),G1tensor(581),G1tensor(371),G1tensor(365),G1tensor(329) &
    ,G1tensor(323)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(340),G1tensor(334)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(346),G1tensor(335)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(357),G1tensor(351)])
  call ol_merge_tensors(G2tensor(271),[G1tensor(363),G1tensor(352)])
  call ol_merge_tensors(G2tensor(241),[G1tensor(369),G1tensor(353)])
  call ol_merge_tensors(G2tensor(274),[G1tensor(364),G1tensor(358)])
  call ol_merge_tensors(G2tensor(244),[G1tensor(370),G1tensor(359)])
  call ol_merge_tensors(G2tensor(568),[G1tensor(664),G1tensor(412),G1tensor(382),G1tensor(376)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(454),G1tensor(443),G1tensor(388),G1tensor(377)])
  call ol_merge_tensors(G2tensor(475),[G1tensor(683),G1tensor(419),G1tensor(389),G1tensor(383)])
  call ol_merge_tensors(G2tensor(571),[G1tensor(676),G1tensor(424),G1tensor(400),G1tensor(394)])
  call ol_merge_tensors(G2tensor(253),[G1tensor(478),G1tensor(467),G1tensor(406),G1tensor(395)])
  call ol_merge_tensors(G2tensor(481),[G1tensor(671),G1tensor(431),G1tensor(407),G1tensor(401)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(154),G1tensor(514),G1tensor(509),G1tensor(418),G1tensor(413)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(262),G1tensor(496),G1tensor(491),G1tensor(430),G1tensor(425)])
  call ol_merge_tensors(G2tensor(574),[G1tensor(484),G1tensor(447),G1tensor(436)])
  call ol_merge_tensors(G2tensor(265),[G1tensor(453),G1tensor(437)])
  call ol_merge_tensors(G2tensor(577),[G1tensor(694),G1tensor(490),G1tensor(448),G1tensor(442)])
  call ol_merge_tensors(G2tensor(487),[G1tensor(719),G1tensor(497),G1tensor(455),G1tensor(449)])
  call ol_merge_tensors(G2tensor(277),[G1tensor(465),G1tensor(459)])
  call ol_merge_tensors(G2tensor(580),[G1tensor(502),G1tensor(471),G1tensor(460)])
  call ol_merge_tensors(G2tensor(166),[G1tensor(477),G1tensor(461)])
  call ol_merge_tensors(G2tensor(583),[G1tensor(712),G1tensor(508),G1tensor(472),G1tensor(466)])
  call ol_merge_tensors(G2tensor(493),[G1tensor(707),G1tensor(515),G1tensor(479),G1tensor(473)])
  call ol_merge_tensors(G2tensor(280),[G1tensor(489),G1tensor(483)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(495),G1tensor(485)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(513),G1tensor(503)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(521)])
  call ol_merge_tensors(G2tensor(397),[G1tensor(525)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(527)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(533)])
  call ol_merge_tensors(G2tensor(399),[G1tensor(537)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(539)])
  call ol_merge_tensors(G2tensor(550),[G1tensor(566)])
  call ol_merge_tensors(G2tensor(443),[G1tensor(567)])
  call ol_merge_tensors(G2tensor(420),[G1tensor(568)])
  call ol_merge_tensors(G2tensor(553),[G1tensor(681),G1tensor(572)])
  call ol_merge_tensors(G2tensor(556),[G1tensor(687),G1tensor(578)])
  call ol_merge_tensors(G2tensor(444),[G1tensor(579)])
  call ol_merge_tensors(G2tensor(423),[G1tensor(580)])
  call ol_merge_tensors(G2tensor(559),[G1tensor(717),G1tensor(584)])
  call ol_merge_tensors(G2tensor(445),[G1tensor(585)])
  call ol_merge_tensors(G2tensor(426),[G1tensor(586)])
  call ol_merge_tensors(G2tensor(598),[G1tensor(639)])
  call ol_merge_tensors(G2tensor(604),[G1tensor(645)])
  call ol_merge_tensors(G2tensor(622),[G1tensor(663)])
  call ol_merge_tensors(G2tensor(514),[G2tensor(505),G1tensor(718),G1tensor(706),G1tensor(677),G1tensor(665)])
  call ol_merge_tensors(G2tensor(625),[G1tensor(669)])
  call ol_merge_tensors(G2tensor(544),[G2tensor(529),G1tensor(713),G1tensor(695),G1tensor(682),G1tensor(670)])
  call ol_merge_tensors(G2tensor(628),[G1tensor(675)])
  call ol_merge_tensors(G2tensor(634),[G1tensor(699)])
  call ol_merge_tensors(G2tensor(640),[G1tensor(705)])
  call ol_merge_tensors(G2tensor(430),[G2tensor(429)])
  call ol_merge_tensors(G2tensor(432),[G2tensor(431)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(433)])
  call Hotf_4pt_reduction_last(G2tensor(171),RedSet_4(279),mass4set(:,1),  & 
G1tensor(1),G1tensor(37),G1tensor(73),G1tensor(109),G1tensor(68))
  call G_TensorShift(G1tensor(37),5)
  call Hotf_4pt_reduction_last(G2tensor(456),RedSet_4(13),mass4set(:,1),  & 
G1tensor(98),G1tensor(4),G1tensor(10),G1tensor(17),G1tensor(23))
  call G_TensorShift(G1tensor(4),13)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(123),mass4set(:,1),  & 
G1tensor(29),G1tensor(35),G1tensor(42),G1tensor(52),G1tensor(60))
  call G_TensorShift(G1tensor(35),9)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(283),mass4set(:,1),  & 
G1tensor(71),G1tensor(82),G1tensor(94),G1tensor(102),G1tensor(111))
  call G_TensorShift(G1tensor(82),6)
  call Hotf_4pt_reduction_last(G2tensor(458),RedSet_4(37),mass4set(:,1),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),14)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(96),mass4set(:,1),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),10)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(149),mass4set(:,1),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),20)
  call Hotf_4pt_reduction_last(G2tensor(700),RedSet_4(60),mass4set(:,1),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),28)
  call Hotf_4pt_reduction_last(G2tensor(205),RedSet_4(184),mass4set(:,1),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),24)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(175),mass4set(:,1),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),20)
  call Hotf_4pt_reduction_last(G2tensor(694),RedSet_4(82),mass4set(:,1),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),28)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(163),mass4set(:,1),  & 
G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(337),24)
  call Hotf_4pt_reduction_last(G2tensor(523),RedSet_4(11),mass4set(:,1),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385))
  call G_TensorShift(G1tensor(367),12)
  call Hotf_4pt_reduction_last(G2tensor(535),RedSet_4(35),mass4set(:,1),  & 
G1tensor(391),G1tensor(397),G1tensor(403),G1tensor(409),G1tensor(415))
  call G_TensorShift(G1tensor(397),12)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(58),mass4set(:,1),  & 
G1tensor(421),G1tensor(427),G1tensor(433),G1tensor(439),G1tensor(445))
  call G_TensorShift(G1tensor(427),24)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(72),mass4set(:,1),  & 
G1tensor(451),G1tensor(457),G1tensor(463),G1tensor(469),G1tensor(475))
  call G_TensorShift(G1tensor(457),20)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(80),mass4set(:,1),  & 
G1tensor(481),G1tensor(487),G1tensor(493),G1tensor(499),G1tensor(505))
  call G_TensorShift(G1tensor(487),24)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(89),mass4set(:,1),  & 
G1tensor(511),G1tensor(517),G1tensor(523),G1tensor(529),G1tensor(535))
  call G_TensorShift(G1tensor(517),20)
  call Hotf_4pt_reduction_last(G2tensor(398),RedSet_4(243),mass4set(:,1),  & 
G1tensor(541),G1tensor(547),G1tensor(553),G1tensor(559),G1tensor(565))
  call G_TensorShift(G1tensor(547),18)
  call Hotf_4pt_reduction_last(G2tensor(402),RedSet_4(52),mass4set(:,1),  & 
G1tensor(571),G1tensor(577),G1tensor(583),G1tensor(589),G1tensor(595))
  call G_TensorShift(G1tensor(577),24)
  call Hotf_4pt_reduction_last(G2tensor(396),RedSet_4(247),mass4set(:,1),  & 
G1tensor(601),G1tensor(607),G1tensor(613),G1tensor(619),G1tensor(625))
  call G_TensorShift(G1tensor(607),17)
  call Hotf_4pt_reduction_last(G2tensor(400),RedSet_4(66),mass4set(:,1),  & 
G1tensor(631),G1tensor(637),G1tensor(643),G1tensor(649),G1tensor(655))
  call G_TensorShift(G1tensor(637),20)
  call Hotf_4pt_reduction_last(G2tensor(616),RedSet_4(4),mass4set(:,1),  & 
G1tensor(661),G1tensor(667),G1tensor(673),G1tensor(679),G1tensor(685))
  call G_TensorShift(G1tensor(667),12)
  call Hotf_4pt_reduction_last(G2tensor(619),RedSet_4(8),mass4set(:,1),  & 
G1tensor(691),G1tensor(697),G1tensor(703),G1tensor(709),G1tensor(715))
  call G_TensorShift(G1tensor(697),12)
  call Hotf_4pt_reduction_last(G2tensor(610),RedSet_4(29),mass4set(:,1),  & 
G1tensor(95),G1tensor(48),G1tensor(660),G1tensor(132),G1tensor(90))
  call G_TensorShift(G1tensor(48),12)
  call Hotf_4pt_reduction_last(G2tensor(613),RedSet_4(32),mass4set(:,1),  & 
G1tensor(128),G1tensor(101),G1tensor(158),G1tensor(138),G1tensor(654))
  call G_TensorShift(G1tensor(101),12)
  call Hotf_4pt_reduction_last(G2tensor(646),RedSet_4(56),mass4set(:,1),  & 
G1tensor(582),G1tensor(192),G1tensor(162),G1tensor(188),G1tensor(168))
  call G_TensorShift(G1tensor(192),24)
  call Hotf_4pt_reduction_last(G2tensor(643),RedSet_4(70),mass4set(:,1),  & 
G1tensor(621),G1tensor(212),G1tensor(198),G1tensor(720),G1tensor(690))
  call G_TensorShift(G1tensor(212),20)
  call Hotf_4pt_reduction_last(G2tensor(403),RedSet_4(78),mass4set(:,1),  & 
G1tensor(558),G1tensor(546),G1tensor(240),G1tensor(216),G1tensor(633))
  call G_TensorShift(G1tensor(546),24)
  call Hotf_4pt_reduction_last(G2tensor(401),RedSet_4(87),mass4set(:,1),  & 
G1tensor(236),G1tensor(222),G1tensor(615),G1tensor(260),G1tensor(246))
  call G_TensorShift(G1tensor(222),20)
  call Hotf_4pt_reduction_last(G2tensor(676),RedSet_4(237),mass4set(:,1),  & 
G1tensor(708),G1tensor(702),G1tensor(564),G1tensor(552),G1tensor(288))
  call G_TensorShift(G1tensor(702),19)
  call Hotf_4pt_reduction_last(G2tensor(670),RedSet_4(236),mass4set(:,1),  & 
G1tensor(264),G1tensor(627),G1tensor(284),G1tensor(270),G1tensor(689))
  call G_TensorShift(G1tensor(627),19)
  call Hotf_4pt_reduction_last(G2tensor(450),RedSet_4(234),mass4set(:,1),  & 
G1tensor(659),G1tensor(126),G1tensor(78),G1tensor(701),G1tensor(653))
  call G_TensorShift(G1tensor(126),11)
  call Hotf_4pt_reduction_last(G2tensor(595),RedSet_4(169),mass4set(:,1),  & 
G1tensor(186),G1tensor(156),G1tensor(557),G1tensor(210),G1tensor(545))
  call G_TensorShift(G1tensor(156),24)
  call Hotf_4pt_reduction_last(G2tensor(589),RedSet_4(213),mass4set(:,1),  & 
G1tensor(234),G1tensor(563),G1tensor(258),G1tensor(551),G1tensor(282))
  call G_TensorShift(G1tensor(563),18)
  call Hotf_4pt_reduction_last(G2tensor(291),RedSet_4(104),mass4set(:,1),  & 
G1tensor(531),G1tensor(302),G1tensor(31),G1tensor(555),G1tensor(326))
  call G_TensorShift(G1tensor(302),26)
  call Hotf_4pt_reduction_last(G2tensor(279),RedSet_4(118),mass4set(:,1),  & 
G1tensor(67),G1tensor(519),G1tensor(344),G1tensor(103),G1tensor(543))
  call G_TensorShift(G1tensor(519),26)
  call Hotf_4pt_reduction_last(G2tensor(294),RedSet_4(130),mass4set(:,1),  & 
G1tensor(368),G1tensor(62),G1tensor(657),G1tensor(108),G1tensor(59))
  call G_TensorShift(G1tensor(62),25)
  call Hotf_4pt_reduction_last(G2tensor(282),RedSet_4(144),mass4set(:,1),  & 
G1tensor(658),G1tensor(120),G1tensor(70),G1tensor(651),G1tensor(174))
  call G_TensorShift(G1tensor(120),22)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(337),mass4set(:,1),  & 
G1tensor(144),G1tensor(652),G1tensor(180),G1tensor(150),G1tensor(678))
  call G_TensorShift(G1tensor(652),1)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(251),mass4set(:,1),  & 
G1tensor(562),G1tensor(556),G1tensor(204),G1tensor(666),G1tensor(550))
  call G_TensorShift(G1tensor(556),5)
  call Hotf_4pt_reduction_last(G2tensor(288),RedSet_4(157),mass4set(:,1),  & 
G1tensor(544),G1tensor(228),G1tensor(561),G1tensor(252),G1tensor(549))
  call G_TensorShift(G1tensor(228),21)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(338),mass4set(:,1),  & 
G1tensor(276),G1tensor(684),G1tensor(534),G1tensor(522),G1tensor(672))
  call G_TensorShift(G1tensor(684),2)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(255),mass4set(:,1),  & 
G1tensor(540),G1tensor(528),G1tensor(570),G1tensor(635),G1tensor(629))
  call G_TensorShift(G1tensor(528),10)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(339),mass4set(:,1),  & 
G1tensor(576),G1tensor(402),G1tensor(611),G1tensor(605),G1tensor(588))
  call G_TensorShift(G1tensor(402),2)
  call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(258),mass4set(:,1),  & 
G1tensor(474),G1tensor(630),G1tensor(408),G1tensor(306),G1tensor(606))
  call G_TensorShift(G1tensor(630),6)
  call Hotf_4pt_reduction_last(G2tensor(285),RedSet_4(179),mass4set(:,1),  & 
G1tensor(480),G1tensor(330),G1tensor(636),G1tensor(432),G1tensor(348))
  call G_TensorShift(G1tensor(330),22)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(340),mass4set(:,1),  & 
G1tensor(612),G1tensor(516),G1tensor(372),G1tensor(620),G1tensor(33))
  call G_TensorShift(G1tensor(516),1)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(261),mass4set(:,1),  & 
G1tensor(386),G1tensor(92),G1tensor(624),G1tensor(390),G1tensor(626))
  call G_TensorShift(G1tensor(92),9)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(40),mass4set(:,1),  & 
G1tensor(104),G1tensor(404),G1tensor(3),G1tensor(614),G1tensor(5))
  call G_TensorShift(G1tensor(404),4)
  call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(265),mass4set(:,1),  & 
G1tensor(416),G1tensor(9),G1tensor(618),G1tensor(420),G1tensor(632))
  call G_TensorShift(G1tensor(9),5)
  call Hotf_4pt_reduction_last(G2tensor(276),RedSet_4(201),mass4set(:,1),  & 
G1tensor(11),G1tensor(428),G1tensor(16),G1tensor(596),G1tensor(177))
  call G_TensorShift(G1tensor(428),21)
  call Hotf_4pt_reduction_last(G2tensor(392),RedSet_4(1),mass4set(:,1),  & 
G1tensor(171),G1tensor(18),G1tensor(452),G1tensor(22),G1tensor(600))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(269),mass4set(:,1),  & 
G1tensor(456),G1tensor(602),G1tensor(65),G1tensor(54),G1tensor(24))
  call G_TensorShift(G1tensor(602),10)
  call Hotf_4pt_reduction_last(G2tensor(394),RedSet_4(26),mass4set(:,1),  & 
G1tensor(476),G1tensor(28),G1tensor(590),G1tensor(147),G1tensor(141))
  call G_TensorShift(G1tensor(28),8)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(272),mass4set(:,1),  & 
G1tensor(30),G1tensor(494),G1tensor(34),G1tensor(594),G1tensor(498))
  call G_TensorShift(G1tensor(494),9)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(223),mass4set(:,1),  & 
G1tensor(608),G1tensor(114),G1tensor(106),G1tensor(36),G1tensor(512))
  call G_TensorShift(G1tensor(114),25)
  call Hotf_4pt_reduction_last(G2tensor(393),RedSet_4(16),mass4set(:,1),  & 
G1tensor(41),G1tensor(656),G1tensor(96),G1tensor(81),G1tensor(85))
  call G_TensorShift(G1tensor(656),4)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(275),mass4set(:,1),  & 
G1tensor(650),G1tensor(164),G1tensor(134),G1tensor(13),G1tensor(554))
  call G_TensorShift(G1tensor(164),6)
  call Hotf_4pt_reduction_last(G2tensor(424),RedSet_4(244),mass4set(:,1),  & 
G1tensor(194),G1tensor(74),G1tensor(542),G1tensor(218),G1tensor(12))
  call G_TensorShift(G1tensor(74),1)
  call Hotf_4pt_reduction_last(G2tensor(421),RedSet_4(240),mass4set(:,1),  & 
G1tensor(560),G1tensor(242),G1tensor(6),G1tensor(548),G1tensor(266))
  call G_TensorShift(G1tensor(242),2)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(248),mass4set(:,1),  & 
G1tensor(110),G1tensor(290),G1tensor(19),G1tensor(318),G1tensor(294))
  call G_TensorShift(G1tensor(290),4)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(259),mass4set(:,1),  & 
G1tensor(296),G1tensor(25),G1tensor(300),G1tensor(308),G1tensor(249))
  call G_TensorShift(G1tensor(25),8)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(256),mass4set(:,1),  & 
G1tensor(201),G1tensor(49),G1tensor(312),G1tensor(314),G1tensor(207))
  call G_TensorShift(G1tensor(49),4)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(252),mass4set(:,1),  & 
G1tensor(55),G1tensor(320),G1tensor(213),G1tensor(61),G1tensor(324))
  call G_TensorShift(G1tensor(320),8)
  call Hotf_4pt_reduction_last(G2tensor(390),RedSet_4(241),mass4set(:,1),  & 
G1tensor(332),G1tensor(91),G1tensor(336),G1tensor(338),G1tensor(97))
  call G_TensorShift(G1tensor(91),2)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(99),mass4set(:,1),  & 
G1tensor(342),G1tensor(350),G1tensor(273),G1tensor(225),G1tensor(50))
  call G_TensorShift(G1tensor(350),10)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(242),mass4set(:,1),  & 
G1tensor(354),G1tensor(356),G1tensor(231),G1tensor(56),G1tensor(360))
  call G_TensorShift(G1tensor(356),2)
  call Hotf_4pt_reduction_last(G2tensor(198),RedSet_4(102),mass4set(:,1),  & 
G1tensor(362),G1tensor(237),G1tensor(27),G1tensor(366),G1tensor(374))
  call G_TensorShift(G1tensor(237),10)
  call Hotf_4pt_reduction_last(G2tensor(427),RedSet_4(49),mass4set(:,1),  & 
G1tensor(80),G1tensor(622),G1tensor(378),G1tensor(380),G1tensor(8))
  call G_TensorShift(G1tensor(622),8)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(110),mass4set(:,1),  & 
G1tensor(86),G1tensor(623),G1tensor(617),G1tensor(384),G1tensor(392))
  call G_TensorShift(G1tensor(623),10)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(50),mass4set(:,1),  & 
G1tensor(116),G1tensor(628),G1tensor(396),G1tensor(398),G1tensor(15))
  call G_TensorShift(G1tensor(628),8)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(51),mass4set(:,1),  & 
G1tensor(2),G1tensor(410),G1tensor(63),G1tensor(616),G1tensor(414))
  call G_TensorShift(G1tensor(410),8)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(116),mass4set(:,1),  & 
G1tensor(422),G1tensor(14),G1tensor(634),G1tensor(426),G1tensor(530))
  call G_TensorShift(G1tensor(14),10)
  call Hotf_4pt_reduction_last(G2tensor(391),RedSet_4(245),mass4set(:,1),  & 
G1tensor(434),G1tensor(51),G1tensor(597),G1tensor(438),G1tensor(440))
  call G_TensorShift(G1tensor(51),1)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(126),mass4set(:,1),  & 
G1tensor(20),G1tensor(598),G1tensor(444),G1tensor(446),G1tensor(46))
  call G_TensorShift(G1tensor(598),9)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(246),mass4set(:,1),  & 
G1tensor(21),G1tensor(599),G1tensor(593),G1tensor(450),G1tensor(524))
  call G_TensorShift(G1tensor(599),1)
  call Hotf_4pt_reduction_last(G2tensor(213),RedSet_4(128),mass4set(:,1),  & 
G1tensor(458),G1tensor(75),G1tensor(603),G1tensor(462),G1tensor(464))
  call G_TensorShift(G1tensor(75),9)
  call Hotf_4pt_reduction_last(G2tensor(428),RedSet_4(63),mass4set(:,1),  & 
G1tensor(26),G1tensor(604),G1tensor(468),G1tensor(470),G1tensor(39))
  call G_TensorShift(G1tensor(604),4)
  call Hotf_4pt_reduction_last(G2tensor(216),RedSet_4(136),mass4set(:,1),  & 
G1tensor(40),G1tensor(536),G1tensor(482),G1tensor(93),G1tensor(591))
  call G_TensorShift(G1tensor(536),6)
  call Hotf_4pt_reduction_last(G2tensor(387),RedSet_4(64),mass4set(:,1),  & 
G1tensor(486),G1tensor(488),G1tensor(32),G1tensor(592),G1tensor(492))
  call G_TensorShift(G1tensor(488),4)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(140),mass4set(:,1),  & 
G1tensor(518),G1tensor(500),G1tensor(87),G1tensor(609),G1tensor(504))
  call G_TensorShift(G1tensor(500),6)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(65),mass4set(:,1),  & 
G1tensor(506),G1tensor(38),G1tensor(610),G1tensor(510),G1tensor(638))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(142),mass4set(:,1),  & 
G1tensor(700),G1tensor(688),G1tensor(648),G1tensor(642),G1tensor(644))
  call G_TensorShift(G1tensor(688),6)
  call Hotf_4pt_reduction_last(G2tensor(247),RedSet_4(249),mass4set(:,1),  & 
G1tensor(573),G1tensor(662),G1tensor(668),G1tensor(674),G1tensor(680))
  call G_TensorShift(G1tensor(662),4)
  call Hotf_4pt_reduction_last(G2tensor(319),RedSet_4(152),mass4set(:,1),  & 
G1tensor(693),G1tensor(686),G1tensor(692),G1tensor(696),G1tensor(526))
  call G_TensorShift(G1tensor(686),20)
  call Hotf_4pt_reduction_last(G2tensor(472),RedSet_4(250),mass4set(:,1),  & 
G1tensor(520),G1tensor(711),G1tensor(698),G1tensor(704),G1tensor(710))
  call G_TensorShift(G1tensor(711),4)
  call Hotf_4pt_reduction_last(G2tensor(592),RedSet_4(155),mass4set(:,1),  & 
G1tensor(714),G1tensor(538),G1tensor(532),G1tensor(716),G1tensor(441))
  call G_TensorShift(G1tensor(538),20)
  call Hotf_4pt_reduction_last(G2tensor(250),RedSet_4(253),mass4set(:,1),  & 
G1tensor(435),G1tensor(7),G1tensor(375),G1tensor(195),G1tensor(43))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(166),mass4set(:,1),  & 
G1tensor(507),G1tensor(501),G1tensor(79),G1tensor(423),G1tensor(219))
  call G_TensorShift(G1tensor(501),24)
  call Hotf_4pt_reduction_last(G2tensor(478),RedSet_4(254),mass4set(:,1),  & 
G1tensor(115),G1tensor(53),G1tensor(44),G1tensor(64),G1tensor(45))
  call G_TensorShift(G1tensor(53),8)
  call Hotf_4pt_reduction_last(G2tensor(256),RedSet_4(257),mass4set(:,1),  & 
G1tensor(72),G1tensor(47),G1tensor(76),G1tensor(57),G1tensor(83))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(177),mass4set(:,1),  & 
G1tensor(58),G1tensor(640),G1tensor(154),G1tensor(148),G1tensor(89))
  call G_TensorShift(G1tensor(640),20)
  call Hotf_4pt_reduction_last(G2tensor(259),RedSet_4(260),mass4set(:,1),  & 
G1tensor(66),G1tensor(84),G1tensor(69),G1tensor(215),G1tensor(209))
  call G_TensorShift(G1tensor(84),8)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(186),mass4set(:,1),  & 
G1tensor(88),G1tensor(77),G1tensor(333),G1tensor(105),G1tensor(99))
  call G_TensorShift(G1tensor(77),24)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(262),mass4set(:,1),  & 
G1tensor(339),G1tensor(112),G1tensor(100),G1tensor(345),G1tensor(122))
  call G_TensorShift(G1tensor(112),1)
  call Hotf_4pt_reduction_last(G2tensor(289),RedSet_4(193),mass4set(:,1),  & 
G1tensor(113),G1tensor(123),G1tensor(119),G1tensor(129),G1tensor(107))
  call G_TensorShift(G1tensor(123),17)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(263),mass4set(:,1),  & 
G1tensor(646),G1tensor(184),G1tensor(178),G1tensor(124),G1tensor(117))
  call G_TensorShift(G1tensor(184),1)
  call Hotf_4pt_reduction_last(G2tensor(292),RedSet_4(196),mass4set(:,1),  & 
G1tensor(130),G1tensor(118),G1tensor(239),G1tensor(233),G1tensor(131))
  call G_TensorShift(G1tensor(118),17)
  call Hotf_4pt_reduction_last(G2tensor(484),RedSet_4(264),mass4set(:,1),  & 
G1tensor(125),G1tensor(140),G1tensor(135),G1tensor(146),G1tensor(136))
  call G_TensorShift(G1tensor(140),1)
  call Hotf_4pt_reduction_last(G2tensor(586),RedSet_4(199),mass4set(:,1),  & 
G1tensor(152),G1tensor(137),G1tensor(153),G1tensor(142),G1tensor(159))
  call G_TensorShift(G1tensor(137),17)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(266),mass4set(:,1),  & 
G1tensor(143),G1tensor(160),G1tensor(149),G1tensor(263),G1tensor(257))
  call G_TensorShift(G1tensor(160),2)
  call Hotf_4pt_reduction_last(G2tensor(295),RedSet_4(207),mass4set(:,1),  & 
G1tensor(161),G1tensor(155),G1tensor(291),G1tensor(170),G1tensor(165))
  call G_TensorShift(G1tensor(155),18)
  call Hotf_4pt_reduction_last(G2tensor(268),RedSet_4(267),mass4set(:,1),  & 
G1tensor(297),G1tensor(176),G1tensor(166),G1tensor(303),G1tensor(182))
  call G_TensorShift(G1tensor(176),2)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(210),mass4set(:,1),  & 
G1tensor(167),G1tensor(183),G1tensor(172),G1tensor(189),G1tensor(173))
  call G_TensorShift(G1tensor(183),18)
  call Hotf_4pt_reduction_last(G2tensor(490),RedSet_4(268),mass4set(:,1),  & 
G1tensor(190),G1tensor(179),G1tensor(287),G1tensor(281),G1tensor(191))
  call G_TensorShift(G1tensor(179),2)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(270),mass4set(:,1),  & 
G1tensor(185),G1tensor(381),G1tensor(244),G1tensor(200),G1tensor(196))
  call G_TensorShift(G1tensor(381),1)
  call Hotf_4pt_reduction_last(G2tensor(283),RedSet_4(219),mass4set(:,1),  & 
G1tensor(387),G1tensor(206),G1tensor(197),G1tensor(574),G1tensor(256))
  call G_TensorShift(G1tensor(206),17)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(271),mass4set(:,1),  & 
G1tensor(208),G1tensor(202),G1tensor(641),G1tensor(262),G1tensor(214))
  call G_TensorShift(G1tensor(202),1)
  call Hotf_4pt_reduction_last(G2tensor(286),RedSet_4(221),mass4set(:,1),  & 
G1tensor(203),G1tensor(399),G1tensor(268),G1tensor(224),G1tensor(220))
  call G_TensorShift(G1tensor(399),17)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(273),mass4set(:,1),  & 
G1tensor(429),G1tensor(230),G1tensor(221),G1tensor(280),G1tensor(232))
  call G_TensorShift(G1tensor(230),2)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(228),mass4set(:,1),  & 
G1tensor(226),G1tensor(647),G1tensor(286),G1tensor(238),G1tensor(227))
  call G_TensorShift(G1tensor(647),18)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(274),mass4set(:,1),  & 
G1tensor(411),G1tensor(248),G1tensor(243),G1tensor(417),G1tensor(254))
  call G_TensorShift(G1tensor(248),2)
  call Hotf_4pt_reduction_last(G2tensor(307),RedSet_4(230),mass4set(:,1),  & 
G1tensor(245),G1tensor(255),G1tensor(250),G1tensor(261),G1tensor(251))
  call G_TensorShift(G1tensor(255),18)
  call Hotf_4pt_reduction_last(G2tensor(417),RedSet_4(327),mass4set(:,1),  & 
G1tensor(393),G1tensor(272),G1tensor(267),G1tensor(405),G1tensor(278))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_4pt_reduction_last(G2tensor(637),RedSet_4(235),mass4set(:,1),  & 
G1tensor(269),G1tensor(279),G1tensor(274),G1tensor(285),G1tensor(275))
  call G_TensorShift(G1tensor(279),12)
  call Hotf_4pt_reduction_last(G2tensor(419),RedSet_4(293),mass4set(:,1),  & 
G1tensor(298),G1tensor(292),G1tensor(304),G1tensor(293),G1tensor(575))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(502),RedSet_4(328),mass4set(:,1),  & 
G1tensor(569),G1tensor(347),G1tensor(341),G1tensor(305),G1tensor(299))
  call G_TensorShift(G1tensor(347),4)
  call Hotf_4pt_reduction_last(G2tensor(508),RedSet_4(329),mass4set(:,1),  & 
G1tensor(315),G1tensor(309),G1tensor(321),G1tensor(310),G1tensor(327))
  call G_TensorShift(G1tensor(309),3)
  call Hotf_4pt_reduction_last(G2tensor(511),RedSet_4(330),mass4set(:,1),  & 
G1tensor(311),G1tensor(322),G1tensor(316),G1tensor(328),G1tensor(317))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(517),RedSet_4(331),mass4set(:,1),  & 
G1tensor(587),G1tensor(581),G1tensor(371),G1tensor(365),G1tensor(329))
  call G_TensorShift(G1tensor(581),3)
  call Hotf_4pt_reduction_last(G2tensor(520),RedSet_4(317),mass4set(:,1),  & 
G1tensor(323),G1tensor(340),G1tensor(334),G1tensor(346),G1tensor(335))
  call G_TensorShift(G1tensor(340),16)
  call Hotf_4pt_reduction_last(G2tensor(526),RedSet_4(332),mass4set(:,1),  & 
G1tensor(357),G1tensor(351),G1tensor(363),G1tensor(352),G1tensor(369))
  call G_TensorShift(G1tensor(351),1)
  call Hotf_4pt_reduction_last(G2tensor(649),RedSet_4(238),mass4set(:,1),  & 
G1tensor(353),G1tensor(364),G1tensor(358),G1tensor(370),G1tensor(359))
  call G_TensorShift(G1tensor(364),17)
  call Hotf_4pt_reduction_last(G2tensor(532),RedSet_4(323),mass4set(:,1),  & 
G1tensor(664),G1tensor(412),G1tensor(382),G1tensor(376),G1tensor(454))
  call G_TensorShift(G1tensor(412),16)
  call Hotf_4pt_reduction_last(G2tensor(538),RedSet_4(333),mass4set(:,1),  & 
G1tensor(443),G1tensor(388),G1tensor(377),G1tensor(683),G1tensor(419))
  call G_TensorShift(G1tensor(388),12)
  call Hotf_4pt_reduction_last(G2tensor(541),RedSet_4(334),mass4set(:,1),  & 
G1tensor(389),G1tensor(383),G1tensor(676),G1tensor(424),G1tensor(400))
  call G_TensorShift(G1tensor(383),2)
  call Hotf_4pt_reduction_last(G2tensor(652),RedSet_4(239),mass4set(:,1),  & 
G1tensor(394),G1tensor(478),G1tensor(467),G1tensor(406),G1tensor(395))
  call G_TensorShift(G1tensor(478),18)
  call Hotf_4pt_reduction_last(G2tensor(547),RedSet_4(335),mass4set(:,1),  & 
G1tensor(671),G1tensor(431),G1tensor(407),G1tensor(401),G1tensor(514))
  call G_TensorShift(G1tensor(431),12)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(190),mass4set(:,1),  & 
G1tensor(509),G1tensor(418),G1tensor(413),G1tensor(496),G1tensor(491))
  call G_TensorShift(G1tensor(418),16)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(146),mass4set(:,1),  & 
G1tensor(430),G1tensor(425),G1tensor(484),G1tensor(447),G1tensor(436))
  call G_TensorShift(G1tensor(425),16)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(226),mass4set(:,1),  & 
G1tensor(453),G1tensor(437),G1tensor(694),G1tensor(490),G1tensor(448))
  call G_TensorShift(G1tensor(437),16)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(182),mass4set(:,1),  & 
G1tensor(442),G1tensor(719),G1tensor(497),G1tensor(455),G1tensor(449))
  call G_TensorShift(G1tensor(719),16)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(276),mass4set(:,1),  & 
G1tensor(465),G1tensor(459),G1tensor(502),G1tensor(471),G1tensor(460))
  call G_TensorShift(G1tensor(459),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(277),mass4set(:,1),  & 
G1tensor(477),G1tensor(461),G1tensor(712),G1tensor(508),G1tensor(472))
  call G_TensorShift(G1tensor(461),4)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(278),mass4set(:,1),  & 
G1tensor(466),G1tensor(707),G1tensor(515),G1tensor(479),G1tensor(473))
  call G_TensorShift(G1tensor(707),4)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(2),mass4set(:,1),  & 
G1tensor(489),G1tensor(483),G1tensor(495),G1tensor(485),G1tensor(513))
  call G_TensorShift(G1tensor(483),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(3),mass4set(:,1),  & 
G1tensor(503),G1tensor(521),G1tensor(525),G1tensor(527),G1tensor(533))
  call G_TensorShift(G1tensor(521),8)
  call Hotf_4pt_reduction_last(G2tensor(601),RedSet_4(6),mass4set(:,1),  & 
G1tensor(537),G1tensor(539),G1tensor(566),G1tensor(567),G1tensor(568))
  call G_TensorShift(G1tensor(539),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(7),mass4set(:,1),  & 
G1tensor(681),G1tensor(572),G1tensor(687),G1tensor(578),G1tensor(579))
  call G_TensorShift(G1tensor(572),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(10),mass4set(:,1),  & 
G1tensor(580),G1tensor(717),G1tensor(584),G1tensor(585),G1tensor(586))
  call G_TensorShift(G1tensor(717),8)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(120),mass4set(:,1),  & 
G1tensor(639),G1tensor(645),G1tensor(663),G1tensor(718),G1tensor(706))
  call G_TensorShift(G1tensor(645),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(121),mass4set(:,1),  & 
G1tensor(677),G1tensor(665),G1tensor(669),G1tensor(713),G1tensor(695))
  call G_TensorShift(G1tensor(665),8)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(122),mass4set(:,1),  & 
G1tensor(682),G1tensor(670),G1tensor(675),G1tensor(699),G1tensor(705))
  call G_TensorShift(G1tensor(670),8)
  call Hotf_4pt_reduction_last(G2tensor(382),RedSet_4(17),mass4set(:,1),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(18),mass4set(:,1),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),4)
  call Hotf_4pt_reduction_last(G2tensor(607),RedSet_4(20),mass4set(:,1),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(21),mass4set(:,1),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(23),mass4set(:,1),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),4)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(280),mass4set(:,1),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),4)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(281),mass4set(:,1),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(282),mass4set(:,1),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),4)
  call Hotf_4pt_reduction_last(G2tensor(384),RedSet_4(27),mass4set(:,1),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(28),mass4set(:,1),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),8)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(31),mass4set(:,1),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),8)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(34),mass4set(:,1),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),8)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(93),mass4set(:,1),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(94),mass4set(:,1),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),8)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(95),mass4set(:,1),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),8)
  call Hotf_4pt_reduction_last(G2tensor(385),RedSet_4(41),mass4set(:,1),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),4)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(42),mass4set(:,1),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),4)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(44),mass4set(:,1),  & 
G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(807),4)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(46),mass4set(:,1),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815))
  call G_TensorShift(G1tensor(812),4)
  call Hotf_4pt_reduction_last(G2tensor(496),RedSet_4(147),mass4set(:,1),  & 
G1tensor(816),G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820))
  call G_TensorShift(G1tensor(817),16)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(148),mass4set(:,1),  & 
G1tensor(821),G1tensor(822),G1tensor(823),G1tensor(824),G1tensor(825))
  call G_TensorShift(G1tensor(822),16)
  call Hotf_4pt_reduction_last(G2tensor(415),RedSet_4(54),mass4set(:,1),  & 
G1tensor(826),G1tensor(827),G1tensor(828),G1tensor(829),G1tensor(830))
  call G_TensorShift(G1tensor(827),8)
  call Hotf_4pt_reduction_last(G2tensor(460),RedSet_4(55),mass4set(:,1),  & 
G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834),G1tensor(835))
  call G_TensorShift(G1tensor(832),8)
  call Hotf_4pt_reduction_last(G2tensor(499),RedSet_4(161),mass4set(:,1),  & 
G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(837),16)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(183),mass4set(:,1),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845))
  call G_TensorShift(G1tensor(842),16)
  call Hotf_4pt_reduction_last(G2tensor(416),RedSet_4(68),mass4set(:,1),  & 
G1tensor(846),G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850))
  call G_TensorShift(G1tensor(847),4)
  call Hotf_4pt_reduction_last(G2tensor(463),RedSet_4(69),mass4set(:,1),  & 
G1tensor(851),G1tensor(852),G1tensor(853),G1tensor(854),G1tensor(855))
  call G_TensorShift(G1tensor(852),4)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(173),mass4set(:,1),  & 
G1tensor(856),G1tensor(857),G1tensor(858),G1tensor(859),G1tensor(860))
  call G_TensorShift(G1tensor(857),16)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(174),mass4set(:,1),  & 
G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864),G1tensor(865))
  call G_TensorShift(G1tensor(862),16)
  call Hotf_4pt_reduction_last(G2tensor(388),RedSet_4(76),mass4set(:,1),  & 
G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(867),8)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(77),mass4set(:,1),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875))
  call G_TensorShift(G1tensor(872),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(160),mass4set(:,1),  & 
G1tensor(876),G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880))
  call G_TensorShift(G1tensor(877),16)
  call Hotf_4pt_reduction_last(G2tensor(163),RedSet_4(162),mass4set(:,1),  & 
G1tensor(881),G1tensor(882),G1tensor(883),G1tensor(884),G1tensor(885))
  call G_TensorShift(G1tensor(882),16)
  call Hotf_4pt_reduction_last(G2tensor(389),RedSet_4(85),mass4set(:,1),  & 
G1tensor(886),G1tensor(887),G1tensor(888),G1tensor(889),G1tensor(890))
  call G_TensorShift(G1tensor(887),4)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(86),mass4set(:,1),  & 
G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894),G1tensor(895))
  call G_TensorShift(G1tensor(892),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(97),mass4set(:,1),  & 
G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(897),8)
  call Hotf_4pt_reduction_last(G2tensor(235),RedSet_4(98),mass4set(:,1),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905))
  call G_TensorShift(G1tensor(902),8)
  call Hotf_4pt_reduction_last(G2tensor(562),RedSet_4(101),mass4set(:,1),  & 
G1tensor(906),G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910))
  call G_TensorShift(G1tensor(907),8)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(107),mass4set(:,1),  & 
G1tensor(911),G1tensor(912),G1tensor(913),G1tensor(914),G1tensor(915))
  call G_TensorShift(G1tensor(912),2)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(108),mass4set(:,1),  & 
G1tensor(916),G1tensor(917),G1tensor(918),G1tensor(919),G1tensor(920))
  call G_TensorShift(G1tensor(917),2)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(109),mass4set(:,1),  & 
G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924),G1tensor(925))
  call G_TensorShift(G1tensor(922),2)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(112),mass4set(:,1),  & 
G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(927),2)
  call Hotf_4pt_reduction_last(G2tensor(238),RedSet_4(113),mass4set(:,1),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935))
  call G_TensorShift(G1tensor(932),2)
  call Hotf_4pt_reduction_last(G2tensor(565),RedSet_4(115),mass4set(:,1),  & 
G1tensor(936),G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940))
  call G_TensorShift(G1tensor(937),2)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(124),mass4set(:,1),  & 
G1tensor(941),G1tensor(942),G1tensor(943),G1tensor(944),G1tensor(945))
  call G_TensorShift(G1tensor(942),8)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(125),mass4set(:,1),  & 
G1tensor(946),G1tensor(947),G1tensor(948),G1tensor(949),G1tensor(950))
  call G_TensorShift(G1tensor(947),8)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(133),mass4set(:,1),  & 
G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954),G1tensor(955))
  call G_TensorShift(G1tensor(952),2)
  call Hotf_4pt_reduction_last(G2tensor(271),RedSet_4(134),mass4set(:,1),  & 
G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(957),2)
  call Hotf_4pt_reduction_last(G2tensor(241),RedSet_4(135),mass4set(:,1),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965))
  call G_TensorShift(G1tensor(962),2)
  call Hotf_4pt_reduction_last(G2tensor(274),RedSet_4(138),mass4set(:,1),  & 
G1tensor(966),G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970))
  call G_TensorShift(G1tensor(967),2)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(139),mass4set(:,1),  & 
G1tensor(971),G1tensor(972),G1tensor(973),G1tensor(974),G1tensor(975))
  call G_TensorShift(G1tensor(972),2)
  call Hotf_4pt_reduction_last(G2tensor(568),RedSet_4(150),mass4set(:,1),  & 
G1tensor(976),G1tensor(977),G1tensor(978),G1tensor(979),G1tensor(980))
  call G_TensorShift(G1tensor(977),16)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(151),mass4set(:,1),  & 
G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984),G1tensor(985))
  call G_TensorShift(G1tensor(982),16)
  call Hotf_4pt_reduction_last(G2tensor(475),RedSet_4(154),mass4set(:,1),  & 
G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(987),16)
  call Hotf_4pt_reduction_last(G2tensor(571),RedSet_4(164),mass4set(:,1),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995))
  call G_TensorShift(G1tensor(992),16)
  call Hotf_4pt_reduction_last(G2tensor(253),RedSet_4(165),mass4set(:,1),  & 
G1tensor(996),G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000))
  call G_TensorShift(G1tensor(997),16)
  call Hotf_4pt_reduction_last(G2tensor(481),RedSet_4(168),mass4set(:,1),  & 
G1tensor(1001),G1tensor(1002),G1tensor(1003),G1tensor(1004),G1tensor(1005))
  call G_TensorShift(G1tensor(1002),16)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(176),mass4set(:,1),  & 
G1tensor(1006),G1tensor(1007),G1tensor(1008),G1tensor(1009),G1tensor(1010))
  call G_TensorShift(G1tensor(1007),16)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(185),mass4set(:,1),  & 
G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014),G1tensor(1015))
  call G_TensorShift(G1tensor(1012),16)
  call Hotf_4pt_reduction_last(G2tensor(574),RedSet_4(191),mass4set(:,1),  & 
G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1017),16)
  call Hotf_4pt_reduction_last(G2tensor(265),RedSet_4(192),mass4set(:,1),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025))
  call G_TensorShift(G1tensor(1022),16)
  call Hotf_4pt_reduction_last(G2tensor(577),RedSet_4(195),mass4set(:,1),  & 
G1tensor(1026),G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030))
  call G_TensorShift(G1tensor(1027),16)
  call Hotf_4pt_reduction_last(G2tensor(487),RedSet_4(198),mass4set(:,1),  & 
G1tensor(1031),G1tensor(1032),G1tensor(1033),G1tensor(1034),G1tensor(1035))
  call G_TensorShift(G1tensor(1032),16)
  call Hotf_4pt_reduction_last(G2tensor(277),RedSet_4(204),mass4set(:,1),  & 
G1tensor(1036),G1tensor(1037),G1tensor(1038),G1tensor(1039),G1tensor(1040))
  call G_TensorShift(G1tensor(1037),16)
  call Hotf_4pt_reduction_last(G2tensor(580),RedSet_4(205),mass4set(:,1),  & 
G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044),G1tensor(1045))
  call G_TensorShift(G1tensor(1042),16)
  call Hotf_4pt_reduction_last(G2tensor(166),RedSet_4(206),mass4set(:,1),  & 
G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1047),16)
  call Hotf_4pt_reduction_last(G2tensor(583),RedSet_4(209),mass4set(:,1),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055))
  call G_TensorShift(G1tensor(1052),16)
  call Hotf_4pt_reduction_last(G2tensor(493),RedSet_4(212),mass4set(:,1),  & 
G1tensor(1056),G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060))
  call G_TensorShift(G1tensor(1057),16)
  call Hotf_4pt_reduction_last(G2tensor(280),RedSet_4(217),mass4set(:,1),  & 
G1tensor(1061),G1tensor(1062),G1tensor(1063),G1tensor(1064),G1tensor(1065))
  call G_TensorShift(G1tensor(1062),16)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(218),mass4set(:,1),  & 
G1tensor(1066),G1tensor(1067),G1tensor(1068),G1tensor(1069),G1tensor(1070))
  call G_TensorShift(G1tensor(1067),16)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(227),mass4set(:,1),  & 
G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074),G1tensor(1075))
  call G_TensorShift(G1tensor(1072),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(284),mass4set(:,1),  & 
G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1077),17)
  call Hotf_4pt_reduction_last(G2tensor(397),RedSet_4(285),mass4set(:,1),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085))
  call G_TensorShift(G1tensor(1082),17)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(286),mass4set(:,1),  & 
G1tensor(1086),G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090))
  call G_TensorShift(G1tensor(1087),17)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(287),mass4set(:,1),  & 
G1tensor(1091),G1tensor(1092),G1tensor(1093),G1tensor(1094),G1tensor(1095))
  call G_TensorShift(G1tensor(1092),18)
  call Hotf_4pt_reduction_last(G2tensor(399),RedSet_4(288),mass4set(:,1),  & 
G1tensor(1096),G1tensor(1097),G1tensor(1098),G1tensor(1099),G1tensor(1100))
  call G_TensorShift(G1tensor(1097),18)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(289),mass4set(:,1),  & 
G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104),G1tensor(1105))
  call G_TensorShift(G1tensor(1102),18)
  call Hotf_4pt_reduction_last(G2tensor(550),RedSet_4(336),mass4set(:,1),  & 
G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1107),3)
  call Hotf_4pt_reduction_last(G2tensor(443),RedSet_4(290),mass4set(:,1),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115))
  call G_TensorShift(G1tensor(1112),8)
  call Hotf_4pt_reduction_last(G2tensor(420),RedSet_4(291),mass4set(:,1),  & 
G1tensor(1116),G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120))
  call G_TensorShift(G1tensor(1117),8)
  call Hotf_4pt_reduction_last(G2tensor(553),RedSet_4(313),mass4set(:,1),  & 
G1tensor(1121),G1tensor(1122),G1tensor(1123),G1tensor(1124),G1tensor(1125))
  call G_TensorShift(G1tensor(1122),16)
  call Hotf_4pt_reduction_last(G2tensor(556),RedSet_4(315),mass4set(:,1),  & 
G1tensor(1126),G1tensor(1127),G1tensor(1128),G1tensor(1129),G1tensor(1130))
  call G_TensorShift(G1tensor(1127),12)
  call Hotf_4pt_reduction_last(G2tensor(444),RedSet_4(295),mass4set(:,1),  & 
G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134),G1tensor(1135))
  call G_TensorShift(G1tensor(1132),2)
  call Hotf_4pt_reduction_last(G2tensor(423),RedSet_4(296),mass4set(:,1),  & 
G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1137),2)
  call Hotf_4pt_reduction_last(G2tensor(559),RedSet_4(325),mass4set(:,1),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145))
  call G_TensorShift(G1tensor(1142),16)
  call Hotf_4pt_reduction_last(G2tensor(445),RedSet_4(298),mass4set(:,1),  & 
G1tensor(1146),G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150))
  call G_TensorShift(G1tensor(1147),2)
  call Hotf_4pt_reduction_last(G2tensor(426),RedSet_4(299),mass4set(:,1),  & 
G1tensor(1151),G1tensor(1152),G1tensor(1153),G1tensor(1154),G1tensor(1155))
  call G_TensorShift(G1tensor(1152),2)
  call Hotf_4pt_reduction_last(G2tensor(598),RedSet_4(301),mass4set(:,1),  & 
G1tensor(1156),G1tensor(1157),G1tensor(1158),G1tensor(1159),G1tensor(1160))
  call G_TensorShift(G1tensor(1157),8)
  call Hotf_4pt_reduction_last(G2tensor(604),RedSet_4(303),mass4set(:,1),  & 
G1tensor(1161),G1tensor(1162),G1tensor(1163),G1tensor(1164),G1tensor(1165))
  call G_TensorShift(G1tensor(1162),4)
  call Hotf_4pt_reduction_last(G2tensor(622),RedSet_4(305),mass4set(:,1),  & 
G1tensor(1166),G1tensor(1167),G1tensor(1168),G1tensor(1169),G1tensor(1170))
  call G_TensorShift(G1tensor(1167),16)
  call Hotf_4pt_reduction_last(G2tensor(514),RedSet_4(306),mass4set(:,1),  & 
G1tensor(1171),G1tensor(1172),G1tensor(1173),G1tensor(1174),G1tensor(1175))
  call G_TensorShift(G1tensor(1172),16)
  call Hotf_4pt_reduction_last(G2tensor(625),RedSet_4(308),mass4set(:,1),  & 
G1tensor(1176),G1tensor(1177),G1tensor(1178),G1tensor(1179),G1tensor(1180))
  call G_TensorShift(G1tensor(1177),16)
  call Hotf_4pt_reduction_last(G2tensor(544),RedSet_4(309),mass4set(:,1),  & 
G1tensor(1181),G1tensor(1182),G1tensor(1183),G1tensor(1184),G1tensor(1185))
  call G_TensorShift(G1tensor(1182),16)
  call Hotf_4pt_reduction_last(G2tensor(628),RedSet_4(311),mass4set(:,1),  & 
G1tensor(1186),G1tensor(1187),G1tensor(1188),G1tensor(1189),G1tensor(1190))
  call G_TensorShift(G1tensor(1187),16)
  call Hotf_4pt_reduction_last(G2tensor(634),RedSet_4(319),mass4set(:,1),  & 
G1tensor(1191),G1tensor(1192),G1tensor(1193),G1tensor(1194),G1tensor(1195))
  call G_TensorShift(G1tensor(1192),12)
  call Hotf_4pt_reduction_last(G2tensor(640),RedSet_4(321),mass4set(:,1),  & 
G1tensor(1196),G1tensor(1197),G1tensor(1198),G1tensor(1199),G1tensor(1200))
  call G_TensorShift(G1tensor(1197),16)
  call Hotf_4pt_reduction_last(G2tensor(430),RedSet_4(309),mass4set(:,1),  & 
G1tensor(1201),G1tensor(1202),G1tensor(1203),G1tensor(1204),G1tensor(1205),G0tensor(1))
  call G_TensorShift(G1tensor(1202),16)
  call Hotf_4pt_reduction_last(G2tensor(432),RedSet_4(235),mass4set(:,1),  & 
G1tensor(1201),G1tensor(1206),G1tensor(1207),G1tensor(1208),G1tensor(1209),G0tensor(2))
  call G_TensorShift(G1tensor(1206),12)
  call Hotf_4pt_reduction_last(G2tensor(434),RedSet_4(306),mass4set(:,1),  & 
G1tensor(1201),G1tensor(1210),G1tensor(1211),G1tensor(1212),G1tensor(1213),G0tensor(3))
  call G_TensorShift(G1tensor(1210),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(279),mass4set(:,1),  & 
G0tensor(4),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(13),mass4set(:,1),  & 
G0tensor(9),G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(123),mass4set(:,1),  & 
G0tensor(14),G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(283),mass4set(:,1),  & 
G0tensor(19),G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(37),mass4set(:,1),  & 
G0tensor(24),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(96),mass4set(:,1),  & 
G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(149),mass4set(:,1),  & 
G0tensor(34),G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(60),mass4set(:,1),  & 
G0tensor(39),G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(184),mass4set(:,1),  & 
G0tensor(44),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(175),mass4set(:,1),  & 
G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(82),mass4set(:,1),  & 
G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(163),mass4set(:,1),  & 
G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(11),mass4set(:,1),  & 
G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(35),mass4set(:,1),  & 
G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(58),mass4set(:,1),  & 
G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(72),mass4set(:,1),  & 
G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(80),mass4set(:,1),  & 
G0tensor(84),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(89),mass4set(:,1),  & 
G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(243),mass4set(:,1),  & 
G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98))
  call Hotf_4pt_reduction_last(G1tensor(571),RedSet_4(52),mass4set(:,1),  & 
G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103))
  call Hotf_4pt_reduction_last(G1tensor(601),RedSet_4(247),mass4set(:,1),  & 
G0tensor(104),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108))
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(66),mass4set(:,1),  & 
G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(4),mass4set(:,1),  & 
G0tensor(114),G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(8),mass4set(:,1),  & 
G0tensor(119),G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123))
  call Hotf_4pt_reduction_last(G1tensor(95),RedSet_4(29),mass4set(:,1),  & 
G0tensor(124),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(32),mass4set(:,1),  & 
G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133))
  call Hotf_4pt_reduction_last(G1tensor(582),RedSet_4(56),mass4set(:,1),  & 
G0tensor(134),G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(70),mass4set(:,1),  & 
G0tensor(139),G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143))
  call Hotf_4pt_reduction_last(G1tensor(558),RedSet_4(78),mass4set(:,1),  & 
G0tensor(144),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(87),mass4set(:,1),  & 
G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153))
  call Hotf_4pt_reduction_last(G1tensor(708),RedSet_4(237),mass4set(:,1),  & 
G0tensor(154),G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158))
  call Hotf_4pt_reduction_last(G1tensor(264),RedSet_4(236),mass4set(:,1),  & 
G0tensor(159),G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163))
  call Hotf_4pt_reduction_last(G1tensor(659),RedSet_4(234),mass4set(:,1),  & 
G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(169),mass4set(:,1),  & 
G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(213),mass4set(:,1),  & 
G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178))
  call Hotf_4pt_reduction_last(G1tensor(531),RedSet_4(104),mass4set(:,1),  & 
G0tensor(179),G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183))
  call Hotf_4pt_reduction_last(G1tensor(67),RedSet_4(118),mass4set(:,1),  & 
G0tensor(184),G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(130),mass4set(:,1),  & 
G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193))
  call Hotf_4pt_reduction_last(G1tensor(658),RedSet_4(144),mass4set(:,1),  & 
G0tensor(194),G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198))
  call Hotf_4pt_reduction_last(G1tensor(144),RedSet_4(337),mass4set(:,1),  & 
G0tensor(199),G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203))
  call Hotf_4pt_reduction_last(G1tensor(562),RedSet_4(251),mass4set(:,1),  & 
G0tensor(204),G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208))
  call Hotf_4pt_reduction_last(G1tensor(544),RedSet_4(157),mass4set(:,1),  & 
G0tensor(209),G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(338),mass4set(:,1),  & 
G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218))
  call Hotf_4pt_reduction_last(G1tensor(540),RedSet_4(255),mass4set(:,1),  & 
G0tensor(219),G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223))
  call Hotf_4pt_reduction_last(G1tensor(576),RedSet_4(339),mass4set(:,1),  & 
G0tensor(224),G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228))
  call Hotf_4pt_reduction_last(G1tensor(474),RedSet_4(258),mass4set(:,1),  & 
G0tensor(229),G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233))
  call Hotf_4pt_reduction_last(G1tensor(480),RedSet_4(179),mass4set(:,1),  & 
G0tensor(234),G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238))
  call Hotf_4pt_reduction_last(G1tensor(612),RedSet_4(340),mass4set(:,1),  & 
G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(261),mass4set(:,1),  & 
G0tensor(244),G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(40),mass4set(:,1),  & 
G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(265),mass4set(:,1),  & 
G0tensor(254),G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(201),mass4set(:,1),  & 
G0tensor(259),G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(1),mass4set(:,1),  & 
G0tensor(264),G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(269),mass4set(:,1),  & 
G0tensor(269),G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(26),mass4set(:,1),  & 
G0tensor(274),G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(272),mass4set(:,1),  & 
G0tensor(279),G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283))
  call Hotf_4pt_reduction_last(G1tensor(608),RedSet_4(223),mass4set(:,1),  & 
G0tensor(284),G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(16),mass4set(:,1),  & 
G0tensor(289),G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293))
  call Hotf_4pt_reduction_last(G1tensor(650),RedSet_4(275),mass4set(:,1),  & 
G0tensor(294),G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298))
  call Hotf_4pt_reduction_last(G1tensor(194),RedSet_4(244),mass4set(:,1),  & 
G0tensor(299),G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303))
  call Hotf_4pt_reduction_last(G1tensor(560),RedSet_4(240),mass4set(:,1),  & 
G0tensor(304),G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(248),mass4set(:,1),  & 
G0tensor(309),G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(259),mass4set(:,1),  & 
G0tensor(314),G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(256),mass4set(:,1),  & 
G0tensor(319),G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(252),mass4set(:,1),  & 
G0tensor(324),G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(241),mass4set(:,1),  & 
G0tensor(329),G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333))
  call Hotf_4pt_reduction_last(G1tensor(342),RedSet_4(99),mass4set(:,1),  & 
G0tensor(334),G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338))
  call Hotf_4pt_reduction_last(G1tensor(354),RedSet_4(242),mass4set(:,1),  & 
G0tensor(339),G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343))
  call Hotf_4pt_reduction_last(G1tensor(362),RedSet_4(102),mass4set(:,1),  & 
G0tensor(344),G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(49),mass4set(:,1),  & 
G0tensor(349),G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(110),mass4set(:,1),  & 
G0tensor(354),G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(50),mass4set(:,1),  & 
G0tensor(359),G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(51),mass4set(:,1),  & 
G0tensor(364),G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368))
  call Hotf_4pt_reduction_last(G1tensor(422),RedSet_4(116),mass4set(:,1),  & 
G0tensor(369),G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373))
  call Hotf_4pt_reduction_last(G1tensor(434),RedSet_4(245),mass4set(:,1),  & 
G0tensor(374),G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(126),mass4set(:,1),  & 
G0tensor(379),G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(246),mass4set(:,1),  & 
G0tensor(384),G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(128),mass4set(:,1),  & 
G0tensor(389),G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(63),mass4set(:,1),  & 
G0tensor(394),G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(136),mass4set(:,1),  & 
G0tensor(399),G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(64),mass4set(:,1),  & 
G0tensor(404),G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408))
  call Hotf_4pt_reduction_last(G1tensor(518),RedSet_4(140),mass4set(:,1),  & 
G0tensor(409),G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(65),mass4set(:,1),  & 
G0tensor(414),G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418))
  call Hotf_4pt_reduction_last(G1tensor(700),RedSet_4(142),mass4set(:,1),  & 
G0tensor(419),G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423))
  call Hotf_4pt_reduction_last(G1tensor(573),RedSet_4(249),mass4set(:,1),  & 
G0tensor(424),G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428))
  call Hotf_4pt_reduction_last(G1tensor(693),RedSet_4(152),mass4set(:,1),  & 
G0tensor(429),G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433))
  call Hotf_4pt_reduction_last(G1tensor(520),RedSet_4(250),mass4set(:,1),  & 
G0tensor(434),G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438))
  call Hotf_4pt_reduction_last(G1tensor(714),RedSet_4(155),mass4set(:,1),  & 
G0tensor(439),G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443))
  call Hotf_4pt_reduction_last(G1tensor(435),RedSet_4(253),mass4set(:,1),  & 
G0tensor(444),G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448))
  call Hotf_4pt_reduction_last(G1tensor(507),RedSet_4(166),mass4set(:,1),  & 
G0tensor(449),G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453))
  call Hotf_4pt_reduction_last(G1tensor(115),RedSet_4(254),mass4set(:,1),  & 
G0tensor(454),G0tensor(455),G0tensor(456),G0tensor(457),G0tensor(458))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(257),mass4set(:,1),  & 
G0tensor(459),G0tensor(460),G0tensor(461),G0tensor(462),G0tensor(463))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(177),mass4set(:,1),  & 
G0tensor(464),G0tensor(465),G0tensor(466),G0tensor(467),G0tensor(468))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(260),mass4set(:,1),  & 
G0tensor(469),G0tensor(470),G0tensor(471),G0tensor(472),G0tensor(473))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(186),mass4set(:,1),  & 
G0tensor(474),G0tensor(475),G0tensor(476),G0tensor(477),G0tensor(478))
  call Hotf_4pt_reduction_last(G1tensor(339),RedSet_4(262),mass4set(:,1),  & 
G0tensor(479),G0tensor(480),G0tensor(481),G0tensor(482),G0tensor(483))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(193),mass4set(:,1),  & 
G0tensor(484),G0tensor(485),G0tensor(486),G0tensor(487),G0tensor(488))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(263),mass4set(:,1),  & 
G0tensor(489),G0tensor(490),G0tensor(491),G0tensor(492),G0tensor(493))
  call Hotf_4pt_reduction_last(G1tensor(130),RedSet_4(196),mass4set(:,1),  & 
G0tensor(494),G0tensor(495),G0tensor(496),G0tensor(497),G0tensor(498))
  call Hotf_4pt_reduction_last(G1tensor(125),RedSet_4(264),mass4set(:,1),  & 
G0tensor(499),G0tensor(500),G0tensor(501),G0tensor(502),G0tensor(503))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(199),mass4set(:,1),  & 
G0tensor(504),G0tensor(505),G0tensor(506),G0tensor(507),G0tensor(508))
  call Hotf_4pt_reduction_last(G1tensor(143),RedSet_4(266),mass4set(:,1),  & 
G0tensor(509),G0tensor(510),G0tensor(511),G0tensor(512),G0tensor(513))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(207),mass4set(:,1),  & 
G0tensor(514),G0tensor(515),G0tensor(516),G0tensor(517),G0tensor(518))
  call Hotf_4pt_reduction_last(G1tensor(297),RedSet_4(267),mass4set(:,1),  & 
G0tensor(519),G0tensor(520),G0tensor(521),G0tensor(522),G0tensor(523))
  call Hotf_4pt_reduction_last(G1tensor(167),RedSet_4(210),mass4set(:,1),  & 
G0tensor(524),G0tensor(525),G0tensor(526),G0tensor(527),G0tensor(528))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(268),mass4set(:,1),  & 
G0tensor(529),G0tensor(530),G0tensor(531),G0tensor(532),G0tensor(533))
  call Hotf_4pt_reduction_last(G1tensor(185),RedSet_4(270),mass4set(:,1),  & 
G0tensor(534),G0tensor(535),G0tensor(536),G0tensor(537),G0tensor(538))
  call Hotf_4pt_reduction_last(G1tensor(387),RedSet_4(219),mass4set(:,1),  & 
G0tensor(539),G0tensor(540),G0tensor(541),G0tensor(542),G0tensor(543))
  call Hotf_4pt_reduction_last(G1tensor(208),RedSet_4(271),mass4set(:,1),  & 
G0tensor(544),G0tensor(545),G0tensor(546),G0tensor(547),G0tensor(548))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(221),mass4set(:,1),  & 
G0tensor(549),G0tensor(550),G0tensor(551),G0tensor(552),G0tensor(553))
  call Hotf_4pt_reduction_last(G1tensor(429),RedSet_4(273),mass4set(:,1),  & 
G0tensor(554),G0tensor(555),G0tensor(556),G0tensor(557),G0tensor(558))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(228),mass4set(:,1),  & 
G0tensor(559),G0tensor(560),G0tensor(561),G0tensor(562),G0tensor(563))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(274),mass4set(:,1),  & 
G0tensor(564),G0tensor(565),G0tensor(566),G0tensor(567),G0tensor(568))
  call Hotf_4pt_reduction_last(G1tensor(245),RedSet_4(230),mass4set(:,1),  & 
G0tensor(569),G0tensor(570),G0tensor(571),G0tensor(572),G0tensor(573))
  call Hotf_4pt_reduction_last(G1tensor(393),RedSet_4(327),mass4set(:,1),  & 
G0tensor(574),G0tensor(575),G0tensor(576),G0tensor(577),G0tensor(578))
  call Hotf_4pt_reduction_last(G1tensor(269),RedSet_4(235),mass4set(:,1),  & 
G0tensor(579),G0tensor(580),G0tensor(581),G0tensor(582),G0tensor(583))
  call Hotf_4pt_reduction_last(G1tensor(298),RedSet_4(293),mass4set(:,1),  & 
G0tensor(584),G0tensor(585),G0tensor(586),G0tensor(587),G0tensor(588))
  call Hotf_4pt_reduction_last(G1tensor(569),RedSet_4(328),mass4set(:,1),  & 
G0tensor(589),G0tensor(590),G0tensor(591),G0tensor(592),G0tensor(593))
  call Hotf_4pt_reduction_last(G1tensor(315),RedSet_4(329),mass4set(:,1),  & 
G0tensor(594),G0tensor(595),G0tensor(596),G0tensor(597),G0tensor(598))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(330),mass4set(:,1),  & 
G0tensor(599),G0tensor(600),G0tensor(601),G0tensor(602),G0tensor(603))
  call Hotf_4pt_reduction_last(G1tensor(587),RedSet_4(331),mass4set(:,1),  & 
G0tensor(604),G0tensor(605),G0tensor(606),G0tensor(607),G0tensor(608))
  call Hotf_4pt_reduction_last(G1tensor(323),RedSet_4(317),mass4set(:,1),  & 
G0tensor(609),G0tensor(610),G0tensor(611),G0tensor(612),G0tensor(613))
  call Hotf_4pt_reduction_last(G1tensor(357),RedSet_4(332),mass4set(:,1),  & 
G0tensor(614),G0tensor(615),G0tensor(616),G0tensor(617),G0tensor(618))
  call Hotf_4pt_reduction_last(G1tensor(353),RedSet_4(238),mass4set(:,1),  & 
G0tensor(619),G0tensor(620),G0tensor(621),G0tensor(622),G0tensor(623))
  call Hotf_4pt_reduction_last(G1tensor(664),RedSet_4(323),mass4set(:,1),  & 
G0tensor(624),G0tensor(625),G0tensor(626),G0tensor(627),G0tensor(628))
  call Hotf_4pt_reduction_last(G1tensor(443),RedSet_4(333),mass4set(:,1),  & 
G0tensor(629),G0tensor(630),G0tensor(631),G0tensor(632),G0tensor(633))
  call Hotf_4pt_reduction_last(G1tensor(389),RedSet_4(334),mass4set(:,1),  & 
G0tensor(634),G0tensor(635),G0tensor(636),G0tensor(637),G0tensor(638))
  call Hotf_4pt_reduction_last(G1tensor(394),RedSet_4(239),mass4set(:,1),  & 
G0tensor(639),G0tensor(640),G0tensor(641),G0tensor(642),G0tensor(643))
  call Hotf_4pt_reduction_last(G1tensor(671),RedSet_4(335),mass4set(:,1),  & 
G0tensor(644),G0tensor(645),G0tensor(646),G0tensor(647),G0tensor(648))
  call Hotf_4pt_reduction_last(G1tensor(509),RedSet_4(190),mass4set(:,1),  & 
G0tensor(649),G0tensor(650),G0tensor(651),G0tensor(652),G0tensor(653))
  call Hotf_4pt_reduction_last(G1tensor(430),RedSet_4(146),mass4set(:,1),  & 
G0tensor(654),G0tensor(655),G0tensor(656),G0tensor(657),G0tensor(658))
  call Hotf_4pt_reduction_last(G1tensor(453),RedSet_4(226),mass4set(:,1),  & 
G0tensor(659),G0tensor(660),G0tensor(661),G0tensor(662),G0tensor(663))
  call Hotf_4pt_reduction_last(G1tensor(442),RedSet_4(182),mass4set(:,1),  & 
G0tensor(664),G0tensor(665),G0tensor(666),G0tensor(667),G0tensor(668))
  call Hotf_4pt_reduction_last(G1tensor(465),RedSet_4(276),mass4set(:,1),  & 
G0tensor(669),G0tensor(670),G0tensor(671),G0tensor(672),G0tensor(673))
  call Hotf_4pt_reduction_last(G1tensor(477),RedSet_4(277),mass4set(:,1),  & 
G0tensor(674),G0tensor(675),G0tensor(676),G0tensor(677),G0tensor(678))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(278),mass4set(:,1),  & 
G0tensor(679),G0tensor(680),G0tensor(681),G0tensor(682),G0tensor(683))
  call Hotf_4pt_reduction_last(G1tensor(489),RedSet_4(2),mass4set(:,1),  & 
G0tensor(684),G0tensor(685),G0tensor(686),G0tensor(687),G0tensor(688))
  call Hotf_4pt_reduction_last(G1tensor(503),RedSet_4(3),mass4set(:,1),  & 
G0tensor(689),G0tensor(690),G0tensor(691),G0tensor(692),G0tensor(693))
  call Hotf_4pt_reduction_last(G1tensor(537),RedSet_4(6),mass4set(:,1),  & 
G0tensor(694),G0tensor(695),G0tensor(696),G0tensor(697),G0tensor(698))
  call Hotf_4pt_reduction_last(G1tensor(681),RedSet_4(7),mass4set(:,1),  & 
G0tensor(699),G0tensor(700),G0tensor(701),G0tensor(702),G0tensor(703))
  call Hotf_4pt_reduction_last(G1tensor(580),RedSet_4(10),mass4set(:,1),  & 
G0tensor(704),G0tensor(705),G0tensor(706),G0tensor(707),G0tensor(708))
  call Hotf_4pt_reduction_last(G1tensor(639),RedSet_4(120),mass4set(:,1),  & 
G0tensor(709),G0tensor(710),G0tensor(711),G0tensor(712),G0tensor(713))
  call Hotf_4pt_reduction_last(G1tensor(677),RedSet_4(121),mass4set(:,1),  & 
G0tensor(714),G0tensor(715),G0tensor(716),G0tensor(717),G0tensor(718))
  call Hotf_4pt_reduction_last(G1tensor(682),RedSet_4(122),mass4set(:,1),  & 
G0tensor(719),G0tensor(720),G0tensor(721),G0tensor(722),G0tensor(723))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(17),mass4set(:,1),  & 
G0tensor(724),G0tensor(725),G0tensor(726),G0tensor(727),G0tensor(728))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(18),mass4set(:,1),  & 
G0tensor(729),G0tensor(730),G0tensor(731),G0tensor(732),G0tensor(733))
  call Hotf_4pt_reduction_last(G1tensor(731),RedSet_4(20),mass4set(:,1),  & 
G0tensor(734),G0tensor(735),G0tensor(736),G0tensor(737),G0tensor(738))
  call Hotf_4pt_reduction_last(G1tensor(736),RedSet_4(21),mass4set(:,1),  & 
G0tensor(739),G0tensor(740),G0tensor(741),G0tensor(742),G0tensor(743))
  call Hotf_4pt_reduction_last(G1tensor(741),RedSet_4(23),mass4set(:,1),  & 
G0tensor(744),G0tensor(745),G0tensor(746),G0tensor(747),G0tensor(748))
  call Hotf_4pt_reduction_last(G1tensor(746),RedSet_4(280),mass4set(:,1),  & 
G0tensor(749),G0tensor(750),G0tensor(751),G0tensor(752),G0tensor(753))
  call Hotf_4pt_reduction_last(G1tensor(751),RedSet_4(281),mass4set(:,1),  & 
G0tensor(754),G0tensor(755),G0tensor(756),G0tensor(757),G0tensor(758))
  call Hotf_4pt_reduction_last(G1tensor(756),RedSet_4(282),mass4set(:,1),  & 
G0tensor(759),G0tensor(760),G0tensor(761),G0tensor(762),G0tensor(763))
  call Hotf_4pt_reduction_last(G1tensor(761),RedSet_4(27),mass4set(:,1),  & 
G0tensor(764),G0tensor(765),G0tensor(766),G0tensor(767),G0tensor(768))
  call Hotf_4pt_reduction_last(G1tensor(766),RedSet_4(28),mass4set(:,1),  & 
G0tensor(769),G0tensor(770),G0tensor(771),G0tensor(772),G0tensor(773))
  call Hotf_4pt_reduction_last(G1tensor(771),RedSet_4(31),mass4set(:,1),  & 
G0tensor(774),G0tensor(775),G0tensor(776),G0tensor(777),G0tensor(778))
  call Hotf_4pt_reduction_last(G1tensor(776),RedSet_4(34),mass4set(:,1),  & 
G0tensor(779),G0tensor(780),G0tensor(781),G0tensor(782),G0tensor(783))
  call Hotf_4pt_reduction_last(G1tensor(781),RedSet_4(93),mass4set(:,1),  & 
G0tensor(784),G0tensor(785),G0tensor(786),G0tensor(787),G0tensor(788))
  call Hotf_4pt_reduction_last(G1tensor(786),RedSet_4(94),mass4set(:,1),  & 
G0tensor(789),G0tensor(790),G0tensor(791),G0tensor(792),G0tensor(793))
  call Hotf_4pt_reduction_last(G1tensor(791),RedSet_4(95),mass4set(:,1),  & 
G0tensor(794),G0tensor(795),G0tensor(796),G0tensor(797),G0tensor(798))
  call Hotf_4pt_reduction_last(G1tensor(796),RedSet_4(41),mass4set(:,1),  & 
G0tensor(799),G0tensor(800),G0tensor(801),G0tensor(802),G0tensor(803))
  call Hotf_4pt_reduction_last(G1tensor(801),RedSet_4(42),mass4set(:,1),  & 
G0tensor(804),G0tensor(805),G0tensor(806),G0tensor(807),G0tensor(808))
  call Hotf_4pt_reduction_last(G1tensor(806),RedSet_4(44),mass4set(:,1),  & 
G0tensor(809),G0tensor(810),G0tensor(811),G0tensor(812),G0tensor(813))
  call Hotf_4pt_reduction_last(G1tensor(811),RedSet_4(46),mass4set(:,1),  & 
G0tensor(814),G0tensor(815),G0tensor(816),G0tensor(817),G0tensor(818))
  call Hotf_4pt_reduction_last(G1tensor(816),RedSet_4(147),mass4set(:,1),  & 
G0tensor(819),G0tensor(820),G0tensor(821),G0tensor(822),G0tensor(823))
  call Hotf_4pt_reduction_last(G1tensor(821),RedSet_4(148),mass4set(:,1),  & 
G0tensor(824),G0tensor(825),G0tensor(826),G0tensor(827),G0tensor(828))
  call Hotf_4pt_reduction_last(G1tensor(826),RedSet_4(54),mass4set(:,1),  & 
G0tensor(829),G0tensor(830),G0tensor(831),G0tensor(832),G0tensor(833))
  call Hotf_4pt_reduction_last(G1tensor(831),RedSet_4(55),mass4set(:,1),  & 
G0tensor(834),G0tensor(835),G0tensor(836),G0tensor(837),G0tensor(838))
  call Hotf_4pt_reduction_last(G1tensor(836),RedSet_4(161),mass4set(:,1),  & 
G0tensor(839),G0tensor(840),G0tensor(841),G0tensor(842),G0tensor(843))
  call Hotf_4pt_reduction_last(G1tensor(841),RedSet_4(183),mass4set(:,1),  & 
G0tensor(844),G0tensor(845),G0tensor(846),G0tensor(847),G0tensor(848))
  call Hotf_4pt_reduction_last(G1tensor(846),RedSet_4(68),mass4set(:,1),  & 
G0tensor(849),G0tensor(850),G0tensor(851),G0tensor(852),G0tensor(853))
  call Hotf_4pt_reduction_last(G1tensor(851),RedSet_4(69),mass4set(:,1),  & 
G0tensor(854),G0tensor(855),G0tensor(856),G0tensor(857),G0tensor(858))
  call Hotf_4pt_reduction_last(G1tensor(856),RedSet_4(173),mass4set(:,1),  & 
G0tensor(859),G0tensor(860),G0tensor(861),G0tensor(862),G0tensor(863))
  call Hotf_4pt_reduction_last(G1tensor(861),RedSet_4(174),mass4set(:,1),  & 
G0tensor(864),G0tensor(865),G0tensor(866),G0tensor(867),G0tensor(868))
  call Hotf_4pt_reduction_last(G1tensor(866),RedSet_4(76),mass4set(:,1),  & 
G0tensor(869),G0tensor(870),G0tensor(871),G0tensor(872),G0tensor(873))
  call Hotf_4pt_reduction_last(G1tensor(871),RedSet_4(77),mass4set(:,1),  & 
G0tensor(874),G0tensor(875),G0tensor(876),G0tensor(877),G0tensor(878))
  call Hotf_4pt_reduction_last(G1tensor(876),RedSet_4(160),mass4set(:,1),  & 
G0tensor(879),G0tensor(880),G0tensor(881),G0tensor(882),G0tensor(883))
  call Hotf_4pt_reduction_last(G1tensor(881),RedSet_4(162),mass4set(:,1),  & 
G0tensor(884),G0tensor(885),G0tensor(886),G0tensor(887),G0tensor(888))
  call Hotf_4pt_reduction_last(G1tensor(886),RedSet_4(85),mass4set(:,1),  & 
G0tensor(889),G0tensor(890),G0tensor(891),G0tensor(892),G0tensor(893))
  call Hotf_4pt_reduction_last(G1tensor(891),RedSet_4(86),mass4set(:,1),  & 
G0tensor(894),G0tensor(895),G0tensor(896),G0tensor(897),G0tensor(898))
  call Hotf_4pt_reduction_last(G1tensor(896),RedSet_4(97),mass4set(:,1),  & 
G0tensor(899),G0tensor(900),G0tensor(901),G0tensor(902),G0tensor(903))
  call Hotf_4pt_reduction_last(G1tensor(901),RedSet_4(98),mass4set(:,1),  & 
G0tensor(904),G0tensor(905),G0tensor(906),G0tensor(907),G0tensor(908))
  call Hotf_4pt_reduction_last(G1tensor(906),RedSet_4(101),mass4set(:,1),  & 
G0tensor(909),G0tensor(910),G0tensor(911),G0tensor(912),G0tensor(913))
  call Hotf_4pt_reduction_last(G1tensor(911),RedSet_4(107),mass4set(:,1),  & 
G0tensor(914),G0tensor(915),G0tensor(916),G0tensor(917),G0tensor(918))
  call Hotf_4pt_reduction_last(G1tensor(916),RedSet_4(108),mass4set(:,1),  & 
G0tensor(919),G0tensor(920),G0tensor(921),G0tensor(922),G0tensor(923))
  call Hotf_4pt_reduction_last(G1tensor(921),RedSet_4(109),mass4set(:,1),  & 
G0tensor(924),G0tensor(925),G0tensor(926),G0tensor(927),G0tensor(928))
  call Hotf_4pt_reduction_last(G1tensor(926),RedSet_4(112),mass4set(:,1),  & 
G0tensor(929),G0tensor(930),G0tensor(931),G0tensor(932),G0tensor(933))
  call Hotf_4pt_reduction_last(G1tensor(931),RedSet_4(113),mass4set(:,1),  & 
G0tensor(934),G0tensor(935),G0tensor(936),G0tensor(937),G0tensor(938))
  call Hotf_4pt_reduction_last(G1tensor(936),RedSet_4(115),mass4set(:,1),  & 
G0tensor(939),G0tensor(940),G0tensor(941),G0tensor(942),G0tensor(943))
  call Hotf_4pt_reduction_last(G1tensor(941),RedSet_4(124),mass4set(:,1),  & 
G0tensor(944),G0tensor(945),G0tensor(946),G0tensor(947),G0tensor(948))
  call Hotf_4pt_reduction_last(G1tensor(946),RedSet_4(125),mass4set(:,1),  & 
G0tensor(949),G0tensor(950),G0tensor(951),G0tensor(952),G0tensor(953))
  call Hotf_4pt_reduction_last(G1tensor(951),RedSet_4(133),mass4set(:,1),  & 
G0tensor(954),G0tensor(955),G0tensor(956),G0tensor(957),G0tensor(958))
  call Hotf_4pt_reduction_last(G1tensor(956),RedSet_4(134),mass4set(:,1),  & 
G0tensor(959),G0tensor(960),G0tensor(961),G0tensor(962),G0tensor(963))
  call Hotf_4pt_reduction_last(G1tensor(961),RedSet_4(135),mass4set(:,1),  & 
G0tensor(964),G0tensor(965),G0tensor(966),G0tensor(967),G0tensor(968))
  call Hotf_4pt_reduction_last(G1tensor(966),RedSet_4(138),mass4set(:,1),  & 
G0tensor(969),G0tensor(970),G0tensor(971),G0tensor(972),G0tensor(973))
  call Hotf_4pt_reduction_last(G1tensor(971),RedSet_4(139),mass4set(:,1),  & 
G0tensor(974),G0tensor(975),G0tensor(976),G0tensor(977),G0tensor(978))
  call Hotf_4pt_reduction_last(G1tensor(976),RedSet_4(150),mass4set(:,1),  & 
G0tensor(979),G0tensor(980),G0tensor(981),G0tensor(982),G0tensor(983))
  call Hotf_4pt_reduction_last(G1tensor(981),RedSet_4(151),mass4set(:,1),  & 
G0tensor(984),G0tensor(985),G0tensor(986),G0tensor(987),G0tensor(988))
  call Hotf_4pt_reduction_last(G1tensor(986),RedSet_4(154),mass4set(:,1),  & 
G0tensor(989),G0tensor(990),G0tensor(991),G0tensor(992),G0tensor(993))
  call Hotf_4pt_reduction_last(G1tensor(991),RedSet_4(164),mass4set(:,1),  & 
G0tensor(994),G0tensor(995),G0tensor(996),G0tensor(997),G0tensor(998))
  call Hotf_4pt_reduction_last(G1tensor(996),RedSet_4(165),mass4set(:,1),  & 
G0tensor(999),G0tensor(1000),G0tensor(1001),G0tensor(1002),G0tensor(1003))
  call Hotf_4pt_reduction_last(G1tensor(1001),RedSet_4(168),mass4set(:,1),  & 
G0tensor(1004),G0tensor(1005),G0tensor(1006),G0tensor(1007),G0tensor(1008))
  call Hotf_4pt_reduction_last(G1tensor(1006),RedSet_4(176),mass4set(:,1),  & 
G0tensor(1009),G0tensor(1010),G0tensor(1011),G0tensor(1012),G0tensor(1013))
  call Hotf_4pt_reduction_last(G1tensor(1011),RedSet_4(185),mass4set(:,1),  & 
G0tensor(1014),G0tensor(1015),G0tensor(1016),G0tensor(1017),G0tensor(1018))
  call Hotf_4pt_reduction_last(G1tensor(1016),RedSet_4(191),mass4set(:,1),  & 
G0tensor(1019),G0tensor(1020),G0tensor(1021),G0tensor(1022),G0tensor(1023))
  call Hotf_4pt_reduction_last(G1tensor(1021),RedSet_4(192),mass4set(:,1),  & 
G0tensor(1024),G0tensor(1025),G0tensor(1026),G0tensor(1027),G0tensor(1028))
  call Hotf_4pt_reduction_last(G1tensor(1026),RedSet_4(195),mass4set(:,1),  & 
G0tensor(1029),G0tensor(1030),G0tensor(1031),G0tensor(1032),G0tensor(1033))
  call Hotf_4pt_reduction_last(G1tensor(1031),RedSet_4(198),mass4set(:,1),  & 
G0tensor(1034),G0tensor(1035),G0tensor(1036),G0tensor(1037),G0tensor(1038))
  call Hotf_4pt_reduction_last(G1tensor(1036),RedSet_4(204),mass4set(:,1),  & 
G0tensor(1039),G0tensor(1040),G0tensor(1041),G0tensor(1042),G0tensor(1043))
  call Hotf_4pt_reduction_last(G1tensor(1041),RedSet_4(205),mass4set(:,1),  & 
G0tensor(1044),G0tensor(1045),G0tensor(1046),G0tensor(1047),G0tensor(1048))
  call Hotf_4pt_reduction_last(G1tensor(1046),RedSet_4(206),mass4set(:,1),  & 
G0tensor(1049),G0tensor(1050),G0tensor(1051),G0tensor(1052),G0tensor(1053))
  call Hotf_4pt_reduction_last(G1tensor(1051),RedSet_4(209),mass4set(:,1),  & 
G0tensor(1054),G0tensor(1055),G0tensor(1056),G0tensor(1057),G0tensor(1058))
  call Hotf_4pt_reduction_last(G1tensor(1056),RedSet_4(212),mass4set(:,1),  & 
G0tensor(1059),G0tensor(1060),G0tensor(1061),G0tensor(1062),G0tensor(1063))
  call Hotf_4pt_reduction_last(G1tensor(1061),RedSet_4(217),mass4set(:,1),  & 
G0tensor(1064),G0tensor(1065),G0tensor(1066),G0tensor(1067),G0tensor(1068))
  call Hotf_4pt_reduction_last(G1tensor(1066),RedSet_4(218),mass4set(:,1),  & 
G0tensor(1069),G0tensor(1070),G0tensor(1071),G0tensor(1072),G0tensor(1073))
  call Hotf_4pt_reduction_last(G1tensor(1071),RedSet_4(227),mass4set(:,1),  & 
G0tensor(1074),G0tensor(1075),G0tensor(1076),G0tensor(1077),G0tensor(1078))
  call Hotf_4pt_reduction_last(G1tensor(1076),RedSet_4(284),mass4set(:,1),  & 
G0tensor(1079),G0tensor(1080),G0tensor(1081),G0tensor(1082),G0tensor(1083))
  call Hotf_4pt_reduction_last(G1tensor(1081),RedSet_4(285),mass4set(:,1),  & 
G0tensor(1084),G0tensor(1085),G0tensor(1086),G0tensor(1087),G0tensor(1088))
  call Hotf_4pt_reduction_last(G1tensor(1086),RedSet_4(286),mass4set(:,1),  & 
G0tensor(1089),G0tensor(1090),G0tensor(1091),G0tensor(1092),G0tensor(1093))
  call Hotf_4pt_reduction_last(G1tensor(1091),RedSet_4(287),mass4set(:,1),  & 
G0tensor(1094),G0tensor(1095),G0tensor(1096),G0tensor(1097),G0tensor(1098))
  call Hotf_4pt_reduction_last(G1tensor(1096),RedSet_4(288),mass4set(:,1),  & 
G0tensor(1099),G0tensor(1100),G0tensor(1101),G0tensor(1102),G0tensor(1103))
  call Hotf_4pt_reduction_last(G1tensor(1101),RedSet_4(289),mass4set(:,1),  & 
G0tensor(1104),G0tensor(1105),G0tensor(1106),G0tensor(1107),G0tensor(1108))
  call Hotf_4pt_reduction_last(G1tensor(1106),RedSet_4(336),mass4set(:,1),  & 
G0tensor(1109),G0tensor(1110),G0tensor(1111),G0tensor(1112),G0tensor(1113))
  call Hotf_4pt_reduction_last(G1tensor(1111),RedSet_4(290),mass4set(:,1),  & 
G0tensor(1114),G0tensor(1115),G0tensor(1116),G0tensor(1117),G0tensor(1118))
  call Hotf_4pt_reduction_last(G1tensor(1116),RedSet_4(291),mass4set(:,1),  & 
G0tensor(1119),G0tensor(1120),G0tensor(1121),G0tensor(1122),G0tensor(1123))
  call Hotf_4pt_reduction_last(G1tensor(1121),RedSet_4(313),mass4set(:,1),  & 
G0tensor(1124),G0tensor(1125),G0tensor(1126),G0tensor(1127),G0tensor(1128))
  call Hotf_4pt_reduction_last(G1tensor(1126),RedSet_4(315),mass4set(:,1),  & 
G0tensor(1129),G0tensor(1130),G0tensor(1131),G0tensor(1132),G0tensor(1133))
  call Hotf_4pt_reduction_last(G1tensor(1131),RedSet_4(295),mass4set(:,1),  & 
G0tensor(1134),G0tensor(1135),G0tensor(1136),G0tensor(1137),G0tensor(1138))
  call Hotf_4pt_reduction_last(G1tensor(1136),RedSet_4(296),mass4set(:,1),  & 
G0tensor(1139),G0tensor(1140),G0tensor(1141),G0tensor(1142),G0tensor(1143))
  call Hotf_4pt_reduction_last(G1tensor(1141),RedSet_4(325),mass4set(:,1),  & 
G0tensor(1144),G0tensor(1145),G0tensor(1146),G0tensor(1147),G0tensor(1148))
  call Hotf_4pt_reduction_last(G1tensor(1146),RedSet_4(298),mass4set(:,1),  & 
G0tensor(1149),G0tensor(1150),G0tensor(1151),G0tensor(1152),G0tensor(1153))
  call Hotf_4pt_reduction_last(G1tensor(1151),RedSet_4(299),mass4set(:,1),  & 
G0tensor(1154),G0tensor(1155),G0tensor(1156),G0tensor(1157),G0tensor(1158))
  call Hotf_4pt_reduction_last(G1tensor(1156),RedSet_4(301),mass4set(:,1),  & 
G0tensor(1159),G0tensor(1160),G0tensor(1161),G0tensor(1162),G0tensor(1163))
  call Hotf_4pt_reduction_last(G1tensor(1161),RedSet_4(303),mass4set(:,1),  & 
G0tensor(1164),G0tensor(1165),G0tensor(1166),G0tensor(1167),G0tensor(1168))
  call Hotf_4pt_reduction_last(G1tensor(1166),RedSet_4(305),mass4set(:,1),  & 
G0tensor(1169),G0tensor(1170),G0tensor(1171),G0tensor(1172),G0tensor(1173))
  call Hotf_4pt_reduction_last(G1tensor(1171),RedSet_4(306),mass4set(:,1),  & 
G0tensor(1174),G0tensor(1175),G0tensor(1176),G0tensor(1177),G0tensor(1178))
  call Hotf_4pt_reduction_last(G1tensor(1176),RedSet_4(308),mass4set(:,1),  & 
G0tensor(1179),G0tensor(1180),G0tensor(1181),G0tensor(1182),G0tensor(1183))
  call Hotf_4pt_reduction_last(G1tensor(1181),RedSet_4(309),mass4set(:,1),  & 
G0tensor(1184),G0tensor(1185),G0tensor(1186),G0tensor(1187),G0tensor(1188))
  call Hotf_4pt_reduction_last(G1tensor(1186),RedSet_4(311),mass4set(:,1),  & 
G0tensor(1189),G0tensor(1190),G0tensor(1191),G0tensor(1192),G0tensor(1193))
  call Hotf_4pt_reduction_last(G1tensor(1191),RedSet_4(319),mass4set(:,1),  & 
G0tensor(1194),G0tensor(1195),G0tensor(1196),G0tensor(1197),G0tensor(1198))
  call Hotf_4pt_reduction_last(G1tensor(1196),RedSet_4(321),mass4set(:,1),  & 
G0tensor(1199),G0tensor(1200),G0tensor(1201),G0tensor(1202),G0tensor(1203))
  call ol_merge_tensors(T0sum(1),[G0tensor(4)])
  call ol_merge_tensors(T0sum(2),[G0tensor(9)])
  call ol_merge_tensors(T0sum(3),[G0tensor(14)])
  call ol_merge_tensors(T0sum(4),[G0tensor(19)])
  call ol_merge_tensors(T0sum(5),[G0tensor(24)])
  call ol_merge_tensors(T0sum(6),[G0tensor(29)])
  call ol_merge_tensors(T0sum(7),[G0tensor(34)])
  call ol_merge_tensors(T0sum(8),[G0tensor(39)])
  call ol_merge_tensors(T0sum(9),[G0tensor(44)])
  call ol_merge_tensors(T0sum(10),[G0tensor(49)])
  call ol_merge_tensors(T0sum(11),[G0tensor(54)])
  call ol_merge_tensors(T0sum(12),[G0tensor(59)])
  call ol_merge_tensors(T0sum(13),[G0tensor(64)])
  call ol_merge_tensors(T0sum(14),[G0tensor(69)])
  call ol_merge_tensors(T0sum(15),[G0tensor(74)])
  call ol_merge_tensors(T0sum(16),[G0tensor(79)])
  call ol_merge_tensors(T0sum(17),[G0tensor(84)])
  call ol_merge_tensors(T0sum(18),[G0tensor(89)])
  call ol_merge_tensors(T0sum(19),[G0tensor(94)])
  call ol_merge_tensors(T0sum(20),[G0tensor(99)])
  call ol_merge_tensors(T0sum(21),[G0tensor(104)])
  call ol_merge_tensors(T0sum(22),[G0tensor(109)])
  call ol_merge_tensors(T0sum(23),[G0tensor(114)])
  call ol_merge_tensors(T0sum(24),[G0tensor(119)])
  call ol_merge_tensors(T0sum(25),[G0tensor(124)])
  call ol_merge_tensors(T0sum(26),[G0tensor(129)])
  call ol_merge_tensors(T0sum(27),[G0tensor(134)])
  call ol_merge_tensors(T0sum(28),[G0tensor(139)])
  call ol_merge_tensors(T0sum(29),[G0tensor(144)])
  call ol_merge_tensors(T0sum(30),[G0tensor(149)])
  call ol_merge_tensors(T0sum(31),[G0tensor(154)])
  call ol_merge_tensors(T0sum(32),[G0tensor(159)])
  call ol_merge_tensors(T0sum(33),[G0tensor(164)])
  call ol_merge_tensors(T0sum(34),[G0tensor(169)])
  call ol_merge_tensors(T0sum(35),[G0tensor(174)])
  call ol_merge_tensors(T0sum(36),[G0tensor(179)])
  call ol_merge_tensors(T0sum(37),[G0tensor(184)])
  call ol_merge_tensors(T0sum(38),[G0tensor(189)])
  call ol_merge_tensors(T0sum(39),[G0tensor(194)])
  call ol_merge_tensors(T0sum(40),[G0tensor(199)])
  call ol_merge_tensors(T0sum(41),[G0tensor(204)])
  call ol_merge_tensors(T0sum(42),[G0tensor(209)])
  call ol_merge_tensors(T0sum(43),[G0tensor(214)])
  call ol_merge_tensors(T0sum(44),[G0tensor(219)])
  call ol_merge_tensors(T0sum(45),[G0tensor(224)])
  call ol_merge_tensors(T0sum(46),[G0tensor(229)])
  call ol_merge_tensors(T0sum(47),[G0tensor(234)])
  call ol_merge_tensors(T0sum(48),[G0tensor(239)])
  call ol_merge_tensors(T0sum(49),[G0tensor(244)])
  call ol_merge_tensors(T0sum(50),[G0tensor(249)])
  call ol_merge_tensors(T0sum(51),[G0tensor(254)])
  call ol_merge_tensors(T0sum(52),[G0tensor(259)])
  call ol_merge_tensors(T0sum(53),[G0tensor(264)])
  call ol_merge_tensors(T0sum(54),[G0tensor(269)])
  call ol_merge_tensors(T0sum(55),[G0tensor(274)])
  call ol_merge_tensors(T0sum(56),[G0tensor(279)])
  call ol_merge_tensors(T0sum(57),[G0tensor(284)])
  call ol_merge_tensors(T0sum(58),[G0tensor(289)])
  call ol_merge_tensors(T0sum(59),[G0tensor(294)])
  call ol_merge_tensors(T0sum(60),[G0tensor(299)])
  call ol_merge_tensors(T0sum(61),[G0tensor(304)])
  call ol_merge_tensors(T0sum(62),[G0tensor(309)])
  call ol_merge_tensors(T0sum(63),[G0tensor(314)])
  call ol_merge_tensors(T0sum(64),[G0tensor(319)])
  call ol_merge_tensors(T0sum(65),[G0tensor(324)])
  call ol_merge_tensors(T0sum(66),[G0tensor(329)])
  call ol_merge_tensors(T0sum(67),[G0tensor(334)])
  call ol_merge_tensors(T0sum(68),[G0tensor(339)])
  call ol_merge_tensors(T0sum(69),[G0tensor(344)])
  call ol_merge_tensors(T0sum(70),[G0tensor(349)])
  call ol_merge_tensors(T0sum(71),[G0tensor(354)])
  call ol_merge_tensors(T0sum(72),[G0tensor(359)])
  call ol_merge_tensors(T0sum(73),[G0tensor(364)])
  call ol_merge_tensors(T0sum(74),[G0tensor(369)])
  call ol_merge_tensors(T0sum(75),[G0tensor(374)])
  call ol_merge_tensors(T0sum(76),[G0tensor(379)])
  call ol_merge_tensors(T0sum(77),[G0tensor(384)])
  call ol_merge_tensors(T0sum(78),[G0tensor(389)])
  call ol_merge_tensors(T0sum(79),[G0tensor(394)])
  call ol_merge_tensors(T0sum(80),[G0tensor(399)])
  call ol_merge_tensors(T0sum(81),[G0tensor(404)])
  call ol_merge_tensors(T0sum(82),[G0tensor(409)])
  call ol_merge_tensors(T0sum(83),[G0tensor(414)])
  call ol_merge_tensors(T0sum(84),[G0tensor(419)])
  call ol_merge_tensors(T0sum(85),[G0tensor(424)])
  call ol_merge_tensors(T0sum(86),[G0tensor(429)])
  call ol_merge_tensors(T0sum(87),[G0tensor(434)])
  call ol_merge_tensors(T0sum(88),[G0tensor(439)])
  call ol_merge_tensors(T0sum(89),[G0tensor(444)])
  call ol_merge_tensors(T0sum(90),[G0tensor(449)])
  call ol_merge_tensors(T0sum(91),[G0tensor(454)])
  call ol_merge_tensors(T0sum(92),[G0tensor(459)])
  call ol_merge_tensors(T0sum(93),[G0tensor(464)])
  call ol_merge_tensors(T0sum(94),[G0tensor(469)])
  call ol_merge_tensors(T0sum(95),[G0tensor(474)])
  call ol_merge_tensors(T0sum(96),[G0tensor(479)])
  call ol_merge_tensors(T0sum(97),[G0tensor(484)])
  call ol_merge_tensors(T0sum(98),[G0tensor(489)])
  call ol_merge_tensors(T0sum(99),[G0tensor(494)])
  call ol_merge_tensors(T0sum(100),[G0tensor(499)])
  call ol_merge_tensors(T0sum(101),[G0tensor(504)])
  call ol_merge_tensors(T0sum(102),[G0tensor(509)])
  call ol_merge_tensors(T0sum(103),[G0tensor(514)])
  call ol_merge_tensors(T0sum(104),[G0tensor(519)])
  call ol_merge_tensors(T0sum(105),[G0tensor(524)])
  call ol_merge_tensors(T0sum(106),[G0tensor(529)])
  call ol_merge_tensors(T0sum(107),[G0tensor(534)])
  call ol_merge_tensors(T0sum(108),[G0tensor(539)])
  call ol_merge_tensors(T0sum(109),[G0tensor(544)])
  call ol_merge_tensors(T0sum(110),[G0tensor(549)])
  call ol_merge_tensors(T0sum(111),[G0tensor(554)])
  call ol_merge_tensors(T0sum(112),[G0tensor(559)])
  call ol_merge_tensors(T0sum(113),[G0tensor(564)])
  call ol_merge_tensors(T0sum(114),[G0tensor(569)])
  call ol_merge_tensors(T0sum(115),[G0tensor(574)])
  call ol_merge_tensors(T0sum(116),[G0tensor(579)])
  call ol_merge_tensors(T0sum(117),[G0tensor(584)])
  call ol_merge_tensors(T0sum(118),[G0tensor(589)])
  call ol_merge_tensors(T0sum(119),[G0tensor(594)])
  call ol_merge_tensors(T0sum(120),[G0tensor(599)])
  call ol_merge_tensors(T0sum(121),[G0tensor(604)])
  call ol_merge_tensors(T0sum(122),[G0tensor(609)])
  call ol_merge_tensors(T0sum(123),[G0tensor(614)])
  call ol_merge_tensors(T0sum(124),[G0tensor(619)])
  call ol_merge_tensors(T0sum(125),[G0tensor(624)])
  call ol_merge_tensors(T0sum(126),[G0tensor(629)])
  call ol_merge_tensors(T0sum(127),[G0tensor(634)])
  call ol_merge_tensors(T0sum(128),[G0tensor(639)])
  call ol_merge_tensors(T0sum(129),[G0tensor(644)])
  call ol_merge_tensors(T0sum(130),[G0tensor(649)])
  call ol_merge_tensors(T0sum(131),[G0tensor(654)])
  call ol_merge_tensors(T0sum(132),[G0tensor(659)])
  call ol_merge_tensors(T0sum(133),[G0tensor(664)])
  call ol_merge_tensors(T0sum(134),[G0tensor(669)])
  call ol_merge_tensors(T0sum(135),[G0tensor(674)])
  call ol_merge_tensors(T0sum(136),[G0tensor(679)])
  call ol_merge_tensors(T0sum(137),[G0tensor(684)])
  call ol_merge_tensors(T0sum(138),[G0tensor(689)])
  call ol_merge_tensors(T0sum(139),[G0tensor(694)])
  call ol_merge_tensors(T0sum(140),[G0tensor(699)])
  call ol_merge_tensors(T0sum(141),[G0tensor(704)])
  call ol_merge_tensors(T0sum(142),[G0tensor(709)])
  call ol_merge_tensors(T0sum(143),[G0tensor(714)])
  call ol_merge_tensors(T0sum(144),[G0tensor(719)])
  call ol_merge_tensors(T0sum(145),[G0tensor(724)])
  call ol_merge_tensors(T0sum(146),[G0tensor(729)])
  call ol_merge_tensors(T0sum(147),[G0tensor(734)])
  call ol_merge_tensors(T0sum(148),[G0tensor(739)])
  call ol_merge_tensors(T0sum(149),[G0tensor(744)])
  call ol_merge_tensors(T0sum(150),[G0tensor(749)])
  call ol_merge_tensors(T0sum(151),[G0tensor(754)])
  call ol_merge_tensors(T0sum(152),[G0tensor(759)])
  call ol_merge_tensors(T0sum(153),[G0tensor(764)])
  call ol_merge_tensors(T0sum(154),[G0tensor(769)])
  call ol_merge_tensors(T0sum(155),[G0tensor(774)])
  call ol_merge_tensors(T0sum(156),[G0tensor(779)])
  call ol_merge_tensors(T0sum(157),[G0tensor(784)])
  call ol_merge_tensors(T0sum(158),[G0tensor(789)])
  call ol_merge_tensors(T0sum(159),[G0tensor(794)])
  call ol_merge_tensors(T0sum(160),[G0tensor(799)])
  call ol_merge_tensors(T0sum(161),[G0tensor(804)])
  call ol_merge_tensors(T0sum(162),[G0tensor(809)])
  call ol_merge_tensors(T0sum(163),[G0tensor(814)])
  call ol_merge_tensors(T0sum(164),[G0tensor(819)])
  call ol_merge_tensors(T0sum(165),[G0tensor(824)])
  call ol_merge_tensors(T0sum(166),[G0tensor(829)])
  call ol_merge_tensors(T0sum(167),[G0tensor(834)])
  call ol_merge_tensors(T0sum(168),[G0tensor(839)])
  call ol_merge_tensors(T0sum(169),[G0tensor(844)])
  call ol_merge_tensors(T0sum(170),[G0tensor(849)])
  call ol_merge_tensors(T0sum(171),[G0tensor(854)])
  call ol_merge_tensors(T0sum(172),[G0tensor(859)])
  call ol_merge_tensors(T0sum(173),[G0tensor(864)])
  call ol_merge_tensors(T0sum(174),[G0tensor(869)])
  call ol_merge_tensors(T0sum(175),[G0tensor(874)])
  call ol_merge_tensors(T0sum(176),[G0tensor(879)])
  call ol_merge_tensors(T0sum(177),[G0tensor(884)])
  call ol_merge_tensors(T0sum(178),[G0tensor(889)])
  call ol_merge_tensors(T0sum(179),[G0tensor(894)])
  call ol_merge_tensors(T0sum(180),[G0tensor(899)])
  call ol_merge_tensors(T0sum(181),[G0tensor(904)])
  call ol_merge_tensors(T0sum(182),[G0tensor(909)])
  call ol_merge_tensors(T0sum(183),[G0tensor(914)])
  call ol_merge_tensors(T0sum(184),[G0tensor(919)])
  call ol_merge_tensors(T0sum(185),[G0tensor(924)])
  call ol_merge_tensors(T0sum(186),[G0tensor(929)])
  call ol_merge_tensors(T0sum(187),[G0tensor(934)])
  call ol_merge_tensors(T0sum(188),[G0tensor(939)])
  call ol_merge_tensors(T0sum(189),[G0tensor(944)])
  call ol_merge_tensors(T0sum(190),[G0tensor(949)])
  call ol_merge_tensors(T0sum(191),[G0tensor(954)])
  call ol_merge_tensors(T0sum(192),[G0tensor(959)])
  call ol_merge_tensors(T0sum(193),[G0tensor(964)])
  call ol_merge_tensors(T0sum(194),[G0tensor(969)])
  call ol_merge_tensors(T0sum(195),[G0tensor(974)])
  call ol_merge_tensors(T0sum(196),[G0tensor(979)])
  call ol_merge_tensors(T0sum(197),[G0tensor(984)])
  call ol_merge_tensors(T0sum(198),[G0tensor(989)])
  call ol_merge_tensors(T0sum(199),[G0tensor(994)])
  call ol_merge_tensors(T0sum(200),[G0tensor(999)])
  call ol_merge_tensors(T0sum(201),[G0tensor(1004)])
  call ol_merge_tensors(T0sum(202),[G0tensor(1009)])
  call ol_merge_tensors(T0sum(203),[G0tensor(1014)])
  call ol_merge_tensors(T0sum(204),[G0tensor(1019)])
  call ol_merge_tensors(T0sum(205),[G0tensor(1024)])
  call ol_merge_tensors(T0sum(206),[G0tensor(1029)])
  call ol_merge_tensors(T0sum(207),[G0tensor(1034)])
  call ol_merge_tensors(T0sum(208),[G0tensor(1039)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1044)])
  call ol_merge_tensors(T0sum(210),[G0tensor(1049)])
  call ol_merge_tensors(T0sum(211),[G0tensor(1054)])
  call ol_merge_tensors(T0sum(212),[G0tensor(1059)])
  call ol_merge_tensors(T0sum(213),[G0tensor(1064)])
  call ol_merge_tensors(T0sum(214),[G0tensor(1069)])
  call ol_merge_tensors(T0sum(215),[G0tensor(1074)])
  call ol_merge_tensors(T0sum(216),[G0tensor(1079)])
  call ol_merge_tensors(T0sum(217),[G0tensor(1084)])
  call ol_merge_tensors(T0sum(218),[G0tensor(1089)])
  call ol_merge_tensors(T0sum(219),[G0tensor(1094)])
  call ol_merge_tensors(T0sum(220),[G0tensor(1099)])
  call ol_merge_tensors(T0sum(221),[G0tensor(1104)])
  call ol_merge_tensors(T0sum(222),[G0tensor(1109)])
  call ol_merge_tensors(T0sum(223),[G0tensor(1114)])
  call ol_merge_tensors(T0sum(224),[G0tensor(1119)])
  call ol_merge_tensors(T0sum(225),[G0tensor(1124)])
  call ol_merge_tensors(T0sum(226),[G0tensor(1129)])
  call ol_merge_tensors(T0sum(227),[G0tensor(1134)])
  call ol_merge_tensors(T0sum(228),[G0tensor(1139)])
  call ol_merge_tensors(T0sum(229),[G0tensor(1144)])
  call ol_merge_tensors(T0sum(230),[G0tensor(1149)])
  call ol_merge_tensors(T0sum(231),[G0tensor(1154)])
  call ol_merge_tensors(T0sum(232),[G0tensor(1159)])
  call ol_merge_tensors(T0sum(233),[G0tensor(1164)])
  call ol_merge_tensors(T0sum(234),[G0tensor(1169)])
  call ol_merge_tensors(T0sum(235),[G0tensor(1174)])
  call ol_merge_tensors(T0sum(236),[G0tensor(1179)])
  call ol_merge_tensors(T0sum(237),[G0tensor(1184)])
  call ol_merge_tensors(T0sum(238),[G0tensor(1189)])
  call ol_merge_tensors(T0sum(239),[G0tensor(1194)])
  call ol_merge_tensors(T0sum(240),[G0tensor(1199)])
  call ol_merge_tensors(T0sum(241),[G0tensor(1)])
  call ol_merge_tensors(T0sum(242),[G0tensor(2)])
  call ol_merge_tensors(T0sum(243),[G0tensor(3)])
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[35,8,20],[0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(5),m4h2x4x8(:,5),heltab3x64(:,:,7))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[35,8,20],[0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(4),m4h4x2x8(:,3),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[35,8,20],[0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(11),m4h2x4x8(:,6),heltab3x64(:,:,9))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[35,4,24],[0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(12),m4h2x4x8(:,7),heltab3x64(:,:,10))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[35,4,24],[0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(7),m4h4x2x8(:,4),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[35,4,24],[0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(8),m4h2x4x8(:,8),heltab3x64(:,:,12))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[44,2,17],[0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(13),m4h2x4x8(:,9),heltab3x64(:,:,13))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[44,2,17],[0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,12),ex6(:),G0H8(14),m4h4x2x8(:,5),heltab3x64(:,:,14))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[44,2,17],[0,0,0],4,2,wf4(:,12),wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(9),m4h2x4x8(:,10),heltab3x64(:,:,15))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[44,1,18],[0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(10),m4h2x4x8(:,11),heltab3x64(:,:,16))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[44,1,18],[0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,12),ex6(:),G0H8(3),m4h4x2x8(:,6),heltab3x64(:,:,17))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[44,1,18],[0,0,0],4,2,wf4(:,12),wf4(:,18))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(2),m4h2x4x8(:,12),heltab3x64(:,:,18))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[51,4,8],[0,0,0],4,1,wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,12),G0H4(1),m4h2x8x4(:,1),heltab3x64(:,:,19))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[51,4,8],[0,0,0],4,1,wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,12),ex6(:),G0H4(2),m4h8x2x4(:,1),heltab3x64(:,:,20))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[51,4,8],[0,0,0],4,1,wf8(:,12))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,12),G0H4(3),m4h2x8x4(:,2),heltab3x64(:,:,21))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[51,4,8],[0,0,0],4,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,17),G0H4(4),m4h2x8x4(:,3),heltab3x64(:,:,22))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[51,4,8],[0,0,0],4,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,17),ex6(:),G0H4(5),m4h8x2x4(:,2),heltab3x64(:,:,23))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[51,4,8],[0,0,0],4,1,wf8(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,17),G0H4(6),m4h2x8x4(:,4),heltab3x64(:,:,24))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[60,1,2],[0,0,0],4,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,4),G0H4(7),m4h2x8x4(:,5),heltab3x64(:,:,25))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[60,1,2],[0,0,0],4,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,4),ex6(:),G0H4(8),m4h8x2x4(:,3),heltab3x64(:,:,26))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[60,1,2],[0,0,0],4,1,wf8(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,4),G0H4(9),m4h2x8x4(:,6),heltab3x64(:,:,27))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[60,1,2],[0,0,0],4,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,9),G0H4(10),m4h2x8x4(:,7),heltab3x64(:,:,28))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[60,1,2],[0,0,0],4,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,9),ex6(:),G0H4(11),m4h8x2x4(:,4),heltab3x64(:,:,29))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[60,1,2],[0,0,0],4,1,wf8(:,9))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,9),G0H4(12),m4h2x8x4(:,8),heltab3x64(:,:,30))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[35,12,16],[0,0,0],3,2,wf8(:,5),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(1),m3h8x8(:,35),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(36),n2h8(208))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[35,12,16],[0,0,0],3,2,wf8(:,5),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(6),m3h8x8(:,36),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(33),n2h8(209))
  Gcoeff(:)%j = (c(21)*(-M(2,:)%j+M(3,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[35,12,16],[0,0,0],3,2,wf8(:,5),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(1),m3h8x8(:,37),heltab2x64(:,:,237))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(34),n2h8(210))
  Gcoeff(:)%j = (c(21)*(-M(2,:)%j+M(3,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[35,12,16],[0,0,0],3,2,wf8(:,5),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(6),m3h8x8(:,38),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(39),n2h8(211))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[44,3,16],[0,0,0],3,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,39),heltab2x64(:,:,239))
  call Hloop_Q_A(ntryL,G0H8(1),44,0,G1H8(40),n2h8(212))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[44,3,16],[0,0,0],3,2,wf8(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,13),G0H8(6),m3h8x8(:,40),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(6),44,0,G1H8(9),n2h8(213))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[44,3,16],[0,0,0],3,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,41),heltab2x64(:,:,241))
  call Hloop_Q_A(ntryL,G0H8(1),44,0,G1H8(17),n2h8(214))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[44,3,16],[0,0,0],3,2,wf8(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,13),G0H8(6),m3h8x8(:,42),heltab2x64(:,:,242))
  call Hloop_A_Q(ntryL,G0H8(6),44,0,G1H8(31),n2h8(215))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,15,16],[0,0,0],3,1,wf16(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,149),heltab2x64(:,:,243))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(89))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,15,16],[0,0,0],3,1,wf16(:,35))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,150),heltab2x64(:,:,244))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(90))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,15,16],[0,0,0],3,1,wf16(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,151),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(91))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,15,16],[0,0,0],3,1,wf16(:,35))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,152),heltab2x64(:,:,246))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(92))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[40,3,20],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,53),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(4),n2h16(91))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[40,3,20],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,54),heltab2x64(:,:,248))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,11,20],[0,0,0],3,2,wf8(:,3),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,153),heltab2x64(:,:,249))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(93))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,11,20],[0,0,0],3,2,wf8(:,3),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,154),heltab2x64(:,:,250))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[35,8,20],[0,0,0],3,2,wf8(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(1),m3h8x8(:,43),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(1),n2h8(216))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[35,8,20],[0,0,0],3,2,wf8(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(3),m3h8x8(:,44),heltab2x64(:,:,252))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,155),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(94))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,156),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(95))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,157),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(96))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,158),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(97))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(11),m3h2x32(:,159),heltab2x64(:,:,257))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,160),heltab2x64(:,:,258))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,161),heltab2x64(:,:,259))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[52,3,8],[0,0,0],3,2,wf8(:,34),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,34),G0H8(6),m3h8x8(:,45),heltab2x64(:,:,260))
  call Hloop_Q_A(ntryL,G0H8(6),52,0,G1H8(28),n2h8(217))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[52,3,8],[0,0,0],3,2,wf8(:,34),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,34),G0H8(1),m3h8x8(:,46),heltab2x64(:,:,261))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,8,23],[0,0,0],3,1,wf16(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,162),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(98))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,8,23],[0,0,0],3,1,wf16(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,163),heltab2x64(:,:,263))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[36,3,24],[0,0,0],3,3,wf4(:,8),wf4(:,1),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,55),heltab2x64(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(4),36,0,G1H16(9),n2h16(92))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[36,3,24],[0,0,0],3,3,wf4(:,8),wf4(:,1),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,56),heltab2x64(:,:,265))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,7,24],[0,0,0],3,2,wf8(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,164),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(99))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,7,24],[0,0,0],3,2,wf8(:,8),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(17),m3h2x32(:,165),heltab2x64(:,:,267))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[35,4,24],[0,0,0],3,2,wf8(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(6),m3h8x8(:,47),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(26),n2h8(218))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[35,4,24],[0,0,0],3,2,wf8(:,5),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(24),m3h8x8(:,48),heltab2x64(:,:,269))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,166),heltab2x64(:,:,270))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(100))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,167),heltab2x64(:,:,271))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(101))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,168),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(102))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,169),heltab2x64(:,:,273))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(103))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(22),m3h2x32(:,170),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,171),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,172),heltab2x64(:,:,276))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[56,3,4],[0,0,0],3,2,wf8(:,41),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,41),G0H8(6),m3h8x8(:,49),heltab2x64(:,:,277))
  call Hloop_A_Q(ntryL,G0H8(6),56,0,G1H8(37),n2h8(219))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[56,3,4],[0,0,0],3,2,wf8(:,41),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,41),G0H8(6),m3h8x8(:,50),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,4,27],[0,0,0],3,1,wf16(:,25))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,173),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(104))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,4,27],[0,0,0],3,1,wf16(:,25))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,174),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[36,11,16],[0,0,0],3,2,wf4(:,8),wf8(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,57),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[44,3,16],[0,0,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(15),m3h8x8(:,51),heltab2x64(:,:,282))
  call Hloop_Q_A(ntryL,G0H8(15),44,0,G1H8(38),n2h8(220))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[44,3,16],[0,0,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,23),G0H8(15),m3h8x8(:,52),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G0H8(15),44,0,G1H8(55),n2h8(221))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(4,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[44,3,16],[0,0,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(15),m3h8x8(:,53),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H8(15),44,0,G1H8(56),n2h8(222))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(4,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[44,3,16],[0,0,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,23),G0H8(15),m3h8x8(:,54),heltab2x64(:,:,285))
  call Hloop_A_Q(ntryL,G0H8(15),44,0,G1H8(58),n2h8(223))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[52,3,8],[0,0,0],3,2,wf8(:,35),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,35),G0H8(15),m3h8x8(:,55),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G0H8(15),52,0,G1H8(61),n2h8(224))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[52,3,8],[0,0,0],3,2,wf8(:,35),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,35),G0H8(15),m3h8x8(:,56),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[39,8,16],[0,0,0],3,1,wf16(:,26))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,26),G0H4(13),m3h16x4(:,1),heltab2x64(:,:,288))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[40,7,16],[0,0,0],3,2,wf4(:,5),wf8(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,58),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(16),m3h8x8(:,57),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G0H8(16),44,0,G1H8(62),n2h8(225))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,24),G0H8(16),m3h8x8(:,58),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G0H8(16),44,0,G1H8(12),n2h8(226))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(4,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(16),m3h8x8(:,59),heltab2x64(:,:,292))
  call Hloop_Q_A(ntryL,G0H8(16),44,0,G1H8(67),n2h8(227))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(4,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,24),G0H8(16),m3h8x8(:,60),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G0H8(16),44,0,G1H8(68),n2h8(228))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[56,3,4],[0,0,0],3,2,wf8(:,42),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(16),m3h8x8(:,61),heltab2x64(:,:,294))
  call Hloop_A_Q(ntryL,G0H8(16),56,0,G1H8(8),n2h8(229))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[56,3,4],[0,0,0],3,2,wf8(:,42),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(16),m3h8x8(:,62),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[43,4,16],[0,0,0],3,1,wf16(:,21))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,21),G0H4(14),m3h16x4(:,2),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,15,16],[0,0,0],3,1,wf16(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,175),heltab2x64(:,:,297))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(105))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,15,16],[0,0,0],3,1,wf16(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,176),heltab2x64(:,:,298))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(106))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(4,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,15,16],[0,0,0],3,1,wf16(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,177),heltab2x64(:,:,299))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(107))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(4,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,15,16],[0,0,0],3,1,wf16(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,178),heltab2x64(:,:,300))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(108))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,8,23],[0,0,0],3,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,179),heltab2x64(:,:,301))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(109))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,8,23],[0,0,0],3,1,wf16(:,38))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,180),heltab2x64(:,:,302))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[39,8,16],[0,0,0],3,1,wf16(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,40),G0H4(15),m3h16x4(:,3),heltab2x64(:,:,303))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,181),heltab2x64(:,:,304))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(110))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,182),heltab2x64(:,:,305))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(111))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,183),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(112))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,184),heltab2x64(:,:,307))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(36),n2h32(113))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,4,27],[0,0,0],3,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,185),heltab2x64(:,:,308))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(114))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[32,4,27],[0,0,0],3,1,wf16(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,186),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[43,4,16],[0,0,0],3,1,wf16(:,45))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,45),G0H4(16),m3h16x4(:,4),heltab2x64(:,:,310))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(3,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[39,8,16],[0,0,0],3,1,wf16(:,47))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,47),G0H4(17),m3h16x4(:,5),heltab2x64(:,:,311))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(3,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[43,4,16],[0,0,0],3,1,wf16(:,49))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,49),G0H4(18),m3h16x4(:,6),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[34,12,17],[0,0,0],3,3,wf4(:,14),wf4(:,12),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(9),m3h4x16(:,59),heltab2x64(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(9),34,0,G1H16(35),n2h16(93))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[34,12,17],[0,0,0],3,3,wf4(:,14),wf4(:,12),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(10),m3h4x16(:,60),heltab2x64(:,:,314))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,187),heltab2x64(:,:,315))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(39),n2h32(115))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,188),heltab2x64(:,:,316))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(116))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,189),heltab2x64(:,:,317))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(41),n2h32(117))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,190),heltab2x64(:,:,318))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(42),n2h32(118))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,191),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(44),m3h2x32(:,192),heltab2x64(:,:,320))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,193),heltab2x64(:,:,321))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[49,2,12],[0,0,0],3,2,wf8(:,61),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,61),G0H8(17),m3h8x8(:,63),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[49,2,12],[0,0,0],3,2,wf8(:,61),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,61),G0H8(18),m3h8x8(:,64),heltab2x64(:,:,323))
  call Hloop_Q_A(ntryL,G0H8(18),49,0,G1H8(13),n2h8(230))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,14,17],[0,0,0],3,2,wf8(:,16),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,194),heltab2x64(:,:,324))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(46),n2h32(119))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,14,17],[0,0,0],3,2,wf8(:,16),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,195),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[44,2,17],[0,0,0],3,2,wf8(:,13),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(18),m3h8x8(:,65),heltab2x64(:,:,326))
  call Hloop_Q_A(ntryL,G0H8(18),44,0,G1H8(11),n2h8(231))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[44,2,17],[0,0,0],3,2,wf8(:,13),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(43),m3h8x8(:,66),heltab2x64(:,:,327))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,2,29],[0,0,0],3,1,wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,196),heltab2x64(:,:,328))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(48),n2h32(120))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,2,29],[0,0,0],3,1,wf16(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,197),heltab2x64(:,:,329))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[33,12,18],[0,0,0],3,3,wf4(:,17),wf4(:,12),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(11),m3h4x16(:,61),heltab2x64(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(11),n2h16(94))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[33,12,18],[0,0,0],3,3,wf4(:,17),wf4(:,12),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(12),m3h4x16(:,62),heltab2x64(:,:,331))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,198),heltab2x64(:,:,332))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(50),n2h32(121))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,199),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(122))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,200),heltab2x64(:,:,334))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(52),n2h32(123))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,201),heltab2x64(:,:,335))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(124))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,202),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(55),m3h2x32(:,203),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,12,19],[0,0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,204),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,13,18],[0,0,0],3,2,wf8(:,20),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,205),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(57),n2h32(125))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,13,18],[0,0,0],3,2,wf8(:,20),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,206),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[50,1,12],[0,0,0],3,2,wf8(:,71),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(18),m3h8x8(:,67),heltab2x64(:,:,341))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[50,1,12],[0,0,0],3,2,wf8(:,71),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,71),G0H8(19),m3h8x8(:,68),heltab2x64(:,:,342))
  call Hloop_A_Q(ntryL,G0H8(19),50,0,G1H8(35),n2h8(232))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[44,1,18],[0,0,0],3,2,wf8(:,13),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,13),G0H8(19),m3h8x8(:,69),heltab2x64(:,:,343))
  call Hloop_A_Q(ntryL,G0H8(19),44,0,G1H8(120),n2h8(233))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[44,1,18],[0,0,0],3,2,wf8(:,13),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(64),m3h8x8(:,70),heltab2x64(:,:,344))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,1,30],[0,0,0],3,1,wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,207),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(126))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,1,30],[0,0,0],3,1,wf16(:,32))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,208),heltab2x64(:,:,346))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[35,12,16],[0,0,0],3,2,wf8(:,25),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,25),G0H8(19),m3h8x8(:,71),heltab2x64(:,:,347))
  call Hloop_A_Q(ntryL,G0H8(19),35,0,G1H8(6),n2h8(234))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[35,12,16],[0,0,0],3,2,wf8(:,25),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(19),m3h8x8(:,72),heltab2x64(:,:,348))
  call Hloop_Q_A(ntryL,G0H8(19),35,0,G1H8(73),n2h8(235))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(3,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[35,12,16],[0,0,0],3,2,wf8(:,25),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,25),G0H8(19),m3h8x8(:,73),heltab2x64(:,:,349))
  call Hloop_A_Q(ntryL,G0H8(19),35,0,G1H8(136),n2h8(236))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(3,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[35,12,16],[0,0,0],3,2,wf8(:,25),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(19),m3h8x8(:,74),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H8(19),35,0,G1H8(74),n2h8(237))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[49,2,12],[0,0,0],3,2,wf8(:,63),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,63),G0H8(19),m3h8x8(:,75),heltab2x64(:,:,351))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[49,2,12],[0,0,0],3,2,wf8(:,63),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,63),G0H8(20),m3h8x8(:,76),heltab2x64(:,:,352))
  call Hloop_Q_A(ntryL,G0H8(20),49,0,G1H8(27),n2h8(238))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[33,14,16],[0,0,0],3,2,wf4(:,17),wf8(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(2),m3h4x16(:,63),heltab2x64(:,:,353))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[45,2,16],[0,0,0],3,1,wf16(:,34))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,34),G0H4(19),m3h16x4(:,7),heltab2x64(:,:,354))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[35,12,16],[0,0,0],3,2,wf8(:,26),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,26),G0H8(20),m3h8x8(:,77),heltab2x64(:,:,355))
  call Hloop_A_Q(ntryL,G0H8(20),35,0,G1H8(29),n2h8(239))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[35,12,16],[0,0,0],3,2,wf8(:,26),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,26),G0H8(20),m3h8x8(:,78),heltab2x64(:,:,356))
  call Hloop_Q_A(ntryL,G0H8(20),35,0,G1H8(46),n2h8(240))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(2,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[35,12,16],[0,0,0],3,2,wf8(:,26),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,26),G0H8(20),m3h8x8(:,79),heltab2x64(:,:,357))
  call Hloop_A_Q(ntryL,G0H8(20),35,0,G1H8(18),n2h8(241))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(2,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[35,12,16],[0,0,0],3,2,wf8(:,26),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,26),G0H8(20),m3h8x8(:,80),heltab2x64(:,:,358))
  call Hloop_Q_A(ntryL,G0H8(20),35,0,G1H8(41),n2h8(242))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[34,13,16],[0,0,0],3,2,wf4(:,14),wf8(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,64),heltab2x64(:,:,359))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[50,1,12],[0,0,0],3,2,wf8(:,72),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,72),G0H8(20),m3h8x8(:,81),heltab2x64(:,:,360))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[50,1,12],[0,0,0],3,2,wf8(:,72),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,72),G0H8(21),m3h8x8(:,82),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H8(21),50,0,G1H8(66),n2h8(243))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[46,1,16],[0,0,0],3,1,wf16(:,28))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,28),G0H4(20),m3h16x4(:,8),heltab2x64(:,:,362))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,15,16],[0,0,0],3,1,wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,209),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(127))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,15,16],[0,0,0],3,1,wf16(:,50))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,210),heltab2x64(:,:,364))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(62),n2h32(128))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(2,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,15,16],[0,0,0],3,1,wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,211),heltab2x64(:,:,365))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(129))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(2,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,15,16],[0,0,0],3,1,wf16(:,50))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,212),heltab2x64(:,:,366))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(64),n2h32(130))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,15,16],[0,0,0],3,1,wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,213),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(65),n2h32(131))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,15,16],[0,0,0],3,1,wf16(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,214),heltab2x64(:,:,368))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(66),n2h32(132))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(3,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,15,16],[0,0,0],3,1,wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,215),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(67),n2h32(133))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(25)*M(3,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,15,16],[0,0,0],3,1,wf16(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,216),heltab2x64(:,:,370))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(68),n2h32(134))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,2,29],[0,0,0],3,1,wf16(:,53))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,217),heltab2x64(:,:,371))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(69),n2h32(135))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,2,29],[0,0,0],3,1,wf16(:,53))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,218),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[45,2,16],[0,0,0],3,1,wf16(:,55))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,55),G0H4(21),m3h16x4(:,9),heltab2x64(:,:,373))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[45,2,16],[0,0,0],3,1,wf16(:,57))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,57),G0H4(22),m3h16x4(:,10),heltab2x64(:,:,374))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,1,30],[0,0,0],3,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,219),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(136))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,1,30],[0,0,0],3,1,wf16(:,59))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,220),heltab2x64(:,:,376))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[46,1,16],[0,0,0],3,1,wf16(:,61))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,61),G0H4(23),m3h16x4(:,11),heltab2x64(:,:,377))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(3,:)%j)) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[46,1,16],[0,0,0],3,1,wf16(:,63))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,63),G0H4(24),m3h16x4(:,12),heltab2x64(:,:,378))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[51,4,8],[0,0,0],3,1,wf16(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,3),G0H4(25),m3h16x4(:,13),heltab2x64(:,:,379))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(160),n2h4(231))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[51,4,8],[0,0,0],3,1,wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,3),51,G1H4(168),m3h16x4(:,14),heltab2x64(:,:,380))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[36,8,19],[0,0,0],3,2,wf4(:,8),wf8(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,65),heltab2x64(:,:,381))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[36,8,19],[0,0,0],3,2,wf4(:,8),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(14),m3h4x16(:,66),heltab2x64(:,:,382))
  call Hloop_Q_A(ntryL,G0H16(14),36,0,G1H16(16),n2h16(95))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[44,2,17],[0,0,0],3,2,wf8(:,23),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(21),m3h8x8(:,83),heltab2x64(:,:,383))
  call Hloop_Q_A(ntryL,G0H8(21),44,0,G1H8(60),n2h8(244))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[44,2,17],[0,0,0],3,2,wf8(:,23),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),44,G1H8(65),m3h8x8(:,84),heltab2x64(:,:,384))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[40,4,19],[0,0,0],3,2,wf4(:,5),wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,67),heltab2x64(:,:,385))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[40,4,19],[0,0,0],3,2,wf4(:,5),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,68),heltab2x64(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(16),40,0,G1H16(36),n2h16(96))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[44,2,17],[0,0,0],3,2,wf8(:,24),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(21),m3h8x8(:,85),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G0H8(21),44,0,G1H8(71),n2h8(245))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[44,2,17],[0,0,0],3,2,wf8(:,24),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),44,G1H8(78),m3h8x8(:,86),heltab2x64(:,:,388))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,8,23],[0,0,0],3,1,wf16(:,65))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,221),heltab2x64(:,:,389))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(73),n2h32(137))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,8,23],[0,0,0],3,1,wf16(:,65))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,222),heltab2x64(:,:,390))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,4,27],[0,0,0],3,1,wf16(:,67))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,223),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(75),n2h32(138))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,4,27],[0,0,0],3,1,wf16(:,67))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,224),heltab2x64(:,:,392))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[51,4,8],[0,0,0],3,1,wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,68),G0H4(25),m3h16x4(:,15),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(194),n2h4(232))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[51,4,8],[0,0,0],3,1,wf16(:,68))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,68),51,G1H4(197),m3h16x4(:,16),heltab2x64(:,:,394))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[51,4,8],[0,0,0],3,1,wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,69),G0H4(25),m3h16x4(:,17),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(198),n2h4(233))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[51,4,8],[0,0,0],3,1,wf16(:,69))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,69),51,G1H4(199),m3h16x4(:,18),heltab2x64(:,:,396))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[51,4,8],[0,0,0],3,1,wf16(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,4),G0H4(25),m3h16x4(:,19),heltab2x64(:,:,397))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(129),n2h4(234))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[51,4,8],[0,0,0],3,1,wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,4),51,G1H4(219),m3h16x4(:,20),heltab2x64(:,:,398))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[36,8,19],[0,0,0],3,2,wf4(:,8),wf8(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(17),m3h4x16(:,69),heltab2x64(:,:,399))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[36,8,19],[0,0,0],3,2,wf4(:,8),wf8(:,17))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(18),m3h4x16(:,70),heltab2x64(:,:,400))
  call Hloop_Q_A(ntryL,G0H16(18),36,0,G1H16(21),n2h16(97))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[44,1,18],[0,0,0],3,2,wf8(:,23),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,23),G0H8(21),m3h8x8(:,87),heltab2x64(:,:,401))
  call Hloop_A_Q(ntryL,G0H8(21),44,0,G1H8(72),n2h8(246))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[44,1,18],[0,0,0],3,2,wf8(:,23),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),44,G1H8(77),m3h8x8(:,88),heltab2x64(:,:,402))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[40,4,19],[0,0,0],3,2,wf4(:,5),wf8(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,71),heltab2x64(:,:,403))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[40,4,19],[0,0,0],3,2,wf4(:,5),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,72),heltab2x64(:,:,404))
  call Hloop_A_Q(ntryL,G0H16(20),40,0,G1H16(40),n2h16(98))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[44,1,18],[0,0,0],3,2,wf8(:,24),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,24),G0H8(21),m3h8x8(:,89),heltab2x64(:,:,405))
  call Hloop_A_Q(ntryL,G0H8(21),44,0,G1H8(83),n2h8(247))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[44,1,18],[0,0,0],3,2,wf8(:,24),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),44,G1H8(90),m3h8x8(:,90),heltab2x64(:,:,406))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,8,23],[0,0,0],3,1,wf16(:,71))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,225),heltab2x64(:,:,407))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(77),n2h32(139))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,8,23],[0,0,0],3,1,wf16(:,71))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,226),heltab2x64(:,:,408))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[32,4,27],[0,0,0],3,1,wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,227),heltab2x64(:,:,409))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(79),n2h32(140))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[32,4,27],[0,0,0],3,1,wf16(:,73))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,228),heltab2x64(:,:,410))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[51,4,8],[0,0,0],3,1,wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,74),G0H4(25),m3h16x4(:,21),heltab2x64(:,:,411))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(218),n2h4(235))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[51,4,8],[0,0,0],3,1,wf16(:,74))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,74),51,G1H4(158),m3h16x4(:,22),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[51,4,8],[0,0,0],3,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,75),G0H4(25),m3h16x4(:,23),heltab2x64(:,:,413))
  call Hloop_A_Q(ntryL,G0H4(25),51,0,G1H4(46),n2h4(236))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[51,4,8],[0,0,0],3,1,wf16(:,75))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,75),51,G1H4(142),m3h16x4(:,24),heltab2x64(:,:,414))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[35,8,20],[0,0,0],3,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(21),m3h8x8(:,91),heltab2x64(:,:,415))
  call Hloop_Q_A(ntryL,G0H8(21),35,0,G1H8(96),n2h8(248))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[35,8,20],[0,0,0],3,2,wf8(:,25),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,25),35,G1H8(101),m3h8x8(:,92),heltab2x64(:,:,416))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[33,2,28],[0,0,0],3,2,wf4(:,17),wf8(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(21),m3h4x16(:,73),heltab2x64(:,:,417))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[33,2,28],[0,0,0],3,2,wf4(:,17),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(22),m3h4x16(:,74),heltab2x64(:,:,418))
  call Hloop_Q_A(ntryL,G0H16(22),33,0,G1H16(42),n2h16(99))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[35,8,20],[0,0,0],3,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,26),G0H8(21),m3h8x8(:,93),heltab2x64(:,:,419))
  call Hloop_Q_A(ntryL,G0H8(21),35,0,G1H8(108),n2h8(249))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[35,8,20],[0,0,0],3,2,wf8(:,26),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,26),35,G1H8(113),m3h8x8(:,94),heltab2x64(:,:,420))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[34,1,28],[0,0,0],3,2,wf4(:,14),wf8(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(1),m3h4x16(:,75),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[34,1,28],[0,0,0],3,2,wf4(:,14),wf8(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,76),heltab2x64(:,:,422))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(44),n2h16(100))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[60,1,2],[0,0,0],3,1,wf16(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,19),G0H4(25),m3h16x4(:,25),heltab2x64(:,:,423))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(21),n2h4(237))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[60,1,2],[0,0,0],3,1,wf16(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(169),m3h16x4(:,26),heltab2x64(:,:,424))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,2,29],[0,0,0],3,1,wf16(:,77))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,229),heltab2x64(:,:,425))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(81),n2h32(141))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,2,29],[0,0,0],3,1,wf16(:,77))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,230),heltab2x64(:,:,426))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[32,1,30],[0,0,0],3,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,231),heltab2x64(:,:,427))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(83),n2h32(142))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[32,1,30],[0,0,0],3,1,wf16(:,79))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,232),heltab2x64(:,:,428))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[60,1,2],[0,0,0],3,1,wf16(:,80))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,80),G0H4(25),m3h16x4(:,27),heltab2x64(:,:,429))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(60),n2h4(238))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[60,1,2],[0,0,0],3,1,wf16(:,80))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,80),60,G1H4(16),m3h16x4(:,28),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[60,1,2],[0,0,0],3,1,wf16(:,81))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,81),G0H4(25),m3h16x4(:,29),heltab2x64(:,:,431))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(217),n2h4(239))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[60,1,2],[0,0,0],3,1,wf16(:,81))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,81),60,G1H4(32),m3h16x4(:,30),heltab2x64(:,:,432))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[35,4,24],[0,0,0],3,2,wf8(:,25),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,25),G0H8(21),m3h8x8(:,95),heltab2x64(:,:,433))
  call Hloop_A_Q(ntryL,G0H8(21),35,0,G1H8(119),n2h8(250))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[35,4,24],[0,0,0],3,2,wf8(:,25),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,25),35,G1H8(14),m3h8x8(:,96),heltab2x64(:,:,434))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[33,2,28],[0,0,0],3,2,wf4(:,17),wf8(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(9),m3h4x16(:,77),heltab2x64(:,:,435))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[33,2,28],[0,0,0],3,2,wf4(:,17),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(11),m3h4x16(:,78),heltab2x64(:,:,436))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(20),n2h16(101))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[35,4,24],[0,0,0],3,2,wf8(:,26),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,26),G0H8(21),m3h8x8(:,97),heltab2x64(:,:,437))
  call Hloop_A_Q(ntryL,G0H8(21),35,0,G1H8(4),n2h8(251))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[35,4,24],[0,0,0],3,2,wf8(:,26),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,26),35,G1H8(44),m3h8x8(:,98),heltab2x64(:,:,438))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[34,1,28],[0,0,0],3,2,wf4(:,14),wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(14),m3h4x16(:,79),heltab2x64(:,:,439))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[34,1,28],[0,0,0],3,2,wf4(:,14),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(16),m3h4x16(:,80),heltab2x64(:,:,440))
  call Hloop_A_Q(ntryL,G0H16(16),34,0,G1H16(47),n2h16(102))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[60,1,2],[0,0,0],3,1,wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,23),G0H4(25),m3h16x4(:,31),heltab2x64(:,:,441))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(28),n2h4(240))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[60,1,2],[0,0,0],3,1,wf16(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,23),60,G1H4(74),m3h16x4(:,32),heltab2x64(:,:,442))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[32,2,29],[0,0,0],3,1,wf16(:,83))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,233),heltab2x64(:,:,443))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(85),n2h32(143))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[32,2,29],[0,0,0],3,1,wf16(:,83))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,234),heltab2x64(:,:,444))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[32,1,30],[0,0,0],3,1,wf16(:,85))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,235),heltab2x64(:,:,445))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(144))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[32,1,30],[0,0,0],3,1,wf16(:,85))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,236),heltab2x64(:,:,446))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[60,1,2],[0,0,0],3,1,wf16(:,86))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,86),G0H4(25),m3h16x4(:,33),heltab2x64(:,:,447))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(75),n2h4(241))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[60,1,2],[0,0,0],3,1,wf16(:,86))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,86),60,G1H4(107),m3h16x4(:,34),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[60,1,2],[0,0,0],3,1,wf16(:,87))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,87),G0H4(25),m3h16x4(:,35),heltab2x64(:,:,449))
  call Hloop_A_Q(ntryL,G0H4(25),60,0,G1H4(137),n2h4(242))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[60,1,2],[0,0,0],3,1,wf16(:,87))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,87),60,G1H4(108),m3h16x4(:,36),heltab2x64(:,:,450))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[39,8,16],[0,0,0],3,1,wf16(:,89))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,89),G0H4(25),m3h16x4(:,37),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[43,4,16],[0,0,0],3,1,wf16(:,91))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,91),G0H4(26),m3h16x4(:,38),heltab2x64(:,:,452))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[51,4,8],[0,0,0],3,1,wf16(:,92))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,92),G0H4(27),m3h16x4(:,39),heltab2x64(:,:,453))
  call Hloop_A_Q(ntryL,G0H4(27),51,0,G1H4(120),n2h4(243))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[51,4,8],[0,0,0],3,1,wf16(:,92))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,92),51,G1H4(70),m3h16x4(:,40),heltab2x64(:,:,454))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[39,8,16],[0,0,0],3,1,wf16(:,94))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,94),G0H4(27),m3h16x4(:,41),heltab2x64(:,:,455))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[43,4,16],[0,0,0],3,1,wf16(:,96))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,96),G0H4(28),m3h16x4(:,42),heltab2x64(:,:,456))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[51,4,8],[0,0,0],3,1,wf16(:,97))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,97),G0H4(29),m3h16x4(:,43),heltab2x64(:,:,457))
  call Hloop_A_Q(ntryL,G0H4(29),51,0,G1H4(124),n2h4(244))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[51,4,8],[0,0,0],3,1,wf16(:,97))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,97),51,G1H4(136),m3h16x4(:,44),heltab2x64(:,:,458))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[45,2,16],[0,0,0],3,1,wf16(:,99))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,99),G0H4(29),m3h16x4(:,45),heltab2x64(:,:,459))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[46,1,16],[0,0,0],3,1,wf16(:,101))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,101),G0H4(30),m3h16x4(:,46),heltab2x64(:,:,460))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[60,1,2],[0,0,0],3,1,wf16(:,102))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,102),G0H4(31),m3h16x4(:,47),heltab2x64(:,:,461))
  call Hloop_A_Q(ntryL,G0H4(31),60,0,G1H4(130),n2h4(245))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[60,1,2],[0,0,0],3,1,wf16(:,102))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,102),60,G1H4(12),m3h16x4(:,48),heltab2x64(:,:,462))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[45,2,16],[0,0,0],3,1,wf16(:,104))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,104),G0H4(31),m3h16x4(:,49),heltab2x64(:,:,463))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[46,1,16],[0,0,0],3,1,wf16(:,106))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,106),G0H4(32),m3h16x4(:,50),heltab2x64(:,:,464))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[60,1,2],[0,0,0],3,1,wf16(:,107))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,107),G0H4(33),m3h16x4(:,51),heltab2x64(:,:,465))
  call Hloop_A_Q(ntryL,G0H4(33),60,0,G1H4(41),n2h4(246))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[60,1,2],[0,0,0],3,1,wf16(:,107))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,107),60,G1H4(175),m3h16x4(:,52),heltab2x64(:,:,466))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(222),G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(214),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(28),G1H8(19),G1H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(71),G1H4(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(12),G1H8(58),G1H8(55),G1H8(31),G1H8(9) &
    ,G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(67),[G1H8(62),G1H8(56),G1H8(38),G1H8(17),G1H8(40) &
    ,G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(29),G1H8(136),G1H8(6),G1H8(39),G1H8(33) &
    ,G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(41),[G1H8(46),G1H8(74),G1H8(73),G1H8(34),G1H8(36) &
    ,G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(65),G1H8(43),G1H8(2),G0H8(9),G0H8(14) &
    ,G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(77),G1H8(64),G1H8(32),G0H8(2),G0H8(3) &
    ,G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(113),[G1H8(101),G1H8(3),G1H8(57),G0H8(11),G0H8(4) &
    ,G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(14),G1H8(24),G1H8(5),G0H8(8),G0H8(7) &
    ,G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(70),G1H4(142),G1H4(158),G1H4(219),G1H4(199) &
    ,G1H4(197),G1H4(168),G0H4(6),G0H4(5),G0H4(4),G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(12),G1H4(108),G1H4(107),G1H4(74),G1H4(32) &
    ,G1H4(16),G1H4(169),G0H4(12),G0H4(11),G0H4(10),G0H4(9),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(6),[G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(96),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(119),G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(20),[G1H32(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(21),[G1H32(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(27),[G0H4(25),G0H4(17),G0H4(15),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(28),[G0H4(26),G0H4(18),G0H4(16),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(29),[G1H32(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(30),[G1H32(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(35),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(36),[G1H32(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(41),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(42),[G1H32(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(60),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(52),[G1H32(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(53),[G1H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(72),G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(31),[G0H4(29),G0H4(22),G0H4(21),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(32),[G0H4(30),G0H4(24),G0H4(23),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(63),[G1H32(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(64),[G1H32(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(67),[G1H32(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(68),[G1H32(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(120),G1H4(46),G1H4(218),G1H4(129),G1H4(198) &
    ,G1H4(194),G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(130),G1H4(137),G1H4(75),G1H4(28),G1H4(217) &
    ,G1H4(60),G1H4(21)])
  call Hloop_QV_A(ntryL,G1H4(7),ex5(:),G1H2(190),m3h2x2(:,371),heltab2x4(:,:,567))
  call Hloop_Q_A(ntryL,G1H2(190),55,0,G2H2(202),n2h2(359))
  call Hloop_AV_Q(ntryL,G1H4(15),ex5(:),G1H2(28),m3h2x2(:,372),heltab2x4(:,:,568))
  call Hloop_A_Q(ntryL,G1H2(28),59,0,G2H2(205),n2h2(360))
  call Hloop_QV_A(ntryL,G1H8(61),wf4(:,1),G1H2(152),m3h4x2(:,111),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(152),55,0,G2H2(207),n2h2(361))
  call Hloop_QV_A(ntryL,G1H4(38),ex5(:),G1H2(32),m3h2x2(:,373),heltab2x4(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(32),61,0,G2H2(209),n2h2(362))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,12),G1H2(195),m3h4x2(:,112),heltab2x8(:,:,404))
  call Hloop_Q_A(ntryL,G1H2(195),61,0,G2H2(210),n2h2(363))
  call Hloop_AV_Q(ntryL,G1H4(62),ex5(:),G1H2(119),m3h2x2(:,374),heltab2x4(:,:,570))
  call Hloop_A_Q(ntryL,G1H2(119),62,0,G2H2(213),n2h2(364))
  call Hloop_AV_Q(ntryL,G1H8(68),wf4(:,1),G1H2(200),m3h4x2(:,113),heltab2x8(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(200),47,0,G2H2(214),n2h2(365))
  call Hloop_QV_A(ntryL,G1H8(67),wf4(:,1),G1H2(86),m3h4x2(:,114),heltab2x8(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(216),n2h2(366))
  call Hloop_QV_A(ntryL,G1H8(47),ex5(:),G1H4(99),m3h2x4(:,239),heltab2x8(:,:,407))
  call Hloop_Q_A(ntryL,G1H4(99),51,0,G2H4(3),n2h4(247))
  call Hloop_AV_Q(ntryL,G1H8(51),ex5(:),G1H4(61),m3h2x4(:,240),heltab2x8(:,:,408))
  call Hloop_A_Q(ntryL,G1H4(61),51,0,G2H4(4),n2h4(248))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,12),G1H2(205),m3h4x2(:,115),heltab2x8(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(205),47,0,G2H2(231),n2h2(367))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,12),G1H2(62),m3h4x2(:,116),heltab2x8(:,:,410))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(233),n2h2(368))
  call Hloop_VA_Q(ntryL,G1H8(78),ex2(:),G1H4(157),m3h2x4(:,241),heltab2x8(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(157),46,0,G2H4(66),n2h4(249))
  call Hloop_VQ_A(ntryL,G1H8(90),ex1(:),G1H4(170),m3h2x4(:,242),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G1H4(170),45,0,G2H4(58),n2h4(250))
  call Hloop_VA_Q(ntryL,G1H8(113),ex4(:),G1H4(147),m3h2x4(:,243),heltab2x8(:,:,413))
  call Hloop_A_Q(ntryL,G1H4(147),43,0,G2H4(62),n2h4(251))
  call Hloop_VQ_A(ntryL,G1H8(15),wf4(:,4),G1H2(210),m3h4x2(:,117),heltab2x8(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(210),55,0,G2H2(236),n2h2(369))
  call Hloop_VQ_A(ntryL,G1H8(44),ex3(:),G1H4(51),m3h2x4(:,244),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H4(51),39,0,G2H4(47),n2h4(252))
  call Hloop_VA_Q(ntryL,G1H8(45),wf4(:,9),G1H2(309),m3h4x2(:,118),heltab2x8(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(309),59,0,G2H2(238),n2h2(370))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(174),m3h4x4(:,54),heltab2x16(:,:,246))
  call Hloop_A_Q(ntryL,G1H4(174),43,0,G2H4(52),n2h4(253))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,1),G1H4(79),m3h4x4(:,55),heltab2x16(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(79),39,0,G2H4(50),n2h4(254))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(70),m3h2x8(:,170),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H8(70),52,0,G2H8(10),n2h8(252))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,12),G1H4(123),m3h4x4(:,56),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(123),46,0,G2H4(2),n2h4(255))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,12),G1H4(146),m3h4x4(:,57),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(146),45,0,G2H4(49),n2h4(256))
  call Hloop_AV_Q(ntryL,G1H16(27),ex5(:),G1H8(81),m3h2x8(:,171),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H8(81),50,0,G2H8(30),n2h8(253))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(79),m3h2x8(:,172),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G1H8(79),49,0,G2H8(22),n2h8(254))
  call Hloop_QV_A(ntryL,G1H16(34),wf8(:,12),G1H2(315),m3h8x2(:,24),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(315),55,0,G2H2(241),n2h2(371))
  call Hloop_QV_A(ntryL,G1H16(41),wf8(:,17),G1H2(193),m3h8x2(:,25),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(193),55,0,G2H2(243),n2h2(372))
  call Hloop_QV_A(ntryL,G1H16(52),wf8(:,4),G1H2(273),m3h8x2(:,26),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(273),61,0,G2H2(246),n2h2(373))
  call Hloop_QV_A(ntryL,G1H16(13),wf8(:,9),G1H2(357),m3h8x2(:,27),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(357),61,0,G2H2(248),n2h2(374))
  call Hloop_VQ_A(ntryL,G1H4(136),ex3(:),G1H2(363),m3h2x2(:,375),heltab2x4(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(363),55,0,G2H2(57),n2h2(375))
  call Hloop_VQ_A(ntryL,G1H4(175),ex1(:),G1H2(198),m3h2x2(:,376),heltab2x4(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(198),61,0,G2H2(58),n2h2(376))
  call Hloop_AV_Q(ntryL,G1H32(5),wf16(:,35),G1H2(303),m3h16x2(:,1),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(303),47,0,G2H2(110),n2h2(377))
  call Hloop_QV_A(ntryL,G1H32(6),wf16(:,35),G1H2(21),m3h16x2(:,2),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(98),n2h2(378))
  call Hloop_UV_W(ntryL,G0H16(3),40,wf4(:,1),3,G1H4(135),m3h4x4(:,58),heltab2x16(:,:,257))
  call Hloop_QA_V(ntryL,G1H32(9),wf8(:,3),G1H4(8),m3h8x4(:,6),heltab2x32(:,:,145))
  call Hloop_VA_Q(ntryL,G1H32(10),wf8(:,3),G1H4(181),m3h8x4(:,7),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(181),43,0,G2H4(21),n2h4(257))
  call Hloop_QA_V(ntryL,G1H8(108),ex4(:),G1H4(47),m3h2x4(:,245),heltab2x8(:,:,417))
  call Hloop_AV_Q(ntryL,G1H32(7),wf4(:,1),G1H8(97),m3h4x8(:,27),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(97),35,0,G2H8(6),n2h8(255))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,1),G1H8(93),m3h4x8(:,28),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(93),35,0,G2H8(13),n2h8(256))
  call Hloop_DV_C(ntryL,G1H32(11),32,wf4(:,1),G2H8(25),m3h4x8(:,29),heltab2x32(:,:,149))
  call Hloop_CV_D(ntryL,G1H32(12),32,wf4(:,1),3,G2H8(28),m3h4x8(:,30),heltab2x32(:,:,150))
  call Hloop_UV_W(ntryL,G1H32(13),32,wf4(:,1),3,G2H8(27),m3h4x8(:,31),heltab2x32(:,:,151))
  call Hloop_UV_W(ntryL,G0H8(15),52,wf4(:,1),3,G1H2(75),m3h4x2(:,119),heltab2x8(:,:,418))
  call Hloop_QA_V(ntryL,G1H32(14),ex4(:),G1H16(22),m3h2x16(:,112),heltab2x32(:,:,152))
  call Hloop_VA_Q(ntryL,G1H32(15),ex4(:),G1H16(51),m3h2x16(:,113),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H16(51),40,0,G2H16(22),n2h16(103))
  call Hloop_UV_W(ntryL,G0H16(6),36,wf4(:,1),3,G1H4(121),m3h4x4(:,59),heltab2x16(:,:,258))
  call Hloop_AQ_V(ntryL,G1H32(16),wf8(:,8),G1H4(54),m3h8x4(:,8),heltab2x32(:,:,154))
  call Hloop_VQ_A(ntryL,G1H32(17),wf8(:,8),G1H4(177),m3h8x4(:,9),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(177),39,0,G2H4(7),n2h4(258))
  call Hloop_AQ_V(ntryL,G1H8(4),ex3(:),G1H4(77),m3h2x4(:,246),heltab2x8(:,:,419))
  call Hloop_AV_Q(ntryL,G1H32(20),wf4(:,1),G1H8(94),m3h4x8(:,32),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(94),35,0,G2H8(29),n2h8(257))
  call Hloop_QV_A(ntryL,G1H32(21),wf4(:,1),G1H8(103),m3h4x8(:,33),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(103),35,0,G2H8(18),n2h8(258))
  call Hloop_DV_C(ntryL,G1H32(22),32,wf4(:,1),G2H8(26),m3h4x8(:,34),heltab2x32(:,:,158))
  call Hloop_CV_D(ntryL,G1H32(23),32,wf4(:,1),3,G2H8(14),m3h4x8(:,35),heltab2x32(:,:,159))
  call Hloop_UV_W(ntryL,G1H32(24),32,wf4(:,1),3,G2H8(5),m3h4x8(:,36),heltab2x32(:,:,160))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,1),G1H2(446),m3h4x2(:,120),heltab2x8(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(446),59,0,G2H2(70),n2h2(379))
  call Hloop_UV_W(ntryL,G0H8(16),56,wf4(:,1),3,G1H2(281),m3h4x2(:,121),heltab2x8(:,:,421))
  call Hloop_AQ_V(ntryL,G1H32(25),ex3(:),G1H16(7),m3h2x16(:,114),heltab2x32(:,:,161))
  call Hloop_VQ_A(ntryL,G1H32(26),ex3(:),G1H16(19),m3h2x16(:,115),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G1H16(19),36,0,G2H16(1),n2h16(104))
  call Hloop_VA_Q(ntryL,G0H16(7),wf8(:,3),G0H2(1),m3h8x2(:,28),heltab2x16(:,:,259))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(109),n2h2(380))
  call Hloop_VA_Q(ntryL,G0H4(27),ex4(:),G0H2(1),m3h2x2(:,377),heltab2x4(:,:,573))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(37),n2h2(381))
  call Hloop_VQ_A(ntryL,G0H16(8),wf8(:,8),G0H2(1),m3h8x2(:,29),heltab2x16(:,:,260))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(50),n2h2(382))
  call Hloop_VQ_A(ntryL,G0H4(28),ex3(:),G0H2(1),m3h2x2(:,378),heltab2x4(:,:,574))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(115),n2h2(383))
  call Hloop_AV_Q(ntryL,G1H32(29),wf16(:,36),G1H2(424),m3h16x2(:,3),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(424),47,0,G2H2(59),n2h2(384))
  call Hloop_QV_A(ntryL,G1H32(30),wf16(:,36),G1H2(293),m3h16x2(:,4),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(293),47,0,G2H2(60),n2h2(385))
  call Hloop_QA_V(ntryL,G1H32(31),ex4(:),G1H16(18),m3h2x16(:,116),heltab2x32(:,:,165))
  call Hloop_VA_Q(ntryL,G1H32(32),ex4(:),G1H16(53),m3h2x16(:,117),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H16(53),40,0,G2H16(2),n2h16(105))
  call Hloop_AV_Q(ntryL,G1H32(35),wf16(:,41),G1H2(121),m3h16x2(:,5),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(121),47,0,G2H2(61),n2h2(386))
  call Hloop_QV_A(ntryL,G1H32(36),wf16(:,41),G1H2(68),m3h16x2(:,6),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(113),n2h2(387))
  call Hloop_AQ_V(ntryL,G1H32(37),ex3(:),G1H16(12),m3h2x16(:,118),heltab2x32(:,:,169))
  call Hloop_VQ_A(ntryL,G1H32(38),ex3(:),G1H16(23),m3h2x16(:,119),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G1H16(23),36,0,G2H16(3),n2h16(106))
  call Hloop_UV_W(ntryL,G0H16(10),34,wf4(:,12),12,G1H4(81),m3h4x4(:,60),heltab2x16(:,:,261))
  call Hloop_QV_A(ntryL,G1H32(41),wf4(:,12),G1H8(104),m3h4x8(:,37),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(104),44,0,G2H8(7),n2h8(259))
  call Hloop_AV_Q(ntryL,G1H32(42),wf4(:,12),G1H8(106),m3h4x8(:,38),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(106),44,0,G2H8(9),n2h8(260))
  call Hloop_CV_D(ntryL,G1H32(43),32,wf4(:,12),12,G2H8(20),m3h4x8(:,39),heltab2x32(:,:,173))
  call Hloop_DV_C(ntryL,G1H32(44),32,wf4(:,12),G2H8(21),m3h4x8(:,40),heltab2x32(:,:,174))
  call Hloop_UV_W(ntryL,G1H32(45),32,wf4(:,12),12,G2H8(23),m3h4x8(:,41),heltab2x32(:,:,175))
  call Hloop_VA_Q(ntryL,G0H8(19),ex2(:),G0H4(33),m3h2x4(:,247),heltab2x8(:,:,422))
  call Hloop_A_Q(ntryL,G0H4(33),51,0,G1H4(83),n2h4(259))
  call Hloop_QA_V(ntryL,G1H8(27),ex2(:),G1H4(96),m3h2x4(:,248),heltab2x8(:,:,423))
  call Hloop_QA_V(ntryL,G1H32(46),wf8(:,16),G1H4(34),m3h8x4(:,10),heltab2x32(:,:,176))
  call Hloop_VA_Q(ntryL,G1H32(47),wf8(:,16),G1H4(27),m3h8x4(:,11),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(27),46,0,G2H4(53),n2h4(260))
  call Hloop_QA_V(ntryL,G1H8(71),ex2(:),G1H4(19),m3h2x4(:,249),heltab2x8(:,:,424))
  call Hloop_QA_V(ntryL,G1H32(48),ex2(:),G1H16(25),m3h2x16(:,120),heltab2x32(:,:,178))
  call Hloop_VA_Q(ntryL,G1H32(49),ex2(:),G1H16(26),m3h2x16(:,121),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H16(26),34,0,G2H16(4),n2h16(107))
  call Hloop_UV_W(ntryL,G0H16(12),33,wf4(:,12),12,G1H4(103),m3h4x4(:,61),heltab2x16(:,:,262))
  call Hloop_QV_A(ntryL,G1H32(52),wf4(:,12),G1H8(130),m3h4x8(:,42),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(130),44,0,G2H8(24),n2h8(261))
  call Hloop_AV_Q(ntryL,G1H32(53),wf4(:,12),G1H8(131),m3h4x8(:,43),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(131),44,0,G2H8(16),n2h8(262))
  call Hloop_CV_D(ntryL,G1H32(54),32,wf4(:,12),12,G2H8(36),m3h4x8(:,44),heltab2x32(:,:,182))
  call Hloop_DV_C(ntryL,G1H32(55),32,wf4(:,12),G2H8(11),m3h4x8(:,45),heltab2x32(:,:,183))
  call Hloop_UV_W(ntryL,G1H32(56),32,wf4(:,12),12,G2H8(12),m3h4x8(:,46),heltab2x32(:,:,184))
  call Hloop_AQ_V(ntryL,G1H32(57),wf8(:,20),G1H4(128),m3h8x4(:,12),heltab2x32(:,:,185))
  call Hloop_VQ_A(ntryL,G1H32(58),wf8(:,20),G1H4(43),m3h8x4(:,13),heltab2x32(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(43),45,0,G2H4(35),n2h4(261))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(6),m3h2x4(:,250),heltab2x8(:,:,425))
  call Hloop_Q_A(ntryL,G0H4(6),51,0,G1H4(29),n2h4(262))
  call Hloop_AQ_V(ntryL,G1H8(66),ex1(:),G1H4(127),m3h2x4(:,251),heltab2x8(:,:,426))
  call Hloop_AQ_V(ntryL,G1H8(83),ex1(:),G1H4(24),m3h2x4(:,252),heltab2x8(:,:,427))
  call Hloop_AQ_V(ntryL,G1H32(59),ex1(:),G1H16(45),m3h2x16(:,122),heltab2x32(:,:,187))
  call Hloop_VQ_A(ntryL,G1H32(60),ex1(:),G1H16(29),m3h2x16(:,123),heltab2x32(:,:,188))
  call Hloop_Q_A(ntryL,G1H16(29),33,0,G2H16(5),n2h16(108))
  call Hloop_VA_Q(ntryL,G0H16(2),wf8(:,16),G0H2(1),m3h8x2(:,30),heltab2x16(:,:,263))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(127),n2h2(388))
  call Hloop_VA_Q(ntryL,G0H4(31),ex2(:),G0H2(1),m3h2x2(:,379),heltab2x4(:,:,575))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(151),n2h2(389))
  call Hloop_VQ_A(ntryL,G0H16(5),wf8(:,20),G0H2(1),m3h8x2(:,31),heltab2x16(:,:,264))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(490),n2h2(390))
  call Hloop_VQ_A(ntryL,G0H4(32),ex1(:),G0H2(1),m3h2x2(:,380),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(323),n2h2(391))
  call Hloop_AV_Q(ntryL,G1H32(63),wf16(:,50),G1H2(157),m3h16x2(:,7),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(157),47,0,G2H2(101),n2h2(392))
  call Hloop_QV_A(ntryL,G1H32(64),wf16(:,50),G1H2(133),m3h16x2(:,8),heltab2x32(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(133),47,0,G2H2(72),n2h2(393))
  call Hloop_AV_Q(ntryL,G1H32(67),wf16(:,51),G1H2(139),m3h16x2(:,9),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(139),47,0,G2H2(62),n2h2(394))
  call Hloop_QV_A(ntryL,G1H32(68),wf16(:,51),G1H2(163),m3h16x2(:,10),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(163),47,0,G2H2(63),n2h2(395))
  call Hloop_QA_V(ntryL,G1H32(69),ex2(:),G1H16(2),m3h2x16(:,124),heltab2x32(:,:,193))
  call Hloop_VA_Q(ntryL,G1H32(70),ex2(:),G1H16(28),m3h2x16(:,125),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G1H16(28),34,0,G2H16(6),n2h16(109))
  call Hloop_AQ_V(ntryL,G1H32(71),ex1(:),G1H16(1),m3h2x16(:,126),heltab2x32(:,:,195))
  call Hloop_VQ_A(ntryL,G1H32(72),ex1(:),G1H16(5),m3h2x16(:,127),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G1H16(5),33,0,G2H16(7),n2h16(110))
  call Hloop_AQ_V(ntryL,G1H4(124),ex3(:),G1H2(468),m3h2x2(:,381),heltab2x4(:,:,577))
  call Hloop_VA_Q(ntryL,G0H16(13),ex4(:),G0H8(21),m3h2x8(:,173),heltab2x16(:,:,265))
  call Hloop_A_Q(ntryL,G0H8(21),44,0,G1H8(141),n2h8(263))
  call Hloop_QA_V(ntryL,G1H16(16),ex4(:),G1H8(147),m3h2x8(:,174),heltab2x16(:,:,266))
  call Hloop_VQ_A(ntryL,G0H16(15),ex3(:),G0H8(9),m3h2x8(:,175),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G0H8(9),44,0,G1H8(75),n2h8(264))
  call Hloop_AQ_V(ntryL,G1H16(36),ex3(:),G1H8(76),m3h2x8(:,176),heltab2x16(:,:,268))
  call Hloop_QA_V(ntryL,G1H32(73),ex4(:),G1H16(6),m3h2x16(:,128),heltab2x32(:,:,197))
  call Hloop_VA_Q(ntryL,G1H32(74),ex4(:),G1H16(31),m3h2x16(:,129),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G1H16(31),40,0,G2H16(8),n2h16(111))
  call Hloop_AQ_V(ntryL,G1H32(75),ex3(:),G1H16(14),m3h2x16(:,130),heltab2x32(:,:,199))
  call Hloop_VQ_A(ntryL,G1H32(76),ex3(:),G1H16(17),m3h2x16(:,131),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G1H16(17),36,0,G2H16(9),n2h16(112))
  call Hloop_VA_Q(ntryL,G0H16(17),ex4(:),G0H8(14),m3h2x8(:,177),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G0H8(14),44,0,G1H8(7),n2h8(265))
  call Hloop_QA_V(ntryL,G1H16(21),ex4(:),G1H8(20),m3h2x8(:,178),heltab2x16(:,:,270))
  call Hloop_VQ_A(ntryL,G0H16(19),ex3(:),G0H8(13),m3h2x8(:,179),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G0H8(13),44,0,G1H8(85),n2h8(266))
  call Hloop_AQ_V(ntryL,G1H16(40),ex3(:),G1H8(92),m3h2x8(:,180),heltab2x16(:,:,272))
  call Hloop_QA_V(ntryL,G1H32(77),ex4(:),G1H16(37),m3h2x16(:,132),heltab2x32(:,:,201))
  call Hloop_VA_Q(ntryL,G1H32(78),ex4(:),G1H16(38),m3h2x16(:,133),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(38),40,0,G2H16(10),n2h16(113))
  call Hloop_AQ_V(ntryL,G1H32(79),ex3(:),G1H16(43),m3h2x16(:,134),heltab2x32(:,:,203))
  call Hloop_VQ_A(ntryL,G1H32(80),ex3(:),G1H16(46),m3h2x16(:,135),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G1H16(46),36,0,G2H16(11),n2h16(114))
  call Hloop_VA_Q(ntryL,G0H16(21),ex2(:),G0H8(2),m3h2x8(:,181),heltab2x16(:,:,273))
  call Hloop_A_Q(ntryL,G0H8(2),35,0,G1H8(25),n2h8(267))
  call Hloop_QA_V(ntryL,G1H16(42),ex2(:),G1H8(30),m3h2x8(:,182),heltab2x16(:,:,274))
  call Hloop_VQ_A(ntryL,G0H16(1),ex1(:),G0H8(3),m3h2x8(:,183),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G0H8(3),35,0,G1H8(54),n2h8(268))
  call Hloop_AQ_V(ntryL,G1H16(44),ex1(:),G1H8(22),m3h2x8(:,184),heltab2x16(:,:,276))
  call Hloop_AQ_V(ntryL,G1H4(41),ex1(:),G1H2(341),m3h2x2(:,382),heltab2x4(:,:,578))
  call Hloop_QA_V(ntryL,G1H32(81),ex2(:),G1H16(48),m3h2x16(:,136),heltab2x32(:,:,205))
  call Hloop_VA_Q(ntryL,G1H32(82),ex2(:),G1H16(49),m3h2x16(:,137),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G1H16(49),34,0,G2H16(12),n2h16(115))
  call Hloop_AQ_V(ntryL,G1H32(83),ex1(:),G1H16(32),m3h2x16(:,138),heltab2x32(:,:,207))
  call Hloop_VQ_A(ntryL,G1H32(84),ex1(:),G1H16(24),m3h2x16(:,139),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G1H16(24),33,0,G2H16(13),n2h16(116))
  call Hloop_VA_Q(ntryL,G0H16(9),ex2(:),G0H8(10),m3h2x8(:,185),heltab2x16(:,:,277))
  call Hloop_A_Q(ntryL,G0H8(10),35,0,G1H8(109),n2h8(269))
  call Hloop_QA_V(ntryL,G1H16(20),ex2(:),G1H8(59),m3h2x8(:,186),heltab2x16(:,:,278))
  call Hloop_VQ_A(ntryL,G0H16(14),ex1(:),G0H8(11),m3h2x8(:,187),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G0H8(11),35,0,G1H8(111),n2h8(270))
  call Hloop_AQ_V(ntryL,G1H16(47),ex1(:),G1H8(112),m3h2x8(:,188),heltab2x16(:,:,280))
  call Hloop_QA_V(ntryL,G1H32(85),ex2(:),G1H16(39),m3h2x16(:,140),heltab2x32(:,:,209))
  call Hloop_VA_Q(ntryL,G1H32(86),ex2(:),G1H16(50),m3h2x16(:,141),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G1H16(50),34,0,G2H16(14),n2h16(117))
  call Hloop_AQ_V(ntryL,G1H32(87),ex1(:),G1H16(54),m3h2x16(:,142),heltab2x32(:,:,211))
  call Hloop_VQ_A(ntryL,G1H32(88),ex1(:),G1H16(55),m3h2x16(:,143),heltab2x32(:,:,212))
  call Hloop_Q_A(ntryL,G1H16(55),33,0,G2H16(15),n2h16(118))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G2H2(118),G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G2H2(183),G2H2(158),G2H2(96),G2H2(36),G2H2(3) &
    ,G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G2H2(123),G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(42),G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(241),G2H2(167),G2H2(91),G2H2(5),G2H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(248),[G2H2(246),G2H2(177),G2H2(172),G2H2(81),G2H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G2H2(193),G2H2(114),G2H2(105),G2H2(9),G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(135),G1H2(486),G1H2(378)])
call HGT_w2_OLR(G1H2(165),1,1,2)
call HGT_w2_invQ_OLR(G1H2(165),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(336),G1H2(294),G1H2(415)])
call HGT_w2_OLR(G1H2(172),1,1,2)
call HGT_w2_invQ_OLR(G1H2(172),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(109)])
call ol_merge_last(G1H2(181), G1H2(181)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G1H2(332),G1H2(123),G1H2(80)])
call HGT_OLR(G2H2(144),1,1,2)
call HGT_invQ_OLR(G2H2(144),2,5,2)
call HGT_OLR(G2H2(144),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(214)])
call ol_merge_last(G1H2(6), G1H2(6)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(216),[G1H2(134),G1H2(51),G1H2(13)])
call HGT_OLR(G2H2(140),1,1,2)
call HGT_invQ_OLR(G2H2(140),2,5,2)
call HGT_OLR(G2H2(140),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(216)])
call HGT_w2_OLR(G1H4(186),1,1,4)
call HGT_w2_invQ_OLR(G1H4(186),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(314),[G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(323),[G1H2(228),G1H2(212),G1H2(55)])
call HGT_w2_OLR(G1H2(314),1,1,2)
call HGT_w2_invQ_OLR(G1H2(314),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(314),[G1H2(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(163)])
call HGT_w2_OLR(G1H4(187),1,1,4)
call HGT_w2_invQ_OLR(G1H4(187),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(252),G1H2(240),G1H2(79)])
call HGT_w2_OLR(G1H2(313),1,1,2)
call HGT_w2_invQ_OLR(G1H2(313),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(490),[G1H2(216),G1H2(146),G1H2(442)])
call HGT_w2_OLR(G1H2(217),1,1,2)
call HGT_w2_invQ_OLR(G1H2(217),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(217),[G1H2(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(399),G1H2(192),G1H2(482)])
call HGT_w2_OLR(G1H2(312),1,1,2)
call HGT_w2_invQ_OLR(G1H2(312),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(382),G1H2(202),G1H2(282)])
call HGT_w2_OLR(G1H2(234),1,1,2)
call HGT_w2_invQ_OLR(G1H2(234),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(37)])
call HGT_OLR(G2H4(42),1,1,4)
call HGT_invQ_OLR(G2H4(42),2,5,4)
call HGT_OLR(G2H4(42),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(101),G2H2(61),G2H2(59),G2H2(110),G2H2(149) &
    ,G2H2(127),G1H2(254),G1H2(206),G1H2(124),G1H2(1),G1H2(471),G1H2(416)])
call HGT_OLR(G2H4(46),1,1,4)
call HGT_invQ_OLR(G2H4(46),2,5,4)
call HGT_OLR(G2H4(46),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(72),G2H2(113),G2H2(60),G2H2(98),G2H2(154) &
    ,G2H2(132),G1H2(229),G1H2(196),G1H2(56),G1H2(469),G1H2(443),G1H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(11),G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(227),G1H4(233)])
call HGT_OLR(G2H4(55),1,1,4)
call HGT_invQ_OLR(G2H4(55),2,5,4)
call HGT_OLR(G2H4(55),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(92)])
call HGT_OLR(G2H4(59),1,1,4)
call HGT_invQ_OLR(G2H4(59),2,5,4)
call HGT_OLR(G2H4(59),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(149)])
call HGT_w2_OLR(G1H2(271),1,1,2)
call HGT_w2_invQ_OLR(G1H2(271),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(271),[G1H2(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(69),G2H4(26)])
call HGT_w2_OLR(G1H2(272),1,1,2)
call HGT_w2_invQ_OLR(G1H2(272),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(272),[G1H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(78),G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(395)])
call HGT_w2_OLR(G1H2(276),1,1,2)
call HGT_w2_invQ_OLR(G1H2(276),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(63),G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(49)])
call HGT_w2_OLR(G1H4(167),1,1,4)
call HGT_w2_invQ_OLR(G1H4(167),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(366)])
call HGT_w2_OLR(G1H2(283),1,1,2)
call HGT_w2_invQ_OLR(G1H2(283),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(283),[G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(60),G2H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(134)])
call HGT_w2_OLR(G1H4(72),1,1,4)
call HGT_w2_invQ_OLR(G1H4(72),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(121)])
call HGT_w2_OLR(G1H4(57),1,1,4)
call HGT_w2_invQ_OLR(G1H4(57),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(10),G1H4(101)])
call HGT_w2_OLR(G1H4(234),1,1,4)
call HGT_w2_invQ_OLR(G1H4(234),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G1H2(325),G1H2(142),G1H2(458)])
call HGT_w2_OLR(G1H2(306),1,1,2)
call HGT_w2_invQ_OLR(G1H2(306),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G1H2(306)])
call HGT_w2_OLR(G1H4(116),1,1,4)
call HGT_w2_invQ_OLR(G1H4(116),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(202)])
call HGT_w2_OLR(G1H4(26),1,1,4)
call HGT_w2_invQ_OLR(G1H4(26),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(241)])
call HGT_w2_OLR(G1H4(58),1,1,4)
call HGT_w2_invQ_OLR(G1H4(58),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(44)])
call HGT_w2_OLR(G1H4(59),1,1,4)
call HGT_w2_invQ_OLR(G1H4(59),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(63)])
call HGT_w2_OLR(G1H8(84),1,1,8)
call HGT_w2_invQ_OLR(G1H8(84),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(142)])
call HGT_w2_OLR(G1H8(89),1,1,8)
call HGT_w2_invQ_OLR(G1H8(89),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(110)])
call HGT_w2_OLR(G1H8(95),1,1,8)
call HGT_w2_invQ_OLR(G1H8(95),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(111),[G1H8(137)])
call HGT_w2_OLR(G1H8(102),1,1,8)
call HGT_w2_invQ_OLR(G1H8(102),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(266),[G1H2(344)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(176),G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(296),[G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(308),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(239),G1H4(33),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(152),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(414),[G1H2(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(116),[G1H2(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(185),G1H2(241),G1H2(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(307),[G1H2(295),G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(468),[G1H2(284),G1H2(265),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(231),[G1H2(147),G1H2(175),G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(215),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(341),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(36),G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(45),G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(243),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(66),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(228),G1H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(144),G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(225),G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(141),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(147),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G1H8(87),G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(82),G1H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G1H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G1H8(117),G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(42),G1H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(122)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(236),ex4(:),G2tensor(2),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(187),ex4(:),G2tensor(309),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(238),ex3(:),G2tensor(6),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(163),ex3(:),G2tensor(3),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(243),ex4(:),G2tensor(5),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(248),ex2(:),G2tensor(8),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(198),ex2(:),G2tensor(305),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hloop_QV_A(ntryL,G1H2(165),ex5(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(619))
  call Hloop_AV_Q(ntryL,G1H2(172),ex5(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(620))
  call Hloop_AV_Q(ntryL,G2H2(144),ex5(:),G2H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(621))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(9),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hloop_QV_A(ntryL,G2H2(140),ex5(:),G2H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(622))
  call Hloop_QV_A(ntryL,G1H4(186),wf4(:,1),G1H1(1),m3h4x1(:,197),heltab2x4(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(623))
  call Hloop_QV_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(624))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(100),ex2(:),G2tensor(19),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hloop_QV_A(ntryL,G1H4(187),wf4(:,12),G1H1(1),m3h4x1(:,198),heltab2x4(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(697),n2h1(625))
  call Hloop_AV_Q(ntryL,G1H2(313),ex5(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(688),n2h1(626))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(109),ex1(:),G2tensor(685),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hloop_QV_A(ntryL,G1H2(217),ex5(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(627))
  call Hloop_QV_A(ntryL,G1H2(312),ex5(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(333),n2h1(628))
  call Hloop_AV_Q(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(629))
  call Hloop_AV_Q(ntryL,G2H4(42),wf4(:,1),G2H1(1),m3h4x1(:,199),heltab2x4(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(9),n2h1(630))
  call Hloop_AV_Q(ntryL,G2H2(62),ex5(:),G2H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(10),n2h1(631))
  call Hloop_QV_A(ntryL,G2H4(46),wf4(:,1),G2H1(1),m3h4x1(:,200),heltab2x4(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(11),n2h1(632))
  call Hloop_QV_A(ntryL,G2H2(63),ex5(:),G2H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(12),n2h1(633))
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,12),G2H1(1),m3h4x1(:,201),heltab2x4(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(13),n2h1(634))
  call Hloop_AV_Q(ntryL,G2H4(17),wf4(:,12),G2H1(1),m3h4x1(:,202),heltab2x4(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(14),n2h1(635))
  call Hloop_AV_Q(ntryL,G2H4(55),wf4(:,12),G2H1(1),m3h4x1(:,203),heltab2x4(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(15),n2h1(636))
  call Hloop_QV_A(ntryL,G2H4(59),wf4(:,12),G2H1(1),m3h4x1(:,204),heltab2x4(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(16),n2h1(637))
  call Hloop_VA_Q(ntryL,G1H2(271),ex2(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(638))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(53),wf4(:,13),G2tensor(27),m3h4x1(:,205),heltab2x4(:,:,587))
  call Hloop_VQ_A(ntryL,G1H2(272),ex1(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(639))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(35),wf4(:,18),G2tensor(186),m3h4x1(:,206),heltab2x4(:,:,588))
  call Hloop_VA_Q(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(640))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(21),wf4(:,4),G2tensor(189),m3h4x1(:,207),heltab2x4(:,:,589))
  call Hloop_VQ_A(ntryL,G1H4(167),wf4(:,4),G1H1(1),m3h4x1(:,208),heltab2x4(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(641))
  call Hloop_VQ_A(ntryL,G1H2(283),ex3(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(691),n2h1(642))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(7),wf4(:,9),G2tensor(682),m3h4x1(:,209),heltab2x4(:,:,591))
  call Hloop_VA_Q(ntryL,G1H4(72),wf4(:,9),G1H1(1),m3h4x1(:,210),heltab2x4(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(679),n2h1(643))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,1),G1H1(1),m3h4x1(:,211),heltab2x4(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(345),n2h1(644))
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,12),G2H1(1),m3h4x1(:,212),heltab2x4(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(17),n2h1(645))
  call Hloop_QV_A(ntryL,G2H2(233),ex5(:),G2H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(18),n2h1(646))
  call Hloop_AV_Q(ntryL,G1H4(116),wf4(:,1),G1H1(1),m3h4x1(:,213),heltab2x4(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(647))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,1),G1H1(1),m3h4x1(:,214),heltab2x4(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(648))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(44),wf8(:,3),G2tensor(96),m3h8x1(:,55),heltab2x8(:,:,428))
  call Hloop_AV_Q(ntryL,G1H4(58),wf4(:,12),G1H1(1),m3h4x1(:,215),heltab2x4(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(649))
  call Hloop_QV_A(ntryL,G1H4(59),wf4(:,12),G1H1(1),m3h4x1(:,216),heltab2x4(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(650))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,20),G2tensor(192),m3h8x1(:,56),heltab2x8(:,:,429))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,16),G2tensor(35),m3h8x1(:,57),heltab2x8(:,:,430))
  call Hloop_QV_A(ntryL,G1H8(84),wf8(:,12),G1H1(1),m3h8x1(:,58),heltab2x8(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(469),n2h1(651))
  call Hloop_QV_A(ntryL,G1H8(89),wf8(:,17),G1H1(1),m3h8x1(:,59),heltab2x8(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(652))
  call Hloop_QV_A(ntryL,G1H8(95),wf8(:,4),G1H1(1),m3h8x1(:,60),heltab2x8(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(653))
  call Hloop_QV_A(ntryL,G1H8(102),wf8(:,9),G1H1(1),m3h8x1(:,61),heltab2x8(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(466),n2h1(654))
  call Hloop_VA_Q(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(655))
  call Hloop_VA_Q(ntryL,G1H2(288),ex4(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(656))
  call Hloop_VQ_A(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(657))
  call Hloop_VQ_A(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(658))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(229),51,wf4(:,12),12,G2tensor(50),m3h4x1(:,217),heltab2x4(:,:,599))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(148),51,wf4(:,12),12,G2tensor(52),m3h4x1(:,218),heltab2x4(:,:,600))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(152),51,wf4(:,12),12,G2tensor(110),m3h4x1(:,219),heltab2x4(:,:,601))
  call Hloop_VQ_A(ntryL,G1H2(414),ex3(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(659))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(660))
  call Hloop_VQ_A(ntryL,G1H2(38),ex1(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(661))
  call Hloop_VA_Q(ntryL,G1H2(116),ex2(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(662))
  call Hloop_AV_Q(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(663))
  call Hloop_VQ_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(664))
  call Hloop_VA_Q(ntryL,G1H2(468),ex4(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(665))
  call Hloop_AV_Q(ntryL,G2H2(231),ex5(:),G2H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(19),n2h1(666))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(667))
  call Hloop_AV_Q(ntryL,G1H4(215),wf4(:,12),G1H1(1),m3h4x1(:,220),heltab2x4(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(668))
  call Hloop_VA_Q(ntryL,G1H2(341),ex2(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(669))
  call Hloop_VA_Q(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(670))
  call Hloop_VA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(671))
  call Hloop_VA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(672))
  call Hloop_VQ_A(ntryL,G1H4(81),wf4(:,13),G1H1(1),m3h4x1(:,221),heltab2x4(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(673))
  call Hloop_VQ_A(ntryL,G1H4(34),wf4(:,13),G1H1(1),m3h4x1(:,222),heltab2x4(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(674))
  call Hloop_VA_Q(ntryL,G1H4(103),wf4(:,18),G1H1(1),m3h4x1(:,223),heltab2x4(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(441),n2h1(675))
  call Hloop_VA_Q(ntryL,G1H4(128),wf4(:,18),G1H1(1),m3h4x1(:,224),heltab2x4(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(676))
  call Hloop_VQ_A(ntryL,G1H4(8),wf4(:,4),G1H1(1),m3h4x1(:,225),heltab2x4(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(677))
  call Hloop_VA_Q(ntryL,G1H4(54),wf4(:,9),G1H1(1),m3h4x1(:,226),heltab2x4(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(439),n2h1(678))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(96),51,wf4(:,12),12,G2tensor(317),m3h4x1(:,227),heltab2x4(:,:,609))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(127),51,wf4(:,12),12,G2tensor(80),m3h4x1(:,228),heltab2x4(:,:,610))
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,12),G2H1(1),m3h4x1(:,229),heltab2x4(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(20),n2h1(679))
  call Hloop_VQ_A(ntryL,G1H4(47),wf4(:,4),G1H1(1),m3h4x1(:,230),heltab2x4(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(680))
  call Hloop_VA_Q(ntryL,G1H4(77),wf4(:,9),G1H1(1),m3h4x1(:,231),heltab2x4(:,:,613))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(681))
  call Hloop_VQ_A(ntryL,G1H4(19),wf4(:,13),G1H1(1),m3h4x1(:,232),heltab2x4(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(673),n2h1(682))
  call Hloop_VA_Q(ntryL,G1H4(24),wf4(:,18),G1H1(1),m3h4x1(:,233),heltab2x4(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(664),n2h1(683))
  call Hloop_AV_Q(ntryL,G1H8(141),wf8(:,12),G1H1(1),m3h8x1(:,62),heltab2x8(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(661),n2h1(684))
  call Hloop_AV_Q(ntryL,G2H8(9),wf8(:,12),G2H1(1),m3h8x1(:,63),heltab2x8(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(21),n2h1(685))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(147),44,wf8(:,12),19,G2tensor(329),m3h8x1(:,64),heltab2x8(:,:,437))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(23),44,wf8(:,12),19,G3tensor(22),m3h8x1(:,65),heltab2x8(:,:,438))
  call Hloop_QV_A(ntryL,G2H8(7),wf8(:,12),G2H1(1),m3h8x1(:,66),heltab2x8(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(23),n2h1(686))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(76),44,wf8(:,12),19,G2tensor(90),m3h8x1(:,67),heltab2x8(:,:,440))
  call Hloop_AV_Q(ntryL,G1H8(7),wf8(:,17),G1H1(1),m3h8x1(:,68),heltab2x8(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(687))
  call Hloop_AV_Q(ntryL,G2H8(16),wf8(:,17),G2H1(1),m3h8x1(:,69),heltab2x8(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(24),n2h1(688))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(20),44,wf8(:,17),19,G2tensor(667),m3h8x1(:,70),heltab2x8(:,:,443))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(12),44,wf8(:,17),19,G3tensor(25),m3h8x1(:,71),heltab2x8(:,:,444))
  call Hloop_QV_A(ntryL,G2H8(24),wf8(:,17),G2H1(1),m3h8x1(:,72),heltab2x8(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(26),n2h1(689))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(92),44,wf8(:,17),19,G2tensor(658),m3h8x1(:,73),heltab2x8(:,:,446))
  call Hloop_AV_Q(ntryL,G1H8(25),wf8(:,4),G1H1(1),m3h8x1(:,74),heltab2x8(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(655),n2h1(690))
  call Hloop_AV_Q(ntryL,G2H8(6),wf8(:,4),G2H1(1),m3h8x1(:,75),heltab2x8(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(27),n2h1(691))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(30),35,wf8(:,4),28,G2tensor(321),m3h8x1(:,76),heltab2x8(:,:,449))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(27),35,wf8(:,4),28,G3tensor(28),m3h8x1(:,77),heltab2x8(:,:,450))
  call Hloop_QV_A(ntryL,G2H8(13),wf8(:,4),G2H1(1),m3h8x1(:,78),heltab2x8(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(29),n2h1(692))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(22),35,wf8(:,4),28,G2tensor(92),m3h8x1(:,79),heltab2x8(:,:,452))
  call Hloop_AV_Q(ntryL,G1H8(109),wf8(:,9),G1H1(1),m3h8x1(:,80),heltab2x8(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(693))
  call Hloop_AV_Q(ntryL,G2H8(29),wf8(:,9),G2H1(1),m3h8x1(:,81),heltab2x8(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(30),n2h1(694))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(59),35,wf8(:,9),28,G2tensor(102),m3h8x1(:,82),heltab2x8(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(5),35,wf8(:,9),28,G3tensor(31),m3h8x1(:,83),heltab2x8(:,:,456))
  call Hloop_QV_A(ntryL,G2H8(18),wf8(:,9),G2H1(1),m3h8x1(:,84),heltab2x8(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(32),n2h1(695))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(112),35,wf8(:,9),28,G2tensor(448),m3h8x1(:,85),heltab2x8(:,:,458))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(202),ex4(:),G2tensor(234),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(205),ex3(:),G2tensor(104),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(207),ex4(:),G2tensor(454),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(209),ex2(:),G2tensor(258),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(210),ex2(:),G2tensor(108),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(213),ex1(:),G2tensor(132),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(66),wf4(:,13),G2tensor(111),m3h4x1(:,234),heltab2x4(:,:,616))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(58),wf4(:,18),G2tensor(156),m3h4x1(:,235),heltab2x4(:,:,617))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(62),wf4(:,4),G2tensor(114),m3h4x1(:,236),heltab2x4(:,:,618))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(47),wf4(:,9),G2tensor(144),m3h4x1(:,237),heltab2x4(:,:,619))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(52),wf4(:,4),G2tensor(117),m3h4x1(:,238),heltab2x4(:,:,620))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(50),wf4(:,9),G2tensor(168),m3h4x1(:,239),heltab2x4(:,:,621))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(10),wf8(:,3),G2tensor(120),m3h8x1(:,86),heltab2x8(:,:,459))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(2),wf4(:,13),G2tensor(122),m3h4x1(:,240),heltab2x4(:,:,622))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(49),wf4(:,18),G2tensor(123),m3h4x1(:,241),heltab2x4(:,:,623))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(30),wf8(:,20),G2tensor(126),m3h8x1(:,87),heltab2x8(:,:,460))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(22),wf8(:,16),G2tensor(128),m3h8x1(:,88),heltab2x8(:,:,461))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(129),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex2(:),G2tensor(134),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(25),35,wf8(:,4),G3tensor(33),m3h8x1(:,89),heltab2x8(:,:,462))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(28),35,wf8(:,4),28,G3tensor(34),m3h8x1(:,90),heltab2x8(:,:,463))
  call Hloop_VQ_A(ntryL,G1H16(22),wf16(:,22),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(696))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(22),wf16(:,22),G2tensor(138),m3h16x1(:,2),heltab2x16(:,:,282))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(26),35,wf8(:,9),G3tensor(35),m3h8x1(:,91),heltab2x8(:,:,464))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(14),35,wf8(:,9),28,G3tensor(36),m3h8x1(:,92),heltab2x8(:,:,465))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(140),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hloop_VA_Q(ntryL,G1H16(7),wf16(:,25),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(697))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(1),wf16(:,25),G2tensor(275),m3h16x1(:,4),heltab2x16(:,:,284))
  call Hloop_VQ_A(ntryL,G1H16(18),wf16(:,38),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(698))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(2),wf16(:,38),G2tensor(147),m3h16x1(:,6),heltab2x16(:,:,286))
  call Hloop_VA_Q(ntryL,G1H16(12),wf16(:,43),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(699))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(3),wf16(:,43),G2tensor(278),m3h16x1(:,8),heltab2x16(:,:,288))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(20),44,wf8(:,12),19,G3tensor(37),m3h8x1(:,93),heltab2x8(:,:,466))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(21),44,wf8(:,12),G3tensor(38),m3h8x1(:,94),heltab2x8(:,:,467))
  call Hloop_VQ_A(ntryL,G1H16(25),wf16(:,30),G1H1(1),m3h16x1(:,9),heltab2x16(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(700))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(4),wf16(:,30),G2tensor(153),m3h16x1(:,10),heltab2x16(:,:,290))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(36),44,wf8(:,17),19,G3tensor(39),m3h8x1(:,95),heltab2x8(:,:,468))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(11),44,wf8(:,17),G3tensor(40),m3h8x1(:,96),heltab2x8(:,:,469))
  call Hloop_VA_Q(ntryL,G1H16(45),wf16(:,32),G1H1(1),m3h16x1(:,11),heltab2x16(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(701))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(5),wf16(:,32),G2tensor(158),m3h16x1(:,12),heltab2x16(:,:,292))
  call Hloop_VQ_A(ntryL,G1H16(2),wf16(:,53),G1H1(1),m3h16x1(:,13),heltab2x16(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(702))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(6),wf16(:,53),G2tensor(162),m3h16x1(:,14),heltab2x16(:,:,294))
  call Hloop_VA_Q(ntryL,G1H16(1),wf16(:,59),G1H1(1),m3h16x1(:,15),heltab2x16(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(703))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(7),wf16(:,59),G2tensor(164),m3h16x1(:,16),heltab2x16(:,:,296))
  call Hloop_VQ_A(ntryL,G1H16(6),wf16(:,65),G1H1(1),m3h16x1(:,17),heltab2x16(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(704))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(8),wf16(:,65),G2tensor(308),m3h16x1(:,18),heltab2x16(:,:,298))
  call Hloop_VA_Q(ntryL,G1H16(14),wf16(:,67),G1H1(1),m3h16x1(:,19),heltab2x16(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(705))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(9),wf16(:,67),G2tensor(170),m3h16x1(:,20),heltab2x16(:,:,300))
  call Hloop_VQ_A(ntryL,G1H16(37),wf16(:,71),G1H1(1),m3h16x1(:,21),heltab2x16(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(304),n2h1(706))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(10),wf16(:,71),G2tensor(179),m3h16x1(:,22),heltab2x16(:,:,302))
  call Hloop_VA_Q(ntryL,G1H16(43),wf16(:,73),G1H1(1),m3h16x1(:,23),heltab2x16(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(707))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(11),wf16(:,73),G2tensor(182),m3h16x1(:,24),heltab2x16(:,:,304))
  call Hloop_VQ_A(ntryL,G1H16(48),wf16(:,77),G1H1(1),m3h16x1(:,25),heltab2x16(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(708))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(12),wf16(:,77),G2tensor(188),m3h16x1(:,26),heltab2x16(:,:,306))
  call Hloop_VA_Q(ntryL,G1H16(32),wf16(:,79),G1H1(1),m3h16x1(:,27),heltab2x16(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(709))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(13),wf16(:,79),G2tensor(194),m3h16x1(:,28),heltab2x16(:,:,308))
  call Hloop_VQ_A(ntryL,G1H16(39),wf16(:,83),G1H1(1),m3h16x1(:,29),heltab2x16(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(710))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(14),wf16(:,83),G2tensor(197),m3h16x1(:,30),heltab2x16(:,:,310))
  call Hloop_VA_Q(ntryL,G1H16(54),wf16(:,85),G1H1(1),m3h16x1(:,31),heltab2x16(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(200),n2h1(711))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(15),wf16(:,85),G2tensor(203),m3h16x1(:,32),heltab2x16(:,:,312))
  call ol_merge_tensors(G3tensor(8),[G3tensor(7),G2tensor(638),G2tensor(632),G2tensor(302),G2tensor(298),G1tensor(1183) &
    ,G1tensor(1178),G1tensor(1123),G1tensor(376),G1tensor(346),G1tensor(292),G1tensor(279),G1tensor(272),G0tensor(1186) &
    ,G0tensor(1181),G0tensor(1126),G0tensor(627),G0tensor(612),G0tensor(585),G0tensor(580),G0tensor(575)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(557),G2tensor(229),G2tensor(306),G1tensor(1127),G1tensor(1063),G1tensor(1028) &
    ,G1tensor(1018),G1tensor(413),G1tensor(334),G1tensor(242),G1tensor(157),G1tensor(127),G1tensor(82),G0tensor(1130) &
    ,G0tensor(1066),G0tensor(1031),G0tensor(1021),G0tensor(651),G0tensor(611),G0tensor(305),G0tensor(30),G0tensor(25) &
    ,G0tensor(20)])
  call ol_merge_tensors(G2tensor(688),[G2tensor(635),G2tensor(310),G1tensor(1192),G1tensor(1053),G1tensor(1043),G1tensor(1038) &
    ,G1tensor(694),G1tensor(382),G1tensor(74),G1tensor(35),G1tensor(4),G1tensor(37),G0tensor(1195),G0tensor(1056),G0tensor(1046) &
    ,G0tensor(1041),G0tensor(661),G0tensor(626),G0tensor(300),G0tensor(15),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(626),G2tensor(593),G2tensor(473),G2tensor(311),G1tensor(1177),G1tensor(321) &
    ,G1tensor(538),G1tensor(711),G1tensor(588),G1tensor(678),G0tensor(1180),G0tensor(596),G0tensor(440),G0tensor(435) &
    ,G0tensor(228),G0tensor(203)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(596),G2tensor(554),G2tensor(479),G2tensor(118),G2tensor(312),G1tensor(1122) &
    ,G1tensor(371),G1tensor(53),G1tensor(33),G1tensor(672),G1tensor(156),G0tensor(1125),G0tensor(606),G0tensor(455),G0tensor(243) &
    ,G0tensor(218),G0tensor(170)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(36),G2tensor(641),G2tensor(587),G2tensor(485),G2tensor(313),G1tensor(1197) &
    ,G1tensor(377),G1tensor(137),G1tensor(140),G1tensor(141),G1tensor(5),G1tensor(158),G1tensor(660),G0tensor(1200),G0tensor(631) &
    ,G0tensor(505),G0tensor(500),G0tensor(278),G0tensor(253),G0tensor(131),G0tensor(126)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(33),G2tensor(590),G2tensor(560),G2tensor(491),G2tensor(130),G2tensor(314) &
    ,G1tensor(1142),G1tensor(407),G1tensor(179),G1tensor(85),G1tensor(600),G1tensor(563),G1tensor(703),G1tensor(673) &
    ,G0tensor(1145),G0tensor(646),G0tensor(530),G0tensor(293),G0tensor(268),G0tensor(175),G0tensor(121),G0tensor(116)])
  call ol_merge_tensors(G2tensor(454),[G2tensor(25),G2tensor(644),G2tensor(503),G2tensor(500),G2tensor(208),G2tensor(318) &
    ,G1tensor(1118),G1tensor(1113),G1tensor(837),G1tensor(347),G1tensor(44),G1tensor(61),G1tensor(308),G1tensor(212) &
    ,G0tensor(1121),G0tensor(1116),G0tensor(840),G0tensor(590),G0tensor(456),G0tensor(327),G0tensor(317),G0tensor(140)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(60),G2tensor(671),G2tensor(668),G2tensor(659),G2tensor(656),G2tensor(629) &
    ,G2tensor(509),G2tensor(322),G1tensor(1187),G1tensor(1158),G1tensor(763),G1tensor(566),G1tensor(495),G1tensor(316) &
    ,G1tensor(309),G1tensor(206),G1tensor(381),G1tensor(155),G1tensor(160),G1tensor(590),G1tensor(452),G1tensor(627) &
    ,G0tensor(1190),G0tensor(1161),G0tensor(766),G0tensor(696),G0tensor(686),G0tensor(601),G0tensor(595),G0tensor(540) &
    ,G0tensor(535),G0tensor(515),G0tensor(510),G0tensor(276),G0tensor(266),G0tensor(160)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(691),G2tensor(647),G2tensor(512),G2tensor(497),G2tensor(112),G2tensor(326) &
    ,G1tensor(817),G1tensor(322),G1tensor(698),G1tensor(314),G1tensor(318),G1tensor(192),G0tensor(820),G0tensor(600),G0tensor(436) &
    ,G0tensor(322),G0tensor(312),G0tensor(135)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(677),G2tensor(674),G2tensor(665),G2tensor(662),G2tensor(623),G2tensor(518) &
    ,G2tensor(330),G1tensor(1167),G1tensor(1163),G1tensor(798),G1tensor(733),G1tensor(723),G1tensor(581),G1tensor(341) &
    ,G1tensor(647),G1tensor(230),G1tensor(123),G1tensor(112),G1tensor(96),G1tensor(3),G1tensor(702),G0tensor(1170),G0tensor(1166) &
    ,G0tensor(801),G0tensor(736),G0tensor(726),G0tensor(605),G0tensor(591),G0tensor(560),G0tensor(555),G0tensor(485),G0tensor(480) &
    ,G0tensor(291),G0tensor(251),G0tensor(155)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(701),G2tensor(698),G2tensor(689),G2tensor(686),G2tensor(548),G2tensor(521) &
    ,G2tensor(354),G2tensor(334),G1tensor(431),G1tensor(363),G1tensor(340),G1tensor(25),G1tensor(290),G1tensor(372),G1tensor(180) &
    ,G1tensor(247),G1tensor(217),G1tensor(187),G0tensor(645),G0tensor(616),G0tensor(610),G0tensor(315),G0tensor(310),G0tensor(241) &
    ,G0tensor(201),G0tensor(45),G0tensor(40),G0tensor(35)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(94),G2tensor(650),G2tensor(581),G2tensor(527),G2tensor(338),G1tensor(1138) &
    ,G1tensor(1133),G1tensor(1042),G1tensor(364),G1tensor(351),G1tensor(280),G1tensor(287),G1tensor(263),G0tensor(1141) &
    ,G0tensor(1136),G0tensor(1045),G0tensor(620),G0tensor(615),G0tensor(557),G0tensor(531),G0tensor(512)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(68),G2tensor(695),G2tensor(692),G2tensor(683),G2tensor(680),G2tensor(539) &
    ,G2tensor(533),G2tensor(346),G2tensor(342),G1tensor(676),G1tensor(388),G1tensor(412),G1tensor(320),G1tensor(49),G1tensor(611) &
    ,G1tensor(534),G1tensor(337),G1tensor(307),G1tensor(277),G0tensor(636),G0tensor(630),G0tensor(625),G0tensor(325),G0tensor(320) &
    ,G0tensor(226),G0tensor(216),G0tensor(60),G0tensor(55),G0tensor(50)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(653),G2tensor(575),G2tensor(542),G2tensor(350),G1tensor(1017),G1tensor(478) &
    ,G1tensor(383),G1tensor(200),G1tensor(135),G1tensor(345),G0tensor(1020),G0tensor(640),G0tensor(635),G0tensor(537) &
    ,G0tensor(501),G0tensor(482)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(31),G2tensor(498),G2tensor(461),G2tensor(418),G2tensor(178),G1tensor(832) &
    ,G1tensor(820),G1tensor(278),G1tensor(532),G1tensor(289),G1tensor(199),G0tensor(835),G0tensor(823),G0tensor(578),G0tensor(441) &
    ,G0tensor(52),G0tensor(37)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G3tensor(34),G3tensor(33),G3tensor(32),G3tensor(31),G3tensor(30),G3tensor(29) &
    ,G3tensor(28),G3tensor(27),G3tensor(6),G3tensor(5),G3tensor(3),G3tensor(1),G2tensor(648),G2tensor(645),G2tensor(639) &
    ,G2tensor(633),G2tensor(516),G2tensor(507),G2tensor(465),G2tensor(462),G2tensor(442),G2tensor(440),G2tensor(351),G2tensor(339) &
    ,G2tensor(11),G2tensor(73),G1tensor(1175),G1tensor(855),G1tensor(835),G1tensor(275),G1tensor(690),G1tensor(168),G1tensor(319) &
    ,G1tensor(229),G0tensor(1178),G0tensor(858),G0tensor(838),G0tensor(583),G0tensor(143),G0tensor(138),G0tensor(57) &
    ,G0tensor(42)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(679),G2tensor(501),G2tensor(464),G2tensor(410),G2tensor(43),G1tensor(852) &
    ,G1tensor(840),G1tensor(575),G1tensor(557),G1tensor(349),G1tensor(259),G0tensor(855),G0tensor(843),G0tensor(588),G0tensor(171) &
    ,G0tensor(62),G0tensor(47)])
  call ol_merge_tensors(G2tensor(658),[G2tensor(90),G2tensor(40),G2tensor(469),G2tensor(563),G2tensor(555),G2tensor(552) &
    ,G2tensor(220),G2tensor(115),G1tensor(1125),G1tensor(1110),G1tensor(907),G1tensor(524),G1tensor(360),G1tensor(564) &
    ,G1tensor(625),G1tensor(565),G0tensor(1128),G0tensor(1113),G0tensor(910),G0tensor(388),G0tensor(343),G0tensor(156) &
    ,G0tensor(108),G0tensor(98)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(176),G2tensor(170),G2tensor(173),G2tensor(278),G2tensor(150),G2tensor(275) &
    ,G2tensor(141),G2tensor(672),G2tensor(669),G2tensor(660),G2tensor(657),G2tensor(597),G2tensor(564),G2tensor(483),G2tensor(451) &
    ,G2tensor(449),G2tensor(364),G2tensor(214),G1tensor(1105),G1tensor(1090),G1tensor(1005),G1tensor(910),G1tensor(464) &
    ,G1tensor(374),G1tensor(59),G1tensor(326),G1tensor(545),G1tensor(653),G1tensor(689),G0tensor(1108),G0tensor(1093) &
    ,G0tensor(1008),G0tensor(913),G0tensor(393),G0tensor(348),G0tensor(193),G0tensor(183),G0tensor(173),G0tensor(168) &
    ,G0tensor(163)])
  call ol_merge_tensors(G2tensor(333),[G2tensor(551),G2tensor(217),G1tensor(1168),G1tensor(1107),G1tensor(978),G1tensor(858) &
    ,G1tensor(818),G1tensor(484),G1tensor(623),G1tensor(622),G1tensor(126),G0tensor(1171),G0tensor(1110),G0tensor(981) &
    ,G0tensor(861),G0tensor(821),G0tensor(656),G0tensor(355),G0tensor(350),G0tensor(165)])
  call ol_merge_tensors(G2tensor(448),[G2tensor(92),G2tensor(466),G2tensor(38),G2tensor(566),G2tensor(561),G2tensor(558) &
    ,G2tensor(232),G2tensor(226),G1tensor(1145),G1tensor(1130),G1tensor(937),G1tensor(638),G1tensor(414),G1tensor(655) &
    ,G1tensor(595),G1tensor(223),G0tensor(1148),G0tensor(1133),G0tensor(940),G0tensor(418),G0tensor(368),G0tensor(113) &
    ,G0tensor(103),G0tensor(41)])
  call ol_merge_tensors(G2tensor(203),[G2tensor(200),G2tensor(194),G2tensor(191),G2tensor(164),G2tensor(281),G2tensor(158) &
    ,G2tensor(272),G2tensor(696),G2tensor(693),G2tensor(684),G2tensor(681),G2tensor(591),G2tensor(567),G2tensor(537),G2tensor(495) &
    ,G2tensor(468),G2tensor(459),G2tensor(455),G2tensor(377),G2tensor(370),G2tensor(357),G2tensor(124),G1tensor(1060) &
    ,G1tensor(940),G1tensor(815),G1tensor(780),G1tensor(644),G1tensor(530),G1tensor(174),G1tensor(543),G1tensor(282),G1tensor(535) &
    ,G1tensor(505),G1tensor(415),G1tensor(325),G1tensor(145),G0tensor(1063),G0tensor(943),G0tensor(818),G0tensor(783) &
    ,G0tensor(423),G0tensor(373),G0tensor(198),G0tensor(188),G0tensor(178),G0tensor(93),G0tensor(88),G0tensor(73),G0tensor(58) &
    ,G0tensor(28)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(17),G2tensor(606),G2tensor(600),G2tensor(343),G2tensor(331),G1tensor(1193) &
    ,G1tensor(1165),G1tensor(1160),G1tensor(1132),G1tensor(1128),G1tensor(274),G0tensor(1196),G0tensor(1168),G0tensor(1163) &
    ,G0tensor(1135),G0tensor(1131),G0tensor(581)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13),G2tensor(52),G2tensor(609),G2tensor(603),G2tensor(347),G2tensor(335) &
    ,G1tensor(735),G1tensor(568),G1tensor(285),G1tensor(138),G1tensor(709),G1tensor(409),G1tensor(379),G0tensor(738),G0tensor(698) &
    ,G0tensor(582),G0tensor(132),G0tensor(122),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(612),G2tensor(411),G2tensor(355),G1tensor(1135),G1tensor(805),G1tensor(770) &
    ,G1tensor(90),G1tensor(133),G0tensor(1138),G0tensor(808),G0tensor(773),G0tensor(128),G0tensor(26)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(615),G2tensor(412),G2tensor(356),G1tensor(1140),G1tensor(810),G1tensor(775) &
    ,G1tensor(654),G1tensor(139),G0tensor(1143),G0tensor(813),G0tensor(778),G0tensor(133),G0tensor(27)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(618),G2tensor(358),G1tensor(730),G1tensor(533),G1tensor(685),G1tensor(10) &
    ,G0tensor(733),G0tensor(693),G0tensor(118),G0tensor(11)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(621),G2tensor(359),G1tensor(740),G1tensor(579),G1tensor(715),G1tensor(17) &
    ,G0tensor(743),G0tensor(703),G0tensor(123),G0tensor(12)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(195),G2tensor(188),G2tensor(185),G2tensor(162),G2tensor(159),G2tensor(153) &
    ,G2tensor(152),G2tensor(702),G2tensor(699),G2tensor(690),G2tensor(687),G2tensor(588),G2tensor(525),G2tensor(489),G2tensor(471) &
    ,G2tensor(457),G2tensor(453),G2tensor(374),G2tensor(367),G2tensor(360),G1tensor(1035),G1tensor(745),G1tensor(586) &
    ,G1tensor(159),G1tensor(512),G1tensor(177),G1tensor(475),G1tensor(445),G1tensor(385),G1tensor(235),G1tensor(23),G0tensor(1038) &
    ,G0tensor(748),G0tensor(708),G0tensor(508),G0tensor(288),G0tensor(263),G0tensor(83),G0tensor(78),G0tensor(68),G0tensor(43) &
    ,G0tensor(13)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(189),G2tensor(570),G2tensor(407),G2tensor(361),G1tensor(980),G1tensor(850) &
    ,G1tensor(148),G1tensor(716),G1tensor(696),G1tensor(720),G1tensor(529),G1tensor(469),G0tensor(983),G0tensor(853),G0tensor(467) &
    ,G0tensor(442),G0tensor(432),G0tensor(142),G0tensor(92),G0tensor(82)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(304),G2tensor(308),G2tensor(165),G2tensor(147),G2tensor(146),G2tensor(138) &
    ,G2tensor(135),G2tensor(678),G2tensor(675),G2tensor(666),G2tensor(663),G2tensor(594),G2tensor(477),G2tensor(447),G2tensor(362) &
    ,G1tensor(1095),G1tensor(1080),G1tensor(990),G1tensor(441),G1tensor(348),G1tensor(549),G1tensor(288),G0tensor(1098) &
    ,G0tensor(1083),G0tensor(993),G0tensor(443),G0tensor(238),G0tensor(213),G0tensor(158)])
  call ol_merge_tensors(G2tensor(439),[G2tensor(682),G2tensor(573),G2tensor(405),G2tensor(363),G1tensor(995),G1tensor(830) &
    ,G1tensor(105),G1tensor(423),G1tensor(210),G1tensor(188),G1tensor(499),G1tensor(439),G0tensor(998),G0tensor(833),G0tensor(477) &
    ,G0tensor(452),G0tensor(172),G0tensor(137),G0tensor(87),G0tensor(77)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(76),G2tensor(576),G2tensor(365),G1tensor(1020),G1tensor(574),G1tensor(153) &
    ,G1tensor(129),G0tensor(1023),G0tensor(542),G0tensor(506),G0tensor(487)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(27),G2tensor(579),G2tensor(366),G1tensor(1089),G1tensor(1079),G1tensor(1030) &
    ,G1tensor(370),G1tensor(224),G1tensor(142),G1tensor(233),G0tensor(1092),G0tensor(1082),G0tensor(1033),G0tensor(622) &
    ,G0tensor(552),G0tensor(507),G0tensor(497)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(441),G2tensor(582),G2tensor(413),G2tensor(368),G1tensor(1150),G1tensor(1045) &
    ,G1tensor(238),G1tensor(170),G1tensor(258),G0tensor(1153),G0tensor(1048),G0tensor(562),G0tensor(517),G0tensor(176)])
  call ol_merge_tensors(G2tensor(325),[G2tensor(186),G2tensor(585),G2tensor(414),G2tensor(369),G1tensor(1155),G1tensor(1104) &
    ,G1tensor(1094),G1tensor(1055),G1tensor(406),G1tensor(261),G1tensor(189),G1tensor(551),G0tensor(1158),G0tensor(1107) &
    ,G0tensor(1097),G0tensor(1058),G0tensor(642),G0tensor(572),G0tensor(527),G0tensor(177)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(82),G2tensor(624),G2tensor(406),G2tensor(371),G1tensor(1170),G1tensor(962) &
    ,G1tensor(39),G1tensor(615),G1tensor(198),G1tensor(643),G0tensor(1173),G0tensor(965),G0tensor(398),G0tensor(151),G0tensor(141) &
    ,G0tensor(111)])
  call ol_merge_tensors(G2tensor(667),[G2tensor(86),G2tensor(329),G2tensor(661),G2tensor(627),G2tensor(372),G1tensor(1180) &
    ,G1tensor(1100),G1tensor(1085),G1tensor(284),G0tensor(1183),G0tensor(1103),G0tensor(1088),G0tensor(161)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(39),G3tensor(38),G3tensor(37),G3tensor(26),G3tensor(25),G3tensor(24),G3tensor(23) &
    ,G3tensor(22),G3tensor(21),G3tensor(4),G3tensor(2),G2tensor(654),G2tensor(651),G2tensor(546),G2tensor(531),G2tensor(438) &
    ,G2tensor(436),G1tensor(1185),G1tensor(395),G1tensor(359),G1tensor(270),G1tensor(552),G0tensor(1188),G0tensor(643) &
    ,G0tensor(623),G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(84),G2tensor(630),G2tensor(404),G2tensor(373),G1tensor(1190),G1tensor(922) &
    ,G1tensor(8),G1tensor(240),G1tensor(162),G1tensor(583),G0tensor(1193),G0tensor(925),G0tensor(353),G0tensor(146),G0tensor(136) &
    ,G0tensor(101)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(673),G2tensor(524),G2tensor(522),G2tensor(470),G2tensor(425),G2tensor(375) &
    ,G1tensor(1083),G1tensor(670),G1tensor(707),G1tensor(358),G1tensor(335),G1tensor(12),G1tensor(613),G1tensor(367) &
    ,G0tensor(1086),G0tensor(720),G0tensor(680),G0tensor(621),G0tensor(613),G0tensor(303),G0tensor(106),G0tensor(65)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(88),G2tensor(321),G2tensor(655),G2tensor(642),G2tensor(636),G2tensor(378) &
    ,G2tensor(376),G1tensor(1200),G1tensor(1195),G1tensor(895),G1tensor(875),G1tensor(246),G1tensor(633),G1tensor(313) &
    ,G0tensor(1203),G0tensor(1198),G0tensor(898),G0tensor(878),G0tensor(153),G0tensor(148),G0tensor(56)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(664),G2tensor(536),G2tensor(534),G2tensor(467),G2tensor(422),G2tensor(379) &
    ,G1tensor(1098),G1tensor(792),G1tensor(757),G1tensor(467),G1tensor(454),G1tensor(266),G1tensor(553),G1tensor(397) &
    ,G0tensor(1101),G0tensor(795),G0tensor(760),G0tensor(641),G0tensor(628),G0tensor(308),G0tensor(96),G0tensor(70)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(408),G1tensor(1115),G1tensor(78),G0tensor(1118),G0tensor(166)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(409),G1tensor(1120),G1tensor(701),G0tensor(1123),G0tensor(167)])
  call ol_merge_tensors(G2tensor(519),[G2tensor(476),G2tensor(474),G1tensor(987),G1tensor(329),G1tensor(710),G1tensor(606) &
    ,G1tensor(550),G0tensor(990),G0tensor(608),G0tensor(438),G0tensor(233),G0tensor(208)])
  call ol_merge_tensors(G2tensor(510),[G2tensor(482),G2tensor(480),G1tensor(1002),G1tensor(327),G1tensor(45),G1tensor(626) &
    ,G1tensor(629),G0tensor(1005),G0tensor(598),G0tensor(458),G0tensor(248),G0tensor(223)])
  call ol_merge_tensors(G2tensor(549),[G2tensor(488),G2tensor(486),G1tensor(1032),G1tensor(514),G1tensor(136),G1tensor(498) &
    ,G1tensor(632),G0tensor(1035),G0tensor(648),G0tensor(503),G0tensor(283),G0tensor(258)])
  call ol_merge_tensors(G2tensor(540),[G2tensor(494),G2tensor(492),G1tensor(1057),G1tensor(419),G1tensor(191),G1tensor(554) &
    ,G1tensor(24),G0tensor(1060),G0tensor(633),G0tensor(533),G0tensor(298),G0tensor(273)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G2tensor(515),G2tensor(513),G2tensor(506),G2tensor(504),G1tensor(1172) &
    ,G1tensor(401),G1tensor(683),G1tensor(317),G1tensor(299),G0tensor(1175),G0tensor(647),G0tensor(632),G0tensor(603) &
    ,G0tensor(593)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G2tensor(545),G2tensor(543),G2tensor(530),G2tensor(528),G1tensor(1182) &
    ,G1tensor(400),G1tensor(369),G1tensor(365),G1tensor(310),G0tensor(1185),G0tensor(638),G0tensor(618),G0tensor(607) &
    ,G0tensor(597)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(569),G1tensor(977),G1tensor(305),G1tensor(57),G1tensor(704),G1tensor(674) &
    ,G0tensor(980),G0tensor(592),G0tensor(462),G0tensor(437),G0tensor(427)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(572),G1tensor(992),G1tensor(328),G1tensor(215),G1tensor(64),G1tensor(195) &
    ,G0tensor(995),G0tensor(602),G0tensor(472),G0tensor(457),G0tensor(447)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(578),G1tensor(1027),G1tensor(352),G1tensor(262),G1tensor(146),G1tensor(124) &
    ,G0tensor(1030),G0tensor(617),G0tensor(547),G0tensor(502),G0tensor(492)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(584),G1tensor(1052),G1tensor(424),G1tensor(417),G1tensor(281),G1tensor(303) &
    ,G0tensor(1055),G0tensor(637),G0tensor(567),G0tensor(532),G0tensor(522)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(599),G1tensor(1157),G1tensor(952),G1tensor(888),G1tensor(848),G1tensor(267) &
    ,G1tensor(32),G1tensor(468),G0tensor(1160),G0tensor(955),G0tensor(891),G0tensor(851),G0tensor(576),G0tensor(406) &
    ,G0tensor(396)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(602),G1tensor(759),G1tensor(754),G1tensor(539),G1tensor(479),G1tensor(508) &
    ,G1tensor(405),G0tensor(762),G0tensor(757),G0tensor(695),G0tensor(682),G0tensor(677),G0tensor(577)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(605),G1tensor(1162),G1tensor(912),G1tensor(868),G1tensor(828),G1tensor(304) &
    ,G1tensor(396),G1tensor(378),G0tensor(1165),G0tensor(915),G0tensor(871),G0tensor(831),G0tensor(586),G0tensor(361) &
    ,G0tensor(351)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(5),G2tensor(608),G1tensor(1114),G1tensor(908),G1tensor(794),G1tensor(789) &
    ,G1tensor(732),G1tensor(699),G1tensor(713),G1tensor(293),G0tensor(1117),G0tensor(911),G0tensor(797),G0tensor(792) &
    ,G0tensor(735),G0tensor(722),G0tensor(717),G0tensor(587)])
  call ol_merge_tensors(G2tensor(258),[G2tensor(611),G1tensor(1153),G1tensor(1148),G1tensor(782),G1tensor(747),G1tensor(336) &
    ,G1tensor(6),G1tensor(48),G0tensor(1156),G0tensor(1151),G0tensor(785),G0tensor(750),G0tensor(331),G0tensor(306) &
    ,G0tensor(125)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(614),G1tensor(787),G1tensor(752),G1tensor(231),G1tensor(548),G1tensor(101) &
    ,G0tensor(790),G0tensor(755),G0tensor(341),G0tensor(307),G0tensor(130)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(617),G1tensor(645),G1tensor(459),G1tensor(597),G1tensor(542),G1tensor(667) &
    ,G0tensor(710),G0tensor(670),G0tensor(376),G0tensor(301),G0tensor(115)])
  call ol_merge_tensors(G2tensor(685),[G2tensor(620),G1tensor(665),G1tensor(461),G1tensor(593),G1tensor(218),G1tensor(697) &
    ,G0tensor(715),G0tensor(675),G0tensor(386),G0tensor(302),G0tensor(120)])
  call ol_merge_tensors(G1tensor(521),[G1tensor(460),G1tensor(73),G0tensor(690),G0tensor(673),G0tensor(6)])
  call ol_merge_tensors(G1tensor(572),[G1tensor(472),G1tensor(109),G0tensor(700),G0tensor(678),G0tensor(7)])
  call ol_merge_tensors(G1tensor(825),[G1tensor(717),G1tensor(473),G1tensor(561),G1tensor(205),G1tensor(68),G0tensor(828) &
    ,G0tensor(705),G0tensor(683),G0tensor(211),G0tensor(38),G0tensor(8)])
  call ol_merge_tensors(G1tensor(727),[G1tensor(706),G1tensor(444),G1tensor(42),G0tensor(730),G0tensor(713),G0tensor(381) &
    ,G0tensor(16)])
  call ol_merge_tensors(G1tensor(737),[G1tensor(695),G1tensor(603),G1tensor(52),G0tensor(740),G0tensor(718),G0tensor(391) &
    ,G0tensor(17)])
  call ol_merge_tensors(G1tensor(845),[G1tensor(742),G1tensor(705),G1tensor(657),G1tensor(265),G1tensor(60),G0tensor(848) &
    ,G0tensor(745),G0tensor(723),G0tensor(191),G0tensor(48),G0tensor(18)])
  call ol_merge_tensors(G1tensor(955),[G1tensor(767),G1tensor(750),G1tensor(87),G1tensor(482),G1tensor(94),G0tensor(958) &
    ,G0tensor(770),G0tensor(753),G0tensor(411),G0tensor(401),G0tensor(21)])
  call ol_merge_tensors(G1tensor(772),[G1tensor(755),G1tensor(102),G0tensor(775),G0tensor(758),G0tensor(22)])
  call ol_merge_tensors(G1tensor(865),[G1tensor(777),G1tensor(760),G1tensor(636),G1tensor(295),G1tensor(111),G0tensor(868) &
    ,G0tensor(780),G0tensor(763),G0tensor(236),G0tensor(53),G0tensor(23)])
  call ol_merge_tensors(G1tensor(915),[G1tensor(802),G1tensor(785),G1tensor(617),G1tensor(273),G1tensor(163),G0tensor(918) &
    ,G0tensor(805),G0tensor(788),G0tensor(356),G0tensor(336),G0tensor(31)])
  call ol_merge_tensors(G1tensor(807),[G1tensor(790),G1tensor(27),G1tensor(169),G0tensor(810),G0tensor(793),G0tensor(346) &
    ,G0tensor(32)])
  call ol_merge_tensors(G1tensor(885),[G1tensor(812),G1tensor(795),G1tensor(31),G1tensor(355),G1tensor(175),G0tensor(888) &
    ,G0tensor(815),G0tensor(798),G0tensor(181),G0tensor(63),G0tensor(33)])
  call ol_merge_tensors(G1tensor(436),[G1tensor(692),G1tensor(14),G1tensor(410),G1tensor(193),G0tensor(658),G0tensor(431) &
    ,G0tensor(370),G0tensor(365),G0tensor(36)])
  call ol_merge_tensors(G1tensor(449),[G1tensor(333),G1tensor(688),G1tensor(38),G1tensor(253),G0tensor(668),G0tensor(476) &
    ,G0tensor(420),G0tensor(415),G0tensor(46)])
  call ol_merge_tensors(G1tensor(872),[G1tensor(860),G1tensor(154),G1tensor(283),G0tensor(875),G0tensor(863),G0tensor(466) &
    ,G0tensor(51)])
  call ol_merge_tensors(G1tensor(892),[G1tensor(880),G1tensor(79),G1tensor(343),G0tensor(895),G0tensor(883),G0tensor(451) &
    ,G0tensor(61)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(697),G1tensor(1137),G1tensor(1129),G1tensor(725),G1tensor(513),G1tensor(679) &
    ,G1tensor(373),G0tensor(1140),G0tensor(1132),G0tensor(728),G0tensor(688),G0tensor(117),G0tensor(66)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(50),G1tensor(1194),G1tensor(800),G1tensor(765),G1tensor(132),G1tensor(403) &
    ,G0tensor(1197),G0tensor(803),G0tensor(768),G0tensor(127),G0tensor(71)])
  call ol_merge_tensors(G1tensor(822),[G1tensor(294),G1tensor(204),G1tensor(427),G0tensor(825),G0tensor(313),G0tensor(206) &
    ,G0tensor(75)])
  call ol_merge_tensors(G1tensor(932),[G1tensor(15),G1tensor(589),G1tensor(433),G0tensor(935),G0tensor(363),G0tensor(102) &
    ,G0tensor(76)])
  call ol_merge_tensors(G1tensor(842),[G1tensor(249),G1tensor(624),G1tensor(457),G0tensor(845),G0tensor(318),G0tensor(246) &
    ,G0tensor(80)])
  call ol_merge_tensors(G1tensor(972),[G1tensor(492),G1tensor(649),G1tensor(463),G0tensor(975),G0tensor(408),G0tensor(112) &
    ,G0tensor(81)])
  call ol_merge_tensors(G1tensor(862),[G1tensor(207),G1tensor(408),G1tensor(487),G0tensor(865),G0tensor(323),G0tensor(231) &
    ,G0tensor(85)])
  call ol_merge_tensors(G1tensor(870),[G1tensor(216),G1tensor(493),G0tensor(873),G0tensor(147),G0tensor(86)])
  call ol_merge_tensors(G1tensor(882),[G1tensor(324),G1tensor(570),G1tensor(517),G0tensor(885),G0tensor(328),G0tensor(221) &
    ,G0tensor(90)])
  call ol_merge_tensors(G1tensor(890),[G1tensor(260),G1tensor(523),G0tensor(893),G0tensor(152),G0tensor(91)])
  call ol_merge_tensors(G1tensor(418),[G1tensor(178),G1tensor(100),G1tensor(528),G1tensor(684),G1tensor(302),G1tensor(547) &
    ,G0tensor(650),G0tensor(491),G0tensor(481),G0tensor(220),G0tensor(215),G0tensor(180),G0tensor(95)])
  call ol_merge_tensors(G1tensor(1093),[G1tensor(902),G1tensor(97),G1tensor(559),G0tensor(1096),G0tensor(905),G0tensor(333) &
    ,G0tensor(97)])
  call ol_merge_tensors(G1tensor(712),[G1tensor(502),G1tensor(425),G1tensor(668),G1tensor(19),G1tensor(602),G1tensor(18) &
    ,G1tensor(519),G1tensor(577),G0tensor(676),G0tensor(671),G0tensor(655),G0tensor(426),G0tensor(311),G0tensor(270),G0tensor(265) &
    ,G0tensor(185),G0tensor(100)])
  call ol_merge_tensors(G1tensor(968),[G1tensor(958),G1tensor(953),G1tensor(437),G1tensor(243),G1tensor(221),G1tensor(92) &
    ,G1tensor(516),G1tensor(62),G1tensor(607),G0tensor(971),G0tensor(961),G0tensor(956),G0tensor(660),G0tensor(566),G0tensor(556) &
    ,G0tensor(245),G0tensor(240),G0tensor(190),G0tensor(105)])
  call ol_merge_tensors(G1tensor(1078),[G1tensor(947),G1tensor(440),G1tensor(619),G0tensor(1081),G0tensor(950),G0tensor(378) &
    ,G0tensor(107)])
  call ol_merge_tensors(G1tensor(943),[G1tensor(669),G1tensor(663),G1tensor(719),G1tensor(69),G1tensor(300),G1tensor(164) &
    ,G1tensor(656),G1tensor(120),G1tensor(637),G0tensor(946),G0tensor(716),G0tensor(711),G0tensor(665),G0tensor(471),G0tensor(316) &
    ,G0tensor(295),G0tensor(290),G0tensor(195),G0tensor(110)])
  call ol_merge_tensors(G1tensor(857),[G1tensor(753),G1tensor(748),G1tensor(76),G1tensor(312),G1tensor(114),G1tensor(494) &
    ,G1tensor(28),G1tensor(546),G0tensor(860),G0tensor(756),G0tensor(751),G0tensor(461),G0tensor(321),G0tensor(285),G0tensor(280) &
    ,G0tensor(275),G0tensor(145)])
  call ol_merge_tensors(G1tensor(898),[G1tensor(877),G1tensor(788),G1tensor(783),G1tensor(375),G1tensor(213),G1tensor(428) &
    ,G1tensor(9),G1tensor(404),G1tensor(222),G0tensor(901),G0tensor(880),G0tensor(791),G0tensor(786),G0tensor(446),G0tensor(326) &
    ,G0tensor(260),G0tensor(255),G0tensor(250),G0tensor(150)])
  call ol_merge_tensors(G1tensor(1000),[G1tensor(935),G1tensor(905),G1tensor(173),G1tensor(219),G1tensor(50),G1tensor(103) &
    ,G1tensor(555),G0tensor(1003),G0tensor(938),G0tensor(908),G0tensor(528),G0tensor(453),G0tensor(338),G0tensor(187) &
    ,G0tensor(182)])
  call ol_merge_tensors(G1tensor(1050),[G1tensor(925),G1tensor(165),G1tensor(392),G1tensor(344),G0tensor(1053),G0tensor(928) &
    ,G0tensor(518),G0tensor(358),G0tensor(186)])
  call ol_merge_tensors(G1tensor(1015),[G1tensor(950),G1tensor(220),G1tensor(99),G1tensor(46),G1tensor(36),G1tensor(108) &
    ,G0tensor(1018),G0tensor(953),G0tensor(553),G0tensor(478),G0tensor(383),G0tensor(287),G0tensor(192)])
  call ol_merge_tensors(G1tensor(1075),[G1tensor(965),G1tensor(227),G1tensor(591),G1tensor(70),G0tensor(1078),G0tensor(968) &
    ,G0tensor(563),G0tensor(403),G0tensor(196)])
  call ol_merge_tensors(G1tensor(1010),[G1tensor(975),G1tensor(251),G1tensor(89),G1tensor(504),G1tensor(432),G1tensor(651) &
    ,G0tensor(1013),G0tensor(978),G0tensor(573),G0tensor(468),G0tensor(413),G0tensor(237),G0tensor(197)])
  call ol_merge_tensors(G1tensor(1082),[G1tensor(1037),G1tensor(928),G1tensor(918),G1tensor(913),G1tensor(166),G1tensor(149) &
    ,G1tensor(228),G1tensor(556),G1tensor(652),G0tensor(1085),G0tensor(1040),G0tensor(931),G0tensor(921),G0tensor(916) &
    ,G0tensor(521),G0tensor(511),G0tensor(210),G0tensor(205),G0tensor(200)])
  call ol_merge_tensors(G1tensor(686),[G1tensor(662),G1tensor(150),G0tensor(430),G0tensor(425),G0tensor(202)])
  call ol_merge_tensors(G1tensor(982),[G1tensor(117),G1tensor(680),G1tensor(420),G1tensor(666),G0tensor(985),G0tensor(493) &
    ,G0tensor(428),G0tensor(257),G0tensor(207)])
  call ol_merge_tensors(G1tensor(985),[G1tensor(131),G1tensor(526),G1tensor(596),G1tensor(252),G0tensor(988),G0tensor(498) &
    ,G0tensor(433),G0tensor(262),G0tensor(212)])
  call ol_merge_tensors(G1tensor(501),[G1tensor(7),G1tensor(522),G0tensor(450),G0tensor(445),G0tensor(217)])
  call ol_merge_tensors(G1tensor(997),[G1tensor(182),G1tensor(43),G1tensor(54),G1tensor(635),G0tensor(1000),G0tensor(523) &
    ,G0tensor(448),G0tensor(272),G0tensor(222)])
  call ol_merge_tensors(G1tensor(1097),[G1tensor(1062),G1tensor(641),G1tensor(244),G1tensor(330),G1tensor(630),G1tensor(402) &
    ,G0tensor(1100),G0tensor(1065),G0tensor(546),G0tensor(536),G0tensor(235),G0tensor(230),G0tensor(225)])
  call ol_merge_tensors(G1tensor(640),[G1tensor(47),G1tensor(605),G0tensor(465),G0tensor(460),G0tensor(227)])
  call ol_merge_tensors(G1tensor(1007),[G1tensor(254),G1tensor(83),G1tensor(13),G1tensor(306),G0tensor(1010),G0tensor(568) &
    ,G0tensor(463),G0tensor(297),G0tensor(232)])
  call ol_merge_tensors(G1tensor(77),[G1tensor(84),G1tensor(620),G0tensor(475),G0tensor(470),G0tensor(242)])
  call ol_merge_tensors(G1tensor(1012),[G1tensor(214),G1tensor(209),G1tensor(594),G1tensor(390),G0tensor(1015),G0tensor(548) &
    ,G0tensor(473),G0tensor(282),G0tensor(247)])
  call ol_merge_tensors(G1tensor(808),[G1tensor(803),G1tensor(118),G1tensor(184),G1tensor(614),G0tensor(811),G0tensor(806) &
    ,G0tensor(495),G0tensor(490),G0tensor(252)])
  call ol_merge_tensors(G1tensor(1092),[G1tensor(1022),G1tensor(122),G1tensor(618),G0tensor(1095),G0tensor(1025),G0tensor(483) &
    ,G0tensor(256)])
  call ol_merge_tensors(G1tensor(1025),[G1tensor(107),G1tensor(16),G0tensor(1028),G0tensor(488),G0tensor(261)])
  call ol_merge_tensors(G1tensor(687),[G1tensor(525),G1tensor(183),G1tensor(176),G1tensor(22),G0tensor(701),G0tensor(691) &
    ,G0tensor(525),G0tensor(520),G0tensor(267)])
  call ol_merge_tensors(G1tensor(1087),[G1tensor(1047),G1tensor(257),G1tensor(65),G0tensor(1090),G0tensor(1050),G0tensor(513) &
    ,G0tensor(271)])
  call ol_merge_tensors(G1tensor(773),[G1tensor(768),G1tensor(399),G1tensor(202),G1tensor(147),G0tensor(776),G0tensor(771) &
    ,G0tensor(550),G0tensor(545),G0tensor(277)])
  call ol_merge_tensors(G1tensor(1102),[G1tensor(1067),G1tensor(196),G1tensor(34),G0tensor(1105),G0tensor(1070),G0tensor(538) &
    ,G0tensor(281)])
  call ol_merge_tensors(G1tensor(1070),[G1tensor(256),G1tensor(106),G0tensor(1073),G0tensor(543),G0tensor(286)])
  call ol_merge_tensors(G1tensor(738),[G1tensor(728),G1tensor(255),G1tensor(248),G1tensor(81),G0tensor(741),G0tensor(731) &
    ,G0tensor(570),G0tensor(565),G0tensor(292)])
  call ol_merge_tensors(G1tensor(1077),[G1tensor(1072),G1tensor(232),G1tensor(134),G0tensor(1080),G0tensor(1075),G0tensor(558) &
    ,G0tensor(296)])
  call ol_merge_tensors(G1tensor(1023),[G1tensor(983),G1tensor(823),G1tensor(447),G1tensor(496),G1tensor(628),G1tensor(350) &
    ,G1tensor(91),G0tensor(1026),G0tensor(986),G0tensor(826),G0tensor(657),G0tensor(652),G0tensor(360),G0tensor(335) &
    ,G0tensor(330)])
  call ol_merge_tensors(G1tensor(897),[G1tensor(56),G1tensor(338),G0tensor(900),G0tensor(342),G0tensor(332)])
  call ol_merge_tensors(G1tensor(930),[G1tensor(900),G1tensor(426),G1tensor(366),G1tensor(225),G0tensor(933),G0tensor(903) &
    ,G0tensor(372),G0tensor(347),G0tensor(337)])
  call ol_merge_tensors(G1tensor(491),[G1tensor(239),G1tensor(119),G1tensor(237),G1tensor(356),G0tensor(653),G0tensor(496) &
    ,G0tensor(486),G0tensor(345),G0tensor(340)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(2),G1tensor(1159),G1tensor(917),G1tensor(873),G1tensor(833),G1tensor(63) &
    ,G1tensor(380),G0tensor(1162),G0tensor(920),G0tensor(876),G0tensor(836),G0tensor(366),G0tensor(352)])
  call ol_merge_tensors(G1tensor(920),[G1tensor(634),G1tensor(384),G0tensor(923),G0tensor(371),G0tensor(357)])
  call ol_merge_tensors(G1tensor(927),[G1tensor(584),G1tensor(527),G1tensor(485),G1tensor(616),G1tensor(398),G0tensor(930) &
    ,G0tensor(706),G0tensor(692),G0tensor(687),G0tensor(367),G0tensor(362)])
  call ol_merge_tensors(G1tensor(1073),[G1tensor(1008),G1tensor(867),G1tensor(863),G1tensor(859),G1tensor(490),G1tensor(598) &
    ,G1tensor(51),G0tensor(1076),G0tensor(1011),G0tensor(870),G0tensor(866),G0tensor(862),G0tensor(662),G0tensor(380) &
    ,G0tensor(375)])
  call ol_merge_tensors(G1tensor(942),[G1tensor(450),G1tensor(438),G0tensor(945),G0tensor(387),G0tensor(377)])
  call ol_merge_tensors(G1tensor(945),[G1tensor(462),G1tensor(446),G0tensor(948),G0tensor(392),G0tensor(382)])
  call ol_merge_tensors(G1tensor(448),[G1tensor(250),G1tensor(286),G1tensor(75),G1tensor(599),G0tensor(663),G0tensor(571) &
    ,G0tensor(561),G0tensor(390),G0tensor(385)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(1188),G1tensor(993),G1tensor(878),G1tensor(838),G1tensor(497),G1tensor(536) &
    ,G1tensor(604),G0tensor(1191),G0tensor(996),G0tensor(881),G0tensor(841),G0tensor(666),G0tensor(400),G0tensor(395)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(6),G1tensor(1164),G1tensor(957),G1tensor(893),G1tensor(853),G1tensor(610) &
    ,G1tensor(470),G0tensor(1167),G0tensor(960),G0tensor(896),G0tensor(856),G0tensor(416),G0tensor(397)])
  call ol_merge_tensors(G1tensor(960),[G1tensor(648),G1tensor(93),G0tensor(963),G0tensor(421),G0tensor(402)])
  call ol_merge_tensors(G1tensor(1068),[G1tensor(1064),G1tensor(1013),G1tensor(843),G1tensor(455),G1tensor(500),G1tensor(488) &
    ,G0tensor(1071),G0tensor(1067),G0tensor(1016),G0tensor(846),G0tensor(667),G0tensor(410),G0tensor(405)])
  call ol_merge_tensors(G1tensor(967),[G1tensor(743),G1tensor(729),G1tensor(724),G1tensor(510),G1tensor(592),G0tensor(970) &
    ,G0tensor(746),G0tensor(732),G0tensor(727),G0tensor(417),G0tensor(407)])
  call ol_merge_tensors(G1tensor(970),[G1tensor(642),G1tensor(609),G0tensor(973),G0tensor(422),G0tensor(412)])
  call ol_merge_tensors(G1tensor(1040),[G1tensor(172),G1tensor(291),G0tensor(1043),G0tensor(526),G0tensor(516)])
  call ol_merge_tensors(G1tensor(1065),[G1tensor(268),G1tensor(197),G0tensor(1068),G0tensor(551),G0tensor(541)])
  call ol_merge_tensors(G1tensor(483),[G1tensor(515),G1tensor(471),G0tensor(685),G0tensor(681),G0tensor(672)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(309),G1tensor(1119),G1tensor(949),G1tensor(944),G1tensor(909),G1tensor(904) &
    ,G1tensor(899),G1tensor(834),G1tensor(829),G1tensor(779),G1tensor(774),G1tensor(585),G1tensor(578),G1tensor(567) &
    ,G0tensor(1122),G0tensor(952),G0tensor(947),G0tensor(912),G0tensor(907),G0tensor(902),G0tensor(837),G0tensor(832) &
    ,G0tensor(782),G0tensor(777),G0tensor(707),G0tensor(702),G0tensor(697)])
  call ol_merge_tensors(G1tensor(948),[G1tensor(722),G1tensor(675),G1tensor(718),G0tensor(951),G0tensor(725),G0tensor(721) &
    ,G0tensor(712)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(3),G1tensor(854),G1tensor(849),G1tensor(814),G1tensor(809),G1tensor(744) &
    ,G1tensor(739),G1tensor(734),G0tensor(857),G0tensor(852),G0tensor(817),G0tensor(812),G0tensor(747),G0tensor(742) &
    ,G0tensor(737)])
  call ol_merge_tensors(G1tensor(762),[G1tensor(758),G1tensor(749),G0tensor(765),G0tensor(761),G0tensor(752)])
  call ol_merge_tensors(G1tensor(874),[G1tensor(869),G1tensor(778),G1tensor(769),G1tensor(764),G0tensor(877),G0tensor(872) &
    ,G0tensor(781),G0tensor(772),G0tensor(767)])
  call ol_merge_tensors(G1tensor(903),[G1tensor(797),G1tensor(793),G1tensor(784),G0tensor(906),G0tensor(800),G0tensor(796) &
    ,G0tensor(787)])
  call ol_merge_tensors(G1tensor(894),[G1tensor(889),G1tensor(813),G1tensor(804),G1tensor(799),G0tensor(897),G0tensor(892) &
    ,G0tensor(816),G0tensor(807),G0tensor(802)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(1124),G1tensor(988),G1tensor(864),G1tensor(827),G1tensor(824),G1tensor(819) &
    ,G0tensor(1127),G0tensor(991),G0tensor(867),G0tensor(830),G0tensor(827),G0tensor(822)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(1179),G1tensor(1003),G1tensor(884),G1tensor(847),G1tensor(844),G1tensor(839) &
    ,G0tensor(1182),G0tensor(1006),G0tensor(887),G0tensor(850),G0tensor(847),G0tensor(842)])
  call ol_merge_tensors(G1tensor(1048),[G1tensor(1039),G1tensor(998),G1tensor(887),G1tensor(883),G1tensor(879),G0tensor(1051) &
    ,G0tensor(1042),G0tensor(1001),G0tensor(890),G0tensor(886),G0tensor(882)])
  call ol_merge_tensors(G1tensor(933),[G1tensor(923),G1tensor(914),G0tensor(936),G0tensor(926),G0tensor(917)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(8),G1tensor(1149),G1tensor(1134),G1tensor(964),G1tensor(959),G1tensor(938) &
    ,G1tensor(924),G1tensor(919),G0tensor(1152),G0tensor(1137),G0tensor(967),G0tensor(962),G0tensor(941),G0tensor(927) &
    ,G0tensor(922)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(305),G1tensor(1154),G1tensor(1139),G1tensor(974),G1tensor(969),G1tensor(939) &
    ,G1tensor(934),G1tensor(929),G0tensor(1157),G0tensor(1142),G0tensor(977),G0tensor(972),G0tensor(942),G0tensor(937) &
    ,G0tensor(932)])
  call ol_merge_tensors(G1tensor(973),[G1tensor(963),G1tensor(954),G0tensor(976),G0tensor(966),G0tensor(957)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(10),G1tensor(1184),G1tensor(1174),G1tensor(1059),G1tensor(1054),G1tensor(1034) &
    ,G1tensor(1029),G1tensor(1014),G1tensor(1009),G1tensor(1004),G1tensor(999),G1tensor(994),G1tensor(989),G1tensor(984) &
    ,G1tensor(979),G0tensor(1187),G0tensor(1177),G0tensor(1062),G0tensor(1057),G0tensor(1037),G0tensor(1032),G0tensor(1017) &
    ,G0tensor(1012),G0tensor(1007),G0tensor(1002),G0tensor(997),G0tensor(992),G0tensor(987),G0tensor(982)])
  call ol_merge_tensors(G2tensor(353),[G1tensor(1152),G1tensor(1144),G1tensor(1069),G1tensor(1033),G1tensor(1024),G1tensor(1019) &
    ,G0tensor(1155),G0tensor(1147),G0tensor(1072),G0tensor(1036),G0tensor(1027),G0tensor(1022)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(1199),G1tensor(1074),G1tensor(1058),G1tensor(1049),G1tensor(1044),G0tensor(1202) &
    ,G0tensor(1077),G0tensor(1061),G0tensor(1052),G0tensor(1047)])
  call ol_merge_tensors(G1tensor(1088),[G1tensor(1084),G0tensor(1091),G0tensor(1087)])
  call ol_merge_tensors(G1tensor(1103),[G1tensor(1099),G0tensor(1106),G0tensor(1102)])
  call ol_merge_tensors(G2tensor(345),[G1tensor(1112),G1tensor(1108),G0tensor(1115),G0tensor(1111)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(1117),G1tensor(1109),G0tensor(1120),G0tensor(1112)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(18),G1tensor(1198),G1tensor(1189),G1tensor(1173),G1tensor(1169),G1tensor(1147) &
    ,G1tensor(1143),G0tensor(1201),G0tensor(1192),G0tensor(1176),G0tensor(1172),G0tensor(1150),G0tensor(1146)])
  call ol_merge_tensors(G1tensor(1206),[G1tensor(1203)])
  call ol_merge_tensors(G1tensor(1212),[G1tensor(1204)])
  call ol_merge_tensors(G1tensor(1213),[G1tensor(1209)])
  call TI_triangle_red(G3tensor(8),RedBasis(224),mass3set(:,1),G0tensor(4),G0tensor(9),G0tensor(14),G0tensor(19),M2L1R1)
  call TI_triangle_red(G2tensor(183),RedBasis(183),mass3set(:,1),G0tensor(24),G0tensor(29),G0tensor(34),G0tensor(39),M2L1R1)
  call TI_triangle_red(G2tensor(688),RedBasis(192),mass3set(:,1),G0tensor(44),G0tensor(49),G0tensor(54),G0tensor(59),M2L1R1)
  call TI_triangle_red(G2tensor(341),RedBasis(267),mass3set(:,1),G0tensor(64),G0tensor(69),G0tensor(74),G0tensor(79),M2L1R1)
  call TI_triangle_red(G2tensor(100),RedBasis(268),mass3set(:,1),G0tensor(84),G0tensor(89),G0tensor(94),G0tensor(99),M2L1R1)
  call TI_triangle_red(G2tensor(317),RedBasis(11),mass3set(:,1),G0tensor(104),G0tensor(109),G0tensor(114),G0tensor(119),M2L1R1)
  call TI_triangle_red(G2tensor(80),RedBasis(6),mass3set(:,1),G0tensor(124),G0tensor(129),G0tensor(134),G0tensor(139),M2L1R1)
  call TI_triangle_red(G2tensor(454),RedBasis(208),mass3set(:,1),G0tensor(144),G0tensor(149),G0tensor(154),G0tensor(159),M2L1R1)
  call TI_triangle_red(G2tensor(129),RedBasis(73),mass3set(:,1),G0tensor(164),G0tensor(169),G0tensor(174),G0tensor(179),M2L1R1)
  call TI_triangle_red(G2tensor(140),RedBasis(231),mass3set(:,1),G0tensor(184),G0tensor(189),G0tensor(194),G0tensor(199),M2L1R1)
  call TI_triangle_red(G2tensor(119),RedBasis(83),mass3set(:,1),G0tensor(204),G0tensor(209),G0tensor(214),G0tensor(219),M2L1R1)
  call TI_triangle_red(G2tensor(66),RedBasis(269),mass3set(:,1),G0tensor(224),G0tensor(229),G0tensor(234),G0tensor(239),M2L1R1)
  call TI_triangle_red(G2tensor(108),RedBasis(209),mass3set(:,1),G0tensor(244),G0tensor(249),G0tensor(254),G0tensor(259),M2L1R1)
  call TI_triangle_red(G2tensor(134),RedBasis(270),mass3set(:,1),G0tensor(264),G0tensor(269),G0tensor(274),G0tensor(279),M2L1R1)
  call TI_triangle_red(G2tensor(21),RedBasis(245),mass3set(:,1),G0tensor(284),G0tensor(289),G0tensor(294),G0tensor(299),M2L1R1)
  call TI_triangle_red(G2tensor(117),RedBasis(44),mass3set(:,1),G0tensor(304),G0tensor(309),G0tensor(314),G0tensor(319),M2L1R1)
  call TI_triangle_red(G3tensor(36),RedBasis(12),mass3set(:,1),G0tensor(324),G0tensor(329),G0tensor(334),G0tensor(339),M2L1R1)
  call TI_triangle_red(G2tensor(168),RedBasis(46),mass3set(:,1),G0tensor(344),G0tensor(349),G0tensor(354),G0tensor(359),M2L1R1)
  call TI_triangle_red(G2tensor(658),RedBasis(211),mass3set(:,1),G0tensor(364),G0tensor(369),G0tensor(374),G0tensor(379),M2L1R1)
  call TI_triangle_red(G2tensor(182),RedBasis(23),mass3set(:,1),G0tensor(384),G0tensor(389),G0tensor(394),G0tensor(399),M2L1R1)
  call TI_triangle_red(G2tensor(333),RedBasis(159),mass3set(:,1),G0tensor(404),G0tensor(409),G0tensor(414),G0tensor(419),M2L1R1)
  call TI_triangle_red(G2tensor(448),RedBasis(14),mass3set(:,1),G0tensor(424),G0tensor(429),G0tensor(434),G0tensor(439),M2L1R1)
  call TI_triangle_red(G2tensor(203),RedBasis(7),mass3set(:,1),G0tensor(444),G0tensor(449),G0tensor(454),G0tensor(459),M2L1R1)
  call TI_triangle_red(G3tensor(20),RedBasis(205),mass3set(:,1),G0tensor(464),G0tensor(469),G0tensor(474),G0tensor(479),M2L1R1)
  call TI_triangle_red(G3tensor(14),RedBasis(3),mass3set(:,1),G0tensor(484),G0tensor(489),G0tensor(494),G0tensor(499),M2L1R1)
  call TI_triangle_red(G2tensor(128),RedBasis(9),mass3set(:,1),G0tensor(504),G0tensor(509),G0tensor(514),G0tensor(519),M2L1R1)
  call TI_triangle_red(G2tensor(35),RedBasis(8),mass3set(:,1),G0tensor(524),G0tensor(529),G0tensor(534),G0tensor(539),M2L1R1)
  call TI_triangle_red(G2tensor(126),RedBasis(4),mass3set(:,1),G0tensor(544),G0tensor(549),G0tensor(554),G0tensor(559),M2L1R1)
  call TI_triangle_red(G2tensor(192),RedBasis(2),mass3set(:,1),G0tensor(564),G0tensor(569),G0tensor(574),G0tensor(579),M2L1R1)
  call TI_triangle_red(G2tensor(197),RedBasis(1),mass3set(:,1),G0tensor(584),G0tensor(589),G0tensor(594),G0tensor(599),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(17),mass3set(:,1),G0tensor(604),G0tensor(609),G0tensor(614),G0tensor(619),M2L1R1)
  call TI_triangle_red(G2tensor(179),RedBasis(41),mass3set(:,1),G0tensor(624),G0tensor(629),G0tensor(634),G0tensor(639),M2L1R1)
  call TI_triangle_red(G2tensor(439),RedBasis(13),mass3set(:,1),G0tensor(644),G0tensor(649),G0tensor(654),G0tensor(659),M2L1R1)
  call TI_triangle_red(G2tensor(122),RedBasis(53),mass3set(:,1),G0tensor(664),G0tensor(669),G0tensor(674),G0tensor(679),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(51),mass3set(:,1),G0tensor(684),G0tensor(689),G0tensor(694),G0tensor(699),M2L1R1)
  call TI_triangle_red(G2tensor(123),RedBasis(56),mass3set(:,1),G0tensor(704),G0tensor(709),G0tensor(714),G0tensor(719),M2L1R1)
  call TI_triangle_red(G2tensor(325),RedBasis(55),mass3set(:,1),G0tensor(724),G0tensor(729),G0tensor(734),G0tensor(739),M2L1R1)
  call TI_triangle_red(G2tensor(114),RedBasis(19),mass3set(:,1),G0tensor(744),G0tensor(749),G0tensor(754),G0tensor(759),M2L1R1)
  call TI_triangle_red(G2tensor(667),RedBasis(223),mass3set(:,1),G0tensor(764),G0tensor(769),G0tensor(774),G0tensor(779),M2L1R1)
  call TI_triangle_red(G3tensor(40),RedBasis(222),mass3set(:,1),G0tensor(784),G0tensor(789),G0tensor(794),G0tensor(799),M2L1R1)
  call TI_triangle_red(G2tensor(144),RedBasis(16),mass3set(:,1),G0tensor(804),G0tensor(809),G0tensor(814),G0tensor(819),M2L1R1)
  call TI_triangle_red(G2tensor(111),RedBasis(218),mass3set(:,1),G0tensor(824),G0tensor(829),G0tensor(834),G0tensor(839),M2L1R1)
  call TI_triangle_red(G2tensor(102),RedBasis(20),mass3set(:,1),G0tensor(844),G0tensor(849),G0tensor(854),G0tensor(859),M2L1R1)
  call TI_triangle_red(G2tensor(156),RedBasis(214),mass3set(:,1),G0tensor(864),G0tensor(869),G0tensor(874),G0tensor(879),M2L1R1)
  call TI_triangle_red(G2tensor(120),RedBasis(207),mass3set(:,1),G0tensor(884),G0tensor(889),G0tensor(894),G0tensor(899),M2L1R1)
  call TI_triangle_red(G2tensor(96),RedBasis(206),mass3set(:,1),G0tensor(904),G0tensor(909),G0tensor(914),G0tensor(919),M2L1R1)
  call TI_triangle_red(G2tensor(519),RedBasis(227),mass3set(:,1),G0tensor(924),G0tensor(929),G0tensor(934),G0tensor(939),M2L1R1)
  call TI_triangle_red(G2tensor(510),RedBasis(233),mass3set(:,1),G0tensor(944),G0tensor(949),G0tensor(954),G0tensor(959),M2L1R1)
  call TI_triangle_red(G2tensor(549),RedBasis(242),mass3set(:,1),G0tensor(964),G0tensor(969),G0tensor(974),G0tensor(979),M2L1R1)
  call TI_triangle_red(G2tensor(540),RedBasis(247),mass3set(:,1),G0tensor(984),G0tensor(989),G0tensor(994),G0tensor(999),M2L1R1)
  call TI_triangle_red(G3tensor(16),RedBasis(265),mass3set(:,1),G0tensor(1004),G0tensor(1009),G0tensor(1014), &
    G0tensor(1019),M2L1R1)
  call TI_triangle_red(G3tensor(11),RedBasis(266),mass3set(:,1),G0tensor(1024),G0tensor(1029),G0tensor(1034), &
    G0tensor(1039),M2L1R1)
  call TI_triangle_red(G2tensor(54),RedBasis(229),mass3set(:,1),G0tensor(1044),G0tensor(1049),G0tensor(1054), &
    G0tensor(1059),M2L1R1)
  call TI_triangle_red(G2tensor(113),RedBasis(235),mass3set(:,1),G0tensor(1064),G0tensor(1069),G0tensor(1074), &
    G0tensor(1079),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(243),mass3set(:,1),G0tensor(1084),G0tensor(1089),G0tensor(1094), &
    G0tensor(1099),M2L1R1)
  call TI_triangle_red(G2tensor(116),RedBasis(248),mass3set(:,1),G0tensor(1104),G0tensor(1109),G0tensor(1114), &
    G0tensor(1119),M2L1R1)
  call TI_triangle_red(G2tensor(104),RedBasis(110),mass3set(:,1),G0tensor(1124),G0tensor(1129),G0tensor(1134), &
    G0tensor(1139),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(254),mass3set(:,1),G0tensor(1144),G0tensor(1149),G0tensor(1154), &
    G0tensor(1159),M2L1R1)
  call TI_triangle_red(G2tensor(234),RedBasis(101),mass3set(:,1),G0tensor(1164),G0tensor(1169),G0tensor(1174), &
    G0tensor(1179),M2L1R1)
  call TI_triangle_red(G2tensor(64),RedBasis(129),mass3set(:,1),G0tensor(1184),G0tensor(1189),G0tensor(1194), &
    G0tensor(1199),M2L1R1)
  call TI_triangle_red(G2tensor(258),RedBasis(210),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(1186),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(215),mass3set(:,1),G0tensor(1181),G0tensor(1126),G0tensor(627),G0tensor(612),M2L1R1)
  call TI_triangle_red(G2tensor(132),RedBasis(220),mass3set(:,1),G0tensor(585),G0tensor(580),G0tensor(575),G0tensor(1130),M2L1R1)
  call TI_triangle_red(G2tensor(685),RedBasis(219),mass3set(:,1),G0tensor(1066),G0tensor(1031),G0tensor(1021), &
    G0tensor(651),M2L1R1)
  call TI_triangle_red(G2tensor(110),RedBasis(5),mass3set(:,1),G0tensor(611),G0tensor(305),G0tensor(30),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(62),RedBasis(10),mass3set(:,1),G0tensor(20),G0tensor(1195),G0tensor(1056),G0tensor(1046),M2L1R1)
  call TI_triangle_red(G2tensor(44),RedBasis(71),mass3set(:,1),G0tensor(1041),G0tensor(661),G0tensor(626),G0tensor(300),M2L1R1)
  call TI_triangle_red(G2tensor(98),RedBasis(169),mass3set(:,1),G0tensor(15),G0tensor(10),G0tensor(5),G0tensor(1180),M2L1R1)
  call TI_triangle_red(G2tensor(46),RedBasis(72),mass3set(:,1),G0tensor(596),G0tensor(440),G0tensor(435),G0tensor(228),M2L1R1)
  call TI_triangle_red(G2tensor(42),RedBasis(61),mass3set(:,1),G0tensor(203),G0tensor(1125),G0tensor(606),G0tensor(455),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(64),mass3set(:,1),G0tensor(243),G0tensor(218),G0tensor(170),G0tensor(1200),M2L1R1)
  call TI_triangle_red(G2tensor(106),RedBasis(160),mass3set(:,1),G0tensor(631),G0tensor(505),G0tensor(500),G0tensor(278),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(170),mass3set(:,1),G0tensor(253),G0tensor(131),G0tensor(126),G0tensor(1145),M2L1R1)
  call TI_triangle_red(G2tensor(74),RedBasis(137),mass3set(:,1),G0tensor(646),G0tensor(530),G0tensor(293),G0tensor(268),M2L1R1)
  call TI_triangle_red(G2tensor(70),RedBasis(141),mass3set(:,1),G0tensor(175),G0tensor(121),G0tensor(116),G0tensor(1121),M2L1R1)
  call TI_triangle_red(G3tensor(12),RedBasis(161),mass3set(:,1),G0tensor(1116),G0tensor(840),G0tensor(590),G0tensor(456),M2L1R1)
  call TI_triangle_red(G2tensor(353),RedBasis(184),mass3set(:,1),G0tensor(327),G0tensor(317),G0tensor(140),G0tensor(1190),M2L1R1)
  call TI_triangle_red(G2tensor(58),RedBasis(193),mass3set(:,1),G0tensor(1161),G0tensor(766),G0tensor(696),G0tensor(686),M2L1R1)
  call TI_triangle_red(G2tensor(345),RedBasis(272),mass3set(:,1),G0tensor(601),G0tensor(595),G0tensor(540),G0tensor(535),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(271),mass3set(:,1),G0tensor(515),G0tensor(510),G0tensor(276),G0tensor(266),M2L1R1)
  call TI_triangle_red(G3tensor(19),RedBasis(221),mass3set(:,1),G0tensor(160),G0tensor(820),G0tensor(600),G0tensor(436),M2L1R1)
  call TI_triangle_red(G1tensor(521),RedBasis(255),mass3set(:,1),G0tensor(322),G0tensor(312),G0tensor(135),G0tensor(1170),M2L1R1)
  call TI_triangle_red(G1tensor(572),RedBasis(253),mass3set(:,1),G0tensor(1166),G0tensor(801),G0tensor(736),G0tensor(726),M2L1R1)
  call TI_triangle_red(G1tensor(825),RedBasis(43),mass3set(:,1),G0tensor(605),G0tensor(591),G0tensor(560),G0tensor(555),M2L1R1)
  call TI_triangle_red(G1tensor(727),RedBasis(35),mass3set(:,1),G0tensor(485),G0tensor(480),G0tensor(291),G0tensor(251),M2L1R1)
  call TI_triangle_red(G1tensor(737),RedBasis(34),mass3set(:,1),G0tensor(155),G0tensor(645),G0tensor(616),G0tensor(610),M2L1R1)
  call TI_triangle_red(G1tensor(845),RedBasis(33),mass3set(:,1),G0tensor(315),G0tensor(310),G0tensor(241),G0tensor(201),M2L1R1)
  call TI_triangle_red(G1tensor(955),RedBasis(40),mass3set(:,1),G0tensor(45),G0tensor(40),G0tensor(35),G0tensor(1141),M2L1R1)
  call TI_triangle_red(G1tensor(772),RedBasis(257),mass3set(:,1),G0tensor(1136),G0tensor(1045),G0tensor(620), &
    G0tensor(615),M2L1R1)
  call TI_triangle_red(G1tensor(865),RedBasis(48),mass3set(:,1),G0tensor(557),G0tensor(531),G0tensor(512),G0tensor(636),M2L1R1)
  call TI_triangle_red(G1tensor(915),RedBasis(28),mass3set(:,1),G0tensor(630),G0tensor(625),G0tensor(325),G0tensor(320),M2L1R1)
  call TI_triangle_red(G1tensor(807),RedBasis(27),mass3set(:,1),G0tensor(226),G0tensor(216),G0tensor(60),G0tensor(55),M2L1R1)
  call TI_triangle_red(G1tensor(885),RedBasis(26),mass3set(:,1),G0tensor(50),G0tensor(1020),G0tensor(640),G0tensor(635),M2L1R1)
  call TI_triangle_red(G1tensor(436),RedBasis(45),mass3set(:,1),G0tensor(537),G0tensor(501),G0tensor(482),G0tensor(835),M2L1R1)
  call TI_triangle_red(G1tensor(449),RedBasis(50),mass3set(:,1),G0tensor(823),G0tensor(578),G0tensor(441),G0tensor(52),M2L1R1)
  call TI_triangle_red(G1tensor(872),RedBasis(49),mass3set(:,1),G0tensor(37),G0tensor(1178),G0tensor(858),G0tensor(838),M2L1R1)
  call TI_triangle_red(G1tensor(892),RedBasis(47),mass3set(:,1),G0tensor(583),G0tensor(143),G0tensor(138),G0tensor(57),M2L1R1)
  call TI_triangle_red(G1tensor(822),RedBasis(230),mass3set(:,1),G0tensor(42),G0tensor(855),G0tensor(843),G0tensor(588),M2L1R1)
  call TI_triangle_red(G1tensor(932),RedBasis(15),mass3set(:,1),G0tensor(171),G0tensor(62),G0tensor(47),G0tensor(1128),M2L1R1)
  call TI_triangle_red(G1tensor(842),RedBasis(241),mass3set(:,1),G0tensor(1113),G0tensor(910),G0tensor(388),G0tensor(343),M2L1R1)
  call TI_triangle_red(G1tensor(972),RedBasis(18),mass3set(:,1),G0tensor(156),G0tensor(108),G0tensor(98),G0tensor(1108),M2L1R1)
  call TI_triangle_red(G1tensor(862),RedBasis(238),mass3set(:,1),G0tensor(1093),G0tensor(1008),G0tensor(913), &
    G0tensor(393),M2L1R1)
  call TI_triangle_red(G1tensor(870),RedBasis(21),mass3set(:,1),G0tensor(348),G0tensor(193),G0tensor(183),G0tensor(173),M2L1R1)
  call TI_triangle_red(G1tensor(882),RedBasis(236),mass3set(:,1),G0tensor(168),G0tensor(163),G0tensor(1171), &
    G0tensor(1110),M2L1R1)
  call TI_triangle_red(G1tensor(890),RedBasis(22),mass3set(:,1),G0tensor(981),G0tensor(861),G0tensor(821),G0tensor(656),M2L1R1)
  call TI_triangle_red(G1tensor(418),RedBasis(246),mass3set(:,1),G0tensor(355),G0tensor(350),G0tensor(165),G0tensor(1148),M2L1R1)
  call TI_triangle_red(G1tensor(1093),RedBasis(212),mass3set(:,1),G0tensor(1133),G0tensor(940),G0tensor(418), &
    G0tensor(368),M2L1R1)
  call TI_triangle_red(G1tensor(712),RedBasis(232),mass3set(:,1),G0tensor(113),G0tensor(103),G0tensor(41),G0tensor(1063),M2L1R1)
  call TI_triangle_red(G1tensor(968),RedBasis(152),mass3set(:,1),G0tensor(943),G0tensor(818),G0tensor(783),G0tensor(423),M2L1R1)
  call TI_triangle_red(G1tensor(1078),RedBasis(216),mass3set(:,1),G0tensor(373),G0tensor(198),G0tensor(188),G0tensor(178),M2L1R1)
  call TI_triangle_red(G1tensor(943),RedBasis(146),mass3set(:,1),G0tensor(93),G0tensor(88),G0tensor(73),G0tensor(58),M2L1R1)
  call TI_triangle_red(G1tensor(857),RedBasis(239),mass3set(:,1),G0tensor(28),G0tensor(1196),G0tensor(1168), &
    G0tensor(1163),M2L1R1)
  call TI_triangle_red(G1tensor(898),RedBasis(128),mass3set(:,1),G0tensor(1135),G0tensor(1131),G0tensor(581), &
    G0tensor(738),M2L1R1)
  call TI_triangle_red(G1tensor(1000),RedBasis(24),mass3set(:,1),G0tensor(698),G0tensor(582),G0tensor(132),G0tensor(122),M2L1R1)
  call TI_triangle_red(G1tensor(1050),RedBasis(29),mass3set(:,1),G0tensor(72),G0tensor(67),G0tensor(1138),G0tensor(808),M2L1R1)
  call TI_triangle_red(G1tensor(1015),RedBasis(31),mass3set(:,1),G0tensor(773),G0tensor(128),G0tensor(26),G0tensor(1143),M2L1R1)
  call TI_triangle_red(G1tensor(1075),RedBasis(38),mass3set(:,1),G0tensor(813),G0tensor(778),G0tensor(133),G0tensor(27),M2L1R1)
  call TI_triangle_red(G1tensor(1010),RedBasis(36),mass3set(:,1),G0tensor(733),G0tensor(693),G0tensor(118),G0tensor(11),M2L1R1)
  call TI_triangle_red(G1tensor(1082),RedBasis(136),mass3set(:,1),G0tensor(743),G0tensor(703),G0tensor(123),G0tensor(12),M2L1R1)
  call TI_triangle_red(G1tensor(686),RedBasis(273),mass3set(:,1),G0tensor(1038),G0tensor(748),G0tensor(708),G0tensor(508),M2L1R1)
  call TI_triangle_red(G1tensor(982),RedBasis(228),mass3set(:,1),G0tensor(288),G0tensor(263),G0tensor(83),G0tensor(78),M2L1R1)
  call TI_triangle_red(G1tensor(985),RedBasis(42),mass3set(:,1),G0tensor(68),G0tensor(43),G0tensor(13),G0tensor(983),M2L1R1)
  call TI_triangle_red(G1tensor(501),RedBasis(274),mass3set(:,1),G0tensor(853),G0tensor(467),G0tensor(442),G0tensor(432),M2L1R1)
  call TI_triangle_red(G1tensor(997),RedBasis(234),mass3set(:,1),G0tensor(142),G0tensor(92),G0tensor(82),G0tensor(1098),M2L1R1)
  call TI_triangle_red(G1tensor(1097),RedBasis(251),mass3set(:,1),G0tensor(1083),G0tensor(993),G0tensor(443), &
    G0tensor(238),M2L1R1)
  call TI_triangle_red(G1tensor(640),RedBasis(275),mass3set(:,1),G0tensor(213),G0tensor(158),G0tensor(998),G0tensor(833),M2L1R1)
  call TI_triangle_red(G1tensor(1007),RedBasis(237),mass3set(:,1),G0tensor(477),G0tensor(452),G0tensor(172),G0tensor(137),M2L1R1)
  call TI_triangle_red(G1tensor(77),RedBasis(276),mass3set(:,1),G0tensor(87),G0tensor(77),G0tensor(1023),G0tensor(542),M2L1R1)
  call TI_triangle_red(G1tensor(1012),RedBasis(240),mass3set(:,1),G0tensor(506),G0tensor(487),G0tensor(1092), &
    G0tensor(1082),M2L1R1)
  call TI_triangle_red(G1tensor(808),RedBasis(70),mass3set(:,1),G0tensor(1033),G0tensor(622),G0tensor(552),G0tensor(507),M2L1R1)
  call TI_triangle_red(G1tensor(1092),RedBasis(244),mass3set(:,1),G0tensor(497),G0tensor(1153),G0tensor(1048), &
    G0tensor(562),M2L1R1)
  call TI_triangle_red(G1tensor(1025),RedBasis(52),mass3set(:,1),G0tensor(517),G0tensor(176),G0tensor(1158), &
    G0tensor(1107),M2L1R1)
  call TI_triangle_red(G1tensor(687),RedBasis(63),mass3set(:,1),G0tensor(1097),G0tensor(1058),G0tensor(642),G0tensor(572),M2L1R1)
  call TI_triangle_red(G1tensor(1087),RedBasis(249),mass3set(:,1),G0tensor(527),G0tensor(177),G0tensor(1173), &
    G0tensor(965),M2L1R1)
  call TI_triangle_red(G1tensor(773),RedBasis(68),mass3set(:,1),G0tensor(398),G0tensor(151),G0tensor(141),G0tensor(111),M2L1R1)
  call TI_triangle_red(G1tensor(1102),RedBasis(250),mass3set(:,1),G0tensor(1183),G0tensor(1103),G0tensor(1088), &
    G0tensor(161),M2L1R1)
  call TI_triangle_red(G1tensor(1070),RedBasis(58),mass3set(:,1),G0tensor(1188),G0tensor(643),G0tensor(623),G0tensor(162),M2L1R1)
  call TI_triangle_red(G1tensor(738),RedBasis(66),mass3set(:,1),G0tensor(157),G0tensor(1193),G0tensor(925),G0tensor(353),M2L1R1)
  call TI_triangle_red(G1tensor(1077),RedBasis(252),mass3set(:,1),G0tensor(146),G0tensor(136),G0tensor(101), &
    G0tensor(1086),M2L1R1)
  call TI_triangle_red(G1tensor(1023),RedBasis(158),mass3set(:,1),G0tensor(720),G0tensor(680),G0tensor(621),G0tensor(613),M2L1R1)
  call TI_triangle_red(G1tensor(897),RedBasis(213),mass3set(:,1),G0tensor(303),G0tensor(106),G0tensor(65),G0tensor(1203),M2L1R1)
  call TI_triangle_red(G1tensor(930),RedBasis(25),mass3set(:,1),G0tensor(1198),G0tensor(898),G0tensor(878),G0tensor(153),M2L1R1)
  call TI_triangle_red(G1tensor(491),RedBasis(54),mass3set(:,1),G0tensor(148),G0tensor(56),G0tensor(1101),G0tensor(795),M2L1R1)
  call TI_triangle_red(G1tensor(920),RedBasis(30),mass3set(:,1),G0tensor(760),G0tensor(641),G0tensor(628),G0tensor(308),M2L1R1)
  call TI_triangle_red(G1tensor(927),RedBasis(62),mass3set(:,1),G0tensor(96),G0tensor(70),G0tensor(1118),G0tensor(166),M2L1R1)
  call TI_triangle_red(G1tensor(1073),RedBasis(176),mass3set(:,1),G0tensor(1123),G0tensor(167),G0tensor(990), &
    G0tensor(608),M2L1R1)
  call TI_triangle_red(G1tensor(942),RedBasis(217),mass3set(:,1),G0tensor(438),G0tensor(233),G0tensor(208),G0tensor(1005),M2L1R1)
  call TI_triangle_red(G1tensor(945),RedBasis(32),mass3set(:,1),G0tensor(598),G0tensor(458),G0tensor(248),G0tensor(223),M2L1R1)
  call TI_triangle_red(G1tensor(448),RedBasis(60),mass3set(:,1),G0tensor(1035),G0tensor(648),G0tensor(503),G0tensor(283),M2L1R1)
  call TI_triangle_red(G1tensor(960),RedBasis(39),mass3set(:,1),G0tensor(258),G0tensor(1060),G0tensor(633),G0tensor(533),M2L1R1)
  call TI_triangle_red(G1tensor(1068),RedBasis(180),mass3set(:,1),G0tensor(298),G0tensor(273),G0tensor(1175), &
    G0tensor(647),M2L1R1)
  call TI_triangle_red(G1tensor(967),RedBasis(65),mass3set(:,1),G0tensor(632),G0tensor(603),G0tensor(593),G0tensor(1185),M2L1R1)
  call TI_triangle_red(G1tensor(970),RedBasis(37),mass3set(:,1),G0tensor(638),G0tensor(618),G0tensor(607),G0tensor(597),M2L1R1)
  call TI_triangle_red(G1tensor(1040),RedBasis(57),mass3set(:,1),G0tensor(980),G0tensor(592),G0tensor(462),G0tensor(437),M2L1R1)
  call TI_triangle_red(G1tensor(1065),RedBasis(59),mass3set(:,1),G0tensor(427),G0tensor(995),G0tensor(602),G0tensor(472),M2L1R1)
  call TI_triangle_red(G1tensor(483),RedBasis(256),mass3set(:,1),G0tensor(457),G0tensor(447),G0tensor(1030),G0tensor(617),M2L1R1)
  call TI_triangle_red(G1tensor(948),RedBasis(145),mass3set(:,1),G0tensor(547),G0tensor(502),G0tensor(492),G0tensor(1055),M2L1R1)
  call TI_triangle_red(G1tensor(762),RedBasis(258),mass3set(:,1),G0tensor(637),G0tensor(567),G0tensor(532),G0tensor(522),M2L1R1)
  call TI_triangle_red(G1tensor(874),RedBasis(67),mass3set(:,1),G0tensor(1160),G0tensor(955),G0tensor(891),G0tensor(851),M2L1R1)
  call TI_triangle_red(G1tensor(903),RedBasis(127),mass3set(:,1),G0tensor(576),G0tensor(406),G0tensor(396),G0tensor(762),M2L1R1)
  call TI_triangle_red(G1tensor(894),RedBasis(69),mass3set(:,1),G0tensor(757),G0tensor(695),G0tensor(682),G0tensor(677),M2L1R1)
  call TI_triangle_red(G1tensor(1048),RedBasis(168),mass3set(:,1),G0tensor(577),G0tensor(1165),G0tensor(915), &
    G0tensor(871),M2L1R1)
  call TI_triangle_red(G1tensor(933),RedBasis(135),mass3set(:,1),G0tensor(831),G0tensor(586),G0tensor(361),G0tensor(351),M2L1R1)
  call TI_triangle_red(G1tensor(973),RedBasis(151),mass3set(:,1),G0tensor(1117),G0tensor(911),G0tensor(797),G0tensor(792),M2L1R1)
  call TI_triangle_red(G1tensor(1088),RedBasis(225),mass3set(:,1),G0tensor(735),G0tensor(722),G0tensor(717),G0tensor(587),M2L1R1)
  call TI_triangle_red(G1tensor(1103),RedBasis(226),mass3set(:,1),G0tensor(1156),G0tensor(1151),G0tensor(785), &
    G0tensor(750),M2L1R1)
  call ol_merge_tensors(T0sum(244),[G0tensor(4)])
  call ol_merge_tensors(T0sum(245),[G0tensor(24)])
  call ol_merge_tensors(T0sum(246),[G0tensor(44)])
  call ol_merge_tensors(T0sum(247),[G0tensor(64)])
  call ol_merge_tensors(T0sum(248),[G0tensor(84)])
  call ol_merge_tensors(T0sum(249),[G0tensor(104)])
  call ol_merge_tensors(T0sum(250),[G0tensor(124)])
  call ol_merge_tensors(T0sum(251),[G0tensor(144)])
  call ol_merge_tensors(T0sum(252),[G0tensor(164)])
  call ol_merge_tensors(T0sum(253),[G0tensor(184)])
  call ol_merge_tensors(T0sum(254),[G0tensor(204)])
  call ol_merge_tensors(T0sum(255),[G0tensor(224)])
  call ol_merge_tensors(T0sum(256),[G0tensor(244)])
  call ol_merge_tensors(T0sum(257),[G0tensor(264)])
  call ol_merge_tensors(T0sum(258),[G0tensor(284)])
  call ol_merge_tensors(T0sum(259),[G0tensor(304)])
  call ol_merge_tensors(T0sum(260),[G0tensor(324)])
  call ol_merge_tensors(T0sum(261),[G0tensor(344)])
  call ol_merge_tensors(T0sum(262),[G0tensor(364)])
  call ol_merge_tensors(T0sum(263),[G0tensor(384)])
  call ol_merge_tensors(T0sum(264),[G0tensor(404)])
  call ol_merge_tensors(T0sum(265),[G0tensor(424)])
  call ol_merge_tensors(T0sum(266),[G0tensor(444)])
  call ol_merge_tensors(T0sum(267),[G0tensor(464)])
  call ol_merge_tensors(T0sum(268),[G0tensor(484)])
  call ol_merge_tensors(T0sum(269),[G0tensor(504)])
  call ol_merge_tensors(T0sum(270),[G0tensor(524)])
  call ol_merge_tensors(T0sum(271),[G0tensor(544)])
  call ol_merge_tensors(T0sum(272),[G0tensor(564)])
  call ol_merge_tensors(T0sum(273),[G0tensor(584)])
  call ol_merge_tensors(T0sum(274),[G0tensor(604)])
  call ol_merge_tensors(T0sum(275),[G0tensor(624)])
  call ol_merge_tensors(T0sum(276),[G0tensor(644)])
  call ol_merge_tensors(T0sum(277),[G0tensor(664)])
  call ol_merge_tensors(T0sum(278),[G0tensor(684)])
  call ol_merge_tensors(T0sum(279),[G0tensor(704)])
  call ol_merge_tensors(T0sum(280),[G0tensor(724)])
  call ol_merge_tensors(T0sum(281),[G0tensor(744)])
  call ol_merge_tensors(T0sum(282),[G0tensor(764)])
  call ol_merge_tensors(T0sum(283),[G0tensor(784)])
  call ol_merge_tensors(T0sum(284),[G0tensor(804)])
  call ol_merge_tensors(T0sum(285),[G0tensor(824)])
  call ol_merge_tensors(T0sum(286),[G0tensor(844)])
  call ol_merge_tensors(T0sum(287),[G0tensor(864)])
  call ol_merge_tensors(T0sum(288),[G0tensor(884)])
  call ol_merge_tensors(T0sum(289),[G0tensor(904)])
  call ol_merge_tensors(T0sum(290),[G0tensor(924)])
  call ol_merge_tensors(T0sum(291),[G0tensor(944)])
  call ol_merge_tensors(T0sum(292),[G0tensor(964)])
  call ol_merge_tensors(T0sum(293),[G0tensor(984)])
  call ol_merge_tensors(T0sum(294),[G0tensor(1004)])
  call ol_merge_tensors(T0sum(295),[G0tensor(1024)])
  call ol_merge_tensors(T0sum(296),[G0tensor(1044)])
  call ol_merge_tensors(T0sum(297),[G0tensor(1064)])
  call ol_merge_tensors(T0sum(298),[G0tensor(1084)])
  call ol_merge_tensors(T0sum(299),[G0tensor(1104)])
  call ol_merge_tensors(T0sum(300),[G0tensor(1124)])
  call ol_merge_tensors(T0sum(301),[G0tensor(1144)])
  call ol_merge_tensors(T0sum(302),[G0tensor(1164)])
  call ol_merge_tensors(T0sum(303),[G0tensor(1184)])
  call ol_merge_tensors(T0sum(304),[G0tensor(1)])
  call ol_merge_tensors(T0sum(305),[G0tensor(1181)])
  call ol_merge_tensors(T0sum(306),[G0tensor(585)])
  call ol_merge_tensors(T0sum(307),[G0tensor(1066)])
  call ol_merge_tensors(T0sum(308),[G0tensor(322)])
  call ol_merge_tensors(T0sum(309),[G0tensor(1166)])
  call ol_merge_tensors(T0sum(310),[G0tensor(605)])
  call ol_merge_tensors(T0sum(311),[G0tensor(485)])
  call ol_merge_tensors(T0sum(312),[G0tensor(155)])
  call ol_merge_tensors(T0sum(313),[G0tensor(315)])
  call ol_merge_tensors(T0sum(314),[G0tensor(45)])
  call ol_merge_tensors(T0sum(315),[G0tensor(1136)])
  call ol_merge_tensors(T0sum(316),[G0tensor(557)])
  call ol_merge_tensors(T0sum(317),[G0tensor(630)])
  call ol_merge_tensors(T0sum(318),[G0tensor(226)])
  call ol_merge_tensors(T0sum(319),[G0tensor(50)])
  call ol_merge_tensors(T0sum(320),[G0tensor(537)])
  call ol_merge_tensors(T0sum(321),[G0tensor(823)])
  call ol_merge_tensors(T0sum(322),[G0tensor(37)])
  call ol_merge_tensors(T0sum(323),[G0tensor(583)])
  call ol_merge_tensors(T0sum(324),[G0tensor(611)])
  call ol_merge_tensors(T0sum(325),[G0tensor(20)])
  call ol_merge_tensors(T0sum(326),[G0tensor(42)])
  call ol_merge_tensors(T0sum(327),[G0tensor(171)])
  call ol_merge_tensors(T0sum(328),[G0tensor(1113)])
  call ol_merge_tensors(T0sum(329),[G0tensor(156)])
  call ol_merge_tensors(T0sum(330),[G0tensor(1093)])
  call ol_merge_tensors(T0sum(331),[G0tensor(348)])
  call ol_merge_tensors(T0sum(332),[G0tensor(168)])
  call ol_merge_tensors(T0sum(333),[G0tensor(981)])
  call ol_merge_tensors(T0sum(334),[G0tensor(355)])
  call ol_merge_tensors(T0sum(335),[G0tensor(1133)])
  call ol_merge_tensors(T0sum(336),[G0tensor(113)])
  call ol_merge_tensors(T0sum(337),[G0tensor(943)])
  call ol_merge_tensors(T0sum(338),[G0tensor(373)])
  call ol_merge_tensors(T0sum(339),[G0tensor(93)])
  call ol_merge_tensors(T0sum(340),[G0tensor(28)])
  call ol_merge_tensors(T0sum(341),[G0tensor(1135)])
  call ol_merge_tensors(T0sum(342),[G0tensor(698)])
  call ol_merge_tensors(T0sum(343),[G0tensor(72)])
  call ol_merge_tensors(T0sum(344),[G0tensor(773)])
  call ol_merge_tensors(T0sum(345),[G0tensor(813)])
  call ol_merge_tensors(T0sum(346),[G0tensor(733)])
  call ol_merge_tensors(T0sum(347),[G0tensor(743)])
  call ol_merge_tensors(T0sum(348),[G0tensor(1038)])
  call ol_merge_tensors(T0sum(349),[G0tensor(288)])
  call ol_merge_tensors(T0sum(350),[G0tensor(68)])
  call ol_merge_tensors(T0sum(351),[G0tensor(853)])
  call ol_merge_tensors(T0sum(352),[G0tensor(142)])
  call ol_merge_tensors(T0sum(353),[G0tensor(1083)])
  call ol_merge_tensors(T0sum(354),[G0tensor(213)])
  call ol_merge_tensors(T0sum(355),[G0tensor(477)])
  call ol_merge_tensors(T0sum(356),[G0tensor(87)])
  call ol_merge_tensors(T0sum(357),[G0tensor(506)])
  call ol_merge_tensors(T0sum(358),[G0tensor(1033)])
  call ol_merge_tensors(T0sum(359),[G0tensor(497)])
  call ol_merge_tensors(T0sum(360),[G0tensor(517)])
  call ol_merge_tensors(T0sum(361),[G0tensor(1097)])
  call ol_merge_tensors(T0sum(362),[G0tensor(527)])
  call ol_merge_tensors(T0sum(363),[G0tensor(398)])
  call ol_merge_tensors(T0sum(364),[G0tensor(1183)])
  call ol_merge_tensors(T0sum(365),[G0tensor(1188)])
  call ol_merge_tensors(T0sum(366),[G0tensor(157)])
  call ol_merge_tensors(T0sum(367),[G0tensor(146)])
  call ol_merge_tensors(T0sum(368),[G0tensor(720)])
  call ol_merge_tensors(T0sum(369),[G0tensor(303)])
  call ol_merge_tensors(T0sum(370),[G0tensor(1198)])
  call ol_merge_tensors(T0sum(371),[G0tensor(148)])
  call ol_merge_tensors(T0sum(372),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(373),[G0tensor(760)])
  call ol_merge_tensors(T0sum(374),[G0tensor(96)])
  call ol_merge_tensors(T0sum(375),[G0tensor(1123)])
  call ol_merge_tensors(T0sum(376),[G0tensor(438)])
  call ol_merge_tensors(T0sum(377),[G0tensor(598)])
  call ol_merge_tensors(T0sum(378),[G0tensor(1035)])
  call ol_merge_tensors(T0sum(379),[G0tensor(15)])
  call ol_merge_tensors(T0sum(380),[G0tensor(596)])
  call ol_merge_tensors(T0sum(381),[G0tensor(258)])
  call ol_merge_tensors(T0sum(382),[G0tensor(298)])
  call ol_merge_tensors(T0sum(383),[G0tensor(632)])
  call ol_merge_tensors(T0sum(384),[G0tensor(638)])
  call ol_merge_tensors(T0sum(385),[G0tensor(980)])
  call ol_merge_tensors(T0sum(386),[G0tensor(427)])
  call ol_merge_tensors(T0sum(387),[G0tensor(457)])
  call ol_merge_tensors(T0sum(388),[G0tensor(203)])
  call ol_merge_tensors(T0sum(389),[G0tensor(547)])
  call ol_merge_tensors(T0sum(390),[G0tensor(243)])
  call ol_merge_tensors(T0sum(391),[G0tensor(637)])
  call ol_merge_tensors(T0sum(392),[G0tensor(1160)])
  call ol_merge_tensors(T0sum(393),[G0tensor(576)])
  call ol_merge_tensors(T0sum(394),[G0tensor(757)])
  call ol_merge_tensors(T0sum(395),[G0tensor(631)])
  call ol_merge_tensors(T0sum(396),[G0tensor(253)])
  call ol_merge_tensors(T0sum(397),[G0tensor(577)])
  call ol_merge_tensors(T0sum(398),[G0tensor(831)])
  call ol_merge_tensors(T0sum(399),[G0tensor(646)])
  call ol_merge_tensors(T0sum(400),[G0tensor(175)])
  call ol_merge_tensors(T0sum(401),[G0tensor(1117)])
  call ol_merge_tensors(T0sum(402),[G0tensor(1116)])
  call ol_merge_tensors(T0sum(403),[G0tensor(327)])
  call ol_merge_tensors(T0sum(404),[G0tensor(1161)])
  call ol_merge_tensors(T0sum(405),[G0tensor(735)])
  call ol_merge_tensors(T0sum(406),[G0tensor(1156)])
  call ol_merge_tensors(T0sum(407),[G0tensor(601)])
  call ol_merge_tensors(T0sum(408),[G0tensor(515)])
  call ol_merge_tensors(T0sum(409),[G0tensor(160)])
  call ol_merge_tensors(T1sum(141),[G1tensor(1202)])
  call ol_merge_tensors(T1sum(142),[G1tensor(1206)])
  call ol_merge_tensors(T1sum(143),[G1tensor(1212)])
  call ol_merge_tensors(T1sum(144),[G1tensor(1205)])
  call ol_merge_tensors(T1sum(145),[G1tensor(1207)])
  call ol_merge_tensors(T1sum(146),[G1tensor(1208)])
  call ol_merge_tensors(T1sum(147),[G1tensor(1213)])
  call ol_merge_tensors(T1sum(148),[G1tensor(1210)])
  call ol_merge_tensors(T1sum(149),[G1tensor(1211)])
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,31],[0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(1),m3h2x32(:,237),heltab2x64(:,:,467))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,31],[0,0],3,2,wf8(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,238),heltab2x64(:,:,468))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,31],[0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,239),heltab2x64(:,:,469))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[60,3],[0,0],3,2,wf8(:,4),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,4),G0H4(5),m4h2x8x4(:,9),heltab3x64(:,:,31))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[60,3],[0,0],3,2,wf8(:,4),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,4),ex6(:),G0H4(4),m4h8x2x4(:,5),heltab3x64(:,:,32))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[60,3],[0,0],3,2,wf8(:,4),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,4),G0H4(3),m4h2x8x4(:,10),heltab3x64(:,:,33))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[35,28],[0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(4),m4h2x4x8(:,13),heltab3x64(:,:,34))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[35,28],[0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(5),m4h4x2x8(:,7),heltab3x64(:,:,35))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[35,28],[0,0],3,2,wf4(:,1),wf8(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(8),m4h2x4x8(:,14),heltab3x64(:,:,36))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,31],[0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,240),heltab2x64(:,:,470))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,31],[0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,241),heltab2x64(:,:,471))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,31],[0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,242),heltab2x64(:,:,472))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[60,3],[0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,9),G0H4(2),m4h2x8x4(:,11),heltab3x64(:,:,37))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[60,3],[0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,9),ex6(:),G0H4(1),m4h8x2x4(:,6),heltab3x64(:,:,38))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[60,3],[0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,9),G0H4(12),m4h2x8x4(:,12),heltab3x64(:,:,39))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[35,28],[0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(7),m4h2x4x8(:,15),heltab3x64(:,:,40))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[35,28],[0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(12),m4h4x2x8(:,8),heltab3x64(:,:,41))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[35,28],[0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(1),m4h2x4x8(:,16),heltab3x64(:,:,42))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,31],[0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,243),heltab2x64(:,:,473))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,31],[0,0],3,2,wf8(:,12),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,244),heltab2x64(:,:,474))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,31],[0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(33),m3h2x32(:,245),heltab2x64(:,:,475))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[44,19],[0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(6),m4h2x4x8(:,17),heltab3x64(:,:,43))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[44,19],[0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,12),ex6(:),G0H8(17),m4h4x2x8(:,9),heltab3x64(:,:,44))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[44,19],[0,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(18),m4h2x4x8(:,18),heltab3x64(:,:,45))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[51,12],[0,0],3,2,wf8(:,12),wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,12),G0H4(11),m4h2x8x4(:,13),heltab3x64(:,:,46))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[51,12],[0,0],3,2,wf8(:,12),wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,12),ex6(:),G0H4(10),m4h8x2x4(:,7),heltab3x64(:,:,47))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[51,12],[0,0],3,2,wf8(:,12),wf4(:,12))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,12),G0H4(9),m4h2x8x4(:,14),heltab3x64(:,:,48))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,31],[0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,246),heltab2x64(:,:,476))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,31],[0,0],3,2,wf8(:,17),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,247),heltab2x64(:,:,477))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,31],[0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,248),heltab2x64(:,:,478))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[44,19],[0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(15),m4h2x4x8(:,19),heltab3x64(:,:,49))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[44,19],[0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,12),ex6(:),G0H8(16),m4h4x2x8(:,10),heltab3x64(:,:,50))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[44,19],[0,0],3,2,wf4(:,12),wf8(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,12),G0H8(19),m4h2x4x8(:,20),heltab3x64(:,:,51))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[51,12],[0,0],3,2,wf8(:,17),wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf8(:,17),G0H4(8),m4h2x8x4(:,15),heltab3x64(:,:,52))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[51,12],[0,0],3,2,wf8(:,17),wf4(:,12))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf8(:,17),ex6(:),G0H4(7),m4h8x2x4(:,8),heltab3x64(:,:,53))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[51,12],[0,0],3,2,wf8(:,17),wf4(:,12))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf8(:,17),G0H4(25),m4h2x8x4(:,16),heltab3x64(:,:,54))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[40,23],[0,0],2,2,wf4(:,5),wf16(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,81),heltab2x64(:,:,479))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[43,20],[0,0],2,2,wf16(:,21),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,21),G0H4(17),m3h16x4(:,53),heltab2x64(:,:,480))
  call Hloop_A_Q(ntryL,G0H4(17),43,0,G1H4(50),n2h4(263))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,19),G0H4(15),m3h16x4(:,54),heltab2x64(:,:,481))
  call Hloop_Q_A(ntryL,G0H4(15),60,0,G1H4(153),n2h4(264))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(4,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,19),G0H4(13),m3h16x4(:,55),heltab2x64(:,:,482))
  call Hloop_Q_A(ntryL,G0H4(13),60,0,G1H4(156),n2h4(265))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)+c(16)*M(4,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(210),m3h16x4(:,56),heltab2x64(:,:,483))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(8)*M(4,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(178),m3h16x4(:,57),heltab2x64(:,:,484))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[52,11],[0,0],2,2,wf8(:,34),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,34),G0H8(20),m3h8x8(:,99),heltab2x64(:,:,485))
  call Hloop_Q_A(ntryL,G0H8(20),52,0,G1H8(118),n2h8(271))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[43,20],[0,0],2,2,wf16(:,45),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,45),G0H4(26),m3h16x4(:,58),heltab2x64(:,:,486))
  call Hloop_A_Q(ntryL,G0H4(26),43,0,G1H4(182),n2h4(266))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[35,28],[0,0],2,2,wf8(:,5),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(21),m3h8x8(:,100),heltab2x64(:,:,487))
  call Hloop_Q_A(ntryL,G0H8(21),35,0,G1H8(123),n2h8(272))
  Gcoeff(:)%j = (c(23)*(M(2,:)%j-M(3,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[35,28],[0,0],2,2,wf8(:,5),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(9),m3h8x8(:,101),heltab2x64(:,:,488))
  call Hloop_Q_A(ntryL,G0H8(9),35,0,G1H8(124),n2h8(273))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[35,28],[0,0],2,2,wf8(:,5),wf8(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(132),m3h8x8(:,102),heltab2x64(:,:,489))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[35,28],[0,0],2,2,wf8(:,5),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(134),m3h8x8(:,103),heltab2x64(:,:,490))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(3,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[43,20],[0,0],2,2,wf16(:,49),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,49),G0H4(18),m3h16x4(:,59),heltab2x64(:,:,491))
  call Hloop_A_Q(ntryL,G0H4(18),43,0,G1H4(145),n2h4(267))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[60,3],[0,0],2,2,wf16(:,80),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,80),G0H4(16),m3h16x4(:,60),heltab2x64(:,:,492))
  call Hloop_Q_A(ntryL,G0H4(16),60,0,G1H4(191),n2h4(268))
  Gcoeff(:)%j = (c(23)*(-M(2,:)%j+M(3,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[60,3],[0,0],2,2,wf16(:,80),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,80),G0H4(14),m3h16x4(:,61),heltab2x64(:,:,493))
  call Hloop_Q_A(ntryL,G0H4(14),60,0,G1H4(106),n2h4(269))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[60,3],[0,0],2,2,wf16(:,80),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,80),60,G1H4(118),m3h16x4(:,62),heltab2x64(:,:,494))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[60,3],[0,0],2,2,wf16(:,80),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,80),60,G1H4(22),m3h16x4(:,63),heltab2x64(:,:,495))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[60,3],[0,0],2,2,wf16(:,81),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(29),m3h16x4(:,64),heltab2x64(:,:,496))
  call Hloop_Q_A(ntryL,G0H4(29),60,0,G1H4(23),n2h4(270))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(4,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[60,3],[0,0],2,2,wf16(:,81),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(22),m3h16x4(:,65),heltab2x64(:,:,497))
  call Hloop_Q_A(ntryL,G0H4(22),60,0,G1H4(48),n2h4(271))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(16)*M(4,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[60,3],[0,0],2,2,wf16(:,81),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,81),60,G1H4(52),m3h16x4(:,66),heltab2x64(:,:,498))
  Gcoeff(:)%j = (c(9)*M(2,:)%j-c(8)*M(4,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[60,3],[0,0],2,2,wf16(:,81),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,81),60,G1H4(64),m3h16x4(:,67),heltab2x64(:,:,499))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[39,24],[0,0],2,2,wf16(:,26),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,26),G0H4(21),m3h16x4(:,68),heltab2x64(:,:,500))
  call Hloop_Q_A(ntryL,G0H4(21),39,0,G1H4(65),n2h4(272))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[36,27],[0,0],2,2,wf4(:,8),wf16(:,25))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(20),m3h4x16(:,82),heltab2x64(:,:,501))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[60,3],[0,0],2,2,wf16(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,23),G0H4(19),m3h16x4(:,69),heltab2x64(:,:,502))
  call Hloop_Q_A(ntryL,G0H4(19),60,0,G1H4(109),n2h4(273))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(4,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[60,3],[0,0],2,2,wf16(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,23),G0H4(30),m3h16x4(:,70),heltab2x64(:,:,503))
  call Hloop_Q_A(ntryL,G0H4(30),60,0,G1H4(78),n2h4(274))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(16)*M(4,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[60,3],[0,0],2,2,wf16(:,23),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,23),60,G1H4(98),m3h16x4(:,71),heltab2x64(:,:,504))
  Gcoeff(:)%j = (c(9)*M(2,:)%j-c(8)*M(4,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[60,3],[0,0],2,2,wf16(:,23),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,23),60,G1H4(100),m3h16x4(:,72),heltab2x64(:,:,505))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[39,24],[0,0],2,2,wf16(:,40),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,40),G0H4(24),m3h16x4(:,73),heltab2x64(:,:,506))
  call Hloop_Q_A(ntryL,G0H4(24),39,0,G1H4(111),n2h4(275))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[56,7],[0,0],2,2,wf8(:,41),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,41),G0H8(14),m3h8x8(:,104),heltab2x64(:,:,507))
  call Hloop_A_Q(ntryL,G0H8(14),56,0,G1H8(139),n2h8(274))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[35,28],[0,0],2,2,wf8(:,5),wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(13),m3h8x8(:,105),heltab2x64(:,:,508))
  call Hloop_Q_A(ntryL,G0H8(13),35,0,G1H8(145),n2h8(275))
  Gcoeff(:)%j = (c(23)*(M(2,:)%j-M(3,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[35,28],[0,0],2,2,wf8(:,5),wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(2),m3h8x8(:,106),heltab2x64(:,:,509))
  call Hloop_Q_A(ntryL,G0H8(2),35,0,G1H8(148),n2h8(276))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[35,28],[0,0],2,2,wf8(:,5),wf8(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(52),m3h8x8(:,107),heltab2x64(:,:,510))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[35,28],[0,0],2,2,wf8(:,5),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),35,G1H8(23),m3h8x8(:,108),heltab2x64(:,:,511))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(3,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[39,24],[0,0],2,2,wf16(:,47),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,47),G0H4(23),m3h16x4(:,74),heltab2x64(:,:,512))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[60,3],[0,0],2,2,wf16(:,86),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,86),G0H4(20),m3h16x4(:,75),heltab2x64(:,:,513))
  call Hloop_Q_A(ntryL,G0H4(20),60,0,G1H4(117),n2h4(276))
  Gcoeff(:)%j = (c(23)*(-M(2,:)%j+M(3,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[60,3],[0,0],2,2,wf16(:,86),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,86),G0H4(27),m3h16x4(:,76),heltab2x64(:,:,514))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(165),n2h4(277))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[60,3],[0,0],2,2,wf16(:,86),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,86),60,G1H4(115),m3h16x4(:,77),heltab2x64(:,:,515))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[60,3],[0,0],2,2,wf16(:,86),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,86),60,G1H4(39),m3h16x4(:,78),heltab2x64(:,:,516))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[60,3],[0,0],2,2,wf16(:,87),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,87),G0H4(28),m3h16x4(:,79),heltab2x64(:,:,517))
  call Hloop_Q_A(ntryL,G0H4(28),60,0,G1H4(80),n2h4(278))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(4,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[60,3],[0,0],2,2,wf16(:,87),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,87),G0H4(33),m3h16x4(:,80),heltab2x64(:,:,518))
  call Hloop_Q_A(ntryL,G0H4(33),60,0,G1H4(122),n2h4(279))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)+c(16)*M(4,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[60,3],[0,0],2,2,wf16(:,87),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,87),60,G1H4(14),m3h16x4(:,81),heltab2x64(:,:,519))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(8)*M(4,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[60,3],[0,0],2,2,wf16(:,87),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,87),60,G1H4(85),m3h16x4(:,82),heltab2x64(:,:,520))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[52,11],[0,0],2,2,wf8(:,35),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,35),G0H8(3),m3h8x8(:,109),heltab2x64(:,:,521))
  call Hloop_Q_A(ntryL,G0H8(3),52,0,G1H8(48),n2h8(277))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[36,27],[0,0],2,2,wf4(:,8),wf16(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(22),m3h4x16(:,83),heltab2x64(:,:,522))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[60,3],[0,0],2,2,wf16(:,102),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,102),G0H4(6),m3h16x4(:,83),heltab2x64(:,:,523))
  call Hloop_Q_A(ntryL,G0H4(6),60,0,G1H4(86),n2h4(280))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(4,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[60,3],[0,0],2,2,wf16(:,102),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,102),G0H4(31),m3h16x4(:,84),heltab2x64(:,:,524))
  call Hloop_Q_A(ntryL,G0H4(31),60,0,G1H4(150),n2h4(281))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(16)*M(4,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[60,3],[0,0],2,2,wf16(:,102),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,102),60,G1H4(205),m3h16x4(:,85),heltab2x64(:,:,525))
  Gcoeff(:)%j = (c(9)*M(2,:)%j-c(8)*M(4,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[60,3],[0,0],2,2,wf16(:,102),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,102),60,G1H4(161),m3h16x4(:,86),heltab2x64(:,:,526))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[40,23],[0,0],2,2,wf4(:,5),wf16(:,38))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,84),heltab2x64(:,:,527))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[56,7],[0,0],2,2,wf8(:,42),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(10),m3h8x8(:,110),heltab2x64(:,:,528))
  call Hloop_A_Q(ntryL,G0H8(10),56,0,G1H8(121),n2h8(278))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[60,3],[0,0],2,2,wf16(:,107),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,107),G0H4(32),m3h16x4(:,87),heltab2x64(:,:,529))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(164),n2h4(282))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(4,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[60,3],[0,0],2,2,wf16(:,107),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,107),G0H4(17),m3h16x4(:,88),heltab2x64(:,:,530))
  call Hloop_Q_A(ntryL,G0H4(17),60,0,G1H4(133),n2h4(283))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)+c(16)*M(4,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[60,3],[0,0],2,2,wf16(:,107),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,107),60,G1H4(188),m3h16x4(:,89),heltab2x64(:,:,531))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(8)*M(4,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[60,3],[0,0],2,2,wf16(:,107),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,107),60,G1H4(192),m3h16x4(:,90),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[51,12],[0,0],2,2,wf16(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,3),G0H4(15),m3h16x4(:,91),heltab2x64(:,:,533))
  call Hloop_Q_A(ntryL,G0H4(15),51,0,G1H4(193),n2h4(284))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(2,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[51,12],[0,0],2,2,wf16(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,3),G0H4(13),m3h16x4(:,92),heltab2x64(:,:,534))
  call Hloop_Q_A(ntryL,G0H4(13),51,0,G1H4(220),n2h4(285))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(20)*M(2,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[51,12],[0,0],2,2,wf16(:,3),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,3),51,G1H4(88),m3h16x4(:,93),heltab2x64(:,:,535))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(2,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[51,12],[0,0],2,2,wf16(:,3),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,3),51,G1H4(179),m3h16x4(:,94),heltab2x64(:,:,536))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[34,29],[0,0],2,2,wf4(:,14),wf16(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(11),m3h4x16(:,85),heltab2x64(:,:,537))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[46,17],[0,0],2,2,wf16(:,28),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,28),G0H4(26),m3h16x4(:,95),heltab2x64(:,:,538))
  call Hloop_A_Q(ntryL,G0H4(26),46,0,G1H4(184),n2h4(286))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[51,12],[0,0],2,2,wf16(:,68),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,68),G0H4(18),m3h16x4(:,96),heltab2x64(:,:,539))
  call Hloop_Q_A(ntryL,G0H4(18),51,0,G1H4(13),n2h4(287))
  Gcoeff(:)%j = (c(23)*(M(2,:)%j-M(3,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[51,12],[0,0],2,2,wf16(:,68),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,68),G0H4(16),m3h16x4(:,97),heltab2x64(:,:,540))
  call Hloop_Q_A(ntryL,G0H4(16),51,0,G1H4(190),n2h4(288))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[51,12],[0,0],2,2,wf16(:,68),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,68),51,G1H4(196),m3h16x4(:,98),heltab2x64(:,:,541))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[51,12],[0,0],2,2,wf16(:,68),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,68),51,G1H4(37),m3h16x4(:,99),heltab2x64(:,:,542))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[44,19],[0,0],2,2,wf8(:,13),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(11),m3h8x8(:,111),heltab2x64(:,:,543))
  call Hloop_Q_A(ntryL,G0H8(11),44,0,G1H8(138),n2h8(279))
  Gcoeff(:)%j = (c(23)*(-M(2,:)%j+M(3,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[44,19],[0,0],2,2,wf8(:,13),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(20),m3h8x8(:,112),heltab2x64(:,:,544))
  call Hloop_Q_A(ntryL,G0H8(20),44,0,G1H8(28),n2h8(280))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[44,19],[0,0],2,2,wf8(:,13),wf8(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(19),m3h8x8(:,113),heltab2x64(:,:,545))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[44,19],[0,0],2,2,wf8(:,13),wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(115),m3h8x8(:,114),heltab2x64(:,:,546))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[49,14],[0,0],2,2,wf8(:,61),wf8(:,16))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,61),G0H8(21),m3h8x8(:,115),heltab2x64(:,:,547))
  call Hloop_Q_A(ntryL,G0H8(21),49,0,G1H8(128),n2h8(281))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[51,12],[0,0],2,2,wf16(:,69),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,69),G0H4(14),m3h16x4(:,100),heltab2x64(:,:,548))
  call Hloop_Q_A(ntryL,G0H4(14),51,0,G1H4(55),n2h4(289))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(3,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[51,12],[0,0],2,2,wf16(:,69),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,69),G0H4(29),m3h16x4(:,101),heltab2x64(:,:,549))
  call Hloop_Q_A(ntryL,G0H4(29),51,0,G1H4(140),n2h4(290))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(20)*M(3,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[51,12],[0,0],2,2,wf16(:,69),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,69),51,G1H4(91),m3h16x4(:,102),heltab2x64(:,:,550))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[51,12],[0,0],2,2,wf16(:,69),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,69),51,G1H4(20),m3h16x4(:,103),heltab2x64(:,:,551))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[46,17],[0,0],2,2,wf16(:,61),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,61),G0H4(22),m3h16x4(:,104),heltab2x64(:,:,552))
  call Hloop_A_Q(ntryL,G0H4(22),46,0,G1H4(30),n2h4(291))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(3,:)%j)) * den(285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[46,17],[0,0],2,2,wf16(:,63),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,63),G0H4(21),m3h16x4(:,105),heltab2x64(:,:,553))
  call Hloop_A_Q(ntryL,G0H4(21),46,0,G1H4(154),n2h4(292))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[51,12],[0,0],2,2,wf16(:,4),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,4),G0H4(19),m3h16x4(:,106),heltab2x64(:,:,554))
  call Hloop_Q_A(ntryL,G0H4(19),51,0,G1H4(87),n2h4(293))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(3,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[51,12],[0,0],2,2,wf16(:,4),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,4),G0H4(30),m3h16x4(:,107),heltab2x64(:,:,555))
  call Hloop_Q_A(ntryL,G0H4(30),51,0,G1H4(189),n2h4(294))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(20)*M(3,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[51,12],[0,0],2,2,wf16(:,4),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,4),51,G1H4(195),m3h16x4(:,108),heltab2x64(:,:,556))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[51,12],[0,0],2,2,wf16(:,4),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,4),51,G1H4(201),m3h16x4(:,109),heltab2x64(:,:,557))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[45,18],[0,0],2,2,wf16(:,34),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,34),G0H4(24),m3h16x4(:,110),heltab2x64(:,:,558))
  call Hloop_Q_A(ntryL,G0H4(24),45,0,G1H4(42),n2h4(295))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[33,30],[0,0],2,2,wf4(:,17),wf16(:,32))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(16),m3h4x16(:,86),heltab2x64(:,:,559))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[51,12],[0,0],2,2,wf16(:,74),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,74),G0H4(20),m3h16x4(:,111),heltab2x64(:,:,560))
  call Hloop_Q_A(ntryL,G0H4(20),51,0,G1H4(53),n2h4(296))
  Gcoeff(:)%j = (c(23)*(M(2,:)%j-M(3,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[51,12],[0,0],2,2,wf16(:,74),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,74),G0H4(27),m3h16x4(:,112),heltab2x64(:,:,561))
  call Hloop_Q_A(ntryL,G0H4(27),51,0,G1H4(230),n2h4(297))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[51,12],[0,0],2,2,wf16(:,74),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,74),51,G1H4(73),m3h16x4(:,113),heltab2x64(:,:,562))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[51,12],[0,0],2,2,wf16(:,74),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,74),51,G1H4(2),m3h16x4(:,114),heltab2x64(:,:,563))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[44,19],[0,0],2,2,wf8(:,13),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(9),m3h8x8(:,116),heltab2x64(:,:,564))
  call Hloop_Q_A(ntryL,G0H8(9),44,0,G1H8(12),n2h8(282))
  Gcoeff(:)%j = (c(23)*(-M(2,:)%j+M(3,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[44,19],[0,0],2,2,wf8(:,13),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(14),m3h8x8(:,117),heltab2x64(:,:,565))
  call Hloop_Q_A(ntryL,G0H8(14),44,0,G1H8(58),n2h8(283))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[44,19],[0,0],2,2,wf8(:,13),wf8(:,17))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,13),44,G1H8(55),m3h8x8(:,118),heltab2x64(:,:,566))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppajjj_uuxccxag_2_/**/REALKIND
