
module ol_vamp_1_ppajjj_uuuxuxag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajjj_uuuxuxag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajjj_uuuxuxag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajjj_uuuxuxag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppajjj_uuuxuxag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(2))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(3))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,16,2,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(4))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(5))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(6))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,1,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(7))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(8))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(9))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(10))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(11))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(12))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,1,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(13))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,4,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(14))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,1,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(15))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,8,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(16))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)-c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,2,16,4,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,16,8,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,2,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(17))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)-c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,2,4,1,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,8,16,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(18))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,1,4,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(19))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,1,4,2,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,1,4,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(20))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,1,4,8,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,2,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(21))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,2,4,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(22))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,8,1,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,1,8,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(23))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,1,8,16,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(34),n2h32(24))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,8,2,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(35),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,8,4,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,16,4,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,16,8,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,16,8,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,16,4,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_VA_Q(ntryL,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(2),36,0,G2H16(1),n2h16(1))
  call Hloop_AQ_V(ntryL,G1H32(3),ex2(:),G1H16(2),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QA_V(ntryL,G1H32(4),ex3(:),G1H16(3),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_VA_Q(ntryL,G1H32(5),ex3(:),G1H16(4),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(4),36,0,G2H16(2),n2h16(2))
  call Hloop_AQ_V(ntryL,G1H32(6),ex2(:),G1H16(4),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_QA_V(ntryL,G1H32(7),ex4(:),G1H16(5),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_VA_Q(ntryL,G1H32(8),ex3(:),G1H16(6),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(6),36,0,G2H16(3),n2h16(3))
  call Hloop_QA_V(ntryL,G1H32(9),ex3(:),G1H16(6),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_VA_Q(ntryL,G1H32(10),ex3(:),G1H16(7),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(7),36,0,G2H16(4),n2h16(4))
  call Hloop_AQ_V(ntryL,G1H32(11),ex2(:),G1H16(7),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_AQ_V(ntryL,G1H32(12),ex2(:),G1H16(8),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G1H32(13),ex1(:),G1H16(9),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex1(:),G1H16(10),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_AQ_V(ntryL,G1H32(15),ex1(:),G1H16(11),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(12),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_QA_V(ntryL,G1H32(17),ex4(:),G1H16(13),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_V(ntryL,G1H32(18),ex2(:),G1H16(14),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_QA_V(ntryL,G1H32(19),ex3(:),G1H16(15),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex2(:),G1H16(16),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_VQ_A(ntryL,G1H32(21),ex2(:),G1H16(17),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(17),34,0,G2H16(5),n2h16(5))
  call Hloop_VQ_A(ntryL,G1H32(22),ex2(:),G1H16(17),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(17),34,0,G2H16(6),n2h16(6))
  call Hloop_QA_V(ntryL,G1H32(23),ex4(:),G1H16(17),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_VQ_A(ntryL,G1H32(24),ex2(:),G1H16(18),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(18),34,0,G2H16(7),n2h16(7))
  call Hloop_AQ_V(ntryL,G1H32(25),ex2(:),G1H16(18),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_AQ_V(ntryL,G1H32(26),ex1(:),G1H16(19),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_VQ_A(ntryL,G1H32(27),ex1(:),G1H16(20),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(20),33,0,G2H16(8),n2h16(8))
  call Hloop_AQ_V(ntryL,G1H32(28),ex1(:),G1H16(20),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_VQ_A(ntryL,G1H32(29),ex1(:),G1H16(21),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(9),n2h16(9))
  call Hloop_QA_V(ntryL,G1H32(30),ex3(:),G1H16(21),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_AQ_V(ntryL,G1H32(31),ex2(:),G1H16(22),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_VQ_A(ntryL,G1H32(32),ex2(:),G1H16(23),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(23),34,0,G2H16(10),n2h16(10))
  call Hloop_AQ_V(ntryL,G1H32(33),ex1(:),G1H16(23),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_AQ_V(ntryL,G1H32(34),ex1(:),G1H16(24),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_VQ_A(ntryL,G1H32(35),ex1(:),G1H16(25),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(11),n2h16(11))
  call Hloop_VQ_A(ntryL,G1H32(36),ex1(:),G1H16(25),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(12),n2h16(12))
  call Hloop_VQ_A(ntryL,G1H32(37),ex1(:),G1H16(25),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(13),n2h16(13))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(25),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(14),n2h16(14))
  call Hloop_VQ_A(ntryL,G1H32(39),ex1(:),G1H16(25),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(15),n2h16(15))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(25),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(16),n2h16(16))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(3),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(3),ex4(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(4),n2h8(3))
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(25),G1H16(1),G1H16(2),G1H16(3),G1H16(26),G1H16(27),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(5),n2h8(4))
  call Hloop_VA_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(6),n2h8(5))
  call Hloop_AQ_V(ntryL,G2H16(3),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(8),n2h8(6))
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(4),G1H16(5),G1H16(6),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(5),8,16)
  call Hloop_VQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(9),n2h8(7))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(10),n2h8(8))
  call Hloop_VQ_A(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(11),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(12),n2h8(10))
  call Hloop_VQ_A(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(13),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(14),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(13),ex1(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(15),n2h8(13))
  call Hloop_VA_Q(ntryL,G1H16(14),ex3(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(16),n2h8(14))
  call Hloop_VQ_A(ntryL,G1H16(15),ex1(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(17),n2h8(15))
  call Hloop_VA_Q(ntryL,G1H16(16),ex4(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(18),n2h8(16))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(3),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),8,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(4),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(14),4,16)
  call Hloop_VQ_A(ntryL,G1H16(17),ex2(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(19),n2h8(17))
  call Hloop_QA_V(ntryL,G2H16(7),ex3(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_VA_Q(ntryL,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(21),n2h8(18))
  call Hloop_VA_Q(ntryL,G1H16(19),ex3(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(22),n2h8(19))
  call Hloop_QA_V(ntryL,G2H16(8),ex3(:),G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_VA_Q(ntryL,G1H16(20),ex3(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(24),n2h8(20))
  call Hloop_QA_V(ntryL,G2H16(9),ex3(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_VQ_A(ntryL,G1H16(21),ex2(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),38,0,G2H8(26),n2h8(21))
  call Hloop_VA_Q(ntryL,G1H16(22),ex3(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(27),n2h8(22))
  call Hloop_QA_V(ntryL,G2H16(10),ex4(:),G2H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_VA_Q(ntryL,G1H16(23),ex4(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(29),n2h8(23))
  call Hloop_VA_Q(ntryL,G1H16(24),ex4(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(30),n2h8(24))
  call Hloop_QA_V(ntryL,G2H16(11),ex4(:),G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_QA_V(ntryL,G2H16(12),ex4(:),G2H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(5),mass5set(:,1),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
  call HG1shiftOLR(G1H16(18),8,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(6),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(24),4,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(6),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),2,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(5),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),2,16)
  call Hloop_AV_Q(ntryL,G1H16(25),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(33),n2h8(25))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AV_Q(ntryL,G1H16(3),ex5(:),G1H8(2),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(34),n2h8(26))
  call Hloop_AV_Q(ntryL,G1H16(26),ex5(:),G1H8(2),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(35),n2h8(27))
  call Hloop_AV_Q(ntryL,G1H16(27),ex5(:),G1H8(2),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(36),n2h8(28))
  call Hloop_AV_Q(ntryL,G1H16(4),ex5(:),G1H8(2),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(37),n2h8(29))
call HGT_raise_alpha_OLR(G1H16(5),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(5),ex4(:),G1H8(2),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AV_Q(ntryL,G1H16(28),ex5(:),G1H8(3),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(3),52,0,G2H8(38),n2h8(30))
  call Hloop_AV_Q(ntryL,G1H16(29),ex5(:),G1H8(3),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(3),52,0,G2H8(39),n2h8(31))
  call Hloop_AV_Q(ntryL,G1H16(30),ex5(:),G1H8(3),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(3),52,0,G2H8(40),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(3),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(3),50,0,G2H8(41),n2h8(33))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(8),ex4(:),G1H8(3),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(4),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(4),50,0,G2H8(42),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(4),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(4),50,0,G2H8(43),n2h8(35))
  call Hloop_QV_A(ntryL,G1H16(12),ex5(:),G1H8(4),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(4),50,0,G2H8(44),n2h8(36))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(4),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(4),50,0,G2H8(45),n2h8(37))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(14),ex3(:),G1H8(4),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(5),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(5),50,0,G2H8(46),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(31),ex5(:),G1H8(5),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(5),50,0,G2H8(47),n2h8(39))
  call Hloop_QV_A(ntryL,G1H16(32),ex5(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(5),50,0,G2H8(48),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(5),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(49),n2h8(41))
call HGT_raise_alpha_OLR(G1H16(18),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(18),ex4(:),G1H8(5),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_QV_A(ntryL,G1H16(20),ex5(:),G1H8(6),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(50),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(21),ex5(:),G1H8(6),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(51),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(6),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(52),n2h8(44))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(6),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(53),n2h8(45))
call HGT_raise_alpha_OLR(G1H16(24),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(24),ex3(:),G1H8(6),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_QV_A(ntryL,G1H16(34),ex5(:),G1H8(7),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(54),n2h8(46))
  call Hloop_QV_A(ntryL,G1H16(35),ex5(:),G1H8(7),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(55),n2h8(47))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(7),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(56),n2h8(48))
  call Hloop_QV_A(ntryL,G1H16(37),ex5(:),G1H8(7),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(57),n2h8(49))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(38),ex2(:),G1H8(7),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(8),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(58),n2h8(50))
  call Hloop_QV_A(ntryL,G1H16(41),ex5(:),G1H8(8),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(59),n2h8(51))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(8),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(60),n2h8(52))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(8),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(61),n2h8(53))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(44),ex2(:),G1H8(8),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QV_A(ntryL,G1H16(46),ex5(:),G1H8(9),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(9),49,0,G2H8(62),n2h8(54))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(9),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(9),49,0,G2H8(63),n2h8(55))
  call Hloop_QV_A(ntryL,G1H16(48),ex5(:),G1H8(9),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(9),49,0,G2H8(64),n2h8(56))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(7),mass5set(:,1),  & 
G1H8(9),G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(10),8,8)
  call Hloop_QA_V(ntryL,G2H8(3),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(6),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(8),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_AQ_V(ntryL,G2H8(8),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(9),mass5set(:,1),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(22),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(9),mass5set(:,1),  & 
G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),4,8)
  call Hloop_QA_V(ntryL,G2H8(11),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(12),ex4(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(10),mass5set(:,1),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(10),mass5set(:,1),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(40),4,8)
  call Hloop_QA_V(ntryL,G2H8(15),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(16),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(17),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(19),ex3(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(11),mass5set(:,1),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(12),mass5set(:,1),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(52),4,8)
  call Hloop_AQ_V(ntryL,G2H8(22),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(13),mass5set(:,1),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(14),mass5set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),8,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(15),mass5set(:,1),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),2,8)
  call Hloop_QA_V(ntryL,G2H8(26),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(16),mass5set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),8,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(17),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),4,8)
  call Hloop_AQ_V(ntryL,G2H8(29),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(18),mass5set(:,1),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(88),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(19),mass5set(:,1),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(94),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(20),mass5set(:,1),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),8)
  call HG1shiftOLR(G1H8(100),2,8)
  call Hloop_AQ_V(ntryL,G2H8(33),ex2(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(35),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(36),ex2(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(37),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(39),ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_V(ntryL,G2H8(41),ex3(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_V(ntryL,G2H8(43),ex3(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_V(ntryL,G2H8(44),ex3(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(45),ex4(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(47),ex4(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G2H8(48),ex4(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G2H8(49),ex3(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H8(51),ex3(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(52),ex3(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_V(ntryL,G2H8(53),ex4(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_V(ntryL,G2H8(55),ex4(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QA_V(ntryL,G2H8(56),ex4(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_QA_V(ntryL,G2H8(57),ex4(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_QA_V(ntryL,G2H8(59),ex4(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QA_V(ntryL,G2H8(60),ex4(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_V(ntryL,G2H8(61),ex3(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QA_V(ntryL,G2H8(63),ex3(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_QA_V(ntryL,G2H8(64),ex3(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(41),n2h4(1))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(10),ex4(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VQ_A(ntryL,G1H8(13),ex2(:),G1H4(2),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(42),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(14),ex2(:),G1H4(2),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(43),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(15),ex1(:),G1H4(2),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(44),n2h4(4))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(16),ex4(:),G1H4(2),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_VQ_A(ntryL,G1H8(19),ex1(:),G1H4(3),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(45),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(20),ex1(:),G1H4(3),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(46),n2h4(6))
  call Hloop_QV_A(ntryL,G1H8(21),ex5(:),G1H4(3),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(47),n2h4(7))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-8,0,G2H8(1),n2h8(59))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(48),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_QV_A(ntryL,G1H8(25),ex5(:),G1H4(3),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(49),n2h4(8))
  call Hloop_QV_A(ntryL,G1H8(26),ex5(:),G1H4(3),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(50),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(27),ex5(:),G1H4(3),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(51),n2h4(10))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-4,0,G2H8(2),n2h8(60))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(52),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_QV_A(ntryL,G1H8(31),ex5(:),G1H4(3),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(53),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(32),ex5(:),G1H4(3),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(54),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(3),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(55),n2h4(13))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(34),-8,0,G2H8(3),n2h8(61))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(56),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(3),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(57),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(38),ex5(:),G1H4(3),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(58),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(3),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(59),n2h4(16))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(40),-4,0,G2H8(4),n2h8(62))
  call Hloop_QA_V(ntryL,G2H8(4),ex3(:),G2H4(60),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QV_A(ntryL,G1H8(43),ex5(:),G1H4(3),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(61),n2h4(17))
  call Hloop_QV_A(ntryL,G1H8(44),ex5(:),G1H4(3),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(62),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(45),ex1(:),G1H4(3),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(63),n2h4(19))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(46),ex4(:),G1H4(3),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VQ_A(ntryL,G1H8(49),ex1(:),G1H4(4),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(64),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(50),ex1(:),G1H4(4),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(65),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H8(51),ex5(:),G1H4(4),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(4),58,0,G2H4(66),n2h4(22))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(52),-4,0,G2H8(5),n2h8(64))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(67),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_AV_Q(ntryL,G1H8(55),ex5(:),G1H4(4),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(4),58,0,G2H4(68),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H8(56),ex5(:),G1H4(4),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(4),58,0,G2H4(69),n2h4(24))
  call Hloop_VQ_A(ntryL,G1H8(57),ex2(:),G1H4(4),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(70),n2h4(25))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(58),ex4(:),G1H4(4),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H8(61),ex2(:),G1H4(5),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(71),n2h4(26))
  call Hloop_VQ_A(ntryL,G1H8(62),ex2(:),G1H4(5),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(72),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H8(63),ex5(:),G1H4(5),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(5),53,0,G2H4(73),n2h4(28))
call HGT_OLR(G1H8(64),1,1,8)
call HGT_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(64),-8,0,G2H8(6),n2h8(66))
  call Hloop_QA_V(ntryL,G2H8(6),ex4(:),G2H4(74),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_AV_Q(ntryL,G1H8(67),ex5(:),G1H4(5),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(5),53,0,G2H4(75),n2h4(29))
  call Hloop_AV_Q(ntryL,G1H8(68),ex5(:),G1H4(5),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(5),53,0,G2H4(76),n2h4(30))
  call Hloop_VA_Q(ntryL,G1H8(69),ex4(:),G1H4(5),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(77),n2h4(31))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(70),ex2(:),G1H4(5),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_VA_Q(ntryL,G1H8(73),ex4(:),G1H4(6),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(6),45,0,G2H4(78),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(74),ex4(:),G1H4(6),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(6),45,0,G2H4(79),n2h4(33))
  call Hloop_AV_Q(ntryL,G1H8(75),ex5(:),G1H4(6),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(6),54,0,G2H4(80),n2h4(34))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(76),-8,0,G2H8(7),n2h8(68))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(81),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_AV_Q(ntryL,G1H8(79),ex5(:),G1H4(6),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(6),54,0,G2H4(82),n2h4(35))
  call Hloop_AV_Q(ntryL,G1H8(80),ex5(:),G1H4(6),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(6),54,0,G2H4(83),n2h4(36))
  call Hloop_VQ_A(ntryL,G1H8(81),ex1(:),G1H4(6),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(6),43,0,G2H4(84),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex3(:),G1H4(6),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_VQ_A(ntryL,G1H8(85),ex1(:),G1H4(7),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(7),43,0,G2H4(85),n2h4(38))
  call Hloop_VQ_A(ntryL,G1H8(86),ex1(:),G1H4(7),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(7),43,0,G2H4(86),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(87),ex5(:),G1H4(7),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(7),57,0,G2H4(87),n2h4(40))
call HGT_OLR(G1H8(88),1,1,8)
call HGT_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(88),-4,0,G2H8(8),n2h8(70))
  call Hloop_QA_V(ntryL,G2H8(8),ex3(:),G2H4(88),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_AV_Q(ntryL,G1H8(91),ex5(:),G1H4(7),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(7),57,0,G2H4(89),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(92),ex5(:),G1H4(7),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(7),57,0,G2H4(90),n2h4(42))
  call Hloop_VQ_A(ntryL,G1H8(93),ex2(:),G1H4(7),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(7),43,0,G2H4(91),n2h4(43))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(94),ex3(:),G1H4(7),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_VQ_A(ntryL,G1H8(97),ex2(:),G1H4(8),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(8),43,0,G2H4(92),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(98),ex2(:),G1H4(8),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(8),43,0,G2H4(93),n2h4(45))
  call Hloop_VA_Q(ntryL,G1H8(99),ex3(:),G1H4(8),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(8),45,0,G2H4(94),n2h4(46))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(100),ex2(:),G1H4(8),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_VA_Q(ntryL,G1H8(103),ex3(:),G1H4(9),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(9),45,0,G2H4(95),n2h4(47))
  call Hloop_VA_Q(ntryL,G1H8(104),ex3(:),G1H4(9),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(9),45,0,G2H4(96),n2h4(48))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(21),mass5set(:,1),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(22),mass5set(:,1),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(23),mass5set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(24),mass5set(:,1),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(25),mass5set(:,1),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(26),mass5set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(27),mass5set(:,1),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(28),mass5set(:,1),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(29),mass5set(:,1),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(11),mass5set(:,1),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(30),mass5set(:,1),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(17),mass5set(:,1),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(31),mass5set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(13),mass5set(:,1),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(32),mass5set(:,1),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(19),mass5set(:,1),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),16,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(1),mass5set(:,1),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(33),mass5set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(2),mass5set(:,1),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(33),mass5set(:,1),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(124),8,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(3),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(34),mass5set(:,1),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(4),mass5set(:,1),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(142),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(35),mass5set(:,1),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
  call HG1shiftOLR(G1H4(148),4,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(5),mass5set(:,1),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
  call HG1shiftOLR(G1H4(154),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(36),mass5set(:,1),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(160),8,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(6),mass5set(:,1),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(166),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(37),mass5set(:,1),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(172),4,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(6),mass5set(:,1),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),2,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(38),mass5set(:,1),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G1H4(188),4)
  call HG1shiftOLR(G1H4(184),2,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(5),mass5set(:,1),  & 
G1H4(189),G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
  call HG1shiftOLR(G1H4(190),2,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(38),mass5set(:,1),  & 
G1H4(195),G1H4(196),G1H4(197),G1H4(198),G1H4(199),G1H4(200),4)
  call HG1shiftOLR(G1H4(196),2,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(7),mass5set(:,1),  & 
G1H4(201),G1H4(202),G1H4(203),G1H4(204),G1H4(205),G1H4(206),4)
  call HG1shiftOLR(G1H4(202),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(39),mass5set(:,1),  & 
G1H4(207),G1H4(208),G1H4(209),G1H4(210),G1H4(211),G1H4(212),4)
  call HG1shiftOLR(G1H4(208),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(8),mass5set(:,1),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(216),G1H4(217),G1H4(218),4)
  call HG1shiftOLR(G1H4(214),8,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(40),mass5set(:,1),  & 
G1H4(219),G1H4(220),G1H4(221),G1H4(222),G1H4(223),G1H4(224),4)
  call HG1shiftOLR(G1H4(220),8,4)
  call Hloop_QA_V(ntryL,G2H4(47),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(50),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(51),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(54),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(55),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(58),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(59),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(62),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(11),mass5set(:,1),  & 
G1H4(225),G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(226),8,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(41),mass5set(:,1),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(235),G1H4(236),4)
  call HG1shiftOLR(G1H4(232),8,4)
  call Hloop_AQ_V(ntryL,G2H4(66),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(69),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(13),mass5set(:,1),  & 
G1H4(237),G1H4(238),G1H4(239),G1H4(240),G1H4(241),G1H4(242),4)
  call HG1shiftOLR(G1H4(238),8,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(42),mass5set(:,1),  & 
G1H4(243),G1H4(244),G1H4(245),G1H4(246),G1H4(247),G1H4(248),4)
  call HG1shiftOLR(G1H4(244),8,4)
  call Hloop_AQ_V(ntryL,G2H4(73),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(76),ex2(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(77),RedSet_5(15),mass5set(:,1),  & 
G1H4(249),G1H4(250),G1H4(251),G1H4(252),G1H4(253),G1H4(254),4)
  call HG1shiftOLR(G1H4(250),2,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(43),mass5set(:,1),  & 
G1H4(255),G1H4(256),G1H4(257),G1H4(258),G1H4(259),G1H4(260),4)
  call HG1shiftOLR(G1H4(256),2,4)
  call Hloop_AQ_V(ntryL,G2H4(80),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(83),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(17),mass5set(:,1),  & 
G1H4(261),G1H4(262),G1H4(263),G1H4(264),G1H4(265),G1H4(266),4)
  call HG1shiftOLR(G1H4(262),4,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(44),mass5set(:,1),  & 
G1H4(267),G1H4(268),G1H4(269),G1H4(270),G1H4(271),G1H4(272),4)
  call HG1shiftOLR(G1H4(268),4,4)
  call Hloop_AQ_V(ntryL,G2H4(87),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(90),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(19),mass5set(:,1),  & 
G1H4(273),G1H4(274),G1H4(275),G1H4(276),G1H4(277),G1H4(278),4)
  call HG1shiftOLR(G1H4(274),4,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(45),mass5set(:,1),  & 
G1H4(279),G1H4(280),G1H4(281),G1H4(282),G1H4(283),G1H4(284),4)
  call HG1shiftOLR(G1H4(280),4,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(20),mass5set(:,1),  & 
G1H4(285),G1H4(286),G1H4(287),G1H4(288),G1H4(289),G1H4(290),4)
  call HG1shiftOLR(G1H4(286),2,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(46),mass5set(:,1),  & 
G1H4(291),G1H4(292),G1H4(293),G1H4(294),G1H4(295),G1H4(296),4)
  call HG1shiftOLR(G1H4(292),2,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(195),[G1H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(219),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(267),[G1H4(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(290)])
  call Hloop_VQ_A(ntryL,G1H4(9),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(1))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(10),-16,0,G2H4(1),n2h4(49))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(14),ex2(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(19),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(15),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(3))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-16,0,G2H4(2),n2h4(50))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(22),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(21),ex2(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(5))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-16,0,G2H4(3),n2h4(51))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(26),ex2(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(25),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(27),ex3(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(26),n2h2(7))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-16,0,G2H4(4),n2h4(52))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VA_Q(ntryL,G1H4(32),ex3(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(28),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(33),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(9))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-16,0,G2H4(5),n2h4(53))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H4(38),ex1(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(31),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(32),n2h2(11))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-16,0,G2H4(6),n2h4(54))
  call Hloop_AV_Q(ntryL,G2H4(6),ex5(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_VQ_A(ntryL,G1H4(44),ex1(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(34),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(45),ex4(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(35),n2h2(13))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(46),-16,0,G2H4(7),n2h4(55))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G1H4(50),ex4(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(37),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(51),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(38),n2h2(15))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(52),-16,0,G2H4(8),n2h4(56))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(56),ex3(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(40),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(57),ex2(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(41),n2h2(17))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-16,0,G2H4(9),n2h4(57))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(62),ex2(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(43),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(63),ex4(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(44),n2h2(19))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(64),-16,0,G2H4(10),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(10),ex5(:),G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_VA_Q(ntryL,G1H4(68),ex4(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(46),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(69),ex2(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(47),n2h2(21))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-16,0,G2H4(11),n2h4(59))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VQ_A(ntryL,G1H4(74),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(49),n2h2(22))
  call Hloop_VA_Q(ntryL,G1H4(75),ex3(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(50),n2h2(23))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(76),-16,0,G2H4(12),n2h4(60))
  call Hloop_QV_A(ntryL,G2H4(12),ex5(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_VA_Q(ntryL,G1H4(80),ex3(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(52),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(81),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(53),n2h2(25))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-16,0,G2H4(13),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(86),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(55),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(87),ex4(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(56),n2h2(27))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-16,0,G2H4(14),n2h4(62))
  call Hloop_QV_A(ntryL,G2H4(14),ex5(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H4(92),ex4(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(58),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(93),ex1(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(59),n2h2(29))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(94),-16,0,G2H4(15),n2h4(63))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_VQ_A(ntryL,G1H4(98),ex1(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(61),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(99),ex3(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(62),n2h2(31))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(100),-16,0,G2H4(16),n2h4(64))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_VA_Q(ntryL,G1H4(104),ex3(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(64),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(105),ex1(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(65),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(106),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(106),ex4(:),G1H2(1),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_VQ_A(ntryL,G1H4(111),ex1(:),G1H2(2),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(66),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(112),ex4(:),G1H2(2),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_VQ_A(ntryL,G1H4(116),ex1(:),G1H2(3),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(67),n2h2(35))
  call Hloop_VQ_A(ntryL,G1H4(117),ex2(:),G1H2(3),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(68),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(118),ex4(:),G1H2(3),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_VQ_A(ntryL,G1H4(123),ex2(:),G1H2(4),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(69),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(124),ex4(:),G1H2(4),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_VQ_A(ntryL,G1H4(128),ex2(:),G1H2(5),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(70),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H4(129),ex1(:),G1H2(5),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(71),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(130),ex4(:),G1H2(5),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_VQ_A(ntryL,G1H4(135),ex1(:),G1H2(6),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(72),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(136),ex4(:),G1H2(6),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_VQ_A(ntryL,G1H4(140),ex1(:),G1H2(7),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(73),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(141),ex1(:),G1H2(7),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(7),59,0,G2H2(74),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(142),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(142),ex3(:),G1H2(7),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_VQ_A(ntryL,G1H4(147),ex1(:),G1H2(8),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(8),59,0,G2H2(75),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(148),ex3(:),G1H2(8),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_VQ_A(ntryL,G1H4(152),ex1(:),G1H2(9),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(9),59,0,G2H2(76),n2h2(44))
  call Hloop_VQ_A(ntryL,G1H4(153),ex2(:),G1H2(9),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(77),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(154),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(154),ex4(:),G1H2(9),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VQ_A(ntryL,G1H4(159),ex2(:),G1H2(10),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(10),55,0,G2H2(78),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(160),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(160),ex4(:),G1H2(10),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_VQ_A(ntryL,G1H4(164),ex2(:),G1H2(11),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(79),n2h2(47))
  call Hloop_VQ_A(ntryL,G1H4(165),ex2(:),G1H2(11),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(11),59,0,G2H2(80),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(166),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(166),ex3(:),G1H2(11),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_VQ_A(ntryL,G1H4(171),ex2(:),G1H2(12),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(12),59,0,G2H2(81),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(172),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(172),ex3(:),G1H2(12),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_VQ_A(ntryL,G1H4(176),ex2(:),G1H2(13),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(13),59,0,G2H2(82),n2h2(50))
  call Hloop_VA_Q(ntryL,G1H4(177),ex3(:),G1H2(13),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(13),61,0,G2H2(83),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(178),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(178),ex2(:),G1H2(13),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_VA_Q(ntryL,G1H4(183),ex3(:),G1H2(14),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(14),61,0,G2H2(84),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(184),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(184),ex2(:),G1H2(14),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_VA_Q(ntryL,G1H4(188),ex3(:),G1H2(15),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(15),61,0,G2H2(85),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(189),ex4(:),G1H2(15),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(15),61,0,G2H2(86),n2h2(54))
call HGT_raise_alpha_OLR(G1H4(190),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(190),ex2(:),G1H2(15),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_VA_Q(ntryL,G1H4(195),ex4(:),G1H2(16),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(16),61,0,G2H2(87),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(196),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(196),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(196),ex2(:),G1H2(16),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_VA_Q(ntryL,G1H4(200),ex4(:),G1H2(17),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(17),61,0,G2H2(88),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(201),ex5(:),G1H2(17),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(17),55,0,G2H2(89),n2h2(57))
call HGT_raise_alpha_OLR(G1H4(202),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(202),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(202),ex4(:),G1H2(17),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_QV_A(ntryL,G1H4(207),ex5(:),G1H2(18),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(18),55,0,G2H2(90),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(208),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(208),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(208),ex4(:),G1H2(18),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QV_A(ntryL,G1H4(212),ex5(:),G1H2(19),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(91),n2h2(59))
  call Hloop_QV_A(ntryL,G1H4(213),ex5(:),G1H2(19),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(92),n2h2(60))
call HGT_raise_alpha_OLR(G1H4(214),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(214),ex4(:),G1H2(19),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_QV_A(ntryL,G1H4(219),ex5(:),G1H2(20),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(93),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(220),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(220),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(220),ex4(:),G1H2(20),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_QV_A(ntryL,G1H4(224),ex5(:),G1H2(21),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(94),n2h2(62))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(21),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(95),n2h2(63))
call HGT_raise_alpha_OLR(G1H4(226),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(226),ex4(:),G1H2(21),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QV_A(ntryL,G1H4(231),ex5(:),G1H2(22),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(22),55,0,G2H2(96),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(232),ex4(:),G1H2(22),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QV_A(ntryL,G1H4(236),ex5(:),G1H2(23),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(97),n2h2(65))
  call Hloop_QV_A(ntryL,G1H4(237),ex5(:),G1H2(23),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(98),n2h2(66))
call HGT_raise_alpha_OLR(G1H4(238),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(238),ex4(:),G1H2(23),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_QV_A(ntryL,G1H4(243),ex5(:),G1H2(24),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(24),55,0,G2H2(99),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(244),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(244),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(244),ex4(:),G1H2(24),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_QV_A(ntryL,G1H4(248),ex5(:),G1H2(25),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(25),55,0,G2H2(100),n2h2(68))
  call Hloop_AV_Q(ntryL,G1H4(249),ex5(:),G1H2(25),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(25),61,0,G2H2(101),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(250),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(250),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(250),ex2(:),G1H2(25),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_AV_Q(ntryL,G1H4(255),ex5(:),G1H2(26),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(26),61,0,G2H2(102),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(256),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(256),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(256),ex2(:),G1H2(26),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AV_Q(ntryL,G1H4(260),ex5(:),G1H2(27),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(27),61,0,G2H2(103),n2h2(71))
  call Hloop_QV_A(ntryL,G1H4(261),ex5(:),G1H2(27),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(27),59,0,G2H2(104),n2h2(72))
call HGT_raise_alpha_OLR(G1H4(262),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(262),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(262),ex3(:),G1H2(27),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_QV_A(ntryL,G1H4(267),ex5(:),G1H2(28),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(28),59,0,G2H2(105),n2h2(73))
call HGT_raise_alpha_OLR(G1H4(268),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(268),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(268),ex3(:),G1H2(28),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_QV_A(ntryL,G1H4(272),ex5(:),G1H2(29),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(29),59,0,G2H2(106),n2h2(74))
  call Hloop_QV_A(ntryL,G1H4(273),ex5(:),G1H2(29),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(29),59,0,G2H2(107),n2h2(75))
call HGT_raise_alpha_OLR(G1H4(274),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(274),ex3(:),G1H2(29),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_QV_A(ntryL,G1H4(279),ex5(:),G1H2(30),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(30),59,0,G2H2(108),n2h2(76))
call HGT_raise_alpha_OLR(G1H4(280),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(280),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(280),ex3(:),G1H2(30),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_QV_A(ntryL,G1H4(284),ex5(:),G1H2(31),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(109),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H4(285),ex5(:),G1H2(31),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(31),61,0,G2H2(110),n2h2(78))
call HGT_raise_alpha_OLR(G1H4(286),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(286),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(286),ex2(:),G1H2(31),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_AV_Q(ntryL,G1H4(291),ex5(:),G1H2(32),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(32),61,0,G2H2(111),n2h2(79))
call HGT_raise_alpha_OLR(G1H4(292),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(292),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(292),ex2(:),G1H2(32),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_AV_Q(ntryL,G1H4(296),ex5(:),G1H2(33),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(33),61,0,G2H2(112),n2h2(80))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(9),mass5set(:,1),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(9),mass5set(:,1),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(10),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(12),mass5set(:,1),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(14),mass5set(:,1),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(16),mass5set(:,1),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(18),mass5set(:,1),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(21),mass5set(:,1),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(22),mass5set(:,1),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(23),mass5set(:,1),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(24),mass5set(:,1),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(25),mass5set(:,1),  & 
G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(106),16,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(26),mass5set(:,1),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),16,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(27),mass5set(:,1),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(118),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(28),mass5set(:,1),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(29),mass5set(:,1),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(11),mass5set(:,1),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(136),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(30),mass5set(:,1),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(142),16,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(17),mass5set(:,1),  & 
G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(148),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(31),mass5set(:,1),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(154),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(13),mass5set(:,1),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(160),16,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(32),mass5set(:,1),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(166),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(19),mass5set(:,1),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(172),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(74),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(80),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(83),ex2(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(86),ex2(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(89),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(95),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(98),ex4(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(101),ex2(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(104),ex3(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(107),ex3(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(110),ex2(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(20),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(24),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(75),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(32),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(28))
  call Hloop_AV_Q(ntryL,G1H2(117),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(29))
  call Hloop_AV_Q(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(46),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(52),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(54),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(147),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(153),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(160),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(165),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(172),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(64),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(6),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(5),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(11),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(13),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(15),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(17),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(19),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(20),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(9),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(9),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(10),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(10),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(12),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(14),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(16),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(18),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(21),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(22),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(23),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(24),mass5set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(25),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(26),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(27),mass5set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(28),mass5set(:,1),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(29),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(11),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(30),mass5set(:,1),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(17),mass5set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(31),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(13),mass5set(:,1),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(32),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(19),mass5set(:,1),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,5,16,2,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(25))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,5,8,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(26))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,8,16,5],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(27))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,8,5,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(28))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,5,2,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(29))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,8,2,5,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(30))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,2,16,8,5],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,16,5,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,5,2,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,8,5,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(31))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,2,5,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,2,5,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(32))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(33))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(34))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(35))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(36))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(37))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(38))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,16,8,6],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,16,6,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,6,1,16,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(39))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,6,16,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(40))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,2,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(41))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,9,4,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(26),n2h32(42))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,2,4,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(43))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,2,4,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(44))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,9,2,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(45))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,4,2,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(46))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,2,16,4,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,2,16,9,4],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,4,16,2,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(33),m3h2x32(:,73),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,4,9,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(47))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,2,9,16,4],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(35),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,2,9,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(48))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,4,1,16,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(37),n2h32(49))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,10,4,1,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(38),n2h32(50))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,1,4,16,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(51))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,4,10,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(52))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,10,1,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(53))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,4,1,10,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(42),n2h32(54))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,16,4,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,16,10,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,4,16,1,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,4,10,1,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(46),n2h32(55))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,10,16,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,10,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(56))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,4,2,8,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(49),n2h32(57))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,4,2,8,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,8,2,4,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(51),n2h32(58))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,8,2,4,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,2,4,8,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,2,4,17,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(54),n2h32(59))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)-c(5)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,2,4,17,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,95),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,8,4,2,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(56),n2h32(60))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,2,17,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(57),m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,2,8,4,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,2,8,17,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(61))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,2,8,17,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,8,2,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(61),n2h32(62))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,17,2,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,2,17,8,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(63))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,2,17,4,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(64),n2h32(64))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,1,8,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(65),n2h32(65))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,1,8,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,8,1,4,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(67),n2h32(66))
  Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,8,1,4,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,1,4,8,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(69),m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,1,4,18,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(70),n2h32(67))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,1,4,18,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(71),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,8,4,1,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(72),n2h32(68))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,4,1,18,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,1,8,4,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,1,8,18,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(75),n2h32(69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,8,18,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,4,8,1,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(77),n2h32(70))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,4,18,1,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,18,8,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(79),n2h32(71))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,18,4,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(80),n2h32(72))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(81),n2h32(73))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(83),n2h32(74))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(84),n2h32(75))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(85),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,126),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(86),n2h32(76))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,127),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(77))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(90),n2h32(78))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(92),n2h32(79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)-c(5)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(95),n2h32(80))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,136),heltab2x64(:,:,136))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(97),n2h32(81))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(99),n2h32(82))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(100),n2h32(83))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(101),m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,142),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(102),n2h32(84))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(85))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(104),m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(105),m3h2x32(:,145),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(106),n2h32(86))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)-c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(107),m3h2x32(:,147),heltab2x64(:,:,147))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(11)*(-M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(108),n2h32(87))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(109),m3h2x32(:,149),heltab2x64(:,:,149))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,150),heltab2x64(:,:,150))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(88))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(112),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[33,8,2,4,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[33,4,2,8,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,154))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[33,4,2,16,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,155))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[33,2,4,8,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[33,4,16,2,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,5),heltab2x64(:,:,157))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[33,2,8,4,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,6),heltab2x64(:,:,158))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[33,2,16,4,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(6),m3h4x16(:,7),heltab2x64(:,:,159))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[33,2,16,8,4],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(7),m3h4x16(:,8),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[34,8,1,4,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,9),heltab2x64(:,:,161))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[34,4,1,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,10),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[34,4,1,16,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,11),heltab2x64(:,:,163))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(1),n2h16(26))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[34,1,4,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,12),heltab2x64(:,:,164))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[34,4,16,1,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(11),m3h4x16(:,13),heltab2x64(:,:,165))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[34,1,8,4,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,14),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[34,1,16,4,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,15),heltab2x64(:,:,167))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[34,1,16,8,4],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(14),m3h4x16(:,16),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(15),m3h4x16(:,17),heltab2x64(:,:,169))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(16),m3h4x16(:,18),heltab2x64(:,:,170))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,19),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(17),36,0,G1H16(3),n2h16(27))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,20),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(17),36,0,G1H16(26),n2h16(28))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,21),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(18),m3h4x16(:,22),heltab2x64(:,:,174))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,23),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(19),36,0,G1H16(27),n2h16(29))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,24),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,25),heltab2x64(:,:,177))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,26),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,27),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(22),40,0,G1H16(4),n2h16(30))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,28),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G0H16(22),40,0,G1H16(5),n2h16(31))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,29),heltab2x64(:,:,181))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(23),m3h4x16(:,30),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(24),m3h4x16(:,31),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H16(24),40,0,G1H16(28),n2h16(32))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(24),m3h4x16(:,32),heltab2x64(:,:,184))
  call Hloop_AV_Q(ntryL,G1H16(2),ex5(:),G1H8(9),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(9),52,0,G2H8(9),n2h8(73))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(10),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(10),52,0,G2H8(10),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(9),ex5(:),G1H8(13),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(13),50,0,G2H8(11),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(15),ex5(:),G1H8(14),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(14),50,0,G2H8(12),n2h8(76))
  call Hloop_QV_A(ntryL,G1H16(19),ex5(:),G1H8(15),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(15),49,0,G2H8(13),n2h8(77))
  call Hloop_QV_A(ntryL,G1H16(33),ex5(:),G1H8(16),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(16),49,0,G2H8(14),n2h8(78))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(19),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(15),n2h8(79))
  call Hloop_QV_A(ntryL,G1H16(45),ex5(:),G1H8(20),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(20),49,0,G2H8(16),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(21),m3h4x8(:,1),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(21),37,0,G2H8(17),n2h8(81))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,1),G1H8(22),m3h4x8(:,2),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(22),37,0,G2H8(18),n2h8(82))
  call Hloop_AQ_V(ntryL,G1H32(3),ex2(:),G1H16(29),m3h2x16(:,41),heltab2x32(:,:,43))
  call Hloop_AQ_V(ntryL,G1H32(4),ex2(:),G1H16(30),m3h2x16(:,42),heltab2x32(:,:,44))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(25),m3h4x8(:,3),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(25),37,0,G2H8(19),n2h8(83))
  call Hloop_QA_V(ntryL,G1H32(6),ex4(:),G1H16(7),m3h2x16(:,43),heltab2x32(:,:,46))
  call Hloop_VQ_A(ntryL,G1H32(7),ex2(:),G1H16(8),m3h2x16(:,44),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G1H16(8),34,0,G2H16(1),n2h16(33))
  call Hloop_VQ_A(ntryL,G1H32(8),ex2(:),G1H16(10),m3h2x16(:,45),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(10),34,0,G2H16(2),n2h16(34))
  call Hloop_UV_W(ntryL,G1H32(9),32,wf4(:,1),5,G2H8(20),m3h4x8(:,4),heltab2x32(:,:,49))
  call Hloop_QA_V(ntryL,G1H32(10),ex4(:),G1H16(11),m3h2x16(:,46),heltab2x32(:,:,50))
  call Hloop_VQ_A(ntryL,G1H32(11),ex2(:),G1H16(12),m3h2x16(:,47),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(12),34,0,G2H16(3),n2h16(35))
  call Hloop_AQ_V(ntryL,G1H32(12),ex2(:),G1H16(13),m3h2x16(:,48),heltab2x32(:,:,52))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,11),G1H8(26),m3h4x8(:,5),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(26),38,0,G2H8(21),n2h8(84))
  call Hloop_QV_A(ntryL,G1H32(14),wf4(:,11),G1H8(27),m3h4x8(:,6),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(27),38,0,G2H8(22),n2h8(85))
  call Hloop_AQ_V(ntryL,G1H32(15),ex1(:),G1H16(14),m3h2x16(:,49),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(16),m3h2x16(:,50),heltab2x32(:,:,56))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,11),G1H8(28),m3h4x8(:,7),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(28),38,0,G2H8(23),n2h8(86))
  call Hloop_QA_V(ntryL,G1H32(18),ex4(:),G1H16(31),m3h2x16(:,51),heltab2x32(:,:,58))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(32),m3h2x16(:,52),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(32),33,0,G2H16(4),n2h16(36))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(17),m3h2x16(:,53),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(5),n2h16(37))
  call Hloop_UV_W(ntryL,G1H32(21),32,wf4(:,11),6,G2H8(24),m3h4x8(:,8),heltab2x32(:,:,61))
  call Hloop_QA_V(ntryL,G1H32(22),ex4(:),G1H16(18),m3h2x16(:,54),heltab2x32(:,:,62))
  call Hloop_VQ_A(ntryL,G1H32(23),ex1(:),G1H16(20),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(20),33,0,G2H16(6),n2h16(38))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(21),m3h2x16(:,56),heltab2x32(:,:,64))
  call Hloop_QA_V(ntryL,G1H32(25),ex3(:),G1H16(22),m3h2x16(:,57),heltab2x32(:,:,65))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,15),G1H8(31),m3h4x8(:,9),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(31),41,0,G2H8(25),n2h8(87))
  call Hloop_AQ_V(ntryL,G1H32(27),ex2(:),G1H16(23),m3h2x16(:,58),heltab2x32(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(28),ex2(:),G1H16(24),m3h2x16(:,59),heltab2x32(:,:,68))
  call Hloop_AV_Q(ntryL,G1H32(29),wf4(:,15),G1H8(32),m3h4x8(:,10),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(32),41,0,G2H8(26),n2h8(88))
  call Hloop_QA_V(ntryL,G1H32(30),ex3(:),G1H16(34),m3h2x16(:,60),heltab2x32(:,:,70))
  call Hloop_VQ_A(ntryL,G1H32(31),ex2(:),G1H16(35),m3h2x16(:,61),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(35),34,0,G2H16(7),n2h16(39))
  call Hloop_VQ_A(ntryL,G1H32(32),ex2(:),G1H16(36),m3h2x16(:,62),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(36),34,0,G2H16(8),n2h16(40))
  call Hloop_VA_Q(ntryL,G1H32(33),ex3(:),G1H16(37),m3h2x16(:,63),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H16(37),36,0,G2H16(9),n2h16(41))
  call Hloop_QA_V(ntryL,G1H32(34),ex3(:),G1H16(38),m3h2x16(:,64),heltab2x32(:,:,74))
  call Hloop_VQ_A(ntryL,G1H32(35),ex2(:),G1H16(40),m3h2x16(:,65),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H16(40),34,0,G2H16(10),n2h16(42))
  call Hloop_AQ_V(ntryL,G1H32(36),ex2(:),G1H16(41),m3h2x16(:,66),heltab2x32(:,:,76))
  call Hloop_QA_V(ntryL,G1H32(37),ex3(:),G1H16(42),m3h2x16(:,67),heltab2x32(:,:,77))
  call Hloop_QV_A(ntryL,G1H32(38),wf4(:,20),G1H8(33),m3h4x8(:,11),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(33),42,0,G2H8(27),n2h8(89))
  call Hloop_AQ_V(ntryL,G1H32(39),ex1(:),G1H16(43),m3h2x16(:,68),heltab2x32(:,:,79))
  call Hloop_AQ_V(ntryL,G1H32(40),ex1(:),G1H16(44),m3h2x16(:,69),heltab2x32(:,:,80))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,20),G1H8(34),m3h4x8(:,12),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(34),42,0,G2H8(28),n2h8(90))
  call Hloop_QA_V(ntryL,G1H32(42),ex3(:),G1H16(46),m3h2x16(:,70),heltab2x32(:,:,82))
  call Hloop_VQ_A(ntryL,G1H32(43),ex1(:),G1H16(47),m3h2x16(:,71),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H16(47),33,0,G2H16(11),n2h16(43))
  call Hloop_VQ_A(ntryL,G1H32(44),ex1(:),G1H16(48),m3h2x16(:,72),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(48),33,0,G2H16(12),n2h16(44))
  call Hloop_VA_Q(ntryL,G1H32(45),ex3(:),G1H16(2),m3h2x16(:,73),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H16(2),36,0,G2H16(13),n2h16(45))
  call Hloop_QA_V(ntryL,G1H32(46),ex3(:),G1H16(6),m3h2x16(:,74),heltab2x32(:,:,86))
  call Hloop_VQ_A(ntryL,G1H32(47),ex1(:),G1H16(9),m3h2x16(:,75),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(9),33,0,G2H16(14),n2h16(46))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(15),m3h2x16(:,76),heltab2x32(:,:,88))
  call Hloop_QA_V(ntryL,G1H32(49),ex3(:),G1H16(19),m3h2x16(:,77),heltab2x32(:,:,89))
  call Hloop_VA_Q(ntryL,G1H32(50),ex3(:),G1H16(33),m3h2x16(:,78),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H16(33),36,0,G2H16(15),n2h16(47))
  call Hloop_QA_V(ntryL,G1H32(51),ex4(:),G1H16(39),m3h2x16(:,79),heltab2x32(:,:,91))
  call Hloop_VA_Q(ntryL,G1H32(52),ex4(:),G1H16(45),m3h2x16(:,80),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(45),40,0,G2H16(16),n2h16(48))
  call Hloop_VQ_A(ntryL,G1H32(53),ex2(:),G1H16(8),m3h2x16(:,81),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(8),34,0,G2H16(17),n2h16(49))
  call Hloop_AQ_V(ntryL,G1H32(54),ex2(:),G1H16(10),m3h2x16(:,82),heltab2x32(:,:,94))
  call Hloop_VQ_A(ntryL,G1H32(55),ex2(:),G1H16(12),m3h2x16(:,83),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H16(12),34,0,G2H16(18),n2h16(50))
  call Hloop_QA_V(ntryL,G1H32(56),ex4(:),G1H16(32),m3h2x16(:,84),heltab2x32(:,:,96))
  call Hloop_VA_Q(ntryL,G1H32(57),ex3(:),G1H16(17),m3h2x16(:,85),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H16(17),36,0,G2H16(19),n2h16(51))
  call Hloop_VQ_A(ntryL,G1H32(58),ex2(:),G1H16(20),m3h2x16(:,86),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(20),34,0,G2H16(20),n2h16(52))
  call Hloop_AQ_V(ntryL,G1H32(59),ex2(:),G1H16(35),m3h2x16(:,87),heltab2x32(:,:,99))
  call Hloop_VQ_A(ntryL,G1H32(60),ex2(:),G1H16(36),m3h2x16(:,88),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H16(36),34,0,G2H16(21),n2h16(53))
  call Hloop_QA_V(ntryL,G1H32(61),ex3(:),G1H16(37),m3h2x16(:,89),heltab2x32(:,:,101))
  call Hloop_VA_Q(ntryL,G1H32(62),ex3(:),G1H16(40),m3h2x16(:,90),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H16(40),36,0,G2H16(22),n2h16(54))
  call Hloop_AQ_V(ntryL,G1H32(63),ex2(:),G1H16(47),m3h2x16(:,91),heltab2x32(:,:,103))
  call Hloop_AQ_V(ntryL,G1H32(64),ex2(:),G1H16(48),m3h2x16(:,92),heltab2x32(:,:,104))
  call Hloop_QA_V(ntryL,G1H32(65),ex3(:),G1H16(2),m3h2x16(:,93),heltab2x32(:,:,105))
  call Hloop_VA_Q(ntryL,G1H32(66),ex3(:),G1H16(9),m3h2x16(:,94),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H16(9),36,0,G2H16(23),n2h16(55))
  call Hloop_QA_V(ntryL,G1H32(67),ex4(:),G1H16(33),m3h2x16(:,95),heltab2x32(:,:,107))
  call Hloop_VA_Q(ntryL,G1H32(68),ex4(:),G1H16(45),m3h2x16(:,96),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H16(45),40,0,G2H16(24),n2h16(56))
  call Hloop_VQ_A(ntryL,G1H32(69),ex1(:),G1H16(8),m3h2x16(:,97),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H16(8),33,0,G2H16(25),n2h16(57))
  call Hloop_AQ_V(ntryL,G1H32(70),ex1(:),G1H16(12),m3h2x16(:,98),heltab2x32(:,:,110))
  call Hloop_VQ_A(ntryL,G1H32(71),ex1(:),G1H16(17),m3h2x16(:,99),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(26),n2h16(58))
  call Hloop_QA_V(ntryL,G1H32(72),ex4(:),G1H16(20),m3h2x16(:,100),heltab2x32(:,:,112))
  call Hloop_VA_Q(ntryL,G1H32(73),ex3(:),G1H16(36),m3h2x16(:,101),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H16(36),36,0,G2H16(27),n2h16(59))
  call Hloop_VQ_A(ntryL,G1H32(74),ex1(:),G1H16(40),m3h2x16(:,102),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H16(40),33,0,G2H16(28),n2h16(60))
  call Hloop_AQ_V(ntryL,G1H32(75),ex1(:),G1H16(9),m3h2x16(:,103),heltab2x32(:,:,115))
  call Hloop_VQ_A(ntryL,G1H32(76),ex1(:),G1H16(45),m3h2x16(:,104),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(45),33,0,G2H16(29),n2h16(61))
  call Hloop_QA_V(ntryL,G1H32(77),ex3(:),G1H16(8),m3h2x16(:,105),heltab2x32(:,:,117))
  call Hloop_VA_Q(ntryL,G1H32(78),ex3(:),G1H16(17),m3h2x16(:,106),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G1H16(17),36,0,G2H16(30),n2h16(62))
  call Hloop_AQ_V(ntryL,G1H32(79),ex1(:),G1H16(36),m3h2x16(:,107),heltab2x32(:,:,119))
  call Hloop_AQ_V(ntryL,G1H32(80),ex1(:),G1H16(40),m3h2x16(:,108),heltab2x32(:,:,120))
  call Hloop_AQ_V(ntryL,G1H32(81),ex2(:),G1H16(45),m3h2x16(:,109),heltab2x32(:,:,121))
  call Hloop_VA_Q(ntryL,G1H32(82),ex4(:),G1H16(17),m3h2x16(:,110),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H16(17),40,0,G2H16(31),n2h16(63))
  call Hloop_AQ_V(ntryL,G1H32(83),ex1(:),G1H16(17),m3h2x16(:,111),heltab2x32(:,:,123))
  call Hloop_AQ_V(ntryL,G1H32(84),ex1(:),G1H16(49),m3h2x16(:,112),heltab2x32(:,:,124))
  call Hloop_VA_Q(ntryL,G1H32(85),ex4(:),G1H16(50),m3h2x16(:,113),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G1H16(50),40,0,G2H16(32),n2h16(64))
  call Hloop_AQ_V(ntryL,G1H32(86),ex2(:),G1H16(50),m3h2x16(:,114),heltab2x32(:,:,126))
  call Hloop_AQ_V(ntryL,G1H32(87),ex1(:),G1H16(51),m3h2x16(:,115),heltab2x32(:,:,127))
  call Hloop_VQ_A(ntryL,G1H32(88),ex1(:),G1H16(52),m3h2x16(:,116),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(52),33,0,G2H16(33),n2h16(65))
  call Hloop_VQ_A(ntryL,G1H32(89),ex1(:),G1H16(52),m3h2x16(:,117),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H16(52),33,0,G2H16(34),n2h16(66))
  call Hloop_AQ_V(ntryL,G1H32(90),ex2(:),G1H16(52),m3h2x16(:,118),heltab2x32(:,:,130))
  call Hloop_VQ_A(ntryL,G1H32(91),ex2(:),G1H16(53),m3h2x16(:,119),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G1H16(53),34,0,G2H16(35),n2h16(67))
  call Hloop_AQ_V(ntryL,G1H32(92),ex2(:),G1H16(53),m3h2x16(:,120),heltab2x32(:,:,132))
  call Hloop_VQ_A(ntryL,G1H32(93),ex2(:),G1H16(54),m3h2x16(:,121),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G1H16(54),34,0,G2H16(36),n2h16(68))
  call Hloop_VQ_A(ntryL,G1H32(94),ex1(:),G1H16(54),m3h2x16(:,122),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(54),33,0,G2H16(37),n2h16(69))
  call Hloop_AQ_V(ntryL,G1H32(95),ex1(:),G1H16(54),m3h2x16(:,123),heltab2x32(:,:,135))
  call Hloop_VQ_A(ntryL,G1H32(96),ex1(:),G1H16(55),m3h2x16(:,124),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G1H16(55),33,0,G2H16(38),n2h16(70))
  call Hloop_AQ_V(ntryL,G1H32(97),ex2(:),G1H16(55),m3h2x16(:,125),heltab2x32(:,:,137))
  call Hloop_VA_Q(ntryL,G1H32(98),ex3(:),G1H16(56),m3h2x16(:,126),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H16(56),36,0,G2H16(39),n2h16(71))
  call Hloop_AQ_V(ntryL,G1H32(99),ex1(:),G1H16(56),m3h2x16(:,127),heltab2x32(:,:,139))
  call Hloop_AQ_V(ntryL,G1H32(100),ex1(:),G1H16(57),m3h2x16(:,128),heltab2x32(:,:,140))
  call Hloop_VA_Q(ntryL,G1H32(101),ex3(:),G1H16(58),m3h2x16(:,129),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H16(58),36,0,G2H16(40),n2h16(72))
  call Hloop_AQ_V(ntryL,G1H32(102),ex2(:),G1H16(58),m3h2x16(:,130),heltab2x32(:,:,142))
  call Hloop_AQ_V(ntryL,G1H32(103),ex1(:),G1H16(59),m3h2x16(:,131),heltab2x32(:,:,143))
  call Hloop_VQ_A(ntryL,G1H32(104),ex1(:),G1H16(60),m3h2x16(:,132),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G1H16(60),33,0,G2H16(41),n2h16(73))
  call Hloop_VQ_A(ntryL,G1H32(105),ex1(:),G1H16(60),m3h2x16(:,133),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G1H16(60),33,0,G2H16(42),n2h16(74))
  call Hloop_AQ_V(ntryL,G1H32(106),ex2(:),G1H16(60),m3h2x16(:,134),heltab2x32(:,:,146))
  call Hloop_VQ_A(ntryL,G1H32(107),ex2(:),G1H16(61),m3h2x16(:,135),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G1H16(61),34,0,G2H16(43),n2h16(75))
  call Hloop_AQ_V(ntryL,G1H32(108),ex2(:),G1H16(61),m3h2x16(:,136),heltab2x32(:,:,148))
  call Hloop_VQ_A(ntryL,G1H32(109),ex2(:),G1H16(62),m3h2x16(:,137),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G1H16(62),34,0,G2H16(44),n2h16(76))
  call Hloop_VQ_A(ntryL,G1H32(110),ex1(:),G1H16(62),m3h2x16(:,138),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G1H16(62),33,0,G2H16(45),n2h16(77))
  call Hloop_AQ_V(ntryL,G1H32(111),ex1(:),G1H16(62),m3h2x16(:,139),heltab2x32(:,:,151))
  call Hloop_VQ_A(ntryL,G1H32(112),ex1(:),G1H16(63),m3h2x16(:,140),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G1H16(63),33,0,G2H16(46),n2h16(78))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(1),41,0,G1H8(37),n2h8(91))
  call Hloop_VA_Q(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(1),37,0,G1H8(38),n2h8(92))
  call Hloop_QA_V(ntryL,G1H16(25),ex3(:),G1H8(39),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_VQ_A(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(40),n2h8(93))
  call Hloop_VA_Q(ntryL,G0H16(4),ex3(:),G0H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(1),37,0,G1H8(43),n2h8(94))
  call Hloop_VQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(44),n2h8(95))
  call Hloop_VQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(45),n2h8(96))
  call Hloop_VQ_A(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(46),n2h8(97))
  call Hloop_VA_Q(ntryL,G0H16(8),ex4(:),G0H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(49),n2h8(98))
  call Hloop_VA_Q(ntryL,G0H16(9),ex3(:),G0H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(50),n2h8(99))
  call Hloop_QA_V(ntryL,G1H16(1),ex3(:),G1H8(51),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(52),n2h8(100))
  call Hloop_VA_Q(ntryL,G0H16(11),ex3(:),G0H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(55),n2h8(101))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(56),n2h8(102))
  call Hloop_VQ_A(ntryL,G0H16(13),ex1(:),G0H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(57),n2h8(103))
  call Hloop_VQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(58),n2h8(104))
  call Hloop_VA_Q(ntryL,G0H16(15),ex4(:),G0H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(61),n2h8(105))
  call Hloop_VA_Q(ntryL,G0H16(16),ex4(:),G0H8(1),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(62),n2h8(106))
  call Hloop_AQ_V(ntryL,G1H16(3),ex2(:),G1H8(63),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntryL,G1H16(26),ex1(:),G1H8(64),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_VQ_A(ntryL,G0H16(17),ex2(:),G0H8(1),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G0H8(1),38,0,G1H8(67),n2h8(107))
  call Hloop_VQ_A(ntryL,G0H16(18),ex1(:),G0H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(68),n2h8(108))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(69),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_VQ_A(ntryL,G0H16(19),ex1(:),G0H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(70),n2h8(109))
  call Hloop_VA_Q(ntryL,G0H16(20),ex3(:),G0H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(73),n2h8(110))
  call Hloop_VA_Q(ntryL,G0H16(21),ex3(:),G0H8(1),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(74),n2h8(111))
  call Hloop_AQ_V(ntryL,G1H16(4),ex2(:),G1H8(75),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_AQ_V(ntryL,G1H16(5),ex1(:),G1H8(76),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_VQ_A(ntryL,G0H16(22),ex2(:),G0H8(1),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(1),42,0,G1H8(79),n2h8(112))
  call Hloop_VQ_A(ntryL,G0H16(23),ex1(:),G0H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(80),n2h8(113))
  call Hloop_AQ_V(ntryL,G1H16(28),ex1(:),G1H8(81),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_VQ_A(ntryL,G0H16(24),ex1(:),G0H8(1),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(82),n2h8(114))
call HGT_w2_OLR(G1H8(5),1,1,8)
call HGT_w2_invQ_OLR(G1H8(5),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(82)])
call HGT_w2_OLR(G1H8(6),1,1,8)
call HGT_w2_invQ_OLR(G1H8(6),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(29)])
call HGT_w2_OLR(G1H8(7),1,1,8)
call HGT_w2_invQ_OLR(G1H8(7),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(57),[G1H8(23)])
call HGT_w2_OLR(G1H8(8),1,1,8)
call HGT_w2_invQ_OLR(G1H8(8),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G1H8(60),G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G1H8(48),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G1H8(78)])
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(110),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(110),60,0,G2H4(17),n2h4(97))
  call Hloop_AQ_V(ntryL,G2H8(34),ex2(:),G2H4(19),m3h2x4(:,106),heltab2x8(:,:,106))
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(122),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(122),60,0,G2H4(20),n2h4(98))
  call Hloop_AQ_V(ntryL,G2H8(38),ex1(:),G2H4(22),m3h2x4(:,108),heltab2x8(:,:,108))
call HGT_w2_OLR(G1H8(3),1,1,8)
call HGT_w2_invQ_OLR(G1H8(3),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(134),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(134),58,0,G2H4(23),n2h4(99))
  call Hloop_QA_V(ntryL,G2H8(42),ex3(:),G2H4(25),m3h2x4(:,110),heltab2x8(:,:,110))
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(146),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(146),54,0,G2H4(26),n2h4(100))
  call Hloop_QA_V(ntryL,G2H8(46),ex4(:),G2H4(28),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(158),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(158),57,0,G2H4(29),n2h4(101))
  call Hloop_QA_V(ntryL,G2H8(50),ex3(:),G2H4(31),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(170),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(170),53,0,G2H4(32),n2h4(102))
  call Hloop_QA_V(ntryL,G2H8(54),ex4(:),G2H4(34),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(182),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(182),51,0,G2H4(35),n2h4(103))
  call Hloop_QA_V(ntryL,G2H8(58),ex4(:),G2H4(37),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(8),ex5(:),G1H4(194),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(194),51,0,G2H4(38),n2h4(104))
  call Hloop_QA_V(ntryL,G2H8(62),ex3(:),G2H4(40),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_VQ_A(ntryL,G1H8(64),ex2(:),G1H4(206),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(206),39,0,G2H4(41),n2h4(105))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(47),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hloop_VQ_A(ntryL,G1H8(63),ex1(:),G1H4(218),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(218),39,0,G2H4(43),n2h4(106))
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(48),mass5set(:,1),  & 
G1H8(93),G1H8(94),G1H8(97),G1H8(98),G1H8(99),G1H8(100),8)
  call HG1shiftOLR(G1H8(94),8,8)
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(230),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(230),51,0,G2H4(44),n2h4(107))
  call Hloop_QV_A(ntryL,G1H8(42),ex5(:),G1H4(242),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(242),51,0,G2H4(46),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(45),ex5(:),G1H4(254),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(254),51,0,G2H4(47),n2h4(109))
  call Hloop_QV_A(ntryL,G1H8(46),ex5(:),G1H4(266),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(266),51,0,G2H4(50),n2h4(110))
  call Hloop_VQ_A(ntryL,G1H8(51),ex1(:),G1H4(278),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(278),39,0,G2H4(51),n2h4(111))
  call Hloop_AV_Q(ntryL,G1H8(53),ex5(:),G1H4(290),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(290),58,0,G2H4(54),n2h4(112))
  call Hloop_AV_Q(ntryL,G1H8(54),ex5(:),G1H4(9),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(9),58,0,G2H4(55),n2h4(113))
  call Hloop_VQ_A(ntryL,G1H8(39),ex2(:),G1H4(10),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(10),39,0,G2H4(58),n2h4(114))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(14),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(14),53,0,G2H4(59),n2h4(115))
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(49),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(9),G1H8(10),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_VA_Q(ntryL,G1H8(71),ex4(:),G1H4(15),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(15),45,0,G2H4(62),n2h4(116))
  call Hloop_VA_Q(ntryL,G1H8(72),ex4(:),G1H4(16),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(16),45,0,G2H4(63),n2h4(117))
  call Hloop_AV_Q(ntryL,G1H8(55),ex5(:),G1H4(20),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(65),n2h4(118))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(50),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_VQ_A(ntryL,G1H8(83),ex1(:),G1H4(21),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(21),43,0,G2H4(66),n2h4(119))
  call Hloop_VQ_A(ntryL,G1H8(84),ex1(:),G1H4(22),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(22),43,0,G2H4(69),n2h4(120))
  call Hloop_AV_Q(ntryL,G1H8(89),ex5(:),G1H4(26),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(26),57,0,G2H4(70),n2h4(121))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(27),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(27),57,0,G2H4(72),n2h4(122))
  call Hloop_VQ_A(ntryL,G1H8(95),ex2(:),G1H4(28),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(28),43,0,G2H4(73),n2h4(123))
  call Hloop_VQ_A(ntryL,G1H8(96),ex2(:),G1H4(32),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(32),43,0,G2H4(76),n2h4(124))
  call Hloop_VA_Q(ntryL,G1H8(101),ex3(:),G1H4(33),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(33),45,0,G2H4(77),n2h4(125))
  call Hloop_VA_Q(ntryL,G1H8(102),ex3(:),G1H4(34),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(34),45,0,G2H4(79),n2h4(126))
  call Hloop_AQ_V(ntryL,G2H8(9),ex2(:),G2H4(80),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(83),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_QA_V(ntryL,G2H8(11),ex3(:),G2H4(84),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_QA_V(ntryL,G2H8(12),ex4(:),G2H4(86),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_QA_V(ntryL,G2H8(13),ex3(:),G2H4(87),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_QA_V(ntryL,G2H8(14),ex4(:),G2H4(90),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(91),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_QA_V(ntryL,G2H8(16),ex3(:),G2H4(93),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_QA_V(ntryL,G2H8(18),ex4(:),G2H4(94),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_VA_Q(ntryL,G1H16(29),ex4(:),G1H8(25),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(29),n2h8(115))
  call Hloop_VA_Q(ntryL,G1H16(30),ex4(:),G1H8(26),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(30),n2h8(116))
  call Hloop_AQ_V(ntryL,G2H8(19),ex2(:),G2H4(96),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_VQ_A(ntryL,G1H16(7),ex2(:),G1H8(27),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(27),42,0,G2H8(31),n2h8(117))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(4),mass5set(:,1),  & 
G1H16(63),G1H16(25),G1H16(1),G1H16(3),G1H16(26),G1H16(27),16)
  call HG1shiftOLR(G1H16(25),5,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(34),mass5set(:,1),  & 
G1H16(4),G1H16(5),G1H16(28),G1H16(29),G1H16(30),G1H16(7),16)
  call HG1shiftOLR(G1H16(5),8,16)
  call Hloop_UV_W(ntryL,G1H16(11),40,wf4(:,1),5,G2H4(1),m3h4x4(:,1),heltab2x16(:,:,116))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(51),mass5set(:,1),  & 
G1H16(11),G1H16(64),G1H16(65),G1H16(66),G1H16(67),G1H16(68),16)
  call HG1shiftOLR(G1H16(64),8,16)
  call Hloop_UV_W(ntryL,G1H16(13),34,wf4(:,1),5,G2H4(2),m3h4x4(:,2),heltab2x16(:,:,117))
  call Hloop_QA_V(ntryL,G2H8(22),ex4(:),G2H4(3),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_VA_Q(ntryL,G1H16(14),ex4(:),G1H8(28),m3h2x8(:,116),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(28),41,0,G2H8(32),n2h8(118))
  call Hloop_VA_Q(ntryL,G1H16(16),ex4(:),G1H8(31),m3h2x8(:,117),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(31),41,0,G2H8(33),n2h8(119))
  call Hloop_AQ_V(ntryL,G2H8(23),ex1(:),G2H4(4),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_VQ_A(ntryL,G1H16(31),ex1(:),G1H8(32),m3h2x8(:,118),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(32),41,0,G2H8(35),n2h8(120))
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(6),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(16),G1H16(31),G1H16(69),G1H16(70),16)
  call HG1shiftOLR(G1H16(14),6,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(36),mass5set(:,1),  & 
G1H16(71),G1H16(72),G1H16(73),G1H16(74),G1H16(75),G1H16(76),16)
  call HG1shiftOLR(G1H16(72),8,16)
  call Hloop_UV_W(ntryL,G1H16(18),40,wf4(:,11),6,G2H4(5),m3h4x4(:,3),heltab2x16(:,:,121))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(52),mass5set(:,1),  & 
G1H16(18),G1H16(77),G1H16(78),G1H16(79),G1H16(80),G1H16(81),16)
  call HG1shiftOLR(G1H16(77),8,16)
  call Hloop_UV_W(ntryL,G1H16(21),33,wf4(:,11),6,G2H4(6),m3h4x4(:,4),heltab2x16(:,:,122))
  call Hloop_VQ_A(ntryL,G1H16(22),ex2(:),G1H8(33),m3h2x8(:,119),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(33),38,0,G2H8(36),n2h8(121))
  call Hloop_QA_V(ntryL,G2H8(25),ex3(:),G2H4(7),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_VA_Q(ntryL,G1H16(23),ex3(:),G1H8(34),m3h2x8(:,120),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(34),38,0,G2H8(37),n2h8(122))
  call Hloop_VA_Q(ntryL,G1H16(24),ex3(:),G1H8(82),m3h2x8(:,121),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(82),38,0,G2H8(39),n2h8(123))
  call Hloop_AQ_V(ntryL,G2H8(26),ex2(:),G2H4(8),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_VQ_A(ntryL,G1H16(34),ex2(:),G1H8(70),m3h2x8(:,122),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(70),38,0,G2H8(40),n2h8(124))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(3),mass5set(:,1),  & 
G1H16(21),G1H16(22),G1H16(23),G1H16(24),G1H16(34),G1H16(82),16)
  call HG1shiftOLR(G1H16(22),9,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(35),mass5set(:,1),  & 
G1H16(83),G1H16(84),G1H16(85),G1H16(86),G1H16(87),G1H16(88),16)
  call HG1shiftOLR(G1H16(84),4,16)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(1),mass5set(:,1),  & 
G1H16(89),G1H16(90),G1H16(91),G1H16(92),G1H16(93),G1H16(94),16)
  call HG1shiftOLR(G1H16(90),9,16)
  call Hloop_UV_W(ntryL,G1H16(38),36,wf4(:,15),9,G2H4(9),m3h4x4(:,5),heltab2x16(:,:,127))
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(53),mass5set(:,1),  & 
G1H16(38),G1H16(95),G1H16(96),G1H16(97),G1H16(98),G1H16(99),16)
  call HG1shiftOLR(G1H16(95),4,16)
  call Hloop_UV_W(ntryL,G1H16(41),34,wf4(:,15),9,G2H4(10),m3h4x4(:,6),heltab2x16(:,:,128))
  call Hloop_VQ_A(ntryL,G1H16(42),ex1(:),G1H8(29),m3h2x8(:,123),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(41),n2h8(125))
  call Hloop_QA_V(ntryL,G2H8(27),ex3(:),G2H4(11),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_VA_Q(ntryL,G1H16(43),ex3(:),G1H8(58),m3h2x8(:,124),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(58),37,0,G2H8(43),n2h8(126))
  call Hloop_VA_Q(ntryL,G1H16(44),ex3(:),G1H8(23),m3h2x8(:,125),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H8(23),37,0,G2H8(44),n2h8(127))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(12),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_VQ_A(ntryL,G1H16(46),ex1(:),G1H8(57),m3h2x8(:,126),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(57),37,0,G2H8(45),n2h8(128))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(41),G1H16(42),G1H16(43),G1H16(44),G1H16(46),G1H16(100),16)
  call HG1shiftOLR(G1H16(42),10,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(37),mass5set(:,1),  & 
G1H16(101),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G1H16(106),16)
  call HG1shiftOLR(G1H16(102),4,16)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(2),mass5set(:,1),  & 
G1H16(107),G1H16(108),G1H16(109),G1H16(110),G1H16(111),G1H16(112),16)
  call HG1shiftOLR(G1H16(108),10,16)
  call Hloop_UV_W(ntryL,G1H16(6),36,wf4(:,20),10,G2H4(13),m3h4x4(:,7),heltab2x16(:,:,133))
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(54),mass5set(:,1),  & 
G1H16(6),G1H16(113),G1H16(114),G1H16(115),G1H16(116),G1H16(117),16)
  call HG1shiftOLR(G1H16(113),4,16)
  call Hloop_UV_W(ntryL,G1H16(15),33,wf4(:,20),10,G2H4(14),m3h4x4(:,8),heltab2x16(:,:,134))
  call Hloop_VQ_A(ntryL,G1H16(19),ex2(:),G1H8(11),m3h2x8(:,127),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(11),38,0,G2H8(47),n2h8(129))
  call Hloop_AQ_V(ntryL,G2H16(15),ex2(:),G2H8(48),m3h2x8(:,128),heltab2x16(:,:,136))
  call Hloop_VQ_A(ntryL,G1H16(39),ex2(:),G1H8(60),m3h2x8(:,129),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(60),42,0,G2H8(49),n2h8(130))
  call Hloop_AQ_V(ntryL,G2H16(16),ex2(:),G2H8(51),m3h2x8(:,130),heltab2x16(:,:,138))
  call Hloop_QA_V(ntryL,G2H16(17),ex3(:),G2H8(52),m3h2x8(:,131),heltab2x16(:,:,139))
  call Hloop_VA_Q(ntryL,G1H16(10),ex3(:),G1H8(12),m3h2x8(:,132),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(12),38,0,G2H8(53),n2h8(131))
  call Hloop_QA_V(ntryL,G2H16(18),ex3(:),G2H8(55),m3h2x8(:,133),heltab2x16(:,:,141))
  call Hloop_VA_Q(ntryL,G1H16(32),ex3(:),G1H8(17),m3h2x8(:,134),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G1H8(17),44,0,G2H8(56),n2h8(132))
  call Hloop_AQ_V(ntryL,G2H16(19),ex2(:),G2H8(57),m3h2x8(:,135),heltab2x16(:,:,143))
  call Hloop_QA_V(ntryL,G2H16(20),ex4(:),G2H8(59),m3h2x8(:,136),heltab2x16(:,:,144))
  call Hloop_VA_Q(ntryL,G1H16(35),ex4(:),G1H8(48),m3h2x8(:,137),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H8(48),42,0,G2H8(60),n2h8(133))
  call Hloop_QA_V(ntryL,G2H16(21),ex4(:),G2H8(61),m3h2x8(:,138),heltab2x16(:,:,146))
  call Hloop_VA_Q(ntryL,G1H16(37),ex4(:),G1H8(18),m3h2x8(:,139),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(63),n2h8(134))
  call Hloop_AQ_V(ntryL,G2H16(22),wf4(:,12),G2H4(15),m3h4x4(:,9),heltab2x16(:,:,148))
  call Hloop_VQ_A(ntryL,G1H16(47),wf4(:,12),G1H4(38),m3h4x4(:,10),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(38),51,0,G2H4(16),n2h4(127))
  call Hloop_VQ_A(ntryL,G1H16(48),wf4(:,12),G1H4(39),m3h4x4(:,11),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(39),51,0,G2H4(97),n2h4(128))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(24),m3h2x8(:,140),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H8(24),37,0,G2H8(64),n2h8(135))
  call Hloop_AQ_V(ntryL,G2H16(23),ex1(:),G2H8(1),m3h2x8(:,141),heltab2x16(:,:,152))
  call Hloop_VQ_A(ntryL,G1H16(33),ex1(:),G1H8(30),m3h2x8(:,142),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(30),41,0,G2H8(2),n2h8(136))
  call Hloop_AQ_V(ntryL,G2H16(24),ex1(:),G2H8(3),m3h2x8(:,143),heltab2x16(:,:,154))
  call Hloop_QA_V(ntryL,G2H16(25),ex3(:),G2H8(4),m3h2x8(:,144),heltab2x16(:,:,155))
  call Hloop_VA_Q(ntryL,G1H16(12),ex3(:),G1H8(35),m3h2x8(:,145),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(35),37,0,G2H8(5),n2h8(137))
  call Hloop_QA_V(ntryL,G2H16(26),ex3(:),G2H8(6),m3h2x8(:,146),heltab2x16(:,:,157))
  call Hloop_VA_Q(ntryL,G1H16(20),ex3(:),G1H8(41),m3h2x8(:,147),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H8(41),44,0,G2H8(7),n2h8(138))
  call Hloop_AQ_V(ntryL,G2H16(27),ex1(:),G2H8(8),m3h2x8(:,148),heltab2x16(:,:,159))
  call Hloop_QA_V(ntryL,G2H16(28),ex4(:),G2H8(34),m3h2x8(:,149),heltab2x16(:,:,160))
  call Hloop_VA_Q(ntryL,G1H16(9),ex4(:),G1H8(47),m3h2x8(:,150),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(47),41,0,G2H8(38),n2h8(139))
  call Hloop_QA_V(ntryL,G2H16(29),ex4(:),G2H8(42),m3h2x8(:,151),heltab2x16(:,:,162))
  call Hloop_VA_Q(ntryL,G1H16(8),ex4(:),G1H8(59),m3h2x8(:,152),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(59),44,0,G2H8(46),n2h8(140))
  call Hloop_AQ_V(ntryL,G2H16(30),wf4(:,4),G2H4(98),m3h4x4(:,12),heltab2x16(:,:,164))
  call Hloop_VQ_A(ntryL,G1H16(36),wf4(:,4),G1H4(40),m3h4x4(:,13),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(40),51,0,G2H4(99),n2h4(129))
  call Hloop_VQ_A(ntryL,G1H16(40),wf4(:,4),G1H4(44),m3h4x4(:,14),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(44),51,0,G2H4(100),n2h4(130))
  call Hloop_VQ_A(ntryL,G1H16(45),ex1(:),G1H8(65),m3h2x8(:,153),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H8(65),35,0,G2H8(50),n2h8(141))
  call Hloop_AQ_V(ntryL,G2H16(31),ex1(:),G2H8(54),m3h2x8(:,154),heltab2x16(:,:,168))
  call Hloop_VQ_A(ntryL,G1H16(17),ex2(:),G1H8(66),m3h2x8(:,155),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(66),35,0,G2H8(58),n2h8(142))
  call Hloop_VQ_A(ntryL,G1H16(49),ex2(:),G1H8(77),m3h2x8(:,156),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(77),35,0,G2H8(62),n2h8(143))
  call Hloop_AQ_V(ntryL,G2H16(32),ex2(:),G2H8(20),m3h2x8(:,157),heltab2x16(:,:,171))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(78),m3h2x8(:,158),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H8(78),35,0,G2H8(24),n2h8(144))
  call Hloop_VA_Q(ntryL,G1H16(51),ex4(:),G1H8(1),m3h2x8(:,159),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(17),n2h8(145))
  call Hloop_QA_V(ntryL,G2H16(33),ex4(:),G2H8(21),m3h2x8(:,160),heltab2x16(:,:,174))
  call Hloop_QA_V(ntryL,G2H16(34),ex4(:),G2H8(9),m3h2x8(:,161),heltab2x16(:,:,175))
  call Hloop_VA_Q(ntryL,G1H16(52),ex4(:),G1H8(2),m3h2x8(:,162),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H8(2),42,0,G2H8(10),n2h8(146))
  call Hloop_QA_V(ntryL,G2H16(35),ex4(:),G2H8(11),m3h2x8(:,163),heltab2x16(:,:,177))
  call Hloop_VA_Q(ntryL,G1H16(53),wf4(:,19),G1H4(45),m3h4x4(:,15),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(45),54,0,G2H4(101),n2h4(131))
  call Hloop_QA_V(ntryL,G2H16(36),wf4(:,19),G2H4(102),m3h4x4(:,16),heltab2x16(:,:,179))
  call Hloop_QA_V(ntryL,G2H16(37),wf4(:,19),G2H4(103),m3h4x4(:,17),heltab2x16(:,:,180))
  call Hloop_VA_Q(ntryL,G1H16(54),wf4(:,19),G1H4(46),m3h4x4(:,18),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(46),53,0,G2H4(104),n2h4(132))
  call Hloop_QA_V(ntryL,G2H16(38),wf4(:,19),G2H4(105),m3h4x4(:,19),heltab2x16(:,:,182))
  call Hloop_VQ_A(ntryL,G1H16(55),ex1(:),G1H8(3),m3h2x8(:,164),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(3),35,0,G2H8(12),n2h8(147))
  call Hloop_AQ_V(ntryL,G2H16(39),ex1(:),G2H8(13),m3h2x8(:,165),heltab2x16(:,:,184))
  call Hloop_VQ_A(ntryL,G1H16(56),ex2(:),G1H8(4),m3h2x8(:,166),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(4),35,0,G2H8(14),n2h8(148))
  call Hloop_VQ_A(ntryL,G1H16(57),ex2(:),G1H8(5),m3h2x8(:,167),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H8(5),35,0,G2H8(15),n2h8(149))
  call Hloop_AQ_V(ntryL,G2H16(40),ex2(:),G2H8(16),m3h2x8(:,168),heltab2x16(:,:,187))
  call Hloop_VQ_A(ntryL,G1H16(58),ex1(:),G1H8(6),m3h2x8(:,169),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(6),35,0,G2H8(18),n2h8(150))
  call Hloop_VA_Q(ntryL,G1H16(59),ex3(:),G1H8(7),m3h2x8(:,170),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(19),n2h8(151))
  call Hloop_QA_V(ntryL,G2H16(41),ex3(:),G2H8(22),m3h2x8(:,171),heltab2x16(:,:,190))
  call Hloop_QA_V(ntryL,G2H16(42),ex3(:),G2H8(23),m3h2x8(:,172),heltab2x16(:,:,191))
  call Hloop_VA_Q(ntryL,G1H16(60),ex3(:),G1H8(8),m3h2x8(:,173),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(25),n2h8(152))
  call Hloop_QA_V(ntryL,G2H16(43),ex3(:),G2H8(26),m3h2x8(:,174),heltab2x16(:,:,193))
  call Hloop_VA_Q(ntryL,G1H16(61),wf4(:,9),G1H4(50),m3h4x4(:,20),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(50),58,0,G2H4(106),n2h4(133))
  call Hloop_QA_V(ntryL,G2H16(44),wf4(:,9),G2H4(107),m3h4x4(:,21),heltab2x16(:,:,195))
  call Hloop_QA_V(ntryL,G2H16(45),wf4(:,9),G2H4(108),m3h4x4(:,22),heltab2x16(:,:,196))
  call Hloop_VA_Q(ntryL,G1H16(62),wf4(:,9),G1H4(51),m3h4x4(:,23),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(51),57,0,G2H4(109),n2h4(134))
  call Hloop_QA_V(ntryL,G2H16(46),wf4(:,9),G2H4(110),m3h4x4(:,24),heltab2x16(:,:,198))
  call Hloop_AQ_V(ntryL,G1H8(37),ex2(:),G1H4(52),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_AQ_V(ntryL,G1H8(38),ex2(:),G1H4(56),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_QA_V(ntryL,G1H8(40),ex3(:),G1H4(57),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_QA_V(ntryL,G1H8(44),ex4(:),G1H4(58),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AQ_V(ntryL,G1H8(49),ex1(:),G1H4(62),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_AQ_V(ntryL,G1H8(50),ex1(:),G1H4(63),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_QA_V(ntryL,G1H8(52),ex3(:),G1H4(64),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_QA_V(ntryL,G1H8(56),ex4(:),G1H4(68),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_AQ_V(ntryL,G1H8(61),ex1(:),G1H4(69),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_AQ_V(ntryL,G1H8(62),ex2(:),G1H4(70),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_QA_V(ntryL,G1H8(67),ex4(:),G1H4(74),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_QA_V(ntryL,G1H8(68),ex4(:),G1H4(75),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_VA_Q(ntryL,G1H8(69),ex4(:),G1H4(76),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(76),45,0,G2H4(111),n2h4(135))
  call Hloop_AQ_V(ntryL,G1H8(73),ex1(:),G1H4(80),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_AQ_V(ntryL,G1H8(74),ex2(:),G1H4(81),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_VQ_A(ntryL,G1H8(75),ex1(:),G1H4(82),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(82),43,0,G2H4(112),n2h4(136))
  call Hloop_VQ_A(ntryL,G1H8(76),ex2(:),G1H4(86),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(86),43,0,G2H4(113),n2h4(137))
  call Hloop_QA_V(ntryL,G1H8(79),ex3(:),G1H4(87),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_QA_V(ntryL,G1H8(80),ex3(:),G1H4(88),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_VA_Q(ntryL,G1H8(81),ex3(:),G1H4(92),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(92),45,0,G2H4(114),n2h4(138))
  call Hloop_VQ_A(ntryL,G1H8(85),ex2(:),G1H4(93),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(93),39,0,G2H4(115),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),ex4(:),G1H4(94),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_VQ_A(ntryL,G1H8(88),ex2(:),G1H4(98),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(98),39,0,G2H4(116),n2h4(140))
  call Hloop_VQ_A(ntryL,G1H8(91),ex2(:),G1H4(99),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(99),39,0,G2H4(117),n2h4(141))
  call Hloop_VQ_A(ntryL,G1H8(92),ex2(:),G1H4(100),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(100),39,0,G2H4(118),n2h4(142))
  call Hloop_VQ_A(ntryL,G1H8(93),ex1(:),G1H4(104),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(104),39,0,G2H4(119),n2h4(143))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(94),ex4(:),G1H4(105),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_VQ_A(ntryL,G1H8(98),ex1(:),G1H4(106),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(106),39,0,G2H4(120),n2h4(144))
  call Hloop_VQ_A(ntryL,G1H8(99),ex1(:),G1H4(111),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(111),39,0,G2H4(121),n2h4(145))
  call Hloop_VQ_A(ntryL,G1H8(100),ex1(:),G1H4(112),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(112),39,0,G2H4(122),n2h4(146))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(116),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(116),53,0,G2H4(123),n2h4(147))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,0,G2H8(27),n2h8(155))
  call Hloop_QA_V(ntryL,G2H8(27),ex4(:),G2H4(124),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_AV_Q(ntryL,G1H8(10),ex5(:),G1H4(117),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(117),53,0,G2H4(125),n2h4(148))
  call Hloop_AV_Q(ntryL,G1H8(13),ex5(:),G1H4(118),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(118),53,0,G2H4(126),n2h4(149))
  call Hloop_AV_Q(ntryL,G1H8(14),ex5(:),G1H4(123),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(123),53,0,G2H4(127),n2h4(150))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(124),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(124),54,0,G2H4(128),n2h4(151))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-8,0,G2H8(28),n2h8(156))
  call Hloop_QA_V(ntryL,G2H8(28),ex4(:),G2H4(129),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_AV_Q(ntryL,G1H8(20),ex5(:),G1H4(128),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(128),54,0,G2H4(130),n2h4(152))
  call Hloop_AV_Q(ntryL,G1H8(21),ex5(:),G1H4(129),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(129),54,0,G2H4(131),n2h4(153))
  call Hloop_AV_Q(ntryL,G1H8(22),ex5(:),G1H4(130),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(130),54,0,G2H4(132),n2h4(154))
  call Hloop_QV_A(ntryL,G1H16(63),ex5(:),G1H8(64),m3h2x8(:,175),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(64),50,0,G2H8(27),n2h8(157))
call HGT_raise_alpha_OLR(G1H16(25),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(25),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(25),-5,wf4(:,1),5,G2H4(133),m3h4x4(:,25),heltab2x16(:,:,200))
call signflip_OLR(G2H4(133))
  call Hloop_QV_A(ntryL,G1H16(3),ex5(:),G1H8(63),m3h2x8(:,176),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(63),50,0,G2H8(28),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(26),ex5(:),G1H8(36),m3h2x8(:,177),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G1H8(36),50,0,G2H8(65),n2h8(159))
  call Hloop_QV_A(ntryL,G1H16(27),ex5(:),G1H8(42),m3h2x8(:,178),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(42),50,0,G2H8(66),n2h8(160))
  call Hloop_QV_A(ntryL,G1H16(4),ex5(:),G1H8(45),m3h2x8(:,179),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(45),50,0,G2H8(67),n2h8(161))
call HGT_raise_alpha_OLR(G1H16(5),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(5),ex4(:),G1H8(46),m3h2x8(:,180),heltab2x16(:,:,205))
  call Hloop_QV_A(ntryL,G1H16(29),ex5(:),G1H8(51),m3h2x8(:,181),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H8(51),50,0,G2H8(68),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(53),m3h2x8(:,182),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(53),50,0,G2H8(69),n2h8(163))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(54),m3h2x8(:,183),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(54),50,0,G2H8(70),n2h8(164))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,1),G1H4(135),m3h4x4(:,26),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(135),39,0,G2H4(134),n2h4(155))
call HGT_raise_alpha_OLR(G1H16(64),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(64),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(64),ex4(:),G1H8(39),m3h2x8(:,184),heltab2x16(:,:,210))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,1),G1H4(136),m3h4x4(:,27),heltab2x16(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(136),39,0,G2H4(135),n2h4(156))
  call Hloop_QV_A(ntryL,G1H16(67),wf4(:,1),G1H4(140),m3h4x4(:,28),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(140),39,0,G2H4(136),n2h4(157))
  call Hloop_QV_A(ntryL,G1H16(68),wf4(:,1),G1H4(141),m3h4x4(:,29),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(141),39,0,G2H4(137),n2h4(158))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(43),m3h2x8(:,185),heltab2x16(:,:,214))
  call Hloop_Q_A(ntryL,G1H8(43),49,0,G2H8(71),n2h8(165))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(14),-6,wf4(:,11),6,G2H4(138),m3h4x4(:,30),heltab2x16(:,:,215))
call signflip_OLR(G2H4(138))
  call Hloop_QV_A(ntryL,G1H16(31),ex5(:),G1H8(71),m3h2x8(:,186),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H8(71),49,0,G2H8(72),n2h8(166))
  call Hloop_QV_A(ntryL,G1H16(69),ex5(:),G1H8(72),m3h2x8(:,187),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(72),49,0,G2H8(73),n2h8(167))
  call Hloop_QV_A(ntryL,G1H16(70),ex5(:),G1H8(55),m3h2x8(:,188),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H8(55),49,0,G2H8(74),n2h8(168))
  call Hloop_QV_A(ntryL,G1H16(71),ex5(:),G1H8(83),m3h2x8(:,189),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H8(83),49,0,G2H8(75),n2h8(169))
call HGT_raise_alpha_OLR(G1H16(72),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(72),ex4(:),G1H8(84),m3h2x8(:,190),heltab2x16(:,:,220))
  call Hloop_QV_A(ntryL,G1H16(74),ex5(:),G1H8(89),m3h2x8(:,191),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H8(89),49,0,G2H8(76),n2h8(170))
  call Hloop_QV_A(ntryL,G1H16(75),ex5(:),G1H8(90),m3h2x8(:,192),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G1H8(90),49,0,G2H8(77),n2h8(171))
  call Hloop_QV_A(ntryL,G1H16(76),ex5(:),G1H8(95),m3h2x8(:,193),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(95),49,0,G2H8(78),n2h8(172))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,11),G1H4(142),m3h4x4(:,31),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(142),39,0,G2H4(139),n2h4(159))
call HGT_raise_alpha_OLR(G1H16(77),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(77),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(77),ex4(:),G1H8(96),m3h2x8(:,194),heltab2x16(:,:,225))
  call Hloop_QV_A(ntryL,G1H16(79),wf4(:,11),G1H4(147),m3h4x4(:,32),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(147),39,0,G2H4(140),n2h4(160))
  call Hloop_QV_A(ntryL,G1H16(80),wf4(:,11),G1H4(148),m3h4x4(:,33),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(148),39,0,G2H4(141),n2h4(161))
  call Hloop_QV_A(ntryL,G1H16(81),wf4(:,11),G1H4(152),m3h4x4(:,34),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(152),39,0,G2H4(142),n2h4(162))
  call Hloop_QV_A(ntryL,G1H16(21),ex5(:),G1H8(101),m3h2x8(:,195),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(101),50,0,G2H8(79),n2h8(173))
call HGT_raise_alpha_OLR(G1H16(22),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(22),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(22),-9,wf4(:,15),9,G2H4(143),m3h4x4(:,35),heltab2x16(:,:,230))
call signflip_OLR(G2H4(143))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(102),m3h2x8(:,196),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(102),50,0,G2H8(80),n2h8(174))
  call Hloop_QV_A(ntryL,G1H16(34),ex5(:),G1H8(25),m3h2x8(:,197),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(25),50,0,G2H8(81),n2h8(175))
  call Hloop_QV_A(ntryL,G1H16(82),ex5(:),G1H8(26),m3h2x8(:,198),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H8(26),50,0,G2H8(82),n2h8(176))
  call Hloop_QV_A(ntryL,G1H16(83),ex5(:),G1H8(27),m3h2x8(:,199),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H8(27),50,0,G2H8(83),n2h8(177))
call HGT_raise_alpha_OLR(G1H16(84),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(84),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(84),ex3(:),G1H8(28),m3h2x8(:,200),heltab2x16(:,:,235))
  call Hloop_QV_A(ntryL,G1H16(86),ex5(:),G1H8(31),m3h2x8(:,201),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(31),50,0,G2H8(84),n2h8(178))
  call Hloop_QV_A(ntryL,G1H16(87),ex5(:),G1H8(32),m3h2x8(:,202),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H8(32),50,0,G2H8(85),n2h8(179))
  call Hloop_QV_A(ntryL,G1H16(88),ex5(:),G1H8(33),m3h2x8(:,203),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H8(33),50,0,G2H8(86),n2h8(180))
  call Hloop_AV_Q(ntryL,G1H16(89),ex5(:),G1H8(34),m3h2x8(:,204),heltab2x16(:,:,239))
  call Hloop_A_Q(ntryL,G1H8(34),52,0,G2H8(87),n2h8(181))
call HGT_raise_alpha_OLR(G1H16(90),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(90),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(90),-9,wf4(:,15),9,G2H4(144),m3h4x4(:,36),heltab2x16(:,:,240))
call signflip_OLR(G2H4(144))
  call Hloop_AV_Q(ntryL,G1H16(92),ex5(:),G1H8(82),m3h2x8(:,205),heltab2x16(:,:,241))
  call Hloop_A_Q(ntryL,G1H8(82),52,0,G2H8(88),n2h8(182))
  call Hloop_AV_Q(ntryL,G1H16(93),ex5(:),G1H8(70),m3h2x8(:,206),heltab2x16(:,:,242))
  call Hloop_A_Q(ntryL,G1H8(70),52,0,G2H8(89),n2h8(183))
  call Hloop_AV_Q(ntryL,G1H16(94),ex5(:),G1H8(29),m3h2x8(:,207),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H8(29),52,0,G2H8(90),n2h8(184))
  call Hloop_QV_A(ntryL,G1H16(38),wf4(:,15),G1H4(153),m3h4x4(:,37),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(153),43,0,G2H4(145),n2h4(163))
call HGT_raise_alpha_OLR(G1H16(95),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(95),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(95),ex3(:),G1H8(58),m3h2x8(:,208),heltab2x16(:,:,245))
  call Hloop_QV_A(ntryL,G1H16(97),wf4(:,15),G1H4(154),m3h4x4(:,38),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(154),43,0,G2H4(146),n2h4(164))
  call Hloop_QV_A(ntryL,G1H16(98),wf4(:,15),G1H4(159),m3h4x4(:,39),heltab2x16(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(159),43,0,G2H4(147),n2h4(165))
  call Hloop_QV_A(ntryL,G1H16(99),wf4(:,15),G1H4(160),m3h4x4(:,40),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(160),43,0,G2H4(148),n2h4(166))
  call Hloop_QV_A(ntryL,G1H16(41),ex5(:),G1H8(23),m3h2x8(:,209),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G1H8(23),49,0,G2H8(91),n2h8(185))
call HGT_raise_alpha_OLR(G1H16(42),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(42),-10,wf4(:,20),10,G2H4(149),m3h4x4(:,41),heltab2x16(:,:,250))
call signflip_OLR(G2H4(149))
  call Hloop_QV_A(ntryL,G1H16(44),ex5(:),G1H8(57),m3h2x8(:,210),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G1H8(57),49,0,G2H8(92),n2h8(186))
  call Hloop_QV_A(ntryL,G1H16(46),ex5(:),G1H8(11),m3h2x8(:,211),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G1H8(11),49,0,G2H8(93),n2h8(187))
  call Hloop_QV_A(ntryL,G1H16(100),ex5(:),G1H8(60),m3h2x8(:,212),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G1H8(60),49,0,G2H8(94),n2h8(188))
  call Hloop_QV_A(ntryL,G1H16(101),ex5(:),G1H8(12),m3h2x8(:,213),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G1H8(12),49,0,G2H8(95),n2h8(189))
call HGT_raise_alpha_OLR(G1H16(102),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(102),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(102),ex3(:),G1H8(17),m3h2x8(:,214),heltab2x16(:,:,255))
  call Hloop_QV_A(ntryL,G1H16(104),ex5(:),G1H8(48),m3h2x8(:,215),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G1H8(48),49,0,G2H8(96),n2h8(190))
  call Hloop_QV_A(ntryL,G1H16(105),ex5(:),G1H8(18),m3h2x8(:,216),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G1H8(18),49,0,G2H8(97),n2h8(191))
  call Hloop_QV_A(ntryL,G1H16(106),ex5(:),G1H8(24),m3h2x8(:,217),heltab2x16(:,:,258))
  call Hloop_Q_A(ntryL,G1H8(24),49,0,G2H8(98),n2h8(192))
  call Hloop_AV_Q(ntryL,G1H16(107),ex5(:),G1H8(30),m3h2x8(:,218),heltab2x16(:,:,259))
  call Hloop_A_Q(ntryL,G1H8(30),52,0,G2H8(99),n2h8(193))
call HGT_raise_alpha_OLR(G1H16(108),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(108),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(108),-10,wf4(:,20),10,G2H4(150),m3h4x4(:,42),heltab2x16(:,:,260))
call signflip_OLR(G2H4(150))
  call Hloop_AV_Q(ntryL,G1H16(110),ex5(:),G1H8(35),m3h2x8(:,219),heltab2x16(:,:,261))
  call Hloop_A_Q(ntryL,G1H8(35),52,0,G2H8(100),n2h8(194))
  call Hloop_AV_Q(ntryL,G1H16(111),ex5(:),G1H8(41),m3h2x8(:,220),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G1H8(41),52,0,G2H8(101),n2h8(195))
  call Hloop_AV_Q(ntryL,G1H16(112),ex5(:),G1H8(47),m3h2x8(:,221),heltab2x16(:,:,263))
  call Hloop_A_Q(ntryL,G1H8(47),52,0,G2H8(102),n2h8(196))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,20),G1H4(164),m3h4x4(:,43),heltab2x16(:,:,264))
  call Hloop_Q_A(ntryL,G1H4(164),43,0,G2H4(151),n2h4(167))
call HGT_raise_alpha_OLR(G1H16(113),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(113),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(113),ex3(:),G1H8(59),m3h2x8(:,222),heltab2x16(:,:,265))
  call Hloop_QV_A(ntryL,G1H16(115),wf4(:,20),G1H4(165),m3h4x4(:,44),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(165),43,0,G2H4(152),n2h4(168))
  call Hloop_QV_A(ntryL,G1H16(116),wf4(:,20),G1H4(166),m3h4x4(:,45),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(166),43,0,G2H4(153),n2h4(169))
  call Hloop_QV_A(ntryL,G1H16(117),wf4(:,20),G1H4(171),m3h4x4(:,46),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(171),43,0,G2H4(154),n2h4(170))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(18),G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(21),G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(24),G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G2H4(27),G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(105),[G2H4(30),G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G2H4(33),G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(36),G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G2H4(39),G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(11)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(42),G1H4(217),G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G1H4(35)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(81)])
call HGT_lower_alpha_w2_OLR(G2H4(48),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(48),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(48),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(215)])
call HGT_lower_alpha_w2_OLR(G2H4(52),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(52),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(52),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(53)])
call HGT_lower_alpha_w2_OLR(G2H4(56),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(56),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(56),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(203)])
call HGT_lower_alpha_w2_OLR(G2H4(60),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(60),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(60),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(83)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G2H4(64),G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(59)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(139),[G2H4(71),G1H4(241)])
call HGT_lower_alpha_w2_OLR(G2H4(74),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(74),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(74),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G2H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(17)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(78),G1H4(289),G1H4(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(95)])
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G2H4(85),G1H4(265)])
call HGT_lower_alpha_w2_OLR(G2H4(88),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(88),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(88),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(109),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(71)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G2H4(92),G1H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(29)])
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(61),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(67),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(73),G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(79),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(85),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(97),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(91),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(103),G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G1H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G1H4(240),G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(117),[G1H4(246),G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G1H4(228),G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G1H4(234),G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G1H4(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G1H4(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G1H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(153),[G1H4(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G1H4(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G1H4(288)])
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(55),mass5set(:,1),  & 
G1H4(172),G1H4(176),G1H4(177),G1H4(178),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(176),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(56),mass5set(:,1),  & 
G1H4(188),G1H4(189),G1H4(190),G1H4(195),G1H4(196),G1H4(200),4)
  call HG1shiftOLR(G1H4(189),8,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(57),mass5set(:,1),  & 
G1H4(201),G1H4(202),G1H4(207),G1H4(208),G1H4(212),G1H4(213),4)
  call HG1shiftOLR(G1H4(202),8,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(58),mass5set(:,1),  & 
G1H4(214),G1H4(219),G1H4(220),G1H4(224),G1H4(225),G1H4(226),4)
  call HG1shiftOLR(G1H4(219),4,4)
  call Hotf_5pt_reduction(G2H4(105),RedSet_5(59),mass5set(:,1),  & 
G1H4(231),G1H4(232),G1H4(236),G1H4(237),G1H4(238),G1H4(243),4)
  call HG1shiftOLR(G1H4(232),8,4)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(60),mass5set(:,1),  & 
G1H4(244),G1H4(248),G1H4(249),G1H4(250),G1H4(255),G1H4(256),4)
  call HG1shiftOLR(G1H4(248),4,4)
  call Hotf_5pt_reduction(G2H4(108),RedSet_5(61),mass5set(:,1),  & 
G1H4(260),G1H4(261),G1H4(262),G1H4(267),G1H4(268),G1H4(272),4)
  call HG1shiftOLR(G1H4(261),2,4)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(62),mass5set(:,1),  & 
G1H4(273),G1H4(274),G1H4(279),G1H4(280),G1H4(284),G1H4(285),4)
  call HG1shiftOLR(G1H4(274),2,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex2(:),G1H2(33),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(33),47,0,G2H2(1),n2h2(81))
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(63),mass5set(:,1),  & 
G1H4(286),G1H4(291),G1H4(292),G1H4(296),G1H4(110),G1H4(122),4)
  call HG1shiftOLR(G1H4(291),8,4)
  call Hloop_VQ_A(ntryL,G1H4(2),ex1(:),G1H2(34),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(34),47,0,G2H2(3),n2h2(82))
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(64),mass5set(:,1),  & 
G1H4(134),G1H4(146),G1H4(158),G1H4(170),G1H4(182),G1H4(194),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hloop_QA_V(ntryL,G2H4(97),ex3(:),G2H2(5),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(65),mass5set(:,1),  & 
G1H4(206),G1H4(218),G1H4(230),G1H4(242),G1H4(254),G1H4(266),4)
  call HG1shiftOLR(G1H4(218),8,4)
  call Hloop_QA_V(ntryL,G2H4(16),ex4(:),G2H2(7),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(66),mass5set(:,1),  & 
G1H4(278),G1H4(290),G1H4(9),G1H4(10),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(290),4,4)
  call Hloop_QA_V(ntryL,G2H4(100),ex3(:),G2H2(9),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(67),mass5set(:,1),  & 
G1H4(16),G1H4(20),G1H4(21),G1H4(22),G1H4(26),G1H4(27),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_QA_V(ntryL,G2H4(99),ex4(:),G2H2(11),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(39),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(39),47,0,G2H2(13),n2h2(83))
  call Hotf_5pt_reduction(G2H4(134),RedSet_5(51),mass5set(:,1),  & 
G1H4(28),G1H4(32),G1H4(33),G1H4(34),G1H4(38),G1H4(39),4)
  call HG1shiftOLR(G1H4(32),8,4)
call HGT_lower_alpha_w2_OLR(G2H4(67),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(67),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(67),6,15,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(68),mass5set(:,1),  & 
G1H4(40),G1H4(44),G1H4(45),G1H4(46),G1H4(50),G1H4(51),4)
  call HG1shiftOLR(G1H4(44),1,4)
  call Hloop_AQ_V(ntryL,G2H4(106),ex1(:),G2H2(15),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_VQ_A(ntryL,G1H4(4),ex2(:),G1H2(40),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(40),47,0,G2H2(17),n2h2(84))
  call Hotf_5pt_reduction(G2H4(139),RedSet_5(52),mass5set(:,1),  & 
G1H4(76),G1H4(82),G1H4(86),G1H4(92),G1H4(93),G1H4(98),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(69),mass5set(:,1),  & 
G1H4(99),G1H4(100),G1H4(104),G1H4(106),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(100),2,4)
  call Hloop_AQ_V(ntryL,G2H4(104),ex2(:),G2H2(20),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_VA_Q(ntryL,G1H4(5),ex4(:),G1H2(45),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(45),47,0,G2H2(23),n2h2(85))
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(70),mass5set(:,1),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(123),G1H4(124),G1H4(128),4)
  call HG1shiftOLR(G1H4(117),2,4)
call HGT_lower_alpha_w2_OLR(G2H4(81),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(81),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(81),6,15,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(71),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(135),G1H4(136),G1H4(140),G1H4(141),4)
  call HG1shiftOLR(G1H4(130),1,4)
  call Hloop_AQ_V(ntryL,G2H4(101),ex1(:),G2H2(26),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(46),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(46),47,0,G2H2(29),n2h2(86))
  call Hotf_5pt_reduction(G2H4(145),RedSet_5(53),mass5set(:,1),  & 
G1H4(142),G1H4(147),G1H4(148),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(147),4,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(72),mass5set(:,1),  & 
G1H4(159),G1H4(160),G1H4(164),G1H4(165),G1H4(166),G1H4(171),4)
  call HG1shiftOLR(G1H4(160),2,4)
  call Hloop_AQ_V(ntryL,G2H4(109),ex2(:),G2H2(32),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_VQ_A(ntryL,G1H4(7),ex2(:),G1H2(51),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(51),47,0,G2H2(35),n2h2(87))
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(54),mass5set(:,1),  & 
G1H4(109),G1H4(121),G1H4(133),G1H4(145),G1H4(157),G1H4(169),4)
  call HG1shiftOLR(G1H4(121),4,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex3(:),G1H2(52),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(52),47,0,G2H2(38),n2h2(88))
  call Hloop_VQ_A(ntryL,G1H4(24),ex2(:),G1H2(57),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(57),47,0,G2H2(41),n2h2(89))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(73),mass5set(:,1),  & 
G1H4(181),G1H4(193),G1H4(11),G1H4(80),G1H4(217),G1H4(205),4)
  call HG1shiftOLR(G1H4(193),16,4)
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(58),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(58),47,0,G2H2(44),n2h2(90))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(74),mass5set(:,1),  & 
G1H4(35),G1H4(81),G1H4(215),G1H4(203),G1H4(83),G1H4(87),4)
  call HG1shiftOLR(G1H4(81),16,4)
  call Hloop_VQ_A(ntryL,G1H4(69),ex2(:),G1H2(63),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(63),47,0,G2H2(47),n2h2(91))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(75),mass5set(:,1),  & 
G1H4(229),G1H4(59),G1H4(88),G1H4(241),G1H4(17),G1H4(64),4)
  call HG1shiftOLR(G1H4(59),16,4)
  call Hloop_VA_Q(ntryL,G1H4(54),ex3(:),G1H2(64),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(64),47,0,G2H2(50),n2h2(92))
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(76),mass5set(:,1),  & 
G1H4(289),G1H4(253),G1H4(95),G1H4(74),G1H4(265),G1H4(71),4)
  call HG1shiftOLR(G1H4(253),16,4)
  call Hloop_VQ_A(ntryL,G1H4(42),ex1(:),G1H2(69),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(69),47,0,G2H2(53),n2h2(93))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(77),mass5set(:,1),  & 
G1H4(75),G1H4(277),G1H4(29),G1H4(68),G1H4(12),G1H4(61),4)
  call HG1shiftOLR(G1H4(277),16,4)
  call Hloop_VQ_A(ntryL,G1H4(70),ex1(:),G1H2(70),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(70),47,0,G2H2(56),n2h2(94))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(78),mass5set(:,1),  & 
G1H4(13),G1H4(18),G1H4(67),G1H4(19),G1H4(23),G1H4(73),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hloop_VA_Q(ntryL,G1H4(57),ex4(:),G1H2(75),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(75),47,0,G2H2(59),n2h2(95))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(79),mass5set(:,1),  & 
G1H4(25),G1H4(30),G1H4(79),G1H4(31),G1H4(36),G1H4(85),4)
  call HG1shiftOLR(G1H4(30),16,4)
  call Hloop_VA_Q(ntryL,G1H4(58),ex3(:),G1H2(76),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(76),47,0,G2H2(62),n2h2(96))
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(80),mass5set(:,1),  & 
G1H4(37),G1H4(41),G1H4(97),G1H4(43),G1H4(47),G1H4(91),4)
  call HG1shiftOLR(G1H4(41),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(81),mass5set(:,1),  & 
G1H4(49),G1H4(53),G1H4(103),G1H4(55),G1H4(60),G1H4(65),4)
  call HG1shiftOLR(G1H4(53),16,4)
  call Hloop_VA_Q(ntryL,G1H4(63),ex4(:),G1H2(81),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(81),47,0,G2H2(65),n2h2(97))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(82),mass5set(:,1),  & 
G1H4(66),G1H4(72),G1H4(77),G1H4(78),G1H4(84),G1H4(89),4)
  call HG1shiftOLR(G1H4(72),16,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(83),mass5set(:,1),  & 
G1H4(90),G1H4(96),G1H4(101),G1H4(102),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(96),16,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex3(:),G1H2(82),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(82),47,0,G2H2(68),n2h2(98))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(84),mass5set(:,1),  & 
G1H4(119),G1H4(120),G1H4(131),G1H4(132),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(120),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(85),mass5set(:,1),  & 
G1H4(155),G1H4(156),G1H4(167),G1H4(168),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(156),16,4)
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(87),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(87),47,0,G2H2(71),n2h2(99))
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(86),mass5set(:,1),  & 
G1H4(191),G1H4(192),G1H4(240),G1H4(204),G1H4(246),G1H4(210),4)
  call HG1shiftOLR(G1H4(192),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(87),mass5set(:,1),  & 
G1H4(211),G1H4(228),G1H4(216),G1H4(234),G1H4(222),G1H4(227),4)
  call HG1shiftOLR(G1H4(228),16,4)
  call Hloop_VA_Q(ntryL,G1H4(52),ex3(:),G1H2(88),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(88),47,0,G2H2(74),n2h2(100))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(88),mass5set(:,1),  & 
G1H4(235),G1H4(239),G1H4(247),G1H4(251),G1H4(252),G1H4(259),4)
  call HG1shiftOLR(G1H4(239),16,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(89),mass5set(:,1),  & 
G1H4(263),G1H4(264),G1H4(271),G1H4(275),G1H4(276),G1H4(283),4)
  call HG1shiftOLR(G1H4(264),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(90),mass5set(:,1),  & 
G1H4(287),G1H4(288),G1H4(1),G1H4(2),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(288),8,4)
  call Hloop_VQ_A(ntryL,G1H4(113),ex1(:),G1H2(93),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(93),55,0,G2H2(77),n2h2(101))
  call Hloop_VQ_A(ntryL,G1H4(114),ex1(:),G1H2(94),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(80),n2h2(102))
  call Hloop_VQ_A(ntryL,G1H4(115),ex1(:),G1H2(99),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(99),55,0,G2H2(83),n2h2(103))
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(91),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(24),G1H4(48),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(92),mass5set(:,1),  & 
G1H4(69),G1H4(54),G1H4(42),G1H4(70),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hloop_VQ_A(ntryL,G1H4(125),ex2(:),G1H2(100),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(100),55,0,G2H2(86),n2h2(104))
  call Hloop_VQ_A(ntryL,G1H4(126),ex2(:),G1H2(105),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(105),55,0,G2H2(89),n2h2(105))
  call Hloop_VQ_A(ntryL,G1H4(127),ex2(:),G1H2(106),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(106),55,0,G2H2(92),n2h2(106))
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(93),mass5set(:,1),  & 
G1H4(63),G1H4(62),G1H4(56),G1H4(52),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(94),mass5set(:,1),  & 
G1H4(115),G1H4(125),G1H4(126),G1H4(127),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(125),8,4)
  call Hloop_VQ_A(ntryL,G1H4(137),ex1(:),G1H2(111),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(111),55,0,G2H2(95),n2h2(107))
  call Hloop_VQ_A(ntryL,G1H4(138),ex1(:),G1H2(112),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(112),55,0,G2H2(98),n2h2(108))
  call Hloop_VQ_A(ntryL,G1H4(139),ex1(:),G1H2(117),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(117),55,0,G2H2(101),n2h2(109))
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(95),mass5set(:,1),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(299),G1H4(300),G1H4(301),4)
  call HG1shiftOLR(G1H4(138),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(96),mass5set(:,1),  & 
G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),G1H4(307),4)
  call HG1shiftOLR(G1H4(303),4,4)
  call Hloop_VQ_A(ntryL,G1H4(149),ex1(:),G1H2(118),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(118),59,0,G2H2(104),n2h2(110))
  call Hloop_VQ_A(ntryL,G1H4(150),ex1(:),G1H2(123),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(123),59,0,G2H2(107),n2h2(111))
  call Hloop_VQ_A(ntryL,G1H4(151),ex1(:),G1H2(124),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(124),59,0,G2H2(110),n2h2(112))
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(97),mass5set(:,1),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(150),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(98),mass5set(:,1),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),8,4)
  call Hloop_VQ_A(ntryL,G1H4(161),ex2(:),G1H2(129),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(129),55,0,G2H2(113),n2h2(113))
  call Hloop_VQ_A(ntryL,G1H4(162),ex2(:),G1H2(130),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(130),55,0,G2H2(114),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(163),ex2(:),G1H2(135),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(135),55,0,G2H2(115),n2h2(115))
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(99),mass5set(:,1),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(317),G1H4(318),G1H4(319),4)
  call HG1shiftOLR(G1H4(162),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(100),mass5set(:,1),  & 
G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),G1H4(325),4)
  call HG1shiftOLR(G1H4(321),4,4)
  call Hloop_VQ_A(ntryL,G1H4(173),ex2(:),G1H2(136),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(136),59,0,G2H2(116),n2h2(116))
  call Hloop_VQ_A(ntryL,G1H4(174),ex2(:),G1H2(141),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(141),59,0,G2H2(117),n2h2(117))
  call Hloop_VQ_A(ntryL,G1H4(175),ex2(:),G1H2(142),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(142),59,0,G2H2(118),n2h2(118))
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(101),mass5set(:,1),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(326),G1H4(327),G1H4(328),4)
  call HG1shiftOLR(G1H4(174),2,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(102),mass5set(:,1),  & 
G1H4(329),G1H4(330),G1H4(331),G1H4(332),G1H4(333),G1H4(334),4)
  call HG1shiftOLR(G1H4(330),2,4)
  call Hloop_VA_Q(ntryL,G1H4(185),ex3(:),G1H2(147),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(147),61,0,G2H2(119),n2h2(119))
  call Hloop_VA_Q(ntryL,G1H4(186),ex3(:),G1H2(148),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(148),61,0,G2H2(120),n2h2(120))
  call Hloop_VA_Q(ntryL,G1H4(187),ex3(:),G1H2(153),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(121),n2h2(121))
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(103),mass5set(:,1),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(335),G1H4(336),G1H4(337),4)
  call HG1shiftOLR(G1H4(186),2,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(104),mass5set(:,1),  & 
G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),G1H4(343),4)
  call HG1shiftOLR(G1H4(339),2,4)
  call Hloop_VA_Q(ntryL,G1H4(197),ex4(:),G1H2(154),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(154),61,0,G2H2(122),n2h2(122))
  call Hloop_VA_Q(ntryL,G1H4(198),ex4(:),G1H2(159),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(159),61,0,G2H2(123),n2h2(123))
  call Hloop_VA_Q(ntryL,G1H4(199),ex4(:),G1H2(160),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(160),61,0,G2H2(124),n2h2(124))
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(47),mass5set(:,1),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(344),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(198),8,4)
  call Hloop_QV_A(ntryL,G1H4(209),ex5(:),G1H2(165),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(165),55,0,G2H2(125),n2h2(125))
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(104),mass4set(:,1),  & 
G1H4(209),G1H4(347),G1H4(348),G1H4(349),G1H4(350),4)
  call HG1shiftOLR(G1H4(347),8,4)
  call Hloop_QV_A(ntryL,G1H4(223),ex5(:),G1H2(166),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(166),55,0,G2H2(126),n2h2(126))
  call Hotf_5pt_reduction(G2H4(119),RedSet_5(48),mass5set(:,1),  & 
G1H4(223),G1H4(351),G1H4(352),G1H4(353),G1H4(354),G1H4(355),4)
  call HG1shiftOLR(G1H4(351),8,4)
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(171),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(171),55,0,G2H2(127),n2h2(127))
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(116),mass4set(:,1),  & 
G1H4(221),G1H4(356),G1H4(357),G1H4(358),G1H4(359),4)
  call HG1shiftOLR(G1H4(356),8,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(105),mass5set(:,1),  & 
G1H4(360),G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),4)
  call HG1shiftOLR(G1H4(361),8,4)
  call Hloop_QV_A(ntryL,G1H4(233),ex5(:),G1H2(172),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(172),55,0,G2H2(128),n2h2(128))
  call Hotf_4pt_reduction(G2H4(136),RedSet_4(34),mass4set(:,1),  & 
G1H4(233),G1H4(366),G1H4(367),G1H4(368),G1H4(369),4)
  call HG1shiftOLR(G1H4(366),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(106),mass5set(:,1),  & 
G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),G1H4(375),4)
  call HG1shiftOLR(G1H4(371),8,4)
  call Hloop_QV_A(ntryL,G1H4(245),ex5(:),G1H2(33),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(129),n2h2(129))
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(62),mass4set(:,1),  & 
G1H4(245),G1H4(376),G1H4(377),G1H4(378),G1H4(379),4)
  call HG1shiftOLR(G1H4(376),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(107),mass5set(:,1),  & 
G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),G1H4(385),4)
  call HG1shiftOLR(G1H4(381),2,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(108),mass5set(:,1),  & 
G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),G1H4(391),4)
  call HG1shiftOLR(G1H4(387),2,4)
  call Hloop_AV_Q(ntryL,G1H4(257),ex5(:),G1H2(34),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(34),61,0,G2H2(130),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H4(258),ex5(:),G1H2(39),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(39),61,0,G2H2(131),n2h2(131))
  call Hloop_AV_Q(ntryL,G1H4(295),ex5(:),G1H2(40),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(40),61,0,G2H2(132),n2h2(132))
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(109),mass5set(:,1),  & 
G1H4(257),G1H4(258),G1H4(295),G1H4(392),G1H4(393),G1H4(394),4)
  call HG1shiftOLR(G1H4(258),4,4)
  call Hotf_5pt_reduction(G2H4(69),RedSet_5(110),mass5set(:,1),  & 
G1H4(395),G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),4)
  call HG1shiftOLR(G1H4(396),4,4)
  call Hloop_QV_A(ntryL,G1H4(269),ex5(:),G1H2(45),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(45),59,0,G2H2(133),n2h2(133))
  call Hloop_QV_A(ntryL,G1H4(270),ex5(:),G1H2(46),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(46),59,0,G2H2(134),n2h2(134))
  call Hotf_4pt_reduction(G2H4(147),RedSet_4(49),mass4set(:,1),  & 
G1H4(269),G1H4(270),G1H4(401),G1H4(402),G1H4(403),4)
  call HG1shiftOLR(G1H4(270),4,4)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(111),mass5set(:,1),  & 
G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),G1H4(409),4)
  call HG1shiftOLR(G1H4(405),4,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(112),mass5set(:,1),  & 
G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),G1H4(415),4)
  call HG1shiftOLR(G1H4(411),4,4)
  call Hloop_QV_A(ntryL,G1H4(281),ex5(:),G1H2(51),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(51),59,0,G2H2(135),n2h2(135))
  call Hloop_QV_A(ntryL,G1H4(282),ex5(:),G1H2(52),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(52),59,0,G2H2(136),n2h2(136))
  call Hotf_4pt_reduction(G2H4(153),RedSet_4(77),mass4set(:,1),  & 
G1H4(281),G1H4(282),G1H4(416),G1H4(417),G1H4(418),4)
  call HG1shiftOLR(G1H4(282),4,4)
  call Hotf_5pt_reduction(G2H4(77),RedSet_5(113),mass5set(:,1),  & 
G1H4(419),G1H4(420),G1H4(421),G1H4(422),G1H4(423),G1H4(424),4)
  call HG1shiftOLR(G1H4(420),2,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(114),mass5set(:,1),  & 
G1H4(425),G1H4(426),G1H4(427),G1H4(428),G1H4(429),G1H4(430),4)
  call HG1shiftOLR(G1H4(426),2,4)
  call Hloop_AV_Q(ntryL,G1H4(293),ex5(:),G1H2(57),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(57),61,0,G2H2(137),n2h2(137))
  call Hloop_AV_Q(ntryL,G1H4(294),ex5(:),G1H2(58),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(58),61,0,G2H2(138),n2h2(138))
  call Hloop_AQ_V(ntryL,G2H4(17),ex2(:),G2H2(139),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_AQ_V(ntryL,G2H4(20),ex1(:),G2H2(140),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_QA_V(ntryL,G2H4(23),ex3(:),G2H2(141),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_QA_V(ntryL,G2H4(26),ex4(:),G2H2(142),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QA_V(ntryL,G2H4(29),ex3(:),G2H2(143),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_QA_V(ntryL,G2H4(32),ex4(:),G2H2(144),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_QA_V(ntryL,G2H4(35),ex4(:),G2H2(145),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_QA_V(ntryL,G2H4(38),ex3(:),G2H2(146),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_QA_V(ntryL,G2H4(44),ex3(:),G2H2(147),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_QA_V(ntryL,G2H4(46),ex4(:),G2H2(148),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_QA_V(ntryL,G2H4(47),ex3(:),G2H2(149),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_QA_V(ntryL,G2H4(50),ex4(:),G2H2(150),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_AQ_V(ntryL,G2H4(54),ex1(:),G2H2(151),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_AQ_V(ntryL,G2H4(55),ex1(:),G2H2(152),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_AQ_V(ntryL,G2H4(59),ex2(:),G2H2(153),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_AQ_V(ntryL,G2H4(65),ex1(:),G2H2(154),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_AQ_V(ntryL,G2H4(70),ex2(:),G2H2(155),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_AQ_V(ntryL,G2H4(72),ex2(:),G2H2(156),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(12),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(77),G1H8(78),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(66),5,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(115),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(116),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(40),G1H8(44),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(18),mass5set(:,1),  & 
G1H8(52),G1H8(56),G1H8(61),G1H8(62),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(56),6,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(117),mass5set(:,1),  & 
G1H8(69),G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(79),8)
  call HG1shiftOLR(G1H8(73),16,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(118),mass5set(:,1),  & 
G1H8(80),G1H8(81),G1H8(85),G1H8(86),G1H8(88),G1H8(91),8)
  call HG1shiftOLR(G1H8(81),16,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(119),mass5set(:,1),  & 
G1H8(92),G1H8(93),G1H8(94),G1H8(98),G1H8(99),G1H8(100),8)
  call HG1shiftOLR(G1H8(93),9,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(16),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(10),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(104),9,8)
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(120),mass5set(:,1),  & 
G1H8(16),G1H8(20),G1H8(21),G1H8(22),G1H8(64),G1H8(63),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(121),mass5set(:,1),  & 
G1H8(36),G1H8(42),G1H8(45),G1H8(51),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(42),16,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(122),mass5set(:,1),  & 
G1H8(43),G1H8(71),G1H8(72),G1H8(55),G1H8(83),G1H8(89),8)
  call HG1shiftOLR(G1H8(71),10,8)
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(14),mass5set(:,1),  & 
G1H8(90),G1H8(95),G1H8(101),G1H8(102),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(95),10,8)
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(123),mass5set(:,1),  & 
G1H8(27),G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(82),8)
  call HG1shiftOLR(G1H8(31),16,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(124),mass5set(:,1),  & 
G1H8(70),G1H8(29),G1H8(23),G1H8(57),G1H8(11),G1H8(60),8)
  call HG1shiftOLR(G1H8(29),16,8)
  call Hloop_QA_V(ntryL,G2H8(47),ex4(:),G2H4(18),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(32),mass5set(:,1),  & 
G1H8(12),G1H8(48),G1H8(18),G1H8(24),G1H8(30),G1H8(35),8)
  call HG1shiftOLR(G1H8(48),17,8)
  call Hloop_QA_V(ntryL,G2H8(49),ex3(:),G2H4(21),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(31),mass5set(:,1),  & 
G1H8(41),G1H8(47),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(47),17,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(125),mass5set(:,1),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),17,8)
  call Hloop_AQ_V(ntryL,G2H8(53),wf4(:,12),G2H2(157),m3h4x2(:,1),heltab2x8(:,:,201))
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(41),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),8,8)
  call Hloop_AQ_V(ntryL,G2H8(56),ex2(:),G2H4(24),m3h2x4(:,201),heltab2x8(:,:,202))
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(40),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(126),mass5set(:,1),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),17,8)
  call Hloop_AQ_V(ntryL,G2H8(60),wf4(:,12),G2H2(158),m3h4x2(:,2),heltab2x8(:,:,203))
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(44),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),4,8)
  call Hloop_AQ_V(ntryL,G2H8(63),ex2(:),G2H4(27),m3h2x4(:,202),heltab2x8(:,:,204))
  call Hloop_QA_V(ntryL,G2H8(64),ex4(:),G2H4(30),m3h2x4(:,203),heltab2x8(:,:,205))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(30),mass5set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),18,8)
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(33),m3h2x4(:,204),heltab2x8(:,:,206))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(29),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),18,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(15),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),18,8)
  call Hloop_AQ_V(ntryL,G2H8(5),wf4(:,4),G2H2(159),m3h4x2(:,3),heltab2x8(:,:,207))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(42),mass5set(:,1),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(36),m3h2x4(:,205),heltab2x8(:,:,208))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(39),mass5set(:,1),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),8,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(20),mass5set(:,1),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),18,8)
  call Hloop_AQ_V(ntryL,G2H8(38),wf4(:,4),G2H2(160),m3h4x2(:,4),heltab2x8(:,:,209))
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(45),mass5set(:,1),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),4,8)
  call Hloop_AQ_V(ntryL,G2H8(46),ex1(:),G2H4(39),m3h2x4(:,206),heltab2x8(:,:,210))
  call Hloop_QA_V(ntryL,G2H8(50),ex4(:),G2H4(42),m3h2x4(:,207),heltab2x8(:,:,211))
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(127),mass5set(:,1),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),20,8)
  call Hloop_QA_V(ntryL,G2H8(58),ex4(:),G2H4(112),m3h2x4(:,208),heltab2x8(:,:,212))
  call Hloop_QA_V(ntryL,G2H8(62),wf4(:,19),G2H2(161),m3h4x2(:,5),heltab2x8(:,:,213))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(128),mass5set(:,1),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),20,8)
  call Hloop_QA_V(ntryL,G2H8(24),wf4(:,19),G2H2(162),m3h4x2(:,6),heltab2x8(:,:,214))
  call Hloop_AQ_V(ntryL,G2H8(17),ex2(:),G2H4(49),m3h2x4(:,209),heltab2x8(:,:,215))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(19),mass5set(:,1),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),20,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(46),mass5set(:,1),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),2,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(43),m3h2x4(:,210),heltab2x8(:,:,216))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(17),mass5set(:,1),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),20,8)
  call Hloop_QA_V(ntryL,G2H8(12),ex3(:),G2H4(53),m3h2x4(:,211),heltab2x8(:,:,217))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(7),mass5set(:,1),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),24,8)
  call Hloop_QA_V(ntryL,G2H8(14),ex3(:),G2H4(113),m3h2x4(:,212),heltab2x8(:,:,218))
  call Hloop_QA_V(ntryL,G2H8(15),wf4(:,9),G2H2(163),m3h4x2(:,7),heltab2x8(:,:,219))
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(8),mass5set(:,1),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),24,8)
  call Hloop_QA_V(ntryL,G2H8(18),wf4(:,9),G2H2(164),m3h4x2(:,8),heltab2x8(:,:,220))
  call Hloop_AQ_V(ntryL,G2H8(19),ex2(:),G2H4(57),m3h2x4(:,213),heltab2x8(:,:,221))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(13),mass5set(:,1),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),24,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(43),mass5set(:,1),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),2,8)
  call Hloop_AQ_V(ntryL,G2H8(25),ex1(:),G2H4(41),m3h2x4(:,214),heltab2x8(:,:,222))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(11),mass5set(:,1),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),24,8)
  call Hotf_4pt_reduction(G2H4(118),RedSet_4(105),mass4set(:,1),  & 
G1H4(293),G1H4(294),G1H4(431),G1H4(432),G1H4(433),4)
  call HG1shiftOLR(G1H4(294),24,4)
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(117),mass4set(:,1),  & 
G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(435),24,4)
  call Hloop_AQ_V(ntryL,G2H4(123),ex2(:),G2H2(165),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_AQ_V(ntryL,G2H4(126),ex2(:),G2H2(166),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_AQ_V(ntryL,G2H4(127),ex2(:),G2H2(167),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_AQ_V(ntryL,G2H4(128),ex1(:),G2H2(168),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AQ_V(ntryL,G2H4(131),ex1(:),G2H2(169),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_AQ_V(ntryL,G2H4(132),ex1(:),G2H2(170),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_QA_V(ntryL,G2H8(27),ex4(:),G2H4(61),m3h2x4(:,215),heltab2x8(:,:,223))
  call Hloop_QA_V(ntryL,G2H8(65),ex4(:),G2H4(64),m3h2x4(:,216),heltab2x8(:,:,224))
  call Hloop_QA_V(ntryL,G2H8(66),ex4(:),G2H4(68),m3h2x4(:,217),heltab2x8(:,:,225))
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(34),mass5set(:,1),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_4pt_reduction(G2H8(69),RedSet_4(34),mass4set(:,1),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hotf_4pt_reduction(G2H8(70),RedSet_4(37),mass4set(:,1),  & 
G1H8(252),G1H8(253),G1H8(254),G1H8(255),G1H8(256),8)
  call HG1shiftOLR(G1H8(253),13,8)
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(126),mass4set(:,1),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),4)
  call HG1shiftOLR(G1H4(440),24,4)
  call Hloop_QA_V(ntryL,G2H8(71),ex4(:),G2H4(71),m3h2x4(:,218),heltab2x8(:,:,226))
  call Hloop_QA_V(ntryL,G2H8(73),ex4(:),G2H4(114),m3h2x4(:,219),heltab2x8(:,:,227))
  call Hloop_QA_V(ntryL,G2H8(74),ex4(:),G2H4(75),m3h2x4(:,220),heltab2x8(:,:,228))
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(36),mass5set(:,1),  & 
G1H8(257),G1H8(258),G1H8(259),G1H8(260),G1H8(261),G1H8(262),8)
  call HG1shiftOLR(G1H8(258),8,8)
  call Hotf_4pt_reduction(G2H8(77),RedSet_4(62),mass4set(:,1),  & 
G1H8(263),G1H8(264),G1H8(265),G1H8(266),G1H8(267),8)
  call HG1shiftOLR(G1H8(264),8,8)
  call Hotf_4pt_reduction(G2H8(78),RedSet_4(65),mass4set(:,1),  & 
G1H8(268),G1H8(269),G1H8(270),G1H8(271),G1H8(272),8)
  call HG1shiftOLR(G1H8(269),14,8)
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(135),mass4set(:,1),  & 
G1H4(444),G1H4(445),G1H4(446),G1H4(447),G1H4(448),4)
  call HG1shiftOLR(G1H4(445),24,4)
  call Hloop_QA_V(ntryL,G2H8(79),ex3(:),G2H4(78),m3h2x4(:,221),heltab2x8(:,:,229))
  call Hloop_QA_V(ntryL,G2H8(81),ex3(:),G2H4(82),m3h2x4(:,222),heltab2x8(:,:,230))
  call Hloop_QA_V(ntryL,G2H8(82),ex3(:),G2H4(85),m3h2x4(:,223),heltab2x8(:,:,231))
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(35),mass5set(:,1),  & 
G1H8(273),G1H8(274),G1H8(275),G1H8(276),G1H8(277),G1H8(278),8)
  call HG1shiftOLR(G1H8(274),4,8)
  call Hotf_4pt_reduction(G2H8(85),RedSet_4(49),mass4set(:,1),  & 
G1H8(279),G1H8(280),G1H8(281),G1H8(282),G1H8(283),8)
  call HG1shiftOLR(G1H8(280),4,8)
  call Hotf_4pt_reduction(G2H8(86),RedSet_4(37),mass4set(:,1),  & 
G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(285),13,8)
  call Hloop_AQ_V(ntryL,G2H8(87),ex2(:),G2H4(111),m3h2x4(:,224),heltab2x8(:,:,232))
  call Hloop_AQ_V(ntryL,G2H8(89),ex2(:),G2H4(89),m3h2x4(:,225),heltab2x8(:,:,233))
  call Hloop_AQ_V(ntryL,G2H8(90),ex2(:),G2H4(92),m3h2x4(:,226),heltab2x8(:,:,234))
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(162),mass4set(:,1),  & 
G1H4(449),G1H4(450),G1H4(451),G1H4(452),G1H4(453),4)
  call HG1shiftOLR(G1H4(450),20,4)
  call Hloop_QA_V(ntryL,G2H8(91),ex3(:),G2H4(98),m3h2x4(:,227),heltab2x8(:,:,235))
  call Hloop_QA_V(ntryL,G2H8(93),ex3(:),G2H4(15),m3h2x4(:,228),heltab2x8(:,:,236))
  call Hloop_QA_V(ntryL,G2H8(94),ex3(:),G2H4(102),m3h2x4(:,229),heltab2x8(:,:,237))
  call Hotf_5pt_reduction(G2H8(95),RedSet_5(37),mass5set(:,1),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),4,8)
  call Hotf_4pt_reduction(G2H8(97),RedSet_4(77),mass4set(:,1),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),8)
  call HG1shiftOLR(G1H8(296),4,8)
  call Hotf_4pt_reduction(G2H8(98),RedSet_4(65),mass4set(:,1),  & 
G1H8(300),G1H8(301),G1H8(302),G1H8(303),G1H8(304),8)
  call HG1shiftOLR(G1H8(301),14,8)
  call Hloop_AQ_V(ntryL,G2H8(99),ex1(:),G2H4(107),m3h2x4(:,230),heltab2x8(:,:,238))
  call Hloop_AQ_V(ntryL,G2H8(101),ex1(:),G2H4(105),m3h2x4(:,231),heltab2x8(:,:,239))
  call Hloop_AQ_V(ntryL,G2H8(102),ex1(:),G2H4(110),m3h2x4(:,232),heltab2x8(:,:,240))
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(175),mass4set(:,1),  & 
G1H4(454),G1H4(455),G1H4(456),G1H4(457),G1H4(458),4)
  call HG1shiftOLR(G1H4(455),20,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(439),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(444),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(269),[G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(449),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(281),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(454),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(209),[G1H4(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(293),[G1H4(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(221),[G1H4(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(434),[G1H4(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(252),[G1H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(263),[G1H8(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(268),[G1H8(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(279),[G1H8(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(284),[G1H8(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(295),[G1H8(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(300),[G1H8(294)])
  call Hloop_VQ_A(ntryL,G1H4(172),ex1(:),G1H2(63),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(63),55,0,G2H2(171),n2h2(139))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(176),ex4(:),G1H2(64),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_VQ_A(ntryL,G1H4(183),ex1(:),G1H2(69),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(69),55,0,G2H2(172),n2h2(140))
  call Hloop_VQ_A(ntryL,G1H4(184),ex1(:),G1H2(70),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(70),55,0,G2H2(173),n2h2(141))
  call Hloop_VQ_A(ntryL,G1H4(188),ex2(:),G1H2(75),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(75),55,0,G2H2(174),n2h2(142))
call HGT_raise_alpha_OLR(G1H4(189),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(189),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(189),ex4(:),G1H2(76),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_VQ_A(ntryL,G1H4(196),ex2(:),G1H2(81),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(81),55,0,G2H2(175),n2h2(143))
  call Hloop_VQ_A(ntryL,G1H4(200),ex2(:),G1H2(82),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(82),55,0,G2H2(176),n2h2(144))
  call Hloop_VQ_A(ntryL,G1H4(201),ex1(:),G1H2(87),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(87),55,0,G2H2(177),n2h2(145))
call HGT_raise_alpha_OLR(G1H4(202),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(202),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(202),ex4(:),G1H2(88),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_VQ_A(ntryL,G1H4(212),ex1(:),G1H2(93),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(93),55,0,G2H2(178),n2h2(146))
  call Hloop_VQ_A(ntryL,G1H4(213),ex1(:),G1H2(94),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(179),n2h2(147))
  call Hloop_VQ_A(ntryL,G1H4(214),ex1(:),G1H2(99),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(99),59,0,G2H2(180),n2h2(148))
call HGT_raise_alpha_OLR(G1H4(219),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(219),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(219),ex3(:),G1H2(100),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_VQ_A(ntryL,G1H4(225),ex1(:),G1H2(105),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(105),59,0,G2H2(181),n2h2(149))
  call Hloop_VQ_A(ntryL,G1H4(226),ex1(:),G1H2(106),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(106),59,0,G2H2(182),n2h2(150))
  call Hloop_VQ_A(ntryL,G1H4(231),ex2(:),G1H2(111),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(111),55,0,G2H2(183),n2h2(151))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(232),ex4(:),G1H2(112),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_VQ_A(ntryL,G1H4(238),ex2(:),G1H2(117),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(117),55,0,G2H2(184),n2h2(152))
  call Hloop_VQ_A(ntryL,G1H4(243),ex2(:),G1H2(118),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(185),n2h2(153))
  call Hloop_VQ_A(ntryL,G1H4(244),ex2(:),G1H2(123),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(123),59,0,G2H2(186),n2h2(154))
call HGT_raise_alpha_OLR(G1H4(248),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(248),ex3(:),G1H2(124),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_VQ_A(ntryL,G1H4(255),ex2(:),G1H2(129),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(129),59,0,G2H2(187),n2h2(155))
  call Hloop_VQ_A(ntryL,G1H4(256),ex2(:),G1H2(130),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(130),59,0,G2H2(188),n2h2(156))
  call Hloop_VA_Q(ntryL,G1H4(260),ex3(:),G1H2(135),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(135),61,0,G2H2(189),n2h2(157))
call HGT_raise_alpha_OLR(G1H4(261),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(261),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(261),ex2(:),G1H2(136),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_VA_Q(ntryL,G1H4(268),ex3(:),G1H2(141),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_A_Q(ntryL,G1H2(141),61,0,G2H2(190),n2h2(158))
  call Hloop_VA_Q(ntryL,G1H4(272),ex3(:),G1H2(142),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(142),61,0,G2H2(191),n2h2(159))
  call Hloop_VA_Q(ntryL,G1H4(273),ex4(:),G1H2(147),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(147),61,0,G2H2(192),n2h2(160))
call HGT_raise_alpha_OLR(G1H4(274),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(274),ex2(:),G1H2(148),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_VA_Q(ntryL,G1H4(284),ex4(:),G1H2(153),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(193),n2h2(161))
  call Hloop_VA_Q(ntryL,G1H4(285),ex4(:),G1H2(154),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_A_Q(ntryL,G1H2(154),61,0,G2H2(194),n2h2(162))
  call Hloop_QV_A(ntryL,G1H4(286),ex5(:),G1H2(159),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(195),n2h2(163))
call HGT_raise_alpha_OLR(G1H4(291),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(291),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(291),ex4(:),G1H2(160),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_QV_A(ntryL,G1H4(110),ex5(:),G1H2(165),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(165),55,0,G2H2(196),n2h2(164))
  call Hloop_QV_A(ntryL,G1H4(122),ex5(:),G1H2(166),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(166),55,0,G2H2(197),n2h2(165))
  call Hloop_QV_A(ntryL,G1H4(134),ex5(:),G1H2(171),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(171),59,0,G2H2(198),n2h2(166))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(146),ex3(:),G1H2(172),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_QV_A(ntryL,G1H4(182),ex5(:),G1H2(33),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(33),59,0,G2H2(199),n2h2(167))
  call Hloop_QV_A(ntryL,G1H4(194),ex5(:),G1H2(34),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(34),59,0,G2H2(200),n2h2(168))
  call Hloop_QV_A(ntryL,G1H4(206),ex5(:),G1H2(39),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(39),55,0,G2H2(201),n2h2(169))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(218),ex4(:),G1H2(40),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_QV_A(ntryL,G1H4(254),ex5(:),G1H2(45),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(45),55,0,G2H2(202),n2h2(170))
  call Hloop_QV_A(ntryL,G1H4(266),ex5(:),G1H2(46),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(46),55,0,G2H2(203),n2h2(171))
  call Hloop_QV_A(ntryL,G1H4(278),ex5(:),G1H2(51),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(51),59,0,G2H2(204),n2h2(172))
call HGT_raise_alpha_OLR(G1H4(290),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(290),ex3(:),G1H2(52),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_QV_A(ntryL,G1H4(14),ex5(:),G1H2(57),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(57),59,0,G2H2(205),n2h2(173))
  call Hloop_QV_A(ntryL,G1H4(15),ex5(:),G1H2(58),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(58),59,0,G2H2(206),n2h2(174))
  call Hloop_QV_A(ntryL,G1H4(16),ex5(:),G1H2(63),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(63),55,0,G2H2(207),n2h2(175))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(69),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_QV_A(ntryL,G1H4(26),ex5(:),G1H2(70),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(70),55,0,G2H2(208),n2h2(176))
  call Hloop_QV_A(ntryL,G1H4(27),ex5(:),G1H2(75),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(75),55,0,G2H2(209),n2h2(177))
  call Hloop_QV_A(ntryL,G1H4(28),ex5(:),G1H2(81),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(81),55,0,G2H2(210),n2h2(178))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(82),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_QV_A(ntryL,G1H4(233),ex5(:),G1H2(87),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(87),55,0,G2H2(211),n2h2(179))
  call Hloop_QV_A(ntryL,G1H4(439),ex5(:),G1H2(93),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_Q_A(ntryL,G1H2(93),55,0,G2H2(212),n2h2(180))
  call Hloop_AV_Q(ntryL,G1H4(40),ex5(:),G1H2(94),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(94),62,0,G2H2(213),n2h2(181))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex1(:),G1H2(99),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_AV_Q(ntryL,G1H4(50),ex5(:),G1H2(105),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_A_Q(ntryL,G1H2(105),62,0,G2H2(214),n2h2(182))
  call Hloop_AV_Q(ntryL,G1H4(51),ex5(:),G1H2(106),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(106),62,0,G2H2(215),n2h2(183))
  call Hloop_QV_A(ntryL,G1H4(76),ex5(:),G1H2(111),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(111),55,0,G2H2(216),n2h2(184))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(82),ex4(:),G1H2(117),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_QV_A(ntryL,G1H4(245),ex5(:),G1H2(118),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(217),n2h2(185))
  call Hloop_QV_A(ntryL,G1H4(444),ex5(:),G1H2(123),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(123),55,0,G2H2(218),n2h2(186))
  call Hloop_AV_Q(ntryL,G1H4(99),ex5(:),G1H2(129),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(129),61,0,G2H2(219),n2h2(187))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(100),ex2(:),G1H2(130),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_AV_Q(ntryL,G1H4(111),ex5(:),G1H2(135),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(135),61,0,G2H2(220),n2h2(188))
  call Hloop_AV_Q(ntryL,G1H4(112),ex5(:),G1H2(141),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_A_Q(ntryL,G1H2(141),61,0,G2H2(221),n2h2(189))
  call Hloop_AV_Q(ntryL,G1H4(116),ex5(:),G1H2(142),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(142),61,0,G2H2(222),n2h2(190))
call HGT_raise_alpha_OLR(G1H4(117),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(117),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(117),ex2(:),G1H2(147),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_AV_Q(ntryL,G1H4(124),ex5(:),G1H2(153),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(223),n2h2(191))
  call Hloop_AV_Q(ntryL,G1H4(128),ex5(:),G1H2(154),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_A_Q(ntryL,G1H2(154),61,0,G2H2(224),n2h2(192))
  call Hloop_AV_Q(ntryL,G1H4(129),ex5(:),G1H2(159),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(159),62,0,G2H2(225),n2h2(193))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(130),ex1(:),G1H2(165),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_AV_Q(ntryL,G1H4(140),ex5(:),G1H2(166),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(166),62,0,G2H2(226),n2h2(194))
  call Hloop_AV_Q(ntryL,G1H4(141),ex5(:),G1H2(171),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(171),62,0,G2H2(227),n2h2(195))
  call Hloop_QV_A(ntryL,G1H4(142),ex5(:),G1H2(33),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(33),59,0,G2H2(228),n2h2(196))
call HGT_raise_alpha_OLR(G1H4(147),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(147),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(147),ex3(:),G1H2(34),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_QV_A(ntryL,G1H4(269),ex5(:),G1H2(39),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(39),59,0,G2H2(229),n2h2(197))
  call Hloop_QV_A(ntryL,G1H4(449),ex5(:),G1H2(45),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(45),59,0,G2H2(230),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H4(159),ex5(:),G1H2(46),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_A_Q(ntryL,G1H2(46),61,0,G2H2(231),n2h2(199))
call HGT_raise_alpha_OLR(G1H4(160),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(160),ex2(:),G1H2(51),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_AV_Q(ntryL,G1H4(166),ex5(:),G1H2(57),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(57),61,0,G2H2(232),n2h2(200))
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(58),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(58),61,0,G2H2(233),n2h2(201))
  call Hloop_QV_A(ntryL,G1H4(109),ex5(:),G1H2(63),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(63),59,0,G2H2(234),n2h2(202))
call HGT_raise_alpha_OLR(G1H4(121),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(121),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(121),ex3(:),G1H2(70),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_QV_A(ntryL,G1H4(281),ex5(:),G1H2(75),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(75),59,0,G2H2(235),n2h2(203))
  call Hloop_QV_A(ntryL,G1H4(454),ex5(:),G1H2(81),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_Q_A(ntryL,G1H2(81),59,0,G2H2(236),n2h2(204))
  call Hloop_VQ_A(ntryL,G1H4(181),ex2(:),G1H2(87),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(87),47,0,G2H2(237),n2h2(205))
call HGT_OLR(G1H4(193),1,1,4)
call HGT_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(193),-16,0,G2H4(108),n2h4(193))
  call Hloop_AV_Q(ntryL,G2H4(108),ex5(:),G2H2(238),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_VQ_A(ntryL,G1H4(217),ex2(:),G1H2(93),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(93),47,0,G2H2(239),n2h2(206))
  call Hloop_VQ_A(ntryL,G1H4(205),ex2(:),G1H2(94),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G1H2(94),47,0,G2H2(240),n2h2(207))
  call Hloop_VA_Q(ntryL,G1H4(35),ex4(:),G1H2(105),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(105),47,0,G2H2(241),n2h2(208))
call HGT_OLR(G1H4(81),1,1,4)
call HGT_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(81),-16,0,G2H4(103),n2h4(194))
  call Hloop_QV_A(ntryL,G2H4(103),ex5(:),G2H2(242),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_VA_Q(ntryL,G1H4(83),ex4(:),G1H2(106),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(106),47,0,G2H2(243),n2h2(209))
  call Hloop_VA_Q(ntryL,G1H4(87),ex4(:),G1H2(111),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G1H2(111),47,0,G2H2(244),n2h2(210))
  call Hloop_VQ_A(ntryL,G1H4(229),ex2(:),G1H2(118),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(118),47,0,G2H2(245),n2h2(211))
call HGT_OLR(G1H4(59),1,1,4)
call HGT_invQ_OLR(G1H4(59),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(59),-16,0,G2H4(45),n2h4(195))
  call Hloop_AV_Q(ntryL,G2H4(45),ex5(:),G2H2(246),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_VQ_A(ntryL,G1H4(17),ex2(:),G1H2(123),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_Q_A(ntryL,G1H2(123),47,0,G2H2(247),n2h2(212))
  call Hloop_VQ_A(ntryL,G1H4(64),ex2(:),G1H2(129),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_Q_A(ntryL,G1H2(129),47,0,G2H2(248),n2h2(213))
  call Hloop_VA_Q(ntryL,G1H4(289),ex3(:),G1H2(135),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(135),47,0,G2H2(249),n2h2(214))
call HGT_OLR(G1H4(253),1,1,4)
call HGT_invQ_OLR(G1H4(253),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(253),-16,0,G2H4(48),n2h4(196))
  call Hloop_QV_A(ntryL,G2H4(48),ex5(:),G2H2(250),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_VA_Q(ntryL,G1H4(265),ex3(:),G1H2(141),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(141),47,0,G2H2(251),n2h2(215))
  call Hloop_VA_Q(ntryL,G1H4(71),ex3(:),G1H2(142),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(142),47,0,G2H2(252),n2h2(216))
  call Hloop_VQ_A(ntryL,G1H4(75),ex1(:),G1H2(153),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(153),47,0,G2H2(253),n2h2(217))
call HGT_OLR(G1H4(277),1,1,4)
call HGT_invQ_OLR(G1H4(277),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(277),-16,0,G2H4(97),n2h4(197))
  call Hloop_AV_Q(ntryL,G2H4(97),ex5(:),G2H2(254),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_VQ_A(ntryL,G1H4(12),ex1(:),G1H2(154),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(154),47,0,G2H2(255),n2h2(218))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(159),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_Q_A(ntryL,G1H2(159),47,0,G2H2(256),n2h2(219))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(166),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(166),47,0,G2H2(257),n2h2(220))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-16,0,G2H4(52),n2h4(198))
  call Hloop_AV_Q(ntryL,G2H4(52),ex5(:),G2H2(258),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_VQ_A(ntryL,G1H4(23),ex1(:),G1H2(171),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(171),47,0,G2H2(259),n2h2(221))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(33),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(33),47,0,G2H2(260),n2h2(222))
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(39),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(39),47,0,G2H2(261),n2h2(223))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(30),-16,0,G2H4(16),n2h4(199))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(262),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_VA_Q(ntryL,G1H4(36),ex4(:),G1H2(45),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(45),47,0,G2H2(263),n2h2(224))
  call Hloop_VA_Q(ntryL,G1H4(85),ex4(:),G1H2(46),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(46),47,0,G2H2(264),n2h2(225))
  call Hloop_VA_Q(ntryL,G1H4(37),ex3(:),G1H2(57),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(57),47,0,G2H2(265),n2h2(226))
call HGT_OLR(G1H4(41),1,1,4)
call HGT_invQ_OLR(G1H4(41),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(41),-16,0,G2H4(56),n2h4(200))
  call Hloop_QV_A(ntryL,G2H4(56),ex5(:),G2H2(266),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_VA_Q(ntryL,G1H4(47),ex3(:),G1H2(58),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(58),47,0,G2H2(267),n2h2(227))
  call Hloop_VA_Q(ntryL,G1H4(91),ex3(:),G1H2(63),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(63),47,0,G2H2(268),n2h2(228))
  call Hloop_VQ_A(ntryL,G1H4(49),ex2(:),G1H2(75),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(75),47,0,G2H2(269),n2h2(229))
call HGT_OLR(G1H4(53),1,1,4)
call HGT_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(53),-16,0,G2H4(100),n2h4(201))
  call Hloop_AV_Q(ntryL,G2H4(100),ex5(:),G2H2(270),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_VQ_A(ntryL,G1H4(60),ex2(:),G1H2(81),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(81),47,0,G2H2(271),n2h2(230))
  call Hloop_VQ_A(ntryL,G1H4(65),ex2(:),G1H2(87),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_Q_A(ntryL,G1H2(87),47,0,G2H2(272),n2h2(231))
  call Hloop_VA_Q(ntryL,G1H4(66),ex4(:),G1H2(93),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_A_Q(ntryL,G1H2(93),47,0,G2H2(273),n2h2(232))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(72),-16,0,G2H4(60),n2h4(202))
  call Hloop_QV_A(ntryL,G2H4(60),ex5(:),G2H2(274),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(94),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_A_Q(ntryL,G1H2(94),47,0,G2H2(275),n2h2(233))
  call Hloop_VA_Q(ntryL,G1H4(89),ex4(:),G1H2(105),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(105),47,0,G2H2(276),n2h2(234))
  call Hloop_VQ_A(ntryL,G1H4(90),ex2(:),G1H2(106),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(106),47,0,G2H2(277),n2h2(235))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(96),-16,0,G2H4(99),n2h4(203))
  call Hloop_AV_Q(ntryL,G2H4(99),ex5(:),G2H2(278),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_VQ_A(ntryL,G1H4(107),ex2(:),G1H2(111),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(111),47,0,G2H2(279),n2h2(236))
  call Hloop_VQ_A(ntryL,G1H4(108),ex2(:),G1H2(118),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(118),47,0,G2H2(280),n2h2(237))
  call Hloop_VA_Q(ntryL,G1H4(119),ex3(:),G1H2(123),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(123),47,0,G2H2(281),n2h2(238))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(120),-16,0,G2H4(134),n2h4(204))
  call Hloop_QV_A(ntryL,G2H4(134),ex5(:),G2H2(282),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_VA_Q(ntryL,G1H4(143),ex3(:),G1H2(129),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(129),47,0,G2H2(283),n2h2(239))
  call Hloop_VA_Q(ntryL,G1H4(144),ex3(:),G1H2(135),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(135),47,0,G2H2(284),n2h2(240))
  call Hloop_VQ_A(ntryL,G1H4(155),ex1(:),G1H2(141),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(141),47,0,G2H2(285),n2h2(241))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(156),-16,0,G2H4(67),n2h4(205))
  call Hloop_AV_Q(ntryL,G2H4(67),ex5(:),G2H2(286),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_VQ_A(ntryL,G1H4(179),ex1(:),G1H2(142),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_Q_A(ntryL,G1H2(142),47,0,G2H2(287),n2h2(242))
  call Hloop_VQ_A(ntryL,G1H4(180),ex1(:),G1H2(153),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_Q_A(ntryL,G1H2(153),47,0,G2H2(288),n2h2(243))
  call Hloop_VA_Q(ntryL,G1H4(191),ex4(:),G1H2(154),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(154),47,0,G2H2(289),n2h2(244))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(192),-16,0,G2H4(106),n2h4(206))
  call Hloop_QV_A(ntryL,G2H4(106),ex5(:),G2H2(290),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_VA_Q(ntryL,G1H4(246),ex4(:),G1H2(159),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(159),47,0,G2H2(291),n2h2(245))
  call Hloop_VA_Q(ntryL,G1H4(210),ex4(:),G1H2(166),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(166),47,0,G2H2(292),n2h2(246))
  call Hloop_VQ_A(ntryL,G1H4(211),ex1(:),G1H2(171),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(171),47,0,G2H2(293),n2h2(247))
call HGT_OLR(G1H4(228),1,1,4)
call HGT_invQ_OLR(G1H4(228),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(228),-16,0,G2H4(139),n2h4(207))
  call Hloop_AV_Q(ntryL,G2H4(139),ex5(:),G2H2(294),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_VQ_A(ntryL,G1H4(222),ex1(:),G1H2(33),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_Q_A(ntryL,G1H2(33),47,0,G2H2(295),n2h2(248))
  call Hloop_VQ_A(ntryL,G1H4(227),ex1(:),G1H2(39),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_Q_A(ntryL,G1H2(39),47,0,G2H2(296),n2h2(249))
  call Hloop_VA_Q(ntryL,G1H4(235),ex3(:),G1H2(45),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(45),47,0,G2H2(297),n2h2(250))
call HGT_OLR(G1H4(239),1,1,4)
call HGT_invQ_OLR(G1H4(239),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(239),-16,0,G2H4(74),n2h4(208))
  call Hloop_QV_A(ntryL,G2H4(74),ex5(:),G2H2(298),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_VA_Q(ntryL,G1H4(252),ex3(:),G1H2(46),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(46),47,0,G2H2(299),n2h2(251))
  call Hloop_VA_Q(ntryL,G1H4(259),ex3(:),G1H2(57),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_A_Q(ntryL,G1H2(57),47,0,G2H2(300),n2h2(252))
  call Hloop_VQ_A(ntryL,G1H4(263),ex1(:),G1H2(58),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(58),55,0,G2H2(301),n2h2(253))
call HGT_raise_alpha_OLR(G1H4(264),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(264),ex4(:),G1H2(63),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_VQ_A(ntryL,G1H4(276),ex1(:),G1H2(75),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(75),55,0,G2H2(302),n2h2(254))
  call Hloop_VQ_A(ntryL,G1H4(283),ex1(:),G1H2(81),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(81),55,0,G2H2(303),n2h2(255))
  call Hloop_VQ_A(ntryL,G1H4(287),ex1(:),G1H2(87),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(87),55,0,G2H2(304),n2h2(256))
call HGT_raise_alpha_OLR(G1H4(288),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(288),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(288),ex4(:),G1H2(93),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(94),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(305),n2h2(257))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(105),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(105),55,0,G2H2(306),n2h2(258))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(106),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(106),55,0,G2H2(307),n2h2(259))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(6),ex4(:),G1H2(111),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_VQ_A(ntryL,G1H4(24),ex2(:),G1H2(118),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(308),n2h2(260))
  call Hloop_VQ_A(ntryL,G1H4(48),ex2(:),G1H2(123),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(123),55,0,G2H2(309),n2h2(261))
  call Hloop_VQ_A(ntryL,G1H4(69),ex2(:),G1H2(129),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(129),55,0,G2H2(310),n2h2(262))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(135),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_VQ_A(ntryL,G1H4(57),ex2(:),G1H2(141),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(141),55,0,G2H2(311),n2h2(263))
  call Hloop_VQ_A(ntryL,G1H4(58),ex2(:),G1H2(142),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(142),55,0,G2H2(312),n2h2(264))
  call Hloop_VQ_A(ntryL,G1H4(63),ex1(:),G1H2(153),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(313),n2h2(265))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(154),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_VQ_A(ntryL,G1H4(113),ex1(:),G1H2(159),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(314),n2h2(266))
  call Hloop_VQ_A(ntryL,G1H4(114),ex1(:),G1H2(166),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(166),55,0,G2H2(315),n2h2(267))
  call Hloop_VQ_A(ntryL,G1H4(115),ex1(:),G1H2(171),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(171),55,0,G2H2(316),n2h2(268))
call HGT_raise_alpha_OLR(G1H4(125),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(125),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(33),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_VQ_A(ntryL,G1H4(297),ex1(:),G1H2(39),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(39),55,0,G2H2(317),n2h2(269))
  call Hloop_VQ_A(ntryL,G1H4(298),ex1(:),G1H2(45),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_Q_A(ntryL,G1H2(45),55,0,G2H2(318),n2h2(270))
  call Hloop_VQ_A(ntryL,G1H4(137),ex1(:),G1H2(46),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(46),59,0,G2H2(319),n2h2(271))
call HGT_raise_alpha_OLR(G1H4(138),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(138),ex3(:),G1H2(57),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_VQ_A(ntryL,G1H4(300),ex1(:),G1H2(58),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(58),59,0,G2H2(320),n2h2(272))
  call Hloop_VQ_A(ntryL,G1H4(301),ex1(:),G1H2(75),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(75),59,0,G2H2(321),n2h2(273))
  call Hloop_VQ_A(ntryL,G1H4(302),ex1(:),G1H2(81),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(81),59,0,G2H2(322),n2h2(274))
call HGT_raise_alpha_OLR(G1H4(303),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(303),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(303),ex3(:),G1H2(87),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_VQ_A(ntryL,G1H4(306),ex1(:),G1H2(94),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(94),59,0,G2H2(323),n2h2(275))
  call Hloop_VQ_A(ntryL,G1H4(307),ex1(:),G1H2(105),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(105),59,0,G2H2(324),n2h2(276))
  call Hloop_VQ_A(ntryL,G1H4(149),ex2(:),G1H2(106),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(106),55,0,G2H2(325),n2h2(277))
call HGT_raise_alpha_OLR(G1H4(150),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(150),ex4(:),G1H2(118),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_VQ_A(ntryL,G1H4(309),ex2(:),G1H2(123),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(123),55,0,G2H2(326),n2h2(278))
  call Hloop_VQ_A(ntryL,G1H4(310),ex2(:),G1H2(129),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_Q_A(ntryL,G1H2(129),55,0,G2H2(327),n2h2(279))
  call Hloop_VQ_A(ntryL,G1H4(311),ex2(:),G1H2(141),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(141),55,0,G2H2(328),n2h2(280))
call HGT_raise_alpha_OLR(G1H4(312),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(312),ex4(:),G1H2(142),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_VQ_A(ntryL,G1H4(315),ex2(:),G1H2(153),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(329),n2h2(281))
  call Hloop_VQ_A(ntryL,G1H4(316),ex2(:),G1H2(159),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(330),n2h2(282))
  call Hloop_VQ_A(ntryL,G1H4(161),ex2(:),G1H2(166),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(166),59,0,G2H2(331),n2h2(283))
call HGT_raise_alpha_OLR(G1H4(162),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(162),ex3(:),G1H2(171),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_VQ_A(ntryL,G1H4(318),ex2(:),G1H2(39),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(39),59,0,G2H2(332),n2h2(284))
  call Hloop_VQ_A(ntryL,G1H4(319),ex2(:),G1H2(45),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(45),59,0,G2H2(333),n2h2(285))
  call Hloop_VQ_A(ntryL,G1H4(320),ex2(:),G1H2(46),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_Q_A(ntryL,G1H2(46),59,0,G2H2(334),n2h2(286))
call HGT_raise_alpha_OLR(G1H4(321),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(321),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(321),ex3(:),G1H2(58),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_VQ_A(ntryL,G1H4(324),ex2(:),G1H2(75),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_Q_A(ntryL,G1H2(75),59,0,G2H2(335),n2h2(287))
  call Hloop_VQ_A(ntryL,G1H4(325),ex2(:),G1H2(81),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_Q_A(ntryL,G1H2(81),59,0,G2H2(336),n2h2(288))
  call Hloop_VA_Q(ntryL,G1H4(173),ex3(:),G1H2(94),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_A_Q(ntryL,G1H2(94),61,0,G2H2(337),n2h2(289))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(174),ex2(:),G1H2(105),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_VA_Q(ntryL,G1H4(327),ex3(:),G1H2(106),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(106),61,0,G2H2(338),n2h2(290))
  call Hloop_VA_Q(ntryL,G1H4(328),ex3(:),G1H2(123),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_A_Q(ntryL,G1H2(123),61,0,G2H2(339),n2h2(291))
  call Hloop_VA_Q(ntryL,G1H4(329),ex3(:),G1H2(129),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(129),61,0,G2H2(340),n2h2(292))
call HGT_raise_alpha_OLR(G1H4(330),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(330),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(330),ex2(:),G1H2(141),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_VA_Q(ntryL,G1H4(333),ex3(:),G1H2(153),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(341),n2h2(293))
  call Hloop_VA_Q(ntryL,G1H4(334),ex3(:),G1H2(159),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_A_Q(ntryL,G1H2(159),61,0,G2H2(342),n2h2(294))
  call Hloop_VA_Q(ntryL,G1H4(185),ex4(:),G1H2(166),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_A_Q(ntryL,G1H2(166),61,0,G2H2(343),n2h2(295))
call HGT_raise_alpha_OLR(G1H4(186),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(186),ex2(:),G1H2(39),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hloop_VA_Q(ntryL,G1H4(336),ex4(:),G1H2(45),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_A_Q(ntryL,G1H2(45),61,0,G2H2(344),n2h2(296))
  call Hloop_VA_Q(ntryL,G1H4(337),ex4(:),G1H2(46),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_A_Q(ntryL,G1H2(46),61,0,G2H2(345),n2h2(297))
  call Hloop_VA_Q(ntryL,G1H4(338),ex4(:),G1H2(75),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_A_Q(ntryL,G1H2(75),61,0,G2H2(346),n2h2(298))
call HGT_raise_alpha_OLR(G1H4(339),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(339),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(339),ex2(:),G1H2(81),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_VA_Q(ntryL,G1H4(342),ex4(:),G1H2(94),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_A_Q(ntryL,G1H2(94),61,0,G2H2(347),n2h2(299))
  call Hloop_VA_Q(ntryL,G1H4(343),ex4(:),G1H2(106),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_A_Q(ntryL,G1H2(106),61,0,G2H2(348),n2h2(300))
  call Hloop_QV_A(ntryL,G1H4(197),ex5(:),G1H2(123),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(123),55,0,G2H2(349),n2h2(301))
call HGT_raise_alpha_OLR(G1H4(198),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(198),ex4(:),G1H2(129),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_QV_A(ntryL,G1H4(209),ex5(:),G1H2(153),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(350),n2h2(302))
  call Hloop_QV_A(ntryL,G1H4(293),ex5(:),G1H2(159),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(351),n2h2(303))
call HGT_raise_alpha_OLR(G1H4(347),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(347),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(347),ex4(:),G1H2(166),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_QV_A(ntryL,G1H4(350),ex5(:),G1H2(45),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_Q_A(ntryL,G1H2(45),55,0,G2H2(352),n2h2(304))
  call Hloop_QV_A(ntryL,G1H4(223),ex5(:),G1H2(46),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(46),55,0,G2H2(353),n2h2(305))
call HGT_raise_alpha_OLR(G1H4(351),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(351),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(351),ex4(:),G1H2(75),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(94),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(354),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(434),ex5(:),G1H2(106),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_Q_A(ntryL,G1H2(106),55,0,G2H2(355),n2h2(307))
call HGT_raise_alpha_OLR(G1H4(356),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(356),ex4(:),G1H2(123),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_QV_A(ntryL,G1H4(359),ex5(:),G1H2(153),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(356),n2h2(308))
  call Hloop_QV_A(ntryL,G1H4(360),ex5(:),G1H2(159),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(357),n2h2(309))
call HGT_raise_alpha_OLR(G1H4(361),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(361),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(361),ex4(:),G1H2(45),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_QV_A(ntryL,G1H4(364),ex5(:),G1H2(46),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(46),55,0,G2H2(358),n2h2(310))
  call Hloop_QV_A(ntryL,G1H4(365),ex5(:),G1H2(94),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(359),n2h2(311))
call HGT_raise_alpha_OLR(G1H4(366),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(366),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(366),ex4(:),G1H2(106),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_QV_A(ntryL,G1H4(369),ex5(:),G1H2(153),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(360),n2h2(312))
  call Hloop_QV_A(ntryL,G1H4(370),ex5(:),G1H2(159),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G1H2(159),55,0,G2H2(361),n2h2(313))
call HGT_raise_alpha_OLR(G1H4(371),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(371),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(371),ex4(:),G1H2(46),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_QV_A(ntryL,G1H4(374),ex5(:),G1H2(94),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(362),n2h2(314))
  call Hloop_QV_A(ntryL,G1H4(375),ex5(:),G1H2(153),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_Q_A(ntryL,G1H2(153),55,0,G2H2(363),n2h2(315))
call HGT_raise_alpha_OLR(G1H4(376),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(376),ex4(:),G1H2(159),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_QV_A(ntryL,G1H4(379),ex5(:),G1H2(94),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_Q_A(ntryL,G1H2(94),55,0,G2H2(364),n2h2(316))
  call Hloop_AV_Q(ntryL,G1H4(380),ex5(:),G1H2(153),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(365),n2h2(317))
call HGT_raise_alpha_OLR(G1H4(381),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(381),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(381),ex2(:),G1H2(94),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_AV_Q(ntryL,G1H4(384),ex5(:),G1H2(153),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(366),n2h2(318))
  call Hloop_AV_Q(ntryL,G1H4(385),ex5(:),G1H2(153),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(367),n2h2(319))
  call Hloop_AV_Q(ntryL,G1H4(386),ex5(:),G1H2(153),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_A_Q(ntryL,G1H2(153),61,0,G2H2(368),n2h2(320))
call HGT_raise_alpha_OLR(G1H4(387),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(387),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(387),ex2(:),G1H2(153),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_AV_Q(ntryL,G1H4(390),ex5(:),G1H2(177),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_A_Q(ntryL,G1H2(177),61,0,G2H2(369),n2h2(321))
  call Hloop_AV_Q(ntryL,G1H4(391),ex5(:),G1H2(177),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_A_Q(ntryL,G1H2(177),61,0,G2H2(370),n2h2(322))
  call Hloop_QV_A(ntryL,G1H4(257),ex5(:),G1H2(177),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(177),59,0,G2H2(371),n2h2(323))
call HGT_raise_alpha_OLR(G1H4(258),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(258),ex3(:),G1H2(177),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_QV_A(ntryL,G1H4(393),ex5(:),G1H2(178),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_Q_A(ntryL,G1H2(178),59,0,G2H2(372),n2h2(324))
  call Hloop_QV_A(ntryL,G1H4(394),ex5(:),G1H2(178),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(178),59,0,G2H2(373),n2h2(325))
  call Hloop_QV_A(ntryL,G1H4(395),ex5(:),G1H2(178),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_Q_A(ntryL,G1H2(178),59,0,G2H2(374),n2h2(326))
call HGT_raise_alpha_OLR(G1H4(396),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(396),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(396),ex3(:),G1H2(178),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_QV_A(ntryL,G1H4(399),ex5(:),G1H2(179),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_Q_A(ntryL,G1H2(179),59,0,G2H2(375),n2h2(327))
  call Hloop_QV_A(ntryL,G1H4(400),ex5(:),G1H2(179),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_Q_A(ntryL,G1H2(179),59,0,G2H2(376),n2h2(328))
call HGT_raise_alpha_OLR(G1H4(270),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(270),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(270),ex3(:),G1H2(179),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_QV_A(ntryL,G1H4(403),ex5(:),G1H2(180),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_Q_A(ntryL,G1H2(180),59,0,G2H2(377),n2h2(329))
  call Hloop_QV_A(ntryL,G1H4(404),ex5(:),G1H2(180),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_Q_A(ntryL,G1H2(180),59,0,G2H2(378),n2h2(330))
call HGT_raise_alpha_OLR(G1H4(405),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(405),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(405),ex3(:),G1H2(180),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_QV_A(ntryL,G1H4(408),ex5(:),G1H2(181),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_Q_A(ntryL,G1H2(181),59,0,G2H2(379),n2h2(331))
  call Hloop_QV_A(ntryL,G1H4(409),ex5(:),G1H2(181),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_Q_A(ntryL,G1H2(181),59,0,G2H2(380),n2h2(332))
  call Hloop_QV_A(ntryL,G1H4(410),ex5(:),G1H2(181),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(181),59,0,G2H2(381),n2h2(333))
call HGT_raise_alpha_OLR(G1H4(411),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(411),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(411),ex3(:),G1H2(181),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_QV_A(ntryL,G1H4(414),ex5(:),G1H2(182),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_Q_A(ntryL,G1H2(182),59,0,G2H2(382),n2h2(334))
  call Hloop_QV_A(ntryL,G1H4(415),ex5(:),G1H2(182),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_Q_A(ntryL,G1H2(182),59,0,G2H2(383),n2h2(335))
call HGT_raise_alpha_OLR(G1H4(282),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(282),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(282),ex3(:),G1H2(182),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_QV_A(ntryL,G1H4(418),ex5(:),G1H2(183),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_Q_A(ntryL,G1H2(183),59,0,G2H2(384),n2h2(336))
  call Hloop_AV_Q(ntryL,G1H4(419),ex5(:),G1H2(183),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(183),61,0,G2H2(385),n2h2(337))
call HGT_raise_alpha_OLR(G1H4(420),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(420),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(420),ex2(:),G1H2(183),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_AV_Q(ntryL,G1H4(423),ex5(:),G1H2(184),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(184),61,0,G2H2(386),n2h2(338))
  call Hloop_AV_Q(ntryL,G1H4(424),ex5(:),G1H2(184),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_A_Q(ntryL,G1H2(184),61,0,G2H2(387),n2h2(339))
  call Hloop_AV_Q(ntryL,G1H4(425),ex5(:),G1H2(184),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_A_Q(ntryL,G1H2(184),61,0,G2H2(388),n2h2(340))
call HGT_raise_alpha_OLR(G1H4(426),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(426),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(426),ex2(:),G1H2(184),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_AV_Q(ntryL,G1H4(429),ex5(:),G1H2(185),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_A_Q(ntryL,G1H2(185),61,0,G2H2(389),n2h2(341))
  call Hloop_AV_Q(ntryL,G1H4(430),ex5(:),G1H2(185),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_A_Q(ntryL,G1H2(185),61,0,G2H2(390),n2h2(342))
  call Hloop_AV_Q(ntryL,G1H8(65),ex5(:),G1H4(38),m3h2x4(:,233),heltab2x8(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(38),58,0,G2H4(104),n2h4(243))
call HGT_OLR(G1H8(66),1,1,8)
call HGT_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(66),-5,0,G2H8(29),n2h8(197))
  call Hloop_QV_A(ntryL,G2H8(29),wf4(:,1),G2H2(391),m3h4x2(:,9),heltab2x8(:,:,242))
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(39),m3h2x4(:,234),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(39),58,0,G2H4(95),n2h4(244))
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(93),m3h2x4(:,235),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(93),58,0,G2H4(81),n2h4(245))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(185),m3h4x2(:,10),heltab2x8(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(392),n2h2(343))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-16,0,G2H8(30),n2h8(198))
  call Hloop_QV_A(ntryL,G2H8(30),ex5(:),G2H4(101),m3h2x4(:,236),heltab2x8(:,:,246))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,1),G1H2(185),m3h4x2(:,11),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(393),n2h2(344))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,1),G1H2(185),m3h4x2(:,12),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(394),n2h2(345))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,1),G1H2(185),m3h4x2(:,13),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(395),n2h2(346))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-16,0,G2H8(31),n2h8(199))
  call Hloop_AV_Q(ntryL,G2H8(31),ex5(:),G2H4(145),m3h2x4(:,237),heltab2x8(:,:,250))
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,1),G1H2(185),m3h4x2(:,14),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(396),n2h2(347))
  call Hloop_QV_A(ntryL,G1H8(50),wf4(:,1),G1H2(185),m3h4x2(:,15),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(397),n2h2(348))
  call Hloop_AV_Q(ntryL,G1H8(52),ex5(:),G1H4(98),m3h2x4(:,238),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(98),57,0,G2H4(88),n2h4(246))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(56),-6,0,G2H8(32),n2h8(200))
  call Hloop_QV_A(ntryL,G2H8(32),wf4(:,11),G2H2(398),m3h4x2(:,16),heltab2x8(:,:,254))
  call Hloop_AV_Q(ntryL,G1H8(67),ex5(:),G1H4(153),m3h2x4(:,239),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(153),57,0,G2H4(109),n2h4(247))
  call Hloop_AV_Q(ntryL,G1H8(68),ex5(:),G1H4(154),m3h2x4(:,240),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(154),57,0,G2H4(151),n2h4(248))
  call Hloop_AV_Q(ntryL,G1H8(69),wf4(:,11),G1H2(185),m3h4x2(:,17),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(399),n2h2(349))
call HGT_OLR(G1H8(73),1,1,8)
call HGT_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(73),-16,0,G2H8(33),n2h8(201))
  call Hloop_QV_A(ntryL,G2H8(33),ex5(:),G2H4(1),m3h2x4(:,241),heltab2x8(:,:,258))
  call Hloop_AV_Q(ntryL,G1H8(76),wf4(:,11),G1H2(185),m3h4x2(:,18),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(400),n2h2(350))
  call Hloop_AV_Q(ntryL,G1H8(79),wf4(:,11),G1H2(185),m3h4x2(:,19),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(401),n2h2(351))
  call Hloop_QV_A(ntryL,G1H8(80),wf4(:,11),G1H2(185),m3h4x2(:,20),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(402),n2h2(352))
call HGT_OLR(G1H8(81),1,1,8)
call HGT_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(81),-16,0,G2H8(35),n2h8(202))
  call Hloop_AV_Q(ntryL,G2H8(35),ex5(:),G2H4(2),m3h2x4(:,242),heltab2x8(:,:,262))
  call Hloop_QV_A(ntryL,G1H8(88),wf4(:,11),G1H2(185),m3h4x2(:,21),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(403),n2h2(353))
  call Hloop_QV_A(ntryL,G1H8(91),wf4(:,11),G1H2(185),m3h4x2(:,22),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(404),n2h2(354))
  call Hloop_QV_A(ntryL,G1H8(92),ex5(:),G1H4(157),m3h2x4(:,243),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(157),54,0,G2H4(9),n2h4(249))
call HGT_OLR(G1H8(93),1,1,8)
call HGT_invQ_OLR(G1H8(93),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(93),-9,0,G2H8(36),n2h8(203))
  call Hloop_AV_Q(ntryL,G2H8(36),wf4(:,15),G2H2(405),m3h4x2(:,23),heltab2x8(:,:,266))
  call Hloop_QV_A(ntryL,G1H8(99),ex5(:),G1H4(169),m3h2x4(:,244),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(169),54,0,G2H4(10),n2h4(250))
  call Hloop_QV_A(ntryL,G1H8(100),ex5(:),G1H4(345),m3h2x4(:,245),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(345),54,0,G2H4(5),n2h4(251))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(346),m3h2x4(:,246),heltab2x8(:,:,269))
  call Hloop_A_Q(ntryL,G1H4(346),54,0,G2H4(13),n2h4(252))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-9,0,G2H8(37),n2h8(204))
  call Hloop_QV_A(ntryL,G2H8(37),wf4(:,15),G2H2(406),m3h4x2(:,24),heltab2x8(:,:,270))
  call Hloop_AV_Q(ntryL,G1H8(14),ex5(:),G1H4(354),m3h2x4(:,247),heltab2x8(:,:,271))
  call Hloop_A_Q(ntryL,G1H4(354),54,0,G2H4(6),n2h4(253))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(355),m3h2x4(:,248),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G1H4(355),54,0,G2H4(14),n2h4(254))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,15),G1H2(185),m3h4x2(:,25),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(407),n2h2(355))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,0,G2H8(39),n2h8(205))
  call Hloop_QV_A(ntryL,G2H8(39),ex5(:),G2H4(7),m3h2x4(:,249),heltab2x8(:,:,274))
  call Hloop_AV_Q(ntryL,G1H8(64),wf4(:,15),G1H2(185),m3h4x2(:,26),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(408),n2h2(356))
  call Hloop_AV_Q(ntryL,G1H8(63),wf4(:,15),G1H2(185),m3h4x2(:,27),heltab2x8(:,:,276))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(409),n2h2(357))
  call Hloop_QV_A(ntryL,G1H8(36),wf4(:,15),G1H2(185),m3h4x2(:,28),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(410),n2h2(358))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(42),-16,0,G2H8(40),n2h8(206))
  call Hloop_AV_Q(ntryL,G2H8(40),ex5(:),G2H4(4),m3h2x4(:,250),heltab2x8(:,:,278))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,15),G1H2(185),m3h4x2(:,29),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(411),n2h2(359))
  call Hloop_QV_A(ntryL,G1H8(54),wf4(:,15),G1H2(185),m3h4x2(:,30),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(412),n2h2(360))
  call Hloop_QV_A(ntryL,G1H8(43),ex5(:),G1H4(172),m3h2x4(:,251),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(172),53,0,G2H4(94),n2h4(255))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(71),-10,0,G2H8(41),n2h8(207))
  call Hloop_AV_Q(ntryL,G2H8(41),wf4(:,20),G2H2(413),m3h4x2(:,31),heltab2x8(:,:,282))
  call Hloop_QV_A(ntryL,G1H8(83),ex5(:),G1H4(176),m3h2x4(:,252),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(176),53,0,G2H4(12),n2h4(256))
  call Hloop_QV_A(ntryL,G1H8(89),ex5(:),G1H4(183),m3h2x4(:,253),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G1H4(183),53,0,G2H4(11),n2h4(257))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(184),m3h2x4(:,254),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(184),53,0,G2H4(96),n2h4(258))
call HGT_OLR(G1H8(95),1,1,8)
call HGT_invQ_OLR(G1H8(95),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(95),-10,0,G2H8(43),n2h8(208))
  call Hloop_QV_A(ntryL,G2H8(43),wf4(:,20),G2H2(414),m3h4x2(:,32),heltab2x8(:,:,286))
  call Hloop_AV_Q(ntryL,G1H8(25),ex5(:),G1H4(188),m3h2x4(:,255),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(188),53,0,G2H4(3),n2h4(259))
  call Hloop_AV_Q(ntryL,G1H8(26),ex5(:),G1H4(189),m3h2x4(:,256),heltab2x8(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(189),53,0,G2H4(8),n2h4(260))
  call Hloop_AV_Q(ntryL,G1H8(27),wf4(:,20),G1H2(185),m3h4x2(:,33),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(415),n2h2(361))
call HGT_OLR(G1H8(31),1,1,8)
call HGT_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(31),-16,0,G2H8(44),n2h8(209))
  call Hloop_QV_A(ntryL,G2H8(44),ex5(:),G2H4(80),m3h2x4(:,257),heltab2x8(:,:,290))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,20),G1H2(185),m3h4x2(:,34),heltab2x8(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(416),n2h2(362))
  call Hloop_AV_Q(ntryL,G1H8(82),wf4(:,20),G1H2(185),m3h4x2(:,35),heltab2x8(:,:,292))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(417),n2h2(363))
  call Hloop_QV_A(ntryL,G1H8(70),wf4(:,20),G1H2(185),m3h4x2(:,36),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(418),n2h2(364))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(29),-16,0,G2H8(45),n2h8(210))
  call Hloop_AV_Q(ntryL,G2H8(45),ex5(:),G2H4(19),m3h2x4(:,258),heltab2x8(:,:,294))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,20),G1H2(185),m3h4x2(:,37),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(419),n2h2(365))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,20),G1H2(185),m3h4x2(:,38),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(185),47,0,G2H2(420),n2h2(366))
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(196),m3h2x4(:,259),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(196),46,0,G2H4(83),n2h4(261))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(48),wf4(:,12),G1H2(185),m3h4x2(:,39),heltab2x8(:,:,298))
  call Hloop_VA_Q(ntryL,G1H8(30),ex4(:),G1H4(200),m3h2x4(:,260),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(200),46,0,G2H4(22),n2h4(262))
  call Hloop_VA_Q(ntryL,G1H8(35),ex4(:),G1H4(201),m3h2x4(:,261),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(201),46,0,G2H4(84),n2h4(263))
  call Hloop_VA_Q(ntryL,G1H8(41),ex3(:),G1H4(202),m3h2x4(:,262),heltab2x8(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(202),46,0,G2H4(25),n2h4(264))
call HGT_raise_alpha_OLR(G1H8(47),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(47),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(47),wf4(:,12),G1H2(186),m3h4x2(:,40),heltab2x8(:,:,302))
  call Hloop_VA_Q(ntryL,G1H8(107),ex3(:),G1H4(212),m3h2x4(:,263),heltab2x8(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(212),46,0,G2H4(86),n2h4(265))
  call Hloop_VA_Q(ntryL,G1H8(108),ex3(:),G1H4(213),m3h2x4(:,264),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(213),46,0,G2H4(28),n2h4(266))
  call Hloop_VA_Q(ntryL,G1H8(109),ex4(:),G1H4(214),m3h2x4(:,265),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(214),46,0,G2H4(87),n2h4(267))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(110),wf4(:,12),G1H2(187),m3h4x2(:,41),heltab2x8(:,:,306))
  call Hloop_VA_Q(ntryL,G1H8(113),ex4(:),G1H4(219),m3h2x4(:,266),heltab2x8(:,:,307))
  call Hloop_A_Q(ntryL,G1H4(219),46,0,G2H4(31),n2h4(268))
  call Hloop_VA_Q(ntryL,G1H8(114),ex4(:),G1H4(225),m3h2x4(:,267),heltab2x8(:,:,308))
  call Hloop_A_Q(ntryL,G1H4(225),46,0,G2H4(90),n2h4(269))
  call Hloop_VQ_A(ntryL,G1H8(115),wf4(:,12),G1H2(188),m3h4x2(:,42),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(421),n2h2(367))
call HGT_raise_alpha_OLR(G1H8(116),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(116),ex4(:),G1H4(226),m3h2x4(:,268),heltab2x8(:,:,310))
  call Hloop_VQ_A(ntryL,G1H8(119),wf4(:,12),G1H2(188),m3h4x2(:,43),heltab2x8(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(422),n2h2(368))
  call Hloop_VQ_A(ntryL,G1H8(120),wf4(:,12),G1H2(188),m3h4x2(:,44),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(423),n2h2(369))
  call Hloop_VQ_A(ntryL,G1H8(121),wf4(:,12),G1H2(188),m3h4x2(:,45),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(424),n2h2(370))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(122),ex4(:),G1H4(231),m3h2x4(:,269),heltab2x8(:,:,314))
  call Hloop_VQ_A(ntryL,G1H8(125),wf4(:,12),G1H2(188),m3h4x2(:,46),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(425),n2h2(371))
  call Hloop_VQ_A(ntryL,G1H8(126),wf4(:,12),G1H2(188),m3h4x2(:,47),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(426),n2h2(372))
  call Hloop_VA_Q(ntryL,G1H8(127),ex3(:),G1H4(232),m3h2x4(:,270),heltab2x8(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(232),46,0,G2H4(34),n2h4(270))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(128),wf4(:,12),G1H2(188),m3h4x2(:,48),heltab2x8(:,:,318))
  call Hloop_VA_Q(ntryL,G1H8(131),ex3(:),G1H4(238),m3h2x4(:,271),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(238),46,0,G2H4(91),n2h4(271))
  call Hloop_VA_Q(ntryL,G1H8(132),ex3(:),G1H4(243),m3h2x4(:,272),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G1H4(243),46,0,G2H4(37),n2h4(272))
  call Hloop_VQ_A(ntryL,G1H8(133),wf4(:,12),G1H2(189),m3h4x2(:,49),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(189),59,0,G2H2(427),n2h2(373))
call HGT_raise_alpha_OLR(G1H8(134),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(134),ex3(:),G1H4(244),m3h2x4(:,273),heltab2x8(:,:,322))
  call Hloop_VQ_A(ntryL,G1H8(137),wf4(:,12),G1H2(189),m3h4x2(:,50),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(189),59,0,G2H2(428),n2h2(374))
  call Hloop_VQ_A(ntryL,G1H8(138),wf4(:,12),G1H2(189),m3h4x2(:,51),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(189),59,0,G2H2(429),n2h2(375))
  call Hloop_VA_Q(ntryL,G1H8(139),ex4(:),G1H4(248),m3h2x4(:,274),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(248),45,0,G2H4(93),n2h4(273))
call HGT_raise_alpha_OLR(G1H8(140),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(140),wf4(:,4),G1H2(189),m3h4x2(:,52),heltab2x8(:,:,326))
  call Hloop_VA_Q(ntryL,G1H8(143),ex4(:),G1H4(255),m3h2x4(:,275),heltab2x8(:,:,327))
  call Hloop_A_Q(ntryL,G1H4(255),45,0,G2H4(40),n2h4(274))
  call Hloop_VA_Q(ntryL,G1H8(144),ex4(:),G1H4(256),m3h2x4(:,276),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(256),45,0,G2H4(115),n2h4(275))
  call Hloop_VA_Q(ntryL,G1H8(145),ex3(:),G1H4(260),m3h2x4(:,277),heltab2x8(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(260),45,0,G2H4(117),n2h4(276))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(146),wf4(:,4),G1H2(190),m3h4x2(:,53),heltab2x8(:,:,330))
  call Hloop_VA_Q(ntryL,G1H8(149),ex3(:),G1H4(261),m3h2x4(:,278),heltab2x8(:,:,331))
  call Hloop_A_Q(ntryL,G1H4(261),45,0,G2H4(119),n2h4(277))
  call Hloop_VA_Q(ntryL,G1H8(150),ex3(:),G1H4(268),m3h2x4(:,279),heltab2x8(:,:,332))
  call Hloop_A_Q(ntryL,G1H4(268),45,0,G2H4(121),n2h4(278))
  call Hloop_VA_Q(ntryL,G1H8(151),ex4(:),G1H4(272),m3h2x4(:,280),heltab2x8(:,:,333))
  call Hloop_A_Q(ntryL,G1H4(272),45,0,G2H4(51),n2h4(279))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(152),wf4(:,4),G1H2(191),m3h4x2(:,54),heltab2x8(:,:,334))
  call Hloop_VA_Q(ntryL,G1H8(155),ex4(:),G1H4(273),m3h2x4(:,281),heltab2x8(:,:,335))
  call Hloop_A_Q(ntryL,G1H4(273),45,0,G2H4(136),n2h4(280))
  call Hloop_VA_Q(ntryL,G1H8(156),ex4(:),G1H4(274),m3h2x4(:,282),heltab2x8(:,:,336))
  call Hloop_A_Q(ntryL,G1H4(274),45,0,G2H4(58),n2h4(281))
  call Hloop_VQ_A(ntryL,G1H8(157),wf4(:,4),G1H2(192),m3h4x2(:,55),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(430),n2h2(376))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(158),ex4(:),G1H4(284),m3h2x4(:,283),heltab2x8(:,:,338))
  call Hloop_VQ_A(ntryL,G1H8(161),wf4(:,4),G1H2(192),m3h4x2(:,56),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(431),n2h2(377))
  call Hloop_VQ_A(ntryL,G1H8(162),wf4(:,4),G1H2(192),m3h4x2(:,57),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(432),n2h2(378))
  call Hloop_VQ_A(ntryL,G1H8(163),wf4(:,4),G1H2(192),m3h4x2(:,58),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(433),n2h2(379))
call HGT_raise_alpha_OLR(G1H8(164),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(164),ex4(:),G1H4(285),m3h2x4(:,284),heltab2x8(:,:,342))
  call Hloop_VQ_A(ntryL,G1H8(167),wf4(:,4),G1H2(192),m3h4x2(:,59),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(434),n2h2(380))
  call Hloop_VQ_A(ntryL,G1H8(168),wf4(:,4),G1H2(192),m3h4x2(:,60),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(435),n2h2(381))
  call Hloop_VA_Q(ntryL,G1H8(169),ex3(:),G1H4(286),m3h2x4(:,285),heltab2x8(:,:,345))
  call Hloop_A_Q(ntryL,G1H4(286),45,0,G2H4(141),n2h4(282))
call HGT_raise_alpha_OLR(G1H8(170),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(170),wf4(:,4),G1H2(192),m3h4x2(:,61),heltab2x8(:,:,346))
  call Hloop_VA_Q(ntryL,G1H8(173),ex3(:),G1H4(291),m3h2x4(:,286),heltab2x8(:,:,347))
  call Hloop_A_Q(ntryL,G1H4(291),45,0,G2H4(62),n2h4(283))
  call Hloop_VA_Q(ntryL,G1H8(174),ex3(:),G1H4(110),m3h2x4(:,287),heltab2x8(:,:,348))
  call Hloop_A_Q(ntryL,G1H4(110),45,0,G2H4(63),n2h4(284))
  call Hloop_VQ_A(ntryL,G1H8(175),wf4(:,4),G1H2(193),m3h4x2(:,62),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(193),59,0,G2H2(436),n2h2(382))
call HGT_raise_alpha_OLR(G1H8(176),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(176),ex3(:),G1H4(122),m3h2x4(:,288),heltab2x8(:,:,350))
  call Hloop_VQ_A(ntryL,G1H8(179),wf4(:,4),G1H2(193),m3h4x2(:,63),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(193),59,0,G2H2(437),n2h2(383))
  call Hloop_VQ_A(ntryL,G1H8(180),wf4(:,4),G1H2(193),m3h4x2(:,64),heltab2x8(:,:,352))
  call Hloop_Q_A(ntryL,G1H2(193),59,0,G2H2(438),n2h2(384))
  call Hloop_VQ_A(ntryL,G1H8(181),ex2(:),G1H4(134),m3h2x4(:,289),heltab2x8(:,:,353))
  call Hloop_Q_A(ntryL,G1H4(134),43,0,G2H4(66),n2h4(285))
call HGT_raise_alpha_OLR(G1H8(182),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(182),wf4(:,19),G1H2(193),m3h4x2(:,65),heltab2x8(:,:,354))
  call Hloop_VQ_A(ntryL,G1H8(185),ex2(:),G1H4(146),m3h2x4(:,290),heltab2x8(:,:,355))
  call Hloop_Q_A(ntryL,G1H4(146),43,0,G2H4(69),n2h4(286))
  call Hloop_VQ_A(ntryL,G1H8(186),ex2(:),G1H4(182),m3h2x4(:,291),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G1H4(182),43,0,G2H4(147),n2h4(287))
  call Hloop_VQ_A(ntryL,G1H8(187),ex1(:),G1H4(194),m3h2x4(:,292),heltab2x8(:,:,357))
  call Hloop_Q_A(ntryL,G1H4(194),43,0,G2H4(73),n2h4(288))
call HGT_raise_alpha_OLR(G1H8(188),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(188),wf4(:,19),G1H2(194),m3h4x2(:,66),heltab2x8(:,:,358))
  call Hloop_VQ_A(ntryL,G1H8(191),ex1(:),G1H4(206),m3h2x4(:,293),heltab2x8(:,:,359))
  call Hloop_Q_A(ntryL,G1H4(206),43,0,G2H4(76),n2h4(289))
  call Hloop_VQ_A(ntryL,G1H8(192),ex1(:),G1H4(218),m3h2x4(:,294),heltab2x8(:,:,360))
  call Hloop_Q_A(ntryL,G1H4(218),43,0,G2H4(153),n2h4(290))
  call Hloop_VQ_A(ntryL,G1H8(193),ex2(:),G1H4(254),m3h2x4(:,295),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(254),43,0,G2H4(77),n2h4(291))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(194),wf4(:,19),G1H2(195),m3h4x2(:,67),heltab2x8(:,:,362))
  call Hloop_VQ_A(ntryL,G1H8(197),ex2(:),G1H4(266),m3h2x4(:,296),heltab2x8(:,:,363))
  call Hloop_Q_A(ntryL,G1H4(266),43,0,G2H4(79),n2h4(292))
  call Hloop_VQ_A(ntryL,G1H8(198),ex2(:),G1H4(278),m3h2x4(:,297),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G1H4(278),43,0,G2H4(17),n2h4(293))
  call Hloop_VA_Q(ntryL,G1H8(199),wf4(:,19),G1H2(196),m3h4x2(:,68),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(196),61,0,G2H2(439),n2h2(385))
call HGT_raise_alpha_OLR(G1H8(200),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(200),ex2(:),G1H4(290),m3h2x4(:,298),heltab2x8(:,:,366))
  call Hloop_VA_Q(ntryL,G1H8(203),wf4(:,19),G1H2(196),m3h4x2(:,69),heltab2x8(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(196),61,0,G2H2(440),n2h2(386))
  call Hloop_VA_Q(ntryL,G1H8(204),wf4(:,19),G1H2(196),m3h4x2(:,70),heltab2x8(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(196),61,0,G2H2(441),n2h2(387))
  call Hloop_VQ_A(ntryL,G1H8(205),ex1(:),G1H4(14),m3h2x4(:,299),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H4(14),43,0,G2H4(20),n2h4(294))
call HGT_raise_alpha_OLR(G1H8(206),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(206),wf4(:,19),G1H2(196),m3h4x2(:,71),heltab2x8(:,:,370))
  call Hloop_VQ_A(ntryL,G1H8(209),ex1(:),G1H4(15),m3h2x4(:,300),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G1H4(15),43,0,G2H4(23),n2h4(295))
  call Hloop_VQ_A(ntryL,G1H8(210),ex1(:),G1H4(16),m3h2x4(:,301),heltab2x8(:,:,372))
  call Hloop_Q_A(ntryL,G1H4(16),43,0,G2H4(26),n2h4(296))
  call Hloop_VQ_A(ntryL,G1H8(211),ex2(:),G1H4(20),m3h2x4(:,302),heltab2x8(:,:,373))
  call Hloop_Q_A(ntryL,G1H4(20),39,0,G2H4(29),n2h4(297))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(212),wf4(:,9),G1H2(197),m3h4x2(:,72),heltab2x8(:,:,374))
  call Hloop_VQ_A(ntryL,G1H8(215),ex2(:),G1H4(26),m3h2x4(:,303),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(26),39,0,G2H4(32),n2h4(298))
  call Hloop_VQ_A(ntryL,G1H8(216),ex2(:),G1H4(27),m3h2x4(:,304),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(27),39,0,G2H4(35),n2h4(299))
  call Hloop_VQ_A(ntryL,G1H8(217),ex1(:),G1H4(28),m3h2x4(:,305),heltab2x8(:,:,377))
  call Hloop_Q_A(ntryL,G1H4(28),39,0,G2H4(38),n2h4(300))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(218),wf4(:,9),G1H2(198),m3h4x2(:,73),heltab2x8(:,:,378))
  call Hloop_VQ_A(ntryL,G1H8(221),ex1(:),G1H4(32),m3h2x4(:,306),heltab2x8(:,:,379))
  call Hloop_Q_A(ntryL,G1H4(32),39,0,G2H4(44),n2h4(301))
  call Hloop_VQ_A(ntryL,G1H8(222),ex1(:),G1H4(233),m3h2x4(:,307),heltab2x8(:,:,380))
  call Hloop_Q_A(ntryL,G1H4(233),39,0,G2H4(46),n2h4(302))
  call Hloop_VQ_A(ntryL,G1H8(223),ex2(:),G1H4(439),m3h2x4(:,308),heltab2x8(:,:,381))
  call Hloop_Q_A(ntryL,G1H4(439),39,0,G2H4(47),n2h4(303))
call HGT_raise_alpha_OLR(G1H8(224),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(224),wf4(:,9),G1H2(199),m3h4x2(:,74),heltab2x8(:,:,382))
  call Hloop_VQ_A(ntryL,G1H8(227),ex2(:),G1H4(40),m3h2x4(:,309),heltab2x8(:,:,383))
  call Hloop_Q_A(ntryL,G1H4(40),39,0,G2H4(50),n2h4(304))
  call Hloop_VQ_A(ntryL,G1H8(228),ex2(:),G1H4(44),m3h2x4(:,310),heltab2x8(:,:,384))
  call Hloop_Q_A(ntryL,G1H4(44),39,0,G2H4(54),n2h4(305))
  call Hloop_VA_Q(ntryL,G1H8(229),wf4(:,9),G1H2(200),m3h4x2(:,75),heltab2x8(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(200),61,0,G2H2(442),n2h2(388))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(230),ex2(:),G1H4(50),m3h2x4(:,311),heltab2x8(:,:,386))
  call Hloop_VA_Q(ntryL,G1H8(233),wf4(:,9),G1H2(200),m3h4x2(:,76),heltab2x8(:,:,387))
  call Hloop_A_Q(ntryL,G1H2(200),61,0,G2H2(443),n2h2(389))
  call Hloop_VA_Q(ntryL,G1H8(234),wf4(:,9),G1H2(200),m3h4x2(:,77),heltab2x8(:,:,388))
  call Hloop_A_Q(ntryL,G1H2(200),61,0,G2H2(444),n2h2(390))
  call Hloop_VQ_A(ntryL,G1H8(235),ex1(:),G1H4(51),m3h2x4(:,312),heltab2x8(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(51),39,0,G2H4(55),n2h4(306))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(236),wf4(:,9),G1H2(200),m3h4x2(:,78),heltab2x8(:,:,390))
  call Hloop_VQ_A(ntryL,G1H8(239),ex1(:),G1H4(76),m3h2x4(:,313),heltab2x8(:,:,391))
  call Hloop_Q_A(ntryL,G1H4(76),39,0,G2H4(59),n2h4(307))
  call Hloop_VQ_A(ntryL,G1H8(240),ex1(:),G1H4(82),m3h2x4(:,314),heltab2x8(:,:,392))
  call Hloop_Q_A(ntryL,G1H4(82),39,0,G2H4(65),n2h4(308))
call HGT_raise_alpha_OLR(G1H4(294),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(294),ex4(:),G1H2(201),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_QV_A(ntryL,G1H4(433),ex5(:),G1H2(202),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_Q_A(ntryL,G1H2(202),55,0,G2H2(445),n2h2(391))
call HGT_raise_alpha_OLR(G1H4(435),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(435),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(435),ex4(:),G1H2(202),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_QV_A(ntryL,G1H4(438),ex5(:),G1H2(203),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(446),n2h2(392))
  call Hloop_QV_A(ntryL,G1H8(241),wf4(:,1),G1H2(203),m3h4x2(:,79),heltab2x8(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(447),n2h2(393))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(242),ex4(:),G1H4(245),m3h2x4(:,315),heltab2x8(:,:,394))
  call Hloop_QV_A(ntryL,G1H8(247),wf4(:,1),G1H2(203),m3h4x2(:,80),heltab2x8(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(448),n2h2(394))
  call Hloop_QV_A(ntryL,G1H8(252),wf4(:,1),G1H2(203),m3h4x2(:,81),heltab2x8(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(449),n2h2(395))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(248),ex4(:),G1H4(444),m3h2x4(:,316),heltab2x8(:,:,397))
  call Hloop_QV_A(ntryL,G1H8(251),wf4(:,1),G1H2(203),m3h4x2(:,82),heltab2x8(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(450),n2h2(396))
call HGT_raise_alpha_OLR(G1H8(253),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(253),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(253),ex4(:),G1H4(99),m3h2x4(:,317),heltab2x8(:,:,399))
  call Hloop_QV_A(ntryL,G1H8(256),wf4(:,1),G1H2(203),m3h4x2(:,83),heltab2x8(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(451),n2h2(397))
call HGT_raise_alpha_OLR(G1H4(440),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(440),ex4(:),G1H2(203),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_QV_A(ntryL,G1H4(443),ex5(:),G1H2(204),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(452),n2h2(398))
  call Hloop_QV_A(ntryL,G1H8(257),wf4(:,11),G1H2(204),m3h4x2(:,84),heltab2x8(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(453),n2h2(399))
call HGT_raise_alpha_OLR(G1H8(258),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(258),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(258),ex4(:),G1H4(100),m3h2x4(:,318),heltab2x8(:,:,402))
  call Hloop_QV_A(ntryL,G1H8(263),wf4(:,11),G1H2(204),m3h4x2(:,85),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(454),n2h2(400))
  call Hloop_QV_A(ntryL,G1H8(268),wf4(:,11),G1H2(204),m3h4x2(:,86),heltab2x8(:,:,404))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(455),n2h2(401))
call HGT_raise_alpha_OLR(G1H8(264),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(264),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(264),ex4(:),G1H4(111),m3h2x4(:,319),heltab2x8(:,:,405))
  call Hloop_QV_A(ntryL,G1H8(267),wf4(:,11),G1H2(204),m3h4x2(:,87),heltab2x8(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(456),n2h2(402))
call HGT_raise_alpha_OLR(G1H8(269),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(269),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(269),ex4(:),G1H4(112),m3h2x4(:,320),heltab2x8(:,:,407))
  call Hloop_QV_A(ntryL,G1H8(272),wf4(:,11),G1H2(204),m3h4x2(:,88),heltab2x8(:,:,408))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(457),n2h2(403))
call HGT_raise_alpha_OLR(G1H4(445),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(445),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(445),ex4(:),G1H2(204),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_QV_A(ntryL,G1H4(448),ex5(:),G1H2(205),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_Q_A(ntryL,G1H2(205),55,0,G2H2(458),n2h2(404))
  call Hloop_QV_A(ntryL,G1H8(273),wf4(:,15),G1H2(205),m3h4x2(:,89),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(459),n2h2(405))
call HGT_raise_alpha_OLR(G1H8(274),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(274),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(274),ex3(:),G1H4(116),m3h2x4(:,321),heltab2x8(:,:,410))
  call Hloop_QV_A(ntryL,G1H8(279),wf4(:,15),G1H2(205),m3h4x2(:,90),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(460),n2h2(406))
  call Hloop_QV_A(ntryL,G1H8(284),wf4(:,15),G1H2(205),m3h4x2(:,91),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(461),n2h2(407))
call HGT_raise_alpha_OLR(G1H8(280),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(280),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(280),ex3(:),G1H4(117),m3h2x4(:,322),heltab2x8(:,:,413))
  call Hloop_QV_A(ntryL,G1H8(283),wf4(:,15),G1H2(205),m3h4x2(:,92),heltab2x8(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(462),n2h2(408))
call HGT_raise_alpha_OLR(G1H8(285),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(285),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(285),ex3(:),G1H4(124),m3h2x4(:,323),heltab2x8(:,:,415))
  call Hloop_QV_A(ntryL,G1H8(288),wf4(:,15),G1H2(205),m3h4x2(:,93),heltab2x8(:,:,416))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(463),n2h2(409))
call HGT_raise_alpha_OLR(G1H4(450),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(450),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(450),ex3(:),G1H2(205),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_QV_A(ntryL,G1H4(453),ex5(:),G1H2(206),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(464),n2h2(410))
  call Hloop_QV_A(ntryL,G1H8(289),wf4(:,20),G1H2(206),m3h4x2(:,94),heltab2x8(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(465),n2h2(411))
call HGT_raise_alpha_OLR(G1H8(290),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(290),ex3(:),G1H4(128),m3h2x4(:,324),heltab2x8(:,:,418))
  call Hloop_QV_A(ntryL,G1H8(295),wf4(:,20),G1H2(206),m3h4x2(:,95),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(466),n2h2(412))
  call Hloop_QV_A(ntryL,G1H8(300),wf4(:,20),G1H2(206),m3h4x2(:,96),heltab2x8(:,:,420))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(467),n2h2(413))
call HGT_raise_alpha_OLR(G1H8(296),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(296),ex3(:),G1H4(129),m3h2x4(:,325),heltab2x8(:,:,421))
  call Hloop_QV_A(ntryL,G1H8(299),wf4(:,20),G1H2(206),m3h4x2(:,97),heltab2x8(:,:,422))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(468),n2h2(414))
call HGT_raise_alpha_OLR(G1H8(301),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(301),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(301),ex3(:),G1H4(130),m3h2x4(:,326),heltab2x8(:,:,423))
  call Hloop_QV_A(ntryL,G1H8(304),wf4(:,20),G1H2(206),m3h4x2(:,98),heltab2x8(:,:,424))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(469),n2h2(415))
call HGT_raise_alpha_OLR(G1H4(455),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(455),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(455),ex3(:),G1H2(206),m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_QV_A(ntryL,G1H4(458),ex5(:),G1H2(207),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(207),59,0,G2H2(470),n2h2(416))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(2),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(4),G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G2H2(6),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(8),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(10),G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(12),G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(14),G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(16),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(19),G1H2(110),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(22),G1H2(104),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(25),G1H2(116),G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(37),G1H2(128),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(402),[G2H2(43),G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(407),[G2H2(46),G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(418),[G2H2(49),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(392),[G2H2(52),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(395),[G2H2(55),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(415),[G2H2(58),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(410),[G2H2(61),G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(399),[G2H2(64),G1H2(176)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(67)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(3)])
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(447),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(449),[G2H2(73)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(459),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(461),[G2H2(76)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(455),[G2H2(79)])
call HGT_w2_OLR(G1H2(11),1,1,2)
call HGT_w2_invQ_OLR(G1H2(11),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(465),[G2H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(467),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G1H2(41)])
call HGT_w2_OLR(G1H2(13),1,1,2)
call HGT_w2_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G1H2(35)])
call HGT_w2_OLR(G1H2(15),1,1,2)
call HGT_w2_invQ_OLR(G1H2(15),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(83)])
call HGT_w2_OLR(G1H2(17),1,1,2)
call HGT_w2_invQ_OLR(G1H2(17),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(433),[G2H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(435),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(107)])
call HGT_w2_OLR(G1H2(19),1,1,2)
call HGT_w2_invQ_OLR(G1H2(19),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(424),[G2H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(426),[G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(155)])
call HGT_w2_OLR(G1H2(21),1,1,2)
call HGT_w2_invQ_OLR(G1H2(21),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(421),[G2H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(423),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(131)])
call HGT_w2_OLR(G1H2(23),1,1,2)
call HGT_w2_invQ_OLR(G1H2(23),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(432),[G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(89)])
call HGT_w2_OLR(G1H2(25),1,1,2)
call HGT_w2_invQ_OLR(G1H2(25),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(442),[G2H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(444),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(167)])
call HGT_w2_OLR(G1H2(27),1,1,2)
call HGT_w2_invQ_OLR(G1H2(27),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(429),[G2H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(143)])
call HGT_w2_OLR(G1H2(29),1,1,2)
call HGT_w2_invQ_OLR(G1H2(29),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(436),[G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(101)])
call HGT_w2_OLR(G1H2(31),1,1,2)
call HGT_w2_invQ_OLR(G1H2(31),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(439),[G2H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(441),[G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(48),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(54),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(151),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(96),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G1H2(133),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(120),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G1H2(139),G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G1H2(145),G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(126),G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(249),[G1H2(151),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(114),G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(253),[G1H2(157),G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(257),[G1H2(169),G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G1H2(163),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(265),[G1H2(175),G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(281),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(293),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G1H2(174)])
  call Hotf_5pt_reduction(G2H2(162),RedSet_5(129),mass5set(:,1),  & 
G1H2(207),G1H2(38),G1H2(44),G1H2(50),G1H2(56),G1H2(62),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(164),RedSet_5(130),mass5set(:,1),  & 
G1H2(68),G1H2(74),G1H2(80),G1H2(110),G1H2(86),G1H2(104),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(131),mass5set(:,1),  & 
G1H2(92),G1H2(116),G1H2(98),G1H2(128),G1H2(122),G1H2(134),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(132),mass5set(:,1),  & 
G1H2(140),G1H2(146),G1H2(152),G1H2(158),G1H2(164),G1H2(170),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(158),RedSet_5(44),mass5set(:,1),  & 
G1H2(176),G1H2(1),G1H2(3),G1H2(5),G1H2(7),G1H2(9),2)
  call HG1shiftOLR(G1H2(1),4,2)
  call Hotf_5pt_reduction(G2H2(159),RedSet_5(42),mass5set(:,1),  & 
G1H2(11),G1H2(41),G1H2(13),G1H2(35),G1H2(15),G1H2(83),2)
  call HG1shiftOLR(G1H2(41),8,2)
  call Hotf_5pt_reduction(G2H2(157),RedSet_5(41),mass5set(:,1),  & 
G1H2(17),G1H2(107),G1H2(19),G1H2(155),G1H2(21),G1H2(131),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_5pt_reduction(G2H2(160),RedSet_5(45),mass5set(:,1),  & 
G1H2(23),G1H2(89),G1H2(25),G1H2(167),G1H2(27),G1H2(143),2)
  call HG1shiftOLR(G1H2(89),4,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(133),mass5set(:,1),  & 
G1H2(29),G1H2(101),G1H2(31),G1H2(48),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(101),2,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(134),mass5set(:,1),  & 
G1H2(54),G1H2(42),G1H2(43),G1H2(47),G1H2(49),G1H2(53),2)
  call HG1shiftOLR(G1H2(42),16,2)
call HGT_OLR(G2H2(21),1,1,2)
call HGT_invQ_OLR(G2H2(21),2,5,2)
call HGT_OLR(G2H2(21),6,15,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(135),mass5set(:,1),  & 
G1H2(55),G1H2(59),G1H2(60),G1H2(61),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(136),mass5set(:,1),  & 
G1H2(67),G1H2(71),G1H2(72),G1H2(73),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(71),16,2)
call HGT_OLR(G2H2(24),1,1,2)
call HGT_invQ_OLR(G2H2(24),2,5,2)
call HGT_OLR(G2H2(24),6,15,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(137),mass5set(:,1),  & 
G1H2(79),G1H2(96),G1H2(84),G1H2(133),G1H2(85),G1H2(120),2)
  call HG1shiftOLR(G1H2(96),2,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(138),mass5set(:,1),  & 
G1H2(90),G1H2(139),G1H2(91),G1H2(95),G1H2(145),G1H2(97),2)
  call HG1shiftOLR(G1H2(139),16,2)
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(139),mass5set(:,1),  & 
G1H2(126),G1H2(102),G1H2(151),G1H2(103),G1H2(114),G1H2(108),2)
  call HG1shiftOLR(G1H2(102),4,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(140),mass5set(:,1),  & 
G1H2(157),G1H2(109),G1H2(113),G1H2(169),G1H2(115),G1H2(119),2)
  call HG1shiftOLR(G1H2(109),1,2)
call HGT_OLR(G2H2(33),1,1,2)
call HGT_invQ_OLR(G2H2(33),2,5,2)
call HGT_OLR(G2H2(33),6,15,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(141),mass5set(:,1),  & 
G1H2(163),G1H2(121),G1H2(125),G1H2(175),G1H2(127),G1H2(132),2)
  call HG1shiftOLR(G1H2(121),1,2)
call HGT_OLR(G2H2(36),1,1,2)
call HGT_invQ_OLR(G2H2(36),2,5,2)
call HGT_OLR(G2H2(36),6,15,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(142),mass5set(:,1),  & 
G1H2(137),G1H2(138),G1H2(144),G1H2(149),G1H2(150),G1H2(156),2)
  call HG1shiftOLR(G1H2(138),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(143),mass5set(:,1),  & 
G1H2(161),G1H2(162),G1H2(168),G1H2(173),G1H2(174),G1H2(208),2)
  call HG1shiftOLR(G1H2(162),16,2)
call HGT_OLR(G2H2(39),1,1,2)
call HGT_invQ_OLR(G2H2(39),2,5,2)
call HGT_OLR(G2H2(39),6,15,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(144),mass5set(:,1),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(210),4,2)
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(145),mass5set(:,1),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(216),2,2)
  call Hotf_5pt_reduction(G2H2(402),RedSet_5(118),mass5set(:,1),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),16,2)
call HGT_OLR(G2H2(45),1,1,2)
call HGT_invQ_OLR(G2H2(45),2,5,2)
call HGT_OLR(G2H2(45),6,15,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(146),mass5set(:,1),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_5pt_reduction(G2H2(407),RedSet_5(120),mass5set(:,1),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),16,2)
call HGT_OLR(G2H2(48),1,1,2)
call HGT_invQ_OLR(G2H2(48),2,5,2)
call HGT_OLR(G2H2(48),6,15,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(147),mass5set(:,1),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),2,2)
  call Hotf_5pt_reduction(G2H2(418),RedSet_5(124),mass5set(:,1),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),16,2)
call HGT_OLR(G2H2(51),1,1,2)
call HGT_invQ_OLR(G2H2(51),2,5,2)
call HGT_OLR(G2H2(51),6,15,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(148),mass5set(:,1),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(252),4,2)
  call Hotf_5pt_reduction(G2H2(392),RedSet_5(115),mass5set(:,1),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),16,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(149),mass5set(:,1),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),1,2)
  call Hotf_5pt_reduction(G2H2(395),RedSet_5(116),mass5set(:,1),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),16,2)
call HGT_OLR(G2H2(57),1,1,2)
call HGT_invQ_OLR(G2H2(57),2,5,2)
call HGT_OLR(G2H2(57),6,15,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(150),mass5set(:,1),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(276),8,2)
  call Hotf_5pt_reduction(G2H2(415),RedSet_5(123),mass5set(:,1),  & 
G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(282),16,2)
call HGT_OLR(G2H2(60),1,1,2)
call HGT_invQ_OLR(G2H2(60),2,5,2)
call HGT_OLR(G2H2(60),6,15,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(151),mass5set(:,1),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),1,2)
  call Hotf_5pt_reduction(G2H2(410),RedSet_5(121),mass5set(:,1),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),16,2)
call HGT_OLR(G2H2(63),1,1,2)
call HGT_invQ_OLR(G2H2(63),2,5,2)
call HGT_OLR(G2H2(63),6,15,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(152),mass5set(:,1),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),2)
  call HG1shiftOLR(G1H2(300),4,2)
  call Hotf_5pt_reduction(G2H2(399),RedSet_5(117),mass5set(:,1),  & 
G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(306),16,2)
  call Hotf_5pt_reduction(G2H2(139),RedSet_5(153),mass5set(:,1),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(312),1,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(1),m3h2x1(:,65),heltab2x2(:,:,65))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(2),ex1(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(3),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hotf_5pt_reduction(G2H2(140),RedSet_5(154),mass5set(:,1),  & 
G1H2(2),G1H2(317),G1H2(318),G1H2(319),G1H2(320),G1H2(321),2)
  call HG1shiftOLR(G1H2(317),2,2)
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(50))
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(155),mass5set(:,1),  & 
G1H2(4),G1H2(322),G1H2(323),G1H2(324),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(322),1,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(447),ex4(:),G2tensor(5),m3h2x1(:,69),heltab2x2(:,:,69))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(449),ex4(:),G2tensor(7),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hotf_5pt_reduction(G2H2(142),RedSet_5(156),mass5set(:,1),  & 
G1H2(6),G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(327),1,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(459),ex3(:),G2tensor(8),m3h2x1(:,72),heltab2x2(:,:,72))
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(8),ex1(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(52))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(461),ex3(:),G2tensor(10),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hotf_5pt_reduction(G2H2(143),RedSet_5(157),mass5set(:,1),  & 
G1H2(8),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(453),ex4(:),G2tensor(11),m3h2x1(:,75),heltab2x2(:,:,75))
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(53))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(455),ex4(:),G2tensor(13),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hotf_5pt_reduction(G2H2(144),RedSet_5(158),mass5set(:,1),  & 
G1H2(10),G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),2)
  call HG1shiftOLR(G1H2(337),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(465),ex3(:),G2tensor(14),m3h2x1(:,78),heltab2x2(:,:,78))
call HGT_w2_OLR(G1H2(12),1,1,2)
call HGT_w2_invQ_OLR(G1H2(12),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(54))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(467),ex3(:),G2tensor(16),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(159),mass5set(:,1),  & 
G1H2(12),G1H2(342),G1H2(343),G1H2(344),G1H2(345),G1H2(346),2)
  call HG1shiftOLR(G1H2(342),4,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(87),ex2(:),G2tensor(17),m3h2x1(:,81),heltab2x2(:,:,81))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(55))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex2(:),G2tensor(21),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hotf_5pt_reduction(G2H2(146),RedSet_5(160),mass5set(:,1),  & 
G1H2(14),G1H2(347),G1H2(348),G1H2(349),G1H2(350),G1H2(351),2)
  call HG1shiftOLR(G1H2(347),8,2)
call HGT_w2_OLR(G1H2(16),1,1,2)
call HGT_w2_invQ_OLR(G1H2(16),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(56))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(161),mass5set(:,1),  & 
G1H2(16),G1H2(352),G1H2(353),G1H2(354),G1H2(355),G1H2(356),2)
  call HG1shiftOLR(G1H2(352),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(433),ex4(:),G2tensor(25),m3h2x1(:,85),heltab2x2(:,:,85))
call HGT_w2_OLR(G1H2(18),1,1,2)
call HGT_w2_invQ_OLR(G1H2(18),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(435),ex4(:),G2tensor(29),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(162),mass5set(:,1),  & 
G1H2(18),G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),2)
  call HG1shiftOLR(G1H2(357),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(424),ex4(:),G2tensor(31),m3h2x1(:,88),heltab2x2(:,:,88))
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(426),ex4(:),G2tensor(35),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(163),mass5set(:,1),  & 
G1H2(20),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(421),ex4(:),G2tensor(37),m3h2x1(:,91),heltab2x2(:,:,91))
call HGT_w2_OLR(G1H2(22),1,1,2)
call HGT_w2_invQ_OLR(G1H2(22),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(59))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(423),ex4(:),G2tensor(41),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(164),mass5set(:,1),  & 
G1H2(22),G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),2)
  call HG1shiftOLR(G1H2(367),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(430),ex4(:),G2tensor(43),m3h2x1(:,94),heltab2x2(:,:,94))
call HGT_w2_OLR(G1H2(24),1,1,2)
call HGT_w2_invQ_OLR(G1H2(24),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(432),ex4(:),G2tensor(47),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(165),mass5set(:,1),  & 
G1H2(24),G1H2(372),G1H2(373),G1H2(374),G1H2(375),G1H2(376),2)
  call HG1shiftOLR(G1H2(372),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(442),ex2(:),G2tensor(49),m3h2x1(:,97),heltab2x2(:,:,97))
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(61))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(444),ex2(:),G2tensor(53),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(166),mass5set(:,1),  & 
G1H2(26),G1H2(377),G1H2(378),G1H2(379),G1H2(380),G1H2(381),2)
  call HG1shiftOLR(G1H2(377),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(427),ex3(:),G2tensor(55),m3h2x1(:,100),heltab2x2(:,:,100))
call HGT_w2_OLR(G1H2(28),1,1,2)
call HGT_w2_invQ_OLR(G1H2(28),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(429),ex3(:),G2tensor(59),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(167),mass5set(:,1),  & 
G1H2(28),G1H2(382),G1H2(383),G1H2(384),G1H2(385),G1H2(386),2)
  call HG1shiftOLR(G1H2(382),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(436),ex3(:),G2tensor(61),m3h2x1(:,103),heltab2x2(:,:,103))
call HGT_w2_OLR(G1H2(30),1,1,2)
call HGT_w2_invQ_OLR(G1H2(30),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(438),ex3(:),G2tensor(65),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(168),mass5set(:,1),  & 
G1H2(30),G1H2(387),G1H2(388),G1H2(389),G1H2(390),G1H2(391),2)
  call HG1shiftOLR(G1H2(387),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(439),ex2(:),G2tensor(66),m3h2x1(:,106),heltab2x2(:,:,106))
call HGT_w2_OLR(G1H2(32),1,1,2)
call HGT_w2_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(64))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(441),ex2(:),G2tensor(68),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(169),mass5set(:,1),  & 
G1H2(32),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(170),mass5set(:,1),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),8,2)
  call Hotf_5pt_reduction(G2H2(148),RedSet_5(171),mass5set(:,1),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),4,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(172),mass5set(:,1),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),4,2)
  call Hotf_5pt_reduction(G2H2(149),RedSet_5(173),mass5set(:,1),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(174),mass5set(:,1),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),8,2)
  call Hotf_5pt_reduction(G2H2(150),RedSet_5(175),mass5set(:,1),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(176),mass5set(:,1),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(434),4,2)
  call Hotf_5pt_reduction(G2H2(151),RedSet_5(177),mass5set(:,1),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),G1H2(444),2)
  call HG1shiftOLR(G1H2(440),4,2)
  call Hotf_5pt_reduction(G2H2(152),RedSet_5(178),mass5set(:,1),  & 
G1H2(445),G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),2)
  call HG1shiftOLR(G1H2(446),4,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(58),mass5set(:,1),  & 
G1H2(451),G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),2)
  call HG1shiftOLR(G1H2(452),4,2)
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(179),mass5set(:,1),  & 
G1H2(457),G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(458),8,2)
  call Hotf_5pt_reduction(G2H2(165),RedSet_5(49),mass5set(:,1),  & 
G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(464),8,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(59),mass5set(:,1),  & 
G1H2(469),G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(470),8,2)
  call Hotf_5pt_reduction(G2H2(154),RedSet_5(180),mass5set(:,1),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),8,2)
  call Hotf_5pt_reduction(G2H2(168),RedSet_5(50),mass5set(:,1),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(482),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(57),mass5set(:,1),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),8,2)
  call Hotf_5pt_reduction(G2H2(155),RedSet_5(181),mass5set(:,1),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(494),4,2)
  call Hotf_5pt_reduction(G2H2(156),RedSet_5(182),mass5set(:,1),  & 
G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),G1H2(504),2)
  call HG1shiftOLR(G1H2(500),4,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(60),mass5set(:,1),  & 
G1H2(505),G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),2)
  call HG1shiftOLR(G1H2(506),4,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(183),mass5set(:,1),  & 
G1H2(511),G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),2)
  call HG1shiftOLR(G1H2(512),16,2)
  call Hotf_5pt_reduction(G2H2(237),RedSet_5(73),mass5set(:,1),  & 
G1H2(517),G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),2)
  call HG1shiftOLR(G1H2(518),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(184),mass5set(:,1),  & 
G1H2(523),G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(524),16,2)
  call Hotf_5pt_reduction(G2H2(241),RedSet_5(74),mass5set(:,1),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(530),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(185),mass5set(:,1),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),2)
  call HG1shiftOLR(G1H2(536),16,2)
  call Hotf_5pt_reduction(G2H2(245),RedSet_5(75),mass5set(:,1),  & 
G1H2(541),G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(542),16,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(186),mass5set(:,1),  & 
G1H2(547),G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),2)
  call HG1shiftOLR(G1H2(548),16,2)
  call Hotf_5pt_reduction(G2H2(249),RedSet_5(76),mass5set(:,1),  & 
G1H2(553),G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),2)
  call HG1shiftOLR(G1H2(554),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(187),mass5set(:,1),  & 
G1H2(559),G1H2(560),G1H2(561),G1H2(562),G1H2(563),G1H2(564),2)
  call HG1shiftOLR(G1H2(560),16,2)
  call Hotf_5pt_reduction(G2H2(253),RedSet_5(77),mass5set(:,1),  & 
G1H2(565),G1H2(566),G1H2(567),G1H2(568),G1H2(569),G1H2(570),2)
  call HG1shiftOLR(G1H2(566),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(188),mass5set(:,1),  & 
G1H2(571),G1H2(572),G1H2(573),G1H2(574),G1H2(575),G1H2(576),2)
  call HG1shiftOLR(G1H2(572),16,2)
  call Hotf_5pt_reduction(G2H2(257),RedSet_5(78),mass5set(:,1),  & 
G1H2(577),G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),2)
  call HG1shiftOLR(G1H2(578),16,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(189),mass5set(:,1),  & 
G1H2(583),G1H2(584),G1H2(585),G1H2(586),G1H2(587),G1H2(588),2)
  call HG1shiftOLR(G1H2(584),16,2)
  call Hotf_5pt_reduction(G2H2(261),RedSet_5(79),mass5set(:,1),  & 
G1H2(589),G1H2(590),G1H2(591),G1H2(592),G1H2(593),G1H2(594),2)
  call HG1shiftOLR(G1H2(590),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(190),mass5set(:,1),  & 
G1H2(595),G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),2)
  call HG1shiftOLR(G1H2(596),16,2)
  call Hotf_5pt_reduction(G2H2(265),RedSet_5(80),mass5set(:,1),  & 
G1H2(601),G1H2(602),G1H2(603),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(602),16,2)
  call Hotf_5pt_reduction(G2H2(269),RedSet_5(81),mass5set(:,1),  & 
G1H2(607),G1H2(608),G1H2(609),G1H2(610),G1H2(611),G1H2(612),2)
  call HG1shiftOLR(G1H2(608),16,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(191),mass5set(:,1),  & 
G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(614),16,2)
  call Hotf_5pt_reduction(G2H2(273),RedSet_5(82),mass5set(:,1),  & 
G1H2(619),G1H2(620),G1H2(621),G1H2(622),G1H2(623),G1H2(624),2)
  call HG1shiftOLR(G1H2(620),16,2)
  call Hotf_5pt_reduction(G2H2(277),RedSet_5(83),mass5set(:,1),  & 
G1H2(625),G1H2(626),G1H2(627),G1H2(628),G1H2(629),G1H2(630),2)
  call HG1shiftOLR(G1H2(626),16,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(192),mass5set(:,1),  & 
G1H2(631),G1H2(632),G1H2(633),G1H2(634),G1H2(635),G1H2(636),2)
  call HG1shiftOLR(G1H2(632),16,2)
  call Hotf_5pt_reduction(G2H2(281),RedSet_5(84),mass5set(:,1),  & 
G1H2(637),G1H2(638),G1H2(639),G1H2(640),G1H2(641),G1H2(642),2)
  call HG1shiftOLR(G1H2(638),16,2)
  call Hotf_5pt_reduction(G2H2(285),RedSet_5(85),mass5set(:,1),  & 
G1H2(643),G1H2(644),G1H2(645),G1H2(646),G1H2(647),G1H2(648),2)
  call HG1shiftOLR(G1H2(644),16,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(193),mass5set(:,1),  & 
G1H2(649),G1H2(650),G1H2(651),G1H2(652),G1H2(653),G1H2(654),2)
  call HG1shiftOLR(G1H2(650),16,2)
  call Hotf_5pt_reduction(G2H2(289),RedSet_5(86),mass5set(:,1),  & 
G1H2(655),G1H2(656),G1H2(657),G1H2(658),G1H2(659),G1H2(660),2)
  call HG1shiftOLR(G1H2(656),16,2)
  call Hotf_5pt_reduction(G2H2(293),RedSet_5(87),mass5set(:,1),  & 
G1H2(661),G1H2(662),G1H2(663),G1H2(664),G1H2(665),G1H2(666),2)
  call HG1shiftOLR(G1H2(662),16,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(194),mass5set(:,1),  & 
G1H2(667),G1H2(668),G1H2(669),G1H2(670),G1H2(671),G1H2(672),2)
  call HG1shiftOLR(G1H2(668),16,2)
  call Hotf_5pt_reduction(G2H2(297),RedSet_5(88),mass5set(:,1),  & 
G1H2(673),G1H2(674),G1H2(675),G1H2(676),G1H2(677),G1H2(678),2)
  call HG1shiftOLR(G1H2(674),16,2)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(32),mass5set(:,1),  & 
G1H4(140),G1H4(141),G1H4(142),G1H4(147),G1H4(269),G1H4(449),4)
  call HG1shiftOLR(G1H4(141),17,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(31),mass5set(:,1),  & 
G1H4(159),G1H4(160),G1H4(166),G1H4(171),G1H4(109),G1H4(121),4)
  call HG1shiftOLR(G1H4(160),17,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(25),mass5set(:,1),  & 
G1H4(281),G1H4(454),G1H4(181),G1H4(193),G1H4(217),G1H4(205),4)
  call HG1shiftOLR(G1H4(454),17,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(26),mass5set(:,1),  & 
G1H4(35),G1H4(81),G1H4(83),G1H4(87),G1H4(229),G1H4(59),4)
  call HG1shiftOLR(G1H4(81),17,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(30),mass5set(:,1),  & 
G1H4(17),G1H4(64),G1H4(289),G1H4(253),G1H4(265),G1H4(71),4)
  call HG1shiftOLR(G1H4(64),18,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(29),mass5set(:,1),  & 
G1H4(75),G1H4(277),G1H4(12),G1H4(61),G1H4(13),G1H4(18),4)
  call HG1shiftOLR(G1H4(277),18,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(21),mass5set(:,1),  & 
G1H4(23),G1H4(73),G1H4(25),G1H4(30),G1H4(36),G1H4(85),4)
  call HG1shiftOLR(G1H4(73),18,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(23),mass5set(:,1),  & 
G1H4(37),G1H4(41),G1H4(47),G1H4(91),G1H4(49),G1H4(53),4)
  call HG1shiftOLR(G1H4(41),18,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(24),mass5set(:,1),  & 
G1H4(60),G1H4(65),G1H4(66),G1H4(72),G1H4(84),G1H4(89),4)
  call HG1shiftOLR(G1H4(65),20,4)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(28),mass5set(:,1),  & 
G1H4(90),G1H4(96),G1H4(107),G1H4(108),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(96),20,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(19),mass5set(:,1),  & 
G1H4(143),G1H4(144),G1H4(155),G1H4(156),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(144),20,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(17),mass5set(:,1),  & 
G1H4(191),G1H4(192),G1H4(246),G1H4(210),G1H4(211),G1H4(228),4)
  call HG1shiftOLR(G1H4(192),20,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(22),mass5set(:,1),  & 
G1H4(222),G1H4(227),G1H4(235),G1H4(239),G1H4(252),G1H4(259),4)
  call HG1shiftOLR(G1H4(227),24,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(27),mass5set(:,1),  & 
G1H4(263),G1H4(264),G1H4(276),G1H4(283),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(264),24,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(13),mass5set(:,1),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(24),G1H4(48),4)
  call HG1shiftOLR(G1H4(4),24,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(11),mass5set(:,1),  & 
G1H4(69),G1H4(54),G1H4(57),G1H4(58),G1H4(63),G1H4(62),4)
  call HG1shiftOLR(G1H4(54),24,4)
  call Hotf_4pt_reduction(G2H2(167),RedSet_4(228),mass4set(:,1),  & 
G1H2(679),G1H2(680),G1H2(681),G1H2(682),G1H2(683),2)
  call HG1shiftOLR(G1H2(680),10,2)
  call Hotf_4pt_reduction(G2H2(170),RedSet_4(233),mass4set(:,1),  & 
G1H2(684),G1H2(685),G1H2(686),G1H2(687),G1H2(688),2)
  call HG1shiftOLR(G1H2(685),9,2)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(4),mass5set(:,1),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(125),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(114),5,4)
  call Hotf_4pt_reduction(G2H4(68),RedSet_4(37),mass4set(:,1),  & 
G1H4(137),G1H4(138),G1H4(300),G1H4(301),G1H4(302),4)
  call HG1shiftOLR(G1H4(138),13,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(6),mass5set(:,1),  & 
G1H4(303),G1H4(306),G1H4(307),G1H4(149),G1H4(150),G1H4(309),4)
  call HG1shiftOLR(G1H4(306),6,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(65),mass4set(:,1),  & 
G1H4(310),G1H4(311),G1H4(312),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(311),14,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(3),mass5set(:,1),  & 
G1H4(161),G1H4(162),G1H4(318),G1H4(319),G1H4(320),G1H4(321),4)
  call HG1shiftOLR(G1H4(162),9,4)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(37),mass4set(:,1),  & 
G1H4(324),G1H4(325),G1H4(173),G1H4(174),G1H4(327),4)
  call HG1shiftOLR(G1H4(325),13,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(1),mass5set(:,1),  & 
G1H4(328),G1H4(329),G1H4(330),G1H4(333),G1H4(334),G1H4(185),4)
  call HG1shiftOLR(G1H4(329),9,4)
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(13),mass4set(:,1),  & 
G1H4(186),G1H4(336),G1H4(337),G1H4(338),G1H4(339),4)
  call HG1shiftOLR(G1H4(336),11,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(5),mass5set(:,1),  & 
G1H4(342),G1H4(343),G1H4(197),G1H4(198),G1H4(209),G1H4(293),4)
  call HG1shiftOLR(G1H4(343),10,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(65),mass4set(:,1),  & 
G1H4(347),G1H4(350),G1H4(223),G1H4(351),G1H4(221),4)
  call HG1shiftOLR(G1H4(350),14,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(2),mass5set(:,1),  & 
G1H4(434),G1H4(356),G1H4(359),G1H4(360),G1H4(361),G1H4(364),4)
  call HG1shiftOLR(G1H4(356),10,4)
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(13),mass4set(:,1),  & 
G1H4(365),G1H4(366),G1H4(369),G1H4(370),G1H4(371),4)
  call HG1shiftOLR(G1H4(366),11,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(171),ex4(:),G2tensor(69),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(173),ex4(:),G2tensor(70),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(174),ex4(:),G2tensor(71),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(176),ex4(:),G2tensor(72),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(177),ex4(:),G2tensor(73),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(179),ex4(:),G2tensor(74),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(180),ex3(:),G2tensor(75),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(182),ex3(:),G2tensor(76),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(183),ex4(:),G2tensor(77),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(185),ex4(:),G2tensor(78),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(186),ex3(:),G2tensor(79),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(188),ex3(:),G2tensor(80),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(189),ex2(:),G2tensor(81),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(191),ex2(:),G2tensor(82),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(192),ex2(:),G2tensor(83),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(194),ex2(:),G2tensor(84),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(195),ex4(:),G2tensor(85),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(197),ex4(:),G2tensor(86),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(198),ex3(:),G2tensor(87),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(200),ex3(:),G2tensor(88),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(201),ex4(:),G2tensor(89),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(203),ex4(:),G2tensor(90),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(204),ex3(:),G2tensor(91),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(206),ex3(:),G2tensor(92),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(207),ex4(:),G2tensor(93),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(209),ex4(:),G2tensor(94),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(210),ex4(:),G2tensor(95),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(212),ex4(:),G2tensor(96),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(213),ex1(:),G2tensor(97),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(215),ex1(:),G2tensor(98),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(216),ex4(:),G2tensor(99),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(218),ex4(:),G2tensor(100),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(219),ex2(:),G2tensor(101),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(221),ex2(:),G2tensor(102),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(222),ex2(:),G2tensor(103),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(224),ex2(:),G2tensor(104),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(225),ex1(:),G2tensor(105),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(227),ex1(:),G2tensor(106),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(228),ex3(:),G2tensor(107),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(230),ex3(:),G2tensor(108),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(231),ex2(:),G2tensor(109),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(233),ex2(:),G2tensor(110),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(234),ex3(:),G2tensor(111),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(236),ex3(:),G2tensor(112),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hotf_4pt_reduction(G2H2(240),RedSet_4(251),mass4set(:,1),  & 
G1H2(689),G1H2(690),G1H2(691),G1H2(692),G1H2(693),2)
  call HG1shiftOLR(G1H2(690),18,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(126),mass4set(:,1),  & 
G1H2(694),G1H2(695),G1H2(696),G1H2(697),G1H2(698),2)
  call HG1shiftOLR(G1H2(695),24,2)
  call Hotf_4pt_reduction(G2H2(248),RedSet_4(273),mass4set(:,1),  & 
G1H2(699),G1H2(700),G1H2(701),G1H2(702),G1H2(703),2)
  call HG1shiftOLR(G1H2(700),18,2)
  call Hotf_4pt_reduction(G2H2(252),RedSet_4(162),mass4set(:,1),  & 
G1H2(704),G1H2(705),G1H2(706),G1H2(707),G1H2(708),2)
  call HG1shiftOLR(G1H2(705),20,2)
  call Hotf_4pt_reduction(G2H2(256),RedSet_4(292),mass4set(:,1),  & 
G1H2(709),G1H2(710),G1H2(711),G1H2(712),G1H2(713),2)
  call HG1shiftOLR(G1H2(710),17,2)
  call Hotf_4pt_reduction(G2H2(260),RedSet_4(298),mass4set(:,1),  & 
G1H2(714),G1H2(715),G1H2(716),G1H2(717),G1H2(718),2)
  call HG1shiftOLR(G1H2(715),17,2)
  call Hotf_4pt_reduction(G2H2(264),RedSet_4(135),mass4set(:,1),  & 
G1H2(719),G1H2(720),G1H2(721),G1H2(722),G1H2(723),2)
  call HG1shiftOLR(G1H2(720),24,2)
  call Hotf_4pt_reduction(G2H2(268),RedSet_4(175),mass4set(:,1),  & 
G1H2(724),G1H2(725),G1H2(726),G1H2(727),G1H2(728),2)
  call HG1shiftOLR(G1H2(725),20,2)
  call Hotf_4pt_reduction(G2H2(272),RedSet_4(185),mass4set(:,1),  & 
G1H2(729),G1H2(730),G1H2(731),G1H2(732),G1H2(733),2)
  call HG1shiftOLR(G1H2(730),18,2)
  call Hotf_4pt_reduction(G2H2(276),RedSet_4(117),mass4set(:,1),  & 
G1H2(734),G1H2(735),G1H2(736),G1H2(737),G1H2(738),2)
  call HG1shiftOLR(G1H2(735),24,2)
  call Hotf_4pt_reduction(G2H2(280),RedSet_4(147),mass4set(:,1),  & 
G1H2(739),G1H2(740),G1H2(741),G1H2(742),G1H2(743),2)
  call HG1shiftOLR(G1H2(740),18,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(160),mass4set(:,1),  & 
G1H2(744),G1H2(745),G1H2(746),G1H2(747),G1H2(748),2)
  call HG1shiftOLR(G1H2(745),20,2)
  call Hotf_4pt_reduction(G2H2(288),RedSet_4(342),mass4set(:,1),  & 
G1H2(749),G1H2(750),G1H2(751),G1H2(752),G1H2(753),2)
  call HG1shiftOLR(G1H2(750),17,2)
  call Hotf_4pt_reduction(G2H2(292),RedSet_4(105),mass4set(:,1),  & 
G1H2(754),G1H2(755),G1H2(756),G1H2(757),G1H2(758),2)
  call HG1shiftOLR(G1H2(755),24,2)
  call Hotf_4pt_reduction(G2H2(296),RedSet_4(355),mass4set(:,1),  & 
G1H2(759),G1H2(760),G1H2(761),G1H2(762),G1H2(763),2)
  call HG1shiftOLR(G1H2(760),17,2)
  call Hotf_4pt_reduction(G2H2(300),RedSet_4(173),mass4set(:,1),  & 
G1H2(764),G1H2(765),G1H2(766),G1H2(767),G1H2(768),2)
  call HG1shiftOLR(G1H2(765),20,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(301),ex4(:),G2tensor(113),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(303),ex4(:),G2tensor(114),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(304),ex4(:),G2tensor(115),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(306),ex4(:),G2tensor(116),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(307),ex4(:),G2tensor(117),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(309),ex4(:),G2tensor(118),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(310),ex4(:),G2tensor(119),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(312),ex4(:),G2tensor(120),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(313),ex4(:),G2tensor(121),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(315),ex4(:),G2tensor(122),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(316),ex4(:),G2tensor(123),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(318),ex4(:),G2tensor(124),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(319),ex3(:),G2tensor(125),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(321),ex3(:),G2tensor(126),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(322),ex3(:),G2tensor(127),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(324),ex3(:),G2tensor(128),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(325),ex4(:),G2tensor(129),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(327),ex4(:),G2tensor(130),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(328),ex4(:),G2tensor(131),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(330),ex4(:),G2tensor(132),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(331),ex3(:),G2tensor(133),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(333),ex3(:),G2tensor(134),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(334),ex3(:),G2tensor(135),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(336),ex3(:),G2tensor(136),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(337),ex2(:),G2tensor(137),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(339),ex2(:),G2tensor(138),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(340),ex2(:),G2tensor(139),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(342),ex2(:),G2tensor(140),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(343),ex2(:),G2tensor(141),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(345),ex2(:),G2tensor(142),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(346),ex2(:),G2tensor(143),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(348),ex2(:),G2tensor(144),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(349),ex4(:),G2tensor(145),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(351),ex4(:),G2tensor(146),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(353),ex4(:),G2tensor(147),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(355),ex4(:),G2tensor(148),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(357),ex4(:),G2tensor(149),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(359),ex4(:),G2tensor(150),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(361),ex4(:),G2tensor(151),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(363),ex4(:),G2tensor(152),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(365),ex2(:),G2tensor(153),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(367),ex2(:),G2tensor(154),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(368),ex2(:),G2tensor(155),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(370),ex2(:),G2tensor(156),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(371),ex3(:),G2tensor(157),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(373),ex3(:),G2tensor(158),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(374),ex3(:),G2tensor(159),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(376),ex3(:),G2tensor(160),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(378),ex3(:),G2tensor(161),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(380),ex3(:),G2tensor(162),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(381),ex3(:),G2tensor(163),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(383),ex3(:),G2tensor(164),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(385),ex2(:),G2tensor(165),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(387),ex2(:),G2tensor(166),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(388),ex2(:),G2tensor(167),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(390),ex2(:),G2tensor(168),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hotf_5pt_reduction(G2H4(104),RedSet_5(12),mass5set(:,1),  & 
G1H4(374),G1H4(375),G1H4(376),G1H4(379),G1H4(380),G1H4(381),4)
  call HG1shiftOLR(G1H4(375),5,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(164),mass4set(:,1),  & 
G1H4(384),G1H4(385),G1H4(386),G1H4(387),G1H4(390),4)
  call HG1shiftOLR(G1H4(385),21,4)
  call Hotf_4pt_reduction(G2H2(394),RedSet_4(164),mass4set(:,1),  & 
G1H2(769),G1H2(770),G1H2(771),G1H2(772),G1H2(773),2)
  call HG1shiftOLR(G1H2(770),21,2)
  call Hotf_4pt_reduction(G2H2(397),RedSet_4(344),mass4set(:,1),  & 
G1H2(774),G1H2(775),G1H2(776),G1H2(777),G1H2(778),2)
  call HG1shiftOLR(G1H2(775),21,2)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(18),mass5set(:,1),  & 
G1H4(391),G1H4(257),G1H4(258),G1H4(393),G1H4(394),G1H4(395),4)
  call HG1shiftOLR(G1H4(257),6,4)
  call Hotf_4pt_reduction(G2H4(151),RedSet_4(177),mass4set(:,1),  & 
G1H4(396),G1H4(399),G1H4(400),G1H4(270),G1H4(403),4)
  call HG1shiftOLR(G1H4(399),22,4)
  call Hotf_4pt_reduction(G2H2(401),RedSet_4(177),mass4set(:,1),  & 
G1H2(779),G1H2(780),G1H2(781),G1H2(782),G1H2(783),2)
  call HG1shiftOLR(G1H2(780),22,2)
  call Hotf_4pt_reduction(G2H2(404),RedSet_4(319),mass4set(:,1),  & 
G1H2(784),G1H2(785),G1H2(786),G1H2(787),G1H2(788),2)
  call HG1shiftOLR(G1H2(785),22,2)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(119),mass5set(:,1),  & 
G1H4(404),G1H4(405),G1H4(408),G1H4(409),G1H4(410),G1H4(411),4)
  call HG1shiftOLR(G1H4(405),9,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(119),mass4set(:,1),  & 
G1H4(414),G1H4(415),G1H4(282),G1H4(418),G1H4(419),4)
  call HG1shiftOLR(G1H4(415),25,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(16),mass5set(:,1),  & 
G1H4(420),G1H4(423),G1H4(424),G1H4(425),G1H4(426),G1H4(429),4)
  call HG1shiftOLR(G1H4(423),9,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(128),mass4set(:,1),  & 
G1H4(430),G1H4(38),G1H4(39),G1H4(93),G1H4(98),4)
  call HG1shiftOLR(G1H4(38),25,4)
  call Hotf_4pt_reduction(G2H2(409),RedSet_4(128),mass4set(:,1),  & 
G1H2(789),G1H2(790),G1H2(791),G1H2(792),G1H2(793),2)
  call HG1shiftOLR(G1H2(790),25,2)
  call Hotf_4pt_reduction(G2H2(412),RedSet_4(119),mass4set(:,1),  & 
G1H2(794),G1H2(795),G1H2(796),G1H2(797),G1H2(798),2)
  call HG1shiftOLR(G1H2(795),25,2)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(122),mass5set(:,1),  & 
G1H4(153),G1H4(154),G1H4(157),G1H4(169),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(154),10,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(109),mass4set(:,1),  & 
G1H4(354),G1H4(355),G1H4(172),G1H4(176),G1H4(183),4)
  call HG1shiftOLR(G1H4(355),26,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(14),mass5set(:,1),  & 
G1H4(184),G1H4(188),G1H4(189),G1H4(196),G1H4(200),G1H4(201),4)
  call HG1shiftOLR(G1H4(188),10,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(137),mass4set(:,1),  & 
G1H4(202),G1H4(212),G1H4(213),G1H4(214),G1H4(219),4)
  call HG1shiftOLR(G1H4(212),26,4)
  call Hotf_4pt_reduction(G2H2(417),RedSet_4(137),mass4set(:,1),  & 
G1H2(799),G1H2(800),G1H2(801),G1H2(802),G1H2(803),2)
  call HG1shiftOLR(G1H2(800),26,2)
  call Hotf_4pt_reduction(G2H2(420),RedSet_4(109),mass4set(:,1),  & 
G1H2(804),G1H2(805),G1H2(806),G1H2(807),G1H2(808),2)
  call HG1shiftOLR(G1H2(805),26,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(83),wf4(:,12),G2tensor(169),m3h4x1(:,1),heltab2x4(:,:,523))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(84),wf4(:,12),G2tensor(170),m3h4x1(:,2),heltab2x4(:,:,524))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(25),wf4(:,12),G2tensor(171),m3h4x1(:,3),heltab2x4(:,:,525))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(28),wf4(:,12),G2tensor(172),m3h4x1(:,4),heltab2x4(:,:,526))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(87),wf4(:,12),G2tensor(173),m3h4x1(:,5),heltab2x4(:,:,527))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(90),wf4(:,12),G2tensor(174),m3h4x1(:,6),heltab2x4(:,:,528))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(34),wf4(:,12),G2tensor(175),m3h4x1(:,7),heltab2x4(:,:,529))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(37),wf4(:,12),G2tensor(176),m3h4x1(:,8),heltab2x4(:,:,530))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(93),wf4(:,4),G2tensor(177),m3h4x1(:,9),heltab2x4(:,:,531))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(115),wf4(:,4),G2tensor(178),m3h4x1(:,10),heltab2x4(:,:,532))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(117),wf4(:,4),G2tensor(179),m3h4x1(:,11),heltab2x4(:,:,533))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(121),wf4(:,4),G2tensor(180),m3h4x1(:,12),heltab2x4(:,:,534))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(51),wf4(:,4),G2tensor(181),m3h4x1(:,13),heltab2x4(:,:,535))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(58),wf4(:,4),G2tensor(182),m3h4x1(:,14),heltab2x4(:,:,536))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(141),wf4(:,4),G2tensor(183),m3h4x1(:,15),heltab2x4(:,:,537))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(63),wf4(:,4),G2tensor(184),m3h4x1(:,16),heltab2x4(:,:,538))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(66),wf4(:,19),G2tensor(185),m3h4x1(:,17),heltab2x4(:,:,539))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(147),wf4(:,19),G2tensor(186),m3h4x1(:,18),heltab2x4(:,:,540))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(73),wf4(:,19),G2tensor(187),m3h4x1(:,19),heltab2x4(:,:,541))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(153),wf4(:,19),G2tensor(188),m3h4x1(:,20),heltab2x4(:,:,542))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(77),wf4(:,19),G2tensor(189),m3h4x1(:,21),heltab2x4(:,:,543))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(17),wf4(:,19),G2tensor(190),m3h4x1(:,22),heltab2x4(:,:,544))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(20),wf4(:,19),G2tensor(191),m3h4x1(:,23),heltab2x4(:,:,545))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(26),wf4(:,19),G2tensor(192),m3h4x1(:,24),heltab2x4(:,:,546))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(29),wf4(:,9),G2tensor(193),m3h4x1(:,25),heltab2x4(:,:,547))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(35),wf4(:,9),G2tensor(194),m3h4x1(:,26),heltab2x4(:,:,548))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(38),wf4(:,9),G2tensor(195),m3h4x1(:,27),heltab2x4(:,:,549))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(46),wf4(:,9),G2tensor(196),m3h4x1(:,28),heltab2x4(:,:,550))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(47),wf4(:,9),G2tensor(197),m3h4x1(:,29),heltab2x4(:,:,551))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(54),wf4(:,9),G2tensor(198),m3h4x1(:,30),heltab2x4(:,:,552))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(55),wf4(:,9),G2tensor(199),m3h4x1(:,31),heltab2x4(:,:,553))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(65),wf4(:,9),G2tensor(200),m3h4x1(:,32),heltab2x4(:,:,554))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(784),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(789),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(804),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(769),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(774),[G1H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(799),[G1H2(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(794),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(779),[G1H2(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(679),[G1H2(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(684),[G1H2(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(689),[G1H2(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(694),[G1H2(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(699),[G1H2(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(704),[G1H2(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(709),[G1H2(570)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(714),[G1H2(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(719),[G1H2(594)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(724),[G1H2(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(729),[G1H2(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(734),[G1H2(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(739),[G1H2(630)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(744),[G1H2(642)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(749),[G1H2(648)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(754),[G1H2(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(759),[G1H2(666)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(764),[G1H2(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(310),[G1H4(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(324),[G1H4(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(347),[G1H4(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(365),[G1H4(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(384),[G1H4(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(414),[G1H4(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(430),[G1H4(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(354),[G1H4(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(201)])
  call Hloop_VA_Q(ntryL,G1H2(207),ex4(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(202),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(205),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(206),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(208),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(211),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(170),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(212),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(213),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(214),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(216),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(217),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(218),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(219),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(220),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(221),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(89),ex3(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(223),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(29),ex2(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(225),n2h1(89))
  call Hloop_VQ_A(ntryL,G1H2(101),ex2(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(226),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(37),ex2(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(228),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(229),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(232),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(234),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(235),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(79),ex2(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(96),ex2(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(238),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H2(120),ex2(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(241),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(242),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(244),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(245),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(157),ex1(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H2(109),ex1(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(247),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H2(119),ex1(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(248),n2h1(112))
  call Hloop_VQ_A(ntryL,G1H2(163),ex1(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(113))
  call Hloop_VQ_A(ntryL,G1H2(121),ex1(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(250),n2h1(114))
  call Hloop_VQ_A(ntryL,G1H2(132),ex1(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(251),n2h1(115))
  call Hloop_VA_Q(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(252),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(253),n2h1(117))
  call Hloop_VA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(254),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(161),ex5(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(255),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(256),n2h1(120))
  call Hloop_AV_Q(ntryL,G1H2(208),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(257),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(209),ex3(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(258),n2h1(122))
  call Hloop_VA_Q(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(259),n2h1(123))
  call Hloop_VA_Q(ntryL,G1H2(214),ex3(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(260),n2h1(124))
  call Hloop_VQ_A(ntryL,G1H2(215),ex2(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(261),n2h1(125))
  call Hloop_VQ_A(ntryL,G1H2(216),ex2(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(262),n2h1(126))
  call Hloop_VQ_A(ntryL,G1H2(220),ex2(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(263),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(221),ex5(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(264),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(265),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(784),ex5(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(267),n2h1(131))
  call Hloop_VA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(268),n2h1(132))
  call Hloop_VA_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(233),ex5(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(270),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(271),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(789),ex5(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(239),ex2(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(240),ex2(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(274),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(244),ex2(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(245),ex5(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(276),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(277),n2h1(141))
  call Hloop_QV_A(ntryL,G1H2(804),ex5(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(142))
  call Hloop_VA_Q(ntryL,G1H2(251),ex3(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(279),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(252),ex3(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(280),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(256),ex3(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(145))
  call Hloop_AV_Q(ntryL,G1H2(257),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(282),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(283),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H2(769),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(263),ex1(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(285),n2h1(149))
  call Hloop_VQ_A(ntryL,G1H2(264),ex1(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(286),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(268),ex1(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(269),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(288),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(270),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(289),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(774),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(154))
  call Hloop_VA_Q(ntryL,G1H2(275),ex4(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(291),n2h1(155))
  call Hloop_VA_Q(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(292),n2h1(156))
  call Hloop_VA_Q(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(157))
  call Hloop_AV_Q(ntryL,G1H2(281),ex5(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(294),n2h1(158))
  call Hloop_AV_Q(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(295),n2h1(159))
  call Hloop_AV_Q(ntryL,G1H2(799),ex5(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H2(287),ex1(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(297),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H2(288),ex1(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(298),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H2(292),ex1(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(293),ex5(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(300),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(294),ex5(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(301),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(794),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(166))
  call Hloop_VA_Q(ntryL,G1H2(299),ex3(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(303),n2h1(167))
  call Hloop_VA_Q(ntryL,G1H2(300),ex3(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(304),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(304),ex3(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(169))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(306),n2h1(170))
  call Hloop_AV_Q(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(307),n2h1(171))
  call Hloop_AV_Q(ntryL,G1H2(779),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(308),n2h1(172))
  call Hloop_VQ_A(ntryL,G1H2(311),ex1(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(309),n2h1(173))
  call Hloop_VQ_A(ntryL,G1H2(312),ex1(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(310),n2h1(174))
  call Hloop_VQ_A(ntryL,G1H2(316),ex1(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(311),n2h1(175))
  call Hloop_VQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(312),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(317),ex2(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(313),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(321),ex2(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(178))
  call Hloop_VQ_A(ntryL,G1H2(4),ex1(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(315),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H2(322),ex1(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(316),n2h1(180))
  call Hloop_VQ_A(ntryL,G1H2(326),ex1(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(181))
  call Hloop_VQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(318),n2h1(182))
  call Hloop_VQ_A(ntryL,G1H2(327),ex1(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(319),n2h1(183))
  call Hloop_VQ_A(ntryL,G1H2(331),ex1(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(320),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(321),n2h1(185))
  call Hloop_VQ_A(ntryL,G1H2(332),ex2(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(322),n2h1(186))
  call Hloop_VQ_A(ntryL,G1H2(336),ex2(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(187))
  call Hloop_VQ_A(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(324),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H2(337),ex2(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(325),n2h1(189))
  call Hloop_VQ_A(ntryL,G1H2(341),ex2(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(190))
  call Hloop_VA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(327),n2h1(191))
  call Hloop_VA_Q(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(328),n2h1(192))
  call Hloop_VA_Q(ntryL,G1H2(346),ex3(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(193))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(330),n2h1(194))
  call Hloop_VA_Q(ntryL,G1H2(347),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(331),n2h1(195))
  call Hloop_VA_Q(ntryL,G1H2(351),ex4(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(196))
  call Hloop_QV_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(333),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(352),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(334),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(356),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(199))
  call Hloop_QV_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(336),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(357),ex5(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(337),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(339),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(340),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(342),n2h1(206))
  call Hloop_QV_A(ntryL,G1H2(367),ex5(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(343),n2h1(207))
  call Hloop_QV_A(ntryL,G1H2(371),ex5(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(345),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(372),ex5(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(346),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(376),ex5(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(211))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(348),n2h1(212))
  call Hloop_QV_A(ntryL,G1H2(377),ex5(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(349),n2h1(213))
  call Hloop_QV_A(ntryL,G1H2(381),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(214))
  call Hloop_QV_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(351),n2h1(215))
  call Hloop_QV_A(ntryL,G1H2(382),ex5(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(352),n2h1(216))
  call Hloop_QV_A(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(354),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(355),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(220))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(357),n2h1(221))
  call Hloop_VA_Q(ntryL,G1H2(392),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(358),n2h1(222))
  call Hloop_VA_Q(ntryL,G1H2(396),ex4(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(223))
  call Hloop_VA_Q(ntryL,G1H2(397),ex4(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(360),n2h1(224))
  call Hloop_VA_Q(ntryL,G1H2(398),ex4(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(361),n2h1(225))
  call Hloop_VA_Q(ntryL,G1H2(402),ex4(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(226))
  call Hloop_VA_Q(ntryL,G1H2(403),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(363),n2h1(227))
  call Hloop_VA_Q(ntryL,G1H2(404),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(364),n2h1(228))
  call Hloop_VA_Q(ntryL,G1H2(408),ex3(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H2(409),ex3(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(366),n2h1(230))
  call Hloop_VA_Q(ntryL,G1H2(410),ex3(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(367),n2h1(231))
  call Hloop_VA_Q(ntryL,G1H2(414),ex3(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(232))
  call Hloop_VA_Q(ntryL,G1H2(415),ex4(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(369),n2h1(233))
  call Hloop_VA_Q(ntryL,G1H2(416),ex4(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(370),n2h1(234))
  call Hloop_VA_Q(ntryL,G1H2(420),ex4(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(235))
  call Hloop_VA_Q(ntryL,G1H2(421),ex4(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(372),n2h1(236))
  call Hloop_VA_Q(ntryL,G1H2(422),ex4(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(373),n2h1(237))
  call Hloop_VA_Q(ntryL,G1H2(426),ex4(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(238))
  call Hloop_VA_Q(ntryL,G1H2(427),ex3(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(375),n2h1(239))
  call Hloop_VA_Q(ntryL,G1H2(428),ex3(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(376),n2h1(240))
  call Hloop_VA_Q(ntryL,G1H2(432),ex3(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(241))
  call Hloop_VA_Q(ntryL,G1H2(433),ex3(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(378),n2h1(242))
  call Hloop_VA_Q(ntryL,G1H2(434),ex3(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(379),n2h1(243))
  call Hloop_VA_Q(ntryL,G1H2(438),ex3(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(380),n2h1(244))
  call Hloop_VA_Q(ntryL,G1H2(439),ex3(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(381),n2h1(245))
  call Hloop_VA_Q(ntryL,G1H2(440),ex3(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(382),n2h1(246))
  call Hloop_VA_Q(ntryL,G1H2(444),ex3(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(383),n2h1(247))
  call Hloop_VA_Q(ntryL,G1H2(445),ex3(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(384),n2h1(248))
  call Hloop_VA_Q(ntryL,G1H2(446),ex3(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(385),n2h1(249))
  call Hloop_VA_Q(ntryL,G1H2(450),ex3(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(386),n2h1(250))
  call Hloop_VA_Q(ntryL,G1H2(451),ex3(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(387),n2h1(251))
  call Hloop_VA_Q(ntryL,G1H2(452),ex3(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(388),n2h1(252))
  call Hloop_VA_Q(ntryL,G1H2(456),ex3(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(389),n2h1(253))
  call Hloop_VA_Q(ntryL,G1H2(457),ex4(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(390),n2h1(254))
  call Hloop_VA_Q(ntryL,G1H2(458),ex4(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(391),n2h1(255))
  call Hloop_VA_Q(ntryL,G1H2(462),ex4(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(392),n2h1(256))
  call Hloop_VA_Q(ntryL,G1H2(463),ex4(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(393),n2h1(257))
  call Hloop_VA_Q(ntryL,G1H2(464),ex4(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(394),n2h1(258))
  call Hloop_VA_Q(ntryL,G1H2(679),ex4(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(395),n2h1(259))
  call Hloop_VA_Q(ntryL,G1H2(469),ex4(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(396),n2h1(260))
  call Hloop_VA_Q(ntryL,G1H2(470),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(397),n2h1(261))
  call Hloop_VA_Q(ntryL,G1H2(474),ex4(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(398),n2h1(262))
  call Hloop_VA_Q(ntryL,G1H2(475),ex4(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(399),n2h1(263))
  call Hloop_VA_Q(ntryL,G1H2(476),ex4(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(400),n2h1(264))
  call Hloop_VA_Q(ntryL,G1H2(480),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(401),n2h1(265))
  call Hloop_VA_Q(ntryL,G1H2(481),ex4(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(402),n2h1(266))
  call Hloop_VA_Q(ntryL,G1H2(482),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(403),n2h1(267))
  call Hloop_VA_Q(ntryL,G1H2(684),ex4(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(404),n2h1(268))
  call Hloop_VA_Q(ntryL,G1H2(487),ex4(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(405),n2h1(269))
  call Hloop_VA_Q(ntryL,G1H2(488),ex4(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(406),n2h1(270))
  call Hloop_VA_Q(ntryL,G1H2(492),ex4(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(407),n2h1(271))
  call Hloop_VA_Q(ntryL,G1H2(493),ex3(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(408),n2h1(272))
  call Hloop_VA_Q(ntryL,G1H2(494),ex3(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(409),n2h1(273))
  call Hloop_VA_Q(ntryL,G1H2(498),ex3(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(410),n2h1(274))
  call Hloop_VA_Q(ntryL,G1H2(499),ex3(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(411),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H2(500),ex3(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(412),n2h1(276))
  call Hloop_VA_Q(ntryL,G1H2(504),ex3(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(413),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H2(505),ex3(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(414),n2h1(278))
  call Hloop_VA_Q(ntryL,G1H2(506),ex3(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(415),n2h1(279))
  call Hloop_VA_Q(ntryL,G1H2(510),ex3(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(416),n2h1(280))
  call Hloop_QV_A(ntryL,G1H2(511),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(417),n2h1(281))
  call Hloop_QV_A(ntryL,G1H2(512),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(418),n2h1(282))
  call Hloop_QV_A(ntryL,G1H2(516),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(419),n2h1(283))
  call Hloop_QV_A(ntryL,G1H2(517),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(420),n2h1(284))
  call Hloop_QV_A(ntryL,G1H2(518),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(421),n2h1(285))
  call Hloop_QV_A(ntryL,G1H2(689),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(422),n2h1(286))
  call Hloop_AV_Q(ntryL,G1H2(523),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(423),n2h1(287))
  call Hloop_AV_Q(ntryL,G1H2(524),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(424),n2h1(288))
  call Hloop_AV_Q(ntryL,G1H2(528),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(425),n2h1(289))
  call Hloop_AV_Q(ntryL,G1H2(529),ex5(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(426),n2h1(290))
  call Hloop_AV_Q(ntryL,G1H2(530),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(427),n2h1(291))
  call Hloop_AV_Q(ntryL,G1H2(694),ex5(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(428),n2h1(292))
  call Hloop_QV_A(ntryL,G1H2(535),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(429),n2h1(293))
  call Hloop_QV_A(ntryL,G1H2(536),ex5(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(430),n2h1(294))
  call Hloop_QV_A(ntryL,G1H2(540),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(431),n2h1(295))
  call Hloop_QV_A(ntryL,G1H2(541),ex5(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(432),n2h1(296))
  call Hloop_QV_A(ntryL,G1H2(542),ex5(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(433),n2h1(297))
  call Hloop_QV_A(ntryL,G1H2(699),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H2(547),ex5(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(435),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(548),ex5(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(436),n2h1(300))
  call Hloop_AV_Q(ntryL,G1H2(552),ex5(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(437),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(553),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(438),n2h1(302))
  call Hloop_AV_Q(ntryL,G1H2(554),ex5(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(439),n2h1(303))
  call Hloop_AV_Q(ntryL,G1H2(704),ex5(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(440),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(559),ex5(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(441),n2h1(305))
  call Hloop_QV_A(ntryL,G1H2(560),ex5(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(442),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(564),ex5(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(565),ex5(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(444),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(566),ex5(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(445),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(709),ex5(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(446),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(571),ex5(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(447),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(572),ex5(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(448),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(576),ex5(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(449),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(577),ex5(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(450),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(578),ex5(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(451),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(714),ex5(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(452),n2h1(316))
  call Hloop_AV_Q(ntryL,G1H2(583),ex5(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(453),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(584),ex5(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(454),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(588),ex5(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(455),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H2(589),ex5(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(456),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H2(590),ex5(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(457),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(719),ex5(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(458),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(595),ex5(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(459),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(596),ex5(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(460),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(600),ex5(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(461),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H2(601),ex5(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(462),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(602),ex5(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(463),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(724),ex5(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(464),n2h1(328))
  call Hloop_QV_A(ntryL,G1H2(607),ex5(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(465),n2h1(329))
  call Hloop_QV_A(ntryL,G1H2(608),ex5(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(466),n2h1(330))
  call Hloop_QV_A(ntryL,G1H2(729),ex5(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(467),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(613),ex5(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(468),n2h1(332))
  call Hloop_AV_Q(ntryL,G1H2(614),ex5(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(469),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(618),ex5(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(470),n2h1(334))
  call Hloop_AV_Q(ntryL,G1H2(619),ex5(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(471),n2h1(335))
  call Hloop_AV_Q(ntryL,G1H2(620),ex5(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(472),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H2(734),ex5(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(473),n2h1(337))
  call Hloop_QV_A(ntryL,G1H2(625),ex5(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(474),n2h1(338))
  call Hloop_QV_A(ntryL,G1H2(626),ex5(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(475),n2h1(339))
  call Hloop_QV_A(ntryL,G1H2(739),ex5(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(476),n2h1(340))
  call Hloop_AV_Q(ntryL,G1H2(631),ex5(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(477),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(632),ex5(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(478),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(636),ex5(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(479),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(637),ex5(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(480),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(638),ex5(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(481),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(744),ex5(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(482),n2h1(346))
  call Hloop_QV_A(ntryL,G1H2(643),ex5(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(483),n2h1(347))
  call Hloop_QV_A(ntryL,G1H2(644),ex5(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(484),n2h1(348))
  call Hloop_QV_A(ntryL,G1H2(749),ex5(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(485),n2h1(349))
  call Hloop_AV_Q(ntryL,G1H2(649),ex5(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(486),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(650),ex5(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(487),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(654),ex5(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(488),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(655),ex5(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(489),n2h1(353))
  call Hloop_AV_Q(ntryL,G1H2(656),ex5(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(490),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H2(754),ex5(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(491),n2h1(355))
  call Hloop_QV_A(ntryL,G1H2(661),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(492),n2h1(356))
  call Hloop_QV_A(ntryL,G1H2(662),ex5(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(493),n2h1(357))
  call Hloop_QV_A(ntryL,G1H2(759),ex5(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(494),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(667),ex5(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(495),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H2(668),ex5(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(496),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H2(672),ex5(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(497),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H2(673),ex5(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(498),n2h1(362))
  call Hloop_AV_Q(ntryL,G1H2(674),ex5(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(499),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H2(764),ex5(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(500),n2h1(364))
  call Hloop_VQ_A(ntryL,G1H4(140),wf4(:,12),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,555))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(501),n2h1(365))
  call Hloop_VQ_A(ntryL,G1H4(141),wf4(:,12),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,556))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(502),n2h1(366))
  call Hloop_VQ_A(ntryL,G1H4(449),wf4(:,12),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(503),n2h1(367))
  call Hloop_VQ_A(ntryL,G1H4(159),wf4(:,12),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(504),n2h1(368))
  call Hloop_VQ_A(ntryL,G1H4(160),wf4(:,12),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(505),n2h1(369))
  call Hloop_VQ_A(ntryL,G1H4(121),wf4(:,12),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(506),n2h1(370))
  call Hloop_VQ_A(ntryL,G1H4(281),wf4(:,12),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(507),n2h1(371))
  call Hloop_VQ_A(ntryL,G1H4(454),wf4(:,12),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(508),n2h1(372))
  call Hloop_VQ_A(ntryL,G1H4(205),wf4(:,12),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(509),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H4(35),wf4(:,12),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(510),n2h1(374))
  call Hloop_VQ_A(ntryL,G1H4(81),wf4(:,12),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(511),n2h1(375))
  call Hloop_VQ_A(ntryL,G1H4(59),wf4(:,12),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(512),n2h1(376))
  call Hloop_VQ_A(ntryL,G1H4(17),wf4(:,4),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(513),n2h1(377))
  call Hloop_VQ_A(ntryL,G1H4(64),wf4(:,4),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(514),n2h1(378))
  call Hloop_VQ_A(ntryL,G1H4(71),wf4(:,4),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(515),n2h1(379))
  call Hloop_VQ_A(ntryL,G1H4(75),wf4(:,4),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(516),n2h1(380))
  call Hloop_VQ_A(ntryL,G1H4(277),wf4(:,4),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(517),n2h1(381))
  call Hloop_VQ_A(ntryL,G1H4(18),wf4(:,4),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(518),n2h1(382))
  call Hloop_VQ_A(ntryL,G1H4(23),wf4(:,4),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(519),n2h1(383))
  call Hloop_VQ_A(ntryL,G1H4(73),wf4(:,4),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(520),n2h1(384))
  call Hloop_VQ_A(ntryL,G1H4(85),wf4(:,4),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(521),n2h1(385))
  call Hloop_VQ_A(ntryL,G1H4(37),wf4(:,4),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(522),n2h1(386))
  call Hloop_VQ_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(523),n2h1(387))
  call Hloop_VQ_A(ntryL,G1H4(53),wf4(:,4),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(524),n2h1(388))
  call Hloop_VA_Q(ntryL,G1H4(60),wf4(:,19),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,579))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(525),n2h1(389))
  call Hloop_VA_Q(ntryL,G1H4(65),wf4(:,19),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(526),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H4(89),wf4(:,19),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(527),n2h1(391))
  call Hloop_VA_Q(ntryL,G1H4(90),wf4(:,19),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(528),n2h1(392))
  call Hloop_VA_Q(ntryL,G1H4(96),wf4(:,19),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(529),n2h1(393))
  call Hloop_VA_Q(ntryL,G1H4(120),wf4(:,19),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(530),n2h1(394))
  call Hloop_VA_Q(ntryL,G1H4(143),wf4(:,19),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(531),n2h1(395))
  call Hloop_VA_Q(ntryL,G1H4(144),wf4(:,19),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,586))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(532),n2h1(396))
  call Hloop_VA_Q(ntryL,G1H4(180),wf4(:,19),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,587))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(533),n2h1(397))
  call Hloop_VA_Q(ntryL,G1H4(191),wf4(:,19),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(534),n2h1(398))
  call Hloop_VA_Q(ntryL,G1H4(192),wf4(:,19),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,589))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(535),n2h1(399))
  call Hloop_VA_Q(ntryL,G1H4(228),wf4(:,19),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(536),n2h1(400))
  call Hloop_VA_Q(ntryL,G1H4(222),wf4(:,9),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,591))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(537),n2h1(401))
  call Hloop_VA_Q(ntryL,G1H4(227),wf4(:,9),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(538),n2h1(402))
  call Hloop_VA_Q(ntryL,G1H4(259),wf4(:,9),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,593))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(539),n2h1(403))
  call Hloop_VA_Q(ntryL,G1H4(263),wf4(:,9),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,594))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(540),n2h1(404))
  call Hloop_VA_Q(ntryL,G1H4(264),wf4(:,9),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(541),n2h1(405))
  call Hloop_VA_Q(ntryL,G1H4(288),wf4(:,9),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(542),n2h1(406))
  call Hloop_VA_Q(ntryL,G1H4(3),wf4(:,9),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(543),n2h1(407))
  call Hloop_VA_Q(ntryL,G1H4(4),wf4(:,9),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(544),n2h1(408))
  call Hloop_VA_Q(ntryL,G1H4(48),wf4(:,9),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(545),n2h1(409))
  call Hloop_VA_Q(ntryL,G1H4(69),wf4(:,9),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(546),n2h1(410))
  call Hloop_VA_Q(ntryL,G1H4(54),wf4(:,9),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(547),n2h1(411))
  call Hloop_VA_Q(ntryL,G1H4(62),wf4(:,9),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(548),n2h1(412))
  call Hloop_VA_Q(ntryL,G1H2(680),ex4(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(549),n2h1(413))
  call Hloop_VA_Q(ntryL,G1H2(685),ex4(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(550),n2h1(414))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(113),58,wf4(:,1),5,G2tensor(551),m3h4x1(:,81),heltab2x4(:,:,603))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(114),0,wf4(:,1),5,G2tensor(552),m3h4x1(:,82),heltab2x4(:,:,604))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(137),58,wf4(:,1),5,G2tensor(553),m3h4x1(:,83),heltab2x4(:,:,605))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),8,wf4(:,1),5,G2tensor(554),m3h4x1(:,84),heltab2x4(:,:,606))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(303),57,wf4(:,11),6,G2tensor(555),m3h4x1(:,85),heltab2x4(:,:,607))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(306),0,wf4(:,11),6,G2tensor(556),m3h4x1(:,86),heltab2x4(:,:,608))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(310),57,wf4(:,11),6,G2tensor(557),m3h4x1(:,87),heltab2x4(:,:,609))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(311),8,wf4(:,11),6,G2tensor(558),m3h4x1(:,88),heltab2x4(:,:,610))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(161),54,wf4(:,15),9,G2tensor(559),m3h4x1(:,89),heltab2x4(:,:,611))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(162),0,wf4(:,15),9,G2tensor(560),m3h4x1(:,90),heltab2x4(:,:,612))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(324),54,wf4(:,15),9,G2tensor(561),m3h4x1(:,91),heltab2x4(:,:,613))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(325),4,wf4(:,15),9,G2tensor(562),m3h4x1(:,92),heltab2x4(:,:,614))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(328),54,wf4(:,15),9,G2tensor(563),m3h4x1(:,93),heltab2x4(:,:,615))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(329),0,wf4(:,15),9,G2tensor(564),m3h4x1(:,94),heltab2x4(:,:,616))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(186),54,wf4(:,15),9,G2tensor(565),m3h4x1(:,95),heltab2x4(:,:,617))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(336),2,wf4(:,15),9,G2tensor(566),m3h4x1(:,96),heltab2x4(:,:,618))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(342),53,wf4(:,20),10,G2tensor(567),m3h4x1(:,97),heltab2x4(:,:,619))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(343),0,wf4(:,20),10,G2tensor(568),m3h4x1(:,98),heltab2x4(:,:,620))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(347),53,wf4(:,20),10,G2tensor(569),m3h4x1(:,99),heltab2x4(:,:,621))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(350),4,wf4(:,20),10,G2tensor(570),m3h4x1(:,100),heltab2x4(:,:,622))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(434),53,wf4(:,20),10,G2tensor(571),m3h4x1(:,101),heltab2x4(:,:,623))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(356),0,wf4(:,20),10,G2tensor(572),m3h4x1(:,102),heltab2x4(:,:,624))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(365),53,wf4(:,20),10,G2tensor(573),m3h4x1(:,103),heltab2x4(:,:,625))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(366),1,wf4(:,20),10,G2tensor(574),m3h4x1(:,104),heltab2x4(:,:,626))
  call Hloop_QV_A(ntryL,G1H2(690),ex5(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(575),n2h1(427))
  call Hloop_AV_Q(ntryL,G1H2(695),ex5(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(576),n2h1(428))
  call Hloop_QV_A(ntryL,G1H2(700),ex5(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(577),n2h1(429))
  call Hloop_AV_Q(ntryL,G1H2(705),ex5(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(578),n2h1(430))
  call Hloop_QV_A(ntryL,G1H2(710),ex5(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(579),n2h1(431))
  call Hloop_QV_A(ntryL,G1H2(715),ex5(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(580),n2h1(432))
  call Hloop_AV_Q(ntryL,G1H2(720),ex5(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(581),n2h1(433))
  call Hloop_AV_Q(ntryL,G1H2(725),ex5(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(582),n2h1(434))
  call Hloop_QV_A(ntryL,G1H2(730),ex5(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(583),n2h1(435))
  call Hloop_AV_Q(ntryL,G1H2(735),ex5(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(584),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(740),ex5(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(585),n2h1(437))
  call Hloop_AV_Q(ntryL,G1H2(745),ex5(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(586),n2h1(438))
  call Hloop_QV_A(ntryL,G1H2(750),ex5(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(587),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H2(755),ex5(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(588),n2h1(440))
  call Hloop_QV_A(ntryL,G1H2(760),ex5(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(589),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H2(765),ex5(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(590),n2h1(442))
  call Hloop_AV_Q(ntryL,G1H4(374),wf4(:,1),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(591),n2h1(443))
  call Hloop_AV_Q(ntryL,G1H4(375),wf4(:,1),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,628))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(592),n2h1(444))
  call Hloop_AV_Q(ntryL,G1H4(384),wf4(:,1),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(593),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H4(385),wf4(:,1),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(594),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(770),ex5(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(595),n2h1(447))
  call Hloop_QV_A(ntryL,G1H2(775),ex5(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(596),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H4(391),wf4(:,11),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,631))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(597),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H4(257),wf4(:,11),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(598),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H4(396),wf4(:,11),G1H1(1),m3h4x1(:,111),heltab2x4(:,:,633))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(599),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H4(399),wf4(:,11),G1H1(1),m3h4x1(:,112),heltab2x4(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(600),n2h1(452))
  call Hloop_AV_Q(ntryL,G1H2(780),ex5(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(601),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(785),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(602),n2h1(454))
  call Hloop_QV_A(ntryL,G1H4(404),wf4(:,15),G1H1(1),m3h4x1(:,113),heltab2x4(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(603),n2h1(455))
  call Hloop_QV_A(ntryL,G1H4(405),wf4(:,15),G1H1(1),m3h4x1(:,114),heltab2x4(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(604),n2h1(456))
  call Hloop_QV_A(ntryL,G1H4(414),wf4(:,15),G1H1(1),m3h4x1(:,115),heltab2x4(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(605),n2h1(457))
  call Hloop_QV_A(ntryL,G1H4(415),wf4(:,15),G1H1(1),m3h4x1(:,116),heltab2x4(:,:,638))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(606),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H4(420),wf4(:,15),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(607),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H4(423),wf4(:,15),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(608),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H4(430),wf4(:,15),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(609),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H4(38),wf4(:,15),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),25,0,G2tensor(610),n2h1(462))
  call Hloop_AV_Q(ntryL,G1H2(790),ex5(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),25,0,G2tensor(611),n2h1(463))
  call Hloop_QV_A(ntryL,G1H2(795),ex5(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(612),n2h1(464))
  call Hloop_QV_A(ntryL,G1H4(153),wf4(:,20),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,643))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(613),n2h1(465))
  call Hloop_QV_A(ntryL,G1H4(154),wf4(:,20),G1H1(1),m3h4x1(:,122),heltab2x4(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(614),n2h1(466))
  call Hloop_QV_A(ntryL,G1H4(354),wf4(:,20),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(615),n2h1(467))
  call Hloop_QV_A(ntryL,G1H4(355),wf4(:,20),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(616),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H4(184),wf4(:,20),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(617),n2h1(469))
  call Hloop_AV_Q(ntryL,G1H4(188),wf4(:,20),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(618),n2h1(470))
  call Hloop_AV_Q(ntryL,G1H4(202),wf4(:,20),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(619),n2h1(471))
  call Hloop_AV_Q(ntryL,G1H4(212),wf4(:,20),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,0,G2tensor(620),n2h1(472))
  call Hloop_AV_Q(ntryL,G1H2(800),ex5(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,0,G2tensor(621),n2h1(473))
  call Hloop_QV_A(ntryL,G1H2(805),ex5(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(622),n2h1(474))
  call ol_merge_tensors(G2tensor(87),[G2tensor(18),G1tensor(98)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(20),G1tensor(104),G1tensor(57)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(22),G1tensor(110)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(24),G1tensor(116),G1tensor(51)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(26),G1tensor(122)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(28),G1tensor(128)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(30),G1tensor(134)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(32),G1tensor(140)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(34),G1tensor(146)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(36),G1tensor(152)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(38),G1tensor(158)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(40),G1tensor(164)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(42),G1tensor(170)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(44),G1tensor(176)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(46),G1tensor(182)])
  call ol_merge_tensors(G2tensor(258),[G2tensor(48),G1tensor(188)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(50),G1tensor(194)])
  call ol_merge_tensors(G2tensor(267),[G2tensor(52),G1tensor(200)])
  call ol_merge_tensors(G2tensor(273),[G2tensor(54),G1tensor(206)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(56),G1tensor(212)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(58),G1tensor(218)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(60),G1tensor(224)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(62),G1tensor(230)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(64),G1tensor(236)])
  call ol_merge_tensors(G2tensor(309),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(312),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(315),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(405),[G2tensor(73),G1tensor(137),G1tensor(17)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(318),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(387),[G2tensor(75),G1tensor(125),G1tensor(23)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(321),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(396),[G2tensor(77),G1tensor(131),G1tensor(29)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(324),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(79),G1tensor(143),G1tensor(35)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(327),[G1tensor(105),G1tensor(38)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(330),[G1tensor(99),G1tensor(44)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(147),G1tensor(50)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(70),G1tensor(52)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(59),G1tensor(53)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(336),[G1tensor(171),G1tensor(56)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(64),G1tensor(58)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(219),G1tensor(62)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(37),G1tensor(138),G1tensor(66)])
  call ol_merge_tensors(G2tensor(342),[G1tensor(195),G1tensor(68)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(43),G1tensor(132),G1tensor(72)])
  call ol_merge_tensors(G2tensor(345),[G1tensor(153),G1tensor(74)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(95),G1tensor(77)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(231),G1tensor(80)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(55),G1tensor(126),G1tensor(84)])
  call ol_merge_tensors(G2tensor(351),[G1tensor(207),G1tensor(86)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(61),G1tensor(144),G1tensor(90)])
  call ol_merge_tensors(G2tensor(354),[G1tensor(165),G1tensor(92)])
  call ol_merge_tensors(G2tensor(165),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(357),[G1tensor(112),G1tensor(100)])
  call ol_merge_tensors(G2tensor(360),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(363),[G1tensor(118),G1tensor(106)])
  call ol_merge_tensors(G2tensor(366),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(204),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(369),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(372),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(375),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(378),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(210),[G1tensor(120)])
  call ol_merge_tensors(G2tensor(381),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(384),[G1tensor(124)])
  call ol_merge_tensors(G2tensor(390),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(393),[G1tensor(130)])
  call ol_merge_tensors(G2tensor(399),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(402),[G1tensor(136)])
  call ol_merge_tensors(G2tensor(408),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(411),[G1tensor(142)])
  call ol_merge_tensors(G2tensor(417),[G1tensor(160),G1tensor(148)])
  call ol_merge_tensors(G2tensor(420),[G1tensor(197),G1tensor(149)])
  call ol_merge_tensors(G2tensor(228),[G1tensor(174),G1tensor(150)])
  call ol_merge_tensors(G2tensor(423),[G1tensor(184),G1tensor(154)])
  call ol_merge_tensors(G2tensor(426),[G1tensor(203),G1tensor(155)])
  call ol_merge_tensors(G2tensor(234),[G1tensor(168),G1tensor(156)])
  call ol_merge_tensors(G2tensor(429),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(432),[G1tensor(209),G1tensor(161)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(180),G1tensor(162)])
  call ol_merge_tensors(G2tensor(435),[G1tensor(190),G1tensor(166)])
  call ol_merge_tensors(G2tensor(438),[G1tensor(215),G1tensor(167)])
  call ol_merge_tensors(G2tensor(441),[G1tensor(178),G1tensor(172)])
  call ol_merge_tensors(G2tensor(444),[G1tensor(221),G1tensor(173)])
  call ol_merge_tensors(G2tensor(447),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(450),[G1tensor(233),G1tensor(179)])
  call ol_merge_tensors(G2tensor(453),[G1tensor(183)])
  call ol_merge_tensors(G2tensor(456),[G1tensor(227),G1tensor(185)])
  call ol_merge_tensors(G2tensor(255),[G1tensor(192),G1tensor(186)])
  call ol_merge_tensors(G2tensor(459),[G1tensor(189)])
  call ol_merge_tensors(G2tensor(462),[G1tensor(239),G1tensor(191)])
  call ol_merge_tensors(G2tensor(465),[G1tensor(196)])
  call ol_merge_tensors(G2tensor(264),[G1tensor(198)])
  call ol_merge_tensors(G2tensor(468),[G1tensor(201)])
  call ol_merge_tensors(G2tensor(471),[G1tensor(202)])
  call ol_merge_tensors(G2tensor(270),[G1tensor(204)])
  call ol_merge_tensors(G2tensor(474),[G1tensor(208)])
  call ol_merge_tensors(G2tensor(276),[G1tensor(210)])
  call ol_merge_tensors(G2tensor(477),[G1tensor(213)])
  call ol_merge_tensors(G2tensor(480),[G1tensor(214)])
  call ol_merge_tensors(G2tensor(282),[G1tensor(216)])
  call ol_merge_tensors(G2tensor(483),[G1tensor(220)])
  call ol_merge_tensors(G2tensor(288),[G1tensor(222)])
  call ol_merge_tensors(G2tensor(486),[G1tensor(225)])
  call ol_merge_tensors(G2tensor(489),[G1tensor(226)])
  call ol_merge_tensors(G2tensor(294),[G1tensor(228)])
  call ol_merge_tensors(G2tensor(492),[G1tensor(232)])
  call ol_merge_tensors(G2tensor(300),[G1tensor(234)])
  call ol_merge_tensors(G2tensor(495),[G1tensor(237)])
  call ol_merge_tensors(G2tensor(498),[G1tensor(238)])
  call ol_merge_tensors(G2tensor(306),[G1tensor(240)])
  call ol_merge_tensors(G2tensor(501),[G2tensor(169)])
  call ol_merge_tensors(G2tensor(504),[G2tensor(171)])
  call ol_merge_tensors(G2tensor(513),[G2tensor(177)])
  call ol_merge_tensors(G2tensor(516),[G2tensor(179)])
  call ol_merge_tensors(G2tensor(531),[G2tensor(189)])
  call ol_merge_tensors(G2tensor(534),[G2tensor(191)])
  call ol_merge_tensors(G2tensor(543),[G2tensor(197)])
  call ol_merge_tensors(G2tensor(546),[G2tensor(199)])
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(64),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(65),mass5set(:,1),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(66),mass5set(:,1),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(67),mass5set(:,1),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),8)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(68),mass5set(:,1),  & 
G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(151),1)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(69),mass5set(:,1),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205),G1tensor(211))
  call G_TensorShift(G1tensor(187),2)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(71),mass5set(:,1),  & 
G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(223),1)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(72),mass5set(:,1),  & 
G1tensor(57),G1tensor(110),G1tensor(116),G1tensor(51),G1tensor(122),G1tensor(128))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(225),RedSet_5(133),mass5set(:,1),  & 
G1tensor(134),G1tensor(140),G1tensor(146),G1tensor(152),G1tensor(158),G1tensor(164))
  call G_TensorShift(G1tensor(140),2)
  call Hotf_5pt_reduction_last(G2tensor(231),RedSet_5(135),mass5set(:,1),  & 
G1tensor(170),G1tensor(176),G1tensor(182),G1tensor(188),G1tensor(194),G1tensor(200))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(137),mass5set(:,1),  & 
G1tensor(206),G1tensor(212),G1tensor(218),G1tensor(224),G1tensor(230),G1tensor(236))
  call G_TensorShift(G1tensor(212),2)
  call Hotf_5pt_reduction_last(G2tensor(243),RedSet_5(139),mass5set(:,1),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(12),G1tensor(6))
  call G_TensorShift(G1tensor(3),4)
  call Hotf_5pt_reduction_last(G2tensor(246),RedSet_5(140),mass5set(:,1),  & 
G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(9),1)
  call Hotf_5pt_reduction_last(G2tensor(249),RedSet_5(141),mass5set(:,1),  & 
G1tensor(16),G1tensor(137),G1tensor(17),G1tensor(18),G1tensor(20),G1tensor(21))
  call G_TensorShift(G1tensor(137),1)
  call Hotf_5pt_reduction_last(G2tensor(252),RedSet_5(142),mass5set(:,1),  & 
G1tensor(22),G1tensor(125),G1tensor(23),G1tensor(24),G1tensor(26),G1tensor(27))
  call G_TensorShift(G1tensor(125),8)
  call Hotf_5pt_reduction_last(G2tensor(258),RedSet_5(144),mass5set(:,1),  & 
G1tensor(28),G1tensor(131),G1tensor(29),G1tensor(30),G1tensor(32),G1tensor(33))
  call G_TensorShift(G1tensor(131),4)
  call Hotf_5pt_reduction_last(G2tensor(261),RedSet_5(145),mass5set(:,1),  & 
G1tensor(34),G1tensor(143),G1tensor(35),G1tensor(36),G1tensor(105),G1tensor(38))
  call G_TensorShift(G1tensor(143),2)
  call Hotf_5pt_reduction_last(G2tensor(267),RedSet_5(146),mass5set(:,1),  & 
G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(48),G1tensor(42),G1tensor(99))
  call G_TensorShift(G1tensor(40),8)
  call Hotf_5pt_reduction_last(G2tensor(273),RedSet_5(147),mass5set(:,1),  & 
G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(147),G1tensor(50))
  call G_TensorShift(G1tensor(45),2)
  call Hotf_5pt_reduction_last(G2tensor(279),RedSet_5(148),mass5set(:,1),  & 
G1tensor(70),G1tensor(52),G1tensor(59),G1tensor(53),G1tensor(54),G1tensor(171))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_5pt_reduction_last(G2tensor(285),RedSet_5(149),mass5set(:,1),  & 
G1tensor(56),G1tensor(64),G1tensor(58),G1tensor(60),G1tensor(219),G1tensor(62))
  call G_TensorShift(G1tensor(64),1)
  call Hotf_5pt_reduction_last(G2tensor(291),RedSet_5(150),mass5set(:,1),  & 
G1tensor(63),G1tensor(65),G1tensor(138),G1tensor(66),G1tensor(195),G1tensor(68))
  call G_TensorShift(G1tensor(65),8)
  call Hotf_5pt_reduction_last(G2tensor(297),RedSet_5(151),mass5set(:,1),  & 
G1tensor(69),G1tensor(71),G1tensor(132),G1tensor(72),G1tensor(153),G1tensor(74))
  call G_TensorShift(G1tensor(71),1)
  call Hotf_5pt_reduction_last(G2tensor(303),RedSet_5(152),mass5set(:,1),  & 
G1tensor(75),G1tensor(76),G1tensor(95),G1tensor(77),G1tensor(78),G1tensor(231))
  call G_TensorShift(G1tensor(76),4)
  call Hotf_5pt_reduction_last(G2tensor(309),RedSet_5(153),mass5set(:,1),  & 
G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(126),G1tensor(84))
  call G_TensorShift(G1tensor(81),1)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(89),mass5set(:,1),  & 
G1tensor(207),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(144))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(90),mass5set(:,1),  & 
G1tensor(90),G1tensor(165),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(96))
  call G_TensorShift(G1tensor(165),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(55),mass5set(:,1),  & 
G1tensor(112),G1tensor(100),G1tensor(101),G1tensor(102),G1tensor(118),G1tensor(106))
  call G_TensorShift(G1tensor(100),8)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(33),mass5set(:,1),  & 
G1tensor(107),G1tensor(108),G1tensor(111),G1tensor(113),G1tensor(114),G1tensor(117))
  call G_TensorShift(G1tensor(108),8)
  call Hotf_5pt_reduction_last(G2tensor(312),RedSet_5(154),mass5set(:,1),  & 
G1tensor(119),G1tensor(120),G1tensor(123),G1tensor(124),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(120),2)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(91),mass5set(:,1),  & 
G1tensor(135),G1tensor(136),G1tensor(141),G1tensor(142),G1tensor(160),G1tensor(148))
  call G_TensorShift(G1tensor(136),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(92),mass5set(:,1),  & 
G1tensor(197),G1tensor(149),G1tensor(174),G1tensor(150),G1tensor(184),G1tensor(154))
  call G_TensorShift(G1tensor(149),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(56),mass5set(:,1),  & 
G1tensor(203),G1tensor(155),G1tensor(168),G1tensor(156),G1tensor(159),G1tensor(209))
  call G_TensorShift(G1tensor(155),8)
  call Hotf_5pt_reduction_last(G2tensor(315),RedSet_5(155),mass5set(:,1),  & 
G1tensor(161),G1tensor(180),G1tensor(162),G1tensor(190),G1tensor(166),G1tensor(215))
  call G_TensorShift(G1tensor(180),1)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(93),mass5set(:,1),  & 
G1tensor(167),G1tensor(178),G1tensor(172),G1tensor(221),G1tensor(173),G1tensor(177))
  call G_TensorShift(G1tensor(178),8)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(94),mass5set(:,1),  & 
G1tensor(233),G1tensor(179),G1tensor(183),G1tensor(227),G1tensor(185),G1tensor(192))
  call G_TensorShift(G1tensor(179),8)
  call Hotf_5pt_reduction_last(G2tensor(405),RedSet_5(57),mass5set(:,1),  & 
G1tensor(186),G1tensor(189),G1tensor(239),G1tensor(191),G1tensor(196),G1tensor(198))
  call G_TensorShift(G1tensor(189),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(34),mass5set(:,1),  & 
G1tensor(201),G1tensor(202),G1tensor(204),G1tensor(208),G1tensor(210),G1tensor(213))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_5pt_reduction_last(G2tensor(318),RedSet_5(156),mass5set(:,1),  & 
G1tensor(214),G1tensor(216),G1tensor(220),G1tensor(222),G1tensor(225),G1tensor(226))
  call G_TensorShift(G1tensor(216),1)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(95),mass5set(:,1),  & 
G1tensor(228),G1tensor(232),G1tensor(234),G1tensor(237),G1tensor(238),G1tensor(240))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(96),mass5set(:,1),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_5pt_reduction_last(G2tensor(387),RedSet_5(58),mass5set(:,1),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(35),mass5set(:,1),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_5pt_reduction_last(G2tensor(321),RedSet_5(157),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),2)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(97),mass5set(:,1),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(98),mass5set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(396),RedSet_5(59),mass5set(:,1),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(36),mass5set(:,1),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(324),RedSet_5(158),mass5set(:,1),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),2)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(99),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(100),mass5set(:,1),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),4)
  call Hotf_5pt_reduction_last(G2tensor(414),RedSet_5(60),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),4)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(37),mass5set(:,1),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),4)
  call Hotf_5pt_reduction_last(G2tensor(327),RedSet_5(159),mass5set(:,1),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),4)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(101),mass5set(:,1),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),2)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(102),mass5set(:,1),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),2)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(61),mass5set(:,1),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(38),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),2)
  call Hotf_5pt_reduction_last(G2tensor(330),RedSet_5(160),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),8)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(103),mass5set(:,1),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),2)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(104),mass5set(:,1),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),2)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(62),mass5set(:,1),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),2)
  call Hotf_5pt_reduction_last(G2tensor(333),RedSet_5(161),mass5set(:,1),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(47),mass5set(:,1),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),8)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(63),mass5set(:,1),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(39),mass5set(:,1),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),8)
  call Hotf_5pt_reduction_last(G2tensor(336),RedSet_5(162),mass5set(:,1),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(48),mass5set(:,1),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(40),mass5set(:,1),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),8)
  call Hotf_5pt_reduction_last(G2tensor(339),RedSet_5(163),mass5set(:,1),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(105),mass5set(:,1),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(51),mass5set(:,1),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),8)
  call Hotf_5pt_reduction_last(G2tensor(219),RedSet_5(41),mass5set(:,1),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_5pt_reduction_last(G2tensor(342),RedSet_5(164),mass5set(:,1),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(106),mass5set(:,1),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(52),mass5set(:,1),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_5pt_reduction_last(G2tensor(216),RedSet_5(42),mass5set(:,1),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),8)
  call Hotf_5pt_reduction_last(G2tensor(345),RedSet_5(165),mass5set(:,1),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(107),mass5set(:,1),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),2)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(108),mass5set(:,1),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),2)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(70),mass5set(:,1),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),2)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(43),mass5set(:,1),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),2)
  call Hotf_5pt_reduction_last(G2tensor(348),RedSet_5(166),mass5set(:,1),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),16)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(109),mass5set(:,1),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),4)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(110),mass5set(:,1),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(53),mass5set(:,1),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),4)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(44),mass5set(:,1),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),4)
  call Hotf_5pt_reduction_last(G2tensor(351),RedSet_5(167),mass5set(:,1),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),16)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(111),mass5set(:,1),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),4)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(112),mass5set(:,1),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),4)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(54),mass5set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),4)
  call Hotf_5pt_reduction_last(G2tensor(222),RedSet_5(45),mass5set(:,1),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),4)
  call Hotf_5pt_reduction_last(G2tensor(354),RedSet_5(168),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),16)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(113),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),2)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(114),mass5set(:,1),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),2)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(46),mass5set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),2)
  call Hotf_5pt_reduction_last(G2tensor(357),RedSet_5(169),mass5set(:,1),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),8)
  call Hotf_5pt_reduction_last(G2tensor(360),RedSet_5(170),mass5set(:,1),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),8)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(129),mass5set(:,1),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),8)
  call Hotf_5pt_reduction_last(G2tensor(363),RedSet_5(171),mass5set(:,1),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),4)
  call Hotf_5pt_reduction_last(G2tensor(366),RedSet_5(172),mass5set(:,1),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),4)
  call Hotf_5pt_reduction_last(G2tensor(204),RedSet_5(130),mass5set(:,1),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),4)
  call Hotf_5pt_reduction_last(G2tensor(369),RedSet_5(173),mass5set(:,1),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),8)
  call Hotf_5pt_reduction_last(G2tensor(372),RedSet_5(174),mass5set(:,1),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),8)
  call Hotf_5pt_reduction_last(G2tensor(207),RedSet_5(131),mass5set(:,1),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),8)
  call Hotf_5pt_reduction_last(G2tensor(375),RedSet_5(175),mass5set(:,1),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),4)
  call Hotf_5pt_reduction_last(G2tensor(378),RedSet_5(176),mass5set(:,1),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),4)
  call Hotf_5pt_reduction_last(G2tensor(210),RedSet_5(132),mass5set(:,1),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),4)
  call Hotf_5pt_reduction_last(G2tensor(381),RedSet_5(177),mass5set(:,1),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),4)
  call Hotf_5pt_reduction_last(G2tensor(384),RedSet_5(178),mass5set(:,1),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),4)
  call Hotf_5pt_reduction_last(G2tensor(390),RedSet_5(179),mass5set(:,1),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),8)
  call Hotf_5pt_reduction_last(G2tensor(393),RedSet_5(49),mass5set(:,1),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),8)
  call Hotf_5pt_reduction_last(G2tensor(399),RedSet_5(180),mass5set(:,1),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),8)
  call Hotf_5pt_reduction_last(G2tensor(402),RedSet_5(50),mass5set(:,1),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),8)
  call Hotf_5pt_reduction_last(G2tensor(408),RedSet_5(181),mass5set(:,1),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),4)
  call Hotf_5pt_reduction_last(G2tensor(411),RedSet_5(182),mass5set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),4)
  call Hotf_5pt_reduction_last(G2tensor(417),RedSet_5(183),mass5set(:,1),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),16)
  call Hotf_5pt_reduction_last(G2tensor(420),RedSet_5(73),mass5set(:,1),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(228),RedSet_5(134),mass5set(:,1),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),16)
  call Hotf_5pt_reduction_last(G2tensor(423),RedSet_5(184),mass5set(:,1),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),16)
  call Hotf_5pt_reduction_last(G2tensor(426),RedSet_5(74),mass5set(:,1),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_5pt_reduction_last(G2tensor(234),RedSet_5(136),mass5set(:,1),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),16)
  call Hotf_5pt_reduction_last(G2tensor(429),RedSet_5(185),mass5set(:,1),  & 
G1tensor(733),G1tensor(734),G1tensor(735),G1tensor(736),G1tensor(737),G1tensor(738))
  call G_TensorShift(G1tensor(734),16)
  call Hotf_5pt_reduction_last(G2tensor(432),RedSet_5(75),mass5set(:,1),  & 
G1tensor(739),G1tensor(740),G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744))
  call G_TensorShift(G1tensor(740),16)
  call Hotf_5pt_reduction_last(G2tensor(240),RedSet_5(138),mass5set(:,1),  & 
G1tensor(745),G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(746),16)
  call Hotf_5pt_reduction_last(G2tensor(435),RedSet_5(186),mass5set(:,1),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755),G1tensor(756))
  call G_TensorShift(G1tensor(752),16)
  call Hotf_5pt_reduction_last(G2tensor(438),RedSet_5(76),mass5set(:,1),  & 
G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760),G1tensor(761),G1tensor(762))
  call G_TensorShift(G1tensor(758),16)
  call Hotf_5pt_reduction_last(G2tensor(441),RedSet_5(187),mass5set(:,1),  & 
G1tensor(763),G1tensor(764),G1tensor(765),G1tensor(766),G1tensor(767),G1tensor(768))
  call G_TensorShift(G1tensor(764),16)
  call Hotf_5pt_reduction_last(G2tensor(444),RedSet_5(77),mass5set(:,1),  & 
G1tensor(769),G1tensor(770),G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774))
  call G_TensorShift(G1tensor(770),16)
  call Hotf_5pt_reduction_last(G2tensor(447),RedSet_5(188),mass5set(:,1),  & 
G1tensor(775),G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(776),16)
  call Hotf_5pt_reduction_last(G2tensor(450),RedSet_5(78),mass5set(:,1),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785),G1tensor(786))
  call G_TensorShift(G1tensor(782),16)
  call Hotf_5pt_reduction_last(G2tensor(453),RedSet_5(189),mass5set(:,1),  & 
G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790),G1tensor(791),G1tensor(792))
  call G_TensorShift(G1tensor(788),16)
  call Hotf_5pt_reduction_last(G2tensor(456),RedSet_5(79),mass5set(:,1),  & 
G1tensor(793),G1tensor(794),G1tensor(795),G1tensor(796),G1tensor(797),G1tensor(798))
  call G_TensorShift(G1tensor(794),16)
  call Hotf_5pt_reduction_last(G2tensor(255),RedSet_5(143),mass5set(:,1),  & 
G1tensor(799),G1tensor(800),G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804))
  call G_TensorShift(G1tensor(800),16)
  call Hotf_5pt_reduction_last(G2tensor(459),RedSet_5(190),mass5set(:,1),  & 
G1tensor(805),G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(806),16)
  call Hotf_5pt_reduction_last(G2tensor(462),RedSet_5(80),mass5set(:,1),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815),G1tensor(816))
  call G_TensorShift(G1tensor(812),16)
  call Hotf_5pt_reduction_last(G2tensor(465),RedSet_5(81),mass5set(:,1),  & 
G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820),G1tensor(821),G1tensor(822))
  call G_TensorShift(G1tensor(818),16)
  call Hotf_5pt_reduction_last(G2tensor(264),RedSet_5(118),mass5set(:,1),  & 
G1tensor(823),G1tensor(824),G1tensor(825),G1tensor(826),G1tensor(827),G1tensor(828))
  call G_TensorShift(G1tensor(824),16)
  call Hotf_5pt_reduction_last(G2tensor(468),RedSet_5(191),mass5set(:,1),  & 
G1tensor(829),G1tensor(830),G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834))
  call G_TensorShift(G1tensor(830),16)
  call Hotf_5pt_reduction_last(G2tensor(471),RedSet_5(82),mass5set(:,1),  & 
G1tensor(835),G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(836),16)
  call Hotf_5pt_reduction_last(G2tensor(270),RedSet_5(120),mass5set(:,1),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845),G1tensor(846))
  call G_TensorShift(G1tensor(842),16)
  call Hotf_5pt_reduction_last(G2tensor(474),RedSet_5(83),mass5set(:,1),  & 
G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850),G1tensor(851),G1tensor(852))
  call G_TensorShift(G1tensor(848),16)
  call Hotf_5pt_reduction_last(G2tensor(276),RedSet_5(124),mass5set(:,1),  & 
G1tensor(853),G1tensor(854),G1tensor(855),G1tensor(856),G1tensor(857),G1tensor(858))
  call G_TensorShift(G1tensor(854),16)
  call Hotf_5pt_reduction_last(G2tensor(477),RedSet_5(192),mass5set(:,1),  & 
G1tensor(859),G1tensor(860),G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864))
  call G_TensorShift(G1tensor(860),16)
  call Hotf_5pt_reduction_last(G2tensor(480),RedSet_5(84),mass5set(:,1),  & 
G1tensor(865),G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(866),16)
  call Hotf_5pt_reduction_last(G2tensor(282),RedSet_5(115),mass5set(:,1),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875),G1tensor(876))
  call G_TensorShift(G1tensor(872),16)
  call Hotf_5pt_reduction_last(G2tensor(483),RedSet_5(85),mass5set(:,1),  & 
G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880),G1tensor(881),G1tensor(882))
  call G_TensorShift(G1tensor(878),16)
  call Hotf_5pt_reduction_last(G2tensor(288),RedSet_5(116),mass5set(:,1),  & 
G1tensor(883),G1tensor(884),G1tensor(885),G1tensor(886),G1tensor(887),G1tensor(888))
  call G_TensorShift(G1tensor(884),16)
  call Hotf_5pt_reduction_last(G2tensor(486),RedSet_5(193),mass5set(:,1),  & 
G1tensor(889),G1tensor(890),G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894))
  call G_TensorShift(G1tensor(890),16)
  call Hotf_5pt_reduction_last(G2tensor(489),RedSet_5(86),mass5set(:,1),  & 
G1tensor(895),G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(896),16)
  call Hotf_5pt_reduction_last(G2tensor(294),RedSet_5(123),mass5set(:,1),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905),G1tensor(906))
  call G_TensorShift(G1tensor(902),16)
  call Hotf_5pt_reduction_last(G2tensor(492),RedSet_5(87),mass5set(:,1),  & 
G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910),G1tensor(911),G1tensor(912))
  call G_TensorShift(G1tensor(908),16)
  call Hotf_5pt_reduction_last(G2tensor(300),RedSet_5(121),mass5set(:,1),  & 
G1tensor(913),G1tensor(914),G1tensor(915),G1tensor(916),G1tensor(917),G1tensor(918))
  call G_TensorShift(G1tensor(914),16)
  call Hotf_5pt_reduction_last(G2tensor(495),RedSet_5(194),mass5set(:,1),  & 
G1tensor(919),G1tensor(920),G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924))
  call G_TensorShift(G1tensor(920),16)
  call Hotf_5pt_reduction_last(G2tensor(498),RedSet_5(88),mass5set(:,1),  & 
G1tensor(925),G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(926),16)
  call Hotf_5pt_reduction_last(G2tensor(306),RedSet_5(117),mass5set(:,1),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935),G1tensor(936))
  call G_TensorShift(G1tensor(932),16)
  call Hotf_5pt_reduction_last(G2tensor(501),RedSet_5(32),mass5set(:,1),  & 
G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940),G1tensor(941),G1tensor(942))
  call G_TensorShift(G1tensor(938),17)
  call Hotf_5pt_reduction_last(G2tensor(504),RedSet_5(31),mass5set(:,1),  & 
G1tensor(943),G1tensor(944),G1tensor(945),G1tensor(946),G1tensor(947),G1tensor(948))
  call G_TensorShift(G1tensor(944),17)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(125),mass5set(:,1),  & 
G1tensor(949),G1tensor(950),G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954))
  call G_TensorShift(G1tensor(950),17)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(126),mass5set(:,1),  & 
G1tensor(955),G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(956),17)
  call Hotf_5pt_reduction_last(G2tensor(513),RedSet_5(30),mass5set(:,1),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965),G1tensor(966))
  call G_TensorShift(G1tensor(962),18)
  call Hotf_5pt_reduction_last(G2tensor(516),RedSet_5(29),mass5set(:,1),  & 
G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970),G1tensor(971),G1tensor(972))
  call G_TensorShift(G1tensor(968),18)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(15),mass5set(:,1),  & 
G1tensor(973),G1tensor(974),G1tensor(975),G1tensor(976),G1tensor(977),G1tensor(978))
  call G_TensorShift(G1tensor(974),18)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(20),mass5set(:,1),  & 
G1tensor(979),G1tensor(980),G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984))
  call G_TensorShift(G1tensor(980),18)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(127),mass5set(:,1),  & 
G1tensor(985),G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(986),20)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(128),mass5set(:,1),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995),G1tensor(996))
  call G_TensorShift(G1tensor(992),20)
  call Hotf_5pt_reduction_last(G2tensor(531),RedSet_5(19),mass5set(:,1),  & 
G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000),G1tensor(1001),G1tensor(1002))
  call G_TensorShift(G1tensor(998),20)
  call Hotf_5pt_reduction_last(G2tensor(534),RedSet_5(17),mass5set(:,1),  & 
G1tensor(1003),G1tensor(1004),G1tensor(1005),G1tensor(1006),G1tensor(1007),G1tensor(1008))
  call G_TensorShift(G1tensor(1004),20)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(7),mass5set(:,1),  & 
G1tensor(1009),G1tensor(1010),G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014))
  call G_TensorShift(G1tensor(1010),24)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(8),mass5set(:,1),  & 
G1tensor(1015),G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1016),24)
  call Hotf_5pt_reduction_last(G2tensor(543),RedSet_5(13),mass5set(:,1),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025),G1tensor(1026))
  call G_TensorShift(G1tensor(1022),24)
  call Hotf_5pt_reduction_last(G2tensor(546),RedSet_5(11),mass5set(:,1),  & 
G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030),G1tensor(1031),G1tensor(1032))
  call G_TensorShift(G1tensor(1028),24)
  call Hotf_5pt_reduction_last(G2tensor(507),RedSet_5(25),mass5set(:,1),  & 
G1tensor(1033),G1tensor(1034),G1tensor(1035),G1tensor(1036),G1tensor(1037),G1tensor(1038))
  call G_TensorShift(G1tensor(1034),17)
  call Hotf_5pt_reduction_last(G2tensor(510),RedSet_5(26),mass5set(:,1),  & 
G1tensor(1039),G1tensor(1040),G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044))
  call G_TensorShift(G1tensor(1040),17)
  call Hotf_5pt_reduction_last(G2tensor(519),RedSet_5(21),mass5set(:,1),  & 
G1tensor(1045),G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1046),18)
  call Hotf_5pt_reduction_last(G2tensor(522),RedSet_5(23),mass5set(:,1),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055),G1tensor(1056))
  call G_TensorShift(G1tensor(1052),18)
  call Hotf_5pt_reduction_last(G2tensor(525),RedSet_5(24),mass5set(:,1),  & 
G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060),G1tensor(1061),G1tensor(1062))
  call G_TensorShift(G1tensor(1058),20)
  call Hotf_5pt_reduction_last(G2tensor(528),RedSet_5(28),mass5set(:,1),  & 
G1tensor(1063),G1tensor(1064),G1tensor(1065),G1tensor(1066),G1tensor(1067),G1tensor(1068))
  call G_TensorShift(G1tensor(1064),20)
  call Hotf_5pt_reduction_last(G2tensor(537),RedSet_5(22),mass5set(:,1),  & 
G1tensor(1069),G1tensor(1070),G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074))
  call G_TensorShift(G1tensor(1070),24)
  call Hotf_5pt_reduction_last(G2tensor(540),RedSet_5(27),mass5set(:,1),  & 
G1tensor(1075),G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1076),24)
  call Hotf_5pt_reduction_last(G2tensor(551),RedSet_5(4),mass5set(:,1),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085),G1tensor(1086))
  call G_TensorShift(G1tensor(1082),5)
  call Hotf_5pt_reduction_last(G2tensor(555),RedSet_5(6),mass5set(:,1),  & 
G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090),G1tensor(1091),G1tensor(1092))
  call G_TensorShift(G1tensor(1088),6)
  call Hotf_5pt_reduction_last(G2tensor(559),RedSet_5(3),mass5set(:,1),  & 
G1tensor(1093),G1tensor(1094),G1tensor(1095),G1tensor(1096),G1tensor(1097),G1tensor(1098))
  call G_TensorShift(G1tensor(1094),9)
  call Hotf_5pt_reduction_last(G2tensor(563),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1099),G1tensor(1100),G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104))
  call G_TensorShift(G1tensor(1100),9)
  call Hotf_5pt_reduction_last(G2tensor(567),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1105),G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1106),10)
  call Hotf_5pt_reduction_last(G2tensor(571),RedSet_5(2),mass5set(:,1),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115),G1tensor(1116))
  call G_TensorShift(G1tensor(1112),10)
  call Hotf_5pt_reduction_last(G2tensor(591),RedSet_5(12),mass5set(:,1),  & 
G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120),G1tensor(1121),G1tensor(1122))
  call G_TensorShift(G1tensor(1118),5)
  call Hotf_5pt_reduction_last(G2tensor(597),RedSet_5(18),mass5set(:,1),  & 
G1tensor(1123),G1tensor(1124),G1tensor(1125),G1tensor(1126),G1tensor(1127),G1tensor(1128))
  call G_TensorShift(G1tensor(1124),6)
  call Hotf_5pt_reduction_last(G2tensor(603),RedSet_5(119),mass5set(:,1),  & 
G1tensor(1129),G1tensor(1130),G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134))
  call G_TensorShift(G1tensor(1130),9)
  call Hotf_5pt_reduction_last(G2tensor(607),RedSet_5(16),mass5set(:,1),  & 
G1tensor(1135),G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1136),9)
  call Hotf_5pt_reduction_last(G2tensor(613),RedSet_5(122),mass5set(:,1),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145),G1tensor(1146))
  call G_TensorShift(G1tensor(1142),10)
  call Hotf_5pt_reduction_last(G2tensor(617),RedSet_5(14),mass5set(:,1),  & 
G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150),G1tensor(1151),G1tensor(1152))
  call G_TensorShift(G1tensor(1148),10)
  call ol_merge_tensors(T1sum(41),[G1tensor(1)])
  call ol_merge_tensors(T1sum(42),[G1tensor(37)])
  call ol_merge_tensors(T1sum(43),[G1tensor(73)])
  call ol_merge_tensors(T1sum(44),[G1tensor(109)])
  call ol_merge_tensors(T1sum(45),[G1tensor(145)])
  call ol_merge_tensors(T1sum(46),[G1tensor(181)])
  call ol_merge_tensors(T1sum(47),[G1tensor(217)])
  call ol_merge_tensors(T1sum(48),[G1tensor(57)])
  call ol_merge_tensors(T1sum(49),[G1tensor(134)])
  call ol_merge_tensors(T1sum(50),[G1tensor(170)])
  call ol_merge_tensors(T1sum(51),[G1tensor(206)])
  call ol_merge_tensors(T1sum(52),[G1tensor(2)])
  call ol_merge_tensors(T1sum(53),[G1tensor(8)])
  call ol_merge_tensors(T1sum(54),[G1tensor(16)])
  call ol_merge_tensors(T1sum(55),[G1tensor(22)])
  call ol_merge_tensors(T1sum(56),[G1tensor(28)])
  call ol_merge_tensors(T1sum(57),[G1tensor(34)])
  call ol_merge_tensors(T1sum(58),[G1tensor(39)])
  call ol_merge_tensors(T1sum(59),[G1tensor(44)])
  call ol_merge_tensors(T1sum(60),[G1tensor(70)])
  call ol_merge_tensors(T1sum(61),[G1tensor(56)])
  call ol_merge_tensors(T1sum(62),[G1tensor(63)])
  call ol_merge_tensors(T1sum(63),[G1tensor(69)])
  call ol_merge_tensors(T1sum(64),[G1tensor(75)])
  call ol_merge_tensors(T1sum(65),[G1tensor(80)])
  call ol_merge_tensors(T1sum(66),[G1tensor(207)])
  call ol_merge_tensors(T1sum(67),[G1tensor(90)])
  call ol_merge_tensors(T1sum(68),[G1tensor(112)])
  call ol_merge_tensors(T1sum(69),[G1tensor(107)])
  call ol_merge_tensors(T1sum(70),[G1tensor(119)])
  call ol_merge_tensors(T1sum(71),[G1tensor(135)])
  call ol_merge_tensors(T1sum(72),[G1tensor(197)])
  call ol_merge_tensors(T1sum(73),[G1tensor(203)])
  call ol_merge_tensors(T1sum(74),[G1tensor(161)])
  call ol_merge_tensors(T1sum(75),[G1tensor(167)])
  call ol_merge_tensors(T1sum(76),[G1tensor(233)])
  call ol_merge_tensors(T1sum(77),[G1tensor(186)])
  call ol_merge_tensors(T1sum(78),[G1tensor(201)])
  call ol_merge_tensors(T1sum(79),[G1tensor(214)])
  call ol_merge_tensors(T1sum(80),[G1tensor(228)])
  call ol_merge_tensors(T1sum(81),[G1tensor(241)])
  call ol_merge_tensors(T1sum(82),[G1tensor(247)])
  call ol_merge_tensors(T1sum(83),[G1tensor(253)])
  call ol_merge_tensors(T1sum(84),[G1tensor(259)])
  call ol_merge_tensors(T1sum(85),[G1tensor(265)])
  call ol_merge_tensors(T1sum(86),[G1tensor(271)])
  call ol_merge_tensors(T1sum(87),[G1tensor(277)])
  call ol_merge_tensors(T1sum(88),[G1tensor(283)])
  call ol_merge_tensors(T1sum(89),[G1tensor(289)])
  call ol_merge_tensors(T1sum(90),[G1tensor(295)])
  call ol_merge_tensors(T1sum(91),[G1tensor(301)])
  call ol_merge_tensors(T1sum(92),[G1tensor(307)])
  call ol_merge_tensors(T1sum(93),[G1tensor(313)])
  call ol_merge_tensors(T1sum(94),[G1tensor(319)])
  call ol_merge_tensors(T1sum(95),[G1tensor(325)])
  call ol_merge_tensors(T1sum(96),[G1tensor(331)])
  call ol_merge_tensors(T1sum(97),[G1tensor(337)])
  call ol_merge_tensors(T1sum(98),[G1tensor(343)])
  call ol_merge_tensors(T1sum(99),[G1tensor(349)])
  call ol_merge_tensors(T1sum(100),[G1tensor(355)])
  call ol_merge_tensors(T1sum(101),[G1tensor(361)])
  call ol_merge_tensors(T1sum(102),[G1tensor(367)])
  call ol_merge_tensors(T1sum(103),[G1tensor(373)])
  call ol_merge_tensors(T1sum(104),[G1tensor(379)])
  call ol_merge_tensors(T1sum(105),[G1tensor(385)])
  call ol_merge_tensors(T1sum(106),[G1tensor(391)])
  call ol_merge_tensors(T1sum(107),[G1tensor(397)])
  call ol_merge_tensors(T1sum(108),[G1tensor(403)])
  call ol_merge_tensors(T1sum(109),[G1tensor(409)])
  call ol_merge_tensors(T1sum(110),[G1tensor(415)])
  call ol_merge_tensors(T1sum(111),[G1tensor(421)])
  call ol_merge_tensors(T1sum(112),[G1tensor(427)])
  call ol_merge_tensors(T1sum(113),[G1tensor(433)])
  call ol_merge_tensors(T1sum(114),[G1tensor(439)])
  call ol_merge_tensors(T1sum(115),[G1tensor(445)])
  call ol_merge_tensors(T1sum(116),[G1tensor(451)])
  call ol_merge_tensors(T1sum(117),[G1tensor(457)])
  call ol_merge_tensors(T1sum(118),[G1tensor(463)])
  call ol_merge_tensors(T1sum(119),[G1tensor(469)])
  call ol_merge_tensors(T1sum(120),[G1tensor(475)])
  call ol_merge_tensors(T1sum(121),[G1tensor(481)])
  call ol_merge_tensors(T1sum(122),[G1tensor(487)])
  call ol_merge_tensors(T1sum(123),[G1tensor(493)])
  call ol_merge_tensors(T1sum(124),[G1tensor(499)])
  call ol_merge_tensors(T1sum(125),[G1tensor(505)])
  call ol_merge_tensors(T1sum(126),[G1tensor(511)])
  call ol_merge_tensors(T1sum(127),[G1tensor(517)])
  call ol_merge_tensors(T1sum(128),[G1tensor(523)])
  call ol_merge_tensors(T1sum(129),[G1tensor(529)])
  call ol_merge_tensors(T1sum(130),[G1tensor(535)])
  call ol_merge_tensors(T1sum(131),[G1tensor(541)])
  call ol_merge_tensors(T1sum(132),[G1tensor(547)])
  call ol_merge_tensors(T1sum(133),[G1tensor(553)])
  call ol_merge_tensors(T1sum(134),[G1tensor(559)])
  call ol_merge_tensors(T1sum(135),[G1tensor(565)])
  call ol_merge_tensors(T1sum(136),[G1tensor(571)])
  call ol_merge_tensors(T1sum(137),[G1tensor(577)])
  call ol_merge_tensors(T1sum(138),[G1tensor(583)])
  call ol_merge_tensors(T1sum(139),[G1tensor(589)])
  call ol_merge_tensors(T1sum(140),[G1tensor(595)])
  call ol_merge_tensors(T1sum(141),[G1tensor(601)])
  call ol_merge_tensors(T1sum(142),[G1tensor(607)])
  call ol_merge_tensors(T1sum(143),[G1tensor(613)])
  call ol_merge_tensors(T1sum(144),[G1tensor(619)])
  call ol_merge_tensors(T1sum(145),[G1tensor(625)])
  call ol_merge_tensors(T1sum(146),[G1tensor(631)])
  call ol_merge_tensors(T1sum(147),[G1tensor(637)])
  call ol_merge_tensors(T1sum(148),[G1tensor(643)])
  call ol_merge_tensors(T1sum(149),[G1tensor(649)])
  call ol_merge_tensors(T1sum(150),[G1tensor(655)])
  call ol_merge_tensors(T1sum(151),[G1tensor(661)])
  call ol_merge_tensors(T1sum(152),[G1tensor(667)])
  call ol_merge_tensors(T1sum(153),[G1tensor(673)])
  call ol_merge_tensors(T1sum(154),[G1tensor(679)])
  call ol_merge_tensors(T1sum(155),[G1tensor(685)])
  call ol_merge_tensors(T1sum(156),[G1tensor(691)])
  call ol_merge_tensors(T1sum(157),[G1tensor(697)])
  call ol_merge_tensors(T1sum(158),[G1tensor(703)])
  call ol_merge_tensors(T1sum(159),[G1tensor(709)])
  call ol_merge_tensors(T1sum(160),[G1tensor(715)])
  call ol_merge_tensors(T1sum(161),[G1tensor(721)])
  call ol_merge_tensors(T1sum(162),[G1tensor(727)])
  call ol_merge_tensors(T1sum(163),[G1tensor(733)])
  call ol_merge_tensors(T1sum(164),[G1tensor(739)])
  call ol_merge_tensors(T1sum(165),[G1tensor(745)])
  call ol_merge_tensors(T1sum(166),[G1tensor(751)])
  call ol_merge_tensors(T1sum(167),[G1tensor(757)])
  call ol_merge_tensors(T1sum(168),[G1tensor(763)])
  call ol_merge_tensors(T1sum(169),[G1tensor(769)])
  call ol_merge_tensors(T1sum(170),[G1tensor(775)])
  call ol_merge_tensors(T1sum(171),[G1tensor(781)])
  call ol_merge_tensors(T1sum(172),[G1tensor(787)])
  call ol_merge_tensors(T1sum(173),[G1tensor(793)])
  call ol_merge_tensors(T1sum(174),[G1tensor(799)])
  call ol_merge_tensors(T1sum(175),[G1tensor(805)])
  call ol_merge_tensors(T1sum(176),[G1tensor(811)])
  call ol_merge_tensors(T1sum(177),[G1tensor(817)])
  call ol_merge_tensors(T1sum(178),[G1tensor(823)])
  call ol_merge_tensors(T1sum(179),[G1tensor(829)])
  call ol_merge_tensors(T1sum(180),[G1tensor(835)])
  call ol_merge_tensors(T1sum(181),[G1tensor(841)])
  call ol_merge_tensors(T1sum(182),[G1tensor(847)])
  call ol_merge_tensors(T1sum(183),[G1tensor(853)])
  call ol_merge_tensors(T1sum(184),[G1tensor(859)])
  call ol_merge_tensors(T1sum(185),[G1tensor(865)])
  call ol_merge_tensors(T1sum(186),[G1tensor(871)])
  call ol_merge_tensors(T1sum(187),[G1tensor(877)])
  call ol_merge_tensors(T1sum(188),[G1tensor(883)])
  call ol_merge_tensors(T1sum(189),[G1tensor(889)])
  call ol_merge_tensors(T1sum(190),[G1tensor(895)])
  call ol_merge_tensors(T1sum(191),[G1tensor(901)])
  call ol_merge_tensors(T1sum(192),[G1tensor(907)])
  call ol_merge_tensors(T1sum(193),[G1tensor(913)])
  call ol_merge_tensors(T1sum(194),[G1tensor(919)])
  call ol_merge_tensors(T1sum(195),[G1tensor(925)])
  call ol_merge_tensors(T1sum(196),[G1tensor(931)])
  call ol_merge_tensors(T1sum(197),[G1tensor(937)])
  call ol_merge_tensors(T1sum(198),[G1tensor(943)])
  call ol_merge_tensors(T1sum(199),[G1tensor(949)])
  call ol_merge_tensors(T1sum(200),[G1tensor(955)])
  call ol_merge_tensors(T1sum(201),[G1tensor(961)])
  call ol_merge_tensors(T1sum(202),[G1tensor(967)])
  call ol_merge_tensors(T1sum(203),[G1tensor(973)])
  call ol_merge_tensors(T1sum(204),[G1tensor(979)])
  call ol_merge_tensors(T1sum(205),[G1tensor(985)])
  call ol_merge_tensors(T1sum(206),[G1tensor(991)])
  call ol_merge_tensors(T1sum(207),[G1tensor(997)])
  call ol_merge_tensors(T1sum(208),[G1tensor(1003)])
  call ol_merge_tensors(T1sum(209),[G1tensor(1009)])
  call ol_merge_tensors(T1sum(210),[G1tensor(1015)])
  call ol_merge_tensors(T1sum(211),[G1tensor(1021)])
  call ol_merge_tensors(T1sum(212),[G1tensor(1027)])
  call ol_merge_tensors(T1sum(213),[G1tensor(1033)])
  call ol_merge_tensors(T1sum(214),[G1tensor(1039)])
  call ol_merge_tensors(T1sum(215),[G1tensor(1045)])
  call ol_merge_tensors(T1sum(216),[G1tensor(1051)])
  call ol_merge_tensors(T1sum(217),[G1tensor(1057)])
  call ol_merge_tensors(T1sum(218),[G1tensor(1063)])
  call ol_merge_tensors(T1sum(219),[G1tensor(1069)])
  call ol_merge_tensors(T1sum(220),[G1tensor(1075)])
  call ol_merge_tensors(T1sum(221),[G1tensor(1081)])
  call ol_merge_tensors(T1sum(222),[G1tensor(1087)])
  call ol_merge_tensors(T1sum(223),[G1tensor(1093)])
  call ol_merge_tensors(T1sum(224),[G1tensor(1099)])
  call ol_merge_tensors(T1sum(225),[G1tensor(1105)])
  call ol_merge_tensors(T1sum(226),[G1tensor(1111)])
  call ol_merge_tensors(T1sum(227),[G1tensor(1117)])
  call ol_merge_tensors(T1sum(228),[G1tensor(1123)])
  call ol_merge_tensors(T1sum(229),[G1tensor(1129)])
  call ol_merge_tensors(T1sum(230),[G1tensor(1135)])
  call ol_merge_tensors(T1sum(231),[G1tensor(1141)])
  call ol_merge_tensors(T1sum(232),[G1tensor(1147)])
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[37,2,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(1),m4h2x4x8(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[37,2,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),ex6(:),G0H8(2),m4h4x2x8(:,1),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[37,2,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(3),m4h2x4x8(:,2),heltab3x64(:,:,3))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[38,1,16,8],[0,0,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,11),G0H8(4),m4h2x4x8(:,3),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[38,1,16,8],[0,0,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,11),ex6(:),G0H8(5),m4h4x2x8(:,2),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(4,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[38,1,16,8],[0,0,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,11),G0H8(6),m4h2x4x8(:,4),heltab3x64(:,:,6))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[41,2,16,4],[0,0,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,15),G0H8(7),m4h2x4x8(:,5),heltab3x64(:,:,7))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[41,2,16,4],[0,0,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,15),ex6(:),G0H8(8),m4h4x2x8(:,3),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[41,2,16,4],[0,0,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,15),G0H8(9),m4h2x4x8(:,6),heltab3x64(:,:,9))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[42,1,16,4],[0,0,0,0],5,1,wf4(:,20))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,20),G0H8(10),m4h2x4x8(:,7),heltab3x64(:,:,10))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[42,1,16,4],[0,0,0,0],5,1,wf4(:,20))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,20),ex6(:),G0H8(11),m4h4x2x8(:,4),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[42,1,16,4],[0,0,0,0],5,1,wf4(:,20))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,20),G0H8(12),m4h2x4x8(:,8),heltab3x64(:,:,12))
  Gcoeff(:)%j = (c(27)*M(2,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,10,5,16],[0,0,0,0],4,2,wf4(:,20),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,153),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(89))
  Gcoeff(:)%j = (c(27)*M(3,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,10,5,16],[0,0,0,0],4,2,wf4(:,20),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,154),heltab2x64(:,:,186))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(90))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,10,5,16],[0,0,0,0],4,2,wf4(:,20),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,155),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(91))
  Gcoeff(:)%j = (-(c(25)*M(3,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,10,5,16],[0,0,0,0],4,2,wf4(:,20),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,156),heltab2x64(:,:,188))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(92))
  Gcoeff(:)%j = (c(27)*M(3,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,5,10,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,157),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(93))
  Gcoeff(:)%j = (c(27)*M(2,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,5,10,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,158),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(94))
  Gcoeff(:)%j = (-(c(25)*M(3,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,5,10,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,159),heltab2x64(:,:,191))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(95))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,5,10,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,160),heltab2x64(:,:,192))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(96))
  Gcoeff(:)%j = (c(27)*M(2,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,5,16,10],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,161),heltab2x64(:,:,193))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(97))
  Gcoeff(:)%j = (c(27)*M(3,:)%j+c(26)*(-M(1,:)%j-M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,5,16,10],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,162),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(98))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,5,16,10],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,163),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(99))
  Gcoeff(:)%j = (-(c(25)*M(3,:)%j)+c(24)*(M(1,:)%j+M(4,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,5,16,10],[0,0,0,0],4,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,164),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(100))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,8,5,18],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,165),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(101))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,8,5,18],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,166),heltab2x64(:,:,198))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,5,18,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,167),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(102))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,5,18,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,168),heltab2x64(:,:,200))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,5,8,18],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,169),heltab2x64(:,:,201))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(103))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,5,8,18],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,170),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,5,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,171),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(104))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,5,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,172),heltab2x64(:,:,204))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,2,24,5],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,173),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(105))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,2,24,5],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,174),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,5,2,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,175),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(106))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,5,2,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,176),heltab2x64(:,:,208))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[34,5,8,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,33),heltab2x64(:,:,209))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[34,5,16,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,34),heltab2x64(:,:,210))
  call Hloop_Q_A(ntryL,G0H16(2),34,0,G1H16(15),n2h16(93))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[34,8,5,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,35),heltab2x64(:,:,211))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[40,5,2,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,36),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[40,2,16,5],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,37),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[40,2,5,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,38),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,7,16,8],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,177),heltab2x64(:,:,215))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,7,8,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,178),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(107))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,8,7,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,179),heltab2x64(:,:,217))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(27),n2h32(108))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,2,16,13],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,180),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,13,2,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,181),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(29),n2h32(109))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,2,13,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,182),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(110))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[37,8,2,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(13),m3h8x8(:,1),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(245),n2h8(247))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[37,2,8,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(13),m3h8x8(:,2),heltab2x64(:,:,222))
  call Hloop_A_Q(ntryL,G0H8(13),37,0,G1H8(246),n2h8(248))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[37,2,16,8],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),37,G1H8(261),m3h8x8(:,3),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j+M(3,:)%j)-c(27)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,6,9,16],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,183),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(111))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*(M(2,:)%j+M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,6,9,16],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,184),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(32),n2h32(112))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j-M(3,:)%j)+c(25)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,6,9,16],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,185),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(113))
  Gcoeff(:)%j = (c(25)*M(1,:)%j+c(24)*(-M(2,:)%j-M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,6,9,16],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,186),heltab2x64(:,:,227))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(114))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*(M(2,:)%j+M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,9,6,16],[0,0,0,0],4,2,wf4(:,15),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,187),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(115))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j+M(3,:)%j)-c(27)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,9,6,16],[0,0,0,0],4,2,wf4(:,15),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,188),heltab2x64(:,:,229))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(36),n2h32(116))
  Gcoeff(:)%j = (c(25)*M(1,:)%j+c(24)*(-M(2,:)%j-M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,9,6,16],[0,0,0,0],4,2,wf4(:,15),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,189),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(117))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j-M(3,:)%j)+c(25)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,9,6,16],[0,0,0,0],4,2,wf4(:,15),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,190),heltab2x64(:,:,231))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(38),n2h32(118))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j+M(3,:)%j)-c(27)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,6,16,9],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,191),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(119))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*(M(2,:)%j+M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,6,16,9],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,192),heltab2x64(:,:,233))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(40),n2h32(120))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j-M(3,:)%j)+c(25)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,6,16,9],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,193),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(121))
  Gcoeff(:)%j = (c(25)*M(1,:)%j+c(24)*(-M(2,:)%j-M(3,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,6,16,9],[0,0,0,0],4,2,wf4(:,11),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,194),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(42),n2h32(122))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,6,17,8],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,195),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(43),n2h32(123))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,6,17,8],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,196),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,8,6,17],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,197),heltab2x64(:,:,238))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(124))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,8,6,17],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,198),heltab2x64(:,:,239))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,6,8,17],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,199),heltab2x64(:,:,240))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(125))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,6,8,17],[0,0,0,0],4,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,200),heltab2x64(:,:,241))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,1,6,24],[0,0,0,0],4,2,wf4(:,11),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,201),heltab2x64(:,:,242))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(126))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,1,6,24],[0,0,0,0],4,2,wf4(:,11),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,202),heltab2x64(:,:,243))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,1,24,6],[0,0,0,0],4,2,wf4(:,9),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,203),heltab2x64(:,:,244))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(127))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,1,24,6],[0,0,0,0],4,2,wf4(:,9),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,204),heltab2x64(:,:,245))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,6,1,24],[0,0,0,0],4,2,wf4(:,11),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,205),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(128))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,6,1,24],[0,0,0,0],4,2,wf4(:,11),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,206),heltab2x64(:,:,247))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[33,6,16,8],[0,0,0,0],4,2,wf4(:,14),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(7),m3h4x16(:,39),heltab2x64(:,:,248))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(19),n2h16(94))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[33,6,8,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(8),m3h4x16(:,40),heltab2x64(:,:,249))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[33,8,6,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(9),m3h4x16(:,41),heltab2x64(:,:,250))
  Gcoeff(:)%j = (c(4)*M(3,:)%j-c(6)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[40,6,1,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,42),heltab2x64(:,:,251))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[40,1,16,6],[0,0,0,0],4,2,wf4(:,5),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,43),heltab2x64(:,:,252))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[40,1,6,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,44),heltab2x64(:,:,253))
  Gcoeff(:)%j = (c(4)*M(3,:)%j-c(6)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,7,16,8],[0,0,0,0],4,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,207),heltab2x64(:,:,254))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,7,8,16],[0,0,0,0],4,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,208),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(129))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,8,7,16],[0,0,0,0],4,1,wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,209),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(57),n2h32(130))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,1,16,14],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,210),heltab2x64(:,:,257))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,14,1,16],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,211),heltab2x64(:,:,258))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(59),n2h32(131))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,1,14,16],[0,0,0,0],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,212),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(60),n2h32(132))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[38,8,1,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,13),G0H8(13),m3h8x8(:,4),heltab2x64(:,:,260))
  call Hloop_Q_A(ntryL,G0H8(13),38,0,G1H8(262),n2h8(249))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[38,1,8,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,13),G0H8(13),m3h8x8(:,5),heltab2x64(:,:,261))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(277),n2h8(250))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(4,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[38,1,16,8],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,13),38,G1H8(278),m3h8x8(:,6),heltab2x64(:,:,262))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,4,9,18],[0,0,0,0],4,2,wf4(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,213),heltab2x64(:,:,263))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(61),n2h32(133))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,4,9,18],[0,0,0,0],4,2,wf4(:,15),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,214),heltab2x64(:,:,264))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,4,18,9],[0,0,0,0],4,2,wf4(:,4),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,215),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(63),n2h32(134))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,4,18,9],[0,0,0,0],4,2,wf4(:,4),wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,216),heltab2x64(:,:,266))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,9,4,18],[0,0,0,0],4,2,wf4(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,217),heltab2x64(:,:,267))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(65),n2h32(135))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,9,4,18],[0,0,0,0],4,2,wf4(:,15),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,218),heltab2x64(:,:,268))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,2,9,20],[0,0,0,0],4,2,wf4(:,15),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,219),heltab2x64(:,:,269))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(67),n2h32(136))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,2,9,20],[0,0,0,0],4,2,wf4(:,15),wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,220),heltab2x64(:,:,270))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,2,20,9],[0,0,0,0],4,2,wf4(:,19),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,221),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(137))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,2,20,9],[0,0,0,0],4,2,wf4(:,19),wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,222),heltab2x64(:,:,272))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,9,2,20],[0,0,0,0],4,2,wf4(:,15),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,223),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(138))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,9,2,20],[0,0,0,0],4,2,wf4(:,15),wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,224),heltab2x64(:,:,274))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(6)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[34,9,4,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,45),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[34,4,16,9],[0,0,0,0],4,2,wf4(:,8),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(14),m3h4x16(:,46),heltab2x64(:,:,276))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[34,4,9,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(15),m3h4x16(:,47),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(2,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[36,9,2,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(16),m3h4x16(:,48),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[36,2,16,9],[0,0,0,0],4,2,wf4(:,17),wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,49),heltab2x64(:,:,279))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[36,2,9,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(18),m3h4x16(:,50),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,4,16,11],[0,0,0,0],4,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,225),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,11,4,16],[0,0,0,0],4,1,wf8(:,27))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,226),heltab2x64(:,:,282))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(74),n2h32(139))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,4,11,16],[0,0,0,0],4,1,wf8(:,27))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,227),heltab2x64(:,:,283))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(75),n2h32(140))
  Gcoeff(:)%j = (c(4)*M(2,:)%j-c(6)*M(4,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,2,16,13],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,228),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,13,2,16],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,229),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(77),n2h32(141))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,2,13,16],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,230),heltab2x64(:,:,286))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(78),n2h32(142))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[41,4,2,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(13),m3h8x8(:,7),heltab2x64(:,:,287))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(293),n2h8(251))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[41,2,4,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,24),G0H8(13),m3h8x8(:,8),heltab2x64(:,:,288))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(294),n2h8(252))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[41,2,16,4],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),41,G1H8(65),m3h8x8(:,9),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,4,17,10],[0,0,0,0],4,2,wf4(:,12),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,231),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(79),n2h32(143))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,4,17,10],[0,0,0,0],4,2,wf4(:,12),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,232),heltab2x64(:,:,291))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,4,10,17],[0,0,0,0],4,2,wf4(:,20),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,233),heltab2x64(:,:,292))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(81),n2h32(144))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,4,10,17],[0,0,0,0],4,2,wf4(:,20),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,234),heltab2x64(:,:,293))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,10,4,17],[0,0,0,0],4,2,wf4(:,20),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,235),heltab2x64(:,:,294))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(83),n2h32(145))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,10,4,17],[0,0,0,0],4,2,wf4(:,20),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,236),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,1,10,20],[0,0,0,0],4,2,wf4(:,20),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,237),heltab2x64(:,:,296))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(85),n2h32(146))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,1,10,20],[0,0,0,0],4,2,wf4(:,20),wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,238),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,1,20,10],[0,0,0,0],4,2,wf4(:,19),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,239),heltab2x64(:,:,298))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(147))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,1,20,10],[0,0,0,0],4,2,wf4(:,19),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,240),heltab2x64(:,:,299))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,10,1,20],[0,0,0,0],4,2,wf4(:,20),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,241),heltab2x64(:,:,300))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(89),n2h32(148))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,10,1,20],[0,0,0,0],4,2,wf4(:,20),wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,242),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[33,4,16,10],[0,0,0,0],4,2,wf4(:,14),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(19),m3h4x16(:,51),heltab2x64(:,:,302))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[33,10,4,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(20),m3h4x16(:,52),heltab2x64(:,:,303))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[33,4,10,16],[0,0,0,0],4,2,wf4(:,14),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(21),m3h4x16(:,53),heltab2x64(:,:,304))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[36,10,1,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(22),m3h4x16(:,54),heltab2x64(:,:,305))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[36,1,16,10],[0,0,0,0],4,2,wf4(:,17),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(23),m3h4x16(:,55),heltab2x64(:,:,306))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[36,1,10,16],[0,0,0,0],4,2,wf4(:,17),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(24),m3h4x16(:,56),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,4,16,11],[0,0,0,0],4,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,243),heltab2x64(:,:,308))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,11,4,16],[0,0,0,0],4,1,wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,244),heltab2x64(:,:,309))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(92),n2h32(149))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,4,11,16],[0,0,0,0],4,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,245),heltab2x64(:,:,310))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(93),n2h32(150))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,1,16,14],[0,0,0,0],4,1,wf8(:,33))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,246),heltab2x64(:,:,311))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,14,1,16],[0,0,0,0],4,1,wf8(:,33))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,247),heltab2x64(:,:,312))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(95),n2h32(151))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,1,14,16],[0,0,0,0],4,1,wf8(:,33))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,248),heltab2x64(:,:,313))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(96),n2h32(152))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[42,4,1,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(13),m3h8x8(:,10),heltab2x64(:,:,314))
  call Hloop_Q_A(ntryL,G0H8(13),42,0,G1H8(66),n2h8(253))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[42,1,4,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,31),G0H8(13),m3h8x8(:,11),heltab2x64(:,:,315))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(1),n2h8(254))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[42,1,16,4],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,31),42,G1H8(2),m3h8x8(:,12),heltab2x64(:,:,316))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[34,8,4,17],[0,0,0,0],4,2,wf4(:,8),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,57),heltab2x64(:,:,317))
  call Hloop_Q_A(ntryL,G0H16(2),34,0,G1H16(39),n2h16(95))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[34,4,8,17],[0,0,0,0],4,2,wf4(:,8),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,58),heltab2x64(:,:,318))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(10),n2h16(96))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[34,4,17,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,59),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[34,4,17,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,60),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(32),n2h16(97))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[36,8,2,17],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(7),m3h4x16(:,61),heltab2x64(:,:,321))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[36,2,8,17],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(25),m3h4x16(:,62),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[36,2,8,17],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(26),m3h4x16(:,63),heltab2x64(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(26),36,0,G1H16(35),n2h16(98))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[36,2,17,8],[0,0,0,0],4,2,wf4(:,17),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(26),m3h4x16(:,64),heltab2x64(:,:,324))
  call Hloop_A_Q(ntryL,G0H16(26),36,0,G1H16(37),n2h16(99))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[40,4,2,17],[0,0,0,0],4,2,wf4(:,5),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(26),m3h4x16(:,65),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[40,2,4,17],[0,0,0,0],4,2,wf4(:,5),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(27),m3h4x16(:,66),heltab2x64(:,:,326))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[40,2,4,17],[0,0,0,0],4,2,wf4(:,5),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(28),m3h4x16(:,67),heltab2x64(:,:,327))
  call Hloop_A_Q(ntryL,G0H16(28),40,0,G1H16(47),n2h16(100))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[40,2,17,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(28),m3h4x16(:,68),heltab2x64(:,:,328))
  call Hloop_A_Q(ntryL,G0H16(28),40,0,G1H16(48),n2h16(101))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,2,8,21],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,249),heltab2x64(:,:,329))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(97),n2h32(153))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,2,8,21],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,250),heltab2x64(:,:,330))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,8,2,21],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,251),heltab2x64(:,:,331))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(99),n2h32(154))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,8,2,21],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(100),m3h2x32(:,252),heltab2x64(:,:,332))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,2,21,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,253),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(101),n2h32(155))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,2,21,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(102),m3h2x32(:,254),heltab2x64(:,:,334))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,2,4,25],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,255),heltab2x64(:,:,335))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(156))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,2,4,25],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(104),m3h2x32(:,256),heltab2x64(:,:,336))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,4,2,25],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,257),heltab2x64(:,:,337))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(105),n2h32(157))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,4,2,25],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(106),m3h2x32(:,258),heltab2x64(:,:,338))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,2,25,4],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,259),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(107),n2h32(158))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,2,25,4],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(108),m3h2x32(:,260),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[49,4,2,8],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,61),G0H8(13),m3h8x8(:,13),heltab2x64(:,:,341))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[49,4,2,8],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,61),G0H8(14),m3h8x8(:,14),heltab2x64(:,:,342))
  call Hloop_Q_A(ntryL,G0H8(14),49,0,G1H8(3),n2h8(255))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[49,2,4,8],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,61),G0H8(14),m3h8x8(:,15),heltab2x64(:,:,343))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[49,2,8,4],[0,0,0,0],4,1,wf8(:,61))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,61),G0H8(15),m3h8x8(:,16),heltab2x64(:,:,344))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[33,4,8,18],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(28),m3h4x16(:,69),heltab2x64(:,:,345))
  call Hloop_Q_A(ntryL,G0H16(28),33,0,G1H16(2),n2h16(102))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[33,8,4,18],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(28),m3h4x16(:,70),heltab2x64(:,:,346))
  call Hloop_Q_A(ntryL,G0H16(28),33,0,G1H16(33),n2h16(103))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[33,4,18,8],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(28),m3h4x16(:,71),heltab2x64(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(28),33,0,G1H16(12),n2h16(104))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[33,4,18,8],[0,0,0,0],4,2,wf4(:,14),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(28),m3h4x16(:,72),heltab2x64(:,:,348))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[36,8,1,18],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(29),m3h4x16(:,73),heltab2x64(:,:,349))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[36,1,8,18],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(30),m3h4x16(:,74),heltab2x64(:,:,350))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[36,1,8,18],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(31),m3h4x16(:,75),heltab2x64(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(31),36,0,G1H16(20),n2h16(105))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[36,1,18,8],[0,0,0,0],4,2,wf4(:,17),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(31),m3h4x16(:,76),heltab2x64(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(31),36,0,G1H16(9),n2h16(106))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[40,4,1,18],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(31),m3h4x16(:,77),heltab2x64(:,:,353))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[40,1,4,18],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(32),m3h4x16(:,78),heltab2x64(:,:,354))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[40,1,4,18],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(33),m3h4x16(:,79),heltab2x64(:,:,355))
  call Hloop_A_Q(ntryL,G0H16(33),40,0,G1H16(8),n2h16(107))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[40,1,18,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(33),m3h4x16(:,80),heltab2x64(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(33),40,0,G1H16(36),n2h16(108))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,1,8,22],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,261),heltab2x64(:,:,357))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(159))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,1,8,22],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,262),heltab2x64(:,:,358))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,8,1,22],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,263),heltab2x64(:,:,359))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(111),n2h32(160))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,8,1,22],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(112),m3h2x32(:,264),heltab2x64(:,:,360))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,1,22,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,265),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(113),n2h32(161))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,1,22,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(114),m3h2x32(:,266),heltab2x64(:,:,362))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,1,4,26],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,267),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(115),n2h32(162))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,1,4,26],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(116),m3h2x32(:,268),heltab2x64(:,:,364))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,4,1,26],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,269),heltab2x64(:,:,365))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(117),n2h32(163))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[32,4,1,26],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,270),heltab2x64(:,:,366))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[32,1,26,4],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,271),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(119),n2h32(164))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[32,1,26,4],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(120),m3h2x32(:,272),heltab2x64(:,:,368))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[50,4,1,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,52),G0H8(16),m3h8x8(:,17),heltab2x64(:,:,369))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[50,4,1,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,52),G0H8(17),m3h8x8(:,18),heltab2x64(:,:,370))
  call Hloop_Q_A(ntryL,G0H8(17),50,0,G1H8(4),n2h8(256))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[50,1,4,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,52),G0H8(17),m3h8x8(:,19),heltab2x64(:,:,371))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[50,1,8,4],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,52),G0H8(18),m3h8x8(:,20),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[33,2,8,20],[0,0,0,0],4,2,wf4(:,14),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(33),m3h4x16(:,81),heltab2x64(:,:,373))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[33,8,2,20],[0,0,0,0],4,2,wf4(:,14),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(34),m3h4x16(:,82),heltab2x64(:,:,374))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[33,8,2,20],[0,0,0,0],4,2,wf4(:,14),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(35),m3h4x16(:,83),heltab2x64(:,:,375))
  call Hloop_Q_A(ntryL,G0H16(35),33,0,G1H16(40),n2h16(109))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[33,2,20,8],[0,0,0,0],4,2,wf4(:,14),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(35),m3h4x16(:,84),heltab2x64(:,:,376))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[34,1,8,20],[0,0,0,0],4,2,wf4(:,8),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(36),m3h4x16(:,85),heltab2x64(:,:,377))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[34,8,1,20],[0,0,0,0],4,2,wf4(:,8),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(37),m3h4x16(:,86),heltab2x64(:,:,378))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[34,8,1,20],[0,0,0,0],4,2,wf4(:,8),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(38),m3h4x16(:,87),heltab2x64(:,:,379))
  call Hloop_Q_A(ntryL,G0H16(38),34,0,G1H16(45),n2h16(110))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[34,1,20,8],[0,0,0,0],4,2,wf4(:,8),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(38),m3h4x16(:,88),heltab2x64(:,:,380))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[40,2,1,20],[0,0,0,0],4,2,wf4(:,5),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(39),m3h4x16(:,89),heltab2x64(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(17),n2h16(111))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[40,1,2,20],[0,0,0,0],4,2,wf4(:,5),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(39),m3h4x16(:,90),heltab2x64(:,:,382))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(49),n2h16(112))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[40,1,20,2],[0,0,0,0],4,2,wf4(:,5),wf4(:,19))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(39),m3h4x16(:,91),heltab2x64(:,:,383))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[40,1,20,2],[0,0,0,0],4,2,wf4(:,5),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(40),m3h4x16(:,92),heltab2x64(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(40),40,0,G1H16(50),n2h16(113))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,2,8,21],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,273),heltab2x64(:,:,385))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(121),n2h32(165))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,2,8,21],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(122),m3h2x32(:,274),heltab2x64(:,:,386))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,8,2,21],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,275),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(123),n2h32(166))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,8,2,21],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(124),m3h2x32(:,276),heltab2x64(:,:,388))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,2,21,8],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,277),heltab2x64(:,:,389))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(125),n2h32(167))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,2,21,8],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(126),m3h2x32(:,278),heltab2x64(:,:,390))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(14)*M(2,:)%j+c(10)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,1,8,22],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,279),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(127),n2h32(168))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(M(2,:)%j-M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,1,8,22],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,280),heltab2x64(:,:,392))
  Gcoeff(:)%j = (c(14)*M(2,:)%j+c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,8,1,22],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,281),heltab2x64(:,:,393))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(129),n2h32(169))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)+c(19)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,8,1,22],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(130),m3h2x32(:,282),heltab2x64(:,:,394))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,1,22,8],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,283),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(131),n2h32(170))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,1,22,8],[0,0,0,0],4,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(132),m3h2x32(:,284),heltab2x64(:,:,396))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[52,2,1,8],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,94),G0H8(19),m3h8x8(:,21),heltab2x64(:,:,397))
  call Hloop_A_Q(ntryL,G0H8(19),52,0,G1H8(7),n2h8(257))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[52,1,2,8],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,94),G0H8(19),m3h8x8(:,22),heltab2x64(:,:,398))
  call Hloop_A_Q(ntryL,G0H8(19),52,0,G1H8(8),n2h8(258))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[52,1,8,2],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,94),G0H8(19),m3h8x8(:,23),heltab2x64(:,:,399))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[52,1,8,2],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,94),G0H8(20),m3h8x8(:,24),heltab2x64(:,:,400))
  call Hloop_A_Q(ntryL,G0H8(20),52,0,G1H8(37),n2h8(259))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[33,2,4,24],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(40),m3h4x16(:,93),heltab2x64(:,:,401))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[33,4,2,24],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(41),m3h4x16(:,94),heltab2x64(:,:,402))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[33,4,2,24],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(42),m3h4x16(:,95),heltab2x64(:,:,403))
  call Hloop_Q_A(ntryL,G0H16(42),33,0,G1H16(51),n2h16(114))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[33,2,24,4],[0,0,0,0],4,2,wf4(:,14),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(42),m3h4x16(:,96),heltab2x64(:,:,404))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[34,1,4,24],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(43),m3h4x16(:,97),heltab2x64(:,:,405))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[34,4,1,24],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(44),m3h4x16(:,98),heltab2x64(:,:,406))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[34,4,1,24],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(45),m3h4x16(:,99),heltab2x64(:,:,407))
  call Hloop_Q_A(ntryL,G0H16(45),34,0,G1H16(52),n2h16(115))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[34,1,24,4],[0,0,0,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(45),m3h4x16(:,100),heltab2x64(:,:,408))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[36,1,2,24],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(46),m3h4x16(:,101),heltab2x64(:,:,409))
  call Hloop_A_Q(ntryL,G0H16(46),36,0,G1H16(53),n2h16(116))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[36,2,1,24],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(46),m3h4x16(:,102),heltab2x64(:,:,410))
  call Hloop_A_Q(ntryL,G0H16(46),36,0,G1H16(54),n2h16(117))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[36,1,24,2],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(46),m3h4x16(:,103),heltab2x64(:,:,411))
  call Hloop_A_Q(ntryL,G0H16(46),36,0,G1H16(55),n2h16(118))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[36,1,24,2],[0,0,0,0],4,2,wf4(:,17),wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(46),m3h4x16(:,104),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(14)*M(3,:)%j-c(11)*M(4,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,2,4,25],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,285),heltab2x64(:,:,413))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(133),n2h32(171))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)+c(19)*M(4,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,2,4,25],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(134),m3h2x32(:,286),heltab2x64(:,:,414))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j+c(14)*M(3,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[32,4,2,25],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,287),heltab2x64(:,:,415))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(135),n2h32(172))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[32,4,2,25],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,288),heltab2x64(:,:,416))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[32,2,25,4],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,289),heltab2x64(:,:,417))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(137),n2h32(173))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[32,2,25,4],[0,0,0,0],4,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(138),m3h2x32(:,290),heltab2x64(:,:,418))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[32,1,4,26],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,291),heltab2x64(:,:,419))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(139),n2h32(174))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[32,1,4,26],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(140),m3h2x32(:,292),heltab2x64(:,:,420))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,4,1,26],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,293),heltab2x64(:,:,421))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(141),n2h32(175))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,4,1,26],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(142),m3h2x32(:,294),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,1,26,4],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,295),heltab2x64(:,:,423))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(143),n2h32(176))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,1,26,4],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(144),m3h2x32(:,296),heltab2x64(:,:,424))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[56,2,1,4],[0,0,0,0],4,1,wf8(:,87))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,87),G0H8(20),m3h8x8(:,25),heltab2x64(:,:,425))
  call Hloop_A_Q(ntryL,G0H8(20),56,0,G1H8(38),n2h8(260))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[56,1,2,4],[0,0,0,0],4,1,wf8(:,87))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,87),G0H8(20),m3h8x8(:,26),heltab2x64(:,:,426))
  call Hloop_A_Q(ntryL,G0H8(20),56,0,G1H8(49),n2h8(261))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[56,1,4,2],[0,0,0,0],4,1,wf8(:,87))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,87),G0H8(20),m3h8x8(:,27),heltab2x64(:,:,427))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[56,1,4,2],[0,0,0,0],4,1,wf8(:,87))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,87),G0H8(21),m3h8x8(:,28),heltab2x64(:,:,428))
  call Hloop_A_Q(ntryL,G0H8(21),56,0,G1H8(50),n2h8(262))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[37,8,2,16],[0,0,0,0],4,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,41),G0H8(21),m3h8x8(:,29),heltab2x64(:,:,429))
  call Hloop_Q_A(ntryL,G0H8(21),37,0,G1H8(52),n2h8(263))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[37,2,8,16],[0,0,0,0],4,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,41),G0H8(21),m3h8x8(:,30),heltab2x64(:,:,430))
  call Hloop_A_Q(ntryL,G0H8(21),37,0,G1H8(56),n2h8(264))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[37,2,16,8],[0,0,0,0],4,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,41),37,G1H8(67),m3h8x8(:,31),heltab2x64(:,:,431))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[41,4,2,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,42),G0H8(21),m3h8x8(:,32),heltab2x64(:,:,432))
  call Hloop_Q_A(ntryL,G0H8(21),41,0,G1H8(68),n2h8(265))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[41,2,4,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,42),G0H8(21),m3h8x8(:,33),heltab2x64(:,:,433))
  call Hloop_A_Q(ntryL,G0H8(21),41,0,G1H8(69),n2h8(266))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(3,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[41,2,16,4],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,42),41,G1H8(73),m3h8x8(:,34),heltab2x64(:,:,434))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(3,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[49,4,2,8],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,63),G0H8(21),m3h8x8(:,35),heltab2x64(:,:,435))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[49,4,2,8],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,63),G0H8(22),m3h8x8(:,36),heltab2x64(:,:,436))
  call Hloop_Q_A(ntryL,G0H8(22),49,0,G1H8(76),n2h8(267))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(3,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[49,2,4,8],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,63),G0H8(22),m3h8x8(:,37),heltab2x64(:,:,437))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[49,2,8,4],[0,0,0,0],4,1,wf8(:,63))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,63),G0H8(23),m3h8x8(:,38),heltab2x64(:,:,438))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[38,8,1,16],[0,0,0,0],4,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,38),G0H8(24),m3h8x8(:,39),heltab2x64(:,:,439))
  call Hloop_Q_A(ntryL,G0H8(24),38,0,G1H8(79),n2h8(268))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[38,1,8,16],[0,0,0,0],4,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,38),G0H8(24),m3h8x8(:,40),heltab2x64(:,:,440))
  call Hloop_A_Q(ntryL,G0H8(24),38,0,G1H8(80),n2h8(269))
  Gcoeff(:)%j = (c(4)*M(2,:)%j-c(6)*M(4,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[38,1,16,8],[0,0,0,0],4,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,38),38,G1H8(81),m3h8x8(:,41),heltab2x64(:,:,441))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[42,4,1,16],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,37),G0H8(24),m3h8x8(:,42),heltab2x64(:,:,442))
  call Hloop_Q_A(ntryL,G0H8(24),42,0,G1H8(88),n2h8(270))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[42,1,4,16],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,37),G0H8(24),m3h8x8(:,43),heltab2x64(:,:,443))
  call Hloop_A_Q(ntryL,G0H8(24),42,0,G1H8(91),n2h8(271))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[42,1,16,4],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,37),42,G1H8(92),m3h8x8(:,44),heltab2x64(:,:,444))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[50,4,1,8],[0,0,0,0],4,1,wf8(:,53))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,53),G0H8(24),m3h8x8(:,45),heltab2x64(:,:,445))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(17)*M(4,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[50,4,1,8],[0,0,0,0],4,1,wf8(:,53))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,53),G0H8(25),m3h8x8(:,46),heltab2x64(:,:,446))
  call Hloop_Q_A(ntryL,G0H8(25),50,0,G1H8(93),n2h8(272))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[50,1,4,8],[0,0,0,0],4,1,wf8(:,53))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,53),G0H8(25),m3h8x8(:,47),heltab2x64(:,:,447))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(12)*M(4,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[50,1,8,4],[0,0,0,0],4,1,wf8(:,53))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,53),G0H8(26),m3h8x8(:,48),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[37,8,2,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,43),G0H8(27),m3h8x8(:,49),heltab2x64(:,:,449))
  call Hloop_Q_A(ntryL,G0H8(27),37,0,G1H8(99),n2h8(273))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[37,2,8,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,43),G0H8(27),m3h8x8(:,50),heltab2x64(:,:,450))
  call Hloop_A_Q(ntryL,G0H8(27),37,0,G1H8(100),n2h8(274))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[37,2,16,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,43),37,G1H8(103),m3h8x8(:,51),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[38,8,1,16],[0,0,0,0],4,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,39),G0H8(27),m3h8x8(:,52),heltab2x64(:,:,452))
  call Hloop_Q_A(ntryL,G0H8(27),38,0,G1H8(104),n2h8(275))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[38,1,8,16],[0,0,0,0],4,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,39),G0H8(27),m3h8x8(:,53),heltab2x64(:,:,453))
  call Hloop_A_Q(ntryL,G0H8(27),38,0,G1H8(14),n2h8(276))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[38,1,16,8],[0,0,0,0],4,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,39),38,G1H8(15),m3h8x8(:,54),heltab2x64(:,:,454))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(15)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[52,2,1,8],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,95),G0H8(27),m3h8x8(:,55),heltab2x64(:,:,455))
  call Hloop_A_Q(ntryL,G0H8(27),52,0,G1H8(16),n2h8(277))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[52,1,2,8],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,95),G0H8(27),m3h8x8(:,56),heltab2x64(:,:,456))
  call Hloop_A_Q(ntryL,G0H8(27),52,0,G1H8(20),n2h8(278))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(10)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[52,1,8,2],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,95),G0H8(27),m3h8x8(:,57),heltab2x64(:,:,457))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[52,1,8,2],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,95),G0H8(28),m3h8x8(:,58),heltab2x64(:,:,458))
  call Hloop_A_Q(ntryL,G0H8(28),52,0,G1H8(64),n2h8(279))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[41,4,2,16],[0,0,0,0],4,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,44),G0H8(28),m3h8x8(:,59),heltab2x64(:,:,459))
  call Hloop_Q_A(ntryL,G0H8(28),41,0,G1H8(63),n2h8(280))
  Gcoeff(:)%j = (c(10)*M(3,:)%j-c(11)*M(4,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[41,2,4,16],[0,0,0,0],4,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,44),G0H8(28),m3h8x8(:,60),heltab2x64(:,:,460))
  call Hloop_A_Q(ntryL,G0H8(28),41,0,G1H8(36),n2h8(281))
  Gcoeff(:)%j = (c(4)*M(3,:)%j-c(6)*M(4,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[41,2,16,4],[0,0,0,0],4,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,44),41,G1H8(42),m3h8x8(:,61),heltab2x64(:,:,461))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[42,4,1,16],[0,0,0,0],4,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,40),G0H8(28),m3h8x8(:,62),heltab2x64(:,:,462))
  call Hloop_Q_A(ntryL,G0H8(28),42,0,G1H8(53),n2h8(282))
  Gcoeff(:)%j = (c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[42,1,4,16],[0,0,0,0],4,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,40),G0H8(28),m3h8x8(:,63),heltab2x64(:,:,463))
  call Hloop_A_Q(ntryL,G0H8(28),42,0,G1H8(54),n2h8(283))
  Gcoeff(:)%j = (c(6)*M(3,:)%j-c(4)*M(4,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[42,1,16,4],[0,0,0,0],4,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,40),42,G1H8(43),m3h8x8(:,64),heltab2x64(:,:,464))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[56,2,1,4],[0,0,0,0],4,1,wf8(:,88))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,88),G0H8(28),m3h8x8(:,65),heltab2x64(:,:,465))
  call Hloop_A_Q(ntryL,G0H8(28),56,0,G1H8(71),n2h8(284))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(12)*M(4,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[56,1,2,4],[0,0,0,0],4,1,wf8(:,88))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,88),G0H8(28),m3h8x8(:,66),heltab2x64(:,:,466))
  call Hloop_A_Q(ntryL,G0H8(28),56,0,G1H8(83),n2h8(285))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[56,1,4,2],[0,0,0,0],4,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,88),G0H8(28),m3h8x8(:,67),heltab2x64(:,:,467))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(17)*M(4,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[56,1,4,2],[0,0,0,0],4,1,wf8(:,88))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,88),G0H8(29),m3h8x8(:,68),heltab2x64(:,:,468))
  call Hloop_A_Q(ntryL,G0H8(29),56,0,G1H8(89),n2h8(286))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(67),G1H8(261),G1H8(87),G0H8(3),G0H8(2) &
    ,G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(81),G1H8(278),G1H8(97),G0H8(6),G0H8(5) &
    ,G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(73),G1H8(65),G0H8(9),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(92),G1H8(2),G0H8(12),G0H8(11),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(3),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(99),[G1H8(52),G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(56),G1H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(33),[G1H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(34),[G1H32(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(37),[G1H32(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(38),[G1H32(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(41),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(42),[G1H32(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(79),G1H8(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(80),G1H8(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(68),G1H8(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(69),G1H8(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(88),G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(91),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(93),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(27),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(28),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(50)])
  call Hloop_VQ_A(ntryL,G1H8(103),ex2(:),G1H4(225),m3h2x4(:,327),heltab2x8(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(225),39,0,G2H4(70),n2h4(315))
  call Hloop_VQ_A(ntryL,G1H8(15),ex1(:),G1H4(232),m3h2x4(:,328),heltab2x8(:,:,426))
  call Hloop_Q_A(ntryL,G1H4(232),39,0,G2H4(72),n2h4(316))
  call Hloop_AV_Q(ntryL,G1H8(9),ex5(:),G1H4(238),m3h2x4(:,329),heltab2x8(:,:,427))
  call Hloop_A_Q(ntryL,G1H4(238),53,0,G2H4(118),n2h4(317))
  call Hloop_AV_Q(ntryL,G1H8(19),ex5(:),G1H4(243),m3h2x4(:,330),heltab2x8(:,:,428))
  call Hloop_A_Q(ntryL,G1H4(243),54,0,G2H4(122),n2h4(318))
  call Hloop_QV_A(ntryL,G1H16(1),ex5(:),G1H8(90),m3h2x8(:,223),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G1H8(90),50,0,G2H8(47),n2h8(287))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(95),m3h2x8(:,224),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H8(95),50,0,G2H8(48),n2h8(288))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,1),G1H4(248),m3h4x4(:,47),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(248),39,0,G2H4(123),n2h4(319))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(25),m3h2x8(:,225),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G1H8(25),49,0,G2H8(49),n2h8(289))
  call Hloop_QV_A(ntryL,G1H16(73),ex5(:),G1H8(26),m3h2x8(:,226),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G1H8(26),49,0,G2H8(51),n2h8(290))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,11),G1H4(255),m3h4x4(:,48),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(255),39,0,G2H4(126),n2h4(320))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(27),m3h2x8(:,227),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G1H8(27),50,0,G2H8(52),n2h8(291))
  call Hloop_QV_A(ntryL,G1H16(85),ex5(:),G1H8(31),m3h2x8(:,228),heltab2x16(:,:,276))
  call Hloop_Q_A(ntryL,G1H8(31),50,0,G2H8(53),n2h8(292))
  call Hloop_AV_Q(ntryL,G1H16(91),ex5(:),G1H8(34),m3h2x8(:,229),heltab2x16(:,:,277))
  call Hloop_A_Q(ntryL,G1H8(34),52,0,G2H8(55),n2h8(293))
  call Hloop_QV_A(ntryL,G1H16(96),wf4(:,15),G1H4(256),m3h4x4(:,49),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(256),43,0,G2H4(127),n2h4(321))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(82),m3h2x8(:,230),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G1H8(82),49,0,G2H8(56),n2h8(294))
  call Hloop_QV_A(ntryL,G1H16(103),ex5(:),G1H8(70),m3h2x8(:,231),heltab2x16(:,:,280))
  call Hloop_Q_A(ntryL,G1H8(70),49,0,G2H8(57),n2h8(295))
  call Hloop_AV_Q(ntryL,G1H16(109),ex5(:),G1H8(29),m3h2x8(:,232),heltab2x16(:,:,281))
  call Hloop_A_Q(ntryL,G1H8(29),52,0,G2H8(59),n2h8(296))
  call Hloop_QV_A(ntryL,G1H16(114),wf4(:,20),G1H4(260),m3h4x4(:,50),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(260),43,0,G2H4(128),n2h4(322))
  call Hloop_VQ_A(ntryL,G1H8(42),ex2(:),G1H4(261),m3h2x4(:,331),heltab2x8(:,:,429))
  call Hloop_Q_A(ntryL,G1H4(261),43,0,G2H4(131),n2h4(323))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(268),m3h2x4(:,332),heltab2x8(:,:,430))
  call Hloop_Q_A(ntryL,G1H4(268),43,0,G2H4(132),n2h4(324))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,20),G1H8(11),m3h4x8(:,13),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(11),42,0,G2H8(60),n2h8(297))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,20),G1H8(60),m3h4x8(:,14),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(60),42,0,G2H8(61),n2h8(298))
  call Hloop_AV_Q(ntryL,G1H32(7),wf4(:,1),G1H8(12),m3h4x8(:,15),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(12),37,0,G2H8(63),n2h8(299))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,1),G1H8(48),m3h4x8(:,16),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G1H8(48),37,0,G2H8(64),n2h8(300))
  call Hloop_QV_A(ntryL,G1H32(11),wf4(:,1),G1H8(30),m3h4x8(:,17),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(1),n2h8(301))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,1),G1H8(35),m3h4x8(:,18),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H8(35),37,0,G2H8(2),n2h8(302))
  call Hloop_QA_V(ntryL,G1H32(13),ex4(:),G1H16(56),m3h2x16(:,141),heltab2x32(:,:,159))
  call Hloop_VA_Q(ntryL,G1H32(14),ex4(:),G1H16(57),m3h2x16(:,142),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H16(57),40,0,G2H16(1),n2h16(119))
  call Hloop_AV_Q(ntryL,G1H32(15),wf4(:,1),G1H8(41),m3h4x8(:,19),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(41),37,0,G2H8(3),n2h8(303))
  call Hloop_UV_W(ntryL,G1H32(16),32,wf4(:,1),5,G2H8(4),m3h4x8(:,20),heltab2x32(:,:,162))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,1),G1H8(47),m3h4x8(:,21),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(47),37,0,G2H8(5),n2h8(304))
  call Hloop_UV_W(ntryL,G1H32(18),32,wf4(:,1),5,G2H8(6),m3h4x8(:,22),heltab2x32(:,:,164))
  call Hloop_AQ_V(ntryL,G1H32(19),ex2(:),G1H16(58),m3h2x16(:,143),heltab2x32(:,:,165))
  call Hloop_VQ_A(ntryL,G1H32(20),ex2(:),G1H16(59),m3h2x16(:,144),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G1H16(59),34,0,G2H16(2),n2h16(120))
  call Hloop_AQ_V(ntryL,G1H32(21),ex2(:),G1H16(60),m3h2x16(:,145),heltab2x32(:,:,167))
  call Hloop_VQ_A(ntryL,G1H32(22),ex2(:),G1H16(61),m3h2x16(:,146),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G1H16(61),34,0,G2H16(3),n2h16(121))
  call Hloop_AV_Q(ntryL,G1H32(23),wf4(:,1),G1H8(107),m3h4x8(:,23),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H8(107),37,0,G2H8(7),n2h8(305))
  call Hloop_UV_W(ntryL,G1H32(24),32,wf4(:,1),5,G2H8(8),m3h4x8(:,24),heltab2x32(:,:,170))
  call Hloop_UV_W(ntryL,G0H16(1),34,wf4(:,1),5,G1H4(272),m3h4x4(:,51),heltab2x16(:,:,283))
  call Hloop_VA_Q(ntryL,G0H16(3),ex4(:),G0H8(29),m3h2x8(:,233),heltab2x16(:,:,284))
  call Hloop_A_Q(ntryL,G0H8(29),42,0,G1H8(108),n2h8(306))
  call Hloop_UV_W(ntryL,G0H16(4),40,wf4(:,1),5,G1H4(273),m3h4x4(:,52),heltab2x16(:,:,285))
  call Hloop_VQ_A(ntryL,G0H16(5),ex2(:),G0H8(3),m3h2x8(:,234),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G0H8(3),42,0,G1H8(109),n2h8(307))
  call Hloop_VQ_A(ntryL,G0H16(6),ex2(:),G0H8(2),m3h2x8(:,235),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G0H8(2),42,0,G1H8(110),n2h8(308))
  call Hloop_VQ_A(ntryL,G1H32(25),wf8(:,8),G1H4(274),m3h8x4(:,1),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(274),39,0,G2H4(137),n2h4(325))
  call Hloop_AQ_V(ntryL,G1H32(26),wf8(:,8),G1H4(286),m3h8x4(:,2),heltab2x32(:,:,172))
  call Hloop_QA_V(ntryL,G1H32(27),ex4(:),G1H16(62),m3h2x16(:,147),heltab2x32(:,:,173))
  call Hloop_VQ_A(ntryL,G1H32(28),ex2(:),G1H16(63),m3h2x16(:,148),heltab2x32(:,:,174))
  call Hloop_Q_A(ntryL,G1H16(63),34,0,G2H16(4),n2h16(122))
  call Hloop_QA_V(ntryL,G1H32(29),wf8(:,3),G1H4(291),m3h8x4(:,3),heltab2x32(:,:,175))
  call Hloop_AQ_V(ntryL,G1H32(30),ex2(:),G1H16(25),m3h2x16(:,149),heltab2x32(:,:,176))
  call Hloop_QA_V(ntryL,G1H8(99),ex4(:),G1H4(110),m3h2x4(:,333),heltab2x8(:,:,431))
  call Hloop_AQ_V(ntryL,G1H8(100),ex2(:),G1H4(134),m3h2x4(:,334),heltab2x8(:,:,432))
  call Hloop_AV_Q(ntryL,G1H32(33),wf4(:,11),G1H8(113),m3h4x8(:,25),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H8(113),38,0,G2H8(34),n2h8(309))
  call Hloop_QV_A(ntryL,G1H32(34),wf4(:,11),G1H8(114),m3h4x8(:,26),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(114),38,0,G2H8(38),n2h8(310))
  call Hloop_AV_Q(ntryL,G1H32(37),wf4(:,15),G1H8(115),m3h4x8(:,27),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(115),41,0,G2H8(42),n2h8(311))
  call Hloop_QV_A(ntryL,G1H32(38),wf4(:,15),G1H8(116),m3h4x8(:,28),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(116),41,0,G2H8(46),n2h8(312))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,11),G1H8(119),m3h4x8(:,29),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(119),38,0,G2H8(50),n2h8(313))
  call Hloop_QV_A(ntryL,G1H32(42),wf4(:,11),G1H8(120),m3h4x8(:,30),heltab2x32(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(120),38,0,G2H8(54),n2h8(314))
  call Hloop_AV_Q(ntryL,G1H32(43),wf4(:,11),G1H8(121),m3h4x8(:,31),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(121),38,0,G2H8(58),n2h8(315))
  call Hloop_UV_W(ntryL,G1H32(44),32,wf4(:,11),6,G2H8(62),m3h4x8(:,32),heltab2x32(:,:,184))
  call Hloop_QA_V(ntryL,G1H32(45),ex4(:),G1H16(3),m3h2x16(:,150),heltab2x32(:,:,185))
  call Hloop_VA_Q(ntryL,G1H32(46),ex4(:),G1H16(26),m3h2x16(:,151),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H16(26),40,0,G2H16(5),n2h16(123))
  call Hloop_QV_A(ntryL,G1H32(47),wf4(:,11),G1H8(122),m3h4x8(:,33),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(122),38,0,G2H8(20),n2h8(316))
  call Hloop_UV_W(ntryL,G1H32(48),32,wf4(:,11),6,G2H8(24),m3h4x8(:,34),heltab2x32(:,:,188))
  call Hloop_AQ_V(ntryL,G1H32(49),ex1(:),G1H16(27),m3h2x16(:,152),heltab2x32(:,:,189))
  call Hloop_VQ_A(ntryL,G1H32(50),ex1(:),G1H16(4),m3h2x16(:,153),heltab2x32(:,:,190))
  call Hloop_Q_A(ntryL,G1H16(4),33,0,G2H16(6),n2h16(124))
  call Hloop_AQ_V(ntryL,G1H32(51),ex1(:),G1H16(5),m3h2x16(:,154),heltab2x32(:,:,191))
  call Hloop_VQ_A(ntryL,G1H32(52),ex1(:),G1H16(29),m3h2x16(:,155),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G1H16(29),33,0,G2H16(7),n2h16(125))
  call Hloop_AV_Q(ntryL,G1H32(53),wf4(:,11),G1H8(125),m3h4x8(:,35),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H8(125),38,0,G2H8(17),n2h8(317))
  call Hloop_UV_W(ntryL,G1H32(54),32,wf4(:,11),6,G2H8(21),m3h4x8(:,36),heltab2x32(:,:,194))
  call Hloop_UV_W(ntryL,G0H16(8),33,wf4(:,11),6,G1H4(146),m3h4x4(:,53),heltab2x16(:,:,288))
  call Hloop_VA_Q(ntryL,G0H16(9),ex4(:),G0H8(1),m3h2x8(:,236),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G0H8(1),41,0,G1H8(126),n2h8(318))
  call Hloop_UV_W(ntryL,G0H16(10),40,wf4(:,11),6,G1H4(182),m3h4x4(:,54),heltab2x16(:,:,290))
  call Hloop_VQ_A(ntryL,G0H16(11),ex1(:),G0H8(6),m3h2x8(:,237),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G0H8(6),41,0,G1H8(127),n2h8(319))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(5),m3h2x8(:,238),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G0H8(5),41,0,G1H8(128),n2h8(320))
  call Hloop_VQ_A(ntryL,G1H32(55),wf8(:,18),G1H4(194),m3h8x4(:,4),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(194),39,0,G2H4(142),n2h4(326))
  call Hloop_AQ_V(ntryL,G1H32(56),wf8(:,18),G1H4(206),m3h8x4(:,5),heltab2x32(:,:,196))
  call Hloop_QA_V(ntryL,G1H32(57),ex4(:),G1H16(30),m3h2x16(:,156),heltab2x32(:,:,197))
  call Hloop_VQ_A(ntryL,G1H32(58),ex1(:),G1H16(7),m3h2x16(:,157),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G1H16(7),33,0,G2H16(8),n2h16(126))
  call Hloop_QA_V(ntryL,G1H32(59),wf8(:,16),G1H4(218),m3h8x4(:,6),heltab2x32(:,:,199))
  call Hloop_AQ_V(ntryL,G1H32(60),ex1(:),G1H16(11),m3h2x16(:,158),heltab2x32(:,:,200))
  call Hloop_QA_V(ntryL,G1H8(104),ex4(:),G1H4(254),m3h2x4(:,335),heltab2x8(:,:,433))
  call Hloop_AQ_V(ntryL,G1H8(14),ex1(:),G1H4(266),m3h2x4(:,336),heltab2x8(:,:,434))
  call Hloop_QA_V(ntryL,G1H32(61),ex3(:),G1H16(64),m3h2x16(:,159),heltab2x32(:,:,201))
  call Hloop_VA_Q(ntryL,G1H32(62),ex3(:),G1H16(66),m3h2x16(:,160),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(66),36,0,G2H16(9),n2h16(127))
  call Hloop_QA_V(ntryL,G1H32(63),ex3(:),G1H16(67),m3h2x16(:,161),heltab2x32(:,:,203))
  call Hloop_VA_Q(ntryL,G1H32(64),ex3(:),G1H16(68),m3h2x16(:,162),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H16(68),36,0,G2H16(10),n2h16(128))
  call Hloop_QV_A(ntryL,G1H32(65),wf4(:,15),G1H8(131),m3h4x8(:,37),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(131),41,0,G2H8(9),n2h8(321))
  call Hloop_UV_W(ntryL,G1H32(66),32,wf4(:,15),9,G2H8(10),m3h4x8(:,38),heltab2x32(:,:,206))
  call Hloop_AQ_V(ntryL,G1H32(67),ex2(:),G1H16(13),m3h2x16(:,163),heltab2x32(:,:,207))
  call Hloop_VQ_A(ntryL,G1H32(68),ex2(:),G1H16(14),m3h2x16(:,164),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G1H16(14),34,0,G2H16(11),n2h16(129))
  call Hloop_AQ_V(ntryL,G1H32(69),ex2(:),G1H16(31),m3h2x16(:,165),heltab2x32(:,:,209))
  call Hloop_VQ_A(ntryL,G1H32(70),ex2(:),G1H16(69),m3h2x16(:,166),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G1H16(69),34,0,G2H16(12),n2h16(130))
  call Hloop_AV_Q(ntryL,G1H32(71),wf4(:,15),G1H8(132),m3h4x8(:,39),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H8(132),41,0,G2H8(11),n2h8(322))
  call Hloop_UV_W(ntryL,G1H32(72),32,wf4(:,15),9,G2H8(12),m3h4x8(:,40),heltab2x32(:,:,212))
  call Hloop_UV_W(ntryL,G0H16(13),34,wf4(:,15),9,G1H4(278),m3h4x4(:,55),heltab2x16(:,:,293))
  call Hloop_VA_Q(ntryL,G0H16(14),ex3(:),G0H8(4),m3h2x8(:,239),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G0H8(4),38,0,G1H8(133),n2h8(323))
  call Hloop_VA_Q(ntryL,G0H16(15),ex3(:),G0H8(9),m3h2x8(:,240),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G0H8(9),38,0,G1H8(134),n2h8(324))
  call Hloop_UV_W(ntryL,G0H16(16),36,wf4(:,15),9,G1H4(14),m3h4x4(:,56),heltab2x16(:,:,296))
  call Hloop_VQ_A(ntryL,G0H16(17),ex2(:),G0H8(8),m3h2x8(:,241),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G0H8(8),38,0,G1H8(137),n2h8(325))
  call Hloop_VQ_A(ntryL,G0H16(18),ex2(:),G0H8(7),m3h2x8(:,242),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G0H8(7),38,0,G1H8(138),n2h8(326))
  call Hloop_VA_Q(ntryL,G1H32(73),ex3(:),G1H16(70),m3h2x16(:,167),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(70),36,0,G2H16(13),n2h16(131))
  call Hloop_AQ_V(ntryL,G1H32(74),wf8(:,27),G1H4(15),m3h8x4(:,7),heltab2x32(:,:,214))
  call Hloop_QA_V(ntryL,G1H32(75),ex3(:),G1H16(71),m3h2x16(:,168),heltab2x32(:,:,215))
  call Hloop_VQ_A(ntryL,G1H32(76),ex2(:),G1H16(72),m3h2x16(:,169),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G1H16(72),34,0,G2H16(14),n2h16(132))
  call Hloop_QA_V(ntryL,G1H32(77),wf8(:,22),G1H4(16),m3h8x4(:,8),heltab2x32(:,:,217))
  call Hloop_AQ_V(ntryL,G1H32(78),ex2(:),G1H16(74),m3h2x16(:,170),heltab2x32(:,:,218))
  call Hloop_QA_V(ntryL,G1H8(63),ex3(:),G1H4(20),m3h2x4(:,337),heltab2x8(:,:,435))
  call Hloop_AQ_V(ntryL,G1H8(36),ex2(:),G1H4(26),m3h2x4(:,338),heltab2x8(:,:,436))
  call Hloop_QA_V(ntryL,G1H32(79),ex3(:),G1H16(75),m3h2x16(:,171),heltab2x32(:,:,219))
  call Hloop_VA_Q(ntryL,G1H32(80),ex3(:),G1H16(76),m3h2x16(:,172),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H16(76),36,0,G2H16(15),n2h16(133))
  call Hloop_QA_V(ntryL,G1H32(81),ex3(:),G1H16(18),m3h2x16(:,173),heltab2x32(:,:,221))
  call Hloop_VA_Q(ntryL,G1H32(82),ex3(:),G1H16(77),m3h2x16(:,174),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G1H16(77),36,0,G2H16(16),n2h16(134))
  call Hloop_QV_A(ntryL,G1H32(83),wf4(:,20),G1H8(139),m3h4x8(:,41),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(139),42,0,G2H8(13),n2h8(327))
  call Hloop_UV_W(ntryL,G1H32(84),32,wf4(:,20),10,G2H8(14),m3h4x8(:,42),heltab2x32(:,:,224))
  call Hloop_AQ_V(ntryL,G1H32(85),ex1(:),G1H16(79),m3h2x16(:,175),heltab2x32(:,:,225))
  call Hloop_VQ_A(ntryL,G1H32(86),ex1(:),G1H16(80),m3h2x16(:,176),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G1H16(80),33,0,G2H16(17),n2h16(135))
  call Hloop_AQ_V(ntryL,G1H32(87),ex1(:),G1H16(81),m3h2x16(:,177),heltab2x32(:,:,227))
  call Hloop_VQ_A(ntryL,G1H32(88),ex1(:),G1H16(21),m3h2x16(:,178),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(18),n2h16(136))
  call Hloop_AV_Q(ntryL,G1H32(89),wf4(:,20),G1H8(140),m3h4x8(:,43),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G1H8(140),42,0,G2H8(15),n2h8(328))
  call Hloop_UV_W(ntryL,G1H32(90),32,wf4(:,20),10,G2H8(16),m3h4x8(:,44),heltab2x32(:,:,230))
  call Hloop_VA_Q(ntryL,G0H16(19),ex3(:),G0H8(12),m3h2x8(:,243),heltab2x16(:,:,299))
  call Hloop_A_Q(ntryL,G0H8(12),37,0,G1H8(143),n2h8(329))
  call Hloop_UV_W(ntryL,G0H16(20),33,wf4(:,20),10,G1H4(27),m3h4x4(:,57),heltab2x16(:,:,300))
  call Hloop_VA_Q(ntryL,G0H16(21),ex3(:),G0H8(11),m3h2x8(:,244),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G0H8(11),37,0,G1H8(144),n2h8(330))
  call Hloop_UV_W(ntryL,G0H16(22),36,wf4(:,20),10,G1H4(28),m3h4x4(:,58),heltab2x16(:,:,302))
  call Hloop_VQ_A(ntryL,G0H16(23),ex1(:),G0H8(10),m3h2x8(:,245),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G0H8(10),37,0,G1H8(145),n2h8(331))
  call Hloop_VQ_A(ntryL,G0H16(24),ex1(:),G0H8(13),m3h2x8(:,246),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(146),n2h8(332))
  call Hloop_VA_Q(ntryL,G1H32(91),ex3(:),G1H16(22),m3h2x16(:,179),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G1H16(22),36,0,G2H16(19),n2h16(137))
  call Hloop_AQ_V(ntryL,G1H32(92),wf8(:,35),G1H4(32),m3h8x4(:,9),heltab2x32(:,:,232))
  call Hloop_QA_V(ntryL,G1H32(93),ex3(:),G1H16(24),m3h2x16(:,180),heltab2x32(:,:,233))
  call Hloop_VQ_A(ntryL,G1H32(94),ex1(:),G1H16(34),m3h2x16(:,181),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G1H16(34),33,0,G2H16(20),n2h16(138))
  call Hloop_QA_V(ntryL,G1H32(95),wf8(:,33),G1H4(233),m3h8x4(:,10),heltab2x32(:,:,235))
  call Hloop_AQ_V(ntryL,G1H32(96),ex1(:),G1H16(82),m3h2x16(:,182),heltab2x32(:,:,236))
  call Hloop_QA_V(ntryL,G1H8(53),ex3(:),G1H4(439),m3h2x4(:,339),heltab2x8(:,:,437))
  call Hloop_AQ_V(ntryL,G1H8(54),ex1(:),G1H4(40),m3h2x4(:,340),heltab2x8(:,:,438))
  call Hloop_QA_V(ntryL,G1H16(39),ex4(:),G1H8(149),m3h2x8(:,247),heltab2x16(:,:,305))
  call Hloop_QA_V(ntryL,G1H16(10),ex3(:),G1H8(150),m3h2x8(:,248),heltab2x16(:,:,306))
  call Hloop_VA_Q(ntryL,G0H16(2),ex3(:),G0H8(14),m3h2x8(:,249),heltab2x16(:,:,307))
  call Hloop_A_Q(ntryL,G0H8(14),38,0,G1H8(151),n2h8(333))
  call Hloop_QA_V(ntryL,G1H16(32),ex3(:),G1H8(152),m3h2x8(:,250),heltab2x16(:,:,308))
  call Hloop_VA_Q(ntryL,G0H16(7),ex4(:),G0H8(15),m3h2x8(:,251),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G0H8(15),44,0,G1H8(155),n2h8(334))
  call Hloop_VQ_A(ntryL,G0H16(25),ex2(:),G0H8(16),m3h2x8(:,252),heltab2x16(:,:,310))
  call Hloop_Q_A(ntryL,G0H8(16),38,0,G1H8(156),n2h8(335))
  call Hloop_AQ_V(ntryL,G1H16(35),ex2(:),G1H8(157),m3h2x8(:,253),heltab2x16(:,:,311))
  call Hloop_AQ_V(ntryL,G1H16(37),ex2(:),G1H8(158),m3h2x8(:,254),heltab2x16(:,:,312))
  call Hloop_VA_Q(ntryL,G0H16(26),ex3(:),G0H8(17),m3h2x8(:,255),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G0H8(17),44,0,G1H8(161),n2h8(336))
  call Hloop_VQ_A(ntryL,G0H16(27),ex2(:),G0H8(18),m3h2x8(:,256),heltab2x16(:,:,314))
  call Hloop_Q_A(ntryL,G0H8(18),42,0,G1H8(162),n2h8(337))
  call Hloop_AQ_V(ntryL,G1H16(47),ex2(:),G1H8(163),m3h2x8(:,257),heltab2x16(:,:,315))
  call Hloop_AQ_V(ntryL,G1H16(48),ex2(:),G1H8(164),m3h2x8(:,258),heltab2x16(:,:,316))
  call Hloop_AQ_V(ntryL,G1H32(97),ex2(:),G1H16(83),m3h2x16(:,183),heltab2x32(:,:,237))
  call Hloop_VQ_A(ntryL,G1H32(98),ex2(:),G1H16(84),m3h2x16(:,184),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G1H16(84),34,0,G2H16(21),n2h16(139))
  call Hloop_QA_V(ntryL,G1H32(99),ex4(:),G1H16(86),m3h2x16(:,185),heltab2x32(:,:,239))
  call Hloop_VA_Q(ntryL,G1H32(100),ex4(:),G1H16(87),m3h2x16(:,186),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G1H16(87),40,0,G2H16(22),n2h16(140))
  call Hloop_AQ_V(ntryL,G1H32(101),ex2(:),G1H16(88),m3h2x16(:,187),heltab2x32(:,:,241))
  call Hloop_VQ_A(ntryL,G1H32(102),ex2(:),G1H16(89),m3h2x16(:,188),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G1H16(89),34,0,G2H16(23),n2h16(141))
  call Hloop_AQ_V(ntryL,G1H32(103),ex2(:),G1H16(90),m3h2x16(:,189),heltab2x32(:,:,243))
  call Hloop_VQ_A(ntryL,G1H32(104),ex2(:),G1H16(92),m3h2x16(:,190),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G1H16(92),34,0,G2H16(24),n2h16(142))
  call Hloop_QA_V(ntryL,G1H32(105),ex3(:),G1H16(93),m3h2x16(:,191),heltab2x32(:,:,245))
  call Hloop_VA_Q(ntryL,G1H32(106),ex3(:),G1H16(94),m3h2x16(:,192),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G1H16(94),36,0,G2H16(25),n2h16(143))
  call Hloop_AQ_V(ntryL,G1H32(107),ex2(:),G1H16(38),m3h2x16(:,193),heltab2x32(:,:,247))
  call Hloop_VQ_A(ntryL,G1H32(108),ex2(:),G1H16(95),m3h2x16(:,194),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G1H16(95),34,0,G2H16(26),n2h16(144))
  call Hloop_VA_Q(ntryL,G0H8(21),ex3(:),G0H4(1),m3h2x4(:,341),heltab2x8(:,:,439))
  call Hloop_A_Q(ntryL,G0H4(1),53,0,G1H4(44),n2h4(327))
  call Hloop_QA_V(ntryL,G1H8(76),ex3(:),G1H4(51),m3h2x4(:,342),heltab2x8(:,:,440))
  call Hloop_VQ_A(ntryL,G0H8(22),ex2(:),G0H4(1),m3h2x4(:,343),heltab2x8(:,:,441))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(76),n2h4(328))
  call Hloop_VQ_A(ntryL,G0H8(23),ex2(:),G0H4(1),m3h2x4(:,344),heltab2x8(:,:,442))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(82),n2h4(329))
  call Hloop_QA_V(ntryL,G1H16(2),ex3(:),G1H8(167),m3h2x8(:,259),heltab2x16(:,:,317))
  call Hloop_QA_V(ntryL,G1H16(33),ex4(:),G1H8(168),m3h2x8(:,260),heltab2x16(:,:,318))
  call Hloop_QA_V(ntryL,G1H16(12),ex3(:),G1H8(169),m3h2x8(:,261),heltab2x16(:,:,319))
  call Hloop_VA_Q(ntryL,G0H16(28),ex3(:),G0H8(19),m3h2x8(:,262),heltab2x16(:,:,320))
  call Hloop_A_Q(ntryL,G0H8(19),37,0,G1H8(170),n2h8(338))
  call Hloop_VA_Q(ntryL,G0H16(29),ex4(:),G0H8(20),m3h2x8(:,263),heltab2x16(:,:,321))
  call Hloop_A_Q(ntryL,G0H8(20),44,0,G1H8(173),n2h8(339))
  call Hloop_VQ_A(ntryL,G0H16(30),ex1(:),G0H8(29),m3h2x8(:,264),heltab2x16(:,:,322))
  call Hloop_Q_A(ntryL,G0H8(29),37,0,G1H8(174),n2h8(340))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(175),m3h2x8(:,265),heltab2x16(:,:,323))
  call Hloop_AQ_V(ntryL,G1H16(9),ex1(:),G1H8(176),m3h2x8(:,266),heltab2x16(:,:,324))
  call Hloop_VA_Q(ntryL,G0H16(31),ex3(:),G0H8(3),m3h2x8(:,267),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(179),n2h8(341))
  call Hloop_VQ_A(ntryL,G0H16(32),ex1(:),G0H8(2),m3h2x8(:,268),heltab2x16(:,:,326))
  call Hloop_Q_A(ntryL,G0H8(2),41,0,G1H8(180),n2h8(342))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(181),m3h2x8(:,269),heltab2x16(:,:,327))
  call Hloop_AQ_V(ntryL,G1H16(36),ex1(:),G1H8(182),m3h2x8(:,270),heltab2x16(:,:,328))
  call Hloop_AQ_V(ntryL,G1H32(109),ex1(:),G1H16(97),m3h2x16(:,195),heltab2x32(:,:,249))
  call Hloop_VQ_A(ntryL,G1H32(110),ex1(:),G1H16(98),m3h2x16(:,196),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G1H16(98),33,0,G2H16(27),n2h16(145))
  call Hloop_QA_V(ntryL,G1H32(111),ex4(:),G1H16(99),m3h2x16(:,197),heltab2x32(:,:,251))
  call Hloop_VA_Q(ntryL,G1H32(112),ex4(:),G1H16(41),m3h2x16(:,198),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G1H16(41),40,0,G2H16(28),n2h16(146))
  call Hloop_AQ_V(ntryL,G1H32(113),ex1(:),G1H16(42),m3h2x16(:,199),heltab2x32(:,:,253))
  call Hloop_VQ_A(ntryL,G1H32(114),ex1(:),G1H16(44),m3h2x16(:,200),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G1H16(44),33,0,G2H16(29),n2h16(147))
  call Hloop_AQ_V(ntryL,G1H32(115),ex1(:),G1H16(46),m3h2x16(:,201),heltab2x32(:,:,255))
  call Hloop_VQ_A(ntryL,G1H32(116),ex1(:),G1H16(100),m3h2x16(:,202),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G1H16(100),33,0,G2H16(30),n2h16(148))
  call Hloop_QA_V(ntryL,G1H32(117),ex3(:),G1H16(101),m3h2x16(:,203),heltab2x32(:,:,257))
  call Hloop_VA_Q(ntryL,G1H32(118),ex3(:),G1H16(102),m3h2x16(:,204),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G1H16(102),36,0,G2H16(31),n2h16(149))
  call Hloop_AQ_V(ntryL,G1H32(119),ex1(:),G1H16(104),m3h2x16(:,205),heltab2x32(:,:,259))
  call Hloop_VQ_A(ntryL,G1H32(120),ex1(:),G1H16(105),m3h2x16(:,206),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G1H16(105),33,0,G2H16(32),n2h16(150))
  call Hloop_VA_Q(ntryL,G0H8(24),ex3(:),G0H4(1),m3h2x4(:,345),heltab2x8(:,:,443))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(294),n2h4(330))
  call Hloop_QA_V(ntryL,G1H8(93),ex3(:),G1H4(433),m3h2x4(:,346),heltab2x8(:,:,444))
  call Hloop_VQ_A(ntryL,G0H8(25),ex1(:),G0H4(1),m3h2x4(:,347),heltab2x8(:,:,445))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(435),n2h4(331))
  call Hloop_VQ_A(ntryL,G0H8(26),ex1(:),G0H4(1),m3h2x4(:,348),heltab2x8(:,:,446))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(438),n2h4(332))
  call Hloop_VQ_A(ntryL,G0H16(33),ex2(:),G0H8(1),m3h2x8(:,271),heltab2x16(:,:,329))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(185),n2h8(343))
  call Hloop_VA_Q(ntryL,G0H16(34),ex4(:),G0H8(6),m3h2x8(:,272),heltab2x16(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(6),41,0,G1H8(186),n2h8(344))
  call Hloop_QA_V(ntryL,G1H16(40),ex4(:),G1H8(187),m3h2x8(:,273),heltab2x16(:,:,331))
  call Hloop_VQ_A(ntryL,G0H16(35),ex2(:),G0H8(5),m3h2x8(:,274),heltab2x16(:,:,332))
  call Hloop_Q_A(ntryL,G0H8(5),35,0,G1H8(188),n2h8(345))
  call Hloop_VQ_A(ntryL,G0H16(36),ex1(:),G0H8(4),m3h2x8(:,275),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G0H8(4),35,0,G1H8(191),n2h8(346))
  call Hloop_VA_Q(ntryL,G0H16(37),ex4(:),G0H8(9),m3h2x8(:,276),heltab2x16(:,:,334))
  call Hloop_A_Q(ntryL,G0H8(9),42,0,G1H8(192),n2h8(347))
  call Hloop_QA_V(ntryL,G1H16(45),ex4(:),G1H8(193),m3h2x8(:,277),heltab2x16(:,:,335))
  call Hloop_VQ_A(ntryL,G0H16(38),ex1(:),G0H8(8),m3h2x8(:,278),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G0H8(8),35,0,G1H8(194),n2h8(348))
  call Hloop_AQ_V(ntryL,G1H16(17),ex2(:),G1H8(197),m3h2x8(:,279),heltab2x16(:,:,337))
  call Hloop_AQ_V(ntryL,G1H16(49),ex1(:),G1H8(198),m3h2x8(:,280),heltab2x16(:,:,338))
  call Hloop_VQ_A(ntryL,G0H16(39),ex1(:),G0H8(7),m3h2x8(:,281),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G0H8(7),41,0,G1H8(199),n2h8(349))
  call Hloop_AQ_V(ntryL,G1H16(50),ex1(:),G1H8(200),m3h2x8(:,282),heltab2x16(:,:,340))
  call Hloop_AQ_V(ntryL,G1H32(121),ex2(:),G1H16(106),m3h2x16(:,207),heltab2x32(:,:,261))
  call Hloop_VQ_A(ntryL,G1H32(122),ex2(:),G1H16(107),m3h2x16(:,208),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G1H16(107),34,0,G2H16(33),n2h16(151))
  call Hloop_QA_V(ntryL,G1H32(123),ex4(:),G1H16(108),m3h2x16(:,209),heltab2x32(:,:,263))
  call Hloop_VA_Q(ntryL,G1H32(124),ex4(:),G1H16(110),m3h2x16(:,210),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G1H16(110),40,0,G2H16(34),n2h16(152))
  call Hloop_AQ_V(ntryL,G1H32(125),ex2(:),G1H16(111),m3h2x16(:,211),heltab2x32(:,:,265))
  call Hloop_VQ_A(ntryL,G1H32(126),ex2(:),G1H16(112),m3h2x16(:,212),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G1H16(112),34,0,G2H16(35),n2h16(153))
  call Hloop_AQ_V(ntryL,G1H32(127),ex1(:),G1H16(6),m3h2x16(:,213),heltab2x32(:,:,267))
  call Hloop_VQ_A(ntryL,G1H32(128),ex1(:),G1H16(113),m3h2x16(:,214),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G1H16(113),33,0,G2H16(36),n2h16(154))
  call Hloop_QA_V(ntryL,G1H32(129),ex4(:),G1H16(115),m3h2x16(:,215),heltab2x32(:,:,269))
  call Hloop_VA_Q(ntryL,G1H32(130),ex4(:),G1H16(116),m3h2x16(:,216),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G1H16(116),40,0,G2H16(37),n2h16(155))
  call Hloop_AQ_V(ntryL,G1H32(131),ex1(:),G1H16(117),m3h2x16(:,217),heltab2x32(:,:,271))
  call Hloop_VQ_A(ntryL,G1H32(132),ex1(:),G1H16(65),m3h2x16(:,218),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(38),n2h16(156))
  call Hloop_AQ_V(ntryL,G1H8(16),ex2(:),G1H4(440),m3h2x4(:,349),heltab2x8(:,:,447))
  call Hloop_AQ_V(ntryL,G1H8(20),ex1(:),G1H4(443),m3h2x4(:,350),heltab2x8(:,:,448))
  call Hloop_VQ_A(ntryL,G0H8(27),ex1(:),G0H4(1),m3h2x4(:,351),heltab2x8(:,:,449))
  call Hloop_Q_A(ntryL,G0H4(1),53,0,G1H4(445),n2h4(333))
  call Hloop_AQ_V(ntryL,G1H8(64),ex1(:),G1H4(448),m3h2x4(:,352),heltab2x8(:,:,450))
  call Hloop_VQ_A(ntryL,G0H16(40),ex2(:),G0H8(12),m3h2x8(:,283),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G0H8(12),35,0,G1H8(203),n2h8(350))
  call Hloop_VA_Q(ntryL,G0H16(41),ex3(:),G0H8(11),m3h2x8(:,284),heltab2x16(:,:,342))
  call Hloop_A_Q(ntryL,G0H8(11),37,0,G1H8(204),n2h8(351))
  call Hloop_QA_V(ntryL,G1H16(51),ex3(:),G1H8(205),m3h2x8(:,285),heltab2x16(:,:,343))
  call Hloop_VQ_A(ntryL,G0H16(42),ex2(:),G0H8(10),m3h2x8(:,286),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G0H8(10),35,0,G1H8(206),n2h8(352))
  call Hloop_VQ_A(ntryL,G0H16(43),ex1(:),G0H8(13),m3h2x8(:,287),heltab2x16(:,:,345))
  call Hloop_Q_A(ntryL,G0H8(13),35,0,G1H8(209),n2h8(353))
  call Hloop_VA_Q(ntryL,G0H16(44),ex3(:),G0H8(14),m3h2x8(:,288),heltab2x16(:,:,346))
  call Hloop_A_Q(ntryL,G0H8(14),38,0,G1H8(210),n2h8(354))
  call Hloop_QA_V(ntryL,G1H16(52),ex3(:),G1H8(211),m3h2x8(:,289),heltab2x16(:,:,347))
  call Hloop_VQ_A(ntryL,G0H16(45),ex1(:),G0H8(15),m3h2x8(:,290),heltab2x16(:,:,348))
  call Hloop_Q_A(ntryL,G0H8(15),35,0,G1H8(212),n2h8(355))
  call Hloop_AQ_V(ntryL,G1H16(53),ex1(:),G1H8(215),m3h2x8(:,291),heltab2x16(:,:,349))
  call Hloop_AQ_V(ntryL,G1H16(54),ex2(:),G1H8(216),m3h2x8(:,292),heltab2x16(:,:,350))
  call Hloop_AQ_V(ntryL,G1H16(55),ex1(:),G1H8(217),m3h2x8(:,293),heltab2x16(:,:,351))
  call Hloop_VQ_A(ntryL,G0H16(46),ex1(:),G0H8(16),m3h2x8(:,294),heltab2x16(:,:,352))
  call Hloop_Q_A(ntryL,G0H8(16),37,0,G1H8(218),n2h8(356))
  call Hloop_AQ_V(ntryL,G1H32(133),ex2(:),G1H16(78),m3h2x16(:,219),heltab2x32(:,:,273))
  call Hloop_VQ_A(ntryL,G1H32(134),ex2(:),G1H16(1),m3h2x16(:,220),heltab2x32(:,:,274))
  call Hloop_Q_A(ntryL,G1H16(1),34,0,G2H16(39),n2h16(157))
  call Hloop_QA_V(ntryL,G1H32(135),ex3(:),G1H16(28),m3h2x16(:,221),heltab2x32(:,:,275))
  call Hloop_VA_Q(ntryL,G1H32(136),ex3(:),G1H16(15),m3h2x16(:,222),heltab2x32(:,:,276))
  call Hloop_A_Q(ntryL,G1H16(15),36,0,G2H16(40),n2h16(158))
  call Hloop_AQ_V(ntryL,G1H32(137),ex2(:),G1H16(16),m3h2x16(:,223),heltab2x32(:,:,277))
  call Hloop_VQ_A(ntryL,G1H32(138),ex2(:),G1H16(73),m3h2x16(:,224),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G1H16(73),34,0,G2H16(41),n2h16(159))
  call Hloop_AQ_V(ntryL,G1H32(139),ex1(:),G1H16(19),m3h2x16(:,225),heltab2x32(:,:,279))
  call Hloop_VQ_A(ntryL,G1H32(140),ex1(:),G1H16(23),m3h2x16(:,226),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(42),n2h16(160))
  call Hloop_QA_V(ntryL,G1H32(141),ex3(:),G1H16(85),m3h2x16(:,227),heltab2x32(:,:,281))
  call Hloop_VA_Q(ntryL,G1H32(142),ex3(:),G1H16(91),m3h2x16(:,228),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G1H16(91),36,0,G2H16(43),n2h16(161))
  call Hloop_AQ_V(ntryL,G1H32(143),ex1(:),G1H16(96),m3h2x16(:,229),heltab2x32(:,:,283))
  call Hloop_VQ_A(ntryL,G1H32(144),ex1(:),G1H16(43),m3h2x16(:,230),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G1H16(43),33,0,G2H16(44),n2h16(162))
  call Hloop_AQ_V(ntryL,G1H8(71),ex2(:),G1H4(450),m3h2x4(:,353),heltab2x8(:,:,451))
  call Hloop_AQ_V(ntryL,G1H8(83),ex1(:),G1H4(453),m3h2x4(:,354),heltab2x8(:,:,452))
  call Hloop_VQ_A(ntryL,G0H8(28),ex1(:),G0H4(1),m3h2x4(:,355),heltab2x8(:,:,453))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(455),n2h4(334))
  call Hloop_AQ_V(ntryL,G1H8(89),ex1(:),G1H4(458),m3h2x4(:,356),heltab2x8(:,:,454))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(273),[G1H4(11)])
call HGT_w2_OLR(G1H4(94),1,1,4)
call HGT_w2_invQ_OLR(G1H4(94),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(137),G2H4(140),G2H4(135),G2H4(120),G2H4(116) &
    ,G1H4(353),G1H4(344),G1H4(92),G1H4(34),G1H4(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(182),[G1H4(29)])
call HGT_w2_OLR(G1H4(105),1,1,4)
call HGT_w2_invQ_OLR(G1H4(105),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(182)])
call HGT_lower_alpha_w2_OLR(G2H4(124),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(124),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(124),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G1H4(106)])
call HGT_lower_alpha_w2_OLR(G2H4(129),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(129),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(129),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(129),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G1H4(372),G1H4(199),G1H4(21)])
call HGT_lower_alpha_OLR(G2H4(133),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(133),2,5,4)
call HGT_lower_alpha_OLR(G2H4(133),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(70)])
call HGT_w2_OLR(G1H8(46),1,1,8)
call HGT_w2_invQ_OLR(G1H8(46),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G1H8(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(40)])
call HGT_w2_OLR(G1H8(39),1,1,8)
call HGT_w2_invQ_OLR(G1H8(39),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G1H4(362),G1H4(352),G1H4(230)])
call HGT_lower_alpha_OLR(G2H4(138),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(138),2,5,4)
call HGT_lower_alpha_OLR(G2H4(138),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(72)])
call HGT_w2_OLR(G1H8(84),1,1,8)
call HGT_w2_invQ_OLR(G1H8(84),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(76),[G1H8(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(85)])
call HGT_w2_OLR(G1H8(96),1,1,8)
call HGT_w2_invQ_OLR(G1H8(96),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G1H4(412),G1H4(406),G1H4(9)])
call HGT_lower_alpha_OLR(G2H4(143),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(143),2,5,4)
call HGT_lower_alpha_OLR(G2H4(143),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G2H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(137),[G1H8(94)])
call HGT_w2_OLR(G1H8(28),1,1,8)
call HGT_w2_invQ_OLR(G1H8(28),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(84),[G1H8(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(427),[G1H4(421),G1H4(104)])
call HGT_lower_alpha_OLR(G2H4(144),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(144),2,5,4)
call HGT_lower_alpha_OLR(G2H4(144),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G1H4(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(45)])
call HGT_w2_OLR(G1H8(58),1,1,8)
call HGT_w2_invQ_OLR(G1H8(58),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(146),G1H4(413),G1H4(398),G1H4(145) &
    ,G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G1H4(397),G1H4(295),G1H4(158)])
call HGT_lower_alpha_OLR(G2H4(149),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(149),2,5,4)
call HGT_lower_alpha_OLR(G2H4(149),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(149),[G2H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(72)])
call HGT_w2_OLR(G1H8(17),1,1,8)
call HGT_w2_invQ_OLR(G1H8(17),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(96),[G1H8(292)])
call HGT_lower_alpha_OLR(G2H4(150),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(150),2,5,4)
call HGT_lower_alpha_OLR(G2H4(150),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(146),[G1H8(23)])
call HGT_w2_OLR(G1H8(59),1,1,8)
call HGT_w2_invQ_OLR(G1H8(59),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(275),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(2),G1H4(208),G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(314),[G1H4(70),G1H4(237),G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(299),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(305),[G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(308),[G1H4(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(317),[G1H4(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(323),[G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(326),[G1H4(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(332),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(335),[G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(341),[G1H4(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(242),G1H4(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G1H4(363),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G1H4(373),G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(422),[G1H4(383),G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(428),[G1H4(389),G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G1H4(392),G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(388),[G1H4(382),G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(128),[G1H4(407),G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(291),G1H4(102),G1H4(55),G1H4(241),G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(272),[G1H4(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(206),[G1H4(286),G1H4(204),G1H4(78),G1H4(31),G1H4(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(278),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(15),G1H4(251),G1H4(132),G1H4(43),G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G1H4(218),G1H4(234),G1H4(168),G1H4(19),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(266),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(439),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(254),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(440),[G1H4(1),G1H4(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(443),[G1H4(42),G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(433),[G1H4(126),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(304),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(313),G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(322),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(331),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(340),[G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(378),[G1H4(368),G1H4(358),G1H4(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(417),[G1H4(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(126),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G1H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(134),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(157),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G1H8(112),G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(163),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(130),G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(150),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(152),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(62),[G1H8(124),G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(158),[G1H8(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(149),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(154),G1H8(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(181),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(172),G1H8(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G1H8(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(166),G1H8(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(176),[G1H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(168),[G1H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(198),[G1H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(196),G1H8(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(197),[G1H8(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(208),G1H8(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(187),[G1H8(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(193),[G1H8(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(215),[G1H8(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(226),G1H8(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(216),[G1H8(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G1H8(238),G1H8(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(205),[G1H8(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(211),[G1H8(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(447),[G1H4(442),G1H4(437),G1H4(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G1H8(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G1H8(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(457),[G1H4(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G1H8(291)])
  call Hloop_VQ_A(ntryL,G1H4(94),ex2(:),G1H2(226),m3h2x2(:,523),heltab2x4(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(226),47,0,G2H2(2),n2h2(417))
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(103),mass4set(:,1),  & 
G1H4(298),G1H4(309),G1H4(321),G1H4(185),G1H4(293),4)
  call HG1shiftOLR(G1H4(309),8,4)
  call Hloop_VQ_A(ntryL,G1H4(105),ex1(:),G1H2(238),m3h2x2(:,524),heltab2x4(:,:,652))
  call Hloop_Q_A(ntryL,G1H2(238),47,0,G2H2(4),n2h2(418))
  call Hotf_4pt_reduction(G2H4(124),RedSet_4(370),mass4set(:,1),  & 
G1H4(364),G1H4(381),G1H4(395),G1H4(411),G1H4(429),4)
  call HG1shiftOLR(G1H4(381),2,4)
  call Hloop_AQ_V(ntryL,G2H4(125),ex2(:),G2H2(6),m3h2x2(:,525),heltab2x4(:,:,653))
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(373),mass4set(:,1),  & 
G1H4(346),G1H4(201),G1H4(140),G1H4(141),G1H4(449),4)
  call HG1shiftOLR(G1H4(201),1,4)
  call Hloop_AQ_V(ntryL,G2H4(130),ex1(:),G2H2(8),m3h2x2(:,526),heltab2x4(:,:,654))
  call Hotf_4pt_reduction(G2H4(133),RedSet_4(98),mass4set(:,1),  & 
G1H4(159),G1H4(160),G1H4(121),G1H4(281),G1H4(454),4)
  call HG1shiftOLR(G1H4(160),8,4)
  call Hloop_QA_V(ntryL,G2H8(28),ex4(:),G2H4(148),m3h2x4(:,357),heltab2x8(:,:,455))
  call Hloop_QV_A(ntryL,G1H8(46),ex5(:),G1H4(205),m3h2x4(:,358),heltab2x8(:,:,456))
  call Hloop_Q_A(ntryL,G1H4(205),58,0,G2H4(154),n2h4(335))
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(31),mass4set(:,1),  & 
G1H8(221),G1H8(222),G1H8(223),G1H8(224),G1H8(227),8)
  call HG1shiftOLR(G1H8(222),8,8)
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,1),G1H2(250),m3h4x2(:,99),heltab2x8(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(250),47,0,G2H2(10),n2h2(419))
  call Hotf_4pt_reduction(G2H4(138),RedSet_4(112),mass4set(:,1),  & 
G1H4(35),G1H4(81),G1H4(59),G1H4(17),G1H4(64),4)
  call HG1shiftOLR(G1H4(81),8,4)
  call Hloop_QA_V(ntryL,G2H8(72),ex4(:),G2H4(108),m3h2x4(:,359),heltab2x8(:,:,458))
  call Hloop_QV_A(ntryL,G1H8(84),ex5(:),G1H4(71),m3h2x4(:,360),heltab2x8(:,:,459))
  call Hloop_Q_A(ntryL,G1H4(71),57,0,G2H4(103),n2h4(336))
  call Hotf_4pt_reduction(G2H8(76),RedSet_4(59),mass4set(:,1),  & 
G1H8(228),G1H8(229),G1H8(230),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(229),8,8)
  call Hloop_QV_A(ntryL,G1H8(96),wf4(:,11),G1H2(262),m3h4x2(:,100),heltab2x8(:,:,460))
  call Hloop_Q_A(ntryL,G1H2(262),47,0,G2H2(12),n2h2(420))
  call Hotf_4pt_reduction(G2H4(143),RedSet_4(167),mass4set(:,1),  & 
G1H4(75),G1H4(277),G1H4(18),G1H4(23),G1H4(73),4)
  call HG1shiftOLR(G1H4(277),4,4)
  call Hloop_QA_V(ntryL,G2H8(80),ex3(:),G2H4(45),m3h2x4(:,361),heltab2x8(:,:,461))
  call Hloop_QV_A(ntryL,G1H8(28),ex5(:),G1H4(85),m3h2x4(:,362),heltab2x8(:,:,462))
  call Hloop_Q_A(ntryL,G1H4(85),54,0,G2H4(48),n2h4(337))
  call Hotf_4pt_reduction(G2H8(84),RedSet_4(46),mass4set(:,1),  & 
G1H8(235),G1H8(236),G1H8(239),G1H8(240),G1H8(241),8)
  call HG1shiftOLR(G1H8(236),4,8)
  call Hotf_4pt_reduction(G2H4(144),RedSet_4(180),mass4set(:,1),  & 
G1H4(37),G1H4(41),G1H4(53),G1H4(60),G1H4(65),4)
  call HG1shiftOLR(G1H4(41),2,4)
  call Hloop_AQ_V(ntryL,G2H8(88),ex2(:),G2H4(97),m3h2x4(:,363),heltab2x8(:,:,463))
  call Hloop_QV_A(ntryL,G1H8(58),wf4(:,15),G1H2(274),m3h4x2(:,101),heltab2x8(:,:,464))
  call Hloop_Q_A(ntryL,G1H2(274),47,0,G2H2(14),n2h2(421))
  call Hotf_4pt_reduction(G2H4(152),RedSet_4(158),mass4set(:,1),  & 
G1H4(89),G1H4(90),G1H4(96),G1H4(120),G1H4(143),4)
  call HG1shiftOLR(G1H4(90),4,4)
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(153),mass4set(:,1),  & 
G1H4(144),G1H4(180),G1H4(191),G1H4(192),G1H4(228),4)
  call HG1shiftOLR(G1H4(180),4,4)
  call Hloop_QA_V(ntryL,G2H8(92),ex3(:),G2H4(52),m3h2x4(:,364),heltab2x8(:,:,465))
  call Hloop_QV_A(ntryL,G1H8(17),ex5(:),G1H4(222),m3h2x4(:,365),heltab2x8(:,:,466))
  call Hloop_Q_A(ntryL,G1H4(222),53,0,G2H4(16),n2h4(338))
  call Hotf_4pt_reduction(G2H8(96),RedSet_4(74),mass4set(:,1),  & 
G1H8(242),G1H8(247),G1H8(252),G1H8(248),G1H8(251),8)
  call HG1shiftOLR(G1H8(247),4,8)
  call Hotf_4pt_reduction(G2H4(150),RedSet_4(372),mass4set(:,1),  & 
G1H4(227),G1H4(259),G1H4(263),G1H4(264),G1H4(288),4)
  call HG1shiftOLR(G1H4(259),1,4)
  call Hloop_AQ_V(ntryL,G2H8(100),ex1(:),G2H4(56),m3h2x4(:,366),heltab2x8(:,:,467))
  call Hloop_QV_A(ntryL,G1H8(59),wf4(:,20),G1H2(286),m3h4x2(:,102),heltab2x8(:,:,468))
  call Hloop_Q_A(ntryL,G1H2(286),47,0,G2H2(16),n2h2(422))
  call Hloop_VQ_A(ntryL,G1H4(275),ex1(:),G1H2(298),m3h2x2(:,527),heltab2x4(:,:,655))
  call Hloop_Q_A(ntryL,G1H2(298),55,0,G2H2(19),n2h2(423))
  call Hloop_VQ_A(ntryL,G1H4(127),ex1(:),G1H2(310),m3h2x2(:,528),heltab2x4(:,:,656))
  call Hloop_Q_A(ntryL,G1H2(310),55,0,G2H2(22),n2h2(424))
  call Hloop_VQ_A(ntryL,G1H4(8),ex2(:),G1H2(468),m3h2x2(:,529),heltab2x4(:,:,657))
  call Hloop_Q_A(ntryL,G1H2(468),55,0,G2H2(25),n2h2(425))
  call Hloop_VQ_A(ntryL,G1H4(314),ex2(:),G1H2(486),m3h2x2(:,530),heltab2x4(:,:,658))
  call Hloop_Q_A(ntryL,G1H2(486),55,0,G2H2(37),n2h2(426))
  call Hloop_VQ_A(ntryL,G1H4(52),ex1(:),G1H2(522),m3h2x2(:,531),heltab2x4(:,:,659))
  call Hloop_Q_A(ntryL,G1H2(522),55,0,G2H2(43),n2h2(427))
  call Hloop_VQ_A(ntryL,G1H4(299),ex1(:),G1H2(534),m3h2x2(:,532),heltab2x4(:,:,660))
  call Hloop_Q_A(ntryL,G1H2(534),59,0,G2H2(46),n2h2(428))
  call Hloop_VQ_A(ntryL,G1H4(305),ex1(:),G1H2(546),m3h2x2(:,533),heltab2x4(:,:,661))
  call Hloop_Q_A(ntryL,G1H2(546),59,0,G2H2(49),n2h2(429))
  call Hloop_VQ_A(ntryL,G1H4(308),ex2(:),G1H2(558),m3h2x2(:,534),heltab2x4(:,:,662))
  call Hloop_Q_A(ntryL,G1H2(558),55,0,G2H2(52),n2h2(430))
  call Hloop_VQ_A(ntryL,G1H4(317),ex2(:),G1H2(570),m3h2x2(:,535),heltab2x4(:,:,663))
  call Hloop_Q_A(ntryL,G1H2(570),59,0,G2H2(55),n2h2(431))
  call Hloop_VQ_A(ntryL,G1H4(323),ex2(:),G1H2(582),m3h2x2(:,536),heltab2x4(:,:,664))
  call Hloop_Q_A(ntryL,G1H2(582),59,0,G2H2(58),n2h2(432))
  call Hloop_VA_Q(ntryL,G1H4(326),ex3(:),G1H2(594),m3h2x2(:,537),heltab2x4(:,:,665))
  call Hloop_A_Q(ntryL,G1H2(594),61,0,G2H2(61),n2h2(433))
  call Hloop_VA_Q(ntryL,G1H4(332),ex3(:),G1H2(606),m3h2x2(:,538),heltab2x4(:,:,666))
  call Hloop_A_Q(ntryL,G1H2(606),61,0,G2H2(64),n2h2(434))
  call Hloop_VA_Q(ntryL,G1H4(335),ex4(:),G1H2(612),m3h2x2(:,539),heltab2x4(:,:,667))
  call Hloop_A_Q(ntryL,G1H2(612),61,0,G2H2(66),n2h2(435))
  call Hloop_VA_Q(ntryL,G1H4(341),ex4(:),G1H2(624),m3h2x2(:,540),heltab2x4(:,:,668))
  call Hloop_A_Q(ntryL,G1H2(624),61,0,G2H2(67),n2h2(436))
  call Hloop_QV_A(ntryL,G1H4(22),ex5(:),G1H2(630),m3h2x2(:,541),heltab2x4(:,:,669))
  call Hloop_Q_A(ntryL,G1H2(630),55,0,G2H2(72),n2h2(437))
  call Hloop_QV_A(ntryL,G1H4(10),ex5(:),G1H2(642),m3h2x2(:,542),heltab2x4(:,:,670))
  call Hloop_Q_A(ntryL,G1H2(642),59,0,G2H2(73),n2h2(438))
  call Hotf_4pt_reduction(G2H4(123),RedSet_4(122),mass4set(:,1),  & 
G1H4(3),G1H4(4),G1H4(48),G1H4(69),G1H4(54),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hloop_AV_Q(ntryL,G1H4(45),ex5(:),G1H2(648),m3h2x2(:,543),heltab2x4(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(648),62,0,G2H2(75),n2h2(439))
  call Hloop_AV_Q(ntryL,G1H4(46),ex5(:),G1H2(660),m3h2x2(:,544),heltab2x4(:,:,672))
  call Hloop_A_Q(ntryL,G1H2(660),62,0,G2H2(76),n2h2(440))
  call Hotf_4pt_reduction(G2H4(126),RedSet_4(131),mass4set(:,1),  & 
G1H4(62),G1H4(113),G1H4(114),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(113),8,4)
  call Hloop_AV_Q(ntryL,G1H4(422),ex5(:),G1H2(666),m3h2x2(:,545),heltab2x4(:,:,673))
  call Hloop_A_Q(ntryL,G1H2(666),61,0,G2H2(78),n2h2(441))
  call Hloop_AV_Q(ntryL,G1H4(428),ex5(:),G1H2(678),m3h2x2(:,546),heltab2x4(:,:,674))
  call Hloop_A_Q(ntryL,G1H2(678),61,0,G2H2(79),n2h2(442))
  call Hotf_4pt_reduction(G2H4(127),RedSet_4(154),mass4set(:,1),  & 
G1H4(303),G1H4(306),G1H4(310),G1H4(311),G1H4(161),4)
  call HG1shiftOLR(G1H4(306),4,4)
  call Hloop_AV_Q(ntryL,G1H4(388),ex5(:),G1H2(207),m3h2x2(:,547),heltab2x4(:,:,675))
  call Hloop_A_Q(ntryL,G1H2(207),61,0,G2H2(81),n2h2(443))
  call Hloop_AV_Q(ntryL,G1H4(165),ex5(:),G1H2(38),m3h2x2(:,548),heltab2x4(:,:,676))
  call Hloop_A_Q(ntryL,G1H2(38),61,0,G2H2(82),n2h2(444))
  call Hotf_4pt_reduction(G2H4(128),RedSet_4(168),mass4set(:,1),  & 
G1H4(162),G1H4(324),G1H4(325),G1H4(328),G1H4(329),4)
  call HG1shiftOLR(G1H4(324),4,4)
  call Hloop_VQ_A(ntryL,G1H4(16),ex2(:),G1H2(62),m3h2x2(:,549),heltab2x4(:,:,677))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(84),n2h2(445))
  call Hloop_VA_Q(ntryL,G1H4(272),ex4(:),G1H2(68),m3h2x2(:,550),heltab2x4(:,:,678))
  call Hloop_A_Q(ntryL,G1H2(68),47,0,G2H2(85),n2h2(446))
  call Hloop_VA_Q(ntryL,G1H4(206),ex4(:),G1H2(74),m3h2x2(:,551),heltab2x4(:,:,679))
  call Hloop_A_Q(ntryL,G1H2(74),47,0,G2H2(90),n2h2(447))
  call Hloop_VQ_A(ntryL,G1H4(14),ex2(:),G1H2(104),m3h2x2(:,552),heltab2x4(:,:,680))
  call Hloop_Q_A(ntryL,G1H2(104),47,0,G2H2(91),n2h2(448))
  call Hloop_VA_Q(ntryL,G1H4(278),ex3(:),G1H2(92),m3h2x2(:,553),heltab2x4(:,:,681))
  call Hloop_A_Q(ntryL,G1H2(92),47,0,G2H2(93),n2h2(449))
  call Hloop_VA_Q(ntryL,G1H4(32),ex3(:),G1H2(116),m3h2x2(:,554),heltab2x4(:,:,682))
  call Hloop_A_Q(ntryL,G1H2(116),47,0,G2H2(94),n2h2(450))
  call Hloop_VQ_A(ntryL,G1H4(233),ex1(:),G1H2(134),m3h2x2(:,555),heltab2x4(:,:,683))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(96),n2h2(451))
  call Hloop_VQ_A(ntryL,G1H4(28),ex1(:),G1H2(140),m3h2x2(:,556),heltab2x4(:,:,684))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(97),n2h2(452))
  call Hloop_VA_Q(ntryL,G1H4(146),ex4(:),G1H2(146),m3h2x2(:,557),heltab2x4(:,:,685))
  call Hloop_A_Q(ntryL,G1H2(146),47,0,G2H2(99),n2h2(453))
  call Hloop_VA_Q(ntryL,G1H4(27),ex3(:),G1H2(170),m3h2x2(:,558),heltab2x4(:,:,686))
  call Hloop_A_Q(ntryL,G1H2(170),47,0,G2H2(100),n2h2(454))
  call Hloop_VQ_A(ntryL,G1H4(20),ex2(:),G1H2(176),m3h2x2(:,559),heltab2x4(:,:,687))
  call Hloop_Q_A(ntryL,G1H2(176),47,0,G2H2(102),n2h2(455))
  call Hloop_VA_Q(ntryL,G1H4(266),ex4(:),G1H2(1),m3h2x2(:,560),heltab2x4(:,:,688))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(103),n2h2(456))
  call Hloop_VQ_A(ntryL,G1H4(110),ex2(:),G1H2(9),m3h2x2(:,561),heltab2x4(:,:,689))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(105),n2h2(457))
  call Hloop_VA_Q(ntryL,G1H4(40),ex3(:),G1H2(11),m3h2x2(:,562),heltab2x4(:,:,690))
  call Hloop_A_Q(ntryL,G1H2(11),47,0,G2H2(106),n2h2(458))
  call Hloop_VQ_A(ntryL,G1H4(439),ex1(:),G1H2(41),m3h2x2(:,563),heltab2x4(:,:,691))
  call Hloop_Q_A(ntryL,G1H2(41),47,0,G2H2(108),n2h2(459))
  call Hloop_VA_Q(ntryL,G1H4(134),ex4(:),G1H2(83),m3h2x2(:,564),heltab2x4(:,:,692))
  call Hloop_A_Q(ntryL,G1H2(83),47,0,G2H2(109),n2h2(460))
  call Hloop_VQ_A(ntryL,G1H4(254),ex1(:),G1H2(17),m3h2x2(:,565),heltab2x4(:,:,693))
  call Hloop_Q_A(ntryL,G1H2(17),47,0,G2H2(111),n2h2(461))
  call Hloop_VA_Q(ntryL,G1H4(26),ex3(:),G1H2(107),m3h2x2(:,566),heltab2x4(:,:,694))
  call Hloop_A_Q(ntryL,G1H2(107),47,0,G2H2(112),n2h2(462))
  call Hloop_VQ_A(ntryL,G1H4(440),ex1(:),G1H2(131),m3h2x2(:,567),heltab2x4(:,:,695))
  call Hloop_Q_A(ntryL,G1H2(131),55,0,G2H2(162),n2h2(463))
  call Hloop_VQ_A(ntryL,G1H4(443),ex2(:),G1H2(23),m3h2x2(:,568),heltab2x4(:,:,696))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(164),n2h2(464))
  call Hloop_VQ_A(ntryL,G1H4(433),ex1(:),G1H2(89),m3h2x2(:,569),heltab2x4(:,:,697))
  call Hloop_Q_A(ntryL,G1H2(89),55,0,G2H2(161),n2h2(465))
  call Hloop_VQ_A(ntryL,G1H4(304),ex1(:),G1H2(143),m3h2x2(:,570),heltab2x4(:,:,698))
  call Hloop_Q_A(ntryL,G1H2(143),59,0,G2H2(163),n2h2(466))
  call Hloop_VQ_A(ntryL,G1H4(51),ex2(:),G1H2(29),m3h2x2(:,571),heltab2x4(:,:,699))
  call Hloop_Q_A(ntryL,G1H2(29),55,0,G2H2(158),n2h2(467))
  call Hloop_VQ_A(ntryL,G1H4(322),ex2(:),G1H2(101),m3h2x2(:,572),heltab2x4(:,:,700))
  call Hloop_Q_A(ntryL,G1H2(101),59,0,G2H2(159),n2h2(468))
  call Hloop_VA_Q(ntryL,G1H4(331),ex3(:),G1H2(37),m3h2x2(:,573),heltab2x4(:,:,701))
  call Hloop_A_Q(ntryL,G1H2(37),61,0,G2H2(157),n2h2(469))
  call Hloop_VA_Q(ntryL,G1H4(340),ex4(:),G1H2(54),m3h2x2(:,574),heltab2x4(:,:,702))
  call Hloop_A_Q(ntryL,G1H2(54),61,0,G2H2(160),n2h2(470))
  call Hloop_QV_A(ntryL,G1H4(348),ex5(:),G1H2(42),m3h2x2(:,575),heltab2x4(:,:,703))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(18),n2h2(471))
  call Hloop_QV_A(ntryL,G1H4(378),ex5(:),G1H2(53),m3h2x2(:,576),heltab2x4(:,:,704))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(31),n2h2(472))
  call Hloop_QV_A(ntryL,G1H4(357),ex5(:),G1H2(55),m3h2x2(:,577),heltab2x4(:,:,705))
  call Hloop_Q_A(ntryL,G1H2(55),55,0,G2H2(21),n2h2(473))
  call Hloop_QV_A(ntryL,G1H4(367),ex5(:),G1H2(59),m3h2x2(:,578),heltab2x4(:,:,706))
  call Hloop_Q_A(ntryL,G1H2(59),55,0,G2H2(28),n2h2(474))
  call Hloop_QV_A(ntryL,G1H4(377),ex5(:),G1H2(66),m3h2x2(:,579),heltab2x4(:,:,707))
  call Hloop_Q_A(ntryL,G1H2(66),55,0,G2H2(24),n2h2(475))
  call Hloop_QV_A(ntryL,G1H4(401),ex5(:),G1H2(67),m3h2x2(:,580),heltab2x4(:,:,708))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(34),n2h2(476))
  call Hloop_QV_A(ntryL,G1H4(417),ex5(:),G1H2(71),m3h2x2(:,581),heltab2x4(:,:,709))
  call Hloop_Q_A(ntryL,G1H2(71),59,0,G2H2(27),n2h2(477))
  call Hloop_QV_A(ntryL,G1H4(416),ex5(:),G1H2(78),m3h2x2(:,582),heltab2x4(:,:,710))
  call Hloop_Q_A(ntryL,G1H2(78),59,0,G2H2(30),n2h2(478))
  call Hloop_AV_Q(ntryL,G1H8(77),ex5(:),G1H4(186),m3h2x4(:,367),heltab2x8(:,:,469))
  call Hloop_A_Q(ntryL,G1H4(186),58,0,G2H4(100),n2h4(339))
  call Hloop_AV_Q(ntryL,G1H8(78),ex5(:),G1H4(336),m3h2x4(:,368),heltab2x8(:,:,470))
  call Hloop_A_Q(ntryL,G1H4(336),58,0,G2H4(60),n2h4(340))
  call Hloop_AV_Q(ntryL,G1H8(108),wf4(:,1),G1H2(79),m3h4x2(:,103),heltab2x8(:,:,471))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(33),n2h2(479))
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(336),mass4set(:,1),  & 
G1H8(253),G1H8(256),G1H8(257),G1H8(258),G1H8(263),G0H8(17),8)
  call HG1shiftOLR(G1H8(256),16,8)
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(336),mass4set(:,1),  & 
G1H8(268),G1H8(264),G1H8(267),G1H8(269),G1H8(272),G0H8(18),8)
  call HG1shiftOLR(G1H8(264),16,8)
  call Hloop_AV_Q(ntryL,G1H8(61),ex5(:),G1H4(342),m3h2x4(:,369),heltab2x8(:,:,472))
  call Hloop_A_Q(ntryL,G1H4(342),57,0,G2H4(99),n2h4(341))
  call Hloop_AV_Q(ntryL,G1H8(62),ex5(:),G1H4(343),m3h2x4(:,370),heltab2x8(:,:,473))
  call Hloop_A_Q(ntryL,G1H4(343),57,0,G2H4(134),n2h4(342))
  call Hloop_AV_Q(ntryL,G1H8(126),wf4(:,11),G1H2(96),m3h4x2(:,104),heltab2x8(:,:,474))
  call Hloop_A_Q(ntryL,G1H2(96),47,0,G2H2(36),n2h2(480))
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(317),mass4set(:,1),  & 
G1H8(273),G1H8(274),G1H8(279),G1H8(284),G1H8(280),G0H8(21),8)
  call HG1shiftOLR(G1H8(274),16,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(317),mass4set(:,1),  & 
G1H8(283),G1H8(285),G1H8(288),G1H8(289),G1H8(290),G0H8(22),8)
  call HG1shiftOLR(G1H8(285),16,8)
  call Hotf_4pt_reduction(G2H8(54),RedSet_4(233),mass4set(:,1),  & 
G1H8(295),G1H8(300),G1H8(296),G1H8(299),G1H8(301),G0H8(23),8)
  call HG1shiftOLR(G1H8(300),9,8)
  call Hloop_AV_Q(ntryL,G1H8(133),ex5(:),G1H4(347),m3h2x4(:,371),heltab2x8(:,:,475))
  call Hloop_A_Q(ntryL,G1H4(347),54,0,G2H4(67),n2h4(343))
  call Hotf_4pt_reduction(G2H8(50),RedSet_4(233),mass4set(:,1),  & 
G1H8(304),G1H8(67),G1H8(261),G1H8(87),G1H8(81),G0H8(19),8)
  call HG1shiftOLR(G1H8(67),9,8)
  call Hloop_AV_Q(ntryL,G1H8(134),wf4(:,15),G1H2(120),m3h4x2(:,105),heltab2x8(:,:,476))
  call Hloop_A_Q(ntryL,G1H2(120),47,0,G2H2(40),n2h2(481))
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(325),mass4set(:,1),  & 
G1H8(278),G1H8(97),G1H8(73),G1H8(65),G1H8(92),G0H8(20),8)
  call HG1shiftOLR(G1H8(97),16,8)
  call Hotf_4pt_reduction(G2H8(38),RedSet_4(325),mass4set(:,1),  & 
G1H8(2),G1H8(52),G1H8(245),G1H8(56),G1H8(246),G0H8(29),8)
  call HG1shiftOLR(G1H8(52),16,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(228),mass4set(:,1),  & 
G1H8(79),G1H8(262),G1H8(80),G1H8(277),G1H8(68),G0H8(3),8)
  call HG1shiftOLR(G1H8(262),10,8)
  call Hloop_AV_Q(ntryL,G1H8(143),ex5(:),G1H4(350),m3h2x4(:,372),heltab2x8(:,:,477))
  call Hloop_A_Q(ntryL,G1H4(350),53,0,G2H4(106),n2h4(344))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(228),mass4set(:,1),  & 
G1H8(293),G1H8(69),G1H8(294),G1H8(88),G1H8(66),G0H8(2),8)
  call HG1shiftOLR(G1H8(69),10,8)
  call Hloop_AV_Q(ntryL,G1H8(144),wf4(:,20),G1H2(90),m3h4x2(:,106),heltab2x8(:,:,478))
  call Hloop_A_Q(ntryL,G1H2(90),47,0,G2H2(39),n2h2(482))
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(331),mass4set(:,1),  & 
G1H8(91),G1H8(1),G1H8(3),G1H8(4),G1H8(7),G0H8(24),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(331),mass4set(:,1),  & 
G1H8(8),G1H8(37),G1H8(38),G1H8(49),G1H8(50),G0H8(25),8)
  call HG1shiftOLR(G1H8(37),16,8)
  call Hloop_VA_Q(ntryL,G1H8(157),ex4(:),G1H4(434),m3h2x4(:,373),heltab2x8(:,:,479))
  call Hloop_A_Q(ntryL,G1H4(434),46,0,G2H4(139),n2h4(345))
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(355),mass4set(:,1),  & 
G1H8(103),G1H8(15),G1H8(9),G1H8(19),G1H8(90),8)
  call HG1shiftOLR(G1H8(15),17,8)
  call Hloop_VA_Q(ntryL,G1H8(163),ex3(:),G1H4(356),m3h2x4(:,374),heltab2x8(:,:,480))
  call Hloop_A_Q(ntryL,G1H4(356),46,0,G2H4(74),n2h4(346))
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(342),mass4set(:,1),  & 
G1H8(95),G1H8(25),G1H8(26),G1H8(27),G1H8(31),8)
  call HG1shiftOLR(G1H8(25),17,8)
  call Hloop_VA_Q(ntryL,G1H8(150),ex4(:),G1H4(365),m3h2x4(:,375),heltab2x8(:,:,481))
  call Hloop_A_Q(ntryL,G1H4(365),46,0,G2H4(18),n2h4(347))
  call Hloop_VQ_A(ntryL,G1H8(152),wf4(:,12),G1H2(139),m3h4x2(:,107),heltab2x8(:,:,482))
  call Hloop_Q_A(ntryL,G1H2(139),55,0,G2H2(42),n2h2(483))
  call Hotf_4pt_reduction(G2H8(62),RedSet_4(116),mass4set(:,1),  & 
G1H8(34),G1H8(82),G1H8(70),G1H8(29),G1H8(42),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_VQ_A(ntryL,G1H8(158),wf4(:,12),G1H2(97),m3h4x2(:,108),heltab2x8(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(402),n2h2(484))
  call Hloop_VA_Q(ntryL,G1H8(149),ex3(:),G1H4(366),m3h2x4(:,376),heltab2x8(:,:,484))
  call Hloop_A_Q(ntryL,G1H4(366),46,0,G2H4(21),n2h4(348))
  call Hloop_VQ_A(ntryL,G1H8(135),wf4(:,12),G1H2(126),m3h4x2(:,109),heltab2x8(:,:,485))
  call Hloop_Q_A(ntryL,G1H2(126),59,0,G2H2(45),n2h2(485))
  call Hloop_VQ_A(ntryL,G1H8(136),wf4(:,12),G1H2(102),m3h4x2(:,110),heltab2x8(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(102),59,0,G2H2(407),n2h2(486))
  call Hloop_VA_Q(ntryL,G1H8(175),ex4(:),G1H4(374),m3h2x4(:,377),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G1H4(374),45,0,G2H4(24),n2h4(349))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(147),mass4set(:,1),  & 
G1H8(43),G1H8(11),G1H8(60),G1H8(12),G1H8(48),8)
  call HG1shiftOLR(G1H8(11),18,8)
  call Hloop_VA_Q(ntryL,G1H8(181),ex3(:),G1H4(375),m3h2x4(:,378),heltab2x8(:,:,488))
  call Hloop_A_Q(ntryL,G1H4(375),45,0,G2H4(27),n2h4(350))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(185),mass4set(:,1),  & 
G1H8(30),G1H8(35),G1H8(41),G1H8(47),G1H8(107),8)
  call HG1shiftOLR(G1H8(35),18,8)
  call Hloop_VA_Q(ntryL,G1H8(167),ex4(:),G1H4(384),m3h2x4(:,379),heltab2x8(:,:,489))
  call Hloop_A_Q(ntryL,G1H4(384),45,0,G2H4(30),n2h4(351))
  call Hloop_VQ_A(ntryL,G1H8(169),wf4(:,4),G1H2(108),m3h4x2(:,111),heltab2x8(:,:,490))
  call Hloop_Q_A(ntryL,G1H2(108),55,0,G2H2(48),n2h2(487))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(104),mass4set(:,1),  & 
G1H8(99),G1H8(100),G1H8(113),G1H8(114),G1H8(115),8)
  call HG1shiftOLR(G1H8(100),8,8)
  call Hloop_VQ_A(ntryL,G1H8(176),wf4(:,4),G1H2(157),m3h4x2(:,112),heltab2x8(:,:,491))
  call Hloop_Q_A(ntryL,G1H2(157),55,0,G2H2(418),n2h2(488))
  call Hloop_VA_Q(ntryL,G1H8(168),ex3(:),G1H4(385),m3h2x4(:,380),heltab2x8(:,:,492))
  call Hloop_A_Q(ntryL,G1H4(385),45,0,G2H4(33),n2h4(352))
  call Hloop_VQ_A(ntryL,G1H8(177),wf4(:,4),G1H2(109),m3h4x2(:,113),heltab2x8(:,:,493))
  call Hloop_Q_A(ntryL,G1H2(109),59,0,G2H2(51),n2h2(489))
  call Hloop_VQ_A(ntryL,G1H8(178),wf4(:,4),G1H2(119),m3h4x2(:,114),heltab2x8(:,:,494))
  call Hloop_Q_A(ntryL,G1H2(119),59,0,G2H2(392),n2h2(490))
  call Hloop_VQ_A(ntryL,G1H8(198),ex2(:),G1H4(391),m3h2x4(:,381),heltab2x8(:,:,495))
  call Hloop_Q_A(ntryL,G1H4(391),43,0,G2H4(36),n2h4(353))
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(173),mass4set(:,1),  & 
G1H8(116),G1H8(119),G1H8(120),G1H8(121),G1H8(122),8)
  call HG1shiftOLR(G1H8(119),20,8)
  call Hloop_VQ_A(ntryL,G1H8(197),ex1(:),G1H4(257),m3h2x4(:,382),heltab2x8(:,:,496))
  call Hloop_Q_A(ntryL,G1H4(257),43,0,G2H4(39),n2h4(354))
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(160),mass4set(:,1),  & 
G1H8(125),G1H8(104),G1H8(14),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(104),20,8)
  call Hloop_VQ_A(ntryL,G1H8(187),ex2(:),G1H4(396),m3h2x4(:,383),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H4(396),43,0,G2H4(42),n2h4(355))
  call Hloop_VA_Q(ntryL,G1H8(201),wf4(:,19),G1H2(163),m3h4x2(:,115),heltab2x8(:,:,498))
  call Hloop_A_Q(ntryL,G1H2(163),61,0,G2H2(54),n2h2(491))
  call Hloop_VA_Q(ntryL,G1H8(202),wf4(:,19),G1H2(121),m3h4x2(:,116),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(121),61,0,G2H2(395),n2h2(492))
  call Hloop_VQ_A(ntryL,G1H8(193),ex1(:),G1H4(399),m3h2x4(:,384),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H4(399),43,0,G2H4(112),n2h4(356))
  call Hloop_VQ_A(ntryL,G1H8(215),ex2(:),G1H4(404),m3h2x4(:,385),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(404),39,0,G2H4(49),n2h4(357))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(105),mass4set(:,1),  & 
G1H8(63),G1H8(36),G1H8(139),G1H8(140),G1H8(53),8)
  call HG1shiftOLR(G1H8(36),24,8)
  call Hloop_VQ_A(ntryL,G1H8(216),ex1(:),G1H4(405),m3h2x4(:,386),heltab2x8(:,:,502))
  call Hloop_Q_A(ntryL,G1H4(405),39,0,G2H4(43),n2h4(358))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(117),mass4set(:,1),  & 
G1H8(54),G1H8(76),G1H8(93),G1H8(16),G1H8(20),8)
  call HG1shiftOLR(G1H8(76),24,8)
  call Hloop_VQ_A(ntryL,G1H8(205),ex2(:),G1H4(414),m3h2x4(:,387),heltab2x8(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(414),39,0,G2H4(53),n2h4(359))
  call Hloop_VA_Q(ntryL,G1H8(231),wf4(:,9),G1H2(132),m3h4x2(:,117),heltab2x8(:,:,504))
  call Hloop_A_Q(ntryL,G1H2(132),61,0,G2H2(57),n2h2(493))
  call Hloop_VA_Q(ntryL,G1H8(232),wf4(:,9),G1H2(137),m3h4x2(:,118),heltab2x8(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(137),61,0,G2H2(415),n2h2(494))
  call Hloop_VQ_A(ntryL,G1H8(211),ex1(:),G1H4(415),m3h2x4(:,388),heltab2x8(:,:,506))
  call Hloop_Q_A(ntryL,G1H4(415),39,0,G2H4(113),n2h4(360))
  call Hloop_QV_A(ntryL,G1H4(431),ex5(:),G1H2(138),m3h2x2(:,583),heltab2x4(:,:,711))
  call Hloop_Q_A(ntryL,G1H2(138),55,0,G2H2(60),n2h2(495))
  call Hloop_QV_A(ntryL,G1H4(447),ex5(:),G1H2(156),m3h2x2(:,584),heltab2x4(:,:,712))
  call Hloop_Q_A(ntryL,G1H2(156),55,0,G2H2(410),n2h2(496))
  call Hloop_QV_A(ntryL,G1H4(436),ex5(:),G1H2(161),m3h2x2(:,585),heltab2x4(:,:,713))
  call Hloop_Q_A(ntryL,G1H2(161),55,0,G2H2(63),n2h2(497))
  call Hotf_4pt_reduction(G2H8(48),RedSet_4(28),mass4set(:,1),  & 
G1H8(64),G1H8(71),G1H8(83),G1H8(89),G1H8(109),8)
  call HG1shiftOLR(G1H8(71),8,8)
  call Hloop_QV_A(ntryL,G1H8(249),wf4(:,1),G1H2(162),m3h4x2(:,119),heltab2x8(:,:,507))
  call Hloop_Q_A(ntryL,G1H2(162),55,0,G2H2(399),n2h2(498))
  call Hloop_QV_A(ntryL,G1H8(250),wf4(:,1),G1H2(208),m3h4x2(:,120),heltab2x8(:,:,508))
  call Hloop_Q_A(ntryL,G1H2(208),55,0,G2H2(139),n2h2(499))
  call Hloop_QV_A(ntryL,G1H8(254),wf4(:,1),G1H2(209),m3h4x2(:,121),heltab2x8(:,:,509))
  call Hloop_Q_A(ntryL,G1H2(209),55,0,G2H2(69),n2h2(500))
  call Hloop_QV_A(ntryL,G1H8(255),wf4(:,1),G1H2(210),m3h4x2(:,122),heltab2x8(:,:,510))
  call Hloop_Q_A(ntryL,G1H2(210),55,0,G2H2(70),n2h2(501))
  call Hloop_QV_A(ntryL,G1H4(441),ex5(:),G1H2(214),m3h2x2(:,586),heltab2x4(:,:,714))
  call Hloop_Q_A(ntryL,G1H2(214),55,0,G2H2(140),n2h2(502))
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(56),mass4set(:,1),  & 
G1H8(244),G1H8(40),G1H8(110),G1H8(127),G1H8(260),8)
  call HG1shiftOLR(G1H8(40),8,8)
  call Hloop_QV_A(ntryL,G1H8(265),wf4(:,11),G1H2(215),m3h4x2(:,123),heltab2x8(:,:,511))
  call Hloop_Q_A(ntryL,G1H2(215),55,0,G2H2(141),n2h2(503))
  call Hloop_QV_A(ntryL,G1H8(266),wf4(:,11),G1H2(216),m3h4x2(:,124),heltab2x8(:,:,512))
  call Hloop_Q_A(ntryL,G1H2(216),55,0,G2H2(447),n2h2(504))
  call Hloop_QV_A(ntryL,G1H8(270),wf4(:,11),G1H2(220),m3h4x2(:,125),heltab2x8(:,:,513))
  call Hloop_Q_A(ntryL,G1H2(220),55,0,G2H2(449),n2h2(505))
  call Hloop_QV_A(ntryL,G1H8(271),wf4(:,11),G1H2(221),m3h4x2(:,126),heltab2x8(:,:,514))
  call Hloop_Q_A(ntryL,G1H2(221),55,0,G2H2(142),n2h2(506))
  call Hloop_QV_A(ntryL,G1H4(446),ex5(:),G1H2(222),m3h2x2(:,587),heltab2x4(:,:,715))
  call Hloop_Q_A(ntryL,G1H2(222),55,0,G2H2(459),n2h2(507))
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(42),mass4set(:,1),  & 
G1H8(85),G1H8(128),G1H8(94),G1H8(137),G1H8(276),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hloop_QV_A(ntryL,G1H8(281),wf4(:,15),G1H2(784),m3h4x2(:,127),heltab2x8(:,:,515))
  call Hloop_Q_A(ntryL,G1H2(784),59,0,G2H2(461),n2h2(508))
  call Hloop_QV_A(ntryL,G1H8(282),wf4(:,15),G1H2(227),m3h4x2(:,128),heltab2x8(:,:,516))
  call Hloop_Q_A(ntryL,G1H2(227),59,0,G2H2(143),n2h2(509))
  call Hloop_QV_A(ntryL,G1H8(286),wf4(:,15),G1H2(228),m3h4x2(:,129),heltab2x8(:,:,517))
  call Hloop_Q_A(ntryL,G1H2(228),59,0,G2H2(453),n2h2(510))
  call Hloop_QV_A(ntryL,G1H8(287),wf4(:,15),G1H2(232),m3h4x2(:,130),heltab2x8(:,:,518))
  call Hloop_Q_A(ntryL,G1H2(232),59,0,G2H2(455),n2h2(511))
  call Hloop_QV_A(ntryL,G1H4(451),ex5(:),G1H2(233),m3h2x2(:,588),heltab2x4(:,:,716))
  call Hloop_Q_A(ntryL,G1H2(233),59,0,G2H2(144),n2h2(512))
  call Hloop_QV_A(ntryL,G1H4(457),ex5(:),G1H2(234),m3h2x2(:,589),heltab2x4(:,:,717))
  call Hloop_Q_A(ntryL,G1H2(234),59,0,G2H2(465),n2h2(513))
  call Hotf_4pt_reduction(G2H8(57),RedSet_4(70),mass4set(:,1),  & 
G1H8(45),G1H8(138),G1H8(72),G1H8(145),G1H8(292),8)
  call HG1shiftOLR(G1H8(138),4,8)
  call Hloop_QV_A(ntryL,G1H8(297),wf4(:,20),G1H2(789),m3h4x2(:,131),heltab2x8(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(789),59,0,G2H2(467),n2h2(514))
  call Hloop_QV_A(ntryL,G1H8(298),wf4(:,20),G1H2(239),m3h4x2(:,132),heltab2x8(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(239),59,0,G2H2(145),n2h2(515))
  call Hloop_QV_A(ntryL,G1H8(302),wf4(:,20),G1H2(240),m3h4x2(:,133),heltab2x8(:,:,521))
  call Hloop_Q_A(ntryL,G1H2(240),59,0,G2H2(87),n2h2(516))
  call Hloop_QV_A(ntryL,G1H8(303),wf4(:,20),G1H2(244),m3h4x2(:,134),heltab2x8(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(244),59,0,G2H2(88),n2h2(517))
  call Hloop_QV_A(ntryL,G1H4(456),ex5(:),G1H2(245),m3h2x2(:,590),heltab2x4(:,:,718))
  call Hloop_Q_A(ntryL,G1H2(245),59,0,G2H2(146),n2h2(518))
  call Hloop_AQ_V(ntryL,G2H4(118),ex2(:),G2H2(1),m3h2x2(:,591),heltab2x4(:,:,719))
  call Hloop_AQ_V(ntryL,G2H4(122),ex1(:),G2H2(433),m3h2x2(:,592),heltab2x4(:,:,720))
  call Hloop_QA_V(ntryL,G2H8(47),ex4(:),G2H4(57),m3h2x4(:,389),heltab2x8(:,:,523))
  call Hloop_QA_V(ntryL,G2H8(49),ex4(:),G2H4(41),m3h2x4(:,390),heltab2x8(:,:,524))
  call Hloop_QA_V(ntryL,G2H8(52),ex3(:),G2H4(61),m3h2x4(:,391),heltab2x8(:,:,525))
  call Hloop_AQ_V(ntryL,G2H8(55),ex2(:),G2H4(68),m3h2x4(:,392),heltab2x8(:,:,526))
  call Hloop_QA_V(ntryL,G2H8(56),ex3(:),G2H4(71),m3h2x4(:,393),heltab2x8(:,:,527))
  call Hloop_AQ_V(ntryL,G2H8(59),ex1(:),G2H4(75),m3h2x4(:,394),heltab2x8(:,:,528))
  call Hloop_UV_W(ntryL,G1H16(56),40,wf4(:,1),5,G2H4(78),m3h4x4(:,59),heltab2x16(:,:,353))
  call Hotf_4pt_reduction(G2H16(1),RedSet_4(251),mass4set(:,1),  & 
G1H16(103),G1H16(109),G1H16(114),G1H16(57),G1H16(59),16)
  call HG1shiftOLR(G1H16(109),18,16)
  call Hloop_AQ_V(ntryL,G2H8(3),wf4(:,4),G2H2(435),m3h4x2(:,135),heltab2x8(:,:,529))
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(85),m3h2x4(:,395),heltab2x8(:,:,530))
  call Hloop_UV_W(ntryL,G1H16(58),34,wf4(:,1),5,G2H4(111),m3h4x4(:,60),heltab2x16(:,:,354))
  call Hotf_4pt_reduction(G2H16(2),RedSet_4(126),mass4set(:,1),  & 
G1H16(61),G1H16(63),G1H16(26),G1H16(4),G1H16(29),16)
  call HG1shiftOLR(G1H16(63),24,16)
  call Hloop_VA_Q(ntryL,G1H16(60),wf4(:,9),G1H4(420),m3h4x4(:,61),heltab2x16(:,:,355))
  call Hloop_A_Q(ntryL,G1H4(420),58,0,G2H4(92),n2h4(361))
  call Hloop_QA_V(ntryL,G2H16(3),wf4(:,9),G2H4(98),m3h4x4(:,62),heltab2x16(:,:,356))
  call Hloop_AQ_V(ntryL,G2H8(7),ex2(:),G2H4(102),m3h2x4(:,396),heltab2x8(:,:,531))
  call Hloop_VQ_A(ntryL,G1H16(62),wf8(:,8),G1H2(246),m3h8x2(:,1),heltab2x16(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(246),47,0,G2H2(3),n2h2(519))
  call Hotf_4pt_reduction(G2H16(4),RedSet_4(37),mass4set(:,1),  & 
G1H16(7),G1H16(66),G1H16(68),G1H16(14),G1H16(69),16)
  call HG1shiftOLR(G1H16(66),13,16)
  call Hloop_VA_Q(ntryL,G1H16(25),wf8(:,3),G1H2(804),m3h8x2(:,2),heltab2x16(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(804),47,0,G2H2(424),n2h2(520))
  call Hloop_AQ_V(ntryL,G2H8(58),wf4(:,12),G2H2(426),m3h4x2(:,136),heltab2x8(:,:,532))
  call Hloop_UV_W(ntryL,G1H16(3),40,wf4(:,11),6,G2H4(107),m3h4x4(:,63),heltab2x16(:,:,359))
  call Hotf_4pt_reduction(G2H16(5),RedSet_4(292),mass4set(:,1),  & 
G1H16(70),G1H16(72),G1H16(76),G1H16(77),G1H16(80),16)
  call HG1shiftOLR(G1H16(72),17,16)
  call Hloop_QA_V(ntryL,G2H8(20),ex4(:),G2H4(110),m3h2x4(:,397),heltab2x8(:,:,533))
  call Hloop_UV_W(ntryL,G1H16(27),33,wf4(:,11),6,G2H4(104),m3h4x4(:,64),heltab2x16(:,:,360))
  call Hotf_4pt_reduction(G2H16(6),RedSet_4(135),mass4set(:,1),  & 
G1H16(21),G1H16(22),G1H16(34),G1H16(39),G1H16(10),16)
  call HG1shiftOLR(G1H16(22),24,16)
  call Hloop_VA_Q(ntryL,G1H16(5),wf4(:,9),G1H4(423),m3h4x4(:,65),heltab2x16(:,:,361))
  call Hloop_A_Q(ntryL,G1H4(423),57,0,G2H4(81),n2h4(362))
  call Hloop_QA_V(ntryL,G2H16(7),wf4(:,9),G2H4(88),m3h4x4(:,66),heltab2x16(:,:,362))
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(151),m3h2x4(:,398),heltab2x8(:,:,534))
  call Hloop_VQ_A(ntryL,G1H16(30),wf8(:,18),G1H2(251),m3h8x2(:,3),heltab2x16(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(251),47,0,G2H2(13),n2h2(521))
  call Hotf_4pt_reduction(G2H16(8),RedSet_4(65),mass4set(:,1),  & 
G1H16(32),G1H16(35),G1H16(37),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(35),14,16)
  call Hloop_VA_Q(ntryL,G1H16(11),wf8(:,16),G1H2(252),m3h8x2(:,4),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(252),47,0,G2H2(421),n2h2(522))
  call Hloop_UV_W(ntryL,G1H16(64),36,wf4(:,15),9,G2H4(9),m3h4x4(:,67),heltab2x16(:,:,365))
  call Hotf_4pt_reduction(G2H16(9),RedSet_4(273),mass4set(:,1),  & 
G1H16(84),G1H16(87),G1H16(89),G1H16(92),G1H16(94),16)
  call HG1shiftOLR(G1H16(87),18,16)
  call Hloop_VQ_A(ntryL,G1H16(67),wf4(:,4),G1H4(430),m3h4x4(:,68),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G1H4(430),54,0,G2H4(5),n2h4(363))
  call Hloop_AQ_V(ntryL,G2H16(10),wf4(:,4),G2H4(13),m3h4x4(:,69),heltab2x16(:,:,367))
  call Hloop_QA_V(ntryL,G2H8(9),ex3(:),G2H4(14),m3h2x4(:,399),heltab2x8(:,:,535))
  call Hloop_UV_W(ntryL,G1H16(13),34,wf4(:,15),9,G2H4(94),m3h4x4(:,70),heltab2x16(:,:,368))
  call Hotf_4pt_reduction(G2H16(11),RedSet_4(162),mass4set(:,1),  & 
G1H16(95),G1H16(2),G1H16(33),G1H16(12),G1H16(20),16)
  call HG1shiftOLR(G1H16(2),20,16)
  call Hloop_VA_Q(ntryL,G1H16(31),wf4(:,19),G1H4(38),m3h4x4(:,71),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G1H4(38),54,0,G2H4(11),n2h4(364))
  call Hloop_QA_V(ntryL,G2H16(12),wf4(:,19),G2H4(96),m3h4x4(:,72),heltab2x16(:,:,370))
  call Hloop_AQ_V(ntryL,G2H8(11),ex2(:),G2H4(8),m3h2x4(:,400),heltab2x8(:,:,536))
  call Hotf_4pt_reduction(G2H16(13),RedSet_4(13),mass4set(:,1),  & 
G1H16(9),G1H16(8),G1H16(36),G1H16(98),G1H16(41),16)
  call HG1shiftOLR(G1H16(8),11,16)
  call Hloop_VQ_A(ntryL,G1H16(71),wf8(:,27),G1H2(256),m3h8x2(:,5),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(256),47,0,G2H2(423),n2h2(523))
  call Hotf_4pt_reduction(G2H16(14),RedSet_4(37),mass4set(:,1),  & 
G1H16(44),G1H16(100),G1H16(102),G1H16(105),G1H16(40),16)
  call HG1shiftOLR(G1H16(100),13,16)
  call Hloop_VA_Q(ntryL,G1H16(74),wf8(:,22),G1H2(257),m3h8x2(:,6),heltab2x16(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(257),47,0,G2H2(17),n2h2(524))
  call Hloop_VQ_A(ntryL,G1H16(75),wf4(:,12),G1H4(153),m3h4x4(:,73),heltab2x16(:,:,373))
  call Hloop_Q_A(ntryL,G1H4(153),53,0,G2H4(83),n2h4(365))
  call Hloop_AQ_V(ntryL,G2H16(15),wf4(:,12),G2H4(84),m3h4x4(:,74),heltab2x16(:,:,374))
  call Hloop_UV_W(ntryL,G1H16(18),36,wf4(:,20),10,G2H4(25),m3h4x4(:,75),heltab2x16(:,:,375))
  call Hotf_4pt_reduction(G2H16(16),RedSet_4(298),mass4set(:,1),  & 
G1H16(45),G1H16(17),G1H16(49),G1H16(50),G1H16(107),16)
  call HG1shiftOLR(G1H16(17),17,16)
  call Hloop_QA_V(ntryL,G2H8(13),ex3(:),G2H4(28),m3h2x4(:,401),heltab2x8(:,:,537))
  call Hloop_UV_W(ntryL,G1H16(79),33,wf4(:,20),10,G2H4(87),m3h4x4(:,76),heltab2x16(:,:,376))
  call Hotf_4pt_reduction(G2H16(17),RedSet_4(175),mass4set(:,1),  & 
G1H16(110),G1H16(112),G1H16(113),G1H16(116),G1H16(65),16)
  call HG1shiftOLR(G1H16(112),20,16)
  call Hloop_VA_Q(ntryL,G1H16(81),wf4(:,19),G1H4(154),m3h4x4(:,77),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G1H4(154),53,0,G2H4(90),n2h4(366))
  call Hloop_QA_V(ntryL,G2H16(18),wf4(:,19),G2H4(34),m3h4x4(:,78),heltab2x16(:,:,378))
  call Hloop_AQ_V(ntryL,G2H8(15),ex1(:),G2H4(37),m3h2x4(:,402),heltab2x8(:,:,538))
  call Hotf_4pt_reduction(G2H16(19),RedSet_4(13),mass4set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),16)
  call HG1shiftOLR(G1H16(52),11,16)
  call Hloop_VQ_A(ntryL,G1H16(24),wf8(:,35),G1H2(258),m3h8x2(:,7),heltab2x16(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(258),47,0,G2H2(430),n2h2(525))
  call Hotf_4pt_reduction(G2H16(20),RedSet_4(65),mass4set(:,1),  & 
G1H16(1),G1H16(15),G1H16(73),G1H16(23),G1H16(91),16)
  call HG1shiftOLR(G1H16(15),14,16)
  call Hloop_VA_Q(ntryL,G1H16(82),wf8(:,33),G1H2(769),m3h8x2(:,8),heltab2x16(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(769),47,0,G2H2(432),n2h2(526))
  call Hloop_AQ_V(ntryL,G1H8(151),wf4(:,12),G1H2(263),m3h4x2(:,137),heltab2x8(:,:,539))
  call Hloop_AQ_V(ntryL,G1H8(155),ex2(:),G1H4(354),m3h2x4(:,403),heltab2x8(:,:,540))
  call Hloop_QA_V(ntryL,G1H8(156),ex4(:),G1H4(355),m3h2x4(:,404),heltab2x8(:,:,541))
  call Hloop_AQ_V(ntryL,G1H8(161),ex2(:),G1H4(184),m3h2x4(:,405),heltab2x8(:,:,542))
  call Hloop_QA_V(ntryL,G1H8(162),ex3(:),G1H4(188),m3h2x4(:,406),heltab2x8(:,:,543))
  call Hloop_VQ_A(ntryL,G1H8(164),wf4(:,12),G1H2(264),m3h4x2(:,138),heltab2x8(:,:,544))
  call Hloop_Q_A(ntryL,G1H2(264),59,0,G2H2(23),n2h2(527))
  call Hloop_VA_Q(ntryL,G1H16(83),ex4(:),G1H8(23),m3h2x8(:,295),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G1H8(23),42,0,G2H8(18),n2h8(357))
  call Hloop_QA_V(ntryL,G2H16(21),ex4(:),G2H8(19),m3h2x8(:,296),heltab2x16(:,:,382))
  call Hloop_VQ_A(ntryL,G1H16(86),ex2(:),G1H8(146),m3h2x8(:,297),heltab2x16(:,:,383))
  call Hloop_Q_A(ntryL,G1H8(146),42,0,G2H8(22),n2h8(358))
  call Hloop_AQ_V(ntryL,G2H16(22),ex2(:),G2H8(23),m3h2x8(:,298),heltab2x16(:,:,384))
  call Hloop_UV_W(ntryL,G1H16(88),34,wf8(:,30),21,G2H2(442),m3h8x2(:,9),heltab2x16(:,:,385))
  call Hotf_4pt_reduction(G2H16(23),RedSet_4(34),mass4set(:,1),  & 
G1H16(43),G1H16(56),G1H16(58),G1H16(60),G1H16(62),16)
  call HG1shiftOLR(G1H16(56),8,16)
  call Hloop_VA_Q(ntryL,G1H16(90),ex3(:),G1H8(5),m3h2x8(:,299),heltab2x16(:,:,386))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(25),n2h8(359))
  call Hloop_QA_V(ntryL,G2H16(24),ex3(:),G2H8(26),m3h2x8(:,300),heltab2x16(:,:,387))
  call Hloop_VQ_A(ntryL,G1H16(93),ex2(:),G1H8(6),m3h2x8(:,301),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G1H8(6),38,0,G2H8(27),n2h8(360))
  call Hloop_AQ_V(ntryL,G2H16(25),ex2(:),G2H8(65),m3h2x8(:,302),heltab2x16(:,:,389))
  call Hloop_UV_W(ntryL,G1H16(38),34,wf8(:,12),25,G2H2(444),m3h8x2(:,10),heltab2x16(:,:,390))
  call Hotf_4pt_reduction(G2H16(26),RedSet_4(49),mass4set(:,1),  & 
G1H16(25),G1H16(3),G1H16(27),G1H16(5),G1H16(30),16)
  call HG1shiftOLR(G1H16(3),4,16)
  call Hloop_AQ_V(ntryL,G1H4(44),ex2(:),G1H2(268),m3h2x2(:,593),heltab2x4(:,:,721))
  call Hloop_QA_V(ntryL,G1H4(76),ex3(:),G1H2(269),m3h2x2(:,594),heltab2x4(:,:,722))
  call Hloop_QA_V(ntryL,G1H4(82),ex4(:),G1H2(270),m3h2x2(:,595),heltab2x4(:,:,723))
  call Hloop_AQ_V(ntryL,G1H8(170),wf4(:,4),G1H2(774),m3h4x2(:,139),heltab2x8(:,:,545))
  call Hloop_AQ_V(ntryL,G1H8(173),ex1(:),G1H4(202),m3h2x4(:,407),heltab2x8(:,:,546))
  call Hloop_QA_V(ntryL,G1H8(174),ex4(:),G1H4(212),m3h2x4(:,408),heltab2x8(:,:,547))
  call Hloop_AQ_V(ntryL,G1H8(179),ex1(:),G1H4(225),m3h2x4(:,409),heltab2x8(:,:,548))
  call Hloop_QA_V(ntryL,G1H8(180),ex3(:),G1H4(232),m3h2x4(:,410),heltab2x8(:,:,549))
  call Hloop_VQ_A(ntryL,G1H8(182),wf4(:,4),G1H2(275),m3h4x2(:,140),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H2(275),59,0,G2H2(29),n2h2(528))
  call Hloop_VA_Q(ntryL,G1H16(97),ex4(:),G1H8(44),m3h2x8(:,303),heltab2x16(:,:,391))
  call Hloop_A_Q(ntryL,G1H8(44),41,0,G2H8(66),n2h8(361))
  call Hloop_QA_V(ntryL,G2H16(27),ex4(:),G2H8(67),m3h2x8(:,304),heltab2x16(:,:,392))
  call Hloop_VQ_A(ntryL,G1H16(99),ex1(:),G1H8(74),m3h2x8(:,305),heltab2x16(:,:,393))
  call Hloop_Q_A(ntryL,G1H8(74),41,0,G2H8(69),n2h8(362))
  call Hloop_AQ_V(ntryL,G2H16(28),ex1(:),G2H8(70),m3h2x8(:,306),heltab2x16(:,:,394))
  call Hloop_UV_W(ntryL,G1H16(42),33,wf8(:,23),22,G2H2(427),m3h8x2(:,11),heltab2x16(:,:,395))
  call Hotf_4pt_reduction(G2H16(29),RedSet_4(62),mass4set(:,1),  & 
G1H16(11),G1H16(64),G1H16(67),G1H16(13),G1H16(31),16)
  call HG1shiftOLR(G1H16(64),8,16)
  call Hloop_VA_Q(ntryL,G1H16(46),ex3(:),G1H8(75),m3h2x8(:,307),heltab2x16(:,:,396))
  call Hloop_A_Q(ntryL,G1H8(75),37,0,G2H8(71),n2h8(363))
  call Hloop_QA_V(ntryL,G2H16(30),ex3(:),G2H8(73),m3h2x8(:,308),heltab2x16(:,:,397))
  call Hloop_VQ_A(ntryL,G1H16(101),ex1(:),G1H8(86),m3h2x8(:,309),heltab2x16(:,:,398))
  call Hloop_Q_A(ntryL,G1H8(86),37,0,G2H8(74),n2h8(364))
  call Hloop_AQ_V(ntryL,G2H16(31),ex1(:),G2H8(75),m3h2x8(:,310),heltab2x16(:,:,399))
  call Hloop_UV_W(ntryL,G1H16(104),33,wf8(:,4),26,G2H2(429),m3h8x2(:,12),heltab2x16(:,:,400))
  call Hotf_4pt_reduction(G2H16(32),RedSet_4(77),mass4set(:,1),  & 
G1H16(71),G1H16(74),G1H16(75),G1H16(18),G1H16(79),16)
  call HG1shiftOLR(G1H16(74),4,16)
  call Hloop_AQ_V(ntryL,G1H4(294),ex1(:),G1H2(276),m3h2x2(:,596),heltab2x4(:,:,724))
  call Hloop_QA_V(ntryL,G1H4(435),ex3(:),G1H2(280),m3h2x2(:,597),heltab2x4(:,:,725))
  call Hloop_QA_V(ntryL,G1H4(438),ex4(:),G1H2(281),m3h2x2(:,598),heltab2x4(:,:,726))
  call Hloop_QA_V(ntryL,G1H8(185),ex4(:),G1H4(238),m3h2x4(:,411),heltab2x8(:,:,551))
  call Hloop_AQ_V(ntryL,G1H8(186),ex2(:),G1H4(243),m3h2x4(:,412),heltab2x8(:,:,552))
  call Hloop_QA_V(ntryL,G1H8(188),wf4(:,19),G1H2(282),m3h4x2(:,141),heltab2x8(:,:,553))
  call Hloop_QA_V(ntryL,G1H8(191),ex4(:),G1H4(248),m3h2x4(:,413),heltab2x8(:,:,554))
  call Hloop_AQ_V(ntryL,G1H8(192),ex1(:),G1H4(255),m3h2x4(:,414),heltab2x8(:,:,555))
  call Hloop_QA_V(ntryL,G1H8(194),wf4(:,19),G1H2(799),m3h4x2(:,142),heltab2x8(:,:,556))
  call Hloop_QA_V(ntryL,G1H8(199),wf4(:,19),G1H2(287),m3h4x2(:,143),heltab2x8(:,:,557))
  call Hloop_VA_Q(ntryL,G1H8(200),wf4(:,19),G1H2(288),m3h4x2(:,144),heltab2x8(:,:,558))
  call Hloop_A_Q(ntryL,G1H2(288),61,0,G2H2(35),n2h2(529))
  call Hloop_VA_Q(ntryL,G1H16(106),ex4(:),G1H8(98),m3h2x8(:,311),heltab2x16(:,:,401))
  call Hloop_A_Q(ntryL,G1H8(98),42,0,G2H8(77),n2h8(365))
  call Hloop_QA_V(ntryL,G2H16(33),ex4(:),G2H8(78),m3h2x8(:,312),heltab2x16(:,:,402))
  call Hloop_VQ_A(ntryL,G1H16(108),ex2(:),G1H8(10),m3h2x8(:,313),heltab2x16(:,:,403))
  call Hloop_Q_A(ntryL,G1H8(10),42,0,G2H8(79),n2h8(366))
  call Hloop_AQ_V(ntryL,G2H16(34),ex2(:),G2H8(81),m3h2x8(:,314),heltab2x16(:,:,404))
  call Hloop_UV_W(ntryL,G1H16(111),34,wf8(:,36),21,G2H2(436),m3h8x2(:,13),heltab2x16(:,:,405))
  call Hotf_4pt_reduction(G2H16(35),RedSet_4(34),mass4set(:,1),  & 
G1H16(81),G1H16(24),G1H16(82),G1H16(83),G1H16(86),16)
  call HG1shiftOLR(G1H16(24),8,16)
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(13),m3h2x8(:,315),heltab2x16(:,:,406))
  call Hloop_A_Q(ntryL,G1H8(13),41,0,G2H8(82),n2h8(367))
  call Hloop_QA_V(ntryL,G2H16(36),ex4(:),G2H8(83),m3h2x8(:,316),heltab2x16(:,:,407))
  call Hloop_VQ_A(ntryL,G1H16(115),ex1(:),G1H8(21),m3h2x8(:,317),heltab2x16(:,:,408))
  call Hloop_Q_A(ntryL,G1H8(21),41,0,G2H8(85),n2h8(368))
  call Hloop_AQ_V(ntryL,G2H16(37),ex1(:),G2H8(86),m3h2x8(:,318),heltab2x16(:,:,409))
  call Hloop_UV_W(ntryL,G1H16(117),33,wf8(:,28),22,G2H2(438),m3h8x2(:,14),heltab2x16(:,:,410))
  call Hotf_4pt_reduction(G2H16(38),RedSet_4(62),mass4set(:,1),  & 
G1H16(88),G1H16(90),G1H16(93),G1H16(38),G1H16(97),16)
  call HG1shiftOLR(G1H16(90),8,16)
  call Hloop_QA_V(ntryL,G1H4(445),ex4(:),G1H2(292),m3h2x2(:,599),heltab2x4(:,:,727))
  call Hloop_VA_Q(ntryL,G1H4(448),ex4(:),G1H2(293),m3h2x2(:,600),heltab2x4(:,:,728))
  call Hloop_A_Q(ntryL,G1H2(293),61,0,G2H2(38),n2h2(530))
  call Hloop_QA_V(ntryL,G1H8(203),ex3(:),G1H4(256),m3h2x4(:,415),heltab2x8(:,:,559))
  call Hloop_AQ_V(ntryL,G1H8(204),ex2(:),G1H4(260),m3h2x4(:,416),heltab2x8(:,:,560))
  call Hloop_QA_V(ntryL,G1H8(206),wf4(:,9),G1H2(294),m3h4x2(:,145),heltab2x8(:,:,561))
  call Hloop_QA_V(ntryL,G1H8(209),ex3(:),G1H4(261),m3h2x4(:,417),heltab2x8(:,:,562))
  call Hloop_AQ_V(ntryL,G1H8(210),ex1(:),G1H4(268),m3h2x4(:,418),heltab2x8(:,:,563))
  call Hloop_QA_V(ntryL,G1H8(212),wf4(:,9),G1H2(794),m3h4x2(:,146),heltab2x8(:,:,564))
  call Hloop_VA_Q(ntryL,G1H8(217),wf4(:,9),G1H2(299),m3h4x2(:,147),heltab2x8(:,:,565))
  call Hloop_A_Q(ntryL,G1H2(299),61,0,G2H2(439),n2h2(531))
  call Hloop_QA_V(ntryL,G1H8(218),wf4(:,9),G1H2(300),m3h4x2(:,148),heltab2x8(:,:,566))
  call Hloop_VA_Q(ntryL,G1H16(78),ex3(:),G1H8(22),m3h2x8(:,319),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H8(22),38,0,G2H8(87),n2h8(369))
  call Hloop_QA_V(ntryL,G2H16(39),ex3(:),G2H8(89),m3h2x8(:,320),heltab2x16(:,:,412))
  call Hloop_VQ_A(ntryL,G1H16(28),ex2(:),G1H8(51),m3h2x8(:,321),heltab2x16(:,:,413))
  call Hloop_Q_A(ntryL,G1H8(51),38,0,G2H8(90),n2h8(370))
  call Hloop_AQ_V(ntryL,G2H16(40),ex2(:),G2H8(91),m3h2x8(:,322),heltab2x16(:,:,414))
  call Hloop_UV_W(ntryL,G1H16(16),34,wf8(:,19),25,G2H2(441),m3h8x2(:,15),heltab2x16(:,:,415))
  call Hotf_4pt_reduction(G2H16(41),RedSet_4(49),mass4set(:,1),  & 
G1H16(99),G1H16(42),G1H16(46),G1H16(101),G1H16(104),16)
  call HG1shiftOLR(G1H16(42),4,16)
  call Hloop_VA_Q(ntryL,G1H16(19),ex3(:),G1H8(55),m3h2x8(:,323),heltab2x16(:,:,416))
  call Hloop_A_Q(ntryL,G1H8(55),37,0,G2H8(93),n2h8(371))
  call Hloop_QA_V(ntryL,G2H16(42),ex3(:),G2H8(94),m3h2x8(:,324),heltab2x16(:,:,417))
  call Hloop_VQ_A(ntryL,G1H16(85),ex1(:),G1H8(101),m3h2x8(:,325),heltab2x16(:,:,418))
  call Hloop_Q_A(ntryL,G1H8(101),37,0,G2H8(95),n2h8(372))
  call Hloop_AQ_V(ntryL,G2H16(43),ex1(:),G2H8(97),m3h2x8(:,326),heltab2x16(:,:,419))
  call Hloop_UV_W(ntryL,G1H16(96),33,wf8(:,9),26,G2H2(147),m3h8x2(:,16),heltab2x16(:,:,420))
  call Hotf_4pt_reduction(G2H16(44),RedSet_4(77),mass4set(:,1),  & 
G1H16(106),G1H16(108),G1H16(111),G1H16(6),G1H16(115),16)
  call HG1shiftOLR(G1H16(108),4,16)
  call Hloop_VQ_A(ntryL,G1H4(450),ex1(:),G1H2(304),m3h2x2(:,601),heltab2x4(:,:,729))
  call Hloop_Q_A(ntryL,G1H2(304),59,0,G2H2(5),n2h2(532))
  call Hloop_VQ_A(ntryL,G1H4(453),ex2(:),G1H2(305),m3h2x2(:,602),heltab2x4(:,:,730))
  call Hloop_Q_A(ntryL,G1H2(305),59,0,G2H2(148),n2h2(533))
  call Hloop_QA_V(ntryL,G1H4(455),ex3(:),G1H2(306),m3h2x2(:,603),heltab2x4(:,:,731))
  call Hloop_VA_Q(ntryL,G1H4(458),ex3(:),G1H2(779),m3h2x2(:,604),heltab2x4(:,:,732))
  call Hloop_A_Q(ntryL,G1H2(779),61,0,G2H2(7),n2h2(534))
  call Hloop_QV_A(ntryL,G1H4(298),ex5(:),G1H2(311),m3h2x2(:,605),heltab2x4(:,:,733))
  call Hloop_Q_A(ntryL,G1H2(311),55,0,G2H2(149),n2h2(535))
call HGT_raise_alpha_OLR(G1H4(309),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(309),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(309),ex4(:),G1H2(312),m3h2x2(:,606),heltab2x4(:,:,734))
  call Hloop_QV_A(ntryL,G1H4(185),ex5(:),G1H2(316),m3h2x2(:,607),heltab2x4(:,:,735))
  call Hloop_Q_A(ntryL,G1H2(316),55,0,G2H2(9),n2h2(536))
  call Hloop_QV_A(ntryL,G1H4(293),ex5(:),G1H2(2),m3h2x2(:,608),heltab2x4(:,:,736))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(150),n2h2(537))
  call Hloop_AV_Q(ntryL,G1H4(364),ex5(:),G1H2(317),m3h2x2(:,609),heltab2x4(:,:,737))
  call Hloop_A_Q(ntryL,G1H2(317),61,0,G2H2(11),n2h2(538))
call HGT_raise_alpha_OLR(G1H4(381),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(381),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(381),ex2(:),G1H2(321),m3h2x2(:,610),heltab2x4(:,:,738))
  call Hloop_AV_Q(ntryL,G1H4(411),ex5(:),G1H2(4),m3h2x2(:,611),heltab2x4(:,:,739))
  call Hloop_A_Q(ntryL,G1H2(4),61,0,G2H2(151),n2h2(539))
  call Hloop_AV_Q(ntryL,G1H4(429),ex5(:),G1H2(322),m3h2x2(:,612),heltab2x4(:,:,740))
  call Hloop_A_Q(ntryL,G1H2(322),61,0,G2H2(152),n2h2(540))
  call Hloop_AV_Q(ntryL,G1H4(346),ex5(:),G1H2(326),m3h2x2(:,613),heltab2x4(:,:,741))
  call Hloop_A_Q(ntryL,G1H2(326),62,0,G2H2(15),n2h2(541))
call HGT_raise_alpha_OLR(G1H4(201),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(201),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(201),ex1(:),G1H2(6),m3h2x2(:,614),heltab2x4(:,:,742))
  call Hloop_AV_Q(ntryL,G1H4(141),ex5(:),G1H2(327),m3h2x2(:,615),heltab2x4(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(327),62,0,G2H2(153),n2h2(542))
  call Hloop_AV_Q(ntryL,G1H4(449),ex5(:),G1H2(331),m3h2x2(:,616),heltab2x4(:,:,744))
  call Hloop_A_Q(ntryL,G1H2(331),62,0,G2H2(165),n2h2(543))
  call Hloop_QV_A(ntryL,G1H4(159),ex5(:),G1H2(8),m3h2x2(:,617),heltab2x4(:,:,745))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(20),n2h2(544))
call HGT_raise_alpha_OLR(G1H4(160),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(160),ex4(:),G1H2(332),m3h2x2(:,618),heltab2x4(:,:,746))
  call Hloop_QV_A(ntryL,G1H4(281),ex5(:),G1H2(336),m3h2x2(:,619),heltab2x4(:,:,747))
  call Hloop_Q_A(ntryL,G1H2(336),55,0,G2H2(154),n2h2(545))
  call Hloop_QV_A(ntryL,G1H4(454),ex5(:),G1H2(10),m3h2x2(:,620),heltab2x4(:,:,748))
  call Hloop_Q_A(ntryL,G1H2(10),55,0,G2H2(168),n2h2(546))
  call Hloop_QV_A(ntryL,G1H8(221),wf4(:,1),G1H2(337),m3h4x2(:,149),heltab2x8(:,:,567))
  call Hloop_Q_A(ntryL,G1H2(337),55,0,G2H2(26),n2h2(547))
call HGT_raise_alpha_OLR(G1H8(222),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(222),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(222),ex4(:),G1H4(274),m3h2x4(:,419),heltab2x8(:,:,568))
  call Hloop_QV_A(ntryL,G1H8(224),wf4(:,1),G1H2(341),m3h4x2(:,150),heltab2x8(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(341),55,0,G2H2(155),n2h2(548))
  call Hloop_QV_A(ntryL,G1H8(227),wf4(:,1),G1H2(12),m3h4x2(:,151),heltab2x8(:,:,570))
  call Hloop_Q_A(ntryL,G1H2(12),55,0,G2H2(156),n2h2(549))
  call Hloop_QV_A(ntryL,G1H4(35),ex5(:),G1H2(342),m3h2x2(:,621),heltab2x4(:,:,749))
  call Hloop_Q_A(ntryL,G1H2(342),55,0,G2H2(32),n2h2(550))
call HGT_raise_alpha_OLR(G1H4(81),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(81),ex4(:),G1H2(346),m3h2x2(:,622),heltab2x4(:,:,750))
  call Hloop_QV_A(ntryL,G1H4(17),ex5(:),G1H2(14),m3h2x2(:,623),heltab2x4(:,:,751))
  call Hloop_Q_A(ntryL,G1H2(14),55,0,G2H2(41),n2h2(551))
  call Hloop_QV_A(ntryL,G1H4(64),ex5(:),G1H2(347),m3h2x2(:,624),heltab2x4(:,:,752))
  call Hloop_Q_A(ntryL,G1H2(347),55,0,G2H2(237),n2h2(552))
  call Hloop_QV_A(ntryL,G1H8(228),wf4(:,11),G1H2(351),m3h4x2(:,152),heltab2x8(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(351),55,0,G2H2(44),n2h2(553))
call HGT_raise_alpha_OLR(G1H8(229),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(229),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(229),ex4(:),G1H4(194),m3h2x4(:,420),heltab2x8(:,:,572))
  call Hloop_QV_A(ntryL,G1H8(233),wf4(:,11),G1H2(16),m3h4x2(:,153),heltab2x8(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(16),55,0,G2H2(241),n2h2(554))
  call Hloop_QV_A(ntryL,G1H8(234),wf4(:,11),G1H2(352),m3h4x2(:,154),heltab2x8(:,:,574))
  call Hloop_Q_A(ntryL,G1H2(352),55,0,G2H2(47),n2h2(555))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(356),m3h2x2(:,625),heltab2x4(:,:,753))
  call Hloop_Q_A(ntryL,G1H2(356),59,0,G2H2(245),n2h2(556))
call HGT_raise_alpha_OLR(G1H4(277),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(277),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(277),ex3(:),G1H2(18),m3h2x2(:,626),heltab2x4(:,:,754))
  call Hloop_QV_A(ntryL,G1H4(23),ex5(:),G1H2(357),m3h2x2(:,627),heltab2x4(:,:,755))
  call Hloop_Q_A(ntryL,G1H2(357),59,0,G2H2(50),n2h2(557))
  call Hloop_QV_A(ntryL,G1H4(73),ex5(:),G1H2(361),m3h2x2(:,628),heltab2x4(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(361),59,0,G2H2(249),n2h2(558))
  call Hloop_QV_A(ntryL,G1H8(235),wf4(:,15),G1H2(20),m3h4x2(:,155),heltab2x8(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(20),59,0,G2H2(53),n2h2(559))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(236),ex3(:),G1H4(11),m3h2x4(:,421),heltab2x8(:,:,576))
  call Hloop_QV_A(ntryL,G1H8(240),wf4(:,15),G1H2(362),m3h4x2(:,156),heltab2x8(:,:,577))
  call Hloop_Q_A(ntryL,G1H2(362),59,0,G2H2(253),n2h2(560))
  call Hloop_QV_A(ntryL,G1H8(241),wf4(:,15),G1H2(366),m3h4x2(:,157),heltab2x8(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(366),59,0,G2H2(56),n2h2(561))
  call Hloop_AV_Q(ntryL,G1H4(37),ex5(:),G1H2(22),m3h2x2(:,629),heltab2x4(:,:,757))
  call Hloop_A_Q(ntryL,G1H2(22),61,0,G2H2(257),n2h2(562))
call HGT_raise_alpha_OLR(G1H4(41),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(41),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(41),ex2(:),G1H2(367),m3h2x2(:,630),heltab2x4(:,:,758))
  call Hloop_AV_Q(ntryL,G1H4(60),ex5(:),G1H2(371),m3h2x2(:,631),heltab2x4(:,:,759))
  call Hloop_A_Q(ntryL,G1H2(371),61,0,G2H2(59),n2h2(563))
  call Hloop_AV_Q(ntryL,G1H4(65),ex5(:),G1H2(24),m3h2x2(:,632),heltab2x4(:,:,760))
  call Hloop_A_Q(ntryL,G1H2(24),61,0,G2H2(261),n2h2(564))
  call Hloop_QV_A(ntryL,G1H4(89),ex5(:),G1H2(372),m3h2x2(:,633),heltab2x4(:,:,761))
  call Hloop_Q_A(ntryL,G1H2(372),59,0,G2H2(62),n2h2(565))
call HGT_raise_alpha_OLR(G1H4(90),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(90),ex3(:),G1H2(376),m3h2x2(:,634),heltab2x4(:,:,762))
  call Hloop_QV_A(ntryL,G1H4(120),ex5(:),G1H2(26),m3h2x2(:,635),heltab2x4(:,:,763))
  call Hloop_Q_A(ntryL,G1H2(26),59,0,G2H2(265),n2h2(566))
  call Hloop_QV_A(ntryL,G1H4(143),ex5(:),G1H2(377),m3h2x2(:,636),heltab2x4(:,:,764))
  call Hloop_Q_A(ntryL,G1H2(377),59,0,G2H2(269),n2h2(567))
  call Hloop_QV_A(ntryL,G1H4(144),ex5(:),G1H2(381),m3h2x2(:,637),heltab2x4(:,:,765))
  call Hloop_Q_A(ntryL,G1H2(381),59,0,G2H2(65),n2h2(568))
call HGT_raise_alpha_OLR(G1H4(180),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(180),ex3(:),G1H2(28),m3h2x2(:,638),heltab2x4(:,:,766))
  call Hloop_QV_A(ntryL,G1H4(192),ex5(:),G1H2(382),m3h2x2(:,639),heltab2x4(:,:,767))
  call Hloop_Q_A(ntryL,G1H2(382),59,0,G2H2(273),n2h2(569))
  call Hloop_QV_A(ntryL,G1H4(228),ex5(:),G1H2(386),m3h2x2(:,640),heltab2x4(:,:,768))
  call Hloop_Q_A(ntryL,G1H2(386),59,0,G2H2(277),n2h2(570))
  call Hloop_QV_A(ntryL,G1H8(242),wf4(:,20),G1H2(30),m3h4x2(:,158),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(30),59,0,G2H2(68),n2h2(571))
call HGT_raise_alpha_OLR(G1H8(247),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(247),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(247),ex3(:),G1H4(273),m3h2x4(:,422),heltab2x8(:,:,580))
  call Hloop_QV_A(ntryL,G1H8(248),wf4(:,20),G1H2(387),m3h4x2(:,159),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(387),59,0,G2H2(281),n2h2(572))
  call Hloop_QV_A(ntryL,G1H8(251),wf4(:,20),G1H2(391),m3h4x2(:,160),heltab2x8(:,:,582))
  call Hloop_Q_A(ntryL,G1H2(391),59,0,G2H2(285),n2h2(573))
  call Hloop_AV_Q(ntryL,G1H4(227),ex5(:),G1H2(32),m3h2x2(:,641),heltab2x4(:,:,769))
  call Hloop_A_Q(ntryL,G1H2(32),62,0,G2H2(71),n2h2(574))
call HGT_raise_alpha_OLR(G1H4(259),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(259),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(259),ex1(:),G1H2(392),m3h2x2(:,642),heltab2x4(:,:,770))
  call Hloop_AV_Q(ntryL,G1H4(264),ex5(:),G1H2(396),m3h2x2(:,643),heltab2x4(:,:,771))
  call Hloop_A_Q(ntryL,G1H2(396),62,0,G2H2(289),n2h2(575))
  call Hloop_AV_Q(ntryL,G1H4(288),ex5(:),G1H2(397),m3h2x2(:,644),heltab2x4(:,:,772))
  call Hloop_A_Q(ntryL,G1H2(397),62,0,G2H2(293),n2h2(576))
  call Hloop_QV_A(ntryL,G1H4(3),ex5(:),G1H2(398),m3h2x2(:,645),heltab2x4(:,:,773))
  call Hloop_Q_A(ntryL,G1H2(398),55,0,G2H2(74),n2h2(577))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(402),m3h2x2(:,646),heltab2x4(:,:,774))
  call Hloop_QV_A(ntryL,G1H4(69),ex5(:),G1H2(403),m3h2x2(:,647),heltab2x4(:,:,775))
  call Hloop_Q_A(ntryL,G1H2(403),55,0,G2H2(297),n2h2(578))
  call Hloop_QV_A(ntryL,G1H4(54),ex5(:),G1H2(404),m3h2x2(:,648),heltab2x4(:,:,776))
  call Hloop_Q_A(ntryL,G1H2(404),55,0,G2H2(167),n2h2(579))
  call Hloop_QV_A(ntryL,G1H4(62),ex5(:),G1H2(408),m3h2x2(:,649),heltab2x4(:,:,777))
  call Hloop_Q_A(ntryL,G1H2(408),55,0,G2H2(170),n2h2(580))
call HGT_raise_alpha_OLR(G1H4(113),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(113),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(113),ex4(:),G1H2(409),m3h2x2(:,650),heltab2x4(:,:,778))
  call Hloop_QV_A(ntryL,G1H4(137),ex5(:),G1H2(410),m3h2x2(:,651),heltab2x4(:,:,779))
  call Hloop_Q_A(ntryL,G1H2(410),55,0,G2H2(171),n2h2(581))
  call Hloop_QV_A(ntryL,G1H4(138),ex5(:),G1H2(414),m3h2x2(:,652),heltab2x4(:,:,780))
  call Hloop_Q_A(ntryL,G1H2(414),55,0,G2H2(173),n2h2(582))
  call Hloop_QV_A(ntryL,G1H4(303),ex5(:),G1H2(415),m3h2x2(:,653),heltab2x4(:,:,781))
  call Hloop_Q_A(ntryL,G1H2(415),59,0,G2H2(174),n2h2(583))
call HGT_raise_alpha_OLR(G1H4(306),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(306),ex3(:),G1H2(416),m3h2x2(:,654),heltab2x4(:,:,782))
  call Hloop_QV_A(ntryL,G1H4(311),ex5(:),G1H2(420),m3h2x2(:,655),heltab2x4(:,:,783))
  call Hloop_Q_A(ntryL,G1H2(420),59,0,G2H2(176),n2h2(584))
  call Hloop_QV_A(ntryL,G1H4(161),ex5(:),G1H2(421),m3h2x2(:,656),heltab2x4(:,:,784))
  call Hloop_Q_A(ntryL,G1H2(421),59,0,G2H2(177),n2h2(585))
  call Hloop_QV_A(ntryL,G1H4(162),ex5(:),G1H2(422),m3h2x2(:,657),heltab2x4(:,:,785))
  call Hloop_Q_A(ntryL,G1H2(422),59,0,G2H2(179),n2h2(586))
call HGT_raise_alpha_OLR(G1H4(324),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(324),ex3(:),G1H2(426),m3h2x2(:,658),heltab2x4(:,:,786))
  call Hloop_QV_A(ntryL,G1H4(328),ex5(:),G1H2(427),m3h2x2(:,659),heltab2x4(:,:,787))
  call Hloop_Q_A(ntryL,G1H2(427),59,0,G2H2(180),n2h2(587))
  call Hloop_QV_A(ntryL,G1H4(329),ex5(:),G1H2(428),m3h2x2(:,660),heltab2x4(:,:,788))
  call Hloop_Q_A(ntryL,G1H2(428),59,0,G2H2(182),n2h2(588))
  call Hloop_AV_Q(ntryL,G1H8(253),wf4(:,1),G1H2(432),m3h4x2(:,161),heltab2x8(:,:,583))
  call Hloop_A_Q(ntryL,G1H2(432),47,0,G2H2(183),n2h2(589))
call HGT_OLR(G1H8(256),1,1,8)
call HGT_invQ_OLR(G1H8(256),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(256),-16,0,G2H8(98),n2h8(377))
  call Hloop_QV_A(ntryL,G2H8(98),ex5(:),G2H4(93),m3h2x4(:,423),heltab2x8(:,:,584))
  call Hloop_AV_Q(ntryL,G1H8(258),wf4(:,1),G1H2(433),m3h4x2(:,162),heltab2x8(:,:,585))
  call Hloop_A_Q(ntryL,G1H2(433),47,0,G2H2(185),n2h2(590))
  call Hloop_AV_Q(ntryL,G1H8(263),wf4(:,1),G1H2(434),m3h4x2(:,163),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H2(434),47,0,G2H2(186),n2h2(591))
  call Hloop_AV_Q(ntryL,G0H8(17),wf4(:,1),G0H2(1),m3h4x2(:,164),heltab2x8(:,:,587))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(438),n2h2(592))
  call Hloop_QV_A(ntryL,G1H8(268),wf4(:,1),G1H2(439),m3h4x2(:,165),heltab2x8(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(439),47,0,G2H2(188),n2h2(593))
call HGT_OLR(G1H8(264),1,1,8)
call HGT_invQ_OLR(G1H8(264),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(264),-16,0,G2H8(99),n2h8(378))
  call Hloop_AV_Q(ntryL,G2H8(99),ex5(:),G2H4(115),m3h2x4(:,424),heltab2x8(:,:,589))
  call Hloop_QV_A(ntryL,G1H8(269),wf4(:,1),G1H2(440),m3h4x2(:,166),heltab2x8(:,:,590))
  call Hloop_Q_A(ntryL,G1H2(440),47,0,G2H2(189),n2h2(594))
  call Hloop_QV_A(ntryL,G1H8(272),wf4(:,1),G1H2(444),m3h4x2(:,167),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(444),47,0,G2H2(191),n2h2(595))
  call Hloop_QV_A(ntryL,G0H8(18),wf4(:,1),G0H2(1),m3h4x2(:,168),heltab2x8(:,:,592))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(445),n2h2(596))
  call Hloop_AV_Q(ntryL,G1H8(273),wf4(:,11),G1H2(446),m3h4x2(:,169),heltab2x8(:,:,593))
  call Hloop_A_Q(ntryL,G1H2(446),47,0,G2H2(192),n2h2(597))
call HGT_OLR(G1H8(274),1,1,8)
call HGT_invQ_OLR(G1H8(274),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(274),-16,0,G2H8(101),n2h8(379))
  call Hloop_QV_A(ntryL,G2H8(101),ex5(:),G2H4(117),m3h2x4(:,425),heltab2x8(:,:,594))
  call Hloop_AV_Q(ntryL,G1H8(284),wf4(:,11),G1H2(450),m3h4x2(:,170),heltab2x8(:,:,595))
  call Hloop_A_Q(ntryL,G1H2(450),47,0,G2H2(194),n2h2(598))
  call Hloop_AV_Q(ntryL,G1H8(280),wf4(:,11),G1H2(451),m3h4x2(:,171),heltab2x8(:,:,596))
  call Hloop_A_Q(ntryL,G1H2(451),47,0,G2H2(195),n2h2(599))
  call Hloop_AV_Q(ntryL,G0H8(21),wf4(:,11),G0H2(1),m3h4x2(:,172),heltab2x8(:,:,597))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(452),n2h2(600))
  call Hloop_QV_A(ntryL,G1H8(283),wf4(:,11),G1H2(456),m3h4x2(:,173),heltab2x8(:,:,598))
  call Hloop_Q_A(ntryL,G1H2(456),47,0,G2H2(197),n2h2(601))
call HGT_OLR(G1H8(285),1,1,8)
call HGT_invQ_OLR(G1H8(285),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(285),-16,0,G2H8(102),n2h8(380))
  call Hloop_AV_Q(ntryL,G2H8(102),ex5(:),G2H4(121),m3h2x4(:,426),heltab2x8(:,:,599))
  call Hloop_QV_A(ntryL,G1H8(289),wf4(:,11),G1H2(457),m3h4x2(:,174),heltab2x8(:,:,600))
  call Hloop_Q_A(ntryL,G1H2(457),47,0,G2H2(198),n2h2(602))
  call Hloop_QV_A(ntryL,G1H8(290),wf4(:,11),G1H2(458),m3h4x2(:,175),heltab2x8(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(458),47,0,G2H2(200),n2h2(603))
  call Hloop_QV_A(ntryL,G0H8(22),wf4(:,11),G0H2(1),m3h4x2(:,176),heltab2x8(:,:,602))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(462),n2h2(604))
  call Hloop_QV_A(ntryL,G1H8(295),ex5(:),G1H4(353),m3h2x4(:,427),heltab2x8(:,:,603))
  call Hloop_Q_A(ntryL,G1H4(353),54,0,G2H4(51),n2h4(381))
call HGT_OLR(G1H8(300),1,1,8)
call HGT_invQ_OLR(G1H8(300),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(300),-9,0,G2H8(29),n2h8(381))
  call Hloop_AV_Q(ntryL,G2H8(29),wf4(:,15),G2H2(201),m3h4x2(:,177),heltab2x8(:,:,604))
  call Hloop_QV_A(ntryL,G1H8(299),ex5(:),G1H4(344),m3h2x4(:,428),heltab2x8(:,:,605))
  call Hloop_Q_A(ntryL,G1H4(344),54,0,G2H4(58),n2h4(382))
  call Hloop_QV_A(ntryL,G1H8(301),ex5(:),G1H4(92),m3h2x4(:,429),heltab2x8(:,:,606))
  call Hloop_Q_A(ntryL,G1H4(92),54,0,G2H4(141),n2h4(383))
  call Hloop_QV_A(ntryL,G0H8(23),ex5(:),G0H4(1),m3h2x4(:,430),heltab2x8(:,:,607))
  call Hloop_Q_A(ntryL,G0H4(1),54,0,G1H4(34),n2h4(384))
  call Hloop_AV_Q(ntryL,G1H8(304),ex5(:),G1H4(296),m3h2x4(:,431),heltab2x8(:,:,608))
  call Hloop_A_Q(ntryL,G1H4(296),54,0,G2H4(63),n2h4(385))
call HGT_OLR(G1H8(67),1,1,8)
call HGT_invQ_OLR(G1H8(67),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(67),-9,0,G2H8(30),n2h8(382))
  call Hloop_QV_A(ntryL,G2H8(30),wf4(:,15),G2H2(203),m3h4x2(:,178),heltab2x8(:,:,609))
  call Hloop_AV_Q(ntryL,G1H8(87),ex5(:),G1H4(29),m3h2x4(:,432),heltab2x8(:,:,610))
  call Hloop_A_Q(ntryL,G1H4(29),54,0,G2H4(66),n2h4(386))
  call Hloop_AV_Q(ntryL,G1H8(81),ex5(:),G1H4(182),m3h2x4(:,433),heltab2x8(:,:,611))
  call Hloop_A_Q(ntryL,G1H4(182),54,0,G2H4(147),n2h4(387))
  call Hloop_AV_Q(ntryL,G0H8(19),ex5(:),G0H4(1),m3h2x4(:,434),heltab2x8(:,:,612))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(106),n2h4(388))
  call Hloop_AV_Q(ntryL,G1H8(278),wf4(:,15),G1H2(463),m3h4x2(:,179),heltab2x8(:,:,613))
  call Hloop_A_Q(ntryL,G1H2(463),47,0,G2H2(204),n2h2(605))
call HGT_OLR(G1H8(97),1,1,8)
call HGT_invQ_OLR(G1H8(97),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(97),-16,0,G2H8(31),n2h8(383))
  call Hloop_QV_A(ntryL,G2H8(31),ex5(:),G2H4(73),m3h2x4(:,435),heltab2x8(:,:,614))
  call Hloop_AV_Q(ntryL,G1H8(65),wf4(:,15),G1H2(464),m3h4x2(:,180),heltab2x8(:,:,615))
  call Hloop_A_Q(ntryL,G1H2(464),47,0,G2H2(206),n2h2(606))
  call Hloop_AV_Q(ntryL,G1H8(92),wf4(:,15),G1H2(679),m3h4x2(:,181),heltab2x8(:,:,616))
  call Hloop_A_Q(ntryL,G1H2(679),47,0,G2H2(207),n2h2(607))
  call Hloop_AV_Q(ntryL,G0H8(20),wf4(:,15),G0H2(1),m3h4x2(:,182),heltab2x8(:,:,617))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(469),n2h2(608))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,15),G1H2(470),m3h4x2(:,183),heltab2x8(:,:,618))
  call Hloop_Q_A(ntryL,G1H2(470),47,0,G2H2(209),n2h2(609))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(52),-16,0,G2H8(32),n2h8(384))
  call Hloop_AV_Q(ntryL,G2H8(32),ex5(:),G2H4(153),m3h2x4(:,436),heltab2x8(:,:,619))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,15),G1H2(474),m3h4x2(:,184),heltab2x8(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(474),47,0,G2H2(210),n2h2(610))
  call Hloop_QV_A(ntryL,G1H8(246),wf4(:,15),G1H2(475),m3h4x2(:,185),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H2(475),47,0,G2H2(212),n2h2(611))
  call Hloop_QV_A(ntryL,G0H8(29),wf4(:,15),G0H2(1),m3h4x2(:,186),heltab2x8(:,:,622))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(476),n2h2(612))
  call Hloop_QV_A(ntryL,G1H8(79),ex5(:),G1H4(136),m3h2x4(:,437),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H4(136),53,0,G2H4(77),n2h4(389))
call HGT_OLR(G1H8(262),1,1,8)
call HGT_invQ_OLR(G1H8(262),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(262),-10,0,G2H8(33),n2h8(385))
  call Hloop_AV_Q(ntryL,G2H8(33),wf4(:,20),G2H2(213),m3h4x2(:,187),heltab2x8(:,:,624))
  call Hloop_QV_A(ntryL,G1H8(277),ex5(:),G1H4(372),m3h2x4(:,438),heltab2x8(:,:,625))
  call Hloop_Q_A(ntryL,G1H4(372),53,0,G2H4(17),n2h4(390))
  call Hloop_QV_A(ntryL,G1H8(68),ex5(:),G1H4(199),m3h2x4(:,439),heltab2x8(:,:,626))
  call Hloop_Q_A(ntryL,G1H4(199),53,0,G2H4(20),n2h4(391))
  call Hloop_QV_A(ntryL,G0H8(3),ex5(:),G0H4(1),m3h2x4(:,440),heltab2x8(:,:,627))
  call Hloop_Q_A(ntryL,G0H4(1),53,0,G1H4(21),n2h4(392))
  call Hloop_AV_Q(ntryL,G1H8(293),ex5(:),G1H4(362),m3h2x4(:,441),heltab2x8(:,:,628))
  call Hloop_A_Q(ntryL,G1H4(362),53,0,G2H4(26),n2h4(393))
call HGT_OLR(G1H8(69),1,1,8)
call HGT_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(69),-10,0,G2H8(35),n2h8(386))
  call Hloop_QV_A(ntryL,G2H8(35),wf4(:,20),G2H2(215),m3h4x2(:,188),heltab2x8(:,:,629))
  call Hloop_AV_Q(ntryL,G1H8(88),ex5(:),G1H4(352),m3h2x4(:,442),heltab2x8(:,:,630))
  call Hloop_A_Q(ntryL,G1H4(352),53,0,G2H4(29),n2h4(394))
  call Hloop_AV_Q(ntryL,G1H8(66),ex5(:),G1H4(230),m3h2x4(:,443),heltab2x8(:,:,631))
  call Hloop_A_Q(ntryL,G1H4(230),53,0,G2H4(35),n2h4(395))
  call Hloop_AV_Q(ntryL,G0H8(2),ex5(:),G0H4(1),m3h2x4(:,444),heltab2x8(:,:,632))
  call Hloop_A_Q(ntryL,G0H4(1),53,0,G1H4(412),n2h4(396))
  call Hloop_AV_Q(ntryL,G1H8(91),wf4(:,20),G1H2(480),m3h4x2(:,189),heltab2x8(:,:,633))
  call Hloop_A_Q(ntryL,G1H2(480),47,0,G2H2(216),n2h2(613))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-16,0,G2H8(36),n2h8(387))
  call Hloop_QV_A(ntryL,G2H8(36),ex5(:),G2H4(38),m3h2x4(:,445),heltab2x8(:,:,634))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,20),G1H2(481),m3h4x2(:,190),heltab2x8(:,:,635))
  call Hloop_A_Q(ntryL,G1H2(481),47,0,G2H2(218),n2h2(614))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,20),G1H2(482),m3h4x2(:,191),heltab2x8(:,:,636))
  call Hloop_A_Q(ntryL,G1H2(482),47,0,G2H2(219),n2h2(615))
  call Hloop_AV_Q(ntryL,G0H8(24),wf4(:,20),G0H2(1),m3h4x2(:,192),heltab2x8(:,:,637))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(684),n2h2(616))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,20),G1H2(487),m3h4x2(:,193),heltab2x8(:,:,638))
  call Hloop_Q_A(ntryL,G1H2(487),47,0,G2H2(221),n2h2(617))
call HGT_OLR(G1H8(37),1,1,8)
call HGT_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(37),-16,0,G2H8(37),n2h8(388))
  call Hloop_AV_Q(ntryL,G2H8(37),ex5(:),G2H4(46),m3h2x4(:,446),heltab2x8(:,:,639))
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,20),G1H2(488),m3h4x2(:,194),heltab2x8(:,:,640))
  call Hloop_Q_A(ntryL,G1H2(488),47,0,G2H2(222),n2h2(618))
  call Hloop_QV_A(ntryL,G1H8(50),wf4(:,20),G1H2(492),m3h4x2(:,195),heltab2x8(:,:,641))
  call Hloop_Q_A(ntryL,G1H2(492),47,0,G2H2(224),n2h2(619))
  call Hloop_QV_A(ntryL,G0H8(25),wf4(:,20),G0H2(1),m3h4x2(:,196),heltab2x8(:,:,642))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(493),n2h2(620))
  call Hloop_VA_Q(ntryL,G1H8(103),ex4(:),G1H4(406),m3h2x4(:,447),heltab2x8(:,:,643))
  call Hloop_A_Q(ntryL,G1H4(406),46,0,G2H4(47),n2h4(397))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(15),wf4(:,12),G1H2(494),m3h4x2(:,197),heltab2x8(:,:,644))
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(9),m3h2x4(:,448),heltab2x8(:,:,645))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(54),n2h4(398))
  call Hloop_VA_Q(ntryL,G1H8(90),ex4(:),G1H4(421),m3h2x4(:,449),heltab2x8(:,:,646))
  call Hloop_A_Q(ntryL,G1H4(421),46,0,G2H4(55),n2h4(399))
  call Hloop_VA_Q(ntryL,G1H8(95),ex3(:),G1H4(104),m3h2x4(:,450),heltab2x8(:,:,647))
  call Hloop_A_Q(ntryL,G1H4(104),46,0,G2H4(65),n2h4(400))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(25),wf4(:,12),G1H2(498),m3h4x2(:,198),heltab2x8(:,:,648))
  call Hloop_VA_Q(ntryL,G1H8(27),ex3(:),G1H4(427),m3h2x4(:,451),heltab2x8(:,:,649))
  call Hloop_A_Q(ntryL,G1H4(427),46,0,G2H4(137),n2h4(401))
  call Hloop_VA_Q(ntryL,G1H8(31),ex3(:),G1H4(413),m3h2x4(:,452),heltab2x8(:,:,650))
  call Hloop_A_Q(ntryL,G1H4(413),46,0,G2H4(140),n2h4(402))
  call Hloop_VQ_A(ntryL,G1H8(34),wf4(:,12),G1H2(499),m3h4x2(:,199),heltab2x8(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(499),55,0,G2H2(225),n2h2(621))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex4(:),G1H4(398),m3h2x4(:,453),heltab2x8(:,:,652))
  call Hloop_VQ_A(ntryL,G1H8(29),wf4(:,12),G1H2(500),m3h4x2(:,200),heltab2x8(:,:,653))
  call Hloop_Q_A(ntryL,G1H2(500),55,0,G2H2(227),n2h2(622))
  call Hloop_VQ_A(ntryL,G1H8(42),wf4(:,12),G1H2(504),m3h4x2(:,201),heltab2x8(:,:,654))
  call Hloop_Q_A(ntryL,G1H2(504),55,0,G2H2(228),n2h2(623))
  call Hloop_VA_Q(ntryL,G1H8(43),ex4(:),G1H4(145),m3h2x4(:,454),heltab2x8(:,:,655))
  call Hloop_A_Q(ntryL,G1H4(145),45,0,G2H4(135),n2h4(403))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(11),wf4(:,4),G1H2(505),m3h4x2(:,202),heltab2x8(:,:,656))
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(152),m3h2x4(:,455),heltab2x8(:,:,657))
  call Hloop_A_Q(ntryL,G1H4(152),45,0,G2H4(120),n2h4(404))
  call Hloop_VA_Q(ntryL,G1H8(48),ex4(:),G1H4(397),m3h2x4(:,456),heltab2x8(:,:,658))
  call Hloop_A_Q(ntryL,G1H4(397),45,0,G2H4(116),n2h4(405))
  call Hloop_VA_Q(ntryL,G1H8(30),ex3(:),G1H4(295),m3h2x4(:,457),heltab2x8(:,:,659))
  call Hloop_A_Q(ntryL,G1H4(295),45,0,G2H4(70),n2h4(406))
call HGT_raise_alpha_OLR(G1H8(35),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(35),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(35),wf4(:,4),G1H2(506),m3h4x2(:,203),heltab2x8(:,:,660))
  call Hloop_VA_Q(ntryL,G1H8(47),ex3(:),G1H4(158),m3h2x4(:,458),heltab2x8(:,:,661))
  call Hloop_A_Q(ntryL,G1H4(158),45,0,G2H4(72),n2h4(407))
  call Hloop_VA_Q(ntryL,G1H8(107),ex3(:),G1H4(135),m3h2x4(:,459),heltab2x8(:,:,662))
  call Hloop_A_Q(ntryL,G1H4(135),45,0,G2H4(131),n2h4(408))
  call Hloop_VQ_A(ntryL,G1H8(99),wf4(:,4),G1H2(510),m3h4x2(:,204),heltab2x8(:,:,663))
  call Hloop_Q_A(ntryL,G1H2(510),55,0,G2H2(230),n2h2(624))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(100),ex4(:),G1H4(177),m3h2x4(:,460),heltab2x8(:,:,664))
  call Hloop_VQ_A(ntryL,G1H8(114),wf4(:,4),G1H2(511),m3h4x2(:,205),heltab2x8(:,:,665))
  call Hloop_Q_A(ntryL,G1H2(511),55,0,G2H2(231),n2h2(625))
  call Hloop_VQ_A(ntryL,G1H8(115),wf4(:,4),G1H2(512),m3h4x2(:,206),heltab2x8(:,:,666))
  call Hloop_Q_A(ntryL,G1H2(512),55,0,G2H2(233),n2h2(626))
  call Hloop_VQ_A(ntryL,G1H8(116),ex2(:),G1H4(2),m3h2x4(:,461),heltab2x8(:,:,667))
  call Hloop_Q_A(ntryL,G1H4(2),43,0,G2H4(146),n2h4(409))
call HGT_raise_alpha_OLR(G1H8(119),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(119),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(119),wf4(:,19),G1H2(516),m3h4x2(:,207),heltab2x8(:,:,668))
  call Hloop_VQ_A(ntryL,G1H8(121),ex2(:),G1H4(208),m3h2x4(:,462),heltab2x8(:,:,669))
  call Hloop_Q_A(ntryL,G1H4(208),43,0,G2H4(132),n2h4(410))
  call Hloop_VQ_A(ntryL,G1H8(122),ex2(:),G1H4(178),m3h2x4(:,463),heltab2x8(:,:,670))
  call Hloop_Q_A(ntryL,G1H4(178),43,0,G2H4(142),n2h4(411))
  call Hloop_VQ_A(ntryL,G1H8(125),ex1(:),G1H4(190),m3h2x4(:,464),heltab2x8(:,:,671))
  call Hloop_Q_A(ntryL,G1H4(190),43,0,G2H4(124),n2h4(412))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(104),wf4(:,19),G1H2(517),m3h4x2(:,208),heltab2x8(:,:,672))
  call Hloop_VQ_A(ntryL,G1H8(131),ex1(:),G1H4(70),m3h2x4(:,465),heltab2x8(:,:,673))
  call Hloop_Q_A(ntryL,G1H4(70),43,0,G2H4(125),n2h4(413))
  call Hloop_VQ_A(ntryL,G1H8(132),ex1(:),G1H4(237),m3h2x4(:,466),heltab2x8(:,:,674))
  call Hloop_Q_A(ntryL,G1H4(237),43,0,G2H4(129),n2h4(414))
  call Hloop_VQ_A(ntryL,G1H8(63),ex2(:),G1H4(195),m3h2x4(:,467),heltab2x8(:,:,675))
  call Hloop_Q_A(ntryL,G1H4(195),39,0,G2H4(130),n2h4(415))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(36),wf4(:,9),G1H2(518),m3h4x2(:,209),heltab2x8(:,:,676))
  call Hloop_VQ_A(ntryL,G1H8(140),ex2(:),G1H4(207),m3h2x4(:,468),heltab2x8(:,:,677))
  call Hloop_Q_A(ntryL,G1H4(207),39,0,G2H4(133),n2h4(416))
  call Hloop_VQ_A(ntryL,G1H8(53),ex2(:),G1H4(220),m3h2x4(:,469),heltab2x8(:,:,678))
  call Hloop_Q_A(ntryL,G1H4(220),39,0,G2H4(138),n2h4(417))
  call Hloop_VQ_A(ntryL,G1H8(54),ex1(:),G1H4(224),m3h2x4(:,470),heltab2x8(:,:,679))
  call Hloop_Q_A(ntryL,G1H4(224),39,0,G2H4(143),n2h4(418))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(76),wf4(:,9),G1H2(689),m3h4x2(:,210),heltab2x8(:,:,680))
  call Hloop_VQ_A(ntryL,G1H8(16),ex1(:),G1H4(236),m3h2x4(:,471),heltab2x8(:,:,681))
  call Hloop_Q_A(ntryL,G1H4(236),39,0,G2H4(144),n2h4(419))
  call Hloop_VQ_A(ntryL,G1H8(20),ex1(:),G1H4(249),m3h2x4(:,472),heltab2x8(:,:,682))
  call Hloop_Q_A(ntryL,G1H4(249),39,0,G2H4(152),n2h4(420))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,1),G1H2(523),m3h4x2(:,211),heltab2x8(:,:,683))
  call Hloop_Q_A(ntryL,G1H2(523),55,0,G2H2(234),n2h2(627))
call HGT_raise_alpha_OLR(G1H8(71),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(71),ex4(:),G1H4(250),m3h2x4(:,473),heltab2x8(:,:,684))
  call Hloop_QV_A(ntryL,G1H8(89),wf4(:,1),G1H2(524),m3h4x2(:,212),heltab2x8(:,:,685))
  call Hloop_Q_A(ntryL,G1H2(524),55,0,G2H2(236),n2h2(628))
  call Hloop_QV_A(ntryL,G1H8(109),wf4(:,1),G1H2(528),m3h4x2(:,213),heltab2x8(:,:,686))
  call Hloop_Q_A(ntryL,G1H2(528),55,0,G2H2(240),n2h2(629))
  call Hloop_QV_A(ntryL,G1H8(244),wf4(:,11),G1H2(529),m3h4x2(:,214),heltab2x8(:,:,687))
  call Hloop_Q_A(ntryL,G1H2(529),55,0,G2H2(244),n2h2(630))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(40),ex4(:),G1H4(262),m3h2x4(:,474),heltab2x8(:,:,688))
  call Hloop_QV_A(ntryL,G1H8(127),wf4(:,11),G1H2(530),m3h4x2(:,215),heltab2x8(:,:,689))
  call Hloop_Q_A(ntryL,G1H2(530),55,0,G2H2(248),n2h2(631))
  call Hloop_QV_A(ntryL,G1H8(260),wf4(:,11),G1H2(694),m3h4x2(:,216),heltab2x8(:,:,690))
  call Hloop_Q_A(ntryL,G1H2(694),55,0,G2H2(252),n2h2(632))
  call Hloop_QV_A(ntryL,G1H8(85),wf4(:,15),G1H2(535),m3h4x2(:,217),heltab2x8(:,:,691))
  call Hloop_Q_A(ntryL,G1H2(535),59,0,G2H2(256),n2h2(633))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(128),ex3(:),G1H4(267),m3h2x4(:,475),heltab2x8(:,:,692))
  call Hloop_QV_A(ntryL,G1H8(137),wf4(:,15),G1H2(536),m3h4x2(:,218),heltab2x8(:,:,693))
  call Hloop_Q_A(ntryL,G1H2(536),59,0,G2H2(260),n2h2(634))
  call Hloop_QV_A(ntryL,G1H8(276),wf4(:,15),G1H2(540),m3h4x2(:,219),heltab2x8(:,:,694))
  call Hloop_Q_A(ntryL,G1H2(540),59,0,G2H2(264),n2h2(635))
  call Hloop_QV_A(ntryL,G1H8(45),wf4(:,20),G1H2(541),m3h4x2(:,220),heltab2x8(:,:,695))
  call Hloop_Q_A(ntryL,G1H2(541),59,0,G2H2(268),n2h2(636))
call HGT_raise_alpha_OLR(G1H8(138),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(138),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(138),ex3(:),G1H4(279),m3h2x4(:,476),heltab2x8(:,:,696))
  call Hloop_QV_A(ntryL,G1H8(145),wf4(:,20),G1H2(542),m3h4x2(:,221),heltab2x8(:,:,697))
  call Hloop_Q_A(ntryL,G1H2(542),59,0,G2H2(272),n2h2(637))
  call Hloop_QV_A(ntryL,G1H8(292),wf4(:,20),G1H2(699),m3h4x2(:,222),heltab2x8(:,:,698))
  call Hloop_Q_A(ntryL,G1H2(699),59,0,G2H2(276),n2h2(638))
  call Hloop_AV_Q(ntryL,G1H16(103),wf4(:,1),G1H4(280),m3h4x4(:,79),heltab2x16(:,:,421))
  call Hloop_A_Q(ntryL,G1H4(280),45,0,G2H4(149),n2h4(421))
call HGT_raise_alpha_OLR(G1H16(109),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(109),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(109),wf4(:,4),G1H4(242),m3h4x4(:,80),heltab2x16(:,:,422))
  call Hloop_AV_Q(ntryL,G1H16(57),wf4(:,1),G1H4(292),m3h4x4(:,81),heltab2x16(:,:,423))
  call Hloop_A_Q(ntryL,G1H4(292),45,0,G2H4(150),n2h4(422))
  call Hloop_AV_Q(ntryL,G1H16(59),wf4(:,1),G1H4(170),m3h4x4(:,82),heltab2x16(:,:,424))
  call Hloop_A_Q(ntryL,G1H4(170),45,0,G2H4(123),n2h4(423))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,1),G1H4(363),m3h4x4(:,83),heltab2x16(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(363),39,0,G2H4(126),n2h4(424))
call HGT_raise_alpha_OLR(G1H16(63),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(63),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(63),wf4(:,9),G1H4(33),m3h4x4(:,84),heltab2x16(:,:,426))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(373),m3h4x4(:,85),heltab2x16(:,:,427))
  call Hloop_Q_A(ntryL,G1H4(373),39,0,G2H4(127),n2h4(425))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,1),G1H4(86),m3h4x4(:,86),heltab2x16(:,:,428))
  call Hloop_Q_A(ntryL,G1H4(86),39,0,G2H4(128),n2h4(426))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(102),m3h2x8(:,327),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G1H8(102),50,0,G2H8(39),n2h8(403))
call HGT_raise_alpha_OLR(G1H16(66),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(66),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(66),wf8(:,3),G1H2(547),m3h8x2(:,17),heltab2x16(:,:,430))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(32),m3h2x8(:,328),heltab2x16(:,:,431))
  call Hloop_Q_A(ntryL,G1H8(32),50,0,G2H8(40),n2h8(404))
  call Hloop_QV_A(ntryL,G1H16(69),ex5(:),G1H8(33),m3h2x8(:,329),heltab2x16(:,:,432))
  call Hloop_Q_A(ntryL,G1H8(33),50,0,G2H8(41),n2h8(405))
  call Hloop_AV_Q(ntryL,G1H16(70),wf4(:,11),G1H4(383),m3h4x4(:,87),heltab2x16(:,:,433))
  call Hloop_A_Q(ntryL,G1H4(383),46,0,G2H4(118),n2h4(427))
call HGT_raise_alpha_OLR(G1H16(72),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(72),wf4(:,12),G1H4(118),m3h4x4(:,88),heltab2x16(:,:,434))
  call Hloop_AV_Q(ntryL,G1H16(77),wf4(:,11),G1H4(389),m3h4x4(:,89),heltab2x16(:,:,435))
  call Hloop_A_Q(ntryL,G1H4(389),46,0,G2H4(122),n2h4(428))
  call Hloop_AV_Q(ntryL,G1H16(80),wf4(:,11),G1H4(123),m3h4x4(:,90),heltab2x16(:,:,436))
  call Hloop_A_Q(ntryL,G1H4(123),46,0,G2H4(155),n2h4(429))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,11),G1H4(392),m3h4x4(:,91),heltab2x16(:,:,437))
  call Hloop_Q_A(ntryL,G1H4(392),39,0,G2H4(156),n2h4(430))
call HGT_raise_alpha_OLR(G1H16(22),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(22),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(22),wf4(:,9),G1H4(148),m3h4x4(:,92),heltab2x16(:,:,438))
  call Hloop_QV_A(ntryL,G1H16(39),wf4(:,11),G1H4(382),m3h4x4(:,93),heltab2x16(:,:,439))
  call Hloop_Q_A(ntryL,G1H4(382),39,0,G2H4(157),n2h4(431))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,11),G1H4(164),m3h4x4(:,94),heltab2x16(:,:,440))
  call Hloop_Q_A(ntryL,G1H4(164),39,0,G2H4(158),n2h4(432))
  call Hloop_QV_A(ntryL,G1H16(32),ex5(:),G1H8(57),m3h2x8(:,330),heltab2x16(:,:,441))
  call Hloop_Q_A(ntryL,G1H8(57),49,0,G2H8(43),n2h8(406))
call HGT_raise_alpha_OLR(G1H16(35),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(35),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(35),wf8(:,16),G1H2(548),m3h8x2(:,18),heltab2x16(:,:,442))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(18),m3h2x8(:,331),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H8(18),49,0,G2H8(44),n2h8(407))
  call Hloop_QV_A(ntryL,G1H16(48),ex5(:),G1H8(112),m3h2x8(:,332),heltab2x16(:,:,444))
  call Hloop_Q_A(ntryL,G1H8(112),49,0,G2H8(45),n2h8(408))
  call Hloop_AV_Q(ntryL,G1H16(84),wf4(:,15),G1H4(407),m3h4x4(:,95),heltab2x16(:,:,445))
  call Hloop_A_Q(ntryL,G1H4(407),45,0,G2H4(159),n2h4(433))
call HGT_raise_alpha_OLR(G1H16(87),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(87),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(87),wf4(:,4),G1H4(133),m3h4x4(:,96),heltab2x16(:,:,446))
  call Hloop_AV_Q(ntryL,G1H16(92),wf4(:,15),G1H4(291),m3h4x4(:,97),heltab2x16(:,:,447))
  call Hloop_A_Q(ntryL,G1H4(291),45,0,G2H4(160),n2h4(434))
  call Hloop_AV_Q(ntryL,G1H16(94),wf4(:,15),G1H4(102),m3h4x4(:,98),heltab2x16(:,:,448))
  call Hloop_A_Q(ntryL,G1H4(102),45,0,G2H4(161),n2h4(435))
  call Hloop_QV_A(ntryL,G1H16(95),wf4(:,15),G1H4(55),m3h4x4(:,99),heltab2x16(:,:,449))
  call Hloop_Q_A(ntryL,G1H4(55),43,0,G2H4(162),n2h4(436))
call HGT_raise_alpha_OLR(G1H16(2),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(2),wf4(:,19),G1H4(241),m3h4x4(:,100),heltab2x16(:,:,450))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,15),G1H4(80),m3h4x4(:,101),heltab2x16(:,:,451))
  call Hloop_Q_A(ntryL,G1H4(80),43,0,G2H4(163),n2h4(437))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,15),G1H4(215),m3h4x4(:,102),heltab2x16(:,:,452))
  call Hloop_Q_A(ntryL,G1H4(215),43,0,G2H4(164),n2h4(438))
  call Hloop_AV_Q(ntryL,G1H16(9),ex5(:),G1H8(24),m3h2x8(:,333),heltab2x16(:,:,453))
  call Hloop_A_Q(ntryL,G1H8(24),52,0,G2H8(28),n2h8(409))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(8),wf8(:,27),G1H2(552),m3h8x2(:,19),heltab2x16(:,:,454))
  call Hloop_AV_Q(ntryL,G1H16(98),ex5(:),G1H8(105),m3h2x8(:,334),heltab2x16(:,:,455))
  call Hloop_A_Q(ntryL,G1H8(105),52,0,G2H8(68),n2h8(410))
  call Hloop_AV_Q(ntryL,G1H16(41),ex5(:),G1H8(130),m3h2x8(:,335),heltab2x16(:,:,456))
  call Hloop_A_Q(ntryL,G1H8(130),52,0,G2H8(72),n2h8(411))
  call Hloop_QV_A(ntryL,G1H16(44),ex5(:),G1H8(106),m3h2x8(:,336),heltab2x16(:,:,457))
  call Hloop_Q_A(ntryL,G1H8(106),50,0,G2H8(76),n2h8(412))
call HGT_raise_alpha_OLR(G1H16(100),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(100),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(100),wf8(:,22),G1H2(553),m3h8x2(:,20),heltab2x16(:,:,458))
  call Hloop_QV_A(ntryL,G1H16(105),ex5(:),G1H8(111),m3h2x8(:,337),heltab2x16(:,:,459))
  call Hloop_Q_A(ntryL,G1H8(111),50,0,G2H8(80),n2h8(413))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(117),m3h2x8(:,338),heltab2x16(:,:,460))
  call Hloop_Q_A(ntryL,G1H8(117),50,0,G2H8(84),n2h8(414))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,20),G1H4(286),m3h4x4(:,103),heltab2x16(:,:,461))
  call Hloop_A_Q(ntryL,G1H4(286),46,0,G2H4(165),n2h4(439))
call HGT_raise_alpha_OLR(G1H16(17),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(17),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(17),wf4(:,12),G1H4(204),m3h4x4(:,104),heltab2x16(:,:,462))
  call Hloop_AV_Q(ntryL,G1H16(50),wf4(:,20),G1H4(78),m3h4x4(:,105),heltab2x16(:,:,463))
  call Hloop_A_Q(ntryL,G1H4(78),46,0,G2H4(166),n2h4(440))
  call Hloop_AV_Q(ntryL,G1H16(107),wf4(:,20),G1H4(31),m3h4x4(:,106),heltab2x16(:,:,464))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(167),n2h4(441))
  call Hloop_QV_A(ntryL,G1H16(110),wf4(:,20),G1H4(203),m3h4x4(:,107),heltab2x16(:,:,465))
  call Hloop_Q_A(ntryL,G1H4(203),43,0,G2H4(168),n2h4(442))
call HGT_raise_alpha_OLR(G1H16(112),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(112),wf4(:,19),G1H4(88),m3h4x4(:,108),heltab2x16(:,:,466))
  call Hloop_QV_A(ntryL,G1H16(116),wf4(:,20),G1H4(95),m3h4x4(:,109),heltab2x16(:,:,467))
  call Hloop_Q_A(ntryL,G1H4(95),43,0,G2H4(169),n2h4(443))
  call Hloop_QV_A(ntryL,G1H16(65),wf4(:,20),G1H4(15),m3h4x4(:,110),heltab2x16(:,:,468))
  call Hloop_Q_A(ntryL,G1H4(15),43,0,G2H4(170),n2h4(444))
  call Hloop_AV_Q(ntryL,G1H16(51),ex5(:),G1H8(124),m3h2x8(:,339),heltab2x16(:,:,469))
  call Hloop_A_Q(ntryL,G1H8(124),52,0,G2H8(88),n2h8(415))
call HGT_raise_alpha_OLR(G1H16(52),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(52),wf8(:,35),G1H2(554),m3h8x2(:,21),heltab2x16(:,:,470))
  call Hloop_AV_Q(ntryL,G1H16(54),ex5(:),G1H8(118),m3h2x8(:,340),heltab2x16(:,:,471))
  call Hloop_A_Q(ntryL,G1H8(118),52,0,G2H8(92),n2h8(416))
  call Hloop_AV_Q(ntryL,G1H16(55),ex5(:),G1H8(123),m3h2x8(:,341),heltab2x16(:,:,472))
  call Hloop_A_Q(ntryL,G1H8(123),52,0,G2H8(96),n2h8(417))
  call Hloop_QV_A(ntryL,G1H16(1),ex5(:),G1H8(129),m3h2x8(:,342),heltab2x16(:,:,473))
  call Hloop_Q_A(ntryL,G1H8(129),49,0,G2H8(100),n2h8(418))
call HGT_raise_alpha_OLR(G1H16(15),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(15),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(15),wf8(:,33),G1H2(704),m3h8x2(:,22),heltab2x16(:,:,474))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(141),m3h2x8(:,343),heltab2x16(:,:,475))
  call Hloop_Q_A(ntryL,G1H8(141),49,0,G2H8(60),n2h8(419))
  call Hloop_QV_A(ntryL,G1H16(91),ex5(:),G1H8(154),m3h2x8(:,344),heltab2x16(:,:,476))
  call Hloop_Q_A(ntryL,G1H8(154),49,0,G2H8(61),n2h8(420))
  call Hloop_QV_A(ntryL,G1H16(43),wf8(:,30),G1H2(559),m3h8x2(:,23),heltab2x16(:,:,477))
  call Hloop_Q_A(ntryL,G1H2(559),55,0,G2H2(280),n2h2(639))
call HGT_raise_alpha_OLR(G1H16(56),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(56),ex4(:),G1H8(142),m3h2x8(:,345),heltab2x16(:,:,478))
  call Hloop_QV_A(ntryL,G1H16(60),wf8(:,30),G1H2(560),m3h8x2(:,24),heltab2x16(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(560),55,0,G2H2(284),n2h2(640))
  call Hloop_QV_A(ntryL,G1H16(62),wf8(:,30),G1H2(564),m3h8x2(:,25),heltab2x16(:,:,480))
  call Hloop_Q_A(ntryL,G1H2(564),55,0,G2H2(288),n2h2(641))
  call Hloop_QV_A(ntryL,G1H16(25),wf8(:,12),G1H2(565),m3h8x2(:,26),heltab2x16(:,:,481))
  call Hloop_Q_A(ntryL,G1H2(565),59,0,G2H2(292),n2h2(642))
call HGT_raise_alpha_OLR(G1H16(3),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(3),ex3(:),G1H8(147),m3h2x8(:,346),heltab2x16(:,:,482))
  call Hloop_QV_A(ntryL,G1H16(5),wf8(:,12),G1H2(566),m3h8x2(:,27),heltab2x16(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(566),59,0,G2H2(296),n2h2(643))
  call Hloop_QV_A(ntryL,G1H16(30),wf8(:,12),G1H2(709),m3h8x2(:,28),heltab2x16(:,:,484))
  call Hloop_Q_A(ntryL,G1H2(709),59,0,G2H2(300),n2h2(644))
  call Hloop_QV_A(ntryL,G1H16(11),wf8(:,23),G1H2(571),m3h8x2(:,29),heltab2x16(:,:,485))
  call Hloop_Q_A(ntryL,G1H2(571),55,0,G2H2(301),n2h2(645))
call HGT_raise_alpha_OLR(G1H16(64),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(64),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(64),ex4(:),G1H8(172),m3h2x8(:,347),heltab2x16(:,:,486))
  call Hloop_QV_A(ntryL,G1H16(13),wf8(:,23),G1H2(572),m3h8x2(:,30),heltab2x16(:,:,487))
  call Hloop_Q_A(ntryL,G1H2(572),55,0,G2H2(303),n2h2(646))
  call Hloop_QV_A(ntryL,G1H16(31),wf8(:,23),G1H2(576),m3h8x2(:,31),heltab2x16(:,:,488))
  call Hloop_Q_A(ntryL,G1H2(576),55,0,G2H2(304),n2h2(647))
  call Hloop_QV_A(ntryL,G1H16(71),wf8(:,4),G1H2(577),m3h8x2(:,32),heltab2x16(:,:,489))
  call Hloop_Q_A(ntryL,G1H2(577),59,0,G2H2(306),n2h2(648))
call HGT_raise_alpha_OLR(G1H16(74),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(74),ex3(:),G1H8(148),m3h2x8(:,348),heltab2x16(:,:,490))
  call Hloop_QV_A(ntryL,G1H16(18),wf8(:,4),G1H2(578),m3h8x2(:,33),heltab2x16(:,:,491))
  call Hloop_Q_A(ntryL,G1H2(578),59,0,G2H2(307),n2h2(649))
  call Hloop_QV_A(ntryL,G1H16(79),wf8(:,4),G1H2(714),m3h8x2(:,34),heltab2x16(:,:,492))
  call Hloop_Q_A(ntryL,G1H2(714),59,0,G2H2(309),n2h2(650))
  call Hloop_QV_A(ntryL,G1H16(81),wf8(:,36),G1H2(583),m3h8x2(:,35),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G1H2(583),55,0,G2H2(310),n2h2(651))
call HGT_raise_alpha_OLR(G1H16(24),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(24),ex4(:),G1H8(153),m3h2x8(:,349),heltab2x16(:,:,494))
  call Hloop_QV_A(ntryL,G1H16(83),wf8(:,36),G1H2(584),m3h8x2(:,36),heltab2x16(:,:,495))
  call Hloop_Q_A(ntryL,G1H2(584),55,0,G2H2(312),n2h2(652))
  call Hloop_QV_A(ntryL,G1H16(86),wf8(:,36),G1H2(588),m3h8x2(:,37),heltab2x16(:,:,496))
  call Hloop_Q_A(ntryL,G1H2(588),55,0,G2H2(313),n2h2(653))
  call Hloop_QV_A(ntryL,G1H16(88),wf8(:,28),G1H2(589),m3h8x2(:,38),heltab2x16(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(589),55,0,G2H2(315),n2h2(654))
call HGT_raise_alpha_OLR(G1H16(90),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(90),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(90),ex4(:),G1H8(159),m3h2x8(:,350),heltab2x16(:,:,498))
  call Hloop_QV_A(ntryL,G1H16(38),wf8(:,28),G1H2(590),m3h8x2(:,39),heltab2x16(:,:,499))
  call Hloop_Q_A(ntryL,G1H2(590),55,0,G2H2(316),n2h2(655))
  call Hloop_QV_A(ntryL,G1H16(97),wf8(:,28),G1H2(719),m3h8x2(:,40),heltab2x16(:,:,500))
  call Hloop_Q_A(ntryL,G1H2(719),55,0,G2H2(318),n2h2(656))
  call Hloop_QV_A(ntryL,G1H16(99),wf8(:,19),G1H2(595),m3h8x2(:,41),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G1H2(595),59,0,G2H2(319),n2h2(657))
call HGT_raise_alpha_OLR(G1H16(42),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(42),ex3(:),G1H8(166),m3h2x8(:,351),heltab2x16(:,:,502))
  call Hloop_QV_A(ntryL,G1H16(101),wf8(:,19),G1H2(596),m3h8x2(:,42),heltab2x16(:,:,503))
  call Hloop_Q_A(ntryL,G1H2(596),59,0,G2H2(321),n2h2(658))
  call Hloop_QV_A(ntryL,G1H16(104),wf8(:,19),G1H2(600),m3h8x2(:,43),heltab2x16(:,:,504))
  call Hloop_Q_A(ntryL,G1H2(600),59,0,G2H2(322),n2h2(659))
  call Hloop_QV_A(ntryL,G1H16(106),wf8(:,9),G1H2(601),m3h8x2(:,44),heltab2x16(:,:,505))
  call Hloop_Q_A(ntryL,G1H2(601),59,0,G2H2(324),n2h2(660))
call HGT_raise_alpha_OLR(G1H16(108),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(108),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(108),ex3(:),G1H8(160),m3h2x8(:,352),heltab2x16(:,:,506))
  call Hloop_QV_A(ntryL,G1H16(6),wf8(:,9),G1H2(602),m3h8x2(:,45),heltab2x16(:,:,507))
  call Hloop_Q_A(ntryL,G1H2(602),59,0,G2H2(325),n2h2(661))
  call Hloop_QV_A(ntryL,G1H16(115),wf8(:,9),G1H2(724),m3h8x2(:,46),heltab2x16(:,:,508))
  call Hloop_Q_A(ntryL,G1H2(724),59,0,G2H2(327),n2h2(662))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(308),[G2H2(302),G2H2(86),G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(311),[G2H2(305),G2H2(89),G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(434),[G2H2(425),G2H2(196),G2H2(175),G2H2(172),G2H2(126) &
    ,G2H2(92),G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G2H2(314),G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(317),G2H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(310),[G2H2(280),G2H2(448),G2H2(422),G2H2(211),G2H2(178) &
    ,G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(256),[G2H2(320),G2H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(323),G2H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(319),[G2H2(292),G2H2(460),G2H2(428),G2H2(229),G2H2(181) &
    ,G2H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(326),G2H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(329),G2H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(315),[G2H2(301),G2H2(454),G2H2(431),G2H2(217),G2H2(184) &
    ,G2H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(268),[G2H2(332),G2H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(335),G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(324),[G2H2(306),G2H2(466),G2H2(437),G2H2(235),G2H2(187) &
    ,G2H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(344),[G2H2(338),G2H2(122),G2H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(347),[G2H2(341),G2H2(123),G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(443),[G2H2(440),G2H2(223),G2H2(193),G2H2(190),G2H2(132) &
    ,G2H2(124),G2H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(418),[G2H2(208),G2H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(402),[G2H2(202),G2H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(358),G2H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(362),G2H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(366),G2H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(415),[G2H2(369),G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(372),G2H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(407),[G2H2(375),G2H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(379),G2H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(392),[G2H2(382),G2H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(386),G2H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(395),[G2H2(389),G2H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(435),[G2H2(166),G1H2(467),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(426),[G2H2(169),G1H2(485),G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(64),G1H4(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(114),G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(82),G1H4(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(89),G1H4(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(15),G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(105),G1H4(361)])
call HGT_w2_OLR(G1H2(64),1,1,2)
call HGT_w2_invQ_OLR(G1H2(64),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(315)])
call HGT_w2_OLR(G1H2(76),1,1,2)
call HGT_w2_invQ_OLR(G1H2(76),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(320)])
call HGT_w2_OLR(G1H2(88),1,1,2)
call HGT_w2_invQ_OLR(G1H2(88),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(325)])
call HGT_w2_OLR(G1H2(100),1,1,2)
call HGT_w2_invQ_OLR(G1H2(100),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(287),[G1H2(335)])
call HGT_w2_OLR(G1H2(112),1,1,2)
call HGT_w2_invQ_OLR(G1H2(112),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(300),[G1H2(340)])
call HGT_w2_OLR(G1H2(124),1,1,2)
call HGT_w2_invQ_OLR(G1H2(124),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(794),[G1H2(345),G1H2(80)])
call HGT_w2_OLR(G1H2(136),1,1,2)
call HGT_w2_invQ_OLR(G1H2(136),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(794)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(799),[G1H2(350),G1H2(44)])
call HGT_w2_OLR(G1H2(148),1,1,2)
call HGT_w2_invQ_OLR(G1H2(148),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(799)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(360),[G1H2(355),G1H2(43)])
call HGT_w2_OLR(G1H2(160),1,1,2)
call HGT_w2_invQ_OLR(G1H2(160),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(160),[G1H2(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(573),[G1H2(561),G1H2(358)])
call HGT_w2_OLR(G1H2(40),1,1,2)
call HGT_w2_invQ_OLR(G1H2(40),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(537),[G1H2(513),G1H2(353)])
call HGT_w2_OLR(G1H2(69),1,1,2)
call HGT_w2_invQ_OLR(G1H2(69),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(365),G1H2(271)])
call HGT_w2_OLR(G1H2(82),1,1,2)
call HGT_w2_invQ_OLR(G1H2(82),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(82)])
call ol_merge_last(G1H2(99), G1H2(99)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(391),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G1H2(657),G1H2(651)])
call HGT_OLR(G2H2(391),1,1,2)
call HGT_invQ_OLR(G2H2(391),2,5,2)
call HGT_OLR(G2H2(391),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(391),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(370),G1H2(223)])
call HGT_w2_OLR(G1H2(117),1,1,2)
call HGT_w2_invQ_OLR(G1H2(117),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(117)])
call ol_merge_last(G1H2(130), G1H2(130)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(414),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G1H2(639),G1H2(633)])
call HGT_OLR(G2H2(414),1,1,2)
call HGT_invQ_OLR(G2H2(414),2,5,2)
call HGT_OLR(G2H2(414),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(414),[G2H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(390),[G1H2(375),G1H2(72)])
call HGT_w2_OLR(G1H2(147),1,1,2)
call HGT_w2_invQ_OLR(G1H2(147),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(147),[G1H2(390)])
call ol_merge_last(G1H2(165), G1H2(165)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(406),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G1H2(675),G1H2(669)])
call HGT_OLR(G2H2(406),1,1,2)
call HGT_invQ_OLR(G2H2(406),2,5,2)
call HGT_OLR(G2H2(406),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(406),[G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(380),G1H2(295)])
call HGT_w2_OLR(G1H2(34),1,1,2)
call HGT_w2_invQ_OLR(G1H2(34),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(34)])
call ol_merge_last(G1H2(51), G1H2(51)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(398),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G1H2(621),G1H2(615)])
call HGT_OLR(G2H2(398),1,1,2)
call HGT_invQ_OLR(G2H2(398),2,5,2)
call HGT_OLR(G2H2(398),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(398),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(439),[G2H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(385),G1H2(247)])
call HGT_w2_OLR(G1H2(70),1,1,2)
call HGT_w2_invQ_OLR(G1H2(70),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(36)])
call HGT_OLR(G2H2(238),1,1,2)
call HGT_invQ_OLR(G2H2(238),2,5,2)
call HGT_OLR(G2H2(238),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(3),G2H2(403),G2H2(396),G2H2(255),G2H2(239) &
    ,G1H2(569),G1H2(521),G1H2(273),G1H2(225),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(231),[G1H2(65)])
call HGT_OLR(G2H2(242),1,1,2)
call HGT_invQ_OLR(G2H2(242),2,5,2)
call HGT_OLR(G2H2(242),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(424),G2H2(408),G2H2(393),G2H2(251),G2H2(243) &
    ,G1H2(557),G1H2(533),G1H2(261),G1H2(237),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(85)])
call HGT_OLR(G2H2(246),1,1,2)
call HGT_invQ_OLR(G2H2(246),2,5,2)
call HGT_OLR(G2H2(246),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(423),G2H2(419),G2H2(411),G2H2(259),G2H2(247) &
    ,G1H2(581),G1H2(545),G1H2(297),G1H2(249),G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(114)])
call HGT_OLR(G2H2(250),1,1,2)
call HGT_invQ_OLR(G2H2(250),2,5,2)
call HGT_OLR(G2H2(250),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(250),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(115)])
call HGT_OLR(G2H2(254),1,1,2)
call HGT_invQ_OLR(G2H2(254),2,5,2)
call HGT_OLR(G2H2(254),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(291),[G1H2(127)])
call HGT_OLR(G2H2(258),1,1,2)
call HGT_invQ_OLR(G2H2(258),2,5,2)
call HGT_OLR(G2H2(258),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(150)])
call HGT_OLR(G2H2(262),1,1,2)
call HGT_invQ_OLR(G2H2(262),2,5,2)
call HGT_OLR(G2H2(262),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(262),[G1H2(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(432),[G2H2(421),G2H2(416),G2H2(400),G2H2(267),G2H2(263) &
    ,G1H2(605),G1H2(593),G1H2(309),G1H2(285),G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(213)])
call HGT_OLR(G2H2(266),1,1,2)
call HGT_invQ_OLR(G2H2(266),2,5,2)
call HGT_OLR(G2H2(266),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(266),[G1H2(303)])
call HGT_OLR(G2H2(270),1,1,2)
call HGT_invQ_OLR(G2H2(270),2,5,2)
call HGT_OLR(G2H2(270),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(270),[G1H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(271),G1H2(611),G1H2(224)])
call HGT_OLR(G2H2(274),1,1,2)
call HGT_invQ_OLR(G2H2(274),2,5,2)
call HGT_OLR(G2H2(274),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G2H2(275),G1H2(623),G1H2(236)])
call HGT_OLR(G2H2(278),1,1,2)
call HGT_invQ_OLR(G2H2(278),2,5,2)
call HGT_OLR(G2H2(278),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(278),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G2H2(279),G1H2(629),G1H2(248)])
call HGT_OLR(G2H2(282),1,1,2)
call HGT_invQ_OLR(G2H2(282),2,5,2)
call HGT_OLR(G2H2(282),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(283),G1H2(641),G1H2(260)])
call HGT_OLR(G2H2(286),1,1,2)
call HGT_invQ_OLR(G2H2(286),2,5,2)
call HGT_OLR(G2H2(286),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(188),[G2H2(287),G1H2(647),G1H2(272)])
call HGT_OLR(G2H2(290),1,1,2)
call HGT_invQ_OLR(G2H2(290),2,5,2)
call HGT_OLR(G2H2(290),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(290),[G1H2(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(216),[G2H2(291),G1H2(659),G1H2(284)])
call HGT_OLR(G2H2(294),1,1,2)
call HGT_invQ_OLR(G2H2(294),2,5,2)
call HGT_OLR(G2H2(294),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G1H2(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(209),[G2H2(295),G1H2(665),G1H2(296)])
call HGT_OLR(G2H2(298),1,1,2)
call HGT_invQ_OLR(G2H2(298),2,5,2)
call HGT_OLR(G2H2(298),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(298),[G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G2H2(299),G1H2(677),G1H2(308)])
call HGT_w2_OLR(G1H2(63),1,1,2)
call HGT_w2_invQ_OLR(G1H2(63),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(313)])
call HGT_w2_OLR(G1H2(93),1,1,2)
call HGT_w2_invQ_OLR(G1H2(93),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(314)])
call HGT_w2_OLR(G1H2(111),1,1,2)
call HGT_w2_invQ_OLR(G1H2(111),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(318)])
call HGT_w2_OLR(G1H2(135),1,1,2)
call HGT_w2_invQ_OLR(G1H2(135),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(135),[G1H2(319)])
call HGT_w2_OLR(G1H2(154),1,1,2)
call HGT_w2_invQ_OLR(G1H2(154),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(323)])
call HGT_w2_OLR(G1H2(33),1,1,2)
call HGT_w2_invQ_OLR(G1H2(33),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(324)])
call HGT_w2_OLR(G1H2(57),1,1,2)
call HGT_w2_invQ_OLR(G1H2(57),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(328)])
call HGT_w2_OLR(G1H2(87),1,1,2)
call HGT_w2_invQ_OLR(G1H2(87),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(329)])
call HGT_w2_OLR(G1H2(118),1,1,2)
call HGT_w2_invQ_OLR(G1H2(118),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(333)])
call HGT_w2_OLR(G1H2(142),1,1,2)
call HGT_w2_invQ_OLR(G1H2(142),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(334)])
call HGT_w2_OLR(G1H2(171),1,1,2)
call HGT_w2_invQ_OLR(G1H2(171),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(171),[G1H2(338)])
call HGT_w2_OLR(G1H2(58),1,1,2)
call HGT_w2_invQ_OLR(G1H2(58),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(405),G1H2(343)])
call HGT_w2_OLR(G1H2(105),1,1,2)
call HGT_w2_invQ_OLR(G1H2(105),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(411),[G1H2(344)])
call HGT_w2_OLR(G1H2(141),1,1,2)
call HGT_w2_invQ_OLR(G1H2(141),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(417),[G1H2(393),G1H2(348)])
call HGT_w2_OLR(G1H2(39),1,1,2)
call HGT_w2_invQ_OLR(G1H2(39),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(399),[G1H2(349)])
call HGT_w2_OLR(G1H2(81),1,1,2)
call HGT_w2_invQ_OLR(G1H2(81),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(519),G1H2(369),G1H2(354)])
call HGT_w2_OLR(G1H2(129),1,1,2)
call HGT_w2_invQ_OLR(G1H2(129),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(230),[G2H2(350)])
call HGT_w2_OLR(G1H2(166),1,1,2)
call HGT_w2_invQ_OLR(G1H2(166),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(166),[G1H2(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G2H2(445),G2H2(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(567),G1H2(364),G1H2(359)])
call HGT_w2_OLR(G1H2(75),1,1,2)
call HGT_w2_invQ_OLR(G1H2(75),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G2H2(354)])
call HGT_w2_OLR(G1H2(123),1,1,2)
call HGT_w2_invQ_OLR(G1H2(123),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(711)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G2H2(446),G2H2(356)])
call ol_merge_last(G1H2(45), G1H2(45)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(413),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(645),G1H2(363)])
call HGT_OLR(G2H2(413),1,1,2)
call HGT_invQ_OLR(G2H2(413),2,5,2)
call HGT_OLR(G2H2(413),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(413),[G2H2(108)])
call HGT_w2_OLR(G1H2(106),1,1,2)
call HGT_w2_invQ_OLR(G1H2(106),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(776)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(313),[G2H2(288),G2H2(452),G2H2(451),G2H2(450) &
    ,G2H2(360)])
call ol_merge_last(G1H2(46), G1H2(46)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(609),G1H2(368)])
call HGT_OLR(G2H2(405),1,1,2)
call HGT_invQ_OLR(G2H2(405),2,5,2)
call HGT_OLR(G2H2(405),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G2H2(102)])
call HGT_w2_OLR(G1H2(159),1,1,2)
call HGT_w2_invQ_OLR(G1H2(159),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(786)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(318),[G2H2(304),G2H2(458),G2H2(457),G2H2(456) &
    ,G2H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(585),[G1H2(525),G1H2(373)])
call HGT_w2_OLR(G1H2(94),1,1,2)
call HGT_w2_invQ_OLR(G1H2(94),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(94),[G1H2(585)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(616),G1H2(531),G1H2(374)])
call HGT_w2_OLR(G1H2(153),1,1,2)
call HGT_w2_invQ_OLR(G1H2(153),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G1H2(663),G1H2(378)])
call HGT_w2_OLR(G1H2(177),1,1,2)
call HGT_w2_invQ_OLR(G1H2(177),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G1H2(579),G1H2(574),G1H2(379)])
call HGT_w2_OLR(G1H2(178),1,1,2)
call HGT_w2_invQ_OLR(G1H2(178),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G1H2(178)])
call HGT_w2_OLR(G1H2(179),1,1,2)
call HGT_w2_invQ_OLR(G1H2(179),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(796)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(322),[G2H2(300),G2H2(464),G2H2(463),G2H2(462) &
    ,G2H2(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G1H2(627),G1H2(383)])
call HGT_w2_OLR(G1H2(180),1,1,2)
call HGT_w2_invQ_OLR(G1H2(180),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G1H2(543),G1H2(538),G1H2(384)])
call HGT_w2_OLR(G1H2(181),1,1,2)
call HGT_w2_invQ_OLR(G1H2(181),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G1H2(181)])
call HGT_w2_OLR(G1H2(182),1,1,2)
call HGT_w2_invQ_OLR(G1H2(182),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(182),[G1H2(806)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(327),[G2H2(309),G2H2(470),G2H2(469),G2H2(468) &
    ,G2H2(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(597),[G1H2(549),G1H2(388)])
call HGT_w2_OLR(G1H2(183),1,1,2)
call HGT_w2_invQ_OLR(G1H2(183),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(597)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(634),G1H2(555),G1H2(389)])
call HGT_w2_OLR(G1H2(184),1,1,2)
call HGT_w2_invQ_OLR(G1H2(184),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(95),G1H4(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(109),G1H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(10),G1H4(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(6),G1H4(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(12),G1H4(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(3),G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(277)])
call HGT_w2_OLR(G1H2(185),1,1,2)
call HGT_w2_invQ_OLR(G1H2(185),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(165),[G2H4(22)])
call HGT_w2_OLR(G1H2(186),1,1,2)
call HGT_w2_invQ_OLR(G1H2(186),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(144)])
call HGT_w2_OLR(G1H2(187),1,1,2)
call HGT_w2_invQ_OLR(G1H2(187),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(187),[G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(166)])
call HGT_w2_OLR(G1H4(226),1,1,4)
call HGT_w2_invQ_OLR(G1H4(226),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(226),[G1H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(181)])
call HGT_w2_OLR(G1H4(231),1,1,4)
call HGT_w2_invQ_OLR(G1H4(231),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(211)])
call HGT_w2_OLR(G1H2(188),1,1,2)
call HGT_w2_invQ_OLR(G1H2(188),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(188),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(355),[G1H4(142)])
call HGT_w2_OLR(G1H4(244),1,1,4)
call HGT_w2_invQ_OLR(G1H4(244),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(229)])
call HGT_w2_OLR(G1H2(189),1,1,2)
call HGT_w2_invQ_OLR(G1H2(189),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(159),[G2H4(40)])
call HGT_w2_OLR(G1H2(190),1,1,2)
call HGT_w2_invQ_OLR(G1H2(190),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(190),[G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(149),[G2H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(280),[G1H2(60)])
call HGT_w2_OLR(G1H2(191),1,1,2)
call HGT_w2_invQ_OLR(G1H2(191),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(232),[G1H4(12)])
call HGT_w2_OLR(G1H4(284),1,1,4)
call HGT_w2_invQ_OLR(G1H4(284),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(225),[G1H4(25)])
call HGT_w2_OLR(G1H4(285),1,1,4)
call HGT_w2_invQ_OLR(G1H4(285),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(285),[G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(151)])
call HGT_w2_OLR(G1H2(192),1,1,2)
call HGT_w2_invQ_OLR(G1H2(192),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(212),[G1H4(289)])
call HGT_w2_OLR(G1H4(122),1,1,4)
call HGT_w2_invQ_OLR(G1H4(122),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(212)])
call HGT_w2_OLR(G1H2(193),1,1,2)
call HGT_w2_invQ_OLR(G1H2(193),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(193),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(69)])
call HGT_w2_OLR(G1H2(194),1,1,2)
call HGT_w2_invQ_OLR(G1H2(194),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(292),[G1H2(241)])
call HGT_w2_OLR(G1H2(195),1,1,2)
call HGT_w2_invQ_OLR(G1H2(195),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(195),[G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(168),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(248),[G1H4(66)])
call HGT_w2_OLR(G1H4(290),1,1,4)
call HGT_w2_invQ_OLR(G1H4(290),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(290),[G1H4(248)])
call HGT_w2_OLR(G1H2(196),1,1,2)
call HGT_w2_invQ_OLR(G1H2(196),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(196),[G1H2(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G2H4(23)])
call HGT_w2_OLR(G1H2(197),1,1,2)
call HGT_w2_invQ_OLR(G1H2(197),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(197),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(32)])
call HGT_w2_OLR(G1H2(198),1,1,2)
call HGT_w2_invQ_OLR(G1H2(198),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(198),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(217)])
call HGT_w2_OLR(G1H2(199),1,1,2)
call HGT_w2_invQ_OLR(G1H2(199),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(199),[G1H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(156),[G2H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(261),[G1H4(235)])
call HGT_w2_OLR(G1H4(50),1,1,4)
call HGT_w2_invQ_OLR(G1H4(50),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(261)])
call HGT_w2_OLR(G1H2(200),1,1,2)
call HGT_w2_invQ_OLR(G1H2(200),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(200),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G2H4(59)])
call HGT_w2_OLR(G1H4(245),1,1,4)
call HGT_w2_invQ_OLR(G1H4(245),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(154),[G1H4(245)])
call HGT_w2_OLR(G1H4(100),1,1,4)
call HGT_w2_invQ_OLR(G1H4(100),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(408)])
call HGT_w2_OLR(G1H4(116),1,1,4)
call HGT_w2_invQ_OLR(G1H4(116),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(116)])
call HGT_w2_OLR(G1H4(117),1,1,4)
call HGT_w2_invQ_OLR(G1H4(117),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(157)])
call HGT_w2_OLR(G1H4(128),1,1,4)
call HGT_w2_invQ_OLR(G1H4(128),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(128)])
call HGT_w2_OLR(G1H4(129),1,1,4)
call HGT_w2_invQ_OLR(G1H4(129),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(395),[G1H2(128),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(436),[G2H2(442),G1H2(491),G1H2(401),G1H2(21),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(407),[G1H2(158),G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(441),[G2H2(444),G1H2(455),G1H2(413),G1H2(7),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(282),[G1H2(419),G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(427),G1H2(473),G1H2(425),G1H2(15),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(431),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G2H2(429),G1H2(509),G1H2(437),G1H2(27),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(443),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(449),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(774),[G1H2(461),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(479),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(497),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(133),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(563),[G1H2(515),G1H2(95),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(149),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(551),[G1H2(527),G1H2(173),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(575),[G1H2(539),G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(212),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(599),[G1H2(587),G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(617),G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(635),G1H2(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(653),G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(671),G1H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(424),[G1H2(400),G1H2(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(436),[G1H2(412),G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(423),[G1H2(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(435),[G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(447),[G1H2(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(453),[G1H2(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(454),[G1H2(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(465),G1H2(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(471),[G1H2(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(472),G1H2(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(433),[G1H2(483),G1H2(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(489),[G1H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(490),G1H2(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(501),[G1H2(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(507),[G1H2(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(508),[G1H2(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G1H2(628),G1H2(610),G1H2(544),G1H2(520),G1H2(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G1H2(658),G1H2(622),G1H2(592),G1H2(532),G1H2(526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G1H2(676),G1H2(640),G1H2(604),G1H2(556),G1H2(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G1H2(664),G1H2(646),G1H2(580),G1H2(568),G1H2(562)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(652),G1H2(591),G1H2(586)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(670),G1H2(603),G1H2(598)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(229),G1H4(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G1H4(217),G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(354),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G1H4(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(49),G1H4(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(36),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G1H4(211),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G1H4(179),G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(111),[G1H4(63),G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(256),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G1H4(24),G1H4(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G1H4(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G1H4(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G1H4(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(742),[G1H2(732),G1H2(702),G1H2(692)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(788),[G1H2(778),G1H2(713),G1H2(693)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(757),[G1H2(737),G1H2(722),G1H2(697)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(793),[G1H2(773),G1H2(708),G1H2(698)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(808),[G1H2(798),G1H2(718),G1H2(703)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(767),[G1H2(747),G1H2(727),G1H2(707)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(762),[G1H2(752),G1H2(717),G1H2(712)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(803),[G1H2(783),G1H2(728),G1H2(723)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G1H2(787),G1H2(733)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(207),[G1H2(792),G1H2(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(224),[G1H2(807),G1H2(743)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G1H2(772),G1H2(748)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G1H2(777),G1H2(753)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G1H2(802),G1H2(758)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(212),[G1H2(797),G1H2(763)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G1H2(782),G1H2(768)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G1H4(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G1H4(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G1H4(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G1H4(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G1H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G2H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(252),[G2H2(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G2H2(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G2H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G2H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G2H2(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(276),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(182),[G2H2(146)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(308),ex4(:),G2tensor(18),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(311),ex4(:),G2tensor(20),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(434),ex4(:),G2tensor(22),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(234),ex4(:),G2tensor(24),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(26),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(310),ex4(:),G2tensor(28),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(256),ex3(:),G2tensor(30),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(32),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(319),ex3(:),G2tensor(34),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(244),ex4(:),G2tensor(36),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(38),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(315),ex4(:),G2tensor(40),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(268),ex3(:),G2tensor(42),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(44),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(324),ex3(:),G2tensor(46),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(344),ex2(:),G2tensor(48),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(347),ex2(:),G2tensor(50),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(443),ex2(:),G2tensor(52),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(418),ex4(:),G2tensor(54),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(402),ex4(:),G2tensor(56),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(58),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(60),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(57),ex2(:),G2tensor(62),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(415),ex2(:),G2tensor(64),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex3(:),G2tensor(73),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(407),ex3(:),G2tensor(75),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex3(:),G2tensor(77),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(392),ex3(:),G2tensor(79),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(37),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(395),ex2(:),G2tensor(43),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hotf_4pt_reduction(G2H2(435),RedSet_4(104),mass4set(:,1),  & 
G1H2(607),G1H2(608),G1H2(729),G1H2(613),G1H2(614),2)
  call HG1shiftOLR(G1H2(608),8,2)
  call Hotf_4pt_reduction(G2H2(426),RedSet_4(116),mass4set(:,1),  & 
G1H2(618),G1H2(619),G1H2(620),G1H2(734),G1H2(625),2)
  call HG1shiftOLR(G1H2(619),8,2)
  call Hotf_4pt_reduction(G2H4(98),RedSet_4(50),mass4set(:,1),  & 
G1H4(251),G1H4(132),G1H4(43),G1H4(74),G1H4(218),4)
  call HG1shiftOLR(G1H4(132),5,4)
  call Hotf_4pt_reduction(G2H4(88),RedSet_4(78),mass4set(:,1),  & 
G1H4(234),G1H4(168),G1H4(19),G1H4(68),G1H4(67),4)
  call HG1shiftOLR(G1H4(168),6,4)
  call Hotf_4pt_reduction(G2H4(96),RedSet_4(35),mass4set(:,1),  & 
G1H4(79),G1H4(97),G1H4(103),G1H4(77),G1H4(101),4)
  call HG1shiftOLR(G1H4(97),9,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(11),mass4set(:,1),  & 
G1H4(131),G1H4(167),G1H4(240),G1H4(216),G1H4(247),4)
  call HG1shiftOLR(G1H4(167),9,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(63),mass4set(:,1),  & 
G1H4(1),G1H4(271),G1H4(42),G1H4(7),G1H4(126),4)
  call HG1shiftOLR(G1H4(271),10,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(23),mass4set(:,1),  & 
G1H4(56),G1H4(139),G1H4(313),G1H4(151),G1H4(163),4)
  call HG1shiftOLR(G1H4(139),10,4)
  call Hloop_VQ_A(ntryL,G1H2(64),ex1(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(475))
  call Hloop_VQ_A(ntryL,G1H2(76),ex2(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(476))
  call Hloop_VQ_A(ntryL,G1H2(88),ex1(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(477))
  call Hloop_VQ_A(ntryL,G1H2(100),ex1(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(478))
  call Hloop_VQ_A(ntryL,G1H2(112),ex2(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(479))
  call Hloop_VQ_A(ntryL,G1H2(124),ex2(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(480))
  call Hloop_VA_Q(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(481))
  call Hloop_VA_Q(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(482))
  call Hloop_QV_A(ntryL,G1H2(160),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(197),n2h1(483))
  call Hloop_QV_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(484))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(87),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hloop_QV_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(485))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(91),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(340),mass4set(:,1),  & 
G1H2(626),G1H2(739),G1H2(631),G1H2(632),G1H2(636),2)
  call HG1shiftOLR(G1H2(739),16,2)
  call Hotf_4pt_reduction(G2H2(391),RedSet_4(347),mass4set(:,1),  & 
G1H2(637),G1H2(638),G1H2(744),G1H2(643),G1H2(644),2)
  call HG1shiftOLR(G1H2(638),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(214),ex1(:),G2tensor(93),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(315),mass4set(:,1),  & 
G1H2(749),G1H2(649),G1H2(650),G1H2(654),G1H2(655),2)
  call HG1shiftOLR(G1H2(649),16,2)
  call Hotf_4pt_reduction(G2H2(414),RedSet_4(334),mass4set(:,1),  & 
G1H2(656),G1H2(754),G1H2(661),G1H2(662),G1H2(759),2)
  call HG1shiftOLR(G1H2(754),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(35),ex2(:),G2tensor(97),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hloop_AV_Q(ntryL,G1H2(147),ex5(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(486))
  call Hotf_4pt_reduction(G2H2(406),RedSet_4(358),mass4set(:,1),  & 
G1H2(667),G1H2(668),G1H2(672),G1H2(673),G1H2(674),2)
  call HG1shiftOLR(G1H2(668),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(226),ex1(:),G2tensor(105),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(353),mass4set(:,1),  & 
G1H2(764),G1H2(680),G1H2(685),G1H2(690),G1H2(695),2)
  call HG1shiftOLR(G1H2(680),16,2)
  call Hotf_4pt_reduction(G2H2(398),RedSet_4(322),mass4set(:,1),  & 
G1H2(700),G1H2(705),G1H2(710),G1H2(715),G1H2(720),2)
  call HG1shiftOLR(G1H2(705),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(439),ex2(:),G2tensor(109),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(329),mass4set(:,1),  & 
G1H2(725),G1H2(730),G1H2(735),G1H2(740),G1H2(745),2)
  call HG1shiftOLR(G1H2(730),16,2)
  call Hotf_4pt_reduction(G2H2(238),RedSet_4(379),mass4set(:,1),  & 
G1H2(750),G1H2(755),G1H2(760),G1H2(765),G1H2(770),2)
  call HG1shiftOLR(G1H2(755),2,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(250),mass4set(:,1),  & 
G1H2(775),G1H2(780),G1H2(785),G1H2(790),G1H2(795),2)
  call HG1shiftOLR(G1H2(780),16,2)
  call Hotf_4pt_reduction(G2H2(242),RedSet_4(383),mass4set(:,1),  & 
G1H2(800),G1H2(805),G1H2(226),G1H2(238),G1H2(250),2)
  call HG1shiftOLR(G1H2(805),8,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(264),mass4set(:,1),  & 
G1H2(262),G1H2(274),G1H2(286),G1H2(298),G1H2(310),2)
  call HG1shiftOLR(G1H2(274),16,2)
  call Hotf_4pt_reduction(G2H2(246),RedSet_4(386),mass4set(:,1),  & 
G1H2(468),G1H2(486),G1H2(522),G1H2(534),G1H2(546),2)
  call HG1shiftOLR(G1H2(486),2,2)
  call Hotf_4pt_reduction(G2H2(430),RedSet_4(272),mass4set(:,1),  & 
G1H2(558),G1H2(570),G1H2(582),G1H2(594),G1H2(606),2)
  call HG1shiftOLR(G1H2(570),16,2)
  call Hotf_4pt_reduction(G2H2(250),RedSet_4(390),mass4set(:,1),  & 
G1H2(612),G1H2(624),G1H2(630),G1H2(642),G1H2(648),2)
  call HG1shiftOLR(G1H2(624),4,2)
  call Hotf_4pt_reduction(G2H2(254),RedSet_4(393),mass4set(:,1),  & 
G1H2(660),G1H2(666),G1H2(678),G1H2(207),G1H2(38),2)
  call HG1shiftOLR(G1H2(666),1,2)
  call Hotf_4pt_reduction(G2H2(258),RedSet_4(395),mass4set(:,1),  & 
G1H2(62),G1H2(68),G1H2(74),G1H2(104),G1H2(92),2)
  call HG1shiftOLR(G1H2(68),1,2)
  call Hotf_4pt_reduction(G2H2(262),RedSet_4(397),mass4set(:,1),  & 
G1H2(116),G1H2(134),G1H2(140),G1H2(146),G1H2(170),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(432),RedSet_4(305),mass4set(:,1),  & 
G1H2(176),G1H2(1),G1H2(9),G1H2(11),G1H2(41),2)
  call HG1shiftOLR(G1H2(1),16,2)
  call Hotf_4pt_reduction(G2H2(266),RedSet_4(400),mass4set(:,1),  & 
G1H2(83),G1H2(17),G1H2(107),G1H2(131),G1H2(23),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hotf_4pt_reduction(G2H2(270),RedSet_4(402),mass4set(:,1),  & 
G1H2(89),G1H2(143),G1H2(29),G1H2(101),G1H2(37),2)
  call HG1shiftOLR(G1H2(143),2,2)
  call Hotf_4pt_reduction(G2H2(197),RedSet_4(317),mass4set(:,1),  & 
G1H2(54),G1H2(42),G1H2(53),G1H2(55),G1H2(59),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_4pt_reduction(G2H2(274),RedSet_4(404),mass4set(:,1),  & 
G1H2(66),G1H2(67),G1H2(71),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(67),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(325),mass4set(:,1),  & 
G1H2(96),G1H2(120),G1H2(90),G1H2(139),G1H2(97),2)
  call HG1shiftOLR(G1H2(120),16,2)
  call Hotf_4pt_reduction(G2H2(278),RedSet_4(407),mass4set(:,1),  & 
G1H2(126),G1H2(102),G1H2(108),G1H2(157),G1H2(109),2)
  call HG1shiftOLR(G1H2(102),2,2)
  call Hotf_4pt_reduction(G2H2(221),RedSet_4(331),mass4set(:,1),  & 
G1H2(119),G1H2(163),G1H2(121),G1H2(132),G1H2(137),2)
  call HG1shiftOLR(G1H2(163),16,2)
  call Hotf_4pt_reduction(G2H2(282),RedSet_4(409),mass4set(:,1),  & 
G1H2(138),G1H2(156),G1H2(161),G1H2(162),G1H2(208),2)
  call HG1shiftOLR(G1H2(156),4,2)
  call Hotf_4pt_reduction(G2H2(183),RedSet_4(336),mass4set(:,1),  & 
G1H2(209),G1H2(210),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(210),16,2)
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(412),mass4set(:,1),  & 
G1H2(220),G1H2(221),G1H2(222),G1H2(784),G1H2(227),2)
  call HG1shiftOLR(G1H2(221),1,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(336),mass4set(:,1),  & 
G1H2(228),G1H2(232),G1H2(233),G1H2(234),G1H2(789),2)
  call HG1shiftOLR(G1H2(232),16,2)
  call Hotf_4pt_reduction(G2H2(290),RedSet_4(414),mass4set(:,1),  & 
G1H2(239),G1H2(240),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(240),8,2)
  call Hotf_4pt_reduction(G2H2(216),RedSet_4(331),mass4set(:,1),  & 
G1H2(804),G1H2(251),G1H2(252),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(251),16,2)
  call Hotf_4pt_reduction(G2H2(294),RedSet_4(417),mass4set(:,1),  & 
G1H2(258),G1H2(769),G1H2(264),G1H2(275),G1H2(288),2)
  call HG1shiftOLR(G1H2(769),1,2)
  call Hotf_4pt_reduction(G2H2(209),RedSet_4(325),mass4set(:,1),  & 
G1H2(293),G1H2(299),G1H2(304),G1H2(305),G1H2(779),2)
  call HG1shiftOLR(G1H2(299),16,2)
  call Hotf_4pt_reduction(G2H2(298),RedSet_4(419),mass4set(:,1),  & 
G1H2(311),G1H2(316),G1H2(2),G1H2(317),G1H2(4),2)
  call HG1shiftOLR(G1H2(316),4,2)
  call Hotf_4pt_reduction(G2H2(192),RedSet_4(317),mass4set(:,1),  & 
G1H2(322),G1H2(326),G1H2(327),G1H2(331),G1H2(8),2)
  call HG1shiftOLR(G1H2(326),16,2)
  call Hloop_VQ_A(ntryL,G1H2(63),ex1(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(225),n2h1(487))
  call Hloop_VQ_A(ntryL,G1H2(93),ex1(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(488))
  call Hloop_VQ_A(ntryL,G1H2(111),ex2(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(489))
  call Hloop_VQ_A(ntryL,G1H2(135),ex2(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(490))
  call Hloop_VQ_A(ntryL,G1H2(154),ex1(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(491))
  call Hloop_VQ_A(ntryL,G1H2(33),ex1(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(492))
  call Hloop_VQ_A(ntryL,G1H2(57),ex1(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(252),n2h1(493))
  call Hloop_VQ_A(ntryL,G1H2(87),ex1(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(258),n2h1(494))
  call Hloop_VQ_A(ntryL,G1H2(118),ex2(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(261),n2h1(495))
  call Hloop_VQ_A(ntryL,G1H2(142),ex2(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(267),n2h1(496))
  call Hloop_VQ_A(ntryL,G1H2(171),ex2(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(497))
  call Hloop_VQ_A(ntryL,G1H2(58),ex2(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(279),n2h1(498))
  call Hloop_VA_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(285),n2h1(499))
  call Hloop_VA_Q(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(291),n2h1(500))
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(297),n2h1(501))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(303),n2h1(502))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(243),mass4set(:,1),  & 
G1H2(336),G1H2(10),G1H2(337),G1H2(341),G1H2(12),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(230),ex4(:),G2tensor(309),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hloop_QV_A(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(503))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(233),ex4(:),G2tensor(115),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(287),mass4set(:,1),  & 
G1H2(342),G1H2(14),G1H2(347),G1H2(351),G1H2(16),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(225),ex4(:),G2tensor(69),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hloop_QV_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(504))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(228),ex4(:),G2tensor(312),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hotf_4pt_reduction(G2H2(413),RedSet_4(339),mass4set(:,1),  & 
G1H2(352),G1H2(356),G1H2(357),G1H2(361),G1H2(20),2)
  call HG1shiftOLR(G1H2(356),16,2)
  call Hloop_QV_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(505))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(313),ex4(:),G2tensor(119),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hotf_4pt_reduction(G2H2(405),RedSet_4(314),mass4set(:,1),  & 
G1H2(362),G1H2(366),G1H2(22),G1H2(371),G1H2(24),2)
  call HG1shiftOLR(G1H2(366),16,2)
  call Hloop_QV_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(506))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(318),ex4(:),G2tensor(315),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hloop_AV_Q(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(507))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(257),mass4set(:,1),  & 
G1H2(372),G1H2(26),G1H2(377),G1H2(381),G1H2(382),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_4pt_reduction(G2H2(111),RedSet_4(352),mass4set(:,1),  & 
G1H2(386),G1H2(30),G1H2(387),G1H2(391),G1H2(32),2)
  call HG1shiftOLR(G1H2(30),16,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(295),mass4set(:,1),  & 
G1H2(396),G1H2(397),G1H2(398),G1H2(403),G1H2(404),2)
  call HG1shiftOLR(G1H2(397),16,2)
  call Hloop_QV_A(ntryL,G1H2(179),ex5(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(508))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(322),ex3(:),G2tensor(405),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(328),mass4set(:,1),  & 
G1H2(408),G1H2(410),G1H2(414),G1H2(415),G1H2(420),2)
  call HG1shiftOLR(G1H2(410),16,2)
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(268),mass4set(:,1),  & 
G1H2(421),G1H2(422),G1H2(427),G1H2(428),G1H2(432),2)
  call HG1shiftOLR(G1H2(422),16,2)
  call Hloop_QV_A(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(509))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(327),ex3(:),G2tensor(318),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hloop_AV_Q(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(510))
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(279),mass4set(:,1),  & 
G1H2(433),G1H2(434),G1H2(439),G1H2(440),G1H2(444),2)
  call HG1shiftOLR(G1H2(434),16,2)
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(50),mass4set(:,1),  & 
G1H4(175),G1H4(187),G1H4(368),G1H4(358),G1H4(349),4)
  call HG1shiftOLR(G1H4(187),5,4)
call HGT_OLR(G2H4(101),1,1,4)
call HGT_invQ_OLR(G2H4(101),2,5,4)
call HGT_OLR(G2H4(101),6,15,4)
  call Hotf_4pt_reduction(G2H4(101),RedSet_4(410),mass4set(:,1),  & 
G1H4(402),G1H4(442),G1H4(437),G1H4(432),G1H4(452),4)
  call HG1shiftOLR(G1H4(442),5,4)
call HGT_OLR(G2H4(145),1,1,4)
call HGT_invQ_OLR(G2H4(145),2,5,4)
call HGT_OLR(G2H4(145),6,15,4)
  call Hotf_4pt_reduction(G2H4(145),RedSet_4(413),mass4set(:,1),  & 
G1H4(94),G1H4(105),G1H4(205),G1H4(71),G1H4(85),4)
  call HG1shiftOLR(G1H4(105),5,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(78),mass4set(:,1),  & 
G1H4(222),G1H4(275),G1H4(127),G1H4(8),G1H4(314),4)
  call HG1shiftOLR(G1H4(275),6,4)
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(420),mass4set(:,1),  & 
G1H4(52),G1H4(299),G1H4(305),G1H4(308),G1H4(317),4)
  call HG1shiftOLR(G1H4(299),6,4)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(403),mass4set(:,1),  & 
G1H4(323),G1H4(326),G1H4(332),G1H4(335),G1H4(341),4)
  call HG1shiftOLR(G1H4(326),6,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(11),mass4set(:,1),  & 
G1H4(22),G1H4(10),G1H4(45),G1H4(46),G1H4(422),4)
  call HG1shiftOLR(G1H4(10),9,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(35),mass4set(:,1),  & 
G1H4(428),G1H4(388),G1H4(165),G1H4(16),G1H4(272),4)
  call HG1shiftOLR(G1H4(388),9,4)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(405),mass4set(:,1),  & 
G1H4(206),G1H4(14),G1H4(278),G1H4(32),G1H4(233),4)
  call HG1shiftOLR(G1H4(14),9,4)
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(418),mass4set(:,1),  & 
G1H4(28),G1H4(146),G1H4(27),G1H4(20),G1H4(266),4)
  call HG1shiftOLR(G1H4(146),9,4)
  call Hotf_4pt_reduction(G2H4(83),RedSet_4(23),mass4set(:,1),  & 
G1H4(110),G1H4(40),G1H4(439),G1H4(134),G1H4(254),4)
  call HG1shiftOLR(G1H4(40),10,4)
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(63),mass4set(:,1),  & 
G1H4(26),G1H4(440),G1H4(443),G1H4(433),G1H4(304),4)
  call HG1shiftOLR(G1H4(440),10,4)
call HGT_OLR(G2H4(80),1,1,4)
call HGT_invQ_OLR(G2H4(80),2,5,4)
call HGT_OLR(G2H4(80),6,15,4)
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(415),mass4set(:,1),  & 
G1H4(51),G1H4(322),G1H4(331),G1H4(340),G1H4(348),4)
  call HG1shiftOLR(G1H4(322),10,4)
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(408),mass4set(:,1),  & 
G1H4(378),G1H4(357),G1H4(367),G1H4(377),G1H4(401),4)
  call HG1shiftOLR(G1H4(357),10,4)
  call Hloop_VA_Q(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(511))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(165),wf4(:,12),G2tensor(387),m3h4x1(:,129),heltab2x4(:,:,789))
  call Hloop_VA_Q(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(512))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(118),wf4(:,12),G2tensor(321),m3h4x1(:,130),heltab2x4(:,:,790))
  call Hloop_VA_Q(ntryL,G1H2(187),ex4(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(513))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(91),wf4(:,12),G2tensor(131),m3h4x1(:,131),heltab2x4(:,:,791))
  call Hloop_VQ_A(ntryL,G1H4(226),wf4(:,12),G1H1(1),m3h4x1(:,132),heltab2x4(:,:,792))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(396),n2h1(514))
  call Hloop_VQ_A(ntryL,G1H4(231),wf4(:,12),G1H1(1),m3h4x1(:,133),heltab2x4(:,:,793))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(515))
  call Hloop_VA_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(324),n2h1(516))
  call Hloop_VQ_A(ntryL,G1H4(244),wf4(:,12),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,794))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(517))
  call Hloop_VA_Q(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(518))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(159),wf4(:,4),G2tensor(414),m3h4x1(:,135),heltab2x4(:,:,795))
  call Hloop_VA_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(519))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(149),wf4(:,4),G2tensor(327),m3h4x1(:,136),heltab2x4(:,:,796))
  call Hloop_VA_Q(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(520))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(62),wf4(:,4),G2tensor(139),m3h4x1(:,137),heltab2x4(:,:,797))
  call Hloop_VQ_A(ntryL,G1H4(284),wf4(:,4),G1H1(1),m3h4x1(:,138),heltab2x4(:,:,798))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(521))
  call Hloop_VQ_A(ntryL,G1H4(285),wf4(:,4),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,799))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(522))
  call Hloop_VA_Q(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(330),n2h1(523))
  call Hloop_VQ_A(ntryL,G1H4(122),wf4(:,4),G1H1(1),m3h4x1(:,140),heltab2x4(:,:,800))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(524))
  call Hloop_VQ_A(ntryL,G1H2(193),ex2(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(525))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(76),wf4(:,19),G2tensor(83),m3h4x1(:,141),heltab2x4(:,:,801))
  call Hloop_VQ_A(ntryL,G1H2(194),ex1(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(333),n2h1(526))
  call Hloop_VQ_A(ntryL,G1H2(195),ex2(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(527))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(168),wf4(:,19),G2tensor(85),m3h4x1(:,142),heltab2x4(:,:,802))
  call Hloop_VA_Q(ntryL,G1H4(290),wf4(:,19),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,803))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(528))
  call Hloop_VQ_A(ntryL,G1H2(196),ex1(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(336),n2h1(529))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(162),wf4(:,19),G2tensor(147),m3h4x1(:,144),heltab2x4(:,:,804))
  call Hloop_VQ_A(ntryL,G1H2(197),ex2(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(530))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(44),wf4(:,9),G2tensor(339),m3h4x1(:,145),heltab2x4(:,:,805))
  call Hloop_VQ_A(ntryL,G1H2(198),ex1(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(531))
  call Hloop_VQ_A(ntryL,G1H2(199),ex2(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(532))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(156),wf4(:,9),G2tensor(219),m3h4x1(:,146),heltab2x4(:,:,806))
  call Hloop_VA_Q(ntryL,G1H4(50),wf4(:,9),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,807))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(342),n2h1(533))
  call Hloop_VQ_A(ntryL,G1H2(200),ex1(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(534))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(126),wf4(:,9),G2tensor(99),m3h4x1(:,148),heltab2x4(:,:,808))
call HGT_w2_OLR(G1H2(201),1,1,2)
call HGT_w2_invQ_OLR(G1H2(201),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(201),ex5(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(216),n2h1(535))
call HGT_w2_OLR(G1H2(202),1,1,2)
call HGT_w2_invQ_OLR(G1H2(202),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(202),ex5(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(345),n2h1(536))
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(430),mass4set(:,1),  & 
G1H4(417),G1H4(416),G1H4(186),G1H4(336),G1H4(342),4)
  call HG1shiftOLR(G1H4(416),5,4)
call HGT_w2_OLR(G1H4(444),1,1,4)
call HGT_w2_invQ_OLR(G1H4(444),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(444),wf4(:,1),G1H1(1),m3h4x1(:,149),heltab2x4(:,:,809))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(537))
call HGT_w2_OLR(G1H4(99),1,1,4)
call HGT_w2_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(99),wf4(:,1),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,810))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(155),n2h1(538))
call HGT_w2_OLR(G1H2(203),1,1,2)
call HGT_w2_invQ_OLR(G1H2(203),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(203),ex5(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(103),n2h1(539))
  call Hotf_4pt_reduction(G2H4(103),RedSet_4(436),mass4set(:,1),  & 
G1H4(343),G1H4(347),G1H4(350),G1H4(434),G1H4(356),4)
  call HG1shiftOLR(G1H4(347),6,4)
call HGT_w2_OLR(G1H4(111),1,1,4)
call HGT_w2_invQ_OLR(G1H4(111),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(111),wf4(:,11),G1H1(1),m3h4x1(:,151),heltab2x4(:,:,811))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(540))
call HGT_w2_OLR(G1H4(112),1,1,4)
call HGT_w2_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(112),wf4(:,11),G1H1(1),m3h4x1(:,152),heltab2x4(:,:,812))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(348),n2h1(541))
call HGT_w2_OLR(G1H2(204),1,1,2)
call HGT_w2_invQ_OLR(G1H2(204),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(204),ex5(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(157),n2h1(542))
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(433),mass4set(:,1),  & 
G1H4(365),G1H4(366),G1H4(374),G1H4(375),G1H4(384),4)
  call HG1shiftOLR(G1H4(366),9,4)
  call Hloop_QV_A(ntryL,G1H4(117),wf4(:,15),G1H1(1),m3h4x1(:,153),heltab2x4(:,:,813))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(543))
call HGT_w2_OLR(G1H4(124),1,1,4)
call HGT_w2_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(124),wf4(:,15),G1H1(1),m3h4x1(:,154),heltab2x4(:,:,814))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(107),n2h1(544))
call HGT_w2_OLR(G1H2(205),1,1,2)
call HGT_w2_invQ_OLR(G1H2(205),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(213),n2h1(545))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(439),mass4set(:,1),  & 
G1H4(385),G1H4(391),G1H4(257),G1H4(396),G1H4(399),4)
  call HG1shiftOLR(G1H4(391),10,4)
  call Hloop_QV_A(ntryL,G1H4(129),wf4(:,20),G1H1(1),m3h4x1(:,155),heltab2x4(:,:,815))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(351),n2h1(546))
call HGT_w2_OLR(G1H4(130),1,1,4)
call HGT_w2_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(130),wf4(:,20),G1H1(1),m3h4x1(:,156),heltab2x4(:,:,816))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(161),n2h1(547))
call HGT_w2_OLR(G1H2(206),1,1,2)
call HGT_w2_invQ_OLR(G1H2(206),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(163),n2h1(548))
  call Hloop_VA_Q(ntryL,G1H2(395),ex4(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(549))
  call Hotf_4pt_reduction(G2H2(436),RedSet_4(34),mass4set(:,1),  & 
G1H2(446),G1H2(450),G1H2(451),G1H2(456),G1H2(457),2)
  call HG1shiftOLR(G1H2(450),8,2)
  call Hloop_VA_Q(ntryL,G1H2(407),ex3(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(550))
  call Hotf_4pt_reduction(G2H2(441),RedSet_4(49),mass4set(:,1),  & 
G1H2(458),G1H2(463),G1H2(464),G1H2(679),G1H2(470),2)
  call HG1shiftOLR(G1H2(463),4,2)
  call Hloop_VA_Q(ntryL,G1H2(282),ex4(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(354),n2h1(551))
  call Hotf_4pt_reduction(G2H2(438),RedSet_4(62),mass4set(:,1),  & 
G1H2(474),G1H2(475),G1H2(480),G1H2(481),G1H2(482),2)
  call HG1shiftOLR(G1H2(475),8,2)
  call Hloop_VA_Q(ntryL,G1H2(294),ex3(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(552))
  call Hotf_4pt_reduction(G2H2(147),RedSet_4(77),mass4set(:,1),  & 
G1H2(487),G1H2(488),G1H2(492),G1H2(499),G1H2(500),2)
  call HG1shiftOLR(G1H2(488),4,2)
  call Hloop_VA_Q(ntryL,G1H2(443),ex3(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(553))
  call Hloop_VA_Q(ntryL,G1H2(449),ex3(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(554))
  call Hloop_VA_Q(ntryL,G1H2(774),ex4(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(357),n2h1(555))
  call Hloop_VA_Q(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(360),n2h1(556))
  call Hloop_VA_Q(ntryL,G1H2(497),ex3(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(557))
  call Hloop_VA_Q(ntryL,G1H2(503),ex3(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(363),n2h1(558))
  call Hloop_VQ_A(ntryL,G1H2(133),ex2(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(366),n2h1(559))
  call Hloop_QV_A(ntryL,G1H2(563),ex5(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(560))
  call Hloop_VA_Q(ntryL,G1H2(149),ex4(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(369),n2h1(561))
  call Hloop_AV_Q(ntryL,G1H2(551),ex5(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(372),n2h1(562))
  call Hloop_QV_A(ntryL,G1H2(575),ex5(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(563))
  call Hloop_VA_Q(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(375),n2h1(564))
  call Hloop_VQ_A(ntryL,G1H2(175),ex1(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(378),n2h1(565))
  call Hloop_AV_Q(ntryL,G1H2(599),ex5(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(566))
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(323),mass4set(:,1),  & 
G1H2(504),G1H2(510),G1H2(511),G1H2(512),G1H2(523),2)
  call HG1shiftOLR(G1H2(510),16,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(335),mass4set(:,1),  & 
G1H2(524),G1H2(528),G1H2(529),G1H2(530),G1H2(694),2)
  call HG1shiftOLR(G1H2(528),16,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(348),mass4set(:,1),  & 
G1H2(535),G1H2(536),G1H2(540),G1H2(541),G1H2(542),2)
  call HG1shiftOLR(G1H2(536),16,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(359),mass4set(:,1),  & 
G1H2(699),G1H2(559),G1H2(560),G1H2(564),G1H2(565),2)
  call HG1shiftOLR(G1H2(559),16,2)
  call Hloop_VA_Q(ntryL,G1H2(424),ex4(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(381),n2h1(567))
  call Hloop_VA_Q(ntryL,G1H2(436),ex3(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(384),n2h1(568))
  call Hloop_VA_Q(ntryL,G1H2(423),ex4(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(390),n2h1(569))
  call Hloop_VA_Q(ntryL,G1H2(435),ex3(:),G1H1(1),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(393),n2h1(570))
  call Hloop_VA_Q(ntryL,G1H2(447),ex3(:),G1H1(1),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(399),n2h1(571))
  call Hloop_VA_Q(ntryL,G1H2(453),ex3(:),G1H1(1),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(402),n2h1(572))
  call Hloop_VA_Q(ntryL,G1H2(454),ex3(:),G1H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(408),n2h1(573))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(226),mass4set(:,1),  & 
G1H2(566),G1H2(709),G1H2(571),G1H2(572),G1H2(576),2)
  call HG1shiftOLR(G1H2(709),8,2)
  call Hloop_VA_Q(ntryL,G1H2(471),ex4(:),G1H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(411),n2h1(574))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(20),mass4set(:,1),  & 
G1H2(577),G1H2(578),G1H2(714),G1H2(583),G1H2(584),2)
  call HG1shiftOLR(G1H2(578),8,2)
  call Hotf_4pt_reduction(G2H2(433),RedSet_4(231),mass4set(:,1),  & 
G1H2(588),G1H2(589),G1H2(590),G1H2(719),G1H2(595),2)
  call HG1shiftOLR(G1H2(589),8,2)
  call Hloop_VA_Q(ntryL,G1H2(489),ex4(:),G1H1(1),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(417),n2h1(575))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(6),mass4set(:,1),  & 
G1H2(596),G1H2(600),G1H2(601),G1H2(602),G1H2(724),2)
  call HG1shiftOLR(G1H2(600),8,2)
  call Hloop_VA_Q(ntryL,G1H2(501),ex3(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(420),n2h1(576))
  call Hloop_VA_Q(ntryL,G1H2(507),ex3(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(228),n2h1(577))
  call Hloop_VA_Q(ntryL,G1H2(508),ex3(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(423),n2h1(578))
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(246),mass4set(:,1),  & 
G1H2(467),G1H2(35),G1H2(485),G1H2(155),G1H2(315),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(260),mass4set(:,1),  & 
G1H2(320),G1H2(325),G1H2(330),G1H2(335),G1H2(287),2)
  call HG1shiftOLR(G1H2(325),16,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(281),mass4set(:,1),  & 
G1H2(340),G1H2(300),G1H2(345),G1H2(80),G1H2(794),2)
  call HG1shiftOLR(G1H2(300),16,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(289),mass4set(:,1),  & 
G1H2(350),G1H2(44),G1H2(799),G1H2(355),G1H2(43),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(301),mass4set(:,1),  & 
G1H2(360),G1H2(172),G1H2(561),G1H2(358),G1H2(573),2)
  call HG1shiftOLR(G1H2(172),16,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(309),mass4set(:,1),  & 
G1H2(52),G1H2(513),G1H2(353),G1H2(537),G1H2(365),2)
  call HG1shiftOLR(G1H2(513),16,2)
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(355),mass4set(:,1),  & 
G1H4(404),G1H4(405),G1H4(414),G1H4(415),G1H4(431),4)
  call HG1shiftOLR(G1H4(405),17,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(298),mass4set(:,1),  & 
G1H4(447),G1H4(436),G1H4(441),G1H4(446),G1H4(451),4)
  call HG1shiftOLR(G1H4(436),17,4)
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(342),mass4set(:,1),  & 
G1H4(457),G1H4(456),G1H4(420),G1H4(423),G1H4(430),4)
  call HG1shiftOLR(G1H4(456),17,4)
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(292),mass4set(:,1),  & 
G1H4(38),G1H4(153),G1H4(154),G1H4(44),G1H4(76),4)
  call HG1shiftOLR(G1H4(153),17,4)
  call Hloop_VQ_A(ntryL,G1H4(87),wf4(:,12),G1H1(1),m3h4x1(:,157),heltab2x4(:,:,817))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(426),n2h1(579))
  call Hloop_VQ_A(ntryL,G1H4(354),wf4(:,12),G1H1(1),m3h4x1(:,158),heltab2x4(:,:,818))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(234),n2h1(580))
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(147),mass4set(:,1),  & 
G1H4(82),G1H4(294),G1H4(435),G1H4(438),G1H4(445),4)
  call HG1shiftOLR(G1H4(294),18,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(273),mass4set(:,1),  & 
G1H4(448),G1H4(450),G1H4(453),G1H4(455),G1H4(458),4)
  call HG1shiftOLR(G1H4(450),18,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(185),mass4set(:,1),  & 
G1H4(298),G1H4(309),G1H4(185),G1H4(293),G1H4(364),4)
  call HG1shiftOLR(G1H4(309),18,4)
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(251),mass4set(:,1),  & 
G1H4(381),G1H4(411),G1H4(429),G1H4(346),G1H4(201),4)
  call HG1shiftOLR(G1H4(411),18,4)
  call Hloop_VQ_A(ntryL,G1H4(91),wf4(:,4),G1H1(1),m3h4x1(:,159),heltab2x4(:,:,819))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(429),n2h1(581))
  call Hloop_VQ_A(ntryL,G1H4(202),wf4(:,4),G1H1(1),m3h4x1(:,160),heltab2x4(:,:,820))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(432),n2h1(582))
  call Hloop_VA_Q(ntryL,G1H4(108),wf4(:,19),G1H1(1),m3h4x1(:,161),heltab2x4(:,:,821))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(583))
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(162),mass4set(:,1),  & 
G1H4(141),G1H4(449),G1H4(159),G1H4(160),G1H4(281),4)
  call HG1shiftOLR(G1H4(449),20,4)
  call Hloop_VA_Q(ntryL,G1H4(238),wf4(:,19),G1H1(1),m3h4x1(:,162),heltab2x4(:,:,822))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(435),n2h1(584))
  call Hotf_4pt_reduction(G2H4(87),RedSet_4(175),mass4set(:,1),  & 
G1H4(454),G1H4(35),G1H4(81),G1H4(17),G1H4(64),4)
  call HG1shiftOLR(G1H4(35),20,4)
  call Hloop_VA_Q(ntryL,G1H4(243),wf4(:,19),G1H1(1),m3h4x1(:,163),heltab2x4(:,:,823))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(438),n2h1(585))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(173),mass4set(:,1),  & 
G1H4(75),G1H4(277),G1H4(23),G1H4(73),G1H4(37),4)
  call HG1shiftOLR(G1H4(277),20,4)
  call Hloop_VA_Q(ntryL,G1H4(255),wf4(:,19),G1H1(1),m3h4x1(:,164),heltab2x4(:,:,824))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(441),n2h1(586))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(160),mass4set(:,1),  & 
G1H4(41),G1H4(60),G1H4(65),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(60),20,4)
  call Hloop_VA_Q(ntryL,G1H4(283),wf4(:,9),G1H1(1),m3h4x1(:,165),heltab2x4(:,:,825))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(444),n2h1(587))
  call Hotf_4pt_reduction(G2H4(111),RedSet_4(126),mass4set(:,1),  & 
G1H4(120),G1H4(143),G1H4(144),G1H4(180),G1H4(192),4)
  call HG1shiftOLR(G1H4(143),24,4)
  call Hloop_VA_Q(ntryL,G1H4(256),wf4(:,9),G1H1(1),m3h4x1(:,166),heltab2x4(:,:,826))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(447),n2h1(588))
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(135),mass4set(:,1),  & 
G1H4(228),G1H4(227),G1H4(259),G1H4(264),G1H4(288),4)
  call HG1shiftOLR(G1H4(227),24,4)
  call Hloop_VA_Q(ntryL,G1H4(260),wf4(:,9),G1H1(1),m3h4x1(:,167),heltab2x4(:,:,827))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(450),n2h1(589))
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(105),mass4set(:,1),  & 
G1H4(3),G1H4(4),G1H4(69),G1H4(54),G1H4(62),4)
  call HG1shiftOLR(G1H4(4),24,4)
  call Hloop_VA_Q(ntryL,G1H4(268),wf4(:,9),G1H1(1),m3h4x1(:,168),heltab2x4(:,:,828))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(453),n2h1(590))
  call Hotf_4pt_reduction(G2H4(151),RedSet_4(117),mass4set(:,1),  & 
G1H4(113),G1H4(137),G1H4(138),G1H4(303),G1H4(306),4)
  call HG1shiftOLR(G1H4(137),24,4)
  call Hloop_VA_Q(ntryL,G1H2(681),ex4(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(456),n2h1(591))
  call Hloop_VA_Q(ntryL,G1H2(682),ex4(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(255),n2h1(592))
  call Hloop_VA_Q(ntryL,G1H2(683),ex4(:),G1H1(1),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(459),n2h1(593))
  call Hloop_VA_Q(ntryL,G1H2(686),ex4(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(462),n2h1(594))
  call Hloop_VA_Q(ntryL,G1H2(687),ex4(:),G1H1(1),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(465),n2h1(595))
  call Hloop_VA_Q(ntryL,G1H2(688),ex4(:),G1H1(1),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(264),n2h1(596))
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(43),mass4set(:,1),  & 
G1H4(311),G1H4(161),G1H4(162),G1H4(324),G1H4(328),4)
  call HG1shiftOLR(G1H4(161),5,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(47),mass4set(:,1),  & 
G1H4(329),G1H4(353),G1H4(344),G1H4(92),G1H4(296),4)
  call HG1shiftOLR(G1H4(353),5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(300),58,wf4(:,1),5,G2tensor(468),m3h4x1(:,169),heltab2x4(:,:,829))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(301),58,wf4(:,1),5,G2tensor(471),m3h4x1(:,170),heltab2x4(:,:,830))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(302),58,wf4(:,1),5,G2tensor(270),m3h4x1(:,171),heltab2x4(:,:,831))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(71),mass4set(:,1),  & 
G1H4(29),G1H4(182),G1H4(136),G1H4(372),G1H4(199),4)
  call HG1shiftOLR(G1H4(182),6,4)
  call Hotf_4pt_reduction(G2H4(108),RedSet_4(75),mass4set(:,1),  & 
G1H4(362),G1H4(352),G1H4(230),G1H4(406),G1H4(9),4)
  call HG1shiftOLR(G1H4(352),6,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(312),57,wf4(:,11),6,G2tensor(474),m3h4x1(:,172),heltab2x4(:,:,832))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(315),57,wf4(:,11),6,G2tensor(276),m3h4x1(:,173),heltab2x4(:,:,833))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(316),57,wf4(:,11),6,G2tensor(477),m3h4x1(:,174),heltab2x4(:,:,834))
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(29),mass4set(:,1),  & 
G1H4(421),G1H4(104),G1H4(427),G1H4(413),G1H4(145),4)
  call HG1shiftOLR(G1H4(104),9,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(32),mass4set(:,1),  & 
G1H4(152),G1H4(397),G1H4(295),G1H4(158),G1H4(135),4)
  call HG1shiftOLR(G1H4(397),9,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(173),54,wf4(:,15),9,G2tensor(480),m3h4x1(:,175),heltab2x4(:,:,835))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(174),54,wf4(:,15),9,G2tensor(282),m3h4x1(:,176),heltab2x4(:,:,836))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(327),54,wf4(:,15),9,G2tensor(483),m3h4x1(:,177),heltab2x4(:,:,837))
  call Hotf_4pt_reduction(G2H4(68),RedSet_4(4),mass4set(:,1),  & 
G1H4(2),G1H4(208),G1H4(178),G1H4(190),G1H4(70),4)
  call HG1shiftOLR(G1H4(208),9,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(8),mass4set(:,1),  & 
G1H4(237),G1H4(195),G1H4(207),G1H4(220),G1H4(224),4)
  call HG1shiftOLR(G1H4(195),9,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(337),54,wf4(:,15),9,G2tensor(288),m3h4x1(:,178),heltab2x4(:,:,838))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(338),54,wf4(:,15),9,G2tensor(486),m3h4x1(:,179),heltab2x4(:,:,839))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(339),54,wf4(:,15),9,G2tensor(489),m3h4x1(:,180),heltab2x4(:,:,840))
  call Hotf_4pt_reduction(G2H4(71),RedSet_4(57),mass4set(:,1),  & 
G1H4(236),G1H4(249),G1H4(280),G1H4(292),G1H4(170),4)
  call HG1shiftOLR(G1H4(249),10,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(60),mass4set(:,1),  & 
G1H4(363),G1H4(373),G1H4(86),G1H4(383),G1H4(389),4)
  call HG1shiftOLR(G1H4(373),10,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(223),53,wf4(:,20),10,G2tensor(294),m3h4x1(:,181),heltab2x4(:,:,841))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(351),53,wf4(:,20),10,G2tensor(492),m3h4x1(:,182),heltab2x4(:,:,842))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(221),53,wf4(:,20),10,G2tensor(300),m3h4x1(:,183),heltab2x4(:,:,843))
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(18),mass4set(:,1),  & 
G1H4(123),G1H4(392),G1H4(382),G1H4(164),G1H4(407),4)
  call HG1shiftOLR(G1H4(392),10,4)
  call Hotf_4pt_reduction(G2H4(56),RedSet_4(21),mass4set(:,1),  & 
G1H4(291),G1H4(102),G1H4(55),G1H4(80),G1H4(215),4)
  call HG1shiftOLR(G1H4(102),10,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(369),53,wf4(:,20),10,G2tensor(495),m3h4x1(:,184),heltab2x4(:,:,844))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(370),53,wf4(:,20),10,G2tensor(498),m3h4x1(:,185),heltab2x4(:,:,845))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(371),53,wf4(:,20),10,G2tensor(306),m3h4x1(:,186),heltab2x4(:,:,846))
  call Hloop_QV_A(ntryL,G1H2(742),ex5(:),G1H1(1),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(501),n2h1(597))
  call Hloop_QV_A(ntryL,G1H2(788),ex5(:),G1H1(1),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(504),n2h1(598))
  call Hloop_AV_Q(ntryL,G1H2(696),ex5(:),G1H1(1),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(599))
  call Hloop_AV_Q(ntryL,G1H2(757),ex5(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(600))
  call Hloop_AV_Q(ntryL,G1H2(793),ex5(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(513),n2h1(601))
  call Hloop_QV_A(ntryL,G1H2(701),ex5(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(516),n2h1(602))
  call Hloop_QV_A(ntryL,G1H2(808),ex5(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(603))
  call Hloop_AV_Q(ntryL,G1H2(706),ex5(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(604))
  call Hloop_AV_Q(ntryL,G1H2(767),ex5(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(605))
  call Hloop_QV_A(ntryL,G1H2(762),ex5(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(606))
  call Hloop_QV_A(ntryL,G1H2(716),ex5(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(531),n2h1(607))
  call Hloop_AV_Q(ntryL,G1H2(721),ex5(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(534),n2h1(608))
  call Hloop_AV_Q(ntryL,G1H2(803),ex5(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(609))
  call Hloop_AV_Q(ntryL,G1H2(726),ex5(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(610))
  call Hloop_QV_A(ntryL,G1H2(731),ex5(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(543),n2h1(611))
  call Hloop_QV_A(ntryL,G2H2(200),ex5(:),G2H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(612))
  call Hloop_AV_Q(ntryL,G1H2(736),ex5(:),G1H1(1),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(546),n2h1(613))
  call Hloop_AV_Q(ntryL,G2H2(207),ex5(:),G2H1(1),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(614))
  call Hloop_QV_A(ntryL,G1H2(741),ex5(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(507),n2h1(615))
  call Hloop_QV_A(ntryL,G2H2(224),ex5(:),G2H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(616))
  call Hloop_AV_Q(ntryL,G1H2(746),ex5(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(510),n2h1(617))
  call Hloop_AV_Q(ntryL,G2H2(186),ex5(:),G2H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(4),n2h1(618))
  call Hloop_QV_A(ntryL,G1H2(751),ex5(:),G1H1(1),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(519),n2h1(619))
  call Hloop_QV_A(ntryL,G2H2(191),ex5(:),G2H1(1),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(5),n2h1(620))
  call Hloop_AV_Q(ntryL,G1H2(756),ex5(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(522),n2h1(621))
  call Hloop_AV_Q(ntryL,G2H2(219),ex5(:),G2H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(622))
  call Hloop_QV_A(ntryL,G1H2(761),ex5(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(525),n2h1(623))
  call Hloop_QV_A(ntryL,G2H2(212),ex5(:),G2H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(624))
  call Hloop_AV_Q(ntryL,G1H2(766),ex5(:),G1H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(528),n2h1(625))
  call Hloop_AV_Q(ntryL,G2H2(195),ex5(:),G2H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(626))
  call Hotf_4pt_reduction(G2H4(100),RedSet_4(221),mass4set(:,1),  & 
G1H4(286),G1H4(78),G1H4(31),G1H4(203),G1H4(95),4)
  call HG1shiftOLR(G1H4(78),5,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(223),mass4set(:,1),  & 
G1H4(15),G1H4(297),G1H4(150),G1H4(320),G1H4(334),4)
  call HG1shiftOLR(G1H4(297),5,4)
  call Hloop_AV_Q(ntryL,G1H4(386),wf4(:,1),G1H1(1),m3h4x1(:,187),heltab2x4(:,:,847))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(537),n2h1(627))
  call Hloop_AV_Q(ntryL,G1H4(387),wf4(:,1),G1H1(1),m3h4x1(:,188),heltab2x4(:,:,848))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(540),n2h1(628))
  call Hloop_AV_Q(ntryL,G1H4(390),wf4(:,1),G1H1(1),m3h4x1(:,189),heltab2x4(:,:,849))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(551),n2h1(629))
  call Hloop_AV_Q(ntryL,G1H2(771),ex5(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(555),n2h1(630))
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(237),mass4set(:,1),  & 
G1H4(209),G1H4(361),G1H4(380),G1H4(394),G1H4(410),4)
  call HG1shiftOLR(G1H4(361),6,4)
  call Hotf_4pt_reduction(G2H4(134),RedSet_4(239),mass4set(:,1),  & 
G1H4(426),G1H4(345),G1H4(200),G1H4(166),G1H4(188),4)
  call HG1shiftOLR(G1H4(345),6,4)
  call Hloop_AV_Q(ntryL,G1H4(400),wf4(:,11),G1H1(1),m3h4x1(:,190),heltab2x4(:,:,850))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(559),n2h1(631))
  call Hloop_AV_Q(ntryL,G1H4(270),wf4(:,11),G1H1(1),m3h4x1(:,191),heltab2x4(:,:,851))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(563),n2h1(632))
  call Hloop_AV_Q(ntryL,G1H4(403),wf4(:,11),G1H1(1),m3h4x1(:,192),heltab2x4(:,:,852))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(567),n2h1(633))
  call Hloop_AV_Q(ntryL,G1H2(781),ex5(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(571),n2h1(634))
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(233),mass4set(:,1),  & 
G1H4(181),G1H4(184),G1H4(142),G1H4(355),G1H4(12),4)
  call HG1shiftOLR(G1H4(184),9,4)
  call Hloop_QV_A(ntryL,G2H4(141),wf4(:,15),G2H1(1),m3h4x1(:,193),heltab2x4(:,:,853))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(9),n2h1(635))
  call Hloop_QV_A(ntryL,G1H4(419),wf4(:,15),G1H1(1),m3h4x1(:,194),heltab2x4(:,:,854))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(591),n2h1(636))
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(232),mass4set(:,1),  & 
G1H4(232),G1H4(25),G1H4(225),G1H4(289),G1H4(212),4)
  call HG1shiftOLR(G1H4(25),9,4)
  call Hotf_4pt_reduction(G2H4(63),RedSet_4(233),mass4set(:,1),  & 
G1H4(66),G1H4(248),G1H4(235),G1H4(261),G1H4(245),4)
  call HG1shiftOLR(G1H4(248),9,4)
  call Hloop_AV_Q(ntryL,G1H4(39),wf4(:,15),G1H1(1),m3h4x1(:,195),heltab2x4(:,:,855))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(597),n2h1(637))
  call Hloop_AV_Q(ntryL,G2H4(147),wf4(:,15),G2H1(1),m3h4x1(:,196),heltab2x4(:,:,856))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(10),n2h1(638))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppajjj_uuuxuxag_2_/**/REALKIND
