
module ol_vamp_1_ppajjj_ddxaggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajjj_ddxaggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajjj_ddxaggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajjj_ddxaggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppajjj_ddxaggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajjj_ddxaggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajjj_ddxaggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(11,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (c(6)*M(4,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,1,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,4,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,1,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(25))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,8,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(26))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,16,4,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,16,8,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(27))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,8,2,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,4,1,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,1,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(28))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,2,8,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,2,8,16,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(35),n2h32(29))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,2,16,1,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(36),n2h32(30))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,4,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,4,2,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,4,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,4,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,1,4,16,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,1,4,8,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,2,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(43),n2h32(31))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,2,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(44),n2h32(32))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,4,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,2,4,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,2,8,1,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(33))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,16,1,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(48),n2h32(34))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,1,8,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(35))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,1,8,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,8,16,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(36))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,8,16,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,8,2,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(37))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,1,8,4,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,16,4,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,16,8,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(38))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,1,16,2,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(57),n2h32(39))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,1,16,8,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,16,2,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(40))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,16,4,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,0,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,0,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,0,G2H16(3),n2h16(3))
  call Hloop_AV_Q(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,0,G2H16(4),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex4(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(3),40,0,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),36,0,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(9),ex3(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,0,G2H16(7),n2h16(7))
  call Hloop_QV_A(ntryL,G1H32(10),ex3(:),G1H16(3),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),36,0,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex2(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(13),ex4(:),G1H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),40,0,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(11),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(5),36,0,G2H16(12),n2h16(12))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(10),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(11),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(12),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_UV_W(ntryL,G1H32(25),32,ex4(:),8,G2H16(13),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_VA_Q(ntryL,G1H32(26),ex2(:),G1H16(13),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(13),34,0,G2H16(14),n2h16(13))
  call Hloop_AV_Q(ntryL,G1H32(27),ex3(:),G1H16(13),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(13),36,0,G2H16(15),n2h16(14))
  call Hloop_QA_V(ntryL,G1H32(28),ex2(:),G1H16(13),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_VA_Q(ntryL,G1H32(29),ex2(:),G1H16(14),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(14),34,0,G2H16(16),n2h16(15))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_UV_W(ntryL,G1H32(31),32,ex4(:),8,G2H16(17),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(15),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(15),34,0,G2H16(18),n2h16(16))
  call Hloop_AV_Q(ntryL,G1H32(33),ex3(:),G1H16(15),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(15),36,0,G2H16(19),n2h16(17))
  call Hloop_VA_Q(ntryL,G1H32(34),ex2(:),G1H16(15),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(15),34,0,G2H16(20),n2h16(18))
  call Hloop_QA_V(ntryL,G1H32(35),ex2(:),G1H16(15),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_QA_V(ntryL,G1H32(36),ex2(:),G1H16(16),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_VQ_A(ntryL,G1H32(37),ex1(:),G1H16(17),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(21),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(17),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(22),n2h16(20))
  call Hloop_VQ_A(ntryL,G1H32(39),ex1(:),G1H16(17),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(23),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(17),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(24),n2h16(22))
  call Hloop_VQ_A(ntryL,G1H32(41),ex1(:),G1H16(17),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(25),n2h16(23))
  call Hloop_VQ_A(ntryL,G1H32(42),ex1(:),G1H16(17),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H16(17),33,0,G2H16(26),n2h16(24))
  call Hloop_QV_A(ntryL,G1H32(43),ex3(:),G1H16(17),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(17),36,0,G2H16(27),n2h16(25))
  call Hloop_QV_A(ntryL,G1H32(44),ex3(:),G1H16(17),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(17),36,0,G2H16(28),n2h16(26))
  call Hloop_VA_Q(ntryL,G1H32(45),ex2(:),G1H16(17),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(17),34,0,G2H16(29),n2h16(27))
  call Hloop_VA_Q(ntryL,G1H32(46),ex2(:),G1H16(17),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(17),34,0,G2H16(30),n2h16(28))
  call Hloop_QA_V(ntryL,G1H32(47),ex2(:),G1H16(17),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_QA_V(ntryL,G1H32(48),ex2(:),G1H16(18),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H32(49),ex1(:),G1H16(19),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_VQ_A(ntryL,G1H32(50),ex1(:),G1H16(20),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H16(20),33,0,G2H16(31),n2h16(29))
  call Hloop_AQ_V(ntryL,G1H32(51),ex1(:),G1H16(20),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_VQ_A(ntryL,G1H32(52),ex1(:),G1H16(21),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(32),n2h16(30))
  call Hloop_AQ_V(ntryL,G1H32(53),ex1(:),G1H16(21),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_VQ_A(ntryL,G1H32(54),ex1(:),G1H16(22),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H16(22),33,0,G2H16(33),n2h16(31))
  call Hloop_VQ_A(ntryL,G1H32(55),ex1(:),G1H16(22),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(22),33,0,G2H16(34),n2h16(32))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(22),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_V(ntryL,G1H32(57),ex1(:),G1H16(23),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_VQ_A(ntryL,G1H32(58),ex1(:),G1H16(24),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H16(24),33,0,G2H16(35),n2h16(33))
  call Hloop_AQ_V(ntryL,G1H32(59),ex1(:),G1H16(24),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_VQ_A(ntryL,G1H32(60),ex1(:),G1H16(25),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(36),n2h16(34))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),16,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(4),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(5),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(5),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(31),G1H16(32),G1H16(33),G1H16(34),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(3),mass5set(:,1),  & 
G1H16(35),G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),16)
  call HG1shiftOLR(G1H16(36),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(8),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(9),n2h8(4))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex2(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(45),G1H16(46),G1H16(47),G1H16(48),G1H16(49),G1H16(50),16)
  call HG1shiftOLR(G1H16(46),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(6),mass5set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G1H16(56),16)
  call HG1shiftOLR(G1H16(52),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(11),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(12),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(13),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(14),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(15),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(16),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(17),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(18),n2h8(12))
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(7),mass5set(:,1),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(6),16,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(8),mass5set(:,1),  & 
G1H16(11),G1H16(12),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(12),16,16)
  call Hloop_AQ_V(ntryL,G2H16(15),ex1(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_UV_W(ntryL,G1H16(13),34,ex4(:),8,G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(9),mass5set(:,1),  & 
G1H16(13),G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),16)
  call HG1shiftOLR(G1H16(61),8,16)
  call Hloop_UV_W(ntryL,G1H16(14),34,ex5(:),16,G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(10),mass5set(:,1),  & 
G1H16(14),G1H16(66),G1H16(67),G1H16(68),G1H16(69),G1H16(70),16)
  call HG1shiftOLR(G1H16(66),16,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(8),mass5set(:,1),  & 
G1H16(71),G1H16(72),G1H16(73),G1H16(74),G1H16(75),G1H16(76),16)
  call HG1shiftOLR(G1H16(72),8,16)
  call Hloop_AQ_V(ntryL,G2H16(19),ex1(:),G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(11),mass5set(:,1),  & 
G1H16(77),G1H16(78),G1H16(79),G1H16(80),G1H16(81),G1H16(82),16)
  call HG1shiftOLR(G1H16(78),16,16)
  call Hloop_UV_W(ntryL,G1H16(15),34,ex4(:),8,G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_UV_W(ntryL,G1H16(16),34,ex5(:),16,G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(12),mass5set(:,1),  & 
G1H16(15),G1H16(16),G1H16(83),G1H16(84),G1H16(85),G1H16(86),16)
  call HG1shiftOLR(G1H16(16),16,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(12),mass5set(:,1),  & 
G1H16(87),G1H16(88),G1H16(89),G1H16(90),G1H16(91),G1H16(92),16)
  call HG1shiftOLR(G1H16(88),8,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(13),mass5set(:,1),  & 
G1H16(93),G1H16(94),G1H16(95),G1H16(96),G1H16(97),G1H16(98),16)
  call HG1shiftOLR(G1H16(94),16,16)
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(14),mass5set(:,1),  & 
G1H16(99),G1H16(100),G1H16(101),G1H16(102),G1H16(103),G1H16(104),16)
  call HG1shiftOLR(G1H16(100),8,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(14),mass5set(:,1),  & 
G1H16(105),G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),16)
  call HG1shiftOLR(G1H16(106),2,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(13),mass5set(:,1),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G1H16(116),16)
  call HG1shiftOLR(G1H16(112),2,16)
  call Hloop_QA_V(ntryL,G2H16(27),ex2(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G2H16(28),ex2(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(15),mass5set(:,1),  & 
G1H16(117),G1H16(118),G1H16(119),G1H16(120),G1H16(121),G1H16(122),16)
  call HG1shiftOLR(G1H16(118),16,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(16),mass5set(:,1),  & 
G1H16(123),G1H16(124),G1H16(125),G1H16(126),G1H16(127),G1H16(128),16)
  call HG1shiftOLR(G1H16(124),8,16)
  call Hloop_UV_W(ntryL,G1H16(17),34,ex4(:),8,G2H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_UV_W(ntryL,G1H16(18),34,ex5(:),16,G2H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_UV_W(ntryL,G1H16(19),33,ex4(:),8,G2H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(17),mass5set(:,1),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(129),G1H16(130),G1H16(131),16)
  call HG1shiftOLR(G1H16(18),16,16)
  call Hloop_UV_W(ntryL,G1H16(20),33,ex4(:),8,G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(18),mass5set(:,1),  & 
G1H16(20),G1H16(132),G1H16(133),G1H16(134),G1H16(135),G1H16(136),16)
  call HG1shiftOLR(G1H16(132),2,16)
  call Hloop_UV_W(ntryL,G1H16(21),33,ex4(:),8,G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(17),mass5set(:,1),  & 
G1H16(21),G1H16(137),G1H16(138),G1H16(139),G1H16(140),G1H16(141),16)
  call HG1shiftOLR(G1H16(137),2,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(19),mass5set(:,1),  & 
G1H16(142),G1H16(143),G1H16(144),G1H16(145),G1H16(146),G1H16(147),16)
  call HG1shiftOLR(G1H16(143),8,16)
  call Hloop_UV_W(ntryL,G1H16(22),33,ex5(:),16,G2H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_UV_W(ntryL,G1H16(23),33,ex5(:),16,G2H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(20),mass5set(:,1),  & 
G1H16(22),G1H16(23),G1H16(148),G1H16(149),G1H16(150),G1H16(151),16)
  call HG1shiftOLR(G1H16(23),2,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,ex5(:),16,G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(19),mass5set(:,1),  & 
G1H16(24),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G1H16(156),16)
  call HG1shiftOLR(G1H16(152),2,16)
  call Hloop_AV_Q(ntryL,G1H16(25),ex3(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(35),n2h8(13))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-16,0,G2H16(1),n2h16(35))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AV_Q(ntryL,G1H16(28),ex3(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(37),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(29),ex3(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(38),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(30),ex3(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(39),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(40),n2h8(17))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,0,G2H16(2),n2h16(36))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_AV_Q(ntryL,G1H16(32),ex4(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(42),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(33),ex4(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(43),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(34),ex4(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(44),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(35),ex5(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),52,0,G2H8(45),n2h8(21))
call HGT_OLR(G1H16(36),1,1,16)
call HGT_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(36),-8,0,G2H16(3),n2h16(37))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QV_A(ntryL,G1H16(38),ex5(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),52,0,G2H8(47),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),52,0,G2H8(48),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),52,0,G2H8(49),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(50),n2h8(25))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,0,G2H16(4),n2h16(38))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QV_A(ntryL,G1H16(42),ex3(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(52),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(43),ex3(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(53),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(44),ex3(:),G1H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(54),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(45),ex4(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(55),n2h8(29))
call HGT_OLR(G1H16(46),1,1,16)
call HGT_invQ_OLR(G1H16(46),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(46),-16,0,G2H16(5),n2h16(39))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(56),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_QV_A(ntryL,G1H16(48),ex4(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(57),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(49),ex4(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(58),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(50),ex4(:),G1H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(59),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H16(51),ex5(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(60),n2h8(33))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(52),-8,0,G2H16(6),n2h16(40))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AV_Q(ntryL,G1H16(54),ex5(:),G1H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(62),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(55),ex5(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(63),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(56),ex5(:),G1H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(64),n2h8(36))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(65),n2h8(37))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(6),-16,ex5(:),16,G2H8(66),m3h2x8(:,66),heltab2x16(:,:,66))
call signflip_OLR(G2H8(66))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(67),n2h8(38))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(68),n2h8(39))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(69),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(70),n2h8(41))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(12),-16,ex5(:),16,G2H8(71),m3h2x8(:,71),heltab2x16(:,:,71))
call signflip_OLR(G2H8(71))
  call Hloop_AV_Q(ntryL,G1H16(58),ex3(:),G1H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(72),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H16(59),ex3(:),G1H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(73),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(74),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H16(13),ex5(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(75),n2h8(45))
call HGT_raise_alpha_OLR(G1H16(61),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(61),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(61),-8,ex4(:),8,G2H8(76),m3h2x8(:,76),heltab2x16(:,:,76))
call signflip_OLR(G2H8(76))
  call Hloop_AV_Q(ntryL,G1H16(63),ex5(:),G1H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(77),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(64),ex5(:),G1H8(1),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(78),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(65),ex5(:),G1H8(1),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(79),n2h8(48))
  call Hloop_VA_Q(ntryL,G1H16(14),ex2(:),G1H8(1),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(80),n2h8(49))
call HGT_raise_alpha_OLR(G1H16(66),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(66),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(66),-16,ex5(:),16,G2H8(81),m3h2x8(:,81),heltab2x16(:,:,81))
call signflip_OLR(G2H8(81))
  call Hloop_VA_Q(ntryL,G1H16(68),ex2(:),G1H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(82),n2h8(50))
  call Hloop_VA_Q(ntryL,G1H16(69),ex2(:),G1H8(1),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(83),n2h8(51))
  call Hloop_VA_Q(ntryL,G1H16(70),ex2(:),G1H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(84),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H16(71),ex3(:),G1H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(85),n2h8(53))
call HGT_raise_alpha_OLR(G1H16(72),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(72),-8,ex4(:),8,G2H8(86),m3h2x8(:,86),heltab2x16(:,:,86))
call signflip_OLR(G2H8(86))
  call Hloop_AV_Q(ntryL,G1H16(74),ex3(:),G1H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(87),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(75),ex3(:),G1H8(1),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(88),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(76),ex3(:),G1H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(89),n2h8(56))
  call Hloop_AV_Q(ntryL,G1H16(77),ex4(:),G1H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(90),n2h8(57))
call HGT_raise_alpha_OLR(G1H16(78),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(78),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(78),-16,ex5(:),16,G2H8(91),m3h2x8(:,91),heltab2x16(:,:,91))
call signflip_OLR(G2H8(91))
  call Hloop_AV_Q(ntryL,G1H16(80),ex4(:),G1H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(92),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H16(81),ex4(:),G1H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(93),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(82),ex4(:),G1H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(94),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(95),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(16),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(16),-16,ex5(:),16,G2H8(96),m3h2x8(:,96),heltab2x16(:,:,96))
call signflip_OLR(G2H8(96))
  call Hloop_QV_A(ntryL,G1H16(84),ex3(:),G1H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(97),n2h8(62))
  call Hloop_QV_A(ntryL,G1H16(85),ex3(:),G1H8(1),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(98),n2h8(63))
  call Hloop_QV_A(ntryL,G1H16(86),ex3(:),G1H8(1),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(99),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(87),ex3(:),G1H8(1),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(100),n2h8(65))
call HGT_raise_alpha_OLR(G1H16(88),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(88),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(88),-8,ex4(:),8,G2H8(101),m3h2x8(:,101),heltab2x16(:,:,101))
call signflip_OLR(G2H8(101))
  call Hloop_QV_A(ntryL,G1H16(90),ex3(:),G1H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(102),n2h8(66))
  call Hloop_QV_A(ntryL,G1H16(91),ex3(:),G1H8(1),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(103),n2h8(67))
  call Hloop_QV_A(ntryL,G1H16(92),ex3(:),G1H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(104),n2h8(68))
  call Hloop_QV_A(ntryL,G1H16(93),ex3(:),G1H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(105),n2h8(69))
call HGT_raise_alpha_OLR(G1H16(94),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(94),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(94),-16,ex5(:),16,G2H8(106),m3h2x8(:,106),heltab2x16(:,:,106))
call signflip_OLR(G2H8(106))
  call Hloop_QV_A(ntryL,G1H16(96),ex3(:),G1H8(1),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(107),n2h8(70))
  call Hloop_QV_A(ntryL,G1H16(97),ex3(:),G1H8(1),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(108),n2h8(71))
  call Hloop_QV_A(ntryL,G1H16(98),ex3(:),G1H8(1),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(109),n2h8(72))
  call Hloop_QV_A(ntryL,G1H16(99),ex3(:),G1H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(110),n2h8(73))
call HGT_raise_alpha_OLR(G1H16(100),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(100),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(100),-8,ex4(:),8,G2H8(111),m3h2x8(:,111),heltab2x16(:,:,111))
call signflip_OLR(G2H8(111))
  call Hloop_QV_A(ntryL,G1H16(102),ex3(:),G1H8(1),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(112),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(103),ex3(:),G1H8(1),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(113),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(104),ex3(:),G1H8(1),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(114),n2h8(76))
  call Hloop_QV_A(ntryL,G1H16(105),ex3(:),G1H8(1),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(115),n2h8(77))
call HGT_raise_alpha_OLR(G1H16(106),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(106),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(106),ex2(:),G1H8(1),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_QV_A(ntryL,G1H16(108),ex3(:),G1H8(2),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(2),37,0,G2H8(116),n2h8(78))
  call Hloop_QV_A(ntryL,G1H16(109),ex3(:),G1H8(2),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(2),37,0,G2H8(117),n2h8(79))
  call Hloop_QV_A(ntryL,G1H16(110),ex3(:),G1H8(2),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(2),37,0,G2H8(118),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(111),ex3(:),G1H8(2),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(2),37,0,G2H8(119),n2h8(81))
call HGT_raise_alpha_OLR(G1H16(112),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(112),ex2(:),G1H8(2),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QV_A(ntryL,G1H16(114),ex3(:),G1H8(3),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(120),n2h8(82))
  call Hloop_QV_A(ntryL,G1H16(115),ex3(:),G1H8(3),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(121),n2h8(83))
  call Hloop_QV_A(ntryL,G1H16(116),ex3(:),G1H8(3),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(122),n2h8(84))
  call Hloop_AV_Q(ntryL,G1H16(117),ex3(:),G1H8(3),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(123),n2h8(85))
call HGT_raise_alpha_OLR(G1H16(118),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(118),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(118),-16,ex5(:),16,G2H8(124),m3h2x8(:,126),heltab2x16(:,:,126))
call signflip_OLR(G2H8(124))
  call Hloop_AV_Q(ntryL,G1H16(120),ex3(:),G1H8(3),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(125),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H16(121),ex3(:),G1H8(3),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(126),n2h8(87))
  call Hloop_AV_Q(ntryL,G1H16(122),ex3(:),G1H8(3),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(127),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H16(123),ex3(:),G1H8(3),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(128),n2h8(89))
call HGT_raise_alpha_OLR(G1H16(124),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(124),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(124),-8,ex4(:),8,G2H8(129),m3h2x8(:,131),heltab2x16(:,:,131))
call signflip_OLR(G2H8(129))
  call Hloop_AV_Q(ntryL,G1H16(126),ex3(:),G1H8(3),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(130),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H16(127),ex3(:),G1H8(3),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(131),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H16(128),ex3(:),G1H8(3),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(132),n2h8(92))
  call Hloop_QV_A(ntryL,G1H16(17),ex4(:),G1H8(3),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(133),n2h8(93))
call HGT_raise_alpha_OLR(G1H16(18),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(18),-16,ex5(:),16,G2H8(134),m3h2x8(:,136),heltab2x16(:,:,136))
call signflip_OLR(G2H8(134))
  call Hloop_QV_A(ntryL,G1H16(129),ex4(:),G1H8(3),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(135),n2h8(94))
  call Hloop_QV_A(ntryL,G1H16(130),ex4(:),G1H8(3),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(136),n2h8(95))
  call Hloop_QV_A(ntryL,G1H16(131),ex4(:),G1H8(3),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(137),n2h8(96))
  call Hloop_QV_A(ntryL,G1H16(20),ex4(:),G1H8(3),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(138),n2h8(97))
call HGT_raise_alpha_OLR(G1H16(132),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(132),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(132),ex2(:),G1H8(3),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_QV_A(ntryL,G1H16(134),ex4(:),G1H8(4),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(139),n2h8(98))
  call Hloop_QV_A(ntryL,G1H16(135),ex4(:),G1H8(4),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(140),n2h8(99))
  call Hloop_QV_A(ntryL,G1H16(136),ex4(:),G1H8(4),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(141),n2h8(100))
  call Hloop_QV_A(ntryL,G1H16(21),ex4(:),G1H8(4),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(142),n2h8(101))
call HGT_raise_alpha_OLR(G1H16(137),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(137),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(137),ex2(:),G1H8(4),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_QV_A(ntryL,G1H16(139),ex4(:),G1H8(5),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(143),n2h8(102))
  call Hloop_QV_A(ntryL,G1H16(140),ex4(:),G1H8(5),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(144),n2h8(103))
  call Hloop_QV_A(ntryL,G1H16(141),ex4(:),G1H8(5),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(145),n2h8(104))
  call Hloop_QV_A(ntryL,G1H16(142),ex5(:),G1H8(5),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(146),n2h8(105))
call HGT_raise_alpha_OLR(G1H16(143),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(143),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(143),-8,ex4(:),8,G2H8(147),m3h2x8(:,151),heltab2x16(:,:,151))
call signflip_OLR(G2H8(147))
  call Hloop_QV_A(ntryL,G1H16(145),ex5(:),G1H8(5),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(148),n2h8(106))
  call Hloop_QV_A(ntryL,G1H16(146),ex5(:),G1H8(5),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(149),n2h8(107))
  call Hloop_QV_A(ntryL,G1H16(147),ex5(:),G1H8(5),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(150),n2h8(108))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(5),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(151),n2h8(109))
call HGT_raise_alpha_OLR(G1H16(23),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(23),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(23),ex2(:),G1H8(5),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(149),ex5(:),G1H8(6),m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(152),n2h8(110))
  call Hloop_QV_A(ntryL,G1H16(150),ex5(:),G1H8(6),m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(153),n2h8(111))
  call Hloop_QV_A(ntryL,G1H16(151),ex5(:),G1H8(6),m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(154),n2h8(112))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(6),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(155),n2h8(113))
call HGT_raise_alpha_OLR(G1H16(152),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(152),ex2(:),G1H8(6),m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_QV_A(ntryL,G1H16(154),ex5(:),G1H8(7),m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(156),n2h8(114))
  call Hloop_QV_A(ntryL,G1H16(155),ex5(:),G1H8(7),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(157),n2h8(115))
  call Hloop_QV_A(ntryL,G1H16(156),ex5(:),G1H8(7),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(158),n2h8(116))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(21),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(22),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(22),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(23),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(23),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(24),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(25),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(26),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(26),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(25),mass5set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(27),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(27),mass5set(:,1),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(28),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(28),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(29),mass5set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(29),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(30),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(30),mass5set(:,1),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(31),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(32),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),16,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(33),mass5set(:,1),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(34),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(35),mass5set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),4,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(36),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(37),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(38),mass5set(:,1),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(32),mass5set(:,1),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),4,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(36),mass5set(:,1),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),4,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(39),mass5set(:,1),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),16,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(18),mass5set(:,1),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(39),mass5set(:,1),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(20),mass5set(:,1),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),4,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(40),mass5set(:,1),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),8,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(40),mass5set(:,1),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),4,8)
  call Hloop_AQ_V(ntryL,G2H8(35),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(38),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(39),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(45),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(50),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(53),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(54),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(55),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(58),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(59),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(60),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(63),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(64),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(7),mass5set(:,1),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),16,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(41),mass5set(:,1),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),16,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(42),mass5set(:,1),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),16,8)
  call Hloop_AQ_V(ntryL,G2H8(70),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(73),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(74),ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(9),mass5set(:,1),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(43),mass5set(:,1),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(79),RedSet_5(44),mass5set(:,1),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(80),RedSet_5(10),mass5set(:,1),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),16,8)
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(45),mass5set(:,1),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),16,8)
  call Hotf_5pt_reduction(G2H8(84),RedSet_5(46),mass5set(:,1),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),16,8)
  call Hloop_AQ_V(ntryL,G2H8(85),ex1(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(88),ex1(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(89),ex1(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(90),RedSet_5(11),mass5set(:,1),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),16,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(47),mass5set(:,1),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),16,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(48),mass5set(:,1),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),16,8)
  call Hloop_QA_V(ntryL,G2H8(95),ex2(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(98),ex2(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(99),ex2(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G2H8(100),ex2(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G2H8(103),ex2(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H8(104),ex2(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(13),mass5set(:,1),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),16,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(49),mass5set(:,1),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),16,8)
  call Hotf_5pt_reduction(G2H8(109),RedSet_5(50),mass5set(:,1),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),16,8)
  call Hotf_5pt_reduction(G2H8(110),RedSet_5(14),mass5set(:,1),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),8,8)
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(51),mass5set(:,1),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),8,8)
  call Hotf_5pt_reduction(G2H8(114),RedSet_5(52),mass5set(:,1),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),8,8)
  call Hotf_5pt_reduction(G2H8(115),RedSet_5(14),mass5set(:,1),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),2,8)
  call Hotf_5pt_reduction(G2H8(117),RedSet_5(53),mass5set(:,1),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),2,8)
  call Hotf_5pt_reduction(G2H8(118),RedSet_5(54),mass5set(:,1),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(332),2,8)
  call Hotf_5pt_reduction(G2H8(119),RedSet_5(13),mass5set(:,1),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),2,8)
  call Hotf_5pt_reduction(G2H8(121),RedSet_5(55),mass5set(:,1),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),G1H8(348),8)
  call HG1shiftOLR(G1H8(344),2,8)
  call Hotf_5pt_reduction(G2H8(122),RedSet_5(54),mass5set(:,1),  & 
G1H8(349),G1H8(350),G1H8(351),G1H8(352),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(350),2,8)
  call Hotf_5pt_reduction(G2H8(123),RedSet_5(15),mass5set(:,1),  & 
G1H8(355),G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),8)
  call HG1shiftOLR(G1H8(356),16,8)
  call Hotf_5pt_reduction(G2H8(126),RedSet_5(47),mass5set(:,1),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),8)
  call HG1shiftOLR(G1H8(362),16,8)
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(56),mass5set(:,1),  & 
G1H8(367),G1H8(368),G1H8(369),G1H8(370),G1H8(371),G1H8(372),8)
  call HG1shiftOLR(G1H8(368),16,8)
  call Hotf_5pt_reduction(G2H8(128),RedSet_5(16),mass5set(:,1),  & 
G1H8(373),G1H8(374),G1H8(375),G1H8(376),G1H8(377),G1H8(378),8)
  call HG1shiftOLR(G1H8(374),8,8)
  call Hotf_5pt_reduction(G2H8(131),RedSet_5(43),mass5set(:,1),  & 
G1H8(379),G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(380),8,8)
  call Hotf_5pt_reduction(G2H8(132),RedSet_5(57),mass5set(:,1),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),8,8)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(17),mass5set(:,1),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(392),16,8)
  call Hotf_5pt_reduction(G2H8(136),RedSet_5(49),mass5set(:,1),  & 
G1H8(397),G1H8(398),G1H8(399),G1H8(400),G1H8(401),G1H8(402),8)
  call HG1shiftOLR(G1H8(398),16,8)
  call Hotf_5pt_reduction(G2H8(137),RedSet_5(58),mass5set(:,1),  & 
G1H8(403),G1H8(404),G1H8(405),G1H8(406),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(404),16,8)
  call Hotf_5pt_reduction(G2H8(138),RedSet_5(18),mass5set(:,1),  & 
G1H8(409),G1H8(410),G1H8(411),G1H8(412),G1H8(413),G1H8(414),8)
  call HG1shiftOLR(G1H8(410),2,8)
  call Hotf_5pt_reduction(G2H8(140),RedSet_5(59),mass5set(:,1),  & 
G1H8(415),G1H8(416),G1H8(417),G1H8(418),G1H8(419),G1H8(420),8)
  call HG1shiftOLR(G1H8(416),2,8)
  call Hotf_5pt_reduction(G2H8(141),RedSet_5(60),mass5set(:,1),  & 
G1H8(421),G1H8(422),G1H8(423),G1H8(424),G1H8(425),G1H8(426),8)
  call HG1shiftOLR(G1H8(422),2,8)
  call Hotf_5pt_reduction(G2H8(142),RedSet_5(17),mass5set(:,1),  & 
G1H8(427),G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(428),2,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(55),mass5set(:,1),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),2,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(60),mass5set(:,1),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),G1H8(444),8)
  call HG1shiftOLR(G1H8(440),2,8)
  call Hotf_5pt_reduction(G2H8(146),RedSet_5(19),mass5set(:,1),  & 
G1H8(445),G1H8(446),G1H8(447),G1H8(448),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(446),8,8)
  call Hotf_5pt_reduction(G2H8(149),RedSet_5(51),mass5set(:,1),  & 
G1H8(451),G1H8(452),G1H8(453),G1H8(454),G1H8(455),G1H8(456),8)
  call HG1shiftOLR(G1H8(452),8,8)
  call Hotf_5pt_reduction(G2H8(150),RedSet_5(61),mass5set(:,1),  & 
G1H8(457),G1H8(458),G1H8(459),G1H8(460),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(458),8,8)
  call Hotf_5pt_reduction(G2H8(151),RedSet_5(20),mass5set(:,1),  & 
G1H8(463),G1H8(464),G1H8(465),G1H8(466),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(464),2,8)
  call Hotf_5pt_reduction(G2H8(153),RedSet_5(59),mass5set(:,1),  & 
G1H8(469),G1H8(470),G1H8(471),G1H8(472),G1H8(473),G1H8(474),8)
  call HG1shiftOLR(G1H8(470),2,8)
  call Hotf_5pt_reduction(G2H8(154),RedSet_5(62),mass5set(:,1),  & 
G1H8(475),G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(476),2,8)
  call Hotf_5pt_reduction(G2H8(155),RedSet_5(19),mass5set(:,1),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),2,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(53),mass5set(:,1),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),G1H8(492),8)
  call HG1shiftOLR(G1H8(488),2,8)
  call Hotf_5pt_reduction(G2H8(158),RedSet_5(62),mass5set(:,1),  & 
G1H8(493),G1H8(494),G1H8(495),G1H8(496),G1H8(497),G1H8(498),8)
  call HG1shiftOLR(G1H8(494),2,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(217),[G1H8(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(223),[G1H8(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(235),[G1H8(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(241),[G1H8(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(253),[G1H8(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(259),[G1H8(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(271),[G1H8(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(277),[G1H8(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(289),[G1H8(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(295),[G1H8(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(307),[G1H8(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(313),[G1H8(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(331),[G1H8(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(343),[G1H8(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(349),[G1H8(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(361),[G1H8(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(367),[G1H8(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(379),[G1H8(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(385),[G1H8(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(397),[G1H8(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(403),[G1H8(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(415),[G1H8(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(421),[G1H8(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(433),[G1H8(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(439),[G1H8(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(451),[G1H8(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(457),[G1H8(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(469),[G1H8(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(475),[G1H8(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(487),[G1H8(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(493),[G1H8(486)])
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(31),n2h4(1))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,0,G2H8(1),n2h8(117))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(33),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(34),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(35),n2h4(4))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,0,G2H8(2),n2h8(118))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(37),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(38),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(39),n2h4(7))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-8,0,G2H8(3),n2h8(119))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(41),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(42),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(43),n2h4(10))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,0,G2H8(4),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(45),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(46),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(47),n2h4(13))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,0,G2H8(5),n2h8(121))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(49),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(50),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(51),n2h4(16))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-16,0,G2H8(6),n2h8(122))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(53),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(54),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(55),n2h4(19))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,0,G2H8(7),n2h8(123))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(57),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(58),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(59),n2h4(22))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-16,0,G2H8(8),n2h8(124))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(61),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(62),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(55),ex4(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(63),n2h4(25))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-4,0,G2H8(9),n2h8(125))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(59),ex4(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(65),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(60),ex4(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(66),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(67),n2h4(28))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,0,G2H8(10),n2h8(126))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_VQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(69),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(66),ex1(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(70),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(71),n2h4(31))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-8,0,G2H8(11),n2h8(127))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(73),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(74),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(75),n2h4(34))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-4,0,G2H8(12),n2h8(128))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(77),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(78),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(79),n2h4(37))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-16,0,G2H8(13),n2h8(129))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(83),ex3(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(81),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(82),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(85),ex3(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(83),n2h4(40))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,0,G2H8(14),n2h8(130))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(89),ex3(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(85),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(90),ex3(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(86),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(91),ex4(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(87),n2h4(43))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-16,0,G2H8(15),n2h8(131))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(89),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(90),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(97),ex4(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(91),n2h4(46))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-4,0,G2H8(16),n2h8(132))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_AV_Q(ntryL,G1H8(101),ex4(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(93),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(102),ex4(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(94),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(95),n2h4(49))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,0,G2H8(17),n2h8(133))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(97),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(98),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(109),ex5(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(99),n2h4(52))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-4,0,G2H8(18),n2h8(134))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_AV_Q(ntryL,G1H8(113),ex5(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(101),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(114),ex5(:),G1H4(1),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(102),n2h4(54))
  call Hloop_UV_W(ntryL,G1H8(115),37,ex4(:),8,G2H4(103),m3h2x4(:,103),heltab2x8(:,:,103))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(116),-16,0,G2H8(19),n2h8(135))
  call Hloop_QV_A(ntryL,G2H8(19),ex5(:),G2H4(104),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_UV_W(ntryL,G1H8(119),37,ex4(:),8,G2H4(105),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_UV_W(ntryL,G1H8(120),37,ex4(:),8,G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_VQ_A(ntryL,G1H8(121),ex1(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(107),n2h4(55))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-16,0,G2H8(20),n2h8(136))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(108),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_VQ_A(ntryL,G1H8(125),ex1(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(109),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H8(126),ex1(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(110),n2h4(57))
  call Hloop_UV_W(ntryL,G1H8(127),50,ex4(:),8,G2H4(111),m3h2x4(:,111),heltab2x8(:,:,111))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-4,0,G2H8(21),n2h8(137))
  call Hloop_AV_Q(ntryL,G2H8(21),ex3(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_UV_W(ntryL,G1H8(131),50,ex4(:),8,G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_UV_W(ntryL,G1H8(132),50,ex4(:),8,G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_UV_W(ntryL,G1H8(133),37,ex5(:),16,G2H4(115),m3h2x4(:,115),heltab2x8(:,:,115))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(134),-8,0,G2H8(22),n2h8(138))
  call Hloop_QV_A(ntryL,G2H8(22),ex4(:),G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_UV_W(ntryL,G1H8(137),37,ex5(:),16,G2H4(117),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_UV_W(ntryL,G1H8(138),37,ex5(:),16,G2H4(118),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_UV_W(ntryL,G1H8(139),42,ex5(:),16,G2H4(119),m3h2x4(:,119),heltab2x8(:,:,119))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(140),-4,0,G2H8(23),n2h8(139))
  call Hloop_AV_Q(ntryL,G2H8(23),ex3(:),G2H4(120),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_UV_W(ntryL,G1H8(143),42,ex5(:),16,G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_UV_W(ntryL,G1H8(144),42,ex5(:),16,G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_VQ_A(ntryL,G1H8(145),ex1(:),G1H4(1),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(123),n2h4(58))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(146),-8,0,G2H8(24),n2h8(140))
  call Hloop_AV_Q(ntryL,G2H8(24),ex4(:),G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_VQ_A(ntryL,G1H8(149),ex1(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(125),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H8(150),ex1(:),G1H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(126),n2h4(60))
  call Hloop_UV_W(ntryL,G1H8(151),38,ex4(:),8,G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(152),-16,0,G2H8(25),n2h8(141))
  call Hloop_AV_Q(ntryL,G2H8(25),ex5(:),G2H4(128),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_UV_W(ntryL,G1H8(155),38,ex4(:),8,G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_UV_W(ntryL,G1H8(156),38,ex4(:),8,G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H8(157),38,ex5(:),16,G2H4(131),m3h2x4(:,131),heltab2x8(:,:,131))
call HGT_OLR(G1H8(158),1,1,8)
call HGT_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(158),-8,0,G2H8(26),n2h8(142))
  call Hloop_AV_Q(ntryL,G2H8(26),ex4(:),G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_UV_W(ntryL,G1H8(161),38,ex5(:),16,G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_UV_W(ntryL,G1H8(162),38,ex5(:),16,G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_VQ_A(ntryL,G1H8(163),ex1(:),G1H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(135),n2h4(61))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(164),-4,0,G2H8(27),n2h8(143))
  call Hloop_AV_Q(ntryL,G2H8(27),ex3(:),G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_VQ_A(ntryL,G1H8(167),ex1(:),G1H4(1),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(137),n2h4(62))
  call Hloop_VQ_A(ntryL,G1H8(168),ex1(:),G1H4(1),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(138),n2h4(63))
  call Hloop_VQ_A(ntryL,G1H8(169),ex1(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(139),n2h4(64))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(170),-4,0,G2H8(28),n2h8(144))
  call Hloop_AV_Q(ntryL,G2H8(28),ex3(:),G2H4(140),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_VQ_A(ntryL,G1H8(173),ex1(:),G1H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(141),n2h4(65))
  call Hloop_VQ_A(ntryL,G1H8(174),ex1(:),G1H4(1),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(142),n2h4(66))
  call Hloop_VA_Q(ntryL,G1H8(175),ex2(:),G1H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(143),n2h4(67))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-16,0,G2H8(29),n2h8(145))
  call Hloop_QV_A(ntryL,G2H8(29),ex5(:),G2H4(144),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_VA_Q(ntryL,G1H8(179),ex2(:),G1H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(145),n2h4(68))
  call Hloop_VA_Q(ntryL,G1H8(180),ex2(:),G1H4(1),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(146),n2h4(69))
  call Hloop_UV_W(ntryL,G1H8(181),41,ex5(:),16,G2H4(147),m3h2x4(:,147),heltab2x8(:,:,147))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(182),-4,0,G2H8(30),n2h8(146))
  call Hloop_QV_A(ntryL,G2H8(30),ex3(:),G2H4(148),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_UV_W(ntryL,G1H8(185),41,ex5(:),16,G2H4(149),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_UV_W(ntryL,G1H8(186),41,ex5(:),16,G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_VA_Q(ntryL,G1H8(187),ex2(:),G1H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(151),n2h4(70))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(188),-4,0,G2H8(31),n2h8(147))
  call Hloop_QV_A(ntryL,G2H8(31),ex3(:),G2H4(152),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_VA_Q(ntryL,G1H8(191),ex2(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(153),n2h4(71))
  call Hloop_VA_Q(ntryL,G1H8(192),ex2(:),G1H4(1),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(154),n2h4(72))
  call Hloop_UV_W(ntryL,G1H8(193),49,ex4(:),8,G2H4(155),m3h2x4(:,155),heltab2x8(:,:,155))
call HGT_OLR(G1H8(194),1,1,8)
call HGT_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(194),-4,0,G2H8(32),n2h8(148))
  call Hloop_QV_A(ntryL,G2H8(32),ex3(:),G2H4(156),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_UV_W(ntryL,G1H8(197),49,ex4(:),8,G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_UV_W(ntryL,G1H8(198),49,ex4(:),8,G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_VA_Q(ntryL,G1H8(199),ex2(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(159),n2h4(73))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(200),-8,0,G2H8(33),n2h8(149))
  call Hloop_QV_A(ntryL,G2H8(33),ex4(:),G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_VA_Q(ntryL,G1H8(203),ex2(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(161),n2h4(74))
  call Hloop_VA_Q(ntryL,G1H8(204),ex2(:),G1H4(1),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(162),n2h4(75))
  call Hloop_VA_Q(ntryL,G1H8(205),ex2(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(163),n2h4(76))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(206),-4,0,G2H8(34),n2h8(150))
  call Hloop_QV_A(ntryL,G2H8(34),ex3(:),G2H4(164),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_VA_Q(ntryL,G1H8(209),ex2(:),G1H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(165),n2h4(77))
  call Hloop_VA_Q(ntryL,G1H8(210),ex2(:),G1H4(1),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(166),n2h4(78))
  call Hloop_QV_A(ntryL,G1H8(211),ex3(:),G1H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(167),n2h4(79))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(212),-16,ex5(:),16,G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
call signflip_OLR(G2H4(168))
  call Hloop_QV_A(ntryL,G1H8(217),ex3(:),G1H4(1),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(169),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(223),ex3(:),G1H4(1),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(170),n2h4(81))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(218),-16,ex5(:),16,G2H4(171),m3h2x4(:,171),heltab2x8(:,:,171))
call signflip_OLR(G2H4(171))
  call Hloop_QV_A(ntryL,G1H8(221),ex3(:),G1H4(1),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(172),n2h4(82))
  call Hloop_QV_A(ntryL,G1H8(222),ex3(:),G1H4(1),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(173),n2h4(83))
call HGT_raise_alpha_OLR(G1H8(224),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(224),-16,ex5(:),16,G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
call signflip_OLR(G2H4(174))
  call Hloop_QV_A(ntryL,G1H8(227),ex3(:),G1H4(1),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(175),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(228),ex3(:),G1H4(1),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(176),n2h4(85))
  call Hloop_AV_Q(ntryL,G1H8(229),ex3(:),G1H4(1),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(177),n2h4(86))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(230),-8,ex4(:),8,G2H4(178),m3h2x4(:,178),heltab2x8(:,:,178))
call signflip_OLR(G2H4(178))
  call Hloop_AV_Q(ntryL,G1H8(235),ex3(:),G1H4(1),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(179),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H8(241),ex3(:),G1H4(1),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(180),n2h4(88))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(236),-8,ex4(:),8,G2H4(181),m3h2x4(:,181),heltab2x8(:,:,181))
call signflip_OLR(G2H4(181))
  call Hloop_AV_Q(ntryL,G1H8(239),ex3(:),G1H4(1),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(182),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H8(240),ex3(:),G1H4(1),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(183),n2h4(90))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(242),-8,ex4(:),8,G2H4(184),m3h2x4(:,184),heltab2x8(:,:,184))
call signflip_OLR(G2H4(184))
  call Hloop_AV_Q(ntryL,G1H8(245),ex3(:),G1H4(1),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(185),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H8(246),ex3(:),G1H4(1),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(186),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H8(247),ex3(:),G1H4(1),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(187),n2h4(93))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(248),-16,ex5(:),16,G2H4(188),m3h2x4(:,188),heltab2x8(:,:,188))
call signflip_OLR(G2H4(188))
  call Hloop_AV_Q(ntryL,G1H8(253),ex3(:),G1H4(1),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(189),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(259),ex3(:),G1H4(1),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(190),n2h4(95))
call HGT_raise_alpha_OLR(G1H8(254),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(254),-16,ex5(:),16,G2H4(191),m3h2x4(:,191),heltab2x8(:,:,191))
call signflip_OLR(G2H4(191))
  call Hloop_AV_Q(ntryL,G1H8(257),ex3(:),G1H4(1),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(192),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H8(258),ex3(:),G1H4(1),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(193),n2h4(97))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(260),-16,ex5(:),16,G2H4(194),m3h2x4(:,194),heltab2x8(:,:,194))
call signflip_OLR(G2H4(194))
  call Hloop_AV_Q(ntryL,G1H8(263),ex3(:),G1H4(1),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(195),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H8(264),ex3(:),G1H4(1),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(196),n2h4(99))
  call Hloop_AV_Q(ntryL,G1H8(265),ex3(:),G1H4(1),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(197),n2h4(100))
call HGT_raise_alpha_OLR(G1H8(266),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(266),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(266),-16,ex5(:),16,G2H4(198),m3h2x4(:,198),heltab2x8(:,:,198))
call signflip_OLR(G2H4(198))
  call Hloop_AV_Q(ntryL,G1H8(271),ex3(:),G1H4(1),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(199),n2h4(101))
  call Hloop_AV_Q(ntryL,G1H8(277),ex3(:),G1H4(1),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(200),n2h4(102))
call HGT_raise_alpha_OLR(G1H8(272),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(272),-16,ex5(:),16,G2H4(201),m3h2x4(:,201),heltab2x8(:,:,201))
call signflip_OLR(G2H4(201))
  call Hloop_AV_Q(ntryL,G1H8(275),ex3(:),G1H4(1),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(202),n2h4(103))
  call Hloop_AV_Q(ntryL,G1H8(276),ex3(:),G1H4(1),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(203),n2h4(104))
call HGT_raise_alpha_OLR(G1H8(278),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(278),-16,ex5(:),16,G2H4(204),m3h2x4(:,204),heltab2x8(:,:,204))
call signflip_OLR(G2H4(204))
  call Hloop_AV_Q(ntryL,G1H8(281),ex3(:),G1H4(1),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(205),n2h4(105))
  call Hloop_AV_Q(ntryL,G1H8(282),ex3(:),G1H4(1),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(206),n2h4(106))
  call Hloop_QV_A(ntryL,G1H8(283),ex4(:),G1H4(1),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(207),n2h4(107))
call HGT_raise_alpha_OLR(G1H8(284),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(284),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(284),-16,ex5(:),16,G2H4(208),m3h2x4(:,208),heltab2x8(:,:,208))
call signflip_OLR(G2H4(208))
  call Hloop_QV_A(ntryL,G1H8(289),ex4(:),G1H4(1),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(209),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(295),ex4(:),G1H4(1),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(210),n2h4(109))
call HGT_raise_alpha_OLR(G1H8(290),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(290),-16,ex5(:),16,G2H4(211),m3h2x4(:,211),heltab2x8(:,:,211))
call signflip_OLR(G2H4(211))
  call Hloop_QV_A(ntryL,G1H8(293),ex4(:),G1H4(1),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(212),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(294),ex4(:),G1H4(1),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(213),n2h4(111))
call HGT_raise_alpha_OLR(G1H8(296),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(296),-16,ex5(:),16,G2H4(214),m3h2x4(:,214),heltab2x8(:,:,214))
call signflip_OLR(G2H4(214))
  call Hloop_QV_A(ntryL,G1H8(299),ex4(:),G1H4(1),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(215),n2h4(112))
  call Hloop_QV_A(ntryL,G1H8(300),ex4(:),G1H4(1),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(216),n2h4(113))
  call Hloop_QV_A(ntryL,G1H8(301),ex5(:),G1H4(1),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(217),n2h4(114))
call HGT_raise_alpha_OLR(G1H8(302),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(302),-8,ex4(:),8,G2H4(218),m3h2x4(:,218),heltab2x8(:,:,218))
call signflip_OLR(G2H4(218))
  call Hloop_QV_A(ntryL,G1H8(307),ex5(:),G1H4(1),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(219),n2h4(115))
  call Hloop_QV_A(ntryL,G1H8(313),ex5(:),G1H4(1),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(220),n2h4(116))
call HGT_raise_alpha_OLR(G1H8(308),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(308),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(308),-8,ex4(:),8,G2H4(221),m3h2x4(:,221),heltab2x8(:,:,221))
call signflip_OLR(G2H4(221))
  call Hloop_QV_A(ntryL,G1H8(311),ex5(:),G1H4(1),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(222),n2h4(117))
  call Hloop_QV_A(ntryL,G1H8(312),ex5(:),G1H4(1),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(223),n2h4(118))
call HGT_raise_alpha_OLR(G1H8(314),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(314),-8,ex4(:),8,G2H4(224),m3h2x4(:,224),heltab2x8(:,:,224))
call signflip_OLR(G2H4(224))
  call Hloop_QV_A(ntryL,G1H8(317),ex5(:),G1H4(1),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(225),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(318),ex5(:),G1H4(1),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(226),n2h4(120))
  call Hloop_QV_A(ntryL,G1H8(319),ex5(:),G1H4(1),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(227),n2h4(121))
call HGT_raise_alpha_OLR(G1H8(320),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(320),ex2(:),G1H4(1),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_QV_A(ntryL,G1H8(325),ex5(:),G1H4(2),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(2),53,0,G2H4(228),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(331),ex5(:),G1H4(2),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(2),53,0,G2H4(229),n2h4(123))
call HGT_raise_alpha_OLR(G1H8(326),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(326),ex2(:),G1H4(2),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_QV_A(ntryL,G1H8(329),ex5(:),G1H4(3),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(230),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(330),ex5(:),G1H4(3),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(231),n2h4(125))
call HGT_raise_alpha_OLR(G1H8(332),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(332),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(332),ex2(:),G1H4(3),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_QV_A(ntryL,G1H8(335),ex5(:),G1H4(4),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(4),53,0,G2H4(232),n2h4(126))
  call Hloop_QV_A(ntryL,G1H8(336),ex5(:),G1H4(4),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(4),53,0,G2H4(233),n2h4(127))
  call Hloop_QV_A(ntryL,G1H8(337),ex4(:),G1H4(4),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(234),n2h4(128))
call HGT_raise_alpha_OLR(G1H8(338),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(338),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(338),ex2(:),G1H4(4),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_QV_A(ntryL,G1H8(343),ex4(:),G1H4(5),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(235),n2h4(129))
  call Hloop_QV_A(ntryL,G1H8(349),ex4(:),G1H4(5),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(236),n2h4(130))
call HGT_raise_alpha_OLR(G1H8(344),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(344),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(344),ex2(:),G1H4(5),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_QV_A(ntryL,G1H8(347),ex4(:),G1H4(6),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(6),45,0,G2H4(237),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(348),ex4(:),G1H4(6),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(6),45,0,G2H4(238),n2h4(132))
call HGT_raise_alpha_OLR(G1H8(350),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(350),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(350),ex2(:),G1H4(6),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_QV_A(ntryL,G1H8(353),ex4(:),G1H4(7),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(239),n2h4(133))
  call Hloop_QV_A(ntryL,G1H8(354),ex4(:),G1H4(7),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(240),n2h4(134))
  call Hloop_AV_Q(ntryL,G1H8(355),ex4(:),G1H4(7),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(241),n2h4(135))
call HGT_raise_alpha_OLR(G1H8(356),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(356),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(356),-16,ex5(:),16,G2H4(242),m3h2x4(:,248),heltab2x8(:,:,248))
call signflip_OLR(G2H4(242))
  call Hloop_AV_Q(ntryL,G1H8(361),ex4(:),G1H4(7),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(243),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H8(367),ex4(:),G1H4(7),m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(244),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(362),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(362),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(362),-16,ex5(:),16,G2H4(245),m3h2x4(:,251),heltab2x8(:,:,251))
call signflip_OLR(G2H4(245))
  call Hloop_AV_Q(ntryL,G1H8(365),ex4(:),G1H4(7),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(246),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H8(366),ex4(:),G1H4(7),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(247),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(368),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(368),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(368),-16,ex5(:),16,G2H4(248),m3h2x4(:,254),heltab2x8(:,:,254))
call signflip_OLR(G2H4(248))
  call Hloop_AV_Q(ntryL,G1H8(371),ex4(:),G1H4(7),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(249),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H8(372),ex4(:),G1H4(7),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(250),n2h4(141))
  call Hloop_AV_Q(ntryL,G1H8(373),ex5(:),G1H4(7),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(251),n2h4(142))
call HGT_raise_alpha_OLR(G1H8(374),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(374),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(374),-8,ex4(:),8,G2H4(252),m3h2x4(:,258),heltab2x8(:,:,258))
call signflip_OLR(G2H4(252))
  call Hloop_AV_Q(ntryL,G1H8(379),ex5(:),G1H4(7),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(253),n2h4(143))
  call Hloop_AV_Q(ntryL,G1H8(385),ex5(:),G1H4(7),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(254),n2h4(144))
call HGT_raise_alpha_OLR(G1H8(380),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(380),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(380),-8,ex4(:),8,G2H4(255),m3h2x4(:,261),heltab2x8(:,:,261))
call signflip_OLR(G2H4(255))
  call Hloop_AV_Q(ntryL,G1H8(383),ex5(:),G1H4(7),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(256),n2h4(145))
  call Hloop_AV_Q(ntryL,G1H8(384),ex5(:),G1H4(7),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(257),n2h4(146))
call HGT_raise_alpha_OLR(G1H8(386),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(386),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(386),-8,ex4(:),8,G2H4(258),m3h2x4(:,264),heltab2x8(:,:,264))
call signflip_OLR(G2H4(258))
  call Hloop_AV_Q(ntryL,G1H8(389),ex5(:),G1H4(7),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(259),n2h4(147))
  call Hloop_AV_Q(ntryL,G1H8(390),ex5(:),G1H4(7),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(260),n2h4(148))
  call Hloop_QV_A(ntryL,G1H8(391),ex3(:),G1H4(7),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(261),n2h4(149))
call HGT_raise_alpha_OLR(G1H8(392),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(392),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(392),-16,ex5(:),16,G2H4(262),m3h2x4(:,268),heltab2x8(:,:,268))
call signflip_OLR(G2H4(262))
  call Hloop_QV_A(ntryL,G1H8(397),ex3(:),G1H4(7),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(263),n2h4(150))
  call Hloop_QV_A(ntryL,G1H8(403),ex3(:),G1H4(7),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(264),n2h4(151))
call HGT_raise_alpha_OLR(G1H8(398),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(398),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(398),-16,ex5(:),16,G2H4(265),m3h2x4(:,271),heltab2x8(:,:,271))
call signflip_OLR(G2H4(265))
  call Hloop_QV_A(ntryL,G1H8(401),ex3(:),G1H4(7),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(266),n2h4(152))
  call Hloop_QV_A(ntryL,G1H8(402),ex3(:),G1H4(7),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(267),n2h4(153))
call HGT_raise_alpha_OLR(G1H8(404),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(404),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(404),-16,ex5(:),16,G2H4(268),m3h2x4(:,274),heltab2x8(:,:,274))
call signflip_OLR(G2H4(268))
  call Hloop_QV_A(ntryL,G1H8(407),ex3(:),G1H4(7),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(269),n2h4(154))
  call Hloop_QV_A(ntryL,G1H8(408),ex3(:),G1H4(7),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(270),n2h4(155))
  call Hloop_QV_A(ntryL,G1H8(409),ex5(:),G1H4(7),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(271),n2h4(156))
call HGT_raise_alpha_OLR(G1H8(410),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(410),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(410),ex2(:),G1H4(7),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_QV_A(ntryL,G1H8(415),ex5(:),G1H4(8),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H4(8),57,0,G2H4(272),n2h4(157))
  call Hloop_QV_A(ntryL,G1H8(421),ex5(:),G1H4(8),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(8),57,0,G2H4(273),n2h4(158))
call HGT_raise_alpha_OLR(G1H8(416),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(416),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(416),ex2(:),G1H4(8),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_QV_A(ntryL,G1H8(419),ex5(:),G1H4(9),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(9),57,0,G2H4(274),n2h4(159))
  call Hloop_QV_A(ntryL,G1H8(420),ex5(:),G1H4(9),m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(9),57,0,G2H4(275),n2h4(160))
call HGT_raise_alpha_OLR(G1H8(422),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(422),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(422),ex2(:),G1H4(9),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_QV_A(ntryL,G1H8(425),ex5(:),G1H4(10),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(10),57,0,G2H4(276),n2h4(161))
  call Hloop_QV_A(ntryL,G1H8(426),ex5(:),G1H4(10),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(10),57,0,G2H4(277),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(427),ex3(:),G1H4(10),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(10),45,0,G2H4(278),n2h4(163))
call HGT_raise_alpha_OLR(G1H8(428),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(428),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(428),ex2(:),G1H4(10),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_QV_A(ntryL,G1H8(433),ex3(:),G1H4(11),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(11),45,0,G2H4(279),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(439),ex3(:),G1H4(11),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(11),45,0,G2H4(280),n2h4(165))
call HGT_raise_alpha_OLR(G1H8(434),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(434),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(434),ex2(:),G1H4(11),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_QV_A(ntryL,G1H8(437),ex3(:),G1H4(12),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H4(12),45,0,G2H4(281),n2h4(166))
  call Hloop_QV_A(ntryL,G1H8(438),ex3(:),G1H4(12),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(12),45,0,G2H4(282),n2h4(167))
call HGT_raise_alpha_OLR(G1H8(440),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(440),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(440),ex2(:),G1H4(12),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_QV_A(ntryL,G1H8(443),ex3(:),G1H4(13),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(13),45,0,G2H4(283),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(444),ex3(:),G1H4(13),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(13),45,0,G2H4(284),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(445),ex3(:),G1H4(13),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(285),n2h4(170))
call HGT_raise_alpha_OLR(G1H8(446),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(446),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(446),-8,ex4(:),8,G2H4(286),m3h2x4(:,298),heltab2x8(:,:,298))
call signflip_OLR(G2H4(286))
  call Hloop_QV_A(ntryL,G1H8(451),ex3(:),G1H4(13),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(287),n2h4(171))
  call Hloop_QV_A(ntryL,G1H8(457),ex3(:),G1H4(13),m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(288),n2h4(172))
call HGT_raise_alpha_OLR(G1H8(452),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(452),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(452),-8,ex4(:),8,G2H4(289),m3h2x4(:,301),heltab2x8(:,:,301))
call signflip_OLR(G2H4(289))
  call Hloop_QV_A(ntryL,G1H8(455),ex3(:),G1H4(13),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(290),n2h4(173))
  call Hloop_QV_A(ntryL,G1H8(456),ex3(:),G1H4(13),m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(291),n2h4(174))
call HGT_raise_alpha_OLR(G1H8(458),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(458),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(458),-8,ex4(:),8,G2H4(292),m3h2x4(:,304),heltab2x8(:,:,304))
call signflip_OLR(G2H4(292))
  call Hloop_QV_A(ntryL,G1H8(461),ex3(:),G1H4(13),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(293),n2h4(175))
  call Hloop_QV_A(ntryL,G1H8(462),ex3(:),G1H4(13),m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(294),n2h4(176))
  call Hloop_QV_A(ntryL,G1H8(463),ex4(:),G1H4(13),m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(13),57,0,G2H4(295),n2h4(177))
call HGT_raise_alpha_OLR(G1H8(464),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(464),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(464),ex2(:),G1H4(13),m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_QV_A(ntryL,G1H8(469),ex4(:),G1H4(14),m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(14),57,0,G2H4(296),n2h4(178))
  call Hloop_QV_A(ntryL,G1H8(475),ex4(:),G1H4(14),m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(14),57,0,G2H4(297),n2h4(179))
call HGT_raise_alpha_OLR(G1H8(470),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(470),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(470),ex2(:),G1H4(14),m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_QV_A(ntryL,G1H8(473),ex4(:),G1H4(15),m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H4(15),57,0,G2H4(298),n2h4(180))
  call Hloop_QV_A(ntryL,G1H8(474),ex4(:),G1H4(15),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G1H4(15),57,0,G2H4(299),n2h4(181))
call HGT_raise_alpha_OLR(G1H8(476),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(476),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(476),ex2(:),G1H4(15),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_QV_A(ntryL,G1H8(479),ex4(:),G1H4(16),m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H4(16),57,0,G2H4(300),n2h4(182))
  call Hloop_QV_A(ntryL,G1H8(480),ex4(:),G1H4(16),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(16),57,0,G2H4(301),n2h4(183))
  call Hloop_QV_A(ntryL,G1H8(481),ex3(:),G1H4(16),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G1H4(16),53,0,G2H4(302),n2h4(184))
call HGT_raise_alpha_OLR(G1H8(482),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(482),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(482),ex2(:),G1H4(16),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_QV_A(ntryL,G1H8(487),ex3(:),G1H4(17),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G1H4(17),53,0,G2H4(303),n2h4(185))
  call Hloop_QV_A(ntryL,G1H8(493),ex3(:),G1H4(17),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(17),53,0,G2H4(304),n2h4(186))
call HGT_raise_alpha_OLR(G1H8(488),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(488),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(488),ex2(:),G1H4(17),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_QV_A(ntryL,G1H8(491),ex3(:),G1H4(18),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_Q_A(ntryL,G1H4(18),53,0,G2H4(305),n2h4(187))
  call Hloop_QV_A(ntryL,G1H8(492),ex3(:),G1H4(18),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(18),53,0,G2H4(306),n2h4(188))
call HGT_raise_alpha_OLR(G1H8(494),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(494),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(494),ex2(:),G1H4(18),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_QV_A(ntryL,G1H8(497),ex3(:),G1H4(19),m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G1H4(19),53,0,G2H4(307),n2h4(189))
  call Hloop_QV_A(ntryL,G1H8(498),ex3(:),G1H4(19),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G1H4(19),53,0,G2H4(308),n2h4(190))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(63),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(64),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(65),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(63),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(64),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(65),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(56),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(8),mass5set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(57),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(12),mass5set(:,1),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(50),mass5set(:,1),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(12),mass5set(:,1),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(52),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(21),mass5set(:,1),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(46),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(22),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(66),mass5set(:,1),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(22),mass5set(:,1),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(67),mass5set(:,1),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(23),mass5set(:,1),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(68),mass5set(:,1),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(23),mass5set(:,1),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(69),mass5set(:,1),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(24),mass5set(:,1),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(42),mass5set(:,1),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),16,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(25),mass5set(:,1),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),16,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(70),mass5set(:,1),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(26),mass5set(:,1),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(68),mass5set(:,1),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),16,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(26),mass5set(:,1),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(71),mass5set(:,1),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(25),mass5set(:,1),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),8,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(72),mass5set(:,1),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),8,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(27),mass5set(:,1),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(69),mass5set(:,1),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),8,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(27),mass5set(:,1),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),4,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(71),mass5set(:,1),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),4,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(28),mass5set(:,1),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),16,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(73),mass5set(:,1),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),16,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(28),mass5set(:,1),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),8,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(74),mass5set(:,1),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(29),mass5set(:,1),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),16,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(73),mass5set(:,1),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),16,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(29),mass5set(:,1),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),4,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(75),mass5set(:,1),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),4,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(30),mass5set(:,1),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),8,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(74),mass5set(:,1),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(30),mass5set(:,1),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),4,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(75),mass5set(:,1),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),4,4)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(31),mass5set(:,1),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),16,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(66),mass5set(:,1),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),16,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(32),mass5set(:,1),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),16,4)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(48),mass5set(:,1),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),16,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(33),mass5set(:,1),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),4,4)
  call Hotf_5pt_reduction(G2H4(114),RedSet_5(76),mass5set(:,1),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),4,4)
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(34),mass5set(:,1),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G1H4(396),4)
  call HG1shiftOLR(G1H4(392),8,4)
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(67),mass5set(:,1),  & 
G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),G1H4(402),4)
  call HG1shiftOLR(G1H4(398),8,4)
  call Hotf_5pt_reduction(G2H4(119),RedSet_5(35),mass5set(:,1),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),4,4)
  call Hotf_5pt_reduction(G2H4(122),RedSet_5(77),mass5set(:,1),  & 
G1H4(409),G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),4)
  call HG1shiftOLR(G1H4(410),4,4)
  call Hotf_5pt_reduction(G2H4(123),RedSet_5(36),mass5set(:,1),  & 
G1H4(415),G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(416),8,4)
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(44),mass5set(:,1),  & 
G1H4(421),G1H4(422),G1H4(423),G1H4(424),G1H4(425),G1H4(426),4)
  call HG1shiftOLR(G1H4(422),8,4)
  call Hotf_5pt_reduction(G2H4(127),RedSet_5(37),mass5set(:,1),  & 
G1H4(427),G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(428),16,4)
  call Hotf_5pt_reduction(G2H4(130),RedSet_5(70),mass5set(:,1),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),16,4)
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(38),mass5set(:,1),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G1H4(444),4)
  call HG1shiftOLR(G1H4(440),8,4)
  call Hotf_5pt_reduction(G2H4(134),RedSet_5(72),mass5set(:,1),  & 
G1H4(445),G1H4(446),G1H4(447),G1H4(448),G1H4(449),G1H4(450),4)
  call HG1shiftOLR(G1H4(446),8,4)
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(32),mass5set(:,1),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),4,4)
  call Hotf_5pt_reduction(G2H4(138),RedSet_5(77),mass5set(:,1),  & 
G1H4(457),G1H4(458),G1H4(459),G1H4(460),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(458),4,4)
  call Hotf_5pt_reduction(G2H4(139),RedSet_5(36),mass5set(:,1),  & 
G1H4(463),G1H4(464),G1H4(465),G1H4(466),G1H4(467),G1H4(468),4)
  call HG1shiftOLR(G1H4(464),4,4)
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(76),mass5set(:,1),  & 
G1H4(469),G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),4)
  call HG1shiftOLR(G1H4(470),4,4)
  call Hotf_5pt_reduction(G2H4(143),RedSet_5(39),mass5set(:,1),  & 
G1H4(475),G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),4)
  call HG1shiftOLR(G1H4(476),16,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(58),mass5set(:,1),  & 
G1H4(481),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),16,4)
  call Hotf_5pt_reduction(G2H4(147),RedSet_5(18),mass5set(:,1),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G1H4(492),4)
  call HG1shiftOLR(G1H4(488),4,4)
  call Hotf_5pt_reduction(G2H4(150),RedSet_5(78),mass5set(:,1),  & 
G1H4(493),G1H4(494),G1H4(495),G1H4(496),G1H4(497),G1H4(498),4)
  call HG1shiftOLR(G1H4(494),4,4)
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(39),mass5set(:,1),  & 
G1H4(499),G1H4(500),G1H4(501),G1H4(502),G1H4(503),G1H4(504),4)
  call HG1shiftOLR(G1H4(500),4,4)
  call Hotf_5pt_reduction(G2H4(154),RedSet_5(78),mass5set(:,1),  & 
G1H4(505),G1H4(506),G1H4(507),G1H4(508),G1H4(509),G1H4(510),4)
  call HG1shiftOLR(G1H4(506),4,4)
  call Hotf_5pt_reduction(G2H4(155),RedSet_5(20),mass5set(:,1),  & 
G1H4(511),G1H4(512),G1H4(513),G1H4(514),G1H4(515),G1H4(516),4)
  call HG1shiftOLR(G1H4(512),4,4)
  call Hotf_5pt_reduction(G2H4(158),RedSet_5(79),mass5set(:,1),  & 
G1H4(517),G1H4(518),G1H4(519),G1H4(520),G1H4(521),G1H4(522),4)
  call HG1shiftOLR(G1H4(518),4,4)
  call Hotf_5pt_reduction(G2H4(159),RedSet_5(40),mass5set(:,1),  & 
G1H4(523),G1H4(524),G1H4(525),G1H4(526),G1H4(527),G1H4(528),4)
  call HG1shiftOLR(G1H4(524),8,4)
  call Hotf_5pt_reduction(G2H4(162),RedSet_5(61),mass5set(:,1),  & 
G1H4(529),G1H4(530),G1H4(531),G1H4(532),G1H4(533),G1H4(534),4)
  call HG1shiftOLR(G1H4(530),8,4)
  call Hotf_5pt_reduction(G2H4(163),RedSet_5(40),mass5set(:,1),  & 
G1H4(535),G1H4(536),G1H4(537),G1H4(538),G1H4(539),G1H4(540),4)
  call HG1shiftOLR(G1H4(536),4,4)
  call Hotf_5pt_reduction(G2H4(166),RedSet_5(79),mass5set(:,1),  & 
G1H4(541),G1H4(542),G1H4(543),G1H4(544),G1H4(545),G1H4(546),4)
  call HG1shiftOLR(G1H4(542),4,4)
  call Hloop_QA_V(ntryL,G2H4(167),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(170),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(176),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(177),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(180),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(186),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(187),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(190),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(196),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(197),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(200),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(206),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(207),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(210),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(216),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(217),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(220),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(226),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(227),RedSet_5(14),mass5set(:,1),  & 
G1H4(547),G1H4(548),G1H4(549),G1H4(550),G1H4(551),G1H4(552),4)
  call HG1shiftOLR(G1H4(548),2,4)
  call Hotf_5pt_reduction(G2H4(229),RedSet_5(54),mass5set(:,1),  & 
G1H4(553),G1H4(554),G1H4(555),G1H4(556),G1H4(557),G1H4(558),4)
  call HG1shiftOLR(G1H4(554),2,4)
  call Hotf_4pt_reduction(G2H4(233),RedSet_4(1),mass4set(:,1),  & 
G1H4(559),G1H4(560),G1H4(561),G1H4(562),G1H4(563),4)
  call HG1shiftOLR(G1H4(560),26,4)
  call Hotf_5pt_reduction(G2H4(234),RedSet_5(13),mass5set(:,1),  & 
G1H4(564),G1H4(565),G1H4(566),G1H4(567),G1H4(568),G1H4(569),4)
  call HG1shiftOLR(G1H4(565),2,4)
  call Hotf_5pt_reduction(G2H4(236),RedSet_5(54),mass5set(:,1),  & 
G1H4(570),G1H4(571),G1H4(572),G1H4(573),G1H4(574),G1H4(575),4)
  call HG1shiftOLR(G1H4(571),2,4)
  call Hotf_4pt_reduction(G2H4(240),RedSet_4(1),mass4set(:,1),  & 
G1H4(576),G1H4(577),G1H4(578),G1H4(579),G1H4(580),4)
  call HG1shiftOLR(G1H4(577),26,4)
  call Hloop_AQ_V(ntryL,G2H4(241),ex1(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(244),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(250),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(251),ex1(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(254),ex1(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(260),ex1(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(261),ex2(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(264),ex2(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H4(270),ex2(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H4(271),RedSet_5(18),mass5set(:,1),  & 
G1H4(581),G1H4(582),G1H4(583),G1H4(584),G1H4(585),G1H4(586),4)
  call HG1shiftOLR(G1H4(582),2,4)
  call Hotf_5pt_reduction(G2H4(273),RedSet_5(60),mass5set(:,1),  & 
G1H4(587),G1H4(588),G1H4(589),G1H4(590),G1H4(591),G1H4(592),4)
  call HG1shiftOLR(G1H4(588),2,4)
  call Hotf_4pt_reduction(G2H4(277),RedSet_4(2),mass4set(:,1),  & 
G1H4(593),G1H4(594),G1H4(595),G1H4(596),G1H4(597),4)
  call HG1shiftOLR(G1H4(594),22,4)
  call Hotf_5pt_reduction(G2H4(278),RedSet_5(17),mass5set(:,1),  & 
G1H4(598),G1H4(599),G1H4(600),G1H4(601),G1H4(602),G1H4(603),4)
  call HG1shiftOLR(G1H4(599),2,4)
  call Hotf_5pt_reduction(G2H4(280),RedSet_5(60),mass5set(:,1),  & 
G1H4(604),G1H4(605),G1H4(606),G1H4(607),G1H4(608),G1H4(609),4)
  call HG1shiftOLR(G1H4(605),2,4)
  call Hotf_4pt_reduction(G2H4(284),RedSet_4(2),mass4set(:,1),  & 
G1H4(610),G1H4(611),G1H4(612),G1H4(613),G1H4(614),4)
  call HG1shiftOLR(G1H4(611),22,4)
  call Hloop_QA_V(ntryL,G2H4(285),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(288),ex2(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(294),ex2(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H4(295),RedSet_5(20),mass5set(:,1),  & 
G1H4(615),G1H4(616),G1H4(617),G1H4(618),G1H4(619),G1H4(620),4)
  call HG1shiftOLR(G1H4(616),2,4)
  call Hotf_5pt_reduction(G2H4(297),RedSet_5(62),mass5set(:,1),  & 
G1H4(621),G1H4(622),G1H4(623),G1H4(624),G1H4(625),G1H4(626),4)
  call HG1shiftOLR(G1H4(622),2,4)
  call Hotf_4pt_reduction(G2H4(301),RedSet_4(3),mass4set(:,1),  & 
G1H4(627),G1H4(628),G1H4(629),G1H4(630),G1H4(631),4)
  call HG1shiftOLR(G1H4(628),14,4)
  call Hotf_5pt_reduction(G2H4(302),RedSet_5(19),mass5set(:,1),  & 
G1H4(632),G1H4(633),G1H4(634),G1H4(635),G1H4(636),G1H4(637),4)
  call HG1shiftOLR(G1H4(633),2,4)
  call Hotf_5pt_reduction(G2H4(304),RedSet_5(62),mass5set(:,1),  & 
G1H4(638),G1H4(639),G1H4(640),G1H4(641),G1H4(642),G1H4(643),4)
  call HG1shiftOLR(G1H4(639),2,4)
  call Hotf_4pt_reduction(G2H4(308),RedSet_4(3),mass4set(:,1),  & 
G1H4(644),G1H4(645),G1H4(646),G1H4(647),G1H4(648),4)
  call HG1shiftOLR(G1H4(645),14,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(313),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(325),[G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(337),[G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(361),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(373),[G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(385),[G1H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(397),[G1H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(409),[G1H4(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(421),[G1H4(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(433),[G1H4(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(445),[G1H4(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(457),[G1H4(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(469),[G1H4(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(481),[G1H4(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(493),[G1H4(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(505),[G1H4(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(517),[G1H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(529),[G1H4(528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(541),[G1H4(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(553),[G1H4(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(559),[G1H4(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(570),[G1H4(569)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(576),[G1H4(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(587),[G1H4(586)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(593),[G1H4(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(604),[G1H4(603)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(610),[G1H4(609)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(621),[G1H4(620)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(627),[G1H4(626)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(638),[G1H4(637)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(644),[G1H4(643)])
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(31),n2h2(1))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,0,G2H4(1),n2h4(191))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(33),n2h2(2))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,0,G2H4(3),n2h4(192))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(35),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(36),n2h2(4))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,0,G2H4(4),n2h4(193))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntryL,G1H4(37),ex2(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(38),n2h2(5))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,0,G2H4(6),n2h4(194))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(42),ex2(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(40),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(41),n2h2(7))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,0,G2H4(7),n2h4(195))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(43),n2h2(8))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-8,0,G2H4(9),n2h4(196))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(45),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(46),n2h2(10))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,0,G2H4(10),n2h4(197))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(48),n2h2(11))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,0,G2H4(12),n2h4(198))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(50),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(67),ex1(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(51),n2h2(13))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-16,0,G2H4(13),n2h4(199))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(53),n2h2(14))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,0,G2H4(15),n2h4(200))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(55),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(79),ex2(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(56),n2h2(16))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-8,0,G2H4(16),n2h4(201))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H4(85),ex2(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(58),n2h2(17))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-8,0,G2H4(18),n2h4(202))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_VA_Q(ntryL,G1H4(90),ex2(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(60),n2h2(18))
  call Hloop_UV_W(ntryL,G1H4(91),39,ex4(:),8,G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(92),-16,ex5(:),16,G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
call signflip_OLR(G2H2(62))
  call Hloop_UV_W(ntryL,G1H4(97),39,ex4(:),8,G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(98),-16,ex5(:),16,G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
call signflip_OLR(G2H2(64))
  call Hloop_UV_W(ntryL,G1H4(102),39,ex4(:),8,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_UV_W(ntryL,G1H4(103),39,ex5(:),16,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(104),-8,ex4(:),8,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
call signflip_OLR(G2H2(67))
  call Hloop_UV_W(ntryL,G1H4(109),39,ex5(:),16,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(110),-8,ex4(:),8,G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
call signflip_OLR(G2H2(69))
  call Hloop_UV_W(ntryL,G1H4(114),39,ex5(:),16,G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UV_W(ntryL,G1H4(115),39,ex4(:),8,G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(116),-16,ex5(:),16,G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
call signflip_OLR(G2H2(72))
  call Hloop_UV_W(ntryL,G1H4(121),39,ex4(:),8,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(122),-16,ex5(:),16,G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
call signflip_OLR(G2H2(74))
  call Hloop_UV_W(ntryL,G1H4(126),39,ex4(:),8,G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_UV_W(ntryL,G1H4(127),39,ex5(:),16,G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(128),-8,ex4(:),8,G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
call signflip_OLR(G2H2(77))
  call Hloop_UV_W(ntryL,G1H4(133),39,ex5(:),16,G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(134),-8,ex4(:),8,G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
call signflip_OLR(G2H2(79))
  call Hloop_UV_W(ntryL,G1H4(138),39,ex5(:),16,G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QV_A(ntryL,G1H4(139),ex3(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(81),n2h2(19))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(140),-16,0,G2H4(19),n2h4(211))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(145),ex3(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(83),n2h2(20))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-16,0,G2H4(21),n2h4(212))
  call Hloop_AV_Q(ntryL,G2H4(21),ex5(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(150),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(85),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(86),n2h2(22))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-16,0,G2H4(22),n2h4(213))
  call Hloop_QV_A(ntryL,G2H4(22),ex5(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AV_Q(ntryL,G1H4(157),ex4(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(88),n2h2(23))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(158),-16,0,G2H4(24),n2h4(214))
  call Hloop_QV_A(ntryL,G2H4(24),ex5(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_AV_Q(ntryL,G1H4(162),ex4(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(90),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(163),ex5(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(91),n2h2(25))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(164),-8,0,G2H4(25),n2h4(215))
  call Hloop_QV_A(ntryL,G2H4(25),ex4(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(93),n2h2(26))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(170),-8,0,G2H4(27),n2h4(216))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AV_Q(ntryL,G1H4(174),ex5(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(95),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(175),ex4(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(96),n2h2(28))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-16,0,G2H4(28),n2h4(217))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QV_A(ntryL,G1H4(181),ex4(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(98),n2h2(29))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-16,0,G2H4(30),n2h4(218))
  call Hloop_AV_Q(ntryL,G2H4(30),ex5(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QV_A(ntryL,G1H4(186),ex4(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(100),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(187),ex5(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(101),n2h2(31))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-8,0,G2H4(31),n2h4(219))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(193),ex5(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(103),n2h2(32))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-8,0,G2H4(34),n2h4(220))
  call Hloop_AV_Q(ntryL,G2H4(34),ex4(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_QV_A(ntryL,G1H4(198),ex5(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(105),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(199),ex3(:),G1H2(1),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(106),n2h2(34))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-16,0,G2H4(35),n2h4(221))
  call Hloop_QV_A(ntryL,G2H4(35),ex5(:),G2H2(107),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AV_Q(ntryL,G1H4(205),ex3(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(108),n2h2(35))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(206),-16,0,G2H4(38),n2h4(222))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AV_Q(ntryL,G1H4(210),ex3(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(110),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(211),ex4(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(111),n2h2(37))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(212),-16,0,G2H4(39),n2h4(223))
  call Hloop_AV_Q(ntryL,G2H4(39),ex5(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntryL,G1H4(217),ex4(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(113),n2h2(38))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-16,0,G2H4(42),n2h4(224))
  call Hloop_AV_Q(ntryL,G2H4(42),ex5(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QV_A(ntryL,G1H4(222),ex4(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(115),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(223),ex3(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(116),n2h2(40))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(224),-16,0,G2H4(43),n2h4(225))
  call Hloop_AV_Q(ntryL,G2H4(43),ex5(:),G2H2(117),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QV_A(ntryL,G1H4(229),ex3(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(118),n2h2(41))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(230),-16,0,G2H4(46),n2h4(226))
  call Hloop_AV_Q(ntryL,G2H4(46),ex5(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_QV_A(ntryL,G1H4(234),ex3(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(120),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(235),ex5(:),G1H2(1),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(121),n2h2(43))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(236),-4,0,G2H4(47),n2h4(227))
  call Hloop_AV_Q(ntryL,G2H4(47),ex3(:),G2H2(122),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QV_A(ntryL,G1H4(241),ex5(:),G1H2(1),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(123),n2h2(44))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(242),-4,0,G2H4(50),n2h4(228))
  call Hloop_AV_Q(ntryL,G2H4(50),ex3(:),G2H2(124),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_QV_A(ntryL,G1H4(246),ex5(:),G1H2(1),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(125),n2h2(45))
  call Hloop_QV_A(ntryL,G1H4(247),ex5(:),G1H2(1),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(126),n2h2(46))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(248),-8,0,G2H4(51),n2h4(229))
  call Hloop_AV_Q(ntryL,G2H4(51),ex4(:),G2H2(127),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_QV_A(ntryL,G1H4(253),ex5(:),G1H2(1),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(128),n2h2(47))
call HGT_OLR(G1H4(254),1,1,4)
call HGT_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(254),-8,0,G2H4(54),n2h4(230))
  call Hloop_AV_Q(ntryL,G2H4(54),ex4(:),G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_QV_A(ntryL,G1H4(258),ex5(:),G1H2(1),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(130),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(259),ex3(:),G1H2(1),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(131),n2h2(49))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(260),-8,0,G2H4(55),n2h4(231))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(132),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_QV_A(ntryL,G1H4(265),ex3(:),G1H2(1),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(133),n2h2(50))
call HGT_OLR(G1H4(266),1,1,4)
call HGT_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(266),-8,0,G2H4(58),n2h4(232))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(134),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_QV_A(ntryL,G1H4(270),ex3(:),G1H2(1),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(135),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(271),ex4(:),G1H2(1),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(136),n2h2(52))
call HGT_OLR(G1H4(272),1,1,4)
call HGT_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(272),-4,0,G2H4(59),n2h4(233))
  call Hloop_AV_Q(ntryL,G2H4(59),ex3(:),G2H2(137),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_QV_A(ntryL,G1H4(277),ex4(:),G1H2(1),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(138),n2h2(53))
call HGT_OLR(G1H4(278),1,1,4)
call HGT_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(278),-4,0,G2H4(62),n2h4(234))
  call Hloop_AV_Q(ntryL,G2H4(62),ex3(:),G2H2(139),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_QV_A(ntryL,G1H4(282),ex4(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(140),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(283),ex4(:),G1H2(1),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(141),n2h2(55))
call HGT_OLR(G1H4(284),1,1,4)
call HGT_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(284),-16,0,G2H4(63),n2h4(235))
  call Hloop_QV_A(ntryL,G2H4(63),ex5(:),G2H2(142),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AV_Q(ntryL,G1H4(289),ex4(:),G1H2(1),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(143),n2h2(56))
call HGT_OLR(G1H4(290),1,1,4)
call HGT_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(290),-16,0,G2H4(66),n2h4(236))
  call Hloop_QV_A(ntryL,G2H4(66),ex5(:),G2H2(144),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_AV_Q(ntryL,G1H4(294),ex4(:),G1H2(1),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(145),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H4(295),ex5(:),G1H2(1),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(146),n2h2(58))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(296),-8,0,G2H4(67),n2h4(237))
  call Hloop_QV_A(ntryL,G2H4(67),ex4(:),G2H2(147),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_AV_Q(ntryL,G1H4(301),ex5(:),G1H2(1),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(148),n2h2(59))
call HGT_OLR(G1H4(302),1,1,4)
call HGT_invQ_OLR(G1H4(302),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(302),-8,0,G2H4(70),n2h4(238))
  call Hloop_QV_A(ntryL,G2H4(70),ex4(:),G2H2(149),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_AV_Q(ntryL,G1H4(306),ex5(:),G1H2(1),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(150),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(307),ex3(:),G1H2(1),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(151),n2h2(61))
call HGT_OLR(G1H4(308),1,1,4)
call HGT_invQ_OLR(G1H4(308),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(308),-16,0,G2H4(71),n2h4(239))
  call Hloop_QV_A(ntryL,G2H4(71),ex5(:),G2H2(152),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_AV_Q(ntryL,G1H4(313),ex3(:),G1H2(1),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(153),n2h2(62))
call HGT_OLR(G1H4(314),1,1,4)
call HGT_invQ_OLR(G1H4(314),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(314),-16,0,G2H4(74),n2h4(240))
  call Hloop_QV_A(ntryL,G2H4(74),ex5(:),G2H2(154),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_AV_Q(ntryL,G1H4(318),ex3(:),G1H2(1),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(155),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(319),ex5(:),G1H2(1),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(156),n2h2(64))
call HGT_OLR(G1H4(320),1,1,4)
call HGT_invQ_OLR(G1H4(320),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(320),-4,0,G2H4(75),n2h4(241))
  call Hloop_QV_A(ntryL,G2H4(75),ex3(:),G2H2(157),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_AV_Q(ntryL,G1H4(325),ex5(:),G1H2(1),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(158),n2h2(65))
call HGT_OLR(G1H4(326),1,1,4)
call HGT_invQ_OLR(G1H4(326),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(326),-4,0,G2H4(78),n2h4(242))
  call Hloop_QV_A(ntryL,G2H4(78),ex3(:),G2H2(159),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_AV_Q(ntryL,G1H4(330),ex5(:),G1H2(1),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(160),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(331),ex3(:),G1H2(1),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(161),n2h2(67))
call HGT_OLR(G1H4(332),1,1,4)
call HGT_invQ_OLR(G1H4(332),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(332),-8,0,G2H4(79),n2h4(243))
  call Hloop_QV_A(ntryL,G2H4(79),ex4(:),G2H2(162),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_AV_Q(ntryL,G1H4(337),ex3(:),G1H2(1),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(163),n2h2(68))
call HGT_OLR(G1H4(338),1,1,4)
call HGT_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(338),-8,0,G2H4(82),n2h4(244))
  call Hloop_QV_A(ntryL,G2H4(82),ex4(:),G2H2(164),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_AV_Q(ntryL,G1H4(342),ex3(:),G1H2(1),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(165),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(343),ex4(:),G1H2(1),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(166),n2h2(70))
call HGT_OLR(G1H4(344),1,1,4)
call HGT_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(344),-4,0,G2H4(83),n2h4(245))
  call Hloop_QV_A(ntryL,G2H4(83),ex3(:),G2H2(167),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_AV_Q(ntryL,G1H4(349),ex4(:),G1H2(1),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(168),n2h2(71))
call HGT_OLR(G1H4(350),1,1,4)
call HGT_invQ_OLR(G1H4(350),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(350),-4,0,G2H4(86),n2h4(246))
  call Hloop_QV_A(ntryL,G2H4(86),ex3(:),G2H2(169),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_AV_Q(ntryL,G1H4(354),ex4(:),G1H2(1),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(170),n2h2(72))
  call Hloop_VA_Q(ntryL,G1H4(355),ex2(:),G1H2(1),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(171),n2h2(73))
call HGT_OLR(G1H4(356),1,1,4)
call HGT_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(356),-16,0,G2H4(87),n2h4(247))
  call Hloop_QV_A(ntryL,G2H4(87),ex5(:),G2H2(172),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_VA_Q(ntryL,G1H4(361),ex2(:),G1H2(1),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(173),n2h2(74))
call HGT_OLR(G1H4(362),1,1,4)
call HGT_invQ_OLR(G1H4(362),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(362),-16,0,G2H4(90),n2h4(248))
  call Hloop_QV_A(ntryL,G2H4(90),ex5(:),G2H2(174),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VA_Q(ntryL,G1H4(366),ex2(:),G1H2(1),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(175),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(367),ex3(:),G1H2(1),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(176),n2h2(76))
call HGT_OLR(G1H4(368),1,1,4)
call HGT_invQ_OLR(G1H4(368),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(368),-16,0,G2H4(91),n2h4(249))
  call Hloop_AV_Q(ntryL,G2H4(91),ex5(:),G2H2(177),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_QV_A(ntryL,G1H4(373),ex3(:),G1H2(1),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(178),n2h2(77))
call HGT_OLR(G1H4(374),1,1,4)
call HGT_invQ_OLR(G1H4(374),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(374),-16,0,G2H4(94),n2h4(250))
  call Hloop_AV_Q(ntryL,G2H4(94),ex5(:),G2H2(179),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_QV_A(ntryL,G1H4(378),ex3(:),G1H2(1),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(180),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(379),ex1(:),G1H2(1),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(181),n2h2(79))
call HGT_OLR(G1H4(380),1,1,4)
call HGT_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(380),-4,0,G2H4(95),n2h4(251))
  call Hloop_AV_Q(ntryL,G2H4(95),ex3(:),G2H2(182),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_VQ_A(ntryL,G1H4(385),ex1(:),G1H2(1),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(183),n2h2(80))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(386),-4,0,G2H4(98),n2h4(252))
  call Hloop_AV_Q(ntryL,G2H4(98),ex3(:),G2H2(184),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_VQ_A(ntryL,G1H4(390),ex1(:),G1H2(1),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(185),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(391),ex2(:),G1H2(1),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(186),n2h2(82))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(392),-8,0,G2H4(99),n2h4(253))
  call Hloop_QV_A(ntryL,G2H4(99),ex4(:),G2H2(187),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_VA_Q(ntryL,G1H4(397),ex2(:),G1H2(1),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(188),n2h2(83))
call HGT_OLR(G1H4(398),1,1,4)
call HGT_invQ_OLR(G1H4(398),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(398),-8,0,G2H4(102),n2h4(254))
  call Hloop_QV_A(ntryL,G2H4(102),ex4(:),G2H2(189),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_VA_Q(ntryL,G1H4(402),ex2(:),G1H2(1),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(190),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(403),ex1(:),G1H2(1),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(191),n2h2(85))
call HGT_OLR(G1H4(404),1,1,4)
call HGT_invQ_OLR(G1H4(404),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(404),-4,0,G2H4(103),n2h4(255))
  call Hloop_AV_Q(ntryL,G2H4(103),ex3(:),G2H2(192),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_VQ_A(ntryL,G1H4(409),ex1(:),G1H2(1),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(193),n2h2(86))
call HGT_OLR(G1H4(410),1,1,4)
call HGT_invQ_OLR(G1H4(410),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(410),-4,0,G2H4(106),n2h4(256))
  call Hloop_AV_Q(ntryL,G2H4(106),ex3(:),G2H2(194),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_VQ_A(ntryL,G1H4(414),ex1(:),G1H2(1),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(195),n2h2(87))
  call Hloop_QV_A(ntryL,G1H4(415),ex3(:),G1H2(1),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(196),n2h2(88))
call HGT_OLR(G1H4(416),1,1,4)
call HGT_invQ_OLR(G1H4(416),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(416),-8,0,G2H4(107),n2h4(257))
  call Hloop_AV_Q(ntryL,G2H4(107),ex4(:),G2H2(197),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_QV_A(ntryL,G1H4(421),ex3(:),G1H2(1),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(198),n2h2(89))
call HGT_OLR(G1H4(422),1,1,4)
call HGT_invQ_OLR(G1H4(422),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(422),-8,0,G2H4(110),n2h4(258))
  call Hloop_AV_Q(ntryL,G2H4(110),ex4(:),G2H2(199),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_QV_A(ntryL,G1H4(426),ex3(:),G1H2(1),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(200),n2h2(90))
  call Hloop_VQ_A(ntryL,G1H4(427),ex1(:),G1H2(1),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(201),n2h2(91))
call HGT_OLR(G1H4(428),1,1,4)
call HGT_invQ_OLR(G1H4(428),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(428),-16,0,G2H4(111),n2h4(259))
  call Hloop_AV_Q(ntryL,G2H4(111),ex5(:),G2H2(202),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_VQ_A(ntryL,G1H4(433),ex1(:),G1H2(1),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(203),n2h2(92))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(434),-16,0,G2H4(114),n2h4(260))
  call Hloop_AV_Q(ntryL,G2H4(114),ex5(:),G2H2(204),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_VQ_A(ntryL,G1H4(438),ex1(:),G1H2(1),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(205),n2h2(93))
  call Hloop_VQ_A(ntryL,G1H4(439),ex1(:),G1H2(1),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(206),n2h2(94))
call HGT_OLR(G1H4(440),1,1,4)
call HGT_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(440),-8,0,G2H4(115),n2h4(261))
  call Hloop_AV_Q(ntryL,G2H4(115),ex4(:),G2H2(207),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_VQ_A(ntryL,G1H4(445),ex1(:),G1H2(1),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(208),n2h2(95))
call HGT_OLR(G1H4(446),1,1,4)
call HGT_invQ_OLR(G1H4(446),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(446),-8,0,G2H4(118),n2h4(262))
  call Hloop_AV_Q(ntryL,G2H4(118),ex4(:),G2H2(209),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_VQ_A(ntryL,G1H4(450),ex1(:),G1H2(1),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(210),n2h2(96))
  call Hloop_QV_A(ntryL,G1H4(451),ex5(:),G1H2(1),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(211),n2h2(97))
call HGT_OLR(G1H4(452),1,1,4)
call HGT_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(452),-4,0,G2H4(119),n2h4(263))
  call Hloop_AV_Q(ntryL,G2H4(119),ex3(:),G2H2(212),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_QV_A(ntryL,G1H4(457),ex5(:),G1H2(1),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(213),n2h2(98))
call HGT_OLR(G1H4(458),1,1,4)
call HGT_invQ_OLR(G1H4(458),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(458),-4,0,G2H4(122),n2h4(264))
  call Hloop_AV_Q(ntryL,G2H4(122),ex3(:),G2H2(214),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QV_A(ntryL,G1H4(462),ex5(:),G1H2(1),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(215),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(463),ex4(:),G1H2(1),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(216),n2h2(100))
call HGT_OLR(G1H4(464),1,1,4)
call HGT_invQ_OLR(G1H4(464),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(464),-4,0,G2H4(123),n2h4(265))
  call Hloop_AV_Q(ntryL,G2H4(123),ex3(:),G2H2(217),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_QV_A(ntryL,G1H4(469),ex4(:),G1H2(1),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(218),n2h2(101))
call HGT_OLR(G1H4(470),1,1,4)
call HGT_invQ_OLR(G1H4(470),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(470),-4,0,G2H4(126),n2h4(266))
  call Hloop_AV_Q(ntryL,G2H4(126),ex3(:),G2H2(219),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_QV_A(ntryL,G1H4(474),ex4(:),G1H2(1),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(220),n2h2(102))
  call Hloop_AV_Q(ntryL,G1H4(475),ex3(:),G1H2(1),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(221),n2h2(103))
call HGT_OLR(G1H4(476),1,1,4)
call HGT_invQ_OLR(G1H4(476),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(476),-16,0,G2H4(127),n2h4(267))
  call Hloop_QV_A(ntryL,G2H4(127),ex5(:),G2H2(222),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_AV_Q(ntryL,G1H4(481),ex3(:),G1H2(1),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(223),n2h2(104))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(482),-16,0,G2H4(130),n2h4(268))
  call Hloop_QV_A(ntryL,G2H4(130),ex5(:),G2H2(224),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_AV_Q(ntryL,G1H4(486),ex3(:),G1H2(1),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(225),n2h2(105))
  call Hloop_VA_Q(ntryL,G1H4(487),ex2(:),G1H2(1),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(226),n2h2(106))
call HGT_OLR(G1H4(488),1,1,4)
call HGT_invQ_OLR(G1H4(488),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(488),-4,0,G2H4(131),n2h4(269))
  call Hloop_QV_A(ntryL,G2H4(131),ex3(:),G2H2(227),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_VA_Q(ntryL,G1H4(493),ex2(:),G1H2(1),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(228),n2h2(107))
call HGT_OLR(G1H4(494),1,1,4)
call HGT_invQ_OLR(G1H4(494),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(494),-4,0,G2H4(134),n2h4(270))
  call Hloop_QV_A(ntryL,G2H4(134),ex3(:),G2H2(229),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_VA_Q(ntryL,G1H4(498),ex2(:),G1H2(1),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(230),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H4(499),ex5(:),G1H2(1),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(231),n2h2(109))
call HGT_OLR(G1H4(500),1,1,4)
call HGT_invQ_OLR(G1H4(500),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(500),-4,0,G2H4(135),n2h4(271))
  call Hloop_QV_A(ntryL,G2H4(135),ex3(:),G2H2(232),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AV_Q(ntryL,G1H4(505),ex5(:),G1H2(1),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(233),n2h2(110))
call HGT_OLR(G1H4(506),1,1,4)
call HGT_invQ_OLR(G1H4(506),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(506),-4,0,G2H4(138),n2h4(272))
  call Hloop_QV_A(ntryL,G2H4(138),ex3(:),G2H2(234),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_AV_Q(ntryL,G1H4(510),ex5(:),G1H2(1),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(235),n2h2(111))
  call Hloop_VA_Q(ntryL,G1H4(511),ex2(:),G1H2(1),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(236),n2h2(112))
call HGT_OLR(G1H4(512),1,1,4)
call HGT_invQ_OLR(G1H4(512),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(512),-4,0,G2H4(139),n2h4(273))
  call Hloop_QV_A(ntryL,G2H4(139),ex3(:),G2H2(237),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_VA_Q(ntryL,G1H4(517),ex2(:),G1H2(1),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(238),n2h2(113))
call HGT_OLR(G1H4(518),1,1,4)
call HGT_invQ_OLR(G1H4(518),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(518),-4,0,G2H4(142),n2h4(274))
  call Hloop_QV_A(ntryL,G2H4(142),ex3(:),G2H2(239),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_VA_Q(ntryL,G1H4(522),ex2(:),G1H2(1),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(240),n2h2(114))
  call Hloop_AV_Q(ntryL,G1H4(523),ex3(:),G1H2(1),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(241),n2h2(115))
call HGT_OLR(G1H4(524),1,1,4)
call HGT_invQ_OLR(G1H4(524),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(524),-8,0,G2H4(143),n2h4(275))
  call Hloop_QV_A(ntryL,G2H4(143),ex4(:),G2H2(242),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_AV_Q(ntryL,G1H4(529),ex3(:),G1H2(1),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(243),n2h2(116))
call HGT_OLR(G1H4(530),1,1,4)
call HGT_invQ_OLR(G1H4(530),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(530),-8,0,G2H4(146),n2h4(276))
  call Hloop_QV_A(ntryL,G2H4(146),ex4(:),G2H2(244),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_AV_Q(ntryL,G1H4(534),ex3(:),G1H2(1),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(245),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H4(535),ex4(:),G1H2(1),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(246),n2h2(118))
call HGT_OLR(G1H4(536),1,1,4)
call HGT_invQ_OLR(G1H4(536),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(536),-4,0,G2H4(147),n2h4(277))
  call Hloop_QV_A(ntryL,G2H4(147),ex3(:),G2H2(247),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_AV_Q(ntryL,G1H4(541),ex4(:),G1H2(1),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(248),n2h2(119))
call HGT_OLR(G1H4(542),1,1,4)
call HGT_invQ_OLR(G1H4(542),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(542),-4,0,G2H4(150),n2h4(278))
  call Hloop_QV_A(ntryL,G2H4(150),ex3(:),G2H2(249),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_AV_Q(ntryL,G1H4(546),ex4(:),G1H2(1),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(250),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(547),ex4(:),G1H2(1),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(251),n2h2(121))
call HGT_raise_alpha_OLR(G1H4(548),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(548),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(548),ex2(:),G1H2(1),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_QV_A(ntryL,G1H4(553),ex4(:),G1H2(2),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(2),61,0,G2H2(252),n2h2(122))
call HGT_raise_alpha_OLR(G1H4(554),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(554),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(554),ex2(:),G1H2(2),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_QV_A(ntryL,G1H4(559),ex4(:),G1H2(3),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(3),61,0,G2H2(253),n2h2(123))
call HGT_raise_alpha_OLR(G1H4(560),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(560),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(560),ex2(:),G1H2(3),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_QV_A(ntryL,G1H4(564),ex5(:),G1H2(4),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(4),61,0,G2H2(254),n2h2(124))
call HGT_raise_alpha_OLR(G1H4(565),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(565),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(565),ex2(:),G1H2(4),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_QV_A(ntryL,G1H4(570),ex5(:),G1H2(5),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(5),61,0,G2H2(255),n2h2(125))
call HGT_raise_alpha_OLR(G1H4(571),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(571),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(571),ex2(:),G1H2(5),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_QV_A(ntryL,G1H4(576),ex5(:),G1H2(6),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(6),61,0,G2H2(256),n2h2(126))
call HGT_raise_alpha_OLR(G1H4(577),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(577),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(577),ex2(:),G1H2(6),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_QV_A(ntryL,G1H4(581),ex3(:),G1H2(7),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(7),61,0,G2H2(257),n2h2(127))
call HGT_raise_alpha_OLR(G1H4(582),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(582),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(582),ex2(:),G1H2(7),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_QV_A(ntryL,G1H4(587),ex3(:),G1H2(8),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(8),61,0,G2H2(258),n2h2(128))
call HGT_raise_alpha_OLR(G1H4(588),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(588),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(588),ex2(:),G1H2(8),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_QV_A(ntryL,G1H4(593),ex3(:),G1H2(9),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(9),61,0,G2H2(259),n2h2(129))
call HGT_raise_alpha_OLR(G1H4(594),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(594),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(594),ex2(:),G1H2(9),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_QV_A(ntryL,G1H4(598),ex5(:),G1H2(10),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(10),61,0,G2H2(260),n2h2(130))
call HGT_raise_alpha_OLR(G1H4(599),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(599),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(599),ex2(:),G1H2(10),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_QV_A(ntryL,G1H4(604),ex5(:),G1H2(11),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(11),61,0,G2H2(261),n2h2(131))
call HGT_raise_alpha_OLR(G1H4(605),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(605),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(605),ex2(:),G1H2(11),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_QV_A(ntryL,G1H4(610),ex5(:),G1H2(12),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(12),61,0,G2H2(262),n2h2(132))
call HGT_raise_alpha_OLR(G1H4(611),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(611),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(611),ex2(:),G1H2(12),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_QV_A(ntryL,G1H4(615),ex3(:),G1H2(13),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(13),61,0,G2H2(263),n2h2(133))
call HGT_raise_alpha_OLR(G1H4(616),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(616),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(616),ex2(:),G1H2(13),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_QV_A(ntryL,G1H4(621),ex3(:),G1H2(14),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(14),61,0,G2H2(264),n2h2(134))
call HGT_raise_alpha_OLR(G1H4(622),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(622),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(622),ex2(:),G1H2(14),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_QV_A(ntryL,G1H4(627),ex3(:),G1H2(15),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(15),61,0,G2H2(265),n2h2(135))
call HGT_raise_alpha_OLR(G1H4(628),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(628),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(628),ex2(:),G1H2(15),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_QV_A(ntryL,G1H4(632),ex4(:),G1H2(16),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(16),61,0,G2H2(266),n2h2(136))
call HGT_raise_alpha_OLR(G1H4(633),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(633),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(633),ex2(:),G1H2(16),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_QV_A(ntryL,G1H4(638),ex4(:),G1H2(17),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(17),61,0,G2H2(267),n2h2(137))
call HGT_raise_alpha_OLR(G1H4(639),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(639),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(639),ex2(:),G1H2(17),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_QV_A(ntryL,G1H4(644),ex4(:),G1H2(18),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(18),61,0,G2H2(268),n2h2(138))
call HGT_raise_alpha_OLR(G1H4(645),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(645),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(645),ex2(:),G1H2(18),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(9),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(11),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(13),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(14),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(15),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(16),mass5set(:,1),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(17),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(19),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(1),mass5set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(2),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(3),mass5set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(4),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(5),mass5set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(6),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(8),mass5set(:,1),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(8),mass5set(:,1),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(12),mass5set(:,1),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(12),mass5set(:,1),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(21),mass5set(:,1),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(22),mass5set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),16,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(22),mass5set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(23),mass5set(:,1),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(23),mass5set(:,1),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hotf_5pt_reduction(G2H2(106),RedSet_5(24),mass5set(:,1),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),16,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(25),mass5set(:,1),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(26),mass5set(:,1),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),16,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(26),mass5set(:,1),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_5pt_reduction(G2H2(126),RedSet_5(25),mass5set(:,1),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hotf_5pt_reduction(G2H2(131),RedSet_5(27),mass5set(:,1),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_5pt_reduction(G2H2(136),RedSet_5(27),mass5set(:,1),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(28),mass5set(:,1),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),16,2)
  call Hotf_5pt_reduction(G2H2(146),RedSet_5(28),mass5set(:,1),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hotf_5pt_reduction(G2H2(151),RedSet_5(29),mass5set(:,1),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),16,2)
  call Hotf_5pt_reduction(G2H2(156),RedSet_5(29),mass5set(:,1),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),4,2)
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(30),mass5set(:,1),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hotf_5pt_reduction(G2H2(166),RedSet_5(30),mass5set(:,1),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),4,2)
  call Hotf_5pt_reduction(G2H2(171),RedSet_5(31),mass5set(:,1),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),16,2)
  call Hotf_5pt_reduction(G2H2(176),RedSet_5(32),mass5set(:,1),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),16,2)
  call Hotf_5pt_reduction(G2H2(181),RedSet_5(33),mass5set(:,1),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),4,2)
  call Hotf_5pt_reduction(G2H2(186),RedSet_5(34),mass5set(:,1),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),8,2)
  call Hotf_5pt_reduction(G2H2(191),RedSet_5(35),mass5set(:,1),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),4,2)
  call Hotf_5pt_reduction(G2H2(196),RedSet_5(36),mass5set(:,1),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),8,2)
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(37),mass5set(:,1),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hotf_5pt_reduction(G2H2(206),RedSet_5(38),mass5set(:,1),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),8,2)
  call Hotf_5pt_reduction(G2H2(211),RedSet_5(32),mass5set(:,1),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),4,2)
  call Hotf_5pt_reduction(G2H2(216),RedSet_5(36),mass5set(:,1),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),4,2)
  call Hotf_5pt_reduction(G2H2(221),RedSet_5(39),mass5set(:,1),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),16,2)
  call Hotf_5pt_reduction(G2H2(226),RedSet_5(18),mass5set(:,1),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),4,2)
  call Hotf_5pt_reduction(G2H2(231),RedSet_5(39),mass5set(:,1),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),4,2)
  call Hotf_5pt_reduction(G2H2(236),RedSet_5(20),mass5set(:,1),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),4,2)
  call Hotf_5pt_reduction(G2H2(241),RedSet_5(40),mass5set(:,1),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),8,2)
  call Hotf_5pt_reduction(G2H2(246),RedSet_5(40),mass5set(:,1),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(251),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(254),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(257),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(260),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(263),ex2(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(266),ex2(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),47,ex5(:),16,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),0,ex5(:),16,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),55,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),0,ex4(:),8,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),47,ex5(:),16,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),0,ex5(:),16,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(37),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(43),47,ex5(:),16,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(44),0,ex5(:),16,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(49),55,ex4(:),8,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(50),0,ex4(:),8,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(55),47,ex5(:),16,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(56),0,ex5(:),16,G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(61),55,ex4(:),8,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(62),0,ex4(:),8,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(67),47,ex5(:),16,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(68),0,ex5(:),16,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(73),55,ex4(:),8,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),0,ex4(:),8,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_AV_Q(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(115),47,ex5(:),16,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(116),0,ex5(:),16,G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(121),55,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(122),0,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(127),47,ex5(:),16,G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(128),0,ex5(:),16,G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(133),55,ex4(:),8,G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(134),0,ex4(:),8,G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hloop_QV_A(ntryL,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(28))
  call Hloop_AV_Q(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(29))
  call Hloop_AV_Q(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(52),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(54),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H2(169),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(37))
  call Hloop_AV_Q(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(175),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(181),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(64),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(193),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(66),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(72),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(74),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(224),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(230),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(78),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(235),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(80),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(241),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(242),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(82),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(247),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(248),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(84),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(254),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(259),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(260),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(88),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(90),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(271),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(272),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(92),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(278),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(94),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(284),ex5(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(96),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(289),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(98),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(295),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(100),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(102),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(307),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(308),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(104),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(314),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(106),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(319),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(320),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(108),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(325),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(326),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(110),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(331),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(332),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(112),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(337),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(338),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(114),n2h1(94))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(14),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(13),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(18),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(17),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(20),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(19),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(9),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(10),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(11),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(13),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(14),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(15),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(16),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(17),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(19),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(1),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(2),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(3),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(4),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(5),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(6),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(8),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(8),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(12),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(12),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(21),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(22),mass5set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(22),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(23),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(23),mass5set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(24),mass5set(:,1),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(25),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(26),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(26),mass5set(:,1),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(25),mass5set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(27),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(27),mass5set(:,1),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(28),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(28),mass5set(:,1),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(29),mass5set(:,1),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(29),mass5set(:,1),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(30),mass5set(:,1),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(30),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(31),mass5set(:,1),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(32),mass5set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(33),mass5set(:,1),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),4)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(34),mass5set(:,1),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(35),mass5set(:,1),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(36),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(37),mass5set(:,1),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(38),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(32),mass5set(:,1),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),4)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(36),mass5set(:,1),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(39),mass5set(:,1),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(18),mass5set(:,1),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(39),mass5set(:,1),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),4)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(20),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),4)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(40),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(40),mass5set(:,1),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[48,2,4,1,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[48,2,4,1,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(6)*(M(4,:)%j-M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[48,2,4,1,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (c(6)*M(2,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[48,1,4,2,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(4),m4h2x2x16(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[48,1,4,2,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(5),m4h2x2x16(:,5),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[48,1,4,2,8],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(6),m4h2x2x16(:,6),heltab3x64(:,:,6))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(7),m4h2x2x16(:,7),heltab3x64(:,:,7))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(8),m4h2x2x16(:,8),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(9),m4h2x2x16(:,9),heltab3x64(:,:,9))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(10),m4h2x2x16(:,10),heltab3x64(:,:,10))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(11),m4h2x2x16(:,11),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(12),m4h2x2x16(:,12),heltab3x64(:,:,12))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[40,2,4,1,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(13),m4h2x2x16(:,13),heltab3x64(:,:,13))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[40,2,4,1,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(14),m4h2x2x16(:,14),heltab3x64(:,:,14))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(5,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[40,2,4,1,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(15),m4h2x2x16(:,15),heltab3x64(:,:,15))
  Gcoeff(:)%j = (c(6)*M(4,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[40,1,4,2,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(16),m4h2x2x16(:,16),heltab3x64(:,:,16))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[40,1,4,2,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(17),m4h2x2x16(:,17),heltab3x64(:,:,17))
  Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(4,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[40,1,4,2,16],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(18),m4h2x2x16(:,18),heltab3x64(:,:,18))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[40,1,4,16,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(19),m4h2x2x16(:,19),heltab3x64(:,:,19))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[40,1,4,16,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(20),m4h2x2x16(:,20),heltab3x64(:,:,20))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[40,1,4,16,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(21),m4h2x2x16(:,21),heltab3x64(:,:,21))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[40,1,16,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(22),m4h2x2x16(:,22),heltab3x64(:,:,22))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[40,1,16,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(23),m4h2x2x16(:,23),heltab3x64(:,:,23))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[40,1,16,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(24),m4h2x2x16(:,24),heltab3x64(:,:,24))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,4,2,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,4,2,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(3,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,4,2,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,2,4,1,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,2,4,1,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(6)*(M(5,:)%j-M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,2,4,1,24],[0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,2,24,1,4],[0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(41))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,2,24,1,4],[0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(42))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,2,24,1,4],[0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(43))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,24,2,4],[0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(44))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,1,24,2,4],[0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(45))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,1,24,2,4],[0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(46))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(47))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,3,16,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(14),n2h32(48))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(49))
  Gcoeff(:)%j = (-(c(27)*M(5,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,3,16,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(16),n2h32(50))
  Gcoeff(:)%j = (c(27)*M(3,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(51))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,3,16,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(18),n2h32(52))
  Gcoeff(:)%j = (c(27)*M(5,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(53))
  Gcoeff(:)%j = (c(25)*M(5,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,3,16,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(20),n2h32(54))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(55))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,3,8,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(22),n2h32(56))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(57))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,3,8,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(24),n2h32(58))
  Gcoeff(:)%j = (c(27)*M(6,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(59))
  Gcoeff(:)%j = (c(25)*M(6,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,3,8,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(26),n2h32(60))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(61))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,3,8,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(28),n2h32(62))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(29),n2h32(63))
  Gcoeff(:)%j = (-(c(27)*M(5,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,3,16,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(30),n2h32(64))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(65))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,3,16,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(32),n2h32(66))
  Gcoeff(:)%j = (c(27)*M(5,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(67))
  Gcoeff(:)%j = (c(25)*M(5,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,3,16,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(34),n2h32(68))
  Gcoeff(:)%j = (c(27)*M(3,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(69))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,3,16,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(36),n2h32(70))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(71))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,4,8,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(38),n2h32(72))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(39),n2h32(73))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,4,8,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(40),n2h32(74))
  Gcoeff(:)%j = (c(27)*M(4,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(75))
  Gcoeff(:)%j = (c(25)*M(4,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,4,8,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(42),n2h32(76))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(43),n2h32(77))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,4,8,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(44),n2h32(78))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(45),n2h32(79))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,3,4,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(46),n2h32(80))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(81))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,3,4,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(48),n2h32(82))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(83))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,3,4,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(50),n2h32(84))
  Gcoeff(:)%j = (c(27)*M(6,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(51),n2h32(85))
  Gcoeff(:)%j = (c(25)*M(6,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,3,4,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(52),n2h32(86))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(53),n2h32(87))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,8,4,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(54),n2h32(88))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(89))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,8,4,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(56),n2h32(90))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(57),n2h32(91))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,8,4,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(58),n2h32(92))
  Gcoeff(:)%j = (c(27)*M(4,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(93))
  Gcoeff(:)%j = (c(25)*M(4,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,8,4,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(60),n2h32(94))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(61),n2h32(95))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,3,8,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(62),n2h32(96))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(97))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,3,8,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(64),n2h32(98))
  Gcoeff(:)%j = (c(27)*M(6,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,125),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(65),n2h32(99))
  Gcoeff(:)%j = (c(25)*M(6,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,3,8,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,126),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(66),n2h32(100))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,127),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(67),n2h32(101))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,3,8,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,128),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(68),n2h32(102))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,129),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(103))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,4,16,3,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(70),n2h32(104))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,131),heltab2x64(:,:,131))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(71),n2h32(105))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,4,16,3,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(72),n2h32(106))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(73),n2h32(107))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,4,16,3,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(74),n2h32(108))
  Gcoeff(:)%j = (c(27)*M(4,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(75),n2h32(109))
  Gcoeff(:)%j = (c(25)*M(4,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,4,16,3,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(76),n2h32(110))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(77),n2h32(111))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,3,4,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(78),n2h32(112))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(79),n2h32(113))
  Gcoeff(:)%j = (-(c(27)*M(5,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,3,4,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(80),n2h32(114))
  Gcoeff(:)%j = (c(27)*M(3,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,141),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(81),n2h32(115))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,3,4,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,142),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(82),n2h32(116))
  Gcoeff(:)%j = (c(27)*M(5,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(83),n2h32(117))
  Gcoeff(:)%j = (c(25)*M(5,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,3,4,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(84),n2h32(118))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(85),n2h32(119))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,8,3,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(86),n2h32(120))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(87),n2h32(121))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,8,3,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(88),n2h32(122))
  Gcoeff(:)%j = (c(27)*M(4,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(89),n2h32(123))
  Gcoeff(:)%j = (c(25)*M(4,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,8,3,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(90),n2h32(124))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(91),n2h32(125))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,8,3,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,152),heltab2x64(:,:,152))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(92),n2h32(126))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,153),heltab2x64(:,:,153))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(93),n2h32(127))
  Gcoeff(:)%j = (-(c(27)*M(5,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,4,3,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,154),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(94),n2h32(128))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,155),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(95),n2h32(129))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,4,3,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,156),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(96),n2h32(130))
  Gcoeff(:)%j = (c(27)*M(5,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,157),heltab2x64(:,:,157))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(97),n2h32(131))
  Gcoeff(:)%j = (c(25)*M(5,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,4,3,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,158),heltab2x64(:,:,158))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(98),n2h32(132))
  Gcoeff(:)%j = (c(27)*M(3,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,159),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(99),n2h32(133))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,4,3,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,160),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(100),n2h32(134))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(28)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(101),n2h32(135))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,4,3,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(102),n2h32(136))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(28)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(137))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,4,3,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,164),heltab2x64(:,:,164))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(104),n2h32(138))
  Gcoeff(:)%j = (c(27)*M(6,:)%j-c(26)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(105),n2h32(139))
  Gcoeff(:)%j = (c(25)*M(6,:)%j-c(24)*M(11,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,4,3,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(106),n2h32(140))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,167),heltab2x64(:,:,167))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(107),n2h32(141))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(10,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,4,3,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,168),heltab2x64(:,:,168))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(108),n2h32(142))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,5,16,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,169),heltab2x64(:,:,169))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(143))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,5,16,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,5,8,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,171),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(144))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,5,8,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(112),m3h2x32(:,172),heltab2x64(:,:,172))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,2,8,16,5],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(113),m3h2x32(:,173),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,2,8,16,5],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,174),heltab2x64(:,:,174))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(114),n2h32(145))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,2,8,5,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,175),heltab2x64(:,:,175))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(115),n2h32(146))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,2,8,5,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(116),m3h2x32(:,176),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,5,2,8,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,177),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(117),n2h32(147))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,5,2,8,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,178),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,8,2,5,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,179),heltab2x64(:,:,179))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(119),n2h32(148))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,8,2,5,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(120),m3h2x32(:,180),heltab2x64(:,:,180))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,2,16,8,5],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(121),m3h2x32(:,181),heltab2x64(:,:,181))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,2,16,8,5],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,182),heltab2x64(:,:,182))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(122),n2h32(149))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,2,16,5,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(123),n2h32(150))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,2,16,5,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(124),m3h2x32(:,184),heltab2x64(:,:,184))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,5,2,16,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(125),n2h32(151))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,5,2,16,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(126),m3h2x32(:,186),heltab2x64(:,:,186))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,8,5,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,187),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(127),n2h32(152))
  Gcoeff(:)%j = (c(6)*M(4,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,8,5,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,188),heltab2x64(:,:,188))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,5,16,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,189),heltab2x64(:,:,189))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(129),n2h32(153))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,2,5,16,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(130),m3h2x32(:,190),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,5,8,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,191),heltab2x64(:,:,191))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(131),n2h32(154))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,5,8,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(132),m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,193),heltab2x64(:,:,193))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(133),n2h32(155))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(134),m3h2x32(:,194),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,195),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(135),n2h32(156))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,196),heltab2x64(:,:,196))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(137),m3h2x32(:,197),heltab2x64(:,:,197))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,198),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(138),n2h32(157))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,199),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(139),n2h32(158))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(140),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,201),heltab2x64(:,:,201))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(141),n2h32(159))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(142),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,203),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(143),n2h32(160))
  Gcoeff(:)%j = (c(6)*M(4,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(144),m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,1,16,8,6],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(145),m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,1,16,8,6],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,206),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(146),n2h32(161))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,1,16,6,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,207),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(147),n2h32(162))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,1,16,6,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(148),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,6,1,16,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,209),heltab2x64(:,:,209))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(149),n2h32(163))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,6,1,16,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(150),m3h2x32(:,210),heltab2x64(:,:,210))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,211),heltab2x64(:,:,211))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(151),n2h32(164))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(152),m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,1,6,16,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,213),heltab2x64(:,:,213))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(153),n2h32(165))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,1,6,16,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(154),m3h2x32(:,214),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,215),heltab2x64(:,:,215))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(155),n2h32(166))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(156),m3h2x32(:,216),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(4)*M(9,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,4,2,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,217),heltab2x64(:,:,217))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(157),n2h32(167))
  Gcoeff(:)%j = (-(c(16)*M(4,:)%j)-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,9,4,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(158),m3h2x32(:,218),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,2,4,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(159),m3h2x32(:,219),heltab2x64(:,:,219))
  Gcoeff(:)%j = (-(c(16)*M(6,:)%j)-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,2,4,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(160),m3h2x32(:,220),heltab2x64(:,:,220))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,9,2,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(161),n2h32(168))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,4,2,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,222),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(162),n2h32(169))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,2,16,4,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(163),m3h2x32(:,223),heltab2x64(:,:,223))
  Gcoeff(:)%j = (-(c(4)*M(9,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,2,16,9,4],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(164),n2h32(170))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,4,16,2,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(165),n2h32(171))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,4,9,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(166),n2h32(172))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,2,9,16,4],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,227),heltab2x64(:,:,227))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(167),n2h32(173))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(9,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,2,9,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,228),heltab2x64(:,:,228))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(168),n2h32(174))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,4,1,16,10],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,229),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(169),n2h32(175))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,10,4,1,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(170),m3h2x32(:,230),heltab2x64(:,:,230))
  Gcoeff(:)%j = (-(c(4)*M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,1,4,16,10],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(171),m3h2x32(:,231),heltab2x64(:,:,231))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,1,4,10,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(172),m3h2x32(:,232),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,10,1,4,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,233),heltab2x64(:,:,233))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(173),n2h32(176))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,4,1,10,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,234),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(174),n2h32(177))
  Gcoeff(:)%j = (-(c(4)*M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,1,16,4,10],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(175),m3h2x32(:,235),heltab2x64(:,:,235))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,1,16,10,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,236),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(176),n2h32(178))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,4,16,1,10],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,237),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(177),n2h32(179))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,4,10,1,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,238),heltab2x64(:,:,238))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(178),n2h32(180))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,1,10,16,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,239),heltab2x64(:,:,239))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(179),n2h32(181))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(9,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,1,10,4,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,240),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(180),n2h32(182))
  Gcoeff(:)%j = (-(c(4)*M(8,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,4,2,8,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,241),heltab2x64(:,:,241))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(181),n2h32(183))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,8,2,4,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(182),m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (c(4)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,2,4,8,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(183),m3h2x32(:,243),heltab2x64(:,:,243))
  Gcoeff(:)%j = (-(c(16)*M(5,:)%j)-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,2,4,17,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(184),m3h2x32(:,244),heltab2x64(:,:,244))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,8,4,2,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,245),heltab2x64(:,:,245))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(185),n2h32(184))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,4,2,17,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,246),heltab2x64(:,:,246))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(186),n2h32(185))
  Gcoeff(:)%j = (c(4)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,2,8,4,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(187),m3h2x32(:,247),heltab2x64(:,:,247))
  Gcoeff(:)%j = (-(c(4)*M(8,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,2,8,17,4],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,248),heltab2x64(:,:,248))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(188),n2h32(186))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,4,8,2,17],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,249),heltab2x64(:,:,249))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(189),n2h32(187))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,4,17,2,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,250),heltab2x64(:,:,250))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(190),n2h32(188))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,2,17,8,4],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,251),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(191),n2h32(189))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(8,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,2,17,4,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,252),heltab2x64(:,:,252))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(192),n2h32(190))
  Gcoeff(:)%j = (c(4)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,4,1,8,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(193),n2h32(191))
  Gcoeff(:)%j = (-(c(16)*M(4,:)%j)-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,8,1,4,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(194),m3h2x32(:,254),heltab2x64(:,:,254))
  Gcoeff(:)%j = (-(c(4)*M(8,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,1,4,8,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(195),m3h2x32(:,255),heltab2x64(:,:,255))
  Gcoeff(:)%j = (-(c(16)*M(3,:)%j)-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,1,4,18,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(196),m3h2x32(:,256),heltab2x64(:,:,256))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,8,4,1,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(197),n2h32(192))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,4,1,18,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(198),n2h32(193))
  Gcoeff(:)%j = (-(c(4)*M(8,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,1,8,4,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(199),m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (c(4)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,1,8,18,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,260),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(200),n2h32(194))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,4,8,1,18],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,261),heltab2x64(:,:,261))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(201),n2h32(195))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,4,18,1,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,262),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(202),n2h32(196))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,1,18,8,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,263),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(203),n2h32(197))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(8,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,1,18,4,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,264),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(204),n2h32(198))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,265),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(205),n2h32(199))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(3,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,266),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(206),n2h32(200))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(3,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,267),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(207),n2h32(201))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(3,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,268),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(208),n2h32(202))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,269),heltab2x64(:,:,269))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(209),n2h32(203))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,270),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(210),n2h32(204))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(3,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(211),m3h2x32(:,271),heltab2x64(:,:,271))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(212),m3h2x32(:,272),heltab2x64(:,:,272))
  Gcoeff(:)%j = (c(6)*(M(5,:)%j-M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(213),m3h2x32(:,273),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,274),heltab2x64(:,:,274))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(214),n2h32(205))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(215),m3h2x32(:,275),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,276),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(216),n2h32(206))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[33,8,2,4,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(25),m3h4x16(:,1),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[33,4,2,8,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(26),m3h4x16(:,2),heltab2x64(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(26),33,0,G1H16(25),n2h16(61))
  Gcoeff(:)%j = (-(c(4)*M(7,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[33,8,4,2,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(26),m3h4x16(:,3),heltab2x64(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(26),33,0,G1H16(26),n2h16(62))
  Gcoeff(:)%j = (-(c(16)*M(3,:)%j)-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[33,4,2,16,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(26),m3h4x16(:,4),heltab2x64(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(26),33,0,G1H16(28),n2h16(63))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[33,2,4,8,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(26),m3h4x16(:,5),heltab2x64(:,:,281))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[33,2,4,16,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(27),m3h4x16(:,6),heltab2x64(:,:,282))
  Gcoeff(:)%j = (-(c(4)*M(7,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[33,4,8,2,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(28),m3h4x16(:,7),heltab2x64(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(28),33,0,G1H16(29),n2h16(64))
  Gcoeff(:)%j = (-(c(4)*M(7,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[33,4,16,2,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(28),m3h4x16(:,8),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(28),33,0,G1H16(30),n2h16(65))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[33,2,8,4,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(28),m3h4x16(:,9),heltab2x64(:,:,285))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[33,2,8,16,4],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(29),m3h4x16(:,10),heltab2x64(:,:,286))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[33,2,16,4,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(30),m3h4x16(:,11),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(7,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[33,2,16,8,4],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(31),m3h4x16(:,12),heltab2x64(:,:,288))
  Gcoeff(:)%j = (-(c(4)*M(7,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[34,8,1,4,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(32),m3h4x16(:,13),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(16)*M(6,:)%j)-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[34,4,1,8,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,13),G0H16(33),m3h4x16(:,14),heltab2x64(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(1),n2h16(66))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[34,8,4,1,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,13),G0H16(33),m3h4x16(:,15),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(2),n2h16(67))
  Gcoeff(:)%j = (-(c(16)*M(5,:)%j)-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[34,4,1,16,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,13),G0H16(33),m3h4x16(:,16),heltab2x64(:,:,292))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(32),n2h16(68))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[34,1,4,8,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(33),m3h4x16(:,17),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[34,1,4,16,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(34),m3h4x16(:,18),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[34,4,8,1,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,13),G0H16(35),m3h4x16(:,19),heltab2x64(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(35),34,0,G1H16(33),n2h16(69))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[34,4,16,1,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,13),G0H16(35),m3h4x16(:,20),heltab2x64(:,:,296))
  call Hloop_A_Q(ntryL,G0H16(35),34,0,G1H16(34),n2h16(70))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[34,1,8,4,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(35),m3h4x16(:,21),heltab2x64(:,:,297))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[34,1,8,16,4],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(36),m3h4x16(:,22),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[34,1,16,4,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(37),m3h4x16(:,23),heltab2x64(:,:,299))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(7,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[34,1,16,8,4],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,13),G0H16(38),m3h4x16(:,24),heltab2x64(:,:,300))
  Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(4,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,25),heltab2x64(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(35),n2h16(71))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(5,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,26),heltab2x64(:,:,302))
  call Hloop_Q_A(ntryL,G0H16(39),40,0,G1H16(36),n2h16(72))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(5,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,27),heltab2x64(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(39),40,0,G1H16(38),n2h16(73))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(5,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,28),heltab2x64(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(39),40,0,G1H16(39),n2h16(74))
  Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(4,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,29),heltab2x64(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(40),n2h16(75))
  Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(4,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,30),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(3),n2h16(76))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(5,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,9),40,G1H16(4),m3h4x16(:,31),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,32),heltab2x64(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(39),40,0,G1H16(42),n2h16(77))
  Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(4,:)%j)+c(4)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,9),40,G1H16(43),m3h4x16(:,33),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,9),40,G1H16(44),m3h4x16(:,34),heltab2x64(:,:,310))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,9),G0H16(39),m3h4x16(:,35),heltab2x64(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(39),40,0,G1H16(45),n2h16(78))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,9),40,G1H16(46),m3h4x16(:,36),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,37),heltab2x64(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(39),48,0,G1H16(48),n2h16(79))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,38),heltab2x64(:,:,314))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(49),n2h16(80))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,39),heltab2x64(:,:,315))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(50),n2h16(81))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,40),heltab2x64(:,:,316))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(51),n2h16(82))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,41),heltab2x64(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(39),48,0,G1H16(52),n2h16(83))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,42),heltab2x64(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(39),48,0,G1H16(54),n2h16(84))
  Gcoeff(:)%j = (c(6)*(M(4,:)%j-M(6,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(55),m3h4x16(:,43),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,44),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(56),n2h16(85))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)+c(4)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(5),m3h4x16(:,45),heltab2x64(:,:,321))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(6),m3h4x16(:,46),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,47),heltab2x64(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(39),48,0,G1H16(8),n2h16(86))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(9),m3h4x16(:,48),heltab2x64(:,:,324))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(7),G0H16(18),G0H16(17),G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(1),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(67),G0H16(15),G0H16(14),G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(25),[G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G0H16(3),G0H16(2),G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G0H16(6),G0H16(5),G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G0H16(9),G0H16(8),G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G0H16(12),G0H16(11),G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G0H16(21),G0H16(20),G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G0H16(24),G0H16(23),G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(17),[G1H32(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(19),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(25),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(27),[G1H32(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(33),[G1H32(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(35),[G1H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(41),[G1H32(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(43),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(49),[G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(51),[G1H32(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(57),[G1H32(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(59),[G1H32(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(65),[G1H32(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(67),[G1H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(73),[G1H32(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(75),[G1H32(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(81),[G1H32(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(83),[G1H32(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(89),[G1H32(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(91),[G1H32(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(97),[G1H32(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(99),[G1H32(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(105),[G1H32(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(107),[G1H32(103)])
  call Hloop_AV_Q(ntryL,G1H16(35),ex3(:),G1H8(215),m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H8(215),44,0,G2H8(35),n2h8(199))
  call Hloop_AV_Q(ntryL,G1H16(31),ex4(:),G1H8(216),m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(216),44,0,G2H8(38),n2h8(200))
  call Hloop_QV_A(ntryL,G1H16(37),ex5(:),G1H8(233),m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H8(233),52,0,G2H8(39),n2h8(201))
  call Hloop_QV_A(ntryL,G1H16(38),ex3(:),G1H8(234),m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(234),44,0,G2H8(40),n2h8(202))
  call Hloop_QV_A(ntryL,G1H16(47),ex4(:),G1H8(251),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(251),44,0,G2H8(43),n2h8(203))
  call Hloop_AV_Q(ntryL,G1H16(53),ex5(:),G1H8(252),m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(252),52,0,G2H8(44),n2h8(204))
  call Hloop_VQ_A(ntryL,G1H16(43),ex1(:),G1H8(269),m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(269),41,0,G2H8(45),n2h8(205))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(270),m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(270),38,0,G2H8(48),n2h8(206))
  call Hloop_AV_Q(ntryL,G1H16(62),ex5(:),G1H8(287),m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(287),50,0,G2H8(49),n2h8(207))
  call Hloop_VA_Q(ntryL,G1H16(4),ex2(:),G1H8(288),m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(288),42,0,G2H8(50),n2h8(208))
  call Hloop_AV_Q(ntryL,G1H16(32),ex3(:),G1H8(305),m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(305),38,0,G2H8(53),n2h8(209))
  call Hloop_AV_Q(ntryL,G1H16(2),ex4(:),G1H8(306),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H8(306),42,0,G2H8(54),n2h8(210))
  call Hloop_QV_A(ntryL,G1H16(25),ex3(:),G1H8(323),m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H8(323),37,0,G2H8(55),n2h8(211))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(324),m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(324),37,0,G2H8(58),n2h8(212))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(341),m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(341),37,0,G2H8(59),n2h8(213))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(342),m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(342),37,0,G2H8(60),n2h8(214))
  call Hloop_QV_A(ntryL,G1H16(107),ex3(:),G1H8(359),m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(359),37,0,G2H8(63),n2h8(215))
  call Hloop_QV_A(ntryL,G1H16(113),ex3(:),G1H8(360),m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(360),37,0,G2H8(64),n2h8(216))
  call Hloop_AV_Q(ntryL,G1H16(33),ex3(:),G1H8(377),m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(377),38,0,G2H8(65),n2h8(217))
  call Hloop_AV_Q(ntryL,G1H16(34),ex3(:),G1H8(378),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(378),38,0,G2H8(68),n2h8(218))
  call Hloop_QV_A(ntryL,G1H16(26),ex4(:),G1H8(395),m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(395),41,0,G2H8(69),n2h8(219))
  call Hloop_QV_A(ntryL,G1H16(133),ex4(:),G1H8(396),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H8(396),41,0,G2H8(70),n2h8(220))
  call Hloop_QV_A(ntryL,G1H16(138),ex4(:),G1H8(413),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(413),41,0,G2H8(73),n2h8(221))
  call Hloop_QV_A(ntryL,G1H16(144),ex5(:),G1H8(414),m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(414),49,0,G2H8(74),n2h8(222))
  call Hloop_QV_A(ntryL,G1H16(148),ex5(:),G1H8(431),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(431),49,0,G2H8(75),n2h8(223))
  call Hloop_QV_A(ntryL,G1H16(153),ex5(:),G1H8(432),m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H8(432),49,0,G2H8(78),n2h8(224))
  call Hloop_VA_Q(ntryL,G1H16(55),ex2(:),G1H8(449),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H8(449),50,0,G2H8(79),n2h8(225))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(450),m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(450),49,0,G2H8(80),n2h8(226))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(467),m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(467),49,0,G2H8(83),n2h8(227))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(468),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(468),49,0,G2H8(84),n2h8(228))
  call Hloop_VQ_A(ntryL,G1H16(44),ex1(:),G1H8(485),m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H8(485),41,0,G2H8(85),n2h8(229))
  call Hloop_VQ_A(ntryL,G1H16(46),ex1(:),G1H8(486),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(486),41,0,G2H8(88),n2h8(230))
  call Hloop_VQ_A(ntryL,G1H32(1),ex1(:),G1H16(10),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H16(10),33,0,G2H16(7),n2h16(87))
  call Hloop_VQ_A(ntryL,G1H32(2),ex1(:),G1H16(11),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G1H16(11),33,0,G2H16(8),n2h16(88))
  call Hloop_VQ_A(ntryL,G1H32(3),ex1(:),G1H16(12),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(12),33,0,G2H16(9),n2h16(89))
  call Hloop_VA_Q(ntryL,G1H32(4),ex2(:),G1H16(58),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(58),34,0,G2H16(10),n2h16(90))
  call Hloop_VA_Q(ntryL,G1H32(5),ex2(:),G1H16(59),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(59),34,0,G2H16(11),n2h16(91))
  call Hloop_VA_Q(ntryL,G1H32(6),ex2(:),G1H16(60),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(60),34,0,G2H16(12),n2h16(92))
  call Hloop_QA_V(ntryL,G1H32(7),ex2(:),G1H16(13),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_QA_V(ntryL,G1H32(8),ex2(:),G1H16(61),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_QA_V(ntryL,G1H32(9),ex2(:),G1H16(63),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_AQ_V(ntryL,G1H32(10),ex1(:),G1H16(64),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_AQ_V(ntryL,G1H32(11),ex1(:),G1H16(65),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(14),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,20),G1H8(7),m3h4x8(:,1),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(89),n2h8(231))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,20),G1H8(8),m3h4x8(:,2),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(8),35,nMT,G2H8(90),n2h8(232))
  call Hloop_QV_A(ntryL,G1H32(19),wf4(:,20),G1H8(11),m3h4x8(:,3),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(11),35,0,G2H8(93),n2h8(233))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,20),G1H8(12),m3h4x8(:,4),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(12),35,nMT,G2H8(94),n2h8(234))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,20),G1H8(13),m3h4x8(:,5),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(13),35,nMB,G2H8(95),n2h8(235))
  call Hloop_QV_A(ntryL,G1H32(20),wf4(:,20),G1H8(14),m3h4x8(:,6),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(14),35,nMB,G2H8(98),n2h8(236))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,20),G1H8(17),m3h4x8(:,7),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(17),35,0,G2H8(99),n2h8(237))
  call Hloop_QV_A(ntryL,G1H32(22),wf4(:,20),G1H8(18),m3h4x8(:,8),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(18),35,nMT,G2H8(100),n2h8(238))
  call Hloop_AV_Q(ntryL,G1H32(27),wf4(:,20),G1H8(19),m3h4x8(:,9),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(103),n2h8(239))
  call Hloop_AV_Q(ntryL,G1H32(24),wf4(:,20),G1H8(20),m3h4x8(:,10),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(20),35,nMT,G2H8(104),n2h8(240))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,20),G1H8(23),m3h4x8(:,11),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(23),35,nMB,G2H8(105),n2h8(241))
  call Hloop_AV_Q(ntryL,G1H32(28),wf4(:,20),G1H8(24),m3h4x8(:,12),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(24),35,nMB,G2H8(108),n2h8(242))
  call Hloop_QV_A(ntryL,G1H32(33),wf4(:,20),G1H8(25),m3h4x8(:,13),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(25),35,0,G2H8(109),n2h8(243))
  call Hloop_QV_A(ntryL,G1H32(30),wf4(:,20),G1H8(26),m3h4x8(:,14),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(26),35,nMT,G2H8(110),n2h8(244))
  call Hloop_AV_Q(ntryL,G1H32(35),wf4(:,20),G1H8(29),m3h4x8(:,15),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(29),35,0,G2H8(113),n2h8(245))
  call Hloop_AV_Q(ntryL,G1H32(32),wf4(:,20),G1H8(30),m3h4x8(:,16),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(30),35,nMT,G2H8(114),n2h8(246))
  call Hloop_QV_A(ntryL,G1H32(34),wf4(:,20),G1H8(31),m3h4x8(:,17),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(31),35,nMB,G2H8(115),n2h8(247))
  call Hloop_AV_Q(ntryL,G1H32(36),wf4(:,20),G1H8(32),m3h4x8(:,18),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(32),35,nMB,G2H8(117),n2h8(248))
  call Hloop_AV_Q(ntryL,G1H32(41),ex3(:),G1H16(66),m3h2x16(:,73),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H16(66),36,0,G2H16(13),n2h16(93))
  call Hloop_AV_Q(ntryL,G1H32(38),ex3(:),G1H16(68),m3h2x16(:,74),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(68),36,nMT,G2H16(14),n2h16(94))
  call Hloop_QV_A(ntryL,G1H32(43),ex3(:),G1H16(69),m3h2x16(:,75),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(69),36,0,G2H16(15),n2h16(95))
  call Hloop_QV_A(ntryL,G1H32(40),ex3(:),G1H16(70),m3h2x16(:,76),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(70),36,nMT,G2H16(16),n2h16(96))
  call Hloop_AV_Q(ntryL,G1H32(42),ex3(:),G1H16(71),m3h2x16(:,77),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H16(71),36,nMB,G2H16(17),n2h16(97))
  call Hloop_QV_A(ntryL,G1H32(44),ex3(:),G1H16(72),m3h2x16(:,78),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H16(72),36,nMB,G2H16(18),n2h16(98))
  call Hloop_AV_Q(ntryL,G1H32(49),wf4(:,20),G1H8(35),m3h4x8(:,19),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(35),35,0,G2H8(118),n2h8(249))
  call Hloop_AV_Q(ntryL,G1H32(46),wf4(:,20),G1H8(36),m3h4x8(:,20),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(36),35,nMT,G2H8(119),n2h8(250))
  call Hloop_QV_A(ntryL,G1H32(51),wf4(:,20),G1H8(37),m3h4x8(:,21),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(37),35,0,G2H8(121),n2h8(251))
  call Hloop_QV_A(ntryL,G1H32(48),wf4(:,20),G1H8(38),m3h4x8(:,22),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(38),35,nMT,G2H8(122),n2h8(252))
  call Hloop_AV_Q(ntryL,G1H32(50),wf4(:,20),G1H8(41),m3h4x8(:,23),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(41),35,nMB,G2H8(123),n2h8(253))
  call Hloop_QV_A(ntryL,G1H32(52),wf4(:,20),G1H8(42),m3h4x8(:,24),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(42),35,nMB,G2H8(126),n2h8(254))
  call Hloop_QV_A(ntryL,G1H32(57),ex4(:),G1H16(74),m3h2x16(:,79),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H16(74),40,0,G2H16(19),n2h16(99))
  call Hloop_QV_A(ntryL,G1H32(54),ex4(:),G1H16(75),m3h2x16(:,80),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G1H16(75),40,nMT,G2H16(20),n2h16(100))
  call Hloop_AV_Q(ntryL,G1H32(59),ex4(:),G1H16(76),m3h2x16(:,81),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H16(76),40,0,G2H16(21),n2h16(101))
  call Hloop_AV_Q(ntryL,G1H32(56),ex4(:),G1H16(77),m3h2x16(:,82),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H16(77),40,nMT,G2H16(22),n2h16(102))
  call Hloop_QV_A(ntryL,G1H32(58),ex4(:),G1H16(78),m3h2x16(:,83),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G1H16(78),40,nMB,G2H16(23),n2h16(103))
  call Hloop_AV_Q(ntryL,G1H32(60),ex4(:),G1H16(80),m3h2x16(:,84),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H16(80),40,nMB,G2H16(24),n2h16(104))
  call Hloop_QV_A(ntryL,G1H32(65),wf4(:,20),G1H8(43),m3h4x8(:,25),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(43),35,0,G2H8(127),n2h8(255))
  call Hloop_QV_A(ntryL,G1H32(62),wf4(:,20),G1H8(44),m3h4x8(:,26),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(44),35,nMT,G2H8(128),n2h8(256))
  call Hloop_AV_Q(ntryL,G1H32(67),wf4(:,20),G1H8(47),m3h4x8(:,27),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(47),35,0,G2H8(131),n2h8(257))
  call Hloop_AV_Q(ntryL,G1H32(64),wf4(:,20),G1H8(48),m3h4x8(:,28),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(48),35,nMT,G2H8(132),n2h8(258))
  call Hloop_QV_A(ntryL,G1H32(66),wf4(:,20),G1H8(49),m3h4x8(:,29),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(49),35,nMB,G2H8(133),n2h8(259))
  call Hloop_AV_Q(ntryL,G1H32(68),wf4(:,20),G1H8(50),m3h4x8(:,30),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(50),35,nMB,G2H8(136),n2h8(260))
  call Hloop_AV_Q(ntryL,G1H32(73),ex3(:),G1H16(81),m3h2x16(:,85),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G1H16(81),36,0,G2H16(25),n2h16(105))
  call Hloop_AV_Q(ntryL,G1H32(70),ex3(:),G1H16(82),m3h2x16(:,86),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G1H16(82),36,nMT,G2H16(26),n2h16(106))
  call Hloop_QV_A(ntryL,G1H32(75),ex3(:),G1H16(15),m3h2x16(:,87),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H16(15),36,0,G2H16(27),n2h16(107))
  call Hloop_QV_A(ntryL,G1H32(72),ex3(:),G1H16(16),m3h2x16(:,88),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H16(16),36,nMT,G2H16(28),n2h16(108))
  call Hloop_AV_Q(ntryL,G1H32(74),ex3(:),G1H16(84),m3h2x16(:,89),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H16(84),36,nMB,G2H16(29),n2h16(109))
  call Hloop_QV_A(ntryL,G1H32(76),ex3(:),G1H16(85),m3h2x16(:,90),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H16(85),36,nMB,G2H16(30),n2h16(110))
  call Hloop_AV_Q(ntryL,G1H32(81),wf4(:,20),G1H8(53),m3h4x8(:,31),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(53),35,0,G2H8(137),n2h8(261))
  call Hloop_AV_Q(ntryL,G1H32(78),wf4(:,20),G1H8(54),m3h4x8(:,32),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(54),35,nMT,G2H8(138),n2h8(262))
  call Hloop_QV_A(ntryL,G1H32(83),wf4(:,20),G1H8(55),m3h4x8(:,33),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(55),35,0,G2H8(140),n2h8(263))
  call Hloop_QV_A(ntryL,G1H32(80),wf4(:,20),G1H8(56),m3h4x8(:,34),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(56),35,nMT,G2H8(141),n2h8(264))
  call Hloop_AV_Q(ntryL,G1H32(82),wf4(:,20),G1H8(59),m3h4x8(:,35),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(59),35,nMB,G2H8(142),n2h8(265))
  call Hloop_QV_A(ntryL,G1H32(84),wf4(:,20),G1H8(60),m3h4x8(:,36),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(60),35,nMB,G2H8(144),n2h8(266))
  call Hloop_AV_Q(ntryL,G1H32(89),ex4(:),G1H16(86),m3h2x16(:,91),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H16(86),40,0,G2H16(31),n2h16(111))
  call Hloop_AV_Q(ntryL,G1H32(86),ex4(:),G1H16(87),m3h2x16(:,92),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H16(87),40,nMT,G2H16(32),n2h16(112))
  call Hloop_QV_A(ntryL,G1H32(91),ex4(:),G1H16(88),m3h2x16(:,93),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H16(88),40,0,G2H16(33),n2h16(113))
  call Hloop_QV_A(ntryL,G1H32(88),ex4(:),G1H16(90),m3h2x16(:,94),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(90),40,nMT,G2H16(34),n2h16(114))
  call Hloop_AV_Q(ntryL,G1H32(90),ex4(:),G1H16(91),m3h2x16(:,95),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G1H16(91),40,nMB,G2H16(35),n2h16(115))
  call Hloop_QV_A(ntryL,G1H32(92),ex4(:),G1H16(92),m3h2x16(:,96),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(92),40,nMB,G2H16(36),n2h16(116))
  call Hloop_QV_A(ntryL,G1H32(97),ex3(:),G1H16(93),m3h2x16(:,97),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G1H16(93),36,0,G2H16(1),n2h16(117))
  call Hloop_QV_A(ntryL,G1H32(94),ex3(:),G1H16(94),m3h2x16(:,98),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(94),36,nMT,G2H16(2),n2h16(118))
  call Hloop_AV_Q(ntryL,G1H32(99),ex3(:),G1H16(96),m3h2x16(:,99),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G1H16(96),36,0,G2H16(3),n2h16(119))
  call Hloop_AV_Q(ntryL,G1H32(96),ex3(:),G1H16(97),m3h2x16(:,100),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H16(97),36,nMT,G2H16(4),n2h16(120))
  call Hloop_QV_A(ntryL,G1H32(98),ex3(:),G1H16(98),m3h2x16(:,101),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G1H16(98),36,nMB,G2H16(5),n2h16(121))
  call Hloop_AV_Q(ntryL,G1H32(100),ex3(:),G1H16(99),m3h2x16(:,102),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H16(99),36,nMB,G2H16(6),n2h16(122))
  call Hloop_QV_A(ntryL,G1H32(105),ex3(:),G1H16(100),m3h2x16(:,103),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G1H16(100),36,0,G2H16(37),n2h16(123))
  call Hloop_QV_A(ntryL,G1H32(102),ex3(:),G1H16(102),m3h2x16(:,104),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G1H16(102),36,nMT,G2H16(38),n2h16(124))
  call Hloop_AV_Q(ntryL,G1H32(107),ex3(:),G1H16(103),m3h2x16(:,105),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H16(103),36,0,G2H16(39),n2h16(125))
  call Hloop_AV_Q(ntryL,G1H32(104),ex3(:),G1H16(104),m3h2x16(:,106),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G1H16(104),36,nMT,G2H16(40),n2h16(126))
  call Hloop_QV_A(ntryL,G1H32(106),ex3(:),G1H16(105),m3h2x16(:,107),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G1H16(105),36,nMB,G2H16(41),n2h16(127))
  call Hloop_AV_Q(ntryL,G1H32(108),ex3(:),G1H16(106),m3h2x16(:,108),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G1H16(106),36,nMB,G2H16(42),n2h16(128))
  call Hloop_AQ_V(ntryL,G1H32(109),wf4(:,2),G1H8(61),m3h4x8(:,37),heltab2x32(:,:,145))
  call Hloop_VQ_A(ntryL,G1H32(110),wf4(:,2),G1H8(62),m3h4x8(:,38),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(62),37,0,G2H8(145),n2h8(267))
  call Hloop_AQ_V(ntryL,G1H32(111),wf4(:,2),G1H8(65),m3h4x8(:,39),heltab2x32(:,:,147))
  call Hloop_VQ_A(ntryL,G1H32(112),wf4(:,2),G1H8(66),m3h4x8(:,40),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(66),37,0,G2H8(146),n2h8(268))
  call Hloop_VA_Q(ntryL,G1H32(113),ex2(:),G1H16(108),m3h2x16(:,109),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H16(108),34,0,G2H16(43),n2h16(129))
  call Hloop_QA_V(ntryL,G1H32(114),ex2(:),G1H16(109),m3h2x16(:,110),heltab2x32(:,:,150))
  call Hloop_QA_V(ntryL,G1H32(115),ex2(:),G1H16(110),m3h2x16(:,111),heltab2x32(:,:,151))
  call Hloop_VA_Q(ntryL,G1H32(116),ex2(:),G1H16(111),m3h2x16(:,112),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(111),34,0,G2H16(44),n2h16(130))
  call Hloop_AQ_V(ntryL,G1H32(117),wf4(:,2),G1H8(67),m3h4x8(:,41),heltab2x32(:,:,153))
  call Hloop_VQ_A(ntryL,G1H32(118),wf4(:,2),G1H8(68),m3h4x8(:,42),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(68),37,0,G2H8(149),n2h8(269))
  call Hloop_QV_A(ntryL,G1H32(119),ex4(:),G1H16(112),m3h2x16(:,113),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G1H16(112),40,0,G2H16(45),n2h16(131))
  call Hloop_UV_W(ntryL,G1H32(120),32,ex4(:),8,G2H16(46),m3h2x16(:,114),heltab2x32(:,:,156))
  call Hloop_VA_Q(ntryL,G1H32(121),ex2(:),G1H16(114),m3h2x16(:,115),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H16(114),34,0,G2H16(47),n2h16(132))
  call Hloop_QA_V(ntryL,G1H32(122),ex2(:),G1H16(115),m3h2x16(:,116),heltab2x32(:,:,158))
  call Hloop_QA_V(ntryL,G1H32(123),ex2(:),G1H16(116),m3h2x16(:,117),heltab2x32(:,:,159))
  call Hloop_VA_Q(ntryL,G1H32(124),ex2(:),G1H16(117),m3h2x16(:,118),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H16(117),34,0,G2H16(48),n2h16(133))
  call Hloop_AQ_V(ntryL,G1H32(125),wf4(:,2),G1H8(71),m3h4x8(:,43),heltab2x32(:,:,161))
  call Hloop_VQ_A(ntryL,G1H32(126),wf4(:,2),G1H8(72),m3h4x8(:,44),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(72),37,0,G2H8(150),n2h8(270))
  call Hloop_AV_Q(ntryL,G1H32(127),ex4(:),G1H16(118),m3h2x16(:,119),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H16(118),40,0,G2H16(49),n2h16(134))
  call Hloop_UV_W(ntryL,G1H32(128),32,ex4(:),8,G2H16(50),m3h2x16(:,120),heltab2x32(:,:,164))
  call Hloop_QA_V(ntryL,G1H32(129),ex2(:),G1H16(120),m3h2x16(:,121),heltab2x32(:,:,165))
  call Hloop_VA_Q(ntryL,G1H32(130),ex2(:),G1H16(121),m3h2x16(:,122),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H16(121),34,0,G2H16(51),n2h16(135))
  call Hloop_QA_V(ntryL,G1H32(131),ex2(:),G1H16(122),m3h2x16(:,123),heltab2x32(:,:,167))
  call Hloop_VA_Q(ntryL,G1H32(132),ex2(:),G1H16(123),m3h2x16(:,124),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H16(123),34,0,G2H16(52),n2h16(136))
  call Hloop_QA_V(ntryL,G1H32(133),wf4(:,4),G1H8(73),m3h4x8(:,45),heltab2x32(:,:,169))
  call Hloop_VA_Q(ntryL,G1H32(134),wf4(:,4),G1H8(74),m3h4x8(:,46),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(74),38,0,G2H8(151),n2h8(271))
  call Hloop_QA_V(ntryL,G1H32(135),wf4(:,4),G1H8(77),m3h4x8(:,47),heltab2x32(:,:,171))
  call Hloop_VA_Q(ntryL,G1H32(136),wf4(:,4),G1H8(78),m3h4x8(:,48),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(78),38,0,G2H8(153),n2h8(272))
  call Hloop_VQ_A(ntryL,G1H32(137),ex1(:),G1H16(124),m3h2x16(:,125),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G1H16(124),33,0,G2H16(53),n2h16(137))
  call Hloop_AQ_V(ntryL,G1H32(138),ex1(:),G1H16(126),m3h2x16(:,126),heltab2x32(:,:,174))
  call Hloop_AQ_V(ntryL,G1H32(139),ex1(:),G1H16(127),m3h2x16(:,127),heltab2x32(:,:,175))
  call Hloop_VQ_A(ntryL,G1H32(140),ex1(:),G1H16(128),m3h2x16(:,128),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G1H16(128),33,0,G2H16(54),n2h16(138))
  call Hloop_QA_V(ntryL,G1H32(141),wf4(:,4),G1H8(79),m3h4x8(:,49),heltab2x32(:,:,177))
  call Hloop_VA_Q(ntryL,G1H32(142),wf4(:,4),G1H8(80),m3h4x8(:,50),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G1H8(80),38,0,G2H8(154),n2h8(273))
  call Hloop_AV_Q(ntryL,G1H32(143),ex4(:),G1H16(17),m3h2x16(:,129),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H16(17),40,0,G2H16(55),n2h16(139))
  call Hloop_UV_W(ntryL,G1H32(144),32,ex4(:),8,G2H16(56),m3h2x16(:,130),heltab2x32(:,:,180))
  call Hloop_VQ_A(ntryL,G1H32(145),ex1(:),G1H16(18),m3h2x16(:,131),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G1H16(18),33,0,G2H16(57),n2h16(140))
  call Hloop_AQ_V(ntryL,G1H32(146),ex1(:),G1H16(129),m3h2x16(:,132),heltab2x32(:,:,182))
  call Hloop_AQ_V(ntryL,G1H32(147),ex1(:),G1H16(130),m3h2x16(:,133),heltab2x32(:,:,183))
  call Hloop_VQ_A(ntryL,G1H32(148),ex1(:),G1H16(131),m3h2x16(:,134),heltab2x32(:,:,184))
  call Hloop_Q_A(ntryL,G1H16(131),33,0,G2H16(58),n2h16(141))
  call Hloop_QA_V(ntryL,G1H32(149),wf4(:,4),G1H8(83),m3h4x8(:,51),heltab2x32(:,:,185))
  call Hloop_VA_Q(ntryL,G1H32(150),wf4(:,4),G1H8(84),m3h4x8(:,52),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(84),38,0,G2H8(155),n2h8(274))
  call Hloop_QV_A(ntryL,G1H32(151),ex4(:),G1H16(20),m3h2x16(:,135),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G1H16(20),40,0,G2H16(59),n2h16(142))
  call Hloop_UV_W(ntryL,G1H32(152),32,ex4(:),8,G2H16(60),m3h2x16(:,136),heltab2x32(:,:,188))
  call Hloop_AQ_V(ntryL,G1H32(153),ex1(:),G1H16(132),m3h2x16(:,137),heltab2x32(:,:,189))
  call Hloop_VQ_A(ntryL,G1H32(154),ex1(:),G1H16(134),m3h2x16(:,138),heltab2x32(:,:,190))
  call Hloop_Q_A(ntryL,G1H16(134),33,0,G2H16(61),n2h16(143))
  call Hloop_AQ_V(ntryL,G1H32(155),ex1(:),G1H16(135),m3h2x16(:,139),heltab2x32(:,:,191))
  call Hloop_VQ_A(ntryL,G1H32(156),ex1(:),G1H16(136),m3h2x16(:,140),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G1H16(136),33,0,G2H16(62),n2h16(144))
  call Hloop_QV_A(ntryL,G1H32(157),ex3(:),G1H16(21),m3h2x16(:,141),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G1H16(21),36,0,G2H16(63),n2h16(145))
  call Hloop_VQ_A(ntryL,G1H32(158),wf4(:,15),G1H8(85),m3h4x8(:,53),heltab2x32(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(85),41,0,G2H8(157),n2h8(275))
  call Hloop_VA_Q(ntryL,G1H32(159),ex2(:),G1H16(137),m3h2x16(:,142),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G1H16(137),34,0,G2H16(64),n2h16(146))
  call Hloop_VA_Q(ntryL,G1H32(160),ex2(:),G1H16(139),m3h2x16(:,143),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G1H16(139),34,0,G2H16(65),n2h16(147))
  call Hloop_AQ_V(ntryL,G1H32(161),wf4(:,15),G1H8(86),m3h4x8(:,54),heltab2x32(:,:,197))
  call Hloop_QV_A(ntryL,G1H32(162),ex3(:),G1H16(140),m3h2x16(:,144),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G1H16(140),36,0,G2H16(66),n2h16(148))
  call Hloop_VA_Q(ntryL,G1H32(163),ex2(:),G1H16(141),m3h2x16(:,145),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G1H16(141),34,0,G2H16(67),n2h16(149))
  call Hloop_QA_V(ntryL,G1H32(164),ex2(:),G1H16(142),m3h2x16(:,146),heltab2x32(:,:,200))
  call Hloop_QV_A(ntryL,G1H32(165),ex3(:),G1H16(143),m3h2x16(:,147),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G1H16(143),36,0,G2H16(68),n2h16(150))
  call Hloop_AV_Q(ntryL,G1H32(166),ex3(:),G1H16(145),m3h2x16(:,148),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(145),36,0,G2H16(69),n2h16(151))
  call Hloop_QA_V(ntryL,G1H32(167),ex2(:),G1H16(146),m3h2x16(:,149),heltab2x32(:,:,203))
  call Hloop_QA_V(ntryL,G1H32(168),ex2(:),G1H16(147),m3h2x16(:,150),heltab2x32(:,:,204))
  call Hloop_AV_Q(ntryL,G1H32(169),ex3(:),G1H16(22),m3h2x16(:,151),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G1H16(22),36,0,G2H16(70),n2h16(152))
  call Hloop_VA_Q(ntryL,G1H32(170),wf4(:,7),G1H8(89),m3h4x8(:,55),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(89),42,0,G2H8(158),n2h8(276))
  call Hloop_VQ_A(ntryL,G1H32(171),ex1(:),G1H16(23),m3h2x16(:,152),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(71),n2h16(153))
  call Hloop_VQ_A(ntryL,G1H32(172),ex1(:),G1H16(149),m3h2x16(:,153),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G1H16(149),33,0,G2H16(72),n2h16(154))
  call Hloop_QA_V(ntryL,G1H32(173),wf4(:,7),G1H8(90),m3h4x8(:,56),heltab2x32(:,:,209))
  call Hloop_AV_Q(ntryL,G1H32(174),ex3(:),G1H16(150),m3h2x16(:,154),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G1H16(150),36,0,G2H16(73),n2h16(155))
  call Hloop_VQ_A(ntryL,G1H32(175),ex1(:),G1H16(151),m3h2x16(:,155),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G1H16(151),33,0,G2H16(74),n2h16(156))
  call Hloop_AQ_V(ntryL,G1H32(176),ex1(:),G1H16(24),m3h2x16(:,156),heltab2x32(:,:,212))
  call Hloop_AV_Q(ntryL,G1H32(177),ex3(:),G1H16(152),m3h2x16(:,157),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(152),36,0,G2H16(75),n2h16(157))
  call Hloop_QV_A(ntryL,G1H32(178),ex3(:),G1H16(154),m3h2x16(:,158),heltab2x32(:,:,214))
  call Hloop_Q_A(ntryL,G1H16(154),36,0,G2H16(76),n2h16(158))
  call Hloop_AQ_V(ntryL,G1H32(179),ex1(:),G1H16(155),m3h2x16(:,159),heltab2x32(:,:,215))
  call Hloop_AQ_V(ntryL,G1H32(180),ex1(:),G1H16(156),m3h2x16(:,160),heltab2x32(:,:,216))
  call Hloop_QV_A(ntryL,G1H32(181),ex3(:),G1H16(27),m3h2x16(:,161),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G1H16(27),36,0,G2H16(77),n2h16(159))
  call Hloop_UV_W(ntryL,G1H32(182),32,ex4(:),8,G2H16(78),m3h2x16(:,162),heltab2x32(:,:,218))
  call Hloop_VA_Q(ntryL,G1H32(183),ex2(:),G1H16(41),m3h2x16(:,163),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G1H16(41),34,0,G2H16(79),n2h16(160))
  call Hloop_VA_Q(ntryL,G1H32(184),ex2(:),G1H16(7),m3h2x16(:,164),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H16(7),34,0,G2H16(80),n2h16(161))
  call Hloop_QV_A(ntryL,G1H32(185),ex4(:),G1H16(57),m3h2x16(:,165),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G1H16(57),40,0,G2H16(81),n2h16(162))
  call Hloop_QV_A(ntryL,G1H32(186),ex3(:),G1H16(67),m3h2x16(:,166),heltab2x32(:,:,222))
  call Hloop_Q_A(ntryL,G1H16(67),36,0,G2H16(82),n2h16(163))
  call Hloop_VA_Q(ntryL,G1H32(187),ex2(:),G1H16(73),m3h2x16(:,167),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(83),n2h16(164))
  call Hloop_QA_V(ntryL,G1H32(188),ex2(:),G1H16(79),m3h2x16(:,168),heltab2x32(:,:,224))
  call Hloop_QV_A(ntryL,G1H32(189),ex3(:),G1H16(83),m3h2x16(:,169),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G1H16(83),36,0,G2H16(84),n2h16(165))
  call Hloop_AV_Q(ntryL,G1H32(190),ex3(:),G1H16(89),m3h2x16(:,170),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G1H16(89),36,0,G2H16(85),n2h16(166))
  call Hloop_QA_V(ntryL,G1H32(191),ex2(:),G1H16(95),m3h2x16(:,171),heltab2x32(:,:,227))
  call Hloop_QA_V(ntryL,G1H32(192),ex2(:),G1H16(101),m3h2x16(:,172),heltab2x32(:,:,228))
  call Hloop_AV_Q(ntryL,G1H32(193),ex3(:),G1H16(119),m3h2x16(:,173),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G1H16(119),36,0,G2H16(86),n2h16(167))
  call Hloop_UV_W(ntryL,G1H32(194),32,ex4(:),8,G2H16(87),m3h2x16(:,174),heltab2x32(:,:,230))
  call Hloop_VQ_A(ntryL,G1H32(195),ex1(:),G1H16(125),m3h2x16(:,175),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G1H16(125),33,0,G2H16(88),n2h16(168))
  call Hloop_VQ_A(ntryL,G1H32(196),ex1(:),G1H16(19),m3h2x16(:,176),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G1H16(19),33,0,G2H16(89),n2h16(169))
  call Hloop_AV_Q(ntryL,G1H32(197),ex4(:),G1H16(35),m3h2x16(:,177),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G1H16(35),40,0,G2H16(90),n2h16(170))
  call Hloop_AV_Q(ntryL,G1H32(198),ex3(:),G1H16(31),m3h2x16(:,178),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G1H16(31),36,0,G2H16(91),n2h16(171))
  call Hloop_VQ_A(ntryL,G1H32(199),ex1(:),G1H16(37),m3h2x16(:,179),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G1H16(37),33,0,G2H16(92),n2h16(172))
  call Hloop_AQ_V(ntryL,G1H32(200),ex1(:),G1H16(38),m3h2x16(:,180),heltab2x32(:,:,236))
  call Hloop_AV_Q(ntryL,G1H32(201),ex3(:),G1H16(47),m3h2x16(:,181),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G1H16(47),36,0,G2H16(93),n2h16(173))
  call Hloop_QV_A(ntryL,G1H32(202),ex3(:),G1H16(53),m3h2x16(:,182),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G1H16(53),36,0,G2H16(94),n2h16(174))
  call Hloop_AQ_V(ntryL,G1H32(203),ex1(:),G1H16(43),m3h2x16(:,183),heltab2x32(:,:,239))
  call Hloop_AQ_V(ntryL,G1H32(204),ex1(:),G1H16(1),m3h2x16(:,184),heltab2x32(:,:,240))
  call Hloop_QA_V(ntryL,G1H32(205),ex2(:),G1H16(62),m3h2x16(:,185),heltab2x32(:,:,241))
  call Hloop_AV_Q(ntryL,G1H32(206),ex3(:),G1H16(4),m3h2x16(:,186),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G1H16(4),36,0,G2H16(95),n2h16(175))
  call Hloop_AQ_V(ntryL,G1H32(207),ex1(:),G1H16(32),m3h2x16(:,187),heltab2x32(:,:,243))
  call Hloop_AQ_V(ntryL,G1H32(208),ex1(:),G1H16(2),m3h2x16(:,188),heltab2x32(:,:,244))
  call Hloop_QV_A(ntryL,G1H32(209),ex3(:),G1H16(25),m3h2x16(:,189),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G1H16(25),36,0,G2H16(96),n2h16(176))
  call Hloop_QA_V(ntryL,G1H32(210),ex2(:),G1H16(28),m3h2x16(:,190),heltab2x32(:,:,246))
  call Hloop_VQ_A(ntryL,G1H32(211),ex1(:),G1H16(29),m3h2x16(:,191),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G1H16(29),33,0,G2H16(97),n2h16(177))
  call Hloop_VQ_A(ntryL,G1H32(212),ex1(:),G1H16(30),m3h2x16(:,192),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G1H16(30),33,0,G2H16(98),n2h16(178))
  call Hloop_VA_Q(ntryL,G1H32(213),ex2(:),G1H16(107),m3h2x16(:,193),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G1H16(107),34,0,G2H16(99),n2h16(179))
  call Hloop_QA_V(ntryL,G1H32(214),ex2(:),G1H16(113),m3h2x16(:,194),heltab2x32(:,:,250))
  call Hloop_VQ_A(ntryL,G1H32(215),ex1(:),G1H16(33),m3h2x16(:,195),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G1H16(33),33,0,G2H16(100),n2h16(180))
  call Hloop_AQ_V(ntryL,G1H32(216),ex1(:),G1H16(34),m3h2x16(:,196),heltab2x32(:,:,252))
  call Hloop_UV_W(ntryL,G0H16(25),33,ex4(:),8,G1H8(91),m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_VA_Q(ntryL,G0H16(26),ex2(:),G0H8(1),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(92),n2h8(277))
  call Hloop_VA_Q(ntryL,G0H16(27),ex2(:),G0H8(1),m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(95),n2h8(278))
  call Hloop_VA_Q(ntryL,G0H16(28),ex2(:),G0H8(1),m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(96),n2h8(279))
  call Hloop_VA_Q(ntryL,G0H16(29),ex2(:),G0H8(1),m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(97),n2h8(280))
  call Hloop_VA_Q(ntryL,G0H16(30),ex2(:),G0H8(1),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(98),n2h8(281))
  call Hloop_VA_Q(ntryL,G0H16(31),ex2(:),G0H8(1),m3h2x8(:,203),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(101),n2h8(282))
  call Hloop_UV_W(ntryL,G0H16(32),34,ex4(:),8,G1H8(102),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_VQ_A(ntryL,G0H16(33),ex1(:),G0H8(1),m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(103),n2h8(283))
  call Hloop_VQ_A(ntryL,G0H16(34),ex1(:),G0H8(1),m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(104),n2h8(284))
  call Hloop_VQ_A(ntryL,G0H16(35),ex1(:),G0H8(1),m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(107),n2h8(285))
  call Hloop_VQ_A(ntryL,G0H16(36),ex1(:),G0H8(1),m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(108),n2h8(286))
  call Hloop_VQ_A(ntryL,G0H16(37),ex1(:),G0H8(1),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(109),n2h8(287))
  call Hloop_VQ_A(ntryL,G0H16(38),ex1(:),G0H8(1),m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(110),n2h8(288))
  call Hloop_QA_V(ntryL,G1H16(36),ex2(:),G1H8(113),m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_QA_V(ntryL,G1H16(39),ex2(:),G1H8(114),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_AQ_V(ntryL,G1H16(40),ex1(:),G1H8(115),m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(116),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_QA_V(ntryL,G1H16(42),ex2(:),G1H8(119),m3h2x8(:,215),heltab2x16(:,:,215))
  call Hloop_AQ_V(ntryL,G1H16(45),ex1(:),G1H8(120),m3h2x8(:,216),heltab2x16(:,:,216))
  call Hloop_AV_Q(ntryL,G1H16(48),ex3(:),G1H8(121),m3h2x8(:,217),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H8(121),52,0,G2H8(1),n2h8(289))
  call Hloop_QA_V(ntryL,G1H16(49),ex2(:),G1H8(122),m3h2x8(:,218),heltab2x16(:,:,218))
  call Hloop_QV_A(ntryL,G1H16(50),ex3(:),G1H8(125),m3h2x8(:,219),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H8(125),52,0,G2H8(2),n2h8(290))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(126),m3h2x8(:,220),heltab2x16(:,:,220))
  call Hloop_AQ_V(ntryL,G1H16(52),ex1(:),G1H8(127),m3h2x8(:,221),heltab2x16(:,:,221))
  call Hloop_AQ_V(ntryL,G1H16(54),ex1(:),G1H8(128),m3h2x8(:,222),heltab2x16(:,:,222))
  call Hloop_QA_V(ntryL,G1H16(56),ex2(:),G1H8(131),m3h2x8(:,223),heltab2x16(:,:,223))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(132),m3h2x8(:,224),heltab2x16(:,:,224))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G2H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G2H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(157),[G2H8(135),G2H8(67),G1H8(394),G1H8(214)])
call HGT_lower_alpha_OLR(G2H8(71),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(71),2,5,8)
call HGT_lower_alpha_OLR(G2H8(71),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(71),[G2H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(154),[G2H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G1H8(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(158),[G2H8(92),G2H8(82),G1H8(268),G1H8(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G1H8(249)])
call HGT_lower_alpha_OLR(G2H8(86),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(86),2,5,8)
call HGT_lower_alpha_OLR(G2H8(86),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(86),[G2H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(155),[G2H8(87)])
call HGT_lower_alpha_OLR(G2H8(96),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(96),2,5,8)
call HGT_lower_alpha_OLR(G2H8(96),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(96),[G2H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(149),[G2H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(213)])
call HGT_lower_alpha_OLR(G2H8(101),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(101),2,5,8)
call HGT_lower_alpha_OLR(G2H8(101),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(101),[G2H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(150),[G2H8(102)])
call HGT_lower_alpha_OLR(G2H8(106),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(106),2,5,8)
call HGT_lower_alpha_OLR(G2H8(106),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(106),[G2H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(146),[G2H8(107),G1H8(286)])
call HGT_lower_alpha_OLR(G2H8(111),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(111),2,5,8)
call HGT_lower_alpha_OLR(G2H8(111),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(111),[G2H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(145),[G2H8(112),G1H8(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(33)])
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(116),[G1H8(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(27)])
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(120),[G1H8(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(153),[G2H8(125),G1H8(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(151),[G2H8(130),G1H8(376)])
call HGT_lower_alpha_OLR(G2H8(134),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(134),2,5,8)
call HGT_lower_alpha_OLR(G2H8(134),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(134),[G2H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(57)])
call HGT_w2_OLR(G1H8(3),1,1,8)
call HGT_w2_invQ_OLR(G1H8(3),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(139),[G1H8(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(107),[G1H8(51)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(143),[G1H8(430)])
call HGT_lower_alpha_OLR(G2H8(147),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(147),2,5,8)
call HGT_lower_alpha_OLR(G2H8(147),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(147),[G2H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(148),[G1H8(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(75)])
call HGT_w2_OLR(G1H8(5),1,1,8)
call HGT_w2_invQ_OLR(G1H8(5),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(152),[G1H8(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(69)])
call HGT_w2_OLR(G1H8(6),1,1,8)
call HGT_w2_invQ_OLR(G1H8(6),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(156),[G1H8(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(113),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(124),G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(67),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(121),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(140),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(178),G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(99),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(127),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(93),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(109),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(118),[G1H8(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(137),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(103),[G1H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(131),[G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(89),[G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(101),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(113),[G1H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G1H8(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(400),[G1H8(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(406),[G1H8(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G1H8(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(274),[G1H8(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(280),[G1H8(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G1H8(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G1H8(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G1H8(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G1H8(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G1H8(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(65),[G1H8(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G1H8(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G1H8(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G1H8(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(73),[G1H8(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(74),[G1H8(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G1H8(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(78),[G1H8(483)])
call HGT_OLR(G2H8(36),1,1,8)
call HGT_invQ_OLR(G2H8(36),2,5,8)
call HGT_OLR(G2H8(36),6,15,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(80),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(137),G1H8(138),G1H8(139),G1H8(140),8)
  call HG1shiftOLR(G1H8(134),2,8)
  call Hloop_AQ_V(ntryL,G2H8(42),ex1(:),G2H4(151),m3h2x4(:,327),heltab2x8(:,:,327))
call HGT_OLR(G2H8(41),1,1,8)
call HGT_invQ_OLR(G2H8(41),2,5,8)
call HGT_OLR(G2H8(41),6,15,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(81),mass5set(:,1),  & 
G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(144),2,8)
call HGT_OLR(G2H8(46),1,1,8)
call HGT_invQ_OLR(G2H8(46),2,5,8)
call HGT_OLR(G2H8(46),6,15,8)
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(82),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(155),G1H8(156),G1H8(157),G1H8(158),8)
  call HG1shiftOLR(G1H8(152),1,8)
  call Hloop_QA_V(ntryL,G2H8(47),ex2(:),G2H4(154),m3h2x4(:,328),heltab2x8(:,:,328))
call HGT_OLR(G2H8(51),1,1,8)
call HGT_invQ_OLR(G2H8(51),2,5,8)
call HGT_OLR(G2H8(51),6,15,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(83),mass5set(:,1),  & 
G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(162),1,8)
  call Hloop_QA_V(ntryL,G2H8(57),ex2(:),G2H4(155),m3h2x4(:,329),heltab2x8(:,:,329))
call HGT_OLR(G2H8(56),1,1,8)
call HGT_invQ_OLR(G2H8(56),2,5,8)
call HGT_OLR(G2H8(56),6,15,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(84),mass5set(:,1),  & 
G1H8(169),G1H8(170),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
  call HG1shiftOLR(G1H8(170),1,8)
call HGT_OLR(G2H8(61),1,1,8)
call HGT_invQ_OLR(G2H8(61),2,5,8)
call HGT_OLR(G2H8(61),6,15,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(85),mass5set(:,1),  & 
G1H8(179),G1H8(180),G1H8(181),G1H8(182),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(180),2,8)
  call Hloop_AQ_V(ntryL,G2H8(62),ex1(:),G2H4(158),m3h2x4(:,330),heltab2x8(:,:,330))
call HGT_lower_alpha_OLR(G2H8(66),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(66),2,5,8)
call HGT_lower_alpha_OLR(G2H8(66),6,15,8)
  call Hotf_5pt_reduction(G2H8(66),RedSet_5(86),mass5set(:,1),  & 
G1H8(187),G1H8(188),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
  call HG1shiftOLR(G1H8(188),2,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(87),mass5set(:,1),  & 
G1H8(197),G1H8(198),G1H8(199),G1H8(200),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(198),16,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(88),mass5set(:,1),  & 
G1H8(205),G1H8(206),G1H8(209),G1H8(210),G1H8(211),G1H8(212),8)
  call HG1shiftOLR(G1H8(206),8,8)
  call Hloop_AQ_V(ntryL,G2H8(154),ex1(:),G2H4(159),m3h2x4(:,331),heltab2x8(:,:,331))
call HGT_lower_alpha_OLR(G2H8(76),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(76),2,5,8)
call HGT_lower_alpha_OLR(G2H8(76),6,15,8)
  call Hotf_5pt_reduction(G2H8(76),RedSet_5(89),mass5set(:,1),  & 
G1H8(217),G1H8(223),G1H8(218),G1H8(221),G1H8(222),G1H8(224),8)
  call HG1shiftOLR(G1H8(223),1,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(90),mass5set(:,1),  & 
G1H8(227),G1H8(228),G1H8(229),G1H8(230),G1H8(235),G1H8(241),8)
  call HG1shiftOLR(G1H8(228),8,8)
call HGT_lower_alpha_OLR(G2H8(81),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(81),2,5,8)
call HGT_lower_alpha_OLR(G2H8(81),6,15,8)
  call Hotf_5pt_reduction(G2H8(81),RedSet_5(91),mass5set(:,1),  & 
G1H8(236),G1H8(239),G1H8(240),G1H8(242),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(239),1,8)
  call Hotf_5pt_reduction(G2H8(158),RedSet_5(92),mass5set(:,1),  & 
G1H8(247),G1H8(248),G1H8(253),G1H8(259),G1H8(254),G1H8(257),8)
  call HG1shiftOLR(G1H8(248),16,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(93),mass5set(:,1),  & 
G1H8(258),G1H8(260),G1H8(263),G1H8(264),G1H8(265),G1H8(266),8)
  call HG1shiftOLR(G1H8(260),16,8)
  call Hloop_AQ_V(ntryL,G2H8(155),ex1(:),G2H4(162),m3h2x4(:,332),heltab2x8(:,:,332))
call HGT_lower_alpha_OLR(G2H8(91),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(91),2,5,8)
call HGT_lower_alpha_OLR(G2H8(91),6,15,8)
  call Hotf_5pt_reduction(G2H8(91),RedSet_5(94),mass5set(:,1),  & 
G1H8(271),G1H8(277),G1H8(272),G1H8(275),G1H8(276),G1H8(278),8)
  call HG1shiftOLR(G1H8(277),1,8)
  call Hotf_5pt_reduction(G2H8(96),RedSet_5(95),mass5set(:,1),  & 
G1H8(281),G1H8(282),G1H8(283),G1H8(284),G1H8(289),G1H8(295),8)
  call HG1shiftOLR(G1H8(282),8,8)
  call Hloop_QA_V(ntryL,G2H8(149),ex2(:),G2H4(163),m3h2x4(:,333),heltab2x8(:,:,333))
  call Hotf_5pt_reduction(G2H8(101),RedSet_5(96),mass5set(:,1),  & 
G1H8(290),G1H8(293),G1H8(294),G1H8(296),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(293),16,8)
  call Hloop_QA_V(ntryL,G2H8(150),ex2(:),G2H4(166),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hotf_5pt_reduction(G2H8(106),RedSet_5(97),mass5set(:,1),  & 
G1H8(301),G1H8(302),G1H8(307),G1H8(313),G1H8(308),G1H8(311),8)
  call HG1shiftOLR(G1H8(302),2,8)
  call Hotf_5pt_reduction(G2H8(146),RedSet_5(98),mass5set(:,1),  & 
G1H8(312),G1H8(314),G1H8(317),G1H8(318),G1H8(319),G1H8(320),8)
  call HG1shiftOLR(G1H8(314),16,8)
  call Hotf_5pt_reduction(G2H8(111),RedSet_5(99),mass5set(:,1),  & 
G1H8(325),G1H8(331),G1H8(326),G1H8(329),G1H8(330),G1H8(332),8)
  call HG1shiftOLR(G1H8(331),2,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(100),mass5set(:,1),  & 
G1H8(335),G1H8(336),G1H8(337),G1H8(338),G1H8(343),G1H8(349),8)
  call HG1shiftOLR(G1H8(336),8,8)
  call Hloop_QV_A(ntryL,G1H8(1),ex3(:),G1H4(24),m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(24),39,0,G2H4(167),n2h4(297))
  call Hotf_5pt_reduction(G2H8(116),RedSet_5(101),mass5set(:,1),  & 
G1H8(344),G1H8(347),G1H8(348),G1H8(350),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(347),2,8)
  call Hloop_QV_A(ntryL,G1H8(2),ex3(:),G1H4(36),m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(36),39,0,G2H4(170),n2h4(298))
  call Hotf_5pt_reduction(G2H8(120),RedSet_5(102),mass5set(:,1),  & 
G1H8(355),G1H8(356),G1H8(361),G1H8(367),G1H8(362),G1H8(365),8)
  call HG1shiftOLR(G1H8(356),2,8)
call HGT_lower_alpha_OLR(G2H8(124),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(124),2,5,8)
call HGT_lower_alpha_OLR(G2H8(124),6,15,8)
  call Hotf_5pt_reduction(G2H8(124),RedSet_5(103),mass5set(:,1),  & 
G1H8(366),G1H8(368),G1H8(371),G1H8(372),G1H8(373),G1H8(374),8)
  call HG1shiftOLR(G1H8(368),1,8)
  call Hotf_5pt_reduction(G2H8(153),RedSet_5(104),mass5set(:,1),  & 
G1H8(379),G1H8(385),G1H8(380),G1H8(383),G1H8(384),G1H8(386),8)
  call HG1shiftOLR(G1H8(385),16,8)
call HGT_lower_alpha_OLR(G2H8(129),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(129),2,5,8)
call HGT_lower_alpha_OLR(G2H8(129),6,15,8)
  call Hotf_5pt_reduction(G2H8(129),RedSet_5(105),mass5set(:,1),  & 
G1H8(389),G1H8(390),G1H8(391),G1H8(392),G1H8(397),G1H8(403),8)
  call HG1shiftOLR(G1H8(390),1,8)
  call Hotf_5pt_reduction(G2H8(151),RedSet_5(106),mass5set(:,1),  & 
G1H8(398),G1H8(401),G1H8(402),G1H8(404),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(401),8,8)
  call Hotf_5pt_reduction(G2H8(134),RedSet_5(107),mass5set(:,1),  & 
G1H8(409),G1H8(410),G1H8(415),G1H8(421),G1H8(416),G1H8(419),8)
  call HG1shiftOLR(G1H8(410),2,8)
  call Hloop_QV_A(ntryL,G1H8(3),ex4(:),G1H4(48),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G1H4(48),43,0,G2H4(176),n2h4(299))
  call Hotf_5pt_reduction(G2H8(139),RedSet_5(108),mass5set(:,1),  & 
G1H8(420),G1H8(422),G1H8(425),G1H8(426),G1H8(427),G1H8(428),8)
  call HG1shiftOLR(G1H8(422),2,8)
  call Hloop_QV_A(ntryL,G1H8(4),ex4(:),G1H4(60),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_Q_A(ntryL,G1H4(60),43,0,G2H4(177),n2h4(300))
  call Hotf_5pt_reduction(G2H8(143),RedSet_5(109),mass5set(:,1),  & 
G1H8(433),G1H8(439),G1H8(434),G1H8(437),G1H8(438),G1H8(440),8)
  call HG1shiftOLR(G1H8(439),2,8)
  call Hotf_5pt_reduction(G2H8(147),RedSet_5(110),mass5set(:,1),  & 
G1H8(443),G1H8(444),G1H8(445),G1H8(446),G1H8(451),G1H8(457),8)
  call HG1shiftOLR(G1H8(444),2,8)
  call Hotf_5pt_reduction(G2H8(148),RedSet_5(111),mass5set(:,1),  & 
G1H8(452),G1H8(455),G1H8(456),G1H8(458),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(455),8,8)
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(72),m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G1H4(72),51,0,G2H4(180),n2h4(301))
  call Hotf_5pt_reduction(G2H8(152),RedSet_5(112),mass5set(:,1),  & 
G1H8(463),G1H8(464),G1H8(469),G1H8(475),G1H8(470),G1H8(473),8)
  call HG1shiftOLR(G1H8(464),2,8)
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(84),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G1H4(84),51,0,G2H4(186),n2h4(302))
  call Hotf_5pt_reduction(G2H8(156),RedSet_5(113),mass5set(:,1),  & 
G1H8(474),G1H8(476),G1H8(479),G1H8(480),G1H8(481),G1H8(482),8)
  call HG1shiftOLR(G1H8(476),2,8)
  call Hloop_VQ_A(ntryL,G1H8(113),ex1(:),G1H4(96),m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G1H4(96),43,0,G2H4(187),n2h4(303))
  call Hloop_VQ_A(ntryL,G1H8(90),ex1(:),G1H4(108),m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_Q_A(ntryL,G1H4(108),43,0,G2H4(190),n2h4(304))
  call Hloop_VA_Q(ntryL,G1H8(15),ex2(:),G1H4(120),m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_A_Q(ntryL,G1H4(120),39,0,G2H4(196),n2h4(305))
  call Hloop_VA_Q(ntryL,G1H8(67),ex2(:),G1H4(132),m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_A_Q(ntryL,G1H4(132),39,0,G2H4(197),n2h4(306))
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(144),m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_A_Q(ntryL,G1H4(144),39,0,G2H4(200),n2h4(307))
  call Hloop_VA_Q(ntryL,G1H8(71),ex2(:),G1H4(156),m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_A_Q(ntryL,G1H4(156),39,0,G2H4(206),n2h4(308))
  call Hotf_5pt_reduction(G2H8(121),RedSet_5(114),mass5set(:,1),  & 
G1H8(487),G1H8(493),G1H8(488),G1H8(491),G1H8(492),G1H8(494),8)
  call HG1shiftOLR(G1H8(493),16,8)
  call Hotf_5pt_reduction(G2H8(140),RedSet_5(115),mass5set(:,1),  & 
G1H8(497),G1H8(498),G1H8(215),G1H8(216),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(498),8,8)
  call Hloop_VA_Q(ntryL,G1H8(115),ex2(:),G1H4(168),m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_A_Q(ntryL,G1H4(168),43,0,G2H4(207),n2h4(309))
  call Hloop_VA_Q(ntryL,G1H8(86),ex2(:),G1H4(180),m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_A_Q(ntryL,G1H4(180),43,0,G2H4(210),n2h4(310))
  call Hloop_VQ_A(ntryL,G1H8(45),ex1(:),G1H4(192),m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G1H4(192),39,0,G2H4(216),n2h4(311))
  call Hloop_VQ_A(ntryL,G1H8(79),ex1(:),G1H4(204),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_Q_A(ntryL,G1H4(204),39,0,G2H4(217),n2h4(312))
  call Hotf_5pt_reduction(G2H8(99),RedSet_5(116),mass5set(:,1),  & 
G1H8(251),G1H8(252),G1H8(269),G1H8(270),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(252),16,8)
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(117),mass5set(:,1),  & 
G1H8(305),G1H8(306),G1H8(323),G1H8(324),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(306),4,8)
  call Hloop_VQ_A(ntryL,G1H8(63),ex1(:),G1H4(216),m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G1H4(216),39,0,G2H4(220),n2h4(313))
  call Hloop_VQ_A(ntryL,G1H8(83),ex1(:),G1H4(228),m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_Q_A(ntryL,G1H4(228),39,0,G2H4(226),n2h4(314))
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(118),mass5set(:,1),  & 
G1H8(359),G1H8(360),G1H8(377),G1H8(378),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(360),8,8)
  call Hotf_5pt_reduction(G2H8(109),RedSet_5(119),mass5set(:,1),  & 
G1H8(413),G1H8(414),G1H8(431),G1H8(432),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(414),4,8)
  call Hloop_AV_Q(ntryL,G1H8(92),ex3(:),G1H4(240),m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_A_Q(ntryL,G1H4(240),39,0,G2H4(227),n2h4(315))
  call Hotf_5pt_reduction(G2H8(118),RedSet_5(114),mass5set(:,1),  & 
G1H8(467),G1H8(468),G1H8(485),G1H8(486),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(468),16,8)
  call Hloop_AV_Q(ntryL,G1H8(95),ex3(:),G1H4(252),m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_A_Q(ntryL,G1H4(252),39,0,G2H4(229),n2h4(316))
  call Hotf_5pt_reduction(G2H8(137),RedSet_5(115),mass5set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(264),m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_A_Q(ntryL,G1H4(264),43,0,G2H4(233),n2h4(317))
  call Hotf_5pt_reduction(G2H8(103),RedSet_5(116),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hloop_AV_Q(ntryL,G1H8(97),ex4(:),G1H4(276),m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_A_Q(ntryL,G1H4(276),43,0,G2H4(234),n2h4(318))
  call Hotf_5pt_reduction(G2H8(131),RedSet_5(117),mass5set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(30),4,8)
  call Hloop_AV_Q(ntryL,G1H8(98),ex5(:),G1H4(288),m3h2x4(:,357),heltab2x8(:,:,357))
  call Hloop_A_Q(ntryL,G1H4(288),51,0,G2H4(236),n2h4(319))
  call Hotf_5pt_reduction(G2H8(89),RedSet_5(118),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_AV_Q(ntryL,G1H8(101),ex5(:),G1H4(300),m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_A_Q(ntryL,G1H4(300),51,0,G2H4(240),n2h4(320))
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(119),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(48),4,8)
  call Hloop_UV_W(ntryL,G1H8(117),37,ex4(:),8,G2H4(241),m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_UV_W(ntryL,G1H8(65),37,ex4(:),8,G2H4(244),m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_VQ_A(ntryL,G1H8(102),ex1(:),G1H4(312),m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(312),43,0,G2H4(250),n2h4(321))
  call Hloop_UV_W(ntryL,G1H8(129),50,ex4(:),8,G2H4(251),m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_UV_W(ntryL,G1H8(130),50,ex4(:),8,G2H4(254),m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_UV_W(ntryL,G1H8(135),37,ex5(:),16,G2H4(260),m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_UV_W(ntryL,G1H8(61),37,ex5(:),16,G2H4(261),m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_UV_W(ntryL,G1H8(141),42,ex5(:),16,G2H4(264),m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_UV_W(ntryL,G1H8(142),42,ex5(:),16,G2H4(270),m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_VQ_A(ntryL,G1H8(147),ex1(:),G1H4(324),m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_Q_A(ntryL,G1H4(324),51,0,G2H4(271),n2h4(322))
  call Hloop_VQ_A(ntryL,G1H8(148),ex1(:),G1H4(336),m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H4(336),51,0,G2H4(273),n2h4(323))
  call Hloop_UV_W(ntryL,G1H8(153),38,ex4(:),8,G2H4(277),m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_UV_W(ntryL,G1H8(77),38,ex4(:),8,G2H4(278),m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_UV_W(ntryL,G1H8(159),38,ex5(:),16,G2H4(280),m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_UV_W(ntryL,G1H8(73),38,ex5(:),16,G2H4(284),m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_VQ_A(ntryL,G1H8(165),ex1(:),G1H4(348),m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_Q_A(ntryL,G1H4(348),43,0,G2H4(285),n2h4(324))
  call Hloop_VQ_A(ntryL,G1H8(166),ex1(:),G1H4(360),m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(360),43,0,G2H4(288),n2h4(325))
  call Hloop_VQ_A(ntryL,G1H8(171),ex1(:),G1H4(372),m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(372),51,0,G2H4(294),n2h4(326))
  call Hloop_VQ_A(ntryL,G1H8(172),ex1(:),G1H4(384),m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_Q_A(ntryL,G1H4(384),51,0,G2H4(295),n2h4(327))
  call Hloop_VA_Q(ntryL,G1H8(91),ex2(:),G1H4(396),m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_A_Q(ntryL,G1H4(396),43,0,G2H4(297),n2h4(328))
  call Hloop_UV_W(ntryL,G1H8(183),41,ex5(:),16,G2H4(301),m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_UV_W(ntryL,G1H8(184),41,ex5(:),16,G2H4(302),m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_VA_Q(ntryL,G1H8(189),ex2(:),G1H4(408),m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(408),43,0,G2H4(304),n2h4(329))
  call Hloop_VA_Q(ntryL,G1H8(190),ex2(:),G1H4(420),m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_A_Q(ntryL,G1H4(420),43,0,G2H4(308),n2h4(330))
  call Hloop_UV_W(ntryL,G1H8(195),49,ex4(:),8,G2H4(1),m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_UV_W(ntryL,G1H8(196),49,ex4(:),8,G2H4(3),m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_VA_Q(ntryL,G1H8(201),ex2(:),G1H4(432),m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_A_Q(ntryL,G1H4(432),51,0,G2H4(4),n2h4(331))
  call Hloop_VA_Q(ntryL,G1H8(202),ex2(:),G1H4(444),m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_A_Q(ntryL,G1H4(444),51,0,G2H4(6),n2h4(332))
  call Hloop_VA_Q(ntryL,G1H8(207),ex2(:),G1H4(456),m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_A_Q(ntryL,G1H4(456),51,0,G2H4(7),n2h4(333))
  call Hloop_VA_Q(ntryL,G1H8(208),ex2(:),G1H4(468),m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_A_Q(ntryL,G1H4(468),51,0,G2H4(9),n2h4(334))
  call Hloop_QV_A(ntryL,G1H8(219),ex3(:),G1H4(480),m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(480),45,0,G2H4(10),n2h4(335))
  call Hloop_QV_A(ntryL,G1H8(400),ex3(:),G1H4(492),m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_Q_A(ntryL,G1H4(492),45,0,G2H4(12),n2h4(336))
  call Hloop_QV_A(ntryL,G1H8(225),ex3(:),G1H4(504),m3h2x4(:,391),heltab2x8(:,:,391))
  call Hloop_Q_A(ntryL,G1H4(504),45,0,G2H4(13),n2h4(337))
  call Hloop_QV_A(ntryL,G1H8(406),ex3(:),G1H4(516),m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_Q_A(ntryL,G1H4(516),45,0,G2H4(15),n2h4(338))
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(120),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(59),G1H8(60),G1H8(62),G1H8(66),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hloop_AV_Q(ntryL,G1H8(237),ex3(:),G1H4(528),m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_A_Q(ntryL,G1H4(528),54,0,G2H4(16),n2h4(339))
  call Hloop_AV_Q(ntryL,G1H8(238),ex3(:),G1H4(540),m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_A_Q(ntryL,G1H4(540),54,0,G2H4(18),n2h4(340))
  call Hloop_AV_Q(ntryL,G1H8(243),ex3(:),G1H4(552),m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_A_Q(ntryL,G1H4(552),54,0,G2H4(19),n2h4(341))
  call Hloop_AV_Q(ntryL,G1H8(244),ex3(:),G1H4(558),m3h2x4(:,396),heltab2x8(:,:,396))
  call Hloop_A_Q(ntryL,G1H4(558),54,0,G2H4(21),n2h4(342))
  call Hloop_AV_Q(ntryL,G1H8(255),ex3(:),G1H4(569),m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_A_Q(ntryL,G1H4(569),46,0,G2H4(22),n2h4(343))
  call Hloop_AV_Q(ntryL,G1H8(274),ex3(:),G1H4(575),m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_A_Q(ntryL,G1H4(575),46,0,G2H4(24),n2h4(344))
  call Hloop_AV_Q(ntryL,G1H8(261),ex3(:),G1H4(586),m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_A_Q(ntryL,G1H4(586),46,0,G2H4(25),n2h4(345))
  call Hloop_AV_Q(ntryL,G1H8(280),ex3(:),G1H4(592),m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_A_Q(ntryL,G1H4(592),46,0,G2H4(27),n2h4(346))
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(121),mass5set(:,1),  & 
G1H8(68),G1H8(72),G1H8(74),G1H8(78),G1H8(80),G1H8(84),8)
  call HG1shiftOLR(G1H8(72),16,8)
  call Hloop_AV_Q(ntryL,G1H8(273),ex3(:),G1H4(603),m3h2x4(:,401),heltab2x8(:,:,401))
  call Hloop_A_Q(ntryL,G1H4(603),46,0,G2H4(28),n2h4(347))
  call Hloop_AV_Q(ntryL,G1H8(279),ex3(:),G1H4(609),m3h2x4(:,402),heltab2x8(:,:,402))
  call Hloop_A_Q(ntryL,G1H4(609),46,0,G2H4(30),n2h4(348))
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(122),mass5set(:,1),  & 
G1H8(85),G1H8(89),G1H8(121),G1H8(125),G1H8(394),G1H8(214),8)
  call HG1shiftOLR(G1H8(89),16,8)
  call Hloop_QV_A(ntryL,G1H8(291),ex4(:),G1H4(620),m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G1H4(620),45,0,G2H4(31),n2h4(349))
  call Hloop_QV_A(ntryL,G1H8(292),ex4(:),G1H4(626),m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_Q_A(ntryL,G1H4(626),45,0,G2H4(34),n2h4(350))
  call Hloop_QV_A(ntryL,G1H8(297),ex4(:),G1H4(637),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_Q_A(ntryL,G1H4(637),45,0,G2H4(35),n2h4(351))
  call Hloop_QV_A(ntryL,G1H8(298),ex4(:),G1H4(643),m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_Q_A(ntryL,G1H4(643),45,0,G2H4(38),n2h4(352))
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(123),mass5set(:,1),  & 
G1H8(232),G1H8(268),G1H8(250),G1H8(249),G1H8(213),G1H8(286),8)
  call HG1shiftOLR(G1H8(268),8,8)
  call Hloop_QV_A(ntryL,G1H8(309),ex5(:),G1H4(19),m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_Q_A(ntryL,G1H4(19),53,0,G2H4(39),n2h4(353))
  call Hloop_QV_A(ntryL,G1H8(310),ex5(:),G1H4(20),m3h2x4(:,408),heltab2x8(:,:,408))
  call Hloop_Q_A(ntryL,G1H4(20),53,0,G2H4(42),n2h4(354))
  call Hloop_QV_A(ntryL,G1H8(315),ex5(:),G1H4(25),m3h2x4(:,409),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G1H4(25),53,0,G2H4(43),n2h4(355))
  call Hloop_QV_A(ntryL,G1H8(316),ex5(:),G1H4(26),m3h2x4(:,410),heltab2x8(:,:,410))
  call Hloop_Q_A(ntryL,G1H4(26),53,0,G2H4(46),n2h4(356))
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(124),mass5set(:,1),  & 
G1H8(304),G1H8(33),G1H8(104),G1H8(322),G1H8(27),G1H8(103),8)
  call HG1shiftOLR(G1H8(33),2,8)
  call Hloop_QV_A(ntryL,G1H8(327),ex5(:),G1H4(30),m3h2x4(:,411),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G1H4(30),53,0,G2H4(47),n2h4(357))
  call Hloop_QV_A(ntryL,G1H8(328),ex5(:),G1H4(31),m3h2x4(:,412),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(50),n2h4(358))
  call Hloop_QV_A(ntryL,G1H8(333),ex5(:),G1H4(32),m3h2x4(:,413),heltab2x8(:,:,413))
  call Hloop_Q_A(ntryL,G1H4(32),53,0,G2H4(51),n2h4(359))
  call Hloop_QV_A(ntryL,G1H8(334),ex5(:),G1H4(37),m3h2x4(:,414),heltab2x8(:,:,414))
  call Hloop_Q_A(ntryL,G1H4(37),53,0,G2H4(54),n2h4(360))
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(125),mass5set(:,1),  & 
G1H8(340),G1H8(358),G1H8(376),G1H8(57),G1H8(108),G1H8(412),8)
  call HG1shiftOLR(G1H8(358),2,8)
  call Hloop_QV_A(ntryL,G1H8(345),ex4(:),G1H4(38),m3h2x4(:,415),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H4(38),45,0,G2H4(55),n2h4(361))
  call Hloop_QV_A(ntryL,G1H8(346),ex4(:),G1H4(42),m3h2x4(:,416),heltab2x8(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(42),45,0,G2H4(58),n2h4(362))
  call Hloop_QV_A(ntryL,G1H8(351),ex4(:),G1H4(43),m3h2x4(:,417),heltab2x8(:,:,417))
  call Hloop_Q_A(ntryL,G1H4(43),45,0,G2H4(59),n2h4(363))
  call Hloop_QV_A(ntryL,G1H8(352),ex4(:),G1H4(44),m3h2x4(:,418),heltab2x8(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(44),45,0,G2H4(62),n2h4(364))
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(126),mass5set(:,1),  & 
G1H8(51),G1H8(107),G1H8(430),G1H8(448),G1H8(75),G1H8(110),8)
  call HG1shiftOLR(G1H8(107),16,8)
  call Hloop_AV_Q(ntryL,G1H8(363),ex4(:),G1H4(49),m3h2x4(:,419),heltab2x8(:,:,419))
  call Hloop_A_Q(ntryL,G1H4(49),46,0,G2H4(63),n2h4(365))
  call Hloop_AV_Q(ntryL,G1H8(364),ex4(:),G1H4(50),m3h2x4(:,420),heltab2x8(:,:,420))
  call Hloop_A_Q(ntryL,G1H4(50),46,0,G2H4(66),n2h4(366))
  call Hloop_AV_Q(ntryL,G1H8(369),ex4(:),G1H4(54),m3h2x4(:,421),heltab2x8(:,:,421))
  call Hloop_A_Q(ntryL,G1H4(54),46,0,G2H4(67),n2h4(367))
  call Hloop_AV_Q(ntryL,G1H8(370),ex4(:),G1H4(55),m3h2x4(:,422),heltab2x8(:,:,422))
  call Hloop_A_Q(ntryL,G1H4(55),46,0,G2H4(70),n2h4(368))
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(127),mass5set(:,1),  & 
G1H8(466),G1H8(69),G1H8(109),G1H8(484),G1H8(9),G1H8(124),8)
  call HG1shiftOLR(G1H8(69),8,8)
  call Hloop_AV_Q(ntryL,G1H8(381),ex5(:),G1H4(56),m3h2x4(:,423),heltab2x8(:,:,423))
  call Hloop_A_Q(ntryL,G1H4(56),54,0,G2H4(71),n2h4(369))
  call Hloop_AV_Q(ntryL,G1H8(382),ex5(:),G1H4(61),m3h2x4(:,424),heltab2x8(:,:,424))
  call Hloop_A_Q(ntryL,G1H4(61),54,0,G2H4(74),n2h4(370))
  call Hloop_AV_Q(ntryL,G1H8(387),ex5(:),G1H4(62),m3h2x4(:,425),heltab2x8(:,:,425))
  call Hloop_A_Q(ntryL,G1H4(62),54,0,G2H4(75),n2h4(371))
  call Hloop_AV_Q(ntryL,G1H8(388),ex5(:),G1H4(66),m3h2x4(:,426),heltab2x8(:,:,426))
  call Hloop_A_Q(ntryL,G1H4(66),54,0,G2H4(78),n2h4(372))
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(128),mass5set(:,1),  & 
G1H8(10),G1H8(16),G1H8(22),G1H8(28),G1H8(34),G1H8(39),8)
  call HG1shiftOLR(G1H8(16),16,8)
  call Hloop_QV_A(ntryL,G1H8(399),ex3(:),G1H4(67),m3h2x4(:,427),heltab2x8(:,:,427))
  call Hloop_Q_A(ntryL,G1H4(67),45,0,G2H4(79),n2h4(373))
  call Hloop_QV_A(ntryL,G1H8(405),ex3(:),G1H4(68),m3h2x4(:,428),heltab2x8(:,:,428))
  call Hloop_Q_A(ntryL,G1H4(68),45,0,G2H4(82),n2h4(374))
  call Hotf_5pt_reduction(G2H8(70),RedSet_5(129),mass5set(:,1),  & 
G1H8(178),G1H8(40),G1H8(46),G1H8(52),G1H8(58),G1H8(64),8)
  call HG1shiftOLR(G1H8(40),2,8)
  call Hloop_QV_A(ntryL,G1H8(417),ex5(:),G1H4(73),m3h2x4(:,429),heltab2x8(:,:,429))
  call Hloop_Q_A(ntryL,G1H4(73),57,0,G2H4(83),n2h4(375))
  call Hloop_QV_A(ntryL,G1H8(418),ex5(:),G1H4(74),m3h2x4(:,430),heltab2x8(:,:,430))
  call Hloop_Q_A(ntryL,G1H4(74),57,0,G2H4(86),n2h4(376))
  call Hloop_QV_A(ntryL,G1H8(423),ex5(:),G1H4(78),m3h2x4(:,431),heltab2x8(:,:,431))
  call Hloop_Q_A(ntryL,G1H4(78),57,0,G2H4(87),n2h4(377))
  call Hloop_QV_A(ntryL,G1H8(424),ex5(:),G1H4(79),m3h2x4(:,432),heltab2x8(:,:,432))
  call Hloop_Q_A(ntryL,G1H4(79),57,0,G2H4(90),n2h4(378))
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(130),mass5set(:,1),  & 
G1H8(70),G1H8(76),G1H8(81),G1H8(82),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(76),2,8)
  call Hloop_QV_A(ntryL,G1H8(435),ex3(:),G1H4(80),m3h2x4(:,433),heltab2x8(:,:,433))
  call Hloop_Q_A(ntryL,G1H4(80),45,0,G2H4(91),n2h4(379))
  call Hloop_QV_A(ntryL,G1H8(436),ex3(:),G1H4(85),m3h2x4(:,434),heltab2x8(:,:,434))
  call Hloop_Q_A(ntryL,G1H4(85),45,0,G2H4(94),n2h4(380))
  call Hloop_QV_A(ntryL,G1H8(441),ex3(:),G1H4(86),m3h2x4(:,435),heltab2x8(:,:,435))
  call Hloop_Q_A(ntryL,G1H4(86),45,0,G2H4(95),n2h4(381))
  call Hloop_QV_A(ntryL,G1H8(442),ex3(:),G1H4(90),m3h2x4(:,436),heltab2x8(:,:,436))
  call Hloop_Q_A(ntryL,G1H4(90),45,0,G2H4(98),n2h4(382))
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(131),mass5set(:,1),  & 
G1H8(93),G1H8(94),G1H8(99),G1H8(100),G1H8(105),G1H8(106),8)
  call HG1shiftOLR(G1H8(94),8,8)
  call Hloop_QV_A(ntryL,G1H8(453),ex3(:),G1H4(91),m3h2x4(:,437),heltab2x8(:,:,437))
  call Hloop_Q_A(ntryL,G1H4(91),53,0,G2H4(99),n2h4(383))
  call Hloop_QV_A(ntryL,G1H8(454),ex3(:),G1H4(92),m3h2x4(:,438),heltab2x8(:,:,438))
  call Hloop_Q_A(ntryL,G1H4(92),53,0,G2H4(102),n2h4(384))
  call Hloop_QV_A(ntryL,G1H8(459),ex3(:),G1H4(97),m3h2x4(:,439),heltab2x8(:,:,439))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(103),n2h4(385))
  call Hloop_QV_A(ntryL,G1H8(460),ex3(:),G1H4(98),m3h2x4(:,440),heltab2x8(:,:,440))
  call Hloop_Q_A(ntryL,G1H4(98),53,0,G2H4(106),n2h4(386))
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(132),mass5set(:,1),  & 
G1H8(111),G1H8(112),G1H8(118),G1H8(123),G1H8(136),G1H8(154),8)
  call HG1shiftOLR(G1H8(112),2,8)
  call Hloop_QV_A(ntryL,G1H8(471),ex4(:),G1H4(102),m3h2x4(:,441),heltab2x8(:,:,441))
  call Hloop_Q_A(ntryL,G1H4(102),57,0,G2H4(107),n2h4(387))
  call Hloop_QV_A(ntryL,G1H8(472),ex4(:),G1H4(103),m3h2x4(:,442),heltab2x8(:,:,442))
  call Hloop_Q_A(ntryL,G1H4(103),57,0,G2H4(110),n2h4(388))
  call Hloop_QV_A(ntryL,G1H8(477),ex4(:),G1H4(104),m3h2x4(:,443),heltab2x8(:,:,443))
  call Hloop_Q_A(ntryL,G1H4(104),57,0,G2H4(111),n2h4(389))
  call Hloop_QV_A(ntryL,G1H8(478),ex4(:),G1H4(109),m3h2x4(:,444),heltab2x8(:,:,444))
  call Hloop_Q_A(ntryL,G1H4(109),57,0,G2H4(114),n2h4(390))
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(133),mass5set(:,1),  & 
G1H8(160),G1H8(177),G1H8(220),G1H8(226),G1H8(231),G1H8(256),8)
  call HG1shiftOLR(G1H8(177),2,8)
  call Hloop_QV_A(ntryL,G1H8(489),ex3(:),G1H4(110),m3h2x4(:,445),heltab2x8(:,:,445))
  call Hloop_Q_A(ntryL,G1H4(110),53,0,G2H4(115),n2h4(391))
  call Hloop_QV_A(ntryL,G1H8(490),ex3(:),G1H4(114),m3h2x4(:,446),heltab2x8(:,:,446))
  call Hloop_Q_A(ntryL,G1H4(114),53,0,G2H4(118),n2h4(392))
  call Hloop_QV_A(ntryL,G1H8(495),ex3(:),G1H4(115),m3h2x4(:,447),heltab2x8(:,:,447))
  call Hloop_Q_A(ntryL,G1H4(115),53,0,G2H4(119),n2h4(393))
  call Hloop_QV_A(ntryL,G1H8(496),ex3(:),G1H4(116),m3h2x4(:,448),heltab2x8(:,:,448))
  call Hloop_Q_A(ntryL,G1H4(116),53,0,G2H4(122),n2h4(394))
  call Hloop_AQ_V(ntryL,G2H8(35),ex1(:),G2H4(123),m3h2x4(:,449),heltab2x8(:,:,449))
  call Hloop_AQ_V(ntryL,G2H8(38),ex1(:),G2H4(126),m3h2x4(:,450),heltab2x8(:,:,450))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(127),m3h2x4(:,451),heltab2x8(:,:,451))
  call Hloop_QA_V(ntryL,G2H8(40),ex2(:),G2H4(130),m3h2x4(:,452),heltab2x8(:,:,452))
  call Hloop_QA_V(ntryL,G2H8(43),ex2(:),G2H4(131),m3h2x4(:,453),heltab2x8(:,:,453))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(134),m3h2x4(:,454),heltab2x8(:,:,454))
  call Hloop_AQ_V(ntryL,G2H8(48),ex1(:),G2H4(135),m3h2x4(:,455),heltab2x8(:,:,455))
  call Hloop_AQ_V(ntryL,G2H8(53),ex1(:),G2H4(138),m3h2x4(:,456),heltab2x8(:,:,456))
  call Hloop_QA_V(ntryL,G2H8(55),ex2(:),G2H4(139),m3h2x4(:,457),heltab2x8(:,:,457))
  call Hloop_QA_V(ntryL,G2H8(58),ex2(:),G2H4(142),m3h2x4(:,458),heltab2x8(:,:,458))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(12),mass5set(:,1),  & 
G1H16(26),G1H16(133),G1H16(138),G1H16(144),G1H16(148),G1H16(153),16)
  call HG1shiftOLR(G1H16(133),24,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(12),mass5set(:,1),  & 
G1H16(55),G1H16(5),G1H16(6),G1H16(9),G1H16(44),G1H16(46),16)
  call HG1shiftOLR(G1H16(5),24,16)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(12),mass5set(:,1),  & 
G1H16(10),G1H16(11),G1H16(12),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(11),24,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(8),mass5set(:,1),  & 
G1H16(66),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),24,16)
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(8),mass5set(:,1),  & 
G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),G1H16(80),16)
  call HG1shiftOLR(G1H16(75),24,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(8),mass5set(:,1),  & 
G1H16(81),G1H16(82),G1H16(15),G1H16(16),G1H16(84),G1H16(85),16)
  call HG1shiftOLR(G1H16(82),24,16)
  call Hloop_GGG_G_12(ntryL,G1H16(13),ex5(:),ex4(:),G1H4(121),m4h2x2x4(:,1),heltab3x16(:,:,1))
  call Hloop_GGG_G_12(ntryL,G1H16(61),ex4(:),ex5(:),G1H4(122),m4h2x2x4(:,2),heltab3x16(:,:,2))
  call Hloop_GGG_G_23(ntryL,G1H16(63),ex5(:),ex4(:),G1H4(126),m4h2x2x4(:,3),heltab3x16(:,:,3))
  call Hloop_GGG_G_12(ntryL,G1H16(64),ex5(:),ex4(:),G1H4(127),m4h2x2x4(:,4),heltab3x16(:,:,4))
  call Hloop_GGG_G_12(ntryL,G1H16(65),ex4(:),ex5(:),G1H4(128),m4h2x2x4(:,5),heltab3x16(:,:,5))
  call Hloop_GGG_G_23(ntryL,G1H16(14),ex5(:),ex4(:),G1H4(133),m4h2x2x4(:,6),heltab3x16(:,:,6))
  call Hotf_5pt_reduction(G2H8(90),RedSet_5(118),mass5set(:,2),  & 
G1H8(262),G1H8(267),G1H8(285),G1H8(303),G1H8(321),G1H8(339),8)
  call HG1shiftOLR(G1H8(267),8,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(118),mass5set(:,2),  & 
G1H8(357),G1H8(375),G1H8(393),G1H8(411),G1H8(429),G1H8(447),8)
  call HG1shiftOLR(G1H8(375),8,8)
  call Hotf_5pt_reduction(G2H8(95),RedSet_5(118),mass5set(:,3),  & 
G1H8(465),G1H8(483),G1H8(1),G1H8(2),G1H8(3),G1H8(4),8)
  call HG1shiftOLR(G1H8(483),8,8)
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(118),mass5set(:,3),  & 
G1H8(5),G1H8(6),G1H8(113),G1H8(90),G1H8(15),G1H8(67),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_5pt_reduction(G2H8(100),RedSet_5(116),mass5set(:,2),  & 
G1H8(21),G1H8(71),G1H8(115),G1H8(86),G1H8(45),G1H8(79),8)
  call HG1shiftOLR(G1H8(71),16,8)
  call Hotf_5pt_reduction(G2H8(104),RedSet_5(116),mass5set(:,2),  & 
G1H8(63),G1H8(83),G1H8(92),G1H8(95),G1H8(96),G1H8(97),8)
  call HG1shiftOLR(G1H8(83),16,8)
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(116),mass5set(:,3),  & 
G1H8(98),G1H8(101),G1H8(117),G1H8(65),G1H8(102),G1H8(129),8)
  call HG1shiftOLR(G1H8(101),16,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(116),mass5set(:,3),  & 
G1H8(130),G1H8(135),G1H8(61),G1H8(141),G1H8(142),G1H8(147),8)
  call HG1shiftOLR(G1H8(135),16,8)
  call Hotf_5pt_reduction(G2H8(110),RedSet_5(119),mass5set(:,2),  & 
G1H8(148),G1H8(153),G1H8(77),G1H8(159),G1H8(73),G1H8(165),8)
  call HG1shiftOLR(G1H8(153),4,8)
  call Hotf_5pt_reduction(G2H8(114),RedSet_5(119),mass5set(:,2),  & 
G1H8(166),G1H8(171),G1H8(172),G1H8(91),G1H8(183),G1H8(184),8)
  call HG1shiftOLR(G1H8(171),4,8)
  call Hotf_5pt_reduction(G2H8(115),RedSet_5(119),mass5set(:,3),  & 
G1H8(189),G1H8(190),G1H8(195),G1H8(196),G1H8(201),G1H8(202),8)
  call HG1shiftOLR(G1H8(190),4,8)
  call Hotf_5pt_reduction(G2H8(117),RedSet_5(119),mass5set(:,3),  & 
G1H8(207),G1H8(208),G1H8(219),G1H8(400),G1H8(225),G1H8(406),8)
  call HG1shiftOLR(G1H8(208),4,8)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(64),mass5set(:,1),  & 
G1H16(86),G1H16(87),G1H16(88),G1H16(90),G1H16(91),G1H16(92),16)
  call HG1shiftOLR(G1H16(87),16,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(64),mass5set(:,2),  & 
G1H16(93),G1H16(94),G1H16(96),G1H16(97),G1H16(98),G1H16(99),16)
  call HG1shiftOLR(G1H16(94),16,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(64),mass5set(:,1),  & 
G1H16(100),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G1H16(106),16)
  call HG1shiftOLR(G1H16(102),16,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(64),mass5set(:,2),  & 
G1H16(108),G1H16(111),G1H16(112),G1H16(114),G1H16(117),G1H16(118),16)
  call HG1shiftOLR(G1H16(111),16,16)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(64),mass5set(:,3),  & 
G1H16(121),G1H16(123),G1H16(124),G1H16(128),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(123),16,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(64),mass5set(:,3),  & 
G1H16(131),G1H16(20),G1H16(134),G1H16(136),G1H16(21),G1H16(137),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hotf_5pt_reduction(G2H8(119),RedSet_5(114),mass5set(:,2),  & 
G1H8(237),G1H8(238),G1H8(243),G1H8(244),G1H8(255),G1H8(274),8)
  call HG1shiftOLR(G1H8(238),16,8)
  call Hotf_5pt_reduction(G2H8(122),RedSet_5(114),mass5set(:,2),  & 
G1H8(261),G1H8(280),G1H8(273),G1H8(279),G1H8(291),G1H8(292),8)
  call HG1shiftOLR(G1H8(280),16,8)
  call Hotf_5pt_reduction(G2H8(123),RedSet_5(114),mass5set(:,3),  & 
G1H8(297),G1H8(298),G1H8(309),G1H8(310),G1H8(315),G1H8(316),8)
  call HG1shiftOLR(G1H8(298),16,8)
  call Hotf_5pt_reduction(G2H8(126),RedSet_5(114),mass5set(:,3),  & 
G1H8(327),G1H8(328),G1H8(333),G1H8(334),G1H8(345),G1H8(346),8)
  call HG1shiftOLR(G1H8(328),16,8)
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(63),mass5set(:,1),  & 
G1H16(139),G1H16(140),G1H16(141),G1H16(143),G1H16(145),G1H16(22),16)
  call HG1shiftOLR(G1H16(140),16,16)
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(63),mass5set(:,2),  & 
G1H16(23),G1H16(149),G1H16(150),G1H16(151),G1H16(152),G1H16(154),16)
  call HG1shiftOLR(G1H16(149),16,16)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(63),mass5set(:,1),  & 
G1H16(27),G1H16(41),G1H16(7),G1H16(57),G1H16(67),G1H16(73),16)
  call HG1shiftOLR(G1H16(41),16,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(63),mass5set(:,2),  & 
G1H16(83),G1H16(89),G1H16(119),G1H16(125),G1H16(19),G1H16(35),16)
  call HG1shiftOLR(G1H16(89),16,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(63),mass5set(:,3),  & 
G1H16(31),G1H16(37),G1H16(47),G1H16(53),G1H16(4),G1H16(25),16)
  call HG1shiftOLR(G1H16(37),16,16)
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(63),mass5set(:,3),  & 
G1H16(29),G1H16(30),G1H16(107),G1H16(33),G1H16(36),G1H16(39),16)
  call HG1shiftOLR(G1H16(30),16,16)
  call Hotf_5pt_reduction(G2H8(128),RedSet_5(117),mass5set(:,2),  & 
G1H8(351),G1H8(352),G1H8(363),G1H8(364),G1H8(369),G1H8(370),8)
  call HG1shiftOLR(G1H8(352),4,8)
  call Hotf_5pt_reduction(G2H8(132),RedSet_5(117),mass5set(:,2),  & 
G1H8(381),G1H8(382),G1H8(387),G1H8(388),G1H8(399),G1H8(405),8)
  call HG1shiftOLR(G1H8(382),4,8)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(117),mass5set(:,3),  & 
G1H8(417),G1H8(418),G1H8(423),G1H8(424),G1H8(435),G1H8(436),8)
  call HG1shiftOLR(G1H8(418),4,8)
  call Hotf_5pt_reduction(G2H8(136),RedSet_5(117),mass5set(:,3),  & 
G1H8(441),G1H8(442),G1H8(453),G1H8(454),G1H8(459),G1H8(460),8)
  call HG1shiftOLR(G1H8(442),4,8)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(65),mass5set(:,1),  & 
G1H16(40),G1H16(3),G1H16(42),G1H16(45),G1H16(48),G1H16(49),16)
  call HG1shiftOLR(G1H16(3),8,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(65),mass5set(:,2),  & 
G1H16(50),G1H16(51),G1H16(52),G1H16(54),G1H16(56),G1H16(8),16)
  call HG1shiftOLR(G1H16(51),8,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(65),mass5set(:,1),  & 
G1H16(13),G1H16(61),G1H16(63),G1H16(64),G1H16(65),G1H16(14),16)
  call HG1shiftOLR(G1H16(61),8,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(65),mass5set(:,2),  & 
G1H16(157),G1H16(158),G1H16(159),G1H16(160),G1H16(161),G1H16(162),16)
  call HG1shiftOLR(G1H16(158),8,16)
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(65),mass5set(:,3),  & 
G1H16(163),G1H16(164),G1H16(165),G1H16(166),G1H16(167),G1H16(168),16)
  call HG1shiftOLR(G1H16(164),8,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(65),mass5set(:,3),  & 
G1H16(169),G1H16(170),G1H16(171),G1H16(172),G1H16(173),G1H16(174),16)
  call HG1shiftOLR(G1H16(170),8,16)
  call Hotf_5pt_reduction(G2H8(138),RedSet_5(115),mass5set(:,2),  & 
G1H8(471),G1H8(472),G1H8(477),G1H8(478),G1H8(489),G1H8(490),8)
  call HG1shiftOLR(G1H8(472),8,8)
  call Hotf_5pt_reduction(G2H8(141),RedSet_5(115),mass5set(:,2),  & 
G1H8(495),G1H8(496),G1H8(499),G1H8(500),G1H8(501),G1H8(502),8)
  call HG1shiftOLR(G1H8(496),8,8)
  call Hotf_5pt_reduction(G2H8(142),RedSet_5(115),mass5set(:,3),  & 
G1H8(503),G1H8(504),G1H8(505),G1H8(506),G1H8(507),G1H8(508),8)
  call HG1shiftOLR(G1H8(504),8,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(115),mass5set(:,3),  & 
G1H8(509),G1H8(510),G1H8(511),G1H8(512),G1H8(513),G1H8(514),8)
  call HG1shiftOLR(G1H8(510),8,8)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(134),mass5set(:,1),  & 
G1H16(175),G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),16)
  call HG1shiftOLR(G1H16(176),16,16)
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(134),mass5set(:,2),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G1H16(186),16)
  call HG1shiftOLR(G1H16(182),16,16)
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(134),mass5set(:,1),  & 
G1H16(187),G1H16(188),G1H16(189),G1H16(190),G1H16(191),G1H16(192),16)
  call HG1shiftOLR(G1H16(188),16,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(134),mass5set(:,2),  & 
G1H16(193),G1H16(194),G1H16(195),G1H16(196),G1H16(197),G1H16(198),16)
  call HG1shiftOLR(G1H16(194),16,16)
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(134),mass5set(:,3),  & 
G1H16(199),G1H16(200),G1H16(201),G1H16(202),G1H16(203),G1H16(204),16)
  call HG1shiftOLR(G1H16(200),16,16)
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(134),mass5set(:,3),  & 
G1H16(205),G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),16)
  call HG1shiftOLR(G1H16(206),16,16)
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(135),mass5set(:,1),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G1H16(216),16)
  call HG1shiftOLR(G1H16(212),8,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(135),mass5set(:,2),  & 
G1H16(217),G1H16(218),G1H16(219),G1H16(220),G1H16(221),G1H16(222),16)
  call HG1shiftOLR(G1H16(218),8,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(135),mass5set(:,1),  & 
G1H16(223),G1H16(224),G1H16(225),G1H16(226),G1H16(227),G1H16(228),16)
  call HG1shiftOLR(G1H16(224),8,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(135),mass5set(:,2),  & 
G1H16(229),G1H16(230),G1H16(231),G1H16(232),G1H16(233),G1H16(234),16)
  call HG1shiftOLR(G1H16(230),8,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(135),mass5set(:,3),  & 
G1H16(235),G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),16)
  call HG1shiftOLR(G1H16(236),8,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(135),mass5set(:,3),  & 
G1H16(241),G1H16(242),G1H16(243),G1H16(244),G1H16(245),G1H16(246),16)
  call HG1shiftOLR(G1H16(242),8,16)
  call Hotf_5pt_reduction(G2H16(37),RedSet_5(136),mass5set(:,1),  & 
G1H16(247),G1H16(248),G1H16(249),G1H16(250),G1H16(251),G1H16(252),16)
  call HG1shiftOLR(G1H16(248),16,16)
  call Hotf_5pt_reduction(G2H16(38),RedSet_5(136),mass5set(:,2),  & 
G1H16(253),G1H16(254),G1H16(255),G1H16(256),G1H16(257),G1H16(258),16)
  call HG1shiftOLR(G1H16(254),16,16)
  call Hotf_5pt_reduction(G2H16(39),RedSet_5(136),mass5set(:,1),  & 
G1H16(259),G1H16(260),G1H16(261),G1H16(262),G1H16(263),G1H16(264),16)
  call HG1shiftOLR(G1H16(260),16,16)
  call Hotf_5pt_reduction(G2H16(40),RedSet_5(136),mass5set(:,2),  & 
G1H16(265),G1H16(266),G1H16(267),G1H16(268),G1H16(269),G1H16(270),16)
  call HG1shiftOLR(G1H16(266),16,16)
  call Hotf_5pt_reduction(G2H16(41),RedSet_5(136),mass5set(:,3),  & 
G1H16(271),G1H16(272),G1H16(273),G1H16(274),G1H16(275),G1H16(276),16)
  call HG1shiftOLR(G1H16(272),16,16)
  call Hotf_5pt_reduction(G2H16(42),RedSet_5(136),mass5set(:,3),  & 
G1H16(277),G1H16(278),G1H16(279),G1H16(280),G1H16(281),G1H16(282),16)
  call HG1shiftOLR(G1H16(278),16,16)
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(35),mass5set(:,1),  & 
G1H16(283),G1H16(284),G1H16(285),G1H16(286),G1H16(287),G1H16(288),16)
  call HG1shiftOLR(G1H16(284),5,16)
  call Hloop_UV_W(ntryL,G1H16(109),34,ex4(:),8,G2H8(3),m3h2x8(:,225),heltab2x16(:,:,225))
  call Hloop_UV_W(ntryL,G1H16(110),34,ex4(:),8,G2H8(4),m3h2x8(:,226),heltab2x16(:,:,226))
  call Hotf_5pt_reduction(G2H16(44),RedSet_5(48),mass5set(:,1),  & 
G1H16(109),G1H16(110),G1H16(289),G1H16(290),G1H16(291),G1H16(292),16)
  call HG1shiftOLR(G1H16(110),16,16)
  call Hloop_QA_V(ntryL,G2H16(45),ex2(:),G2H8(5),m3h2x8(:,227),heltab2x16(:,:,227))
  call Hotf_5pt_reduction(G2H16(46),RedSet_5(46),mass5set(:,1),  & 
G1H16(293),G1H16(294),G1H16(295),G1H16(296),G1H16(297),G1H16(298),16)
  call HG1shiftOLR(G1H16(294),16,16)
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(33),mass5set(:,1),  & 
G1H16(299),G1H16(300),G1H16(301),G1H16(302),G1H16(303),G1H16(304),16)
  call HG1shiftOLR(G1H16(300),5,16)
  call Hloop_UV_W(ntryL,G1H16(115),34,ex5(:),16,G2H8(6),m3h2x8(:,228),heltab2x16(:,:,228))
  call Hloop_UV_W(ntryL,G1H16(116),34,ex5(:),16,G2H8(7),m3h2x8(:,229),heltab2x16(:,:,229))
  call Hotf_5pt_reduction(G2H16(48),RedSet_5(44),mass5set(:,1),  & 
G1H16(115),G1H16(116),G1H16(305),G1H16(306),G1H16(307),G1H16(308),16)
  call HG1shiftOLR(G1H16(116),8,16)
  call Hloop_AQ_V(ntryL,G2H16(49),wf4(:,2),G2H4(143),m3h4x4(:,1),heltab2x16(:,:,230))
  call Hotf_5pt_reduction(G2H16(50),RedSet_5(41),mass5set(:,1),  & 
G1H16(309),G1H16(310),G1H16(311),G1H16(312),G1H16(313),G1H16(314),16)
  call HG1shiftOLR(G1H16(310),16,16)
  call Hloop_VQ_A(ntryL,G1H16(120),wf4(:,2),G1H4(134),m3h4x4(:,2),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(134),39,0,G2H4(146),n2h4(395))
  call Hloop_AQ_V(ntryL,G2H16(51),wf4(:,2),G2H4(147),m3h4x4(:,3),heltab2x16(:,:,232))
  call Hloop_VQ_A(ntryL,G1H16(122),wf4(:,2),G1H4(138),m3h4x4(:,4),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(138),39,0,G2H4(150),n2h4(396))
  call Hloop_AQ_V(ntryL,G2H16(52),wf4(:,2),G2H4(309),m3h4x4(:,5),heltab2x16(:,:,234))
  call Hotf_5pt_reduction(G2H16(53),RedSet_5(18),mass5set(:,1),  & 
G1H16(120),G1H16(122),G1H16(315),G1H16(316),G1H16(317),G1H16(318),16)
  call HG1shiftOLR(G1H16(122),6,16)
  call Hloop_UV_W(ntryL,G1H16(126),33,ex4(:),8,G2H8(8),m3h2x8(:,230),heltab2x16(:,:,235))
  call Hloop_UV_W(ntryL,G1H16(127),33,ex4(:),8,G2H8(9),m3h2x8(:,231),heltab2x16(:,:,236))
  call Hotf_5pt_reduction(G2H16(54),RedSet_5(58),mass5set(:,1),  & 
G1H16(126),G1H16(127),G1H16(319),G1H16(320),G1H16(321),G1H16(322),16)
  call HG1shiftOLR(G1H16(127),16,16)
  call Hloop_AQ_V(ntryL,G2H16(55),ex1(:),G2H8(10),m3h2x8(:,232),heltab2x16(:,:,237))
  call Hotf_5pt_reduction(G2H16(56),RedSet_5(42),mass5set(:,1),  & 
G1H16(323),G1H16(324),G1H16(325),G1H16(326),G1H16(327),G1H16(328),16)
  call HG1shiftOLR(G1H16(324),16,16)
  call Hotf_5pt_reduction(G2H16(57),RedSet_5(20),mass5set(:,1),  & 
G1H16(329),G1H16(330),G1H16(331),G1H16(332),G1H16(333),G1H16(334),16)
  call HG1shiftOLR(G1H16(330),6,16)
  call Hloop_UV_W(ntryL,G1H16(129),33,ex5(:),16,G2H8(11),m3h2x8(:,233),heltab2x16(:,:,238))
  call Hloop_UV_W(ntryL,G1H16(130),33,ex5(:),16,G2H8(12),m3h2x8(:,234),heltab2x16(:,:,239))
  call Hotf_5pt_reduction(G2H16(58),RedSet_5(61),mass5set(:,1),  & 
G1H16(129),G1H16(130),G1H16(335),G1H16(336),G1H16(337),G1H16(338),16)
  call HG1shiftOLR(G1H16(130),8,16)
  call Hloop_QA_V(ntryL,G2H16(59),wf4(:,4),G2H4(310),m3h4x4(:,6),heltab2x16(:,:,240))
  call Hotf_5pt_reduction(G2H16(60),RedSet_5(45),mass5set(:,1),  & 
G1H16(339),G1H16(340),G1H16(341),G1H16(342),G1H16(343),G1H16(344),16)
  call HG1shiftOLR(G1H16(340),16,16)
  call Hloop_VA_Q(ntryL,G1H16(132),wf4(:,4),G1H4(139),m3h4x4(:,7),heltab2x16(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(139),39,0,G2H4(311),n2h4(397))
  call Hloop_QA_V(ntryL,G2H16(61),wf4(:,4),G2H4(312),m3h4x4(:,8),heltab2x16(:,:,242))
  call Hloop_VA_Q(ntryL,G1H16(135),wf4(:,4),G1H4(140),m3h4x4(:,9),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(140),39,0,G2H4(313),n2h4(398))
  call Hloop_QA_V(ntryL,G2H16(62),wf4(:,4),G2H4(314),m3h4x4(:,10),heltab2x16(:,:,244))
  call Hloop_QA_V(ntryL,G2H16(63),ex2(:),G2H8(13),m3h2x8(:,235),heltab2x16(:,:,245))
  call Hotf_5pt_reduction(G2H16(64),RedSet_5(16),mass5set(:,1),  & 
G1H16(132),G1H16(135),G1H16(345),G1H16(346),G1H16(347),G1H16(348),16)
  call HG1shiftOLR(G1H16(135),9,16)
  call Hotf_5pt_reduction(G2H16(65),RedSet_5(56),mass5set(:,1),  & 
G1H16(349),G1H16(350),G1H16(351),G1H16(352),G1H16(353),G1H16(354),16)
  call HG1shiftOLR(G1H16(350),16,16)
  call Hloop_QA_V(ntryL,G2H16(66),ex2(:),G2H8(14),m3h2x8(:,236),heltab2x16(:,:,246))
  call Hotf_5pt_reduction(G2H16(67),RedSet_5(9),mass5set(:,1),  & 
G1H16(355),G1H16(356),G1H16(357),G1H16(358),G1H16(359),G1H16(360),16)
  call HG1shiftOLR(G1H16(356),9,16)
  call Hloop_UV_W(ntryL,G1H16(142),34,ex5(:),16,G2H8(15),m3h2x8(:,237),heltab2x16(:,:,247))
  call Hotf_5pt_reduction(G2H16(68),RedSet_5(3),mass5set(:,1),  & 
G1H16(142),G1H16(361),G1H16(362),G1H16(363),G1H16(364),G1H16(365),16)
  call HG1shiftOLR(G1H16(361),9,16)
  call Hloop_AQ_V(ntryL,G2H16(69),wf4(:,15),G2H4(315),m3h4x4(:,11),heltab2x16(:,:,248))
  call Hloop_VQ_A(ntryL,G1H16(146),wf4(:,15),G1H4(145),m3h4x4(:,12),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(145),43,0,G2H4(316),n2h4(399))
  call Hloop_VQ_A(ntryL,G1H16(147),wf4(:,15),G1H4(146),m3h4x4(:,13),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(146),43,0,G2H4(317),n2h4(400))
  call Hloop_AQ_V(ntryL,G2H16(70),ex1(:),G2H8(16),m3h2x8(:,238),heltab2x16(:,:,251))
  call Hotf_5pt_reduction(G2H16(71),RedSet_5(14),mass5set(:,1),  & 
G1H16(146),G1H16(147),G1H16(366),G1H16(367),G1H16(368),G1H16(369),16)
  call HG1shiftOLR(G1H16(147),10,16)
  call Hotf_5pt_reduction(G2H16(72),RedSet_5(50),mass5set(:,1),  & 
G1H16(370),G1H16(371),G1H16(372),G1H16(373),G1H16(374),G1H16(375),16)
  call HG1shiftOLR(G1H16(371),16,16)
  call Hloop_AQ_V(ntryL,G2H16(73),ex1(:),G2H8(17),m3h2x8(:,239),heltab2x16(:,:,252))
  call Hotf_5pt_reduction(G2H16(74),RedSet_5(19),mass5set(:,1),  & 
G1H16(376),G1H16(377),G1H16(378),G1H16(379),G1H16(380),G1H16(381),16)
  call HG1shiftOLR(G1H16(377),10,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,ex5(:),16,G2H8(18),m3h2x8(:,240),heltab2x16(:,:,253))
  call Hotf_5pt_reduction(G2H16(75),RedSet_5(6),mass5set(:,1),  & 
G1H16(24),G1H16(382),G1H16(383),G1H16(384),G1H16(385),G1H16(386),16)
  call HG1shiftOLR(G1H16(382),10,16)
  call Hloop_QA_V(ntryL,G2H16(76),wf4(:,7),G2H4(318),m3h4x4(:,14),heltab2x16(:,:,254))
  call Hloop_VA_Q(ntryL,G1H16(155),wf4(:,7),G1H4(150),m3h4x4(:,15),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(150),43,0,G2H4(319),n2h4(401))
  call Hloop_VA_Q(ntryL,G1H16(156),wf4(:,7),G1H4(151),m3h4x4(:,16),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(151),43,0,G2H4(320),n2h4(402))
  call Hloop_QA_V(ntryL,G2H16(77),ex2(:),G2H8(19),m3h2x8(:,241),heltab2x16(:,:,257))
  call Hotf_5pt_reduction(G2H16(78),RedSet_5(10),mass5set(:,1),  & 
G1H16(155),G1H16(156),G1H16(387),G1H16(388),G1H16(389),G1H16(390),16)
  call HG1shiftOLR(G1H16(156),17,16)
  call Hotf_5pt_reduction(G2H16(79),RedSet_5(15),mass5set(:,1),  & 
G1H16(391),G1H16(392),G1H16(393),G1H16(394),G1H16(395),G1H16(396),16)
  call HG1shiftOLR(G1H16(392),17,16)
  call Hotf_5pt_reduction(G2H16(80),RedSet_5(57),mass5set(:,1),  & 
G1H16(397),G1H16(398),G1H16(399),G1H16(400),G1H16(401),G1H16(402),16)
  call HG1shiftOLR(G1H16(398),8,16)
  call Hotf_5pt_reduction(G2H16(81),RedSet_5(4),mass5set(:,1),  & 
G1H16(403),G1H16(404),G1H16(405),G1H16(406),G1H16(407),G1H16(408),16)
  call HG1shiftOLR(G1H16(404),17,16)
  call Hloop_QA_V(ntryL,G2H16(82),ex2(:),G2H8(20),m3h2x8(:,242),heltab2x16(:,:,258))
  call Hotf_5pt_reduction(G2H16(83),RedSet_5(11),mass5set(:,1),  & 
G1H16(409),G1H16(410),G1H16(411),G1H16(412),G1H16(413),G1H16(414),16)
  call HG1shiftOLR(G1H16(410),17,16)
  call Hloop_UV_W(ntryL,G1H16(79),34,ex4(:),8,G2H8(21),m3h2x8(:,243),heltab2x16(:,:,259))
  call Hotf_5pt_reduction(G2H16(84),RedSet_5(5),mass5set(:,1),  & 
G1H16(79),G1H16(415),G1H16(416),G1H16(417),G1H16(418),G1H16(419),16)
  call HG1shiftOLR(G1H16(415),17,16)
  call Hloop_AQ_V(ntryL,G2H16(85),wf4(:,17),G2H4(321),m3h4x4(:,17),heltab2x16(:,:,260))
  call Hloop_VQ_A(ntryL,G1H16(95),wf4(:,17),G1H4(152),m3h4x4(:,18),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(152),51,0,G2H4(322),n2h4(403))
  call Hloop_VQ_A(ntryL,G1H16(101),wf4(:,17),G1H4(157),m3h4x4(:,19),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(157),51,0,G2H4(323),n2h4(404))
  call Hloop_AQ_V(ntryL,G2H16(86),ex1(:),G2H8(22),m3h2x8(:,244),heltab2x16(:,:,263))
  call Hotf_5pt_reduction(G2H16(87),RedSet_5(7),mass5set(:,1),  & 
G1H16(95),G1H16(101),G1H16(420),G1H16(421),G1H16(422),G1H16(423),16)
  call HG1shiftOLR(G1H16(101),18,16)
  call Hotf_5pt_reduction(G2H16(88),RedSet_5(13),mass5set(:,1),  & 
G1H16(424),G1H16(425),G1H16(426),G1H16(427),G1H16(428),G1H16(429),16)
  call HG1shiftOLR(G1H16(425),18,16)
  call Hotf_5pt_reduction(G2H16(89),RedSet_5(52),mass5set(:,1),  & 
G1H16(430),G1H16(431),G1H16(432),G1H16(433),G1H16(434),G1H16(435),16)
  call HG1shiftOLR(G1H16(431),8,16)
  call Hotf_5pt_reduction(G2H16(90),RedSet_5(1),mass5set(:,1),  & 
G1H16(436),G1H16(437),G1H16(438),G1H16(439),G1H16(440),G1H16(441),16)
  call HG1shiftOLR(G1H16(437),18,16)
  call Hloop_AQ_V(ntryL,G2H16(91),ex1(:),G2H8(23),m3h2x8(:,245),heltab2x16(:,:,264))
  call Hotf_5pt_reduction(G2H16(92),RedSet_5(17),mass5set(:,1),  & 
G1H16(442),G1H16(443),G1H16(444),G1H16(445),G1H16(446),G1H16(447),16)
  call HG1shiftOLR(G1H16(443),18,16)
  call Hloop_UV_W(ntryL,G1H16(38),33,ex4(:),8,G2H8(24),m3h2x8(:,246),heltab2x16(:,:,265))
  call Hotf_5pt_reduction(G2H16(93),RedSet_5(2),mass5set(:,1),  & 
G1H16(38),G1H16(448),G1H16(449),G1H16(450),G1H16(451),G1H16(452),16)
  call HG1shiftOLR(G1H16(448),18,16)
  call Hloop_QA_V(ntryL,G2H16(94),wf4(:,10),G2H4(324),m3h4x4(:,20),heltab2x16(:,:,266))
  call Hloop_VA_Q(ntryL,G1H16(43),wf4(:,10),G1H4(158),m3h4x4(:,21),heltab2x16(:,:,267))
  call Hloop_A_Q(ntryL,G1H4(158),51,0,G2H4(325),n2h4(405))
  call Hloop_VA_Q(ntryL,G1H16(1),wf4(:,10),G1H4(162),m3h4x4(:,22),heltab2x16(:,:,268))
  call Hloop_A_Q(ntryL,G1H4(162),51,0,G2H4(326),n2h4(406))
  call Hloop_VQ_A(ntryL,G1H16(62),ex1(:),G1H8(515),m3h2x8(:,247),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G1H8(515),35,0,G2H8(25),n2h8(291))
  call Hloop_AQ_V(ntryL,G2H16(95),ex1(:),G2H8(26),m3h2x8(:,248),heltab2x16(:,:,270))
  call Hloop_VA_Q(ntryL,G1H16(32),ex2(:),G1H8(515),m3h2x8(:,249),heltab2x16(:,:,271))
  call Hloop_A_Q(ntryL,G1H8(515),35,0,G2H8(27),n2h8(292))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(515),m3h2x8(:,250),heltab2x16(:,:,272))
  call Hloop_A_Q(ntryL,G1H8(515),35,0,G2H8(28),n2h8(293))
  call Hloop_QA_V(ntryL,G2H16(96),ex2(:),G2H8(29),m3h2x8(:,251),heltab2x16(:,:,273))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(515),m3h2x8(:,252),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G1H8(515),35,0,G2H8(30),n2h8(294))
  call Hotf_5pt_reduction(G2H16(97),RedSet_5(12),mass5set(:,1),  & 
G1H16(43),G1H16(1),G1H16(62),G1H16(32),G1H16(2),G1H16(28),16)
  call HG1shiftOLR(G1H16(1),24,16)
  call Hotf_5pt_reduction(G2H16(98),RedSet_5(54),mass5set(:,1),  & 
G1H16(453),G1H16(454),G1H16(455),G1H16(456),G1H16(457),G1H16(458),16)
  call HG1shiftOLR(G1H16(454),2,16)
  call Hotf_5pt_reduction(G2H16(99),RedSet_5(8),mass5set(:,1),  & 
G1H16(459),G1H16(460),G1H16(461),G1H16(462),G1H16(463),G1H16(464),16)
  call HG1shiftOLR(G1H16(460),24,16)
  call Hloop_UV_W(ntryL,G1H16(113),34,wf4(:,12),24,G2H4(327),m3h4x4(:,23),heltab2x16(:,:,275))
  call Hotf_5pt_reduction(G2H16(100),RedSet_5(59),mass5set(:,1),  & 
G1H16(113),G1H16(465),G1H16(466),G1H16(467),G1H16(468),G1H16(469),16)
  call HG1shiftOLR(G1H16(465),2,16)
  call Hloop_UV_W(ntryL,G1H16(34),33,wf4(:,12),24,G2H4(328),m3h4x4(:,24),heltab2x16(:,:,276))
  call Hloop_VQ_A(ntryL,G1H8(114),ex1(:),G1H4(163),m3h2x4(:,459),heltab2x8(:,:,459))
  call Hloop_Q_A(ntryL,G1H4(163),43,0,G2H4(329),n2h4(407))
  call Hloop_VA_Q(ntryL,G1H8(116),ex2(:),G1H4(164),m3h2x4(:,460),heltab2x8(:,:,460))
  call Hloop_A_Q(ntryL,G1H4(164),43,0,G2H4(330),n2h4(408))
  call Hloop_UV_W(ntryL,G1H8(119),42,ex5(:),16,G2H4(331),m3h2x4(:,461),heltab2x8(:,:,461))
  call Hloop_UV_W(ntryL,G1H8(120),41,ex5(:),16,G2H4(332),m3h2x4(:,462),heltab2x8(:,:,462))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(333),m3h2x4(:,463),heltab2x8(:,:,463))
  call Hloop_VQ_A(ntryL,G1H8(122),ex1(:),G1H4(169),m3h2x4(:,464),heltab2x8(:,:,464))
  call Hloop_Q_A(ntryL,G1H4(169),51,0,G2H4(334),n2h4(409))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(335),m3h2x4(:,465),heltab2x8(:,:,465))
  call Hloop_VQ_A(ntryL,G1H8(126),ex1(:),G1H4(170),m3h2x4(:,466),heltab2x8(:,:,466))
  call Hloop_Q_A(ntryL,G1H4(170),51,0,G2H4(336),n2h4(410))
  call Hloop_VA_Q(ntryL,G1H8(127),ex2(:),G1H4(174),m3h2x4(:,467),heltab2x8(:,:,467))
  call Hloop_A_Q(ntryL,G1H4(174),51,0,G2H4(337),n2h4(411))
  call Hloop_VA_Q(ntryL,G1H8(128),ex2(:),G1H4(175),m3h2x4(:,468),heltab2x8(:,:,468))
  call Hloop_A_Q(ntryL,G1H4(175),51,0,G2H4(338),n2h4(412))
  call Hloop_UV_W(ntryL,G1H8(131),50,ex4(:),8,G2H4(339),m3h2x4(:,469),heltab2x8(:,:,469))
  call Hloop_UV_W(ntryL,G1H8(132),49,ex4(:),8,G2H4(340),m3h2x4(:,470),heltab2x8(:,:,470))
  call Hloop_AV_Q(ntryL,G1H8(133),ex3(:),G1H4(176),m3h2x4(:,471),heltab2x8(:,:,471))
  call Hloop_A_Q(ntryL,G1H4(176),60,0,G2H4(341),n2h4(413))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(134),-2,0,G2H8(31),n2h8(295))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(342),m3h2x4(:,472),heltab2x8(:,:,472))
  call Hloop_AV_Q(ntryL,G1H8(138),ex3(:),G1H4(181),m3h2x4(:,473),heltab2x8(:,:,473))
  call Hloop_A_Q(ntryL,G1H4(181),60,0,G2H4(343),n2h4(414))
  call Hloop_AV_Q(ntryL,G1H8(139),ex3(:),G1H4(182),m3h2x4(:,474),heltab2x8(:,:,474))
  call Hloop_A_Q(ntryL,G1H4(182),60,0,G2H4(344),n2h4(415))
  call Hloop_AV_Q(ntryL,G1H8(140),ex3(:),G1H4(186),m3h2x4(:,475),heltab2x8(:,:,475))
  call Hloop_A_Q(ntryL,G1H4(186),60,0,G2H4(345),n2h4(416))
  call Hloop_AV_Q(ntryL,G1H8(143),ex4(:),G1H4(187),m3h2x4(:,476),heltab2x8(:,:,476))
  call Hloop_A_Q(ntryL,G1H4(187),60,0,G2H4(346),n2h4(417))
call HGT_OLR(G1H8(144),1,1,8)
call HGT_invQ_OLR(G1H8(144),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(144),-2,0,G2H8(32),n2h8(296))
  call Hloop_QA_V(ntryL,G2H8(32),ex2(:),G2H4(347),m3h2x4(:,477),heltab2x8(:,:,477))
  call Hloop_AV_Q(ntryL,G1H8(146),ex4(:),G1H4(188),m3h2x4(:,478),heltab2x8(:,:,478))
  call Hloop_A_Q(ntryL,G1H4(188),60,0,G2H4(348),n2h4(418))
  call Hloop_AV_Q(ntryL,G1H8(149),ex4(:),G1H4(193),m3h2x4(:,479),heltab2x8(:,:,479))
  call Hloop_A_Q(ntryL,G1H4(193),60,0,G2H4(349),n2h4(419))
  call Hloop_AV_Q(ntryL,G1H8(150),ex4(:),G1H4(194),m3h2x4(:,480),heltab2x8(:,:,480))
  call Hloop_A_Q(ntryL,G1H4(194),60,0,G2H4(350),n2h4(420))
  call Hloop_QV_A(ntryL,G1H8(151),ex5(:),G1H4(198),m3h2x4(:,481),heltab2x8(:,:,481))
  call Hloop_Q_A(ntryL,G1H4(198),60,0,G2H4(351),n2h4(421))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(152),-1,0,G2H8(33),n2h8(297))
  call Hloop_AQ_V(ntryL,G2H8(33),ex1(:),G2H4(352),m3h2x4(:,482),heltab2x8(:,:,482))
  call Hloop_QV_A(ntryL,G1H8(156),ex5(:),G1H4(199),m3h2x4(:,483),heltab2x8(:,:,483))
  call Hloop_Q_A(ntryL,G1H4(199),60,0,G2H4(353),n2h4(422))
  call Hloop_QV_A(ntryL,G1H8(157),ex5(:),G1H4(200),m3h2x4(:,484),heltab2x8(:,:,484))
  call Hloop_Q_A(ntryL,G1H4(200),60,0,G2H4(354),n2h4(423))
  call Hloop_QV_A(ntryL,G1H8(158),ex5(:),G1H4(205),m3h2x4(:,485),heltab2x8(:,:,485))
  call Hloop_Q_A(ntryL,G1H4(205),60,0,G2H4(355),n2h4(424))
  call Hloop_QV_A(ntryL,G1H8(161),ex3(:),G1H4(206),m3h2x4(:,486),heltab2x8(:,:,486))
  call Hloop_Q_A(ntryL,G1H4(206),60,0,G2H4(356),n2h4(425))
call HGT_OLR(G1H8(162),1,1,8)
call HGT_invQ_OLR(G1H8(162),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(162),-1,0,G2H8(34),n2h8(298))
  call Hloop_AQ_V(ntryL,G2H8(34),ex1(:),G2H4(357),m3h2x4(:,487),heltab2x8(:,:,487))
  call Hloop_QV_A(ntryL,G1H8(164),ex3(:),G1H4(210),m3h2x4(:,488),heltab2x8(:,:,488))
  call Hloop_Q_A(ntryL,G1H4(210),60,0,G2H4(358),n2h4(426))
  call Hloop_QV_A(ntryL,G1H8(167),ex3(:),G1H4(211),m3h2x4(:,489),heltab2x8(:,:,489))
  call Hloop_Q_A(ntryL,G1H4(211),60,0,G2H4(359),n2h4(427))
  call Hloop_QV_A(ntryL,G1H8(168),ex3(:),G1H4(212),m3h2x4(:,490),heltab2x8(:,:,490))
  call Hloop_Q_A(ntryL,G1H4(212),60,0,G2H4(360),n2h4(428))
  call Hloop_QV_A(ntryL,G1H8(169),ex4(:),G1H4(217),m3h2x4(:,491),heltab2x8(:,:,491))
  call Hloop_Q_A(ntryL,G1H4(217),60,0,G2H4(361),n2h4(429))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(170),-1,0,G2H8(37),n2h8(299))
  call Hloop_AQ_V(ntryL,G2H8(37),ex1(:),G2H4(362),m3h2x4(:,492),heltab2x8(:,:,492))
  call Hloop_QV_A(ntryL,G1H8(174),ex4(:),G1H4(218),m3h2x4(:,493),heltab2x8(:,:,493))
  call Hloop_Q_A(ntryL,G1H4(218),60,0,G2H4(363),n2h4(430))
  call Hloop_QV_A(ntryL,G1H8(175),ex4(:),G1H4(222),m3h2x4(:,494),heltab2x8(:,:,494))
  call Hloop_Q_A(ntryL,G1H4(222),60,0,G2H4(364),n2h4(431))
  call Hloop_QV_A(ntryL,G1H8(176),ex4(:),G1H4(223),m3h2x4(:,495),heltab2x8(:,:,495))
  call Hloop_Q_A(ntryL,G1H4(223),60,0,G2H4(365),n2h4(432))
  call Hloop_AV_Q(ntryL,G1H8(179),ex5(:),G1H4(224),m3h2x4(:,496),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G1H4(224),60,0,G2H4(366),n2h4(433))
call HGT_OLR(G1H8(180),1,1,8)
call HGT_invQ_OLR(G1H8(180),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(180),-2,0,G2H8(52),n2h8(300))
  call Hloop_QA_V(ntryL,G2H8(52),ex2(:),G2H4(367),m3h2x4(:,497),heltab2x8(:,:,497))
  call Hloop_AV_Q(ntryL,G1H8(182),ex5(:),G1H4(229),m3h2x4(:,498),heltab2x8(:,:,498))
  call Hloop_A_Q(ntryL,G1H4(229),60,0,G2H4(368),n2h4(434))
  call Hloop_AV_Q(ntryL,G1H8(185),ex5(:),G1H4(230),m3h2x4(:,499),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H4(230),60,0,G2H4(369),n2h4(435))
  call Hloop_AV_Q(ntryL,G1H8(186),ex5(:),G1H4(234),m3h2x4(:,500),heltab2x8(:,:,500))
  call Hloop_A_Q(ntryL,G1H4(234),60,0,G2H4(370),n2h4(436))
  call Hloop_VQ_A(ntryL,G1H8(187),ex1(:),G1H4(235),m3h2x4(:,501),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(235),57,0,G2H4(371),n2h4(437))
call HGT_raise_alpha_OLR(G1H8(188),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(188),ex2(:),G1H4(236),m3h2x4(:,502),heltab2x8(:,:,502))
  call Hloop_VQ_A(ntryL,G1H8(192),ex1(:),G1H4(241),m3h2x4(:,503),heltab2x8(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(241),57,0,G2H4(372),n2h4(438))
  call Hloop_VQ_A(ntryL,G1H8(193),ex1(:),G1H4(242),m3h2x4(:,504),heltab2x8(:,:,504))
  call Hloop_Q_A(ntryL,G1H4(242),57,0,G2H4(373),n2h4(439))
  call Hloop_VQ_A(ntryL,G1H8(194),ex1(:),G1H4(246),m3h2x4(:,505),heltab2x8(:,:,505))
  call Hloop_Q_A(ntryL,G1H4(246),57,0,G2H4(374),n2h4(440))
  call Hloop_QV_A(ntryL,G1H8(197),ex3(:),G1H4(247),m3h2x4(:,506),heltab2x8(:,:,506))
  call Hloop_Q_A(ntryL,G1H4(247),45,0,G2H4(375),n2h4(441))
call HGT_raise_alpha_OLR(G1H8(198),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(198),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(198),-16,ex5(:),16,G2H4(376),m3h2x4(:,507),heltab2x8(:,:,507))
call signflip_OLR(G2H4(376))
  call Hloop_QV_A(ntryL,G1H8(200),ex3(:),G1H4(248),m3h2x4(:,508),heltab2x8(:,:,508))
  call Hloop_Q_A(ntryL,G1H4(248),45,0,G2H4(377),n2h4(442))
  call Hloop_QV_A(ntryL,G1H8(203),ex3(:),G1H4(253),m3h2x4(:,509),heltab2x8(:,:,509))
  call Hloop_Q_A(ntryL,G1H4(253),45,0,G2H4(378),n2h4(443))
  call Hloop_QV_A(ntryL,G1H8(204),ex3(:),G1H4(254),m3h2x4(:,510),heltab2x8(:,:,510))
  call Hloop_Q_A(ntryL,G1H4(254),45,0,G2H4(379),n2h4(444))
  call Hloop_AV_Q(ntryL,G1H8(205),ex3(:),G1H4(258),m3h2x4(:,511),heltab2x8(:,:,511))
  call Hloop_A_Q(ntryL,G1H4(258),54,0,G2H4(380),n2h4(445))
call HGT_raise_alpha_OLR(G1H8(206),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(206),-8,ex4(:),8,G2H4(381),m3h2x4(:,512),heltab2x8(:,:,512))
call signflip_OLR(G2H4(381))
  call Hloop_AV_Q(ntryL,G1H8(210),ex3(:),G1H4(259),m3h2x4(:,513),heltab2x8(:,:,513))
  call Hloop_A_Q(ntryL,G1H4(259),54,0,G2H4(382),n2h4(446))
  call Hloop_AV_Q(ntryL,G1H8(211),ex3(:),G1H4(260),m3h2x4(:,514),heltab2x8(:,:,514))
  call Hloop_A_Q(ntryL,G1H4(260),54,0,G2H4(383),n2h4(447))
  call Hloop_AV_Q(ntryL,G1H8(212),ex3(:),G1H4(265),m3h2x4(:,515),heltab2x8(:,:,515))
  call Hloop_A_Q(ntryL,G1H4(265),54,0,G2H4(384),n2h4(448))
  call Hloop_AV_Q(ntryL,G1H8(217),ex5(:),G1H4(266),m3h2x4(:,516),heltab2x8(:,:,516))
  call Hloop_A_Q(ntryL,G1H4(266),58,0,G2H4(385),n2h4(449))
call HGT_raise_alpha_OLR(G1H8(223),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(223),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(223),ex1(:),G1H4(270),m3h2x4(:,517),heltab2x8(:,:,517))
  call Hloop_AV_Q(ntryL,G1H8(221),ex5(:),G1H4(271),m3h2x4(:,518),heltab2x8(:,:,518))
  call Hloop_A_Q(ntryL,G1H4(271),58,0,G2H4(386),n2h4(450))
  call Hloop_AV_Q(ntryL,G1H8(222),ex5(:),G1H4(272),m3h2x4(:,519),heltab2x8(:,:,519))
  call Hloop_A_Q(ntryL,G1H4(272),58,0,G2H4(387),n2h4(451))
  call Hloop_AV_Q(ntryL,G1H8(224),ex5(:),G1H4(277),m3h2x4(:,520),heltab2x8(:,:,520))
  call Hloop_A_Q(ntryL,G1H4(277),58,0,G2H4(388),n2h4(452))
  call Hloop_AV_Q(ntryL,G1H8(227),ex3(:),G1H4(278),m3h2x4(:,521),heltab2x8(:,:,521))
  call Hloop_A_Q(ntryL,G1H4(278),54,0,G2H4(389),n2h4(453))
call HGT_raise_alpha_OLR(G1H8(228),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(228),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(228),-8,ex4(:),8,G2H4(390),m3h2x4(:,522),heltab2x8(:,:,522))
call signflip_OLR(G2H4(390))
  call Hloop_AV_Q(ntryL,G1H8(230),ex3(:),G1H4(282),m3h2x4(:,523),heltab2x8(:,:,523))
  call Hloop_A_Q(ntryL,G1H4(282),54,0,G2H4(391),n2h4(454))
  call Hloop_AV_Q(ntryL,G1H8(235),ex3(:),G1H4(283),m3h2x4(:,524),heltab2x8(:,:,524))
  call Hloop_A_Q(ntryL,G1H4(283),54,0,G2H4(392),n2h4(455))
  call Hloop_AV_Q(ntryL,G1H8(241),ex3(:),G1H4(284),m3h2x4(:,525),heltab2x8(:,:,525))
  call Hloop_A_Q(ntryL,G1H4(284),54,0,G2H4(393),n2h4(456))
  call Hloop_VA_Q(ntryL,G1H8(236),ex2(:),G1H4(289),m3h2x4(:,526),heltab2x8(:,:,526))
  call Hloop_A_Q(ntryL,G1H4(289),58,0,G2H4(394),n2h4(457))
call HGT_raise_alpha_OLR(G1H8(239),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(239),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(239),ex1(:),G1H4(290),m3h2x4(:,527),heltab2x8(:,:,527))
  call Hloop_VA_Q(ntryL,G1H8(242),ex2(:),G1H4(294),m3h2x4(:,528),heltab2x8(:,:,528))
  call Hloop_A_Q(ntryL,G1H4(294),58,0,G2H4(395),n2h4(458))
  call Hloop_VA_Q(ntryL,G1H8(245),ex2(:),G1H4(295),m3h2x4(:,529),heltab2x8(:,:,529))
  call Hloop_A_Q(ntryL,G1H4(295),58,0,G2H4(396),n2h4(459))
  call Hloop_VA_Q(ntryL,G1H8(246),ex2(:),G1H4(296),m3h2x4(:,530),heltab2x8(:,:,530))
  call Hloop_A_Q(ntryL,G1H4(296),58,0,G2H4(397),n2h4(460))
  call Hloop_AV_Q(ntryL,G1H8(247),ex3(:),G1H4(301),m3h2x4(:,531),heltab2x8(:,:,531))
  call Hloop_A_Q(ntryL,G1H4(301),46,0,G2H4(398),n2h4(461))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(248),-16,ex5(:),16,G2H4(399),m3h2x4(:,532),heltab2x8(:,:,532))
call signflip_OLR(G2H4(399))
  call Hloop_AV_Q(ntryL,G1H8(259),ex3(:),G1H4(302),m3h2x4(:,533),heltab2x8(:,:,533))
  call Hloop_A_Q(ntryL,G1H4(302),46,0,G2H4(400),n2h4(462))
  call Hloop_AV_Q(ntryL,G1H8(254),ex3(:),G1H4(306),m3h2x4(:,534),heltab2x8(:,:,534))
  call Hloop_A_Q(ntryL,G1H4(306),46,0,G2H4(401),n2h4(463))
  call Hloop_AV_Q(ntryL,G1H8(257),ex3(:),G1H4(307),m3h2x4(:,535),heltab2x8(:,:,535))
  call Hloop_A_Q(ntryL,G1H4(307),46,0,G2H4(402),n2h4(464))
  call Hloop_AV_Q(ntryL,G1H8(258),ex3(:),G1H4(308),m3h2x4(:,536),heltab2x8(:,:,536))
  call Hloop_A_Q(ntryL,G1H4(308),46,0,G2H4(403),n2h4(465))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(260),-16,ex5(:),16,G2H4(404),m3h2x4(:,537),heltab2x8(:,:,537))
call signflip_OLR(G2H4(404))
  call Hloop_AV_Q(ntryL,G1H8(264),ex3(:),G1H4(313),m3h2x4(:,538),heltab2x8(:,:,538))
  call Hloop_A_Q(ntryL,G1H4(313),46,0,G2H4(405),n2h4(466))
  call Hloop_AV_Q(ntryL,G1H8(265),ex3(:),G1H4(314),m3h2x4(:,539),heltab2x8(:,:,539))
  call Hloop_A_Q(ntryL,G1H4(314),46,0,G2H4(406),n2h4(467))
  call Hloop_AV_Q(ntryL,G1H8(266),ex3(:),G1H4(318),m3h2x4(:,540),heltab2x8(:,:,540))
  call Hloop_A_Q(ntryL,G1H4(318),46,0,G2H4(407),n2h4(468))
  call Hloop_AV_Q(ntryL,G1H8(271),ex4(:),G1H4(319),m3h2x4(:,541),heltab2x8(:,:,541))
  call Hloop_A_Q(ntryL,G1H4(319),58,0,G2H4(408),n2h4(469))
call HGT_raise_alpha_OLR(G1H8(277),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(277),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(277),ex1(:),G1H4(320),m3h2x4(:,542),heltab2x8(:,:,542))
  call Hloop_AV_Q(ntryL,G1H8(275),ex4(:),G1H4(325),m3h2x4(:,543),heltab2x8(:,:,543))
  call Hloop_A_Q(ntryL,G1H4(325),58,0,G2H4(409),n2h4(470))
  call Hloop_AV_Q(ntryL,G1H8(276),ex4(:),G1H4(326),m3h2x4(:,544),heltab2x8(:,:,544))
  call Hloop_A_Q(ntryL,G1H4(326),58,0,G2H4(410),n2h4(471))
  call Hloop_AV_Q(ntryL,G1H8(278),ex4(:),G1H4(330),m3h2x4(:,545),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H4(330),58,0,G2H4(411),n2h4(472))
  call Hloop_QV_A(ntryL,G1H8(281),ex3(:),G1H4(331),m3h2x4(:,546),heltab2x8(:,:,546))
  call Hloop_Q_A(ntryL,G1H4(331),53,0,G2H4(412),n2h4(473))
call HGT_raise_alpha_OLR(G1H8(282),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(282),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(282),-8,ex4(:),8,G2H4(413),m3h2x4(:,547),heltab2x8(:,:,547))
call signflip_OLR(G2H4(413))
  call Hloop_QV_A(ntryL,G1H8(284),ex3(:),G1H4(332),m3h2x4(:,548),heltab2x8(:,:,548))
  call Hloop_Q_A(ntryL,G1H4(332),53,0,G2H4(414),n2h4(474))
  call Hloop_QV_A(ntryL,G1H8(289),ex3(:),G1H4(337),m3h2x4(:,549),heltab2x8(:,:,549))
  call Hloop_Q_A(ntryL,G1H4(337),53,0,G2H4(415),n2h4(475))
  call Hloop_QV_A(ntryL,G1H8(295),ex3(:),G1H4(338),m3h2x4(:,550),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H4(338),53,0,G2H4(416),n2h4(476))
  call Hloop_QV_A(ntryL,G1H8(290),ex3(:),G1H4(342),m3h2x4(:,551),heltab2x8(:,:,551))
  call Hloop_Q_A(ntryL,G1H4(342),45,0,G2H4(417),n2h4(477))
call HGT_raise_alpha_OLR(G1H8(293),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(293),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(293),-16,ex5(:),16,G2H4(418),m3h2x4(:,552),heltab2x8(:,:,552))
call signflip_OLR(G2H4(418))
  call Hloop_QV_A(ntryL,G1H8(296),ex3(:),G1H4(343),m3h2x4(:,553),heltab2x8(:,:,553))
  call Hloop_Q_A(ntryL,G1H4(343),45,0,G2H4(419),n2h4(478))
  call Hloop_QV_A(ntryL,G1H8(299),ex3(:),G1H4(344),m3h2x4(:,554),heltab2x8(:,:,554))
  call Hloop_Q_A(ntryL,G1H4(344),45,0,G2H4(420),n2h4(479))
  call Hloop_QV_A(ntryL,G1H8(300),ex3(:),G1H4(349),m3h2x4(:,555),heltab2x8(:,:,555))
  call Hloop_Q_A(ntryL,G1H4(349),45,0,G2H4(421),n2h4(480))
  call Hloop_QV_A(ntryL,G1H8(301),ex3(:),G1H4(350),m3h2x4(:,556),heltab2x8(:,:,556))
  call Hloop_Q_A(ntryL,G1H4(350),53,0,G2H4(422),n2h4(481))
call HGT_raise_alpha_OLR(G1H8(302),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(302),ex2(:),G1H4(354),m3h2x4(:,557),heltab2x8(:,:,557))
  call Hloop_QV_A(ntryL,G1H8(313),ex3(:),G1H4(355),m3h2x4(:,558),heltab2x8(:,:,558))
  call Hloop_Q_A(ntryL,G1H4(355),53,0,G2H4(423),n2h4(482))
  call Hloop_QV_A(ntryL,G1H8(308),ex3(:),G1H4(356),m3h2x4(:,559),heltab2x8(:,:,559))
  call Hloop_Q_A(ntryL,G1H4(356),53,0,G2H4(424),n2h4(483))
  call Hloop_QV_A(ntryL,G1H8(311),ex3(:),G1H4(361),m3h2x4(:,560),heltab2x8(:,:,560))
  call Hloop_Q_A(ntryL,G1H4(361),53,0,G2H4(425),n2h4(484))
  call Hloop_QV_A(ntryL,G1H8(312),ex4(:),G1H4(362),m3h2x4(:,561),heltab2x8(:,:,561))
  call Hloop_Q_A(ntryL,G1H4(362),45,0,G2H4(426),n2h4(485))
call HGT_raise_alpha_OLR(G1H8(314),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(314),-16,ex5(:),16,G2H4(427),m3h2x4(:,562),heltab2x8(:,:,562))
call signflip_OLR(G2H4(427))
  call Hloop_QV_A(ntryL,G1H8(318),ex4(:),G1H4(366),m3h2x4(:,563),heltab2x8(:,:,563))
  call Hloop_Q_A(ntryL,G1H4(366),45,0,G2H4(428),n2h4(486))
  call Hloop_QV_A(ntryL,G1H8(319),ex4(:),G1H4(367),m3h2x4(:,564),heltab2x8(:,:,564))
  call Hloop_Q_A(ntryL,G1H4(367),45,0,G2H4(429),n2h4(487))
  call Hloop_QV_A(ntryL,G1H8(320),ex4(:),G1H4(368),m3h2x4(:,565),heltab2x8(:,:,565))
  call Hloop_Q_A(ntryL,G1H4(368),45,0,G2H4(430),n2h4(488))
  call Hloop_QV_A(ntryL,G1H8(325),ex3(:),G1H4(373),m3h2x4(:,566),heltab2x8(:,:,566))
  call Hloop_Q_A(ntryL,G1H4(373),45,0,G2H4(431),n2h4(489))
call HGT_raise_alpha_OLR(G1H8(331),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(331),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(331),ex2(:),G1H4(374),m3h2x4(:,567),heltab2x8(:,:,567))
  call Hloop_QV_A(ntryL,G1H8(329),ex3(:),G1H4(378),m3h2x4(:,568),heltab2x8(:,:,568))
  call Hloop_Q_A(ntryL,G1H4(378),45,0,G2H4(432),n2h4(490))
  call Hloop_QV_A(ntryL,G1H8(330),ex3(:),G1H4(379),m3h2x4(:,569),heltab2x8(:,:,569))
  call Hloop_Q_A(ntryL,G1H4(379),45,0,G2H4(433),n2h4(491))
  call Hloop_QV_A(ntryL,G1H8(332),ex3(:),G1H4(380),m3h2x4(:,570),heltab2x8(:,:,570))
  call Hloop_Q_A(ntryL,G1H4(380),45,0,G2H4(434),n2h4(492))
  call Hloop_QV_A(ntryL,G1H8(335),ex5(:),G1H4(385),m3h2x4(:,571),heltab2x8(:,:,571))
  call Hloop_Q_A(ntryL,G1H4(385),53,0,G2H4(435),n2h4(493))
call HGT_raise_alpha_OLR(G1H8(336),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(336),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(336),-8,ex4(:),8,G2H4(436),m3h2x4(:,572),heltab2x8(:,:,572))
call signflip_OLR(G2H4(436))
  call Hloop_QV_A(ntryL,G1H8(338),ex5(:),G1H4(386),m3h2x4(:,573),heltab2x8(:,:,573))
  call Hloop_Q_A(ntryL,G1H4(386),53,0,G2H4(437),n2h4(494))
  call Hloop_QV_A(ntryL,G1H8(343),ex5(:),G1H4(390),m3h2x4(:,574),heltab2x8(:,:,574))
  call Hloop_Q_A(ntryL,G1H4(390),53,0,G2H4(438),n2h4(495))
  call Hloop_QV_A(ntryL,G1H8(349),ex5(:),G1H4(391),m3h2x4(:,575),heltab2x8(:,:,575))
  call Hloop_Q_A(ntryL,G1H4(391),53,0,G2H4(439),n2h4(496))
  call Hloop_QV_A(ntryL,G1H8(344),ex5(:),G1H4(392),m3h2x4(:,576),heltab2x8(:,:,576))
  call Hloop_Q_A(ntryL,G1H4(392),53,0,G2H4(440),n2h4(497))
call HGT_raise_alpha_OLR(G1H8(347),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(347),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(347),ex2(:),G1H4(397),m3h2x4(:,577),heltab2x8(:,:,577))
  call Hloop_QV_A(ntryL,G1H8(350),ex5(:),G1H4(398),m3h2x4(:,578),heltab2x8(:,:,578))
  call Hloop_Q_A(ntryL,G1H4(398),53,0,G2H4(441),n2h4(498))
  call Hloop_QV_A(ntryL,G1H8(353),ex5(:),G1H4(402),m3h2x4(:,579),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H4(402),53,0,G2H4(442),n2h4(499))
  call Hloop_QV_A(ntryL,G1H8(354),ex5(:),G1H4(403),m3h2x4(:,580),heltab2x8(:,:,580))
  call Hloop_Q_A(ntryL,G1H4(403),53,0,G2H4(443),n2h4(500))
  call Hloop_QV_A(ntryL,G1H8(355),ex4(:),G1H4(404),m3h2x4(:,581),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H4(404),45,0,G2H4(444),n2h4(501))
call HGT_raise_alpha_OLR(G1H8(356),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(356),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(356),ex2(:),G1H4(409),m3h2x4(:,582),heltab2x8(:,:,582))
  call Hloop_QV_A(ntryL,G1H8(367),ex4(:),G1H4(410),m3h2x4(:,583),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H4(410),45,0,G2H4(445),n2h4(502))
  call Hloop_QV_A(ntryL,G1H8(362),ex4(:),G1H4(414),m3h2x4(:,584),heltab2x8(:,:,584))
  call Hloop_Q_A(ntryL,G1H4(414),45,0,G2H4(446),n2h4(503))
  call Hloop_QV_A(ntryL,G1H8(365),ex4(:),G1H4(415),m3h2x4(:,585),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H4(415),45,0,G2H4(447),n2h4(504))
  call Hloop_AV_Q(ntryL,G1H8(366),ex3(:),G1H4(416),m3h2x4(:,586),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H4(416),54,0,G2H4(448),n2h4(505))
call HGT_raise_alpha_OLR(G1H8(368),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(368),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(368),ex1(:),G1H4(421),m3h2x4(:,587),heltab2x8(:,:,587))
  call Hloop_AV_Q(ntryL,G1H8(372),ex3(:),G1H4(422),m3h2x4(:,588),heltab2x8(:,:,588))
  call Hloop_A_Q(ntryL,G1H4(422),54,0,G2H4(449),n2h4(506))
  call Hloop_AV_Q(ntryL,G1H8(373),ex3(:),G1H4(426),m3h2x4(:,589),heltab2x8(:,:,589))
  call Hloop_A_Q(ntryL,G1H4(426),54,0,G2H4(450),n2h4(507))
  call Hloop_AV_Q(ntryL,G1H8(374),ex3(:),G1H4(427),m3h2x4(:,590),heltab2x8(:,:,590))
  call Hloop_A_Q(ntryL,G1H4(427),54,0,G2H4(451),n2h4(508))
  call Hloop_AV_Q(ntryL,G1H8(379),ex4(:),G1H4(428),m3h2x4(:,591),heltab2x8(:,:,591))
  call Hloop_A_Q(ntryL,G1H4(428),46,0,G2H4(452),n2h4(509))
call HGT_raise_alpha_OLR(G1H8(385),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(385),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(385),-16,ex5(:),16,G2H4(453),m3h2x4(:,592),heltab2x8(:,:,592))
call signflip_OLR(G2H4(453))
  call Hloop_AV_Q(ntryL,G1H8(383),ex4(:),G1H4(433),m3h2x4(:,593),heltab2x8(:,:,593))
  call Hloop_A_Q(ntryL,G1H4(433),46,0,G2H4(454),n2h4(510))
  call Hloop_AV_Q(ntryL,G1H8(384),ex4(:),G1H4(434),m3h2x4(:,594),heltab2x8(:,:,594))
  call Hloop_A_Q(ntryL,G1H4(434),46,0,G2H4(455),n2h4(511))
  call Hloop_AV_Q(ntryL,G1H8(386),ex4(:),G1H4(438),m3h2x4(:,595),heltab2x8(:,:,595))
  call Hloop_A_Q(ntryL,G1H4(438),46,0,G2H4(456),n2h4(512))
  call Hloop_AV_Q(ntryL,G1H8(389),ex3(:),G1H4(439),m3h2x4(:,596),heltab2x8(:,:,596))
  call Hloop_A_Q(ntryL,G1H4(439),46,0,G2H4(457),n2h4(513))
call HGT_raise_alpha_OLR(G1H8(390),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(390),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(390),ex1(:),G1H4(440),m3h2x4(:,597),heltab2x8(:,:,597))
  call Hloop_AV_Q(ntryL,G1H8(392),ex3(:),G1H4(445),m3h2x4(:,598),heltab2x8(:,:,598))
  call Hloop_A_Q(ntryL,G1H4(445),46,0,G2H4(458),n2h4(514))
  call Hloop_AV_Q(ntryL,G1H8(397),ex3(:),G1H4(446),m3h2x4(:,599),heltab2x8(:,:,599))
  call Hloop_A_Q(ntryL,G1H4(446),46,0,G2H4(459),n2h4(515))
  call Hloop_AV_Q(ntryL,G1H8(403),ex3(:),G1H4(450),m3h2x4(:,600),heltab2x8(:,:,600))
  call Hloop_A_Q(ntryL,G1H4(450),46,0,G2H4(460),n2h4(516))
  call Hloop_AV_Q(ntryL,G1H8(398),ex5(:),G1H4(451),m3h2x4(:,601),heltab2x8(:,:,601))
  call Hloop_A_Q(ntryL,G1H4(451),54,0,G2H4(461),n2h4(517))
call HGT_raise_alpha_OLR(G1H8(401),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(401),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(401),-8,ex4(:),8,G2H4(462),m3h2x4(:,602),heltab2x8(:,:,602))
call signflip_OLR(G2H4(462))
  call Hloop_AV_Q(ntryL,G1H8(404),ex5(:),G1H4(452),m3h2x4(:,603),heltab2x8(:,:,603))
  call Hloop_A_Q(ntryL,G1H4(452),54,0,G2H4(463),n2h4(518))
  call Hloop_AV_Q(ntryL,G1H8(407),ex5(:),G1H4(457),m3h2x4(:,604),heltab2x8(:,:,604))
  call Hloop_A_Q(ntryL,G1H4(457),54,0,G2H4(464),n2h4(519))
  call Hloop_AV_Q(ntryL,G1H8(408),ex5(:),G1H4(458),m3h2x4(:,605),heltab2x8(:,:,605))
  call Hloop_A_Q(ntryL,G1H4(458),54,0,G2H4(465),n2h4(520))
  call Hloop_QV_A(ntryL,G1H8(409),ex4(:),G1H4(462),m3h2x4(:,606),heltab2x8(:,:,606))
  call Hloop_Q_A(ntryL,G1H4(462),57,0,G2H4(466),n2h4(521))
call HGT_raise_alpha_OLR(G1H8(410),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(410),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(410),ex2(:),G1H4(463),m3h2x4(:,607),heltab2x8(:,:,607))
  call Hloop_QV_A(ntryL,G1H8(421),ex4(:),G1H4(464),m3h2x4(:,608),heltab2x8(:,:,608))
  call Hloop_Q_A(ntryL,G1H4(464),57,0,G2H4(467),n2h4(522))
  call Hloop_QV_A(ntryL,G1H8(416),ex4(:),G1H4(469),m3h2x4(:,609),heltab2x8(:,:,609))
  call Hloop_Q_A(ntryL,G1H4(469),57,0,G2H4(468),n2h4(523))
  call Hloop_QV_A(ntryL,G1H8(419),ex4(:),G1H4(470),m3h2x4(:,610),heltab2x8(:,:,610))
  call Hloop_Q_A(ntryL,G1H4(470),57,0,G2H4(469),n2h4(524))
  call Hloop_QV_A(ntryL,G1H8(420),ex5(:),G1H4(474),m3h2x4(:,611),heltab2x8(:,:,611))
  call Hloop_Q_A(ntryL,G1H4(474),57,0,G2H4(470),n2h4(525))
call HGT_raise_alpha_OLR(G1H8(422),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(422),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(422),ex2(:),G1H4(475),m3h2x4(:,612),heltab2x8(:,:,612))
  call Hloop_QV_A(ntryL,G1H8(426),ex5(:),G1H4(476),m3h2x4(:,613),heltab2x8(:,:,613))
  call Hloop_Q_A(ntryL,G1H4(476),57,0,G2H4(471),n2h4(526))
  call Hloop_QV_A(ntryL,G1H8(427),ex5(:),G1H4(481),m3h2x4(:,614),heltab2x8(:,:,614))
  call Hloop_Q_A(ntryL,G1H4(481),57,0,G2H4(472),n2h4(527))
  call Hloop_QV_A(ntryL,G1H8(428),ex5(:),G1H4(482),m3h2x4(:,615),heltab2x8(:,:,615))
  call Hloop_Q_A(ntryL,G1H4(482),57,0,G2H4(473),n2h4(528))
  call Hloop_QV_A(ntryL,G1H8(433),ex3(:),G1H4(486),m3h2x4(:,616),heltab2x8(:,:,616))
  call Hloop_Q_A(ntryL,G1H4(486),45,0,G2H4(474),n2h4(529))
call HGT_raise_alpha_OLR(G1H8(439),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(439),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(439),ex2(:),G1H4(487),m3h2x4(:,617),heltab2x8(:,:,617))
  call Hloop_QV_A(ntryL,G1H8(437),ex3(:),G1H4(488),m3h2x4(:,618),heltab2x8(:,:,618))
  call Hloop_Q_A(ntryL,G1H4(488),45,0,G2H4(475),n2h4(530))
  call Hloop_QV_A(ntryL,G1H8(438),ex3(:),G1H4(493),m3h2x4(:,619),heltab2x8(:,:,619))
  call Hloop_Q_A(ntryL,G1H4(493),45,0,G2H4(476),n2h4(531))
  call Hloop_QV_A(ntryL,G1H8(440),ex3(:),G1H4(494),m3h2x4(:,620),heltab2x8(:,:,620))
  call Hloop_Q_A(ntryL,G1H4(494),45,0,G2H4(477),n2h4(532))
  call Hloop_QV_A(ntryL,G1H8(443),ex5(:),G1H4(498),m3h2x4(:,621),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H4(498),57,0,G2H4(478),n2h4(533))
call HGT_raise_alpha_OLR(G1H8(444),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(444),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(444),ex2(:),G1H4(499),m3h2x4(:,622),heltab2x8(:,:,622))
  call Hloop_QV_A(ntryL,G1H8(446),ex5(:),G1H4(500),m3h2x4(:,623),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H4(500),57,0,G2H4(479),n2h4(534))
  call Hloop_QV_A(ntryL,G1H8(451),ex5(:),G1H4(505),m3h2x4(:,624),heltab2x8(:,:,624))
  call Hloop_Q_A(ntryL,G1H4(505),57,0,G2H4(480),n2h4(535))
  call Hloop_QV_A(ntryL,G1H8(457),ex5(:),G1H4(506),m3h2x4(:,625),heltab2x8(:,:,625))
  call Hloop_Q_A(ntryL,G1H4(506),57,0,G2H4(481),n2h4(536))
  call Hloop_QV_A(ntryL,G1H8(452),ex3(:),G1H4(510),m3h2x4(:,626),heltab2x8(:,:,626))
  call Hloop_Q_A(ntryL,G1H4(510),53,0,G2H4(482),n2h4(537))
call HGT_raise_alpha_OLR(G1H8(455),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(455),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(455),-8,ex4(:),8,G2H4(483),m3h2x4(:,627),heltab2x8(:,:,627))
call signflip_OLR(G2H4(483))
  call Hloop_QV_A(ntryL,G1H8(458),ex3(:),G1H4(511),m3h2x4(:,628),heltab2x8(:,:,628))
  call Hloop_Q_A(ntryL,G1H4(511),53,0,G2H4(484),n2h4(538))
  call Hloop_QV_A(ntryL,G1H8(461),ex3(:),G1H4(512),m3h2x4(:,629),heltab2x8(:,:,629))
  call Hloop_Q_A(ntryL,G1H4(512),53,0,G2H4(485),n2h4(539))
  call Hloop_QV_A(ntryL,G1H8(462),ex3(:),G1H4(517),m3h2x4(:,630),heltab2x8(:,:,630))
  call Hloop_Q_A(ntryL,G1H4(517),53,0,G2H4(486),n2h4(540))
  call Hloop_QV_A(ntryL,G1H8(463),ex4(:),G1H4(518),m3h2x4(:,631),heltab2x8(:,:,631))
  call Hloop_Q_A(ntryL,G1H4(518),57,0,G2H4(487),n2h4(541))
call HGT_raise_alpha_OLR(G1H8(464),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(464),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(464),ex2(:),G1H4(522),m3h2x4(:,632),heltab2x8(:,:,632))
  call Hloop_QV_A(ntryL,G1H8(475),ex4(:),G1H4(523),m3h2x4(:,633),heltab2x8(:,:,633))
  call Hloop_Q_A(ntryL,G1H4(523),57,0,G2H4(488),n2h4(542))
  call Hloop_QV_A(ntryL,G1H8(470),ex4(:),G1H4(524),m3h2x4(:,634),heltab2x8(:,:,634))
  call Hloop_Q_A(ntryL,G1H4(524),57,0,G2H4(489),n2h4(543))
  call Hloop_QV_A(ntryL,G1H8(473),ex4(:),G1H4(529),m3h2x4(:,635),heltab2x8(:,:,635))
  call Hloop_Q_A(ntryL,G1H4(529),57,0,G2H4(490),n2h4(544))
  call Hloop_QV_A(ntryL,G1H8(474),ex3(:),G1H4(530),m3h2x4(:,636),heltab2x8(:,:,636))
  call Hloop_Q_A(ntryL,G1H4(530),53,0,G2H4(491),n2h4(545))
call HGT_raise_alpha_OLR(G1H8(476),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(476),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(476),ex2(:),G1H4(534),m3h2x4(:,637),heltab2x8(:,:,637))
  call Hloop_QV_A(ntryL,G1H8(480),ex3(:),G1H4(535),m3h2x4(:,638),heltab2x8(:,:,638))
  call Hloop_Q_A(ntryL,G1H4(535),53,0,G2H4(492),n2h4(546))
  call Hloop_QV_A(ntryL,G1H8(481),ex3(:),G1H4(536),m3h2x4(:,639),heltab2x8(:,:,639))
  call Hloop_Q_A(ntryL,G1H4(536),53,0,G2H4(493),n2h4(547))
  call Hloop_QV_A(ntryL,G1H8(482),ex3(:),G1H4(541),m3h2x4(:,640),heltab2x8(:,:,640))
  call Hloop_Q_A(ntryL,G1H4(541),53,0,G2H4(494),n2h4(548))
  call Hloop_QV_A(ntryL,G1H8(487),ex3(:),G1H4(542),m3h2x4(:,641),heltab2x8(:,:,641))
  call Hloop_Q_A(ntryL,G1H4(542),39,0,G2H4(495),n2h4(549))
call HGT_OLR(G1H8(493),1,1,8)
call HGT_invQ_OLR(G1H8(493),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(493),-16,0,G2H8(135),n2h8(329))
  call Hloop_AV_Q(ntryL,G2H8(135),ex5(:),G2H4(496),m3h2x4(:,642),heltab2x8(:,:,642))
  call Hloop_QV_A(ntryL,G1H8(491),ex3(:),G1H4(546),m3h2x4(:,643),heltab2x8(:,:,643))
  call Hloop_Q_A(ntryL,G1H4(546),39,0,G2H4(497),n2h4(550))
  call Hloop_QV_A(ntryL,G1H8(492),ex3(:),G1H4(547),m3h2x4(:,644),heltab2x8(:,:,644))
  call Hloop_Q_A(ntryL,G1H4(547),39,0,G2H4(498),n2h4(551))
  call Hloop_QV_A(ntryL,G1H8(494),ex3(:),G1H4(548),m3h2x4(:,645),heltab2x8(:,:,645))
  call Hloop_Q_A(ntryL,G1H4(548),39,0,G2H4(499),n2h4(552))
  call Hloop_QV_A(ntryL,G1H8(497),ex3(:),G1H4(553),m3h2x4(:,646),heltab2x8(:,:,646))
  call Hloop_Q_A(ntryL,G1H4(553),39,0,G2H4(500),n2h4(553))
call HGT_OLR(G1H8(498),1,1,8)
call HGT_invQ_OLR(G1H8(498),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(498),-8,0,G2H8(67),n2h8(330))
  call Hloop_AV_Q(ntryL,G2H8(67),ex4(:),G2H4(501),m3h2x4(:,647),heltab2x8(:,:,647))
  call Hloop_QV_A(ntryL,G1H8(216),ex3(:),G1H4(554),m3h2x4(:,648),heltab2x8(:,:,648))
  call Hloop_Q_A(ntryL,G1H4(554),39,0,G2H4(502),n2h4(554))
  call Hloop_QV_A(ntryL,G1H8(233),ex3(:),G1H4(559),m3h2x4(:,649),heltab2x8(:,:,649))
  call Hloop_Q_A(ntryL,G1H4(559),39,0,G2H4(503),n2h4(555))
  call Hloop_QV_A(ntryL,G1H8(234),ex3(:),G1H4(560),m3h2x4(:,650),heltab2x8(:,:,650))
  call Hloop_Q_A(ntryL,G1H4(560),39,0,G2H4(504),n2h4(556))
  call Hloop_QV_A(ntryL,G1H8(251),ex4(:),G1H4(564),m3h2x4(:,651),heltab2x8(:,:,651))
  call Hloop_Q_A(ntryL,G1H4(564),43,0,G2H4(505),n2h4(557))
call HGT_OLR(G1H8(252),1,1,8)
call HGT_invQ_OLR(G1H8(252),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(252),-16,0,G2H8(79),n2h8(331))
  call Hloop_AV_Q(ntryL,G2H8(79),ex5(:),G2H4(506),m3h2x4(:,652),heltab2x8(:,:,652))
  call Hloop_QV_A(ntryL,G1H8(270),ex4(:),G1H4(565),m3h2x4(:,653),heltab2x8(:,:,653))
  call Hloop_Q_A(ntryL,G1H4(565),43,0,G2H4(507),n2h4(558))
  call Hloop_QV_A(ntryL,G1H8(287),ex4(:),G1H4(570),m3h2x4(:,654),heltab2x8(:,:,654))
  call Hloop_Q_A(ntryL,G1H4(570),43,0,G2H4(508),n2h4(559))
  call Hloop_QV_A(ntryL,G1H8(288),ex4(:),G1H4(571),m3h2x4(:,655),heltab2x8(:,:,655))
  call Hloop_Q_A(ntryL,G1H4(571),43,0,G2H4(509),n2h4(560))
  call Hloop_QV_A(ntryL,G1H8(305),ex4(:),G1H4(576),m3h2x4(:,656),heltab2x8(:,:,656))
  call Hloop_Q_A(ntryL,G1H4(576),43,0,G2H4(510),n2h4(561))
call HGT_OLR(G1H8(306),1,1,8)
call HGT_invQ_OLR(G1H8(306),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(306),-4,0,G2H8(72),n2h8(332))
  call Hloop_AV_Q(ntryL,G2H8(72),ex3(:),G2H4(511),m3h2x4(:,657),heltab2x8(:,:,657))
  call Hloop_QV_A(ntryL,G1H8(324),ex4(:),G1H4(577),m3h2x4(:,658),heltab2x8(:,:,658))
  call Hloop_Q_A(ntryL,G1H4(577),43,0,G2H4(512),n2h4(562))
  call Hloop_QV_A(ntryL,G1H8(341),ex4(:),G1H4(581),m3h2x4(:,659),heltab2x8(:,:,659))
  call Hloop_Q_A(ntryL,G1H4(581),43,0,G2H4(513),n2h4(563))
  call Hloop_QV_A(ntryL,G1H8(342),ex4(:),G1H4(582),m3h2x4(:,660),heltab2x8(:,:,660))
  call Hloop_Q_A(ntryL,G1H4(582),43,0,G2H4(514),n2h4(564))
  call Hloop_QV_A(ntryL,G1H8(359),ex5(:),G1H4(587),m3h2x4(:,661),heltab2x8(:,:,661))
  call Hloop_Q_A(ntryL,G1H4(587),51,0,G2H4(515),n2h4(565))
call HGT_OLR(G1H8(360),1,1,8)
call HGT_invQ_OLR(G1H8(360),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(360),-8,0,G2H8(92),n2h8(333))
  call Hloop_AV_Q(ntryL,G2H8(92),ex4(:),G2H4(516),m3h2x4(:,662),heltab2x8(:,:,662))
  call Hloop_QV_A(ntryL,G1H8(378),ex5(:),G1H4(588),m3h2x4(:,663),heltab2x8(:,:,663))
  call Hloop_Q_A(ntryL,G1H4(588),51,0,G2H4(517),n2h4(566))
  call Hloop_QV_A(ntryL,G1H8(395),ex5(:),G1H4(593),m3h2x4(:,664),heltab2x8(:,:,664))
  call Hloop_Q_A(ntryL,G1H4(593),51,0,G2H4(518),n2h4(567))
  call Hloop_QV_A(ntryL,G1H8(396),ex5(:),G1H4(594),m3h2x4(:,665),heltab2x8(:,:,665))
  call Hloop_Q_A(ntryL,G1H4(594),51,0,G2H4(519),n2h4(568))
  call Hloop_QV_A(ntryL,G1H8(413),ex5(:),G1H4(598),m3h2x4(:,666),heltab2x8(:,:,666))
  call Hloop_Q_A(ntryL,G1H4(598),51,0,G2H4(520),n2h4(569))
call HGT_OLR(G1H8(414),1,1,8)
call HGT_invQ_OLR(G1H8(414),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(414),-4,0,G2H8(82),n2h8(334))
  call Hloop_AV_Q(ntryL,G2H8(82),ex3(:),G2H4(521),m3h2x4(:,667),heltab2x8(:,:,667))
  call Hloop_QV_A(ntryL,G1H8(432),ex5(:),G1H4(599),m3h2x4(:,668),heltab2x8(:,:,668))
  call Hloop_Q_A(ntryL,G1H4(599),51,0,G2H4(522),n2h4(570))
  call Hloop_QV_A(ntryL,G1H8(449),ex5(:),G1H4(604),m3h2x4(:,669),heltab2x8(:,:,669))
  call Hloop_Q_A(ntryL,G1H4(604),51,0,G2H4(523),n2h4(571))
  call Hloop_QV_A(ntryL,G1H8(450),ex5(:),G1H4(605),m3h2x4(:,670),heltab2x8(:,:,670))
  call Hloop_Q_A(ntryL,G1H4(605),51,0,G2H4(524),n2h4(572))
  call Hloop_AV_Q(ntryL,G1H8(467),ex3(:),G1H4(610),m3h2x4(:,671),heltab2x8(:,:,671))
  call Hloop_A_Q(ntryL,G1H4(610),39,0,G2H4(525),n2h4(573))
call HGT_OLR(G1H8(468),1,1,8)
call HGT_invQ_OLR(G1H8(468),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(468),-16,0,G2H8(50),n2h8(335))
  call Hloop_QV_A(ntryL,G2H8(50),ex5(:),G2H4(526),m3h2x4(:,672),heltab2x8(:,:,672))
  call Hloop_AV_Q(ntryL,G1H8(486),ex3(:),G1H4(611),m3h2x4(:,673),heltab2x8(:,:,673))
  call Hloop_A_Q(ntryL,G1H4(611),39,0,G2H4(527),n2h4(574))
  call Hloop_AV_Q(ntryL,G1H8(7),ex3(:),G1H4(615),m3h2x4(:,674),heltab2x8(:,:,674))
  call Hloop_A_Q(ntryL,G1H4(615),39,0,G2H4(528),n2h4(575))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(616),m3h2x4(:,675),heltab2x8(:,:,675))
  call Hloop_A_Q(ntryL,G1H4(616),39,0,G2H4(529),n2h4(576))
  call Hloop_AV_Q(ntryL,G1H8(11),ex3(:),G1H4(621),m3h2x4(:,676),heltab2x8(:,:,676))
  call Hloop_A_Q(ntryL,G1H4(621),39,0,G2H4(530),n2h4(577))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(12),-8,0,G2H8(87),n2h8(336))
  call Hloop_QV_A(ntryL,G2H8(87),ex4(:),G2H4(531),m3h2x4(:,677),heltab2x8(:,:,677))
  call Hloop_AV_Q(ntryL,G1H8(14),ex3(:),G1H4(622),m3h2x4(:,678),heltab2x8(:,:,678))
  call Hloop_A_Q(ntryL,G1H4(622),39,0,G2H4(532),n2h4(578))
  call Hloop_AV_Q(ntryL,G1H8(17),ex3(:),G1H4(627),m3h2x4(:,679),heltab2x8(:,:,679))
  call Hloop_A_Q(ntryL,G1H4(627),39,0,G2H4(533),n2h4(579))
  call Hloop_AV_Q(ntryL,G1H8(18),ex3(:),G1H4(628),m3h2x4(:,680),heltab2x8(:,:,680))
  call Hloop_A_Q(ntryL,G1H4(628),39,0,G2H4(534),n2h4(580))
  call Hloop_AV_Q(ntryL,G1H8(19),ex4(:),G1H4(632),m3h2x4(:,681),heltab2x8(:,:,681))
  call Hloop_A_Q(ntryL,G1H4(632),43,0,G2H4(535),n2h4(581))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,0,G2H8(80),n2h8(337))
  call Hloop_QV_A(ntryL,G2H8(80),ex5(:),G2H4(536),m3h2x4(:,682),heltab2x8(:,:,682))
  call Hloop_AV_Q(ntryL,G1H8(24),ex4(:),G1H4(633),m3h2x4(:,683),heltab2x8(:,:,683))
  call Hloop_A_Q(ntryL,G1H4(633),43,0,G2H4(537),n2h4(582))
  call Hloop_AV_Q(ntryL,G1H8(25),ex4(:),G1H4(638),m3h2x4(:,684),heltab2x8(:,:,684))
  call Hloop_A_Q(ntryL,G1H4(638),43,0,G2H4(538),n2h4(583))
  call Hloop_AV_Q(ntryL,G1H8(26),ex4(:),G1H4(639),m3h2x4(:,685),heltab2x8(:,:,685))
  call Hloop_A_Q(ntryL,G1H4(639),43,0,G2H4(539),n2h4(584))
  call Hloop_AV_Q(ntryL,G1H8(29),ex4(:),G1H4(644),m3h2x4(:,686),heltab2x8(:,:,686))
  call Hloop_A_Q(ntryL,G1H4(644),43,0,G2H4(540),n2h4(585))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(30),-4,0,G2H8(97),n2h8(338))
  call Hloop_QV_A(ntryL,G2H8(97),ex3(:),G2H4(541),m3h2x4(:,687),heltab2x8(:,:,687))
  call Hloop_AV_Q(ntryL,G1H8(32),ex4(:),G1H4(645),m3h2x4(:,688),heltab2x8(:,:,688))
  call Hloop_A_Q(ntryL,G1H4(645),43,0,G2H4(542),n2h4(586))
  call Hloop_AV_Q(ntryL,G1H8(35),ex4(:),G1H4(24),m3h2x4(:,689),heltab2x8(:,:,689))
  call Hloop_A_Q(ntryL,G1H4(24),43,0,G2H4(543),n2h4(587))
  call Hloop_AV_Q(ntryL,G1H8(36),ex4(:),G1H4(36),m3h2x4(:,690),heltab2x8(:,:,690))
  call Hloop_A_Q(ntryL,G1H4(36),43,0,G2H4(544),n2h4(588))
  call Hloop_AV_Q(ntryL,G1H8(37),ex5(:),G1H4(48),m3h2x4(:,691),heltab2x8(:,:,691))
  call Hloop_A_Q(ntryL,G1H4(48),51,0,G2H4(545),n2h4(589))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-8,0,G2H8(45),n2h8(339))
  call Hloop_QV_A(ntryL,G2H8(45),ex4(:),G2H4(546),m3h2x4(:,692),heltab2x8(:,:,692))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(60),m3h2x4(:,693),heltab2x8(:,:,693))
  call Hloop_A_Q(ntryL,G1H4(60),51,0,G2H4(547),n2h4(590))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(72),m3h2x4(:,694),heltab2x8(:,:,694))
  call Hloop_A_Q(ntryL,G1H4(72),51,0,G2H4(548),n2h4(591))
  call Hloop_AV_Q(ntryL,G1H8(44),ex5(:),G1H4(84),m3h2x4(:,695),heltab2x8(:,:,695))
  call Hloop_A_Q(ntryL,G1H4(84),51,0,G2H4(549),n2h4(592))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(96),m3h2x4(:,696),heltab2x8(:,:,696))
  call Hloop_A_Q(ntryL,G1H4(96),51,0,G2H4(550),n2h4(593))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-4,0,G2H8(102),n2h8(340))
  call Hloop_QV_A(ntryL,G2H8(102),ex3(:),G2H4(551),m3h2x4(:,697),heltab2x8(:,:,697))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(108),m3h2x4(:,698),heltab2x8(:,:,698))
  call Hloop_A_Q(ntryL,G1H4(108),51,0,G2H4(552),n2h4(594))
  call Hloop_AV_Q(ntryL,G1H8(53),ex5(:),G1H4(120),m3h2x4(:,699),heltab2x8(:,:,699))
  call Hloop_A_Q(ntryL,G1H4(120),51,0,G2H4(553),n2h4(595))
  call Hloop_AV_Q(ntryL,G1H8(54),ex5(:),G1H4(132),m3h2x4(:,700),heltab2x8(:,:,700))
  call Hloop_A_Q(ntryL,G1H4(132),51,0,G2H4(554),n2h4(596))
  call Hloop_AV_Q(ntryL,G1H8(55),ex3(:),G1H4(144),m3h2x4(:,701),heltab2x8(:,:,701))
  call Hloop_A_Q(ntryL,G1H4(144),54,0,G2H4(555),n2h4(597))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(56),-8,ex4(:),8,G2H4(556),m3h2x4(:,702),heltab2x8(:,:,702))
call signflip_OLR(G2H4(556))
  call Hloop_AV_Q(ntryL,G1H8(60),ex3(:),G1H4(156),m3h2x4(:,703),heltab2x8(:,:,703))
  call Hloop_A_Q(ntryL,G1H4(156),54,0,G2H4(557),n2h4(598))
  call Hloop_AV_Q(ntryL,G1H8(62),ex3(:),G1H4(168),m3h2x4(:,704),heltab2x8(:,:,704))
  call Hloop_A_Q(ntryL,G1H4(168),54,0,G2H4(558),n2h4(599))
  call Hloop_AV_Q(ntryL,G1H8(66),ex3(:),G1H4(180),m3h2x4(:,705),heltab2x8(:,:,705))
  call Hloop_A_Q(ntryL,G1H4(180),54,0,G2H4(559),n2h4(600))
  call Hloop_AV_Q(ntryL,G1H8(68),ex3(:),G1H4(192),m3h2x4(:,706),heltab2x8(:,:,706))
  call Hloop_A_Q(ntryL,G1H4(192),46,0,G2H4(560),n2h4(601))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(72),-16,ex5(:),16,G2H4(561),m3h2x4(:,707),heltab2x8(:,:,707))
call signflip_OLR(G2H4(561))
  call Hloop_AV_Q(ntryL,G1H8(78),ex3(:),G1H4(204),m3h2x4(:,708),heltab2x8(:,:,708))
  call Hloop_A_Q(ntryL,G1H4(204),46,0,G2H4(562),n2h4(602))
  call Hloop_AV_Q(ntryL,G1H8(80),ex3(:),G1H4(216),m3h2x4(:,709),heltab2x8(:,:,709))
  call Hloop_A_Q(ntryL,G1H4(216),46,0,G2H4(563),n2h4(603))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(228),m3h2x4(:,710),heltab2x8(:,:,710))
  call Hloop_A_Q(ntryL,G1H4(228),46,0,G2H4(564),n2h4(604))
  call Hloop_QV_A(ntryL,G1H8(85),ex4(:),G1H4(240),m3h2x4(:,711),heltab2x8(:,:,711))
  call Hloop_Q_A(ntryL,G1H4(240),45,0,G2H4(565),n2h4(605))
call HGT_raise_alpha_OLR(G1H8(89),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(89),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(89),-16,ex5(:),16,G2H4(566),m3h2x4(:,712),heltab2x8(:,:,712))
call signflip_OLR(G2H4(566))
  call Hloop_QV_A(ntryL,G1H8(125),ex4(:),G1H4(252),m3h2x4(:,713),heltab2x8(:,:,713))
  call Hloop_Q_A(ntryL,G1H4(252),45,0,G2H4(567),n2h4(606))
  call Hloop_QV_A(ntryL,G1H8(394),ex4(:),G1H4(264),m3h2x4(:,714),heltab2x8(:,:,714))
  call Hloop_Q_A(ntryL,G1H4(264),45,0,G2H4(568),n2h4(607))
  call Hloop_QV_A(ntryL,G1H8(214),ex4(:),G1H4(276),m3h2x4(:,715),heltab2x8(:,:,715))
  call Hloop_Q_A(ntryL,G1H4(276),45,0,G2H4(569),n2h4(608))
  call Hloop_QV_A(ntryL,G1H8(232),ex5(:),G1H4(288),m3h2x4(:,716),heltab2x8(:,:,716))
  call Hloop_Q_A(ntryL,G1H4(288),53,0,G2H4(570),n2h4(609))
call HGT_raise_alpha_OLR(G1H8(268),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(268),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(268),-8,ex4(:),8,G2H4(571),m3h2x4(:,717),heltab2x8(:,:,717))
call signflip_OLR(G2H4(571))
  call Hloop_QV_A(ntryL,G1H8(249),ex5(:),G1H4(300),m3h2x4(:,718),heltab2x8(:,:,718))
  call Hloop_Q_A(ntryL,G1H4(300),53,0,G2H4(572),n2h4(610))
  call Hloop_QV_A(ntryL,G1H8(213),ex5(:),G1H4(312),m3h2x4(:,719),heltab2x8(:,:,719))
  call Hloop_Q_A(ntryL,G1H4(312),53,0,G2H4(573),n2h4(611))
  call Hloop_QV_A(ntryL,G1H8(286),ex5(:),G1H4(324),m3h2x4(:,720),heltab2x8(:,:,720))
  call Hloop_Q_A(ntryL,G1H4(324),53,0,G2H4(574),n2h4(612))
  call Hloop_QV_A(ntryL,G1H8(304),ex5(:),G1H4(336),m3h2x4(:,721),heltab2x8(:,:,721))
  call Hloop_Q_A(ntryL,G1H4(336),53,0,G2H4(575),n2h4(613))
call HGT_raise_alpha_OLR(G1H8(33),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(33),ex2(:),G1H4(348),m3h2x4(:,722),heltab2x8(:,:,722))
  call Hloop_QV_A(ntryL,G1H8(322),ex5(:),G1H4(360),m3h2x4(:,723),heltab2x8(:,:,723))
  call Hloop_Q_A(ntryL,G1H4(360),53,0,G2H4(576),n2h4(614))
  call Hloop_QV_A(ntryL,G1H8(27),ex5(:),G1H4(372),m3h2x4(:,724),heltab2x8(:,:,724))
  call Hloop_Q_A(ntryL,G1H4(372),53,0,G2H4(577),n2h4(615))
  call Hloop_QV_A(ntryL,G1H8(103),ex5(:),G1H4(384),m3h2x4(:,725),heltab2x8(:,:,725))
  call Hloop_Q_A(ntryL,G1H4(384),53,0,G2H4(578),n2h4(616))
  call Hloop_QV_A(ntryL,G1H8(340),ex4(:),G1H4(396),m3h2x4(:,726),heltab2x8(:,:,726))
  call Hloop_Q_A(ntryL,G1H4(396),45,0,G2H4(579),n2h4(617))
call HGT_raise_alpha_OLR(G1H8(358),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(358),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(358),ex2(:),G1H4(408),m3h2x4(:,727),heltab2x8(:,:,727))
  call Hloop_QV_A(ntryL,G1H8(57),ex4(:),G1H4(420),m3h2x4(:,728),heltab2x8(:,:,728))
  call Hloop_Q_A(ntryL,G1H4(420),45,0,G2H4(580),n2h4(618))
  call Hloop_QV_A(ntryL,G1H8(108),ex4(:),G1H4(432),m3h2x4(:,729),heltab2x8(:,:,729))
  call Hloop_Q_A(ntryL,G1H4(432),45,0,G2H4(581),n2h4(619))
  call Hloop_QV_A(ntryL,G1H8(412),ex4(:),G1H4(444),m3h2x4(:,730),heltab2x8(:,:,730))
  call Hloop_Q_A(ntryL,G1H4(444),45,0,G2H4(582),n2h4(620))
  call Hloop_AV_Q(ntryL,G1H8(51),ex4(:),G1H4(456),m3h2x4(:,731),heltab2x8(:,:,731))
  call Hloop_A_Q(ntryL,G1H4(456),46,0,G2H4(583),n2h4(621))
call HGT_raise_alpha_OLR(G1H8(107),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(107),-16,ex5(:),16,G2H4(584),m3h2x4(:,732),heltab2x8(:,:,732))
call signflip_OLR(G2H4(584))
  call Hloop_AV_Q(ntryL,G1H8(448),ex4(:),G1H4(468),m3h2x4(:,733),heltab2x8(:,:,733))
  call Hloop_A_Q(ntryL,G1H4(468),46,0,G2H4(585),n2h4(622))
  call Hloop_AV_Q(ntryL,G1H8(75),ex4(:),G1H4(480),m3h2x4(:,734),heltab2x8(:,:,734))
  call Hloop_A_Q(ntryL,G1H4(480),46,0,G2H4(586),n2h4(623))
  call Hloop_AV_Q(ntryL,G1H8(110),ex4(:),G1H4(492),m3h2x4(:,735),heltab2x8(:,:,735))
  call Hloop_A_Q(ntryL,G1H4(492),46,0,G2H4(587),n2h4(624))
  call Hloop_AV_Q(ntryL,G1H8(466),ex5(:),G1H4(504),m3h2x4(:,736),heltab2x8(:,:,736))
  call Hloop_A_Q(ntryL,G1H4(504),54,0,G2H4(588),n2h4(625))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(69),-8,ex4(:),8,G2H4(589),m3h2x4(:,737),heltab2x8(:,:,737))
call signflip_OLR(G2H4(589))
  call Hloop_AV_Q(ntryL,G1H8(484),ex5(:),G1H4(516),m3h2x4(:,738),heltab2x8(:,:,738))
  call Hloop_A_Q(ntryL,G1H4(516),54,0,G2H4(590),n2h4(626))
  call Hloop_AV_Q(ntryL,G1H8(9),ex5(:),G1H4(528),m3h2x4(:,739),heltab2x8(:,:,739))
  call Hloop_A_Q(ntryL,G1H4(528),54,0,G2H4(591),n2h4(627))
  call Hloop_AV_Q(ntryL,G1H8(124),ex5(:),G1H4(540),m3h2x4(:,740),heltab2x8(:,:,740))
  call Hloop_A_Q(ntryL,G1H4(540),54,0,G2H4(592),n2h4(628))
  call Hloop_QV_A(ntryL,G1H8(10),ex3(:),G1H4(552),m3h2x4(:,741),heltab2x8(:,:,741))
  call Hloop_Q_A(ntryL,G1H4(552),45,0,G2H4(593),n2h4(629))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(16),-16,ex5(:),16,G2H4(594),m3h2x4(:,742),heltab2x8(:,:,742))
call signflip_OLR(G2H4(594))
  call Hloop_QV_A(ntryL,G1H8(28),ex3(:),G1H4(558),m3h2x4(:,743),heltab2x8(:,:,743))
  call Hloop_Q_A(ntryL,G1H4(558),45,0,G2H4(595),n2h4(630))
  call Hloop_QV_A(ntryL,G1H8(34),ex3(:),G1H4(569),m3h2x4(:,744),heltab2x8(:,:,744))
  call Hloop_Q_A(ntryL,G1H4(569),45,0,G2H4(596),n2h4(631))
  call Hloop_QV_A(ntryL,G1H8(39),ex3(:),G1H4(575),m3h2x4(:,745),heltab2x8(:,:,745))
  call Hloop_Q_A(ntryL,G1H4(575),45,0,G2H4(597),n2h4(632))
  call Hloop_QV_A(ntryL,G1H8(178),ex5(:),G1H4(586),m3h2x4(:,746),heltab2x8(:,:,746))
  call Hloop_Q_A(ntryL,G1H4(586),57,0,G2H4(598),n2h4(633))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(40),ex2(:),G1H4(592),m3h2x4(:,747),heltab2x8(:,:,747))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(603),m3h2x4(:,748),heltab2x8(:,:,748))
  call Hloop_Q_A(ntryL,G1H4(603),57,0,G2H4(599),n2h4(634))
  call Hloop_QV_A(ntryL,G1H8(58),ex5(:),G1H4(609),m3h2x4(:,749),heltab2x8(:,:,749))
  call Hloop_Q_A(ntryL,G1H4(609),57,0,G2H4(600),n2h4(635))
  call Hloop_QV_A(ntryL,G1H8(64),ex5(:),G1H4(620),m3h2x4(:,750),heltab2x8(:,:,750))
  call Hloop_Q_A(ntryL,G1H4(620),57,0,G2H4(601),n2h4(636))
  call Hloop_QV_A(ntryL,G1H8(70),ex3(:),G1H4(626),m3h2x4(:,751),heltab2x8(:,:,751))
  call Hloop_Q_A(ntryL,G1H4(626),45,0,G2H4(602),n2h4(637))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(76),ex2(:),G1H4(637),m3h2x4(:,752),heltab2x8(:,:,752))
  call Hloop_QV_A(ntryL,G1H8(82),ex3(:),G1H4(643),m3h2x4(:,753),heltab2x8(:,:,753))
  call Hloop_Q_A(ntryL,G1H4(643),45,0,G2H4(603),n2h4(638))
  call Hloop_QV_A(ntryL,G1H8(87),ex3(:),G1H4(19),m3h2x4(:,754),heltab2x8(:,:,754))
  call Hloop_Q_A(ntryL,G1H4(19),45,0,G2H4(604),n2h4(639))
  call Hloop_QV_A(ntryL,G1H8(88),ex3(:),G1H4(20),m3h2x4(:,755),heltab2x8(:,:,755))
  call Hloop_Q_A(ntryL,G1H4(20),45,0,G2H4(605),n2h4(640))
  call Hloop_QV_A(ntryL,G1H8(93),ex3(:),G1H4(25),m3h2x4(:,756),heltab2x8(:,:,756))
  call Hloop_Q_A(ntryL,G1H4(25),53,0,G2H4(606),n2h4(641))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(94),-8,ex4(:),8,G2H4(607),m3h2x4(:,757),heltab2x8(:,:,757))
call signflip_OLR(G2H4(607))
  call Hloop_QV_A(ntryL,G1H8(100),ex3(:),G1H4(26),m3h2x4(:,758),heltab2x8(:,:,758))
  call Hloop_Q_A(ntryL,G1H4(26),53,0,G2H4(608),n2h4(642))
  call Hloop_QV_A(ntryL,G1H8(105),ex3(:),G1H4(30),m3h2x4(:,759),heltab2x8(:,:,759))
  call Hloop_Q_A(ntryL,G1H4(30),53,0,G2H4(609),n2h4(643))
  call Hloop_QV_A(ntryL,G1H8(106),ex3(:),G1H4(31),m3h2x4(:,760),heltab2x8(:,:,760))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(610),n2h4(644))
  call Hloop_QV_A(ntryL,G1H8(111),ex4(:),G1H4(32),m3h2x4(:,761),heltab2x8(:,:,761))
  call Hloop_Q_A(ntryL,G1H4(32),57,0,G2H4(611),n2h4(645))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(112),ex2(:),G1H4(37),m3h2x4(:,762),heltab2x8(:,:,762))
  call Hloop_QV_A(ntryL,G1H8(123),ex4(:),G1H4(38),m3h2x4(:,763),heltab2x8(:,:,763))
  call Hloop_Q_A(ntryL,G1H4(38),57,0,G2H4(612),n2h4(646))
  call Hloop_QV_A(ntryL,G1H8(136),ex4(:),G1H4(42),m3h2x4(:,764),heltab2x8(:,:,764))
  call Hloop_Q_A(ntryL,G1H4(42),57,0,G2H4(613),n2h4(647))
  call Hloop_QV_A(ntryL,G1H8(154),ex4(:),G1H4(43),m3h2x4(:,765),heltab2x8(:,:,765))
  call Hloop_Q_A(ntryL,G1H4(43),57,0,G2H4(614),n2h4(648))
  call Hloop_QV_A(ntryL,G1H8(160),ex3(:),G1H4(44),m3h2x4(:,766),heltab2x8(:,:,766))
  call Hloop_Q_A(ntryL,G1H4(44),53,0,G2H4(615),n2h4(649))
call HGT_raise_alpha_OLR(G1H8(177),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(177),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(177),ex2(:),G1H4(49),m3h2x4(:,767),heltab2x8(:,:,767))
  call Hloop_QV_A(ntryL,G1H8(226),ex3(:),G1H4(50),m3h2x4(:,768),heltab2x8(:,:,768))
  call Hloop_Q_A(ntryL,G1H4(50),53,0,G2H4(616),n2h4(650))
  call Hloop_QV_A(ntryL,G1H8(231),ex3(:),G1H4(54),m3h2x4(:,769),heltab2x8(:,:,769))
  call Hloop_Q_A(ntryL,G1H4(54),53,0,G2H4(617),n2h4(651))
  call Hloop_QV_A(ntryL,G1H8(256),ex3(:),G1H4(55),m3h2x4(:,770),heltab2x8(:,:,770))
  call Hloop_Q_A(ntryL,G1H4(55),53,0,G2H4(618),n2h4(652))
  call Hloop_QV_A(ntryL,G1H16(26),ex3(:),G1H8(515),m3h2x8(:,253),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G1H8(515),37,0,G2H8(83),n2h8(355))
call HGT_raise_alpha_OLR(G1H16(133),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(133),2,5,16)
  call Hloop_GGG_G_12(ntryL,G1H16(133),ex4(:),ex5(:),G1H4(56),m4h2x2x4(:,7),heltab3x16(:,:,7))
  call Hloop_QV_A(ntryL,G1H16(144),ex3(:),G1H8(114),m3h2x8(:,254),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G1H8(114),37,0,G2H8(107),n2h8(356))
  call Hloop_QV_A(ntryL,G1H16(148),ex3(:),G1H8(116),m3h2x8(:,255),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G1H8(116),37,0,G2H8(85),n2h8(357))
  call Hloop_QV_A(ntryL,G1H16(153),ex3(:),G1H8(119),m3h2x8(:,256),heltab2x16(:,:,280))
  call Hloop_Q_A(ntryL,G1H8(119),37,0,G2H8(112),n2h8(358))
  call Hloop_QV_A(ntryL,G1H16(55),ex3(:),G1H8(120),m3h2x8(:,257),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(120),37,0,G2H8(125),n2h8(359))
call HGT_raise_alpha_OLR(G1H16(5),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_GGG_G_12(ntryL,G1H16(5),ex5(:),ex4(:),G1H4(61),m4h2x2x4(:,8),heltab3x16(:,:,8))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(122),m3h2x8(:,258),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G1H8(122),37,0,G2H8(130),n2h8(360))
  call Hloop_QV_A(ntryL,G1H16(44),ex3(:),G1H8(126),m3h2x8(:,259),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H8(126),37,0,G2H8(84),n2h8(361))
  call Hloop_QV_A(ntryL,G1H16(46),ex3(:),G1H8(127),m3h2x8(:,260),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G1H8(127),37,0,G2H8(88),n2h8(362))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(128),m3h2x8(:,261),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H8(128),37,0,G2H8(36),n2h8(363))
call HGT_raise_alpha_OLR(G1H16(11),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(11),2,5,16)
  call Hloop_GGG_G_23(ntryL,G1H16(11),ex4(:),ex5(:),G1H4(62),m4h2x2x4(:,9),heltab3x16(:,:,9))
  call Hloop_QV_A(ntryL,G1H16(58),ex3(:),G1H8(131),m3h2x8(:,262),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H8(131),37,0,G2H8(42),n2h8(364))
  call Hloop_QV_A(ntryL,G1H16(59),ex3(:),G1H8(132),m3h2x8(:,263),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G1H8(132),37,0,G2H8(41),n2h8(365))
  call Hloop_QV_A(ntryL,G1H16(60),ex3(:),G1H8(133),m3h2x8(:,264),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H8(133),37,0,G2H8(46),n2h8(366))
  call Hloop_AV_Q(ntryL,G1H16(66),ex3(:),G1H8(134),m3h2x8(:,265),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G1H8(134),38,0,G2H8(47),n2h8(367))
call HGT_raise_alpha_OLR(G1H16(68),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_GGG_G_12(ntryL,G1H16(68),ex4(:),ex5(:),G1H4(66),m4h2x2x4(:,10),heltab3x16(:,:,10))
  call Hloop_AV_Q(ntryL,G1H16(70),ex3(:),G1H8(138),m3h2x8(:,266),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G1H8(138),38,0,G2H8(51),n2h8(368))
  call Hloop_AV_Q(ntryL,G1H16(71),ex3(:),G1H8(139),m3h2x8(:,267),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H8(139),38,0,G2H8(57),n2h8(369))
  call Hloop_AV_Q(ntryL,G1H16(72),ex3(:),G1H8(140),m3h2x8(:,268),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H8(140),38,0,G2H8(56),n2h8(370))
  call Hloop_AV_Q(ntryL,G1H16(74),ex3(:),G1H8(143),m3h2x8(:,269),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(61),n2h8(371))
call HGT_raise_alpha_OLR(G1H16(75),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(75),2,5,16)
  call Hloop_GGG_G_12(ntryL,G1H16(75),ex5(:),ex4(:),G1H4(67),m4h2x2x4(:,11),heltab3x16(:,:,11))
  call Hloop_AV_Q(ntryL,G1H16(77),ex3(:),G1H8(144),m3h2x8(:,270),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G1H8(144),38,0,G2H8(62),n2h8(372))
  call Hloop_AV_Q(ntryL,G1H16(78),ex3(:),G1H8(146),m3h2x8(:,271),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H8(146),38,0,G2H8(66),n2h8(373))
  call Hloop_AV_Q(ntryL,G1H16(80),ex3(:),G1H8(149),m3h2x8(:,272),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H8(149),38,0,G2H8(157),n2h8(374))
  call Hloop_AV_Q(ntryL,G1H16(81),ex3(:),G1H8(150),m3h2x8(:,273),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G1H8(150),38,0,G2H8(71),n2h8(375))
call HGT_raise_alpha_OLR(G1H16(82),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_GGG_G_23(ntryL,G1H16(82),ex4(:),ex5(:),G1H4(68),m4h2x2x4(:,12),heltab3x16(:,:,12))
  call Hloop_AV_Q(ntryL,G1H16(16),ex3(:),G1H8(151),m3h2x8(:,274),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H8(151),38,0,G2H8(154),n2h8(376))
  call Hloop_AV_Q(ntryL,G1H16(84),ex3(:),G1H8(152),m3h2x8(:,275),heltab2x16(:,:,299))
  call Hloop_A_Q(ntryL,G1H8(152),38,0,G2H8(76),n2h8(377))
  call Hloop_AV_Q(ntryL,G1H16(85),ex3(:),G1H8(156),m3h2x8(:,276),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H8(156),38,0,G2H8(77),n2h8(378))
  call Hloop_AV_Q(ntryL,G1H8(262),ex5(:),G1H4(73),m3h2x4(:,771),heltab2x8(:,:,771))
  call Hloop_A_Q(ntryL,G1H4(73),51,nMT,G2H4(619),n2h4(653))
call HGT_OLR(G1H8(267),1,1,8)
call HGT_invQ_OLR(G1H8(267),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(267),-8,nMT,G2H8(81),n2h8(379))
  call Hloop_QV_A(ntryL,G2H8(81),ex4(:),G2H4(620),m3h2x4(:,772),heltab2x8(:,:,772))
  call Hloop_AV_Q(ntryL,G1H8(303),ex5(:),G1H4(74),m3h2x4(:,773),heltab2x8(:,:,773))
  call Hloop_A_Q(ntryL,G1H4(74),51,nMT,G2H4(621),n2h4(654))
  call Hloop_AV_Q(ntryL,G1H8(321),ex5(:),G1H4(78),m3h2x4(:,774),heltab2x8(:,:,774))
  call Hloop_A_Q(ntryL,G1H4(78),51,nMT,G2H4(622),n2h4(655))
  call Hloop_AV_Q(ntryL,G1H8(339),ex5(:),G1H4(79),m3h2x4(:,775),heltab2x8(:,:,775))
  call Hloop_A_Q(ntryL,G1H4(79),51,nMT,G2H4(623),n2h4(656))
  call Hloop_QV_A(ntryL,G1H8(357),ex5(:),G1H4(80),m3h2x4(:,776),heltab2x8(:,:,776))
  call Hloop_Q_A(ntryL,G1H4(80),51,nMT,G2H4(624),n2h4(657))
call HGT_OLR(G1H8(375),1,1,8)
call HGT_invQ_OLR(G1H8(375),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(375),-8,nMT,G2H8(158),n2h8(380))
  call Hloop_AV_Q(ntryL,G2H8(158),ex4(:),G2H4(625),m3h2x4(:,777),heltab2x8(:,:,777))
  call Hloop_QV_A(ntryL,G1H8(411),ex5(:),G1H4(85),m3h2x4(:,778),heltab2x8(:,:,778))
  call Hloop_Q_A(ntryL,G1H4(85),51,nMT,G2H4(626),n2h4(658))
  call Hloop_QV_A(ntryL,G1H8(429),ex5(:),G1H4(86),m3h2x4(:,779),heltab2x8(:,:,779))
  call Hloop_Q_A(ntryL,G1H4(86),51,nMT,G2H4(627),n2h4(659))
  call Hloop_QV_A(ntryL,G1H8(447),ex5(:),G1H4(90),m3h2x4(:,780),heltab2x8(:,:,780))
  call Hloop_Q_A(ntryL,G1H4(90),51,nMT,G2H4(628),n2h4(660))
  call Hloop_AV_Q(ntryL,G1H8(465),ex5(:),G1H4(91),m3h2x4(:,781),heltab2x8(:,:,781))
  call Hloop_A_Q(ntryL,G1H4(91),51,nMB,G2H4(629),n2h4(661))
call HGT_OLR(G1H8(483),1,1,8)
call HGT_invQ_OLR(G1H8(483),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(483),-8,nMB,G2H8(86),n2h8(381))
  call Hloop_QV_A(ntryL,G2H8(86),ex4(:),G2H4(630),m3h2x4(:,782),heltab2x8(:,:,782))
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(92),m3h2x4(:,783),heltab2x8(:,:,783))
  call Hloop_A_Q(ntryL,G1H4(92),51,nMB,G2H4(631),n2h4(662))
  call Hloop_AV_Q(ntryL,G1H8(3),ex5(:),G1H4(97),m3h2x4(:,784),heltab2x8(:,:,784))
  call Hloop_A_Q(ntryL,G1H4(97),51,nMB,G2H4(632),n2h4(663))
  call Hloop_AV_Q(ntryL,G1H8(4),ex5(:),G1H4(98),m3h2x4(:,785),heltab2x8(:,:,785))
  call Hloop_A_Q(ntryL,G1H4(98),51,nMB,G2H4(633),n2h4(664))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(102),m3h2x4(:,786),heltab2x8(:,:,786))
  call Hloop_Q_A(ntryL,G1H4(102),51,nMB,G2H4(634),n2h4(665))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(6),-8,nMB,G2H8(155),n2h8(382))
  call Hloop_AV_Q(ntryL,G2H8(155),ex4(:),G2H4(635),m3h2x4(:,787),heltab2x8(:,:,787))
  call Hloop_QV_A(ntryL,G1H8(90),ex5(:),G1H4(103),m3h2x4(:,788),heltab2x8(:,:,788))
  call Hloop_Q_A(ntryL,G1H4(103),51,nMB,G2H4(636),n2h4(666))
  call Hloop_QV_A(ntryL,G1H8(15),ex5(:),G1H4(104),m3h2x4(:,789),heltab2x8(:,:,789))
  call Hloop_Q_A(ntryL,G1H4(104),51,nMB,G2H4(637),n2h4(667))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(109),m3h2x4(:,790),heltab2x8(:,:,790))
  call Hloop_Q_A(ntryL,G1H4(109),51,nMB,G2H4(638),n2h4(668))
  call Hloop_QV_A(ntryL,G1H8(21),ex4(:),G1H4(110),m3h2x4(:,791),heltab2x8(:,:,791))
  call Hloop_Q_A(ntryL,G1H4(110),43,nMT,G2H4(639),n2h4(669))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(71),-16,nMT,G2H8(91),n2h8(383))
  call Hloop_AV_Q(ntryL,G2H8(91),ex5(:),G2H4(640),m3h2x4(:,792),heltab2x8(:,:,792))
  call Hloop_QV_A(ntryL,G1H8(86),ex4(:),G1H4(114),m3h2x4(:,793),heltab2x8(:,:,793))
  call Hloop_Q_A(ntryL,G1H4(114),43,nMT,G2H4(641),n2h4(670))
  call Hloop_QV_A(ntryL,G1H8(45),ex4(:),G1H4(115),m3h2x4(:,794),heltab2x8(:,:,794))
  call Hloop_Q_A(ntryL,G1H4(115),43,nMT,G2H4(642),n2h4(671))
  call Hloop_QV_A(ntryL,G1H8(79),ex4(:),G1H4(116),m3h2x4(:,795),heltab2x8(:,:,795))
  call Hloop_Q_A(ntryL,G1H4(116),43,nMT,G2H4(643),n2h4(672))
  call Hloop_AV_Q(ntryL,G1H8(63),ex4(:),G1H4(134),m3h2x4(:,796),heltab2x8(:,:,796))
  call Hloop_A_Q(ntryL,G1H4(134),43,nMT,G2H4(644),n2h4(673))
call HGT_OLR(G1H8(83),1,1,8)
call HGT_invQ_OLR(G1H8(83),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(83),-16,nMT,G2H8(96),n2h8(384))
  call Hloop_QV_A(ntryL,G2H8(96),ex5(:),G2H4(645),m3h2x4(:,797),heltab2x8(:,:,797))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(138),m3h2x4(:,798),heltab2x8(:,:,798))
  call Hloop_A_Q(ntryL,G1H4(138),43,nMT,G2H4(646),n2h4(674))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(139),m3h2x4(:,799),heltab2x8(:,:,799))
  call Hloop_A_Q(ntryL,G1H4(139),43,nMT,G2H4(647),n2h4(675))
  call Hloop_AV_Q(ntryL,G1H8(97),ex4(:),G1H4(140),m3h2x4(:,800),heltab2x8(:,:,800))
  call Hloop_A_Q(ntryL,G1H4(140),43,nMT,G2H4(648),n2h4(676))
  call Hloop_QV_A(ntryL,G1H8(98),ex4(:),G1H4(145),m3h2x4(:,801),heltab2x8(:,:,801))
  call Hloop_Q_A(ntryL,G1H4(145),43,nMB,G2H4(649),n2h4(677))
call HGT_OLR(G1H8(101),1,1,8)
call HGT_invQ_OLR(G1H8(101),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(101),-16,nMB,G2H8(149),n2h8(385))
  call Hloop_AV_Q(ntryL,G2H8(149),ex5(:),G2H4(650),m3h2x4(:,802),heltab2x8(:,:,802))
  call Hloop_QV_A(ntryL,G1H8(65),ex4(:),G1H4(146),m3h2x4(:,803),heltab2x8(:,:,803))
  call Hloop_Q_A(ntryL,G1H4(146),43,nMB,G2H4(651),n2h4(678))
  call Hloop_QV_A(ntryL,G1H8(102),ex4(:),G1H4(150),m3h2x4(:,804),heltab2x8(:,:,804))
  call Hloop_Q_A(ntryL,G1H4(150),43,nMB,G2H4(652),n2h4(679))
  call Hloop_QV_A(ntryL,G1H8(129),ex4(:),G1H4(151),m3h2x4(:,805),heltab2x8(:,:,805))
  call Hloop_Q_A(ntryL,G1H4(151),43,nMB,G2H4(653),n2h4(680))
  call Hloop_AV_Q(ntryL,G1H8(130),ex4(:),G1H4(152),m3h2x4(:,806),heltab2x8(:,:,806))
  call Hloop_A_Q(ntryL,G1H4(152),43,nMB,G2H4(654),n2h4(681))
call HGT_OLR(G1H8(135),1,1,8)
call HGT_invQ_OLR(G1H8(135),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(135),-16,nMB,G2H8(101),n2h8(386))
  call Hloop_QV_A(ntryL,G2H8(101),ex5(:),G2H4(655),m3h2x4(:,807),heltab2x8(:,:,807))
  call Hloop_AV_Q(ntryL,G1H8(141),ex4(:),G1H4(157),m3h2x4(:,808),heltab2x8(:,:,808))
  call Hloop_A_Q(ntryL,G1H4(157),43,nMB,G2H4(656),n2h4(682))
  call Hloop_AV_Q(ntryL,G1H8(142),ex4(:),G1H4(158),m3h2x4(:,809),heltab2x8(:,:,809))
  call Hloop_A_Q(ntryL,G1H4(158),43,nMB,G2H4(657),n2h4(683))
  call Hloop_AV_Q(ntryL,G1H8(147),ex4(:),G1H4(162),m3h2x4(:,810),heltab2x8(:,:,810))
  call Hloop_A_Q(ntryL,G1H4(162),43,nMB,G2H4(658),n2h4(684))
  call Hloop_QV_A(ntryL,G1H8(148),ex5(:),G1H4(163),m3h2x4(:,811),heltab2x8(:,:,811))
  call Hloop_Q_A(ntryL,G1H4(163),51,nMT,G2H4(659),n2h4(685))
call HGT_OLR(G1H8(153),1,1,8)
call HGT_invQ_OLR(G1H8(153),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(153),-4,nMT,G2H8(150),n2h8(387))
  call Hloop_AV_Q(ntryL,G2H8(150),ex3(:),G2H4(660),m3h2x4(:,812),heltab2x8(:,:,812))
  call Hloop_QV_A(ntryL,G1H8(159),ex5(:),G1H4(164),m3h2x4(:,813),heltab2x8(:,:,813))
  call Hloop_Q_A(ntryL,G1H4(164),51,nMT,G2H4(661),n2h4(686))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(169),m3h2x4(:,814),heltab2x8(:,:,814))
  call Hloop_Q_A(ntryL,G1H4(169),51,nMT,G2H4(662),n2h4(687))
  call Hloop_QV_A(ntryL,G1H8(165),ex5(:),G1H4(170),m3h2x4(:,815),heltab2x8(:,:,815))
  call Hloop_Q_A(ntryL,G1H4(170),51,nMT,G2H4(663),n2h4(688))
  call Hloop_AV_Q(ntryL,G1H8(166),ex5(:),G1H4(174),m3h2x4(:,816),heltab2x8(:,:,816))
  call Hloop_A_Q(ntryL,G1H4(174),51,nMT,G2H4(664),n2h4(689))
call HGT_OLR(G1H8(171),1,1,8)
call HGT_invQ_OLR(G1H8(171),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(171),-4,nMT,G2H8(106),n2h8(388))
  call Hloop_QV_A(ntryL,G2H8(106),ex3(:),G2H4(665),m3h2x4(:,817),heltab2x8(:,:,817))
  call Hloop_AV_Q(ntryL,G1H8(91),ex5(:),G1H4(175),m3h2x4(:,818),heltab2x8(:,:,818))
  call Hloop_A_Q(ntryL,G1H4(175),51,nMT,G2H4(666),n2h4(690))
  call Hloop_AV_Q(ntryL,G1H8(183),ex5(:),G1H4(176),m3h2x4(:,819),heltab2x8(:,:,819))
  call Hloop_A_Q(ntryL,G1H4(176),51,nMT,G2H4(667),n2h4(691))
  call Hloop_AV_Q(ntryL,G1H8(184),ex5(:),G1H4(181),m3h2x4(:,820),heltab2x8(:,:,820))
  call Hloop_A_Q(ntryL,G1H4(181),51,nMT,G2H4(668),n2h4(692))
  call Hloop_QV_A(ntryL,G1H8(189),ex5(:),G1H4(182),m3h2x4(:,821),heltab2x8(:,:,821))
  call Hloop_Q_A(ntryL,G1H4(182),51,nMB,G2H4(669),n2h4(693))
call HGT_OLR(G1H8(190),1,1,8)
call HGT_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(190),-4,nMB,G2H8(146),n2h8(389))
  call Hloop_AV_Q(ntryL,G2H8(146),ex3(:),G2H4(670),m3h2x4(:,822),heltab2x8(:,:,822))
  call Hloop_QV_A(ntryL,G1H8(196),ex5(:),G1H4(186),m3h2x4(:,823),heltab2x8(:,:,823))
  call Hloop_Q_A(ntryL,G1H4(186),51,nMB,G2H4(671),n2h4(694))
  call Hloop_QV_A(ntryL,G1H8(201),ex5(:),G1H4(187),m3h2x4(:,824),heltab2x8(:,:,824))
  call Hloop_Q_A(ntryL,G1H4(187),51,nMB,G2H4(672),n2h4(695))
  call Hloop_QV_A(ntryL,G1H8(202),ex5(:),G1H4(188),m3h2x4(:,825),heltab2x8(:,:,825))
  call Hloop_Q_A(ntryL,G1H4(188),51,nMB,G2H4(673),n2h4(696))
  call Hloop_AV_Q(ntryL,G1H8(207),ex5(:),G1H4(193),m3h2x4(:,826),heltab2x8(:,:,826))
  call Hloop_A_Q(ntryL,G1H4(193),51,nMB,G2H4(674),n2h4(697))
call HGT_OLR(G1H8(208),1,1,8)
call HGT_invQ_OLR(G1H8(208),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(208),-4,nMB,G2H8(111),n2h8(390))
  call Hloop_QV_A(ntryL,G2H8(111),ex3(:),G2H4(675),m3h2x4(:,827),heltab2x8(:,:,827))
  call Hloop_AV_Q(ntryL,G1H8(400),ex5(:),G1H4(194),m3h2x4(:,828),heltab2x8(:,:,828))
  call Hloop_A_Q(ntryL,G1H4(194),51,nMB,G2H4(676),n2h4(698))
  call Hloop_AV_Q(ntryL,G1H8(225),ex5(:),G1H4(198),m3h2x4(:,829),heltab2x8(:,:,829))
  call Hloop_A_Q(ntryL,G1H4(198),51,nMB,G2H4(677),n2h4(699))
  call Hloop_AV_Q(ntryL,G1H8(406),ex5(:),G1H4(199),m3h2x4(:,830),heltab2x8(:,:,830))
  call Hloop_A_Q(ntryL,G1H4(199),51,nMB,G2H4(678),n2h4(700))
  call Hloop_AV_Q(ntryL,G1H16(86),ex4(:),G1H8(157),m3h2x8(:,277),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H8(157),44,0,G2H8(145),n2h8(391))
call HGT_OLR(G1H16(87),1,1,16)
call HGT_invQ_OLR(G1H16(87),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(87),-16,0,G2H16(7),n2h16(187))
  call Hloop_QV_A(ntryL,G2H16(7),ex5(:),G2H8(116),m3h2x8(:,278),heltab2x16(:,:,302))
  call Hloop_AV_Q(ntryL,G1H16(90),ex4(:),G1H8(158),m3h2x8(:,279),heltab2x16(:,:,303))
  call Hloop_A_Q(ntryL,G1H8(158),44,0,G2H8(120),n2h8(392))
  call Hloop_AV_Q(ntryL,G1H16(91),ex4(:),G1H8(161),m3h2x8(:,280),heltab2x16(:,:,304))
  call Hloop_A_Q(ntryL,G1H8(161),44,0,G2H8(124),n2h8(393))
  call Hloop_AV_Q(ntryL,G1H16(92),ex4(:),G1H8(162),m3h2x8(:,281),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H8(162),44,0,G2H8(153),n2h8(394))
  call Hloop_AV_Q(ntryL,G1H16(93),ex4(:),G1H8(164),m3h2x8(:,282),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G1H8(164),44,nMT,G2H8(129),n2h8(395))
call HGT_OLR(G1H16(94),1,1,16)
call HGT_invQ_OLR(G1H16(94),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(94),-16,nMT,G2H16(8),n2h16(188))
  call Hloop_QV_A(ntryL,G2H16(8),ex5(:),G2H8(151),m3h2x8(:,283),heltab2x16(:,:,307))
  call Hloop_AV_Q(ntryL,G1H16(97),ex4(:),G1H8(167),m3h2x8(:,284),heltab2x16(:,:,308))
  call Hloop_A_Q(ntryL,G1H8(167),44,nMT,G2H8(134),n2h8(396))
  call Hloop_AV_Q(ntryL,G1H16(98),ex4(:),G1H8(168),m3h2x8(:,285),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G1H8(168),44,nMT,G2H8(139),n2h8(397))
  call Hloop_AV_Q(ntryL,G1H16(99),ex4(:),G1H8(169),m3h2x8(:,286),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G1H8(169),44,nMT,G2H8(143),n2h8(398))
  call Hloop_QV_A(ntryL,G1H16(100),ex4(:),G1H8(170),m3h2x8(:,287),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H8(170),44,0,G2H8(147),n2h8(399))
call HGT_OLR(G1H16(102),1,1,16)
call HGT_invQ_OLR(G1H16(102),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(102),-16,0,G2H16(9),n2h16(189))
  call Hloop_AV_Q(ntryL,G2H16(9),ex5(:),G2H8(148),m3h2x8(:,288),heltab2x16(:,:,312))
  call Hloop_QV_A(ntryL,G1H16(104),ex4(:),G1H8(174),m3h2x8(:,289),heltab2x16(:,:,313))
  call Hloop_Q_A(ntryL,G1H8(174),44,0,G2H8(152),n2h8(400))
  call Hloop_QV_A(ntryL,G1H16(105),ex4(:),G1H8(175),m3h2x8(:,290),heltab2x16(:,:,314))
  call Hloop_Q_A(ntryL,G1H8(175),44,0,G2H8(156),n2h8(401))
  call Hloop_QV_A(ntryL,G1H16(106),ex4(:),G1H8(176),m3h2x8(:,291),heltab2x16(:,:,315))
  call Hloop_Q_A(ntryL,G1H8(176),44,0,G2H8(121),n2h8(402))
  call Hloop_QV_A(ntryL,G1H16(108),ex4(:),G1H8(179),m3h2x8(:,292),heltab2x16(:,:,316))
  call Hloop_Q_A(ntryL,G1H8(179),44,nMT,G2H8(140),n2h8(403))
call HGT_OLR(G1H16(111),1,1,16)
call HGT_invQ_OLR(G1H16(111),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(111),-16,nMT,G2H16(10),n2h16(190))
  call Hloop_AV_Q(ntryL,G2H16(10),ex5(:),G2H8(99),m3h2x8(:,293),heltab2x16(:,:,317))
  call Hloop_QV_A(ntryL,G1H16(114),ex4(:),G1H8(180),m3h2x8(:,294),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G1H8(180),44,nMT,G2H8(127),n2h8(404))
  call Hloop_QV_A(ntryL,G1H16(117),ex4(:),G1H8(182),m3h2x8(:,295),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G1H8(182),44,nMT,G2H8(93),n2h8(405))
  call Hloop_QV_A(ntryL,G1H16(118),ex4(:),G1H8(185),m3h2x8(:,296),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H8(185),44,nMT,G2H8(109),n2h8(406))
  call Hloop_AV_Q(ntryL,G1H16(121),ex4(:),G1H8(186),m3h2x8(:,297),heltab2x16(:,:,321))
  call Hloop_A_Q(ntryL,G1H8(186),44,nMB,G2H8(118),n2h8(407))
call HGT_OLR(G1H16(123),1,1,16)
call HGT_invQ_OLR(G1H16(123),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(123),-16,nMB,G2H16(11),n2h16(191))
  call Hloop_QV_A(ntryL,G2H16(11),ex5(:),G2H8(137),m3h2x8(:,298),heltab2x16(:,:,322))
  call Hloop_AV_Q(ntryL,G1H16(128),ex4(:),G1H8(187),m3h2x8(:,299),heltab2x16(:,:,323))
  call Hloop_A_Q(ntryL,G1H8(187),44,nMB,G2H8(103),n2h8(408))
  call Hloop_AV_Q(ntryL,G1H16(17),ex4(:),G1H8(188),m3h2x8(:,300),heltab2x16(:,:,324))
  call Hloop_A_Q(ntryL,G1H8(188),44,nMB,G2H8(131),n2h8(409))
  call Hloop_AV_Q(ntryL,G1H16(18),ex4(:),G1H8(192),m3h2x8(:,301),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G1H8(192),44,nMB,G2H8(89),n2h8(410))
  call Hloop_QV_A(ntryL,G1H16(131),ex4(:),G1H8(193),m3h2x8(:,302),heltab2x16(:,:,326))
  call Hloop_Q_A(ntryL,G1H8(193),44,nMB,G2H8(113),n2h8(411))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-16,nMB,G2H16(12),n2h16(192))
  call Hloop_AV_Q(ntryL,G2H16(12),ex5(:),G2H8(49),m3h2x8(:,303),heltab2x16(:,:,327))
  call Hloop_QV_A(ntryL,G1H16(136),ex4(:),G1H8(194),m3h2x8(:,304),heltab2x16(:,:,328))
  call Hloop_Q_A(ntryL,G1H8(194),44,nMB,G2H8(54),n2h8(412))
  call Hloop_QV_A(ntryL,G1H16(21),ex4(:),G1H8(197),m3h2x8(:,305),heltab2x16(:,:,329))
  call Hloop_Q_A(ntryL,G1H8(197),44,nMB,G2H8(59),n2h8(413))
  call Hloop_QV_A(ntryL,G1H16(137),ex4(:),G1H8(198),m3h2x8(:,306),heltab2x16(:,:,330))
  call Hloop_Q_A(ntryL,G1H8(198),44,nMB,G2H8(60),n2h8(414))
  call Hloop_AV_Q(ntryL,G1H8(237),ex3(:),G1H4(200),m3h2x4(:,831),heltab2x8(:,:,831))
  call Hloop_A_Q(ntryL,G1H4(200),39,nMT,G2H4(679),n2h4(701))
call HGT_OLR(G1H8(238),1,1,8)
call HGT_invQ_OLR(G1H8(238),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(238),-16,nMT,G2H8(63),n2h8(415))
  call Hloop_QV_A(ntryL,G2H8(63),ex5(:),G2H4(680),m3h2x4(:,832),heltab2x8(:,:,832))
  call Hloop_AV_Q(ntryL,G1H8(244),ex3(:),G1H4(205),m3h2x4(:,833),heltab2x8(:,:,833))
  call Hloop_A_Q(ntryL,G1H4(205),39,nMT,G2H4(681),n2h4(702))
  call Hloop_AV_Q(ntryL,G1H8(255),ex3(:),G1H4(206),m3h2x4(:,834),heltab2x8(:,:,834))
  call Hloop_A_Q(ntryL,G1H4(206),39,nMT,G2H4(682),n2h4(703))
  call Hloop_AV_Q(ntryL,G1H8(274),ex3(:),G1H4(210),m3h2x4(:,835),heltab2x8(:,:,835))
  call Hloop_A_Q(ntryL,G1H4(210),39,nMT,G2H4(683),n2h4(704))
  call Hloop_QV_A(ntryL,G1H8(261),ex3(:),G1H4(211),m3h2x4(:,836),heltab2x8(:,:,836))
  call Hloop_Q_A(ntryL,G1H4(211),39,nMT,G2H4(684),n2h4(705))
call HGT_OLR(G1H8(280),1,1,8)
call HGT_invQ_OLR(G1H8(280),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(280),-16,nMT,G2H8(64),n2h8(416))
  call Hloop_AV_Q(ntryL,G2H8(64),ex5(:),G2H4(685),m3h2x4(:,837),heltab2x8(:,:,837))
  call Hloop_QV_A(ntryL,G1H8(279),ex3(:),G1H4(212),m3h2x4(:,838),heltab2x8(:,:,838))
  call Hloop_Q_A(ntryL,G1H4(212),39,nMT,G2H4(686),n2h4(706))
  call Hloop_QV_A(ntryL,G1H8(291),ex3(:),G1H4(217),m3h2x4(:,839),heltab2x8(:,:,839))
  call Hloop_Q_A(ntryL,G1H4(217),39,nMT,G2H4(687),n2h4(707))
  call Hloop_QV_A(ntryL,G1H8(292),ex3(:),G1H4(218),m3h2x4(:,840),heltab2x8(:,:,840))
  call Hloop_Q_A(ntryL,G1H4(218),39,nMT,G2H4(688),n2h4(708))
  call Hloop_AV_Q(ntryL,G1H8(297),ex3(:),G1H4(222),m3h2x4(:,841),heltab2x8(:,:,841))
  call Hloop_A_Q(ntryL,G1H4(222),39,nMB,G2H4(689),n2h4(709))
call HGT_OLR(G1H8(298),1,1,8)
call HGT_invQ_OLR(G1H8(298),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(298),-16,nMB,G2H8(65),n2h8(417))
  call Hloop_QV_A(ntryL,G2H8(65),ex5(:),G2H4(690),m3h2x4(:,842),heltab2x8(:,:,842))
  call Hloop_AV_Q(ntryL,G1H8(310),ex3(:),G1H4(223),m3h2x4(:,843),heltab2x8(:,:,843))
  call Hloop_A_Q(ntryL,G1H4(223),39,nMB,G2H4(691),n2h4(710))
  call Hloop_AV_Q(ntryL,G1H8(315),ex3(:),G1H4(224),m3h2x4(:,844),heltab2x8(:,:,844))
  call Hloop_A_Q(ntryL,G1H4(224),39,nMB,G2H4(692),n2h4(711))
  call Hloop_AV_Q(ntryL,G1H8(316),ex3(:),G1H4(229),m3h2x4(:,845),heltab2x8(:,:,845))
  call Hloop_A_Q(ntryL,G1H4(229),39,nMB,G2H4(693),n2h4(712))
  call Hloop_QV_A(ntryL,G1H8(327),ex3(:),G1H4(230),m3h2x4(:,846),heltab2x8(:,:,846))
  call Hloop_Q_A(ntryL,G1H4(230),39,nMB,G2H4(694),n2h4(713))
call HGT_OLR(G1H8(328),1,1,8)
call HGT_invQ_OLR(G1H8(328),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(328),-16,nMB,G2H8(68),n2h8(418))
  call Hloop_AV_Q(ntryL,G2H8(68),ex5(:),G2H4(695),m3h2x4(:,847),heltab2x8(:,:,847))
  call Hloop_QV_A(ntryL,G1H8(334),ex3(:),G1H4(234),m3h2x4(:,848),heltab2x8(:,:,848))
  call Hloop_Q_A(ntryL,G1H4(234),39,nMB,G2H4(696),n2h4(714))
  call Hloop_QV_A(ntryL,G1H8(345),ex3(:),G1H4(235),m3h2x4(:,849),heltab2x8(:,:,849))
  call Hloop_Q_A(ntryL,G1H4(235),39,nMB,G2H4(697),n2h4(715))
  call Hloop_QV_A(ntryL,G1H8(346),ex3(:),G1H4(241),m3h2x4(:,850),heltab2x8(:,:,850))
  call Hloop_Q_A(ntryL,G1H4(241),39,nMB,G2H4(698),n2h4(716))
  call Hloop_QV_A(ntryL,G1H16(139),ex3(:),G1H8(200),m3h2x8(:,307),heltab2x16(:,:,331))
  call Hloop_Q_A(ntryL,G1H8(200),44,0,G2H8(69),n2h8(419))
call HGT_OLR(G1H16(140),1,1,16)
call HGT_invQ_OLR(G1H16(140),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(140),-16,0,G2H16(13),n2h16(193))
  call Hloop_AV_Q(ntryL,G2H16(13),ex5(:),G2H8(70),m3h2x8(:,308),heltab2x16(:,:,332))
  call Hloop_QV_A(ntryL,G1H16(143),ex3(:),G1H8(203),m3h2x8(:,309),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G1H8(203),44,0,G2H8(73),n2h8(420))
  call Hloop_QV_A(ntryL,G1H16(145),ex3(:),G1H8(204),m3h2x8(:,310),heltab2x16(:,:,334))
  call Hloop_Q_A(ntryL,G1H8(204),44,0,G2H8(74),n2h8(421))
  call Hloop_QV_A(ntryL,G1H16(22),ex3(:),G1H8(205),m3h2x8(:,311),heltab2x16(:,:,335))
  call Hloop_Q_A(ntryL,G1H8(205),44,0,G2H8(75),n2h8(422))
  call Hloop_QV_A(ntryL,G1H16(23),ex3(:),G1H8(206),m3h2x8(:,312),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G1H8(206),44,nMT,G2H8(78),n2h8(423))
call HGT_OLR(G1H16(149),1,1,16)
call HGT_invQ_OLR(G1H16(149),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(149),-16,nMT,G2H16(14),n2h16(194))
  call Hloop_AV_Q(ntryL,G2H16(14),ex5(:),G2H8(35),m3h2x8(:,313),heltab2x16(:,:,337))
  call Hloop_QV_A(ntryL,G1H16(151),ex3(:),G1H8(210),m3h2x8(:,314),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G1H8(210),44,nMT,G2H8(38),n2h8(424))
  call Hloop_QV_A(ntryL,G1H16(152),ex3(:),G1H8(211),m3h2x8(:,315),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G1H8(211),44,nMT,G2H8(39),n2h8(425))
  call Hloop_QV_A(ntryL,G1H16(154),ex3(:),G1H8(212),m3h2x8(:,316),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G1H8(212),44,nMT,G2H8(40),n2h8(426))
  call Hloop_AV_Q(ntryL,G1H16(27),ex3(:),G1H8(217),m3h2x8(:,317),heltab2x16(:,:,341))
  call Hloop_A_Q(ntryL,G1H8(217),44,0,G2H8(43),n2h8(427))
call HGT_OLR(G1H16(41),1,1,16)
call HGT_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(41),-16,0,G2H16(15),n2h16(195))
  call Hloop_QV_A(ntryL,G2H16(15),ex5(:),G2H8(44),m3h2x8(:,318),heltab2x16(:,:,342))
  call Hloop_AV_Q(ntryL,G1H16(57),ex3(:),G1H8(223),m3h2x8(:,319),heltab2x16(:,:,343))
  call Hloop_A_Q(ntryL,G1H8(223),44,0,G2H8(48),n2h8(428))
  call Hloop_AV_Q(ntryL,G1H16(67),ex3(:),G1H8(221),m3h2x8(:,320),heltab2x16(:,:,344))
  call Hloop_A_Q(ntryL,G1H8(221),44,0,G2H8(53),n2h8(429))
  call Hloop_AV_Q(ntryL,G1H16(73),ex3(:),G1H8(222),m3h2x8(:,321),heltab2x16(:,:,345))
  call Hloop_A_Q(ntryL,G1H8(222),44,0,G2H8(55),n2h8(430))
  call Hloop_AV_Q(ntryL,G1H16(83),ex3(:),G1H8(224),m3h2x8(:,322),heltab2x16(:,:,346))
  call Hloop_A_Q(ntryL,G1H8(224),44,nMT,G2H8(58),n2h8(431))
call HGT_OLR(G1H16(89),1,1,16)
call HGT_invQ_OLR(G1H16(89),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(89),-16,nMT,G2H16(16),n2h16(196))
  call Hloop_QV_A(ntryL,G2H16(16),ex5(:),G2H8(90),m3h2x8(:,323),heltab2x16(:,:,347))
  call Hloop_AV_Q(ntryL,G1H16(125),ex3(:),G1H8(227),m3h2x8(:,324),heltab2x16(:,:,348))
  call Hloop_A_Q(ntryL,G1H8(227),44,nMT,G2H8(94),n2h8(432))
  call Hloop_AV_Q(ntryL,G1H16(19),ex3(:),G1H8(228),m3h2x8(:,325),heltab2x16(:,:,349))
  call Hloop_A_Q(ntryL,G1H8(228),44,nMT,G2H8(95),n2h8(433))
  call Hloop_AV_Q(ntryL,G1H16(35),ex3(:),G1H8(230),m3h2x8(:,326),heltab2x16(:,:,350))
  call Hloop_A_Q(ntryL,G1H8(230),44,nMT,G2H8(98),n2h8(434))
  call Hloop_QV_A(ntryL,G1H16(31),ex3(:),G1H8(235),m3h2x8(:,327),heltab2x16(:,:,351))
  call Hloop_Q_A(ntryL,G1H8(235),44,nMB,G2H8(100),n2h8(435))
call HGT_OLR(G1H16(37),1,1,16)
call HGT_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(37),-16,nMB,G2H16(17),n2h16(197))
  call Hloop_AV_Q(ntryL,G2H16(17),ex5(:),G2H8(104),m3h2x8(:,328),heltab2x16(:,:,352))
  call Hloop_QV_A(ntryL,G1H16(53),ex3(:),G1H8(241),m3h2x8(:,329),heltab2x16(:,:,353))
  call Hloop_Q_A(ntryL,G1H8(241),44,nMB,G2H8(105),n2h8(436))
  call Hloop_QV_A(ntryL,G1H16(4),ex3(:),G1H8(236),m3h2x8(:,330),heltab2x16(:,:,354))
  call Hloop_Q_A(ntryL,G1H8(236),44,nMB,G2H8(108),n2h8(437))
  call Hloop_QV_A(ntryL,G1H16(25),ex3(:),G1H8(239),m3h2x8(:,331),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H8(239),44,nMB,G2H8(110),n2h8(438))
  call Hloop_AV_Q(ntryL,G1H16(29),ex3(:),G1H8(242),m3h2x8(:,332),heltab2x16(:,:,356))
  call Hloop_A_Q(ntryL,G1H8(242),44,nMB,G2H8(114),n2h8(439))
call HGT_OLR(G1H16(30),1,1,16)
call HGT_invQ_OLR(G1H16(30),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(30),-16,nMB,G2H16(18),n2h16(198))
  call Hloop_QV_A(ntryL,G2H16(18),ex5(:),G2H8(115),m3h2x8(:,333),heltab2x16(:,:,357))
  call Hloop_AV_Q(ntryL,G1H16(33),ex3(:),G1H8(245),m3h2x8(:,334),heltab2x16(:,:,358))
  call Hloop_A_Q(ntryL,G1H8(245),44,nMB,G2H8(117),n2h8(440))
  call Hloop_AV_Q(ntryL,G1H16(36),ex3(:),G1H8(246),m3h2x8(:,335),heltab2x16(:,:,359))
  call Hloop_A_Q(ntryL,G1H8(246),44,nMB,G2H8(119),n2h8(441))
  call Hloop_AV_Q(ntryL,G1H16(39),ex3(:),G1H8(247),m3h2x8(:,336),heltab2x16(:,:,360))
  call Hloop_A_Q(ntryL,G1H8(247),44,nMB,G2H8(122),n2h8(442))
  call Hloop_QV_A(ntryL,G1H8(351),ex4(:),G1H4(242),m3h2x4(:,851),heltab2x8(:,:,851))
  call Hloop_Q_A(ntryL,G1H4(242),43,nMT,G2H4(699),n2h4(717))
call HGT_OLR(G1H8(352),1,1,8)
call HGT_invQ_OLR(G1H8(352),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(352),-4,nMT,G2H8(123),n2h8(443))
  call Hloop_AV_Q(ntryL,G2H8(123),ex3(:),G2H4(700),m3h2x4(:,852),heltab2x8(:,:,852))
  call Hloop_QV_A(ntryL,G1H8(364),ex4(:),G1H4(246),m3h2x4(:,853),heltab2x8(:,:,853))
  call Hloop_Q_A(ntryL,G1H4(246),43,nMT,G2H4(701),n2h4(718))
  call Hloop_QV_A(ntryL,G1H8(369),ex4(:),G1H4(247),m3h2x4(:,854),heltab2x8(:,:,854))
  call Hloop_Q_A(ntryL,G1H4(247),43,nMT,G2H4(702),n2h4(719))
  call Hloop_QV_A(ntryL,G1H8(370),ex4(:),G1H4(248),m3h2x4(:,855),heltab2x8(:,:,855))
  call Hloop_Q_A(ntryL,G1H4(248),43,nMT,G2H4(703),n2h4(720))
  call Hloop_AV_Q(ntryL,G1H8(381),ex4(:),G1H4(253),m3h2x4(:,856),heltab2x8(:,:,856))
  call Hloop_A_Q(ntryL,G1H4(253),43,nMT,G2H4(704),n2h4(721))
call HGT_OLR(G1H8(382),1,1,8)
call HGT_invQ_OLR(G1H8(382),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(382),-4,nMT,G2H8(126),n2h8(444))
  call Hloop_QV_A(ntryL,G2H8(126),ex3(:),G2H4(705),m3h2x4(:,857),heltab2x8(:,:,857))
  call Hloop_AV_Q(ntryL,G1H8(388),ex4(:),G1H4(254),m3h2x4(:,858),heltab2x8(:,:,858))
  call Hloop_A_Q(ntryL,G1H4(254),43,nMT,G2H4(706),n2h4(722))
  call Hloop_AV_Q(ntryL,G1H8(399),ex4(:),G1H4(258),m3h2x4(:,859),heltab2x8(:,:,859))
  call Hloop_A_Q(ntryL,G1H4(258),43,nMT,G2H4(707),n2h4(723))
  call Hloop_AV_Q(ntryL,G1H8(405),ex4(:),G1H4(259),m3h2x4(:,860),heltab2x8(:,:,860))
  call Hloop_A_Q(ntryL,G1H4(259),43,nMT,G2H4(708),n2h4(724))
  call Hloop_QV_A(ntryL,G1H8(417),ex4(:),G1H4(260),m3h2x4(:,861),heltab2x8(:,:,861))
  call Hloop_Q_A(ntryL,G1H4(260),43,nMB,G2H4(709),n2h4(725))
call HGT_OLR(G1H8(418),1,1,8)
call HGT_invQ_OLR(G1H8(418),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(418),-4,nMB,G2H8(128),n2h8(445))
  call Hloop_AV_Q(ntryL,G2H8(128),ex3(:),G2H4(710),m3h2x4(:,862),heltab2x8(:,:,862))
  call Hloop_QV_A(ntryL,G1H8(424),ex4(:),G1H4(265),m3h2x4(:,863),heltab2x8(:,:,863))
  call Hloop_Q_A(ntryL,G1H4(265),43,nMB,G2H4(711),n2h4(726))
  call Hloop_QV_A(ntryL,G1H8(435),ex4(:),G1H4(266),m3h2x4(:,864),heltab2x8(:,:,864))
  call Hloop_Q_A(ntryL,G1H4(266),43,nMB,G2H4(712),n2h4(727))
  call Hloop_QV_A(ntryL,G1H8(436),ex4(:),G1H4(271),m3h2x4(:,865),heltab2x8(:,:,865))
  call Hloop_Q_A(ntryL,G1H4(271),43,nMB,G2H4(713),n2h4(728))
  call Hloop_AV_Q(ntryL,G1H8(441),ex4(:),G1H4(272),m3h2x4(:,866),heltab2x8(:,:,866))
  call Hloop_A_Q(ntryL,G1H4(272),43,nMB,G2H4(714),n2h4(729))
call HGT_OLR(G1H8(442),1,1,8)
call HGT_invQ_OLR(G1H8(442),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(442),-4,nMB,G2H8(132),n2h8(446))
  call Hloop_QV_A(ntryL,G2H8(132),ex3(:),G2H4(715),m3h2x4(:,867),heltab2x8(:,:,867))
  call Hloop_AV_Q(ntryL,G1H8(454),ex4(:),G1H4(277),m3h2x4(:,868),heltab2x8(:,:,868))
  call Hloop_A_Q(ntryL,G1H4(277),43,nMB,G2H4(716),n2h4(730))
  call Hloop_AV_Q(ntryL,G1H8(459),ex4(:),G1H4(278),m3h2x4(:,869),heltab2x8(:,:,869))
  call Hloop_A_Q(ntryL,G1H4(278),43,nMB,G2H4(717),n2h4(731))
  call Hloop_AV_Q(ntryL,G1H8(460),ex4(:),G1H4(282),m3h2x4(:,870),heltab2x8(:,:,870))
  call Hloop_A_Q(ntryL,G1H4(282),43,nMB,G2H4(718),n2h4(732))
  call Hloop_AV_Q(ntryL,G1H16(40),ex5(:),G1H8(248),m3h2x8(:,337),heltab2x16(:,:,361))
  call Hloop_A_Q(ntryL,G1H8(248),52,0,G2H8(133),n2h8(447))
call HGT_OLR(G1H16(3),1,1,16)
call HGT_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(3),-8,0,G2H16(19),n2h16(199))
  call Hloop_QV_A(ntryL,G2H16(19),ex4(:),G2H8(136),m3h2x8(:,338),heltab2x16(:,:,362))
  call Hloop_AV_Q(ntryL,G1H16(45),ex5(:),G1H8(259),m3h2x8(:,339),heltab2x16(:,:,363))
  call Hloop_A_Q(ntryL,G1H8(259),52,0,G2H8(138),n2h8(448))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(254),m3h2x8(:,340),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H8(254),52,0,G2H8(141),n2h8(449))
  call Hloop_AV_Q(ntryL,G1H16(49),ex5(:),G1H8(257),m3h2x8(:,341),heltab2x16(:,:,365))
  call Hloop_A_Q(ntryL,G1H8(257),52,0,G2H8(142),n2h8(450))
  call Hloop_AV_Q(ntryL,G1H16(50),ex5(:),G1H8(258),m3h2x8(:,342),heltab2x16(:,:,366))
  call Hloop_A_Q(ntryL,G1H8(258),52,nMT,G2H8(144),n2h8(451))
call HGT_OLR(G1H16(51),1,1,16)
call HGT_invQ_OLR(G1H16(51),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(51),-8,nMT,G2H16(20),n2h16(200))
  call Hloop_QV_A(ntryL,G2H16(20),ex4(:),G2H8(1),m3h2x8(:,343),heltab2x16(:,:,367))
  call Hloop_AV_Q(ntryL,G1H16(54),ex5(:),G1H8(260),m3h2x8(:,344),heltab2x16(:,:,368))
  call Hloop_A_Q(ntryL,G1H8(260),52,nMT,G2H8(2),n2h8(452))
  call Hloop_AV_Q(ntryL,G1H16(56),ex5(:),G1H8(264),m3h2x8(:,345),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G1H8(264),52,nMT,G2H8(31),n2h8(453))
  call Hloop_AV_Q(ntryL,G1H16(8),ex5(:),G1H8(265),m3h2x8(:,346),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G1H8(265),52,nMT,G2H8(32),n2h8(454))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(266),m3h2x8(:,347),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H8(266),52,0,G2H8(33),n2h8(455))
call HGT_OLR(G1H16(61),1,1,16)
call HGT_invQ_OLR(G1H16(61),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(61),-8,0,G2H16(21),n2h16(201))
  call Hloop_AV_Q(ntryL,G2H16(21),ex4(:),G2H8(34),m3h2x8(:,348),heltab2x16(:,:,372))
  call Hloop_QV_A(ntryL,G1H16(64),ex5(:),G1H8(271),m3h2x8(:,349),heltab2x16(:,:,373))
  call Hloop_Q_A(ntryL,G1H8(271),52,0,G2H8(37),n2h8(456))
  call Hloop_QV_A(ntryL,G1H16(65),ex5(:),G1H8(277),m3h2x8(:,350),heltab2x16(:,:,374))
  call Hloop_Q_A(ntryL,G1H8(277),52,0,G2H8(52),n2h8(457))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(275),m3h2x8(:,351),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H8(275),52,0,G2H8(135),n2h8(458))
  call Hloop_QV_A(ntryL,G1H16(157),ex5(:),G1H8(276),m3h2x8(:,352),heltab2x16(:,:,376))
  call Hloop_Q_A(ntryL,G1H8(276),52,nMT,G2H8(67),n2h8(459))
call HGT_OLR(G1H16(158),1,1,16)
call HGT_invQ_OLR(G1H16(158),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(158),-8,nMT,G2H16(22),n2h16(202))
  call Hloop_AV_Q(ntryL,G2H16(22),ex4(:),G2H8(79),m3h2x8(:,353),heltab2x16(:,:,377))
  call Hloop_QV_A(ntryL,G1H16(160),ex5(:),G1H8(278),m3h2x8(:,354),heltab2x16(:,:,378))
  call Hloop_Q_A(ntryL,G1H8(278),52,nMT,G2H8(72),n2h8(460))
  call Hloop_QV_A(ntryL,G1H16(161),ex5(:),G1H8(281),m3h2x8(:,355),heltab2x16(:,:,379))
  call Hloop_Q_A(ntryL,G1H8(281),52,nMT,G2H8(92),n2h8(461))
  call Hloop_QV_A(ntryL,G1H16(162),ex5(:),G1H8(282),m3h2x8(:,356),heltab2x16(:,:,380))
  call Hloop_Q_A(ntryL,G1H8(282),52,nMT,G2H8(82),n2h8(462))
  call Hloop_AV_Q(ntryL,G1H16(163),ex5(:),G1H8(284),m3h2x8(:,357),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G1H8(284),52,nMB,G2H8(50),n2h8(463))
call HGT_OLR(G1H16(164),1,1,16)
call HGT_invQ_OLR(G1H16(164),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(164),-8,nMB,G2H16(23),n2h16(203))
  call Hloop_QV_A(ntryL,G2H16(23),ex4(:),G2H8(87),m3h2x8(:,358),heltab2x16(:,:,382))
  call Hloop_AV_Q(ntryL,G1H16(166),ex5(:),G1H8(289),m3h2x8(:,359),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G1H8(289),52,nMB,G2H8(80),n2h8(464))
  call Hloop_AV_Q(ntryL,G1H16(167),ex5(:),G1H8(295),m3h2x8(:,360),heltab2x16(:,:,384))
  call Hloop_A_Q(ntryL,G1H8(295),52,nMB,G2H8(97),n2h8(465))
  call Hloop_AV_Q(ntryL,G1H16(168),ex5(:),G1H8(290),m3h2x8(:,361),heltab2x16(:,:,385))
  call Hloop_A_Q(ntryL,G1H8(290),52,nMB,G2H8(45),n2h8(466))
  call Hloop_QV_A(ntryL,G1H16(169),ex5(:),G1H8(293),m3h2x8(:,362),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G1H8(293),52,nMB,G2H8(102),n2h8(467))
call HGT_OLR(G1H16(170),1,1,16)
call HGT_invQ_OLR(G1H16(170),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(170),-8,nMB,G2H16(24),n2h16(204))
  call Hloop_AV_Q(ntryL,G2H16(24),ex4(:),G2H8(81),m3h2x8(:,363),heltab2x16(:,:,387))
  call Hloop_QV_A(ntryL,G1H16(172),ex5(:),G1H8(296),m3h2x8(:,364),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G1H8(296),52,nMB,G2H8(158),n2h8(468))
  call Hloop_QV_A(ntryL,G1H16(173),ex5(:),G1H8(299),m3h2x8(:,365),heltab2x16(:,:,389))
  call Hloop_Q_A(ntryL,G1H8(299),52,nMB,G2H8(86),n2h8(469))
  call Hloop_QV_A(ntryL,G1H16(174),ex5(:),G1H8(300),m3h2x8(:,366),heltab2x16(:,:,390))
  call Hloop_Q_A(ntryL,G1H8(300),52,nMB,G2H8(155),n2h8(470))
  call Hloop_AV_Q(ntryL,G1H8(471),ex3(:),G1H4(283),m3h2x4(:,871),heltab2x8(:,:,871))
  call Hloop_A_Q(ntryL,G1H4(283),39,nMT,G2H4(719),n2h4(733))
call HGT_OLR(G1H8(472),1,1,8)
call HGT_invQ_OLR(G1H8(472),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(472),-8,nMT,G2H8(91),n2h8(471))
  call Hloop_QV_A(ntryL,G2H8(91),ex4(:),G2H4(720),m3h2x4(:,872),heltab2x8(:,:,872))
  call Hloop_AV_Q(ntryL,G1H8(478),ex3(:),G1H4(284),m3h2x4(:,873),heltab2x8(:,:,873))
  call Hloop_A_Q(ntryL,G1H4(284),39,nMT,G2H4(721),n2h4(734))
  call Hloop_AV_Q(ntryL,G1H8(489),ex3(:),G1H4(289),m3h2x4(:,874),heltab2x8(:,:,874))
  call Hloop_A_Q(ntryL,G1H4(289),39,nMT,G2H4(722),n2h4(735))
  call Hloop_AV_Q(ntryL,G1H8(490),ex3(:),G1H4(294),m3h2x4(:,875),heltab2x8(:,:,875))
  call Hloop_A_Q(ntryL,G1H4(294),39,nMT,G2H4(723),n2h4(736))
  call Hloop_QV_A(ntryL,G1H8(495),ex3(:),G1H4(295),m3h2x4(:,876),heltab2x8(:,:,876))
  call Hloop_Q_A(ntryL,G1H4(295),39,nMT,G2H4(724),n2h4(737))
call HGT_OLR(G1H8(496),1,1,8)
call HGT_invQ_OLR(G1H8(496),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(496),-8,nMT,G2H8(96),n2h8(472))
  call Hloop_AV_Q(ntryL,G2H8(96),ex4(:),G2H4(725),m3h2x4(:,877),heltab2x8(:,:,877))
  call Hloop_QV_A(ntryL,G1H8(500),ex3(:),G1H4(296),m3h2x4(:,878),heltab2x8(:,:,878))
  call Hloop_Q_A(ntryL,G1H4(296),39,nMT,G2H4(726),n2h4(738))
  call Hloop_QV_A(ntryL,G1H8(501),ex3(:),G1H4(301),m3h2x4(:,879),heltab2x8(:,:,879))
  call Hloop_Q_A(ntryL,G1H4(301),39,nMT,G2H4(727),n2h4(739))
  call Hloop_QV_A(ntryL,G1H8(502),ex3(:),G1H4(302),m3h2x4(:,880),heltab2x8(:,:,880))
  call Hloop_Q_A(ntryL,G1H4(302),39,nMT,G2H4(728),n2h4(740))
  call Hloop_AV_Q(ntryL,G1H8(503),ex3(:),G1H4(306),m3h2x4(:,881),heltab2x8(:,:,881))
  call Hloop_A_Q(ntryL,G1H4(306),39,nMB,G2H4(729),n2h4(741))
call HGT_OLR(G1H8(504),1,1,8)
call HGT_invQ_OLR(G1H8(504),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(504),-8,nMB,G2H8(149),n2h8(473))
  call Hloop_QV_A(ntryL,G2H8(149),ex4(:),G2H4(730),m3h2x4(:,882),heltab2x8(:,:,882))
  call Hloop_AV_Q(ntryL,G1H8(506),ex3(:),G1H4(307),m3h2x4(:,883),heltab2x8(:,:,883))
  call Hloop_A_Q(ntryL,G1H4(307),39,nMB,G2H4(731),n2h4(742))
  call Hloop_AV_Q(ntryL,G1H8(507),ex3(:),G1H4(308),m3h2x4(:,884),heltab2x8(:,:,884))
  call Hloop_A_Q(ntryL,G1H4(308),39,nMB,G2H4(732),n2h4(743))
  call Hloop_AV_Q(ntryL,G1H8(508),ex3(:),G1H4(313),m3h2x4(:,885),heltab2x8(:,:,885))
  call Hloop_A_Q(ntryL,G1H4(313),39,nMB,G2H4(733),n2h4(744))
  call Hloop_QV_A(ntryL,G1H8(509),ex3(:),G1H4(314),m3h2x4(:,886),heltab2x8(:,:,886))
  call Hloop_Q_A(ntryL,G1H4(314),39,nMB,G2H4(734),n2h4(745))
call HGT_OLR(G1H8(510),1,1,8)
call HGT_invQ_OLR(G1H8(510),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(510),-8,nMB,G2H8(101),n2h8(474))
  call Hloop_AV_Q(ntryL,G2H8(101),ex4(:),G2H4(735),m3h2x4(:,887),heltab2x8(:,:,887))
  call Hloop_QV_A(ntryL,G1H8(512),ex3(:),G1H4(318),m3h2x4(:,888),heltab2x8(:,:,888))
  call Hloop_Q_A(ntryL,G1H4(318),39,nMB,G2H4(736),n2h4(746))
  call Hloop_QV_A(ntryL,G1H8(513),ex3(:),G1H4(319),m3h2x4(:,889),heltab2x8(:,:,889))
  call Hloop_Q_A(ntryL,G1H4(319),39,nMB,G2H4(737),n2h4(747))
  call Hloop_QV_A(ntryL,G1H8(514),ex3(:),G1H4(325),m3h2x4(:,890),heltab2x8(:,:,890))
  call Hloop_Q_A(ntryL,G1H4(325),39,nMB,G2H4(738),n2h4(748))
  call Hloop_AV_Q(ntryL,G1H16(175),wf4(:,20),G1H4(326),m3h4x4(:,25),heltab2x16(:,:,391))
  call Hloop_A_Q(ntryL,G1H4(326),43,0,G2H4(739),n2h4(749))
call HGT_OLR(G1H16(176),1,1,16)
call HGT_invQ_OLR(G1H16(176),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(176),-16,0,G2H16(25),n2h16(205))
  call Hloop_QV_A(ntryL,G2H16(25),ex5(:),G2H8(150),m3h2x8(:,367),heltab2x16(:,:,392))
  call Hloop_AV_Q(ntryL,G1H16(178),wf4(:,20),G1H4(330),m3h4x4(:,26),heltab2x16(:,:,393))
  call Hloop_A_Q(ntryL,G1H4(330),43,0,G2H4(740),n2h4(750))
  call Hloop_AV_Q(ntryL,G1H16(179),wf4(:,20),G1H4(331),m3h4x4(:,27),heltab2x16(:,:,394))
  call Hloop_A_Q(ntryL,G1H4(331),43,0,G2H4(741),n2h4(751))
  call Hloop_AV_Q(ntryL,G1H16(180),wf4(:,20),G1H4(332),m3h4x4(:,28),heltab2x16(:,:,395))
  call Hloop_A_Q(ntryL,G1H4(332),43,0,G2H4(742),n2h4(752))
  call Hloop_AV_Q(ntryL,G1H16(181),wf4(:,20),G1H4(337),m3h4x4(:,29),heltab2x16(:,:,396))
  call Hloop_A_Q(ntryL,G1H4(337),43,nMT,G2H4(743),n2h4(753))
call HGT_OLR(G1H16(182),1,1,16)
call HGT_invQ_OLR(G1H16(182),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(182),-16,nMT,G2H16(26),n2h16(206))
  call Hloop_QV_A(ntryL,G2H16(26),ex5(:),G2H8(106),m3h2x8(:,368),heltab2x16(:,:,397))
  call Hloop_AV_Q(ntryL,G1H16(184),wf4(:,20),G1H4(338),m3h4x4(:,30),heltab2x16(:,:,398))
  call Hloop_A_Q(ntryL,G1H4(338),43,nMT,G2H4(744),n2h4(754))
  call Hloop_AV_Q(ntryL,G1H16(185),wf4(:,20),G1H4(342),m3h4x4(:,31),heltab2x16(:,:,399))
  call Hloop_A_Q(ntryL,G1H4(342),43,nMT,G2H4(745),n2h4(755))
  call Hloop_AV_Q(ntryL,G1H16(186),wf4(:,20),G1H4(343),m3h4x4(:,32),heltab2x16(:,:,400))
  call Hloop_A_Q(ntryL,G1H4(343),43,nMT,G2H4(746),n2h4(756))
  call Hloop_QV_A(ntryL,G1H16(187),wf4(:,20),G1H4(344),m3h4x4(:,33),heltab2x16(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(344),43,0,G2H4(747),n2h4(757))
call HGT_OLR(G1H16(188),1,1,16)
call HGT_invQ_OLR(G1H16(188),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(188),-16,0,G2H16(27),n2h16(207))
  call Hloop_AV_Q(ntryL,G2H16(27),ex5(:),G2H8(146),m3h2x8(:,369),heltab2x16(:,:,402))
  call Hloop_QV_A(ntryL,G1H16(190),wf4(:,20),G1H4(349),m3h4x4(:,34),heltab2x16(:,:,403))
  call Hloop_Q_A(ntryL,G1H4(349),43,0,G2H4(748),n2h4(758))
  call Hloop_QV_A(ntryL,G1H16(191),wf4(:,20),G1H4(350),m3h4x4(:,35),heltab2x16(:,:,404))
  call Hloop_Q_A(ntryL,G1H4(350),43,0,G2H4(749),n2h4(759))
  call Hloop_QV_A(ntryL,G1H16(192),wf4(:,20),G1H4(355),m3h4x4(:,36),heltab2x16(:,:,405))
  call Hloop_Q_A(ntryL,G1H4(355),43,0,G2H4(750),n2h4(760))
  call Hloop_QV_A(ntryL,G1H16(193),wf4(:,20),G1H4(356),m3h4x4(:,37),heltab2x16(:,:,406))
  call Hloop_Q_A(ntryL,G1H4(356),43,nMT,G2H4(751),n2h4(761))
call HGT_OLR(G1H16(194),1,1,16)
call HGT_invQ_OLR(G1H16(194),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(194),-16,nMT,G2H16(28),n2h16(208))
  call Hloop_AV_Q(ntryL,G2H16(28),ex5(:),G2H8(111),m3h2x8(:,370),heltab2x16(:,:,407))
  call Hloop_QV_A(ntryL,G1H16(196),wf4(:,20),G1H4(361),m3h4x4(:,38),heltab2x16(:,:,408))
  call Hloop_Q_A(ntryL,G1H4(361),43,nMT,G2H4(752),n2h4(762))
  call Hloop_QV_A(ntryL,G1H16(197),wf4(:,20),G1H4(362),m3h4x4(:,39),heltab2x16(:,:,409))
  call Hloop_Q_A(ntryL,G1H4(362),43,nMT,G2H4(753),n2h4(763))
  call Hloop_QV_A(ntryL,G1H16(198),wf4(:,20),G1H4(366),m3h4x4(:,40),heltab2x16(:,:,410))
  call Hloop_Q_A(ntryL,G1H4(366),43,nMT,G2H4(754),n2h4(764))
  call Hloop_AV_Q(ntryL,G1H16(199),wf4(:,20),G1H4(367),m3h4x4(:,41),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(367),43,nMB,G2H4(755),n2h4(765))
call HGT_OLR(G1H16(200),1,1,16)
call HGT_invQ_OLR(G1H16(200),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(200),-16,nMB,G2H16(29),n2h16(209))
  call Hloop_QV_A(ntryL,G2H16(29),ex5(:),G2H8(63),m3h2x8(:,371),heltab2x16(:,:,412))
  call Hloop_AV_Q(ntryL,G1H16(202),wf4(:,20),G1H4(368),m3h4x4(:,42),heltab2x16(:,:,413))
  call Hloop_A_Q(ntryL,G1H4(368),43,nMB,G2H4(756),n2h4(766))
  call Hloop_AV_Q(ntryL,G1H16(203),wf4(:,20),G1H4(373),m3h4x4(:,43),heltab2x16(:,:,414))
  call Hloop_A_Q(ntryL,G1H4(373),43,nMB,G2H4(757),n2h4(767))
  call Hloop_AV_Q(ntryL,G1H16(204),wf4(:,20),G1H4(378),m3h4x4(:,44),heltab2x16(:,:,415))
  call Hloop_A_Q(ntryL,G1H4(378),43,nMB,G2H4(758),n2h4(768))
  call Hloop_QV_A(ntryL,G1H16(205),wf4(:,20),G1H4(379),m3h4x4(:,45),heltab2x16(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(379),43,nMB,G2H4(759),n2h4(769))
call HGT_OLR(G1H16(206),1,1,16)
call HGT_invQ_OLR(G1H16(206),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(206),-16,nMB,G2H16(30),n2h16(210))
  call Hloop_AV_Q(ntryL,G2H16(30),ex5(:),G2H8(64),m3h2x8(:,372),heltab2x16(:,:,417))
  call Hloop_QV_A(ntryL,G1H16(208),wf4(:,20),G1H4(380),m3h4x4(:,46),heltab2x16(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(380),43,nMB,G2H4(760),n2h4(770))
  call Hloop_QV_A(ntryL,G1H16(209),wf4(:,20),G1H4(385),m3h4x4(:,47),heltab2x16(:,:,419))
  call Hloop_Q_A(ntryL,G1H4(385),43,nMB,G2H4(761),n2h4(771))
  call Hloop_QV_A(ntryL,G1H16(210),wf4(:,20),G1H4(386),m3h4x4(:,48),heltab2x16(:,:,420))
  call Hloop_Q_A(ntryL,G1H4(386),43,nMB,G2H4(762),n2h4(772))
  call Hloop_QV_A(ntryL,G1H16(211),wf4(:,20),G1H4(390),m3h4x4(:,49),heltab2x16(:,:,421))
  call Hloop_Q_A(ntryL,G1H4(390),39,0,G2H4(763),n2h4(773))
call HGT_OLR(G1H16(212),1,1,16)
call HGT_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(212),-8,0,G2H16(31),n2h16(211))
  call Hloop_AV_Q(ntryL,G2H16(31),ex4(:),G2H8(65),m3h2x8(:,373),heltab2x16(:,:,422))
  call Hloop_QV_A(ntryL,G1H16(214),wf4(:,20),G1H4(391),m3h4x4(:,50),heltab2x16(:,:,423))
  call Hloop_Q_A(ntryL,G1H4(391),39,0,G2H4(764),n2h4(774))
  call Hloop_QV_A(ntryL,G1H16(215),wf4(:,20),G1H4(392),m3h4x4(:,51),heltab2x16(:,:,424))
  call Hloop_Q_A(ntryL,G1H4(392),39,0,G2H4(765),n2h4(775))
  call Hloop_QV_A(ntryL,G1H16(216),wf4(:,20),G1H4(398),m3h4x4(:,52),heltab2x16(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(398),39,0,G2H4(766),n2h4(776))
  call Hloop_QV_A(ntryL,G1H16(217),wf4(:,20),G1H4(402),m3h4x4(:,53),heltab2x16(:,:,426))
  call Hloop_Q_A(ntryL,G1H4(402),39,nMT,G2H4(767),n2h4(777))
call HGT_OLR(G1H16(218),1,1,16)
call HGT_invQ_OLR(G1H16(218),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(218),-8,nMT,G2H16(32),n2h16(212))
  call Hloop_AV_Q(ntryL,G2H16(32),ex4(:),G2H8(68),m3h2x8(:,374),heltab2x16(:,:,427))
  call Hloop_QV_A(ntryL,G1H16(220),wf4(:,20),G1H4(403),m3h4x4(:,54),heltab2x16(:,:,428))
  call Hloop_Q_A(ntryL,G1H4(403),39,nMT,G2H4(768),n2h4(778))
  call Hloop_QV_A(ntryL,G1H16(221),wf4(:,20),G1H4(404),m3h4x4(:,55),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G1H4(404),39,nMT,G2H4(769),n2h4(779))
  call Hloop_QV_A(ntryL,G1H16(222),wf4(:,20),G1H4(410),m3h4x4(:,56),heltab2x16(:,:,430))
  call Hloop_Q_A(ntryL,G1H4(410),39,nMT,G2H4(770),n2h4(780))
  call Hloop_AV_Q(ntryL,G1H16(223),wf4(:,20),G1H4(414),m3h4x4(:,57),heltab2x16(:,:,431))
  call Hloop_A_Q(ntryL,G1H4(414),39,0,G2H4(771),n2h4(781))
call HGT_OLR(G1H16(224),1,1,16)
call HGT_invQ_OLR(G1H16(224),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(224),-8,0,G2H16(33),n2h16(213))
  call Hloop_QV_A(ntryL,G2H16(33),ex4(:),G2H8(123),m3h2x8(:,375),heltab2x16(:,:,432))
  call Hloop_AV_Q(ntryL,G1H16(226),wf4(:,20),G1H4(415),m3h4x4(:,58),heltab2x16(:,:,433))
  call Hloop_A_Q(ntryL,G1H4(415),39,0,G2H4(772),n2h4(782))
  call Hloop_AV_Q(ntryL,G1H16(227),wf4(:,20),G1H4(416),m3h4x4(:,59),heltab2x16(:,:,434))
  call Hloop_A_Q(ntryL,G1H4(416),39,0,G2H4(773),n2h4(783))
  call Hloop_AV_Q(ntryL,G1H16(228),wf4(:,20),G1H4(422),m3h4x4(:,60),heltab2x16(:,:,435))
  call Hloop_A_Q(ntryL,G1H4(422),39,0,G2H4(774),n2h4(784))
  call Hloop_AV_Q(ntryL,G1H16(229),wf4(:,20),G1H4(426),m3h4x4(:,61),heltab2x16(:,:,436))
  call Hloop_A_Q(ntryL,G1H4(426),39,nMT,G2H4(775),n2h4(785))
call HGT_OLR(G1H16(230),1,1,16)
call HGT_invQ_OLR(G1H16(230),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(230),-8,nMT,G2H16(34),n2h16(214))
  call Hloop_QV_A(ntryL,G2H16(34),ex4(:),G2H8(126),m3h2x8(:,376),heltab2x16(:,:,437))
  call Hloop_AV_Q(ntryL,G1H16(232),wf4(:,20),G1H4(427),m3h4x4(:,62),heltab2x16(:,:,438))
  call Hloop_A_Q(ntryL,G1H4(427),39,nMT,G2H4(776),n2h4(786))
  call Hloop_AV_Q(ntryL,G1H16(233),wf4(:,20),G1H4(428),m3h4x4(:,63),heltab2x16(:,:,439))
  call Hloop_A_Q(ntryL,G1H4(428),39,nMT,G2H4(777),n2h4(787))
  call Hloop_AV_Q(ntryL,G1H16(234),wf4(:,20),G1H4(433),m3h4x4(:,64),heltab2x16(:,:,440))
  call Hloop_A_Q(ntryL,G1H4(433),39,nMT,G2H4(778),n2h4(788))
  call Hloop_QV_A(ntryL,G1H16(235),wf4(:,20),G1H4(434),m3h4x4(:,65),heltab2x16(:,:,441))
  call Hloop_Q_A(ntryL,G1H4(434),39,nMB,G2H4(779),n2h4(789))
call HGT_OLR(G1H16(236),1,1,16)
call HGT_invQ_OLR(G1H16(236),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(236),-8,nMB,G2H16(35),n2h16(215))
  call Hloop_AV_Q(ntryL,G2H16(35),ex4(:),G2H8(128),m3h2x8(:,377),heltab2x16(:,:,442))
  call Hloop_QV_A(ntryL,G1H16(238),wf4(:,20),G1H4(438),m3h4x4(:,66),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H4(438),39,nMB,G2H4(780),n2h4(790))
  call Hloop_QV_A(ntryL,G1H16(239),wf4(:,20),G1H4(439),m3h4x4(:,67),heltab2x16(:,:,444))
  call Hloop_Q_A(ntryL,G1H4(439),39,nMB,G2H4(781),n2h4(791))
  call Hloop_QV_A(ntryL,G1H16(240),wf4(:,20),G1H4(445),m3h4x4(:,68),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G1H4(445),39,nMB,G2H4(782),n2h4(792))
  call Hloop_AV_Q(ntryL,G1H16(241),wf4(:,20),G1H4(446),m3h4x4(:,69),heltab2x16(:,:,446))
  call Hloop_A_Q(ntryL,G1H4(446),39,nMB,G2H4(783),n2h4(793))
call HGT_OLR(G1H16(242),1,1,16)
call HGT_invQ_OLR(G1H16(242),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(242),-8,nMB,G2H16(36),n2h16(216))
  call Hloop_QV_A(ntryL,G2H16(36),ex4(:),G2H8(132),m3h2x8(:,378),heltab2x16(:,:,447))
  call Hloop_AV_Q(ntryL,G1H16(244),wf4(:,20),G1H4(450),m3h4x4(:,70),heltab2x16(:,:,448))
  call Hloop_A_Q(ntryL,G1H4(450),39,nMB,G2H4(784),n2h4(794))
  call Hloop_AV_Q(ntryL,G1H16(245),wf4(:,20),G1H4(451),m3h4x4(:,71),heltab2x16(:,:,449))
  call Hloop_A_Q(ntryL,G1H4(451),39,nMB,G2H4(785),n2h4(795))
  call Hloop_AV_Q(ntryL,G1H16(246),wf4(:,20),G1H4(452),m3h4x4(:,72),heltab2x16(:,:,450))
  call Hloop_A_Q(ntryL,G1H4(452),39,nMB,G2H4(786),n2h4(796))
  call Hloop_QV_A(ntryL,G1H16(247),wf4(:,20),G1H4(457),m3h4x4(:,73),heltab2x16(:,:,451))
  call Hloop_Q_A(ntryL,G1H4(457),39,0,G2H4(787),n2h4(797))
call HGT_OLR(G1H16(248),1,1,16)
call HGT_invQ_OLR(G1H16(248),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(248),-16,0,G2H16(1),n2h16(217))
  call Hloop_AV_Q(ntryL,G2H16(1),ex5(:),G2H8(91),m3h2x8(:,379),heltab2x16(:,:,452))
  call Hloop_QV_A(ntryL,G1H16(250),wf4(:,20),G1H4(458),m3h4x4(:,74),heltab2x16(:,:,453))
  call Hloop_Q_A(ntryL,G1H4(458),39,0,G2H4(788),n2h4(798))
  call Hloop_QV_A(ntryL,G1H16(251),wf4(:,20),G1H4(462),m3h4x4(:,75),heltab2x16(:,:,454))
  call Hloop_Q_A(ntryL,G1H4(462),39,0,G2H4(789),n2h4(799))
  call Hloop_QV_A(ntryL,G1H16(252),wf4(:,20),G1H4(464),m3h4x4(:,76),heltab2x16(:,:,455))
  call Hloop_Q_A(ntryL,G1H4(464),39,0,G2H4(790),n2h4(800))
  call Hloop_QV_A(ntryL,G1H16(253),wf4(:,20),G1H4(469),m3h4x4(:,77),heltab2x16(:,:,456))
  call Hloop_Q_A(ntryL,G1H4(469),39,nMT,G2H4(791),n2h4(801))
call HGT_OLR(G1H16(254),1,1,16)
call HGT_invQ_OLR(G1H16(254),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(254),-16,nMT,G2H16(2),n2h16(218))
  call Hloop_AV_Q(ntryL,G2H16(2),ex5(:),G2H8(96),m3h2x8(:,380),heltab2x16(:,:,457))
  call Hloop_QV_A(ntryL,G1H16(256),wf4(:,20),G1H4(470),m3h4x4(:,78),heltab2x16(:,:,458))
  call Hloop_Q_A(ntryL,G1H4(470),39,nMT,G2H4(792),n2h4(802))
  call Hloop_QV_A(ntryL,G1H16(257),wf4(:,20),G1H4(474),m3h4x4(:,79),heltab2x16(:,:,459))
  call Hloop_Q_A(ntryL,G1H4(474),39,nMT,G2H4(793),n2h4(803))
  call Hloop_QV_A(ntryL,G1H16(258),wf4(:,20),G1H4(476),m3h4x4(:,80),heltab2x16(:,:,460))
  call Hloop_Q_A(ntryL,G1H4(476),39,nMT,G2H4(794),n2h4(804))
  call Hloop_AV_Q(ntryL,G1H16(259),wf4(:,20),G1H4(481),m3h4x4(:,81),heltab2x16(:,:,461))
  call Hloop_A_Q(ntryL,G1H4(481),39,0,G2H4(795),n2h4(805))
call HGT_OLR(G1H16(260),1,1,16)
call HGT_invQ_OLR(G1H16(260),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(260),-16,0,G2H16(3),n2h16(219))
  call Hloop_QV_A(ntryL,G2H16(3),ex5(:),G2H8(149),m3h2x8(:,381),heltab2x16(:,:,462))
  call Hloop_AV_Q(ntryL,G1H16(262),wf4(:,20),G1H4(482),m3h4x4(:,82),heltab2x16(:,:,463))
  call Hloop_A_Q(ntryL,G1H4(482),39,0,G2H4(796),n2h4(806))
  call Hloop_AV_Q(ntryL,G1H16(263),wf4(:,20),G1H4(486),m3h4x4(:,83),heltab2x16(:,:,464))
  call Hloop_A_Q(ntryL,G1H4(486),39,0,G2H4(797),n2h4(807))
  call Hloop_AV_Q(ntryL,G1H16(264),wf4(:,20),G1H4(488),m3h4x4(:,84),heltab2x16(:,:,465))
  call Hloop_A_Q(ntryL,G1H4(488),39,0,G2H4(798),n2h4(808))
  call Hloop_AV_Q(ntryL,G1H16(265),wf4(:,20),G1H4(493),m3h4x4(:,85),heltab2x16(:,:,466))
  call Hloop_A_Q(ntryL,G1H4(493),39,nMT,G2H4(799),n2h4(809))
call HGT_OLR(G1H16(266),1,1,16)
call HGT_invQ_OLR(G1H16(266),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(266),-16,nMT,G2H16(4),n2h16(220))
  call Hloop_QV_A(ntryL,G2H16(4),ex5(:),G2H8(101),m3h2x8(:,382),heltab2x16(:,:,467))
  call Hloop_AV_Q(ntryL,G1H16(268),wf4(:,20),G1H4(494),m3h4x4(:,86),heltab2x16(:,:,468))
  call Hloop_A_Q(ntryL,G1H4(494),39,nMT,G2H4(800),n2h4(810))
  call Hloop_AV_Q(ntryL,G1H16(269),wf4(:,20),G1H4(498),m3h4x4(:,87),heltab2x16(:,:,469))
  call Hloop_A_Q(ntryL,G1H4(498),39,nMT,G2H4(801),n2h4(811))
  call Hloop_AV_Q(ntryL,G1H16(270),wf4(:,20),G1H4(500),m3h4x4(:,88),heltab2x16(:,:,470))
  call Hloop_A_Q(ntryL,G1H4(500),39,nMT,G2H4(802),n2h4(812))
  call Hloop_QV_A(ntryL,G1H16(271),wf4(:,20),G1H4(505),m3h4x4(:,89),heltab2x16(:,:,471))
  call Hloop_Q_A(ntryL,G1H4(505),39,nMB,G2H4(803),n2h4(813))
call HGT_OLR(G1H16(272),1,1,16)
call HGT_invQ_OLR(G1H16(272),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(272),-16,nMB,G2H16(5),n2h16(221))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(159),m3h2x8(:,383),heltab2x16(:,:,472))
  call Hloop_QV_A(ntryL,G1H16(274),wf4(:,20),G1H4(506),m3h4x4(:,90),heltab2x16(:,:,473))
  call Hloop_Q_A(ntryL,G1H4(506),39,nMB,G2H4(804),n2h4(814))
  call Hloop_QV_A(ntryL,G1H16(275),wf4(:,20),G1H4(510),m3h4x4(:,91),heltab2x16(:,:,474))
  call Hloop_Q_A(ntryL,G1H4(510),39,nMB,G2H4(805),n2h4(815))
  call Hloop_QV_A(ntryL,G1H16(276),wf4(:,20),G1H4(511),m3h4x4(:,92),heltab2x16(:,:,475))
  call Hloop_Q_A(ntryL,G1H4(511),39,nMB,G2H4(806),n2h4(816))
  call Hloop_AV_Q(ntryL,G1H16(277),wf4(:,20),G1H4(512),m3h4x4(:,93),heltab2x16(:,:,476))
  call Hloop_A_Q(ntryL,G1H4(512),39,nMB,G2H4(807),n2h4(817))
call HGT_OLR(G1H16(278),1,1,16)
call HGT_invQ_OLR(G1H16(278),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(278),-16,nMB,G2H16(6),n2h16(222))
  call Hloop_QV_A(ntryL,G2H16(6),ex5(:),G2H8(160),m3h2x8(:,384),heltab2x16(:,:,477))
  call Hloop_AV_Q(ntryL,G1H16(280),wf4(:,20),G1H4(517),m3h4x4(:,94),heltab2x16(:,:,478))
  call Hloop_A_Q(ntryL,G1H4(517),39,nMB,G2H4(808),n2h4(818))
  call Hloop_AV_Q(ntryL,G1H16(281),wf4(:,20),G1H4(518),m3h4x4(:,95),heltab2x16(:,:,479))
  call Hloop_A_Q(ntryL,G1H4(518),39,nMB,G2H4(809),n2h4(819))
  call Hloop_AV_Q(ntryL,G1H16(282),wf4(:,20),G1H4(523),m3h4x4(:,96),heltab2x16(:,:,480))
  call Hloop_A_Q(ntryL,G1H4(523),39,nMB,G2H4(810),n2h4(820))
  call Hloop_AV_Q(ntryL,G1H16(283),ex4(:),G1H8(301),m3h2x8(:,385),heltab2x16(:,:,481))
  call Hloop_A_Q(ntryL,G1H8(301),42,0,G2H8(161),n2h8(475))
call HGT_raise_alpha_OLR(G1H16(284),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(284),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(284),wf4(:,2),G1H4(524),m3h4x4(:,97),heltab2x16(:,:,482))
  call Hloop_AV_Q(ntryL,G1H16(286),ex4(:),G1H8(302),m3h2x8(:,386),heltab2x16(:,:,483))
  call Hloop_A_Q(ntryL,G1H8(302),42,0,G2H8(162),n2h8(476))
  call Hloop_AV_Q(ntryL,G1H16(287),ex4(:),G1H8(313),m3h2x8(:,387),heltab2x16(:,:,484))
  call Hloop_A_Q(ntryL,G1H8(313),42,0,G2H8(163),n2h8(477))
  call Hloop_AV_Q(ntryL,G1H16(288),ex4(:),G1H8(308),m3h2x8(:,388),heltab2x16(:,:,485))
  call Hloop_A_Q(ntryL,G1H8(308),42,0,G2H8(164),n2h8(478))
  call Hloop_AV_Q(ntryL,G1H16(109),ex4(:),G1H8(311),m3h2x8(:,389),heltab2x16(:,:,486))
  call Hloop_A_Q(ntryL,G1H8(311),42,0,G2H8(165),n2h8(479))
call HGT_raise_alpha_OLR(G1H16(110),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(110),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(110),-16,ex5(:),16,G2H8(166),m3h2x8(:,390),heltab2x16(:,:,487))
call signflip_OLR(G2H8(166))
  call Hloop_AV_Q(ntryL,G1H16(290),ex4(:),G1H8(312),m3h2x8(:,391),heltab2x16(:,:,488))
  call Hloop_A_Q(ntryL,G1H8(312),42,0,G2H8(167),n2h8(480))
  call Hloop_AV_Q(ntryL,G1H16(291),ex4(:),G1H8(314),m3h2x8(:,392),heltab2x16(:,:,489))
  call Hloop_A_Q(ntryL,G1H8(314),42,0,G2H8(168),n2h8(481))
  call Hloop_AV_Q(ntryL,G1H16(292),ex4(:),G1H8(318),m3h2x8(:,393),heltab2x16(:,:,490))
  call Hloop_A_Q(ntryL,G1H8(318),42,0,G2H8(169),n2h8(482))
  call Hloop_VA_Q(ntryL,G1H16(293),ex2(:),G1H8(319),m3h2x8(:,394),heltab2x16(:,:,491))
  call Hloop_A_Q(ntryL,G1H8(319),42,0,G2H8(170),n2h8(483))
call HGT_raise_alpha_OLR(G1H16(294),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(294),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(294),-16,ex5(:),16,G2H8(171),m3h2x8(:,395),heltab2x16(:,:,492))
call signflip_OLR(G2H8(171))
  call Hloop_VA_Q(ntryL,G1H16(296),ex2(:),G1H8(320),m3h2x8(:,396),heltab2x16(:,:,493))
  call Hloop_A_Q(ntryL,G1H8(320),42,0,G2H8(172),n2h8(484))
  call Hloop_VA_Q(ntryL,G1H16(297),ex2(:),G1H8(325),m3h2x8(:,397),heltab2x16(:,:,494))
  call Hloop_A_Q(ntryL,G1H8(325),42,0,G2H8(173),n2h8(485))
  call Hloop_VA_Q(ntryL,G1H16(298),ex2(:),G1H8(331),m3h2x8(:,398),heltab2x16(:,:,495))
  call Hloop_A_Q(ntryL,G1H8(331),42,0,G2H8(174),n2h8(486))
  call Hloop_AV_Q(ntryL,G1H16(299),ex5(:),G1H8(329),m3h2x8(:,399),heltab2x16(:,:,496))
  call Hloop_A_Q(ntryL,G1H8(329),50,0,G2H8(175),n2h8(487))
call HGT_raise_alpha_OLR(G1H16(300),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(300),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(300),wf4(:,2),G1H4(529),m3h4x4(:,98),heltab2x16(:,:,497))
  call Hloop_AV_Q(ntryL,G1H16(302),ex5(:),G1H8(330),m3h2x8(:,400),heltab2x16(:,:,498))
  call Hloop_A_Q(ntryL,G1H8(330),50,0,G2H8(176),n2h8(488))
  call Hloop_AV_Q(ntryL,G1H16(303),ex5(:),G1H8(332),m3h2x8(:,401),heltab2x16(:,:,499))
  call Hloop_A_Q(ntryL,G1H8(332),50,0,G2H8(177),n2h8(489))
  call Hloop_AV_Q(ntryL,G1H16(304),ex5(:),G1H8(335),m3h2x8(:,402),heltab2x16(:,:,500))
  call Hloop_A_Q(ntryL,G1H8(335),50,0,G2H8(178),n2h8(490))
  call Hloop_AV_Q(ntryL,G1H16(115),ex5(:),G1H8(336),m3h2x8(:,403),heltab2x16(:,:,501))
  call Hloop_A_Q(ntryL,G1H8(336),50,0,G2H8(179),n2h8(491))
call HGT_raise_alpha_OLR(G1H16(116),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(116),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(116),-8,ex4(:),8,G2H8(180),m3h2x8(:,404),heltab2x16(:,:,502))
call signflip_OLR(G2H8(180))
  call Hloop_AV_Q(ntryL,G1H16(306),ex5(:),G1H8(338),m3h2x8(:,405),heltab2x16(:,:,503))
  call Hloop_A_Q(ntryL,G1H8(338),50,0,G2H8(181),n2h8(492))
  call Hloop_AV_Q(ntryL,G1H16(307),ex5(:),G1H8(343),m3h2x8(:,406),heltab2x16(:,:,504))
  call Hloop_A_Q(ntryL,G1H8(343),50,0,G2H8(182),n2h8(493))
  call Hloop_AV_Q(ntryL,G1H16(308),ex5(:),G1H8(349),m3h2x8(:,407),heltab2x16(:,:,505))
  call Hloop_A_Q(ntryL,G1H8(349),50,0,G2H8(183),n2h8(494))
  call Hloop_VQ_A(ntryL,G1H16(309),wf4(:,2),G1H4(530),m3h4x4(:,99),heltab2x16(:,:,506))
  call Hloop_Q_A(ntryL,G1H4(530),45,0,G2H4(811),n2h4(821))
call HGT_raise_alpha_OLR(G1H16(310),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(310),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(310),-16,ex5(:),16,G2H8(184),m3h2x8(:,408),heltab2x16(:,:,507))
call signflip_OLR(G2H8(184))
  call Hloop_VQ_A(ntryL,G1H16(312),wf4(:,2),G1H4(535),m3h4x4(:,100),heltab2x16(:,:,508))
  call Hloop_Q_A(ntryL,G1H4(535),45,0,G2H4(812),n2h4(822))
  call Hloop_VQ_A(ntryL,G1H16(313),wf4(:,2),G1H4(536),m3h4x4(:,101),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G1H4(536),45,0,G2H4(813),n2h4(823))
  call Hloop_VQ_A(ntryL,G1H16(314),wf4(:,2),G1H4(541),m3h4x4(:,102),heltab2x16(:,:,510))
  call Hloop_Q_A(ntryL,G1H4(541),45,0,G2H4(814),n2h4(824))
  call Hloop_QV_A(ntryL,G1H16(120),ex4(:),G1H8(344),m3h2x8(:,409),heltab2x16(:,:,511))
  call Hloop_Q_A(ntryL,G1H8(344),41,0,G2H8(185),n2h8(495))
call HGT_raise_alpha_OLR(G1H16(122),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(122),wf4(:,4),G1H4(542),m3h4x4(:,103),heltab2x16(:,:,512))
  call Hloop_QV_A(ntryL,G1H16(316),ex4(:),G1H8(347),m3h2x8(:,410),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G1H8(347),41,0,G2H8(186),n2h8(496))
  call Hloop_QV_A(ntryL,G1H16(317),ex4(:),G1H8(350),m3h2x8(:,411),heltab2x16(:,:,514))
  call Hloop_Q_A(ntryL,G1H8(350),41,0,G2H8(187),n2h8(497))
  call Hloop_QV_A(ntryL,G1H16(318),ex4(:),G1H8(353),m3h2x8(:,412),heltab2x16(:,:,515))
  call Hloop_Q_A(ntryL,G1H8(353),41,0,G2H8(188),n2h8(498))
  call Hloop_QV_A(ntryL,G1H16(126),ex4(:),G1H8(354),m3h2x8(:,413),heltab2x16(:,:,516))
  call Hloop_Q_A(ntryL,G1H8(354),41,0,G2H8(189),n2h8(499))
call HGT_raise_alpha_OLR(G1H16(127),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(127),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(127),-16,ex5(:),16,G2H8(190),m3h2x8(:,414),heltab2x16(:,:,517))
call signflip_OLR(G2H8(190))
  call Hloop_QV_A(ntryL,G1H16(320),ex4(:),G1H8(355),m3h2x8(:,415),heltab2x16(:,:,518))
  call Hloop_Q_A(ntryL,G1H8(355),41,0,G2H8(191),n2h8(500))
  call Hloop_QV_A(ntryL,G1H16(321),ex4(:),G1H8(356),m3h2x8(:,416),heltab2x16(:,:,519))
  call Hloop_Q_A(ntryL,G1H8(356),41,0,G2H8(192),n2h8(501))
  call Hloop_QV_A(ntryL,G1H16(322),ex4(:),G1H8(367),m3h2x8(:,417),heltab2x16(:,:,520))
  call Hloop_Q_A(ntryL,G1H8(367),41,0,G2H8(193),n2h8(502))
  call Hloop_VQ_A(ntryL,G1H16(323),ex1(:),G1H8(362),m3h2x8(:,418),heltab2x16(:,:,521))
  call Hloop_Q_A(ntryL,G1H8(362),41,0,G2H8(194),n2h8(503))
call HGT_raise_alpha_OLR(G1H16(324),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(324),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(324),-16,ex5(:),16,G2H8(195),m3h2x8(:,419),heltab2x16(:,:,522))
call signflip_OLR(G2H8(195))
  call Hloop_VQ_A(ntryL,G1H16(326),ex1(:),G1H8(365),m3h2x8(:,420),heltab2x16(:,:,523))
  call Hloop_Q_A(ntryL,G1H8(365),41,0,G2H8(196),n2h8(504))
  call Hloop_VQ_A(ntryL,G1H16(327),ex1(:),G1H8(366),m3h2x8(:,421),heltab2x16(:,:,524))
  call Hloop_Q_A(ntryL,G1H8(366),41,0,G2H8(197),n2h8(505))
  call Hloop_VQ_A(ntryL,G1H16(328),ex1(:),G1H8(368),m3h2x8(:,422),heltab2x16(:,:,525))
  call Hloop_Q_A(ntryL,G1H8(368),41,0,G2H8(198),n2h8(506))
  call Hloop_QV_A(ntryL,G1H16(329),ex5(:),G1H8(372),m3h2x8(:,423),heltab2x16(:,:,526))
  call Hloop_Q_A(ntryL,G1H8(372),49,0,G2H8(199),n2h8(507))
call HGT_raise_alpha_OLR(G1H16(330),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(330),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(330),wf4(:,4),G1H4(546),m3h4x4(:,104),heltab2x16(:,:,527))
  call Hloop_QV_A(ntryL,G1H16(332),ex5(:),G1H8(373),m3h2x8(:,424),heltab2x16(:,:,528))
  call Hloop_Q_A(ntryL,G1H8(373),49,0,G2H8(200),n2h8(508))
  call Hloop_QV_A(ntryL,G1H16(333),ex5(:),G1H8(374),m3h2x8(:,425),heltab2x16(:,:,529))
  call Hloop_Q_A(ntryL,G1H8(374),49,0,G2H8(201),n2h8(509))
  call Hloop_QV_A(ntryL,G1H16(334),ex5(:),G1H8(379),m3h2x8(:,426),heltab2x16(:,:,530))
  call Hloop_Q_A(ntryL,G1H8(379),49,0,G2H8(202),n2h8(510))
  call Hloop_QV_A(ntryL,G1H16(129),ex5(:),G1H8(385),m3h2x8(:,427),heltab2x16(:,:,531))
  call Hloop_Q_A(ntryL,G1H8(385),49,0,G2H8(203),n2h8(511))
call HGT_raise_alpha_OLR(G1H16(130),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(130),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(130),-8,ex4(:),8,G2H8(204),m3h2x8(:,428),heltab2x16(:,:,532))
call signflip_OLR(G2H8(204))
  call Hloop_QV_A(ntryL,G1H16(336),ex5(:),G1H8(383),m3h2x8(:,429),heltab2x16(:,:,533))
  call Hloop_Q_A(ntryL,G1H8(383),49,0,G2H8(205),n2h8(512))
  call Hloop_QV_A(ntryL,G1H16(337),ex5(:),G1H8(384),m3h2x8(:,430),heltab2x16(:,:,534))
  call Hloop_Q_A(ntryL,G1H8(384),49,0,G2H8(206),n2h8(513))
  call Hloop_QV_A(ntryL,G1H16(338),ex5(:),G1H8(386),m3h2x8(:,431),heltab2x16(:,:,535))
  call Hloop_Q_A(ntryL,G1H8(386),49,0,G2H8(207),n2h8(514))
  call Hloop_VA_Q(ntryL,G1H16(339),wf4(:,4),G1H4(547),m3h4x4(:,105),heltab2x16(:,:,536))
  call Hloop_A_Q(ntryL,G1H4(547),46,0,G2H4(815),n2h4(825))
call HGT_raise_alpha_OLR(G1H16(340),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(340),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(340),-16,ex5(:),16,G2H8(208),m3h2x8(:,432),heltab2x16(:,:,537))
call signflip_OLR(G2H8(208))
  call Hloop_VA_Q(ntryL,G1H16(342),wf4(:,4),G1H4(548),m3h4x4(:,106),heltab2x16(:,:,538))
  call Hloop_A_Q(ntryL,G1H4(548),46,0,G2H4(816),n2h4(826))
  call Hloop_VA_Q(ntryL,G1H16(343),wf4(:,4),G1H4(553),m3h4x4(:,107),heltab2x16(:,:,539))
  call Hloop_A_Q(ntryL,G1H4(553),46,0,G2H4(817),n2h4(827))
  call Hloop_VA_Q(ntryL,G1H16(344),wf4(:,4),G1H4(554),m3h4x4(:,108),heltab2x16(:,:,540))
  call Hloop_A_Q(ntryL,G1H4(554),46,0,G2H4(818),n2h4(828))
  call Hloop_AV_Q(ntryL,G1H16(132),ex3(:),G1H8(389),m3h2x8(:,433),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H8(389),38,0,G2H8(209),n2h8(515))
call HGT_raise_alpha_OLR(G1H16(135),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(135),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(135),wf4(:,15),G1H4(559),m3h4x4(:,109),heltab2x16(:,:,542))
  call Hloop_AV_Q(ntryL,G1H16(346),ex3(:),G1H8(390),m3h2x8(:,434),heltab2x16(:,:,543))
  call Hloop_A_Q(ntryL,G1H8(390),38,0,G2H8(210),n2h8(516))
  call Hloop_AV_Q(ntryL,G1H16(347),ex3(:),G1H8(392),m3h2x8(:,435),heltab2x16(:,:,544))
  call Hloop_A_Q(ntryL,G1H8(392),38,0,G2H8(211),n2h8(517))
  call Hloop_AV_Q(ntryL,G1H16(348),ex3(:),G1H8(397),m3h2x8(:,436),heltab2x16(:,:,545))
  call Hloop_A_Q(ntryL,G1H8(397),38,0,G2H8(212),n2h8(518))
  call Hloop_AV_Q(ntryL,G1H16(349),ex3(:),G1H8(403),m3h2x8(:,437),heltab2x16(:,:,546))
  call Hloop_A_Q(ntryL,G1H8(403),38,0,G2H8(213),n2h8(519))
call HGT_raise_alpha_OLR(G1H16(350),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(350),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(350),-16,ex5(:),16,G2H8(214),m3h2x8(:,438),heltab2x16(:,:,547))
call signflip_OLR(G2H8(214))
  call Hloop_AV_Q(ntryL,G1H16(352),ex3(:),G1H8(398),m3h2x8(:,439),heltab2x16(:,:,548))
  call Hloop_A_Q(ntryL,G1H8(398),38,0,G2H8(215),n2h8(520))
  call Hloop_AV_Q(ntryL,G1H16(353),ex3(:),G1H8(401),m3h2x8(:,440),heltab2x16(:,:,549))
  call Hloop_A_Q(ntryL,G1H8(401),38,0,G2H8(216),n2h8(521))
  call Hloop_AV_Q(ntryL,G1H16(354),ex3(:),G1H8(404),m3h2x8(:,441),heltab2x16(:,:,550))
  call Hloop_A_Q(ntryL,G1H8(404),38,0,G2H8(217),n2h8(522))
  call Hloop_AV_Q(ntryL,G1H16(355),ex5(:),G1H8(407),m3h2x8(:,442),heltab2x16(:,:,551))
  call Hloop_A_Q(ntryL,G1H8(407),50,0,G2H8(218),n2h8(523))
call HGT_raise_alpha_OLR(G1H16(356),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(356),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(356),wf4(:,15),G1H4(560),m3h4x4(:,110),heltab2x16(:,:,552))
  call Hloop_AV_Q(ntryL,G1H16(358),ex5(:),G1H8(408),m3h2x8(:,443),heltab2x16(:,:,553))
  call Hloop_A_Q(ntryL,G1H8(408),50,0,G2H8(219),n2h8(524))
  call Hloop_AV_Q(ntryL,G1H16(359),ex5(:),G1H8(409),m3h2x8(:,444),heltab2x16(:,:,554))
  call Hloop_A_Q(ntryL,G1H8(409),50,0,G2H8(220),n2h8(525))
  call Hloop_AV_Q(ntryL,G1H16(360),ex5(:),G1H8(410),m3h2x8(:,445),heltab2x16(:,:,555))
  call Hloop_A_Q(ntryL,G1H8(410),50,0,G2H8(221),n2h8(526))
  call Hloop_QV_A(ntryL,G1H16(142),ex5(:),G1H8(421),m3h2x8(:,446),heltab2x16(:,:,556))
  call Hloop_Q_A(ntryL,G1H8(421),52,0,G2H8(222),n2h8(527))
call HGT_OLR(G1H16(361),1,1,16)
call HGT_invQ_OLR(G1H16(361),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(361),-9,0,G2H16(37),n2h16(238))
  call Hloop_AQ_V(ntryL,G2H16(37),wf4(:,15),G2H4(819),m3h4x4(:,111),heltab2x16(:,:,557))
  call Hloop_QV_A(ntryL,G1H16(363),ex5(:),G1H8(416),m3h2x8(:,447),heltab2x16(:,:,558))
  call Hloop_Q_A(ntryL,G1H8(416),52,0,G2H8(223),n2h8(528))
  call Hloop_QV_A(ntryL,G1H16(364),ex5(:),G1H8(419),m3h2x8(:,448),heltab2x16(:,:,559))
  call Hloop_Q_A(ntryL,G1H8(419),52,0,G2H8(224),n2h8(529))
  call Hloop_QV_A(ntryL,G1H16(365),ex5(:),G1H8(420),m3h2x8(:,449),heltab2x16(:,:,560))
  call Hloop_Q_A(ntryL,G1H8(420),52,0,G2H8(225),n2h8(530))
  call Hloop_QV_A(ntryL,G1H16(146),ex3(:),G1H8(422),m3h2x8(:,450),heltab2x16(:,:,561))
  call Hloop_Q_A(ntryL,G1H8(422),37,0,G2H8(226),n2h8(531))
call HGT_raise_alpha_OLR(G1H16(147),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(147),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(147),wf4(:,7),G1H4(564),m3h4x4(:,112),heltab2x16(:,:,562))
  call Hloop_QV_A(ntryL,G1H16(367),ex3(:),G1H8(426),m3h2x8(:,451),heltab2x16(:,:,563))
  call Hloop_Q_A(ntryL,G1H8(426),37,0,G2H8(227),n2h8(532))
  call Hloop_QV_A(ntryL,G1H16(368),ex3(:),G1H8(427),m3h2x8(:,452),heltab2x16(:,:,564))
  call Hloop_Q_A(ntryL,G1H8(427),37,0,G2H8(228),n2h8(533))
  call Hloop_QV_A(ntryL,G1H16(369),ex3(:),G1H8(428),m3h2x8(:,453),heltab2x16(:,:,565))
  call Hloop_Q_A(ntryL,G1H8(428),37,0,G2H8(229),n2h8(534))
  call Hloop_QV_A(ntryL,G1H16(370),ex3(:),G1H8(433),m3h2x8(:,454),heltab2x16(:,:,566))
  call Hloop_Q_A(ntryL,G1H8(433),37,0,G2H8(230),n2h8(535))
call HGT_raise_alpha_OLR(G1H16(371),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(371),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(371),-16,ex5(:),16,G2H8(231),m3h2x8(:,455),heltab2x16(:,:,567))
call signflip_OLR(G2H8(231))
  call Hloop_QV_A(ntryL,G1H16(373),ex3(:),G1H8(439),m3h2x8(:,456),heltab2x16(:,:,568))
  call Hloop_Q_A(ntryL,G1H8(439),37,0,G2H8(232),n2h8(536))
  call Hloop_QV_A(ntryL,G1H16(374),ex3(:),G1H8(437),m3h2x8(:,457),heltab2x16(:,:,569))
  call Hloop_Q_A(ntryL,G1H8(437),37,0,G2H8(233),n2h8(537))
  call Hloop_QV_A(ntryL,G1H16(375),ex3(:),G1H8(438),m3h2x8(:,458),heltab2x16(:,:,570))
  call Hloop_Q_A(ntryL,G1H8(438),37,0,G2H8(234),n2h8(538))
  call Hloop_QV_A(ntryL,G1H16(376),ex5(:),G1H8(440),m3h2x8(:,459),heltab2x16(:,:,571))
  call Hloop_Q_A(ntryL,G1H8(440),49,0,G2H8(235),n2h8(539))
call HGT_raise_alpha_OLR(G1H16(377),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(377),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(377),wf4(:,7),G1H4(565),m3h4x4(:,113),heltab2x16(:,:,572))
  call Hloop_QV_A(ntryL,G1H16(379),ex5(:),G1H8(443),m3h2x8(:,460),heltab2x16(:,:,573))
  call Hloop_Q_A(ntryL,G1H8(443),49,0,G2H8(236),n2h8(540))
  call Hloop_QV_A(ntryL,G1H16(380),ex5(:),G1H8(444),m3h2x8(:,461),heltab2x16(:,:,574))
  call Hloop_Q_A(ntryL,G1H8(444),49,0,G2H8(237),n2h8(541))
  call Hloop_QV_A(ntryL,G1H16(381),ex5(:),G1H8(446),m3h2x8(:,462),heltab2x16(:,:,575))
  call Hloop_Q_A(ntryL,G1H8(446),49,0,G2H8(238),n2h8(542))
  call Hloop_AV_Q(ntryL,G1H16(24),ex5(:),G1H8(451),m3h2x8(:,463),heltab2x16(:,:,576))
  call Hloop_A_Q(ntryL,G1H8(451),52,0,G2H8(239),n2h8(543))
call HGT_OLR(G1H16(382),1,1,16)
call HGT_invQ_OLR(G1H16(382),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(382),-10,0,G2H16(38),n2h16(242))
  call Hloop_QA_V(ntryL,G2H16(38),wf4(:,7),G2H4(820),m3h4x4(:,114),heltab2x16(:,:,577))
  call Hloop_AV_Q(ntryL,G1H16(384),ex5(:),G1H8(457),m3h2x8(:,464),heltab2x16(:,:,578))
  call Hloop_A_Q(ntryL,G1H8(457),52,0,G2H8(240),n2h8(544))
  call Hloop_AV_Q(ntryL,G1H16(385),ex5(:),G1H8(452),m3h2x8(:,465),heltab2x16(:,:,579))
  call Hloop_A_Q(ntryL,G1H8(452),52,0,G2H8(241),n2h8(545))
  call Hloop_AV_Q(ntryL,G1H16(386),ex5(:),G1H8(455),m3h2x8(:,466),heltab2x16(:,:,580))
  call Hloop_A_Q(ntryL,G1H8(455),52,0,G2H8(242),n2h8(546))
  call Hloop_VA_Q(ntryL,G1H16(155),ex2(:),G1H8(458),m3h2x8(:,467),heltab2x16(:,:,581))
  call Hloop_A_Q(ntryL,G1H8(458),42,0,G2H8(243),n2h8(547))
call HGT_raise_alpha_OLR(G1H16(156),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(156),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(156),wf4(:,17),G1H4(570),m3h4x4(:,115),heltab2x16(:,:,582))
  call Hloop_VA_Q(ntryL,G1H16(388),ex2(:),G1H8(461),m3h2x8(:,468),heltab2x16(:,:,583))
  call Hloop_A_Q(ntryL,G1H8(461),42,0,G2H8(244),n2h8(548))
  call Hloop_VA_Q(ntryL,G1H16(389),ex2(:),G1H8(462),m3h2x8(:,469),heltab2x16(:,:,584))
  call Hloop_A_Q(ntryL,G1H8(462),42,0,G2H8(245),n2h8(549))
  call Hloop_VA_Q(ntryL,G1H16(390),ex2(:),G1H8(463),m3h2x8(:,470),heltab2x16(:,:,585))
  call Hloop_A_Q(ntryL,G1H8(463),42,0,G2H8(246),n2h8(550))
  call Hloop_AV_Q(ntryL,G1H16(391),ex3(:),G1H8(464),m3h2x8(:,471),heltab2x16(:,:,586))
  call Hloop_A_Q(ntryL,G1H8(464),38,0,G2H8(247),n2h8(551))
call HGT_raise_alpha_OLR(G1H16(392),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(392),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(392),wf4(:,17),G1H4(571),m3h4x4(:,116),heltab2x16(:,:,587))
  call Hloop_AV_Q(ntryL,G1H16(394),ex3(:),G1H8(475),m3h2x8(:,472),heltab2x16(:,:,588))
  call Hloop_A_Q(ntryL,G1H8(475),38,0,G2H8(248),n2h8(552))
  call Hloop_AV_Q(ntryL,G1H16(395),ex3(:),G1H8(470),m3h2x8(:,473),heltab2x16(:,:,589))
  call Hloop_A_Q(ntryL,G1H8(470),38,0,G2H8(249),n2h8(553))
  call Hloop_AV_Q(ntryL,G1H16(396),ex3(:),G1H8(473),m3h2x8(:,474),heltab2x16(:,:,590))
  call Hloop_A_Q(ntryL,G1H8(473),38,0,G2H8(250),n2h8(554))
  call Hloop_AV_Q(ntryL,G1H16(397),ex3(:),G1H8(474),m3h2x8(:,475),heltab2x16(:,:,591))
  call Hloop_A_Q(ntryL,G1H8(474),38,0,G2H8(251),n2h8(555))
call HGT_raise_alpha_OLR(G1H16(398),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(398),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(398),-8,ex4(:),8,G2H8(252),m3h2x8(:,476),heltab2x16(:,:,592))
call signflip_OLR(G2H8(252))
  call Hloop_AV_Q(ntryL,G1H16(400),ex3(:),G1H8(476),m3h2x8(:,477),heltab2x16(:,:,593))
  call Hloop_A_Q(ntryL,G1H8(476),38,0,G2H8(253),n2h8(556))
  call Hloop_AV_Q(ntryL,G1H16(401),ex3(:),G1H8(480),m3h2x8(:,478),heltab2x16(:,:,594))
  call Hloop_A_Q(ntryL,G1H8(480),38,0,G2H8(254),n2h8(557))
  call Hloop_AV_Q(ntryL,G1H16(402),ex3(:),G1H8(481),m3h2x8(:,479),heltab2x16(:,:,595))
  call Hloop_A_Q(ntryL,G1H8(481),38,0,G2H8(255),n2h8(558))
  call Hloop_QV_A(ntryL,G1H16(403),ex3(:),G1H8(482),m3h2x8(:,480),heltab2x16(:,:,596))
  call Hloop_Q_A(ntryL,G1H8(482),44,0,G2H8(256),n2h8(559))
call HGT_OLR(G1H16(404),1,1,16)
call HGT_invQ_OLR(G1H16(404),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(404),-17,0,G2H16(39),n2h16(246))
  call Hloop_AQ_V(ntryL,G2H16(39),wf4(:,17),G2H4(821),m3h4x4(:,117),heltab2x16(:,:,597))
  call Hloop_QV_A(ntryL,G1H16(406),ex3(:),G1H8(487),m3h2x8(:,481),heltab2x16(:,:,598))
  call Hloop_Q_A(ntryL,G1H8(487),44,0,G2H8(257),n2h8(560))
  call Hloop_QV_A(ntryL,G1H16(407),ex3(:),G1H8(493),m3h2x8(:,482),heltab2x16(:,:,599))
  call Hloop_Q_A(ntryL,G1H8(493),44,0,G2H8(258),n2h8(561))
  call Hloop_QV_A(ntryL,G1H16(408),ex3(:),G1H8(491),m3h2x8(:,483),heltab2x16(:,:,600))
  call Hloop_Q_A(ntryL,G1H8(491),44,0,G2H8(259),n2h8(562))
  call Hloop_AV_Q(ntryL,G1H16(409),ex4(:),G1H8(492),m3h2x8(:,484),heltab2x16(:,:,601))
  call Hloop_A_Q(ntryL,G1H8(492),42,0,G2H8(260),n2h8(563))
call HGT_raise_alpha_OLR(G1H16(410),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(410),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(410),wf4(:,17),G1H4(576),m3h4x4(:,118),heltab2x16(:,:,602))
  call Hloop_AV_Q(ntryL,G1H16(412),ex4(:),G1H8(494),m3h2x8(:,485),heltab2x16(:,:,603))
  call Hloop_A_Q(ntryL,G1H8(494),42,0,G2H8(261),n2h8(564))
  call Hloop_AV_Q(ntryL,G1H16(413),ex4(:),G1H8(497),m3h2x8(:,486),heltab2x16(:,:,604))
  call Hloop_A_Q(ntryL,G1H8(497),42,0,G2H8(262),n2h8(565))
  call Hloop_AV_Q(ntryL,G1H16(414),ex4(:),G1H8(498),m3h2x8(:,487),heltab2x16(:,:,605))
  call Hloop_A_Q(ntryL,G1H8(498),42,0,G2H8(263),n2h8(566))
  call Hloop_QV_A(ntryL,G1H16(79),ex4(:),G1H8(216),m3h2x8(:,488),heltab2x16(:,:,606))
  call Hloop_Q_A(ntryL,G1H8(216),44,0,G2H8(264),n2h8(567))
call HGT_OLR(G1H16(415),1,1,16)
call HGT_invQ_OLR(G1H16(415),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(415),-17,0,G2H16(40),n2h16(248))
  call Hloop_AQ_V(ntryL,G2H16(40),wf4(:,17),G2H4(822),m3h4x4(:,119),heltab2x16(:,:,607))
  call Hloop_QV_A(ntryL,G1H16(417),ex4(:),G1H8(233),m3h2x8(:,489),heltab2x16(:,:,608))
  call Hloop_Q_A(ntryL,G1H8(233),44,0,G2H8(265),n2h8(568))
  call Hloop_QV_A(ntryL,G1H16(418),ex4(:),G1H8(234),m3h2x8(:,490),heltab2x16(:,:,609))
  call Hloop_Q_A(ntryL,G1H8(234),44,0,G2H8(266),n2h8(569))
  call Hloop_QV_A(ntryL,G1H16(419),ex4(:),G1H8(251),m3h2x8(:,491),heltab2x16(:,:,610))
  call Hloop_Q_A(ntryL,G1H8(251),44,0,G2H8(267),n2h8(570))
  call Hloop_VQ_A(ntryL,G1H16(95),ex1(:),G1H8(252),m3h2x8(:,492),heltab2x16(:,:,611))
  call Hloop_Q_A(ntryL,G1H8(252),41,0,G2H8(268),n2h8(571))
call HGT_raise_alpha_OLR(G1H16(101),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(101),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(101),wf4(:,10),G1H4(577),m3h4x4(:,120),heltab2x16(:,:,612))
  call Hloop_VQ_A(ntryL,G1H16(421),ex1(:),G1H8(270),m3h2x8(:,493),heltab2x16(:,:,613))
  call Hloop_Q_A(ntryL,G1H8(270),41,0,G2H8(269),n2h8(572))
  call Hloop_VQ_A(ntryL,G1H16(422),ex1(:),G1H8(287),m3h2x8(:,494),heltab2x16(:,:,614))
  call Hloop_Q_A(ntryL,G1H8(287),41,0,G2H8(270),n2h8(573))
  call Hloop_VQ_A(ntryL,G1H16(423),ex1(:),G1H8(288),m3h2x8(:,495),heltab2x16(:,:,615))
  call Hloop_Q_A(ntryL,G1H8(288),41,0,G2H8(271),n2h8(574))
  call Hloop_QV_A(ntryL,G1H16(424),ex3(:),G1H8(305),m3h2x8(:,496),heltab2x16(:,:,616))
  call Hloop_Q_A(ntryL,G1H8(305),37,0,G2H8(272),n2h8(575))
call HGT_raise_alpha_OLR(G1H16(425),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(425),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(425),wf4(:,10),G1H4(581),m3h4x4(:,121),heltab2x16(:,:,617))
  call Hloop_QV_A(ntryL,G1H16(427),ex3(:),G1H8(306),m3h2x8(:,497),heltab2x16(:,:,618))
  call Hloop_Q_A(ntryL,G1H8(306),37,0,G2H8(273),n2h8(576))
  call Hloop_QV_A(ntryL,G1H16(428),ex3(:),G1H8(324),m3h2x8(:,498),heltab2x16(:,:,619))
  call Hloop_Q_A(ntryL,G1H8(324),37,0,G2H8(274),n2h8(577))
  call Hloop_QV_A(ntryL,G1H16(429),ex3(:),G1H8(341),m3h2x8(:,499),heltab2x16(:,:,620))
  call Hloop_Q_A(ntryL,G1H8(341),37,0,G2H8(275),n2h8(578))
  call Hloop_QV_A(ntryL,G1H16(430),ex3(:),G1H8(342),m3h2x8(:,500),heltab2x16(:,:,621))
  call Hloop_Q_A(ntryL,G1H8(342),37,0,G2H8(276),n2h8(579))
call HGT_raise_alpha_OLR(G1H16(431),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(431),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(431),-8,ex4(:),8,G2H8(277),m3h2x8(:,501),heltab2x16(:,:,622))
call signflip_OLR(G2H8(277))
  call Hloop_QV_A(ntryL,G1H16(433),ex3(:),G1H8(359),m3h2x8(:,502),heltab2x16(:,:,623))
  call Hloop_Q_A(ntryL,G1H8(359),37,0,G2H8(278),n2h8(580))
  call Hloop_QV_A(ntryL,G1H16(434),ex3(:),G1H8(360),m3h2x8(:,503),heltab2x16(:,:,624))
  call Hloop_Q_A(ntryL,G1H8(360),37,0,G2H8(279),n2h8(581))
  call Hloop_QV_A(ntryL,G1H16(435),ex3(:),G1H8(378),m3h2x8(:,504),heltab2x16(:,:,625))
  call Hloop_Q_A(ntryL,G1H8(378),37,0,G2H8(280),n2h8(582))
  call Hloop_AV_Q(ntryL,G1H16(436),ex3(:),G1H8(395),m3h2x8(:,505),heltab2x16(:,:,626))
  call Hloop_A_Q(ntryL,G1H8(395),44,0,G2H8(281),n2h8(583))
call HGT_OLR(G1H16(437),1,1,16)
call HGT_invQ_OLR(G1H16(437),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(437),-18,0,G2H16(41),n2h16(252))
  call Hloop_QA_V(ntryL,G2H16(41),wf4(:,10),G2H4(823),m3h4x4(:,122),heltab2x16(:,:,627))
  call Hloop_AV_Q(ntryL,G1H16(439),ex3(:),G1H8(396),m3h2x8(:,506),heltab2x16(:,:,628))
  call Hloop_A_Q(ntryL,G1H8(396),44,0,G2H8(282),n2h8(584))
  call Hloop_AV_Q(ntryL,G1H16(440),ex3(:),G1H8(413),m3h2x8(:,507),heltab2x16(:,:,629))
  call Hloop_A_Q(ntryL,G1H8(413),44,0,G2H8(283),n2h8(585))
  call Hloop_AV_Q(ntryL,G1H16(441),ex3(:),G1H8(414),m3h2x8(:,508),heltab2x16(:,:,630))
  call Hloop_A_Q(ntryL,G1H8(414),44,0,G2H8(284),n2h8(586))
  call Hloop_QV_A(ntryL,G1H16(442),ex4(:),G1H8(432),m3h2x8(:,509),heltab2x16(:,:,631))
  call Hloop_Q_A(ntryL,G1H8(432),41,0,G2H8(285),n2h8(587))
call HGT_raise_alpha_OLR(G1H16(443),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(443),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(443),wf4(:,10),G1H4(582),m3h4x4(:,123),heltab2x16(:,:,632))
  call Hloop_QV_A(ntryL,G1H16(445),ex4(:),G1H8(449),m3h2x8(:,510),heltab2x16(:,:,633))
  call Hloop_Q_A(ntryL,G1H8(449),41,0,G2H8(286),n2h8(588))
  call Hloop_QV_A(ntryL,G1H16(446),ex4(:),G1H8(450),m3h2x8(:,511),heltab2x16(:,:,634))
  call Hloop_Q_A(ntryL,G1H8(450),41,0,G2H8(287),n2h8(589))
  call Hloop_QV_A(ntryL,G1H16(447),ex4(:),G1H8(467),m3h2x8(:,512),heltab2x16(:,:,635))
  call Hloop_Q_A(ntryL,G1H8(467),41,0,G2H8(288),n2h8(590))
  call Hloop_AV_Q(ntryL,G1H16(38),ex4(:),G1H8(468),m3h2x8(:,513),heltab2x16(:,:,636))
  call Hloop_A_Q(ntryL,G1H8(468),44,0,G2H8(289),n2h8(591))
call HGT_OLR(G1H16(448),1,1,16)
call HGT_invQ_OLR(G1H16(448),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(448),-18,0,G2H16(42),n2h16(254))
  call Hloop_QA_V(ntryL,G2H16(42),wf4(:,10),G2H4(824),m3h4x4(:,124),heltab2x16(:,:,637))
  call Hloop_AV_Q(ntryL,G1H16(450),ex4(:),G1H8(486),m3h2x8(:,514),heltab2x16(:,:,638))
  call Hloop_A_Q(ntryL,G1H8(486),44,0,G2H8(290),n2h8(592))
  call Hloop_AV_Q(ntryL,G1H16(451),ex4(:),G1H8(7),m3h2x8(:,515),heltab2x16(:,:,639))
  call Hloop_A_Q(ntryL,G1H8(7),44,0,G2H8(291),n2h8(593))
  call Hloop_AV_Q(ntryL,G1H16(452),ex4(:),G1H8(8),m3h2x8(:,516),heltab2x16(:,:,640))
  call Hloop_A_Q(ntryL,G1H8(8),44,0,G2H8(292),n2h8(594))
  call Hloop_QV_A(ntryL,G1H16(43),ex3(:),G1H8(11),m3h2x8(:,517),heltab2x16(:,:,641))
  call Hloop_Q_A(ntryL,G1H8(11),37,0,G2H8(293),n2h8(595))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(1),-24,wf4(:,12),24,G2H4(825),m3h4x4(:,125),heltab2x16(:,:,642))
call signflip_OLR(G2H4(825))
  call Hloop_QV_A(ntryL,G1H16(32),ex3(:),G1H8(12),m3h2x8(:,518),heltab2x16(:,:,643))
  call Hloop_Q_A(ntryL,G1H8(12),37,0,G2H8(294),n2h8(596))
  call Hloop_QV_A(ntryL,G1H16(2),ex3(:),G1H8(14),m3h2x8(:,519),heltab2x16(:,:,644))
  call Hloop_Q_A(ntryL,G1H8(14),37,0,G2H8(295),n2h8(597))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(17),m3h2x8(:,520),heltab2x16(:,:,645))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(296),n2h8(598))
  call Hloop_QV_A(ntryL,G1H16(453),ex3(:),G1H8(18),m3h2x8(:,521),heltab2x16(:,:,646))
  call Hloop_Q_A(ntryL,G1H8(18),37,0,G2H8(297),n2h8(599))
call HGT_raise_alpha_OLR(G1H16(454),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(454),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(454),ex2(:),G1H8(19),m3h2x8(:,522),heltab2x16(:,:,647))
  call Hloop_QV_A(ntryL,G1H16(456),ex3(:),G1H8(20),m3h2x8(:,523),heltab2x16(:,:,648))
  call Hloop_Q_A(ntryL,G1H8(20),37,0,G2H8(298),n2h8(600))
  call Hloop_QV_A(ntryL,G1H16(457),ex3(:),G1H8(24),m3h2x8(:,524),heltab2x16(:,:,649))
  call Hloop_Q_A(ntryL,G1H8(24),37,0,G2H8(299),n2h8(601))
  call Hloop_QV_A(ntryL,G1H16(458),ex3(:),G1H8(25),m3h2x8(:,525),heltab2x16(:,:,650))
  call Hloop_Q_A(ntryL,G1H8(25),37,0,G2H8(300),n2h8(602))
  call Hloop_AV_Q(ntryL,G1H16(459),ex3(:),G1H8(26),m3h2x8(:,526),heltab2x16(:,:,651))
  call Hloop_A_Q(ntryL,G1H8(26),38,0,G2H8(301),n2h8(603))
call HGT_raise_alpha_OLR(G1H16(460),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(460),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(460),-24,wf4(:,12),24,G2H4(826),m3h4x4(:,126),heltab2x16(:,:,652))
call signflip_OLR(G2H4(826))
  call Hloop_AV_Q(ntryL,G1H16(462),ex3(:),G1H8(29),m3h2x8(:,527),heltab2x16(:,:,653))
  call Hloop_A_Q(ntryL,G1H8(29),38,0,G2H8(302),n2h8(604))
  call Hloop_AV_Q(ntryL,G1H16(463),ex3(:),G1H8(30),m3h2x8(:,528),heltab2x16(:,:,654))
  call Hloop_A_Q(ntryL,G1H8(30),38,0,G2H8(303),n2h8(605))
  call Hloop_AV_Q(ntryL,G1H16(464),ex3(:),G1H8(32),m3h2x8(:,529),heltab2x16(:,:,655))
  call Hloop_A_Q(ntryL,G1H8(32),38,0,G2H8(304),n2h8(606))
  call Hloop_QV_A(ntryL,G1H16(113),wf4(:,12),G1H4(587),m3h4x4(:,127),heltab2x16(:,:,656))
  call Hloop_Q_A(ntryL,G1H4(587),57,0,G2H4(827),n2h4(829))
call HGT_raise_alpha_OLR(G1H16(465),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(465),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(465),ex2(:),G1H8(35),m3h2x8(:,530),heltab2x16(:,:,657))
  call Hloop_QV_A(ntryL,G1H16(467),wf4(:,12),G1H4(588),m3h4x4(:,128),heltab2x16(:,:,658))
  call Hloop_Q_A(ntryL,G1H4(588),57,0,G2H4(828),n2h4(830))
  call Hloop_QV_A(ntryL,G1H16(468),wf4(:,12),G1H4(593),m3h4x4(:,129),heltab2x16(:,:,659))
  call Hloop_Q_A(ntryL,G1H4(593),57,0,G2H4(829),n2h4(831))
  call Hloop_QV_A(ntryL,G1H16(469),wf4(:,12),G1H4(594),m3h4x4(:,130),heltab2x16(:,:,660))
  call Hloop_Q_A(ntryL,G1H4(594),57,0,G2H4(830),n2h4(832))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G2H4(2),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(315),[G2H4(105),G2H4(5),G1H4(359),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(324),[G2H4(133),G2H4(8),G1H4(443),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(310),[G2H4(11),G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(318),[G2H4(129),G2H4(14),G1H4(431),G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(321),[G2H4(117),G2H4(17),G1H4(395),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(309),[G2H4(20),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G2H4(23),G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(314),[G2H4(26),G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(312),[G2H4(29),G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(747),[G2H4(33),G1H4(143)])
call HGT_OLR(G2H4(36),1,1,4)
call HGT_invQ_OLR(G2H4(36),2,5,4)
call HGT_OLR(G2H4(36),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(795),[G2H4(37),G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G1H4(21)])
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(771),[G2H4(41),G1H4(167)])
call HGT_OLR(G2H4(44),1,1,4)
call HGT_invQ_OLR(G2H4(44),2,5,4)
call HGT_OLR(G2H4(44),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G2H4(45),G1H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(187),[G1H4(141)])
call HGT_OLR(G2H4(48),1,1,4)
call HGT_invQ_OLR(G2H4(48),2,5,4)
call HGT_OLR(G2H4(48),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(146),[G2H4(49),G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(739),[G2H4(53),G1H4(203)])
call HGT_OLR(G2H4(56),1,1,4)
call HGT_invQ_OLR(G2H4(56),2,5,4)
call HGT_OLR(G2H4(56),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(787),[G2H4(57),G1H4(215)])
call HGT_OLR(G2H4(60),1,1,4)
call HGT_invQ_OLR(G2H4(60),2,5,4)
call HGT_OLR(G2H4(60),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(317),[G2H4(109),G2H4(61),G1H4(371),G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(216),[G1H4(213)])
call HGT_OLR(G2H4(64),1,1,4)
call HGT_invQ_OLR(G2H4(64),2,5,4)
call HGT_OLR(G2H4(64),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(316),[G2H4(137),G2H4(65),G1H4(455),G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G1H4(57)])
call HGT_OLR(G2H4(68),1,1,4)
call HGT_invQ_OLR(G2H4(68),2,5,4)
call HGT_OLR(G2H4(68),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(763),[G2H4(69),G1H4(251)])
call HGT_OLR(G2H4(72),1,1,4)
call HGT_invQ_OLR(G2H4(72),2,5,4)
call HGT_OLR(G2H4(72),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(323),[G2H4(125),G2H4(73),G1H4(419),G1H4(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(220),[G1H4(249)])
call HGT_OLR(G2H4(76),1,1,4)
call HGT_invQ_OLR(G2H4(76),2,5,4)
call HGT_OLR(G2H4(76),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(322),[G2H4(141),G2H4(77),G1H4(467),G1H4(275)])
call HGT_OLR(G2H4(80),1,1,4)
call HGT_invQ_OLR(G2H4(80),2,5,4)
call HGT_OLR(G2H4(80),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(313),[G2H4(81),G1H4(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(207),[G1H4(201)])
call HGT_OLR(G2H4(84),1,1,4)
call HGT_invQ_OLR(G2H4(84),2,5,4)
call HGT_OLR(G2H4(84),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(311),[G2H4(85),G1H4(299)])
call HGT_OLR(G2H4(88),1,1,4)
call HGT_invQ_OLR(G2H4(88),2,5,4)
call HGT_OLR(G2H4(88),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(320),[G2H4(145),G2H4(89),G1H4(479),G1H4(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(196),[G1H4(153)])
call HGT_OLR(G2H4(92),1,1,4)
call HGT_invQ_OLR(G2H4(92),2,5,4)
call HGT_OLR(G2H4(92),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(319),[G2H4(153),G2H4(93),G1H4(503),G1H4(323)])
call HGT_OLR(G2H4(96),1,1,4)
call HGT_invQ_OLR(G2H4(96),2,5,4)
call HGT_OLR(G2H4(96),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(326),[G2H4(161),G2H4(97),G1H4(527),G1H4(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(200),[G1H4(165)])
call HGT_OLR(G2H4(100),1,1,4)
call HGT_invQ_OLR(G2H4(100),2,5,4)
call HGT_OLR(G2H4(100),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(325),[G2H4(165),G2H4(101),G1H4(539),G1H4(347)])
call HGT_OLR(G2H4(108),1,1,4)
call HGT_invQ_OLR(G2H4(108),2,5,4)
call HGT_OLR(G2H4(108),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(327),[G2H4(121),G2H4(113),G1H4(126),G1H4(122),G1H4(121) &
    ,G1H4(407),G1H4(383)])
call HGT_OLR(G2H4(124),1,1,4)
call HGT_invQ_OLR(G2H4(124),2,5,4)
call HGT_OLR(G2H4(124),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(277),[G1H4(429)])
call HGT_OLR(G2H4(136),1,1,4)
call HGT_invQ_OLR(G2H4(136),2,5,4)
call HGT_OLR(G2H4(136),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(280),[G1H4(441)])
call HGT_OLR(G2H4(140),1,1,4)
call HGT_invQ_OLR(G2H4(140),2,5,4)
call HGT_OLR(G2H4(140),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G2H4(280)])
call HGT_OLR(G2H4(144),1,1,4)
call HGT_invQ_OLR(G2H4(144),2,5,4)
call HGT_OLR(G2H4(144),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G2H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(328),[G2H4(157),G2H4(149),G1H4(133),G1H4(128),G1H4(127) &
    ,G1H4(515),G1H4(491)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(241),[G1H4(357)])
call HGT_OLR(G2H4(152),1,1,4)
call HGT_invQ_OLR(G2H4(152),2,5,4)
call HGT_OLR(G2H4(152),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(241)])
call HGT_OLR(G2H4(160),1,1,4)
call HGT_invQ_OLR(G2H4(160),2,5,4)
call HGT_OLR(G2H4(160),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(160),[G2H4(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(260),[G1H4(393)])
call HGT_OLR(G2H4(164),1,1,4)
call HGT_invQ_OLR(G2H4(164),2,5,4)
call HGT_OLR(G2H4(164),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(164),[G2H4(260)])
call HGT_lower_alpha_OLR(G2H4(168),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(168),2,5,4)
call HGT_lower_alpha_OLR(G2H4(168),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(168),[G2H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(811),[G2H4(169)])
call HGT_lower_alpha_OLR(G2H4(171),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(171),2,5,4)
call HGT_lower_alpha_OLR(G2H4(171),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(171),[G2H4(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(813),[G2H4(175),G2H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(814),[G2H4(173)])
call HGT_lower_alpha_OLR(G2H4(174),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(174),2,5,4)
call HGT_lower_alpha_OLR(G2H4(174),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(174),[G2H4(374)])
call HGT_lower_alpha_OLR(G2H4(178),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(178),2,5,4)
call HGT_lower_alpha_OLR(G2H4(178),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(178),[G2H4(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(253),[G2H4(179)])
call HGT_lower_alpha_OLR(G2H4(181),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(181),2,5,4)
call HGT_lower_alpha_OLR(G2H4(181),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(181),[G2H4(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(259),[G2H4(256),G2H4(185),G2H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(257),[G2H4(183)])
call HGT_lower_alpha_OLR(G2H4(184),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(184),2,5,4)
call HGT_lower_alpha_OLR(G2H4(184),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(184),[G2H4(388)])
call HGT_lower_alpha_OLR(G2H4(188),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(188),2,5,4)
call HGT_lower_alpha_OLR(G2H4(188),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(188),[G2H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(815),[G2H4(189)])
call HGT_lower_alpha_OLR(G2H4(191),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(191),2,5,4)
call HGT_lower_alpha_OLR(G2H4(191),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(191),[G2H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(817),[G2H4(195),G2H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(818),[G2H4(193)])
call HGT_lower_alpha_OLR(G2H4(194),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(194),2,5,4)
call HGT_lower_alpha_OLR(G2H4(194),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(194),[G2H4(397)])
call HGT_lower_alpha_OLR(G2H4(198),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(198),2,5,4)
call HGT_lower_alpha_OLR(G2H4(198),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(198),[G2H4(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(243),[G2H4(199)])
call HGT_lower_alpha_OLR(G2H4(201),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(201),2,5,4)
call HGT_lower_alpha_OLR(G2H4(201),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(201),[G2H4(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(249),[G2H4(246),G2H4(205),G2H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(247),[G2H4(203)])
call HGT_lower_alpha_OLR(G2H4(204),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(204),2,5,4)
call HGT_lower_alpha_OLR(G2H4(204),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(204),[G2H4(411)])
call HGT_lower_alpha_OLR(G2H4(208),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(208),2,5,4)
call HGT_lower_alpha_OLR(G2H4(208),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(208),[G2H4(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(263),[G2H4(209)])
call HGT_lower_alpha_OLR(G2H4(211),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(211),2,5,4)
call HGT_lower_alpha_OLR(G2H4(211),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(211),[G2H4(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(269),[G2H4(266),G2H4(215),G2H4(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(267),[G2H4(213)])
call HGT_lower_alpha_OLR(G2H4(214),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(214),2,5,4)
call HGT_lower_alpha_OLR(G2H4(214),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(214),[G2H4(425)])
call HGT_lower_alpha_OLR(G2H4(218),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(218),2,5,4)
call HGT_lower_alpha_OLR(G2H4(218),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(218),[G2H4(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(287),[G2H4(219)])
call HGT_lower_alpha_OLR(G2H4(221),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(221),2,5,4)
call HGT_lower_alpha_OLR(G2H4(221),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(221),[G2H4(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(293),[G2H4(290),G2H4(225),G2H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(291),[G2H4(223)])
call HGT_lower_alpha_OLR(G2H4(224),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(224),2,5,4)
call HGT_lower_alpha_OLR(G2H4(224),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(224),[G2H4(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(167),[G1H4(189)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(167),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(303),[G2H4(228),G1H4(636),G1H4(551)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(307),[G2H4(305),G2H4(232),G2H4(230),G1H4(642) &
    ,G1H4(557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(306),[G2H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(170),[G1H4(177)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(170),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(279),[G2H4(235),G1H4(602),G1H4(568)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(283),[G2H4(281),G2H4(239),G2H4(237),G1H4(608) &
    ,G1H4(574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(282),[G2H4(238)])
call HGT_lower_alpha_OLR(G2H4(242),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(242),2,5,4)
call HGT_lower_alpha_OLR(G2H4(242),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(242),[G2H4(448)])
call HGT_lower_alpha_OLR(G2H4(245),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(245),2,5,4)
call HGT_lower_alpha_OLR(G2H4(245),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(245),[G2H4(450)])
call HGT_lower_alpha_OLR(G2H4(248),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(248),2,5,4)
call HGT_lower_alpha_OLR(G2H4(248),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(248),[G2H4(451)])
call HGT_lower_alpha_OLR(G2H4(252),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(252),2,5,4)
call HGT_lower_alpha_OLR(G2H4(252),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(252),[G2H4(457)])
call HGT_lower_alpha_OLR(G2H4(255),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(255),2,5,4)
call HGT_lower_alpha_OLR(G2H4(255),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(255),[G2H4(459)])
call HGT_lower_alpha_OLR(G2H4(258),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(258),2,5,4)
call HGT_lower_alpha_OLR(G2H4(258),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(258),[G2H4(460)])
call HGT_lower_alpha_OLR(G2H4(262),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(262),2,5,4)
call HGT_lower_alpha_OLR(G2H4(262),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(262),[G2H4(466)])
call HGT_lower_alpha_OLR(G2H4(265),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(265),2,5,4)
call HGT_lower_alpha_OLR(G2H4(265),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(265),[G2H4(468)])
call HGT_lower_alpha_OLR(G2H4(268),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(268),2,5,4)
call HGT_lower_alpha_OLR(G2H4(268),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(268),[G2H4(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(176),[G1H4(237)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(176),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(827),[G2H4(296),G2H4(272),G1H4(619),G1H4(585)])
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(829),[G2H4(300),G2H4(298),G2H4(276),G2H4(274),G1H4(625) &
    ,G1H4(591)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(830),[G2H4(299),G2H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(177),[G1H4(225)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(177),[G1H4(10)])
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(231)])
call HGT_lower_alpha_OLR(G2H4(286),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(286),2,5,4)
call HGT_lower_alpha_OLR(G2H4(286),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(286),[G2H4(478)])
call HGT_lower_alpha_OLR(G2H4(289),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(289),2,5,4)
call HGT_lower_alpha_OLR(G2H4(289),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(289),[G2H4(480)])
call HGT_lower_alpha_OLR(G2H4(292),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(292),2,5,4)
call HGT_lower_alpha_OLR(G2H4(292),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(292),[G2H4(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(180),[G1H4(273)])
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(180),[G1H4(13)])
call HGT_w2_OLR(G1H4(14),1,1,4)
call HGT_w2_invQ_OLR(G1H4(14),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(186),[G1H4(261)])
call HGT_w2_OLR(G1H4(16),1,1,4)
call HGT_w2_invQ_OLR(G1H4(16),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(186),[G1H4(16)])
call HGT_w2_OLR(G1H4(17),1,1,4)
call HGT_w2_invQ_OLR(G1H4(17),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G1H4(34),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(365),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(154),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(449),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G1H4(70),G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(437),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(158),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(401),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(159),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(139),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(163),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(190),[G1H4(370),G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(376),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(749),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(197),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(797),[G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(206),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(773),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(495),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(498),[G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(500),[G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(503),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(210),[G1H4(478),G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(484),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(741),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(217),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(789),[G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(505),[G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(508),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(377),[G1H4(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(510),[G1H4(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(513),[G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(461),[G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(226),[G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(765),[G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(515),[G1H4(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(518),[G1H4(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(425),[G1H4(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(520),[G1H4(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(523),[G1H4(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(473),[G1H4(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(227),[G1H4(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(525),[G1H4(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(528),[G1H4(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(229),[G1H4(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(530),[G1H4(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(533),[G1H4(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(233),[G1H4(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(535),[G1H4(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(538),[G1H4(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(485),[G1H4(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(234),[G1H4(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(540),[G1H4(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(543),[G1H4(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(509),[G1H4(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(236),[G1H4(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(545),[G1H4(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(548),[G1H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(533),[G1H4(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(240),[G1H4(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(550),[G1H4(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(553),[G1H4(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(545),[G1H4(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(244),[G1H4(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(250),[G1H4(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(251),[G1H4(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(254),[G1H4(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(413),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(261),[G1H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(264),[G1H4(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(270),[G1H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(271),[G1H4(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(273),[G1H4(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(278),[G1H4(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(284),[G1H4(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(285),[G1H4(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(288),[G1H4(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(294),[G1H4(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(295),[G1H4(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(297),[G1H4(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(301),[G1H4(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(302),[G1H4(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(521),[G1H4(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(304),[G1H4(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(308),[G1H4(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(513)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(538)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(575),[G1H4(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(440),[G1H4(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(577),[G2H4(51),G1H4(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(442),[G2H4(54),G1H4(556)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(648),[G1H4(563)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(579),[G1H4(566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(444),[G1H4(567)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(581),[G2H4(59),G1H4(572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(446),[G2H4(62),G1H4(573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(614),[G1H4(580)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(598),[G1H4(583)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(470),[G1H4(584)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(600),[G2H4(87),G1H4(589)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(472),[G2H4(90),G1H4(590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(631),[G1H4(597)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(602),[G1H4(600)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(474),[G1H4(601)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(604),[G2H4(95),G1H4(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(476),[G2H4(98),G1H4(607)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(611),[G1H4(617)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(487),[G1H4(618)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(613),[G2H4(111),G1H4(623)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(489),[G2H4(114),G1H4(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(615),[G1H4(634)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(491),[G1H4(635)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(617),[G2H4(119),G1H4(640)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(493),[G2H4(122),G1H4(641)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(420),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(378),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(558),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(392),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(406),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(401),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(563),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(568),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(429),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(573),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(438),[G2H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(586),[G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(455),[G2H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(591),[G2H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(464),[G2H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(596),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(609),[G2H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(485),[G2H4(106)])
  call Hotf_5pt_reduction(G2H4(143),RedSet_5(41),mass5set(:,1),  & 
G1H4(598),G1H4(599),G1H4(604),G1H4(605),G1H4(610),G1H4(611),4)
  call HG1shiftOLR(G1H4(599),16,4)
  call Hotf_5pt_reduction(G2H4(315),RedSet_5(137),mass5set(:,1),  & 
G1H4(615),G1H4(616),G1H4(621),G1H4(622),G1H4(627),G1H4(628),4)
  call HG1shiftOLR(G1H4(616),16,4)
  call Hotf_5pt_reduction(G2H4(324),RedSet_5(138),mass5set(:,1),  & 
G1H4(632),G1H4(633),G1H4(638),G1H4(639),G1H4(644),G1H4(645),4)
  call HG1shiftOLR(G1H4(633),8,4)
  call Hotf_5pt_reduction(G2H4(310),RedSet_5(45),mass5set(:,1),  & 
G1H4(24),G1H4(36),G1H4(48),G1H4(60),G1H4(72),G1H4(84),4)
  call HG1shiftOLR(G1H4(36),16,4)
  call Hotf_5pt_reduction(G2H4(318),RedSet_5(139),mass5set(:,1),  & 
G1H4(96),G1H4(108),G1H4(120),G1H4(132),G1H4(144),G1H4(156),4)
  call HG1shiftOLR(G1H4(108),16,4)
  call Hotf_5pt_reduction(G2H4(321),RedSet_5(140),mass5set(:,1),  & 
G1H4(168),G1H4(180),G1H4(192),G1H4(204),G1H4(216),G1H4(228),4)
  call HG1shiftOLR(G1H4(180),8,4)
  call Hotf_5pt_reduction(G2H4(309),RedSet_5(141),mass5set(:,1),  & 
G1H4(240),G1H4(252),G1H4(264),G1H4(276),G1H4(288),G1H4(300),4)
  call HG1shiftOLR(G1H4(252),16,4)
  call Hotf_5pt_reduction(G2H4(147),RedSet_5(142),mass5set(:,1),  & 
G1H4(312),G1H4(324),G1H4(336),G1H4(360),G1H4(372),G1H4(384),4)
  call HG1shiftOLR(G1H4(324),8,4)
  call Hotf_5pt_reduction(G2H4(314),RedSet_5(143),mass5set(:,1),  & 
G1H4(396),G1H4(420),G1H4(432),G1H4(444),G1H4(456),G1H4(468),4)
  call HG1shiftOLR(G1H4(420),16,4)
  call Hotf_5pt_reduction(G2H4(312),RedSet_5(144),mass5set(:,1),  & 
G1H4(480),G1H4(492),G1H4(504),G1H4(516),G1H4(528),G1H4(540),4)
  call HG1shiftOLR(G1H4(492),8,4)
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(145),mass5set(:,1),  & 
G1H4(552),G1H4(558),G1H4(569),G1H4(575),G1H4(586),G1H4(603),4)
  call HG1shiftOLR(G1H4(558),4,4)
  call Hotf_5pt_reduction(G2H4(747),RedSet_5(134),mass5set(:,1),  & 
G1H4(609),G1H4(620),G1H4(626),G1H4(643),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(620),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(146),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(30),G1H4(31),G1H4(32),G1H4(38),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(795),RedSet_5(136),mass5set(:,1),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(50),G1H4(54),G1H4(55),4)
  call HG1shiftOLR(G1H4(43),16,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(147),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(78),G1H4(79),G1H4(80),G1H4(85),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(771),RedSet_5(135),mass5set(:,1),  & 
G1H4(86),G1H4(90),G1H4(91),G1H4(92),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(148),mass5set(:,1),  & 
G1H4(102),G1H4(103),G1H4(104),G1H4(109),G1H4(110),G1H4(114),4)
  call HG1shiftOLR(G1H4(103),8,4)
  call Hotf_5pt_reduction(G2H4(150),RedSet_5(141),mass5set(:,1),  & 
G1H4(115),G1H4(116),G1H4(134),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(149),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(150),G1H4(151),G1H4(152),G1H4(157),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(142),mass5set(:,1),  & 
G1H4(158),G1H4(162),G1H4(163),G1H4(164),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(162),8,4)
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(150),mass5set(:,1),  & 
G1H4(174),G1H4(175),G1H4(176),G1H4(181),G1H4(182),G1H4(186),4)
  call HG1shiftOLR(G1H4(175),4,4)
  call Hotf_5pt_reduction(G2H4(739),RedSet_5(134),mass5set(:,1),  & 
G1H4(187),G1H4(188),G1H4(193),G1H4(194),G1H4(198),G1H4(199),4)
  call HG1shiftOLR(G1H4(188),16,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(151),mass5set(:,1),  & 
G1H4(200),G1H4(205),G1H4(206),G1H4(210),G1H4(211),G1H4(212),4)
  call HG1shiftOLR(G1H4(205),8,4)
  call Hotf_5pt_reduction(G2H4(787),RedSet_5(136),mass5set(:,1),  & 
G1H4(217),G1H4(218),G1H4(222),G1H4(223),G1H4(224),G1H4(229),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(152),mass5set(:,1),  & 
G1H4(230),G1H4(234),G1H4(235),G1H4(241),G1H4(242),G1H4(246),4)
  call HG1shiftOLR(G1H4(234),4,4)
  call Hotf_5pt_reduction(G2H4(317),RedSet_5(153),mass5set(:,1),  & 
G1H4(247),G1H4(248),G1H4(253),G1H4(254),G1H4(258),G1H4(259),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(154),mass5set(:,1),  & 
G1H4(260),G1H4(265),G1H4(266),G1H4(271),G1H4(272),G1H4(277),4)
  call HG1shiftOLR(G1H4(265),16,4)
  call Hotf_5pt_reduction(G2H4(316),RedSet_5(155),mass5set(:,1),  & 
G1H4(278),G1H4(282),G1H4(283),G1H4(284),G1H4(289),G1H4(294),4)
  call HG1shiftOLR(G1H4(282),4,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(156),mass5set(:,1),  & 
G1H4(295),G1H4(296),G1H4(301),G1H4(302),G1H4(306),G1H4(307),4)
  call HG1shiftOLR(G1H4(296),16,4)
  call Hotf_5pt_reduction(G2H4(763),RedSet_5(135),mass5set(:,1),  & 
G1H4(308),G1H4(313),G1H4(314),G1H4(318),G1H4(319),G1H4(325),4)
  call HG1shiftOLR(G1H4(313),8,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(157),mass5set(:,1),  & 
G1H4(326),G1H4(330),G1H4(331),G1H4(332),G1H4(337),G1H4(338),4)
  call HG1shiftOLR(G1H4(330),4,4)
  call Hotf_5pt_reduction(G2H4(323),RedSet_5(158),mass5set(:,1),  & 
G1H4(342),G1H4(343),G1H4(344),G1H4(349),G1H4(350),G1H4(355),4)
  call HG1shiftOLR(G1H4(343),8,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(159),mass5set(:,1),  & 
G1H4(356),G1H4(361),G1H4(362),G1H4(366),G1H4(367),G1H4(368),4)
  call HG1shiftOLR(G1H4(361),8,4)
  call Hotf_5pt_reduction(G2H4(322),RedSet_5(160),mass5set(:,1),  & 
G1H4(373),G1H4(378),G1H4(379),G1H4(380),G1H4(385),G1H4(386),4)
  call HG1shiftOLR(G1H4(378),4,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(161),mass5set(:,1),  & 
G1H4(390),G1H4(391),G1H4(392),G1H4(398),G1H4(402),G1H4(403),4)
  call HG1shiftOLR(G1H4(391),8,4)
  call Hotf_5pt_reduction(G2H4(313),RedSet_5(143),mass5set(:,1),  & 
G1H4(404),G1H4(410),G1H4(414),G1H4(415),G1H4(416),G1H4(422),4)
  call HG1shiftOLR(G1H4(410),16,4)
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(162),mass5set(:,1),  & 
G1H4(426),G1H4(427),G1H4(428),G1H4(433),G1H4(434),G1H4(438),4)
  call HG1shiftOLR(G1H4(427),16,4)
  call Hotf_5pt_reduction(G2H4(311),RedSet_5(144),mass5set(:,1),  & 
G1H4(439),G1H4(445),G1H4(446),G1H4(450),G1H4(451),G1H4(452),4)
  call HG1shiftOLR(G1H4(445),8,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(163),mass5set(:,1),  & 
G1H4(457),G1H4(458),G1H4(462),G1H4(464),G1H4(469),G1H4(470),4)
  call HG1shiftOLR(G1H4(458),4,4)
  call Hotf_5pt_reduction(G2H4(320),RedSet_5(164),mass5set(:,1),  & 
G1H4(474),G1H4(476),G1H4(481),G1H4(482),G1H4(486),G1H4(488),4)
  call HG1shiftOLR(G1H4(476),16,4)
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(165),mass5set(:,1),  & 
G1H4(493),G1H4(494),G1H4(498),G1H4(500),G1H4(505),G1H4(506),4)
  call HG1shiftOLR(G1H4(494),16,4)
  call Hotf_5pt_reduction(G2H4(319),RedSet_5(166),mass5set(:,1),  & 
G1H4(510),G1H4(511),G1H4(512),G1H4(517),G1H4(518),G1H4(523),4)
  call HG1shiftOLR(G1H4(511),4,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(167),mass5set(:,1),  & 
G1H4(530),G1H4(535),G1H4(536),G1H4(541),G1H4(547),G1H4(548),4)
  call HG1shiftOLR(G1H4(535),4,4)
  call Hotf_5pt_reduction(G2H4(326),RedSet_5(168),mass5set(:,1),  & 
G1H4(553),G1H4(554),G1H4(587),G1H4(588),G1H4(593),G1H4(594),4)
  call HG1shiftOLR(G1H4(554),8,4)
  call Hotf_5pt_reduction(G2H4(100),RedSet_5(169),mass5set(:,1),  & 
G1H4(23),G1H4(359),G1H4(35),G1H4(443),G1H4(47),G1H4(59),4)
  call HG1shiftOLR(G1H4(359),8,4)
  call Hotf_5pt_reduction(G2H4(325),RedSet_5(170),mass5set(:,1),  & 
G1H4(431),G1H4(71),G1H4(395),G1H4(83),G1H4(95),G1H4(107),4)
  call HG1shiftOLR(G1H4(71),4,4)
call HGT_OLR(G2H4(104),1,1,4)
call HGT_invQ_OLR(G2H4(104),2,5,4)
call HGT_OLR(G2H4(104),6,15,4)
  call Hotf_5pt_reduction(G2H4(104),RedSet_5(171),mass5set(:,1),  & 
G1H4(119),G1H4(131),G1H4(143),G1H4(155),G1H4(21),G1H4(167),4)
  call HG1shiftOLR(G1H4(131),2,4)
  call Hotf_5pt_reduction(G2H4(108),RedSet_5(172),mass5set(:,1),  & 
G1H4(179),G1H4(141),G1H4(191),G1H4(203),G1H4(215),G1H4(371),4)
  call HG1shiftOLR(G1H4(141),4,4)
call HGT_OLR(G2H4(112),1,1,4)
call HGT_invQ_OLR(G2H4(112),2,5,4)
call HGT_OLR(G2H4(112),6,15,4)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(173),mass5set(:,1),  & 
G1H4(227),G1H4(213),G1H4(455),G1H4(239),G1H4(57),G1H4(251),4)
  call HG1shiftOLR(G1H4(213),1,4)
  call Hotf_5pt_reduction(G2H4(327),RedSet_5(174),mass5set(:,1),  & 
G1H4(419),G1H4(263),G1H4(249),G1H4(467),G1H4(275),G1H4(287),4)
  call HG1shiftOLR(G1H4(263),4,4)
call HGT_OLR(G2H4(116),1,1,4)
call HGT_invQ_OLR(G2H4(116),2,5,4)
call HGT_OLR(G2H4(116),6,15,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(175),mass5set(:,1),  & 
G1H4(201),G1H4(299),G1H4(479),G1H4(311),G1H4(153),G1H4(503),4)
  call HG1shiftOLR(G1H4(299),2,4)
call HGT_OLR(G2H4(120),1,1,4)
call HGT_invQ_OLR(G2H4(120),2,5,4)
call HGT_OLR(G2H4(120),6,15,4)
  call Hotf_5pt_reduction(G2H4(120),RedSet_5(176),mass5set(:,1),  & 
G1H4(323),G1H4(527),G1H4(335),G1H4(165),G1H4(539),G1H4(347),4)
  call HG1shiftOLR(G1H4(527),1,4)
  call Hotf_5pt_reduction(G2H4(124),RedSet_5(177),mass5set(:,1),  & 
G1H4(126),G1H4(122),G1H4(121),G1H4(407),G1H4(383),G1H4(429),4)
  call HG1shiftOLR(G1H4(122),4,4)
call HGT_OLR(G2H4(128),1,1,4)
call HGT_invQ_OLR(G2H4(128),2,5,4)
call HGT_OLR(G2H4(128),6,15,4)
  call Hotf_5pt_reduction(G2H4(128),RedSet_5(178),mass5set(:,1),  & 
G1H4(441),G1H4(133),G1H4(128),G1H4(127),G1H4(515),G1H4(491),4)
  call HG1shiftOLR(G1H4(133),1,4)
call HGT_OLR(G2H4(132),1,1,4)
call HGT_invQ_OLR(G2H4(132),2,5,4)
call HGT_OLR(G2H4(132),6,15,4)
  call Hotf_5pt_reduction(G2H4(132),RedSet_5(179),mass5set(:,1),  & 
G1H4(357),G1H4(393),G1H4(189),G1H4(1),G1H4(636),G1H4(551),4)
  call HG1shiftOLR(G1H4(393),1,4)
  call Hotf_5pt_reduction(G2H4(136),RedSet_5(180),mass5set(:,1),  & 
G1H4(195),G1H4(642),G1H4(557),G1H4(177),G1H4(4),G1H4(602),4)
  call HG1shiftOLR(G1H4(642),16,4)
  call Hotf_5pt_reduction(G2H4(140),RedSet_5(181),mass5set(:,1),  & 
G1H4(568),G1H4(183),G1H4(608),G1H4(574),G1H4(237),G1H4(7),4)
  call HG1shiftOLR(G1H4(183),8,4)
  call Hotf_5pt_reduction(G2H4(144),RedSet_5(182),mass5set(:,1),  & 
G1H4(619),G1H4(585),G1H4(243),G1H4(625),G1H4(591),G1H4(225),4)
  call HG1shiftOLR(G1H4(585),4,4)
call HGT_OLR(G2H4(148),1,1,4)
call HGT_invQ_OLR(G2H4(148),2,5,4)
call HGT_OLR(G2H4(148),6,15,4)
  call Hotf_5pt_reduction(G2H4(148),RedSet_5(183),mass5set(:,1),  & 
G1H4(10),G1H4(231),G1H4(273),G1H4(13),G1H4(279),G1H4(261),4)
  call HG1shiftOLR(G1H4(231),2,4)
  call Hotf_5pt_reduction(G2H4(328),RedSet_5(184),mass5set(:,1),  & 
G1H4(16),G1H4(267),G1H4(34),G1H4(22),G1H4(28),G1H4(33),4)
  call HG1shiftOLR(G1H4(267),4,4)
  call Hotf_5pt_reduction(G2H4(152),RedSet_5(185),mass5set(:,1),  & 
G1H4(41),G1H4(45),G1H4(46),G1H4(53),G1H4(70),G1H4(58),4)
  call HG1shiftOLR(G1H4(45),16,4)
call HGT_OLR(G2H4(156),1,1,4)
call HGT_invQ_OLR(G2H4(156),2,5,4)
call HGT_OLR(G2H4(156),6,15,4)
  call Hotf_5pt_reduction(G2H4(156),RedSet_5(186),mass5set(:,1),  & 
G1H4(64),G1H4(69),G1H4(77),G1H4(81),G1H4(82),G1H4(89),4)
  call HG1shiftOLR(G1H4(69),2,4)
  call Hotf_5pt_reduction(G2H4(160),RedSet_5(187),mass5set(:,1),  & 
G1H4(93),G1H4(94),G1H4(105),G1H4(106),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(94),4,4)
  call Hotf_5pt_reduction(G2H4(164),RedSet_5(188),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(370),G1H4(142),G1H4(148),G1H4(149),4)
  call HG1shiftOLR(G1H4(130),8,4)
  call Hotf_5pt_reduction(G2H4(168),RedSet_5(86),mass5set(:,1),  & 
G1H4(154),G1H4(161),G1H4(166),G1H4(173),G1H4(178),G1H4(184),4)
  call HG1shiftOLR(G1H4(161),2,4)
  call Hloop_QA_V(ntryL,G2H4(811),ex2(:),G2H2(1),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hotf_4pt_reduction(G2H4(171),RedSet_4(406),mass4set(:,1),  & 
G1H4(190),G1H4(196),G1H4(478),G1H4(202),G1H4(208),4)
  call HG1shiftOLR(G1H4(196),2,4)
  call Hloop_QA_V(ntryL,G2H4(813),ex2(:),G2H2(4),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_QA_V(ntryL,G2H4(814),ex2(:),G2H2(7),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hotf_4pt_reduction(G2H4(174),RedSet_4(407),mass4set(:,1),  & 
G1H4(209),G1H4(214),G1H4(221),G1H4(226),G1H4(232),4)
  call HG1shiftOLR(G1H4(214),6,4)
  call Hotf_5pt_reduction(G2H4(178),RedSet_5(89),mass5set(:,1),  & 
G1H4(233),G1H4(238),G1H4(244),G1H4(245),G1H4(250),G1H4(257),4)
  call HG1shiftOLR(G1H4(238),1,4)
  call Hloop_AQ_V(ntryL,G2H4(253),ex1(:),G2H2(10),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hotf_4pt_reduction(G2H4(181),RedSet_4(408),mass4set(:,1),  & 
G1H4(262),G1H4(268),G1H4(269),G1H4(274),G1H4(280),4)
  call HG1shiftOLR(G1H4(268),1,4)
  call Hloop_AQ_V(ntryL,G2H4(259),ex1(:),G2H2(13),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_AQ_V(ntryL,G2H4(257),ex1(:),G2H2(16),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hotf_4pt_reduction(G2H4(184),RedSet_4(409),mass4set(:,1),  & 
G1H4(281),G1H4(285),G1H4(286),G1H4(292),G1H4(297),4)
  call HG1shiftOLR(G1H4(285),5,4)
  call Hotf_5pt_reduction(G2H4(188),RedSet_5(91),mass5set(:,1),  & 
G1H4(298),G1H4(304),G1H4(309),G1H4(310),G1H4(316),G1H4(317),4)
  call HG1shiftOLR(G1H4(304),1,4)
  call Hloop_AQ_V(ntryL,G2H4(815),ex1(:),G2H2(19),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hotf_4pt_reduction(G2H4(191),RedSet_4(410),mass4set(:,1),  & 
G1H4(321),G1H4(322),G1H4(328),G1H4(329),G1H4(333),4)
  call HG1shiftOLR(G1H4(322),1,4)
  call Hloop_AQ_V(ntryL,G2H4(817),ex1(:),G2H2(22),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_AQ_V(ntryL,G2H4(818),ex1(:),G2H2(25),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hotf_4pt_reduction(G2H4(194),RedSet_4(411),mass4set(:,1),  & 
G1H4(334),G1H4(340),G1H4(341),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(340),5,4)
  call Hotf_5pt_reduction(G2H4(198),RedSet_5(94),mass5set(:,1),  & 
G1H4(352),G1H4(353),G1H4(358),G1H4(369),G1H4(381),G1H4(382),4)
  call HG1shiftOLR(G1H4(353),1,4)
  call Hloop_AQ_V(ntryL,G2H4(243),ex1(:),G2H2(28),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hotf_4pt_reduction(G2H4(201),RedSet_4(412),mass4set(:,1),  & 
G1H4(389),G1H4(394),G1H4(405),G1H4(406),G1H4(417),4)
  call HG1shiftOLR(G1H4(394),1,4)
  call Hloop_AQ_V(ntryL,G2H4(249),ex1(:),G2H2(31),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_AQ_V(ntryL,G2H4(247),ex1(:),G2H2(36),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hotf_4pt_reduction(G2H4(204),RedSet_4(413),mass4set(:,1),  & 
G1H4(418),G1H4(430),G1H4(442),G1H4(453),G1H4(454),4)
  call HG1shiftOLR(G1H4(430),5,4)
  call Hotf_5pt_reduction(G2H4(208),RedSet_5(97),mass5set(:,1),  & 
G1H4(465),G1H4(466),G1H4(477),G1H4(489),G1H4(490),G1H4(497),4)
  call HG1shiftOLR(G1H4(466),2,4)
  call Hloop_QA_V(ntryL,G2H4(263),ex2(:),G2H2(41),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hotf_4pt_reduction(G2H4(211),RedSet_4(414),mass4set(:,1),  & 
G1H4(501),G1H4(502),G1H4(513),G1H4(514),G1H4(525),4)
  call HG1shiftOLR(G1H4(502),2,4)
  call Hloop_QA_V(ntryL,G2H4(269),ex2(:),G2H2(46),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_QA_V(ntryL,G2H4(267),ex2(:),G2H2(51),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hotf_4pt_reduction(G2H4(214),RedSet_4(415),mass4set(:,1),  & 
G1H4(526),G1H4(537),G1H4(538),G1H4(549),G1H4(550),4)
  call HG1shiftOLR(G1H4(537),10,4)
  call Hotf_5pt_reduction(G2H4(218),RedSet_5(99),mass5set(:,1),  & 
G1H4(555),G1H4(556),G1H4(563),G1H4(566),G1H4(567),G1H4(572),4)
  call HG1shiftOLR(G1H4(556),2,4)
  call Hloop_QA_V(ntryL,G2H4(287),ex2(:),G2H2(56),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hotf_4pt_reduction(G2H4(221),RedSet_4(416),mass4set(:,1),  & 
G1H4(573),G1H4(580),G1H4(583),G1H4(584),G1H4(589),4)
  call HG1shiftOLR(G1H4(580),2,4)
  call Hloop_QA_V(ntryL,G2H4(293),ex2(:),G2H2(61),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_QA_V(ntryL,G2H4(291),ex2(:),G2H2(66),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hotf_4pt_reduction(G2H4(224),RedSet_4(65),mass4set(:,1),  & 
G1H4(590),G1H4(597),G1H4(600),G1H4(601),G1H4(606),4)
  call HG1shiftOLR(G1H4(597),18,4)
  call Hotf_5pt_reduction(G2H4(167),RedSet_5(189),mass5set(:,1),  & 
G1H4(607),G1H4(617),G1H4(618),G1H4(623),G1H4(624),G1H4(634),4)
  call HG1shiftOLR(G1H4(617),8,4)
  call Hotf_5pt_reduction(G2H4(303),RedSet_5(53),mass5set(:,1),  & 
G1H4(635),G1H4(640),G1H4(641),G1H4(649),G1H4(650),G1H4(651),4)
  call HG1shiftOLR(G1H4(640),2,4)
  call Hloop_QV_A(ntryL,G1H4(2),ex5(:),G1H2(19),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(71),n2h2(139))
  call Hotf_4pt_reduction(G2H4(307),RedSet_4(13),mass4set(:,1),  & 
G1H4(2),G1H4(652),G1H4(653),G1H4(654),G1H4(655),4)
  call HG1shiftOLR(G1H4(652),2,4)
  call Hotf_4pt_reduction(G2H4(306),RedSet_4(14),mass4set(:,1),  & 
G1H4(656),G1H4(657),G1H4(658),G1H4(659),G1H4(660),4)
  call HG1shiftOLR(G1H4(657),10,4)
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(3),ex5(:),G1H2(20),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(76),n2h2(140))
  call Hotf_5pt_reduction(G2H4(170),RedSet_5(190),mass5set(:,1),  & 
G1H4(3),G1H4(661),G1H4(662),G1H4(663),G1H4(664),G1H4(665),4)
  call HG1shiftOLR(G1H4(661),16,4)
  call Hotf_5pt_reduction(G2H4(279),RedSet_5(55),mass5set(:,1),  & 
G1H4(666),G1H4(667),G1H4(668),G1H4(669),G1H4(670),G1H4(671),4)
  call HG1shiftOLR(G1H4(667),2,4)
  call Hloop_QV_A(ntryL,G1H4(5),ex4(:),G1H2(25),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(81),n2h2(141))
  call Hotf_4pt_reduction(G2H4(283),RedSet_4(13),mass4set(:,1),  & 
G1H4(5),G1H4(672),G1H4(673),G1H4(674),G1H4(675),4)
  call HG1shiftOLR(G1H4(672),2,4)
  call Hotf_4pt_reduction(G2H4(282),RedSet_4(25),mass4set(:,1),  & 
G1H4(676),G1H4(677),G1H4(678),G1H4(679),G1H4(680),4)
  call HG1shiftOLR(G1H4(677),18,4)
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(6),ex4(:),G1H2(26),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(86),n2h2(142))
  call Hotf_5pt_reduction(G2H4(242),RedSet_5(103),mass5set(:,1),  & 
G1H4(6),G1H4(681),G1H4(682),G1H4(683),G1H4(684),G1H4(685),4)
  call HG1shiftOLR(G1H4(681),1,4)
  call Hotf_4pt_reduction(G2H4(245),RedSet_4(412),mass4set(:,1),  & 
G1H4(686),G1H4(687),G1H4(688),G1H4(689),G1H4(690),4)
  call HG1shiftOLR(G1H4(687),1,4)
  call Hotf_4pt_reduction(G2H4(248),RedSet_4(417),mass4set(:,1),  & 
G1H4(691),G1H4(692),G1H4(693),G1H4(694),G1H4(695),4)
  call HG1shiftOLR(G1H4(692),9,4)
  call Hotf_5pt_reduction(G2H4(252),RedSet_5(105),mass5set(:,1),  & 
G1H4(696),G1H4(697),G1H4(698),G1H4(699),G1H4(700),G1H4(701),4)
  call HG1shiftOLR(G1H4(697),1,4)
  call Hotf_4pt_reduction(G2H4(255),RedSet_4(408),mass4set(:,1),  & 
G1H4(702),G1H4(703),G1H4(704),G1H4(705),G1H4(706),4)
  call HG1shiftOLR(G1H4(703),1,4)
  call Hotf_4pt_reduction(G2H4(258),RedSet_4(94),mass4set(:,1),  & 
G1H4(707),G1H4(708),G1H4(709),G1H4(710),G1H4(711),4)
  call HG1shiftOLR(G1H4(708),17,4)
  call Hotf_5pt_reduction(G2H4(262),RedSet_5(107),mass5set(:,1),  & 
G1H4(712),G1H4(713),G1H4(714),G1H4(715),G1H4(716),G1H4(717),4)
  call HG1shiftOLR(G1H4(713),2,4)
  call Hotf_4pt_reduction(G2H4(265),RedSet_4(414),mass4set(:,1),  & 
G1H4(718),G1H4(719),G1H4(720),G1H4(721),G1H4(722),4)
  call HG1shiftOLR(G1H4(719),2,4)
  call Hotf_4pt_reduction(G2H4(268),RedSet_4(418),mass4set(:,1),  & 
G1H4(723),G1H4(724),G1H4(725),G1H4(726),G1H4(727),4)
  call HG1shiftOLR(G1H4(724),6,4)
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(191),mass5set(:,1),  & 
G1H4(728),G1H4(729),G1H4(730),G1H4(731),G1H4(732),G1H4(733),4)
  call HG1shiftOLR(G1H4(729),4,4)
  call Hotf_5pt_reduction(G2H4(827),RedSet_5(59),mass5set(:,1),  & 
G1H4(734),G1H4(735),G1H4(736),G1H4(737),G1H4(738),G1H4(739),4)
  call HG1shiftOLR(G1H4(735),2,4)
  call Hloop_QV_A(ntryL,G1H4(8),ex5(:),G1H2(31),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(91),n2h2(143))
  call Hotf_4pt_reduction(G2H4(829),RedSet_4(13),mass4set(:,1),  & 
G1H4(8),G1H4(740),G1H4(741),G1H4(742),G1H4(743),4)
  call HG1shiftOLR(G1H4(740),2,4)
  call Hotf_4pt_reduction(G2H4(830),RedSet_4(37),mass4set(:,1),  & 
G1H4(744),G1H4(745),G1H4(746),G1H4(747),G1H4(748),4)
  call HG1shiftOLR(G1H4(745),6,4)
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(9),ex5(:),G1H2(32),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_Q_A(ntryL,G1H2(32),59,0,G2H2(96),n2h2(144))
  call Hotf_5pt_reduction(G2H4(177),RedSet_5(192),mass5set(:,1),  & 
G1H4(9),G1H4(749),G1H4(750),G1H4(751),G1H4(752),G1H4(753),4)
  call HG1shiftOLR(G1H4(749),16,4)
  call Hloop_QV_A(ntryL,G1H4(11),ex3(:),G1H2(37),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(101),n2h2(145))
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(12),ex3(:),G1H2(38),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(106),n2h2(146))
  call Hotf_5pt_reduction(G2H4(286),RedSet_5(110),mass5set(:,1),  & 
G1H4(11),G1H4(12),G1H4(754),G1H4(755),G1H4(756),G1H4(757),4)
  call HG1shiftOLR(G1H4(12),2,4)
  call Hotf_4pt_reduction(G2H4(289),RedSet_4(416),mass4set(:,1),  & 
G1H4(758),G1H4(759),G1H4(760),G1H4(761),G1H4(762),4)
  call HG1shiftOLR(G1H4(759),2,4)
  call Hotf_4pt_reduction(G2H4(292),RedSet_4(419),mass4set(:,1),  & 
G1H4(763),G1H4(764),G1H4(765),G1H4(766),G1H4(767),4)
  call HG1shiftOLR(G1H4(764),6,4)
  call Hotf_5pt_reduction(G2H4(180),RedSet_5(193),mass5set(:,1),  & 
G1H4(768),G1H4(769),G1H4(770),G1H4(771),G1H4(772),G1H4(773),4)
  call HG1shiftOLR(G1H4(769),4,4)
  call Hloop_QV_A(ntryL,G1H4(14),ex4(:),G1H2(43),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(43),59,0,G2H2(111),n2h2(147))
call HGT_w2_OLR(G1H4(15),1,1,4)
call HGT_w2_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(15),ex4(:),G1H2(44),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(44),59,0,G2H2(116),n2h2(148))
  call Hotf_5pt_reduction(G2H4(186),RedSet_5(194),mass5set(:,1),  & 
G1H4(14),G1H4(15),G1H4(774),G1H4(775),G1H4(776),G1H4(777),4)
  call HG1shiftOLR(G1H4(15),8,4)
  call Hloop_QV_A(ntryL,G1H4(17),ex3(:),G1H2(49),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(49),55,0,G2H2(121),n2h2(149))
call HGT_w2_OLR(G1H4(18),1,1,4)
call HGT_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(18),ex3(:),G1H2(50),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(50),55,0,G2H2(126),n2h2(150))
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(195),mass5set(:,1),  & 
G1H4(17),G1H4(18),G1H4(778),G1H4(779),G1H4(780),G1H4(781),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hloop_VA_Q(ntryL,G1H4(27),ex2(:),G1H2(55),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(131),n2h2(151))
  call Hloop_VA_Q(ntryL,G1H4(40),ex2(:),G1H2(56),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(136),n2h2(152))
  call Hloop_VA_Q(ntryL,G1H4(29),ex2(:),G1H2(61),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(141),n2h2(153))
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(196),mass5set(:,1),  & 
G1H4(27),G1H4(40),G1H4(29),G1H4(782),G1H4(783),G1H4(784),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hloop_VA_Q(ntryL,G1H4(39),ex2(:),G1H2(62),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(146),n2h2(154))
  call Hloop_VA_Q(ntryL,G1H4(365),ex2(:),G1H2(67),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G1H2(67),47,0,G2H2(151),n2h2(155))
  call Hotf_5pt_reduction(G2H4(127),RedSet_5(197),mass5set(:,1),  & 
G1H4(39),G1H4(365),G1H4(785),G1H4(786),G1H4(787),G1H4(788),4)
  call HG1shiftOLR(G1H4(365),8,4)
  call Hotf_5pt_reduction(G2H4(154),RedSet_5(198),mass5set(:,1),  & 
G1H4(789),G1H4(790),G1H4(791),G1H4(792),G1H4(793),G1H4(794),4)
  call HG1shiftOLR(G1H4(790),8,4)
  call Hloop_VQ_A(ntryL,G1H4(51),ex1(:),G1H2(68),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_Q_A(ntryL,G1H2(68),55,0,G2H2(156),n2h2(156))
  call Hloop_VQ_A(ntryL,G1H4(52),ex1(:),G1H2(73),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(73),55,0,G2H2(161),n2h2(157))
  call Hloop_VQ_A(ntryL,G1H4(449),ex1(:),G1H2(74),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(74),55,0,G2H2(166),n2h2(158))
  call Hotf_5pt_reduction(G2H4(155),RedSet_5(199),mass5set(:,1),  & 
G1H4(51),G1H4(52),G1H4(449),G1H4(795),G1H4(796),G1H4(797),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hloop_VQ_A(ntryL,G1H4(63),ex1(:),G1H2(79),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(79),47,0,G2H2(171),n2h2(159))
  call Hloop_VQ_A(ntryL,G1H4(76),ex1(:),G1H2(80),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G1H2(80),47,0,G2H2(176),n2h2(160))
  call Hloop_VQ_A(ntryL,G1H4(65),ex1(:),G1H2(85),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(85),47,0,G2H2(181),n2h2(161))
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(200),mass5set(:,1),  & 
G1H4(63),G1H4(76),G1H4(65),G1H4(798),G1H4(799),G1H4(800),4)
  call HG1shiftOLR(G1H4(76),16,4)
  call Hloop_VQ_A(ntryL,G1H4(75),ex1(:),G1H2(86),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(186),n2h2(162))
  call Hloop_VQ_A(ntryL,G1H4(437),ex1(:),G1H2(91),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(191),n2h2(163))
  call Hotf_5pt_reduction(G2H4(134),RedSet_5(201),mass5set(:,1),  & 
G1H4(75),G1H4(437),G1H4(801),G1H4(802),G1H4(803),G1H4(804),4)
  call HG1shiftOLR(G1H4(437),8,4)
  call Hotf_5pt_reduction(G2H4(158),RedSet_5(202),mass5set(:,1),  & 
G1H4(805),G1H4(806),G1H4(807),G1H4(808),G1H4(809),G1H4(810),4)
  call HG1shiftOLR(G1H4(806),8,4)
  call Hloop_VA_Q(ntryL,G1H4(87),ex2(:),G1H2(92),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G1H2(92),55,0,G2H2(196),n2h2(164))
  call Hloop_VA_Q(ntryL,G1H4(88),ex2(:),G1H2(97),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_A_Q(ntryL,G1H2(97),55,0,G2H2(201),n2h2(165))
  call Hloop_VA_Q(ntryL,G1H4(401),ex2(:),G1H2(98),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_A_Q(ntryL,G1H2(98),55,0,G2H2(206),n2h2(166))
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(203),mass5set(:,1),  & 
G1H4(87),G1H4(88),G1H4(401),G1H4(811),G1H4(812),G1H4(813),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hotf_5pt_reduction(G2H4(159),RedSet_5(204),mass5set(:,1),  & 
G1H4(814),G1H4(815),G1H4(816),G1H4(817),G1H4(818),G1H4(819),4)
  call HG1shiftOLR(G1H4(815),16,4)
  call Hloop_UV_W(ntryL,G1H4(99),39,ex4(:),8,G2H2(211),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_UV_W(ntryL,G1H4(100),39,ex4(:),8,G2H2(216),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_UV_W(ntryL,G1H4(101),39,ex4(:),8,G2H2(221),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hotf_5pt_reduction(G2H4(138),RedSet_5(205),mass5set(:,1),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(820),G1H4(821),G1H4(822),4)
  call HG1shiftOLR(G1H4(100),8,4)
  call Hotf_5pt_reduction(G2H4(162),RedSet_5(206),mass5set(:,1),  & 
G1H4(823),G1H4(824),G1H4(825),G1H4(826),G1H4(827),G1H4(828),4)
  call HG1shiftOLR(G1H4(824),8,4)
  call Hloop_UV_W(ntryL,G1H4(111),39,ex5(:),16,G2H2(226),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_UV_W(ntryL,G1H4(112),39,ex5(:),16,G2H2(231),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_UV_W(ntryL,G1H4(113),39,ex5(:),16,G2H2(236),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hotf_5pt_reduction(G2H4(139),RedSet_5(207),mass5set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(829),G1H4(830),G1H4(831),4)
  call HG1shiftOLR(G1H4(112),16,4)
  call Hotf_5pt_reduction(G2H4(163),RedSet_5(208),mass5set(:,1),  & 
G1H4(832),G1H4(833),G1H4(834),G1H4(835),G1H4(836),G1H4(837),4)
  call HG1shiftOLR(G1H4(833),16,4)
  call Hloop_UV_W(ntryL,G1H4(123),39,ex4(:),8,G2H2(241),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_UV_W(ntryL,G1H4(124),39,ex4(:),8,G2H2(246),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_UV_W(ntryL,G1H4(125),39,ex4(:),8,G2H2(251),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(209),mass5set(:,1),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(838),G1H4(839),G1H4(840),4)
  call HG1shiftOLR(G1H4(124),8,4)
  call Hotf_5pt_reduction(G2H4(166),RedSet_5(210),mass5set(:,1),  & 
G1H4(841),G1H4(842),G1H4(843),G1H4(844),G1H4(845),G1H4(846),4)
  call HG1shiftOLR(G1H4(842),8,4)
  call Hloop_UV_W(ntryL,G1H4(135),39,ex5(:),16,G2H2(254),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_UV_W(ntryL,G1H4(136),39,ex5(:),16,G2H2(257),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_UV_W(ntryL,G1H4(137),39,ex5(:),16,G2H2(260),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hotf_5pt_reduction(G2H4(190),RedSet_5(211),mass5set(:,1),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(847),G1H4(848),G1H4(849),4)
  call HG1shiftOLR(G1H4(136),16,4)
  call Hloop_QV_A(ntryL,G1H4(147),ex3(:),G1H2(103),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(103),47,0,G2H2(263),n2h2(167))
  call Hloop_QV_A(ntryL,G1H4(376),ex3(:),G1H2(104),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(104),47,0,G2H2(266),n2h2(168))
  call Hotf_4pt_reduction(G2H4(749),RedSet_4(70),mass4set(:,1),  & 
G1H4(147),G1H4(376),G1H4(850),G1H4(851),G1H4(852),G0H4(1),4)
  call HG1shiftOLR(G1H4(376),16,4)
  call Hotf_5pt_reduction(G2H4(197),RedSet_5(208),mass5set(:,1),  & 
G1H4(853),G1H4(854),G1H4(855),G1H4(856),G1H4(857),G1H4(858),4)
  call HG1shiftOLR(G1H4(854),16,4)
  call Hloop_AV_Q(ntryL,G1H4(159),ex4(:),G1H2(109),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(269),n2h2(169))
  call Hloop_AV_Q(ntryL,G1H4(160),ex4(:),G1H2(110),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(270),n2h2(170))
  call Hotf_4pt_reduction(G2H4(797),RedSet_4(175),mass4set(:,1),  & 
G1H4(159),G1H4(160),G1H4(859),G1H4(860),G1H4(861),G0H4(2),4)
  call HG1shiftOLR(G1H4(160),16,4)
  call Hotf_5pt_reduction(G2H4(206),RedSet_5(210),mass5set(:,1),  & 
G1H4(862),G1H4(863),G1H4(864),G1H4(865),G1H4(866),G1H4(867),4)
  call HG1shiftOLR(G1H4(863),8,4)
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(115),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(115),55,0,G2H2(271),n2h2(171))
  call Hloop_AV_Q(ntryL,G1H4(172),ex5(:),G1H2(116),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(116),55,0,G2H2(272),n2h2(172))
  call Hotf_4pt_reduction(G2H4(773),RedSet_4(188),mass4set(:,1),  & 
G1H4(171),G1H4(172),G1H4(868),G1H4(869),G1H4(870),G0H4(3),4)
  call HG1shiftOLR(G1H4(172),8,4)
  call Hotf_5pt_reduction(G2H4(495),RedSet_5(114),mass5set(:,1),  & 
G1H4(871),G1H4(872),G1H4(873),G1H4(874),G1H4(875),G1H4(876),4)
  call HG1shiftOLR(G1H4(872),16,4)
  call Hotf_4pt_reduction(G2H4(498),RedSet_4(264),mass4set(:,1),  & 
G1H4(877),G1H4(878),G1H4(879),G1H4(880),G1H4(881),G0H4(4),4)
  call HG1shiftOLR(G1H4(878),16,4)
  call Hloop_QV_A(ntryL,G1H4(185),ex4(:),G1H2(121),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(121),47,0,G2H2(273),n2h2(173))
  call Hotf_5pt_reduction(G2H4(500),RedSet_5(115),mass5set(:,1),  & 
G1H4(185),G1H4(882),G1H4(883),G1H4(884),G1H4(885),G1H4(886),4)
  call HG1shiftOLR(G1H4(882),8,4)
  call Hotf_4pt_reduction(G2H4(503),RedSet_4(271),mass4set(:,1),  & 
G1H4(887),G1H4(888),G1H4(889),G1H4(890),G1H4(891),G0H4(5),4)
  call HG1shiftOLR(G1H4(888),8,4)
  call Hloop_QV_A(ntryL,G1H4(197),ex5(:),G1H2(122),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(274),n2h2(174))
  call Hotf_5pt_reduction(G2H4(210),RedSet_5(212),mass5set(:,1),  & 
G1H4(197),G1H4(892),G1H4(893),G1H4(894),G1H4(895),G1H4(896),4)
  call HG1shiftOLR(G1H4(892),16,4)
  call Hloop_AV_Q(ntryL,G1H4(207),ex3(:),G1H2(127),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(275),n2h2(175))
  call Hloop_AV_Q(ntryL,G1H4(484),ex3(:),G1H2(128),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(276),n2h2(176))
  call Hotf_4pt_reduction(G2H4(741),RedSet_4(70),mass4set(:,1),  & 
G1H4(207),G1H4(484),G1H4(897),G1H4(898),G1H4(899),G0H4(6),4)
  call HG1shiftOLR(G1H4(484),16,4)
  call Hotf_5pt_reduction(G2H4(217),RedSet_5(204),mass5set(:,1),  & 
G1H4(900),G1H4(901),G1H4(902),G1H4(903),G1H4(904),G1H4(905),4)
  call HG1shiftOLR(G1H4(901),16,4)
  call Hloop_QV_A(ntryL,G1H4(219),ex4(:),G1H2(133),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(133),47,0,G2H2(277),n2h2(177))
  call Hloop_QV_A(ntryL,G1H4(220),ex4(:),G1H2(134),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(278),n2h2(178))
  call Hotf_4pt_reduction(G2H4(789),RedSet_4(175),mass4set(:,1),  & 
G1H4(219),G1H4(220),G1H4(906),G1H4(907),G1H4(908),G0H4(7),4)
  call HG1shiftOLR(G1H4(220),16,4)
  call Hotf_5pt_reduction(G2H4(505),RedSet_5(116),mass5set(:,1),  & 
G1H4(909),G1H4(910),G1H4(911),G1H4(912),G1H4(913),G1H4(914),4)
  call HG1shiftOLR(G1H4(910),16,4)
  call Hotf_4pt_reduction(G2H4(508),RedSet_4(264),mass4set(:,1),  & 
G1H4(915),G1H4(916),G1H4(917),G1H4(918),G1H4(919),G0H4(8),4)
  call HG1shiftOLR(G1H4(916),16,4)
  call Hloop_QV_A(ntryL,G1H4(377),ex3(:),G1H2(139),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(139),47,0,G2H2(279),n2h2(179))
  call Hotf_5pt_reduction(G2H4(510),RedSet_5(117),mass5set(:,1),  & 
G1H4(377),G1H4(920),G1H4(921),G1H4(922),G1H4(923),G1H4(924),4)
  call HG1shiftOLR(G1H4(920),4,4)
  call Hotf_4pt_reduction(G2H4(513),RedSet_4(295),mass4set(:,1),  & 
G1H4(925),G1H4(926),G1H4(927),G1H4(928),G1H4(929),G0H4(9),4)
  call HG1shiftOLR(G1H4(926),4,4)
  call Hloop_QV_A(ntryL,G1H4(461),ex5(:),G1H2(140),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_Q_A(ntryL,G1H2(140),59,0,G2H2(280),n2h2(180))
  call Hotf_5pt_reduction(G2H4(226),RedSet_5(206),mass5set(:,1),  & 
G1H4(461),G1H4(930),G1H4(931),G1H4(932),G1H4(933),G1H4(934),4)
  call HG1shiftOLR(G1H4(930),8,4)
  call Hloop_QV_A(ntryL,G1H4(255),ex5(:),G1H2(145),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(145),55,0,G2H2(281),n2h2(181))
  call Hloop_QV_A(ntryL,G1H4(256),ex5(:),G1H2(146),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_Q_A(ntryL,G1H2(146),55,0,G2H2(282),n2h2(182))
  call Hotf_4pt_reduction(G2H4(765),RedSet_4(188),mass4set(:,1),  & 
G1H4(255),G1H4(256),G1H4(935),G1H4(936),G1H4(937),G0H4(10),4)
  call HG1shiftOLR(G1H4(256),8,4)
  call Hotf_5pt_reduction(G2H4(515),RedSet_5(118),mass5set(:,1),  & 
G1H4(938),G1H4(939),G1H4(940),G1H4(941),G1H4(942),G1H4(943),4)
  call HG1shiftOLR(G1H4(939),8,4)
  call Hotf_4pt_reduction(G2H4(518),RedSet_4(271),mass4set(:,1),  & 
G1H4(944),G1H4(945),G1H4(946),G1H4(947),G1H4(948),G0H4(11),4)
  call HG1shiftOLR(G1H4(945),8,4)
  call Hloop_QV_A(ntryL,G1H4(425),ex3(:),G1H2(151),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(151),55,0,G2H2(283),n2h2(183))
  call Hotf_5pt_reduction(G2H4(520),RedSet_5(119),mass5set(:,1),  & 
G1H4(425),G1H4(949),G1H4(950),G1H4(951),G1H4(952),G1H4(953),4)
  call HG1shiftOLR(G1H4(949),4,4)
  call Hotf_4pt_reduction(G2H4(523),RedSet_4(295),mass4set(:,1),  & 
G1H4(954),G1H4(955),G1H4(956),G1H4(957),G1H4(958),G0H4(12),4)
  call HG1shiftOLR(G1H4(955),4,4)
  call Hloop_QV_A(ntryL,G1H4(473),ex4(:),G1H2(152),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_Q_A(ntryL,G1H2(152),59,0,G2H2(284),n2h2(184))
  call Hotf_5pt_reduction(G2H4(227),RedSet_5(213),mass5set(:,1),  & 
G1H4(473),G1H4(959),G1H4(960),G1H4(961),G1H4(962),G1H4(963),4)
  call HG1shiftOLR(G1H4(959),16,4)
  call Hotf_5pt_reduction(G2H4(525),RedSet_5(114),mass5set(:,1),  & 
G1H4(964),G1H4(965),G1H4(966),G1H4(967),G1H4(968),G1H4(969),4)
  call HG1shiftOLR(G1H4(965),16,4)
  call Hloop_AV_Q(ntryL,G1H4(291),ex4(:),G1H2(157),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(157),47,0,G2H2(285),n2h2(185))
  call Hotf_4pt_reduction(G2H4(528),RedSet_4(264),mass4set(:,1),  & 
G1H4(291),G1H4(970),G1H4(971),G1H4(972),G1H4(973),G0H4(13),4)
  call HG1shiftOLR(G1H4(970),16,4)
  call Hloop_AV_Q(ntryL,G1H4(293),ex4(:),G1H2(158),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(158),47,0,G2H2(286),n2h2(186))
  call Hotf_5pt_reduction(G2H4(229),RedSet_5(214),mass5set(:,1),  & 
G1H4(293),G1H4(974),G1H4(975),G1H4(976),G1H4(977),G1H4(978),4)
  call HG1shiftOLR(G1H4(974),8,4)
  call Hotf_5pt_reduction(G2H4(530),RedSet_5(115),mass5set(:,1),  & 
G1H4(979),G1H4(980),G1H4(981),G1H4(982),G1H4(983),G1H4(984),4)
  call HG1shiftOLR(G1H4(980),8,4)
  call Hloop_AV_Q(ntryL,G1H4(303),ex5(:),G1H2(163),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(163),55,0,G2H2(287),n2h2(187))
  call Hotf_4pt_reduction(G2H4(533),RedSet_4(271),mass4set(:,1),  & 
G1H4(303),G1H4(985),G1H4(986),G1H4(987),G1H4(988),G0H4(14),4)
  call HG1shiftOLR(G1H4(985),8,4)
  call Hloop_AV_Q(ntryL,G1H4(305),ex5(:),G1H2(164),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(164),55,0,G2H2(288),n2h2(188))
  call Hotf_5pt_reduction(G2H4(233),RedSet_5(215),mass5set(:,1),  & 
G1H4(305),G1H4(989),G1H4(990),G1H4(991),G1H4(992),G1H4(993),4)
  call HG1shiftOLR(G1H4(989),16,4)
  call Hotf_5pt_reduction(G2H4(535),RedSet_5(116),mass5set(:,1),  & 
G1H4(994),G1H4(995),G1H4(996),G1H4(997),G1H4(998),G1H4(999),4)
  call HG1shiftOLR(G1H4(995),16,4)
  call Hloop_AV_Q(ntryL,G1H4(315),ex3(:),G1H2(169),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(169),47,0,G2H2(289),n2h2(189))
  call Hotf_4pt_reduction(G2H4(538),RedSet_4(264),mass4set(:,1),  & 
G1H4(315),G1H4(1000),G1H4(1001),G1H4(1002),G1H4(1003),G0H4(15),4)
  call HG1shiftOLR(G1H4(1000),16,4)
  call Hloop_AV_Q(ntryL,G1H4(485),ex3(:),G1H2(170),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(170),47,0,G2H2(290),n2h2(190))
  call Hotf_5pt_reduction(G2H4(234),RedSet_5(216),mass5set(:,1),  & 
G1H4(485),G1H4(1004),G1H4(1005),G1H4(1006),G1H4(1007),G1H4(1008),4)
  call HG1shiftOLR(G1H4(1004),4,4)
  call Hotf_5pt_reduction(G2H4(540),RedSet_5(117),mass5set(:,1),  & 
G1H4(1009),G1H4(1010),G1H4(1011),G1H4(1012),G1H4(1013),G1H4(1014),4)
  call HG1shiftOLR(G1H4(1010),4,4)
  call Hloop_AV_Q(ntryL,G1H4(327),ex5(:),G1H2(175),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(175),59,0,G2H2(291),n2h2(191))
  call Hotf_4pt_reduction(G2H4(543),RedSet_4(295),mass4set(:,1),  & 
G1H4(327),G1H4(1015),G1H4(1016),G1H4(1017),G1H4(1018),G0H4(16),4)
  call HG1shiftOLR(G1H4(1015),4,4)
  call Hloop_AV_Q(ntryL,G1H4(509),ex5(:),G1H2(176),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(176),59,0,G2H2(292),n2h2(192))
  call Hotf_5pt_reduction(G2H4(236),RedSet_5(217),mass5set(:,1),  & 
G1H4(509),G1H4(1019),G1H4(1020),G1H4(1021),G1H4(1022),G1H4(1023),4)
  call HG1shiftOLR(G1H4(1019),8,4)
  call Hotf_5pt_reduction(G2H4(545),RedSet_5(118),mass5set(:,1),  & 
G1H4(1024),G1H4(1025),G1H4(1026),G1H4(1027),G1H4(1028),G1H4(1029),4)
  call HG1shiftOLR(G1H4(1025),8,4)
  call Hloop_AV_Q(ntryL,G1H4(339),ex3(:),G1H2(181),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(181),55,0,G2H2(293),n2h2(193))
  call Hotf_4pt_reduction(G2H4(548),RedSet_4(271),mass4set(:,1),  & 
G1H4(339),G1H4(1030),G1H4(1031),G1H4(1032),G1H4(1033),G0H4(17),4)
  call HG1shiftOLR(G1H4(1030),8,4)
  call Hloop_AV_Q(ntryL,G1H4(533),ex3(:),G1H2(182),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(182),55,0,G2H2(294),n2h2(194))
  call Hotf_5pt_reduction(G2H4(240),RedSet_5(218),mass5set(:,1),  & 
G1H4(533),G1H4(1034),G1H4(1035),G1H4(1036),G1H4(1037),G1H4(1038),4)
  call HG1shiftOLR(G1H4(1034),4,4)
  call Hotf_5pt_reduction(G2H4(550),RedSet_5(119),mass5set(:,1),  & 
G1H4(1039),G1H4(1040),G1H4(1041),G1H4(1042),G1H4(1043),G1H4(1044),4)
  call HG1shiftOLR(G1H4(1040),4,4)
  call Hloop_AV_Q(ntryL,G1H4(351),ex4(:),G1H2(187),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(187),59,0,G2H2(295),n2h2(195))
  call Hotf_4pt_reduction(G2H4(553),RedSet_4(295),mass4set(:,1),  & 
G1H4(351),G1H4(1045),G1H4(1046),G1H4(1047),G1H4(1048),G0H4(18),4)
  call HG1shiftOLR(G1H4(1045),4,4)
  call Hloop_AV_Q(ntryL,G1H4(545),ex4(:),G1H2(188),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(188),59,0,G2H2(296),n2h2(196))
  call Hotf_5pt_reduction(G2H4(244),RedSet_5(98),mass5set(:,1),  & 
G1H4(545),G1H4(1049),G1H4(1050),G1H4(1051),G1H4(1052),G1H4(1053),4)
  call HG1shiftOLR(G1H4(1049),16,4)
  call Hloop_VA_Q(ntryL,G1H4(363),ex2(:),G1H2(193),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(193),47,0,G2H2(297),n2h2(197))
  call Hloop_VA_Q(ntryL,G1H4(364),ex2(:),G1H2(194),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(194),47,0,G2H2(298),n2h2(198))
  call Hotf_5pt_reduction(G2H4(250),RedSet_5(219),mass5set(:,1),  & 
G1H4(363),G1H4(364),G1H4(1054),G1H4(1055),G1H4(1056),G1H4(1057),4)
  call HG1shiftOLR(G1H4(364),16,4)
  call Hloop_QV_A(ntryL,G1H4(375),ex3(:),G1H2(199),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(199),47,0,G2H2(299),n2h2(199))
  call Hotf_5pt_reduction(G2H4(251),RedSet_5(220),mass5set(:,1),  & 
G1H4(375),G1H4(1058),G1H4(1059),G1H4(1060),G1H4(1061),G1H4(1062),4)
  call HG1shiftOLR(G1H4(1058),4,4)
  call Hotf_5pt_reduction(G2H4(254),RedSet_5(221),mass5set(:,1),  & 
G1H4(1063),G1H4(1064),G1H4(1065),G1H4(1066),G1H4(1067),G1H4(1068),4)
  call HG1shiftOLR(G1H4(1064),4,4)
  call Hloop_VQ_A(ntryL,G1H4(387),ex1(:),G1H2(200),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(200),59,0,G2H2(300),n2h2(200))
  call Hloop_VQ_A(ntryL,G1H4(388),ex1(:),G1H2(205),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(205),59,0,G2H2(301),n2h2(201))
  call Hloop_VQ_A(ntryL,G1H4(413),ex1(:),G1H2(206),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(302),n2h2(202))
  call Hotf_5pt_reduction(G2H4(261),RedSet_5(100),mass5set(:,1),  & 
G1H4(387),G1H4(388),G1H4(413),G1H4(1069),G1H4(1070),G1H4(1071),4)
  call HG1shiftOLR(G1H4(388),8,4)
  call Hloop_VA_Q(ntryL,G1H4(399),ex2(:),G1H2(211),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(211),55,0,G2H2(303),n2h2(203))
  call Hloop_VA_Q(ntryL,G1H4(400),ex2(:),G1H2(212),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(212),55,0,G2H2(304),n2h2(204))
  call Hotf_5pt_reduction(G2H4(264),RedSet_5(222),mass5set(:,1),  & 
G1H4(399),G1H4(400),G1H4(1072),G1H4(1073),G1H4(1074),G1H4(1075),4)
  call HG1shiftOLR(G1H4(400),4,4)
  call Hotf_5pt_reduction(G2H4(270),RedSet_5(223),mass5set(:,1),  & 
G1H4(1076),G1H4(1077),G1H4(1078),G1H4(1079),G1H4(1080),G1H4(1081),4)
  call HG1shiftOLR(G1H4(1077),4,4)
  call Hloop_VQ_A(ntryL,G1H4(411),ex1(:),G1H2(217),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_Q_A(ntryL,G1H2(217),59,0,G2H2(305),n2h2(205))
  call Hloop_VQ_A(ntryL,G1H4(412),ex1(:),G1H2(218),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(218),59,0,G2H2(306),n2h2(206))
  call Hotf_5pt_reduction(G2H4(271),RedSet_5(224),mass5set(:,1),  & 
G1H4(411),G1H4(412),G1H4(1082),G1H4(1083),G1H4(1084),G1H4(1085),4)
  call HG1shiftOLR(G1H4(412),8,4)
  call Hotf_5pt_reduction(G2H4(273),RedSet_5(225),mass5set(:,1),  & 
G1H4(1086),G1H4(1087),G1H4(1088),G1H4(1089),G1H4(1090),G1H4(1091),4)
  call HG1shiftOLR(G1H4(1087),8,4)
  call Hloop_QV_A(ntryL,G1H4(423),ex3(:),G1H2(223),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_Q_A(ntryL,G1H2(223),55,0,G2H2(307),n2h2(207))
  call Hloop_QV_A(ntryL,G1H4(424),ex3(:),G1H2(224),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_Q_A(ntryL,G1H2(224),55,0,G2H2(308),n2h2(208))
  call Hotf_5pt_reduction(G2H4(278),RedSet_5(104),mass5set(:,1),  & 
G1H4(423),G1H4(424),G1H4(1092),G1H4(1093),G1H4(1094),G1H4(1095),4)
  call HG1shiftOLR(G1H4(424),16,4)
  call Hloop_VQ_A(ntryL,G1H4(435),ex1(:),G1H2(229),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(229),47,0,G2H2(309),n2h2(209))
  call Hloop_VQ_A(ntryL,G1H4(436),ex1(:),G1H2(230),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_Q_A(ntryL,G1H2(230),47,0,G2H2(310),n2h2(210))
  call Hotf_5pt_reduction(G2H4(284),RedSet_5(106),mass5set(:,1),  & 
G1H4(435),G1H4(436),G1H4(1096),G1H4(1097),G1H4(1098),G1H4(1099),4)
  call HG1shiftOLR(G1H4(436),8,4)
  call Hloop_VQ_A(ntryL,G1H4(447),ex1(:),G1H2(235),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(235),55,0,G2H2(311),n2h2(211))
  call Hloop_VQ_A(ntryL,G1H4(448),ex1(:),G1H2(236),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(236),55,0,G2H2(312),n2h2(212))
  call Hotf_5pt_reduction(G2H4(285),RedSet_5(226),mass5set(:,1),  & 
G1H4(447),G1H4(448),G1H4(1100),G1H4(1101),G1H4(1102),G1H4(1103),4)
  call HG1shiftOLR(G1H4(448),4,4)
  call Hotf_5pt_reduction(G2H4(288),RedSet_5(227),mass5set(:,1),  & 
G1H4(1104),G1H4(1105),G1H4(1106),G1H4(1107),G1H4(1108),G1H4(1109),4)
  call HG1shiftOLR(G1H4(1105),4,4)
  call Hloop_QV_A(ntryL,G1H4(459),ex5(:),G1H2(241),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(241),59,0,G2H2(313),n2h2(213))
  call Hloop_QV_A(ntryL,G1H4(460),ex5(:),G1H2(242),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_Q_A(ntryL,G1H2(242),59,0,G2H2(314),n2h2(214))
  call Hotf_5pt_reduction(G2H4(294),RedSet_5(228),mass5set(:,1),  & 
G1H4(459),G1H4(460),G1H4(1110),G1H4(1111),G1H4(1112),G1H4(1113),4)
  call HG1shiftOLR(G1H4(460),4,4)
  call Hotf_5pt_reduction(G2H4(295),RedSet_5(229),mass5set(:,1),  & 
G1H4(1114),G1H4(1115),G1H4(1116),G1H4(1117),G1H4(1118),G1H4(1119),4)
  call HG1shiftOLR(G1H4(1115),4,4)
  call Hloop_QV_A(ntryL,G1H4(471),ex4(:),G1H2(247),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(247),59,0,G2H2(315),n2h2(215))
  call Hloop_QV_A(ntryL,G1H4(472),ex4(:),G1H2(248),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(248),59,0,G2H2(316),n2h2(216))
  call Hotf_5pt_reduction(G2H4(297),RedSet_5(230),mass5set(:,1),  & 
G1H4(471),G1H4(472),G1H4(1120),G1H4(1121),G1H4(1122),G1H4(1123),4)
  call HG1shiftOLR(G1H4(472),16,4)
  call Hloop_AV_Q(ntryL,G1H4(483),ex3(:),G1H2(253),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(253),47,0,G2H2(317),n2h2(217))
  call Hotf_5pt_reduction(G2H4(301),RedSet_5(231),mass5set(:,1),  & 
G1H4(483),G1H4(1124),G1H4(1125),G1H4(1126),G1H4(1127),G1H4(1128),4)
  call HG1shiftOLR(G1H4(1124),4,4)
  call Hotf_5pt_reduction(G2H4(302),RedSet_5(232),mass5set(:,1),  & 
G1H4(1129),G1H4(1130),G1H4(1131),G1H4(1132),G1H4(1133),G1H4(1134),4)
  call HG1shiftOLR(G1H4(1130),4,4)
  call Hloop_VA_Q(ntryL,G1H4(495),ex2(:),G1H2(254),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_A_Q(ntryL,G1H2(254),59,0,G2H2(318),n2h2(218))
  call Hloop_VA_Q(ntryL,G1H4(496),ex2(:),G1H2(259),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_A_Q(ntryL,G1H2(259),59,0,G2H2(319),n2h2(219))
  call Hloop_VA_Q(ntryL,G1H4(521),ex2(:),G1H2(260),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_A_Q(ntryL,G1H2(260),59,0,G2H2(320),n2h2(220))
  call Hotf_5pt_reduction(G2H4(304),RedSet_5(233),mass5set(:,1),  & 
G1H4(495),G1H4(496),G1H4(521),G1H4(1135),G1H4(1136),G1H4(1137),4)
  call HG1shiftOLR(G1H4(496),4,4)
  call Hotf_5pt_reduction(G2H4(308),RedSet_5(234),mass5set(:,1),  & 
G1H4(1138),G1H4(1139),G1H4(1140),G1H4(1141),G1H4(1142),G1H4(1143),4)
  call HG1shiftOLR(G1H4(1139),4,4)
  call Hloop_AV_Q(ntryL,G1H4(507),ex5(:),G1H2(265),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_A_Q(ntryL,G1H2(265),59,0,G2H2(321),n2h2(221))
  call Hloop_AV_Q(ntryL,G1H4(508),ex5(:),G1H2(266),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_A_Q(ntryL,G1H2(266),59,0,G2H2(322),n2h2(222))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(235),mass5set(:,1),  & 
G1H4(507),G1H4(508),G1H4(1144),G1H4(1145),G1H4(1146),G1H4(1147),4)
  call HG1shiftOLR(G1H4(508),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(236),mass5set(:,1),  & 
G1H4(1148),G1H4(1149),G1H4(1150),G1H4(1151),G1H4(1152),G1H4(1153),4)
  call HG1shiftOLR(G1H4(1149),4,4)
  call Hloop_VA_Q(ntryL,G1H4(519),ex2(:),G1H2(271),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_A_Q(ntryL,G1H2(271),59,0,G2H2(323),n2h2(223))
  call Hloop_VA_Q(ntryL,G1H4(520),ex2(:),G1H2(272),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_A_Q(ntryL,G1H2(272),59,0,G2H2(324),n2h2(224))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(237),mass5set(:,1),  & 
G1H4(519),G1H4(520),G1H4(1154),G1H4(1155),G1H4(1156),G1H4(1157),4)
  call HG1shiftOLR(G1H4(520),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(238),mass5set(:,1),  & 
G1H4(1158),G1H4(1159),G1H4(1160),G1H4(1161),G1H4(1162),G1H4(1163),4)
  call HG1shiftOLR(G1H4(1159),8,4)
  call Hloop_AV_Q(ntryL,G1H4(531),ex3(:),G1H2(277),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_A_Q(ntryL,G1H2(277),55,0,G2H2(325),n2h2(225))
  call Hloop_AV_Q(ntryL,G1H4(532),ex3(:),G1H2(278),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(278),55,0,G2H2(326),n2h2(226))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(239),mass5set(:,1),  & 
G1H4(531),G1H4(532),G1H4(1164),G1H4(1165),G1H4(1166),G1H4(1167),4)
  call HG1shiftOLR(G1H4(532),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(240),mass5set(:,1),  & 
G1H4(1168),G1H4(1169),G1H4(1170),G1H4(1171),G1H4(1172),G1H4(1173),4)
  call HG1shiftOLR(G1H4(1169),4,4)
  call Hloop_AV_Q(ntryL,G1H4(543),ex4(:),G1H2(283),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(283),59,0,G2H2(327),n2h2(227))
  call Hloop_AV_Q(ntryL,G1H4(544),ex4(:),G1H2(284),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_A_Q(ntryL,G1H2(284),59,0,G2H2(328),n2h2(228))
  call Hotf_5pt_reduction(G2H4(575),RedSet_5(124),mass5set(:,1),  & 
G1H4(543),G1H4(544),G1H4(1174),G1H4(1175),G1H4(1176),G1H4(1177),4)
  call HG1shiftOLR(G1H4(544),2,4)
  call Hotf_5pt_reduction(G2H4(440),RedSet_5(101),mass5set(:,1),  & 
G1H4(1178),G1H4(1179),G1H4(1180),G1H4(1181),G1H4(1182),G1H4(1183),4)
  call HG1shiftOLR(G1H4(1179),2,4)
  call Hotf_4pt_reduction(G2H4(577),RedSet_4(6),mass4set(:,1),  & 
G1H4(1184),G1H4(1185),G1H4(1186),G1H4(1187),G1H4(1188),4)
  call HG1shiftOLR(G1H4(1185),2,4)
  call Hotf_4pt_reduction(G2H4(442),RedSet_4(10),mass4set(:,1),  & 
G1H4(1189),G1H4(1190),G1H4(1191),G1H4(1192),G1H4(1193),4)
  call HG1shiftOLR(G1H4(1190),2,4)
  call Hloop_QV_A(ntryL,G1H4(561),ex4(:),G1H2(289),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(289),61,0,G2H2(329),n2h2(229))
  call Hloop_QV_A(ntryL,G1H4(562),ex4(:),G1H2(290),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_Q_A(ntryL,G1H2(290),61,0,G2H2(330),n2h2(230))
  call Hloop_QV_A(ntryL,G1H4(648),ex4(:),G1H2(295),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(295),61,0,G2H2(331),n2h2(231))
  call Hotf_5pt_reduction(G2H4(579),RedSet_5(125),mass5set(:,1),  & 
G1H4(561),G1H4(562),G1H4(648),G1H4(1194),G1H4(1195),G1H4(1196),4)
  call HG1shiftOLR(G1H4(562),2,4)
  call Hotf_5pt_reduction(G2H4(444),RedSet_5(102),mass5set(:,1),  & 
G1H4(1197),G1H4(1198),G1H4(1199),G1H4(1200),G1H4(1201),G1H4(1202),4)
  call HG1shiftOLR(G1H4(1198),2,4)
  call Hotf_4pt_reduction(G2H4(581),RedSet_4(6),mass4set(:,1),  & 
G1H4(1203),G1H4(1204),G1H4(1205),G1H4(1206),G1H4(1207),4)
  call HG1shiftOLR(G1H4(1204),2,4)
  call Hotf_4pt_reduction(G2H4(446),RedSet_4(10),mass4set(:,1),  & 
G1H4(1208),G1H4(1209),G1H4(1210),G1H4(1211),G1H4(1212),4)
  call HG1shiftOLR(G1H4(1209),2,4)
  call Hloop_QV_A(ntryL,G1H4(578),ex5(:),G1H2(296),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_Q_A(ntryL,G1H2(296),61,0,G2H2(332),n2h2(232))
  call Hloop_QV_A(ntryL,G1H4(579),ex5(:),G1H2(301),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(301),61,0,G2H2(333),n2h2(233))
  call Hloop_QV_A(ntryL,G1H4(614),ex5(:),G1H2(302),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(302),61,0,G2H2(334),n2h2(234))
  call Hotf_5pt_reduction(G2H4(598),RedSet_5(129),mass5set(:,1),  & 
G1H4(578),G1H4(579),G1H4(614),G1H4(1213),G1H4(1214),G1H4(1215),4)
  call HG1shiftOLR(G1H4(579),2,4)
  call Hotf_5pt_reduction(G2H4(470),RedSet_5(108),mass5set(:,1),  & 
G1H4(1216),G1H4(1217),G1H4(1218),G1H4(1219),G1H4(1220),G1H4(1221),4)
  call HG1shiftOLR(G1H4(1217),2,4)
  call Hotf_4pt_reduction(G2H4(600),RedSet_4(30),mass4set(:,1),  & 
G1H4(1222),G1H4(1223),G1H4(1224),G1H4(1225),G1H4(1226),4)
  call HG1shiftOLR(G1H4(1223),2,4)
  call Hotf_4pt_reduction(G2H4(472),RedSet_4(34),mass4set(:,1),  & 
G1H4(1227),G1H4(1228),G1H4(1229),G1H4(1230),G1H4(1231),4)
  call HG1shiftOLR(G1H4(1228),2,4)
  call Hloop_QV_A(ntryL,G1H4(595),ex3(:),G1H2(307),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(307),61,0,G2H2(335),n2h2(235))
  call Hloop_QV_A(ntryL,G1H4(596),ex3(:),G1H2(308),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(308),61,0,G2H2(336),n2h2(236))
  call Hloop_QV_A(ntryL,G1H4(631),ex3(:),G1H2(313),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(313),61,0,G2H2(337),n2h2(237))
  call Hotf_5pt_reduction(G2H4(602),RedSet_5(130),mass5set(:,1),  & 
G1H4(595),G1H4(596),G1H4(631),G1H4(1232),G1H4(1233),G1H4(1234),4)
  call HG1shiftOLR(G1H4(596),2,4)
  call Hotf_5pt_reduction(G2H4(474),RedSet_5(109),mass5set(:,1),  & 
G1H4(1235),G1H4(1236),G1H4(1237),G1H4(1238),G1H4(1239),G1H4(1240),4)
  call HG1shiftOLR(G1H4(1236),2,4)
  call Hotf_4pt_reduction(G2H4(604),RedSet_4(30),mass4set(:,1),  & 
G1H4(1241),G1H4(1242),G1H4(1243),G1H4(1244),G1H4(1245),4)
  call HG1shiftOLR(G1H4(1242),2,4)
  call Hotf_4pt_reduction(G2H4(476),RedSet_4(34),mass4set(:,1),  & 
G1H4(1246),G1H4(1247),G1H4(1248),G1H4(1249),G1H4(1250),4)
  call HG1shiftOLR(G1H4(1247),2,4)
  call Hloop_QV_A(ntryL,G1H4(612),ex5(:),G1H2(314),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_Q_A(ntryL,G1H2(314),61,0,G2H2(338),n2h2(238))
  call Hloop_QV_A(ntryL,G1H4(613),ex5(:),G1H2(319),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(319),61,0,G2H2(339),n2h2(239))
  call Hotf_5pt_reduction(G2H4(611),RedSet_5(132),mass5set(:,1),  & 
G1H4(612),G1H4(613),G1H4(1251),G1H4(1252),G1H4(1253),G1H4(1254),4)
  call HG1shiftOLR(G1H4(613),2,4)
  call Hotf_5pt_reduction(G2H4(487),RedSet_5(112),mass5set(:,1),  & 
G1H4(1255),G1H4(1256),G1H4(1257),G1H4(1258),G1H4(1259),G1H4(1260),4)
  call HG1shiftOLR(G1H4(1256),2,4)
  call Hotf_4pt_reduction(G2H4(613),RedSet_4(48),mass4set(:,1),  & 
G1H4(1261),G1H4(1262),G1H4(1263),G1H4(1264),G1H4(1265),4)
  call HG1shiftOLR(G1H4(1262),2,4)
  call Hotf_4pt_reduction(G2H4(489),RedSet_4(51),mass4set(:,1),  & 
G1H4(1266),G1H4(1267),G1H4(1268),G1H4(1269),G1H4(1270),4)
  call HG1shiftOLR(G1H4(1267),2,4)
  call Hloop_QV_A(ntryL,G1H4(629),ex3(:),G1H2(320),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(320),61,0,G2H2(340),n2h2(240))
  call Hloop_QV_A(ntryL,G1H4(630),ex3(:),G1H2(325),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(325),61,0,G2H2(341),n2h2(241))
  call Hotf_5pt_reduction(G2H4(615),RedSet_5(133),mass5set(:,1),  & 
G1H4(629),G1H4(630),G1H4(1271),G1H4(1272),G1H4(1273),G1H4(1274),4)
  call HG1shiftOLR(G1H4(630),2,4)
  call Hotf_5pt_reduction(G2H4(491),RedSet_5(113),mass5set(:,1),  & 
G1H4(1275),G1H4(1276),G1H4(1277),G1H4(1278),G1H4(1279),G1H4(1280),4)
  call HG1shiftOLR(G1H4(1276),2,4)
  call Hotf_4pt_reduction(G2H4(617),RedSet_4(48),mass4set(:,1),  & 
G1H4(1281),G1H4(1282),G1H4(1283),G1H4(1284),G1H4(1285),4)
  call HG1shiftOLR(G1H4(1282),2,4)
  call Hotf_4pt_reduction(G2H4(493),RedSet_4(51),mass4set(:,1),  & 
G1H4(1286),G1H4(1287),G1H4(1288),G1H4(1289),G1H4(1290),4)
  call HG1shiftOLR(G1H4(1287),2,4)
  call Hloop_QV_A(ntryL,G1H4(646),ex4(:),G1H2(326),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_Q_A(ntryL,G1H2(326),61,0,G2H2(342),n2h2(242))
  call Hloop_QV_A(ntryL,G1H4(647),ex4(:),G1H2(331),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(331),61,0,G2H2(343),n2h2(243))
  call Hloop_QA_V(ntryL,G2H4(420),ex2(:),G2H2(344),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_QA_V(ntryL,G2H4(378),ex2(:),G2H2(345),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_AQ_V(ntryL,G2H4(558),ex1(:),G2H2(346),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_AQ_V(ntryL,G2H4(392),ex1(:),G2H2(347),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_AQ_V(ntryL,G2H4(406),ex1(:),G2H2(348),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_AQ_V(ntryL,G2H4(401),ex1(:),G2H2(349),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_AQ_V(ntryL,G2H4(563),ex1(:),G2H2(350),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_QA_V(ntryL,G2H4(568),ex2(:),G2H2(351),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_QA_V(ntryL,G2H4(429),ex2(:),G2H2(352),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_QA_V(ntryL,G2H4(573),ex2(:),G2H2(353),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_QA_V(ntryL,G2H4(438),ex2(:),G2H2(354),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_AQ_V(ntryL,G2H4(586),ex1(:),G2H2(355),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_AQ_V(ntryL,G2H4(455),ex1(:),G2H2(356),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_AQ_V(ntryL,G2H4(591),ex1(:),G2H2(357),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_AQ_V(ntryL,G2H4(464),ex1(:),G2H2(358),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_QA_V(ntryL,G2H4(596),ex2(:),G2H2(359),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_QA_V(ntryL,G2H4(609),ex2(:),G2H2(360),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_QA_V(ntryL,G2H4(485),ex2(:),G2H2(361),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(35),mass5set(:,1),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(37),5,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(48),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(50),G1H8(53),G1H8(54),G1H8(55),8)
  call HG1shiftOLR(G1H8(48),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(46),mass5set(:,1),  & 
G1H8(56),G1H8(60),G1H8(62),G1H8(66),G1H8(68),G1H8(72),8)
  call HG1shiftOLR(G1H8(60),16,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(33),mass5set(:,1),  & 
G1H8(78),G1H8(80),G1H8(84),G1H8(85),G1H8(89),G1H8(125),8)
  call HG1shiftOLR(G1H8(80),5,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(44),mass5set(:,1),  & 
G1H8(394),G1H8(214),G1H8(232),G1H8(268),G1H8(249),G1H8(213),8)
  call HG1shiftOLR(G1H8(214),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(18),mass5set(:,1),  & 
G1H8(286),G1H8(304),G1H8(33),G1H8(322),G1H8(27),G1H8(103),8)
  call HG1shiftOLR(G1H8(304),6,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(58),mass5set(:,1),  & 
G1H8(340),G1H8(358),G1H8(57),G1H8(108),G1H8(412),G1H8(51),8)
  call HG1shiftOLR(G1H8(358),16,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(42),mass5set(:,1),  & 
G1H8(107),G1H8(448),G1H8(75),G1H8(110),G1H8(466),G1H8(69),8)
  call HG1shiftOLR(G1H8(448),16,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(20),mass5set(:,1),  & 
G1H8(484),G1H8(9),G1H8(124),G1H8(10),G1H8(16),G1H8(28),8)
  call HG1shiftOLR(G1H8(9),6,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(61),mass5set(:,1),  & 
G1H8(34),G1H8(39),G1H8(178),G1H8(40),G1H8(52),G1H8(58),8)
  call HG1shiftOLR(G1H8(39),8,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(38),mass5set(:,1),  & 
G1H8(64),G1H8(70),G1H8(76),G1H8(82),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(70),9,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(70),mass5set(:,1),  & 
G1H8(93),G1H8(94),G1H8(100),G1H8(105),G1H8(106),G1H8(111),8)
  call HG1shiftOLR(G1H8(94),16,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(76),mass5set(:,1),  & 
G1H8(112),G1H8(123),G1H8(136),G1H8(154),G1H8(160),G1H8(177),8)
  call HG1shiftOLR(G1H8(123),4,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(34),mass5set(:,1),  & 
G1H8(226),G1H8(231),G1H8(256),G1H8(515),G1H8(114),G1H8(116),8)
  call HG1shiftOLR(G1H8(231),10,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(66),mass5set(:,1),  & 
G1H8(119),G1H8(120),G1H8(122),G1H8(126),G1H8(127),G1H8(128),8)
  call HG1shiftOLR(G1H8(120),16,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(79),mass5set(:,1),  & 
G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(138),G1H8(139),8)
  call HG1shiftOLR(G1H8(132),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(37),mass5set(:,1),  & 
G1H8(140),G1H8(143),G1H8(144),G1H8(146),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(143),17,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(72),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(156),G1H8(262),G1H8(267),G1H8(303),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(77),mass5set(:,1),  & 
G1H8(321),G1H8(339),G1H8(357),G1H8(375),G1H8(411),G1H8(429),8)
  call HG1shiftOLR(G1H8(339),4,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(31),mass5set(:,1),  & 
G1H8(447),G1H8(465),G1H8(483),G1H8(2),G1H8(3),G1H8(4),8)
  call HG1shiftOLR(G1H8(465),18,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(67),mass5set(:,1),  & 
G1H8(5),G1H8(6),G1H8(90),G1H8(15),G1H8(67),G1H8(21),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(78),mass5set(:,1),  & 
G1H8(71),G1H8(86),G1H8(45),G1H8(79),G1H8(63),G1H8(83),8)
  call HG1shiftOLR(G1H8(86),4,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(23),mass5set(:,1),  & 
G1H8(95),G1H8(96),G1H8(97),G1H8(98),G1H8(101),G1H8(65),8)
  call HG1shiftOLR(G1H8(96),24,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(22),mass5set(:,1),  & 
G1H8(102),G1H8(129),G1H8(130),G1H8(135),G1H8(141),G1H8(142),8)
  call HG1shiftOLR(G1H8(129),24,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(28),mass5set(:,1),  & 
G1H8(147),G1H8(148),G1H8(153),G1H8(159),G1H8(73),G1H8(165),8)
  call HG1shiftOLR(G1H8(148),24,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(75),mass5set(:,1),  & 
G1H8(166),G1H8(171),G1H8(91),G1H8(183),G1H8(184),G1H8(189),8)
  call HG1shiftOLR(G1H8(171),4,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(25),mass5set(:,1),  & 
G1H8(190),G1H8(196),G1H8(201),G1H8(202),G1H8(207),G1H8(208),8)
  call HG1shiftOLR(G1H8(196),24,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(71),mass5set(:,1),  & 
G1H8(400),G1H8(225),G1H8(406),G1H8(157),G1H8(158),G1H8(161),8)
  call HG1shiftOLR(G1H8(225),4,8)
  call Hloop_AQ_V(ntryL,G2H4(341),ex1(:),G2H2(362),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_AQ_V(ntryL,G2H4(344),ex1(:),G2H2(363),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_AQ_V(ntryL,G2H4(345),ex1(:),G2H2(364),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_AQ_V(ntryL,G2H4(346),ex1(:),G2H2(365),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_AQ_V(ntryL,G2H4(349),ex1(:),G2H2(366),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hloop_AQ_V(ntryL,G2H4(350),ex1(:),G2H2(367),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_QA_V(ntryL,G2H4(351),ex2(:),G2H2(368),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_QA_V(ntryL,G2H4(354),ex2(:),G2H2(369),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_QA_V(ntryL,G2H4(355),ex2(:),G2H2(370),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_QA_V(ntryL,G2H4(356),ex2(:),G2H2(371),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_QA_V(ntryL,G2H4(359),ex2(:),G2H2(372),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_QA_V(ntryL,G2H4(360),ex2(:),G2H2(373),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_QA_V(ntryL,G2H4(361),ex2(:),G2H2(374),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_QA_V(ntryL,G2H4(364),ex2(:),G2H2(375),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_QA_V(ntryL,G2H4(365),ex2(:),G2H2(376),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_AQ_V(ntryL,G2H4(366),ex1(:),G2H2(377),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_AQ_V(ntryL,G2H4(369),ex1(:),G2H2(378),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_AQ_V(ntryL,G2H4(370),ex1(:),G2H2(379),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_QA_V(ntryL,G2H4(375),ex2(:),G2H2(380),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_QA_V(ntryL,G2H4(379),ex2(:),G2H2(381),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_AQ_V(ntryL,G2H4(380),ex1(:),G2H2(382),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_AQ_V(ntryL,G2H4(383),ex1(:),G2H2(383),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_AQ_V(ntryL,G2H4(384),ex1(:),G2H2(384),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_AQ_V(ntryL,G2H4(389),ex1(:),G2H2(385),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_AQ_V(ntryL,G2H4(393),ex1(:),G2H2(386),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_AQ_V(ntryL,G2H4(398),ex1(:),G2H2(387),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_AQ_V(ntryL,G2H4(402),ex1(:),G2H2(388),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_AQ_V(ntryL,G2H4(403),ex1(:),G2H2(389),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_AQ_V(ntryL,G2H4(407),ex1(:),G2H2(390),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_QA_V(ntryL,G2H4(412),ex2(:),G2H2(391),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_QA_V(ntryL,G2H4(415),ex2(:),G2H2(392),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_QA_V(ntryL,G2H4(416),ex2(:),G2H2(393),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_QA_V(ntryL,G2H4(417),ex2(:),G2H2(394),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_QA_V(ntryL,G2H4(421),ex2(:),G2H2(395),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_QA_V(ntryL,G2H4(426),ex2(:),G2H2(396),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_QA_V(ntryL,G2H4(430),ex2(:),G2H2(397),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_QA_V(ntryL,G2H4(435),ex2(:),G2H2(398),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_QA_V(ntryL,G2H4(439),ex2(:),G2H2(399),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hotf_4pt_reduction(G2H4(443),RedSet_4(11),mass4set(:,1),  & 
G1H4(646),G1H4(647),G1H4(1291),G1H4(1292),G1H4(1293),4)
  call HG1shiftOLR(G1H4(647),10,4)
  call Hotf_4pt_reduction(G2H4(447),RedSet_4(23),mass4set(:,1),  & 
G1H4(1294),G1H4(1295),G1H4(1296),G1H4(1297),G1H4(1298),4)
  call HG1shiftOLR(G1H4(1295),18,4)
  call Hloop_AQ_V(ntryL,G2H4(452),ex1(:),G2H2(400),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_AQ_V(ntryL,G2H4(456),ex1(:),G2H2(401),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_AQ_V(ntryL,G2H4(461),ex1(:),G2H2(402),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_AQ_V(ntryL,G2H4(465),ex1(:),G2H2(403),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hotf_4pt_reduction(G2H4(473),RedSet_4(35),mass4set(:,1),  & 
G1H4(1299),G1H4(1300),G1H4(1301),G1H4(1302),G1H4(1303),4)
  call HG1shiftOLR(G1H4(1300),6,4)
  call Hotf_4pt_reduction(G2H4(477),RedSet_4(44),mass4set(:,1),  & 
G1H4(1304),G1H4(1305),G1H4(1306),G1H4(1307),G1H4(1308),4)
  call HG1shiftOLR(G1H4(1305),18,4)
  call Hloop_QA_V(ntryL,G2H4(482),ex2(:),G2H2(404),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_QA_V(ntryL,G2H4(486),ex2(:),G2H2(405),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hotf_4pt_reduction(G2H4(490),RedSet_4(52),mass4set(:,1),  & 
G1H4(1309),G1H4(1310),G1H4(1311),G1H4(1312),G1H4(1313),4)
  call HG1shiftOLR(G1H4(1310),6,4)
  call Hotf_4pt_reduction(G2H4(494),RedSet_4(59),mass4set(:,1),  & 
G1H4(1314),G1H4(1315),G1H4(1316),G1H4(1317),G1H4(1318),4)
  call HG1shiftOLR(G1H4(1315),10,4)
  call Hotf_4pt_reduction(G2H4(499),RedSet_4(265),mass4set(:,1),  & 
G1H4(1319),G1H4(1320),G1H4(1321),G1H4(1322),G1H4(1323),G0H4(19),4)
  call HG1shiftOLR(G1H4(1320),24,4)
  call Hotf_4pt_reduction(G2H4(504),RedSet_4(265),mass4set(:,1),  & 
G1H4(1324),G1H4(1325),G1H4(1326),G1H4(1327),G1H4(1328),G0H4(20),4)
  call HG1shiftOLR(G1H4(1325),24,4)
  call Hotf_4pt_reduction(G2H4(509),RedSet_4(287),mass4set(:,1),  & 
G1H4(1329),G1H4(1330),G1H4(1331),G1H4(1332),G1H4(1333),G0H4(21),4)
  call HG1shiftOLR(G1H4(1330),20,4)
  call Hotf_4pt_reduction(G2H4(514),RedSet_4(287),mass4set(:,1),  & 
G1H4(1334),G1H4(1335),G1H4(1336),G1H4(1337),G1H4(1338),G0H4(22),4)
  call HG1shiftOLR(G1H4(1335),20,4)
  call Hotf_4pt_reduction(G2H4(519),RedSet_4(307),mass4set(:,1),  & 
G1H4(1339),G1H4(1340),G1H4(1341),G1H4(1342),G1H4(1343),G0H4(23),4)
  call HG1shiftOLR(G1H4(1340),12,4)
  call Hotf_4pt_reduction(G2H4(524),RedSet_4(307),mass4set(:,1),  & 
G1H4(1344),G1H4(1345),G1H4(1346),G1H4(1347),G1H4(1348),G0H4(24),4)
  call HG1shiftOLR(G1H4(1345),12,4)
  call Hotf_4pt_reduction(G2H4(529),RedSet_4(265),mass4set(:,1),  & 
G1H4(1349),G1H4(1350),G1H4(1351),G1H4(1352),G1H4(1353),G0H4(25),4)
  call HG1shiftOLR(G1H4(1350),24,4)
  call Hotf_4pt_reduction(G2H4(534),RedSet_4(265),mass4set(:,1),  & 
G1H4(1354),G1H4(1355),G1H4(1356),G1H4(1357),G1H4(1358),G0H4(26),4)
  call HG1shiftOLR(G1H4(1355),24,4)
  call Hotf_4pt_reduction(G2H4(539),RedSet_4(287),mass4set(:,1),  & 
G1H4(1359),G1H4(1360),G1H4(1361),G1H4(1362),G1H4(1363),G0H4(27),4)
  call HG1shiftOLR(G1H4(1360),20,4)
  call Hotf_4pt_reduction(G2H4(544),RedSet_4(287),mass4set(:,1),  & 
G1H4(1364),G1H4(1365),G1H4(1366),G1H4(1367),G1H4(1368),G0H4(28),4)
  call HG1shiftOLR(G1H4(1365),20,4)
  call Hotf_4pt_reduction(G2H4(549),RedSet_4(307),mass4set(:,1),  & 
G1H4(1369),G1H4(1370),G1H4(1371),G1H4(1372),G1H4(1373),G0H4(29),4)
  call HG1shiftOLR(G1H4(1370),12,4)
  call Hotf_4pt_reduction(G2H4(554),RedSet_4(307),mass4set(:,1),  & 
G1H4(1374),G1H4(1375),G1H4(1376),G1H4(1377),G1H4(1378),G0H4(30),4)
  call HG1shiftOLR(G1H4(1375),12,4)
  call Hloop_AQ_V(ntryL,G2H4(555),ex1(:),G2H2(406),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_AQ_V(ntryL,G2H4(559),ex1(:),G2H2(407),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_AQ_V(ntryL,G2H4(560),ex1(:),G2H2(408),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_AQ_V(ntryL,G2H4(564),ex1(:),G2H2(409),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_QA_V(ntryL,G2H4(565),ex2(:),G2H2(410),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_QA_V(ntryL,G2H4(569),ex2(:),G2H2(411),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_QA_V(ntryL,G2H4(570),ex2(:),G2H2(412),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_QA_V(ntryL,G2H4(574),ex2(:),G2H2(413),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hotf_4pt_reduction(G2H4(578),RedSet_4(7),mass4set(:,1),  & 
G1H4(1379),G1H4(1380),G1H4(1381),G1H4(1382),G1H4(1383),4)
  call HG1shiftOLR(G1H4(1380),10,4)
  call Hotf_4pt_reduction(G2H4(582),RedSet_4(20),mass4set(:,1),  & 
G1H4(1384),G1H4(1385),G1H4(1386),G1H4(1387),G1H4(1388),4)
  call HG1shiftOLR(G1H4(1385),18,4)
  call Hloop_AQ_V(ntryL,G2H4(583),ex1(:),G2H2(414),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_AQ_V(ntryL,G2H4(587),ex1(:),G2H2(415),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_AQ_V(ntryL,G2H4(588),ex1(:),G2H2(416),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_AQ_V(ntryL,G2H4(592),ex1(:),G2H2(417),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_QA_V(ntryL,G2H4(593),ex2(:),G2H2(418),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_QA_V(ntryL,G2H4(597),ex2(:),G2H2(419),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hotf_4pt_reduction(G2H4(601),RedSet_4(31),mass4set(:,1),  & 
G1H4(1389),G1H4(1390),G1H4(1391),G1H4(1392),G1H4(1393),4)
  call HG1shiftOLR(G1H4(1390),6,4)
  call Hotf_4pt_reduction(G2H4(605),RedSet_4(42),mass4set(:,1),  & 
G1H4(1394),G1H4(1395),G1H4(1396),G1H4(1397),G1H4(1398),4)
  call HG1shiftOLR(G1H4(1395),18,4)
  call Hloop_QA_V(ntryL,G2H4(606),ex2(:),G2H2(420),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_QA_V(ntryL,G2H4(610),ex2(:),G2H2(421),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hotf_4pt_reduction(G2H4(614),RedSet_4(49),mass4set(:,1),  & 
G1H4(1399),G1H4(1400),G1H4(1401),G1H4(1402),G1H4(1403),4)
  call HG1shiftOLR(G1H4(1400),6,4)
  call Hotf_4pt_reduction(G2H4(618),RedSet_4(57),mass4set(:,1),  & 
G1H4(1404),G1H4(1405),G1H4(1406),G1H4(1407),G1H4(1408),4)
  call HG1shiftOLR(G1H4(1405),10,4)
  call Hloop_QA_V(ntryL,G2H8(83),ex2(:),G2H4(2),m3h2x4(:,891),heltab2x8(:,:,891))
  call Hloop_QA_V(ntryL,G2H8(85),ex2(:),G2H4(105),m3h2x4(:,892),heltab2x8(:,:,892))
  call Hloop_QA_V(ntryL,G2H8(112),ex2(:),G2H4(5),m3h2x4(:,893),heltab2x8(:,:,893))
  call Hloop_QA_V(ntryL,G2H8(125),ex2(:),G2H4(133),m3h2x4(:,894),heltab2x8(:,:,894))
  call Hloop_QA_V(ntryL,G2H8(84),ex2(:),G2H4(8),m3h2x4(:,895),heltab2x8(:,:,895))
  call Hloop_QA_V(ntryL,G2H8(88),ex2(:),G2H4(11),m3h2x4(:,896),heltab2x8(:,:,896))
  call Hloop_QA_V(ntryL,G2H8(36),ex2(:),G2H4(129),m3h2x4(:,897),heltab2x8(:,:,897))
  call Hloop_QA_V(ntryL,G2H8(41),ex2(:),G2H4(14),m3h2x4(:,898),heltab2x8(:,:,898))
  call Hloop_QA_V(ntryL,G2H8(46),ex2(:),G2H4(117),m3h2x4(:,899),heltab2x8(:,:,899))
  call Hloop_AQ_V(ntryL,G2H8(47),ex1(:),G2H4(17),m3h2x4(:,900),heltab2x8(:,:,900))
  call Hloop_AQ_V(ntryL,G2H8(57),ex1(:),G2H4(20),m3h2x4(:,901),heltab2x8(:,:,901))
  call Hloop_AQ_V(ntryL,G2H8(56),ex1(:),G2H4(23),m3h2x4(:,902),heltab2x8(:,:,902))
  call Hloop_AQ_V(ntryL,G2H8(61),ex1(:),G2H4(26),m3h2x4(:,903),heltab2x8(:,:,903))
  call Hloop_AQ_V(ntryL,G2H8(66),ex1(:),G2H4(29),m3h2x4(:,904),heltab2x8(:,:,904))
  call Hloop_AQ_V(ntryL,G2H8(157),ex1(:),G2H4(33),m3h2x4(:,905),heltab2x8(:,:,905))
  call Hloop_AQ_V(ntryL,G2H8(71),ex1(:),G2H4(333),m3h2x4(:,906),heltab2x8(:,:,906))
  call Hloop_AQ_V(ntryL,G2H8(76),ex1(:),G2H4(37),m3h2x4(:,907),heltab2x8(:,:,907))
  call Hloop_AQ_V(ntryL,G2H8(77),ex1(:),G2H4(123),m3h2x4(:,908),heltab2x8(:,:,908))
  call Hotf_5pt_reduction(G2H4(619),RedSet_5(118),mass5set(:,2),  & 
G1H4(1409),G1H4(1410),G1H4(1411),G1H4(1412),G1H4(1413),G1H4(1414),4)
  call HG1shiftOLR(G1H4(1410),8,4)
  call Hotf_4pt_reduction(G2H4(622),RedSet_4(271),mass4set(:,2),  & 
G1H4(1415),G1H4(1416),G1H4(1417),G1H4(1418),G1H4(1419),G0H4(31),4)
  call HG1shiftOLR(G1H4(1416),8,4)
  call Hotf_4pt_reduction(G2H4(623),RedSet_4(307),mass4set(:,2),  & 
G1H4(1420),G1H4(1421),G1H4(1422),G1H4(1423),G1H4(1424),G0H4(32),4)
  call HG1shiftOLR(G1H4(1421),12,4)
  call Hotf_5pt_reduction(G2H4(624),RedSet_5(118),mass5set(:,2),  & 
G1H4(1425),G1H4(1426),G1H4(1427),G1H4(1428),G1H4(1429),G1H4(1430),4)
  call HG1shiftOLR(G1H4(1426),8,4)
  call Hotf_4pt_reduction(G2H4(627),RedSet_4(271),mass4set(:,2),  & 
G1H4(1431),G1H4(1432),G1H4(1433),G1H4(1434),G1H4(1435),G0H4(33),4)
  call HG1shiftOLR(G1H4(1432),8,4)
  call Hotf_4pt_reduction(G2H4(628),RedSet_4(307),mass4set(:,2),  & 
G1H4(1436),G1H4(1437),G1H4(1438),G1H4(1439),G1H4(1440),G0H4(34),4)
  call HG1shiftOLR(G1H4(1437),12,4)
  call Hotf_5pt_reduction(G2H4(629),RedSet_5(118),mass5set(:,3),  & 
G1H4(1441),G1H4(1442),G1H4(1443),G1H4(1444),G1H4(1445),G1H4(1446),4)
  call HG1shiftOLR(G1H4(1442),8,4)
  call Hotf_4pt_reduction(G2H4(632),RedSet_4(271),mass4set(:,3),  & 
G1H4(1447),G1H4(1448),G1H4(1449),G1H4(1450),G1H4(1451),G0H4(35),4)
  call HG1shiftOLR(G1H4(1448),8,4)
  call Hotf_4pt_reduction(G2H4(633),RedSet_4(307),mass4set(:,3),  & 
G1H4(1452),G1H4(1453),G1H4(1454),G1H4(1455),G1H4(1456),G0H4(36),4)
  call HG1shiftOLR(G1H4(1453),12,4)
  call Hotf_5pt_reduction(G2H4(634),RedSet_5(118),mass5set(:,3),  & 
G1H4(1457),G1H4(1458),G1H4(1459),G1H4(1460),G1H4(1461),G1H4(1462),4)
  call HG1shiftOLR(G1H4(1458),8,4)
  call Hotf_4pt_reduction(G2H4(637),RedSet_4(271),mass4set(:,3),  & 
G1H4(1463),G1H4(1464),G1H4(1465),G1H4(1466),G1H4(1467),G0H4(37),4)
  call HG1shiftOLR(G1H4(1464),8,4)
  call Hotf_4pt_reduction(G2H4(638),RedSet_4(307),mass4set(:,3),  & 
G1H4(1468),G1H4(1469),G1H4(1470),G1H4(1471),G1H4(1472),G0H4(38),4)
  call HG1shiftOLR(G1H4(1469),12,4)
  call Hotf_5pt_reduction(G2H4(639),RedSet_5(116),mass5set(:,2),  & 
G1H4(1473),G1H4(1474),G1H4(1475),G1H4(1476),G1H4(1477),G1H4(1478),4)
  call HG1shiftOLR(G1H4(1474),16,4)
  call Hotf_4pt_reduction(G2H4(642),RedSet_4(264),mass4set(:,2),  & 
G1H4(1479),G1H4(1480),G1H4(1481),G1H4(1482),G1H4(1483),G0H4(39),4)
  call HG1shiftOLR(G1H4(1480),16,4)
  call Hotf_4pt_reduction(G2H4(643),RedSet_4(287),mass4set(:,2),  & 
G1H4(1484),G1H4(1485),G1H4(1486),G1H4(1487),G1H4(1488),G0H4(40),4)
  call HG1shiftOLR(G1H4(1485),20,4)
  call Hotf_5pt_reduction(G2H4(644),RedSet_5(116),mass5set(:,2),  & 
G1H4(1489),G1H4(1490),G1H4(1491),G1H4(1492),G1H4(1493),G1H4(1494),4)
  call HG1shiftOLR(G1H4(1490),16,4)
  call Hotf_4pt_reduction(G2H4(647),RedSet_4(264),mass4set(:,2),  & 
G1H4(1495),G1H4(1496),G1H4(1497),G1H4(1498),G1H4(1499),G0H4(41),4)
  call HG1shiftOLR(G1H4(1496),16,4)
  call Hotf_4pt_reduction(G2H4(648),RedSet_4(287),mass4set(:,2),  & 
G1H4(1500),G1H4(1501),G1H4(1502),G1H4(1503),G1H4(1504),G0H4(42),4)
  call HG1shiftOLR(G1H4(1501),20,4)
  call Hotf_5pt_reduction(G2H4(649),RedSet_5(116),mass5set(:,3),  & 
G1H4(1505),G1H4(1506),G1H4(1507),G1H4(1508),G1H4(1509),G1H4(1510),4)
  call HG1shiftOLR(G1H4(1506),16,4)
  call Hotf_4pt_reduction(G2H4(652),RedSet_4(264),mass4set(:,3),  & 
G1H4(1511),G1H4(1512),G1H4(1513),G1H4(1514),G1H4(1515),G0H4(43),4)
  call HG1shiftOLR(G1H4(1512),16,4)
  call Hotf_4pt_reduction(G2H4(653),RedSet_4(287),mass4set(:,3),  & 
G1H4(1516),G1H4(1517),G1H4(1518),G1H4(1519),G1H4(1520),G0H4(44),4)
  call HG1shiftOLR(G1H4(1517),20,4)
  call Hotf_5pt_reduction(G2H4(654),RedSet_5(116),mass5set(:,3),  & 
G1H4(1521),G1H4(1522),G1H4(1523),G1H4(1524),G1H4(1525),G1H4(1526),4)
  call HG1shiftOLR(G1H4(1522),16,4)
  call Hotf_4pt_reduction(G2H4(657),RedSet_4(264),mass4set(:,3),  & 
G1H4(1527),G1H4(1528),G1H4(1529),G1H4(1530),G1H4(1531),G0H4(45),4)
  call HG1shiftOLR(G1H4(1528),16,4)
  call Hotf_4pt_reduction(G2H4(658),RedSet_4(287),mass4set(:,3),  & 
G1H4(1532),G1H4(1533),G1H4(1534),G1H4(1535),G1H4(1536),G0H4(46),4)
  call HG1shiftOLR(G1H4(1533),20,4)
  call Hotf_5pt_reduction(G2H4(659),RedSet_5(119),mass5set(:,2),  & 
G1H4(1537),G1H4(1538),G1H4(1539),G1H4(1540),G1H4(1541),G1H4(1542),4)
  call HG1shiftOLR(G1H4(1538),4,4)
  call Hotf_4pt_reduction(G2H4(662),RedSet_4(295),mass4set(:,2),  & 
G1H4(1543),G1H4(1544),G1H4(1545),G1H4(1546),G1H4(1547),G0H4(47),4)
  call HG1shiftOLR(G1H4(1544),4,4)
  call Hotf_4pt_reduction(G2H4(663),RedSet_4(307),mass4set(:,2),  & 
G1H4(1548),G1H4(1549),G1H4(1550),G1H4(1551),G1H4(1552),G0H4(48),4)
  call HG1shiftOLR(G1H4(1549),12,4)
  call Hotf_5pt_reduction(G2H4(664),RedSet_5(119),mass5set(:,2),  & 
G1H4(1553),G1H4(1554),G1H4(1555),G1H4(1556),G1H4(1557),G1H4(1558),4)
  call HG1shiftOLR(G1H4(1554),4,4)
  call Hotf_4pt_reduction(G2H4(667),RedSet_4(295),mass4set(:,2),  & 
G1H4(1559),G1H4(1560),G1H4(1561),G1H4(1562),G1H4(1563),G0H4(49),4)
  call HG1shiftOLR(G1H4(1560),4,4)
  call Hotf_4pt_reduction(G2H4(668),RedSet_4(307),mass4set(:,2),  & 
G1H4(1564),G1H4(1565),G1H4(1566),G1H4(1567),G1H4(1568),G0H4(50),4)
  call HG1shiftOLR(G1H4(1565),12,4)
  call Hotf_5pt_reduction(G2H4(669),RedSet_5(119),mass5set(:,3),  & 
G1H4(1569),G1H4(1570),G1H4(1571),G1H4(1572),G1H4(1573),G1H4(1574),4)
  call HG1shiftOLR(G1H4(1570),4,4)
  call Hotf_4pt_reduction(G2H4(672),RedSet_4(295),mass4set(:,3),  & 
G1H4(1575),G1H4(1576),G1H4(1577),G1H4(1578),G1H4(1579),G0H4(51),4)
  call HG1shiftOLR(G1H4(1576),4,4)
  call Hotf_4pt_reduction(G2H4(673),RedSet_4(307),mass4set(:,3),  & 
G1H4(1580),G1H4(1581),G1H4(1582),G1H4(1583),G1H4(1584),G0H4(52),4)
  call HG1shiftOLR(G1H4(1581),12,4)
  call Hotf_5pt_reduction(G2H4(674),RedSet_5(119),mass5set(:,3),  & 
G1H4(1585),G1H4(1586),G1H4(1587),G1H4(1588),G1H4(1589),G1H4(1590),4)
  call HG1shiftOLR(G1H4(1586),4,4)
  call Hotf_4pt_reduction(G2H4(677),RedSet_4(295),mass4set(:,3),  & 
G1H4(1591),G1H4(1592),G1H4(1593),G1H4(1594),G1H4(1595),G0H4(53),4)
  call HG1shiftOLR(G1H4(1592),4,4)
  call Hotf_4pt_reduction(G2H4(678),RedSet_4(307),mass4set(:,3),  & 
G1H4(1596),G1H4(1597),G1H4(1598),G1H4(1599),G1H4(1600),G0H4(54),4)
  call HG1shiftOLR(G1H4(1597),12,4)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(64),mass5set(:,1),  & 
G1H8(162),G1H8(164),G1H8(167),G1H8(168),G1H8(169),G1H8(170),8)
  call HG1shiftOLR(G1H8(164),16,8)
  call Hotf_4pt_reduction(G2H8(124),RedSet_4(175),mass4set(:,1),  & 
G1H8(174),G1H8(175),G1H8(176),G1H8(179),G1H8(180),G0H8(1),8)
  call HG1shiftOLR(G1H8(175),16,8)
  call Hotf_4pt_reduction(G2H8(153),RedSet_4(178),mass4set(:,1),  & 
G1H8(182),G1H8(185),G1H8(186),G1H8(187),G1H8(188),G0H8(2),8)
  call HG1shiftOLR(G1H8(185),19,8)
  call Hotf_5pt_reduction(G2H8(129),RedSet_5(64),mass5set(:,2),  & 
G1H8(192),G1H8(193),G1H8(194),G1H8(197),G1H8(198),G1H8(237),8)
  call HG1shiftOLR(G1H8(193),16,8)
  call Hotf_4pt_reduction(G2H8(139),RedSet_4(175),mass4set(:,2),  & 
G1H8(238),G1H8(244),G1H8(255),G1H8(274),G1H8(261),G0H8(3),8)
  call HG1shiftOLR(G1H8(244),16,8)
  call Hotf_4pt_reduction(G2H8(143),RedSet_4(178),mass4set(:,2),  & 
G1H8(280),G1H8(279),G1H8(291),G1H8(292),G1H8(297),G0H8(4),8)
  call HG1shiftOLR(G1H8(279),19,8)
  call Hotf_5pt_reduction(G2H8(147),RedSet_5(64),mass5set(:,1),  & 
G1H8(298),G1H8(310),G1H8(315),G1H8(316),G1H8(327),G1H8(328),8)
  call HG1shiftOLR(G1H8(310),16,8)
  call Hotf_4pt_reduction(G2H8(156),RedSet_4(175),mass4set(:,1),  & 
G1H8(334),G1H8(345),G1H8(346),G1H8(200),G1H8(203),G0H8(5),8)
  call HG1shiftOLR(G1H8(345),16,8)
  call Hotf_4pt_reduction(G2H8(121),RedSet_4(178),mass4set(:,1),  & 
G1H8(204),G1H8(205),G1H8(206),G1H8(210),G1H8(211),G0H8(6),8)
  call HG1shiftOLR(G1H8(205),19,8)
  call Hotf_5pt_reduction(G2H8(140),RedSet_5(64),mass5set(:,2),  & 
G1H8(212),G1H8(217),G1H8(223),G1H8(221),G1H8(222),G1H8(224),8)
  call HG1shiftOLR(G1H8(217),16,8)
  call Hotf_4pt_reduction(G2H8(93),RedSet_4(175),mass4set(:,2),  & 
G1H8(227),G1H8(228),G1H8(230),G1H8(235),G1H8(241),G0H8(7),8)
  call HG1shiftOLR(G1H8(228),16,8)
  call Hotf_4pt_reduction(G2H8(109),RedSet_4(178),mass4set(:,2),  & 
G1H8(236),G1H8(239),G1H8(242),G1H8(245),G1H8(246),G0H8(8),8)
  call HG1shiftOLR(G1H8(239),19,8)
  call Hotf_5pt_reduction(G2H8(118),RedSet_5(64),mass5set(:,3),  & 
G1H8(247),G1H8(351),G1H8(352),G1H8(364),G1H8(369),G1H8(370),8)
  call HG1shiftOLR(G1H8(351),16,8)
  call Hotf_4pt_reduction(G2H8(131),RedSet_4(175),mass4set(:,3),  & 
G1H8(381),G1H8(382),G1H8(388),G1H8(399),G1H8(405),G0H8(9),8)
  call HG1shiftOLR(G1H8(382),16,8)
  call Hotf_4pt_reduction(G2H8(89),RedSet_4(178),mass4set(:,3),  & 
G1H8(417),G1H8(418),G1H8(424),G1H8(435),G1H8(436),G0H8(10),8)
  call HG1shiftOLR(G1H8(418),19,8)
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(64),mass5set(:,3),  & 
G1H8(441),G1H8(442),G1H8(454),G1H8(459),G1H8(460),G1H8(248),8)
  call HG1shiftOLR(G1H8(442),16,8)
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(175),mass4set(:,3),  & 
G1H8(259),G1H8(254),G1H8(257),G1H8(258),G1H8(260),G0H8(11),8)
  call HG1shiftOLR(G1H8(254),16,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(178),mass4set(:,3),  & 
G1H8(264),G1H8(265),G1H8(266),G1H8(271),G1H8(277),G0H8(12),8)
  call HG1shiftOLR(G1H8(265),19,8)
  call Hotf_5pt_reduction(G2H4(679),RedSet_5(114),mass5set(:,2),  & 
G1H4(1601),G1H4(1602),G1H4(1603),G1H4(1604),G1H4(1605),G1H4(1606),4)
  call HG1shiftOLR(G1H4(1602),16,4)
  call Hotf_4pt_reduction(G2H4(682),RedSet_4(264),mass4set(:,2),  & 
G1H4(1607),G1H4(1608),G1H4(1609),G1H4(1610),G1H4(1611),G0H4(55),4)
  call HG1shiftOLR(G1H4(1608),16,4)
  call Hotf_4pt_reduction(G2H4(683),RedSet_4(265),mass4set(:,2),  & 
G1H4(1612),G1H4(1613),G1H4(1614),G1H4(1615),G1H4(1616),G0H4(56),4)
  call HG1shiftOLR(G1H4(1613),24,4)
  call Hotf_5pt_reduction(G2H4(684),RedSet_5(114),mass5set(:,2),  & 
G1H4(1617),G1H4(1618),G1H4(1619),G1H4(1620),G1H4(1621),G1H4(1622),4)
  call HG1shiftOLR(G1H4(1618),16,4)
  call Hotf_4pt_reduction(G2H4(687),RedSet_4(264),mass4set(:,2),  & 
G1H4(1623),G1H4(1624),G1H4(1625),G1H4(1626),G1H4(1627),G0H4(57),4)
  call HG1shiftOLR(G1H4(1624),16,4)
  call Hotf_4pt_reduction(G2H4(688),RedSet_4(265),mass4set(:,2),  & 
G1H4(1628),G1H4(1629),G1H4(1630),G1H4(1631),G1H4(1632),G0H4(58),4)
  call HG1shiftOLR(G1H4(1629),24,4)
  call Hotf_5pt_reduction(G2H4(689),RedSet_5(114),mass5set(:,3),  & 
G1H4(1633),G1H4(1634),G1H4(1635),G1H4(1636),G1H4(1637),G1H4(1638),4)
  call HG1shiftOLR(G1H4(1634),16,4)
  call Hotf_4pt_reduction(G2H4(692),RedSet_4(264),mass4set(:,3),  & 
G1H4(1639),G1H4(1640),G1H4(1641),G1H4(1642),G1H4(1643),G0H4(59),4)
  call HG1shiftOLR(G1H4(1640),16,4)
  call Hotf_4pt_reduction(G2H4(693),RedSet_4(265),mass4set(:,3),  & 
G1H4(1644),G1H4(1645),G1H4(1646),G1H4(1647),G1H4(1648),G0H4(60),4)
  call HG1shiftOLR(G1H4(1645),24,4)
  call Hotf_5pt_reduction(G2H4(694),RedSet_5(114),mass5set(:,3),  & 
G1H4(1649),G1H4(1650),G1H4(1651),G1H4(1652),G1H4(1653),G1H4(1654),4)
  call HG1shiftOLR(G1H4(1650),16,4)
  call Hotf_4pt_reduction(G2H4(697),RedSet_4(264),mass4set(:,3),  & 
G1H4(1655),G1H4(1656),G1H4(1657),G1H4(1658),G1H4(1659),G0H4(61),4)
  call HG1shiftOLR(G1H4(1656),16,4)
  call Hotf_4pt_reduction(G2H4(698),RedSet_4(265),mass4set(:,3),  & 
G1H4(1660),G1H4(1661),G1H4(1662),G1H4(1663),G1H4(1664),G0H4(62),4)
  call HG1shiftOLR(G1H4(1661),24,4)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(63),mass5set(:,1),  & 
G1H8(275),G1H8(276),G1H8(278),G1H8(281),G1H8(282),G1H8(284),8)
  call HG1shiftOLR(G1H8(276),16,8)
  call Hotf_4pt_reduction(G2H8(74),RedSet_4(70),mass4set(:,1),  & 
G1H8(289),G1H8(295),G1H8(290),G1H8(293),G1H8(296),G0H8(13),8)
  call HG1shiftOLR(G1H8(295),16,8)
  call Hotf_4pt_reduction(G2H8(75),RedSet_4(169),mass4set(:,1),  & 
G1H8(299),G1H8(300),G1H8(471),G1H8(472),G1H8(478),G0H8(14),8)
  call HG1shiftOLR(G1H8(300),19,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(63),mass5set(:,2),  & 
G1H8(489),G1H8(490),G1H8(495),G1H8(496),G1H8(500),G1H8(501),8)
  call HG1shiftOLR(G1H8(490),16,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(70),mass4set(:,2),  & 
G1H8(502),G1H8(503),G1H8(504),G1H8(506),G1H8(507),G0H8(15),8)
  call HG1shiftOLR(G1H8(503),16,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(169),mass4set(:,2),  & 
G1H8(508),G1H8(509),G1H8(510),G1H8(512),G1H8(513),G0H8(16),8)
  call HG1shiftOLR(G1H8(509),19,8)
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(63),mass5set(:,1),  & 
G1H8(514),G1H8(301),G1H8(302),G1H8(313),G1H8(308),G1H8(311),8)
  call HG1shiftOLR(G1H8(301),16,8)
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(70),mass4set(:,1),  & 
G1H8(312),G1H8(314),G1H8(318),G1H8(319),G1H8(320),G0H8(17),8)
  call HG1shiftOLR(G1H8(314),16,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(169),mass4set(:,1),  & 
G1H8(325),G1H8(331),G1H8(329),G1H8(330),G1H8(332),G0H8(18),8)
  call HG1shiftOLR(G1H8(331),19,8)
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(63),mass5set(:,2),  & 
G1H8(335),G1H8(336),G1H8(338),G1H8(343),G1H8(349),G1H8(344),8)
  call HG1shiftOLR(G1H8(336),16,8)
  call Hotf_4pt_reduction(G2H8(95),RedSet_4(70),mass4set(:,2),  & 
G1H8(347),G1H8(350),G1H8(353),G1H8(354),G1H8(355),G0H8(19),8)
  call HG1shiftOLR(G1H8(350),16,8)
  call Hotf_4pt_reduction(G2H8(98),RedSet_4(169),mass4set(:,2),  & 
G1H8(356),G1H8(367),G1H8(362),G1H8(365),G1H8(366),G0H8(20),8)
  call HG1shiftOLR(G1H8(367),19,8)
  call Hotf_5pt_reduction(G2H8(100),RedSet_5(63),mass5set(:,3),  & 
G1H8(368),G1H8(372),G1H8(373),G1H8(374),G1H8(379),G1H8(385),8)
  call HG1shiftOLR(G1H8(372),16,8)
  call Hotf_4pt_reduction(G2H8(108),RedSet_4(70),mass4set(:,3),  & 
G1H8(383),G1H8(384),G1H8(386),G1H8(389),G1H8(390),G0H8(21),8)
  call HG1shiftOLR(G1H8(384),16,8)
  call Hotf_4pt_reduction(G2H8(110),RedSet_4(169),mass4set(:,3),  & 
G1H8(392),G1H8(397),G1H8(403),G1H8(398),G1H8(401),G0H8(22),8)
  call HG1shiftOLR(G1H8(397),19,8)
  call Hotf_5pt_reduction(G2H8(114),RedSet_5(63),mass5set(:,3),  & 
G1H8(404),G1H8(407),G1H8(408),G1H8(409),G1H8(410),G1H8(421),8)
  call HG1shiftOLR(G1H8(407),16,8)
  call Hotf_4pt_reduction(G2H8(119),RedSet_4(70),mass4set(:,3),  & 
G1H8(416),G1H8(419),G1H8(420),G1H8(422),G1H8(426),G0H8(23),8)
  call HG1shiftOLR(G1H8(419),16,8)
  call Hotf_4pt_reduction(G2H8(122),RedSet_4(169),mass4set(:,3),  & 
G1H8(427),G1H8(428),G1H8(433),G1H8(439),G1H8(437),G0H8(24),8)
  call HG1shiftOLR(G1H8(428),19,8)
  call Hotf_5pt_reduction(G2H4(699),RedSet_5(117),mass5set(:,2),  & 
G1H4(1665),G1H4(1666),G1H4(1667),G1H4(1668),G1H4(1669),G1H4(1670),4)
  call HG1shiftOLR(G1H4(1666),4,4)
  call Hotf_4pt_reduction(G2H4(702),RedSet_4(295),mass4set(:,2),  & 
G1H4(1671),G1H4(1672),G1H4(1673),G1H4(1674),G1H4(1675),G0H4(63),4)
  call HG1shiftOLR(G1H4(1672),4,4)
  call Hotf_4pt_reduction(G2H4(703),RedSet_4(287),mass4set(:,2),  & 
G1H4(1676),G1H4(1677),G1H4(1678),G1H4(1679),G1H4(1680),G0H4(64),4)
  call HG1shiftOLR(G1H4(1677),20,4)
  call Hotf_5pt_reduction(G2H4(704),RedSet_5(117),mass5set(:,2),  & 
G1H4(1681),G1H4(1682),G1H4(1683),G1H4(1684),G1H4(1685),G1H4(1686),4)
  call HG1shiftOLR(G1H4(1682),4,4)
  call Hotf_4pt_reduction(G2H4(707),RedSet_4(295),mass4set(:,2),  & 
G1H4(1687),G1H4(1688),G1H4(1689),G1H4(1690),G1H4(1691),G0H4(65),4)
  call HG1shiftOLR(G1H4(1688),4,4)
  call Hotf_4pt_reduction(G2H4(708),RedSet_4(287),mass4set(:,2),  & 
G1H4(1692),G1H4(1693),G1H4(1694),G1H4(1695),G1H4(1696),G0H4(66),4)
  call HG1shiftOLR(G1H4(1693),20,4)
  call Hotf_5pt_reduction(G2H4(709),RedSet_5(117),mass5set(:,3),  & 
G1H4(1697),G1H4(1698),G1H4(1699),G1H4(1700),G1H4(1701),G1H4(1702),4)
  call HG1shiftOLR(G1H4(1698),4,4)
  call Hotf_4pt_reduction(G2H4(712),RedSet_4(295),mass4set(:,3),  & 
G1H4(1703),G1H4(1704),G1H4(1705),G1H4(1706),G1H4(1707),G0H4(67),4)
  call HG1shiftOLR(G1H4(1704),4,4)
  call Hotf_4pt_reduction(G2H4(713),RedSet_4(287),mass4set(:,3),  & 
G1H4(1708),G1H4(1709),G1H4(1710),G1H4(1711),G1H4(1712),G0H4(68),4)
  call HG1shiftOLR(G1H4(1709),20,4)
  call Hotf_5pt_reduction(G2H4(714),RedSet_5(117),mass5set(:,3),  & 
G1H4(1713),G1H4(1714),G1H4(1715),G1H4(1716),G1H4(1717),G1H4(1718),4)
  call HG1shiftOLR(G1H4(1714),4,4)
  call Hotf_4pt_reduction(G2H4(717),RedSet_4(295),mass4set(:,3),  & 
G1H4(1719),G1H4(1720),G1H4(1721),G1H4(1722),G1H4(1723),G0H4(69),4)
  call HG1shiftOLR(G1H4(1720),4,4)
  call Hotf_4pt_reduction(G2H4(718),RedSet_4(287),mass4set(:,3),  & 
G1H4(1724),G1H4(1725),G1H4(1726),G1H4(1727),G1H4(1728),G0H4(70),4)
  call HG1shiftOLR(G1H4(1725),20,4)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(65),mass5set(:,1),  & 
G1H8(438),G1H8(440),G1H8(443),G1H8(444),G1H8(446),G1H8(451),8)
  call HG1shiftOLR(G1H8(440),8,8)
  call Hotf_4pt_reduction(G2H8(141),RedSet_4(188),mass4set(:,1),  & 
G1H8(457),G1H8(452),G1H8(455),G1H8(458),G1H8(461),G0H8(25),8)
  call HG1shiftOLR(G1H8(452),8,8)
  call Hotf_4pt_reduction(G2H8(142),RedSet_4(191),mass4set(:,1),  & 
G1H8(462),G1H8(463),G1H8(464),G1H8(475),G1H8(470),G0H8(26),8)
  call HG1shiftOLR(G1H8(463),11,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(65),mass5set(:,2),  & 
G1H8(473),G1H8(474),G1H8(476),G1H8(480),G1H8(481),G1H8(482),8)
  call HG1shiftOLR(G1H8(474),8,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(188),mass4set(:,2),  & 
G1H8(487),G1H8(493),G1H8(491),G1H8(492),G1H8(494),G0H8(27),8)
  call HG1shiftOLR(G1H8(493),8,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(191),mass4set(:,2),  & 
G1H8(497),G1H8(498),G1H8(216),G1H8(233),G1H8(234),G0H8(28),8)
  call HG1shiftOLR(G1H8(498),11,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(65),mass5set(:,1),  & 
G1H8(251),G1H8(252),G1H8(270),G1H8(287),G1H8(288),G1H8(305),8)
  call HG1shiftOLR(G1H8(252),8,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(188),mass4set(:,1),  & 
G1H8(306),G1H8(324),G1H8(341),G1H8(342),G1H8(359),G0H8(29),8)
  call HG1shiftOLR(G1H8(324),8,8)
  call Hotf_4pt_reduction(G2H8(135),RedSet_4(191),mass4set(:,1),  & 
G1H8(360),G1H8(378),G1H8(395),G1H8(396),G1H8(413),G0H8(30),8)
  call HG1shiftOLR(G1H8(378),11,8)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(65),mass5set(:,2),  & 
G1H8(414),G1H8(432),G1H8(449),G1H8(450),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(432),8,8)
  call Hotf_4pt_reduction(G2H8(92),RedSet_4(188),mass4set(:,2),  & 
G1H8(486),G1H8(7),G1H8(8),G1H8(11),G1H8(12),G0H8(31),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hotf_4pt_reduction(G2H8(82),RedSet_4(191),mass4set(:,2),  & 
G1H8(14),G1H8(17),G1H8(18),G1H8(20),G1H8(24),G0H8(32),8)
  call HG1shiftOLR(G1H8(17),11,8)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(65),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(29),G1H8(30),G1H8(32),G1H8(516),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_4pt_reduction(G2H8(97),RedSet_4(188),mass4set(:,3),  & 
G1H8(517),G1H8(518),G1H8(519),G1H8(520),G1H8(521),G0H8(33),8)
  call HG1shiftOLR(G1H8(518),8,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(191),mass4set(:,3),  & 
G1H8(522),G1H8(523),G1H8(524),G1H8(525),G1H8(526),G0H8(34),8)
  call HG1shiftOLR(G1H8(523),11,8)
  call Hotf_5pt_reduction(G2H8(102),RedSet_5(65),mass5set(:,3),  & 
G1H8(527),G1H8(528),G1H8(529),G1H8(530),G1H8(531),G1H8(532),8)
  call HG1shiftOLR(G1H8(528),8,8)
  call Hotf_4pt_reduction(G2H8(86),RedSet_4(188),mass4set(:,3),  & 
G1H8(533),G1H8(534),G1H8(535),G1H8(536),G1H8(537),G0H8(35),8)
  call HG1shiftOLR(G1H8(534),8,8)
  call Hotf_4pt_reduction(G2H8(155),RedSet_4(191),mass4set(:,3),  & 
G1H8(538),G1H8(539),G1H8(540),G1H8(541),G1H8(542),G0H8(36),8)
  call HG1shiftOLR(G1H8(539),11,8)
  call Hotf_5pt_reduction(G2H4(719),RedSet_5(115),mass5set(:,2),  & 
G1H4(1729),G1H4(1730),G1H4(1731),G1H4(1732),G1H4(1733),G1H4(1734),4)
  call HG1shiftOLR(G1H4(1730),8,4)
  call Hotf_4pt_reduction(G2H4(722),RedSet_4(271),mass4set(:,2),  & 
G1H4(1735),G1H4(1736),G1H4(1737),G1H4(1738),G1H4(1739),G0H4(71),4)
  call HG1shiftOLR(G1H4(1736),8,4)
  call Hotf_4pt_reduction(G2H4(723),RedSet_4(265),mass4set(:,2),  & 
G1H4(1740),G1H4(1741),G1H4(1742),G1H4(1743),G1H4(1744),G0H4(72),4)
  call HG1shiftOLR(G1H4(1741),24,4)
  call Hotf_5pt_reduction(G2H4(724),RedSet_5(115),mass5set(:,2),  & 
G1H4(1745),G1H4(1746),G1H4(1747),G1H4(1748),G1H4(1749),G1H4(1750),4)
  call HG1shiftOLR(G1H4(1746),8,4)
  call Hotf_4pt_reduction(G2H4(727),RedSet_4(271),mass4set(:,2),  & 
G1H4(1751),G1H4(1752),G1H4(1753),G1H4(1754),G1H4(1755),G0H4(73),4)
  call HG1shiftOLR(G1H4(1752),8,4)
  call Hotf_4pt_reduction(G2H4(728),RedSet_4(265),mass4set(:,2),  & 
G1H4(1756),G1H4(1757),G1H4(1758),G1H4(1759),G1H4(1760),G0H4(74),4)
  call HG1shiftOLR(G1H4(1757),24,4)
  call Hotf_5pt_reduction(G2H4(729),RedSet_5(115),mass5set(:,3),  & 
G1H4(1761),G1H4(1762),G1H4(1763),G1H4(1764),G1H4(1765),G1H4(1766),4)
  call HG1shiftOLR(G1H4(1762),8,4)
  call Hotf_4pt_reduction(G2H4(732),RedSet_4(271),mass4set(:,3),  & 
G1H4(1767),G1H4(1768),G1H4(1769),G1H4(1770),G1H4(1771),G0H4(75),4)
  call HG1shiftOLR(G1H4(1768),8,4)
  call Hotf_4pt_reduction(G2H4(733),RedSet_4(265),mass4set(:,3),  & 
G1H4(1772),G1H4(1773),G1H4(1774),G1H4(1775),G1H4(1776),G0H4(76),4)
  call HG1shiftOLR(G1H4(1773),24,4)
  call Hotf_5pt_reduction(G2H4(734),RedSet_5(115),mass5set(:,3),  & 
G1H4(1777),G1H4(1778),G1H4(1779),G1H4(1780),G1H4(1781),G1H4(1782),4)
  call HG1shiftOLR(G1H4(1778),8,4)
  call Hotf_4pt_reduction(G2H4(737),RedSet_4(271),mass4set(:,3),  & 
G1H4(1783),G1H4(1784),G1H4(1785),G1H4(1786),G1H4(1787),G0H4(77),4)
  call HG1shiftOLR(G1H4(1784),8,4)
  call Hotf_4pt_reduction(G2H4(738),RedSet_4(265),mass4set(:,3),  & 
G1H4(1788),G1H4(1789),G1H4(1790),G1H4(1791),G1H4(1792),G0H4(78),4)
  call HG1shiftOLR(G1H4(1789),24,4)
  call Hotf_4pt_reduction(G2H4(742),RedSet_4(246),mass4set(:,1),  & 
G1H4(1793),G1H4(1794),G1H4(1795),G1H4(1796),G1H4(1797),G0H4(79),4)
  call HG1shiftOLR(G1H4(1794),20,4)
  call Hotf_5pt_reduction(G2H4(743),RedSet_5(134),mass5set(:,2),  & 
G1H4(1798),G1H4(1799),G1H4(1800),G1H4(1801),G1H4(1802),G1H4(1803),4)
  call HG1shiftOLR(G1H4(1799),16,4)
  call Hotf_4pt_reduction(G2H4(745),RedSet_4(70),mass4set(:,2),  & 
G1H4(1804),G1H4(1805),G1H4(1806),G1H4(1807),G1H4(1808),G0H4(80),4)
  call HG1shiftOLR(G1H4(1805),16,4)
  call Hotf_4pt_reduction(G2H4(746),RedSet_4(246),mass4set(:,2),  & 
G1H4(1809),G1H4(1810),G1H4(1811),G1H4(1812),G1H4(1813),G0H4(81),4)
  call HG1shiftOLR(G1H4(1810),20,4)
  call Hotf_4pt_reduction(G2H4(750),RedSet_4(246),mass4set(:,1),  & 
G1H4(1814),G1H4(1815),G1H4(1816),G1H4(1817),G1H4(1818),G0H4(82),4)
  call HG1shiftOLR(G1H4(1815),20,4)
  call Hotf_5pt_reduction(G2H4(751),RedSet_5(134),mass5set(:,2),  & 
G1H4(1819),G1H4(1820),G1H4(1821),G1H4(1822),G1H4(1823),G1H4(1824),4)
  call HG1shiftOLR(G1H4(1820),16,4)
  call Hotf_4pt_reduction(G2H4(753),RedSet_4(70),mass4set(:,2),  & 
G1H4(1825),G1H4(1826),G1H4(1827),G1H4(1828),G1H4(1829),G0H4(83),4)
  call HG1shiftOLR(G1H4(1826),16,4)
  call Hotf_4pt_reduction(G2H4(754),RedSet_4(246),mass4set(:,2),  & 
G1H4(1830),G1H4(1831),G1H4(1832),G1H4(1833),G1H4(1834),G0H4(84),4)
  call HG1shiftOLR(G1H4(1831),20,4)
  call Hotf_5pt_reduction(G2H4(755),RedSet_5(134),mass5set(:,3),  & 
G1H4(1835),G1H4(1836),G1H4(1837),G1H4(1838),G1H4(1839),G1H4(1840),4)
  call HG1shiftOLR(G1H4(1836),16,4)
  call Hotf_4pt_reduction(G2H4(757),RedSet_4(70),mass4set(:,3),  & 
G1H4(1841),G1H4(1842),G1H4(1843),G1H4(1844),G1H4(1845),G0H4(85),4)
  call HG1shiftOLR(G1H4(1842),16,4)
  call Hotf_4pt_reduction(G2H4(758),RedSet_4(246),mass4set(:,3),  & 
G1H4(1846),G1H4(1847),G1H4(1848),G1H4(1849),G1H4(1850),G0H4(86),4)
  call HG1shiftOLR(G1H4(1847),20,4)
  call Hotf_5pt_reduction(G2H4(759),RedSet_5(134),mass5set(:,3),  & 
G1H4(1851),G1H4(1852),G1H4(1853),G1H4(1854),G1H4(1855),G1H4(1856),4)
  call HG1shiftOLR(G1H4(1852),16,4)
  call Hotf_4pt_reduction(G2H4(761),RedSet_4(70),mass4set(:,3),  & 
G1H4(1857),G1H4(1858),G1H4(1859),G1H4(1860),G1H4(1861),G0H4(87),4)
  call HG1shiftOLR(G1H4(1858),16,4)
  call Hotf_4pt_reduction(G2H4(762),RedSet_4(246),mass4set(:,3),  & 
G1H4(1862),G1H4(1863),G1H4(1864),G1H4(1865),G1H4(1866),G0H4(88),4)
  call HG1shiftOLR(G1H4(1863),20,4)
  call Hotf_4pt_reduction(G2H4(766),RedSet_4(252),mass4set(:,1),  & 
G1H4(1867),G1H4(1868),G1H4(1869),G1H4(1870),G1H4(1871),G0H4(89),4)
  call HG1shiftOLR(G1H4(1868),24,4)
  call Hotf_5pt_reduction(G2H4(767),RedSet_5(135),mass5set(:,2),  & 
G1H4(1872),G1H4(1873),G1H4(1874),G1H4(1875),G1H4(1876),G1H4(1877),4)
  call HG1shiftOLR(G1H4(1873),8,4)
  call Hotf_4pt_reduction(G2H4(769),RedSet_4(188),mass4set(:,2),  & 
G1H4(1878),G1H4(1879),G1H4(1880),G1H4(1881),G1H4(1882),G0H4(90),4)
  call HG1shiftOLR(G1H4(1879),8,4)
  call Hotf_4pt_reduction(G2H4(770),RedSet_4(252),mass4set(:,2),  & 
G1H4(1883),G1H4(1884),G1H4(1885),G1H4(1886),G1H4(1887),G0H4(91),4)
  call HG1shiftOLR(G1H4(1884),24,4)
  call Hotf_4pt_reduction(G2H4(774),RedSet_4(252),mass4set(:,1),  & 
G1H4(1888),G1H4(1889),G1H4(1890),G1H4(1891),G1H4(1892),G0H4(92),4)
  call HG1shiftOLR(G1H4(1889),24,4)
  call Hotf_5pt_reduction(G2H4(775),RedSet_5(135),mass5set(:,2),  & 
G1H4(1893),G1H4(1894),G1H4(1895),G1H4(1896),G1H4(1897),G1H4(1898),4)
  call HG1shiftOLR(G1H4(1894),8,4)
  call Hotf_4pt_reduction(G2H4(777),RedSet_4(188),mass4set(:,2),  & 
G1H4(1899),G1H4(1900),G1H4(1901),G1H4(1902),G1H4(1903),G0H4(93),4)
  call HG1shiftOLR(G1H4(1900),8,4)
  call Hotf_4pt_reduction(G2H4(778),RedSet_4(252),mass4set(:,2),  & 
G1H4(1904),G1H4(1905),G1H4(1906),G1H4(1907),G1H4(1908),G0H4(94),4)
  call HG1shiftOLR(G1H4(1905),24,4)
  call Hotf_5pt_reduction(G2H4(779),RedSet_5(135),mass5set(:,3),  & 
G1H4(1909),G1H4(1910),G1H4(1911),G1H4(1912),G1H4(1913),G1H4(1914),4)
  call HG1shiftOLR(G1H4(1910),8,4)
  call Hotf_4pt_reduction(G2H4(781),RedSet_4(188),mass4set(:,3),  & 
G1H4(1915),G1H4(1916),G1H4(1917),G1H4(1918),G1H4(1919),G0H4(95),4)
  call HG1shiftOLR(G1H4(1916),8,4)
  call Hotf_4pt_reduction(G2H4(782),RedSet_4(252),mass4set(:,3),  & 
G1H4(1920),G1H4(1921),G1H4(1922),G1H4(1923),G1H4(1924),G0H4(96),4)
  call HG1shiftOLR(G1H4(1921),24,4)
  call Hotf_5pt_reduction(G2H4(783),RedSet_5(135),mass5set(:,3),  & 
G1H4(1925),G1H4(1926),G1H4(1927),G1H4(1928),G1H4(1929),G1H4(1930),4)
  call HG1shiftOLR(G1H4(1926),8,4)
  call Hotf_4pt_reduction(G2H4(785),RedSet_4(188),mass4set(:,3),  & 
G1H4(1931),G1H4(1932),G1H4(1933),G1H4(1934),G1H4(1935),G0H4(97),4)
  call HG1shiftOLR(G1H4(1932),8,4)
  call Hotf_4pt_reduction(G2H4(786),RedSet_4(252),mass4set(:,3),  & 
G1H4(1936),G1H4(1937),G1H4(1938),G1H4(1939),G1H4(1940),G0H4(98),4)
  call HG1shiftOLR(G1H4(1937),24,4)
  call Hotf_4pt_reduction(G2H4(790),RedSet_4(252),mass4set(:,1),  & 
G1H4(1941),G1H4(1942),G1H4(1943),G1H4(1944),G1H4(1945),G0H4(99),4)
  call HG1shiftOLR(G1H4(1942),24,4)
  call Hotf_5pt_reduction(G2H4(791),RedSet_5(136),mass5set(:,2),  & 
G1H4(1946),G1H4(1947),G1H4(1948),G1H4(1949),G1H4(1950),G1H4(1951),4)
  call HG1shiftOLR(G1H4(1947),16,4)
  call Hotf_4pt_reduction(G2H4(793),RedSet_4(175),mass4set(:,2),  & 
G1H4(1952),G1H4(1953),G1H4(1954),G1H4(1955),G1H4(1956),G0H4(100),4)
  call HG1shiftOLR(G1H4(1953),16,4)
  call Hotf_4pt_reduction(G2H4(794),RedSet_4(252),mass4set(:,2),  & 
G1H4(1957),G1H4(1958),G1H4(1959),G1H4(1960),G1H4(1961),G0H4(101),4)
  call HG1shiftOLR(G1H4(1958),24,4)
  call Hotf_4pt_reduction(G2H4(798),RedSet_4(252),mass4set(:,1),  & 
G1H4(1962),G1H4(1963),G1H4(1964),G1H4(1965),G1H4(1966),G0H4(102),4)
  call HG1shiftOLR(G1H4(1963),24,4)
  call Hotf_5pt_reduction(G2H4(799),RedSet_5(136),mass5set(:,2),  & 
G1H4(1967),G1H4(1968),G1H4(1969),G1H4(1970),G1H4(1971),G1H4(1972),4)
  call HG1shiftOLR(G1H4(1968),16,4)
  call Hotf_4pt_reduction(G2H4(801),RedSet_4(175),mass4set(:,2),  & 
G1H4(1973),G1H4(1974),G1H4(1975),G1H4(1976),G1H4(1977),G0H4(103),4)
  call HG1shiftOLR(G1H4(1974),16,4)
  call Hotf_4pt_reduction(G2H4(802),RedSet_4(252),mass4set(:,2),  & 
G1H4(1978),G1H4(1979),G1H4(1980),G1H4(1981),G1H4(1982),G0H4(104),4)
  call HG1shiftOLR(G1H4(1979),24,4)
  call Hotf_5pt_reduction(G2H4(803),RedSet_5(136),mass5set(:,3),  & 
G1H4(1983),G1H4(1984),G1H4(1985),G1H4(1986),G1H4(1987),G1H4(1988),4)
  call HG1shiftOLR(G1H4(1984),16,4)
  call Hotf_4pt_reduction(G2H4(805),RedSet_4(175),mass4set(:,3),  & 
G1H4(1989),G1H4(1990),G1H4(1991),G1H4(1992),G1H4(1993),G0H4(105),4)
  call HG1shiftOLR(G1H4(1990),16,4)
  call Hotf_4pt_reduction(G2H4(806),RedSet_4(252),mass4set(:,3),  & 
G1H4(1994),G1H4(1995),G1H4(1996),G1H4(1997),G1H4(1998),G0H4(106),4)
  call HG1shiftOLR(G1H4(1995),24,4)
  call Hotf_5pt_reduction(G2H4(807),RedSet_5(136),mass5set(:,3),  & 
G1H4(1999),G1H4(2000),G1H4(2001),G1H4(2002),G1H4(2003),G1H4(2004),4)
  call HG1shiftOLR(G1H4(2000),16,4)
  call Hotf_4pt_reduction(G2H4(809),RedSet_4(175),mass4set(:,3),  & 
G1H4(2005),G1H4(2006),G1H4(2007),G1H4(2008),G1H4(2009),G0H4(107),4)
  call HG1shiftOLR(G1H4(2006),16,4)
  call Hotf_4pt_reduction(G2H4(810),RedSet_4(252),mass4set(:,3),  & 
G1H4(2010),G1H4(2011),G1H4(2012),G1H4(2013),G1H4(2014),G0H4(108),4)
  call HG1shiftOLR(G1H4(2011),24,4)
  call Hotf_5pt_reduction(G2H8(161),RedSet_5(35),mass5set(:,1),  & 
G1H8(543),G1H8(544),G1H8(545),G1H8(546),G1H8(547),G1H8(548),8)
  call HG1shiftOLR(G1H8(544),5,8)
  call Hotf_4pt_reduction(G2H8(163),RedSet_4(352),mass4set(:,1),  & 
G1H8(549),G1H8(550),G1H8(551),G1H8(552),G1H8(553),8)
  call HG1shiftOLR(G1H8(550),5,8)
  call Hotf_4pt_reduction(G2H8(164),RedSet_4(112),mass4set(:,1),  & 
G1H8(554),G1H8(555),G1H8(556),G1H8(557),G1H8(558),8)
  call HG1shiftOLR(G1H8(555),21,8)
  call Hloop_AQ_V(ntryL,G2H8(165),wf4(:,2),G2H2(422),m3h4x2(:,1),heltab2x8(:,:,909))
  call Hloop_AQ_V(ntryL,G2H8(168),wf4(:,2),G2H2(423),m3h4x2(:,2),heltab2x8(:,:,910))
  call Hloop_AQ_V(ntryL,G2H8(169),wf4(:,2),G2H2(424),m3h4x2(:,3),heltab2x8(:,:,911))
  call Hloop_AQ_V(ntryL,G2H8(170),wf4(:,2),G2H2(425),m3h4x2(:,4),heltab2x8(:,:,912))
  call Hloop_AQ_V(ntryL,G2H8(173),wf4(:,2),G2H2(426),m3h4x2(:,5),heltab2x8(:,:,913))
  call Hloop_AQ_V(ntryL,G2H8(174),wf4(:,2),G2H2(427),m3h4x2(:,6),heltab2x8(:,:,914))
  call Hotf_5pt_reduction(G2H8(175),RedSet_5(33),mass5set(:,1),  & 
G1H8(559),G1H8(560),G1H8(561),G1H8(562),G1H8(563),G1H8(564),8)
  call HG1shiftOLR(G1H8(560),5,8)
  call Hotf_4pt_reduction(G2H8(177),RedSet_4(352),mass4set(:,1),  & 
G1H8(565),G1H8(566),G1H8(567),G1H8(568),G1H8(569),8)
  call HG1shiftOLR(G1H8(566),5,8)
  call Hotf_4pt_reduction(G2H8(178),RedSet_4(88),mass4set(:,1),  & 
G1H8(570),G1H8(571),G1H8(572),G1H8(573),G1H8(574),8)
  call HG1shiftOLR(G1H8(571),13,8)
  call Hloop_AQ_V(ntryL,G2H8(179),wf4(:,2),G2H2(428),m3h4x2(:,7),heltab2x8(:,:,915))
  call Hloop_AQ_V(ntryL,G2H8(182),wf4(:,2),G2H2(429),m3h4x2(:,8),heltab2x8(:,:,916))
  call Hloop_AQ_V(ntryL,G2H8(183),wf4(:,2),G2H2(430),m3h4x2(:,9),heltab2x8(:,:,917))
  call Hotf_5pt_reduction(G2H8(185),RedSet_5(18),mass5set(:,1),  & 
G1H8(575),G1H8(576),G1H8(577),G1H8(578),G1H8(579),G1H8(580),8)
  call HG1shiftOLR(G1H8(576),6,8)
  call Hotf_4pt_reduction(G2H8(187),RedSet_4(37),mass4set(:,1),  & 
G1H8(581),G1H8(582),G1H8(583),G1H8(584),G1H8(585),8)
  call HG1shiftOLR(G1H8(582),6,8)
  call Hotf_4pt_reduction(G2H8(188),RedSet_4(2),mass4set(:,1),  & 
G1H8(586),G1H8(587),G1H8(588),G1H8(589),G1H8(590),8)
  call HG1shiftOLR(G1H8(587),22,8)
  call Hloop_QA_V(ntryL,G2H8(189),wf4(:,4),G2H2(431),m3h4x2(:,10),heltab2x8(:,:,918))
  call Hloop_QA_V(ntryL,G2H8(192),wf4(:,4),G2H2(432),m3h4x2(:,11),heltab2x8(:,:,919))
  call Hloop_QA_V(ntryL,G2H8(193),wf4(:,4),G2H2(433),m3h4x2(:,12),heltab2x8(:,:,920))
  call Hloop_QA_V(ntryL,G2H8(194),wf4(:,4),G2H2(434),m3h4x2(:,13),heltab2x8(:,:,921))
  call Hloop_QA_V(ntryL,G2H8(197),wf4(:,4),G2H2(435),m3h4x2(:,14),heltab2x8(:,:,922))
  call Hloop_QA_V(ntryL,G2H8(198),wf4(:,4),G2H2(436),m3h4x2(:,15),heltab2x8(:,:,923))
  call Hotf_5pt_reduction(G2H8(199),RedSet_5(20),mass5set(:,1),  & 
G1H8(591),G1H8(592),G1H8(593),G1H8(594),G1H8(595),G1H8(596),8)
  call HG1shiftOLR(G1H8(592),6,8)
  call Hotf_4pt_reduction(G2H8(201),RedSet_4(37),mass4set(:,1),  & 
G1H8(597),G1H8(598),G1H8(599),G1H8(600),G1H8(601),8)
  call HG1shiftOLR(G1H8(598),6,8)
  call Hotf_4pt_reduction(G2H8(202),RedSet_4(3),mass4set(:,1),  & 
G1H8(602),G1H8(603),G1H8(604),G1H8(605),G1H8(606),8)
  call HG1shiftOLR(G1H8(603),14,8)
  call Hloop_QA_V(ntryL,G2H8(203),wf4(:,4),G2H2(437),m3h4x2(:,16),heltab2x8(:,:,924))
  call Hloop_QA_V(ntryL,G2H8(206),wf4(:,4),G2H2(438),m3h4x2(:,17),heltab2x8(:,:,925))
  call Hloop_QA_V(ntryL,G2H8(207),wf4(:,4),G2H2(439),m3h4x2(:,18),heltab2x8(:,:,926))
  call Hotf_5pt_reduction(G2H8(209),RedSet_5(16),mass5set(:,1),  & 
G1H8(607),G1H8(608),G1H8(609),G1H8(610),G1H8(611),G1H8(612),8)
  call HG1shiftOLR(G1H8(608),9,8)
  call Hotf_4pt_reduction(G2H8(211),RedSet_4(86),mass4set(:,1),  & 
G1H8(613),G1H8(614),G1H8(615),G1H8(616),G1H8(617),8)
  call HG1shiftOLR(G1H8(614),9,8)
  call Hotf_4pt_reduction(G2H8(212),RedSet_4(141),mass4set(:,1),  & 
G1H8(618),G1H8(619),G1H8(620),G1H8(621),G1H8(622),8)
  call HG1shiftOLR(G1H8(619),25,8)
  call Hloop_AQ_V(ntryL,G2H8(213),wf4(:,15),G2H2(440),m3h4x2(:,19),heltab2x8(:,:,927))
  call Hloop_AQ_V(ntryL,G2H8(216),wf4(:,15),G2H2(441),m3h4x2(:,20),heltab2x8(:,:,928))
  call Hloop_AQ_V(ntryL,G2H8(217),wf4(:,15),G2H2(442),m3h4x2(:,21),heltab2x8(:,:,929))
  call Hotf_5pt_reduction(G2H8(218),RedSet_5(9),mass5set(:,1),  & 
G1H8(623),G1H8(624),G1H8(625),G1H8(626),G1H8(627),G1H8(628),8)
  call HG1shiftOLR(G1H8(624),9,8)
  call Hotf_4pt_reduction(G2H8(220),RedSet_4(86),mass4set(:,1),  & 
G1H8(629),G1H8(630),G1H8(631),G1H8(632),G1H8(633),8)
  call HG1shiftOLR(G1H8(630),9,8)
  call Hotf_4pt_reduction(G2H8(221),RedSet_4(88),mass4set(:,1),  & 
G1H8(634),G1H8(635),G1H8(636),G1H8(637),G1H8(638),8)
  call HG1shiftOLR(G1H8(635),13,8)
  call Hloop_QA_V(ntryL,G2H8(222),ex2(:),G2H4(41),m3h2x4(:,909),heltab2x8(:,:,930))
  call Hloop_QA_V(ntryL,G2H8(224),ex2(:),G2H4(334),m3h2x4(:,910),heltab2x8(:,:,931))
  call Hloop_QA_V(ntryL,G2H8(225),ex2(:),G2H4(45),m3h2x4(:,911),heltab2x8(:,:,932))
  call Hotf_5pt_reduction(G2H8(226),RedSet_5(14),mass5set(:,1),  & 
G1H8(639),G1H8(640),G1H8(641),G1H8(642),G1H8(643),G1H8(644),8)
  call HG1shiftOLR(G1H8(640),10,8)
  call Hotf_4pt_reduction(G2H8(228),RedSet_4(14),mass4set(:,1),  & 
G1H8(645),G1H8(646),G1H8(647),G1H8(648),G1H8(649),8)
  call HG1shiftOLR(G1H8(646),10,8)
  call Hotf_4pt_reduction(G2H8(229),RedSet_4(1),mass4set(:,1),  & 
G1H8(650),G1H8(651),G1H8(652),G1H8(653),G1H8(654),8)
  call HG1shiftOLR(G1H8(651),26,8)
  call Hloop_QA_V(ntryL,G2H8(230),wf4(:,7),G2H2(443),m3h4x2(:,22),heltab2x8(:,:,933))
  call Hloop_QA_V(ntryL,G2H8(233),wf4(:,7),G2H2(444),m3h4x2(:,23),heltab2x8(:,:,934))
  call Hloop_QA_V(ntryL,G2H8(234),wf4(:,7),G2H2(445),m3h4x2(:,24),heltab2x8(:,:,935))
  call Hotf_5pt_reduction(G2H8(235),RedSet_5(19),mass5set(:,1),  & 
G1H8(655),G1H8(656),G1H8(657),G1H8(658),G1H8(659),G1H8(660),8)
  call HG1shiftOLR(G1H8(656),10,8)
  call Hotf_4pt_reduction(G2H8(237),RedSet_4(14),mass4set(:,1),  & 
G1H8(661),G1H8(662),G1H8(663),G1H8(664),G1H8(665),8)
  call HG1shiftOLR(G1H8(662),10,8)
  call Hotf_4pt_reduction(G2H8(238),RedSet_4(3),mass4set(:,1),  & 
G1H8(666),G1H8(667),G1H8(668),G1H8(669),G1H8(670),8)
  call HG1shiftOLR(G1H8(667),14,8)
  call Hloop_AQ_V(ntryL,G2H8(239),ex1(:),G2H4(187),m3h2x4(:,912),heltab2x8(:,:,936))
  call Hloop_AQ_V(ntryL,G2H8(241),ex1(:),G2H4(49),m3h2x4(:,913),heltab2x8(:,:,937))
  call Hloop_AQ_V(ntryL,G2H8(242),ex1(:),G2H4(53),m3h2x4(:,914),heltab2x8(:,:,938))
  call Hotf_5pt_reduction(G2H8(243),RedSet_5(10),mass5set(:,1),  & 
G1H8(671),G1H8(672),G1H8(673),G1H8(674),G1H8(675),G1H8(676),8)
  call HG1shiftOLR(G1H8(672),17,8)
  call Hotf_4pt_reduction(G2H8(245),RedSet_4(100),mass4set(:,1),  & 
G1H8(677),G1H8(678),G1H8(679),G1H8(680),G1H8(681),8)
  call HG1shiftOLR(G1H8(678),17,8)
  call Hotf_4pt_reduction(G2H8(246),RedSet_4(102),mass4set(:,1),  & 
G1H8(682),G1H8(683),G1H8(684),G1H8(685),G1H8(686),8)
  call HG1shiftOLR(G1H8(683),21,8)
  call Hotf_5pt_reduction(G2H8(247),RedSet_5(15),mass5set(:,1),  & 
G1H8(687),G1H8(688),G1H8(689),G1H8(690),G1H8(691),G1H8(692),8)
  call HG1shiftOLR(G1H8(688),17,8)
  call Hotf_4pt_reduction(G2H8(249),RedSet_4(110),mass4set(:,1),  & 
G1H8(693),G1H8(694),G1H8(695),G1H8(696),G1H8(697),8)
  call HG1shiftOLR(G1H8(694),17,8)
  call Hotf_4pt_reduction(G2H8(250),RedSet_4(141),mass4set(:,1),  & 
G1H8(698),G1H8(699),G1H8(700),G1H8(701),G1H8(702),8)
  call HG1shiftOLR(G1H8(699),25,8)
  call Hloop_AQ_V(ntryL,G2H8(251),wf4(:,17),G2H2(446),m3h4x2(:,25),heltab2x8(:,:,939))
  call Hloop_AQ_V(ntryL,G2H8(254),wf4(:,17),G2H2(447),m3h4x2(:,26),heltab2x8(:,:,940))
  call Hloop_AQ_V(ntryL,G2H8(255),wf4(:,17),G2H2(448),m3h4x2(:,27),heltab2x8(:,:,941))
  call Hloop_QA_V(ntryL,G2H8(256),ex2(:),G2H4(335),m3h2x4(:,915),heltab2x8(:,:,942))
  call Hloop_QA_V(ntryL,G2H8(258),ex2(:),G2H4(57),m3h2x4(:,916),heltab2x8(:,:,943))
  call Hloop_QA_V(ntryL,G2H8(259),ex2(:),G2H4(336),m3h2x4(:,917),heltab2x8(:,:,944))
  call Hotf_5pt_reduction(G2H8(260),RedSet_5(11),mass5set(:,1),  & 
G1H8(703),G1H8(704),G1H8(705),G1H8(706),G1H8(707),G1H8(708),8)
  call HG1shiftOLR(G1H8(704),17,8)
  call Hotf_4pt_reduction(G2H8(262),RedSet_4(110),mass4set(:,1),  & 
G1H8(709),G1H8(710),G1H8(711),G1H8(712),G1H8(713),8)
  call HG1shiftOLR(G1H8(710),17,8)
  call Hotf_4pt_reduction(G2H8(263),RedSet_4(112),mass4set(:,1),  & 
G1H8(714),G1H8(715),G1H8(716),G1H8(717),G1H8(718),8)
  call HG1shiftOLR(G1H8(715),21,8)
  call Hloop_QA_V(ntryL,G2H8(264),ex2(:),G2H4(109),m3h2x4(:,918),heltab2x8(:,:,945))
  call Hloop_QA_V(ntryL,G2H8(266),ex2(:),G2H4(61),m3h2x4(:,919),heltab2x8(:,:,946))
  call Hloop_QA_V(ntryL,G2H8(267),ex2(:),G2H4(216),m3h2x4(:,920),heltab2x8(:,:,947))
  call Hotf_5pt_reduction(G2H8(268),RedSet_5(7),mass5set(:,1),  & 
G1H8(719),G1H8(720),G1H8(721),G1H8(722),G1H8(723),G1H8(724),8)
  call HG1shiftOLR(G1H8(720),18,8)
  call Hotf_4pt_reduction(G2H8(270),RedSet_4(71),mass4set(:,1),  & 
G1H8(725),G1H8(726),G1H8(727),G1H8(728),G1H8(729),8)
  call HG1shiftOLR(G1H8(726),18,8)
  call Hotf_4pt_reduction(G2H8(271),RedSet_4(73),mass4set(:,1),  & 
G1H8(730),G1H8(731),G1H8(732),G1H8(733),G1H8(734),8)
  call HG1shiftOLR(G1H8(731),22,8)
  call Hotf_5pt_reduction(G2H8(272),RedSet_5(13),mass5set(:,1),  & 
G1H8(735),G1H8(736),G1H8(737),G1H8(738),G1H8(739),G1H8(740),8)
  call HG1shiftOLR(G1H8(736),18,8)
  call Hotf_4pt_reduction(G2H8(274),RedSet_4(25),mass4set(:,1),  & 
G1H8(741),G1H8(742),G1H8(743),G1H8(744),G1H8(745),8)
  call HG1shiftOLR(G1H8(742),18,8)
  call Hotf_4pt_reduction(G2H8(275),RedSet_4(1),mass4set(:,1),  & 
G1H8(746),G1H8(747),G1H8(748),G1H8(749),G1H8(750),8)
  call HG1shiftOLR(G1H8(747),26,8)
  call Hloop_QA_V(ntryL,G2H8(276),wf4(:,10),G2H2(449),m3h4x2(:,28),heltab2x8(:,:,948))
  call Hloop_QA_V(ntryL,G2H8(279),wf4(:,10),G2H2(450),m3h4x2(:,29),heltab2x8(:,:,949))
  call Hloop_QA_V(ntryL,G2H8(280),wf4(:,10),G2H2(451),m3h4x2(:,30),heltab2x8(:,:,950))
  call Hloop_AQ_V(ntryL,G2H8(281),ex1(:),G2H4(137),m3h2x4(:,921),heltab2x8(:,:,951))
  call Hloop_AQ_V(ntryL,G2H8(283),ex1(:),G2H4(65),m3h2x4(:,922),heltab2x8(:,:,952))
  call Hloop_AQ_V(ntryL,G2H8(284),ex1(:),G2H4(130),m3h2x4(:,923),heltab2x8(:,:,953))
  call Hotf_5pt_reduction(G2H8(285),RedSet_5(17),mass5set(:,1),  & 
G1H8(751),G1H8(752),G1H8(753),G1H8(754),G1H8(755),G1H8(756),8)
  call HG1shiftOLR(G1H8(752),18,8)
  call Hotf_4pt_reduction(G2H8(287),RedSet_4(25),mass4set(:,1),  & 
G1H8(757),G1H8(758),G1H8(759),G1H8(760),G1H8(761),8)
  call HG1shiftOLR(G1H8(758),18,8)
  call Hotf_4pt_reduction(G2H8(288),RedSet_4(2),mass4set(:,1),  & 
G1H8(762),G1H8(763),G1H8(764),G1H8(765),G1H8(766),8)
  call HG1shiftOLR(G1H8(763),22,8)
  call Hloop_AQ_V(ntryL,G2H8(289),ex1(:),G2H4(69),m3h2x4(:,924),heltab2x8(:,:,954))
  call Hloop_AQ_V(ntryL,G2H8(291),ex1(:),G2H4(329),m3h2x4(:,925),heltab2x8(:,:,955))
  call Hloop_AQ_V(ntryL,G2H8(292),ex1(:),G2H4(125),m3h2x4(:,926),heltab2x8(:,:,956))
  call Hloop_QA_V(ntryL,G2H8(293),ex2(:),G2H4(73),m3h2x4(:,927),heltab2x8(:,:,957))
  call Hloop_QA_V(ntryL,G2H8(295),ex2(:),G2H4(220),m3h2x4(:,928),heltab2x8(:,:,958))
  call Hloop_QA_V(ntryL,G2H8(296),ex2(:),G2H4(141),m3h2x4(:,929),heltab2x8(:,:,959))
  call Hotf_5pt_reduction(G2H8(297),RedSet_5(54),mass5set(:,1),  & 
G1H8(767),G1H8(768),G1H8(769),G1H8(770),G1H8(771),G1H8(772),8)
  call HG1shiftOLR(G1H8(768),2,8)
  call Hotf_4pt_reduction(G2H8(299),RedSet_4(13),mass4set(:,1),  & 
G1H8(773),G1H8(774),G1H8(775),G1H8(776),G1H8(777),8)
  call HG1shiftOLR(G1H8(774),2,8)
  call Hotf_4pt_reduction(G2H8(300),RedSet_4(1),mass4set(:,1),  & 
G1H8(778),G1H8(779),G1H8(780),G1H8(781),G1H8(782),8)
  call HG1shiftOLR(G1H8(779),26,8)
  call Hloop_AQ_V(ntryL,G2H8(301),ex1(:),G2H4(77),m3h2x4(:,930),heltab2x8(:,:,960))
  call Hloop_AQ_V(ntryL,G2H8(303),ex1(:),G2H4(337),m3h2x4(:,931),heltab2x8(:,:,961))
  call Hloop_AQ_V(ntryL,G2H8(304),ex1(:),G2H4(81),m3h2x4(:,932),heltab2x8(:,:,962))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1814),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1962),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1888),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1793),[G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(219),[G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1941),[G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1867),[G1H4(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(190),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(209),[G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(262),[G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(281),[G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(321),[G1H4(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(334),[G1H4(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(389),[G1H4(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(418),[G1H4(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(501),[G1H4(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(526),[G1H4(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(573),[G1H4(567)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(590),[G1H4(572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(650)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(656),[G1H4(651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(670)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(676),[G1H4(671)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(686),[G1H4(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(691),[G1H4(685)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(702),[G1H4(700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(707),[G1H4(701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(718),[G1H4(716)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(723),[G1H4(717)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(744),[G1H4(739)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(758),[G1H4(756)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(763),[G1H4(757)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(877),[G1H4(875)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1319),[G1H4(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(887),[G1H4(885)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1324),[G1H4(886)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(915),[G1H4(913)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1329),[G1H4(914)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(925),[G1H4(923)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1334),[G1H4(924)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(944),[G1H4(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1339),[G1H4(943)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(954),[G1H4(952)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1344),[G1H4(953)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(968)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1349),[G1H4(969)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(303),[G1H4(983)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1354),[G1H4(984)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(315),[G1H4(998)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1359),[G1H4(999)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(327),[G1H4(1013)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1364),[G1H4(1014)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(339),[G1H4(1028)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1369),[G1H4(1029)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(351),[G1H4(1043)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1374),[G1H4(1044)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1184),[G1H4(1176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1379),[G1H4(1177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1189),[G1H4(1182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(646),[G1H4(1183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1203),[G1H4(1195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1384),[G1H4(1196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1208),[G1H4(1201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1294),[G1H4(1202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1222),[G1H4(1214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1389),[G1H4(1215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1227),[G1H4(1220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1299),[G1H4(1221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1241),[G1H4(1233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1394),[G1H4(1234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1246),[G1H4(1239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1304),[G1H4(1240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1261),[G1H4(1253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1399),[G1H4(1254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1266),[G1H4(1259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1309),[G1H4(1260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1281),[G1H4(1273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1404),[G1H4(1274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1286),[G1H4(1279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1314),[G1H4(1280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1415),[G1H4(1413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1420),[G1H4(1414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1431),[G1H4(1429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1436),[G1H4(1430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1447),[G1H4(1445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1452),[G1H4(1446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1463),[G1H4(1461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1468),[G1H4(1462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1479),[G1H4(1477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1484),[G1H4(1478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1495),[G1H4(1493)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1500),[G1H4(1494)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1511),[G1H4(1509)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1516),[G1H4(1510)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1527),[G1H4(1525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1532),[G1H4(1526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1543),[G1H4(1541)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1548),[G1H4(1542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1559),[G1H4(1557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1564),[G1H4(1558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1575),[G1H4(1573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1580),[G1H4(1574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1591),[G1H4(1589)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1596),[G1H4(1590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G1H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(182),[G1H8(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(238),[G1H8(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(280),[G1H8(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(334),[G1H8(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(204),[G1H8(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(227),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(236),[G1H8(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(381),[G1H8(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(417),[G1H8(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(259),[G1H8(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(264),[G1H8(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1607),[G1H4(1605)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1612),[G1H4(1606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1623),[G1H4(1621)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1628),[G1H4(1622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1639),[G1H4(1637)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1644),[G1H4(1638)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1655),[G1H4(1653)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1660),[G1H4(1654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(289),[G1H8(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(299),[G1H8(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(502),[G1H8(500)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(508),[G1H8(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(312),[G1H8(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(347),[G1H8(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(356),[G1H8(344)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(383),[G1H8(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(392),[G1H8(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(416),[G1H8(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(427),[G1H8(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1671),[G1H4(1669)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1676),[G1H4(1670)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1687),[G1H4(1685)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1692),[G1H4(1686)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1703),[G1H4(1701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1708),[G1H4(1702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1719),[G1H4(1717)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1724),[G1H4(1718)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(457),[G1H8(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(462),[G1H8(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(487),[G1H8(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(497),[G1H8(482)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(306),[G1H8(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(360),[G1H8(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(486),[G1H8(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(517),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(522),[G1H8(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(533),[G1H8(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(538),[G1H8(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1735),[G1H4(1733)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1740),[G1H4(1734)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1751),[G1H4(1749)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1756),[G1H4(1750)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1767),[G1H4(1765)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1772),[G1H4(1766)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1783),[G1H4(1781)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1788),[G1H4(1782)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1804),[G1H4(1802)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1809),[G1H4(1803)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1825),[G1H4(1823)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1830),[G1H4(1824)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1841),[G1H4(1839)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1846),[G1H4(1840)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1857),[G1H4(1855)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1862),[G1H4(1856)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1878),[G1H4(1876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1883),[G1H4(1877)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1899),[G1H4(1897)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1904),[G1H4(1898)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1915),[G1H4(1913)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1920),[G1H4(1914)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1931),[G1H4(1929)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1936),[G1H4(1930)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1952),[G1H4(1950)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1957),[G1H4(1951)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1973),[G1H4(1971)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1978),[G1H4(1972)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1989),[G1H4(1987)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1994),[G1H4(1988)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2005),[G1H4(2003)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2010),[G1H4(2004)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(549),[G1H8(547)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(554),[G1H8(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(565),[G1H8(563)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(570),[G1H8(564)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(581),[G1H8(579)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(586),[G1H8(580)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(597),[G1H8(595)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(602),[G1H8(596)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(613),[G1H8(611)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(618),[G1H8(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(629),[G1H8(627)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(634),[G1H8(628)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(645),[G1H8(643)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(650),[G1H8(644)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(661),[G1H8(659)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(666),[G1H8(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(677),[G1H8(675)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(682),[G1H8(676)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(693),[G1H8(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(698),[G1H8(692)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(709),[G1H8(707)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(714),[G1H8(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(725),[G1H8(723)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(730),[G1H8(724)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(741),[G1H8(739)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(746),[G1H8(740)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(757),[G1H8(755)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(762),[G1H8(756)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(773),[G1H8(771)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(778),[G1H8(772)])
  call Hloop_VA_Q(ntryL,G1H4(598),ex2(:),G1H2(332),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_A_Q(ntryL,G1H2(332),47,0,G2H2(452),n2h2(244))
call HGT_OLR(G1H4(599),1,1,4)
call HGT_invQ_OLR(G1H4(599),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(599),-16,0,G2H4(207),n2h4(833))
  call Hloop_QV_A(ntryL,G2H4(207),ex5(:),G2H2(453),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_VA_Q(ntryL,G1H4(610),ex2(:),G1H2(337),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_A_Q(ntryL,G1H2(337),47,0,G2H2(454),n2h2(245))
  call Hloop_VA_Q(ntryL,G1H4(611),ex2(:),G1H2(338),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(338),47,0,G2H2(455),n2h2(246))
  call Hloop_VA_Q(ntryL,G1H4(615),ex2(:),G1H2(19),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_A_Q(ntryL,G1H2(19),47,0,G2H2(456),n2h2(247))
call HGT_OLR(G1H4(616),1,1,4)
call HGT_invQ_OLR(G1H4(616),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(616),-16,0,G2H4(85),n2h4(834))
  call Hloop_QV_A(ntryL,G2H4(85),ex5(:),G2H2(457),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_VA_Q(ntryL,G1H4(627),ex2(:),G1H2(20),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(458),n2h2(248))
  call Hloop_VA_Q(ntryL,G1H4(628),ex2(:),G1H2(25),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(459),n2h2(249))
  call Hloop_VQ_A(ntryL,G1H4(632),ex1(:),G1H2(26),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_Q_A(ntryL,G1H2(26),55,0,G2H2(460),n2h2(250))
call HGT_OLR(G1H4(633),1,1,4)
call HGT_invQ_OLR(G1H4(633),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(633),-8,0,G2H4(338),n2h4(835))
  call Hloop_AV_Q(ntryL,G2H4(338),ex4(:),G2H2(461),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_VQ_A(ntryL,G1H4(644),ex1(:),G1H2(31),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_Q_A(ntryL,G1H2(31),55,0,G2H2(462),n2h2(251))
  call Hloop_VQ_A(ntryL,G1H4(645),ex1(:),G1H2(32),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(463),n2h2(252))
  call Hloop_VQ_A(ntryL,G1H4(24),ex1(:),G1H2(37),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(464),n2h2(253))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(36),-16,0,G2H4(145),n2h4(836))
  call Hloop_AV_Q(ntryL,G2H4(145),ex5(:),G2H2(465),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_VQ_A(ntryL,G1H4(72),ex1(:),G1H2(38),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(466),n2h2(254))
  call Hloop_VQ_A(ntryL,G1H4(84),ex1(:),G1H2(43),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(467),n2h2(255))
  call Hloop_VQ_A(ntryL,G1H4(96),ex1(:),G1H2(44),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(468),n2h2(256))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(108),-16,0,G2H4(89),n2h4(837))
  call Hloop_AV_Q(ntryL,G2H4(89),ex5(:),G2H2(469),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_VQ_A(ntryL,G1H4(144),ex1(:),G1H2(49),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(470),n2h2(257))
  call Hloop_VQ_A(ntryL,G1H4(156),ex1(:),G1H2(50),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(471),n2h2(258))
  call Hloop_VA_Q(ntryL,G1H4(168),ex2(:),G1H2(55),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(472),n2h2(259))
call HGT_OLR(G1H4(180),1,1,4)
call HGT_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(180),-8,0,G2H4(196),n2h4(838))
  call Hloop_QV_A(ntryL,G2H4(196),ex4(:),G2H2(473),m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_VA_Q(ntryL,G1H4(216),ex2(:),G1H2(56),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(474),n2h2(260))
  call Hloop_VA_Q(ntryL,G1H4(228),ex2(:),G1H2(61),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_A_Q(ntryL,G1H2(61),55,0,G2H2(475),n2h2(261))
  call Hloop_UV_W(ntryL,G1H4(240),39,ex4(:),8,G2H2(476),m3h2x2(:,524),heltab2x4(:,:,524))
call HGT_raise_alpha_OLR(G1H4(252),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(252),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(252),-16,ex5(:),16,G2H2(477),m3h2x2(:,525),heltab2x4(:,:,525))
call signflip_OLR(G2H2(477))
  call Hloop_UV_W(ntryL,G1H4(288),39,ex4(:),8,G2H2(478),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_UV_W(ntryL,G1H4(300),39,ex4(:),8,G2H2(479),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_UV_W(ntryL,G1H4(312),39,ex5(:),16,G2H2(480),m3h2x2(:,528),heltab2x4(:,:,528))
call HGT_raise_alpha_OLR(G1H4(324),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(324),-8,ex4(:),8,G2H2(481),m3h2x2(:,529),heltab2x4(:,:,529))
call signflip_OLR(G2H2(481))
  call Hloop_UV_W(ntryL,G1H4(372),39,ex5(:),16,G2H2(482),m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_UV_W(ntryL,G1H4(384),39,ex5(:),16,G2H2(483),m3h2x2(:,531),heltab2x4(:,:,531))
  call Hloop_UV_W(ntryL,G1H4(396),39,ex4(:),8,G2H2(484),m3h2x2(:,532),heltab2x4(:,:,532))
call HGT_raise_alpha_OLR(G1H4(420),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(420),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(420),-16,ex5(:),16,G2H2(485),m3h2x2(:,533),heltab2x4(:,:,533))
call signflip_OLR(G2H2(485))
  call Hloop_UV_W(ntryL,G1H4(456),39,ex4(:),8,G2H2(486),m3h2x2(:,534),heltab2x4(:,:,534))
  call Hloop_UV_W(ntryL,G1H4(468),39,ex4(:),8,G2H2(487),m3h2x2(:,535),heltab2x4(:,:,535))
  call Hloop_UV_W(ntryL,G1H4(480),39,ex5(:),16,G2H2(488),m3h2x2(:,536),heltab2x4(:,:,536))
call HGT_raise_alpha_OLR(G1H4(492),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(492),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(492),-8,ex4(:),8,G2H2(489),m3h2x2(:,537),heltab2x4(:,:,537))
call signflip_OLR(G2H2(489))
  call Hloop_UV_W(ntryL,G1H4(528),39,ex5(:),16,G2H2(490),m3h2x2(:,538),heltab2x4(:,:,538))
  call Hloop_UV_W(ntryL,G1H4(540),39,ex5(:),16,G2H2(491),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_VQ_A(ntryL,G1H4(552),ex1(:),G1H2(62),m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_Q_A(ntryL,G1H2(62),59,0,G2H2(492),n2h2(262))
call HGT_OLR(G1H4(558),1,1,4)
call HGT_invQ_OLR(G1H4(558),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(558),-4,0,G2H4(153),n2h4(843))
  call Hloop_AV_Q(ntryL,G2H4(153),ex3(:),G2H2(493),m3h2x2(:,541),heltab2x4(:,:,541))
  call Hloop_VQ_A(ntryL,G1H4(586),ex1(:),G1H2(67),m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(494),n2h2(263))
  call Hloop_VQ_A(ntryL,G1H4(603),ex1(:),G1H2(68),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(495),n2h2(264))
  call Hloop_QV_A(ntryL,G1H4(609),ex3(:),G1H2(73),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(496),n2h2(265))
call HGT_OLR(G1H4(620),1,1,4)
call HGT_invQ_OLR(G1H4(620),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(620),-16,0,G2H4(93),n2h4(844))
  call Hloop_AV_Q(ntryL,G2H4(93),ex5(:),G2H2(497),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_QV_A(ntryL,G1H4(147),ex3(:),G1H2(74),m3h2x2(:,546),heltab2x4(:,:,546))
  call Hloop_Q_A(ntryL,G1H2(74),47,0,G2H2(498),n2h2(266))
  call Hloop_QV_A(ntryL,G1H4(1814),ex3(:),G1H2(79),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_Q_A(ntryL,G1H2(79),47,0,G2H2(499),n2h2(267))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(80),m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_A_Q(ntryL,G1H2(80),55,0,G2H2(500),n2h2(268))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-8,0,G2H4(330),n2h4(845))
  call Hloop_QV_A(ntryL,G2H4(330),ex4(:),G2H2(501),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_VA_Q(ntryL,G1H4(32),ex2(:),G1H2(85),m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_A_Q(ntryL,G1H2(85),55,0,G2H2(502),n2h2(269))
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(86),m3h2x2(:,551),heltab2x4(:,:,551))
  call Hloop_A_Q(ntryL,G1H2(86),55,0,G2H2(503),n2h2(270))
  call Hloop_AV_Q(ntryL,G1H4(42),ex4(:),G1H2(91),m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(504),n2h2(271))
call HGT_OLR(G1H4(43),1,1,4)
call HGT_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(43),-16,0,G2H4(161),n2h4(846))
  call Hloop_QV_A(ntryL,G2H4(161),ex5(:),G2H2(505),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_AV_Q(ntryL,G1H4(159),ex4(:),G1H2(92),m3h2x2(:,554),heltab2x4(:,:,554))
  call Hloop_A_Q(ntryL,G1H2(92),47,0,G2H2(506),n2h2(272))
  call Hloop_AV_Q(ntryL,G1H4(1962),ex4(:),G1H2(97),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_A_Q(ntryL,G1H2(97),47,0,G2H2(507),n2h2(273))
  call Hloop_VA_Q(ntryL,G1H4(73),ex2(:),G1H2(98),m3h2x2(:,556),heltab2x4(:,:,556))
  call Hloop_A_Q(ntryL,G1H2(98),47,0,G2H2(508),n2h2(274))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-16,0,G2H4(97),n2h4(847))
  call Hloop_QV_A(ntryL,G2H4(97),ex5(:),G2H2(509),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_VA_Q(ntryL,G1H4(80),ex2(:),G1H2(103),m3h2x2(:,558),heltab2x4(:,:,558))
  call Hloop_A_Q(ntryL,G1H2(103),47,0,G2H2(510),n2h2(275))
  call Hloop_VA_Q(ntryL,G1H4(85),ex2(:),G1H2(104),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(511),n2h2(276))
  call Hloop_AV_Q(ntryL,G1H4(86),ex5(:),G1H2(109),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_A_Q(ntryL,G1H2(109),55,0,G2H2(512),n2h2(277))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(90),-8,0,G2H4(200),n2h4(848))
  call Hloop_QV_A(ntryL,G2H4(200),ex4(:),G2H2(513),m3h2x2(:,561),heltab2x4(:,:,561))
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(110),m3h2x2(:,562),heltab2x4(:,:,562))
  call Hloop_A_Q(ntryL,G1H2(110),55,0,G2H2(514),n2h2(278))
  call Hloop_AV_Q(ntryL,G1H4(1888),ex5(:),G1H2(115),m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_A_Q(ntryL,G1H2(115),55,0,G2H2(515),n2h2(279))
  call Hloop_QV_A(ntryL,G1H4(102),ex3(:),G1H2(116),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_Q_A(ntryL,G1H2(116),55,0,G2H2(516),n2h2(280))
call HGT_OLR(G1H4(103),1,1,4)
call HGT_invQ_OLR(G1H4(103),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(103),-8,0,G2H4(165),n2h4(849))
  call Hloop_AV_Q(ntryL,G2H4(165),ex4(:),G2H2(517),m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_QV_A(ntryL,G1H4(110),ex3(:),G1H2(121),m3h2x2(:,566),heltab2x4(:,:,566))
  call Hloop_Q_A(ntryL,G1H2(121),55,0,G2H2(518),n2h2(281))
  call Hloop_QV_A(ntryL,G1H4(114),ex3(:),G1H2(122),m3h2x2(:,567),heltab2x4(:,:,567))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(519),n2h2(282))
  call Hloop_QV_A(ntryL,G1H4(115),ex4(:),G1H2(127),m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_Q_A(ntryL,G1H2(127),47,0,G2H2(520),n2h2(283))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-16,0,G2H4(101),n2h4(850))
  call Hloop_AV_Q(ntryL,G2H4(101),ex5(:),G2H2(521),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_QV_A(ntryL,G1H4(139),ex4(:),G1H2(128),m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_Q_A(ntryL,G1H2(128),47,0,G2H2(522),n2h2(284))
  call Hloop_QV_A(ntryL,G1H4(140),ex4(:),G1H2(133),m3h2x2(:,571),heltab2x4(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(133),47,0,G2H2(523),n2h2(285))
  call Hloop_QV_A(ntryL,G1H4(145),ex3(:),G1H2(134),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(524),n2h2(286))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-16,0,G2H4(339),n2h4(851))
  call Hloop_AV_Q(ntryL,G2H4(339),ex5(:),G2H2(525),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_QV_A(ntryL,G1H4(152),ex3(:),G1H2(139),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_Q_A(ntryL,G1H2(139),47,0,G2H2(526),n2h2(287))
  call Hloop_QV_A(ntryL,G1H4(157),ex3(:),G1H2(140),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(527),n2h2(288))
  call Hloop_QV_A(ntryL,G1H4(158),ex5(:),G1H2(145),m3h2x2(:,576),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G1H2(145),55,0,G2H2(528),n2h2(289))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(162),-8,0,G2H4(121),n2h4(852))
  call Hloop_AV_Q(ntryL,G2H4(121),ex4(:),G2H2(529),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_QV_A(ntryL,G1H4(169),ex5(:),G1H2(146),m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(146),55,0,G2H2(530),n2h2(290))
  call Hloop_QV_A(ntryL,G1H4(170),ex5(:),G1H2(151),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(151),55,0,G2H2(531),n2h2(291))
  call Hloop_VA_Q(ntryL,G1H4(174),ex2(:),G1H2(152),m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_A_Q(ntryL,G1H2(152),59,0,G2H2(532),n2h2(292))
call HGT_OLR(G1H4(175),1,1,4)
call HGT_invQ_OLR(G1H4(175),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(175),-4,0,G2H4(113),n2h4(853))
  call Hloop_QV_A(ntryL,G2H4(113),ex3(:),G2H2(533),m3h2x2(:,581),heltab2x4(:,:,581))
  call Hloop_VA_Q(ntryL,G1H4(182),ex2(:),G1H2(157),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_A_Q(ntryL,G1H2(157),59,0,G2H2(534),n2h2(293))
  call Hloop_VA_Q(ntryL,G1H4(186),ex2(:),G1H2(158),m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_A_Q(ntryL,G1H2(158),59,0,G2H2(535),n2h2(294))
  call Hloop_AV_Q(ntryL,G1H4(187),ex3(:),G1H2(163),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_A_Q(ntryL,G1H2(163),47,0,G2H2(536),n2h2(295))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(188),-16,0,G2H4(331),n2h4(854))
  call Hloop_QV_A(ntryL,G2H4(331),ex5(:),G2H2(537),m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_AV_Q(ntryL,G1H4(207),ex3(:),G1H2(164),m3h2x2(:,586),heltab2x4(:,:,586))
  call Hloop_A_Q(ntryL,G1H2(164),47,0,G2H2(538),n2h2(296))
  call Hloop_AV_Q(ntryL,G1H4(1793),ex3(:),G1H2(169),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_A_Q(ntryL,G1H2(169),47,0,G2H2(539),n2h2(297))
  call Hloop_VQ_A(ntryL,G1H4(200),ex1(:),G1H2(170),m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(170),55,0,G2H2(540),n2h2(298))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(205),-8,0,G2H4(277),n2h4(855))
  call Hloop_AV_Q(ntryL,G2H4(277),ex4(:),G2H2(541),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_VQ_A(ntryL,G1H4(211),ex1(:),G1H2(175),m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_Q_A(ntryL,G1H2(175),55,0,G2H2(542),n2h2(299))
  call Hloop_VQ_A(ntryL,G1H4(212),ex1(:),G1H2(176),m3h2x2(:,591),heltab2x4(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(176),55,0,G2H2(543),n2h2(300))
  call Hloop_QV_A(ntryL,G1H4(217),ex4(:),G1H2(181),m3h2x2(:,592),heltab2x4(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(181),47,0,G2H2(544),n2h2(301))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-16,0,G2H4(280),n2h4(856))
  call Hloop_AV_Q(ntryL,G2H4(280),ex5(:),G2H2(545),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_QV_A(ntryL,G1H4(219),ex4(:),G1H2(182),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_Q_A(ntryL,G1H2(182),47,0,G2H2(546),n2h2(302))
  call Hloop_QV_A(ntryL,G1H4(1941),ex4(:),G1H2(187),m3h2x2(:,595),heltab2x4(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(187),47,0,G2H2(547),n2h2(303))
  call Hloop_QV_A(ntryL,G1H4(230),ex4(:),G1H2(188),m3h2x2(:,596),heltab2x4(:,:,596))
  call Hloop_Q_A(ntryL,G1H2(188),59,0,G2H2(548),n2h2(304))
call HGT_OLR(G1H4(234),1,1,4)
call HGT_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(234),-4,0,G2H4(340),n2h4(857))
  call Hloop_AV_Q(ntryL,G2H4(340),ex3(:),G2H2(549),m3h2x2(:,597),heltab2x4(:,:,597))
  call Hloop_QV_A(ntryL,G1H4(242),ex4(:),G1H2(193),m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_Q_A(ntryL,G1H2(193),59,0,G2H2(550),n2h2(305))
  call Hloop_QV_A(ntryL,G1H4(246),ex4(:),G1H2(194),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_Q_A(ntryL,G1H2(194),59,0,G2H2(551),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(247),ex3(:),G1H2(199),m3h2x2(:,600),heltab2x4(:,:,600))
  call Hloop_Q_A(ntryL,G1H2(199),47,0,G2H2(552),n2h2(307))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(248),-16,0,G2H4(157),n2h4(858))
  call Hloop_AV_Q(ntryL,G2H4(157),ex5(:),G2H2(553),m3h2x2(:,601),heltab2x4(:,:,601))
  call Hloop_QV_A(ntryL,G1H4(258),ex3(:),G1H2(200),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_Q_A(ntryL,G1H2(200),47,0,G2H2(554),n2h2(308))
  call Hloop_QV_A(ntryL,G1H4(259),ex3(:),G1H2(205),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(205),47,0,G2H2(555),n2h2(309))
  call Hloop_QV_A(ntryL,G1H4(260),ex4(:),G1H2(206),m3h2x2(:,604),heltab2x4(:,:,604))
  call Hloop_Q_A(ntryL,G1H2(206),47,0,G2H2(556),n2h2(310))
call HGT_OLR(G1H4(265),1,1,4)
call HGT_invQ_OLR(G1H4(265),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(265),-16,0,G2H4(149),n2h4(859))
  call Hloop_AV_Q(ntryL,G2H4(149),ex5(:),G2H2(557),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_QV_A(ntryL,G1H4(272),ex4(:),G1H2(211),m3h2x2(:,606),heltab2x4(:,:,606))
  call Hloop_Q_A(ntryL,G1H2(211),47,0,G2H2(558),n2h2(311))
  call Hloop_QV_A(ntryL,G1H4(277),ex4(:),G1H2(212),m3h2x2(:,607),heltab2x4(:,:,607))
  call Hloop_Q_A(ntryL,G1H2(212),47,0,G2H2(559),n2h2(312))
  call Hloop_QV_A(ntryL,G1H4(278),ex5(:),G1H2(217),m3h2x2(:,608),heltab2x4(:,:,608))
  call Hloop_Q_A(ntryL,G1H2(217),59,0,G2H2(560),n2h2(313))
call HGT_OLR(G1H4(282),1,1,4)
call HGT_invQ_OLR(G1H4(282),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(282),-4,0,G2H4(241),n2h4(860))
  call Hloop_AV_Q(ntryL,G2H4(241),ex3(:),G2H2(561),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_QV_A(ntryL,G1H4(289),ex5(:),G1H2(218),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_Q_A(ntryL,G1H2(218),59,0,G2H2(562),n2h2(314))
  call Hloop_QV_A(ntryL,G1H4(294),ex5(:),G1H2(223),m3h2x2(:,611),heltab2x4(:,:,611))
  call Hloop_Q_A(ntryL,G1H2(223),59,0,G2H2(563),n2h2(315))
  call Hloop_VQ_A(ntryL,G1H4(295),ex1(:),G1H2(224),m3h2x2(:,612),heltab2x4(:,:,612))
  call Hloop_Q_A(ntryL,G1H2(224),47,0,G2H2(564),n2h2(316))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(296),-16,0,G2H4(332),n2h4(861))
  call Hloop_AV_Q(ntryL,G2H4(332),ex5(:),G2H2(565),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_VQ_A(ntryL,G1H4(306),ex1(:),G1H2(229),m3h2x2(:,614),heltab2x4(:,:,614))
  call Hloop_Q_A(ntryL,G1H2(229),47,0,G2H2(566),n2h2(317))
  call Hloop_VQ_A(ntryL,G1H4(307),ex1(:),G1H2(230),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_Q_A(ntryL,G1H2(230),47,0,G2H2(567),n2h2(318))
  call Hloop_QV_A(ntryL,G1H4(308),ex5(:),G1H2(235),m3h2x2(:,616),heltab2x4(:,:,616))
  call Hloop_Q_A(ntryL,G1H2(235),55,0,G2H2(568),n2h2(319))
call HGT_OLR(G1H4(313),1,1,4)
call HGT_invQ_OLR(G1H4(313),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(313),-8,0,G2H4(260),n2h4(862))
  call Hloop_AV_Q(ntryL,G2H4(260),ex4(:),G2H2(569),m3h2x2(:,617),heltab2x4(:,:,617))
  call Hloop_QV_A(ntryL,G1H4(255),ex5(:),G1H2(236),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_Q_A(ntryL,G1H2(236),55,0,G2H2(570),n2h2(320))
  call Hloop_QV_A(ntryL,G1H4(1867),ex5(:),G1H2(241),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_Q_A(ntryL,G1H2(241),55,0,G2H2(571),n2h2(321))
  call Hloop_QV_A(ntryL,G1H4(326),ex5(:),G1H2(242),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(242),59,0,G2H2(572),n2h2(322))
call HGT_OLR(G1H4(330),1,1,4)
call HGT_invQ_OLR(G1H4(330),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(330),-4,0,G2H4(371),n2h4(863))
  call Hloop_AV_Q(ntryL,G2H4(371),ex3(:),G2H2(573),m3h2x2(:,621),heltab2x4(:,:,621))
  call Hloop_QV_A(ntryL,G1H4(337),ex5(:),G1H2(247),m3h2x2(:,622),heltab2x4(:,:,622))
  call Hloop_Q_A(ntryL,G1H2(247),59,0,G2H2(574),n2h2(323))
  call Hloop_QV_A(ntryL,G1H4(338),ex5(:),G1H2(248),m3h2x2(:,623),heltab2x4(:,:,623))
  call Hloop_Q_A(ntryL,G1H2(248),59,0,G2H2(575),n2h2(324))
  call Hloop_QV_A(ntryL,G1H4(342),ex3(:),G1H2(253),m3h2x2(:,624),heltab2x4(:,:,624))
  call Hloop_Q_A(ntryL,G1H2(253),55,0,G2H2(576),n2h2(325))
call HGT_OLR(G1H4(343),1,1,4)
call HGT_invQ_OLR(G1H4(343),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(343),-8,0,G2H4(169),n2h4(864))
  call Hloop_AV_Q(ntryL,G2H4(169),ex4(:),G2H2(577),m3h2x2(:,625),heltab2x4(:,:,625))
  call Hloop_QV_A(ntryL,G1H4(350),ex3(:),G1H2(254),m3h2x2(:,626),heltab2x4(:,:,626))
  call Hloop_Q_A(ntryL,G1H2(254),55,0,G2H2(578),n2h2(326))
  call Hloop_QV_A(ntryL,G1H4(355),ex3(:),G1H2(259),m3h2x2(:,627),heltab2x4(:,:,627))
  call Hloop_Q_A(ntryL,G1H2(259),55,0,G2H2(579),n2h2(327))
  call Hloop_QV_A(ntryL,G1H4(356),ex5(:),G1H2(260),m3h2x2(:,628),heltab2x4(:,:,628))
  call Hloop_Q_A(ntryL,G1H2(260),55,0,G2H2(580),n2h2(328))
call HGT_OLR(G1H4(361),1,1,4)
call HGT_invQ_OLR(G1H4(361),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(361),-8,0,G2H4(373),n2h4(865))
  call Hloop_AV_Q(ntryL,G2H4(373),ex4(:),G2H2(581),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_QV_A(ntryL,G1H4(367),ex5(:),G1H2(265),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_Q_A(ntryL,G1H2(265),55,0,G2H2(582),n2h2(329))
  call Hloop_QV_A(ntryL,G1H4(368),ex5(:),G1H2(266),m3h2x2(:,631),heltab2x4(:,:,631))
  call Hloop_Q_A(ntryL,G1H2(266),55,0,G2H2(583),n2h2(330))
  call Hloop_QV_A(ntryL,G1H4(373),ex4(:),G1H2(271),m3h2x2(:,632),heltab2x4(:,:,632))
  call Hloop_Q_A(ntryL,G1H2(271),59,0,G2H2(584),n2h2(331))
call HGT_OLR(G1H4(378),1,1,4)
call HGT_invQ_OLR(G1H4(378),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(378),-4,0,G2H4(175),n2h4(866))
  call Hloop_AV_Q(ntryL,G2H4(175),ex3(:),G2H2(585),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_QV_A(ntryL,G1H4(385),ex4(:),G1H2(272),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_Q_A(ntryL,G1H2(272),59,0,G2H2(586),n2h2(332))
  call Hloop_QV_A(ntryL,G1H4(386),ex4(:),G1H2(277),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_Q_A(ntryL,G1H2(277),59,0,G2H2(587),n2h2(333))
  call Hloop_AV_Q(ntryL,G1H4(390),ex3(:),G1H2(278),m3h2x2(:,636),heltab2x4(:,:,636))
  call Hloop_A_Q(ntryL,G1H2(278),55,0,G2H2(588),n2h2(334))
call HGT_OLR(G1H4(391),1,1,4)
call HGT_invQ_OLR(G1H4(391),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(391),-8,0,G2H4(172),n2h4(867))
  call Hloop_QV_A(ntryL,G2H4(172),ex4(:),G2H2(589),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_AV_Q(ntryL,G1H4(402),ex3(:),G1H2(283),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_A_Q(ntryL,G1H2(283),55,0,G2H2(590),n2h2(335))
  call Hloop_AV_Q(ntryL,G1H4(403),ex3(:),G1H2(284),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_A_Q(ntryL,G1H2(284),55,0,G2H2(591),n2h2(336))
  call Hloop_AV_Q(ntryL,G1H4(404),ex4(:),G1H2(289),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_A_Q(ntryL,G1H2(289),47,0,G2H2(592),n2h2(337))
call HGT_OLR(G1H4(410),1,1,4)
call HGT_invQ_OLR(G1H4(410),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(410),-16,0,G2H4(173),n2h4(868))
  call Hloop_QV_A(ntryL,G2H4(173),ex5(:),G2H2(593),m3h2x2(:,641),heltab2x4(:,:,641))
  call Hloop_AV_Q(ntryL,G1H4(416),ex4(:),G1H2(290),m3h2x2(:,642),heltab2x4(:,:,642))
  call Hloop_A_Q(ntryL,G1H2(290),47,0,G2H2(594),n2h2(338))
  call Hloop_AV_Q(ntryL,G1H4(422),ex4(:),G1H2(295),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(295),47,0,G2H2(595),n2h2(339))
  call Hloop_AV_Q(ntryL,G1H4(426),ex3(:),G1H2(296),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_A_Q(ntryL,G1H2(296),47,0,G2H2(596),n2h2(340))
call HGT_OLR(G1H4(427),1,1,4)
call HGT_invQ_OLR(G1H4(427),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(427),-16,0,G2H4(374),n2h4(869))
  call Hloop_QV_A(ntryL,G2H4(374),ex5(:),G2H2(597),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_AV_Q(ntryL,G1H4(434),ex3(:),G1H2(301),m3h2x2(:,646),heltab2x4(:,:,646))
  call Hloop_A_Q(ntryL,G1H2(301),47,0,G2H2(598),n2h2(341))
  call Hloop_AV_Q(ntryL,G1H4(438),ex3(:),G1H2(302),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_A_Q(ntryL,G1H2(302),47,0,G2H2(599),n2h2(342))
  call Hloop_AV_Q(ntryL,G1H4(439),ex5(:),G1H2(307),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_A_Q(ntryL,G1H2(307),55,0,G2H2(600),n2h2(343))
call HGT_OLR(G1H4(445),1,1,4)
call HGT_invQ_OLR(G1H4(445),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(445),-8,0,G2H4(385),n2h4(870))
  call Hloop_QV_A(ntryL,G2H4(385),ex4(:),G2H2(601),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_AV_Q(ntryL,G1H4(451),ex5(:),G1H2(308),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_A_Q(ntryL,G1H2(308),55,0,G2H2(602),n2h2(344))
  call Hloop_AV_Q(ntryL,G1H4(452),ex5(:),G1H2(313),m3h2x2(:,651),heltab2x4(:,:,651))
  call Hloop_A_Q(ntryL,G1H2(313),55,0,G2H2(603),n2h2(345))
  call Hloop_AV_Q(ntryL,G1H4(457),ex4(:),G1H2(314),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_A_Q(ntryL,G1H2(314),59,0,G2H2(604),n2h2(346))
call HGT_OLR(G1H4(458),1,1,4)
call HGT_invQ_OLR(G1H4(458),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(458),-4,0,G2H4(179),n2h4(871))
  call Hloop_QV_A(ntryL,G2H4(179),ex3(:),G2H2(605),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_AV_Q(ntryL,G1H4(469),ex4(:),G1H2(319),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_A_Q(ntryL,G1H2(319),59,0,G2H2(606),n2h2(347))
  call Hloop_AV_Q(ntryL,G1H4(470),ex4(:),G1H2(320),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_A_Q(ntryL,G1H2(320),59,0,G2H2(607),n2h2(348))
  call Hloop_AV_Q(ntryL,G1H4(474),ex3(:),G1H2(325),m3h2x2(:,656),heltab2x4(:,:,656))
  call Hloop_A_Q(ntryL,G1H2(325),47,0,G2H2(608),n2h2(349))
call HGT_OLR(G1H4(476),1,1,4)
call HGT_invQ_OLR(G1H4(476),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(476),-16,0,G2H4(387),n2h4(872))
  call Hloop_QV_A(ntryL,G2H4(387),ex5(:),G2H2(609),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_AV_Q(ntryL,G1H4(486),ex3(:),G1H2(326),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_A_Q(ntryL,G1H2(326),47,0,G2H2(610),n2h2(350))
  call Hloop_AV_Q(ntryL,G1H4(488),ex3(:),G1H2(331),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_A_Q(ntryL,G1H2(331),47,0,G2H2(611),n2h2(351))
  call Hloop_AV_Q(ntryL,G1H4(493),ex4(:),G1H2(332),m3h2x2(:,660),heltab2x4(:,:,660))
  call Hloop_A_Q(ntryL,G1H2(332),47,0,G2H2(612),n2h2(352))
call HGT_OLR(G1H4(494),1,1,4)
call HGT_invQ_OLR(G1H4(494),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(494),-16,0,G2H4(256),n2h4(873))
  call Hloop_QV_A(ntryL,G2H4(256),ex5(:),G2H2(613),m3h2x2(:,661),heltab2x4(:,:,661))
  call Hloop_AV_Q(ntryL,G1H4(505),ex4(:),G1H2(337),m3h2x2(:,662),heltab2x4(:,:,662))
  call Hloop_A_Q(ntryL,G1H2(337),47,0,G2H2(614),n2h2(353))
  call Hloop_AV_Q(ntryL,G1H4(506),ex4(:),G1H2(338),m3h2x2(:,663),heltab2x4(:,:,663))
  call Hloop_A_Q(ntryL,G1H2(338),47,0,G2H2(615),n2h2(354))
  call Hloop_AV_Q(ntryL,G1H4(510),ex5(:),G1H2(19),m3h2x2(:,664),heltab2x4(:,:,664))
  call Hloop_A_Q(ntryL,G1H2(19),59,0,G2H2(616),n2h2(355))
call HGT_OLR(G1H4(511),1,1,4)
call HGT_invQ_OLR(G1H4(511),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(511),-4,0,G2H4(185),n2h4(874))
  call Hloop_QV_A(ntryL,G2H4(185),ex3(:),G2H2(617),m3h2x2(:,665),heltab2x4(:,:,665))
  call Hloop_AV_Q(ntryL,G1H4(518),ex5(:),G1H2(20),m3h2x2(:,666),heltab2x4(:,:,666))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(618),n2h2(356))
  call Hloop_AV_Q(ntryL,G1H4(523),ex5(:),G1H2(25),m3h2x2(:,667),heltab2x4(:,:,667))
  call Hloop_A_Q(ntryL,G1H2(25),59,0,G2H2(619),n2h2(357))
  call Hloop_AV_Q(ntryL,G1H4(530),ex5(:),G1H2(26),m3h2x2(:,668),heltab2x4(:,:,668))
  call Hloop_A_Q(ntryL,G1H2(26),59,0,G2H2(620),n2h2(358))
call HGT_OLR(G1H4(535),1,1,4)
call HGT_invQ_OLR(G1H4(535),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(535),-4,0,G2H4(182),n2h4(875))
  call Hloop_QV_A(ntryL,G2H4(182),ex3(:),G2H2(621),m3h2x2(:,669),heltab2x4(:,:,669))
  call Hloop_AV_Q(ntryL,G1H4(547),ex5(:),G1H2(31),m3h2x2(:,670),heltab2x4(:,:,670))
  call Hloop_A_Q(ntryL,G1H2(31),59,0,G2H2(622),n2h2(359))
  call Hloop_AV_Q(ntryL,G1H4(548),ex5(:),G1H2(32),m3h2x2(:,671),heltab2x4(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(32),59,0,G2H2(623),n2h2(360))
  call Hloop_AV_Q(ntryL,G1H4(553),ex3(:),G1H2(37),m3h2x2(:,672),heltab2x4(:,:,672))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(624),n2h2(361))
call HGT_OLR(G1H4(554),1,1,4)
call HGT_invQ_OLR(G1H4(554),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(554),-8,0,G2H4(183),n2h4(876))
  call Hloop_QV_A(ntryL,G2H4(183),ex4(:),G2H2(625),m3h2x2(:,673),heltab2x4(:,:,673))
  call Hloop_AV_Q(ntryL,G1H4(593),ex3(:),G1H2(38),m3h2x2(:,674),heltab2x4(:,:,674))
  call Hloop_A_Q(ntryL,G1H2(38),55,0,G2H2(626),n2h2(362))
  call Hloop_AV_Q(ntryL,G1H4(594),ex3(:),G1H2(43),m3h2x2(:,675),heltab2x4(:,:,675))
  call Hloop_A_Q(ntryL,G1H2(43),55,0,G2H2(627),n2h2(363))
  call Hloop_AV_Q(ntryL,G1H4(23),ex5(:),G1H2(44),m3h2x2(:,676),heltab2x4(:,:,676))
  call Hloop_A_Q(ntryL,G1H2(44),55,0,G2H2(628),n2h2(364))
call HGT_OLR(G1H4(359),1,1,4)
call HGT_invQ_OLR(G1H4(359),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(359),-8,0,G2H4(388),n2h4(877))
  call Hloop_QV_A(ntryL,G2H4(388),ex4(:),G2H2(629),m3h2x2(:,677),heltab2x4(:,:,677))
  call Hloop_AV_Q(ntryL,G1H4(47),ex5(:),G1H2(49),m3h2x2(:,678),heltab2x4(:,:,678))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(630),n2h2(365))
  call Hloop_AV_Q(ntryL,G1H4(59),ex5(:),G1H2(50),m3h2x2(:,679),heltab2x4(:,:,679))
  call Hloop_A_Q(ntryL,G1H2(50),55,0,G2H2(631),n2h2(366))
  call Hloop_AV_Q(ntryL,G1H4(431),ex4(:),G1H2(55),m3h2x2(:,680),heltab2x4(:,:,680))
  call Hloop_A_Q(ntryL,G1H2(55),59,0,G2H2(632),n2h2(367))
call HGT_OLR(G1H4(71),1,1,4)
call HGT_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(71),-4,0,G2H4(394),n2h4(878))
  call Hloop_QV_A(ntryL,G2H4(394),ex3(:),G2H2(633),m3h2x2(:,681),heltab2x4(:,:,681))
  call Hloop_AV_Q(ntryL,G1H4(95),ex4(:),G1H2(56),m3h2x2(:,682),heltab2x4(:,:,682))
  call Hloop_A_Q(ntryL,G1H2(56),59,0,G2H2(634),n2h2(368))
  call Hloop_AV_Q(ntryL,G1H4(107),ex4(:),G1H2(61),m3h2x2(:,683),heltab2x4(:,:,683))
  call Hloop_A_Q(ntryL,G1H2(61),59,0,G2H2(635),n2h2(369))
  call Hloop_UV_W(ntryL,G1H4(119),53,ex4(:),8,G2H2(636),m3h2x2(:,684),heltab2x4(:,:,684))
call HGT_OLR(G1H4(131),1,1,4)
call HGT_invQ_OLR(G1H4(131),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(131),-2,0,G2H4(189),n2h4(879))
  call Hloop_QA_V(ntryL,G2H4(189),ex2(:),G2H2(637),m3h2x2(:,685),heltab2x4(:,:,685))
  call Hloop_UV_W(ntryL,G1H4(21),53,ex4(:),8,G2H2(638),m3h2x2(:,686),heltab2x4(:,:,686))
  call Hloop_UV_W(ntryL,G1H4(167),53,ex4(:),8,G2H2(639),m3h2x2(:,687),heltab2x4(:,:,687))
  call Hloop_VQ_A(ntryL,G1H4(179),ex1(:),G1H2(62),m3h2x2(:,688),heltab2x4(:,:,688))
  call Hloop_Q_A(ntryL,G1H2(62),59,0,G2H2(640),n2h2(370))
call HGT_OLR(G1H4(141),1,1,4)
call HGT_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(141),-4,0,G2H4(396),n2h4(880))
  call Hloop_AV_Q(ntryL,G2H4(396),ex3(:),G2H2(641),m3h2x2(:,689),heltab2x4(:,:,689))
  call Hloop_VQ_A(ntryL,G1H4(215),ex1(:),G1H2(67),m3h2x2(:,690),heltab2x4(:,:,690))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(642),n2h2(371))
  call Hloop_VQ_A(ntryL,G1H4(371),ex1(:),G1H2(68),m3h2x2(:,691),heltab2x4(:,:,691))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(643),n2h2(372))
  call Hloop_UV_W(ntryL,G1H4(227),54,ex4(:),8,G2H2(644),m3h2x2(:,692),heltab2x4(:,:,692))
call HGT_OLR(G1H4(213),1,1,4)
call HGT_invQ_OLR(G1H4(213),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(213),-1,0,G2H4(195),n2h4(881))
  call Hloop_AQ_V(ntryL,G2H4(195),ex1(:),G2H2(645),m3h2x2(:,693),heltab2x4(:,:,693))
  call Hloop_UV_W(ntryL,G1H4(57),54,ex4(:),8,G2H2(646),m3h2x2(:,694),heltab2x4(:,:,694))
  call Hloop_UV_W(ntryL,G1H4(251),54,ex4(:),8,G2H2(647),m3h2x2(:,695),heltab2x4(:,:,695))
  call Hloop_VQ_A(ntryL,G1H4(419),ex1(:),G1H2(73),m3h2x2(:,696),heltab2x4(:,:,696))
  call Hloop_Q_A(ntryL,G1H2(73),59,0,G2H2(648),n2h2(373))
call HGT_OLR(G1H4(263),1,1,4)
call HGT_invQ_OLR(G1H4(263),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(263),-4,0,G2H4(192),n2h4(882))
  call Hloop_AV_Q(ntryL,G2H4(192),ex3(:),G2H2(649),m3h2x2(:,697),heltab2x4(:,:,697))
  call Hloop_VQ_A(ntryL,G1H4(275),ex1(:),G1H2(74),m3h2x2(:,698),heltab2x4(:,:,698))
  call Hloop_Q_A(ntryL,G1H2(74),59,0,G2H2(650),n2h2(374))
  call Hloop_VQ_A(ntryL,G1H4(287),ex1(:),G1H2(79),m3h2x2(:,699),heltab2x4(:,:,699))
  call Hloop_Q_A(ntryL,G1H2(79),59,0,G2H2(651),n2h2(375))
  call Hloop_UV_W(ntryL,G1H4(201),45,ex5(:),16,G2H2(652),m3h2x2(:,700),heltab2x4(:,:,700))
call HGT_OLR(G1H4(299),1,1,4)
call HGT_invQ_OLR(G1H4(299),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(299),-2,0,G2H4(193),n2h4(883))
  call Hloop_QA_V(ntryL,G2H4(193),ex2(:),G2H2(653),m3h2x2(:,701),heltab2x4(:,:,701))
  call Hloop_UV_W(ntryL,G1H4(153),45,ex5(:),16,G2H2(654),m3h2x2(:,702),heltab2x4(:,:,702))
  call Hloop_UV_W(ntryL,G1H4(503),45,ex5(:),16,G2H2(655),m3h2x2(:,703),heltab2x4(:,:,703))
  call Hloop_UV_W(ntryL,G1H4(323),46,ex5(:),16,G2H2(656),m3h2x2(:,704),heltab2x4(:,:,704))
call HGT_OLR(G1H4(527),1,1,4)
call HGT_invQ_OLR(G1H4(527),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(527),-1,0,G2H4(397),n2h4(884))
  call Hloop_AQ_V(ntryL,G2H4(397),ex1(:),G2H2(657),m3h2x2(:,705),heltab2x4(:,:,705))
  call Hloop_UV_W(ntryL,G1H4(539),46,ex5(:),16,G2H2(658),m3h2x2(:,706),heltab2x4(:,:,706))
  call Hloop_UV_W(ntryL,G1H4(347),46,ex5(:),16,G2H2(659),m3h2x2(:,707),heltab2x4(:,:,707))
  call Hloop_VQ_A(ntryL,G1H4(126),ex1(:),G1H2(80),m3h2x2(:,708),heltab2x4(:,:,708))
  call Hloop_Q_A(ntryL,G1H2(80),59,0,G2H2(660),n2h2(376))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(122),-4,0,G2H4(408),n2h4(885))
  call Hloop_AV_Q(ntryL,G2H4(408),ex3(:),G2H2(661),m3h2x2(:,709),heltab2x4(:,:,709))
  call Hloop_VQ_A(ntryL,G1H4(383),ex1(:),G1H2(85),m3h2x2(:,710),heltab2x4(:,:,710))
  call Hloop_Q_A(ntryL,G1H2(85),59,0,G2H2(662),n2h2(377))
  call Hloop_VQ_A(ntryL,G1H4(429),ex1(:),G1H2(86),m3h2x2(:,711),heltab2x4(:,:,711))
  call Hloop_Q_A(ntryL,G1H2(86),59,0,G2H2(663),n2h2(378))
  call Hloop_UV_W(ntryL,G1H4(441),54,ex4(:),8,G2H2(664),m3h2x2(:,712),heltab2x4(:,:,712))
call HGT_OLR(G1H4(133),1,1,4)
call HGT_invQ_OLR(G1H4(133),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(133),-1,0,G2H4(199),n2h4(886))
  call Hloop_AQ_V(ntryL,G2H4(199),ex1(:),G2H2(665),m3h2x2(:,713),heltab2x4(:,:,713))
  call Hloop_UV_W(ntryL,G1H4(515),54,ex4(:),8,G2H2(666),m3h2x2(:,714),heltab2x4(:,:,714))
  call Hloop_UV_W(ntryL,G1H4(491),54,ex4(:),8,G2H2(667),m3h2x2(:,715),heltab2x4(:,:,715))
  call Hloop_UV_W(ntryL,G1H4(357),46,ex5(:),16,G2H2(668),m3h2x2(:,716),heltab2x4(:,:,716))
call HGT_OLR(G1H4(393),1,1,4)
call HGT_invQ_OLR(G1H4(393),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(393),-1,0,G2H4(410),n2h4(887))
  call Hloop_AQ_V(ntryL,G2H4(410),ex1(:),G2H2(669),m3h2x2(:,717),heltab2x4(:,:,717))
  call Hloop_UV_W(ntryL,G1H4(636),46,ex5(:),16,G2H2(670),m3h2x2(:,718),heltab2x4(:,:,718))
  call Hloop_UV_W(ntryL,G1H4(551),46,ex5(:),16,G2H2(671),m3h2x2(:,719),heltab2x4(:,:,719))
  call Hloop_VQ_A(ntryL,G1H4(195),ex1(:),G1H2(91),m3h2x2(:,720),heltab2x4(:,:,720))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(672),n2h2(379))
call HGT_OLR(G1H4(642),1,1,4)
call HGT_invQ_OLR(G1H4(642),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(642),-16,0,G2H4(246),n2h4(888))
  call Hloop_AV_Q(ntryL,G2H4(246),ex5(:),G2H2(673),m3h2x2(:,721),heltab2x4(:,:,721))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(92),m3h2x2(:,722),heltab2x4(:,:,722))
  call Hloop_Q_A(ntryL,G1H2(92),47,0,G2H2(674),n2h2(380))
  call Hloop_VQ_A(ntryL,G1H4(602),ex1(:),G1H2(97),m3h2x2(:,723),heltab2x4(:,:,723))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(675),n2h2(381))
  call Hloop_VQ_A(ntryL,G1H4(568),ex1(:),G1H2(98),m3h2x2(:,724),heltab2x4(:,:,724))
  call Hloop_Q_A(ntryL,G1H2(98),55,0,G2H2(676),n2h2(382))
call HGT_OLR(G1H4(183),1,1,4)
call HGT_invQ_OLR(G1H4(183),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(183),-8,0,G2H4(205),n2h4(889))
  call Hloop_AV_Q(ntryL,G2H4(205),ex4(:),G2H2(677),m3h2x2(:,725),heltab2x4(:,:,725))
  call Hloop_VQ_A(ntryL,G1H4(237),ex1(:),G1H2(103),m3h2x2(:,726),heltab2x4(:,:,726))
  call Hloop_Q_A(ntryL,G1H2(103),55,0,G2H2(678),n2h2(383))
  call Hloop_VQ_A(ntryL,G1H4(7),ex1(:),G1H2(104),m3h2x2(:,727),heltab2x4(:,:,727))
  call Hloop_Q_A(ntryL,G1H2(104),55,0,G2H2(679),n2h2(384))
  call Hloop_VA_Q(ntryL,G1H4(619),ex2(:),G1H2(109),m3h2x2(:,728),heltab2x4(:,:,728))
  call Hloop_A_Q(ntryL,G1H2(109),59,0,G2H2(680),n2h2(385))
call HGT_OLR(G1H4(585),1,1,4)
call HGT_invQ_OLR(G1H4(585),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(585),-4,0,G2H4(202),n2h4(890))
  call Hloop_QV_A(ntryL,G2H4(202),ex3(:),G2H2(681),m3h2x2(:,729),heltab2x4(:,:,729))
  call Hloop_VA_Q(ntryL,G1H4(591),ex2(:),G1H2(110),m3h2x2(:,730),heltab2x4(:,:,730))
  call Hloop_A_Q(ntryL,G1H2(110),59,0,G2H2(682),n2h2(386))
  call Hloop_VA_Q(ntryL,G1H4(225),ex2(:),G1H2(115),m3h2x2(:,731),heltab2x4(:,:,731))
  call Hloop_A_Q(ntryL,G1H2(115),59,0,G2H2(683),n2h2(387))
  call Hloop_UV_W(ntryL,G1H4(10),45,ex5(:),16,G2H2(684),m3h2x2(:,732),heltab2x4(:,:,732))
call HGT_OLR(G1H4(231),1,1,4)
call HGT_invQ_OLR(G1H4(231),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(231),-2,0,G2H4(203),n2h4(891))
  call Hloop_QA_V(ntryL,G2H4(203),ex2(:),G2H2(685),m3h2x2(:,733),heltab2x4(:,:,733))
  call Hloop_UV_W(ntryL,G1H4(279),45,ex5(:),16,G2H2(686),m3h2x2(:,734),heltab2x4(:,:,734))
  call Hloop_UV_W(ntryL,G1H4(261),45,ex5(:),16,G2H2(687),m3h2x2(:,735),heltab2x4(:,:,735))
  call Hloop_VA_Q(ntryL,G1H4(16),ex2(:),G1H2(116),m3h2x2(:,736),heltab2x4(:,:,736))
  call Hloop_A_Q(ntryL,G1H2(116),59,0,G2H2(688),n2h2(388))
call HGT_OLR(G1H4(267),1,1,4)
call HGT_invQ_OLR(G1H4(267),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(267),-4,0,G2H4(411),n2h4(892))
  call Hloop_QV_A(ntryL,G2H4(411),ex3(:),G2H2(689),m3h2x2(:,737),heltab2x4(:,:,737))
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(121),m3h2x2(:,738),heltab2x4(:,:,738))
  call Hloop_A_Q(ntryL,G1H2(121),59,0,G2H2(690),n2h2(389))
  call Hloop_VA_Q(ntryL,G1H4(33),ex2(:),G1H2(122),m3h2x2(:,739),heltab2x4(:,:,739))
  call Hloop_A_Q(ntryL,G1H2(122),59,0,G2H2(691),n2h2(390))
  call Hloop_VA_Q(ntryL,G1H4(41),ex2(:),G1H2(127),m3h2x2(:,740),heltab2x4(:,:,740))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(692),n2h2(391))
call HGT_OLR(G1H4(45),1,1,4)
call HGT_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(45),-16,0,G2H4(422),n2h4(893))
  call Hloop_QV_A(ntryL,G2H4(422),ex5(:),G2H2(693),m3h2x2(:,741),heltab2x4(:,:,741))
  call Hloop_VA_Q(ntryL,G1H4(70),ex2(:),G1H2(128),m3h2x2(:,742),heltab2x4(:,:,742))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(694),n2h2(392))
  call Hloop_VA_Q(ntryL,G1H4(58),ex2(:),G1H2(133),m3h2x2(:,743),heltab2x4(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(695),n2h2(393))
  call Hloop_UV_W(ntryL,G1H4(64),53,ex4(:),8,G2H2(696),m3h2x2(:,744),heltab2x4(:,:,744))
call HGT_OLR(G1H4(69),1,1,4)
call HGT_invQ_OLR(G1H4(69),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(69),-2,0,G2H4(209),n2h4(894))
  call Hloop_QA_V(ntryL,G2H4(209),ex2(:),G2H2(697),m3h2x2(:,745),heltab2x4(:,:,745))
  call Hloop_UV_W(ntryL,G1H4(82),53,ex4(:),8,G2H2(698),m3h2x2(:,746),heltab2x4(:,:,746))
  call Hloop_UV_W(ntryL,G1H4(89),53,ex4(:),8,G2H2(699),m3h2x2(:,747),heltab2x4(:,:,747))
  call Hloop_VA_Q(ntryL,G1H4(93),ex2(:),G1H2(134),m3h2x2(:,748),heltab2x4(:,:,748))
  call Hloop_A_Q(ntryL,G1H2(134),59,0,G2H2(700),n2h2(394))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-4,0,G2H4(424),n2h4(895))
  call Hloop_QV_A(ntryL,G2H4(424),ex3(:),G2H2(701),m3h2x2(:,749),heltab2x4(:,:,749))
  call Hloop_VA_Q(ntryL,G1H4(117),ex2(:),G1H2(139),m3h2x2(:,750),heltab2x4(:,:,750))
  call Hloop_A_Q(ntryL,G1H2(139),59,0,G2H2(702),n2h2(395))
  call Hloop_VA_Q(ntryL,G1H4(118),ex2(:),G1H2(140),m3h2x2(:,751),heltab2x4(:,:,751))
  call Hloop_A_Q(ntryL,G1H2(140),59,0,G2H2(703),n2h2(396))
  call Hloop_VA_Q(ntryL,G1H4(129),ex2(:),G1H2(145),m3h2x2(:,752),heltab2x4(:,:,752))
  call Hloop_A_Q(ntryL,G1H2(145),55,0,G2H2(704),n2h2(397))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(130),-8,0,G2H4(266),n2h4(896))
  call Hloop_QV_A(ntryL,G2H4(266),ex4(:),G2H2(705),m3h2x2(:,753),heltab2x4(:,:,753))
  call Hloop_VA_Q(ntryL,G1H4(148),ex2(:),G1H2(146),m3h2x2(:,754),heltab2x4(:,:,754))
  call Hloop_A_Q(ntryL,G1H2(146),55,0,G2H2(706),n2h2(398))
  call Hloop_VA_Q(ntryL,G1H4(149),ex2(:),G1H2(151),m3h2x2(:,755),heltab2x4(:,:,755))
  call Hloop_A_Q(ntryL,G1H2(151),55,0,G2H2(707),n2h2(399))
  call Hloop_QV_A(ntryL,G1H4(154),ex3(:),G1H2(152),m3h2x2(:,756),heltab2x4(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(152),61,0,G2H2(708),n2h2(400))
call HGT_raise_alpha_OLR(G1H4(161),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(161),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(161),ex2(:),G1H2(157),m3h2x2(:,757),heltab2x4(:,:,757))
  call Hloop_QV_A(ntryL,G1H4(190),ex3(:),G1H2(158),m3h2x2(:,758),heltab2x4(:,:,758))
  call Hloop_Q_A(ntryL,G1H2(158),61,0,G2H2(709),n2h2(401))
  call Hloop_QV_A(ntryL,G1H4(209),ex3(:),G1H2(163),m3h2x2(:,759),heltab2x4(:,:,759))
  call Hloop_Q_A(ntryL,G1H2(163),61,0,G2H2(710),n2h2(402))
call HGT_raise_alpha_OLR(G1H4(196),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(196),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(196),ex2(:),G1H2(164),m3h2x2(:,760),heltab2x4(:,:,760))
  call Hloop_QV_A(ntryL,G1H4(208),ex3(:),G1H2(169),m3h2x2(:,761),heltab2x4(:,:,761))
  call Hloop_Q_A(ntryL,G1H2(169),61,0,G2H2(711),n2h2(403))
call HGT_raise_alpha_OLR(G1H4(214),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(214),ex2(:),G1H2(170),m3h2x2(:,762),heltab2x4(:,:,762))
  call Hloop_QV_A(ntryL,G1H4(232),ex3(:),G1H2(175),m3h2x2(:,763),heltab2x4(:,:,763))
  call Hloop_Q_A(ntryL,G1H2(175),61,0,G2H2(712),n2h2(404))
  call Hloop_AV_Q(ntryL,G1H4(233),ex3(:),G1H2(176),m3h2x2(:,764),heltab2x4(:,:,764))
  call Hloop_A_Q(ntryL,G1H2(176),62,0,G2H2(713),n2h2(405))
call HGT_raise_alpha_OLR(G1H4(238),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(238),ex1(:),G1H2(181),m3h2x2(:,765),heltab2x4(:,:,765))
  call Hloop_AV_Q(ntryL,G1H4(262),ex3(:),G1H2(182),m3h2x2(:,766),heltab2x4(:,:,766))
  call Hloop_A_Q(ntryL,G1H2(182),62,0,G2H2(714),n2h2(406))
  call Hloop_AV_Q(ntryL,G1H4(281),ex3(:),G1H2(187),m3h2x2(:,767),heltab2x4(:,:,767))
  call Hloop_A_Q(ntryL,G1H2(187),62,0,G2H2(715),n2h2(407))
call HGT_raise_alpha_OLR(G1H4(268),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(268),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(268),ex1(:),G1H2(188),m3h2x2(:,768),heltab2x4(:,:,768))
  call Hloop_AV_Q(ntryL,G1H4(280),ex3(:),G1H2(193),m3h2x2(:,769),heltab2x4(:,:,769))
  call Hloop_A_Q(ntryL,G1H2(193),62,0,G2H2(716),n2h2(408))
call HGT_raise_alpha_OLR(G1H4(285),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(285),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(285),ex1(:),G1H2(194),m3h2x2(:,770),heltab2x4(:,:,770))
  call Hloop_AV_Q(ntryL,G1H4(297),ex3(:),G1H2(199),m3h2x2(:,771),heltab2x4(:,:,771))
  call Hloop_A_Q(ntryL,G1H2(199),62,0,G2H2(717),n2h2(409))
  call Hloop_AV_Q(ntryL,G1H4(298),ex3(:),G1H2(200),m3h2x2(:,772),heltab2x4(:,:,772))
  call Hloop_A_Q(ntryL,G1H2(200),62,0,G2H2(718),n2h2(410))
call HGT_raise_alpha_OLR(G1H4(304),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(304),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(304),ex1(:),G1H2(205),m3h2x2(:,773),heltab2x4(:,:,773))
  call Hloop_AV_Q(ntryL,G1H4(321),ex3(:),G1H2(206),m3h2x2(:,774),heltab2x4(:,:,774))
  call Hloop_A_Q(ntryL,G1H2(206),62,0,G2H2(719),n2h2(411))
  call Hloop_AV_Q(ntryL,G1H4(334),ex3(:),G1H2(211),m3h2x2(:,775),heltab2x4(:,:,775))
  call Hloop_A_Q(ntryL,G1H2(211),62,0,G2H2(720),n2h2(412))
call HGT_raise_alpha_OLR(G1H4(322),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(322),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(322),ex1(:),G1H2(212),m3h2x2(:,776),heltab2x4(:,:,776))
  call Hloop_AV_Q(ntryL,G1H4(333),ex3(:),G1H2(217),m3h2x2(:,777),heltab2x4(:,:,777))
  call Hloop_A_Q(ntryL,G1H2(217),62,0,G2H2(721),n2h2(413))
call HGT_raise_alpha_OLR(G1H4(340),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(340),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(340),ex1(:),G1H2(218),m3h2x2(:,778),heltab2x4(:,:,778))
  call Hloop_AV_Q(ntryL,G1H4(346),ex3(:),G1H2(223),m3h2x2(:,779),heltab2x4(:,:,779))
  call Hloop_A_Q(ntryL,G1H2(223),62,0,G2H2(722),n2h2(414))
  call Hloop_AV_Q(ntryL,G1H4(352),ex3(:),G1H2(224),m3h2x2(:,780),heltab2x4(:,:,780))
  call Hloop_A_Q(ntryL,G1H2(224),62,0,G2H2(723),n2h2(415))
call HGT_raise_alpha_OLR(G1H4(353),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(353),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(353),ex1(:),G1H2(229),m3h2x2(:,781),heltab2x4(:,:,781))
  call Hloop_AV_Q(ntryL,G1H4(389),ex3(:),G1H2(230),m3h2x2(:,782),heltab2x4(:,:,782))
  call Hloop_A_Q(ntryL,G1H2(230),62,0,G2H2(724),n2h2(416))
  call Hloop_AV_Q(ntryL,G1H4(418),ex3(:),G1H2(235),m3h2x2(:,783),heltab2x4(:,:,783))
  call Hloop_A_Q(ntryL,G1H2(235),62,0,G2H2(725),n2h2(417))
call HGT_raise_alpha_OLR(G1H4(394),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(394),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(394),ex1(:),G1H2(236),m3h2x2(:,784),heltab2x4(:,:,784))
  call Hloop_AV_Q(ntryL,G1H4(417),ex3(:),G1H2(241),m3h2x2(:,785),heltab2x4(:,:,785))
  call Hloop_A_Q(ntryL,G1H2(241),62,0,G2H2(726),n2h2(418))
call HGT_raise_alpha_OLR(G1H4(430),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(430),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(430),ex1(:),G1H2(242),m3h2x2(:,786),heltab2x4(:,:,786))
  call Hloop_AV_Q(ntryL,G1H4(454),ex3(:),G1H2(247),m3h2x2(:,787),heltab2x4(:,:,787))
  call Hloop_A_Q(ntryL,G1H2(247),62,0,G2H2(727),n2h2(419))
  call Hloop_QV_A(ntryL,G1H4(465),ex4(:),G1H2(248),m3h2x2(:,788),heltab2x4(:,:,788))
  call Hloop_Q_A(ntryL,G1H2(248),61,0,G2H2(728),n2h2(420))
call HGT_raise_alpha_OLR(G1H4(466),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(466),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(466),ex2(:),G1H2(253),m3h2x2(:,789),heltab2x4(:,:,789))
  call Hloop_QV_A(ntryL,G1H4(501),ex4(:),G1H2(254),m3h2x2(:,790),heltab2x4(:,:,790))
  call Hloop_Q_A(ntryL,G1H2(254),61,0,G2H2(729),n2h2(421))
  call Hloop_QV_A(ntryL,G1H4(526),ex4(:),G1H2(259),m3h2x2(:,791),heltab2x4(:,:,791))
  call Hloop_Q_A(ntryL,G1H2(259),61,0,G2H2(730),n2h2(422))
call HGT_raise_alpha_OLR(G1H4(502),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(502),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(502),ex2(:),G1H2(260),m3h2x2(:,792),heltab2x4(:,:,792))
  call Hloop_QV_A(ntryL,G1H4(525),ex4(:),G1H2(265),m3h2x2(:,793),heltab2x4(:,:,793))
  call Hloop_Q_A(ntryL,G1H2(265),61,0,G2H2(731),n2h2(423))
call HGT_raise_alpha_OLR(G1H4(537),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(537),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(537),ex2(:),G1H2(266),m3h2x2(:,794),heltab2x4(:,:,794))
  call Hloop_QV_A(ntryL,G1H4(550),ex4(:),G1H2(271),m3h2x2(:,795),heltab2x4(:,:,795))
  call Hloop_Q_A(ntryL,G1H2(271),61,0,G2H2(732),n2h2(424))
  call Hloop_QV_A(ntryL,G1H4(555),ex5(:),G1H2(272),m3h2x2(:,796),heltab2x4(:,:,796))
  call Hloop_Q_A(ntryL,G1H2(272),61,0,G2H2(733),n2h2(425))
call HGT_raise_alpha_OLR(G1H4(556),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(556),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(556),ex2(:),G1H2(277),m3h2x2(:,797),heltab2x4(:,:,797))
  call Hloop_QV_A(ntryL,G1H4(573),ex5(:),G1H2(278),m3h2x2(:,798),heltab2x4(:,:,798))
  call Hloop_Q_A(ntryL,G1H2(278),61,0,G2H2(734),n2h2(426))
  call Hloop_QV_A(ntryL,G1H4(590),ex5(:),G1H2(283),m3h2x2(:,799),heltab2x4(:,:,799))
  call Hloop_Q_A(ntryL,G1H2(283),61,0,G2H2(735),n2h2(427))
call HGT_raise_alpha_OLR(G1H4(580),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(580),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(580),ex2(:),G1H2(284),m3h2x2(:,800),heltab2x4(:,:,800))
  call Hloop_QV_A(ntryL,G1H4(589),ex5(:),G1H2(289),m3h2x2(:,801),heltab2x4(:,:,801))
  call Hloop_Q_A(ntryL,G1H2(289),61,0,G2H2(736),n2h2(428))
call HGT_raise_alpha_OLR(G1H4(597),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(597),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(597),ex2(:),G1H2(290),m3h2x2(:,802),heltab2x4(:,:,802))
  call Hloop_QV_A(ntryL,G1H4(606),ex5(:),G1H2(295),m3h2x2(:,803),heltab2x4(:,:,803))
  call Hloop_Q_A(ntryL,G1H2(295),61,0,G2H2(737),n2h2(429))
  call Hloop_QV_A(ntryL,G1H4(607),ex5(:),G1H2(296),m3h2x2(:,804),heltab2x4(:,:,804))
  call Hloop_Q_A(ntryL,G1H2(296),55,0,G2H2(738),n2h2(430))
call HGT_OLR(G1H4(617),1,1,4)
call HGT_invQ_OLR(G1H4(617),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(617),-8,0,G2H4(215),n2h4(915))
  call Hloop_AV_Q(ntryL,G2H4(215),ex4(:),G2H2(739),m3h2x2(:,805),heltab2x4(:,:,805))
  call Hloop_QV_A(ntryL,G1H4(624),ex5(:),G1H2(301),m3h2x2(:,806),heltab2x4(:,:,806))
  call Hloop_Q_A(ntryL,G1H2(301),55,0,G2H2(740),n2h2(431))
  call Hloop_QV_A(ntryL,G1H4(634),ex5(:),G1H2(302),m3h2x2(:,807),heltab2x4(:,:,807))
  call Hloop_Q_A(ntryL,G1H2(302),55,0,G2H2(741),n2h2(432))
  call Hloop_QV_A(ntryL,G1H4(635),ex4(:),G1H2(307),m3h2x2(:,808),heltab2x4(:,:,808))
  call Hloop_Q_A(ntryL,G1H2(307),61,0,G2H2(742),n2h2(433))
call HGT_raise_alpha_OLR(G1H4(640),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(640),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(640),ex2(:),G1H2(308),m3h2x2(:,809),heltab2x4(:,:,809))
  call Hloop_QV_A(ntryL,G1H4(2),ex4(:),G1H2(313),m3h2x2(:,810),heltab2x4(:,:,810))
  call Hloop_Q_A(ntryL,G1H2(313),61,0,G2H2(743),n2h2(434))
  call Hloop_QV_A(ntryL,G1H4(656),ex4(:),G1H2(314),m3h2x2(:,811),heltab2x4(:,:,811))
  call Hloop_Q_A(ntryL,G1H2(314),61,0,G2H2(744),n2h2(435))
call HGT_raise_alpha_OLR(G1H4(652),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(652),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(652),ex2(:),G1H2(319),m3h2x2(:,812),heltab2x4(:,:,812))
  call Hloop_QV_A(ntryL,G1H4(655),ex4(:),G1H2(320),m3h2x2(:,813),heltab2x4(:,:,813))
  call Hloop_Q_A(ntryL,G1H2(320),61,0,G2H2(745),n2h2(436))
call HGT_raise_alpha_OLR(G1H4(657),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(657),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(657),ex2(:),G1H2(325),m3h2x2(:,814),heltab2x4(:,:,814))
  call Hloop_QV_A(ntryL,G1H4(660),ex4(:),G1H2(326),m3h2x2(:,815),heltab2x4(:,:,815))
  call Hloop_Q_A(ntryL,G1H2(326),61,0,G2H2(746),n2h2(437))
  call Hloop_QV_A(ntryL,G1H4(3),ex4(:),G1H2(331),m3h2x2(:,816),heltab2x4(:,:,816))
  call Hloop_Q_A(ntryL,G1H2(331),47,0,G2H2(747),n2h2(438))
call HGT_OLR(G1H4(661),1,1,4)
call HGT_invQ_OLR(G1H4(661),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(661),-16,0,G2H4(212),n2h4(919))
  call Hloop_AV_Q(ntryL,G2H4(212),ex5(:),G2H2(748),m3h2x2(:,817),heltab2x4(:,:,817))
  call Hloop_QV_A(ntryL,G1H4(664),ex4(:),G1H2(332),m3h2x2(:,818),heltab2x4(:,:,818))
  call Hloop_Q_A(ntryL,G1H2(332),47,0,G2H2(749),n2h2(439))
  call Hloop_QV_A(ntryL,G1H4(665),ex4(:),G1H2(337),m3h2x2(:,819),heltab2x4(:,:,819))
  call Hloop_Q_A(ntryL,G1H2(337),47,0,G2H2(750),n2h2(440))
  call Hloop_QV_A(ntryL,G1H4(666),ex5(:),G1H2(338),m3h2x2(:,820),heltab2x4(:,:,820))
  call Hloop_Q_A(ntryL,G1H2(338),61,0,G2H2(751),n2h2(441))
call HGT_raise_alpha_OLR(G1H4(667),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(667),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(667),ex2(:),G1H2(19),m3h2x2(:,821),heltab2x4(:,:,821))
  call Hloop_QV_A(ntryL,G1H4(5),ex5(:),G1H2(20),m3h2x2(:,822),heltab2x4(:,:,822))
  call Hloop_Q_A(ntryL,G1H2(20),61,0,G2H2(752),n2h2(442))
  call Hloop_QV_A(ntryL,G1H4(676),ex5(:),G1H2(25),m3h2x2(:,823),heltab2x4(:,:,823))
  call Hloop_Q_A(ntryL,G1H2(25),61,0,G2H2(753),n2h2(443))
call HGT_raise_alpha_OLR(G1H4(672),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(672),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(672),ex2(:),G1H2(26),m3h2x2(:,824),heltab2x4(:,:,824))
  call Hloop_QV_A(ntryL,G1H4(675),ex5(:),G1H2(31),m3h2x2(:,825),heltab2x4(:,:,825))
  call Hloop_Q_A(ntryL,G1H2(31),61,0,G2H2(754),n2h2(444))
call HGT_raise_alpha_OLR(G1H4(677),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(677),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(677),ex2(:),G1H2(32),m3h2x2(:,826),heltab2x4(:,:,826))
  call Hloop_QV_A(ntryL,G1H4(680),ex5(:),G1H2(37),m3h2x2(:,827),heltab2x4(:,:,827))
  call Hloop_Q_A(ntryL,G1H2(37),61,0,G2H2(755),n2h2(445))
  call Hloop_AV_Q(ntryL,G1H4(6),ex4(:),G1H2(38),m3h2x2(:,828),heltab2x4(:,:,828))
  call Hloop_A_Q(ntryL,G1H2(38),62,0,G2H2(756),n2h2(446))
call HGT_raise_alpha_OLR(G1H4(681),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(681),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(681),ex1(:),G1H2(43),m3h2x2(:,829),heltab2x4(:,:,829))
  call Hloop_AV_Q(ntryL,G1H4(686),ex4(:),G1H2(44),m3h2x2(:,830),heltab2x4(:,:,830))
  call Hloop_A_Q(ntryL,G1H2(44),62,0,G2H2(757),n2h2(447))
  call Hloop_AV_Q(ntryL,G1H4(691),ex4(:),G1H2(49),m3h2x2(:,831),heltab2x4(:,:,831))
  call Hloop_A_Q(ntryL,G1H2(49),62,0,G2H2(758),n2h2(448))
call HGT_raise_alpha_OLR(G1H4(687),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(687),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(687),ex1(:),G1H2(50),m3h2x2(:,832),heltab2x4(:,:,832))
  call Hloop_AV_Q(ntryL,G1H4(690),ex4(:),G1H2(55),m3h2x2(:,833),heltab2x4(:,:,833))
  call Hloop_A_Q(ntryL,G1H2(55),62,0,G2H2(759),n2h2(449))
call HGT_raise_alpha_OLR(G1H4(692),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(692),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(692),ex1(:),G1H2(56),m3h2x2(:,834),heltab2x4(:,:,834))
  call Hloop_AV_Q(ntryL,G1H4(695),ex4(:),G1H2(61),m3h2x2(:,835),heltab2x4(:,:,835))
  call Hloop_A_Q(ntryL,G1H2(61),62,0,G2H2(760),n2h2(450))
  call Hloop_AV_Q(ntryL,G1H4(696),ex5(:),G1H2(62),m3h2x2(:,836),heltab2x4(:,:,836))
  call Hloop_A_Q(ntryL,G1H2(62),62,0,G2H2(761),n2h2(451))
call HGT_raise_alpha_OLR(G1H4(697),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(697),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(697),ex1(:),G1H2(67),m3h2x2(:,837),heltab2x4(:,:,837))
  call Hloop_AV_Q(ntryL,G1H4(702),ex5(:),G1H2(68),m3h2x2(:,838),heltab2x4(:,:,838))
  call Hloop_A_Q(ntryL,G1H2(68),62,0,G2H2(762),n2h2(452))
  call Hloop_AV_Q(ntryL,G1H4(707),ex5(:),G1H2(73),m3h2x2(:,839),heltab2x4(:,:,839))
  call Hloop_A_Q(ntryL,G1H2(73),62,0,G2H2(763),n2h2(453))
call HGT_raise_alpha_OLR(G1H4(703),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(703),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(703),ex1(:),G1H2(74),m3h2x2(:,840),heltab2x4(:,:,840))
  call Hloop_AV_Q(ntryL,G1H4(706),ex5(:),G1H2(79),m3h2x2(:,841),heltab2x4(:,:,841))
  call Hloop_A_Q(ntryL,G1H2(79),62,0,G2H2(764),n2h2(454))
call HGT_raise_alpha_OLR(G1H4(708),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(708),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(708),ex1(:),G1H2(80),m3h2x2(:,842),heltab2x4(:,:,842))
  call Hloop_AV_Q(ntryL,G1H4(711),ex5(:),G1H2(85),m3h2x2(:,843),heltab2x4(:,:,843))
  call Hloop_A_Q(ntryL,G1H2(85),62,0,G2H2(765),n2h2(455))
  call Hloop_QV_A(ntryL,G1H4(712),ex3(:),G1H2(86),m3h2x2(:,844),heltab2x4(:,:,844))
  call Hloop_Q_A(ntryL,G1H2(86),61,0,G2H2(766),n2h2(456))
call HGT_raise_alpha_OLR(G1H4(713),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(713),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(713),ex2(:),G1H2(91),m3h2x2(:,845),heltab2x4(:,:,845))
  call Hloop_QV_A(ntryL,G1H4(718),ex3(:),G1H2(92),m3h2x2(:,846),heltab2x4(:,:,846))
  call Hloop_Q_A(ntryL,G1H2(92),61,0,G2H2(767),n2h2(457))
  call Hloop_QV_A(ntryL,G1H4(723),ex3(:),G1H2(97),m3h2x2(:,847),heltab2x4(:,:,847))
  call Hloop_Q_A(ntryL,G1H2(97),61,0,G2H2(768),n2h2(458))
call HGT_raise_alpha_OLR(G1H4(719),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(719),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(719),ex2(:),G1H2(98),m3h2x2(:,848),heltab2x4(:,:,848))
  call Hloop_QV_A(ntryL,G1H4(722),ex3(:),G1H2(103),m3h2x2(:,849),heltab2x4(:,:,849))
  call Hloop_Q_A(ntryL,G1H2(103),61,0,G2H2(769),n2h2(459))
call HGT_raise_alpha_OLR(G1H4(724),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(724),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(724),ex2(:),G1H2(104),m3h2x2(:,850),heltab2x4(:,:,850))
  call Hloop_QV_A(ntryL,G1H4(727),ex3(:),G1H2(109),m3h2x2(:,851),heltab2x4(:,:,851))
  call Hloop_Q_A(ntryL,G1H2(109),61,0,G2H2(770),n2h2(460))
  call Hloop_QV_A(ntryL,G1H4(728),ex5(:),G1H2(110),m3h2x2(:,852),heltab2x4(:,:,852))
  call Hloop_Q_A(ntryL,G1H2(110),59,0,G2H2(771),n2h2(461))
call HGT_OLR(G1H4(729),1,1,4)
call HGT_invQ_OLR(G1H4(729),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(729),-4,0,G2H4(213),n2h4(932))
  call Hloop_AV_Q(ntryL,G2H4(213),ex3(:),G2H2(772),m3h2x2(:,853),heltab2x4(:,:,853))
  call Hloop_QV_A(ntryL,G1H4(732),ex5(:),G1H2(115),m3h2x2(:,854),heltab2x4(:,:,854))
  call Hloop_Q_A(ntryL,G1H2(115),59,0,G2H2(773),n2h2(462))
  call Hloop_QV_A(ntryL,G1H4(733),ex5(:),G1H2(116),m3h2x2(:,855),heltab2x4(:,:,855))
  call Hloop_Q_A(ntryL,G1H2(116),59,0,G2H2(774),n2h2(463))
  call Hloop_QV_A(ntryL,G1H4(734),ex3(:),G1H2(121),m3h2x2(:,856),heltab2x4(:,:,856))
  call Hloop_Q_A(ntryL,G1H2(121),61,0,G2H2(775),n2h2(464))
call HGT_raise_alpha_OLR(G1H4(735),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(735),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(735),ex2(:),G1H2(122),m3h2x2(:,857),heltab2x4(:,:,857))
  call Hloop_QV_A(ntryL,G1H4(8),ex3(:),G1H2(127),m3h2x2(:,858),heltab2x4(:,:,858))
  call Hloop_Q_A(ntryL,G1H2(127),61,0,G2H2(776),n2h2(465))
  call Hloop_QV_A(ntryL,G1H4(744),ex3(:),G1H2(128),m3h2x2(:,859),heltab2x4(:,:,859))
  call Hloop_Q_A(ntryL,G1H2(128),61,0,G2H2(777),n2h2(466))
call HGT_raise_alpha_OLR(G1H4(740),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(740),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(740),ex2(:),G1H2(133),m3h2x2(:,860),heltab2x4(:,:,860))
  call Hloop_QV_A(ntryL,G1H4(743),ex3(:),G1H2(134),m3h2x2(:,861),heltab2x4(:,:,861))
  call Hloop_Q_A(ntryL,G1H2(134),61,0,G2H2(778),n2h2(467))
call HGT_raise_alpha_OLR(G1H4(745),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(745),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(745),ex2(:),G1H2(139),m3h2x2(:,862),heltab2x4(:,:,862))
  call Hloop_QV_A(ntryL,G1H4(748),ex3(:),G1H2(140),m3h2x2(:,863),heltab2x4(:,:,863))
  call Hloop_Q_A(ntryL,G1H2(140),61,0,G2H2(779),n2h2(468))
  call Hloop_QV_A(ntryL,G1H4(9),ex3(:),G1H2(145),m3h2x2(:,864),heltab2x4(:,:,864))
  call Hloop_Q_A(ntryL,G1H2(145),47,0,G2H2(780),n2h2(469))
call HGT_OLR(G1H4(749),1,1,4)
call HGT_invQ_OLR(G1H4(749),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(749),-16,0,G2H4(425),n2h4(936))
  call Hloop_AV_Q(ntryL,G2H4(425),ex5(:),G2H2(781),m3h2x2(:,865),heltab2x4(:,:,865))
  call Hloop_QV_A(ntryL,G1H4(752),ex3(:),G1H2(146),m3h2x2(:,866),heltab2x4(:,:,866))
  call Hloop_Q_A(ntryL,G1H2(146),47,0,G2H2(782),n2h2(470))
  call Hloop_QV_A(ntryL,G1H4(753),ex3(:),G1H2(151),m3h2x2(:,867),heltab2x4(:,:,867))
  call Hloop_Q_A(ntryL,G1H2(151),47,0,G2H2(783),n2h2(471))
  call Hloop_QV_A(ntryL,G1H4(11),ex3(:),G1H2(152),m3h2x2(:,868),heltab2x4(:,:,868))
  call Hloop_Q_A(ntryL,G1H2(152),61,0,G2H2(784),n2h2(472))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(158),m3h2x2(:,869),heltab2x4(:,:,869))
  call Hloop_QV_A(ntryL,G1H4(758),ex3(:),G1H2(163),m3h2x2(:,870),heltab2x4(:,:,870))
  call Hloop_Q_A(ntryL,G1H2(163),61,0,G2H2(785),n2h2(473))
  call Hloop_QV_A(ntryL,G1H4(763),ex3(:),G1H2(169),m3h2x2(:,871),heltab2x4(:,:,871))
  call Hloop_Q_A(ntryL,G1H2(169),61,0,G2H2(786),n2h2(474))
call HGT_raise_alpha_OLR(G1H4(759),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(759),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(759),ex2(:),G1H2(175),m3h2x2(:,872),heltab2x4(:,:,872))
  call Hloop_QV_A(ntryL,G1H4(762),ex3(:),G1H2(176),m3h2x2(:,873),heltab2x4(:,:,873))
  call Hloop_Q_A(ntryL,G1H2(176),61,0,G2H2(787),n2h2(475))
call HGT_raise_alpha_OLR(G1H4(764),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(764),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(764),ex2(:),G1H2(182),m3h2x2(:,874),heltab2x4(:,:,874))
  call Hloop_QV_A(ntryL,G1H4(767),ex3(:),G1H2(187),m3h2x2(:,875),heltab2x4(:,:,875))
  call Hloop_Q_A(ntryL,G1H2(187),61,0,G2H2(788),n2h2(476))
  call Hloop_QV_A(ntryL,G1H4(768),ex4(:),G1H2(193),m3h2x2(:,876),heltab2x4(:,:,876))
  call Hloop_Q_A(ntryL,G1H2(193),59,0,G2H2(789),n2h2(477))
call HGT_OLR(G1H4(769),1,1,4)
call HGT_invQ_OLR(G1H4(769),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(769),-4,0,G2H4(431),n2h4(940))
  call Hloop_AV_Q(ntryL,G2H4(431),ex3(:),G2H2(790),m3h2x2(:,877),heltab2x4(:,:,877))
  call Hloop_QV_A(ntryL,G1H4(772),ex4(:),G1H2(199),m3h2x2(:,878),heltab2x4(:,:,878))
  call Hloop_Q_A(ntryL,G1H2(199),59,0,G2H2(791),n2h2(478))
  call Hloop_QV_A(ntryL,G1H4(773),ex4(:),G1H2(200),m3h2x2(:,879),heltab2x4(:,:,879))
  call Hloop_Q_A(ntryL,G1H2(200),59,0,G2H2(792),n2h2(479))
  call Hloop_QV_A(ntryL,G1H4(14),ex3(:),G1H2(206),m3h2x2(:,880),heltab2x4(:,:,880))
  call Hloop_Q_A(ntryL,G1H2(206),55,0,G2H2(793),n2h2(480))
call HGT_OLR(G1H4(15),1,1,4)
call HGT_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(15),-8,0,G2H4(219),n2h4(941))
  call Hloop_AV_Q(ntryL,G2H4(219),ex4(:),G2H2(794),m3h2x2(:,881),heltab2x4(:,:,881))
  call Hloop_QV_A(ntryL,G1H4(776),ex3(:),G1H2(211),m3h2x2(:,882),heltab2x4(:,:,882))
  call Hloop_Q_A(ntryL,G1H2(211),55,0,G2H2(795),n2h2(481))
  call Hloop_QV_A(ntryL,G1H4(777),ex3(:),G1H2(217),m3h2x2(:,883),heltab2x4(:,:,883))
  call Hloop_Q_A(ntryL,G1H2(217),55,0,G2H2(796),n2h2(482))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(223),m3h2x2(:,884),heltab2x4(:,:,884))
  call Hloop_A_Q(ntryL,G1H2(223),47,0,G2H2(797),n2h2(483))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-16,0,G2H4(433),n2h4(942))
  call Hloop_QV_A(ntryL,G2H4(433),ex5(:),G2H2(798),m3h2x2(:,885),heltab2x4(:,:,885))
  call Hloop_VA_Q(ntryL,G1H4(780),ex2(:),G1H2(224),m3h2x2(:,886),heltab2x4(:,:,886))
  call Hloop_A_Q(ntryL,G1H2(224),47,0,G2H2(799),n2h2(484))
  call Hloop_VA_Q(ntryL,G1H4(781),ex2(:),G1H2(230),m3h2x2(:,887),heltab2x4(:,:,887))
  call Hloop_A_Q(ntryL,G1H2(230),47,0,G2H2(800),n2h2(485))
  call Hloop_VA_Q(ntryL,G1H4(27),ex2(:),G1H2(235),m3h2x2(:,888),heltab2x4(:,:,888))
  call Hloop_A_Q(ntryL,G1H2(235),47,0,G2H2(801),n2h2(486))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(40),-16,0,G2H4(290),n2h4(943))
  call Hloop_QV_A(ntryL,G2H4(290),ex5(:),G2H2(802),m3h2x2(:,889),heltab2x4(:,:,889))
  call Hloop_VA_Q(ntryL,G1H4(783),ex2(:),G1H2(241),m3h2x2(:,890),heltab2x4(:,:,890))
  call Hloop_A_Q(ntryL,G1H2(241),47,0,G2H2(803),n2h2(487))
  call Hloop_VA_Q(ntryL,G1H4(784),ex2(:),G1H2(247),m3h2x2(:,891),heltab2x4(:,:,891))
  call Hloop_A_Q(ntryL,G1H2(247),47,0,G2H2(804),n2h2(488))
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(248),m3h2x2(:,892),heltab2x4(:,:,892))
  call Hloop_Q_A(ntryL,G1H2(248),55,0,G2H2(805),n2h2(489))
call HGT_OLR(G1H4(365),1,1,4)
call HGT_invQ_OLR(G1H4(365),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(365),-8,0,G2H4(225),n2h4(944))
  call Hloop_AV_Q(ntryL,G2H4(225),ex4(:),G2H2(806),m3h2x2(:,893),heltab2x4(:,:,893))
  call Hloop_VQ_A(ntryL,G1H4(787),ex1(:),G1H2(254),m3h2x2(:,894),heltab2x4(:,:,894))
  call Hloop_Q_A(ntryL,G1H2(254),55,0,G2H2(807),n2h2(490))
  call Hloop_VQ_A(ntryL,G1H4(788),ex1(:),G1H2(259),m3h2x2(:,895),heltab2x4(:,:,895))
  call Hloop_Q_A(ntryL,G1H2(259),55,0,G2H2(808),n2h2(491))
  call Hloop_VQ_A(ntryL,G1H4(789),ex1(:),G1H2(265),m3h2x2(:,896),heltab2x4(:,:,896))
  call Hloop_Q_A(ntryL,G1H2(265),55,0,G2H2(809),n2h2(492))
call HGT_OLR(G1H4(790),1,1,4)
call HGT_invQ_OLR(G1H4(790),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(790),-8,0,G2H4(222),n2h4(945))
  call Hloop_AV_Q(ntryL,G2H4(222),ex4(:),G2H2(810),m3h2x2(:,897),heltab2x4(:,:,897))
  call Hloop_VQ_A(ntryL,G1H4(793),ex1(:),G1H2(271),m3h2x2(:,898),heltab2x4(:,:,898))
  call Hloop_Q_A(ntryL,G1H2(271),55,0,G2H2(811),n2h2(493))
  call Hloop_VQ_A(ntryL,G1H4(794),ex1(:),G1H2(272),m3h2x2(:,899),heltab2x4(:,:,899))
  call Hloop_Q_A(ntryL,G1H2(272),55,0,G2H2(812),n2h2(494))
  call Hloop_VQ_A(ntryL,G1H4(51),ex1(:),G1H2(278),m3h2x2(:,900),heltab2x4(:,:,900))
  call Hloop_Q_A(ntryL,G1H2(278),47,0,G2H2(813),n2h2(495))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-16,0,G2H4(223),n2h4(946))
  call Hloop_AV_Q(ntryL,G2H4(223),ex5(:),G2H2(814),m3h2x2(:,901),heltab2x4(:,:,901))
  call Hloop_VQ_A(ntryL,G1H4(796),ex1(:),G1H2(283),m3h2x2(:,902),heltab2x4(:,:,902))
  call Hloop_Q_A(ntryL,G1H2(283),47,0,G2H2(815),n2h2(496))
  call Hloop_VQ_A(ntryL,G1H4(797),ex1(:),G1H2(289),m3h2x2(:,903),heltab2x4(:,:,903))
  call Hloop_Q_A(ntryL,G1H2(289),47,0,G2H2(816),n2h2(497))
  call Hloop_VQ_A(ntryL,G1H4(63),ex1(:),G1H2(295),m3h2x2(:,904),heltab2x4(:,:,904))
  call Hloop_Q_A(ntryL,G1H2(295),47,0,G2H2(817),n2h2(498))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(76),-16,0,G2H4(434),n2h4(947))
  call Hloop_AV_Q(ntryL,G2H4(434),ex5(:),G2H2(818),m3h2x2(:,905),heltab2x4(:,:,905))
  call Hloop_VQ_A(ntryL,G1H4(799),ex1(:),G1H2(296),m3h2x2(:,906),heltab2x4(:,:,906))
  call Hloop_Q_A(ntryL,G1H2(296),47,0,G2H2(819),n2h2(499))
  call Hloop_VQ_A(ntryL,G1H4(800),ex1(:),G1H2(301),m3h2x2(:,907),heltab2x4(:,:,907))
  call Hloop_Q_A(ntryL,G1H2(301),47,0,G2H2(820),n2h2(500))
  call Hloop_VA_Q(ntryL,G1H4(75),ex2(:),G1H2(302),m3h2x2(:,908),heltab2x4(:,:,908))
  call Hloop_A_Q(ntryL,G1H2(302),55,0,G2H2(821),n2h2(501))
call HGT_OLR(G1H4(437),1,1,4)
call HGT_invQ_OLR(G1H4(437),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(437),-8,0,G2H4(228),n2h4(948))
  call Hloop_QV_A(ntryL,G2H4(228),ex4(:),G2H2(822),m3h2x2(:,909),heltab2x4(:,:,909))
  call Hloop_VA_Q(ntryL,G1H4(803),ex2(:),G1H2(307),m3h2x2(:,910),heltab2x4(:,:,910))
  call Hloop_A_Q(ntryL,G1H2(307),55,0,G2H2(823),n2h2(502))
  call Hloop_VA_Q(ntryL,G1H4(804),ex2(:),G1H2(313),m3h2x2(:,911),heltab2x4(:,:,911))
  call Hloop_A_Q(ntryL,G1H2(313),55,0,G2H2(824),n2h2(503))
  call Hloop_VA_Q(ntryL,G1H4(805),ex2(:),G1H2(314),m3h2x2(:,912),heltab2x4(:,:,912))
  call Hloop_A_Q(ntryL,G1H2(314),55,0,G2H2(825),n2h2(504))
call HGT_OLR(G1H4(806),1,1,4)
call HGT_invQ_OLR(G1H4(806),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(806),-8,0,G2H4(305),n2h4(949))
  call Hloop_QV_A(ntryL,G2H4(305),ex4(:),G2H2(826),m3h2x2(:,913),heltab2x4(:,:,913))
  call Hloop_VA_Q(ntryL,G1H4(809),ex2(:),G1H2(320),m3h2x2(:,914),heltab2x4(:,:,914))
  call Hloop_A_Q(ntryL,G1H2(320),55,0,G2H2(827),n2h2(505))
  call Hloop_VA_Q(ntryL,G1H4(810),ex2(:),G1H2(326),m3h2x2(:,915),heltab2x4(:,:,915))
  call Hloop_A_Q(ntryL,G1H2(326),55,0,G2H2(828),n2h2(506))
  call Hloop_UV_W(ntryL,G1H4(87),39,ex4(:),8,G2H2(829),m3h2x2(:,916),heltab2x4(:,:,916))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(88),-16,ex5(:),16,G2H2(830),m3h2x2(:,917),heltab2x4(:,:,917))
call signflip_OLR(G2H2(830))
  call Hloop_UV_W(ntryL,G1H4(812),39,ex4(:),8,G2H2(831),m3h2x2(:,918),heltab2x4(:,:,918))
  call Hloop_UV_W(ntryL,G1H4(813),39,ex4(:),8,G2H2(832),m3h2x2(:,919),heltab2x4(:,:,919))
  call Hloop_UV_W(ntryL,G1H4(814),39,ex4(:),8,G2H2(833),m3h2x2(:,920),heltab2x4(:,:,920))
call HGT_raise_alpha_OLR(G1H4(815),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(815),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(815),-16,ex5(:),16,G2H2(834),m3h2x2(:,921),heltab2x4(:,:,921))
call signflip_OLR(G2H2(834))
  call Hloop_UV_W(ntryL,G1H4(818),39,ex4(:),8,G2H2(835),m3h2x2(:,922),heltab2x4(:,:,922))
  call Hloop_UV_W(ntryL,G1H4(819),39,ex4(:),8,G2H2(836),m3h2x2(:,923),heltab2x4(:,:,923))
  call Hloop_UV_W(ntryL,G1H4(99),39,ex5(:),16,G2H2(837),m3h2x2(:,924),heltab2x4(:,:,924))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(100),-8,ex4(:),8,G2H2(838),m3h2x2(:,925),heltab2x4(:,:,925))
call signflip_OLR(G2H2(838))
  call Hloop_UV_W(ntryL,G1H4(821),39,ex5(:),16,G2H2(839),m3h2x2(:,926),heltab2x4(:,:,926))
  call Hloop_UV_W(ntryL,G1H4(822),39,ex5(:),16,G2H2(840),m3h2x2(:,927),heltab2x4(:,:,927))
  call Hloop_UV_W(ntryL,G1H4(823),39,ex5(:),16,G2H2(841),m3h2x2(:,928),heltab2x4(:,:,928))
call HGT_raise_alpha_OLR(G1H4(824),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(824),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(824),-8,ex4(:),8,G2H2(842),m3h2x2(:,929),heltab2x4(:,:,929))
call signflip_OLR(G2H2(842))
  call Hloop_UV_W(ntryL,G1H4(827),39,ex5(:),16,G2H2(843),m3h2x2(:,930),heltab2x4(:,:,930))
  call Hloop_UV_W(ntryL,G1H4(828),39,ex5(:),16,G2H2(844),m3h2x2(:,931),heltab2x4(:,:,931))
  call Hloop_UV_W(ntryL,G1H4(111),39,ex4(:),8,G2H2(845),m3h2x2(:,932),heltab2x4(:,:,932))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(112),-16,ex5(:),16,G2H2(846),m3h2x2(:,933),heltab2x4(:,:,933))
call signflip_OLR(G2H2(846))
  call Hloop_UV_W(ntryL,G1H4(830),39,ex4(:),8,G2H2(847),m3h2x2(:,934),heltab2x4(:,:,934))
  call Hloop_UV_W(ntryL,G1H4(831),39,ex4(:),8,G2H2(848),m3h2x2(:,935),heltab2x4(:,:,935))
  call Hloop_UV_W(ntryL,G1H4(832),39,ex4(:),8,G2H2(849),m3h2x2(:,936),heltab2x4(:,:,936))
call HGT_raise_alpha_OLR(G1H4(833),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(833),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(833),-16,ex5(:),16,G2H2(850),m3h2x2(:,937),heltab2x4(:,:,937))
call signflip_OLR(G2H2(850))
  call Hloop_UV_W(ntryL,G1H4(836),39,ex4(:),8,G2H2(851),m3h2x2(:,938),heltab2x4(:,:,938))
  call Hloop_UV_W(ntryL,G1H4(837),39,ex4(:),8,G2H2(852),m3h2x2(:,939),heltab2x4(:,:,939))
  call Hloop_UV_W(ntryL,G1H4(123),39,ex5(:),16,G2H2(853),m3h2x2(:,940),heltab2x4(:,:,940))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(124),-8,ex4(:),8,G2H2(854),m3h2x2(:,941),heltab2x4(:,:,941))
call signflip_OLR(G2H2(854))
  call Hloop_UV_W(ntryL,G1H4(839),39,ex5(:),16,G2H2(855),m3h2x2(:,942),heltab2x4(:,:,942))
  call Hloop_UV_W(ntryL,G1H4(840),39,ex5(:),16,G2H2(856),m3h2x2(:,943),heltab2x4(:,:,943))
  call Hloop_UV_W(ntryL,G1H4(841),39,ex5(:),16,G2H2(857),m3h2x2(:,944),heltab2x4(:,:,944))
call HGT_raise_alpha_OLR(G1H4(842),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(842),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(842),-8,ex4(:),8,G2H2(858),m3h2x2(:,945),heltab2x4(:,:,945))
call signflip_OLR(G2H2(858))
  call Hloop_UV_W(ntryL,G1H4(845),39,ex5(:),16,G2H2(859),m3h2x2(:,946),heltab2x4(:,:,946))
  call Hloop_UV_W(ntryL,G1H4(846),39,ex5(:),16,G2H2(860),m3h2x2(:,947),heltab2x4(:,:,947))
  call Hloop_QV_A(ntryL,G1H4(135),ex3(:),G1H2(331),m3h2x2(:,948),heltab2x4(:,:,948))
  call Hloop_Q_A(ntryL,G1H2(331),47,0,G2H2(861),n2h2(507))
call HGT_OLR(G1H4(136),1,1,4)
call HGT_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(136),-16,0,G2H4(232),n2h4(958))
  call Hloop_AV_Q(ntryL,G2H4(232),ex5(:),G2H2(862),m3h2x2(:,949),heltab2x4(:,:,949))
  call Hloop_QV_A(ntryL,G1H4(848),ex3(:),G1H2(332),m3h2x2(:,950),heltab2x4(:,:,950))
  call Hloop_Q_A(ntryL,G1H2(332),47,0,G2H2(863),n2h2(508))
  call Hloop_QV_A(ntryL,G1H4(849),ex3(:),G1H2(337),m3h2x2(:,951),heltab2x4(:,:,951))
  call Hloop_Q_A(ntryL,G1H2(337),47,0,G2H2(864),n2h2(509))
call HGT_OLR(G1H4(376),1,1,4)
call HGT_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(376),-16,0,G2H4(230),n2h4(959))
  call Hloop_AV_Q(ntryL,G2H4(230),ex5(:),G2H2(865),m3h2x2(:,952),heltab2x4(:,:,952))
  call Hloop_QV_A(ntryL,G1H4(852),ex3(:),G1H2(338),m3h2x2(:,953),heltab2x4(:,:,953))
  call Hloop_Q_A(ntryL,G1H2(338),47,0,G2H2(866),n2h2(510))
  call Hloop_QV_A(ntryL,G0H4(1),ex3(:),G0H2(1),m3h2x2(:,954),heltab2x4(:,:,954))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(20),n2h2(511))
  call Hloop_AV_Q(ntryL,G1H4(853),ex4(:),G1H2(25),m3h2x2(:,955),heltab2x4(:,:,955))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(867),n2h2(512))
call HGT_OLR(G1H4(854),1,1,4)
call HGT_invQ_OLR(G1H4(854),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(854),-16,0,G2H4(231),n2h4(960))
  call Hloop_QV_A(ntryL,G2H4(231),ex5(:),G2H2(868),m3h2x2(:,956),heltab2x4(:,:,956))
  call Hloop_AV_Q(ntryL,G1H4(857),ex4(:),G1H2(31),m3h2x2(:,957),heltab2x4(:,:,957))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(869),n2h2(513))
  call Hloop_AV_Q(ntryL,G1H4(858),ex4(:),G1H2(37),m3h2x2(:,958),heltab2x4(:,:,958))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(870),n2h2(514))
call HGT_OLR(G1H4(160),1,1,4)
call HGT_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(160),-16,0,G2H4(235),n2h4(961))
  call Hloop_QV_A(ntryL,G2H4(235),ex5(:),G2H2(871),m3h2x2(:,959),heltab2x4(:,:,959))
  call Hloop_AV_Q(ntryL,G1H4(861),ex4(:),G1H2(38),m3h2x2(:,960),heltab2x4(:,:,960))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(872),n2h2(515))
  call Hloop_AV_Q(ntryL,G0H4(2),ex4(:),G0H2(1),m3h2x2(:,961),heltab2x4(:,:,961))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(44),n2h2(516))
  call Hloop_AV_Q(ntryL,G1H4(862),ex5(:),G1H2(49),m3h2x2(:,962),heltab2x4(:,:,962))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(873),n2h2(517))
call HGT_OLR(G1H4(863),1,1,4)
call HGT_invQ_OLR(G1H4(863),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(863),-8,0,G2H4(281),n2h4(962))
  call Hloop_QV_A(ntryL,G2H4(281),ex4(:),G2H2(874),m3h2x2(:,963),heltab2x4(:,:,963))
  call Hloop_AV_Q(ntryL,G1H4(866),ex5(:),G1H2(55),m3h2x2(:,964),heltab2x4(:,:,964))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(875),n2h2(518))
  call Hloop_AV_Q(ntryL,G1H4(867),ex5(:),G1H2(61),m3h2x2(:,965),heltab2x4(:,:,965))
  call Hloop_A_Q(ntryL,G1H2(61),55,0,G2H2(876),n2h2(519))
call HGT_OLR(G1H4(172),1,1,4)
call HGT_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(172),-8,0,G2H4(239),n2h4(963))
  call Hloop_QV_A(ntryL,G2H4(239),ex4(:),G2H2(877),m3h2x2(:,966),heltab2x4(:,:,966))
  call Hloop_AV_Q(ntryL,G1H4(870),ex5(:),G1H2(62),m3h2x2(:,967),heltab2x4(:,:,967))
  call Hloop_A_Q(ntryL,G1H2(62),55,0,G2H2(878),n2h2(520))
  call Hloop_AV_Q(ntryL,G0H4(3),ex5(:),G0H2(1),m3h2x2(:,968),heltab2x4(:,:,968))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(68),n2h2(521))
  call Hloop_QV_A(ntryL,G1H4(871),ex4(:),G1H2(73),m3h2x2(:,969),heltab2x4(:,:,969))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(879),n2h2(522))
call HGT_OLR(G1H4(872),1,1,4)
call HGT_invQ_OLR(G1H4(872),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(872),-16,0,G2H4(237),n2h4(964))
  call Hloop_AV_Q(ntryL,G2H4(237),ex5(:),G2H2(880),m3h2x2(:,970),heltab2x4(:,:,970))
  call Hloop_QV_A(ntryL,G1H4(877),ex4(:),G1H2(79),m3h2x2(:,971),heltab2x4(:,:,971))
  call Hloop_Q_A(ntryL,G1H2(79),47,0,G2H2(881),n2h2(523))
  call Hloop_QV_A(ntryL,G1H4(1319),ex4(:),G1H2(85),m3h2x2(:,972),heltab2x4(:,:,972))
  call Hloop_Q_A(ntryL,G1H2(85),47,0,G2H2(882),n2h2(524))
call HGT_OLR(G1H4(878),1,1,4)
call HGT_invQ_OLR(G1H4(878),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(878),-16,0,G2H4(238),n2h4(965))
  call Hloop_AV_Q(ntryL,G2H4(238),ex5(:),G2H2(883),m3h2x2(:,973),heltab2x4(:,:,973))
  call Hloop_QV_A(ntryL,G1H4(881),ex4(:),G1H2(86),m3h2x2(:,974),heltab2x4(:,:,974))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(884),n2h2(525))
  call Hloop_QV_A(ntryL,G0H4(4),ex4(:),G0H2(1),m3h2x2(:,975),heltab2x4(:,:,975))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(92),n2h2(526))
  call Hloop_QV_A(ntryL,G1H4(185),ex5(:),G1H2(97),m3h2x2(:,976),heltab2x4(:,:,976))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(885),n2h2(527))
call HGT_OLR(G1H4(882),1,1,4)
call HGT_invQ_OLR(G1H4(882),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(882),-8,0,G2H4(448),n2h4(966))
  call Hloop_AV_Q(ntryL,G2H4(448),ex4(:),G2H2(886),m3h2x2(:,977),heltab2x4(:,:,977))
  call Hloop_QV_A(ntryL,G1H4(887),ex5(:),G1H2(103),m3h2x2(:,978),heltab2x4(:,:,978))
  call Hloop_Q_A(ntryL,G1H2(103),55,0,G2H2(887),n2h2(528))
  call Hloop_QV_A(ntryL,G1H4(1324),ex5(:),G1H2(109),m3h2x2(:,979),heltab2x4(:,:,979))
  call Hloop_Q_A(ntryL,G1H2(109),55,0,G2H2(888),n2h2(529))
call HGT_OLR(G1H4(888),1,1,4)
call HGT_invQ_OLR(G1H4(888),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(888),-8,0,G2H4(450),n2h4(967))
  call Hloop_AV_Q(ntryL,G2H4(450),ex4(:),G2H2(889),m3h2x2(:,980),heltab2x4(:,:,980))
  call Hloop_QV_A(ntryL,G1H4(891),ex5(:),G1H2(110),m3h2x2(:,981),heltab2x4(:,:,981))
  call Hloop_Q_A(ntryL,G1H2(110),55,0,G2H2(890),n2h2(530))
  call Hloop_QV_A(ntryL,G0H4(5),ex5(:),G0H2(1),m3h2x2(:,982),heltab2x4(:,:,982))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(115),n2h2(531))
  call Hloop_AV_Q(ntryL,G1H4(197),ex3(:),G1H2(116),m3h2x2(:,983),heltab2x4(:,:,983))
  call Hloop_A_Q(ntryL,G1H2(116),47,0,G2H2(891),n2h2(532))
call HGT_OLR(G1H4(892),1,1,4)
call HGT_invQ_OLR(G1H4(892),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(892),-16,0,G2H4(451),n2h4(968))
  call Hloop_QV_A(ntryL,G2H4(451),ex5(:),G2H2(892),m3h2x2(:,984),heltab2x4(:,:,984))
  call Hloop_AV_Q(ntryL,G1H4(895),ex3(:),G1H2(121),m3h2x2(:,985),heltab2x4(:,:,985))
  call Hloop_A_Q(ntryL,G1H2(121),47,0,G2H2(893),n2h2(533))
  call Hloop_AV_Q(ntryL,G1H4(896),ex3(:),G1H2(127),m3h2x2(:,986),heltab2x4(:,:,986))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(894),n2h2(534))
call HGT_OLR(G1H4(484),1,1,4)
call HGT_invQ_OLR(G1H4(484),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(484),-16,0,G2H4(457),n2h4(969))
  call Hloop_QV_A(ntryL,G2H4(457),ex5(:),G2H2(895),m3h2x2(:,987),heltab2x4(:,:,987))
  call Hloop_AV_Q(ntryL,G1H4(899),ex3(:),G1H2(128),m3h2x2(:,988),heltab2x4(:,:,988))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(896),n2h2(535))
  call Hloop_AV_Q(ntryL,G0H4(6),ex3(:),G0H2(1),m3h2x2(:,989),heltab2x4(:,:,989))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(134),n2h2(536))
  call Hloop_QV_A(ntryL,G1H4(900),ex4(:),G1H2(140),m3h2x2(:,990),heltab2x4(:,:,990))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(897),n2h2(537))
call HGT_OLR(G1H4(901),1,1,4)
call HGT_invQ_OLR(G1H4(901),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(901),-16,0,G2H4(459),n2h4(970))
  call Hloop_AV_Q(ntryL,G2H4(459),ex5(:),G2H2(898),m3h2x2(:,991),heltab2x4(:,:,991))
  call Hloop_QV_A(ntryL,G1H4(904),ex4(:),G1H2(145),m3h2x2(:,992),heltab2x4(:,:,992))
  call Hloop_Q_A(ntryL,G1H2(145),47,0,G2H2(899),n2h2(538))
  call Hloop_QV_A(ntryL,G1H4(905),ex4(:),G1H2(146),m3h2x2(:,993),heltab2x4(:,:,993))
  call Hloop_Q_A(ntryL,G1H2(146),47,0,G2H2(900),n2h2(539))
call HGT_OLR(G1H4(220),1,1,4)
call HGT_invQ_OLR(G1H4(220),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(220),-16,0,G2H4(460),n2h4(971))
  call Hloop_AV_Q(ntryL,G2H4(460),ex5(:),G2H2(901),m3h2x2(:,994),heltab2x4(:,:,994))
  call Hloop_QV_A(ntryL,G1H4(908),ex4(:),G1H2(151),m3h2x2(:,995),heltab2x4(:,:,995))
  call Hloop_Q_A(ntryL,G1H2(151),47,0,G2H2(902),n2h2(540))
  call Hloop_QV_A(ntryL,G0H4(7),ex4(:),G0H2(1),m3h2x2(:,996),heltab2x4(:,:,996))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(152),n2h2(541))
  call Hloop_QV_A(ntryL,G1H4(909),ex3(:),G1H2(163),m3h2x2(:,997),heltab2x4(:,:,997))
  call Hloop_Q_A(ntryL,G1H2(163),47,0,G2H2(903),n2h2(542))
call HGT_OLR(G1H4(910),1,1,4)
call HGT_invQ_OLR(G1H4(910),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(910),-16,0,G2H4(466),n2h4(972))
  call Hloop_AV_Q(ntryL,G2H4(466),ex5(:),G2H2(904),m3h2x2(:,998),heltab2x4(:,:,998))
  call Hloop_QV_A(ntryL,G1H4(915),ex3(:),G1H2(169),m3h2x2(:,999),heltab2x4(:,:,999))
  call Hloop_Q_A(ntryL,G1H2(169),47,0,G2H2(905),n2h2(543))
  call Hloop_QV_A(ntryL,G1H4(1329),ex3(:),G1H2(176),m3h2x2(:,1000),heltab2x4(:,:,1000))
  call Hloop_Q_A(ntryL,G1H2(176),47,0,G2H2(906),n2h2(544))
call HGT_OLR(G1H4(916),1,1,4)
call HGT_invQ_OLR(G1H4(916),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(916),-16,0,G2H4(468),n2h4(973))
  call Hloop_AV_Q(ntryL,G2H4(468),ex5(:),G2H2(907),m3h2x2(:,1001),heltab2x4(:,:,1001))
  call Hloop_QV_A(ntryL,G1H4(919),ex3(:),G1H2(187),m3h2x2(:,1002),heltab2x4(:,:,1002))
  call Hloop_Q_A(ntryL,G1H2(187),47,0,G2H2(908),n2h2(545))
  call Hloop_QV_A(ntryL,G0H4(8),ex3(:),G0H2(1),m3h2x2(:,1003),heltab2x4(:,:,1003))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(193),n2h2(546))
  call Hloop_QV_A(ntryL,G1H4(377),ex5(:),G1H2(199),m3h2x2(:,1004),heltab2x4(:,:,1004))
  call Hloop_Q_A(ntryL,G1H2(199),59,0,G2H2(909),n2h2(547))
call HGT_OLR(G1H4(920),1,1,4)
call HGT_invQ_OLR(G1H4(920),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(920),-4,0,G2H4(469),n2h4(974))
  call Hloop_AV_Q(ntryL,G2H4(469),ex3(:),G2H2(910),m3h2x2(:,1005),heltab2x4(:,:,1005))
  call Hloop_QV_A(ntryL,G1H4(925),ex5(:),G1H2(200),m3h2x2(:,1006),heltab2x4(:,:,1006))
  call Hloop_Q_A(ntryL,G1H2(200),59,0,G2H2(911),n2h2(548))
  call Hloop_QV_A(ntryL,G1H4(1334),ex5(:),G1H2(206),m3h2x2(:,1007),heltab2x4(:,:,1007))
  call Hloop_Q_A(ntryL,G1H2(206),59,0,G2H2(912),n2h2(549))
call HGT_OLR(G1H4(926),1,1,4)
call HGT_invQ_OLR(G1H4(926),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(926),-4,0,G2H4(296),n2h4(975))
  call Hloop_AV_Q(ntryL,G2H4(296),ex3(:),G2H2(913),m3h2x2(:,1008),heltab2x4(:,:,1008))
  call Hloop_QV_A(ntryL,G1H4(929),ex5(:),G1H2(211),m3h2x2(:,1009),heltab2x4(:,:,1009))
  call Hloop_Q_A(ntryL,G1H2(211),59,0,G2H2(914),n2h2(550))
  call Hloop_QV_A(ntryL,G0H4(9),ex5(:),G0H2(1),m3h2x2(:,1010),heltab2x4(:,:,1010))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(217),n2h2(551))
  call Hloop_QV_A(ntryL,G1H4(461),ex5(:),G1H2(223),m3h2x2(:,1011),heltab2x4(:,:,1011))
  call Hloop_Q_A(ntryL,G1H2(223),55,0,G2H2(915),n2h2(552))
call HGT_OLR(G1H4(930),1,1,4)
call HGT_invQ_OLR(G1H4(930),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(930),-8,0,G2H4(272),n2h4(976))
  call Hloop_AV_Q(ntryL,G2H4(272),ex4(:),G2H2(916),m3h2x2(:,1012),heltab2x4(:,:,1012))
  call Hloop_QV_A(ntryL,G1H4(933),ex5(:),G1H2(224),m3h2x2(:,1013),heltab2x4(:,:,1013))
  call Hloop_Q_A(ntryL,G1H2(224),55,0,G2H2(917),n2h2(553))
  call Hloop_QV_A(ntryL,G1H4(934),ex5(:),G1H2(230),m3h2x2(:,1014),heltab2x4(:,:,1014))
  call Hloop_Q_A(ntryL,G1H2(230),55,0,G2H2(918),n2h2(554))
call HGT_OLR(G1H4(256),1,1,4)
call HGT_invQ_OLR(G1H4(256),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(256),-8,0,G2H4(300),n2h4(977))
  call Hloop_AV_Q(ntryL,G2H4(300),ex4(:),G2H2(919),m3h2x2(:,1015),heltab2x4(:,:,1015))
  call Hloop_QV_A(ntryL,G1H4(937),ex5(:),G1H2(235),m3h2x2(:,1016),heltab2x4(:,:,1016))
  call Hloop_Q_A(ntryL,G1H2(235),55,0,G2H2(920),n2h2(555))
  call Hloop_QV_A(ntryL,G0H4(10),ex5(:),G0H2(1),m3h2x2(:,1017),heltab2x4(:,:,1017))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(241),n2h2(556))
  call Hloop_QV_A(ntryL,G1H4(938),ex3(:),G1H2(247),m3h2x2(:,1018),heltab2x4(:,:,1018))
  call Hloop_Q_A(ntryL,G1H2(247),55,0,G2H2(921),n2h2(557))
call HGT_OLR(G1H4(939),1,1,4)
call HGT_invQ_OLR(G1H4(939),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(939),-8,0,G2H4(298),n2h4(978))
  call Hloop_AV_Q(ntryL,G2H4(298),ex4(:),G2H2(922),m3h2x2(:,1019),heltab2x4(:,:,1019))
  call Hloop_QV_A(ntryL,G1H4(944),ex3(:),G1H2(248),m3h2x2(:,1020),heltab2x4(:,:,1020))
  call Hloop_Q_A(ntryL,G1H2(248),55,0,G2H2(923),n2h2(558))
  call Hloop_QV_A(ntryL,G1H4(1339),ex3(:),G1H2(254),m3h2x2(:,1021),heltab2x4(:,:,1021))
  call Hloop_Q_A(ntryL,G1H2(254),55,0,G2H2(924),n2h2(559))
call HGT_OLR(G1H4(945),1,1,4)
call HGT_invQ_OLR(G1H4(945),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(945),-8,0,G2H4(276),n2h4(979))
  call Hloop_AV_Q(ntryL,G2H4(276),ex4(:),G2H2(925),m3h2x2(:,1022),heltab2x4(:,:,1022))
  call Hloop_QV_A(ntryL,G1H4(948),ex3(:),G1H2(259),m3h2x2(:,1023),heltab2x4(:,:,1023))
  call Hloop_Q_A(ntryL,G1H2(259),55,0,G2H2(926),n2h2(560))
  call Hloop_QV_A(ntryL,G0H4(11),ex3(:),G0H2(1),m3h2x2(:,1024),heltab2x4(:,:,1024))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(265),n2h2(561))
  call Hloop_QV_A(ntryL,G1H4(425),ex4(:),G1H2(271),m3h2x2(:,1025),heltab2x4(:,:,1025))
  call Hloop_Q_A(ntryL,G1H2(271),59,0,G2H2(927),n2h2(562))
call HGT_OLR(G1H4(949),1,1,4)
call HGT_invQ_OLR(G1H4(949),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(949),-4,0,G2H4(274),n2h4(980))
  call Hloop_AV_Q(ntryL,G2H4(274),ex3(:),G2H2(928),m3h2x2(:,1026),heltab2x4(:,:,1026))
  call Hloop_QV_A(ntryL,G1H4(954),ex4(:),G1H2(272),m3h2x2(:,1027),heltab2x4(:,:,1027))
  call Hloop_Q_A(ntryL,G1H2(272),59,0,G2H2(929),n2h2(563))
  call Hloop_QV_A(ntryL,G1H4(1344),ex4(:),G1H2(278),m3h2x2(:,1028),heltab2x4(:,:,1028))
  call Hloop_Q_A(ntryL,G1H2(278),59,0,G2H2(930),n2h2(564))
call HGT_OLR(G1H4(955),1,1,4)
call HGT_invQ_OLR(G1H4(955),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(955),-4,0,G2H4(299),n2h4(981))
  call Hloop_AV_Q(ntryL,G2H4(299),ex3(:),G2H2(931),m3h2x2(:,1029),heltab2x4(:,:,1029))
  call Hloop_QV_A(ntryL,G1H4(958),ex4(:),G1H2(283),m3h2x2(:,1030),heltab2x4(:,:,1030))
  call Hloop_Q_A(ntryL,G1H2(283),59,0,G2H2(932),n2h2(565))
  call Hloop_QV_A(ntryL,G0H4(12),ex4(:),G0H2(1),m3h2x2(:,1031),heltab2x4(:,:,1031))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(289),n2h2(566))
  call Hloop_AV_Q(ntryL,G1H4(473),ex4(:),G1H2(295),m3h2x2(:,1032),heltab2x4(:,:,1032))
  call Hloop_A_Q(ntryL,G1H2(295),47,0,G2H2(933),n2h2(567))
call HGT_OLR(G1H4(959),1,1,4)
call HGT_invQ_OLR(G1H4(959),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(959),-16,0,G2H4(275),n2h4(982))
  call Hloop_QV_A(ntryL,G2H4(275),ex5(:),G2H2(934),m3h2x2(:,1033),heltab2x4(:,:,1033))
  call Hloop_AV_Q(ntryL,G1H4(962),ex4(:),G1H2(296),m3h2x2(:,1034),heltab2x4(:,:,1034))
  call Hloop_A_Q(ntryL,G1H2(296),47,0,G2H2(935),n2h2(568))
  call Hloop_AV_Q(ntryL,G1H4(963),ex4(:),G1H2(301),m3h2x2(:,1035),heltab2x4(:,:,1035))
  call Hloop_A_Q(ntryL,G1H2(301),47,0,G2H2(936),n2h2(569))
  call Hloop_AV_Q(ntryL,G1H4(964),ex4(:),G1H2(302),m3h2x2(:,1036),heltab2x4(:,:,1036))
  call Hloop_A_Q(ntryL,G1H2(302),47,0,G2H2(937),n2h2(570))
call HGT_OLR(G1H4(965),1,1,4)
call HGT_invQ_OLR(G1H4(965),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(965),-16,0,G2H4(478),n2h4(983))
  call Hloop_QV_A(ntryL,G2H4(478),ex5(:),G2H2(938),m3h2x2(:,1037),heltab2x4(:,:,1037))
  call Hloop_AV_Q(ntryL,G1H4(291),ex4(:),G1H2(307),m3h2x2(:,1038),heltab2x4(:,:,1038))
  call Hloop_A_Q(ntryL,G1H2(307),47,0,G2H2(939),n2h2(571))
  call Hloop_AV_Q(ntryL,G1H4(1349),ex4(:),G1H2(313),m3h2x2(:,1039),heltab2x4(:,:,1039))
  call Hloop_A_Q(ntryL,G1H2(313),47,0,G2H2(940),n2h2(572))
call HGT_OLR(G1H4(970),1,1,4)
call HGT_invQ_OLR(G1H4(970),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(970),-16,0,G2H4(480),n2h4(984))
  call Hloop_QV_A(ntryL,G2H4(480),ex5(:),G2H2(941),m3h2x2(:,1040),heltab2x4(:,:,1040))
  call Hloop_AV_Q(ntryL,G1H4(973),ex4(:),G1H2(314),m3h2x2(:,1041),heltab2x4(:,:,1041))
  call Hloop_A_Q(ntryL,G1H2(314),47,0,G2H2(942),n2h2(573))
  call Hloop_AV_Q(ntryL,G0H4(13),ex4(:),G0H2(1),m3h2x2(:,1042),heltab2x4(:,:,1042))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(320),n2h2(574))
  call Hloop_AV_Q(ntryL,G1H4(293),ex5(:),G1H2(326),m3h2x2(:,1043),heltab2x4(:,:,1043))
  call Hloop_A_Q(ntryL,G1H2(326),55,0,G2H2(943),n2h2(575))
call HGT_OLR(G1H4(974),1,1,4)
call HGT_invQ_OLR(G1H4(974),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(974),-8,0,G2H4(481),n2h4(985))
  call Hloop_QV_A(ntryL,G2H4(481),ex4(:),G2H2(944),m3h2x2(:,1044),heltab2x4(:,:,1044))
  call Hloop_AV_Q(ntryL,G1H4(977),ex5(:),G1H2(331),m3h2x2(:,1045),heltab2x4(:,:,1045))
  call Hloop_A_Q(ntryL,G1H2(331),55,0,G2H2(945),n2h2(576))
  call Hloop_AV_Q(ntryL,G1H4(978),ex5(:),G1H2(332),m3h2x2(:,1046),heltab2x4(:,:,1046))
  call Hloop_A_Q(ntryL,G1H2(332),55,0,G2H2(946),n2h2(577))
  call Hloop_AV_Q(ntryL,G1H4(979),ex5(:),G1H2(337),m3h2x2(:,1047),heltab2x4(:,:,1047))
  call Hloop_A_Q(ntryL,G1H2(337),55,0,G2H2(947),n2h2(578))
call HGT_OLR(G1H4(980),1,1,4)
call HGT_invQ_OLR(G1H4(980),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(980),-8,0,G2H4(51),n2h4(986))
  call Hloop_QV_A(ntryL,G2H4(51),ex4(:),G2H2(948),m3h2x2(:,1048),heltab2x4(:,:,1048))
  call Hloop_AV_Q(ntryL,G1H4(303),ex5(:),G1H2(338),m3h2x2(:,1049),heltab2x4(:,:,1049))
  call Hloop_A_Q(ntryL,G1H2(338),55,0,G2H2(949),n2h2(579))
  call Hloop_AV_Q(ntryL,G1H4(1354),ex5(:),G1H2(25),m3h2x2(:,1050),heltab2x4(:,:,1050))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(950),n2h2(580))
call HGT_OLR(G1H4(985),1,1,4)
call HGT_invQ_OLR(G1H4(985),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(985),-8,0,G2H4(54),n2h4(987))
  call Hloop_QV_A(ntryL,G2H4(54),ex4(:),G2H2(951),m3h2x2(:,1051),heltab2x4(:,:,1051))
  call Hloop_AV_Q(ntryL,G1H4(988),ex5(:),G1H2(31),m3h2x2(:,1052),heltab2x4(:,:,1052))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(952),n2h2(581))
  call Hloop_AV_Q(ntryL,G0H4(14),ex5(:),G0H2(1),m3h2x2(:,1053),heltab2x4(:,:,1053))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(37),n2h2(582))
  call Hloop_AV_Q(ntryL,G1H4(305),ex3(:),G1H2(38),m3h2x2(:,1054),heltab2x4(:,:,1054))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(953),n2h2(583))
call HGT_OLR(G1H4(989),1,1,4)
call HGT_invQ_OLR(G1H4(989),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(989),-16,0,G2H4(59),n2h4(988))
  call Hloop_QV_A(ntryL,G2H4(59),ex5(:),G2H2(954),m3h2x2(:,1055),heltab2x4(:,:,1055))
  call Hloop_AV_Q(ntryL,G1H4(992),ex3(:),G1H2(49),m3h2x2(:,1056),heltab2x4(:,:,1056))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(955),n2h2(584))
  call Hloop_AV_Q(ntryL,G1H4(993),ex3(:),G1H2(55),m3h2x2(:,1057),heltab2x4(:,:,1057))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(956),n2h2(585))
  call Hloop_AV_Q(ntryL,G1H4(994),ex3(:),G1H2(61),m3h2x2(:,1058),heltab2x4(:,:,1058))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(957),n2h2(586))
call HGT_OLR(G1H4(995),1,1,4)
call HGT_invQ_OLR(G1H4(995),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(995),-16,0,G2H4(62),n2h4(989))
  call Hloop_QV_A(ntryL,G2H4(62),ex5(:),G2H2(958),m3h2x2(:,1059),heltab2x4(:,:,1059))
  call Hloop_AV_Q(ntryL,G1H4(315),ex3(:),G1H2(62),m3h2x2(:,1060),heltab2x4(:,:,1060))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(959),n2h2(587))
  call Hloop_AV_Q(ntryL,G1H4(1359),ex3(:),G1H2(73),m3h2x2(:,1061),heltab2x4(:,:,1061))
  call Hloop_A_Q(ntryL,G1H2(73),47,0,G2H2(960),n2h2(588))
call HGT_OLR(G1H4(1000),1,1,4)
call HGT_invQ_OLR(G1H4(1000),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1000),-16,0,G2H4(87),n2h4(990))
  call Hloop_QV_A(ntryL,G2H4(87),ex5(:),G2H2(961),m3h2x2(:,1062),heltab2x4(:,:,1062))
  call Hloop_AV_Q(ntryL,G1H4(1003),ex3(:),G1H2(79),m3h2x2(:,1063),heltab2x4(:,:,1063))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(962),n2h2(589))
  call Hloop_AV_Q(ntryL,G0H4(15),ex3(:),G0H2(1),m3h2x2(:,1064),heltab2x4(:,:,1064))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(85),n2h2(590))
  call Hloop_AV_Q(ntryL,G1H4(485),ex5(:),G1H2(86),m3h2x2(:,1065),heltab2x4(:,:,1065))
  call Hloop_A_Q(ntryL,G1H2(86),59,0,G2H2(963),n2h2(591))
call HGT_OLR(G1H4(1004),1,1,4)
call HGT_invQ_OLR(G1H4(1004),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1004),-4,0,G2H4(90),n2h4(991))
  call Hloop_QV_A(ntryL,G2H4(90),ex3(:),G2H2(964),m3h2x2(:,1066),heltab2x4(:,:,1066))
  call Hloop_AV_Q(ntryL,G1H4(1007),ex5(:),G1H2(97),m3h2x2(:,1067),heltab2x4(:,:,1067))
  call Hloop_A_Q(ntryL,G1H2(97),59,0,G2H2(965),n2h2(592))
  call Hloop_AV_Q(ntryL,G1H4(1008),ex5(:),G1H2(103),m3h2x2(:,1068),heltab2x4(:,:,1068))
  call Hloop_A_Q(ntryL,G1H2(103),59,0,G2H2(966),n2h2(593))
  call Hloop_AV_Q(ntryL,G1H4(1009),ex5(:),G1H2(109),m3h2x2(:,1069),heltab2x4(:,:,1069))
  call Hloop_A_Q(ntryL,G1H2(109),59,0,G2H2(967),n2h2(594))
call HGT_OLR(G1H4(1010),1,1,4)
call HGT_invQ_OLR(G1H4(1010),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1010),-4,0,G2H4(95),n2h4(992))
  call Hloop_QV_A(ntryL,G2H4(95),ex3(:),G2H2(968),m3h2x2(:,1070),heltab2x4(:,:,1070))
  call Hloop_AV_Q(ntryL,G1H4(327),ex5(:),G1H2(110),m3h2x2(:,1071),heltab2x4(:,:,1071))
  call Hloop_A_Q(ntryL,G1H2(110),59,0,G2H2(969),n2h2(595))
  call Hloop_AV_Q(ntryL,G1H4(1364),ex5(:),G1H2(116),m3h2x2(:,1072),heltab2x4(:,:,1072))
  call Hloop_A_Q(ntryL,G1H2(116),59,0,G2H2(970),n2h2(596))
call HGT_OLR(G1H4(1015),1,1,4)
call HGT_invQ_OLR(G1H4(1015),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1015),-4,0,G2H4(98),n2h4(993))
  call Hloop_QV_A(ntryL,G2H4(98),ex3(:),G2H2(971),m3h2x2(:,1073),heltab2x4(:,:,1073))
  call Hloop_AV_Q(ntryL,G1H4(1018),ex5(:),G1H2(121),m3h2x2(:,1074),heltab2x4(:,:,1074))
  call Hloop_A_Q(ntryL,G1H2(121),59,0,G2H2(972),n2h2(597))
  call Hloop_AV_Q(ntryL,G0H4(16),ex5(:),G0H2(1),m3h2x2(:,1075),heltab2x4(:,:,1075))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(127),n2h2(598))
  call Hloop_AV_Q(ntryL,G1H4(509),ex3(:),G1H2(128),m3h2x2(:,1076),heltab2x4(:,:,1076))
  call Hloop_A_Q(ntryL,G1H2(128),55,0,G2H2(973),n2h2(599))
call HGT_OLR(G1H4(1019),1,1,4)
call HGT_invQ_OLR(G1H4(1019),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1019),-8,0,G2H4(111),n2h4(994))
  call Hloop_QV_A(ntryL,G2H4(111),ex4(:),G2H2(974),m3h2x2(:,1077),heltab2x4(:,:,1077))
  call Hloop_AV_Q(ntryL,G1H4(1022),ex3(:),G1H2(140),m3h2x2(:,1078),heltab2x4(:,:,1078))
  call Hloop_A_Q(ntryL,G1H2(140),55,0,G2H2(975),n2h2(600))
  call Hloop_AV_Q(ntryL,G1H4(1023),ex3(:),G1H2(145),m3h2x2(:,1079),heltab2x4(:,:,1079))
  call Hloop_A_Q(ntryL,G1H2(145),55,0,G2H2(976),n2h2(601))
  call Hloop_AV_Q(ntryL,G1H4(1024),ex3(:),G1H2(146),m3h2x2(:,1080),heltab2x4(:,:,1080))
  call Hloop_A_Q(ntryL,G1H2(146),55,0,G2H2(977),n2h2(602))
call HGT_OLR(G1H4(1025),1,1,4)
call HGT_invQ_OLR(G1H4(1025),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1025),-8,0,G2H4(114),n2h4(995))
  call Hloop_QV_A(ntryL,G2H4(114),ex4(:),G2H2(978),m3h2x2(:,1081),heltab2x4(:,:,1081))
  call Hloop_AV_Q(ntryL,G1H4(339),ex3(:),G1H2(151),m3h2x2(:,1082),heltab2x4(:,:,1082))
  call Hloop_A_Q(ntryL,G1H2(151),55,0,G2H2(979),n2h2(603))
  call Hloop_AV_Q(ntryL,G1H4(1369),ex3(:),G1H2(163),m3h2x2(:,1083),heltab2x4(:,:,1083))
  call Hloop_A_Q(ntryL,G1H2(163),55,0,G2H2(980),n2h2(604))
call HGT_OLR(G1H4(1030),1,1,4)
call HGT_invQ_OLR(G1H4(1030),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1030),-8,0,G2H4(119),n2h4(996))
  call Hloop_QV_A(ntryL,G2H4(119),ex4(:),G2H2(981),m3h2x2(:,1084),heltab2x4(:,:,1084))
  call Hloop_AV_Q(ntryL,G1H4(1033),ex3(:),G1H2(169),m3h2x2(:,1085),heltab2x4(:,:,1085))
  call Hloop_A_Q(ntryL,G1H2(169),55,0,G2H2(982),n2h2(605))
  call Hloop_AV_Q(ntryL,G0H4(17),ex3(:),G0H2(1),m3h2x2(:,1086),heltab2x4(:,:,1086))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(176),n2h2(606))
  call Hloop_AV_Q(ntryL,G1H4(533),ex4(:),G1H2(187),m3h2x2(:,1087),heltab2x4(:,:,1087))
  call Hloop_A_Q(ntryL,G1H2(187),59,0,G2H2(983),n2h2(607))
call HGT_OLR(G1H4(1034),1,1,4)
call HGT_invQ_OLR(G1H4(1034),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1034),-4,0,G2H4(122),n2h4(997))
  call Hloop_QV_A(ntryL,G2H4(122),ex3(:),G2H2(984),m3h2x2(:,1088),heltab2x4(:,:,1088))
  call Hloop_AV_Q(ntryL,G1H4(1037),ex4(:),G1H2(199),m3h2x2(:,1089),heltab2x4(:,:,1089))
  call Hloop_A_Q(ntryL,G1H2(199),59,0,G2H2(985),n2h2(608))
  call Hloop_AV_Q(ntryL,G1H4(1038),ex4(:),G1H2(200),m3h2x2(:,1090),heltab2x4(:,:,1090))
  call Hloop_A_Q(ntryL,G1H2(200),59,0,G2H2(986),n2h2(609))
  call Hloop_AV_Q(ntryL,G1H4(1039),ex4(:),G1H2(206),m3h2x2(:,1091),heltab2x4(:,:,1091))
  call Hloop_A_Q(ntryL,G1H2(206),59,0,G2H2(987),n2h2(610))
call HGT_OLR(G1H4(1040),1,1,4)
call HGT_invQ_OLR(G1H4(1040),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1040),-4,0,G2H4(13),n2h4(998))
  call Hloop_QV_A(ntryL,G2H4(13),ex3(:),G2H2(988),m3h2x2(:,1092),heltab2x4(:,:,1092))
  call Hloop_AV_Q(ntryL,G1H4(351),ex4(:),G1H2(211),m3h2x2(:,1093),heltab2x4(:,:,1093))
  call Hloop_A_Q(ntryL,G1H2(211),59,0,G2H2(989),n2h2(611))
  call Hloop_AV_Q(ntryL,G1H4(1374),ex4(:),G1H2(223),m3h2x2(:,1094),heltab2x4(:,:,1094))
  call Hloop_A_Q(ntryL,G1H2(223),59,0,G2H2(990),n2h2(612))
call HGT_OLR(G1H4(1045),1,1,4)
call HGT_invQ_OLR(G1H4(1045),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1045),-4,0,G2H4(15),n2h4(999))
  call Hloop_QV_A(ntryL,G2H4(15),ex3(:),G2H2(991),m3h2x2(:,1095),heltab2x4(:,:,1095))
  call Hloop_AV_Q(ntryL,G1H4(1048),ex4(:),G1H2(224),m3h2x2(:,1096),heltab2x4(:,:,1096))
  call Hloop_A_Q(ntryL,G1H2(224),59,0,G2H2(992),n2h2(613))
  call Hloop_AV_Q(ntryL,G0H4(18),ex4(:),G0H2(1),m3h2x2(:,1097),heltab2x4(:,:,1097))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(230),n2h2(614))
  call Hloop_VA_Q(ntryL,G1H4(545),ex2(:),G1H2(235),m3h2x2(:,1098),heltab2x4(:,:,1098))
  call Hloop_A_Q(ntryL,G1H2(235),47,0,G2H2(993),n2h2(615))
call HGT_OLR(G1H4(1049),1,1,4)
call HGT_invQ_OLR(G1H4(1049),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1049),-16,0,G2H4(19),n2h4(1000))
  call Hloop_QV_A(ntryL,G2H4(19),ex5(:),G2H2(994),m3h2x2(:,1099),heltab2x4(:,:,1099))
  call Hloop_VA_Q(ntryL,G1H4(1052),ex2(:),G1H2(247),m3h2x2(:,1100),heltab2x4(:,:,1100))
  call Hloop_A_Q(ntryL,G1H2(247),47,0,G2H2(995),n2h2(616))
  call Hloop_VA_Q(ntryL,G1H4(1053),ex2(:),G1H2(248),m3h2x2(:,1101),heltab2x4(:,:,1101))
  call Hloop_A_Q(ntryL,G1H2(248),47,0,G2H2(996),n2h2(617))
  call Hloop_QV_A(ntryL,G1H4(363),ex3(:),G1H2(254),m3h2x2(:,1102),heltab2x4(:,:,1102))
  call Hloop_Q_A(ntryL,G1H2(254),47,0,G2H2(997),n2h2(618))
call HGT_OLR(G1H4(364),1,1,4)
call HGT_invQ_OLR(G1H4(364),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(364),-16,0,G2H4(21),n2h4(1001))
  call Hloop_AV_Q(ntryL,G2H4(21),ex5(:),G2H2(998),m3h2x2(:,1103),heltab2x4(:,:,1103))
  call Hloop_QV_A(ntryL,G1H4(1056),ex3(:),G1H2(259),m3h2x2(:,1104),heltab2x4(:,:,1104))
  call Hloop_Q_A(ntryL,G1H2(259),47,0,G2H2(999),n2h2(619))
  call Hloop_QV_A(ntryL,G1H4(1057),ex3(:),G1H2(271),m3h2x2(:,1105),heltab2x4(:,:,1105))
  call Hloop_Q_A(ntryL,G1H2(271),47,0,G2H2(1000),n2h2(620))
  call Hloop_VQ_A(ntryL,G1H4(375),ex1(:),G1H2(272),m3h2x2(:,1106),heltab2x4(:,:,1106))
  call Hloop_Q_A(ntryL,G1H2(272),59,0,G2H2(1001),n2h2(621))
call HGT_OLR(G1H4(1058),1,1,4)
call HGT_invQ_OLR(G1H4(1058),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1058),-4,0,G2H4(25),n2h4(1002))
  call Hloop_AV_Q(ntryL,G2H4(25),ex3(:),G2H2(1002),m3h2x2(:,1107),heltab2x4(:,:,1107))
  call Hloop_VQ_A(ntryL,G1H4(1061),ex1(:),G1H2(278),m3h2x2(:,1108),heltab2x4(:,:,1108))
  call Hloop_Q_A(ntryL,G1H2(278),59,0,G2H2(1003),n2h2(622))
  call Hloop_VQ_A(ntryL,G1H4(1062),ex1(:),G1H2(283),m3h2x2(:,1109),heltab2x4(:,:,1109))
  call Hloop_Q_A(ntryL,G1H2(283),59,0,G2H2(1004),n2h2(623))
  call Hloop_VQ_A(ntryL,G1H4(1063),ex1(:),G1H2(295),m3h2x2(:,1110),heltab2x4(:,:,1110))
  call Hloop_Q_A(ntryL,G1H2(295),59,0,G2H2(1005),n2h2(624))
call HGT_OLR(G1H4(1064),1,1,4)
call HGT_invQ_OLR(G1H4(1064),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1064),-4,0,G2H4(27),n2h4(1003))
  call Hloop_AV_Q(ntryL,G2H4(27),ex3(:),G2H2(1006),m3h2x2(:,1111),heltab2x4(:,:,1111))
  call Hloop_VQ_A(ntryL,G1H4(1067),ex1(:),G1H2(296),m3h2x2(:,1112),heltab2x4(:,:,1112))
  call Hloop_Q_A(ntryL,G1H2(296),59,0,G2H2(1007),n2h2(625))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppajjj_ddxaggg_1_/**/REALKIND
