
module ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4), K2(4,4), KL(4,4), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  36,  12,  12,   0]
  K1( 2,:) = [  12,  36,   0,  12]
  K1( 3,:) = [  12,   0,  36,  12]
  K1( 4,:) = [   0,  12,  12,  36]
  K1( 5,:) = [  48,  16,  16,   0]
  K1( 6,:) = [  16,  48,   0,  16]
  K1( 7,:) = [  16,   0,  48,  16]
  K1( 8,:) = [   0,  16,  16,  48]
  K1( 9,:) = [   0,  16,  -2,   6]
  K1(10,:) = [  16,   0,   6,  -2]
  K1(11,:) = [  -2,   6,   0,  16]
  K1(12,:) = [   6,  -2,  16,   0]
  K1(13,:) = [  48,  16,  16,   0]
  K1(14,:) = [  16,  48,   0,  16]
  K1(15,:) = [  16,   0,  48,  16]
  K1(16,:) = [   0,  16,  16,  48]
  K1(17,:) = [   6,   2,   2,   0]
  K1(18,:) = [   2,   0,  -6, -16]
  K1(19,:) = [   2,  -6,   0, -16]
  K1(20,:) = [   0, -16, -16, -48]
  K1(21,:) = [   0,   2, -16,  -6]
  K1(22,:) = [   2,   6,   0,   2]
  K1(23,:) = [ -16,   0, -48, -16]
  K1(24,:) = [  -6,   2, -16,   0]
  K1(25,:) = [  48,  16,  16,   0]
  K1(26,:) = [  16,  48,   0,  16]
  K1(27,:) = [  16,   0,  48,  16]
  K1(28,:) = [   0,  16,  16,  48]
  K1(29,:) = [   0, -16,   2,  -6]
  K1(30,:) = [ -16, -48,   0, -16]
  K1(31,:) = [   2,   0,   6,   2]
  K1(32,:) = [  -6, -16,   2,   0]
  K1(33,:) = [ -48, -16, -16,   0]
  K1(34,:) = [ -16,   0,  -6,   2]
  K1(35,:) = [ -16,  -6,   0,   2]
  K1(36,:) = [   0,   2,   2,   6]
  K1(37,:) = [   0,  -2,  16,   6]
  K1(38,:) = [  -2,   0,   6,  16]
  K1(39,:) = [  16,   6,   0,  -2]
  K1(40,:) = [   6,  16,  -2,   0]
  K1(41,:) = [  48,  16,  16,   0]
  K1(42,:) = [  16,  48,   0,  16]
  K1(43,:) = [  16,   0,  48,  16]
  K1(44,:) = [   0,  16,  16,  48]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [ -54, -18, -18,   0]
  K1(66,:) = [ -18,   0,   0,  18]
  K1(67,:) = [ -18,   0, -54, -18]
  K1(68,:) = [   0,  18, -18,   0]
  K1(69,:) = [   0, -18,  18,   0]
  K1(70,:) = [ -18, -54,   0, -18]
  K1(71,:) = [  18,   0,   0, -18]
  K1(72,:) = [   0, -18, -18, -54]
  K1(73,:) = [ -54, -18, -18,   0]
  K1(74,:) = [ -18, -54,   0, -18]
  K1(75,:) = [ -18,   0,   0,  18]
  K1(76,:) = [   0, -18,  18,   0]
  K1(77,:) = [   0,  18, -18,   0]
  K1(78,:) = [  18,   0,   0, -18]
  K1(79,:) = [ -18,   0, -54, -18]
  K1(80,:) = [   0, -18, -18, -54]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [ 108,  36,  36,   0]
  K1(86,:) = [  36, 108,   0,  36]
  K1(87,:) = [  36,   0, 108,  36]
  K1(88,:) = [   0,  36,  36, 108]
  K1(89,:) = [   0,   0,   0,   0]
  K1(90,:) = [   0,   0,   0,   0]
  K1(91,:) = [   0,   0,   0,   0]
  K1(92,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

#if 1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND



module ol_forced_parameters_ppajjj_uuuxuxag_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (nf /= 5) write(*,101) 'nf = 5'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppajjj_uuuxuxag_2_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppajjj_uuuxuxag_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
  integer(intkind2), save :: nhflip = 64    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,64) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(565)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,60), wf8(8,190), wf16(16,214), wf64(64,388)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(20), c(29)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppajjj_uuuxuxag_2_/**/REALKIND






! **********************************************************************
module ol_loop_ppajjj_uuuxuxag_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED*gQCD**3)/3._/**/REALKIND
    f( 2) = (2*eQED*gQCD**3)/3._/**/REALKIND
    f( 3) = (2*CI*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED*gQCD**5
    f( 5) = (2*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 6) = (2*CI*countertermnorm*ctGqq*eQED*gQCD**5)/3._/**/REALKIND
    f( 7) = (2*countertermnorm*ctGqq*eQED*gQCD**5)/3._/**/REALKIND
    f( 8) = (2*CI*countertermnorm*ctVqq*eQED*gQCD**5)/3._/**/REALKIND
    f( 9) = (2*countertermnorm*ctVqq*eQED*gQCD**5)/3._/**/REALKIND
    f(10) = (2*countertermnorm*ctVVV*eQED*gQCD**5)/3._/**/REALKIND
    f(11) = (CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(12) = (2*CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(13) = (eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(14) = (2*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(15) = CI*eQED*gQCD**5*integralnorm*SwF
    f(16) = (4*CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(17) = 2*CI*eQED*gQCD**5*integralnorm*SwF
    f(18) = eQED*gQCD**5*integralnorm*SwF
    f(19) = (4*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(20) = 2*eQED*gQCD**5*integralnorm*SwF

  c = [ 27*CI*f(11), 54*CI*f(11), 3*CI*f(12), 9*CI*f(12), 24*CI*f(12), 27*CI*f(12), 54*CI*f(12), 18*f(13), 54*f(13), f(14) &
    , 3*f(14), 6*f(14), 8*f(14), 9*f(14), 10*f(14), 18*f(14), 21*f(14), 24*f(14), 27*f(14), 54*f(14), 9*CI*f(15), 9*CI*f(16) &
    , 9*CI*f(17), 3*f(18), 9*f(18), 3*f(19), 9*f(19), 3*f(20), 9*f(20) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,18))+L(6,18))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,13))+L(6,13))
  den(9) = 1 /((L(5,26))+L(6,26))
  den(12) = 1 /((L(5,34))+L(6,34))
  den(13) = 1 /((L(5,24))+L(6,24))
  den(16) = 1 /((L(5,7))+L(6,7))
  den(23) = 1 /((L(5,17))+L(6,17))
  den(24) = 1 /((L(5,6))+L(6,6))
  den(27) = 1 /((L(5,25))+L(6,25))
  den(30) = 1 /((L(5,14))+L(6,14))
  den(33) = 1 /((L(5,33))+L(6,33))
  den(42) = 1 /((L(5,9))+L(6,9))
  den(43) = 1 /((L(5,36))+L(6,36))
  den(48) = 1 /((L(5,22))+L(6,22))
  den(51) = 1 /((L(5,20))+L(6,20))
  den(54) = 1 /((L(5,11))+L(6,11))
  den(61) = 1 /((L(5,10))+L(6,10))
  den(64) = 1 /((L(5,21))+L(6,21))
  den(78) = 1 /((L(5,38))+L(6,38))
  den(83) = 1 /((L(5,42))+L(6,42))
  den(86) = 1 /((L(5,37))+L(6,37))
  den(92) = 1 /((L(5,41))+L(6,41))
  den(107) = 1 /((L(5,50))+L(6,50))
  den(112) = 1 /((L(5,49))+L(6,49))
  den(134) = 1 /((L(5,56))+L(6,56))
  den(140) = 1 /((L(5,52))+L(6,52))
  den(164) = 1 /((L(5,58))+L(6,58))
  den(168) = 1 /((L(5,45))+L(6,45))
  den(171) = 1 /((L(5,23))+L(6,23))
  den(186) = 1 /((L(5,29))+L(6,29))
  den(189) = 1 /((L(5,39))+L(6,39))
  den(208) = 1 /((L(5,46))+L(6,46))
  den(212) = 1 /((L(5,57))+L(6,57))
  den(226) = 1 /((L(5,30))+L(6,30))
  den(248) = 1 /((L(5,54))+L(6,54))
  den(254) = 1 /((L(5,27))+L(6,27))
  den(270) = 1 /((L(5,43))+L(6,43))
  den(291) = 1 /((L(5,53))+L(6,53))
  den(371) = 1 /((L(5,15))+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(12)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(13)*den(17)
  den(19) = den(9)*den(13)
  den(20) = den(1)*den(19)
  den(21) = den(7)*den(12)
  den(22) = den(3)*den(17)
  den(25) = den(23)*den(24)
  den(26) = den(3)*den(25)
  den(28) = den(23)*den(27)
  den(29) = den(24)*den(28)
  den(31) = den(24)*den(30)
  den(32) = den(23)*den(31)
  den(34) = den(24)*den(33)
  den(35) = den(13)*den(34)
  den(36) = den(16)*den(24)
  den(37) = den(13)*den(36)
  den(38) = den(13)*den(27)
  den(39) = den(24)*den(38)
  den(40) = den(31)*den(33)
  den(41) = den(3)*den(36)
  den(44) = den(2)*den(42)
  den(45) = den(43)*den(44)
  den(46) = den(6)*den(42)
  den(47) = den(2)*den(46)
  den(49) = den(2)*den(48)
  den(50) = den(42)*den(49)
  den(52) = den(12)*den(42)
  den(53) = den(51)*den(52)
  den(55) = den(42)*den(54)
  den(56) = den(51)*den(55)
  den(57) = den(48)*den(51)
  den(58) = den(42)*den(57)
  den(59) = den(12)*den(46)
  den(60) = den(43)*den(55)
  den(62) = den(23)*den(61)
  den(63) = den(43)*den(62)
  den(65) = den(23)*den(64)
  den(66) = den(61)*den(65)
  den(67) = den(30)*den(61)
  den(68) = den(23)*den(67)
  den(69) = den(33)*den(61)
  den(70) = den(51)*den(69)
  den(71) = den(54)*den(61)
  den(72) = den(51)*den(71)
  den(73) = den(51)*den(64)
  den(74) = den(61)*den(73)
  den(75) = den(33)*den(67)
  den(76) = den(43)*den(71)
  den(77) = den(12)*den(65)
  den(79) = den(12)*den(78)
  den(80) = den(23)*den(79)
  den(81) = den(43)*den(78)
  den(82) = den(23)*den(81)
  den(84) = den(3)*den(83)
  den(85) = den(23)*den(84)
  den(87) = den(33)*den(86)
  den(88) = den(2)*den(87)
  den(89) = den(33)*den(49)
  den(90) = den(43)*den(86)
  den(91) = den(2)*den(90)
  den(93) = den(3)*den(92)
  den(94) = den(2)*den(93)
  den(95) = den(33)*den(57)
  den(96) = den(12)*den(73)
  den(97) = den(3)*den(73)
  den(98) = den(51)*den(93)
  den(99) = den(19)*den(33)
  den(100) = den(12)*den(38)
  den(101) = den(13)*den(90)
  den(102) = den(38)*den(43)
  den(103) = den(1)*den(61)
  den(104) = den(24)*den(42)
  den(105) = den(1)*den(86)
  den(106) = den(2)*den(105)
  den(108) = den(2)*den(107)
  den(109) = den(1)*den(108)
  den(110) = den(12)*den(107)
  den(111) = den(1)*den(110)
  den(113) = den(23)*den(112)
  den(114) = den(24)*den(113)
  den(115) = den(24)*den(78)
  den(116) = den(23)*den(115)
  den(117) = den(33)*den(112)
  den(118) = den(24)*den(117)
  den(119) = den(42)*den(92)
  den(120) = den(2)*den(119)
  den(121) = den(42)*den(108)
  den(122) = den(42)*den(110)
  den(123) = den(61)*den(113)
  den(124) = den(61)*den(83)
  den(125) = den(23)*den(124)
  den(126) = den(61)*den(117)
  den(127) = den(12)*den(28)
  den(128) = den(12)*den(83)
  den(129) = den(23)*den(128)
  den(130) = den(33)*den(92)
  den(131) = den(2)*den(130)
  den(132) = den(10)*den(33)
  den(133) = den(13)*den(105)
  den(135) = den(13)*den(134)
  den(136) = den(1)*den(135)
  den(137) = den(3)*den(134)
  den(138) = den(1)*den(137)
  den(139) = den(51)*den(119)
  den(141) = den(51)*den(140)
  den(142) = den(42)*den(141)
  den(143) = den(43)*den(140)
  den(144) = den(42)*den(143)
  den(145) = den(28)*den(43)
  den(146) = den(3)*den(65)
  den(147) = den(51)*den(130)
  den(148) = den(13)*den(87)
  den(149) = den(24)*den(135)
  den(150) = den(13)*den(115)
  den(151) = den(24)*den(137)
  den(152) = den(61)*den(141)
  den(153) = den(51)*den(124)
  den(154) = den(61)*den(143)
  den(155) = den(10)*den(43)
  den(156) = den(3)*den(49)
  den(157) = den(51)*den(128)
  den(158) = den(51)*den(84)
  den(159) = den(3)*den(57)
  den(160) = den(13)*den(79)
  den(161) = den(19)*den(43)
  den(162) = den(13)*den(81)
  den(163) = den(2)*den(3)
  den(165) = den(163)*den(164)
  den(166) = den(1)*den(165)
  den(167) = den(1)*den(3)
  den(169) = den(167)*den(168)
  den(170) = den(2)*den(169)
  den(172) = den(4)*den(171)
  den(173) = den(3)*den(172)
  den(174) = den(1)**2
  den(175) = den(108)*den(174)
  den(176) = den(10)*den(174)
  den(177) = den(2)**2
  den(178) = den(105)*den(177)
  den(179) = den(7)*den(177)
  den(180) = den(7)*den(108)
  den(181) = den(10)*den(105)
  den(182) = den(12)*den(13)
  den(183) = den(164)*den(182)
  den(184) = den(1)*den(183)
  den(185) = den(1)*den(13)
  den(187) = den(185)*den(186)
  den(188) = den(12)*den(187)
  den(190) = den(14)*den(189)
  den(191) = den(13)*den(190)
  den(192) = den(135)*den(174)
  den(193) = den(19)*den(174)
  den(194) = den(13)**2
  den(195) = den(105)*den(194)
  den(196) = den(17)*den(135)
  den(197) = den(19)*den(105)
  den(198) = den(17)*den(194)
  den(199) = den(110)*den(174)
  den(200) = den(12)**2
  den(201) = den(7)*den(200)
  den(202) = den(7)*den(110)
  den(203) = den(137)*den(174)
  den(204) = den(17)*den(137)
  den(205) = den(3)**2
  den(206) = den(17)*den(205)
  den(207) = den(3)*den(24)
  den(209) = den(207)*den(208)
  den(210) = den(23)*den(209)
  den(211) = den(3)*den(23)
  den(213) = den(211)*den(212)
  den(214) = den(24)*den(213)
  den(215) = den(25)*den(171)
  den(216) = den(3)*den(215)
  den(217) = den(23)**2
  den(218) = den(115)*den(217)
  den(219) = den(31)*den(217)
  den(220) = den(24)**2
  den(221) = den(113)*den(220)
  den(222) = den(28)*den(220)
  den(223) = den(28)*den(115)
  den(224) = den(31)*den(113)
  den(225) = den(13)*den(24)
  den(227) = den(225)*den(226)
  den(228) = den(33)*den(227)
  den(229) = den(13)*den(33)
  den(230) = den(212)*den(229)
  den(231) = den(24)*den(230)
  den(232) = den(34)*den(189)
  den(233) = den(13)*den(232)
  den(234) = den(135)*den(220)
  den(235) = den(115)*den(194)
  den(236) = den(36)*den(135)
  den(237) = den(38)*den(115)
  den(238) = den(38)*den(220)
  den(239) = den(36)*den(194)
  den(240) = den(33)**2
  den(241) = den(31)*den(240)
  den(242) = den(117)*den(220)
  den(243) = den(31)*den(117)
  den(244) = den(137)*den(220)
  den(245) = den(36)*den(137)
  den(246) = den(36)*den(205)
  den(247) = den(2)*den(43)
  den(249) = den(247)*den(248)
  den(250) = den(42)*den(249)
  den(251) = den(42)*den(43)
  den(252) = den(168)*den(251)
  den(253) = den(2)*den(252)
  den(255) = den(44)*den(254)
  den(256) = den(43)*den(255)
  den(257) = den(42)**2
  den(258) = den(108)*den(257)
  den(259) = den(49)*den(257)
  den(260) = den(119)*den(177)
  den(261) = den(46)*den(177)
  den(262) = den(46)*den(108)
  den(263) = den(49)*den(119)
  den(264) = den(12)*den(51)
  den(265) = den(248)*den(264)
  den(266) = den(42)*den(265)
  den(267) = den(42)*den(51)
  den(268) = den(186)*den(267)
  den(269) = den(12)*den(268)
  den(271) = den(52)*den(270)
  den(272) = den(51)*den(271)
  den(273) = den(141)*den(257)
  den(274) = den(57)*den(257)
  den(275) = den(51)**2
  den(276) = den(119)*den(275)
  den(277) = den(55)*den(141)
  den(278) = den(57)*den(119)
  den(279) = den(55)*den(275)
  den(280) = den(110)*den(257)
  den(281) = den(46)*den(200)
  den(282) = den(46)*den(110)
  den(283) = den(143)*den(257)
  den(284) = den(55)*den(143)
  den(285) = den(43)**2
  den(286) = den(55)*den(285)
  den(287) = den(43)*den(61)
  den(288) = den(208)*den(287)
  den(289) = den(23)*den(288)
  den(290) = den(23)*den(43)
  den(292) = den(290)*den(291)
  den(293) = den(61)*den(292)
  den(294) = den(62)*den(254)
  den(295) = den(43)*den(294)
  den(296) = den(124)*den(217)
  den(297) = den(67)*den(217)
  den(298) = den(61)**2
  den(299) = den(113)*den(298)
  den(300) = den(65)*den(298)
  den(301) = den(65)*den(124)
  den(302) = den(67)*den(113)
  den(303) = den(51)*den(61)
  den(304) = den(226)*den(303)
  den(305) = den(33)*den(304)
  den(306) = den(33)*den(51)
  den(307) = den(291)*den(306)
  den(308) = den(61)*den(307)
  den(309) = den(69)*den(270)
  den(310) = den(51)*den(309)
  den(311) = den(141)*den(298)
  den(312) = den(124)*den(275)
  den(313) = den(71)*den(141)
  den(314) = den(73)*den(124)
  den(315) = den(73)*den(298)
  den(316) = den(71)*den(275)
  den(317) = den(67)*den(240)
  den(318) = den(117)*den(298)
  den(319) = den(67)*den(117)
  den(320) = den(143)*den(298)
  den(321) = den(71)*den(143)
  den(322) = den(71)*den(285)
  den(323) = den(128)*den(217)
  den(324) = den(79)*den(217)
  den(325) = den(28)*den(200)
  den(326) = den(65)*den(200)
  den(327) = den(65)*den(128)
  den(328) = den(28)*den(79)
  den(329) = den(81)*den(217)
  den(330) = den(28)*den(285)
  den(331) = den(28)*den(81)
  den(332) = den(84)*den(217)
  den(333) = den(65)*den(84)
  den(334) = den(65)*den(205)
  den(335) = den(10)*den(240)
  den(336) = den(49)*den(240)
  den(337) = den(130)*den(177)
  den(338) = den(87)*den(177)
  den(339) = den(10)*den(87)
  den(340) = den(49)*den(130)
  den(341) = den(10)*den(285)
  den(342) = den(10)*den(90)
  den(343) = den(90)*den(177)
  den(344) = den(49)*den(93)
  den(345) = den(49)*den(205)
  den(346) = den(93)*den(177)
  den(347) = den(57)*den(240)
  den(348) = den(130)*den(275)
  den(349) = den(57)*den(130)
  den(350) = den(128)*den(275)
  den(351) = den(73)*den(128)
  den(352) = den(73)*den(200)
  den(353) = den(73)*den(84)
  den(354) = den(57)*den(93)
  den(355) = den(84)*den(275)
  den(356) = den(57)*den(205)
  den(357) = den(93)*den(275)
  den(358) = den(73)*den(205)
  den(359) = den(19)*den(240)
  den(360) = den(19)*den(87)
  den(361) = den(87)*den(194)
  den(362) = den(38)*den(79)
  den(363) = den(79)*den(194)
  den(364) = den(38)*den(200)
  den(365) = den(19)*den(90)
  den(366) = den(38)*den(81)
  den(367) = den(19)*den(285)
  den(368) = den(81)*den(194)
  den(369) = den(38)*den(285)
  den(370) = den(90)*den(194)
  den(372) = den(103)*den(371)
  den(373) = den(17)*den(371)
  den(374) = den(17)*den(171)
  den(375) = den(17)*den(189)
  den(376) = den(7)*den(371)
  den(377) = den(7)*den(186)
  den(378) = den(7)*den(168)
  den(379) = den(105)*den(189)
  den(380) = den(105)*den(168)
  den(381) = den(104)*den(371)
  den(382) = den(36)*den(371)
  den(383) = den(36)*den(171)
  den(384) = den(36)*den(189)
  den(385) = den(31)*den(371)
  den(386) = den(115)*den(189)
  den(387) = den(31)*den(226)
  den(388) = den(31)*den(208)
  den(389) = den(115)*den(208)
  den(390) = den(55)*den(371)
  den(391) = den(55)*den(254)
  den(392) = den(55)*den(270)
  den(393) = den(46)*den(371)
  den(394) = den(46)*den(186)
  den(395) = den(46)*den(168)
  den(396) = den(119)*den(270)
  den(397) = den(119)*den(168)
  den(398) = den(71)*den(371)
  den(399) = den(71)*den(254)
  den(400) = den(71)*den(270)
  den(401) = den(67)*den(371)
  den(402) = den(124)*den(270)
  den(403) = den(67)*den(226)
  den(404) = den(67)*den(208)
  den(405) = den(124)*den(208)
  den(406) = den(65)*den(171)
  den(407) = den(65)*den(186)
  den(408) = den(65)*den(291)
  den(409) = den(28)*den(254)
  den(410) = den(28)*den(186)
  den(411) = den(28)*den(212)
  den(412) = den(113)*den(291)
  den(413) = den(113)*den(212)
  den(414) = den(49)*den(171)
  den(415) = den(10)*den(254)
  den(416) = den(49)*den(226)
  den(417) = den(49)*den(248)
  den(418) = den(10)*den(226)
  den(419) = den(10)*den(164)
  den(420) = den(108)*den(248)
  den(421) = den(108)*den(164)
  den(422) = den(73)*den(171)
  den(423) = den(57)*den(171)
  den(424) = den(73)*den(186)
  den(425) = den(73)*den(291)
  den(426) = den(141)*den(291)
  den(427) = den(57)*den(226)
  den(428) = den(57)*den(248)
  den(429) = den(141)*den(248)
  den(430) = den(38)*den(254)
  den(431) = den(19)*den(254)
  den(432) = den(38)*den(186)
  den(433) = den(38)*den(212)
  den(434) = den(135)*den(212)
  den(435) = den(19)*den(226)
  den(436) = den(19)*den(164)
  den(437) = den(135)*den(164)
  den(438) = den(87)*den(189)
  den(439) = den(87)*den(168)
  den(440) = den(130)*den(270)
  den(441) = den(130)*den(168)
  den(442) = den(117)*den(291)
  den(443) = den(117)*den(212)
  den(444) = den(79)*den(189)
  den(445) = den(128)*den(270)
  den(446) = den(79)*den(208)
  den(447) = den(128)*den(208)
  den(448) = den(110)*den(248)
  den(449) = den(110)*den(164)
  den(450) = den(90)*den(189)
  den(451) = den(81)*den(189)
  den(452) = den(90)*den(168)
  den(453) = den(143)*den(291)
  den(454) = den(81)*den(208)
  den(455) = den(143)*den(248)
  den(456) = den(93)*den(270)
  den(457) = den(84)*den(270)
  den(458) = den(93)*den(168)
  den(459) = den(137)*den(212)
  den(460) = den(84)*den(208)
  den(461) = den(137)*den(164)
  den(462) = den(61)*den(105)
  den(463) = den(1)*den(124)
  den(464) = den(1)*den(2)*den(3)
  den(465) = den(1)*den(12)*den(13)
  den(466) = den(1)*den(128)
  den(467) = den(1)*den(84)
  den(468) = den(24)*den(119)
  den(469) = den(42)*den(115)
  den(470) = den(3)*den(23)*den(24)
  den(471) = den(13)*den(24)*den(33)
  den(472) = den(24)*den(130)
  den(473) = den(24)*den(93)
  den(474) = den(2)*den(42)*den(43)
  den(475) = den(12)*den(42)*den(51)
  den(476) = den(42)*den(79)
  den(477) = den(42)*den(81)
  den(478) = den(23)*den(43)*den(61)
  den(479) = den(33)*den(51)*den(61)
  den(480) = den(61)*den(87)
  den(481) = den(61)*den(90)
  den(482) = den(12)*den(23)
  den(483) = den(2)*den(33)
  den(484) = den(3)*den(51)
  den(485) = den(13)*den(43)
  den(486) = den(2)*den(378)
  den(487) = den(2)*den(380)
  den(488) = den(1)*den(419)
  den(489) = den(1)*den(421)
  den(490) = den(13)*den(375)
  den(491) = den(13)*den(379)
  den(492) = den(1)*den(436)
  den(493) = den(1)*den(437)
  den(494) = den(12)*den(377)
  den(495) = den(1)*den(449)
  den(496) = den(3)*den(374)
  den(497) = den(1)*den(461)
  den(498) = den(24)*den(411)
  den(499) = den(24)*den(413)
  den(500) = den(23)*den(388)
  den(501) = den(23)*den(389)
  den(502) = den(13)*den(384)
  den(503) = den(24)*den(433)
  den(504) = den(13)*den(386)
  den(505) = den(24)*den(434)
  den(506) = den(24)*den(443)
  den(507) = den(33)*den(387)
  den(508) = den(3)*den(383)
  den(509) = den(24)*den(459)
  den(510) = den(2)*den(395)
  den(511) = den(2)*den(397)
  den(512) = den(42)*den(417)
  den(513) = den(42)*den(420)
  den(514) = den(51)*den(392)
  den(515) = den(51)*den(396)
  den(516) = den(42)*den(428)
  den(517) = den(42)*den(429)
  den(518) = den(12)*den(394)
  den(519) = den(42)*den(448)
  den(520) = den(43)*den(391)
  den(521) = den(42)*den(455)
  den(522) = den(61)*den(408)
  den(523) = den(61)*den(412)
  den(524) = den(23)*den(404)
  den(525) = den(23)*den(405)
  den(526) = den(51)*den(400)
  den(527) = den(61)*den(425)
  den(528) = den(51)*den(402)
  den(529) = den(61)*den(426)
  den(530) = den(61)*den(442)
  den(531) = den(33)*den(403)
  den(532) = den(43)*den(399)
  den(533) = den(61)*den(453)
  den(534) = den(12)*den(407)
  den(535) = den(12)*den(410)
  den(536) = den(23)*den(446)
  den(537) = den(23)*den(447)
  den(538) = den(43)*den(409)
  den(539) = den(23)*den(454)
  den(540) = den(3)*den(406)
  den(541) = den(23)*den(460)
  den(542) = den(2)*den(439)
  den(543) = den(2)*den(441)
  den(544) = den(33)*den(416)
  den(545) = den(33)*den(418)
  den(546) = den(2)*den(452)
  den(547) = den(43)*den(415)
  den(548) = den(2)*den(458)
  den(549) = den(3)*den(414)
  den(550) = den(51)*den(440)
  den(551) = den(33)*den(427)
  den(552) = den(12)*den(424)
  den(553) = den(51)*den(445)
  den(554) = den(3)*den(422)
  den(555) = den(51)*den(456)
  den(556) = den(3)*den(423)
  den(557) = den(51)*den(457)
  den(558) = den(13)*den(438)
  den(559) = den(33)*den(435)
  den(560) = den(12)*den(432)
  den(561) = den(13)*den(444)
  den(562) = den(13)*den(450)
  den(563) = den(43)*den(430)
  den(564) = den(13)*den(451)
  den(565) = den(43)*den(431)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,388))
  allocate(M1helarray(4,hel_states))
  allocate(M1helarray_ct(4,hel_states))
  allocate(M0_col1_helarray(4,hel_states))
  A(1:hel_states,1:388)%j = 0
  A(1:hel_states,1:388)%e = 0
  A(1:hel_states,1:388)%hf = 0
  A(1:hel_states,1:388)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(4,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up up anti-up anti-up gamma glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppajjj_uuuxuxag_2, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppajjj_uuuxuxag_2, only: &
    & external_perm_ppajjj_uuuxuxag_2, &
    & external_perm_inv_ppajjj_uuuxuxag_2, &
    & extcomb_perm_ppajjj_uuuxuxag_2, &
    & average_factor_ppajjj_uuuxuxag_2
  use ol_external_ppajjj_uuuxuxag_2, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppajjj_uuuxuxag_2_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppajjj_uuuxuxag_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,388))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppajjj_uuuxuxag_2, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,2), 18, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call prop_A_Q(ntry, wf4(:,3), 40, ZERO, 0_intkind1, wf4(:,5), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex6(:), wf4(:,4), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 13, ZERO, 0_intkind1, wf8(:,3), n2(3))
  call vert_QA_V(ntry, wf4(:,4), ex4(:), wf8(:,4), n3(:,7), t3x8(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 5, ex6(:), 32, wf8(:,5), n3(:,8), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex6(:), ex2(:), wf4(:,6), n3(:,9), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,7), n3(:,10), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,6), 34, ZERO, 0_intkind1, wf4(:,8), n2(4))
  call prop_A_Q(ntry, wf4(:,7), 24, ZERO, 0_intkind1, wf4(:,9), n2(5))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,2), n3(:,11), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,6), n3(:,12), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,7), n3(:,13), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,6), 7, ZERO, 0_intkind1, wf8(:,8), n2(6))
  call vert_QA_V(ntry, ex2(:), wf4(:,9), wf8(:,9), n3(:,14), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex5(:), wf4(:,8), wf8(:,10), n3(:,15), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,11), n3(:,16), t3x8(:,:,9))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,10), n3(:,17), t3x4(:,:,6))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,11), n3(:,18), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,10), 17, ZERO, 0_intkind1, wf4(:,12), n2(7))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,12), wf16(:,3), n3(:,19), t3x16(:,:,3))
  call vert_QA_V(ntry, wf4(:,12), ex4(:), wf8(:,12), n3(:,20), t3x8(:,:,10))
  call vert_UV_W(ntry, wf4(:,11), 6, ex6(:), 32, wf8(:,13), n3(:,21), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,14), n3(:,22), t3x8(:,:,12))
  call vert_VQ_A(ntry, ex6(:), wf4(:,12), wf8(:,15), n3(:,23), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,14), 14, ZERO, 0_intkind1, wf8(:,16), n2(8))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,13), n3(:,24), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,13), 33, ZERO, 0_intkind1, wf4(:,14), n2(9))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,14), wf16(:,4), n3(:,25), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,11), ex1(:), wf8(:,17), n3(:,26), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,17), 7, ZERO, 0_intkind1, wf8(:,18), n2(10))
  call vert_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,19), n3(:,27), t3x8(:,:,15))
  call vert_VQ_A(ntry, ex5(:), wf4(:,14), wf8(:,20), n3(:,28), t3x8(:,:,16))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,15), n3(:,29), t3x4(:,:,9))
  call vert_AV_Q(ntry, ex3(:), ex6(:), wf4(:,16), n3(:,30), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,16), 36, ZERO, 0_intkind1, wf4(:,17), n2(11))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,4), wf16(:,5), n3(:,31), t3x16(:,:,5))
  call vert_AV_Q(ntry, ex3(:), wf4(:,15), wf8(:,21), n3(:,32), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,21), 13, ZERO, 0_intkind1, wf8(:,22), n2(12))
  call vert_QA_V(ntry, wf4(:,4), ex3(:), wf8(:,23), n3(:,33), t3x8(:,:,18))
  call vert_UV_W(ntry, wf4(:,15), 9, ex6(:), 32, wf8(:,24), n3(:,34), t3x8(:,:,19))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,18), n3(:,35), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,18), 20, ZERO, 0_intkind1, wf4(:,19), n2(13))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,8), wf16(:,6), n3(:,36), t3x16(:,:,6))
  call vert_VQ_A(ntry, wf4(:,15), ex2(:), wf8(:,25), n3(:,37), t3x8(:,:,20))
  call vert_AV_Q(ntry, wf4(:,19), ex6(:), wf8(:,26), n3(:,38), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,25), 11, ZERO, 0_intkind1, wf8(:,27), n2(14))
  call vert_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,28), n3(:,39), t3x8(:,:,22))
  call vert_AV_Q(ntry, wf4(:,17), ex5(:), wf8(:,29), n3(:,40), t3x8(:,:,23))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,20), n3(:,41), t3x4(:,:,12))
  call vert_VQ_A(ntry, wf4(:,20), wf4(:,12), wf16(:,7), n3(:,42), t3x16(:,:,7))
  call vert_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,30), n3(:,43), t3x8(:,:,24))
  call vert_UV_W(ntry, wf4(:,20), 10, ex6(:), 32, wf8(:,31), n3(:,44), t3x8(:,:,25))
  call vert_AV_Q(ntry, ex3(:), wf4(:,20), wf8(:,32), n3(:,45), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,32), 14, ZERO, 0_intkind1, wf8(:,33), n2(15))
  call vert_VQ_A(ntry, wf4(:,20), wf4(:,14), wf16(:,8), n3(:,46), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,20), ex1(:), wf8(:,34), n3(:,47), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,34), 11, ZERO, 0_intkind1, wf8(:,35), n2(16))
  call vert_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,36), n3(:,48), t3x8(:,:,28))
  call vert_QA_V(ntry, wf4(:,8), ex4(:), wf8(:,37), n3(:,49), t3x8(:,:,29))
  call vert_QA_V(ntry, wf4(:,8), ex3(:), wf8(:,38), n3(:,50), t3x8(:,:,30))
  call vert_QA_V(ntry, ex2(:), wf4(:,17), wf8(:,39), n3(:,51), t3x8(:,:,31))
  call vert_QA_V(ntry, ex2(:), wf4(:,5), wf8(:,40), n3(:,52), t3x8(:,:,32))
  call vert_QA_V(ntry, wf4(:,14), ex3(:), wf8(:,41), n3(:,53), t3x8(:,:,33))
  call vert_QA_V(ntry, wf4(:,14), ex4(:), wf8(:,42), n3(:,54), t3x8(:,:,34))
  call vert_QA_V(ntry, ex1(:), wf4(:,17), wf8(:,43), n3(:,55), t3x8(:,:,35))
  call vert_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,44), n3(:,56), t3x8(:,:,36))
  call counter_VGG_G(ctAGGG,ntry, ex5(:), wf4(:,1), ex6(:), wf16(:,9), n4(:,1), t4x16(:,:,1))
  call counter_VGG_G(ctAGGG,ntry, ex5(:), ex6(:), wf4(:,1), wf16(:,10), n4(:,2), t4x16(:,:,2))
  call counter_VGG_G(ctAGGG,ntry, ex5(:), wf4(:,15), ex6(:), wf16(:,11), n4(:,3), t4x16(:,:,3))
  call counter_VGG_G(ctAGGG,ntry, ex5(:), ex6(:), wf4(:,15), wf16(:,12), n4(:,4), t4x16(:,:,4))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,13), n3(:,57), t3x16(:,:,9))
  call counter_VQ_A(ntry, ex6(:), wf4(:,4), wf8(:,45), n3(:,58), t3x8(:,:,37))
  call counter_UV_W(ntry, wf4(:,1), 5, ex6(:), 32, wf8(:,46), n3(:,59), t3x8(:,:,38))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,14), n3(:,60), t3x16(:,:,10))
  call counter_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,47), n3(:,61), t3x8(:,:,39))
  call counter_VQ_A(ntry, ex5(:), wf4(:,8), wf8(:,48), n3(:,62), t3x8(:,:,40))
  call counter_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,49), n3(:,63), t3x8(:,:,41))
  call counter_QA_V(ntry, wf4(:,4), ex4(:), wf8(:,50), n3(:,64), t3x8(:,:,42))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,51), n3(:,65), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,2), 50, ZERO, 0_intkind1, wf8(:,52), n2(17))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,21), n3(:,66), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,21), 40, ZERO, 0_intkind1, wf4(:,22), n2(18))
  call prop_Q_A(ntry, wf8(:,10), 50, ZERO, 0_intkind1, wf8(:,53), n2(19))
  call vert_AV_Q(ntry, wf4(:,22), ex5(:), wf8(:,54), n3(:,67), t3x8(:,:,44))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,23), n3(:,68), t3x4(:,:,14))
  call prop_A_Q(ntry, wf4(:,23), 24, ZERO, 0_intkind1, wf4(:,24), n2(20))
  call vert_AV_Q(ntry, wf4(:,24), ex6(:), wf8(:,55), n3(:,69), t3x8(:,:,45))
  call vert_QA_V(ntry, ex2(:), wf4(:,24), wf8(:,56), n3(:,70), t3x8(:,:,46))
  call counter_VQ_A(ntry, wf4(:,11), wf4(:,12), wf16(:,15), n3(:,71), t3x16(:,:,11))
  call counter_UV_W(ntry, wf4(:,11), 6, ex6(:), 32, wf8(:,57), n3(:,72), t3x8(:,:,47))
  call counter_VQ_A(ntry, ex6(:), wf4(:,12), wf8(:,58), n3(:,73), t3x8(:,:,48))
  call counter_VQ_A(ntry, wf4(:,11), wf4(:,14), wf16(:,16), n3(:,74), t3x16(:,:,12))
  call counter_VQ_A(ntry, ex5(:), wf4(:,14), wf8(:,59), n3(:,75), t3x8(:,:,49))
  call counter_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,60), n3(:,76), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,15), 49, ZERO, 0_intkind1, wf8(:,61), n2(21))
  call counter_QA_V(ntry, wf4(:,12), ex4(:), wf8(:,62), n3(:,77), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,20), 49, ZERO, 0_intkind1, wf8(:,63), n2(22))
  call vert_QA_V(ntry, ex1(:), wf4(:,24), wf8(:,64), n3(:,78), t3x8(:,:,52))
  call counter_VQ_A(ntry, wf4(:,15), wf4(:,4), wf16(:,17), n3(:,79), t3x16(:,:,13))
  call counter_UV_W(ntry, wf4(:,15), 9, ex6(:), 32, wf8(:,65), n3(:,80), t3x8(:,:,53))
  call counter_VQ_A(ntry, wf4(:,15), wf4(:,8), wf16(:,18), n3(:,81), t3x16(:,:,14))
  call counter_AV_Q(ntry, wf4(:,19), ex6(:), wf8(:,66), n3(:,82), t3x8(:,:,54))
  call counter_AV_Q(ntry, wf4(:,17), ex5(:), wf8(:,67), n3(:,83), t3x8(:,:,55))
  call counter_VQ_A(ntry, wf4(:,20), wf4(:,12), wf16(:,19), n3(:,84), t3x16(:,:,15))
  call counter_UV_W(ntry, wf4(:,20), 10, ex6(:), 32, wf8(:,68), n3(:,85), t3x8(:,:,56))
  call counter_VQ_A(ntry, wf4(:,20), wf4(:,14), wf16(:,20), n3(:,86), t3x16(:,:,16))
  call counter_QA_V(ntry, wf4(:,8), ex4(:), wf8(:,69), n3(:,87), t3x8(:,:,57))
  call vert_QA_V(ntry, ex2(:), wf4(:,22), wf8(:,70), n3(:,88), t3x8(:,:,58))
  call counter_QA_V(ntry, wf4(:,14), ex4(:), wf8(:,71), n3(:,89), t3x8(:,:,59))
  call vert_QA_V(ntry, ex1(:), wf4(:,22), wf8(:,72), n3(:,90), t3x8(:,:,60))
  call counter_QA_V(ntry, wf4(:,4), ex3(:), wf8(:,73), n3(:,91), t3x8(:,:,61))
  call counter_AV_Q(ntry, ex3(:), wf4(:,15), wf8(:,74), n3(:,92), t3x8(:,:,62))
  call counter_AV_Q(ntry, ex3(:), ex6(:), wf4(:,25), n3(:,93), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,25), 36, ZERO, 0_intkind1, wf4(:,26), n2(23))
  call vert_AV_Q(ntry, wf4(:,26), ex5(:), wf8(:,75), n3(:,94), t3x8(:,:,63))
  call counter_AV_Q(ntry, ex3(:), ex5(:), wf4(:,27), n3(:,95), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,27), 20, ZERO, 0_intkind1, wf4(:,28), n2(24))
  call vert_AV_Q(ntry, wf4(:,28), ex6(:), wf8(:,76), n3(:,96), t3x8(:,:,64))
  call vert_QA_V(ntry, ex2(:), wf4(:,28), wf8(:,77), n3(:,97), t3x8(:,:,65))
  call counter_AV_Q(ntry, ex3(:), wf4(:,20), wf8(:,78), n3(:,98), t3x8(:,:,66))
  call counter_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,79), n3(:,99), t3x8(:,:,67))
  call vert_QA_V(ntry, ex1(:), wf4(:,28), wf8(:,80), n3(:,100), t3x8(:,:,68))
  call counter_QA_V(ntry, wf4(:,8), ex3(:), wf8(:,81), n3(:,101), t3x8(:,:,69))
  call vert_QA_V(ntry, ex2(:), wf4(:,26), wf8(:,82), n3(:,102), t3x8(:,:,70))
  call counter_QA_V(ntry, wf4(:,14), ex3(:), wf8(:,83), n3(:,103), t3x8(:,:,71))
  call vert_QA_V(ntry, ex1(:), wf4(:,26), wf8(:,84), n3(:,104), t3x8(:,:,72))
  call counter_QA_V(ntry, ex2(:), wf4(:,9), wf8(:,85), n3(:,105), t3x8(:,:,73))
  call counter_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,86), n3(:,106), t3x8(:,:,74))
  call prop_A_Q(ntry, wf8(:,7), 56, ZERO, 0_intkind1, wf8(:,87), n2(25))
  call counter_VQ_A(ntry, ex6(:), ex2(:), wf4(:,29), n3(:,107), t3x4(:,:,17))
  call prop_Q_A(ntry, wf4(:,29), 34, ZERO, 0_intkind1, wf4(:,30), n2(26))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,30), wf16(:,21), n3(:,108), t3x16(:,:,17))
  call prop_A_Q(ntry, wf8(:,11), 56, ZERO, 0_intkind1, wf8(:,88), n2(27))
  call vert_VQ_A(ntry, ex5(:), wf4(:,30), wf8(:,89), n3(:,109), t3x8(:,:,75))
  call counter_VQ_A(ntry, ex5(:), ex2(:), wf4(:,31), n3(:,110), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,31), 18, ZERO, 0_intkind1, wf4(:,32), n2(28))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,32), wf16(:,22), n3(:,111), t3x16(:,:,18))
  call vert_VQ_A(ntry, ex6(:), wf4(:,32), wf8(:,90), n3(:,112), t3x8(:,:,76))
  call vert_QA_V(ntry, wf4(:,32), ex4(:), wf8(:,91), n3(:,113), t3x8(:,:,77))
  call counter_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,92), n3(:,114), t3x8(:,:,78))
  call counter_VQ_A(ntry, wf4(:,15), ex2(:), wf8(:,93), n3(:,115), t3x8(:,:,79))
  call prop_A_Q(ntry, wf8(:,26), 52, ZERO, 0_intkind1, wf8(:,94), n2(29))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,30), wf16(:,23), n3(:,116), t3x16(:,:,19))
  call prop_A_Q(ntry, wf8(:,29), 52, ZERO, 0_intkind1, wf8(:,95), n2(30))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,32), wf16(:,24), n3(:,117), t3x16(:,:,20))
  call vert_QA_V(ntry, wf4(:,32), ex3(:), wf8(:,96), n3(:,118), t3x8(:,:,80))
  call counter_QA_V(ntry, ex2(:), wf4(:,17), wf8(:,97), n3(:,119), t3x8(:,:,81))
  call counter_QA_V(ntry, ex2(:), wf4(:,5), wf8(:,98), n3(:,120), t3x8(:,:,82))
  call vert_QA_V(ntry, wf4(:,30), ex4(:), wf8(:,99), n3(:,121), t3x8(:,:,83))
  call vert_QA_V(ntry, wf4(:,30), ex3(:), wf8(:,100), n3(:,122), t3x8(:,:,84))
  call counter_QA_V(ntry, ex2(:), ex4(:), wf4(:,33), n3(:,123), t3x4(:,:,19))
  call vert_VQ_A(ntry, wf4(:,33), wf4(:,12), wf16(:,25), n3(:,124), t3x16(:,:,21))
  call vert_UV_W(ntry, wf4(:,33), 10, ex6(:), 32, wf8(:,101), n3(:,125), t3x8(:,:,85))
  call vert_AV_Q(ntry, ex3(:), wf4(:,33), wf8(:,102), n3(:,126), t3x8(:,:,86))
  call prop_A_Q(ntry, wf8(:,102), 14, ZERO, 0_intkind1, wf8(:,103), n2(31))
  call vert_VQ_A(ntry, wf4(:,33), wf4(:,14), wf16(:,26), n3(:,127), t3x16(:,:,22))
  call vert_VQ_A(ntry, wf4(:,33), ex1(:), wf8(:,104), n3(:,128), t3x8(:,:,87))
  call prop_Q_A(ntry, wf8(:,104), 11, ZERO, 0_intkind1, wf8(:,105), n2(32))
  call counter_QA_V(ntry, ex2(:), ex3(:), wf4(:,34), n3(:,129), t3x4(:,:,20))
  call vert_VQ_A(ntry, wf4(:,34), wf4(:,12), wf16(:,27), n3(:,130), t3x16(:,:,23))
  call vert_UV_W(ntry, wf4(:,34), 6, ex6(:), 32, wf8(:,106), n3(:,131), t3x8(:,:,88))
  call vert_AV_Q(ntry, ex4(:), wf4(:,34), wf8(:,107), n3(:,132), t3x8(:,:,89))
  call prop_A_Q(ntry, wf8(:,107), 14, ZERO, 0_intkind1, wf8(:,108), n2(33))
  call vert_VQ_A(ntry, wf4(:,34), wf4(:,14), wf16(:,28), n3(:,133), t3x16(:,:,24))
  call vert_VQ_A(ntry, wf4(:,34), ex1(:), wf8(:,109), n3(:,134), t3x8(:,:,90))
  call prop_Q_A(ntry, wf8(:,109), 7, ZERO, 0_intkind1, wf8(:,110), n2(34))
  call counter_VQ_A(ntry, wf4(:,11), ex1(:), wf8(:,111), n3(:,135), t3x8(:,:,91))
  call counter_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,112), n3(:,136), t3x8(:,:,92))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,35), n3(:,137), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,35), 33, ZERO, 0_intkind1, wf4(:,36), n2(35))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,36), wf16(:,29), n3(:,138), t3x16(:,:,25))
  call vert_VQ_A(ntry, ex5(:), wf4(:,36), wf8(:,113), n3(:,139), t3x8(:,:,93))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,37), n3(:,140), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,37), 17, ZERO, 0_intkind1, wf4(:,38), n2(36))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,38), wf16(:,30), n3(:,141), t3x16(:,:,26))
  call vert_QA_V(ntry, wf4(:,38), ex4(:), wf8(:,114), n3(:,142), t3x8(:,:,94))
  call vert_VQ_A(ntry, ex6(:), wf4(:,38), wf8(:,115), n3(:,143), t3x8(:,:,95))
  call counter_VQ_A(ntry, wf4(:,20), ex1(:), wf8(:,116), n3(:,144), t3x8(:,:,96))
  call counter_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,117), n3(:,145), t3x8(:,:,97))
  call vert_VQ_A(ntry, wf4(:,20), wf4(:,36), wf16(:,31), n3(:,146), t3x16(:,:,27))
  call vert_VQ_A(ntry, wf4(:,20), wf4(:,38), wf16(:,32), n3(:,147), t3x16(:,:,28))
  call vert_QA_V(ntry, wf4(:,38), ex3(:), wf8(:,118), n3(:,148), t3x8(:,:,98))
  call counter_QA_V(ntry, ex1(:), wf4(:,17), wf8(:,119), n3(:,149), t3x8(:,:,99))
  call counter_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,120), n3(:,150), t3x8(:,:,100))
  call vert_QA_V(ntry, wf4(:,36), ex3(:), wf8(:,121), n3(:,151), t3x8(:,:,101))
  call vert_QA_V(ntry, wf4(:,36), ex4(:), wf8(:,122), n3(:,152), t3x8(:,:,102))
  call counter_QA_V(ntry, ex1(:), ex4(:), wf4(:,39), n3(:,153), t3x4(:,:,23))
  call vert_VQ_A(ntry, wf4(:,39), wf4(:,4), wf16(:,33), n3(:,154), t3x16(:,:,29))
  call vert_AV_Q(ntry, ex3(:), wf4(:,39), wf8(:,123), n3(:,155), t3x8(:,:,103))
  call prop_A_Q(ntry, wf8(:,123), 13, ZERO, 0_intkind1, wf8(:,124), n2(37))
  call vert_UV_W(ntry, wf4(:,39), 9, ex6(:), 32, wf8(:,125), n3(:,156), t3x8(:,:,104))
  call vert_VQ_A(ntry, wf4(:,39), wf4(:,8), wf16(:,34), n3(:,157), t3x16(:,:,30))
  call vert_VQ_A(ntry, wf4(:,39), ex2(:), wf8(:,126), n3(:,158), t3x8(:,:,105))
  call prop_Q_A(ntry, wf8(:,126), 11, ZERO, 0_intkind1, wf8(:,127), n2(38))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,40), n3(:,159), t3x4(:,:,24))
  call vert_VQ_A(ntry, wf4(:,40), wf4(:,4), wf16(:,35), n3(:,160), t3x16(:,:,31))
  call vert_AV_Q(ntry, ex4(:), wf4(:,40), wf8(:,128), n3(:,161), t3x8(:,:,106))
  call prop_A_Q(ntry, wf8(:,128), 13, ZERO, 0_intkind1, wf8(:,129), n2(39))
  call vert_UV_W(ntry, wf4(:,40), 5, ex6(:), 32, wf8(:,130), n3(:,162), t3x8(:,:,107))
  call vert_VQ_A(ntry, wf4(:,40), wf4(:,8), wf16(:,36), n3(:,163), t3x16(:,:,32))
  call vert_VQ_A(ntry, wf4(:,40), ex2(:), wf8(:,131), n3(:,164), t3x8(:,:,108))
  call prop_Q_A(ntry, wf8(:,131), 7, ZERO, 0_intkind1, wf8(:,132), n2(40))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,5), wf16(:,37), n3(:,165), t3x16(:,:,33))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 5, wf4(:,41), n2(41))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,1), wf16(:,38), n3(:,166), t3x16(:,:,34))
  call counter_Q_A(ctqq,2,ntry, wf4(:,4), 18, wf4(:,42), n2(42))
  call prop_A_Q(ntry, wf16(:,38), 45, ZERO, 0_intkind1, wf16(:,39), n2(43))
  call counter_A_Q(ctqq,2,ntry, wf4(:,5), 40, wf4(:,43), n2(44))
  call prop_Q_A(ntry, wf16(:,1), 23, ZERO, 0_intkind1, wf16(:,40), n2(45))
  call vert_AV_Q(ntry, ex4(:), wf4(:,41), wf8(:,133), n3(:,167), t3x8(:,:,109))
  call vert_UV_W(ntry, wf4(:,41), 5, ex6(:), 32, wf8(:,134), n3(:,168), t3x8(:,:,110))
  call prop_Q_A(ntry, wf4(:,42), 18, ZERO, 0_intkind1, wf4(:,44), n2(46))
  call vert_QA_V(ntry, wf4(:,44), ex4(:), wf8(:,135), n3(:,169), t3x8(:,:,111))
  call vert_VQ_A(ntry, ex6(:), wf4(:,44), wf8(:,136), n3(:,170), t3x8(:,:,112))
  call counter_A_Q(ctqq,2,ntry, wf8(:,3), 13, wf8(:,137), n2(47))
  call counter_V_V(ctGG,21,ntry, wf8(:,4), 26, wf8(:,138), n2(48))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,9), wf16(:,41), n3(:,171), t3x16(:,:,35))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,1), wf16(:,42), n3(:,172), t3x16(:,:,36))
  call counter_Q_A(ctqq,2,ntry, wf4(:,8), 34, wf4(:,45), n2(49))
  call prop_A_Q(ntry, wf16(:,42), 29, ZERO, 0_intkind1, wf16(:,43), n2(50))
  call counter_A_Q(ctqq,2,ntry, wf4(:,9), 24, wf4(:,46), n2(51))
  call prop_Q_A(ntry, wf16(:,2), 39, ZERO, 0_intkind1, wf16(:,44), n2(52))
  call vert_VQ_A(ntry, wf4(:,41), ex2(:), wf8(:,139), n3(:,173), t3x8(:,:,113))
  call prop_A_Q(ntry, wf4(:,46), 24, ZERO, 0_intkind1, wf4(:,47), n2(53))
  call vert_QA_V(ntry, ex2(:), wf4(:,47), wf8(:,140), n3(:,174), t3x8(:,:,114))
  call counter_Q_A(ctqq,2,ntry, wf8(:,8), 7, wf8(:,141), n2(54))
  call counter_V_V(ctGG,21,ntry, wf8(:,9), 26, wf8(:,142), n2(55))
  call vert_AV_Q(ntry, wf4(:,47), ex6(:), wf8(:,143), n3(:,175), t3x8(:,:,115))
  call prop_Q_A(ntry, wf4(:,45), 34, ZERO, 0_intkind1, wf4(:,48), n2(56))
  call vert_VQ_A(ntry, ex5(:), wf4(:,48), wf8(:,144), n3(:,176), t3x8(:,:,116))
  call prop_A_Q(ntry, wf4(:,43), 40, ZERO, 0_intkind1, wf4(:,49), n2(57))
  call vert_AV_Q(ntry, wf4(:,49), ex5(:), wf8(:,145), n3(:,177), t3x8(:,:,117))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,11), wf16(:,45), n3(:,178), t3x16(:,:,37))
  call counter_Q_A(ctqq,2,ntry, wf4(:,12), 17, wf4(:,50), n2(58))
  call prop_A_Q(ntry, wf16(:,45), 46, ZERO, 0_intkind1, wf16(:,46), n2(59))
  call vert_QA_V(ntry, wf4(:,12), wf4(:,5), wf16(:,47), n3(:,179), t3x16(:,:,38))
  call counter_V_V(ctGG,21,ntry, wf4(:,11), 6, wf4(:,51), n2(60))
  call prop_Q_A(ntry, wf16(:,3), 23, ZERO, 0_intkind1, wf16(:,48), n2(61))
  call prop_Q_A(ntry, wf4(:,50), 17, ZERO, 0_intkind1, wf4(:,52), n2(62))
  call vert_QA_V(ntry, wf4(:,52), ex4(:), wf8(:,146), n3(:,180), t3x8(:,:,118))
  call vert_VQ_A(ntry, ex6(:), wf4(:,52), wf8(:,147), n3(:,181), t3x8(:,:,119))
  call vert_AV_Q(ntry, ex4(:), wf4(:,51), wf8(:,148), n3(:,182), t3x8(:,:,120))
  call vert_UV_W(ntry, wf4(:,51), 6, ex6(:), 32, wf8(:,149), n3(:,183), t3x8(:,:,121))
  call counter_V_V(ctGG,21,ntry, wf8(:,12), 25, wf8(:,150), n2(63))
  call counter_A_Q(ctqq,2,ntry, wf8(:,16), 14, wf8(:,151), n2(64))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,11), wf16(:,49), n3(:,184), t3x16(:,:,39))
  call counter_Q_A(ctqq,2,ntry, wf4(:,14), 33, wf4(:,53), n2(65))
  call prop_A_Q(ntry, wf16(:,49), 30, ZERO, 0_intkind1, wf16(:,50), n2(66))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,9), wf16(:,51), n3(:,185), t3x16(:,:,40))
  call prop_Q_A(ntry, wf16(:,4), 39, ZERO, 0_intkind1, wf16(:,52), n2(67))
  call vert_VQ_A(ntry, wf4(:,51), ex1(:), wf8(:,152), n3(:,186), t3x8(:,:,122))
  call vert_QA_V(ntry, ex1(:), wf4(:,47), wf8(:,153), n3(:,187), t3x8(:,:,123))
  call counter_Q_A(ctqq,2,ntry, wf8(:,18), 7, wf8(:,154), n2(68))
  call counter_V_V(ctGG,21,ntry, wf8(:,19), 25, wf8(:,155), n2(69))
  call prop_Q_A(ntry, wf4(:,53), 33, ZERO, 0_intkind1, wf4(:,54), n2(70))
  call vert_VQ_A(ntry, ex5(:), wf4(:,54), wf8(:,156), n3(:,188), t3x8(:,:,124))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,17), wf16(:,53), n3(:,189), t3x16(:,:,41))
  call counter_V_V(ctGG,21,ntry, wf4(:,15), 9, wf4(:,55), n2(71))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,15), wf16(:,54), n3(:,190), t3x16(:,:,42))
  call prop_A_Q(ntry, wf16(:,54), 45, ZERO, 0_intkind1, wf16(:,55), n2(72))
  call counter_A_Q(ctqq,2,ntry, wf4(:,17), 36, wf4(:,56), n2(73))
  call prop_Q_A(ntry, wf16(:,5), 27, ZERO, 0_intkind1, wf16(:,56), n2(74))
  call vert_AV_Q(ntry, ex3(:), wf4(:,55), wf8(:,157), n3(:,191), t3x8(:,:,125))
  call vert_UV_W(ntry, wf4(:,55), 9, ex6(:), 32, wf8(:,158), n3(:,192), t3x8(:,:,126))
  call vert_QA_V(ntry, wf4(:,44), ex3(:), wf8(:,159), n3(:,193), t3x8(:,:,127))
  call counter_A_Q(ctqq,2,ntry, wf8(:,22), 13, wf8(:,160), n2(75))
  call counter_V_V(ctGG,21,ntry, wf8(:,23), 22, wf8(:,161), n2(76))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,19), wf16(:,57), n3(:,194), t3x16(:,:,43))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,15), wf16(:,58), n3(:,195), t3x16(:,:,44))
  call prop_A_Q(ntry, wf16(:,58), 29, ZERO, 0_intkind1, wf16(:,59), n2(77))
  call counter_A_Q(ctqq,2,ntry, wf4(:,19), 20, wf4(:,57), n2(78))
  call prop_Q_A(ntry, wf16(:,6), 43, ZERO, 0_intkind1, wf16(:,60), n2(79))
  call vert_VQ_A(ntry, wf4(:,55), ex2(:), wf8(:,162), n3(:,196), t3x8(:,:,128))
  call prop_A_Q(ntry, wf4(:,57), 20, ZERO, 0_intkind1, wf4(:,58), n2(80))
  call vert_QA_V(ntry, ex2(:), wf4(:,58), wf8(:,163), n3(:,197), t3x8(:,:,129))
  call counter_Q_A(ctqq,2,ntry, wf8(:,27), 11, wf8(:,164), n2(81))
  call counter_V_V(ctGG,21,ntry, wf8(:,28), 22, wf8(:,165), n2(82))
  call vert_AV_Q(ntry, wf4(:,58), ex6(:), wf8(:,166), n3(:,198), t3x8(:,:,130))
  call prop_A_Q(ntry, wf4(:,56), 36, ZERO, 0_intkind1, wf4(:,59), n2(83))
  call vert_AV_Q(ntry, wf4(:,59), ex5(:), wf8(:,167), n3(:,199), t3x8(:,:,131))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,20), wf16(:,61), n3(:,200), t3x16(:,:,45))
  call prop_A_Q(ntry, wf16(:,61), 46, ZERO, 0_intkind1, wf16(:,62), n2(84))
  call vert_QA_V(ntry, wf4(:,12), wf4(:,17), wf16(:,63), n3(:,201), t3x16(:,:,46))
  call counter_V_V(ctGG,21,ntry, wf4(:,20), 10, wf4(:,60), n2(85))
  call prop_Q_A(ntry, wf16(:,7), 27, ZERO, 0_intkind1, wf16(:,64), n2(86))
  call vert_QA_V(ntry, wf4(:,52), ex3(:), wf8(:,168), n3(:,202), t3x8(:,:,132))
  call vert_AV_Q(ntry, ex3(:), wf4(:,60), wf8(:,169), n3(:,203), t3x8(:,:,133))
  call vert_UV_W(ntry, wf4(:,60), 10, ex6(:), 32, wf8(:,170), n3(:,204), t3x8(:,:,134))
  call counter_V_V(ctGG,21,ntry, wf8(:,30), 21, wf8(:,171), n2(87))
  call counter_A_Q(ctqq,2,ntry, wf8(:,33), 14, wf8(:,172), n2(88))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,20), wf16(:,65), n3(:,205), t3x16(:,:,47))
  call prop_A_Q(ntry, wf16(:,65), 30, ZERO, 0_intkind1, wf16(:,66), n2(89))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,19), wf16(:,67), n3(:,206), t3x16(:,:,48))
  call prop_Q_A(ntry, wf16(:,8), 43, ZERO, 0_intkind1, wf16(:,68), n2(90))
  call vert_VQ_A(ntry, wf4(:,60), ex1(:), wf8(:,173), n3(:,207), t3x8(:,:,135))
  call vert_QA_V(ntry, ex1(:), wf4(:,58), wf8(:,174), n3(:,208), t3x8(:,:,136))
  call counter_Q_A(ctqq,2,ntry, wf8(:,35), 11, wf8(:,175), n2(91))
  call counter_V_V(ctGG,21,ntry, wf8(:,36), 21, wf8(:,176), n2(92))
  call vert_QA_V(ntry, wf4(:,48), ex3(:), wf8(:,177), n3(:,209), t3x8(:,:,137))
  call vert_QA_V(ntry, wf4(:,48), ex4(:), wf8(:,178), n3(:,210), t3x8(:,:,138))
  call counter_V_V(ctGG,21,ntry, wf8(:,38), 38, wf8(:,179), n2(93))
  call vert_QA_V(ntry, ex2(:), wf4(:,59), wf8(:,180), n3(:,211), t3x8(:,:,139))
  call counter_V_V(ctGG,21,ntry, wf8(:,39), 38, wf8(:,181), n2(94))
  call counter_V_V(ctGG,21,ntry, wf8(:,40), 42, wf8(:,182), n2(95))
  call vert_QA_V(ntry, ex2(:), wf4(:,49), wf8(:,183), n3(:,212), t3x8(:,:,140))
  call vert_QA_V(ntry, wf4(:,54), ex3(:), wf8(:,184), n3(:,213), t3x8(:,:,141))
  call vert_QA_V(ntry, wf4(:,54), ex4(:), wf8(:,185), n3(:,214), t3x8(:,:,142))
  call counter_V_V(ctGG,21,ntry, wf8(:,41), 37, wf8(:,186), n2(96))
  call vert_QA_V(ntry, ex1(:), wf4(:,59), wf8(:,187), n3(:,215), t3x8(:,:,143))
  call counter_V_V(ctGG,21,ntry, wf8(:,43), 37, wf8(:,188), n2(97))
  call counter_V_V(ctGG,21,ntry, wf8(:,44), 41, wf8(:,189), n2(98))
  call vert_QA_V(ntry, ex1(:), wf4(:,49), wf8(:,190), n3(:,216), t3x8(:,:,144))
  call vert_UV_W(ntry, wf4(:,1), 5, wf4(:,20), 10, wf16(:,69), n3(:,217), t3x16(:,:,49))
  call vert_QA_V(ntry, wf8(:,8), ex4(:), wf16(:,70), n3(:,218), t3x16(:,:,50))
  call vert_VQ_A(ntry, ex5(:), wf8(:,8), wf16(:,71), n3(:,219), t3x16(:,:,51))
  call prop_Q_A(ntry, wf16(:,71), 23, ZERO, 0_intkind1, wf16(:,72), n2(99))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,73), n3(:,220), t3x16(:,:,52))
  call prop_Q_A(ntry, wf16(:,73), 39, ZERO, 0_intkind1, wf16(:,74), n2(100))
  call vert_QA_V(ntry, ex2(:), wf8(:,3), wf16(:,75), n3(:,221), t3x16(:,:,53))
  call vert_AV_Q(ntry, wf8(:,3), ex5(:), wf16(:,76), n3(:,222), t3x16(:,:,54))
  call prop_A_Q(ntry, wf16(:,76), 29, ZERO, 0_intkind1, wf16(:,77), n2(101))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,78), n3(:,223), t3x16(:,:,55))
  call prop_A_Q(ntry, wf16(:,78), 45, ZERO, 0_intkind1, wf16(:,79), n2(102))
  call vert_VQ_A(ntry, wf8(:,5), ex2(:), wf16(:,80), n3(:,224), t3x16(:,:,56))
  call prop_Q_A(ntry, wf16(:,80), 39, ZERO, 0_intkind1, wf16(:,81), n2(103))
  call vert_AV_Q(ntry, ex4(:), wf8(:,5), wf16(:,82), n3(:,225), t3x16(:,:,57))
  call prop_A_Q(ntry, wf16(:,82), 45, ZERO, 0_intkind1, wf16(:,83), n2(104))
  call vert_UV_W(ntry, wf4(:,11), 6, wf4(:,15), 9, wf16(:,84), n3(:,226), t3x16(:,:,58))
  call vert_QA_V(ntry, wf8(:,18), ex4(:), wf16(:,85), n3(:,227), t3x16(:,:,59))
  call vert_VQ_A(ntry, ex5(:), wf8(:,18), wf16(:,86), n3(:,228), t3x16(:,:,60))
  call prop_Q_A(ntry, wf16(:,86), 23, ZERO, 0_intkind1, wf16(:,87), n2(105))
  call vert_VQ_A(ntry, ex6(:), wf8(:,18), wf16(:,88), n3(:,229), t3x16(:,:,61))
  call prop_Q_A(ntry, wf16(:,88), 39, ZERO, 0_intkind1, wf16(:,89), n2(106))
  call vert_QA_V(ntry, ex1(:), wf8(:,16), wf16(:,90), n3(:,230), t3x16(:,:,62))
  call vert_VQ_A(ntry, wf8(:,13), ex1(:), wf16(:,91), n3(:,231), t3x16(:,:,63))
  call prop_Q_A(ntry, wf16(:,91), 39, ZERO, 0_intkind1, wf16(:,92), n2(107))
  call vert_AV_Q(ntry, wf8(:,16), ex5(:), wf16(:,93), n3(:,232), t3x16(:,:,64))
  call prop_A_Q(ntry, wf16(:,93), 30, ZERO, 0_intkind1, wf16(:,94), n2(108))
  call vert_AV_Q(ntry, wf8(:,16), ex6(:), wf16(:,95), n3(:,233), t3x16(:,:,65))
  call prop_A_Q(ntry, wf16(:,95), 46, ZERO, 0_intkind1, wf16(:,96), n2(109))
  call vert_AV_Q(ntry, ex4(:), wf8(:,13), wf16(:,97), n3(:,234), t3x16(:,:,66))
  call prop_A_Q(ntry, wf16(:,97), 46, ZERO, 0_intkind1, wf16(:,98), n2(110))
  call vert_QA_V(ntry, wf8(:,27), ex3(:), wf16(:,99), n3(:,235), t3x16(:,:,67))
  call vert_VQ_A(ntry, ex5(:), wf8(:,27), wf16(:,100), n3(:,236), t3x16(:,:,68))
  call prop_Q_A(ntry, wf16(:,100), 27, ZERO, 0_intkind1, wf16(:,101), n2(111))
  call vert_VQ_A(ntry, ex6(:), wf8(:,27), wf16(:,102), n3(:,237), t3x16(:,:,69))
  call prop_Q_A(ntry, wf16(:,102), 43, ZERO, 0_intkind1, wf16(:,103), n2(112))
  call vert_QA_V(ntry, ex2(:), wf8(:,22), wf16(:,104), n3(:,238), t3x16(:,:,70))
  call vert_AV_Q(ntry, wf8(:,22), ex5(:), wf16(:,105), n3(:,239), t3x16(:,:,71))
  call prop_A_Q(ntry, wf16(:,105), 29, ZERO, 0_intkind1, wf16(:,106), n2(113))
  call vert_AV_Q(ntry, wf8(:,22), ex6(:), wf16(:,107), n3(:,240), t3x16(:,:,72))
  call prop_A_Q(ntry, wf16(:,107), 45, ZERO, 0_intkind1, wf16(:,108), n2(114))
  call vert_VQ_A(ntry, wf8(:,24), ex2(:), wf16(:,109), n3(:,241), t3x16(:,:,73))
  call prop_Q_A(ntry, wf16(:,109), 43, ZERO, 0_intkind1, wf16(:,110), n2(115))
  call vert_AV_Q(ntry, ex3(:), wf8(:,24), wf16(:,111), n3(:,242), t3x16(:,:,74))
  call prop_A_Q(ntry, wf16(:,111), 45, ZERO, 0_intkind1, wf16(:,112), n2(116))
  call vert_QA_V(ntry, wf8(:,35), ex3(:), wf16(:,113), n3(:,243), t3x16(:,:,75))
  call vert_VQ_A(ntry, ex5(:), wf8(:,35), wf16(:,114), n3(:,244), t3x16(:,:,76))
  call prop_Q_A(ntry, wf16(:,114), 27, ZERO, 0_intkind1, wf16(:,115), n2(117))
  call vert_VQ_A(ntry, ex6(:), wf8(:,35), wf16(:,116), n3(:,245), t3x16(:,:,77))
  call prop_Q_A(ntry, wf16(:,116), 43, ZERO, 0_intkind1, wf16(:,117), n2(118))
  call vert_QA_V(ntry, ex1(:), wf8(:,33), wf16(:,118), n3(:,246), t3x16(:,:,78))
  call vert_VQ_A(ntry, wf8(:,31), ex1(:), wf16(:,119), n3(:,247), t3x16(:,:,79))
  call prop_Q_A(ntry, wf16(:,119), 43, ZERO, 0_intkind1, wf16(:,120), n2(119))
  call vert_AV_Q(ntry, wf8(:,33), ex5(:), wf16(:,121), n3(:,248), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,121), 30, ZERO, 0_intkind1, wf16(:,122), n2(120))
  call vert_AV_Q(ntry, wf8(:,33), ex6(:), wf16(:,123), n3(:,249), t3x16(:,:,81))
  call prop_A_Q(ntry, wf16(:,123), 46, ZERO, 0_intkind1, wf16(:,124), n2(121))
  call vert_AV_Q(ntry, ex3(:), wf8(:,31), wf16(:,125), n3(:,250), t3x16(:,:,82))
  call prop_A_Q(ntry, wf16(:,125), 46, ZERO, 0_intkind1, wf16(:,126), n2(122))
  call vert_VQ_A(ntry, wf8(:,30), ex2(:), wf16(:,127), n3(:,251), t3x16(:,:,83))
  call prop_Q_A(ntry, wf16(:,127), 23, ZERO, 0_intkind1, wf16(:,128), n2(123))
  call vert_AV_Q(ntry, ex4(:), wf8(:,30), wf16(:,129), n3(:,252), t3x16(:,:,84))
  call prop_A_Q(ntry, wf16(:,129), 29, ZERO, 0_intkind1, wf16(:,130), n2(124))
  call vert_UV_W(ntry, wf8(:,30), 21, ex6(:), 32, wf16(:,131), n3(:,253), t3x16(:,:,85))
  call vert_VQ_A(ntry, wf8(:,12), ex2(:), wf16(:,132), n3(:,254), t3x16(:,:,86))
  call prop_Q_A(ntry, wf16(:,132), 27, ZERO, 0_intkind1, wf16(:,133), n2(125))
  call vert_AV_Q(ntry, ex3(:), wf8(:,12), wf16(:,134), n3(:,255), t3x16(:,:,87))
  call prop_A_Q(ntry, wf16(:,134), 29, ZERO, 0_intkind1, wf16(:,135), n2(126))
  call vert_UV_W(ntry, wf8(:,12), 25, ex6(:), 32, wf16(:,136), n3(:,256), t3x16(:,:,88))
  call vert_QA_V(ntry, wf8(:,61), ex3(:), wf16(:,137), n3(:,257), t3x16(:,:,89))
  call vert_QA_V(ntry, wf8(:,61), ex4(:), wf16(:,138), n3(:,258), t3x16(:,:,90))
  call vert_VQ_A(ntry, wf8(:,23), ex1(:), wf16(:,139), n3(:,259), t3x16(:,:,91))
  call prop_Q_A(ntry, wf16(:,139), 23, ZERO, 0_intkind1, wf16(:,140), n2(127))
  call vert_VQ_A(ntry, wf8(:,4), ex1(:), wf16(:,141), n3(:,260), t3x16(:,:,92))
  call prop_Q_A(ntry, wf16(:,141), 27, ZERO, 0_intkind1, wf16(:,142), n2(128))
  call vert_AV_Q(ntry, ex4(:), wf8(:,23), wf16(:,143), n3(:,261), t3x16(:,:,93))
  call prop_A_Q(ntry, wf16(:,143), 30, ZERO, 0_intkind1, wf16(:,144), n2(129))
  call vert_UV_W(ntry, wf8(:,23), 22, ex6(:), 32, wf16(:,145), n3(:,262), t3x16(:,:,94))
  call vert_AV_Q(ntry, ex3(:), wf8(:,4), wf16(:,146), n3(:,263), t3x16(:,:,95))
  call prop_A_Q(ntry, wf16(:,146), 30, ZERO, 0_intkind1, wf16(:,147), n2(130))
  call vert_UV_W(ntry, wf8(:,4), 26, ex6(:), 32, wf16(:,148), n3(:,264), t3x16(:,:,96))
  call vert_QA_V(ntry, wf8(:,52), ex3(:), wf16(:,149), n3(:,265), t3x16(:,:,97))
  call vert_QA_V(ntry, wf8(:,52), ex4(:), wf16(:,150), n3(:,266), t3x16(:,:,98))
  call vert_VQ_A(ntry, wf8(:,36), ex2(:), wf16(:,151), n3(:,267), t3x16(:,:,99))
  call prop_Q_A(ntry, wf16(:,151), 23, ZERO, 0_intkind1, wf16(:,152), n2(131))
  call vert_VQ_A(ntry, wf8(:,28), ex1(:), wf16(:,153), n3(:,268), t3x16(:,:,100))
  call prop_Q_A(ntry, wf16(:,153), 23, ZERO, 0_intkind1, wf16(:,154), n2(132))
  call vert_AV_Q(ntry, ex4(:), wf8(:,36), wf16(:,155), n3(:,269), t3x16(:,:,101))
  call prop_A_Q(ntry, wf16(:,155), 29, ZERO, 0_intkind1, wf16(:,156), n2(133))
  call vert_UV_W(ntry, wf8(:,36), 21, ex6(:), 32, wf16(:,157), n3(:,270), t3x16(:,:,102))
  call vert_QA_V(ntry, ex1(:), wf8(:,94), wf16(:,158), n3(:,271), t3x16(:,:,103))
  call vert_AV_Q(ntry, ex4(:), wf8(:,28), wf16(:,159), n3(:,272), t3x16(:,:,104))
  call prop_A_Q(ntry, wf16(:,159), 30, ZERO, 0_intkind1, wf16(:,160), n2(134))
  call vert_UV_W(ntry, wf8(:,28), 22, ex6(:), 32, wf16(:,161), n3(:,273), t3x16(:,:,105))
  call vert_QA_V(ntry, ex2(:), wf8(:,94), wf16(:,162), n3(:,274), t3x16(:,:,106))
  call vert_VQ_A(ntry, wf8(:,19), ex2(:), wf16(:,163), n3(:,275), t3x16(:,:,107))
  call prop_Q_A(ntry, wf16(:,163), 27, ZERO, 0_intkind1, wf16(:,164), n2(135))
  call vert_VQ_A(ntry, wf8(:,9), ex1(:), wf16(:,165), n3(:,276), t3x16(:,:,108))
  call prop_Q_A(ntry, wf16(:,165), 27, ZERO, 0_intkind1, wf16(:,166), n2(136))
  call vert_AV_Q(ntry, ex3(:), wf8(:,19), wf16(:,167), n3(:,277), t3x16(:,:,109))
  call prop_A_Q(ntry, wf16(:,167), 29, ZERO, 0_intkind1, wf16(:,168), n2(137))
  call vert_UV_W(ntry, wf8(:,19), 25, ex6(:), 32, wf16(:,169), n3(:,278), t3x16(:,:,110))
  call vert_QA_V(ntry, ex1(:), wf8(:,87), wf16(:,170), n3(:,279), t3x16(:,:,111))
  call vert_AV_Q(ntry, ex3(:), wf8(:,9), wf16(:,171), n3(:,280), t3x16(:,:,112))
  call prop_A_Q(ntry, wf16(:,171), 30, ZERO, 0_intkind1, wf16(:,172), n2(138))
  call vert_UV_W(ntry, wf8(:,9), 26, ex6(:), 32, wf16(:,173), n3(:,281), t3x16(:,:,113))
  call vert_QA_V(ntry, ex2(:), wf8(:,87), wf16(:,174), n3(:,282), t3x16(:,:,114))
  call vert_VQ_A(ntry, wf8(:,41), ex2(:), wf16(:,175), n3(:,283), t3x16(:,:,115))
  call prop_Q_A(ntry, wf16(:,175), 39, ZERO, 0_intkind1, wf16(:,176), n2(139))
  call vert_AV_Q(ntry, ex4(:), wf8(:,41), wf16(:,177), n3(:,284), t3x16(:,:,116))
  call prop_A_Q(ntry, wf16(:,177), 45, ZERO, 0_intkind1, wf16(:,178), n2(140))
  call vert_VQ_A(ntry, wf8(:,42), ex2(:), wf16(:,179), n3(:,285), t3x16(:,:,117))
  call prop_Q_A(ntry, wf16(:,179), 43, ZERO, 0_intkind1, wf16(:,180), n2(141))
  call vert_AV_Q(ntry, ex3(:), wf8(:,42), wf16(:,181), n3(:,286), t3x16(:,:,118))
  call prop_A_Q(ntry, wf16(:,181), 45, ZERO, 0_intkind1, wf16(:,182), n2(142))
  call vert_QA_V(ntry, wf8(:,63), ex3(:), wf16(:,183), n3(:,287), t3x16(:,:,119))
  call vert_QA_V(ntry, wf8(:,63), ex4(:), wf16(:,184), n3(:,288), t3x16(:,:,120))
  call vert_VQ_A(ntry, wf8(:,38), ex1(:), wf16(:,185), n3(:,289), t3x16(:,:,121))
  call prop_Q_A(ntry, wf16(:,185), 39, ZERO, 0_intkind1, wf16(:,186), n2(143))
  call vert_VQ_A(ntry, wf8(:,37), ex1(:), wf16(:,187), n3(:,290), t3x16(:,:,122))
  call prop_Q_A(ntry, wf16(:,187), 43, ZERO, 0_intkind1, wf16(:,188), n2(144))
  call vert_AV_Q(ntry, ex4(:), wf8(:,38), wf16(:,189), n3(:,291), t3x16(:,:,123))
  call prop_A_Q(ntry, wf16(:,189), 46, ZERO, 0_intkind1, wf16(:,190), n2(145))
  call vert_AV_Q(ntry, ex3(:), wf8(:,37), wf16(:,191), n3(:,292), t3x16(:,:,124))
  call prop_A_Q(ntry, wf16(:,191), 46, ZERO, 0_intkind1, wf16(:,192), n2(146))
  call vert_QA_V(ntry, wf8(:,53), ex3(:), wf16(:,193), n3(:,293), t3x16(:,:,125))
  call vert_QA_V(ntry, wf8(:,53), ex4(:), wf16(:,194), n3(:,294), t3x16(:,:,126))
  call vert_VQ_A(ntry, wf8(:,43), ex2(:), wf16(:,195), n3(:,295), t3x16(:,:,127))
  call prop_Q_A(ntry, wf16(:,195), 39, ZERO, 0_intkind1, wf16(:,196), n2(147))
  call vert_VQ_A(ntry, wf8(:,39), ex1(:), wf16(:,197), n3(:,296), t3x16(:,:,128))
  call prop_Q_A(ntry, wf16(:,197), 39, ZERO, 0_intkind1, wf16(:,198), n2(148))
  call vert_AV_Q(ntry, ex4(:), wf8(:,43), wf16(:,199), n3(:,297), t3x16(:,:,129))
  call prop_A_Q(ntry, wf16(:,199), 45, ZERO, 0_intkind1, wf16(:,200), n2(149))
  call vert_QA_V(ntry, ex1(:), wf8(:,95), wf16(:,201), n3(:,298), t3x16(:,:,130))
  call vert_AV_Q(ntry, ex4(:), wf8(:,39), wf16(:,202), n3(:,299), t3x16(:,:,131))
  call prop_A_Q(ntry, wf16(:,202), 46, ZERO, 0_intkind1, wf16(:,203), n2(150))
  call vert_QA_V(ntry, ex2(:), wf8(:,95), wf16(:,204), n3(:,300), t3x16(:,:,132))
  call vert_VQ_A(ntry, wf8(:,44), ex2(:), wf16(:,205), n3(:,301), t3x16(:,:,133))
  call prop_Q_A(ntry, wf16(:,205), 43, ZERO, 0_intkind1, wf16(:,206), n2(151))
  call vert_VQ_A(ntry, wf8(:,40), ex1(:), wf16(:,207), n3(:,302), t3x16(:,:,134))
  call prop_Q_A(ntry, wf16(:,207), 43, ZERO, 0_intkind1, wf16(:,208), n2(152))
  call vert_AV_Q(ntry, ex3(:), wf8(:,44), wf16(:,209), n3(:,303), t3x16(:,:,135))
  call prop_A_Q(ntry, wf16(:,209), 45, ZERO, 0_intkind1, wf16(:,210), n2(153))
  call vert_QA_V(ntry, ex1(:), wf8(:,88), wf16(:,211), n3(:,304), t3x16(:,:,136))
  call vert_AV_Q(ntry, ex3(:), wf8(:,40), wf16(:,212), n3(:,305), t3x16(:,:,137))
  call prop_A_Q(ntry, wf16(:,212), 46, ZERO, 0_intkind1, wf16(:,213), n2(154))
  call vert_QA_V(ntry, ex2(:), wf8(:,88), wf16(:,214), n3(:,306), t3x16(:,:,138))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,11,5,8,12,9,13]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,5), wf16(:,1), A(:,1), n3(:,307), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,308), t3x64(:,:,2), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,5), A(:,3), n3(:,309), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,2), A(:,4), n3(:,310), t3x64(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,8), A(:,5), n3(:,311), t3x64(:,:,5), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,9), A(:,6), n3(:,312), t3x64(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,10), A(:,7), n3(:,313), t3x64(:,:,7), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,11), A(:,8), n3(:,314), t3x64(:,:,8), nhel, den(22))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,3), A(:,9), n3(:,315), t3x64(:,:,9), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,13), A(:,10), n3(:,316), t3x64(:,:,10), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,11), n3(:,317), t3x64(:,:,11), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,4), A(:,12), n3(:,318), t3x64(:,:,12), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,18), A(:,13), n3(:,319), t3x64(:,:,13), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,19), A(:,14), n3(:,320), t3x64(:,:,14), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,20), A(:,15), n3(:,321), t3x64(:,:,15), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,18), A(:,16), n3(:,322), t3x64(:,:,16), nhel, den(41))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,5), A(:,17), n3(:,323), t3x64(:,:,17), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,22), A(:,18), n3(:,324), t3x64(:,:,18), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,24), A(:,19), n3(:,325), t3x64(:,:,19), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,6), A(:,20), n3(:,326), t3x64(:,:,20), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,21), n3(:,327), t3x64(:,:,21), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,28), A(:,22), n3(:,328), t3x64(:,:,22), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,22), A(:,23), n3(:,329), t3x64(:,:,23), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,29), A(:,24), n3(:,330), t3x64(:,:,24), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,7), A(:,25), n3(:,331), t3x64(:,:,25), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,31), A(:,26), n3(:,332), t3x64(:,:,26), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,33), A(:,27), n3(:,333), t3x64(:,:,27), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,8), A(:,28), n3(:,334), t3x64(:,:,28), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,35), A(:,29), n3(:,335), t3x64(:,:,29), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,36), A(:,30), n3(:,336), t3x64(:,:,30), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,33), A(:,31), n3(:,337), t3x64(:,:,31), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,35), A(:,32), n3(:,338), t3x64(:,:,32), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,37), A(:,33), n3(:,339), t3x64(:,:,33), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,38), A(:,34), n3(:,340), t3x64(:,:,34), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,39), A(:,35), n3(:,341), t3x64(:,:,35), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,40), A(:,36), n3(:,342), t3x64(:,:,36), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,41), A(:,37), n3(:,343), t3x64(:,:,37), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,42), A(:,38), n3(:,344), t3x64(:,:,38), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,43), A(:,39), n3(:,345), t3x64(:,:,39), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,44), A(:,40), n3(:,346), t3x64(:,:,40), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,42), A(:,41), n3(:,347), t3x64(:,:,41), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,37), A(:,42), n3(:,348), t3x64(:,:,42), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,40), A(:,43), n3(:,349), t3x64(:,:,43), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,44), A(:,44), n3(:,350), t3x64(:,:,44), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,41), A(:,45), n3(:,351), t3x64(:,:,45), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,38), A(:,46), n3(:,352), t3x64(:,:,46), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,43), A(:,47), n3(:,353), t3x64(:,:,47), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,39), A(:,48), n3(:,354), t3x64(:,:,48), nhel, den(102))

    call Hcont_VV(nsync, wf4(:,20), wf16(:,9), A(:,49), n3(:,355), t3x64(:,:,49), nhel, den(103))
    call Hcont_VV(nsync, wf4(:,20), wf16(:,10), A(:,50), n3(:,356), t3x64(:,:,50), nhel, den(103))
    call Hcont_VV(nsync, wf4(:,11), wf16(:,11), A(:,51), n3(:,357), t3x64(:,:,51), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,11), wf16(:,12), A(:,52), n3(:,358), t3x64(:,:,52), nhel, den(104))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,13), A(:,53), n3(:,359), t3x64(:,:,53), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,45), A(:,54), n3(:,360), t3x64(:,:,54), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,46), A(:,55), n3(:,361), t3x64(:,:,55), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,14), A(:,56), n3(:,362), t3x64(:,:,56), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,47), A(:,57), n3(:,363), t3x64(:,:,57), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,46), A(:,58), n3(:,364), t3x64(:,:,58), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,48), A(:,59), n3(:,365), t3x64(:,:,59), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,49), A(:,60), n3(:,366), t3x64(:,:,60), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,50), A(:,61), n3(:,367), t3x64(:,:,61), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,52), A(:,62), n3(:,368), t3x64(:,:,62), nhel, den(109))
    call Hcont_QA(nsync, wf16(:,1), wf4(:,22), A(:,63), n3(:,369), t3x64(:,:,63), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,53), A(:,64), n3(:,370), t3x64(:,:,64), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,54), A(:,65), n3(:,371), t3x64(:,:,65), nhel, den(22))
    call Hcont_QA(nsync, wf16(:,2), wf4(:,24), A(:,66), n3(:,372), t3x64(:,:,66), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,55), A(:,67), n3(:,373), t3x64(:,:,67), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,56), A(:,68), n3(:,374), t3x64(:,:,68), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,15), A(:,69), n3(:,375), t3x64(:,:,69), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,57), A(:,70), n3(:,376), t3x64(:,:,70), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,58), A(:,71), n3(:,377), t3x64(:,:,71), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,16), A(:,72), n3(:,378), t3x64(:,:,72), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,47), A(:,73), n3(:,379), t3x64(:,:,73), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,57), A(:,74), n3(:,380), t3x64(:,:,74), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,59), A(:,75), n3(:,381), t3x64(:,:,75), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,49), A(:,76), n3(:,382), t3x64(:,:,76), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,61), A(:,77), n3(:,383), t3x64(:,:,77), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,62), A(:,78), n3(:,384), t3x64(:,:,78), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,3), wf4(:,22), A(:,79), n3(:,385), t3x64(:,:,79), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,63), A(:,80), n3(:,386), t3x64(:,:,80), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,54), A(:,81), n3(:,387), t3x64(:,:,81), nhel, den(41))
    call Hcont_QA(nsync, wf16(:,4), wf4(:,24), A(:,82), n3(:,388), t3x64(:,:,82), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,55), A(:,83), n3(:,389), t3x64(:,:,83), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,64), A(:,84), n3(:,390), t3x64(:,:,84), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,17), A(:,85), n3(:,391), t3x64(:,:,85), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,45), A(:,86), n3(:,392), t3x64(:,:,86), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,65), A(:,87), n3(:,393), t3x64(:,:,87), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,18), A(:,88), n3(:,394), t3x64(:,:,88), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,66), A(:,89), n3(:,395), t3x64(:,:,89), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,65), A(:,90), n3(:,396), t3x64(:,:,90), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,48), A(:,91), n3(:,397), t3x64(:,:,91), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,67), A(:,92), n3(:,398), t3x64(:,:,92), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,19), A(:,93), n3(:,399), t3x64(:,:,93), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,68), A(:,94), n3(:,400), t3x64(:,:,94), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,58), A(:,95), n3(:,401), t3x64(:,:,95), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,20), A(:,96), n3(:,402), t3x64(:,:,96), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,66), A(:,97), n3(:,403), t3x64(:,:,97), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,68), A(:,98), n3(:,404), t3x64(:,:,98), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,59), A(:,99), n3(:,405), t3x64(:,:,99), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,67), A(:,100), n3(:,406), t3x64(:,:,100), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,69), A(:,101), n3(:,407), t3x64(:,:,101), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,62), A(:,102), n3(:,408), t3x64(:,:,102), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,62), A(:,103), n3(:,409), t3x64(:,:,103), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,70), A(:,104), n3(:,410), t3x64(:,:,104), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,50), A(:,105), n3(:,411), t3x64(:,:,105), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,71), A(:,106), n3(:,412), t3x64(:,:,106), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,50), A(:,107), n3(:,413), t3x64(:,:,107), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,72), A(:,108), n3(:,414), t3x64(:,:,108), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,71), A(:,109), n3(:,415), t3x64(:,:,109), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,69), A(:,110), n3(:,416), t3x64(:,:,110), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,70), A(:,111), n3(:,417), t3x64(:,:,111), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,72), A(:,112), n3(:,418), t3x64(:,:,112), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,56), A(:,113), n3(:,419), t3x64(:,:,113), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,64), A(:,114), n3(:,420), t3x64(:,:,114), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,56), A(:,115), n3(:,421), t3x64(:,:,115), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,64), A(:,116), n3(:,422), t3x64(:,:,116), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,73), A(:,117), n3(:,423), t3x64(:,:,117), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,74), A(:,118), n3(:,424), t3x64(:,:,118), nhel, den(121))
    call Hcont_QA(nsync, wf16(:,5), wf4(:,26), A(:,119), n3(:,425), t3x64(:,:,119), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,74), A(:,120), n3(:,426), t3x64(:,:,120), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,75), A(:,121), n3(:,427), t3x64(:,:,121), nhel, den(60))
    call Hcont_QA(nsync, wf16(:,6), wf4(:,28), A(:,122), n3(:,428), t3x64(:,:,122), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,76), A(:,123), n3(:,429), t3x64(:,:,123), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,77), A(:,124), n3(:,430), t3x64(:,:,124), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,61), wf8(:,78), A(:,125), n3(:,431), t3x64(:,:,125), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,79), A(:,126), n3(:,432), t3x64(:,:,126), nhel, den(125))
    call Hcont_QA(nsync, wf16(:,7), wf4(:,26), A(:,127), n3(:,433), t3x64(:,:,127), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,78), A(:,128), n3(:,434), t3x64(:,:,128), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,75), A(:,129), n3(:,435), t3x64(:,:,129), nhel, den(76))
    call Hcont_QA(nsync, wf16(:,8), wf4(:,28), A(:,130), n3(:,436), t3x64(:,:,130), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,76), A(:,131), n3(:,437), t3x64(:,:,131), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,80), A(:,132), n3(:,438), t3x64(:,:,132), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,81), A(:,133), n3(:,439), t3x64(:,:,133), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,79), A(:,134), n3(:,440), t3x64(:,:,134), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,79), A(:,135), n3(:,441), t3x64(:,:,135), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,82), A(:,136), n3(:,442), t3x64(:,:,136), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,73), A(:,137), n3(:,443), t3x64(:,:,137), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,83), A(:,138), n3(:,444), t3x64(:,:,138), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,73), A(:,139), n3(:,445), t3x64(:,:,139), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,84), A(:,140), n3(:,446), t3x64(:,:,140), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,83), A(:,141), n3(:,447), t3x64(:,:,141), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,81), A(:,142), n3(:,448), t3x64(:,:,142), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,82), A(:,143), n3(:,449), t3x64(:,:,143), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,84), A(:,144), n3(:,450), t3x64(:,:,144), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,77), A(:,145), n3(:,451), t3x64(:,:,145), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,80), A(:,146), n3(:,452), t3x64(:,:,146), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,77), A(:,147), n3(:,453), t3x64(:,:,147), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,80), A(:,148), n3(:,454), t3x64(:,:,148), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,85), A(:,149), n3(:,455), t3x64(:,:,149), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,87), A(:,150), n3(:,456), t3x64(:,:,150), nhel, den(136))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,21), A(:,151), n3(:,457), t3x64(:,:,151), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,88), A(:,152), n3(:,458), t3x64(:,:,152), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,89), A(:,153), n3(:,459), t3x64(:,:,153), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,22), A(:,154), n3(:,460), t3x64(:,:,154), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,90), A(:,155), n3(:,461), t3x64(:,:,155), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,91), A(:,156), n3(:,462), t3x64(:,:,156), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,92), A(:,157), n3(:,463), t3x64(:,:,157), nhel, den(139))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,94), A(:,158), n3(:,464), t3x64(:,:,158), nhel, den(142))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,23), A(:,159), n3(:,465), t3x64(:,:,159), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,95), A(:,160), n3(:,466), t3x64(:,:,160), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,89), A(:,161), n3(:,467), t3x64(:,:,161), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,24), A(:,162), n3(:,468), t3x64(:,:,162), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,90), A(:,163), n3(:,469), t3x64(:,:,163), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,96), A(:,164), n3(:,470), t3x64(:,:,164), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,97), A(:,165), n3(:,471), t3x64(:,:,165), nhel, den(145))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,98), A(:,166), n3(:,472), t3x64(:,:,166), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,99), A(:,167), n3(:,473), t3x64(:,:,167), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,100), A(:,168), n3(:,474), t3x64(:,:,168), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,92), A(:,169), n3(:,475), t3x64(:,:,169), nhel, den(147))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,98), A(:,170), n3(:,476), t3x64(:,:,170), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,92), A(:,171), n3(:,477), t3x64(:,:,171), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,99), A(:,172), n3(:,478), t3x64(:,:,172), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,85), A(:,173), n3(:,479), t3x64(:,:,173), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,85), A(:,174), n3(:,480), t3x64(:,:,174), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,97), A(:,175), n3(:,481), t3x64(:,:,175), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,100), A(:,176), n3(:,482), t3x64(:,:,176), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,91), A(:,177), n3(:,483), t3x64(:,:,177), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,96), A(:,178), n3(:,484), t3x64(:,:,178), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,91), A(:,179), n3(:,485), t3x64(:,:,179), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,96), A(:,180), n3(:,486), t3x64(:,:,180), nhel, den(94))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,25), A(:,181), n3(:,487), t3x64(:,:,181), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,101), A(:,182), n3(:,488), t3x64(:,:,182), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,103), A(:,183), n3(:,489), t3x64(:,:,183), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,26), A(:,184), n3(:,490), t3x64(:,:,184), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,101), A(:,185), n3(:,491), t3x64(:,:,185), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,105), A(:,186), n3(:,492), t3x64(:,:,186), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,103), A(:,187), n3(:,493), t3x64(:,:,187), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,105), A(:,188), n3(:,494), t3x64(:,:,188), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,27), A(:,189), n3(:,495), t3x64(:,:,189), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,106), A(:,190), n3(:,496), t3x64(:,:,190), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,108), A(:,191), n3(:,497), t3x64(:,:,191), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,28), A(:,192), n3(:,498), t3x64(:,:,192), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,106), A(:,193), n3(:,499), t3x64(:,:,193), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,110), A(:,194), n3(:,500), t3x64(:,:,194), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,108), A(:,195), n3(:,501), t3x64(:,:,195), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,110), A(:,196), n3(:,502), t3x64(:,:,196), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,111), A(:,197), n3(:,503), t3x64(:,:,197), nhel, den(149))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,112), A(:,198), n3(:,504), t3x64(:,:,198), nhel, den(150))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,29), A(:,199), n3(:,505), t3x64(:,:,199), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,111), A(:,200), n3(:,506), t3x64(:,:,200), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,113), A(:,201), n3(:,507), t3x64(:,:,201), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,30), A(:,202), n3(:,508), t3x64(:,:,202), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,114), A(:,203), n3(:,509), t3x64(:,:,203), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,115), A(:,204), n3(:,510), t3x64(:,:,204), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,116), A(:,205), n3(:,511), t3x64(:,:,205), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,117), A(:,206), n3(:,512), t3x64(:,:,206), nhel, den(153))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,31), A(:,207), n3(:,513), t3x64(:,:,207), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,116), A(:,208), n3(:,514), t3x64(:,:,208), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,113), A(:,209), n3(:,515), t3x64(:,:,209), nhel, den(75))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,32), A(:,210), n3(:,516), t3x64(:,:,210), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,118), A(:,211), n3(:,517), t3x64(:,:,211), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,115), A(:,212), n3(:,518), t3x64(:,:,212), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,119), A(:,213), n3(:,519), t3x64(:,:,213), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,120), A(:,214), n3(:,520), t3x64(:,:,214), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,121), A(:,215), n3(:,521), t3x64(:,:,215), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,122), A(:,216), n3(:,522), t3x64(:,:,216), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,117), A(:,217), n3(:,523), t3x64(:,:,217), nhel, den(157))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,117), A(:,218), n3(:,524), t3x64(:,:,218), nhel, den(158))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,120), A(:,219), n3(:,525), t3x64(:,:,219), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,122), A(:,220), n3(:,526), t3x64(:,:,220), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,112), A(:,221), n3(:,527), t3x64(:,:,221), nhel, den(160))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,119), A(:,222), n3(:,528), t3x64(:,:,222), nhel, den(161))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,112), A(:,223), n3(:,529), t3x64(:,:,223), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,121), A(:,224), n3(:,530), t3x64(:,:,224), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,118), A(:,225), n3(:,531), t3x64(:,:,225), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,114), A(:,226), n3(:,532), t3x64(:,:,226), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,114), A(:,227), n3(:,533), t3x64(:,:,227), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,118), A(:,228), n3(:,534), t3x64(:,:,228), nhel, den(85))
    call Hcont_QA(nsync, wf4(:,17), wf16(:,33), A(:,229), n3(:,535), t3x64(:,:,229), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,124), A(:,230), n3(:,536), t3x64(:,:,230), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,125), A(:,231), n3(:,537), t3x64(:,:,231), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,34), A(:,232), n3(:,538), t3x64(:,:,232), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,127), A(:,233), n3(:,539), t3x64(:,:,233), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,125), A(:,234), n3(:,540), t3x64(:,:,234), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,124), A(:,235), n3(:,541), t3x64(:,:,235), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,127), A(:,236), n3(:,542), t3x64(:,:,236), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,35), A(:,237), n3(:,543), t3x64(:,:,237), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,129), A(:,238), n3(:,544), t3x64(:,:,238), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,130), A(:,239), n3(:,545), t3x64(:,:,239), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,36), A(:,240), n3(:,546), t3x64(:,:,240), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,132), A(:,241), n3(:,547), t3x64(:,:,241), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,130), A(:,242), n3(:,548), t3x64(:,:,242), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,129), A(:,243), n3(:,549), t3x64(:,:,243), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,132), A(:,244), n3(:,550), t3x64(:,:,244), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,37), wf4(:,41), A(:,245), n3(:,551), t3x64(:,:,245), nhel, den(166))
    call Hcont_QA(nsync, wf4(:,42), wf16(:,39), A(:,246), n3(:,552), t3x64(:,:,246), nhel, den(170))
    call Hcont_QA(nsync, wf4(:,43), wf16(:,40), A(:,247), n3(:,553), t3x64(:,:,247), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,133), A(:,248), n3(:,554), t3x64(:,:,248), nhel, den(175))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,134), A(:,249), n3(:,555), t3x64(:,:,249), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,135), A(:,250), n3(:,556), t3x64(:,:,250), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,136), A(:,251), n3(:,557), t3x64(:,:,251), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,137), A(:,252), n3(:,558), t3x64(:,:,252), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,138), A(:,253), n3(:,559), t3x64(:,:,253), nhel, den(181))
    call Hcont_VV(nsync, wf4(:,41), wf16(:,41), A(:,254), n3(:,560), t3x64(:,:,254), nhel, den(184))
    call Hcont_QA(nsync, wf4(:,45), wf16(:,43), A(:,255), n3(:,561), t3x64(:,:,255), nhel, den(188))
    call Hcont_QA(nsync, wf4(:,46), wf16(:,44), A(:,256), n3(:,562), t3x64(:,:,256), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,139), A(:,257), n3(:,563), t3x64(:,:,257), nhel, den(192))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,134), A(:,258), n3(:,564), t3x64(:,:,258), nhel, den(193))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,140), A(:,259), n3(:,565), t3x64(:,:,259), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,141), A(:,260), n3(:,566), t3x64(:,:,260), nhel, den(196))
    call Hcont_VV(nsync, wf8(:,5), wf8(:,142), A(:,261), n3(:,567), t3x64(:,:,261), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,143), A(:,262), n3(:,568), t3x64(:,:,262), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,133), A(:,263), n3(:,569), t3x64(:,:,263), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,144), A(:,264), n3(:,570), t3x64(:,:,264), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,137), A(:,265), n3(:,571), t3x64(:,:,265), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,139), A(:,266), n3(:,572), t3x64(:,:,266), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,141), A(:,267), n3(:,573), t3x64(:,:,267), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,145), A(:,268), n3(:,574), t3x64(:,:,268), nhel, den(206))
    call Hcont_QA(nsync, wf4(:,50), wf16(:,46), A(:,269), n3(:,575), t3x64(:,:,269), nhel, den(210))
    call Hcont_VV(nsync, wf16(:,47), wf4(:,51), A(:,270), n3(:,576), t3x64(:,:,270), nhel, den(214))
    call Hcont_QA(nsync, wf4(:,43), wf16(:,48), A(:,271), n3(:,577), t3x64(:,:,271), nhel, den(216))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,146), A(:,272), n3(:,578), t3x64(:,:,272), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,147), A(:,273), n3(:,579), t3x64(:,:,273), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,61), wf8(:,148), A(:,274), n3(:,580), t3x64(:,:,274), nhel, den(221))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,149), A(:,275), n3(:,581), t3x64(:,:,275), nhel, den(222))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,150), A(:,276), n3(:,582), t3x64(:,:,276), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,61), wf8(:,151), A(:,277), n3(:,583), t3x64(:,:,277), nhel, den(224))
    call Hcont_QA(nsync, wf4(:,53), wf16(:,50), A(:,278), n3(:,584), t3x64(:,:,278), nhel, den(228))
    call Hcont_VV(nsync, wf4(:,51), wf16(:,51), A(:,279), n3(:,585), t3x64(:,:,279), nhel, den(231))
    call Hcont_QA(nsync, wf4(:,46), wf16(:,52), A(:,280), n3(:,586), t3x64(:,:,280), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,152), A(:,281), n3(:,587), t3x64(:,:,281), nhel, den(234))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,153), A(:,282), n3(:,588), t3x64(:,:,282), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,154), A(:,283), n3(:,589), t3x64(:,:,283), nhel, den(236))
    call Hcont_VV(nsync, wf8(:,13), wf8(:,155), A(:,284), n3(:,590), t3x64(:,:,284), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,149), A(:,285), n3(:,591), t3x64(:,:,285), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,143), A(:,286), n3(:,592), t3x64(:,:,286), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,156), A(:,287), n3(:,593), t3x64(:,:,287), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,148), A(:,288), n3(:,594), t3x64(:,:,288), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,151), A(:,289), n3(:,595), t3x64(:,:,289), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,152), A(:,290), n3(:,596), t3x64(:,:,290), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,154), A(:,291), n3(:,597), t3x64(:,:,291), nhel, den(245))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,145), A(:,292), n3(:,598), t3x64(:,:,292), nhel, den(246))
    call Hcont_VV(nsync, wf16(:,53), wf4(:,55), A(:,293), n3(:,599), t3x64(:,:,293), nhel, den(250))
    call Hcont_QA(nsync, wf4(:,42), wf16(:,55), A(:,294), n3(:,600), t3x64(:,:,294), nhel, den(253))
    call Hcont_QA(nsync, wf4(:,56), wf16(:,56), A(:,295), n3(:,601), t3x64(:,:,295), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,157), A(:,296), n3(:,602), t3x64(:,:,296), nhel, den(258))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,158), A(:,297), n3(:,603), t3x64(:,:,297), nhel, den(259))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,159), A(:,298), n3(:,604), t3x64(:,:,298), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,136), A(:,299), n3(:,605), t3x64(:,:,299), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,160), A(:,300), n3(:,606), t3x64(:,:,300), nhel, den(262))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,161), A(:,301), n3(:,607), t3x64(:,:,301), nhel, den(263))
    call Hcont_VV(nsync, wf4(:,55), wf16(:,57), A(:,302), n3(:,608), t3x64(:,:,302), nhel, den(266))
    call Hcont_QA(nsync, wf4(:,45), wf16(:,59), A(:,303), n3(:,609), t3x64(:,:,303), nhel, den(269))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,60), A(:,304), n3(:,610), t3x64(:,:,304), nhel, den(272))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,162), A(:,305), n3(:,611), t3x64(:,:,305), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,158), A(:,306), n3(:,612), t3x64(:,:,306), nhel, den(274))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,163), A(:,307), n3(:,613), t3x64(:,:,307), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,164), A(:,308), n3(:,614), t3x64(:,:,308), nhel, den(277))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,165), A(:,309), n3(:,615), t3x64(:,:,309), nhel, den(278))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,166), A(:,310), n3(:,616), t3x64(:,:,310), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,157), A(:,311), n3(:,617), t3x64(:,:,311), nhel, den(280))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,144), A(:,312), n3(:,618), t3x64(:,:,312), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,160), A(:,313), n3(:,619), t3x64(:,:,313), nhel, den(282))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,162), A(:,314), n3(:,620), t3x64(:,:,314), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,164), A(:,315), n3(:,621), t3x64(:,:,315), nhel, den(284))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,167), A(:,316), n3(:,622), t3x64(:,:,316), nhel, den(286))
    call Hcont_QA(nsync, wf4(:,50), wf16(:,62), A(:,317), n3(:,623), t3x64(:,:,317), nhel, den(289))
    call Hcont_VV(nsync, wf16(:,63), wf4(:,60), A(:,318), n3(:,624), t3x64(:,:,318), nhel, den(293))
    call Hcont_QA(nsync, wf4(:,56), wf16(:,64), A(:,319), n3(:,625), t3x64(:,:,319), nhel, den(295))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,168), A(:,320), n3(:,626), t3x64(:,:,320), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,147), A(:,321), n3(:,627), t3x64(:,:,321), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,61), wf8(:,169), A(:,322), n3(:,628), t3x64(:,:,322), nhel, den(299))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,170), A(:,323), n3(:,629), t3x64(:,:,323), nhel, den(300))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,171), A(:,324), n3(:,630), t3x64(:,:,324), nhel, den(301))
    call Hcont_QA(nsync, wf8(:,61), wf8(:,172), A(:,325), n3(:,631), t3x64(:,:,325), nhel, den(302))
    call Hcont_QA(nsync, wf4(:,53), wf16(:,66), A(:,326), n3(:,632), t3x64(:,:,326), nhel, den(305))
    call Hcont_VV(nsync, wf4(:,60), wf16(:,67), A(:,327), n3(:,633), t3x64(:,:,327), nhel, den(308))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,68), A(:,328), n3(:,634), t3x64(:,:,328), nhel, den(310))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,173), A(:,329), n3(:,635), t3x64(:,:,329), nhel, den(311))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,174), A(:,330), n3(:,636), t3x64(:,:,330), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,175), A(:,331), n3(:,637), t3x64(:,:,331), nhel, den(313))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,176), A(:,332), n3(:,638), t3x64(:,:,332), nhel, den(314))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,170), A(:,333), n3(:,639), t3x64(:,:,333), nhel, den(315))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,166), A(:,334), n3(:,640), t3x64(:,:,334), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,156), A(:,335), n3(:,641), t3x64(:,:,335), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,169), A(:,336), n3(:,642), t3x64(:,:,336), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,172), A(:,337), n3(:,643), t3x64(:,:,337), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,173), A(:,338), n3(:,644), t3x64(:,:,338), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,175), A(:,339), n3(:,645), t3x64(:,:,339), nhel, den(321))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,167), A(:,340), n3(:,646), t3x64(:,:,340), nhel, den(322))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,168), A(:,341), n3(:,647), t3x64(:,:,341), nhel, den(323))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,146), A(:,342), n3(:,648), t3x64(:,:,342), nhel, den(324))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,177), A(:,343), n3(:,649), t3x64(:,:,343), nhel, den(325))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,178), A(:,344), n3(:,650), t3x64(:,:,344), nhel, den(326))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,171), A(:,345), n3(:,651), t3x64(:,:,345), nhel, den(327))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,179), A(:,346), n3(:,652), t3x64(:,:,346), nhel, den(328))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,146), A(:,347), n3(:,653), t3x64(:,:,347), nhel, den(329))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,180), A(:,348), n3(:,654), t3x64(:,:,348), nhel, den(330))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,181), A(:,349), n3(:,655), t3x64(:,:,349), nhel, den(331))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,168), A(:,350), n3(:,656), t3x64(:,:,350), nhel, den(332))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,182), A(:,351), n3(:,657), t3x64(:,:,351), nhel, den(333))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,183), A(:,352), n3(:,658), t3x64(:,:,352), nhel, den(334))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,184), A(:,353), n3(:,659), t3x64(:,:,353), nhel, den(335))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,185), A(:,354), n3(:,660), t3x64(:,:,354), nhel, den(336))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,159), A(:,355), n3(:,661), t3x64(:,:,355), nhel, den(337))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,135), A(:,356), n3(:,662), t3x64(:,:,356), nhel, den(338))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,186), A(:,357), n3(:,663), t3x64(:,:,357), nhel, den(339))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,161), A(:,358), n3(:,664), t3x64(:,:,358), nhel, den(340))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,187), A(:,359), n3(:,665), t3x64(:,:,359), nhel, den(341))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,188), A(:,360), n3(:,666), t3x64(:,:,360), nhel, den(342))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,135), A(:,361), n3(:,667), t3x64(:,:,361), nhel, den(343))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,189), A(:,362), n3(:,668), t3x64(:,:,362), nhel, den(344))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,190), A(:,363), n3(:,669), t3x64(:,:,363), nhel, den(345))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,159), A(:,364), n3(:,670), t3x64(:,:,364), nhel, den(346))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,185), A(:,365), n3(:,671), t3x64(:,:,365), nhel, den(347))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,163), A(:,366), n3(:,672), t3x64(:,:,366), nhel, den(348))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,165), A(:,367), n3(:,673), t3x64(:,:,367), nhel, den(349))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,174), A(:,368), n3(:,674), t3x64(:,:,368), nhel, den(350))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,176), A(:,369), n3(:,675), t3x64(:,:,369), nhel, den(351))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,178), A(:,370), n3(:,676), t3x64(:,:,370), nhel, den(352))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,176), A(:,371), n3(:,677), t3x64(:,:,371), nhel, den(353))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,189), A(:,372), n3(:,678), t3x64(:,:,372), nhel, den(354))
    call Hcont_VV(nsync, wf8(:,40), wf8(:,174), A(:,373), n3(:,679), t3x64(:,:,373), nhel, den(355))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,190), A(:,374), n3(:,680), t3x64(:,:,374), nhel, den(356))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,163), A(:,375), n3(:,681), t3x64(:,:,375), nhel, den(357))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,183), A(:,376), n3(:,682), t3x64(:,:,376), nhel, den(358))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,184), A(:,377), n3(:,683), t3x64(:,:,377), nhel, den(359))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,142), A(:,378), n3(:,684), t3x64(:,:,378), nhel, den(360))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,140), A(:,379), n3(:,685), t3x64(:,:,379), nhel, den(361))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,155), A(:,380), n3(:,686), t3x64(:,:,380), nhel, den(362))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,153), A(:,381), n3(:,687), t3x64(:,:,381), nhel, den(363))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,177), A(:,382), n3(:,688), t3x64(:,:,382), nhel, den(364))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,188), A(:,383), n3(:,689), t3x64(:,:,383), nhel, den(365))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,155), A(:,384), n3(:,690), t3x64(:,:,384), nhel, den(366))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,187), A(:,385), n3(:,691), t3x64(:,:,385), nhel, den(367))
    call Hcont_VV(nsync, wf8(:,39), wf8(:,153), A(:,386), n3(:,692), t3x64(:,:,386), nhel, den(368))
    call Hcont_VV(nsync, wf8(:,19), wf8(:,180), A(:,387), n3(:,693), t3x64(:,:,387), nhel, den(369))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,140), A(:,388), n3(:,694), t3x64(:,:,388), nhel, den(370))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,nhel)
  integer :: empty(0), i

  M1(1)%j = ((A(j,25)%j+A(j,27)%j+A(j,28)%j+A(j,29)%j+A(j,31)%j+A(j,32)%j+A(j,37)%j+A(j,39)%j+A(j,45)%j &
       +A(j,47)%j)*f(1))/6._/**/REALKIND+((A(j,11)%j+A(j,12)%j+A(j,15)%j+A(j,17)%j+A(j,21)%j+A(j,24)%j+A(j,35)%j+A(j,38)%j &
       +A(j,41)%j+A(j,48)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,10)%j+A(j,14)%j-A(j,19)%j-A(j,22)%j)*f(2))/2._/**/REALKIND
  M1(2)%j = ((-A(j,2)%j-A(j,4)%j-A(j,7)%j-A(j,25)%j-A(j,29)%j-A(j,32)%j-A(j,33)%j-A(j,39)%j-A(j,42)%j &
       -A(j,47)%j)*f(1))/2._/**/REALKIND+((-A(j,17)%j-A(j,18)%j-A(j,20)%j-A(j,21)%j-A(j,23)%j-A(j,24)%j-A(j,34)%j-A(j,35)%j &
       -A(j,46)%j-A(j,48)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,3)%j-A(j,6)%j+A(j,26)%j+A(j,30)%j)*f(2))/2._/**/REALKIND
  M1(3)%j = ((-A(j,9)%j-A(j,11)%j-A(j,12)%j-A(j,13)%j-A(j,15)%j-A(j,16)%j-A(j,38)%j-A(j,40)%j-A(j,41)%j &
       -A(j,44)%j)*f(1))/6._/**/REALKIND+((-A(j,1)%j-A(j,5)%j-A(j,8)%j-A(j,27)%j-A(j,28)%j-A(j,31)%j-A(j,36)%j-A(j,37)%j-A(j,43)%j &
       -A(j,45)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,3)%j+A(j,6)%j-A(j,26)%j-A(j,30)%j)*f(2))/2._/**/REALKIND
  M1(4)%j = ((A(j,1)%j+A(j,2)%j+A(j,4)%j+A(j,5)%j+A(j,7)%j+A(j,8)%j+A(j,33)%j+A(j,36)%j+A(j,42)%j+A(j,43)%j)*f(1))/6._/**/REALKIND &
       +((A(j,9)%j+A(j,13)%j+A(j,16)%j+A(j,18)%j+A(j,20)%j+A(j,23)%j+A(j,34)%j+A(j,40)%j+A(j,44)%j &
       +A(j,46)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,10)%j-A(j,14)%j+A(j,19)%j+A(j,22)%j)*f(2))/2._/**/REALKIND

  M2(1)%j = ((-A(j,273)%j-A(j,274)%j-A(j,277)%j-A(j,278)%j-A(j,279)%j-A(j,280)%j-A(j,287)%j-A(j,288)%j-A(j,289)%j-A(j,293)%j &
       -A(j,294)%j-A(j,295)%j-A(j,305)%j-A(j,308)%j-A(j,310)%j-A(j,314)%j-A(j,315)%j-A(j,316)%j-A(j,347)%j-A(j,348)%j-A(j,349)%j &
       -A(j,354)%j-A(j,355)%j-A(j,358)%j-A(j,365)%j-A(j,366)%j-A(j,367)%j-A(j,384)%j-A(j,386)%j-A(j,387)%j)*f(3))/2._/**/REALKIND &
       +((-A(j,317)%j-A(j,318)%j-A(j,319)%j-A(j,321)%j-A(j,322)%j-A(j,325)%j-A(j,326)%j-A(j,327)%j-A(j,328)%j-A(j,329)%j &
       -A(j,331)%j-A(j,334)%j-A(j,335)%j-A(j,336)%j-A(j,337)%j-A(j,338)%j-A(j,339)%j-A(j,340)%j-A(j,353)%j-A(j,356)%j-A(j,357)%j &
       -A(j,359)%j-A(j,360)%j-A(j,361)%j-A(j,377)%j-A(j,378)%j-A(j,379)%j-A(j,383)%j-A(j,385)%j-A(j,388)%j)*f(3))/6._/**/REALKIND &
       +((-A(j,49)%j-A(j,50)%j)*f(4))/12._/**/REALKIND-(A(j,52)%j*f(4))/4._/**/REALKIND+(CI*(-A(j,272)%j-A(j,275)%j-A(j,276)%j &
       -A(j,282)%j-A(j,284)%j-A(j,285)%j+A(j,297)%j+A(j,298)%j+A(j,301)%j+A(j,306)%j+A(j,307)%j+A(j,309)%j)*f(5))/2._/**/REALKIND &
       +((A(j,93)%j+A(j,95)%j+A(j,96)%j+A(j,97)%j+A(j,105)%j+A(j,107)%j+A(j,125)%j+A(j,127)%j+A(j,128)%j+A(j,129)%j+A(j,138)%j &
       +A(j,140)%j+A(j,141)%j+A(j,144)%j+A(j,173)%j+A(j,174)%j+A(j,181)%j+A(j,183)%j+A(j,184)%j+A(j,186)%j+A(j,187)%j+A(j,188)%j &
       +A(j,205)%j+A(j,207)%j+A(j,208)%j+A(j,209)%j+A(j,213)%j+A(j,215)%j+A(j,222)%j+A(j,224)%j)*f(6))/6._/**/REALKIND+((A(j,71)%j &
       +A(j,72)%j+A(j,77)%j+A(j,80)%j+A(j,85)%j+A(j,89)%j+A(j,103)%j+A(j,106)%j+A(j,109)%j+A(j,119)%j+A(j,121)%j+A(j,136)%j &
       +A(j,137)%j+A(j,143)%j+A(j,158)%j+A(j,160)%j+A(j,165)%j+A(j,169)%j+A(j,175)%j+A(j,191)%j+A(j,192)%j+A(j,195)%j+A(j,199)%j &
       +A(j,201)%j+A(j,216)%j+A(j,220)%j+A(j,223)%j+A(j,229)%j+A(j,233)%j+A(j,236)%j)*f(6))/2._/**/REALKIND+(CI*(A(j,78)%j &
       -A(j,117)%j-A(j,157)%j+A(j,190)%j+A(j,193)%j+A(j,198)%j-A(j,231)%j-A(j,234)%j)*f(7))/2._/**/REALKIND+((A(j,99)%j+A(j,100)%j &
       +A(j,113)%j+A(j,115)%j+A(j,130)%j+A(j,131)%j+A(j,177)%j+A(j,179)%j+A(j,210)%j+A(j,212)%j)*f(8))/6._/**/REALKIND+((A(j,75)%j &
       +A(j,82)%j+A(j,92)%j+A(j,116)%j+A(j,123)%j+A(j,145)%j+A(j,162)%j+A(j,178)%j+A(j,204)%j+A(j,227)%j)*f(8))/2._/**/REALKIND &
       +(CI*(A(j,84)%j-A(j,124)%j-A(j,164)%j+A(j,203)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,70)%j+A(j,74)%j-A(j,87)%j &
       -A(j,90)%j)*f(10))/2._/**/REALKIND
  M2(2)%j = ((A(j,293)%j+A(j,294)%j+A(j,295)%j+A(j,296)%j+A(j,299)%j+A(j,300)%j+A(j,302)%j+A(j,303)%j+A(j,304)%j+A(j,305)%j &
       +A(j,308)%j+A(j,310)%j+A(j,311)%j+A(j,312)%j+A(j,313)%j+A(j,314)%j+A(j,315)%j+A(j,316)%j+A(j,342)%j+A(j,343)%j+A(j,346)%j &
       +A(j,347)%j+A(j,348)%j+A(j,349)%j+A(j,380)%j+A(j,381)%j+A(j,382)%j+A(j,384)%j+A(j,386)%j+A(j,387)%j)*f(3))/6._/**/REALKIND &
       +((A(j,248)%j+A(j,251)%j+A(j,252)%j+A(j,254)%j+A(j,255)%j+A(j,256)%j+A(j,263)%j+A(j,264)%j+A(j,265)%j+A(j,317)%j+A(j,318)%j &
       +A(j,319)%j+A(j,329)%j+A(j,331)%j+A(j,334)%j+A(j,338)%j+A(j,339)%j+A(j,340)%j+A(j,341)%j+A(j,344)%j+A(j,345)%j+A(j,359)%j &
       +A(j,360)%j+A(j,361)%j+A(j,368)%j+A(j,369)%j+A(j,370)%j+A(j,383)%j+A(j,385)%j+A(j,388)%j)*f(3))/2._/**/REALKIND &
       +(A(j,49)%j*f(4))/4._/**/REALKIND+((A(j,51)%j+A(j,52)%j)*f(4))/12._/**/REALKIND+(CI*(A(j,249)%j+A(j,250)%j+A(j,253)%j &
       +A(j,258)%j+A(j,259)%j+A(j,261)%j-A(j,320)%j-A(j,323)%j-A(j,324)%j-A(j,330)%j-A(j,332)%j-A(j,333)%j)*f(5))/2._/**/REALKIND &
       +((-A(j,85)%j-A(j,86)%j-A(j,88)%j-A(j,89)%j-A(j,102)%j-A(j,103)%j-A(j,118)%j-A(j,119)%j-A(j,120)%j-A(j,121)%j-A(j,133)%j &
       -A(j,136)%j-A(j,142)%j-A(j,143)%j-A(j,158)%j-A(j,159)%j-A(j,160)%j-A(j,161)%j-A(j,165)%j-A(j,168)%j-A(j,175)%j-A(j,176)%j &
       -A(j,221)%j-A(j,223)%j-A(j,229)%j-A(j,230)%j-A(j,232)%j-A(j,233)%j-A(j,235)%j-A(j,236)%j)*f(6))/6._/**/REALKIND+(( &
       -A(j,54)%j-A(j,56)%j-A(j,62)%j-A(j,64)%j-A(j,93)%j-A(j,97)%j-A(j,101)%j-A(j,107)%j-A(j,110)%j-A(j,127)%j-A(j,129)%j &
       -A(j,134)%j-A(j,140)%j-A(j,144)%j-A(j,151)%j-A(j,153)%j-A(j,167)%j-A(j,172)%j-A(j,174)%j-A(j,181)%j-A(j,186)%j-A(j,188)%j &
       -A(j,205)%j-A(j,208)%j-A(j,213)%j-A(j,217)%j-A(j,222)%j-A(j,238)%j-A(j,240)%j-A(j,243)%j)*f(6))/2._/**/REALKIND+(CI*( &
       -A(j,61)%j+A(j,126)%j-A(j,149)%j+A(j,182)%j+A(j,185)%j+A(j,206)%j-A(j,239)%j-A(j,242)%j)*f(7))/2._/**/REALKIND+((-A(j,59)%j &
       -A(j,66)%j-A(j,100)%j-A(j,115)%j-A(j,131)%j-A(j,146)%j-A(j,155)%j-A(j,179)%j-A(j,210)%j-A(j,225)%j)*f(8))/2._/**/REALKIND &
       +((-A(j,91)%j-A(j,92)%j-A(j,114)%j-A(j,116)%j-A(j,122)%j-A(j,123)%j-A(j,162)%j-A(j,163)%j-A(j,226)%j &
       -A(j,227)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,68)%j+A(j,132)%j-A(j,156)%j+A(j,211)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,55)%j &
       -A(j,58)%j+A(j,94)%j+A(j,98)%j)*f(10))/2._/**/REALKIND
  M2(3)%j = ((A(j,269)%j+A(j,270)%j+A(j,271)%j+A(j,273)%j+A(j,274)%j+A(j,277)%j+A(j,278)%j+A(j,279)%j+A(j,280)%j+A(j,281)%j &
       +A(j,283)%j+A(j,286)%j+A(j,287)%j+A(j,288)%j+A(j,289)%j+A(j,290)%j+A(j,291)%j+A(j,292)%j+A(j,354)%j+A(j,355)%j+A(j,358)%j &
       +A(j,362)%j+A(j,363)%j+A(j,364)%j+A(j,365)%j+A(j,366)%j+A(j,367)%j+A(j,372)%j+A(j,374)%j+A(j,375)%j)*f(3))/6._/**/REALKIND &
       +((A(j,245)%j+A(j,246)%j+A(j,247)%j+A(j,257)%j+A(j,260)%j+A(j,262)%j+A(j,266)%j+A(j,267)%j+A(j,268)%j+A(j,321)%j+A(j,322)%j &
       +A(j,325)%j+A(j,326)%j+A(j,327)%j+A(j,328)%j+A(j,335)%j+A(j,336)%j+A(j,337)%j+A(j,350)%j+A(j,351)%j+A(j,352)%j+A(j,353)%j &
       +A(j,356)%j+A(j,357)%j+A(j,371)%j+A(j,373)%j+A(j,376)%j+A(j,377)%j+A(j,378)%j+A(j,379)%j)*f(3))/2._/**/REALKIND &
       +(A(j,50)%j*f(4))/4._/**/REALKIND+((A(j,51)%j+A(j,52)%j)*f(4))/12._/**/REALKIND+(CI*(-A(j,249)%j-A(j,250)%j-A(j,253)%j &
       -A(j,258)%j-A(j,259)%j-A(j,261)%j+A(j,320)%j+A(j,323)%j+A(j,324)%j+A(j,330)%j+A(j,332)%j+A(j,333)%j)*f(5))/2._/**/REALKIND &
       +((-A(j,69)%j-A(j,71)%j-A(j,72)%j-A(j,73)%j-A(j,77)%j-A(j,79)%j-A(j,80)%j-A(j,81)%j-A(j,106)%j-A(j,108)%j-A(j,109)%j &
       -A(j,112)%j-A(j,137)%j-A(j,139)%j-A(j,169)%j-A(j,171)%j-A(j,189)%j-A(j,191)%j-A(j,192)%j-A(j,194)%j-A(j,195)%j-A(j,196)%j &
       -A(j,197)%j-A(j,199)%j-A(j,200)%j-A(j,201)%j-A(j,214)%j-A(j,216)%j-A(j,219)%j-A(j,220)%j)*f(6))/6._/**/REALKIND+(( &
       -A(j,53)%j-A(j,57)%j-A(j,63)%j-A(j,65)%j-A(j,95)%j-A(j,96)%j-A(j,104)%j-A(j,105)%j-A(j,111)%j-A(j,125)%j-A(j,128)%j &
       -A(j,135)%j-A(j,138)%j-A(j,141)%j-A(j,150)%j-A(j,152)%j-A(j,166)%j-A(j,170)%j-A(j,173)%j-A(j,183)%j-A(j,184)%j-A(j,187)%j &
       -A(j,207)%j-A(j,209)%j-A(j,215)%j-A(j,218)%j-A(j,224)%j-A(j,237)%j-A(j,241)%j-A(j,244)%j)*f(6))/2._/**/REALKIND &
       +(CI*(A(j,61)%j-A(j,126)%j+A(j,149)%j-A(j,182)%j-A(j,185)%j-A(j,206)%j+A(j,239)%j+A(j,242)%j)*f(7))/2._/**/REALKIND+(( &
       -A(j,75)%j-A(j,76)%j-A(j,82)%j-A(j,83)%j-A(j,145)%j-A(j,147)%j-A(j,178)%j-A(j,180)%j-A(j,202)%j &
       -A(j,204)%j)*f(8))/6._/**/REALKIND+((-A(j,60)%j-A(j,67)%j-A(j,99)%j-A(j,113)%j-A(j,130)%j-A(j,148)%j-A(j,154)%j-A(j,177)%j &
       -A(j,212)%j-A(j,228)%j)*f(8))/2._/**/REALKIND+(CI*(A(j,68)%j-A(j,132)%j+A(j,156)%j-A(j,211)%j)*f(9))/2._/**/REALKIND &
       +(CI*(A(j,55)%j+A(j,58)%j-A(j,94)%j-A(j,98)%j)*f(10))/2._/**/REALKIND
  M2(4)%j = ((-A(j,245)%j-A(j,246)%j-A(j,247)%j-A(j,248)%j-A(j,251)%j-A(j,252)%j-A(j,254)%j-A(j,255)%j-A(j,256)%j-A(j,257)%j &
       -A(j,260)%j-A(j,262)%j-A(j,263)%j-A(j,264)%j-A(j,265)%j-A(j,266)%j-A(j,267)%j-A(j,268)%j-A(j,341)%j-A(j,344)%j-A(j,345)%j &
       -A(j,350)%j-A(j,351)%j-A(j,352)%j-A(j,368)%j-A(j,369)%j-A(j,370)%j-A(j,371)%j-A(j,373)%j-A(j,376)%j)*f(3))/6._/**/REALKIND &
       +((-A(j,269)%j-A(j,270)%j-A(j,271)%j-A(j,281)%j-A(j,283)%j-A(j,286)%j-A(j,290)%j-A(j,291)%j-A(j,292)%j-A(j,296)%j &
       -A(j,299)%j-A(j,300)%j-A(j,302)%j-A(j,303)%j-A(j,304)%j-A(j,311)%j-A(j,312)%j-A(j,313)%j-A(j,342)%j-A(j,343)%j-A(j,346)%j &
       -A(j,362)%j-A(j,363)%j-A(j,364)%j-A(j,372)%j-A(j,374)%j-A(j,375)%j-A(j,380)%j-A(j,381)%j-A(j,382)%j)*f(3))/2._/**/REALKIND &
       +((-A(j,49)%j-A(j,50)%j)*f(4))/12._/**/REALKIND-(A(j,51)%j*f(4))/4._/**/REALKIND+(CI*(A(j,272)%j+A(j,275)%j+A(j,276)%j &
       +A(j,282)%j+A(j,284)%j+A(j,285)%j-A(j,297)%j-A(j,298)%j-A(j,301)%j-A(j,306)%j-A(j,307)%j-A(j,309)%j)*f(5))/2._/**/REALKIND &
       +((A(j,69)%j+A(j,73)%j+A(j,79)%j+A(j,81)%j+A(j,86)%j+A(j,88)%j+A(j,102)%j+A(j,108)%j+A(j,112)%j+A(j,118)%j+A(j,120)%j &
       +A(j,133)%j+A(j,139)%j+A(j,142)%j+A(j,159)%j+A(j,161)%j+A(j,168)%j+A(j,171)%j+A(j,176)%j+A(j,189)%j+A(j,194)%j+A(j,196)%j &
       +A(j,197)%j+A(j,200)%j+A(j,214)%j+A(j,219)%j+A(j,221)%j+A(j,230)%j+A(j,232)%j+A(j,235)%j)*f(6))/2._/**/REALKIND+((A(j,53)%j &
       +A(j,54)%j+A(j,56)%j+A(j,57)%j+A(j,62)%j+A(j,63)%j+A(j,64)%j+A(j,65)%j+A(j,101)%j+A(j,104)%j+A(j,110)%j+A(j,111)%j &
       +A(j,134)%j+A(j,135)%j+A(j,150)%j+A(j,151)%j+A(j,152)%j+A(j,153)%j+A(j,166)%j+A(j,167)%j+A(j,170)%j+A(j,172)%j+A(j,217)%j &
       +A(j,218)%j+A(j,237)%j+A(j,238)%j+A(j,240)%j+A(j,241)%j+A(j,243)%j+A(j,244)%j)*f(6))/6._/**/REALKIND+(CI*(-A(j,78)%j &
       +A(j,117)%j+A(j,157)%j-A(j,190)%j-A(j,193)%j-A(j,198)%j+A(j,231)%j+A(j,234)%j)*f(7))/2._/**/REALKIND+((A(j,76)%j+A(j,83)%j &
       +A(j,91)%j+A(j,114)%j+A(j,122)%j+A(j,147)%j+A(j,163)%j+A(j,180)%j+A(j,202)%j+A(j,226)%j)*f(8))/2._/**/REALKIND+((A(j,59)%j &
       +A(j,60)%j+A(j,66)%j+A(j,67)%j+A(j,146)%j+A(j,148)%j+A(j,154)%j+A(j,155)%j+A(j,225)%j+A(j,228)%j)*f(8))/6._/**/REALKIND &
       +(CI*(-A(j,84)%j+A(j,124)%j+A(j,164)%j-A(j,203)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,70)%j-A(j,74)%j+A(j,87)%j &
       +A(j,90)%j)*f(10))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_ppajjj_uuuxuxag_2_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for up up anti-up anti-up gamma glue -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for up up anti-up anti-up gamma glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,6)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for ppajjj_uuuxuxag_2:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_ppajjj_uuuxuxag_2, only: &
    & external_perm_inv_ppajjj_uuuxuxag_2
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 6
    r = external_perm_inv_ppajjj_uuuxuxag_2(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
        case(6)
          call assign_helicity_flip(ex6(:)%hf,ex6(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(64,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_ppajjj_uuuxuxag_2_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mflip(4)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 4
    do j = 1, 4
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_ppajjj_uuuxuxag_2_/**/REALKIND
