
module ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(360,12)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  144,   48,   48,   18,    0,   -6,   48,    0,    0,   48,   -6,    0]
  K1(  2,:) = [   48,  144,   18,   48,   -6,    0,    0,   48,   48,    0,    0,   -6]
  K1(  3,:) = [   48,   18,  144,   48,   48,    0,    0,   -6,   -6,    0,    0,   48]
  K1(  4,:) = [   18,   48,   48,  144,    0,   48,   -6,    0,    0,   -6,   48,    0]
  K1(  5,:) = [    0,   -6,   48,    0,  144,   48,   48,   18,  -18,   -6,   -6,   18]
  K1(  6,:) = [   -6,    0,    0,   48,   48,  144,   18,   48,   -6,  -18,   18,   -6]
  K1(  7,:) = [   48,    0,    0,   -6,   48,   18,  144,   48,   -6,   18,  -18,   -6]
  K1(  8,:) = [    0,   48,   -6,    0,   18,   48,   48,  144,   18,   -6,   -6,  -18]
  K1(  9,:) = [    0,   48,   -6,    0,  -18,   -6,   -6,   18,  144,   48,   48,   18]
  K1( 10,:) = [   48,    0,    0,   -6,   -6,  -18,   18,   -6,   48,  144,   18,   48]
  K1( 11,:) = [   -6,    0,    0,   48,   -6,   18,  -18,   -6,   48,   18,  144,   48]
  K1( 12,:) = [    0,   -6,   48,    0,   18,   -6,   -6,  -18,   18,   48,   48,  144]
  K1( 13,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 14,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 15,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 16,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 17,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 18,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 19,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 20,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 21,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 22,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 23,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 24,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 25,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 26,:) = [    8,    0,    6,    8,  -10,  -24,  -24,  -64,   -1,    3,    3,    8]
  K1( 27,:) = [    8,    6,    0,    8,   -1,    3,    3,    8,  -10,  -24,  -24,  -64]
  K1( 28,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1( 29,:) = [    0,  -10,   -1,    0,   -3,   -1,   -1,  -24,  -30,  -10,  -10,  -24]
  K1( 30,:) = [   -1,  -24,    3,    8,   -1,    0,  -21,  -64,  -10,    0,    6,    8]
  K1( 31,:) = [    8,  -24,    3,   -1,   -1,  -21,    0,  -64,  -10,    6,    0,    8]
  K1( 32,:) = [    0,  -64,    8,    0,  -24,  -64,  -64, -192,  -24,    8,    8,   24]
  K1( 33,:) = [    0,   -1,  -10,    0,  -30,  -10,  -10,  -24,   -3,   -1,   -1,  -24]
  K1( 34,:) = [    8,    3,  -24,   -1,  -10,    0,    6,    8,   -1,    0,  -21,  -64]
  K1( 35,:) = [   -1,    3,  -24,    8,  -10,    6,    0,    8,   -1,  -21,    0,  -64]
  K1( 36,:) = [    0,    8,  -64,    0,  -24,    8,    8,   24,  -24,  -64,  -64, -192]
  K1( 37,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 38,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 39,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 40,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 41,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 42,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 43,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 44,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 45,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 46,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 47,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 48,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 49,:) = [    0,   64,    1,   21,   -3,    1,   -8,   24,   24,   -8,    1,   -3]
  K1( 50,:) = [   64,    0,   21,    1,    1,   -3,   24,   -8,   -8,   24,   -3,    1]
  K1( 51,:) = [    1,   21,    0,   64,   -8,   24,   -3,    1,    1,   -3,   24,   -8]
  K1( 52,:) = [   21,    1,   64,    0,   24,   -8,    1,   -3,   -3,    1,   -8,   24]
  K1( 53,:) = [   -3,    1,   -8,   24,    0,   64,    1,   21,    0,   -8,   10,   -6]
  K1( 54,:) = [    1,   -3,   24,   -8,   64,    0,   21,    1,   -8,    0,   -6,   10]
  K1( 55,:) = [   -8,   24,   -3,    1,    1,   21,    0,   64,   10,   -6,    0,   -8]
  K1( 56,:) = [   24,   -8,    1,   -3,   21,    1,   64,    0,   -6,   10,   -8,    0]
  K1( 57,:) = [   24,   -8,    1,   -3,    0,   -8,   10,   -6,    0,   64,    1,   21]
  K1( 58,:) = [   -8,   24,   -3,    1,   -8,    0,   -6,   10,   64,    0,   21,    1]
  K1( 59,:) = [    1,   -3,   24,   -8,   10,   -6,    0,   -8,    1,   21,    0,   64]
  K1( 60,:) = [   -3,    1,   -8,   24,   -6,   10,   -8,    0,   21,    1,   64,    0]
  K1( 61,:) = [    0,    8,    8,    6,  -24,  -10,  -64,  -24,    3,   -1,    8,    3]
  K1( 62,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 63,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 64,:) = [    6,    8,    8,    0,    3,   -1,    8,    3,  -24,  -10,  -64,  -24]
  K1( 65,:) = [  -24,   -1,    8,    3,    0,   -1,  -64,  -21,    0,  -10,    8,    6]
  K1( 66,:) = [  -10,    0,    0,   -1,   -1,   -3,  -24,   -1,  -10,  -30,  -24,  -10]
  K1( 67,:) = [  -64,    0,    0,    8,  -64,  -24, -192,  -64,    8,  -24,   24,    8]
  K1( 68,:) = [  -24,    8,   -1,    3,  -21,   -1,  -64,    0,    6,  -10,    8,    0]
  K1( 69,:) = [    3,    8,   -1,  -24,    0,  -10,    8,    6,    0,   -1,  -64,  -21]
  K1( 70,:) = [   -1,    0,    0,  -10,  -10,  -30,  -24,  -10,   -1,   -3,  -24,   -1]
  K1( 71,:) = [    8,    0,    0,  -64,    8,  -24,   24,    8,  -64,  -24, -192,  -64]
  K1( 72,:) = [    3,   -1,    8,  -24,    6,  -10,    8,    0,  -21,   -1,  -64,    0]
  K1( 73,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 74,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 75,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 76,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 77,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 78,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 79,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 80,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 81,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 82,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 83,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 84,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 85,:) = [    0,    8,    8,    6,    3,    8,   -1,    3,  -24,  -64,  -10,  -24]
  K1( 86,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 87,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 88,:) = [    6,    8,    8,    0,  -24,  -64,  -10,  -24,    3,    8,   -1,    3]
  K1( 89,:) = [    3,   -1,    8,  -24,    0,  -64,   -1,  -21,    0,    8,  -10,    6]
  K1( 90,:) = [    8,    0,    0,  -64,  -64, -192,  -24,  -64,    8,   24,  -24,    8]
  K1( 91,:) = [   -1,    0,    0,  -10,   -1,  -24,   -3,   -1,  -10,  -24,  -30,  -10]
  K1( 92,:) = [    3,    8,   -1,  -24,  -21,  -64,   -1,    0,    6,    8,  -10,    0]
  K1( 93,:) = [  -24,    8,   -1,    3,    0,    8,  -10,    6,    0,  -64,   -1,  -21]
  K1( 94,:) = [  -64,    0,    0,    8,    8,   24,  -24,    8,  -64, -192,  -24,  -64]
  K1( 95,:) = [  -10,    0,    0,   -1,  -10,  -24,  -30,  -10,   -1,  -24,   -3,   -1]
  K1( 96,:) = [  -24,   -1,    8,    3,    6,    8,  -10,    0,  -21,  -64,   -1,    0]
  K1( 97,:) = [    0,    1,   64,   21,   24,    1,   -8,   -3,   -3,   -8,    1,   24]
  K1( 98,:) = [    1,    0,   21,   64,    1,   24,   -3,   -8,   -8,   -3,   24,    1]
  K1( 99,:) = [   64,   21,    0,    1,   -8,   -3,   24,    1,    1,   24,   -3,   -8]
  K1(100,:) = [   21,   64,    1,    0,   -3,   -8,    1,   24,   24,    1,   -8,   -3]
  K1(101,:) = [   24,    1,   -8,   -3,    0,    1,   64,   21,    0,   10,   -8,   -6]
  K1(102,:) = [    1,   24,   -3,   -8,    1,    0,   21,   64,   10,    0,   -6,   -8]
  K1(103,:) = [   -8,   -3,   24,    1,   64,   21,    0,    1,   -8,   -6,    0,   10]
  K1(104,:) = [   -3,   -8,    1,   24,   21,   64,    1,    0,   -6,   -8,   10,    0]
  K1(105,:) = [   -3,   -8,    1,   24,    0,   10,   -8,   -6,    0,    1,   64,   21]
  K1(106,:) = [   -8,   -3,   24,    1,   10,    0,   -6,   -8,    1,    0,   21,   64]
  K1(107,:) = [    1,   24,   -3,   -8,   -8,   -6,    0,   10,   64,   21,    0,    1]
  K1(108,:) = [   24,    1,   -8,   -3,   -6,   -8,   10,    0,   21,   64,    1,    0]
  K1(109,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1(110,:) = [    8,    0,    6,    8,    8,    3,    3,   -1,  -64,  -24,  -24,  -10]
  K1(111,:) = [    8,    6,    0,    8,  -64,  -24,  -24,  -10,    8,    3,    3,   -1]
  K1(112,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1(113,:) = [    0,    8,  -64,    0, -192,  -64,  -64,  -24,   24,    8,    8,  -24]
  K1(114,:) = [   -1,    3,  -24,    8,  -64,    0,  -21,   -1,    8,    0,    6,  -10]
  K1(115,:) = [    8,    3,  -24,   -1,  -64,  -21,    0,   -1,    8,    6,    0,  -10]
  K1(116,:) = [    0,   -1,  -10,    0,  -24,   -1,   -1,   -3,  -24,  -10,  -10,  -30]
  K1(117,:) = [    0,  -64,    8,    0,   24,    8,    8,  -24, -192,  -64,  -64,  -24]
  K1(118,:) = [    8,  -24,    3,   -1,    8,    0,    6,  -10,  -64,    0,  -21,   -1]
  K1(119,:) = [   -1,  -24,    3,    8,    8,    6,    0,  -10,  -64,  -21,    0,   -1]
  K1(120,:) = [    0,  -10,   -1,    0,  -24,  -10,  -10,  -30,  -24,   -1,   -1,   -3]
  K1(121,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1(122,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1(123,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1(124,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1(125,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1(126,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1(127,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1(128,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1(129,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1(130,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1(131,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1(132,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1(133,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(134,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(135,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(136,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(137,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(138,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(139,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(140,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(141,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(142,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(143,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(144,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(145,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(146,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(147,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(148,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(149,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(150,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(151,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(152,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(153,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(154,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(155,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(156,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(157,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(158,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(159,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(160,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(161,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(162,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(163,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(164,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(165,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(166,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(167,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(168,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(169,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(170,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(171,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(172,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(173,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(174,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(175,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(176,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(177,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(178,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(179,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(180,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(181,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(182,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(183,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(184,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(185,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(186,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(187,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(188,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(189,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(190,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(191,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(192,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(193,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(194,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(195,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(196,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(197,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(198,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(199,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(200,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(201,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(202,:) = [   72,    0,   27,    9,    9,    0,   27,   -9,  -72,    0,  -27,   -9]
  K1(203,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(204,:) = [   27,    9,   72,    0,   27,   -9,    9,    0,  -27,   -9,  -72,    0]
  K1(205,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(206,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(207,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(208,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(209,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(210,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(211,:) = [   72,   27,    0,    9,  -72,  -27,    0,   -9,    9,   27,    0,   -9]
  K1(212,:) = [   27,   72,    9,    0,  -27,  -72,   -9,    0,   27,    9,   -9,    0]
  K1(213,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(214,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(215,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(216,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(217,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(218,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(219,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(220,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(221,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(222,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(223,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(224,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(225,:) = [    0,   72,    9,   27,    0,    9,   -9,   27,    0,  -72,   -9,  -27]
  K1(226,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(227,:) = [    9,   27,    0,   72,   -9,   27,    0,    9,   -9,  -27,    0,  -72]
  K1(228,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(229,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(230,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(231,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(232,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(233,:) = [    0,    9,   72,   27,    0,   -9,  -72,  -27,    0,   -9,    9,   27]
  K1(234,:) = [    9,    0,   27,   72,   -9,    0,  -27,  -72,   -9,    0,   27,    9]
  K1(235,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(236,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(237,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(238,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(239,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(240,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(241,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(242,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(243,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(244,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(245,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(246,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(247,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(248,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(249,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(250,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(251,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(252,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(253,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(254,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(255,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(256,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(257,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(258,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(259,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(260,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(261,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(262,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(263,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(264,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(265,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(266,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(267,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(268,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(269,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(270,:) = [    9,   27,    0,   72,  -72,    0,  -27,   -9,    9,    0,   27,   -9]
  K1(271,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(272,:) = [    0,   72,    9,   27,  -27,   -9,  -72,    0,   27,   -9,    9,    0]
  K1(273,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(274,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(275,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(276,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(277,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(278,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(279,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(280,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(281,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(282,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(283,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(284,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(285,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(286,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(287,:) = [    9,    0,   27,   72,    9,   27,    0,   -9,  -72,  -27,    0,   -9]
  K1(288,:) = [    0,    9,   72,   27,   27,    9,   -9,    0,  -27,  -72,   -9,    0]
  K1(289,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(290,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(291,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(292,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(293,:) = [   27,    9,   72,    0,    0,  -72,   -9,  -27,    0,    9,   -9,   27]
  K1(294,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(295,:) = [   72,    0,   27,    9,   -9,  -27,    0,  -72,   -9,   27,    0,    9]
  K1(296,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(297,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(298,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(299,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(300,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(301,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(302,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(303,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(304,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(305,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(306,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(307,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(308,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(309,:) = [   27,   72,    9,    0,    0,   -9,    9,   27,    0,   -9,  -72,  -27]
  K1(310,:) = [   72,   27,    0,    9,   -9,    0,   27,    9,   -9,    0,  -27,  -72]
  K1(311,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(312,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(313,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(314,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(315,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(316,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(317,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(318,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(319,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(320,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(321,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(322,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(323,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(324,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(325,:) = [    0,   81,   81,   54,    0,    0,  -81,    0,    0,  -81,    0,    0]
  K1(326,:) = [   81,    0,   54,   81,    0,    0,    0,  -81,  -81,    0,    0,    0]
  K1(327,:) = [   81,   54,    0,   81,  -81,    0,    0,    0,    0,    0,    0,  -81]
  K1(328,:) = [   54,   81,   81,    0,    0,  -81,    0,    0,    0,    0,  -81,    0]
  K1(329,:) = [    0,    0,  -81,    0, -243,  -81,  -81,  -54,    0,    0,    0,  -54]
  K1(330,:) = [    0,    0,    0,  -81,  -81, -243,  -54,  -81,    0,    0,  -54,    0]
  K1(331,:) = [  -81,    0,    0,    0,  -81,  -54, -243,  -81,    0,  -54,    0,    0]
  K1(332,:) = [    0,  -81,    0,    0,  -54,  -81,  -81, -243,  -54,    0,    0,    0]
  K1(333,:) = [    0,  -81,    0,    0,    0,    0,    0,  -54, -243,  -81,  -81,  -54]
  K1(334,:) = [  -81,    0,    0,    0,    0,    0,  -54,    0,  -81, -243,  -54,  -81]
  K1(335,:) = [    0,    0,    0,  -81,    0,  -54,    0,    0,  -81,  -54, -243,  -81]
  K1(336,:) = [    0,    0,  -81,    0,  -54,    0,    0,    0,  -54,  -81,  -81, -243]
  K1(337,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(338,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(339,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(340,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(341,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(342,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(343,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(344,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(345,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(346,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(347,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(348,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(349,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(350,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(351,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(352,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(353,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(354,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(355,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(356,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(357,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(358,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(359,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(360,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 9) * K1


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND



module ol_forced_parameters_ppajjj_ddxssxagg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppajjj_ddxssxagg_1_/**/REALKIND

module ol_tree_ppajjj_ddxssxagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(2)
  complex(REALKIND), save :: den(311)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  complex(DREALKIND) :: M1helarr(12,128) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED*gQCD**4)/3._/**/REALKIND
    f(2) = (eQED*gQCD**4)/3._/**/REALKIND

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,20))+L(6,20))
  den(2) = 1 /((L(5,3))+L(6,3))
  den(3) = 1 /((L(5,28))+L(6,28))
  den(6) = 1 /((L(5,24))+L(6,24))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(10) = 1 /((L(5,12))+L(6,12))
  den(11) = 1 /((L(5,19))+L(6,19))
  den(14) = 1 /((L(5,18))+L(6,18))
  den(17) = 1 /((L(5,40))+L(6,40))
  den(19) = 1 /((L(5,67))+L(6,67))
  den(23) = 1 /((L(5,84))+L(6,84))
  den(27) = 1 /((L(5,104))+L(6,104))
  den(30) = 1 /((L(5,72))+L(6,72))
  den(32) = 1 /((L(5,35))+L(6,35))
  den(36) = 1 /((L(5,52))+L(6,52))
  den(41) = 1 /((L(5,96))+L(6,96))
  den(43) = 1 /((L(5,11))+L(6,11))
  den(56) = 1 /((L(5,36))+L(6,36))
  den(60) = 1 /((L(5,100))+L(6,100))
  den(64) = 1 /((L(5,88))+L(6,88))
  den(67) = 1 /((L(5,68))+L(6,68))
  den(73) = 1 /((L(5,56))+L(6,56))
  den(77) = 1 /((L(5,7))+L(6,7))
  den(111) = 1 /((L(5,34))+L(6,34))
  den(113) = 1 /((L(5,81))+L(6,81))
  den(117) = 1 /((L(5,98))+L(6,98))
  den(121) = 1 /((L(5,76))+L(6,76))
  den(124) = 1 /((L(5,66))+L(6,66))
  den(126) = 1 /((L(5,49))+L(6,49))
  den(132) = 1 /((L(5,44))+L(6,44))
  den(138) = 1 /((L(5,14))+L(6,14))
  den(149) = 1 /((L(5,33))+L(6,33))
  den(151) = 1 /((L(5,97))+L(6,97))
  den(155) = 1 /((L(5,82))+L(6,82))
  den(160) = 1 /((L(5,65))+L(6,65))
  den(164) = 1 /((L(5,50))+L(6,50))
  den(171) = 1 /((L(5,13))+L(6,13))

  ! denominators

  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(3)*den(6)
  den(8) = den(2)*den(7)
  den(12) = den(9)*den(11)
  den(13) = den(10)*den(12)
  den(15) = den(11)*den(14)
  den(16) = den(10)*den(15)
  den(18) = den(1)*den(17)
  den(20) = den(2)*den(19)
  den(21) = den(18)*den(20)
  den(22) = den(2)*den(17)
  den(24) = den(1)*den(23)
  den(25) = den(22)*den(24)
  den(26) = den(1)*den(2)
  den(28) = den(17)*den(27)
  den(29) = den(26)*den(28)
  den(31) = den(1)*den(30)
  den(33) = den(2)*den(32)
  den(34) = den(31)*den(33)
  den(35) = den(2)*den(30)
  den(37) = den(1)*den(36)
  den(38) = den(35)*den(37)
  den(39) = den(27)*den(30)
  den(40) = den(26)*den(39)
  den(42) = den(1)*den(41)
  den(44) = den(2)*den(43)
  den(45) = den(42)*den(44)
  den(46) = den(2)*den(41)
  den(47) = den(4)*den(46)
  den(48) = den(27)*den(41)
  den(49) = den(26)*den(48)
  den(50) = den(37)*den(44)
  den(51) = den(24)*den(44)
  den(52) = den(4)*den(33)
  den(53) = den(24)*den(33)
  den(54) = den(4)*den(20)
  den(55) = den(20)*den(37)
  den(57) = den(6)*den(56)
  den(58) = den(20)*den(57)
  den(59) = den(2)*den(6)
  den(61) = den(56)*den(60)
  den(62) = den(59)*den(61)
  den(63) = den(2)*den(56)
  den(65) = den(6)*den(64)
  den(66) = den(63)*den(65)
  den(68) = den(6)*den(67)
  den(69) = den(33)*den(68)
  den(70) = den(60)*den(67)
  den(71) = den(59)*den(70)
  den(72) = den(2)*den(67)
  den(74) = den(6)*den(73)
  den(75) = den(72)*den(74)
  den(76) = den(6)*den(41)
  den(78) = den(2)*den(77)
  den(79) = den(76)*den(78)
  den(80) = den(7)*den(46)
  den(81) = den(41)*den(60)
  den(82) = den(59)*den(81)
  den(83) = den(65)*den(78)
  den(84) = den(74)*den(78)
  den(85) = den(7)*den(33)
  den(86) = den(33)*den(65)
  den(87) = den(7)*den(20)
  den(88) = den(20)*den(74)
  den(89) = den(36)*den(56)
  den(90) = den(35)*den(89)
  den(91) = den(30)*den(64)
  den(92) = den(63)*den(91)
  den(93) = den(44)*den(89)
  den(94) = den(44)*den(61)
  den(95) = den(20)*den(89)
  den(96) = den(23)*den(67)
  den(97) = den(22)*den(96)
  den(98) = den(17)*den(73)
  den(99) = den(72)*den(98)
  den(100) = den(28)*den(78)
  den(101) = den(78)*den(98)
  den(102) = den(20)*den(98)
  den(103) = den(44)*den(96)
  den(104) = den(44)*den(70)
  den(105) = den(33)*den(96)
  den(106) = den(39)*den(78)
  den(107) = den(78)*den(91)
  den(108) = den(33)*den(91)
  den(109) = den(48)*den(78)
  den(110) = den(44)*den(81)
  den(112) = den(10)*den(111)
  den(114) = den(9)*den(113)
  den(115) = den(112)*den(114)
  den(116) = den(9)*den(10)
  den(118) = den(111)*den(117)
  den(119) = den(116)*den(118)
  den(120) = den(9)*den(111)
  den(122) = den(10)*den(121)
  den(123) = den(120)*den(122)
  den(125) = den(10)*den(124)
  den(127) = den(9)*den(126)
  den(128) = den(125)*den(127)
  den(129) = den(117)*den(124)
  den(130) = den(116)*den(129)
  den(131) = den(9)*den(124)
  den(133) = den(10)*den(132)
  den(134) = den(131)*den(133)
  den(135) = den(10)*den(41)
  den(136) = den(12)*den(135)
  den(137) = den(9)*den(41)
  den(139) = den(10)*den(138)
  den(140) = den(137)*den(139)
  den(141) = den(41)*den(117)
  den(142) = den(116)*den(141)
  den(143) = den(12)*den(122)
  den(144) = den(12)*den(133)
  den(145) = den(127)*den(139)
  den(146) = den(122)*den(127)
  den(147) = den(114)*den(139)
  den(148) = den(114)*den(133)
  den(150) = den(10)*den(14)
  den(152) = den(149)*den(151)
  den(153) = den(150)*den(152)
  den(154) = den(10)*den(149)
  den(156) = den(14)*den(155)
  den(157) = den(154)*den(156)
  den(158) = den(14)*den(149)
  den(159) = den(122)*den(158)
  den(161) = den(151)*den(160)
  den(162) = den(150)*den(161)
  den(163) = den(10)*den(160)
  den(165) = den(14)*den(164)
  den(166) = den(163)*den(165)
  den(167) = den(14)*den(160)
  den(168) = den(133)*den(167)
  den(169) = den(15)*den(135)
  den(170) = den(14)*den(41)
  den(172) = den(10)*den(171)
  den(173) = den(170)*den(172)
  den(174) = den(41)*den(151)
  den(175) = den(150)*den(174)
  den(176) = den(15)*den(122)
  den(177) = den(15)*den(133)
  den(178) = den(156)*den(172)
  den(179) = den(165)*den(172)
  den(180) = den(122)*den(165)
  den(181) = den(133)*den(156)
  den(182) = den(126)*den(149)
  den(183) = den(125)*den(182)
  den(184) = den(124)*den(155)
  den(185) = den(154)*den(184)
  den(186) = den(139)*den(182)
  den(187) = den(122)*den(182)
  den(188) = den(139)*den(152)
  den(189) = den(113)*den(160)
  den(190) = den(112)*den(189)
  den(191) = den(111)*den(164)
  den(192) = den(163)*den(191)
  den(193) = den(118)*den(172)
  den(194) = den(172)*den(191)
  den(195) = den(122)*den(191)
  den(196) = den(139)*den(189)
  den(197) = den(133)*den(189)
  den(198) = den(139)*den(161)
  den(199) = den(129)*den(172)
  den(200) = den(172)*den(184)
  den(201) = den(133)*den(184)
  den(202) = den(141)*den(172)
  den(203) = den(139)*den(174)
  den(204) = den(67)*den(121)
  den(205) = den(120)*den(204)
  den(206) = den(30)*den(121)
  den(207) = den(120)*den(206)
  den(208) = den(56)*den(132)
  den(209) = den(131)*den(208)
  den(210) = den(30)*den(56)
  den(211) = den(12)*den(210)
  den(212) = den(12)*den(61)
  den(213) = den(12)*den(208)
  den(214) = den(114)*den(208)
  den(215) = den(17)*den(132)
  den(216) = den(131)*den(215)
  den(217) = den(17)*den(67)
  den(218) = den(12)*den(217)
  den(219) = den(12)*den(28)
  den(220) = den(12)*den(215)
  den(221) = den(114)*den(215)
  den(222) = den(12)*den(70)
  den(223) = den(12)*den(204)
  den(224) = den(127)*den(204)
  den(225) = den(12)*den(39)
  den(226) = den(12)*den(206)
  den(227) = den(127)*den(206)
  den(228) = den(12)*den(48)
  den(229) = den(12)*den(81)
  den(230) = den(158)*den(204)
  den(231) = den(158)*den(206)
  den(232) = den(167)*den(208)
  den(233) = den(15)*den(210)
  den(234) = den(15)*den(61)
  den(235) = den(15)*den(208)
  den(236) = den(156)*den(208)
  den(237) = den(167)*den(215)
  den(238) = den(15)*den(217)
  den(239) = den(15)*den(28)
  den(240) = den(15)*den(215)
  den(241) = den(156)*den(215)
  den(242) = den(15)*den(70)
  den(243) = den(15)*den(204)
  den(244) = den(165)*den(204)
  den(245) = den(15)*den(39)
  den(246) = den(15)*den(206)
  den(247) = den(165)*den(206)
  den(248) = den(15)*den(48)
  den(249) = den(15)*den(81)
  den(250) = den(124)*den(149)
  den(251) = den(4)*den(250)
  den(252) = den(32)*den(149)
  den(253) = den(31)*den(252)
  den(254) = den(24)*den(252)
  den(255) = den(4)*den(252)
  den(256) = den(4)*den(152)
  den(257) = den(111)*den(160)
  den(258) = den(4)*den(257)
  den(259) = den(32)*den(111)
  den(260) = den(31)*den(259)
  den(261) = den(24)*den(259)
  den(262) = den(4)*den(259)
  den(263) = den(4)*den(118)
  den(264) = den(19)*den(160)
  den(265) = den(18)*den(264)
  den(266) = den(19)*den(124)
  den(267) = den(18)*den(266)
  den(268) = den(37)*den(264)
  den(269) = den(4)*den(264)
  den(270) = den(4)*den(161)
  den(271) = den(37)*den(266)
  den(272) = den(4)*den(266)
  den(273) = den(4)*den(129)
  den(274) = den(4)*den(141)
  den(275) = den(4)*den(174)
  den(276) = den(7)*den(250)
  den(277) = den(68)*den(252)
  den(278) = den(65)*den(252)
  den(279) = den(7)*den(252)
  den(280) = den(7)*den(152)
  den(281) = den(7)*den(257)
  den(282) = den(68)*den(259)
  den(283) = den(65)*den(259)
  den(284) = den(7)*den(259)
  den(285) = den(7)*den(118)
  den(286) = den(57)*den(264)
  den(287) = den(57)*den(266)
  den(288) = den(74)*den(264)
  den(289) = den(7)*den(264)
  den(290) = den(7)*den(161)
  den(291) = den(74)*den(266)
  den(292) = den(7)*den(266)
  den(293) = den(7)*den(129)
  den(294) = den(7)*den(141)
  den(295) = den(7)*den(174)
  den(296) = den(96)*den(252)
  den(297) = den(182)*den(204)
  den(298) = den(91)*den(252)
  den(299) = den(182)*den(206)
  den(300) = den(96)*den(259)
  den(301) = den(191)*den(204)
  den(302) = den(91)*den(259)
  den(303) = den(191)*den(206)
  den(304) = den(89)*den(264)
  den(305) = den(189)*den(208)
  den(306) = den(89)*den(266)
  den(307) = den(184)*den(208)
  den(308) = den(98)*den(264)
  den(309) = den(189)*den(215)
  den(310) = den(98)*den(266)
  den(311) = den(184)*den(215)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppajjj_ddxssxagg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppajjj_ddxssxagg_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for down anti-down strange anti-strange gamma glue glue -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppajjj_ddxssxagg_1, only: &
    & external_perm_ppajjj_ddxssxagg_1, &
    & external_perm_inv_ppajjj_ddxssxagg_1, &
    & extcomb_perm_ppajjj_ddxssxagg_1, &
    & average_factor_ppajjj_ddxssxagg_1, &
    & photonid_ppajjj_ddxssxagg_1
  use ol_external_ppajjj_ddxssxagg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppajjj_ddxssxagg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppajjj_ddxssxagg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(12), M1helarray(12,128)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,27), wf8(8,80), wf16(16,104), wf128(128,204)

  type(polcont) :: A(128,204)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    call check_forced_parameters()
  end if
  call factors_init()

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
      &  external_perm_inv_ppajjj_ddxssxagg_1, 7,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppajjj_ddxssxagg_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppajjj_ddxssxagg_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
       & extcomb_perm_ppajjj_ddxssxagg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_A(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_A(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_V(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_V(P(:,6), rZERO, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5, ex3, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,2), 20, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call vert_QA_V(ntry, wf4(:,3), ex4, wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_GGG_G(ntry, wf4(:,1), ex6, ex7, wf16(:,1), n4(:,1), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,1), wf16(:,2), n4(:,2), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex7, wf4(:,1), ex6, wf16(:,3), n4(:,3), t4x16(:,:,3))
  call vert_AV_Q(ntry, ex4, ex5, wf4(:,4), n3(:,4), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,4), 24, ZERO, 0_intkind1, wf4(:,5), n2(2))
  call vert_QA_V(ntry, ex3, wf4(:,5), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_VQ_A(ntry, ex5, ex1, wf4(:,6), n3(:,6), t3x4(:,:,4))
  call vert_QA_V(ntry, ex3, ex4, wf4(:,7), n3(:,7), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,6), 17, ZERO, 0_intkind1, wf4(:,8), n2(3))
  call vert_QA_V(ntry, wf4(:,8), ex2, wf8(:,3), n3(:,8), t3x8(:,:,3))
  call vert_GGG_G(ntry, wf4(:,7), ex6, ex7, wf16(:,4), n4(:,4), t4x16(:,:,4))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,7), wf16(:,5), n4(:,5), t4x16(:,:,5))
  call vert_GGG_G(ntry, ex7, wf4(:,7), ex6, wf16(:,6), n4(:,6), t4x16(:,:,6))
  call vert_AV_Q(ntry, ex2, ex5, wf4(:,9), n3(:,9), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,9), 18, ZERO, 0_intkind1, wf4(:,10), n2(4))
  call vert_QA_V(ntry, ex1, wf4(:,10), wf8(:,4), n3(:,10), t3x8(:,:,4))
  call vert_AV_Q(ntry, ex4, ex6, wf4(:,11), n3(:,11), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,11), 40, ZERO, 0_intkind1, wf4(:,12), n2(5))
  call vert_UV_W(ntry, wf4(:,1), 3, ex7, 64, wf8(:,5), n3(:,12), t3x8(:,:,5))
  call vert_QA_V(ntry, wf4(:,3), wf4(:,12), wf16(:,7), n3(:,13), t3x16(:,:,1))
  call vert_VQ_A(ntry, ex7, wf4(:,3), wf8(:,6), n3(:,14), t3x8(:,:,6))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,1), wf16(:,8), n3(:,15), t3x16(:,:,2))
  call prop_Q_A(ntry, wf8(:,6), 84, ZERO, 0_intkind1, wf8(:,7), n2(6))
  call vert_AV_Q(ntry, wf4(:,12), ex7, wf8(:,8), n3(:,16), t3x8(:,:,7))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,3), wf16(:,9), n3(:,17), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,8), 104, ZERO, 0_intkind1, wf8(:,9), n2(7))
  call vert_AV_Q(ntry, ex4, ex7, wf4(:,13), n3(:,18), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,13), 72, ZERO, 0_intkind1, wf4(:,14), n2(8))
  call vert_UV_W(ntry, wf4(:,1), 3, ex6, 32, wf8(:,10), n3(:,19), t3x8(:,:,8))
  call vert_QA_V(ntry, wf4(:,3), wf4(:,14), wf16(:,10), n3(:,20), t3x16(:,:,4))
  call vert_VQ_A(ntry, ex6, wf4(:,3), wf8(:,11), n3(:,21), t3x8(:,:,9))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,11), n3(:,22), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,11), 52, ZERO, 0_intkind1, wf8(:,12), n2(9))
  call vert_AV_Q(ntry, wf4(:,14), ex6, wf8(:,13), n3(:,23), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,13), 104, ZERO, 0_intkind1, wf8(:,14), n2(10))
  call vert_UV_W(ntry, ex6, 32, ex7, 64, wf4(:,15), n3(:,24), t3x4(:,:,9))
  call vert_AV_Q(ntry, ex4, wf4(:,1), wf8(:,15), n3(:,25), t3x8(:,:,11))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,3), wf16(:,12), n3(:,26), t3x16(:,:,6))
  call prop_A_Q(ntry, wf8(:,15), 11, ZERO, 0_intkind1, wf8(:,16), n2(11))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,15), 96, wf16(:,13), n3(:,27), t3x16(:,:,7))
  call vert_AV_Q(ntry, ex4, wf4(:,15), wf8(:,17), n3(:,28), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,17), 104, ZERO, 0_intkind1, wf8(:,18), n2(12))
  call vert_AV_Q(ntry, wf8(:,16), ex7, wf16(:,14), n3(:,29), t3x16(:,:,8))
  call vert_AV_Q(ntry, wf8(:,16), ex6, wf16(:,15), n3(:,30), t3x16(:,:,9))
  call vert_UV_W(ntry, wf8(:,1), 28, ex7, 64, wf16(:,16), n3(:,31), t3x16(:,:,10))
  call vert_AV_Q(ntry, ex4, wf8(:,10), wf16(:,17), n3(:,32), t3x16(:,:,11))
  call vert_UV_W(ntry, wf8(:,1), 28, ex6, 32, wf16(:,18), n3(:,33), t3x16(:,:,12))
  call vert_QA_V(ntry, wf8(:,12), ex4, wf16(:,19), n3(:,34), t3x16(:,:,13))
  call vert_VQ_A(ntry, ex6, ex3, wf4(:,16), n3(:,35), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,16), 36, ZERO, 0_intkind1, wf4(:,17), n2(13))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,5), wf16(:,20), n3(:,36), t3x16(:,:,14))
  call vert_VQ_A(ntry, ex7, wf4(:,17), wf8(:,19), n3(:,37), t3x8(:,:,13))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,1), wf16(:,21), n3(:,38), t3x16(:,:,15))
  call prop_Q_A(ntry, wf8(:,19), 100, ZERO, 0_intkind1, wf8(:,20), n2(14))
  call vert_AV_Q(ntry, wf4(:,5), ex7, wf8(:,21), n3(:,39), t3x8(:,:,14))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,17), wf16(:,22), n3(:,40), t3x16(:,:,16))
  call prop_A_Q(ntry, wf8(:,21), 88, ZERO, 0_intkind1, wf8(:,22), n2(15))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,18), n3(:,41), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,18), 68, ZERO, 0_intkind1, wf4(:,19), n2(16))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,5), wf16(:,23), n3(:,42), t3x16(:,:,17))
  call vert_VQ_A(ntry, ex6, wf4(:,19), wf8(:,23), n3(:,43), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,23), 100, ZERO, 0_intkind1, wf8(:,24), n2(17))
  call vert_AV_Q(ntry, wf4(:,5), ex6, wf8(:,25), n3(:,44), t3x8(:,:,16))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,19), wf16(:,24), n3(:,45), t3x16(:,:,18))
  call prop_A_Q(ntry, wf8(:,25), 56, ZERO, 0_intkind1, wf8(:,26), n2(18))
  call vert_VQ_A(ntry, wf4(:,1), ex3, wf8(:,27), n3(:,46), t3x8(:,:,17))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,15), wf16(:,25), n3(:,47), t3x16(:,:,19))
  call prop_Q_A(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,28), n2(19))
  call vert_VQ_A(ntry, wf4(:,15), ex3, wf8(:,29), n3(:,48), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,29), 100, ZERO, 0_intkind1, wf8(:,30), n2(20))
  call vert_VQ_A(ntry, ex6, wf8(:,28), wf16(:,26), n3(:,49), t3x16(:,:,20))
  call vert_VQ_A(ntry, ex7, wf8(:,28), wf16(:,27), n3(:,50), t3x16(:,:,21))
  call vert_UV_W(ntry, wf8(:,2), 28, ex7, 64, wf16(:,28), n3(:,51), t3x16(:,:,22))
  call vert_VQ_A(ntry, wf8(:,10), ex3, wf16(:,29), n3(:,52), t3x16(:,:,23))
  call vert_UV_W(ntry, wf8(:,2), 28, ex6, 32, wf16(:,30), n3(:,53), t3x16(:,:,24))
  call vert_QA_V(ntry, ex3, wf8(:,26), wf16(:,31), n3(:,54), t3x16(:,:,25))
  call vert_VQ_A(ntry, ex5, wf4(:,17), wf8(:,31), n3(:,55), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,31), 52, ZERO, 0_intkind1, wf8(:,32), n2(21))
  call vert_AV_Q(ntry, wf4(:,14), ex5, wf8(:,33), n3(:,56), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,33), 88, ZERO, 0_intkind1, wf8(:,34), n2(22))
  call vert_AV_Q(ntry, wf8(:,16), ex5, wf16(:,32), n3(:,57), t3x16(:,:,26))
  call vert_QA_V(ntry, wf8(:,32), ex4, wf16(:,33), n3(:,58), t3x16(:,:,27))
  call vert_VQ_A(ntry, ex5, wf4(:,19), wf8(:,35), n3(:,59), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,35), 84, ZERO, 0_intkind1, wf8(:,36), n2(23))
  call vert_AV_Q(ntry, wf4(:,12), ex5, wf8(:,37), n3(:,60), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,37), 56, ZERO, 0_intkind1, wf8(:,38), n2(24))
  call vert_VQ_A(ntry, ex5, wf8(:,28), wf16(:,34), n3(:,61), t3x16(:,:,28))
  call vert_QA_V(ntry, ex3, wf8(:,38), wf16(:,35), n3(:,62), t3x16(:,:,29))
  call vert_QA_V(ntry, wf8(:,36), ex4, wf16(:,36), n3(:,63), t3x16(:,:,30))
  call vert_QA_V(ntry, ex3, wf8(:,34), wf16(:,37), n3(:,64), t3x16(:,:,31))
  call vert_VQ_A(ntry, ex5, wf8(:,30), wf16(:,38), n3(:,65), t3x16(:,:,32))
  call vert_AV_Q(ntry, ex2, ex6, wf4(:,20), n3(:,66), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,20), 34, ZERO, 0_intkind1, wf4(:,21), n2(25))
  call vert_VQ_A(ntry, ex7, wf4(:,8), wf8(:,39), n3(:,67), t3x8(:,:,23))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,7), wf16(:,39), n3(:,68), t3x16(:,:,33))
  call prop_Q_A(ntry, wf8(:,39), 81, ZERO, 0_intkind1, wf8(:,40), n2(26))
  call vert_AV_Q(ntry, wf4(:,21), ex7, wf8(:,41), n3(:,69), t3x8(:,:,24))
  call vert_VQ_A(ntry, wf4(:,7), wf4(:,8), wf16(:,40), n3(:,70), t3x16(:,:,34))
  call prop_A_Q(ntry, wf8(:,41), 98, ZERO, 0_intkind1, wf8(:,42), n2(27))
  call vert_UV_W(ntry, wf4(:,7), 12, ex7, 64, wf8(:,43), n3(:,71), t3x8(:,:,25))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,21), wf16(:,41), n3(:,72), t3x16(:,:,35))
  call vert_AV_Q(ntry, ex2, ex7, wf4(:,22), n3(:,73), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,22), 66, ZERO, 0_intkind1, wf4(:,23), n2(28))
  call vert_VQ_A(ntry, ex6, wf4(:,8), wf8(:,44), n3(:,74), t3x8(:,:,26))
  call vert_AV_Q(ntry, wf4(:,23), wf4(:,7), wf16(:,42), n3(:,75), t3x16(:,:,36))
  call prop_Q_A(ntry, wf8(:,44), 49, ZERO, 0_intkind1, wf8(:,45), n2(29))
  call vert_AV_Q(ntry, wf4(:,23), ex6, wf8(:,46), n3(:,76), t3x8(:,:,27))
  call prop_A_Q(ntry, wf8(:,46), 98, ZERO, 0_intkind1, wf8(:,47), n2(30))
  call vert_UV_W(ntry, wf4(:,7), 12, ex6, 32, wf8(:,48), n3(:,77), t3x8(:,:,28))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,23), wf16(:,43), n3(:,78), t3x16(:,:,37))
  call vert_UV_W(ntry, wf4(:,7), 12, wf4(:,15), 96, wf16(:,44), n3(:,79), t3x16(:,:,38))
  call vert_AV_Q(ntry, ex2, wf4(:,7), wf8(:,49), n3(:,80), t3x8(:,:,29))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,8), wf16(:,45), n3(:,81), t3x16(:,:,39))
  call prop_A_Q(ntry, wf8(:,49), 14, ZERO, 0_intkind1, wf8(:,50), n2(31))
  call vert_AV_Q(ntry, ex2, wf4(:,15), wf8(:,51), n3(:,82), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,51), 98, ZERO, 0_intkind1, wf8(:,52), n2(32))
  call vert_UV_W(ntry, wf8(:,3), 19, ex6, 32, wf16(:,46), n3(:,83), t3x16(:,:,40))
  call vert_UV_W(ntry, wf8(:,3), 19, ex7, 64, wf16(:,47), n3(:,84), t3x16(:,:,41))
  call vert_AV_Q(ntry, wf8(:,50), ex7, wf16(:,48), n3(:,85), t3x16(:,:,42))
  call vert_QA_V(ntry, wf8(:,45), ex2, wf16(:,49), n3(:,86), t3x16(:,:,43))
  call vert_AV_Q(ntry, wf8(:,50), ex6, wf16(:,50), n3(:,87), t3x16(:,:,44))
  call vert_AV_Q(ntry, ex2, wf8(:,48), wf16(:,51), n3(:,88), t3x16(:,:,45))
  call vert_VQ_A(ntry, ex6, ex1, wf4(:,24), n3(:,89), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,24), 33, ZERO, 0_intkind1, wf4(:,25), n2(33))
  call vert_VQ_A(ntry, ex7, wf4(:,25), wf8(:,53), n3(:,90), t3x8(:,:,31))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,7), wf16(:,52), n3(:,91), t3x16(:,:,46))
  call prop_Q_A(ntry, wf8(:,53), 97, ZERO, 0_intkind1, wf8(:,54), n2(34))
  call vert_AV_Q(ntry, wf4(:,10), ex7, wf8(:,55), n3(:,92), t3x8(:,:,32))
  call vert_VQ_A(ntry, wf4(:,7), wf4(:,25), wf16(:,53), n3(:,93), t3x16(:,:,47))
  call prop_A_Q(ntry, wf8(:,55), 82, ZERO, 0_intkind1, wf8(:,56), n2(35))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,10), wf16(:,54), n3(:,94), t3x16(:,:,48))
  call vert_VQ_A(ntry, ex7, ex1, wf4(:,26), n3(:,95), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,26), 65, ZERO, 0_intkind1, wf4(:,27), n2(36))
  call vert_VQ_A(ntry, ex6, wf4(:,27), wf8(:,57), n3(:,96), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,57), 97, ZERO, 0_intkind1, wf8(:,58), n2(37))
  call vert_AV_Q(ntry, wf4(:,10), ex6, wf8(:,59), n3(:,97), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf4(:,7), wf4(:,27), wf16(:,55), n3(:,98), t3x16(:,:,49))
  call prop_A_Q(ntry, wf8(:,59), 50, ZERO, 0_intkind1, wf8(:,60), n2(38))
  call vert_QA_V(ntry, wf4(:,27), wf4(:,10), wf16(:,56), n3(:,99), t3x16(:,:,50))
  call vert_VQ_A(ntry, wf4(:,7), ex1, wf8(:,61), n3(:,100), t3x8(:,:,35))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,15), wf16(:,57), n3(:,101), t3x16(:,:,51))
  call prop_Q_A(ntry, wf8(:,61), 13, ZERO, 0_intkind1, wf8(:,62), n2(39))
  call vert_VQ_A(ntry, wf4(:,15), ex1, wf8(:,63), n3(:,102), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,63), 97, ZERO, 0_intkind1, wf8(:,64), n2(40))
  call vert_UV_W(ntry, wf8(:,4), 19, ex6, 32, wf16(:,58), n3(:,103), t3x16(:,:,52))
  call vert_UV_W(ntry, wf8(:,4), 19, ex7, 64, wf16(:,59), n3(:,104), t3x16(:,:,53))
  call vert_VQ_A(ntry, ex6, wf8(:,62), wf16(:,60), n3(:,105), t3x16(:,:,54))
  call vert_VQ_A(ntry, ex7, wf8(:,62), wf16(:,61), n3(:,106), t3x16(:,:,55))
  call vert_QA_V(ntry, ex1, wf8(:,60), wf16(:,62), n3(:,107), t3x16(:,:,56))
  call vert_VQ_A(ntry, wf8(:,48), ex1, wf16(:,63), n3(:,108), t3x16(:,:,57))
  call vert_VQ_A(ntry, ex5, wf4(:,25), wf8(:,65), n3(:,109), t3x8(:,:,37))
  call prop_Q_A(ntry, wf8(:,65), 49, ZERO, 0_intkind1, wf8(:,66), n2(41))
  call vert_AV_Q(ntry, wf4(:,23), ex5, wf8(:,67), n3(:,110), t3x8(:,:,38))
  call prop_A_Q(ntry, wf8(:,67), 82, ZERO, 0_intkind1, wf8(:,68), n2(42))
  call vert_QA_V(ntry, wf8(:,66), ex2, wf16(:,64), n3(:,111), t3x16(:,:,58))
  call vert_AV_Q(ntry, wf8(:,50), ex5, wf16(:,65), n3(:,112), t3x16(:,:,59))
  call vert_VQ_A(ntry, ex5, wf4(:,27), wf8(:,69), n3(:,113), t3x8(:,:,39))
  call prop_Q_A(ntry, wf8(:,69), 81, ZERO, 0_intkind1, wf8(:,70), n2(43))
  call vert_AV_Q(ntry, wf4(:,21), ex5, wf8(:,71), n3(:,114), t3x8(:,:,40))
  call prop_A_Q(ntry, wf8(:,71), 50, ZERO, 0_intkind1, wf8(:,72), n2(44))
  call vert_VQ_A(ntry, ex5, wf8(:,62), wf16(:,66), n3(:,115), t3x16(:,:,60))
  call vert_QA_V(ntry, ex1, wf8(:,72), wf16(:,67), n3(:,116), t3x16(:,:,61))
  call vert_QA_V(ntry, wf8(:,70), ex2, wf16(:,68), n3(:,117), t3x16(:,:,62))
  call vert_QA_V(ntry, ex1, wf8(:,68), wf16(:,69), n3(:,118), t3x16(:,:,63))
  call vert_VQ_A(ntry, ex5, wf8(:,64), wf16(:,70), n3(:,119), t3x16(:,:,64))
  call vert_QA_V(ntry, wf4(:,19), ex4, wf8(:,73), n3(:,120), t3x8(:,:,41))
  call vert_QA_V(ntry, ex3, wf4(:,14), wf8(:,74), n3(:,121), t3x8(:,:,42))
  call vert_QA_V(ntry, wf4(:,17), ex4, wf8(:,75), n3(:,122), t3x8(:,:,43))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,14), wf16(:,71), n3(:,123), t3x16(:,:,65))
  call vert_AV_Q(ntry, ex4, wf8(:,3), wf16(:,72), n3(:,124), t3x16(:,:,66))
  call vert_AV_Q(ntry, ex2, wf8(:,75), wf16(:,73), n3(:,125), t3x16(:,:,67))
  call vert_QA_V(ntry, ex3, wf4(:,12), wf8(:,76), n3(:,126), t3x8(:,:,44))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,12), wf16(:,74), n3(:,127), t3x16(:,:,68))
  call vert_VQ_A(ntry, wf8(:,3), ex3, wf16(:,75), n3(:,128), t3x16(:,:,69))
  call vert_AV_Q(ntry, ex2, wf8(:,76), wf16(:,76), n3(:,129), t3x16(:,:,70))
  call vert_AV_Q(ntry, ex2, wf8(:,73), wf16(:,77), n3(:,130), t3x16(:,:,71))
  call vert_AV_Q(ntry, ex2, wf8(:,74), wf16(:,78), n3(:,131), t3x16(:,:,72))
  call vert_AV_Q(ntry, ex4, wf8(:,4), wf16(:,79), n3(:,132), t3x16(:,:,73))
  call vert_VQ_A(ntry, wf8(:,75), ex1, wf16(:,80), n3(:,133), t3x16(:,:,74))
  call vert_VQ_A(ntry, wf8(:,4), ex3, wf16(:,81), n3(:,134), t3x16(:,:,75))
  call vert_VQ_A(ntry, wf8(:,76), ex1, wf16(:,82), n3(:,135), t3x16(:,:,76))
  call vert_VQ_A(ntry, wf8(:,73), ex1, wf16(:,83), n3(:,136), t3x16(:,:,77))
  call vert_VQ_A(ntry, wf8(:,74), ex1, wf16(:,84), n3(:,137), t3x16(:,:,78))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,23), wf16(:,85), n3(:,138), t3x16(:,:,79))
  call vert_QA_V(ntry, wf4(:,25), ex2, wf8(:,77), n3(:,139), t3x8(:,:,45))
  call vert_AV_Q(ntry, ex4, wf8(:,77), wf16(:,86), n3(:,140), t3x16(:,:,80))
  call vert_UV_W(ntry, wf8(:,77), 35, ex7, 64, wf16(:,87), n3(:,141), t3x16(:,:,81))
  call vert_AV_Q(ntry, ex2, wf8(:,1), wf16(:,88), n3(:,142), t3x16(:,:,82))
  call vert_QA_V(ntry, wf4(:,27), wf4(:,21), wf16(:,89), n3(:,143), t3x16(:,:,83))
  call vert_QA_V(ntry, ex1, wf4(:,21), wf8(:,78), n3(:,144), t3x8(:,:,46))
  call vert_AV_Q(ntry, ex4, wf8(:,78), wf16(:,90), n3(:,145), t3x16(:,:,84))
  call vert_UV_W(ntry, wf8(:,78), 35, ex7, 64, wf16(:,91), n3(:,146), t3x16(:,:,85))
  call vert_VQ_A(ntry, wf8(:,1), ex1, wf16(:,92), n3(:,147), t3x16(:,:,86))
  call vert_QA_V(ntry, wf4(:,27), ex2, wf8(:,79), n3(:,148), t3x8(:,:,47))
  call vert_QA_V(ntry, ex1, wf4(:,23), wf8(:,80), n3(:,149), t3x8(:,:,48))
  call vert_AV_Q(ntry, ex4, wf8(:,79), wf16(:,93), n3(:,150), t3x16(:,:,87))
  call vert_UV_W(ntry, ex6, 32, wf8(:,79), 67, wf16(:,94), n3(:,151), t3x16(:,:,88))
  call vert_AV_Q(ntry, ex4, wf8(:,80), wf16(:,95), n3(:,152), t3x16(:,:,89))
  call vert_UV_W(ntry, ex6, 32, wf8(:,80), 67, wf16(:,96), n3(:,153), t3x16(:,:,90))
  call vert_QA_V(ntry, ex1, wf8(:,52), wf16(:,97), n3(:,154), t3x16(:,:,91))
  call vert_QA_V(ntry, wf8(:,64), ex2, wf16(:,98), n3(:,155), t3x16(:,:,92))
  call vert_VQ_A(ntry, wf8(:,77), ex3, wf16(:,99), n3(:,156), t3x16(:,:,93))
  call vert_AV_Q(ntry, ex2, wf8(:,2), wf16(:,100), n3(:,157), t3x16(:,:,94))
  call vert_VQ_A(ntry, wf8(:,78), ex3, wf16(:,101), n3(:,158), t3x16(:,:,95))
  call vert_VQ_A(ntry, wf8(:,2), ex1, wf16(:,102), n3(:,159), t3x16(:,:,96))
  call vert_VQ_A(ntry, wf8(:,79), ex3, wf16(:,103), n3(:,160), t3x16(:,:,97))
  call vert_VQ_A(ntry, wf8(:,80), ex3, wf16(:,104), n3(:,161), t3x16(:,:,98))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if
  end do

  if (ntry == 1 .and. any(POLSEL /= 0)) then
    ntry = 2
    goto 42
  end if

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  M2munu = 0
  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppajjj_ddxssxagg_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppajjj_ddxssxagg_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_ppajjj_ddxssxagg_1(k))
  end do

  ! photon-factors
  call photon_factors(photonid_ppajjj_ddxssxagg_1, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf8(:,1), wf16(:,1), A(:,1), n3(:,162), t3x128(:,:,1), nhel, den(5))
    call cont_VV(nsync, wf8(:,1), wf16(:,2), A(:,2), n3(:,163), t3x128(:,:,2), nhel, den(5))
    call cont_VV(nsync, wf8(:,1), wf16(:,3), A(:,3), n3(:,164), t3x128(:,:,3), nhel, den(5))
    call cont_VV(nsync, wf16(:,1), wf8(:,2), A(:,4), n3(:,165), t3x128(:,:,4), nhel, den(8))
    call cont_VV(nsync, wf16(:,2), wf8(:,2), A(:,5), n3(:,166), t3x128(:,:,5), nhel, den(8))
    call cont_VV(nsync, wf16(:,3), wf8(:,2), A(:,6), n3(:,167), t3x128(:,:,6), nhel, den(8))
    call cont_VV(nsync, wf8(:,3), wf16(:,4), A(:,7), n3(:,168), t3x128(:,:,7), nhel, den(13))
    call cont_VV(nsync, wf8(:,3), wf16(:,5), A(:,8), n3(:,169), t3x128(:,:,8), nhel, den(13))
    call cont_VV(nsync, wf8(:,3), wf16(:,6), A(:,9), n3(:,170), t3x128(:,:,9), nhel, den(13))
    call cont_VV(nsync, wf16(:,4), wf8(:,4), A(:,10), n3(:,171), t3x128(:,:,10), nhel, den(16))
    call cont_VV(nsync, wf16(:,5), wf8(:,4), A(:,11), n3(:,172), t3x128(:,:,11), nhel, den(16))
    call cont_VV(nsync, wf16(:,6), wf8(:,4), A(:,12), n3(:,173), t3x128(:,:,12), nhel, den(16))
    call cont_VV(nsync, wf8(:,5), wf16(:,7), A(:,13), n3(:,174), t3x128(:,:,13), nhel, den(21))
    call cont_QA(nsync, wf16(:,8), wf8(:,7), A(:,14), n3(:,175), t3x128(:,:,14), nhel, den(25))
    call cont_QA(nsync, wf16(:,9), wf8(:,9), A(:,15), n3(:,176), t3x128(:,:,15), nhel, den(29))
    call cont_VV(nsync, wf8(:,10), wf16(:,10), A(:,16), n3(:,177), t3x128(:,:,16), nhel, den(34))
    call cont_QA(nsync, wf16(:,11), wf8(:,12), A(:,17), n3(:,178), t3x128(:,:,17), nhel, den(38))
    call cont_QA(nsync, wf16(:,9), wf8(:,14), A(:,18), n3(:,179), t3x128(:,:,18), nhel, den(40))
    call cont_QA(nsync, wf16(:,12), wf8(:,16), A(:,19), n3(:,180), t3x128(:,:,19), nhel, den(45))
    call cont_VV(nsync, wf8(:,1), wf16(:,13), A(:,20), n3(:,181), t3x128(:,:,20), nhel, den(47))
    call cont_QA(nsync, wf16(:,9), wf8(:,18), A(:,21), n3(:,182), t3x128(:,:,21), nhel, den(49))
    call cont_QA(nsync, wf8(:,12), wf16(:,14), A(:,22), n3(:,183), t3x128(:,:,22), nhel, den(50))
    call cont_QA(nsync, wf8(:,7), wf16(:,15), A(:,23), n3(:,184), t3x128(:,:,23), nhel, den(51))
    call cont_VV(nsync, wf8(:,10), wf16(:,16), A(:,24), n3(:,185), t3x128(:,:,24), nhel, den(52))
    call cont_QA(nsync, wf8(:,7), wf16(:,17), A(:,25), n3(:,186), t3x128(:,:,25), nhel, den(53))
    call cont_VV(nsync, wf8(:,5), wf16(:,18), A(:,26), n3(:,187), t3x128(:,:,26), nhel, den(54))
    call cont_VV(nsync, wf8(:,5), wf16(:,19), A(:,27), n3(:,188), t3x128(:,:,27), nhel, den(55))
    call cont_VV(nsync, wf8(:,5), wf16(:,20), A(:,28), n3(:,189), t3x128(:,:,28), nhel, den(58))
    call cont_QA(nsync, wf16(:,21), wf8(:,20), A(:,29), n3(:,190), t3x128(:,:,29), nhel, den(62))
    call cont_QA(nsync, wf16(:,22), wf8(:,22), A(:,30), n3(:,191), t3x128(:,:,30), nhel, den(66))
    call cont_VV(nsync, wf8(:,10), wf16(:,23), A(:,31), n3(:,192), t3x128(:,:,31), nhel, den(69))
    call cont_QA(nsync, wf16(:,21), wf8(:,24), A(:,32), n3(:,193), t3x128(:,:,32), nhel, den(71))
    call cont_QA(nsync, wf16(:,24), wf8(:,26), A(:,33), n3(:,194), t3x128(:,:,33), nhel, den(75))
    call cont_QA(nsync, wf16(:,25), wf8(:,28), A(:,34), n3(:,195), t3x128(:,:,34), nhel, den(79))
    call cont_VV(nsync, wf8(:,2), wf16(:,13), A(:,35), n3(:,196), t3x128(:,:,35), nhel, den(80))
    call cont_QA(nsync, wf16(:,21), wf8(:,30), A(:,36), n3(:,197), t3x128(:,:,36), nhel, den(82))
    call cont_QA(nsync, wf8(:,22), wf16(:,26), A(:,37), n3(:,198), t3x128(:,:,37), nhel, den(83))
    call cont_QA(nsync, wf8(:,26), wf16(:,27), A(:,38), n3(:,199), t3x128(:,:,38), nhel, den(84))
    call cont_VV(nsync, wf8(:,10), wf16(:,28), A(:,39), n3(:,200), t3x128(:,:,39), nhel, den(85))
    call cont_QA(nsync, wf8(:,22), wf16(:,29), A(:,40), n3(:,201), t3x128(:,:,40), nhel, den(86))
    call cont_VV(nsync, wf8(:,5), wf16(:,30), A(:,41), n3(:,202), t3x128(:,:,41), nhel, den(87))
    call cont_VV(nsync, wf8(:,5), wf16(:,31), A(:,42), n3(:,203), t3x128(:,:,42), nhel, den(88))
    call cont_QA(nsync, wf16(:,11), wf8(:,32), A(:,43), n3(:,204), t3x128(:,:,43), nhel, den(90))
    call cont_QA(nsync, wf16(:,22), wf8(:,34), A(:,44), n3(:,205), t3x128(:,:,44), nhel, den(92))
    call cont_QA(nsync, wf16(:,14), wf8(:,32), A(:,45), n3(:,206), t3x128(:,:,45), nhel, den(93))
    call cont_QA(nsync, wf8(:,20), wf16(:,32), A(:,46), n3(:,207), t3x128(:,:,46), nhel, den(94))
    call cont_VV(nsync, wf8(:,5), wf16(:,33), A(:,47), n3(:,208), t3x128(:,:,47), nhel, den(95))
    call cont_QA(nsync, wf16(:,8), wf8(:,36), A(:,48), n3(:,209), t3x128(:,:,48), nhel, den(97))
    call cont_QA(nsync, wf16(:,24), wf8(:,38), A(:,49), n3(:,210), t3x128(:,:,49), nhel, den(99))
    call cont_QA(nsync, wf8(:,9), wf16(:,34), A(:,50), n3(:,211), t3x128(:,:,50), nhel, den(100))
    call cont_QA(nsync, wf16(:,27), wf8(:,38), A(:,51), n3(:,212), t3x128(:,:,51), nhel, den(101))
    call cont_VV(nsync, wf8(:,5), wf16(:,35), A(:,52), n3(:,213), t3x128(:,:,52), nhel, den(102))
    call cont_QA(nsync, wf16(:,15), wf8(:,36), A(:,53), n3(:,214), t3x128(:,:,53), nhel, den(103))
    call cont_QA(nsync, wf8(:,24), wf16(:,32), A(:,54), n3(:,215), t3x128(:,:,54), nhel, den(104))
    call cont_VV(nsync, wf8(:,10), wf16(:,36), A(:,55), n3(:,216), t3x128(:,:,55), nhel, den(105))
    call cont_QA(nsync, wf8(:,14), wf16(:,34), A(:,56), n3(:,217), t3x128(:,:,56), nhel, den(106))
    call cont_QA(nsync, wf16(:,26), wf8(:,34), A(:,57), n3(:,218), t3x128(:,:,57), nhel, den(107))
    call cont_VV(nsync, wf8(:,10), wf16(:,37), A(:,58), n3(:,219), t3x128(:,:,58), nhel, den(108))
    call cont_QA(nsync, wf8(:,18), wf16(:,34), A(:,59), n3(:,220), t3x128(:,:,59), nhel, den(109))
    call cont_QA(nsync, wf8(:,16), wf16(:,38), A(:,60), n3(:,221), t3x128(:,:,60), nhel, den(110))
    call cont_QA(nsync, wf16(:,39), wf8(:,40), A(:,61), n3(:,222), t3x128(:,:,61), nhel, den(115))
    call cont_QA(nsync, wf16(:,40), wf8(:,42), A(:,62), n3(:,223), t3x128(:,:,62), nhel, den(119))
    call cont_VV(nsync, wf8(:,43), wf16(:,41), A(:,63), n3(:,224), t3x128(:,:,63), nhel, den(123))
    call cont_QA(nsync, wf16(:,42), wf8(:,45), A(:,64), n3(:,225), t3x128(:,:,64), nhel, den(128))
    call cont_QA(nsync, wf16(:,40), wf8(:,47), A(:,65), n3(:,226), t3x128(:,:,65), nhel, den(130))
    call cont_VV(nsync, wf8(:,48), wf16(:,43), A(:,66), n3(:,227), t3x128(:,:,66), nhel, den(134))
    call cont_VV(nsync, wf8(:,3), wf16(:,44), A(:,67), n3(:,228), t3x128(:,:,67), nhel, den(136))
    call cont_QA(nsync, wf16(:,45), wf8(:,50), A(:,68), n3(:,229), t3x128(:,:,68), nhel, den(140))
    call cont_QA(nsync, wf16(:,40), wf8(:,52), A(:,69), n3(:,230), t3x128(:,:,69), nhel, den(142))
    call cont_VV(nsync, wf8(:,43), wf16(:,46), A(:,70), n3(:,231), t3x128(:,:,70), nhel, den(143))
    call cont_VV(nsync, wf8(:,48), wf16(:,47), A(:,71), n3(:,232), t3x128(:,:,71), nhel, den(144))
    call cont_QA(nsync, wf8(:,45), wf16(:,48), A(:,72), n3(:,233), t3x128(:,:,72), nhel, den(145))
    call cont_VV(nsync, wf8(:,43), wf16(:,49), A(:,73), n3(:,234), t3x128(:,:,73), nhel, den(146))
    call cont_QA(nsync, wf8(:,40), wf16(:,50), A(:,74), n3(:,235), t3x128(:,:,74), nhel, den(147))
    call cont_QA(nsync, wf8(:,40), wf16(:,51), A(:,75), n3(:,236), t3x128(:,:,75), nhel, den(148))
    call cont_QA(nsync, wf16(:,52), wf8(:,54), A(:,76), n3(:,237), t3x128(:,:,76), nhel, den(153))
    call cont_QA(nsync, wf16(:,53), wf8(:,56), A(:,77), n3(:,238), t3x128(:,:,77), nhel, den(157))
    call cont_VV(nsync, wf8(:,43), wf16(:,54), A(:,78), n3(:,239), t3x128(:,:,78), nhel, den(159))
    call cont_QA(nsync, wf16(:,52), wf8(:,58), A(:,79), n3(:,240), t3x128(:,:,79), nhel, den(162))
    call cont_QA(nsync, wf16(:,55), wf8(:,60), A(:,80), n3(:,241), t3x128(:,:,80), nhel, den(166))
    call cont_VV(nsync, wf8(:,48), wf16(:,56), A(:,81), n3(:,242), t3x128(:,:,81), nhel, den(168))
    call cont_VV(nsync, wf8(:,4), wf16(:,44), A(:,82), n3(:,243), t3x128(:,:,82), nhel, den(169))
    call cont_QA(nsync, wf16(:,57), wf8(:,62), A(:,83), n3(:,244), t3x128(:,:,83), nhel, den(173))
    call cont_QA(nsync, wf16(:,52), wf8(:,64), A(:,84), n3(:,245), t3x128(:,:,84), nhel, den(175))
    call cont_VV(nsync, wf8(:,43), wf16(:,58), A(:,85), n3(:,246), t3x128(:,:,85), nhel, den(176))
    call cont_VV(nsync, wf8(:,48), wf16(:,59), A(:,86), n3(:,247), t3x128(:,:,86), nhel, den(177))
    call cont_QA(nsync, wf8(:,56), wf16(:,60), A(:,87), n3(:,248), t3x128(:,:,87), nhel, den(178))
    call cont_QA(nsync, wf8(:,60), wf16(:,61), A(:,88), n3(:,249), t3x128(:,:,88), nhel, den(179))
    call cont_VV(nsync, wf8(:,43), wf16(:,62), A(:,89), n3(:,250), t3x128(:,:,89), nhel, den(180))
    call cont_QA(nsync, wf8(:,56), wf16(:,63), A(:,90), n3(:,251), t3x128(:,:,90), nhel, den(181))
    call cont_QA(nsync, wf16(:,42), wf8(:,66), A(:,91), n3(:,252), t3x128(:,:,91), nhel, den(183))
    call cont_QA(nsync, wf16(:,53), wf8(:,68), A(:,92), n3(:,253), t3x128(:,:,92), nhel, den(185))
    call cont_QA(nsync, wf16(:,48), wf8(:,66), A(:,93), n3(:,254), t3x128(:,:,93), nhel, den(186))
    call cont_VV(nsync, wf8(:,43), wf16(:,64), A(:,94), n3(:,255), t3x128(:,:,94), nhel, den(187))
    call cont_QA(nsync, wf8(:,54), wf16(:,65), A(:,95), n3(:,256), t3x128(:,:,95), nhel, den(188))
    call cont_QA(nsync, wf16(:,39), wf8(:,70), A(:,96), n3(:,257), t3x128(:,:,96), nhel, den(190))
    call cont_QA(nsync, wf16(:,55), wf8(:,72), A(:,97), n3(:,258), t3x128(:,:,97), nhel, den(192))
    call cont_QA(nsync, wf8(:,42), wf16(:,66), A(:,98), n3(:,259), t3x128(:,:,98), nhel, den(193))
    call cont_QA(nsync, wf16(:,61), wf8(:,72), A(:,99), n3(:,260), t3x128(:,:,99), nhel, den(194))
    call cont_VV(nsync, wf8(:,43), wf16(:,67), A(:,100), n3(:,261), t3x128(:,:,100), nhel, den(195))
    call cont_QA(nsync, wf16(:,50), wf8(:,70), A(:,101), n3(:,262), t3x128(:,:,101), nhel, den(196))
    call cont_VV(nsync, wf8(:,48), wf16(:,68), A(:,102), n3(:,263), t3x128(:,:,102), nhel, den(197))
    call cont_QA(nsync, wf8(:,58), wf16(:,65), A(:,103), n3(:,264), t3x128(:,:,103), nhel, den(198))
    call cont_QA(nsync, wf8(:,47), wf16(:,66), A(:,104), n3(:,265), t3x128(:,:,104), nhel, den(199))
    call cont_QA(nsync, wf16(:,60), wf8(:,68), A(:,105), n3(:,266), t3x128(:,:,105), nhel, den(200))
    call cont_VV(nsync, wf8(:,48), wf16(:,69), A(:,106), n3(:,267), t3x128(:,:,106), nhel, den(201))
    call cont_QA(nsync, wf8(:,52), wf16(:,66), A(:,107), n3(:,268), t3x128(:,:,107), nhel, den(202))
    call cont_QA(nsync, wf8(:,50), wf16(:,70), A(:,108), n3(:,269), t3x128(:,:,108), nhel, den(203))
    call cont_VV(nsync, wf16(:,41), wf8(:,73), A(:,109), n3(:,270), t3x128(:,:,109), nhel, den(205))
    call cont_VV(nsync, wf16(:,41), wf8(:,74), A(:,110), n3(:,271), t3x128(:,:,110), nhel, den(207))
    call cont_VV(nsync, wf16(:,43), wf8(:,75), A(:,111), n3(:,272), t3x128(:,:,111), nhel, den(209))
    call cont_VV(nsync, wf8(:,3), wf16(:,71), A(:,112), n3(:,273), t3x128(:,:,112), nhel, den(211))
    call cont_QA(nsync, wf8(:,20), wf16(:,72), A(:,113), n3(:,274), t3x128(:,:,113), nhel, den(212))
    call cont_VV(nsync, wf16(:,47), wf8(:,75), A(:,114), n3(:,275), t3x128(:,:,114), nhel, den(213))
    call cont_QA(nsync, wf8(:,40), wf16(:,73), A(:,115), n3(:,276), t3x128(:,:,115), nhel, den(214))
    call cont_VV(nsync, wf16(:,43), wf8(:,76), A(:,116), n3(:,277), t3x128(:,:,116), nhel, den(216))
    call cont_VV(nsync, wf8(:,3), wf16(:,74), A(:,117), n3(:,278), t3x128(:,:,117), nhel, den(218))
    call cont_QA(nsync, wf8(:,9), wf16(:,75), A(:,118), n3(:,279), t3x128(:,:,118), nhel, den(219))
    call cont_VV(nsync, wf16(:,47), wf8(:,76), A(:,119), n3(:,280), t3x128(:,:,119), nhel, den(220))
    call cont_QA(nsync, wf8(:,40), wf16(:,76), A(:,120), n3(:,281), t3x128(:,:,120), nhel, den(221))
    call cont_QA(nsync, wf8(:,24), wf16(:,72), A(:,121), n3(:,282), t3x128(:,:,121), nhel, den(222))
    call cont_VV(nsync, wf16(:,46), wf8(:,73), A(:,122), n3(:,283), t3x128(:,:,122), nhel, den(223))
    call cont_QA(nsync, wf8(:,45), wf16(:,77), A(:,123), n3(:,284), t3x128(:,:,123), nhel, den(224))
    call cont_QA(nsync, wf8(:,14), wf16(:,75), A(:,124), n3(:,285), t3x128(:,:,124), nhel, den(225))
    call cont_VV(nsync, wf16(:,46), wf8(:,74), A(:,125), n3(:,286), t3x128(:,:,125), nhel, den(226))
    call cont_QA(nsync, wf8(:,45), wf16(:,78), A(:,126), n3(:,287), t3x128(:,:,126), nhel, den(227))
    call cont_QA(nsync, wf8(:,18), wf16(:,75), A(:,127), n3(:,288), t3x128(:,:,127), nhel, den(228))
    call cont_QA(nsync, wf8(:,30), wf16(:,72), A(:,128), n3(:,289), t3x128(:,:,128), nhel, den(229))
    call cont_VV(nsync, wf16(:,54), wf8(:,73), A(:,129), n3(:,290), t3x128(:,:,129), nhel, den(230))
    call cont_VV(nsync, wf16(:,54), wf8(:,74), A(:,130), n3(:,291), t3x128(:,:,130), nhel, den(231))
    call cont_VV(nsync, wf16(:,56), wf8(:,75), A(:,131), n3(:,292), t3x128(:,:,131), nhel, den(232))
    call cont_VV(nsync, wf8(:,4), wf16(:,71), A(:,132), n3(:,293), t3x128(:,:,132), nhel, den(233))
    call cont_QA(nsync, wf8(:,20), wf16(:,79), A(:,133), n3(:,294), t3x128(:,:,133), nhel, den(234))
    call cont_VV(nsync, wf16(:,59), wf8(:,75), A(:,134), n3(:,295), t3x128(:,:,134), nhel, den(235))
    call cont_QA(nsync, wf8(:,56), wf16(:,80), A(:,135), n3(:,296), t3x128(:,:,135), nhel, den(236))
    call cont_VV(nsync, wf16(:,56), wf8(:,76), A(:,136), n3(:,297), t3x128(:,:,136), nhel, den(237))
    call cont_VV(nsync, wf8(:,4), wf16(:,74), A(:,137), n3(:,298), t3x128(:,:,137), nhel, den(238))
    call cont_QA(nsync, wf8(:,9), wf16(:,81), A(:,138), n3(:,299), t3x128(:,:,138), nhel, den(239))
    call cont_VV(nsync, wf16(:,59), wf8(:,76), A(:,139), n3(:,300), t3x128(:,:,139), nhel, den(240))
    call cont_QA(nsync, wf8(:,56), wf16(:,82), A(:,140), n3(:,301), t3x128(:,:,140), nhel, den(241))
    call cont_QA(nsync, wf8(:,24), wf16(:,79), A(:,141), n3(:,302), t3x128(:,:,141), nhel, den(242))
    call cont_VV(nsync, wf16(:,58), wf8(:,73), A(:,142), n3(:,303), t3x128(:,:,142), nhel, den(243))
    call cont_QA(nsync, wf8(:,60), wf16(:,83), A(:,143), n3(:,304), t3x128(:,:,143), nhel, den(244))
    call cont_QA(nsync, wf8(:,14), wf16(:,81), A(:,144), n3(:,305), t3x128(:,:,144), nhel, den(245))
    call cont_VV(nsync, wf16(:,58), wf8(:,74), A(:,145), n3(:,306), t3x128(:,:,145), nhel, den(246))
    call cont_QA(nsync, wf8(:,60), wf16(:,84), A(:,146), n3(:,307), t3x128(:,:,146), nhel, den(247))
    call cont_QA(nsync, wf8(:,18), wf16(:,81), A(:,147), n3(:,308), t3x128(:,:,147), nhel, den(248))
    call cont_QA(nsync, wf8(:,30), wf16(:,79), A(:,148), n3(:,309), t3x128(:,:,148), nhel, den(249))
    call cont_VV(nsync, wf8(:,1), wf16(:,85), A(:,149), n3(:,310), t3x128(:,:,149), nhel, den(251))
    call cont_VV(nsync, wf16(:,10), wf8(:,77), A(:,150), n3(:,311), t3x128(:,:,150), nhel, den(253))
    call cont_QA(nsync, wf8(:,7), wf16(:,86), A(:,151), n3(:,312), t3x128(:,:,151), nhel, den(254))
    call cont_VV(nsync, wf8(:,1), wf16(:,87), A(:,152), n3(:,313), t3x128(:,:,152), nhel, den(255))
    call cont_QA(nsync, wf8(:,54), wf16(:,88), A(:,153), n3(:,314), t3x128(:,:,153), nhel, den(256))
    call cont_VV(nsync, wf8(:,1), wf16(:,89), A(:,154), n3(:,315), t3x128(:,:,154), nhel, den(258))
    call cont_VV(nsync, wf16(:,10), wf8(:,78), A(:,155), n3(:,316), t3x128(:,:,155), nhel, den(260))
    call cont_QA(nsync, wf8(:,7), wf16(:,90), A(:,156), n3(:,317), t3x128(:,:,156), nhel, den(261))
    call cont_VV(nsync, wf8(:,1), wf16(:,91), A(:,157), n3(:,318), t3x128(:,:,157), nhel, den(262))
    call cont_QA(nsync, wf8(:,42), wf16(:,92), A(:,158), n3(:,319), t3x128(:,:,158), nhel, den(263))
    call cont_VV(nsync, wf16(:,7), wf8(:,79), A(:,159), n3(:,320), t3x128(:,:,159), nhel, den(265))
    call cont_VV(nsync, wf16(:,7), wf8(:,80), A(:,160), n3(:,321), t3x128(:,:,160), nhel, den(267))
    call cont_QA(nsync, wf8(:,12), wf16(:,93), A(:,161), n3(:,322), t3x128(:,:,161), nhel, den(268))
    call cont_VV(nsync, wf8(:,1), wf16(:,94), A(:,162), n3(:,323), t3x128(:,:,162), nhel, den(269))
    call cont_QA(nsync, wf8(:,58), wf16(:,88), A(:,163), n3(:,324), t3x128(:,:,163), nhel, den(270))
    call cont_QA(nsync, wf8(:,12), wf16(:,95), A(:,164), n3(:,325), t3x128(:,:,164), nhel, den(271))
    call cont_VV(nsync, wf8(:,1), wf16(:,96), A(:,165), n3(:,326), t3x128(:,:,165), nhel, den(272))
    call cont_QA(nsync, wf8(:,47), wf16(:,92), A(:,166), n3(:,327), t3x128(:,:,166), nhel, den(273))
    call cont_VV(nsync, wf8(:,1), wf16(:,97), A(:,167), n3(:,328), t3x128(:,:,167), nhel, den(274))
    call cont_VV(nsync, wf8(:,1), wf16(:,98), A(:,168), n3(:,329), t3x128(:,:,168), nhel, den(275))
    call cont_VV(nsync, wf8(:,2), wf16(:,85), A(:,169), n3(:,330), t3x128(:,:,169), nhel, den(276))
    call cont_VV(nsync, wf16(:,23), wf8(:,77), A(:,170), n3(:,331), t3x128(:,:,170), nhel, den(277))
    call cont_QA(nsync, wf8(:,22), wf16(:,99), A(:,171), n3(:,332), t3x128(:,:,171), nhel, den(278))
    call cont_VV(nsync, wf8(:,2), wf16(:,87), A(:,172), n3(:,333), t3x128(:,:,172), nhel, den(279))
    call cont_QA(nsync, wf8(:,54), wf16(:,100), A(:,173), n3(:,334), t3x128(:,:,173), nhel, den(280))
    call cont_VV(nsync, wf8(:,2), wf16(:,89), A(:,174), n3(:,335), t3x128(:,:,174), nhel, den(281))
    call cont_VV(nsync, wf16(:,23), wf8(:,78), A(:,175), n3(:,336), t3x128(:,:,175), nhel, den(282))
    call cont_QA(nsync, wf8(:,22), wf16(:,101), A(:,176), n3(:,337), t3x128(:,:,176), nhel, den(283))
    call cont_VV(nsync, wf8(:,2), wf16(:,91), A(:,177), n3(:,338), t3x128(:,:,177), nhel, den(284))
    call cont_QA(nsync, wf8(:,42), wf16(:,102), A(:,178), n3(:,339), t3x128(:,:,178), nhel, den(285))
    call cont_VV(nsync, wf16(:,20), wf8(:,79), A(:,179), n3(:,340), t3x128(:,:,179), nhel, den(286))
    call cont_VV(nsync, wf16(:,20), wf8(:,80), A(:,180), n3(:,341), t3x128(:,:,180), nhel, den(287))
    call cont_QA(nsync, wf8(:,26), wf16(:,103), A(:,181), n3(:,342), t3x128(:,:,181), nhel, den(288))
    call cont_VV(nsync, wf8(:,2), wf16(:,94), A(:,182), n3(:,343), t3x128(:,:,182), nhel, den(289))
    call cont_QA(nsync, wf8(:,58), wf16(:,100), A(:,183), n3(:,344), t3x128(:,:,183), nhel, den(290))
    call cont_QA(nsync, wf8(:,26), wf16(:,104), A(:,184), n3(:,345), t3x128(:,:,184), nhel, den(291))
    call cont_VV(nsync, wf8(:,2), wf16(:,96), A(:,185), n3(:,346), t3x128(:,:,185), nhel, den(292))
    call cont_QA(nsync, wf8(:,47), wf16(:,102), A(:,186), n3(:,347), t3x128(:,:,186), nhel, den(293))
    call cont_VV(nsync, wf8(:,2), wf16(:,97), A(:,187), n3(:,348), t3x128(:,:,187), nhel, den(294))
    call cont_VV(nsync, wf8(:,2), wf16(:,98), A(:,188), n3(:,349), t3x128(:,:,188), nhel, den(295))
    call cont_QA(nsync, wf8(:,36), wf16(:,86), A(:,189), n3(:,350), t3x128(:,:,189), nhel, den(296))
    call cont_QA(nsync, wf8(:,66), wf16(:,77), A(:,190), n3(:,351), t3x128(:,:,190), nhel, den(297))
    call cont_QA(nsync, wf8(:,34), wf16(:,99), A(:,191), n3(:,352), t3x128(:,:,191), nhel, den(298))
    call cont_QA(nsync, wf8(:,66), wf16(:,78), A(:,192), n3(:,353), t3x128(:,:,192), nhel, den(299))
    call cont_QA(nsync, wf8(:,36), wf16(:,90), A(:,193), n3(:,354), t3x128(:,:,193), nhel, den(300))
    call cont_QA(nsync, wf8(:,72), wf16(:,83), A(:,194), n3(:,355), t3x128(:,:,194), nhel, den(301))
    call cont_QA(nsync, wf8(:,34), wf16(:,101), A(:,195), n3(:,356), t3x128(:,:,195), nhel, den(302))
    call cont_QA(nsync, wf8(:,72), wf16(:,84), A(:,196), n3(:,357), t3x128(:,:,196), nhel, den(303))
    call cont_QA(nsync, wf8(:,32), wf16(:,93), A(:,197), n3(:,358), t3x128(:,:,197), nhel, den(304))
    call cont_QA(nsync, wf8(:,70), wf16(:,73), A(:,198), n3(:,359), t3x128(:,:,198), nhel, den(305))
    call cont_QA(nsync, wf8(:,32), wf16(:,95), A(:,199), n3(:,360), t3x128(:,:,199), nhel, den(306))
    call cont_QA(nsync, wf8(:,68), wf16(:,80), A(:,200), n3(:,361), t3x128(:,:,200), nhel, den(307))
    call cont_QA(nsync, wf8(:,38), wf16(:,103), A(:,201), n3(:,362), t3x128(:,:,201), nhel, den(308))
    call cont_QA(nsync, wf8(:,70), wf16(:,76), A(:,202), n3(:,363), t3x128(:,:,202), nhel, den(309))
    call cont_QA(nsync, wf8(:,38), wf16(:,104), A(:,203), n3(:,364), t3x128(:,:,203), nhel, den(310))
    call cont_QA(nsync, wf8(:,68), wf16(:,82), A(:,204), n3(:,365), t3x128(:,:,204), nhel, den(311))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(12) ! M1helarray(12,128)
  integer :: empty(0)

  M1( 1) = ((A(j,111)%j+A(j,115)%j+A(j,116)%j+A(j,120)%j+A(j,131)%j+A(j,135)%j+A(j,136)%j+A(j,140)%j+A(j,159)%j+A(j,160)%j &
        +A(j,161)%j+A(j,164)%j+A(j,179)%j+A(j,180)%j+A(j,181)%j+A(j,184)%j+A(j,197)%j+A(j,198)%j+A(j,199)%j+A(j,200)%j+A(j,201)%j &
        +A(j,202)%j+A(j,203)%j+A(j,204)%j)*f(1))/6._/**/REALKIND
  M1( 2) = ((A(j,1)%j-A(j,3)%j+A(j,4)%j-A(j,6)%j+A(j,7)%j-A(j,9)%j+A(j,10)%j-A(j,12)%j-A(j,14)%j-A(j,24)%j-A(j,26)%j-A(j,33)%j &
        -A(j,39)%j-A(j,41)%j-A(j,48)%j-A(j,49)%j-A(j,64)%j-A(j,70)%j-A(j,71)%j-A(j,77)%j-A(j,85)%j-A(j,86)%j-A(j,91)%j-A(j,92)%j &
        -A(j,116)%j-A(j,117)%j-A(j,123)%j-A(j,129)%j-A(j,137)%j-A(j,140)%j-A(j,149)%j-A(j,151)%j-A(j,160)%j-A(j,169)%j-A(j,170)%j &
        -A(j,184)%j-A(j,189)%j-A(j,190)%j-A(j,203)%j-A(j,204)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,13)%j+A(j,25)%j+A(j,31)%j &
        -A(j,42)%j-A(j,52)%j+A(j,55)%j-A(j,66)%j+A(j,73)%j+A(j,78)%j-A(j,90)%j+A(j,94)%j-A(j,106)%j-A(j,119)%j+A(j,122)%j &
        -A(j,139)%j+A(j,142)%j-A(j,152)%j-A(j,165)%j-A(j,172)%j-A(j,185)%j)*f(2))/2._/**/REALKIND
  M1( 3) = ((A(j,1)%j-A(j,3)%j+A(j,4)%j-A(j,6)%j+A(j,7)%j-A(j,9)%j+A(j,10)%j-A(j,12)%j-A(j,17)%j-A(j,24)%j-A(j,26)%j-A(j,30)%j &
        -A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,44)%j-A(j,61)%j-A(j,70)%j-A(j,71)%j-A(j,80)%j-A(j,85)%j-A(j,86)%j-A(j,96)%j-A(j,97)%j &
        -A(j,110)%j-A(j,112)%j-A(j,115)%j-A(j,131)%j-A(j,132)%j-A(j,146)%j-A(j,154)%j-A(j,155)%j-A(j,161)%j-A(j,174)%j-A(j,176)%j &
        -A(j,179)%j-A(j,195)%j-A(j,196)%j-A(j,197)%j-A(j,198)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,16)%j+A(j,27)%j+A(j,28)%j &
        -A(j,40)%j+A(j,47)%j-A(j,58)%j-A(j,63)%j+A(j,75)%j+A(j,81)%j-A(j,89)%j-A(j,100)%j+A(j,102)%j+A(j,114)%j-A(j,125)%j &
        +A(j,134)%j-A(j,145)%j+A(j,157)%j+A(j,162)%j+A(j,177)%j+A(j,182)%j)*f(2))/2._/**/REALKIND
  M1( 4) = ((A(j,109)%j+A(j,110)%j+A(j,123)%j+A(j,126)%j+A(j,129)%j+A(j,130)%j+A(j,143)%j+A(j,146)%j+A(j,150)%j+A(j,151)%j &
        +A(j,155)%j+A(j,156)%j+A(j,170)%j+A(j,171)%j+A(j,175)%j+A(j,176)%j+A(j,189)%j+A(j,190)%j+A(j,191)%j+A(j,192)%j+A(j,193)%j &
        +A(j,194)%j+A(j,195)%j+A(j,196)%j)*f(1))/6._/**/REALKIND
  M1( 5) = ((A(j,61)%j+A(j,62)%j+A(j,74)%j+A(j,79)%j+A(j,80)%j+A(j,88)%j+A(j,96)%j+A(j,97)%j+A(j,98)%j+A(j,99)%j+A(j,101)%j &
        +A(j,103)%j+A(j,154)%j+A(j,158)%j+A(j,163)%j+A(j,174)%j+A(j,178)%j+A(j,183)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,68)%j &
        +A(j,69)%j+A(j,83)%j+A(j,84)%j+A(j,107)%j+A(j,108)%j+A(j,167)%j+A(j,168)%j+A(j,187)%j+A(j,188)%j)*f(2))/6._/**/REALKIND
  M1( 6) = ((-A(j,1)%j+A(j,2)%j-A(j,4)%j+A(j,5)%j-A(j,8)%j+A(j,9)%j-A(j,11)%j+A(j,12)%j-A(j,20)%j-A(j,23)%j+A(j,24)%j-A(j,32)%j &
        -A(j,35)%j+A(j,39)%j-A(j,53)%j-A(j,54)%j-A(j,62)%j+A(j,67)%j+A(j,70)%j+A(j,82)%j+A(j,85)%j-A(j,88)%j-A(j,98)%j-A(j,99)%j &
        -A(j,109)%j-A(j,121)%j-A(j,141)%j-A(j,143)%j-A(j,156)%j-A(j,158)%j-A(j,175)%j-A(j,178)%j-A(j,193)%j &
        -A(j,194)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,19)%j-A(j,25)%j-A(j,31)%j-A(j,36)%j-A(j,55)%j-A(j,60)%j+A(j,63)%j-A(j,69)%j &
        -A(j,83)%j+A(j,89)%j+A(j,100)%j-A(j,107)%j-A(j,122)%j-A(j,128)%j-A(j,142)%j-A(j,148)%j-A(j,157)%j-A(j,167)%j-A(j,177)%j &
        -A(j,187)%j)*f(2))/2._/**/REALKIND
  M1( 7) = ((-A(j,2)%j+A(j,3)%j-A(j,5)%j+A(j,6)%j-A(j,7)%j+A(j,8)%j-A(j,10)%j+A(j,11)%j-A(j,15)%j+A(j,20)%j+A(j,26)%j+A(j,35)%j &
        -A(j,38)%j+A(j,41)%j-A(j,50)%j-A(j,51)%j-A(j,67)%j+A(j,71)%j-A(j,74)%j-A(j,79)%j-A(j,82)%j+A(j,86)%j-A(j,101)%j-A(j,103)%j &
        -A(j,118)%j-A(j,120)%j-A(j,136)%j-A(j,138)%j-A(j,159)%j-A(j,163)%j-A(j,181)%j-A(j,183)%j-A(j,201)%j &
        -A(j,202)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,13)%j-A(j,21)%j-A(j,34)%j+A(j,42)%j+A(j,52)%j-A(j,59)%j-A(j,68)%j-A(j,75)%j &
        -A(j,81)%j-A(j,84)%j-A(j,102)%j-A(j,108)%j+A(j,119)%j-A(j,127)%j+A(j,139)%j-A(j,147)%j-A(j,162)%j-A(j,168)%j-A(j,182)%j &
        -A(j,188)%j)*f(2))/2._/**/REALKIND
  M1( 8) = ((A(j,14)%j+A(j,15)%j+A(j,23)%j+A(j,32)%j+A(j,33)%j+A(j,38)%j+A(j,48)%j+A(j,49)%j+A(j,50)%j+A(j,51)%j+A(j,53)%j &
        +A(j,54)%j+A(j,117)%j+A(j,118)%j+A(j,121)%j+A(j,137)%j+A(j,138)%j+A(j,141)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,19)%j &
        +A(j,21)%j+A(j,34)%j+A(j,36)%j+A(j,59)%j+A(j,60)%j+A(j,127)%j+A(j,128)%j+A(j,147)%j+A(j,148)%j)*f(2))/6._/**/REALKIND
  M1( 9) = ((A(j,64)%j+A(j,65)%j+A(j,72)%j+A(j,76)%j+A(j,77)%j+A(j,87)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j+A(j,95)%j+A(j,104)%j &
        +A(j,105)%j+A(j,149)%j+A(j,153)%j+A(j,166)%j+A(j,169)%j+A(j,173)%j+A(j,186)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,68)%j &
        -A(j,69)%j-A(j,83)%j-A(j,84)%j-A(j,107)%j-A(j,108)%j-A(j,167)%j-A(j,168)%j-A(j,187)%j-A(j,188)%j)*f(2))/6._/**/REALKIND
  M1(10) = ((-A(j,2)%j+A(j,3)%j-A(j,5)%j+A(j,6)%j-A(j,7)%j+A(j,8)%j-A(j,10)%j+A(j,11)%j+A(j,20)%j-A(j,22)%j+A(j,26)%j-A(j,29)%j &
        +A(j,35)%j+A(j,41)%j-A(j,45)%j-A(j,46)%j-A(j,65)%j-A(j,67)%j+A(j,71)%j-A(j,82)%j+A(j,86)%j-A(j,87)%j-A(j,104)%j-A(j,105)%j &
        -A(j,111)%j-A(j,113)%j-A(j,133)%j-A(j,135)%j-A(j,164)%j-A(j,166)%j-A(j,180)%j-A(j,186)%j-A(j,199)%j &
        -A(j,200)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,19)%j-A(j,27)%j-A(j,28)%j+A(j,36)%j-A(j,47)%j+A(j,60)%j+A(j,66)%j+A(j,69)%j &
        +A(j,83)%j+A(j,90)%j+A(j,106)%j+A(j,107)%j-A(j,114)%j+A(j,128)%j-A(j,134)%j+A(j,148)%j+A(j,165)%j+A(j,167)%j+A(j,185)%j &
        +A(j,187)%j)*f(2))/2._/**/REALKIND
  M1(11) = ((-A(j,1)%j+A(j,2)%j-A(j,4)%j+A(j,5)%j-A(j,8)%j+A(j,9)%j-A(j,11)%j+A(j,12)%j-A(j,18)%j-A(j,20)%j+A(j,24)%j-A(j,35)%j &
        -A(j,37)%j+A(j,39)%j-A(j,56)%j-A(j,57)%j+A(j,67)%j+A(j,70)%j-A(j,72)%j-A(j,76)%j+A(j,82)%j+A(j,85)%j-A(j,93)%j-A(j,95)%j &
        -A(j,124)%j-A(j,126)%j-A(j,130)%j-A(j,144)%j-A(j,150)%j-A(j,153)%j-A(j,171)%j-A(j,173)%j-A(j,191)%j &
        -A(j,192)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,16)%j+A(j,21)%j+A(j,34)%j+A(j,40)%j+A(j,58)%j+A(j,59)%j+A(j,68)%j-A(j,73)%j &
        -A(j,78)%j+A(j,84)%j-A(j,94)%j+A(j,108)%j+A(j,125)%j+A(j,127)%j+A(j,145)%j+A(j,147)%j+A(j,152)%j+A(j,168)%j+A(j,172)%j &
        +A(j,188)%j)*f(2))/2._/**/REALKIND
  M1(12) = ((A(j,17)%j+A(j,18)%j+A(j,22)%j+A(j,29)%j+A(j,30)%j+A(j,37)%j+A(j,43)%j+A(j,44)%j+A(j,45)%j+A(j,46)%j+A(j,56)%j &
        +A(j,57)%j+A(j,112)%j+A(j,113)%j+A(j,124)%j+A(j,132)%j+A(j,133)%j+A(j,144)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,19)%j &
        -A(j,21)%j-A(j,34)%j-A(j,36)%j-A(j,59)%j-A(j,60)%j-A(j,127)%j-A(j,128)%j-A(j,147)%j-A(j,148)%j)*f(2))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(12)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 12*extcomb
    do i = 1, 12
      do j = 1, 12
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(12), M2(12)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 12*extcomb
    do i = 1, 12
      do j = 1, 12
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajjj_ddxssxagg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(12)
  complex(REALKIND), intent(in)  :: M2(12)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 12
    do j = 1, 12
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppajjj_ddxssxagg_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(12,128)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppajjj_ddxssxagg_1")
#else
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_qp_ppajjj_ddxssxagg_1")
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(DREALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppajjj_ddxssxagg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppajjj_ddxssxagg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppajjj_ddxssxagg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppajjj_ddxssxagg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7,extcombs, M2munu)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppajjj_ddxssxagg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppajjj_ddxssxagg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppajjj_ddxssxagg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppajjj_ddxssxagg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppajjj_ddxssxagg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppajjj_ddxssxagg_1_/**/REALKIND
