
module ol_vamp_1_ppajjj_uuxbbxag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajjj_uuxbbxag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajjj_uuxbbxag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajjj_uuxbbxag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppajjj_uuxbbxag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajjj_uuxbbxag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajjj_uuxbbxag_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(4,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,0,0,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMB,0,0,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,2,1,4,16,8],[0,0,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,1,2,4,16],[nMB,0,0,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(4),n2h32(3))
  Gcoeff(:)%j = (c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,2,1,8,16],[nMB,0,0,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(5),n2h32(4))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[0,0,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,1,2,4,16,8],[0,0,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,1,2,8,16,4],[0,0,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (c(30)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,1,16,2,8],[nMB,0,0,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(9),n2h32(5))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(30)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,8,4,1,16],[0,0,nMB,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(6))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j)+c(9)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,16,1,4,8],[0,0,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(30)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,4,8,2,16],[0,0,nMB,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(7))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,4,16,8,2],[0,0,nMB,nMB,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(8))
  Gcoeff(:)%j = (c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,16,1,8],[nMB,0,0,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(14),n2h32(9))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,4,8,1,16],[0,0,nMB,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(10))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,16,1,8,4],[0,0,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,1,8,4,2,16],[0,0,nMB,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(11))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,1,8,16,4,2],[0,0,nMB,nMB,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(12))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)-c(10)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,16,2,4,8],[0,0,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j)+c(9)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,16,2,8,4],[0,0,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_V(ntryL,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_VA_Q(ntryL,G1H32(3),ex2(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(3),34,0,G2H16(1),n2h16(1))
  call Hloop_QA_V(ntryL,G1H32(4),ex4(:),G1H16(3),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_V(ntryL,G1H32(5),ex3(:),G1H16(4),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_VA_Q(ntryL,G1H32(6),ex2(:),G1H16(5),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(5),34,0,G2H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G1H32(7),ex1(:),G1H16(5),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(5),33,0,G2H16(3),n2h16(3))
  call Hloop_VQ_A(ntryL,G1H32(8),ex1(:),G1H16(5),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(5),33,0,G2H16(4),n2h16(4))
  call Hloop_AQ_V(ntryL,G1H32(9),ex3(:),G1H16(5),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_QA_V(ntryL,G1H32(10),ex2(:),G1H16(6),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_VA_Q(ntryL,G1H32(11),ex2(:),G1H16(7),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(7),34,0,G2H16(5),n2h16(5))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(7),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G1H32(13),ex1(:),G1H16(8),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex3(:),G1H16(9),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_QA_V(ntryL,G1H32(15),ex2(:),G1H16(10),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_VA_Q(ntryL,G1H32(16),ex2(:),G1H16(11),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(11),34,0,G2H16(6),n2h16(6))
  call Hloop_AQ_V(ntryL,G1H32(17),ex1(:),G1H16(11),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_V(ntryL,G1H32(18),ex1(:),G1H16(12),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(13),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(13),33,0,G2H16(7),n2h16(7))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(13),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(13),33,0,G2H16(8),n2h16(8))
  call Hloop_VA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(4),n2h8(3))
  call Hloop_VA_Q(ntryL,G1H16(4),ex2(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(5),n2h8(4))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(3),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_V(ntryL,G2H16(4),ex2(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(9),n2h8(5))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMB,G2H8(10),n2h8(6))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(1),mass5set(:,1),  & 
G1H16(13),G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMB,G2H8(11),n2h8(7))
  call Hloop_VQ_A(ntryL,G1H16(8),ex3(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMB,G2H8(12),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(13),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(10),ex3(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),38,nMB,G2H8(14),n2h8(10))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(1),mass5set(:,1),  & 
G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(14),16)
  call HG1shiftOLR(G1H16(7),4,16)
  call Hloop_VA_Q(ntryL,G1H16(11),ex4(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),41,nMB,G2H8(15),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex4(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),41,nMB,G2H8(16),n2h8(12))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(11),G1H16(12),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(12),8,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),4,16)
  call Hloop_AV_Q(ntryL,G1H16(13),ex5(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(17),n2h8(13))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AV_Q(ntryL,G1H16(3),ex5(:),G1H8(2),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(18),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(4),ex5(:),G1H8(2),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(19),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(5),ex5(:),G1H8(2),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(20),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(2),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(21),n2h8(17))
call HGT_raise_alpha_OLR(G1H16(7),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(2),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AV_Q(ntryL,G1H16(9),ex5(:),G1H8(3),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(22),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(3),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(23),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(14),ex5(:),G1H8(3),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(24),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(3),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(25),n2h8(21))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(12),ex4(:),G1H8(3),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(4),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(26),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(4),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(27),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(18),ex5(:),G1H8(4),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(28),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(19),ex5(:),G1H8(4),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(29),n2h8(25))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(4),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(5),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(30),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(5),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(31),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(5),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(5),49,0,G2H8(32),n2h8(28))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(3),mass5set(:,2),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(4),mass5set(:,2),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(12),4,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(5),mass5set(:,2),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(6),mass5set(:,2),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(24),4,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(7),mass5set(:,3),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(30),8,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(11),ex4(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(8),mass5set(:,4),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(36),2,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(9),mass5set(:,3),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hloop_QA_V(ntryL,G2H8(14),ex4(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(15),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(10),mass5set(:,4),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),2,8)
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G2H8(20),ex1(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G2H8(21),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G2H8(23),ex1(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G2H8(24),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(25),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_V(ntryL,G2H8(28),ex2(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_V(ntryL,G2H8(29),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G2H8(32),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMB,G2H4(21),n2h4(1))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(9),ex3(:),G1H4(2),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(2),39,nMB,G2H4(22),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(10),ex3(:),G1H4(2),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(2),39,nMB,G2H4(23),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(11),ex4(:),G1H4(2),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(2),43,nMB,G2H4(24),n2h4(4))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(2),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(3),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(3),43,nMB,G2H4(25),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(16),ex4(:),G1H4(3),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(3),43,nMB,G2H4(26),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(17),ex3(:),G1H4(3),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(3),39,nMB,G2H4(27),n2h4(7))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(3),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_VQ_A(ntryL,G1H8(21),ex3(:),G1H4(4),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(4),39,nMB,G2H4(28),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(22),ex3(:),G1H4(4),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(4),39,nMB,G2H4(29),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(4),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(4),43,nMB,G2H4(30),n2h4(10))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex3(:),G1H4(4),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_VA_Q(ntryL,G1H8(27),ex4(:),G1H4(5),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(5),43,nMB,G2H4(31),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(28),ex4(:),G1H4(5),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(5),43,nMB,G2H4(32),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(29),ex5(:),G1H4(5),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(33),n2h4(13))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(30),-8,nMB,G2H8(1),n2h8(33))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(34),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(5),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(35),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(34),ex5(:),G1H4(5),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(36),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(5),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMB,G2H4(37),n2h4(16))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-2,0,G2H8(2),n2h8(34))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(38),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(5),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMB,G2H4(39),n2h4(17))
  call Hloop_QV_A(ntryL,G1H8(40),ex5(:),G1H4(5),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMB,G2H4(40),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(5),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(41),n2h4(19))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(42),-8,nMB,G2H8(3),n2h8(35))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(42),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AV_Q(ntryL,G1H8(45),ex5(:),G1H4(5),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(43),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(46),ex5(:),G1H4(5),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(5),54,0,G2H4(44),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(5),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(5),57,nMB,G2H4(45),n2h4(22))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-2,0,G2H8(4),n2h8(36))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(46),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(51),ex5(:),G1H4(5),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(5),57,nMB,G2H4(47),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H8(52),ex5(:),G1H4(5),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(5),57,nMB,G2H4(48),n2h4(24))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(11),mass5set(:,3),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(12),mass5set(:,3),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(13),mass5set(:,3),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(14),mass5set(:,3),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(15),mass5set(:,5),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(16),mass5set(:,5),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(17),mass5set(:,5),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(18),mass5set(:,5),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(1),mass5set(:,1),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(19),mass5set(:,2),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(1),mass5set(:,1),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(20),mass5set(:,2),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,1),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(21),mass5set(:,2),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(2),mass5set(:,1),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(22),mass5set(:,2),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(3),mass5set(:,2),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),8,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(23),mass5set(:,2),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(4),mass5set(:,2),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(24),mass5set(:,2),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),4,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(5),mass5set(:,2),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),8,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(25),mass5set(:,2),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(6),mass5set(:,2),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),4,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(26),mass5set(:,2),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),4,4)
  call Hloop_QA_V(ntryL,G2H4(33),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(36),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(37),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(40),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(41),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(44),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(45),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(48),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(142)])
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(9),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(6),-16,nMB,G2H4(1),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(11),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(12),n2h2(3))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-16,nMB,G2H4(2),n2h4(26))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(14),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(15),n2h2(5))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-16,nMB,G2H4(3),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(22),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(17),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(18),n2h2(7))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-16,nMB,G2H4(4),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(28),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(20),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(29),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(21),n2h2(9))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-16,0,G2H4(5),n2h4(29))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(34),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(10))
  call Hloop_VA_Q(ntryL,G1H4(35),ex2(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(24),n2h2(11))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(36),-16,0,G2H4(6),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_VA_Q(ntryL,G1H4(40),ex2(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(26),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(27),n2h2(13))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(42),-16,0,G2H4(7),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(7),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(46),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(30),n2h2(15))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-16,0,G2H4(8),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VA_Q(ntryL,G1H4(52),ex2(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(32),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(53),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(33),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VQ_A(ntryL,G1H4(59),ex3(:),G1H2(2),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMB,G2H2(34),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(60),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(60),ex4(:),G1H2(2),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VQ_A(ntryL,G1H4(64),ex3(:),G1H2(3),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(35),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(65),ex4(:),G1H2(3),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMB,G2H2(36),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(66),ex3(:),G1H2(3),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(71),ex4(:),G1H2(4),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(4),59,nMB,G2H2(37),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(72),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(72),ex3(:),G1H2(4),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VA_Q(ntryL,G1H4(76),ex4(:),G1H2(5),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(5),59,nMB,G2H2(38),n2h2(22))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(5),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(5),55,nMB,G2H2(39),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(78),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(78),ex4(:),G1H2(5),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(83),ex3(:),G1H2(6),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(40),n2h2(24))
call HGT_raise_alpha_OLR(G1H4(84),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(6),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(88),ex3(:),G1H2(7),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(41),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(89),ex4(:),G1H2(7),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(7),59,nMB,G2H2(42),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(90),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(90),ex3(:),G1H2(7),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VA_Q(ntryL,G1H4(95),ex4(:),G1H2(8),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMB,G2H2(43),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(96),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(96),ex3(:),G1H2(8),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_VA_Q(ntryL,G1H4(100),ex4(:),G1H2(9),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(44),n2h2(28))
  call Hloop_QV_A(ntryL,G1H4(101),ex5(:),G1H2(9),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(45),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(102),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(9),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(107),ex5(:),G1H2(10),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMB,G2H2(46),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(108),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(108),ex4(:),G1H2(10),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_QV_A(ntryL,G1H4(112),ex5(:),G1H2(11),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMB,G2H2(47),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H4(113),ex5(:),G1H2(11),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(11),59,nMB,G2H2(48),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(114),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(114),ex3(:),G1H2(11),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(119),ex5(:),G1H2(12),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(12),59,nMB,G2H2(49),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(120),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(120),ex3(:),G1H2(12),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AV_Q(ntryL,G1H4(124),ex5(:),G1H2(13),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(13),59,nMB,G2H2(50),n2h2(34))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(13),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMB,G2H2(51),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(126),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(126),ex4(:),G1H2(13),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(131),ex5(:),G1H2(14),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(14),55,nMB,G2H2(52),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(132),ex4(:),G1H2(14),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(136),ex5(:),G1H2(15),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(53),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H4(137),ex5(:),G1H2(15),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(54),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(138),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(138),ex3(:),G1H2(15),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AV_Q(ntryL,G1H4(143),ex5(:),G1H2(16),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(55),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(144),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(144),ex3(:),G1H2(16),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AV_Q(ntryL,G1H4(148),ex5(:),G1H2(17),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(17),59,nMB,G2H2(56),n2h2(40))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,3),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(8),mass5set(:,4),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),2,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,3),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,4),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),2,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(11),mass5set(:,3),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(12),mass5set(:,3),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(13),mass5set(:,3),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(14),mass5set(:,3),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(15),mass5set(:,5),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(16),mass5set(:,5),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(17),mass5set(:,5),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(18),mass5set(:,5),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(12),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(16),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(18),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(20),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(22),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(23),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(24),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(4),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(5),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(6),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(7),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(8),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(9),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(10),mass5set(:,4),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(11),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(12),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(13),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(14),mass5set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(15),mass5set(:,5),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(16),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(17),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(18),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(3,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(13))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(2,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(14))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(2,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(3),n2h32(15))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(2,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(4),n2h32(16))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(3,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(5),n2h32(17))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*M(3,:)%j-c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(6),n2h32(18))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(19)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,8,16,4],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,16,3,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)+c(19)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,3,4,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,3,4,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(10),n2h32(19))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,3,16,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,3,8,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(12),n2h32(20))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(21))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(22))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(23))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(24))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(25))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j+c(30)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(26))
  Gcoeff(:)%j = (c(35)*M(3,:)%j+c(30)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(9)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(35)*M(2,:)%j+c(30)*(-M(1,:)%j+M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(9)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(27))
  Gcoeff(:)%j = (c(9)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(28))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,4,8,17],[0,0,nMB,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(29))
  Gcoeff(:)%j = (c(8)*M(2,:)%j+c(10)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,8,4,2,17],[0,nMB,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,2,17,8],[nMB,0,0,0,nMB],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(27),n2h32(30))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(30)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,8,4,17],[0,0,nMB,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(31))
  Gcoeff(:)%j = (c(8)*(M(2,:)%j-M(3,:)%j)+c(9)*(M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,8,2,17],[0,nMB,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(30)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,17,2,8],[nMB,0,0,0,nMB],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(30),n2h32(32))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(8)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,2,17,8,4],[0,0,0,nMB,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j)+c(9)*(M(1,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,2,17,4,8],[0,0,0,nMB,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(30)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,4,8,18],[0,0,nMB,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (c(8)*(M(2,:)%j-M(3,:)%j)+c(9)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,4,1,18],[0,nMB,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(30)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,1,18,8],[nMB,0,0,0,nMB],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(35),n2h32(34))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(27)*(-M(2,:)%j-M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,8,4,18],[0,0,nMB,0,0],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(35))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(8)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,8,1,18],[0,nMB,0,0,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(27)*(-M(2,:)%j-M(3,:)%j)+c(26)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,4,18,1,8],[nMB,0,0,0,nMB],5,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(38),n2h32(36))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j)+c(9)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,18,8,4],[0,0,0,nMB,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)-c(10)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,18,4,8],[0,0,0,nMB,0],5,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,1,8,20],[0,0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,8,1,2,20],[nMB,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(42),n2h32(37))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,8,20],[0,0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,2,20,8],[0,0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,8,2,1,20],[nMB,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(45),n2h32(38))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,2,1,20,8],[0,0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,8,20,2],[0,0,nMB,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(39))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,1,20,8,2],[0,0,nMB,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(40))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,2,1,4,24],[0,0,0,nMB,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,4,1,2,24],[nMB,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(50),n2h32(41))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,4,24],[0,0,0,nMB,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(51),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,2,24,4],[0,0,0,nMB,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(16)*(M(2,:)%j+M(3,:)%j)-c(15)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,4,2,1,24],[nMB,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(53),n2h32(42))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,2,1,24,4],[0,0,0,nMB,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,4,24,2],[0,0,nMB,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(43))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*(M(2,:)%j+M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,1,24,4,2],[0,0,nMB,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(44))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(33)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[33,8,4,2,16],[0,nMB,0,0,0],5,1,wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(22)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[33,2,4,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,17))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j-c(28)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[33,4,8,2,16],[0,nMB,0,0,0],5,1,wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(2),m3h4x16(:,3),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(17)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[33,2,8,16,4],[0,0,nMB,nMB,0],5,1,wf4(:,17))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(1),n2h16(14))
  Gcoeff(:)%j = (c(31)*M(1,:)%j-c(28)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[34,8,4,1,16],[0,nMB,0,0,0],5,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,5),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(17)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[34,1,4,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,6),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(3),n2h16(15))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(33)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[34,4,8,1,16],[0,nMB,0,0,0],5,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,7),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(22)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[34,1,8,16,4],[0,0,nMB,nMB,0],5,1,wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,8),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(5),34,0,G1H16(4),n2h16(16))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)-c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[36,2,1,8,16],[0,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,9),heltab2x64(:,:,85))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(20)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[36,1,2,8,16],[0,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,10),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(33)*M(2,:)%j+c(26)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[36,2,16,1,8],[0,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,11),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)+c(31)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[36,1,16,2,8],[0,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,12),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(17)*M(3,:)%j-c(20)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[40,2,1,4,16],[0,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,13),heltab2x64(:,:,89))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)-c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[40,1,2,4,16],[0,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,14),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(28)*M(3,:)%j)+c(31)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[40,2,16,1,4],[0,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,15),heltab2x64(:,:,91))
  Gcoeff(:)%j = (c(33)*M(3,:)%j+c(26)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[40,1,16,2,4],[0,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,16),heltab2x64(:,:,92))
  call Hloop_AV_Q(ntryL,G1H16(2),ex5(:),G1H8(5),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(5),50,0,G2H8(5),n2h8(37))
  call Hloop_AV_Q(ntryL,G1H16(8),ex5(:),G1H8(6),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(6),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(15),ex5(:),G1H8(9),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(9),49,0,G2H8(7),n2h8(39))
  call Hloop_QV_A(ntryL,G1H16(21),ex5(:),G1H8(10),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(10),49,0,G2H8(8),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(11),m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(11),35,nMB,G2H8(9),n2h8(41))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,1),G1H8(12),m3h4x8(:,2),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(12),35,nMB,G2H8(10),n2h8(42))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(15),m3h4x8(:,3),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(15),35,nMB,G2H8(11),n2h8(43))
  call Hloop_AQ_V(ntryL,G1H32(4),ex3(:),G1H16(5),m3h2x16(:,21),heltab2x32(:,:,24))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(16),m3h4x8(:,4),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(16),35,nMB,G2H8(12),n2h8(44))
  call Hloop_QA_V(ntryL,G1H32(6),ex4(:),G1H16(6),m3h2x16(:,22),heltab2x32(:,:,26))
  call Hloop_UV_W(ntryL,G1H32(7),32,wf4(:,1),3,G2H8(13),m3h4x8(:,5),heltab2x32(:,:,27))
  call Hloop_VQ_A(ntryL,G1H32(8),ex3(:),G1H16(7),m3h2x16(:,23),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(7),36,nMB,G2H16(1),n2h16(17))
  call Hloop_UV_W(ntryL,G1H32(9),32,wf4(:,1),3,G2H8(14),m3h4x8(:,6),heltab2x32(:,:,29))
  call Hloop_QA_V(ntryL,G1H32(10),ex4(:),G1H16(9),m3h2x16(:,24),heltab2x32(:,:,30))
  call Hloop_VQ_A(ntryL,G1H32(11),ex3(:),G1H16(10),m3h2x16(:,25),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(10),36,nMB,G2H16(2),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H32(12),ex3(:),G1H16(14),m3h2x16(:,26),heltab2x32(:,:,32))
  call Hloop_QA_V(ntryL,G1H32(13),ex2(:),G1H16(11),m3h2x16(:,27),heltab2x32(:,:,33))
  call Hloop_QV_A(ntryL,G1H32(14),wf4(:,12),G1H8(17),m3h4x8(:,7),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(17),44,0,G2H8(15),n2h8(45))
  call Hloop_AQ_V(ntryL,G1H32(15),ex1(:),G1H16(12),m3h2x16(:,28),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(16),m3h2x16(:,29),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,12),G1H8(18),m3h4x8(:,8),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(16),n2h8(46))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(17),m3h2x16(:,30),heltab2x32(:,:,38))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(18),m3h2x16(:,31),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(18),33,0,G2H16(3),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(19),m3h2x16(:,32),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(19),33,0,G2H16(4),n2h16(20))
  call Hloop_VA_Q(ntryL,G1H32(21),ex2(:),G1H16(20),m3h2x16(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(20),34,0,G2H16(5),n2h16(21))
  call Hloop_QA_V(ntryL,G1H32(22),ex2(:),G1H16(22),m3h2x16(:,34),heltab2x32(:,:,42))
  call Hloop_VQ_A(ntryL,G1H32(23),ex1(:),G1H16(23),m3h2x16(:,35),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(6),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(24),m3h2x16(:,36),heltab2x32(:,:,44))
  call Hloop_QA_V(ntryL,G1H32(25),ex2(:),G1H16(2),m3h2x16(:,37),heltab2x32(:,:,45))
  call Hloop_VA_Q(ntryL,G1H32(26),ex4(:),G1H16(8),m3h2x16(:,38),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(8),40,nMB,G2H16(7),n2h16(23))
  call Hloop_AQ_V(ntryL,G1H32(27),ex3(:),G1H16(15),m3h2x16(:,39),heltab2x32(:,:,47))
  call Hloop_QA_V(ntryL,G1H32(28),ex2(:),G1H16(21),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_VQ_A(ntryL,G1H32(29),ex3(:),G1H16(7),m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(7),36,nMB,G2H16(8),n2h16(24))
  call Hloop_AQ_V(ntryL,G1H32(30),ex3(:),G1H16(10),m3h2x16(:,42),heltab2x32(:,:,50))
  call Hloop_VA_Q(ntryL,G1H32(31),ex2(:),G1H16(18),m3h2x16(:,43),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H16(18),34,0,G2H16(9),n2h16(25))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(19),m3h2x16(:,44),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(10),n2h16(26))
  call Hloop_AQ_V(ntryL,G1H32(33),ex1(:),G1H16(20),m3h2x16(:,45),heltab2x32(:,:,53))
  call Hloop_VA_Q(ntryL,G1H32(34),ex4(:),G1H16(23),m3h2x16(:,46),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(23),40,nMB,G2H16(11),n2h16(27))
  call Hloop_AQ_V(ntryL,G1H32(35),ex3(:),G1H16(8),m3h2x16(:,47),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(7),m3h2x16(:,48),heltab2x32(:,:,56))
  call Hloop_VQ_A(ntryL,G1H32(37),ex3(:),G1H16(18),m3h2x16(:,49),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H16(18),36,nMB,G2H16(12),n2h16(28))
  call Hloop_AQ_V(ntryL,G1H32(38),ex3(:),G1H16(19),m3h2x16(:,50),heltab2x32(:,:,58))
  call Hloop_VQ_A(ntryL,G1H32(39),ex1(:),G1H16(23),m3h2x16(:,51),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(13),n2h16(29))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(18),m3h2x16(:,52),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(18),33,0,G2H16(14),n2h16(30))
  call Hloop_VA_Q(ntryL,G1H32(41),ex2(:),G1H16(23),m3h2x16(:,53),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(23),34,0,G2H16(15),n2h16(31))
  call Hloop_QA_V(ntryL,G1H32(42),ex4(:),G1H16(18),m3h2x16(:,54),heltab2x32(:,:,62))
  call Hloop_VQ_A(ntryL,G1H32(43),ex1(:),G1H16(23),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(16),n2h16(32))
  call Hloop_VQ_A(ntryL,G1H32(44),ex1(:),G1H16(23),m3h2x16(:,56),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(17),n2h16(33))
  call Hloop_QA_V(ntryL,G1H32(45),ex4(:),G1H16(23),m3h2x16(:,57),heltab2x32(:,:,65))
  call Hloop_VA_Q(ntryL,G1H32(46),ex2(:),G1H16(25),m3h2x16(:,58),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(25),34,0,G2H16(18),n2h16(34))
  call Hloop_AQ_V(ntryL,G1H32(47),ex1(:),G1H16(25),m3h2x16(:,59),heltab2x32(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(26),m3h2x16(:,60),heltab2x32(:,:,68))
  call Hloop_VA_Q(ntryL,G1H32(49),ex2(:),G1H16(27),m3h2x16(:,61),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(27),34,0,G2H16(19),n2h16(35))
  call Hloop_AQ_V(ntryL,G1H32(50),ex3(:),G1H16(27),m3h2x16(:,62),heltab2x32(:,:,70))
  call Hloop_VQ_A(ntryL,G1H32(51),ex1(:),G1H16(28),m3h2x16(:,63),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(28),33,0,G2H16(20),n2h16(36))
  call Hloop_VQ_A(ntryL,G1H32(52),ex1(:),G1H16(28),m3h2x16(:,64),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(28),33,0,G2H16(21),n2h16(37))
  call Hloop_AQ_V(ntryL,G1H32(53),ex3(:),G1H16(28),m3h2x16(:,65),heltab2x32(:,:,73))
  call Hloop_VA_Q(ntryL,G1H32(54),ex2(:),G1H16(29),m3h2x16(:,66),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(29),34,0,G2H16(22),n2h16(38))
  call Hloop_AQ_V(ntryL,G1H32(55),ex1(:),G1H16(29),m3h2x16(:,67),heltab2x32(:,:,75))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(30),m3h2x16(:,68),heltab2x32(:,:,76))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(1),41,nMB,G1H8(21),n2h8(47))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(22),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_VQ_A(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G0H8(1),37,nMB,G1H8(23),n2h8(48))
  call Hloop_QA_V(ntryL,G1H16(1),ex2(:),G1H8(24),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_VA_Q(ntryL,G0H16(3),ex4(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(1),42,nMB,G1H8(27),n2h8(49))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(28),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_VQ_A(ntryL,G0H16(4),ex3(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(1),38,nMB,G1H8(29),n2h8(50))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(30),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_VA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(33),n2h8(51))
  call Hloop_VQ_A(ntryL,G0H16(6),ex1(:),G0H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(34),n2h8(52))
  call Hloop_VA_Q(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(35),n2h8(53))
  call Hloop_VQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(36),n2h8(54))
  call Hloop_VA_Q(ntryL,G0H16(9),ex2(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(39),n2h8(55))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(40),n2h8(56))
  call Hloop_VA_Q(ntryL,G0H16(11),ex2(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(41),n2h8(57))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(42),n2h8(58))
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(43)])
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(35)])
call HGT_w2_OLR(G1H8(3),1,1,8)
call HGT_w2_invQ_OLR(G1H8(3),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(31)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(20),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(26),G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(25)])
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(58),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(58),58,0,G2H4(9),n2h4(49))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(11),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(70),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(70),54,0,G2H4(12),n2h4(50))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(14),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(82),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(82),57,0,G2H4(15),n2h4(51))
  call Hloop_QA_V(ntryL,G2H8(26),ex2(:),G2H4(17),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(94),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(94),53,0,G2H4(18),n2h4(52))
  call Hloop_QA_V(ntryL,G2H8(30),ex2(:),G2H4(20),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_VQ_A(ntryL,G1H8(28),ex3(:),G1H4(106),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(106),39,nMB,G2H4(21),n2h4(53))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(27),mass5set(:,4),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hloop_VA_Q(ntryL,G1H8(30),ex4(:),G1H4(118),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(118),43,nMB,G2H4(23),n2h4(54))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(28),mass5set(:,4),  & 
G1H8(5),G1H8(6),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(6),4,8)
  call Hloop_VQ_A(ntryL,G1H8(22),ex3(:),G1H4(130),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(130),39,nMB,G2H4(24),n2h4(55))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(142),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(142),43,nMB,G2H4(26),n2h4(56))
  call Hloop_QV_A(ntryL,G1H8(32),ex5(:),G1H4(5),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(5),53,0,G2H4(27),n2h4(57))
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(6),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(6),53,nMB,G2H4(29),n2h4(58))
  call Hloop_QV_A(ntryL,G1H8(38),ex5(:),G1H4(10),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(10),53,nMB,G2H4(30),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H8(44),ex5(:),G1H4(11),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(11),54,0,G2H4(32),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H8(49),ex5(:),G1H4(12),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(12),57,nMB,G2H4(33),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(16),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(16),57,nMB,G2H4(36),n2h4(62))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(37),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(40),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(41),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_QA_V(ntryL,G2H8(8),ex2(:),G2H4(44),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(29),mass5set(:,6),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(41),G1H8(43),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_QA_V(ntryL,G2H8(10),ex4(:),G2H4(45),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(30),mass5set(:,6),  & 
G1H8(35),G1H8(42),G1H8(31),G1H8(36),G1H8(7),G1H8(20),8)
  call HG1shiftOLR(G1H8(42),4,8)
  call Hloop_VA_Q(ntryL,G1H16(5),ex4(:),G1H8(8),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(8),44,nMB,G2H8(17),n2h8(59))
  call Hloop_AQ_V(ntryL,G2H8(12),ex3(:),G2H4(48),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(6),ex3(:),G1H8(13),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(13),44,nMB,G2H8(19),n2h8(60))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(31),mass5set(:,7),  & 
G1H16(13),G1H16(1),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_UV_W(ntryL,G1H16(9),40,wf4(:,1),3,G2H4(1),m3h4x4(:,1),heltab2x16(:,:,59))
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(32),mass5set(:,7),  & 
G1H16(9),G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),16)
  call HG1shiftOLR(G1H16(31),8,16)
  call Hloop_UV_W(ntryL,G1H16(14),36,wf4(:,1),3,G2H4(2),m3h4x4(:,2),heltab2x16(:,:,60))
  call Hloop_VQ_A(ntryL,G1H16(11),ex1(:),G1H8(26),m3h2x8(:,59),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(26),35,0,G2H8(20),n2h8(61))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(3),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(14),m3h2x8(:,60),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(14),35,0,G2H8(21),n2h8(62))
  call Hloop_VA_Q(ntryL,G1H16(16),ex2(:),G1H8(19),m3h2x8(:,61),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(23),n2h8(63))
  call Hloop_AQ_V(ntryL,G2H8(16),ex1(:),G2H4(4),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VQ_A(ntryL,G1H16(17),ex1(:),G1H8(25),m3h2x8(:,62),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(25),35,0,G2H8(24),n2h8(64))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(2),mass5set(:,1),  & 
G1H16(14),G1H16(11),G1H16(12),G1H16(16),G1H16(17),G1H16(36),16)
  call HG1shiftOLR(G1H16(11),12,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(33),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),2,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(1),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),12,16)
  call Hloop_UV_W(ntryL,G1H16(22),34,wf4(:,12),12,G2H4(5),m3h4x4(:,3),heltab2x16(:,:,65))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(34),mass5set(:,1),  & 
G1H16(22),G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),16)
  call HG1shiftOLR(G1H16(49),2,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,wf4(:,12),12,G2H4(6),m3h4x4(:,4),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),38,nMB,G2H8(25),n2h8(65))
  call Hloop_AQ_V(ntryL,G2H16(7),ex3(:),G2H8(27),m3h2x8(:,64),heltab2x16(:,:,68))
  call Hloop_VA_Q(ntryL,G1H16(15),ex2(:),G1H8(2),m3h2x8(:,65),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(28),n2h8(66))
  call Hloop_VA_Q(ntryL,G1H16(21),ex4(:),G1H8(3),m3h2x8(:,66),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(3),42,nMB,G2H8(29),n2h8(67))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(31),m3h2x8(:,67),heltab2x16(:,:,71))
  call Hloop_VQ_A(ntryL,G1H16(10),wf4(:,13),G1H4(17),m3h4x4(:,5),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(17),53,0,G2H4(7),n2h4(63))
  call Hloop_AQ_V(ntryL,G2H16(9),wf4(:,13),G2H4(8),m3h4x4(:,6),heltab2x16(:,:,73))
  call Hloop_AQ_V(ntryL,G2H16(10),wf4(:,13),G2H4(49),m3h4x4(:,7),heltab2x16(:,:,74))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(4),m3h2x8(:,68),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(4),37,nMB,G2H8(32),n2h8(68))
  call Hloop_AQ_V(ntryL,G2H16(11),ex3(:),G2H8(1),m3h2x8(:,69),heltab2x16(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(28),m3h2x8(:,70),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(28),37,0,G2H8(2),n2h8(69))
  call Hloop_VA_Q(ntryL,G1H16(7),ex4(:),G1H8(30),m3h2x8(:,71),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(30),41,nMB,G2H8(3),n2h8(70))
  call Hloop_QA_V(ntryL,G2H16(12),ex4(:),G2H8(4),m3h2x8(:,72),heltab2x16(:,:,79))
  call Hloop_VA_Q(ntryL,G1H16(19),wf4(:,18),G1H4(18),m3h4x4(:,8),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(50),n2h4(64))
  call Hloop_QA_V(ntryL,G2H16(13),wf4(:,18),G2H4(51),m3h4x4(:,9),heltab2x16(:,:,81))
  call Hloop_QA_V(ntryL,G2H16(14),wf4(:,18),G2H4(52),m3h4x4(:,10),heltab2x16(:,:,82))
  call Hloop_AQ_V(ntryL,G2H16(15),ex1(:),G2H8(18),m3h2x8(:,73),heltab2x16(:,:,83))
  call Hloop_VQ_A(ntryL,G1H16(18),ex1(:),G1H8(22),m3h2x8(:,74),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(22),41,0,G2H8(22),n2h8(71))
  call Hloop_QA_V(ntryL,G2H16(16),ex2(:),G2H8(26),m3h2x8(:,75),heltab2x16(:,:,85))
  call Hloop_QA_V(ntryL,G2H16(17),ex2(:),G2H8(30),m3h2x8(:,76),heltab2x16(:,:,86))
  call Hloop_VA_Q(ntryL,G1H16(23),ex2(:),G1H8(24),m3h2x8(:,77),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(24),42,0,G2H8(14),n2h8(72))
  call Hloop_AQ_V(ntryL,G2H16(18),ex1(:),G2H8(13),m3h2x8(:,78),heltab2x16(:,:,88))
  call Hloop_VA_Q(ntryL,G1H16(25),ex4(:),G1H8(32),m3h2x8(:,79),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(32),41,nMB,G2H8(5),n2h8(73))
  call Hloop_VQ_A(ntryL,G1H16(26),wf4(:,4),G1H4(22),m3h4x4(:,11),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(22),53,nMB,G2H4(53),n2h4(65))
  call Hloop_AQ_V(ntryL,G2H16(19),ex1(:),G2H8(6),m3h2x8(:,80),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G1H16(27),ex1(:),G1H8(37),m3h2x8(:,81),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(7),n2h8(74))
  call Hloop_QA_V(ntryL,G2H16(20),ex2(:),G2H8(8),m3h2x8(:,82),heltab2x16(:,:,93))
  call Hloop_QA_V(ntryL,G2H16(21),ex2(:),G2H8(9),m3h2x8(:,83),heltab2x16(:,:,94))
  call Hloop_VA_Q(ntryL,G1H16(28),ex2(:),G1H8(38),m3h2x8(:,84),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(38),38,0,G2H8(10),n2h8(75))
  call Hloop_AQ_V(ntryL,G2H16(22),ex1(:),G2H8(11),m3h2x8(:,85),heltab2x16(:,:,96))
  call Hloop_VQ_A(ntryL,G1H16(29),ex3(:),G1H8(44),m3h2x8(:,86),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(44),37,nMB,G2H8(12),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H16(30),wf4(:,9),G1H4(23),m3h4x4(:,12),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(23),57,nMB,G2H4(54),n2h4(66))
  call Hloop_AQ_V(ntryL,G1H8(21),ex3(:),G1H4(24),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_QA_V(ntryL,G1H8(23),ex4(:),G1H4(28),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AQ_V(ntryL,G1H8(27),ex3(:),G1H4(29),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_V(ntryL,G1H8(29),ex4(:),G1H4(30),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_AQ_V(ntryL,G1H8(33),ex1(:),G1H4(34),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_V(ntryL,G1H8(34),ex2(:),G1H4(35),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AQ_V(ntryL,G1H8(39),ex1(:),G1H4(36),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_V(ntryL,G1H8(40),ex2(:),G1H4(40),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_VQ_A(ntryL,G1H8(45),ex3(:),G1H4(41),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(41),39,nMB,G2H4(55),n2h4(67))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(46),ex4(:),G1H4(42),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_VQ_A(ntryL,G1H8(48),ex3(:),G1H4(46),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(46),39,nMB,G2H4(56),n2h4(68))
  call Hloop_VQ_A(ntryL,G1H8(51),ex3(:),G1H4(47),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(47),39,nMB,G2H4(57),n2h4(69))
  call Hloop_VQ_A(ntryL,G1H8(52),ex3(:),G1H4(48),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(48),39,nMB,G2H4(58),n2h4(70))
  call Hloop_VA_Q(ntryL,G1H8(5),ex4(:),G1H4(52),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(52),43,nMB,G2H4(59),n2h4(71))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(53),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_VA_Q(ntryL,G1H8(10),ex4(:),G1H4(54),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(54),43,nMB,G2H4(60),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(11),ex4(:),G1H4(59),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(59),43,nMB,G2H4(61),n2h4(73))
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(60),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(60),43,nMB,G2H4(62),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(64),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(64),51,nMB,G2H4(63),n2h4(75))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-8,nMB,G2H8(15),n2h8(79))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(64),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AV_Q(ntryL,G1H8(18),ex5(:),G1H4(65),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(65),51,nMB,G2H4(65),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(66),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(66),51,nMB,G2H4(66),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(71),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(71),51,nMB,G2H4(67),n2h4(78))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(72),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(72),51,nMB,G2H4(68),n2h4(79))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(42),-4,nMB,G2H8(16),n2h8(80))
  call Hloop_AQ_V(ntryL,G2H8(16),ex3(:),G2H4(69),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(76),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(76),51,nMB,G2H4(70),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(77),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(77),51,nMB,G2H4(71),n2h4(81))
  call Hloop_QV_A(ntryL,G1H8(20),ex5(:),G1H4(78),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(78),51,nMB,G2H4(72),n2h4(82))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(49),m3h2x8(:,87),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(49),52,nMB,G2H8(15),n2h8(81))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(50),m3h2x8(:,88),heltab2x16(:,:,100))
  call Hloop_QV_A(ntryL,G1H16(4),ex5(:),G1H8(8),m3h2x8(:,89),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(8),52,nMB,G2H8(16),n2h8(82))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(13),m3h2x8(:,90),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(13),52,nMB,G2H8(33),n2h8(83))
  call Hloop_QV_A(ntryL,G1H16(6),ex5(:),G1H8(26),m3h2x8(:,91),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(26),52,nMB,G2H8(34),n2h8(84))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,1),G1H4(83),m3h4x4(:,13),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(83),39,nMB,G2H4(73),n2h4(83))
call HGT_raise_alpha_OLR(G1H16(31),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(31),ex4(:),G1H8(14),m3h2x8(:,92),heltab2x16(:,:,105))
  call Hloop_QV_A(ntryL,G1H16(33),wf4(:,1),G1H4(84),m3h4x4(:,14),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(84),39,nMB,G2H4(74),n2h4(84))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,1),G1H4(88),m3h4x4(:,15),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(88),39,nMB,G2H4(75),n2h4(85))
  call Hloop_QV_A(ntryL,G1H16(35),wf4(:,1),G1H4(89),m3h4x4(:,16),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(89),39,nMB,G2H4(76),n2h4(86))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(19),m3h2x8(:,93),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(35),n2h8(85))
call HGT_raise_alpha_OLR(G1H16(11),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(11),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(11),-12,wf4(:,12),12,G2H4(77),m3h4x4(:,17),heltab2x16(:,:,110))
call signflip_OLR(G2H4(77))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(25),m3h2x8(:,94),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(25),49,0,G2H8(36),n2h8(86))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(37),n2h8(87))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(2),m3h2x8(:,96),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(2),49,0,G2H8(38),n2h8(88))
  call Hloop_QV_A(ntryL,G1H16(37),ex5(:),G1H8(3),m3h2x8(:,97),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(39),n2h8(89))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(38),ex2(:),G1H8(4),m3h2x8(:,98),heltab2x16(:,:,115))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(28),m3h2x8(:,99),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(28),49,0,G2H8(40),n2h8(90))
  call Hloop_QV_A(ntryL,G1H16(41),ex5(:),G1H8(30),m3h2x8(:,100),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(30),49,0,G2H8(41),n2h8(91))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(22),m3h2x8(:,101),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(22),49,0,G2H8(42),n2h8(92))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(24),m3h2x8(:,102),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(24),50,0,G2H8(43),n2h8(93))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(44),-12,wf4(:,12),12,G2H4(78),m3h4x4(:,18),heltab2x16(:,:,120))
call signflip_OLR(G2H4(78))
  call Hloop_AV_Q(ntryL,G1H16(46),ex5(:),G1H8(32),m3h2x8(:,103),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(32),50,0,G2H8(44),n2h8(94))
  call Hloop_AV_Q(ntryL,G1H16(47),ex5(:),G1H8(37),m3h2x8(:,104),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(37),50,0,G2H8(45),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(38),m3h2x8(:,105),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(38),50,0,G2H8(46),n2h8(96))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,12),G1H4(90),m3h4x4(:,19),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(90),45,0,G2H4(79),n2h4(87))
call HGT_raise_alpha_OLR(G1H16(49),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(44),m3h2x8(:,106),heltab2x16(:,:,125))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,12),G1H4(95),m3h4x4(:,20),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(95),45,0,G2H4(80),n2h4(88))
  call Hloop_QV_A(ntryL,G1H16(52),wf4(:,12),G1H4(96),m3h4x4(:,21),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(96),45,0,G2H4(81),n2h4(89))
  call Hloop_QV_A(ntryL,G1H16(53),wf4(:,12),G1H4(100),m3h4x4(:,22),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(100),45,0,G2H4(82),n2h4(90))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(10),G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(13),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(16),G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(19),G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(7)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(25)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(19)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(13)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(103)])
call HGT_lower_alpha_w2_OLR(G2H4(38),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(38),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(38),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(115)])
call HGT_lower_alpha_w2_OLR(G2H4(46),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(46),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(46),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(21),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(27),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(45),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(51),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(128),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(134),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(140),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(146),G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(139)])
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(35),mass5set(:,2),  & 
G1H4(101),G1H4(102),G1H4(107),G1H4(108),G1H4(112),G1H4(113),4)
  call HG1shiftOLR(G1H4(102),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(36),mass5set(:,2),  & 
G1H4(114),G1H4(119),G1H4(120),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(119),4,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(37),mass5set(:,2),  & 
G1H4(131),G1H4(132),G1H4(136),G1H4(137),G1H4(138),G1H4(143),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(38),mass5set(:,2),  & 
G1H4(144),G1H4(148),G1H4(58),G1H4(70),G1H4(82),G1H4(94),4)
  call HG1shiftOLR(G1H4(148),4,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(17),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(17),47,nMB,G2H2(1),n2h2(41))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(39),mass5set(:,4),  & 
G1H4(106),G1H4(118),G1H4(130),G1H4(142),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(118),8,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(18),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(18),47,nMB,G2H2(3),n2h2(42))
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(40),mass5set(:,4),  & 
G1H4(10),G1H4(11),G1H4(12),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(11),4,4)
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(23),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(23),47,nMB,G2H2(5),n2h2(43))
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(41),mass5set(:,4),  & 
G1H4(22),G1H4(23),G1H4(41),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(24),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(24),47,nMB,G2H2(7),n2h2(44))
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(42),mass5set(:,4),  & 
G1H4(52),G1H4(54),G1H4(59),G1H4(60),G1H4(64),G1H4(65),4)
  call HG1shiftOLR(G1H4(54),4,4)
call HGT_lower_alpha_w2_OLR(G2H4(34),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(34),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(34),6,15,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(43),mass5set(:,8),  & 
G1H4(66),G1H4(71),G1H4(72),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(71),2,4)
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(9),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(44),mass5set(:,4),  & 
G1H4(83),G1H4(84),G1H4(88),G1H4(89),G1H4(90),G1H4(95),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hloop_QA_V(ntryL,G2H4(53),ex4(:),G2H2(12),m3h2x2(:,78),heltab2x4(:,:,78))
call HGT_lower_alpha_w2_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(42),6,15,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(45),mass5set(:,8),  & 
G1H4(96),G1H4(100),G1H4(57),G1H4(69),G1H4(81),G1H4(93),4)
  call HG1shiftOLR(G1H4(100),1,4)
  call Hloop_AQ_V(ntryL,G2H4(50),ex1(:),G2H2(15),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(46),mass5set(:,4),  & 
G1H4(7),G1H4(36),G1H4(105),G1H4(25),G1H4(34),G1H4(117),4)
  call HG1shiftOLR(G1H4(36),4,4)
  call Hloop_AQ_V(ntryL,G2H4(54),ex3(:),G2H2(18),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(29),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(29),47,nMB,G2H2(21),n2h2(45))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(47),mass5set(:,9),  & 
G1H4(19),G1H4(40),G1H4(129),G1H4(13),G1H4(35),G1H4(141),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(30),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(30),47,nMB,G2H2(24),n2h2(46))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(48),mass5set(:,9),  & 
G1H4(103),G1H4(115),G1H4(21),G1H4(9),G1H4(27),G1H4(15),4)
  call HG1shiftOLR(G1H4(115),16,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(35),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(35),47,nMB,G2H2(27),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(36),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(36),47,nMB,G2H2(30),n2h2(48))
  call Hloop_VQ_A(ntryL,G1H4(29),ex1(:),G1H2(41),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(41),47,0,G2H2(33),n2h2(49))
  call Hloop_VQ_A(ntryL,G1H4(32),ex1(:),G1H2(42),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(42),47,0,G2H2(36),n2h2(50))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(49),mass5set(:,1),  & 
G1H4(31),G1H4(45),G1H4(33),G1H4(37),G1H4(51),G1H4(39),4)
  call HG1shiftOLR(G1H4(45),16,4)
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(47),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(39),n2h2(51))
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(48),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(42),n2h2(52))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(50),mass5set(:,1),  & 
G1H4(43),G1H4(49),G1H4(55),G1H4(56),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(49),16,4)
  call Hloop_VQ_A(ntryL,G1H4(30),ex1(:),G1H2(53),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(53),47,0,G2H2(45),n2h2(53))
  call Hloop_VQ_A(ntryL,G1H4(44),ex1(:),G1H2(54),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(54),47,0,G2H2(48),n2h2(54))
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(59),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(59),47,0,G2H2(51),n2h2(55))
  call Hloop_VA_Q(ntryL,G1H4(50),ex2(:),G1H2(60),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(60),47,0,G2H2(54),n2h2(56))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(51),mass5set(:,2),  & 
G1H4(79),G1H4(80),G1H4(91),G1H4(92),G1H4(128),G1H4(104),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(52),mass5set(:,2),  & 
G1H4(134),G1H4(110),G1H4(140),G1H4(116),G1H4(146),G1H4(122),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(65),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(65),55,nMB,G2H2(57),n2h2(57))
  call Hloop_VQ_A(ntryL,G1H4(62),ex3(:),G1H2(66),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(66),55,nMB,G2H2(58),n2h2(58))
  call Hloop_VQ_A(ntryL,G1H4(63),ex3(:),G1H2(71),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(71),55,nMB,G2H2(59),n2h2(59))
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(53),mass5set(:,2),  & 
G1H4(127),G1H4(139),G1H4(1),G1H4(2),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(139),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(54),mass5set(:,2),  & 
G1H4(8),G1H4(14),G1H4(20),G1H4(26),G1H4(29),G1H4(32),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hloop_VA_Q(ntryL,G1H4(73),ex4(:),G1H2(72),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(72),59,nMB,G2H2(60),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(77),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(61),n2h2(61))
  call Hloop_VA_Q(ntryL,G1H4(75),ex4(:),G1H2(78),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(78),59,nMB,G2H2(62),n2h2(62))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(55),mass5set(:,2),  & 
G1H4(28),G1H4(38),G1H4(30),G1H4(44),G1H4(24),G1H4(50),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(56),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(73),G1H4(74),G1H4(75),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_VQ_A(ntryL,G1H4(85),ex3(:),G1H2(83),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(83),55,nMB,G2H2(63),n2h2(63))
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(84),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(84),55,nMB,G2H2(64),n2h2(64))
  call Hloop_VQ_A(ntryL,G1H4(87),ex3(:),G1H2(17),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMB,G2H2(65),n2h2(65))
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(57),mass5set(:,2),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(149),G1H4(150),G1H4(151),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(58),mass5set(:,2),  & 
G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(153),4,4)
  call Hloop_VA_Q(ntryL,G1H4(97),ex4(:),G1H2(18),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(18),59,nMB,G2H2(66),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(23),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(23),59,nMB,G2H2(67),n2h2(67))
  call Hloop_VA_Q(ntryL,G1H4(99),ex4(:),G1H2(24),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(24),59,nMB,G2H2(68),n2h2(68))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(27),mass5set(:,4),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hloop_QV_A(ntryL,G1H4(109),ex5(:),G1H2(29),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(69),n2h2(69))
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(55),mass4set(:,1),  & 
G1H4(109),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(161),8,4)
  call Hloop_QV_A(ntryL,G1H4(111),ex5(:),G1H2(30),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(30),55,nMB,G2H2(70),n2h2(70))
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(28),mass5set(:,4),  & 
G1H4(111),G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),4)
  call HG1shiftOLR(G1H4(165),4,4)
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(35),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(35),59,nMB,G2H2(71),n2h2(71))
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(69),mass4set(:,1),  & 
G1H4(121),G1H4(170),G1H4(171),G1H4(172),G1H4(173),4)
  call HG1shiftOLR(G1H4(170),4,4)
  call Hloop_AV_Q(ntryL,G1H4(123),ex5(:),G1H2(36),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(36),59,nMB,G2H2(72),n2h2(72))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(59),mass5set(:,4),  & 
G1H4(123),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),8,4)
  call Hloop_QV_A(ntryL,G1H4(133),ex5(:),G1H2(41),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(41),55,nMB,G2H2(73),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(135),ex5(:),G1H2(42),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(42),55,nMB,G2H2(74),n2h2(74))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(60),mass5set(:,4),  & 
G1H4(133),G1H4(135),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(135),4,4)
  call Hloop_AV_Q(ntryL,G1H4(145),ex5(:),G1H2(47),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(47),59,nMB,G2H2(75),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(147),ex5(:),G1H2(48),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(48),59,nMB,G2H2(76),n2h2(76))
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(77),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_AQ_V(ntryL,G2H4(12),ex1(:),G2H2(78),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QA_V(ntryL,G2H4(15),ex2(:),G2H2(79),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_QA_V(ntryL,G2H4(18),ex2(:),G2H2(80),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QA_V(ntryL,G2H4(27),ex2(:),G2H2(81),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_V(ntryL,G2H4(29),ex4(:),G2H2(82),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QA_V(ntryL,G2H4(30),ex4(:),G2H2(83),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AQ_V(ntryL,G2H4(32),ex1(:),G2H2(84),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_AQ_V(ntryL,G2H4(33),ex3(:),G2H2(85),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_AQ_V(ntryL,G2H4(36),ex3(:),G2H2(86),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(61),mass5set(:,10),  & 
G1H4(145),G1H4(147),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(147),16,4)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(62),mass5set(:,11),  & 
G1H8(21),G1H8(23),G1H8(27),G1H8(29),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(23),16,8)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(63),mass5set(:,10),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),16,4)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(64),mass5set(:,11),  & 
G1H8(39),G1H8(40),G1H8(45),G1H8(46),G1H8(48),G1H8(51),8)
  call HG1shiftOLR(G1H8(40),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(65),mass5set(:,1),  & 
G1H8(52),G1H8(5),G1H8(6),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(5),12,8)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(66),mass5set(:,1),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),16,4)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(67),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(18),G1H8(41),G1H8(43),G1H8(35),8)
  call HG1shiftOLR(G1H8(16),12,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(68),mass5set(:,1),  & 
G1H8(42),G1H8(36),G1H8(7),G1H8(20),G1H8(49),G1H8(8),8)
  call HG1shiftOLR(G1H8(36),16,8)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(69),mass5set(:,1),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(70),mass5set(:,1),  & 
G1H8(13),G1H8(26),G1H8(19),G1H8(25),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(10),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(71),mass5set(:,12),  & 
G1H8(3),G1H8(28),G1H8(30),G1H8(22),G1H8(24),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),17,8)
  call Hloop_AQ_V(ntryL,G2H8(28),wf4(:,13),G2H2(87),m3h4x2(:,1),heltab2x8(:,:,108))
  call Hloop_AQ_V(ntryL,G2H8(29),ex3(:),G2H4(13),m3h2x4(:,108),heltab2x8(:,:,109))
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(72),mass5set(:,12),  & 
G1H8(37),G1H8(38),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(38),17,8)
  call Hloop_QA_V(ntryL,G2H8(32),ex4(:),G2H4(16),m3h2x4(:,109),heltab2x8(:,:,110))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(73),mass5set(:,12),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),18,8)
  call Hloop_QA_V(ntryL,G2H8(2),wf4(:,18),G2H2(88),m3h4x2(:,2),heltab2x8(:,:,111))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(19),m3h2x4(:,110),heltab2x8(:,:,112))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(74),mass5set(:,12),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),18,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(4),mass5set(:,2),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),20,8)
  call Hloop_QA_V(ntryL,G2H8(22),ex2(:),G2H4(35),m3h2x4(:,111),heltab2x8(:,:,113))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(6),mass5set(:,2),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),20,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(25),mass5set(:,2),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(21),m3h2x4(:,112),heltab2x8(:,:,114))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(23),mass5set(:,2),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(88),8,8)
  call Hloop_AQ_V(ntryL,G2H8(5),wf4(:,4),G2H2(89),m3h4x2(:,3),heltab2x8(:,:,115))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(3),mass5set(:,2),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(94),24,8)
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(39),m3h2x4(:,113),heltab2x8(:,:,116))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(5),mass5set(:,2),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),8)
  call HG1shiftOLR(G1H8(100),24,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(26),mass5set(:,2),  & 
G1H8(105),G1H8(106),G1H8(107),G1H8(108),G1H8(109),G1H8(110),8)
  call HG1shiftOLR(G1H8(106),4,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(43),m3h2x4(:,114),heltab2x8(:,:,117))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(24),mass5set(:,2),  & 
G1H8(111),G1H8(112),G1H8(113),G1H8(114),G1H8(115),G1H8(116),8)
  call HG1shiftOLR(G1H8(112),4,8)
  call Hloop_QA_V(ntryL,G2H8(12),wf4(:,9),G2H2(90),m3h4x2(:,4),heltab2x8(:,:,118))
  call Hotf_4pt_reduction(G2H4(58),RedSet_4(56),mass4set(:,1),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),4)
  call HG1shiftOLR(G1H4(206),24,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(70),mass4set(:,1),  & 
G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(211),20,4)
  call Hloop_AQ_V(ntryL,G2H4(63),ex3(:),G2H2(91),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_AQ_V(ntryL,G2H4(66),ex3(:),G2H2(92),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_AQ_V(ntryL,G2H4(67),ex3(:),G2H2(93),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_QA_V(ntryL,G2H4(68),ex4(:),G2H2(94),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_QA_V(ntryL,G2H4(71),ex4(:),G2H2(95),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_QA_V(ntryL,G2H4(72),ex4(:),G2H2(96),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(31),mass5set(:,7),  & 
G1H8(117),G1H8(118),G1H8(119),G1H8(120),G1H8(121),G1H8(122),8)
  call HG1shiftOLR(G1H8(118),8,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(101),mass4set(:,2),  & 
G1H8(123),G1H8(124),G1H8(125),G1H8(126),G1H8(127),8)
  call HG1shiftOLR(G1H8(124),8,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(234),mass4set(:,2),  & 
G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(129),11,8)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(32),mass5set(:,7),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),8,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(101),mass4set(:,2),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),4)
  call HG1shiftOLR(G1H4(222),8,4)
  call Hotf_4pt_reduction(G2H4(76),RedSet_4(169),mass4set(:,2),  & 
G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(227),24,4)
  call Hloop_QA_V(ntryL,G2H8(35),ex2(:),G2H4(23),m3h2x4(:,115),heltab2x8(:,:,119))
  call Hloop_QA_V(ntryL,G2H8(37),ex2(:),G2H4(47),m3h2x4(:,116),heltab2x8(:,:,120))
  call Hloop_QA_V(ntryL,G2H8(38),ex2(:),G2H4(49),m3h2x4(:,117),heltab2x8(:,:,121))
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(33),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),2,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(115),mass4set(:,3),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),8)
  call HG1shiftOLR(G1H8(140),2,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(37),mass4set(:,3),  & 
G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
  call HG1shiftOLR(G1H8(145),14,8)
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(8),m3h2x4(:,118),heltab2x8(:,:,122))
  call Hloop_AQ_V(ntryL,G2H8(45),ex1(:),G2H4(52),m3h2x4(:,119),heltab2x8(:,:,123))
  call Hloop_AQ_V(ntryL,G2H8(46),ex1(:),G2H4(51),m3h2x4(:,120),heltab2x8(:,:,124))
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(34),mass5set(:,1),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(235),G1H4(236),4)
  call HG1shiftOLR(G1H4(232),2,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(115),mass4set(:,3),  & 
G1H4(237),G1H4(238),G1H4(239),G1H4(240),G1H4(241),4)
  call HG1shiftOLR(G1H4(238),2,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(213),mass4set(:,3),  & 
G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(243),18,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(123),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(221),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(226),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(236)])
  call Hloop_VQ_A(ntryL,G1H4(101),ex3(:),G1H2(53),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(53),55,nMB,G2H2(97),n2h2(77))
call HGT_raise_alpha_OLR(G1H4(102),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(54),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_VQ_A(ntryL,G1H4(112),ex3(:),G1H2(59),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(59),55,nMB,G2H2(98),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(113),ex3(:),G1H2(60),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(60),55,nMB,G2H2(99),n2h2(79))
  call Hloop_VA_Q(ntryL,G1H4(114),ex4(:),G1H2(65),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(65),59,nMB,G2H2(100),n2h2(80))
call HGT_raise_alpha_OLR(G1H4(119),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(119),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(119),ex3(:),G1H2(66),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(71),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(71),59,nMB,G2H2(101),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(126),ex4(:),G1H2(72),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(72),59,nMB,G2H2(102),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(131),ex3(:),G1H2(77),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(77),55,nMB,G2H2(103),n2h2(83))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(132),ex4(:),G1H2(78),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_VQ_A(ntryL,G1H4(138),ex3(:),G1H2(83),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(83),55,nMB,G2H2(104),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(143),ex3(:),G1H2(84),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(84),55,nMB,G2H2(105),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(144),ex4(:),G1H2(17),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(17),59,nMB,G2H2(106),n2h2(86))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(148),ex3(:),G1H2(18),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_VA_Q(ntryL,G1H4(82),ex4(:),G1H2(23),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(23),59,nMB,G2H2(107),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(94),ex4(:),G1H2(24),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(24),59,nMB,G2H2(108),n2h2(88))
  call Hloop_QV_A(ntryL,G1H4(106),ex5(:),G1H2(29),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(109),n2h2(89))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(118),ex4(:),G1H2(30),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_QV_A(ntryL,G1H4(5),ex5(:),G1H2(35),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(35),55,nMB,G2H2(110),n2h2(90))
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(36),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(36),55,nMB,G2H2(111),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(41),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(41),59,nMB,G2H2(112),n2h2(92))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(42),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_AV_Q(ntryL,G1H4(17),ex5(:),G1H2(47),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(47),59,nMB,G2H2(113),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(18),ex5(:),G1H2(48),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(48),59,nMB,G2H2(114),n2h2(94))
  call Hloop_QV_A(ntryL,G1H4(22),ex5(:),G1H2(53),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(53),55,nMB,G2H2(115),n2h2(95))
call HGT_raise_alpha_OLR(G1H4(23),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(59),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_QV_A(ntryL,G1H4(47),ex5(:),G1H2(60),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(60),55,nMB,G2H2(116),n2h2(96))
  call Hloop_QV_A(ntryL,G1H4(48),ex5(:),G1H2(65),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(65),55,nMB,G2H2(117),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H4(52),ex5(:),G1H2(71),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(71),59,nMB,G2H2(118),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(54),ex3(:),G1H2(72),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_AV_Q(ntryL,G1H4(64),ex5(:),G1H2(77),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(119),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H4(65),ex5(:),G1H2(83),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(83),59,nMB,G2H2(120),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(66),ex5(:),G1H2(84),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(84),61,0,G2H2(121),n2h2(101))
call HGT_raise_alpha_OLR(G1H4(71),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(71),ex2(:),G1H2(17),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_QV_A(ntryL,G1H4(77),ex5(:),G1H2(23),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(23),61,0,G2H2(122),n2h2(102))
  call Hloop_QV_A(ntryL,G1H4(78),ex5(:),G1H2(24),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(24),61,0,G2H2(123),n2h2(103))
  call Hloop_QV_A(ntryL,G1H4(83),ex5(:),G1H2(29),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(124),n2h2(104))
call HGT_raise_alpha_OLR(G1H4(84),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(35),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(36),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(36),55,nMB,G2H2(125),n2h2(105))
  call Hloop_QV_A(ntryL,G1H4(95),ex5(:),G1H2(41),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(41),55,nMB,G2H2(126),n2h2(106))
  call Hloop_AV_Q(ntryL,G1H4(96),ex5(:),G1H2(47),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(47),62,0,G2H2(127),n2h2(107))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(100),ex1(:),G1H2(48),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_AV_Q(ntryL,G1H4(81),ex5(:),G1H2(53),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(53),62,0,G2H2(128),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H4(93),ex5(:),G1H2(60),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(60),62,0,G2H2(129),n2h2(109))
  call Hloop_AV_Q(ntryL,G1H4(7),ex5(:),G1H2(65),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(65),59,nMB,G2H2(130),n2h2(110))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(36),ex3(:),G1H2(71),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_AV_Q(ntryL,G1H4(34),ex5(:),G1H2(77),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(131),n2h2(111))
  call Hloop_AV_Q(ntryL,G1H4(117),ex5(:),G1H2(83),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(83),59,nMB,G2H2(132),n2h2(112))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(84),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(84),47,nMB,G2H2(133),n2h2(113))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-16,nMB,G2H4(22),n2h4(103))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(134),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_VQ_A(ntryL,G1H4(35),ex3(:),G1H2(23),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(23),47,nMB,G2H2(135),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(141),ex3(:),G1H2(24),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(24),47,nMB,G2H2(136),n2h2(115))
  call Hloop_VA_Q(ntryL,G1H4(103),ex4(:),G1H2(29),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(29),47,nMB,G2H2(137),n2h2(116))
call HGT_OLR(G1H4(115),1,1,4)
call HGT_invQ_OLR(G1H4(115),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(115),-16,nMB,G2H4(25),n2h4(104))
  call Hloop_QV_A(ntryL,G2H4(25),ex5(:),G2H2(138),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(36),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(36),47,nMB,G2H2(139),n2h2(117))
  call Hloop_VA_Q(ntryL,G1H4(15),ex4(:),G1H2(41),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(41),47,nMB,G2H2(140),n2h2(118))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(47),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(47),47,0,G2H2(141),n2h2(119))
call HGT_OLR(G1H4(45),1,1,4)
call HGT_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(45),-16,0,G2H4(28),n2h4(105))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(142),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(51),ex1(:),G1H2(53),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(53),47,0,G2H2(143),n2h2(120))
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(60),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(60),47,0,G2H2(144),n2h2(121))
  call Hloop_VA_Q(ntryL,G1H4(43),ex2(:),G1H2(65),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(65),47,0,G2H2(145),n2h2(122))
call HGT_OLR(G1H4(49),1,1,4)
call HGT_invQ_OLR(G1H4(49),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(49),-16,0,G2H4(31),n2h4(106))
  call Hloop_QV_A(ntryL,G2H4(31),ex5(:),G2H2(146),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_VA_Q(ntryL,G1H4(67),ex2(:),G1H2(77),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(77),47,0,G2H2(147),n2h2(123))
  call Hloop_VA_Q(ntryL,G1H4(68),ex2(:),G1H2(83),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(83),47,0,G2H2(148),n2h2(124))
  call Hloop_VQ_A(ntryL,G1H4(79),ex3(:),G1H2(84),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(84),55,nMB,G2H2(149),n2h2(125))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(23),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_VQ_A(ntryL,G1H4(128),ex3(:),G1H2(24),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(24),55,nMB,G2H2(150),n2h2(126))
  call Hloop_VQ_A(ntryL,G1H4(104),ex3(:),G1H2(29),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(151),n2h2(127))
  call Hloop_VQ_A(ntryL,G1H4(134),ex3(:),G1H2(36),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(36),55,nMB,G2H2(152),n2h2(128))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(110),ex4(:),G1H2(41),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_VQ_A(ntryL,G1H4(146),ex3(:),G1H2(47),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(47),55,nMB,G2H2(153),n2h2(129))
  call Hloop_VQ_A(ntryL,G1H4(122),ex3(:),G1H2(53),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(53),55,nMB,G2H2(154),n2h2(130))
  call Hloop_VA_Q(ntryL,G1H4(127),ex4(:),G1H2(60),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(60),59,nMB,G2H2(155),n2h2(131))
call HGT_raise_alpha_OLR(G1H4(139),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(139),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(139),ex3(:),G1H2(65),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(77),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(156),n2h2(132))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(83),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(83),59,nMB,G2H2(157),n2h2(133))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(84),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(84),59,nMB,G2H2(158),n2h2(134))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(24),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_VA_Q(ntryL,G1H4(29),ex4(:),G1H2(29),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(29),59,nMB,G2H2(159),n2h2(135))
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(36),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(36),59,nMB,G2H2(160),n2h2(136))
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(47),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(47),55,nMB,G2H2(161),n2h2(137))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex4(:),G1H2(53),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_VQ_A(ntryL,G1H4(24),ex3(:),G1H2(60),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(60),55,nMB,G2H2(162),n2h2(138))
  call Hloop_VQ_A(ntryL,G1H4(50),ex3(:),G1H2(77),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(77),55,nMB,G2H2(163),n2h2(139))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(83),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(83),55,nMB,G2H2(164),n2h2(140))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(84),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_VQ_A(ntryL,G1H4(74),ex3(:),G1H2(29),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(165),n2h2(141))
  call Hloop_VQ_A(ntryL,G1H4(75),ex3(:),G1H2(36),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(36),55,nMB,G2H2(166),n2h2(142))
  call Hloop_VA_Q(ntryL,G1H4(85),ex4(:),G1H2(47),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(47),59,nMB,G2H2(167),n2h2(143))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(60),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_VA_Q(ntryL,G1H4(150),ex4(:),G1H2(77),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(168),n2h2(144))
  call Hloop_VA_Q(ntryL,G1H4(151),ex4(:),G1H2(83),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(83),59,nMB,G2H2(169),n2h2(145))
  call Hloop_VA_Q(ntryL,G1H4(152),ex4(:),G1H2(29),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(29),59,nMB,G2H2(170),n2h2(146))
call HGT_raise_alpha_OLR(G1H4(153),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(153),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(153),ex3(:),G1H2(36),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VA_Q(ntryL,G1H4(156),ex4(:),G1H2(47),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(47),59,nMB,G2H2(171),n2h2(147))
  call Hloop_VA_Q(ntryL,G1H4(157),ex4(:),G1H2(77),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(172),n2h2(148))
  call Hloop_QV_A(ntryL,G1H4(97),ex5(:),G1H2(83),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(83),55,nMB,G2H2(173),n2h2(149))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(29),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_QV_A(ntryL,G1H4(109),ex5(:),G1H2(47),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(47),55,nMB,G2H2(174),n2h2(150))
  call Hloop_QV_A(ntryL,G1H4(205),ex5(:),G1H2(77),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(77),55,nMB,G2H2(175),n2h2(151))
call HGT_raise_alpha_OLR(G1H4(161),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(161),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(161),ex4(:),G1H2(83),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_QV_A(ntryL,G1H4(164),ex5(:),G1H2(47),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(47),55,nMB,G2H2(176),n2h2(152))
  call Hloop_AV_Q(ntryL,G1H4(111),ex5(:),G1H2(77),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(177),n2h2(153))
call HGT_raise_alpha_OLR(G1H4(165),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(165),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(165),ex3(:),G1H2(47),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(77),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(178),n2h2(154))
  call Hloop_AV_Q(ntryL,G1H4(210),ex5(:),G1H2(77),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(77),59,nMB,G2H2(179),n2h2(155))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(170),ex3(:),G1H2(77),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AV_Q(ntryL,G1H4(173),ex5(:),G1H2(89),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(89),59,nMB,G2H2(180),n2h2(156))
  call Hloop_QV_A(ntryL,G1H4(123),ex5(:),G1H2(89),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(89),55,nMB,G2H2(181),n2h2(157))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(174),ex4(:),G1H2(89),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(90),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(90),55,nMB,G2H2(182),n2h2(158))
  call Hloop_QV_A(ntryL,G1H4(178),ex5(:),G1H2(90),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(90),55,nMB,G2H2(183),n2h2(159))
  call Hloop_AV_Q(ntryL,G1H4(133),ex5(:),G1H2(90),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(90),59,nMB,G2H2(184),n2h2(160))
call HGT_raise_alpha_OLR(G1H4(135),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(135),ex3(:),G1H2(90),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_AV_Q(ntryL,G1H4(181),ex5(:),G1H2(91),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(91),59,nMB,G2H2(185),n2h2(161))
  call Hloop_AV_Q(ntryL,G1H4(182),ex5(:),G1H2(91),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(91),59,nMB,G2H2(186),n2h2(162))
  call Hloop_VQ_A(ntryL,G1H4(145),ex3(:),G1H2(91),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(187),n2h2(163))
call HGT_OLR(G1H4(147),1,1,4)
call HGT_invQ_OLR(G1H4(147),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(147),-16,nMB,G2H4(34),n2h4(121))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(188),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_VQ_A(ntryL,G1H4(185),ex3(:),G1H2(91),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(189),n2h2(164))
  call Hloop_VQ_A(ntryL,G1H4(186),ex3(:),G1H2(91),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(190),n2h2(165))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(91),m3h4x2(:,5),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(191),n2h2(166))
call HGT_OLR(G1H8(23),1,1,8)
call HGT_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(23),-16,nMB,G2H8(17),n2h8(97))
  call Hloop_QV_A(ntryL,G2H8(17),ex5(:),G2H4(7),m3h2x4(:,121),heltab2x8(:,:,126))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,1),G1H2(91),m3h4x2(:,6),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(192),n2h2(167))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,1),G1H2(91),m3h4x2(:,7),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(193),n2h2(168))
  call Hloop_VA_Q(ntryL,G1H4(187),ex4(:),G1H2(91),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(194),n2h2(169))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(188),-16,nMB,G2H4(38),n2h4(122))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(195),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_VA_Q(ntryL,G1H4(191),ex4(:),G1H2(91),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(196),n2h2(170))
  call Hloop_VA_Q(ntryL,G1H4(192),ex4(:),G1H2(91),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(91),47,nMB,G2H2(197),n2h2(171))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,1),G1H2(91),m3h4x2(:,8),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(198),n2h2(172))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(40),-16,nMB,G2H8(19),n2h8(98))
  call Hloop_AV_Q(ntryL,G2H8(19),ex5(:),G2H4(53),m3h2x4(:,122),heltab2x8(:,:,130))
  call Hloop_QV_A(ntryL,G1H8(48),wf4(:,1),G1H2(91),m3h4x2(:,9),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(199),n2h2(173))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,1),G1H2(91),m3h4x2(:,10),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMB,G2H2(200),n2h2(174))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(159),m3h2x4(:,123),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(159),51,0,G2H4(42),n2h4(123))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(5),-12,0,G2H8(20),n2h8(99))
  call Hloop_AV_Q(ntryL,G2H8(20),wf4(:,12),G2H2(201),m3h4x2(:,11),heltab2x8(:,:,134))
  call Hloop_QV_A(ntryL,G1H8(11),ex5(:),G1H4(160),m3h2x4(:,124),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(160),51,0,G2H4(50),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(12),ex5(:),G1H4(168),m3h2x4(:,125),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(168),51,0,G2H4(46),n2h4(125))
  call Hloop_VQ_A(ntryL,G1H4(193),ex1(:),G1H2(91),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(202),n2h2(175))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-16,0,G2H4(54),n2h4(126))
  call Hloop_AV_Q(ntryL,G2H4(54),ex5(:),G2H2(203),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_VQ_A(ntryL,G1H4(197),ex1(:),G1H2(91),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(204),n2h2(176))
  call Hloop_VQ_A(ntryL,G1H4(198),ex1(:),G1H2(91),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(205),n2h2(177))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(169),m3h2x4(:,126),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(169),51,0,G2H4(1),n2h4(127))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-12,0,G2H8(21),n2h8(100))
  call Hloop_QV_A(ntryL,G2H8(21),wf4(:,12),G2H2(206),m3h4x2(:,12),heltab2x8(:,:,138))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(219),m3h2x4(:,127),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(219),51,0,G2H4(2),n2h4(128))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(220),m3h2x4(:,128),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(220),51,0,G2H4(5),n2h4(129))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,12),G1H2(91),m3h4x2(:,13),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(207),n2h2(178))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-16,0,G2H8(23),n2h8(101))
  call Hloop_QV_A(ntryL,G2H8(23),ex5(:),G2H4(6),m3h2x4(:,129),heltab2x8(:,:,142))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,12),G1H2(91),m3h4x2(:,14),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(208),n2h2(179))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,12),G1H2(91),m3h4x2(:,15),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(209),n2h2(180))
  call Hloop_VA_Q(ntryL,G1H4(199),ex2(:),G1H2(91),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(210),n2h2(181))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-16,0,G2H4(37),n2h4(130))
  call Hloop_QV_A(ntryL,G2H4(37),ex5(:),G2H2(211),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_VA_Q(ntryL,G1H4(203),ex2(:),G1H2(91),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(212),n2h2(182))
  call Hloop_VA_Q(ntryL,G1H4(204),ex2(:),G1H2(91),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(213),n2h2(183))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,12),G1H2(91),m3h4x2(:,16),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(214),n2h2(184))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,0,G2H8(24),n2h8(102))
  call Hloop_AV_Q(ntryL,G2H8(24),ex5(:),G2H4(11),m3h2x4(:,130),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,12),G1H2(91),m3h4x2(:,17),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(215),n2h2(185))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,12),G1H2(91),m3h4x2(:,18),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(216),n2h2(186))
  call Hloop_VA_Q(ntryL,G1H8(3),ex2(:),G1H4(235),m3h2x4(:,131),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(235),46,0,G2H4(40),n2h4(131))
call HGT_raise_alpha_OLR(G1H8(28),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(28),wf4(:,13),G1H2(91),m3h4x2(:,19),heltab2x8(:,:,150))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(236),m3h2x4(:,132),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(236),46,0,G2H4(14),n2h4(132))
  call Hloop_VA_Q(ntryL,G1H8(32),ex2(:),G1H4(101),m3h2x4(:,133),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(101),46,0,G2H4(41),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(102),m3h2x4(:,134),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(102),46,0,G2H4(17),n2h4(134))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(38),wf4(:,13),G1H2(92),m3h4x2(:,20),heltab2x8(:,:,154))
  call Hloop_VA_Q(ntryL,G1H8(55),ex2(:),G1H4(112),m3h2x4(:,135),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(112),46,0,G2H4(44),n2h4(135))
  call Hloop_VA_Q(ntryL,G1H8(56),ex2(:),G1H4(113),m3h2x4(:,136),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(113),46,0,G2H4(20),n2h4(136))
  call Hloop_VQ_A(ntryL,G1H8(57),ex1(:),G1H4(114),m3h2x4(:,137),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(114),45,0,G2H4(55),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(58),wf4(:,18),G1H2(93),m3h4x2(:,21),heltab2x8(:,:,158))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(119),m3h2x4(:,138),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(119),45,0,G2H4(57),n2h4(138))
  call Hloop_VQ_A(ntryL,G1H8(62),ex1(:),G1H4(125),m3h2x4(:,139),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(125),45,0,G2H4(59),n2h4(139))
  call Hloop_VQ_A(ntryL,G1H8(63),ex1(:),G1H4(126),m3h2x4(:,140),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(126),45,0,G2H4(61),n2h4(140))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(64),wf4(:,18),G1H2(94),m3h4x2(:,22),heltab2x8(:,:,162))
  call Hloop_VQ_A(ntryL,G1H8(67),ex1(:),G1H4(131),m3h2x4(:,141),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(131),45,0,G2H4(24),n2h4(141))
  call Hloop_VQ_A(ntryL,G1H8(68),ex1(:),G1H4(132),m3h2x4(:,142),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(132),45,0,G2H4(26),n2h4(142))
  call Hloop_VA_Q(ntryL,G1H8(69),ex4(:),G1H4(138),m3h2x4(:,143),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(138),43,nMB,G2H4(9),n2h4(143))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(70),wf4(:,4),G1H2(95),m3h4x2(:,23),heltab2x8(:,:,166))
  call Hloop_VA_Q(ntryL,G1H8(73),ex4(:),G1H4(143),m3h2x4(:,144),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(143),43,nMB,G2H4(12),n2h4(144))
  call Hloop_VA_Q(ntryL,G1H8(74),ex4(:),G1H4(144),m3h2x4(:,145),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(144),43,nMB,G2H4(15),n2h4(145))
  call Hloop_VA_Q(ntryL,G1H8(75),ex4(:),G1H4(148),m3h2x4(:,146),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(148),43,nMB,G2H4(18),n2h4(146))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(76),wf4(:,4),G1H2(96),m3h4x2(:,24),heltab2x8(:,:,170))
  call Hloop_VA_Q(ntryL,G1H8(79),ex4(:),G1H4(82),m3h2x4(:,147),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(82),43,nMB,G2H4(27),n2h4(147))
  call Hloop_VA_Q(ntryL,G1H8(80),ex4(:),G1H4(94),m3h2x4(:,148),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(94),43,nMB,G2H4(29),n2h4(148))
  call Hloop_VQ_A(ntryL,G1H8(81),wf4(:,4),G1H2(97),m3h4x2(:,25),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(217),n2h2(187))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex4(:),G1H4(106),m3h2x4(:,149),heltab2x8(:,:,174))
  call Hloop_VQ_A(ntryL,G1H8(85),wf4(:,4),G1H2(97),m3h4x2(:,26),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(218),n2h2(188))
  call Hloop_VQ_A(ntryL,G1H8(86),wf4(:,4),G1H2(97),m3h4x2(:,27),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(219),n2h2(189))
  call Hloop_VQ_A(ntryL,G1H8(87),wf4(:,4),G1H2(97),m3h4x2(:,28),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(220),n2h2(190))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(88),ex4(:),G1H4(118),m3h2x4(:,150),heltab2x8(:,:,178))
  call Hloop_VQ_A(ntryL,G1H8(91),wf4(:,4),G1H2(97),m3h4x2(:,29),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(221),n2h2(191))
  call Hloop_VQ_A(ntryL,G1H8(92),wf4(:,4),G1H2(97),m3h4x2(:,30),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(222),n2h2(192))
  call Hloop_VQ_A(ntryL,G1H8(93),ex3(:),G1H4(5),m3h2x4(:,151),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMB,G2H4(30),n2h4(149))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(94),wf4(:,9),G1H2(97),m3h4x2(:,31),heltab2x8(:,:,182))
  call Hloop_VQ_A(ntryL,G1H8(97),ex3(:),G1H4(6),m3h2x4(:,152),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(6),39,nMB,G2H4(32),n2h4(150))
  call Hloop_VQ_A(ntryL,G1H8(98),ex3(:),G1H4(10),m3h2x4(:,153),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(10),39,nMB,G2H4(33),n2h4(151))
  call Hloop_VQ_A(ntryL,G1H8(99),ex3(:),G1H4(11),m3h2x4(:,154),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(11),39,nMB,G2H4(36),n2h4(152))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(100),wf4(:,9),G1H2(98),m3h4x2(:,32),heltab2x8(:,:,186))
  call Hloop_VQ_A(ntryL,G1H8(103),ex3(:),G1H4(17),m3h2x4(:,155),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(17),39,nMB,G2H4(45),n2h4(153))
  call Hloop_VQ_A(ntryL,G1H8(104),ex3(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(18),39,nMB,G2H4(48),n2h4(154))
  call Hloop_VA_Q(ntryL,G1H8(105),wf4(:,9),G1H2(99),m3h4x2(:,33),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(223),n2h2(193))
call HGT_raise_alpha_OLR(G1H8(106),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(106),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(106),ex3(:),G1H4(22),m3h2x4(:,157),heltab2x8(:,:,190))
  call Hloop_VA_Q(ntryL,G1H8(109),wf4(:,9),G1H2(99),m3h4x2(:,34),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(224),n2h2(194))
  call Hloop_VA_Q(ntryL,G1H8(110),wf4(:,9),G1H2(99),m3h4x2(:,35),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(225),n2h2(195))
  call Hloop_VA_Q(ntryL,G1H8(111),wf4(:,9),G1H2(99),m3h4x2(:,36),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(226),n2h2(196))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(112),ex3(:),G1H4(23),m3h2x4(:,158),heltab2x8(:,:,194))
  call Hloop_VA_Q(ntryL,G1H8(115),wf4(:,9),G1H2(99),m3h4x2(:,37),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(227),n2h2(197))
  call Hloop_VA_Q(ntryL,G1H8(116),wf4(:,9),G1H2(99),m3h4x2(:,38),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(99),59,nMB,G2H2(228),n2h2(198))
call HGT_raise_alpha_OLR(G1H4(206),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(206),ex4(:),G1H2(99),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_QV_A(ntryL,G1H4(209),ex5(:),G1H2(100),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(100),55,nMB,G2H2(229),n2h2(199))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(211),ex3(:),G1H2(100),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_AV_Q(ntryL,G1H4(214),ex5(:),G1H2(101),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(101),59,nMB,G2H2(230),n2h2(200))
  call Hloop_QV_A(ntryL,G1H8(117),wf4(:,1),G1H2(101),m3h4x2(:,39),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(231),n2h2(201))
call HGT_raise_alpha_OLR(G1H8(118),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(118),ex4(:),G1H4(47),m3h2x4(:,159),heltab2x8(:,:,198))
  call Hloop_QV_A(ntryL,G1H8(123),wf4(:,1),G1H2(101),m3h4x2(:,40),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(232),n2h2(202))
  call Hloop_QV_A(ntryL,G1H8(128),wf4(:,1),G1H2(101),m3h4x2(:,41),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(233),n2h2(203))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(124),ex4(:),G1H4(48),m3h2x4(:,160),heltab2x8(:,:,201))
  call Hloop_QV_A(ntryL,G1H8(127),wf4(:,1),G1H2(101),m3h4x2(:,42),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(234),n2h2(204))
call HGT_raise_alpha_OLR(G1H8(129),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(129),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(129),ex4(:),G1H4(52),m3h2x4(:,161),heltab2x8(:,:,203))
  call Hloop_QV_A(ntryL,G1H8(132),wf4(:,1),G1H2(101),m3h4x2(:,43),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(235),n2h2(205))
  call Hloop_QV_A(ntryL,G1H4(215),ex5(:),G1H2(101),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(101),55,nMB,G2H2(236),n2h2(206))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(216),ex4(:),G1H2(101),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(102),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(102),55,nMB,G2H2(237),n2h2(207))
  call Hloop_QV_A(ntryL,G1H4(226),ex5(:),G1H2(102),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(102),55,nMB,G2H2(238),n2h2(208))
call HGT_raise_alpha_OLR(G1H4(222),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(222),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(222),ex4(:),G1H2(102),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(103),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(103),55,nMB,G2H2(239),n2h2(209))
call HGT_raise_alpha_OLR(G1H4(227),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(227),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(227),ex4(:),G1H2(103),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_QV_A(ntryL,G1H4(230),ex5(:),G1H2(104),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(104),55,nMB,G2H2(240),n2h2(210))
  call Hloop_QV_A(ntryL,G1H8(133),wf4(:,12),G1H2(104),m3h4x2(:,44),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(104),61,0,G2H2(241),n2h2(211))



end subroutine vamp_1

end module ol_vamp_1_ppajjj_uuxbbxag_1_/**/REALKIND
