
module ol_vamp_4_ppajj_ew_uuxbbxa_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_4(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_uuxbbxa_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_uuxbbxa_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_uuxbbxa_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_uuxbbxa_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(69)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[20,11],[nMW,nMT],2,2,wf4(:,3),wf8(:,52))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,182),heltab2x32(:,:,801))
  Gcoeff(:)%j = (c(188)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[28,3],[nME,nME],2,2,wf8(:,67),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,95),heltab2x32(:,:,802))
  call Hloop_Q_A(ntryL,G0H4(29),28,nME,G1H4(13),n2h4(247))
  Gcoeff(:)%j = (c(198)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[28,3],[nMM,nMM],2,2,wf8(:,67),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,96),heltab2x32(:,:,803))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(77),n2h4(248))
  Gcoeff(:)%j = (c(193)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[28,3],[nML,nML],2,2,wf8(:,67),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,97),heltab2x32(:,:,804))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(120),n2h4(249))
  Gcoeff(:)%j = (-(c(203)*M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[28,3],[nMT,nMT],2,2,wf8(:,67),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,98),heltab2x32(:,:,805))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(67),n2h4(250))
  Gcoeff(:)%j = (c(184)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[28,3],[nMB,nMB],2,2,wf8(:,67),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,99),heltab2x32(:,:,806))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(68),n2h4(251))
  Gcoeff(:)%j = (-(c(188)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[28,3],[nME,nME],2,2,wf8(:,49),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,100),heltab2x32(:,:,807))
  call Hloop_Q_A(ntryL,G0H4(29),28,nME,G1H4(69),n2h4(252))
  Gcoeff(:)%j = (-(c(198)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[28,3],[nMM,nMM],2,2,wf8(:,49),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,101),heltab2x32(:,:,808))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(73),n2h4(253))
  Gcoeff(:)%j = (-(c(193)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[28,3],[nML,nML],2,2,wf8(:,49),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,102),heltab2x32(:,:,809))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(74),n2h4(254))
  Gcoeff(:)%j = (-(c(203)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[28,3],[nMT,nMT],2,2,wf8(:,49),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,103),heltab2x32(:,:,810))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(90),n2h4(255))
  Gcoeff(:)%j = (-(c(184)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[28,3],[nMB,nMB],2,2,wf8(:,49),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,104),heltab2x32(:,:,811))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(91),n2h4(256))
  Gcoeff(:)%j = (-(c(189)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[28,3],[nME,nME],2,2,wf8(:,67),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,105),heltab2x32(:,:,812))
  call Hloop_Q_A(ntryL,G0H4(29),28,nME,G1H4(92),n2h4(257))
  Gcoeff(:)%j = (-(c(199)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[28,3],[nMM,nMM],2,2,wf8(:,67),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,106),heltab2x32(:,:,813))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(116),n2h4(258))
  Gcoeff(:)%j = (-(c(194)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[28,3],[nML,nML],2,2,wf8(:,67),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,107),heltab2x32(:,:,814))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(117),n2h4(259))
  Gcoeff(:)%j = (-(c(205)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[28,3],[nMT,nMT],2,2,wf8(:,67),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,108),heltab2x32(:,:,815))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(118),n2h4(260))
  Gcoeff(:)%j = (-(c(186)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[28,3],[nMB,nMB],2,2,wf8(:,67),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,67),G0H4(29),ngH,m3h8x4(:,109),heltab2x32(:,:,816))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(21),n2h4(261))
  Gcoeff(:)%j = (c(189)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[28,3],[nME,nME],2,2,wf8(:,49),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,110),heltab2x32(:,:,817))
  call Hloop_Q_A(ntryL,G0H4(29),28,nME,G1H4(22),n2h4(262))
  Gcoeff(:)%j = (c(199)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[28,3],[nMM,nMM],2,2,wf8(:,49),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,111),heltab2x32(:,:,818))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(65),n2h4(263))
  Gcoeff(:)%j = (c(194)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[28,3],[nML,nML],2,2,wf8(:,49),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,112),heltab2x32(:,:,819))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(79),n2h4(264))
  Gcoeff(:)%j = (-(c(205)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[28,3],[nMT,nMT],2,2,wf8(:,49),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,113),heltab2x32(:,:,820))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(80),n2h4(265))
  Gcoeff(:)%j = (c(186)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[28,3],[nMB,nMB],2,2,wf8(:,49),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),ngX,m3h8x4(:,114),heltab2x32(:,:,821))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(97),n2h4(266))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(29),m3h8x4(:,115),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(145)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(30),m3h8x4(:,116),heltab2x32(:,:,823))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[28,3],[nMH,nMZ],2,2,wf8(:,49),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,49),G0H4(31),m3h8x4(:,117),heltab2x32(:,:,824))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(32),m3h8x4(:,118),heltab2x32(:,:,825))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(33),m3h8x4(:,119),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,49),G0H4(34),m3h8x4(:,120),heltab2x32(:,:,827))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,49),G0H4(35),m3h8x4(:,121),heltab2x32(:,:,828))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(36),m3h8x4(:,122),heltab2x32(:,:,829))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,67),G0H4(37),m3h8x4(:,123),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,49),G0H4(38),m3h8x4(:,124),heltab2x32(:,:,831))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,49),G0H4(39),m3h8x4(:,125),heltab2x32(:,:,832))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,67),G0H4(40),m3h8x4(:,126),heltab2x32(:,:,833))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,67),G0H4(41),m3h8x4(:,127),heltab2x32(:,:,834))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,67),28,G1H4(30),m3h8x4(:,128),heltab2x32(:,:,835))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,67),28,G1H4(42),m3h8x4(:,129),heltab2x32(:,:,836))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,49),28,G1H4(37),m3h8x4(:,130),heltab2x32(:,:,837))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,49),28,G1H4(31),m3h8x4(:,131),heltab2x32(:,:,838))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,67),28,G1H4(36),m3h8x4(:,132),heltab2x32(:,:,839))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[28,3],[nMW,nMW],2,2,wf8(:,67),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,67),28,G1H4(41),m3h8x4(:,133),heltab2x32(:,:,840))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[28,3],[nMH,nMZ],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,49),28,G1H4(46),m3h8x4(:,134),heltab2x32(:,:,841))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,49),28,G1H4(52),m3h8x4(:,135),heltab2x32(:,:,842))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[28,3],[nMW,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,49),28,G1H4(47),m3h8x4(:,136),heltab2x32(:,:,843))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[28,3],[nME,nME],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,137),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G0H4(42),28,nME,G1H4(51),n2h4(267))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[28,3],[nMM,nMM],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,138),heltab2x32(:,:,845))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMM,G1H4(56),n2h4(268))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[28,3],[nML,nML],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,139),heltab2x32(:,:,846))
  call Hloop_Q_A(ntryL,G0H4(42),28,nML,G1H4(4),n2h4(269))
  Gcoeff(:)%j = (-(c(166)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[28,3],[0,0],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,140),heltab2x32(:,:,847))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(8),n2h4(270))
  Gcoeff(:)%j = (-(c(164)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[28,3],[nMT,nMT],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,141),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMT,G1H4(2),n2h4(271))
  Gcoeff(:)%j = (-(c(163)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[28,3],[0,0],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,142),heltab2x32(:,:,849))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(14),n2h4(272))
  Gcoeff(:)%j = (-(c(162)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[28,3],[nMB,nMB],2,2,wf8(:,50),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,143),heltab2x32(:,:,850))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMB,G1H4(19),n2h4(273))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[28,3],[nME,nME],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,144),heltab2x32(:,:,851))
  call Hloop_Q_A(ntryL,G0H4(42),28,nME,G1H4(1),n2h4(274))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[28,3],[nMM,nMM],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,145),heltab2x32(:,:,852))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMM,G1H4(66),n2h4(275))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[28,3],[nML,nML],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,146),heltab2x32(:,:,853))
  call Hloop_Q_A(ntryL,G0H4(42),28,nML,G1H4(59),n2h4(276))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[28,3],[0,0],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZu,m3h8x4(:,147),heltab2x32(:,:,854))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(7),n2h4(277))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[28,3],[nMT,nMT],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZu,m3h8x4(:,148),heltab2x32(:,:,855))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMT,G1H4(58),n2h4(278))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[28,3],[0,0],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZd,m3h8x4(:,149),heltab2x32(:,:,856))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(70),n2h4(279))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[28,3],[nMB,nMB],2,2,wf8(:,51),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZd,m3h8x4(:,150),heltab2x32(:,:,857))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMB,G1H4(76),n2h4(280))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[28,3],[nME,nME],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,151),heltab2x32(:,:,858))
  call Hloop_Q_A(ntryL,G0H4(42),28,nME,G1H4(71),n2h4(281))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[28,3],[nMM,nMM],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,152),heltab2x32(:,:,859))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMM,G1H4(75),n2h4(282))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[28,3],[nML,nML],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,153),heltab2x32(:,:,860))
  call Hloop_Q_A(ntryL,G0H4(42),28,nML,G1H4(81),n2h4(283))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[28,3],[0,0],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,154),heltab2x32(:,:,861))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(83),n2h4(284))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[28,3],[nMT,nMT],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,155),heltab2x32(:,:,862))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMT,G1H4(84),n2h4(285))
  Gcoeff(:)%j = (c(168)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[28,3],[0,0],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,156),heltab2x32(:,:,863))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(88),n2h4(286))
  Gcoeff(:)%j = (c(165)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[28,3],[nMB,nMB],2,2,wf8(:,50),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,157),heltab2x32(:,:,864))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMB,G1H4(89),n2h4(287))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[28,3],[0,0],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZn,m3h8x4(:,158),heltab2x32(:,:,865))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(113),n2h4(288))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[28,3],[nME,nME],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,159),heltab2x32(:,:,866))
  call Hloop_Q_A(ntryL,G0H4(42),28,nME,G1H4(99),n2h4(289))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[28,3],[nMM,nMM],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,160),heltab2x32(:,:,867))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMM,G1H4(102),n2h4(290))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[28,3],[nML,nML],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZl,m3h8x4(:,161),heltab2x32(:,:,868))
  call Hloop_Q_A(ntryL,G0H4(42),28,nML,G1H4(86),n2h4(291))
  Gcoeff(:)%j = (c(180)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[28,3],[0,0],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZu,m3h8x4(:,162),heltab2x32(:,:,869))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(10),n2h4(292))
  Gcoeff(:)%j = (c(176)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[28,3],[nMT,nMT],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZu,m3h8x4(:,163),heltab2x32(:,:,870))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMT,G1H4(104),n2h4(293))
  Gcoeff(:)%j = (c(180)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[28,3],[0,0],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZd,m3h8x4(:,164),heltab2x32(:,:,871))
  call Hloop_Q_A(ntryL,G0H4(42),28,0,G1H4(95),n2h4(294))
  Gcoeff(:)%j = (c(176)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[28,3],[nMB,nMB],2,2,wf8(:,51),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,51),G0H4(42),ngZd,m3h8x4(:,165),heltab2x32(:,:,872))
  call Hloop_Q_A(ntryL,G0H4(42),28,nMB,G1H4(98),n2h4(295))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(82),m3h8x4(:,166),heltab2x32(:,:,873))
  Gcoeff(:)%j = (c(150)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(53),m3h8x4(:,167),heltab2x32(:,:,874))
  Gcoeff(:)%j = (-(c(149)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(96),m3h8x4(:,168),heltab2x32(:,:,875))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[28,3],[nMH,nMZ],2,2,wf8(:,51),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(111),m3h8x4(:,169),heltab2x32(:,:,876))
  Gcoeff(:)%j = (-(c(157)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(112),m3h8x4(:,170),heltab2x32(:,:,877))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(3),m3h8x4(:,171),heltab2x32(:,:,878))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(16),m3h8x4(:,172),heltab2x32(:,:,879))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(114),m3h8x4(:,173),heltab2x32(:,:,880))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(103),m3h8x4(:,174),heltab2x32(:,:,881))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(108),m3h8x4(:,175),heltab2x32(:,:,882))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(115),m3h8x4(:,176),heltab2x32(:,:,883))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(54),m3h8x4(:,177),heltab2x32(:,:,884))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(63),m3h8x4(:,178),heltab2x32(:,:,885))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(39),m3h8x4(:,179),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(18),m3h8x4(:,180),heltab2x32(:,:,887))
  Gcoeff(:)%j = (c(118)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,50),28,G1H4(15),m3h8x4(:,181),heltab2x32(:,:,888))
  Gcoeff(:)%j = (-(c(66)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,51),28,G1H4(93),m3h8x4(:,182),heltab2x32(:,:,889))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,50),G0H4(42),m3h8x4(:,183),heltab2x32(:,:,890))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,50),G0H4(43),m3h8x4(:,184),heltab2x32(:,:,891))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,51),G0H4(44),m3h8x4(:,185),heltab2x32(:,:,892))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,51),G0H4(45),m3h8x4(:,186),heltab2x32(:,:,893))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,50),G0H4(46),m3h8x4(:,187),heltab2x32(:,:,894))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[28,3],[nMW,nMW],2,2,wf8(:,50),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,50),G0H4(47),m3h8x4(:,188),heltab2x32(:,:,895))
  Gcoeff(:)%j = (c(112)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[28,3],[nMH,nMZ],2,2,wf8(:,51),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,51),G0H4(48),m3h8x4(:,189),heltab2x32(:,:,896))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,51),G0H4(49),m3h8x4(:,190),heltab2x32(:,:,897))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[28,3],[nMW,nMW],2,2,wf8(:,51),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,51),G0H4(50),m3h8x4(:,191),heltab2x32(:,:,898))
  Gcoeff(:)%j = (-(c(98)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[24,7],[nMB,nMH],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngH,m3h4x8(:,183),heltab2x32(:,:,899))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(48),n2h8(129))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(18),ngX,m3h4x8(:,184),heltab2x32(:,:,900))
  call Hloop_A_Q(ntryL,G0H8(18),24,nMB,G1H8(46),n2h8(130))
  Gcoeff(:)%j = (c(83)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),ngPbt,m3h4x8(:,185),heltab2x32(:,:,901))
  call Hloop_A_Q(ntryL,G0H8(19),24,nMT,G1H8(44),n2h8(131))
  Gcoeff(:)%j = (c(100)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[24,7],[nMB,nMH],2,2,wf4(:,6),wf8(:,58))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(31),ngH,m3h4x8(:,186),heltab2x32(:,:,902))
  call Hloop_A_Q(ntryL,G0H8(31),24,nMB,G1H8(56),n2h8(132))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,58))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngX,m3h4x8(:,187),heltab2x32(:,:,903))
  call Hloop_A_Q(ntryL,G0H8(27),24,nMB,G1H8(57),n2h8(133))
  Gcoeff(:)%j = (-(c(87)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,58))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngPbt,m3h4x8(:,188),heltab2x32(:,:,904))
  call Hloop_A_Q(ntryL,G0H8(28),24,nMT,G1H8(58),n2h8(134))
  Gcoeff(:)%j = (c(103)*M(1,:)%j-c(102)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[24,7],[nMB,nMH],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngH,m3h4x8(:,189),heltab2x32(:,:,905))
  call Hloop_A_Q(ntryL,G0H8(29),24,nMB,G1H8(53),n2h8(135))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)+c(102)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(5),ngX,m3h4x8(:,190),heltab2x32(:,:,906))
  call Hloop_A_Q(ntryL,G0H8(5),24,nMB,G1H8(54),n2h8(136))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)+c(92)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,57))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(1),ngPbt,m3h4x8(:,191),heltab2x32(:,:,907))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(55),n2h8(137))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,57))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(2),m3h4x8(:,192),heltab2x32(:,:,908))
  call Hloop_A_Q(ntryL,G0H8(2),24,nMB,G1H8(24),n2h8(138))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,57))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(20),ngZd,m3h4x8(:,193),heltab2x32(:,:,909))
  call Hloop_A_Q(ntryL,G0H8(20),24,nMB,G1H8(26),n2h8(139))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,57))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),m3h4x8(:,194),heltab2x32(:,:,910))
  call Hloop_A_Q(ntryL,G0H8(47),24,nMT,G1H8(21),n2h8(140))
  Gcoeff(:)%j = (c(17)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,57))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(17),m3h4x8(:,195),heltab2x32(:,:,911))
  call Hloop_A_Q(ntryL,G0H8(17),24,nMB,G1H8(13),n2h8(141))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,58))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(7),m3h4x8(:,196),heltab2x32(:,:,912))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMB,G1H8(17),n2h8(142))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,58))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngZd,m3h4x8(:,197),heltab2x32(:,:,913))
  call Hloop_A_Q(ntryL,G0H8(4),24,nMB,G1H8(12),n2h8(143))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,58))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,198),heltab2x32(:,:,914))
  call Hloop_A_Q(ntryL,G0H8(6),24,nMT,G1H8(8),n2h8(144))
  Gcoeff(:)%j = (-(c(25)*M(3,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,58))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,199),heltab2x32(:,:,915))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMB,G1H8(16),n2h8(145))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,57))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(35),m3h4x8(:,200),heltab2x32(:,:,916))
  call Hloop_A_Q(ntryL,G0H8(35),24,nMB,G1H8(51),n2h8(146))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,57))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(30),ngZd,m3h4x8(:,201),heltab2x32(:,:,917))
  call Hloop_A_Q(ntryL,G0H8(30),24,nMB,G1H8(52),n2h8(147))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(69)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,57))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,202),heltab2x32(:,:,918))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMT,G1H8(22),n2h8(148))
  Gcoeff(:)%j = (c(188)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[28,3],[nME,nME],2,2,wf8(:,68),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,192),heltab2x32(:,:,919))
  call Hloop_Q_A(ntryL,G0H4(51),28,nME,G1H4(40),n2h4(296))
  Gcoeff(:)%j = (c(198)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[28,3],[nMM,nMM],2,2,wf8(:,68),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,193),heltab2x32(:,:,920))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMM,G1H4(27),n2h4(297))
  Gcoeff(:)%j = (c(193)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[28,3],[nML,nML],2,2,wf8(:,68),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,194),heltab2x32(:,:,921))
  call Hloop_Q_A(ntryL,G0H4(51),28,nML,G1H4(33),n2h4(298))
  Gcoeff(:)%j = (-(c(203)*M(2,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[28,3],[nMT,nMT],2,2,wf8(:,68),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,195),heltab2x32(:,:,922))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMT,G1H4(9),n2h4(299))
  Gcoeff(:)%j = (c(184)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[28,3],[nMB,nMB],2,2,wf8(:,68),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,196),heltab2x32(:,:,923))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMB,G1H4(34),n2h4(300))
  Gcoeff(:)%j = (-(c(188)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[28,3],[nME,nME],2,2,wf8(:,54),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,197),heltab2x32(:,:,924))
  call Hloop_Q_A(ntryL,G0H4(51),28,nME,G1H4(28),n2h4(301))
  Gcoeff(:)%j = (-(c(198)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[28,3],[nMM,nMM],2,2,wf8(:,54),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,198),heltab2x32(:,:,925))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMM,G1H4(107),n2h4(302))
  Gcoeff(:)%j = (-(c(193)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[28,3],[nML,nML],2,2,wf8(:,54),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,199),heltab2x32(:,:,926))
  call Hloop_Q_A(ntryL,G0H4(51),28,nML,G1H4(119),n2h4(303))
  Gcoeff(:)%j = (-(c(203)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[28,3],[nMT,nMT],2,2,wf8(:,54),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,200),heltab2x32(:,:,927))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMT,G1H4(49),n2h4(304))
  Gcoeff(:)%j = (-(c(184)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[28,3],[nMB,nMB],2,2,wf8(:,54),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,201),heltab2x32(:,:,928))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMB,G1H4(72),n2h4(305))
  Gcoeff(:)%j = (-(c(189)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[28,3],[nME,nME],2,2,wf8(:,68),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,202),heltab2x32(:,:,929))
  call Hloop_Q_A(ntryL,G0H4(51),28,nME,G1H4(64),n2h4(306))
  Gcoeff(:)%j = (-(c(199)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[28,3],[nMM,nMM],2,2,wf8(:,68),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,203),heltab2x32(:,:,930))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMM,G1H4(60),n2h4(307))
  Gcoeff(:)%j = (-(c(194)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[28,3],[nML,nML],2,2,wf8(:,68),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,204),heltab2x32(:,:,931))
  call Hloop_Q_A(ntryL,G0H4(51),28,nML,G1H4(106),n2h4(308))
  Gcoeff(:)%j = (-(c(205)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[28,3],[nMT,nMT],2,2,wf8(:,68),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,205),heltab2x32(:,:,932))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMT,G1H4(29),n2h4(309))
  Gcoeff(:)%j = (-(c(186)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[28,3],[nMB,nMB],2,2,wf8(:,68),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,68),G0H4(51),ngH,m3h8x4(:,206),heltab2x32(:,:,933))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMB,G1H4(44),n2h4(310))
  Gcoeff(:)%j = (c(189)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[28,3],[nME,nME],2,2,wf8(:,54),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,207),heltab2x32(:,:,934))
  call Hloop_Q_A(ntryL,G0H4(51),28,nME,G1H4(23),n2h4(311))
  Gcoeff(:)%j = (c(199)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[28,3],[nMM,nMM],2,2,wf8(:,54),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,208),heltab2x32(:,:,935))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMM,G1H4(24),n2h4(312))
  Gcoeff(:)%j = (c(194)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[28,3],[nML,nML],2,2,wf8(:,54),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,209),heltab2x32(:,:,936))
  call Hloop_Q_A(ntryL,G0H4(51),28,nML,G1H4(25),n2h4(313))
  Gcoeff(:)%j = (-(c(205)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[28,3],[nMT,nMT],2,2,wf8(:,54),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,210),heltab2x32(:,:,937))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMT,G1H4(26),n2h4(314))
  Gcoeff(:)%j = (c(186)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[28,3],[nMB,nMB],2,2,wf8(:,54),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,54),G0H4(51),ngX,m3h8x4(:,211),heltab2x32(:,:,938))
  call Hloop_Q_A(ntryL,G0H4(51),28,nMB,G1H4(45),n2h4(315))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(51),m3h8x4(:,212),heltab2x32(:,:,939))
  Gcoeff(:)%j = (-(c(145)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(52),m3h8x4(:,213),heltab2x32(:,:,940))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[28,3],[nMH,nMZ],2,2,wf8(:,54),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,54),G0H4(53),m3h8x4(:,214),heltab2x32(:,:,941))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(54),m3h8x4(:,215),heltab2x32(:,:,942))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(55),m3h8x4(:,216),heltab2x32(:,:,943))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,54),G0H4(56),m3h8x4(:,217),heltab2x32(:,:,944))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,54),G0H4(57),m3h8x4(:,218),heltab2x32(:,:,945))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(58),m3h8x4(:,219),heltab2x32(:,:,946))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,68),G0H4(59),m3h8x4(:,220),heltab2x32(:,:,947))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,54),G0H4(60),m3h8x4(:,221),heltab2x32(:,:,948))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,54),G0H4(61),m3h8x4(:,222),heltab2x32(:,:,949))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,68),G0H4(62),m3h8x4(:,223),heltab2x32(:,:,950))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,68),G0H4(63),m3h8x4(:,224),heltab2x32(:,:,951))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,68),28,G1H4(48),m3h8x4(:,225),heltab2x32(:,:,952))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,68),28,G1H4(87),m3h8x4(:,226),heltab2x32(:,:,953))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,54),28,G1H4(62),m3h8x4(:,227),heltab2x32(:,:,954))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,54),28,G1H4(61),m3h8x4(:,228),heltab2x32(:,:,955))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,68),28,G1H4(78),m3h8x4(:,229),heltab2x32(:,:,956))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[28,3],[nMW,nMW],2,2,wf8(:,68),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,68),28,G1H4(11),m3h8x4(:,230),heltab2x32(:,:,957))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[28,3],[nMH,nMZ],2,2,wf8(:,54),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,54),28,G1H4(12),m3h8x4(:,231),heltab2x32(:,:,958))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,54),28,G1H4(50),m3h8x4(:,232),heltab2x32(:,:,959))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[28,3],[nMW,nMW],2,2,wf8(:,54),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,54),28,G1H4(85),m3h8x4(:,233),heltab2x32(:,:,960))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[28,3],[nME,nME],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,234),heltab2x32(:,:,961))
  call Hloop_Q_A(ntryL,G0H4(64),28,nME,G1H4(17),n2h4(316))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[28,3],[nMM,nMM],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,235),heltab2x32(:,:,962))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMM,G1H4(101),n2h4(317))
  Gcoeff(:)%j = (-(c(167)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[28,3],[nML,nML],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,236),heltab2x32(:,:,963))
  call Hloop_Q_A(ntryL,G0H4(64),28,nML,G1H4(94),n2h4(318))
  Gcoeff(:)%j = (-(c(166)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[28,3],[0,0],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,237),heltab2x32(:,:,964))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(6),n2h4(319))
  Gcoeff(:)%j = (-(c(164)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[28,3],[nMT,nMT],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,238),heltab2x32(:,:,965))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMT,G1H4(109),n2h4(320))
  Gcoeff(:)%j = (-(c(163)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[28,3],[0,0],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,239),heltab2x32(:,:,966))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(100),n2h4(321))
  Gcoeff(:)%j = (-(c(162)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[28,3],[nMB,nMB],2,2,wf8(:,55),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,240),heltab2x32(:,:,967))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMB,G1H4(110),n2h4(322))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[28,3],[nME,nME],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,241),heltab2x32(:,:,968))
  call Hloop_Q_A(ntryL,G0H4(64),28,nME,G1H4(105),n2h4(323))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[28,3],[nMM,nMM],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,242),heltab2x32(:,:,969))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMM,G1H4(20),n2h4(324))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[28,3],[nML,nML],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,243),heltab2x32(:,:,970))
  call Hloop_Q_A(ntryL,G0H4(64),28,nML,G1H4(35),n2h4(325))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[28,3],[0,0],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZu,m3h8x4(:,244),heltab2x32(:,:,971))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(57),n2h4(326))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[28,3],[nMT,nMT],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZu,m3h8x4(:,245),heltab2x32(:,:,972))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMT,G1H4(43),n2h4(327))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[28,3],[0,0],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZd,m3h8x4(:,246),heltab2x32(:,:,973))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(38),n2h4(328))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[28,3],[nMB,nMB],2,2,wf8(:,56),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZd,m3h8x4(:,247),heltab2x32(:,:,974))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMB,G1H4(32),n2h4(329))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[28,3],[nME,nME],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,248),heltab2x32(:,:,975))
  call Hloop_Q_A(ntryL,G0H4(64),28,nME,G1H4(5),n2h4(330))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[28,3],[nMM,nMM],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,249),heltab2x32(:,:,976))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMM,G1H4(55),n2h4(331))
  Gcoeff(:)%j = (c(169)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[28,3],[nML,nML],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,250),heltab2x32(:,:,977))
  call Hloop_Q_A(ntryL,G0H4(64),28,nML,G1H4(121),n2h4(332))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[28,3],[0,0],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,251),heltab2x32(:,:,978))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(122),n2h4(333))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[28,3],[nMT,nMT],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,252),heltab2x32(:,:,979))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMT,G1H4(123),n2h4(334))
  Gcoeff(:)%j = (c(168)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[28,3],[0,0],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,253),heltab2x32(:,:,980))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(124),n2h4(335))
  Gcoeff(:)%j = (c(165)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[28,3],[nMB,nMB],2,2,wf8(:,55),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,254),heltab2x32(:,:,981))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMB,G1H4(125),n2h4(336))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[28,3],[0,0],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZn,m3h8x4(:,255),heltab2x32(:,:,982))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(126),n2h4(337))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[28,3],[nME,nME],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,256),heltab2x32(:,:,983))
  call Hloop_Q_A(ntryL,G0H4(64),28,nME,G1H4(127),n2h4(338))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[28,3],[nMM,nMM],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,257),heltab2x32(:,:,984))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMM,G1H4(128),n2h4(339))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[28,3],[nML,nML],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZl,m3h8x4(:,258),heltab2x32(:,:,985))
  call Hloop_Q_A(ntryL,G0H4(64),28,nML,G1H4(129),n2h4(340))
  Gcoeff(:)%j = (c(180)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[28,3],[0,0],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZu,m3h8x4(:,259),heltab2x32(:,:,986))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(130),n2h4(341))
  Gcoeff(:)%j = (c(176)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[28,3],[nMT,nMT],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZu,m3h8x4(:,260),heltab2x32(:,:,987))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMT,G1H4(131),n2h4(342))
  Gcoeff(:)%j = (c(180)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[28,3],[0,0],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZd,m3h8x4(:,261),heltab2x32(:,:,988))
  call Hloop_Q_A(ntryL,G0H4(64),28,0,G1H4(132),n2h4(343))
  Gcoeff(:)%j = (c(176)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[28,3],[nMB,nMB],2,2,wf8(:,56),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,56),G0H4(64),ngZd,m3h8x4(:,262),heltab2x32(:,:,989))
  call Hloop_Q_A(ntryL,G0H4(64),28,nMB,G1H4(133),n2h4(344))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(134),m3h8x4(:,263),heltab2x32(:,:,990))
  Gcoeff(:)%j = (c(150)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(135),m3h8x4(:,264),heltab2x32(:,:,991))
  Gcoeff(:)%j = (-(c(149)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(136),m3h8x4(:,265),heltab2x32(:,:,992))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[28,3],[nMH,nMZ],2,2,wf8(:,56),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(137),m3h8x4(:,266),heltab2x32(:,:,993))
  Gcoeff(:)%j = (-(c(157)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(138),m3h8x4(:,267),heltab2x32(:,:,994))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(139),m3h8x4(:,268),heltab2x32(:,:,995))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(140),m3h8x4(:,269),heltab2x32(:,:,996))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(141),m3h8x4(:,270),heltab2x32(:,:,997))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(142),m3h8x4(:,271),heltab2x32(:,:,998))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(143),m3h8x4(:,272),heltab2x32(:,:,999))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(144),m3h8x4(:,273),heltab2x32(:,:,1000))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(145),m3h8x4(:,274),heltab2x32(:,:,1001))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(146),m3h8x4(:,275),heltab2x32(:,:,1002))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(147),m3h8x4(:,276),heltab2x32(:,:,1003))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(148),m3h8x4(:,277),heltab2x32(:,:,1004))
  Gcoeff(:)%j = (c(118)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,55),28,G1H4(149),m3h8x4(:,278),heltab2x32(:,:,1005))
  Gcoeff(:)%j = (-(c(66)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,56),28,G1H4(150),m3h8x4(:,279),heltab2x32(:,:,1006))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,55),G0H4(64),m3h8x4(:,280),heltab2x32(:,:,1007))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,55),G0H4(65),m3h8x4(:,281),heltab2x32(:,:,1008))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(66),m3h8x4(:,282),heltab2x32(:,:,1009))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(67),m3h8x4(:,283),heltab2x32(:,:,1010))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,55),G0H4(68),m3h8x4(:,284),heltab2x32(:,:,1011))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[28,3],[nMW,nMW],2,2,wf8(:,55),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,55),G0H4(69),m3h8x4(:,285),heltab2x32(:,:,1012))
  Gcoeff(:)%j = (c(112)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[28,3],[nMH,nMZ],2,2,wf8(:,56),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(70),m3h8x4(:,286),heltab2x32(:,:,1013))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(71),m3h8x4(:,287),heltab2x32(:,:,1014))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[28,3],[nMW,nMW],2,2,wf8(:,56),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(72),m3h8x4(:,288),heltab2x32(:,:,1015))
  Gcoeff(:)%j = (-(c(190)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[19,12],[nME,nME],2,2,wf8(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,289),heltab2x32(:,:,1016))
  call Hloop_Q_A(ntryL,G0H4(73),19,nME,G1H4(151),n2h4(345))
  Gcoeff(:)%j = (-(c(200)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,290),heltab2x32(:,:,1017))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMM,G1H4(152),n2h4(346))
  Gcoeff(:)%j = (-(c(195)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,291),heltab2x32(:,:,1018))
  call Hloop_Q_A(ntryL,G0H4(73),19,nML,G1H4(153),n2h4(347))
  Gcoeff(:)%j = (c(204)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,292),heltab2x32(:,:,1019))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMT,G1H4(154),n2h4(348))
  Gcoeff(:)%j = (-(c(185)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,293),heltab2x32(:,:,1020))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMB,G1H4(155),n2h4(349))
  Gcoeff(:)%j = (c(190)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[19,12],[nME,nME],2,2,wf8(:,5),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,294),heltab2x32(:,:,1021))
  call Hloop_Q_A(ntryL,G0H4(73),19,nME,G1H4(156),n2h4(350))
  Gcoeff(:)%j = (c(200)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,295),heltab2x32(:,:,1022))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMM,G1H4(157),n2h4(351))
  Gcoeff(:)%j = (c(195)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,296),heltab2x32(:,:,1023))
  call Hloop_Q_A(ntryL,G0H4(73),19,nML,G1H4(158),n2h4(352))
  Gcoeff(:)%j = (c(204)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,297),heltab2x32(:,:,1024))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMT,G1H4(159),n2h4(353))
  Gcoeff(:)%j = (c(185)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,298),heltab2x32(:,:,1025))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMB,G1H4(160),n2h4(354))
  Gcoeff(:)%j = (c(191)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[19,12],[nME,nME],2,2,wf8(:,6),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,299),heltab2x32(:,:,1026))
  call Hloop_Q_A(ntryL,G0H4(73),19,nME,G1H4(161),n2h4(355))
  Gcoeff(:)%j = (c(201)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,300),heltab2x32(:,:,1027))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMM,G1H4(162),n2h4(356))
  Gcoeff(:)%j = (c(196)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,301),heltab2x32(:,:,1028))
  call Hloop_Q_A(ntryL,G0H4(73),19,nML,G1H4(163),n2h4(357))
  Gcoeff(:)%j = (c(206)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZu,m3h8x4(:,302),heltab2x32(:,:,1029))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMT,G1H4(164),n2h4(358))
  Gcoeff(:)%j = (c(187)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZd,m3h8x4(:,303),heltab2x32(:,:,1030))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMB,G1H4(165),n2h4(359))
  Gcoeff(:)%j = (-(c(191)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[19,12],[nME,nME],2,2,wf8(:,6),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,304),heltab2x32(:,:,1031))
  call Hloop_Q_A(ntryL,G0H4(73),19,nME,G1H4(166),n2h4(360))
  Gcoeff(:)%j = (-(c(201)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,305),heltab2x32(:,:,1032))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMM,G1H4(167),n2h4(361))
  Gcoeff(:)%j = (-(c(196)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZl,m3h8x4(:,306),heltab2x32(:,:,1033))
  call Hloop_Q_A(ntryL,G0H4(73),19,nML,G1H4(168),n2h4(362))
  Gcoeff(:)%j = (c(206)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZu,m3h8x4(:,307),heltab2x32(:,:,1034))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMT,G1H4(169),n2h4(363))
  Gcoeff(:)%j = (-(c(187)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(73),ngZd,m3h8x4(:,308),heltab2x32(:,:,1035))
  call Hloop_Q_A(ntryL,G0H4(73),19,nMB,G1H4(170),n2h4(364))
  Gcoeff(:)%j = (-(c(107)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(171),m3h8x4(:,309),heltab2x32(:,:,1036))
  Gcoeff(:)%j = (c(146)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(172),m3h8x4(:,310),heltab2x32(:,:,1037))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(173),m3h8x4(:,311),heltab2x32(:,:,1038))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(174),m3h8x4(:,312),heltab2x32(:,:,1039))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(175),m3h8x4(:,313),heltab2x32(:,:,1040))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1075),h0tab(:,1075),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(176),m3h8x4(:,314),heltab2x32(:,:,1041))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1076),h0tab(:,1076),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(177),m3h8x4(:,315),heltab2x32(:,:,1042))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1077),h0tab(:,1077),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(178),m3h8x4(:,316),heltab2x32(:,:,1043))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1078),h0tab(:,1078),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(179),m3h8x4(:,317),heltab2x32(:,:,1044))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1079),h0tab(:,1079),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(180),m3h8x4(:,318),heltab2x32(:,:,1045))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1080),h0tab(:,1080),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(181),m3h8x4(:,319),heltab2x32(:,:,1046))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1081),h0tab(:,1081),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(182),m3h8x4(:,320),heltab2x32(:,:,1047))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1082),h0tab(:,1082),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(183),m3h8x4(:,321),heltab2x32(:,:,1048))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1083),h0tab(:,1083),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(73),m3h8x4(:,322),heltab2x32(:,:,1049))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1084),h0tab(:,1084),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(74),m3h8x4(:,323),heltab2x32(:,:,1050))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1085),h0tab(:,1085),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(75),m3h8x4(:,324),heltab2x32(:,:,1051))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1086),h0tab(:,1086),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(76),m3h8x4(:,325),heltab2x32(:,:,1052))
  Gcoeff(:)%j = (c(124)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1087),h0tab(:,1087),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(77),m3h8x4(:,326),heltab2x32(:,:,1053))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1088),h0tab(:,1088),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(78),m3h8x4(:,327),heltab2x32(:,:,1054))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1089),h0tab(:,1089),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(79),m3h8x4(:,328),heltab2x32(:,:,1055))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1090),h0tab(:,1090),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(80),m3h8x4(:,329),heltab2x32(:,:,1056))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1091),h0tab(:,1091),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(81),m3h8x4(:,330),heltab2x32(:,:,1057))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1092),h0tab(:,1092),[19,12],[nME,nME],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,331),heltab2x32(:,:,1058))
  call Hloop_Q_A(ntryL,G0H4(82),19,nME,G1H4(184),n2h4(365))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1093),h0tab(:,1093),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,332),heltab2x32(:,:,1059))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMM,G1H4(185),n2h4(366))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1094),h0tab(:,1094),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,333),heltab2x32(:,:,1060))
  call Hloop_Q_A(ntryL,G0H4(82),19,nML,G1H4(186),n2h4(367))
  Gcoeff(:)%j = (c(170)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1095),h0tab(:,1095),[19,12],[0,0],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,334),heltab2x32(:,:,1061))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(187),n2h4(368))
  Gcoeff(:)%j = (c(166)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1096),h0tab(:,1096),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,335),heltab2x32(:,:,1062))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMT,G1H4(188),n2h4(369))
  Gcoeff(:)%j = (c(164)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1097),h0tab(:,1097),[19,12],[0,0],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,336),heltab2x32(:,:,1063))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(189),n2h4(370))
  Gcoeff(:)%j = (c(163)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1098),h0tab(:,1098),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,337),heltab2x32(:,:,1064))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMB,G1H4(190),n2h4(371))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1099),h0tab(:,1099),[19,12],[nME,nME],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,338),heltab2x32(:,:,1065))
  call Hloop_Q_A(ntryL,G0H4(82),19,nME,G1H4(191),n2h4(372))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1100),h0tab(:,1100),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,339),heltab2x32(:,:,1066))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMM,G1H4(192),n2h4(373))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1101),h0tab(:,1101),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,340),heltab2x32(:,:,1067))
  call Hloop_Q_A(ntryL,G0H4(82),19,nML,G1H4(193),n2h4(374))
  Gcoeff(:)%j = (-(c(178)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1102),h0tab(:,1102),[19,12],[0,0],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,341),heltab2x32(:,:,1068))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(194),n2h4(375))
  Gcoeff(:)%j = (-(c(174)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1103),h0tab(:,1103),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,342),heltab2x32(:,:,1069))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMT,G1H4(195),n2h4(376))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1104),h0tab(:,1104),[19,12],[0,0],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,343),heltab2x32(:,:,1070))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(196),n2h4(377))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1105),h0tab(:,1105),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,344),heltab2x32(:,:,1071))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMB,G1H4(197),n2h4(378))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1106),h0tab(:,1106),[19,12],[nME,nME],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,345),heltab2x32(:,:,1072))
  call Hloop_Q_A(ntryL,G0H4(82),19,nME,G1H4(198),n2h4(379))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1107),h0tab(:,1107),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,346),heltab2x32(:,:,1073))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMM,G1H4(199),n2h4(380))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1108),h0tab(:,1108),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,347),heltab2x32(:,:,1074))
  call Hloop_Q_A(ntryL,G0H4(82),19,nML,G1H4(200),n2h4(381))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1109),h0tab(:,1109),[19,12],[0,0],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZu,m3h8x4(:,348),heltab2x32(:,:,1075))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(201),n2h4(382))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1110),h0tab(:,1110),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZu,m3h8x4(:,349),heltab2x32(:,:,1076))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMT,G1H4(202),n2h4(383))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1111),h0tab(:,1111),[19,12],[0,0],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZd,m3h8x4(:,350),heltab2x32(:,:,1077))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(203),n2h4(384))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1112),h0tab(:,1112),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZd,m3h8x4(:,351),heltab2x32(:,:,1078))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMB,G1H4(204),n2h4(385))
  Gcoeff(:)%j = (-(c(183)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1113),h0tab(:,1113),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZn,m3h8x4(:,352),heltab2x32(:,:,1079))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(205),n2h4(386))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1114),h0tab(:,1114),[19,12],[nME,nME],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,353),heltab2x32(:,:,1080))
  call Hloop_Q_A(ntryL,G0H4(82),19,nME,G1H4(206),n2h4(387))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1115),h0tab(:,1115),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,354),heltab2x32(:,:,1081))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMM,G1H4(207),n2h4(388))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1116),h0tab(:,1116),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZl,m3h8x4(:,355),heltab2x32(:,:,1082))
  call Hloop_Q_A(ntryL,G0H4(82),19,nML,G1H4(208),n2h4(389))
  Gcoeff(:)%j = (-(c(182)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1117),h0tab(:,1117),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZu,m3h8x4(:,356),heltab2x32(:,:,1083))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(209),n2h4(390))
  Gcoeff(:)%j = (-(c(180)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1118),h0tab(:,1118),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZu,m3h8x4(:,357),heltab2x32(:,:,1084))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMT,G1H4(210),n2h4(391))
  Gcoeff(:)%j = (-(c(182)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1119),h0tab(:,1119),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZd,m3h8x4(:,358),heltab2x32(:,:,1085))
  call Hloop_Q_A(ntryL,G0H4(82),19,0,G1H4(211),n2h4(392))
  Gcoeff(:)%j = (-(c(180)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1120),h0tab(:,1120),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(82),ngZd,m3h8x4(:,359),heltab2x32(:,:,1086))
  call Hloop_Q_A(ntryL,G0H4(82),19,nMB,G1H4(212),n2h4(393))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1121),h0tab(:,1121),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(213),m3h8x4(:,360),heltab2x32(:,:,1087))
  Gcoeff(:)%j = (-(c(152)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1122),h0tab(:,1122),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(214),m3h8x4(:,361),heltab2x32(:,:,1088))
  Gcoeff(:)%j = (c(150)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1123),h0tab(:,1123),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(215),m3h8x4(:,362),heltab2x32(:,:,1089))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1124),h0tab(:,1124),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(216),m3h8x4(:,363),heltab2x32(:,:,1090))
  Gcoeff(:)%j = (c(158)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1125),h0tab(:,1125),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(217),m3h8x4(:,364),heltab2x32(:,:,1091))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1126),h0tab(:,1126),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(218),m3h8x4(:,365),heltab2x32(:,:,1092))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1127),h0tab(:,1127),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(219),m3h8x4(:,366),heltab2x32(:,:,1093))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1128),h0tab(:,1128),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(220),m3h8x4(:,367),heltab2x32(:,:,1094))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1129),h0tab(:,1129),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(221),m3h8x4(:,368),heltab2x32(:,:,1095))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1130),h0tab(:,1130),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(222),m3h8x4(:,369),heltab2x32(:,:,1096))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1131),h0tab(:,1131),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(223),m3h8x4(:,370),heltab2x32(:,:,1097))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1132),h0tab(:,1132),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(224),m3h8x4(:,371),heltab2x32(:,:,1098))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1133),h0tab(:,1133),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(225),m3h8x4(:,372),heltab2x32(:,:,1099))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1134),h0tab(:,1134),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(226),m3h8x4(:,373),heltab2x32(:,:,1100))
  Gcoeff(:)%j = (c(121)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1135),h0tab(:,1135),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(227),m3h8x4(:,374),heltab2x32(:,:,1101))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1136),h0tab(:,1136),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(228),m3h8x4(:,375),heltab2x32(:,:,1102))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1137),h0tab(:,1137),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(229),m3h8x4(:,376),heltab2x32(:,:,1103))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1138),h0tab(:,1138),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(82),m3h8x4(:,377),heltab2x32(:,:,1104))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1139),h0tab(:,1139),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(83),m3h8x4(:,378),heltab2x32(:,:,1105))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1140),h0tab(:,1140),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(84),m3h8x4(:,379),heltab2x32(:,:,1106))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1141),h0tab(:,1141),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(85),m3h8x4(:,380),heltab2x32(:,:,1107))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1142),h0tab(:,1142),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(86),m3h8x4(:,381),heltab2x32(:,:,1108))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1143),h0tab(:,1143),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(87),m3h8x4(:,382),heltab2x32(:,:,1109))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1144),h0tab(:,1144),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(88),m3h8x4(:,383),heltab2x32(:,:,1110))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1145),h0tab(:,1145),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(89),m3h8x4(:,384),heltab2x32(:,:,1111))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1146),h0tab(:,1146),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(90),m3h8x4(:,385),heltab2x32(:,:,1112))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1147),h0tab(:,1147),[17,14],[0,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(33),m3h4x8(:,203),heltab2x32(:,:,1113))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1148),h0tab(:,1148),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(44),ngZu,m3h4x8(:,204),heltab2x32(:,:,1114))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1149),h0tab(:,1149),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(45),m3h4x8(:,205),heltab2x32(:,:,1115))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1150),h0tab(:,1150),[17,14],[0,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(46),m3h4x8(:,206),heltab2x32(:,:,1116))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1151),h0tab(:,1151),[17,14],[0,0],2,2,wf4(:,9),wf8(:,62))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(43),m3h4x8(:,207),heltab2x32(:,:,1117))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1152),h0tab(:,1152),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,62))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(41),ngZu,m3h4x8(:,208),heltab2x32(:,:,1118))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1153),h0tab(:,1153),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,62))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(42),m3h4x8(:,209),heltab2x32(:,:,1119))
  Gcoeff(:)%j = (c(28)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1154),h0tab(:,1154),[17,14],[0,0],2,2,wf4(:,9),wf8(:,62))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(14),m3h4x8(:,210),heltab2x32(:,:,1120))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(21)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1155),h0tab(:,1155),[17,14],[0,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(18),m3h4x8(:,211),heltab2x32(:,:,1121))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1156),h0tab(:,1156),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(19),ngZu,m3h4x8(:,212),heltab2x32(:,:,1122))
  Gcoeff(:)%j = (c(72)*M(1,:)%j-c(71)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1157),h0tab(:,1157),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,60))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(31),m3h4x8(:,213),heltab2x32(:,:,1123))
  Gcoeff(:)%j = (-(c(190)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1158),h0tab(:,1158),[19,12],[nME,nME],2,2,wf8(:,7),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,386),heltab2x32(:,:,1124))
  call Hloop_Q_A(ntryL,G0H4(91),19,nME,G1H4(230),n2h4(394))
  Gcoeff(:)%j = (-(c(200)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1159),h0tab(:,1159),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,387),heltab2x32(:,:,1125))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMM,G1H4(231),n2h4(395))
  Gcoeff(:)%j = (-(c(195)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1160),h0tab(:,1160),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,388),heltab2x32(:,:,1126))
  call Hloop_Q_A(ntryL,G0H4(91),19,nML,G1H4(232),n2h4(396))
  Gcoeff(:)%j = (c(204)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1161),h0tab(:,1161),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,389),heltab2x32(:,:,1127))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMT,G1H4(233),n2h4(397))
  Gcoeff(:)%j = (-(c(185)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1162),h0tab(:,1162),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,390),heltab2x32(:,:,1128))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMB,G1H4(234),n2h4(398))
  Gcoeff(:)%j = (c(190)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1163),h0tab(:,1163),[19,12],[nME,nME],2,2,wf8(:,7),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,391),heltab2x32(:,:,1129))
  call Hloop_Q_A(ntryL,G0H4(91),19,nME,G1H4(235),n2h4(399))
  Gcoeff(:)%j = (c(200)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1164),h0tab(:,1164),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,392),heltab2x32(:,:,1130))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMM,G1H4(236),n2h4(400))
  Gcoeff(:)%j = (c(195)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1165),h0tab(:,1165),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,393),heltab2x32(:,:,1131))
  call Hloop_Q_A(ntryL,G0H4(91),19,nML,G1H4(237),n2h4(401))
  Gcoeff(:)%j = (c(204)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1166),h0tab(:,1166),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,394),heltab2x32(:,:,1132))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMT,G1H4(238),n2h4(402))
  Gcoeff(:)%j = (c(185)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1167),h0tab(:,1167),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,395),heltab2x32(:,:,1133))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMB,G1H4(239),n2h4(403))
  Gcoeff(:)%j = (c(191)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1168),h0tab(:,1168),[19,12],[nME,nME],2,2,wf8(:,8),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,396),heltab2x32(:,:,1134))
  call Hloop_Q_A(ntryL,G0H4(91),19,nME,G1H4(240),n2h4(404))
  Gcoeff(:)%j = (c(201)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1169),h0tab(:,1169),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,397),heltab2x32(:,:,1135))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMM,G1H4(241),n2h4(405))
  Gcoeff(:)%j = (c(196)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1170),h0tab(:,1170),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,398),heltab2x32(:,:,1136))
  call Hloop_Q_A(ntryL,G0H4(91),19,nML,G1H4(242),n2h4(406))
  Gcoeff(:)%j = (c(206)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1171),h0tab(:,1171),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZu,m3h8x4(:,399),heltab2x32(:,:,1137))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMT,G1H4(243),n2h4(407))
  Gcoeff(:)%j = (c(187)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1172),h0tab(:,1172),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,13))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZd,m3h8x4(:,400),heltab2x32(:,:,1138))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMB,G1H4(244),n2h4(408))
  Gcoeff(:)%j = (-(c(191)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1173),h0tab(:,1173),[19,12],[nME,nME],2,2,wf8(:,8),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,401),heltab2x32(:,:,1139))
  call Hloop_Q_A(ntryL,G0H4(91),19,nME,G1H4(245),n2h4(409))
  Gcoeff(:)%j = (-(c(201)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1174),h0tab(:,1174),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,402),heltab2x32(:,:,1140))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMM,G1H4(246),n2h4(410))
  Gcoeff(:)%j = (-(c(196)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1175),h0tab(:,1175),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZl,m3h8x4(:,403),heltab2x32(:,:,1141))
  call Hloop_Q_A(ntryL,G0H4(91),19,nML,G1H4(247),n2h4(411))
  Gcoeff(:)%j = (c(206)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1176),h0tab(:,1176),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZu,m3h8x4(:,404),heltab2x32(:,:,1142))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMT,G1H4(248),n2h4(412))
  Gcoeff(:)%j = (-(c(187)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1177),h0tab(:,1177),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,52))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(91),ngZd,m3h8x4(:,405),heltab2x32(:,:,1143))
  call Hloop_Q_A(ntryL,G0H4(91),19,nMB,G1H4(249),n2h4(413))
  Gcoeff(:)%j = (-(c(107)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1178),h0tab(:,1178),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(250),m3h8x4(:,406),heltab2x32(:,:,1144))
  Gcoeff(:)%j = (c(146)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1179),h0tab(:,1179),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(251),m3h8x4(:,407),heltab2x32(:,:,1145))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1180),h0tab(:,1180),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(252),m3h8x4(:,408),heltab2x32(:,:,1146))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1181),h0tab(:,1181),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(253),m3h8x4(:,409),heltab2x32(:,:,1147))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1182),h0tab(:,1182),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(254),m3h8x4(:,410),heltab2x32(:,:,1148))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1183),h0tab(:,1183),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(255),m3h8x4(:,411),heltab2x32(:,:,1149))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1184),h0tab(:,1184),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(256),m3h8x4(:,412),heltab2x32(:,:,1150))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1185),h0tab(:,1185),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(257),m3h8x4(:,413),heltab2x32(:,:,1151))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1186),h0tab(:,1186),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(258),m3h8x4(:,414),heltab2x32(:,:,1152))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1187),h0tab(:,1187),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(259),m3h8x4(:,415),heltab2x32(:,:,1153))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1188),h0tab(:,1188),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(260),m3h8x4(:,416),heltab2x32(:,:,1154))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1189),h0tab(:,1189),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(261),m3h8x4(:,417),heltab2x32(:,:,1155))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1190),h0tab(:,1190),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(262),m3h8x4(:,418),heltab2x32(:,:,1156))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1191),h0tab(:,1191),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(91),m3h8x4(:,419),heltab2x32(:,:,1157))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1192),h0tab(:,1192),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(92),m3h8x4(:,420),heltab2x32(:,:,1158))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1193),h0tab(:,1193),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(93),m3h8x4(:,421),heltab2x32(:,:,1159))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1194),h0tab(:,1194),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(94),m3h8x4(:,422),heltab2x32(:,:,1160))
  Gcoeff(:)%j = (c(124)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1195),h0tab(:,1195),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(95),m3h8x4(:,423),heltab2x32(:,:,1161))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1196),h0tab(:,1196),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(96),m3h8x4(:,424),heltab2x32(:,:,1162))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1197),h0tab(:,1197),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(97),m3h8x4(:,425),heltab2x32(:,:,1163))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1198),h0tab(:,1198),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(98),m3h8x4(:,426),heltab2x32(:,:,1164))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1199),h0tab(:,1199),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(99),m3h8x4(:,427),heltab2x32(:,:,1165))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1200),h0tab(:,1200),[19,12],[nME,nME],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,428),heltab2x32(:,:,1166))
  call Hloop_Q_A(ntryL,G0H4(100),19,nME,G1H4(263),n2h4(414))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1201),h0tab(:,1201),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,429),heltab2x32(:,:,1167))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMM,G1H4(264),n2h4(415))
  Gcoeff(:)%j = (c(171)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1202),h0tab(:,1202),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,430),heltab2x32(:,:,1168))
  call Hloop_Q_A(ntryL,G0H4(100),19,nML,G1H4(265),n2h4(416))
  Gcoeff(:)%j = (c(170)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1203),h0tab(:,1203),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,431),heltab2x32(:,:,1169))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(266),n2h4(417))
  Gcoeff(:)%j = (c(166)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1204),h0tab(:,1204),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,432),heltab2x32(:,:,1170))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMT,G1H4(267),n2h4(418))
  Gcoeff(:)%j = (c(164)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1205),h0tab(:,1205),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,433),heltab2x32(:,:,1171))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(268),n2h4(419))
  Gcoeff(:)%j = (c(163)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1206),h0tab(:,1206),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,434),heltab2x32(:,:,1172))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMB,G1H4(269),n2h4(420))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1207),h0tab(:,1207),[19,12],[nME,nME],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,435),heltab2x32(:,:,1173))
  call Hloop_Q_A(ntryL,G0H4(100),19,nME,G1H4(270),n2h4(421))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1208),h0tab(:,1208),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,436),heltab2x32(:,:,1174))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMM,G1H4(271),n2h4(422))
  Gcoeff(:)%j = (c(177)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1209),h0tab(:,1209),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,437),heltab2x32(:,:,1175))
  call Hloop_Q_A(ntryL,G0H4(100),19,nML,G1H4(272),n2h4(423))
  Gcoeff(:)%j = (-(c(178)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1210),h0tab(:,1210),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,438),heltab2x32(:,:,1176))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(273),n2h4(424))
  Gcoeff(:)%j = (-(c(174)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1211),h0tab(:,1211),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,439),heltab2x32(:,:,1177))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMT,G1H4(274),n2h4(425))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1212),h0tab(:,1212),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,440),heltab2x32(:,:,1178))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(275),n2h4(426))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1213),h0tab(:,1213),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,441),heltab2x32(:,:,1179))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMB,G1H4(276),n2h4(427))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1214),h0tab(:,1214),[19,12],[nME,nME],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,442),heltab2x32(:,:,1180))
  call Hloop_Q_A(ntryL,G0H4(100),19,nME,G1H4(277),n2h4(428))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1215),h0tab(:,1215),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,443),heltab2x32(:,:,1181))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMM,G1H4(278),n2h4(429))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1216),h0tab(:,1216),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,444),heltab2x32(:,:,1182))
  call Hloop_Q_A(ntryL,G0H4(100),19,nML,G1H4(279),n2h4(430))
  Gcoeff(:)%j = (c(174)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1217),h0tab(:,1217),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZu,m3h8x4(:,445),heltab2x32(:,:,1183))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(280),n2h4(431))
  Gcoeff(:)%j = (c(172)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1218),h0tab(:,1218),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZu,m3h8x4(:,446),heltab2x32(:,:,1184))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMT,G1H4(281),n2h4(432))
  Gcoeff(:)%j = (-(c(172)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1219),h0tab(:,1219),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZd,m3h8x4(:,447),heltab2x32(:,:,1185))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(282),n2h4(433))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1220),h0tab(:,1220),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZd,m3h8x4(:,448),heltab2x32(:,:,1186))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMB,G1H4(283),n2h4(434))
  Gcoeff(:)%j = (-(c(183)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1221),h0tab(:,1221),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZn,m3h8x4(:,449),heltab2x32(:,:,1187))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(284),n2h4(435))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1222),h0tab(:,1222),[19,12],[nME,nME],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,450),heltab2x32(:,:,1188))
  call Hloop_Q_A(ntryL,G0H4(100),19,nME,G1H4(285),n2h4(436))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1223),h0tab(:,1223),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,451),heltab2x32(:,:,1189))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMM,G1H4(286),n2h4(437))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1224),h0tab(:,1224),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZl,m3h8x4(:,452),heltab2x32(:,:,1190))
  call Hloop_Q_A(ntryL,G0H4(100),19,nML,G1H4(287),n2h4(438))
  Gcoeff(:)%j = (-(c(182)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1225),h0tab(:,1225),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZu,m3h8x4(:,453),heltab2x32(:,:,1191))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(288),n2h4(439))
  Gcoeff(:)%j = (-(c(180)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1226),h0tab(:,1226),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZu,m3h8x4(:,454),heltab2x32(:,:,1192))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMT,G1H4(289),n2h4(440))
  Gcoeff(:)%j = (-(c(182)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1227),h0tab(:,1227),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZd,m3h8x4(:,455),heltab2x32(:,:,1193))
  call Hloop_Q_A(ntryL,G0H4(100),19,0,G1H4(290),n2h4(441))
  Gcoeff(:)%j = (-(c(180)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1228),h0tab(:,1228),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(100),ngZd,m3h8x4(:,456),heltab2x32(:,:,1194))
  call Hloop_Q_A(ntryL,G0H4(100),19,nMB,G1H4(291),n2h4(442))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1229),h0tab(:,1229),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(292),m3h8x4(:,457),heltab2x32(:,:,1195))
  Gcoeff(:)%j = (-(c(152)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1230),h0tab(:,1230),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(293),m3h8x4(:,458),heltab2x32(:,:,1196))
  Gcoeff(:)%j = (c(150)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1231),h0tab(:,1231),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(294),m3h8x4(:,459),heltab2x32(:,:,1197))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1232),h0tab(:,1232),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(295),m3h8x4(:,460),heltab2x32(:,:,1198))
  Gcoeff(:)%j = (c(158)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1233),h0tab(:,1233),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(296),m3h8x4(:,461),heltab2x32(:,:,1199))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1234),h0tab(:,1234),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(297),m3h8x4(:,462),heltab2x32(:,:,1200))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1235),h0tab(:,1235),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(298),m3h8x4(:,463),heltab2x32(:,:,1201))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1236),h0tab(:,1236),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(299),m3h8x4(:,464),heltab2x32(:,:,1202))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1237),h0tab(:,1237),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(300),m3h8x4(:,465),heltab2x32(:,:,1203))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1238),h0tab(:,1238),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(301),m3h8x4(:,466),heltab2x32(:,:,1204))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1239),h0tab(:,1239),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(302),m3h8x4(:,467),heltab2x32(:,:,1205))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1240),h0tab(:,1240),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(303),m3h8x4(:,468),heltab2x32(:,:,1206))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1241),h0tab(:,1241),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(304),m3h8x4(:,469),heltab2x32(:,:,1207))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1242),h0tab(:,1242),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(305),m3h8x4(:,470),heltab2x32(:,:,1208))
  Gcoeff(:)%j = (c(121)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1243),h0tab(:,1243),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(306),m3h8x4(:,471),heltab2x32(:,:,1209))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1244),h0tab(:,1244),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(307),m3h8x4(:,472),heltab2x32(:,:,1210))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1245),h0tab(:,1245),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(308),m3h8x4(:,473),heltab2x32(:,:,1211))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1246),h0tab(:,1246),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(100),m3h8x4(:,474),heltab2x32(:,:,1212))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1247),h0tab(:,1247),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(101),m3h8x4(:,475),heltab2x32(:,:,1213))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1248),h0tab(:,1248),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(102),m3h8x4(:,476),heltab2x32(:,:,1214))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1249),h0tab(:,1249),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(103),m3h8x4(:,477),heltab2x32(:,:,1215))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1250),h0tab(:,1250),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(104),m3h8x4(:,478),heltab2x32(:,:,1216))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1251),h0tab(:,1251),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(105),m3h8x4(:,479),heltab2x32(:,:,1217))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1252),h0tab(:,1252),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(106),m3h8x4(:,480),heltab2x32(:,:,1218))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1253),h0tab(:,1253),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(107),m3h8x4(:,481),heltab2x32(:,:,1219))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1254),h0tab(:,1254),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(108),m3h8x4(:,482),heltab2x32(:,:,1220))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1255),h0tab(:,1255),[18,13],[0,0],2,2,wf4(:,12),wf8(:,64))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(27),m3h4x8(:,214),heltab2x32(:,:,1221))
  call Hloop_A_Q(ntryL,G0H8(27),18,0,G1H8(32),n2h8(149))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1256),h0tab(:,1256),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,64))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(28),ngZu,m3h4x8(:,215),heltab2x32(:,:,1222))
  call Hloop_A_Q(ntryL,G0H8(28),18,0,G1H8(34),n2h8(150))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1257),h0tab(:,1257),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,64))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(29),m3h4x8(:,216),heltab2x32(:,:,1223))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(30),n2h8(151))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1258),h0tab(:,1258),[18,13],[0,0],2,2,wf4(:,12),wf8(:,64))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,217),heltab2x32(:,:,1224))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(28),n2h8(152))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1259),h0tab(:,1259),[18,13],[0,0],2,2,wf4(:,12),wf8(:,66))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,218),heltab2x32(:,:,1225))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(29),n2h8(153))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1260),h0tab(:,1260),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,66))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngZu,m3h4x8(:,219),heltab2x32(:,:,1226))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(31),n2h8(154))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1261),h0tab(:,1261),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,66))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(20),m3h4x8(:,220),heltab2x32(:,:,1227))
  call Hloop_A_Q(ntryL,G0H8(20),18,0,G1H8(5),n2h8(155))
  Gcoeff(:)%j = (c(28)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1262),h0tab(:,1262),[18,13],[0,0],2,2,wf4(:,12),wf8(:,66))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(47),m3h4x8(:,221),heltab2x32(:,:,1228))
  call Hloop_A_Q(ntryL,G0H8(47),18,0,G1H8(35),n2h8(156))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(21)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1263),h0tab(:,1263),[18,13],[0,0],2,2,wf4(:,12),wf8(:,64))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,222),heltab2x32(:,:,1229))
  call Hloop_A_Q(ntryL,G0H8(17),18,0,G1H8(49),n2h8(157))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1264),h0tab(:,1264),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,64))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngZu,m3h4x8(:,223),heltab2x32(:,:,1230))
  call Hloop_A_Q(ntryL,G0H8(7),18,0,G1H8(9),n2h8(158))
  Gcoeff(:)%j = (c(72)*M(1,:)%j-c(71)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1265),h0tab(:,1265),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,64))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,224),heltab2x32(:,:,1231))
  call Hloop_A_Q(ntryL,G0H8(4),18,0,G1H8(47),n2h8(159))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(22),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(57),[G0H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(63),[G0H16(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(62),G1H4(87),G1H4(48),G1H4(31),G1H4(37) &
    ,G1H4(42),G1H4(30),G0H4(67),G0H4(66),G0H4(65),G0H4(64),G0H4(45),G0H4(44),G0H4(43),G0H4(42),G0H4(18),G0H4(14),G0H4(15) &
    ,G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(50),G1H4(11),G1H4(78),G1H4(47),G1H4(52) &
    ,G1H4(41),G1H4(36),G0H4(72),G0H4(71),G0H4(69),G0H4(68),G0H4(50),G0H4(49),G0H4(47),G0H4(46),G0H4(16),G0H4(19),G0H4(21) &
    ,G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(134),G1H4(53),G1H4(82),G0H4(51),G0H4(29) &
    ,G0H4(10),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(136),G1H4(112),G1H4(96),G0H4(52),G0H4(30) &
    ,G0H4(1),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(147),G1H4(18),G1H4(39),G0H4(62),G0H4(40) &
    ,G0H4(12),G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(149),G1H4(93),G1H4(15),G0H4(63),G0H4(41) &
    ,G0H4(23),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(251),[G1H4(250),G1H4(172),G1H4(171),G0H4(7),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(262),[G1H4(261),G1H4(183),G1H4(182),G0H4(9),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(294),[G1H4(292),G1H4(215),G1H4(213),G0H4(6),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(296),[G1H4(293),G1H4(217),G1H4(214),G0H4(20),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(307),[G1H4(305),G1H4(228),G1H4(226),G0H4(27),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(308),[G1H4(306),G1H4(229),G1H4(227),G0H4(28),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(40),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(32),[G0H8(24),G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(34),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(17),G1H4(28),G1H4(40),G1H4(1),G1H4(51) &
    ,G1H4(69),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(101),G1H4(107),G1H4(27),G1H4(66),G1H4(56) &
    ,G1H4(73),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(94),G1H4(119),G1H4(33),G1H4(59),G1H4(4) &
    ,G1H4(74),G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(109),G1H4(49),G1H4(9),G1H4(58),G1H4(2),G1H4(90) &
    ,G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(110),G1H4(72),G1H4(34),G1H4(76),G1H4(19) &
    ,G1H4(91),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(5),G1H4(23),G1H4(64),G1H4(99),G1H4(71) &
    ,G1H4(22),G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(55),G1H4(24),G1H4(60),G1H4(102),G1H4(75) &
    ,G1H4(65),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(121),G1H4(25),G1H4(106),G1H4(86),G1H4(81) &
    ,G1H4(79),G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(123),G1H4(26),G1H4(29),G1H4(104),G1H4(84) &
    ,G1H4(80),G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(125),G1H4(45),G1H4(44),G1H4(98),G1H4(89) &
    ,G1H4(97),G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(111),G0H4(53),G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(141),G1H4(140),G1H4(139),G1H4(103),G1H4(114) &
    ,G1H4(16),G1H4(3),G0H4(57),G0H4(56),G0H4(55),G0H4(54),G0H4(35),G0H4(34),G0H4(33),G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(145),G1H4(144),G1H4(143),G1H4(63),G1H4(54) &
    ,G1H4(115),G1H4(108),G0H4(61),G0H4(60),G0H4(59),G0H4(58),G0H4(39),G0H4(38),G0H4(37),G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(46),G0H4(70),G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(57),G1H4(100),G1H4(6),G1H4(70),G1H4(7),G1H4(14) &
    ,G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(122),G1H4(10),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(124),G1H4(95),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(13),G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(240),[G1H4(230),G1H4(161),G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(231),G1H4(162),G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(232),G1H4(163),G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(233),G1H4(164),G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(234),G1H4(165),G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(235),G1H4(166),G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(246),[G1H4(236),G1H4(167),G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(237),G1H4(168),G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(248),[G1H4(238),G1H4(169),G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(249),[G1H4(239),G1H4(170),G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(258),[G1H4(257),G1H4(254),G1H4(253),G1H4(179),G1H4(178) &
    ,G1H4(175),G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(259),G1H4(256),G1H4(255),G1H4(181),G1H4(180) &
    ,G1H4(177),G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(96),[G0H4(95),G0H4(92),G0H4(91),G0H4(78),G0H4(77) &
    ,G0H4(74),G0H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(99),[G0H4(98),G0H4(94),G0H4(93),G0H4(81),G0H4(80) &
    ,G0H4(76),G0H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(97),[G0H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(263),G1H4(198),G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(278),[G1H4(264),G1H4(199),G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(265),G1H4(200),G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(282),[G1H4(280),G1H4(268),G1H4(266),G1H4(203),G1H4(201) &
    ,G1H4(189),G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(281),[G1H4(267),G1H4(202),G1H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(269),G1H4(204),G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(285),[G1H4(270),G1H4(206),G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(286),[G1H4(271),G1H4(207),G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(272),G1H4(208),G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(288),[G1H4(273),G1H4(209),G1H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(274),G1H4(210),G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(290),[G1H4(275),G1H4(211),G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(276),G1H4(212),G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(302),[G1H4(301),G1H4(298),G1H4(297),G1H4(223),G1H4(222) &
    ,G1H4(219),G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(304),[G1H4(303),G1H4(300),G1H4(299),G1H4(225),G1H4(224) &
    ,G1H4(221),G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(105),[G0H4(104),G0H4(101),G0H4(100),G0H4(87),G0H4(86) &
    ,G0H4(83),G0H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(108),[G0H4(107),G0H4(103),G0H4(102),G0H4(90),G0H4(89) &
    ,G0H4(85),G0H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(106),[G0H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(46),G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(31),[G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(28),G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(29)])
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H16(15),wf4(:,1),wf4(:,13),G0tensor(1),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H16(22),wf4(:,1),wf4(:,52),G0tensor(26),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H16(57),wf4(:,4),wf4(:,13),G0tensor(56),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H16(63),wf4(:,4),wf4(:,52),G0tensor(81),m4h4x4x1(:,4),heltab3x16(:,:,4))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(18),wf4(:,1),wf4(:,8),G1tensor(4),m4h4x4x1(:,5),heltab3x16(:,:,5))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(17),wf4(:,1),wf4(:,10),G1tensor(10),m4h4x4x1(:,6),heltab3x16(:,:,6))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(26),wf4(:,4),wf4(:,8),G1tensor(47),m4h4x4x1(:,7),heltab3x16(:,:,7))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(35),wf4(:,4),wf4(:,10),G1tensor(59),m4h4x4x1(:,8),heltab3x16(:,:,8))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(24),wf4(:,1),wf4(:,8),G1tensor(33),m4h4x4x1(:,9),heltab3x16(:,:,9))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(34),wf4(:,1),wf4(:,10),G1tensor(45),m4h4x4x1(:,10),heltab3x16(:,:,10))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(39),wf4(:,4),wf4(:,8),G1tensor(64),m4h4x4x1(:,11),heltab3x16(:,:,11))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(48),wf4(:,4),wf4(:,10),G1tensor(70),m4h4x4x1(:,12),heltab3x16(:,:,12))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(61),wf4(:,1),G1tensor(76),m3h4x1(:,153),heltab2x4(:,:,270))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(85),wf4(:,4),G1tensor(83),m3h4x1(:,154),heltab2x4(:,:,271))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(135),28,wf4(:,1),3,G2tensor(96),m3h4x1(:,155),heltab2x4(:,:,272))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(138),28,wf4(:,4),3,G2tensor(97),m3h4x1(:,156),heltab2x4(:,:,273))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(148),28,wf4(:,1),3,G2tensor(98),m3h4x1(:,157),heltab2x4(:,:,274))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(150),28,wf4(:,4),3,G2tensor(107),m3h4x1(:,158),heltab2x4(:,:,275))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(251),wf4(:,13),G1tensor(94),m3h4x1(:,159),heltab2x4(:,:,276))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(262),wf4(:,13),G1tensor(105),m3h4x1(:,160),heltab2x4(:,:,277))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(294),19,wf4(:,8),12,G2tensor(108),m3h4x1(:,161),heltab2x4(:,:,278))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(296),19,wf4(:,10),12,G2tensor(109),m3h4x1(:,162),heltab2x4(:,:,279))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(307),19,wf4(:,8),12,G2tensor(110),m3h4x1(:,163),heltab2x4(:,:,280))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(308),19,wf4(:,10),12,G2tensor(111),m3h4x1(:,164),heltab2x4(:,:,281))
  call Hloop_SA_Q(ntryL,G0H8(40),wf8(:,52),G0H1(1),ngH,m3h8x1(:,33),heltab2x8(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(121),n2h1(315))
  call Hloop_SA_Q(ntryL,G0H8(9),wf8(:,52),G0H1(1),ngX,m3h8x1(:,34),heltab2x8(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(126),n2h1(316))
  call Hloop_SA_Q(ntryL,G0H8(10),wf8(:,52),G0H1(1),ngPbt,m3h8x1(:,35),heltab2x8(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(131),n2h1(317))
  call Hloop_SA_Q(ntryL,G0H8(36),wf8(:,53),G0H1(1),ngH,m3h8x1(:,36),heltab2x8(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(136),n2h1(318))
  call Hloop_SA_Q(ntryL,G0H8(37),wf8(:,53),G0H1(1),ngX,m3h8x1(:,37),heltab2x8(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(141),n2h1(319))
  call Hloop_SA_Q(ntryL,G0H8(38),wf8(:,53),G0H1(1),ngPbt,m3h8x1(:,38),heltab2x8(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(146),n2h1(320))
  call Hloop_VA_Q(ntryL,G0H8(32),wf8(:,52),G0H1(1),m3h8x1(:,39),heltab2x8(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(151),n2h1(321))
  call Hloop_ZA_Q(ntryL,G0H8(34),wf8(:,52),G0H1(1),ngZd,m3h8x1(:,40),heltab2x8(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(156),n2h1(322))
  call Hloop_WA_Q(ntryL,G0H8(3),wf8(:,52),G0H1(1),m3h8x1(:,41),heltab2x8(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(161),n2h1(323))
  call Hloop_VA_Q(ntryL,G0H8(22),wf8(:,53),G0H1(1),m3h8x1(:,42),heltab2x8(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(166),n2h1(324))
  call Hloop_ZA_Q(ntryL,G0H8(25),wf8(:,53),G0H1(1),ngZd,m3h8x1(:,43),heltab2x8(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(171),n2h1(325))
  call Hloop_WA_Q(ntryL,G0H8(21),wf8(:,53),G0H1(1),m3h8x1(:,44),heltab2x8(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(176),n2h1(326))
  call Hloop_QV_A(ntryL,G1H4(105),wf4(:,1),G1H1(1),m3h4x1(:,165),heltab2x4(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(112),n2h1(327))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,1),G1H1(1),m3h4x1(:,166),heltab2x4(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(113),n2h1(328))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,1),G1H1(1),m3h4x1(:,167),heltab2x4(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(114),n2h1(329))
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,1),G1H1(1),m3h4x1(:,168),heltab2x4(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(330))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,1),G1H1(1),m3h4x1(:,169),heltab2x4(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(331))
  call Hloop_QZ_A(ntryL,G1H4(127),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,170),heltab2x4(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(131),n2h1(332))
  call Hloop_QZ_A(ntryL,G1H4(128),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,171),heltab2x4(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(143),n2h1(333))
  call Hloop_QZ_A(ntryL,G1H4(129),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,172),heltab2x4(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(146),n2h1(334))
  call Hloop_QZ_A(ntryL,G1H4(131),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,173),heltab2x4(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(140),n2h1(335))
  call Hloop_QZ_A(ntryL,G1H4(133),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,174),heltab2x4(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(149),n2h1(336))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(137),28,wf4(:,4),3,G2tensor(161),m3h4x1(:,175),heltab2x4(:,:,292))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(142),28,wf4(:,1),3,G2tensor(164),m3h4x1(:,176),heltab2x4(:,:,293))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(146),28,wf4(:,4),3,G2tensor(158),m3h4x1(:,177),heltab2x4(:,:,294))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(12),wf4(:,4),G1tensor(181),m3h4x1(:,178),heltab2x4(:,:,295))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,1),G1H1(1),m3h4x1(:,179),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(337))
  call Hloop_QZ_A(ntryL,G1H4(130),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,180),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(338))
  call Hloop_QZ_A(ntryL,G1H4(132),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,181),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(339))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,182),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(340))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(53),wf8(:,57),G1tensor(186),ngH,m3h8x1(:,45),heltab2x8(:,:,239))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(54),wf8(:,57),G1tensor(191),ngX,m3h8x1(:,46),heltab2x8(:,:,240))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(55),wf8(:,57),G1tensor(196),ngPtb,m3h8x1(:,47),heltab2x8(:,:,241))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(56),wf8(:,58),G1tensor(201),ngH,m3h8x1(:,48),heltab2x8(:,:,242))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(57),wf8(:,58),G1tensor(206),ngX,m3h8x1(:,49),heltab2x8(:,:,243))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(58),wf8(:,58),G1tensor(211),ngPtb,m3h8x1(:,50),heltab2x8(:,:,244))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(51),wf8(:,57),G1tensor(216),m3h8x1(:,51),heltab2x8(:,:,245))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(52),wf8(:,57),G1tensor(221),ngZd,m3h8x1(:,52),heltab2x8(:,:,246))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(22),wf8(:,57),G1tensor(226),m3h8x1(:,53),heltab2x8(:,:,247))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(16),wf8(:,58),G1tensor(231),m3h8x1(:,54),heltab2x8(:,:,248))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(12),wf8(:,58),G1tensor(236),ngZd,m3h8x1(:,55),heltab2x8(:,:,249))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(8),wf8(:,58),G1tensor(241),m3h8x1(:,56),heltab2x8(:,:,250))
  call Hloop_QS_A(ntryL,G1H4(240),wf4(:,13),G1H1(1),ngH,m3h4x1(:,183),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(209),n2h1(341))
  call Hloop_QS_A(ntryL,G1H4(241),wf4(:,13),G1H1(1),ngH,m3h4x1(:,184),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(212),n2h1(342))
  call Hloop_QS_A(ntryL,G1H4(242),wf4(:,13),G1H1(1),ngH,m3h4x1(:,185),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(215),n2h1(343))
  call Hloop_QS_A(ntryL,G1H4(243),wf4(:,13),G1H1(1),ngH,m3h4x1(:,186),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(344))
  call Hloop_QS_A(ntryL,G1H4(244),wf4(:,13),G1H1(1),ngH,m3h4x1(:,187),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(106),n2h1(345))
  call Hloop_QS_A(ntryL,G1H4(245),wf4(:,52),G1H1(1),ngX,m3h4x1(:,188),heltab2x4(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(60),n2h1(346))
  call Hloop_QS_A(ntryL,G1H4(246),wf4(:,52),G1H1(1),ngX,m3h4x1(:,189),heltab2x4(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(105),n2h1(347))
  call Hloop_QS_A(ntryL,G1H4(247),wf4(:,52),G1H1(1),ngX,m3h4x1(:,190),heltab2x4(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(104),n2h1(348))
  call Hloop_QS_A(ntryL,G1H4(248),wf4(:,52),G1H1(1),ngX,m3h4x1(:,191),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(54),n2h1(349))
  call Hloop_QS_A(ntryL,G1H4(249),wf4(:,52),G1H1(1),ngX,m3h4x1(:,192),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(350))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(252),wf4(:,52),G1tensor(246),m3h4x1(:,193),heltab2x4(:,:,310))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(258),wf4(:,13),G1tensor(251),m3h4x1(:,194),heltab2x4(:,:,311))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(260),wf4(:,52),G1tensor(256),m3h4x1(:,195),heltab2x4(:,:,312))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H4(96),19,wf4(:,13),12,G1tensor(261),m3h4x1(:,196),heltab2x4(:,:,313))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H4(99),19,wf4(:,52),12,G1tensor(266),m3h4x1(:,197),heltab2x4(:,:,314))
  call Hcheck_last_VS_T(ntryL,l_switch,G0H4(97),19,wf4(:,52),12,G1tensor(271),m3h4x1(:,198),heltab2x4(:,:,315))
  call Hloop_QV_A(ntryL,G1H4(277),wf4(:,8),G1H1(1),m3h4x1(:,199),heltab2x4(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(48),n2h1(351))
  call Hloop_QV_A(ntryL,G1H4(278),wf4(:,8),G1H1(1),m3h4x1(:,200),heltab2x4(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(78),n2h1(352))
  call Hloop_QV_A(ntryL,G1H4(279),wf4(:,8),G1H1(1),m3h4x1(:,201),heltab2x4(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(102),n2h1(353))
  call Hloop_QV_A(ntryL,G1H4(282),wf4(:,8),G1H1(1),m3h4x1(:,202),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(118),n2h1(354))
  call Hloop_QV_A(ntryL,G1H4(281),wf4(:,8),G1H1(1),m3h4x1(:,203),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(355))
  call Hloop_QV_A(ntryL,G1H4(283),wf4(:,8),G1H1(1),m3h4x1(:,204),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(116),n2h1(356))
  call Hloop_QZ_A(ntryL,G1H4(285),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,205),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(115),n2h1(357))
  call Hloop_QZ_A(ntryL,G1H4(286),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,206),heltab2x4(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(62),n2h1(358))
  call Hloop_QZ_A(ntryL,G1H4(287),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,207),heltab2x4(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(43),n2h1(359))
  call Hloop_QZ_A(ntryL,G1H4(288),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,208),heltab2x4(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(360))
  call Hloop_QZ_A(ntryL,G1H4(289),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,209),heltab2x4(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(122),n2h1(361))
  call Hloop_QZ_A(ntryL,G1H4(290),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,210),heltab2x4(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(362))
  call Hloop_QZ_A(ntryL,G1H4(291),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,211),heltab2x4(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(363))
  call Hloop_QZ_A(ntryL,G1H4(284),wf4(:,10),G1H1(1),ngZn,m3h4x1(:,212),heltab2x4(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(199),n2h1(364))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(295),19,wf4(:,10),12,G2tensor(196),m3h4x1(:,213),heltab2x4(:,:,330))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(302),19,wf4(:,8),12,G2tensor(124),m3h4x1(:,214),heltab2x4(:,:,331))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(304),19,wf4(:,10),12,G2tensor(126),m3h4x1(:,215),heltab2x4(:,:,332))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(105),wf4(:,8),G0tensor(111),m3h4x1(:,216),heltab2x4(:,:,333))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(108),wf4(:,10),G0tensor(141),m3h4x1(:,217),heltab2x4(:,:,334))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(106),wf4(:,10),G0tensor(166),m3h4x1(:,218),heltab2x4(:,:,335))
  call Hloop_VA_Q(ntryL,G0H8(18),wf8(:,60),G0H1(1),m3h8x1(:,57),heltab2x8(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(276),n2h1(365))
  call Hloop_ZA_Q(ntryL,G0H8(19),wf8(:,60),G0H1(1),ngZu,m3h8x1(:,58),heltab2x8(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(281),n2h1(366))
  call Hloop_WA_Q(ntryL,G0H8(31),wf8(:,60),G0H1(1),m3h8x1(:,59),heltab2x8(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(286),n2h1(367))
  call Hloop_VA_Q(ntryL,G0H8(14),wf8(:,62),G0H1(1),m3h8x1(:,60),heltab2x8(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(291),n2h1(368))
  call Hloop_ZA_Q(ntryL,G0H8(41),wf8(:,62),G0H1(1),ngZu,m3h8x1(:,61),heltab2x8(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(296),n2h1(369))
  call Hloop_WA_Q(ntryL,G0H8(42),wf8(:,62),G0H1(1),m3h8x1(:,62),heltab2x8(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(301),n2h1(370))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(49),wf8(:,64),G1tensor(306),m3h8x1(:,63),heltab2x8(:,:,257))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(9),wf8(:,64),G1tensor(311),ngZu,m3h8x1(:,64),heltab2x8(:,:,258))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(47),wf8(:,64),G1tensor(316),m3h8x1(:,65),heltab2x8(:,:,259))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(35),wf8(:,66),G1tensor(321),m3h8x1(:,66),heltab2x8(:,:,260))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(31),wf8(:,66),G1tensor(326),ngZu,m3h8x1(:,67),heltab2x8(:,:,261))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(5),wf8(:,66),G1tensor(331),m3h8x1(:,68),heltab2x8(:,:,262))
  call ol_merge_tensors(G2tensor(158),[G2tensor(164),G2tensor(107),G2tensor(98),G2tensor(97),G2tensor(96),G1tensor(83) &
    ,G1tensor(76),G0tensor(28),G0tensor(23),G0tensor(152),G0tensor(510),G0tensor(91),G0tensor(6)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(124),G2tensor(111),G2tensor(110),G2tensor(109),G2tensor(108),G1tensor(266) &
    ,G1tensor(261),G1tensor(256),G1tensor(251),G1tensor(105),G1tensor(94),G0tensor(141),G0tensor(111),G0tensor(255),G0tensor(227) &
    ,G0tensor(60),G0tensor(192),G0tensor(151),G0tensor(11)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(64),G1tensor(45),G1tensor(33),G1tensor(59),G1tensor(47),G1tensor(10),G1tensor(4) &
    ,G0tensor(81),G0tensor(56),G0tensor(26),G0tensor(1),G0tensor(295),G0tensor(42),G0tensor(32),G0tensor(8),G0tensor(71) &
    ,G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(848),[G0tensor(768),G0tensor(763),G0tensor(757),G0tensor(684),G0tensor(678),G0tensor(673) &
    ,G0tensor(534),G0tensor(509),G0tensor(478),G0tensor(172),G0tensor(357),G0tensor(117),G0tensor(317),G0tensor(280),G0tensor(528) &
    ,G0tensor(277),G0tensor(418),G0tensor(62),G0tensor(368),G0tensor(58),G0tensor(237),G0tensor(38),G0tensor(230),G0tensor(27) &
    ,G0tensor(212),G0tensor(20),G0tensor(14),G0tensor(22),G0tensor(2),G0tensor(532),G0tensor(527),G0tensor(235),G0tensor(502) &
    ,G0tensor(436),G0tensor(296),G0tensor(186),G0tensor(161),G0tensor(136),G0tensor(101),G0tensor(76),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(681),[G0tensor(670),G0tensor(150),G0tensor(310),G0tensor(432),G0tensor(207),G0tensor(215) &
    ,G0tensor(31)])
  call ol_merge_tensors(G0tensor(322),[G0tensor(291),G0tensor(36)])
  call ol_merge_tensors(G0tensor(847),[G0tensor(769),G0tensor(762),G0tensor(756),G0tensor(690),G0tensor(685),G0tensor(679) &
    ,G0tensor(672),G0tensor(518),G0tensor(539),G0tensor(489),G0tensor(474),G0tensor(133),G0tensor(153),G0tensor(393),G0tensor(423) &
    ,G0tensor(250),G0tensor(44),G0tensor(232),G0tensor(30),G0tensor(447),G0tensor(24),G0tensor(442),G0tensor(441),G0tensor(326) &
    ,G0tensor(301),G0tensor(131),G0tensor(106),G0tensor(51)])
  call ol_merge_tensors(G0tensor(498),[G0tensor(469),G0tensor(87),G0tensor(43),G0tensor(375),G0tensor(61)])
  call ol_merge_tensors(G0tensor(767),[G0tensor(84),G0tensor(29),G0tensor(66)])
  call ol_merge_tensors(G0tensor(766),[G0tensor(468),G0tensor(129),G0tensor(47),G0tensor(452),G0tensor(426),G0tensor(116) &
    ,G0tensor(86)])
  call ol_merge_tensors(G1tensor(241),[G1tensor(226),G1tensor(211),G1tensor(196),G0tensor(488),G0tensor(64),G0tensor(431) &
    ,G0tensor(96)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(161),G1tensor(146),G1tensor(131),G0tensor(508),G0tensor(40),G0tensor(65) &
    ,G0tensor(121)])
  call ol_merge_tensors(G0tensor(514),[G0tensor(110),G0tensor(265),G0tensor(321),G0tensor(126)])
  call ol_merge_tensors(G0tensor(669),[G0tensor(540),G0tensor(487),G0tensor(171),G0tensor(146)])
  call ol_merge_tensors(G1tensor(331),[G1tensor(316),G0tensor(677),G0tensor(353),G0tensor(175),G0tensor(156)])
  call ol_merge_tensors(G1tensor(301),[G1tensor(286),G0tensor(683),G0tensor(238),G0tensor(59),G0tensor(176)])
  call ol_merge_tensors(G0tensor(831),[G0tensor(816),G0tensor(714),G0tensor(689),G0tensor(615),G0tensor(367),G0tensor(67) &
    ,G0tensor(530),G0tensor(145),G0tensor(515),G0tensor(500),G0tensor(505),G0tensor(181)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(123),G0tensor(451),G0tensor(391),G0tensor(361),G0tensor(336),G0tensor(251) &
    ,G0tensor(226),G0tensor(196)])
  call ol_merge_tensors(G0tensor(499),[G0tensor(300),G0tensor(201)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(206)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(219),G0tensor(374),G0tensor(208),G0tensor(370),G0tensor(139),G0tensor(127) &
    ,G0tensor(302),G0tensor(383),G0tensor(68),G0tensor(4),G0tensor(531),G0tensor(501),G0tensor(376),G0tensor(211)])
  call ol_merge_tensors(G0tensor(940),[G0tensor(935),G0tensor(929),G0tensor(923),G0tensor(917),G0tensor(911),G0tensor(906) &
    ,G0tensor(901),G0tensor(896),G0tensor(890),G0tensor(874),G0tensor(864),G0tensor(858),G0tensor(853),G0tensor(821),G0tensor(808) &
    ,G0tensor(802),G0tensor(796),G0tensor(790),G0tensor(784),G0tensor(779),G0tensor(774),G0tensor(751),G0tensor(745),G0tensor(739) &
    ,G0tensor(732),G0tensor(727),G0tensor(721),G0tensor(715),G0tensor(710),G0tensor(705),G0tensor(700),G0tensor(695),G0tensor(662) &
    ,G0tensor(656),G0tensor(645),G0tensor(638),G0tensor(628),G0tensor(622),G0tensor(616),G0tensor(611),G0tensor(606),G0tensor(601) &
    ,G0tensor(596),G0tensor(586),G0tensor(574),G0tensor(563),G0tensor(558),G0tensor(553),G0tensor(548),G0tensor(543),G0tensor(463) &
    ,G0tensor(425),G0tensor(419),G0tensor(392),G0tensor(384),G0tensor(389),G0tensor(333),G0tensor(313),G0tensor(359),G0tensor(298) &
    ,G0tensor(349),G0tensor(283),G0tensor(274),G0tensor(494),G0tensor(407),G0tensor(362),G0tensor(263),G0tensor(360),G0tensor(347) &
    ,G0tensor(132),G0tensor(335),G0tensor(332),G0tensor(312),G0tensor(107),G0tensor(94),G0tensor(89),G0tensor(260),G0tensor(57) &
    ,G0tensor(49),G0tensor(190),G0tensor(245),G0tensor(460),G0tensor(526),G0tensor(496),G0tensor(466),G0tensor(411),G0tensor(381) &
    ,G0tensor(351),G0tensor(271),G0tensor(241),G0tensor(216)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(116),G2tensor(103),G2tensor(106),G0tensor(268),G0tensor(128),G0tensor(248) &
    ,G0tensor(113),G0tensor(428),G0tensor(104),G0tensor(231)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(319),G0tensor(123),G0tensor(118),G0tensor(98),G0tensor(109),G0tensor(72) &
    ,G0tensor(240),G0tensor(205),G0tensor(45),G0tensor(521),G0tensor(236)])
  call ol_merge_tensors(G0tensor(861),[G0tensor(818),G0tensor(659),G0tensor(625),G0tensor(619),G0tensor(209),G0tensor(95) &
    ,G0tensor(256)])
  call ol_merge_tensors(G0tensor(388),[G0tensor(261)])
  call ol_merge_tensors(G0tensor(941),[G0tensor(930),G0tensor(924),G0tensor(918),G0tensor(912),G0tensor(895),G0tensor(885) &
    ,G0tensor(880),G0tensor(875),G0tensor(869),G0tensor(863),G0tensor(842),G0tensor(837),G0tensor(832),G0tensor(827),G0tensor(822) &
    ,G0tensor(803),G0tensor(797),G0tensor(791),G0tensor(785),G0tensor(750),G0tensor(744),G0tensor(738),G0tensor(733),G0tensor(726) &
    ,G0tensor(720),G0tensor(667),G0tensor(661),G0tensor(655),G0tensor(650),G0tensor(644),G0tensor(639),G0tensor(633),G0tensor(627) &
    ,G0tensor(621),G0tensor(591),G0tensor(585),G0tensor(580),G0tensor(575),G0tensor(569),G0tensor(564),G0tensor(462),G0tensor(440) &
    ,G0tensor(444),G0tensor(430),G0tensor(409),G0tensor(387),G0tensor(394),G0tensor(377),G0tensor(334),G0tensor(308),G0tensor(223) &
    ,G0tensor(269),G0tensor(228),G0tensor(178),G0tensor(155),G0tensor(138),G0tensor(350),G0tensor(140),G0tensor(102),G0tensor(427) &
    ,G0tensor(52),G0tensor(105),G0tensor(517),G0tensor(480),G0tensor(470),G0tensor(50),G0tensor(465),G0tensor(491),G0tensor(406) &
    ,G0tensor(266)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(121),G0tensor(272),G0tensor(421),G0tensor(311),G0tensor(281)])
  call ol_merge_tensors(G0tensor(844),[G0tensor(676),G0tensor(320),G0tensor(37),G0tensor(200),G0tensor(286)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(117),G2tensor(54),G2tensor(1),G0tensor(352),G0tensor(103),G0tensor(316)])
  call ol_merge_tensors(G0tensor(856),[G0tensor(805),G0tensor(642),G0tensor(604),G0tensor(599),G0tensor(327),G0tensor(341)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(346)])
  call ol_merge_tensors(G0tensor(258),[G0tensor(511),G0tensor(476),G0tensor(366)])
  call ol_merge_tensors(G1tensor(201),[G1tensor(186),G0tensor(398),G0tensor(9),G0tensor(371)])
  call ol_merge_tensors(G0tensor(893),[G0tensor(748),G0tensor(724),G0tensor(718),G0tensor(560),G0tensor(450),G0tensor(414) &
    ,G0tensor(385),G0tensor(355),G0tensor(10),G0tensor(180),G0tensor(396)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(221),G1tensor(206),G1tensor(191),G0tensor(584),G0tensor(538),G0tensor(380) &
    ,G0tensor(382),G0tensor(348),G0tensor(486),G0tensor(401)])
  call ol_merge_tensors(G0tensor(888),[G0tensor(736),G0tensor(703),G0tensor(698),G0tensor(533),G0tensor(513),G0tensor(354) &
    ,G0tensor(344),G0tensor(134),G0tensor(55),G0tensor(456)])
  call ol_merge_tensors(G1tensor(231),[G1tensor(216),G0tensor(547),G0tensor(439),G0tensor(294),G0tensor(318),G0tensor(170) &
    ,G0tensor(461)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(181),G0tensor(264),G0tensor(257),G0tensor(481)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(121),G0tensor(275),G0tensor(516)])
  call ol_merge_tensors(G0tensor(199),[G0tensor(142),G0tensor(160)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(156),G1tensor(141),G1tensor(126),G0tensor(801),G0tensor(795),G0tensor(573) &
    ,G0tensor(435),G0tensor(408),G0tensor(242)])
  call ol_merge_tensors(G0tensor(932),[G0tensor(692),G0tensor(630),G0tensor(593),G0tensor(567),G0tensor(546),G0tensor(338) &
    ,G0tensor(304),G0tensor(288),G0tensor(210),G0tensor(35),G0tensor(120),G0tensor(115)])
  call ol_merge_tensors(G0tensor(903),[G0tensor(866),G0tensor(850),G0tensor(835),G0tensor(815),G0tensor(811),G0tensor(806) &
    ,G0tensor(771),G0tensor(577),G0tensor(550),G0tensor(541),G0tensor(415),G0tensor(284),G0tensor(73),G0tensor(187),G0tensor(70) &
    ,G0tensor(3)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(188),G2tensor(185),G2tensor(173),G0tensor(898),G0tensor(776),G0tensor(303) &
    ,G0tensor(143),G0tensor(7),G0tensor(90),G0tensor(512),G0tensor(497),G0tensor(475),G0tensor(525)])
  call ol_merge_tensors(G1tensor(291),[G1tensor(276),G0tensor(889),G0tensor(879),G0tensor(857),G0tensor(826),G0tensor(812) &
    ,G0tensor(709),G0tensor(610),G0tensor(79),G0tensor(467)])
  call ol_merge_tensors(G0tensor(729),[G0tensor(664),G0tensor(647),G0tensor(635),G0tensor(589),G0tensor(583),G0tensor(578) &
    ,G0tensor(477),G0tensor(490)])
  call ol_merge_tensors(G0tensor(914),[G0tensor(840),G0tensor(830),G0tensor(825),G0tensor(819),G0tensor(588),G0tensor(571) &
    ,G0tensor(566),G0tensor(561),G0tensor(157),G0tensor(485)])
  call ol_merge_tensors(G1tensor(296),[G1tensor(281),G0tensor(841),G0tensor(836),G0tensor(743),G0tensor(654),G0tensor(162) &
    ,G0tensor(458)])
  call ol_merge_tensors(G0tensor(845),[G0tensor(753),G0tensor(164),G0tensor(77),G0tensor(69),G0tensor(5),G0tensor(537) &
    ,G0tensor(492)])
  call ol_merge_tensors(G0tensor(759),[G0tensor(484),G0tensor(85),G0tensor(99),G0tensor(12),G0tensor(247),G0tensor(167) &
    ,G0tensor(507)])
  call ol_merge_tensors(G1tensor(321),[G1tensor(306),G0tensor(814),G0tensor(704),G0tensor(649),G0tensor(605),G0tensor(34) &
    ,G0tensor(13)])
  call ol_merge_tensors(G0tensor(882),[G0tensor(877),G0tensor(871),G0tensor(781),G0tensor(434),G0tensor(438),G0tensor(329) &
    ,G0tensor(325),G0tensor(290)])
  call ol_merge_tensors(G0tensor(937),[G0tensor(454),G0tensor(449),G0tensor(390),G0tensor(453),G0tensor(243),G0tensor(130)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(315)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(378),G0tensor(53)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(151),G0tensor(789),G0tensor(778),G0tensor(552),G0tensor(364),G0tensor(15)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(120),G2tensor(40),G2tensor(118),G0tensor(810),G0tensor(699),G0tensor(600) &
    ,G0tensor(177),G0tensor(159),G0tensor(154),G0tensor(413),G0tensor(282),G0tensor(82),G0tensor(267),G0tensor(195)])
  call ol_merge_tensors(G0tensor(755),[G0tensor(78),G0tensor(25),G0tensor(39)])
  call ol_merge_tensors(G0tensor(760),[G0tensor(403),G0tensor(54),G0tensor(33),G0tensor(222)])
  call ol_merge_tensors(G0tensor(794),[G0tensor(777),G0tensor(772),G0tensor(717),G0tensor(707),G0tensor(697),G0tensor(693) &
    ,G0tensor(273),G0tensor(48)])
  call ol_merge_tensors(G0tensor(800),[G0tensor(788),G0tensor(782),G0tensor(747),G0tensor(741),G0tensor(735),G0tensor(730) &
    ,G0tensor(345),G0tensor(63),G0tensor(343)])
  call ol_merge_tensors(G0tensor(214),[G0tensor(194),G0tensor(297),G0tensor(285)])
  call ol_merge_tensors(G0tensor(927),[G0tensor(921),G0tensor(872),G0tensor(658),G0tensor(652),G0tensor(641),G0tensor(636) &
    ,G0tensor(229),G0tensor(213),G0tensor(307),G0tensor(433)])
  call ol_merge_tensors(G0tensor(909),[G0tensor(899),G0tensor(851),G0tensor(618),G0tensor(608),G0tensor(598),G0tensor(594) &
    ,G0tensor(330),G0tensor(158)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(342),G0tensor(253)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(112),G0tensor(183)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(48),G2tensor(60),G2tensor(209),G0tensor(174)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(113),G0tensor(397)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(78),G2tensor(105),G2tensor(212),G0tensor(218)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(114),G0tensor(198)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(102),G2tensor(104),G2tensor(215),G0tensor(189)])
  call ol_merge_tensors(G0tensor(939),[G0tensor(928),G0tensor(916),G0tensor(910),G0tensor(412)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(271),G1tensor(246),G0tensor(166),G0tensor(244)])
  call ol_merge_tensors(G0tensor(443),[G0tensor(448),G0tensor(369),G0tensor(289),G0tensor(279)])
  call ol_merge_tensors(G0tensor(892),[G0tensor(887),G0tensor(783),G0tensor(773),G0tensor(424),G0tensor(323),G0tensor(299)])
  call ol_merge_tensors(G0tensor(920),[G0tensor(787),G0tensor(579),G0tensor(400),G0tensor(339)])
  call ol_merge_tensors(G0tensor(908),[G0tensor(793),G0tensor(568),G0tensor(404),G0tensor(395)])
  call ol_merge_tensors(G0tensor(926),[G0tensor(799),G0tensor(590),G0tensor(457),G0tensor(445)])
  call ol_merge_tensors(G0tensor(524),[G0tensor(483),G0tensor(473)])
  call ol_merge_tensors(G0tensor(765),[G0tensor(761),G0tensor(519),G0tensor(503)])
  call ol_merge_tensors(G0tensor(742),[G0tensor(713),G0tensor(708),G0tensor(582),G0tensor(562),G0tensor(555),G0tensor(545) &
    ,G0tensor(542)])
  call ol_merge_tensors(G0tensor(731),[G0tensor(723),G0tensor(712),G0tensor(702),G0tensor(694),G0tensor(572),G0tensor(556) &
    ,G0tensor(551)])
  call ol_merge_tensors(G0tensor(915),[G0tensor(904),G0tensor(637),G0tensor(624),G0tensor(613),G0tensor(603),G0tensor(595)])
  call ol_merge_tensors(G0tensor(820),[G0tensor(807),G0tensor(653),G0tensor(614),G0tensor(609)])
  call ol_merge_tensors(G0tensor(867),[G0tensor(824),G0tensor(719),G0tensor(631),G0tensor(620)])
  call ol_merge_tensors(G1tensor(326),[G1tensor(311),G0tensor(829),G0tensor(725),G0tensor(666),G0tensor(632),G0tensor(626)])
  call ol_merge_tensors(G0tensor(878),[G0tensor(834),G0tensor(737),G0tensor(648),G0tensor(643)])
  call ol_merge_tensors(G0tensor(883),[G0tensor(839),G0tensor(749),G0tensor(665),G0tensor(660)])
  call ol_merge_tensors(G0tensor(754),[G0tensor(687),G0tensor(675),G0tensor(671)])
  call ol_merge_tensors(G0tensor(846),[G0tensor(688),G0tensor(682)])
  call ol_merge_tensors(G0tensor(938),[G0tensor(933),G0tensor(873),G0tensor(860),G0tensor(855),G0tensor(852)])
  call ol_merge_tensors(G0tensor(894),[G0tensor(884),G0tensor(868),G0tensor(862)])
  call ol_merge_tensors(G0tensor(934),[G0tensor(922),G0tensor(905),G0tensor(900)])
call TI_bubble_red(G2tensor(158),28,mass2set(:,1),G0tensor(191),M2L1R1,G0tensor(221))
call TI_bubble_red(G2tensor(126),19,mass2set(:,1),G0tensor(246),M2L1R1,G0tensor(276))
call TI_bubble_red(G2tensor(149),28,mass2set(:,2),G0tensor(306),M2L1R1,G0tensor(331))
call TI_bubble_red(G2tensor(77),19,mass2set(:,2),G0tensor(356),M2L1R1,G0tensor(386))
call TI_bubble_red(G2tensor(140),28,mass2set(:,3),G0tensor(416),M2L1R1,G0tensor(446))
call TI_bubble_red(G2tensor(122),19,mass2set(:,3),G0tensor(471),M2L1R1,G0tensor(506))
call TI_bubble_red(G2tensor(161),28,mass2set(:,4),G0tensor(536),M2L1R1,G0tensor(185),G0tensor(337))
call TI_bubble_red(G2tensor(191),28,mass2set(:,5),G0tensor(340),M2L1R1)
call TI_bubble_red(G2tensor(199),19,mass2set(:,5),G0tensor(495),M2L1R1)
call TI_bubble_red(G2tensor(131),28,mass2set(:,6),G0tensor(472),M2L1R1,G0tensor(482))
call TI_bubble_red(G2tensor(115),19,mass2set(:,6),G0tensor(372),M2L1R1,G0tensor(225))
call TI_bubble_red(G2tensor(143),28,mass2set(:,7),G0tensor(437),M2L1R1,G0tensor(305))
call TI_bubble_red(G2tensor(62),19,mass2set(:,7),G0tensor(520),M2L1R1,G0tensor(522))
call TI_bubble_red(G2tensor(146),28,mass2set(:,8),G0tensor(417),M2L1R1,G0tensor(535))
call TI_bubble_red(G2tensor(43),19,mass2set(:,8),G0tensor(165),M2L1R1,G0tensor(17))
call TI_bubble_red(G2tensor(196),19,mass2set(:,9),G0tensor(278),M2L1R1,G0tensor(314),G0tensor(293))
  call ol_merge_tensors(G0tensor(848),[G0tensor(276),G0tensor(221)])
  call ol_merge_tensors(G0tensor(506),[G0tensor(446),G0tensor(847)])
  call ol_merge_tensors(G0tensor(386),[G0tensor(940),G0tensor(331)])
  call ol_merge_tensors(G0tensor(314),[G0tensor(337),G0tensor(239)])
  call ol_merge_tensors(G0tensor(293),[G0tensor(185),G0tensor(941)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(225),G0tensor(482)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(522),G0tensor(305)])
  call ol_merge_tensors(G0tensor(254),[G0tensor(17),G0tensor(535)])
call TI_bubble_red(G1tensor(70),16,mass2set(:,1),G0tensor(324),M2L1R1,G0tensor(309))
call TI_bubble_red(G1tensor(241),24,mass2set(:,10),G0tensor(197),M2L1R1,G0tensor(328),G0tensor(373))
call TI_bubble_red(G1tensor(176),20,mass2set(:,11),G0tensor(379),M2L1R1,G0tensor(405),G0tensor(410))
call TI_bubble_red(G1tensor(331),18,mass2set(:,12),G0tensor(399),M2L1R1,G0tensor(420))
call TI_bubble_red(G1tensor(301),17,mass2set(:,13),G0tensor(429),M2L1R1,G0tensor(455))
call TI_bubble_red(G1tensor(201),24,mass2set(:,14),G0tensor(464),M2L1R1,G0tensor(479),G0tensor(493))
call TI_bubble_red(G1tensor(236),24,mass2set(:,15),G0tensor(529),M2L1R1,G0tensor(523),G0tensor(544))
call TI_bubble_red(G1tensor(231),24,mass2set(:,16),G0tensor(549),M2L1R1,G0tensor(554))
call TI_bubble_red(G1tensor(136),20,mass2set(:,17),G0tensor(559),M2L1R1,G0tensor(565),G0tensor(570))
call TI_bubble_red(G1tensor(171),20,mass2set(:,18),G0tensor(576),M2L1R1,G0tensor(581),G0tensor(587))
call TI_bubble_red(G1tensor(291),17,mass2set(:,5),G0tensor(592),M2L1R1)
call TI_bubble_red(G1tensor(296),17,mass2set(:,19),G0tensor(597),M2L1R1,G0tensor(602))
call TI_bubble_red(G1tensor(321),18,mass2set(:,5),G0tensor(18),M2L1R1)
call TI_bubble_red(G1tensor(166),20,mass2set(:,20),G0tensor(607),M2L1R1,G0tensor(612))
call TI_bubble_red(G1tensor(326),18,mass2set(:,21),G0tensor(617),M2L1R1,G0tensor(623))
  call ol_merge_tensors(G0tensor(455),[G0tensor(420),G0tensor(410),G0tensor(328),G0tensor(309),G0tensor(848)])
  call ol_merge_tensors(G0tensor(405),[G0tensor(373),G0tensor(506)])
  call ol_merge_tensors(G0tensor(612),[G0tensor(581),G0tensor(565),G0tensor(554),G0tensor(544),G0tensor(493),G0tensor(386)])
  call ol_merge_tensors(G0tensor(570),[G0tensor(479),G0tensor(314)])
  call ol_merge_tensors(G0tensor(623),[G0tensor(602),G0tensor(587),G0tensor(523),G0tensor(293)])
  call ol_merge_tensors(T0sum(281),[G0tensor(191)])
  call ol_merge_tensors(T0sum(282),[G0tensor(455)])
  call ol_merge_tensors(T0sum(283),[G0tensor(246)])
  call ol_merge_tensors(T0sum(284),[G0tensor(324)])
  call ol_merge_tensors(T0sum(285),[G0tensor(681)])
  call ol_merge_tensors(T0sum(286),[G0tensor(322)])
  call ol_merge_tensors(T0sum(287),[G0tensor(405)])
  call ol_merge_tensors(T0sum(288),[G0tensor(498)])
  call ol_merge_tensors(T0sum(289),[G0tensor(767)])
  call ol_merge_tensors(T0sum(290),[G0tensor(766)])
  call ol_merge_tensors(T0sum(291),[G0tensor(197)])
  call ol_merge_tensors(T0sum(292),[G0tensor(379)])
  call ol_merge_tensors(T0sum(293),[G0tensor(514)])
  call ol_merge_tensors(T0sum(294),[G0tensor(669)])
  call ol_merge_tensors(T0sum(295),[G0tensor(399)])
  call ol_merge_tensors(T0sum(296),[G0tensor(429)])
  call ol_merge_tensors(T0sum(297),[G0tensor(831)])
  call ol_merge_tensors(T0sum(298),[G0tensor(306)])
  call ol_merge_tensors(T0sum(299),[G0tensor(612)])
  call ol_merge_tensors(T0sum(300),[G0tensor(499)])
  call ol_merge_tensors(T0sum(301),[G0tensor(93)])
  call ol_merge_tensors(T0sum(302),[G0tensor(570)])
  call ol_merge_tensors(T0sum(303),[G0tensor(356)])
  call ol_merge_tensors(T0sum(304),[G0tensor(557)])
  call ol_merge_tensors(T0sum(305),[G0tensor(861)])
  call ol_merge_tensors(T0sum(306),[G0tensor(388)])
  call ol_merge_tensors(T0sum(307),[G0tensor(623)])
  call ol_merge_tensors(T0sum(308),[G0tensor(416)])
  call ol_merge_tensors(T0sum(309),[G0tensor(844)])
  call ol_merge_tensors(T0sum(310),[G0tensor(471)])
  call ol_merge_tensors(T0sum(311),[G0tensor(856)])
  call ol_merge_tensors(T0sum(312),[G0tensor(114)])
  call ol_merge_tensors(T0sum(313),[G0tensor(258)])
  call ol_merge_tensors(T0sum(314),[G0tensor(464)])
  call ol_merge_tensors(T0sum(315),[G0tensor(893)])
  call ol_merge_tensors(T0sum(316),[G0tensor(529)])
  call ol_merge_tensors(T0sum(317),[G0tensor(888)])
  call ol_merge_tensors(T0sum(318),[G0tensor(549)])
  call ol_merge_tensors(T0sum(319),[G0tensor(536)])
  call ol_merge_tensors(T0sum(320),[G0tensor(559)])
  call ol_merge_tensors(T0sum(321),[G0tensor(199)])
  call ol_merge_tensors(T0sum(322),[G0tensor(576)])
  call ol_merge_tensors(T0sum(323),[G0tensor(932)])
  call ol_merge_tensors(T0sum(324),[G0tensor(903)])
  call ol_merge_tensors(T0sum(325),[G0tensor(340)])
  call ol_merge_tensors(T0sum(326),[G0tensor(592)])
  call ol_merge_tensors(T0sum(327),[G0tensor(729)])
  call ol_merge_tensors(T0sum(328),[G0tensor(914)])
  call ol_merge_tensors(T0sum(329),[G0tensor(597)])
  call ol_merge_tensors(T0sum(330),[G0tensor(845)])
  call ol_merge_tensors(T0sum(331),[G0tensor(759)])
  call ol_merge_tensors(T0sum(332),[G0tensor(18)])
  call ol_merge_tensors(T0sum(333),[G0tensor(882)])
  call ol_merge_tensors(T0sum(334),[G0tensor(937)])
  call ol_merge_tensors(T0sum(335),[G0tensor(169)])
  call ol_merge_tensors(T0sum(336),[G0tensor(125)])
  call ol_merge_tensors(T0sum(337),[G0tensor(607)])
  call ol_merge_tensors(T0sum(338),[G0tensor(495)])
  call ol_merge_tensors(T0sum(339),[G0tensor(755)])
  call ol_merge_tensors(T0sum(340),[G0tensor(760)])
  call ol_merge_tensors(T0sum(341),[G0tensor(794)])
  call ol_merge_tensors(T0sum(342),[G0tensor(800)])
  call ol_merge_tensors(T0sum(343),[G0tensor(214)])
  call ol_merge_tensors(T0sum(344),[G0tensor(927)])
  call ol_merge_tensors(T0sum(345),[G0tensor(909)])
  call ol_merge_tensors(T0sum(346),[G0tensor(137)])
  call ol_merge_tensors(T0sum(347),[G0tensor(472)])
  call ol_merge_tensors(T0sum(348),[G0tensor(179)])
  call ol_merge_tensors(T0sum(349),[G0tensor(372)])
  call ol_merge_tensors(T0sum(350),[G0tensor(184)])
  call ol_merge_tensors(T0sum(351),[G0tensor(437)])
  call ol_merge_tensors(T0sum(352),[G0tensor(188)])
  call ol_merge_tensors(T0sum(353),[G0tensor(520)])
  call ol_merge_tensors(T0sum(354),[G0tensor(193)])
  call ol_merge_tensors(T0sum(355),[G0tensor(417)])
  call ol_merge_tensors(T0sum(356),[G0tensor(254)])
  call ol_merge_tensors(T0sum(357),[G0tensor(165)])
  call ol_merge_tensors(T0sum(358),[G0tensor(504)])
  call ol_merge_tensors(T0sum(359),[G0tensor(939)])
  call ol_merge_tensors(T0sum(360),[G0tensor(204)])
  call ol_merge_tensors(T0sum(361),[G0tensor(259)])
  call ol_merge_tensors(T0sum(362),[G0tensor(278)])
  call ol_merge_tensors(T0sum(363),[G0tensor(443)])
  call ol_merge_tensors(T0sum(364),[G0tensor(892)])
  call ol_merge_tensors(T0sum(365),[G0tensor(920)])
  call ol_merge_tensors(T0sum(366),[G0tensor(908)])
  call ol_merge_tensors(T0sum(367),[G0tensor(926)])
  call ol_merge_tensors(T0sum(368),[G0tensor(524)])
  call ol_merge_tensors(T0sum(369),[G0tensor(765)])
  call ol_merge_tensors(T0sum(370),[G0tensor(742)])
  call ol_merge_tensors(T0sum(371),[G0tensor(731)])
  call ol_merge_tensors(T0sum(372),[G0tensor(915)])
  call ol_merge_tensors(T0sum(373),[G0tensor(820)])
  call ol_merge_tensors(T0sum(374),[G0tensor(867)])
  call ol_merge_tensors(T0sum(375),[G0tensor(617)])
  call ol_merge_tensors(T0sum(376),[G0tensor(878)])
  call ol_merge_tensors(T0sum(377),[G0tensor(883)])
  call ol_merge_tensors(T0sum(378),[G0tensor(754)])
  call ol_merge_tensors(T0sum(379),[G0tensor(846)])
  call ol_merge_tensors(T0sum(380),[G0tensor(938)])
  call ol_merge_tensors(T0sum(381),[G0tensor(894)])
  call ol_merge_tensors(T0sum(382),[G0tensor(934)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_97,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_127,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_122,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_124,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_97,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 17, 19, 27 ],masses2_97,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 27 ],masses2_127,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 27 ],masses2_122,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 16, 17, 19 ],masses2_124,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 1, 3, 11 ],masses2_97,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 20, 21, 23 ],masses2_87,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 21, 23 ],masses2_104,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 23 ],masses2_104,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 16, 20, 21 ],masses2_104,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 4, 5, 7 ],masses2_87,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 20, 21, 23 ],masses2_91,RedSet_4(11),ScalarBoxes(16))
  call compute_scalar_box([ 16, 21, 23 ],masses2_106,RedSet_4(12),ScalarBoxes(17))
  call compute_scalar_box([ 16, 20, 23 ],masses2_106,RedSet_4(13),ScalarBoxes(18))
  call compute_scalar_box([ 4, 5, 7 ],masses2_91,RedSet_4(15),ScalarBoxes(19))
  call compute_scalar_box([ 20, 21, 23 ],masses2_128,RedSet_4(11),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_112,RedSet_4(13),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_112,RedSet_4(14),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_128,RedSet_4(15),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_129,RedSet_4(11),ScalarBoxes(24))
  call compute_scalar_box([ 16, 20, 23 ],masses2_115,RedSet_4(13),ScalarBoxes(25))
  call compute_scalar_box([ 4, 5, 7 ],masses2_129,RedSet_4(15),ScalarBoxes(26))
  call compute_scalar_box([ 20, 21, 23 ],masses2_123,RedSet_4(11),ScalarBoxes(27))
  call compute_scalar_box([ 16, 21, 23 ],masses2_116,RedSet_4(12),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 23 ],masses2_120,RedSet_4(13),ScalarBoxes(29))
  call compute_scalar_box([ 16, 20, 21 ],masses2_118,RedSet_4(14),ScalarBoxes(30))
  call compute_scalar_box([ 4, 5, 7 ],masses2_123,RedSet_4(15),ScalarBoxes(31))
  call compute_scalar_box([ 20, 22, 23 ],masses2_87,RedSet_4(16),ScalarBoxes(32))
  call compute_scalar_box([ 16, 22, 23 ],masses2_104,RedSet_4(17),ScalarBoxes(33))
  call compute_scalar_box([ 16, 20, 22 ],masses2_104,RedSet_4(18),ScalarBoxes(34))
  call compute_scalar_box([ 4, 6, 7 ],masses2_87,RedSet_4(19),ScalarBoxes(35))
  call compute_scalar_box([ 20, 22, 23 ],masses2_128,RedSet_4(16),ScalarBoxes(36))
  call compute_scalar_box([ 16, 20, 22 ],masses2_112,RedSet_4(18),ScalarBoxes(37))
  call compute_scalar_box([ 4, 6, 7 ],masses2_128,RedSet_4(19),ScalarBoxes(38))
  call compute_scalar_box([ 20, 22, 23 ],masses2_91,RedSet_4(16),ScalarBoxes(39))
  call compute_scalar_box([ 16, 22, 23 ],masses2_106,RedSet_4(17),ScalarBoxes(40))
  call compute_scalar_box([ 4, 6, 7 ],masses2_91,RedSet_4(19),ScalarBoxes(41))
  call compute_scalar_box([ 20, 22, 23 ],masses2_129,RedSet_4(16),ScalarBoxes(42))
  call compute_scalar_box([ 4, 6, 7 ],masses2_129,RedSet_4(19),ScalarBoxes(43))
  call compute_scalar_box([ 17, 21, 29 ],masses2_92,RedSet_4(20),ScalarBoxes(44))
  call compute_scalar_box([ 16, 21, 29 ],masses2_92,RedSet_4(21),ScalarBoxes(45))
  call compute_scalar_box([ 16, 17, 29 ],masses2_86,RedSet_4(22),ScalarBoxes(46))
  call compute_scalar_box([ 16, 17, 21 ],masses2_88,RedSet_4(23),ScalarBoxes(47))
  call compute_scalar_box([ 1, 5, 13 ],masses2_92,RedSet_4(24),ScalarBoxes(48))
  call compute_scalar_box([ 17, 21, 29 ],masses2_93,RedSet_4(20),ScalarBoxes(49))
  call compute_scalar_box([ 16, 21, 29 ],masses2_93,RedSet_4(21),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 29 ],masses2_90,RedSet_4(22),ScalarBoxes(51))
  call compute_scalar_box([ 1, 5, 13 ],masses2_93,RedSet_4(24),ScalarBoxes(52))
  call compute_scalar_box([ 17, 21, 29 ],masses2_130,RedSet_4(20),ScalarBoxes(53))
  call compute_scalar_box([ 16, 17, 29 ],masses2_99,RedSet_4(22),ScalarBoxes(54))
  call compute_scalar_box([ 16, 17, 21 ],masses2_100,RedSet_4(23),ScalarBoxes(55))
  call compute_scalar_box([ 1, 5, 13 ],masses2_130,RedSet_4(24),ScalarBoxes(56))
  call compute_scalar_box([ 17, 21, 29 ],masses2_131,RedSet_4(20),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 29 ],masses2_102,RedSet_4(22),ScalarBoxes(58))
  call compute_scalar_box([ 1, 5, 13 ],masses2_131,RedSet_4(24),ScalarBoxes(59))
  call compute_scalar_box([ 17, 21, 29 ],masses2_126,RedSet_4(20),ScalarBoxes(60))
  call compute_scalar_box([ 16, 21, 29 ],masses2_94,RedSet_4(21),ScalarBoxes(61))
  call compute_scalar_box([ 16, 17, 29 ],masses2_98,RedSet_4(22),ScalarBoxes(62))
  call compute_scalar_box([ 16, 17, 21 ],masses2_96,RedSet_4(23),ScalarBoxes(63))
  call compute_scalar_box([ 1, 5, 13 ],masses2_126,RedSet_4(24),ScalarBoxes(64))
  call compute_scalar_box([ 17, 25, 29 ],masses2_92,RedSet_4(25),ScalarBoxes(65))
  call compute_scalar_box([ 16, 25, 29 ],masses2_92,RedSet_4(26),ScalarBoxes(66))
  call compute_scalar_box([ 16, 17, 25 ],masses2_88,RedSet_4(27),ScalarBoxes(67))
  call compute_scalar_box([ 1, 9, 13 ],masses2_92,RedSet_4(28),ScalarBoxes(68))
  call compute_scalar_box([ 17, 25, 29 ],masses2_93,RedSet_4(25),ScalarBoxes(69))
  call compute_scalar_box([ 16, 25, 29 ],masses2_93,RedSet_4(26),ScalarBoxes(70))
  call compute_scalar_box([ 1, 9, 13 ],masses2_93,RedSet_4(28),ScalarBoxes(71))
  call compute_scalar_box([ 17, 25, 29 ],masses2_130,RedSet_4(25),ScalarBoxes(72))
  call compute_scalar_box([ 16, 17, 25 ],masses2_100,RedSet_4(27),ScalarBoxes(73))
  call compute_scalar_box([ 1, 9, 13 ],masses2_130,RedSet_4(28),ScalarBoxes(74))
  call compute_scalar_box([ 17, 25, 29 ],masses2_131,RedSet_4(25),ScalarBoxes(75))
  call compute_scalar_box([ 1, 9, 13 ],masses2_131,RedSet_4(28),ScalarBoxes(76))
! end of process


end subroutine vamp_4

end module ol_vamp_4_ppajj_ew_uuxbbxa_3_/**/REALKIND
