
module ol_vamp_3_ppajj_ew_ddxagg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_ddxagg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_ddxagg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_ddxagg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_ddxagg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_ddxagg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_ddxagg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call TI_triangle_red(G2tensor(300),RedBasis(7),mass3set(:,5),G0tensor(149),G0tensor(17),G0tensor(184),G0tensor(18),M2L1R1,[nMW], &
    G0tensor(189))
  call TI_triangle_red(G2tensor(105),RedBasis(13),mass3set(:,1),G0tensor(99),G0tensor(89),G0tensor(79),G0tensor(39),M2L1R1)
  call TI_triangle_red(G2tensor(107),RedBasis(12),mass3set(:,1),G0tensor(29),G0tensor(19),G0tensor(331),G0tensor(154),M2L1R1)
  call TI_triangle_red(G2tensor(109),RedBasis(13),mass3set(:,4),G0tensor(27),G0tensor(194),G0tensor(28), &
    G0tensor(341),M2L1R1,[nMZ],G0tensor(159))
  call TI_triangle_red(G2tensor(111),RedBasis(12),mass3set(:,4),G0tensor(37),G0tensor(199),G0tensor(178), &
    G0tensor(38),M2L1R1,[nMZ],G0tensor(254))
  call TI_triangle_red(G2tensor(112),RedBasis(13),mass3set(:,5),G0tensor(204),G0tensor(47),G0tensor(259), &
    G0tensor(209),M2L1R1,[nMW],G0tensor(143))
  call TI_triangle_red(G2tensor(103),RedBasis(12),mass3set(:,5),G0tensor(133),G0tensor(123),G0tensor(68), &
    G0tensor(58),M2L1R1,[nMW],G0tensor(48))
  call TI_triangle_red(G2tensor(275),RedBasis(19),mass3set(:,1),G0tensor(264),G0tensor(214),G0tensor(49),G0tensor(269),M2L1R1)
  call TI_triangle_red(G2tensor(63),RedBasis(18),mass3set(:,1),G0tensor(219),G0tensor(57),G0tensor(274),G0tensor(224),M2L1R1)
  call TI_triangle_red(G2tensor(281),RedBasis(19),mass3set(:,7),G0tensor(59),G0tensor(279),G0tensor(229), &
    G0tensor(67),M2L1R1,[nMZ],G0tensor(284))
  call TI_triangle_red(G2tensor(183),RedBasis(18),mass3set(:,4),G0tensor(234),G0tensor(169),G0tensor(69), &
    G0tensor(261),M2L1R1,[nMZ],G0tensor(104))
  call TI_triangle_red(G2tensor(284),RedBasis(19),mass3set(:,8),G0tensor(77),G0tensor(239),G0tensor(78), &
    G0tensor(271),M2L1R1,[nMW],G0tensor(109))
  call TI_triangle_red(G2tensor(67),RedBasis(18),mass3set(:,5),G0tensor(87),G0tensor(244),G0tensor(88),G0tensor(281),M2L1R1,[nMW], &
    G0tensor(114))
  call TI_triangle_red(G2tensor(100),RedBasis(22),mass3set(:,9),G0tensor(97),G0tensor(249),G0tensor(168), &
    G0tensor(98),M2L1R1,[nMW],G0tensor(319))
  call TI_triangle_red(G2tensor(115),RedBasis(23),mass3set(:,9),G0tensor(289),G0tensor(122),G0tensor(324), &
    G0tensor(294),M2L1R1,[nMW],G0tensor(124))
  call TI_triangle_red(G3tensor(12),RedBasis(8),mass3set(:,10),G0tensor(329),G0tensor(299),G0tensor(132), &
    G0tensor(334),M2L1R1,[nMT],G0tensor(304))
  call TI_triangle_red(G3tensor(14),RedBasis(8),mass3set(:,11),G0tensor(134),G0tensor(339),G0tensor(309), &
    G0tensor(142),M2L1R1,[nMB],G0tensor(344))
  call TI_triangle_red(G3tensor(16),RedBasis(1),mass3set(:,10),G0tensor(314),G0tensor(179),G0tensor(144), &
    G0tensor(349),M2L1R1,[nMT],G0tensor(167))
  call TI_triangle_red(G3tensor(18),RedBasis(1),mass3set(:,11),G0tensor(354),G0tensor(177),G0tensor(369), &
    G0tensor(359),M2L1R1,[nMB],G0tensor(374))
  call TI_triangle_red(G3tensor(55),RedBasis(39),mass3set(:,1),G0tensor(364),G0tensor(379),G0tensor(384),G0tensor(186),M2L1R1)
  call TI_triangle_red(G2tensor(117),RedBasis(42),mass3set(:,1),G0tensor(94),G0tensor(84),G0tensor(74),G0tensor(34),M2L1R1)
  call TI_triangle_red(G2tensor(306),RedBasis(42),mass3set(:,4),G0tensor(24),G0tensor(14),G0tensor(211),G0tensor(44),M2L1R1,[nMZ], &
    G0tensor(221))
  call TI_triangle_red(G2tensor(123),RedBasis(42),mass3set(:,5),G0tensor(54),G0tensor(231),G0tensor(164), &
    G0tensor(64),M2L1R1,[nMW],G0tensor(291))
  call TI_triangle_red(G2tensor(129),RedBasis(47),mass3set(:,1),G0tensor(119),G0tensor(301),G0tensor(129),G0tensor(311),M2L1R1)
  call TI_triangle_red(G2tensor(39),RedBasis(47),mass3set(:,4),G0tensor(174),G0tensor(139),G0tensor(181), &
    G0tensor(13),M2L1R1,[nMZ],G0tensor(191))
  call TI_triangle_red(G2tensor(135),RedBasis(47),mass3set(:,5),G0tensor(23),G0tensor(196),G0tensor(173), &
    G0tensor(33),M2L1R1,[nMW],G0tensor(201))
  call TI_triangle_red(G2tensor(3),RedBasis(40),mass3set(:,1),G0tensor(42),G0tensor(206),G0tensor(138),G0tensor(128),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(40),mass3set(:,4),G0tensor(118),G0tensor(63),G0tensor(53),G0tensor(43),M2L1R1,[nMZ], &
    G0tensor(216))
  call TI_triangle_red(G2tensor(11),RedBasis(40),mass3set(:,5),G0tensor(52),G0tensor(226),G0tensor(62),G0tensor(236),M2L1R1,[nMW], &
    G0tensor(73))
  call TI_triangle_red(G2tensor(14),RedBasis(44),mass3set(:,1),G0tensor(241),G0tensor(83),G0tensor(246),G0tensor(163),M2L1R1)
  call TI_triangle_red(G3tensor(23),RedBasis(43),mass3set(:,1),G0tensor(93),G0tensor(251),G0tensor(237),G0tensor(102),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(44),mass3set(:,7),G0tensor(256),G0tensor(187),G0tensor(158), &
    G0tensor(153),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G2tensor(22),RedBasis(44),mass3set(:,8),G0tensor(113),G0tensor(108),G0tensor(103), &
    G0tensor(266),M2L1R1,[nMW],G0tensor(242))
  call TI_triangle_red(G2tensor(27),RedBasis(45),mass3set(:,1),G0tensor(107),G0tensor(347),G0tensor(276),G0tensor(247),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(45),mass3set(:,4),G0tensor(112),G0tensor(286),G0tensor(117), &
    G0tensor(296),M2L1R1,[nMZ],G0tensor(127))
  call TI_triangle_red(G2tensor(35),RedBasis(45),mass3set(:,5),G0tensor(306),G0tensor(137),G0tensor(316), &
    G0tensor(182),M2L1R1,[nMW],G0tensor(147))
  call TI_triangle_red(G2tensor(38),RedBasis(14),mass3set(:,1),G0tensor(326),G0tensor(192),G0tensor(152),G0tensor(352),M2L1R1)
  call TI_triangle_red(G3tensor(25),RedBasis(5),mass3set(:,1),G0tensor(336),G0tensor(197),G0tensor(157),G0tensor(346),M2L1R1)
  call TI_triangle_red(G2tensor(46),RedBasis(14),mass3set(:,7),G0tensor(162),G0tensor(351),G0tensor(172), &
    G0tensor(377),M2L1R1,[nMZ],G0tensor(356))
  call TI_triangle_red(G2tensor(51),RedBasis(14),mass3set(:,8),G0tensor(382),G0tensor(361),G0tensor(366), &
    G0tensor(371),M2L1R1,[nMW],G0tensor(376))
  call TI_triangle_red(G2tensor(55),RedBasis(48),mass3set(:,1),G0tensor(381),G0tensor(313),G0tensor(303),G0tensor(293),M2L1R1)
  call TI_triangle_red(G2tensor(59),RedBasis(48),mass3set(:,7),G0tensor(248),G0tensor(243),G0tensor(238), &
    G0tensor(233),M2L1R1,[nMZ],G0tensor(223))
  call TI_triangle_red(G2tensor(66),RedBasis(48),mass3set(:,8),G0tensor(213),G0tensor(208),G0tensor(198), &
    G0tensor(193),M2L1R1,[nMW],G0tensor(188))
  call TI_triangle_red(G2tensor(74),RedBasis(6),mass3set(:,1),G0tensor(183),G0tensor(307),G0tensor(297),G0tensor(287),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(6),mass3set(:,7),G0tensor(227),G0tensor(217),G0tensor(207), &
    G0tensor(202),M2L1R1,[nMZ],G0tensor(212))
  call TI_triangle_red(G2tensor(120),RedBasis(6),mass3set(:,8),G0tensor(203),G0tensor(222),G0tensor(218), &
    G0tensor(348),M2L1R1,[nMW],G0tensor(232))
  call TI_triangle_red(G2tensor(252),RedBasis(49),mass3set(:,9),G0tensor(228),G0tensor(337),G0tensor(327), &
    G0tensor(317),M2L1R1,[nMW],G0tensor(277))
  call TI_triangle_red(G2tensor(99),RedBasis(50),mass3set(:,9),G0tensor(267),G0tensor(257),G0tensor(252), &
    G0tensor(262),M2L1R1,[nMW],G0tensor(253))
  call TI_triangle_red(G3tensor(29),RedBasis(5),mass3set(:,10),G0tensor(343),G0tensor(333),G0tensor(323), &
    G0tensor(283),M2L1R1,[nMT],G0tensor(273))
  call TI_triangle_red(G3tensor(33),RedBasis(5),mass3set(:,11),G0tensor(263),G0tensor(258),G0tensor(272), &
    G0tensor(268),M2L1R1,[nMB],G0tensor(282))
  call TI_triangle_red(G3tensor(37),RedBasis(43),mass3set(:,10),G0tensor(278),G0tensor(292),G0tensor(288), &
    G0tensor(302),M2L1R1,[nMT],G0tensor(298))
  call TI_triangle_red(G3tensor(41),RedBasis(43),mass3set(:,11),G0tensor(353),G0tensor(312),G0tensor(308), &
    G0tensor(322),M2L1R1,[nMB],G0tensor(318))
  call TI_triangle_red(G3tensor(52),RedBasis(39),mass3set(:,10),G0tensor(332),G0tensor(328),G0tensor(342), &
    G0tensor(338),M2L1R1,[nMT],G0tensor(357))
  call TI_triangle_red(G3tensor(56),RedBasis(39),mass3set(:,11),G0tensor(358),G0tensor(362),G0tensor(363), &
    G0tensor(367),M2L1R1,[nMB],G0tensor(378))
  call TI_triangle_red(G3tensor(24),RedBasis(3),mass3set(:,1),G0tensor(368),G0tensor(372),G0tensor(383),G0tensor(373),M2L1R1)
  call TI_triangle_red(G3tensor(59),RedBasis(11),mass3set(:,1),G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(10),mass3set(:,1),G0tensor(389),G0tensor(390),G0tensor(391),G0tensor(392),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(10),mass3set(:,7),G0tensor(393),G0tensor(394),G0tensor(395), &
    G0tensor(396),M2L1R1,[nMZ],G0tensor(397))
  call TI_triangle_red(G2tensor(23),RedBasis(10),mass3set(:,8),G0tensor(398),G0tensor(399),G0tensor(400), &
    G0tensor(401),M2L1R1,[nMW],G0tensor(402))
  call TI_triangle_red(G3tensor(60),RedBasis(17),mass3set(:,1),G0tensor(403),G0tensor(404),G0tensor(405),G0tensor(406),M2L1R1)
  call TI_triangle_red(G2tensor(42),RedBasis(16),mass3set(:,1),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410),M2L1R1)
  call TI_triangle_red(G3tensor(26),RedBasis(15),mass3set(:,1),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),M2L1R1)
  call TI_triangle_red(G2tensor(50),RedBasis(16),mass3set(:,7),G0tensor(415),G0tensor(416),G0tensor(417), &
    G0tensor(418),M2L1R1,[nMZ],G0tensor(419))
  call TI_triangle_red(G2tensor(54),RedBasis(16),mass3set(:,8),G0tensor(420),G0tensor(421),G0tensor(422), &
    G0tensor(423),M2L1R1,[nMW],G0tensor(424))
  call TI_triangle_red(G2tensor(58),RedBasis(20),mass3set(:,1),G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),M2L1R1)
  call TI_triangle_red(G2tensor(62),RedBasis(20),mass3set(:,7),G0tensor(429),G0tensor(430),G0tensor(431), &
    G0tensor(432),M2L1R1,[nMZ],G0tensor(433))
  call TI_triangle_red(G2tensor(70),RedBasis(20),mass3set(:,8),G0tensor(434),G0tensor(435),G0tensor(436), &
    G0tensor(437),M2L1R1,[nMW],G0tensor(438))
  call TI_triangle_red(G2tensor(75),RedBasis(21),mass3set(:,1),G0tensor(439),G0tensor(440),G0tensor(441),G0tensor(442),M2L1R1)
  call TI_triangle_red(G2tensor(79),RedBasis(21),mass3set(:,7),G0tensor(443),G0tensor(444),G0tensor(445), &
    G0tensor(446),M2L1R1,[nMZ],G0tensor(447))
  call TI_triangle_red(G2tensor(231),RedBasis(21),mass3set(:,8),G0tensor(448),G0tensor(449),G0tensor(450), &
    G0tensor(451),M2L1R1,[nMW],G0tensor(452))
  call TI_triangle_red(G3tensor(62),RedBasis(17),mass3set(:,10),G0tensor(453),G0tensor(454),G0tensor(455), &
    G0tensor(456),M2L1R1,[nMT],G0tensor(457))
  call TI_triangle_red(G3tensor(30),RedBasis(15),mass3set(:,10),G0tensor(458),G0tensor(459),G0tensor(460), &
    G0tensor(461),M2L1R1,[nMT],G0tensor(462))
  call TI_triangle_red(G3tensor(64),RedBasis(17),mass3set(:,11),G0tensor(463),G0tensor(464),G0tensor(465), &
    G0tensor(466),M2L1R1,[nMB],G0tensor(467))
  call TI_triangle_red(G3tensor(34),RedBasis(15),mass3set(:,11),G0tensor(468),G0tensor(469),G0tensor(470), &
    G0tensor(471),M2L1R1,[nMB],G0tensor(472))
  call TI_triangle_red(G3tensor(66),RedBasis(11),mass3set(:,10),G0tensor(473),G0tensor(474),G0tensor(475), &
    G0tensor(476),M2L1R1,[nMT],G0tensor(477))
  call TI_triangle_red(G3tensor(38),RedBasis(3),mass3set(:,10),G0tensor(478),G0tensor(479),G0tensor(480), &
    G0tensor(481),M2L1R1,[nMT],G0tensor(482))
  call TI_triangle_red(G3tensor(68),RedBasis(11),mass3set(:,11),G0tensor(483),G0tensor(484),G0tensor(485), &
    G0tensor(486),M2L1R1,[nMB],G0tensor(487))
  call TI_triangle_red(G3tensor(42),RedBasis(3),mass3set(:,11),G0tensor(488),G0tensor(489),G0tensor(490), &
    G0tensor(491),M2L1R1,[nMB],G0tensor(492))
  call TI_triangle_red(G2tensor(147),RedBasis(22),mass3set(:,1),G0tensor(493),G0tensor(494),G0tensor(495),G0tensor(496),M2L1R1)
  call TI_triangle_red(G2tensor(294),RedBasis(22),mass3set(:,2),G0tensor(497),G0tensor(498),G0tensor(499), &
    G0tensor(500),M2L1R1,[nMZ],G0tensor(501))
  call TI_triangle_red(G2tensor(153),RedBasis(22),mass3set(:,3),G0tensor(502),G0tensor(503),G0tensor(504), &
    G0tensor(505),M2L1R1,[nMW],G0tensor(506))
  call TI_triangle_red(G2tensor(165),RedBasis(23),mass3set(:,1),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510),M2L1R1)
  call TI_triangle_red(G2tensor(171),RedBasis(23),mass3set(:,2),G0tensor(511),G0tensor(512),G0tensor(513), &
    G0tensor(514),M2L1R1,[nMZ],G0tensor(515))
  call TI_triangle_red(G2tensor(177),RedBasis(23),mass3set(:,3),G0tensor(516),G0tensor(517),G0tensor(518), &
    G0tensor(519),M2L1R1,[nMW],G0tensor(520))
  call ol_merge_tensors(T0sum(85),[G0tensor(10)])
  call ol_merge_tensors(T0sum(86),[G0tensor(30)])
  call ol_merge_tensors(T0sum(87),[G0tensor(55)])
  call ol_merge_tensors(T0sum(88),[G0tensor(80)])
  call ol_merge_tensors(T0sum(89),[G0tensor(100)])
  call ol_merge_tensors(T0sum(90),[G0tensor(125)])
  call ol_merge_tensors(T0sum(91),[G0tensor(150)])
  call ol_merge_tensors(T0sum(92),[G0tensor(170)])
  call ol_merge_tensors(T0sum(93),[G0tensor(195)])
  call ol_merge_tensors(T0sum(94),[G0tensor(220)])
  call ol_merge_tensors(T0sum(95),[G0tensor(240)])
  call ol_merge_tensors(T0sum(96),[G0tensor(265)])
  call ol_merge_tensors(T0sum(97),[G0tensor(290)])
  call ol_merge_tensors(T0sum(98),[G0tensor(315)])
  call ol_merge_tensors(T0sum(99),[G0tensor(340)])
  call ol_merge_tensors(T0sum(100),[G0tensor(2)])
  call ol_merge_tensors(T0sum(101),[G0tensor(6)])
  call ol_merge_tensors(T0sum(102),[G0tensor(355)])
  call ol_merge_tensors(T0sum(103),[G0tensor(380)])
  call ol_merge_tensors(T0sum(104),[G0tensor(36)])
  call ol_merge_tensors(T0sum(105),[G0tensor(41)])
  call ol_merge_tensors(T0sum(106),[G0tensor(111)])
  call ol_merge_tensors(T0sum(107),[G0tensor(76)])
  call ol_merge_tensors(T0sum(108),[G0tensor(96)])
  call ol_merge_tensors(T0sum(109),[G0tensor(116)])
  call ol_merge_tensors(T0sum(110),[G0tensor(22)])
  call ol_merge_tensors(T0sum(111),[G0tensor(166)])
  call ol_merge_tensors(T0sum(112),[G0tensor(149)])
  call ol_merge_tensors(T0sum(113),[G0tensor(99)])
  call ol_merge_tensors(T0sum(114),[G0tensor(29)])
  call ol_merge_tensors(T0sum(115),[G0tensor(27)])
  call ol_merge_tensors(T0sum(116),[G0tensor(37)])
  call ol_merge_tensors(T0sum(117),[G0tensor(204)])
  call ol_merge_tensors(T0sum(118),[G0tensor(133)])
  call ol_merge_tensors(T0sum(119),[G0tensor(264)])
  call ol_merge_tensors(T0sum(120),[G0tensor(219)])
  call ol_merge_tensors(T0sum(121),[G0tensor(59)])
  call ol_merge_tensors(T0sum(122),[G0tensor(234)])
  call ol_merge_tensors(T0sum(123),[G0tensor(77)])
  call ol_merge_tensors(T0sum(124),[G0tensor(87)])
  call ol_merge_tensors(T0sum(125),[G0tensor(97)])
  call ol_merge_tensors(T0sum(126),[G0tensor(289)])
  call ol_merge_tensors(T0sum(127),[G0tensor(329)])
  call ol_merge_tensors(T0sum(128),[G0tensor(134)])
  call ol_merge_tensors(T0sum(129),[G0tensor(314)])
  call ol_merge_tensors(T0sum(130),[G0tensor(354)])
  call ol_merge_tensors(T0sum(131),[G0tensor(364)])
  call ol_merge_tensors(T0sum(132),[G0tensor(94)])
  call ol_merge_tensors(T0sum(133),[G0tensor(24)])
  call ol_merge_tensors(T0sum(134),[G0tensor(54)])
  call ol_merge_tensors(T0sum(135),[G0tensor(119)])
  call ol_merge_tensors(T0sum(136),[G0tensor(174)])
  call ol_merge_tensors(T0sum(137),[G0tensor(23)])
  call ol_merge_tensors(T0sum(138),[G0tensor(42)])
  call ol_merge_tensors(T0sum(139),[G0tensor(118)])
  call ol_merge_tensors(T0sum(140),[G0tensor(52)])
  call ol_merge_tensors(T0sum(141),[G0tensor(241)])
  call ol_merge_tensors(T0sum(142),[G0tensor(93)])
  call ol_merge_tensors(T0sum(143),[G0tensor(256)])
  call ol_merge_tensors(T0sum(144),[G0tensor(113)])
  call ol_merge_tensors(T0sum(145),[G0tensor(107)])
  call ol_merge_tensors(T0sum(146),[G0tensor(112)])
  call ol_merge_tensors(T0sum(147),[G0tensor(306)])
  call ol_merge_tensors(T0sum(148),[G0tensor(326)])
  call ol_merge_tensors(T0sum(149),[G0tensor(336)])
  call ol_merge_tensors(T0sum(150),[G0tensor(162)])
  call ol_merge_tensors(T0sum(151),[G0tensor(382)])
  call ol_merge_tensors(T0sum(152),[G0tensor(381)])
  call ol_merge_tensors(T0sum(153),[G0tensor(248)])
  call ol_merge_tensors(T0sum(154),[G0tensor(213)])
  call ol_merge_tensors(T0sum(155),[G0tensor(183)])
  call ol_merge_tensors(T0sum(156),[G0tensor(227)])
  call ol_merge_tensors(T0sum(157),[G0tensor(203)])
  call ol_merge_tensors(T0sum(158),[G0tensor(228)])
  call ol_merge_tensors(T0sum(159),[G0tensor(267)])
  call ol_merge_tensors(T0sum(160),[G0tensor(343)])
  call ol_merge_tensors(T0sum(161),[G0tensor(263)])
  call ol_merge_tensors(T0sum(162),[G0tensor(278)])
  call ol_merge_tensors(T0sum(163),[G0tensor(353)])
  call ol_merge_tensors(T0sum(164),[G0tensor(332)])
  call ol_merge_tensors(T0sum(165),[G0tensor(358)])
  call ol_merge_tensors(T0sum(166),[G0tensor(368)])
  call ol_merge_tensors(T0sum(167),[G0tensor(385)])
  call ol_merge_tensors(T0sum(168),[G0tensor(389)])
  call ol_merge_tensors(T0sum(169),[G0tensor(393)])
  call ol_merge_tensors(T0sum(170),[G0tensor(398)])
  call ol_merge_tensors(T0sum(171),[G0tensor(403)])
  call ol_merge_tensors(T0sum(172),[G0tensor(407)])
  call ol_merge_tensors(T0sum(173),[G0tensor(411)])
  call ol_merge_tensors(T0sum(174),[G0tensor(415)])
  call ol_merge_tensors(T0sum(175),[G0tensor(420)])
  call ol_merge_tensors(T0sum(176),[G0tensor(425)])
  call ol_merge_tensors(T0sum(177),[G0tensor(429)])
  call ol_merge_tensors(T0sum(178),[G0tensor(434)])
  call ol_merge_tensors(T0sum(179),[G0tensor(439)])
  call ol_merge_tensors(T0sum(180),[G0tensor(443)])
  call ol_merge_tensors(T0sum(181),[G0tensor(448)])
  call ol_merge_tensors(T1sum(21),[G1tensor(347)])
  call ol_merge_tensors(T1sum(22),[G1tensor(348)])
  call ol_merge_tensors(T1sum(23),[G1tensor(373)])
  call ol_merge_tensors(T1sum(24),[G1tensor(354)])
  call ol_merge_tensors(T1sum(25),[G1tensor(372)])
  call ol_merge_tensors(T1sum(26),[G1tensor(352)])
  call ol_merge_tensors(T1sum(27),[G1tensor(353)])
  call ol_merge_tensors(T1sum(28),[G1tensor(376)])
  call ol_merge_tensors(T1sum(29),[G1tensor(356)])
  call ol_merge_tensors(T1sum(30),[G1tensor(357)])
  call ol_merge_tensors(T1sum(31),[G1tensor(366)])
  call ol_merge_tensors(T1sum(32),[G1tensor(380)])
  call ol_merge_tensors(T1sum(33),[G1tensor(360)])
  call ol_merge_tensors(T1sum(34),[G1tensor(361)])
  call ol_merge_tensors(T1sum(35),[G1tensor(370)])
  call ol_merge_tensors(T1sum(36),[G1tensor(363)])
  call ol_merge_tensors(T1sum(37),[G1tensor(364)])
  call ol_merge_tensors(T1sum(38),[G1tensor(377)])
  call ol_merge_tensors(T1sum(39),[G1tensor(367)])
  call ol_merge_tensors(T1sum(40),[G1tensor(368)])
  call ol_merge_tensors(T1sum(41),[G1tensor(381)])
  call ol_merge_tensors(T1sum(42),[G1tensor(371)])
  call ol_merge_tensors(T1sum(43),[G1tensor(374)])
  call ol_merge_tensors(T1sum(44),[G1tensor(375)])
  call ol_merge_tensors(T1sum(45),[G1tensor(378)])
  call ol_merge_tensors(T1sum(46),[G1tensor(379)])
  call ol_merge_tensors(T1sum(47),[G1tensor(382)])
  call ol_merge_tensors(T0sum(182),[G0tensor(453)])
  call ol_merge_tensors(T0sum(183),[G0tensor(458)])
  call ol_merge_tensors(T0sum(184),[G0tensor(463)])
  call ol_merge_tensors(T0sum(185),[G0tensor(468)])
  call ol_merge_tensors(T0sum(186),[G0tensor(473)])
  call ol_merge_tensors(T0sum(187),[G0tensor(478)])
  call ol_merge_tensors(T0sum(188),[G0tensor(483)])
  call ol_merge_tensors(T0sum(189),[G0tensor(488)])
  call ol_merge_tensors(T0sum(190),[G0tensor(493)])
  call ol_merge_tensors(T0sum(191),[G0tensor(497)])
  call ol_merge_tensors(T0sum(192),[G0tensor(502)])
  call ol_merge_tensors(T0sum(193),[G0tensor(507)])
  call ol_merge_tensors(T0sum(194),[G0tensor(511)])
  call ol_merge_tensors(T0sum(195),[G0tensor(516)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[21,10],[0,0],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(31),m3h8x4(:,37),heltab2x32(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(31),21,0,G1H4(96),n2h4(97))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[21,10],[0,nMZ],2,2,wf8(:,30),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(1),ngZd,m3h8x4(:,38),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(97),n2h4(98))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[21,10],[0,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(2),m3h8x4(:,39),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(2),21,0,G1H4(98),n2h4(99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[26,5],[0,0],2,2,wf8(:,29),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,29),G0H4(3),m3h8x4(:,40),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(101),n2h4(100))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[26,5],[0,nMZ],2,2,wf8(:,29),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,29),G0H4(4),ngZd,m3h8x4(:,41),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(4),26,0,G1H4(103),n2h4(101))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[26,5],[0,nMW],2,2,wf8(:,29),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,29),G0H4(5),m3h8x4(:,42),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(104),n2h4(102))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[18,13],[0,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,42),heltab2x32(:,:,228))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngZd,m3h4x8(:,43),heltab2x32(:,:,229))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,44),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[26,5],[0,0],2,2,wf8(:,32),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(6),m3h8x4(:,43),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G0H4(6),26,0,G1H4(107),n2h4(103))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[26,5],[0,nMZ],2,2,wf8(:,32),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(16),ngZd,m3h8x4(:,44),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(16),26,0,G1H4(108),n2h4(104))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[26,5],[0,nMW],2,2,wf8(:,32),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(7),m3h8x4(:,45),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(7),26,0,G1H4(110),n2h4(105))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[26,5],[0,0],2,2,wf8(:,35),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,35),G0H4(17),m3h8x4(:,46),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(17),26,0,G1H4(113),n2h4(106))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[26,5],[0,nMZ],2,2,wf8(:,35),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,35),G0H4(8),ngZd,m3h8x4(:,47),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H4(8),26,0,G1H4(114),n2h4(107))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[26,5],[0,nMW],2,2,wf8(:,35),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,35),G0H4(18),m3h8x4(:,48),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(18),26,0,G1H4(115),n2h4(108))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[25,6],[0,0],2,2,wf8(:,38),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(9),m3h8x4(:,49),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H4(9),25,0,G1H4(119),n2h4(109))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[25,6],[0,nMZ],2,2,wf8(:,38),wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(22),ngZd,m3h8x4(:,50),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H4(22),25,0,G1H4(120),n2h4(110))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[25,6],[0,nMW],2,2,wf8(:,38),wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(11),m3h8x4(:,51),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G0H4(11),25,0,G1H4(1),n2h4(111))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[22,9],[0,0],2,2,wf8(:,37),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(23),m3h8x4(:,52),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(23),22,0,G1H4(2),n2h4(112))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[22,9],[0,nMZ],2,2,wf8(:,37),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(12),ngZd,m3h8x4(:,53),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H4(12),22,0,G1H4(6),n2h4(113))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[22,9],[0,nMW],2,2,wf8(:,37),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(24),m3h8x4(:,54),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H4(24),22,0,G1H4(7),n2h4(114))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[25,6],[0,0],2,2,wf8(:,41),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,41),G0H4(10),m3h8x4(:,55),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(10),25,0,G1H4(8),n2h4(115))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[25,6],[0,nMZ],2,2,wf8(:,41),wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,41),G0H4(13),ngZd,m3h8x4(:,56),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(11),n2h4(116))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[25,6],[0,nMW],2,2,wf8(:,41),wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,41),G0H4(14),m3h8x4(:,57),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H4(14),25,0,G1H4(13),n2h4(117))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[17,14],[0,0],2,2,wf4(:,13),wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(13),m3h4x8(:,45),heltab2x32(:,:,246))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[17,14],[nMZ,0],2,2,wf4(:,13),wf8(:,40))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,13),G0H8(3),ngZd,m3h4x8(:,46),heltab2x32(:,:,247))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[17,14],[nMW,0],2,2,wf4(:,13),wf8(:,40))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,13),G0H8(4),m3h4x8(:,47),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[25,6],[0,0],2,2,wf8(:,43),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,43),G0H4(15),m3h8x4(:,58),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[25,6],[nMZ,0],2,2,wf8(:,43),wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,43),G0H4(19),ngZd,m3h8x4(:,59),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[25,6],[nMW,0],2,2,wf8(:,43),wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,43),G0H4(20),m3h8x4(:,60),heltab2x32(:,:,251))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[18,13],[0,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,48),heltab2x32(:,:,252))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngZd,m3h4x8(:,49),heltab2x32(:,:,253))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,50),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[22,9],[0,0],2,2,wf8(:,45),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(21),m3h8x4(:,61),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H4(21),22,0,G1H4(14),n2h4(118))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[22,9],[0,nMZ],2,2,wf8(:,45),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(25),ngZd,m3h8x4(:,62),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H4(25),22,0,G1H4(17),n2h4(119))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[22,9],[0,nMW],2,2,wf8(:,45),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(26),m3h8x4(:,63),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H4(26),22,0,G1H4(18),n2h4(120))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[21,10],[0,0],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(27),m3h8x4(:,64),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H4(27),21,0,G1H4(20),n2h4(121))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[21,10],[0,nMZ],2,2,wf8(:,49),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(28),ngZd,m3h8x4(:,65),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H4(28),21,0,G1H4(23),n2h4(122))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[21,10],[0,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(29),m3h8x4(:,66),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H4(29),21,0,G1H4(24),n2h4(123))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[17,14],[0,0],2,2,wf4(:,13),wf8(:,48))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(1),m3h4x8(:,51),heltab2x32(:,:,261))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[17,14],[nMZ,0],2,2,wf4(:,13),wf8(:,48))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,13),G0H8(5),ngZd,m3h4x8(:,52),heltab2x32(:,:,262))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[17,14],[nMW,0],2,2,wf4(:,13),wf8(:,48))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,13),G0H8(6),m3h4x8(:,53),heltab2x32(:,:,263))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(107),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(108),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(110),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(7)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(20),wf4(:,4),G1tensor(1),m3h4x1(:,65),heltab2x4(:,:,264))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(23),wf4(:,4),G1tensor(31),ngZd,m3h4x1(:,66),heltab2x4(:,:,265))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(24),wf4(:,4),G1tensor(61),m3h4x1(:,67),heltab2x4(:,:,266))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(113),wf4(:,3),G1tensor(91),m3h4x1(:,68),heltab2x4(:,:,267))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(114),wf4(:,3),G1tensor(2),ngZd,m3h4x1(:,69),heltab2x4(:,:,268))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(115),wf4(:,3),G1tensor(18),m3h4x1(:,70),heltab2x4(:,:,269))
  call Hloop_VQ_A(ntryL,G0H8(10),wf8(:,33),G0H1(1),m3h8x1(:,13),heltab2x8(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(66),n2h1(509))
  call Hloop_ZQ_A(ntryL,G0H8(11),wf8(:,33),G0H1(1),ngZd,m3h8x1(:,14),heltab2x8(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(38),n2h1(510))
  call Hloop_WQ_A(ntryL,G0H8(12),wf8(:,33),G0H1(1),m3h8x1(:,15),heltab2x8(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(54),n2h1(511))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(8),wf4(:,11),G1tensor(68),m3h4x1(:,71),heltab2x4(:,:,270))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(11),wf4(:,11),G1tensor(80),ngZd,m3h4x1(:,72),heltab2x4(:,:,271))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(13),wf4(:,11),G1tensor(90),m3h4x1(:,73),heltab2x4(:,:,272))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(14),wf4(:,10),G1tensor(104),m3h4x1(:,74),heltab2x4(:,:,273))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(17),wf4(:,10),G1tensor(120),ngZd,m3h4x1(:,75),heltab2x4(:,:,274))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(18),wf4(:,10),G1tensor(17),m3h4x1(:,76),heltab2x4(:,:,275))
  call Hloop_VA_Q(ntryL,G0H8(13),wf8(:,40),G0H1(1),m3h8x1(:,16),heltab2x8(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(16),n2h1(512))
  call Hloop_ZA_Q(ntryL,G0H8(3),wf8(:,40),G0H1(1),ngZd,m3h8x1(:,17),heltab2x8(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(34),n2h1(513))
  call Hloop_WA_Q(ntryL,G0H8(4),wf8(:,40),G0H1(1),m3h8x1(:,18),heltab2x8(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(29),n2h1(514))
  call Hloop_VA_Q(ntryL,G0H4(15),wf4(:,11),G0H1(1),m3h4x1(:,77),heltab2x4(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(46),n2h1(515))
  call Hloop_ZA_Q(ntryL,G0H4(19),wf4(:,11),G0H1(1),ngZd,m3h4x1(:,78),heltab2x4(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(100),n2h1(516))
  call Hloop_WA_Q(ntryL,G0H4(20),wf4(:,11),G0H1(1),m3h4x1(:,79),heltab2x4(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(59),n2h1(517))
  call Hloop_VQ_A(ntryL,G0H8(8),wf8(:,46),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(75),n2h1(518))
  call Hloop_ZQ_A(ntryL,G0H8(14),wf8(:,46),G0H1(1),ngZd,m3h8x1(:,20),heltab2x8(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(119),n2h1(519))
  call Hloop_WQ_A(ntryL,G0H8(15),wf8(:,46),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(101),n2h1(520))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,48),G0H1(1),m3h8x1(:,22),heltab2x8(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(121),n2h1(521))
  call Hloop_ZA_Q(ntryL,G0H8(5),wf8(:,48),G0H1(1),ngZd,m3h8x1(:,23),heltab2x8(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(126),n2h1(522))
  call Hloop_WA_Q(ntryL,G0H8(6),wf8(:,48),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(131),n2h1(523))
  call ol_merge_tensors(G0tensor(517),[G0tensor(512),G0tensor(508),G0tensor(503),G0tensor(498),G0tensor(494),G0tensor(450) &
    ,G0tensor(445),G0tensor(441),G0tensor(422),G0tensor(417),G0tensor(413),G0tensor(409),G0tensor(405),G0tensor(386),G0tensor(198) &
    ,G0tensor(238),G0tensor(303),G0tensor(103),G0tensor(158),G0tensor(237),G0tensor(246),G0tensor(379),G0tensor(7),G0tensor(200) &
    ,G0tensor(175),G0tensor(155),G0tensor(60),G0tensor(35),G0tensor(15)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(276),G0tensor(83),G0tensor(301),G0tensor(57),G0tensor(92),G0tensor(345) &
    ,G0tensor(225),G0tensor(90),G0tensor(20)])
  call ol_merge_tensors(G1tensor(91),[G0tensor(390),G0tensor(163),G0tensor(206),G0tensor(74),G0tensor(3),G0tensor(25)])
  call ol_merge_tensors(G0tensor(139),[G0tensor(169),G0tensor(360),G0tensor(245),G0tensor(40)])
  call ol_merge_tensors(G1tensor(2),[G0tensor(63),G0tensor(16),G0tensor(45)])
  call ol_merge_tensors(G0tensor(515),[G0tensor(501),G0tensor(447),G0tensor(433),G0tensor(419),G0tensor(397),G0tensor(212) &
    ,G0tensor(223),G0tensor(356),G0tensor(127),G0tensor(148),G0tensor(216),G0tensor(191),G0tensor(221),G0tensor(104),G0tensor(284) &
    ,G0tensor(254),G0tensor(159),G0tensor(32),G0tensor(126),G0tensor(21),G0tensor(375),G0tensor(260),G0tensor(190),G0tensor(120) &
    ,G0tensor(50)])
  call ol_merge_tensors(G0tensor(196),[G0tensor(244),G0tensor(31),G0tensor(320),G0tensor(270),G0tensor(65)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(226),G0tensor(106),G0tensor(330),G0tensor(70)])
  call ol_merge_tensors(G0tensor(520),[G0tensor(506),G0tensor(452),G0tensor(438),G0tensor(424),G0tensor(402),G0tensor(253) &
    ,G0tensor(277),G0tensor(232),G0tensor(188),G0tensor(376),G0tensor(147),G0tensor(242),G0tensor(73),G0tensor(201),G0tensor(291) &
    ,G0tensor(124),G0tensor(319),G0tensor(114),G0tensor(109),G0tensor(48),G0tensor(143),G0tensor(189),G0tensor(321),G0tensor(51) &
    ,G0tensor(46),G0tensor(335),G0tensor(310),G0tensor(285),G0tensor(215),G0tensor(145),G0tensor(75)])
  call ol_merge_tensors(G0tensor(307),[G0tensor(313),G0tensor(138),G0tensor(84),G0tensor(214),G0tensor(89),G0tensor(91) &
    ,G0tensor(230),G0tensor(160),G0tensor(85)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(251),G0tensor(384),G0tensor(71),G0tensor(280),G0tensor(255),G0tensor(235) &
    ,G0tensor(140),G0tensor(115),G0tensor(95)])
  call ol_merge_tensors(G0tensor(14),[G0tensor(194),G0tensor(156),G0tensor(180),G0tensor(105)])
  call ol_merge_tensors(G0tensor(351),[G0tensor(117),G0tensor(187),G0tensor(12),G0tensor(110)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(47),G0tensor(17),G0tensor(295),G0tensor(205),G0tensor(130)])
  call ol_merge_tensors(G0tensor(327),[G0tensor(361),G0tensor(316),G0tensor(108),G0tensor(161),G0tensor(135)])
  call ol_merge_tensors(G1tensor(46),[G1tensor(68),G0tensor(426),G0tensor(293),G0tensor(347),G0tensor(129),G0tensor(19) &
    ,G0tensor(165)])
  call ol_merge_tensors(G1tensor(80),[G0tensor(286),G0tensor(199),G0tensor(185)])
  call ol_merge_tensors(G1tensor(90),[G0tensor(137),G0tensor(123),G0tensor(305),G0tensor(210)])
  call ol_merge_tensors(G0tensor(217),[G0tensor(243),G0tensor(53),G0tensor(279),G0tensor(250)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(222),G0tensor(208),G0tensor(62),G0tensor(239),G0tensor(275)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(337),G0tensor(122),G0tensor(249),G0tensor(325),G0tensor(300)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(509),G0tensor(440),G0tensor(287),G0tensor(4),G0tensor(350)])
  call ol_merge_tensors(G0tensor(412),[G0tensor(346),G0tensor(209),G0tensor(341),G0tensor(39),G0tensor(72),G0tensor(370) &
    ,G0tensor(8),G0tensor(1)])
  call ol_merge_tensors(G0tensor(414),[G0tensor(373),G0tensor(281),G0tensor(261),G0tensor(224),G0tensor(58),G0tensor(38) &
    ,G0tensor(154),G0tensor(18),G0tensor(136),G0tensor(121),G0tensor(81),G0tensor(56),G0tensor(26),G0tensor(9),G0tensor(5)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(202),G0tensor(11),G0tensor(365)])
  call ol_merge_tensors(G0tensor(449),[G0tensor(348),G0tensor(324),G0tensor(82),G0tensor(101)])
  call ol_merge_tensors(G0tensor(406),[G0tensor(388),G0tensor(78),G0tensor(229),G0tensor(49),G0tensor(176),G0tensor(151) &
    ,G0tensor(86),G0tensor(66)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(66),G0tensor(496),G0tensor(410),G0tensor(392),G0tensor(146),G0tensor(61)])
  call ol_merge_tensors(G1tensor(119),[G1tensor(38),G0tensor(418),G0tensor(396),G0tensor(141),G0tensor(131)])
  call ol_merge_tensors(G1tensor(101),[G1tensor(54),G0tensor(423),G0tensor(401),G0tensor(98),G0tensor(184),G0tensor(171)])
  call ol_merge_tensors(G1tensor(104),[G0tensor(495),G0tensor(408),G0tensor(352),G0tensor(331),G0tensor(79)])
  call ol_merge_tensors(G0tensor(416),[G0tensor(377),G0tensor(178),G0tensor(28)])
  call ol_merge_tensors(G0tensor(421),[G0tensor(371),G0tensor(168),G0tensor(68),G0tensor(259)])
  call ol_merge_tensors(G1tensor(121),[G1tensor(16),G0tensor(510),G0tensor(442),G0tensor(428),G0tensor(274),G0tensor(269)])
  call ol_merge_tensors(G1tensor(126),[G1tensor(34),G0tensor(446),G0tensor(432),G0tensor(69),G0tensor(67)])
  call ol_merge_tensors(G1tensor(131),[G1tensor(29),G0tensor(451),G0tensor(437),G0tensor(294),G0tensor(88),G0tensor(271)])
  call ol_merge_tensors(G0tensor(342),[G0tensor(292),G0tensor(333),G0tensor(299)])
  call ol_merge_tensors(G0tensor(476),[G0tensor(456),G0tensor(132)])
  call ol_merge_tensors(G0tensor(481),[G0tensor(461),G0tensor(349),G0tensor(334)])
  call ol_merge_tensors(G0tensor(482),[G0tensor(477),G0tensor(462),G0tensor(457),G0tensor(357),G0tensor(298),G0tensor(273) &
    ,G0tensor(167),G0tensor(304)])
  call ol_merge_tensors(G0tensor(363),[G0tensor(312),G0tensor(258),G0tensor(339)])
  call ol_merge_tensors(G0tensor(486),[G0tensor(466),G0tensor(309)])
  call ol_merge_tensors(G0tensor(491),[G0tensor(471),G0tensor(359),G0tensor(142)])
  call ol_merge_tensors(G0tensor(492),[G0tensor(487),G0tensor(472),G0tensor(467),G0tensor(378),G0tensor(318),G0tensor(282) &
    ,G0tensor(374),G0tensor(344)])
  call ol_merge_tensors(G0tensor(474),[G0tensor(460),G0tensor(455),G0tensor(328),G0tensor(288),G0tensor(179)])
  call ol_merge_tensors(G0tensor(459),[G0tensor(283),G0tensor(144)])
  call ol_merge_tensors(G0tensor(484),[G0tensor(470),G0tensor(465),G0tensor(362),G0tensor(308),G0tensor(177)])
  call ol_merge_tensors(G0tensor(469),[G0tensor(268),G0tensor(369)])
  call ol_merge_tensors(G0tensor(372),[G0tensor(182),G0tensor(296),G0tensor(247),G0tensor(102),G0tensor(236),G0tensor(43) &
    ,G0tensor(128),G0tensor(33),G0tensor(13),G0tensor(311),G0tensor(64),G0tensor(44),G0tensor(34),G0tensor(186)])
  call ol_merge_tensors(G0tensor(394),[G0tensor(153),G0tensor(211)])
  call ol_merge_tensors(G0tensor(399),[G0tensor(317),G0tensor(266),G0tensor(164)])
  call ol_merge_tensors(G1tensor(100),[G0tensor(430),G0tensor(233),G0tensor(181)])
  call ol_merge_tensors(G1tensor(59),[G0tensor(435),G0tensor(262),G0tensor(193),G0tensor(173)])
  call ol_merge_tensors(G0tensor(436),[G0tensor(431),G0tensor(427),G0tensor(404),G0tensor(400),G0tensor(395),G0tensor(391) &
    ,G0tensor(387),G0tensor(383),G0tensor(218),G0tensor(207),G0tensor(297),G0tensor(366),G0tensor(172),G0tensor(157) &
    ,G0tensor(152)])
  call ol_merge_tensors(G0tensor(480),[G0tensor(475),G0tensor(454),G0tensor(323)])
  call ol_merge_tensors(G0tensor(490),[G0tensor(485),G0tensor(464),G0tensor(272)])
  call ol_merge_tensors(G0tensor(479),[G0tensor(338),G0tensor(302)])
  call ol_merge_tensors(G0tensor(489),[G0tensor(367),G0tensor(322)])
  call ol_merge_tensors(G1tensor(120),[G0tensor(499)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(504)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(513)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(518)])
call TI_bubble_red(G1tensor(91),26,mass2set(:,1),G0tensor(10),M2L1R1)
call TI_bubble_red(G1tensor(2),26,mass2set(:,2),G0tensor(30),M2L1R1,G0tensor(55))
call TI_bubble_red(G1tensor(18),26,mass2set(:,3),G0tensor(80),M2L1R1,G0tensor(100))
call TI_bubble_red(G1tensor(46),25,mass2set(:,1),G0tensor(125),M2L1R1)
call TI_bubble_red(G1tensor(80),25,mass2set(:,2),G0tensor(150),M2L1R1,G0tensor(170))
call TI_bubble_red(G1tensor(90),25,mass2set(:,3),G0tensor(195),M2L1R1,G0tensor(220))
call TI_bubble_red(G1tensor(1),21,mass2set(:,1),G0tensor(240),M2L1R1)
call TI_bubble_red(G1tensor(75),18,mass2set(:,1),G0tensor(265),M2L1R1)
call TI_bubble_red(G1tensor(119),18,mass2set(:,4),G0tensor(290),M2L1R1,G0tensor(315))
call TI_bubble_red(G1tensor(101),18,mass2set(:,5),G0tensor(340),M2L1R1,G0tensor(2))
call TI_bubble_red(G1tensor(104),22,mass2set(:,1),G0tensor(6),M2L1R1)
call TI_bubble_red(G1tensor(121),17,mass2set(:,1),G0tensor(355),M2L1R1)
call TI_bubble_red(G1tensor(126),17,mass2set(:,4),G0tensor(380),M2L1R1,G0tensor(36))
call TI_bubble_red(G1tensor(131),17,mass2set(:,5),G0tensor(41),M2L1R1,G0tensor(111))
call TI_bubble_red(G1tensor(100),25,mass2set(:,4),G0tensor(76),M2L1R1,G0tensor(96))
call TI_bubble_red(G1tensor(59),25,mass2set(:,5),G0tensor(116),M2L1R1,G0tensor(22))
call TI_bubble_red(G1tensor(120),22,mass2set(:,2),G0tensor(166),M2L1R1,G0tensor(149))
call TI_bubble_red(G1tensor(17),22,mass2set(:,3),G0tensor(99),M2L1R1,G0tensor(29))
call TI_bubble_red(G1tensor(31),21,mass2set(:,2),G0tensor(27),M2L1R1,G0tensor(37))
call TI_bubble_red(G1tensor(61),21,mass2set(:,3),G0tensor(204),M2L1R1,G0tensor(133))
  call ol_merge_tensors(G0tensor(37),[G0tensor(149),G0tensor(96),G0tensor(36),G0tensor(315),G0tensor(170),G0tensor(515) &
    ,G0tensor(55)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(29),G0tensor(22),G0tensor(111),G0tensor(2),G0tensor(220),G0tensor(520) &
    ,G0tensor(100)])
  call ol_merge_tensors(T0sum(196),[G0tensor(517)])
  call ol_merge_tensors(T0sum(197),[G0tensor(192)])
  call ol_merge_tensors(T0sum(198),[G0tensor(10)])
  call ol_merge_tensors(T0sum(199),[G0tensor(139)])
  call ol_merge_tensors(T0sum(200),[G0tensor(30)])
  call ol_merge_tensors(T0sum(201),[G0tensor(37)])
  call ol_merge_tensors(T0sum(202),[G0tensor(196)])
  call ol_merge_tensors(T0sum(203),[G0tensor(80)])
  call ol_merge_tensors(T0sum(204),[G0tensor(133)])
  call ol_merge_tensors(T0sum(205),[G0tensor(307)])
  call ol_merge_tensors(T0sum(206),[G0tensor(197)])
  call ol_merge_tensors(T0sum(207),[G0tensor(14)])
  call ol_merge_tensors(T0sum(208),[G0tensor(351)])
  call ol_merge_tensors(T0sum(209),[G0tensor(231)])
  call ol_merge_tensors(T0sum(210),[G0tensor(327)])
  call ol_merge_tensors(T0sum(211),[G0tensor(125)])
  call ol_merge_tensors(T0sum(212),[G0tensor(150)])
  call ol_merge_tensors(T0sum(213),[G0tensor(195)])
  call ol_merge_tensors(T0sum(214),[G0tensor(217)])
  call ol_merge_tensors(T0sum(215),[G0tensor(252)])
  call ol_merge_tensors(T0sum(216),[G0tensor(257)])
  call ol_merge_tensors(T0sum(217),[G0tensor(240)])
  call ol_merge_tensors(T0sum(218),[G0tensor(412)])
  call ol_merge_tensors(T0sum(219),[G0tensor(414)])
  call ol_merge_tensors(T0sum(220),[G0tensor(444)])
  call ol_merge_tensors(T0sum(221),[G0tensor(449)])
  call ol_merge_tensors(T0sum(222),[G0tensor(406)])
  call ol_merge_tensors(T0sum(223),[G0tensor(265)])
  call ol_merge_tensors(T0sum(224),[G0tensor(290)])
  call ol_merge_tensors(T0sum(225),[G0tensor(340)])
  call ol_merge_tensors(T0sum(226),[G0tensor(6)])
  call ol_merge_tensors(T0sum(227),[G0tensor(416)])
  call ol_merge_tensors(T0sum(228),[G0tensor(421)])
  call ol_merge_tensors(T0sum(229),[G0tensor(355)])
  call ol_merge_tensors(T0sum(230),[G0tensor(380)])
  call ol_merge_tensors(T0sum(231),[G0tensor(41)])
  call ol_merge_tensors(T0sum(232),[G0tensor(342)])
  call ol_merge_tensors(T0sum(233),[G0tensor(476)])
  call ol_merge_tensors(T0sum(234),[G0tensor(481)])
  call ol_merge_tensors(T0sum(235),[G0tensor(482)])
  call ol_merge_tensors(T0sum(236),[G0tensor(363)])
  call ol_merge_tensors(T0sum(237),[G0tensor(486)])
  call ol_merge_tensors(T0sum(238),[G0tensor(491)])
  call ol_merge_tensors(T0sum(239),[G0tensor(492)])
  call ol_merge_tensors(T0sum(240),[G0tensor(474)])
  call ol_merge_tensors(T0sum(241),[G0tensor(459)])
  call ol_merge_tensors(T0sum(242),[G0tensor(484)])
  call ol_merge_tensors(T0sum(243),[G0tensor(469)])
  call ol_merge_tensors(T0sum(244),[G0tensor(372)])
  call ol_merge_tensors(T0sum(245),[G0tensor(394)])
  call ol_merge_tensors(T0sum(246),[G0tensor(399)])
  call ol_merge_tensors(T0sum(247),[G0tensor(76)])
  call ol_merge_tensors(T0sum(248),[G0tensor(116)])
  call ol_merge_tensors(T0sum(249),[G0tensor(436)])
  call ol_merge_tensors(T0sum(250),[G0tensor(480)])
  call ol_merge_tensors(T0sum(251),[G0tensor(490)])
  call ol_merge_tensors(T0sum(252),[G0tensor(479)])
  call ol_merge_tensors(T0sum(253),[G0tensor(489)])
  call ol_merge_tensors(T0sum(254),[G0tensor(166)])
  call ol_merge_tensors(T0sum(255),[G0tensor(500)])
  call ol_merge_tensors(T0sum(256),[G0tensor(99)])
  call ol_merge_tensors(T0sum(257),[G0tensor(505)])
  call ol_merge_tensors(T0sum(258),[G0tensor(27)])
  call ol_merge_tensors(T0sum(259),[G0tensor(514)])
  call ol_merge_tensors(T0sum(260),[G0tensor(204)])
  call ol_merge_tensors(T0sum(261),[G0tensor(519)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_22,RedSet_4(7),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_22,RedSet_4(8),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_22,RedSet_4(9),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_22,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_22,RedSet_4(10),ScalarBoxes(5))
  call compute_scalar_box([ 20, 21, 23 ],masses2_27,RedSet_4(7),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_27,RedSet_4(8),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 21 ],masses2_24,RedSet_4(1),ScalarBoxes(8))
  call compute_scalar_box([ 4, 5, 7 ],masses2_27,RedSet_4(10),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_25,RedSet_4(7),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 23 ],masses2_25,RedSet_4(8),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 21 ],masses2_23,RedSet_4(1),ScalarBoxes(12))
  call compute_scalar_box([ 4, 5, 7 ],masses2_25,RedSet_4(10),ScalarBoxes(13))
  call compute_scalar_box([ 18, 19, 23 ],masses2_22,RedSet_4(11),ScalarBoxes(14))
  call compute_scalar_box([ 16, 19, 23 ],masses2_22,RedSet_4(12),ScalarBoxes(15))
  call compute_scalar_box([ 16, 18, 23 ],masses2_22,RedSet_4(13),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 19 ],masses2_22,RedSet_4(2),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 7 ],masses2_22,RedSet_4(14),ScalarBoxes(18))
  call compute_scalar_box([ 18, 19, 23 ],masses2_32,RedSet_4(11),ScalarBoxes(19))
  call compute_scalar_box([ 16, 18, 23 ],masses2_27,RedSet_4(13),ScalarBoxes(20))
  call compute_scalar_box([ 16, 18, 19 ],masses2_27,RedSet_4(2),ScalarBoxes(21))
  call compute_scalar_box([ 2, 3, 7 ],masses2_32,RedSet_4(14),ScalarBoxes(22))
  call compute_scalar_box([ 18, 19, 23 ],masses2_30,RedSet_4(11),ScalarBoxes(23))
  call compute_scalar_box([ 16, 18, 23 ],masses2_25,RedSet_4(13),ScalarBoxes(24))
  call compute_scalar_box([ 16, 18, 19 ],masses2_25,RedSet_4(2),ScalarBoxes(25))
  call compute_scalar_box([ 2, 3, 7 ],masses2_30,RedSet_4(14),ScalarBoxes(26))
  call compute_scalar_box([ 20, 22, 23 ],masses2_22,RedSet_4(15),ScalarBoxes(27))
  call compute_scalar_box([ 16, 22, 23 ],masses2_22,RedSet_4(16),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 22 ],masses2_22,RedSet_4(3),ScalarBoxes(29))
  call compute_scalar_box([ 4, 6, 7 ],masses2_22,RedSet_4(17),ScalarBoxes(30))
  call compute_scalar_box([ 20, 22, 23 ],masses2_27,RedSet_4(15),ScalarBoxes(31))
  call compute_scalar_box([ 16, 22, 23 ],masses2_27,RedSet_4(16),ScalarBoxes(32))
  call compute_scalar_box([ 16, 20, 22 ],masses2_24,RedSet_4(3),ScalarBoxes(33))
  call compute_scalar_box([ 4, 6, 7 ],masses2_27,RedSet_4(17),ScalarBoxes(34))
  call compute_scalar_box([ 20, 22, 23 ],masses2_25,RedSet_4(15),ScalarBoxes(35))
  call compute_scalar_box([ 16, 22, 23 ],masses2_25,RedSet_4(16),ScalarBoxes(36))
  call compute_scalar_box([ 16, 20, 22 ],masses2_23,RedSet_4(3),ScalarBoxes(37))
  call compute_scalar_box([ 4, 6, 7 ],masses2_25,RedSet_4(17),ScalarBoxes(38))
  call compute_scalar_box([ 18, 19, 27 ],masses2_22,RedSet_4(18),ScalarBoxes(39))
  call compute_scalar_box([ 16, 19, 27 ],masses2_22,RedSet_4(19),ScalarBoxes(40))
  call compute_scalar_box([ 16, 18, 27 ],masses2_22,RedSet_4(20),ScalarBoxes(41))
  call compute_scalar_box([ 2, 3, 11 ],masses2_22,RedSet_4(21),ScalarBoxes(42))
  call compute_scalar_box([ 18, 19, 27 ],masses2_32,RedSet_4(18),ScalarBoxes(43))
  call compute_scalar_box([ 16, 18, 27 ],masses2_27,RedSet_4(20),ScalarBoxes(44))
  call compute_scalar_box([ 2, 3, 11 ],masses2_32,RedSet_4(21),ScalarBoxes(45))
  call compute_scalar_box([ 18, 19, 27 ],masses2_30,RedSet_4(18),ScalarBoxes(46))
  call compute_scalar_box([ 16, 18, 27 ],masses2_25,RedSet_4(20),ScalarBoxes(47))
  call compute_scalar_box([ 2, 3, 11 ],masses2_30,RedSet_4(21),ScalarBoxes(48))
  call compute_scalar_box([ 17, 19, 23 ],masses2_22,RedSet_4(22),ScalarBoxes(49))
  call compute_scalar_box([ 16, 17, 23 ],masses2_22,RedSet_4(23),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 19 ],masses2_22,RedSet_4(4),ScalarBoxes(51))
  call compute_scalar_box([ 1, 3, 7 ],masses2_22,RedSet_4(24),ScalarBoxes(52))
  call compute_scalar_box([ 17, 19, 23 ],masses2_32,RedSet_4(22),ScalarBoxes(53))
  call compute_scalar_box([ 16, 17, 23 ],masses2_27,RedSet_4(23),ScalarBoxes(54))
  call compute_scalar_box([ 16, 17, 19 ],masses2_27,RedSet_4(4),ScalarBoxes(55))
  call compute_scalar_box([ 1, 3, 7 ],masses2_32,RedSet_4(24),ScalarBoxes(56))
  call compute_scalar_box([ 17, 19, 23 ],masses2_30,RedSet_4(22),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 23 ],masses2_25,RedSet_4(23),ScalarBoxes(58))
  call compute_scalar_box([ 16, 17, 19 ],masses2_25,RedSet_4(4),ScalarBoxes(59))
  call compute_scalar_box([ 1, 3, 7 ],masses2_30,RedSet_4(24),ScalarBoxes(60))
  call compute_scalar_box([ 17, 19, 27 ],masses2_22,RedSet_4(25),ScalarBoxes(61))
  call compute_scalar_box([ 16, 17, 27 ],masses2_22,RedSet_4(26),ScalarBoxes(62))
  call compute_scalar_box([ 1, 3, 11 ],masses2_22,RedSet_4(27),ScalarBoxes(63))
  call compute_scalar_box([ 17, 19, 27 ],masses2_32,RedSet_4(25),ScalarBoxes(64))
  call compute_scalar_box([ 16, 17, 27 ],masses2_27,RedSet_4(26),ScalarBoxes(65))
  call compute_scalar_box([ 1, 3, 11 ],masses2_32,RedSet_4(27),ScalarBoxes(66))
  call compute_scalar_box([ 17, 19, 27 ],masses2_30,RedSet_4(25),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 27 ],masses2_25,RedSet_4(26),ScalarBoxes(68))
  call compute_scalar_box([ 1, 3, 11 ],masses2_30,RedSet_4(27),ScalarBoxes(69))
  call compute_scalar_box([ 18, 22, 23 ],masses2_31,RedSet_4(28),ScalarBoxes(70))
  call compute_scalar_box([ 16, 18, 22 ],masses2_26,RedSet_4(5),ScalarBoxes(71))
  call compute_scalar_box([ 2, 6, 7 ],masses2_31,RedSet_4(29),ScalarBoxes(72))
  call compute_scalar_box([ 17, 21, 23 ],masses2_31,RedSet_4(30),ScalarBoxes(73))
  call compute_scalar_box([ 16, 17, 21 ],masses2_26,RedSet_4(6),ScalarBoxes(74))
  call compute_scalar_box([ 1, 5, 7 ],masses2_31,RedSet_4(31),ScalarBoxes(75))
! end of process


end subroutine vamp_3

end module ol_vamp_3_ppajj_ew_ddxagg_1_/**/REALKIND
