
module ol_vamp_3_ppajj_ew_dddxdxa_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_dddxdxa_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_dddxdxa_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_dddxdxa_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_dddxdxa_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_dddxdxa_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_dddxdxa_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(159),n2h16(199))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,328),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(160),n2h16(200))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[16,6,9],[0,0,0],3,2,wf4(:,8),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,329),heltab2x32(:,:,417))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(161),n2h16(201))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,330),heltab2x32(:,:,418))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(162),n2h16(202))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[16,6,9],[nME,nME,nME],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,331),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G0H16(33),16,nME,G1H16(163),n2h16(203))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[16,6,9],[nMM,nMM,nMM],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,332),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMM,G1H16(164),n2h16(204))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[16,6,9],[nML,nML,nML],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,333),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(165),n2h16(205))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[16,6,9],[nME,nME,nME],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,334),heltab2x32(:,:,422))
  call Hloop_A_Q(ntryL,G0H16(33),16,nME,G1H16(166),n2h16(206))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[16,6,9],[nMM,nMM,nMM],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,335),heltab2x32(:,:,423))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMM,G1H16(167),n2h16(207))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[16,6,9],[nML,nML,nML],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,336),heltab2x32(:,:,424))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(168),n2h16(208))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[16,6,9],[0,0,0],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,337),heltab2x32(:,:,425))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(169),n2h16(209))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,338),heltab2x32(:,:,426))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMT,G1H16(170),n2h16(210))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,6,9],[0,0,0],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,339),heltab2x32(:,:,427))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(171),n2h16(211))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,340),heltab2x32(:,:,428))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(172),n2h16(212))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,6,9],[0,0,0],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,341),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(173),n2h16(213))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,10),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,342),heltab2x32(:,:,430))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(174),n2h16(214))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,6,9],[0,0,0],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,343),heltab2x32(:,:,431))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(175),n2h16(215))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,10),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,344),heltab2x32(:,:,432))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(176),n2h16(216))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,345),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(178),m3h2x16(:,346),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,347),heltab2x32(:,:,435))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(180),m3h2x16(:,348),heltab2x32(:,:,436))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,349),heltab2x32(:,:,437))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(182),m3h2x16(:,350),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,351),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,352),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,353),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(186),m3h2x16(:,354),heltab2x32(:,:,442))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,355),heltab2x32(:,:,443))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(188),m3h2x16(:,356),heltab2x32(:,:,444))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,357),heltab2x32(:,:,445))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(190),m3h2x16(:,358),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,359),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(192),m3h2x16(:,360),heltab2x32(:,:,448))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(193),m3h2x16(:,361),heltab2x32(:,:,449))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(194),m3h2x16(:,362),heltab2x32(:,:,450))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,363),heltab2x32(:,:,451))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(196),m3h2x16(:,364),heltab2x32(:,:,452))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,365),heltab2x32(:,:,453))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(198),m3h2x16(:,366),heltab2x32(:,:,454))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(199),m3h2x16(:,367),heltab2x32(:,:,455))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(200),m3h2x16(:,368),heltab2x32(:,:,456))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(201),m3h2x16(:,369),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(202),m3h2x16(:,370),heltab2x32(:,:,458))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(203),m3h2x16(:,371),heltab2x32(:,:,459))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(204),m3h2x16(:,372),heltab2x32(:,:,460))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(205),m3h2x16(:,373),heltab2x32(:,:,461))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,374),heltab2x32(:,:,462))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(207),m3h2x16(:,375),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,376),heltab2x32(:,:,464))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,377),heltab2x32(:,:,465))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(210),m3h2x16(:,378),heltab2x32(:,:,466))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(211),m3h2x16(:,379),heltab2x32(:,:,467))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,380),heltab2x32(:,:,468))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(213),m3h2x16(:,381),heltab2x32(:,:,469))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(214),m3h2x16(:,382),heltab2x32(:,:,470))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(215),m3h2x16(:,383),heltab2x32(:,:,471))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(216),m3h2x16(:,384),heltab2x32(:,:,472))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,385),heltab2x32(:,:,473))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,386),heltab2x32(:,:,474))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,387),heltab2x32(:,:,475))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,388),heltab2x32(:,:,476))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,389),heltab2x32(:,:,477))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,390),heltab2x32(:,:,478))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,391),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,392),heltab2x32(:,:,480))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,393),heltab2x32(:,:,481))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,394),heltab2x32(:,:,482))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,395),heltab2x32(:,:,483))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,396),heltab2x32(:,:,484))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,397),heltab2x32(:,:,485))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,398),heltab2x32(:,:,486))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,399),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,400),heltab2x32(:,:,488))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,401),heltab2x32(:,:,489))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,402),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,403),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,404),heltab2x32(:,:,492))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,405),heltab2x32(:,:,493))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,406),heltab2x32(:,:,494))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,407),heltab2x32(:,:,495))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,408),heltab2x32(:,:,496))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,409),heltab2x32(:,:,497))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,410),heltab2x32(:,:,498))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,411),heltab2x32(:,:,499))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,412),heltab2x32(:,:,500))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,413),heltab2x32(:,:,501))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,414),heltab2x32(:,:,502))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,415),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,416),heltab2x32(:,:,504))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(217),m3h2x16(:,417),heltab2x32(:,:,505))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,418),heltab2x32(:,:,506))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,419),heltab2x32(:,:,507))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(220),m3h2x16(:,420),heltab2x32(:,:,508))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,421),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(222),m3h2x16(:,422),heltab2x32(:,:,510))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,423),heltab2x32(:,:,511))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,10),wf4(:,12))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,424),heltab2x32(:,:,512))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[17,6,8],[0,0,0],3,2,wf4(:,9),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(16),m3h4x8(:,89),heltab2x32(:,:,513))
  call Hloop_Q_A(ntryL,G0H8(16),17,0,G1H8(48),n2h8(89))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[17,6,8],[0,0,nMZ],3,2,wf4(:,9),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(17),ngZd,m3h4x8(:,90),heltab2x32(:,:,514))
  call Hloop_Q_A(ntryL,G0H8(17),17,0,G1H8(49),n2h8(90))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[17,6,8],[0,0,nMW],3,2,wf4(:,9),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(18),m3h4x8(:,91),heltab2x32(:,:,515))
  call Hloop_Q_A(ntryL,G0H8(18),17,0,G1H8(50),n2h8(91))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[17,6,8],[0,0,0],3,2,wf4(:,9),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,92),heltab2x32(:,:,516))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(51),n2h8(92))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[17,6,8],[0,0,nMZ],3,2,wf4(:,9),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(20),ngZd,m3h4x8(:,93),heltab2x32(:,:,517))
  call Hloop_Q_A(ntryL,G0H8(20),17,0,G1H8(52),n2h8(93))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[17,6,8],[0,0,nMW],3,2,wf4(:,9),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(21),m3h4x8(:,94),heltab2x32(:,:,518))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(53),n2h8(94))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[17,6,8],[nMW,nMW,0],3,2,wf4(:,9),wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(22),m3h4x8(:,95),heltab2x32(:,:,519))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[17,6,8],[nMW,nMW,0],3,2,wf4(:,9),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(23),m3h4x8(:,96),heltab2x32(:,:,520))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[24,1,6],[0,0,0],3,2,wf4(:,6),wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(24),m3h4x8(:,97),heltab2x32(:,:,521))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[24,1,6],[nMZ,0,0],3,2,wf4(:,6),wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngZd,m3h4x8(:,98),heltab2x32(:,:,522))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[24,1,6],[nMW,0,0],3,2,wf4(:,6),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(26),m3h4x8(:,99),heltab2x32(:,:,523))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[24,1,6],[0,0,0],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,100),heltab2x32(:,:,524))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[24,1,6],[nMZ,0,0],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngZd,m3h4x8(:,101),heltab2x32(:,:,525))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[24,1,6],[nMW,0,0],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,102),heltab2x32(:,:,526))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[24,1,6],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(30),m3h4x8(:,103),heltab2x32(:,:,527))
  call Hloop_A_Q(ntryL,G0H8(30),24,0,G1H8(54),n2h8(95))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[24,1,6],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(31),m3h4x8(:,104),heltab2x32(:,:,528))
  call Hloop_A_Q(ntryL,G0H8(31),24,0,G1H8(55),n2h8(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[16,7,8],[0,0,0],3,1,wf8(:,63))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,425),heltab2x32(:,:,529))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(225),n2h16(217))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[16,7,8],[0,nMZ,0],3,1,wf8(:,63))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,426),heltab2x32(:,:,530))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(226),n2h16(218))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[16,7,8],[0,nMW,0],3,1,wf8(:,63))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,427),heltab2x32(:,:,531))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(227),n2h16(219))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[16,7,8],[0,0,0],3,1,wf8(:,64))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,428),heltab2x32(:,:,532))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(228),n2h16(220))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[16,7,8],[0,nMZ,0],3,1,wf8(:,64))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,429),heltab2x32(:,:,533))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(229),n2h16(221))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[16,7,8],[0,nMW,0],3,1,wf8(:,64))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,430),heltab2x32(:,:,534))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(230),n2h16(222))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[16,7,8],[nMW,0,nMW],3,1,wf8(:,63))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,431),heltab2x32(:,:,535))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[16,7,8],[nMW,0,nMW],3,1,wf8(:,64))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,432),heltab2x32(:,:,536))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[16,1,14],[0,0,0],3,1,wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,433),heltab2x32(:,:,537))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(233),n2h16(223))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[16,1,14],[0,nMZ,0],3,1,wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,434),heltab2x32(:,:,538))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(234),n2h16(224))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[16,1,14],[0,nMW,0],3,1,wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,435),heltab2x32(:,:,539))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(235),n2h16(225))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[16,1,14],[0,0,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,436),heltab2x32(:,:,540))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(236),n2h16(226))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[16,1,14],[0,nMZ,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,437),heltab2x32(:,:,541))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(237),n2h16(227))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[16,1,14],[0,nMW,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,438),heltab2x32(:,:,542))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(238),n2h16(228))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[16,1,14],[nMW,0,nMW],3,1,wf8(:,58))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,439),heltab2x32(:,:,543))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[16,1,14],[nMW,0,nMW],3,1,wf8(:,60))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,440),heltab2x32(:,:,544))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[18,4,9],[0,0,0],3,2,wf4(:,3),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(32),m3h4x8(:,105),heltab2x32(:,:,545))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[18,4,9],[nMZ,0,0],3,2,wf4(:,3),wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(33),ngZd,m3h4x8(:,106),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[18,4,9],[nMW,0,0],3,2,wf4(:,3),wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(34),m3h4x8(:,107),heltab2x32(:,:,547))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[18,4,9],[0,0,0],3,2,wf4(:,3),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(35),m3h4x8(:,108),heltab2x32(:,:,548))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[18,4,9],[nMZ,0,0],3,2,wf4(:,3),wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(36),ngZd,m3h4x8(:,109),heltab2x32(:,:,549))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[18,4,9],[nMW,0,0],3,2,wf4(:,3),wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,110),heltab2x32(:,:,550))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[18,4,9],[0,nMW,nMW],3,2,wf4(:,3),wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,111),heltab2x32(:,:,551))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(56),n2h8(97))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[18,4,9],[0,nMW,nMW],3,2,wf4(:,3),wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,112),heltab2x32(:,:,552))
  call Hloop_Q_A(ntryL,G0H8(2),18,0,G1H8(57),n2h8(98))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[20,2,9],[0,0,0],3,2,wf4(:,14),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,14),G0H8(3),m3h4x8(:,113),heltab2x32(:,:,553))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[20,2,9],[nMZ,0,0],3,2,wf4(:,14),wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,14),G0H8(4),ngZd,m3h4x8(:,114),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[20,2,9],[nMW,0,0],3,2,wf4(:,14),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,14),G0H8(5),m3h4x8(:,115),heltab2x32(:,:,555))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[20,2,9],[0,0,0],3,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,14),G0H8(14),m3h4x8(:,116),heltab2x32(:,:,556))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[20,2,9],[nMZ,0,0],3,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,14),G0H8(15),ngZd,m3h4x8(:,117),heltab2x32(:,:,557))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[20,2,9],[nMW,0,0],3,2,wf4(:,14),wf4(:,12))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,14),G0H8(16),m3h4x8(:,118),heltab2x32(:,:,558))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[20,2,9],[0,nMW,nMW],3,2,wf4(:,14),wf4(:,11))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,14),G0H8(17),m3h4x8(:,119),heltab2x32(:,:,559))
  call Hloop_A_Q(ntryL,G0H8(17),20,0,G1H8(58),n2h8(99))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[20,2,9],[0,nMW,nMW],3,2,wf4(:,14),wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,14),G0H8(18),m3h4x8(:,120),heltab2x32(:,:,560))
  call Hloop_A_Q(ntryL,G0H8(18),20,0,G1H8(59),n2h8(100))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[16,4,11],[0,0,0],3,1,wf8(:,71))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,441),heltab2x32(:,:,561))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(241),n2h16(229))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[16,4,11],[0,nMZ,0],3,1,wf8(:,71))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,442),heltab2x32(:,:,562))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(242),n2h16(230))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[16,4,11],[0,nMW,0],3,1,wf8(:,71))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,443),heltab2x32(:,:,563))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(243),n2h16(231))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[16,4,11],[0,0,0],3,1,wf8(:,72))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,444),heltab2x32(:,:,564))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(244),n2h16(232))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[16,4,11],[0,nMZ,0],3,1,wf8(:,72))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,445),heltab2x32(:,:,565))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(245),n2h16(233))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[16,4,11],[0,nMW,0],3,1,wf8(:,72))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,446),heltab2x32(:,:,566))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(246),n2h16(234))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[16,4,11],[nMW,0,nMW],3,1,wf8(:,71))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(247),m3h2x16(:,447),heltab2x32(:,:,567))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[16,4,11],[nMW,0,nMW],3,1,wf8(:,72))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(248),m3h2x16(:,448),heltab2x32(:,:,568))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[16,2,13],[0,0,0],3,1,wf8(:,67))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,449),heltab2x32(:,:,569))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(249),n2h16(235))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[16,2,13],[0,nMZ,0],3,1,wf8(:,67))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,450),heltab2x32(:,:,570))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(250),n2h16(236))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,2,13],[0,nMW,0],3,1,wf8(:,67))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,451),heltab2x32(:,:,571))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(251),n2h16(237))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,2,13],[0,0,0],3,1,wf8(:,68))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,452),heltab2x32(:,:,572))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(252),n2h16(238))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,2,13],[0,nMZ,0],3,1,wf8(:,68))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,453),heltab2x32(:,:,573))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(253),n2h16(239))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,2,13],[0,nMW,0],3,1,wf8(:,68))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,454),heltab2x32(:,:,574))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(254),n2h16(240))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,2,13],[nMW,0,nMW],3,1,wf8(:,67))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(255),m3h2x16(:,455),heltab2x32(:,:,575))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,2,13],[nMW,0,nMW],3,1,wf8(:,68))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(256),m3h2x16(:,456),heltab2x32(:,:,576))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[17,4,10],[0,0,0],3,2,wf4(:,9),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,121),heltab2x32(:,:,577))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[17,4,10],[nMZ,0,0],3,2,wf4(:,9),wf4(:,15))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(20),ngZd,m3h4x8(:,122),heltab2x32(:,:,578))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[17,4,10],[nMW,0,0],3,2,wf4(:,9),wf4(:,15))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(21),m3h4x8(:,123),heltab2x32(:,:,579))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[17,4,10],[0,0,0],3,2,wf4(:,9),wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(30),m3h4x8(:,124),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[17,4,10],[nMZ,0,0],3,2,wf4(:,9),wf4(:,16))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(31),ngZd,m3h4x8(:,125),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[17,4,10],[nMW,0,0],3,2,wf4(:,9),wf4(:,16))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,126),heltab2x32(:,:,582))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[17,4,10],[0,nMW,nMW],3,2,wf4(:,9),wf4(:,15))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(2),m3h4x8(:,127),heltab2x32(:,:,583))
  call Hloop_Q_A(ntryL,G0H8(2),17,0,G1H8(60),n2h8(101))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[17,4,10],[0,nMW,nMW],3,2,wf4(:,9),wf4(:,16))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(17),m3h4x8(:,128),heltab2x32(:,:,584))
  call Hloop_Q_A(ntryL,G0H8(17),17,0,G1H8(61),n2h8(102))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[20,1,10],[0,0,0],3,2,wf4(:,14),wf4(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,14),G0H8(18),m3h4x8(:,129),heltab2x32(:,:,585))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[20,1,10],[nMZ,0,0],3,2,wf4(:,14),wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,14),G0H8(2),ngZd,m3h4x8(:,130),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[20,1,10],[nMW,0,0],3,2,wf4(:,14),wf4(:,15))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,14),G0H8(17),m3h4x8(:,131),heltab2x32(:,:,587))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[20,1,10],[0,0,0],3,2,wf4(:,14),wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,14),G0H8(38),m3h4x8(:,132),heltab2x32(:,:,588))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[20,1,10],[nMZ,0,0],3,2,wf4(:,14),wf4(:,16))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,14),G0H8(39),ngZd,m3h4x8(:,133),heltab2x32(:,:,589))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[20,1,10],[nMW,0,0],3,2,wf4(:,14),wf4(:,16))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,14),G0H8(40),m3h4x8(:,134),heltab2x32(:,:,590))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[20,1,10],[0,nMW,nMW],3,2,wf4(:,14),wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,14),G0H8(41),m3h4x8(:,135),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G0H8(41),20,0,G1H8(62),n2h8(103))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[20,1,10],[0,nMW,nMW],3,2,wf4(:,14),wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,14),G0H8(41),m3h4x8(:,136),heltab2x32(:,:,592))
  call Hloop_A_Q(ntryL,G0H8(41),20,0,G1H8(63),n2h8(104))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[16,4,11],[0,0,0],3,1,wf8(:,79))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,457),heltab2x32(:,:,593))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(257),n2h16(241))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[16,4,11],[0,nMZ,0],3,1,wf8(:,79))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,458),heltab2x32(:,:,594))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(258),n2h16(242))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[16,4,11],[0,nMW,0],3,1,wf8(:,79))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,459),heltab2x32(:,:,595))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(259),n2h16(243))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,4,11],[0,0,0],3,1,wf8(:,80))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,460),heltab2x32(:,:,596))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(260),n2h16(244))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,4,11],[0,nMZ,0],3,1,wf8(:,80))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,461),heltab2x32(:,:,597))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(261),n2h16(245))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,4,11],[0,nMW,0],3,1,wf8(:,80))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,462),heltab2x32(:,:,598))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(262),n2h16(246))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,4,11],[nMW,0,nMW],3,1,wf8(:,79))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(263),m3h2x16(:,463),heltab2x32(:,:,599))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,4,11],[nMW,0,nMW],3,1,wf8(:,80))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(264),m3h2x16(:,464),heltab2x32(:,:,600))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,1,14],[0,0,0],3,1,wf8(:,74))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,465),heltab2x32(:,:,601))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(265),n2h16(247))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,1,14],[0,nMZ,0],3,1,wf8(:,74))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,466),heltab2x32(:,:,602))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(266),n2h16(248))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,1,14],[0,nMW,0],3,1,wf8(:,74))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,467),heltab2x32(:,:,603))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(267),n2h16(249))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,1,14],[0,0,0],3,1,wf8(:,76))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,468),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(268),n2h16(250))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,1,14],[0,nMZ,0],3,1,wf8(:,76))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,469),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(269),n2h16(251))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,1,14],[0,nMW,0],3,1,wf8(:,76))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,470),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(270),n2h16(252))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,1,14],[nMW,0,nMW],3,1,wf8(:,74))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(271),m3h2x16(:,471),heltab2x32(:,:,607))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,1,14],[nMW,0,nMW],3,1,wf8(:,76))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(272),m3h2x16(:,472),heltab2x32(:,:,608))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[21,2,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,1),heltab2x32(:,:,609))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(7),n2h4(127))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[21,2,8],[0,nMZ,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,2),heltab2x32(:,:,610))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(11),n2h4(128))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[21,2,8],[0,nMW,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,3),heltab2x32(:,:,611))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(14),n2h4(129))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[21,2,8],[0,0,0],3,1,wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZd,m3h8x4(:,4),heltab2x32(:,:,612))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(17),n2h4(130))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[21,2,8],[0,nMZ,0],3,1,wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZd,m3h8x4(:,5),heltab2x32(:,:,613))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(18),n2h4(131))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[21,2,8],[0,nMW,0],3,1,wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZu,m3h8x4(:,6),heltab2x32(:,:,614))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(27),n2h4(132))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[21,2,8],[nMW,0,nMW],3,1,wf8(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,13),21,G1H4(28),m3h8x4(:,7),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[21,2,8],[nMW,0,nMW],3,1,wf8(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,14),21,G1H4(29),m3h8x4(:,8),heltab2x32(:,:,616))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[25,2,4],[0,0,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(9),m3h8x4(:,9),heltab2x32(:,:,617))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(32),n2h4(133))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[25,2,4],[0,nMZ,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(9),m3h8x4(:,10),heltab2x32(:,:,618))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(33),n2h4(134))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[25,2,4],[0,nMW,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(9),m3h8x4(:,11),heltab2x32(:,:,619))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(34),n2h4(135))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[25,2,4],[0,0,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(9),ngZd,m3h8x4(:,12),heltab2x32(:,:,620))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(38),n2h4(136))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[25,2,4],[0,nMZ,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(9),ngZd,m3h8x4(:,13),heltab2x32(:,:,621))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(39),n2h4(137))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[25,2,4],[0,nMW,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(9),ngZu,m3h8x4(:,14),heltab2x32(:,:,622))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(40),n2h4(138))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[25,2,4],[nMW,0,nMW],3,1,wf8(:,5))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,5),25,G1H4(43),m3h8x4(:,15),heltab2x32(:,:,623))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[25,2,4],[nMW,0,nMW],3,1,wf8(:,6))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,6),25,G1H4(44),m3h8x4(:,16),heltab2x32(:,:,624))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[22,1,8],[0,0,0],3,1,wf8(:,65))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,65),G0H4(9),m3h8x4(:,17),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(45),n2h4(139))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[22,1,8],[0,nMZ,0],3,1,wf8(:,65))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,65),G0H4(9),m3h8x4(:,18),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(48),n2h4(140))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[22,1,8],[0,nMW,0],3,1,wf8(:,65))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,65),G0H4(9),m3h8x4(:,19),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(49),n2h4(141))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[22,1,8],[0,0,0],3,1,wf8(:,66))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,66),G0H4(9),ngZd,m3h8x4(:,20),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(50),n2h4(142))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[22,1,8],[0,nMZ,0],3,1,wf8(:,66))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,66),G0H4(9),ngZd,m3h8x4(:,21),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(53),n2h4(143))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[22,1,8],[0,nMW,0],3,1,wf8(:,66))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,66),G0H4(9),ngZu,m3h8x4(:,22),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(54),n2h4(144))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[22,1,8],[nMW,0,nMW],3,1,wf8(:,65))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,65),22,G1H4(55),m3h8x4(:,23),heltab2x32(:,:,631))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[22,1,8],[nMW,0,nMW],3,1,wf8(:,66))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,66),22,G1H4(58),m3h8x4(:,24),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[26,1,4],[0,0,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,49),G0H4(9),m3h8x4(:,25),heltab2x32(:,:,633))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(59),n2h4(145))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[26,1,4],[0,nMZ,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,49),G0H4(9),m3h8x4(:,26),heltab2x32(:,:,634))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(60),n2h4(146))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[26,1,4],[0,nMW,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,49),G0H4(9),m3h8x4(:,27),heltab2x32(:,:,635))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(63),n2h4(147))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[26,1,4],[0,0,0],3,1,wf8(:,50))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,50),G0H4(9),ngZd,m3h8x4(:,28),heltab2x32(:,:,636))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(64),n2h4(148))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[26,1,4],[0,nMZ,0],3,1,wf8(:,50))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,50),G0H4(9),ngZd,m3h8x4(:,29),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(65),n2h4(149))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[26,1,4],[0,nMW,0],3,1,wf8(:,50))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,50),G0H4(9),ngZu,m3h8x4(:,30),heltab2x32(:,:,638))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(68),n2h4(150))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[26,1,4],[nMW,0,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,49),26,G1H4(69),m3h8x4(:,31),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[26,1,4],[nMW,0,nMW],3,1,wf8(:,50))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,50),26,G1H4(70),m3h8x4(:,32),heltab2x32(:,:,640))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[21,2,8],[0,0,0],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,77),G0H4(9),m3h8x4(:,33),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(73),n2h4(151))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[21,2,8],[0,nMZ,0],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,77),G0H4(9),m3h8x4(:,34),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(74),n2h4(152))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[21,2,8],[0,nMW,0],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,77),G0H4(9),m3h8x4(:,35),heltab2x32(:,:,643))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(75),n2h4(153))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[21,2,8],[0,0,0],3,1,wf8(:,78))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,78),G0H4(9),ngZd,m3h8x4(:,36),heltab2x32(:,:,644))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(78),n2h4(154))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[21,2,8],[0,nMZ,0],3,1,wf8(:,78))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,78),G0H4(9),ngZd,m3h8x4(:,37),heltab2x32(:,:,645))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(79),n2h4(155))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[21,2,8],[0,nMW,0],3,1,wf8(:,78))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,78),G0H4(9),ngZu,m3h8x4(:,38),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G0H4(9),21,0,G1H4(80),n2h4(156))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[21,2,8],[nMW,0,nMW],3,1,wf8(:,77))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,77),21,G1H4(16),m3h8x4(:,39),heltab2x32(:,:,647))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[21,2,8],[nMW,0,nMW],3,1,wf8(:,78))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,78),21,G1H4(36),m3h8x4(:,40),heltab2x32(:,:,648))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[22,1,8],[0,0,0],3,1,wf8(:,69))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,69),G0H4(9),m3h8x4(:,41),heltab2x32(:,:,649))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(9),n2h4(157))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[22,1,8],[0,nMZ,0],3,1,wf8(:,69))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,69),G0H4(9),m3h8x4(:,42),heltab2x32(:,:,650))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(82),n2h4(158))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[22,1,8],[0,nMW,0],3,1,wf8(:,69))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,69),G0H4(9),m3h8x4(:,43),heltab2x32(:,:,651))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(21),n2h4(159))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[22,1,8],[0,0,0],3,1,wf8(:,70))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,70),G0H4(9),ngZd,m3h8x4(:,44),heltab2x32(:,:,652))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(22),n2h4(160))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[22,1,8],[0,nMZ,0],3,1,wf8(:,70))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,70),G0H4(9),ngZd,m3h8x4(:,45),heltab2x32(:,:,653))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(93),n2h4(161))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[22,1,8],[0,nMW,0],3,1,wf8(:,70))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,70),G0H4(9),ngZu,m3h8x4(:,46),heltab2x32(:,:,654))
  call Hloop_A_Q(ntryL,G0H4(9),22,0,G1H4(94),n2h4(162))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[22,1,8],[nMW,0,nMW],3,1,wf8(:,69))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,69),22,G1H4(95),m3h8x4(:,47),heltab2x32(:,:,655))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[22,1,8],[nMW,0,nMW],3,1,wf8(:,70))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,70),22,G1H4(98),m3h8x4(:,48),heltab2x32(:,:,656))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[25,2,4],[0,0,0],3,1,wf8(:,61))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,61),G0H4(9),m3h8x4(:,49),heltab2x32(:,:,657))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(99),n2h4(163))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[25,2,4],[0,nMZ,0],3,1,wf8(:,61))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,61),G0H4(9),m3h8x4(:,50),heltab2x32(:,:,658))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(100),n2h4(164))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[25,2,4],[0,nMW,0],3,1,wf8(:,61))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,61),G0H4(9),m3h8x4(:,51),heltab2x32(:,:,659))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(103),n2h4(165))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[25,2,4],[0,0,0],3,1,wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,62),G0H4(9),ngZd,m3h8x4(:,52),heltab2x32(:,:,660))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(104),n2h4(166))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[25,2,4],[0,nMZ,0],3,1,wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,62),G0H4(9),ngZd,m3h8x4(:,53),heltab2x32(:,:,661))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(105),n2h4(167))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[25,2,4],[0,nMW,0],3,1,wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,62),G0H4(9),ngZu,m3h8x4(:,54),heltab2x32(:,:,662))
  call Hloop_A_Q(ntryL,G0H4(9),25,0,G1H4(108),n2h4(168))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[25,2,4],[nMW,0,nMW],3,1,wf8(:,61))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,61),25,G1H4(109),m3h8x4(:,55),heltab2x32(:,:,663))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[25,2,4],[nMW,0,nMW],3,1,wf8(:,62))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,62),25,G1H4(110),m3h8x4(:,56),heltab2x32(:,:,664))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[26,1,4],[0,0,0],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,53),G0H4(9),m3h8x4(:,57),heltab2x32(:,:,665))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(113),n2h4(169))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[26,1,4],[0,nMZ,0],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,53),G0H4(9),m3h8x4(:,58),heltab2x32(:,:,666))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(114),n2h4(170))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[26,1,4],[0,nMW,0],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,53),G0H4(9),m3h8x4(:,59),heltab2x32(:,:,667))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(115),n2h4(171))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[26,1,4],[0,0,0],3,1,wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,54),G0H4(9),ngZd,m3h8x4(:,60),heltab2x32(:,:,668))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(118),n2h4(172))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[26,1,4],[0,nMZ,0],3,1,wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,54),G0H4(9),ngZd,m3h8x4(:,61),heltab2x32(:,:,669))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(119),n2h4(173))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[26,1,4],[0,nMW,0],3,1,wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,54),G0H4(9),ngZu,m3h8x4(:,62),heltab2x32(:,:,670))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(120),n2h4(174))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[26,1,4],[nMW,0,nMW],3,1,wf8(:,53))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,53),26,G1H4(123),m3h8x4(:,63),heltab2x32(:,:,671))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[26,1,4],[nMW,0,nMW],3,1,wf8(:,54))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,54),26,G1H4(124),m3h8x4(:,64),heltab2x32(:,:,672))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(95),G1H4(58),G1H4(55),G1H4(15),G0H4(2) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(16),G1H4(29),G1H4(28),G1H4(8),G0H4(4) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(109),G1H4(44),G1H4(43),G0H4(6),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(123),G1H4(70),G1H4(69),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(67),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(68),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(79),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(90),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(100),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(131),[G1H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G1H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(191),[G1H16(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(192),[G1H16(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(195),[G1H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(196),[G1H16(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(199),[G1H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(200),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(210),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(212),[G1H16(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(214),[G1H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(216),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(218),[G1H16(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(220),[G1H16(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(222),[G1H16(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(224),[G1H16(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(73),G1H4(17),G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(74),G1H4(18),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(75),G1H4(27),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(99),G1H4(38),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(100),G1H4(39),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(103),G1H4(40),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(9),G1H4(50),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(82),G1H4(53),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(21),G1H4(54),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(113),G1H4(64),G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(114),G1H4(65),G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(115),G1H4(68),G1H4(63)])
  call Hloop_WQ_A(ntryL,G1H4(98),ex1(:),G1H2(180),m3h2x2(:,143),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(180),23,0,G2H2(65),n2h2(83))
  call Hloop_WQ_A(ntryL,G1H4(36),ex2(:),G1H2(184),m3h2x2(:,144),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(184),23,0,G2H2(38),n2h2(84))
  call Hloop_QV_A(ntryL,G1H8(42),wf4(:,1),G1H2(185),m3h4x2(:,33),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(185),23,0,G2H2(77),n2h2(85))
  call Hloop_QZ_A(ntryL,G1H8(45),wf4(:,4),G1H2(186),ngZu,m3h4x2(:,34),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(186),23,0,G2H2(41),n2h2(86))
  call Hloop_QV_A(ntryL,G1H8(50),wf4(:,8),G1H2(190),m3h4x2(:,35),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(190),23,0,G2H2(71),n2h2(87))
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,10),G1H2(191),ngZu,m3h4x2(:,36),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(191),23,0,G2H2(44),n2h2(88))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,11),G1H2(192),m3h4x2(:,37),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(192),27,0,G2H2(83),n2h2(89))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,12),G1H2(196),ngZu,m3h4x2(:,38),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(196),27,0,G2H2(47),n2h2(90))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,15),G1H2(197),m3h4x2(:,39),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(197),27,0,G2H2(10),n2h2(91))
  call Hloop_QZ_A(ntryL,G1H8(36),wf4(:,16),G1H2(198),ngZu,m3h4x2(:,40),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(198),27,0,G2H2(17),n2h2(92))
  call Hloop_WQ_A(ntryL,G1H4(110),ex2(:),G1H2(202),m3h2x2(:,145),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(202),27,0,G2H2(15),n2h2(93))
  call Hloop_WQ_A(ntryL,G1H4(124),ex1(:),G1H2(203),m3h2x2(:,146),heltab2x4(:,:,302))
  call Hloop_Q_A(ntryL,G1H2(203),27,0,G2H2(19),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(125),m3h4x4(:,21),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(125),21,nME,G2H4(17),n2h4(175))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(128),m3h4x4(:,22),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(128),21,nMM,G2H4(18),n2h4(176))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(85),m3h4x4(:,23),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(85),21,nML,G2H4(19),n2h4(177))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(86),m3h4x4(:,24),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(86),21,nME,G2H4(20),n2h4(178))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(131),m3h4x4(:,25),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(131),21,nMM,G2H4(21),n2h4(179))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(132),m3h4x4(:,26),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(132),21,nML,G2H4(22),n2h4(180))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(133),m3h4x4(:,27),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(133),21,0,G2H4(23),n2h4(181))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(136),m3h4x4(:,28),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(136),21,nMT,G2H4(24),n2h4(182))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,1),G1H4(137),m3h4x4(:,29),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(137),21,0,G2H4(25),n2h4(183))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,1),G1H4(138),m3h4x4(:,30),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(138),21,nMT,G2H4(26),n2h4(184))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,1),G1H4(141),m3h4x4(:,31),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(141),21,nMB,G2H4(27),n2h4(185))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,1),G1H4(142),m3h4x4(:,32),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(142),21,nMB,G2H4(28),n2h4(186))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,1),G1H4(143),m3h4x4(:,33),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(143),21,nME,G2H4(29),n2h4(187))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,1),G1H4(146),m3h4x4(:,34),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(146),21,nMM,G2H4(30),n2h4(188))
  call Hloop_AV_Q(ntryL,G1H16(17),wf4(:,1),G1H4(147),m3h4x4(:,35),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(147),21,nML,G2H4(31),n2h4(189))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,1),G1H4(148),m3h4x4(:,36),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(148),21,nME,G2H4(32),n2h4(190))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,1),G1H4(151),m3h4x4(:,37),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(151),21,nMM,G2H4(33),n2h4(191))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,1),G1H4(152),m3h4x4(:,38),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(152),21,nML,G2H4(34),n2h4(192))
  call Hloop_AV_Q(ntryL,G1H16(21),wf4(:,1),G1H4(153),m3h4x4(:,39),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(153),21,0,G2H4(35),n2h4(193))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,1),G1H4(156),m3h4x4(:,40),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(156),21,nMT,G2H4(36),n2h4(194))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,1),G1H4(157),m3h4x4(:,41),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(157),21,0,G2H4(37),n2h4(195))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,1),G1H4(158),m3h4x4(:,42),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(158),21,nMT,G2H4(38),n2h4(196))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,1),G1H4(161),m3h4x4(:,43),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(161),21,0,G2H4(39),n2h4(197))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,1),G1H4(162),m3h4x4(:,44),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(162),21,nMB,G2H4(40),n2h4(198))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,1),G1H4(163),m3h4x4(:,45),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(163),21,0,G2H4(15),n2h4(199))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,1),G1H4(166),m3h4x4(:,46),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(166),21,nMB,G2H4(7),n2h4(200))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,4),G1H4(87),ngZl,m3h4x4(:,47),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(87),21,nME,G2H4(1),n2h4(201))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,4),G1H4(88),ngZl,m3h4x4(:,48),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(88),21,nMM,G2H4(2),n2h4(202))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,4),G1H4(169),ngZl,m3h4x4(:,49),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(169),21,nML,G2H4(3),n2h4(203))
  call Hloop_QZ_A(ntryL,G1H16(32),wf4(:,4),G1H4(170),ngZl,m3h4x4(:,50),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(170),21,nME,G2H4(9),n2h4(204))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,4),G1H4(171),ngZl,m3h4x4(:,51),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(171),21,nMM,G2H4(10),n2h4(205))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,4),G1H4(174),ngZl,m3h4x4(:,52),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(174),21,nML,G2H4(11),n2h4(206))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,4),G1H4(175),ngZu,m3h4x4(:,53),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(175),21,0,G2H4(16),n2h4(207))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,4),G1H4(176),ngZu,m3h4x4(:,54),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G1H4(176),21,nMT,G2H4(8),n2h4(208))
  call Hloop_QZ_A(ntryL,G1H16(37),wf4(:,4),G1H4(179),ngZu,m3h4x4(:,55),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(179),21,0,G2H4(4),n2h4(209))
  call Hloop_QZ_A(ntryL,G1H16(38),wf4(:,4),G1H4(180),ngZu,m3h4x4(:,56),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(180),21,nMT,G2H4(5),n2h4(210))
  call Hloop_AZ_Q(ntryL,G1H16(39),wf4(:,4),G1H4(181),ngZd,m3h4x4(:,57),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(181),21,0,G2H4(6),n2h4(211))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,4),G1H4(184),ngZd,m3h4x4(:,58),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(184),21,nMB,G2H4(12),n2h4(212))
  call Hloop_QZ_A(ntryL,G1H16(41),wf4(:,4),G1H4(185),ngZd,m3h4x4(:,59),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(185),21,0,G2H4(13),n2h4(213))
  call Hloop_QZ_A(ntryL,G1H16(42),wf4(:,4),G1H4(186),ngZd,m3h4x4(:,60),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(186),21,nMB,G2H4(14),n2h4(214))
  call Hloop_AZ_Q(ntryL,G1H16(43),wf4(:,4),G1H4(189),ngZl,m3h4x4(:,61),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(189),21,nME,G2H4(41),n2h4(215))
  call Hloop_AZ_Q(ntryL,G1H16(44),wf4(:,4),G1H4(190),ngZl,m3h4x4(:,62),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(190),21,nMM,G2H4(42),n2h4(216))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,4),G1H4(191),ngZl,m3h4x4(:,63),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(191),21,nML,G2H4(43),n2h4(217))
  call Hloop_QZ_A(ntryL,G1H16(46),wf4(:,4),G1H4(194),ngZl,m3h4x4(:,64),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(194),21,nME,G2H4(44),n2h4(218))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,4),G1H4(195),ngZl,m3h4x4(:,65),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(195),21,nMM,G2H4(45),n2h4(219))
  call Hloop_QZ_A(ntryL,G1H16(48),wf4(:,4),G1H4(196),ngZl,m3h4x4(:,66),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(196),21,nML,G2H4(46),n2h4(220))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,4),G1H4(199),ngZu,m3h4x4(:,67),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(199),21,0,G2H4(47),n2h4(221))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf4(:,4),G1H4(200),ngZu,m3h4x4(:,68),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(200),21,nMT,G2H4(48),n2h4(222))
  call Hloop_QZ_A(ntryL,G1H16(51),wf4(:,4),G1H4(201),ngZu,m3h4x4(:,69),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(201),21,0,G2H4(49),n2h4(223))
  call Hloop_QZ_A(ntryL,G1H16(52),wf4(:,4),G1H4(204),ngZu,m3h4x4(:,70),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(204),21,nMT,G2H4(50),n2h4(224))
  call Hloop_AZ_Q(ntryL,G1H16(53),wf4(:,4),G1H4(89),ngZd,m3h4x4(:,71),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(89),21,0,G2H4(51),n2h4(225))
  call Hloop_AZ_Q(ntryL,G1H16(54),wf4(:,4),G1H4(90),ngZd,m3h4x4(:,72),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(90),21,nMB,G2H4(52),n2h4(226))
  call Hloop_QZ_A(ntryL,G1H16(55),wf4(:,4),G1H4(207),ngZd,m3h4x4(:,73),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(207),21,0,G2H4(53),n2h4(227))
  call Hloop_QZ_A(ntryL,G1H16(56),wf4(:,4),G1H4(208),ngZd,m3h4x4(:,74),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(208),21,nMB,G2H4(54),n2h4(228))
  call Hloop_SV_T(ntryL,G1H16(57),16,wf4(:,1),5,G2H4(55),m3h4x4(:,75),heltab2x16(:,:,191))
  call Hloop_TV_S(ntryL,G1H16(58),16,wf4(:,1),5,G2H4(56),m3h4x4(:,76),heltab2x16(:,:,192))
  call Hloop_SV_T(ntryL,G1H16(59),16,wf4(:,1),5,G2H4(57),m3h4x4(:,77),heltab2x16(:,:,193))
  call Hloop_TV_S(ntryL,G1H16(60),16,wf4(:,1),5,G2H4(58),m3h4x4(:,78),heltab2x16(:,:,194))
  call Hloop_SV_T(ntryL,G1H16(61),16,wf4(:,4),5,G2H4(59),m3h4x4(:,79),heltab2x16(:,:,195))
  call Hloop_TV_S(ntryL,G1H16(62),16,wf4(:,4),5,G2H4(60),m3h4x4(:,80),heltab2x16(:,:,196))
  call Hloop_SV_T(ntryL,G1H16(63),16,wf4(:,4),5,G2H4(61),m3h4x4(:,81),heltab2x16(:,:,197))
  call Hloop_TV_S(ntryL,G1H16(64),16,wf4(:,4),5,G2H4(62),m3h4x4(:,82),heltab2x16(:,:,198))
  call Hloop_DV_C(ntryL,G1H16(67),16,wf4(:,1),G2H4(63),m3h4x4(:,83),heltab2x16(:,:,199))
  call Hloop_CV_D(ntryL,G1H16(68),16,wf4(:,1),5,G2H4(64),m3h4x4(:,84),heltab2x16(:,:,200))
  call Hloop_DV_C(ntryL,G1H16(71),16,wf4(:,1),G2H4(65),m3h4x4(:,85),heltab2x16(:,:,201))
  call Hloop_CV_D(ntryL,G1H16(72),16,wf4(:,1),5,G2H4(66),m3h4x4(:,86),heltab2x16(:,:,202))
  call Hloop_DV_C(ntryL,G1H16(75),16,wf4(:,4),G2H4(67),m3h4x4(:,87),heltab2x16(:,:,203))
  call Hloop_CV_D(ntryL,G1H16(76),16,wf4(:,4),5,G2H4(68),m3h4x4(:,88),heltab2x16(:,:,204))
  call Hloop_DV_C(ntryL,G1H16(79),16,wf4(:,4),G2H4(69),m3h4x4(:,89),heltab2x16(:,:,205))
  call Hloop_CV_D(ntryL,G1H16(80),16,wf4(:,4),5,G2H4(70),m3h4x4(:,90),heltab2x16(:,:,206))
  call Hloop_UW_V(ntryL,G1H16(81),16,wf4(:,1),5,G2H4(71),m3h4x4(:,91),heltab2x16(:,:,207))
  call Hloop_UV_W(ntryL,G1H16(82),16,wf4(:,1),5,G2H4(72),m3h4x4(:,92),heltab2x16(:,:,208))
  call Hloop_UW_V(ntryL,G1H16(83),16,wf4(:,1),5,G2H4(73),m3h4x4(:,93),heltab2x16(:,:,209))
  call Hloop_UV_W(ntryL,G1H16(84),16,wf4(:,1),5,G2H4(74),m3h4x4(:,94),heltab2x16(:,:,210))
  call Hloop_UW_V(ntryL,G1H16(85),16,wf4(:,4),5,G2H4(75),m3h4x4(:,95),heltab2x16(:,:,211))
  call Hloop_UV_W(ntryL,G1H16(86),16,wf4(:,4),5,G2H4(76),m3h4x4(:,96),heltab2x16(:,:,212))
  call Hloop_UW_V(ntryL,G1H16(87),16,wf4(:,4),5,G2H4(77),m3h4x4(:,97),heltab2x16(:,:,213))
  call Hloop_UV_W(ntryL,G1H16(88),16,wf4(:,4),5,G2H4(78),m3h4x4(:,98),heltab2x16(:,:,214))
  call Hloop_SV_V(ntryL,G1H16(90),wf4(:,1),G1H4(209),m3h4x4(:,99),heltab2x16(:,:,215))
  call Hloop_SV_V(ntryL,G1H16(92),wf4(:,1),G1H4(212),m3h4x4(:,100),heltab2x16(:,:,216))
  call Hloop_SV_V(ntryL,G1H16(94),wf4(:,4),G1H4(213),m3h4x4(:,101),heltab2x16(:,:,217))
  call Hloop_SV_V(ntryL,G1H16(96),wf4(:,4),G1H4(214),m3h4x4(:,102),heltab2x16(:,:,218))
  call Hloop_SV_T(ntryL,G0H16(5),16,wf4(:,1),5,G1H4(217),m3h4x4(:,103),heltab2x16(:,:,219))
  call Hloop_TV_S(ntryL,G0H16(6),16,wf4(:,1),5,G1H4(218),m3h4x4(:,104),heltab2x16(:,:,220))
  call Hloop_SV_T(ntryL,G0H16(7),16,wf4(:,1),5,G1H4(219),m3h4x4(:,105),heltab2x16(:,:,221))
  call Hloop_TV_S(ntryL,G0H16(8),16,wf4(:,1),5,G1H4(222),m3h4x4(:,106),heltab2x16(:,:,222))
  call Hloop_SV_T(ntryL,G0H16(9),16,wf4(:,4),5,G1H4(223),m3h4x4(:,107),heltab2x16(:,:,223))
  call Hloop_TV_S(ntryL,G0H16(10),16,wf4(:,4),5,G1H4(224),m3h4x4(:,108),heltab2x16(:,:,224))
  call Hloop_SV_T(ntryL,G0H16(11),16,wf4(:,4),5,G1H4(227),m3h4x4(:,109),heltab2x16(:,:,225))
  call Hloop_TV_S(ntryL,G0H16(12),16,wf4(:,4),5,G1H4(228),m3h4x4(:,110),heltab2x16(:,:,226))
  call Hloop_VV_S(ntryL,G0H16(13),wf4(:,1),G0H4(9),m3h4x4(:,111),heltab2x16(:,:,227))
  call Hloop_VV_S(ntryL,G0H16(14),wf4(:,1),G0H4(2),m3h4x4(:,112),heltab2x16(:,:,228))
  call Hloop_VV_S(ntryL,G0H16(15),wf4(:,1),G0H4(3),m3h4x4(:,113),heltab2x16(:,:,229))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,1),G0H4(4),m3h4x4(:,114),heltab2x16(:,:,230))
  call Hloop_VV_S(ntryL,G0H16(17),wf4(:,4),G0H4(5),m3h4x4(:,115),heltab2x16(:,:,231))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(6),m3h4x4(:,116),heltab2x16(:,:,232))
  call Hloop_VV_S(ntryL,G0H16(2),wf4(:,4),G0H4(1),m3h4x4(:,117),heltab2x16(:,:,233))
  call Hloop_VV_S(ntryL,G0H16(3),wf4(:,4),G0H4(8),m3h4x4(:,118),heltab2x16(:,:,234))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,1),G0H4(7),m3h4x4(:,119),heltab2x16(:,:,235))
  call Hloop_SV_V(ntryL,G0H16(18),wf4(:,1),G0H4(10),m3h4x4(:,120),heltab2x16(:,:,236))
  call Hloop_SV_V(ntryL,G0H16(19),wf4(:,1),G0H4(11),m3h4x4(:,121),heltab2x16(:,:,237))
  call Hloop_SV_V(ntryL,G0H16(20),wf4(:,1),G0H4(12),m3h4x4(:,122),heltab2x16(:,:,238))
  call Hloop_SV_V(ntryL,G0H16(21),wf4(:,4),G0H4(13),m3h4x4(:,123),heltab2x16(:,:,239))
  call Hloop_SV_V(ntryL,G0H16(22),wf4(:,4),G0H4(14),m3h4x4(:,124),heltab2x16(:,:,240))
  call Hloop_SV_V(ntryL,G0H16(23),wf4(:,4),G0H4(15),m3h4x4(:,125),heltab2x16(:,:,241))
  call Hloop_SV_V(ntryL,G0H16(24),wf4(:,4),G0H4(16),m3h4x4(:,126),heltab2x16(:,:,242))
  call Hloop_UW_V(ntryL,G0H16(25),16,wf4(:,1),5,G1H4(229),m3h4x4(:,127),heltab2x16(:,:,243))
  call Hloop_UV_W(ntryL,G0H16(26),16,wf4(:,1),5,G1H4(232),m3h4x4(:,128),heltab2x16(:,:,244))
  call Hloop_UW_V(ntryL,G0H16(27),16,wf4(:,1),5,G1H4(233),m3h4x4(:,129),heltab2x16(:,:,245))
  call Hloop_UV_W(ntryL,G0H16(28),16,wf4(:,1),5,G1H4(234),m3h4x4(:,130),heltab2x16(:,:,246))
  call Hloop_UW_V(ntryL,G0H16(29),16,wf4(:,4),5,G1H4(237),m3h4x4(:,131),heltab2x16(:,:,247))
  call Hloop_UV_W(ntryL,G0H16(30),16,wf4(:,4),5,G1H4(238),m3h4x4(:,132),heltab2x16(:,:,248))
  call Hloop_UW_V(ntryL,G0H16(31),16,wf4(:,4),5,G1H4(239),m3h4x4(:,133),heltab2x16(:,:,249))
  call Hloop_UV_W(ntryL,G0H16(32),16,wf4(:,4),5,G1H4(242),m3h4x4(:,134),heltab2x16(:,:,250))
  call Hloop_VV_S(ntryL,G1H16(98),wf4(:,1),G1H4(91),m3h4x4(:,135),heltab2x16(:,:,251))
  call Hloop_VV_S(ntryL,G1H16(100),wf4(:,1),G1H4(92),m3h4x4(:,136),heltab2x16(:,:,252))
  call Hloop_VV_S(ntryL,G1H16(102),wf4(:,4),G1H4(245),m3h4x4(:,137),heltab2x16(:,:,253))
  call Hloop_VV_S(ntryL,G1H16(104),wf4(:,4),G1H4(246),m3h4x4(:,138),heltab2x16(:,:,254))
  call Hloop_QV_A(ntryL,G1H8(40),wf4(:,1),G1H2(204),m3h4x2(:,41),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(204),23,0,G2H2(67),n2h2(95))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,1),G1H2(208),m3h4x2(:,42),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H2(208),23,0,G2H2(73),n2h2(96))
  call Hloop_QZ_A(ntryL,G1H8(43),wf4(:,4),G1H2(209),ngZd,m3h4x2(:,43),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(209),23,0,G2H2(79),n2h2(97))
  call Hloop_QZ_A(ntryL,G1H8(44),wf4(:,4),G1H2(210),ngZd,m3h4x2(:,44),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(210),23,0,G2H2(85),n2h2(98))
  call Hloop_UV_W(ntryL,G0H8(6),18,wf4(:,1),5,G1H2(214),m3h4x2(:,45),heltab2x8(:,:,225))
  call Hloop_UV_W(ntryL,G0H8(7),18,wf4(:,4),5,G1H2(215),m3h4x2(:,46),heltab2x8(:,:,226))
  call Hloop_VQ_A(ntryL,G0H8(8),ex2(:),G0H4(17),m3h2x4(:,181),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(247),n2h4(229))
  call Hloop_ZQ_A(ntryL,G0H8(9),ex2(:),G0H4(17),ngZd,m3h2x4(:,182),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(250),n2h4(230))
  call Hloop_WQ_A(ntryL,G0H8(10),ex2(:),G0H4(17),m3h2x4(:,183),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(95),n2h4(231))
  call Hloop_VQ_A(ntryL,G0H8(11),ex2(:),G0H4(17),m3h2x4(:,184),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(58),n2h4(232))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex2(:),G0H4(17),ngZd,m3h2x4(:,185),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(55),n2h4(233))
  call Hloop_WQ_A(ntryL,G0H8(13),ex2(:),G0H4(17),m3h2x4(:,186),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G0H4(17),26,0,G1H4(15),n2h4(234))
  call Hloop_AQ_W(ntryL,G1H8(46),ex2(:),G1H4(16),m3h2x4(:,187),heltab2x8(:,:,233))
  call Hloop_AQ_W(ntryL,G1H8(47),ex2(:),G1H4(29),m3h2x4(:,188),heltab2x8(:,:,234))
  call Hloop_AQ_V(ntryL,G1H16(105),wf8(:,55),G1H2(216),m3h8x2(:,1),heltab2x16(:,:,255))
  call Hloop_AQ_Z(ntryL,G1H16(106),wf8(:,55),G1H2(220),ngZd,m3h8x2(:,2),heltab2x16(:,:,256))
  call Hloop_AQ_W(ntryL,G1H16(107),wf8(:,55),G1H2(144),m3h8x2(:,3),heltab2x16(:,:,257))
  call Hloop_AQ_V(ntryL,G1H16(108),wf8(:,56),G1H2(108),m3h8x2(:,4),heltab2x16(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H16(109),wf8(:,56),G1H2(7),ngZd,m3h8x2(:,5),heltab2x16(:,:,259))
  call Hloop_AQ_W(ntryL,G1H16(110),wf8(:,56),G1H2(56),m3h8x2(:,6),heltab2x16(:,:,260))
  call Hloop_WQ_A(ntryL,G1H16(111),wf8(:,55),G1H2(20),m3h8x2(:,7),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(20),23,0,G2H2(68),n2h2(99))
  call Hloop_WQ_A(ntryL,G1H16(112),wf8(:,56),G1H2(8),m3h8x2(:,8),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(80),n2h2(100))
  call Hloop_AQ_V(ntryL,G1H16(113),ex2(:),G1H8(64),m3h2x8(:,117),heltab2x16(:,:,263))
  call Hloop_AQ_Z(ntryL,G1H16(114),ex2(:),G1H8(65),ngZd,m3h2x8(:,118),heltab2x16(:,:,264))
  call Hloop_AQ_W(ntryL,G1H16(115),ex2(:),G1H8(66),m3h2x8(:,119),heltab2x16(:,:,265))
  call Hloop_AQ_V(ntryL,G1H16(116),ex2(:),G1H8(67),m3h2x8(:,120),heltab2x16(:,:,266))
  call Hloop_AQ_Z(ntryL,G1H16(117),ex2(:),G1H8(68),ngZd,m3h2x8(:,121),heltab2x16(:,:,267))
  call Hloop_AQ_W(ntryL,G1H16(118),ex2(:),G1H8(69),m3h2x8(:,122),heltab2x16(:,:,268))
  call Hloop_WQ_A(ntryL,G1H16(119),ex2(:),G1H8(70),m3h2x8(:,123),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G1H8(70),18,0,G2H8(1),n2h8(105))
  call Hloop_WQ_A(ntryL,G1H16(120),ex2(:),G1H8(71),m3h2x8(:,124),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H8(71),18,0,G2H8(2),n2h8(106))
  call Hloop_QV_A(ntryL,G1H16(121),wf4(:,8),G1H4(28),m3h4x4(:,139),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(28),22,nME,G2H4(79),n2h4(235))
  call Hloop_QV_A(ntryL,G1H16(122),wf4(:,8),G1H4(8),m3h4x4(:,140),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(8),22,nMM,G2H4(80),n2h4(236))
  call Hloop_QV_A(ntryL,G1H16(123),wf4(:,8),G1H4(109),m3h4x4(:,141),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(109),22,nML,G2H4(81),n2h4(237))
  call Hloop_AV_Q(ntryL,G1H16(124),wf4(:,8),G1H4(44),m3h4x4(:,142),heltab2x16(:,:,274))
  call Hloop_A_Q(ntryL,G1H4(44),22,nME,G2H4(82),n2h4(238))
  call Hloop_AV_Q(ntryL,G1H16(125),wf4(:,8),G1H4(43),m3h4x4(:,143),heltab2x16(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(43),22,nMM,G2H4(83),n2h4(239))
  call Hloop_AV_Q(ntryL,G1H16(126),wf4(:,8),G1H4(123),m3h4x4(:,144),heltab2x16(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(123),22,nML,G2H4(84),n2h4(240))
  call Hloop_QV_A(ntryL,G1H16(131),wf4(:,8),G1H4(70),m3h4x4(:,145),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G1H4(70),22,0,G2H4(85),n2h4(241))
  call Hloop_QV_A(ntryL,G1H16(128),wf4(:,8),G1H4(69),m3h4x4(:,146),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(69),22,nMT,G2H4(86),n2h4(242))
  call Hloop_AV_Q(ntryL,G1H16(133),wf4(:,8),G1H4(73),m3h4x4(:,147),heltab2x16(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(73),22,0,G2H4(87),n2h4(243))
  call Hloop_AV_Q(ntryL,G1H16(130),wf4(:,8),G1H4(17),m3h4x4(:,148),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(17),22,nMT,G2H4(88),n2h4(244))
  call Hloop_QV_A(ntryL,G1H16(132),wf4(:,8),G1H4(7),m3h4x4(:,149),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(7),22,nMB,G2H4(89),n2h4(245))
  call Hloop_AV_Q(ntryL,G1H16(134),wf4(:,8),G1H4(74),m3h4x4(:,150),heltab2x16(:,:,282))
  call Hloop_A_Q(ntryL,G1H4(74),22,nMB,G2H4(90),n2h4(246))
  call Hloop_QZ_A(ntryL,G1H16(135),wf4(:,10),G1H4(18),ngZl,m3h4x4(:,151),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(18),22,nME,G2H4(91),n2h4(247))
  call Hloop_QZ_A(ntryL,G1H16(136),wf4(:,10),G1H4(11),ngZl,m3h4x4(:,152),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G1H4(11),22,nMM,G2H4(92),n2h4(248))
  call Hloop_QZ_A(ntryL,G1H16(137),wf4(:,10),G1H4(75),ngZl,m3h4x4(:,153),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(75),22,nML,G2H4(93),n2h4(249))
  call Hloop_AZ_Q(ntryL,G1H16(138),wf4(:,10),G1H4(27),ngZl,m3h4x4(:,154),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(27),22,nME,G2H4(94),n2h4(250))
  call Hloop_AZ_Q(ntryL,G1H16(139),wf4(:,10),G1H4(14),ngZl,m3h4x4(:,155),heltab2x16(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(14),22,nMM,G2H4(95),n2h4(251))
  call Hloop_AZ_Q(ntryL,G1H16(140),wf4(:,10),G1H4(99),ngZl,m3h4x4(:,156),heltab2x16(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(99),22,nML,G2H4(96),n2h4(252))
  call Hloop_QZ_A(ntryL,G1H16(141),wf4(:,10),G1H4(38),ngZu,m3h4x4(:,157),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(38),22,0,G2H4(97),n2h4(253))
  call Hloop_QZ_A(ntryL,G1H16(142),wf4(:,10),G1H4(32),ngZu,m3h4x4(:,158),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(32),22,nMT,G2H4(98),n2h4(254))
  call Hloop_AZ_Q(ntryL,G1H16(143),wf4(:,10),G1H4(100),ngZu,m3h4x4(:,159),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(100),22,0,G2H4(99),n2h4(255))
  call Hloop_AZ_Q(ntryL,G1H16(144),wf4(:,10),G1H4(39),ngZu,m3h4x4(:,160),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(39),22,nMT,G2H4(100),n2h4(256))
  call Hloop_QZ_A(ntryL,G1H16(145),wf4(:,10),G1H4(33),ngZd,m3h4x4(:,161),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(33),22,0,G2H4(101),n2h4(257))
  call Hloop_QZ_A(ntryL,G1H16(146),wf4(:,10),G1H4(103),ngZd,m3h4x4(:,162),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(103),22,nMB,G2H4(102),n2h4(258))
  call Hloop_AZ_Q(ntryL,G1H16(147),wf4(:,10),G1H4(40),ngZd,m3h4x4(:,163),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(40),22,0,G2H4(103),n2h4(259))
  call Hloop_AZ_Q(ntryL,G1H16(148),wf4(:,10),G1H4(34),ngZd,m3h4x4(:,164),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(34),22,nMB,G2H4(104),n2h4(260))
  call Hloop_QV_A(ntryL,G1H16(149),wf4(:,8),G1H4(9),m3h4x4(:,165),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(9),22,nME,G2H4(105),n2h4(261))
  call Hloop_QV_A(ntryL,G1H16(150),wf4(:,8),G1H4(50),m3h4x4(:,166),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(50),22,nMM,G2H4(106),n2h4(262))
  call Hloop_QV_A(ntryL,G1H16(151),wf4(:,8),G1H4(45),m3h4x4(:,167),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(45),22,nML,G2H4(107),n2h4(263))
  call Hloop_AV_Q(ntryL,G1H16(152),wf4(:,8),G1H4(82),m3h4x4(:,168),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(82),22,nME,G2H4(108),n2h4(264))
  call Hloop_AV_Q(ntryL,G1H16(153),wf4(:,8),G1H4(53),m3h4x4(:,169),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(53),22,nMM,G2H4(109),n2h4(265))
  call Hloop_AV_Q(ntryL,G1H16(154),wf4(:,8),G1H4(48),m3h4x4(:,170),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(48),22,nML,G2H4(110),n2h4(266))
  call Hloop_QV_A(ntryL,G1H16(155),wf4(:,8),G1H4(21),m3h4x4(:,171),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(21),22,0,G2H4(111),n2h4(267))
  call Hloop_QV_A(ntryL,G1H16(156),wf4(:,8),G1H4(54),m3h4x4(:,172),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(54),22,nMT,G2H4(112),n2h4(268))
  call Hloop_AV_Q(ntryL,G1H16(157),wf4(:,8),G1H4(49),m3h4x4(:,173),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(49),22,0,G2H4(113),n2h4(269))
  call Hloop_AV_Q(ntryL,G1H16(158),wf4(:,8),G1H4(113),m3h4x4(:,174),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G1H4(113),22,nMT,G2H4(114),n2h4(270))
  call Hloop_QV_A(ntryL,G1H16(159),wf4(:,8),G1H4(64),m3h4x4(:,175),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(64),22,0,G2H4(115),n2h4(271))
  call Hloop_QV_A(ntryL,G1H16(160),wf4(:,8),G1H4(59),m3h4x4(:,176),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(59),22,nMB,G2H4(116),n2h4(272))
  call Hloop_AV_Q(ntryL,G1H16(161),wf4(:,8),G1H4(114),m3h4x4(:,177),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G1H4(114),22,0,G2H4(117),n2h4(273))
  call Hloop_AV_Q(ntryL,G1H16(162),wf4(:,8),G1H4(65),m3h4x4(:,178),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G1H4(65),22,nMB,G2H4(118),n2h4(274))
  call Hloop_QZ_A(ntryL,G1H16(163),wf4(:,10),G1H4(60),ngZl,m3h4x4(:,179),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H4(60),22,nME,G2H4(119),n2h4(275))
  call Hloop_QZ_A(ntryL,G1H16(164),wf4(:,10),G1H4(115),ngZl,m3h4x4(:,180),heltab2x16(:,:,312))
  call Hloop_Q_A(ntryL,G1H4(115),22,nMM,G2H4(120),n2h4(276))
  call Hloop_QZ_A(ntryL,G1H16(165),wf4(:,10),G1H4(68),ngZl,m3h4x4(:,181),heltab2x16(:,:,313))
  call Hloop_Q_A(ntryL,G1H4(68),22,nML,G2H4(121),n2h4(277))
  call Hloop_AZ_Q(ntryL,G1H16(166),wf4(:,10),G1H4(63),ngZl,m3h4x4(:,182),heltab2x16(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(63),22,nME,G2H4(122),n2h4(278))
  call Hloop_AZ_Q(ntryL,G1H16(167),wf4(:,10),G1H4(98),ngZl,m3h4x4(:,183),heltab2x16(:,:,315))
  call Hloop_A_Q(ntryL,G1H4(98),22,nMM,G2H4(123),n2h4(279))
  call Hloop_AZ_Q(ntryL,G1H16(168),wf4(:,10),G1H4(36),ngZl,m3h4x4(:,184),heltab2x16(:,:,316))
  call Hloop_A_Q(ntryL,G1H4(36),22,nML,G2H4(124),n2h4(280))
  call Hloop_QZ_A(ntryL,G1H16(169),wf4(:,10),G1H4(110),ngZu,m3h4x4(:,185),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G1H4(110),22,0,G2H4(125),n2h4(281))
  call Hloop_QZ_A(ntryL,G1H16(170),wf4(:,10),G1H4(124),ngZu,m3h4x4(:,186),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G1H4(124),22,nMT,G2H4(126),n2h4(282))
  call Hloop_AZ_Q(ntryL,G1H16(171),wf4(:,10),G1H4(125),ngZu,m3h4x4(:,187),heltab2x16(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(125),22,0,G2H4(127),n2h4(283))
  call Hloop_AZ_Q(ntryL,G1H16(172),wf4(:,10),G1H4(128),ngZu,m3h4x4(:,188),heltab2x16(:,:,320))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(128),n2h4(284))
  call Hloop_QZ_A(ntryL,G1H16(173),wf4(:,10),G1H4(85),ngZd,m3h4x4(:,189),heltab2x16(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(85),22,0,G2H4(129),n2h4(285))
  call Hloop_QZ_A(ntryL,G1H16(174),wf4(:,10),G1H4(86),ngZd,m3h4x4(:,190),heltab2x16(:,:,322))
  call Hloop_Q_A(ntryL,G1H4(86),22,nMB,G2H4(130),n2h4(286))
  call Hloop_AZ_Q(ntryL,G1H16(175),wf4(:,10),G1H4(131),ngZd,m3h4x4(:,191),heltab2x16(:,:,323))
  call Hloop_A_Q(ntryL,G1H4(131),22,0,G2H4(131),n2h4(287))
  call Hloop_AZ_Q(ntryL,G1H16(176),wf4(:,10),G1H4(132),ngZd,m3h4x4(:,192),heltab2x16(:,:,324))
  call Hloop_A_Q(ntryL,G1H4(132),22,nMB,G2H4(132),n2h4(288))
  call Hloop_TV_S(ntryL,G1H16(177),16,wf4(:,8),6,G2H4(133),m3h4x4(:,193),heltab2x16(:,:,325))
  call Hloop_SV_T(ntryL,G1H16(178),16,wf4(:,8),6,G2H4(134),m3h4x4(:,194),heltab2x16(:,:,326))
  call Hloop_TV_S(ntryL,G1H16(179),16,wf4(:,10),6,G2H4(135),m3h4x4(:,195),heltab2x16(:,:,327))
  call Hloop_SV_T(ntryL,G1H16(180),16,wf4(:,10),6,G2H4(136),m3h4x4(:,196),heltab2x16(:,:,328))
  call Hloop_TV_S(ntryL,G1H16(181),16,wf4(:,8),6,G2H4(137),m3h4x4(:,197),heltab2x16(:,:,329))
  call Hloop_SV_T(ntryL,G1H16(182),16,wf4(:,8),6,G2H4(138),m3h4x4(:,198),heltab2x16(:,:,330))
  call Hloop_TV_S(ntryL,G1H16(183),16,wf4(:,10),6,G2H4(139),m3h4x4(:,199),heltab2x16(:,:,331))
  call Hloop_SV_T(ntryL,G1H16(184),16,wf4(:,10),6,G2H4(140),m3h4x4(:,200),heltab2x16(:,:,332))
  call Hloop_CV_D(ntryL,G1H16(187),16,wf4(:,8),6,G2H4(141),m3h4x4(:,201),heltab2x16(:,:,333))
  call Hloop_DV_C(ntryL,G1H16(188),16,wf4(:,8),G2H4(142),m3h4x4(:,202),heltab2x16(:,:,334))
  call Hloop_CV_D(ntryL,G1H16(191),16,wf4(:,10),6,G2H4(143),m3h4x4(:,203),heltab2x16(:,:,335))
  call Hloop_DV_C(ntryL,G1H16(192),16,wf4(:,10),G2H4(144),m3h4x4(:,204),heltab2x16(:,:,336))
  call Hloop_CV_D(ntryL,G1H16(195),16,wf4(:,8),6,G2H4(145),m3h4x4(:,205),heltab2x16(:,:,337))
  call Hloop_DV_C(ntryL,G1H16(196),16,wf4(:,8),G2H4(146),m3h4x4(:,206),heltab2x16(:,:,338))
  call Hloop_CV_D(ntryL,G1H16(199),16,wf4(:,10),6,G2H4(147),m3h4x4(:,207),heltab2x16(:,:,339))
  call Hloop_DV_C(ntryL,G1H16(200),16,wf4(:,10),G2H4(148),m3h4x4(:,208),heltab2x16(:,:,340))
  call Hloop_UV_W(ntryL,G1H16(201),16,wf4(:,8),6,G2H4(149),m3h4x4(:,209),heltab2x16(:,:,341))
  call Hloop_UW_V(ntryL,G1H16(202),16,wf4(:,8),6,G2H4(150),m3h4x4(:,210),heltab2x16(:,:,342))
  call Hloop_UV_W(ntryL,G1H16(203),16,wf4(:,10),6,G2H4(151),m3h4x4(:,211),heltab2x16(:,:,343))
  call Hloop_UW_V(ntryL,G1H16(204),16,wf4(:,10),6,G2H4(152),m3h4x4(:,212),heltab2x16(:,:,344))
  call Hloop_UV_W(ntryL,G1H16(205),16,wf4(:,8),6,G2H4(153),m3h4x4(:,213),heltab2x16(:,:,345))
  call Hloop_UW_V(ntryL,G1H16(206),16,wf4(:,8),6,G2H4(154),m3h4x4(:,214),heltab2x16(:,:,346))
  call Hloop_UV_W(ntryL,G1H16(207),16,wf4(:,10),6,G2H4(155),m3h4x4(:,215),heltab2x16(:,:,347))
  call Hloop_UW_V(ntryL,G1H16(208),16,wf4(:,10),6,G2H4(156),m3h4x4(:,216),heltab2x16(:,:,348))
  call Hloop_SV_V(ntryL,G1H16(210),wf4(:,8),G1H4(133),m3h4x4(:,217),heltab2x16(:,:,349))
  call Hloop_SV_V(ntryL,G1H16(212),wf4(:,10),G1H4(136),m3h4x4(:,218),heltab2x16(:,:,350))
  call Hloop_SV_V(ntryL,G1H16(214),wf4(:,8),G1H4(137),m3h4x4(:,219),heltab2x16(:,:,351))
  call Hloop_SV_V(ntryL,G1H16(216),wf4(:,10),G1H4(138),m3h4x4(:,220),heltab2x16(:,:,352))
  call Hloop_VV_S(ntryL,G0H16(33),wf4(:,8),G0H4(17),m3h4x4(:,221),heltab2x16(:,:,353))
  call Hloop_VV_S(ntryL,G0H16(34),wf4(:,8),G0H4(18),m3h4x4(:,222),heltab2x16(:,:,354))
  call Hloop_VV_S(ntryL,G0H16(35),wf4(:,10),G0H4(19),m3h4x4(:,223),heltab2x16(:,:,355))
  call Hloop_VV_S(ntryL,G0H16(36),wf4(:,10),G0H4(20),m3h4x4(:,224),heltab2x16(:,:,356))
  call Hloop_VV_S(ntryL,G0H16(37),wf4(:,8),G0H4(21),m3h4x4(:,225),heltab2x16(:,:,357))
  call Hloop_VV_S(ntryL,G0H16(38),wf4(:,8),G0H4(22),m3h4x4(:,226),heltab2x16(:,:,358))
  call Hloop_VV_S(ntryL,G0H16(39),wf4(:,10),G0H4(23),m3h4x4(:,227),heltab2x16(:,:,359))
  call Hloop_VV_S(ntryL,G0H16(40),wf4(:,10),G0H4(24),m3h4x4(:,228),heltab2x16(:,:,360))
  call Hloop_TV_S(ntryL,G0H16(41),16,wf4(:,8),6,G1H4(141),m3h4x4(:,229),heltab2x16(:,:,361))
  call Hloop_SV_T(ntryL,G0H16(42),16,wf4(:,8),6,G1H4(142),m3h4x4(:,230),heltab2x16(:,:,362))
  call Hloop_TV_S(ntryL,G0H16(43),16,wf4(:,10),6,G1H4(143),m3h4x4(:,231),heltab2x16(:,:,363))
  call Hloop_SV_T(ntryL,G0H16(44),16,wf4(:,10),6,G1H4(146),m3h4x4(:,232),heltab2x16(:,:,364))
  call Hloop_TV_S(ntryL,G0H16(45),16,wf4(:,8),6,G1H4(147),m3h4x4(:,233),heltab2x16(:,:,365))
  call Hloop_SV_T(ntryL,G0H16(46),16,wf4(:,8),6,G1H4(148),m3h4x4(:,234),heltab2x16(:,:,366))
  call Hloop_TV_S(ntryL,G0H16(47),16,wf4(:,10),6,G1H4(151),m3h4x4(:,235),heltab2x16(:,:,367))
  call Hloop_SV_T(ntryL,G0H16(48),16,wf4(:,10),6,G1H4(152),m3h4x4(:,236),heltab2x16(:,:,368))
  call Hloop_UV_W(ntryL,G0H16(49),16,wf4(:,8),6,G1H4(153),m3h4x4(:,237),heltab2x16(:,:,369))
  call Hloop_UW_V(ntryL,G0H16(50),16,wf4(:,8),6,G1H4(156),m3h4x4(:,238),heltab2x16(:,:,370))
  call Hloop_UV_W(ntryL,G0H16(51),16,wf4(:,10),6,G1H4(157),m3h4x4(:,239),heltab2x16(:,:,371))
  call Hloop_UW_V(ntryL,G0H16(52),16,wf4(:,10),6,G1H4(158),m3h4x4(:,240),heltab2x16(:,:,372))
  call Hloop_UV_W(ntryL,G0H16(53),16,wf4(:,8),6,G1H4(161),m3h4x4(:,241),heltab2x16(:,:,373))
  call Hloop_UW_V(ntryL,G0H16(54),16,wf4(:,8),6,G1H4(162),m3h4x4(:,242),heltab2x16(:,:,374))
  call Hloop_UV_W(ntryL,G0H16(55),16,wf4(:,10),6,G1H4(163),m3h4x4(:,243),heltab2x16(:,:,375))
  call Hloop_UW_V(ntryL,G0H16(56),16,wf4(:,10),6,G1H4(166),m3h4x4(:,244),heltab2x16(:,:,376))
  call Hloop_SV_V(ntryL,G0H16(57),wf4(:,8),G0H4(25),m3h4x4(:,245),heltab2x16(:,:,377))
  call Hloop_SV_V(ntryL,G0H16(58),wf4(:,8),G0H4(26),m3h4x4(:,246),heltab2x16(:,:,378))
  call Hloop_SV_V(ntryL,G0H16(59),wf4(:,10),G0H4(27),m3h4x4(:,247),heltab2x16(:,:,379))
  call Hloop_SV_V(ntryL,G0H16(60),wf4(:,10),G0H4(28),m3h4x4(:,248),heltab2x16(:,:,380))
  call Hloop_SV_V(ntryL,G0H16(61),wf4(:,8),G0H4(29),m3h4x4(:,249),heltab2x16(:,:,381))
  call Hloop_SV_V(ntryL,G0H16(62),wf4(:,8),G0H4(30),m3h4x4(:,250),heltab2x16(:,:,382))
  call Hloop_SV_V(ntryL,G0H16(63),wf4(:,10),G0H4(31),m3h4x4(:,251),heltab2x16(:,:,383))
  call Hloop_SV_V(ntryL,G0H16(64),wf4(:,10),G0H4(32),m3h4x4(:,252),heltab2x16(:,:,384))
  call Hloop_VV_S(ntryL,G1H16(218),wf4(:,8),G1H4(87),m3h4x4(:,253),heltab2x16(:,:,385))
  call Hloop_VV_S(ntryL,G1H16(220),wf4(:,10),G1H4(88),m3h4x4(:,254),heltab2x16(:,:,386))
  call Hloop_VV_S(ntryL,G1H16(222),wf4(:,8),G1H4(169),m3h4x4(:,255),heltab2x16(:,:,387))
  call Hloop_VV_S(ntryL,G1H16(224),wf4(:,10),G1H4(170),m3h4x4(:,256),heltab2x16(:,:,388))
  call Hloop_QV_A(ntryL,G1H8(48),wf4(:,8),G1H2(9),m3h4x2(:,47),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(74),n2h2(101))
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,8),G1H2(13),m3h4x2(:,48),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(13),23,0,G2H2(86),n2h2(102))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,10),G1H2(62),ngZd,m3h4x2(:,49),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(62),23,0,G2H2(12),n2h2(103))
  call Hloop_QZ_A(ntryL,G1H8(52),wf4(:,10),G1H2(26),ngZd,m3h4x2(:,50),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(13),n2h2(104))
  call Hloop_UV_W(ntryL,G0H8(22),17,wf4(:,8),6,G1H2(14),m3h4x2(:,51),heltab2x8(:,:,239))
  call Hloop_UV_W(ntryL,G0H8(23),17,wf4(:,10),6,G1H2(15),m3h4x2(:,52),heltab2x8(:,:,240))
  call Hloop_VQ_A(ntryL,G0H8(24),ex1(:),G0H4(33),m3h2x4(:,189),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(171),n2h4(289))
  call Hloop_ZQ_A(ntryL,G0H8(25),ex1(:),G0H4(33),ngZd,m3h2x4(:,190),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(174),n2h4(290))
  call Hloop_WQ_A(ntryL,G0H8(26),ex1(:),G0H4(33),m3h2x4(:,191),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(175),n2h4(291))
  call Hloop_VQ_A(ntryL,G0H8(27),ex1(:),G0H4(33),m3h2x4(:,192),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(176),n2h4(292))
  call Hloop_ZQ_A(ntryL,G0H8(28),ex1(:),G0H4(33),ngZd,m3h2x4(:,193),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(179),n2h4(293))
  call Hloop_WQ_A(ntryL,G0H8(29),ex1(:),G0H4(33),m3h2x4(:,194),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G0H4(33),25,0,G1H4(180),n2h4(294))
  call Hloop_AQ_W(ntryL,G1H8(54),ex1(:),G1H4(181),m3h2x4(:,195),heltab2x8(:,:,247))
  call Hloop_AQ_W(ntryL,G1H8(55),ex1(:),G1H4(184),m3h2x4(:,196),heltab2x8(:,:,248))
  call Hloop_AQ_V(ntryL,G1H16(225),wf8(:,63),G1H2(19),m3h8x2(:,9),heltab2x16(:,:,389))
  call Hloop_AQ_Z(ntryL,G1H16(226),wf8(:,63),G1H2(21),ngZd,m3h8x2(:,10),heltab2x16(:,:,390))
  call Hloop_AQ_W(ntryL,G1H16(227),wf8(:,63),G1H2(25),m3h8x2(:,11),heltab2x16(:,:,391))
  call Hloop_AQ_V(ntryL,G1H16(228),wf8(:,64),G1H2(27),m3h8x2(:,12),heltab2x16(:,:,392))
  call Hloop_AQ_Z(ntryL,G1H16(229),wf8(:,64),G1H2(31),ngZd,m3h8x2(:,13),heltab2x16(:,:,393))
  call Hloop_AQ_W(ntryL,G1H16(230),wf8(:,64),G1H2(80),m3h8x2(:,14),heltab2x16(:,:,394))
  call Hloop_WQ_A(ntryL,G1H16(231),wf8(:,63),G1H2(44),m3h8x2(:,15),heltab2x16(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(44),23,0,G2H2(14),n2h2(105))
  call Hloop_WQ_A(ntryL,G1H16(232),wf8(:,64),G1H2(32),m3h8x2(:,16),heltab2x16(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(32),23,0,G2H2(11),n2h2(106))
  call Hloop_AQ_V(ntryL,G1H16(233),ex1(:),G1H8(72),m3h2x8(:,125),heltab2x16(:,:,397))
  call Hloop_AQ_Z(ntryL,G1H16(234),ex1(:),G1H8(73),ngZd,m3h2x8(:,126),heltab2x16(:,:,398))
  call Hloop_AQ_W(ntryL,G1H16(235),ex1(:),G1H8(74),m3h2x8(:,127),heltab2x16(:,:,399))
  call Hloop_AQ_V(ntryL,G1H16(236),ex1(:),G1H8(75),m3h2x8(:,128),heltab2x16(:,:,400))
  call Hloop_AQ_Z(ntryL,G1H16(237),ex1(:),G1H8(76),ngZd,m3h2x8(:,129),heltab2x16(:,:,401))
  call Hloop_AQ_W(ntryL,G1H16(238),ex1(:),G1H8(77),m3h2x8(:,130),heltab2x16(:,:,402))
  call Hloop_WQ_A(ntryL,G1H16(239),ex1(:),G1H8(78),m3h2x8(:,131),heltab2x16(:,:,403))
  call Hloop_Q_A(ntryL,G1H8(78),17,0,G2H8(3),n2h8(107))
  call Hloop_WQ_A(ntryL,G1H16(240),ex1(:),G1H8(79),m3h2x8(:,132),heltab2x16(:,:,404))
  call Hloop_Q_A(ntryL,G1H8(79),17,0,G2H8(4),n2h8(108))
  call Hloop_VA_Q(ntryL,G0H8(32),ex3(:),G0H4(33),m3h2x4(:,197),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(185),n2h4(295))
  call Hloop_ZA_Q(ntryL,G0H8(33),ex3(:),G0H4(33),ngZd,m3h2x4(:,198),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(186),n2h4(296))
  call Hloop_WA_Q(ntryL,G0H8(34),ex3(:),G0H4(33),m3h2x4(:,199),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(189),n2h4(297))
  call Hloop_VA_Q(ntryL,G0H8(35),ex3(:),G0H4(33),m3h2x4(:,200),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(190),n2h4(298))
  call Hloop_ZA_Q(ntryL,G0H8(36),ex3(:),G0H4(33),ngZd,m3h2x4(:,201),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(191),n2h4(299))
  call Hloop_WA_Q(ntryL,G0H8(37),ex3(:),G0H4(33),m3h2x4(:,202),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G0H4(33),22,0,G1H4(194),n2h4(300))
  call Hloop_QA_W(ntryL,G1H8(56),ex3(:),G1H4(195),m3h2x4(:,203),heltab2x8(:,:,255))
  call Hloop_QA_W(ntryL,G1H8(57),ex3(:),G1H4(196),m3h2x4(:,204),heltab2x8(:,:,256))
  call Hloop_VQ_A(ntryL,G0H8(3),ex2(:),G0H4(33),m3h2x4(:,205),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(199),n2h4(301))
  call Hloop_ZQ_A(ntryL,G0H8(4),ex2(:),G0H4(33),ngZd,m3h2x4(:,206),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(200),n2h4(302))
  call Hloop_WQ_A(ntryL,G0H8(5),ex2(:),G0H4(33),m3h2x4(:,207),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(201),n2h4(303))
  call Hloop_VQ_A(ntryL,G0H8(14),ex2(:),G0H4(33),m3h2x4(:,208),heltab2x8(:,:,260))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(204),n2h4(304))
  call Hloop_ZQ_A(ntryL,G0H8(15),ex2(:),G0H4(33),ngZd,m3h2x4(:,209),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(89),n2h4(305))
  call Hloop_WQ_A(ntryL,G0H8(16),ex2(:),G0H4(33),m3h2x4(:,210),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G0H4(33),22,0,G1H4(90),n2h4(306))
  call Hloop_AQ_W(ntryL,G1H8(58),ex2(:),G1H4(207),m3h2x4(:,211),heltab2x8(:,:,263))
  call Hloop_AQ_W(ntryL,G1H8(59),ex2(:),G1H4(208),m3h2x4(:,212),heltab2x8(:,:,264))
  call Hloop_QA_V(ntryL,G1H16(241),ex3(:),G1H8(80),m3h2x8(:,133),heltab2x16(:,:,405))
  call Hloop_QA_Z(ntryL,G1H16(242),ex3(:),G1H8(81),ngZd,m3h2x8(:,134),heltab2x16(:,:,406))
  call Hloop_QA_W(ntryL,G1H16(243),ex3(:),G1H8(82),m3h2x8(:,135),heltab2x16(:,:,407))
  call Hloop_QA_V(ntryL,G1H16(244),ex3(:),G1H8(83),m3h2x8(:,136),heltab2x16(:,:,408))
  call Hloop_QA_Z(ntryL,G1H16(245),ex3(:),G1H8(84),ngZd,m3h2x8(:,137),heltab2x16(:,:,409))
  call Hloop_QA_W(ntryL,G1H16(246),ex3(:),G1H8(85),m3h2x8(:,138),heltab2x16(:,:,410))
  call Hloop_WA_Q(ntryL,G1H16(247),ex3(:),G1H8(86),m3h2x8(:,139),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H8(86),20,0,G2H8(5),n2h8(109))
  call Hloop_WA_Q(ntryL,G1H16(248),ex3(:),G1H8(87),m3h2x8(:,140),heltab2x16(:,:,412))
  call Hloop_A_Q(ntryL,G1H8(87),20,0,G2H8(6),n2h8(110))
  call Hloop_AQ_V(ntryL,G1H16(249),ex2(:),G1H8(88),m3h2x8(:,141),heltab2x16(:,:,413))
  call Hloop_AQ_Z(ntryL,G1H16(250),ex2(:),G1H8(89),ngZd,m3h2x8(:,142),heltab2x16(:,:,414))
  call Hloop_AQ_W(ntryL,G1H16(251),ex2(:),G1H8(90),m3h2x8(:,143),heltab2x16(:,:,415))
  call Hloop_AQ_V(ntryL,G1H16(252),ex2(:),G1H8(91),m3h2x8(:,144),heltab2x16(:,:,416))
  call Hloop_AQ_Z(ntryL,G1H16(253),ex2(:),G1H8(92),ngZd,m3h2x8(:,145),heltab2x16(:,:,417))
  call Hloop_AQ_W(ntryL,G1H16(254),ex2(:),G1H8(93),m3h2x8(:,146),heltab2x16(:,:,418))
  call Hloop_WQ_A(ntryL,G1H16(255),ex2(:),G1H8(37),m3h2x8(:,147),heltab2x16(:,:,419))
  call Hloop_Q_A(ntryL,G1H8(37),18,0,G2H8(7),n2h8(111))
  call Hloop_WQ_A(ntryL,G1H16(256),ex2(:),G1H8(2),m3h2x8(:,148),heltab2x16(:,:,420))
  call Hloop_Q_A(ntryL,G1H8(2),18,0,G2H8(8),n2h8(112))
  call Hloop_VA_Q(ntryL,G0H8(19),ex3(:),G0H4(33),m3h2x4(:,213),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(28),n2h4(307))
  call Hloop_ZA_Q(ntryL,G0H8(20),ex3(:),G0H4(33),ngZd,m3h2x4(:,214),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(8),n2h4(308))
  call Hloop_WA_Q(ntryL,G0H8(21),ex3(:),G0H4(33),m3h2x4(:,215),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(109),n2h4(309))
  call Hloop_VA_Q(ntryL,G0H8(30),ex3(:),G0H4(33),m3h2x4(:,216),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(44),n2h4(310))
  call Hloop_ZA_Q(ntryL,G0H8(31),ex3(:),G0H4(33),ngZd,m3h2x4(:,217),heltab2x8(:,:,269))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(43),n2h4(311))
  call Hloop_WA_Q(ntryL,G0H8(1),ex3(:),G0H4(33),m3h2x4(:,218),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G0H4(33),21,0,G1H4(123),n2h4(312))
  call Hloop_QA_W(ntryL,G1H8(60),ex3(:),G1H4(70),m3h2x4(:,219),heltab2x8(:,:,271))
  call Hloop_QA_W(ntryL,G1H8(61),ex3(:),G1H4(69),m3h2x4(:,220),heltab2x8(:,:,272))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(33),m3h2x4(:,221),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(73),n2h4(313))
  call Hloop_ZQ_A(ntryL,G0H8(2),ex1(:),G0H4(33),ngZd,m3h2x4(:,222),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(17),n2h4(314))
  call Hloop_WQ_A(ntryL,G0H8(17),ex1(:),G0H4(33),m3h2x4(:,223),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(7),n2h4(315))
  call Hloop_VQ_A(ntryL,G0H8(38),ex1(:),G0H4(33),m3h2x4(:,224),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(74),n2h4(316))
  call Hloop_ZQ_A(ntryL,G0H8(39),ex1(:),G0H4(33),ngZd,m3h2x4(:,225),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(18),n2h4(317))
  call Hloop_WQ_A(ntryL,G0H8(40),ex1(:),G0H4(33),m3h2x4(:,226),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(11),n2h4(318))
  call Hloop_AQ_W(ntryL,G1H8(62),ex1(:),G1H4(75),m3h2x4(:,227),heltab2x8(:,:,279))
  call Hloop_AQ_W(ntryL,G1H8(63),ex1(:),G1H4(27),m3h2x4(:,228),heltab2x8(:,:,280))
  call Hloop_QA_V(ntryL,G1H16(257),ex3(:),G1H8(3),m3h2x8(:,149),heltab2x16(:,:,421))
  call Hloop_QA_Z(ntryL,G1H16(258),ex3(:),G1H8(4),ngZd,m3h2x8(:,150),heltab2x16(:,:,422))
  call Hloop_QA_W(ntryL,G1H16(259),ex3(:),G1H8(5),m3h2x8(:,151),heltab2x16(:,:,423))
  call Hloop_QA_V(ntryL,G1H16(260),ex3(:),G1H8(7),m3h2x8(:,152),heltab2x16(:,:,424))
  call Hloop_QA_Z(ntryL,G1H16(261),ex3(:),G1H8(8),ngZd,m3h2x8(:,153),heltab2x16(:,:,425))
  call Hloop_QA_W(ntryL,G1H16(262),ex3(:),G1H8(9),m3h2x8(:,154),heltab2x16(:,:,426))
  call Hloop_WA_Q(ntryL,G1H16(263),ex3(:),G1H8(10),m3h2x8(:,155),heltab2x16(:,:,427))
  call Hloop_A_Q(ntryL,G1H8(10),20,0,G2H8(9),n2h8(113))
  call Hloop_WA_Q(ntryL,G1H16(264),ex3(:),G1H8(12),m3h2x8(:,156),heltab2x16(:,:,428))
  call Hloop_A_Q(ntryL,G1H8(12),20,0,G2H8(10),n2h8(114))
  call Hloop_AQ_V(ntryL,G1H16(265),ex1(:),G1H8(13),m3h2x8(:,157),heltab2x16(:,:,429))
  call Hloop_AQ_Z(ntryL,G1H16(266),ex1(:),G1H8(14),ngZd,m3h2x8(:,158),heltab2x16(:,:,430))
  call Hloop_AQ_W(ntryL,G1H16(267),ex1(:),G1H8(15),m3h2x8(:,159),heltab2x16(:,:,431))
  call Hloop_AQ_V(ntryL,G1H16(268),ex1(:),G1H8(17),m3h2x8(:,160),heltab2x16(:,:,432))
  call Hloop_AQ_Z(ntryL,G1H16(269),ex1(:),G1H8(18),ngZd,m3h2x8(:,161),heltab2x16(:,:,433))
  call Hloop_AQ_W(ntryL,G1H16(270),ex1(:),G1H8(19),m3h2x8(:,162),heltab2x16(:,:,434))
  call Hloop_WQ_A(ntryL,G1H16(271),ex1(:),G1H8(20),m3h2x8(:,163),heltab2x16(:,:,435))
  call Hloop_Q_A(ntryL,G1H8(20),17,0,G2H8(11),n2h8(115))
  call Hloop_WQ_A(ntryL,G1H16(272),ex1(:),G1H8(22),m3h2x8(:,164),heltab2x16(:,:,436))
  call Hloop_Q_A(ntryL,G1H8(22),17,0,G2H8(12),n2h8(116))
  call Hloop_AQ_V(ntryL,G1H4(78),ex2(:),G1H2(33),m3h2x2(:,147),heltab2x4(:,:,303))
  call Hloop_AQ_Z(ntryL,G1H4(79),ex2(:),G1H2(37),ngZd,m3h2x2(:,148),heltab2x4(:,:,304))
  call Hloop_AQ_W(ntryL,G1H4(80),ex2(:),G1H2(86),m3h2x2(:,149),heltab2x4(:,:,305))
  call Hloop_AQ_V(ntryL,G1H4(104),ex2(:),G1H2(50),m3h2x2(:,150),heltab2x4(:,:,306))
  call Hloop_AQ_Z(ntryL,G1H4(105),ex2(:),G1H2(38),ngZd,m3h2x2(:,151),heltab2x4(:,:,307))
  call Hloop_AQ_W(ntryL,G1H4(108),ex2(:),G1H2(39),m3h2x2(:,152),heltab2x4(:,:,308))
  call Hloop_AQ_V(ntryL,G1H4(22),ex1(:),G1H2(43),m3h2x2(:,153),heltab2x4(:,:,309))
  call Hloop_AQ_Z(ntryL,G1H4(93),ex1(:),G1H2(45),ngZd,m3h2x2(:,154),heltab2x4(:,:,310))
  call Hloop_AQ_W(ntryL,G1H4(94),ex1(:),G1H2(49),m3h2x2(:,155),heltab2x4(:,:,311))
  call Hloop_AQ_V(ntryL,G1H4(118),ex1(:),G1H2(51),m3h2x2(:,156),heltab2x4(:,:,312))
  call Hloop_AQ_Z(ntryL,G1H4(119),ex1(:),G1H2(55),ngZd,m3h2x2(:,157),heltab2x4(:,:,313))
  call Hloop_AQ_W(ntryL,G1H4(120),ex1(:),G1H2(57),m3h2x2(:,158),heltab2x4(:,:,314))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(14),G2H2(80),G2H2(68),G2H2(75),G2H2(72) &
    ,G2H2(69),G2H2(66),G2H2(63),G2H2(60)])
call HGT_w2_OLR(G1H4(19),1,1,4)
call HGT_w2_invQ_OLR(G1H4(19),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(95)])
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(15)])
call HGT_w2_OLR(G1H4(23),1,1,4)
call HGT_w2_invQ_OLR(G1H4(23),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(175)])
call HGT_w2_OLR(G1H4(24),1,1,4)
call HGT_w2_invQ_OLR(G1H4(24),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(149)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(84),G2H2(81),G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(164)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(225)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(240)])
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(19),G1H2(108),G1H2(216),G1H2(124),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(21),G1H2(7),G1H2(220),G1H2(132),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(80),[G1H2(25),G1H2(56),G1H2(144),G1H2(166),G1H2(154) &
    ,G1H2(94),G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(215),[G1H2(214),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(14),G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(26),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(67),G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(185),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G2H4(99),G2H4(87),G1H4(112),G1H4(107),G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(189),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(190),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G2H4(117),G1H4(122),G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(191),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G2H4(113),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(195),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(150),G1H4(130),G0H4(28),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(196),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(156),[G2H4(154),G1H4(135),G0H4(32),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G2H4(97),G2H4(85),G1H4(150),G1H4(145),G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(129),[G2H4(115),G1H4(160),G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(125),[G2H4(111),G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G2H4(149),G1H4(168),G0H4(27),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(208),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G2H4(153),G1H4(173),G0H4(31),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(16),G2H4(23),G1H4(188),G1H4(183),G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(39),G1H4(198),G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(35),G1H4(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(71),G1H4(206),G0H4(13),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(73),G1H4(211),G0H4(15),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(4),G2H4(25),G1H4(226),G1H4(221),G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(15),G1H4(236),G1H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(37),G1H4(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(72),G1H4(244),G0H4(14),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(74),G1H4(249),G0H4(16),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(55),G0H4(5),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(56),G0H4(6),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(57),G0H4(1),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(58),G0H4(8),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(237),G1H4(232),G1H4(229),G1H4(213) &
    ,G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(239),G1H4(234),G1H4(233),G1H4(214) &
    ,G1H4(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(91),G1H4(224),G1H4(223),G1H4(218),G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(246),[G1H4(92),G1H4(228),G1H4(227),G1H4(222),G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G2H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(128),[G2H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G2H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G2H4(133),G0H4(19),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(134),G0H4(20),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(139),[G2H4(137),G0H4(23),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G2H4(138),G0H4(24),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G2H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G2H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G2H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G2H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(157),G1H4(156),G1H4(153),G1H4(136) &
    ,G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(163),G1H4(162),G1H4(161),G1H4(138) &
    ,G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(87),G1H4(146),G1H4(143),G1H4(142),G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(169),G1H4(152),G1H4(151),G1H4(148) &
    ,G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(86)])
call HGT_w2_OLR(G1H2(160),1,1,2)
call HGT_w2_invQ_OLR(G1H2(160),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(160),ex1(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(299),n2h1(333))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(2),m3h2x1(:,274),heltab2x2(:,:,274))
call HGT_w2_OLR(G1H2(167),1,1,2)
call HGT_w2_invQ_OLR(G1H2(167),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(167),ex2(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(251),n2h1(334))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,1),G1H1(1),m3h4x1(:,157),heltab2x4(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(335))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,158),heltab2x4(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(336))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,8),G1H1(1),m3h4x1(:,159),heltab2x4(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(337))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,160),heltab2x4(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(275),n2h1(338))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,11),G1H1(1),m3h4x1(:,161),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(339))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(10),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,12),G1H1(1),ngZu,m3h4x1(:,162),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(340))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,15),G1H1(1),m3h4x1(:,163),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(341))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,164),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(342))
  call Hloop_VA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(343))
  call Hloop_VA_Q(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(344))
  call Hloop_ZA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),ngZd,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(345))
  call Hloop_ZA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),ngZd,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(346))
  call Hloop_WA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(347))
  call Hloop_WA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(348))
  call Hloop_WA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(349))
  call Hloop_WA_Q(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(350))
  call Hloop_WA_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(351))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(352))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZd,m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(353))
  call Hloop_WA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(354))
  call Hloop_WA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(355))
  call Hloop_WA_Q(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,165),heltab2x4(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H4(31),wf4(:,1),G1H1(1),m3h4x1(:,166),heltab2x4(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H4(25),wf4(:,1),G1H1(1),m3h4x1(:,167),heltab2x4(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,168),heltab2x4(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(360))
  call Hloop_AZ_Q(ntryL,G1H4(35),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,169),heltab2x4(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(361))
  call Hloop_AZ_Q(ntryL,G1H4(42),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,170),heltab2x4(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(362))
  call Hloop_AZ_Q(ntryL,G1H4(41),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,171),heltab2x4(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(363))
  call Hloop_AZ_Q(ntryL,G1H4(46),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,172),heltab2x4(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(364))
  call Hloop_AZ_Q(ntryL,G1H4(47),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,173),heltab2x4(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(365))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(51),26,wf4(:,1),5,G2tensor(55),m3h4x1(:,174),heltab2x4(:,:,332))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(52),26,wf4(:,1),5,G2tensor(281),m3h4x1(:,175),heltab2x4(:,:,333))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(56),26,wf4(:,4),5,G2tensor(65),m3h4x1(:,176),heltab2x4(:,:,334))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(57),26,wf4(:,4),5,G2tensor(59),m3h4x1(:,177),heltab2x4(:,:,335))
  call Hloop_AV_Q(ntryL,G1H4(61),wf4(:,8),G1H1(1),m3h4x1(:,178),heltab2x4(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(284),n2h1(366))
  call Hloop_AV_Q(ntryL,G1H4(72),wf4(:,8),G1H1(1),m3h4x1(:,179),heltab2x4(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(367))
  call Hloop_AV_Q(ntryL,G1H4(66),wf4(:,8),G1H1(1),m3h4x1(:,180),heltab2x4(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(368))
  call Hloop_AV_Q(ntryL,G1H4(71),wf4(:,8),G1H1(1),m3h4x1(:,181),heltab2x4(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(287),n2h1(369))
  call Hloop_AZ_Q(ntryL,G1H4(76),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,182),heltab2x4(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(370))
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,183),heltab2x4(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(233),n2h1(371))
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,184),heltab2x4(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(372))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,185),heltab2x4(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(373))
  call Hloop_AZ_Q(ntryL,G1H4(81),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,186),heltab2x4(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(236),n2h1(374))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(83),25,wf4(:,8),6,G2tensor(83),m3h4x1(:,187),heltab2x4(:,:,345))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(84),25,wf4(:,8),6,G2tensor(77),m3h4x1(:,188),heltab2x4(:,:,346))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(96),25,wf4(:,10),6,G2tensor(239),m3h4x1(:,189),heltab2x4(:,:,347))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(97),25,wf4(:,10),6,G2tensor(86),m3h4x1(:,190),heltab2x4(:,:,348))
  call Hloop_AV_Q(ntryL,G1H4(185),wf4(:,11),G1H1(1),m3h4x1(:,191),heltab2x4(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(186),n2h1(375))
  call Hloop_AV_Q(ntryL,G2H4(103),wf4(:,11),G2H1(1),m3h4x1(:,192),heltab2x4(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(376))
  call Hloop_AV_Q(ntryL,G1H4(186),wf4(:,11),G1H1(1),m3h4x1(:,193),heltab2x4(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(377))
  call Hloop_AV_Q(ntryL,G1H4(189),wf4(:,11),G1H1(1),m3h4x1(:,194),heltab2x4(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(329),n2h1(378))
  call Hloop_AZ_Q(ntryL,G1H4(190),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,195),heltab2x4(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(379))
  call Hloop_AZ_Q(ntryL,G2H4(131),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,196),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(380))
  call Hloop_AZ_Q(ntryL,G1H4(191),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,197),heltab2x4(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(381))
  call Hloop_AZ_Q(ntryL,G1H4(194),wf4(:,12),G1H1(1),ngZu,m3h4x1(:,198),heltab2x4(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(382))
  call Hloop_AZ_Q(ntryL,G2H4(127),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,199),heltab2x4(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(383))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(195),22,wf4(:,11),9,G2tensor(94),m3h4x1(:,200),heltab2x4(:,:,358))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(152),22,wf4(:,11),9,G3tensor(4),m3h4x1(:,201),heltab2x4(:,:,359))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(196),22,wf4(:,12),9,G2tensor(332),m3h4x1(:,202),heltab2x4(:,:,360))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(156),22,wf4(:,12),9,G3tensor(5),m3h4x1(:,203),heltab2x4(:,:,361))
  call Hloop_QV_A(ntryL,G1H4(199),wf4(:,11),G1H1(1),m3h4x1(:,204),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(384))
  call Hloop_QV_A(ntryL,G2H4(101),wf4(:,11),G2H1(1),m3h4x1(:,205),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(385))
  call Hloop_QV_A(ntryL,G1H4(200),wf4(:,11),G1H1(1),m3h4x1(:,206),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(386))
  call Hloop_QZ_A(ntryL,G1H4(204),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,207),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(387))
  call Hloop_QZ_A(ntryL,G2H4(129),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,208),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(388))
  call Hloop_QZ_A(ntryL,G1H4(89),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,209),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(389))
  call Hloop_QZ_A(ntryL,G2H4(125),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,210),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(8),n2h1(390))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(207),22,wf4(:,11),9,G2tensor(335),m3h4x1(:,211),heltab2x4(:,:,369))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(151),22,wf4(:,11),9,G3tensor(9),m3h4x1(:,212),heltab2x4(:,:,370))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(208),22,wf4(:,12),9,G2tensor(101),m3h4x1(:,213),heltab2x4(:,:,371))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(155),22,wf4(:,12),9,G3tensor(10),m3h4x1(:,214),heltab2x4(:,:,372))
  call Hloop_AV_Q(ntryL,G1H4(28),wf4(:,15),G1H1(1),m3h4x1(:,215),heltab2x4(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(169),n2h1(391))
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,15),G2H1(1),m3h4x1(:,216),heltab2x4(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(11),n2h1(392))
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,15),G1H1(1),m3h4x1(:,217),heltab2x4(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(393))
  call Hloop_AV_Q(ntryL,G1H4(109),wf4(:,15),G1H1(1),m3h4x1(:,218),heltab2x4(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(257),n2h1(394))
  call Hloop_AZ_Q(ntryL,G1H4(44),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,219),heltab2x4(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(395))
  call Hloop_AZ_Q(ntryL,G2H4(51),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,220),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(12),n2h1(396))
  call Hloop_AZ_Q(ntryL,G1H4(43),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,221),heltab2x4(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(397))
  call Hloop_AZ_Q(ntryL,G1H4(123),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,222),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(398))
  call Hloop_AZ_Q(ntryL,G2H4(47),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,223),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(399))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(70),21,wf4(:,15),10,G2tensor(109),m3h4x1(:,224),heltab2x4(:,:,382))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(75),21,wf4(:,15),10,G3tensor(14),m3h4x1(:,225),heltab2x4(:,:,383))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(69),21,wf4(:,16),10,G2tensor(260),m3h4x1(:,226),heltab2x4(:,:,384))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(77),21,wf4(:,16),10,G3tensor(15),m3h4x1(:,227),heltab2x4(:,:,385))
  call Hloop_QV_A(ntryL,G1H4(73),wf4(:,15),G1H1(1),m3h4x1(:,228),heltab2x4(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(400))
  call Hloop_QV_A(ntryL,G2H4(13),wf4(:,15),G2H1(1),m3h4x1(:,229),heltab2x4(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(16),n2h1(401))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,15),G1H1(1),m3h4x1(:,230),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(402))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,231),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(403))
  call Hloop_QZ_A(ntryL,G2H4(53),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,232),heltab2x4(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(404))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,233),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(405))
  call Hloop_QZ_A(ntryL,G2H4(49),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,234),heltab2x4(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(406))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(75),21,wf4(:,15),10,G2tensor(263),m3h4x1(:,235),heltab2x4(:,:,393))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(76),21,wf4(:,15),10,G3tensor(19),m3h4x1(:,236),heltab2x4(:,:,394))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(27),21,wf4(:,16),10,G2tensor(116),m3h4x1(:,237),heltab2x4(:,:,395))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(78),21,wf4(:,16),10,G3tensor(20),m3h4x1(:,238),heltab2x4(:,:,396))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(121),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(134),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(323),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(371),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(305),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(308),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(311),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(353),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hloop_AV_Q(ntryL,G2H4(1),wf4(:,15),G2H1(1),m3h4x1(:,239),heltab2x4(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(21),n2h1(407))
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,15),G2H1(1),m3h4x1(:,240),heltab2x4(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(22),n2h1(408))
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,15),G2H1(1),m3h4x1(:,241),heltab2x4(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(23),n2h1(409))
  call Hloop_QV_A(ntryL,G2H4(9),wf4(:,15),G2H1(1),m3h4x1(:,242),heltab2x4(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(24),n2h1(410))
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,15),G2H1(1),m3h4x1(:,243),heltab2x4(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(25),n2h1(411))
  call Hloop_QV_A(ntryL,G2H4(11),wf4(:,15),G2H1(1),m3h4x1(:,244),heltab2x4(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(26),n2h1(412))
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,15),G2H1(1),m3h4x1(:,245),heltab2x4(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(27),n2h1(413))
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,15),G2H1(1),m3h4x1(:,246),heltab2x4(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(28),n2h1(414))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,15),G2H1(1),m3h4x1(:,247),heltab2x4(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(29),n2h1(415))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,15),G2H1(1),m3h4x1(:,248),heltab2x4(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(30),n2h1(416))
  call Hloop_AZ_Q(ntryL,G2H4(41),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,249),heltab2x4(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(31),n2h1(417))
  call Hloop_AZ_Q(ntryL,G2H4(42),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,250),heltab2x4(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(32),n2h1(418))
  call Hloop_AZ_Q(ntryL,G2H4(43),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,251),heltab2x4(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(33),n2h1(419))
  call Hloop_QZ_A(ntryL,G2H4(44),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,252),heltab2x4(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(34),n2h1(420))
  call Hloop_QZ_A(ntryL,G2H4(45),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,253),heltab2x4(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(35),n2h1(421))
  call Hloop_QZ_A(ntryL,G2H4(46),wf4(:,16),G2H1(1),ngZl,m3h4x1(:,254),heltab2x4(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(36),n2h1(422))
  call Hloop_AZ_Q(ntryL,G2H4(48),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,255),heltab2x4(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(37),n2h1(423))
  call Hloop_QZ_A(ntryL,G2H4(50),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,256),heltab2x4(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(38),n2h1(424))
  call Hloop_AZ_Q(ntryL,G2H4(52),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,257),heltab2x4(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(39),n2h1(425))
  call Hloop_QZ_A(ntryL,G2H4(54),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,258),heltab2x4(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(40),n2h1(426))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(59),21,wf4(:,15),10,G3tensor(41),m3h4x1(:,259),heltab2x4(:,:,417))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(60),21,wf4(:,15),10,G3tensor(42),m3h4x1(:,260),heltab2x4(:,:,418))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(61),21,wf4(:,16),10,G3tensor(43),m3h4x1(:,261),heltab2x4(:,:,419))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(62),21,wf4(:,16),10,G3tensor(44),m3h4x1(:,262),heltab2x4(:,:,420))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(67),21,wf4(:,15),G3tensor(45),m3h4x1(:,263),heltab2x4(:,:,421))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(68),21,wf4(:,15),10,G3tensor(46),m3h4x1(:,264),heltab2x4(:,:,422))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(69),21,wf4(:,16),G3tensor(47),m3h4x1(:,265),heltab2x4(:,:,423))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(70),21,wf4(:,16),10,G3tensor(48),m3h4x1(:,266),heltab2x4(:,:,424))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(238),wf4(:,15),G1tensor(73),m3h4x1(:,267),heltab2x4(:,:,425))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(242),wf4(:,16),G1tensor(103),m3h4x1(:,268),heltab2x4(:,:,426))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(245),wf4(:,15),G1tensor(133),m3h4x1(:,269),heltab2x4(:,:,427))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(246),wf4(:,16),G1tensor(163),m3h4x1(:,270),heltab2x4(:,:,428))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(356),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(359),ngZd,m3h2x1(:,300),heltab2x2(:,:,300))
  call Hloop_QV_A(ntryL,G1H4(247),wf4(:,1),G1H1(1),m3h4x1(:,271),heltab2x4(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(302),n2h1(427))
  call Hloop_QV_A(ntryL,G1H4(250),wf4(:,1),G1H1(1),m3h4x1(:,272),heltab2x4(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(254),n2h1(428))
  call Hloop_QZ_A(ntryL,G1H4(58),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,273),heltab2x4(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(350),n2h1(429))
  call Hloop_QZ_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,274),heltab2x4(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(278),n2h1(430))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(16),26,wf4(:,1),5,G2tensor(178),m3h4x1(:,275),heltab2x4(:,:,433))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(29),26,wf4(:,4),5,G2tensor(26),m3h4x1(:,276),heltab2x4(:,:,434))
  call Hloop_VA_Q(ntryL,G1H8(64),wf8(:,51),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(431))
  call Hloop_ZA_Q(ntryL,G1H8(65),wf8(:,51),G1H1(1),ngZd,m3h8x1(:,2),heltab2x8(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(180),n2h1(432))
  call Hloop_WA_Q(ntryL,G1H8(66),wf8(:,51),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(433))
  call Hloop_VA_Q(ntryL,G1H8(67),wf8(:,52),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(181),n2h1(434))
  call Hloop_ZA_Q(ntryL,G1H8(68),wf8(:,52),G1H1(1),ngZd,m3h8x1(:,5),heltab2x8(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(161),n2h1(435))
  call Hloop_WA_Q(ntryL,G1H8(69),wf8(:,52),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(436))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(1),wf8(:,51),G2tensor(163),m3h8x1(:,7),heltab2x8(:,:,287))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(2),wf8(:,52),G2tensor(164),m3h8x1(:,8),heltab2x8(:,:,288))
  call Hloop_QV_A(ntryL,G2H4(91),wf4(:,11),G2H1(1),m3h4x1(:,277),heltab2x4(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(49),n2h1(437))
  call Hloop_QV_A(ntryL,G2H4(92),wf4(:,11),G2H1(1),m3h4x1(:,278),heltab2x4(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(50),n2h1(438))
  call Hloop_QV_A(ntryL,G2H4(93),wf4(:,11),G2H1(1),m3h4x1(:,279),heltab2x4(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(51),n2h1(439))
  call Hloop_AV_Q(ntryL,G2H4(94),wf4(:,11),G2H1(1),m3h4x1(:,280),heltab2x4(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(52),n2h1(440))
  call Hloop_AV_Q(ntryL,G2H4(95),wf4(:,11),G2H1(1),m3h4x1(:,281),heltab2x4(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(53),n2h1(441))
  call Hloop_AV_Q(ntryL,G2H4(96),wf4(:,11),G2H1(1),m3h4x1(:,282),heltab2x4(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(54),n2h1(442))
  call Hloop_QV_A(ntryL,G2H4(98),wf4(:,11),G2H1(1),m3h4x1(:,283),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(55),n2h1(443))
  call Hloop_AV_Q(ntryL,G2H4(100),wf4(:,11),G2H1(1),m3h4x1(:,284),heltab2x4(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(56),n2h1(444))
  call Hloop_QV_A(ntryL,G2H4(102),wf4(:,11),G2H1(1),m3h4x1(:,285),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(57),n2h1(445))
  call Hloop_AV_Q(ntryL,G2H4(104),wf4(:,11),G2H1(1),m3h4x1(:,286),heltab2x4(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(58),n2h1(446))
  call Hloop_QZ_A(ntryL,G2H4(119),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,287),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(59),n2h1(447))
  call Hloop_QZ_A(ntryL,G2H4(120),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,288),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(60),n2h1(448))
  call Hloop_QZ_A(ntryL,G2H4(121),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,289),heltab2x4(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(61),n2h1(449))
  call Hloop_AZ_Q(ntryL,G2H4(122),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,290),heltab2x4(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(62),n2h1(450))
  call Hloop_AZ_Q(ntryL,G2H4(123),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,291),heltab2x4(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(63),n2h1(451))
  call Hloop_AZ_Q(ntryL,G2H4(124),wf4(:,12),G2H1(1),ngZl,m3h4x1(:,292),heltab2x4(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(64),n2h1(452))
  call Hloop_QZ_A(ntryL,G2H4(126),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,293),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(65),n2h1(453))
  call Hloop_AZ_Q(ntryL,G2H4(128),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,294),heltab2x4(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(66),n2h1(454))
  call Hloop_QZ_A(ntryL,G2H4(130),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,295),heltab2x4(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(67),n2h1(455))
  call Hloop_AZ_Q(ntryL,G2H4(132),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,296),heltab2x4(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(68),n2h1(456))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(135),22,wf4(:,11),9,G3tensor(69),m3h4x1(:,297),heltab2x4(:,:,455))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(136),22,wf4(:,11),9,G3tensor(70),m3h4x1(:,298),heltab2x4(:,:,456))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(139),22,wf4(:,12),9,G3tensor(71),m3h4x1(:,299),heltab2x4(:,:,457))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(140),22,wf4(:,12),9,G3tensor(72),m3h4x1(:,300),heltab2x4(:,:,458))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(143),22,wf4(:,11),9,G3tensor(73),m3h4x1(:,301),heltab2x4(:,:,459))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(144),22,wf4(:,11),G3tensor(74),m3h4x1(:,302),heltab2x4(:,:,460))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(147),22,wf4(:,12),9,G3tensor(75),m3h4x1(:,303),heltab2x4(:,:,461))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(148),22,wf4(:,12),G3tensor(76),m3h4x1(:,304),heltab2x4(:,:,462))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(158),wf4(:,11),G1tensor(193),m3h4x1(:,305),heltab2x4(:,:,463))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(166),wf4(:,12),G1tensor(223),m3h4x1(:,306),heltab2x4(:,:,464))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(88),wf4(:,11),G1tensor(6),m3h4x1(:,307),heltab2x4(:,:,465))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(170),wf4(:,12),G1tensor(49),m3h4x1(:,308),heltab2x4(:,:,466))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(182),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(50),ngZd,m3h2x1(:,302),heltab2x2(:,:,302))
  call Hloop_QV_A(ntryL,G1H4(171),wf4(:,8),G1H1(1),m3h4x1(:,309),heltab2x4(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(183),n2h1(457))
  call Hloop_QV_A(ntryL,G1H4(174),wf4(:,8),G1H1(1),m3h4x1(:,310),heltab2x4(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(184),n2h1(458))
  call Hloop_QZ_A(ntryL,G1H4(176),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,311),heltab2x4(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(459))
  call Hloop_QZ_A(ntryL,G1H4(179),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,312),heltab2x4(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(460))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(181),25,wf4(:,8),6,G2tensor(165),m3h4x1(:,313),heltab2x4(:,:,471))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(184),25,wf4(:,10),6,G2tensor(166),m3h4x1(:,314),heltab2x4(:,:,472))
  call Hloop_VA_Q(ntryL,G1H8(72),wf8(:,58),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(461))
  call Hloop_ZA_Q(ntryL,G1H8(73),wf8(:,58),G1H1(1),ngZd,m3h8x1(:,10),heltab2x8(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(168),n2h1(462))
  call Hloop_WA_Q(ntryL,G1H8(74),wf8(:,58),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(58),n2h1(463))
  call Hloop_VA_Q(ntryL,G1H8(75),wf8(:,60),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(290),n2h1(464))
  call Hloop_ZA_Q(ntryL,G1H8(76),wf8(:,60),G1H1(1),ngZd,m3h8x1(:,13),heltab2x8(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(465))
  call Hloop_WA_Q(ntryL,G1H8(77),wf8(:,60),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(293),n2h1(466))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(3),wf8(:,58),G2tensor(64),m3h8x1(:,15),heltab2x8(:,:,295))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(4),wf8(:,60),G2tensor(67),m3h8x1(:,16),heltab2x8(:,:,296))
  call Hloop_VQ_A(ntryL,G1H8(80),wf8(:,71),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(467))
  call Hloop_ZQ_A(ntryL,G1H8(81),wf8(:,71),G1H1(1),ngZd,m3h8x1(:,18),heltab2x8(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(296),n2h1(468))
  call Hloop_WQ_A(ntryL,G1H8(82),wf8(:,71),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(469))
  call Hloop_VQ_A(ntryL,G1H8(83),wf8(:,72),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(242),n2h1(470))
  call Hloop_ZQ_A(ntryL,G1H8(84),wf8(:,72),G1H1(1),ngZd,m3h8x1(:,21),heltab2x8(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(471))
  call Hloop_WQ_A(ntryL,G1H8(85),wf8(:,72),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(245),n2h1(472))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(5),wf8(:,71),G2tensor(79),m3h8x1(:,23),heltab2x8(:,:,303))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(6),wf8(:,72),G2tensor(82),m3h8x1(:,24),heltab2x8(:,:,304))
  call Hloop_VA_Q(ntryL,G1H8(88),wf8(:,67),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(473))
  call Hloop_ZA_Q(ntryL,G1H8(89),wf8(:,67),G1H1(1),ngZd,m3h8x1(:,26),heltab2x8(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(248),n2h1(474))
  call Hloop_WA_Q(ntryL,G1H8(90),wf8(:,67),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(190),n2h1(475))
  call Hloop_VA_Q(ntryL,G1H8(91),wf8(:,68),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(338),n2h1(476))
  call Hloop_ZA_Q(ntryL,G1H8(92),wf8(:,68),G1H1(1),ngZd,m3h8x1(:,29),heltab2x8(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(477))
  call Hloop_WA_Q(ntryL,G1H8(93),wf8(:,68),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(192),n2h1(478))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(7),wf8(:,67),G2tensor(341),m3h8x1(:,31),heltab2x8(:,:,311))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(8),wf8(:,68),G2tensor(193),m3h8x1(:,32),heltab2x8(:,:,312))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,79),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(194),n2h1(479))
  call Hloop_ZQ_A(ntryL,G1H8(4),wf8(:,79),G1H1(1),ngZd,m3h8x1(:,34),heltab2x8(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(344),n2h1(480))
  call Hloop_WQ_A(ntryL,G1H8(5),wf8(:,79),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(481))
  call Hloop_VQ_A(ntryL,G1H8(7),wf8(:,80),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(266),n2h1(482))
  call Hloop_ZQ_A(ntryL,G1H8(8),wf8(:,80),G1H1(1),ngZd,m3h8x1(:,37),heltab2x8(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(174),n2h1(483))
  call Hloop_WQ_A(ntryL,G1H8(9),wf8(:,80),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(175),n2h1(484))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(9),wf8(:,79),G2tensor(269),m3h8x1(:,39),heltab2x8(:,:,319))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(10),wf8(:,80),G2tensor(176),m3h8x1(:,40),heltab2x8(:,:,320))
  call Hloop_VA_Q(ntryL,G1H8(13),wf8(:,74),G1H1(1),m3h8x1(:,41),heltab2x8(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(177),n2h1(485))
  call Hloop_ZA_Q(ntryL,G1H8(14),wf8(:,74),G1H1(1),ngZd,m3h8x1(:,42),heltab2x8(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(272),n2h1(486))
  call Hloop_WA_Q(ntryL,G1H8(15),wf8(:,74),G1H1(1),m3h8x1(:,43),heltab2x8(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(487))
  call Hloop_VA_Q(ntryL,G1H8(17),wf8(:,76),G1H1(1),m3h8x1(:,44),heltab2x8(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(488))
  call Hloop_ZA_Q(ntryL,G1H8(18),wf8(:,76),G1H1(1),ngZd,m3h8x1(:,45),heltab2x8(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(195),n2h1(489))
  call Hloop_WA_Q(ntryL,G1H8(19),wf8(:,76),G1H1(1),m3h8x1(:,46),heltab2x8(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(490))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(11),wf8(:,74),G2tensor(5),m3h8x1(:,47),heltab2x8(:,:,327))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(12),wf8(:,76),G2tensor(148),m3h8x1(:,48),heltab2x8(:,:,328))
  call Hloop_VA_Q(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(491))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex3(:),G1H1(1),ngZd,m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(492))
  call Hloop_WA_Q(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(493))
  call Hloop_VA_Q(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(494))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex3(:),G1H1(1),ngZd,m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(495))
  call Hloop_WA_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(496))
  call ol_merge_tensors(G3tensor(76),[G3tensor(75),G3tensor(74),G3tensor(73),G3tensor(72),G3tensor(71),G3tensor(70),G3tensor(69) &
    ,G3tensor(10),G3tensor(9),G3tensor(5),G3tensor(4),G2tensor(196),G1tensor(49),G1tensor(6),G1tensor(223),G1tensor(193) &
    ,G1tensor(724),G1tensor(295),G1tensor(91),G0tensor(724),G0tensor(295),G0tensor(4)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(47),G3tensor(46),G3tensor(45),G3tensor(44),G3tensor(43),G3tensor(42),G3tensor(41) &
    ,G3tensor(20),G3tensor(19),G3tensor(15),G3tensor(14),G2tensor(198),G1tensor(163),G1tensor(133),G1tensor(103),G1tensor(73) &
    ,G1tensor(729),G1tensor(335),G1tensor(151),G0tensor(729),G0tensor(335),G0tensor(14)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(341),G2tensor(164),G2tensor(163),G2tensor(304),G2tensor(301),G2tensor(256) &
    ,G2tensor(253),G2tensor(201),G2tensor(199),G1tensor(320),G1tensor(300),G1tensor(127),G1tensor(97),G0tensor(320),G0tensor(300) &
    ,G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(5),G2tensor(67),G2tensor(64),G2tensor(352),G2tensor(349),G2tensor(280) &
    ,G2tensor(277),G2tensor(202),G2tensor(200),G1tensor(360),G1tensor(340),G1tensor(187),G1tensor(157),G0tensor(360),G0tensor(340) &
    ,G0tensor(20),G0tensor(15)])
  call ol_merge_tensors(G2tensor(204),[G1tensor(547),G1tensor(125),G1tensor(17),G0tensor(547),G0tensor(134),G0tensor(124)])
  call ol_merge_tensors(G3tensor(8),[G3tensor(7),G3tensor(6),G3tensor(3),G3tensor(2),G3tensor(1),G2tensor(211),G2tensor(208) &
    ,G2tensor(205),G1tensor(804),G1tensor(799),G1tensor(794),G1tensor(580),G1tensor(565),G1tensor(550),G1tensor(70),G1tensor(46) &
    ,G1tensor(27),G0tensor(804),G0tensor(799),G0tensor(794),G0tensor(580),G0tensor(565),G0tensor(550),G0tensor(159),G0tensor(139) &
    ,G0tensor(129)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(562),G1tensor(51),G1tensor(131),G0tensor(562),G0tensor(149),G0tensor(144)])
  call ol_merge_tensors(G2tensor(210),[G1tensor(577),G1tensor(155),G0tensor(577),G0tensor(154)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(178),G2tensor(213),G1tensor(582),G1tensor(53),G0tensor(582),G0tensor(155)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(190),G2tensor(162),G2tensor(32),G2tensor(298),G2tensor(289),G2tensor(250) &
    ,G2tensor(241),G2tensor(217),G2tensor(214),G1tensor(630),G1tensor(585),G1tensor(141),G1tensor(58),G0tensor(630),G0tensor(585) &
    ,G0tensor(200),G0tensor(160)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(335),G2tensor(216),G1tensor(723),G1tensor(627),G1tensor(124),G0tensor(723) &
    ,G0tensor(627),G0tensor(195)])
  call ol_merge_tensors(G2tensor(219),[G1tensor(637),G1tensor(202),G1tensor(153),G0tensor(637),G0tensor(219),G0tensor(204)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17),G3tensor(16),G3tensor(13),G3tensor(12),G3tensor(11),G2tensor(226),G2tensor(223) &
    ,G2tensor(220),G1tensor(819),G1tensor(814),G1tensor(809),G1tensor(670),G1tensor(650),G1tensor(640),G1tensor(67),G1tensor(208) &
    ,G1tensor(172),G0tensor(819),G0tensor(814),G0tensor(809),G0tensor(670),G0tensor(650),G0tensor(640),G0tensor(239),G0tensor(224) &
    ,G0tensor(209)])
  call ol_merge_tensors(G2tensor(222),[G1tensor(647),G1tensor(219),G1tensor(179),G0tensor(647),G0tensor(229),G0tensor(214)])
  call ol_merge_tensors(G2tensor(225),[G1tensor(667),G1tensor(237),G0tensor(667),G0tensor(234)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(165),G2tensor(228),G1tensor(672),G1tensor(238),G0tensor(672),G0tensor(235)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(1),G2tensor(293),G2tensor(58),G2tensor(346),G2tensor(337),G2tensor(274) &
    ,G2tensor(265),G2tensor(232),G2tensor(229),G1tensor(720),G1tensor(675),G1tensor(280),G1tensor(61),G0tensor(720),G0tensor(675) &
    ,G0tensor(280),G0tensor(240)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(263),G2tensor(231),G1tensor(728),G1tensor(717),G1tensor(275),G0tensor(728) &
    ,G0tensor(717),G0tensor(275)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(243),G2tensor(234),G1tensor(653),G1tensor(638),G1tensor(633),G1tensor(502) &
    ,G1tensor(215),G1tensor(173),G1tensor(59),G1tensor(212),G0tensor(653),G0tensor(638),G0tensor(633),G0tensor(502),G0tensor(182) &
    ,G0tensor(167),G0tensor(162),G0tensor(103)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(85),G2tensor(181),G2tensor(179),G2tensor(292),G2tensor(283),G2tensor(244) &
    ,G2tensor(235),G1tensor(440),G1tensor(425),G1tensor(390),G1tensor(375),G1tensor(185),G1tensor(88),G1tensor(25),G0tensor(440) &
    ,G0tensor(425),G0tensor(390),G0tensor(375),G0tensor(170),G0tensor(130),G0tensor(30)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(246),G2tensor(237),G1tensor(658),G1tensor(648),G1tensor(643),G1tensor(111) &
    ,G1tensor(89),G1tensor(81),G0tensor(658),G0tensor(648),G0tensor(643),G0tensor(187),G0tensor(177),G0tensor(172)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(248),G2tensor(161),G2tensor(180),G2tensor(295),G2tensor(286),G2tensor(247) &
    ,G2tensor(238),G1tensor(460),G1tensor(450),G1tensor(410),G1tensor(400),G1tensor(95),G1tensor(34),G1tensor(30),G0tensor(460) &
    ,G0tensor(450),G0tensor(410),G0tensor(400),G0tensor(180),G0tensor(140),G0tensor(45)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(249),G2tensor(240),G1tensor(668),G1tensor(663),G1tensor(135),G1tensor(119) &
    ,G0tensor(668),G0tensor(663),G0tensor(197),G0tensor(192)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(255),G2tensor(252),G1tensor(333),G1tensor(328),G1tensor(302),G1tensor(109) &
    ,G0tensor(333),G0tensor(328),G0tensor(302),G0tensor(7)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(267),G2tensor(258),G1tensor(553),G1tensor(548),G1tensor(543),G1tensor(412) &
    ,G1tensor(252),G1tensor(247),G1tensor(242),G1tensor(50),G0tensor(553),G0tensor(548),G0tensor(543),G0tensor(412),G0tensor(252) &
    ,G0tensor(247),G0tensor(242),G0tensor(53)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(177),G2tensor(290),G2tensor(167),G2tensor(340),G2tensor(331),G2tensor(268) &
    ,G2tensor(259),G1tensor(520),G1tensor(510),G1tensor(480),G1tensor(470),G1tensor(250),G1tensor(166),G1tensor(140),G0tensor(520) &
    ,G0tensor(510),G0tensor(480),G0tensor(470),G0tensor(250),G0tensor(210),G0tensor(80)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(270),G2tensor(261),G1tensor(568),G1tensor(563),G1tensor(558),G1tensor(267) &
    ,G1tensor(262),G1tensor(257),G0tensor(568),G0tensor(563),G0tensor(558),G0tensor(267),G0tensor(262),G0tensor(257)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(272),G2tensor(61),G2tensor(168),G2tensor(343),G2tensor(334),G2tensor(271) &
    ,G2tensor(262),G1tensor(540),G1tensor(530),G1tensor(500),G1tensor(490),G1tensor(265),G1tensor(209),G1tensor(186),G0tensor(540) &
    ,G0tensor(530),G0tensor(500),G0tensor(490),G0tensor(265),G0tensor(225),G0tensor(95)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(273),G2tensor(264),G1tensor(578),G1tensor(573),G1tensor(277),G1tensor(272) &
    ,G0tensor(578),G0tensor(573),G0tensor(277),G0tensor(272)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(279),G2tensor(276),G1tensor(342),G1tensor(293),G1tensor(288),G1tensor(169) &
    ,G0tensor(342),G0tensor(293),G0tensor(288),G0tensor(17)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(291),G2tensor(282),G1tensor(698),G1tensor(683),G1tensor(678),G1tensor(462) &
    ,G1tensor(35),G1tensor(22),G1tensor(15),G1tensor(122),G0tensor(698),G0tensor(683),G0tensor(678),G0tensor(462),G0tensor(142) &
    ,G0tensor(127),G0tensor(122),G0tensor(73)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(294),G2tensor(285),G1tensor(703),G1tensor(693),G1tensor(688),G1tensor(143) &
    ,G1tensor(94),G1tensor(40),G0tensor(703),G0tensor(693),G0tensor(688),G0tensor(147),G0tensor(137),G0tensor(132)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(297),G2tensor(288),G1tensor(713),G1tensor(708),G1tensor(118),G1tensor(64) &
    ,G0tensor(713),G0tensor(708),G0tensor(157),G0tensor(152)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(303),G2tensor(300),G1tensor(353),G1tensor(348),G1tensor(282),G1tensor(79) &
    ,G0tensor(353),G0tensor(348),G0tensor(282),G0tensor(2)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(306),G1tensor(792),G1tensor(783),G1tensor(732),G1tensor(632),G1tensor(149) &
    ,G0tensor(792),G0tensor(783),G0tensor(732),G0tensor(632),G0tensor(203)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(194),G2tensor(242),G2tensor(70),G2tensor(364),G2tensor(355),G2tensor(316) &
    ,G2tensor(307),G1tensor(810),G1tensor(795),G0tensor(810),G0tensor(795)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(309),G1tensor(797),G1tensor(788),G1tensor(778),G1tensor(742),G1tensor(737) &
    ,G0tensor(797),G0tensor(788),G0tensor(778),G0tensor(742),G0tensor(737)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(344),G2tensor(76),G2tensor(296),G2tensor(367),G2tensor(358),G2tensor(319) &
    ,G2tensor(310),G1tensor(815),G1tensor(800),G0tensor(815),G0tensor(800)])
  call ol_merge_tensors(G2tensor(321),[G2tensor(312),G1tensor(802),G1tensor(327),G1tensor(323),G0tensor(802),G0tensor(327) &
    ,G0tensor(323)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(173),G2tensor(245),G2tensor(73),G2tensor(370),G2tensor(361),G2tensor(322) &
    ,G2tensor(313),G1tensor(820),G1tensor(805),G0tensor(820),G0tensor(805)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(324),G1tensor(722),G1tensor(662),G1tensor(231),G0tensor(722),G0tensor(662) &
    ,G0tensor(233)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(269),G2tensor(82),G2tensor(79),G2tensor(376),G2tensor(373),G2tensor(328) &
    ,G2tensor(325),G1tensor(730),G1tensor(725),G0tensor(730),G0tensor(725)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(339),G2tensor(330),G1tensor(598),G1tensor(593),G1tensor(588),G1tensor(362) &
    ,G1tensor(177),G1tensor(159),G1tensor(148),G1tensor(205),G0tensor(598),G0tensor(593),G0tensor(588),G0tensor(362),G0tensor(212) &
    ,G0tensor(207),G0tensor(202),G0tensor(23)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(342),G2tensor(333),G1tensor(613),G1tensor(608),G1tensor(603),G1tensor(226) &
    ,G1tensor(201),G1tensor(184),G0tensor(613),G0tensor(608),G0tensor(603),G0tensor(227),G0tensor(222),G0tensor(217)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(345),G2tensor(336),G1tensor(623),G1tensor(618),G1tensor(43),G1tensor(225) &
    ,G0tensor(623),G0tensor(618),G0tensor(237),G0tensor(232)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(351),G2tensor(348),G1tensor(322),G1tensor(313),G1tensor(308),G1tensor(139) &
    ,G0tensor(322),G0tensor(313),G0tensor(308),G0tensor(12)])
  call ol_merge_tensors(G2tensor(363),[G2tensor(354),G1tensor(807),G1tensor(747),G1tensor(542),G1tensor(16),G0tensor(807) &
    ,G0tensor(747),G0tensor(542),G0tensor(123)])
  call ol_merge_tensors(G2tensor(366),[G2tensor(357),G1tensor(812),G1tensor(757),G1tensor(752),G0tensor(812),G0tensor(757) &
    ,G0tensor(752)])
  call ol_merge_tensors(G2tensor(369),[G2tensor(360),G1tensor(817),G1tensor(287),G1tensor(283),G0tensor(817),G0tensor(287) &
    ,G0tensor(283)])
  call ol_merge_tensors(G2tensor(375),[G2tensor(372),G1tensor(727),G1tensor(572),G1tensor(52),G0tensor(727),G0tensor(572) &
    ,G0tensor(153)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(94),G1tensor(290),G1tensor(85),G0tensor(290),G0tensor(3)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(55),G1tensor(310),G1tensor(115),G0tensor(310),G0tensor(8)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(281),G1tensor(315),G1tensor(121),G0tensor(315),G0tensor(9)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(109),G1tensor(330),G1tensor(145),G0tensor(330),G0tensor(13)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(83),G1tensor(350),G1tensor(175),G0tensor(350),G0tensor(18)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(77),G1tensor(355),G1tensor(181),G0tensor(355),G0tensor(19)])
  call ol_merge_tensors(G1tensor(74),[G1tensor(44),G1tensor(7),G1tensor(229),G1tensor(199),G0tensor(57),G0tensor(52),G0tensor(32) &
    ,G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G1tensor(367),[G1tensor(164),G1tensor(138),G1tensor(13),G1tensor(211),G0tensor(367),G0tensor(89) &
    ,G0tensor(74),G0tensor(39),G0tensor(24)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(302),G1tensor(372),G1tensor(20),G1tensor(217),G0tensor(372),G0tensor(125) &
    ,G0tensor(25)])
  call ol_merge_tensors(G1tensor(430),[G1tensor(415),G1tensor(380),G1tensor(365),G1tensor(235),G0tensor(430),G0tensor(415) &
    ,G0tensor(380),G0tensor(365),G0tensor(28)])
  call ol_merge_tensors(G1tensor(435),[G1tensor(420),G1tensor(385),G1tensor(370),G1tensor(192),G1tensor(134),G1tensor(36) &
    ,G1tensor(31),G0tensor(435),G0tensor(420),G0tensor(385),G0tensor(370),G0tensor(94),G0tensor(79),G0tensor(44),G0tensor(29)])
  call ol_merge_tensors(G1tensor(777),[G1tensor(377),G1tensor(1),G0tensor(777),G0tensor(377),G0tensor(33)])
  call ol_merge_tensors(G1tensor(382),[G1tensor(198),G1tensor(168),G1tensor(66),G1tensor(12),G0tensor(382),G0tensor(99) &
    ,G0tensor(84),G0tensor(49),G0tensor(34)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(41),G1tensor(55),G0tensor(387),G0tensor(145),G0tensor(35)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(80),G1tensor(38),G1tensor(60),G1tensor(18),G0tensor(67),G0tensor(62),G0tensor(47) &
    ,G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(782),[G1tensor(392),G1tensor(19),G0tensor(782),G0tensor(392),G0tensor(38)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(29),G1tensor(24),G0tensor(397),G0tensor(135),G0tensor(40)])
  call ol_merge_tensors(G1tensor(455),[G1tensor(445),G1tensor(405),G1tensor(395),G1tensor(54),G0tensor(455),G0tensor(445) &
    ,G0tensor(405),G0tensor(395),G0tensor(43)])
  call ol_merge_tensors(G1tensor(787),[G1tensor(402),G1tensor(72),G0tensor(787),G0tensor(402),G0tensor(48)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(112),G1tensor(48),G0tensor(407),G0tensor(150),G0tensor(50)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(3),G1tensor(222),G1tensor(120),G1tensor(56),G0tensor(417),G0tensor(114) &
    ,G0tensor(104),G0tensor(64),G0tensor(54)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(98),G1tensor(793),G1tensor(422),G1tensor(65),G1tensor(62),G0tensor(793) &
    ,G0tensor(422),G0tensor(165),G0tensor(55)])
  call ol_merge_tensors(G1tensor(762),[G1tensor(748),G1tensor(427),G1tensor(108),G0tensor(762),G0tensor(748),G0tensor(427) &
    ,G0tensor(58)])
  call ol_merge_tensors(G1tensor(432),[G1tensor(10),G1tensor(228),G1tensor(98),G1tensor(102),G0tensor(432),G0tensor(119) &
    ,G0tensor(109),G0tensor(69),G0tensor(59)])
  call ol_merge_tensors(G1tensor(437),[G1tensor(221),G1tensor(84),G0tensor(437),G0tensor(185),G0tensor(60)])
  call ol_merge_tensors(G1tensor(767),[G1tensor(753),G1tensor(442),G1tensor(86),G0tensor(767),G0tensor(753),G0tensor(442) &
    ,G0tensor(63)])
  call ol_merge_tensors(G1tensor(447),[G1tensor(87),G1tensor(114),G0tensor(447),G0tensor(175),G0tensor(65)])
  call ol_merge_tensors(G1tensor(772),[G1tensor(758),G1tensor(452),G1tensor(92),G0tensor(772),G0tensor(758),G0tensor(452) &
    ,G0tensor(68)])
  call ol_merge_tensors(G1tensor(457),[G1tensor(117),G1tensor(104),G0tensor(457),G0tensor(190),G0tensor(70)])
  call ol_merge_tensors(G1tensor(224),[G1tensor(210),G1tensor(150),G1tensor(144),G1tensor(116),G0tensor(107),G0tensor(102) &
    ,G0tensor(82),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(183),G1tensor(780),G1tensor(467),G1tensor(160),G1tensor(126),G0tensor(780) &
    ,G0tensor(467),G0tensor(205),G0tensor(75)])
  call ol_merge_tensors(G1tensor(515),[G1tensor(505),G1tensor(475),G1tensor(465),G1tensor(132),G0tensor(515),G0tensor(505) &
    ,G0tensor(475),G0tensor(465),G0tensor(78)])
  call ol_merge_tensors(G1tensor(472),[G1tensor(152),G0tensor(472),G0tensor(83)])
  call ol_merge_tensors(G1tensor(477),[G1tensor(183),G1tensor(156),G0tensor(477),G0tensor(215),G0tensor(85)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(240),G1tensor(194),G1tensor(180),G1tensor(174),G0tensor(117),G0tensor(112) &
    ,G0tensor(97),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G1tensor(482),[G1tensor(162),G0tensor(482),G0tensor(88)])
  call ol_merge_tensors(G1tensor(487),[G1tensor(190),G1tensor(170),G0tensor(487),G0tensor(220),G0tensor(90)])
  call ol_merge_tensors(G1tensor(535),[G1tensor(525),G1tensor(495),G1tensor(485),G1tensor(182),G0tensor(535),G0tensor(525) &
    ,G0tensor(495),G0tensor(485),G0tensor(93)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(204),G0tensor(492),G0tensor(98)])
  call ol_merge_tensors(G1tensor(497),[G1tensor(232),G1tensor(200),G0tensor(497),G0tensor(230),G0tensor(100)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(113),G1tensor(808),G1tensor(765),G1tensor(507),G1tensor(245),G1tensor(216) &
    ,G0tensor(808),G0tensor(765),G0tensor(507),G0tensor(245),G0tensor(105)])
  call ol_merge_tensors(G1tensor(733),[G1tensor(512),G1tensor(234),G0tensor(733),G0tensor(512),G0tensor(108)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(255),G1tensor(230),G0tensor(517),G0tensor(255),G0tensor(110)])



end subroutine vamp_3

end module ol_vamp_3_ppajj_ew_dddxdxa_4_/**/REALKIND
