
module ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(51,3), K2(3,3), KL(3,3), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0]
  K1( 2,:) = [   0,   9,   0]
  K1( 3,:) = [   0,   0,   0]
  K1( 4,:) = [   0,   0,   0]
  K1( 5,:) = [   0,  12,   0]
  K1( 6,:) = [   0,   0,   0]
  K1( 7,:) = [   0,   0,   0]
  K1( 8,:) = [   0, -12,   0]
  K1( 9,:) = [   0,   0,   0]
  K1(10,:) = [   0,   0,   0]
  K1(11,:) = [   0,  12,   0]
  K1(12,:) = [   0,   0,   0]
  K1(13,:) = [   0,   0,   0]
  K1(14,:) = [   0,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,   0,   0]
  K1(17,:) = [   0,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   0,   0]
  K1(20,:) = [   0,  12,   0]
  K1(21,:) = [   0,   0,   0]
  K1(22,:) = [   0,   0,   0]
  K1(23,:) = [   0,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   0,   0]
  K1(26,:) = [   0,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,   0,   0]
  K1(29,:) = [   0, -12,   0]
  K1(30,:) = [   0,   0,   0]
  K1(31,:) = [   0,   0,   0]
  K1(32,:) = [   0,  12,   0]
  K1(33,:) = [   0,   0,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0,   0,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,   0,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   0,   3,   0]
  K1(50,:) = [   3,   0,   9]
  K1(51,:) = [   0,   9,   0]

  K2(1,:) = [ 0, 0, 3]
  K2(2,:) = [ 3, 9, 0]
  K2(3,:) = [ 0, 0, 9]

  KL(1,:) = [ 0, 3, 0]
  KL(2,:) = [ 3, 0, 9]
  KL(3,:) = [ 0, 9, 0]

#if -1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+3*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND



module ol_forced_parameters_ppajj_ew_uuxbbxa_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppajj_ew_uuxbbxa_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 32 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(84)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,60), wf8(8,68), wf32(32,118)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(217), c(206)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/REALKIND






! **********************************************************************
module ol_loop_ppajj_ew_uuxbbxa_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**3)/27._/**/REALKIND
    f(  2) = (4*CI*eQED**3)/27._/**/REALKIND
    f(  3) = (CI*eQED**3)/3._/**/REALKIND
    f(  4) = (2*CI*eQED**3)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**5)/27._/**/REALKIND
    f(  6) = (CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  7) = (4*CI*countertermnorm*eQED**5)/27._/**/REALKIND
    f(  8) = (2*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  9) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f( 10) = (4*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f( 11) = (2*CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f( 12) = CI*countertermnorm*eQED**5
    f( 13) = (CI*eQED*gQCD**2)/3._/**/REALKIND
    f( 14) = (2*CI*eQED*gQCD**2)/3._/**/REALKIND
    f( 15) = (2*CI*countertermnorm*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 16) = (4*CI*countertermnorm*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 17) = (CI*countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 18) = (2*CI*countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 19) = CI*countertermnorm*eQED**3*gQCD**2
    f( 20) = (2*CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 21) = (4*CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 22) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 23) = (2*CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 24) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 25) = (4*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 26) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 27) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 28) = (countertermnorm*eQED**5*MB)/(MW*sw*9._/**/REALKIND)
    f( 29) = (countertermnorm*eQED**5*MB)/(MW*sw*6._/**/REALKIND)
    f( 30) = (2*countertermnorm*eQED**5*MB)/(MW*sw*9._/**/REALKIND)
    f( 31) = (countertermnorm*eQED**5*MB)/(MW*sw*3._/**/REALKIND)
    f( 32) = (CI*countertermnorm*eQED**5*EWctHAA*MB)/(3._/**/REALKIND*MW*sw)
    f( 33) = (CI*countertermnorm*eQED**5*EWctHZA*MB)/(2._/**/REALKIND*MW*sw)
    f( 34) = (2*eQED**5*integralnorm*SwB)/243._/**/REALKIND
    f( 35) = (4*eQED**5*integralnorm*SwB)/243._/**/REALKIND
    f( 36) = (8*eQED**5*integralnorm*SwB)/243._/**/REALKIND
    f( 37) = (eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 38) = (16*eQED**5*integralnorm*SwB)/243._/**/REALKIND
    f( 39) = (2*eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 40) = (4*eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 41) = (2*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 42) = (8*eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 43) = (eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f( 44) = (4*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 45) = (2*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f( 46) = (eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f( 47) = (2*eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f( 48) = (4*eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f( 49) = (8*eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f( 50) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f( 51) = (2*eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f( 52) = (2*eQED**5*integralnorm*MW**2*SwB)/27._/**/REALKIND
    f( 53) = (4*eQED**5*integralnorm*MW**2*SwB)/27._/**/REALKIND
    f( 54) = (2*eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 55) = eQED**5*integralnorm*MW**2*SwB
    f( 56) = (eQED**5*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MB*SwB)/(sw**4*6._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 63) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 64) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 65) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*12._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*6._/**/REALKIND)
    f( 68) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*12._/**/REALKIND)
    f( 69) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f( 70) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f( 71) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*3._/**/REALKIND)
    f( 72) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 80) = (2*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 82) = (4*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 84) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 87) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f( 89) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 90) = (2*cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 91) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f( 92) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 93) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 94) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MB*SwB)/(sw**2*18._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MB*SwB)/(sw**2*9._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f( 98) = (2*eQED**5*integralnorm*MB*SwB)/(sw**2*9._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MB*SwB)/(sw**2*3._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MB*MH**2*SwB)/(sw**2*6._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(104) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(106) = (4*eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(108) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(111) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(112) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(113) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(114) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*54._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(119) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(120) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2*3._/**/REALKIND)
    f(128) = (2*eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2*3._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(133) = (cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(134) = (2*cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(135) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(136) = (4*cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(137) = (2*cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*6._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(143) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(144) = (2*cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(147) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(149) = (4*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(150) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(152) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(154) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(155) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(156) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(157) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(158) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(159) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(160) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(161) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(162) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(163) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(164) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(165) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(166) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(167) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(168) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(169) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND)
    f(170) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(171) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(172) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(176) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(177) = (2*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(178) = (4*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(179) = (8*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(180) = (eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(181) = (16*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(182) = (2*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(183) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(184) = (32*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(185) = (4*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(186) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(187) = (8*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(188) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(189) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(190) = (16*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(191) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(192) = eQED**5*integralnorm*SwF
    f(193) = (4*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(194) = 2*eQED**5*integralnorm*SwF
    f(195) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*54._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*27._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(211) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*27._/**/REALKIND)
    f(215) = (2*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*27._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)

  c = [ 6*f(34), 6*f(35), 6*f(36), 6*f(37), 6*f(38), 6*f(39), 6*f(40), 6*f(41), 6*f(42), 6*f(43), 6*f(44), 6*f(45), f(46), 3*f(46) &
    , f(47), 3*f(47), 8*f(47), f(48), 3*f(48), 8*f(48), f(49), 3*f(49), f(50), 3*f(50), 8*f(50), f(51), 3*f(51), 8*f(51), 6*f(52) &
    , 6*f(53), 6*f(54), 6*f(55), 6*f(56), 6*f(57), 6*f(58), 6*f(59), 6*f(60), 6*f(61), 6*f(62), 6*f(63), 6*f(64), 6*f(65), 6*f(66) &
    , 6*f(67), 6*f(68), 6*f(69), 6*f(70), 6*f(71), 6*f(72), 6*f(73), 6*f(74), 6*f(75), 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80) &
    , 6*f(81), 6*f(82), 6*f(83), 6*f(84), 6*f(85), 6*f(86), 6*f(87), 6*f(88), 6*f(89), 6*f(90), 6*f(91), f(92), 3*f(92), f(93) &
    , 3*f(93), f(94), 3*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99), 6*f(100), 6*f(101), 6*f(102), 6*f(103), 6*f(104) &
    , 6*f(105), 6*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110), 6*f(111), f(112), 3*f(112), f(113), 3*f(113), f(114), 3*f(114) &
    , 6*f(115), 6*f(116), 6*f(117), 6*f(118), f(119), 3*f(119), f(120), 3*f(120), 6*f(121), 6*f(122), 6*f(123), 6*f(124), 6*f(125) &
    , 6*f(126), 6*f(127), 6*f(128), 6*f(129), 6*f(130), 6*f(131), 6*f(132), 6*f(133), 6*f(134), 6*f(135), 6*f(136), 6*f(137) &
    , 6*f(138), 6*f(139), 6*f(140), 6*f(141), 6*f(142), 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148), 6*f(149) &
    , 6*f(150), 6*f(151), 6*f(152), 6*f(153), 6*f(154), 6*f(155), 6*f(156), 6*f(157), 6*f(158), 6*f(159), 6*f(160), 6*f(161) &
    , 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167), 6*f(168), 6*f(169), 6*f(170), 6*f(171), 6*f(172), 6*f(173) &
    , 6*f(174), 6*f(175), 6*f(176), 18*f(177), 18*f(178), 18*f(179), 18*f(180), 18*f(181), 6*f(182), 18*f(182), 6*f(183) &
    , 18*f(184), 6*f(185), 18*f(185), 6*f(186), 18*f(187), 6*f(188), 18*f(188), 6*f(189), 18*f(190), 6*f(191), 18*f(191), 6*f(192) &
    , 18*f(193), 6*f(194), 18*f(195), 18*f(196), 18*f(197), 18*f(198), 6*f(199), 6*f(200), 6*f(201), 6*f(202), 6*f(203), 6*f(204) &
    , 6*f(205), 6*f(206), 6*f(207), 6*f(208), 6*f(209), 6*f(210), 6*f(211), 6*f(212), 6*f(213), 18*f(214), 18*f(215), 18*f(216) &
    , 18*f(217) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20) - MB2)+L(6,20))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(6) = 1 /((L(5,24) - MB2)+L(6,24))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(10) = 1 /((L(5,12))+L(6,12))
  den(12) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(14) = 1 /((L(5,18))+L(6,18))
  den(17) = 1 /((L(5,12) - MH2)+L(6,12))
  den(20) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(24) = 1 /((L(5,28))+L(6,28))
  den(28) = 1 /((L(5,11) - MB2)+L(6,11))
  den(39) = 1 /((L(5,7) - MB2)+L(6,7))
  den(44) = 1 /((L(5,14))+L(6,14))
  den(49) = 1 /((L(5,19))+L(6,19))
  den(52) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(57) = 1 /((L(5,13))+L(6,13))
  den(68) = 1 /((L(5,28) - MH2)+L(6,28))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(4)*den(6)
  den(11) = den(9)*den(10)
  den(13) = den(9)*den(12)
  den(15) = den(10)*den(14)
  den(16) = den(12)*den(14)
  den(18) = den(1)*den(17)
  den(19) = den(4)*den(17)
  den(21) = den(2)*den(20)
  den(22) = den(1)*den(21)
  den(23) = den(4)*den(21)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(27) = den(4)*den(25)
  den(29) = den(1)*den(28)
  den(30) = den(2)*den(29)
  den(31) = den(4)*den(28)
  den(32) = den(2)*den(31)
  den(33) = den(6)*den(20)
  den(34) = den(1)*den(33)
  den(35) = den(4)*den(33)
  den(36) = den(6)*den(24)
  den(37) = den(1)*den(36)
  den(38) = den(4)*den(36)
  den(40) = den(1)*den(39)
  den(41) = den(6)*den(40)
  den(42) = den(4)*den(39)
  den(43) = den(6)*den(42)
  den(45) = den(10)*den(44)
  den(46) = den(9)*den(45)
  den(47) = den(12)*den(44)
  den(48) = den(9)*den(47)
  den(50) = den(9)*den(49)
  den(51) = den(12)*den(50)
  den(53) = den(9)*den(52)
  den(54) = den(12)*den(53)
  den(55) = den(10)*den(50)
  den(56) = den(10)*den(53)
  den(58) = den(10)*den(57)
  den(59) = den(14)*den(58)
  den(60) = den(12)*den(57)
  den(61) = den(14)*den(60)
  den(62) = den(14)*den(49)
  den(63) = den(12)*den(62)
  den(64) = den(14)*den(52)
  den(65) = den(12)*den(64)
  den(66) = den(10)*den(62)
  den(67) = den(10)*den(64)
  den(69) = den(2)*den(68)
  den(70) = den(6)*den(68)
  den(71) = den(1)*den(12)
  den(72) = den(4)*den(12)
  den(73) = den(1)*den(10)
  den(74) = den(4)*den(10)
  den(75) = den(9)*den(17)
  den(76) = den(14)*den(17)
  den(77) = den(1)*den(69)
  den(78) = den(4)*den(69)
  den(79) = den(1)*den(70)
  den(80) = den(4)*den(70)
  den(81) = den(17)*den(50)
  den(82) = den(17)*den(53)
  den(83) = den(17)*den(62)
  den(84) = den(17)*den(64)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,118))
  allocate(M1helarray(3,hel_states))
  allocate(M1helarray_ct(3,hel_states))
  allocate(M0_col1_helarray(3,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(3,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppajj_ew_uuxbbxa_3_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up bottom anti-bottom gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppajj_ew_uuxbbxa_3, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppajj_ew_uuxbbxa_3, only: &
    & external_perm_ppajj_ew_uuxbbxa_3, &
    & external_perm_inv_ppajj_ew_uuxbbxa_3, &
    & extcomb_perm_ppajj_ew_uuxbbxa_3, &
    & average_factor_ppajj_ew_uuxbbxa_3
  use ol_external_ppajj_ew_uuxbbxa_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppajj_ew_uuxbbxa_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(3), M2(3)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,118))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMB, nMB, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppajj_ew_uuxbbxa_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,2), 20, MB, 1_intkind1, wf4(:,3), n2(1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,4), t3x4(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,5), 24, MB, 1_intkind1, wf4(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), ex3(:), wf8(:,4), n3(:,8), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,7), n3(:,9), t3x4(:,:,5))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,8), n3(:,10), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,7), 17, ZERO, 0_intkind1, wf4(:,9), n2(3))
  call vert_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,5), n3(:,11), t3x8(:,:,5))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,10), n3(:,12), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,9), ex2(:), wf8(:,6), n3(:,13), t3x8(:,:,6))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,11), n3(:,14), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,11), 18, ZERO, 0_intkind1, wf4(:,12), n2(4))
  call vert_QA_V(ntry, ex1(:), wf4(:,12), wf8(:,7), n3(:,15), t3x8(:,:,7))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,12), wf8(:,8), n3(:,16), t3x8(:,:,8))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,13), n3(:,17), t3x4(:,:,9))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf8(:,9), n3(:,18), t3x8(:,:,9))
  call counter_VV_S(ntry, wf4(:,4), ex5(:), wf8(:,10), n3(:,19), t3x8(:,:,10))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,11), n3(:,20), t3x8(:,:,11))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), wf4(:,1), wf8(:,12), n3(:,21), t3x8(:,:,12))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,13), n3(:,22), t3x8(:,:,13))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,4), wf8(:,14), n3(:,23), t3x8(:,:,14))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,1), wf8(:,15), n3(:,24), t3x8(:,:,15))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,14), n3(:,25), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,14), 24, MB, 1_intkind1, wf4(:,15), n2(5))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), ex5(:), wf4(:,16), n3(:,26), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,16), 24, MB, 1_intkind1, wf4(:,17), n2(6))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,16), n3(:,27), t3x8(:,:,16))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,1), ex3(:), wf8(:,17), n3(:,28), t3x8(:,:,17))
  call counter_ZQ_A(gZd,ntry, wf4(:,4), ex3(:), wf8(:,18), n3(:,29), t3x8(:,:,18))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,4), ex3(:), wf8(:,19), n3(:,30), t3x8(:,:,19))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,1), ex3(:), wf8(:,20), n3(:,31), t3x8(:,:,20))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,18), n3(:,32), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,18), 20, MB, 1_intkind1, wf4(:,19), n2(7))
  call counter_VQ_A_LR(EWctAbb,ntry, ex5(:), ex3(:), wf4(:,20), n3(:,33), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,20), 20, MB, 1_intkind1, wf4(:,21), n2(8))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,22), n3(:,34), t3x4(:,:,14))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,23), n3(:,35), t3x4(:,:,15))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,24), n3(:,36), t3x4(:,:,16))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,25), n3(:,37), t3x4(:,:,17))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,26), n3(:,38), t3x4(:,:,18))
  call counter_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,21), n3(:,39), t3x8(:,:,21))
  call counter_QA_V_LR(EWctAuu,ntry, wf4(:,9), ex2(:), wf8(:,22), n3(:,40), t3x8(:,:,22))
  call counter_QA_Z(gZu,ntry, wf4(:,9), ex2(:), wf8(:,23), n3(:,41), t3x8(:,:,23))
  call counter_QA_Z(EWctVuu,ntry, wf4(:,9), ex2(:), wf8(:,24), n3(:,42), t3x8(:,:,24))
  call counter_QA_V_LR(EWctGuu,ntry, wf4(:,9), ex2(:), wf8(:,25), n3(:,43), t3x8(:,:,25))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,27), n3(:,44), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,27), 18, ZERO, 0_intkind1, wf4(:,28), n2(9))
  call vert_QA_V(ntry, ex1(:), wf4(:,28), wf8(:,26), n3(:,45), t3x8(:,:,26))
  call counter_AV_Q_LR(EWctAuu,ntry, ex2(:), ex5(:), wf4(:,29), n3(:,46), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,29), 18, ZERO, 0_intkind1, wf4(:,30), n2(10))
  call vert_QA_V(ntry, ex1(:), wf4(:,30), wf8(:,27), n3(:,47), t3x8(:,:,27))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,28), wf8(:,28), n3(:,48), t3x8(:,:,28))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,30), wf8(:,29), n3(:,49), t3x8(:,:,29))
  call counter_QA_V(ntry, ex1(:), wf4(:,12), wf8(:,30), n3(:,50), t3x8(:,:,30))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), wf4(:,12), wf8(:,31), n3(:,51), t3x8(:,:,31))
  call counter_QA_Z(gZu,ntry, ex1(:), wf4(:,12), wf8(:,32), n3(:,52), t3x8(:,:,32))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), wf4(:,12), wf8(:,33), n3(:,53), t3x8(:,:,33))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), wf4(:,12), wf8(:,34), n3(:,54), t3x8(:,:,34))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,31), n3(:,55), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,31), 17, ZERO, 0_intkind1, wf4(:,32), n2(11))
  call vert_QA_V(ntry, wf4(:,32), ex2(:), wf8(:,35), n3(:,56), t3x8(:,:,35))
  call counter_VQ_A_LR(EWctAuu,ntry, ex5(:), ex1(:), wf4(:,33), n3(:,57), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,33), 17, ZERO, 0_intkind1, wf4(:,34), n2(12))
  call vert_QA_V(ntry, wf4(:,34), ex2(:), wf8(:,36), n3(:,58), t3x8(:,:,36))
  call vert_QA_Z(gZu,ntry, wf4(:,32), ex2(:), wf8(:,37), n3(:,59), t3x8(:,:,37))
  call vert_QA_Z(gZu,ntry, wf4(:,34), ex2(:), wf8(:,38), n3(:,60), t3x8(:,:,38))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,35), n3(:,61), t3x4(:,:,23))
  call vert_AV_Q(ntry, ex4(:), wf4(:,35), wf8(:,39), n3(:,62), t3x8(:,:,39))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), ex2(:), wf4(:,36), n3(:,63), t3x4(:,:,24))
  call vert_AV_Q(ntry, ex4(:), wf4(:,36), wf8(:,40), n3(:,64), t3x8(:,:,40))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,37), n3(:,65), t3x4(:,:,25))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,37), wf8(:,41), n3(:,66), t3x8(:,:,41))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), ex2(:), wf4(:,38), n3(:,67), t3x4(:,:,26))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,38), wf8(:,42), n3(:,68), t3x8(:,:,42))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), ex2(:), wf4(:,39), n3(:,69), t3x4(:,:,27))
  call vert_AV_Q(ntry, ex4(:), wf4(:,39), wf8(:,43), n3(:,70), t3x8(:,:,43))
  call vert_VQ_A(ntry, wf4(:,35), ex3(:), wf8(:,44), n3(:,71), t3x8(:,:,44))
  call vert_VQ_A(ntry, wf4(:,36), ex3(:), wf8(:,45), n3(:,72), t3x8(:,:,45))
  call vert_ZQ_A(gZd,ntry, wf4(:,37), ex3(:), wf8(:,46), n3(:,73), t3x8(:,:,46))
  call vert_ZQ_A(gZd,ntry, wf4(:,38), ex3(:), wf8(:,47), n3(:,74), t3x8(:,:,47))
  call vert_VQ_A(ntry, wf4(:,39), ex3(:), wf8(:,48), n3(:,75), t3x8(:,:,48))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,3), wf8(:,49), n3(:,76), t3x8(:,:,49))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,40), n2(13))
  call counter_V_S(EWctXZ,ntry, wf4(:,4), 3, wf4(:,41), n2(14))
  call vert_QA_V(ntry, wf4(:,3), ex4(:), wf8(:,50), n3(:,77), t3x8(:,:,50))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,42), n2(15))
  call vert_QA_Z(gZd,ntry, wf4(:,3), ex4(:), wf8(:,51), n3(:,78), t3x8(:,:,51))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,43), n2(16))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 3, wf4(:,44), n2(17))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 3, wf4(:,45), n2(18))
  call counter_Q_A(ctbb,5,ntry, wf4(:,3), 20, wf4(:,46), n2(19))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,52), n2(20))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,3), 20, wf4(:,47), n2(21))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,53), n2(22))
  call vert_AQ_S(gX,ntry, wf4(:,6), ex3(:), wf8(:,54), n3(:,79), t3x8(:,:,52))
  call vert_QA_V(ntry, ex3(:), wf4(:,6), wf8(:,55), n3(:,80), t3x8(:,:,53))
  call vert_QA_Z(gZd,ntry, ex3(:), wf4(:,6), wf8(:,56), n3(:,81), t3x8(:,:,54))
  call counter_A_Q(ctbb,5,ntry, wf4(:,6), 24, wf4(:,48), n2(23))
  call prop_Q_A(ntry, wf8(:,3), 7, MB, 1_intkind1, wf8(:,57), n2(24))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,6), 24, wf4(:,49), n2(25))
  call prop_Q_A(ntry, wf8(:,4), 7, MB, 1_intkind1, wf8(:,58), n2(26))
  call vert_AV_Q(ntry, ex2(:), wf4(:,8), wf8(:,59), n3(:,82), t3x8(:,:,55))
  call counter_Q_A(ctqq,2,ntry, wf4(:,9), 17, wf4(:,50), n2(27))
  call prop_A_Q(ntry, wf8(:,59), 14, ZERO, 0_intkind1, wf8(:,60), n2(28))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,9), 17, wf4(:,51), n2(29))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,10), wf8(:,61), n3(:,83), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,61), 14, ZERO, 0_intkind1, wf8(:,62), n2(30))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,52), n3(:,84), t3x4(:,:,28))
  call counter_S_V(EWctXA,ntry, wf4(:,52), 12, wf4(:,53), n2(31))
  call counter_S_V(EWctXZ,ntry, wf4(:,52), 12, wf4(:,54), n2(32))
  call counter_V_V(EWctAA,ntry, wf4(:,8), 12, wf4(:,55), n2(33))
  call counter_V_V(EWctAZ,ntry, wf4(:,10), 12, wf4(:,56), n2(34))
  call counter_V_V(EWctAZ,ntry, wf4(:,8), 12, wf4(:,57), n2(35))
  call counter_V_V(EWctZZ,ntry, wf4(:,10), 12, wf4(:,58), n2(36))
  call vert_VQ_A(ntry, wf4(:,8), ex1(:), wf8(:,63), n3(:,85), t3x8(:,:,57))
  call counter_A_Q(ctqq,2,ntry, wf4(:,12), 18, wf4(:,59), n2(37))
  call prop_Q_A(ntry, wf8(:,63), 13, ZERO, 0_intkind1, wf8(:,64), n2(38))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,12), 18, wf4(:,60), n2(39))
  call vert_ZQ_A(gZu,ntry, wf4(:,10), ex1(:), wf8(:,65), n3(:,86), t3x8(:,:,58))
  call prop_Q_A(ntry, wf8(:,65), 13, ZERO, 0_intkind1, wf8(:,66), n2(40))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,3), wf8(:,67), n3(:,87), t3x8(:,:,59))
  call vert_AQ_S(gH,ntry, wf4(:,6), ex3(:), wf8(:,68), n3(:,88), t3x8(:,:,60))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,1), n3(:,89), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,2), A(:,2), n3(:,90), t3x32(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,3), n3(:,91), t3x32(:,:,3), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,3), A(:,4), n3(:,92), t3x32(:,:,4), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,4), A(:,5), n3(:,93), t3x32(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,3), A(:,6), n3(:,94), t3x32(:,:,6), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,5), A(:,7), n3(:,95), t3x32(:,:,7), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,6), A(:,8), n3(:,96), t3x32(:,:,8), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,5), A(:,9), n3(:,97), t3x32(:,:,9), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,7), A(:,10), n3(:,98), t3x32(:,:,10), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,8), A(:,11), n3(:,99), t3x32(:,:,11), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,7), A(:,12), n3(:,100), t3x32(:,:,12), nhel, den(15))

    call Hcont_SS(nsync, wf4(:,13), wf8(:,9), A(:,13), n3(:,101), t3x32(:,:,13), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,13), wf8(:,10), A(:,14), n3(:,102), t3x32(:,:,14), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,11), A(:,15), n3(:,103), t3x32(:,:,15), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,12), A(:,16), n3(:,104), t3x32(:,:,16), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,13), A(:,17), n3(:,105), t3x32(:,:,17), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,14), A(:,18), n3(:,106), t3x32(:,:,18), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,15), A(:,19), n3(:,107), t3x32(:,:,19), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,15), A(:,20), n3(:,108), t3x32(:,:,20), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,17), A(:,21), n3(:,109), t3x32(:,:,21), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,15), A(:,22), n3(:,110), t3x32(:,:,22), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,17), A(:,23), n3(:,111), t3x32(:,:,23), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,17), A(:,24), n3(:,112), t3x32(:,:,24), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,16), A(:,25), n3(:,113), t3x32(:,:,25), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,17), A(:,26), n3(:,114), t3x32(:,:,26), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,18), A(:,27), n3(:,115), t3x32(:,:,27), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,19), A(:,28), n3(:,116), t3x32(:,:,28), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,20), A(:,29), n3(:,117), t3x32(:,:,29), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,19), A(:,30), n3(:,118), t3x32(:,:,30), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,21), A(:,31), n3(:,119), t3x32(:,:,31), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,19), A(:,32), n3(:,120), t3x32(:,:,32), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,21), A(:,33), n3(:,121), t3x32(:,:,33), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,21), A(:,34), n3(:,122), t3x32(:,:,34), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,22), A(:,35), n3(:,123), t3x32(:,:,35), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,23), A(:,36), n3(:,124), t3x32(:,:,36), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,24), A(:,37), n3(:,125), t3x32(:,:,37), nhel, den(13))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,25), A(:,38), n3(:,126), t3x32(:,:,38), nhel, den(13))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,26), A(:,39), n3(:,127), t3x32(:,:,39), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,22), A(:,40), n3(:,128), t3x32(:,:,40), nhel, den(15))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,23), A(:,41), n3(:,129), t3x32(:,:,41), nhel, den(15))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,24), A(:,42), n3(:,130), t3x32(:,:,42), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,25), A(:,43), n3(:,131), t3x32(:,:,43), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,26), A(:,44), n3(:,132), t3x32(:,:,44), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,21), A(:,45), n3(:,133), t3x32(:,:,45), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,22), A(:,46), n3(:,134), t3x32(:,:,46), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,23), A(:,47), n3(:,135), t3x32(:,:,47), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,24), A(:,48), n3(:,136), t3x32(:,:,48), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,25), A(:,49), n3(:,137), t3x32(:,:,49), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,26), A(:,50), n3(:,138), t3x32(:,:,50), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,27), A(:,51), n3(:,139), t3x32(:,:,51), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,28), A(:,52), n3(:,140), t3x32(:,:,52), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,29), A(:,53), n3(:,141), t3x32(:,:,53), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,27), A(:,54), n3(:,142), t3x32(:,:,54), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,30), A(:,55), n3(:,143), t3x32(:,:,55), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,31), A(:,56), n3(:,144), t3x32(:,:,56), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,32), A(:,57), n3(:,145), t3x32(:,:,57), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,33), A(:,58), n3(:,146), t3x32(:,:,58), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,34), A(:,59), n3(:,147), t3x32(:,:,59), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,35), A(:,60), n3(:,148), t3x32(:,:,60), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,36), A(:,61), n3(:,149), t3x32(:,:,61), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,37), A(:,62), n3(:,150), t3x32(:,:,62), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,38), A(:,63), n3(:,151), t3x32(:,:,63), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,36), A(:,64), n3(:,152), t3x32(:,:,64), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,39), A(:,65), n3(:,153), t3x32(:,:,65), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,40), A(:,66), n3(:,154), t3x32(:,:,66), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,41), A(:,67), n3(:,155), t3x32(:,:,67), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,42), A(:,68), n3(:,156), t3x32(:,:,68), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,43), A(:,69), n3(:,157), t3x32(:,:,69), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,44), A(:,70), n3(:,158), t3x32(:,:,70), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,45), A(:,71), n3(:,159), t3x32(:,:,71), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,46), A(:,72), n3(:,160), t3x32(:,:,72), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,47), A(:,73), n3(:,161), t3x32(:,:,73), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,48), A(:,74), n3(:,162), t3x32(:,:,74), nhel, den(7))
    call Hcont_SS(nsync, wf8(:,49), wf4(:,40), A(:,75), n3(:,163), t3x32(:,:,75), nhel, den(22))
    call Hcont_SS(nsync, wf8(:,49), wf4(:,41), A(:,76), n3(:,164), t3x32(:,:,76), nhel, den(23))
    call Hcont_VV(nsync, wf8(:,50), wf4(:,42), A(:,77), n3(:,165), t3x32(:,:,77), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,51), wf4(:,43), A(:,78), n3(:,166), t3x32(:,:,78), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,50), wf4(:,44), A(:,79), n3(:,167), t3x32(:,:,79), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,51), wf4(:,45), A(:,80), n3(:,168), t3x32(:,:,80), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,52), A(:,81), n3(:,169), t3x32(:,:,81), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,52), wf4(:,47), A(:,82), n3(:,170), t3x32(:,:,82), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,53), A(:,83), n3(:,171), t3x32(:,:,83), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,47), wf8(:,53), A(:,84), n3(:,172), t3x32(:,:,84), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,52), wf4(:,47), A(:,85), n3(:,173), t3x32(:,:,85), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,40), wf8(:,54), A(:,86), n3(:,174), t3x32(:,:,86), nhel, den(34))
    call Hcont_SS(nsync, wf4(:,41), wf8(:,54), A(:,87), n3(:,175), t3x32(:,:,87), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,42), wf8(:,55), A(:,88), n3(:,176), t3x32(:,:,88), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,43), wf8(:,56), A(:,89), n3(:,177), t3x32(:,:,89), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,44), wf8(:,55), A(:,90), n3(:,178), t3x32(:,:,90), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,45), wf8(:,56), A(:,91), n3(:,179), t3x32(:,:,91), nhel, den(35))
    call Hcont_QA(nsync, wf4(:,48), wf8(:,57), A(:,92), n3(:,180), t3x32(:,:,92), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,57), wf4(:,49), A(:,93), n3(:,181), t3x32(:,:,93), nhel, den(41))
    call Hcont_QA(nsync, wf4(:,48), wf8(:,58), A(:,94), n3(:,182), t3x32(:,:,94), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,49), wf8(:,58), A(:,95), n3(:,183), t3x32(:,:,95), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,57), wf4(:,49), A(:,96), n3(:,184), t3x32(:,:,96), nhel, den(41))
    call Hcont_QA(nsync, wf4(:,50), wf8(:,60), A(:,97), n3(:,185), t3x32(:,:,97), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,60), wf4(:,51), A(:,98), n3(:,186), t3x32(:,:,98), nhel, den(46))
    call Hcont_QA(nsync, wf4(:,50), wf8(:,62), A(:,99), n3(:,187), t3x32(:,:,99), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,51), wf8(:,62), A(:,100), n3(:,188), t3x32(:,:,100), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,60), wf4(:,51), A(:,101), n3(:,189), t3x32(:,:,101), nhel, den(46))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,53), A(:,102), n3(:,190), t3x32(:,:,102), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,54), A(:,103), n3(:,191), t3x32(:,:,103), nhel, den(54))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,55), A(:,104), n3(:,192), t3x32(:,:,104), nhel, den(55))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,56), A(:,105), n3(:,193), t3x32(:,:,105), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,57), A(:,106), n3(:,194), t3x32(:,:,106), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,58), A(:,107), n3(:,195), t3x32(:,:,107), nhel, den(54))
    call Hcont_QA(nsync, wf4(:,59), wf8(:,64), A(:,108), n3(:,196), t3x32(:,:,108), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,64), wf4(:,60), A(:,109), n3(:,197), t3x32(:,:,109), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,59), wf8(:,66), A(:,110), n3(:,198), t3x32(:,:,110), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,60), wf8(:,66), A(:,111), n3(:,199), t3x32(:,:,111), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,64), wf4(:,60), A(:,112), n3(:,200), t3x32(:,:,112), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,53), A(:,113), n3(:,201), t3x32(:,:,113), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,54), A(:,114), n3(:,202), t3x32(:,:,114), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,55), A(:,115), n3(:,203), t3x32(:,:,115), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,56), A(:,116), n3(:,204), t3x32(:,:,116), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,57), A(:,117), n3(:,205), t3x32(:,:,117), nhel, den(67))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,58), A(:,118), n3(:,206), t3x32(:,:,118), nhel, den(65))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(3), M2(3) ! M1helarray(3,nhel)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,3)%j-A(j,6)%j)*f(13))/2._/**/REALKIND+((A(j,9)%j+A(j,12)%j)*f(14))/2._/**/REALKIND
  M1(2)%j = (A(j,1)%j+A(j,4)%j)*f(1)+(-A(j,7)%j-A(j,10)%j)*f(2)+(-A(j,2)%j-A(j,5)%j)*f(3)+(A(j,8)%j+A(j,11)%j)*f(4)
  M1(3)%j = ((A(j,3)%j+A(j,6)%j)*f(13))/6._/**/REALKIND+((-A(j,9)%j-A(j,12)%j)*f(14))/6._/**/REALKIND

  M2(1)%j = ((-A(j,19)%j-A(j,29)%j-A(j,69)%j-A(j,74)%j+A(j,85)%j+A(j,96)%j)*f(17))/2._/**/REALKIND+((A(j,39)%j+A(j,44)%j+A(j,49)%j &
       +A(j,59)%j-A(j,101)%j-A(j,112)%j)*f(18))/2._/**/REALKIND+((-A(j,24)%j-A(j,34)%j-A(j,54)%j &
       -A(j,64)%j)*f(19))/2._/**/REALKIND
  M2(2)%j = (-A(j,81)%j-A(j,92)%j)*f(15)+(A(j,97)%j+A(j,108)%j)*f(16)+(A(j,83)%j+A(j,94)%j)*f(17)+((A(j,19)%j+A(j,29)%j+A(j,69)%j &
       +A(j,74)%j-A(j,85)%j-A(j,96)%j)*f(17))/6._/**/REALKIND+(-A(j,99)%j-A(j,110)%j)*f(18)+((-A(j,39)%j-A(j,44)%j-A(j,49)%j &
       -A(j,59)%j+A(j,101)%j+A(j,112)%j)*f(18))/6._/**/REALKIND+((A(j,24)%j+A(j,34)%j+A(j,54)%j+A(j,64)%j)*f(19))/6._/**/REALKIND &
       +(A(j,15)%j+A(j,20)%j+A(j,25)%j+A(j,30)%j)*f(20)+(-A(j,35)%j-A(j,40)%j)*f(21)+(-A(j,17)%j-A(j,22)%j-A(j,27)%j &
       -A(j,32)%j)*f(22)+(A(j,37)%j+A(j,42)%j)*f(23)+(A(j,65)%j+A(j,70)%j)*f(24)+(-A(j,45)%j-A(j,50)%j-A(j,55)%j-A(j,60)%j)*f(25) &
       +(-A(j,67)%j-A(j,72)%j)*f(26)+(A(j,47)%j+A(j,52)%j+A(j,57)%j+A(j,62)%j)*f(27)
  M2(3)%j = (-A(j,77)%j-A(j,82)%j-A(j,88)%j-A(j,93)%j)*f(5)+(-A(j,66)%j-A(j,71)%j+A(j,79)%j+A(j,90)%j)*f(6)+(A(j,98)%j+A(j,104)%j &
       +A(j,109)%j+A(j,115)%j)*f(7)+(A(j,16)%j+A(j,21)%j+A(j,26)%j+A(j,31)%j+A(j,46)%j+A(j,51)%j+A(j,56)%j+A(j,61)%j-A(j,78)%j &
       -A(j,89)%j-A(j,106)%j-A(j,117)%j)*f(8)+(-A(j,18)%j-A(j,28)%j-A(j,68)%j-A(j,73)%j+A(j,80)%j+A(j,84)%j+A(j,91)%j &
       +A(j,95)%j)*f(9)+(-A(j,36)%j-A(j,41)%j+A(j,105)%j+A(j,116)%j)*f(10)+(A(j,38)%j+A(j,43)%j+A(j,48)%j+A(j,58)%j-A(j,100)%j &
       -A(j,107)%j-A(j,111)%j-A(j,118)%j)*f(11)+(-A(j,23)%j-A(j,33)%j-A(j,53)%j-A(j,63)%j)*f(12)+(A(j,75)%j+A(j,86)%j)*f(28)+( &
       -A(j,76)%j-A(j,87)%j)*f(29)+(-A(j,102)%j-A(j,113)%j)*f(30)+(A(j,103)%j+A(j,114)%j)*f(31)-A(j,13)%j*f(32)+A(j,14)%j*f(33)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 3
      do j = 1, 3
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(3), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 3
    do j = 1, 3
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+3*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 3*k
    do i = 1, 3
      do j = 1, 3
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(3)
  complex(REALKIND), intent(in)  :: M2(3)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 3
    do j = 1, 3
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_uuxbbxa_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(3)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 3 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+3*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppajj_ew_uuxbbxa_3_/**/REALKIND
