
module ol_vamp_3_ppajj_ew_bbxagg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_bbxagg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_bbxagg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_bbxagg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_bbxagg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_bbxagg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_bbxagg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call G_TensorShift(G1tensor(503),8)
  call Hotf_4pt_reduction_last(G2tensor(468),RedSet_4(9),mass4set(:,12),  & 
G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510),G1tensor(511))
  call G_TensorShift(G1tensor(508),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(32),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(32),mass4set(:,2),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(1),mass4set(:,2),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(32),mass4set(:,3),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(1),mass4set(:,3),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(32),mass4set(:,4),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(1),mass4set(:,4),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(33),mass4set(:,5),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(2),mass4set(:,5),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(33),mass4set(:,6),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,6),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(92),RedSet_4(33),mass4set(:,7),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(2),mass4set(:,7),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(33),mass4set(:,8),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(2),mass4set(:,8),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(34),mass4set(:,1),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(3),mass4set(:,1),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(34),mass4set(:,2),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(3),mass4set(:,2),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(34),mass4set(:,3),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(3),mass4set(:,3),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(34),mass4set(:,4),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(3),mass4set(:,4),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(70),RedSet_4(15),mass4set(:,5),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(15),mass4set(:,6),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(15),mass4set(:,7),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(15),mass4set(:,8),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(107),RedSet_4(35),mass4set(:,5),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(119),RedSet_4(4),mass4set(:,5),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(35),mass4set(:,6),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(153),RedSet_4(4),mass4set(:,6),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(35),mass4set(:,7),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(4),mass4set(:,7),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(35),mass4set(:,8),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(4),mass4set(:,8),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(7),mass4set(:,5),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(7),mass4set(:,6),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(7),mass4set(:,7),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(7),mass4set(:,8),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(36),mass4set(:,9),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(5),mass4set(:,9),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(37),mass4set(:,9),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(6),mass4set(:,9),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(8),mass4set(:,5),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(9),mass4set(:,10),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(8),mass4set(:,6),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(8),mass4set(:,7),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(9),mass4set(:,11),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(8),mass4set(:,8),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(11),mass4set(:,13),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(12),mass4set(:,10),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(13),mass4set(:,5),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(11),mass4set(:,14),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(13),mass4set(:,6),  & 
G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(11),mass4set(:,15),  & 
G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(12),mass4set(:,11),  & 
G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(13),mass4set(:,7),  & 
G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(11),mass4set(:,16),  & 
G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(13),mass4set(:,8),  & 
G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(16),mass4set(:,5),  & 
G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(16),mass4set(:,6),  & 
G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(16),mass4set(:,7),  & 
G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(16),mass4set(:,8),  & 
G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(18),mass4set(:,13),  & 
G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(19),mass4set(:,10),  & 
G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(20),mass4set(:,5),  & 
G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(18),mass4set(:,14),  & 
G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(20),mass4set(:,6),  & 
G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(18),mass4set(:,15),  & 
G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(19),mass4set(:,11),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(20),mass4set(:,7),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(18),mass4set(:,16),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(20),mass4set(:,8),  & 
G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(22),mass4set(:,13),  & 
G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(23),mass4set(:,5),  & 
G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(22),mass4set(:,14),  & 
G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(23),mass4set(:,6),  & 
G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(22),mass4set(:,15),  & 
G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(23),mass4set(:,7),  & 
G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(22),mass4set(:,16),  & 
G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(23),mass4set(:,8),  & 
G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(25),mass4set(:,13),  & 
G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(26),mass4set(:,5),  & 
G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(25),mass4set(:,14),  & 
G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(26),mass4set(:,6),  & 
G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(25),mass4set(:,15),  & 
G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(26),mass4set(:,7),  & 
G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(25),mass4set(:,16),  & 
G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(26),mass4set(:,8),  & 
G0tensor(455),G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(28),mass4set(:,17),  & 
G0tensor(460),G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(30),mass4set(:,17),  & 
G0tensor(465),G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(19),mass4set(:,12),  & 
G0tensor(470),G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474))
  call Hotf_4pt_reduction_last(G1tensor(502),RedSet_4(12),mass4set(:,12),  & 
G0tensor(475),G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479))
  call Hotf_4pt_reduction_last(G1tensor(507),RedSet_4(9),mass4set(:,12),  & 
G0tensor(480),G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(295)])
  call ol_merge_tensors(T0sum(59),[G0tensor(300)])
  call ol_merge_tensors(T0sum(60),[G0tensor(305)])
  call ol_merge_tensors(T0sum(61),[G0tensor(310)])
  call ol_merge_tensors(T0sum(62),[G0tensor(315)])
  call ol_merge_tensors(T0sum(63),[G0tensor(320)])
  call ol_merge_tensors(T0sum(64),[G0tensor(325)])
  call ol_merge_tensors(T0sum(65),[G0tensor(330)])
  call ol_merge_tensors(T0sum(66),[G0tensor(335)])
  call ol_merge_tensors(T0sum(67),[G0tensor(340)])
  call ol_merge_tensors(T0sum(68),[G0tensor(345)])
  call ol_merge_tensors(T0sum(69),[G0tensor(350)])
  call ol_merge_tensors(T0sum(70),[G0tensor(355)])
  call ol_merge_tensors(T0sum(71),[G0tensor(360)])
  call ol_merge_tensors(T0sum(72),[G0tensor(365)])
  call ol_merge_tensors(T0sum(73),[G0tensor(370)])
  call ol_merge_tensors(T0sum(74),[G0tensor(375)])
  call ol_merge_tensors(T0sum(75),[G0tensor(380)])
  call ol_merge_tensors(T0sum(76),[G0tensor(385)])
  call ol_merge_tensors(T0sum(77),[G0tensor(390)])
  call ol_merge_tensors(T0sum(78),[G0tensor(395)])
  call ol_merge_tensors(T0sum(79),[G0tensor(400)])
  call ol_merge_tensors(T0sum(80),[G0tensor(405)])
  call ol_merge_tensors(T0sum(81),[G0tensor(410)])
  call ol_merge_tensors(T0sum(82),[G0tensor(415)])
  call ol_merge_tensors(T0sum(83),[G0tensor(420)])
  call ol_merge_tensors(T0sum(84),[G0tensor(425)])
  call ol_merge_tensors(T0sum(85),[G0tensor(430)])
  call ol_merge_tensors(T0sum(86),[G0tensor(435)])
  call ol_merge_tensors(T0sum(87),[G0tensor(440)])
  call ol_merge_tensors(T0sum(88),[G0tensor(445)])
  call ol_merge_tensors(T0sum(89),[G0tensor(450)])
  call ol_merge_tensors(T0sum(90),[G0tensor(455)])
  call ol_merge_tensors(T0sum(91),[G0tensor(460)])
  call ol_merge_tensors(T0sum(92),[G0tensor(465)])
  call ol_merge_tensors(T0sum(93),[G0tensor(1)])
  call ol_merge_tensors(T0sum(94),[G0tensor(2)])
  call ol_merge_tensors(T0sum(95),[G0tensor(3)])
  call ol_merge_tensors(T0sum(96),[G0tensor(4)])
  call ol_merge_tensors(T0sum(97),[G0tensor(5)])
  call ol_merge_tensors(T0sum(98),[G0tensor(6)])
  call ol_merge_tensors(T0sum(99),[G0tensor(7)])
  call ol_merge_tensors(T0sum(100),[G0tensor(8)])
  call ol_merge_tensors(T0sum(101),[G0tensor(9)])
  call ol_merge_tensors(T0sum(102),[G0tensor(470)])
  call ol_merge_tensors(T0sum(103),[G0tensor(475)])
  call ol_merge_tensors(T0sum(104),[G0tensor(480)])
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,5,10],[nMB,nMH,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(173))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,5,10],[nMB,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(174))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,5,10],[nMT,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,175),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(33),n2h16(175))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,5,10],[nMB,0,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(176))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,5,10],[nMB,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(177))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,5,10],[nMT,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(178))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[18,5,8],[nMH,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(22),ngH,m3h4x8(:,49),heltab2x32(:,:,227))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[18,5,8],[nMZ,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(23),ngX,m3h4x8(:,50),heltab2x32(:,:,228))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[18,5,8],[nMW,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(24),ngPbt,m3h4x8(:,51),heltab2x32(:,:,229))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[18,5,8],[0,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(25),m3h4x8(:,52),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[18,5,8],[nMZ,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(26),ngZd,m3h4x8(:,53),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[18,5,8],[nMW,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,54),heltab2x32(:,:,232))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[24,2,5],[nMB,nMH,nMB],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(28),m3h4x8(:,55),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H8(28),24,nMB,G1H8(23),n2h8(85))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[24,2,5],[nMB,nMZ,nMB],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(29),m3h4x8(:,56),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H8(29),24,nMB,G1H8(24),n2h8(86))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[24,2,5],[nMT,nMW,nMT],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(30),m3h4x8(:,57),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G0H8(30),24,nMT,G1H8(25),n2h8(87))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[24,2,5],[nMB,0,nMB],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(31),m3h4x8(:,58),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H8(31),24,nMB,G1H8(26),n2h8(88))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[24,2,5],[nMB,nMZ,nMB],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(32),m3h4x8(:,59),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H8(32),24,nMB,G1H8(27),n2h8(89))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[24,2,5],[nMT,nMW,nMT],3,2,wf4(:,7),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(33),m3h4x8(:,60),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H8(33),24,nMT,G1H8(28),n2h8(90))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(179))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,180),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(180))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(181))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(182))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(183))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(184))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,185),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(185))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(186))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,7,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(187))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(10),n2h16(188))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,7,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(15),n2h16(189))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(190))
  Gcoeff(:)%j = (c(20)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,7,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(191))
  Gcoeff(:)%j = (c(19)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(192))
  Gcoeff(:)%j = (c(20)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,7,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(17),n2h16(193))
  Gcoeff(:)%j = (c(19)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(194))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,7,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,195),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(19),n2h16(195))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,196),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(20),n2h16(196))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,7,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,197),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(197))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(22),n2h16(198))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,7,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(199))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(24),n2h16(200))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,7,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(25),n2h16(201))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(202))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,2,13],[nMB,nMH,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(203))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,2,13],[nMB,nMZ,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(204))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,2,13],[nMT,nMW,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,265))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(205))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,2,13],[nMB,0,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,206),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(206))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,2,13],[nMB,nMZ,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,267))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(207))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,2,13],[nMT,nMW,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,208),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(208))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[21,2,8],[nMH,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(5),ngH,m3h8x4(:,1),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[21,2,8],[nMZ,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(3),ngX,m3h8x4(:,2),heltab2x32(:,:,270))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[21,2,8],[nMW,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(4),ngPtb,m3h8x4(:,3),heltab2x32(:,:,271))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[21,2,8],[0,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,32),G0H4(1),m3h8x4(:,4),heltab2x32(:,:,272))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[21,2,8],[nMZ,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,32),G0H4(2),ngZd,m3h8x4(:,5),heltab2x32(:,:,273))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[21,2,8],[nMW,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,32),G0H4(6),m3h8x4(:,6),heltab2x32(:,:,274))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,6,9],[nMB,nMH,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,209),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(209))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,6,9],[nMB,nMZ,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,210),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(210))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,6,9],[nMT,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,211),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(211))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,6,9],[nMB,0,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(36),n2h16(212))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,6,9],[nMB,nMZ,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(213))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,6,9],[nMT,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,214),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(214))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[17,6,8],[nMH,nMB,nMB],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,13),G0H8(1),ngH,m3h4x8(:,61),heltab2x32(:,:,281))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[17,6,8],[nMZ,nMB,nMB],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,13),G0H8(2),ngX,m3h4x8(:,62),heltab2x32(:,:,282))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[17,6,8],[nMW,nMT,nMT],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,13),G0H8(3),ngPtb,m3h4x8(:,63),heltab2x32(:,:,283))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[17,6,8],[0,nMB,nMB],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(4),m3h4x8(:,64),heltab2x32(:,:,284))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[17,6,8],[nMZ,nMB,nMB],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,13),G0H8(5),ngZd,m3h4x8(:,65),heltab2x32(:,:,285))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[17,6,8],[nMW,nMT,nMT],3,2,wf4(:,13),wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,13),G0H8(6),m3h4x8(:,66),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[24,1,6],[nMB,nMH,nMB],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(7),m3h4x8(:,67),heltab2x32(:,:,287))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMB,G1H8(29),n2h8(91))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[24,1,6],[nMB,nMZ,nMB],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(8),m3h4x8(:,68),heltab2x32(:,:,288))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMB,G1H8(30),n2h8(92))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[24,1,6],[nMT,nMW,nMT],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(9),m3h4x8(:,69),heltab2x32(:,:,289))
  call Hloop_A_Q(ntryL,G0H8(9),24,nMT,G1H8(31),n2h8(93))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[24,1,6],[nMB,0,nMB],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(10),m3h4x8(:,70),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H8(10),24,nMB,G1H8(32),n2h8(94))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[24,1,6],[nMB,nMZ,nMB],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(11),m3h4x8(:,71),heltab2x32(:,:,291))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(17),n2h8(95))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[24,1,6],[nMT,nMW,nMT],3,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(12),m3h4x8(:,72),heltab2x32(:,:,292))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMT,G1H8(18),n2h8(96))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,215),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(41),n2h16(215))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(216))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,217),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(217))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,218),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(218))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,219),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(219))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(220))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(221))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(48),n2h16(222))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,7,8],[0,0,0],3,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(223))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(50),n2h16(224))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,7,8],[0,0,0],3,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,225),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(51),n2h16(225))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,226),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(52),n2h16(226))
  Gcoeff(:)%j = (c(20)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,7,8],[0,0,0],3,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,227),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(53),n2h16(227))
  Gcoeff(:)%j = (c(19)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,228),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(228))
  Gcoeff(:)%j = (c(20)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,7,8],[0,0,0],3,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,229),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(55),n2h16(229))
  Gcoeff(:)%j = (c(19)*M(3,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,230),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(230))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,231),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(61),n2h16(231))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(58),n2h16(232))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(63),n2h16(233))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(234))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(62),n2h16(235))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(236))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,315))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(65),n2h16(237))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(238))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,1,14],[nMB,nMH,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(67),n2h16(239))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,1,14],[nMB,nMZ,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,240),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(68),n2h16(240))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,1,14],[nMT,nMW,nMT],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,241),heltab2x32(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(69),n2h16(241))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,1,14],[nMB,0,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,242),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(70),n2h16(242))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,1,14],[nMB,nMZ,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,243),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(71),n2h16(243))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,1,14],[nMT,nMW,nMT],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,322))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(244))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[22,1,8],[nMH,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(7),ngH,m3h8x4(:,7),heltab2x32(:,:,323))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[22,1,8],[nMZ,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(8),ngX,m3h8x4(:,8),heltab2x32(:,:,324))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[22,1,8],[nMW,nMT,nMT],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(9),ngPbt,m3h8x4(:,9),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[22,1,8],[0,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,39),G0H4(10),m3h8x4(:,10),heltab2x32(:,:,326))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[22,1,8],[nMZ,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,39),G0H4(11),ngZd,m3h8x4(:,11),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[22,1,8],[nMW,nMT,nMT],3,1,wf8(:,39))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,39),G0H4(12),m3h8x4(:,12),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[18,4,9],[nMB,nMB,nMH],3,2,wf4(:,6),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngH,m3h4x8(:,73),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMB,G1H8(19),n2h8(97))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[18,4,9],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngX,m3h4x8(:,74),heltab2x32(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(14),18,nMB,G1H8(20),n2h8(98))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[18,4,9],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),ngPbt,m3h4x8(:,75),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H8(15),18,nMT,G1H8(21),n2h8(99))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[18,4,9],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngPbt,m3h4x8(:,76),heltab2x32(:,:,332))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[18,4,9],[nMB,nMB,0],3,2,wf4(:,6),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(17),m3h4x8(:,77),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(22),n2h8(100))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[18,4,9],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(18),ngZd,m3h4x8(:,78),heltab2x32(:,:,334))
  call Hloop_A_Q(ntryL,G0H8(18),18,nMB,G1H8(33),n2h8(101))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[18,4,9],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,79),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H8(19),18,nMT,G1H8(34),n2h8(102))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[18,4,9],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(20),m3h4x8(:,80),heltab2x32(:,:,336))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[18,4,9],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(21),ngPbt,m3h4x8(:,81),heltab2x32(:,:,337))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[18,4,9],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(28),m3h4x8(:,82),heltab2x32(:,:,338))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,2,13],[nMB,nMH,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,245),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(245))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,2,13],[nMB,nMZ,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(246))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,2,13],[nMT,nMW,nMT],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,247),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(247))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,2,13],[nMB,0,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(76),n2h16(248))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,2,13],[nMB,nMZ,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,249),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(77),n2h16(249))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,2,13],[nMT,nMW,nMT],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,250),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(250))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[25,2,4],[nMH,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,40),G0H4(13),ngH,m3h8x4(:,13),heltab2x32(:,:,345))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,40),G0H4(14),ngX,m3h8x4(:,14),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,40))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,40),G0H4(15),ngPtb,m3h8x4(:,15),heltab2x32(:,:,347))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(16),ngPtb,m3h8x4(:,16),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(16),25,nMT,G1H4(109),n2h4(137))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[25,2,4],[0,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,40),G0H4(16),m3h8x4(:,17),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,40),G0H4(17),ngZd,m3h8x4(:,18),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,40))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,40),G0H4(18),m3h8x4(:,19),heltab2x32(:,:,351))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,40))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(19),m3h8x4(:,20),heltab2x32(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMT,G1H4(115),n2h4(138))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(19),ngPtb,m3h8x4(:,21),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMT,G1H4(116),n2h4(139))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,40))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(19),m3h8x4(:,22),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMT,G1H4(114),n2h4(140))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[17,4,10],[nMB,nMB,nMH],3,2,wf4(:,13),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(29),ngH,m3h4x8(:,83),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMB,G1H8(35),n2h8(103))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[17,4,10],[nMB,nMB,nMZ],3,2,wf4(:,13),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(30),ngX,m3h4x8(:,84),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H8(30),17,nMB,G1H8(36),n2h8(104))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[17,4,10],[nMT,nMT,nMW],3,2,wf4(:,13),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(31),ngPtb,m3h4x8(:,85),heltab2x32(:,:,357))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMT,G1H8(37),n2h8(105))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[17,4,10],[nMW,nMW,nMT],3,2,wf4(:,13),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,13),G0H8(32),ngPtb,m3h4x8(:,86),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[17,4,10],[nMB,nMB,0],3,2,wf4(:,13),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(33),m3h4x8(:,87),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(38),n2h8(106))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[17,4,10],[nMB,nMB,nMZ],3,2,wf4(:,13),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(7),ngZd,m3h4x8(:,88),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMB,G1H8(39),n2h8(107))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[17,4,10],[nMT,nMT,nMW],3,2,wf4(:,13),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(8),m3h4x8(:,89),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G0H8(8),17,nMT,G1H8(40),n2h8(108))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[17,4,10],[nMW,nMW,nMT],3,2,wf4(:,13),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,13),G0H8(9),ngPtb,m3h4x8(:,90),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[17,4,10],[nMW,nMW,nMT],3,2,wf4(:,13),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,13),G0H8(10),m3h4x8(:,91),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[17,4,10],[nMW,nMW,nMT],3,2,wf4(:,13),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,13),G0H8(11),m3h4x8(:,92),heltab2x32(:,:,364))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,1,14],[nMB,nMH,nMB],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,251),heltab2x32(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(251))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,1,14],[nMB,nMZ,nMB],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,252),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(80),n2h16(252))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,1,14],[nMT,nMW,nMT],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,253),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(253))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,1,14],[nMB,0,nMB],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(82),n2h16(254))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,1,14],[nMB,nMZ,nMB],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,255),heltab2x32(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(83),n2h16(255))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,1,14],[nMT,nMW,nMT],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(84),n2h16(256))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[26,1,4],[nMH,nMB,nMB],3,1,wf8(:,31))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,31),G0H4(19),ngH,m3h8x4(:,23),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,31))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,31),G0H4(20),ngX,m3h8x4(:,24),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,31))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,31),G0H4(21),ngPbt,m3h8x4(:,25),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,31))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,31),G0H4(22),ngPbt,m3h8x4(:,26),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(22),26,nMT,G1H4(63),n2h4(141))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[26,1,4],[0,nMB,nMB],3,1,wf8(:,31))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,31),G0H4(22),m3h8x4(:,27),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,31))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,31),G0H4(23),ngZd,m3h8x4(:,28),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,31))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,31),G0H4(24),m3h8x4(:,29),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,31))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,31),G0H4(25),m3h8x4(:,30),heltab2x32(:,:,378))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMT,G1H4(77),n2h4(142))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,31))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,31),G0H4(25),ngPbt,m3h8x4(:,31),heltab2x32(:,:,379))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMT,G1H4(69),n2h4(143))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,31))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,31),G0H4(25),m3h8x4(:,32),heltab2x32(:,:,380))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMT,G1H4(78),n2h4(144))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[21,2,8],[nMH,nMB,nMB],3,1,wf8(:,51))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,51),G0H4(25),ngH,m3h8x4(:,33),heltab2x32(:,:,381))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[21,2,8],[nMZ,nMB,nMB],3,1,wf8(:,51))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,51),G0H4(26),ngX,m3h8x4(:,34),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[21,2,8],[nMW,nMT,nMT],3,1,wf8(:,51))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,51),G0H4(27),ngPtb,m3h8x4(:,35),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[21,2,8],[0,nMB,nMB],3,1,wf8(:,51))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,51),G0H4(28),m3h8x4(:,36),heltab2x32(:,:,384))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[21,2,8],[nMZ,nMB,nMB],3,1,wf8(:,51))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,51),G0H4(29),ngZd,m3h8x4(:,37),heltab2x32(:,:,385))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[21,2,8],[nMW,nMT,nMT],3,1,wf8(:,51))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,51),G0H4(30),m3h8x4(:,38),heltab2x32(:,:,386))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[25,2,4],[nMH,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(31),ngH,m3h8x4(:,39),heltab2x32(:,:,387))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(32),ngX,m3h8x4(:,40),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(33),ngPtb,m3h8x4(:,41),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(34),ngPtb,m3h8x4(:,42),heltab2x32(:,:,390))
  call Hloop_Q_A(ntryL,G0H4(34),25,nMT,G1H4(75),n2h4(145))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[25,2,4],[0,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,43),G0H4(34),m3h8x4(:,43),heltab2x32(:,:,391))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,43),G0H4(35),ngZd,m3h8x4(:,44),heltab2x32(:,:,392))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,43))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,43),G0H4(36),m3h8x4(:,45),heltab2x32(:,:,393))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(37),m3h8x4(:,46),heltab2x32(:,:,394))
  call Hloop_Q_A(ntryL,G0H4(37),25,nMT,G1H4(79),n2h4(146))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(37),ngPtb,m3h8x4(:,47),heltab2x32(:,:,395))
  call Hloop_Q_A(ntryL,G0H4(37),25,nMT,G1H4(81),n2h4(147))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(37),m3h8x4(:,48),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(37),25,nMT,G1H4(80),n2h4(148))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[22,1,8],[nMH,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,47),G0H4(37),ngH,m3h8x4(:,49),heltab2x32(:,:,397))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[22,1,8],[nMZ,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,47),G0H4(38),ngX,m3h8x4(:,50),heltab2x32(:,:,398))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[22,1,8],[nMW,nMT,nMT],3,1,wf8(:,47))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,47),G0H4(39),ngPbt,m3h8x4(:,51),heltab2x32(:,:,399))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[22,1,8],[0,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,47),G0H4(40),m3h8x4(:,52),heltab2x32(:,:,400))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[22,1,8],[nMZ,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,47),G0H4(41),ngZd,m3h8x4(:,53),heltab2x32(:,:,401))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[22,1,8],[nMW,nMT,nMT],3,1,wf8(:,47))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,47),G0H4(42),m3h8x4(:,54),heltab2x32(:,:,402))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[26,1,4],[nMH,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(43),ngH,m3h8x4(:,55),heltab2x32(:,:,403))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(44),ngX,m3h8x4(:,56),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(45),ngPbt,m3h8x4(:,57),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(46),ngPbt,m3h8x4(:,58),heltab2x32(:,:,406))
  call Hloop_A_Q(ntryL,G0H4(46),26,nMT,G1H4(87),n2h4(149))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[26,1,4],[0,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,34),G0H4(46),m3h8x4(:,59),heltab2x32(:,:,407))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,34),G0H4(47),ngZd,m3h8x4(:,60),heltab2x32(:,:,408))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,34),G0H4(48),m3h8x4(:,61),heltab2x32(:,:,409))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(49),m3h8x4(:,62),heltab2x32(:,:,410))
  call Hloop_A_Q(ntryL,G0H4(49),26,nMT,G1H4(83),n2h4(150))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(49),ngPbt,m3h8x4(:,63),heltab2x32(:,:,411))
  call Hloop_A_Q(ntryL,G0H4(49),26,nMT,G1H4(93),n2h4(151))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(49),m3h8x4(:,64),heltab2x32(:,:,412))
  call Hloop_A_Q(ntryL,G0H4(49),26,nMT,G1H4(84),n2h4(152))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[25,2,4],[nMH,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,45),G0H4(49),ngH,m3h8x4(:,65),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,45),G0H4(50),ngX,m3h8x4(:,66),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,45))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,45),G0H4(51),ngPtb,m3h8x4(:,67),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,45),G0H4(52),ngPtb,m3h8x4(:,68),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G0H4(52),25,nMT,G1H4(119),n2h4(153))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[25,2,4],[0,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,45),G0H4(52),m3h8x4(:,69),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[25,2,4],[nMZ,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,45),G0H4(53),ngZd,m3h8x4(:,70),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[25,2,4],[nMW,nMT,nMT],3,1,wf8(:,45))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,45),G0H4(54),m3h8x4(:,71),heltab2x32(:,:,419))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,45))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,45),G0H4(55),m3h8x4(:,72),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(55),25,nMT,G1H4(125),n2h4(154))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,45),G0H4(55),ngPtb,m3h8x4(:,73),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(55),25,nMT,G1H4(126),n2h4(155))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[25,2,4],[nMT,nMW,nMW],3,1,wf8(:,45))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,45),G0H4(55),m3h8x4(:,74),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(55),25,nMT,G1H4(122),n2h4(156))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[26,1,4],[nMH,nMB,nMB],3,1,wf8(:,37))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,37),G0H4(55),ngH,m3h8x4(:,75),heltab2x32(:,:,423))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,37))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,37),G0H4(56),ngX,m3h8x4(:,76),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,37))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,37),G0H4(57),ngPbt,m3h8x4(:,77),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(58),ngPbt,m3h8x4(:,78),heltab2x32(:,:,426))
  call Hloop_A_Q(ntryL,G0H4(58),26,nMT,G1H4(89),n2h4(157))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[26,1,4],[0,nMB,nMB],3,1,wf8(:,37))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,37),G0H4(58),m3h8x4(:,79),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[26,1,4],[nMZ,nMB,nMB],3,1,wf8(:,37))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,37),G0H4(59),ngZd,m3h8x4(:,80),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[26,1,4],[nMW,nMT,nMT],3,1,wf8(:,37))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,37),G0H4(60),m3h8x4(:,81),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(61),m3h8x4(:,82),heltab2x32(:,:,430))
  call Hloop_A_Q(ntryL,G0H4(61),26,nMT,G1H4(95),n2h4(158))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(61),ngPbt,m3h8x4(:,83),heltab2x32(:,:,431))
  call Hloop_A_Q(ntryL,G0H4(61),26,nMT,G1H4(96),n2h4(159))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[26,1,4],[nMT,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,37),G0H4(61),m3h8x4(:,84),heltab2x32(:,:,432))
  call Hloop_A_Q(ntryL,G0H4(61),26,nMT,G1H4(92),n2h4(160))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(25),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(26),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(27),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(28),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(30),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(53),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(37),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(38),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(39),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(40),[G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(41),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(42),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(49),[G0H4(31),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(50),[G0H4(32),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(51),[G0H4(33),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(75),G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(34),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(53),[G0H4(35),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(54),[G0H4(36),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(79),G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(81),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(80),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(55),[G0H4(43),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(44),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(57),[G0H4(45),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(87),G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(58),[G0H4(46),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(59),[G0H4(47),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(48),G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(83),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(93),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(84),G1H4(78)])
  call Hloop_QV_A(ntryL,G1H4(155),ex3(:),G1H2(166),m3h2x2(:,249),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(166),23,nMB,G2H2(234),n2h2(313))
  call Hloop_QV_A(ntryL,G1H4(162),ex3(:),G1H2(183),m3h2x2(:,250),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(183),23,nMT,G2H2(216),n2h2(314))
  call Hloop_QV_A(ntryL,G1H4(169),ex4(:),G1H2(188),m3h2x2(:,251),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(188),27,nMB,G2H2(204),n2h2(315))
  call Hloop_QV_A(ntryL,G1H4(176),ex4(:),G1H2(199),m3h2x2(:,252),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(199),27,nMT,G2H2(19),n2h2(316))
  call Hloop_AV_Q(ntryL,G1H4(185),ex3(:),G1H2(200),m3h2x2(:,253),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(200),23,nMB,G2H2(15),n2h2(317))
  call Hloop_AV_Q(ntryL,G1H4(192),ex3(:),G1H2(205),m3h2x2(:,254),heltab2x4(:,:,302))
  call Hloop_A_Q(ntryL,G1H2(205),23,nMT,G2H2(7),n2h2(318))
  call Hloop_AV_Q(ntryL,G1H4(7),ex4(:),G1H2(216),m3h2x2(:,255),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(216),27,nMB,G2H2(3),n2h2(319))
  call Hloop_AV_Q(ntryL,G1H4(14),ex4(:),G1H2(221),m3h2x2(:,256),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G1H2(221),27,nMT,G2H2(228),n2h2(320))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(222),m3h2x2(:,257),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(222),27,0,G2H2(210),n2h2(321))
  call Hloop_AV_Q(ntryL,G1H4(30),ex4(:),G1H2(233),m3h2x2(:,258),heltab2x4(:,:,306))
  call Hloop_A_Q(ntryL,G1H2(233),27,0,G2H2(198),n2h2(322))
  call Hloop_AV_Q(ntryL,G1H4(37),ex3(:),G1H2(238),m3h2x2(:,259),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(238),23,0,G2H2(23),n2h2(323))
  call Hloop_QV_A(ntryL,G1H4(44),ex3(:),G1H2(243),m3h2x2(:,260),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(243),23,0,G2H2(11),n2h2(324))
  call Hloop_QS_A(ntryL,G1H8(3),wf4(:,36),G1H2(254),ngH,m3h4x2(:,113),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(254),23,nMT,G2H2(133),n2h2(325))
  call Hloop_AS_Q(ntryL,G1H8(8),wf4(:,36),G1H2(255),ngH,m3h4x2(:,114),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(255),23,nMT,G2H2(27),n2h2(326))
  call Hloop_QS_A(ntryL,G1H8(13),wf4(:,36),G1H2(260),ngH,m3h4x2(:,115),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(260),23,nMB,G2H2(134),n2h2(327))
  call Hloop_AS_Q(ntryL,G1H8(50),wf4(:,36),G1H2(271),ngH,m3h4x2(:,116),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(271),23,nMB,G2H2(137),n2h2(328))
  call Hloop_QS_A(ntryL,G1H8(55),wf4(:,37),G1H2(276),ngX,m3h4x2(:,117),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(276),23,nMT,G2H2(84),n2h2(329))
  call Hloop_AS_Q(ntryL,G1H8(60),wf4(:,37),G1H2(277),ngX,m3h4x2(:,118),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(277),23,nMT,G2H2(31),n2h2(330))
  call Hloop_QS_A(ntryL,G1H8(65),wf4(:,37),G1H2(17),ngX,m3h4x2(:,119),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMB,G2H2(135),n2h2(331))
  call Hloop_AS_Q(ntryL,G1H8(70),wf4(:,37),G1H2(28),ngX,m3h4x2(:,120),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMB,G2H2(138),n2h2(332))
  call Hloop_QV_A(ntryL,G1H8(75),wf4(:,14),G1H2(50),m3h4x2(:,121),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(50),23,0,G2H2(85),n2h2(333))
  call Hloop_QV_A(ntryL,G1H8(80),wf4(:,14),G1H2(94),m3h4x2(:,122),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(94),23,nMT,G2H2(119),n2h2(334))
  call Hloop_AV_Q(ntryL,G1H8(85),wf4(:,14),G1H2(105),m3h4x2(:,123),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(105),23,0,G2H2(115),n2h2(335))
  call Hloop_AV_Q(ntryL,G1H8(90),wf4(:,14),G1H2(116),m3h4x2(:,124),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(116),23,nMT,G2H2(35),n2h2(336))
  call Hloop_QV_A(ntryL,G1H8(95),wf4(:,14),G1H2(160),m3h4x2(:,125),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(160),23,nMB,G2H2(136),n2h2(337))
  call Hloop_AV_Q(ntryL,G1H8(100),wf4(:,14),G1H2(182),m3h4x2(:,126),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(182),23,nMB,G2H2(39),n2h2(338))
  call Hloop_QZ_A(ntryL,G1H8(105),wf4(:,15),G1H2(193),ngZu,m3h4x2(:,127),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(193),23,0,G2H2(231),n2h2(339))
  call Hloop_QZ_A(ntryL,G1H8(110),wf4(:,15),G1H2(237),ngZu,m3h4x2(:,128),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(237),23,nMT,G2H2(213),n2h2(340))
  call Hloop_AZ_Q(ntryL,G1H8(115),wf4(:,15),G1H2(248),ngZu,m3h4x2(:,129),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(248),23,0,G2H2(201),n2h2(341))
  call Hloop_AZ_Q(ntryL,G1H8(120),wf4(:,15),G1H2(270),ngZu,m3h4x2(:,130),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(270),23,nMT,G2H2(59),n2h2(342))
  call Hloop_QZ_A(ntryL,G1H8(125),wf4(:,15),G1H2(7),ngZd,m3h4x2(:,131),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(7),23,0,G2H2(55),n2h2(343))
  call Hloop_QZ_A(ntryL,G1H8(130),wf4(:,15),G1H2(8),ngZd,m3h4x2(:,132),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(47),n2h2(344))
  call Hloop_AZ_Q(ntryL,G1H8(135),wf4(:,15),G1H2(12),ngZd,m3h4x2(:,133),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G1H2(12),23,0,G2H2(43),n2h2(345))
  call Hloop_AZ_Q(ntryL,G1H8(140),wf4(:,15),G1H2(23),ngZd,m3h4x2(:,134),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G1H2(23),23,nMB,G2H2(222),n2h2(346))
  call Hloop_AQ_S(ntryL,G1H16(9),wf4(:,3),G1H4(97),ngH,m3h4x4(:,57),heltab2x16(:,:,167))
  call Hloop_AQ_S(ntryL,G1H16(11),wf4(:,3),G1H4(103),ngX,m3h4x4(:,58),heltab2x16(:,:,168))
  call Hloop_AQ_S(ntryL,G1H16(33),wf4(:,3),G1H4(104),ngPtb,m3h4x4(:,59),heltab2x16(:,:,169))
  call Hloop_AQ_V(ntryL,G1H16(35),wf4(:,3),G1H4(102),m3h4x4(:,60),heltab2x16(:,:,170))
  call Hloop_AQ_Z(ntryL,G1H16(57),wf4(:,3),G1H4(107),ngZd,m3h4x4(:,61),heltab2x16(:,:,171))
  call Hloop_AQ_W(ntryL,G1H16(59),wf4(:,3),G1H4(108),m3h4x4(:,62),heltab2x16(:,:,172))
  call Hloop_SQ_A(ntryL,G0H8(22),wf4(:,3),G0H2(1),ngH,m3h4x2(:,135),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(29),n2h2(347))
  call Hloop_SQ_A(ntryL,G0H8(23),wf4(:,3),G0H2(1),ngX,m3h4x2(:,136),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(30),n2h2(348))
  call Hloop_SQ_A(ntryL,G0H8(24),wf4(:,3),G0H2(1),ngPtb,m3h4x2(:,137),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(41),n2h2(349))
  call Hloop_VQ_A(ntryL,G0H8(25),wf4(:,3),G0H2(1),m3h4x2(:,138),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(45),n2h2(350))
  call Hloop_ZQ_A(ntryL,G0H8(26),wf4(:,3),G0H2(1),ngZd,m3h4x2(:,139),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(51),n2h2(351))
  call Hloop_WQ_A(ntryL,G0H8(27),wf4(:,3),G0H2(1),m3h4x2(:,140),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(62),n2h2(352))
  call Hloop_QA_S(ntryL,G1H8(23),ex2(:),G1H4(85),ngH,m3h2x4(:,135),heltab2x8(:,:,275))
  call Hloop_QA_S(ntryL,G1H8(24),ex2(:),G1H4(86),ngX,m3h2x4(:,136),heltab2x8(:,:,276))
  call Hloop_QA_S(ntryL,G1H8(25),ex2(:),G1H4(127),ngPbt,m3h2x4(:,137),heltab2x8(:,:,277))
  call Hloop_QA_V(ntryL,G1H8(26),ex2(:),G1H4(128),m3h2x4(:,138),heltab2x8(:,:,278))
  call Hloop_QA_Z(ntryL,G1H8(27),ex2(:),G1H4(131),ngZd,m3h2x4(:,139),heltab2x8(:,:,279))
  call Hloop_QA_W(ntryL,G1H8(28),ex2(:),G1H4(132),m3h2x4(:,140),heltab2x8(:,:,280))
  call Hloop_AS_Q(ntryL,G1H16(1),wf8(:,12),G1H2(63),ngH,m3h8x2(:,1),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(63),23,nMT,G2H2(207),n2h2(353))
  call Hloop_QS_A(ntryL,G1H16(2),wf8(:,12),G1H2(67),ngH,m3h8x2(:,2),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMT,G2H2(195),n2h2(354))
  call Hloop_AS_Q(ntryL,G1H16(3),wf8(:,12),G1H2(78),ngH,m3h8x2(:,3),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(78),23,nMB,G2H2(63),n2h2(355))
  call Hloop_QS_A(ntryL,G1H16(4),wf8(:,12),G1H2(84),ngH,m3h8x2(:,4),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(84),23,nMB,G2H2(51),n2h2(356))
  call Hloop_AS_Q(ntryL,G1H16(5),wf8(:,52),G1H2(85),ngX,m3h8x2(:,5),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(85),23,nMT,G2H2(21),n2h2(357))
  call Hloop_QS_A(ntryL,G1H16(6),wf8(:,52),G1H2(96),ngX,m3h8x2(:,6),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(96),23,nMT,G2H2(67),n2h2(358))
  call Hloop_AS_Q(ntryL,G1H16(7),wf8(:,52),G1H2(100),ngX,m3h8x2(:,7),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(100),23,nMB,G2H2(13),n2h2(359))
  call Hloop_QS_A(ntryL,G1H16(8),wf8(:,52),G1H2(106),ngX,m3h8x2(:,8),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMB,G2H2(33),n2h2(360))
  call Hloop_AV_Q(ntryL,G1H16(14),wf8(:,3),G1H2(117),m3h8x2(:,9),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(117),23,0,G2H2(108),n2h2(361))
  call Hloop_AV_Q(ntryL,G1H16(10),wf8(:,3),G1H2(118),m3h8x2(:,10),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(118),23,nMT,G2H2(71),n2h2(362))
  call Hloop_QV_A(ntryL,G1H16(17),wf8(:,3),G1H2(122),m3h8x2(:,11),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(122),23,0,G2H2(25),n2h2(363))
  call Hloop_QV_A(ntryL,G1H16(12),wf8(:,3),G1H2(133),m3h8x2(:,12),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMT,G2H2(37),n2h2(364))
  call Hloop_AV_Q(ntryL,G1H16(16),wf8(:,3),G1H2(139),m3h8x2(:,13),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(139),23,nMB,G2H2(109),n2h2(365))
  call Hloop_QV_A(ntryL,G1H16(18),wf8(:,3),G1H2(140),m3h8x2(:,14),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(140),23,nMB,G2H2(75),n2h2(366))
  call Hloop_AZ_Q(ntryL,G1H16(19),wf8(:,13),G1H2(156),ngZu,m3h8x2(:,15),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(156),23,0,G2H2(29),n2h2(367))
  call Hloop_AZ_Q(ntryL,G1H16(20),wf8(:,13),G1H2(161),ngZu,m3h8x2(:,16),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(161),23,nMT,G2H2(79),n2h2(368))
  call Hloop_QZ_A(ntryL,G1H16(21),wf8(:,13),G1H2(167),ngZu,m3h8x2(:,17),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(167),23,0,G2H2(139),n2h2(369))
  call Hloop_QZ_A(ntryL,G1H16(22),wf8(:,13),G1H2(38),ngZu,m3h8x2(:,18),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMT,G2H2(83),n2h2(370))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf8(:,13),G1H2(16),ngZd,m3h8x2(:,19),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(16),23,0,G2H2(140),n2h2(371))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf8(:,13),G1H2(5),ngZd,m3h8x2(:,20),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMB,G2H2(143),n2h2(372))
  call Hloop_QZ_A(ntryL,G1H16(25),wf8(:,13),G1H2(60),ngZd,m3h8x2(:,21),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(60),23,0,G2H2(96),n2h2(373))
  call Hloop_QZ_A(ntryL,G1H16(26),wf8(:,13),G1H2(269),ngZd,m3h8x2(:,22),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(269),23,nMB,G2H2(87),n2h2(374))
  call Hloop_QA_S(ntryL,G1H16(27),ex2(:),G1H8(41),ngH,m3h2x8(:,111),heltab2x16(:,:,195))
  call Hloop_QA_S(ntryL,G1H16(28),ex2(:),G1H8(42),ngX,m3h2x8(:,112),heltab2x16(:,:,196))
  call Hloop_QA_S(ntryL,G1H16(29),ex2(:),G1H8(43),ngPbt,m3h2x8(:,113),heltab2x16(:,:,197))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(44),m3h2x8(:,114),heltab2x16(:,:,198))
  call Hloop_QA_Z(ntryL,G1H16(31),ex2(:),G1H8(45),ngZd,m3h2x8(:,115),heltab2x16(:,:,199))
  call Hloop_QA_W(ntryL,G1H16(32),ex2(:),G1H8(46),m3h2x8(:,116),heltab2x16(:,:,200))
  call Hloop_SA_Q(ntryL,G0H4(25),ex2(:),G0H2(1),ngH,m3h2x2(:,261),heltab2x4(:,:,309))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(71),n2h2(375))
  call Hloop_SA_Q(ntryL,G0H4(26),ex2(:),G0H2(1),ngX,m3h2x2(:,262),heltab2x4(:,:,310))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(104),n2h2(376))
  call Hloop_SA_Q(ntryL,G0H4(27),ex2(:),G0H2(1),ngPbt,m3h2x2(:,263),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(93),n2h2(377))
  call Hloop_VA_Q(ntryL,G0H4(28),ex2(:),G0H2(1),m3h2x2(:,264),heltab2x4(:,:,312))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(115),n2h2(378))
  call Hloop_ZA_Q(ntryL,G0H4(29),ex2(:),G0H2(1),ngZd,m3h2x2(:,265),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(102),n2h2(379))
  call Hloop_WA_Q(ntryL,G0H4(30),ex2(:),G0H2(1),m3h2x2(:,266),heltab2x4(:,:,314))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(148),n2h2(380))
  call Hloop_QA_S(ntryL,G1H16(37),wf4(:,11),G1H4(133),ngH,m3h4x4(:,63),heltab2x16(:,:,201))
  call Hloop_QA_S(ntryL,G1H16(34),wf4(:,11),G1H4(134),ngX,m3h4x4(:,64),heltab2x16(:,:,202))
  call Hloop_QA_S(ntryL,G1H16(39),wf4(:,11),G1H4(137),ngPbt,m3h4x4(:,65),heltab2x16(:,:,203))
  call Hloop_QA_V(ntryL,G1H16(36),wf4(:,11),G1H4(138),m3h4x4(:,66),heltab2x16(:,:,204))
  call Hloop_QA_Z(ntryL,G1H16(38),wf4(:,11),G1H4(139),ngZd,m3h4x4(:,67),heltab2x16(:,:,205))
  call Hloop_QA_W(ntryL,G1H16(40),wf4(:,11),G1H4(140),m3h4x4(:,68),heltab2x16(:,:,206))
  call Hloop_SA_Q(ntryL,G0H8(1),wf4(:,11),G0H2(1),ngH,m3h4x2(:,141),heltab2x8(:,:,281))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(113),n2h2(381))
  call Hloop_SA_Q(ntryL,G0H8(2),wf4(:,11),G0H2(1),ngX,m3h4x2(:,142),heltab2x8(:,:,282))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(170),n2h2(382))
  call Hloop_SA_Q(ntryL,G0H8(3),wf4(:,11),G0H2(1),ngPbt,m3h4x2(:,143),heltab2x8(:,:,283))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(181),n2h2(383))
  call Hloop_VA_Q(ntryL,G0H8(4),wf4(:,11),G0H2(1),m3h4x2(:,144),heltab2x8(:,:,284))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(192),n2h2(384))
  call Hloop_ZA_Q(ntryL,G0H8(5),wf4(:,11),G0H2(1),ngZd,m3h4x2(:,145),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(214),n2h2(385))
  call Hloop_WA_Q(ntryL,G0H8(6),wf4(:,11),G0H2(1),m3h4x2(:,146),heltab2x8(:,:,286))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(3),n2h2(386))
  call Hloop_AQ_S(ntryL,G1H8(29),ex1(:),G1H4(143),ngH,m3h2x4(:,141),heltab2x8(:,:,287))
  call Hloop_AQ_S(ntryL,G1H8(30),ex1(:),G1H4(144),ngX,m3h2x4(:,142),heltab2x8(:,:,288))
  call Hloop_AQ_S(ntryL,G1H8(31),ex1(:),G1H4(145),ngPtb,m3h2x4(:,143),heltab2x8(:,:,289))
  call Hloop_AQ_V(ntryL,G1H8(32),ex1(:),G1H4(146),m3h2x4(:,144),heltab2x8(:,:,290))
  call Hloop_AQ_Z(ntryL,G1H8(17),ex1(:),G1H4(149),ngZd,m3h2x4(:,145),heltab2x8(:,:,291))
  call Hloop_AQ_W(ntryL,G1H8(18),ex1(:),G1H4(150),m3h2x4(:,146),heltab2x8(:,:,292))
  call Hloop_AS_Q(ntryL,G1H16(41),wf8(:,16),G1H2(225),ngH,m3h8x2(:,23),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(225),23,nMT,G2H2(141),n2h2(387))
  call Hloop_QS_A(ntryL,G1H16(42),wf8(:,16),G1H2(25),ngH,m3h8x2(:,24),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMT,G2H2(144),n2h2(388))
  call Hloop_AS_Q(ntryL,G1H16(43),wf8(:,16),G1H2(247),ngH,m3h8x2(:,25),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(247),23,nMB,G2H2(97),n2h2(389))
  call Hloop_QS_A(ntryL,G1H16(44),wf8(:,16),G1H2(36),ngH,m3h8x2(:,26),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(127),n2h2(390))
  call Hloop_AS_Q(ntryL,G1H16(45),wf8(:,53),G1H2(150),ngX,m3h8x2(:,27),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(150),23,nMT,G2H2(123),n2h2(391))
  call Hloop_QS_A(ntryL,G1H16(46),wf8(:,53),G1H2(4),ngX,m3h8x2(:,28),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(91),n2h2(392))
  call Hloop_AS_Q(ntryL,G1H16(47),wf8(:,53),G1H2(44),ngX,m3h8x2(:,29),heltab2x16(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMB,G2H2(142),n2h2(393))
  call Hloop_QS_A(ntryL,G1H16(48),wf8(:,53),G1H2(15),ngX,m3h8x2(:,30),heltab2x16(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(95),n2h2(394))
  call Hloop_AV_Q(ntryL,G1H16(53),wf8(:,6),G1H2(279),m3h8x2(:,31),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(279),23,0,G2H2(5),n2h2(395))
  call Hloop_AV_Q(ntryL,G1H16(50),wf8(:,6),G1H2(26),m3h8x2(:,32),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(26),23,nMT,G2H2(99),n2h2(396))
  call Hloop_QV_A(ntryL,G1H16(55),wf8(:,6),G1H2(37),m3h8x2(:,33),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(37),23,0,G2H2(9),n2h2(397))
  call Hloop_QV_A(ntryL,G1H16(52),wf8(:,6),G1H2(47),m3h8x2(:,34),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(47),23,nMT,G2H2(113),n2h2(398))
  call Hloop_AV_Q(ntryL,G1H16(54),wf8(:,6),G1H2(81),m3h8x2(:,35),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(128),n2h2(399))
  call Hloop_QV_A(ntryL,G1H16(56),wf8(:,6),G1H2(87),m3h8x2(:,36),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMB,G2H2(103),n2h2(400))
  call Hloop_AZ_Q(ntryL,G1H16(61),wf8(:,17),G1H2(65),ngZu,m3h8x2(:,37),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(65),23,0,G2H2(45),n2h2(401))
  call Hloop_AZ_Q(ntryL,G1H16(58),wf8(:,17),G1H2(54),ngZu,m3h8x2(:,38),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(54),23,nMT,G2H2(121),n2h2(402))
  call Hloop_QZ_A(ntryL,G1H16(63),wf8(:,17),G1H2(70),ngZu,m3h8x2(:,39),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(70),23,0,G2H2(129),n2h2(403))
  call Hloop_QZ_A(ntryL,G1H16(60),wf8(:,17),G1H2(76),ngZu,m3h8x2(:,40),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(76),23,nMT,G2H2(107),n2h2(404))
  call Hloop_AZ_Q(ntryL,G1H16(62),wf8(:,17),G1H2(77),ngZd,m3h8x2(:,41),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(77),23,0,G2H2(49),n2h2(405))
  call Hloop_AZ_Q(ntryL,G1H16(64),wf8(:,17),G1H2(132),ngZd,m3h8x2(:,42),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(132),23,nMB,G2H2(111),n2h2(406))
  call Hloop_QZ_A(ntryL,G1H16(65),wf8(:,17),G1H2(110),ngZd,m3h8x2(:,43),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(110),23,0,G2H2(145),n2h2(407))
  call Hloop_QZ_A(ntryL,G1H16(66),wf8(:,17),G1H2(99),ngZd,m3h8x2(:,44),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(99),23,nMB,G2H2(146),n2h2(408))
  call Hloop_AQ_S(ntryL,G1H16(67),ex1(:),G1H8(47),ngH,m3h2x8(:,117),heltab2x16(:,:,229))
  call Hloop_AQ_S(ntryL,G1H16(68),ex1(:),G1H8(48),ngX,m3h2x8(:,118),heltab2x16(:,:,230))
  call Hloop_AQ_S(ntryL,G1H16(69),ex1(:),G1H8(1),ngPtb,m3h2x8(:,119),heltab2x16(:,:,231))
  call Hloop_AQ_V(ntryL,G1H16(70),ex1(:),G1H8(2),m3h2x8(:,120),heltab2x16(:,:,232))
  call Hloop_AQ_Z(ntryL,G1H16(71),ex1(:),G1H8(4),ngZd,m3h2x8(:,121),heltab2x16(:,:,233))
  call Hloop_AQ_W(ntryL,G1H16(72),ex1(:),G1H8(5),m3h2x8(:,122),heltab2x16(:,:,234))
  call Hloop_SQ_A(ntryL,G0H4(37),ex1(:),G0H2(1),ngH,m3h2x2(:,267),heltab2x4(:,:,315))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(114),n2h2(409))
  call Hloop_SQ_A(ntryL,G0H4(38),ex1(:),G0H2(1),ngX,m3h2x2(:,268),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(120),n2h2(410))
  call Hloop_SQ_A(ntryL,G0H4(39),ex1(:),G0H2(1),ngPtb,m3h2x2(:,269),heltab2x4(:,:,317))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(121),n2h2(411))
  call Hloop_VQ_A(ntryL,G0H4(40),ex1(:),G0H2(1),m3h2x2(:,270),heltab2x4(:,:,318))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(169),n2h2(412))
  call Hloop_ZQ_A(ntryL,G0H4(41),ex1(:),G0H2(1),ngZd,m3h2x2(:,271),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(147),n2h2(413))
  call Hloop_WQ_A(ntryL,G0H4(42),ex1(:),G0H2(1),m3h2x2(:,272),heltab2x4(:,:,320))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(136),n2h2(414))
  call Hloop_AV_Q(ntryL,G1H8(19),ex3(:),G1H4(151),m3h2x4(:,147),heltab2x8(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(151),22,nMB,G2H4(38),n2h4(161))
  call Hloop_AV_Q(ntryL,G1H8(20),ex3(:),G1H4(152),m3h2x4(:,148),heltab2x8(:,:,294))
  call Hloop_A_Q(ntryL,G1H4(152),22,nMB,G2H4(35),n2h4(162))
  call Hloop_AV_Q(ntryL,G1H8(21),ex3(:),G1H4(156),m3h2x4(:,149),heltab2x8(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(156),22,nMT,G2H4(32),n2h4(163))
  call Hloop_SV_T(ntryL,G0H8(16),18,ex3(:),4,G1H4(157),m3h2x4(:,150),heltab2x8(:,:,296))
  call Hloop_AV_Q(ntryL,G1H8(22),ex3(:),G1H4(158),m3h2x4(:,151),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(158),22,nMB,G2H4(8),n2h4(164))
  call Hloop_AV_Q(ntryL,G1H8(33),ex3(:),G1H4(161),m3h2x4(:,152),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(161),22,nMB,G2H4(1),n2h4(165))
  call Hloop_AV_Q(ntryL,G1H8(34),ex3(:),G1H4(163),m3h2x4(:,153),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(163),22,nMT,G2H4(20),n2h4(166))
  call Hloop_VV_S(ntryL,G0H8(20),ex3(:),G0H4(61),m3h2x4(:,154),heltab2x8(:,:,300))
  call Hloop_SV_V(ntryL,G0H8(21),ex3(:),G0H4(5),m3h2x4(:,155),heltab2x8(:,:,301))
  call Hloop_UW_V(ntryL,G0H8(28),18,ex3(:),4,G1H4(164),m3h2x4(:,156),heltab2x8(:,:,302))
  call Hloop_QA_S(ntryL,G1H16(73),ex2(:),G1H8(6),ngH,m3h2x8(:,123),heltab2x16(:,:,235))
  call Hloop_QA_S(ntryL,G1H16(74),ex2(:),G1H8(7),ngX,m3h2x8(:,124),heltab2x16(:,:,236))
  call Hloop_QA_S(ntryL,G1H16(75),ex2(:),G1H8(9),ngPbt,m3h2x8(:,125),heltab2x16(:,:,237))
  call Hloop_QA_V(ntryL,G1H16(76),ex2(:),G1H8(10),m3h2x8(:,126),heltab2x16(:,:,238))
  call Hloop_QA_Z(ntryL,G1H16(77),ex2(:),G1H8(11),ngZd,m3h2x8(:,127),heltab2x16(:,:,239))
  call Hloop_QA_W(ntryL,G1H16(78),ex2(:),G1H8(12),m3h2x8(:,128),heltab2x16(:,:,240))
  call Hloop_SA_Q(ntryL,G0H4(49),ex2(:),G0H2(1),ngH,m3h2x2(:,273),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(142),n2h2(415))
  call Hloop_SA_Q(ntryL,G0H4(50),ex2(:),G0H2(1),ngX,m3h2x2(:,274),heltab2x4(:,:,322))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(146),n2h2(416))
  call Hloop_SA_Q(ntryL,G0H4(51),ex2(:),G0H2(1),ngPbt,m3h2x2(:,275),heltab2x4(:,:,323))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(157),n2h2(417))
  call Hloop_QA_S(ntryL,G1H4(119),ex2(:),G1H2(168),ngPbt,m3h2x2(:,276),heltab2x4(:,:,324))
  call Hloop_VA_Q(ntryL,G0H4(52),ex2(:),G0H2(1),m3h2x2(:,277),heltab2x4(:,:,325))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(179),n2h2(418))
  call Hloop_ZA_Q(ntryL,G0H4(53),ex2(:),G0H2(1),ngZd,m3h2x2(:,278),heltab2x4(:,:,326))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(213),n2h2(419))
  call Hloop_WA_Q(ntryL,G0H4(54),ex2(:),G0H2(1),m3h2x2(:,279),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(219),n2h2(420))
  call Hloop_QA_S(ntryL,G1H4(125),ex2(:),G1H2(197),ngPbt,m3h2x2(:,280),heltab2x4(:,:,328))
  call Hloop_QA_W(ntryL,G1H4(126),ex2(:),G1H2(186),m3h2x2(:,281),heltab2x4(:,:,329))
  call Hloop_QA_W(ntryL,G1H4(122),ex2(:),G1H2(202),m3h2x2(:,282),heltab2x4(:,:,330))
  call Hloop_QV_A(ntryL,G1H8(35),ex3(:),G1H4(167),m3h2x4(:,157),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(167),21,nMB,G2H4(22),n2h4(167))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(168),m3h2x4(:,158),heltab2x8(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(168),21,nMB,G2H4(16),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(37),ex3(:),G1H4(170),m3h2x4(:,159),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(170),21,nMT,G2H4(10),n2h4(169))
  call Hloop_TV_S(ntryL,G0H8(32),17,ex3(:),4,G1H4(173),m3h2x4(:,160),heltab2x8(:,:,306))
  call Hloop_QV_A(ntryL,G1H8(38),ex3(:),G1H4(174),m3h2x4(:,161),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(174),21,nMB,G2H4(23),n2h4(170))
  call Hloop_QV_A(ntryL,G1H8(39),ex3(:),G1H4(175),m3h2x4(:,162),heltab2x8(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(175),21,nMB,G2H4(14),n2h4(171))
  call Hloop_QV_A(ntryL,G1H8(40),ex3(:),G1H4(179),m3h2x4(:,163),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(179),21,nMT,G2H4(11),n2h4(172))
  call Hloop_SV_V(ntryL,G0H8(9),ex3(:),G0H4(3),m3h2x4(:,164),heltab2x8(:,:,310))
  call Hloop_VV_S(ntryL,G0H8(10),ex3(:),G0H4(4),m3h2x4(:,165),heltab2x8(:,:,311))
  call Hloop_UV_W(ntryL,G0H8(11),17,ex3(:),4,G1H4(180),m3h2x4(:,166),heltab2x8(:,:,312))
  call Hloop_AQ_S(ntryL,G1H16(79),ex1(:),G1H8(14),ngH,m3h2x8(:,129),heltab2x16(:,:,241))
  call Hloop_AQ_S(ntryL,G1H16(80),ex1(:),G1H8(15),ngX,m3h2x8(:,130),heltab2x16(:,:,242))
  call Hloop_AQ_S(ntryL,G1H16(81),ex1(:),G1H8(16),ngPtb,m3h2x8(:,131),heltab2x16(:,:,243))
  call Hloop_AQ_V(ntryL,G1H16(82),ex1(:),G1H8(49),m3h2x8(:,132),heltab2x16(:,:,244))
  call Hloop_AQ_Z(ntryL,G1H16(83),ex1(:),G1H8(51),ngZd,m3h2x8(:,133),heltab2x16(:,:,245))
  call Hloop_AQ_W(ntryL,G1H16(84),ex1(:),G1H8(52),m3h2x8(:,134),heltab2x16(:,:,246))
  call Hloop_SQ_A(ntryL,G0H4(55),ex1(:),G0H2(1),ngH,m3h2x2(:,283),heltab2x4(:,:,331))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(208),n2h2(421))
  call Hloop_SQ_A(ntryL,G0H4(56),ex1(:),G0H2(1),ngX,m3h2x2(:,284),heltab2x4(:,:,332))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(209),n2h2(422))
  call Hloop_SQ_A(ntryL,G0H4(57),ex1(:),G0H2(1),ngPtb,m3h2x2(:,285),heltab2x4(:,:,333))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(257),n2h2(423))
  call Hloop_AQ_S(ntryL,G1H4(89),ex1(:),G1H2(235),ngPtb,m3h2x2(:,286),heltab2x4(:,:,334))
  call Hloop_VQ_A(ntryL,G0H4(58),ex1(:),G0H2(1),m3h2x2(:,287),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(224),n2h2(424))
  call Hloop_ZQ_A(ntryL,G0H4(59),ex1(:),G0H2(1),ngZd,m3h2x2(:,288),heltab2x4(:,:,336))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(230),n2h2(425))
  call Hloop_WQ_A(ntryL,G0H4(60),ex1(:),G0H2(1),m3h2x2(:,289),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(234),n2h2(426))
  call Hloop_AQ_S(ntryL,G1H4(95),ex1(:),G1H2(245),ngPtb,m3h2x2(:,290),heltab2x4(:,:,338))
  call Hloop_AQ_W(ntryL,G1H4(96),ex1(:),G1H2(256),m3h2x2(:,291),heltab2x4(:,:,339))
  call Hloop_AQ_W(ntryL,G1H4(92),ex1(:),G1H2(267),m3h2x2(:,292),heltab2x4(:,:,340))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(19),G1H2(226)])
call HGT_OLR(G2H2(148),1,1,2)
call HGT_invQ_OLR(G2H2(148),2,5,2)
call HGT_OLR(G2H2(148),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(103),G2H2(95),G2H2(127),G2H2(87),G2H2(75) &
    ,G2H2(33),G2H2(51),G2H2(253),G2H2(232),G2H2(214),G2H2(202),G2H2(149),G1H2(375),G1H2(369),G1H2(366),G1H2(349),G1H2(155) &
    ,G1H2(111),G1H2(40),G1H2(1)])
call HGT_OLR(G2H2(152),1,1,2)
call HGT_invQ_OLR(G2H2(152),2,5,2)
call HGT_OLR(G2H2(152),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(113),G2H2(91),G2H2(144),G2H2(83),G2H2(37) &
    ,G2H2(67),G2H2(195),G2H2(241),G2H2(223),G2H2(208),G2H2(196),G2H2(153),G1H2(372),G1H2(360),G1H2(126),G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(136),G2H2(135),G2H2(134),G1H2(92),G1H2(11) &
    ,G1H2(236),G1H2(144)])
call HGT_OLR(G2H2(156),1,1,2)
call HGT_invQ_OLR(G2H2(156),2,5,2)
call HGT_OLR(G2H2(156),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G1H2(383),G1H2(268),G1H2(33),G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G2H2(119),G2H2(84),G2H2(133),G1H2(48),G1H2(82)])
call HGT_OLR(G2H2(160),1,1,2)
call HGT_invQ_OLR(G2H2(160),2,5,2)
call HGT_OLR(G2H2(160),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G1H2(394),G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(241),[G1H2(164),G1H2(135)])
call HGT_OLR(G2H2(164),1,1,2)
call HGT_invQ_OLR(G2H2(164),2,5,2)
call HGT_OLR(G2H2(164),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(128),G2H2(142),G2H2(97),G2H2(143),G2H2(109) &
    ,G2H2(13),G2H2(63),G2H2(259),G2H2(235),G2H2(217),G2H2(205),G2H2(165),G1H2(405),G1H2(341),G1H2(335),G1H2(332),G1H2(252) &
    ,G1H2(180),G1H2(153),G1H2(211)])
call HGT_OLR(G2H2(168),1,1,2)
call HGT_invQ_OLR(G2H2(168),2,5,2)
call HGT_OLR(G2H2(168),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(99),G2H2(123),G2H2(141),G2H2(79),G2H2(71) &
    ,G2H2(21),G2H2(207),G2H2(247),G2H2(229),G2H2(211),G2H2(199),G2H2(169),G1H2(416),G1H2(338),G1H2(223),G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G2H2(39),G2H2(138),G2H2(137),G1H2(302),G1H2(171) &
    ,G1H2(215),G1H2(210)])
call HGT_OLR(G2H2(172),1,1,2)
call HGT_invQ_OLR(G2H2(172),2,5,2)
call HGT_OLR(G2H2(172),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G2H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G1H2(427),G1H2(307),G1H2(287),G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(35),G2H2(31),G2H2(27),G1H2(292),G1H2(265)])
call HGT_OLR(G2H2(176),1,1,2)
call HGT_invQ_OLR(G2H2(176),2,5,2)
call HGT_OLR(G2H2(176),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G1H2(438),G1H2(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(231),G2H2(85),G1H2(123)])
call HGT_OLR(G2H2(180),1,1,2)
call HGT_invQ_OLR(G2H2(180),2,5,2)
call HGT_OLR(G2H2(180),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(201),G2H2(115),G1H2(459)])
call HGT_OLR(G2H2(184),1,1,2)
call HGT_invQ_OLR(G2H2(184),2,5,2)
call HGT_OLR(G2H2(184),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(185),[G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(45),G2H2(5),G2H2(140),G2H2(29),G2H2(108) &
    ,G2H2(256),G2H2(244),G2H2(226),G2H2(189),G1H2(460),G1H2(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(129),G2H2(9),G2H2(96),G2H2(139),G2H2(25) &
    ,G2H2(250),G2H2(238),G2H2(220),G2H2(193),G1H2(145),G1H2(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(327),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(208),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(344),G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(230),[G1H2(209),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(30),G1H2(352),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(257),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(41),G1H2(444),G1H2(355),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(224),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(363),G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(317),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(365),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(378),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(147),[G1H2(120),G1H2(368),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(386),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(121),G1H2(443),G1H2(371),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(389),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(374),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(397),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(400),G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(213),[G1H2(146),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(214),[G1H2(170),G1H2(408),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(157),G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(181),G1H2(448),G1H2(411),G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(419),G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(331),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(422),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(104),G1H2(334),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(430),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(93),G1H2(447),G1H2(337),G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(433),[G1H2(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(340),G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(441),[G1H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G1H2(362),G1H2(351),G1H2(348),G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(216),[G1H2(359),G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G1H2(396),G1H2(385),G1H2(382),G1H2(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(393),G1H2(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(418),G1H2(407),G1H2(404),G1H2(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(415),G1H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(440),G1H2(429),G1H2(426),G1H2(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G1H2(437),G1H2(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(59),G0H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(51),G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(66),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(120),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G1H4(112),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(165),G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(124),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(33),G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(210),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(455)])
  call Hloop_QV_A(ntryL,G2H2(148),ex3(:),G2H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(19),n2h1(515))
  call Hloop_QV_A(ntryL,G2H2(146),ex4(:),G2H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(20),n2h1(516))
  call Hloop_QV_A(ntryL,G2H2(152),ex3(:),G2H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(21),n2h1(517))
  call Hloop_QV_A(ntryL,G2H2(107),ex4(:),G2H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(22),n2h1(518))
  call Hloop_QV_A(ntryL,G2H2(156),ex4(:),G2H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(519))
  call Hloop_QV_A(ntryL,G2H2(157),ex3(:),G2H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(24),n2h1(520))
  call Hloop_QV_A(ntryL,G2H2(160),ex4(:),G2H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(25),n2h1(521))
  call Hloop_QV_A(ntryL,G2H2(161),ex3(:),G2H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(26),n2h1(522))
  call Hloop_AV_Q(ntryL,G2H2(164),ex3(:),G2H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(27),n2h1(523))
  call Hloop_AV_Q(ntryL,G2H2(111),ex4(:),G2H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(28),n2h1(524))
  call Hloop_AV_Q(ntryL,G2H2(168),ex3(:),G2H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(29),n2h1(525))
  call Hloop_AV_Q(ntryL,G2H2(121),ex4(:),G2H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(30),n2h1(526))
  call Hloop_AV_Q(ntryL,G2H2(172),ex4(:),G2H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(31),n2h1(527))
  call Hloop_AV_Q(ntryL,G2H2(173),ex3(:),G2H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(32),n2h1(528))
  call Hloop_AV_Q(ntryL,G2H2(176),ex4(:),G2H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(33),n2h1(529))
  call Hloop_AV_Q(ntryL,G2H2(177),ex3(:),G2H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(34),n2h1(530))
  call Hloop_QV_A(ntryL,G2H2(180),ex4(:),G2H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(35),n2h1(531))
  call Hloop_QV_A(ntryL,G2H2(181),ex3(:),G2H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(36),n2h1(532))
  call Hloop_AV_Q(ntryL,G2H2(184),ex4(:),G2H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(37),n2h1(533))
  call Hloop_AV_Q(ntryL,G2H2(185),ex3(:),G2H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(38),n2h1(534))
call HGT_OLR(G2H2(188),1,1,2)
call HGT_invQ_OLR(G2H2(188),2,5,2)
call HGT_OLR(G2H2(188),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(188),ex3(:),G2H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(39),n2h1(535))
  call Hloop_AV_Q(ntryL,G2H2(49),ex4(:),G2H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(40),n2h1(536))
call HGT_OLR(G2H2(192),1,1,2)
call HGT_invQ_OLR(G2H2(192),2,5,2)
call HGT_OLR(G2H2(192),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(192),ex3(:),G2H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(41),n2h1(537))
  call Hloop_QV_A(ntryL,G2H2(145),ex4(:),G2H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(42),n2h1(538))
call HGT_OLR(G2H4(25),1,1,4)
call HGT_invQ_OLR(G2H4(25),2,5,4)
call HGT_OLR(G2H4(25),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(25),wf4(:,36),G2H1(1),ngH,m3h4x1(:,49),heltab2x4(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(43),n2h1(539))
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(17),wf4(:,36),G2H1(1),ngH,m3h4x1(:,50),heltab2x4(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(44),n2h1(540))
call HGT_OLR(G2H4(30),1,1,4)
call HGT_invQ_OLR(G2H4(30),2,5,4)
call HGT_OLR(G2H4(30),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(30),wf4(:,36),G2H1(1),ngH,m3h4x1(:,51),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(45),n2h1(541))
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(19),wf4(:,36),G2H1(1),ngH,m3h4x1(:,52),heltab2x4(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(46),n2h1(542))
call HGT_OLR(G2H4(44),1,1,4)
call HGT_invQ_OLR(G2H4(44),2,5,4)
call HGT_OLR(G2H4(44),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(44),wf4(:,37),G2H1(1),ngX,m3h4x1(:,53),heltab2x4(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(47),n2h1(543))
call HGT_OLR(G2H4(28),1,1,4)
call HGT_invQ_OLR(G2H4(28),2,5,4)
call HGT_OLR(G2H4(28),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(28),wf4(:,37),G2H1(1),ngX,m3h4x1(:,54),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(48),n2h1(544))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(4),wf4(:,37),G2H1(1),ngX,m3h4x1(:,55),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(49),n2h1(545))
call HGT_OLR(G2H4(33),1,1,4)
call HGT_invQ_OLR(G2H4(33),2,5,4)
call HGT_OLR(G2H4(33),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(33),wf4(:,37),G2H1(1),ngX,m3h4x1(:,56),heltab2x4(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(50),n2h1(546))
call HGT_OLR(G2H4(42),1,1,4)
call HGT_invQ_OLR(G2H4(42),2,5,4)
call HGT_OLR(G2H4(42),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(42),wf4(:,14),G2H1(1),m3h4x1(:,57),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(51),n2h1(547))
call HGT_OLR(G2H4(29),1,1,4)
call HGT_invQ_OLR(G2H4(29),2,5,4)
call HGT_OLR(G2H4(29),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(29),wf4(:,14),G2H1(1),m3h4x1(:,58),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(52),n2h1(548))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,14),G2H1(1),m3h4x1(:,59),heltab2x4(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(53),n2h1(549))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,14),G2H1(1),m3h4x1(:,60),heltab2x4(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(54),n2h1(550))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,14),G2H1(1),m3h4x1(:,61),heltab2x4(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(55),n2h1(551))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,14),G2H1(1),m3h4x1(:,62),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(56),n2h1(552))
call HGT_OLR(G2H4(41),1,1,4)
call HGT_invQ_OLR(G2H4(41),2,5,4)
call HGT_OLR(G2H4(41),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(41),wf4(:,15),G2H1(1),ngZu,m3h4x1(:,63),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(57),n2h1(553))
call HGT_OLR(G2H4(43),1,1,4)
call HGT_invQ_OLR(G2H4(43),2,5,4)
call HGT_OLR(G2H4(43),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(43),wf4(:,15),G2H1(1),ngZu,m3h4x1(:,64),heltab2x4(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(58),n2h1(554))
call HGT_OLR(G2H4(13),1,1,4)
call HGT_invQ_OLR(G2H4(13),2,5,4)
call HGT_OLR(G2H4(13),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(13),wf4(:,15),G2H1(1),ngZu,m3h4x1(:,65),heltab2x4(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(59),n2h1(555))
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(7),wf4(:,15),G2H1(1),ngZu,m3h4x1(:,66),heltab2x4(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(60),n2h1(556))
call HGT_OLR(G2H4(27),1,1,4)
call HGT_invQ_OLR(G2H4(27),2,5,4)
call HGT_OLR(G2H4(27),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(27),wf4(:,15),G2H1(1),ngZd,m3h4x1(:,67),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(61),n2h1(557))
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(40),wf4(:,15),G2H1(1),ngZd,m3h4x1(:,68),heltab2x4(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(62),n2h1(558))
call HGT_OLR(G2H4(34),1,1,4)
call HGT_invQ_OLR(G2H4(34),2,5,4)
call HGT_OLR(G2H4(34),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(34),wf4(:,15),G2H1(1),ngZd,m3h4x1(:,69),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(63),n2h1(559))
call HGT_OLR(G2H4(21),1,1,4)
call HGT_invQ_OLR(G2H4(21),2,5,4)
call HGT_OLR(G2H4(21),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,15),G2H1(1),ngZd,m3h4x1(:,70),heltab2x4(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(64),n2h1(560))
  call Hloop_SA_Q(ntryL,G1H2(189),ex2(:),G1H1(1),ngH,m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(561))
  call Hloop_SA_Q(ntryL,G1H2(194),ex2(:),G1H1(1),ngH,m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(562))
  call Hloop_SA_Q(ntryL,G1H2(227),ex2(:),G1H1(1),ngX,m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(563))
  call Hloop_SA_Q(ntryL,G1H2(232),ex2(:),G1H1(1),ngX,m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(564))
  call Hloop_SA_Q(ntryL,G1H2(244),ex2(:),G1H1(1),ngPbt,m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(438),n2h1(565))
  call Hloop_SA_Q(ntryL,G1H2(322),ex2(:),G1H1(1),ngPbt,m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(7),n2h1(566))
  call Hloop_VA_Q(ntryL,G1H2(282),ex2(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(156),n2h1(567))
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(568))
  call Hloop_ZA_Q(ntryL,G1H2(61),ex2(:),G1H1(1),ngZd,m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(441),n2h1(569))
  call Hloop_ZA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),ngZd,m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(570))
  call Hloop_WA_Q(ntryL,G1H2(138),ex2(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(14),n2h1(571))
  call Hloop_WA_Q(ntryL,G1H2(327),ex2(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(572))
  call Hloop_QV_A(ntryL,G1H2(208),ex3(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(573))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(574))
  call Hloop_QV_A(ntryL,G1H2(230),ex3(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(575))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(576))
  call Hloop_QV_A(ntryL,G1H2(234),ex3(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(26),n2h1(577))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(27),n2h1(578))
  call Hloop_QV_A(ntryL,G1H2(224),ex3(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(30),n2h1(579))
  call Hloop_QV_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(580))
  call Hloop_SQ_A(ntryL,G1H2(128),ex1(:),G1H1(1),ngH,m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(581))
  call Hloop_SQ_A(ntryL,G1H2(129),ex1(:),G1H1(1),ngH,m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(582))
  call Hloop_SQ_A(ntryL,G1H2(172),ex1(:),G1H1(1),ngX,m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(201),n2h1(583))
  call Hloop_SQ_A(ntryL,G1H2(177),ex1(:),G1H1(1),ngX,m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(584))
  call Hloop_SQ_A(ntryL,G1H2(27),ex1(:),G1H1(1),ngPtb,m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(414),n2h1(585))
  call Hloop_SQ_A(ntryL,G1H2(312),ex1(:),G1H1(1),ngPtb,m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(39),n2h1(586))
  call Hloop_VQ_A(ntryL,G1H2(91),ex1(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(204),n2h1(587))
  call Hloop_VQ_A(ntryL,G1H2(137),ex1(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(588))
  call Hloop_ZQ_A(ntryL,G1H2(159),ex1(:),G1H1(1),ngZd,m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(417),n2h1(589))
  call Hloop_ZQ_A(ntryL,G1H2(124),ex1(:),G1H1(1),ngZd,m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(590))
  call Hloop_WQ_A(ntryL,G1H2(280),ex1(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(591))
  call Hloop_WQ_A(ntryL,G1H2(317),ex1(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(592))
  call Hloop_QV_A(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(593))
  call Hloop_QV_A(ntryL,G1H2(378),ex3(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(594))
  call Hloop_QV_A(ntryL,G1H2(147),ex4(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(595))
  call Hloop_QV_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(596))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(66),n2h1(597))
  call Hloop_QV_A(ntryL,G1H2(389),ex3(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(598))
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(599))
  call Hloop_QV_A(ntryL,G1H2(397),ex3(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(600))
  call Hloop_AV_Q(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(74),n2h1(601))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(602))
  call Hloop_AV_Q(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(603))
  call Hloop_AV_Q(ntryL,G1H2(214),ex4(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(79),n2h1(604))
  call Hloop_AV_Q(ntryL,G1H2(219),ex3(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(82),n2h1(605))
  call Hloop_AV_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(606))
  call Hloop_AV_Q(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(607))
  call Hloop_AV_Q(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(608))
  call Hloop_AV_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(291),n2h1(609))
  call Hloop_AV_Q(ntryL,G1H2(422),ex3(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(98),n2h1(610))
  call Hloop_AV_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(405),n2h1(611))
  call Hloop_AV_Q(ntryL,G1H2(430),ex3(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(99),n2h1(612))
  call Hloop_AV_Q(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(297),n2h1(613))
  call Hloop_AV_Q(ntryL,G1H2(433),ex3(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(614))
  call Hloop_AV_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(429),n2h1(615))
  call Hloop_AV_Q(ntryL,G1H2(441),ex3(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(616))
  call Hloop_SQ_A(ntryL,G1H2(311),ex1(:),G1H1(1),ngPtb,m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(150),n2h1(617))
  call Hloop_WQ_A(ntryL,G1H2(316),ex1(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(159),n2h1(618))
  call Hloop_SA_Q(ntryL,G1H2(321),ex2(:),G1H1(1),ngPbt,m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(318),n2h1(619))
  call Hloop_WA_Q(ntryL,G1H2(326),ex2(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(327),n2h1(620))
  call Hloop_QV_A(ntryL,G2H2(234),ex4(:),G2H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(65),n2h1(621))
  call Hloop_QV_A(ntryL,G2H2(216),ex4(:),G2H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(66),n2h1(622))
  call Hloop_QV_A(ntryL,G2H2(204),ex3(:),G2H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(67),n2h1(623))
  call Hloop_QV_A(ntryL,G2H2(19),ex3(:),G2H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(68),n2h1(624))
  call Hloop_AV_Q(ntryL,G2H2(15),ex4(:),G2H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(69),n2h1(625))
  call Hloop_AV_Q(ntryL,G2H2(7),ex4(:),G2H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(70),n2h1(626))
  call Hloop_AV_Q(ntryL,G2H2(3),ex3(:),G2H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(71),n2h1(627))
  call Hloop_AV_Q(ntryL,G2H2(228),ex3(:),G2H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(72),n2h1(628))
  call Hloop_SQ_A(ntryL,G1H4(157),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,71),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(348),n2h1(629))
  call Hloop_SQ_A(ntryL,G1H4(137),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,72),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(357),n2h1(630))
  call Hloop_WQ_A(ntryL,G1H4(164),wf4(:,10),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(631))
  call Hloop_WQ_A(ntryL,G1H4(140),wf4(:,10),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(632))
  call Hloop_SQ_A(ntryL,G1H4(22),wf4(:,10),G1H1(1),ngH,m3h4x1(:,75),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(131),n2h1(633))
  call Hloop_SQ_A(ntryL,G1H4(133),wf4(:,10),G1H1(1),ngH,m3h4x1(:,76),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(132),n2h1(634))
  call Hloop_SQ_A(ntryL,G1H4(58),wf4(:,10),G1H1(1),ngX,m3h4x1(:,77),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(137),n2h1(635))
  call Hloop_SQ_A(ntryL,G1H4(134),wf4(:,10),G1H1(1),ngX,m3h4x1(:,78),heltab2x4(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(636))
  call Hloop_SQ_A(ntryL,G1H4(113),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,79),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(141),n2h1(637))
  call Hloop_VQ_A(ntryL,G1H4(70),wf4(:,10),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(638))
  call Hloop_VQ_A(ntryL,G1H4(138),wf4(:,10),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(639))
  call Hloop_ZQ_A(ntryL,G1H4(178),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,82),heltab2x4(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(453),n2h1(640))
  call Hloop_ZQ_A(ntryL,G1H4(139),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,83),heltab2x4(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(459),n2h1(641))
  call Hloop_WQ_A(ntryL,G1H4(100),wf4(:,10),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(465),n2h1(642))
  call Hloop_SA_Q(ntryL,G1H4(173),wf4(:,4),G1H1(1),ngPbt,m3h4x1(:,85),heltab2x4(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(147),n2h1(643))
  call Hloop_SA_Q(ntryL,G1H4(104),wf4(:,4),G1H1(1),ngPbt,m3h4x1(:,86),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(435),n2h1(644))
  call Hloop_WA_Q(ntryL,G1H4(180),wf4(:,4),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(165),n2h1(645))
  call Hloop_WA_Q(ntryL,G1H4(108),wf4(:,4),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(447),n2h1(646))
  call Hloop_SA_Q(ntryL,G1H4(136),wf4(:,4),G1H1(1),ngH,m3h4x1(:,89),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(168),n2h1(647))
  call Hloop_SA_Q(ntryL,G1H4(97),wf4(:,4),G1H1(1),ngH,m3h4x1(:,90),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(450),n2h1(648))
  call Hloop_SA_Q(ntryL,G1H4(148),wf4(:,4),G1H1(1),ngX,m3h4x1(:,91),heltab2x4(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(162),n2h1(649))
  call Hloop_SA_Q(ntryL,G1H4(103),wf4(:,4),G1H1(1),ngX,m3h4x1(:,92),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(444),n2h1(650))
  call Hloop_SA_Q(ntryL,G1H4(160),wf4(:,4),G1H1(1),ngPbt,m3h4x1(:,93),heltab2x4(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(651))
  call Hloop_VA_Q(ntryL,G1H4(189),wf4(:,4),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(652))
  call Hloop_VA_Q(ntryL,G1H4(102),wf4(:,4),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(653))
  call Hloop_ZA_Q(ntryL,G1H4(15),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,96),heltab2x4(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(654))
  call Hloop_ZA_Q(ntryL,G1H4(107),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,97),heltab2x4(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(183),n2h1(655))
  call Hloop_WA_Q(ntryL,G1H4(73),wf4(:,4),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(59),n2h1(656))
  call Hloop_QV_A(ntryL,G2H2(210),ex3(:),G2H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(73),n2h1(657))
  call Hloop_AV_Q(ntryL,G2H2(198),ex3(:),G2H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(74),n2h1(658))
  call Hloop_AV_Q(ntryL,G2H2(23),ex4(:),G2H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(75),n2h1(659))
  call Hloop_QV_A(ntryL,G2H2(11),ex4(:),G2H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(76),n2h1(660))
  call Hloop_SQ_A(ntryL,G1H4(85),wf4(:,3),G1H1(1),ngH,m3h4x1(:,99),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(189),n2h1(661))
  call Hloop_SQ_A(ntryL,G1H4(86),wf4(:,3),G1H1(1),ngX,m3h4x1(:,100),heltab2x4(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(662))
  call Hloop_SQ_A(ntryL,G1H4(127),wf4(:,3),G1H1(1),ngPtb,m3h4x1(:,101),heltab2x4(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(195),n2h1(663))
  call Hloop_VQ_A(ntryL,G1H4(128),wf4(:,3),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(411),n2h1(664))
  call Hloop_ZQ_A(ntryL,G1H4(131),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,103),heltab2x4(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(213),n2h1(665))
  call Hloop_WQ_A(ntryL,G1H4(132),wf4(:,3),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(423),n2h1(666))
  call Hloop_SQ_A(ntryL,G1H8(41),wf8(:,35),G1H1(1),ngH,m3h8x1(:,1),heltab2x8(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(216),n2h1(667))
  call Hloop_SQ_A(ntryL,G1H8(42),wf8(:,35),G1H1(1),ngX,m3h8x1(:,2),heltab2x8(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(426),n2h1(668))
  call Hloop_SQ_A(ntryL,G1H8(43),wf8(:,35),G1H1(1),ngPtb,m3h8x1(:,3),heltab2x8(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(210),n2h1(669))
  call Hloop_VQ_A(ntryL,G1H8(44),wf8(:,35),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(420),n2h1(670))
  call Hloop_ZQ_A(ntryL,G1H8(45),wf8(:,35),G1H1(1),ngZd,m3h8x1(:,5),heltab2x8(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(219),n2h1(671))
  call Hloop_WQ_A(ntryL,G1H8(46),wf8(:,35),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(225),n2h1(672))
  call Hloop_SA_Q(ntryL,G1H4(143),wf4(:,11),G1H1(1),ngH,m3h4x1(:,105),heltab2x4(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(231),n2h1(673))
  call Hloop_SA_Q(ntryL,G1H4(144),wf4(:,11),G1H1(1),ngX,m3h4x1(:,106),heltab2x4(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(237),n2h1(674))
  call Hloop_SA_Q(ntryL,G1H4(145),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,107),heltab2x4(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(243),n2h1(675))
  call Hloop_VA_Q(ntryL,G1H4(146),wf4(:,11),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(676))
  call Hloop_ZA_Q(ntryL,G1H4(149),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,109),heltab2x4(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(249),n2h1(677))
  call Hloop_WA_Q(ntryL,G1H4(150),wf4(:,11),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(678))
  call Hloop_SA_Q(ntryL,G1H8(47),wf8(:,42),G1H1(1),ngH,m3h8x1(:,7),heltab2x8(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(255),n2h1(679))
  call Hloop_SA_Q(ntryL,G1H8(48),wf8(:,42),G1H1(1),ngX,m3h8x1(:,8),heltab2x8(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(680))
  call Hloop_SA_Q(ntryL,G1H8(1),wf8(:,42),G1H1(1),ngPbt,m3h8x1(:,9),heltab2x8(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(261),n2h1(681))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,42),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(95),n2h1(682))
  call Hloop_ZA_Q(ntryL,G1H8(4),wf8(:,42),G1H1(1),ngZd,m3h8x1(:,11),heltab2x8(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(267),n2h1(683))
  call Hloop_WA_Q(ntryL,G1H8(5),wf8(:,42),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(273),n2h1(684))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(38),wf4(:,10),G2tensor(279),ngH,m3h4x1(:,111),heltab2x4(:,:,403))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(35),wf4(:,10),G2tensor(285),ngX,m3h4x1(:,112),heltab2x4(:,:,404))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(32),wf4(:,10),G2tensor(294),ngPtb,m3h4x1(:,113),heltab2x4(:,:,405))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(8),wf4(:,10),G2tensor(408),m3h4x1(:,114),heltab2x4(:,:,406))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(1),wf4(:,10),G2tensor(300),ngZd,m3h4x1(:,115),heltab2x4(:,:,407))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(20),wf4(:,10),G2tensor(432),m3h4x1(:,116),heltab2x4(:,:,408))
  call Hloop_SQ_A(ntryL,G1H8(6),wf8(:,48),G1H1(1),ngH,m3h8x1(:,13),heltab2x8(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(303),n2h1(685))
  call Hloop_SQ_A(ntryL,G1H8(7),wf8(:,48),G1H1(1),ngX,m3h8x1(:,14),heltab2x8(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(198),n2h1(686))
  call Hloop_SQ_A(ntryL,G1H8(9),wf8(:,48),G1H1(1),ngPtb,m3h8x1(:,15),heltab2x8(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(306),n2h1(687))
  call Hloop_VQ_A(ntryL,G1H8(10),wf8(:,48),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(309),n2h1(688))
  call Hloop_ZQ_A(ntryL,G1H8(11),wf8(:,48),G1H1(1),ngZd,m3h8x1(:,17),heltab2x8(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(207),n2h1(689))
  call Hloop_WQ_A(ntryL,G1H8(12),wf8(:,48),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(312),n2h1(690))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(168),27,ex3(:),4,G2tensor(315),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(197),ex3(:),G1tensor(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(186),ex3(:),G1tensor(31),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(202),27,ex3(:),4,G2tensor(366),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(22),wf4(:,4),G2tensor(174),ngH,m3h4x1(:,117),heltab2x4(:,:,409))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(16),wf4(:,4),G2tensor(321),ngX,m3h4x1(:,118),heltab2x4(:,:,410))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(10),wf4(:,4),G2tensor(180),ngPbt,m3h4x1(:,119),heltab2x4(:,:,411))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(23),wf4(:,4),G2tensor(324),m3h4x1(:,120),heltab2x4(:,:,412))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(14),wf4(:,4),G2tensor(375),ngZd,m3h4x1(:,121),heltab2x4(:,:,413))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(11),wf4(:,4),G2tensor(186),m3h4x1(:,122),heltab2x4(:,:,414))
  call Hloop_SA_Q(ntryL,G1H8(14),wf8(:,50),G1H1(1),ngH,m3h8x1(:,19),heltab2x8(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(330),n2h1(691))
  call Hloop_SA_Q(ntryL,G1H8(15),wf8(:,50),G1H1(1),ngX,m3h8x1(:,20),heltab2x8(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(192),n2h1(692))
  call Hloop_SA_Q(ntryL,G1H8(16),wf8(:,50),G1H1(1),ngPbt,m3h8x1(:,21),heltab2x8(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(333),n2h1(693))
  call Hloop_VA_Q(ntryL,G1H8(49),wf8(:,50),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(336),n2h1(694))
  call Hloop_ZA_Q(ntryL,G1H8(51),wf8(:,50),G1H1(1),ngZd,m3h8x1(:,23),heltab2x8(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(339),n2h1(695))
  call Hloop_WA_Q(ntryL,G1H8(52),wf8(:,50),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(342),n2h1(696))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(235),27,ex3(:),4,G2tensor(345),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(245),ex3(:),G1tensor(61),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(256),ex3(:),G1tensor(91),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(267),27,ex3(:),4,G2tensor(384),m3h2x1(:,570),heltab2x2(:,:,570))
  call ol_merge_tensors(G2tensor(436),[G2tensor(148),G2tensor(4),G1tensor(37),G1tensor(7),G0tensor(16),G0tensor(11)])
  call ol_merge_tensors(G2tensor(448),[G2tensor(439),G2tensor(166),G2tensor(154),G2tensor(8),G1tensor(97),G1tensor(67) &
    ,G0tensor(26),G0tensor(21)])
  call ol_merge_tensors(G2tensor(451),[G2tensor(442),G2tensor(169),G2tensor(157),G2tensor(12),G1tensor(2),G1tensor(127) &
    ,G0tensor(36),G0tensor(31)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(163),G2tensor(16),G1tensor(30),G1tensor(18),G0tensor(46),G0tensor(41)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(220),G2tensor(172),G2tensor(52),G2tensor(20),G1tensor(75),G1tensor(146) &
    ,G1tensor(50),G1tensor(90),G0tensor(131),G0tensor(92),G0tensor(56),G0tensor(51)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(201),G2tensor(226),G2tensor(178),G2tensor(56),G2tensor(24),G1tensor(82) &
    ,G1tensor(5),G1tensor(80),G1tensor(66),G0tensor(136),G0tensor(102),G0tensor(66),G0tensor(61)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(414),G2tensor(232),G2tensor(184),G2tensor(60),G2tensor(28),G1tensor(87) &
    ,G1tensor(100),G1tensor(132),G1tensor(69),G0tensor(141),G0tensor(112),G0tensor(76),G0tensor(71)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(238),G2tensor(190),G2tensor(64),G2tensor(32),G1tensor(95),G1tensor(149) &
    ,G1tensor(128),G1tensor(116),G0tensor(146),G0tensor(122),G0tensor(86),G0tensor(81)])
  call ol_merge_tensors(G2tensor(412),[G2tensor(196),G2tensor(36),G1tensor(4),G1tensor(21),G0tensor(96),G0tensor(91)])
  call ol_merge_tensors(G2tensor(424),[G2tensor(415),G2tensor(214),G2tensor(202),G2tensor(40),G1tensor(65),G1tensor(11) &
    ,G0tensor(106),G0tensor(101)])
  call ol_merge_tensors(G2tensor(427),[G2tensor(418),G2tensor(217),G2tensor(205),G2tensor(44),G1tensor(29),G1tensor(106) &
    ,G0tensor(116),G0tensor(111)])
  call ol_merge_tensors(G2tensor(421),[G2tensor(211),G2tensor(48),G1tensor(52),G1tensor(40),G0tensor(126),G0tensor(121)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(268),G2tensor(244),G2tensor(84),G2tensor(68),G1tensor(182),G1tensor(123) &
    ,G1tensor(111),G1tensor(13),G0tensor(191),G0tensor(156),G0tensor(151),G0tensor(12)])
  call ol_merge_tensors(G2tensor(441),[G2tensor(153),G2tensor(274),G2tensor(250),G2tensor(88),G2tensor(72),G1tensor(187) &
    ,G1tensor(157),G1tensor(137),G1tensor(73),G0tensor(196),G0tensor(166),G0tensor(161),G0tensor(22)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(438),G2tensor(280),G2tensor(256),G2tensor(92),G2tensor(76),G1tensor(192) &
    ,G1tensor(167),G1tensor(162),G1tensor(133),G0tensor(201),G0tensor(176),G0tensor(171),G0tensor(32)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(286),G2tensor(262),G2tensor(96),G2tensor(80),G1tensor(197),G1tensor(177) &
    ,G1tensor(172),G1tensor(20),G0tensor(206),G0tensor(186),G0tensor(181),G0tensor(42)])
  call ol_merge_tensors(G2tensor(366),[G2tensor(315),G2tensor(409),G2tensor(406),G2tensor(295),G2tensor(292),G2tensor(100) &
    ,G1tensor(31),G1tensor(1),G1tensor(207),G1tensor(202),G0tensor(216),G0tensor(211)])
  call ol_merge_tensors(G2tensor(384),[G2tensor(345),G2tensor(433),G2tensor(430),G2tensor(301),G2tensor(298),G2tensor(104) &
    ,G1tensor(91),G1tensor(61),G1tensor(217),G1tensor(212),G0tensor(226),G0tensor(221)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(271),G2tensor(269),G2tensor(1),G1tensor(417),G1tensor(185),G1tensor(43) &
    ,G0tensor(426),G0tensor(194),G0tensor(17)])
  call ol_merge_tensors(G2tensor(450),[G2tensor(305),G2tensor(5),G1tensor(225),G1tensor(49),G0tensor(234),G0tensor(18)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(1),G2tensor(449),G2tensor(446),G2tensor(440),G2tensor(437),G2tensor(425) &
    ,G2tensor(422),G2tensor(416),G2tensor(413),G2tensor(200),G2tensor(152),G1tensor(230),G1tensor(64),G1tensor(27),G1tensor(53) &
    ,G1tensor(36),G1tensor(115),G1tensor(55),G0tensor(239),G0tensor(129),G0tensor(109),G0tensor(99),G0tensor(49),G0tensor(29) &
    ,G0tensor(19)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(162),G2tensor(277),G2tensor(275),G2tensor(9),G1tensor(427),G1tensor(190) &
    ,G1tensor(103),G0tensor(436),G0tensor(199),G0tensor(27)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(444),G2tensor(308),G2tensor(13),G1tensor(235),G1tensor(109),G0tensor(244) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(171),G2tensor(283),G2tensor(281),G2tensor(17),G1tensor(437),G1tensor(195) &
    ,G1tensor(6),G0tensor(446),G0tensor(204),G0tensor(37)])
  call ol_merge_tensors(G2tensor(447),[G2tensor(435),G2tensor(311),G2tensor(21),G1tensor(240),G1tensor(219),G1tensor(8) &
    ,G0tensor(249),G0tensor(228),G0tensor(38)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(2),G2tensor(452),G2tensor(443),G2tensor(428),G2tensor(419),G2tensor(209) &
    ,G2tensor(161),G1tensor(245),G1tensor(39),G1tensor(12),G0tensor(254),G0tensor(119),G0tensor(39)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(289),G2tensor(287),G2tensor(25),G1tensor(447),G1tensor(200),G1tensor(32) &
    ,G0tensor(456),G0tensor(209),G0tensor(47)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(314),G2tensor(29),G1tensor(250),G1tensor(84),G0tensor(259),G0tensor(48)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(317),G2tensor(97),G2tensor(33),G1tensor(325),G1tensor(255),G1tensor(54) &
    ,G0tensor(334),G0tensor(264),G0tensor(57)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(7),G3tensor(3),G2tensor(386),G2tensor(368),G2tensor(350),G2tensor(320) &
    ,G1tensor(330),G1tensor(260),G1tensor(179),G1tensor(159),G1tensor(129),G1tensor(134),G1tensor(86),G1tensor(56),G0tensor(339) &
    ,G0tensor(269),G0tensor(188),G0tensor(168),G0tensor(158),G0tensor(88),G0tensor(68),G0tensor(58)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(216),G2tensor(224),G2tensor(176),G2tensor(101),G2tensor(37),G1tensor(335) &
    ,G1tensor(265),G1tensor(60),G0tensor(344),G0tensor(274),G0tensor(59)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(323),G2tensor(105),G2tensor(41),G1tensor(340),G1tensor(270),G1tensor(57) &
    ,G0tensor(349),G0tensor(279),G0tensor(67)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(198),G2tensor(219),G2tensor(426),G2tensor(230),G2tensor(182),G2tensor(106) &
    ,G2tensor(45),G1tensor(345),G1tensor(275),G1tensor(63),G0tensor(354),G0tensor(284),G0tensor(69)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(326),G2tensor(107),G2tensor(49),G1tensor(350),G1tensor(280),G1tensor(108) &
    ,G0tensor(359),G0tensor(289),G0tensor(77)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(10),G3tensor(8),G3tensor(4),G2tensor(395),G2tensor(377),G2tensor(359),G2tensor(329) &
    ,G1tensor(355),G1tensor(285),G1tensor(169),G1tensor(110),G0tensor(364),G0tensor(294),G0tensor(178),G0tensor(78)])
  call ol_merge_tensors(G2tensor(312),[G2tensor(306),G2tensor(225),G2tensor(210),G2tensor(410),G2tensor(407),G2tensor(236) &
    ,G2tensor(188),G2tensor(108),G2tensor(53),G1tensor(360),G1tensor(290),G1tensor(210),G1tensor(138),G0tensor(369),G0tensor(299) &
    ,G0tensor(219),G0tensor(79)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(332),G2tensor(109),G2tensor(57),G1tensor(365),G1tensor(295),G1tensor(9) &
    ,G0tensor(374),G0tensor(304),G0tensor(87)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(420),G2tensor(242),G2tensor(194),G2tensor(110),G2tensor(61),G1tensor(370) &
    ,G1tensor(300),G1tensor(15),G0tensor(379),G0tensor(309),G0tensor(89)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(223),G2tensor(221),G2tensor(65),G1tensor(332),G1tensor(124),G1tensor(71) &
    ,G0tensor(341),G0tensor(134),G0tensor(97)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(335),G2tensor(69),G1tensor(305),G1tensor(59),G0tensor(314),G0tensor(98)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(137),G2tensor(229),G2tensor(227),G2tensor(73),G1tensor(342),G1tensor(81) &
    ,G1tensor(17),G0tensor(351),G0tensor(139),G0tensor(107)])
  call ol_merge_tensors(G2tensor(459),[G2tensor(139),G2tensor(338),G2tensor(77),G1tensor(310),G1tensor(22),G0tensor(319) &
    ,G0tensor(108)])
  call ol_merge_tensors(G2tensor(465),[G2tensor(141),G2tensor(235),G2tensor(233),G2tensor(81),G1tensor(357),G1tensor(89) &
    ,G1tensor(33),G0tensor(366),G0tensor(144),G0tensor(117)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(357),G2tensor(341),G2tensor(85),G1tensor(315),G1tensor(209),G1tensor(35) &
    ,G0tensor(324),G0tensor(218),G0tensor(118)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(241),G2tensor(239),G2tensor(89),G1tensor(367),G1tensor(105),G1tensor(58) &
    ,G0tensor(376),G0tensor(149),G0tensor(127)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(344),G2tensor(93),G1tensor(320),G1tensor(148),G0tensor(329),G0tensor(128)])
  call ol_merge_tensors(G2tensor(383),[G2tensor(365),G2tensor(119),G2tensor(111),G1tensor(415),G1tensor(375),G1tensor(125) &
    ,G0tensor(424),G0tensor(384),G0tensor(157)])
  call ol_merge_tensors(G2tensor(330),[G2tensor(255),G2tensor(272),G2tensor(248),G2tensor(120),G2tensor(112),G1tensor(420) &
    ,G1tensor(380),G1tensor(131),G0tensor(429),G0tensor(389),G0tensor(159)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(371),G2tensor(121),G2tensor(113),G1tensor(425),G1tensor(385),G1tensor(158) &
    ,G0tensor(434),G0tensor(394),G0tensor(167)])
  call ol_merge_tensors(G2tensor(339),[G2tensor(192),G2tensor(267),G2tensor(91),G2tensor(278),G2tensor(254),G2tensor(122) &
    ,G2tensor(114),G1tensor(430),G1tensor(390),G1tensor(160),G0tensor(439),G0tensor(399),G0tensor(169)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(374),G2tensor(123),G2tensor(115),G1tensor(435),G1tensor(395),G1tensor(168) &
    ,G0tensor(444),G0tensor(404),G0tensor(177)])
  call ol_merge_tensors(G2tensor(342),[G2tensor(333),G2tensor(273),G2tensor(261),G2tensor(434),G2tensor(431),G2tensor(284) &
    ,G2tensor(260),G2tensor(124),G2tensor(116),G1tensor(440),G1tensor(400),G1tensor(220),G1tensor(170),G0tensor(449),G0tensor(409) &
    ,G0tensor(229),G0tensor(179)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(380),G2tensor(125),G2tensor(117),G1tensor(445),G1tensor(405),G1tensor(178) &
    ,G0tensor(454),G0tensor(414),G0tensor(187)])
  call ol_merge_tensors(G2tensor(336),[G2tensor(95),G2tensor(290),G2tensor(266),G2tensor(126),G2tensor(118),G1tensor(450) &
    ,G1tensor(410),G1tensor(180),G0tensor(459),G0tensor(419),G0tensor(189)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(348),G2tensor(401),G2tensor(127),G1tensor(455),G1tensor(208),G0tensor(464) &
    ,G0tensor(217)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(147),G2tensor(404),G2tensor(128),G1tensor(460),G1tensor(218),G0tensor(469) &
    ,G0tensor(227)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(14),G3tensor(13),G2tensor(464),G2tensor(461),G2tensor(458) &
    ,G2tensor(455),G1tensor(506),G1tensor(501),G0tensor(479),G0tensor(474)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17),G2tensor(470),G2tensor(467),G1tensor(511),G0tensor(484)])
  call ol_merge_tensors(G3tensor(64),[G3tensor(62),G3tensor(56),G3tensor(55),G3tensor(50),G3tensor(49),G3tensor(46),G3tensor(45) &
    ,G2tensor(215),G2tensor(212),G2tensor(203),G2tensor(199),G2tensor(197),G2tensor(167),G2tensor(164),G2tensor(155),G2tensor(151) &
    ,G2tensor(149),G1tensor(227),G1tensor(45),G1tensor(154),G1tensor(152),G1tensor(26),G1tensor(85),G1tensor(25),G0tensor(236) &
    ,G0tensor(124),G0tensor(104),G0tensor(94),G0tensor(44),G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(58),G3tensor(54),G3tensor(52),G3tensor(48),G3tensor(47),G3tensor(44),G3tensor(43) &
    ,G2tensor(218),G2tensor(208),G2tensor(206),G2tensor(170),G2tensor(160),G2tensor(158),G1tensor(242),G1tensor(34),G1tensor(145) &
    ,G0tensor(251),G0tensor(114),G0tensor(34)])
  call ol_merge_tensors(G2tensor(189),[G2tensor(175),G2tensor(173),G1tensor(262),G1tensor(96),G0tensor(271),G0tensor(54)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(63),G2tensor(181),G2tensor(179),G1tensor(272),G1tensor(74),G0tensor(281) &
    ,G0tensor(64)])
  call ol_merge_tensors(G2tensor(423),[G2tensor(195),G2tensor(296),G2tensor(293),G2tensor(187),G2tensor(185),G1tensor(287) &
    ,G1tensor(205),G1tensor(102),G0tensor(296),G0tensor(214),G0tensor(74)])
  call ol_merge_tensors(G2tensor(411),[G2tensor(193),G2tensor(191),G1tensor(297),G1tensor(122),G0tensor(306),G0tensor(84)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(247),G2tensor(245),G1tensor(377),G1tensor(117),G0tensor(386),G0tensor(154)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(237),G2tensor(253),G2tensor(251),G1tensor(387),G1tensor(147),G0tensor(396) &
    ,G0tensor(164)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(243),G2tensor(302),G2tensor(299),G2tensor(259),G2tensor(257),G1tensor(397) &
    ,G1tensor(215),G1tensor(165),G0tensor(406),G0tensor(224),G0tensor(174)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(265),G2tensor(263),G1tensor(407),G1tensor(175),G0tensor(416),G0tensor(184)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(304),G1tensor(222),G1tensor(19),G0tensor(231),G0tensor(13)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(6),G2tensor(307),G1tensor(232),G1tensor(79),G0tensor(241),G0tensor(23)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(7),G2tensor(310),G1tensor(237),G1tensor(214),G1tensor(139),G0tensor(246) &
    ,G0tensor(223),G0tensor(33)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(313),G1tensor(247),G1tensor(24),G0tensor(256),G0tensor(43)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(316),G1tensor(252),G1tensor(42),G0tensor(261),G0tensor(52)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(19),G2tensor(367),G2tensor(319),G1tensor(257),G1tensor(174),G1tensor(143) &
    ,G1tensor(113),G1tensor(120),G1tensor(72),G1tensor(44),G0tensor(266),G0tensor(183),G0tensor(163),G0tensor(153),G0tensor(83) &
    ,G0tensor(63),G0tensor(53)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(322),G1tensor(267),G1tensor(68),G0tensor(276),G0tensor(62)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(325),G1tensor(277),G1tensor(98),G0tensor(286),G0tensor(72)])
  call ol_merge_tensors(G3tensor(29),[G3tensor(21),G2tensor(376),G2tensor(328),G1tensor(282),G1tensor(164),G1tensor(126) &
    ,G0tensor(291),G0tensor(173),G0tensor(73)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(331),G1tensor(292),G1tensor(144),G0tensor(301),G0tensor(82)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(334),G1tensor(302),G1tensor(150),G0tensor(311),G0tensor(93)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(38),G2tensor(337),G1tensor(307),G1tensor(10),G0tensor(316),G0tensor(103)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(39),G2tensor(340),G1tensor(312),G1tensor(204),G1tensor(46),G0tensor(321) &
    ,G0tensor(213),G0tensor(113)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(343),G1tensor(317),G1tensor(41),G0tensor(326),G0tensor(123)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(346),G1tensor(322),G1tensor(303),G1tensor(142),G0tensor(331),G0tensor(312) &
    ,G0tensor(132)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(23),G2tensor(385),G2tensor(349),G1tensor(327),G1tensor(228),G1tensor(199) &
    ,G1tensor(189),G1tensor(184),G1tensor(101),G1tensor(77),G1tensor(130),G0tensor(336),G0tensor(237),G0tensor(208),G0tensor(198) &
    ,G0tensor(193),G0tensor(148),G0tensor(138),G0tensor(133)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(352),G1tensor(337),G1tensor(308),G1tensor(76),G0tensor(346),G0tensor(317) &
    ,G0tensor(137)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(355),G1tensor(453),G1tensor(347),G1tensor(313),G1tensor(136),G0tensor(462) &
    ,G0tensor(356),G0tensor(322),G0tensor(142)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(25),G2tensor(394),G2tensor(358),G1tensor(352),G1tensor(243),G1tensor(194) &
    ,G1tensor(88),G0tensor(361),G0tensor(252),G0tensor(203),G0tensor(143)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(361),G1tensor(362),G1tensor(318),G1tensor(99),G0tensor(371),G0tensor(327) &
    ,G0tensor(147)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(364),G1tensor(372),G1tensor(155),G0tensor(381),G0tensor(152)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(370),G1tensor(382),G1tensor(141),G0tensor(391),G0tensor(162)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(373),G1tensor(392),G1tensor(163),G0tensor(401),G0tensor(172)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(379),G1tensor(402),G1tensor(173),G0tensor(411),G0tensor(182)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(382),G1tensor(412),G1tensor(223),G1tensor(183),G0tensor(421),G0tensor(232) &
    ,G0tensor(192)])
  call ol_merge_tensors(G2tensor(405),[G2tensor(388),G1tensor(422),G1tensor(233),G1tensor(188),G0tensor(431),G0tensor(242) &
    ,G0tensor(197)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(391),G1tensor(458),G1tensor(432),G1tensor(238),G1tensor(193),G0tensor(467) &
    ,G0tensor(441),G0tensor(247),G0tensor(202)])
  call ol_merge_tensors(G2tensor(429),[G2tensor(397),G1tensor(442),G1tensor(248),G1tensor(198),G0tensor(451),G0tensor(257) &
    ,G0tensor(207)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(150),G2tensor(400),G1tensor(452),G1tensor(203),G0tensor(461),G0tensor(212)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(318),G2tensor(403),G1tensor(457),G1tensor(213),G0tensor(466),G0tensor(222)])
  call ol_merge_tensors(G3tensor(37),[G3tensor(35),G2tensor(457),G2tensor(454),G1tensor(509),G1tensor(498),G0tensor(482) &
    ,G0tensor(471)])
  call ol_merge_tensors(G3tensor(41),[G3tensor(39),G2tensor(463),G2tensor(460),G1tensor(503),G0tensor(476)])
  call ol_merge_tensors(G3tensor(63),[G3tensor(61),G3tensor(59),G3tensor(57),G3tensor(53),G3tensor(51),G2tensor(469),G2tensor(466) &
    ,G1tensor(508),G0tensor(481)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(20),G1tensor(409),G1tensor(389),G1tensor(379),G1tensor(319),G1tensor(309) &
    ,G1tensor(304),G1tensor(299),G1tensor(274),G1tensor(264),G1tensor(259),G1tensor(249),G1tensor(234),G1tensor(229),G1tensor(224) &
    ,G0tensor(418),G0tensor(398),G0tensor(388),G0tensor(328),G0tensor(318),G0tensor(313),G0tensor(308),G0tensor(283),G0tensor(273) &
    ,G0tensor(268),G0tensor(258),G0tensor(243),G0tensor(238),G0tensor(233)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(22),G1tensor(399),G1tensor(314),G1tensor(289),G1tensor(284),G1tensor(244) &
    ,G1tensor(239),G0tensor(408),G0tensor(323),G0tensor(298),G0tensor(293),G0tensor(253),G0tensor(248)])
  call ol_merge_tensors(G3tensor(69),[G3tensor(65),G1tensor(403),G1tensor(383),G1tensor(373),G1tensor(293),G1tensor(268) &
    ,G1tensor(258),G1tensor(253),G0tensor(412),G0tensor(392),G0tensor(382),G0tensor(302),G0tensor(277),G0tensor(267) &
    ,G0tensor(262)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(263),G1tensor(254),G0tensor(272),G0tensor(263)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(273),G1tensor(269),G0tensor(282),G0tensor(278)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(66),G1tensor(393),G1tensor(283),G1tensor(278),G0tensor(402),G0tensor(292) &
    ,G0tensor(287)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(454),G1tensor(288),G1tensor(279),G0tensor(463),G0tensor(297),G0tensor(288)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(298),G1tensor(294),G0tensor(307),G0tensor(303)])
  call ol_merge_tensors(G3tensor(71),[G3tensor(67),G1tensor(443),G1tensor(423),G1tensor(413),G1tensor(363),G1tensor(338) &
    ,G1tensor(328),G1tensor(323),G0tensor(452),G0tensor(432),G0tensor(422),G0tensor(372),G0tensor(347),G0tensor(337) &
    ,G0tensor(332)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(333),G1tensor(324),G0tensor(342),G0tensor(333)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(24),G1tensor(449),G1tensor(429),G1tensor(419),G1tensor(369),G1tensor(344) &
    ,G1tensor(334),G1tensor(329),G0tensor(458),G0tensor(438),G0tensor(428),G0tensor(378),G0tensor(353),G0tensor(343) &
    ,G0tensor(338)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(343),G1tensor(339),G0tensor(352),G0tensor(348)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(68),G1tensor(433),G1tensor(353),G1tensor(348),G0tensor(442),G0tensor(362) &
    ,G0tensor(357)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(358),G1tensor(349),G0tensor(367),G0tensor(358)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(26),G1tensor(439),G1tensor(359),G1tensor(354),G0tensor(448),G0tensor(368) &
    ,G0tensor(363)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(368),G1tensor(364),G0tensor(377),G0tensor(373)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(378),G1tensor(374),G0tensor(387),G0tensor(383)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(388),G1tensor(384),G0tensor(397),G0tensor(393)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(459),G1tensor(398),G1tensor(394),G0tensor(468),G0tensor(407),G0tensor(403)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(408),G1tensor(404),G0tensor(417),G0tensor(413)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(418),G1tensor(414),G0tensor(427),G0tensor(423)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(428),G1tensor(424),G0tensor(437),G0tensor(433)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(438),G1tensor(434),G0tensor(447),G0tensor(443)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(448),G1tensor(444),G0tensor(457),G0tensor(453)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(464)])
  call ol_merge_tensors(G1tensor(473),[G1tensor(465)])
  call ol_merge_tensors(G1tensor(488),[G1tensor(468)])
  call ol_merge_tensors(G1tensor(477),[G1tensor(469)])
  call ol_merge_tensors(G1tensor(491),[G1tensor(470)])
  call ol_merge_tensors(G1tensor(487),[G1tensor(474)])
  call ol_merge_tensors(G1tensor(495),[G1tensor(478)])
  call ol_merge_tensors(G1tensor(485),[G1tensor(481)])
  call ol_merge_tensors(G1tensor(496),[G1tensor(484)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(73),G1tensor(499),G0tensor(472)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(36),G1tensor(500),G0tensor(473)])
  call ol_merge_tensors(G3tensor(76),[G3tensor(75),G1tensor(504),G0tensor(477)])
  call ol_merge_tensors(G3tensor(42),[G3tensor(40),G1tensor(510),G1tensor(505),G0tensor(483),G0tensor(478)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(285)])
  call ol_merge_tensors(G2tensor(432),[G2tensor(294)])
  call ol_merge_tensors(G2tensor(375),[G2tensor(321)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(180)])
  call TI_triangle_red(G2tensor(436),RedBasis(49),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20), &
    G0tensor(25),M2L1R1,[nMH,nMB],G0tensor(30),G0tensor(35))
  call TI_triangle_red(G2tensor(448),RedBasis(49),mass3set(:,2),G0tensor(40),G0tensor(45),G0tensor(50), &
    G0tensor(55),M2L1R1,[nMZ,nMB],G0tensor(60),G0tensor(65))
  call TI_triangle_red(G2tensor(451),RedBasis(49),mass3set(:,3),G0tensor(70),G0tensor(75),G0tensor(80), &
    G0tensor(85),M2L1R1,[nMW,nMT],G0tensor(90),G0tensor(95))
  call TI_triangle_red(G2tensor(445),RedBasis(49),mass3set(:,4),G0tensor(100),G0tensor(105),G0tensor(110), &
    G0tensor(115),M2L1R1,[nMB],G0tensor(120))
  call TI_triangle_red(G2tensor(34),RedBasis(46),mass3set(:,5),G0tensor(125),G0tensor(130),G0tensor(135), &
    G0tensor(140),M2L1R1,[nMB,nMH],G0tensor(145),G0tensor(150))
  call TI_triangle_red(G2tensor(417),RedBasis(46),mass3set(:,6),G0tensor(155),G0tensor(160),G0tensor(165), &
    G0tensor(170),M2L1R1,[nMB,nMZ],G0tensor(175),G0tensor(180))
  call TI_triangle_red(G2tensor(46),RedBasis(46),mass3set(:,7),G0tensor(185),G0tensor(190),G0tensor(195), &
    G0tensor(200),M2L1R1,[nMT,nMW],G0tensor(205),G0tensor(210))
  call TI_triangle_red(G2tensor(204),RedBasis(46),mass3set(:,8),G0tensor(215),G0tensor(220),G0tensor(225), &
    G0tensor(230),M2L1R1,[nMB],G0tensor(235))
  call TI_triangle_red(G2tensor(412),RedBasis(50),mass3set(:,1),G0tensor(240),G0tensor(245),G0tensor(250), &
    G0tensor(255),M2L1R1,[nMH,nMB],G0tensor(260),G0tensor(265))
  call TI_triangle_red(G2tensor(424),RedBasis(50),mass3set(:,2),G0tensor(270),G0tensor(275),G0tensor(280), &
    G0tensor(285),M2L1R1,[nMZ,nMB],G0tensor(290),G0tensor(295))
  call TI_triangle_red(G2tensor(427),RedBasis(50),mass3set(:,3),G0tensor(300),G0tensor(305),G0tensor(310), &
    G0tensor(315),M2L1R1,[nMW,nMT],G0tensor(320),G0tensor(325))
  call TI_triangle_red(G2tensor(421),RedBasis(50),mass3set(:,4),G0tensor(330),G0tensor(335),G0tensor(340), &
    G0tensor(345),M2L1R1,[nMB],G0tensor(350))
  call TI_triangle_red(G2tensor(2),RedBasis(41),mass3set(:,5),G0tensor(355),G0tensor(360),G0tensor(365), &
    G0tensor(370),M2L1R1,[nMB,nMH],G0tensor(375),G0tensor(380))



end subroutine vamp_3

end module ol_vamp_3_ppajj_ew_bbxagg_1_/**/REALKIND
