
module ol_vamp_3_ppajj_ew_ddxaag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_ddxaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_ddxaag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_ddxaag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_ddxaag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_ddxaag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_ddxaag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(1,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call TI_triangle_red(G3tensor(10),RedBasis(11),mass3set(:,13),G0tensor(541),G0tensor(542),G0tensor(543), &
    G0tensor(544),M2L1R1,[nML],G0tensor(545))
  call TI_triangle_red(G3tensor(12),RedBasis(11),mass3set(:,14),G0tensor(546),G0tensor(547),G0tensor(548), &
    G0tensor(549),M2L1R1,[nMT],G0tensor(550))
  call TI_triangle_red(G3tensor(14),RedBasis(11),mass3set(:,15),G0tensor(551),G0tensor(552),G0tensor(553), &
    G0tensor(554),M2L1R1,[nMB],G0tensor(555))
  call ol_merge_tensors(T0sum(89),[G0tensor(1)])
  call ol_merge_tensors(T0sum(90),[G0tensor(21)])
  call ol_merge_tensors(T0sum(91),[G0tensor(46)])
  call ol_merge_tensors(T0sum(92),[G0tensor(71)])
  call ol_merge_tensors(T0sum(93),[G0tensor(91)])
  call ol_merge_tensors(T0sum(94),[G0tensor(116)])
  call ol_merge_tensors(T0sum(95),[G0tensor(141)])
  call ol_merge_tensors(T0sum(96),[G0tensor(161)])
  call ol_merge_tensors(T0sum(97),[G0tensor(186)])
  call ol_merge_tensors(T0sum(98),[G0tensor(211)])
  call ol_merge_tensors(T0sum(99),[G0tensor(231)])
  call ol_merge_tensors(T0sum(100),[G0tensor(256)])
  call ol_merge_tensors(T0sum(101),[G0tensor(281)])
  call ol_merge_tensors(T0sum(102),[G0tensor(306)])
  call ol_merge_tensors(T0sum(103),[G0tensor(331)])
  call ol_merge_tensors(T0sum(104),[G0tensor(356)])
  call ol_merge_tensors(T0sum(105),[G0tensor(381)])
  call ol_merge_tensors(T0sum(106),[G0tensor(401)])
  call ol_merge_tensors(T0sum(107),[G0tensor(421)])
  call ol_merge_tensors(T0sum(108),[G0tensor(27)])
  call ol_merge_tensors(T0sum(109),[G0tensor(47)])
  call ol_merge_tensors(T0sum(110),[G0tensor(52)])
  call ol_merge_tensors(T0sum(111),[G0tensor(122)])
  call ol_merge_tensors(T0sum(112),[G0tensor(82)])
  call ol_merge_tensors(T0sum(113),[G0tensor(107)])
  call ol_merge_tensors(T0sum(114),[G0tensor(127)])
  call ol_merge_tensors(T0sum(115),[G0tensor(137)])
  call ol_merge_tensors(T0sum(116),[G0tensor(43)])
  call ol_merge_tensors(T0sum(117),[G0tensor(427)])
  call ol_merge_tensors(T0sum(118),[G0tensor(2)])
  call ol_merge_tensors(T0sum(119),[G0tensor(367)])
  call ol_merge_tensors(T0sum(120),[G0tensor(29)])
  call ol_merge_tensors(T0sum(121),[G0tensor(90)])
  call ol_merge_tensors(T0sum(122),[G0tensor(165)])
  call ol_merge_tensors(T0sum(123),[G0tensor(200)])
  call ol_merge_tensors(T0sum(124),[G0tensor(49)])
  call ol_merge_tensors(T0sum(125),[G0tensor(305)])
  call ol_merge_tensors(T0sum(126),[G0tensor(134)])
  call ol_merge_tensors(T0sum(127),[G0tensor(310)])
  call ol_merge_tensors(T0sum(128),[G0tensor(68)])
  call ol_merge_tensors(T0sum(129),[G0tensor(275)])
  call ol_merge_tensors(T0sum(130),[G0tensor(180)])
  call ol_merge_tensors(T0sum(131),[G0tensor(285)])
  call ol_merge_tensors(T0sum(132),[G0tensor(290)])
  call ol_merge_tensors(T0sum(133),[G0tensor(108)])
  call ol_merge_tensors(T0sum(134),[G0tensor(335)])
  call ol_merge_tensors(T0sum(135),[G0tensor(375)])
  call ol_merge_tensors(T0sum(136),[G0tensor(145)])
  call ol_merge_tensors(T0sum(137),[G0tensor(360)])
  call ol_merge_tensors(T0sum(138),[G0tensor(10)])
  call ol_merge_tensors(T0sum(139),[G0tensor(188)])
  call ol_merge_tensors(T0sum(140),[G0tensor(8)])
  call ol_merge_tensors(T0sum(141),[G0tensor(225)])
  call ol_merge_tensors(T0sum(142),[G0tensor(95)])
  call ol_merge_tensors(T0sum(143),[G0tensor(257)])
  call ol_merge_tensors(T0sum(144),[G0tensor(175)])
  call ol_merge_tensors(T0sum(145),[G0tensor(140)])
  call ol_merge_tensors(T0sum(146),[G0tensor(15)])
  call ol_merge_tensors(T0sum(147),[G0tensor(439)])
  call ol_merge_tensors(T0sum(148),[G0tensor(13)])
  call ol_merge_tensors(T0sum(149),[G0tensor(237)])
  call ol_merge_tensors(T0sum(150),[G0tensor(44)])
  call ol_merge_tensors(T0sum(151),[G0tensor(139)])
  call ol_merge_tensors(T0sum(152),[G0tensor(262)])
  call ol_merge_tensors(T0sum(153),[G0tensor(272)])
  call ol_merge_tensors(T0sum(154),[G0tensor(287)])
  call ol_merge_tensors(T0sum(155),[G0tensor(297)])
  call ol_merge_tensors(T0sum(156),[G0tensor(169)])
  call ol_merge_tensors(T0sum(157),[G0tensor(119)])
  call ol_merge_tensors(T0sum(158),[G0tensor(393)])
  call ol_merge_tensors(T0sum(159),[G0tensor(128)])
  call ol_merge_tensors(T0sum(160),[G0tensor(413)])
  call ol_merge_tensors(T0sum(161),[G0tensor(228)])
  call ol_merge_tensors(T0sum(162),[G0tensor(408)])
  call ol_merge_tensors(T0sum(163),[G0tensor(173)])
  call ol_merge_tensors(T0sum(164),[G0tensor(184)])
  call ol_merge_tensors(T0sum(165),[G0tensor(412)])
  call ol_merge_tensors(T0sum(166),[G0tensor(199)])
  call ol_merge_tensors(T0sum(167),[G0tensor(440)])
  call ol_merge_tensors(T0sum(168),[G0tensor(214)])
  call ol_merge_tensors(T0sum(169),[G0tensor(294)])
  call ol_merge_tensors(T0sum(170),[G0tensor(259)])
  call ol_merge_tensors(T0sum(171),[G0tensor(229)])
  call ol_merge_tensors(T0sum(172),[G0tensor(263)])
  call ol_merge_tensors(T0sum(173),[G0tensor(268)])
  call ol_merge_tensors(T0sum(174),[G0tensor(383)])
  call ol_merge_tensors(T0sum(175),[G0tensor(303)])
  call ol_merge_tensors(T0sum(176),[G0tensor(404)])
  call ol_merge_tensors(T0sum(177),[G0tensor(319)])
  call ol_merge_tensors(T0sum(178),[G0tensor(399)])
  call ol_merge_tensors(T0sum(179),[G0tensor(348)])
  call ol_merge_tensors(T0sum(180),[G0tensor(368)])
  call ol_merge_tensors(T0sum(181),[G0tensor(414)])
  call ol_merge_tensors(T0sum(182),[G0tensor(424)])
  call ol_merge_tensors(T0sum(183),[G0tensor(443)])
  call ol_merge_tensors(T0sum(184),[G0tensor(448)])
  call ol_merge_tensors(T0sum(185),[G0tensor(453)])
  call ol_merge_tensors(T0sum(186),[G0tensor(457)])
  call ol_merge_tensors(T0sum(187),[G0tensor(461)])
  call ol_merge_tensors(T0sum(188),[G0tensor(465)])
  call ol_merge_tensors(T0sum(189),[G0tensor(470)])
  call ol_merge_tensors(T0sum(190),[G0tensor(475)])
  call ol_merge_tensors(T0sum(191),[G0tensor(479)])
  call ol_merge_tensors(T0sum(192),[G0tensor(484)])
  call ol_merge_tensors(T0sum(193),[G0tensor(489)])
  call ol_merge_tensors(T0sum(194),[G0tensor(493)])
  call ol_merge_tensors(T0sum(195),[G0tensor(498)])
  call ol_merge_tensors(T0sum(196),[G0tensor(503)])
  call ol_merge_tensors(T0sum(197),[G0tensor(508)])
  call ol_merge_tensors(T0sum(198),[G0tensor(513)])
  call ol_merge_tensors(T0sum(199),[G0tensor(517)])
  call ol_merge_tensors(T0sum(200),[G0tensor(522)])
  call ol_merge_tensors(T0sum(201),[G0tensor(526)])
  call ol_merge_tensors(T0sum(202),[G0tensor(531)])
  call ol_merge_tensors(T0sum(203),[G0tensor(536)])
  call ol_merge_tensors(T0sum(204),[G0tensor(541)])
  call ol_merge_tensors(T0sum(205),[G0tensor(546)])
  call ol_merge_tensors(T0sum(206),[G0tensor(551)])
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[27,4],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,37),G0H2(4),m4h2x8x2(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[27,4],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,38),G0H2(3),m4h2x8x2(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[27,4],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,37),G0H2(1),m4h2x8x2(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[27,4],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,38),G0H2(2),m4h2x8x2(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(5),m4h2x8x2(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(6),m4h2x8x2(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(7),m4h2x8x2(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(8),m4h2x8x2(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[23,8],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,37),G0H2(9),m4h2x8x2(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[23,8],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,38),G0H2(10),m4h2x8x2(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[23,8],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,37),G0H2(11),m4h2x8x2(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[23,8],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,38),G0H2(12),m4h2x8x2(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(13),m4h2x8x2(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(14),m4h2x8x2(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(15),m4h2x8x2(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(16),m4h2x8x2(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[19,12],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,37),19,G1H4(41),m3h8x4(:,169),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[19,12],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,38),19,G1H4(6),m3h8x4(:,170),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[19,12],[nMW,nMW],3,1,wf8(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,37),19,G1H4(1),m3h8x4(:,171),heltab2x32(:,:,286))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[19,12],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,38),19,G1H4(8),m3h8x4(:,172),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[19,12],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(12),m3h8x4(:,173),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(129),m3h8x4(:,174),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[19,12],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(47),m3h8x4(:,175),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(126),m3h8x4(:,176),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[21,10],[0,0],2,2,wf8(:,21),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,21),G0H4(57),m3h8x4(:,177),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(57),21,0,G1H4(132),n2h4(121))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[21,10],[0,nMZ],2,2,wf8(:,21),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,21),G0H4(1),ngZd,m3h8x4(:,178),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(9),n2h4(122))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[21,10],[0,nMW],2,2,wf8(:,21),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,21),G0H4(2),m3h8x4(:,179),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(2),21,0,G1H4(18),n2h4(123))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[26,5],[0,0],2,2,wf8(:,20),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,20),G0H4(3),m3h8x4(:,180),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(133),n2h4(124))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[26,5],[0,nMZ],2,2,wf8(:,20),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,20),G0H4(4),ngZd,m3h8x4(:,181),heltab2x32(:,:,296))
  call Hloop_A_Q(ntryL,G0H4(4),26,0,G1H4(53),n2h4(125))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[26,5],[0,nMW],2,2,wf8(:,20),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,20),G0H4(5),m3h8x4(:,182),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(23),n2h4(126))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[18,13],[0,0],2,2,wf4(:,6),wf8(:,24))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,43),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,24))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(10),ngZd,m3h4x8(:,44),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,24))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,45),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[26,5],[0,0],2,2,wf8(:,23),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,23),G0H4(6),m3h8x4(:,183),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H4(6),26,0,G1H4(134),n2h4(127))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[26,5],[0,nMZ],2,2,wf8(:,23),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,23),G0H4(7),ngZd,m3h8x4(:,184),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H4(7),26,0,G1H4(10),n2h4(128))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[26,5],[0,nMW],2,2,wf8(:,23),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,23),G0H4(8),m3h8x4(:,185),heltab2x32(:,:,303))
  call Hloop_A_Q(ntryL,G0H4(8),26,0,G1H4(30),n2h4(129))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[25,6],[0,0],2,2,wf8(:,27),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,27),G0H4(9),m3h8x4(:,186),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H4(9),25,0,G1H4(135),n2h4(130))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[25,6],[0,nMZ],2,2,wf8(:,27),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,27),G0H4(10),ngZd,m3h8x4(:,187),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(10),25,0,G1H4(120),n2h4(131))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[25,6],[0,nMW],2,2,wf8(:,27),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,27),G0H4(11),m3h8x4(:,188),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G0H4(11),25,0,G1H4(15),n2h4(132))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[22,9],[0,0],2,2,wf8(:,26),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,26),G0H4(12),m3h8x4(:,189),heltab2x32(:,:,307))
  call Hloop_A_Q(ntryL,G0H4(12),22,0,G1H4(40),n2h4(133))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[22,9],[0,nMZ],2,2,wf8(:,26),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,26),G0H4(35),ngZd,m3h8x4(:,190),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G0H4(35),22,0,G1H4(48),n2h4(134))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[22,9],[0,nMW],2,2,wf8(:,26),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,191),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H4(15),22,0,G1H4(24),n2h4(135))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[25,6],[0,0],2,2,wf8(:,30),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(13),m3h8x4(:,192),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(143),n2h4(136))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[25,6],[0,nMZ],2,2,wf8(:,30),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(36),ngZd,m3h8x4(:,193),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H4(36),25,0,G1H4(138),n2h4(137))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[25,6],[0,nMW],2,2,wf8(:,30),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,30),G0H4(16),m3h8x4(:,194),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H4(16),25,0,G1H4(72),n2h4(138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[17,14],[0,0],2,2,wf4(:,12),wf8(:,29))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(12),m3h4x8(:,46),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,29))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(14),ngZd,m3h4x8(:,47),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,29))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(15),m3h4x8(:,48),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[18,13],[0,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(1),m3h4x8(:,49),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngZd,m3h4x8(:,50),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,51),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[22,9],[0,0],2,2,wf8(:,32),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(14),m3h8x4(:,195),heltab2x32(:,:,319))
  call Hloop_A_Q(ntryL,G0H4(14),22,0,G1H4(29),n2h4(139))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[22,9],[0,nMZ],2,2,wf8(:,32),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(39),ngZd,m3h8x4(:,196),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H4(39),22,0,G1H4(139),n2h4(140))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[22,9],[0,nMW],2,2,wf8(:,32),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(19),m3h8x4(:,197),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H4(19),22,0,G1H4(130),n2h4(141))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[21,10],[0,0],2,2,wf8(:,36),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,36),G0H4(17),m3h8x4(:,198),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(17),21,0,G1H4(16),n2h4(142))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[21,10],[0,nMZ],2,2,wf8(:,36),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,36),G0H4(40),ngZd,m3h8x4(:,199),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H4(40),21,0,G1H4(43),n2h4(143))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[21,10],[0,nMW],2,2,wf8(:,36),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,36),G0H4(20),m3h8x4(:,200),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H4(20),21,0,G1H4(54),n2h4(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[17,14],[0,0],2,2,wf4(:,12),wf8(:,35))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,52),heltab2x32(:,:,325))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,35))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(6),ngZd,m3h4x8(:,53),heltab2x32(:,:,326))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,35))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,54),heltab2x32(:,:,327))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(5),G0H2(3),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(8),[G0H2(7),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(14),[G0H2(13),G0H2(10),G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(15),G0H2(12),G0H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(12),G1H4(6),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(47),G1H4(8),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(24)])
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(6),27,ex3(:),4,G1tensor(13),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(8),27,ex3(:),4,G1tensor(8),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(14),23,ex4(:),8,G1tensor(20),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(16),23,ex4(:),8,G1tensor(72),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(129),ex4(:),ex3(:),G1tensor(44),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(126),ex4(:),ex3(:),G1tensor(56),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(16),wf4(:,4),G1tensor(51),m3h4x1(:,55),heltab2x4(:,:,245))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(43),wf4(:,4),G1tensor(86),ngZd,m3h4x1(:,56),heltab2x4(:,:,246))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(54),wf4(:,4),G1tensor(96),m3h4x1(:,57),heltab2x4(:,:,247))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(134),wf4(:,3),G1tensor(15),m3h4x1(:,58),heltab2x4(:,:,248))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(10),wf4(:,3),G1tensor(122),ngZd,m3h4x1(:,59),heltab2x4(:,:,249))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(30),wf4(:,3),G1tensor(140),m3h4x1(:,60),heltab2x4(:,:,250))
  call Hloop_VQ_A(ntryL,G0H8(9),wf8(:,24),G0H1(1),m3h8x1(:,13),heltab2x8(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(9),n2h1(489))
  call Hloop_ZQ_A(ntryL,G0H8(10),wf8(:,24),G0H1(1),ngZd,m3h8x1(:,14),heltab2x8(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(53),n2h1(490))
  call Hloop_WQ_A(ntryL,G0H8(11),wf8(:,24),G0H1(1),m3h8x1(:,15),heltab2x8(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(136),n2h1(491))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(143),wf4(:,10),G1tensor(88),m3h4x1(:,61),heltab2x4(:,:,251))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(138),wf4(:,10),G1tensor(39),ngZd,m3h4x1(:,62),heltab2x4(:,:,252))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(72),wf4(:,10),G1tensor(52),m3h4x1(:,63),heltab2x4(:,:,253))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(29),wf4(:,9),G1tensor(118),m3h4x1(:,64),heltab2x4(:,:,254))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(139),wf4(:,9),G1tensor(70),ngZd,m3h4x1(:,65),heltab2x4(:,:,255))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(130),wf4(:,9),G1tensor(131),m3h4x1(:,66),heltab2x4(:,:,256))
  call Hloop_VA_Q(ntryL,G0H8(12),wf8(:,29),G0H1(1),m3h8x1(:,16),heltab2x8(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(95),n2h1(492))
  call Hloop_ZA_Q(ntryL,G0H8(14),wf8(:,29),G0H1(1),ngZd,m3h8x1(:,17),heltab2x8(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(107),n2h1(493))
  call Hloop_WA_Q(ntryL,G0H8(15),wf8(:,29),G0H1(1),m3h8x1(:,18),heltab2x8(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(119),n2h1(494))
  call Hloop_VQ_A(ntryL,G0H8(1),wf8(:,33),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(141),n2h1(495))
  call Hloop_ZQ_A(ntryL,G0H8(2),wf8(:,33),G0H1(1),ngZd,m3h8x1(:,20),heltab2x8(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(146),n2h1(496))
  call Hloop_WQ_A(ntryL,G0H8(3),wf8(:,33),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(151),n2h1(497))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,35),G0H1(1),m3h8x1(:,22),heltab2x8(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(156),n2h1(498))
  call Hloop_ZA_Q(ntryL,G0H8(6),wf8(:,35),G0H1(1),ngZd,m3h8x1(:,23),heltab2x8(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(161),n2h1(499))
  call Hloop_WA_Q(ntryL,G0H8(7),wf8(:,35),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(166),n2h1(500))
  call ol_merge_tensors(G0tensor(527),[G0tensor(523),G0tensor(518),G0tensor(514),G0tensor(500),G0tensor(495),G0tensor(491) &
    ,G0tensor(472),G0tensor(467),G0tensor(463),G0tensor(459),G0tensor(455),G0tensor(388),G0tensor(309),G0tensor(298),G0tensor(203) &
    ,G0tensor(223),G0tensor(183),G0tensor(113),G0tensor(292),G0tensor(282),G0tensor(403),G0tensor(215),G0tensor(426),G0tensor(191) &
    ,G0tensor(166),G0tensor(146),G0tensor(51),G0tensor(26),G0tensor(6)])
  call ol_merge_tensors(G0tensor(342),[G0tensor(159),G0tensor(63),G0tensor(19),G0tensor(79),G0tensor(97),G0tensor(386) &
    ,G0tensor(216),G0tensor(81),G0tensor(11)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(429),G0tensor(398),G0tensor(34),G0tensor(178),G0tensor(406),G0tensor(16)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(320),G0tensor(22),G0tensor(236),G0tensor(31)])
  call ol_merge_tensors(G1tensor(122),[G0tensor(247),G0tensor(42),G0tensor(36)])
  call ol_merge_tensors(G0tensor(530),[G0tensor(521),G0tensor(497),G0tensor(483),G0tensor(469),G0tensor(447),G0tensor(224) &
    ,G0tensor(193),G0tensor(163),G0tensor(118),G0tensor(104),G0tensor(149),G0tensor(25),G0tensor(205),G0tensor(325),G0tensor(265) &
    ,G0tensor(387),G0tensor(377),G0tensor(433),G0tensor(147),G0tensor(57),G0tensor(437),G0tensor(251),G0tensor(181),G0tensor(111) &
    ,G0tensor(41)])
  call ol_merge_tensors(G0tensor(75),[G0tensor(55),G0tensor(80),G0tensor(117),G0tensor(361),G0tensor(336),G0tensor(261) &
    ,G0tensor(56)])
  call ol_merge_tensors(G1tensor(140),[G0tensor(129),G0tensor(5),G0tensor(103),G0tensor(346),G0tensor(61)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(507),G0tensor(502),G0tensor(488),G0tensor(474),G0tensor(452),G0tensor(354) &
    ,G0tensor(334),G0tensor(314),G0tensor(329),G0tensor(419),G0tensor(313),G0tensor(274),G0tensor(249),G0tensor(273),G0tensor(234) &
    ,G0tensor(269),G0tensor(339),G0tensor(417),G0tensor(392),G0tensor(332),G0tensor(233),G0tensor(54),G0tensor(24),G0tensor(217) &
    ,G0tensor(3),G0tensor(212),G0tensor(347),G0tensor(277),G0tensor(420),G0tensor(390),G0tensor(350),G0tensor(135),G0tensor(365) &
    ,G0tensor(125),G0tensor(98),G0tensor(88),G0tensor(190),G0tensor(58),G0tensor(210),G0tensor(12),G0tensor(7),G0tensor(87) &
    ,G0tensor(62),G0tensor(376),G0tensor(351),G0tensor(326),G0tensor(301),G0tensor(276),G0tensor(206),G0tensor(136) &
    ,G0tensor(66)])
  call ol_merge_tensors(G0tensor(435),[G0tensor(397),G0tensor(242),G0tensor(395),G0tensor(255),G0tensor(160),G0tensor(23) &
    ,G0tensor(221),G0tensor(151),G0tensor(76)])
  call ol_merge_tensors(G0tensor(352),[G0tensor(73),G0tensor(155),G0tensor(102),G0tensor(271),G0tensor(246),G0tensor(226) &
    ,G0tensor(131),G0tensor(106),G0tensor(86)])
  call ol_merge_tensors(G0tensor(405),[G0tensor(50),G0tensor(422),G0tensor(171),G0tensor(96)])
  call ol_merge_tensors(G0tensor(158),[G0tensor(312),G0tensor(94),G0tensor(33),G0tensor(101)])
  call ol_merge_tensors(G0tensor(389),[G0tensor(415),G0tensor(170),G0tensor(438),G0tensor(311),G0tensor(286),G0tensor(196) &
    ,G0tensor(121)])
  call ol_merge_tensors(G0tensor(343),[G0tensor(244),G0tensor(284),G0tensor(382),G0tensor(293),G0tensor(283),G0tensor(187) &
    ,G0tensor(126)])
  call ol_merge_tensors(G1tensor(88),[G0tensor(476),G0tensor(402),G0tensor(164),G0tensor(232),G0tensor(235),G0tensor(156)])
  call ol_merge_tensors(G1tensor(39),[G0tensor(114),G0tensor(38),G0tensor(176)])
  call ol_merge_tensors(G1tensor(52),[G0tensor(504),G0tensor(322),G0tensor(9),G0tensor(296),G0tensor(201)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(407),G0tensor(53),G0tensor(260),G0tensor(241)])
  call ol_merge_tensors(G0tensor(409),[G0tensor(324),G0tensor(363),G0tensor(394),G0tensor(248),G0tensor(209),G0tensor(208) &
    ,G0tensor(74),G0tensor(78),G0tensor(266)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(13),G0tensor(510),G0tensor(253),G0tensor(289),G0tensor(14),G0tensor(4),G0tensor(357) &
    ,G0tensor(133),G0tensor(89),G0tensor(341),G0tensor(291)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(20),G0tensor(505),G0tensor(264),G0tensor(254),G0tensor(207),G0tensor(423) &
    ,G0tensor(195),G0tensor(345),G0tensor(99),G0tensor(366),G0tensor(316)])
  call ol_merge_tensors(G1tensor(96),[G0tensor(509),G0tensor(308),G0tensor(353),G0tensor(295),G0tensor(321)])
  call ol_merge_tensors(G1tensor(131),[G0tensor(304),G0tensor(373),G0tensor(222),G0tensor(385),G0tensor(371)])
  call ol_merge_tensors(G1tensor(51),[G0tensor(524),G0tensor(490),G0tensor(425),G0tensor(411),G0tensor(391)])
  call ol_merge_tensors(G0tensor(462),[G0tensor(323),G0tensor(333),G0tensor(362),G0tensor(245),G0tensor(30),G0tensor(230) &
    ,G0tensor(67),G0tensor(32),G0tensor(431),G0tensor(396)])
  call ol_merge_tensors(G0tensor(464),[G0tensor(374),G0tensor(358),G0tensor(153),G0tensor(109),G0tensor(115),G0tensor(70) &
    ,G0tensor(59),G0tensor(250),G0tensor(39),G0tensor(100),G0tensor(17),G0tensor(172),G0tensor(142),G0tensor(132),G0tensor(72) &
    ,G0tensor(83),G0tensor(436),G0tensor(416)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(204),G0tensor(112),G0tensor(37)])
  call ol_merge_tensors(G0tensor(499),[G0tensor(278),G0tensor(349),G0tensor(370),G0tensor(77),G0tensor(93)])
  call ol_merge_tensors(G0tensor(456),[G0tensor(434),G0tensor(330),G0tensor(60),G0tensor(154),G0tensor(182),G0tensor(167) &
    ,G0tensor(157),G0tensor(92)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(9),G0tensor(516),G0tensor(460),G0tensor(442),G0tensor(162),G0tensor(432)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(53),G0tensor(468),G0tensor(446),G0tensor(177),G0tensor(152)])
  call ol_merge_tensors(G1tensor(151),[G1tensor(136),G0tensor(473),G0tensor(451),G0tensor(185),G0tensor(120),G0tensor(197) &
    ,G0tensor(192)])
  call ol_merge_tensors(G1tensor(118),[G0tensor(515),G0tensor(458),G0tensor(418),G0tensor(110),G0tensor(28)])
  call ol_merge_tensors(G0tensor(466),[G0tensor(238),G0tensor(240),G0tensor(40)])
  call ol_merge_tensors(G0tensor(471),[G0tensor(239),G0tensor(168),G0tensor(317),G0tensor(300),G0tensor(48)])
  call ol_merge_tensors(G1tensor(156),[G1tensor(95),G0tensor(525),G0tensor(492),G0tensor(478),G0tensor(69),G0tensor(144)])
  call ol_merge_tensors(G1tensor(161),[G1tensor(107),G0tensor(496),G0tensor(482),G0tensor(270),G0tensor(315)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(119),G0tensor(501),G0tensor(487),G0tensor(338),G0tensor(380),G0tensor(340) &
    ,G0tensor(307),G0tensor(280)])
  call ol_merge_tensors(G0tensor(449),[G0tensor(279),G0tensor(302),G0tensor(220),G0tensor(179),G0tensor(327)])
  call ol_merge_tensors(G0tensor(485),[G0tensor(258),G0tensor(198),G0tensor(267),G0tensor(355),G0tensor(143)])
  call ol_merge_tensors(G0tensor(364),[G0tensor(123),G0tensor(288),G0tensor(124),G0tensor(84),G0tensor(64),G0tensor(252) &
    ,G0tensor(194),G0tensor(65),G0tensor(35),G0tensor(105),G0tensor(18),G0tensor(410),G0tensor(400),G0tensor(20)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(174),G0tensor(189)])
  call ol_merge_tensors(G0tensor(480),[G0tensor(218),G0tensor(45)])
  call ol_merge_tensors(G1tensor(56),[G1tensor(44),G0tensor(328),G0tensor(379),G0tensor(428),G0tensor(150),G0tensor(337)])
  call ol_merge_tensors(G0tensor(344),[G0tensor(318),G0tensor(227),G0tensor(202),G0tensor(130)])
  call ol_merge_tensors(G0tensor(486),[G0tensor(481),G0tensor(477),G0tensor(454),G0tensor(450),G0tensor(445),G0tensor(441) &
    ,G0tensor(384),G0tensor(378),G0tensor(359),G0tensor(213),G0tensor(430),G0tensor(243),G0tensor(372),G0tensor(148) &
    ,G0tensor(138)])
  call ol_merge_tensors(G0tensor(511),[G0tensor(506),G0tensor(369),G0tensor(299)])
  call ol_merge_tensors(G1tensor(70),[G0tensor(519)])
  call ol_merge_tensors(G1tensor(86),[G0tensor(528)])
call TI_bubble_red(G1tensor(15),26,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(122),26,mass2set(:,2),G0tensor(21),M2L1R1,G0tensor(46))
call TI_bubble_red(G1tensor(140),26,mass2set(:,3),G0tensor(71),M2L1R1,G0tensor(91))
call TI_bubble_red(G1tensor(88),25,mass2set(:,1),G0tensor(116),M2L1R1)
call TI_bubble_red(G1tensor(39),25,mass2set(:,2),G0tensor(141),M2L1R1,G0tensor(161))
call TI_bubble_red(G1tensor(52),25,mass2set(:,3),G0tensor(186),M2L1R1,G0tensor(211))
call TI_bubble_red(G1tensor(8),27,mass2set(:,4),G0tensor(231),M2L1R1,G0tensor(256))
call TI_bubble_red(G1tensor(72),23,mass2set(:,4),G0tensor(281),M2L1R1,G0tensor(306))
call TI_bubble_red(G1tensor(96),21,mass2set(:,3),G0tensor(331),M2L1R1,G0tensor(356))
call TI_bubble_red(G1tensor(131),22,mass2set(:,3),G0tensor(381),M2L1R1,G0tensor(401))
call TI_bubble_red(G1tensor(51),21,mass2set(:,1),G0tensor(421),M2L1R1)
call TI_bubble_red(G1tensor(141),18,mass2set(:,1),G0tensor(27),M2L1R1)
call TI_bubble_red(G1tensor(146),18,mass2set(:,5),G0tensor(47),M2L1R1,G0tensor(52))
call TI_bubble_red(G1tensor(151),18,mass2set(:,6),G0tensor(122),M2L1R1,G0tensor(82))
call TI_bubble_red(G1tensor(118),22,mass2set(:,1),G0tensor(107),M2L1R1)
call TI_bubble_red(G1tensor(156),17,mass2set(:,1),G0tensor(127),M2L1R1)
call TI_bubble_red(G1tensor(161),17,mass2set(:,5),G0tensor(137),M2L1R1,G0tensor(43))
call TI_bubble_red(G1tensor(166),17,mass2set(:,6),G0tensor(427),M2L1R1,G0tensor(2))
call TI_bubble_red(G1tensor(56),19,mass2set(:,4),G0tensor(367),M2L1R1,G0tensor(29))
call TI_bubble_red(G1tensor(70),22,mass2set(:,2),G0tensor(90),M2L1R1,G0tensor(165))
call TI_bubble_red(G1tensor(86),21,mass2set(:,2),G0tensor(200),M2L1R1,G0tensor(49))
  call ol_merge_tensors(G0tensor(49),[G0tensor(165),G0tensor(43),G0tensor(52),G0tensor(161),G0tensor(530),G0tensor(46)])
  call ol_merge_tensors(G0tensor(29),[G0tensor(2),G0tensor(82),G0tensor(401),G0tensor(356),G0tensor(306),G0tensor(256) &
    ,G0tensor(211),G0tensor(512),G0tensor(91)])
  call ol_merge_tensors(T0sum(207),[G0tensor(527)])
  call ol_merge_tensors(T0sum(208),[G0tensor(342)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1)])
  call ol_merge_tensors(T0sum(210),[G0tensor(85)])
  call ol_merge_tensors(T0sum(211),[G0tensor(21)])
  call ol_merge_tensors(T0sum(212),[G0tensor(49)])
  call ol_merge_tensors(T0sum(213),[G0tensor(75)])
  call ol_merge_tensors(T0sum(214),[G0tensor(71)])
  call ol_merge_tensors(T0sum(215),[G0tensor(29)])
  call ol_merge_tensors(T0sum(216),[G0tensor(435)])
  call ol_merge_tensors(T0sum(217),[G0tensor(352)])
  call ol_merge_tensors(T0sum(218),[G0tensor(405)])
  call ol_merge_tensors(T0sum(219),[G0tensor(158)])
  call ol_merge_tensors(T0sum(220),[G0tensor(389)])
  call ol_merge_tensors(T0sum(221),[G0tensor(343)])
  call ol_merge_tensors(T0sum(222),[G0tensor(116)])
  call ol_merge_tensors(T0sum(223),[G0tensor(141)])
  call ol_merge_tensors(T0sum(224),[G0tensor(186)])
  call ol_merge_tensors(T0sum(225),[G0tensor(219)])
  call ol_merge_tensors(T0sum(226),[G0tensor(409)])
  call ol_merge_tensors(T0sum(227),[G0tensor(231)])
  call ol_merge_tensors(T0sum(228),[G0tensor(281)])
  call ol_merge_tensors(T0sum(229),[G0tensor(331)])
  call ol_merge_tensors(T0sum(230),[G0tensor(381)])
  call ol_merge_tensors(T0sum(231),[G0tensor(421)])
  call ol_merge_tensors(T0sum(232),[G0tensor(462)])
  call ol_merge_tensors(T0sum(233),[G0tensor(464)])
  call ol_merge_tensors(T0sum(234),[G0tensor(494)])
  call ol_merge_tensors(T0sum(235),[G0tensor(499)])
  call ol_merge_tensors(T0sum(236),[G0tensor(456)])
  call ol_merge_tensors(T0sum(237),[G0tensor(27)])
  call ol_merge_tensors(T0sum(238),[G0tensor(47)])
  call ol_merge_tensors(T0sum(239),[G0tensor(122)])
  call ol_merge_tensors(T0sum(240),[G0tensor(107)])
  call ol_merge_tensors(T0sum(241),[G0tensor(466)])
  call ol_merge_tensors(T0sum(242),[G0tensor(471)])
  call ol_merge_tensors(T0sum(243),[G0tensor(127)])
  call ol_merge_tensors(T0sum(244),[G0tensor(137)])
  call ol_merge_tensors(T0sum(245),[G0tensor(427)])
  call ol_merge_tensors(T0sum(246),[G0tensor(449)])
  call ol_merge_tensors(T0sum(247),[G0tensor(485)])
  call ol_merge_tensors(T0sum(248),[G0tensor(364)])
  call ol_merge_tensors(T0sum(249),[G0tensor(444)])
  call ol_merge_tensors(T0sum(250),[G0tensor(480)])
  call ol_merge_tensors(T0sum(251),[G0tensor(367)])
  call ol_merge_tensors(T0sum(252),[G0tensor(344)])
  call ol_merge_tensors(T0sum(253),[G0tensor(486)])
  call ol_merge_tensors(T0sum(254),[G0tensor(511)])
  call ol_merge_tensors(T0sum(255),[G0tensor(90)])
  call ol_merge_tensors(T0sum(256),[G0tensor(520)])
  call ol_merge_tensors(T0sum(257),[G0tensor(200)])
  call ol_merge_tensors(T0sum(258),[G0tensor(529)])
  call ol_merge_tensors(T0sum(259),[G0tensor(532)])
  call ol_merge_tensors(T0sum(260),[G0tensor(533)])
  call ol_merge_tensors(T0sum(261),[G0tensor(534)])
  call ol_merge_tensors(T0sum(262),[G0tensor(535)])
  call ol_merge_tensors(T0sum(263),[G0tensor(537)])
  call ol_merge_tensors(T0sum(264),[G0tensor(538)])
  call ol_merge_tensors(T0sum(265),[G0tensor(539)])
  call ol_merge_tensors(T0sum(266),[G0tensor(540)])
  call ol_merge_tensors(T0sum(267),[G0tensor(542)])
  call ol_merge_tensors(T0sum(268),[G0tensor(543)])
  call ol_merge_tensors(T0sum(269),[G0tensor(544)])
  call ol_merge_tensors(T0sum(270),[G0tensor(545)])
  call ol_merge_tensors(T0sum(271),[G0tensor(547)])
  call ol_merge_tensors(T0sum(272),[G0tensor(548)])
  call ol_merge_tensors(T0sum(273),[G0tensor(549)])
  call ol_merge_tensors(T0sum(274),[G0tensor(550)])
  call ol_merge_tensors(T0sum(275),[G0tensor(552)])
  call ol_merge_tensors(T0sum(276),[G0tensor(553)])
  call ol_merge_tensors(T0sum(277),[G0tensor(554)])
  call ol_merge_tensors(T0sum(278),[G0tensor(555)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_42,RedSet_4(9),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_37,RedSet_4(10),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_37,RedSet_4(11),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_37,RedSet_4(7),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_42,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_42,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_37,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_37,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_42,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_32,RedSet_4(16),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 23 ],masses2_32,RedSet_4(17),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 23 ],masses2_32,RedSet_4(18),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 21 ],masses2_32,RedSet_4(1),ScalarBoxes(13))
  call compute_scalar_box([ 4, 5, 7 ],masses2_32,RedSet_4(19),ScalarBoxes(14))
  call compute_scalar_box([ 20, 21, 23 ],masses2_39,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 21, 23 ],masses2_39,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 20, 21 ],masses2_35,RedSet_4(1),ScalarBoxes(17))
  call compute_scalar_box([ 4, 5, 7 ],masses2_39,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_36,RedSet_4(16),ScalarBoxes(19))
  call compute_scalar_box([ 16, 21, 23 ],masses2_36,RedSet_4(17),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 21 ],masses2_33,RedSet_4(1),ScalarBoxes(21))
  call compute_scalar_box([ 4, 5, 7 ],masses2_36,RedSet_4(19),ScalarBoxes(22))
  call compute_scalar_box([ 18, 19, 23 ],masses2_32,RedSet_4(20),ScalarBoxes(23))
  call compute_scalar_box([ 16, 19, 23 ],masses2_32,RedSet_4(21),ScalarBoxes(24))
  call compute_scalar_box([ 16, 18, 23 ],masses2_32,RedSet_4(22),ScalarBoxes(25))
  call compute_scalar_box([ 16, 18, 19 ],masses2_32,RedSet_4(2),ScalarBoxes(26))
  call compute_scalar_box([ 2, 3, 7 ],masses2_32,RedSet_4(23),ScalarBoxes(27))
  call compute_scalar_box([ 18, 19, 23 ],masses2_43,RedSet_4(20),ScalarBoxes(28))
  call compute_scalar_box([ 16, 18, 23 ],masses2_39,RedSet_4(22),ScalarBoxes(29))
  call compute_scalar_box([ 16, 18, 19 ],masses2_39,RedSet_4(2),ScalarBoxes(30))
  call compute_scalar_box([ 2, 3, 7 ],masses2_43,RedSet_4(23),ScalarBoxes(31))
  call compute_scalar_box([ 18, 19, 23 ],masses2_40,RedSet_4(20),ScalarBoxes(32))
  call compute_scalar_box([ 16, 18, 23 ],masses2_36,RedSet_4(22),ScalarBoxes(33))
  call compute_scalar_box([ 16, 18, 19 ],masses2_36,RedSet_4(2),ScalarBoxes(34))
  call compute_scalar_box([ 2, 3, 7 ],masses2_40,RedSet_4(23),ScalarBoxes(35))
  call compute_scalar_box([ 20, 22, 23 ],masses2_32,RedSet_4(24),ScalarBoxes(36))
  call compute_scalar_box([ 16, 22, 23 ],masses2_32,RedSet_4(25),ScalarBoxes(37))
  call compute_scalar_box([ 16, 20, 22 ],masses2_32,RedSet_4(3),ScalarBoxes(38))
  call compute_scalar_box([ 4, 6, 7 ],masses2_32,RedSet_4(26),ScalarBoxes(39))
  call compute_scalar_box([ 20, 22, 23 ],masses2_39,RedSet_4(24),ScalarBoxes(40))
  call compute_scalar_box([ 16, 22, 23 ],masses2_39,RedSet_4(25),ScalarBoxes(41))
  call compute_scalar_box([ 16, 20, 22 ],masses2_35,RedSet_4(3),ScalarBoxes(42))
  call compute_scalar_box([ 4, 6, 7 ],masses2_39,RedSet_4(26),ScalarBoxes(43))
  call compute_scalar_box([ 20, 22, 23 ],masses2_36,RedSet_4(24),ScalarBoxes(44))
  call compute_scalar_box([ 16, 22, 23 ],masses2_36,RedSet_4(25),ScalarBoxes(45))
  call compute_scalar_box([ 16, 20, 22 ],masses2_33,RedSet_4(3),ScalarBoxes(46))
  call compute_scalar_box([ 4, 6, 7 ],masses2_36,RedSet_4(26),ScalarBoxes(47))
  call compute_scalar_box([ 18, 19, 27 ],masses2_32,RedSet_4(27),ScalarBoxes(48))
  call compute_scalar_box([ 16, 19, 27 ],masses2_32,RedSet_4(28),ScalarBoxes(49))
  call compute_scalar_box([ 16, 18, 27 ],masses2_32,RedSet_4(29),ScalarBoxes(50))
  call compute_scalar_box([ 2, 3, 11 ],masses2_32,RedSet_4(30),ScalarBoxes(51))
  call compute_scalar_box([ 18, 19, 27 ],masses2_43,RedSet_4(27),ScalarBoxes(52))
  call compute_scalar_box([ 16, 18, 27 ],masses2_39,RedSet_4(29),ScalarBoxes(53))
  call compute_scalar_box([ 2, 3, 11 ],masses2_43,RedSet_4(30),ScalarBoxes(54))
  call compute_scalar_box([ 18, 19, 27 ],masses2_40,RedSet_4(27),ScalarBoxes(55))
  call compute_scalar_box([ 16, 18, 27 ],masses2_36,RedSet_4(29),ScalarBoxes(56))
  call compute_scalar_box([ 2, 3, 11 ],masses2_40,RedSet_4(30),ScalarBoxes(57))
  call compute_scalar_box([ 17, 19, 23 ],masses2_32,RedSet_4(31),ScalarBoxes(58))
  call compute_scalar_box([ 16, 17, 23 ],masses2_32,RedSet_4(32),ScalarBoxes(59))
  call compute_scalar_box([ 16, 17, 19 ],masses2_32,RedSet_4(4),ScalarBoxes(60))
  call compute_scalar_box([ 1, 3, 7 ],masses2_32,RedSet_4(33),ScalarBoxes(61))
  call compute_scalar_box([ 17, 19, 23 ],masses2_43,RedSet_4(31),ScalarBoxes(62))
  call compute_scalar_box([ 16, 17, 23 ],masses2_39,RedSet_4(32),ScalarBoxes(63))
  call compute_scalar_box([ 16, 17, 19 ],masses2_39,RedSet_4(4),ScalarBoxes(64))
  call compute_scalar_box([ 1, 3, 7 ],masses2_43,RedSet_4(33),ScalarBoxes(65))
  call compute_scalar_box([ 17, 19, 23 ],masses2_40,RedSet_4(31),ScalarBoxes(66))
  call compute_scalar_box([ 16, 17, 23 ],masses2_36,RedSet_4(32),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 19 ],masses2_36,RedSet_4(4),ScalarBoxes(68))
  call compute_scalar_box([ 1, 3, 7 ],masses2_40,RedSet_4(33),ScalarBoxes(69))
  call compute_scalar_box([ 17, 19, 27 ],masses2_32,RedSet_4(34),ScalarBoxes(70))
  call compute_scalar_box([ 16, 17, 27 ],masses2_32,RedSet_4(35),ScalarBoxes(71))
  call compute_scalar_box([ 1, 3, 11 ],masses2_32,RedSet_4(36),ScalarBoxes(72))
  call compute_scalar_box([ 17, 19, 27 ],masses2_43,RedSet_4(34),ScalarBoxes(73))
  call compute_scalar_box([ 16, 17, 27 ],masses2_39,RedSet_4(35),ScalarBoxes(74))
  call compute_scalar_box([ 1, 3, 11 ],masses2_43,RedSet_4(36),ScalarBoxes(75))
  call compute_scalar_box([ 17, 19, 27 ],masses2_40,RedSet_4(34),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 27 ],masses2_36,RedSet_4(35),ScalarBoxes(77))
  call compute_scalar_box([ 1, 3, 11 ],masses2_40,RedSet_4(36),ScalarBoxes(78))
  call compute_scalar_box([ 18, 22, 23 ],masses2_41,RedSet_4(37),ScalarBoxes(79))
  call compute_scalar_box([ 16, 18, 22 ],masses2_37,RedSet_4(5),ScalarBoxes(80))
  call compute_scalar_box([ 2, 6, 7 ],masses2_41,RedSet_4(38),ScalarBoxes(81))
  call compute_scalar_box([ 18, 26, 27 ],masses2_41,RedSet_4(39),ScalarBoxes(82))
  call compute_scalar_box([ 16, 26, 27 ],masses2_36,RedSet_4(40),ScalarBoxes(83))
  call compute_scalar_box([ 16, 18, 26 ],masses2_37,RedSet_4(6),ScalarBoxes(84))
  call compute_scalar_box([ 2, 10, 11 ],masses2_41,RedSet_4(41),ScalarBoxes(85))
  call compute_scalar_box([ 17, 21, 23 ],masses2_41,RedSet_4(42),ScalarBoxes(86))
  call compute_scalar_box([ 1, 5, 7 ],masses2_41,RedSet_4(43),ScalarBoxes(87))
  call compute_scalar_box([ 17, 25, 27 ],masses2_41,RedSet_4(44),ScalarBoxes(88))
  call compute_scalar_box([ 16, 25, 27 ],masses2_36,RedSet_4(45),ScalarBoxes(89))
  call compute_scalar_box([ 1, 9, 11 ],masses2_41,RedSet_4(46),ScalarBoxes(90))
! end of process


end subroutine vamp_3

end module ol_vamp_3_ppajj_ew_ddxaag_2_/**/REALKIND
