
module ol_vamp_3_ppajj_ew_bbbxbxa_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_bbbxbxa_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_bbbxbxa_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_bbbxbxa_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_bbbxbxa_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_bbbxbxa_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_bbbxbxa_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(15),ngPtb,m3h4x8(:,20),heltab2x32(:,:,784))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[17,4,2,8],[nMB,nMH,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),m3h4x8(:,21),heltab2x32(:,:,785))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(105),n2h8(38))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[17,4,2,8],[nMB,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),m3h4x8(:,22),heltab2x32(:,:,786))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(104),n2h8(39))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[17,4,2,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngZd,m3h4x8(:,23),heltab2x32(:,:,787))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(112),n2h8(40))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[17,4,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngZd,m3h4x8(:,24),heltab2x32(:,:,788))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(111),n2h8(41))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[17,4,2,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),m3h4x8(:,25),heltab2x32(:,:,789))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMT,G1H8(129),n2h8(42))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[17,4,2,8],[nMB,0,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngH,m3h4x8(:,26),heltab2x32(:,:,790))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(128),n2h8(43))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[17,4,2,8],[nMB,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngX,m3h4x8(:,27),heltab2x32(:,:,791))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(136),n2h8(44))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[17,4,2,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngH,m3h4x8(:,28),heltab2x32(:,:,792))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(135),n2h8(45))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[17,4,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngX,m3h4x8(:,29),heltab2x32(:,:,793))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMB,G1H8(153),n2h8(46))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[17,4,2,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngPtb,m3h4x8(:,30),heltab2x32(:,:,794))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMT,G1H8(152),n2h8(47))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[17,4,2,8],[0,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(16),m3h4x8(:,31),heltab2x32(:,:,795))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[17,4,2,8],[nMZ,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(17),ngZd,m3h4x8(:,32),heltab2x32(:,:,796))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[17,4,2,8],[0,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(18),m3h4x8(:,33),heltab2x32(:,:,797))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[17,4,2,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(19),ngZd,m3h4x8(:,34),heltab2x32(:,:,798))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[17,4,2,8],[nMW,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(20),m3h4x8(:,35),heltab2x32(:,:,799))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[17,4,2,8],[nMB,0,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),m3h4x8(:,36),heltab2x32(:,:,800))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(160),n2h8(48))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[17,4,2,8],[nMB,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngZd,m3h4x8(:,37),heltab2x32(:,:,801))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(159),n2h8(49))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[17,4,2,8],[nMB,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),m3h4x8(:,38),heltab2x32(:,:,802))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(1),n2h8(50))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[17,4,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngZd,m3h4x8(:,39),heltab2x32(:,:,803))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(2),n2h8(51))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[17,4,2,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),m3h4x8(:,40),heltab2x32(:,:,804))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(3),n2h8(52))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[17,2,4,8],[nMH,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngH,m3h4x8(:,41),heltab2x32(:,:,805))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[17,2,4,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(22),ngH,m3h4x8(:,42),heltab2x32(:,:,806))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[17,2,4,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(23),ngX,m3h4x8(:,43),heltab2x32(:,:,807))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[17,2,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(24),ngX,m3h4x8(:,44),heltab2x32(:,:,808))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[17,2,4,8],[nMH,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(25),ngH,m3h4x8(:,45),heltab2x32(:,:,809))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[17,2,4,8],[nMZ,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(26),ngX,m3h4x8(:,46),heltab2x32(:,:,810))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[17,2,4,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(27),ngH,m3h4x8(:,47),heltab2x32(:,:,811))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[17,2,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(28),ngX,m3h4x8(:,48),heltab2x32(:,:,812))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[17,2,4,8],[0,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,49),heltab2x32(:,:,813))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[17,2,4,8],[0,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(30),m3h4x8(:,50),heltab2x32(:,:,814))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[17,2,4,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(31),ngZd,m3h4x8(:,51),heltab2x32(:,:,815))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[17,2,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(32),ngZd,m3h4x8(:,52),heltab2x32(:,:,816))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[17,2,4,8],[0,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,53),heltab2x32(:,:,817))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[17,2,4,8],[0,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(34),m3h4x8(:,54),heltab2x32(:,:,818))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[17,2,4,8],[nMZ,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(35),ngZd,m3h4x8(:,55),heltab2x32(:,:,819))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[17,2,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(36),ngZd,m3h4x8(:,56),heltab2x32(:,:,820))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[17,2,8,4],[nMH,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(37),ngH,m3h4x8(:,57),heltab2x32(:,:,821))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[17,2,8,4],[nMH,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(38),ngH,m3h4x8(:,58),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[17,2,8,4],[nMZ,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(39),ngX,m3h4x8(:,59),heltab2x32(:,:,823))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[17,2,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(40),ngX,m3h4x8(:,60),heltab2x32(:,:,824))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[17,2,8,4],[nMH,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(41),ngH,m3h4x8(:,61),heltab2x32(:,:,825))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[17,2,8,4],[nMZ,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(42),ngX,m3h4x8(:,62),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[17,2,8,4],[nMH,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(43),ngH,m3h4x8(:,63),heltab2x32(:,:,827))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[17,2,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(44),ngX,m3h4x8(:,64),heltab2x32(:,:,828))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[17,2,8,4],[0,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(45),m3h4x8(:,65),heltab2x32(:,:,829))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[17,2,8,4],[0,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(46),m3h4x8(:,66),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[17,2,8,4],[nMZ,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(47),ngZd,m3h4x8(:,67),heltab2x32(:,:,831))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[17,2,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(48),ngZd,m3h4x8(:,68),heltab2x32(:,:,832))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[17,2,8,4],[0,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(49),m3h4x8(:,69),heltab2x32(:,:,833))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[17,2,8,4],[0,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(50),m3h4x8(:,70),heltab2x32(:,:,834))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[17,2,8,4],[nMZ,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(51),ngZd,m3h4x8(:,71),heltab2x32(:,:,835))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[17,2,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(52),ngZd,m3h4x8(:,72),heltab2x32(:,:,836))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[18,4,1,8],[nMH,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(53),ngH,m3h4x8(:,73),heltab2x32(:,:,837))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[18,4,1,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(54),ngX,m3h4x8(:,74),heltab2x32(:,:,838))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[18,4,1,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(55),ngH,m3h4x8(:,75),heltab2x32(:,:,839))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[18,4,1,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(56),ngX,m3h4x8(:,76),heltab2x32(:,:,840))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[18,4,1,8],[nMW,nMT,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(57),ngPtb,m3h4x8(:,77),heltab2x32(:,:,841))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[18,4,1,8],[nMB,nMH,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngH,m3h4x8(:,78),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G0H8(58),18,nMB,G1H8(4),n2h8(53))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[18,4,1,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngX,m3h4x8(:,79),heltab2x32(:,:,843))
  call Hloop_Q_A(ntryL,G0H8(58),18,nMB,G1H8(5),n2h8(54))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[18,4,1,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngH,m3h4x8(:,80),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G0H8(58),18,nMB,G1H8(6),n2h8(55))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[18,4,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngX,m3h4x8(:,81),heltab2x32(:,:,845))
  call Hloop_Q_A(ntryL,G0H8(58),18,nMB,G1H8(7),n2h8(56))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[18,4,1,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngPtb,m3h4x8(:,82),heltab2x32(:,:,846))
  call Hloop_Q_A(ntryL,G0H8(58),18,nMT,G1H8(8),n2h8(57))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[18,4,1,8],[0,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(58),m3h4x8(:,83),heltab2x32(:,:,847))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[18,4,1,8],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(59),m3h4x8(:,84),heltab2x32(:,:,848))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[18,4,1,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(60),ngZd,m3h4x8(:,85),heltab2x32(:,:,849))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[18,4,1,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngZd,m3h4x8(:,86),heltab2x32(:,:,850))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[18,4,1,8],[nMW,nMT,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(62),m3h4x8(:,87),heltab2x32(:,:,851))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[18,4,1,8],[nMH,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(63),ngH,m3h4x8(:,88),heltab2x32(:,:,852))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[18,4,1,8],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(64),ngX,m3h4x8(:,89),heltab2x32(:,:,853))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[18,4,1,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(65),ngH,m3h4x8(:,90),heltab2x32(:,:,854))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[18,4,1,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(66),ngX,m3h4x8(:,91),heltab2x32(:,:,855))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[18,4,1,8],[nMW,nMT,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(67),ngPtb,m3h4x8(:,92),heltab2x32(:,:,856))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[18,4,1,8],[nMB,nMH,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),m3h4x8(:,93),heltab2x32(:,:,857))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(9),n2h8(58))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[18,4,1,8],[nMB,nMZ,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),m3h4x8(:,94),heltab2x32(:,:,858))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(10),n2h8(59))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[18,4,1,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngZd,m3h4x8(:,95),heltab2x32(:,:,859))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(11),n2h8(60))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[18,4,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngZd,m3h4x8(:,96),heltab2x32(:,:,860))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(12),n2h8(61))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[18,4,1,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),m3h4x8(:,97),heltab2x32(:,:,861))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMT,G1H8(13),n2h8(62))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[18,4,1,8],[nMB,0,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngH,m3h4x8(:,98),heltab2x32(:,:,862))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(14),n2h8(63))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[18,4,1,8],[nMB,0,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngX,m3h4x8(:,99),heltab2x32(:,:,863))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(15),n2h8(64))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[18,4,1,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngH,m3h4x8(:,100),heltab2x32(:,:,864))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(16),n2h8(65))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[18,4,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngX,m3h4x8(:,101),heltab2x32(:,:,865))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMB,G1H8(17),n2h8(66))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[18,4,1,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngPtb,m3h4x8(:,102),heltab2x32(:,:,866))
  call Hloop_Q_A(ntryL,G0H8(68),18,nMT,G1H8(18),n2h8(67))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[18,4,1,8],[0,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(68),m3h4x8(:,103),heltab2x32(:,:,867))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[18,4,1,8],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(69),ngZd,m3h4x8(:,104),heltab2x32(:,:,868))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[18,4,1,8],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(70),m3h4x8(:,105),heltab2x32(:,:,869))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[18,4,1,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(71),ngZd,m3h4x8(:,106),heltab2x32(:,:,870))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[18,4,1,8],[nMW,nMT,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(72),m3h4x8(:,107),heltab2x32(:,:,871))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[18,4,1,8],[nMB,0,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(73),m3h4x8(:,108),heltab2x32(:,:,872))
  call Hloop_Q_A(ntryL,G0H8(73),18,nMB,G1H8(19),n2h8(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[18,4,1,8],[nMB,0,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(73),ngZd,m3h4x8(:,109),heltab2x32(:,:,873))
  call Hloop_Q_A(ntryL,G0H8(73),18,nMB,G1H8(20),n2h8(69))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[18,4,1,8],[nMB,nMZ,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(73),m3h4x8(:,110),heltab2x32(:,:,874))
  call Hloop_Q_A(ntryL,G0H8(73),18,nMB,G1H8(21),n2h8(70))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[18,4,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(73),ngZd,m3h4x8(:,111),heltab2x32(:,:,875))
  call Hloop_Q_A(ntryL,G0H8(73),18,nMB,G1H8(22),n2h8(71))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[18,4,1,8],[nMT,nMW,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(73),m3h4x8(:,112),heltab2x32(:,:,876))
  call Hloop_Q_A(ntryL,G0H8(73),18,nMT,G1H8(23),n2h8(72))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[18,1,4,8],[nMH,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(73),ngH,m3h4x8(:,113),heltab2x32(:,:,877))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[18,1,4,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(74),ngH,m3h4x8(:,114),heltab2x32(:,:,878))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[18,1,4,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(75),ngX,m3h4x8(:,115),heltab2x32(:,:,879))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[18,1,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(76),ngX,m3h4x8(:,116),heltab2x32(:,:,880))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[18,1,4,8],[nMH,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(77),ngH,m3h4x8(:,117),heltab2x32(:,:,881))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[18,1,4,8],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(78),ngX,m3h4x8(:,118),heltab2x32(:,:,882))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[18,1,4,8],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(79),ngH,m3h4x8(:,119),heltab2x32(:,:,883))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[18,1,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(80),ngX,m3h4x8(:,120),heltab2x32(:,:,884))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[18,1,4,8],[0,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(81),m3h4x8(:,121),heltab2x32(:,:,885))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[18,1,4,8],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(82),m3h4x8(:,122),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[18,1,4,8],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(83),ngZd,m3h4x8(:,123),heltab2x32(:,:,887))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[18,1,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(84),ngZd,m3h4x8(:,124),heltab2x32(:,:,888))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[18,1,4,8],[0,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(85),m3h4x8(:,125),heltab2x32(:,:,889))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[18,1,4,8],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(86),m3h4x8(:,126),heltab2x32(:,:,890))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[18,1,4,8],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(87),ngZd,m3h4x8(:,127),heltab2x32(:,:,891))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[18,1,4,8],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(88),ngZd,m3h4x8(:,128),heltab2x32(:,:,892))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[18,1,8,4],[nMH,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(89),ngH,m3h4x8(:,129),heltab2x32(:,:,893))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[18,1,8,4],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(90),ngH,m3h4x8(:,130),heltab2x32(:,:,894))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[18,1,8,4],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(91),ngX,m3h4x8(:,131),heltab2x32(:,:,895))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[18,1,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(92),ngX,m3h4x8(:,132),heltab2x32(:,:,896))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[18,1,8,4],[nMH,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(93),ngH,m3h4x8(:,133),heltab2x32(:,:,897))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[18,1,8,4],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(94),ngX,m3h4x8(:,134),heltab2x32(:,:,898))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[18,1,8,4],[nMH,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(95),ngH,m3h4x8(:,135),heltab2x32(:,:,899))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[18,1,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(96),ngX,m3h4x8(:,136),heltab2x32(:,:,900))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[18,1,8,4],[0,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(97),m3h4x8(:,137),heltab2x32(:,:,901))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[18,1,8,4],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(98),m3h4x8(:,138),heltab2x32(:,:,902))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[18,1,8,4],[nMZ,nMB,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(99),ngZd,m3h4x8(:,139),heltab2x32(:,:,903))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[18,1,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(100),ngZd,m3h4x8(:,140),heltab2x32(:,:,904))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[18,1,8,4],[0,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(101),m3h4x8(:,141),heltab2x32(:,:,905))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[18,1,8,4],[0,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(102),m3h4x8(:,142),heltab2x32(:,:,906))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[18,1,8,4],[nMZ,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(103),ngZd,m3h4x8(:,143),heltab2x32(:,:,907))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[18,1,8,4],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(104),ngZd,m3h4x8(:,144),heltab2x32(:,:,908))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[20,2,1,8],[nMB,nMH,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,145),heltab2x32(:,:,909))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(24),n2h8(73))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[20,2,1,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,146),heltab2x32(:,:,910))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(25),n2h8(74))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[20,2,1,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,147),heltab2x32(:,:,911))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(26),n2h8(75))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[20,2,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,148),heltab2x32(:,:,912))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(27),n2h8(76))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[20,2,1,8],[nMB,nMH,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,149),heltab2x32(:,:,913))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(28),n2h8(77))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[20,2,1,8],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,150),heltab2x32(:,:,914))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(29),n2h8(78))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[20,2,1,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,151),heltab2x32(:,:,915))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(30),n2h8(79))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[20,2,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,152),heltab2x32(:,:,916))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(31),n2h8(80))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[20,2,1,8],[nMB,0,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,153),heltab2x32(:,:,917))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(32),n2h8(81))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[20,2,1,8],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,154),heltab2x32(:,:,918))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(33),n2h8(82))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[20,2,1,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,155),heltab2x32(:,:,919))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(34),n2h8(83))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[20,2,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,156),heltab2x32(:,:,920))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(35),n2h8(84))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[20,2,1,8],[nMB,0,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,157),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(36),n2h8(85))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[20,2,1,8],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,158),heltab2x32(:,:,922))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(37),n2h8(86))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[20,2,1,8],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,159),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(38),n2h8(87))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[20,2,1,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,160),heltab2x32(:,:,924))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(39),n2h8(88))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[20,1,2,8],[nMB,nMH,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,161),heltab2x32(:,:,925))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(40),n2h8(89))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[20,1,2,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,162),heltab2x32(:,:,926))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(41),n2h8(90))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[20,1,2,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,163),heltab2x32(:,:,927))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(42),n2h8(91))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[20,1,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,164),heltab2x32(:,:,928))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(43),n2h8(92))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[20,1,2,8],[nMB,nMH,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,165),heltab2x32(:,:,929))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(44),n2h8(93))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[20,1,2,8],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,166),heltab2x32(:,:,930))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(45),n2h8(94))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[20,1,2,8],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,167),heltab2x32(:,:,931))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(46),n2h8(95))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[20,1,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,168),heltab2x32(:,:,932))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(47),n2h8(96))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[20,1,2,8],[nMB,0,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,169),heltab2x32(:,:,933))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(48),n2h8(97))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[20,1,2,8],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,170),heltab2x32(:,:,934))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(49),n2h8(98))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[20,1,2,8],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,171),heltab2x32(:,:,935))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(50),n2h8(99))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[20,1,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngX,m3h4x8(:,172),heltab2x32(:,:,936))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(51),n2h8(100))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[20,1,2,8],[nMB,0,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,173),heltab2x32(:,:,937))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(52),n2h8(101))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[20,1,2,8],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,174),heltab2x32(:,:,938))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(53),n2h8(102))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[20,1,2,8],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),m3h4x8(:,175),heltab2x32(:,:,939))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(54),n2h8(103))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[20,1,2,8],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngZd,m3h4x8(:,176),heltab2x32(:,:,940))
  call Hloop_A_Q(ntryL,G0H8(105),20,nMB,G1H8(55),n2h8(104))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[20,1,8,2],[nMH,nMB,nMH,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(105),ngH,m3h4x8(:,177),heltab2x32(:,:,941))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[20,1,8,2],[nMH,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(106),ngH,m3h4x8(:,178),heltab2x32(:,:,942))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[20,1,8,2],[nMZ,nMB,nMH,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(107),ngX,m3h4x8(:,179),heltab2x32(:,:,943))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[20,1,8,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(108),ngX,m3h4x8(:,180),heltab2x32(:,:,944))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[20,1,8,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(109),ngPbt,m3h4x8(:,181),heltab2x32(:,:,945))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[20,1,8,2],[nMB,nMH,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngH,m3h4x8(:,182),heltab2x32(:,:,946))
  call Hloop_A_Q(ntryL,G0H8(110),20,nMB,G1H8(56),n2h8(105))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[20,1,8,2],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngX,m3h4x8(:,183),heltab2x32(:,:,947))
  call Hloop_A_Q(ntryL,G0H8(110),20,nMB,G1H8(57),n2h8(106))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[20,1,8,2],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngH,m3h4x8(:,184),heltab2x32(:,:,948))
  call Hloop_A_Q(ntryL,G0H8(110),20,nMB,G1H8(58),n2h8(107))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[20,1,8,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngX,m3h4x8(:,185),heltab2x32(:,:,949))
  call Hloop_A_Q(ntryL,G0H8(110),20,nMB,G1H8(59),n2h8(108))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[20,1,8,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngPbt,m3h4x8(:,186),heltab2x32(:,:,950))
  call Hloop_A_Q(ntryL,G0H8(110),20,nMT,G1H8(60),n2h8(109))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[20,1,8,2],[nMH,nMB,0,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(110),ngH,m3h4x8(:,187),heltab2x32(:,:,951))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[20,1,8,2],[nMZ,nMB,0,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(111),ngX,m3h4x8(:,188),heltab2x32(:,:,952))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[20,1,8,2],[nMH,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(112),ngH,m3h4x8(:,189),heltab2x32(:,:,953))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[20,1,8,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(113),ngX,m3h4x8(:,190),heltab2x32(:,:,954))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[20,1,8,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,20),G0H8(114),ngPbt,m3h4x8(:,191),heltab2x32(:,:,955))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[20,1,8,2],[0,nMB,nMH,nMB],4,1,wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,20),G0H8(115),m3h4x8(:,192),heltab2x32(:,:,956))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[20,1,8,2],[0,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,20),G0H8(116),m3h4x8(:,193),heltab2x32(:,:,957))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[20,1,8,2],[nMZ,nMB,nMH,nMB],4,1,wf4(:,20))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,20),G0H8(117),ngZd,m3h4x8(:,194),heltab2x32(:,:,958))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[20,1,8,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,20),G0H8(118),ngZd,m3h4x8(:,195),heltab2x32(:,:,959))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[20,1,8,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,20))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,20),G0H8(119),m3h4x8(:,196),heltab2x32(:,:,960))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[20,1,8,2],[nMB,nMH,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),m3h4x8(:,197),heltab2x32(:,:,961))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(61),n2h8(110))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[20,1,8,2],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),m3h4x8(:,198),heltab2x32(:,:,962))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(62),n2h8(111))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[20,1,8,2],[nMB,nMH,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngZd,m3h4x8(:,199),heltab2x32(:,:,963))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(63),n2h8(112))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[20,1,8,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngZd,m3h4x8(:,200),heltab2x32(:,:,964))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(64),n2h8(113))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[20,1,8,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,20))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),m3h4x8(:,201),heltab2x32(:,:,965))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMT,G1H8(65),n2h8(114))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[20,1,8,2],[nMB,0,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngH,m3h4x8(:,202),heltab2x32(:,:,966))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(66),n2h8(115))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[20,1,8,2],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngX,m3h4x8(:,203),heltab2x32(:,:,967))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(67),n2h8(116))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[20,1,8,2],[nMB,nMZ,nMB,nMH],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngH,m3h4x8(:,204),heltab2x32(:,:,968))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(68),n2h8(117))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[20,1,8,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngX,m3h4x8(:,205),heltab2x32(:,:,969))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMB,G1H8(69),n2h8(118))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[20,1,8,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(120),ngPbt,m3h4x8(:,206),heltab2x32(:,:,970))
  call Hloop_A_Q(ntryL,G0H8(120),20,nMT,G1H8(70),n2h8(119))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[20,1,8,2],[0,nMB,0,nMB],4,1,wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,20),G0H8(120),m3h4x8(:,207),heltab2x32(:,:,971))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[20,1,8,2],[0,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,20),G0H8(121),m3h4x8(:,208),heltab2x32(:,:,972))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[20,1,8,2],[nMZ,nMB,0,nMB],4,1,wf4(:,20))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,20),G0H8(122),ngZd,m3h4x8(:,209),heltab2x32(:,:,973))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[20,1,8,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,20))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,20),G0H8(123),ngZd,m3h4x8(:,210),heltab2x32(:,:,974))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[20,1,8,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,20))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,20),G0H8(124),m3h4x8(:,211),heltab2x32(:,:,975))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[20,1,8,2],[nMB,0,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(125),m3h4x8(:,212),heltab2x32(:,:,976))
  call Hloop_A_Q(ntryL,G0H8(125),20,nMB,G1H8(71),n2h8(120))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[20,1,8,2],[nMB,0,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(125),ngZd,m3h4x8(:,213),heltab2x32(:,:,977))
  call Hloop_A_Q(ntryL,G0H8(125),20,nMB,G1H8(72),n2h8(121))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[20,1,8,2],[nMB,nMZ,nMB,0],4,1,wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(125),m3h4x8(:,214),heltab2x32(:,:,978))
  call Hloop_A_Q(ntryL,G0H8(125),20,nMB,G1H8(73),n2h8(122))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[20,1,8,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(125),ngZd,m3h4x8(:,215),heltab2x32(:,:,979))
  call Hloop_A_Q(ntryL,G0H8(125),20,nMB,G1H8(74),n2h8(123))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[20,1,8,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,20))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,20),G0H8(125),m3h4x8(:,216),heltab2x32(:,:,980))
  call Hloop_A_Q(ntryL,G0H8(125),20,nMT,G1H8(75),n2h8(124))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[24,2,1,4],[nMB,nMH,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,217),heltab2x32(:,:,981))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(76),n2h8(125))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[24,2,1,4],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,218),heltab2x32(:,:,982))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(77),n2h8(126))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[24,2,1,4],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,219),heltab2x32(:,:,983))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(78),n2h8(127))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[24,2,1,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,220),heltab2x32(:,:,984))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(79),n2h8(128))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[24,2,1,4],[nMB,nMH,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,221),heltab2x32(:,:,985))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(82),n2h8(129))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[24,2,1,4],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,222),heltab2x32(:,:,986))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(83),n2h8(130))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[24,2,1,4],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,223),heltab2x32(:,:,987))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(84),n2h8(131))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[24,2,1,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,224),heltab2x32(:,:,988))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(85),n2h8(132))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[24,2,1,4],[nMB,0,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,225),heltab2x32(:,:,989))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(86),n2h8(133))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[24,2,1,4],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,226),heltab2x32(:,:,990))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(89),n2h8(134))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[24,2,1,4],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,227),heltab2x32(:,:,991))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(90),n2h8(135))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[24,2,1,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,228),heltab2x32(:,:,992))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(91),n2h8(136))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[24,2,1,4],[nMB,0,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,229),heltab2x32(:,:,993))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(92),n2h8(137))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[24,2,1,4],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,230),heltab2x32(:,:,994))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(93),n2h8(138))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[24,2,1,4],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,231),heltab2x32(:,:,995))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(94),n2h8(139))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[24,2,1,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,232),heltab2x32(:,:,996))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(95),n2h8(140))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[24,1,2,4],[nMB,nMH,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,233),heltab2x32(:,:,997))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(96),n2h8(141))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[24,1,2,4],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,234),heltab2x32(:,:,998))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(97),n2h8(142))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[24,1,2,4],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,235),heltab2x32(:,:,999))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(98),n2h8(143))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[24,1,2,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,236),heltab2x32(:,:,1000))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(99),n2h8(144))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[24,1,2,4],[nMB,nMH,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,237),heltab2x32(:,:,1001))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(100),n2h8(145))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[24,1,2,4],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,238),heltab2x32(:,:,1002))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(101),n2h8(146))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[24,1,2,4],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,239),heltab2x32(:,:,1003))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(102),n2h8(147))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[24,1,2,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,240),heltab2x32(:,:,1004))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(103),n2h8(148))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[24,1,2,4],[nMB,0,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,241),heltab2x32(:,:,1005))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(106),n2h8(149))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[24,1,2,4],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,242),heltab2x32(:,:,1006))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(107),n2h8(150))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[24,1,2,4],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,243),heltab2x32(:,:,1007))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(108),n2h8(151))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[24,1,2,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,244),heltab2x32(:,:,1008))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(109),n2h8(152))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[24,1,2,4],[nMB,0,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,245),heltab2x32(:,:,1009))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(110),n2h8(153))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[24,1,2,4],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,246),heltab2x32(:,:,1010))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(113),n2h8(154))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[24,1,2,4],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),m3h4x8(:,247),heltab2x32(:,:,1011))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(114),n2h8(155))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[24,1,2,4],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngZd,m3h4x8(:,248),heltab2x32(:,:,1012))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(115),n2h8(156))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[24,1,4,2],[nMH,nMB,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,249),heltab2x32(:,:,1013))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[24,1,4,2],[nMH,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(126),ngH,m3h4x8(:,250),heltab2x32(:,:,1014))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[24,1,4,2],[nMZ,nMB,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(127),ngX,m3h4x8(:,251),heltab2x32(:,:,1015))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[24,1,4,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(128),ngX,m3h4x8(:,252),heltab2x32(:,:,1016))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[24,1,4,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(129),ngPbt,m3h4x8(:,253),heltab2x32(:,:,1017))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[24,1,4,2],[nMB,nMH,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngH,m3h4x8(:,254),heltab2x32(:,:,1018))
  call Hloop_A_Q(ntryL,G0H8(130),24,nMB,G1H8(116),n2h8(157))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[24,1,4,2],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngX,m3h4x8(:,255),heltab2x32(:,:,1019))
  call Hloop_A_Q(ntryL,G0H8(130),24,nMB,G1H8(117),n2h8(158))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[24,1,4,2],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngH,m3h4x8(:,256),heltab2x32(:,:,1020))
  call Hloop_A_Q(ntryL,G0H8(130),24,nMB,G1H8(118),n2h8(159))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[24,1,4,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngX,m3h4x8(:,257),heltab2x32(:,:,1021))
  call Hloop_A_Q(ntryL,G0H8(130),24,nMB,G1H8(119),n2h8(160))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[24,1,4,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngPbt,m3h4x8(:,258),heltab2x32(:,:,1022))
  call Hloop_A_Q(ntryL,G0H8(130),24,nMT,G1H8(120),n2h8(161))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[24,1,4,2],[nMH,nMB,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(130),ngH,m3h4x8(:,259),heltab2x32(:,:,1023))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[24,1,4,2],[nMZ,nMB,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(131),ngX,m3h4x8(:,260),heltab2x32(:,:,1024))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[24,1,4,2],[nMH,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(132),ngH,m3h4x8(:,261),heltab2x32(:,:,1025))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[24,1,4,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngX,m3h4x8(:,262),heltab2x32(:,:,1026))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[24,1,4,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(134),ngPbt,m3h4x8(:,263),heltab2x32(:,:,1027))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[24,1,4,2],[0,nMB,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(135),m3h4x8(:,264),heltab2x32(:,:,1028))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[24,1,4,2],[0,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(136),m3h4x8(:,265),heltab2x32(:,:,1029))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[24,1,4,2],[nMZ,nMB,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngZd,m3h4x8(:,266),heltab2x32(:,:,1030))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[24,1,4,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(138),ngZd,m3h4x8(:,267),heltab2x32(:,:,1031))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[24,1,4,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(139),m3h4x8(:,268),heltab2x32(:,:,1032))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[24,1,4,2],[nMB,nMH,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),m3h4x8(:,269),heltab2x32(:,:,1033))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(121),n2h8(162))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[24,1,4,2],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),m3h4x8(:,270),heltab2x32(:,:,1034))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(122),n2h8(163))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[24,1,4,2],[nMB,nMH,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngZd,m3h4x8(:,271),heltab2x32(:,:,1035))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(123),n2h8(164))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[24,1,4,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngZd,m3h4x8(:,272),heltab2x32(:,:,1036))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(124),n2h8(165))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[24,1,4,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),m3h4x8(:,273),heltab2x32(:,:,1037))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMT,G1H8(125),n2h8(166))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[24,1,4,2],[nMB,0,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngH,m3h4x8(:,274),heltab2x32(:,:,1038))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(126),n2h8(167))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[24,1,4,2],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngX,m3h4x8(:,275),heltab2x32(:,:,1039))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(127),n2h8(168))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[24,1,4,2],[nMB,nMZ,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngH,m3h4x8(:,276),heltab2x32(:,:,1040))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(130),n2h8(169))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[24,1,4,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngX,m3h4x8(:,277),heltab2x32(:,:,1041))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMB,G1H8(131),n2h8(170))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[24,1,4,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(140),ngPbt,m3h4x8(:,278),heltab2x32(:,:,1042))
  call Hloop_A_Q(ntryL,G0H8(140),24,nMT,G1H8(132),n2h8(171))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[24,1,4,2],[0,nMB,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(140),m3h4x8(:,279),heltab2x32(:,:,1043))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[24,1,4,2],[0,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(141),m3h4x8(:,280),heltab2x32(:,:,1044))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[24,1,4,2],[nMZ,nMB,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(142),ngZd,m3h4x8(:,281),heltab2x32(:,:,1045))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[24,1,4,2],[nMZ,nMB,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(143),ngZd,m3h4x8(:,282),heltab2x32(:,:,1046))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[24,1,4,2],[nMW,nMT,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(144),m3h4x8(:,283),heltab2x32(:,:,1047))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[24,1,4,2],[nMB,0,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(145),m3h4x8(:,284),heltab2x32(:,:,1048))
  call Hloop_A_Q(ntryL,G0H8(145),24,nMB,G1H8(133),n2h8(172))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[24,1,4,2],[nMB,0,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(145),ngZd,m3h4x8(:,285),heltab2x32(:,:,1049))
  call Hloop_A_Q(ntryL,G0H8(145),24,nMB,G1H8(134),n2h8(173))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[24,1,4,2],[nMB,nMZ,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(145),m3h4x8(:,286),heltab2x32(:,:,1050))
  call Hloop_A_Q(ntryL,G0H8(145),24,nMB,G1H8(137),n2h8(174))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[24,1,4,2],[nMB,nMZ,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(145),ngZd,m3h4x8(:,287),heltab2x32(:,:,1051))
  call Hloop_A_Q(ntryL,G0H8(145),24,nMB,G1H8(138),n2h8(175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[24,1,4,2],[nMT,nMW,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(145),m3h4x8(:,288),heltab2x32(:,:,1052))
  call Hloop_A_Q(ntryL,G0H8(145),24,nMT,G1H8(139),n2h8(176))
  call Hloop_AQ_S(ntryL,G1H16(1),ex2(:),G1H8(140),ngH,m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_AQ_S(ntryL,G1H16(2),ex2(:),G1H8(141),ngX,m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_AQ_S(ntryL,G1H16(3),ex2(:),G1H8(142),ngPtb,m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_AQ_S(ntryL,G1H16(4),ex2(:),G1H8(143),ngH,m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_AQ_S(ntryL,G1H16(5),ex2(:),G1H8(144),ngX,m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_AQ_S(ntryL,G1H16(6),ex2(:),G1H8(145),ngPtb,m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_SQ_A(ntryL,G1H16(7),ex2(:),G1H8(146),ngPtb,m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(146),18,nMT,G2H8(1),n2h8(177))
  call Hloop_AQ_V(ntryL,G1H16(8),ex2(:),G1H8(147),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex2(:),G1H8(148),ngZd,m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_AQ_W(ntryL,G1H16(10),ex2(:),G1H8(149),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_AQ_V(ntryL,G1H16(11),ex2(:),G1H8(150),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex2(:),G1H8(151),ngZd,m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_AQ_W(ntryL,G1H16(13),ex2(:),G1H8(154),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_SQ_A(ntryL,G0H16(13),ex2(:),G0H8(145),ngPtb,m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(155),n2h8(178))
  call Hloop_SQ_A(ntryL,G0H16(14),ex2(:),G0H8(145),ngPtb,m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(156),n2h8(179))
  call Hloop_SQ_A(ntryL,G1H16(14),ex2(:),G1H8(157),ngPtb,m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(157),18,nMT,G2H8(3),n2h8(180))
  call Hloop_SQ_A(ntryL,G1H16(15),ex2(:),G1H8(158),ngPtb,m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(158),18,nMT,G2H8(2),n2h8(181))
  call Hloop_WQ_A(ntryL,G0H16(15),ex2(:),G0H8(145),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(146),n2h8(182))
  call Hloop_SQ_A(ntryL,G0H16(16),ex2(:),G0H8(145),ngPtb,m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(157),n2h8(183))
  call Hloop_WQ_A(ntryL,G1H16(16),ex2(:),G1H8(158),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(158),18,nMT,G2H8(4),n2h8(184))
  call Hloop_WQ_A(ntryL,G1H16(17),ex2(:),G1H8(158),m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(158),18,nMT,G2H8(5),n2h8(185))
  call Hloop_WQ_A(ntryL,G0H16(1),ex2(:),G0H8(145),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(158),n2h8(186))
  call Hloop_WQ_A(ntryL,G0H16(2),ex2(:),G0H8(145),m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(162),n2h8(187))
  call Hloop_WQ_A(ntryL,G1H16(18),ex2(:),G1H8(163),m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(163),18,nMT,G2H8(7),n2h8(188))
  call Hloop_AQ_S(ntryL,G1H16(19),ex2(:),G1H8(163),ngH,m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_AQ_S(ntryL,G1H16(20),ex2(:),G1H8(164),ngX,m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_AQ_S(ntryL,G1H16(21),ex2(:),G1H8(165),ngPtb,m3h2x8(:,203),heltab2x16(:,:,203))
  call Hloop_AQ_S(ntryL,G1H16(22),ex2(:),G1H8(166),ngH,m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_AQ_S(ntryL,G1H16(23),ex2(:),G1H8(167),ngX,m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_AQ_S(ntryL,G1H16(24),ex2(:),G1H8(168),ngPtb,m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_SQ_A(ntryL,G1H16(25),ex2(:),G1H8(169),ngPtb,m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(169),18,nMT,G2H8(6),n2h8(189))
  call Hloop_SQ_A(ntryL,G1H16(26),ex2(:),G1H8(169),ngPtb,m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(169),18,nMT,G2H8(8),n2h8(190))
  call Hloop_AQ_V(ntryL,G1H16(27),ex2(:),G1H8(169),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex2(:),G1H8(170),ngZd,m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_AQ_W(ntryL,G1H16(29),ex2(:),G1H8(171),m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_AQ_V(ntryL,G1H16(30),ex2(:),G1H8(172),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_AQ_Z(ntryL,G1H16(31),ex2(:),G1H8(173),ngZd,m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_AQ_W(ntryL,G1H16(32),ex2(:),G1H8(174),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_SQ_A(ntryL,G0H16(5),ex2(:),G0H8(145),ngPtb,m3h2x8(:,215),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(175),n2h8(191))
  call Hloop_SQ_A(ntryL,G0H16(6),ex2(:),G0H8(145),ngPtb,m3h2x8(:,216),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(176),n2h8(192))
  call Hloop_SQ_A(ntryL,G1H16(33),ex2(:),G1H8(177),ngPtb,m3h2x8(:,217),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(177),18,nMT,G2H8(9),n2h8(193))
  call Hloop_SQ_A(ntryL,G1H16(34),ex2(:),G1H8(177),ngPtb,m3h2x8(:,218),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H8(177),18,nMT,G2H8(11),n2h8(194))
  call Hloop_WQ_A(ntryL,G0H16(7),ex2(:),G0H8(145),m3h2x8(:,219),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(177),n2h8(195))
  call Hloop_WQ_A(ntryL,G0H16(8),ex2(:),G0H8(145),m3h2x8(:,220),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(178),n2h8(196))
  call Hloop_SQ_A(ntryL,G0H16(9),ex2(:),G0H8(145),ngPtb,m3h2x8(:,221),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(179),n2h8(197))
  call Hloop_SQ_A(ntryL,G0H16(10),ex2(:),G0H8(145),ngPtb,m3h2x8(:,222),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(180),n2h8(198))
  call Hloop_WQ_A(ntryL,G1H16(35),ex2(:),G1H8(181),m3h2x8(:,223),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(181),18,nMT,G2H8(10),n2h8(199))
  call Hloop_WQ_A(ntryL,G1H16(36),ex2(:),G1H8(181),m3h2x8(:,224),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H8(181),18,nMT,G2H8(12),n2h8(200))
  call Hloop_WQ_A(ntryL,G0H16(11),ex2(:),G0H8(145),m3h2x8(:,225),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(181),n2h8(201))
  call Hloop_WQ_A(ntryL,G0H16(12),ex2(:),G0H8(145),m3h2x8(:,226),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(182),n2h8(202))
  call Hloop_WQ_A(ntryL,G1H16(37),ex2(:),G1H8(183),m3h2x8(:,227),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(183),18,nMT,G2H8(13),n2h8(203))
  call Hloop_WQ_A(ntryL,G1H16(38),ex2(:),G1H8(183),m3h2x8(:,228),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(183),18,nMT,G2H8(15),n2h8(204))
  call Hloop_AS_Q(ntryL,G1H16(39),wf4(:,1),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(3),n2h4(161))
  call Hloop_AS_Q(ntryL,G1H16(40),wf4(:,1),G1H4(2),ngH,m3h4x4(:,2),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(2),21,nMB,G2H4(4),n2h4(162))
  call Hloop_AS_Q(ntryL,G1H16(41),wf4(:,1),G1H4(5),ngH,m3h4x4(:,3),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(5),21,nMT,G2H4(6),n2h4(163))
  call Hloop_AS_Q(ntryL,G1H16(42),wf4(:,4),G1H4(6),ngX,m3h4x4(:,4),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(6),21,nMB,G2H4(8),n2h4(164))
  call Hloop_AS_Q(ntryL,G1H16(43),wf4(:,4),G1H4(7),ngX,m3h4x4(:,5),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(7),21,nMB,G2H4(19),n2h4(165))
  call Hloop_AS_Q(ntryL,G1H16(44),wf4(:,4),G1H4(8),ngX,m3h4x4(:,6),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(8),21,nMT,G2H4(20),n2h4(166))
  call Hloop_SS_S(ntryL,G1H16(45),wf4(:,1),G1H4(11),m3h4x4(:,7),heltab2x16(:,:,235))
  call Hloop_AS_Q(ntryL,G1H16(46),wf4(:,1),G1H4(12),ngH,m3h4x4(:,8),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(12),21,nMB,G2H4(22),n2h4(167))
  call Hloop_AS_Q(ntryL,G1H16(47),wf4(:,1),G1H4(13),ngH,m3h4x4(:,9),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(13),21,nMB,G2H4(24),n2h4(168))
  call Hloop_AS_Q(ntryL,G1H16(48),wf4(:,1),G1H4(14),ngH,m3h4x4(:,10),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(14),21,nMT,G2H4(35),n2h4(169))
  call Hloop_AS_Q(ntryL,G1H16(49),wf4(:,4),G1H4(17),ngX,m3h4x4(:,11),heltab2x16(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(17),21,nMB,G2H4(36),n2h4(170))
  call Hloop_AS_Q(ntryL,G1H16(50),wf4(:,4),G1H4(18),ngX,m3h4x4(:,12),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(18),21,nMB,G2H4(38),n2h4(171))
  call Hloop_AS_Q(ntryL,G1H16(51),wf4(:,4),G1H4(19),ngX,m3h4x4(:,13),heltab2x16(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(19),21,nMT,G2H4(40),n2h4(172))
  call Hloop_VT_S(ntryL,G0H16(3),16,wf4(:,1),5,G1H4(20),m3h4x4(:,14),heltab2x16(:,:,242))
  call Hloop_VT_S(ntryL,G0H16(4),16,wf4(:,4),5,G1H4(23),m3h4x4(:,15),heltab2x16(:,:,243))
  call Hloop_SS_S(ntryL,G0H16(17),wf4(:,1),G0H4(1),m3h4x4(:,16),heltab2x16(:,:,244))
  call Hloop_ST_V(ntryL,G1H16(52),16,wf4(:,1),5,G2H4(51),m3h4x4(:,17),heltab2x16(:,:,245))
  call Hloop_ST_V(ntryL,G1H16(53),16,wf4(:,4),5,G2H4(52),m3h4x4(:,18),heltab2x16(:,:,246))
  call Hloop_VT_S(ntryL,G1H16(54),16,wf4(:,1),5,G2H4(54),m3h4x4(:,19),heltab2x16(:,:,247))
  call Hloop_VT_S(ntryL,G1H16(55),16,wf4(:,4),5,G2H4(56),m3h4x4(:,20),heltab2x16(:,:,248))
  call Hloop_VS_V(ntryL,G0H16(18),wf4(:,1),G0H4(2),m3h4x4(:,21),heltab2x16(:,:,249))
  call Hloop_ST_V(ntryL,G0H16(19),16,wf4(:,1),5,G1H4(24),m3h4x4(:,22),heltab2x16(:,:,250))
  call Hloop_ST_V(ntryL,G0H16(20),16,wf4(:,4),5,G1H4(25),m3h4x4(:,23),heltab2x16(:,:,251))
  call Hloop_VS_V(ntryL,G1H16(56),wf4(:,1),G1H4(26),m3h4x4(:,24),heltab2x16(:,:,252))
  call Hloop_AV_Q(ntryL,G1H16(57),wf4(:,5),G1H4(29),m3h4x4(:,25),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(29),21,nMB,G2H4(66),n2h4(173))
  call Hloop_AV_Q(ntryL,G1H16(58),wf4(:,5),G1H4(30),m3h4x4(:,26),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(30),21,nMB,G2H4(68),n2h4(174))
  call Hloop_AV_Q(ntryL,G1H16(59),wf4(:,5),G1H4(31),m3h4x4(:,27),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(31),21,nMT,G2H4(69),n2h4(175))
  call Hloop_AZ_Q(ntryL,G1H16(60),wf4(:,6),G1H4(32),ngZd,m3h4x4(:,28),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(32),21,nMB,G2H4(77),n2h4(176))
  call Hloop_AZ_Q(ntryL,G1H16(61),wf4(:,6),G1H4(35),ngZd,m3h4x4(:,29),heltab2x16(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(35),21,nMB,G2H4(79),n2h4(177))
  call Hloop_AZ_Q(ntryL,G1H16(62),wf4(:,6),G1H4(36),ngZu,m3h4x4(:,30),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(36),21,nMT,G2H4(80),n2h4(178))
  call Hloop_SV_T(ntryL,G1H16(63),16,wf4(:,5),5,G2H4(90),m3h4x4(:,31),heltab2x16(:,:,259))
  call Hloop_SV_T(ntryL,G1H16(64),16,wf4(:,6),5,G2H4(92),m3h4x4(:,32),heltab2x16(:,:,260))
  call Hloop_AV_Q(ntryL,G1H16(65),wf4(:,5),G1H4(37),m3h4x4(:,33),heltab2x16(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(37),21,nMB,G2H4(93),n2h4(179))
  call Hloop_AV_Q(ntryL,G1H16(66),wf4(:,5),G1H4(38),m3h4x4(:,34),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(38),21,nMB,G2H4(101),n2h4(180))
  call Hloop_AV_Q(ntryL,G1H16(67),wf4(:,5),G1H4(41),m3h4x4(:,35),heltab2x16(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(41),21,nMT,G2H4(103),n2h4(181))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,6),G1H4(42),ngZd,m3h4x4(:,36),heltab2x16(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(42),21,nMB,G2H4(104),n2h4(182))
  call Hloop_AZ_Q(ntryL,G1H16(69),wf4(:,6),G1H4(43),ngZd,m3h4x4(:,37),heltab2x16(:,:,265))
  call Hloop_A_Q(ntryL,G1H4(43),21,nMB,G2H4(115),n2h4(183))
  call Hloop_AZ_Q(ntryL,G1H16(70),wf4(:,6),G1H4(44),ngZu,m3h4x4(:,38),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G1H4(44),21,nMT,G2H4(116),n2h4(184))
  call Hloop_VV_S(ntryL,G0H16(21),wf4(:,5),G0H4(3),m3h4x4(:,39),heltab2x16(:,:,267))
  call Hloop_VV_S(ntryL,G0H16(22),wf4(:,6),G0H4(4),m3h4x4(:,40),heltab2x16(:,:,268))
  call Hloop_SV_T(ntryL,G0H16(23),16,wf4(:,5),5,G1H4(47),m3h4x4(:,41),heltab2x16(:,:,269))
  call Hloop_SV_T(ntryL,G0H16(24),16,wf4(:,6),5,G1H4(48),m3h4x4(:,42),heltab2x16(:,:,270))
  call Hloop_SV_V(ntryL,G1H16(71),wf4(:,5),G1H4(49),m3h4x4(:,43),heltab2x16(:,:,271))
  call Hloop_SV_V(ntryL,G1H16(72),wf4(:,6),G1H4(50),m3h4x4(:,44),heltab2x16(:,:,272))
  call Hloop_VV_S(ntryL,G1H16(73),wf4(:,5),G1H4(53),m3h4x4(:,45),heltab2x16(:,:,273))
  call Hloop_VV_S(ntryL,G1H16(74),wf4(:,6),G1H4(54),m3h4x4(:,46),heltab2x16(:,:,274))
  call Hloop_UW_V(ntryL,G0H16(25),16,wf4(:,5),5,G1H4(55),m3h4x4(:,47),heltab2x16(:,:,275))
  call Hloop_UW_V(ntryL,G0H16(26),16,wf4(:,6),5,G1H4(56),m3h4x4(:,48),heltab2x16(:,:,276))
  call Hloop_SV_V(ntryL,G0H16(27),wf4(:,5),G0H4(5),m3h4x4(:,49),heltab2x16(:,:,277))
  call Hloop_SV_V(ntryL,G0H16(28),wf4(:,6),G0H4(6),m3h4x4(:,50),heltab2x16(:,:,278))
  call Hloop_UW_V(ntryL,G1H16(75),16,wf4(:,5),5,G2H4(117),m3h4x4(:,51),heltab2x16(:,:,279))
  call Hloop_UW_V(ntryL,G1H16(76),16,wf4(:,6),5,G2H4(120),m3h4x4(:,52),heltab2x16(:,:,280))
  call Hloop_AQ_S(ntryL,G1H16(77),ex2(:),G1H8(183),ngH,m3h2x8(:,229),heltab2x16(:,:,281))
  call Hloop_AQ_S(ntryL,G1H16(78),ex2(:),G1H8(184),ngX,m3h2x8(:,230),heltab2x16(:,:,282))
  call Hloop_AQ_S(ntryL,G1H16(79),ex2(:),G1H8(185),ngPtb,m3h2x8(:,231),heltab2x16(:,:,283))
  call Hloop_AQ_S(ntryL,G1H16(80),ex2(:),G1H8(186),ngH,m3h2x8(:,232),heltab2x16(:,:,284))
  call Hloop_AQ_S(ntryL,G1H16(81),ex2(:),G1H8(187),ngX,m3h2x8(:,233),heltab2x16(:,:,285))
  call Hloop_SQ_A(ntryL,G1H16(82),ex2(:),G1H8(188),ngPtb,m3h2x8(:,234),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H8(188),18,nMT,G2H8(14),n2h8(205))
  call Hloop_SQ_A(ntryL,G1H16(83),ex2(:),G1H8(188),ngPtb,m3h2x8(:,235),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G1H8(188),18,nMT,G2H8(16),n2h8(206))
  call Hloop_AQ_S(ntryL,G1H16(84),ex2(:),G1H8(188),ngX,m3h2x8(:,236),heltab2x16(:,:,288))
  call Hloop_AQ_S(ntryL,G1H16(85),ex2(:),G1H8(189),ngPtb,m3h2x8(:,237),heltab2x16(:,:,289))
  call Hloop_AQ_S(ntryL,G1H16(86),ex2(:),G1H8(190),ngH,m3h2x8(:,238),heltab2x16(:,:,290))
  call Hloop_AQ_S(ntryL,G1H16(87),ex2(:),G1H8(191),ngPtb,m3h2x8(:,239),heltab2x16(:,:,291))
  call Hloop_AQ_Z(ntryL,G1H16(88),ex2(:),G1H8(192),ngZd,m3h2x8(:,240),heltab2x16(:,:,292))
  call Hloop_AQ_W(ntryL,G1H16(89),ex2(:),G1H8(193),m3h2x8(:,241),heltab2x16(:,:,293))
  call Hloop_AQ_Z(ntryL,G1H16(90),ex2(:),G1H8(194),ngZd,m3h2x8(:,242),heltab2x16(:,:,294))
  call Hloop_AQ_W(ntryL,G1H16(91),ex2(:),G1H8(195),m3h2x8(:,243),heltab2x16(:,:,295))
  call Hloop_SQ_A(ntryL,G0H16(29),ex2(:),G0H8(145),ngPtb,m3h2x8(:,244),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(196),n2h8(207))
  call Hloop_SQ_A(ntryL,G0H16(30),ex2(:),G0H8(145),ngPtb,m3h2x8(:,245),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(197),n2h8(208))
  call Hloop_WQ_A(ntryL,G0H16(31),ex2(:),G0H8(145),m3h2x8(:,246),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(198),n2h8(209))
  call Hloop_WQ_A(ntryL,G0H16(32),ex2(:),G0H8(145),m3h2x8(:,247),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(199),n2h8(210))
  call Hloop_AQ_Z(ntryL,G1H16(92),ex2(:),G1H8(200),ngZd,m3h2x8(:,248),heltab2x16(:,:,300))
  call Hloop_AQ_W(ntryL,G1H16(93),ex2(:),G1H8(201),m3h2x8(:,249),heltab2x16(:,:,301))
  call Hloop_WQ_A(ntryL,G1H16(94),ex2(:),G1H8(202),m3h2x8(:,250),heltab2x16(:,:,302))
  call Hloop_Q_A(ntryL,G1H8(202),18,nMT,G2H8(17),n2h8(211))
  call Hloop_WQ_A(ntryL,G1H16(95),ex2(:),G1H8(202),m3h2x8(:,251),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H8(202),18,nMT,G2H8(18),n2h8(212))
  call Hloop_AQ_S(ntryL,G1H16(96),ex2(:),G1H8(202),ngPtb,m3h2x8(:,252),heltab2x16(:,:,304))
  call Hloop_AQ_S(ntryL,G1H16(97),ex2(:),G1H8(203),ngH,m3h2x8(:,253),heltab2x16(:,:,305))
  call Hloop_AQ_S(ntryL,G1H16(98),ex2(:),G1H8(204),ngX,m3h2x8(:,254),heltab2x16(:,:,306))
  call Hloop_AQ_S(ntryL,G1H16(99),ex2(:),G1H8(205),ngPtb,m3h2x8(:,255),heltab2x16(:,:,307))
  call Hloop_SQ_A(ntryL,G1H16(100),ex2(:),G1H8(206),ngPtb,m3h2x8(:,256),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H8(206),18,nMT,G2H8(19),n2h8(213))
  call Hloop_SQ_A(ntryL,G1H16(101),ex2(:),G1H8(206),ngPtb,m3h2x8(:,257),heltab2x16(:,:,309))
  call Hloop_Q_A(ntryL,G1H8(206),18,nMT,G2H8(20),n2h8(214))
  call Hloop_AQ_S(ntryL,G1H16(102),ex2(:),G1H8(206),ngPtb,m3h2x8(:,258),heltab2x16(:,:,310))
  call Hloop_AQ_S(ntryL,G1H16(103),ex2(:),G1H8(207),ngH,m3h2x8(:,259),heltab2x16(:,:,311))
  call Hloop_AQ_S(ntryL,G1H16(104),ex2(:),G1H8(208),ngPtb,m3h2x8(:,260),heltab2x16(:,:,312))
  call Hloop_AQ_W(ntryL,G1H16(105),ex2(:),G1H8(209),m3h2x8(:,261),heltab2x16(:,:,313))
  call Hloop_AQ_Z(ntryL,G1H16(106),ex2(:),G1H8(210),ngZd,m3h2x8(:,262),heltab2x16(:,:,314))
  call Hloop_AQ_W(ntryL,G1H16(107),ex2(:),G1H8(211),m3h2x8(:,263),heltab2x16(:,:,315))
  call Hloop_SQ_A(ntryL,G0H16(33),ex2(:),G0H8(145),ngPtb,m3h2x8(:,264),heltab2x16(:,:,316))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(212),n2h8(215))
  call Hloop_SQ_A(ntryL,G0H16(34),ex2(:),G0H8(145),ngPtb,m3h2x8(:,265),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(213),n2h8(216))
  call Hloop_WQ_A(ntryL,G0H16(35),ex2(:),G0H8(145),m3h2x8(:,266),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(214),n2h8(217))
  call Hloop_WQ_A(ntryL,G0H16(36),ex2(:),G0H8(145),m3h2x8(:,267),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(215),n2h8(218))
  call Hloop_AQ_W(ntryL,G1H16(108),ex2(:),G1H8(216),m3h2x8(:,268),heltab2x16(:,:,320))
  call Hloop_AQ_W(ntryL,G1H16(109),ex2(:),G1H8(217),m3h2x8(:,269),heltab2x16(:,:,321))
  call Hloop_WQ_A(ntryL,G1H16(110),ex2(:),G1H8(218),m3h2x8(:,270),heltab2x16(:,:,322))
  call Hloop_Q_A(ntryL,G1H8(218),18,nMT,G2H8(21),n2h8(219))
  call Hloop_WQ_A(ntryL,G1H16(111),ex2(:),G1H8(218),m3h2x8(:,271),heltab2x16(:,:,323))
  call Hloop_Q_A(ntryL,G1H8(218),18,nMT,G2H8(22),n2h8(220))
  call Hloop_AQ_S(ntryL,G1H16(112),ex1(:),G1H8(218),ngH,m3h2x8(:,272),heltab2x16(:,:,324))
  call Hloop_AQ_S(ntryL,G1H16(113),ex1(:),G1H8(219),ngX,m3h2x8(:,273),heltab2x16(:,:,325))
  call Hloop_AQ_S(ntryL,G1H16(114),ex1(:),G1H8(220),ngPtb,m3h2x8(:,274),heltab2x16(:,:,326))
  call Hloop_AQ_S(ntryL,G1H16(115),ex1(:),G1H8(221),ngH,m3h2x8(:,275),heltab2x16(:,:,327))
  call Hloop_AQ_S(ntryL,G1H16(116),ex1(:),G1H8(222),ngX,m3h2x8(:,276),heltab2x16(:,:,328))
  call Hloop_AQ_S(ntryL,G1H16(117),ex1(:),G1H8(223),ngPtb,m3h2x8(:,277),heltab2x16(:,:,329))
  call Hloop_SQ_A(ntryL,G1H16(118),ex1(:),G1H8(224),ngPtb,m3h2x8(:,278),heltab2x16(:,:,330))
  call Hloop_Q_A(ntryL,G1H8(224),17,nMT,G2H8(23),n2h8(221))
  call Hloop_AQ_V(ntryL,G1H16(119),ex1(:),G1H8(224),m3h2x8(:,279),heltab2x16(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H16(120),ex1(:),G1H8(225),ngZd,m3h2x8(:,280),heltab2x16(:,:,332))
  call Hloop_AQ_W(ntryL,G1H16(121),ex1(:),G1H8(226),m3h2x8(:,281),heltab2x16(:,:,333))
  call Hloop_AQ_V(ntryL,G1H16(122),ex1(:),G1H8(227),m3h2x8(:,282),heltab2x16(:,:,334))
  call Hloop_AQ_Z(ntryL,G1H16(123),ex1(:),G1H8(228),ngZd,m3h2x8(:,283),heltab2x16(:,:,335))
  call Hloop_AQ_W(ntryL,G1H16(124),ex1(:),G1H8(229),m3h2x8(:,284),heltab2x16(:,:,336))
  call Hloop_SQ_A(ntryL,G0H16(37),ex1(:),G0H8(145),ngPtb,m3h2x8(:,285),heltab2x16(:,:,337))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(230),n2h8(222))
  call Hloop_SQ_A(ntryL,G0H16(38),ex1(:),G0H8(145),ngPtb,m3h2x8(:,286),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(231),n2h8(223))
  call Hloop_SQ_A(ntryL,G1H16(125),ex1(:),G1H8(232),ngPtb,m3h2x8(:,287),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G1H8(232),17,nMT,G2H8(24),n2h8(224))
  call Hloop_SQ_A(ntryL,G1H16(126),ex1(:),G1H8(232),ngPtb,m3h2x8(:,288),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G1H8(232),17,nMT,G2H8(25),n2h8(225))
  call Hloop_WQ_A(ntryL,G0H16(39),ex1(:),G0H8(145),m3h2x8(:,289),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(232),n2h8(226))
  call Hloop_SQ_A(ntryL,G0H16(40),ex1(:),G0H8(145),ngPtb,m3h2x8(:,290),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(233),n2h8(227))
  call Hloop_WQ_A(ntryL,G1H16(127),ex1(:),G1H8(234),m3h2x8(:,291),heltab2x16(:,:,343))
  call Hloop_Q_A(ntryL,G1H8(234),17,nMT,G2H8(26),n2h8(228))
  call Hloop_WQ_A(ntryL,G1H16(128),ex1(:),G1H8(234),m3h2x8(:,292),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G1H8(234),17,nMT,G2H8(27),n2h8(229))
  call Hloop_WQ_A(ntryL,G0H16(41),ex1(:),G0H8(145),m3h2x8(:,293),heltab2x16(:,:,345))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(234),n2h8(230))
  call Hloop_WQ_A(ntryL,G0H16(42),ex1(:),G0H8(145),m3h2x8(:,294),heltab2x16(:,:,346))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(235),n2h8(231))
  call Hloop_WQ_A(ntryL,G1H16(129),ex1(:),G1H8(236),m3h2x8(:,295),heltab2x16(:,:,347))
  call Hloop_Q_A(ntryL,G1H8(236),17,nMT,G2H8(28),n2h8(232))
  call Hloop_AQ_S(ntryL,G1H16(130),ex1(:),G1H8(236),ngH,m3h2x8(:,296),heltab2x16(:,:,348))
  call Hloop_AQ_S(ntryL,G1H16(131),ex1(:),G1H8(237),ngX,m3h2x8(:,297),heltab2x16(:,:,349))
  call Hloop_AQ_S(ntryL,G1H16(132),ex1(:),G1H8(238),ngPtb,m3h2x8(:,298),heltab2x16(:,:,350))
  call Hloop_AQ_S(ntryL,G1H16(133),ex1(:),G1H8(239),ngH,m3h2x8(:,299),heltab2x16(:,:,351))
  call Hloop_AQ_S(ntryL,G1H16(134),ex1(:),G1H8(240),ngX,m3h2x8(:,300),heltab2x16(:,:,352))
  call Hloop_AQ_S(ntryL,G1H16(135),ex1(:),G1H8(241),ngPtb,m3h2x8(:,301),heltab2x16(:,:,353))
  call Hloop_SQ_A(ntryL,G1H16(136),ex1(:),G1H8(242),ngPtb,m3h2x8(:,302),heltab2x16(:,:,354))
  call Hloop_Q_A(ntryL,G1H8(242),17,nMT,G2H8(29),n2h8(233))
  call Hloop_SQ_A(ntryL,G1H16(137),ex1(:),G1H8(242),ngPtb,m3h2x8(:,303),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H8(242),17,nMT,G2H8(30),n2h8(234))
  call Hloop_AQ_V(ntryL,G1H16(138),ex1(:),G1H8(242),m3h2x8(:,304),heltab2x16(:,:,356))
  call Hloop_AQ_Z(ntryL,G1H16(139),ex1(:),G1H8(243),ngZd,m3h2x8(:,305),heltab2x16(:,:,357))
  call Hloop_AQ_W(ntryL,G1H16(140),ex1(:),G1H8(244),m3h2x8(:,306),heltab2x16(:,:,358))
  call Hloop_AQ_V(ntryL,G1H16(141),ex1(:),G1H8(245),m3h2x8(:,307),heltab2x16(:,:,359))
  call Hloop_AQ_Z(ntryL,G1H16(142),ex1(:),G1H8(246),ngZd,m3h2x8(:,308),heltab2x16(:,:,360))
  call Hloop_AQ_W(ntryL,G1H16(143),ex1(:),G1H8(247),m3h2x8(:,309),heltab2x16(:,:,361))
  call Hloop_SQ_A(ntryL,G0H16(43),ex1(:),G0H8(145),ngPtb,m3h2x8(:,310),heltab2x16(:,:,362))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(248),n2h8(235))
  call Hloop_SQ_A(ntryL,G0H16(44),ex1(:),G0H8(145),ngPtb,m3h2x8(:,311),heltab2x16(:,:,363))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(249),n2h8(236))
  call Hloop_SQ_A(ntryL,G1H16(144),ex1(:),G1H8(250),ngPtb,m3h2x8(:,312),heltab2x16(:,:,364))
  call Hloop_Q_A(ntryL,G1H8(250),17,nMT,G2H8(31),n2h8(237))
  call Hloop_SQ_A(ntryL,G1H16(145),ex1(:),G1H8(250),ngPtb,m3h2x8(:,313),heltab2x16(:,:,365))
  call Hloop_Q_A(ntryL,G1H8(250),17,nMT,G2H8(32),n2h8(238))
  call Hloop_WQ_A(ntryL,G0H16(45),ex1(:),G0H8(145),m3h2x8(:,314),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(250),n2h8(239))
  call Hloop_WQ_A(ntryL,G0H16(46),ex1(:),G0H8(145),m3h2x8(:,315),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(251),n2h8(240))
  call Hloop_SQ_A(ntryL,G0H16(47),ex1(:),G0H8(145),ngPtb,m3h2x8(:,316),heltab2x16(:,:,368))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(252),n2h8(241))
  call Hloop_SQ_A(ntryL,G0H16(48),ex1(:),G0H8(145),ngPtb,m3h2x8(:,317),heltab2x16(:,:,369))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(253),n2h8(242))
  call Hloop_WQ_A(ntryL,G1H16(146),ex1(:),G1H8(254),m3h2x8(:,318),heltab2x16(:,:,370))
  call Hloop_Q_A(ntryL,G1H8(254),17,nMT,G2H8(33),n2h8(243))
  call Hloop_WQ_A(ntryL,G1H16(147),ex1(:),G1H8(254),m3h2x8(:,319),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H8(254),17,nMT,G2H8(34),n2h8(244))
  call Hloop_WQ_A(ntryL,G0H16(49),ex1(:),G0H8(145),m3h2x8(:,320),heltab2x16(:,:,372))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(254),n2h8(245))
  call Hloop_WQ_A(ntryL,G0H16(50),ex1(:),G0H8(145),m3h2x8(:,321),heltab2x16(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(255),n2h8(246))
  call Hloop_WQ_A(ntryL,G1H16(148),ex1(:),G1H8(256),m3h2x8(:,322),heltab2x16(:,:,374))
  call Hloop_Q_A(ntryL,G1H8(256),17,nMT,G2H8(35),n2h8(247))
  call Hloop_WQ_A(ntryL,G1H16(149),ex1(:),G1H8(256),m3h2x8(:,323),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H8(256),17,nMT,G2H8(36),n2h8(248))
  call Hloop_AS_Q(ntryL,G1H16(150),wf4(:,10),G1H4(59),ngH,m3h4x4(:,53),heltab2x16(:,:,376))
  call Hloop_A_Q(ntryL,G1H4(59),22,nMB,G2H4(122),n2h4(185))
  call Hloop_AS_Q(ntryL,G1H16(151),wf4(:,10),G1H4(60),ngH,m3h4x4(:,54),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G1H4(60),22,nMB,G2H4(123),n2h4(186))
  call Hloop_AS_Q(ntryL,G1H16(152),wf4(:,10),G1H4(61),ngH,m3h4x4(:,55),heltab2x16(:,:,378))
  call Hloop_A_Q(ntryL,G1H4(61),22,nMT,G2H4(139),n2h4(187))
  call Hloop_AS_Q(ntryL,G1H16(153),wf4(:,12),G1H4(62),ngX,m3h4x4(:,56),heltab2x16(:,:,379))
  call Hloop_A_Q(ntryL,G1H4(62),22,nMB,G2H4(140),n2h4(188))
  call Hloop_AS_Q(ntryL,G1H16(154),wf4(:,12),G1H4(65),ngX,m3h4x4(:,57),heltab2x16(:,:,380))
  call Hloop_A_Q(ntryL,G1H4(65),22,nMB,G2H4(141),n2h4(189))
  call Hloop_AS_Q(ntryL,G1H16(155),wf4(:,12),G1H4(66),ngX,m3h4x4(:,58),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(66),22,nMT,G2H4(144),n2h4(190))
  call Hloop_SS_S(ntryL,G1H16(156),wf4(:,10),G1H4(67),m3h4x4(:,59),heltab2x16(:,:,382))
  call Hloop_AS_Q(ntryL,G1H16(157),wf4(:,10),G1H4(68),ngH,m3h4x4(:,60),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G1H4(68),22,nMB,G2H4(146),n2h4(191))
  call Hloop_AS_Q(ntryL,G1H16(158),wf4(:,10),G1H4(71),ngH,m3h4x4(:,61),heltab2x16(:,:,384))
  call Hloop_A_Q(ntryL,G1H4(71),22,nMB,G2H4(147),n2h4(192))
  call Hloop_AS_Q(ntryL,G1H16(159),wf4(:,10),G1H4(72),ngH,m3h4x4(:,62),heltab2x16(:,:,385))
  call Hloop_A_Q(ntryL,G1H4(72),22,nMT,G2H4(1),n2h4(193))
  call Hloop_AS_Q(ntryL,G1H16(160),wf4(:,12),G1H4(73),ngX,m3h4x4(:,63),heltab2x16(:,:,386))
  call Hloop_A_Q(ntryL,G1H4(73),22,nMB,G2H4(2),n2h4(194))
  call Hloop_AS_Q(ntryL,G1H16(161),wf4(:,12),G1H4(74),ngX,m3h4x4(:,64),heltab2x16(:,:,387))
  call Hloop_A_Q(ntryL,G1H4(74),22,nMB,G2H4(11),n2h4(195))
  call Hloop_AS_Q(ntryL,G1H16(162),wf4(:,12),G1H4(77),ngX,m3h4x4(:,65),heltab2x16(:,:,388))
  call Hloop_A_Q(ntryL,G1H4(77),22,nMT,G2H4(12),n2h4(196))
  call Hloop_VT_S(ntryL,G0H16(51),16,wf4(:,10),6,G1H4(78),m3h4x4(:,66),heltab2x16(:,:,389))
  call Hloop_VT_S(ntryL,G0H16(52),16,wf4(:,12),6,G1H4(79),m3h4x4(:,67),heltab2x16(:,:,390))
  call Hloop_SS_S(ntryL,G0H16(53),wf4(:,10),G0H4(7),m3h4x4(:,68),heltab2x16(:,:,391))
  call Hloop_ST_V(ntryL,G1H16(163),16,wf4(:,10),6,G2H4(5),m3h4x4(:,69),heltab2x16(:,:,392))
  call Hloop_ST_V(ntryL,G1H16(164),16,wf4(:,12),6,G2H4(15),m3h4x4(:,70),heltab2x16(:,:,393))
  call Hloop_VT_S(ntryL,G1H16(165),16,wf4(:,10),6,G2H4(7),m3h4x4(:,71),heltab2x16(:,:,394))
  call Hloop_VT_S(ntryL,G1H16(166),16,wf4(:,12),6,G2H4(16),m3h4x4(:,72),heltab2x16(:,:,395))
  call Hloop_VS_V(ntryL,G0H16(54),wf4(:,10),G0H4(8),m3h4x4(:,73),heltab2x16(:,:,396))
  call Hloop_ST_V(ntryL,G0H16(55),16,wf4(:,10),6,G1H4(80),m3h4x4(:,74),heltab2x16(:,:,397))
  call Hloop_ST_V(ntryL,G0H16(56),16,wf4(:,12),6,G1H4(83),m3h4x4(:,75),heltab2x16(:,:,398))
  call Hloop_VS_V(ntryL,G1H16(167),wf4(:,10),G1H4(84),m3h4x4(:,76),heltab2x16(:,:,399))
  call Hloop_AV_Q(ntryL,G1H16(168),wf4(:,13),G1H4(85),m3h4x4(:,77),heltab2x16(:,:,400))
  call Hloop_A_Q(ntryL,G1H4(85),22,nMB,G2H4(9),n2h4(197))
  call Hloop_AV_Q(ntryL,G1H16(169),wf4(:,13),G1H4(86),m3h4x4(:,78),heltab2x16(:,:,401))
  call Hloop_A_Q(ntryL,G1H4(86),22,nMB,G2H4(10),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H16(170),wf4(:,13),G1H4(89),m3h4x4(:,79),heltab2x16(:,:,402))
  call Hloop_A_Q(ntryL,G1H4(89),22,nMT,G2H4(13),n2h4(199))
  call Hloop_AZ_Q(ntryL,G1H16(171),wf4(:,14),G1H4(90),ngZd,m3h4x4(:,80),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G1H4(90),22,nMB,G2H4(14),n2h4(200))
  call Hloop_AZ_Q(ntryL,G1H16(172),wf4(:,14),G1H4(91),ngZd,m3h4x4(:,81),heltab2x16(:,:,404))
  call Hloop_A_Q(ntryL,G1H4(91),22,nMB,G2H4(17),n2h4(201))
  call Hloop_AZ_Q(ntryL,G1H16(173),wf4(:,14),G1H4(92),ngZu,m3h4x4(:,82),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G1H4(92),22,nMT,G2H4(18),n2h4(202))
  call Hloop_SV_T(ntryL,G1H16(174),16,wf4(:,13),6,G2H4(27),m3h4x4(:,83),heltab2x16(:,:,406))
  call Hloop_SV_T(ntryL,G1H16(175),16,wf4(:,14),6,G2H4(28),m3h4x4(:,84),heltab2x16(:,:,407))
  call Hloop_AV_Q(ntryL,G1H16(176),wf4(:,13),G1H4(95),m3h4x4(:,85),heltab2x16(:,:,408))
  call Hloop_A_Q(ntryL,G1H4(95),22,nMB,G2H4(21),n2h4(203))
  call Hloop_AV_Q(ntryL,G1H16(177),wf4(:,13),G1H4(96),m3h4x4(:,86),heltab2x16(:,:,409))
  call Hloop_A_Q(ntryL,G1H4(96),22,nMB,G2H4(31),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H16(178),wf4(:,13),G1H4(1),m3h4x4(:,87),heltab2x16(:,:,410))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(23),n2h4(205))
  call Hloop_AZ_Q(ntryL,G1H16(179),wf4(:,14),G1H4(2),ngZd,m3h4x4(:,88),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(2),22,nMB,G2H4(32),n2h4(206))
  call Hloop_AZ_Q(ntryL,G1H16(180),wf4(:,14),G1H4(5),ngZd,m3h4x4(:,89),heltab2x16(:,:,412))
  call Hloop_A_Q(ntryL,G1H4(5),22,nMB,G2H4(25),n2h4(207))
  call Hloop_AZ_Q(ntryL,G1H16(181),wf4(:,14),G1H4(6),ngZu,m3h4x4(:,90),heltab2x16(:,:,413))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(26),n2h4(208))
  call Hloop_VV_S(ntryL,G0H16(57),wf4(:,13),G0H4(9),m3h4x4(:,91),heltab2x16(:,:,414))
  call Hloop_VV_S(ntryL,G0H16(58),wf4(:,14),G0H4(10),m3h4x4(:,92),heltab2x16(:,:,415))
  call Hloop_SV_T(ntryL,G0H16(59),16,wf4(:,13),6,G1H4(7),m3h4x4(:,93),heltab2x16(:,:,416))
  call Hloop_SV_T(ntryL,G0H16(60),16,wf4(:,14),6,G1H4(8),m3h4x4(:,94),heltab2x16(:,:,417))
  call Hloop_SV_V(ntryL,G1H16(182),wf4(:,13),G1H4(12),m3h4x4(:,95),heltab2x16(:,:,418))
  call Hloop_SV_V(ntryL,G1H16(183),wf4(:,14),G1H4(13),m3h4x4(:,96),heltab2x16(:,:,419))
  call Hloop_VV_S(ntryL,G1H16(184),wf4(:,13),G1H4(14),m3h4x4(:,97),heltab2x16(:,:,420))
  call Hloop_VV_S(ntryL,G1H16(185),wf4(:,14),G1H4(17),m3h4x4(:,98),heltab2x16(:,:,421))
  call Hloop_UW_V(ntryL,G0H16(61),16,wf4(:,13),6,G1H4(18),m3h4x4(:,99),heltab2x16(:,:,422))
  call Hloop_UW_V(ntryL,G0H16(62),16,wf4(:,14),6,G1H4(19),m3h4x4(:,100),heltab2x16(:,:,423))
  call Hloop_SV_V(ntryL,G0H16(63),wf4(:,13),G0H4(11),m3h4x4(:,101),heltab2x16(:,:,424))
  call Hloop_SV_V(ntryL,G0H16(64),wf4(:,14),G0H4(12),m3h4x4(:,102),heltab2x16(:,:,425))
  call Hloop_UW_V(ntryL,G1H16(186),16,wf4(:,13),6,G2H4(29),m3h4x4(:,103),heltab2x16(:,:,426))
  call Hloop_UW_V(ntryL,G1H16(187),16,wf4(:,14),6,G2H4(30),m3h4x4(:,104),heltab2x16(:,:,427))
  call Hloop_AQ_S(ntryL,G1H16(188),ex1(:),G1H8(256),ngH,m3h2x8(:,324),heltab2x16(:,:,428))
  call Hloop_AQ_S(ntryL,G1H16(189),ex1(:),G1H8(257),ngX,m3h2x8(:,325),heltab2x16(:,:,429))
  call Hloop_AQ_S(ntryL,G1H16(190),ex1(:),G1H8(258),ngPtb,m3h2x8(:,326),heltab2x16(:,:,430))
  call Hloop_AQ_S(ntryL,G1H16(191),ex1(:),G1H8(259),ngH,m3h2x8(:,327),heltab2x16(:,:,431))
  call Hloop_AQ_S(ntryL,G1H16(192),ex1(:),G1H8(260),ngX,m3h2x8(:,328),heltab2x16(:,:,432))
  call Hloop_SQ_A(ntryL,G1H16(193),ex1(:),G1H8(261),ngPtb,m3h2x8(:,329),heltab2x16(:,:,433))
  call Hloop_Q_A(ntryL,G1H8(261),17,nMT,G2H8(37),n2h8(249))
  call Hloop_SQ_A(ntryL,G1H16(194),ex1(:),G1H8(261),ngPtb,m3h2x8(:,330),heltab2x16(:,:,434))
  call Hloop_Q_A(ntryL,G1H8(261),17,nMT,G2H8(38),n2h8(250))
  call Hloop_AQ_S(ntryL,G1H16(195),ex1(:),G1H8(261),ngX,m3h2x8(:,331),heltab2x16(:,:,435))
  call Hloop_AQ_S(ntryL,G1H16(196),ex1(:),G1H8(262),ngPtb,m3h2x8(:,332),heltab2x16(:,:,436))
  call Hloop_AQ_S(ntryL,G1H16(197),ex1(:),G1H8(263),ngH,m3h2x8(:,333),heltab2x16(:,:,437))
  call Hloop_AQ_S(ntryL,G1H16(198),ex1(:),G1H8(264),ngPtb,m3h2x8(:,334),heltab2x16(:,:,438))
  call Hloop_AQ_Z(ntryL,G1H16(199),ex1(:),G1H8(265),ngZd,m3h2x8(:,335),heltab2x16(:,:,439))
  call Hloop_AQ_W(ntryL,G1H16(200),ex1(:),G1H8(266),m3h2x8(:,336),heltab2x16(:,:,440))
  call Hloop_AQ_Z(ntryL,G1H16(201),ex1(:),G1H8(267),ngZd,m3h2x8(:,337),heltab2x16(:,:,441))
  call Hloop_AQ_W(ntryL,G1H16(202),ex1(:),G1H8(268),m3h2x8(:,338),heltab2x16(:,:,442))
  call Hloop_SQ_A(ntryL,G0H16(65),ex1(:),G0H8(145),ngPtb,m3h2x8(:,339),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(269),n2h8(251))
  call Hloop_SQ_A(ntryL,G0H16(66),ex1(:),G0H8(145),ngPtb,m3h2x8(:,340),heltab2x16(:,:,444))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(270),n2h8(252))
  call Hloop_WQ_A(ntryL,G0H16(67),ex1(:),G0H8(145),m3h2x8(:,341),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(271),n2h8(253))
  call Hloop_WQ_A(ntryL,G0H16(68),ex1(:),G0H8(145),m3h2x8(:,342),heltab2x16(:,:,446))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(272),n2h8(254))
  call Hloop_AQ_Z(ntryL,G1H16(203),ex1(:),G1H8(273),ngZd,m3h2x8(:,343),heltab2x16(:,:,447))
  call Hloop_AQ_W(ntryL,G1H16(204),ex1(:),G1H8(274),m3h2x8(:,344),heltab2x16(:,:,448))
  call Hloop_WQ_A(ntryL,G1H16(205),ex1(:),G1H8(275),m3h2x8(:,345),heltab2x16(:,:,449))
  call Hloop_Q_A(ntryL,G1H8(275),17,nMT,G2H8(39),n2h8(255))
  call Hloop_WQ_A(ntryL,G1H16(206),ex1(:),G1H8(275),m3h2x8(:,346),heltab2x16(:,:,450))
  call Hloop_Q_A(ntryL,G1H8(275),17,nMT,G2H8(40),n2h8(256))
  call Hloop_AQ_S(ntryL,G1H16(207),ex1(:),G1H8(275),ngPtb,m3h2x8(:,347),heltab2x16(:,:,451))
  call Hloop_AQ_S(ntryL,G1H16(208),ex1(:),G1H8(276),ngH,m3h2x8(:,348),heltab2x16(:,:,452))
  call Hloop_AQ_S(ntryL,G1H16(209),ex1(:),G1H8(277),ngX,m3h2x8(:,349),heltab2x16(:,:,453))
  call Hloop_AQ_S(ntryL,G1H16(210),ex1(:),G1H8(278),ngPtb,m3h2x8(:,350),heltab2x16(:,:,454))
  call Hloop_SQ_A(ntryL,G1H16(211),ex1(:),G1H8(279),ngPtb,m3h2x8(:,351),heltab2x16(:,:,455))
  call Hloop_Q_A(ntryL,G1H8(279),17,nMT,G2H8(41),n2h8(257))
  call Hloop_SQ_A(ntryL,G1H16(212),ex1(:),G1H8(279),ngPtb,m3h2x8(:,352),heltab2x16(:,:,456))
  call Hloop_Q_A(ntryL,G1H8(279),17,nMT,G2H8(42),n2h8(258))
  call Hloop_AQ_S(ntryL,G1H16(213),ex1(:),G1H8(279),ngPtb,m3h2x8(:,353),heltab2x16(:,:,457))
  call Hloop_AQ_S(ntryL,G1H16(214),ex1(:),G1H8(280),ngH,m3h2x8(:,354),heltab2x16(:,:,458))
  call Hloop_AQ_S(ntryL,G1H16(215),ex1(:),G1H8(281),ngPtb,m3h2x8(:,355),heltab2x16(:,:,459))
  call Hloop_AQ_W(ntryL,G1H16(216),ex1(:),G1H8(282),m3h2x8(:,356),heltab2x16(:,:,460))
  call Hloop_AQ_Z(ntryL,G1H16(217),ex1(:),G1H8(283),ngZd,m3h2x8(:,357),heltab2x16(:,:,461))
  call Hloop_AQ_W(ntryL,G1H16(218),ex1(:),G1H8(284),m3h2x8(:,358),heltab2x16(:,:,462))
  call Hloop_SQ_A(ntryL,G0H16(69),ex1(:),G0H8(145),ngPtb,m3h2x8(:,359),heltab2x16(:,:,463))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(285),n2h8(259))
  call Hloop_SQ_A(ntryL,G0H16(70),ex1(:),G0H8(145),ngPtb,m3h2x8(:,360),heltab2x16(:,:,464))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(286),n2h8(260))
  call Hloop_WQ_A(ntryL,G0H16(71),ex1(:),G0H8(145),m3h2x8(:,361),heltab2x16(:,:,465))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(287),n2h8(261))
  call Hloop_WQ_A(ntryL,G0H16(72),ex1(:),G0H8(145),m3h2x8(:,362),heltab2x16(:,:,466))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(288),n2h8(262))
  call Hloop_AQ_W(ntryL,G1H16(219),ex1(:),G1H8(289),m3h2x8(:,363),heltab2x16(:,:,467))
  call Hloop_AQ_W(ntryL,G1H16(220),ex1(:),G1H8(290),m3h2x8(:,364),heltab2x16(:,:,468))
  call Hloop_WQ_A(ntryL,G1H16(221),ex1(:),G1H8(291),m3h2x8(:,365),heltab2x16(:,:,469))
  call Hloop_Q_A(ntryL,G1H8(291),17,nMT,G2H8(43),n2h8(263))
  call Hloop_WQ_A(ntryL,G1H16(222),ex1(:),G1H8(291),m3h2x8(:,366),heltab2x16(:,:,470))
  call Hloop_Q_A(ntryL,G1H8(291),17,nMT,G2H8(44),n2h8(264))
  call Hloop_AQ_S(ntryL,G1H16(223),ex2(:),G1H8(291),ngH,m3h2x8(:,367),heltab2x16(:,:,471))
  call Hloop_AQ_S(ntryL,G1H16(224),ex2(:),G1H8(292),ngX,m3h2x8(:,368),heltab2x16(:,:,472))
  call Hloop_AQ_S(ntryL,G1H16(225),ex2(:),G1H8(293),ngPtb,m3h2x8(:,369),heltab2x16(:,:,473))
  call Hloop_AQ_S(ntryL,G1H16(226),ex2(:),G1H8(294),ngH,m3h2x8(:,370),heltab2x16(:,:,474))
  call Hloop_AQ_S(ntryL,G1H16(227),ex2(:),G1H8(295),ngX,m3h2x8(:,371),heltab2x16(:,:,475))
  call Hloop_AQ_S(ntryL,G1H16(228),ex2(:),G1H8(296),ngPtb,m3h2x8(:,372),heltab2x16(:,:,476))
  call Hloop_SQ_A(ntryL,G1H16(229),ex2(:),G1H8(297),ngPtb,m3h2x8(:,373),heltab2x16(:,:,477))
  call Hloop_Q_A(ntryL,G1H8(297),18,nMT,G2H8(45),n2h8(265))
  call Hloop_AQ_V(ntryL,G1H16(230),ex2(:),G1H8(297),m3h2x8(:,374),heltab2x16(:,:,478))
  call Hloop_AQ_Z(ntryL,G1H16(231),ex2(:),G1H8(298),ngZd,m3h2x8(:,375),heltab2x16(:,:,479))
  call Hloop_AQ_W(ntryL,G1H16(232),ex2(:),G1H8(299),m3h2x8(:,376),heltab2x16(:,:,480))
  call Hloop_AQ_V(ntryL,G1H16(233),ex2(:),G1H8(300),m3h2x8(:,377),heltab2x16(:,:,481))
  call Hloop_AQ_Z(ntryL,G1H16(234),ex2(:),G1H8(301),ngZd,m3h2x8(:,378),heltab2x16(:,:,482))
  call Hloop_AQ_W(ntryL,G1H16(235),ex2(:),G1H8(302),m3h2x8(:,379),heltab2x16(:,:,483))
  call Hloop_SQ_A(ntryL,G0H16(73),ex2(:),G0H8(145),ngPtb,m3h2x8(:,380),heltab2x16(:,:,484))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(303),n2h8(266))
  call Hloop_SQ_A(ntryL,G0H16(74),ex2(:),G0H8(145),ngPtb,m3h2x8(:,381),heltab2x16(:,:,485))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(304),n2h8(267))
  call Hloop_SQ_A(ntryL,G1H16(236),ex2(:),G1H8(305),ngPtb,m3h2x8(:,382),heltab2x16(:,:,486))
  call Hloop_Q_A(ntryL,G1H8(305),18,nMT,G2H8(46),n2h8(268))
  call Hloop_SQ_A(ntryL,G1H16(237),ex2(:),G1H8(305),ngPtb,m3h2x8(:,383),heltab2x16(:,:,487))
  call Hloop_Q_A(ntryL,G1H8(305),18,nMT,G2H8(47),n2h8(269))
  call Hloop_WQ_A(ntryL,G0H16(75),ex2(:),G0H8(145),m3h2x8(:,384),heltab2x16(:,:,488))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(305),n2h8(270))
  call Hloop_SQ_A(ntryL,G0H16(76),ex2(:),G0H8(145),ngPtb,m3h2x8(:,385),heltab2x16(:,:,489))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(306),n2h8(271))
  call Hloop_WQ_A(ntryL,G1H16(238),ex2(:),G1H8(307),m3h2x8(:,386),heltab2x16(:,:,490))
  call Hloop_Q_A(ntryL,G1H8(307),18,nMT,G2H8(48),n2h8(272))
  call Hloop_WQ_A(ntryL,G1H16(239),ex2(:),G1H8(307),m3h2x8(:,387),heltab2x16(:,:,491))
  call Hloop_Q_A(ntryL,G1H8(307),18,nMT,G2H8(49),n2h8(273))
  call Hloop_WQ_A(ntryL,G0H16(77),ex2(:),G0H8(145),m3h2x8(:,388),heltab2x16(:,:,492))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(307),n2h8(274))
  call Hloop_WQ_A(ntryL,G0H16(78),ex2(:),G0H8(145),m3h2x8(:,389),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(308),n2h8(275))
  call Hloop_WQ_A(ntryL,G1H16(240),ex2(:),G1H8(309),m3h2x8(:,390),heltab2x16(:,:,494))
  call Hloop_Q_A(ntryL,G1H8(309),18,nMT,G2H8(50),n2h8(276))
  call Hloop_AQ_S(ntryL,G1H16(241),ex2(:),G1H8(309),ngH,m3h2x8(:,391),heltab2x16(:,:,495))
  call Hloop_AQ_S(ntryL,G1H16(242),ex2(:),G1H8(310),ngX,m3h2x8(:,392),heltab2x16(:,:,496))
  call Hloop_AQ_S(ntryL,G1H16(243),ex2(:),G1H8(311),ngPtb,m3h2x8(:,393),heltab2x16(:,:,497))
  call Hloop_AQ_S(ntryL,G1H16(244),ex2(:),G1H8(312),ngH,m3h2x8(:,394),heltab2x16(:,:,498))
  call Hloop_AQ_S(ntryL,G1H16(245),ex2(:),G1H8(313),ngX,m3h2x8(:,395),heltab2x16(:,:,499))
  call Hloop_AQ_S(ntryL,G1H16(246),ex2(:),G1H8(314),ngPtb,m3h2x8(:,396),heltab2x16(:,:,500))
  call Hloop_SQ_A(ntryL,G1H16(247),ex2(:),G1H8(315),ngPtb,m3h2x8(:,397),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G1H8(315),18,nMT,G2H8(51),n2h8(277))
  call Hloop_SQ_A(ntryL,G1H16(248),ex2(:),G1H8(315),ngPtb,m3h2x8(:,398),heltab2x16(:,:,502))
  call Hloop_Q_A(ntryL,G1H8(315),18,nMT,G2H8(52),n2h8(278))
  call Hloop_AQ_V(ntryL,G1H16(249),ex2(:),G1H8(315),m3h2x8(:,399),heltab2x16(:,:,503))
  call Hloop_AQ_Z(ntryL,G1H16(250),ex2(:),G1H8(316),ngZd,m3h2x8(:,400),heltab2x16(:,:,504))
  call Hloop_AQ_W(ntryL,G1H16(251),ex2(:),G1H8(317),m3h2x8(:,401),heltab2x16(:,:,505))
  call Hloop_AQ_V(ntryL,G1H16(252),ex2(:),G1H8(318),m3h2x8(:,402),heltab2x16(:,:,506))
  call Hloop_AQ_Z(ntryL,G1H16(253),ex2(:),G1H8(319),ngZd,m3h2x8(:,403),heltab2x16(:,:,507))
  call Hloop_AQ_W(ntryL,G1H16(254),ex2(:),G1H8(320),m3h2x8(:,404),heltab2x16(:,:,508))
  call Hloop_SQ_A(ntryL,G0H16(79),ex2(:),G0H8(145),ngPtb,m3h2x8(:,405),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(321),n2h8(279))
  call Hloop_SQ_A(ntryL,G0H16(80),ex2(:),G0H8(145),ngPtb,m3h2x8(:,406),heltab2x16(:,:,510))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(322),n2h8(280))
  call Hloop_SQ_A(ntryL,G1H16(255),ex2(:),G1H8(323),ngPtb,m3h2x8(:,407),heltab2x16(:,:,511))
  call Hloop_Q_A(ntryL,G1H8(323),18,nMT,G2H8(53),n2h8(281))
  call Hloop_SQ_A(ntryL,G1H16(256),ex2(:),G1H8(323),ngPtb,m3h2x8(:,408),heltab2x16(:,:,512))
  call Hloop_Q_A(ntryL,G1H8(323),18,nMT,G2H8(54),n2h8(282))
  call Hloop_WQ_A(ntryL,G0H16(81),ex2(:),G0H8(145),m3h2x8(:,409),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(323),n2h8(283))
  call Hloop_WQ_A(ntryL,G0H16(82),ex2(:),G0H8(145),m3h2x8(:,410),heltab2x16(:,:,514))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(324),n2h8(284))
  call Hloop_SQ_A(ntryL,G0H16(83),ex2(:),G0H8(145),ngPtb,m3h2x8(:,411),heltab2x16(:,:,515))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(325),n2h8(285))
  call Hloop_SQ_A(ntryL,G0H16(84),ex2(:),G0H8(145),ngPtb,m3h2x8(:,412),heltab2x16(:,:,516))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(326),n2h8(286))
  call Hloop_WQ_A(ntryL,G1H16(257),ex2(:),G1H8(327),m3h2x8(:,413),heltab2x16(:,:,517))
  call Hloop_Q_A(ntryL,G1H8(327),18,nMT,G2H8(55),n2h8(287))
  call Hloop_WQ_A(ntryL,G1H16(258),ex2(:),G1H8(327),m3h2x8(:,414),heltab2x16(:,:,518))
  call Hloop_Q_A(ntryL,G1H8(327),18,nMT,G2H8(56),n2h8(288))
  call Hloop_WQ_A(ntryL,G0H16(85),ex2(:),G0H8(145),m3h2x8(:,415),heltab2x16(:,:,519))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(327),n2h8(289))
  call Hloop_WQ_A(ntryL,G0H16(86),ex2(:),G0H8(145),m3h2x8(:,416),heltab2x16(:,:,520))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(328),n2h8(290))
  call Hloop_WQ_A(ntryL,G1H16(259),ex2(:),G1H8(329),m3h2x8(:,417),heltab2x16(:,:,521))
  call Hloop_Q_A(ntryL,G1H8(329),18,nMT,G2H8(57),n2h8(291))
  call Hloop_WQ_A(ntryL,G1H16(260),ex2(:),G1H8(329),m3h2x8(:,418),heltab2x16(:,:,522))
  call Hloop_Q_A(ntryL,G1H8(329),18,nMT,G2H8(58),n2h8(292))
  call Hloop_QA_S(ntryL,G1H16(261),ex3(:),G1H8(329),ngH,m3h2x8(:,419),heltab2x16(:,:,523))
  call Hloop_QA_S(ntryL,G1H16(262),ex3(:),G1H8(330),ngX,m3h2x8(:,420),heltab2x16(:,:,524))
  call Hloop_QA_S(ntryL,G1H16(263),ex3(:),G1H8(331),ngPbt,m3h2x8(:,421),heltab2x16(:,:,525))
  call Hloop_QA_S(ntryL,G1H16(264),ex3(:),G1H8(332),ngH,m3h2x8(:,422),heltab2x16(:,:,526))
  call Hloop_QA_S(ntryL,G1H16(265),ex3(:),G1H8(333),ngX,m3h2x8(:,423),heltab2x16(:,:,527))
  call Hloop_QA_S(ntryL,G1H16(266),ex3(:),G1H8(334),ngPbt,m3h2x8(:,424),heltab2x16(:,:,528))
  call Hloop_SA_Q(ntryL,G1H16(267),ex3(:),G1H8(335),ngPbt,m3h2x8(:,425),heltab2x16(:,:,529))
  call Hloop_A_Q(ntryL,G1H8(335),20,nMT,G2H8(59),n2h8(293))
  call Hloop_QA_V(ntryL,G1H16(268),ex3(:),G1H8(335),m3h2x8(:,426),heltab2x16(:,:,530))
  call Hloop_QA_Z(ntryL,G1H16(269),ex3(:),G1H8(336),ngZd,m3h2x8(:,427),heltab2x16(:,:,531))
  call Hloop_QA_W(ntryL,G1H16(270),ex3(:),G1H8(337),m3h2x8(:,428),heltab2x16(:,:,532))
  call Hloop_QA_V(ntryL,G1H16(271),ex3(:),G1H8(338),m3h2x8(:,429),heltab2x16(:,:,533))
  call Hloop_QA_Z(ntryL,G1H16(272),ex3(:),G1H8(339),ngZd,m3h2x8(:,430),heltab2x16(:,:,534))
  call Hloop_QA_W(ntryL,G1H16(273),ex3(:),G1H8(340),m3h2x8(:,431),heltab2x16(:,:,535))
  call Hloop_SA_Q(ntryL,G0H16(87),ex3(:),G0H8(145),ngPbt,m3h2x8(:,432),heltab2x16(:,:,536))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(341),n2h8(294))
  call Hloop_SA_Q(ntryL,G0H16(88),ex3(:),G0H8(145),ngPbt,m3h2x8(:,433),heltab2x16(:,:,537))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(342),n2h8(295))
  call Hloop_WA_Q(ntryL,G0H16(89),ex3(:),G0H8(145),m3h2x8(:,434),heltab2x16(:,:,538))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(343),n2h8(296))
  call Hloop_SA_Q(ntryL,G1H16(274),ex3(:),G1H8(344),ngPbt,m3h2x8(:,435),heltab2x16(:,:,539))
  call Hloop_A_Q(ntryL,G1H8(344),20,nMT,G2H8(60),n2h8(297))
  call Hloop_SA_Q(ntryL,G1H16(275),ex3(:),G1H8(344),ngPbt,m3h2x8(:,436),heltab2x16(:,:,540))
  call Hloop_A_Q(ntryL,G1H8(344),20,nMT,G2H8(61),n2h8(298))
  call Hloop_WA_Q(ntryL,G1H16(276),ex3(:),G1H8(344),m3h2x8(:,437),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H8(344),20,nMT,G2H8(62),n2h8(299))
  call Hloop_WA_Q(ntryL,G1H16(277),ex3(:),G1H8(344),m3h2x8(:,438),heltab2x16(:,:,542))
  call Hloop_A_Q(ntryL,G1H8(344),20,nMT,G2H8(63),n2h8(300))
  call Hloop_SA_Q(ntryL,G0H16(90),ex3(:),G0H8(145),ngPbt,m3h2x8(:,439),heltab2x16(:,:,543))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(344),n2h8(301))
  call Hloop_WA_Q(ntryL,G0H16(91),ex3(:),G0H8(145),m3h2x8(:,440),heltab2x16(:,:,544))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(345),n2h8(302))
  call Hloop_WA_Q(ntryL,G0H16(92),ex3(:),G0H8(145),m3h2x8(:,441),heltab2x16(:,:,545))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(346),n2h8(303))
  call Hloop_WA_Q(ntryL,G1H16(278),ex3(:),G1H8(347),m3h2x8(:,442),heltab2x16(:,:,546))
  call Hloop_A_Q(ntryL,G1H8(347),20,nMT,G2H8(64),n2h8(304))
  call Hloop_QA_S(ntryL,G1H16(279),ex3(:),G1H8(347),ngH,m3h2x8(:,443),heltab2x16(:,:,547))
  call Hloop_QA_S(ntryL,G1H16(280),ex3(:),G1H8(348),ngX,m3h2x8(:,444),heltab2x16(:,:,548))
  call Hloop_QA_S(ntryL,G1H16(281),ex3(:),G1H8(349),ngPbt,m3h2x8(:,445),heltab2x16(:,:,549))
  call Hloop_QA_S(ntryL,G1H16(282),ex3(:),G1H8(350),ngH,m3h2x8(:,446),heltab2x16(:,:,550))
  call Hloop_QA_S(ntryL,G1H16(283),ex3(:),G1H8(351),ngX,m3h2x8(:,447),heltab2x16(:,:,551))
  call Hloop_QA_S(ntryL,G1H16(284),ex3(:),G1H8(352),ngPbt,m3h2x8(:,448),heltab2x16(:,:,552))
  call Hloop_SA_Q(ntryL,G1H16(285),ex3(:),G1H8(353),ngPbt,m3h2x8(:,449),heltab2x16(:,:,553))
  call Hloop_A_Q(ntryL,G1H8(353),20,nMT,G2H8(65),n2h8(305))
  call Hloop_SA_Q(ntryL,G1H16(286),ex3(:),G1H8(353),ngPbt,m3h2x8(:,450),heltab2x16(:,:,554))
  call Hloop_A_Q(ntryL,G1H8(353),20,nMT,G2H8(66),n2h8(306))
  call Hloop_QA_V(ntryL,G1H16(287),ex3(:),G1H8(353),m3h2x8(:,451),heltab2x16(:,:,555))
  call Hloop_QA_Z(ntryL,G1H16(288),ex3(:),G1H8(354),ngZd,m3h2x8(:,452),heltab2x16(:,:,556))
  call Hloop_QA_W(ntryL,G1H16(289),ex3(:),G1H8(355),m3h2x8(:,453),heltab2x16(:,:,557))
  call Hloop_QA_V(ntryL,G1H16(290),ex3(:),G1H8(356),m3h2x8(:,454),heltab2x16(:,:,558))
  call Hloop_QA_Z(ntryL,G1H16(291),ex3(:),G1H8(357),ngZd,m3h2x8(:,455),heltab2x16(:,:,559))
  call Hloop_QA_W(ntryL,G1H16(292),ex3(:),G1H8(358),m3h2x8(:,456),heltab2x16(:,:,560))
  call Hloop_SA_Q(ntryL,G0H16(93),ex3(:),G0H8(145),ngPbt,m3h2x8(:,457),heltab2x16(:,:,561))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(359),n2h8(307))
  call Hloop_SA_Q(ntryL,G0H16(94),ex3(:),G0H8(145),ngPbt,m3h2x8(:,458),heltab2x16(:,:,562))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(360),n2h8(308))
  call Hloop_WA_Q(ntryL,G0H16(95),ex3(:),G0H8(145),m3h2x8(:,459),heltab2x16(:,:,563))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(361),n2h8(309))
  call Hloop_WA_Q(ntryL,G0H16(96),ex3(:),G0H8(145),m3h2x8(:,460),heltab2x16(:,:,564))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(362),n2h8(310))
  call Hloop_SA_Q(ntryL,G1H16(293),ex3(:),G1H8(363),ngPbt,m3h2x8(:,461),heltab2x16(:,:,565))
  call Hloop_A_Q(ntryL,G1H8(363),20,nMT,G2H8(67),n2h8(311))
  call Hloop_SA_Q(ntryL,G1H16(294),ex3(:),G1H8(363),ngPbt,m3h2x8(:,462),heltab2x16(:,:,566))
  call Hloop_A_Q(ntryL,G1H8(363),20,nMT,G2H8(68),n2h8(312))
  call Hloop_WA_Q(ntryL,G1H16(295),ex3(:),G1H8(363),m3h2x8(:,463),heltab2x16(:,:,567))
  call Hloop_A_Q(ntryL,G1H8(363),20,nMT,G2H8(69),n2h8(313))
  call Hloop_WA_Q(ntryL,G1H16(296),ex3(:),G1H8(363),m3h2x8(:,464),heltab2x16(:,:,568))
  call Hloop_A_Q(ntryL,G1H8(363),20,nMT,G2H8(70),n2h8(314))
  call Hloop_SA_Q(ntryL,G0H16(97),ex3(:),G0H8(145),ngPbt,m3h2x8(:,465),heltab2x16(:,:,569))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(363),n2h8(315))
  call Hloop_SA_Q(ntryL,G0H16(98),ex3(:),G0H8(145),ngPbt,m3h2x8(:,466),heltab2x16(:,:,570))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(364),n2h8(316))
  call Hloop_WA_Q(ntryL,G0H16(99),ex3(:),G0H8(145),m3h2x8(:,467),heltab2x16(:,:,571))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(365),n2h8(317))
  call Hloop_WA_Q(ntryL,G0H16(100),ex3(:),G0H8(145),m3h2x8(:,468),heltab2x16(:,:,572))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(366),n2h8(318))
  call Hloop_WA_Q(ntryL,G1H16(297),ex3(:),G1H8(367),m3h2x8(:,469),heltab2x16(:,:,573))
  call Hloop_A_Q(ntryL,G1H8(367),20,nMT,G2H8(71),n2h8(319))
  call Hloop_WA_Q(ntryL,G1H16(298),ex3(:),G1H8(367),m3h2x8(:,470),heltab2x16(:,:,574))
  call Hloop_A_Q(ntryL,G1H8(367),20,nMT,G2H8(72),n2h8(320))
  call Hloop_AQ_S(ntryL,G1H16(299),ex2(:),G1H8(367),ngH,m3h2x8(:,471),heltab2x16(:,:,575))
  call Hloop_AQ_S(ntryL,G1H16(300),ex2(:),G1H8(368),ngX,m3h2x8(:,472),heltab2x16(:,:,576))
  call Hloop_AQ_S(ntryL,G1H16(301),ex2(:),G1H8(369),ngPtb,m3h2x8(:,473),heltab2x16(:,:,577))
  call Hloop_AQ_S(ntryL,G1H16(302),ex2(:),G1H8(370),ngH,m3h2x8(:,474),heltab2x16(:,:,578))
  call Hloop_AQ_S(ntryL,G1H16(303),ex2(:),G1H8(371),ngX,m3h2x8(:,475),heltab2x16(:,:,579))
  call Hloop_SQ_A(ntryL,G1H16(304),ex2(:),G1H8(372),ngPtb,m3h2x8(:,476),heltab2x16(:,:,580))
  call Hloop_Q_A(ntryL,G1H8(372),18,nMT,G2H8(73),n2h8(321))
  call Hloop_SQ_A(ntryL,G1H16(305),ex2(:),G1H8(372),ngPtb,m3h2x8(:,477),heltab2x16(:,:,581))
  call Hloop_Q_A(ntryL,G1H8(372),18,nMT,G2H8(74),n2h8(322))
  call Hloop_AQ_S(ntryL,G1H16(306),ex2(:),G1H8(372),ngX,m3h2x8(:,478),heltab2x16(:,:,582))
  call Hloop_AQ_S(ntryL,G1H16(307),ex2(:),G1H8(373),ngPtb,m3h2x8(:,479),heltab2x16(:,:,583))
  call Hloop_AQ_S(ntryL,G1H16(308),ex2(:),G1H8(374),ngH,m3h2x8(:,480),heltab2x16(:,:,584))
  call Hloop_AQ_S(ntryL,G1H16(309),ex2(:),G1H8(375),ngPtb,m3h2x8(:,481),heltab2x16(:,:,585))
  call Hloop_AQ_Z(ntryL,G1H16(310),ex2(:),G1H8(376),ngZd,m3h2x8(:,482),heltab2x16(:,:,586))
  call Hloop_AQ_W(ntryL,G1H16(311),ex2(:),G1H8(377),m3h2x8(:,483),heltab2x16(:,:,587))
  call Hloop_AQ_Z(ntryL,G1H16(312),ex2(:),G1H8(378),ngZd,m3h2x8(:,484),heltab2x16(:,:,588))
  call Hloop_AQ_W(ntryL,G1H16(313),ex2(:),G1H8(379),m3h2x8(:,485),heltab2x16(:,:,589))
  call Hloop_SQ_A(ntryL,G0H16(101),ex2(:),G0H8(145),ngPtb,m3h2x8(:,486),heltab2x16(:,:,590))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(380),n2h8(323))
  call Hloop_SQ_A(ntryL,G0H16(102),ex2(:),G0H8(145),ngPtb,m3h2x8(:,487),heltab2x16(:,:,591))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(381),n2h8(324))
  call Hloop_WQ_A(ntryL,G0H16(103),ex2(:),G0H8(145),m3h2x8(:,488),heltab2x16(:,:,592))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(382),n2h8(325))
  call Hloop_WQ_A(ntryL,G0H16(104),ex2(:),G0H8(145),m3h2x8(:,489),heltab2x16(:,:,593))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(383),n2h8(326))
  call Hloop_AQ_Z(ntryL,G1H16(314),ex2(:),G1H8(384),ngZd,m3h2x8(:,490),heltab2x16(:,:,594))
  call Hloop_AQ_W(ntryL,G1H16(315),ex2(:),G1H8(385),m3h2x8(:,491),heltab2x16(:,:,595))
  call Hloop_WQ_A(ntryL,G1H16(316),ex2(:),G1H8(386),m3h2x8(:,492),heltab2x16(:,:,596))
  call Hloop_Q_A(ntryL,G1H8(386),18,nMT,G2H8(75),n2h8(327))
  call Hloop_WQ_A(ntryL,G1H16(317),ex2(:),G1H8(386),m3h2x8(:,493),heltab2x16(:,:,597))
  call Hloop_Q_A(ntryL,G1H8(386),18,nMT,G2H8(76),n2h8(328))
  call Hloop_AQ_S(ntryL,G1H16(318),ex2(:),G1H8(386),ngPtb,m3h2x8(:,494),heltab2x16(:,:,598))
  call Hloop_AQ_S(ntryL,G1H16(319),ex2(:),G1H8(387),ngH,m3h2x8(:,495),heltab2x16(:,:,599))
  call Hloop_AQ_S(ntryL,G1H16(320),ex2(:),G1H8(388),ngX,m3h2x8(:,496),heltab2x16(:,:,600))
  call Hloop_AQ_S(ntryL,G1H16(321),ex2(:),G1H8(389),ngPtb,m3h2x8(:,497),heltab2x16(:,:,601))
  call Hloop_SQ_A(ntryL,G1H16(322),ex2(:),G1H8(390),ngPtb,m3h2x8(:,498),heltab2x16(:,:,602))
  call Hloop_Q_A(ntryL,G1H8(390),18,nMT,G2H8(77),n2h8(329))
  call Hloop_SQ_A(ntryL,G1H16(323),ex2(:),G1H8(390),ngPtb,m3h2x8(:,499),heltab2x16(:,:,603))
  call Hloop_Q_A(ntryL,G1H8(390),18,nMT,G2H8(78),n2h8(330))
  call Hloop_AQ_S(ntryL,G1H16(324),ex2(:),G1H8(390),ngPtb,m3h2x8(:,500),heltab2x16(:,:,604))
  call Hloop_AQ_S(ntryL,G1H16(325),ex2(:),G1H8(391),ngH,m3h2x8(:,501),heltab2x16(:,:,605))
  call Hloop_AQ_S(ntryL,G1H16(326),ex2(:),G1H8(392),ngPtb,m3h2x8(:,502),heltab2x16(:,:,606))
  call Hloop_AQ_W(ntryL,G1H16(327),ex2(:),G1H8(393),m3h2x8(:,503),heltab2x16(:,:,607))
  call Hloop_AQ_Z(ntryL,G1H16(328),ex2(:),G1H8(394),ngZd,m3h2x8(:,504),heltab2x16(:,:,608))
  call Hloop_AQ_W(ntryL,G1H16(329),ex2(:),G1H8(395),m3h2x8(:,505),heltab2x16(:,:,609))
  call Hloop_SQ_A(ntryL,G0H16(105),ex2(:),G0H8(145),ngPtb,m3h2x8(:,506),heltab2x16(:,:,610))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(396),n2h8(331))
  call Hloop_SQ_A(ntryL,G0H16(106),ex2(:),G0H8(145),ngPtb,m3h2x8(:,507),heltab2x16(:,:,611))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(397),n2h8(332))
  call Hloop_WQ_A(ntryL,G0H16(107),ex2(:),G0H8(145),m3h2x8(:,508),heltab2x16(:,:,612))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(398),n2h8(333))
  call Hloop_WQ_A(ntryL,G0H16(108),ex2(:),G0H8(145),m3h2x8(:,509),heltab2x16(:,:,613))
  call Hloop_Q_A(ntryL,G0H8(145),18,nMT,G1H8(399),n2h8(334))
  call Hloop_AQ_W(ntryL,G1H16(330),ex2(:),G1H8(400),m3h2x8(:,510),heltab2x16(:,:,614))
  call Hloop_AQ_W(ntryL,G1H16(331),ex2(:),G1H8(401),m3h2x8(:,511),heltab2x16(:,:,615))
  call Hloop_WQ_A(ntryL,G1H16(332),ex2(:),G1H8(402),m3h2x8(:,512),heltab2x16(:,:,616))
  call Hloop_Q_A(ntryL,G1H8(402),18,nMT,G2H8(79),n2h8(335))
  call Hloop_WQ_A(ntryL,G1H16(333),ex2(:),G1H8(402),m3h2x8(:,513),heltab2x16(:,:,617))
  call Hloop_Q_A(ntryL,G1H8(402),18,nMT,G2H8(80),n2h8(336))
  call Hloop_AQ_S(ntryL,G1H16(334),ex1(:),G1H8(402),ngH,m3h2x8(:,514),heltab2x16(:,:,618))
  call Hloop_AQ_S(ntryL,G1H16(335),ex1(:),G1H8(403),ngX,m3h2x8(:,515),heltab2x16(:,:,619))
  call Hloop_AQ_S(ntryL,G1H16(336),ex1(:),G1H8(404),ngPtb,m3h2x8(:,516),heltab2x16(:,:,620))
  call Hloop_AQ_S(ntryL,G1H16(337),ex1(:),G1H8(405),ngH,m3h2x8(:,517),heltab2x16(:,:,621))
  call Hloop_AQ_S(ntryL,G1H16(338),ex1(:),G1H8(406),ngX,m3h2x8(:,518),heltab2x16(:,:,622))
  call Hloop_AQ_S(ntryL,G1H16(339),ex1(:),G1H8(407),ngPtb,m3h2x8(:,519),heltab2x16(:,:,623))
  call Hloop_SQ_A(ntryL,G1H16(340),ex1(:),G1H8(408),ngPtb,m3h2x8(:,520),heltab2x16(:,:,624))
  call Hloop_Q_A(ntryL,G1H8(408),17,nMT,G2H8(81),n2h8(337))
  call Hloop_AQ_V(ntryL,G1H16(341),ex1(:),G1H8(408),m3h2x8(:,521),heltab2x16(:,:,625))
  call Hloop_AQ_Z(ntryL,G1H16(342),ex1(:),G1H8(409),ngZd,m3h2x8(:,522),heltab2x16(:,:,626))
  call Hloop_AQ_W(ntryL,G1H16(343),ex1(:),G1H8(410),m3h2x8(:,523),heltab2x16(:,:,627))
  call Hloop_AQ_V(ntryL,G1H16(344),ex1(:),G1H8(411),m3h2x8(:,524),heltab2x16(:,:,628))
  call Hloop_AQ_Z(ntryL,G1H16(345),ex1(:),G1H8(412),ngZd,m3h2x8(:,525),heltab2x16(:,:,629))
  call Hloop_AQ_W(ntryL,G1H16(346),ex1(:),G1H8(413),m3h2x8(:,526),heltab2x16(:,:,630))
  call Hloop_SQ_A(ntryL,G0H16(109),ex1(:),G0H8(145),ngPtb,m3h2x8(:,527),heltab2x16(:,:,631))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(414),n2h8(338))
  call Hloop_SQ_A(ntryL,G0H16(110),ex1(:),G0H8(145),ngPtb,m3h2x8(:,528),heltab2x16(:,:,632))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(415),n2h8(339))
  call Hloop_SQ_A(ntryL,G1H16(347),ex1(:),G1H8(416),ngPtb,m3h2x8(:,529),heltab2x16(:,:,633))
  call Hloop_Q_A(ntryL,G1H8(416),17,nMT,G2H8(82),n2h8(340))
  call Hloop_SQ_A(ntryL,G1H16(348),ex1(:),G1H8(416),ngPtb,m3h2x8(:,530),heltab2x16(:,:,634))
  call Hloop_Q_A(ntryL,G1H8(416),17,nMT,G2H8(83),n2h8(341))
  call Hloop_WQ_A(ntryL,G0H16(111),ex1(:),G0H8(145),m3h2x8(:,531),heltab2x16(:,:,635))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(416),n2h8(342))
  call Hloop_SQ_A(ntryL,G0H16(112),ex1(:),G0H8(145),ngPtb,m3h2x8(:,532),heltab2x16(:,:,636))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(417),n2h8(343))
  call Hloop_WQ_A(ntryL,G1H16(349),ex1(:),G1H8(418),m3h2x8(:,533),heltab2x16(:,:,637))
  call Hloop_Q_A(ntryL,G1H8(418),17,nMT,G2H8(84),n2h8(344))
  call Hloop_WQ_A(ntryL,G1H16(350),ex1(:),G1H8(418),m3h2x8(:,534),heltab2x16(:,:,638))
  call Hloop_Q_A(ntryL,G1H8(418),17,nMT,G2H8(85),n2h8(345))
  call Hloop_WQ_A(ntryL,G0H16(113),ex1(:),G0H8(145),m3h2x8(:,535),heltab2x16(:,:,639))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(418),n2h8(346))
  call Hloop_WQ_A(ntryL,G0H16(114),ex1(:),G0H8(145),m3h2x8(:,536),heltab2x16(:,:,640))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(419),n2h8(347))
  call Hloop_WQ_A(ntryL,G1H16(351),ex1(:),G1H8(420),m3h2x8(:,537),heltab2x16(:,:,641))
  call Hloop_Q_A(ntryL,G1H8(420),17,nMT,G2H8(86),n2h8(348))
  call Hloop_AQ_S(ntryL,G1H16(352),ex1(:),G1H8(420),ngH,m3h2x8(:,538),heltab2x16(:,:,642))
  call Hloop_AQ_S(ntryL,G1H16(353),ex1(:),G1H8(421),ngX,m3h2x8(:,539),heltab2x16(:,:,643))
  call Hloop_AQ_S(ntryL,G1H16(354),ex1(:),G1H8(422),ngPtb,m3h2x8(:,540),heltab2x16(:,:,644))
  call Hloop_AQ_S(ntryL,G1H16(355),ex1(:),G1H8(423),ngH,m3h2x8(:,541),heltab2x16(:,:,645))
  call Hloop_AQ_S(ntryL,G1H16(356),ex1(:),G1H8(424),ngX,m3h2x8(:,542),heltab2x16(:,:,646))
  call Hloop_AQ_S(ntryL,G1H16(357),ex1(:),G1H8(425),ngPtb,m3h2x8(:,543),heltab2x16(:,:,647))
  call Hloop_SQ_A(ntryL,G1H16(358),ex1(:),G1H8(426),ngPtb,m3h2x8(:,544),heltab2x16(:,:,648))
  call Hloop_Q_A(ntryL,G1H8(426),17,nMT,G2H8(87),n2h8(349))
  call Hloop_SQ_A(ntryL,G1H16(359),ex1(:),G1H8(426),ngPtb,m3h2x8(:,545),heltab2x16(:,:,649))
  call Hloop_Q_A(ntryL,G1H8(426),17,nMT,G2H8(88),n2h8(350))
  call Hloop_AQ_V(ntryL,G1H16(360),ex1(:),G1H8(426),m3h2x8(:,546),heltab2x16(:,:,650))
  call Hloop_AQ_Z(ntryL,G1H16(361),ex1(:),G1H8(427),ngZd,m3h2x8(:,547),heltab2x16(:,:,651))
  call Hloop_AQ_W(ntryL,G1H16(362),ex1(:),G1H8(428),m3h2x8(:,548),heltab2x16(:,:,652))
  call Hloop_AQ_V(ntryL,G1H16(363),ex1(:),G1H8(429),m3h2x8(:,549),heltab2x16(:,:,653))
  call Hloop_AQ_Z(ntryL,G1H16(364),ex1(:),G1H8(430),ngZd,m3h2x8(:,550),heltab2x16(:,:,654))
  call Hloop_AQ_W(ntryL,G1H16(365),ex1(:),G1H8(431),m3h2x8(:,551),heltab2x16(:,:,655))
  call Hloop_SQ_A(ntryL,G0H16(115),ex1(:),G0H8(145),ngPtb,m3h2x8(:,552),heltab2x16(:,:,656))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(432),n2h8(351))
  call Hloop_SQ_A(ntryL,G0H16(116),ex1(:),G0H8(145),ngPtb,m3h2x8(:,553),heltab2x16(:,:,657))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(433),n2h8(352))
  call Hloop_SQ_A(ntryL,G1H16(366),ex1(:),G1H8(434),ngPtb,m3h2x8(:,554),heltab2x16(:,:,658))
  call Hloop_Q_A(ntryL,G1H8(434),17,nMT,G2H8(89),n2h8(353))
  call Hloop_SQ_A(ntryL,G1H16(367),ex1(:),G1H8(434),ngPtb,m3h2x8(:,555),heltab2x16(:,:,659))
  call Hloop_Q_A(ntryL,G1H8(434),17,nMT,G2H8(90),n2h8(354))
  call Hloop_WQ_A(ntryL,G0H16(117),ex1(:),G0H8(145),m3h2x8(:,556),heltab2x16(:,:,660))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(434),n2h8(355))
  call Hloop_WQ_A(ntryL,G0H16(118),ex1(:),G0H8(145),m3h2x8(:,557),heltab2x16(:,:,661))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(435),n2h8(356))
  call Hloop_SQ_A(ntryL,G0H16(119),ex1(:),G0H8(145),ngPtb,m3h2x8(:,558),heltab2x16(:,:,662))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(436),n2h8(357))
  call Hloop_SQ_A(ntryL,G0H16(120),ex1(:),G0H8(145),ngPtb,m3h2x8(:,559),heltab2x16(:,:,663))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(437),n2h8(358))
  call Hloop_WQ_A(ntryL,G1H16(368),ex1(:),G1H8(438),m3h2x8(:,560),heltab2x16(:,:,664))
  call Hloop_Q_A(ntryL,G1H8(438),17,nMT,G2H8(91),n2h8(359))
  call Hloop_WQ_A(ntryL,G1H16(369),ex1(:),G1H8(438),m3h2x8(:,561),heltab2x16(:,:,665))
  call Hloop_Q_A(ntryL,G1H8(438),17,nMT,G2H8(92),n2h8(360))
  call Hloop_WQ_A(ntryL,G0H16(121),ex1(:),G0H8(145),m3h2x8(:,562),heltab2x16(:,:,666))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(438),n2h8(361))
  call Hloop_WQ_A(ntryL,G0H16(122),ex1(:),G0H8(145),m3h2x8(:,563),heltab2x16(:,:,667))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(439),n2h8(362))
  call Hloop_WQ_A(ntryL,G1H16(370),ex1(:),G1H8(440),m3h2x8(:,564),heltab2x16(:,:,668))
  call Hloop_Q_A(ntryL,G1H8(440),17,nMT,G2H8(93),n2h8(363))
  call Hloop_WQ_A(ntryL,G1H16(371),ex1(:),G1H8(440),m3h2x8(:,565),heltab2x16(:,:,669))
  call Hloop_Q_A(ntryL,G1H8(440),17,nMT,G2H8(94),n2h8(364))
  call Hloop_QA_S(ntryL,G1H16(372),ex3(:),G1H8(440),ngH,m3h2x8(:,566),heltab2x16(:,:,670))
  call Hloop_QA_S(ntryL,G1H16(373),ex3(:),G1H8(441),ngX,m3h2x8(:,567),heltab2x16(:,:,671))
  call Hloop_QA_S(ntryL,G1H16(374),ex3(:),G1H8(442),ngPbt,m3h2x8(:,568),heltab2x16(:,:,672))
  call Hloop_QA_S(ntryL,G1H16(375),ex3(:),G1H8(443),ngH,m3h2x8(:,569),heltab2x16(:,:,673))
  call Hloop_QA_S(ntryL,G1H16(376),ex3(:),G1H8(444),ngX,m3h2x8(:,570),heltab2x16(:,:,674))
  call Hloop_QA_S(ntryL,G1H16(377),ex3(:),G1H8(445),ngPbt,m3h2x8(:,571),heltab2x16(:,:,675))
  call Hloop_SA_Q(ntryL,G1H16(378),ex3(:),G1H8(446),ngPbt,m3h2x8(:,572),heltab2x16(:,:,676))
  call Hloop_A_Q(ntryL,G1H8(446),20,nMT,G2H8(95),n2h8(365))
  call Hloop_QA_V(ntryL,G1H16(379),ex3(:),G1H8(446),m3h2x8(:,573),heltab2x16(:,:,677))
  call Hloop_QA_Z(ntryL,G1H16(380),ex3(:),G1H8(447),ngZd,m3h2x8(:,574),heltab2x16(:,:,678))
  call Hloop_QA_W(ntryL,G1H16(381),ex3(:),G1H8(448),m3h2x8(:,575),heltab2x16(:,:,679))
  call Hloop_QA_V(ntryL,G1H16(382),ex3(:),G1H8(449),m3h2x8(:,576),heltab2x16(:,:,680))
  call Hloop_QA_Z(ntryL,G1H16(383),ex3(:),G1H8(450),ngZd,m3h2x8(:,577),heltab2x16(:,:,681))
  call Hloop_QA_W(ntryL,G1H16(384),ex3(:),G1H8(451),m3h2x8(:,578),heltab2x16(:,:,682))
  call Hloop_SA_Q(ntryL,G0H16(123),ex3(:),G0H8(145),ngPbt,m3h2x8(:,579),heltab2x16(:,:,683))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(452),n2h8(366))
  call Hloop_SA_Q(ntryL,G0H16(124),ex3(:),G0H8(145),ngPbt,m3h2x8(:,580),heltab2x16(:,:,684))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(453),n2h8(367))
  call Hloop_WA_Q(ntryL,G0H16(125),ex3(:),G0H8(145),m3h2x8(:,581),heltab2x16(:,:,685))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(454),n2h8(368))
  call Hloop_SA_Q(ntryL,G1H16(385),ex3(:),G1H8(455),ngPbt,m3h2x8(:,582),heltab2x16(:,:,686))
  call Hloop_A_Q(ntryL,G1H8(455),20,nMT,G2H8(96),n2h8(369))
  call Hloop_SA_Q(ntryL,G1H16(386),ex3(:),G1H8(455),ngPbt,m3h2x8(:,583),heltab2x16(:,:,687))
  call Hloop_A_Q(ntryL,G1H8(455),20,nMT,G2H8(97),n2h8(370))
  call Hloop_WA_Q(ntryL,G1H16(387),ex3(:),G1H8(455),m3h2x8(:,584),heltab2x16(:,:,688))
  call Hloop_A_Q(ntryL,G1H8(455),20,nMT,G2H8(98),n2h8(371))
  call Hloop_WA_Q(ntryL,G1H16(388),ex3(:),G1H8(455),m3h2x8(:,585),heltab2x16(:,:,689))
  call Hloop_A_Q(ntryL,G1H8(455),20,nMT,G2H8(99),n2h8(372))
  call Hloop_SA_Q(ntryL,G0H16(126),ex3(:),G0H8(145),ngPbt,m3h2x8(:,586),heltab2x16(:,:,690))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(455),n2h8(373))
  call Hloop_WA_Q(ntryL,G0H16(127),ex3(:),G0H8(145),m3h2x8(:,587),heltab2x16(:,:,691))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(456),n2h8(374))
  call Hloop_WA_Q(ntryL,G0H16(128),ex3(:),G0H8(145),m3h2x8(:,588),heltab2x16(:,:,692))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(457),n2h8(375))
  call Hloop_WA_Q(ntryL,G1H16(389),ex3(:),G1H8(458),m3h2x8(:,589),heltab2x16(:,:,693))
  call Hloop_A_Q(ntryL,G1H8(458),20,nMT,G2H8(100),n2h8(376))
  call Hloop_QA_S(ntryL,G1H16(390),ex3(:),G1H8(458),ngH,m3h2x8(:,590),heltab2x16(:,:,694))
  call Hloop_QA_S(ntryL,G1H16(391),ex3(:),G1H8(459),ngX,m3h2x8(:,591),heltab2x16(:,:,695))
  call Hloop_QA_S(ntryL,G1H16(392),ex3(:),G1H8(460),ngPbt,m3h2x8(:,592),heltab2x16(:,:,696))
  call Hloop_QA_S(ntryL,G1H16(393),ex3(:),G1H8(461),ngH,m3h2x8(:,593),heltab2x16(:,:,697))
  call Hloop_QA_S(ntryL,G1H16(394),ex3(:),G1H8(462),ngX,m3h2x8(:,594),heltab2x16(:,:,698))
  call Hloop_QA_S(ntryL,G1H16(395),ex3(:),G1H8(463),ngPbt,m3h2x8(:,595),heltab2x16(:,:,699))
  call Hloop_SA_Q(ntryL,G1H16(396),ex3(:),G1H8(464),ngPbt,m3h2x8(:,596),heltab2x16(:,:,700))
  call Hloop_A_Q(ntryL,G1H8(464),20,nMT,G2H8(101),n2h8(377))
  call Hloop_SA_Q(ntryL,G1H16(397),ex3(:),G1H8(464),ngPbt,m3h2x8(:,597),heltab2x16(:,:,701))
  call Hloop_A_Q(ntryL,G1H8(464),20,nMT,G2H8(102),n2h8(378))
  call Hloop_QA_V(ntryL,G1H16(398),ex3(:),G1H8(464),m3h2x8(:,598),heltab2x16(:,:,702))
  call Hloop_QA_Z(ntryL,G1H16(399),ex3(:),G1H8(465),ngZd,m3h2x8(:,599),heltab2x16(:,:,703))
  call Hloop_QA_W(ntryL,G1H16(400),ex3(:),G1H8(466),m3h2x8(:,600),heltab2x16(:,:,704))
  call Hloop_QA_V(ntryL,G1H16(401),ex3(:),G1H8(467),m3h2x8(:,601),heltab2x16(:,:,705))
  call Hloop_QA_Z(ntryL,G1H16(402),ex3(:),G1H8(468),ngZd,m3h2x8(:,602),heltab2x16(:,:,706))
  call Hloop_QA_W(ntryL,G1H16(403),ex3(:),G1H8(469),m3h2x8(:,603),heltab2x16(:,:,707))
  call Hloop_SA_Q(ntryL,G0H16(129),ex3(:),G0H8(145),ngPbt,m3h2x8(:,604),heltab2x16(:,:,708))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(470),n2h8(379))
  call Hloop_SA_Q(ntryL,G0H16(130),ex3(:),G0H8(145),ngPbt,m3h2x8(:,605),heltab2x16(:,:,709))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(471),n2h8(380))
  call Hloop_WA_Q(ntryL,G0H16(131),ex3(:),G0H8(145),m3h2x8(:,606),heltab2x16(:,:,710))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(472),n2h8(381))
  call Hloop_WA_Q(ntryL,G0H16(132),ex3(:),G0H8(145),m3h2x8(:,607),heltab2x16(:,:,711))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(473),n2h8(382))
  call Hloop_SA_Q(ntryL,G1H16(404),ex3(:),G1H8(474),ngPbt,m3h2x8(:,608),heltab2x16(:,:,712))
  call Hloop_A_Q(ntryL,G1H8(474),20,nMT,G2H8(103),n2h8(383))
  call Hloop_SA_Q(ntryL,G1H16(405),ex3(:),G1H8(474),ngPbt,m3h2x8(:,609),heltab2x16(:,:,713))
  call Hloop_A_Q(ntryL,G1H8(474),20,nMT,G2H8(104),n2h8(384))
  call Hloop_WA_Q(ntryL,G1H16(406),ex3(:),G1H8(474),m3h2x8(:,610),heltab2x16(:,:,714))
  call Hloop_A_Q(ntryL,G1H8(474),20,nMT,G2H8(105),n2h8(385))
  call Hloop_WA_Q(ntryL,G1H16(407),ex3(:),G1H8(474),m3h2x8(:,611),heltab2x16(:,:,715))
  call Hloop_A_Q(ntryL,G1H8(474),20,nMT,G2H8(106),n2h8(386))
  call Hloop_SA_Q(ntryL,G0H16(133),ex3(:),G0H8(145),ngPbt,m3h2x8(:,612),heltab2x16(:,:,716))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(474),n2h8(387))
  call Hloop_SA_Q(ntryL,G0H16(134),ex3(:),G0H8(145),ngPbt,m3h2x8(:,613),heltab2x16(:,:,717))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(475),n2h8(388))
  call Hloop_WA_Q(ntryL,G0H16(135),ex3(:),G0H8(145),m3h2x8(:,614),heltab2x16(:,:,718))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(476),n2h8(389))
  call Hloop_WA_Q(ntryL,G0H16(136),ex3(:),G0H8(145),m3h2x8(:,615),heltab2x16(:,:,719))
  call Hloop_A_Q(ntryL,G0H8(145),20,nMT,G1H8(477),n2h8(390))
  call Hloop_WA_Q(ntryL,G1H16(408),ex3(:),G1H8(478),m3h2x8(:,616),heltab2x16(:,:,720))
  call Hloop_A_Q(ntryL,G1H8(478),20,nMT,G2H8(107),n2h8(391))
  call Hloop_WA_Q(ntryL,G1H16(409),ex3(:),G1H8(478),m3h2x8(:,617),heltab2x16(:,:,721))
  call Hloop_A_Q(ntryL,G1H8(478),20,nMT,G2H8(108),n2h8(392))
  call Hloop_AQ_S(ntryL,G1H16(410),ex1(:),G1H8(478),ngH,m3h2x8(:,618),heltab2x16(:,:,722))
  call Hloop_AQ_S(ntryL,G1H16(411),ex1(:),G1H8(479),ngX,m3h2x8(:,619),heltab2x16(:,:,723))
  call Hloop_AQ_S(ntryL,G1H16(412),ex1(:),G1H8(480),ngPtb,m3h2x8(:,620),heltab2x16(:,:,724))
  call Hloop_AQ_S(ntryL,G1H16(413),ex1(:),G1H8(481),ngH,m3h2x8(:,621),heltab2x16(:,:,725))
  call Hloop_AQ_S(ntryL,G1H16(414),ex1(:),G1H8(482),ngX,m3h2x8(:,622),heltab2x16(:,:,726))
  call Hloop_SQ_A(ntryL,G1H16(415),ex1(:),G1H8(483),ngPtb,m3h2x8(:,623),heltab2x16(:,:,727))
  call Hloop_Q_A(ntryL,G1H8(483),17,nMT,G2H8(109),n2h8(393))
  call Hloop_SQ_A(ntryL,G1H16(416),ex1(:),G1H8(483),ngPtb,m3h2x8(:,624),heltab2x16(:,:,728))
  call Hloop_Q_A(ntryL,G1H8(483),17,nMT,G2H8(110),n2h8(394))
  call Hloop_AQ_S(ntryL,G1H16(417),ex1(:),G1H8(483),ngX,m3h2x8(:,625),heltab2x16(:,:,729))
  call Hloop_AQ_S(ntryL,G1H16(418),ex1(:),G1H8(484),ngPtb,m3h2x8(:,626),heltab2x16(:,:,730))
  call Hloop_AQ_S(ntryL,G1H16(419),ex1(:),G1H8(485),ngH,m3h2x8(:,627),heltab2x16(:,:,731))
  call Hloop_AQ_S(ntryL,G1H16(420),ex1(:),G1H8(486),ngPtb,m3h2x8(:,628),heltab2x16(:,:,732))
  call Hloop_AQ_Z(ntryL,G1H16(421),ex1(:),G1H8(487),ngZd,m3h2x8(:,629),heltab2x16(:,:,733))
  call Hloop_AQ_W(ntryL,G1H16(422),ex1(:),G1H8(488),m3h2x8(:,630),heltab2x16(:,:,734))
  call Hloop_AQ_Z(ntryL,G1H16(423),ex1(:),G1H8(489),ngZd,m3h2x8(:,631),heltab2x16(:,:,735))
  call Hloop_AQ_W(ntryL,G1H16(424),ex1(:),G1H8(490),m3h2x8(:,632),heltab2x16(:,:,736))
  call Hloop_SQ_A(ntryL,G0H16(137),ex1(:),G0H8(145),ngPtb,m3h2x8(:,633),heltab2x16(:,:,737))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(491),n2h8(395))
  call Hloop_SQ_A(ntryL,G0H16(138),ex1(:),G0H8(145),ngPtb,m3h2x8(:,634),heltab2x16(:,:,738))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(492),n2h8(396))
  call Hloop_WQ_A(ntryL,G0H16(139),ex1(:),G0H8(145),m3h2x8(:,635),heltab2x16(:,:,739))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(493),n2h8(397))
  call Hloop_WQ_A(ntryL,G0H16(140),ex1(:),G0H8(145),m3h2x8(:,636),heltab2x16(:,:,740))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(494),n2h8(398))
  call Hloop_AQ_Z(ntryL,G1H16(425),ex1(:),G1H8(495),ngZd,m3h2x8(:,637),heltab2x16(:,:,741))
  call Hloop_AQ_W(ntryL,G1H16(426),ex1(:),G1H8(496),m3h2x8(:,638),heltab2x16(:,:,742))
  call Hloop_WQ_A(ntryL,G1H16(427),ex1(:),G1H8(497),m3h2x8(:,639),heltab2x16(:,:,743))
  call Hloop_Q_A(ntryL,G1H8(497),17,nMT,G2H8(111),n2h8(399))
  call Hloop_WQ_A(ntryL,G1H16(428),ex1(:),G1H8(497),m3h2x8(:,640),heltab2x16(:,:,744))
  call Hloop_Q_A(ntryL,G1H8(497),17,nMT,G2H8(112),n2h8(400))
  call Hloop_AQ_S(ntryL,G1H16(429),ex1(:),G1H8(497),ngPtb,m3h2x8(:,641),heltab2x16(:,:,745))
  call Hloop_AQ_S(ntryL,G1H16(430),ex1(:),G1H8(498),ngH,m3h2x8(:,642),heltab2x16(:,:,746))
  call Hloop_AQ_S(ntryL,G1H16(431),ex1(:),G1H8(499),ngX,m3h2x8(:,643),heltab2x16(:,:,747))
  call Hloop_AQ_S(ntryL,G1H16(432),ex1(:),G1H8(500),ngPtb,m3h2x8(:,644),heltab2x16(:,:,748))
  call Hloop_SQ_A(ntryL,G1H16(433),ex1(:),G1H8(501),ngPtb,m3h2x8(:,645),heltab2x16(:,:,749))
  call Hloop_Q_A(ntryL,G1H8(501),17,nMT,G2H8(113),n2h8(401))
  call Hloop_SQ_A(ntryL,G1H16(434),ex1(:),G1H8(501),ngPtb,m3h2x8(:,646),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G1H8(501),17,nMT,G2H8(114),n2h8(402))
  call Hloop_AQ_S(ntryL,G1H16(435),ex1(:),G1H8(501),ngPtb,m3h2x8(:,647),heltab2x16(:,:,751))
  call Hloop_AQ_S(ntryL,G1H16(436),ex1(:),G1H8(502),ngH,m3h2x8(:,648),heltab2x16(:,:,752))
  call Hloop_AQ_S(ntryL,G1H16(437),ex1(:),G1H8(503),ngPtb,m3h2x8(:,649),heltab2x16(:,:,753))
  call Hloop_AQ_W(ntryL,G1H16(438),ex1(:),G1H8(504),m3h2x8(:,650),heltab2x16(:,:,754))
  call Hloop_AQ_Z(ntryL,G1H16(439),ex1(:),G1H8(505),ngZd,m3h2x8(:,651),heltab2x16(:,:,755))
  call Hloop_AQ_W(ntryL,G1H16(440),ex1(:),G1H8(506),m3h2x8(:,652),heltab2x16(:,:,756))
  call Hloop_SQ_A(ntryL,G0H16(141),ex1(:),G0H8(145),ngPtb,m3h2x8(:,653),heltab2x16(:,:,757))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(507),n2h8(403))
  call Hloop_SQ_A(ntryL,G0H16(142),ex1(:),G0H8(145),ngPtb,m3h2x8(:,654),heltab2x16(:,:,758))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(508),n2h8(404))
  call Hloop_WQ_A(ntryL,G0H16(143),ex1(:),G0H8(145),m3h2x8(:,655),heltab2x16(:,:,759))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(509),n2h8(405))
  call Hloop_WQ_A(ntryL,G0H16(144),ex1(:),G0H8(145),m3h2x8(:,656),heltab2x16(:,:,760))
  call Hloop_Q_A(ntryL,G0H8(145),17,nMT,G1H8(510),n2h8(406))
  call Hloop_AQ_W(ntryL,G1H16(441),ex1(:),G1H8(511),m3h2x8(:,657),heltab2x16(:,:,761))
  call Hloop_AQ_W(ntryL,G1H16(442),ex1(:),G1H8(512),m3h2x8(:,658),heltab2x16(:,:,762))
  call Hloop_WQ_A(ntryL,G1H16(443),ex1(:),G1H8(513),m3h2x8(:,659),heltab2x16(:,:,763))
  call Hloop_Q_A(ntryL,G1H8(513),17,nMT,G2H8(115),n2h8(407))
  call Hloop_WQ_A(ntryL,G1H16(444),ex1(:),G1H8(513),m3h2x8(:,660),heltab2x16(:,:,764))
  call Hloop_Q_A(ntryL,G1H8(513),17,nMT,G2H8(116),n2h8(408))
  call Hloop_SA_Q(ntryL,G0H8(1),ex3(:),G0H4(13),ngH,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(29),n2h4(209))
  call Hloop_SA_Q(ntryL,G0H8(2),ex3(:),G0H4(13),ngX,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(30),n2h4(210))
  call Hloop_SA_Q(ntryL,G0H8(3),ex3(:),G0H4(13),ngH,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(31),n2h4(211))
  call Hloop_SA_Q(ntryL,G0H8(4),ex3(:),G0H4(13),ngX,m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(32),n2h4(212))
  call Hloop_SA_Q(ntryL,G0H8(5),ex3(:),G0H4(13),ngPbt,m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMT,G1H4(35),n2h4(213))
  call Hloop_QA_S(ntryL,G1H8(161),ex3(:),G1H4(36),ngH,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_QA_S(ntryL,G1H8(81),ex3(:),G1H4(37),ngH,m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_QA_S(ntryL,G1H8(80),ex3(:),G1H4(38),ngX,m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_QA_S(ntryL,G1H8(88),ex3(:),G1H4(41),ngX,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_QA_S(ntryL,G1H8(87),ex3(:),G1H4(42),ngPbt,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_VA_Q(ntryL,G0H8(6),ex3(:),G0H4(13),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(43),n2h4(214))
  call Hloop_VA_Q(ntryL,G0H8(7),ex3(:),G0H4(13),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(44),n2h4(215))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex3(:),G0H4(13),ngZd,m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(59),n2h4(216))
  call Hloop_ZA_Q(ntryL,G0H8(9),ex3(:),G0H4(13),ngZd,m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(60),n2h4(217))
  call Hloop_WA_Q(ntryL,G0H8(10),ex3(:),G0H4(13),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMT,G1H4(61),n2h4(218))
  call Hloop_SA_Q(ntryL,G0H8(11),ex3(:),G0H4(13),ngH,m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(62),n2h4(219))
  call Hloop_SA_Q(ntryL,G0H8(12),ex3(:),G0H4(13),ngX,m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(65),n2h4(220))
  call Hloop_SA_Q(ntryL,G0H8(13),ex3(:),G0H4(13),ngH,m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(66),n2h4(221))
  call Hloop_SA_Q(ntryL,G0H8(14),ex3(:),G0H4(13),ngX,m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(68),n2h4(222))
  call Hloop_SA_Q(ntryL,G0H8(15),ex3(:),G0H4(13),ngPbt,m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMT,G1H4(71),n2h4(223))
  call Hloop_QA_S(ntryL,G1H8(105),ex3(:),G1H4(72),ngH,m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QA_S(ntryL,G1H8(104),ex3(:),G1H4(73),ngX,m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QA_S(ntryL,G1H8(112),ex3(:),G1H4(74),ngH,m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_QA_S(ntryL,G1H8(111),ex3(:),G1H4(77),ngX,m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_QA_S(ntryL,G1H8(129),ex3(:),G1H4(85),ngPbt,m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_QA_V(ntryL,G1H8(128),ex3(:),G1H4(86),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_QA_V(ntryL,G1H8(136),ex3(:),G1H4(89),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_QA_Z(ntryL,G1H8(135),ex3(:),G1H4(90),ngZd,m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_QA_Z(ntryL,G1H8(153),ex3(:),G1H4(91),ngZd,m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_QA_W(ntryL,G1H8(152),ex3(:),G1H4(92),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_VA_Q(ntryL,G0H8(16),ex3(:),G0H4(13),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(95),n2h4(224))
  call Hloop_ZA_Q(ntryL,G0H8(17),ex3(:),G0H4(13),ngZd,m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(96),n2h4(225))
  call Hloop_VA_Q(ntryL,G0H8(18),ex3(:),G0H4(13),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(1),n2h4(226))
  call Hloop_ZA_Q(ntryL,G0H8(19),ex3(:),G0H4(13),ngZd,m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMB,G1H4(2),n2h4(227))
  call Hloop_WA_Q(ntryL,G0H8(20),ex3(:),G0H4(13),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(13),21,nMT,G1H4(5),n2h4(228))
  call Hloop_QA_V(ntryL,G1H8(160),ex3(:),G1H4(6),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QA_V(ntryL,G1H8(159),ex3(:),G1H4(97),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_Z(ntryL,G1H8(1),ex3(:),G1H4(98),ngZd,m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_QA_Z(ntryL,G1H8(2),ex3(:),G1H4(99),ngZd,m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_QA_W(ntryL,G1H8(3),ex3(:),G1H4(100),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_SQ_A(ntryL,G0H8(21),ex2(:),G0H4(13),ngH,m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(101),n2h4(229))
  call Hloop_SQ_A(ntryL,G0H8(22),ex2(:),G0H4(13),ngH,m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(102),n2h4(230))
  call Hloop_SQ_A(ntryL,G0H8(23),ex2(:),G0H4(13),ngX,m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(103),n2h4(231))
  call Hloop_SQ_A(ntryL,G0H8(24),ex2(:),G0H4(13),ngX,m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(104),n2h4(232))
  call Hloop_SQ_A(ntryL,G0H8(25),ex2(:),G0H4(13),ngH,m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(105),n2h4(233))
  call Hloop_SQ_A(ntryL,G0H8(26),ex2(:),G0H4(13),ngX,m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(106),n2h4(234))
  call Hloop_SQ_A(ntryL,G0H8(27),ex2(:),G0H4(13),ngH,m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(107),n2h4(235))
  call Hloop_SQ_A(ntryL,G0H8(28),ex2(:),G0H4(13),ngX,m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(108),n2h4(236))
  call Hloop_VQ_A(ntryL,G0H8(29),ex2(:),G0H4(13),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(109),n2h4(237))
  call Hloop_VQ_A(ntryL,G0H8(30),ex2(:),G0H4(13),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(110),n2h4(238))
  call Hloop_ZQ_A(ntryL,G0H8(31),ex2(:),G0H4(13),ngZd,m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(111),n2h4(239))
  call Hloop_ZQ_A(ntryL,G0H8(32),ex2(:),G0H4(13),ngZd,m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(112),n2h4(240))
  call Hloop_VQ_A(ntryL,G0H8(33),ex2(:),G0H4(13),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(113),n2h4(241))
  call Hloop_VQ_A(ntryL,G0H8(34),ex2(:),G0H4(13),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(114),n2h4(242))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex2(:),G0H4(13),ngZd,m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(115),n2h4(243))
  call Hloop_ZQ_A(ntryL,G0H8(36),ex2(:),G0H4(13),ngZd,m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(116),n2h4(244))
  call Hloop_SQ_A(ntryL,G0H8(37),ex2(:),G0H4(13),ngH,m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(117),n2h4(245))
  call Hloop_SQ_A(ntryL,G0H8(38),ex2(:),G0H4(13),ngH,m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(118),n2h4(246))
  call Hloop_SQ_A(ntryL,G0H8(39),ex2(:),G0H4(13),ngX,m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(119),n2h4(247))
  call Hloop_SQ_A(ntryL,G0H8(40),ex2(:),G0H4(13),ngX,m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(120),n2h4(248))
  call Hloop_SQ_A(ntryL,G0H8(41),ex2(:),G0H4(13),ngH,m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(121),n2h4(249))
  call Hloop_SQ_A(ntryL,G0H8(42),ex2(:),G0H4(13),ngX,m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(122),n2h4(250))
  call Hloop_SQ_A(ntryL,G0H8(43),ex2(:),G0H4(13),ngH,m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(123),n2h4(251))
  call Hloop_SQ_A(ntryL,G0H8(44),ex2(:),G0H4(13),ngX,m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(124),n2h4(252))
  call Hloop_VQ_A(ntryL,G0H8(45),ex2(:),G0H4(13),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(125),n2h4(253))
  call Hloop_VQ_A(ntryL,G0H8(46),ex2(:),G0H4(13),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(126),n2h4(254))
  call Hloop_ZQ_A(ntryL,G0H8(47),ex2(:),G0H4(13),ngZd,m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(127),n2h4(255))
  call Hloop_ZQ_A(ntryL,G0H8(48),ex2(:),G0H4(13),ngZd,m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(128),n2h4(256))
  call Hloop_VQ_A(ntryL,G0H8(49),ex2(:),G0H4(13),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(129),n2h4(257))
  call Hloop_VQ_A(ntryL,G0H8(50),ex2(:),G0H4(13),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(130),n2h4(258))
  call Hloop_ZQ_A(ntryL,G0H8(51),ex2(:),G0H4(13),ngZd,m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(131),n2h4(259))
  call Hloop_ZQ_A(ntryL,G0H8(52),ex2(:),G0H4(13),ngZd,m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(132),n2h4(260))
  call Hloop_SA_Q(ntryL,G0H8(53),ex3(:),G0H4(13),ngH,m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(133),n2h4(261))
  call Hloop_SA_Q(ntryL,G0H8(54),ex3(:),G0H4(13),ngX,m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(134),n2h4(262))
  call Hloop_SA_Q(ntryL,G0H8(55),ex3(:),G0H4(13),ngH,m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(135),n2h4(263))
  call Hloop_SA_Q(ntryL,G0H8(56),ex3(:),G0H4(13),ngX,m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(136),n2h4(264))
  call Hloop_SA_Q(ntryL,G0H8(57),ex3(:),G0H4(13),ngPbt,m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMT,G1H4(137),n2h4(265))
  call Hloop_QA_S(ntryL,G1H8(4),ex3(:),G1H4(138),ngH,m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_QA_S(ntryL,G1H8(5),ex3(:),G1H4(139),ngH,m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_QA_S(ntryL,G1H8(6),ex3(:),G1H4(140),ngX,m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_QA_S(ntryL,G1H8(7),ex3(:),G1H4(141),ngX,m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_QA_S(ntryL,G1H8(8),ex3(:),G1H4(142),ngPbt,m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_VA_Q(ntryL,G0H8(58),ex3(:),G0H4(13),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(143),n2h4(266))
  call Hloop_VA_Q(ntryL,G0H8(59),ex3(:),G0H4(13),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(144),n2h4(267))
  call Hloop_ZA_Q(ntryL,G0H8(60),ex3(:),G0H4(13),ngZd,m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(145),n2h4(268))
  call Hloop_ZA_Q(ntryL,G0H8(61),ex3(:),G0H4(13),ngZd,m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(146),n2h4(269))
  call Hloop_WA_Q(ntryL,G0H8(62),ex3(:),G0H4(13),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMT,G1H4(147),n2h4(270))
  call Hloop_SA_Q(ntryL,G0H8(63),ex3(:),G0H4(13),ngH,m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(148),n2h4(271))
  call Hloop_SA_Q(ntryL,G0H8(64),ex3(:),G0H4(13),ngX,m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(149),n2h4(272))
  call Hloop_SA_Q(ntryL,G0H8(65),ex3(:),G0H4(13),ngH,m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(150),n2h4(273))
  call Hloop_SA_Q(ntryL,G0H8(66),ex3(:),G0H4(13),ngX,m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(151),n2h4(274))
  call Hloop_SA_Q(ntryL,G0H8(67),ex3(:),G0H4(13),ngPbt,m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMT,G1H4(152),n2h4(275))
  call Hloop_QA_S(ntryL,G1H8(9),ex3(:),G1H4(153),ngH,m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_QA_S(ntryL,G1H8(10),ex3(:),G1H4(154),ngX,m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_QA_S(ntryL,G1H8(11),ex3(:),G1H4(155),ngH,m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_QA_S(ntryL,G1H8(12),ex3(:),G1H4(156),ngX,m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_QA_S(ntryL,G1H8(13),ex3(:),G1H4(157),ngPbt,m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_QA_V(ntryL,G1H8(14),ex3(:),G1H4(158),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_QA_V(ntryL,G1H8(15),ex3(:),G1H4(159),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_QA_Z(ntryL,G1H8(16),ex3(:),G1H4(160),ngZd,m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_QA_Z(ntryL,G1H8(17),ex3(:),G1H4(161),ngZd,m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_QA_W(ntryL,G1H8(18),ex3(:),G1H4(162),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_VA_Q(ntryL,G0H8(68),ex3(:),G0H4(13),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(163),n2h4(276))
  call Hloop_ZA_Q(ntryL,G0H8(69),ex3(:),G0H4(13),ngZd,m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(164),n2h4(277))
  call Hloop_VA_Q(ntryL,G0H8(70),ex3(:),G0H4(13),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(165),n2h4(278))
  call Hloop_ZA_Q(ntryL,G0H8(71),ex3(:),G0H4(13),ngZd,m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(166),n2h4(279))
  call Hloop_WA_Q(ntryL,G0H8(72),ex3(:),G0H4(13),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMT,G1H4(167),n2h4(280))
  call Hloop_QA_V(ntryL,G1H8(19),ex3(:),G1H4(168),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_QA_V(ntryL,G1H8(20),ex3(:),G1H4(169),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_QA_Z(ntryL,G1H8(21),ex3(:),G1H4(170),ngZd,m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_QA_Z(ntryL,G1H8(22),ex3(:),G1H4(171),ngZd,m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_QA_W(ntryL,G1H8(23),ex3(:),G1H4(172),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_SQ_A(ntryL,G0H8(73),ex1(:),G0H4(13),ngH,m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(173),n2h4(281))
  call Hloop_SQ_A(ntryL,G0H8(74),ex1(:),G0H4(13),ngH,m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(174),n2h4(282))
  call Hloop_SQ_A(ntryL,G0H8(75),ex1(:),G0H4(13),ngX,m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(175),n2h4(283))
  call Hloop_SQ_A(ntryL,G0H8(76),ex1(:),G0H4(13),ngX,m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(176),n2h4(284))
  call Hloop_SQ_A(ntryL,G0H8(77),ex1(:),G0H4(13),ngH,m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(177),n2h4(285))
  call Hloop_SQ_A(ntryL,G0H8(78),ex1(:),G0H4(13),ngX,m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(178),n2h4(286))
  call Hloop_SQ_A(ntryL,G0H8(79),ex1(:),G0H4(13),ngH,m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(179),n2h4(287))
  call Hloop_SQ_A(ntryL,G0H8(80),ex1(:),G0H4(13),ngX,m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(180),n2h4(288))
  call Hloop_VQ_A(ntryL,G0H8(81),ex1(:),G0H4(13),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(181),n2h4(289))
  call Hloop_VQ_A(ntryL,G0H8(82),ex1(:),G0H4(13),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(182),n2h4(290))
  call Hloop_ZQ_A(ntryL,G0H8(83),ex1(:),G0H4(13),ngZd,m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(183),n2h4(291))
  call Hloop_ZQ_A(ntryL,G0H8(84),ex1(:),G0H4(13),ngZd,m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(184),n2h4(292))
  call Hloop_VQ_A(ntryL,G0H8(85),ex1(:),G0H4(13),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(185),n2h4(293))
  call Hloop_VQ_A(ntryL,G0H8(86),ex1(:),G0H4(13),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(186),n2h4(294))
  call Hloop_ZQ_A(ntryL,G0H8(87),ex1(:),G0H4(13),ngZd,m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(187),n2h4(295))
  call Hloop_ZQ_A(ntryL,G0H8(88),ex1(:),G0H4(13),ngZd,m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(188),n2h4(296))
  call Hloop_SQ_A(ntryL,G0H8(89),ex1(:),G0H4(13),ngH,m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(189),n2h4(297))
  call Hloop_SQ_A(ntryL,G0H8(90),ex1(:),G0H4(13),ngH,m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(190),n2h4(298))
  call Hloop_SQ_A(ntryL,G0H8(91),ex1(:),G0H4(13),ngX,m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(191),n2h4(299))
  call Hloop_SQ_A(ntryL,G0H8(92),ex1(:),G0H4(13),ngX,m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(192),n2h4(300))
  call Hloop_SQ_A(ntryL,G0H8(93),ex1(:),G0H4(13),ngH,m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(193),n2h4(301))
  call Hloop_SQ_A(ntryL,G0H8(94),ex1(:),G0H4(13),ngX,m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(194),n2h4(302))
  call Hloop_SQ_A(ntryL,G0H8(95),ex1(:),G0H4(13),ngH,m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(195),n2h4(303))
  call Hloop_SQ_A(ntryL,G0H8(96),ex1(:),G0H4(13),ngX,m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(196),n2h4(304))
  call Hloop_VQ_A(ntryL,G0H8(97),ex1(:),G0H4(13),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(197),n2h4(305))
  call Hloop_VQ_A(ntryL,G0H8(98),ex1(:),G0H4(13),m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(198),n2h4(306))
  call Hloop_ZQ_A(ntryL,G0H8(99),ex1(:),G0H4(13),ngZd,m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(199),n2h4(307))
  call Hloop_ZQ_A(ntryL,G0H8(100),ex1(:),G0H4(13),ngZd,m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(200),n2h4(308))
  call Hloop_VQ_A(ntryL,G0H8(101),ex1(:),G0H4(13),m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(201),n2h4(309))
  call Hloop_VQ_A(ntryL,G0H8(102),ex1(:),G0H4(13),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(202),n2h4(310))
  call Hloop_ZQ_A(ntryL,G0H8(103),ex1(:),G0H4(13),ngZd,m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(203),n2h4(311))
  call Hloop_ZQ_A(ntryL,G0H8(104),ex1(:),G0H4(13),ngZd,m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMB,G1H4(204),n2h4(312))
  call Hloop_AQ_S(ntryL,G1H8(24),ex2(:),G1H4(205),ngH,m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_AQ_S(ntryL,G1H8(25),ex2(:),G1H4(206),ngH,m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_AQ_S(ntryL,G1H8(26),ex2(:),G1H4(207),ngX,m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_AQ_S(ntryL,G1H8(27),ex2(:),G1H4(208),ngX,m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_AQ_S(ntryL,G1H8(28),ex2(:),G1H4(209),ngH,m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_AQ_S(ntryL,G1H8(29),ex2(:),G1H4(210),ngX,m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_AQ_S(ntryL,G1H8(30),ex2(:),G1H4(211),ngH,m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_AQ_S(ntryL,G1H8(31),ex2(:),G1H4(212),ngX,m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_AQ_V(ntryL,G1H8(32),ex2(:),G1H4(213),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_AQ_V(ntryL,G1H8(33),ex2(:),G1H4(214),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_AQ_Z(ntryL,G1H8(34),ex2(:),G1H4(215),ngZd,m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_AQ_Z(ntryL,G1H8(35),ex2(:),G1H4(216),ngZd,m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_AQ_V(ntryL,G1H8(36),ex2(:),G1H4(217),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_AQ_V(ntryL,G1H8(37),ex2(:),G1H4(218),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_AQ_Z(ntryL,G1H8(38),ex2(:),G1H4(219),ngZd,m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_AQ_Z(ntryL,G1H8(39),ex2(:),G1H4(220),ngZd,m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_AQ_S(ntryL,G1H8(40),ex1(:),G1H4(221),ngH,m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_AQ_S(ntryL,G1H8(41),ex1(:),G1H4(222),ngH,m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_AQ_S(ntryL,G1H8(42),ex1(:),G1H4(223),ngX,m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_AQ_S(ntryL,G1H8(43),ex1(:),G1H4(224),ngX,m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_AQ_S(ntryL,G1H8(44),ex1(:),G1H4(225),ngH,m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_AQ_S(ntryL,G1H8(45),ex1(:),G1H4(226),ngX,m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_AQ_S(ntryL,G1H8(46),ex1(:),G1H4(227),ngH,m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_AQ_S(ntryL,G1H8(47),ex1(:),G1H4(228),ngX,m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_AQ_V(ntryL,G1H8(48),ex1(:),G1H4(229),m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_AQ_V(ntryL,G1H8(49),ex1(:),G1H4(230),m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_AQ_Z(ntryL,G1H8(50),ex1(:),G1H4(231),ngZd,m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H8(51),ex1(:),G1H4(232),ngZd,m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_AQ_V(ntryL,G1H8(52),ex1(:),G1H4(233),m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_AQ_V(ntryL,G1H8(53),ex1(:),G1H4(234),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_AQ_Z(ntryL,G1H8(54),ex1(:),G1H4(235),ngZd,m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_AQ_Z(ntryL,G1H8(55),ex1(:),G1H4(236),ngZd,m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_SQ_A(ntryL,G0H8(105),ex1(:),G0H4(13),ngH,m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(237),n2h4(313))
  call Hloop_SQ_A(ntryL,G0H8(106),ex1(:),G0H4(13),ngH,m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(238),n2h4(314))
  call Hloop_SQ_A(ntryL,G0H8(107),ex1(:),G0H4(13),ngX,m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(239),n2h4(315))
  call Hloop_SQ_A(ntryL,G0H8(108),ex1(:),G0H4(13),ngX,m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(240),n2h4(316))
  call Hloop_SQ_A(ntryL,G0H8(109),ex1(:),G0H4(13),ngPtb,m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMT,G1H4(241),n2h4(317))
  call Hloop_AQ_S(ntryL,G1H8(56),ex1(:),G1H4(242),ngH,m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_AQ_S(ntryL,G1H8(57),ex1(:),G1H4(243),ngH,m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_AQ_S(ntryL,G1H8(58),ex1(:),G1H4(244),ngX,m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_AQ_S(ntryL,G1H8(59),ex1(:),G1H4(245),ngX,m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_AQ_S(ntryL,G1H8(60),ex1(:),G1H4(246),ngPtb,m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_SQ_A(ntryL,G0H8(110),ex1(:),G0H4(13),ngH,m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(247),n2h4(318))
  call Hloop_SQ_A(ntryL,G0H8(111),ex1(:),G0H4(13),ngX,m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(248),n2h4(319))
  call Hloop_SQ_A(ntryL,G0H8(112),ex1(:),G0H4(13),ngH,m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(249),n2h4(320))
  call Hloop_SQ_A(ntryL,G0H8(113),ex1(:),G0H4(13),ngX,m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(250),n2h4(321))
  call Hloop_SQ_A(ntryL,G0H8(114),ex1(:),G0H4(13),ngPtb,m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMT,G1H4(251),n2h4(322))
  call Hloop_VQ_A(ntryL,G0H8(115),ex1(:),G0H4(13),m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(252),n2h4(323))
  call Hloop_VQ_A(ntryL,G0H8(116),ex1(:),G0H4(13),m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(253),n2h4(324))
  call Hloop_ZQ_A(ntryL,G0H8(117),ex1(:),G0H4(13),ngZd,m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(254),n2h4(325))
  call Hloop_ZQ_A(ntryL,G0H8(118),ex1(:),G0H4(13),ngZd,m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(255),n2h4(326))
  call Hloop_WQ_A(ntryL,G0H8(119),ex1(:),G0H4(13),m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMT,G1H4(256),n2h4(327))
  call Hloop_AQ_S(ntryL,G1H8(61),ex1(:),G1H4(257),ngH,m3h2x4(:,357),heltab2x8(:,:,357))
  call Hloop_AQ_S(ntryL,G1H8(62),ex1(:),G1H4(258),ngX,m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_AQ_S(ntryL,G1H8(63),ex1(:),G1H4(259),ngH,m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_AQ_S(ntryL,G1H8(64),ex1(:),G1H4(260),ngX,m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_AQ_S(ntryL,G1H8(65),ex1(:),G1H4(261),ngPtb,m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_AQ_V(ntryL,G1H8(66),ex1(:),G1H4(262),m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_AQ_V(ntryL,G1H8(67),ex1(:),G1H4(263),m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_AQ_Z(ntryL,G1H8(68),ex1(:),G1H4(264),ngZd,m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_AQ_Z(ntryL,G1H8(69),ex1(:),G1H4(265),ngZd,m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_AQ_W(ntryL,G1H8(70),ex1(:),G1H4(266),m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_VQ_A(ntryL,G0H8(120),ex1(:),G0H4(13),m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(267),n2h4(328))
  call Hloop_VQ_A(ntryL,G0H8(121),ex1(:),G0H4(13),m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(268),n2h4(329))
  call Hloop_ZQ_A(ntryL,G0H8(122),ex1(:),G0H4(13),ngZd,m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(269),n2h4(330))
  call Hloop_ZQ_A(ntryL,G0H8(123),ex1(:),G0H4(13),ngZd,m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(270),n2h4(331))
  call Hloop_WQ_A(ntryL,G0H8(124),ex1(:),G0H4(13),m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMT,G1H4(271),n2h4(332))
  call Hloop_AQ_V(ntryL,G1H8(71),ex1(:),G1H4(272),m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_AQ_V(ntryL,G1H8(72),ex1(:),G1H4(273),m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_AQ_Z(ntryL,G1H8(73),ex1(:),G1H4(274),ngZd,m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_AQ_Z(ntryL,G1H8(74),ex1(:),G1H4(275),ngZd,m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_AQ_W(ntryL,G1H8(75),ex1(:),G1H4(276),m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_AQ_S(ntryL,G1H8(76),ex2(:),G1H4(277),ngH,m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_AQ_S(ntryL,G1H8(77),ex2(:),G1H4(278),ngH,m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_AQ_S(ntryL,G1H8(78),ex2(:),G1H4(279),ngX,m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_AQ_S(ntryL,G1H8(79),ex2(:),G1H4(280),ngX,m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_AQ_S(ntryL,G1H8(82),ex2(:),G1H4(281),ngH,m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_AQ_S(ntryL,G1H8(83),ex2(:),G1H4(282),ngX,m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_AQ_S(ntryL,G1H8(84),ex2(:),G1H4(283),ngH,m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_AQ_S(ntryL,G1H8(85),ex2(:),G1H4(284),ngX,m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_AQ_V(ntryL,G1H8(86),ex2(:),G1H4(285),m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_AQ_V(ntryL,G1H8(89),ex2(:),G1H4(286),m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_AQ_Z(ntryL,G1H8(90),ex2(:),G1H4(287),ngZd,m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_AQ_Z(ntryL,G1H8(91),ex2(:),G1H4(288),ngZd,m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_AQ_V(ntryL,G1H8(92),ex2(:),G1H4(289),m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_AQ_V(ntryL,G1H8(93),ex2(:),G1H4(290),m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_AQ_Z(ntryL,G1H8(94),ex2(:),G1H4(291),ngZd,m3h2x4(:,391),heltab2x8(:,:,391))
  call Hloop_AQ_Z(ntryL,G1H8(95),ex2(:),G1H4(292),ngZd,m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_AQ_S(ntryL,G1H8(96),ex1(:),G1H4(293),ngH,m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_AQ_S(ntryL,G1H8(97),ex1(:),G1H4(294),ngH,m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_AQ_S(ntryL,G1H8(98),ex1(:),G1H4(295),ngX,m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_AQ_S(ntryL,G1H8(99),ex1(:),G1H4(296),ngX,m3h2x4(:,396),heltab2x8(:,:,396))
  call Hloop_AQ_S(ntryL,G1H8(100),ex1(:),G1H4(297),ngH,m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_AQ_S(ntryL,G1H8(101),ex1(:),G1H4(298),ngX,m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_AQ_S(ntryL,G1H8(102),ex1(:),G1H4(299),ngH,m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_AQ_S(ntryL,G1H8(103),ex1(:),G1H4(300),ngX,m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_AQ_V(ntryL,G1H8(106),ex1(:),G1H4(301),m3h2x4(:,401),heltab2x8(:,:,401))
  call Hloop_AQ_V(ntryL,G1H8(107),ex1(:),G1H4(302),m3h2x4(:,402),heltab2x8(:,:,402))
  call Hloop_AQ_Z(ntryL,G1H8(108),ex1(:),G1H4(303),ngZd,m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_AQ_Z(ntryL,G1H8(109),ex1(:),G1H4(304),ngZd,m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_AQ_V(ntryL,G1H8(110),ex1(:),G1H4(305),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_AQ_V(ntryL,G1H8(113),ex1(:),G1H4(306),m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_AQ_Z(ntryL,G1H8(114),ex1(:),G1H4(307),ngZd,m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_AQ_Z(ntryL,G1H8(115),ex1(:),G1H4(308),ngZd,m3h2x4(:,408),heltab2x8(:,:,408))
  call Hloop_SQ_A(ntryL,G0H8(125),ex1(:),G0H4(13),ngH,m3h2x4(:,409),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(309),n2h4(333))
  call Hloop_SQ_A(ntryL,G0H8(126),ex1(:),G0H4(13),ngH,m3h2x4(:,410),heltab2x8(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(310),n2h4(334))
  call Hloop_SQ_A(ntryL,G0H8(127),ex1(:),G0H4(13),ngX,m3h2x4(:,411),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(311),n2h4(335))
  call Hloop_SQ_A(ntryL,G0H8(128),ex1(:),G0H4(13),ngX,m3h2x4(:,412),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(312),n2h4(336))
  call Hloop_SQ_A(ntryL,G0H8(129),ex1(:),G0H4(13),ngPtb,m3h2x4(:,413),heltab2x8(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMT,G1H4(313),n2h4(337))
  call Hloop_AQ_S(ntryL,G1H8(116),ex1(:),G1H4(314),ngH,m3h2x4(:,414),heltab2x8(:,:,414))
  call Hloop_AQ_S(ntryL,G1H8(117),ex1(:),G1H4(315),ngH,m3h2x4(:,415),heltab2x8(:,:,415))
  call Hloop_AQ_S(ntryL,G1H8(118),ex1(:),G1H4(316),ngX,m3h2x4(:,416),heltab2x8(:,:,416))
  call Hloop_AQ_S(ntryL,G1H8(119),ex1(:),G1H4(317),ngX,m3h2x4(:,417),heltab2x8(:,:,417))
  call Hloop_AQ_S(ntryL,G1H8(120),ex1(:),G1H4(318),ngPtb,m3h2x4(:,418),heltab2x8(:,:,418))
  call Hloop_SQ_A(ntryL,G0H8(130),ex1(:),G0H4(13),ngH,m3h2x4(:,419),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(319),n2h4(338))
  call Hloop_SQ_A(ntryL,G0H8(131),ex1(:),G0H4(13),ngX,m3h2x4(:,420),heltab2x8(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(320),n2h4(339))
  call Hloop_SQ_A(ntryL,G0H8(132),ex1(:),G0H4(13),ngH,m3h2x4(:,421),heltab2x8(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(321),n2h4(340))
  call Hloop_SQ_A(ntryL,G0H8(133),ex1(:),G0H4(13),ngX,m3h2x4(:,422),heltab2x8(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(322),n2h4(341))
  call Hloop_SQ_A(ntryL,G0H8(134),ex1(:),G0H4(13),ngPtb,m3h2x4(:,423),heltab2x8(:,:,423))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMT,G1H4(323),n2h4(342))
  call Hloop_VQ_A(ntryL,G0H8(135),ex1(:),G0H4(13),m3h2x4(:,424),heltab2x8(:,:,424))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(324),n2h4(343))
  call Hloop_VQ_A(ntryL,G0H8(136),ex1(:),G0H4(13),m3h2x4(:,425),heltab2x8(:,:,425))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(325),n2h4(344))
  call Hloop_ZQ_A(ntryL,G0H8(137),ex1(:),G0H4(13),ngZd,m3h2x4(:,426),heltab2x8(:,:,426))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(326),n2h4(345))
  call Hloop_ZQ_A(ntryL,G0H8(138),ex1(:),G0H4(13),ngZd,m3h2x4(:,427),heltab2x8(:,:,427))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(327),n2h4(346))
  call Hloop_WQ_A(ntryL,G0H8(139),ex1(:),G0H4(13),m3h2x4(:,428),heltab2x8(:,:,428))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMT,G1H4(328),n2h4(347))
  call Hloop_AQ_S(ntryL,G1H8(121),ex1(:),G1H4(329),ngH,m3h2x4(:,429),heltab2x8(:,:,429))
  call Hloop_AQ_S(ntryL,G1H8(122),ex1(:),G1H4(330),ngX,m3h2x4(:,430),heltab2x8(:,:,430))
  call Hloop_AQ_S(ntryL,G1H8(123),ex1(:),G1H4(331),ngH,m3h2x4(:,431),heltab2x8(:,:,431))
  call Hloop_AQ_S(ntryL,G1H8(124),ex1(:),G1H4(332),ngX,m3h2x4(:,432),heltab2x8(:,:,432))
  call Hloop_AQ_S(ntryL,G1H8(125),ex1(:),G1H4(333),ngPtb,m3h2x4(:,433),heltab2x8(:,:,433))
  call Hloop_AQ_V(ntryL,G1H8(126),ex1(:),G1H4(334),m3h2x4(:,434),heltab2x8(:,:,434))
  call Hloop_AQ_V(ntryL,G1H8(127),ex1(:),G1H4(335),m3h2x4(:,435),heltab2x8(:,:,435))
  call Hloop_AQ_Z(ntryL,G1H8(130),ex1(:),G1H4(336),ngZd,m3h2x4(:,436),heltab2x8(:,:,436))
  call Hloop_AQ_Z(ntryL,G1H8(131),ex1(:),G1H4(337),ngZd,m3h2x4(:,437),heltab2x8(:,:,437))
  call Hloop_AQ_W(ntryL,G1H8(132),ex1(:),G1H4(338),m3h2x4(:,438),heltab2x8(:,:,438))
  call Hloop_VQ_A(ntryL,G0H8(140),ex1(:),G0H4(13),m3h2x4(:,439),heltab2x8(:,:,439))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(339),n2h4(348))
  call Hloop_VQ_A(ntryL,G0H8(141),ex1(:),G0H4(13),m3h2x4(:,440),heltab2x8(:,:,440))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(340),n2h4(349))
  call Hloop_ZQ_A(ntryL,G0H8(142),ex1(:),G0H4(13),ngZd,m3h2x4(:,441),heltab2x8(:,:,441))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(341),n2h4(350))
  call Hloop_ZQ_A(ntryL,G0H8(143),ex1(:),G0H4(13),ngZd,m3h2x4(:,442),heltab2x8(:,:,442))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMB,G1H4(342),n2h4(351))
  call Hloop_WQ_A(ntryL,G0H8(144),ex1(:),G0H4(13),m3h2x4(:,443),heltab2x8(:,:,443))
  call Hloop_Q_A(ntryL,G0H4(13),25,nMT,G1H4(343),n2h4(352))
  call Hloop_AQ_V(ntryL,G1H8(133),ex1(:),G1H4(344),m3h2x4(:,444),heltab2x8(:,:,444))
  call Hloop_AQ_V(ntryL,G1H8(134),ex1(:),G1H4(345),m3h2x4(:,445),heltab2x8(:,:,445))
  call Hloop_AQ_Z(ntryL,G1H8(137),ex1(:),G1H4(346),ngZd,m3h2x4(:,446),heltab2x8(:,:,446))
  call Hloop_AQ_Z(ntryL,G1H8(138),ex1(:),G1H4(347),ngZd,m3h2x4(:,447),heltab2x8(:,:,447))
  call Hloop_AQ_W(ntryL,G1H8(139),ex1(:),G1H4(348),m3h2x4(:,448),heltab2x8(:,:,448))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(27),G1H4(79),G1H4(78),G1H4(67),G1H4(4),G0H4(10) &
    ,G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(7),G1H4(17),G1H4(14),G1H4(8),G1H4(7),G1H4(10) &
    ,G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(5),G1H4(19),G1H4(18),G1H4(13),G1H4(12),G1H4(16) &
    ,G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(29),G1H4(84),G1H4(83),G1H4(80),G1H4(22) &
    ,G0H4(12),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(90),G1H4(23),G1H4(20),G1H4(11),G1H4(52),G0H4(4) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(54),G1H4(54),G1H4(53),G1H4(48),G1H4(47) &
    ,G1H4(58),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(51),G1H4(56),G1H4(55),G1H4(50),G1H4(49) &
    ,G1H4(64),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(117),G1H4(26),G1H4(25),G1H4(24),G1H4(70) &
    ,G0H4(6),G0H4(5)])



end subroutine vamp_3

end module ol_vamp_3_ppajj_ew_bbbxbxa_4_/**/REALKIND
