
module ol_vamp_1_ppajj_ew_ddxaag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_ddxaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_ddxaag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_ddxaag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_ddxaag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_ddxaag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_ddxaag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(1,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,8,1,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,1,8,2,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(26),n2h16(26))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(3))
  call Hloop_QA_V(ntryL,G1H16(4),ex2(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_Z(ntryL,G1H16(5),ex2(:),G1H8(2),ngZd,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_W(ntryL,G1H16(6),ex2(:),G1H8(3),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QV_A(ntryL,G1H16(7),ex3(:),G1H8(4),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(4),n2h8(4))
  call Hloop_QV_A(ntryL,G1H16(8),ex3(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(5),n2h8(5))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(4),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(6),n2h8(6))
  call Hloop_QA_V(ntryL,G1H16(10),ex2(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_QA_Z(ntryL,G1H16(11),ex2(:),G1H8(5),ngZd,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QA_W(ntryL,G1H16(12),ex2(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(8),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_W(ntryL,G1H16(15),ex1(:),G1H8(9),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(16),ex1(:),G1H8(10),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H16(17),ex1(:),G1H8(11),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(12),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_W(ntryL,G1H16(19),ex2(:),G1H8(13),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_W(ntryL,G1H16(20),ex2(:),G1H8(14),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_W(ntryL,G1H16(21),ex1(:),G1H8(15),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(16),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(17),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(24),ex1(:),G1H8(18),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_W(ntryL,G1H16(25),ex1(:),G1H8(19),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_W(ntryL,G1H16(26),ex1(:),G1H8(20),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZd,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(4),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngZd,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(5),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(6),n2h4(3))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(8),ngZd,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(10),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(11),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(12),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(13),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZd,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(14),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(15),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(16),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),ngZd,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(17),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(18),n2h4(12))
  call Hloop_UW_V(ntryL,G1H8(13),18,ex3(:),4,G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_UW_V(ntryL,G1H8(14),18,ex4(:),8,G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_UV_W(ntryL,G1H8(15),17,ex3(:),4,G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_VV_S(ntryL,G1H8(16),ex3(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_UV_W(ntryL,G1H8(17),17,ex3(:),4,G2H4(22),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_UV_W(ntryL,G1H8(18),17,ex4(:),8,G2H4(23),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VV_S(ntryL,G1H8(19),ex4(:),G1H4(2),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_UV_W(ntryL,G1H8(20),17,ex4(:),8,G2H4(24),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,5),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(3),mass5set(:,2),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,3),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),4,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(4),mass5set(:,4),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(4),mass5set(:,5),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),4,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(5),mass5set(:,4),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(5),mass5set(:,5),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),4,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(6),mass5set(:,4),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),4,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(6),mass5set(:,5),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),4,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(7),mass5set(:,6),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(8),mass5set(:,6),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(9),mass5set(:,6),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(124),8,4)
  call Hloop_SV_V(ntryL,G1H4(1),ex4(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(10),mass5set(:,7),  & 
G1H4(1),G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),4)
  call HG1shiftOLR(G1H4(129),2,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(11),mass5set(:,6),  & 
G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),4)
  call HG1shiftOLR(G1H4(135),4,4)
  call Hloop_SV_V(ntryL,G1H4(2),ex3(:),G1H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(12),mass5set(:,7),  & 
G1H4(2),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),2,4)
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-8,0,G2H4(1),n2h4(13))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(3),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(3),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(8),ex2(:),G1H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(4),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex2(:),G1H2(3),ngZd,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(5),n2h2(4))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-8,0,G2H4(2),n2h4(14))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(6),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex2(:),G1H2(3),ngZd,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(7),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(14),ex2(:),G1H2(3),ngZd,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(8),n2h2(6))
  call Hloop_WA_Q(ntryL,G1H4(15),ex2(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(9),n2h2(7))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,0,G2H4(3),n2h4(15))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(10),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_WA_Q(ntryL,G1H4(19),ex2(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(11),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(20),ex2(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(12),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(21),ex3(:),G1H2(3),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(13),n2h2(10))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-8,0,G2H4(4),n2h4(16))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(14),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(3),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(15),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(3),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(16),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(3),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(17),n2h2(13))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-8,0,G2H4(5),n2h4(17))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(18),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QV_A(ntryL,G1H4(31),ex3(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(19),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(32),ex3(:),G1H2(3),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(20),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(3),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(21),n2h2(16))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-8,0,G2H4(6),n2h4(18))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(22),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QV_A(ntryL,G1H4(37),ex3(:),G1H2(3),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(23),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(38),ex3(:),G1H2(3),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(24),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(3),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(25),n2h2(19))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-8,0,G2H4(7),n2h4(19))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(26),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(3),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(27),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(44),ex1(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(28),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex1(:),G1H2(3),ngZd,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(29),n2h2(22))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(46),-8,0,G2H4(8),n2h4(20))
  call Hloop_AV_Q(ntryL,G2H4(8),ex4(:),G2H2(30),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex1(:),G1H2(3),ngZd,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(31),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex1(:),G1H2(3),ngZd,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(32),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(51),ex1(:),G1H2(3),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(33),n2h2(25))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-8,0,G2H4(9),n2h4(21))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(34),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_WQ_A(ntryL,G1H4(55),ex1(:),G1H2(3),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(35),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(56),ex1(:),G1H2(3),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(36),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(57),ex4(:),G1H2(3),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(37),n2h2(28))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-4,0,G2H4(10),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(10),ex3(:),G2H2(38),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QV_A(ntryL,G1H4(61),ex4(:),G1H2(3),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(39),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(62),ex4(:),G1H2(3),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(40),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(63),ex4(:),G1H2(3),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(41),n2h2(31))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-4,0,G2H4(11),n2h4(23))
  call Hloop_AV_Q(ntryL,G2H4(11),ex3(:),G2H2(42),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(67),ex4(:),G1H2(3),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(43),n2h2(32))
  call Hloop_QV_A(ntryL,G1H4(68),ex4(:),G1H2(3),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(44),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(69),ex4(:),G1H2(3),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(45),n2h2(34))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-4,0,G2H4(12),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(12),ex3(:),G2H2(46),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_QV_A(ntryL,G1H4(73),ex4(:),G1H2(3),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(47),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(74),ex4(:),G1H2(3),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(48),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(3),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(49),n2h2(37))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(76),-8,0,G2H4(13),n2h4(25))
  call Hloop_QV_A(ntryL,G2H4(13),ex4(:),G2H2(50),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AV_Q(ntryL,G1H4(79),ex3(:),G1H2(3),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(51),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H4(80),ex3(:),G1H2(3),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(52),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H4(81),ex3(:),G1H2(3),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(53),n2h2(40))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-8,0,G2H4(14),n2h4(26))
  call Hloop_QV_A(ntryL,G2H4(14),ex4(:),G2H2(54),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AV_Q(ntryL,G1H4(85),ex3(:),G1H2(3),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(55),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H4(86),ex3(:),G1H2(3),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(56),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(87),ex3(:),G1H2(3),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(57),n2h2(43))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-8,0,G2H4(15),n2h4(27))
  call Hloop_QV_A(ntryL,G2H4(15),ex4(:),G2H2(58),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AV_Q(ntryL,G1H4(91),ex3(:),G1H2(3),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(59),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(92),ex3(:),G1H2(3),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(60),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(3),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(61),n2h2(46))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-4,0,G2H4(16),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(16),ex3(:),G2H2(62),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AV_Q(ntryL,G1H4(97),ex4(:),G1H2(3),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(63),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(98),ex4(:),G1H2(3),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(64),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H4(99),ex4(:),G1H2(3),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(65),n2h2(49))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(100),-4,0,G2H4(17),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(17),ex3(:),G2H2(66),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AV_Q(ntryL,G1H4(103),ex4(:),G1H2(3),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(67),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(104),ex4(:),G1H2(3),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(68),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H4(105),ex4(:),G1H2(3),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(69),n2h2(52))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(106),-4,0,G2H4(18),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(18),ex3(:),G2H2(70),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AV_Q(ntryL,G1H4(109),ex4(:),G1H2(3),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(71),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(110),ex4(:),G1H2(3),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(72),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H4(111),ex1(:),G1H2(3),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(73),n2h2(55))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(112),-8,0,G2H4(19),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(74),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_WQ_A(ntryL,G1H4(115),ex1(:),G1H2(3),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(75),n2h2(56))
  call Hloop_WQ_A(ntryL,G1H4(116),ex1(:),G1H2(3),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(76),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(117),ex1(:),G1H2(3),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(77),n2h2(58))
call HGT_OLR(G1H4(118),1,1,4)
call HGT_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(118),-4,0,G2H4(20),n2h4(32))
  call Hloop_AV_Q(ntryL,G2H4(20),ex3(:),G2H2(78),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_WQ_A(ntryL,G1H4(121),ex1(:),G1H2(3),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(79),n2h2(59))
  call Hloop_WQ_A(ntryL,G1H4(122),ex1(:),G1H2(3),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(80),n2h2(60))
  call Hloop_WA_Q(ntryL,G1H4(123),ex2(:),G1H2(3),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(81),n2h2(61))
call HGT_OLR(G1H4(124),1,1,4)
call HGT_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(124),-8,0,G2H4(21),n2h4(33))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(82),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_WA_Q(ntryL,G1H4(127),ex2(:),G1H2(3),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(83),n2h2(62))
  call Hloop_WA_Q(ntryL,G1H4(128),ex2(:),G1H2(3),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(84),n2h2(63))
  call Hloop_UV_W(ntryL,G1H4(1),21,ex4(:),8,G2H2(85),m3h2x2(:,87),heltab2x4(:,:,87))
call HGT_OLR(G1H4(129),1,1,4)
call HGT_invQ_OLR(G1H4(129),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(129),-2,0,G2H4(22),n2h4(34))
  call Hloop_QA_W(ntryL,G2H4(22),ex2(:),G2H2(86),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_UV_W(ntryL,G1H4(132),21,ex4(:),8,G2H2(87),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UV_W(ntryL,G1H4(133),21,ex4(:),8,G2H2(88),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_WA_Q(ntryL,G1H4(134),ex2(:),G1H2(3),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(89),n2h2(64))
call HGT_OLR(G1H4(135),1,1,4)
call HGT_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(135),-4,0,G2H4(23),n2h4(35))
  call Hloop_QV_A(ntryL,G2H4(23),ex3(:),G2H2(90),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_WA_Q(ntryL,G1H4(138),ex2(:),G1H2(3),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(91),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(139),ex2(:),G1H2(3),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(92),n2h2(66))
  call Hloop_UV_W(ntryL,G1H4(2),25,ex3(:),4,G2H2(93),m3h2x2(:,95),heltab2x4(:,:,95))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-2,0,G2H4(24),n2h4(36))
  call Hloop_QA_W(ntryL,G2H4(24),ex2(:),G2H2(94),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_UV_W(ntryL,G1H4(143),25,ex3(:),4,G2H2(95),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_UV_W(ntryL,G1H4(144),25,ex3(:),4,G2H2(96),m3h2x2(:,98),heltab2x4(:,:,98))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(2)])
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(10),mass5set(:,7),  & 
G1H2(3),G1H2(1),G1H2(2),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(12),mass5set(:,7),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(1),mass4set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(20),10,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,2),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(1),mass4set(:,2),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(31),10,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,3),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(1),mass4set(:,3),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),10,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(2),mass5set(:,1),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(47),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(2),mass4set(:,1),  & 
G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(53),12,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(2),mass5set(:,4),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(2),mass4set(:,4),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(64),12,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(2),mass5set(:,5),  & 
G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(69),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(2),mass4set(:,5),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(75),12,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(3),mass5set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(3),mass4set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(86),9,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(3),mass5set(:,2),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(3),mass4set(:,2),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(97),9,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(3),mass5set(:,3),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(3),mass4set(:,3),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),9,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(4),mass5set(:,1),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(113),4,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,1),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(119),12,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(4),mass5set(:,4),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(2),mass4set(:,4),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),12,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(4),mass5set(:,5),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),4,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(2),mass4set(:,5),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(141),12,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(5),mass5set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(4),mass4set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(152),12,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(5),mass5set(:,4),  & 
G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(157),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(4),mass4set(:,4),  & 
G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(163),12,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(5),mass5set(:,5),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(4),mass4set(:,5),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),2)
  call HG1shiftOLR(G1H2(174),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(6),mass5set(:,1),  & 
G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(179),4,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(4),mass4set(:,1),  & 
G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(185),12,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(6),mass5set(:,4),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(190),4,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(4),mass4set(:,4),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(196),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(6),mass5set(:,5),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),2)
  call HG1shiftOLR(G1H2(201),4,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(4),mass4set(:,5),  & 
G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(207),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(7),mass5set(:,6),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(5),mass4set(:,6),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),2)
  call HG1shiftOLR(G1H2(218),9,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(8),mass5set(:,6),  & 
G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),2)
  call HG1shiftOLR(G1H2(223),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(6),mass4set(:,6),  & 
G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(229),5,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(9),mass5set(:,6),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),8,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(7),mass4set(:,6),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),2)
  call HG1shiftOLR(G1H2(240),10,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(7),mass4set(:,6),  & 
G1H2(244),G1H2(245),G1H2(246),G1H2(247),G1H2(248),2)
  call HG1shiftOLR(G1H2(245),10,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(11),mass5set(:,6),  & 
G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(250),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(8),mass4set(:,6),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(256),6,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(8),mass4set(:,6),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(261),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(244),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(260),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(195),[G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(206),[G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(217),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(239),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(254)])
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(2),n2h1(2))
  call Hloop_WA_Q(ntryL,G1H2(244),ex2(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(5),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(260),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(18),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(22),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(38),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(40),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(42),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(113),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(44),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(119),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(46),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(123),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(48),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(50),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(135),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(52),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(54),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(58),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(62),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(174),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(66),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(68),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(70),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(72),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(195),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(196),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(74),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(201),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(207),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(80),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(82),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(222),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(223),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(84),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(228),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(86),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(88),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(90),n2h1(90))
  call Hloop_WA_Q(ntryL,G1H2(245),ex2(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(91),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(249),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(250),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(93),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(255),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(256),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(95),n2h1(95))
  call Hloop_WA_Q(ntryL,G1H2(261),ex2(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(96),n2h1(96))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(10),mass5set(:,7),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(12),mass5set(:,7),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(2),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(2),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(3),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(4),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(4),mass5set(:,4),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(4),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(5),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(5),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(5),mass5set(:,5),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(6),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(6),mass5set(:,4),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(6),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(7),mass5set(:,6),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(8),mass5set(:,6),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(9),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(11),mass5set(:,6),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,12,2],[0,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,8,5],[0,nMW,nMW,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(2),n2h16(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,5,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(30))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,5,2,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(5),n2h16(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,5,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(32))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(33))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,5,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(34))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,8,6],[0,nMW,nMW,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,6,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(10),n2h16(36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(11),n2h16(37))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,6,1,8],[0,nMW,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(12),n2h16(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,1,6,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(39))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(40))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,6,8],[0,nMW,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(41))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,4,9],[0,nMW,nMW,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,2,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(17),n2h16(43))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(18),n2h16(44))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,2,9],[0,0,nMW,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,2,9,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(20),n2h16(46))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(47))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,2,9,4],[0,nMW,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(22),n2h16(48))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,1,4,10],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,4,1,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(24),n2h16(50))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(51))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,1,10],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(26),n2h16(52))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,1,10,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(27),n2h16(53))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(28),n2h16(54))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,10,4],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(55))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[17,4,2,8],[0,0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(1),n2h8(7))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[17,4,2,8],[nMW,nMW,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[17,2,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,3),heltab2x32(:,:,58))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngZd,m3h4x8(:,4),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[17,2,4,8],[nMW,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,5),heltab2x32(:,:,60))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,6),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H8(5),17,0,G1H8(2),n2h8(8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,7),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(5),17,0,G1H8(3),n2h8(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[17,2,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,8),heltab2x32(:,:,63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(6),ngZd,m3h4x8(:,9),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[17,2,8,4],[nMW,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,10),heltab2x32(:,:,65))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,11),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(8),17,0,G1H8(4),n2h8(10))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,12),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(8),17,0,G1H8(5),n2h8(11))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[18,4,1,8],[0,0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,13),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(8),18,0,G1H8(6),n2h8(12))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[18,4,1,8],[nMW,nMW,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,14),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[18,1,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,15),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(10),ngZd,m3h4x8(:,16),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[18,1,4,8],[nMW,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,17),heltab2x32(:,:,72))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,18),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(12),18,0,G1H8(7),n2h8(13))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,19),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(12),18,0,G1H8(8),n2h8(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[18,1,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,20),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngZd,m3h4x8(:,21),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[18,1,8,4],[nMW,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,22),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,23),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(9),n2h8(15))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,24),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(10),n2h8(16))
  call Hloop_AQ_W(ntryL,G1H16(1),ex1(:),G1H8(11),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_W(ntryL,G1H16(2),ex2(:),G1H8(12),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(3),wf4(:,3),G1H4(3),m3h4x4(:,1),heltab2x16(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H16(4),wf4(:,3),G1H4(4),ngZd,m3h4x4(:,2),heltab2x16(:,:,30))
  call Hloop_AQ_W(ntryL,G1H16(5),wf4(:,3),G1H4(7),m3h4x4(:,3),heltab2x16(:,:,31))
  call Hloop_QA_V(ntryL,G1H16(6),ex2(:),G1H8(13),m3h2x8(:,29),heltab2x16(:,:,32))
  call Hloop_QA_Z(ntryL,G1H16(7),ex2(:),G1H8(14),ngZd,m3h2x8(:,30),heltab2x16(:,:,33))
  call Hloop_QA_W(ntryL,G1H16(8),ex2(:),G1H8(15),m3h2x8(:,31),heltab2x16(:,:,34))
  call Hloop_AQ_W(ntryL,G1H16(9),ex1(:),G1H8(16),m3h2x8(:,32),heltab2x16(:,:,35))
  call Hloop_QA_V(ntryL,G1H16(10),wf4(:,10),G1H4(8),m3h4x4(:,4),heltab2x16(:,:,36))
  call Hloop_QA_Z(ntryL,G1H16(11),wf4(:,10),G1H4(9),ngZd,m3h4x4(:,5),heltab2x16(:,:,37))
  call Hloop_QA_W(ntryL,G1H16(12),wf4(:,10),G1H4(10),m3h4x4(:,6),heltab2x16(:,:,38))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(17),m3h2x8(:,33),heltab2x16(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(18),ngZd,m3h2x8(:,34),heltab2x16(:,:,40))
  call Hloop_AQ_W(ntryL,G1H16(15),ex1(:),G1H8(19),m3h2x8(:,35),heltab2x16(:,:,41))
  call Hloop_QA_W(ntryL,G1H16(16),ex2(:),G1H8(20),m3h2x8(:,36),heltab2x16(:,:,42))
  call Hloop_QV_A(ntryL,G1H16(17),ex3(:),G1H8(21),m3h2x8(:,37),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(1),n2h8(17))
  call Hloop_QV_A(ntryL,G1H16(18),ex3(:),G1H8(21),m3h2x8(:,38),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(2),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(19),ex3(:),G1H8(21),m3h2x8(:,39),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(3),n2h8(19))
  call Hloop_QA_V(ntryL,G1H16(20),ex2(:),G1H8(21),m3h2x8(:,40),heltab2x16(:,:,46))
  call Hloop_QA_Z(ntryL,G1H16(21),ex2(:),G1H8(22),ngZd,m3h2x8(:,41),heltab2x16(:,:,47))
  call Hloop_QA_W(ntryL,G1H16(22),ex2(:),G1H8(23),m3h2x8(:,42),heltab2x16(:,:,48))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(24),m3h2x8(:,43),heltab2x16(:,:,49))
  call Hloop_AV_Q(ntryL,G1H16(24),ex3(:),G1H8(25),m3h2x8(:,44),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(4),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(25),ex3(:),G1H8(25),m3h2x8(:,45),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(5),n2h8(21))
  call Hloop_AV_Q(ntryL,G1H16(26),ex3(:),G1H8(25),m3h2x8(:,46),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(6),n2h8(22))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(25),m3h2x8(:,47),heltab2x16(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex1(:),G1H8(26),ngZd,m3h2x8(:,48),heltab2x16(:,:,54))
  call Hloop_AQ_W(ntryL,G1H16(29),ex1(:),G1H8(27),m3h2x8(:,49),heltab2x16(:,:,55))
  call Hloop_QV_A(ntryL,G1H8(1),ex3(:),G1H4(13),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(13),21,0,G2H4(1),n2h4(37))
  call Hloop_UV_W(ntryL,G0H8(1),17,ex3(:),4,G1H4(14),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(15),n2h4(38))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngZd,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(16),n2h4(39))
  call Hloop_WA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(19),n2h4(40))
  call Hloop_QA_W(ntryL,G1H8(2),ex2(:),G1H4(20),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_W(ntryL,G1H8(3),ex2(:),G1H4(21),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(22),n2h4(41))
  call Hloop_ZA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),ngZd,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(25),n2h4(42))
  call Hloop_WA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(26),n2h4(43))
  call Hloop_QA_W(ntryL,G1H8(4),ex2(:),G1H4(27),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_W(ntryL,G1H8(5),ex2(:),G1H4(28),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AV_Q(ntryL,G1H8(6),ex3(:),G1H4(31),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(31),22,0,G2H4(2),n2h4(44))
  call Hloop_UW_V(ntryL,G0H8(8),18,ex3(:),4,G1H4(32),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(33),n2h4(45))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngZd,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(34),n2h4(46))
  call Hloop_WQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(37),n2h4(47))
  call Hloop_AQ_W(ntryL,G1H8(7),ex1(:),G1H4(38),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_AQ_W(ntryL,G1H8(8),ex1(:),G1H4(39),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(40),n2h4(48))
  call Hloop_ZQ_A(ntryL,G0H8(13),ex1(:),G0H4(1),ngZd,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(43),n2h4(49))
  call Hloop_WQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(44),n2h4(50))
  call Hloop_AQ_W(ntryL,G1H8(9),ex1(:),G1H4(45),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AQ_W(ntryL,G1H8(10),ex1(:),G1H4(46),m3h2x4(:,50),heltab2x8(:,:,50))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(126),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(30),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(114),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(66),G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(84),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102),G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(125)])
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(6),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(85),n2h2(67))
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(12),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(12),23,0,G2H2(93),n2h2(68))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex2(:),G1H2(18),ngZd,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(18),23,0,G2H2(1),n2h2(69))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex2(:),G1H2(29),ngZd,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(29),23,0,G2H2(4),n2h2(70))
  call Hloop_WA_Q(ntryL,G1H4(17),ex2(:),G1H2(40),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(40),23,0,G2H2(5),n2h2(71))
  call Hloop_WA_Q(ntryL,G1H4(7),ex2(:),G1H2(51),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(51),23,0,G2H2(8),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(62),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(62),23,0,G2H2(9),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(36),ex3(:),G1H2(73),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(73),23,0,G2H2(12),n2h2(74))
  call Hloop_QV_A(ntryL,G1H4(34),ex3(:),G1H2(84),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(84),23,0,G2H2(13),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(37),ex3(:),G1H2(95),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(95),23,0,G2H2(16),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(106),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(106),23,0,G2H2(17),n2h2(77))
  call Hloop_VQ_A(ntryL,G1H4(8),ex1(:),G1H2(117),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(117),23,0,G2H2(20),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex1(:),G1H2(128),ngZd,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(128),23,0,G2H2(21),n2h2(79))
  call Hloop_ZQ_A(ntryL,G1H4(9),ex1(:),G1H2(139),ngZd,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(139),23,0,G2H2(24),n2h2(80))
  call Hloop_WQ_A(ntryL,G1H4(53),ex1(:),G1H2(150),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(150),23,0,G2H2(25),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H4(10),ex1(:),G1H2(161),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(161),23,0,G2H2(28),n2h2(82))
  call Hloop_QV_A(ntryL,G1H4(40),ex4(:),G1H2(172),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(172),27,0,G2H2(29),n2h2(83))
  call Hloop_QV_A(ntryL,G1H4(72),ex4(:),G1H2(183),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(183),27,0,G2H2(32),n2h2(84))
  call Hloop_QV_A(ntryL,G1H4(43),ex4(:),G1H2(194),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(194),27,0,G2H2(33),n2h2(85))
  call Hloop_QV_A(ntryL,G1H4(44),ex4(:),G1H2(205),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(205),27,0,G2H2(36),n2h2(86))
  call Hloop_AV_Q(ntryL,G1H4(15),ex3(:),G1H2(216),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(216),23,0,G2H2(37),n2h2(87))
  call Hloop_AV_Q(ntryL,G1H4(90),ex3(:),G1H2(227),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(227),23,0,G2H2(40),n2h2(88))
  call Hloop_AV_Q(ntryL,G1H4(16),ex3(:),G1H2(238),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(238),23,0,G2H2(41),n2h2(89))
  call Hloop_AV_Q(ntryL,G1H4(19),ex3(:),G1H2(254),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(254),23,0,G2H2(44),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H4(22),ex4(:),G1H2(3),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(45),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(108),ex4(:),G1H2(1),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(48),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H4(25),ex4(:),G1H2(244),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(244),27,0,G2H2(49),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(26),ex4(:),G1H2(7),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(7),27,0,G2H2(52),n2h2(94))
  call Hloop_WQ_A(ntryL,G1H4(32),ex1(:),G1H2(8),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(53),n2h2(95))
  call Hloop_WQ_A(ntryL,G1H4(119),ex1(:),G1H2(260),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(260),27,0,G2H2(56),n2h2(96))
  call Hloop_WQ_A(ntryL,G1H4(120),ex1(:),G1H2(13),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(13),27,0,G2H2(57),n2h2(97))
  call Hloop_WA_Q(ntryL,G1H4(14),ex2(:),G1H2(14),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(14),23,0,G2H2(60),n2h2(98))
  call Hloop_UV_W(ntryL,G1H4(130),21,ex4(:),8,G2H2(61),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_UV_W(ntryL,G1H4(131),21,ex4(:),8,G2H2(64),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_WA_Q(ntryL,G1H4(136),ex2(:),G1H2(19),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(19),27,0,G2H2(65),n2h2(99))
  call Hloop_WA_Q(ntryL,G1H4(137),ex2(:),G1H2(20),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(20),27,0,G2H2(68),n2h2(100))
  call Hloop_UV_W(ntryL,G1H4(141),25,ex3(:),4,G2H2(69),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_UV_W(ntryL,G1H4(142),25,ex3(:),4,G2H2(72),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_VWW_V(ntryL,G1H8(11),ex4(:),ex3(:),G1H2(24),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hloop_UW_V(ntryL,G1H8(12),18,ex4(:),8,G2H4(3),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_VQ_A(ntryL,G1H8(13),wf4(:,3),G1H2(25),m3h4x2(:,1),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(25),23,0,G2H2(73),n2h2(101))
  call Hloop_ZQ_A(ntryL,G1H8(14),wf4(:,3),G1H2(30),ngZd,m3h4x2(:,2),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(30),23,0,G2H2(76),n2h2(102))
  call Hloop_WQ_A(ntryL,G1H8(15),wf4(:,3),G1H2(31),m3h4x2(:,3),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(31),23,0,G2H2(77),n2h2(103))
  call Hloop_UV_W(ntryL,G1H8(16),17,ex4(:),8,G2H4(4),m3h2x4(:,52),heltab2x8(:,:,55))
  call Hloop_VA_Q(ntryL,G1H8(17),wf4(:,10),G1H2(35),m3h4x2(:,4),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(35),23,0,G2H2(80),n2h2(104))
  call Hloop_ZA_Q(ntryL,G1H8(18),wf4(:,10),G1H2(36),ngZd,m3h4x2(:,5),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(36),23,0,G2H2(81),n2h2(105))
  call Hloop_WA_Q(ntryL,G1H8(19),wf4(:,10),G1H2(41),m3h4x2(:,6),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(41),23,0,G2H2(84),n2h2(106))
  call Hloop_UW_V(ntryL,G1H8(20),18,ex3(:),4,G2H4(5),m3h2x4(:,53),heltab2x8(:,:,59))
  call Hloop_QA_V(ntryL,G2H8(1),ex2(:),G2H4(6),m3h2x4(:,54),heltab2x8(:,:,60))
  call Hloop_QA_Z(ntryL,G2H8(2),ex2(:),G2H4(7),ngZd,m3h2x4(:,55),heltab2x8(:,:,61))
  call Hloop_QA_W(ntryL,G2H8(3),ex2(:),G2H4(8),m3h2x4(:,56),heltab2x8(:,:,62))
  call Hloop_VQ_A(ntryL,G1H8(21),wf4(:,9),G1H2(42),m3h4x2(:,7),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(42),27,0,G2H2(88),n2h2(107))
  call Hloop_ZQ_A(ntryL,G1H8(22),wf4(:,9),G1H2(46),ngZd,m3h4x2(:,8),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(46),27,0,G2H2(89),n2h2(108))
  call Hloop_WQ_A(ntryL,G1H8(23),wf4(:,9),G1H2(47),m3h4x2(:,9),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(47),27,0,G2H2(92),n2h2(109))
  call Hloop_UV_W(ntryL,G1H8(24),17,ex3(:),4,G2H4(9),m3h2x4(:,57),heltab2x8(:,:,66))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(10),m3h2x4(:,58),heltab2x8(:,:,67))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(11),ngZd,m3h2x4(:,59),heltab2x8(:,:,68))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(12),m3h2x4(:,60),heltab2x8(:,:,69))
  call Hloop_VA_Q(ntryL,G1H8(25),wf4(:,4),G1H2(52),m3h4x2(:,10),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(52),27,0,G2H2(96),n2h2(110))
  call Hloop_ZA_Q(ntryL,G1H8(26),wf4(:,4),G1H2(53),ngZd,m3h4x2(:,11),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(53),27,0,G2H2(97),n2h2(111))
  call Hloop_WA_Q(ntryL,G1H8(27),wf4(:,4),G1H2(57),m3h4x2(:,12),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(57),27,0,G2H2(98),n2h2(112))
  call Hloop_QA_W(ntryL,G2H4(1),ex2(:),G2H2(99),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_VV_S(ntryL,G1H4(20),ex3(:),G1H2(58),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_UW_V(ntryL,G1H4(21),19,ex3(:),4,G2H2(100),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_VV_S(ntryL,G1H4(27),ex4(:),G1H2(63),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_UW_V(ntryL,G1H4(28),19,ex4(:),8,G2H2(101),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(102),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_VV_S(ntryL,G1H4(38),ex3(:),G1H2(64),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_UV_W(ntryL,G1H4(39),19,ex3(:),4,G2H2(103),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_VV_S(ntryL,G1H4(45),ex4(:),G1H2(68),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_UV_W(ntryL,G1H4(46),19,ex4(:),8,G2H2(104),m3h2x2(:,146),heltab2x4(:,:,146))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(7),G2H2(3),G1H2(39),G1H2(28),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(15),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(19),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(75),G2H2(23),G1H2(215),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(31),G2H2(27),G1H2(105),G1H2(94),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(81)])
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(39),G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(92)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(43),G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(103)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(79),G2H2(47),G1H2(226),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(51),G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(55),G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(83),G2H2(59),G1H2(237),G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(15)])
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(63),G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(26)])
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(67),G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(37)])
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(91),G2H2(71),G1H2(253),G1H2(204)])
call HGT_lower_alpha_w2_OLR(G2H2(86),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(86),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(86),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(87),G1H2(24),G1H2(11),G1H2(5)])
call HGT_lower_alpha_w2_OLR(G2H2(94),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(94),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(34),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(236),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(242),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(71),G1H2(60),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(66),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(221),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(100),G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(214),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(220),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(137),G1H2(126),G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(132),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(170),G1H2(159),G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(176),[G1H2(165),G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(203),G1H2(192),G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(209),[G1H2(198),G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(252)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(47),mass4set(:,1),  & 
G1H2(69),G1H2(74),G1H2(75),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(74),2,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(18),mass4set(:,1),  & 
G1H2(85),G1H2(86),G1H2(90),G1H2(91),G1H2(96),2)
  call HG1shiftOLR(G1H2(86),8,2)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(47),mass4set(:,2),  & 
G1H2(97),G1H2(101),G1H2(102),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(101),2,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(47),mass4set(:,3),  & 
G1H2(112),G1H2(113),G1H2(118),G1H2(119),G1H2(123),2)
  call HG1shiftOLR(G1H2(113),2,2)
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(48),mass4set(:,1),  & 
G1H2(124),G1H2(129),G1H2(130),G1H2(134),G1H2(135),2)
  call HG1shiftOLR(G1H2(129),4,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(22),mass4set(:,1),  & 
G1H2(140),G1H2(141),G1H2(145),G1H2(146),G1H2(151),2)
  call HG1shiftOLR(G1H2(141),8,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(48),mass4set(:,4),  & 
G1H2(152),G1H2(156),G1H2(157),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(156),4,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(22),mass4set(:,4),  & 
G1H2(167),G1H2(168),G1H2(173),G1H2(174),G1H2(178),2)
  call HG1shiftOLR(G1H2(168),8,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(48),mass4set(:,5),  & 
G1H2(179),G1H2(184),G1H2(185),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(184),4,2)
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(22),mass4set(:,5),  & 
G1H2(195),G1H2(196),G1H2(200),G1H2(201),G1H2(206),2)
  call HG1shiftOLR(G1H2(196),8,2)
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(49),mass4set(:,1),  & 
G1H2(207),G1H2(211),G1H2(212),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(211),1,2)
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(18),mass4set(:,1),  & 
G1H2(222),G1H2(223),G1H2(228),G1H2(229),G1H2(233),2)
  call HG1shiftOLR(G1H2(223),8,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(49),mass4set(:,2),  & 
G1H2(234),G1H2(239),G1H2(240),G1H2(245),G1H2(249),2)
  call HG1shiftOLR(G1H2(239),1,2)
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(49),mass4set(:,3),  & 
G1H2(250),G1H2(255),G1H2(256),G1H2(261),G1H2(6),2)
  call HG1shiftOLR(G1H2(255),1,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(24),mass4set(:,1),  & 
G1H2(12),G1H2(18),G1H2(29),G1H2(40),G1H2(51),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(29),mass4set(:,1),  & 
G1H2(62),G1H2(73),G1H2(84),G1H2(95),G1H2(106),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(24),mass4set(:,4),  & 
G1H2(117),G1H2(128),G1H2(139),G1H2(150),G1H2(161),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(29),mass4set(:,4),  & 
G1H2(172),G1H2(183),G1H2(194),G1H2(205),G1H2(216),2)
  call HG1shiftOLR(G1H2(183),4,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(24),mass4set(:,5),  & 
G1H2(227),G1H2(238),G1H2(254),G1H2(3),G1H2(1),2)
  call HG1shiftOLR(G1H2(238),8,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(29),mass4set(:,5),  & 
G1H2(244),G1H2(7),G1H2(8),G1H2(260),G1H2(13),2)
  call HG1shiftOLR(G1H2(7),4,2)
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(50),mass4set(:,1),  & 
G1H2(14),G1H2(19),G1H2(20),G1H2(25),G1H2(30),2)
  call HG1shiftOLR(G1H2(19),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(32),mass4set(:,1),  & 
G1H2(31),G1H2(35),G1H2(36),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(35),8,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(50),mass4set(:,4),  & 
G1H2(46),G1H2(47),G1H2(52),G1H2(53),G1H2(57),2)
  call HG1shiftOLR(G1H2(47),4,2)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(32),mass4set(:,4),  & 
G1H2(39),G1H2(28),G1H2(17),G1H2(50),G1H2(61),2)
  call HG1shiftOLR(G1H2(28),8,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(50),mass4set(:,5),  & 
G1H2(215),G1H2(72),G1H2(105),G1H2(94),G1H2(83),2)
  call HG1shiftOLR(G1H2(72),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(32),mass4set(:,5),  & 
G1H2(81),G1H2(116),G1H2(92),G1H2(127),G1H2(103),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(16),mass4set(:,1),  & 
G1H2(226),G1H2(138),G1H2(149),G1H2(160),G1H2(237),2)
  call HG1shiftOLR(G1H2(138),8,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(35),mass4set(:,1),  & 
G1H2(171),G1H2(15),G1H2(182),G1H2(26),G1H2(193),2)
  call HG1shiftOLR(G1H2(15),4,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(16),mass4set(:,4),  & 
G1H2(37),G1H2(253),G1H2(204),G1H2(24),G1H2(11),2)
  call HG1shiftOLR(G1H2(253),8,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(35),mass4set(:,4),  & 
G1H2(5),G1H2(2),G1H2(4),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(16),mass4set(:,5),  & 
G1H2(16),G1H2(34),G1H2(23),G1H2(27),G1H2(236),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(35),mass4set(:,5),  & 
G1H2(38),G1H2(44),G1H2(48),G1H2(71),G1H2(60),2)
  call HG1shiftOLR(G1H2(44),4,2)
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(51),mass4set(:,6),  & 
G1H2(49),G1H2(66),G1H2(55),G1H2(59),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),1,2)
call HGT_OLR(G2H2(78),1,1,2)
call HGT_invQ_OLR(G2H2(78),2,5,2)
call HGT_OLR(G2H2(78),6,15,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(52),mass4set(:,6),  & 
G1H2(78),G1H2(82),G1H2(100),G1H2(89),G1H2(93),2)
  call HG1shiftOLR(G1H2(82),1,2)
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(53),mass4set(:,6),  & 
G1H2(214),G1H2(104),G1H2(110),G1H2(114),G1H2(137),2)
  call HG1shiftOLR(G1H2(104),2,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(20),mass4set(:,7),  & 
G1H2(126),G1H2(115),G1H2(132),G1H2(121),G1H2(125),2)
  call HG1shiftOLR(G1H2(115),8,2)
  call Hotf_4pt_reduction(G2H2(95),RedSet_4(11),mass4set(:,6),  & 
G1H2(136),G1H2(144),G1H2(147),G1H2(170),G1H2(159),2)
  call HG1shiftOLR(G1H2(144),2,2)
call HGT_OLR(G2H2(90),1,1,2)
call HGT_invQ_OLR(G2H2(90),2,5,2)
call HGT_OLR(G2H2(90),6,15,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(54),mass4set(:,6),  & 
G1H2(148),G1H2(165),G1H2(154),G1H2(158),G1H2(169),2)
  call HG1shiftOLR(G1H2(165),2,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(27),mass4set(:,7),  & 
G1H2(177),G1H2(180),G1H2(203),G1H2(192),G1H2(181),2)
  call HG1shiftOLR(G1H2(180),4,2)
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(9),mass4set(:,8),  & 
G1H2(198),G1H2(187),G1H2(191),G1H2(202),G1H2(210),2)
  call HG1shiftOLR(G1H2(187),2,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(10),mass4set(:,6),  & 
G1H2(213),G1H2(224),G1H2(225),G1H2(235),G1H2(248),2)
  call HG1shiftOLR(G1H2(224),2,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(13),mass4set(:,8),  & 
G1H2(251),G1H2(252),G1H2(265),G1H2(266),G1H2(267),2)
  call HG1shiftOLR(G1H2(252),2,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(14),mass4set(:,6),  & 
G1H2(268),G1H2(269),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(269),2,2)
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(17),mass4set(:,1),  & 
G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(274),8,2)
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(99))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(17),mass4set(:,4),  & 
G1H2(21),G1H2(22),G1H2(45),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(101))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(17),mass4set(:,5),  & 
G1H2(32),G1H2(33),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(33),8,2)
  call Hloop_AV_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(103))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(20),mass4set(:,1),  & 
G1H2(43),G1H2(242),G1H2(283),G1H2(284),G1H2(285),2)
  call HG1shiftOLR(G1H2(242),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(21),mass4set(:,1),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(287),8,2)
  call Hloop_QV_A(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(106))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(20),mass4set(:,9),  & 
G1H2(54),G1H2(77),G1H2(56),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hloop_QV_A(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(108))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(20),mass4set(:,10),  & 
G1H2(65),G1H2(67),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(67),8,2)
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(110))
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(25),mass4set(:,1),  & 
G1H2(76),G1H2(221),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(221),8,2)
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(113))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(25),mass4set(:,4),  & 
G1H2(87),G1H2(88),G1H2(111),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(88),8,2)
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(115))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(25),mass4set(:,5),  & 
G1H2(98),G1H2(99),G1H2(301),G1H2(302),G1H2(303),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hloop_QV_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(116))
  call Hloop_QV_A(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(117))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(27),mass4set(:,1),  & 
G1H2(109),G1H2(220),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(220),4,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(28),mass4set(:,1),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),2)
  call HG1shiftOLR(G1H2(308),4,2)
  call Hloop_QV_A(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(118))
  call Hloop_QV_A(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(122),ex3(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(120))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(27),mass4set(:,9),  & 
G1H2(120),G1H2(143),G1H2(122),G1H2(312),G1H2(313),2)
  call HG1shiftOLR(G1H2(143),4,2)
  call Hloop_QV_A(ntryL,G1H2(131),ex3(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(122))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(27),mass4set(:,10),  & 
G1H2(131),G1H2(133),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(133),4,2)
  call Hloop_QV_A(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(232),ex3(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(124))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(31),mass4set(:,1),  & 
G1H2(142),G1H2(232),G1H2(317),G1H2(318),G1H2(319),2)
  call HG1shiftOLR(G1H2(232),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(21),mass4set(:,1),  & 
G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(321),8,2)
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(176),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(127))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(31),mass4set(:,9),  & 
G1H2(153),G1H2(176),G1H2(155),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hloop_AV_Q(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(166),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(129))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(31),mass4set(:,10),  & 
G1H2(164),G1H2(166),G1H2(327),G1H2(328),G1H2(329),2)
  call HG1shiftOLR(G1H2(166),8,2)
  call Hloop_AV_Q(ntryL,G1H2(175),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(131))
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(34),mass4set(:,1),  & 
G1H2(175),G1H2(243),G1H2(330),G1H2(331),G1H2(332),2)
  call HG1shiftOLR(G1H2(243),4,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(28),mass4set(:,1),  & 
G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(334),4,2)
  call Hloop_AV_Q(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(209),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(134))
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(34),mass4set(:,9),  & 
G1H2(186),G1H2(209),G1H2(188),G1H2(338),G1H2(339),2)
  call HG1shiftOLR(G1H2(209),4,2)
  call Hloop_AV_Q(ntryL,G1H2(197),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(136))
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(34),mass4set(:,10),  & 
G1H2(197),G1H2(199),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(199),4,2)
  call Hloop_AV_Q(ntryL,G1H2(208),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(259),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(138))
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(37),mass4set(:,11),  & 
G1H2(208),G1H2(259),G1H2(343),G1H2(344),G1H2(345),2)
  call HG1shiftOLR(G1H2(259),8,2)
  call Hloop_QV_A(ntryL,G1H2(219),ex4(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(139))
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(39),mass4set(:,11),  & 
G1H2(219),G1H2(346),G1H2(347),G1H2(348),G1H2(349),2)
  call HG1shiftOLR(G1H2(346),4,2)
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(40),mass4set(:,5),  & 
G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(351),4,2)
  call Hloop_QV_A(ntryL,G1H2(230),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(231),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(141))
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(42),mass4set(:,11),  & 
G1H2(230),G1H2(231),G1H2(355),G1H2(356),G1H2(357),2)
  call HG1shiftOLR(G1H2(231),8,2)
  call Hloop_AV_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(118),n2h1(142))
  call Hloop_WA_Q(ntryL,G1H2(246),ex2(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(143))
  call Hloop_WA_Q(ntryL,G1H2(247),ex2(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(144))
  call Hloop_WA_Q(ntryL,G1H2(264),ex2(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(145))
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(44),mass4set(:,11),  & 
G1H2(241),G1H2(246),G1H2(247),G1H2(264),G1H2(358),2)
  call HG1shiftOLR(G1H2(246),4,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(45),mass4set(:,5),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),2)
  call HG1shiftOLR(G1H2(360),4,2)
  call Hloop_AV_Q(ntryL,G1H2(257),ex3(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(258),ex3(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(147))
  call Hloop_WA_Q(ntryL,G1H2(262),ex2(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(124),n2h1(148))
  call Hloop_WA_Q(ntryL,G1H2(263),ex2(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(149))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(6),mass4set(:,6),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(55),4)
  call HG1shiftOLR(G1H4(50),5,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(8),mass4set(:,6),  & 
G1H4(56),G1H4(57),G1H4(58),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(57),6,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(5),mass4set(:,6),  & 
G1H4(63),G1H4(64),G1H4(67),G1H4(68),G1H4(69),4)
  call HG1shiftOLR(G1H4(64),9,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(3),mass4set(:,1),  & 
G1H4(70),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(73),9,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(3),mass4set(:,2),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(85),4)
  call HG1shiftOLR(G1H4(80),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(3),mass4set(:,3),  & 
G1H4(86),G1H4(87),G1H4(88),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(87),9,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(7),mass4set(:,6),  & 
G1H4(93),G1H4(94),G1H4(97),G1H4(98),G1H4(99),4)
  call HG1shiftOLR(G1H4(94),10,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(1),mass4set(:,1),  & 
G1H4(100),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(103),10,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(1),mass4set(:,2),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(115),4)
  call HG1shiftOLR(G1H4(110),10,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(1),mass4set(:,3),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(117),10,4)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(42),mass4set(:,12),  & 
G1H2(257),G1H2(258),G1H2(262),G1H2(263),G1H2(364),2)
  call HG1shiftOLR(G1H2(258),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(58),ex4(:),G1tensor(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(31),mass4set(:,7),  & 
G1H2(58),G1H2(365),G1H2(366),G1H2(367),G1H2(368),2)
  call HG1shiftOLR(G1H2(365),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(63),ex3(:),G1tensor(7),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(34),mass4set(:,7),  & 
G1H2(63),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(369),4,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(37),mass4set(:,12),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(64),ex4(:),G1tensor(13),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(68),ex3(:),G1tensor(19),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hloop_VA_Q(ntryL,G1H2(69),ex2(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(126),n2h1(150))
  call Hloop_VA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(127),n2h1(151))
  call Hloop_VA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(152))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(130),n2h1(154))
  call Hloop_AV_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(155))
  call Hloop_ZA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),ngZd,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(156))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),ngZd,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(133),n2h1(157))
  call Hloop_ZA_Q(ntryL,G1H2(108),ex2(:),G1H1(1),ngZd,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(158))
  call Hloop_WA_Q(ntryL,G1H2(112),ex2(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(159))
  call Hloop_WA_Q(ntryL,G1H2(113),ex2(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(136),n2h1(160))
  call Hloop_WA_Q(ntryL,G1H2(123),ex2(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(161))
  call Hloop_QV_A(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(162))
  call Hloop_QV_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(139),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(135),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(142),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(152),ex3(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(144),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(156),ex3(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(145),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(171))
  call Hloop_QV_A(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(148),n2h1(172))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(173))
  call Hloop_QV_A(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(151),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(152),n2h1(176))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(177))
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(154),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H2(207),ex1(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(180))
  call Hloop_VQ_A(ntryL,G1H2(211),ex1(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(157),n2h1(181))
  call Hloop_VQ_A(ntryL,G1H2(218),ex1(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(158),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(159),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(160),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(161),n2h1(185))
  call Hloop_ZQ_A(ntryL,G1H2(234),ex1(:),G1H1(1),ngZd,m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(186))
  call Hloop_ZQ_A(ntryL,G1H2(239),ex1(:),G1H1(1),ngZd,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(163),n2h1(187))
  call Hloop_ZQ_A(ntryL,G1H2(249),ex1(:),G1H1(1),ngZd,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(164),n2h1(188))
  call Hloop_WQ_A(ntryL,G1H2(250),ex1(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(165),n2h1(189))
  call Hloop_WQ_A(ntryL,G1H2(255),ex1(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(166),n2h1(190))
  call Hloop_WQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(191))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(168),n2h1(192))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(169),n2h1(193))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(170),n2h1(194))
  call Hloop_QV_A(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(171),n2h1(195))
  call Hloop_QV_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(172),n2h1(196))
  call Hloop_QV_A(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(174),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(175),n2h1(199))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(176),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(177),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(178),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(216),ex3(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(180),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(238),ex4(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(181),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(182),n2h1(206))
  call Hloop_QV_A(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(183),n2h1(207))
  call Hloop_QV_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(184),n2h1(208))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(186),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(187),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(189),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(190),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(192),n2h1(216))
  call Hloop_AV_Q(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(193),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(194),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(195),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(196),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H2(215),ex3(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(198),n2h1(222))
  call Hloop_AV_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(199),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(200),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(201),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(202),n2h1(226))
  call Hloop_AV_Q(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(227))
  call Hloop_AV_Q(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(204),n2h1(228))
  call Hloop_AV_Q(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(205),n2h1(229))
  call Hloop_AV_Q(ntryL,G1H2(237),ex4(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(206),n2h1(230))
  call Hloop_AV_Q(ntryL,G1H2(171),ex3(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(207),n2h1(231))
  call Hloop_AV_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(208),n2h1(232))
  call Hloop_AV_Q(ntryL,G1H2(193),ex3(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(209),n2h1(233))
  call Hloop_AV_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(210),n2h1(234))
  call Hloop_AV_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(211),n2h1(235))
  call Hloop_AV_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(212),n2h1(236))
  call Hloop_AV_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(213),n2h1(237))
  call Hloop_AV_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(214),n2h1(238))
  call Hloop_AV_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(215),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(216),n2h1(240))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(217),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(218),n2h1(242))
  call Hloop_AV_Q(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(219),n2h1(243))
  call Hloop_AV_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(220),n2h1(244))
  call Hloop_AV_Q(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(221),n2h1(245))
  call Hloop_WQ_A(ntryL,G1H2(49),ex1(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(222),n2h1(246))
  call Hloop_WQ_A(ntryL,G1H2(66),ex1(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(223),n2h1(247))
  call Hloop_WQ_A(ntryL,G1H2(70),ex1(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(224),n2h1(248))
  call Hloop_WQ_A(ntryL,G1H2(78),ex1(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(225),n2h1(249))
  call Hloop_WQ_A(ntryL,G1H2(82),ex1(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(226),n2h1(250))
  call Hloop_WQ_A(ntryL,G1H2(93),ex1(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(227),n2h1(251))
  call Hloop_WA_Q(ntryL,G1H2(214),ex2(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(228),n2h1(252))
  call Hloop_WA_Q(ntryL,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(229),n2h1(253))
  call Hloop_WA_Q(ntryL,G1H2(137),ex2(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(230),n2h1(254))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(126),23,ex4(:),8,G2tensor(231),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(115),0,ex4(:),8,G2tensor(232),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(125),23,ex4(:),8,G2tensor(233),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hloop_WA_Q(ntryL,G1H2(136),ex2(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(234),n2h1(256))
  call Hloop_WA_Q(ntryL,G1H2(144),ex2(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(235),n2h1(257))
  call Hloop_WA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(236),n2h1(258))
  call Hloop_WA_Q(ntryL,G1H2(148),ex2(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(237),n2h1(259))
  call Hloop_WA_Q(ntryL,G1H2(165),ex2(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(238),n2h1(260))
  call Hloop_WA_Q(ntryL,G1H2(169),ex2(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(239),n2h1(261))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(177),27,ex3(:),4,G2tensor(240),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(180),0,ex3(:),4,G2tensor(241),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(181),27,ex3(:),4,G2tensor(242),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hloop_WA_Q(ntryL,G1H2(198),ex2(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(243),n2h1(263))
  call Hloop_WA_Q(ntryL,G1H2(187),ex2(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(244),n2h1(264))
  call Hloop_WA_Q(ntryL,G1H2(210),ex2(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(245),n2h1(265))
  call Hloop_WA_Q(ntryL,G1H2(213),ex2(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(246),n2h1(266))
  call Hloop_WA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(247),n2h1(267))
  call Hloop_WA_Q(ntryL,G1H2(248),ex2(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(248),n2h1(268))
  call Hloop_WA_Q(ntryL,G1H2(251),ex2(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(249),n2h1(269))
  call Hloop_WA_Q(ntryL,G1H2(252),ex2(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(250),n2h1(270))
  call Hloop_WA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(251),n2h1(271))
  call Hloop_WA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(252),n2h1(272))
  call Hloop_WA_Q(ntryL,G1H2(269),ex2(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(253),n2h1(273))
  call Hloop_WA_Q(ntryL,G1H2(272),ex2(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(254),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(273),ex4(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(255),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(274),ex4(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(256),n2h1(276))
  call Hloop_AV_Q(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(257),n2h1(277))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(258),n2h1(278))
  call Hloop_AV_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(259),n2h1(279))
  call Hloop_AV_Q(ntryL,G1H2(279),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(260),n2h1(280))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(261),n2h1(281))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(262),n2h1(282))
  call Hloop_AV_Q(ntryL,G1H2(282),ex4(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(263),n2h1(283))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(264),n2h1(284))
  call Hloop_QV_A(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(265),n2h1(285))
  call Hloop_QV_A(ntryL,G1H2(285),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(266),n2h1(286))
  call Hloop_QV_A(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(267),n2h1(287))
  call Hloop_QV_A(ntryL,G1H2(287),ex4(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(268),n2h1(288))
  call Hloop_QV_A(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(269),n2h1(289))
  call Hloop_QV_A(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(270),n2h1(290))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(271),n2h1(291))
  call Hloop_QV_A(ntryL,G1H2(292),ex4(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(272),n2h1(292))
  call Hloop_QV_A(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(273),n2h1(293))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(274),n2h1(294))
  call Hloop_QV_A(ntryL,G1H2(295),ex4(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(275),n2h1(295))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(276),n2h1(296))
  call Hloop_QV_A(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(277),n2h1(297))
  call Hloop_QV_A(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(278),n2h1(298))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(279),n2h1(299))
  call Hloop_QV_A(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(280),n2h1(300))
  call Hloop_QV_A(ntryL,G1H2(300),ex4(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(281),n2h1(301))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(282),n2h1(302))
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(283),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(303),ex4(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(284),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(285),n2h1(305))
  call Hloop_QV_A(ntryL,G1H2(220),ex3(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(286),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(287),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(288),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(289),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(311),ex3(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(290),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(291),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(292),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(293),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(131),ex3(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(294),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(295),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(316),ex3(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(296),n2h1(316))
  call Hloop_AV_Q(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(297),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(298),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(319),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(299),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H2(320),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(300),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(301),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(302),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(303),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(176),ex4(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(304),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(326),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(305),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(306),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(166),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(307),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(329),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(308),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(309),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(243),ex3(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(310),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(332),ex3(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(311),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(333),ex3(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(312),n2h1(332))
  call Hloop_AV_Q(ntryL,G1H2(334),ex3(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(313),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(337),ex3(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(314),n2h1(334))
  call Hloop_AV_Q(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(315),n2h1(335))
  call Hloop_AV_Q(ntryL,G1H2(209),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(316),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H2(339),ex3(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(317),n2h1(337))
  call Hloop_AV_Q(ntryL,G1H2(197),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(318),n2h1(338))
  call Hloop_AV_Q(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(319),n2h1(339))
  call Hloop_AV_Q(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(320),n2h1(340))
  call Hloop_QV_A(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(321),n2h1(341))
  call Hloop_QV_A(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(322),n2h1(342))
  call Hloop_QV_A(ntryL,G1H2(345),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(323),n2h1(343))
  call Hloop_QV_A(ntryL,G1H2(219),ex3(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(324),n2h1(344))
  call Hloop_QV_A(ntryL,G1H2(346),ex3(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(325),n2h1(345))
  call Hloop_QV_A(ntryL,G1H2(349),ex3(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(326),n2h1(346))
  call Hloop_QV_A(ntryL,G1H2(350),ex3(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(327),n2h1(347))
  call Hloop_QV_A(ntryL,G1H2(351),ex3(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(328),n2h1(348))
  call Hloop_QV_A(ntryL,G1H2(354),ex3(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(329),n2h1(349))
  call Hloop_AV_Q(ntryL,G1H2(230),ex4(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(330),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(231),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(331),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(357),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(332),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(241),ex3(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(333),n2h1(353))
  call Hloop_AV_Q(ntryL,G1H2(246),ex3(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(334),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H2(358),ex3(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(335),n2h1(355))
  call Hloop_AV_Q(ntryL,G1H2(359),ex3(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(336),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H2(360),ex3(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(337),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H2(363),ex3(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(338),n2h1(358))
  call Hloop_WQ_A(ntryL,G1H4(49),wf4(:,3),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(339),n2h1(359))
  call Hloop_WQ_A(ntryL,G1H4(50),wf4(:,3),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(340),n2h1(360))
  call Hloop_WQ_A(ntryL,G1H4(55),wf4(:,3),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(341),n2h1(361))
  call Hloop_WA_Q(ntryL,G1H4(56),wf4(:,10),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(342),n2h1(362))
  call Hloop_WA_Q(ntryL,G1H4(57),wf4(:,10),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(343),n2h1(363))
  call Hloop_WA_Q(ntryL,G1H4(62),wf4(:,10),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(344),n2h1(364))
  call Hloop_WQ_A(ntryL,G1H4(63),wf4(:,9),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(345),n2h1(365))
  call Hloop_WQ_A(ntryL,G1H4(64),wf4(:,9),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(346),n2h1(366))
  call Hloop_WQ_A(ntryL,G1H4(69),wf4(:,9),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(367))
  call Hloop_VQ_A(ntryL,G1H4(70),wf4(:,9),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(348),n2h1(368))
  call Hloop_VQ_A(ntryL,G1H4(73),wf4(:,9),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(349),n2h1(369))
  call Hloop_VQ_A(ntryL,G1H4(76),wf4(:,9),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(350),n2h1(370))
  call Hloop_ZQ_A(ntryL,G1H4(79),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,13),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(351),n2h1(371))
  call Hloop_ZQ_A(ntryL,G1H4(80),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(352),n2h1(372))
  call Hloop_ZQ_A(ntryL,G1H4(85),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(353),n2h1(373))
  call Hloop_WQ_A(ntryL,G1H4(86),wf4(:,9),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(354),n2h1(374))
  call Hloop_WQ_A(ntryL,G1H4(87),wf4(:,9),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(355),n2h1(375))
  call Hloop_WQ_A(ntryL,G1H4(92),wf4(:,9),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(356),n2h1(376))
  call Hloop_WA_Q(ntryL,G1H4(93),wf4(:,4),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(357),n2h1(377))
  call Hloop_WA_Q(ntryL,G1H4(94),wf4(:,4),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(358),n2h1(378))
  call Hloop_WA_Q(ntryL,G1H4(99),wf4(:,4),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(359),n2h1(379))
  call Hloop_VA_Q(ntryL,G1H4(100),wf4(:,4),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(360),n2h1(380))
  call Hloop_VA_Q(ntryL,G1H4(103),wf4(:,4),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(361),n2h1(381))
  call Hloop_VA_Q(ntryL,G1H4(106),wf4(:,4),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,170))



end subroutine vamp_1

end module ol_vamp_1_ppajj_ew_ddxaag_2_/**/REALKIND
