
module ol_vamp_1_ppajj_ew_bbbxbxa_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj_ew_bbbxbxa_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj_ew_bbbxbxa_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppajj_ew_bbbxbxa_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppajj_ew_bbbxbxa_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppajj_ew_bbbxbxa_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppajj_ew_bbbxbxa_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,2,1,4,8],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,2,1,4,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,2,1,4,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,2,1,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,2,1,8,4],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,2,1,8,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,2,1,8,4],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(31))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(32))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,2,4,8],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(33))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,2,4,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(34))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(35))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(36),n2h16(36))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(37))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(38))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(39),n2h16(39))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,1,2,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(40),n2h16(40))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,2,4,8],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(41))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,1,2,4,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(42))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,1,2,4,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(43))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,1,2,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,2,4,8],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(45),n2h16(45))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,2,4,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,2,4,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(47))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,2,4,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(48),n2h16(48))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,1,2,8,4],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(49))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,1,2,8,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(50))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,1,2,8,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(51),n2h16(51))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,1,2,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(52))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,1,2,8,4],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(53))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,1,2,8,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(54))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,2,8,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(55))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,2,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(56))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,2,8,4],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(57))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,2,8,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(58))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,2,8,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(59),n2h16(59))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,2,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(60))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,2,8,4],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(61),n2h16(61))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,2,8,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(62),n2h16(62))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,2,8,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(63))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,2,8,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(64))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,2,4,1,8],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(65),n2h16(65))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,2,4,1,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(66))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,4,1,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(67),n2h16(67))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,4,1,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(68),n2h16(68))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,4,1,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(69),n2h16(69))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,4,1,8],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(71),n2h16(70))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,4,1,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(72),n2h16(71))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,4,1,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(72))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,4,1,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(73))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,4,1,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(74))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,4,1,8],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(76),n2h16(75))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,4,1,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(77),n2h16(76))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,4,1,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(78),n2h16(77))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,4,1,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(78))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,4,1,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(80),n2h16(79))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,82),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,2,4,1,8],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(82),n2h16(80))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,2,4,1,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(83),n2h16(81))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,2,4,1,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(84),n2h16(82))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,2,4,1,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(85),n2h16(83))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,2,4,1,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(86),n2h16(84))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,2,4,1,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,2,8,1,4],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(89),n2h16(85))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,2,8,1,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(90),n2h16(86))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,2,8,1,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(91),n2h16(87))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,2,8,1,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(92),n2h16(88))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,2,8,1,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(93),n2h16(89))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,2,8,1,4],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(95),n2h16(90))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,2,8,1,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(96),n2h16(91))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,2,8,1,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(97),n2h16(92))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,2,8,1,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(98),n2h16(93))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,2,8,1,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(99),n2h16(94))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,2,8,1,4],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(100),n2h16(95))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,2,8,1,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(101),n2h16(96))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,2,8,1,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(102),n2h16(97))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,2,8,1,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(103),n2h16(98))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,2,8,1,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(104),n2h16(99))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(45)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,2,8,1,4],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(106),n2h16(100))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,2,8,1,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(107),n2h16(101))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,2,8,1,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(108),n2h16(102))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,2,8,1,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(109),n2h16(103))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,2,8,1,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMT,G1H16(110),n2h16(104))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,2,8,1,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,1,4,2,8],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(113),n2h16(105))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,1,4,2,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(114),n2h16(106))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,4,2,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(115),n2h16(107))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,4,2,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(116),n2h16(108))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,4,2,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMT,G1H16(117),n2h16(109))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,4,2,8],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(119),n2h16(110))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,4,2,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(120),n2h16(111))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,4,2,8],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(121),n2h16(112))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,4,2,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(122),n2h16(113))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,4,2,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMT,G1H16(123),n2h16(114))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,4,2,8],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(124),n2h16(115))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,1,4,2,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(125),n2h16(116))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,1,4,2,8],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(126),n2h16(117))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,1,4,2,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMB,G1H16(127),n2h16(118))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,1,4,2,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMT,G1H16(128),n2h16(119))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(129),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(45)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,1,4,2,8],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMB,G1H16(130),n2h16(120))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,1,4,2,8],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMB,G1H16(131),n2h16(121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,1,4,2,8],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMB,G1H16(132),n2h16(122))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,1,4,2,8],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMB,G1H16(133),n2h16(123))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,1,4,2,8],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMT,G1H16(134),n2h16(124))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,145),heltab2x32(:,:,145))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(135),m3h2x16(:,146),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,147),heltab2x32(:,:,147))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,1,4,2,8],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(136),m3h2x16(:,148),heltab2x32(:,:,148))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,1,8,2,4],[nMB,nMH,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(137),n2h16(125))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,1,8,2,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(138),n2h16(126))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,1,8,2,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(139),n2h16(127))
  Gcoeff(:)%j = (c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,1,8,2,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(140),n2h16(128))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,1,8,2,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMT,G1H16(141),n2h16(129))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,154),heltab2x32(:,:,154))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,1,8,2,4],[nMB,nMH,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(143),n2h16(130))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,1,8,2,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(144),n2h16(131))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,1,8,2,4],[nMB,nMH,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(145),n2h16(132))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,1,8,2,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(146),n2h16(133))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,1,8,2,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMT,G1H16(147),n2h16(134))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,1,8,2,4],[nMB,0,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(148),n2h16(135))
  Gcoeff(:)%j = (c(95)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,1,8,2,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(149),n2h16(136))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,1,8,2,4],[nMB,nMZ,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(150),n2h16(137))
  Gcoeff(:)%j = (c(96)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,1,8,2,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMB,G1H16(151),n2h16(138))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,1,8,2,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMT,G1H16(152),n2h16(139))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,165),heltab2x32(:,:,165))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(153),m3h2x16(:,166),heltab2x32(:,:,166))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,1,8,2,4],[nMB,0,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMB,G1H16(154),n2h16(140))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,1,8,2,4],[nMB,0,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMB,G1H16(155),n2h16(141))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,1,8,2,4],[nMB,nMZ,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMB,G1H16(156),n2h16(142))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,1,8,2,4],[nMB,nMZ,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMB,G1H16(157),n2h16(143))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,1,8,2,4],[nMT,nMW,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMT,G1H16(158),n2h16(144))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,1,8,2,4],[nMW,nMT,nMW,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_AQ_S(ntryL,G1H16(1),ex2(:),G1H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_S(ntryL,G1H16(2),ex2(:),G1H8(2),ngH,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_S(ntryL,G1H16(3),ex2(:),G1H8(3),ngX,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_S(ntryL,G1H16(4),ex2(:),G1H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_S(ntryL,G1H16(5),ex2(:),G1H8(5),ngH,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_S(ntryL,G1H16(6),ex2(:),G1H8(6),ngX,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_S(ntryL,G1H16(7),ex2(:),G1H8(7),ngH,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_S(ntryL,G1H16(8),ex2(:),G1H8(8),ngX,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(9),ex2(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(10),ex2(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex2(:),G1H8(11),ngZd,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex2(:),G1H8(12),ngZd,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex2(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_V(ntryL,G1H16(14),ex2(:),G1H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex2(:),G1H8(15),ngZd,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex2(:),G1H8(16),ngZd,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_S(ntryL,G1H16(17),ex2(:),G1H8(17),ngH,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_S(ntryL,G1H16(18),ex2(:),G1H8(18),ngH,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_S(ntryL,G1H16(19),ex2(:),G1H8(19),ngX,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_S(ntryL,G1H16(20),ex2(:),G1H8(20),ngX,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_S(ntryL,G1H16(21),ex2(:),G1H8(21),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_S(ntryL,G1H16(22),ex2(:),G1H8(22),ngX,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_S(ntryL,G1H16(23),ex2(:),G1H8(23),ngH,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_S(ntryL,G1H16(24),ex2(:),G1H8(24),ngX,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H16(25),ex2(:),G1H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_V(ntryL,G1H16(26),ex2(:),G1H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex2(:),G1H8(27),ngZd,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex2(:),G1H8(28),ngZd,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(29),ex2(:),G1H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_V(ntryL,G1H16(30),ex2(:),G1H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H16(31),ex2(:),G1H8(31),ngZd,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(32),ex2(:),G1H8(32),ngZd,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_S(ntryL,G1H16(33),ex1(:),G1H8(33),ngH,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_AQ_S(ntryL,G1H16(34),ex1(:),G1H8(34),ngH,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_S(ntryL,G1H16(35),ex1(:),G1H8(35),ngX,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_AQ_S(ntryL,G1H16(36),ex1(:),G1H8(36),ngX,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AQ_S(ntryL,G1H16(37),ex1(:),G1H8(37),ngH,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_AQ_S(ntryL,G1H16(38),ex1(:),G1H8(38),ngX,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_AQ_S(ntryL,G1H16(39),ex1(:),G1H8(39),ngH,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AQ_S(ntryL,G1H16(40),ex1(:),G1H8(40),ngX,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_AQ_V(ntryL,G1H16(41),ex1(:),G1H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_AQ_V(ntryL,G1H16(42),ex1(:),G1H8(42),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H16(43),ex1(:),G1H8(43),ngZd,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_Z(ntryL,G1H16(44),ex1(:),G1H8(44),ngZd,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_V(ntryL,G1H16(45),ex1(:),G1H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AQ_V(ntryL,G1H16(46),ex1(:),G1H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_Z(ntryL,G1H16(47),ex1(:),G1H8(47),ngZd,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H16(48),ex1(:),G1H8(48),ngZd,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_S(ntryL,G1H16(49),ex1(:),G1H8(49),ngH,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_S(ntryL,G1H16(50),ex1(:),G1H8(50),ngH,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_S(ntryL,G1H16(51),ex1(:),G1H8(51),ngX,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_S(ntryL,G1H16(52),ex1(:),G1H8(52),ngX,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_S(ntryL,G1H16(53),ex1(:),G1H8(53),ngH,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_S(ntryL,G1H16(54),ex1(:),G1H8(54),ngX,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_S(ntryL,G1H16(55),ex1(:),G1H8(55),ngH,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_S(ntryL,G1H16(56),ex1(:),G1H8(56),ngX,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(57),ex1(:),G1H8(57),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_AQ_V(ntryL,G1H16(58),ex1(:),G1H8(58),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H16(59),ex1(:),G1H8(59),ngZd,m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H16(60),ex1(:),G1H8(60),ngZd,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_V(ntryL,G1H16(61),ex1(:),G1H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_V(ntryL,G1H16(62),ex1(:),G1H8(62),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_Z(ntryL,G1H16(63),ex1(:),G1H8(63),ngZd,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H16(64),ex1(:),G1H8(64),ngZd,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_S(ntryL,G1H16(65),ex2(:),G1H8(65),ngH,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_S(ntryL,G1H16(66),ex2(:),G1H8(66),ngX,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_AQ_S(ntryL,G1H16(67),ex2(:),G1H8(67),ngH,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_S(ntryL,G1H16(68),ex2(:),G1H8(68),ngX,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_AQ_S(ntryL,G1H16(69),ex2(:),G1H8(69),ngPtb,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_SQ_A(ntryL,G1H16(70),ex2(:),G1H8(70),ngPtb,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(70),18,nMT,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H16(71),ex2(:),G1H8(70),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_AQ_V(ntryL,G1H16(72),ex2(:),G1H8(71),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_AQ_Z(ntryL,G1H16(73),ex2(:),G1H8(72),ngZd,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H16(74),ex2(:),G1H8(73),ngZd,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AQ_W(ntryL,G1H16(75),ex2(:),G1H8(74),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_AQ_S(ntryL,G1H16(76),ex2(:),G1H8(75),ngH,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_AQ_S(ntryL,G1H16(77),ex2(:),G1H8(76),ngX,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_AQ_S(ntryL,G1H16(78),ex2(:),G1H8(77),ngH,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AQ_S(ntryL,G1H16(79),ex2(:),G1H8(78),ngX,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_AQ_S(ntryL,G1H16(80),ex2(:),G1H8(79),ngPtb,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_SQ_A(ntryL,G0H16(1),ex2(:),G0H8(1),ngPtb,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(80),n2h8(2))
  call Hloop_WQ_A(ntryL,G0H16(2),ex2(:),G0H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(81),n2h8(3))
  call Hloop_SQ_A(ntryL,G1H16(81),ex2(:),G1H8(82),ngPtb,m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(82),18,nMT,G2H8(2),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(82),ex2(:),G1H8(82),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_Z(ntryL,G1H16(83),ex2(:),G1H8(83),ngZd,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_AQ_V(ntryL,G1H16(84),ex2(:),G1H8(84),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H16(85),ex2(:),G1H8(85),ngZd,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_AQ_W(ntryL,G1H16(86),ex2(:),G1H8(86),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_WQ_A(ntryL,G1H16(87),ex2(:),G1H8(87),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(87),18,nMT,G2H8(3),n2h8(5))
  call Hloop_SQ_A(ntryL,G0H16(3),ex2(:),G0H8(1),ngPtb,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(87),n2h8(6))
  call Hloop_WQ_A(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(88),n2h8(7))
  call Hloop_WQ_A(ntryL,G1H16(88),ex2(:),G1H8(89),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(89),18,nMT,G2H8(4),n2h8(8))
  call Hloop_AQ_S(ntryL,G1H16(89),ex2(:),G1H8(89),ngH,m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_AQ_S(ntryL,G1H16(90),ex2(:),G1H8(90),ngX,m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_AQ_S(ntryL,G1H16(91),ex2(:),G1H8(91),ngH,m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_AQ_S(ntryL,G1H16(92),ex2(:),G1H8(92),ngX,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_AQ_S(ntryL,G1H16(93),ex2(:),G1H8(93),ngPtb,m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_SQ_A(ntryL,G1H16(94),ex2(:),G1H8(94),ngPtb,m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(94),18,nMT,G2H8(5),n2h8(9))
  call Hloop_AQ_V(ntryL,G1H16(95),ex2(:),G1H8(94),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntryL,G1H16(96),ex2(:),G1H8(95),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_AQ_Z(ntryL,G1H16(97),ex2(:),G1H8(96),ngZd,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H16(98),ex2(:),G1H8(97),ngZd,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AQ_W(ntryL,G1H16(99),ex2(:),G1H8(98),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_AQ_S(ntryL,G1H16(100),ex2(:),G1H8(99),ngH,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_S(ntryL,G1H16(101),ex2(:),G1H8(100),ngX,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_AQ_S(ntryL,G1H16(102),ex2(:),G1H8(101),ngH,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_AQ_S(ntryL,G1H16(103),ex2(:),G1H8(102),ngX,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_AQ_S(ntryL,G1H16(104),ex2(:),G1H8(103),ngPtb,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_SQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),ngPtb,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(104),n2h8(10))
  call Hloop_WQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(105),n2h8(11))
  call Hloop_SQ_A(ntryL,G1H16(105),ex2(:),G1H8(106),ngPtb,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(106),18,nMT,G2H8(6),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H16(106),ex2(:),G1H8(106),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_AQ_Z(ntryL,G1H16(107),ex2(:),G1H8(107),ngZd,m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_AQ_V(ntryL,G1H16(108),ex2(:),G1H8(108),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_AQ_Z(ntryL,G1H16(109),ex2(:),G1H8(109),ngZd,m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_AQ_W(ntryL,G1H16(110),ex2(:),G1H8(110),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_WQ_A(ntryL,G1H16(111),ex2(:),G1H8(111),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(111),18,nMT,G2H8(7),n2h8(13))
  call Hloop_SQ_A(ntryL,G0H16(7),ex2(:),G0H8(1),ngPtb,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(111),n2h8(14))
  call Hloop_WQ_A(ntryL,G0H16(8),ex2(:),G0H8(1),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(112),n2h8(15))
  call Hloop_WQ_A(ntryL,G1H16(112),ex2(:),G1H8(113),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(113),18,nMT,G2H8(8),n2h8(16))
  call Hloop_AQ_S(ntryL,G1H16(113),ex1(:),G1H8(113),ngH,m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_AQ_S(ntryL,G1H16(114),ex1(:),G1H8(114),ngH,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_AQ_S(ntryL,G1H16(115),ex1(:),G1H8(115),ngX,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_AQ_S(ntryL,G1H16(116),ex1(:),G1H8(116),ngX,m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_AQ_S(ntryL,G1H16(117),ex1(:),G1H8(117),ngPtb,m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_SQ_A(ntryL,G1H16(118),ex1(:),G1H8(118),ngPtb,m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(118),17,nMT,G2H8(9),n2h8(17))
  call Hloop_AQ_S(ntryL,G1H16(119),ex1(:),G1H8(118),ngH,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_AQ_S(ntryL,G1H16(120),ex1(:),G1H8(119),ngX,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_AQ_S(ntryL,G1H16(121),ex1(:),G1H8(120),ngH,m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_AQ_S(ntryL,G1H16(122),ex1(:),G1H8(121),ngX,m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_AQ_S(ntryL,G1H16(123),ex1(:),G1H8(122),ngPtb,m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_AQ_V(ntryL,G1H16(124),ex1(:),G1H8(123),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_AQ_V(ntryL,G1H16(125),ex1(:),G1H8(124),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H16(126),ex1(:),G1H8(125),ngZd,m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H16(127),ex1(:),G1H8(126),ngZd,m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_AQ_W(ntryL,G1H16(128),ex1(:),G1H8(127),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_SQ_A(ntryL,G0H16(9),ex1(:),G0H8(1),ngPtb,m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(128),n2h8(18))
  call Hloop_SQ_A(ntryL,G1H16(129),ex1(:),G1H8(129),ngPtb,m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(129),17,nMT,G2H8(10),n2h8(19))
  call Hloop_WQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(129),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H16(130),ex1(:),G1H8(130),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_AQ_V(ntryL,G1H16(131),ex1(:),G1H8(131),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_AQ_Z(ntryL,G1H16(132),ex1(:),G1H8(132),ngZd,m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_AQ_Z(ntryL,G1H16(133),ex1(:),G1H8(133),ngZd,m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_AQ_W(ntryL,G1H16(134),ex1(:),G1H8(134),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_SQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),ngPtb,m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(135),n2h8(21))
  call Hloop_WQ_A(ntryL,G1H16(135),ex1(:),G1H8(136),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(136),17,nMT,G2H8(11),n2h8(22))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(136),n2h8(23))
  call Hloop_WQ_A(ntryL,G1H16(136),ex1(:),G1H8(137),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(137),17,nMT,G2H8(12),n2h8(24))
  call Hloop_AQ_S(ntryL,G1H16(137),ex1(:),G1H8(137),ngH,m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_AQ_S(ntryL,G1H16(138),ex1(:),G1H8(138),ngH,m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_AQ_S(ntryL,G1H16(139),ex1(:),G1H8(139),ngX,m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_AQ_S(ntryL,G1H16(140),ex1(:),G1H8(140),ngX,m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_AQ_S(ntryL,G1H16(141),ex1(:),G1H8(141),ngPtb,m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_SQ_A(ntryL,G1H16(142),ex1(:),G1H8(142),ngPtb,m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(142),17,nMT,G2H8(13),n2h8(25))
  call Hloop_AQ_S(ntryL,G1H16(143),ex1(:),G1H8(142),ngH,m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_AQ_S(ntryL,G1H16(144),ex1(:),G1H8(143),ngX,m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_AQ_S(ntryL,G1H16(145),ex1(:),G1H8(144),ngH,m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_AQ_S(ntryL,G1H16(146),ex1(:),G1H8(145),ngX,m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_AQ_S(ntryL,G1H16(147),ex1(:),G1H8(146),ngPtb,m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_AQ_V(ntryL,G1H16(148),ex1(:),G1H8(147),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_AQ_V(ntryL,G1H16(149),ex1(:),G1H8(148),m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_AQ_Z(ntryL,G1H16(150),ex1(:),G1H8(149),ngZd,m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_AQ_Z(ntryL,G1H16(151),ex1(:),G1H8(150),ngZd,m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_AQ_W(ntryL,G1H16(152),ex1(:),G1H8(151),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_SQ_A(ntryL,G0H16(13),ex1(:),G0H8(1),ngPtb,m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(152),n2h8(26))
  call Hloop_SQ_A(ntryL,G1H16(153),ex1(:),G1H8(153),ngPtb,m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H8(153),17,nMT,G2H8(14),n2h8(27))
  call Hloop_WQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(153),n2h8(28))
  call Hloop_AQ_V(ntryL,G1H16(154),ex1(:),G1H8(154),m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_AQ_V(ntryL,G1H16(155),ex1(:),G1H8(155),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_AQ_Z(ntryL,G1H16(156),ex1(:),G1H8(156),ngZd,m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_AQ_Z(ntryL,G1H16(157),ex1(:),G1H8(157),ngZd,m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_AQ_W(ntryL,G1H16(158),ex1(:),G1H8(158),m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_SQ_A(ntryL,G0H16(15),ex1(:),G0H8(1),ngPtb,m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(159),n2h8(29))
  call Hloop_WQ_A(ntryL,G1H16(159),ex1(:),G1H8(160),m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H8(160),17,nMT,G2H8(15),n2h8(30))
  call Hloop_WQ_A(ntryL,G0H16(16),ex1(:),G0H8(1),m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(160),n2h8(31))
  call Hloop_WQ_A(ntryL,G1H16(160),ex1(:),G1H8(161),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(161),17,nMT,G2H8(16),n2h8(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(159)])
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(1),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngH,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(2),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngX,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(3),n2h4(3))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(4),n2h4(4))
  call Hloop_SQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngH,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(5),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngX,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(6),n2h4(6))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngH,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(7),n2h4(7))
  call Hloop_SQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngX,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(8),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(9),n2h4(9))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(10),n2h4(10))
  call Hloop_ZQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(11),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),ngZd,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(12),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(13),n2h4(13))
  call Hloop_VQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(14),n2h4(14))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),ngZd,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(15),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),ngZd,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(16),n2h4(16))
  call Hloop_SQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),ngH,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(17),n2h4(17))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),ngH,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(18),n2h4(18))
  call Hloop_SQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),ngX,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(19),n2h4(19))
  call Hloop_SQ_A(ntryL,G1H8(20),ex1(:),G1H4(1),ngX,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(20),n2h4(20))
  call Hloop_SQ_A(ntryL,G1H8(21),ex1(:),G1H4(1),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(21),n2h4(21))
  call Hloop_SQ_A(ntryL,G1H8(22),ex1(:),G1H4(1),ngX,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(22),n2h4(22))
  call Hloop_SQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),ngH,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(23),n2h4(23))
  call Hloop_SQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),ngX,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(24))
  call Hloop_VQ_A(ntryL,G1H8(25),ex1(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(25),n2h4(25))
  call Hloop_VQ_A(ntryL,G1H8(26),ex1(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(26),n2h4(26))
  call Hloop_ZQ_A(ntryL,G1H8(27),ex1(:),G1H4(1),ngZd,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(27),n2h4(27))
  call Hloop_ZQ_A(ntryL,G1H8(28),ex1(:),G1H4(1),ngZd,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(28),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H8(29),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(29),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(30),ex1(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(30),n2h4(30))
  call Hloop_ZQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),ngZd,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(31),n2h4(31))
  call Hloop_ZQ_A(ntryL,G1H8(32),ex1(:),G1H4(1),ngZd,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(32),n2h4(32))
  call Hloop_SQ_A(ntryL,G1H8(33),ex2(:),G1H4(1),ngH,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(33),n2h4(33))
  call Hloop_SQ_A(ntryL,G1H8(34),ex2(:),G1H4(1),ngH,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(34),n2h4(34))
  call Hloop_SQ_A(ntryL,G1H8(35),ex2(:),G1H4(1),ngX,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(35),n2h4(35))
  call Hloop_SQ_A(ntryL,G1H8(36),ex2(:),G1H4(1),ngX,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(36),n2h4(36))
  call Hloop_SQ_A(ntryL,G1H8(37),ex2(:),G1H4(1),ngH,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(37),n2h4(37))
  call Hloop_SQ_A(ntryL,G1H8(38),ex2(:),G1H4(1),ngX,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(38),n2h4(38))
  call Hloop_SQ_A(ntryL,G1H8(39),ex2(:),G1H4(1),ngH,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(39),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(40),ex2(:),G1H4(1),ngX,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(40),n2h4(40))
  call Hloop_VQ_A(ntryL,G1H8(41),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(41),n2h4(41))
  call Hloop_VQ_A(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(42),n2h4(42))
  call Hloop_ZQ_A(ntryL,G1H8(43),ex2(:),G1H4(1),ngZd,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(43),n2h4(43))
  call Hloop_ZQ_A(ntryL,G1H8(44),ex2(:),G1H4(1),ngZd,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(44),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(45),ex2(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(45),n2h4(45))
  call Hloop_VQ_A(ntryL,G1H8(46),ex2(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(46),n2h4(46))
  call Hloop_ZQ_A(ntryL,G1H8(47),ex2(:),G1H4(1),ngZd,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(47),n2h4(47))
  call Hloop_ZQ_A(ntryL,G1H8(48),ex2(:),G1H4(1),ngZd,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(48),n2h4(48))
  call Hloop_SQ_A(ntryL,G1H8(49),ex2(:),G1H4(1),ngH,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(49),n2h4(49))
  call Hloop_SQ_A(ntryL,G1H8(50),ex2(:),G1H4(1),ngH,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(50),n2h4(50))
  call Hloop_SQ_A(ntryL,G1H8(51),ex2(:),G1H4(1),ngX,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(51),n2h4(51))
  call Hloop_SQ_A(ntryL,G1H8(52),ex2(:),G1H4(1),ngX,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(52),n2h4(52))
  call Hloop_SQ_A(ntryL,G1H8(53),ex2(:),G1H4(1),ngH,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(53),n2h4(53))
  call Hloop_SQ_A(ntryL,G1H8(54),ex2(:),G1H4(1),ngX,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(54),n2h4(54))
  call Hloop_SQ_A(ntryL,G1H8(55),ex2(:),G1H4(1),ngH,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(55),n2h4(55))
  call Hloop_SQ_A(ntryL,G1H8(56),ex2(:),G1H4(1),ngX,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(56),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H8(57),ex2(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(57),n2h4(57))
  call Hloop_VQ_A(ntryL,G1H8(58),ex2(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(58),n2h4(58))
  call Hloop_ZQ_A(ntryL,G1H8(59),ex2(:),G1H4(1),ngZd,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(59),n2h4(59))
  call Hloop_ZQ_A(ntryL,G1H8(60),ex2(:),G1H4(1),ngZd,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(60),n2h4(60))
  call Hloop_VQ_A(ntryL,G1H8(61),ex2(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(61),n2h4(61))
  call Hloop_VQ_A(ntryL,G1H8(62),ex2(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(62),n2h4(62))
  call Hloop_ZQ_A(ntryL,G1H8(63),ex2(:),G1H4(1),ngZd,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(63),n2h4(63))
  call Hloop_ZQ_A(ntryL,G1H8(64),ex2(:),G1H4(1),ngZd,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(64),n2h4(64))
  call Hloop_SA_Q(ntryL,G1H8(65),ex3(:),G1H4(1),ngH,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(65),n2h4(65))
  call Hloop_SA_Q(ntryL,G1H8(66),ex3(:),G1H4(1),ngX,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(66),n2h4(66))
  call Hloop_SA_Q(ntryL,G1H8(67),ex3(:),G1H4(1),ngH,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(67),n2h4(67))
  call Hloop_SA_Q(ntryL,G1H8(68),ex3(:),G1H4(1),ngX,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(68),n2h4(68))
  call Hloop_SA_Q(ntryL,G1H8(69),ex3(:),G1H4(1),ngPbt,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(69),n2h4(69))
  call Hloop_QA_S(ntryL,G2H8(1),ex3(:),G2H4(70),ngPbt,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_VA_Q(ntryL,G1H8(70),ex3(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(71),n2h4(70))
  call Hloop_VA_Q(ntryL,G1H8(71),ex3(:),G1H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(72),n2h4(71))
  call Hloop_ZA_Q(ntryL,G1H8(72),ex3(:),G1H4(1),ngZd,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(73),n2h4(72))
  call Hloop_ZA_Q(ntryL,G1H8(73),ex3(:),G1H4(1),ngZd,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(74),n2h4(73))
  call Hloop_WA_Q(ntryL,G1H8(74),ex3(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(75),n2h4(74))
  call Hloop_SA_Q(ntryL,G1H8(75),ex3(:),G1H4(1),ngH,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(76),n2h4(75))
  call Hloop_SA_Q(ntryL,G1H8(76),ex3(:),G1H4(1),ngX,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(77),n2h4(76))
  call Hloop_SA_Q(ntryL,G1H8(77),ex3(:),G1H4(1),ngH,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(78),n2h4(77))
  call Hloop_SA_Q(ntryL,G1H8(78),ex3(:),G1H4(1),ngX,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(79),n2h4(78))
  call Hloop_SA_Q(ntryL,G1H8(79),ex3(:),G1H4(1),ngPbt,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(80),n2h4(79))
  call Hloop_QA_S(ntryL,G2H8(3),ex3(:),G2H4(81),ngPbt,m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_W(ntryL,G2H8(2),ex3(:),G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_VA_Q(ntryL,G1H8(82),ex3(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(83),n2h4(80))
  call Hloop_ZA_Q(ntryL,G1H8(83),ex3(:),G1H4(1),ngZd,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(84),n2h4(81))
  call Hloop_VA_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(85),n2h4(82))
  call Hloop_ZA_Q(ntryL,G1H8(85),ex3(:),G1H4(1),ngZd,m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(86),n2h4(83))
  call Hloop_WA_Q(ntryL,G1H8(86),ex3(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(87),n2h4(84))
  call Hloop_QA_W(ntryL,G2H8(4),ex3(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_SA_Q(ntryL,G1H8(89),ex4(:),G1H4(1),ngH,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(89),n2h4(85))
  call Hloop_SA_Q(ntryL,G1H8(90),ex4(:),G1H4(1),ngX,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(90),n2h4(86))
  call Hloop_SA_Q(ntryL,G1H8(91),ex4(:),G1H4(1),ngH,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(91),n2h4(87))
  call Hloop_SA_Q(ntryL,G1H8(92),ex4(:),G1H4(1),ngX,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(92),n2h4(88))
  call Hloop_SA_Q(ntryL,G1H8(93),ex4(:),G1H4(1),ngPbt,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(93),n2h4(89))
  call Hloop_QA_S(ntryL,G2H8(5),ex4(:),G2H4(94),ngPbt,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VA_Q(ntryL,G1H8(94),ex4(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(95),n2h4(90))
  call Hloop_VA_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(96),n2h4(91))
  call Hloop_ZA_Q(ntryL,G1H8(96),ex4(:),G1H4(1),ngZd,m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(97),n2h4(92))
  call Hloop_ZA_Q(ntryL,G1H8(97),ex4(:),G1H4(1),ngZd,m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(98),n2h4(93))
  call Hloop_WA_Q(ntryL,G1H8(98),ex4(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(99),n2h4(94))
  call Hloop_SA_Q(ntryL,G1H8(99),ex4(:),G1H4(1),ngH,m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(100),n2h4(95))
  call Hloop_SA_Q(ntryL,G1H8(100),ex4(:),G1H4(1),ngX,m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(101),n2h4(96))
  call Hloop_SA_Q(ntryL,G1H8(101),ex4(:),G1H4(1),ngH,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(102),n2h4(97))
  call Hloop_SA_Q(ntryL,G1H8(102),ex4(:),G1H4(1),ngX,m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(103),n2h4(98))
  call Hloop_SA_Q(ntryL,G1H8(103),ex4(:),G1H4(1),ngPbt,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(104),n2h4(99))
  call Hloop_QA_S(ntryL,G2H8(7),ex4(:),G2H4(105),ngPbt,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_QA_W(ntryL,G2H8(6),ex4(:),G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_VA_Q(ntryL,G1H8(106),ex4(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(107),n2h4(100))
  call Hloop_ZA_Q(ntryL,G1H8(107),ex4(:),G1H4(1),ngZd,m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(108),n2h4(101))
  call Hloop_VA_Q(ntryL,G1H8(108),ex4(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(109),n2h4(102))
  call Hloop_ZA_Q(ntryL,G1H8(109),ex4(:),G1H4(1),ngZd,m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(110),n2h4(103))
  call Hloop_WA_Q(ntryL,G1H8(110),ex4(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(111),n2h4(104))
  call Hloop_QA_W(ntryL,G2H8(8),ex4(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_SA_Q(ntryL,G1H8(113),ex3(:),G1H4(1),ngH,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(113),n2h4(105))
  call Hloop_SA_Q(ntryL,G1H8(114),ex3(:),G1H4(1),ngH,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(114),n2h4(106))
  call Hloop_SA_Q(ntryL,G1H8(115),ex3(:),G1H4(1),ngX,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(115),n2h4(107))
  call Hloop_SA_Q(ntryL,G1H8(116),ex3(:),G1H4(1),ngX,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(116),n2h4(108))
  call Hloop_SA_Q(ntryL,G1H8(117),ex3(:),G1H4(1),ngPbt,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(117),n2h4(109))
  call Hloop_QA_S(ntryL,G2H8(9),ex3(:),G2H4(118),ngPbt,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_SA_Q(ntryL,G1H8(118),ex3(:),G1H4(1),ngH,m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(119),n2h4(110))
  call Hloop_SA_Q(ntryL,G1H8(119),ex3(:),G1H4(1),ngX,m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(120),n2h4(111))
  call Hloop_SA_Q(ntryL,G1H8(120),ex3(:),G1H4(1),ngH,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(121),n2h4(112))
  call Hloop_SA_Q(ntryL,G1H8(121),ex3(:),G1H4(1),ngX,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(122),n2h4(113))
  call Hloop_SA_Q(ntryL,G1H8(122),ex3(:),G1H4(1),ngPbt,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(123),n2h4(114))
  call Hloop_VA_Q(ntryL,G1H8(123),ex3(:),G1H4(1),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(124),n2h4(115))
  call Hloop_VA_Q(ntryL,G1H8(124),ex3(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(125),n2h4(116))
  call Hloop_ZA_Q(ntryL,G1H8(125),ex3(:),G1H4(1),ngZd,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(126),n2h4(117))
  call Hloop_ZA_Q(ntryL,G1H8(126),ex3(:),G1H4(1),ngZd,m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(127),n2h4(118))
  call Hloop_WA_Q(ntryL,G1H8(127),ex3(:),G1H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(128),n2h4(119))
  call Hloop_QA_S(ntryL,G2H8(11),ex3(:),G2H4(129),ngPbt,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_QA_W(ntryL,G2H8(10),ex3(:),G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_VA_Q(ntryL,G1H8(130),ex3(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(131),n2h4(120))
  call Hloop_VA_Q(ntryL,G1H8(131),ex3(:),G1H4(1),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(132),n2h4(121))
  call Hloop_ZA_Q(ntryL,G1H8(132),ex3(:),G1H4(1),ngZd,m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(133),n2h4(122))
  call Hloop_ZA_Q(ntryL,G1H8(133),ex3(:),G1H4(1),ngZd,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(134),n2h4(123))
  call Hloop_WA_Q(ntryL,G1H8(134),ex3(:),G1H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(135),n2h4(124))
  call Hloop_QA_W(ntryL,G2H8(12),ex3(:),G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_SA_Q(ntryL,G1H8(137),ex4(:),G1H4(1),ngH,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(137),n2h4(125))
  call Hloop_SA_Q(ntryL,G1H8(138),ex4(:),G1H4(1),ngH,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(138),n2h4(126))
  call Hloop_SA_Q(ntryL,G1H8(139),ex4(:),G1H4(1),ngX,m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(139),n2h4(127))
  call Hloop_SA_Q(ntryL,G1H8(140),ex4(:),G1H4(1),ngX,m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(140),n2h4(128))
  call Hloop_SA_Q(ntryL,G1H8(141),ex4(:),G1H4(1),ngPbt,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(141),n2h4(129))
  call Hloop_QA_S(ntryL,G2H8(13),ex4(:),G2H4(142),ngPbt,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_SA_Q(ntryL,G1H8(142),ex4(:),G1H4(1),ngH,m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(143),n2h4(130))
  call Hloop_SA_Q(ntryL,G1H8(143),ex4(:),G1H4(1),ngX,m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(144),n2h4(131))
  call Hloop_SA_Q(ntryL,G1H8(144),ex4(:),G1H4(1),ngH,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(145),n2h4(132))
  call Hloop_SA_Q(ntryL,G1H8(145),ex4(:),G1H4(1),ngX,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(146),n2h4(133))
  call Hloop_SA_Q(ntryL,G1H8(146),ex4(:),G1H4(1),ngPbt,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(147),n2h4(134))
  call Hloop_VA_Q(ntryL,G1H8(147),ex4(:),G1H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(148),n2h4(135))
  call Hloop_VA_Q(ntryL,G1H8(148),ex4(:),G1H4(1),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(149),n2h4(136))
  call Hloop_ZA_Q(ntryL,G1H8(149),ex4(:),G1H4(1),ngZd,m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(150),n2h4(137))
  call Hloop_ZA_Q(ntryL,G1H8(150),ex4(:),G1H4(1),ngZd,m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(151),n2h4(138))
  call Hloop_WA_Q(ntryL,G1H8(151),ex4(:),G1H4(1),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(152),n2h4(139))
  call Hloop_QA_S(ntryL,G2H8(15),ex4(:),G2H4(153),ngPbt,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_QA_W(ntryL,G2H8(14),ex4(:),G2H4(154),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_VA_Q(ntryL,G1H8(154),ex4(:),G1H4(1),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(155),n2h4(140))
  call Hloop_VA_Q(ntryL,G1H8(155),ex4(:),G1H4(1),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(156),n2h4(141))
  call Hloop_ZA_Q(ntryL,G1H8(156),ex4(:),G1H4(1),ngZd,m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(157),n2h4(142))
  call Hloop_ZA_Q(ntryL,G1H8(157),ex4(:),G1H4(1),ngZd,m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(158),n2h4(143))
  call Hloop_WA_Q(ntryL,G1H8(158),ex4(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(159),n2h4(144))
  call Hloop_QA_W(ntryL,G2H8(16),ex4(:),G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G2H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(111),[G2H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G2H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G2H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(128),[G2H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G2H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G2H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G2H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(157),[G2H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(158),[G2H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(159),[G2H4(147)])
  call Hloop_QA_S(ntryL,G2H4(1),ex3(:),G2H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_S(ntryL,G2H4(2),ex3(:),G2H2(2),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_S(ntryL,G2H4(11),ex3(:),G2H2(3),ngH,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_S(ntryL,G2H4(12),ex3(:),G2H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(5),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(15),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_Z(ntryL,G2H4(7),ex3(:),G2H2(7),ngZd,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(16),ex3(:),G2H2(8),ngZd,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_S(ntryL,G2H4(9),ex3(:),G2H2(9),ngH,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_S(ntryL,G2H4(10),ex3(:),G2H2(10),ngX,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(13),ex3(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G2H4(14),ex3(:),G2H2(12),ngZd,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_S(ntryL,G2H4(17),ex4(:),G2H2(13),ngH,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_S(ntryL,G2H4(18),ex4(:),G2H2(14),ngX,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G2H4(27),ex4(:),G2H2(15),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_S(ntryL,G2H4(28),ex4(:),G2H2(16),ngX,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(21),ex4(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(31),ex4(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(23),ex4(:),G2H2(19),ngZd,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G2H4(32),ex4(:),G2H2(20),ngZd,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_S(ntryL,G2H4(25),ex4(:),G2H2(21),ngH,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_S(ntryL,G2H4(26),ex4(:),G2H2(22),ngX,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_V(ntryL,G2H4(29),ex4(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(30),ex4(:),G2H2(24),ngZd,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_S(ntryL,G2H4(33),ex3(:),G2H2(25),ngH,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_S(ntryL,G2H4(34),ex3(:),G2H2(26),ngX,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_S(ntryL,G2H4(43),ex3(:),G2H2(27),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_S(ntryL,G2H4(44),ex3(:),G2H2(28),ngX,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(37),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(47),ex3(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_Z(ntryL,G2H4(39),ex3(:),G2H2(31),ngZd,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_Z(ntryL,G2H4(48),ex3(:),G2H2(32),ngZd,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_S(ntryL,G2H4(41),ex3(:),G2H2(33),ngH,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_S(ntryL,G2H4(42),ex3(:),G2H2(34),ngX,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_V(ntryL,G2H4(45),ex3(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_Z(ntryL,G2H4(46),ex3(:),G2H2(36),ngZd,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_S(ntryL,G2H4(49),ex4(:),G2H2(37),ngH,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_S(ntryL,G2H4(50),ex4(:),G2H2(38),ngX,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_S(ntryL,G2H4(59),ex4(:),G2H2(39),ngH,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_S(ntryL,G2H4(60),ex4(:),G2H2(40),ngX,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_V(ntryL,G2H4(53),ex4(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_V(ntryL,G2H4(63),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QA_Z(ntryL,G2H4(55),ex4(:),G2H2(43),ngZd,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_QA_Z(ntryL,G2H4(64),ex4(:),G2H2(44),ngZd,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QA_S(ntryL,G2H4(57),ex4(:),G2H2(45),ngH,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_QA_S(ntryL,G2H4(58),ex4(:),G2H2(46),ngX,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QA_V(ntryL,G2H4(61),ex4(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QA_Z(ntryL,G2H4(62),ex4(:),G2H2(48),ngZd,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_S(ntryL,G2H4(65),ex1(:),G2H2(49),ngH,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_S(ntryL,G2H4(73),ex1(:),G2H2(50),ngH,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_S(ntryL,G2H4(67),ex1(:),G2H2(51),ngX,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_S(ntryL,G2H4(74),ex1(:),G2H2(52),ngX,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_S(ntryL,G2H4(75),ex1(:),G2H2(53),ngPtb,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_AQ_S(ntryL,G2H4(71),ex1(:),G2H2(54),ngH,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_S(ntryL,G2H4(72),ex1(:),G2H2(55),ngX,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_V(ntryL,G2H4(76),ex1(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_V(ntryL,G2H4(84),ex1(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H4(78),ex1(:),G2H2(58),ngZd,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_Z(ntryL,G2H4(86),ex1(:),G2H2(59),ngZd,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_W(ntryL,G2H4(87),ex1(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_AQ_V(ntryL,G2H4(83),ex1(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AQ_Z(ntryL,G2H4(85),ex1(:),G2H2(62),ngZd,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(1),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_AQ_S(ntryL,G2H4(89),ex1(:),G2H2(63),ngH,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_AQ_S(ntryL,G2H4(97),ex1(:),G2H2(64),ngH,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AQ_S(ntryL,G2H4(91),ex1(:),G2H2(65),ngX,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_AQ_S(ntryL,G2H4(98),ex1(:),G2H2(66),ngX,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AQ_S(ntryL,G2H4(99),ex1(:),G2H2(67),ngPtb,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(2),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),4,4)
  call Hloop_AQ_S(ntryL,G2H4(95),ex1(:),G2H2(68),ngH,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AQ_S(ntryL,G2H4(96),ex1(:),G2H2(69),ngX,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AQ_V(ntryL,G2H4(100),ex1(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_AQ_V(ntryL,G2H4(108),ex1(:),G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AQ_Z(ntryL,G2H4(102),ex1(:),G2H2(72),ngZd,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AQ_Z(ntryL,G2H4(110),ex1(:),G2H2(73),ngZd,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AQ_W(ntryL,G2H4(111),ex1(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hotf_5pt_reduction(G2H4(105),RedSet_5(2),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(2),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hloop_AQ_V(ntryL,G2H4(107),ex1(:),G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_AQ_Z(ntryL,G2H4(109),ex1(:),G2H2(76),ngZd,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(2),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hloop_AQ_S(ntryL,G2H4(113),ex2(:),G2H2(77),ngH,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_AQ_S(ntryL,G2H4(114),ex2(:),G2H2(78),ngX,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AQ_S(ntryL,G2H4(126),ex2(:),G2H2(79),ngH,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_AQ_S(ntryL,G2H4(127),ex2(:),G2H2(80),ngX,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_S(ntryL,G2H4(128),ex2(:),G2H2(81),ngPtb,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(3),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hloop_AQ_V(ntryL,G2H4(119),ex2(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_AQ_V(ntryL,G2H4(133),ex2(:),G2H2(83),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_AQ_Z(ntryL,G2H4(121),ex2(:),G2H2(84),ngZd,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AQ_Z(ntryL,G2H4(134),ex2(:),G2H2(85),ngZd,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_AQ_W(ntryL,G2H4(135),ex2(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AQ_S(ntryL,G2H4(124),ex2(:),G2H2(87),ngH,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AQ_S(ntryL,G2H4(125),ex2(:),G2H2(88),ngX,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hotf_5pt_reduction(G2H4(129),RedSet_5(3),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(130),RedSet_5(3),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_AQ_V(ntryL,G2H4(131),ex2(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_AQ_Z(ntryL,G2H4(132),ex2(:),G2H2(90),ngZd,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hotf_5pt_reduction(G2H4(136),RedSet_5(3),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hloop_AQ_S(ntryL,G2H4(137),ex2(:),G2H2(91),ngH,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_S(ntryL,G2H4(138),ex2(:),G2H2(92),ngX,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_S(ntryL,G2H4(150),ex2(:),G2H2(93),ngH,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_AQ_S(ntryL,G2H4(151),ex2(:),G2H2(94),ngX,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AQ_S(ntryL,G2H4(152),ex2(:),G2H2(95),ngPtb,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(4),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),4,4)
  call Hloop_AQ_V(ntryL,G2H4(143),ex2(:),G2H2(96),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_AQ_V(ntryL,G2H4(157),ex2(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AQ_Z(ntryL,G2H4(145),ex2(:),G2H2(98),ngZd,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AQ_Z(ntryL,G2H4(158),ex2(:),G2H2(99),ngZd,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_W(ntryL,G2H4(159),ex2(:),G2H2(100),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_S(ntryL,G2H4(148),ex2(:),G2H2(101),ngH,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_S(ntryL,G2H4(149),ex2(:),G2H2(102),ngX,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hotf_5pt_reduction(G2H4(153),RedSet_5(4),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),4,4)
  call Hotf_5pt_reduction(G2H4(154),RedSet_5(4),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hloop_AQ_V(ntryL,G2H4(155),ex2(:),G2H2(103),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_Z(ntryL,G2H4(156),ex2(:),G2H2(104),ngZd,m3h2x2(:,104),heltab2x4(:,:,104))
  call Hotf_5pt_reduction(G2H4(160),RedSet_5(4),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),4,4)
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngPtb,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(105),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),ngPbt,m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_SQ_A(ntryL,G1H4(5),ex1(:),G1H2(2),ngPtb,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(106),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(6),ex1(:),G1H2(2),ngPtb,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(107),n2h2(3))
  call Hloop_SQ_A(ntryL,G1H4(7),ex1(:),G1H2(2),ngPtb,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(108),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_SQ_A(ntryL,G1H4(11),ex1(:),G1H2(3),ngPtb,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(109),n2h2(5))
  call Hloop_SQ_A(ntryL,G1H4(12),ex1(:),G1H2(3),ngPtb,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(110),n2h2(6))
  call Hloop_WQ_A(ntryL,G1H4(13),ex1(:),G1H2(3),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(111),n2h2(7))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(14),ex4(:),G1H2(3),ngPbt,m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_WQ_A(ntryL,G1H4(17),ex1(:),G1H2(4),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(112),n2h2(8))
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(4),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(113),n2h2(9))
  call Hloop_WQ_A(ntryL,G1H4(19),ex1(:),G1H2(4),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(114),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex4(:),G1H2(4),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_WQ_A(ntryL,G1H4(23),ex1(:),G1H2(5),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMT,G2H2(115),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(24),ex1(:),G1H2(5),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMT,G2H2(116),n2h2(12))
  call Hloop_SQ_A(ntryL,G1H4(25),ex1(:),G1H2(5),ngPtb,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(5),27,nMT,G2H2(117),n2h2(13))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(26),ex3(:),G1H2(5),ngPbt,m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_SQ_A(ntryL,G1H4(29),ex1(:),G1H2(6),ngPtb,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(6),27,nMT,G2H2(118),n2h2(14))
  call Hloop_SQ_A(ntryL,G1H4(30),ex1(:),G1H2(6),ngPtb,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(6),27,nMT,G2H2(119),n2h2(15))
  call Hloop_SQ_A(ntryL,G1H4(31),ex1(:),G1H2(6),ngPtb,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(6),27,nMT,G2H2(120),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(32),ex3(:),G1H2(6),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_SQ_A(ntryL,G1H4(35),ex1(:),G1H2(7),ngPtb,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(7),27,nMT,G2H2(121),n2h2(17))
  call Hloop_SQ_A(ntryL,G1H4(36),ex1(:),G1H2(7),ngPtb,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(7),27,nMT,G2H2(122),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(37),ex1(:),G1H2(7),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(7),27,nMT,G2H2(123),n2h2(19))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(38),ex3(:),G1H2(7),ngPbt,m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_WQ_A(ntryL,G1H4(41),ex1(:),G1H2(8),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(8),27,nMT,G2H2(124),n2h2(20))
  call Hloop_WQ_A(ntryL,G1H4(42),ex1(:),G1H2(8),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(8),27,nMT,G2H2(125),n2h2(21))
  call Hloop_WQ_A(ntryL,G1H4(43),ex1(:),G1H2(8),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(8),27,nMT,G2H2(126),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_WQ_A(ntryL,G1H4(47),ex1(:),G1H2(9),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMT,G2H2(127),n2h2(23))
  call Hloop_WQ_A(ntryL,G1H4(48),ex1(:),G1H2(9),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMT,G2H2(128),n2h2(24))
  call Hloop_SQ_A(ntryL,G1H4(49),ex2(:),G1H2(9),ngPtb,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMT,G2H2(129),n2h2(25))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(50),ex4(:),G1H2(9),ngPbt,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_SQ_A(ntryL,G1H4(53),ex2(:),G1H2(10),ngPtb,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(10),23,nMT,G2H2(130),n2h2(26))
  call Hloop_SQ_A(ntryL,G1H4(54),ex2(:),G1H2(10),ngPtb,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(10),23,nMT,G2H2(131),n2h2(27))
  call Hloop_SQ_A(ntryL,G1H4(55),ex2(:),G1H2(10),ngPtb,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(10),23,nMT,G2H2(132),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(56),ex4(:),G1H2(10),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_SQ_A(ntryL,G1H4(59),ex2(:),G1H2(11),ngPtb,m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(133),n2h2(29))
  call Hloop_SQ_A(ntryL,G1H4(60),ex2(:),G1H2(11),ngPtb,m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(134),n2h2(30))
  call Hloop_WQ_A(ntryL,G1H4(61),ex2(:),G1H2(11),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(135),n2h2(31))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(62),ex4(:),G1H2(11),ngPbt,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_WQ_A(ntryL,G1H4(65),ex2(:),G1H2(12),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(136),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(66),ex2(:),G1H2(12),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(137),n2h2(33))
  call Hloop_WQ_A(ntryL,G1H4(67),ex2(:),G1H2(12),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(138),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(68),ex4(:),G1H2(12),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_WQ_A(ntryL,G1H4(71),ex2(:),G1H2(13),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMT,G2H2(139),n2h2(35))
  call Hloop_WQ_A(ntryL,G1H4(72),ex2(:),G1H2(13),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMT,G2H2(140),n2h2(36))
  call Hloop_SQ_A(ntryL,G1H4(73),ex2(:),G1H2(13),ngPtb,m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(13),27,nMT,G2H2(141),n2h2(37))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(74),ex3(:),G1H2(13),ngPbt,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_SQ_A(ntryL,G1H4(77),ex2(:),G1H2(14),ngPtb,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(142),n2h2(38))
  call Hloop_SQ_A(ntryL,G1H4(78),ex2(:),G1H2(14),ngPtb,m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(143),n2h2(39))
  call Hloop_SQ_A(ntryL,G1H4(79),ex2(:),G1H2(14),ngPtb,m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(144),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(80),ex3(:),G1H2(14),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_SQ_A(ntryL,G1H4(83),ex2(:),G1H2(15),ngPtb,m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMT,G2H2(145),n2h2(41))
  call Hloop_SQ_A(ntryL,G1H4(84),ex2(:),G1H2(15),ngPtb,m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMT,G2H2(146),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(85),ex2(:),G1H2(15),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMT,G2H2(147),n2h2(43))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(86),ex3(:),G1H2(15),ngPbt,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_WQ_A(ntryL,G1H4(89),ex2(:),G1H2(16),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMT,G2H2(148),n2h2(44))
  call Hloop_WQ_A(ntryL,G1H4(90),ex2(:),G1H2(16),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMT,G2H2(149),n2h2(45))
  call Hloop_WQ_A(ntryL,G1H4(91),ex2(:),G1H2(16),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMT,G2H2(150),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(92),ex3(:),G1H2(16),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_WQ_A(ntryL,G1H4(95),ex2(:),G1H2(17),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(17),27,nMT,G2H2(151),n2h2(47))
  call Hloop_WQ_A(ntryL,G1H4(96),ex2(:),G1H2(17),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(17),27,nMT,G2H2(152),n2h2(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G2H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G2H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G2H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(146)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,2),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,3),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,4),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,5),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(5),mass5set(:,6),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(5),mass5set(:,7),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,3),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(5),mass5set(:,5),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,8),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(5),mass5set(:,9),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(5),mass5set(:,10),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(5),mass5set(:,9),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(6),mass5set(:,2),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),4,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(6),mass5set(:,3),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(96),4,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(6),mass5set(:,4),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),4,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(6),mass5set(:,5),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(6),mass5set(:,6),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),4,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(6),mass5set(:,7),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(120),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(6),mass5set(:,3),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(126),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(6),mass5set(:,5),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(132),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(6),mass5set(:,8),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),4,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(6),mass5set(:,9),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(144),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(6),mass5set(:,10),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(150),4,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(6),mass5set(:,9),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(7),mass5set(:,2),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(7),mass5set(:,3),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(7),mass5set(:,4),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),8,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(7),mass5set(:,5),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(180),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(7),mass5set(:,6),  & 
G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(186),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(7),mass5set(:,7),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(192),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(7),mass5set(:,3),  & 
G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(198),8,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(7),mass5set(:,5),  & 
G1H2(203),G1H2(204),G1H2(205),G1H2(206),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(204),8,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(7),mass5set(:,8),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(210),8,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(7),mass5set(:,9),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(216),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(7),mass5set(:,10),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),8,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(7),mass5set(:,9),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(8),mass5set(:,2),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),4,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(8),mass5set(:,3),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),4,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(8),mass5set(:,4),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),4,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(8),mass5set(:,5),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(252),4,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(8),mass5set(:,6),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),4,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(8),mass5set(:,7),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),4,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(8),mass5set(:,3),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),4,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(8),mass5set(:,5),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(276),4,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(8),mass5set(:,8),  & 
G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(282),4,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(8),mass5set(:,9),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),4,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(8),mass5set(:,10),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),4,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(8),mass5set(:,9),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),2)
  call HG1shiftOLR(G1H2(300),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(1),mass5set(:,2),  & 
G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(306),8,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(1),mass5set(:,4),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(312),8,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(1),mass5set(:,3),  & 
G1H2(317),G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(318),8,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(1),mass5set(:,5),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(1),mass5set(:,11),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),G1H2(334),2)
  call HG1shiftOLR(G1H2(330),8,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(1),mass5set(:,8),  & 
G1H2(335),G1H2(336),G1H2(337),G1H2(338),G1H2(339),G1H2(340),2)
  call HG1shiftOLR(G1H2(336),8,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(1),mass5set(:,9),  & 
G1H2(341),G1H2(342),G1H2(343),G1H2(344),G1H2(345),G1H2(346),2)
  call HG1shiftOLR(G1H2(342),8,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(1),mass5set(:,6),  & 
G1H2(347),G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(348),8,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(1),mass5set(:,7),  & 
G1H2(353),G1H2(354),G1H2(355),G1H2(356),G1H2(357),G1H2(358),2)
  call HG1shiftOLR(G1H2(354),8,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(1),mass5set(:,3),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),G1H2(364),2)
  call HG1shiftOLR(G1H2(360),8,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(1),mass5set(:,5),  & 
G1H2(365),G1H2(366),G1H2(367),G1H2(368),G1H2(369),G1H2(370),2)
  call HG1shiftOLR(G1H2(366),8,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(1),mass5set(:,11),  & 
G1H2(371),G1H2(372),G1H2(373),G1H2(374),G1H2(375),G1H2(376),2)
  call HG1shiftOLR(G1H2(372),8,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(1),mass5set(:,10),  & 
G1H2(377),G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),2)
  call HG1shiftOLR(G1H2(378),8,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(1),mass5set(:,9),  & 
G1H2(383),G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(384),8,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(2),mass5set(:,2),  & 
G1H2(389),G1H2(390),G1H2(391),G1H2(392),G1H2(393),G1H2(394),2)
  call HG1shiftOLR(G1H2(390),4,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(2),mass5set(:,4),  & 
G1H2(395),G1H2(396),G1H2(397),G1H2(398),G1H2(399),G1H2(400),2)
  call HG1shiftOLR(G1H2(396),4,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(2),mass5set(:,3),  & 
G1H2(401),G1H2(402),G1H2(403),G1H2(404),G1H2(405),G1H2(406),2)
  call HG1shiftOLR(G1H2(402),4,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(2),mass5set(:,5),  & 
G1H2(407),G1H2(408),G1H2(409),G1H2(410),G1H2(411),G1H2(412),2)
  call HG1shiftOLR(G1H2(408),4,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(2),mass5set(:,11),  & 
G1H2(413),G1H2(414),G1H2(415),G1H2(416),G1H2(417),G1H2(418),2)
  call HG1shiftOLR(G1H2(414),4,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(2),mass5set(:,8),  & 
G1H2(419),G1H2(420),G1H2(421),G1H2(422),G1H2(423),G1H2(424),2)
  call HG1shiftOLR(G1H2(420),4,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(2),mass5set(:,9),  & 
G1H2(425),G1H2(426),G1H2(427),G1H2(428),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(426),4,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(2),mass5set(:,6),  & 
G1H2(431),G1H2(432),G1H2(433),G1H2(434),G1H2(435),G1H2(436),2)
  call HG1shiftOLR(G1H2(432),4,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(2),mass5set(:,7),  & 
G1H2(437),G1H2(438),G1H2(439),G1H2(440),G1H2(441),G1H2(442),2)
  call HG1shiftOLR(G1H2(438),4,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(2),mass5set(:,3),  & 
G1H2(443),G1H2(444),G1H2(445),G1H2(446),G1H2(447),G1H2(448),2)
  call HG1shiftOLR(G1H2(444),4,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(2),mass5set(:,5),  & 
G1H2(449),G1H2(450),G1H2(451),G1H2(452),G1H2(453),G1H2(454),2)
  call HG1shiftOLR(G1H2(450),4,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(2),mass5set(:,11),  & 
G1H2(455),G1H2(456),G1H2(457),G1H2(458),G1H2(459),G1H2(460),2)
  call HG1shiftOLR(G1H2(456),4,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(2),mass5set(:,10),  & 
G1H2(461),G1H2(462),G1H2(463),G1H2(464),G1H2(465),G1H2(466),2)
  call HG1shiftOLR(G1H2(462),4,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(2),mass5set(:,9),  & 
G1H2(467),G1H2(468),G1H2(469),G1H2(470),G1H2(471),G1H2(472),2)
  call HG1shiftOLR(G1H2(468),4,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(3),mass5set(:,2),  & 
G1H2(473),G1H2(474),G1H2(475),G1H2(476),G1H2(477),G1H2(478),2)
  call HG1shiftOLR(G1H2(474),8,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(3),mass5set(:,3),  & 
G1H2(479),G1H2(480),G1H2(481),G1H2(482),G1H2(483),G1H2(484),2)
  call HG1shiftOLR(G1H2(480),8,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(3),mass5set(:,4),  & 
G1H2(485),G1H2(486),G1H2(487),G1H2(488),G1H2(489),G1H2(490),2)
  call HG1shiftOLR(G1H2(486),8,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(3),mass5set(:,5),  & 
G1H2(491),G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(492),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(3),mass5set(:,11),  & 
G1H2(497),G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(498),8,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(3),mass5set(:,6),  & 
G1H2(503),G1H2(504),G1H2(505),G1H2(506),G1H2(507),G1H2(508),2)
  call HG1shiftOLR(G1H2(504),8,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(3),mass5set(:,7),  & 
G1H2(509),G1H2(510),G1H2(511),G1H2(512),G1H2(513),G1H2(514),2)
  call HG1shiftOLR(G1H2(510),8,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(3),mass5set(:,3),  & 
G1H2(515),G1H2(516),G1H2(517),G1H2(518),G1H2(519),G1H2(520),2)
  call HG1shiftOLR(G1H2(516),8,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(3),mass5set(:,5),  & 
G1H2(521),G1H2(522),G1H2(523),G1H2(524),G1H2(525),G1H2(526),2)
  call HG1shiftOLR(G1H2(522),8,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(3),mass5set(:,11),  & 
G1H2(527),G1H2(528),G1H2(529),G1H2(530),G1H2(531),G1H2(532),2)
  call HG1shiftOLR(G1H2(528),8,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(3),mass5set(:,8),  & 
G1H2(533),G1H2(534),G1H2(535),G1H2(536),G1H2(537),G1H2(538),2)
  call HG1shiftOLR(G1H2(534),8,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(3),mass5set(:,9),  & 
G1H2(539),G1H2(540),G1H2(541),G1H2(542),G1H2(543),G1H2(544),2)
  call HG1shiftOLR(G1H2(540),8,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(3),mass5set(:,10),  & 
G1H2(545),G1H2(546),G1H2(547),G1H2(548),G1H2(549),G1H2(550),2)
  call HG1shiftOLR(G1H2(546),8,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(3),mass5set(:,9),  & 
G1H2(551),G1H2(552),G1H2(553),G1H2(554),G1H2(555),G1H2(556),2)
  call HG1shiftOLR(G1H2(552),8,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(4),mass5set(:,2),  & 
G1H2(557),G1H2(558),G1H2(559),G1H2(560),G1H2(561),G1H2(562),2)
  call HG1shiftOLR(G1H2(558),4,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(4),mass5set(:,3),  & 
G1H2(563),G1H2(564),G1H2(565),G1H2(566),G1H2(567),G1H2(568),2)
  call HG1shiftOLR(G1H2(564),4,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(4),mass5set(:,4),  & 
G1H2(569),G1H2(570),G1H2(571),G1H2(572),G1H2(573),G1H2(574),2)
  call HG1shiftOLR(G1H2(570),4,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(4),mass5set(:,5),  & 
G1H2(575),G1H2(576),G1H2(577),G1H2(578),G1H2(579),G1H2(580),2)
  call HG1shiftOLR(G1H2(576),4,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(4),mass5set(:,11),  & 
G1H2(581),G1H2(582),G1H2(583),G1H2(584),G1H2(585),G1H2(586),2)
  call HG1shiftOLR(G1H2(582),4,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(4),mass5set(:,6),  & 
G1H2(587),G1H2(588),G1H2(589),G1H2(590),G1H2(591),G1H2(592),2)
  call HG1shiftOLR(G1H2(588),4,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(4),mass5set(:,7),  & 
G1H2(593),G1H2(594),G1H2(595),G1H2(596),G1H2(597),G1H2(598),2)
  call HG1shiftOLR(G1H2(594),4,2)
  call Hotf_5pt_reduction(G2H2(98),RedSet_5(4),mass5set(:,3),  & 
G1H2(599),G1H2(600),G1H2(601),G1H2(602),G1H2(603),G1H2(604),2)
  call HG1shiftOLR(G1H2(600),4,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(4),mass5set(:,5),  & 
G1H2(605),G1H2(606),G1H2(607),G1H2(608),G1H2(609),G1H2(610),2)
  call HG1shiftOLR(G1H2(606),4,2)
  call Hotf_5pt_reduction(G2H2(100),RedSet_5(4),mass5set(:,11),  & 
G1H2(611),G1H2(612),G1H2(613),G1H2(614),G1H2(615),G1H2(616),2)
  call HG1shiftOLR(G1H2(612),4,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(4),mass5set(:,8),  & 
G1H2(617),G1H2(618),G1H2(619),G1H2(620),G1H2(621),G1H2(622),2)
  call HG1shiftOLR(G1H2(618),4,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(4),mass5set(:,9),  & 
G1H2(623),G1H2(624),G1H2(625),G1H2(626),G1H2(627),G1H2(628),2)
  call HG1shiftOLR(G1H2(624),4,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(4),mass5set(:,10),  & 
G1H2(629),G1H2(630),G1H2(631),G1H2(632),G1H2(633),G1H2(634),2)
  call HG1shiftOLR(G1H2(630),4,2)
  call Hotf_5pt_reduction(G2H2(104),RedSet_5(4),mass5set(:,9),  & 
G1H2(635),G1H2(636),G1H2(637),G1H2(638),G1H2(639),G1H2(640),2)
  call HG1shiftOLR(G1H2(636),4,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(111),ex4(:),G2tensor(1),ngPbt,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(113),ex4(:),G2tensor(2),ngPbt,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(114),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(116),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(123),ex3(:),G2tensor(5),ngPbt,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(125),ex3(:),G2tensor(6),ngPbt,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(126),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(128),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(135),ex4(:),G2tensor(9),ngPbt,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(137),ex4(:),G2tensor(10),ngPbt,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(138),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(140),ex4(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(147),ex3(:),G2tensor(13),ngPbt,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(149),ex3(:),G2tensor(14),ngPbt,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(150),ex3(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(152),ex3(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_SA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngH,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngH,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(18),n2h1(2))
  call Hloop_SA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),ngH,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(3))
  call Hloop_SA_Q(ntryL,G1H2(23),ex4(:),G1H1(1),ngX,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(4))
  call Hloop_SA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),ngX,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(21),n2h1(5))
  call Hloop_SA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),ngX,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),ngH,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngH,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(24),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngH,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),ngX,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(26),n2h1(10))
  call Hloop_SA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngX,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(27),n2h1(11))
  call Hloop_SA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),ngX,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(28),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(30),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(32),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(33),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngZd,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(36),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),ngZd,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(39),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),ngZd,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(40),n2h1(24))
  call Hloop_SA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),ngH,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(25))
  call Hloop_SA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngH,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(42),n2h1(26))
  call Hloop_SA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),ngH,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(27))
  call Hloop_SA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngX,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(28))
  call Hloop_SA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),ngX,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(45),n2h1(29))
  call Hloop_SA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),ngX,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(46),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(48),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(33))
  call Hloop_ZA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),ngZd,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(51),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),ngZd,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(52),n2h1(36))
  call Hloop_SA_Q(ntryL,G1H2(89),ex3(:),G1H1(1),ngH,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(37))
  call Hloop_SA_Q(ntryL,G1H2(90),ex3(:),G1H1(1),ngH,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(54),n2h1(38))
  call Hloop_SA_Q(ntryL,G1H2(94),ex3(:),G1H1(1),ngH,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(39))
  call Hloop_SA_Q(ntryL,G1H2(95),ex3(:),G1H1(1),ngX,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(56),n2h1(40))
  call Hloop_SA_Q(ntryL,G1H2(96),ex3(:),G1H1(1),ngX,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(57),n2h1(41))
  call Hloop_SA_Q(ntryL,G1H2(100),ex3(:),G1H1(1),ngX,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(42))
  call Hloop_SA_Q(ntryL,G1H2(101),ex3(:),G1H1(1),ngH,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(43))
  call Hloop_SA_Q(ntryL,G1H2(102),ex3(:),G1H1(1),ngH,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(60),n2h1(44))
  call Hloop_SA_Q(ntryL,G1H2(106),ex3(:),G1H1(1),ngH,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(45))
  call Hloop_SA_Q(ntryL,G1H2(107),ex3(:),G1H1(1),ngX,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(46))
  call Hloop_SA_Q(ntryL,G1H2(108),ex3(:),G1H1(1),ngX,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(63),n2h1(47))
  call Hloop_SA_Q(ntryL,G1H2(112),ex3(:),G1H1(1),ngX,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(64),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(113),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(66),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(119),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(69),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(54))
  call Hloop_ZA_Q(ntryL,G1H2(125),ex3(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(55))
  call Hloop_ZA_Q(ntryL,G1H2(126),ex3(:),G1H1(1),ngZd,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(72),n2h1(56))
  call Hloop_ZA_Q(ntryL,G1H2(130),ex3(:),G1H1(1),ngZd,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(73),n2h1(57))
  call Hloop_ZA_Q(ntryL,G1H2(131),ex3(:),G1H1(1),ngZd,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(74),n2h1(58))
  call Hloop_ZA_Q(ntryL,G1H2(132),ex3(:),G1H1(1),ngZd,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(75),n2h1(59))
  call Hloop_ZA_Q(ntryL,G1H2(136),ex3(:),G1H1(1),ngZd,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(76),n2h1(60))
  call Hloop_SA_Q(ntryL,G1H2(137),ex3(:),G1H1(1),ngH,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(61))
  call Hloop_SA_Q(ntryL,G1H2(138),ex3(:),G1H1(1),ngH,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(78),n2h1(62))
  call Hloop_SA_Q(ntryL,G1H2(142),ex3(:),G1H1(1),ngH,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(79),n2h1(63))
  call Hloop_SA_Q(ntryL,G1H2(143),ex3(:),G1H1(1),ngX,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(64))
  call Hloop_SA_Q(ntryL,G1H2(144),ex3(:),G1H1(1),ngX,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(81),n2h1(65))
  call Hloop_SA_Q(ntryL,G1H2(148),ex3(:),G1H1(1),ngX,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(84),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(154),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(69))
  call Hloop_ZA_Q(ntryL,G1H2(155),ex3(:),G1H1(1),ngZd,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(70))
  call Hloop_ZA_Q(ntryL,G1H2(156),ex3(:),G1H1(1),ngZd,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(87),n2h1(71))
  call Hloop_ZA_Q(ntryL,G1H2(160),ex3(:),G1H1(1),ngZd,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(72))
  call Hloop_SA_Q(ntryL,G1H2(161),ex4(:),G1H1(1),ngH,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(73))
  call Hloop_SA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),ngH,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(90),n2h1(74))
  call Hloop_SA_Q(ntryL,G1H2(166),ex4(:),G1H1(1),ngH,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(75))
  call Hloop_SA_Q(ntryL,G1H2(167),ex4(:),G1H1(1),ngX,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(92),n2h1(76))
  call Hloop_SA_Q(ntryL,G1H2(168),ex4(:),G1H1(1),ngX,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(93),n2h1(77))
  call Hloop_SA_Q(ntryL,G1H2(172),ex4(:),G1H1(1),ngX,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(78))
  call Hloop_SA_Q(ntryL,G1H2(173),ex4(:),G1H1(1),ngH,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(95),n2h1(79))
  call Hloop_SA_Q(ntryL,G1H2(174),ex4(:),G1H1(1),ngH,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(96),n2h1(80))
  call Hloop_SA_Q(ntryL,G1H2(178),ex4(:),G1H1(1),ngH,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(97),n2h1(81))
  call Hloop_SA_Q(ntryL,G1H2(179),ex4(:),G1H1(1),ngX,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(98),n2h1(82))
  call Hloop_SA_Q(ntryL,G1H2(180),ex4(:),G1H1(1),ngX,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(99),n2h1(83))
  call Hloop_SA_Q(ntryL,G1H2(184),ex4(:),G1H1(1),ngX,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(100),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(101),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(186),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(102),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(190),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(104),n2h1(88))
  call Hloop_VA_Q(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(105),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(106),n2h1(90))
  call Hloop_ZA_Q(ntryL,G1H2(197),ex4(:),G1H1(1),ngZd,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(107),n2h1(91))
  call Hloop_ZA_Q(ntryL,G1H2(198),ex4(:),G1H1(1),ngZd,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(108),n2h1(92))
  call Hloop_ZA_Q(ntryL,G1H2(202),ex4(:),G1H1(1),ngZd,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(109),n2h1(93))
  call Hloop_ZA_Q(ntryL,G1H2(203),ex4(:),G1H1(1),ngZd,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(110),n2h1(94))
  call Hloop_ZA_Q(ntryL,G1H2(204),ex4(:),G1H1(1),ngZd,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(111),n2h1(95))
  call Hloop_ZA_Q(ntryL,G1H2(208),ex4(:),G1H1(1),ngZd,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(209),ex4(:),G1H1(1),ngH,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(113),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(210),ex4(:),G1H1(1),ngH,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(114),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(214),ex4(:),G1H1(1),ngH,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),ngX,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(116),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(216),ex4(:),G1H1(1),ngX,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(117),n2h1(101))
  call Hloop_SA_Q(ntryL,G1H2(220),ex4(:),G1H1(1),ngX,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(119),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(120),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(121),n2h1(105))
  call Hloop_ZA_Q(ntryL,G1H2(227),ex4(:),G1H1(1),ngZd,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(122),n2h1(106))
  call Hloop_ZA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),ngZd,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(123),n2h1(107))
  call Hloop_ZA_Q(ntryL,G1H2(232),ex4(:),G1H1(1),ngZd,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(124),n2h1(108))
  call Hloop_SA_Q(ntryL,G1H2(233),ex3(:),G1H1(1),ngH,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(125),n2h1(109))
  call Hloop_SA_Q(ntryL,G1H2(234),ex3(:),G1H1(1),ngH,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(126),n2h1(110))
  call Hloop_SA_Q(ntryL,G1H2(238),ex3(:),G1H1(1),ngH,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(127),n2h1(111))
  call Hloop_SA_Q(ntryL,G1H2(239),ex3(:),G1H1(1),ngX,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(128),n2h1(112))
  call Hloop_SA_Q(ntryL,G1H2(240),ex3(:),G1H1(1),ngX,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(129),n2h1(113))
  call Hloop_SA_Q(ntryL,G1H2(244),ex3(:),G1H1(1),ngX,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(130),n2h1(114))
  call Hloop_SA_Q(ntryL,G1H2(245),ex3(:),G1H1(1),ngH,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(131),n2h1(115))
  call Hloop_SA_Q(ntryL,G1H2(246),ex3(:),G1H1(1),ngH,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(132),n2h1(116))
  call Hloop_SA_Q(ntryL,G1H2(250),ex3(:),G1H1(1),ngH,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(133),n2h1(117))
  call Hloop_SA_Q(ntryL,G1H2(251),ex3(:),G1H1(1),ngX,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(134),n2h1(118))
  call Hloop_SA_Q(ntryL,G1H2(252),ex3(:),G1H1(1),ngX,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(135),n2h1(119))
  call Hloop_SA_Q(ntryL,G1H2(256),ex3(:),G1H1(1),ngX,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(136),n2h1(120))
  call Hloop_VA_Q(ntryL,G1H2(257),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(137),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(258),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(138),n2h1(122))
  call Hloop_VA_Q(ntryL,G1H2(262),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(123))
  call Hloop_VA_Q(ntryL,G1H2(263),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(140),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(264),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(141),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H2(268),ex3(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(126))
  call Hloop_ZA_Q(ntryL,G1H2(269),ex3(:),G1H1(1),ngZd,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(127))
  call Hloop_ZA_Q(ntryL,G1H2(270),ex3(:),G1H1(1),ngZd,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(144),n2h1(128))
  call Hloop_ZA_Q(ntryL,G1H2(274),ex3(:),G1H1(1),ngZd,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(129))
  call Hloop_ZA_Q(ntryL,G1H2(275),ex3(:),G1H1(1),ngZd,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(146),n2h1(130))
  call Hloop_ZA_Q(ntryL,G1H2(276),ex3(:),G1H1(1),ngZd,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(147),n2h1(131))
  call Hloop_ZA_Q(ntryL,G1H2(280),ex3(:),G1H1(1),ngZd,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(148),n2h1(132))
  call Hloop_SA_Q(ntryL,G1H2(281),ex3(:),G1H1(1),ngH,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(149),n2h1(133))
  call Hloop_SA_Q(ntryL,G1H2(282),ex3(:),G1H1(1),ngH,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(150),n2h1(134))
  call Hloop_SA_Q(ntryL,G1H2(286),ex3(:),G1H1(1),ngH,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(151),n2h1(135))
  call Hloop_SA_Q(ntryL,G1H2(287),ex3(:),G1H1(1),ngX,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(152),n2h1(136))
  call Hloop_SA_Q(ntryL,G1H2(288),ex3(:),G1H1(1),ngX,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(153),n2h1(137))
  call Hloop_SA_Q(ntryL,G1H2(292),ex3(:),G1H1(1),ngX,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(154),n2h1(138))
  call Hloop_VA_Q(ntryL,G1H2(293),ex3(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(155),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(294),ex3(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(156),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(298),ex3(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(141))
  call Hloop_ZA_Q(ntryL,G1H2(299),ex3(:),G1H1(1),ngZd,m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(158),n2h1(142))
  call Hloop_ZA_Q(ntryL,G1H2(300),ex3(:),G1H1(1),ngZd,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(159),n2h1(143))
  call Hloop_ZA_Q(ntryL,G1H2(304),ex3(:),G1H1(1),ngZd,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(160),n2h1(144))
  call Hloop_SA_Q(ntryL,G1H2(305),ex4(:),G1H1(1),ngH,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(161),n2h1(145))
  call Hloop_SA_Q(ntryL,G1H2(306),ex4(:),G1H1(1),ngH,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(162),n2h1(146))
  call Hloop_SA_Q(ntryL,G1H2(310),ex4(:),G1H1(1),ngH,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(163),n2h1(147))
  call Hloop_SA_Q(ntryL,G1H2(311),ex4(:),G1H1(1),ngH,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(148))
  call Hloop_SA_Q(ntryL,G1H2(312),ex4(:),G1H1(1),ngH,m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(165),n2h1(149))
  call Hloop_SA_Q(ntryL,G1H2(316),ex4(:),G1H1(1),ngH,m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(150))
  call Hloop_SA_Q(ntryL,G1H2(317),ex4(:),G1H1(1),ngX,m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(167),n2h1(151))
  call Hloop_SA_Q(ntryL,G1H2(318),ex4(:),G1H1(1),ngX,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(168),n2h1(152))
  call Hloop_SA_Q(ntryL,G1H2(322),ex4(:),G1H1(1),ngX,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(169),n2h1(153))
  call Hloop_SA_Q(ntryL,G1H2(323),ex4(:),G1H1(1),ngX,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(170),n2h1(154))
  call Hloop_SA_Q(ntryL,G1H2(324),ex4(:),G1H1(1),ngX,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(171),n2h1(155))
  call Hloop_SA_Q(ntryL,G1H2(328),ex4(:),G1H1(1),ngX,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(172),n2h1(156))
  call Hloop_SA_Q(ntryL,G1H2(329),ex4(:),G1H1(1),ngPbt,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(173),n2h1(157))
  call Hloop_SA_Q(ntryL,G1H2(330),ex4(:),G1H1(1),ngPbt,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(174),n2h1(158))
  call Hloop_SA_Q(ntryL,G1H2(334),ex4(:),G1H1(1),ngPbt,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(175),n2h1(159))
  call Hloop_SA_Q(ntryL,G1H2(335),ex4(:),G1H1(1),ngH,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(176),n2h1(160))
  call Hloop_SA_Q(ntryL,G1H2(336),ex4(:),G1H1(1),ngH,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(177),n2h1(161))
  call Hloop_SA_Q(ntryL,G1H2(340),ex4(:),G1H1(1),ngH,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(178),n2h1(162))
  call Hloop_SA_Q(ntryL,G1H2(341),ex4(:),G1H1(1),ngX,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(179),n2h1(163))
  call Hloop_SA_Q(ntryL,G1H2(342),ex4(:),G1H1(1),ngX,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(180),n2h1(164))
  call Hloop_SA_Q(ntryL,G1H2(346),ex4(:),G1H1(1),ngX,m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(165))
  call Hloop_VA_Q(ntryL,G1H2(347),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(182),n2h1(166))
  call Hloop_VA_Q(ntryL,G1H2(348),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(183),n2h1(167))
  call Hloop_VA_Q(ntryL,G1H2(352),ex4(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(184),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(185),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(354),ex4(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(186),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(358),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(187),n2h1(171))
  call Hloop_ZA_Q(ntryL,G1H2(359),ex4(:),G1H1(1),ngZd,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(188),n2h1(172))
  call Hloop_ZA_Q(ntryL,G1H2(360),ex4(:),G1H1(1),ngZd,m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(189),n2h1(173))
  call Hloop_ZA_Q(ntryL,G1H2(364),ex4(:),G1H1(1),ngZd,m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(190),n2h1(174))
  call Hloop_ZA_Q(ntryL,G1H2(365),ex4(:),G1H1(1),ngZd,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(191),n2h1(175))
  call Hloop_ZA_Q(ntryL,G1H2(366),ex4(:),G1H1(1),ngZd,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(192),n2h1(176))
  call Hloop_ZA_Q(ntryL,G1H2(370),ex4(:),G1H1(1),ngZd,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(193),n2h1(177))
  call Hloop_WA_Q(ntryL,G1H2(371),ex4(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(194),n2h1(178))
  call Hloop_WA_Q(ntryL,G1H2(372),ex4(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(195),n2h1(179))
  call Hloop_WA_Q(ntryL,G1H2(376),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(180))
  call Hloop_VA_Q(ntryL,G1H2(377),ex4(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(197),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H2(378),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(198),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(382),ex4(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(199),n2h1(183))
  call Hloop_ZA_Q(ntryL,G1H2(383),ex4(:),G1H1(1),ngZd,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(200),n2h1(184))
  call Hloop_ZA_Q(ntryL,G1H2(384),ex4(:),G1H1(1),ngZd,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(201),n2h1(185))
  call Hloop_ZA_Q(ntryL,G1H2(388),ex4(:),G1H1(1),ngZd,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(202),n2h1(186))
  call Hloop_SA_Q(ntryL,G1H2(389),ex3(:),G1H1(1),ngH,m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(203),n2h1(187))
  call Hloop_SA_Q(ntryL,G1H2(390),ex3(:),G1H1(1),ngH,m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(204),n2h1(188))
  call Hloop_SA_Q(ntryL,G1H2(394),ex3(:),G1H1(1),ngH,m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(205),n2h1(189))
  call Hloop_SA_Q(ntryL,G1H2(395),ex3(:),G1H1(1),ngH,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(206),n2h1(190))
  call Hloop_SA_Q(ntryL,G1H2(396),ex3(:),G1H1(1),ngH,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(207),n2h1(191))
  call Hloop_SA_Q(ntryL,G1H2(400),ex3(:),G1H1(1),ngH,m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(208),n2h1(192))
  call Hloop_SA_Q(ntryL,G1H2(401),ex3(:),G1H1(1),ngX,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(209),n2h1(193))
  call Hloop_SA_Q(ntryL,G1H2(402),ex3(:),G1H1(1),ngX,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(210),n2h1(194))
  call Hloop_SA_Q(ntryL,G1H2(406),ex3(:),G1H1(1),ngX,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(211),n2h1(195))
  call Hloop_SA_Q(ntryL,G1H2(407),ex3(:),G1H1(1),ngX,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(212),n2h1(196))
  call Hloop_SA_Q(ntryL,G1H2(408),ex3(:),G1H1(1),ngX,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(213),n2h1(197))
  call Hloop_SA_Q(ntryL,G1H2(412),ex3(:),G1H1(1),ngX,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(214),n2h1(198))
  call Hloop_SA_Q(ntryL,G1H2(413),ex3(:),G1H1(1),ngPbt,m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(215),n2h1(199))
  call Hloop_SA_Q(ntryL,G1H2(414),ex3(:),G1H1(1),ngPbt,m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(216),n2h1(200))
  call Hloop_SA_Q(ntryL,G1H2(418),ex3(:),G1H1(1),ngPbt,m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(217),n2h1(201))
  call Hloop_SA_Q(ntryL,G1H2(419),ex3(:),G1H1(1),ngH,m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(218),n2h1(202))
  call Hloop_SA_Q(ntryL,G1H2(420),ex3(:),G1H1(1),ngH,m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(219),n2h1(203))
  call Hloop_SA_Q(ntryL,G1H2(424),ex3(:),G1H1(1),ngH,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(220),n2h1(204))
  call Hloop_SA_Q(ntryL,G1H2(425),ex3(:),G1H1(1),ngX,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(221),n2h1(205))
  call Hloop_SA_Q(ntryL,G1H2(426),ex3(:),G1H1(1),ngX,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(222),n2h1(206))
  call Hloop_SA_Q(ntryL,G1H2(430),ex3(:),G1H1(1),ngX,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(223),n2h1(207))
  call Hloop_VA_Q(ntryL,G1H2(431),ex3(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(224),n2h1(208))



end subroutine vamp_1

end module ol_vamp_1_ppajj_ew_bbbxbxa_4_/**/REALKIND
