
module ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(68,4), K2(4,4), KL(4,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0,   0]
  K1( 2,:) = [   0,   9,   0,   3]
  K1( 3,:) = [   0,   0,   0,   0]
  K1( 4,:) = [   0,   3,   0,   9]
  K1( 5,:) = [   0,  12,   0,   4]
  K1( 6,:) = [  12,   0,   4,   0]
  K1( 7,:) = [   0,   4,   0,  12]
  K1( 8,:) = [   4,   0,  12,   0]
  K1( 9,:) = [   0,   0,   0,   4]
  K1(10,:) = [   0,   0,   4,   0]
  K1(11,:) = [   0,   4,   0,   0]
  K1(12,:) = [   4,   0,   0,   0]
  K1(13,:) = [   0,  12,   0,   4]
  K1(14,:) = [  12,   0,   4,   0]
  K1(15,:) = [   0,   4,   0,  12]
  K1(16,:) = [   4,   0,  12,   0]
  K1(17,:) = [   0,   0,   0,  -4]
  K1(18,:) = [   0,   0,  -4,   0]
  K1(19,:) = [   0,  -4,   0, -12]
  K1(20,:) = [  -4,   0, -12,   0]
  K1(21,:) = [   0, -12,   0,  -4]
  K1(22,:) = [ -12,   0,  -4,   0]
  K1(23,:) = [   0,  -4,   0,   0]
  K1(24,:) = [  -4,   0,   0,   0]
  K1(25,:) = [   0,  12,   0,   4]
  K1(26,:) = [  12,   0,   4,   0]
  K1(27,:) = [   0,   4,   0,  12]
  K1(28,:) = [   4,   0,  12,   0]
  K1(29,:) = [   0, -12,   0,  -4]
  K1(30,:) = [ -12,   0,  -4,   0]
  K1(31,:) = [   0,  -4,   0,   0]
  K1(32,:) = [  -4,   0,   0,   0]
  K1(33,:) = [   0,   0,   0,  -4]
  K1(34,:) = [   0,   0,  -4,   0]
  K1(35,:) = [   0,  -4,   0, -12]
  K1(36,:) = [  -4,   0, -12,   0]
  K1(37,:) = [   0,   0,   0,   4]
  K1(38,:) = [   0,   0,   4,   0]
  K1(39,:) = [   0,   4,   0,   0]
  K1(40,:) = [   4,   0,   0,   0]
  K1(41,:) = [   0,  12,   0,   4]
  K1(42,:) = [  12,   0,   4,   0]
  K1(43,:) = [   0,   4,   0,  12]
  K1(44,:) = [   4,   0,  12,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   0,   0,   0]
  K1(66,:) = [   0,   9,   0,   3]
  K1(67,:) = [   0,   0,   0,   0]
  K1(68,:) = [   0,   3,   0,   9]

  K2(1,:) = [ 9, 0, 3, 0]
  K2(2,:) = [ 0, 9, 0, 3]
  K2(3,:) = [ 3, 0, 9, 0]
  K2(4,:) = [ 0, 3, 0, 9]

  KL(1,:) = [ 0, 9, 0, 3]
  KL(2,:) = [ 9, 0, 3, 0]
  KL(3,:) = [ 0, 3, 0, 9]
  KL(4,:) = [ 3, 0, 9, 0]

#if -1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND



module ol_forced_parameters_ppajj_ew_bbbxbxa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppajj_ew_bbbxbxa_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppajj_ew_bbbxbxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:)
  complex(REALKIND), save :: den(138)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,72), wf8(8,176), wf32(32,240)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(30), c(40)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,32), M0M1_hel_cc(4,32,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppajj_ew_bbbxbxa_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppajj_ew_bbbxbxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppajj_ew_bbbxbxa_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**3)/27._/**/REALKIND
    f( 2) = (CI*eQED**3)/3._/**/REALKIND
    f( 3) = (CI*eQED*gQCD**2)/3._/**/REALKIND
    f( 4) = (CI*countertermnorm*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**3*gQCD**2
    f( 7) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/27._/**/REALKIND
    f( 8) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 9) = (CI*countertermnorm*eQED*gQCD**4)/3._/**/REALKIND
    f(10) = (CI*countertermnorm*ctGbb*eQED*gQCD**4)/3._/**/REALKIND
    f(11) = (CI*countertermnorm*ctVbb*eQED*gQCD**4)/3._/**/REALKIND
    f(12) = (CI*eQED**3*MB**2)/(12._/**/REALKIND*MW**2*sw**2)
    f(13) = (CI*countertermnorm*eQED**3*gQCD**2*MB**2)/(12._/**/REALKIND*MW**2*sw**2)
    f(14) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB**2)/(12._/**/REALKIND*MW**2*sw**2)
    f(15) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB**2)/(12._/**/REALKIND*MW**2*sw**2)
    f(16) = (eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f(17) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(18) = (CI*eQED*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(19) = (eQED*gQCD**4*integralnorm*SwB)/6._/**/REALKIND
    f(20) = (eQED*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(21) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(22) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(23) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(24) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(25) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(26) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(27) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(28) = (eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(29) = (2*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(30) = (4*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND

  c = [ 6*f(16), 18*f(16), 48*f(16), 6*f(17), 18*f(17), 48*f(17), 9*CI*f(18), 27*CI*f(18), 18*f(19), 54*f(19), f(20), 3*f(20) &
    , 6*f(20), 8*f(20), 10*f(20), 18*f(20), 21*f(20), 24*f(20), 54*f(20), 6*f(21), 18*f(21), 6*f(22), 18*f(22), 6*f(23), 18*f(23) &
    , 6*f(24), 18*f(24), 6*f(25), 18*f(25), 6*f(26), 18*f(26), 6*f(27), 18*f(27), 48*f(27), 3*f(28), 9*f(28), 3*f(29), 9*f(29) &
    , 3*f(30), 9*f(30) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MH2)+L(6,5))
  den(2) = 1 /((L(5,18) - MB2)+L(6,18))
  den(4) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(6) = 1 /((L(5,5))+L(6,5))
  den(8) = 1 /((L(5,24) - MB2)+L(6,24))
  den(12) = 1 /((L(5,17) - MB2)+L(6,17))
  den(13) = 1 /((L(5,6) - MH2)+L(6,6))
  den(15) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(17) = 1 /((L(5,6))+L(6,6))
  den(22) = 1 /((L(5,9) - MH2)+L(6,9))
  den(24) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(26) = 1 /((L(5,9))+L(6,9))
  den(28) = 1 /((L(5,20) - MB2)+L(6,20))
  den(32) = 1 /((L(5,10) - MH2)+L(6,10))
  den(34) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(36) = 1 /((L(5,10))+L(6,10))
  den(41) = 1 /((L(5,26))+L(6,26))
  den(44) = 1 /((L(5,13) - MB2)+L(6,13))
  den(53) = 1 /((L(5,7) - MB2)+L(6,7))
  den(60) = 1 /((L(5,14) - MB2)+L(6,14))
  den(67) = 1 /((L(5,25))+L(6,25))
  den(78) = 1 /((L(5,22))+L(6,22))
  den(89) = 1 /((L(5,11) - MB2)+L(6,11))
  den(102) = 1 /((L(5,21))+L(6,21))
  den(113) = 1 /((L(5,21) - MH2)+L(6,21))
  den(115) = 1 /((L(5,21) - MZ2)+L(6,21))
  den(117) = 1 /((L(5,25) - MH2)+L(6,25))
  den(119) = 1 /((L(5,25) - MZ2)+L(6,25))
  den(121) = 1 /((L(5,22) - MH2)+L(6,22))
  den(123) = 1 /((L(5,22) - MZ2)+L(6,22))
  den(125) = 1 /((L(5,26) - MH2)+L(6,26))
  den(127) = 1 /((L(5,26) - MZ2)+L(6,26))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(4)*den(8)
  den(11) = den(6)*den(8)
  den(14) = den(12)*den(13)
  den(16) = den(12)*den(15)
  den(18) = den(12)*den(17)
  den(19) = den(8)*den(13)
  den(20) = den(8)*den(15)
  den(21) = den(8)*den(17)
  den(23) = den(2)*den(22)
  den(25) = den(2)*den(24)
  den(27) = den(2)*den(26)
  den(29) = den(22)*den(28)
  den(30) = den(24)*den(28)
  den(31) = den(26)*den(28)
  den(33) = den(12)*den(32)
  den(35) = den(12)*den(34)
  den(37) = den(12)*den(36)
  den(38) = den(28)*den(32)
  den(39) = den(28)*den(34)
  den(40) = den(28)*den(36)
  den(42) = den(2)*den(41)
  den(43) = den(6)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(2)*den(45)
  den(47) = den(4)*den(44)
  den(48) = den(2)*den(47)
  den(49) = den(6)*den(44)
  den(50) = den(2)*den(49)
  den(51) = den(8)*den(41)
  den(52) = den(6)*den(51)
  den(54) = den(1)*den(53)
  den(55) = den(8)*den(54)
  den(56) = den(4)*den(53)
  den(57) = den(8)*den(56)
  den(58) = den(6)*den(53)
  den(59) = den(8)*den(58)
  den(61) = den(13)*den(60)
  den(62) = den(12)*den(61)
  den(63) = den(15)*den(60)
  den(64) = den(12)*den(63)
  den(65) = den(17)*den(60)
  den(66) = den(12)*den(65)
  den(68) = den(12)*den(67)
  den(69) = den(17)*den(68)
  den(70) = den(8)*den(67)
  den(71) = den(17)*den(70)
  den(72) = den(13)*den(53)
  den(73) = den(8)*den(72)
  den(74) = den(15)*den(53)
  den(75) = den(8)*den(74)
  den(76) = den(17)*den(53)
  den(77) = den(8)*den(76)
  den(79) = den(2)*den(78)
  den(80) = den(26)*den(79)
  den(81) = den(22)*den(44)
  den(82) = den(2)*den(81)
  den(83) = den(24)*den(44)
  den(84) = den(2)*den(83)
  den(85) = den(26)*den(44)
  den(86) = den(2)*den(85)
  den(87) = den(28)*den(78)
  den(88) = den(26)*den(87)
  den(90) = den(22)*den(89)
  den(91) = den(28)*den(90)
  den(92) = den(24)*den(89)
  den(93) = den(28)*den(92)
  den(94) = den(26)*den(89)
  den(95) = den(28)*den(94)
  den(96) = den(32)*den(60)
  den(97) = den(12)*den(96)
  den(98) = den(34)*den(60)
  den(99) = den(12)*den(98)
  den(100) = den(36)*den(60)
  den(101) = den(12)*den(100)
  den(103) = den(12)*den(102)
  den(104) = den(36)*den(103)
  den(105) = den(28)*den(102)
  den(106) = den(36)*den(105)
  den(107) = den(32)*den(89)
  den(108) = den(28)*den(107)
  den(109) = den(34)*den(89)
  den(110) = den(28)*den(109)
  den(111) = den(36)*den(89)
  den(112) = den(28)*den(111)
  den(114) = den(12)*den(113)
  den(116) = den(12)*den(115)
  den(118) = den(12)*den(117)
  den(120) = den(12)*den(119)
  den(122) = den(2)*den(121)
  den(124) = den(2)*den(123)
  den(126) = den(2)*den(125)
  den(128) = den(2)*den(127)
  den(129) = den(28)*den(113)
  den(130) = den(28)*den(115)
  den(131) = den(28)*den(121)
  den(132) = den(28)*den(123)
  den(133) = den(8)*den(117)
  den(134) = den(8)*den(119)
  den(135) = den(8)*den(125)
  den(136) = den(8)*den(127)
  den(137) = den(6)*den(36)
  den(138) = den(17)*den(26)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppajj_ew_bbbxbxa_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom bottom anti-bottom anti-bottom gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppajj_ew_bbbxbxa_1, only: &
    & external_perm_ppajj_ew_bbbxbxa_1, &
    & external_perm_inv_ppajj_ew_bbbxbxa_1, &
    & extcomb_perm_ppajj_ew_bbbxbxa_1, &
    & average_factor_ppajj_ew_bbbxbxa_1, &
    & photonid_ppajj_ew_bbbxbxa_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppajj_ew_bbbxbxa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppajj_ew_bbbxbxa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,32)
  type(Hpolcont) :: M1helarray_ct(4,32)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
!  type(Hpolcont) :: A(32,240)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(240)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,240))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMB, nMB, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppajj_ew_bbbxbxa_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,2), 18, MB, 1_intkind1, wf4(:,3), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AQ_S(gX,ntry, ex3(:), ex1(:), wf4(:,4), n3(:,4), t3x4(:,:,3))
  call vert_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_QA_Z(gZd,ntry, ex1(:), ex3(:), wf4(:,6), n3(:,8), t3x4(:,:,5))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,4), n3(:,9), t3x8(:,:,4))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,7), n3(:,10), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,7), 24, MB, 1_intkind1, wf4(:,8), n2(2))
  call vert_QS_A(gH,ntry, ex2(:), wf4(:,1), wf8(:,5), n3(:,11), t3x8(:,:,5))
  call vert_QS_A(gX,ntry, ex2(:), wf4(:,4), wf8(:,6), n3(:,12), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,7), n3(:,13), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex2(:), wf8(:,8), n3(:,14), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,9), n3(:,15), t3x4(:,:,7))
  call vert_AQ_S(gH,ntry, ex3(:), ex2(:), wf4(:,10), n3(:,16), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,9), 17, MB, 1_intkind1, wf4(:,11), n2(3))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,11), wf8(:,9), n3(:,17), t3x8(:,:,9))
  call vert_AQ_S(gX,ntry, ex3(:), ex2(:), wf4(:,12), n3(:,18), t3x4(:,:,9))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,11), wf8(:,10), n3(:,19), t3x8(:,:,10))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,13), n3(:,20), t3x4(:,:,10))
  call vert_QA_V(ntry, wf4(:,11), ex4(:), wf8(:,11), n3(:,21), t3x8(:,:,11))
  call vert_QA_Z(gZd,ntry, ex2(:), ex3(:), wf4(:,14), n3(:,22), t3x4(:,:,11))
  call vert_QA_Z(gZd,ntry, wf4(:,11), ex4(:), wf8(:,12), n3(:,23), t3x8(:,:,12))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,10), wf8(:,13), n3(:,24), t3x8(:,:,13))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,12), wf8(:,14), n3(:,25), t3x8(:,:,14))
  call vert_VQ_A(ntry, wf4(:,13), ex1(:), wf8(:,15), n3(:,26), t3x8(:,:,15))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), ex1(:), wf8(:,16), n3(:,27), t3x8(:,:,16))
  call vert_AQ_S(gH,ntry, ex4(:), ex1(:), wf4(:,15), n3(:,28), t3x4(:,:,12))
  call vert_SA_Q(gH,ntry, wf4(:,15), ex3(:), wf8(:,17), n3(:,29), t3x8(:,:,17))
  call vert_AQ_S(gX,ntry, ex4(:), ex1(:), wf4(:,16), n3(:,30), t3x4(:,:,13))
  call vert_SA_Q(gX,ntry, wf4(:,16), ex3(:), wf8(:,18), n3(:,31), t3x8(:,:,18))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,17), n3(:,32), t3x4(:,:,14))
  call vert_AV_Q(ntry, ex3(:), wf4(:,17), wf8(:,19), n3(:,33), t3x8(:,:,19))
  call vert_QA_Z(gZd,ntry, ex1(:), ex4(:), wf4(:,18), n3(:,34), t3x4(:,:,15))
  call vert_AZ_Q(gZd,ntry, ex3(:), wf4(:,18), wf8(:,20), n3(:,35), t3x8(:,:,20))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,19), n3(:,36), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,19), 20, MB, 1_intkind1, wf4(:,20), n2(4))
  call vert_QS_A(gH,ntry, ex2(:), wf4(:,15), wf8(:,21), n3(:,37), t3x8(:,:,21))
  call vert_QS_A(gX,ntry, ex2(:), wf4(:,16), wf8(:,22), n3(:,38), t3x8(:,:,22))
  call vert_VQ_A(ntry, wf4(:,17), ex2(:), wf8(:,23), n3(:,39), t3x8(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf4(:,18), ex2(:), wf8(:,24), n3(:,40), t3x8(:,:,24))
  call vert_AQ_S(gH,ntry, ex4(:), ex2(:), wf4(:,21), n3(:,41), t3x4(:,:,17))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,11), wf8(:,25), n3(:,42), t3x8(:,:,25))
  call vert_AQ_S(gX,ntry, ex4(:), ex2(:), wf4(:,22), n3(:,43), t3x4(:,:,18))
  call vert_AQ_S(gX,ntry, ex3(:), wf4(:,11), wf8(:,26), n3(:,44), t3x8(:,:,26))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,23), n3(:,45), t3x4(:,:,19))
  call vert_QA_V(ntry, wf4(:,11), ex3(:), wf8(:,27), n3(:,46), t3x8(:,:,27))
  call vert_QA_Z(gZd,ntry, ex2(:), ex4(:), wf4(:,24), n3(:,47), t3x4(:,:,20))
  call vert_QA_Z(gZd,ntry, wf4(:,11), ex3(:), wf8(:,28), n3(:,48), t3x8(:,:,28))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,21), wf8(:,29), n3(:,49), t3x8(:,:,29))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,22), wf8(:,30), n3(:,50), t3x8(:,:,30))
  call vert_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,31), n3(:,51), t3x8(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf4(:,24), ex1(:), wf8(:,32), n3(:,52), t3x8(:,:,32))
  call counter_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,33), n3(:,53), t3x8(:,:,33))
  call counter_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,34), n3(:,54), t3x8(:,:,34))
  call counter_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,35), n3(:,55), t3x8(:,:,35))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,36), n3(:,56), t3x8(:,:,36))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,5), wf8(:,37), n3(:,57), t3x8(:,:,37))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,25), n3(:,58), t3x4(:,:,21))
  call prop_A_Q(ntry, wf4(:,25), 24, MB, 1_intkind1, wf4(:,26), n2(5))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), ex5(:), wf4(:,27), n3(:,59), t3x4(:,:,22))
  call prop_A_Q(ntry, wf4(:,27), 24, MB, 1_intkind1, wf4(:,28), n2(6))
  call counter_AQ_S(gH,ntry, ex4(:), wf4(:,11), wf8(:,38), n3(:,60), t3x8(:,:,38))
  call counter_AQ_S(gX,ntry, ex4(:), wf4(:,11), wf8(:,39), n3(:,61), t3x8(:,:,39))
  call counter_QA_V(ntry, wf4(:,11), ex4(:), wf8(:,40), n3(:,62), t3x8(:,:,40))
  call counter_QA_Z(gZd,ntry, wf4(:,11), ex4(:), wf8(:,41), n3(:,63), t3x8(:,:,41))
  call counter_QA_V_LR(EWctGbb,ntry, wf4(:,11), ex4(:), wf8(:,42), n3(:,64), t3x8(:,:,42))
  call counter_SA_Q(gH,ntry, wf4(:,15), ex3(:), wf8(:,43), n3(:,65), t3x8(:,:,43))
  call counter_SA_Q(gX,ntry, wf4(:,16), ex3(:), wf8(:,44), n3(:,66), t3x8(:,:,44))
  call counter_AV_Q(ntry, ex3(:), wf4(:,17), wf8(:,45), n3(:,67), t3x8(:,:,45))
  call counter_AZ_Q(gZd,ntry, ex3(:), wf4(:,18), wf8(:,46), n3(:,68), t3x8(:,:,46))
  call counter_AV_Q_LR(EWctGbb,ntry, ex3(:), wf4(:,17), wf8(:,47), n3(:,69), t3x8(:,:,47))
  call counter_AV_Q(ntry, ex3(:), ex5(:), wf4(:,29), n3(:,70), t3x4(:,:,23))
  call prop_A_Q(ntry, wf4(:,29), 20, MB, 1_intkind1, wf4(:,30), n2(7))
  call counter_AV_Q_LR(EWctAbb,ntry, ex3(:), ex5(:), wf4(:,31), n3(:,71), t3x4(:,:,24))
  call prop_A_Q(ntry, wf4(:,31), 20, MB, 1_intkind1, wf4(:,32), n2(8))
  call counter_AQ_S(gH,ntry, ex3(:), wf4(:,11), wf8(:,48), n3(:,72), t3x8(:,:,48))
  call counter_AQ_S(gX,ntry, ex3(:), wf4(:,11), wf8(:,49), n3(:,73), t3x8(:,:,49))
  call counter_QA_V(ntry, wf4(:,11), ex3(:), wf8(:,50), n3(:,74), t3x8(:,:,50))
  call counter_QA_Z(gZd,ntry, wf4(:,11), ex3(:), wf8(:,51), n3(:,75), t3x8(:,:,51))
  call counter_QA_V_LR(EWctGbb,ntry, wf4(:,11), ex3(:), wf8(:,52), n3(:,76), t3x8(:,:,52))
  call counter_QS_A(gH,ntry, ex2(:), wf4(:,1), wf8(:,53), n3(:,77), t3x8(:,:,53))
  call counter_QS_A(gX,ntry, ex2(:), wf4(:,4), wf8(:,54), n3(:,78), t3x8(:,:,54))
  call counter_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,55), n3(:,79), t3x8(:,:,55))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex2(:), wf8(:,56), n3(:,80), t3x8(:,:,56))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,5), ex2(:), wf8(:,57), n3(:,81), t3x8(:,:,57))
  call counter_VQ_A(ntry, ex5(:), ex2(:), wf4(:,33), n3(:,82), t3x4(:,:,25))
  call prop_Q_A(ntry, wf4(:,33), 18, MB, 1_intkind1, wf4(:,34), n2(9))
  call counter_VQ_A_LR(EWctAbb,ntry, ex5(:), ex2(:), wf4(:,35), n3(:,83), t3x4(:,:,26))
  call prop_Q_A(ntry, wf4(:,35), 18, MB, 1_intkind1, wf4(:,36), n2(10))
  call counter_QS_A(gH,ntry, ex2(:), wf4(:,15), wf8(:,58), n3(:,84), t3x8(:,:,58))
  call counter_QS_A(gX,ntry, ex2(:), wf4(:,16), wf8(:,59), n3(:,85), t3x8(:,:,59))
  call counter_VQ_A(ntry, wf4(:,17), ex2(:), wf8(:,60), n3(:,86), t3x8(:,:,60))
  call counter_ZQ_A(gZd,ntry, wf4(:,18), ex2(:), wf8(:,61), n3(:,87), t3x8(:,:,61))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,17), ex2(:), wf8(:,62), n3(:,88), t3x8(:,:,62))
  call counter_AQ_S(gH,ntry, ex4(:), ex2(:), wf4(:,37), n3(:,89), t3x4(:,:,27))
  call counter_AQ_S(gX,ntry, ex4(:), ex2(:), wf4(:,38), n3(:,90), t3x4(:,:,28))
  call counter_QA_V(ntry, ex2(:), ex4(:), wf4(:,39), n3(:,91), t3x4(:,:,29))
  call counter_QA_Z(gZd,ntry, ex2(:), ex4(:), wf4(:,40), n3(:,92), t3x4(:,:,30))
  call counter_QA_V_LR(EWctGbb,ntry, ex2(:), ex4(:), wf4(:,41), n3(:,93), t3x4(:,:,31))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,37), wf8(:,63), n3(:,94), t3x8(:,:,63))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,38), wf8(:,64), n3(:,95), t3x8(:,:,64))
  call vert_VQ_A(ntry, wf4(:,39), ex1(:), wf8(:,65), n3(:,96), t3x8(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf4(:,40), ex1(:), wf8(:,66), n3(:,97), t3x8(:,:,66))
  call vert_VQ_A(ntry, wf4(:,41), ex1(:), wf8(:,67), n3(:,98), t3x8(:,:,67))
  call counter_AQ_S(gH,ntry, ex3(:), ex2(:), wf4(:,42), n3(:,99), t3x4(:,:,32))
  call counter_AQ_S(gX,ntry, ex3(:), ex2(:), wf4(:,43), n3(:,100), t3x4(:,:,33))
  call counter_QA_V(ntry, ex2(:), ex3(:), wf4(:,44), n3(:,101), t3x4(:,:,34))
  call counter_QA_Z(gZd,ntry, ex2(:), ex3(:), wf4(:,45), n3(:,102), t3x4(:,:,35))
  call counter_QA_V_LR(EWctGbb,ntry, ex2(:), ex3(:), wf4(:,46), n3(:,103), t3x4(:,:,36))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,42), wf8(:,68), n3(:,104), t3x8(:,:,68))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,43), wf8(:,69), n3(:,105), t3x8(:,:,69))
  call vert_VQ_A(ntry, wf4(:,44), ex1(:), wf8(:,70), n3(:,106), t3x8(:,:,70))
  call vert_ZQ_A(gZd,ntry, wf4(:,45), ex1(:), wf8(:,71), n3(:,107), t3x8(:,:,71))
  call vert_VQ_A(ntry, wf4(:,46), ex1(:), wf8(:,72), n3(:,108), t3x8(:,:,72))
  call counter_QS_A(gH,ntry, ex1(:), wf4(:,10), wf8(:,73), n3(:,109), t3x8(:,:,73))
  call counter_QS_A(gX,ntry, ex1(:), wf4(:,12), wf8(:,74), n3(:,110), t3x8(:,:,74))
  call counter_VQ_A(ntry, wf4(:,13), ex1(:), wf8(:,75), n3(:,111), t3x8(:,:,75))
  call counter_ZQ_A(gZd,ntry, wf4(:,14), ex1(:), wf8(:,76), n3(:,112), t3x8(:,:,76))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,13), ex1(:), wf8(:,77), n3(:,113), t3x8(:,:,77))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,47), n3(:,114), t3x4(:,:,37))
  call prop_Q_A(ntry, wf4(:,47), 17, MB, 1_intkind1, wf4(:,48), n2(11))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,48), wf8(:,78), n3(:,115), t3x8(:,:,78))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,48), wf8(:,79), n3(:,116), t3x8(:,:,79))
  call vert_QA_V(ntry, wf4(:,48), ex4(:), wf8(:,80), n3(:,117), t3x8(:,:,80))
  call vert_QA_Z(gZd,ntry, wf4(:,48), ex4(:), wf8(:,81), n3(:,118), t3x8(:,:,81))
  call counter_VQ_A_LR(EWctAbb,ntry, ex5(:), ex1(:), wf4(:,49), n3(:,119), t3x4(:,:,38))
  call prop_Q_A(ntry, wf4(:,49), 17, MB, 1_intkind1, wf4(:,50), n2(12))
  call vert_QA_V(ntry, wf4(:,50), ex4(:), wf8(:,82), n3(:,120), t3x8(:,:,82))
  call counter_QS_A(gH,ntry, ex1(:), wf4(:,21), wf8(:,83), n3(:,121), t3x8(:,:,83))
  call counter_QS_A(gX,ntry, ex1(:), wf4(:,22), wf8(:,84), n3(:,122), t3x8(:,:,84))
  call counter_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,85), n3(:,123), t3x8(:,:,85))
  call counter_ZQ_A(gZd,ntry, wf4(:,24), ex1(:), wf8(:,86), n3(:,124), t3x8(:,:,86))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,23), ex1(:), wf8(:,87), n3(:,125), t3x8(:,:,87))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,48), wf8(:,88), n3(:,126), t3x8(:,:,88))
  call vert_AQ_S(gX,ntry, ex3(:), wf4(:,48), wf8(:,89), n3(:,127), t3x8(:,:,89))
  call vert_QA_V(ntry, wf4(:,48), ex3(:), wf8(:,90), n3(:,128), t3x8(:,:,90))
  call vert_QA_Z(gZd,ntry, wf4(:,48), ex3(:), wf8(:,91), n3(:,129), t3x8(:,:,91))
  call vert_QA_V(ntry, wf4(:,50), ex3(:), wf8(:,92), n3(:,130), t3x8(:,:,92))
  call counter_AQ_S(gH,ntry, ex4(:), ex1(:), wf4(:,51), n3(:,131), t3x4(:,:,39))
  call vert_SA_Q(gH,ntry, wf4(:,51), ex3(:), wf8(:,93), n3(:,132), t3x8(:,:,93))
  call counter_AQ_S(gX,ntry, ex4(:), ex1(:), wf4(:,52), n3(:,133), t3x4(:,:,40))
  call vert_SA_Q(gX,ntry, wf4(:,52), ex3(:), wf8(:,94), n3(:,134), t3x8(:,:,94))
  call counter_QA_V(ntry, ex1(:), ex4(:), wf4(:,53), n3(:,135), t3x4(:,:,41))
  call vert_AV_Q(ntry, ex3(:), wf4(:,53), wf8(:,95), n3(:,136), t3x8(:,:,95))
  call counter_QA_Z(gZd,ntry, ex1(:), ex4(:), wf4(:,54), n3(:,137), t3x4(:,:,42))
  call vert_AZ_Q(gZd,ntry, ex3(:), wf4(:,54), wf8(:,96), n3(:,138), t3x8(:,:,96))
  call counter_QA_V_LR(EWctGbb,ntry, ex1(:), ex4(:), wf4(:,55), n3(:,139), t3x4(:,:,43))
  call vert_AV_Q(ntry, ex3(:), wf4(:,55), wf8(:,97), n3(:,140), t3x8(:,:,97))
  call vert_QS_A(gH,ntry, ex2(:), wf4(:,51), wf8(:,98), n3(:,141), t3x8(:,:,98))
  call vert_QS_A(gX,ntry, ex2(:), wf4(:,52), wf8(:,99), n3(:,142), t3x8(:,:,99))
  call vert_VQ_A(ntry, wf4(:,53), ex2(:), wf8(:,100), n3(:,143), t3x8(:,:,100))
  call vert_ZQ_A(gZd,ntry, wf4(:,54), ex2(:), wf8(:,101), n3(:,144), t3x8(:,:,101))
  call vert_VQ_A(ntry, wf4(:,55), ex2(:), wf8(:,102), n3(:,145), t3x8(:,:,102))
  call counter_AQ_S(gH,ntry, ex3(:), ex1(:), wf4(:,56), n3(:,146), t3x4(:,:,44))
  call vert_SA_Q(gH,ntry, wf4(:,56), ex4(:), wf8(:,103), n3(:,147), t3x8(:,:,103))
  call counter_AQ_S(gX,ntry, ex3(:), ex1(:), wf4(:,57), n3(:,148), t3x4(:,:,45))
  call vert_SA_Q(gX,ntry, wf4(:,57), ex4(:), wf8(:,104), n3(:,149), t3x8(:,:,104))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,58), n3(:,150), t3x4(:,:,46))
  call vert_AV_Q(ntry, ex4(:), wf4(:,58), wf8(:,105), n3(:,151), t3x8(:,:,105))
  call counter_QA_Z(gZd,ntry, ex1(:), ex3(:), wf4(:,59), n3(:,152), t3x4(:,:,47))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,59), wf8(:,106), n3(:,153), t3x8(:,:,106))
  call counter_QA_V_LR(EWctGbb,ntry, ex1(:), ex3(:), wf4(:,60), n3(:,154), t3x4(:,:,48))
  call vert_AV_Q(ntry, ex4(:), wf4(:,60), wf8(:,107), n3(:,155), t3x8(:,:,107))
  call vert_QS_A(gH,ntry, ex2(:), wf4(:,56), wf8(:,108), n3(:,156), t3x8(:,:,108))
  call vert_QS_A(gX,ntry, ex2(:), wf4(:,57), wf8(:,109), n3(:,157), t3x8(:,:,109))
  call vert_VQ_A(ntry, wf4(:,58), ex2(:), wf8(:,110), n3(:,158), t3x8(:,:,110))
  call vert_ZQ_A(gZd,ntry, wf4(:,59), ex2(:), wf8(:,111), n3(:,159), t3x8(:,:,111))
  call vert_VQ_A(ntry, wf4(:,60), ex2(:), wf8(:,112), n3(:,160), t3x8(:,:,112))
  call vert_QA_V(ntry, wf4(:,3), ex4(:), wf8(:,113), n3(:,161), t3x8(:,:,113))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 5, wf4(:,61), n2(13))
  call counter_Q_A(ctbb,5,ntry, wf4(:,3), 18, wf4(:,62), n2(14))
  call prop_A_Q(ntry, wf8(:,1), 13, MB, 1_intkind1, wf8(:,114), n2(15))
  call prop_A_Q(ntry, wf8(:,2), 13, MB, 1_intkind1, wf8(:,115), n2(16))
  call prop_A_Q(ntry, wf8(:,3), 13, MB, 1_intkind1, wf8(:,116), n2(17))
  call prop_A_Q(ntry, wf8(:,4), 13, MB, 1_intkind1, wf8(:,117), n2(18))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,3), 18, wf4(:,63), n2(19))
  call vert_QA_V(ntry, ex2(:), wf4(:,8), wf8(:,118), n3(:,162), t3x8(:,:,114))
  call counter_A_Q(ctbb,5,ntry, wf4(:,8), 24, wf4(:,64), n2(20))
  call prop_Q_A(ntry, wf8(:,5), 7, MB, 1_intkind1, wf8(:,119), n2(21))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,120), n2(22))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,121), n2(23))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,122), n2(24))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,8), 24, wf4(:,65), n2(25))
  call vert_SA_Q(gH,ntry, wf4(:,10), ex4(:), wf8(:,123), n3(:,163), t3x8(:,:,115))
  call counter_Q_A(ctbb,5,ntry, wf4(:,11), 17, wf4(:,66), n2(26))
  call prop_A_Q(ntry, wf8(:,123), 14, MB, 1_intkind1, wf8(:,124), n2(27))
  call vert_SA_Q(gX,ntry, wf4(:,12), ex4(:), wf8(:,125), n3(:,164), t3x8(:,:,116))
  call prop_A_Q(ntry, wf8(:,125), 14, MB, 1_intkind1, wf8(:,126), n2(28))
  call vert_AV_Q(ntry, ex4(:), wf4(:,13), wf8(:,127), n3(:,165), t3x8(:,:,117))
  call prop_A_Q(ntry, wf8(:,127), 14, MB, 1_intkind1, wf8(:,128), n2(29))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,14), wf8(:,129), n3(:,166), t3x8(:,:,118))
  call prop_A_Q(ntry, wf8(:,129), 14, MB, 1_intkind1, wf8(:,130), n2(30))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,11), 17, wf4(:,67), n2(31))
  call counter_V_V(ctGG,21,ntry, wf4(:,13), 6, wf4(:,68), n2(32))
  call vert_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,131), n3(:,167), t3x8(:,:,119))
  call prop_Q_A(ntry, wf8(:,13), 7, MB, 1_intkind1, wf8(:,132), n2(33))
  call prop_Q_A(ntry, wf8(:,14), 7, MB, 1_intkind1, wf8(:,133), n2(34))
  call prop_Q_A(ntry, wf8(:,15), 7, MB, 1_intkind1, wf8(:,134), n2(35))
  call prop_Q_A(ntry, wf8(:,16), 7, MB, 1_intkind1, wf8(:,135), n2(36))
  call vert_QA_V(ntry, wf4(:,3), ex3(:), wf8(:,136), n3(:,168), t3x8(:,:,120))
  call counter_V_V(ctGG,21,ntry, wf4(:,17), 9, wf4(:,69), n2(37))
  call prop_A_Q(ntry, wf8(:,17), 13, MB, 1_intkind1, wf8(:,137), n2(38))
  call prop_A_Q(ntry, wf8(:,18), 13, MB, 1_intkind1, wf8(:,138), n2(39))
  call prop_A_Q(ntry, wf8(:,19), 13, MB, 1_intkind1, wf8(:,139), n2(40))
  call prop_A_Q(ntry, wf8(:,20), 13, MB, 1_intkind1, wf8(:,140), n2(41))
  call vert_QA_V(ntry, ex2(:), wf4(:,20), wf8(:,141), n3(:,169), t3x8(:,:,121))
  call counter_A_Q(ctbb,5,ntry, wf4(:,20), 20, wf4(:,70), n2(42))
  call prop_Q_A(ntry, wf8(:,21), 11, MB, 1_intkind1, wf8(:,142), n2(43))
  call prop_Q_A(ntry, wf8(:,22), 11, MB, 1_intkind1, wf8(:,143), n2(44))
  call prop_Q_A(ntry, wf8(:,23), 11, MB, 1_intkind1, wf8(:,144), n2(45))
  call prop_Q_A(ntry, wf8(:,24), 11, MB, 1_intkind1, wf8(:,145), n2(46))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,20), 20, wf4(:,71), n2(47))
  call vert_SA_Q(gH,ntry, wf4(:,21), ex3(:), wf8(:,146), n3(:,170), t3x8(:,:,122))
  call prop_A_Q(ntry, wf8(:,146), 14, MB, 1_intkind1, wf8(:,147), n2(48))
  call vert_SA_Q(gX,ntry, wf4(:,22), ex3(:), wf8(:,148), n3(:,171), t3x8(:,:,123))
  call prop_A_Q(ntry, wf8(:,148), 14, MB, 1_intkind1, wf8(:,149), n2(49))
  call vert_AV_Q(ntry, ex3(:), wf4(:,23), wf8(:,150), n3(:,172), t3x8(:,:,124))
  call prop_A_Q(ntry, wf8(:,150), 14, MB, 1_intkind1, wf8(:,151), n2(50))
  call vert_AZ_Q(gZd,ntry, ex3(:), wf4(:,24), wf8(:,152), n3(:,173), t3x8(:,:,125))
  call prop_A_Q(ntry, wf8(:,152), 14, MB, 1_intkind1, wf8(:,153), n2(51))
  call counter_V_V(ctGG,21,ntry, wf4(:,23), 10, wf4(:,72), n2(52))
  call vert_QA_V(ntry, ex1(:), wf4(:,20), wf8(:,154), n3(:,174), t3x8(:,:,126))
  call prop_Q_A(ntry, wf8(:,29), 11, MB, 1_intkind1, wf8(:,155), n2(53))
  call prop_Q_A(ntry, wf8(:,30), 11, MB, 1_intkind1, wf8(:,156), n2(54))
  call prop_Q_A(ntry, wf8(:,31), 11, MB, 1_intkind1, wf8(:,157), n2(55))
  call prop_Q_A(ntry, wf8(:,32), 11, MB, 1_intkind1, wf8(:,158), n2(56))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,3), wf8(:,159), n3(:,175), t3x8(:,:,127))
  call vert_AQ_S(gX,ntry, ex3(:), wf4(:,3), wf8(:,160), n3(:,176), t3x8(:,:,128))
  call vert_QA_Z(gZd,ntry, wf4(:,3), ex3(:), wf8(:,161), n3(:,177), t3x8(:,:,129))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,3), wf8(:,162), n3(:,178), t3x8(:,:,130))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,3), wf8(:,163), n3(:,179), t3x8(:,:,131))
  call vert_QA_Z(gZd,ntry, wf4(:,3), ex4(:), wf8(:,164), n3(:,180), t3x8(:,:,132))
  call vert_AQ_S(gH,ntry, wf4(:,20), ex1(:), wf8(:,165), n3(:,181), t3x8(:,:,133))
  call vert_AQ_S(gX,ntry, wf4(:,20), ex1(:), wf8(:,166), n3(:,182), t3x8(:,:,134))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,20), wf8(:,167), n3(:,183), t3x8(:,:,135))
  call vert_AQ_S(gH,ntry, wf4(:,20), ex2(:), wf8(:,168), n3(:,184), t3x8(:,:,136))
  call vert_AQ_S(gX,ntry, wf4(:,20), ex2(:), wf8(:,169), n3(:,185), t3x8(:,:,137))
  call vert_QA_Z(gZd,ntry, ex2(:), wf4(:,20), wf8(:,170), n3(:,186), t3x8(:,:,138))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex1(:), wf8(:,171), n3(:,187), t3x8(:,:,139))
  call vert_AQ_S(gX,ntry, wf4(:,8), ex1(:), wf8(:,172), n3(:,188), t3x8(:,:,140))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,8), wf8(:,173), n3(:,189), t3x8(:,:,141))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex2(:), wf8(:,174), n3(:,190), t3x8(:,:,142))
  call vert_AQ_S(gX,ntry, wf4(:,8), ex2(:), wf8(:,175), n3(:,191), t3x8(:,:,143))
  call vert_QA_Z(gZd,ntry, ex2(:), wf4(:,8), wf8(:,176), n3(:,192), t3x8(:,:,144))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppajj_ew_bbbxbxa_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if -1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,1), n3(:,193), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,2), A(:,2), n3(:,194), t3x32(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,3), A(:,3), n3(:,195), t3x32(:,:,3), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,4), A(:,4), n3(:,196), t3x32(:,:,4), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,3), A(:,5), n3(:,197), t3x32(:,:,5), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,5), A(:,6), n3(:,198), t3x32(:,:,6), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,6), A(:,7), n3(:,199), t3x32(:,:,7), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,7), A(:,8), n3(:,200), t3x32(:,:,8), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,8), A(:,9), n3(:,201), t3x32(:,:,9), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,7), A(:,10), n3(:,202), t3x32(:,:,10), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,10), wf8(:,9), A(:,11), n3(:,203), t3x32(:,:,11), nhel, den(14))
    call Hcont_SS(nsync, wf4(:,12), wf8(:,10), A(:,12), n3(:,204), t3x32(:,:,12), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,11), A(:,13), n3(:,205), t3x32(:,:,13), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,12), A(:,14), n3(:,206), t3x32(:,:,14), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,11), A(:,15), n3(:,207), t3x32(:,:,15), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,13), A(:,16), n3(:,208), t3x32(:,:,16), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,14), A(:,17), n3(:,209), t3x32(:,:,17), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,15), A(:,18), n3(:,210), t3x32(:,:,18), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,16), A(:,19), n3(:,211), t3x32(:,:,19), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,15), A(:,20), n3(:,212), t3x32(:,:,20), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,17), A(:,21), n3(:,213), t3x32(:,:,21), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,18), A(:,22), n3(:,214), t3x32(:,:,22), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,19), A(:,23), n3(:,215), t3x32(:,:,23), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,20), A(:,24), n3(:,216), t3x32(:,:,24), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,19), A(:,25), n3(:,217), t3x32(:,:,25), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,21), A(:,26), n3(:,218), t3x32(:,:,26), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,22), A(:,27), n3(:,219), t3x32(:,:,27), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,23), A(:,28), n3(:,220), t3x32(:,:,28), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,24), A(:,29), n3(:,221), t3x32(:,:,29), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,23), A(:,30), n3(:,222), t3x32(:,:,30), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,21), wf8(:,25), A(:,31), n3(:,223), t3x32(:,:,31), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,22), wf8(:,26), A(:,32), n3(:,224), t3x32(:,:,32), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,27), A(:,33), n3(:,225), t3x32(:,:,33), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,24), wf8(:,28), A(:,34), n3(:,226), t3x32(:,:,34), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,27), A(:,35), n3(:,227), t3x32(:,:,35), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,29), A(:,36), n3(:,228), t3x32(:,:,36), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,30), A(:,37), n3(:,229), t3x32(:,:,37), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,31), A(:,38), n3(:,230), t3x32(:,:,38), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,32), A(:,39), n3(:,231), t3x32(:,:,39), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,31), A(:,40), n3(:,232), t3x32(:,:,40), nhel, den(40))

    call Hcont_QA(nsync, wf4(:,3), wf8(:,33), A(:,41), n3(:,233), t3x32(:,:,41), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,34), A(:,42), n3(:,234), t3x32(:,:,42), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,35), A(:,43), n3(:,235), t3x32(:,:,43), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,36), A(:,44), n3(:,236), t3x32(:,:,44), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,35), A(:,45), n3(:,237), t3x32(:,:,45), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,37), A(:,46), n3(:,238), t3x32(:,:,46), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,26), A(:,47), n3(:,239), t3x32(:,:,47), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,26), A(:,48), n3(:,240), t3x32(:,:,48), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,26), A(:,49), n3(:,241), t3x32(:,:,49), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,26), A(:,50), n3(:,242), t3x32(:,:,50), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,26), A(:,51), n3(:,243), t3x32(:,:,51), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,28), A(:,52), n3(:,244), t3x32(:,:,52), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,10), wf8(:,38), A(:,53), n3(:,245), t3x32(:,:,53), nhel, den(14))
    call Hcont_SS(nsync, wf4(:,12), wf8(:,39), A(:,54), n3(:,246), t3x32(:,:,54), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,40), A(:,55), n3(:,247), t3x32(:,:,55), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,41), A(:,56), n3(:,248), t3x32(:,:,56), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,40), A(:,57), n3(:,249), t3x32(:,:,57), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,42), A(:,58), n3(:,250), t3x32(:,:,58), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,26), A(:,59), n3(:,251), t3x32(:,:,59), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,14), wf4(:,26), A(:,60), n3(:,252), t3x32(:,:,60), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,26), A(:,61), n3(:,253), t3x32(:,:,61), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,26), A(:,62), n3(:,254), t3x32(:,:,62), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,26), A(:,63), n3(:,255), t3x32(:,:,63), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,28), A(:,64), n3(:,256), t3x32(:,:,64), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,43), A(:,65), n3(:,257), t3x32(:,:,65), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,44), A(:,66), n3(:,258), t3x32(:,:,66), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,45), A(:,67), n3(:,259), t3x32(:,:,67), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,46), A(:,68), n3(:,260), t3x32(:,:,68), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,45), A(:,69), n3(:,261), t3x32(:,:,69), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,47), A(:,70), n3(:,262), t3x32(:,:,70), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,30), A(:,71), n3(:,263), t3x32(:,:,71), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,22), wf4(:,30), A(:,72), n3(:,264), t3x32(:,:,72), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,30), A(:,73), n3(:,265), t3x32(:,:,73), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,30), A(:,74), n3(:,266), t3x32(:,:,74), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,30), A(:,75), n3(:,267), t3x32(:,:,75), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,32), A(:,76), n3(:,268), t3x32(:,:,76), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,21), wf8(:,48), A(:,77), n3(:,269), t3x32(:,:,77), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,22), wf8(:,49), A(:,78), n3(:,270), t3x32(:,:,78), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,50), A(:,79), n3(:,271), t3x32(:,:,79), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,24), wf8(:,51), A(:,80), n3(:,272), t3x32(:,:,80), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,50), A(:,81), n3(:,273), t3x32(:,:,81), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,52), A(:,82), n3(:,274), t3x32(:,:,82), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,29), wf4(:,30), A(:,83), n3(:,275), t3x32(:,:,83), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,30), wf4(:,30), A(:,84), n3(:,276), t3x32(:,:,84), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,30), A(:,85), n3(:,277), t3x32(:,:,85), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,30), A(:,86), n3(:,278), t3x32(:,:,86), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,30), A(:,87), n3(:,279), t3x32(:,:,87), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,32), A(:,88), n3(:,280), t3x32(:,:,88), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,53), A(:,89), n3(:,281), t3x32(:,:,89), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,54), A(:,90), n3(:,282), t3x32(:,:,90), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,55), A(:,91), n3(:,283), t3x32(:,:,91), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,56), A(:,92), n3(:,284), t3x32(:,:,92), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,55), A(:,93), n3(:,285), t3x32(:,:,93), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,57), A(:,94), n3(:,286), t3x32(:,:,94), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,34), A(:,95), n3(:,287), t3x32(:,:,95), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,34), A(:,96), n3(:,288), t3x32(:,:,96), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,34), A(:,97), n3(:,289), t3x32(:,:,97), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,34), A(:,98), n3(:,290), t3x32(:,:,98), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,34), A(:,99), n3(:,291), t3x32(:,:,99), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,36), A(:,100), n3(:,292), t3x32(:,:,100), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,58), A(:,101), n3(:,293), t3x32(:,:,101), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,59), A(:,102), n3(:,294), t3x32(:,:,102), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,60), A(:,103), n3(:,295), t3x32(:,:,103), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,61), A(:,104), n3(:,296), t3x32(:,:,104), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,60), A(:,105), n3(:,297), t3x32(:,:,105), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,62), A(:,106), n3(:,298), t3x32(:,:,106), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,34), A(:,107), n3(:,299), t3x32(:,:,107), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,34), A(:,108), n3(:,300), t3x32(:,:,108), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,19), wf4(:,34), A(:,109), n3(:,301), t3x32(:,:,109), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,34), A(:,110), n3(:,302), t3x32(:,:,110), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,19), wf4(:,34), A(:,111), n3(:,303), t3x32(:,:,111), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,19), wf4(:,36), A(:,112), n3(:,304), t3x32(:,:,112), nhel, den(27))
    call Hcont_SS(nsync, wf8(:,25), wf4(:,37), A(:,113), n3(:,305), t3x32(:,:,113), nhel, den(33))
    call Hcont_SS(nsync, wf8(:,26), wf4(:,38), A(:,114), n3(:,306), t3x32(:,:,114), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,27), wf4(:,39), A(:,115), n3(:,307), t3x32(:,:,115), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,28), wf4(:,40), A(:,116), n3(:,308), t3x32(:,:,116), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,27), wf4(:,39), A(:,117), n3(:,309), t3x32(:,:,117), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,27), wf4(:,41), A(:,118), n3(:,310), t3x32(:,:,118), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,63), A(:,119), n3(:,311), t3x32(:,:,119), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,64), A(:,120), n3(:,312), t3x32(:,:,120), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,65), A(:,121), n3(:,313), t3x32(:,:,121), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,66), A(:,122), n3(:,314), t3x32(:,:,122), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,65), A(:,123), n3(:,315), t3x32(:,:,123), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,67), A(:,124), n3(:,316), t3x32(:,:,124), nhel, den(40))
    call Hcont_SS(nsync, wf8(:,9), wf4(:,42), A(:,125), n3(:,317), t3x32(:,:,125), nhel, den(14))
    call Hcont_SS(nsync, wf8(:,10), wf4(:,43), A(:,126), n3(:,318), t3x32(:,:,126), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,44), A(:,127), n3(:,319), t3x32(:,:,127), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,12), wf4(:,45), A(:,128), n3(:,320), t3x32(:,:,128), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,44), A(:,129), n3(:,321), t3x32(:,:,129), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,46), A(:,130), n3(:,322), t3x32(:,:,130), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,68), A(:,131), n3(:,323), t3x32(:,:,131), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,69), A(:,132), n3(:,324), t3x32(:,:,132), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,70), A(:,133), n3(:,325), t3x32(:,:,133), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,71), A(:,134), n3(:,326), t3x32(:,:,134), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,70), A(:,135), n3(:,327), t3x32(:,:,135), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,72), A(:,136), n3(:,328), t3x32(:,:,136), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,73), A(:,137), n3(:,329), t3x32(:,:,137), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,74), A(:,138), n3(:,330), t3x32(:,:,138), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,75), A(:,139), n3(:,331), t3x32(:,:,139), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,76), A(:,140), n3(:,332), t3x32(:,:,140), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,75), A(:,141), n3(:,333), t3x32(:,:,141), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,77), A(:,142), n3(:,334), t3x32(:,:,142), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,10), wf8(:,78), A(:,143), n3(:,335), t3x32(:,:,143), nhel, den(14))
    call Hcont_SS(nsync, wf4(:,12), wf8(:,79), A(:,144), n3(:,336), t3x32(:,:,144), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,80), A(:,145), n3(:,337), t3x32(:,:,145), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,81), A(:,146), n3(:,338), t3x32(:,:,146), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,80), A(:,147), n3(:,339), t3x32(:,:,147), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,82), A(:,148), n3(:,340), t3x32(:,:,148), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,83), A(:,149), n3(:,341), t3x32(:,:,149), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,84), A(:,150), n3(:,342), t3x32(:,:,150), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,85), A(:,151), n3(:,343), t3x32(:,:,151), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,86), A(:,152), n3(:,344), t3x32(:,:,152), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,85), A(:,153), n3(:,345), t3x32(:,:,153), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,87), A(:,154), n3(:,346), t3x32(:,:,154), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,21), wf8(:,88), A(:,155), n3(:,347), t3x32(:,:,155), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,22), wf8(:,89), A(:,156), n3(:,348), t3x32(:,:,156), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,90), A(:,157), n3(:,349), t3x32(:,:,157), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,24), wf8(:,91), A(:,158), n3(:,350), t3x32(:,:,158), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,90), A(:,159), n3(:,351), t3x32(:,:,159), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,92), A(:,160), n3(:,352), t3x32(:,:,160), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,93), A(:,161), n3(:,353), t3x32(:,:,161), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,94), A(:,162), n3(:,354), t3x32(:,:,162), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,95), A(:,163), n3(:,355), t3x32(:,:,163), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,96), A(:,164), n3(:,356), t3x32(:,:,164), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,95), A(:,165), n3(:,357), t3x32(:,:,165), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,97), A(:,166), n3(:,358), t3x32(:,:,166), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,98), A(:,167), n3(:,359), t3x32(:,:,167), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,99), A(:,168), n3(:,360), t3x32(:,:,168), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,100), A(:,169), n3(:,361), t3x32(:,:,169), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,101), A(:,170), n3(:,362), t3x32(:,:,170), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,100), A(:,171), n3(:,363), t3x32(:,:,171), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,102), A(:,172), n3(:,364), t3x32(:,:,172), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,103), A(:,173), n3(:,365), t3x32(:,:,173), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,104), A(:,174), n3(:,366), t3x32(:,:,174), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,105), A(:,175), n3(:,367), t3x32(:,:,175), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,106), A(:,176), n3(:,368), t3x32(:,:,176), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,105), A(:,177), n3(:,369), t3x32(:,:,177), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,107), A(:,178), n3(:,370), t3x32(:,:,178), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,108), A(:,179), n3(:,371), t3x32(:,:,179), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,109), A(:,180), n3(:,372), t3x32(:,:,180), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,110), A(:,181), n3(:,373), t3x32(:,:,181), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,111), A(:,182), n3(:,374), t3x32(:,:,182), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,110), A(:,183), n3(:,375), t3x32(:,:,183), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,112), A(:,184), n3(:,376), t3x32(:,:,184), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,113), wf4(:,61), A(:,185), n3(:,377), t3x32(:,:,185), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,114), A(:,186), n3(:,378), t3x32(:,:,186), nhel, den(46))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,115), A(:,187), n3(:,379), t3x32(:,:,187), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,116), A(:,188), n3(:,380), t3x32(:,:,188), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,117), A(:,189), n3(:,381), t3x32(:,:,189), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,116), A(:,190), n3(:,382), t3x32(:,:,190), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,116), wf4(:,63), A(:,191), n3(:,383), t3x32(:,:,191), nhel, den(50))
    call Hcont_VV(nsync, wf4(:,61), wf8(:,118), A(:,192), n3(:,384), t3x32(:,:,192), nhel, den(52))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,119), A(:,193), n3(:,385), t3x32(:,:,193), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,120), A(:,194), n3(:,386), t3x32(:,:,194), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,121), A(:,195), n3(:,387), t3x32(:,:,195), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,122), A(:,196), n3(:,388), t3x32(:,:,196), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,121), A(:,197), n3(:,389), t3x32(:,:,197), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,121), wf4(:,65), A(:,198), n3(:,390), t3x32(:,:,198), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,124), A(:,199), n3(:,391), t3x32(:,:,199), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,126), A(:,200), n3(:,392), t3x32(:,:,200), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,128), A(:,201), n3(:,393), t3x32(:,:,201), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,130), A(:,202), n3(:,394), t3x32(:,:,202), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,128), A(:,203), n3(:,395), t3x32(:,:,203), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,128), wf4(:,67), A(:,204), n3(:,396), t3x32(:,:,204), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,68), A(:,205), n3(:,397), t3x32(:,:,205), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,68), wf8(:,131), A(:,206), n3(:,398), t3x32(:,:,206), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,132), A(:,207), n3(:,399), t3x32(:,:,207), nhel, den(73))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,133), A(:,208), n3(:,400), t3x32(:,:,208), nhel, den(75))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,134), A(:,209), n3(:,401), t3x32(:,:,209), nhel, den(77))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,135), A(:,210), n3(:,402), t3x32(:,:,210), nhel, den(75))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,134), A(:,211), n3(:,403), t3x32(:,:,211), nhel, den(77))
    call Hcont_QA(nsync, wf4(:,65), wf8(:,134), A(:,212), n3(:,404), t3x32(:,:,212), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,136), wf4(:,69), A(:,213), n3(:,405), t3x32(:,:,213), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,137), A(:,214), n3(:,406), t3x32(:,:,214), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,138), A(:,215), n3(:,407), t3x32(:,:,215), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,139), A(:,216), n3(:,408), t3x32(:,:,216), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,140), A(:,217), n3(:,409), t3x32(:,:,217), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,62), wf8(:,139), A(:,218), n3(:,410), t3x32(:,:,218), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,63), wf8(:,139), A(:,219), n3(:,411), t3x32(:,:,219), nhel, den(86))
    call Hcont_VV(nsync, wf4(:,69), wf8(:,141), A(:,220), n3(:,412), t3x32(:,:,220), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,142), A(:,221), n3(:,413), t3x32(:,:,221), nhel, den(91))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,143), A(:,222), n3(:,414), t3x32(:,:,222), nhel, den(93))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,144), A(:,223), n3(:,415), t3x32(:,:,223), nhel, den(95))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,145), A(:,224), n3(:,416), t3x32(:,:,224), nhel, den(93))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,144), A(:,225), n3(:,417), t3x32(:,:,225), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,144), wf4(:,71), A(:,226), n3(:,418), t3x32(:,:,226), nhel, den(95))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,147), A(:,227), n3(:,419), t3x32(:,:,227), nhel, den(97))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,149), A(:,228), n3(:,420), t3x32(:,:,228), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,151), A(:,229), n3(:,421), t3x32(:,:,229), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,153), A(:,230), n3(:,422), t3x32(:,:,230), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,151), A(:,231), n3(:,423), t3x32(:,:,231), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,67), wf8(:,151), A(:,232), n3(:,424), t3x32(:,:,232), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,27), wf4(:,72), A(:,233), n3(:,425), t3x32(:,:,233), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,72), wf8(:,154), A(:,234), n3(:,426), t3x32(:,:,234), nhel, den(106))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,155), A(:,235), n3(:,427), t3x32(:,:,235), nhel, den(108))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,156), A(:,236), n3(:,428), t3x32(:,:,236), nhel, den(110))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,157), A(:,237), n3(:,429), t3x32(:,:,237), nhel, den(112))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,158), A(:,238), n3(:,430), t3x32(:,:,238), nhel, den(110))
    call Hcont_QA(nsync, wf4(:,70), wf8(:,157), A(:,239), n3(:,431), t3x32(:,:,239), nhel, den(112))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,157), A(:,240), n3(:,432), t3x32(:,:,240), nhel, den(112))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,32)
  integer :: empty(0), i

  M1(1)%j = (-A(j,13)%j-A(j,18)%j-A(j,23)%j-A(j,28)%j)*f(1)+(-A(j,14)%j-A(j,19)%j-A(j,24)%j-A(j,29)%j)*f(2)+(A(j,11)%j-A(j,12)%j &
       +A(j,16)%j-A(j,17)%j+A(j,21)%j-A(j,22)%j+A(j,26)%j-A(j,27)%j)*f(12)
  M1(2)%j = ((A(j,15)%j+A(j,20)%j+A(j,25)%j+A(j,30)%j)*f(3))/6._/**/REALKIND+((A(j,5)%j+A(j,10)%j+A(j,35)%j &
       +A(j,40)%j)*f(3))/2._/**/REALKIND
  M1(3)%j = (A(j,3)%j+A(j,8)%j+A(j,33)%j+A(j,38)%j)*f(1)+(A(j,4)%j+A(j,9)%j+A(j,34)%j+A(j,39)%j)*f(2)+(-A(j,1)%j+A(j,2)%j-A(j,6)%j &
       +A(j,7)%j-A(j,31)%j+A(j,32)%j-A(j,36)%j+A(j,37)%j)*f(12)
  M1(4)%j = ((-A(j,15)%j-A(j,20)%j-A(j,25)%j-A(j,30)%j)*f(3))/2._/**/REALKIND+((-A(j,5)%j-A(j,10)%j-A(j,35)%j &
       -A(j,40)%j)*f(3))/6._/**/REALKIND

  M2(1)%j = ((-A(j,203)%j-A(j,205)%j-A(j,206)%j-A(j,211)%j-A(j,213)%j-A(j,218)%j-A(j,220)%j-A(j,225)%j)*f(9))/6._/**/REALKIND+(( &
       -A(j,185)%j-A(j,190)%j-A(j,192)%j-A(j,197)%j-A(j,231)%j-A(j,233)%j-A(j,234)%j-A(j,239)%j)*f(9))/2._/**/REALKIND+((A(j,57)%j &
       +A(j,69)%j+A(j,105)%j+A(j,129)%j+A(j,135)%j+A(j,141)%j+A(j,165)%j+A(j,171)%j)*f(10))/6._/**/REALKIND+((A(j,45)%j+A(j,81)%j &
       +A(j,93)%j+A(j,117)%j+A(j,123)%j+A(j,153)%j+A(j,177)%j+A(j,183)%j)*f(10))/2._/**/REALKIND+((A(j,63)%j+A(j,75)%j+A(j,111)%j &
       +A(j,147)%j)*f(11))/6._/**/REALKIND+((A(j,51)%j+A(j,87)%j+A(j,99)%j+A(j,159)%j)*f(11))/2._/**/REALKIND
  M2(2)%j = (A(j,201)%j+A(j,209)%j+A(j,216)%j+A(j,223)%j)*f(4)+(A(j,202)%j+A(j,210)%j+A(j,217)%j+A(j,224)%j)*f(5)+((A(j,58)%j &
       +A(j,70)%j+A(j,106)%j+A(j,130)%j+A(j,136)%j+A(j,142)%j+A(j,166)%j+A(j,172)%j-A(j,204)%j-A(j,212)%j-A(j,219)%j &
       -A(j,226)%j)*f(5))/6._/**/REALKIND+((A(j,46)%j+A(j,82)%j+A(j,94)%j+A(j,118)%j+A(j,124)%j+A(j,154)%j+A(j,178)%j+A(j,184)%j &
       -A(j,191)%j-A(j,198)%j-A(j,232)%j-A(j,240)%j)*f(5))/2._/**/REALKIND+((A(j,64)%j+A(j,76)%j+A(j,112)%j &
       +A(j,148)%j)*f(6))/6._/**/REALKIND+((A(j,52)%j+A(j,88)%j+A(j,100)%j+A(j,160)%j)*f(6))/2._/**/REALKIND+(-A(j,55)%j-A(j,61)%j &
       -A(j,67)%j-A(j,73)%j-A(j,103)%j-A(j,109)%j-A(j,127)%j-A(j,133)%j-A(j,139)%j-A(j,145)%j-A(j,163)%j-A(j,169)%j)*f(7)+( &
       -A(j,56)%j-A(j,62)%j-A(j,68)%j-A(j,74)%j-A(j,104)%j-A(j,110)%j-A(j,128)%j-A(j,134)%j-A(j,140)%j-A(j,146)%j-A(j,164)%j &
       -A(j,170)%j)*f(8)+(-A(j,199)%j+A(j,200)%j-A(j,207)%j+A(j,208)%j-A(j,214)%j+A(j,215)%j-A(j,221)%j+A(j,222)%j)*f(13) &
       +(A(j,53)%j-A(j,54)%j+A(j,65)%j-A(j,66)%j+A(j,101)%j-A(j,102)%j+A(j,125)%j-A(j,126)%j+A(j,131)%j-A(j,132)%j+A(j,137)%j &
       -A(j,138)%j+A(j,161)%j-A(j,162)%j+A(j,167)%j-A(j,168)%j)*f(14)+(A(j,59)%j-A(j,60)%j+A(j,71)%j-A(j,72)%j+A(j,107)%j &
       -A(j,108)%j+A(j,143)%j-A(j,144)%j)*f(15)
  M2(3)%j = ((A(j,203)%j+A(j,205)%j+A(j,206)%j+A(j,211)%j+A(j,213)%j+A(j,218)%j+A(j,220)%j+A(j,225)%j)*f(9))/2._/**/REALKIND &
       +((A(j,185)%j+A(j,190)%j+A(j,192)%j+A(j,197)%j+A(j,231)%j+A(j,233)%j+A(j,234)%j+A(j,239)%j)*f(9))/6._/**/REALKIND+(( &
       -A(j,57)%j-A(j,69)%j-A(j,105)%j-A(j,129)%j-A(j,135)%j-A(j,141)%j-A(j,165)%j-A(j,171)%j)*f(10))/2._/**/REALKIND+((-A(j,45)%j &
       -A(j,81)%j-A(j,93)%j-A(j,117)%j-A(j,123)%j-A(j,153)%j-A(j,177)%j-A(j,183)%j)*f(10))/6._/**/REALKIND+((-A(j,63)%j-A(j,75)%j &
       -A(j,111)%j-A(j,147)%j)*f(11))/2._/**/REALKIND+((-A(j,51)%j-A(j,87)%j-A(j,99)%j-A(j,159)%j)*f(11))/6._/**/REALKIND
  M2(4)%j = (-A(j,188)%j-A(j,195)%j-A(j,229)%j-A(j,237)%j)*f(4)+((-A(j,58)%j-A(j,70)%j-A(j,106)%j-A(j,130)%j-A(j,136)%j-A(j,142)%j &
       -A(j,166)%j-A(j,172)%j+A(j,204)%j+A(j,212)%j+A(j,219)%j+A(j,226)%j)*f(5))/2._/**/REALKIND+(-A(j,189)%j-A(j,196)%j &
       -A(j,230)%j-A(j,238)%j)*f(5)+((-A(j,46)%j-A(j,82)%j-A(j,94)%j-A(j,118)%j-A(j,124)%j-A(j,154)%j-A(j,178)%j-A(j,184)%j &
       +A(j,191)%j+A(j,198)%j+A(j,232)%j+A(j,240)%j)*f(5))/6._/**/REALKIND+((-A(j,64)%j-A(j,76)%j-A(j,112)%j &
       -A(j,148)%j)*f(6))/2._/**/REALKIND+((-A(j,52)%j-A(j,88)%j-A(j,100)%j-A(j,160)%j)*f(6))/6._/**/REALKIND+(A(j,43)%j+A(j,49)%j &
       +A(j,79)%j+A(j,85)%j+A(j,91)%j+A(j,97)%j+A(j,115)%j+A(j,121)%j+A(j,151)%j+A(j,157)%j+A(j,175)%j+A(j,181)%j)*f(7)+(A(j,44)%j &
       +A(j,50)%j+A(j,80)%j+A(j,86)%j+A(j,92)%j+A(j,98)%j+A(j,116)%j+A(j,122)%j+A(j,152)%j+A(j,158)%j+A(j,176)%j+A(j,182)%j)*f(8) &
       +(A(j,186)%j-A(j,187)%j+A(j,193)%j-A(j,194)%j+A(j,227)%j-A(j,228)%j+A(j,235)%j-A(j,236)%j)*f(13)+(-A(j,41)%j+A(j,42)%j &
       -A(j,77)%j+A(j,78)%j-A(j,89)%j+A(j,90)%j-A(j,113)%j+A(j,114)%j-A(j,119)%j+A(j,120)%j-A(j,149)%j+A(j,150)%j-A(j,173)%j &
       +A(j,174)%j-A(j,179)%j+A(j,180)%j)*f(14)+(-A(j,47)%j+A(j,48)%j-A(j,83)%j+A(j,84)%j-A(j,95)%j+A(j,96)%j-A(j,155)%j &
       +A(j,156)%j)*f(15)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppajj_ew_bbbxbxa_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppajj_ew_bbbxbxa_1_/**/REALKIND
