
module ol_vamp_1_ppajj2_agggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppajj2_agggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppajj2_agggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppajj2_agggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppajj2_agggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(6)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,73) :: G0
  complex(REALKIND), dimension(4,5,4,342) :: G1
  complex(REALKIND), dimension(4,15,4,612) :: G2
  complex(REALKIND), dimension(4,35,4,360) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,162,32))
    allocate(G4tensorhel(70,108,32))
    allocate(G5tensorhel(126,72,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,19),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,30),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,0),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,20),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,30),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,0),G2(:,:,:,4))
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,21),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,30),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,0),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,36),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,30),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,0),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,10),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,14),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,30),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,18),ZERO,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,10),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,30),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,0),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-3),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,26),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,22),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-3),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,40),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,30),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,0),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,31),ZERO,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,13),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,22),ZERO,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,30),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,0),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,10),ZERO,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,13),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,30),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,0),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-4),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,26),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,14),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,42),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,30),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,0),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,31),ZERO,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,16),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,26),ZERO,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,30),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,0),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,6),ZERO,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,16),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,30),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,0),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,22),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-3),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-3),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,2),MT,G1(:,:,:,14))
  call loop_AV_Q(G1(:,:,:,14),wf(:,19),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,30),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,0),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,31),MT,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,14),wf(:,20),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,30),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,0),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,31),MT,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,14),wf(:,21),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,30),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,0),G2(:,:,:,36))
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,31),MT,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,14),wf(:,36),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,30),MT,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,0),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,31),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,14),wf(:,10),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,14),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,30),MT,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,0),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,31),MT,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-4),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,18),MT,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,10),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,30),MT,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,0),G3(:,:,:,28))
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,31),MT,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-3),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,26),MT,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,30),MT,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,31),MT,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,22),MT,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,30),MT,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,31),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,14),wf(:,40),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,30),MT,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,0),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,31),MT,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,14),wf(:,13),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,22),MT,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-3),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,30),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,0),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,31),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-3),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,10),MT,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,13),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,30),MT,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,0),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,31),MT,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,26),MT,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,30),MT,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,31),MT,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,14),MT,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,30),MT,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,31),MT,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,14),wf(:,42),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,30),MT,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,0),G2(:,:,:,54))
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,31),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,14),wf(:,16),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,26),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-2),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,30),MT,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,0),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,31),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-2),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,6),MT,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,16),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,30),MT,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,0),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,31),MT,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,22),MT,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-3),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,30),MT,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,31),MT,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-3),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,14),MT,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,30),MT,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,31),MT,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,2),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,19),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,30),ZERO,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,0),G2(:,:,:,62))
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,31),ZERO,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,27),wf(:,20),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,30),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,0),G2(:,:,:,64))
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,31),ZERO,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,27),wf(:,21),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,30),ZERO,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,0),G2(:,:,:,66))
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,31),ZERO,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,27),wf(:,36),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,30),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,0),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,31),ZERO,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,27),wf(:,10),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,14),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,30),ZERO,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50))
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,31),ZERO,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,18),ZERO,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,10),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,30),ZERO,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,0),G3(:,:,:,52))
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,31),ZERO,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,71),wf(:,-3),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,26),ZERO,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,30),ZERO,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,31),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,71),wf(:,-2),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,22),ZERO,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-3),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,30),ZERO,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,31),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,27),wf(:,40),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,30),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,0),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,31),ZERO,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,27),wf(:,13),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,22),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-3),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,30),ZERO,G3(:,:,:,57))
  call loop_QV_A(G3(:,:,:,57),wf(:,0),G3(:,:,:,58))
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,31),ZERO,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,27),wf(:,-3),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,10),ZERO,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,13),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,30),ZERO,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,0),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,31),ZERO,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,81))
  call loop_Q_A(G2(:,:,:,81),Q(:,26),ZERO,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,30),ZERO,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),ZERO,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,79),wf(:,-2),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,14),ZERO,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,30),ZERO,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),ZERO,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,27),wf(:,42),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,30),ZERO,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,0),G2(:,:,:,84))
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,31),ZERO,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,27),wf(:,16),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,26),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-2),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,30),ZERO,G3(:,:,:,65))
  call loop_QV_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66))
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,31),ZERO,G4tensor(:,17))
  call loop_QV_A(G1(:,:,:,27),wf(:,-2),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,6),ZERO,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,16),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,30),ZERO,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,0),G3(:,:,:,68))
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,31),ZERO,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,87),wf(:,-4),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,22),ZERO,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-3),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_QV_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,87),wf(:,-3),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,14),ZERO,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_QV_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,2),MT,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,19),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,30),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,0),G2(:,:,:,92))
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,31),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,40),wf(:,20),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,30),MT,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,0),G2(:,:,:,94))
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,31),MT,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,40),wf(:,21),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,30),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,0),G2(:,:,:,96))
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,31),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,40),wf(:,36),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,30),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,0),G2(:,:,:,98))
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,31),MT,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,40),wf(:,10),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,14),MT,G2(:,:,:,99))
  call loop_QV_A(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,30),MT,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,0),G3(:,:,:,74))
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,31),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,40),wf(:,-4),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,18),MT,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,10),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,30),MT,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,0),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,31),MT,G4tensor(:,20))
  call loop_QV_A(G2(:,:,:,101),wf(:,-3),G2(:,:,:,103))
  call loop_Q_A(G2(:,:,:,103),Q(:,26),MT,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,101),wf(:,-2),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,22),MT,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,40),wf(:,40),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,30),MT,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,0),G2(:,:,:,106))
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,31),MT,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,40),wf(:,13),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,22),MT,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-3),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,30),MT,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,0),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,31),MT,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,40),wf(:,-3),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,10),MT,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,13),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,30),MT,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,0),G3(:,:,:,84))
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,31),MT,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,109),wf(:,-4),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,26),MT,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,30),MT,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),MT,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,14),MT,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,30),MT,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),MT,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,40),wf(:,42),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,30),MT,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,0),G2(:,:,:,114))
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,31),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,40),wf(:,16),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,26),MT,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,30),MT,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,0),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,31),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,40),wf(:,-2),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,6),MT,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,16),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,30),MT,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,0),G3(:,:,:,92))
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,31),MT,G4tensor(:,24))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,22),MT,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,30),MT,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,117),wf(:,-3),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,14),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,30),MT,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),MT,G5tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,2),MB,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,19),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,30),MB,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,0),G2(:,:,:,122))
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,31),MB,G3tensor(:,25))
  call loop_AV_Q(G1(:,:,:,53),wf(:,20),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,30),MB,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,0),G2(:,:,:,124))
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,31),MB,G3tensor(:,26))
  call loop_AV_Q(G1(:,:,:,53),wf(:,21),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,30),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,0),G2(:,:,:,126))
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,31),MB,G3tensor(:,27))
  call loop_AV_Q(G1(:,:,:,53),wf(:,36),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,30),MB,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,0),G2(:,:,:,128))
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,31),MB,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,53),wf(:,10),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,14),MB,G2(:,:,:,129))
  call loop_AV_Q(G2(:,:,:,129),wf(:,-4),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,30),MB,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,0),G3(:,:,:,98))
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,31),MB,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-4),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,18),MB,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,10),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,30),MB,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,0),G3(:,:,:,100))
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,31),MB,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-3),G2(:,:,:,133))
  call loop_A_Q(G2(:,:,:,133),Q(:,26),MB,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-2),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,30),MB,G4(:,:,:,49))
  call loop_AV_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),MB,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-2),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,22),MB,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-3),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,30),MB,G4(:,:,:,51))
  call loop_AV_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),MB,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,53),wf(:,40),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,30),MB,G2(:,:,:,135))
  call loop_AV_Q(G2(:,:,:,135),wf(:,0),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,31),MB,G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,53),wf(:,13),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,22),MB,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-3),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,30),MB,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,0),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,31),MB,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-3),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,10),MB,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,13),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,30),MB,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,0),G3(:,:,:,108))
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,31),MB,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-4),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,26),MB,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,30),MB,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54))
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),MB,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-2),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,14),MB,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,30),MB,G4(:,:,:,55))
  call loop_AV_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56))
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),MB,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,53),wf(:,42),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,30),MB,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,0),G2(:,:,:,144))
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,31),MB,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,53),wf(:,16),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,26),MB,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-2),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,30),MB,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,0),G3(:,:,:,114))
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,31),MB,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-2),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,6),MB,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,16),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,30),MB,G3(:,:,:,115))
  call loop_AV_Q(G3(:,:,:,115),wf(:,0),G3(:,:,:,116))
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,31),MB,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-4),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,22),MB,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-3),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,30),MB,G4(:,:,:,57))
  call loop_AV_Q(G4(:,:,:,57),wf(:,0),G4(:,:,:,58))
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,31),MB,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-3),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,14),MB,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,30),MB,G4(:,:,:,59))
  call loop_AV_Q(G4(:,:,:,59),wf(:,0),G4(:,:,:,60))
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,31),MB,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,2),MB,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,19),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,30),MB,G2(:,:,:,151))
  call loop_QV_A(G2(:,:,:,151),wf(:,0),G2(:,:,:,152))
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,31),MB,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,66),wf(:,20),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,30),MB,G2(:,:,:,153))
  call loop_QV_A(G2(:,:,:,153),wf(:,0),G2(:,:,:,154))
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,31),MB,G3tensor(:,32))
  call loop_QV_A(G1(:,:,:,66),wf(:,21),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,30),MB,G2(:,:,:,155))
  call loop_QV_A(G2(:,:,:,155),wf(:,0),G2(:,:,:,156))
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,31),MB,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,66),wf(:,36),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,30),MB,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,0),G2(:,:,:,158))
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,31),MB,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,66),wf(:,10),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,14),MB,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,-4),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,30),MB,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,0),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,31),MB,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,66),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,18),MB,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,10),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,30),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,0),G3(:,:,:,124))
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,31),MB,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,161),wf(:,-3),G2(:,:,:,163))
  call loop_Q_A(G2(:,:,:,163),Q(:,26),MB,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-2),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,30),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),MB,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,161),wf(:,-2),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,22),MB,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-3),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,30),MB,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),MB,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,66),wf(:,40),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,30),MB,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,0),G2(:,:,:,166))
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,31),MB,G3tensor(:,35))
  call loop_QV_A(G1(:,:,:,66),wf(:,13),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,22),MB,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-3),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,30),MB,G3(:,:,:,129))
  call loop_QV_A(G3(:,:,:,129),wf(:,0),G3(:,:,:,130))
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,31),MB,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,66),wf(:,-3),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,10),MB,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,13),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,30),MB,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,0),G3(:,:,:,132))
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,31),MB,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,169),wf(:,-4),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,26),MB,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,-2),G3(:,:,:,134))
  call loop_Q_A(G3(:,:,:,134),Q(:,30),MB,G4(:,:,:,65))
  call loop_QV_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66))
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,31),MB,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,169),wf(:,-2),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,14),MB,G3(:,:,:,135))
  call loop_QV_A(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_Q_A(G3(:,:,:,136),Q(:,30),MB,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,31),MB,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,66),wf(:,42),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,30),MB,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,0),G2(:,:,:,174))
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,31),MB,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,66),wf(:,16),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,26),MB,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,30),MB,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,0),G3(:,:,:,138))
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,31),MB,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,66),wf(:,-2),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,6),MB,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,16),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,30),MB,G3(:,:,:,139))
  call loop_QV_A(G3(:,:,:,139),wf(:,0),G3(:,:,:,140))
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,31),MB,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,177),wf(:,-4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,22),MB,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,30),MB,G4(:,:,:,69))
  call loop_QV_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70))
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,31),MB,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,177),wf(:,-3),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,14),MB,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,30),MB,G4(:,:,:,71))
  call loop_QV_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72))
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,31),MB,G5tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,4),ZERO,G1(:,:,:,79))
  call loop_AV_Q(G1(:,:,:,79),wf(:,22),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,30),ZERO,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,0),G2(:,:,:,182))
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,31),ZERO,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,79),wf(:,23),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,30),ZERO,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,0),G2(:,:,:,184))
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,31),ZERO,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,79),wf(:,24),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,30),ZERO,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,0),G2(:,:,:,186))
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,31),ZERO,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,79),wf(:,34),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,30),ZERO,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,0),G2(:,:,:,188))
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,31),ZERO,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,79),wf(:,4),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,14),ZERO,G2(:,:,:,189))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-4),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,30),ZERO,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,0),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,31),ZERO,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-4),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,20),ZERO,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,4),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,30),ZERO,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,0),G3(:,:,:,148))
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,31),ZERO,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-1),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,22),ZERO,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-3),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_AV_Q(G1(:,:,:,79),wf(:,38),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,30),ZERO,G2(:,:,:,194))
  call loop_AV_Q(G2(:,:,:,194),wf(:,0),G2(:,:,:,195))
  call check_last_A_Q(l_switch,G2(:,:,:,195),Q(:,31),ZERO,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,79),wf(:,7),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,22),ZERO,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-3),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,30),ZERO,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,0),G3(:,:,:,152))
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,31),ZERO,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-3),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,12),ZERO,G2(:,:,:,198))
  call loop_AV_Q(G2(:,:,:,198),wf(:,7),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,30),ZERO,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,0),G3(:,:,:,154))
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,31),ZERO,G4tensor(:,40))
  call loop_AV_Q(G2(:,:,:,198),wf(:,-1),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,14),ZERO,G3(:,:,:,155))
  call loop_AV_Q(G3(:,:,:,155),wf(:,-4),G3(:,:,:,156))
  call loop_A_Q(G3(:,:,:,156),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,79),wf(:,41),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,30),ZERO,G2(:,:,:,201))
  call loop_AV_Q(G2(:,:,:,201),wf(:,0),G2(:,:,:,202))
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,31),ZERO,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-1),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,6),ZERO,G2(:,:,:,203))
  call loop_AV_Q(G2(:,:,:,203),wf(:,16),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,30),ZERO,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,0),G3(:,:,:,158))
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,31),ZERO,G4tensor(:,41))
  call loop_AV_Q(G2(:,:,:,203),wf(:,-4),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,22),ZERO,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-3),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,30),ZERO,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),ZERO,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,203),wf(:,-3),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,14),ZERO,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,-4),G3(:,:,:,162))
  call loop_A_Q(G3(:,:,:,162),Q(:,30),ZERO,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),ZERO,G5tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,22),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,30),MT,G2(:,:,:,207))
  call loop_AV_Q(G2(:,:,:,207),wf(:,0),G2(:,:,:,208))
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,31),MT,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,91),wf(:,23),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,30),MT,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,0),G2(:,:,:,210))
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,31),MT,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,91),wf(:,24),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,30),MT,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,0),G2(:,:,:,212))
  call check_last_A_Q(l_switch,G2(:,:,:,212),Q(:,31),MT,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,91),wf(:,34),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,30),MT,G2(:,:,:,213))
  call loop_AV_Q(G2(:,:,:,213),wf(:,0),G2(:,:,:,214))
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,31),MT,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,91),wf(:,4),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,14),MT,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-4),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,30),MT,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,0),G3(:,:,:,164))
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,31),MT,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-4),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,20),MT,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,4),G2(:,:,:,218))
  call loop_A_Q(G2(:,:,:,218),Q(:,30),MT,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,0),G3(:,:,:,166))
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,31),MT,G4tensor(:,43))
  call loop_AV_Q(G2(:,:,:,217),wf(:,-1),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,22),MT,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,-3),G3(:,:,:,168))
  call loop_A_Q(G3(:,:,:,168),Q(:,30),MT,G4(:,:,:,81))
  call loop_AV_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,31),MT,G5tensor(:,41))
  call loop_AV_Q(G1(:,:,:,91),wf(:,38),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,30),MT,G2(:,:,:,220))
  call loop_AV_Q(G2(:,:,:,220),wf(:,0),G2(:,:,:,221))
  call check_last_A_Q(l_switch,G2(:,:,:,221),Q(:,31),MT,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,91),wf(:,7),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,22),MT,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-3),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,30),MT,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170))
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,31),MT,G4tensor(:,44))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-3),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,12),MT,G2(:,:,:,224))
  call loop_AV_Q(G2(:,:,:,224),wf(:,7),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,30),MT,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,0),G3(:,:,:,172))
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,31),MT,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,224),wf(:,-1),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,14),MT,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-4),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,30),MT,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,31),MT,G5tensor(:,42))
  call loop_AV_Q(G1(:,:,:,91),wf(:,41),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,30),MT,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,0),G2(:,:,:,228))
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,31),MT,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-1),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,6),MT,G2(:,:,:,229))
  call loop_AV_Q(G2(:,:,:,229),wf(:,16),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,30),MT,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,0),G3(:,:,:,176))
  call check_last_A_Q(l_switch,G3(:,:,:,176),Q(:,31),MT,G4tensor(:,46))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-4),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,22),MT,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,-3),G3(:,:,:,178))
  call loop_A_Q(G3(:,:,:,178),Q(:,30),MT,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,31),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-3),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,14),MT,G3(:,:,:,179))
  call loop_AV_Q(G3(:,:,:,179),wf(:,-4),G3(:,:,:,180))
  call loop_A_Q(G3(:,:,:,180),Q(:,30),MT,G4(:,:,:,87))
  call loop_AV_Q(G4(:,:,:,87),wf(:,0),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,31),MT,G5tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,22),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,30),ZERO,G2(:,:,:,233))
  call loop_QV_A(G2(:,:,:,233),wf(:,0),G2(:,:,:,234))
  call check_last_Q_A(l_switch,G2(:,:,:,234),Q(:,31),ZERO,G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,103),wf(:,23),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,30),ZERO,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,0),G2(:,:,:,236))
  call check_last_Q_A(l_switch,G2(:,:,:,236),Q(:,31),ZERO,G3tensor(:,50))
  call loop_QV_A(G1(:,:,:,103),wf(:,24),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,30),ZERO,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,0),G2(:,:,:,238))
  call check_last_Q_A(l_switch,G2(:,:,:,238),Q(:,31),ZERO,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,103),wf(:,34),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,30),ZERO,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,0),G2(:,:,:,240))
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,31),ZERO,G3tensor(:,52))
  call loop_QV_A(G1(:,:,:,103),wf(:,4),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,14),ZERO,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-4),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,30),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,0),G3(:,:,:,182))
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,31),ZERO,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,103),wf(:,-4),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,20),ZERO,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,4),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,30),ZERO,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,0),G3(:,:,:,184))
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,31),ZERO,G4tensor(:,48))
  call loop_QV_A(G2(:,:,:,243),wf(:,-1),G2(:,:,:,245))
  call loop_Q_A(G2(:,:,:,245),Q(:,22),ZERO,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,-3),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,30),ZERO,G4(:,:,:,89))
  call loop_QV_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90))
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),ZERO,G5tensor(:,45))
  call loop_QV_A(G1(:,:,:,103),wf(:,38),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,30),ZERO,G2(:,:,:,246))
  call loop_QV_A(G2(:,:,:,246),wf(:,0),G2(:,:,:,247))
  call check_last_Q_A(l_switch,G2(:,:,:,247),Q(:,31),ZERO,G3tensor(:,53))
  call loop_QV_A(G1(:,:,:,103),wf(:,7),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,22),ZERO,G2(:,:,:,248))
  call loop_QV_A(G2(:,:,:,248),wf(:,-3),G2(:,:,:,249))
  call loop_Q_A(G2(:,:,:,249),Q(:,30),ZERO,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,0),G3(:,:,:,188))
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,31),ZERO,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,103),wf(:,-3),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,12),ZERO,G2(:,:,:,250))
  call loop_QV_A(G2(:,:,:,250),wf(:,7),G2(:,:,:,251))
  call loop_Q_A(G2(:,:,:,251),Q(:,30),ZERO,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,0),G3(:,:,:,190))
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,31),ZERO,G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,250),wf(:,-1),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,14),ZERO,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,30),ZERO,G4(:,:,:,91))
  call loop_QV_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92))
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),ZERO,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,103),wf(:,41),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,30),ZERO,G2(:,:,:,253))
  call loop_QV_A(G2(:,:,:,253),wf(:,0),G2(:,:,:,254))
  call check_last_Q_A(l_switch,G2(:,:,:,254),Q(:,31),ZERO,G3tensor(:,54))
  call loop_QV_A(G1(:,:,:,103),wf(:,-1),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,6),ZERO,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,16),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,30),ZERO,G3(:,:,:,193))
  call loop_QV_A(G3(:,:,:,193),wf(:,0),G3(:,:,:,194))
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,31),ZERO,G4tensor(:,51))
  call loop_QV_A(G2(:,:,:,255),wf(:,-4),G2(:,:,:,257))
  call loop_Q_A(G2(:,:,:,257),Q(:,22),ZERO,G3(:,:,:,195))
  call loop_QV_A(G3(:,:,:,195),wf(:,-3),G3(:,:,:,196))
  call loop_Q_A(G3(:,:,:,196),Q(:,30),ZERO,G4(:,:,:,93))
  call loop_QV_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94))
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),ZERO,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,255),wf(:,-3),G2(:,:,:,258))
  call loop_Q_A(G2(:,:,:,258),Q(:,14),ZERO,G3(:,:,:,197))
  call loop_QV_A(G3(:,:,:,197),wf(:,-4),G3(:,:,:,198))
  call loop_Q_A(G3(:,:,:,198),Q(:,30),ZERO,G4(:,:,:,95))
  call loop_QV_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96))
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),ZERO,G5tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,4),MT,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,22),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,30),MT,G2(:,:,:,259))
  call loop_QV_A(G2(:,:,:,259),wf(:,0),G2(:,:,:,260))
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,31),MT,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,115),wf(:,23),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,30),MT,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,0),G2(:,:,:,262))
  call check_last_Q_A(l_switch,G2(:,:,:,262),Q(:,31),MT,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,115),wf(:,24),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,30),MT,G2(:,:,:,263))
  call loop_QV_A(G2(:,:,:,263),wf(:,0),G2(:,:,:,264))
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,31),MT,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,115),wf(:,34),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,30),MT,G2(:,:,:,265))
  call loop_QV_A(G2(:,:,:,265),wf(:,0),G2(:,:,:,266))
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,31),MT,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,115),wf(:,4),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,14),MT,G2(:,:,:,267))
  call loop_QV_A(G2(:,:,:,267),wf(:,-4),G2(:,:,:,268))
  call loop_Q_A(G2(:,:,:,268),Q(:,30),MT,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,0),G3(:,:,:,200))
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,31),MT,G4tensor(:,52))
  call loop_QV_A(G1(:,:,:,115),wf(:,-4),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,20),MT,G2(:,:,:,269))
  call loop_QV_A(G2(:,:,:,269),wf(:,4),G2(:,:,:,270))
  call loop_Q_A(G2(:,:,:,270),Q(:,30),MT,G3(:,:,:,201))
  call loop_QV_A(G3(:,:,:,201),wf(:,0),G3(:,:,:,202))
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,31),MT,G4tensor(:,53))
  call loop_QV_A(G2(:,:,:,269),wf(:,-1),G2(:,:,:,271))
  call loop_Q_A(G2(:,:,:,271),Q(:,22),MT,G3(:,:,:,203))
  call loop_QV_A(G3(:,:,:,203),wf(:,-3),G3(:,:,:,204))
  call loop_Q_A(G3(:,:,:,204),Q(:,30),MT,G4(:,:,:,97))
  call loop_QV_A(G4(:,:,:,97),wf(:,0),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,31),MT,G5tensor(:,49))
  call loop_QV_A(G1(:,:,:,115),wf(:,38),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,30),MT,G2(:,:,:,272))
  call loop_QV_A(G2(:,:,:,272),wf(:,0),G2(:,:,:,273))
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,31),MT,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,115),wf(:,7),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,22),MT,G2(:,:,:,274))
  call loop_QV_A(G2(:,:,:,274),wf(:,-3),G2(:,:,:,275))
  call loop_Q_A(G2(:,:,:,275),Q(:,30),MT,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,0),G3(:,:,:,206))
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,31),MT,G4tensor(:,54))
  call loop_QV_A(G1(:,:,:,115),wf(:,-3),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,12),MT,G2(:,:,:,276))
  call loop_QV_A(G2(:,:,:,276),wf(:,7),G2(:,:,:,277))
  call loop_Q_A(G2(:,:,:,277),Q(:,30),MT,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,0),G3(:,:,:,208))
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,31),MT,G4tensor(:,55))
  call loop_QV_A(G2(:,:,:,276),wf(:,-1),G2(:,:,:,278))
  call loop_Q_A(G2(:,:,:,278),Q(:,14),MT,G3(:,:,:,209))
  call loop_QV_A(G3(:,:,:,209),wf(:,-4),G3(:,:,:,210))
  call loop_Q_A(G3(:,:,:,210),Q(:,30),MT,G4(:,:,:,99))
  call loop_QV_A(G4(:,:,:,99),wf(:,0),G4(:,:,:,100))
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,31),MT,G5tensor(:,50))
  call loop_QV_A(G1(:,:,:,115),wf(:,41),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,30),MT,G2(:,:,:,279))
  call loop_QV_A(G2(:,:,:,279),wf(:,0),G2(:,:,:,280))
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,31),MT,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,115),wf(:,-1),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,6),MT,G2(:,:,:,281))
  call loop_QV_A(G2(:,:,:,281),wf(:,16),G2(:,:,:,282))
  call loop_Q_A(G2(:,:,:,282),Q(:,30),MT,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,0),G3(:,:,:,212))
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,31),MT,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,281),wf(:,-4),G2(:,:,:,283))
  call loop_Q_A(G2(:,:,:,283),Q(:,22),MT,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-3),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,30),MT,G4(:,:,:,101))
  call loop_QV_A(G4(:,:,:,101),wf(:,0),G4(:,:,:,102))
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,31),MT,G5tensor(:,51))
  call loop_QV_A(G2(:,:,:,281),wf(:,-3),G2(:,:,:,284))
  call loop_Q_A(G2(:,:,:,284),Q(:,14),MT,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,30),MT,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,0),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,31),MT,G5tensor(:,52))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,4),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,22),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,30),MB,G2(:,:,:,285))
  call loop_AV_Q(G2(:,:,:,285),wf(:,0),G2(:,:,:,286))
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,31),MB,G3tensor(:,61))
  call loop_AV_Q(G1(:,:,:,127),wf(:,23),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,30),MB,G2(:,:,:,287))
  call loop_AV_Q(G2(:,:,:,287),wf(:,0),G2(:,:,:,288))
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,31),MB,G3tensor(:,62))
  call loop_AV_Q(G1(:,:,:,127),wf(:,24),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,30),MB,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,0),G2(:,:,:,290))
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,31),MB,G3tensor(:,63))
  call loop_AV_Q(G1(:,:,:,127),wf(:,34),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,30),MB,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,0),G2(:,:,:,292))
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,31),MB,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,127),wf(:,4),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,14),MB,G2(:,:,:,293))
  call loop_AV_Q(G2(:,:,:,293),wf(:,-4),G2(:,:,:,294))
  call loop_A_Q(G2(:,:,:,294),Q(:,30),MB,G3(:,:,:,217))
  call loop_AV_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218))
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,31),MB,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-4),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,20),MB,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,4),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,30),MB,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,0),G3(:,:,:,220))
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,31),MB,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-1),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,22),MB,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-3),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,30),MB,G4(:,:,:,105))
  call loop_AV_Q(G4(:,:,:,105),wf(:,0),G4(:,:,:,106))
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,31),MB,G5tensor(:,53))
  call loop_AV_Q(G1(:,:,:,127),wf(:,38),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,30),MB,G2(:,:,:,298))
  call loop_AV_Q(G2(:,:,:,298),wf(:,0),G2(:,:,:,299))
  call check_last_A_Q(l_switch,G2(:,:,:,299),Q(:,31),MB,G3tensor(:,65))
  call loop_AV_Q(G1(:,:,:,127),wf(:,7),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,22),MB,G2(:,:,:,300))
  call loop_AV_Q(G2(:,:,:,300),wf(:,-3),G2(:,:,:,301))
  call loop_A_Q(G2(:,:,:,301),Q(:,30),MB,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,0),G3(:,:,:,224))
  call check_last_A_Q(l_switch,G3(:,:,:,224),Q(:,31),MB,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-3),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,12),MB,G2(:,:,:,302))
  call loop_AV_Q(G2(:,:,:,302),wf(:,7),G2(:,:,:,303))
  call loop_A_Q(G2(:,:,:,303),Q(:,30),MB,G3(:,:,:,225))
  call loop_AV_Q(G3(:,:,:,225),wf(:,0),G3(:,:,:,226))
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,31),MB,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,302),wf(:,-1),G2(:,:,:,304))
  call loop_A_Q(G2(:,:,:,304),Q(:,14),MB,G3(:,:,:,227))
  call loop_AV_Q(G3(:,:,:,227),wf(:,-4),G3(:,:,:,228))
  call loop_A_Q(G3(:,:,:,228),Q(:,30),MB,G4(:,:,:,107))
  call loop_AV_Q(G4(:,:,:,107),wf(:,0),G4(:,:,:,108))
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,31),MB,G5tensor(:,54))
  call loop_AV_Q(G1(:,:,:,127),wf(:,41),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,30),MB,G2(:,:,:,305))
  call loop_AV_Q(G2(:,:,:,305),wf(:,0),G2(:,:,:,306))
  call check_last_A_Q(l_switch,G2(:,:,:,306),Q(:,31),MB,G3tensor(:,66))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-1),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,6),MB,G2(:,:,:,307))
  call loop_AV_Q(G2(:,:,:,307),wf(:,16),G2(:,:,:,308))
  call loop_A_Q(G2(:,:,:,308),Q(:,30),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,0),G3(:,:,:,230))
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,31),MB,G4tensor(:,61))
  call loop_AV_Q(G2(:,:,:,307),wf(:,-4),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,22),MB,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-3),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,30),MB,G4(:,:,:,109))
  call loop_AV_Q(G4(:,:,:,109),wf(:,0),G4(:,:,:,110))
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,31),MB,G5tensor(:,55))
  call loop_AV_Q(G2(:,:,:,307),wf(:,-3),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,14),MB,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,-4),G3(:,:,:,234))
  call loop_A_Q(G3(:,:,:,234),Q(:,30),MB,G4(:,:,:,111))
  call loop_AV_Q(G4(:,:,:,111),wf(:,0),G4(:,:,:,112))
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,31),MB,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,4),MB,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,22),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,30),MB,G2(:,:,:,311))
  call loop_QV_A(G2(:,:,:,311),wf(:,0),G2(:,:,:,312))
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,31),MB,G3tensor(:,67))
  call loop_QV_A(G1(:,:,:,139),wf(:,23),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,30),MB,G2(:,:,:,313))
  call loop_QV_A(G2(:,:,:,313),wf(:,0),G2(:,:,:,314))
  call check_last_Q_A(l_switch,G2(:,:,:,314),Q(:,31),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,139),wf(:,24),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,30),MB,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,0),G2(:,:,:,316))
  call check_last_Q_A(l_switch,G2(:,:,:,316),Q(:,31),MB,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,139),wf(:,34),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,30),MB,G2(:,:,:,317))
  call loop_QV_A(G2(:,:,:,317),wf(:,0),G2(:,:,:,318))
  call check_last_Q_A(l_switch,G2(:,:,:,318),Q(:,31),MB,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,139),wf(:,4),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,14),MB,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,-4),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,30),MB,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,0),G3(:,:,:,236))
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,31),MB,G4tensor(:,62))
  call loop_QV_A(G1(:,:,:,139),wf(:,-4),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,20),MB,G2(:,:,:,321))
  call loop_QV_A(G2(:,:,:,321),wf(:,4),G2(:,:,:,322))
  call loop_Q_A(G2(:,:,:,322),Q(:,30),MB,G3(:,:,:,237))
  call loop_QV_A(G3(:,:,:,237),wf(:,0),G3(:,:,:,238))
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,31),MB,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,321),wf(:,-1),G2(:,:,:,323))
  call loop_Q_A(G2(:,:,:,323),Q(:,22),MB,G3(:,:,:,239))
  call loop_QV_A(G3(:,:,:,239),wf(:,-3),G3(:,:,:,240))
  call loop_Q_A(G3(:,:,:,240),Q(:,30),MB,G4(:,:,:,113))
  call loop_QV_A(G4(:,:,:,113),wf(:,0),G4(:,:,:,114))
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,31),MB,G5tensor(:,57))
  call loop_QV_A(G1(:,:,:,139),wf(:,38),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,30),MB,G2(:,:,:,324))
  call loop_QV_A(G2(:,:,:,324),wf(:,0),G2(:,:,:,325))
  call check_last_Q_A(l_switch,G2(:,:,:,325),Q(:,31),MB,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,139),wf(:,7),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,22),MB,G2(:,:,:,326))
  call loop_QV_A(G2(:,:,:,326),wf(:,-3),G2(:,:,:,327))
  call loop_Q_A(G2(:,:,:,327),Q(:,30),MB,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,0),G3(:,:,:,242))
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,31),MB,G4tensor(:,64))
  call loop_QV_A(G1(:,:,:,139),wf(:,-3),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,12),MB,G2(:,:,:,328))
  call loop_QV_A(G2(:,:,:,328),wf(:,7),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,30),MB,G3(:,:,:,243))
  call loop_QV_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244))
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,31),MB,G4tensor(:,65))
  call loop_QV_A(G2(:,:,:,328),wf(:,-1),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,14),MB,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-4),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,30),MB,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,31),MB,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,139),wf(:,41),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,30),MB,G2(:,:,:,331))
  call loop_QV_A(G2(:,:,:,331),wf(:,0),G2(:,:,:,332))
  call check_last_Q_A(l_switch,G2(:,:,:,332),Q(:,31),MB,G3tensor(:,72))
  call loop_QV_A(G1(:,:,:,139),wf(:,-1),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,6),MB,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,16),G2(:,:,:,334))
  call loop_Q_A(G2(:,:,:,334),Q(:,30),MB,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,0),G3(:,:,:,248))
  call check_last_Q_A(l_switch,G3(:,:,:,248),Q(:,31),MB,G4tensor(:,66))
  call loop_QV_A(G2(:,:,:,333),wf(:,-4),G2(:,:,:,335))
  call loop_Q_A(G2(:,:,:,335),Q(:,22),MB,G3(:,:,:,249))
  call loop_QV_A(G3(:,:,:,249),wf(:,-3),G3(:,:,:,250))
  call loop_Q_A(G3(:,:,:,250),Q(:,30),MB,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,0),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,31),MB,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,333),wf(:,-3),G2(:,:,:,336))
  call loop_Q_A(G2(:,:,:,336),Q(:,14),MB,G3(:,:,:,251))
  call loop_QV_A(G3(:,:,:,251),wf(:,-4),G3(:,:,:,252))
  call loop_Q_A(G3(:,:,:,252),Q(:,30),MB,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,0),G4(:,:,:,120))
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,31),MB,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,8),ZERO,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,25),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,30),ZERO,G2(:,:,:,337))
  call loop_AV_Q(G2(:,:,:,337),wf(:,0),G2(:,:,:,338))
  call check_last_A_Q(l_switch,G2(:,:,:,338),Q(:,31),ZERO,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,151),wf(:,26),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,30),ZERO,G2(:,:,:,339))
  call loop_AV_Q(G2(:,:,:,339),wf(:,0),G2(:,:,:,340))
  call check_last_A_Q(l_switch,G2(:,:,:,340),Q(:,31),ZERO,G3tensor(:,74))
  call loop_AV_Q(G1(:,:,:,151),wf(:,27),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,30),ZERO,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,0),G2(:,:,:,342))
  call check_last_A_Q(l_switch,G2(:,:,:,342),Q(:,31),ZERO,G3tensor(:,75))
  call loop_AV_Q(G1(:,:,:,151),wf(:,32),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,30),ZERO,G2(:,:,:,343))
  call loop_AV_Q(G2(:,:,:,343),wf(:,0),G2(:,:,:,344))
  call check_last_A_Q(l_switch,G2(:,:,:,344),Q(:,31),ZERO,G3tensor(:,76))
  call loop_AV_Q(G1(:,:,:,151),wf(:,1),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,14),ZERO,G2(:,:,:,345))
  call loop_AV_Q(G2(:,:,:,345),wf(:,-4),G2(:,:,:,346))
  call loop_A_Q(G2(:,:,:,346),Q(:,30),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,0),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,31),ZERO,G4tensor(:,67))
  call loop_AV_Q(G1(:,:,:,151),wf(:,37),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,30),ZERO,G2(:,:,:,347))
  call loop_AV_Q(G2(:,:,:,347),wf(:,0),G2(:,:,:,348))
  call check_last_A_Q(l_switch,G2(:,:,:,348),Q(:,31),ZERO,G3tensor(:,77))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-2),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,12),ZERO,G2(:,:,:,349))
  call loop_AV_Q(G2(:,:,:,349),wf(:,7),G2(:,:,:,350))
  call loop_A_Q(G2(:,:,:,350),Q(:,30),ZERO,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,0),G3(:,:,:,256))
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,31),ZERO,G4tensor(:,68))
  call loop_AV_Q(G2(:,:,:,349),wf(:,-1),G2(:,:,:,351))
  call loop_A_Q(G2(:,:,:,351),Q(:,14),ZERO,G3(:,:,:,257))
  call loop_AV_Q(G3(:,:,:,257),wf(:,-4),G3(:,:,:,258))
  call loop_A_Q(G3(:,:,:,258),Q(:,30),ZERO,G4(:,:,:,121))
  call loop_AV_Q(G4(:,:,:,121),wf(:,0),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,31),ZERO,G5tensor(:,61))
  call loop_AV_Q(G1(:,:,:,151),wf(:,39),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,30),ZERO,G2(:,:,:,352))
  call loop_AV_Q(G2(:,:,:,352),wf(:,0),G2(:,:,:,353))
  call check_last_A_Q(l_switch,G2(:,:,:,353),Q(:,31),ZERO,G3tensor(:,78))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-1),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,10),ZERO,G2(:,:,:,354))
  call loop_AV_Q(G2(:,:,:,354),wf(:,13),G2(:,:,:,355))
  call loop_A_Q(G2(:,:,:,355),Q(:,30),ZERO,G3(:,:,:,259))
  call loop_AV_Q(G3(:,:,:,259),wf(:,0),G3(:,:,:,260))
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,31),ZERO,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,354),wf(:,-2),G2(:,:,:,356))
  call loop_A_Q(G2(:,:,:,356),Q(:,14),ZERO,G3(:,:,:,261))
  call loop_AV_Q(G3(:,:,:,261),wf(:,-4),G3(:,:,:,262))
  call loop_A_Q(G3(:,:,:,262),Q(:,30),ZERO,G4(:,:,:,123))
  call loop_AV_Q(G4(:,:,:,123),wf(:,0),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,31),ZERO,G5tensor(:,62))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,8),MT,G1(:,:,:,161))
  call loop_AV_Q(G1(:,:,:,161),wf(:,25),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,30),MT,G2(:,:,:,357))
  call loop_AV_Q(G2(:,:,:,357),wf(:,0),G2(:,:,:,358))
  call check_last_A_Q(l_switch,G2(:,:,:,358),Q(:,31),MT,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,161),wf(:,26),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,30),MT,G2(:,:,:,359))
  call loop_AV_Q(G2(:,:,:,359),wf(:,0),G2(:,:,:,360))
  call check_last_A_Q(l_switch,G2(:,:,:,360),Q(:,31),MT,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,161),wf(:,27),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,30),MT,G2(:,:,:,361))
  call loop_AV_Q(G2(:,:,:,361),wf(:,0),G2(:,:,:,362))
  call check_last_A_Q(l_switch,G2(:,:,:,362),Q(:,31),MT,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,161),wf(:,32),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,30),MT,G2(:,:,:,363))
  call loop_AV_Q(G2(:,:,:,363),wf(:,0),G2(:,:,:,364))
  call check_last_A_Q(l_switch,G2(:,:,:,364),Q(:,31),MT,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,161),wf(:,1),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,14),MT,G2(:,:,:,365))
  call loop_AV_Q(G2(:,:,:,365),wf(:,-4),G2(:,:,:,366))
  call loop_A_Q(G2(:,:,:,366),Q(:,30),MT,G3(:,:,:,263))
  call loop_AV_Q(G3(:,:,:,263),wf(:,0),G3(:,:,:,264))
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,31),MT,G4tensor(:,70))
  call loop_AV_Q(G1(:,:,:,161),wf(:,37),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,30),MT,G2(:,:,:,367))
  call loop_AV_Q(G2(:,:,:,367),wf(:,0),G2(:,:,:,368))
  call check_last_A_Q(l_switch,G2(:,:,:,368),Q(:,31),MT,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,161),wf(:,-2),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,12),MT,G2(:,:,:,369))
  call loop_AV_Q(G2(:,:,:,369),wf(:,7),G2(:,:,:,370))
  call loop_A_Q(G2(:,:,:,370),Q(:,30),MT,G3(:,:,:,265))
  call loop_AV_Q(G3(:,:,:,265),wf(:,0),G3(:,:,:,266))
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,31),MT,G4tensor(:,71))
  call loop_AV_Q(G2(:,:,:,369),wf(:,-1),G2(:,:,:,371))
  call loop_A_Q(G2(:,:,:,371),Q(:,14),MT,G3(:,:,:,267))
  call loop_AV_Q(G3(:,:,:,267),wf(:,-4),G3(:,:,:,268))
  call loop_A_Q(G3(:,:,:,268),Q(:,30),MT,G4(:,:,:,125))
  call loop_AV_Q(G4(:,:,:,125),wf(:,0),G4(:,:,:,126))
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,31),MT,G5tensor(:,63))
  call loop_AV_Q(G1(:,:,:,161),wf(:,39),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,30),MT,G2(:,:,:,372))
  call loop_AV_Q(G2(:,:,:,372),wf(:,0),G2(:,:,:,373))
  call check_last_A_Q(l_switch,G2(:,:,:,373),Q(:,31),MT,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,161),wf(:,-1),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,10),MT,G2(:,:,:,374))
  call loop_AV_Q(G2(:,:,:,374),wf(:,13),G2(:,:,:,375))
  call loop_A_Q(G2(:,:,:,375),Q(:,30),MT,G3(:,:,:,269))
  call loop_AV_Q(G3(:,:,:,269),wf(:,0),G3(:,:,:,270))
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,31),MT,G4tensor(:,72))
  call loop_AV_Q(G2(:,:,:,374),wf(:,-2),G2(:,:,:,376))
  call loop_A_Q(G2(:,:,:,376),Q(:,14),MT,G3(:,:,:,271))
  call loop_AV_Q(G3(:,:,:,271),wf(:,-4),G3(:,:,:,272))
  call loop_A_Q(G3(:,:,:,272),Q(:,30),MT,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,0),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,31),MT,G5tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,8),ZERO,G1(:,:,:,171))
  call loop_QV_A(G1(:,:,:,171),wf(:,25),G1(:,:,:,172))
  call loop_Q_A(G1(:,:,:,172),Q(:,30),ZERO,G2(:,:,:,377))
  call loop_QV_A(G2(:,:,:,377),wf(:,0),G2(:,:,:,378))
  call check_last_Q_A(l_switch,G2(:,:,:,378),Q(:,31),ZERO,G3tensor(:,85))
  call loop_QV_A(G1(:,:,:,171),wf(:,26),G1(:,:,:,173))
  call loop_Q_A(G1(:,:,:,173),Q(:,30),ZERO,G2(:,:,:,379))
  call loop_QV_A(G2(:,:,:,379),wf(:,0),G2(:,:,:,380))
  call check_last_Q_A(l_switch,G2(:,:,:,380),Q(:,31),ZERO,G3tensor(:,86))
  call loop_QV_A(G1(:,:,:,171),wf(:,27),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,30),ZERO,G2(:,:,:,381))
  call loop_QV_A(G2(:,:,:,381),wf(:,0),G2(:,:,:,382))
  call check_last_Q_A(l_switch,G2(:,:,:,382),Q(:,31),ZERO,G3tensor(:,87))
  call loop_QV_A(G1(:,:,:,171),wf(:,32),G1(:,:,:,175))
  call loop_Q_A(G1(:,:,:,175),Q(:,30),ZERO,G2(:,:,:,383))
  call loop_QV_A(G2(:,:,:,383),wf(:,0),G2(:,:,:,384))
  call check_last_Q_A(l_switch,G2(:,:,:,384),Q(:,31),ZERO,G3tensor(:,88))
  call loop_QV_A(G1(:,:,:,171),wf(:,1),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,14),ZERO,G2(:,:,:,385))
  call loop_QV_A(G2(:,:,:,385),wf(:,-4),G2(:,:,:,386))
  call loop_Q_A(G2(:,:,:,386),Q(:,30),ZERO,G3(:,:,:,273))
  call loop_QV_A(G3(:,:,:,273),wf(:,0),G3(:,:,:,274))
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,31),ZERO,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,171),wf(:,37),G1(:,:,:,177))
  call loop_Q_A(G1(:,:,:,177),Q(:,30),ZERO,G2(:,:,:,387))
  call loop_QV_A(G2(:,:,:,387),wf(:,0),G2(:,:,:,388))
  call check_last_Q_A(l_switch,G2(:,:,:,388),Q(:,31),ZERO,G3tensor(:,89))
  call loop_QV_A(G1(:,:,:,171),wf(:,-2),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,12),ZERO,G2(:,:,:,389))
  call loop_QV_A(G2(:,:,:,389),wf(:,7),G2(:,:,:,390))
  call loop_Q_A(G2(:,:,:,390),Q(:,30),ZERO,G3(:,:,:,275))
  call loop_QV_A(G3(:,:,:,275),wf(:,0),G3(:,:,:,276))
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,31),ZERO,G4tensor(:,74))
  call loop_QV_A(G2(:,:,:,389),wf(:,-1),G2(:,:,:,391))
  call loop_Q_A(G2(:,:,:,391),Q(:,14),ZERO,G3(:,:,:,277))
  call loop_QV_A(G3(:,:,:,277),wf(:,-4),G3(:,:,:,278))
  call loop_Q_A(G3(:,:,:,278),Q(:,30),ZERO,G4(:,:,:,129))
  call loop_QV_A(G4(:,:,:,129),wf(:,0),G4(:,:,:,130))
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,31),ZERO,G5tensor(:,65))
  call loop_QV_A(G1(:,:,:,171),wf(:,39),G1(:,:,:,179))
  call loop_Q_A(G1(:,:,:,179),Q(:,30),ZERO,G2(:,:,:,392))
  call loop_QV_A(G2(:,:,:,392),wf(:,0),G2(:,:,:,393))
  call check_last_Q_A(l_switch,G2(:,:,:,393),Q(:,31),ZERO,G3tensor(:,90))
  call loop_QV_A(G1(:,:,:,171),wf(:,-1),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,10),ZERO,G2(:,:,:,394))
  call loop_QV_A(G2(:,:,:,394),wf(:,13),G2(:,:,:,395))
  call loop_Q_A(G2(:,:,:,395),Q(:,30),ZERO,G3(:,:,:,279))
  call loop_QV_A(G3(:,:,:,279),wf(:,0),G3(:,:,:,280))
  call check_last_Q_A(l_switch,G3(:,:,:,280),Q(:,31),ZERO,G4tensor(:,75))
  call loop_QV_A(G2(:,:,:,394),wf(:,-2),G2(:,:,:,396))
  call loop_Q_A(G2(:,:,:,396),Q(:,14),ZERO,G3(:,:,:,281))
  call loop_QV_A(G3(:,:,:,281),wf(:,-4),G3(:,:,:,282))
  call loop_Q_A(G3(:,:,:,282),Q(:,30),ZERO,G4(:,:,:,131))
  call loop_QV_A(G4(:,:,:,131),wf(:,0),G4(:,:,:,132))
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,31),ZERO,G5tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,8),MT,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,25),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,30),MT,G2(:,:,:,397))
  call loop_QV_A(G2(:,:,:,397),wf(:,0),G2(:,:,:,398))
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,31),MT,G3tensor(:,91))
  call loop_QV_A(G1(:,:,:,181),wf(:,26),G1(:,:,:,183))
  call loop_Q_A(G1(:,:,:,183),Q(:,30),MT,G2(:,:,:,399))
  call loop_QV_A(G2(:,:,:,399),wf(:,0),G2(:,:,:,400))
  call check_last_Q_A(l_switch,G2(:,:,:,400),Q(:,31),MT,G3tensor(:,92))
  call loop_QV_A(G1(:,:,:,181),wf(:,27),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,30),MT,G2(:,:,:,401))
  call loop_QV_A(G2(:,:,:,401),wf(:,0),G2(:,:,:,402))
  call check_last_Q_A(l_switch,G2(:,:,:,402),Q(:,31),MT,G3tensor(:,93))
  call loop_QV_A(G1(:,:,:,181),wf(:,32),G1(:,:,:,185))
  call loop_Q_A(G1(:,:,:,185),Q(:,30),MT,G2(:,:,:,403))
  call loop_QV_A(G2(:,:,:,403),wf(:,0),G2(:,:,:,404))
  call check_last_Q_A(l_switch,G2(:,:,:,404),Q(:,31),MT,G3tensor(:,94))
  call loop_QV_A(G1(:,:,:,181),wf(:,1),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,14),MT,G2(:,:,:,405))
  call loop_QV_A(G2(:,:,:,405),wf(:,-4),G2(:,:,:,406))
  call loop_Q_A(G2(:,:,:,406),Q(:,30),MT,G3(:,:,:,283))
  call loop_QV_A(G3(:,:,:,283),wf(:,0),G3(:,:,:,284))
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,31),MT,G4tensor(:,76))
  call loop_QV_A(G1(:,:,:,181),wf(:,37),G1(:,:,:,187))
  call loop_Q_A(G1(:,:,:,187),Q(:,30),MT,G2(:,:,:,407))
  call loop_QV_A(G2(:,:,:,407),wf(:,0),G2(:,:,:,408))
  call check_last_Q_A(l_switch,G2(:,:,:,408),Q(:,31),MT,G3tensor(:,95))
  call loop_QV_A(G1(:,:,:,181),wf(:,-2),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,12),MT,G2(:,:,:,409))
  call loop_QV_A(G2(:,:,:,409),wf(:,7),G2(:,:,:,410))
  call loop_Q_A(G2(:,:,:,410),Q(:,30),MT,G3(:,:,:,285))
  call loop_QV_A(G3(:,:,:,285),wf(:,0),G3(:,:,:,286))
  call check_last_Q_A(l_switch,G3(:,:,:,286),Q(:,31),MT,G4tensor(:,77))
  call loop_QV_A(G2(:,:,:,409),wf(:,-1),G2(:,:,:,411))
  call loop_Q_A(G2(:,:,:,411),Q(:,14),MT,G3(:,:,:,287))
  call loop_QV_A(G3(:,:,:,287),wf(:,-4),G3(:,:,:,288))
  call loop_Q_A(G3(:,:,:,288),Q(:,30),MT,G4(:,:,:,133))
  call loop_QV_A(G4(:,:,:,133),wf(:,0),G4(:,:,:,134))
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,31),MT,G5tensor(:,67))
  call loop_QV_A(G1(:,:,:,181),wf(:,39),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,30),MT,G2(:,:,:,412))
  call loop_QV_A(G2(:,:,:,412),wf(:,0),G2(:,:,:,413))
  call check_last_Q_A(l_switch,G2(:,:,:,413),Q(:,31),MT,G3tensor(:,96))
  call loop_QV_A(G1(:,:,:,181),wf(:,-1),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,10),MT,G2(:,:,:,414))
  call loop_QV_A(G2(:,:,:,414),wf(:,13),G2(:,:,:,415))
  call loop_Q_A(G2(:,:,:,415),Q(:,30),MT,G3(:,:,:,289))
  call loop_QV_A(G3(:,:,:,289),wf(:,0),G3(:,:,:,290))
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,31),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,414),wf(:,-2),G2(:,:,:,416))
  call loop_Q_A(G2(:,:,:,416),Q(:,14),MT,G3(:,:,:,291))
  call loop_QV_A(G3(:,:,:,291),wf(:,-4),G3(:,:,:,292))
  call loop_Q_A(G3(:,:,:,292),Q(:,30),MT,G4(:,:,:,135))
  call loop_QV_A(G4(:,:,:,135),wf(:,0),G4(:,:,:,136))
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,31),MT,G5tensor(:,68))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,8),MB,G1(:,:,:,191))
  call loop_AV_Q(G1(:,:,:,191),wf(:,25),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,30),MB,G2(:,:,:,417))
  call loop_AV_Q(G2(:,:,:,417),wf(:,0),G2(:,:,:,418))
  call check_last_A_Q(l_switch,G2(:,:,:,418),Q(:,31),MB,G3tensor(:,97))
  call loop_AV_Q(G1(:,:,:,191),wf(:,26),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,30),MB,G2(:,:,:,419))
  call loop_AV_Q(G2(:,:,:,419),wf(:,0),G2(:,:,:,420))
  call check_last_A_Q(l_switch,G2(:,:,:,420),Q(:,31),MB,G3tensor(:,98))
  call loop_AV_Q(G1(:,:,:,191),wf(:,27),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,30),MB,G2(:,:,:,421))
  call loop_AV_Q(G2(:,:,:,421),wf(:,0),G2(:,:,:,422))
  call check_last_A_Q(l_switch,G2(:,:,:,422),Q(:,31),MB,G3tensor(:,99))
  call loop_AV_Q(G1(:,:,:,191),wf(:,32),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,30),MB,G2(:,:,:,423))
  call loop_AV_Q(G2(:,:,:,423),wf(:,0),G2(:,:,:,424))
  call check_last_A_Q(l_switch,G2(:,:,:,424),Q(:,31),MB,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,191),wf(:,1),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,14),MB,G2(:,:,:,425))
  call loop_AV_Q(G2(:,:,:,425),wf(:,-4),G2(:,:,:,426))
  call loop_A_Q(G2(:,:,:,426),Q(:,30),MB,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,0),G3(:,:,:,294))
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,31),MB,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,191),wf(:,37),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,30),MB,G2(:,:,:,427))
  call loop_AV_Q(G2(:,:,:,427),wf(:,0),G2(:,:,:,428))
  call check_last_A_Q(l_switch,G2(:,:,:,428),Q(:,31),MB,G3tensor(:,101))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-2),G1(:,:,:,198))
  call loop_A_Q(G1(:,:,:,198),Q(:,12),MB,G2(:,:,:,429))
  call loop_AV_Q(G2(:,:,:,429),wf(:,7),G2(:,:,:,430))
  call loop_A_Q(G2(:,:,:,430),Q(:,30),MB,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,0),G3(:,:,:,296))
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,31),MB,G4tensor(:,80))
  call loop_AV_Q(G2(:,:,:,429),wf(:,-1),G2(:,:,:,431))
  call loop_A_Q(G2(:,:,:,431),Q(:,14),MB,G3(:,:,:,297))
  call loop_AV_Q(G3(:,:,:,297),wf(:,-4),G3(:,:,:,298))
  call loop_A_Q(G3(:,:,:,298),Q(:,30),MB,G4(:,:,:,137))
  call loop_AV_Q(G4(:,:,:,137),wf(:,0),G4(:,:,:,138))
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,31),MB,G5tensor(:,69))
  call loop_AV_Q(G1(:,:,:,191),wf(:,39),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,30),MB,G2(:,:,:,432))
  call loop_AV_Q(G2(:,:,:,432),wf(:,0),G2(:,:,:,433))
  call check_last_A_Q(l_switch,G2(:,:,:,433),Q(:,31),MB,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-1),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,10),MB,G2(:,:,:,434))
  call loop_AV_Q(G2(:,:,:,434),wf(:,13),G2(:,:,:,435))
  call loop_A_Q(G2(:,:,:,435),Q(:,30),MB,G3(:,:,:,299))
  call loop_AV_Q(G3(:,:,:,299),wf(:,0),G3(:,:,:,300))
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,31),MB,G4tensor(:,81))
  call loop_AV_Q(G2(:,:,:,434),wf(:,-2),G2(:,:,:,436))
  call loop_A_Q(G2(:,:,:,436),Q(:,14),MB,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-4),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,30),MB,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,0),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,31),MB,G5tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,8),MB,G1(:,:,:,201))
  call loop_QV_A(G1(:,:,:,201),wf(:,25),G1(:,:,:,202))
  call loop_Q_A(G1(:,:,:,202),Q(:,30),MB,G2(:,:,:,437))
  call loop_QV_A(G2(:,:,:,437),wf(:,0),G2(:,:,:,438))
  call check_last_Q_A(l_switch,G2(:,:,:,438),Q(:,31),MB,G3tensor(:,103))
  call loop_QV_A(G1(:,:,:,201),wf(:,26),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,30),MB,G2(:,:,:,439))
  call loop_QV_A(G2(:,:,:,439),wf(:,0),G2(:,:,:,440))
  call check_last_Q_A(l_switch,G2(:,:,:,440),Q(:,31),MB,G3tensor(:,104))
  call loop_QV_A(G1(:,:,:,201),wf(:,27),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,30),MB,G2(:,:,:,441))
  call loop_QV_A(G2(:,:,:,441),wf(:,0),G2(:,:,:,442))
  call check_last_Q_A(l_switch,G2(:,:,:,442),Q(:,31),MB,G3tensor(:,105))
  call loop_QV_A(G1(:,:,:,201),wf(:,32),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,30),MB,G2(:,:,:,443))
  call loop_QV_A(G2(:,:,:,443),wf(:,0),G2(:,:,:,444))
  call check_last_Q_A(l_switch,G2(:,:,:,444),Q(:,31),MB,G3tensor(:,106))
  call loop_QV_A(G1(:,:,:,201),wf(:,1),G1(:,:,:,206))
  call loop_Q_A(G1(:,:,:,206),Q(:,14),MB,G2(:,:,:,445))
  call loop_QV_A(G2(:,:,:,445),wf(:,-4),G2(:,:,:,446))
  call loop_Q_A(G2(:,:,:,446),Q(:,30),MB,G3(:,:,:,303))
  call loop_QV_A(G3(:,:,:,303),wf(:,0),G3(:,:,:,304))
  call check_last_Q_A(l_switch,G3(:,:,:,304),Q(:,31),MB,G4tensor(:,82))
  call loop_QV_A(G1(:,:,:,201),wf(:,37),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,30),MB,G2(:,:,:,447))
  call loop_QV_A(G2(:,:,:,447),wf(:,0),G2(:,:,:,448))
  call check_last_Q_A(l_switch,G2(:,:,:,448),Q(:,31),MB,G3tensor(:,107))
  call loop_QV_A(G1(:,:,:,201),wf(:,-2),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,12),MB,G2(:,:,:,449))
  call loop_QV_A(G2(:,:,:,449),wf(:,7),G2(:,:,:,450))
  call loop_Q_A(G2(:,:,:,450),Q(:,30),MB,G3(:,:,:,305))
  call loop_QV_A(G3(:,:,:,305),wf(:,0),G3(:,:,:,306))
  call check_last_Q_A(l_switch,G3(:,:,:,306),Q(:,31),MB,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,449),wf(:,-1),G2(:,:,:,451))
  call loop_Q_A(G2(:,:,:,451),Q(:,14),MB,G3(:,:,:,307))
  call loop_QV_A(G3(:,:,:,307),wf(:,-4),G3(:,:,:,308))
  call loop_Q_A(G3(:,:,:,308),Q(:,30),MB,G4(:,:,:,141))
  call loop_QV_A(G4(:,:,:,141),wf(:,0),G4(:,:,:,142))
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,31),MB,G5tensor(:,71))
  call loop_QV_A(G1(:,:,:,201),wf(:,39),G1(:,:,:,209))
  call loop_Q_A(G1(:,:,:,209),Q(:,30),MB,G2(:,:,:,452))
  call loop_QV_A(G2(:,:,:,452),wf(:,0),G2(:,:,:,453))
  call check_last_Q_A(l_switch,G2(:,:,:,453),Q(:,31),MB,G3tensor(:,108))
  call loop_QV_A(G1(:,:,:,201),wf(:,-1),G1(:,:,:,210))
  call loop_Q_A(G1(:,:,:,210),Q(:,10),MB,G2(:,:,:,454))
  call loop_QV_A(G2(:,:,:,454),wf(:,13),G2(:,:,:,455))
  call loop_Q_A(G2(:,:,:,455),Q(:,30),MB,G3(:,:,:,309))
  call loop_QV_A(G3(:,:,:,309),wf(:,0),G3(:,:,:,310))
  call check_last_Q_A(l_switch,G3(:,:,:,310),Q(:,31),MB,G4tensor(:,84))
  call loop_QV_A(G2(:,:,:,454),wf(:,-2),G2(:,:,:,456))
  call loop_Q_A(G2(:,:,:,456),Q(:,14),MB,G3(:,:,:,311))
  call loop_QV_A(G3(:,:,:,311),wf(:,-4),G3(:,:,:,312))
  call loop_Q_A(G3(:,:,:,312),Q(:,30),MB,G4(:,:,:,143))
  call loop_QV_A(G4(:,:,:,143),wf(:,0),G4(:,:,:,144))
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,31),MB,G5tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,14),ZERO,G1(:,:,:,211))
  call loop_QV_A(G1(:,:,:,211),wf(:,-4),G1(:,:,:,212))
  call loop_Q_A(G1(:,:,:,212),Q(:,30),ZERO,G2(:,:,:,457))
  call loop_QV_A(G2(:,:,:,457),wf(:,0),G2(:,:,:,458))
  call check_last_Q_A(l_switch,G2(:,:,:,458),Q(:,31),ZERO,G3tensor(:,109))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,14),ZERO,G1(:,:,:,213))
  call loop_QV_A(G1(:,:,:,213),wf(:,-4),G1(:,:,:,214))
  call loop_Q_A(G1(:,:,:,214),Q(:,30),ZERO,G2(:,:,:,459))
  call loop_QV_A(G2(:,:,:,459),wf(:,0),G2(:,:,:,460))
  call check_last_Q_A(l_switch,G2(:,:,:,460),Q(:,31),ZERO,G3tensor(:,110))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,14),ZERO,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,-4),G1(:,:,:,216))
  call loop_Q_A(G1(:,:,:,216),Q(:,30),ZERO,G2(:,:,:,461))
  call loop_QV_A(G2(:,:,:,461),wf(:,0),G2(:,:,:,462))
  call check_last_Q_A(l_switch,G2(:,:,:,462),Q(:,31),ZERO,G3tensor(:,111))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,14),MT,G1(:,:,:,217))
  call loop_QV_A(G1(:,:,:,217),wf(:,-4),G1(:,:,:,218))
  call loop_Q_A(G1(:,:,:,218),Q(:,30),MT,G2(:,:,:,463))
  call loop_QV_A(G2(:,:,:,463),wf(:,0),G2(:,:,:,464))
  call check_last_Q_A(l_switch,G2(:,:,:,464),Q(:,31),MT,G3tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,14),MT,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,-4),G1(:,:,:,220))
  call loop_Q_A(G1(:,:,:,220),Q(:,30),MT,G2(:,:,:,465))
  call loop_QV_A(G2(:,:,:,465),wf(:,0),G2(:,:,:,466))
  call check_last_Q_A(l_switch,G2(:,:,:,466),Q(:,31),MT,G3tensor(:,113))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,14),MT,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,-4),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,30),MT,G2(:,:,:,467))
  call loop_QV_A(G2(:,:,:,467),wf(:,0),G2(:,:,:,468))
  call check_last_Q_A(l_switch,G2(:,:,:,468),Q(:,31),MT,G3tensor(:,114))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,14),ZERO,G1(:,:,:,223))
  call loop_AV_Q(G1(:,:,:,223),wf(:,-4),G1(:,:,:,224))
  call loop_A_Q(G1(:,:,:,224),Q(:,30),ZERO,G2(:,:,:,469))
  call loop_AV_Q(G2(:,:,:,469),wf(:,0),G2(:,:,:,470))
  call check_last_A_Q(l_switch,G2(:,:,:,470),Q(:,31),ZERO,G3tensor(:,115))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,14),ZERO,G1(:,:,:,225))
  call loop_AV_Q(G1(:,:,:,225),wf(:,-4),G1(:,:,:,226))
  call loop_A_Q(G1(:,:,:,226),Q(:,30),ZERO,G2(:,:,:,471))
  call loop_AV_Q(G2(:,:,:,471),wf(:,0),G2(:,:,:,472))
  call check_last_A_Q(l_switch,G2(:,:,:,472),Q(:,31),ZERO,G3tensor(:,116))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,14),ZERO,G1(:,:,:,227))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-4),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,30),ZERO,G2(:,:,:,473))
  call loop_AV_Q(G2(:,:,:,473),wf(:,0),G2(:,:,:,474))
  call check_last_A_Q(l_switch,G2(:,:,:,474),Q(:,31),ZERO,G3tensor(:,117))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,14),MT,G1(:,:,:,229))
  call loop_AV_Q(G1(:,:,:,229),wf(:,-4),G1(:,:,:,230))
  call loop_A_Q(G1(:,:,:,230),Q(:,30),MT,G2(:,:,:,475))
  call loop_AV_Q(G2(:,:,:,475),wf(:,0),G2(:,:,:,476))
  call check_last_A_Q(l_switch,G2(:,:,:,476),Q(:,31),MT,G3tensor(:,118))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,14),MT,G1(:,:,:,231))
  call loop_AV_Q(G1(:,:,:,231),wf(:,-4),G1(:,:,:,232))
  call loop_A_Q(G1(:,:,:,232),Q(:,30),MT,G2(:,:,:,477))
  call loop_AV_Q(G2(:,:,:,477),wf(:,0),G2(:,:,:,478))
  call check_last_A_Q(l_switch,G2(:,:,:,478),Q(:,31),MT,G3tensor(:,119))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,14),MT,G1(:,:,:,233))
  call loop_AV_Q(G1(:,:,:,233),wf(:,-4),G1(:,:,:,234))
  call loop_A_Q(G1(:,:,:,234),Q(:,30),MT,G2(:,:,:,479))
  call loop_AV_Q(G2(:,:,:,479),wf(:,0),G2(:,:,:,480))
  call check_last_A_Q(l_switch,G2(:,:,:,480),Q(:,31),MT,G3tensor(:,120))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,14),MB,G1(:,:,:,235))
  call loop_QV_A(G1(:,:,:,235),wf(:,-4),G1(:,:,:,236))
  call loop_Q_A(G1(:,:,:,236),Q(:,30),MB,G2(:,:,:,481))
  call loop_QV_A(G2(:,:,:,481),wf(:,0),G2(:,:,:,482))
  call check_last_Q_A(l_switch,G2(:,:,:,482),Q(:,31),MB,G3tensor(:,121))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,14),MB,G1(:,:,:,237))
  call loop_QV_A(G1(:,:,:,237),wf(:,-4),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,30),MB,G2(:,:,:,483))
  call loop_QV_A(G2(:,:,:,483),wf(:,0),G2(:,:,:,484))
  call check_last_Q_A(l_switch,G2(:,:,:,484),Q(:,31),MB,G3tensor(:,122))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,14),MB,G1(:,:,:,239))
  call loop_QV_A(G1(:,:,:,239),wf(:,-4),G1(:,:,:,240))
  call loop_Q_A(G1(:,:,:,240),Q(:,30),MB,G2(:,:,:,485))
  call loop_QV_A(G2(:,:,:,485),wf(:,0),G2(:,:,:,486))
  call check_last_Q_A(l_switch,G2(:,:,:,486),Q(:,31),MB,G3tensor(:,123))
  call loop_AV_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,14),MB,G1(:,:,:,241))
  call loop_AV_Q(G1(:,:,:,241),wf(:,-4),G1(:,:,:,242))
  call loop_A_Q(G1(:,:,:,242),Q(:,30),MB,G2(:,:,:,487))
  call loop_AV_Q(G2(:,:,:,487),wf(:,0),G2(:,:,:,488))
  call check_last_A_Q(l_switch,G2(:,:,:,488),Q(:,31),MB,G3tensor(:,124))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,14),MB,G1(:,:,:,243))
  call loop_AV_Q(G1(:,:,:,243),wf(:,-4),G1(:,:,:,244))
  call loop_A_Q(G1(:,:,:,244),Q(:,30),MB,G2(:,:,:,489))
  call loop_AV_Q(G2(:,:,:,489),wf(:,0),G2(:,:,:,490))
  call check_last_A_Q(l_switch,G2(:,:,:,490),Q(:,31),MB,G3tensor(:,125))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,14),MB,G1(:,:,:,245))
  call loop_AV_Q(G1(:,:,:,245),wf(:,-4),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,30),MB,G2(:,:,:,491))
  call loop_AV_Q(G2(:,:,:,491),wf(:,0),G2(:,:,:,492))
  call check_last_A_Q(l_switch,G2(:,:,:,492),Q(:,31),MB,G3tensor(:,126))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,6),ZERO,G1(:,:,:,247))
  call loop_AV_Q(G1(:,:,:,247),wf(:,16),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,30),ZERO,G2(:,:,:,493))
  call loop_AV_Q(G2(:,:,:,493),wf(:,0),G2(:,:,:,494))
  call check_last_A_Q(l_switch,G2(:,:,:,494),Q(:,31),ZERO,G3tensor(:,127))
  call loop_AV_Q(G1(:,:,:,247),wf(:,-4),G1(:,:,:,249))
  call loop_A_Q(G1(:,:,:,249),Q(:,22),ZERO,G2(:,:,:,495))
  call loop_AV_Q(G2(:,:,:,495),wf(:,-3),G2(:,:,:,496))
  call loop_A_Q(G2(:,:,:,496),Q(:,30),ZERO,G3(:,:,:,313))
  call loop_AV_Q(G3(:,:,:,313),wf(:,0),G3(:,:,:,314))
  call check_last_A_Q(l_switch,G3(:,:,:,314),Q(:,31),ZERO,G4tensor(:,85))
  call loop_AV_Q(G1(:,:,:,247),wf(:,-3),G1(:,:,:,250))
  call loop_A_Q(G1(:,:,:,250),Q(:,14),ZERO,G2(:,:,:,497))
  call loop_AV_Q(G2(:,:,:,497),wf(:,-4),G2(:,:,:,498))
  call loop_A_Q(G2(:,:,:,498),Q(:,30),ZERO,G3(:,:,:,315))
  call loop_AV_Q(G3(:,:,:,315),wf(:,0),G3(:,:,:,316))
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,31),ZERO,G4tensor(:,86))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,6),MT,G1(:,:,:,251))
  call loop_AV_Q(G1(:,:,:,251),wf(:,16),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,30),MT,G2(:,:,:,499))
  call loop_AV_Q(G2(:,:,:,499),wf(:,0),G2(:,:,:,500))
  call check_last_A_Q(l_switch,G2(:,:,:,500),Q(:,31),MT,G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,251),wf(:,-4),G1(:,:,:,253))
  call loop_A_Q(G1(:,:,:,253),Q(:,22),MT,G2(:,:,:,501))
  call loop_AV_Q(G2(:,:,:,501),wf(:,-3),G2(:,:,:,502))
  call loop_A_Q(G2(:,:,:,502),Q(:,30),MT,G3(:,:,:,317))
  call loop_AV_Q(G3(:,:,:,317),wf(:,0),G3(:,:,:,318))
  call check_last_A_Q(l_switch,G3(:,:,:,318),Q(:,31),MT,G4tensor(:,87))
  call loop_AV_Q(G1(:,:,:,251),wf(:,-3),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,14),MT,G2(:,:,:,503))
  call loop_AV_Q(G2(:,:,:,503),wf(:,-4),G2(:,:,:,504))
  call loop_A_Q(G2(:,:,:,504),Q(:,30),MT,G3(:,:,:,319))
  call loop_AV_Q(G3(:,:,:,319),wf(:,0),G3(:,:,:,320))
  call check_last_A_Q(l_switch,G3(:,:,:,320),Q(:,31),MT,G4tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,6),ZERO,G1(:,:,:,255))
  call loop_QV_A(G1(:,:,:,255),wf(:,16),G1(:,:,:,256))
  call loop_Q_A(G1(:,:,:,256),Q(:,30),ZERO,G2(:,:,:,505))
  call loop_QV_A(G2(:,:,:,505),wf(:,0),G2(:,:,:,506))
  call check_last_Q_A(l_switch,G2(:,:,:,506),Q(:,31),ZERO,G3tensor(:,129))
  call loop_QV_A(G1(:,:,:,255),wf(:,-4),G1(:,:,:,257))
  call loop_Q_A(G1(:,:,:,257),Q(:,22),ZERO,G2(:,:,:,507))
  call loop_QV_A(G2(:,:,:,507),wf(:,-3),G2(:,:,:,508))
  call loop_Q_A(G2(:,:,:,508),Q(:,30),ZERO,G3(:,:,:,321))
  call loop_QV_A(G3(:,:,:,321),wf(:,0),G3(:,:,:,322))
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,31),ZERO,G4tensor(:,89))
  call loop_QV_A(G1(:,:,:,255),wf(:,-3),G1(:,:,:,258))
  call loop_Q_A(G1(:,:,:,258),Q(:,14),ZERO,G2(:,:,:,509))
  call loop_QV_A(G2(:,:,:,509),wf(:,-4),G2(:,:,:,510))
  call loop_Q_A(G2(:,:,:,510),Q(:,30),ZERO,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,0),G3(:,:,:,324))
  call check_last_Q_A(l_switch,G3(:,:,:,324),Q(:,31),ZERO,G4tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,6),MT,G1(:,:,:,259))
  call loop_QV_A(G1(:,:,:,259),wf(:,16),G1(:,:,:,260))
  call loop_Q_A(G1(:,:,:,260),Q(:,30),MT,G2(:,:,:,511))
  call loop_QV_A(G2(:,:,:,511),wf(:,0),G2(:,:,:,512))
  call check_last_Q_A(l_switch,G2(:,:,:,512),Q(:,31),MT,G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,259),wf(:,-4),G1(:,:,:,261))
  call loop_Q_A(G1(:,:,:,261),Q(:,22),MT,G2(:,:,:,513))
  call loop_QV_A(G2(:,:,:,513),wf(:,-3),G2(:,:,:,514))
  call loop_Q_A(G2(:,:,:,514),Q(:,30),MT,G3(:,:,:,325))
  call loop_QV_A(G3(:,:,:,325),wf(:,0),G3(:,:,:,326))
  call check_last_Q_A(l_switch,G3(:,:,:,326),Q(:,31),MT,G4tensor(:,91))
  call loop_QV_A(G1(:,:,:,259),wf(:,-3),G1(:,:,:,262))
  call loop_Q_A(G1(:,:,:,262),Q(:,14),MT,G2(:,:,:,515))
  call loop_QV_A(G2(:,:,:,515),wf(:,-4),G2(:,:,:,516))
  call loop_Q_A(G2(:,:,:,516),Q(:,30),MT,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,0),G3(:,:,:,328))
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,31),MT,G4tensor(:,92))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,6),MB,G1(:,:,:,263))
  call loop_AV_Q(G1(:,:,:,263),wf(:,16),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,30),MB,G2(:,:,:,517))
  call loop_AV_Q(G2(:,:,:,517),wf(:,0),G2(:,:,:,518))
  call check_last_A_Q(l_switch,G2(:,:,:,518),Q(:,31),MB,G3tensor(:,131))
  call loop_AV_Q(G1(:,:,:,263),wf(:,-4),G1(:,:,:,265))
  call loop_A_Q(G1(:,:,:,265),Q(:,22),MB,G2(:,:,:,519))
  call loop_AV_Q(G2(:,:,:,519),wf(:,-3),G2(:,:,:,520))
  call loop_A_Q(G2(:,:,:,520),Q(:,30),MB,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,0),G3(:,:,:,330))
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,31),MB,G4tensor(:,93))
  call loop_AV_Q(G1(:,:,:,263),wf(:,-3),G1(:,:,:,266))
  call loop_A_Q(G1(:,:,:,266),Q(:,14),MB,G2(:,:,:,521))
  call loop_AV_Q(G2(:,:,:,521),wf(:,-4),G2(:,:,:,522))
  call loop_A_Q(G2(:,:,:,522),Q(:,30),MB,G3(:,:,:,331))
  call loop_AV_Q(G3(:,:,:,331),wf(:,0),G3(:,:,:,332))
  call check_last_A_Q(l_switch,G3(:,:,:,332),Q(:,31),MB,G4tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,6),MB,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,16),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,30),MB,G2(:,:,:,523))
  call loop_QV_A(G2(:,:,:,523),wf(:,0),G2(:,:,:,524))
  call check_last_Q_A(l_switch,G2(:,:,:,524),Q(:,31),MB,G3tensor(:,132))
  call loop_QV_A(G1(:,:,:,267),wf(:,-4),G1(:,:,:,269))
  call loop_Q_A(G1(:,:,:,269),Q(:,22),MB,G2(:,:,:,525))
  call loop_QV_A(G2(:,:,:,525),wf(:,-3),G2(:,:,:,526))
  call loop_Q_A(G2(:,:,:,526),Q(:,30),MB,G3(:,:,:,333))
  call loop_QV_A(G3(:,:,:,333),wf(:,0),G3(:,:,:,334))
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,31),MB,G4tensor(:,95))
  call loop_QV_A(G1(:,:,:,267),wf(:,-3),G1(:,:,:,270))
  call loop_Q_A(G1(:,:,:,270),Q(:,14),MB,G2(:,:,:,527))
  call loop_QV_A(G2(:,:,:,527),wf(:,-4),G2(:,:,:,528))
  call loop_Q_A(G2(:,:,:,528),Q(:,30),MB,G3(:,:,:,335))
  call loop_QV_A(G3(:,:,:,335),wf(:,0),G3(:,:,:,336))
  call check_last_Q_A(l_switch,G3(:,:,:,336),Q(:,31),MB,G4tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,14),ZERO,G1(:,:,:,271))
  call loop_QV_A(G1(:,:,:,271),wf(:,-4),G1(:,:,:,272))
  call loop_Q_A(G1(:,:,:,272),Q(:,30),ZERO,G2(:,:,:,529))
  call loop_QV_A(G2(:,:,:,529),wf(:,0),G2(:,:,:,530))
  call check_last_Q_A(l_switch,G2(:,:,:,530),Q(:,31),ZERO,G3tensor(:,133))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,14),MT,G1(:,:,:,273))
  call loop_QV_A(G1(:,:,:,273),wf(:,-4),G1(:,:,:,274))
  call loop_Q_A(G1(:,:,:,274),Q(:,30),MT,G2(:,:,:,531))
  call loop_QV_A(G2(:,:,:,531),wf(:,0),G2(:,:,:,532))
  call check_last_Q_A(l_switch,G2(:,:,:,532),Q(:,31),MT,G3tensor(:,134))
  call loop_AV_Q(G0(:,:,:,1),wf(:,31),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,14),ZERO,G1(:,:,:,275))
  call loop_AV_Q(G1(:,:,:,275),wf(:,-4),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,30),ZERO,G2(:,:,:,533))
  call loop_AV_Q(G2(:,:,:,533),wf(:,0),G2(:,:,:,534))
  call check_last_A_Q(l_switch,G2(:,:,:,534),Q(:,31),ZERO,G3tensor(:,135))
  call loop_AV_Q(G0(:,:,:,1),wf(:,31),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,14),MT,G1(:,:,:,277))
  call loop_AV_Q(G1(:,:,:,277),wf(:,-4),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,30),MT,G2(:,:,:,535))
  call loop_AV_Q(G2(:,:,:,535),wf(:,0),G2(:,:,:,536))
  call check_last_A_Q(l_switch,G2(:,:,:,536),Q(:,31),MT,G3tensor(:,136))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,14),MB,G1(:,:,:,279))
  call loop_QV_A(G1(:,:,:,279),wf(:,-4),G1(:,:,:,280))
  call loop_Q_A(G1(:,:,:,280),Q(:,30),MB,G2(:,:,:,537))
  call loop_QV_A(G2(:,:,:,537),wf(:,0),G2(:,:,:,538))
  call check_last_Q_A(l_switch,G2(:,:,:,538),Q(:,31),MB,G3tensor(:,137))
  call loop_AV_Q(G0(:,:,:,1),wf(:,31),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,14),MB,G1(:,:,:,281))
  call loop_AV_Q(G1(:,:,:,281),wf(:,-4),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,30),MB,G2(:,:,:,539))
  call loop_AV_Q(G2(:,:,:,539),wf(:,0),G2(:,:,:,540))
  call check_last_A_Q(l_switch,G2(:,:,:,540),Q(:,31),MB,G3tensor(:,138))
  call loop_AV_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,10),ZERO,G1(:,:,:,283))
  call loop_AV_Q(G1(:,:,:,283),wf(:,13),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,30),ZERO,G2(:,:,:,541))
  call loop_AV_Q(G2(:,:,:,541),wf(:,0),G2(:,:,:,542))
  call check_last_A_Q(l_switch,G2(:,:,:,542),Q(:,31),ZERO,G3tensor(:,139))
  call loop_AV_Q(G1(:,:,:,283),wf(:,-2),G1(:,:,:,285))
  call loop_A_Q(G1(:,:,:,285),Q(:,14),ZERO,G2(:,:,:,543))
  call loop_AV_Q(G2(:,:,:,543),wf(:,-4),G2(:,:,:,544))
  call loop_A_Q(G2(:,:,:,544),Q(:,30),ZERO,G3(:,:,:,337))
  call loop_AV_Q(G3(:,:,:,337),wf(:,0),G3(:,:,:,338))
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,31),ZERO,G4tensor(:,97))
  call loop_AV_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,10),MT,G1(:,:,:,286))
  call loop_AV_Q(G1(:,:,:,286),wf(:,13),G1(:,:,:,287))
  call loop_A_Q(G1(:,:,:,287),Q(:,30),MT,G2(:,:,:,545))
  call loop_AV_Q(G2(:,:,:,545),wf(:,0),G2(:,:,:,546))
  call check_last_A_Q(l_switch,G2(:,:,:,546),Q(:,31),MT,G3tensor(:,140))
  call loop_AV_Q(G1(:,:,:,286),wf(:,-2),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,14),MT,G2(:,:,:,547))
  call loop_AV_Q(G2(:,:,:,547),wf(:,-4),G2(:,:,:,548))
  call loop_A_Q(G2(:,:,:,548),Q(:,30),MT,G3(:,:,:,339))
  call loop_AV_Q(G3(:,:,:,339),wf(:,0),G3(:,:,:,340))
  call check_last_A_Q(l_switch,G3(:,:,:,340),Q(:,31),MT,G4tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,10),ZERO,G1(:,:,:,289))
  call loop_QV_A(G1(:,:,:,289),wf(:,13),G1(:,:,:,290))
  call loop_Q_A(G1(:,:,:,290),Q(:,30),ZERO,G2(:,:,:,549))
  call loop_QV_A(G2(:,:,:,549),wf(:,0),G2(:,:,:,550))
  call check_last_Q_A(l_switch,G2(:,:,:,550),Q(:,31),ZERO,G3tensor(:,141))
  call loop_QV_A(G1(:,:,:,289),wf(:,-2),G1(:,:,:,291))
  call loop_Q_A(G1(:,:,:,291),Q(:,14),ZERO,G2(:,:,:,551))
  call loop_QV_A(G2(:,:,:,551),wf(:,-4),G2(:,:,:,552))
  call loop_Q_A(G2(:,:,:,552),Q(:,30),ZERO,G3(:,:,:,341))
  call loop_QV_A(G3(:,:,:,341),wf(:,0),G3(:,:,:,342))
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,31),ZERO,G4tensor(:,99))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,10),MT,G1(:,:,:,292))
  call loop_QV_A(G1(:,:,:,292),wf(:,13),G1(:,:,:,293))
  call loop_Q_A(G1(:,:,:,293),Q(:,30),MT,G2(:,:,:,553))
  call loop_QV_A(G2(:,:,:,553),wf(:,0),G2(:,:,:,554))
  call check_last_Q_A(l_switch,G2(:,:,:,554),Q(:,31),MT,G3tensor(:,142))
  call loop_QV_A(G1(:,:,:,292),wf(:,-2),G1(:,:,:,294))
  call loop_Q_A(G1(:,:,:,294),Q(:,14),MT,G2(:,:,:,555))
  call loop_QV_A(G2(:,:,:,555),wf(:,-4),G2(:,:,:,556))
  call loop_Q_A(G2(:,:,:,556),Q(:,30),MT,G3(:,:,:,343))
  call loop_QV_A(G3(:,:,:,343),wf(:,0),G3(:,:,:,344))
  call check_last_Q_A(l_switch,G3(:,:,:,344),Q(:,31),MT,G4tensor(:,100))
  call loop_AV_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,10),MB,G1(:,:,:,295))
  call loop_AV_Q(G1(:,:,:,295),wf(:,13),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,30),MB,G2(:,:,:,557))
  call loop_AV_Q(G2(:,:,:,557),wf(:,0),G2(:,:,:,558))
  call check_last_A_Q(l_switch,G2(:,:,:,558),Q(:,31),MB,G3tensor(:,143))
  call loop_AV_Q(G1(:,:,:,295),wf(:,-2),G1(:,:,:,297))
  call loop_A_Q(G1(:,:,:,297),Q(:,14),MB,G2(:,:,:,559))
  call loop_AV_Q(G2(:,:,:,559),wf(:,-4),G2(:,:,:,560))
  call loop_A_Q(G2(:,:,:,560),Q(:,30),MB,G3(:,:,:,345))
  call loop_AV_Q(G3(:,:,:,345),wf(:,0),G3(:,:,:,346))
  call check_last_A_Q(l_switch,G3(:,:,:,346),Q(:,31),MB,G4tensor(:,101))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,10),MB,G1(:,:,:,298))
  call loop_QV_A(G1(:,:,:,298),wf(:,13),G1(:,:,:,299))
  call loop_Q_A(G1(:,:,:,299),Q(:,30),MB,G2(:,:,:,561))
  call loop_QV_A(G2(:,:,:,561),wf(:,0),G2(:,:,:,562))
  call check_last_Q_A(l_switch,G2(:,:,:,562),Q(:,31),MB,G3tensor(:,144))
  call loop_QV_A(G1(:,:,:,298),wf(:,-2),G1(:,:,:,300))
  call loop_Q_A(G1(:,:,:,300),Q(:,14),MB,G2(:,:,:,563))
  call loop_QV_A(G2(:,:,:,563),wf(:,-4),G2(:,:,:,564))
  call loop_Q_A(G2(:,:,:,564),Q(:,30),MB,G3(:,:,:,347))
  call loop_QV_A(G3(:,:,:,347),wf(:,0),G3(:,:,:,348))
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,31),MB,G4tensor(:,102))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,14),ZERO,G1(:,:,:,301))
  call loop_QV_A(G1(:,:,:,301),wf(:,-4),G1(:,:,:,302))
  call loop_Q_A(G1(:,:,:,302),Q(:,30),ZERO,G2(:,:,:,565))
  call loop_QV_A(G2(:,:,:,565),wf(:,0),G2(:,:,:,566))
  call check_last_Q_A(l_switch,G2(:,:,:,566),Q(:,31),ZERO,G3tensor(:,145))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,14),MT,G1(:,:,:,303))
  call loop_QV_A(G1(:,:,:,303),wf(:,-4),G1(:,:,:,304))
  call loop_Q_A(G1(:,:,:,304),Q(:,30),MT,G2(:,:,:,567))
  call loop_QV_A(G2(:,:,:,567),wf(:,0),G2(:,:,:,568))
  call check_last_Q_A(l_switch,G2(:,:,:,568),Q(:,31),MT,G3tensor(:,146))
  call loop_AV_Q(G0(:,:,:,1),wf(:,33),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,14),ZERO,G1(:,:,:,305))
  call loop_AV_Q(G1(:,:,:,305),wf(:,-4),G1(:,:,:,306))
  call loop_A_Q(G1(:,:,:,306),Q(:,30),ZERO,G2(:,:,:,569))
  call loop_AV_Q(G2(:,:,:,569),wf(:,0),G2(:,:,:,570))
  call check_last_A_Q(l_switch,G2(:,:,:,570),Q(:,31),ZERO,G3tensor(:,147))
  call loop_AV_Q(G0(:,:,:,1),wf(:,33),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,14),MT,G1(:,:,:,307))
  call loop_AV_Q(G1(:,:,:,307),wf(:,-4),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,30),MT,G2(:,:,:,571))
  call loop_AV_Q(G2(:,:,:,571),wf(:,0),G2(:,:,:,572))
  call check_last_A_Q(l_switch,G2(:,:,:,572),Q(:,31),MT,G3tensor(:,148))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,14),MB,G1(:,:,:,309))
  call loop_QV_A(G1(:,:,:,309),wf(:,-4),G1(:,:,:,310))
  call loop_Q_A(G1(:,:,:,310),Q(:,30),MB,G2(:,:,:,573))
  call loop_QV_A(G2(:,:,:,573),wf(:,0),G2(:,:,:,574))
  call check_last_Q_A(l_switch,G2(:,:,:,574),Q(:,31),MB,G3tensor(:,149))
  call loop_AV_Q(G0(:,:,:,1),wf(:,33),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,14),MB,G1(:,:,:,311))
  call loop_AV_Q(G1(:,:,:,311),wf(:,-4),G1(:,:,:,312))
  call loop_A_Q(G1(:,:,:,312),Q(:,30),MB,G2(:,:,:,575))
  call loop_AV_Q(G2(:,:,:,575),wf(:,0),G2(:,:,:,576))
  call check_last_A_Q(l_switch,G2(:,:,:,576),Q(:,31),MB,G3tensor(:,150))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,12),ZERO,G1(:,:,:,313))
  call loop_QV_A(G1(:,:,:,313),wf(:,7),G1(:,:,:,314))
  call loop_Q_A(G1(:,:,:,314),Q(:,30),ZERO,G2(:,:,:,577))
  call loop_QV_A(G2(:,:,:,577),wf(:,0),G2(:,:,:,578))
  call check_last_Q_A(l_switch,G2(:,:,:,578),Q(:,31),ZERO,G3tensor(:,151))
  call loop_QV_A(G1(:,:,:,313),wf(:,-1),G1(:,:,:,315))
  call loop_Q_A(G1(:,:,:,315),Q(:,14),ZERO,G2(:,:,:,579))
  call loop_QV_A(G2(:,:,:,579),wf(:,-4),G2(:,:,:,580))
  call loop_Q_A(G2(:,:,:,580),Q(:,30),ZERO,G3(:,:,:,349))
  call loop_QV_A(G3(:,:,:,349),wf(:,0),G3(:,:,:,350))
  call check_last_Q_A(l_switch,G3(:,:,:,350),Q(:,31),ZERO,G4tensor(:,103))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,12),MT,G1(:,:,:,316))
  call loop_QV_A(G1(:,:,:,316),wf(:,7),G1(:,:,:,317))
  call loop_Q_A(G1(:,:,:,317),Q(:,30),MT,G2(:,:,:,581))
  call loop_QV_A(G2(:,:,:,581),wf(:,0),G2(:,:,:,582))
  call check_last_Q_A(l_switch,G2(:,:,:,582),Q(:,31),MT,G3tensor(:,152))
  call loop_QV_A(G1(:,:,:,316),wf(:,-1),G1(:,:,:,318))
  call loop_Q_A(G1(:,:,:,318),Q(:,14),MT,G2(:,:,:,583))
  call loop_QV_A(G2(:,:,:,583),wf(:,-4),G2(:,:,:,584))
  call loop_Q_A(G2(:,:,:,584),Q(:,30),MT,G3(:,:,:,351))
  call loop_QV_A(G3(:,:,:,351),wf(:,0),G3(:,:,:,352))
  call check_last_Q_A(l_switch,G3(:,:,:,352),Q(:,31),MT,G4tensor(:,104))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,12),ZERO,G1(:,:,:,319))
  call loop_AV_Q(G1(:,:,:,319),wf(:,7),G1(:,:,:,320))
  call loop_A_Q(G1(:,:,:,320),Q(:,30),ZERO,G2(:,:,:,585))
  call loop_AV_Q(G2(:,:,:,585),wf(:,0),G2(:,:,:,586))
  call check_last_A_Q(l_switch,G2(:,:,:,586),Q(:,31),ZERO,G3tensor(:,153))
  call loop_AV_Q(G1(:,:,:,319),wf(:,-1),G1(:,:,:,321))
  call loop_A_Q(G1(:,:,:,321),Q(:,14),ZERO,G2(:,:,:,587))
  call loop_AV_Q(G2(:,:,:,587),wf(:,-4),G2(:,:,:,588))
  call loop_A_Q(G2(:,:,:,588),Q(:,30),ZERO,G3(:,:,:,353))
  call loop_AV_Q(G3(:,:,:,353),wf(:,0),G3(:,:,:,354))
  call check_last_A_Q(l_switch,G3(:,:,:,354),Q(:,31),ZERO,G4tensor(:,105))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,12),MT,G1(:,:,:,322))
  call loop_AV_Q(G1(:,:,:,322),wf(:,7),G1(:,:,:,323))
  call loop_A_Q(G1(:,:,:,323),Q(:,30),MT,G2(:,:,:,589))
  call loop_AV_Q(G2(:,:,:,589),wf(:,0),G2(:,:,:,590))
  call check_last_A_Q(l_switch,G2(:,:,:,590),Q(:,31),MT,G3tensor(:,154))
  call loop_AV_Q(G1(:,:,:,322),wf(:,-1),G1(:,:,:,324))
  call loop_A_Q(G1(:,:,:,324),Q(:,14),MT,G2(:,:,:,591))
  call loop_AV_Q(G2(:,:,:,591),wf(:,-4),G2(:,:,:,592))
  call loop_A_Q(G2(:,:,:,592),Q(:,30),MT,G3(:,:,:,355))
  call loop_AV_Q(G3(:,:,:,355),wf(:,0),G3(:,:,:,356))
  call check_last_A_Q(l_switch,G3(:,:,:,356),Q(:,31),MT,G4tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,12),MB,G1(:,:,:,325))
  call loop_QV_A(G1(:,:,:,325),wf(:,7),G1(:,:,:,326))
  call loop_Q_A(G1(:,:,:,326),Q(:,30),MB,G2(:,:,:,593))
  call loop_QV_A(G2(:,:,:,593),wf(:,0),G2(:,:,:,594))
  call check_last_Q_A(l_switch,G2(:,:,:,594),Q(:,31),MB,G3tensor(:,155))
  call loop_QV_A(G1(:,:,:,325),wf(:,-1),G1(:,:,:,327))
  call loop_Q_A(G1(:,:,:,327),Q(:,14),MB,G2(:,:,:,595))
  call loop_QV_A(G2(:,:,:,595),wf(:,-4),G2(:,:,:,596))
  call loop_Q_A(G2(:,:,:,596),Q(:,30),MB,G3(:,:,:,357))
  call loop_QV_A(G3(:,:,:,357),wf(:,0),G3(:,:,:,358))
  call check_last_Q_A(l_switch,G3(:,:,:,358),Q(:,31),MB,G4tensor(:,107))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,12),MB,G1(:,:,:,328))
  call loop_AV_Q(G1(:,:,:,328),wf(:,7),G1(:,:,:,329))
  call loop_A_Q(G1(:,:,:,329),Q(:,30),MB,G2(:,:,:,597))
  call loop_AV_Q(G2(:,:,:,597),wf(:,0),G2(:,:,:,598))
  call check_last_A_Q(l_switch,G2(:,:,:,598),Q(:,31),MB,G3tensor(:,156))
  call loop_AV_Q(G1(:,:,:,328),wf(:,-1),G1(:,:,:,330))
  call loop_A_Q(G1(:,:,:,330),Q(:,14),MB,G2(:,:,:,599))
  call loop_AV_Q(G2(:,:,:,599),wf(:,-4),G2(:,:,:,600))
  call loop_A_Q(G2(:,:,:,600),Q(:,30),MB,G3(:,:,:,359))
  call loop_AV_Q(G3(:,:,:,359),wf(:,0),G3(:,:,:,360))
  call check_last_A_Q(l_switch,G3(:,:,:,360),Q(:,31),MB,G4tensor(:,108))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,14),ZERO,G1(:,:,:,331))
  call loop_QV_A(G1(:,:,:,331),wf(:,-4),G1(:,:,:,332))
  call loop_Q_A(G1(:,:,:,332),Q(:,30),ZERO,G2(:,:,:,601))
  call loop_QV_A(G2(:,:,:,601),wf(:,0),G2(:,:,:,602))
  call check_last_Q_A(l_switch,G2(:,:,:,602),Q(:,31),ZERO,G3tensor(:,157))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,14),MT,G1(:,:,:,333))
  call loop_QV_A(G1(:,:,:,333),wf(:,-4),G1(:,:,:,334))
  call loop_Q_A(G1(:,:,:,334),Q(:,30),MT,G2(:,:,:,603))
  call loop_QV_A(G2(:,:,:,603),wf(:,0),G2(:,:,:,604))
  call check_last_Q_A(l_switch,G2(:,:,:,604),Q(:,31),MT,G3tensor(:,158))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,14),ZERO,G1(:,:,:,335))
  call loop_AV_Q(G1(:,:,:,335),wf(:,-4),G1(:,:,:,336))
  call loop_A_Q(G1(:,:,:,336),Q(:,30),ZERO,G2(:,:,:,605))
  call loop_AV_Q(G2(:,:,:,605),wf(:,0),G2(:,:,:,606))
  call check_last_A_Q(l_switch,G2(:,:,:,606),Q(:,31),ZERO,G3tensor(:,159))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,14),MT,G1(:,:,:,337))
  call loop_AV_Q(G1(:,:,:,337),wf(:,-4),G1(:,:,:,338))
  call loop_A_Q(G1(:,:,:,338),Q(:,30),MT,G2(:,:,:,607))
  call loop_AV_Q(G2(:,:,:,607),wf(:,0),G2(:,:,:,608))
  call check_last_A_Q(l_switch,G2(:,:,:,608),Q(:,31),MT,G3tensor(:,160))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,14),MB,G1(:,:,:,339))
  call loop_QV_A(G1(:,:,:,339),wf(:,-4),G1(:,:,:,340))
  call loop_Q_A(G1(:,:,:,340),Q(:,30),MB,G2(:,:,:,609))
  call loop_QV_A(G2(:,:,:,609),wf(:,0),G2(:,:,:,610))
  call check_last_Q_A(l_switch,G2(:,:,:,610),Q(:,31),MB,G3tensor(:,161))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,14),MB,G1(:,:,:,341))
  call loop_AV_Q(G1(:,:,:,341),wf(:,-4),G1(:,:,:,342))
  call loop_A_Q(G1(:,:,:,342),Q(:,30),MB,G2(:,:,:,611))
  call loop_AV_Q(G2(:,:,:,611),wf(:,0),G2(:,:,:,612))
  call check_last_A_Q(l_switch,G2(:,:,:,612),Q(:,31),MB,G3tensor(:,162))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(5) = M(5) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(6) = M(6) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(3) = M(3) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(5) = M(5) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(3) = M(3) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(5) = M(5) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(4) = M(4) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(6) = M(6) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(3) = M(3) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(5) = M(5) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(3) = M(3) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(5) = M(5) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(4) = M(4) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(6) = M(6) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(3) = M(3) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(5) = M(5) + (-f(7) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(3) = M(3) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(5) = M(5) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(2) = M(2) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(4) = M(4) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(6) = M(6) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(2) = M(2) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(3) = M(3) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(5) = M(5) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(5) = M(5) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(6) = M(6) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(3) = M(3) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(5) = M(5) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(3) = M(3) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(5) = M(5) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(2) = M(2) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(4) = M(4) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(6) = M(6) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(2) = M(2) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(3) = M(3) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(5) = M(5) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(3) = M(3) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(5) = M(5) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(4) = M(4) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(6) = M(6) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(3) = M(3) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(5) = M(5) + (f(6) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(3) = M(3) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(5) = M(5) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(2) = M(2) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(4) = M(4) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(6) = M(6) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(2) = M(2) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(3) = M(3) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(5) = M(5) + (f(5) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(2) = M(2) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(3) = M(3) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(5) = M(5) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(2) = M(2) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(4) = M(4) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(6) = M(6) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(1) = M(1) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(3) = M(3) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(5) = M(5) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(3) = M(3) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(5) = M(5) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(1) = M(1) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(2) = M(2) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(4) = M(4) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(6) = M(6) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(1) = M(1) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(3) = M(3) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(5) = M(5) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(2) = M(2) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(3) = M(3) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(5) = M(5) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(2) = M(2) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(4) = M(4) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(6) = M(6) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(1) = M(1) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(3) = M(3) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(5) = M(5) + (-f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(3) = M(3) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(5) = M(5) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(1) = M(1) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(2) = M(2) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(4) = M(4) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(6) = M(6) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(1) = M(1) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(3) = M(3) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(5) = M(5) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(2) = M(2) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(3) = M(3) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(5) = M(5) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(4) = M(4) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(6) = M(6) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,38),T3sum(1:35,4))
  M(1) = M(1) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(3) = M(3) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(5) = M(5) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(2) = M(2) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,6))
  M(3) = M(3) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,6))
  M(5) = M(5) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,6))
  M(1) = M(1) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(2) = M(2) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(4) = M(4) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(6) = M(6) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,6))
  M(1) = M(1) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(3) = M(3) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(5) = M(5) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,6))
  M(2) = M(2) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(3) = M(3) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(5) = M(5) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(4) = M(4) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(6) = M(6) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,50),T3sum(1:35,4))
  M(1) = M(1) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(3) = M(3) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(5) = M(5) + (f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(8)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(2) = M(2) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,6))
  M(3) = M(3) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,6))
  M(5) = M(5) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,6))
  M(1) = M(1) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,6))
  M(2) = M(2) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,6))
  M(4) = M(4) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,6))
  M(6) = M(6) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,6))
  M(1) = M(1) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(3) = M(3) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(5) = M(5) + (f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(8)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(1) = M(1) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(6) = M(6) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(3) = M(3) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(4) = M(4) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(5) = M(5) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(1) = M(1) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(6) = M(6) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,79),T3sum(1:35,8))
  M(2) = M(2) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,79),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,79),T3sum(1:35,8))
  M(6) = M(6) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,79),T3sum(1:35,8))
  M(2) = M(2) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,8))
  M(3) = M(3) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,8))
  M(4) = M(4) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,8))
  M(5) = M(5) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,80),T3sum(1:35,8))
  M(1) = M(1) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,81),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,81),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,81),T3sum(1:35,8))
  M(6) = M(6) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(6) = M(6) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(3) = M(3) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(4) = M(4) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(5) = M(5) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(1) = M(1) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(6) = M(6) + (-f(7) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,8))
  M(2) = M(2) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,8))
  M(6) = M(6) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,91),T3sum(1:35,8))
  M(2) = M(2) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,8))
  M(3) = M(3) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,8))
  M(4) = M(4) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,8))
  M(5) = M(5) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,92),T3sum(1:35,8))
  M(1) = M(1) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,8))
  M(6) = M(6) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,93),T3sum(1:35,8))
  M(1) = M(1) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(6) = M(6) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(3) = M(3) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(4) = M(4) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(5) = M(5) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(6) = M(6) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,97),T3sum(1:35,9))
  M(2) = M(2) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,97),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,97),T3sum(1:35,9))
  M(6) = M(6) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,97),T3sum(1:35,9))
  M(2) = M(2) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,98),T3sum(1:35,9))
  M(3) = M(3) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,98),T3sum(1:35,9))
  M(4) = M(4) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,98),T3sum(1:35,9))
  M(5) = M(5) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,98),T3sum(1:35,9))
  M(1) = M(1) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,99),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,99),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,99),T3sum(1:35,9))
  M(6) = M(6) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,99),T3sum(1:35,9))
  M(1) = M(1) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(6) = M(6) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(3) = M(3) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(4) = M(4) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(5) = M(5) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(6) = M(6) + (f(6) * den(9)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,103),T3sum(1:35,9))
  M(2) = M(2) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,103),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,103),T3sum(1:35,9))
  M(6) = M(6) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,103),T3sum(1:35,9))
  M(2) = M(2) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,104),T3sum(1:35,9))
  M(3) = M(3) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,104),T3sum(1:35,9))
  M(4) = M(4) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,104),T3sum(1:35,9))
  M(5) = M(5) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,104),T3sum(1:35,9))
  M(1) = M(1) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,105),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,105),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,105),T3sum(1:35,9))
  M(6) = M(6) + (f(5) * den(9)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,105),T3sum(1:35,9))
  M(1) = M(1) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(2) = M(2) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(4) = M(4) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(1) = M(1) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(3) = M(3) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(5) = M(5) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(6) = M(6) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(2) = M(2) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(4) = M(4) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,112),T3sum(1:35,11))
  M(2) = M(2) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,112),T3sum(1:35,11))
  M(4) = M(4) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,112),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,112),T3sum(1:35,11))
  M(1) = M(1) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,113),T3sum(1:35,11))
  M(3) = M(3) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,113),T3sum(1:35,11))
  M(5) = M(5) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,113),T3sum(1:35,11))
  M(6) = M(6) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,113),T3sum(1:35,11))
  M(2) = M(2) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,114),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,114),T3sum(1:35,11))
  M(4) = M(4) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,114),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,114),T3sum(1:35,11))
  M(1) = M(1) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(2) = M(2) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(4) = M(4) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(1) = M(1) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(3) = M(3) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(5) = M(5) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(6) = M(6) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(2) = M(2) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(4) = M(4) + (-f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,118),T3sum(1:35,11))
  M(2) = M(2) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,118),T3sum(1:35,11))
  M(4) = M(4) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,118),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,118),T3sum(1:35,11))
  M(1) = M(1) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,119),T3sum(1:35,11))
  M(3) = M(3) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,119),T3sum(1:35,11))
  M(5) = M(5) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,119),T3sum(1:35,11))
  M(6) = M(6) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,119),T3sum(1:35,11))
  M(2) = M(2) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,120),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,120),T3sum(1:35,11))
  M(4) = M(4) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,120),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,120),T3sum(1:35,11))
  M(1) = M(1) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(4) = M(4) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,109),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(3) = M(3) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(5) = M(5) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(6) = M(6) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,110),T3sum(1:35,10))
  M(2) = M(2) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(4) = M(4) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,111),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,121),T3sum(1:35,12))
  M(2) = M(2) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,121),T3sum(1:35,12))
  M(4) = M(4) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,121),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,121),T3sum(1:35,12))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,122),T3sum(1:35,12))
  M(3) = M(3) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,122),T3sum(1:35,12))
  M(5) = M(5) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,122),T3sum(1:35,12))
  M(6) = M(6) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,122),T3sum(1:35,12))
  M(2) = M(2) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,123),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,123),T3sum(1:35,12))
  M(4) = M(4) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,123),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,123),T3sum(1:35,12))
  M(1) = M(1) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(4) = M(4) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,115),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(3) = M(3) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(5) = M(5) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(6) = M(6) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,116),T3sum(1:35,10))
  M(2) = M(2) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(4) = M(4) + (f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(10)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,117),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,124),T3sum(1:35,12))
  M(2) = M(2) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,124),T3sum(1:35,12))
  M(4) = M(4) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,124),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,124),T3sum(1:35,12))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,12))
  M(3) = M(3) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,12))
  M(5) = M(5) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,12))
  M(6) = M(6) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,125),T3sum(1:35,12))
  M(2) = M(2) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,12))
  M(4) = M(4) + (f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(10)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,126),T3sum(1:35,12))
  M(1) = M(1) + (-f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(2) = M(2) + (f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(4) = M(4) + (f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(6) = M(6) + (-f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(1) = M(1) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,128),T3sum(1:35,14))
  M(2) = M(2) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,128),T3sum(1:35,14))
  M(4) = M(4) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,128),T3sum(1:35,14))
  M(6) = M(6) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,128),T3sum(1:35,14))
  M(1) = M(1) + (-f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(2) = M(2) + (f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(4) = M(4) + (f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(6) = M(6) + (-f(7) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(1) = M(1) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,130),T3sum(1:35,14))
  M(2) = M(2) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,130),T3sum(1:35,14))
  M(4) = M(4) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,130),T3sum(1:35,14))
  M(6) = M(6) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,130),T3sum(1:35,14))
  M(1) = M(1) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(2) = M(2) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(4) = M(4) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(6) = M(6) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,127),T3sum(1:35,13))
  M(1) = M(1) + (f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,131),T3sum(1:35,15))
  M(2) = M(2) + (-f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,131),T3sum(1:35,15))
  M(4) = M(4) + (-f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,131),T3sum(1:35,15))
  M(6) = M(6) + (f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,131),T3sum(1:35,15))
  M(1) = M(1) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(2) = M(2) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(4) = M(4) + (-f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(6) = M(6) + (f(6) * den(23)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,129),T3sum(1:35,13))
  M(1) = M(1) + (f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,132),T3sum(1:35,15))
  M(2) = M(2) + (-f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,132),T3sum(1:35,15))
  M(4) = M(4) + (-f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,132),T3sum(1:35,15))
  M(6) = M(6) + (f(5) * den(23)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,132),T3sum(1:35,15))
  M(1) = M(1) + (-f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(2) = M(2) + (f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(4) = M(4) + (f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,134),T3sum(1:35,11))
  M(2) = M(2) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,134),T3sum(1:35,11))
  M(4) = M(4) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,134),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,134),T3sum(1:35,11))
  M(1) = M(1) + (-f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(2) = M(2) + (f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(4) = M(4) + (f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,136),T3sum(1:35,11))
  M(2) = M(2) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,136),T3sum(1:35,11))
  M(4) = M(4) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,136),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,136),T3sum(1:35,11))
  M(1) = M(1) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(4) = M(4) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,133),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,12))
  M(2) = M(2) + (-f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,12))
  M(4) = M(4) + (-f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,137),T3sum(1:35,12))
  M(1) = M(1) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(4) = M(4) + (-f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(11)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,135),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,12))
  M(2) = M(2) + (-f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,12))
  M(4) = M(4) + (-f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(11)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,138),T3sum(1:35,12))
  M(1) = M(1) + (f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(2) = M(2) + (-f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(6) = M(6) + (f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,82),T3sum(1:35,8))
  M(2) = M(2) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,82),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,82),T3sum(1:35,8))
  M(6) = M(6) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,82),T3sum(1:35,8))
  M(1) = M(1) + (f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (-f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(6) = M(6) + (f(7) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,8))
  M(2) = M(2) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,8))
  M(6) = M(6) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,94),T3sum(1:35,8))
  M(1) = M(1) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(2) = M(2) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(6) = M(6) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(1) = M(1) + (-f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,100),T3sum(1:35,9))
  M(2) = M(2) + (f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,100),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,100),T3sum(1:35,9))
  M(6) = M(6) + (-f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,100),T3sum(1:35,9))
  M(1) = M(1) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(6) = M(6) + (-f(6) * den(12)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (-f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,106),T3sum(1:35,9))
  M(2) = M(2) + (f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,106),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,106),T3sum(1:35,9))
  M(6) = M(6) + (-f(5) * den(12)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,106),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(4) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,67),T4sum(1:70,1))
  M(6) = M(6) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,67),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,70),T4sum(1:70,2))
  M(6) = M(6) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,70),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(4) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,73),T4sum(1:70,1))
  M(4) = M(4) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,73),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,76),T4sum(1:70,2))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,76),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,67),T4sum(1:70,1))
  M(6) = M(6) + (CI*f(3) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,67),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,79),T4sum(1:70,3))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,79),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,73),T4sum(1:70,1))
  M(4) = M(4) + (CI*f(3) * den(1)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,73),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,82),T4sum(1:70,3))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,82),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(4) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,89),T4sum(1:70,4))
  M(4) = M(4) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,89),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,91),T4sum(1:70,5))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,91),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(4) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,85),T4sum(1:70,4))
  M(6) = M(6) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,85),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,87),T4sum(1:70,5))
  M(6) = M(6) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,87),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,89),T4sum(1:70,4))
  M(4) = M(4) + (CI*f(3) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,89),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,95),T4sum(1:70,6))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,95),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,85),T4sum(1:70,4))
  M(6) = M(6) + (CI*f(3) * den(1)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,85),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,93),T4sum(1:70,6))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,93),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(4) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,90),T4sum(1:70,7))
  M(6) = M(6) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,90),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,92),T4sum(1:70,8))
  M(6) = M(6) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,92),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(4) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(4)) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,88),T4sum(1:70,8))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,88),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,90),T4sum(1:70,7))
  M(6) = M(6) + (CI*f(3) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,90),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,96),T4sum(1:70,9))
  M(6) = M(6) + (CI*f(2) * den(1)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,96),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,7))
  M(4) = M(4) + (CI*f(3) * den(1)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,94),T4sum(1:70,9))
  M(4) = M(4) + (CI*f(2) * den(1)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,94),T4sum(1:70,9))
  M(2) = M(2) + (f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(3) = M(3) + (-f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(4) = M(4) + (f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(5) = M(5) + (-f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(2) = M(2) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,140),T3sum(1:35,17))
  M(3) = M(3) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,140),T3sum(1:35,17))
  M(4) = M(4) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,140),T3sum(1:35,17))
  M(5) = M(5) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,140),T3sum(1:35,17))
  M(2) = M(2) + (f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(3) = M(3) + (-f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(4) = M(4) + (f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(5) = M(5) + (-f(7) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(2) = M(2) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,142),T3sum(1:35,17))
  M(3) = M(3) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,142),T3sum(1:35,17))
  M(4) = M(4) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,142),T3sum(1:35,17))
  M(5) = M(5) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,142),T3sum(1:35,17))
  M(2) = M(2) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(3) = M(3) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(4) = M(4) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(5) = M(5) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,139),T3sum(1:35,16))
  M(2) = M(2) + (-f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,143),T3sum(1:35,18))
  M(3) = M(3) + (f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,143),T3sum(1:35,18))
  M(4) = M(4) + (-f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,143),T3sum(1:35,18))
  M(5) = M(5) + (f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,143),T3sum(1:35,18))
  M(2) = M(2) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(3) = M(3) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(4) = M(4) + (-f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(5) = M(5) + (f(6) * den(24)) * TI2_call(3,momenta_5,masses2_3,G3tensor(:,141),T3sum(1:35,16))
  M(2) = M(2) + (-f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,144),T3sum(1:35,18))
  M(3) = M(3) + (f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,144),T3sum(1:35,18))
  M(4) = M(4) + (-f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,144),T3sum(1:35,18))
  M(5) = M(5) + (f(5) * den(24)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,144),T3sum(1:35,18))
  M(2) = M(2) + (-f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(4) = M(4) + (-f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,11))
  M(4) = M(4) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,146),T3sum(1:35,11))
  M(2) = M(2) + (-f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(4) = M(4) + (-f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(2) = M(2) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,11))
  M(4) = M(4) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,148),T3sum(1:35,11))
  M(2) = M(2) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(4) = M(4) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,145),T3sum(1:35,10))
  M(2) = M(2) + (f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,149),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,149),T3sum(1:35,12))
  M(4) = M(4) + (f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,149),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,149),T3sum(1:35,12))
  M(2) = M(2) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(4) = M(4) + (f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(13)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,147),T3sum(1:35,10))
  M(2) = M(2) + (f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,150),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,150),T3sum(1:35,12))
  M(4) = M(4) + (f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,150),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(13)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,150),T3sum(1:35,12))
  M(2) = M(2) + (-f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(3) = M(3) + (f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(5) = M(5) + (f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(3) = M(3) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(5) = M(5) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(2) = M(2) + (-f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(3) = M(3) + (f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(5) = M(5) + (f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(2) = M(2) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(3) = M(3) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(5) = M(5) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(2) = M(2) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(3) = M(3) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(5) = M(5) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,40),T3sum(1:35,4))
  M(2) = M(2) + (f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,6))
  M(3) = M(3) + (-f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,6))
  M(5) = M(5) + (-f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,6))
  M(2) = M(2) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(3) = M(3) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(5) = M(5) + (-f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,52),T3sum(1:35,4))
  M(2) = M(2) + (f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(3) = M(3) + (-f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(5) = M(5) + (-f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(4) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,37),T4sum(1:70,10))
  M(5) = M(5) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,37),T4sum(1:70,10))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,42),T4sum(1:70,11))
  M(5) = M(5) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,42),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,47),T4sum(1:70,10))
  M(3) = M(3) + (CI*f(4) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,47),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,52),T4sum(1:70,11))
  M(3) = M(3) + (CI*f(3) * den(2)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,52),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,37),T4sum(1:70,10))
  M(5) = M(5) + (CI*f(3) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,37),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,57),T4sum(1:70,12))
  M(5) = M(5) + (CI*f(2) * den(2)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,57),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,47),T4sum(1:70,10))
  M(3) = M(3) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,47),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,62),T4sum(1:70,12))
  M(3) = M(3) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,62),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(3) = M(3) + (CI*f(4) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,43),T4sum(1:70,14))
  M(3) = M(3) + (CI*f(3) * den(2)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,43),T4sum(1:70,14))
  M(4) = M(4) + (CI*f(4) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,48),T4sum(1:70,13))
  M(5) = M(5) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,48),T4sum(1:70,13))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,53),T4sum(1:70,14))
  M(5) = M(5) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,53),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(3) = M(3) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,58),T4sum(1:70,15))
  M(3) = M(3) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,58),T4sum(1:70,15))
  M(4) = M(4) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,48),T4sum(1:70,13))
  M(5) = M(5) + (CI*f(3) * den(2)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,48),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,63),T4sum(1:70,15))
  M(5) = M(5) + (CI*f(2) * den(2)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,63),T4sum(1:70,15))
  M(4) = M(4) + (CI*f(4) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,99),T4sum(1:70,16))
  M(5) = M(5) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,99),T4sum(1:70,16))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,100),T4sum(1:70,17))
  M(5) = M(5) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,100),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(4)) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,97),T4sum(1:70,16))
  M(3) = M(3) + (CI*f(4) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,97),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,98),T4sum(1:70,17))
  M(3) = M(3) + (CI*f(3) * den(2)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,98),T4sum(1:70,17))
  M(4) = M(4) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,99),T4sum(1:70,16))
  M(5) = M(5) + (CI*f(3) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,99),T4sum(1:70,16))
  M(4) = M(4) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,102),T4sum(1:70,18))
  M(5) = M(5) + (CI*f(2) * den(2)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,102),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,97),T4sum(1:70,16))
  M(3) = M(3) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,97),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,101),T4sum(1:70,18))
  M(3) = M(3) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,101),T4sum(1:70,18))
  M(1) = M(1) + (f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(3) = M(3) + (-f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(5) = M(5) + (-f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(6) = M(6) + (f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(1) = M(1) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,152),T3sum(1:35,20))
  M(3) = M(3) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,152),T3sum(1:35,20))
  M(5) = M(5) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,152),T3sum(1:35,20))
  M(6) = M(6) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,152),T3sum(1:35,20))
  M(1) = M(1) + (f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(3) = M(3) + (-f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(5) = M(5) + (-f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(6) = M(6) + (f(7) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(1) = M(1) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,154),T3sum(1:35,20))
  M(3) = M(3) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,154),T3sum(1:35,20))
  M(5) = M(5) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,154),T3sum(1:35,20))
  M(6) = M(6) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,154),T3sum(1:35,20))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(3) = M(3) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(5) = M(5) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(6) = M(6) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,151),T3sum(1:35,19))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,155),T3sum(1:35,21))
  M(3) = M(3) + (f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,155),T3sum(1:35,21))
  M(5) = M(5) + (f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,155),T3sum(1:35,21))
  M(6) = M(6) + (-f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,155),T3sum(1:35,21))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(3) = M(3) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(5) = M(5) + (f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(6) = M(6) + (-f(6) * den(25)) * TI2_call(3,momenta_6,masses2_3,G3tensor(:,153),T3sum(1:35,19))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,156),T3sum(1:35,21))
  M(3) = M(3) + (f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,156),T3sum(1:35,21))
  M(5) = M(5) + (f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,156),T3sum(1:35,21))
  M(6) = M(6) + (-f(5) * den(25)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,156),T3sum(1:35,21))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,158),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,158),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,158),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,158),T3sum(1:35,11))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(3) = M(3) + (f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(5) = M(5) + (f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(6) = M(6) + (-f(7) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(1) = M(1) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,160),T3sum(1:35,11))
  M(3) = M(3) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,160),T3sum(1:35,11))
  M(5) = M(5) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,160),T3sum(1:35,11))
  M(6) = M(6) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_2,G3tensor(:,160),T3sum(1:35,11))
  M(1) = M(1) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,157),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,161),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,161),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,161),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,161),T3sum(1:35,12))
  M(1) = M(1) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(3) = M(3) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(5) = M(5) + (-f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(6) = M(6) + (f(6) * den(15)) * TI2_call(3,momenta_7,masses2_3,G3tensor(:,159),T3sum(1:35,10))
  M(1) = M(1) + (f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,162),T3sum(1:35,12))
  M(3) = M(3) + (-f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,162),T3sum(1:35,12))
  M(5) = M(5) + (-f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,162),T3sum(1:35,12))
  M(6) = M(6) + (f(5) * den(15)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,162),T3sum(1:35,12))
  M(1) = M(1) + (-f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(3) = M(3) + (f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(5) = M(5) + (f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(3) = M(3) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(5) = M(5) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(3) = M(3) + (f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(5) = M(5) + (f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,2))
  M(3) = M(3) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,2))
  M(5) = M(5) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(3) = M(3) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(5) = M(5) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(3) = M(3) + (-f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(5) = M(5) + (-f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(3) = M(3) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(5) = M(5) + (-f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(3) = M(3) + (-f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(5) = M(5) + (-f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(4) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(3) = M(3) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(3) * den(4)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,7),T4sum(1:70,20))
  M(3) = M(3) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,7),T4sum(1:70,20))
  M(5) = M(5) + (CI*f(4) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,13),T4sum(1:70,19))
  M(6) = M(6) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,13),T4sum(1:70,19))
  M(5) = M(5) + (CI*f(3) * den(4)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,19),T4sum(1:70,20))
  M(6) = M(6) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,19),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(3) = M(3) + (CI*f(3) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,25),T4sum(1:70,21))
  M(3) = M(3) + (CI*f(2) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,25),T4sum(1:70,21))
  M(5) = M(5) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,13),T4sum(1:70,19))
  M(6) = M(6) + (CI*f(3) * den(4)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,13),T4sum(1:70,19))
  M(5) = M(5) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,31),T4sum(1:70,21))
  M(6) = M(6) + (CI*f(2) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,31),T4sum(1:70,21))
  M(5) = M(5) + (CI*f(4) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,2),T4sum(1:70,22))
  M(6) = M(6) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,2),T4sum(1:70,22))
  M(5) = M(5) + (CI*f(3) * den(4)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,8),T4sum(1:70,23))
  M(6) = M(6) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,8),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(4) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,22))
  M(3) = M(3) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(3) * den(4)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,20),T4sum(1:70,23))
  M(3) = M(3) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,20),T4sum(1:70,23))
  M(5) = M(5) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,2),T4sum(1:70,22))
  M(6) = M(6) + (CI*f(3) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,2),T4sum(1:70,22))
  M(5) = M(5) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,26),T4sum(1:70,24))
  M(6) = M(6) + (CI*f(2) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,26),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,22))
  M(3) = M(3) + (CI*f(3) * den(4)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,32),T4sum(1:70,24))
  M(3) = M(3) + (CI*f(2) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,32),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(4) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(3) = M(3) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(3) * den(4)) * TI2_call(4,momenta_25,masses2_5,G4tensor(:,104),T4sum(1:70,26))
  M(3) = M(3) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_25,masses2_5,G4tensor(:,104),T4sum(1:70,26))
  M(5) = M(5) + (CI*f(4) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(6) = M(6) + (-(CI*f(4)) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(5) = M(5) + (CI*f(3) * den(4)) * TI2_call(4,momenta_25,masses2_5,G4tensor(:,106),T4sum(1:70,26))
  M(6) = M(6) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_25,masses2_5,G4tensor(:,106),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(3) = M(3) + (CI*f(3) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,107),T4sum(1:70,27))
  M(3) = M(3) + (CI*f(2) * den(4)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,107),T4sum(1:70,27))
  M(5) = M(5) + (-(CI*f(3)) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(6) = M(6) + (CI*f(3) * den(4)) * TI2_call(4,momenta_25,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(5) = M(5) + (-(CI*f(2)) * den(4)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,108),T4sum(1:70,27))
  M(6) = M(6) + (CI*f(2) * den(4)) * TI2_call(4,momenta_25,masses2_4,G4tensor(:,108),T4sum(1:70,27))
  M(1) = M(1) + (-f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(6) = M(6) + (-f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(1) = M(1) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,8))
  M(6) = M(6) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,83),T3sum(1:35,8))
  M(1) = M(1) + (-f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(6) = M(6) + (-f(7) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(1) = M(1) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,8))
  M(6) = M(6) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,95),T3sum(1:35,8))
  M(1) = M(1) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(6) = M(6) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(1) = M(1) + (f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,101),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,101),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,101),T3sum(1:35,9))
  M(6) = M(6) + (f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,101),T3sum(1:35,9))
  M(1) = M(1) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(6) = M(6) + (f(6) * den(17)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(1) = M(1) + (f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,107),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,107),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,107),T3sum(1:35,9))
  M(6) = M(6) + (f(5) * den(17)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,107),T3sum(1:35,9))
  M(1) = M(1) + (f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(3) = M(3) + (-f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(5) = M(5) + (-f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(3) = M(3) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(5) = M(5) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(1) = M(1) + (f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(3) = M(3) + (-f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(5) = M(5) + (-f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(3) = M(3) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(5) = M(5) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(1) = M(1) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(3) = M(3) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(5) = M(5) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,41),T3sum(1:35,4))
  M(1) = M(1) + (-f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,6))
  M(3) = M(3) + (f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,6))
  M(5) = M(5) + (f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,6))
  M(1) = M(1) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(3) = M(3) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(5) = M(5) + (f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (-f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(3) = M(3) + (f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(5) = M(5) + (f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,39),T4sum(1:70,28))
  M(6) = M(6) + (CI*f(4) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,39),T4sum(1:70,28))
  M(3) = M(3) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,44),T4sum(1:70,29))
  M(6) = M(6) + (CI*f(3) * den(3)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,44),T4sum(1:70,29))
  M(1) = M(1) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,49),T4sum(1:70,28))
  M(5) = M(5) + (CI*f(4) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,49),T4sum(1:70,28))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,54),T4sum(1:70,29))
  M(5) = M(5) + (CI*f(3) * den(3)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,54),T4sum(1:70,29))
  M(3) = M(3) + (CI*f(3) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,39),T4sum(1:70,28))
  M(6) = M(6) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,39),T4sum(1:70,28))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,59),T4sum(1:70,30))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,59),T4sum(1:70,30))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,49),T4sum(1:70,28))
  M(5) = M(5) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,49),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,64),T4sum(1:70,30))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,64),T4sum(1:70,30))
  M(1) = M(1) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,40),T4sum(1:70,31))
  M(5) = M(5) + (CI*f(4) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,40),T4sum(1:70,31))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,45),T4sum(1:70,32))
  M(5) = M(5) + (CI*f(3) * den(3)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,45),T4sum(1:70,32))
  M(3) = M(3) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,50),T4sum(1:70,31))
  M(6) = M(6) + (CI*f(4) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,50),T4sum(1:70,31))
  M(3) = M(3) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,55),T4sum(1:70,32))
  M(6) = M(6) + (CI*f(3) * den(3)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,55),T4sum(1:70,32))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,40),T4sum(1:70,31))
  M(5) = M(5) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,40),T4sum(1:70,31))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,60),T4sum(1:70,33))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,60),T4sum(1:70,33))
  M(3) = M(3) + (CI*f(3) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,50),T4sum(1:70,31))
  M(6) = M(6) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,50),T4sum(1:70,31))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,65),T4sum(1:70,33))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,65),T4sum(1:70,33))
  M(3) = M(3) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,68),T4sum(1:70,34))
  M(6) = M(6) + (CI*f(4) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,68),T4sum(1:70,34))
  M(3) = M(3) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,71),T4sum(1:70,35))
  M(6) = M(6) + (CI*f(3) * den(3)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,71),T4sum(1:70,35))
  M(1) = M(1) + (-(CI*f(4)) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,74),T4sum(1:70,34))
  M(5) = M(5) + (CI*f(4) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,74),T4sum(1:70,34))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,77),T4sum(1:70,35))
  M(5) = M(5) + (CI*f(3) * den(3)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,77),T4sum(1:70,35))
  M(3) = M(3) + (CI*f(3) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,68),T4sum(1:70,34))
  M(6) = M(6) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,68),T4sum(1:70,34))
  M(3) = M(3) + (CI*f(2) * den(3)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,80),T4sum(1:70,36))
  M(6) = M(6) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,80),T4sum(1:70,36))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,74),T4sum(1:70,34))
  M(5) = M(5) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,74),T4sum(1:70,34))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,83),T4sum(1:70,36))
  M(5) = M(5) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,83),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(2) = M(2) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,84),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,84),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,84),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,84),T3sum(1:35,8))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(3) = M(3) + (f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(4) = M(4) + (-f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(5) = M(5) + (f(7) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(2) = M(2) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,8))
  M(3) = M(3) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,8))
  M(4) = M(4) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,8))
  M(5) = M(5) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_2,G3tensor(:,96),T3sum(1:35,8))
  M(2) = M(2) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(2) = M(2) + (f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,102),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,102),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,102),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,102),T3sum(1:35,9))
  M(2) = M(2) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(3) = M(3) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(4) = M(4) + (f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(5) = M(5) + (-f(6) * den(19)) * TI2_call(3,momenta_4,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(2) = M(2) + (f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,108),T3sum(1:35,9))
  M(3) = M(3) + (-f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,108),T3sum(1:35,9))
  M(4) = M(4) + (f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,108),T3sum(1:35,9))
  M(5) = M(5) + (-f(5) * den(19)) * TI2_call(3,momenta_4,masses2_1,G3tensor(:,108),T3sum(1:35,9))
  M(2) = M(2) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(3) = M(3) + (-f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(5) = M(5) + (-f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,2))
  M(3) = M(3) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,2))
  M(5) = M(5) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,2))
  M(2) = M(2) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(3) = M(3) + (-f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(5) = M(5) + (-f(7) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,2))
  M(3) = M(3) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,2))
  M(5) = M(5) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,2))
  M(2) = M(2) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(3) = M(3) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(5) = M(5) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(3) = M(3) + (f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(5) = M(5) + (f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(2) = M(2) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(3) = M(3) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(5) = M(5) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(3) = M(3) + (f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(5) = M(5) + (f(5) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,3),T4sum(1:70,37))
  M(5) = M(5) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,3),T4sum(1:70,37))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,9),T4sum(1:70,38))
  M(5) = M(5) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,9),T4sum(1:70,38))
  M(3) = M(3) + (CI*f(4) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(4) = M(4) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(3) = M(3) + (CI*f(3) * den(5)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,21),T4sum(1:70,38))
  M(4) = M(4) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,21),T4sum(1:70,38))
  M(2) = M(2) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,3),T4sum(1:70,37))
  M(5) = M(5) + (CI*f(3) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,3),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,27),T4sum(1:70,39))
  M(5) = M(5) + (CI*f(2) * den(5)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,27),T4sum(1:70,39))
  M(3) = M(3) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(4) = M(4) + (CI*f(3) * den(5)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(3) = M(3) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(4) = M(4) + (CI*f(2) * den(5)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(3) = M(3) + (CI*f(4) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,4),T4sum(1:70,40))
  M(4) = M(4) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,4),T4sum(1:70,40))
  M(3) = M(3) + (CI*f(3) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,10),T4sum(1:70,41))
  M(4) = M(4) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,10),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,16),T4sum(1:70,40))
  M(5) = M(5) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,16),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,22),T4sum(1:70,41))
  M(5) = M(5) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,22),T4sum(1:70,41))
  M(3) = M(3) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,4),T4sum(1:70,40))
  M(4) = M(4) + (CI*f(3) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,4),T4sum(1:70,40))
  M(3) = M(3) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,28),T4sum(1:70,42))
  M(4) = M(4) + (CI*f(2) * den(5)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,28),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,16),T4sum(1:70,40))
  M(5) = M(5) + (CI*f(3) * den(5)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,16),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,34),T4sum(1:70,42))
  M(5) = M(5) + (CI*f(2) * den(5)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,34),T4sum(1:70,42))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,69),T4sum(1:70,43))
  M(5) = M(5) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,69),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,72),T4sum(1:70,44))
  M(5) = M(5) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,72),T4sum(1:70,44))
  M(3) = M(3) + (CI*f(4) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,75),T4sum(1:70,43))
  M(4) = M(4) + (-(CI*f(4)) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,75),T4sum(1:70,43))
  M(3) = M(3) + (CI*f(3) * den(5)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,78),T4sum(1:70,44))
  M(4) = M(4) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,78),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,69),T4sum(1:70,43))
  M(5) = M(5) + (CI*f(3) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,69),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,81),T4sum(1:70,45))
  M(5) = M(5) + (CI*f(2) * den(5)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,81),T4sum(1:70,45))
  M(3) = M(3) + (-(CI*f(3)) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,75),T4sum(1:70,43))
  M(4) = M(4) + (CI*f(3) * den(5)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,75),T4sum(1:70,43))
  M(3) = M(3) + (-(CI*f(2)) * den(5)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,84),T4sum(1:70,45))
  M(4) = M(4) + (CI*f(2) * den(5)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,84),T4sum(1:70,45))
  M(1) = M(1) + (f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(2) = M(2) + (-f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(2) = M(2) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(1) = M(1) + (f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (-f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(4) = M(4) + (-f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(6) = M(6) + (f(7) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(2) = M(2) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(4) = M(4) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(6) = M(6) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(1) = M(1) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(2) = M(2) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,42),T3sum(1:35,4))
  M(1) = M(1) + (-f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,6))
  M(2) = M(2) + (f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,6))
  M(1) = M(1) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(4) = M(4) + (f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(6) = M(6) + (-f(6) * den(21)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (-f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(2) = M(2) + (f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(4) = M(4) + (f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(6) = M(6) + (-f(5) * den(21)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(1) = M(1) + (-f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(2) = M(2) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(4) = M(4) + (f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(6) = M(6) + (-f(7) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,2))
  M(2) = M(2) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,2))
  M(4) = M(4) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,2))
  M(6) = M(6) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(2) = M(2) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(4) = M(4) + (-f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(6) = M(6) + (f(6) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(2) = M(2) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(4) = M(4) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(6) = M(6) + (f(5) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(4) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,5),T4sum(1:70,46))
  M(6) = M(6) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,5),T4sum(1:70,46))
  M(4) = M(4) + (CI*f(3) * den(6)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,11),T4sum(1:70,47))
  M(6) = M(6) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,11),T4sum(1:70,47))
  M(1) = M(1) + (CI*f(4) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,17),T4sum(1:70,46))
  M(2) = M(2) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,17),T4sum(1:70,46))
  M(1) = M(1) + (CI*f(3) * den(6)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,23),T4sum(1:70,47))
  M(2) = M(2) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,23),T4sum(1:70,47))
  M(4) = M(4) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,5),T4sum(1:70,46))
  M(6) = M(6) + (CI*f(3) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,5),T4sum(1:70,46))
  M(4) = M(4) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,29),T4sum(1:70,48))
  M(6) = M(6) + (CI*f(2) * den(6)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,29),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,17),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(3) * den(6)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,17),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,35),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(2) * den(6)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,35),T4sum(1:70,48))
  M(1) = M(1) + (CI*f(4) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(3) * den(6)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,12),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,12),T4sum(1:70,50))
  M(4) = M(4) + (CI*f(4) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,18),T4sum(1:70,49))
  M(6) = M(6) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,18),T4sum(1:70,49))
  M(4) = M(4) + (CI*f(3) * den(6)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,24),T4sum(1:70,50))
  M(6) = M(6) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,24),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(3) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,30),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(2) * den(6)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,30),T4sum(1:70,51))
  M(4) = M(4) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,18),T4sum(1:70,49))
  M(6) = M(6) + (CI*f(3) * den(6)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,18),T4sum(1:70,49))
  M(4) = M(4) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,36),T4sum(1:70,51))
  M(6) = M(6) + (CI*f(2) * den(6)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,36),T4sum(1:70,51))
  M(4) = M(4) + (CI*f(4) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,41),T4sum(1:70,52))
  M(6) = M(6) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,41),T4sum(1:70,52))
  M(4) = M(4) + (CI*f(3) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,46),T4sum(1:70,53))
  M(6) = M(6) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,46),T4sum(1:70,53))
  M(1) = M(1) + (CI*f(4) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,51),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(4)) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,51),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(3) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,56),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,56),T4sum(1:70,53))
  M(4) = M(4) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,41),T4sum(1:70,52))
  M(6) = M(6) + (CI*f(3) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,41),T4sum(1:70,52))
  M(4) = M(4) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,61),T4sum(1:70,54))
  M(6) = M(6) + (CI*f(2) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,61),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(3)) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,51),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(3) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,51),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(2)) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,66),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(2) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,66),T4sum(1:70,54))
  M(4) = M(4) + (-f(7)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,3),T5sum(1:126,1))
  M(4) = M(4) + (-f(6)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,9),T5sum(1:126,2))
  M(2) = M(2) + (-f(7)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,15),T5sum(1:126,1))
  M(2) = M(2) + (-f(6)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,21),T5sum(1:126,2))
  M(4) = M(4) + (f(6)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,3),T5sum(1:126,1))
  M(4) = M(4) + (f(5)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,27),T5sum(1:126,3))
  M(2) = M(2) + (f(6)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,15),T5sum(1:126,1))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,33),T5sum(1:126,3))
  M(6) = M(6) + (-f(7)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,1),T5sum(1:126,4))
  M(6) = M(6) + (-f(6)) * TI2_call(5,momenta_31,masses2_8,G5tensor(:,7),T5sum(1:126,5))
  M(1) = M(1) + (-f(7)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (-f(6)) * TI2_call(5,momenta_31,masses2_8,G5tensor(:,19),T5sum(1:126,5))
  M(6) = M(6) + (f(6)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,1),T5sum(1:126,4))
  M(6) = M(6) + (f(5)) * TI2_call(5,momenta_31,masses2_7,G5tensor(:,25),T5sum(1:126,6))
  M(1) = M(1) + (f(6)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_31,masses2_7,G5tensor(:,31),T5sum(1:126,6))
  M(2) = M(2) + (-f(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,5),T5sum(1:126,7))
  M(2) = M(2) + (-f(6)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,11),T5sum(1:126,8))
  M(4) = M(4) + (-f(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,17),T5sum(1:126,7))
  M(4) = M(4) + (-f(6)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,23),T5sum(1:126,8))
  M(2) = M(2) + (f(6)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,5),T5sum(1:126,7))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,29),T5sum(1:126,9))
  M(4) = M(4) + (f(6)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,17),T5sum(1:126,7))
  M(4) = M(4) + (f(5)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,35),T5sum(1:126,9))
  M(5) = M(5) + (-f(7)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,2),T5sum(1:126,10))
  M(5) = M(5) + (-f(6)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,8),T5sum(1:126,11))
  M(3) = M(3) + (-f(7)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,14),T5sum(1:126,10))
  M(3) = M(3) + (-f(6)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,20),T5sum(1:126,11))
  M(5) = M(5) + (f(6)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,2),T5sum(1:126,10))
  M(5) = M(5) + (f(5)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,26),T5sum(1:126,12))
  M(3) = M(3) + (f(6)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,14),T5sum(1:126,10))
  M(3) = M(3) + (f(5)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,32),T5sum(1:126,12))
  M(1) = M(1) + (-f(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,6),T5sum(1:126,13))
  M(1) = M(1) + (-f(6)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,12),T5sum(1:126,14))
  M(6) = M(6) + (-f(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,18),T5sum(1:126,13))
  M(6) = M(6) + (-f(6)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,24),T5sum(1:126,14))
  M(1) = M(1) + (f(6)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,6),T5sum(1:126,13))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,30),T5sum(1:126,15))
  M(6) = M(6) + (f(6)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,18),T5sum(1:126,13))
  M(6) = M(6) + (f(5)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,36),T5sum(1:126,15))
  M(3) = M(3) + (-f(7)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,4),T5sum(1:126,16))
  M(3) = M(3) + (-f(6)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,10),T5sum(1:126,17))
  M(5) = M(5) + (-f(7)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,16),T5sum(1:126,16))
  M(5) = M(5) + (-f(6)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,22),T5sum(1:126,17))
  M(3) = M(3) + (f(6)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,4),T5sum(1:126,16))
  M(3) = M(3) + (f(5)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,28),T5sum(1:126,18))
  M(5) = M(5) + (f(6)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,16),T5sum(1:126,16))
  M(5) = M(5) + (f(5)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,34),T5sum(1:126,18))
  M(6) = M(6) + (-f(7)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,39),T5sum(1:126,19))
  M(6) = M(6) + (-f(6)) * TI2_call(5,momenta_33,masses2_8,G5tensor(:,43),T5sum(1:126,20))
  M(1) = M(1) + (-f(7)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,47),T5sum(1:126,19))
  M(1) = M(1) + (-f(6)) * TI2_call(5,momenta_33,masses2_8,G5tensor(:,51),T5sum(1:126,20))
  M(6) = M(6) + (f(6)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,39),T5sum(1:126,19))
  M(6) = M(6) + (f(5)) * TI2_call(5,momenta_33,masses2_7,G5tensor(:,55),T5sum(1:126,21))
  M(1) = M(1) + (f(6)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,47),T5sum(1:126,19))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_33,masses2_7,G5tensor(:,59),T5sum(1:126,21))
  M(3) = M(3) + (-f(7)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,37),T5sum(1:126,22))
  M(3) = M(3) + (-f(6)) * TI2_call(5,momenta_35,masses2_8,G5tensor(:,41),T5sum(1:126,23))
  M(5) = M(5) + (-f(7)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,45),T5sum(1:126,22))
  M(5) = M(5) + (-f(6)) * TI2_call(5,momenta_35,masses2_8,G5tensor(:,49),T5sum(1:126,23))
  M(3) = M(3) + (f(6)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,37),T5sum(1:126,22))
  M(3) = M(3) + (f(5)) * TI2_call(5,momenta_35,masses2_7,G5tensor(:,53),T5sum(1:126,24))
  M(5) = M(5) + (f(6)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,45),T5sum(1:126,22))
  M(5) = M(5) + (f(5)) * TI2_call(5,momenta_35,masses2_7,G5tensor(:,57),T5sum(1:126,24))
  M(4) = M(4) + (-f(7)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,40),T5sum(1:126,25))
  M(4) = M(4) + (-f(6)) * TI2_call(5,momenta_32,masses2_8,G5tensor(:,44),T5sum(1:126,26))
  M(2) = M(2) + (-f(7)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,48),T5sum(1:126,25))
  M(2) = M(2) + (-f(6)) * TI2_call(5,momenta_32,masses2_8,G5tensor(:,52),T5sum(1:126,26))
  M(4) = M(4) + (f(6)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,40),T5sum(1:126,25))
  M(4) = M(4) + (f(5)) * TI2_call(5,momenta_32,masses2_7,G5tensor(:,56),T5sum(1:126,27))
  M(2) = M(2) + (f(6)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,48),T5sum(1:126,25))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_32,masses2_7,G5tensor(:,60),T5sum(1:126,27))
  M(5) = M(5) + (-f(7)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,38),T5sum(1:126,28))
  M(5) = M(5) + (-f(6)) * TI2_call(5,momenta_34,masses2_8,G5tensor(:,42),T5sum(1:126,29))
  M(3) = M(3) + (-f(7)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,46),T5sum(1:126,28))
  M(3) = M(3) + (-f(6)) * TI2_call(5,momenta_34,masses2_8,G5tensor(:,50),T5sum(1:126,29))
  M(5) = M(5) + (f(6)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,38),T5sum(1:126,28))
  M(5) = M(5) + (f(5)) * TI2_call(5,momenta_34,masses2_7,G5tensor(:,54),T5sum(1:126,30))
  M(3) = M(3) + (f(6)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,46),T5sum(1:126,28))
  M(3) = M(3) + (f(5)) * TI2_call(5,momenta_34,masses2_7,G5tensor(:,58),T5sum(1:126,30))
  M(2) = M(2) + (-f(7)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,62),T5sum(1:126,31))
  M(2) = M(2) + (-f(6)) * TI2_call(5,momenta_36,masses2_8,G5tensor(:,64),T5sum(1:126,32))
  M(4) = M(4) + (-f(7)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,66),T5sum(1:126,31))
  M(4) = M(4) + (-f(6)) * TI2_call(5,momenta_36,masses2_8,G5tensor(:,68),T5sum(1:126,32))
  M(2) = M(2) + (f(6)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,62),T5sum(1:126,31))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_36,masses2_7,G5tensor(:,70),T5sum(1:126,33))
  M(4) = M(4) + (f(6)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,66),T5sum(1:126,31))
  M(4) = M(4) + (f(5)) * TI2_call(5,momenta_36,masses2_7,G5tensor(:,72),T5sum(1:126,33))
  M(6) = M(6) + (-f(7)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,61),T5sum(1:126,34))
  M(6) = M(6) + (-f(6)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,63),T5sum(1:126,35))
  M(1) = M(1) + (-f(7)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,65),T5sum(1:126,34))
  M(1) = M(1) + (-f(6)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,67),T5sum(1:126,35))
  M(6) = M(6) + (f(6)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,61),T5sum(1:126,34))
  M(6) = M(6) + (f(5)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,69),T5sum(1:126,36))
  M(1) = M(1) + (f(6)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,65),T5sum(1:126,34))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,71),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppajj2_agggg_1_/**/REALKIND
