
module ol_colourmatrix_ppajj2_bbxagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,3), KL(0,3), KL2(51,3), KL2ct(3,3), KL2ct2(51,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [   48,   -6,   18]
  KL2( 2,:) = [   -6,   48,   18]
  KL2( 3,:) = [   18,   18,   54]
  KL2( 4,:) = [   64,   -8,   24]
  KL2( 5,:) = [   -8,   64,   24]
  KL2( 6,:) = [   24,   24,   72]
  KL2( 7,:) = [   -1,  -10,  -24]
  KL2( 8,:) = [  -10,   -1,  -24]
  KL2( 9,:) = [  -24,  -24,  -72]
  KL2(10,:) = [   64,   -8,   24]
  KL2(11,:) = [   -8,   64,   24]
  KL2(12,:) = [   24,   24,   72]
  KL2(13,:) = [    0,    0,    0]
  KL2(14,:) = [    0,    0,    0]
  KL2(15,:) = [    0,    0,    0]
  KL2(16,:) = [    0,    0,    0]
  KL2(17,:) = [    0,    0,    0]
  KL2(18,:) = [    0,    0,    0]
  KL2(19,:) = [    0,    0,    0]
  KL2(20,:) = [    0,    0,    0]
  KL2(21,:) = [    0,    0,    0]
  KL2(22,:) = [    9,    9,   27]
  KL2(23,:) = [    9,  -72,  -27]
  KL2(24,:) = [   27,  -27,    0]
  KL2(25,:) = [  -72,    9,  -27]
  KL2(26,:) = [    9,    9,   27]
  KL2(27,:) = [  -27,   27,    0]
  KL2(28,:) = [    0,    0,    0]
  KL2(29,:) = [    0,    0,    0]
  KL2(30,:) = [    0,    0,    0]
  KL2(31,:) = [  144,  -18,   54]
  KL2(32,:) = [  -18,  144,   54]
  KL2(33,:) = [   54,   54,  162]
  KL2(34,:) = [  -72,    9,  -27]
  KL2(35,:) = [    9,    9,   27]
  KL2(36,:) = [  -27,   27,    0]
  KL2(37,:) = [    9,    9,   27]
  KL2(38,:) = [    9,  -72,  -27]
  KL2(39,:) = [   27,  -27,    0]
  KL2(40,:) = [    0,    0,    0]
  KL2(41,:) = [    0,    0,    0]
  KL2(42,:) = [    0,    0,    0]
  KL2(43,:) = [  -81,    0,  -54]
  KL2(44,:) = [    0,  -81,  -54]
  KL2(45,:) = [  -54,  -54, -162]
  KL2(46,:) = [  144,  -18,   54]
  KL2(47,:) = [  -18,  144,   54]
  KL2(48,:) = [   54,   54,  162]
  KL2(49,:) = [    0,    0,    0]
  KL2(50,:) = [    0,    0,    0]
  KL2(51,:) = [    0,    0,    0]
  KL2 = (1._/**/REALKIND / 9) * KL2

  KL2ct(1,:) = [ 16, -2,  6]
  KL2ct(2,:) = [ -2, 16,  6]
  KL2ct(3,:) = [  6,  6, 18]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [   48,   -6,   18]
  KL2ct2( 2,:) = [   -6,   48,   18]
  KL2ct2( 3,:) = [   18,   18,   54]
  KL2ct2( 4,:) = [   64,   -8,   24]
  KL2ct2( 5,:) = [   -8,   64,   24]
  KL2ct2( 6,:) = [   24,   24,   72]
  KL2ct2( 7,:) = [   -1,  -10,  -24]
  KL2ct2( 8,:) = [  -10,   -1,  -24]
  KL2ct2( 9,:) = [  -24,  -24,  -72]
  KL2ct2(10,:) = [   64,   -8,   24]
  KL2ct2(11,:) = [   -8,   64,   24]
  KL2ct2(12,:) = [   24,   24,   72]
  KL2ct2(13,:) = [    0,    0,    0]
  KL2ct2(14,:) = [    0,    0,    0]
  KL2ct2(15,:) = [    0,    0,    0]
  KL2ct2(16,:) = [    0,    0,    0]
  KL2ct2(17,:) = [    0,    0,    0]
  KL2ct2(18,:) = [    0,    0,    0]
  KL2ct2(19,:) = [    0,    0,    0]
  KL2ct2(20,:) = [    0,    0,    0]
  KL2ct2(21,:) = [    0,    0,    0]
  KL2ct2(22,:) = [    9,    9,   27]
  KL2ct2(23,:) = [    9,  -72,  -27]
  KL2ct2(24,:) = [   27,  -27,    0]
  KL2ct2(25,:) = [  -72,    9,  -27]
  KL2ct2(26,:) = [    9,    9,   27]
  KL2ct2(27,:) = [  -27,   27,    0]
  KL2ct2(28,:) = [    0,    0,    0]
  KL2ct2(29,:) = [    0,    0,    0]
  KL2ct2(30,:) = [    0,    0,    0]
  KL2ct2(31,:) = [  144,  -18,   54]
  KL2ct2(32,:) = [  -18,  144,   54]
  KL2ct2(33,:) = [   54,   54,  162]
  KL2ct2(34,:) = [  -72,    9,  -27]
  KL2ct2(35,:) = [    9,    9,   27]
  KL2ct2(36,:) = [  -27,   27,    0]
  KL2ct2(37,:) = [    9,    9,   27]
  KL2ct2(38,:) = [    9,  -72,  -27]
  KL2ct2(39,:) = [   27,  -27,    0]
  KL2ct2(40,:) = [    0,    0,    0]
  KL2ct2(41,:) = [    0,    0,    0]
  KL2ct2(42,:) = [    0,    0,    0]
  KL2ct2(43,:) = [  -81,    0,  -54]
  KL2ct2(44,:) = [    0,  -81,  -54]
  KL2ct2(45,:) = [  -54,  -54, -162]
  KL2ct2(46,:) = [  144,  -18,   54]
  KL2ct2(47,:) = [  -18,  144,   54]
  KL2ct2(48,:) = [   54,   54,  162]
  KL2ct2(49,:) = [    0,    0,    0]
  KL2ct2(50,:) = [    0,    0,    0]
  KL2ct2(51,:) = [    0,    0,    0]
  KL2ct2 = (1._/**/REALKIND / 9) * KL2ct2

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppajj2_bbxagg_1_/**/REALKIND



module ol_forced_parameters_ppajj2_bbxagg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppajj2_bbxagg_1_/**/REALKIND

module ol_loop_ppajj2_bbxagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(8), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:25)
  ! denominators
  complex(REALKIND), save :: den(12)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,32), Mct(3,32), Mcol_loop(3,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = CI*countertermnorm*eQED*gQCD**4
    f(2) = (countertermnorm*eQED*gQCD**4)/3._/**/REALKIND
    f(3) = (countertermnorm*ctGbb*eQED*gQCD**4)/3._/**/REALKIND
    f(4) = (countertermnorm*ctVbb*eQED*gQCD**4)/3._/**/REALKIND
    f(5) = (countertermnorm*ctVVV*eQED*gQCD**4)/3._/**/REALKIND
    f(6) = (eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(7) = (2*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(8) = (4*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(0), M2(3)
  complex(REALKIND) :: A(10)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMB, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rMB, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rMB, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rMB, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call counter_VGG_G(ctAGGG,wf(:,-2),wf(:,-3),wf(:,-4),wf(:,2))
  call counter_VGG_G(ctAGGG,wf(:,-2),wf(:,-4),wf(:,-3),wf(:,3))
  call vert_VQ_A(wf(:,-2),wf(:,0),wf(:,4))
  call counter_UV_W(wf(:,-3),Q(:,8),wf(:,-4),Q(:,16),wf(:,5))
  call prop_Q_A(wf(:,4),Q(:,5),MB,1_intkind1,wf(:,6))
  call vert_QA_V(wf(:,6),wf(:,-1),wf(:,7))
  call vert_AV_Q(wf(:,-1),wf(:,-2),wf(:,8))
  call prop_A_Q(wf(:,8),Q(:,6),MB,1_intkind1,wf(:,9))
  call vert_QA_V(wf(:,0),wf(:,9),wf(:,10))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,-4),Q(:,16),wf(:,11))
  call counter_QA_V(wf(:,6),wf(:,-1),wf(:,12))
  call counter_AV_Q(wf(:,-1),wf(:,-2),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,6),MB,1_intkind1,wf(:,14))
  call vert_QA_V(wf(:,0),wf(:,14),wf(:,15))
  call counter_QA_V(wf(:,0),wf(:,9),wf(:,16))
  call counter_VQ_A(wf(:,-2),wf(:,0),wf(:,17))
  call prop_Q_A(wf(:,17),Q(:,5),MB,1_intkind1,wf(:,18))
  call vert_QA_V(wf(:,18),wf(:,-1),wf(:,19))
  call vert_AV_Q(wf(:,-1),wf(:,11),wf(:,20))
  call counter_Q_A(ctbb,5,wf(:,6),Q(:,5),wf(:,21))
  call prop_A_Q(wf(:,20),Q(:,26),MB,1_intkind1,wf(:,22))
  call vert_VQ_A(wf(:,11),wf(:,0),wf(:,23))
  call counter_A_Q(ctbb,5,wf(:,9),Q(:,6),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,25),MB,1_intkind1,wf(:,25))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3))
  den(2) = 1 / (Q(5,5) - MB2)
  den(3) = 1 / (Q(5,24))
  den(5) = 1 / (Q(5,6) - MB2)
  den(7) = 1 / (Q(5,26) - MB2)
  den(10) = 1 / (Q(5,25) - MB2)

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(3)*den(5)
  den(8) = den(3)*den(7)
  den(9) = den(2)*den(8)
  den(11) = den(3)*den(10)
  den(12) = den(5)*den(11)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(10)


  A(1) = cont_VV(wf(:,1),wf(:,2)) * den(1)
  A(2) = cont_VV(wf(:,1),wf(:,3)) * den(1)
  A(3) = cont_VV(wf(:,5),wf(:,7)) * den(4)
  A(4) = cont_VV(wf(:,5),wf(:,10)) * den(6)
  A(5) = cont_VV(wf(:,11),wf(:,12)) * den(4)
  A(6) = cont_VV(wf(:,11),wf(:,15)) * den(6)
  A(7) = cont_VV(wf(:,11),wf(:,16)) * den(6)
  A(8) = cont_VV(wf(:,11),wf(:,19)) * den(4)
  A(9) = cont_QA(wf(:,21),wf(:,22)) * den(9)
  A(10) = cont_QA(wf(:,24),wf(:,25)) * den(12)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(10)
  complex(REALKIND), intent(out) :: M1(0), M2(3)


  M2(1) = -(A(1)*f(1))/2._/**/REALKIND+CI*(A(9)+A(10))*f(2)+CI*(-A(5)-A(7))*f(3)+CI*(-A(6)-A(8))*f(4)+CI*(-A(3)-A(4))*f(5)
  M2(2) = -(A(2)*f(1))/2._/**/REALKIND+CI*(-A(9)-A(10))*f(2)+CI*(A(5)+A(7))*f(3)+CI*(A(6)+A(8))*f(4)+CI*(A(3)+A(4))*f(5)
  M2(3) = ((A(1)+A(2))*f(1))/6._/**/REALKIND

end subroutine colourvectors

end module ol_loop_ppajj2_bbxagg_1_/**/REALKIND
