
module ol_vamp_1_ppaatt_ttxaagg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaatt_ttxaagg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaatt_ttxaagg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppaatt_ttxaagg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppaatt_ttxaagg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppaatt_ttxaagg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppaatt_ttxaagg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(3,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,1,16,2,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(25),n2h32(25))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,8,4,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,16,1,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(27),n2h32(26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,1,4,8,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,1,4,16,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,4,8,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,2,16,1,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(31),n2h32(27))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,4,8,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,16,1,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(33),n2h32(28))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,1,8,4,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,8,16,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(35),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,8,4,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,16,2,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(37),n2h32(29))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,16,8,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,16,2,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(39),n2h32(30))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,16,4,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nMT,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,nMT,G2H16(3),n2h16(3))
  call Hloop_AV_Q(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(4),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex4(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(3),40,nMT,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(9),ex3(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,nMT,G2H16(7),n2h16(7))
  call Hloop_QV_A(ntryL,G1H32(10),ex3(:),G1H16(3),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex2(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(13),ex4(:),G1H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),40,nMT,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(11),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(5),36,nMT,G2H16(12),n2h16(12))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(10),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(11),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(12),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AV_Q(ntryL,G1H32(25),ex3(:),G1H16(13),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(13),36,nMT,G2H16(13),n2h16(13))
  call Hloop_VA_Q(ntryL,G1H32(26),ex2(:),G1H16(13),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(13),34,nMT,G2H16(14),n2h16(14))
  call Hloop_QA_V(ntryL,G1H32(27),ex2(:),G1H16(13),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_VQ_A(ntryL,G1H32(28),ex1(:),G1H16(14),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(14),33,nMT,G2H16(15),n2h16(15))
  call Hloop_VQ_A(ntryL,G1H32(29),ex1(:),G1H16(14),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H16(14),33,nMT,G2H16(16),n2h16(16))
  call Hloop_VQ_A(ntryL,G1H32(30),ex1(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(14),33,nMT,G2H16(17),n2h16(17))
  call Hloop_QV_A(ntryL,G1H32(31),ex3(:),G1H16(14),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(14),36,nMT,G2H16(18),n2h16(18))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(14),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(14),34,nMT,G2H16(19),n2h16(19))
  call Hloop_QA_V(ntryL,G1H32(33),ex2(:),G1H16(14),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_VQ_A(ntryL,G1H32(34),ex1(:),G1H16(15),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(15),33,nMT,G2H16(20),n2h16(20))
  call Hloop_VQ_A(ntryL,G1H32(35),ex1(:),G1H16(15),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(15),33,nMT,G2H16(21),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H32(36),ex1(:),G1H16(15),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(15),33,nMT,G2H16(22),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H32(37),ex1(:),G1H16(15),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(16),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(16),33,nMT,G2H16(23),n2h16(23))
  call Hloop_AQ_V(ntryL,G1H32(39),ex1(:),G1H16(16),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(17),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(17),33,nMT,G2H16(24),n2h16(24))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
  call HG1shiftOLR(G1H16(18),16,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(4),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(5),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(5),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(23),G1H16(24),G1H16(25),G1H16(26),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(3),mass5set(:,1),  & 
G1H16(27),G1H16(28),G1H16(29),G1H16(30),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(28),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(8),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(9),n2h8(4))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex2(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(6),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(11),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(12),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(13),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(14),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(15),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(16),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(17),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(18),n2h8(12))
  call Hloop_AQ_V(ntryL,G2H16(13),ex1(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(7),mass5set(:,2),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(6),16,16)
  call Hloop_UV_W(ntryL,G1H16(13),34,ex5(:),16,G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(8),mass5set(:,2),  & 
G1H16(11),G1H16(12),G1H16(13),G1H16(49),G1H16(50),G1H16(51),16)
  call HG1shiftOLR(G1H16(12),16,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(9),mass5set(:,2),  & 
G1H16(52),G1H16(53),G1H16(54),G1H16(55),G1H16(56),G1H16(57),16)
  call HG1shiftOLR(G1H16(53),2,16)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(8),mass5set(:,2),  & 
G1H16(58),G1H16(59),G1H16(60),G1H16(61),G1H16(62),G1H16(63),16)
  call HG1shiftOLR(G1H16(59),2,16)
  call Hloop_QA_V(ntryL,G2H16(18),ex2(:),G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(10),mass5set(:,2),  & 
G1H16(64),G1H16(65),G1H16(66),G1H16(67),G1H16(68),G1H16(69),16)
  call HG1shiftOLR(G1H16(65),16,16)
  call Hloop_UV_W(ntryL,G1H16(14),34,ex5(:),16,G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(11),mass5set(:,2),  & 
G1H16(14),G1H16(70),G1H16(71),G1H16(72),G1H16(73),G1H16(74),16)
  call HG1shiftOLR(G1H16(70),16,16)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(12),mass5set(:,2),  & 
G1H16(75),G1H16(76),G1H16(77),G1H16(78),G1H16(79),G1H16(80),16)
  call HG1shiftOLR(G1H16(76),2,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(11),mass5set(:,2),  & 
G1H16(81),G1H16(82),G1H16(83),G1H16(84),G1H16(85),G1H16(86),16)
  call HG1shiftOLR(G1H16(82),2,16)
  call Hloop_UV_W(ntryL,G1H16(15),33,ex5(:),16,G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(13),mass5set(:,2),  & 
G1H16(15),G1H16(87),G1H16(88),G1H16(89),G1H16(90),G1H16(91),16)
  call HG1shiftOLR(G1H16(87),2,16)
  call Hloop_UV_W(ntryL,G1H16(16),33,ex5(:),16,G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(14),mass5set(:,2),  & 
G1H16(16),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G1H16(96),16)
  call HG1shiftOLR(G1H16(92),2,16)
  call Hloop_AV_Q(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(25),n2h8(13))
call HGT_OLR(G1H16(18),1,1,16)
call HGT_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(18),-16,nMT,G2H16(1),n2h16(25))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AV_Q(ntryL,G1H16(20),ex3(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(27),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(21),ex3(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(28),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(22),ex3(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(29),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(30),n2h8(17))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,nMT,G2H16(2),n2h16(26))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AV_Q(ntryL,G1H16(24),ex4(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(32),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(25),ex4(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(33),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(26),ex4(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(34),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(27),ex5(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(35),n2h8(21))
call HGT_OLR(G1H16(28),1,1,16)
call HGT_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(28),-8,nMT,G2H16(3),n2h16(27))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(37),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(31),ex5(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(38),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(32),ex5(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(39),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(40),n2h8(25))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,nMT,G2H16(4),n2h16(28))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QV_A(ntryL,G1H16(34),ex3(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(42),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(35),ex3(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(43),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(36),ex3(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(44),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(37),ex4(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(45),n2h8(29))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-16,nMT,G2H16(5),n2h16(29))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QV_A(ntryL,G1H16(40),ex4(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(47),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(41),ex4(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(48),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(42),ex4(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(49),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(50),n2h8(33))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-8,nMT,G2H16(6),n2h16(30))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AV_Q(ntryL,G1H16(46),ex5(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(52),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(47),ex5(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(53),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(54),n2h8(36))
  call Hloop_AV_Q(ntryL,G1H16(5),ex4(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(55),n2h8(37))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(6),-16,ex5(:),16,G2H8(56),m3h2x8(:,56),heltab2x16(:,:,56))
call signflip_OLR(G2H8(56))
  call Hloop_AV_Q(ntryL,G1H16(8),ex4(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(57),n2h8(38))
  call Hloop_AV_Q(ntryL,G1H16(9),ex4(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(58),n2h8(39))
  call Hloop_AV_Q(ntryL,G1H16(10),ex4(:),G1H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(59),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(60),n2h8(41))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(12),-16,ex5(:),16,G2H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
call signflip_OLR(G2H8(61))
  call Hloop_QV_A(ntryL,G1H16(49),ex3(:),G1H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(62),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(50),ex3(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(63),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(51),ex3(:),G1H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(64),n2h8(44))
  call Hloop_QV_A(ntryL,G1H16(52),ex3(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(65),n2h8(45))
call HGT_raise_alpha_OLR(G1H16(53),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(53),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(53),ex2(:),G1H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_QV_A(ntryL,G1H16(55),ex3(:),G1H8(2),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(66),n2h8(46))
  call Hloop_QV_A(ntryL,G1H16(56),ex3(:),G1H8(2),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(67),n2h8(47))
  call Hloop_QV_A(ntryL,G1H16(57),ex3(:),G1H8(2),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(68),n2h8(48))
  call Hloop_QV_A(ntryL,G1H16(58),ex3(:),G1H8(2),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(69),n2h8(49))
call HGT_raise_alpha_OLR(G1H16(59),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(59),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(59),ex2(:),G1H8(2),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QV_A(ntryL,G1H16(61),ex3(:),G1H8(3),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(70),n2h8(50))
  call Hloop_QV_A(ntryL,G1H16(62),ex3(:),G1H8(3),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(71),n2h8(51))
  call Hloop_QV_A(ntryL,G1H16(63),ex3(:),G1H8(3),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(72),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H16(64),ex3(:),G1H8(3),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(73),n2h8(53))
call HGT_raise_alpha_OLR(G1H16(65),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(65),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(65),-16,ex5(:),16,G2H8(74),m3h2x8(:,76),heltab2x16(:,:,76))
call signflip_OLR(G2H8(74))
  call Hloop_AV_Q(ntryL,G1H16(67),ex3(:),G1H8(3),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(75),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(68),ex3(:),G1H8(3),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(76),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(69),ex3(:),G1H8(3),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(77),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(14),ex4(:),G1H8(3),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(78),n2h8(57))
call HGT_raise_alpha_OLR(G1H16(70),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(70),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(70),-16,ex5(:),16,G2H8(79),m3h2x8(:,81),heltab2x16(:,:,81))
call signflip_OLR(G2H8(79))
  call Hloop_QV_A(ntryL,G1H16(72),ex4(:),G1H8(3),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(80),n2h8(58))
  call Hloop_QV_A(ntryL,G1H16(73),ex4(:),G1H8(3),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(81),n2h8(59))
  call Hloop_QV_A(ntryL,G1H16(74),ex4(:),G1H8(3),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(82),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(75),ex4(:),G1H8(3),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(83),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(76),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(76),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(76),ex2(:),G1H8(3),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_QV_A(ntryL,G1H16(78),ex4(:),G1H8(4),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(84),n2h8(62))
  call Hloop_QV_A(ntryL,G1H16(79),ex4(:),G1H8(4),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(85),n2h8(63))
  call Hloop_QV_A(ntryL,G1H16(80),ex4(:),G1H8(4),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(86),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(81),ex4(:),G1H8(4),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(87),n2h8(65))
call HGT_raise_alpha_OLR(G1H16(82),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(82),ex2(:),G1H8(4),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_QV_A(ntryL,G1H16(84),ex4(:),G1H8(5),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(88),n2h8(66))
  call Hloop_QV_A(ntryL,G1H16(85),ex4(:),G1H8(5),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(89),n2h8(67))
  call Hloop_QV_A(ntryL,G1H16(86),ex4(:),G1H8(5),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(90),n2h8(68))
  call Hloop_QV_A(ntryL,G1H16(15),ex5(:),G1H8(5),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(91),n2h8(69))
call HGT_raise_alpha_OLR(G1H16(87),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(87),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(87),ex2(:),G1H8(5),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_QV_A(ntryL,G1H16(89),ex5(:),G1H8(6),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(92),n2h8(70))
  call Hloop_QV_A(ntryL,G1H16(90),ex5(:),G1H8(6),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(93),n2h8(71))
  call Hloop_QV_A(ntryL,G1H16(91),ex5(:),G1H8(6),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(94),n2h8(72))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(6),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(95),n2h8(73))
call HGT_raise_alpha_OLR(G1H16(92),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(92),ex2(:),G1H8(6),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_QV_A(ntryL,G1H16(94),ex5(:),G1H8(7),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(96),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(95),ex5(:),G1H8(7),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(97),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(96),ex5(:),G1H8(7),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(98),n2h8(76))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(15),mass5set(:,3),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(16),mass5set(:,3),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(16),mass5set(:,3),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(17),mass5set(:,4),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(17),mass5set(:,4),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(18),mass5set(:,3),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(19),mass5set(:,3),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(20),mass5set(:,4),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(20),mass5set(:,4),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(19),mass5set(:,3),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(21),mass5set(:,4),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(21),mass5set(:,4),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(22),mass5set(:,4),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(22),mass5set(:,4),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(23),mass5set(:,4),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(23),mass5set(:,4),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(24),mass5set(:,4),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(24),mass5set(:,4),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(25),mass5set(:,5),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),8,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(26),mass5set(:,6),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(27),mass5set(:,5),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),8,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(26),mass5set(:,6),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),4,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(28),mass5set(:,6),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(28),mass5set(:,6),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),4,8)
  call Hloop_AQ_V(ntryL,G2H8(25),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(29),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(30),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(33),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(34),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(35),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(38),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(40),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(43),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(44),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(45),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(50),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(53),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(54),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(7),mass5set(:,2),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(29),mass5set(:,7),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),16,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(30),mass5set(:,7),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),16,8)
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(8),mass5set(:,2),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),16,8)
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(31),mass5set(:,7),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),16,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(32),mass5set(:,7),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(9),mass5set(:,2),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),2,8)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(33),mass5set(:,2),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),2,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(34),mass5set(:,2),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),2,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(8),mass5set(:,2),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),2,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(35),mass5set(:,2),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),2,8)
  call Hotf_5pt_reduction(G2H8(72),RedSet_5(34),mass5set(:,2),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),2,8)
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(10),mass5set(:,2),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),16,8)
  call Hotf_5pt_reduction(G2H8(76),RedSet_5(29),mass5set(:,7),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),16,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(36),mass5set(:,7),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),16,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(11),mass5set(:,2),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),16,8)
  call Hotf_5pt_reduction(G2H8(81),RedSet_5(31),mass5set(:,7),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),16,8)
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(37),mass5set(:,7),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),16,8)
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(12),mass5set(:,2),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),2,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(38),mass5set(:,2),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),2,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(39),mass5set(:,2),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),2,8)
  call Hotf_5pt_reduction(G2H8(87),RedSet_5(11),mass5set(:,2),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),2,8)
  call Hotf_5pt_reduction(G2H8(89),RedSet_5(35),mass5set(:,2),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),2,8)
  call Hotf_5pt_reduction(G2H8(90),RedSet_5(39),mass5set(:,2),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),2,8)
  call Hotf_5pt_reduction(G2H8(91),RedSet_5(13),mass5set(:,2),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),2,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(38),mass5set(:,2),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),2,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(40),mass5set(:,2),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),2,8)
  call Hotf_5pt_reduction(G2H8(95),RedSet_5(14),mass5set(:,2),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),2,8)
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(33),mass5set(:,2),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),2,8)
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(40),mass5set(:,2),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),2,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(157),[G1H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(163),[G1H8(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(181),[G1H8(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(193),[G1H8(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(199),[G1H8(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(211),[G1H8(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(217),[G1H8(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(229),[G1H8(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(235),[G1H8(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(253),[G1H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(265),[G1H8(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(271),[G1H8(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(283),[G1H8(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(289),[G1H8(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(301),[G1H8(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(307),[G1H8(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(319),[G1H8(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(318)])
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(19),n2h4(1))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nMT,G2H8(1),n2h8(77))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(21),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(22),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(23),n2h4(4))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,nMT,G2H8(2),n2h8(78))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(25),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(26),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(27),n2h4(7))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-8,nMT,G2H8(3),n2h8(79))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(29),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(30),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(31),n2h4(10))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,nMT,G2H8(4),n2h8(80))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(33),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(34),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(35),n2h4(13))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,nMT,G2H8(5),n2h8(81))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QV_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(37),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(38),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(39),n2h4(16))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-16,nMT,G2H8(6),n2h8(82))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(41),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(42),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(43),n2h4(19))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,nMT,G2H8(7),n2h8(83))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(45),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(46),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(47),n2h4(22))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-16,nMT,G2H8(8),n2h8(84))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(49),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(50),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(55),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(51),n2h4(25))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-4,nMT,G2H8(9),n2h8(85))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(59),ex4(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(53),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(60),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(54),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(55),n2h4(28))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,nMT,G2H8(10),n2h8(86))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(57),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(66),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(58),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(59),n2h4(31))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-8,nMT,G2H8(11),n2h8(87))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(61),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(62),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(63),n2h4(34))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-4,nMT,G2H8(12),n2h8(88))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(65),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(66),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(67),n2h4(37))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-16,nMT,G2H8(13),n2h8(89))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_AV_Q(ntryL,G1H8(83),ex3(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(69),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(70),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(85),ex3(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(71),n2h4(40))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,nMT,G2H8(14),n2h8(90))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AV_Q(ntryL,G1H8(89),ex3(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(73),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(90),ex3(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(74),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(91),ex4(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(75),n2h4(43))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-16,nMT,G2H8(15),n2h8(91))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(77),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(78),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(97),ex4(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(79),n2h4(46))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-4,nMT,G2H8(16),n2h8(92))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(101),ex4(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(81),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(102),ex4(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(82),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(83),n2h4(49))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,nMT,G2H8(17),n2h8(93))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(85),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(86),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(109),ex5(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(87),n2h4(52))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-4,nMT,G2H8(18),n2h8(94))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(113),ex5(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(89),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(114),ex5(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(90),n2h4(54))
  call Hloop_UV_W(ntryL,G1H8(115),37,ex5(:),16,G2H4(91),m3h2x4(:,91),heltab2x8(:,:,91))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(116),-8,nMT,G2H8(19),n2h8(95))
  call Hloop_QV_A(ntryL,G2H8(19),ex4(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_UV_W(ntryL,G1H8(119),37,ex5(:),16,G2H4(93),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_UV_W(ntryL,G1H8(120),37,ex5(:),16,G2H4(94),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VQ_A(ntryL,G1H8(121),ex1(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(95),n2h4(55))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-8,nMT,G2H8(20),n2h8(96))
  call Hloop_AV_Q(ntryL,G2H8(20),ex4(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_VQ_A(ntryL,G1H8(125),ex1(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(97),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H8(126),ex1(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(98),n2h4(57))
  call Hloop_UV_W(ntryL,G1H8(127),38,ex5(:),16,G2H4(99),m3h2x4(:,99),heltab2x8(:,:,99))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-8,nMT,G2H8(21),n2h8(97))
  call Hloop_AV_Q(ntryL,G2H8(21),ex4(:),G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_UV_W(ntryL,G1H8(131),38,ex5(:),16,G2H4(101),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_UV_W(ntryL,G1H8(132),38,ex5(:),16,G2H4(102),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_VQ_A(ntryL,G1H8(133),ex1(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(103),n2h4(58))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(134),-4,nMT,G2H8(22),n2h8(98))
  call Hloop_AV_Q(ntryL,G2H8(22),ex3(:),G2H4(104),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_VQ_A(ntryL,G1H8(137),ex1(:),G1H4(1),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(105),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H8(138),ex1(:),G1H4(1),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(106),n2h4(60))
  call Hloop_VA_Q(ntryL,G1H8(139),ex2(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(107),n2h4(61))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-8,nMT,G2H8(23),n2h8(99))
  call Hloop_QV_A(ntryL,G2H8(23),ex4(:),G2H4(108),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_VA_Q(ntryL,G1H8(143),ex2(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(109),n2h4(62))
  call Hloop_VA_Q(ntryL,G1H8(144),ex2(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(110),n2h4(63))
  call Hloop_VA_Q(ntryL,G1H8(145),ex2(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(111),n2h4(64))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(146),-4,nMT,G2H8(24),n2h8(100))
  call Hloop_QV_A(ntryL,G2H8(24),ex3(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_VA_Q(ntryL,G1H8(149),ex2(:),G1H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(113),n2h4(65))
  call Hloop_VA_Q(ntryL,G1H8(150),ex2(:),G1H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(114),n2h4(66))
  call Hloop_AV_Q(ntryL,G1H8(151),ex3(:),G1H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(115),n2h4(67))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(152),-16,ex5(:),16,G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
call signflip_OLR(G2H4(116))
  call Hloop_AV_Q(ntryL,G1H8(157),ex3(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(117),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H8(163),ex3(:),G1H4(1),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(118),n2h4(69))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-16,ex5(:),16,G2H4(119),m3h2x4(:,119),heltab2x8(:,:,119))
call signflip_OLR(G2H4(119))
  call Hloop_AV_Q(ntryL,G1H8(161),ex3(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(120),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H8(162),ex3(:),G1H4(1),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(121),n2h4(71))
call HGT_raise_alpha_OLR(G1H8(164),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(164),-16,ex5(:),16,G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
call signflip_OLR(G2H4(122))
  call Hloop_AV_Q(ntryL,G1H8(167),ex3(:),G1H4(1),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(123),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(168),ex3(:),G1H4(1),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(124),n2h4(73))
  call Hloop_QV_A(ntryL,G1H8(169),ex4(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(125),n2h4(74))
call HGT_raise_alpha_OLR(G1H8(170),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(170),-16,ex5(:),16,G2H4(126),m3h2x4(:,126),heltab2x8(:,:,126))
call signflip_OLR(G2H4(126))
  call Hloop_QV_A(ntryL,G1H8(175),ex4(:),G1H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(127),n2h4(75))
  call Hloop_QV_A(ntryL,G1H8(181),ex4(:),G1H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(128),n2h4(76))
call HGT_raise_alpha_OLR(G1H8(176),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(176),-16,ex5(:),16,G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
call signflip_OLR(G2H4(129))
  call Hloop_QV_A(ntryL,G1H8(179),ex4(:),G1H4(1),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(130),n2h4(77))
  call Hloop_QV_A(ntryL,G1H8(180),ex4(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(131),n2h4(78))
call HGT_raise_alpha_OLR(G1H8(182),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(182),-16,ex5(:),16,G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
call signflip_OLR(G2H4(132))
  call Hloop_QV_A(ntryL,G1H8(185),ex4(:),G1H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(133),n2h4(79))
  call Hloop_QV_A(ntryL,G1H8(186),ex4(:),G1H4(1),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(134),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(187),ex5(:),G1H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(135),n2h4(81))
call HGT_raise_alpha_OLR(G1H8(188),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(188),ex2(:),G1H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_QV_A(ntryL,G1H8(193),ex5(:),G1H4(2),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(136),n2h4(82))
  call Hloop_QV_A(ntryL,G1H8(199),ex5(:),G1H4(2),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(137),n2h4(83))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(194),ex2(:),G1H4(2),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_QV_A(ntryL,G1H8(197),ex5(:),G1H4(3),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(138),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(198),ex5(:),G1H4(3),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(139),n2h4(85))
call HGT_raise_alpha_OLR(G1H8(200),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(200),ex2(:),G1H4(3),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_QV_A(ntryL,G1H8(203),ex5(:),G1H4(4),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(140),n2h4(86))
  call Hloop_QV_A(ntryL,G1H8(204),ex5(:),G1H4(4),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(141),n2h4(87))
  call Hloop_QV_A(ntryL,G1H8(205),ex4(:),G1H4(4),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(4),45,nMT,G2H4(142),n2h4(88))
call HGT_raise_alpha_OLR(G1H8(206),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(206),ex2(:),G1H4(4),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(211),ex4(:),G1H4(5),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(143),n2h4(89))
  call Hloop_QV_A(ntryL,G1H8(217),ex4(:),G1H4(5),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(144),n2h4(90))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(212),ex2(:),G1H4(5),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_QV_A(ntryL,G1H8(215),ex4(:),G1H4(6),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(145),n2h4(91))
  call Hloop_QV_A(ntryL,G1H8(216),ex4(:),G1H4(6),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(146),n2h4(92))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(218),ex2(:),G1H4(6),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_QV_A(ntryL,G1H8(221),ex4(:),G1H4(7),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(147),n2h4(93))
  call Hloop_QV_A(ntryL,G1H8(222),ex4(:),G1H4(7),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(148),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(223),ex4(:),G1H4(7),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(149),n2h4(95))
call HGT_raise_alpha_OLR(G1H8(224),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(224),-16,ex5(:),16,G2H4(150),m3h2x4(:,156),heltab2x8(:,:,156))
call signflip_OLR(G2H4(150))
  call Hloop_AV_Q(ntryL,G1H8(229),ex4(:),G1H4(7),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(151),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H8(235),ex4(:),G1H4(7),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(152),n2h4(97))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(230),-16,ex5(:),16,G2H4(153),m3h2x4(:,159),heltab2x8(:,:,159))
call signflip_OLR(G2H4(153))
  call Hloop_AV_Q(ntryL,G1H8(233),ex4(:),G1H4(7),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(154),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H8(234),ex4(:),G1H4(7),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(155),n2h4(99))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(236),-16,ex5(:),16,G2H4(156),m3h2x4(:,162),heltab2x8(:,:,162))
call signflip_OLR(G2H4(156))
  call Hloop_AV_Q(ntryL,G1H8(239),ex4(:),G1H4(7),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(157),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H8(240),ex4(:),G1H4(7),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(158),n2h4(101))
  call Hloop_QV_A(ntryL,G1H8(241),ex3(:),G1H4(7),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(159),n2h4(102))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(242),-16,ex5(:),16,G2H4(160),m3h2x4(:,166),heltab2x8(:,:,166))
call signflip_OLR(G2H4(160))
  call Hloop_QV_A(ntryL,G1H8(247),ex3(:),G1H4(7),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(161),n2h4(103))
  call Hloop_QV_A(ntryL,G1H8(253),ex3(:),G1H4(7),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(162),n2h4(104))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(248),-16,ex5(:),16,G2H4(163),m3h2x4(:,169),heltab2x8(:,:,169))
call signflip_OLR(G2H4(163))
  call Hloop_QV_A(ntryL,G1H8(251),ex3(:),G1H4(7),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(164),n2h4(105))
  call Hloop_QV_A(ntryL,G1H8(252),ex3(:),G1H4(7),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(165),n2h4(106))
call HGT_raise_alpha_OLR(G1H8(254),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(254),-16,ex5(:),16,G2H4(166),m3h2x4(:,172),heltab2x8(:,:,172))
call signflip_OLR(G2H4(166))
  call Hloop_QV_A(ntryL,G1H8(257),ex3(:),G1H4(7),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(167),n2h4(107))
  call Hloop_QV_A(ntryL,G1H8(258),ex3(:),G1H4(7),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(168),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(259),ex5(:),G1H4(7),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(7),57,nMT,G2H4(169),n2h4(109))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(260),ex2(:),G1H4(7),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_QV_A(ntryL,G1H8(265),ex5(:),G1H4(8),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(170),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(271),ex5(:),G1H4(8),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(171),n2h4(111))
call HGT_raise_alpha_OLR(G1H8(266),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(266),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(266),ex2(:),G1H4(8),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_QV_A(ntryL,G1H8(269),ex5(:),G1H4(9),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(9),57,nMT,G2H4(172),n2h4(112))
  call Hloop_QV_A(ntryL,G1H8(270),ex5(:),G1H4(9),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(9),57,nMT,G2H4(173),n2h4(113))
call HGT_raise_alpha_OLR(G1H8(272),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(272),ex2(:),G1H4(9),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QV_A(ntryL,G1H8(275),ex5(:),G1H4(10),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(10),57,nMT,G2H4(174),n2h4(114))
  call Hloop_QV_A(ntryL,G1H8(276),ex5(:),G1H4(10),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(10),57,nMT,G2H4(175),n2h4(115))
  call Hloop_QV_A(ntryL,G1H8(277),ex3(:),G1H4(10),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(10),45,nMT,G2H4(176),n2h4(116))
call HGT_raise_alpha_OLR(G1H8(278),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(278),ex2(:),G1H4(10),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_QV_A(ntryL,G1H8(283),ex3(:),G1H4(11),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(11),45,nMT,G2H4(177),n2h4(117))
  call Hloop_QV_A(ntryL,G1H8(289),ex3(:),G1H4(11),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(11),45,nMT,G2H4(178),n2h4(118))
call HGT_raise_alpha_OLR(G1H8(284),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(284),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(284),ex2(:),G1H4(11),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_QV_A(ntryL,G1H8(287),ex3(:),G1H4(12),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(12),45,nMT,G2H4(179),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(288),ex3(:),G1H4(12),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(12),45,nMT,G2H4(180),n2h4(120))
call HGT_raise_alpha_OLR(G1H8(290),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(290),ex2(:),G1H4(12),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_QV_A(ntryL,G1H8(293),ex3(:),G1H4(13),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(181),n2h4(121))
  call Hloop_QV_A(ntryL,G1H8(294),ex3(:),G1H4(13),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(182),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(295),ex4(:),G1H4(13),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(13),57,nMT,G2H4(183),n2h4(123))
call HGT_raise_alpha_OLR(G1H8(296),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(296),ex2(:),G1H4(13),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QV_A(ntryL,G1H8(301),ex4(:),G1H4(14),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(14),57,nMT,G2H4(184),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(307),ex4(:),G1H4(14),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(14),57,nMT,G2H4(185),n2h4(125))
call HGT_raise_alpha_OLR(G1H8(302),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(302),ex2(:),G1H4(14),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_QV_A(ntryL,G1H8(305),ex4(:),G1H4(15),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(15),57,nMT,G2H4(186),n2h4(126))
  call Hloop_QV_A(ntryL,G1H8(306),ex4(:),G1H4(15),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(15),57,nMT,G2H4(187),n2h4(127))
call HGT_raise_alpha_OLR(G1H8(308),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(308),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(308),ex2(:),G1H4(15),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_QV_A(ntryL,G1H8(311),ex4(:),G1H4(16),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(16),57,nMT,G2H4(188),n2h4(128))
  call Hloop_QV_A(ntryL,G1H8(312),ex4(:),G1H4(16),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(16),57,nMT,G2H4(189),n2h4(129))
  call Hloop_QV_A(ntryL,G1H8(313),ex3(:),G1H4(16),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H4(16),53,nMT,G2H4(190),n2h4(130))
call HGT_raise_alpha_OLR(G1H8(314),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(314),ex2(:),G1H4(16),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_QV_A(ntryL,G1H8(319),ex3(:),G1H4(17),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(191),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(325),ex3(:),G1H4(17),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(192),n2h4(132))
call HGT_raise_alpha_OLR(G1H8(320),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(320),ex2(:),G1H4(17),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_QV_A(ntryL,G1H8(323),ex3(:),G1H4(18),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(18),53,nMT,G2H4(193),n2h4(133))
  call Hloop_QV_A(ntryL,G1H8(324),ex3(:),G1H4(18),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(18),53,nMT,G2H4(194),n2h4(134))
call HGT_raise_alpha_OLR(G1H8(326),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(326),ex2(:),G1H4(18),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_QV_A(ntryL,G1H8(329),ex3(:),G1H4(19),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(19),53,nMT,G2H4(195),n2h4(135))
  call Hloop_QV_A(ntryL,G1H8(330),ex3(:),G1H4(19),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G1H4(19),53,nMT,G2H4(196),n2h4(136))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(41),mass5set(:,8),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(42),mass5set(:,8),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(43),mass5set(:,8),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(41),mass5set(:,8),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(42),mass5set(:,8),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(43),mass5set(:,8),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(15),mass5set(:,3),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(44),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(16),mass5set(:,3),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(45),mass5set(:,3),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(16),mass5set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(46),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(17),mass5set(:,4),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(47),mass5set(:,4),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(17),mass5set(:,4),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(48),mass5set(:,4),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(18),mass5set(:,3),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(49),mass5set(:,3),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(19),mass5set(:,3),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(50),mass5set(:,3),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),16,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(20),mass5set(:,4),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(47),mass5set(:,4),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(20),mass5set(:,4),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),4,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(51),mass5set(:,4),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(19),mass5set(:,3),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(52),mass5set(:,3),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),8,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(21),mass5set(:,4),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(48),mass5set(:,4),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),8,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(21),mass5set(:,4),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(51),mass5set(:,4),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(22),mass5set(:,4),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),16,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(53),mass5set(:,4),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),16,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(22),mass5set(:,4),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(54),mass5set(:,4),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),8,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(23),mass5set(:,4),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),16,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(53),mass5set(:,4),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),16,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(23),mass5set(:,4),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),4,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(55),mass5set(:,4),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),4,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(24),mass5set(:,4),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),8,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(54),mass5set(:,4),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(24),mass5set(:,4),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),4,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(55),mass5set(:,4),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),4,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(25),mass5set(:,5),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),8,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(46),mass5set(:,3),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),8,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(26),mass5set(:,6),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),8,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(56),mass5set(:,6),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),8,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(27),mass5set(:,5),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),8,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(52),mass5set(:,3),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(26),mass5set(:,6),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),4,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(57),mass5set(:,6),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),4,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(28),mass5set(:,6),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),8,4)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(58),mass5set(:,6),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),8,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(28),mass5set(:,6),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),4,4)
  call Hotf_5pt_reduction(G2H4(114),RedSet_5(59),mass5set(:,6),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),4,4)
  call Hloop_AQ_V(ntryL,G2H4(115),ex1(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(118),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(124),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(125),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(128),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(134),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(9),mass5set(:,2),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),2,4)
  call Hotf_5pt_reduction(G2H4(137),RedSet_5(34),mass5set(:,2),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),2,4)
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(1),mass4set(:,1),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),4)
  call HG1shiftOLR(G1H4(392),26,4)
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(8),mass5set(:,2),  & 
G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),4)
  call HG1shiftOLR(G1H4(397),2,4)
  call Hotf_5pt_reduction(G2H4(144),RedSet_5(34),mass5set(:,2),  & 
G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),4)
  call HG1shiftOLR(G1H4(403),2,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(1),mass4set(:,1),  & 
G1H4(408),G1H4(409),G1H4(410),G1H4(411),G1H4(412),4)
  call HG1shiftOLR(G1H4(409),26,4)
  call Hloop_AQ_V(ntryL,G2H4(149),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(152),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(158),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(159),ex2(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(162),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(168),ex2(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(169),RedSet_5(12),mass5set(:,2),  & 
G1H4(413),G1H4(414),G1H4(415),G1H4(416),G1H4(417),G1H4(418),4)
  call HG1shiftOLR(G1H4(414),2,4)
  call Hotf_5pt_reduction(G2H4(171),RedSet_5(39),mass5set(:,2),  & 
G1H4(419),G1H4(420),G1H4(421),G1H4(422),G1H4(423),G1H4(424),4)
  call HG1shiftOLR(G1H4(420),2,4)
  call Hotf_4pt_reduction(G2H4(175),RedSet_4(2),mass4set(:,1),  & 
G1H4(425),G1H4(426),G1H4(427),G1H4(428),G1H4(429),4)
  call HG1shiftOLR(G1H4(426),22,4)
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(11),mass5set(:,2),  & 
G1H4(430),G1H4(431),G1H4(432),G1H4(433),G1H4(434),G1H4(435),4)
  call HG1shiftOLR(G1H4(431),2,4)
  call Hotf_5pt_reduction(G2H4(178),RedSet_5(39),mass5set(:,2),  & 
G1H4(436),G1H4(437),G1H4(438),G1H4(439),G1H4(440),G1H4(441),4)
  call HG1shiftOLR(G1H4(437),2,4)
  call Hotf_4pt_reduction(G2H4(182),RedSet_4(2),mass4set(:,1),  & 
G1H4(442),G1H4(443),G1H4(444),G1H4(445),G1H4(446),4)
  call HG1shiftOLR(G1H4(443),22,4)
  call Hotf_5pt_reduction(G2H4(183),RedSet_5(13),mass5set(:,2),  & 
G1H4(447),G1H4(448),G1H4(449),G1H4(450),G1H4(451),G1H4(452),4)
  call HG1shiftOLR(G1H4(448),2,4)
  call Hotf_5pt_reduction(G2H4(185),RedSet_5(40),mass5set(:,2),  & 
G1H4(453),G1H4(454),G1H4(455),G1H4(456),G1H4(457),G1H4(458),4)
  call HG1shiftOLR(G1H4(454),2,4)
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(3),mass4set(:,1),  & 
G1H4(459),G1H4(460),G1H4(461),G1H4(462),G1H4(463),4)
  call HG1shiftOLR(G1H4(460),14,4)
  call Hotf_5pt_reduction(G2H4(190),RedSet_5(14),mass5set(:,2),  & 
G1H4(464),G1H4(465),G1H4(466),G1H4(467),G1H4(468),G1H4(469),4)
  call HG1shiftOLR(G1H4(465),2,4)
  call Hotf_5pt_reduction(G2H4(192),RedSet_5(40),mass5set(:,2),  & 
G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),G1H4(475),4)
  call HG1shiftOLR(G1H4(471),2,4)
  call Hotf_4pt_reduction(G2H4(196),RedSet_4(3),mass4set(:,1),  & 
G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),4)
  call HG1shiftOLR(G1H4(477),14,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(313),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(325),[G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(337),[G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(361),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(373),[G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(385),[G1H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(391),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(402),[G1H4(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(408),[G1H4(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(419),[G1H4(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(425),[G1H4(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(436),[G1H4(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(442),[G1H4(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(453),[G1H4(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(459),[G1H4(458)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(470),[G1H4(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(476),[G1H4(475)])
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(13),n2h2(1))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,nMT,G2H4(1),n2h4(137))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(15),n2h2(2))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,nMT,G2H4(3),n2h4(138))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(17),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(18),n2h2(4))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,nMT,G2H4(4),n2h4(139))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(37),ex2(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(20),n2h2(5))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,nMT,G2H4(6),n2h4(140))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(42),ex2(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(22),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(23),n2h2(7))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,nMT,G2H4(7),n2h4(141))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(25),n2h2(8))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-8,nMT,G2H4(9),n2h4(142))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(27),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(28),n2h2(10))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,nMT,G2H4(10),n2h4(143))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(30),n2h2(11))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,nMT,G2H4(12),n2h4(144))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(32),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(67),ex1(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(33),n2h2(13))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-16,nMT,G2H4(13),n2h4(145))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(35),n2h2(14))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,nMT,G2H4(15),n2h4(146))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(37),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(79),ex2(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(38),n2h2(16))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-8,nMT,G2H4(16),n2h4(147))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(85),ex2(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(40),n2h2(17))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-8,nMT,G2H4(18),n2h4(148))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VA_Q(ntryL,G1H4(90),ex2(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(42),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(91),ex3(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(43),n2h2(19))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-16,nMT,G2H4(19),n2h4(149))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(97),ex3(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(45),n2h2(20))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-16,nMT,G2H4(22),n2h4(150))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QV_A(ntryL,G1H4(102),ex3(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(47),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(103),ex4(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(48),n2h2(22))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-16,nMT,G2H4(23),n2h4(151))
  call Hloop_QV_A(ntryL,G2H4(23),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AV_Q(ntryL,G1H4(109),ex4(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(50),n2h2(23))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-16,nMT,G2H4(26),n2h4(152))
  call Hloop_QV_A(ntryL,G2H4(26),ex5(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AV_Q(ntryL,G1H4(114),ex4(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(52),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(115),ex5(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(53),n2h2(25))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(116),-8,nMT,G2H4(27),n2h4(153))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(55),n2h2(26))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(122),-8,nMT,G2H4(30),n2h4(154))
  call Hloop_QV_A(ntryL,G2H4(30),ex4(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AV_Q(ntryL,G1H4(126),ex5(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(57),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(127),ex4(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(58),n2h2(28))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(128),-16,nMT,G2H4(31),n2h4(155))
  call Hloop_AV_Q(ntryL,G2H4(31),ex5(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QV_A(ntryL,G1H4(133),ex4(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(60),n2h2(29))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(134),-16,nMT,G2H4(34),n2h4(156))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QV_A(ntryL,G1H4(138),ex4(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(62),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(139),ex5(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(63),n2h2(31))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(140),-8,nMT,G2H4(35),n2h4(157))
  call Hloop_AV_Q(ntryL,G2H4(35),ex4(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(145),ex5(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(65),n2h2(32))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-8,nMT,G2H4(38),n2h4(158))
  call Hloop_AV_Q(ntryL,G2H4(38),ex4(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(150),ex5(:),G1H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(67),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(151),ex3(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(68),n2h2(34))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-16,nMT,G2H4(39),n2h4(159))
  call Hloop_QV_A(ntryL,G2H4(39),ex5(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AV_Q(ntryL,G1H4(157),ex3(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(70),n2h2(35))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(158),-16,nMT,G2H4(42),n2h4(160))
  call Hloop_QV_A(ntryL,G2H4(42),ex5(:),G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AV_Q(ntryL,G1H4(162),ex3(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(72),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(163),ex4(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(73),n2h2(37))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(164),-16,nMT,G2H4(43),n2h4(161))
  call Hloop_AV_Q(ntryL,G2H4(43),ex5(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(169),ex4(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(75),n2h2(38))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-16,nMT,G2H4(46),n2h4(162))
  call Hloop_AV_Q(ntryL,G2H4(46),ex5(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QV_A(ntryL,G1H4(174),ex4(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(77),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(175),ex3(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(78),n2h2(40))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-16,nMT,G2H4(47),n2h4(163))
  call Hloop_AV_Q(ntryL,G2H4(47),ex5(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QV_A(ntryL,G1H4(181),ex3(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(80),n2h2(41))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-16,nMT,G2H4(50),n2h4(164))
  call Hloop_AV_Q(ntryL,G2H4(50),ex5(:),G2H2(81),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_QV_A(ntryL,G1H4(186),ex3(:),G1H2(1),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(82),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(187),ex5(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(83),n2h2(43))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-4,nMT,G2H4(51),n2h4(165))
  call Hloop_AV_Q(ntryL,G2H4(51),ex3(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(193),ex5(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(85),n2h2(44))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-4,nMT,G2H4(54),n2h4(166))
  call Hloop_AV_Q(ntryL,G2H4(54),ex3(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QV_A(ntryL,G1H4(198),ex5(:),G1H2(1),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(87),n2h2(45))
  call Hloop_QV_A(ntryL,G1H4(199),ex5(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(88),n2h2(46))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(200),-8,nMT,G2H4(55),n2h4(167))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QV_A(ntryL,G1H4(205),ex5(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(90),n2h2(47))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(206),-8,nMT,G2H4(58),n2h4(168))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_QV_A(ntryL,G1H4(210),ex5(:),G1H2(1),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(92),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(211),ex3(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(93),n2h2(49))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(212),-8,nMT,G2H4(59),n2h4(169))
  call Hloop_AV_Q(ntryL,G2H4(59),ex4(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QV_A(ntryL,G1H4(217),ex3(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(95),n2h2(50))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-8,nMT,G2H4(62),n2h4(170))
  call Hloop_AV_Q(ntryL,G2H4(62),ex4(:),G2H2(96),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QV_A(ntryL,G1H4(222),ex3(:),G1H2(1),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(97),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(223),ex4(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(98),n2h2(52))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(224),-4,nMT,G2H4(63),n2h4(171))
  call Hloop_AV_Q(ntryL,G2H4(63),ex3(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QV_A(ntryL,G1H4(229),ex4(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(100),n2h2(53))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(230),-4,nMT,G2H4(66),n2h4(172))
  call Hloop_AV_Q(ntryL,G2H4(66),ex3(:),G2H2(101),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_QV_A(ntryL,G1H4(234),ex4(:),G1H2(1),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(102),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(235),ex4(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(103),n2h2(55))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(236),-16,nMT,G2H4(67),n2h4(173))
  call Hloop_QV_A(ntryL,G2H4(67),ex5(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AV_Q(ntryL,G1H4(241),ex4(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(105),n2h2(56))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(242),-16,nMT,G2H4(70),n2h4(174))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AV_Q(ntryL,G1H4(246),ex4(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(107),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H4(247),ex5(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(108),n2h2(58))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(248),-8,nMT,G2H4(71),n2h4(175))
  call Hloop_QV_A(ntryL,G2H4(71),ex4(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AV_Q(ntryL,G1H4(253),ex5(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(110),n2h2(59))
call HGT_OLR(G1H4(254),1,1,4)
call HGT_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(254),-8,nMT,G2H4(74),n2h4(176))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(111),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AV_Q(ntryL,G1H4(258),ex5(:),G1H2(1),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(112),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(259),ex3(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(113),n2h2(61))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(260),-16,nMT,G2H4(75),n2h4(177))
  call Hloop_QV_A(ntryL,G2H4(75),ex5(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AV_Q(ntryL,G1H4(265),ex3(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(115),n2h2(62))
call HGT_OLR(G1H4(266),1,1,4)
call HGT_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(266),-16,nMT,G2H4(78),n2h4(178))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(116),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_AV_Q(ntryL,G1H4(270),ex3(:),G1H2(1),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(117),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(271),ex5(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(118),n2h2(64))
call HGT_OLR(G1H4(272),1,1,4)
call HGT_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(272),-4,nMT,G2H4(79),n2h4(179))
  call Hloop_QV_A(ntryL,G2H4(79),ex3(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AV_Q(ntryL,G1H4(277),ex5(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(120),n2h2(65))
call HGT_OLR(G1H4(278),1,1,4)
call HGT_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(278),-4,nMT,G2H4(82),n2h4(180))
  call Hloop_QV_A(ntryL,G2H4(82),ex3(:),G2H2(121),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_AV_Q(ntryL,G1H4(282),ex5(:),G1H2(1),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(122),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(283),ex3(:),G1H2(1),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(123),n2h2(67))
call HGT_OLR(G1H4(284),1,1,4)
call HGT_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(284),-8,nMT,G2H4(83),n2h4(181))
  call Hloop_QV_A(ntryL,G2H4(83),ex4(:),G2H2(124),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_AV_Q(ntryL,G1H4(289),ex3(:),G1H2(1),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(125),n2h2(68))
call HGT_OLR(G1H4(290),1,1,4)
call HGT_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(290),-8,nMT,G2H4(86),n2h4(182))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_AV_Q(ntryL,G1H4(294),ex3(:),G1H2(1),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(127),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(295),ex4(:),G1H2(1),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(128),n2h2(70))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(296),-4,nMT,G2H4(87),n2h4(183))
  call Hloop_QV_A(ntryL,G2H4(87),ex3(:),G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_AV_Q(ntryL,G1H4(301),ex4(:),G1H2(1),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(130),n2h2(71))
call HGT_OLR(G1H4(302),1,1,4)
call HGT_invQ_OLR(G1H4(302),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(302),-4,nMT,G2H4(90),n2h4(184))
  call Hloop_QV_A(ntryL,G2H4(90),ex3(:),G2H2(131),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_AV_Q(ntryL,G1H4(306),ex4(:),G1H2(1),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(132),n2h2(72))
  call Hloop_VA_Q(ntryL,G1H4(307),ex2(:),G1H2(1),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(133),n2h2(73))
call HGT_OLR(G1H4(308),1,1,4)
call HGT_invQ_OLR(G1H4(308),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(308),-8,nMT,G2H4(91),n2h4(185))
  call Hloop_QV_A(ntryL,G2H4(91),ex4(:),G2H2(134),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VA_Q(ntryL,G1H4(313),ex2(:),G1H2(1),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(135),n2h2(74))
call HGT_OLR(G1H4(314),1,1,4)
call HGT_invQ_OLR(G1H4(314),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(314),-8,nMT,G2H4(94),n2h4(186))
  call Hloop_QV_A(ntryL,G2H4(94),ex4(:),G2H2(136),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_VA_Q(ntryL,G1H4(318),ex2(:),G1H2(1),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(137),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(319),ex3(:),G1H2(1),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(138),n2h2(76))
call HGT_OLR(G1H4(320),1,1,4)
call HGT_invQ_OLR(G1H4(320),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(320),-8,nMT,G2H4(95),n2h4(187))
  call Hloop_AV_Q(ntryL,G2H4(95),ex4(:),G2H2(139),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_QV_A(ntryL,G1H4(325),ex3(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(140),n2h2(77))
call HGT_OLR(G1H4(326),1,1,4)
call HGT_invQ_OLR(G1H4(326),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(326),-8,nMT,G2H4(98),n2h4(188))
  call Hloop_AV_Q(ntryL,G2H4(98),ex4(:),G2H2(141),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_QV_A(ntryL,G1H4(330),ex3(:),G1H2(1),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(142),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(331),ex1(:),G1H2(1),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(143),n2h2(79))
call HGT_OLR(G1H4(332),1,1,4)
call HGT_invQ_OLR(G1H4(332),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(332),-8,nMT,G2H4(99),n2h4(189))
  call Hloop_AV_Q(ntryL,G2H4(99),ex4(:),G2H2(144),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_VQ_A(ntryL,G1H4(337),ex1(:),G1H2(1),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(145),n2h2(80))
call HGT_OLR(G1H4(338),1,1,4)
call HGT_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(338),-8,nMT,G2H4(102),n2h4(190))
  call Hloop_AV_Q(ntryL,G2H4(102),ex4(:),G2H2(146),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_VQ_A(ntryL,G1H4(342),ex1(:),G1H2(1),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(147),n2h2(81))
  call Hloop_QV_A(ntryL,G1H4(343),ex4(:),G1H2(1),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(148),n2h2(82))
call HGT_OLR(G1H4(344),1,1,4)
call HGT_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(344),-4,nMT,G2H4(103),n2h4(191))
  call Hloop_AV_Q(ntryL,G2H4(103),ex3(:),G2H2(149),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_QV_A(ntryL,G1H4(349),ex4(:),G1H2(1),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(150),n2h2(83))
call HGT_OLR(G1H4(350),1,1,4)
call HGT_invQ_OLR(G1H4(350),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(350),-4,nMT,G2H4(106),n2h4(192))
  call Hloop_AV_Q(ntryL,G2H4(106),ex3(:),G2H2(151),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_QV_A(ntryL,G1H4(354),ex4(:),G1H2(1),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(152),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H4(355),ex3(:),G1H2(1),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(153),n2h2(85))
call HGT_OLR(G1H4(356),1,1,4)
call HGT_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(356),-8,nMT,G2H4(107),n2h4(193))
  call Hloop_QV_A(ntryL,G2H4(107),ex4(:),G2H2(154),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_AV_Q(ntryL,G1H4(361),ex3(:),G1H2(1),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(155),n2h2(86))
call HGT_OLR(G1H4(362),1,1,4)
call HGT_invQ_OLR(G1H4(362),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(362),-8,nMT,G2H4(110),n2h4(194))
  call Hloop_QV_A(ntryL,G2H4(110),ex4(:),G2H2(156),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_AV_Q(ntryL,G1H4(366),ex3(:),G1H2(1),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(157),n2h2(87))
  call Hloop_AV_Q(ntryL,G1H4(367),ex4(:),G1H2(1),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(158),n2h2(88))
call HGT_OLR(G1H4(368),1,1,4)
call HGT_invQ_OLR(G1H4(368),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(368),-4,nMT,G2H4(111),n2h4(195))
  call Hloop_QV_A(ntryL,G2H4(111),ex3(:),G2H2(159),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_AV_Q(ntryL,G1H4(373),ex4(:),G1H2(1),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(160),n2h2(89))
call HGT_OLR(G1H4(374),1,1,4)
call HGT_invQ_OLR(G1H4(374),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(374),-4,nMT,G2H4(114),n2h4(196))
  call Hloop_QV_A(ntryL,G2H4(114),ex3(:),G2H2(161),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_AV_Q(ntryL,G1H4(378),ex4(:),G1H2(1),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(162),n2h2(90))
  call Hloop_QV_A(ntryL,G1H4(379),ex4(:),G1H2(1),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(1),61,nMT,G2H2(163),n2h2(91))
call HGT_raise_alpha_OLR(G1H4(380),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(380),ex2(:),G1H2(1),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_QV_A(ntryL,G1H4(385),ex4(:),G1H2(2),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(2),61,nMT,G2H2(164),n2h2(92))
call HGT_raise_alpha_OLR(G1H4(386),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(386),ex2(:),G1H2(2),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_QV_A(ntryL,G1H4(391),ex4(:),G1H2(3),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(3),61,nMT,G2H2(165),n2h2(93))
call HGT_raise_alpha_OLR(G1H4(392),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(392),ex2(:),G1H2(3),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_QV_A(ntryL,G1H4(396),ex5(:),G1H2(4),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(4),61,nMT,G2H2(166),n2h2(94))
call HGT_raise_alpha_OLR(G1H4(397),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(397),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(397),ex2(:),G1H2(4),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_QV_A(ntryL,G1H4(402),ex5(:),G1H2(5),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(5),61,nMT,G2H2(167),n2h2(95))
call HGT_raise_alpha_OLR(G1H4(403),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(403),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(403),ex2(:),G1H2(5),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_QV_A(ntryL,G1H4(408),ex5(:),G1H2(6),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(6),61,nMT,G2H2(168),n2h2(96))
call HGT_raise_alpha_OLR(G1H4(409),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(409),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(409),ex2(:),G1H2(6),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_QV_A(ntryL,G1H4(413),ex3(:),G1H2(7),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(7),61,nMT,G2H2(169),n2h2(97))
call HGT_raise_alpha_OLR(G1H4(414),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(414),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(414),ex2(:),G1H2(7),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_QV_A(ntryL,G1H4(419),ex3(:),G1H2(8),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(8),61,nMT,G2H2(170),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(420),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(420),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(420),ex2(:),G1H2(8),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_QV_A(ntryL,G1H4(425),ex3(:),G1H2(9),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(9),61,nMT,G2H2(171),n2h2(99))
call HGT_raise_alpha_OLR(G1H4(426),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(426),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(426),ex2(:),G1H2(9),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_QV_A(ntryL,G1H4(430),ex5(:),G1H2(10),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(10),61,nMT,G2H2(172),n2h2(100))
call HGT_raise_alpha_OLR(G1H4(431),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(431),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(431),ex2(:),G1H2(10),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_QV_A(ntryL,G1H4(436),ex5(:),G1H2(11),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(11),61,nMT,G2H2(173),n2h2(101))
call HGT_raise_alpha_OLR(G1H4(437),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(437),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(437),ex2(:),G1H2(11),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_QV_A(ntryL,G1H4(442),ex5(:),G1H2(12),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(12),61,nMT,G2H2(174),n2h2(102))
call HGT_raise_alpha_OLR(G1H4(443),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(443),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(443),ex2(:),G1H2(12),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_QV_A(ntryL,G1H4(447),ex3(:),G1H2(13),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(13),61,nMT,G2H2(175),n2h2(103))
call HGT_raise_alpha_OLR(G1H4(448),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(448),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(448),ex2(:),G1H2(13),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_QV_A(ntryL,G1H4(453),ex3(:),G1H2(14),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(14),61,nMT,G2H2(176),n2h2(104))
call HGT_raise_alpha_OLR(G1H4(454),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(454),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(454),ex2(:),G1H2(14),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_QV_A(ntryL,G1H4(459),ex3(:),G1H2(15),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(15),61,nMT,G2H2(177),n2h2(105))
call HGT_raise_alpha_OLR(G1H4(460),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(460),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(460),ex2(:),G1H2(15),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_QV_A(ntryL,G1H4(464),ex4(:),G1H2(16),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(16),61,nMT,G2H2(178),n2h2(106))
call HGT_raise_alpha_OLR(G1H4(465),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(465),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(465),ex2(:),G1H2(16),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_QV_A(ntryL,G1H4(470),ex4(:),G1H2(17),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(17),61,nMT,G2H2(179),n2h2(107))
call HGT_raise_alpha_OLR(G1H4(471),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(471),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(471),ex2(:),G1H2(17),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_QV_A(ntryL,G1H4(476),ex4(:),G1H2(18),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(18),61,nMT,G2H2(180),n2h2(108))
call HGT_raise_alpha_OLR(G1H4(477),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(477),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(477),ex2(:),G1H2(18),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,2),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,2),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(11),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(1),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(2),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(3),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(4),mass5set(:,1),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(5),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(6),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(15),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(16),mass5set(:,3),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(16),mass5set(:,3),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(17),mass5set(:,4),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(17),mass5set(:,4),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(18),mass5set(:,3),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(19),mass5set(:,3),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(20),mass5set(:,4),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(20),mass5set(:,4),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(19),mass5set(:,3),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(21),mass5set(:,4),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(98),RedSet_5(21),mass5set(:,4),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(22),mass5set(:,4),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(22),mass5set(:,4),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(23),mass5set(:,4),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hotf_5pt_reduction(G2H2(118),RedSet_5(23),mass5set(:,4),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_5pt_reduction(G2H2(123),RedSet_5(24),mass5set(:,4),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hotf_5pt_reduction(G2H2(128),RedSet_5(24),mass5set(:,4),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(25),mass5set(:,5),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),8,2)
  call Hotf_5pt_reduction(G2H2(138),RedSet_5(26),mass5set(:,6),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hotf_5pt_reduction(G2H2(143),RedSet_5(27),mass5set(:,5),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_5pt_reduction(G2H2(148),RedSet_5(26),mass5set(:,6),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(28),mass5set(:,6),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hotf_5pt_reduction(G2H2(158),RedSet_5(28),mass5set(:,6),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(163),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(166),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(169),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(172),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(175),ex2(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(178),ex2(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),47,ex5(:),16,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),0,ex5(:),16,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),47,ex5(:),16,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),0,ex5(:),16,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),47,ex5(:),16,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),0,ex5(:),16,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(37),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(15),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(16),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(18),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(20),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(21),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(22),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(24),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(26),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(28),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(30),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(32),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(34),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(35),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(36),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(38),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(40),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(42),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(43),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(44),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(45),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(46),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(47),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(48),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(50),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(151),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(52),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(53),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(54),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(163),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(56),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(57),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(170),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(58),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H2(175),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(59),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H2(176),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(60),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(181),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(62),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(187),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(188),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(64),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(193),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(66),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(68),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(69),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(70),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(72),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(217),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(73),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(74),n2h1(64))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(9),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(8),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(12),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(11),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(13),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(14),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(7),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(8),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(10),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(11),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(3),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(5),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(6),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(15),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(16),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(16),mass5set(:,3),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(17),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(17),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(18),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(19),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(20),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(20),mass5set(:,4),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(19),mass5set(:,3),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(21),mass5set(:,4),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(21),mass5set(:,4),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(22),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(22),mass5set(:,4),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(23),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(23),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(24),mass5set(:,4),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(24),mass5set(:,4),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(25),mass5set(:,5),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(26),mass5set(:,6),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(27),mass5set(:,5),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(26),mass5set(:,6),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(28),mass5set(:,6),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(28),mass5set(:,6),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[48,1,4,8,2],[0,nMT,nMT,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[48,1,4,8,2],[0,nMT,nMT,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[48,1,4,8,2],[0,nMT,nMT,nMT,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[48,1,8,4,2],[0,nMT,nMT,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(4),m4h2x2x16(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[48,1,8,4,2],[0,nMT,nMT,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(5),m4h2x2x16(:,5),heltab3x64(:,:,5))



end subroutine vamp_1

end module ol_vamp_1_ppaatt_ttxaagg_1_/**/REALKIND
