
module ol_vamp_1_ppaajj_uuuxuxaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaajj_uuuxuxaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaajj_uuuxuxaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppaajj_uuuxuxaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppaajj_uuuxuxaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppaajj_uuuxuxaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppaajj_uuuxuxaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,1,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,2,4,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,1,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,8,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,2,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,8,16,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,4,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,4,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,4,2,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,4,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,8,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,8,16,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(24))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_V(ntryL,G1H32(2),ex2(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_QA_V(ntryL,G1H32(3),ex3(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_V(ntryL,G1H32(4),ex2(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_QA_V(ntryL,G1H32(5),ex4(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex3(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_V(ntryL,G1H32(7),ex2(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_V(ntryL,G1H32(8),ex2(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AQ_V(ntryL,G1H32(9),ex1(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_AQ_V(ntryL,G1H32(10),ex1(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_AQ_V(ntryL,G1H32(11),ex1(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QA_V(ntryL,G1H32(13),ex4(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex2(:),G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_QA_V(ntryL,G1H32(15),ex3(:),G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AQ_V(ntryL,G1H32(16),ex2(:),G1H16(16),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_QA_V(ntryL,G1H32(17),ex4(:),G1H16(17),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_V(ntryL,G1H32(18),ex2(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(21),ex3(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex2(:),G1H16(22),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(23),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(24),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(2),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(3),ex4(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(3),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(4),n2h8(4))
  call Hloop_VA_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(5),n2h8(5))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(6),n2h8(6))
  call Hloop_VQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(7),n2h8(7))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(8),n2h8(8))
  call Hloop_VQ_A(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(9),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(10),n2h8(10))
  call Hloop_VQ_A(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(11),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(13),ex1(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(13),n2h8(13))
  call Hloop_VA_Q(ntryL,G1H16(14),ex3(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(14),n2h8(14))
  call Hloop_VQ_A(ntryL,G1H16(15),ex1(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(15),n2h8(15))
  call Hloop_VA_Q(ntryL,G1H16(16),ex4(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(16),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(17),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(17),n2h8(17))
  call Hloop_VA_Q(ntryL,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(18),n2h8(18))
  call Hloop_VA_Q(ntryL,G1H16(19),ex3(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(19),n2h8(19))
  call Hloop_VA_Q(ntryL,G1H16(20),ex3(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(20),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H16(21),ex2(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),38,0,G2H8(21),n2h8(21))
  call Hloop_VA_Q(ntryL,G1H16(22),ex3(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(22),n2h8(22))
  call Hloop_VA_Q(ntryL,G1H16(23),ex4(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(23),n2h8(23))
  call Hloop_VA_Q(ntryL,G1H16(24),ex4(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(24),n2h8(24))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(4),ex4(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(5),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(6),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),4,8)
  call Hloop_QA_V(ntryL,G2H8(9),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(10),ex4(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(2),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(2),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),4,8)
  call Hloop_QA_V(ntryL,G2H8(13),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G2H8(16),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(17),ex3(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(3),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),4,8)
  call Hloop_AQ_V(ntryL,G2H8(19),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(4),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hloop_QA_V(ntryL,G2H8(21),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(5),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_AQ_V(ntryL,G2H8(23),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(6),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),4,8)
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(17),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-8,0,G2H8(1),n2h8(25))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(19),n2h4(2))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(20),n2h4(3))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(21),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-4,0,G2H8(2),n2h8(26))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QV_A(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(23),n2h4(5))
  call Hloop_QV_A(ntryL,G1H8(12),ex5(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(24),n2h4(6))
  call Hloop_QV_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(25),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-8,0,G2H8(3),n2h8(27))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QV_A(ntryL,G1H8(17),ex5(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(27),n2h4(8))
  call Hloop_QV_A(ntryL,G1H8(18),ex5(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(28),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(29),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-4,0,G2H8(4),n2h8(28))
  call Hloop_QA_V(ntryL,G2H8(4),ex3(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QV_A(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(31),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(32),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(33),n2h4(13))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-4,0,G2H8(5),n2h8(29))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AV_Q(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(35),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(36),n2h4(15))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(37),n2h4(16))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-8,0,G2H8(6),n2h8(30))
  call Hloop_QA_V(ntryL,G2H8(6),ex4(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(39),n2h4(17))
  call Hloop_AV_Q(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(40),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(41),n2h4(19))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-8,0,G2H8(7),n2h8(31))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(43),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(44),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(45),n2h4(22))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-4,0,G2H8(8),n2h8(32))
  call Hloop_QA_V(ntryL,G2H8(8),ex3(:),G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(47),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H8(48),ex5(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(48),n2h4(24))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(7),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(8),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(9),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(10),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(11),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(12),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(13),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(14),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(15),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(16),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(17),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(18),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(19),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(20),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(21),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(22),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(20),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(21),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(25),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(28),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(29),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(32),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(33),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(36),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(37),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(40),ex2(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntryL,G2H4(41),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(44),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(45),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(48),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-16,0,G2H4(1),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(19),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(3))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,0,G2H4(2),n2h4(26))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(22),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(5))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-16,0,G2H4(3),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(25),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(19),ex3(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(26),n2h2(7))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,0,G2H4(4),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VA_Q(ntryL,G1H4(24),ex3(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(28),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(25),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(9))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(26),-16,0,G2H4(5),n2h4(29))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H4(30),ex1(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(31),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(32),n2h2(11))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-16,0,G2H4(6),n2h4(30))
  call Hloop_AV_Q(ntryL,G2H4(6),ex5(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_VQ_A(ntryL,G1H4(36),ex1(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(34),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(37),ex4(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(35),n2h2(13))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,0,G2H4(7),n2h4(31))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G1H4(42),ex4(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(37),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(43),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(38),n2h2(15))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(44),-16,0,G2H4(8),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(48),ex3(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(40),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(49),ex2(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(41),n2h2(17))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-16,0,G2H4(9),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(54),ex2(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(43),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(55),ex4(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(44),n2h2(19))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-16,0,G2H4(10),n2h4(34))
  call Hloop_QV_A(ntryL,G2H4(10),ex5(:),G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_VA_Q(ntryL,G1H4(60),ex4(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(46),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(61),ex2(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(47),n2h2(21))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,0,G2H4(11),n2h4(35))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VQ_A(ntryL,G1H4(66),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(49),n2h2(22))
  call Hloop_VA_Q(ntryL,G1H4(67),ex3(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(50),n2h2(23))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-16,0,G2H4(12),n2h4(36))
  call Hloop_QV_A(ntryL,G2H4(12),ex5(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_VA_Q(ntryL,G1H4(72),ex3(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(52),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(53),n2h2(25))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,0,G2H4(13),n2h4(37))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(55),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(79),ex4(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(56),n2h2(27))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-16,0,G2H4(14),n2h4(38))
  call Hloop_QV_A(ntryL,G2H4(14),ex5(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(58),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(85),ex1(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(59),n2h2(29))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-16,0,G2H4(15),n2h4(39))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_VQ_A(ntryL,G1H4(90),ex1(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(61),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(91),ex3(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(62),n2h2(31))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(92),-16,0,G2H4(16),n2h4(40))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_VA_Q(ntryL,G1H4(96),ex3(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(64),n2h2(32))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(4),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(5),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(6),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(7),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(8),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(9),mass5set(:,1),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(10),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(11),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(12),mass5set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(13),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(14),mass5set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(15),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(16),mass5set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(17),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(18),mass5set(:,1),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(19),mass5set(:,1),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(20),mass5set(:,1),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(21),mass5set(:,1),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(22),mass5set(:,1),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(4),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(8),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(16),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(28))
  call Hloop_AV_Q(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(29))
  call Hloop_AV_Q(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(133),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(46),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(6),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(11),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(12),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(13),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(14),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(15),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(16),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(17),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(18),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(19),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(20),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(21),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(22),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,5,16,2,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(25))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,5,8,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(26))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,8,16,5],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(27))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,8,5,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(28))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,5,2,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(29))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,2,5,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(30))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,8,5,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(31))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,5,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(32))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(33))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(34))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(35))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(36))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(37))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(39))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(40))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,2,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(41))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,9,4,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(42))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,4,16,9],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(43))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,4,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(44))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,9,2,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(45))
  Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,2,9,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,9,2,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(47))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,9,4,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(48))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,1,16,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,10,4,1,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(26),n2h32(50))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,4,16,10],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(51))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,4,10,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(52))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,10,1,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(53))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,1,10,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,10,1,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(55))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,10,4,16],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(32),n2h32(56))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,2,8,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(57))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,8,2,4,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,2,4,17,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,8,4,2,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(36),n2h32(60))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,8,17,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(61))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,4,8,2,17],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(38),n2h32(62))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,17,8,4],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(63))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,17,4,8],[0,0,0,0,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(64))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,1,8,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(41),n2h32(65))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,8,1,4,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(42),n2h32(66))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,4,18,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(43),n2h32(67))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,8,4,1,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(44),n2h32(68))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,1,8,18,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(45),n2h32(69))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,4,8,1,18],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(46),n2h32(70))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,18,8,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(71))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,18,4,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(72))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(73))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(50),n2h32(74))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(75))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(52),n2h32(76))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(77))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(54),n2h32(78))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(79))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(80))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(57),n2h32(81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(58),n2h32(82))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(83))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(60),n2h32(84))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(85))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(62),n2h32(86))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(87))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(64),n2h32(88))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[33,8,2,4,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[33,4,2,8,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[33,4,2,16,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[33,2,4,8,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[33,4,16,2,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(4),m3h4x16(:,5),heltab2x64(:,:,93))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[33,2,8,4,16],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(5),m3h4x16(:,6),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[33,2,16,4,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(6),m3h4x16(:,7),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[33,2,16,8,4],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,14),G0H16(7),m3h4x16(:,8),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[34,8,1,4,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,9),heltab2x64(:,:,97))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[34,4,1,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,10),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[34,4,1,16,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,11),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[34,1,4,8,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,12),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[34,4,16,1,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(11),m3h4x16(:,13),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[34,1,8,4,16],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,14),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[34,1,16,4,8],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,15),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[34,1,16,8,4],[0,0,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(14),m3h4x16(:,16),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(15),m3h4x16(:,17),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(16),m3h4x16(:,18),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,19),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(17),36,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,20),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(17),36,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(17),m3h4x16(:,21),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(18),m3h4x16(:,22),heltab2x64(:,:,110))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,23),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(19),36,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,17),G0H16(19),m3h4x16(:,24),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,25),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,26),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,27),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(22),40,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,28),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(22),40,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,29),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(23),m3h4x16(:,30),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(24),m3h4x16(:,31),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(24),40,0,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(24),m3h4x16(:,32),heltab2x64(:,:,120))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(9),n2h8(33))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,1),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(2),37,0,G2H8(10),n2h8(34))
  call Hloop_AQ_V(ntryL,G1H32(3),ex2(:),G1H16(9),m3h2x16(:,25),heltab2x32(:,:,27))
  call Hloop_AQ_V(ntryL,G1H32(4),ex2(:),G1H16(10),m3h2x16(:,26),heltab2x32(:,:,28))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(5),m3h4x8(:,3),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(5),37,0,G2H8(11),n2h8(35))
  call Hloop_QA_V(ntryL,G1H32(6),ex4(:),G1H16(11),m3h2x16(:,27),heltab2x32(:,:,30))
  call Hloop_QA_V(ntryL,G1H32(7),ex4(:),G1H16(12),m3h2x16(:,28),heltab2x32(:,:,31))
  call Hloop_AQ_V(ntryL,G1H32(8),ex2(:),G1H16(13),m3h2x16(:,29),heltab2x32(:,:,32))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,11),G1H8(6),m3h4x8(:,4),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(6),38,0,G2H8(12),n2h8(36))
  call Hloop_QV_A(ntryL,G1H32(10),wf4(:,11),G1H8(7),m3h4x8(:,5),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(13),n2h8(37))
  call Hloop_AQ_V(ntryL,G1H32(11),ex1(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(15),m3h2x16(:,31),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,11),G1H8(8),m3h4x8(:,6),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(14),n2h8(38))
  call Hloop_QA_V(ntryL,G1H32(14),ex4(:),G1H16(16),m3h2x16(:,32),heltab2x32(:,:,38))
  call Hloop_QA_V(ntryL,G1H32(15),ex4(:),G1H16(17),m3h2x16(:,33),heltab2x32(:,:,39))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(18),m3h2x16(:,34),heltab2x32(:,:,40))
  call Hloop_QA_V(ntryL,G1H32(17),ex3(:),G1H16(19),m3h2x16(:,35),heltab2x32(:,:,41))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,15),G1H8(11),m3h4x8(:,7),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(11),41,0,G2H8(15),n2h8(39))
  call Hloop_AQ_V(ntryL,G1H32(19),ex2(:),G1H16(20),m3h2x16(:,36),heltab2x32(:,:,43))
  call Hloop_AQ_V(ntryL,G1H32(20),ex2(:),G1H16(21),m3h2x16(:,37),heltab2x32(:,:,44))
  call Hloop_AV_Q(ntryL,G1H32(21),wf4(:,15),G1H8(12),m3h4x8(:,8),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(12),41,0,G2H8(16),n2h8(40))
  call Hloop_QA_V(ntryL,G1H32(22),ex3(:),G1H16(22),m3h2x16(:,38),heltab2x32(:,:,46))
  call Hloop_QA_V(ntryL,G1H32(23),ex3(:),G1H16(23),m3h2x16(:,39),heltab2x32(:,:,47))
  call Hloop_AQ_V(ntryL,G1H32(24),ex2(:),G1H16(24),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_QA_V(ntryL,G1H32(25),ex3(:),G1H16(25),m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,20),G1H8(13),m3h4x8(:,9),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(13),42,0,G2H8(17),n2h8(41))
  call Hloop_AQ_V(ntryL,G1H32(27),ex1(:),G1H16(26),m3h2x16(:,42),heltab2x32(:,:,51))
  call Hloop_AQ_V(ntryL,G1H32(28),ex1(:),G1H16(27),m3h2x16(:,43),heltab2x32(:,:,52))
  call Hloop_AV_Q(ntryL,G1H32(29),wf4(:,20),G1H8(14),m3h4x8(:,10),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(14),42,0,G2H8(18),n2h8(42))
  call Hloop_QA_V(ntryL,G1H32(30),ex3(:),G1H16(28),m3h2x16(:,44),heltab2x32(:,:,54))
  call Hloop_QA_V(ntryL,G1H32(31),ex3(:),G1H16(29),m3h2x16(:,45),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H32(32),ex1(:),G1H16(30),m3h2x16(:,46),heltab2x32(:,:,56))
  call Hloop_QA_V(ntryL,G1H32(33),ex3(:),G1H16(31),m3h2x16(:,47),heltab2x32(:,:,57))
  call Hloop_QA_V(ntryL,G1H32(34),ex4(:),G1H16(32),m3h2x16(:,48),heltab2x32(:,:,58))
  call Hloop_AQ_V(ntryL,G1H32(35),ex2(:),G1H16(33),m3h2x16(:,49),heltab2x32(:,:,59))
  call Hloop_QA_V(ntryL,G1H32(36),ex4(:),G1H16(34),m3h2x16(:,50),heltab2x32(:,:,60))
  call Hloop_AQ_V(ntryL,G1H32(37),ex2(:),G1H16(35),m3h2x16(:,51),heltab2x32(:,:,61))
  call Hloop_QA_V(ntryL,G1H32(38),ex3(:),G1H16(36),m3h2x16(:,52),heltab2x32(:,:,62))
  call Hloop_AQ_V(ntryL,G1H32(39),ex2(:),G1H16(37),m3h2x16(:,53),heltab2x32(:,:,63))
  call Hloop_AQ_V(ntryL,G1H32(40),ex2(:),G1H16(38),m3h2x16(:,54),heltab2x32(:,:,64))
  call Hloop_QA_V(ntryL,G1H32(41),ex3(:),G1H16(39),m3h2x16(:,55),heltab2x32(:,:,65))
  call Hloop_QA_V(ntryL,G1H32(42),ex4(:),G1H16(40),m3h2x16(:,56),heltab2x32(:,:,66))
  call Hloop_AQ_V(ntryL,G1H32(43),ex1(:),G1H16(41),m3h2x16(:,57),heltab2x32(:,:,67))
  call Hloop_QA_V(ntryL,G1H32(44),ex4(:),G1H16(42),m3h2x16(:,58),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntryL,G1H32(45),ex1(:),G1H16(43),m3h2x16(:,59),heltab2x32(:,:,69))
  call Hloop_QA_V(ntryL,G1H32(46),ex3(:),G1H16(44),m3h2x16(:,60),heltab2x32(:,:,70))
  call Hloop_AQ_V(ntryL,G1H32(47),ex1(:),G1H16(45),m3h2x16(:,61),heltab2x32(:,:,71))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(46),m3h2x16(:,62),heltab2x32(:,:,72))
  call Hloop_AQ_V(ntryL,G1H32(49),ex2(:),G1H16(47),m3h2x16(:,63),heltab2x32(:,:,73))
  call Hloop_AQ_V(ntryL,G1H32(50),ex1(:),G1H16(48),m3h2x16(:,64),heltab2x32(:,:,74))
  call Hloop_AQ_V(ntryL,G1H32(51),ex1(:),G1H16(49),m3h2x16(:,65),heltab2x32(:,:,75))
  call Hloop_AQ_V(ntryL,G1H32(52),ex2(:),G1H16(50),m3h2x16(:,66),heltab2x32(:,:,76))
  call Hloop_AQ_V(ntryL,G1H32(53),ex1(:),G1H16(51),m3h2x16(:,67),heltab2x32(:,:,77))
  call Hloop_AQ_V(ntryL,G1H32(54),ex2(:),G1H16(52),m3h2x16(:,68),heltab2x32(:,:,78))
  call Hloop_AQ_V(ntryL,G1H32(55),ex2(:),G1H16(53),m3h2x16(:,69),heltab2x32(:,:,79))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(54),m3h2x16(:,70),heltab2x32(:,:,80))
  call Hloop_AQ_V(ntryL,G1H32(57),ex2(:),G1H16(55),m3h2x16(:,71),heltab2x32(:,:,81))
  call Hloop_AQ_V(ntryL,G1H32(58),ex1(:),G1H16(56),m3h2x16(:,72),heltab2x32(:,:,82))
  call Hloop_AQ_V(ntryL,G1H32(59),ex1(:),G1H16(57),m3h2x16(:,73),heltab2x32(:,:,83))
  call Hloop_AQ_V(ntryL,G1H32(60),ex2(:),G1H16(58),m3h2x16(:,74),heltab2x32(:,:,84))
  call Hloop_AQ_V(ntryL,G1H32(61),ex1(:),G1H16(59),m3h2x16(:,75),heltab2x32(:,:,85))
  call Hloop_AQ_V(ntryL,G1H32(62),ex2(:),G1H16(60),m3h2x16(:,76),heltab2x32(:,:,86))
  call Hloop_AQ_V(ntryL,G1H32(63),ex2(:),G1H16(61),m3h2x16(:,77),heltab2x32(:,:,87))
  call Hloop_AQ_V(ntryL,G1H32(64),ex1(:),G1H16(62),m3h2x16(:,78),heltab2x32(:,:,88))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(1),41,0,G1H8(17),n2h8(43))
  call Hloop_VA_Q(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(1),37,0,G1H8(18),n2h8(44))
  call Hloop_QA_V(ntryL,G1H16(1),ex3(:),G1H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_VQ_A(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(20),n2h8(45))
  call Hloop_VA_Q(ntryL,G0H16(4),ex3(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),37,0,G1H8(23),n2h8(46))
  call Hloop_VQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(24),n2h8(47))
  call Hloop_VQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(25),n2h8(48))
  call Hloop_VQ_A(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(26),n2h8(49))
  call Hloop_VA_Q(ntryL,G0H16(8),ex4(:),G0H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(29),n2h8(50))
  call Hloop_VA_Q(ntryL,G0H16(9),ex3(:),G0H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(30),n2h8(51))
  call Hloop_QA_V(ntryL,G1H16(2),ex3(:),G1H8(31),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(32),n2h8(52))
  call Hloop_VA_Q(ntryL,G0H16(11),ex3(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(35),n2h8(53))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(36),n2h8(54))
  call Hloop_VQ_A(ntryL,G0H16(13),ex1(:),G0H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(37),n2h8(55))
  call Hloop_VQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(38),n2h8(56))
  call Hloop_VA_Q(ntryL,G0H16(15),ex4(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(41),n2h8(57))
  call Hloop_VA_Q(ntryL,G0H16(16),ex4(:),G0H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(42),n2h8(58))
  call Hloop_AQ_V(ntryL,G1H16(3),ex2(:),G1H8(43),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(44),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_VQ_A(ntryL,G0H16(17),ex2(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),38,0,G1H8(47),n2h8(59))
  call Hloop_VQ_A(ntryL,G0H16(18),ex1(:),G0H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(48),n2h8(60))
  call Hloop_AQ_V(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_VQ_A(ntryL,G0H16(19),ex1(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(2),n2h8(61))
  call Hloop_VA_Q(ntryL,G0H16(20),ex3(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(5),n2h8(62))
  call Hloop_VA_Q(ntryL,G0H16(21),ex3(:),G0H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(6),n2h8(63))
  call Hloop_AQ_V(ntryL,G1H16(6),ex2(:),G1H8(7),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(8),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_VQ_A(ntryL,G0H16(22),ex2(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G0H8(1),42,0,G1H8(11),n2h8(64))
  call Hloop_VQ_A(ntryL,G0H16(23),ex1(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(12),n2h8(65))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(13),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_VQ_A(ntryL,G0H16(24),ex1(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(14),n2h8(66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(40)])
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(17),n2h4(41))
  call Hloop_QV_A(ntryL,G1H8(16),ex5(:),G1H4(2),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(20),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(38),ex5(:),G1H4(6),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(6),51,0,G2H4(21),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(22),ex5(:),G1H4(7),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(7),51,0,G2H4(24),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(25),ex5(:),G1H4(8),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(8),51,0,G2H4(25),n2h4(45))
  call Hloop_QV_A(ntryL,G1H8(26),ex5(:),G1H4(12),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(28),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(27),ex5(:),G1H4(13),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(13),58,0,G2H4(29),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(28),ex5(:),G1H4(14),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(14),58,0,G2H4(32),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(23),ex5(:),G1H4(18),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(18),53,0,G2H4(33),n2h4(49))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(23),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(9),G1H8(10),G1H8(15),G1H8(21),8)
  call HG1shiftOLR(G1H8(4),8,8)
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(19),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(36),n2h4(50))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(24),mass5set(:,1),  & 
G1H8(33),G1H8(34),G1H8(39),G1H8(40),G1H8(37),G1H8(16),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hloop_AV_Q(ntryL,G1H8(45),ex5(:),G1H4(20),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(20),57,0,G2H4(37),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(46),ex5(:),G1H4(24),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(24),57,0,G2H4(40),n2h4(52))
  call Hloop_QA_V(ntryL,G2H8(10),ex4(:),G2H4(41),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_VA_Q(ntryL,G1H16(9),ex4(:),G1H8(38),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(38),42,0,G2H8(19),n2h8(67))
  call Hloop_VA_Q(ntryL,G1H16(10),ex4(:),G1H8(22),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(22),42,0,G2H8(20),n2h8(68))
  call Hloop_AQ_V(ntryL,G2H8(11),ex2(:),G2H4(44),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_VQ_A(ntryL,G1H16(11),ex2(:),G1H8(25),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(25),42,0,G2H8(21),n2h8(69))
  call Hloop_UV_W(ntryL,G1H16(12),40,wf4(:,1),5,G2H4(45),m3h4x4(:,1),heltab2x16(:,:,60))
  call Hloop_UV_W(ntryL,G1H16(13),34,wf4(:,1),5,G2H4(48),m3h4x4(:,2),heltab2x16(:,:,61))
  call Hloop_QA_V(ntryL,G2H8(13),ex4(:),G2H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_VA_Q(ntryL,G1H16(14),ex4(:),G1H8(26),m3h2x8(:,60),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(26),41,0,G2H8(22),n2h8(70))
  call Hloop_VA_Q(ntryL,G1H16(15),ex4(:),G1H8(27),m3h2x8(:,61),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(27),41,0,G2H8(23),n2h8(71))
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(2),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_VQ_A(ntryL,G1H16(16),ex1(:),G1H8(28),m3h2x8(:,62),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(28),41,0,G2H8(24),n2h8(72))
  call Hloop_UV_W(ntryL,G1H16(17),40,wf4(:,11),6,G2H4(3),m3h4x4(:,3),heltab2x16(:,:,65))
  call Hloop_UV_W(ntryL,G1H16(18),33,wf4(:,11),6,G2H4(4),m3h4x4(:,4),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(19),ex2(:),G1H8(23),m3h2x8(:,63),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(23),38,0,G2H8(1),n2h8(73))
  call Hloop_QA_V(ntryL,G2H8(15),ex3(:),G2H4(5),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_VA_Q(ntryL,G1H16(20),ex3(:),G1H8(35),m3h2x8(:,64),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(35),38,0,G2H8(2),n2h8(74))
  call Hloop_VA_Q(ntryL,G1H16(21),ex3(:),G1H8(45),m3h2x8(:,65),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(45),38,0,G2H8(3),n2h8(75))
  call Hloop_AQ_V(ntryL,G2H8(16),ex2(:),G2H4(6),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(22),ex2(:),G1H8(46),m3h2x8(:,66),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(46),38,0,G2H8(4),n2h8(76))
  call Hloop_UV_W(ntryL,G1H16(23),36,wf4(:,15),9,G2H4(7),m3h4x4(:,5),heltab2x16(:,:,71))
  call Hloop_UV_W(ntryL,G1H16(24),34,wf4(:,15),9,G2H4(8),m3h4x4(:,6),heltab2x16(:,:,72))
  call Hloop_VQ_A(ntryL,G1H16(25),ex1(:),G1H8(38),m3h2x8(:,67),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(5),n2h8(77))
  call Hloop_QA_V(ntryL,G2H8(17),ex3(:),G2H4(9),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_VA_Q(ntryL,G1H16(26),ex3(:),G1H8(22),m3h2x8(:,68),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(22),37,0,G2H8(6),n2h8(78))
  call Hloop_VA_Q(ntryL,G1H16(27),ex3(:),G1H8(25),m3h2x8(:,69),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(25),37,0,G2H8(7),n2h8(79))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(10),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(26),m3h2x8(:,70),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(26),37,0,G2H8(8),n2h8(80))
  call Hloop_UV_W(ntryL,G1H16(29),36,wf4(:,20),10,G2H4(11),m3h4x4(:,7),heltab2x16(:,:,77))
  call Hloop_UV_W(ntryL,G1H16(30),33,wf4(:,20),10,G2H4(12),m3h4x4(:,8),heltab2x16(:,:,78))
  call Hloop_VQ_A(ntryL,G1H16(31),ex2(:),G1H8(27),m3h2x8(:,71),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(27),38,0,G2H8(9),n2h8(81))
  call Hloop_VQ_A(ntryL,G1H16(32),ex2(:),G1H8(28),m3h2x8(:,72),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(28),42,0,G2H8(12),n2h8(82))
  call Hloop_VA_Q(ntryL,G1H16(33),ex3(:),G1H8(23),m3h2x8(:,73),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(23),38,0,G2H8(10),n2h8(83))
  call Hloop_VA_Q(ntryL,G1H16(34),ex3(:),G1H8(35),m3h2x8(:,74),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(35),44,0,G2H8(11),n2h8(84))
  call Hloop_VA_Q(ntryL,G1H16(35),ex4(:),G1H8(45),m3h2x8(:,75),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(45),42,0,G2H8(13),n2h8(85))
  call Hloop_VA_Q(ntryL,G1H16(36),ex4(:),G1H8(46),m3h2x8(:,76),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(46),44,0,G2H8(14),n2h8(86))
  call Hloop_VQ_A(ntryL,G1H16(37),wf4(:,12),G1H4(25),m3h4x4(:,9),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(25),51,0,G2H4(13),n2h4(53))
  call Hloop_VQ_A(ntryL,G1H16(38),wf4(:,12),G1H4(26),m3h4x4(:,10),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(26),51,0,G2H4(14),n2h4(54))
  call Hloop_VQ_A(ntryL,G1H16(39),ex1(:),G1H8(38),m3h2x8(:,77),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(15),n2h8(87))
  call Hloop_VQ_A(ntryL,G1H16(40),ex1(:),G1H8(22),m3h2x8(:,78),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(22),41,0,G2H8(16),n2h8(88))
  call Hloop_VA_Q(ntryL,G1H16(41),ex3(:),G1H8(25),m3h2x8(:,79),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(25),37,0,G2H8(17),n2h8(89))
  call Hloop_VA_Q(ntryL,G1H16(42),ex3(:),G1H8(26),m3h2x8(:,80),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(26),44,0,G2H8(18),n2h8(90))
  call Hloop_VA_Q(ntryL,G1H16(43),ex4(:),G1H8(27),m3h2x8(:,81),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(27),41,0,G2H8(25),n2h8(91))
  call Hloop_VA_Q(ntryL,G1H16(44),ex4(:),G1H8(28),m3h2x8(:,82),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(28),44,0,G2H8(26),n2h8(92))
  call Hloop_VQ_A(ntryL,G1H16(45),wf4(:,4),G1H4(30),m3h4x4(:,11),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(30),51,0,G2H4(15),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H16(46),wf4(:,4),G1H4(31),m3h4x4(:,12),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(31),51,0,G2H4(16),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H16(47),ex1(:),G1H8(23),m3h2x8(:,83),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(23),35,0,G2H8(27),n2h8(93))
  call Hloop_VQ_A(ntryL,G1H16(48),ex2(:),G1H8(35),m3h2x8(:,84),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(35),35,0,G2H8(28),n2h8(94))
  call Hloop_VQ_A(ntryL,G1H16(49),ex2(:),G1H8(45),m3h2x8(:,85),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(45),35,0,G2H8(29),n2h8(95))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(46),m3h2x8(:,86),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(46),35,0,G2H8(30),n2h8(96))
  call Hloop_VA_Q(ntryL,G1H16(51),ex4(:),G1H8(38),m3h2x8(:,87),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(38),41,0,G2H8(31),n2h8(97))
  call Hloop_VA_Q(ntryL,G1H16(52),ex4(:),G1H8(22),m3h2x8(:,88),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(22),42,0,G2H8(32),n2h8(98))
  call Hloop_VA_Q(ntryL,G1H16(53),wf4(:,19),G1H4(32),m3h4x4(:,13),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(32),54,0,G2H4(49),n2h4(57))
  call Hloop_VA_Q(ntryL,G1H16(54),wf4(:,19),G1H4(36),m3h4x4(:,14),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(36),53,0,G2H4(50),n2h4(58))
  call Hloop_VQ_A(ntryL,G1H16(55),ex1(:),G1H8(25),m3h2x8(:,89),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(25),35,0,G2H8(33),n2h8(99))
  call Hloop_VQ_A(ntryL,G1H16(56),ex2(:),G1H8(26),m3h2x8(:,90),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(26),35,0,G2H8(34),n2h8(100))
  call Hloop_VQ_A(ntryL,G1H16(57),ex2(:),G1H8(27),m3h2x8(:,91),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(27),35,0,G2H8(35),n2h8(101))
  call Hloop_VQ_A(ntryL,G1H16(58),ex1(:),G1H8(28),m3h2x8(:,92),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(28),35,0,G2H8(36),n2h8(102))
  call Hloop_VA_Q(ntryL,G1H16(59),ex3(:),G1H8(23),m3h2x8(:,93),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(23),37,0,G2H8(37),n2h8(103))
  call Hloop_VA_Q(ntryL,G1H16(60),ex3(:),G1H8(35),m3h2x8(:,94),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(35),38,0,G2H8(38),n2h8(104))
  call Hloop_VA_Q(ntryL,G1H16(61),wf4(:,9),G1H4(37),m3h4x4(:,15),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(37),58,0,G2H4(51),n2h4(59))
  call Hloop_VA_Q(ntryL,G1H16(62),wf4(:,9),G1H4(38),m3h4x4(:,16),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(38),57,0,G2H4(52),n2h4(60))
  call Hloop_AQ_V(ntryL,G1H8(17),ex2(:),G1H4(42),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_AQ_V(ntryL,G1H8(18),ex2(:),G1H4(43),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_VQ_A(ntryL,G1H8(19),ex2(:),G1H4(44),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(44),39,0,G2H4(53),n2h4(61))
  call Hloop_QA_V(ntryL,G1H8(20),ex3(:),G1H4(48),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QA_V(ntryL,G1H8(24),ex4(:),G1H4(49),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(50),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_AQ_V(ntryL,G1H8(30),ex1(:),G1H4(54),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_VQ_A(ntryL,G1H8(31),ex1(:),G1H4(55),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(55),39,0,G2H4(54),n2h4(62))
  call Hloop_QA_V(ntryL,G1H8(32),ex3(:),G1H4(56),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_QA_V(ntryL,G1H8(36),ex4(:),G1H4(60),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_AQ_V(ntryL,G1H8(41),ex1(:),G1H4(61),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_AQ_V(ntryL,G1H8(42),ex2(:),G1H4(62),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(66),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(66),39,0,G2H4(55),n2h4(63))
  call Hloop_VQ_A(ntryL,G1H8(44),ex2(:),G1H4(67),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(67),39,0,G2H4(56),n2h4(64))
  call Hloop_QA_V(ntryL,G1H8(47),ex4(:),G1H4(68),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_V(ntryL,G1H8(48),ex4(:),G1H4(72),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(73),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(73),45,0,G2H4(57),n2h4(65))
  call Hloop_QV_A(ntryL,G1H8(2),ex5(:),G1H4(74),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(74),53,0,G2H4(58),n2h4(66))
  call Hloop_AQ_V(ntryL,G1H8(5),ex1(:),G1H4(78),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_AQ_V(ntryL,G1H8(6),ex2(:),G1H4(79),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(80),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(80),43,0,G2H4(59),n2h4(67))
  call Hloop_VQ_A(ntryL,G1H8(8),ex2(:),G1H4(84),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(84),43,0,G2H4(60),n2h4(68))
  call Hloop_QA_V(ntryL,G1H8(11),ex3(:),G1H4(85),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_QA_V(ntryL,G1H8(12),ex3(:),G1H4(86),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_VA_Q(ntryL,G1H8(13),ex3(:),G1H4(90),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(90),45,0,G2H4(61),n2h4(69))
  call Hloop_QV_A(ntryL,G1H8(14),ex5(:),G1H4(91),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(91),57,0,G2H4(62),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H8(3),ex5(:),G1H4(92),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(92),53,0,G2H4(63),n2h4(71))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-8,0,G2H8(39),n2h8(105))
  call Hloop_QA_V(ntryL,G2H8(39),ex4(:),G2H4(64),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(10),ex5(:),G1H4(96),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(96),53,0,G2H4(65),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(15),ex5(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(66),n2h4(73))
  call Hloop_AV_Q(ntryL,G1H8(21),ex5(:),G1H4(2),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(67),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(33),ex5(:),G1H4(6),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(6),54,0,G2H4(68),n2h4(75))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(34),-8,0,G2H8(39),n2h8(106))
  call Hloop_QA_V(ntryL,G2H8(39),ex4(:),G2H4(69),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_AV_Q(ntryL,G1H8(40),ex5(:),G1H4(7),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(7),54,0,G2H4(70),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(37),ex5(:),G1H4(8),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(8),54,0,G2H4(71),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(16),ex5(:),G1H4(12),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(12),54,0,G2H4(72),n2h4(78))
call HGT_lower_alpha_w2_OLR(G2H4(18),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(18),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(18),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(19)])
call HGT_lower_alpha_w2_OLR(G2H4(22),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(22),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(22),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(23)])
call HGT_lower_alpha_w2_OLR(G2H4(26),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(26),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(26),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(27)])
call HGT_lower_alpha_w2_OLR(G2H4(30),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(30),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(30),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(35)])
call HGT_lower_alpha_w2_OLR(G2H4(38),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(38),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(38),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(43)])
call HGT_lower_alpha_w2_OLR(G2H4(46),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(46),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(46),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(53),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(59),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(65),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(71),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(77),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(89),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(83),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(95),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(94)])
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(25),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(18),G1H4(19),G1H4(20),G1H4(24),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hloop_QA_V(ntryL,G2H4(14),ex3(:),G2H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(26),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(30),G1H4(31),G1H4(32),G1H4(36),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hloop_QA_V(ntryL,G2H4(13),ex4(:),G2H2(3),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(27),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(44),G1H4(55),G1H4(66),G1H4(67),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hloop_QA_V(ntryL,G2H4(16),ex3(:),G2H2(5),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(28),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(80),G1H4(84),G1H4(90),G1H4(91),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(7),m3h2x2(:,68),heltab2x4(:,:,68))
call HGT_lower_alpha_w2_OLR(G2H4(34),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(34),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(34),6,15,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(29),mass5set(:,1),  & 
G1H4(92),G1H4(96),G1H4(1),G1H4(2),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(96),1,4)
  call Hloop_AQ_V(ntryL,G2H4(51),ex1(:),G2H2(9),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(30),mass5set(:,1),  & 
G1H4(8),G1H4(12),G1H4(3),G1H4(4),G1H4(53),G1H4(5),4)
  call HG1shiftOLR(G1H4(12),2,4)
  call Hloop_AQ_V(ntryL,G2H4(50),ex2(:),G2H2(11),m3h2x2(:,70),heltab2x4(:,:,70))
call HGT_lower_alpha_w2_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(42),6,15,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(31),mass5set(:,1),  & 
G1H4(9),G1H4(10),G1H4(59),G1H4(11),G1H4(15),G1H4(65),4)
  call HG1shiftOLR(G1H4(10),1,4)
  call Hloop_AQ_V(ntryL,G2H4(49),ex1(:),G2H2(13),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(32),mass5set(:,1),  & 
G1H4(17),G1H4(21),G1H4(22),G1H4(71),G1H4(23),G1H4(27),4)
  call HG1shiftOLR(G1H4(21),2,4)
  call Hloop_AQ_V(ntryL,G2H4(52),ex2(:),G2H2(15),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_VQ_A(ntryL,G1H4(78),ex2(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(33))
  call Hloop_VQ_A(ntryL,G1H4(16),ex2(:),G1H2(2),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(20),n2h2(34))
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(33),mass5set(:,1),  & 
G1H4(28),G1H4(77),G1H4(29),G1H4(33),G1H4(89),G1H4(35),4)
  call HG1shiftOLR(G1H4(77),16,4)
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(7),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(23),n2h2(35))
  call Hloop_VA_Q(ntryL,G1H4(40),ex4(:),G1H2(8),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(26),n2h2(36))
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(34),mass5set(:,1),  & 
G1H4(39),G1H4(83),G1H4(41),G1H4(45),G1H4(95),G1H4(47),4)
  call HG1shiftOLR(G1H4(83),16,4)
  call Hloop_VQ_A(ntryL,G1H4(61),ex2(:),G1H2(13),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(29),n2h2(37))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(35),mass5set(:,1),  & 
G1H4(51),G1H4(52),G1H4(57),G1H4(58),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hloop_VA_Q(ntryL,G1H4(60),ex3(:),G1H2(14),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(14),47,0,G2H2(32),n2h2(38))
  call Hloop_VA_Q(ntryL,G1H4(46),ex3(:),G1H2(19),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(19),47,0,G2H2(35),n2h2(39))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(36),mass5set(:,1),  & 
G1H4(69),G1H4(70),G1H4(75),G1H4(76),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(70),16,4)
  call Hloop_VQ_A(ntryL,G1H4(79),ex1(:),G1H2(20),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(38),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(34),ex1(:),G1H2(25),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(41),n2h2(41))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(37),mass5set(:,1),  & 
G1H4(87),G1H4(88),G1H4(93),G1H4(94),G1H4(78),G1H4(16),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hloop_VQ_A(ntryL,G1H4(62),ex1(:),G1H2(26),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(44),n2h2(42))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(38),mass5set(:,1),  & 
G1H4(56),G1H4(40),G1H4(61),G1H4(60),G1H4(46),G1H4(79),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(31),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(47),n2h2(43))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(39),mass5set(:,1),  & 
G1H4(34),G1H4(62),G1H4(48),G1H4(97),G1H4(98),G1H4(99),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hloop_VA_Q(ntryL,G1H4(49),ex3(:),G1H2(32),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(50),n2h2(44))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(40),mass5set(:,1),  & 
G1H4(49),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),16,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex2(:),G1H2(37),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(53),n2h2(45))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(41),mass5set(:,1),  & 
G1H4(86),G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),4)
  call HG1shiftOLR(G1H4(105),16,4)
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(38),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(56),n2h2(46))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(42),mass5set(:,1),  & 
G1H4(54),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hloop_VQ_A(ntryL,G1H4(72),ex2(:),G1H2(43),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(59),n2h2(47))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(43),mass5set(:,1),  & 
G1H4(72),G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),4)
  call HG1shiftOLR(G1H4(115),16,4)
  call Hloop_VA_Q(ntryL,G1H4(50),ex3(:),G1H2(44),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(62),n2h2(48))
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(44),mass5set(:,1),  & 
G1H4(50),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),16,4)
  call Hloop_VQ_A(ntryL,G1H4(85),ex1(:),G1H2(49),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(65),n2h2(49))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(45),mass5set(:,1),  & 
G1H4(85),G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),4)
  call HG1shiftOLR(G1H4(125),16,4)
  call Hloop_VA_Q(ntryL,G1H4(43),ex4(:),G1H2(50),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(50),47,0,G2H2(66),n2h2(50))
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(46),mass5set(:,1),  & 
G1H4(43),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),16,4)
  call Hloop_VQ_A(ntryL,G1H4(68),ex1(:),G1H2(55),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(67),n2h2(51))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(47),mass5set(:,1),  & 
G1H4(68),G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),4)
  call HG1shiftOLR(G1H4(135),16,4)
  call Hloop_VA_Q(ntryL,G1H4(42),ex3(:),G1H2(56),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(68),n2h2(52))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(48),mass5set(:,1),  & 
G1H4(42),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(69),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_QA_V(ntryL,G2H4(20),ex3(:),G2H2(70),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QA_V(ntryL,G2H4(21),ex4(:),G2H2(71),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(72),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QA_V(ntryL,G2H4(25),ex3(:),G2H2(73),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_V(ntryL,G2H4(28),ex4(:),G2H2(74),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AQ_V(ntryL,G2H4(29),ex1(:),G2H2(75),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_V(ntryL,G2H4(32),ex1(:),G2H2(76),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_V(ntryL,G2H4(33),ex2(:),G2H2(77),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_V(ntryL,G2H4(36),ex1(:),G2H2(78),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_V(ntryL,G2H4(37),ex2(:),G2H2(79),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_V(ntryL,G2H4(40),ex2(:),G2H2(80),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(3),mass5set(:,1),  & 
G1H8(45),G1H8(46),G1H8(38),G1H8(22),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(46),5,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(49),mass5set(:,1),  & 
G1H8(27),G1H8(28),G1H8(23),G1H8(35),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(28),16,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(50),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(24),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(6),mass5set(:,1),  & 
G1H8(32),G1H8(36),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(36),6,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(51),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(1),G1H8(2),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(48),16,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(52),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(53),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(10),G1H8(15),G1H8(21),G1H8(33),8)
  call HG1shiftOLR(G1H8(4),9,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(5),mass5set(:,1),  & 
G1H8(34),G1H8(40),G1H8(37),G1H8(16),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(40),9,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(54),mass5set(:,1),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(52),16,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(55),mass5set(:,1),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(56),mass5set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),10,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(4),mass5set(:,1),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),10,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(57),mass5set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(58),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),16,8)
  call Hloop_QA_V(ntryL,G2H8(9),ex4(:),G2H4(59),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_QA_V(ntryL,G2H8(12),ex3(:),G2H4(19),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AQ_V(ntryL,G2H8(10),wf4(:,12),G2H2(81),m3h4x2(:,1),heltab2x8(:,:,107))
  call Hloop_AQ_V(ntryL,G2H8(11),ex2(:),G2H4(55),m3h2x4(:,107),heltab2x8(:,:,108))
  call Hloop_AQ_V(ntryL,G2H8(13),wf4(:,12),G2H2(82),m3h4x2(:,2),heltab2x8(:,:,109))
  call Hloop_AQ_V(ntryL,G2H8(14),ex2(:),G2H4(23),m3h2x4(:,108),heltab2x8(:,:,110))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(60),m3h2x4(:,109),heltab2x8(:,:,111))
  call Hloop_QA_V(ntryL,G2H8(16),ex3(:),G2H4(27),m3h2x4(:,110),heltab2x8(:,:,112))
  call Hloop_AQ_V(ntryL,G2H8(17),wf4(:,4),G2H2(83),m3h4x2(:,3),heltab2x8(:,:,113))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(56),m3h2x4(:,111),heltab2x8(:,:,114))
  call Hloop_AQ_V(ntryL,G2H8(25),wf4(:,4),G2H2(84),m3h4x2(:,4),heltab2x8(:,:,115))
  call Hloop_AQ_V(ntryL,G2H8(26),ex1(:),G2H4(31),m3h2x4(:,112),heltab2x8(:,:,116))
  call Hloop_QA_V(ntryL,G2H8(27),ex4(:),G2H4(35),m3h2x4(:,113),heltab2x8(:,:,117))
  call Hloop_QA_V(ntryL,G2H8(28),ex4(:),G2H4(61),m3h2x4(:,114),heltab2x8(:,:,118))
  call Hloop_QA_V(ntryL,G2H8(29),wf4(:,19),G2H2(85),m3h4x2(:,5),heltab2x8(:,:,119))
  call Hloop_QA_V(ntryL,G2H8(30),wf4(:,19),G2H2(86),m3h4x2(:,6),heltab2x8(:,:,120))
  call Hloop_AQ_V(ntryL,G2H8(31),ex2(:),G2H4(39),m3h2x4(:,115),heltab2x8(:,:,121))
  call Hloop_AQ_V(ntryL,G2H8(32),ex1(:),G2H4(43),m3h2x4(:,116),heltab2x8(:,:,122))
  call Hloop_QA_V(ntryL,G2H8(33),ex3(:),G2H4(57),m3h2x4(:,117),heltab2x8(:,:,123))
  call Hloop_QA_V(ntryL,G2H8(34),ex3(:),G2H4(47),m3h2x4(:,118),heltab2x8(:,:,124))
  call Hloop_QA_V(ntryL,G2H8(35),wf4(:,9),G2H2(87),m3h4x2(:,7),heltab2x8(:,:,125))
  call Hloop_QA_V(ntryL,G2H8(36),wf4(:,9),G2H2(88),m3h4x2(:,8),heltab2x8(:,:,126))
  call Hloop_AQ_V(ntryL,G2H8(37),ex2(:),G2H4(18),m3h2x4(:,119),heltab2x8(:,:,127))
  call Hloop_AQ_V(ntryL,G2H8(38),ex1(:),G2H4(14),m3h2x4(:,120),heltab2x8(:,:,128))
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(59),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(60),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hloop_QA_V(ntryL,G2H4(58),ex4(:),G2H2(89),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_QA_V(ntryL,G2H4(62),ex3(:),G2H2(90),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AQ_V(ntryL,G2H4(63),ex2(:),G2H2(91),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_V(ntryL,G2H4(66),ex2(:),G2H2(92),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_AQ_V(ntryL,G2H4(67),ex2(:),G2H2(93),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AQ_V(ntryL,G2H4(68),ex1(:),G2H2(94),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AQ_V(ntryL,G2H4(71),ex1(:),G2H2(95),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AQ_V(ntryL,G2H4(72),ex1(:),G2H2(96),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntryL,G1H4(13),ex5(:),G1H2(61),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(61),59,0,G2H2(97),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex3(:),G1H2(62),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QV_A(ntryL,G1H4(20),ex5(:),G1H2(67),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(98),n2h2(54))
  call Hloop_QV_A(ntryL,G1H4(24),ex5(:),G1H2(68),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(99),n2h2(55))
  call Hloop_QV_A(ntryL,G1H4(25),ex5(:),G1H2(73),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(73),55,0,G2H2(100),n2h2(56))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(74),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QV_A(ntryL,G1H4(32),ex5(:),G1H2(79),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(79),55,0,G2H2(101),n2h2(57))
  call Hloop_QV_A(ntryL,G1H4(36),ex5(:),G1H2(80),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(80),55,0,G2H2(102),n2h2(58))
  call Hloop_QV_A(ntryL,G1H4(37),ex5(:),G1H2(85),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(85),59,0,G2H2(103),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex3(:),G1H2(86),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QV_A(ntryL,G1H4(66),ex5(:),G1H2(91),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(91),59,0,G2H2(104),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(67),ex5(:),G1H2(92),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(92),59,0,G2H2(105),n2h2(61))
  call Hloop_QV_A(ntryL,G1H4(73),ex5(:),G1H2(97),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(106),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(98),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(103),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(103),55,0,G2H2(107),n2h2(63))
  call Hloop_QV_A(ntryL,G1H4(91),ex5(:),G1H2(104),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(104),55,0,G2H2(108),n2h2(64))
  call Hloop_AV_Q(ntryL,G1H4(92),ex5(:),G1H2(109),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(109),62,0,G2H2(109),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(96),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(96),ex1(:),G1H2(110),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AV_Q(ntryL,G1H4(6),ex5(:),G1H2(115),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(115),62,0,G2H2(110),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(7),ex5(:),G1H2(116),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(116),62,0,G2H2(111),n2h2(67))
  call Hloop_AV_Q(ntryL,G1H4(8),ex5(:),G1H2(121),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(121),61,0,G2H2(112),n2h2(68))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(12),ex2(:),G1H2(122),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_AV_Q(ntryL,G1H4(53),ex5(:),G1H2(127),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(113),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(5),ex5(:),G1H2(128),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(128),61,0,G2H2(114),n2h2(70))
  call Hloop_AV_Q(ntryL,G1H4(9),ex5(:),G1H2(133),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(133),62,0,G2H2(115),n2h2(71))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex1(:),G1H2(134),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_AV_Q(ntryL,G1H4(15),ex5(:),G1H2(139),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(139),62,0,G2H2(116),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H4(65),ex5(:),G1H2(140),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(140),62,0,G2H2(117),n2h2(73))
  call Hloop_AV_Q(ntryL,G1H4(17),ex5(:),G1H2(1),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(1),61,0,G2H2(118),n2h2(74))
call HGT_raise_alpha_OLR(G1H4(21),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(21),ex2(:),G1H2(2),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AV_Q(ntryL,G1H4(23),ex5(:),G1H2(7),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(7),61,0,G2H2(119),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(27),ex5(:),G1H2(8),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(8),61,0,G2H2(120),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(28),ex2(:),G1H2(13),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(121),n2h2(77))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(77),-16,0,G2H4(22),n2h4(87))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(122),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_VQ_A(ntryL,G1H4(89),ex2(:),G1H2(14),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(123),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(35),ex2(:),G1H2(19),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(124),n2h2(79))
  call Hloop_VA_Q(ntryL,G1H4(39),ex4(:),G1H2(20),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(125),n2h2(80))
call HGT_OLR(G1H4(83),1,1,4)
call HGT_invQ_OLR(G1H4(83),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(83),-16,0,G2H4(13),n2h4(88))
  call Hloop_QV_A(ntryL,G2H4(13),ex5(:),G2H2(126),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_VA_Q(ntryL,G1H4(95),ex4(:),G1H2(25),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(127),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(47),ex4(:),G1H2(26),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(26),47,0,G2H2(128),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(51),ex2(:),G1H2(31),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(129),n2h2(83))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-16,0,G2H4(26),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(26),ex5(:),G2H2(130),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_VQ_A(ntryL,G1H4(63),ex2(:),G1H2(32),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(131),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(64),ex2(:),G1H2(37),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(132),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(69),ex3(:),G1H2(38),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(133),n2h2(86))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(70),-16,0,G2H4(16),n2h4(90))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(134),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_VA_Q(ntryL,G1H4(81),ex3(:),G1H2(43),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(135),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(82),ex3(:),G1H2(44),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(136),n2h2(88))
  call Hloop_VQ_A(ntryL,G1H4(87),ex1(:),G1H2(49),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(137),n2h2(89))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(88),-16,0,G2H4(30),n2h4(91))
  call Hloop_AV_Q(ntryL,G2H4(30),ex5(:),G2H2(138),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(50),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(139),n2h2(90))
  call Hloop_VQ_A(ntryL,G1H4(16),ex1(:),G1H2(55),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(140),n2h2(91))
  call Hloop_VQ_A(ntryL,G1H4(56),ex1(:),G1H2(56),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(141),n2h2(92))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-16,0,G2H4(15),n2h4(92))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(142),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_VQ_A(ntryL,G1H4(46),ex1(:),G1H2(61),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(143),n2h2(93))
  call Hloop_VQ_A(ntryL,G1H4(79),ex1(:),G1H2(67),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(67),47,0,G2H2(144),n2h2(94))
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(68),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(68),47,0,G2H2(145),n2h2(95))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(62),-16,0,G2H4(34),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(34),ex5(:),G2H2(146),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(73),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(73),47,0,G2H2(147),n2h2(96))
  call Hloop_VA_Q(ntryL,G1H4(99),ex4(:),G1H2(79),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(148),n2h2(97))
  call Hloop_VA_Q(ntryL,G1H4(49),ex3(:),G1H2(80),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(149),n2h2(98))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(100),-16,0,G2H4(51),n2h4(94))
  call Hloop_QV_A(ntryL,G2H4(51),ex5(:),G2H2(150),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VA_Q(ntryL,G1H4(103),ex3(:),G1H2(85),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(85),47,0,G2H2(151),n2h2(99))
  call Hloop_VA_Q(ntryL,G1H4(104),ex3(:),G1H2(91),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(152),n2h2(100))
  call Hloop_VQ_A(ntryL,G1H4(86),ex2(:),G1H2(92),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(92),47,0,G2H2(153),n2h2(101))
call HGT_OLR(G1H4(105),1,1,4)
call HGT_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(105),-16,0,G2H4(38),n2h4(95))
  call Hloop_AV_Q(ntryL,G2H4(38),ex5(:),G2H2(154),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_VQ_A(ntryL,G1H4(108),ex2(:),G1H2(97),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(155),n2h2(102))
  call Hloop_VQ_A(ntryL,G1H4(109),ex2(:),G1H2(103),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(103),47,0,G2H2(156),n2h2(103))
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(104),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(157),n2h2(104))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-16,0,G2H4(50),n2h4(96))
  call Hloop_QV_A(ntryL,G2H4(50),ex5(:),G2H2(158),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_VA_Q(ntryL,G1H4(113),ex4(:),G1H2(109),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(159),n2h2(105))
  call Hloop_VA_Q(ntryL,G1H4(114),ex4(:),G1H2(115),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(115),47,0,G2H2(160),n2h2(106))
  call Hloop_VQ_A(ntryL,G1H4(72),ex2(:),G1H2(116),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(116),47,0,G2H2(161),n2h2(107))
call HGT_OLR(G1H4(115),1,1,4)
call HGT_invQ_OLR(G1H4(115),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(115),-16,0,G2H4(42),n2h4(97))
  call Hloop_AV_Q(ntryL,G2H4(42),ex5(:),G2H2(162),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(118),ex2(:),G1H2(121),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(121),47,0,G2H2(163),n2h2(108))
  call Hloop_VQ_A(ntryL,G1H4(119),ex2(:),G1H2(127),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(127),47,0,G2H2(164),n2h2(109))
  call Hloop_VA_Q(ntryL,G1H4(50),ex3(:),G1H2(128),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(165),n2h2(110))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(120),-16,0,G2H4(49),n2h4(98))
  call Hloop_QV_A(ntryL,G2H4(49),ex5(:),G2H2(166),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_VA_Q(ntryL,G1H4(123),ex3(:),G1H2(133),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(167),n2h2(111))
  call Hloop_VA_Q(ntryL,G1H4(124),ex3(:),G1H2(139),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(139),47,0,G2H2(168),n2h2(112))
  call Hloop_VQ_A(ntryL,G1H4(85),ex1(:),G1H2(140),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(169),n2h2(113))
call HGT_OLR(G1H4(125),1,1,4)
call HGT_invQ_OLR(G1H4(125),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(125),-16,0,G2H4(46),n2h4(99))
  call Hloop_AV_Q(ntryL,G2H4(46),ex5(:),G2H2(170),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_VQ_A(ntryL,G1H4(128),ex1(:),G1H2(1),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(171),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(129),ex1(:),G1H2(7),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(172),n2h2(115))
  call Hloop_VA_Q(ntryL,G1H4(43),ex4(:),G1H2(8),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(173),n2h2(116))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(130),-16,0,G2H4(52),n2h4(100))
  call Hloop_QV_A(ntryL,G2H4(52),ex5(:),G2H2(174),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_VA_Q(ntryL,G1H4(133),ex4(:),G1H2(13),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(13),47,0,G2H2(175),n2h2(117))
  call Hloop_VA_Q(ntryL,G1H4(134),ex4(:),G1H2(14),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(14),47,0,G2H2(176),n2h2(118))
  call Hloop_VQ_A(ntryL,G1H4(68),ex1(:),G1H2(19),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(177),n2h2(119))
call HGT_OLR(G1H4(135),1,1,4)
call HGT_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(135),-16,0,G2H4(45),n2h4(101))
  call Hloop_AV_Q(ntryL,G2H4(45),ex5(:),G2H2(178),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_VQ_A(ntryL,G1H4(138),ex1(:),G1H2(20),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(179),n2h2(120))
  call Hloop_VQ_A(ntryL,G1H4(139),ex1(:),G1H2(25),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(180),n2h2(121))
  call Hloop_VA_Q(ntryL,G1H4(42),ex3(:),G1H2(26),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(26),47,0,G2H2(181),n2h2(122))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-16,0,G2H4(48),n2h4(102))
  call Hloop_QV_A(ntryL,G2H4(48),ex5(:),G2H2(182),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_VA_Q(ntryL,G1H4(143),ex3(:),G1H2(31),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(183),n2h2(123))
  call Hloop_VA_Q(ntryL,G1H4(144),ex3(:),G1H2(32),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(184),n2h2(124))
  call Hloop_AV_Q(ntryL,G1H8(45),ex5(:),G1H4(13),m3h2x4(:,121),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(13),58,0,G2H4(7),n2h4(103))
call HGT_OLR(G1H8(46),1,1,8)
call HGT_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(46),-5,0,G2H8(39),n2h8(107))
  call Hloop_QV_A(ntryL,G2H8(39),wf4(:,1),G2H2(185),m3h4x2(:,9),heltab2x8(:,:,130))
  call Hloop_AV_Q(ntryL,G1H8(25),ex5(:),G1H4(14),m3h2x4(:,122),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(14),58,0,G2H4(8),n2h4(104))
  call Hloop_AV_Q(ntryL,G1H8(26),ex5(:),G1H4(20),m3h2x4(:,123),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(20),58,0,G2H4(3),n2h4(105))
  call Hloop_AV_Q(ntryL,G1H8(27),wf4(:,1),G1H2(37),m3h4x2(:,10),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(186),n2h2(125))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-16,0,G2H8(19),n2h8(108))
  call Hloop_QV_A(ntryL,G2H8(19),ex5(:),G2H4(11),m3h2x4(:,124),heltab2x8(:,:,134))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,1),G1H2(38),m3h4x2(:,11),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(187),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,1),G1H2(43),m3h4x2(:,12),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(188),n2h2(127))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,1),G1H2(44),m3h4x2(:,13),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(189),n2h2(128))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,0,G2H8(20),n2h8(109))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(4),m3h2x4(:,125),heltab2x8(:,:,138))
  call Hloop_QV_A(ntryL,G1H8(30),wf4(:,1),G1H2(49),m3h4x2(:,14),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(190),n2h2(129))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,1),G1H2(50),m3h4x2(:,15),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(191),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H8(32),ex5(:),G1H4(24),m3h2x4(:,126),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(24),57,0,G2H4(12),n2h4(106))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-6,0,G2H8(21),n2h8(110))
  call Hloop_QV_A(ntryL,G2H8(21),wf4(:,11),G2H2(192),m3h4x2(:,16),heltab2x8(:,:,142))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(25),m3h2x4(:,127),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(25),57,0,G2H4(5),n2h4(107))
  call Hloop_AV_Q(ntryL,G1H8(44),ex5(:),G1H4(26),m3h2x4(:,128),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(26),57,0,G2H4(2),n2h4(108))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,11),G1H2(55),m3h4x2(:,17),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(193),n2h2(131))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-16,0,G2H8(22),n2h8(111))
  call Hloop_QV_A(ntryL,G2H8(22),ex5(:),G2H4(41),m3h2x4(:,129),heltab2x8(:,:,146))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,11),G1H2(56),m3h4x2(:,18),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(194),n2h2(132))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,11),G1H2(61),m3h4x2(:,19),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(195),n2h2(133))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,11),G1H2(67),m3h4x2(:,20),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(67),47,0,G2H2(196),n2h2(134))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,0,G2H8(23),n2h8(112))
  call Hloop_AV_Q(ntryL,G2H8(23),ex5(:),G2H4(10),m3h2x4(:,130),heltab2x8(:,:,150))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,11),G1H2(68),m3h4x2(:,21),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(197),n2h2(135))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,11),G1H2(73),m3h4x2(:,22),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(198),n2h2(136))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(32),m3h2x4(:,131),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(32),54,0,G2H4(9),n2h4(109))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(4),-9,0,G2H8(24),n2h8(113))
  call Hloop_AV_Q(ntryL,G2H8(24),wf4(:,15),G2H2(199),m3h4x2(:,23),heltab2x8(:,:,154))
  call Hloop_QV_A(ntryL,G1H8(21),ex5(:),G1H4(36),m3h2x4(:,132),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(36),54,0,G2H4(44),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(37),m3h2x4(:,133),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(37),54,0,G2H4(1),n2h4(111))
  call Hloop_AV_Q(ntryL,G1H8(34),ex5(:),G1H4(38),m3h2x4(:,134),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(38),54,0,G2H4(6),n2h4(112))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(40),-9,0,G2H8(1),n2h8(114))
  call Hloop_QV_A(ntryL,G2H8(1),wf4(:,15),G2H2(200),m3h4x2(:,24),heltab2x8(:,:,158))
  call Hloop_AV_Q(ntryL,G1H8(49),ex5(:),G1H4(66),m3h2x4(:,135),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(66),54,0,G2H4(17),n2h4(113))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(67),m3h2x4(:,136),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(67),54,0,G2H4(20),n2h4(114))
  call Hloop_AV_Q(ntryL,G1H8(51),wf4(:,15),G1H2(79),m3h4x2(:,25),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(201),n2h2(137))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(52),-16,0,G2H8(2),n2h8(115))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(21),m3h2x4(:,137),heltab2x8(:,:,162))
  call Hloop_AV_Q(ntryL,G1H8(55),wf4(:,15),G1H2(80),m3h4x2(:,26),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(202),n2h2(138))
  call Hloop_AV_Q(ntryL,G1H8(56),wf4(:,15),G1H2(85),m3h4x2(:,27),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(85),47,0,G2H2(203),n2h2(139))
  call Hloop_QV_A(ntryL,G1H8(57),wf4(:,15),G1H2(91),m3h4x2(:,28),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(204),n2h2(140))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(58),-16,0,G2H8(3),n2h8(116))
  call Hloop_AV_Q(ntryL,G2H8(3),ex5(:),G2H4(24),m3h2x4(:,138),heltab2x8(:,:,166))
  call Hloop_QV_A(ntryL,G1H8(61),wf4(:,15),G1H2(92),m3h4x2(:,29),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(92),47,0,G2H2(205),n2h2(141))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,15),G1H2(97),m3h4x2(:,30),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(206),n2h2(142))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(73),m3h2x4(:,139),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(73),53,0,G2H4(25),n2h4(115))
call HGT_OLR(G1H8(64),1,1,8)
call HGT_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(64),-10,0,G2H8(4),n2h8(117))
  call Hloop_AV_Q(ntryL,G2H8(4),wf4(:,20),G2H2(207),m3h4x2(:,31),heltab2x8(:,:,170))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(74),m3h2x4(:,140),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(74),53,0,G2H4(28),n2h4(116))
  call Hloop_QV_A(ntryL,G1H8(68),ex5(:),G1H4(90),m3h2x4(:,141),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(90),53,0,G2H4(29),n2h4(117))
  call Hloop_AV_Q(ntryL,G1H8(69),ex5(:),G1H4(91),m3h2x4(:,142),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(91),53,0,G2H4(32),n2h4(118))
call HGT_OLR(G1H8(70),1,1,8)
call HGT_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(70),-10,0,G2H8(5),n2h8(118))
  call Hloop_QV_A(ntryL,G2H8(5),wf4(:,20),G2H2(208),m3h4x2(:,32),heltab2x8(:,:,174))
  call Hloop_AV_Q(ntryL,G1H8(73),ex5(:),G1H4(92),m3h2x4(:,143),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(92),53,0,G2H4(33),n2h4(119))
  call Hloop_AV_Q(ntryL,G1H8(74),ex5(:),G1H4(96),m3h2x4(:,144),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(96),53,0,G2H4(36),n2h4(120))
  call Hloop_AV_Q(ntryL,G1H8(75),wf4(:,20),G1H2(103),m3h4x2(:,33),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(103),47,0,G2H2(209),n2h2(143))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(76),-16,0,G2H8(6),n2h8(119))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(37),m3h2x4(:,145),heltab2x8(:,:,178))
  call Hloop_AV_Q(ntryL,G1H8(79),wf4(:,20),G1H2(104),m3h4x2(:,34),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(210),n2h2(144))
  call Hloop_AV_Q(ntryL,G1H8(80),wf4(:,20),G1H2(109),m3h4x2(:,35),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(211),n2h2(145))
  call Hloop_QV_A(ntryL,G1H8(81),wf4(:,20),G1H2(115),m3h4x2(:,36),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(115),47,0,G2H2(212),n2h2(146))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(82),-16,0,G2H8(7),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(40),m3h2x4(:,146),heltab2x8(:,:,182))
  call Hloop_QV_A(ntryL,G1H8(85),wf4(:,20),G1H2(116),m3h4x2(:,37),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(116),47,0,G2H2(213),n2h2(147))
  call Hloop_QV_A(ntryL,G1H8(86),wf4(:,20),G1H2(121),m3h4x2(:,38),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(121),47,0,G2H2(214),n2h2(148))
  call Hloop_QV_A(ntryL,G1H4(145),ex5(:),G1H2(127),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(127),55,0,G2H2(215),n2h2(149))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(146),ex4(:),G1H2(128),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_QV_A(ntryL,G1H4(149),ex5(:),G1H2(133),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(133),55,0,G2H2(216),n2h2(150))
  call Hloop_QV_A(ntryL,G1H4(150),ex5(:),G1H2(139),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(139),55,0,G2H2(217),n2h2(151))
  call Hloop_QV_A(ntryL,G1H4(151),ex5(:),G1H2(140),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(140),55,0,G2H2(218),n2h2(152))
call HGT_raise_alpha_OLR(G1H4(152),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(152),ex4(:),G1H2(1),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QV_A(ntryL,G1H4(155),ex5(:),G1H2(7),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(219),n2h2(153))
  call Hloop_QV_A(ntryL,G1H4(156),ex5(:),G1H2(8),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(220),n2h2(154))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(2),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(4),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(6),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(8),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(10),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(12),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(14),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(16),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(19),G1H2(78),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(22),G1H2(72),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(25),G1H2(84),G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(37),G1H2(96),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G2H2(43),G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G2H2(46),G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(212),[G2H2(49),G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G2H2(52),G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G2H2(55),G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(209),[G2H2(58),G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G2H2(61),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G2H2(64),G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G1H2(16),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(22),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(64),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G1H2(101),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(88),G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(107),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(113),G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(94),G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(119),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(82),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G1H2(125),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G1H2(137),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G1H2(131),G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G1H2(143),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G1H2(142)])
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(61),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(19),G1H2(20),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(62),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(37),G1H2(38),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(32),4,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(63),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(55),G1H2(56),G1H2(61),G1H2(67),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(64),mass5set(:,1),  & 
G1H2(68),G1H2(73),G1H2(79),G1H2(80),G1H2(85),G1H2(91),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(65),mass5set(:,1),  & 
G1H2(92),G1H2(97),G1H2(103),G1H2(104),G1H2(109),G1H2(115),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(66),mass5set(:,1),  & 
G1H2(116),G1H2(121),G1H2(127),G1H2(133),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(121),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(67),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(6),G1H2(12),G1H2(18),G1H2(24),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(68),mass5set(:,1),  & 
G1H2(30),G1H2(36),G1H2(42),G1H2(48),G1H2(78),G1H2(54),2)
  call HG1shiftOLR(G1H2(36),4,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(69),mass5set(:,1),  & 
G1H2(72),G1H2(60),G1H2(84),G1H2(66),G1H2(96),G1H2(90),2)
  call HG1shiftOLR(G1H2(60),2,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(70),mass5set(:,1),  & 
G1H2(102),G1H2(108),G1H2(114),G1H2(120),G1H2(126),G1H2(132),2)
  call HG1shiftOLR(G1H2(108),16,2)
call HGT_OLR(G2H2(21),1,1,2)
call HGT_invQ_OLR(G2H2(21),2,5,2)
call HGT_OLR(G2H2(21),6,15,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(71),mass5set(:,1),  & 
G1H2(138),G1H2(144),G1H2(3),G1H2(16),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(144),8,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(72),mass5set(:,1),  & 
G1H2(9),G1H2(22),G1H2(10),G1H2(11),G1H2(15),G1H2(17),2)
  call HG1shiftOLR(G1H2(22),16,2)
call HGT_OLR(G2H2(24),1,1,2)
call HGT_invQ_OLR(G2H2(24),2,5,2)
call HGT_OLR(G2H2(24),6,15,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(73),mass5set(:,1),  & 
G1H2(21),G1H2(23),G1H2(27),G1H2(28),G1H2(29),G1H2(33),2)
  call HG1shiftOLR(G1H2(23),2,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(74),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(39),G1H2(40),G1H2(41),G1H2(45),2)
  call HG1shiftOLR(G1H2(35),16,2)
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(75),mass5set(:,1),  & 
G1H2(46),G1H2(47),G1H2(51),G1H2(64),G1H2(52),G1H2(101),2)
  call HG1shiftOLR(G1H2(47),4,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(76),mass5set(:,1),  & 
G1H2(53),G1H2(57),G1H2(88),G1H2(58),G1H2(107),G1H2(59),2)
  call HG1shiftOLR(G1H2(57),1,2)
call HGT_OLR(G2H2(33),1,1,2)
call HGT_invQ_OLR(G2H2(33),2,5,2)
call HGT_OLR(G2H2(33),6,15,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(77),mass5set(:,1),  & 
G1H2(63),G1H2(113),G1H2(65),G1H2(69),G1H2(94),G1H2(70),2)
  call HG1shiftOLR(G1H2(113),1,2)
call HGT_OLR(G2H2(36),1,1,2)
call HGT_invQ_OLR(G2H2(36),2,5,2)
call HGT_OLR(G2H2(36),6,15,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(78),mass5set(:,1),  & 
G1H2(119),G1H2(71),G1H2(75),G1H2(82),G1H2(76),G1H2(125),2)
  call HG1shiftOLR(G1H2(71),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(79),mass5set(:,1),  & 
G1H2(77),G1H2(81),G1H2(137),G1H2(83),G1H2(87),G1H2(131),2)
  call HG1shiftOLR(G1H2(81),16,2)
call HGT_OLR(G2H2(39),1,1,2)
call HGT_invQ_OLR(G2H2(39),2,5,2)
call HGT_OLR(G2H2(39),6,15,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(80),mass5set(:,1),  & 
G1H2(89),G1H2(93),G1H2(143),G1H2(95),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(93),4,2)
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(81),mass5set(:,1),  & 
G1H2(105),G1H2(106),G1H2(111),G1H2(112),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(106),2,2)
  call Hotf_5pt_reduction(G2H2(196),RedSet_5(52),mass5set(:,1),  & 
G1H2(123),G1H2(124),G1H2(129),G1H2(130),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(124),16,2)
call HGT_OLR(G2H2(45),1,1,2)
call HGT_invQ_OLR(G2H2(45),2,5,2)
call HGT_OLR(G2H2(45),6,15,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(82),mass5set(:,1),  & 
G1H2(141),G1H2(142),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(142),8,2)
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(54),mass5set(:,1),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(150),16,2)
call HGT_OLR(G2H2(48),1,1,2)
call HGT_invQ_OLR(G2H2(48),2,5,2)
call HGT_OLR(G2H2(48),6,15,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(83),mass5set(:,1),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),2,2)
  call Hotf_5pt_reduction(G2H2(212),RedSet_5(58),mass5set(:,1),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),16,2)
call HGT_OLR(G2H2(51),1,1,2)
call HGT_invQ_OLR(G2H2(51),2,5,2)
call HGT_OLR(G2H2(51),6,15,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(84),mass5set(:,1),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),4,2)
  call Hotf_5pt_reduction(G2H2(186),RedSet_5(49),mass5set(:,1),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),16,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(85),mass5set(:,1),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(180),1,2)
  call Hotf_5pt_reduction(G2H2(189),RedSet_5(50),mass5set(:,1),  & 
G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(186),16,2)
call HGT_OLR(G2H2(57),1,1,2)
call HGT_invQ_OLR(G2H2(57),2,5,2)
call HGT_OLR(G2H2(57),6,15,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(86),mass5set(:,1),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(192),8,2)
  call Hotf_5pt_reduction(G2H2(209),RedSet_5(57),mass5set(:,1),  & 
G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(198),16,2)
call HGT_OLR(G2H2(60),1,1,2)
call HGT_invQ_OLR(G2H2(60),2,5,2)
call HGT_OLR(G2H2(60),6,15,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(87),mass5set(:,1),  & 
G1H2(203),G1H2(204),G1H2(205),G1H2(206),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(204),1,2)
  call Hotf_5pt_reduction(G2H2(204),RedSet_5(55),mass5set(:,1),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(210),16,2)
call HGT_OLR(G2H2(63),1,1,2)
call HGT_invQ_OLR(G2H2(63),2,5,2)
call HGT_OLR(G2H2(63),6,15,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(88),mass5set(:,1),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(216),4,2)
  call Hotf_5pt_reduction(G2H2(193),RedSet_5(51),mass5set(:,1),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),16,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(89),mass5set(:,1),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(90),mass5set(:,1),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),8,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(91),mass5set(:,1),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),8,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(92),mass5set(:,1),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),4,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(93),mass5set(:,1),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(252),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(94),mass5set(:,1),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),4,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(95),mass5set(:,1),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(96),mass5set(:,1),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),8,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(97),mass5set(:,1),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(276),4,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(98),mass5set(:,1),  & 
G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(282),4,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(99),mass5set(:,1),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),4,2)



end subroutine vamp_1

end module ol_vamp_1_ppaajj_uuuxuxaa_1_/**/REALKIND
