
module ol_vamp_16_ppaajj_ddxaagg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_16(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaajj_ddxaagg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaajj_ddxaagg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppaajj_ddxaagg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppaajj_ddxaagg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppaajj_ddxaagg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppaajj_ddxaagg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(3,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[32,8,23],[0,0,0],3,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,518),heltab2x64(:,:,766))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(32),n2h32(439))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,519),heltab2x64(:,:,767))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(31),n2h32(440))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[32,8,23],[0,0,0],3,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,520),heltab2x64(:,:,768))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(441))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,521),heltab2x64(:,:,769))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(37),n2h32(442))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[32,8,23],[0,0,0],3,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,522),heltab2x64(:,:,770))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(40),n2h32(443))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,523),heltab2x64(:,:,771))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(39),n2h32(444))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[32,8,23],[0,0,0],3,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,524),heltab2x64(:,:,772))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(42),n2h32(445))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,525),heltab2x64(:,:,773))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(38),n2h32(446))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[41,6,16],[0,0,0],3,2,wf8(:,29),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,29),G0H8(17),m3h8x8(:,125),heltab2x64(:,:,774))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[41,6,16],[0,0,0],3,2,wf8(:,29),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,29),G0H8(18),m3h8x8(:,126),heltab2x64(:,:,775))
  call Hloop_Q_A(ntryL,G0H8(18),41,0,G1H8(123),n2h8(996))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[49,6,8],[0,0,0],3,2,wf8(:,89),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,89),G0H8(19),m3h8x8(:,127),heltab2x64(:,:,776))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[33,14,16],[0,0,0],3,2,wf4(:,17),wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(33),m3h4x16(:,94),heltab2x64(:,:,777))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[33,14,16],[0,0,0],3,2,wf4(:,17),wf8(:,27))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(34),m3h4x16(:,95),heltab2x64(:,:,778))
  call Hloop_Q_A(ntryL,G0H16(34),33,0,G1H16(253),n2h16(458))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[33,8,22],[0,0,0],3,2,wf4(:,17),wf8(:,22))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(35),m3h4x16(:,96),heltab2x64(:,:,779))
  call Hloop_Q_A(ntryL,G0H16(35),33,0,G1H16(254),n2h16(459))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[39,8,16],[0,0,0],3,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,38),G0H4(68),m3h16x4(:,32),heltab2x64(:,:,780))
  call Hloop_A_Q(ntryL,G0H4(68),39,0,G1H4(80),n2h4(1495))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,38),G0H4(69),m3h16x4(:,33),heltab2x64(:,:,781))
  call Hloop_A_Q(ntryL,G0H4(69),39,nMT,G1H4(738),n2h4(1496))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[39,8,16],[0,0,0],3,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,38),G0H4(70),m3h16x4(:,34),heltab2x64(:,:,782))
  call Hloop_Q_A(ntryL,G0H4(70),39,0,G1H4(347),n2h4(1497))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,38),G0H4(71),m3h16x4(:,35),heltab2x64(:,:,783))
  call Hloop_Q_A(ntryL,G0H4(71),39,nMT,G1H4(105),n2h4(1498))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[39,8,16],[0,0,0],3,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,38),G0H4(72),m3h16x4(:,36),heltab2x64(:,:,784))
  call Hloop_A_Q(ntryL,G0H4(72),39,0,G1H4(811),n2h4(1499))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,38),G0H4(19),m3h16x4(:,37),heltab2x64(:,:,785))
  call Hloop_A_Q(ntryL,G0H4(19),39,nMB,G1H4(753),n2h4(1500))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[39,8,16],[0,0,0],3,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,38),G0H4(20),m3h16x4(:,38),heltab2x64(:,:,786))
  call Hloop_Q_A(ntryL,G0H4(20),39,0,G1H4(299),n2h4(1501))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,38),G0H4(21),m3h16x4(:,39),heltab2x64(:,:,787))
  call Hloop_Q_A(ntryL,G0H4(21),39,nMB,G1H4(383),n2h4(1502))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[48,7,8],[0,0,0],3,2,wf4(:,3),wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(36),m3h4x16(:,97),heltab2x64(:,:,788))
  call Hloop_Q_A(ntryL,G0H16(36),48,0,G1H16(255),n2h16(460))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[48,7,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(37),m3h4x16(:,98),heltab2x64(:,:,789))
  call Hloop_Q_A(ntryL,G0H16(37),48,nMT,G1H16(258),n2h16(461))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[48,7,8],[0,0,0],3,2,wf4(:,3),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(38),m3h4x16(:,99),heltab2x64(:,:,790))
  call Hloop_A_Q(ntryL,G0H16(38),48,0,G1H16(259),n2h16(462))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[48,7,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(39),m3h4x16(:,100),heltab2x64(:,:,791))
  call Hloop_A_Q(ntryL,G0H16(39),48,nMT,G1H16(260),n2h16(463))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[48,7,8],[0,0,0],3,2,wf4(:,3),wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(40),m3h4x16(:,101),heltab2x64(:,:,792))
  call Hloop_Q_A(ntryL,G0H16(40),48,0,G1H16(261),n2h16(464))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[48,7,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(41),m3h4x16(:,102),heltab2x64(:,:,793))
  call Hloop_Q_A(ntryL,G0H16(41),48,nMB,G1H16(264),n2h16(465))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[48,7,8],[0,0,0],3,2,wf4(:,3),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(42),m3h4x16(:,103),heltab2x64(:,:,794))
  call Hloop_A_Q(ntryL,G0H16(42),48,0,G1H16(265),n2h16(466))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[48,7,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(43),m3h4x16(:,104),heltab2x64(:,:,795))
  call Hloop_A_Q(ntryL,G0H16(43),48,nMB,G1H16(75),n2h16(467))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[49,6,8],[0,0,0],3,2,wf8(:,32),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,32),G0H8(22),m3h8x8(:,128),heltab2x64(:,:,796))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,27))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(44),m3h4x16(:,105),heltab2x64(:,:,797))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(78),n2h16(468))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,27))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(267),m3h4x16(:,106),heltab2x64(:,:,798))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[54,1,8],[0,0,0],3,1,wf16(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,15),G0H4(22),m3h16x4(:,40),heltab2x64(:,:,799))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[32,8,23],[0,0,0],3,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,526),heltab2x64(:,:,800))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(447))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,527),heltab2x64(:,:,801))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(47),n2h32(448))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[32,8,23],[0,0,0],3,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,528),heltab2x64(:,:,802))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(44),n2h32(449))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,529),heltab2x64(:,:,803))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(46),n2h32(450))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[32,8,23],[0,0,0],3,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,530),heltab2x64(:,:,804))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(48),n2h32(451))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,531),heltab2x64(:,:,805))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(53),n2h32(452))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[32,8,23],[0,0,0],3,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,532),heltab2x64(:,:,806))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(50),n2h32(453))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,533),heltab2x64(:,:,807))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(55),n2h32(454))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[39,8,16],[0,0,0],3,1,wf16(:,40))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,40),G0H4(23),m3h16x4(:,41),heltab2x64(:,:,808))
  call Hloop_A_Q(ntryL,G0H4(23),39,0,G1H4(110),n2h4(1503))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,40))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,40),G0H4(24),m3h16x4(:,42),heltab2x64(:,:,809))
  call Hloop_A_Q(ntryL,G0H4(24),39,nMT,G1H4(821),n2h4(1504))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[39,8,16],[0,0,0],3,1,wf16(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,40),G0H4(73),m3h16x4(:,43),heltab2x64(:,:,810))
  call Hloop_Q_A(ntryL,G0H4(73),39,0,G1H4(768),n2h4(1505))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,40),G0H4(74),m3h16x4(:,44),heltab2x64(:,:,811))
  call Hloop_Q_A(ntryL,G0H4(74),39,nMT,G1H4(434),n2h4(1506))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[39,8,16],[0,0,0],3,1,wf16(:,40))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,40),G0H4(75),m3h16x4(:,45),heltab2x64(:,:,812))
  call Hloop_A_Q(ntryL,G0H4(75),39,0,G1H4(609),n2h4(1507))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,40))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,40),G0H4(76),m3h16x4(:,46),heltab2x64(:,:,813))
  call Hloop_A_Q(ntryL,G0H4(76),39,nMB,G1H4(285),n2h4(1508))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[39,8,16],[0,0,0],3,1,wf16(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,40),G0H4(77),m3h16x4(:,47),heltab2x64(:,:,814))
  call Hloop_Q_A(ntryL,G0H4(77),39,0,G1H4(108),n2h4(1509))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,40),G0H4(78),m3h16x4(:,48),heltab2x64(:,:,815))
  call Hloop_Q_A(ntryL,G0H4(78),39,nMB,G1H4(599),n2h4(1510))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,534),heltab2x64(:,:,816))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(52),n2h32(455))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,535),heltab2x64(:,:,817))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(54),n2h32(456))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,536),heltab2x64(:,:,818))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(56),n2h32(457))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,537),heltab2x64(:,:,819))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(61),n2h32(458))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,538),heltab2x64(:,:,820))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(58),n2h32(459))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,539),heltab2x64(:,:,821))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(63),n2h32(460))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,540),heltab2x64(:,:,822))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(60),n2h32(461))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,541),heltab2x64(:,:,823))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(62),n2h32(462))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(64),m3h2x32(:,542),heltab2x64(:,:,824))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(69),m3h2x32(:,543),heltab2x64(:,:,825))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[32,15,16],[0,0,0],3,1,wf16(:,41))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,544),heltab2x64(:,:,826))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[32,8,23],[0,0,0],3,1,wf16(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,545),heltab2x64(:,:,827))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(71),n2h32(463))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,546),heltab2x64(:,:,828))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(74),n2h32(464))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[32,8,23],[0,0,0],3,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,547),heltab2x64(:,:,829))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(70),n2h32(465))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,548),heltab2x64(:,:,830))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(76),n2h32(466))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[32,8,23],[0,0,0],3,1,wf16(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,549),heltab2x64(:,:,831))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(77),n2h32(467))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,550),heltab2x64(:,:,832))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(79),n2h32(468))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[32,8,23],[0,0,0],3,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,551),heltab2x64(:,:,833))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(78),n2h32(469))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,552),heltab2x64(:,:,834))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(84),n2h32(470))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[39,8,16],[0,0,0],3,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,43),G0H4(79),m3h16x4(:,49),heltab2x64(:,:,835))
  call Hloop_A_Q(ntryL,G0H4(79),39,0,G1H4(395),n2h4(1511))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,43),G0H4(80),m3h16x4(:,50),heltab2x64(:,:,836))
  call Hloop_A_Q(ntryL,G0H4(80),39,nMT,G1H4(168),n2h4(1512))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[39,8,16],[0,0,0],3,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,43),G0H4(25),m3h16x4(:,51),heltab2x64(:,:,837))
  call Hloop_Q_A(ntryL,G0H4(25),39,0,G1H4(647),n2h4(1513))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,43),G0H4(26),m3h16x4(:,52),heltab2x64(:,:,838))
  call Hloop_Q_A(ntryL,G0H4(26),39,nMT,G1H4(508),n2h4(1514))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[39,8,16],[0,0,0],3,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,43),G0H4(27),m3h16x4(:,53),heltab2x64(:,:,839))
  call Hloop_A_Q(ntryL,G0H4(27),39,0,G1H4(324),n2h4(1515))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,43),G0H4(28),m3h16x4(:,54),heltab2x64(:,:,840))
  call Hloop_A_Q(ntryL,G0H4(28),39,nMB,G1H4(637),n2h4(1516))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[39,8,16],[0,0,0],3,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,43),G0H4(29),m3h16x4(:,55),heltab2x64(:,:,841))
  call Hloop_Q_A(ntryL,G0H4(29),39,0,G1H4(528),n2h4(1517))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,43),G0H4(30),m3h16x4(:,56),heltab2x64(:,:,842))
  call Hloop_Q_A(ntryL,G0H4(30),39,nMB,G1H4(384),n2h4(1518))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[32,1,30],[0,0,0],3,1,wf16(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,553),heltab2x64(:,:,843))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(85),n2h32(471))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[32,1,30],[0,0,0],3,1,wf16(:,45))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,554),heltab2x64(:,:,844))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[46,1,16],[0,0,0],3,1,wf16(:,47))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,47),G0H4(81),m3h16x4(:,57),heltab2x64(:,:,845))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[46,1,16],[0,0,0],3,1,wf16(:,47))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,47),G0H4(82),m3h16x4(:,58),heltab2x64(:,:,846))
  call Hloop_A_Q(ntryL,G0H4(82),46,0,G1H4(676),n2h4(1519))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[32,1,30],[0,0,0],3,1,wf16(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,555),heltab2x64(:,:,847))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(472))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[32,1,30],[0,0,0],3,1,wf16(:,49))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,556),heltab2x64(:,:,848))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[54,1,8],[0,0,0],3,1,wf16(:,51))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,51),G0H4(83),m3h16x4(:,59),heltab2x64(:,:,849))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[46,1,16],[0,0,0],3,1,wf16(:,53))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,53),G0H4(84),m3h16x4(:,60),heltab2x64(:,:,850))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[46,1,16],[0,0,0],3,1,wf16(:,53))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,53),G0H4(85),m3h16x4(:,61),heltab2x64(:,:,851))
  call Hloop_A_Q(ntryL,G0H4(85),46,0,G1H4(532),n2h4(1520))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[54,1,8],[0,0,0],3,1,wf16(:,55))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,55),G0H4(86),m3h16x4(:,62),heltab2x64(:,:,852))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[32,13,18],[0,0,0],3,2,wf8(:,34),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,557),heltab2x64(:,:,853))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(93),n2h32(473))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[32,13,18],[0,0,0],3,2,wf8(:,34),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,558),heltab2x64(:,:,854))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[41,4,18],[0,0,0],3,2,wf8(:,79),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,79),G0H8(26),m3h8x8(:,129),heltab2x64(:,:,855))
  call Hloop_Q_A(ntryL,G0H8(26),41,0,G1H8(178),n2h8(997))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[32,9,22],[0,0,0],3,2,wf4(:,12),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,559),heltab2x64(:,:,856))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(95),n2h32(474))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[32,9,22],[0,0,0],3,2,wf4(:,12),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,560),heltab2x64(:,:,857))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[50,4,9],[0,0,0],3,2,wf8(:,73),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,73),G0H8(27),m3h8x8(:,130),heltab2x64(:,:,858))
  call Hloop_A_Q(ntryL,G0H8(27),50,0,G1H8(196),n2h8(998))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[32,4,27],[0,0,0],3,1,wf16(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,561),heltab2x64(:,:,859))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(94),n2h32(475))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,562),heltab2x64(:,:,860))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(97),n2h32(476))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[32,4,27],[0,0,0],3,1,wf16(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,563),heltab2x64(:,:,861))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(99),n2h32(477))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,564),heltab2x64(:,:,862))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(100),n2h32(478))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[32,4,27],[0,0,0],3,1,wf16(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,565),heltab2x64(:,:,863))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(101),n2h32(479))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,566),heltab2x64(:,:,864))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(102),n2h32(480))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[32,4,27],[0,0,0],3,1,wf16(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,567),heltab2x64(:,:,865))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(481))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,568),heltab2x64(:,:,866))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(104),n2h32(482))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[34,13,16],[0,0,0],3,2,wf4(:,9),wf8(:,34))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,9),G0H16(45),m3h4x16(:,107),heltab2x64(:,:,867))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[34,13,16],[0,0,0],3,2,wf4(:,9),wf8(:,34))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(46),m3h4x16(:,108),heltab2x64(:,:,868))
  call Hloop_A_Q(ntryL,G0H16(46),34,0,G1H16(268),n2h16(469))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[34,4,25],[0,0,0],3,2,wf4(:,9),wf8(:,19))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(47),m3h4x16(:,109),heltab2x64(:,:,869))
  call Hloop_A_Q(ntryL,G0H16(47),34,0,G1H16(269),n2h16(470))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[38,9,16],[0,0,0],3,2,wf8(:,38),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,38),G0H8(29),m3h8x8(:,131),heltab2x64(:,:,870))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[38,9,16],[0,0,0],3,2,wf8(:,38),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(30),m3h8x8(:,132),heltab2x64(:,:,871))
  call Hloop_A_Q(ntryL,G0H8(30),38,0,G1H8(237),n2h8(999))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[50,4,9],[0,0,0],3,2,wf8(:,75),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,75),G0H8(32),m3h8x8(:,133),heltab2x64(:,:,872))
  call Hloop_A_Q(ntryL,G0H8(32),50,0,G1H8(286),n2h8(1000))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[43,4,16],[0,0,0],3,1,wf16(:,57))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,57),G0H4(87),m3h16x4(:,63),heltab2x64(:,:,873))
  call Hloop_A_Q(ntryL,G0H4(87),43,0,G1H4(424),n2h4(1521))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,57))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,57),G0H4(88),m3h16x4(:,64),heltab2x64(:,:,874))
  call Hloop_A_Q(ntryL,G0H4(88),43,nMT,G1H4(666),n2h4(1522))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[43,4,16],[0,0,0],3,1,wf16(:,57))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,57),G0H4(31),m3h16x4(:,65),heltab2x64(:,:,875))
  call Hloop_Q_A(ntryL,G0H4(31),43,0,G1H4(536),n2h4(1523))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,57))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,57),G0H4(32),m3h16x4(:,66),heltab2x64(:,:,876))
  call Hloop_Q_A(ntryL,G0H4(32),43,nMT,G1H4(469),n2h4(1524))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[43,4,16],[0,0,0],3,1,wf16(:,57))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,57),G0H4(33),m3h16x4(:,67),heltab2x64(:,:,877))
  call Hloop_A_Q(ntryL,G0H4(33),43,0,G1H4(1062),n2h4(1525))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,57))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,57),G0H4(34),m3h16x4(:,68),heltab2x64(:,:,878))
  call Hloop_A_Q(ntryL,G0H4(34),43,nMB,G1H4(1078),n2h4(1526))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[43,4,16],[0,0,0],3,1,wf16(:,57))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,57),G0H4(35),m3h16x4(:,69),heltab2x64(:,:,879))
  call Hloop_Q_A(ntryL,G0H4(35),43,0,G1H4(1094),n2h4(1527))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,57))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,57),G0H4(36),m3h16x4(:,70),heltab2x64(:,:,880))
  call Hloop_Q_A(ntryL,G0H4(36),43,nMB,G1H4(1110),n2h4(1528))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(48),m3h4x16(:,110),heltab2x64(:,:,881))
  call Hloop_A_Q(ntryL,G0H16(48),48,0,G1H16(270),n2h16(471))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(49),m3h4x16(:,111),heltab2x64(:,:,882))
  call Hloop_A_Q(ntryL,G0H16(49),48,nMT,G1H16(273),n2h16(472))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(50),m3h4x16(:,112),heltab2x64(:,:,883))
  call Hloop_Q_A(ntryL,G0H16(50),48,0,G1H16(274),n2h16(473))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,54))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(51),m3h4x16(:,113),heltab2x64(:,:,884))
  call Hloop_Q_A(ntryL,G0H16(51),48,nMT,G1H16(275),n2h16(474))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(52),m3h4x16(:,114),heltab2x64(:,:,885))
  call Hloop_A_Q(ntryL,G0H16(52),48,0,G1H16(276),n2h16(475))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(53),m3h4x16(:,115),heltab2x64(:,:,886))
  call Hloop_A_Q(ntryL,G0H16(53),48,nMB,G1H16(279),n2h16(476))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(54),m3h4x16(:,116),heltab2x64(:,:,887))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(280),n2h16(477))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,54))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(55),m3h4x16(:,117),heltab2x64(:,:,888))
  call Hloop_Q_A(ntryL,G0H16(55),48,nMB,G1H16(86),n2h16(478))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[48,2,13],[0,0,0],3,2,wf4(:,3),wf8(:,34))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(56),m3h4x16(:,118),heltab2x64(:,:,889))
  call Hloop_Q_A(ntryL,G0H16(56),48,0,G1H16(281),n2h16(479))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[48,2,13],[0,0,0],3,2,wf4(:,3),wf8(:,34))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(284),m3h4x16(:,119),heltab2x64(:,:,890))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[50,4,9],[0,0,0],3,2,wf8(:,16),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,16),G0H8(33),m3h8x8(:,134),heltab2x64(:,:,891))
  call Hloop_A_Q(ntryL,G0H8(33),50,0,G1H8(322),n2h8(1001))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[57,2,4],[0,0,0],3,1,wf16(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,17),G0H4(89),m3h16x4(:,71),heltab2x64(:,:,892))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[32,4,27],[0,0,0],3,1,wf16(:,58))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,569),heltab2x64(:,:,893))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(105),n2h32(483))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,58))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,570),heltab2x64(:,:,894))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(106),n2h32(484))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[32,4,27],[0,0,0],3,1,wf16(:,58))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,571),heltab2x64(:,:,895))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(107),n2h32(485))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,58))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,572),heltab2x64(:,:,896))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(108),n2h32(486))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[32,4,27],[0,0,0],3,1,wf16(:,58))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,573),heltab2x64(:,:,897))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(109),n2h32(487))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,58))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,574),heltab2x64(:,:,898))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(110),n2h32(488))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[32,4,27],[0,0,0],3,1,wf16(:,58))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,575),heltab2x64(:,:,899))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(489))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,58))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,576),heltab2x64(:,:,900))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(116),n2h32(490))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[43,4,16],[0,0,0],3,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,59),G0H4(90),m3h16x4(:,72),heltab2x64(:,:,901))
  call Hloop_A_Q(ntryL,G0H4(90),43,0,G1H4(1472),n2h4(1529))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,59),G0H4(91),m3h16x4(:,73),heltab2x64(:,:,902))
  call Hloop_A_Q(ntryL,G0H4(91),43,nMT,G1H4(1126),n2h4(1530))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[43,4,16],[0,0,0],3,1,wf16(:,59))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,59),G0H4(92),m3h16x4(:,74),heltab2x64(:,:,903))
  call Hloop_Q_A(ntryL,G0H4(92),43,0,G1H4(1451),n2h4(1531))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,59))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,59),G0H4(93),m3h16x4(:,75),heltab2x64(:,:,904))
  call Hloop_Q_A(ntryL,G0H4(93),43,nMT,G1H4(1142),n2h4(1532))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[43,4,16],[0,0,0],3,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,59),G0H4(94),m3h16x4(:,76),heltab2x64(:,:,905))
  call Hloop_A_Q(ntryL,G0H4(94),43,0,G1H4(1504),n2h4(1533))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,59),G0H4(95),m3h16x4(:,77),heltab2x64(:,:,906))
  call Hloop_A_Q(ntryL,G0H4(95),43,nMB,G1H4(1158),n2h4(1534))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[43,4,16],[0,0,0],3,1,wf16(:,59))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,59),G0H4(96),m3h16x4(:,78),heltab2x64(:,:,907))
  call Hloop_Q_A(ntryL,G0H4(96),43,0,G1H4(1488),n2h4(1535))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,59))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,59),G0H4(97),m3h16x4(:,79),heltab2x64(:,:,908))
  call Hloop_Q_A(ntryL,G0H4(97),43,nMB,G1H4(1174),n2h4(1536))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,577),heltab2x64(:,:,909))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(113),n2h32(491))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,578),heltab2x64(:,:,910))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(118),n2h32(492))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,579),heltab2x64(:,:,911))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(115),n2h32(493))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,60))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,580),heltab2x64(:,:,912))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(117),n2h32(494))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,581),heltab2x64(:,:,913))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(119),n2h32(495))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,582),heltab2x64(:,:,914))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(124),n2h32(496))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,583),heltab2x64(:,:,915))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(121),n2h32(497))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,60))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,584),heltab2x64(:,:,916))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(126),n2h32(498))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(123),m3h2x32(:,585),heltab2x64(:,:,917))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(125),m3h2x32(:,586),heltab2x64(:,:,918))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[32,15,16],[0,0,0],3,1,wf16(:,60))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(127),m3h2x32(:,587),heltab2x64(:,:,919))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[32,2,29],[0,0,0],3,1,wf16(:,62))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,588),heltab2x64(:,:,920))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(132),n2h32(499))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[32,2,29],[0,0,0],3,1,wf16(:,62))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(129),m3h2x32(:,589),heltab2x64(:,:,921))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[45,2,16],[0,0,0],3,1,wf16(:,64))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,64),G0H4(98),m3h16x4(:,80),heltab2x64(:,:,922))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[45,2,16],[0,0,0],3,1,wf16(:,64))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,64),G0H4(99),m3h16x4(:,81),heltab2x64(:,:,923))
  call Hloop_Q_A(ntryL,G0H4(99),45,0,G1H4(1524),n2h4(1537))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[32,4,27],[0,0,0],3,1,wf16(:,65))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,590),heltab2x64(:,:,924))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(134),n2h32(500))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,65))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,591),heltab2x64(:,:,925))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(131),n2h32(501))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[32,4,27],[0,0,0],3,1,wf16(:,65))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,592),heltab2x64(:,:,926))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(133),n2h32(502))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,65))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,593),heltab2x64(:,:,927))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(135),n2h32(503))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(964),h0tab(:,964),[32,4,27],[0,0,0],3,1,wf16(:,65))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,594),heltab2x64(:,:,928))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(136),n2h32(504))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(965),h0tab(:,965),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,65))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,595),heltab2x64(:,:,929))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(137),n2h32(505))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(966),h0tab(:,966),[32,4,27],[0,0,0],3,1,wf16(:,65))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,596),heltab2x64(:,:,930))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(138),n2h32(506))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(967),h0tab(:,967),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,65))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,597),heltab2x64(:,:,931))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(139),n2h32(507))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(968),h0tab(:,968),[32,2,29],[0,0,0],3,1,wf16(:,67))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,598),heltab2x64(:,:,932))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(140),n2h32(508))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(969),h0tab(:,969),[32,2,29],[0,0,0],3,1,wf16(:,67))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(141),m3h2x32(:,599),heltab2x64(:,:,933))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(296)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(970),h0tab(:,970),[57,2,4],[0,0,0],3,1,wf16(:,69))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,69),G0H4(100),m3h16x4(:,82),heltab2x64(:,:,934))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(971),h0tab(:,971),[43,4,16],[0,0,0],3,1,wf16(:,70))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,70),G0H4(101),m3h16x4(:,83),heltab2x64(:,:,935))
  call Hloop_A_Q(ntryL,G0H4(101),43,0,G1H4(1190),n2h4(1538))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(972),h0tab(:,972),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,70))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,70),G0H4(102),m3h16x4(:,84),heltab2x64(:,:,936))
  call Hloop_A_Q(ntryL,G0H4(102),43,nMT,G1H4(1545),n2h4(1539))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(973),h0tab(:,973),[43,4,16],[0,0,0],3,1,wf16(:,70))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,70),G0H4(103),m3h16x4(:,85),heltab2x64(:,:,937))
  call Hloop_Q_A(ntryL,G0H4(103),43,0,G1H4(1206),n2h4(1540))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(974),h0tab(:,974),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,70))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,70),G0H4(104),m3h16x4(:,86),heltab2x64(:,:,938))
  call Hloop_Q_A(ntryL,G0H4(104),43,nMT,G1H4(1561),n2h4(1541))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(975),h0tab(:,975),[43,4,16],[0,0,0],3,1,wf16(:,70))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,70),G0H4(105),m3h16x4(:,87),heltab2x64(:,:,939))
  call Hloop_A_Q(ntryL,G0H4(105),43,0,G1H4(1222),n2h4(1542))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(976),h0tab(:,976),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,70))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,70),G0H4(106),m3h16x4(:,88),heltab2x64(:,:,940))
  call Hloop_A_Q(ntryL,G0H4(106),43,nMB,G1H4(1577),n2h4(1543))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[43,4,16],[0,0,0],3,1,wf16(:,70))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,70),G0H4(107),m3h16x4(:,89),heltab2x64(:,:,941))
  call Hloop_Q_A(ntryL,G0H4(107),43,0,G1H4(1238),n2h4(1544))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,70))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,70),G0H4(108),m3h16x4(:,90),heltab2x64(:,:,942))
  call Hloop_Q_A(ntryL,G0H4(108),43,nMB,G1H4(1620),n2h4(1545))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[45,2,16],[0,0,0],3,1,wf16(:,72))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,72),G0H4(1),m3h16x4(:,91),heltab2x64(:,:,943))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[45,2,16],[0,0,0],3,1,wf16(:,72))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,72),G0H4(2),m3h16x4(:,92),heltab2x64(:,:,944))
  call Hloop_Q_A(ntryL,G0H4(2),45,0,G1H4(1254),n2h4(1546))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[57,2,4],[0,0,0],3,1,wf16(:,74))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,74),G0H4(3),m3h16x4(:,93),heltab2x64(:,:,945))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[32,10,21],[0,0,0],3,2,wf4(:,5),wf8(:,40))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,600),heltab2x64(:,:,946))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(142),n2h32(509))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[32,10,21],[0,0,0],3,2,wf4(:,5),wf8(:,40))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(143),m3h2x32(:,601),heltab2x64(:,:,947))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[49,4,10],[0,0,0],3,2,wf8(:,87),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,87),G0H8(35),m3h8x8(:,135),heltab2x64(:,:,948))
  call Hloop_Q_A(ntryL,G0H8(35),49,0,G1H8(103),n2h8(1002))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[32,14,17],[0,0,0],3,2,wf8(:,42),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,602),heltab2x64(:,:,949))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(144),n2h32(510))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[32,14,17],[0,0,0],3,2,wf8(:,42),wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(145),m3h2x32(:,603),heltab2x64(:,:,950))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[42,4,17],[0,0,0],3,2,wf8(:,66),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,66),G0H8(36),m3h8x8(:,136),heltab2x64(:,:,951))
  call Hloop_A_Q(ntryL,G0H8(36),42,0,G1H8(122),n2h8(1003))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[32,4,27],[0,0,0],3,1,wf16(:,75))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,604),heltab2x64(:,:,952))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(146),n2h32(511))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,75))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,605),heltab2x64(:,:,953))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(147),n2h32(512))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[32,4,27],[0,0,0],3,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,606),heltab2x64(:,:,954))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(152),n2h32(513))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,607),heltab2x64(:,:,955))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(149),n2h32(514))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[32,4,27],[0,0,0],3,1,wf16(:,75))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,608),heltab2x64(:,:,956))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(154),n2h32(515))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,75))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,609),heltab2x64(:,:,957))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(151),n2h32(516))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[32,4,27],[0,0,0],3,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,610),heltab2x64(:,:,958))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(153),n2h32(517))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,611),heltab2x64(:,:,959))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(155),n2h32(518))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[37,10,16],[0,0,0],3,2,wf8(:,44),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,44),G0H8(11),m3h8x8(:,137),heltab2x64(:,:,960))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[37,10,16],[0,0,0],3,2,wf8(:,44),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,44),G0H8(1),m3h8x8(:,138),heltab2x64(:,:,961))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(132),n2h8(1004))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[49,4,10],[0,0,0],3,2,wf8(:,89),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,89),G0H8(12),m3h8x8(:,139),heltab2x64(:,:,962))
  call Hloop_Q_A(ntryL,G0H8(12),49,0,G1H8(327),n2h8(1005))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[33,14,16],[0,0,0],3,2,wf4(:,17),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,17),G0H16(57),m3h4x16(:,120),heltab2x64(:,:,963))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[33,14,16],[0,0,0],3,2,wf4(:,17),wf8(:,42))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(58),m3h4x16(:,121),heltab2x64(:,:,964))
  call Hloop_Q_A(ntryL,G0H16(58),33,0,G1H16(285),n2h16(480))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[33,4,26],[0,0,0],3,2,wf4(:,17),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(59),m3h4x16(:,122),heltab2x64(:,:,965))
  call Hloop_Q_A(ntryL,G0H16(59),33,0,G1H16(89),n2h16(481))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[43,4,16],[0,0,0],3,1,wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,76),G0H4(4),m3h16x4(:,94),heltab2x64(:,:,966))
  call Hloop_A_Q(ntryL,G0H4(4),43,0,G1H4(1599),n2h4(1547))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,76),G0H4(5),m3h16x4(:,95),heltab2x64(:,:,967))
  call Hloop_A_Q(ntryL,G0H4(5),43,nMT,G1H4(1270),n2h4(1548))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[43,4,16],[0,0,0],3,1,wf16(:,76))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,76),G0H4(6),m3h16x4(:,96),heltab2x64(:,:,968))
  call Hloop_Q_A(ntryL,G0H4(6),43,0,G1H4(1652),n2h4(1549))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,76))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,76),G0H4(7),m3h16x4(:,97),heltab2x64(:,:,969))
  call Hloop_Q_A(ntryL,G0H4(7),43,nMT,G1H4(1286),n2h4(1550))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[43,4,16],[0,0,0],3,1,wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,76),G0H4(8),m3h16x4(:,98),heltab2x64(:,:,970))
  call Hloop_A_Q(ntryL,G0H4(8),43,0,G1H4(1636),n2h4(1551))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,76),G0H4(9),m3h16x4(:,99),heltab2x64(:,:,971))
  call Hloop_A_Q(ntryL,G0H4(9),43,nMB,G1H4(1302),n2h4(1552))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[43,4,16],[0,0,0],3,1,wf16(:,76))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,76),G0H4(10),m3h16x4(:,100),heltab2x64(:,:,972))
  call Hloop_Q_A(ntryL,G0H4(10),43,0,G1H4(1598),n2h4(1553))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,76))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,76),G0H4(11),m3h16x4(:,101),heltab2x64(:,:,973))
  call Hloop_Q_A(ntryL,G0H4(11),43,nMB,G1H4(1318),n2h4(1554))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(60),m3h4x16(:,123),heltab2x64(:,:,974))
  call Hloop_A_Q(ntryL,G0H16(60),48,0,G1H16(90),n2h16(482))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(61),m3h4x16(:,124),heltab2x64(:,:,975))
  call Hloop_A_Q(ntryL,G0H16(61),48,nMT,G1H16(288),n2h16(483))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(62),m3h4x16(:,125),heltab2x64(:,:,976))
  call Hloop_Q_A(ntryL,G0H16(62),48,0,G1H16(289),n2h16(484))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,3),wf8(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(63),m3h4x16(:,126),heltab2x64(:,:,977))
  call Hloop_Q_A(ntryL,G0H16(63),48,nMT,G1H16(290),n2h16(485))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(64),m3h4x16(:,127),heltab2x64(:,:,978))
  call Hloop_A_Q(ntryL,G0H16(64),48,0,G1H16(291),n2h16(486))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(65),m3h4x16(:,128),heltab2x64(:,:,979))
  call Hloop_A_Q(ntryL,G0H16(65),48,nMB,G1H16(294),n2h16(487))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[48,4,11],[0,0,0],3,2,wf4(:,3),wf8(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(66),m3h4x16(:,129),heltab2x64(:,:,980))
  call Hloop_Q_A(ntryL,G0H16(66),48,0,G1H16(295),n2h16(488))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,3),wf8(:,56))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(67),m3h4x16(:,130),heltab2x64(:,:,981))
  call Hloop_Q_A(ntryL,G0H16(67),48,nMB,G1H16(296),n2h16(489))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[49,4,10],[0,0,0],3,2,wf8(:,32),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,32),G0H8(2),m3h8x8(:,140),heltab2x64(:,:,982))
  call Hloop_Q_A(ntryL,G0H8(2),49,0,G1H8(344),n2h8(1006))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(68),m3h4x16(:,131),heltab2x64(:,:,983))
  call Hloop_A_Q(ntryL,G0H16(68),48,0,G1H16(297),n2h16(490))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,42))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(300),m3h4x16(:,132),heltab2x64(:,:,984))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[58,1,4],[0,0,0],3,1,wf16(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,11),G0H4(12),m3h16x4(:,102),heltab2x64(:,:,985))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[32,4,27],[0,0,0],3,1,wf16(:,77))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,612),heltab2x64(:,:,986))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(160),n2h32(519))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,77))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,613),heltab2x64(:,:,987))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(157),n2h32(520))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[32,4,27],[0,0,0],3,1,wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,614),heltab2x64(:,:,988))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(162),n2h32(521))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,615),heltab2x64(:,:,989))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(159),n2h32(522))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[32,4,27],[0,0,0],3,1,wf16(:,77))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,616),heltab2x64(:,:,990))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(161),n2h32(523))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,77))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,617),heltab2x64(:,:,991))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(163),n2h32(524))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[32,4,27],[0,0,0],3,1,wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,618),heltab2x64(:,:,992))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(168),n2h32(525))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,619),heltab2x64(:,:,993))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(165),n2h32(526))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[43,4,16],[0,0,0],3,1,wf16(:,78))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,78),G0H4(13),m3h16x4(:,103),heltab2x64(:,:,994))
  call Hloop_A_Q(ntryL,G0H4(13),43,0,G1H4(1619),n2h4(1555))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,78))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,78),G0H4(14),m3h16x4(:,104),heltab2x64(:,:,995))
  call Hloop_A_Q(ntryL,G0H4(14),43,nMT,G1H4(1334),n2h4(1556))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[43,4,16],[0,0,0],3,1,wf16(:,78))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,78),G0H4(15),m3h16x4(:,105),heltab2x64(:,:,996))
  call Hloop_Q_A(ntryL,G0H4(15),43,0,G1H4(1635),n2h4(1557))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,78))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,78),G0H4(16),m3h16x4(:,106),heltab2x64(:,:,997))
  call Hloop_Q_A(ntryL,G0H4(16),43,nMT,G1H4(1350),n2h4(1558))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[43,4,16],[0,0,0],3,1,wf16(:,78))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,78),G0H4(17),m3h16x4(:,107),heltab2x64(:,:,998))
  call Hloop_A_Q(ntryL,G0H4(17),43,0,G1H4(1651),n2h4(1559))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,78))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,78),G0H4(18),m3h16x4(:,108),heltab2x64(:,:,999))
  call Hloop_A_Q(ntryL,G0H4(18),43,nMB,G1H4(1366),n2h4(1560))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[43,4,16],[0,0,0],3,1,wf16(:,78))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,78),G0H4(37),m3h16x4(:,109),heltab2x64(:,:,1000))
  call Hloop_Q_A(ntryL,G0H4(37),43,0,G1H4(1450),n2h4(1561))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,78))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,78),G0H4(38),m3h16x4(:,110),heltab2x64(:,:,1001))
  call Hloop_Q_A(ntryL,G0H4(38),43,nMB,G1H4(1546),n2h4(1562))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,620),heltab2x64(:,:,1002))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(170),n2h32(527))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,621),heltab2x64(:,:,1003))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(167),n2h32(528))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,622),heltab2x64(:,:,1004))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(169),n2h32(529))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,79))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,623),heltab2x64(:,:,1005))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(171),n2h32(530))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,624),heltab2x64(:,:,1006))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(172),n2h32(531))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,625),heltab2x64(:,:,1007))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(173),n2h32(532))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(18)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,626),heltab2x64(:,:,1008))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(174),n2h32(533))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(16)*M(3,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,79))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,627),heltab2x64(:,:,1009))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(175),n2h32(534))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(176),m3h2x32(:,628),heltab2x64(:,:,1010))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(177),m3h2x32(:,629),heltab2x64(:,:,1011))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[32,15,16],[0,0,0],3,1,wf16(:,79))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(178),m3h2x32(:,630),heltab2x64(:,:,1012))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[32,4,27],[0,0,0],3,1,wf16(:,80))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,631),heltab2x64(:,:,1013))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(179),n2h32(535))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,80))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,632),heltab2x64(:,:,1014))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(180),n2h32(536))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[32,4,27],[0,0,0],3,1,wf16(:,80))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,633),heltab2x64(:,:,1015))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(185),n2h32(537))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,80))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,634),heltab2x64(:,:,1016))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(182),n2h32(538))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[32,4,27],[0,0,0],3,1,wf16(:,80))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,635),heltab2x64(:,:,1017))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(187),n2h32(539))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,80))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,636),heltab2x64(:,:,1018))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(184),n2h32(540))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[32,4,27],[0,0,0],3,1,wf16(:,80))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,637),heltab2x64(:,:,1019))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(186),n2h32(541))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,80))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,638),heltab2x64(:,:,1020))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(188),n2h32(542))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1057),h0tab(:,1057),[43,4,16],[0,0,0],3,1,wf16(:,81))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,81),G0H4(39),m3h16x4(:,111),heltab2x64(:,:,1021))
  call Hloop_A_Q(ntryL,G0H4(39),43,0,G1H4(1382),n2h4(1563))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1058),h0tab(:,1058),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,81))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,81),G0H4(40),m3h16x4(:,112),heltab2x64(:,:,1022))
  call Hloop_A_Q(ntryL,G0H4(40),43,nMT,G1H4(1471),n2h4(1564))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1059),h0tab(:,1059),[43,4,16],[0,0,0],3,1,wf16(:,81))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(41),m3h16x4(:,113),heltab2x64(:,:,1023))
  call Hloop_Q_A(ntryL,G0H4(41),43,0,G1H4(1525),n2h4(1565))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1060),h0tab(:,1060),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,81))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(42),m3h16x4(:,114),heltab2x64(:,:,1024))
  call Hloop_Q_A(ntryL,G0H4(42),43,nMT,G1H4(1398),n2h4(1566))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1061),h0tab(:,1061),[43,4,16],[0,0,0],3,1,wf16(:,81))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,81),G0H4(43),m3h16x4(:,115),heltab2x64(:,:,1025))
  call Hloop_A_Q(ntryL,G0H4(43),43,0,G1H4(1487),n2h4(1567))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1062),h0tab(:,1062),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,81))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,81),G0H4(44),m3h16x4(:,116),heltab2x64(:,:,1026))
  call Hloop_A_Q(ntryL,G0H4(44),43,nMB,G1H4(1578),n2h4(1568))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1063),h0tab(:,1063),[43,4,16],[0,0,0],3,1,wf16(:,81))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(46),m3h16x4(:,117),heltab2x64(:,:,1027))
  call Hloop_Q_A(ntryL,G0H4(46),43,0,G1H4(1414),n2h4(1569))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1064),h0tab(:,1064),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,81))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,81),G0H4(47),m3h16x4(:,118),heltab2x64(:,:,1028))
  call Hloop_Q_A(ntryL,G0H4(47),43,nMB,G1H4(1503),n2h4(1570))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1065),h0tab(:,1065),[32,1,30],[0,0,0],3,1,wf16(:,83))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,639),heltab2x64(:,:,1029))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(193),n2h32(543))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1066),h0tab(:,1066),[32,1,30],[0,0,0],3,1,wf16(:,83))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(190),m3h2x32(:,640),heltab2x64(:,:,1030))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1067),h0tab(:,1067),[46,1,16],[0,0,0],3,1,wf16(:,85))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,85),G0H4(48),m3h16x4(:,119),heltab2x64(:,:,1031))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1068),h0tab(:,1068),[46,1,16],[0,0,0],3,1,wf16(:,85))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,85),G0H4(49),m3h16x4(:,120),heltab2x64(:,:,1032))
  call Hloop_A_Q(ntryL,G0H4(49),46,0,G1H4(1562),n2h4(1571))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1069),h0tab(:,1069),[32,1,30],[0,0,0],3,1,wf16(:,87))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,641),heltab2x64(:,:,1033))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(195),n2h32(544))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1070),h0tab(:,1070),[32,1,30],[0,0,0],3,1,wf16(:,87))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(192),m3h2x32(:,642),heltab2x64(:,:,1034))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1071),h0tab(:,1071),[58,1,4],[0,0,0],3,1,wf16(:,89))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,89),G0H4(50),m3h16x4(:,121),heltab2x64(:,:,1035))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1072),h0tab(:,1072),[46,1,16],[0,0,0],3,1,wf16(:,91))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,91),G0H4(51),m3h16x4(:,122),heltab2x64(:,:,1036))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1073),h0tab(:,1073),[46,1,16],[0,0,0],3,1,wf16(:,91))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,91),G0H4(52),m3h16x4(:,123),heltab2x64(:,:,1037))
  call Hloop_A_Q(ntryL,G0H4(52),46,0,G1H4(1430),n2h4(1572))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1074),h0tab(:,1074),[58,1,4],[0,0,0],3,1,wf16(:,93))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,93),G0H4(53),m3h16x4(:,124),heltab2x64(:,:,1038))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1075),h0tab(:,1075),[34,8,21],[0,0,0],3,2,wf4(:,9),wf8(:,40))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(69),m3h4x16(:,133),heltab2x64(:,:,1039))
  call Hloop_A_Q(ntryL,G0H16(69),34,0,G1H16(301),n2h16(491))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1076),h0tab(:,1076),[34,4,25],[0,0,0],3,2,wf4(:,9),wf8(:,24))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(70),m3h4x16(:,134),heltab2x64(:,:,1040))
  call Hloop_A_Q(ntryL,G0H16(70),34,0,G1H16(96),n2h16(492))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1077),h0tab(:,1077),[38,8,17],[0,0,0],3,2,wf8(:,38),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(25),m3h8x8(:,141),heltab2x64(:,:,1041))
  call Hloop_A_Q(ntryL,G0H8(25),38,0,G1H8(348),n2h8(1007))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1078),h0tab(:,1078),[42,4,17],[0,0,0],3,2,wf8(:,14),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,14),G0H8(3),m3h8x8(:,142),heltab2x64(:,:,1042))
  call Hloop_A_Q(ntryL,G0H8(3),42,0,G1H8(145),n2h8(1008))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1079),h0tab(:,1079),[32,8,23],[0,0,0],3,1,wf16(:,94))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,643),heltab2x64(:,:,1043))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(194),n2h32(545))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1080),h0tab(:,1080),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,94))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,644),heltab2x64(:,:,1044))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(196),n2h32(546))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1081),h0tab(:,1081),[32,8,23],[0,0,0],3,1,wf16(:,94))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,645),heltab2x64(:,:,1045))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(201),n2h32(547))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1082),h0tab(:,1082),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,94))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,646),heltab2x64(:,:,1046))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(198),n2h32(548))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1083),h0tab(:,1083),[32,8,23],[0,0,0],3,1,wf16(:,94))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,647),heltab2x64(:,:,1047))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(203),n2h32(549))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1084),h0tab(:,1084),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,94))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,648),heltab2x64(:,:,1048))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(200),n2h32(550))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1085),h0tab(:,1085),[32,8,23],[0,0,0],3,1,wf16(:,94))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,649),heltab2x64(:,:,1049))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(202),n2h32(551))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1086),h0tab(:,1086),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,94))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,650),heltab2x64(:,:,1050))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(204),n2h32(552))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1087),h0tab(:,1087),[32,2,29],[0,0,0],3,1,wf16(:,96))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,651),heltab2x64(:,:,1051))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(205),n2h32(553))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1088),h0tab(:,1088),[32,2,29],[0,0,0],3,1,wf16(:,96))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(206),m3h2x32(:,652),heltab2x64(:,:,1052))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1089),h0tab(:,1089),[53,2,8],[0,0,0],3,1,wf16(:,98))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,98),G0H4(55),m3h16x4(:,125),heltab2x64(:,:,1053))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1090),h0tab(:,1090),[32,4,27],[0,0,0],3,1,wf16(:,99))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,653),heltab2x64(:,:,1054))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(207),n2h32(554))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1091),h0tab(:,1091),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,99))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,654),heltab2x64(:,:,1055))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(208),n2h32(555))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1092),h0tab(:,1092),[32,4,27],[0,0,0],3,1,wf16(:,99))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,655),heltab2x64(:,:,1056))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(209),n2h32(556))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1093),h0tab(:,1093),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,99))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,656),heltab2x64(:,:,1057))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(210),n2h32(557))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1094),h0tab(:,1094),[32,4,27],[0,0,0],3,1,wf16(:,99))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,657),heltab2x64(:,:,1058))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(215),n2h32(558))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1095),h0tab(:,1095),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,99))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,658),heltab2x64(:,:,1059))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(212),n2h32(559))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1096),h0tab(:,1096),[32,4,27],[0,0,0],3,1,wf16(:,99))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,659),heltab2x64(:,:,1060))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(217),n2h32(560))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1097),h0tab(:,1097),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,99))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,660),heltab2x64(:,:,1061))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(214),n2h32(561))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1098),h0tab(:,1098),[32,2,29],[0,0,0],3,1,wf16(:,101))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,661),heltab2x64(:,:,1062))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(216),n2h32(562))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1099),h0tab(:,1099),[32,2,29],[0,0,0],3,1,wf16(:,101))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(218),m3h2x32(:,662),heltab2x64(:,:,1063))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1100),h0tab(:,1100),[57,2,4],[0,0,0],3,1,wf16(:,103))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,103),G0H4(57),m3h16x4(:,126),heltab2x64(:,:,1064))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1101),h0tab(:,1101),[53,2,8],[0,0,0],3,1,wf16(:,105))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,105),G0H4(58),m3h16x4(:,127),heltab2x64(:,:,1065))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1102),h0tab(:,1102),[57,2,4],[0,0,0],3,1,wf16(:,107))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,107),G0H4(59),m3h16x4(:,128),heltab2x64(:,:,1066))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1103),h0tab(:,1103),[37,8,18],[0,0,0],3,2,wf8(:,44),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,44),G0H8(28),m3h8x8(:,143),heltab2x64(:,:,1067))
  call Hloop_Q_A(ntryL,G0H8(28),37,0,G1H8(284),n2h8(1009))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1104),h0tab(:,1104),[41,4,18],[0,0,0],3,2,wf8(:,29),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,29),G0H8(4),m3h8x8(:,144),heltab2x64(:,:,1068))
  call Hloop_Q_A(ntryL,G0H8(4),41,0,G1H8(325),n2h8(1010))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1105),h0tab(:,1105),[33,8,22],[0,0,0],3,2,wf4(:,17),wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(71),m3h4x16(:,135),heltab2x64(:,:,1069))
  call Hloop_Q_A(ntryL,G0H16(71),33,0,G1H16(302),n2h16(493))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1106),h0tab(:,1106),[33,4,26],[0,0,0],3,2,wf4(:,17),wf8(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,17),G0H16(72),m3h4x16(:,136),heltab2x64(:,:,1070))
  call Hloop_Q_A(ntryL,G0H16(72),33,0,G1H16(305),n2h16(494))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1107),h0tab(:,1107),[32,8,23],[0,0,0],3,1,wf16(:,108))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,663),heltab2x64(:,:,1071))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(223),n2h32(563))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1108),h0tab(:,1108),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,108))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,664),heltab2x64(:,:,1072))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(220),n2h32(564))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1109),h0tab(:,1109),[32,8,23],[0,0,0],3,1,wf16(:,108))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,665),heltab2x64(:,:,1073))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(225),n2h32(565))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1110),h0tab(:,1110),[32,8,23],[nMT,nMT,nMT],3,1,wf16(:,108))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,666),heltab2x64(:,:,1074))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(222),n2h32(566))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1111),h0tab(:,1111),[32,8,23],[0,0,0],3,1,wf16(:,108))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,667),heltab2x64(:,:,1075))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(224),n2h32(567))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1112),h0tab(:,1112),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,108))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,668),heltab2x64(:,:,1076))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(226),n2h32(568))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1113),h0tab(:,1113),[32,8,23],[0,0,0],3,1,wf16(:,108))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,669),heltab2x64(:,:,1077))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(231),n2h32(569))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1114),h0tab(:,1114),[32,8,23],[nMB,nMB,nMB],3,1,wf16(:,108))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,670),heltab2x64(:,:,1078))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(228),n2h32(570))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1115),h0tab(:,1115),[32,4,27],[0,0,0],3,1,wf16(:,109))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,671),heltab2x64(:,:,1079))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(233),n2h32(571))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1116),h0tab(:,1116),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,109))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,672),heltab2x64(:,:,1080))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(230),n2h32(572))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1117),h0tab(:,1117),[32,4,27],[0,0,0],3,1,wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,673),heltab2x64(:,:,1081))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(232),n2h32(573))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1118),h0tab(:,1118),[32,4,27],[nMT,nMT,nMT],3,1,wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,674),heltab2x64(:,:,1082))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(234),n2h32(574))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1119),h0tab(:,1119),[32,4,27],[0,0,0],3,1,wf16(:,109))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,675),heltab2x64(:,:,1083))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(235),n2h32(575))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1120),h0tab(:,1120),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,109))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,676),heltab2x64(:,:,1084))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(236),n2h32(576))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1121),h0tab(:,1121),[32,4,27],[0,0,0],3,1,wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,677),heltab2x64(:,:,1085))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(237),n2h32(577))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1122),h0tab(:,1122),[32,4,27],[nMB,nMB,nMB],3,1,wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,678),heltab2x64(:,:,1086))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(238),n2h32(578))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1123),h0tab(:,1123),[32,1,30],[0,0,0],3,1,wf16(:,111))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,679),heltab2x64(:,:,1087))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(239),n2h32(579))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1124),h0tab(:,1124),[32,1,30],[0,0,0],3,1,wf16(:,111))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(240),m3h2x32(:,680),heltab2x64(:,:,1088))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1125),h0tab(:,1125),[54,1,8],[0,0,0],3,1,wf16(:,113))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,113),G0H4(60),m3h16x4(:,129),heltab2x64(:,:,1089))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1126),h0tab(:,1126),[32,1,30],[0,0,0],3,1,wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,681),heltab2x64(:,:,1090))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(241),n2h32(580))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1127),h0tab(:,1127),[32,1,30],[0,0,0],3,1,wf16(:,115))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(242),m3h2x32(:,682),heltab2x64(:,:,1091))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1128),h0tab(:,1128),[58,1,4],[0,0,0],3,1,wf16(:,117))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,117),G0H4(61),m3h16x4(:,130),heltab2x64(:,:,1092))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(332)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1129),h0tab(:,1129),[54,1,8],[0,0,0],3,1,wf16(:,119))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,119),G0H4(62),m3h16x4(:,131),heltab2x64(:,:,1093))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1130),h0tab(:,1130),[58,1,4],[0,0,0],3,1,wf16(:,121))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,121),G0H4(63),m3h16x4(:,132),heltab2x64(:,:,1094))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1131),h0tab(:,1131),[39,8,16],[0,0,0],3,1,wf16(:,122))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,122),G0H4(64),m3h16x4(:,133),heltab2x64(:,:,1095))
  call Hloop_A_Q(ntryL,G0H4(64),39,0,G1H4(581),n2h4(1573))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1132),h0tab(:,1132),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,122))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,122),G0H4(66),m3h16x4(:,134),heltab2x64(:,:,1096))
  call Hloop_A_Q(ntryL,G0H4(66),39,nMT,G1H4(165),n2h4(1574))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1133),h0tab(:,1133),[39,8,16],[0,0,0],3,1,wf16(:,122))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,122),G0H4(68),m3h16x4(:,135),heltab2x64(:,:,1097))
  call Hloop_Q_A(ntryL,G0H4(68),39,0,G1H4(1517),n2h4(1575))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1134),h0tab(:,1134),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,122))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,122),G0H4(69),m3h16x4(:,136),heltab2x64(:,:,1098))
  call Hloop_Q_A(ntryL,G0H4(69),39,nMT,G1H4(590),n2h4(1576))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1135),h0tab(:,1135),[39,8,16],[0,0,0],3,1,wf16(:,122))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,122),G0H4(70),m3h16x4(:,137),heltab2x64(:,:,1099))
  call Hloop_A_Q(ntryL,G0H4(70),39,0,G1H4(468),n2h4(1577))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1136),h0tab(:,1136),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,122))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,122),G0H4(71),m3h16x4(:,138),heltab2x64(:,:,1100))
  call Hloop_A_Q(ntryL,G0H4(71),39,nMB,G1H4(344),n2h4(1578))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1137),h0tab(:,1137),[39,8,16],[0,0,0],3,1,wf16(:,122))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,122),G0H4(72),m3h16x4(:,139),heltab2x64(:,:,1101))
  call Hloop_Q_A(ntryL,G0H4(72),39,0,G1H4(628),n2h4(1579))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1138),h0tab(:,1138),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,122))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,122),G0H4(19),m3h16x4(:,140),heltab2x64(:,:,1102))
  call Hloop_Q_A(ntryL,G0H4(19),39,nMB,G1H4(283),n2h4(1580))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(336)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1139),h0tab(:,1139),[45,2,16],[0,0,0],3,1,wf16(:,124))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,124),G0H4(20),m3h16x4(:,141),heltab2x64(:,:,1103))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(336)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1140),h0tab(:,1140),[45,2,16],[0,0,0],3,1,wf16(:,124))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,124),G0H4(21),m3h16x4(:,142),heltab2x64(:,:,1104))
  call Hloop_Q_A(ntryL,G0H4(21),45,0,G1H4(419),n2h4(1581))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1141),h0tab(:,1141),[53,2,8],[0,0,0],3,1,wf16(:,126))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,126),G0H4(23),m3h16x4(:,143),heltab2x64(:,:,1105))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1142),h0tab(:,1142),[43,4,16],[0,0,0],3,1,wf16(:,127))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,127),G0H4(24),m3h16x4(:,144),heltab2x64(:,:,1106))
  call Hloop_A_Q(ntryL,G0H4(24),43,0,G1H4(657),n2h4(1582))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1143),h0tab(:,1143),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,127))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,127),G0H4(73),m3h16x4(:,145),heltab2x64(:,:,1107))
  call Hloop_A_Q(ntryL,G0H4(73),43,nMT,G1H4(379),n2h4(1583))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1144),h0tab(:,1144),[43,4,16],[0,0,0],3,1,wf16(:,127))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,127),G0H4(74),m3h16x4(:,146),heltab2x64(:,:,1108))
  call Hloop_Q_A(ntryL,G0H4(74),43,0,G1H4(420),n2h4(1584))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1145),h0tab(:,1145),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,127))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,127),G0H4(75),m3h16x4(:,147),heltab2x64(:,:,1109))
  call Hloop_Q_A(ntryL,G0H4(75),43,nMT,G1H4(619),n2h4(1585))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1146),h0tab(:,1146),[43,4,16],[0,0,0],3,1,wf16(:,127))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,127),G0H4(76),m3h16x4(:,148),heltab2x64(:,:,1110))
  call Hloop_A_Q(ntryL,G0H4(76),43,0,G1H4(447),n2h4(1586))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1147),h0tab(:,1147),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,127))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,127),G0H4(77),m3h16x4(:,149),heltab2x64(:,:,1111))
  call Hloop_A_Q(ntryL,G0H4(77),43,nMB,G1H4(460),n2h4(1587))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1148),h0tab(:,1148),[43,4,16],[0,0,0],3,1,wf16(:,127))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,127),G0H4(78),m3h16x4(:,150),heltab2x64(:,:,1112))
  call Hloop_Q_A(ntryL,G0H4(78),43,0,G1H4(263),n2h4(1588))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1149),h0tab(:,1149),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,127))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,127),G0H4(79),m3h16x4(:,151),heltab2x64(:,:,1113))
  call Hloop_Q_A(ntryL,G0H4(79),43,nMB,G1H4(335),n2h4(1589))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1150),h0tab(:,1150),[45,2,16],[0,0,0],3,1,wf16(:,129))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,129),G0H4(80),m3h16x4(:,152),heltab2x64(:,:,1114))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1151),h0tab(:,1151),[45,2,16],[0,0,0],3,1,wf16(:,129))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,129),G0H4(25),m3h16x4(:,153),heltab2x64(:,:,1115))
  call Hloop_Q_A(ntryL,G0H4(25),45,0,G1H4(317),n2h4(1590))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1152),h0tab(:,1152),[57,2,4],[0,0,0],3,1,wf16(:,131))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,131),G0H4(26),m3h16x4(:,154),heltab2x64(:,:,1116))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1153),h0tab(:,1153),[53,2,8],[0,0,0],3,1,wf16(:,133))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,133),G0H4(27),m3h16x4(:,155),heltab2x64(:,:,1117))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(342)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1154),h0tab(:,1154),[57,2,4],[0,0,0],3,1,wf16(:,135))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,135),G0H4(28),m3h16x4(:,156),heltab2x64(:,:,1118))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1155),h0tab(:,1155),[39,8,16],[0,0,0],3,1,wf16(:,136))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,136),G0H4(29),m3h16x4(:,157),heltab2x64(:,:,1119))
  call Hloop_A_Q(ntryL,G0H4(29),39,0,G1H4(152),n2h4(1591))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1156),h0tab(:,1156),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,136))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,136),G0H4(30),m3h16x4(:,158),heltab2x64(:,:,1120))
  call Hloop_A_Q(ntryL,G0H4(30),39,nMT,G1H4(167),n2h4(1592))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1157),h0tab(:,1157),[39,8,16],[0,0,0],3,1,wf16(:,136))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,136),G0H4(82),m3h16x4(:,159),heltab2x64(:,:,1121))
  call Hloop_Q_A(ntryL,G0H4(82),39,0,G1H4(350),n2h4(1593))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1158),h0tab(:,1158),[39,8,16],[nMT,nMT,nMT],3,1,wf16(:,136))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,136),G0H4(85),m3h16x4(:,160),heltab2x64(:,:,1122))
  call Hloop_Q_A(ntryL,G0H4(85),39,nMT,G1H4(179),n2h4(1594))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1159),h0tab(:,1159),[39,8,16],[0,0,0],3,1,wf16(:,136))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,136),G0H4(87),m3h16x4(:,161),heltab2x64(:,:,1123))
  call Hloop_A_Q(ntryL,G0H4(87),39,0,G1H4(132),n2h4(1595))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1160),h0tab(:,1160),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,136))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,136),G0H4(88),m3h16x4(:,162),heltab2x64(:,:,1124))
  call Hloop_A_Q(ntryL,G0H4(88),39,nMB,G1H4(331),n2h4(1596))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1161),h0tab(:,1161),[39,8,16],[0,0,0],3,1,wf16(:,136))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,136),G0H4(31),m3h16x4(:,163),heltab2x64(:,:,1125))
  call Hloop_Q_A(ntryL,G0H4(31),39,0,G1H4(541),n2h4(1597))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1162),h0tab(:,1162),[39,8,16],[nMB,nMB,nMB],3,1,wf16(:,136))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,136),G0H4(32),m3h16x4(:,164),heltab2x64(:,:,1126))
  call Hloop_Q_A(ntryL,G0H4(32),39,nMB,G1H4(228),n2h4(1598))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1163),h0tab(:,1163),[43,4,16],[0,0,0],3,1,wf16(:,137))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,137),G0H4(33),m3h16x4(:,165),heltab2x64(:,:,1127))
  call Hloop_A_Q(ntryL,G0H4(33),43,0,G1H4(144),n2h4(1599))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1164),h0tab(:,1164),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,137))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,137),G0H4(34),m3h16x4(:,166),heltab2x64(:,:,1128))
  call Hloop_A_Q(ntryL,G0H4(34),43,nMT,G1H4(216),n2h4(1600))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1165),h0tab(:,1165),[43,4,16],[0,0,0],3,1,wf16(:,137))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,137),G0H4(35),m3h16x4(:,167),heltab2x64(:,:,1129))
  call Hloop_Q_A(ntryL,G0H4(35),43,0,G1H4(33),n2h4(1601))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1166),h0tab(:,1166),[43,4,16],[nMT,nMT,nMT],3,1,wf16(:,137))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,137),G0H4(36),m3h16x4(:,168),heltab2x64(:,:,1130))
  call Hloop_Q_A(ntryL,G0H4(36),43,nMT,G1H4(288),n2h4(1602))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1167),h0tab(:,1167),[43,4,16],[0,0,0],3,1,wf16(:,137))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,137),G0H4(90),m3h16x4(:,169),heltab2x64(:,:,1131))
  call Hloop_A_Q(ntryL,G0H4(90),43,0,G1H4(554),n2h4(1603))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1168),h0tab(:,1168),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,137))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,137),G0H4(91),m3h16x4(:,170),heltab2x64(:,:,1132))
  call Hloop_A_Q(ntryL,G0H4(91),43,nMB,G1H4(300),n2h4(1604))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1169),h0tab(:,1169),[43,4,16],[0,0,0],3,1,wf16(:,137))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,137),G0H4(92),m3h16x4(:,171),heltab2x64(:,:,1133))
  call Hloop_Q_A(ntryL,G0H4(92),43,0,G1H4(372),n2h4(1605))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1170),h0tab(:,1170),[43,4,16],[nMB,nMB,nMB],3,1,wf16(:,137))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,137),G0H4(93),m3h16x4(:,172),heltab2x64(:,:,1134))
  call Hloop_Q_A(ntryL,G0H4(93),43,nMB,G1H4(408),n2h4(1606))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1171),h0tab(:,1171),[46,1,16],[0,0,0],3,1,wf16(:,139))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,139),G0H4(94),m3h16x4(:,173),heltab2x64(:,:,1135))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1172),h0tab(:,1172),[46,1,16],[0,0,0],3,1,wf16(:,139))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,139),G0H4(95),m3h16x4(:,174),heltab2x64(:,:,1136))
  call Hloop_A_Q(ntryL,G0H4(95),46,0,G1H4(557),n2h4(1607))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1173),h0tab(:,1173),[54,1,8],[0,0,0],3,1,wf16(:,141))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,141),G0H4(96),m3h16x4(:,175),heltab2x64(:,:,1137))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1174),h0tab(:,1174),[46,1,16],[0,0,0],3,1,wf16(:,143))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,143),G0H4(97),m3h16x4(:,176),heltab2x64(:,:,1138))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1175),h0tab(:,1175),[46,1,16],[0,0,0],3,1,wf16(:,143))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,143),G0H4(99),m3h16x4(:,177),heltab2x64(:,:,1139))
  call Hloop_A_Q(ntryL,G0H4(99),46,0,G1H4(452),n2h4(1608))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(349)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1176),h0tab(:,1176),[58,1,4],[0,0,0],3,1,wf16(:,145))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,145),G0H4(101),m3h16x4(:,178),heltab2x64(:,:,1140))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(350)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1177),h0tab(:,1177),[54,1,8],[0,0,0],3,1,wf16(:,147))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,147),G0H4(102),m3h16x4(:,179),heltab2x64(:,:,1141))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(351)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1178),h0tab(:,1178),[58,1,4],[0,0,0],3,1,wf16(:,149))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,149),G0H4(103),m3h16x4(:,180),heltab2x64(:,:,1142))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1179),h0tab(:,1179),[53,2,8],[0,0,0],3,1,wf16(:,151))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,151),G0H4(104),m3h16x4(:,181),heltab2x64(:,:,1143))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1180),h0tab(:,1180),[57,2,4],[0,0,0],3,1,wf16(:,153))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,153),G0H4(105),m3h16x4(:,182),heltab2x64(:,:,1144))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1181),h0tab(:,1181),[54,1,8],[0,0,0],3,1,wf16(:,155))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,155),G0H4(106),m3h16x4(:,183),heltab2x64(:,:,1145))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(355)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1182),h0tab(:,1182),[58,1,4],[0,0,0],3,1,wf16(:,157))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,157),G0H4(107),m3h16x4(:,184),heltab2x64(:,:,1146))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1171),[G1H4(357),G1H4(237),G1H4(117),G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1181),[G1H4(118),G1H4(135),G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1193),[G1H4(449),G1H4(178),G1H4(13),G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(297),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(399),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(685),[G1H4(40),G1H4(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(541),[G1H4(350),G1H4(628),G1H4(1517),G1H4(528),G1H4(647) &
    ,G1H4(108),G1H4(768),G1H4(299),G1H4(347),G1H4(93),G1H4(114),G1H4(448),G1H4(693),G1H4(801),G1H4(667),G1H4(655),G1H4(530) &
    ,G1H4(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(372),[G1H4(33),G1H4(263),G1H4(420),G1H4(1414),G1H4(1525) &
    ,G1H4(1450),G1H4(1635),G1H4(1598),G1H4(1652),G1H4(1238),G1H4(1206),G1H4(1488),G1H4(1451),G1H4(1094),G1H4(536),G1H4(989) &
    ,G1H4(521),G1H4(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(185),[G1H4(549),G1H4(505)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(680),[G1H4(556),G1H4(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(208),[G1H4(17),G1H4(535)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1151),[G1H4(622),G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(152),G1H4(468),G1H4(581),G1H4(324),G1H4(395) &
    ,G1H4(609),G1H4(110),G1H4(811),G1H4(80),G1H4(723),G1H4(591),G1H4(431),G1H4(397),G1H4(380),G1H4(354),G1H4(1113),G1H4(597) &
    ,G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(554),[G1H4(144),G1H4(447),G1H4(657),G1H4(1487),G1H4(1382) &
    ,G1H4(1651),G1H4(1619),G1H4(1636),G1H4(1599),G1H4(1222),G1H4(1190),G1H4(1504),G1H4(1472),G1H4(1062),G1H4(424),G1H4(1130) &
    ,G1H4(589),G1H4(571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1122),[G1H4(630),G1H4(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1166),[G1H4(636),G1H4(583)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1140),[G1H4(614),G1H4(607)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1370),[G1H4(963),G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1202),[G1H4(872),G1H4(700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1362),[G1H4(940),G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1210),[G1H4(427),G1H4(715)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1391),[G1H4(1013),G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1220),[G1H4(897),G1H4(730)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1380),[G1H4(988),G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1231),[G1H4(912),G1H4(745)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1282),[G1H4(813),G1H4(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(288),[G1H4(619),G1H4(1398),G1H4(1350),G1H4(1286) &
    ,G1H4(1561),G1H4(1142),G1H4(469),G1H4(1246),G1H4(1050),G1H4(760)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1290),[G1H4(376),G1H4(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(216),[G1H4(379),G1H4(1471),G1H4(1334),G1H4(1270) &
    ,G1H4(1545),G1H4(1126),G1H4(666),G1H4(1251),G1H4(1025),G1H4(775)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1300),[G1H4(843),G1H4(782)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(408),[G1H4(335),G1H4(1503),G1H4(1546),G1H4(1318) &
    ,G1H4(1620),G1H4(1174),G1H4(1110),G1H4(1261),G1H4(1091),G1H4(789)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1311),[G1H4(857),G1H4(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(460),G1H4(1578),G1H4(1366),G1H4(1302) &
    ,G1H4(1577),G1H4(1158),G1H4(1078),G1H4(1273),G1H4(1071),G1H4(799)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1411),[G1H4(1060),G1H4(806)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1406),[G1H4(1038),G1H4(818)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1433),[G1H4(1101),G1H4(839)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1421),[G1H4(1086),G1H4(847)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(608),[G1H8(615),G1H8(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(309),[G1H8(302),G1H8(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(594),G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(604),G1H8(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(207),[G1H8(293),G1H8(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(373),[G1H8(205),G1H8(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(165),G1H4(168),G1H4(821),G1H4(738),G1H4(35) &
    ,G1H4(414),G1H4(787),G1H4(1326),G1H4(950),G1H4(949)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(179),[G1H4(590),G1H4(508),G1H4(434),G1H4(105),G1H4(83) &
    ,G1H4(582),G1H4(367),G1H4(1331),G1H4(936),G1H4(886)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(331),[G1H4(344),G1H4(637),G1H4(285),G1H4(753),G1H4(620) &
    ,G1H4(85),G1H4(332),G1H4(1341),G1H4(1000),G1H4(1049)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(228),[G1H4(283),G1H4(384),G1H4(599),G1H4(383),G1H4(200) &
    ,G1H4(199),G1H4(677),G1H4(1353),G1H4(975),G1H4(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(511),G1H8(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(56),G1H8(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(270),G1H8(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(360),G1H8(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(141),[G1H8(17),G1H8(506)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(195),[G1H8(154),G1H8(524)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(250),[G1H8(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(129),G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(341),[G1H8(337),G1H8(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(193),[G1H8(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(322),[G1H8(286),G1H8(196),G1H8(291),G1H8(391) &
    ,G1H8(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(388),[G1H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(344),[G1H8(327),G1H8(103),G1H8(26),G1H8(91),G1H8(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(348),[G1H8(79),G1H8(188),G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(122),G1H8(446),G1H8(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(284),[G1H8(46),G1H8(526),G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(178),G1H8(606),G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(237),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(254),[G1H16(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(269),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(89),[G1H16(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(301),[G1H16(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(302),[G1H16(505)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(305),[G1H16(509)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(233),[G0H16(3),G0H16(2),G0H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(67),[G0H16(6),G0H16(5),G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(252),[G0H16(7),G0H16(8),G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(267),[G0H16(10),G0H16(11),G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(284),[G0H16(16),G0H16(15),G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(300),[G0H16(17),G0H16(14),G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(55),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(34),[G1H32(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(58),[G0H8(57),G0H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(130),[G1H32(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(150),[G1H32(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(244),[G1H16(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(246),[G1H16(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(104),[G0H4(27),G0H4(23),G0H4(58),G0H4(55),G0H4(67) &
    ,G0H4(56),G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(183),[G1H32(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(191),[G1H32(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(221),[G1H32(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(229),[G1H32(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(80),[G0H4(20),G0H4(1),G0H4(98),G0H4(65),G0H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(317),[G1H4(419),G1H4(1254),G1H4(1524),G1H4(191) &
    ,G1H4(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(51),[G1H32(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(81),[G1H32(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(123),[G1H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(29),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(237),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(13),[G1H32(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(15),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(19),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(40),[G1H32(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(42),[G1H32(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(261),[G1H16(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(265),[G1H16(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(106),[G0H4(102),G0H4(96),G0H4(62),G0H4(60),G0H4(86) &
    ,G0H4(83),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(48),[G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(50),[G1H32(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(58),[G1H32(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(60),[G1H32(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(77),[G1H32(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(78),[G1H32(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(97),[G0H4(94),G0H4(51),G0H4(48),G0H4(84),G0H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(452),[G1H4(557),G1H4(1430),G1H4(1562),G1H4(532) &
    ,G1H4(676)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(101),[G1H32(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(103),[G1H32(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(276),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(280),[G1H16(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(105),[G0H4(28),G0H4(26),G0H4(59),G0H4(57),G0H4(3) &
    ,G0H4(100),G0H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(109),[G1H32(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(111),[G1H32(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(119),[G1H32(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(121),[G1H32(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(136),[G1H32(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(138),[G1H32(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(154),[G1H32(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(153),[G1H32(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(291),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(295),[G1H16(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(107),[G0H4(103),G0H4(101),G0H4(63),G0H4(61),G0H4(53) &
    ,G0H4(50),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(161),[G1H32(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(168),[G1H32(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(172),[G1H32(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(174),[G1H32(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(187),[G1H32(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(186),[G1H32(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(203),[G1H32(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(202),[G1H32(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(215),[G1H32(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(217),[G1H32(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(224),[G1H32(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(231),[G1H32(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(235),[G1H32(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(237),[G1H32(232)])
  call Hloop_QV_A(ntryL,G1H4(1171),ex4(:),G1H2(1283),m3h2x2(:,2240),heltab2x4(:,:,2570))
  call Hloop_Q_A(ntryL,G1H2(1283),61,0,G2H2(511),n2h2(2238))
  call Hloop_QV_A(ntryL,G1H4(1181),ex5(:),G1H2(1361),m3h2x2(:,2241),heltab2x4(:,:,2571))
  call Hloop_Q_A(ntryL,G1H2(1361),61,0,G2H2(281),n2h2(2239))
  call Hloop_QV_A(ntryL,G1H4(1193),ex3(:),G1H2(1295),m3h2x2(:,2242),heltab2x4(:,:,2572))
  call Hloop_Q_A(ntryL,G1H2(1295),61,0,G2H2(275),n2h2(2240))
  call Hloop_AV_Q(ntryL,G1H4(297),ex3(:),G1H2(1289),m3h2x2(:,2243),heltab2x4(:,:,2573))
  call Hloop_A_Q(ntryL,G1H2(1289),62,0,G2H2(4),n2h2(2241))
  call Hloop_AV_Q(ntryL,G1H4(399),ex4(:),G1H2(1306),m3h2x2(:,2244),heltab2x4(:,:,2574))
  call Hloop_A_Q(ntryL,G1H2(1306),62,0,G2H2(540),n2h2(2242))
  call Hloop_AV_Q(ntryL,G1H4(273),ex5(:),G1H2(1300),m3h2x2(:,2245),heltab2x4(:,:,2575))
  call Hloop_A_Q(ntryL,G1H2(1300),62,0,G2H2(284),n2h2(2243))
  call Hloop_QV_A(ntryL,G1H4(685),ex3(:),G1H2(1367),m3h2x2(:,2246),heltab2x4(:,:,2576))
  call Hloop_Q_A(ntryL,G1H2(1367),55,0,G2H2(278),n2h2(2244))
  call Hloop_QV_A(ntryL,G1H4(541),ex4(:),G1H2(1312),m3h2x2(:,2247),heltab2x4(:,:,2577))
  call Hloop_Q_A(ntryL,G1H2(1312),47,0,G2H2(13),n2h2(2245))
  call Hloop_QV_A(ntryL,G1H4(372),ex3(:),G1H2(1301),m3h2x2(:,2248),heltab2x4(:,:,2578))
  call Hloop_Q_A(ntryL,G1H2(1301),47,0,G2H2(490),n2h2(2246))
  call Hloop_QV_A(ntryL,G1H4(185),ex5(:),G1H2(1373),m3h2x2(:,2249),heltab2x4(:,:,2579))
  call Hloop_Q_A(ntryL,G1H2(1373),55,0,G2H2(73),n2h2(2247))
  call Hloop_QV_A(ntryL,G1H4(680),ex4(:),G1H2(1313),m3h2x2(:,2250),heltab2x4(:,:,2580))
  call Hloop_Q_A(ntryL,G1H2(1313),59,0,G2H2(23),n2h2(2248))
  call Hloop_QV_A(ntryL,G1H4(208),ex5(:),G1H2(1307),m3h2x2(:,2251),heltab2x4(:,:,2581))
  call Hloop_Q_A(ntryL,G1H2(1307),59,0,G2H2(499),n2h2(2249))
  call Hloop_AV_Q(ntryL,G1H4(1151),ex3(:),G1H2(1409),m3h2x2(:,2252),heltab2x4(:,:,2582))
  call Hloop_A_Q(ntryL,G1H2(1409),55,0,G2H2(53),n2h2(2250))
  call Hloop_AV_Q(ntryL,G1H4(132),ex4(:),G1H2(1378),m3h2x2(:,2253),heltab2x4(:,:,2583))
  call Hloop_A_Q(ntryL,G1H2(1378),47,0,G2H2(33),n2h2(2251))
  call Hloop_AV_Q(ntryL,G1H4(554),ex3(:),G1H2(1389),m3h2x2(:,2254),heltab2x4(:,:,2584))
  call Hloop_A_Q(ntryL,G1H2(1389),47,0,G2H2(518),n2h2(2252))
  call Hloop_AV_Q(ntryL,G1H4(1122),ex5(:),G1H2(1379),m3h2x2(:,2255),heltab2x4(:,:,2585))
  call Hloop_A_Q(ntryL,G1H2(1379),55,0,G2H2(63),n2h2(2253))
  call Hloop_AV_Q(ntryL,G1H4(1166),ex4(:),G1H2(1414),m3h2x2(:,2256),heltab2x4(:,:,2586))
  call Hloop_A_Q(ntryL,G1H2(1414),59,0,G2H2(43),n2h2(2254))
  call Hloop_AV_Q(ntryL,G1H4(1140),ex5(:),G1H2(1383),m3h2x2(:,2257),heltab2x4(:,:,2587))
  call Hloop_A_Q(ntryL,G1H2(1383),59,0,G2H2(328),n2h2(2255))
  call Hloop_AV_Q(ntryL,G1H4(1370),ex5(:),G1H2(1394),m3h2x2(:,2258),heltab2x4(:,:,2588))
  call Hloop_A_Q(ntryL,G1H2(1394),59,nMT,G2H2(83),n2h2(2256))
  call Hloop_AV_Q(ntryL,G1H4(1202),ex3(:),G1H2(1384),m3h2x2(:,2259),heltab2x4(:,:,2589))
  call Hloop_A_Q(ntryL,G1H2(1384),55,nMT,G2H2(1537),n2h2(2257))
  call Hloop_QV_A(ntryL,G1H4(1362),ex5(:),G1H2(1388),m3h2x2(:,2260),heltab2x4(:,:,2590))
  call Hloop_Q_A(ntryL,G1H2(1388),59,nMT,G2H2(539),n2h2(2258))
  call Hloop_QV_A(ntryL,G1H4(1210),ex3(:),G1H2(1393),m3h2x2(:,2261),heltab2x4(:,:,2591))
  call Hloop_Q_A(ntryL,G1H2(1393),55,nMT,G2H2(88),n2h2(2259))
  call Hloop_AV_Q(ntryL,G1H4(1391),ex5(:),G1H2(1398),m3h2x2(:,2262),heltab2x4(:,:,2592))
  call Hloop_A_Q(ntryL,G1H2(1398),59,nMB,G2H2(1768),n2h2(2260))
  call Hloop_AV_Q(ntryL,G1H4(1220),ex3(:),G1H2(1403),m3h2x2(:,2263),heltab2x4(:,:,2593))
  call Hloop_A_Q(ntryL,G1H2(1403),55,nMB,G2H2(1026),n2h2(2261))
  call Hloop_QV_A(ntryL,G1H4(1380),ex5(:),G1H2(1434),m3h2x2(:,2264),heltab2x4(:,:,2594))
  call Hloop_Q_A(ntryL,G1H2(1434),59,nMB,G2H2(796),n2h2(2262))
  call Hloop_QV_A(ntryL,G1H4(1231),ex3(:),G1H2(1429),m3h2x2(:,2265),heltab2x4(:,:,2595))
  call Hloop_Q_A(ntryL,G1H2(1429),55,nMB,G2H2(356),n2h2(2263))
  call Hloop_QV_A(ntryL,G1H4(1282),ex4(:),G1H2(1433),m3h2x2(:,2266),heltab2x4(:,:,2596))
  call Hloop_Q_A(ntryL,G1H2(1433),59,nMT,G2H2(288),n2h2(2264))
  call Hloop_QV_A(ntryL,G1H4(288),ex3(:),G1H2(1564),m3h2x2(:,2267),heltab2x4(:,:,2597))
  call Hloop_Q_A(ntryL,G1H2(1564),47,nMT,G2H2(93),n2h2(2265))
  call Hloop_AV_Q(ntryL,G1H4(1290),ex4(:),G1H2(1439),m3h2x2(:,2268),heltab2x4(:,:,2598))
  call Hloop_A_Q(ntryL,G1H2(1439),59,nMT,G2H2(543),n2h2(2266))
  call Hloop_AV_Q(ntryL,G1H4(216),ex3(:),G1H2(1449),m3h2x2(:,2269),heltab2x4(:,:,2599))
  call Hloop_A_Q(ntryL,G1H2(1449),47,nMT,G2H2(98),n2h2(2267))
  call Hloop_QV_A(ntryL,G1H4(1300),ex4(:),G1H2(1444),m3h2x2(:,2270),heltab2x4(:,:,2600))
  call Hloop_Q_A(ntryL,G1H2(1444),59,nMB,G2H2(1810),n2h2(2268))
  call Hloop_QV_A(ntryL,G1H4(408),ex3(:),G1H2(1448),m3h2x2(:,2271),heltab2x4(:,:,2601))
  call Hloop_Q_A(ntryL,G1H2(1448),47,nMB,G2H2(954),n2h2(2269))
  call Hloop_AV_Q(ntryL,G1H4(1311),ex4(:),G1H2(1584),m3h2x2(:,2272),heltab2x4(:,:,2602))
  call Hloop_A_Q(ntryL,G1H2(1584),59,nMB,G2H2(810),n2h2(2270))
  call Hloop_AV_Q(ntryL,G1H4(300),ex3(:),G1H2(1454),m3h2x2(:,2273),heltab2x4(:,:,2603))
  call Hloop_A_Q(ntryL,G1H2(1454),47,nMB,G2H2(324),n2h2(2271))
  call Hloop_QV_A(ntryL,G1H4(1411),ex5(:),G1H2(1624),m3h2x2(:,2274),heltab2x4(:,:,2604))
  call Hloop_Q_A(ntryL,G1H2(1624),55,nMT,G2H2(292),n2h2(2272))
  call Hloop_AV_Q(ntryL,G1H4(1406),ex5(:),G1H2(1589),m3h2x2(:,2275),heltab2x4(:,:,2605))
  call Hloop_A_Q(ntryL,G1H2(1589),55,nMT,G2H2(103),n2h2(2273))
  call Hloop_QV_A(ntryL,G1H4(1433),ex5(:),G1H2(1494),m3h2x2(:,2276),heltab2x4(:,:,2606))
  call Hloop_Q_A(ntryL,G1H2(1494),55,nMB,G2H2(547),n2h2(2274))
  call Hloop_AV_Q(ntryL,G1H4(1421),ex5(:),G1H2(1459),m3h2x2(:,2277),heltab2x4(:,:,2607))
  call Hloop_A_Q(ntryL,G1H2(1459),55,nMB,G2H2(108),n2h2(2275))
  call Hloop_AV_Q(ntryL,G1H8(158),ex4(:),G1H4(390),m3h2x4(:,1113),heltab2x8(:,:,1925))
  call Hloop_A_Q(ntryL,G1H4(390),60,0,G2H4(276),n2h4(1609))
  call Hloop_AV_Q(ntryL,G1H8(608),wf4(:,18),G1H2(1654),m3h4x2(:,513),heltab2x8(:,:,1926))
  call Hloop_A_Q(ntryL,G1H2(1654),47,0,G2H2(551),n2h2(2276))
  call Hloop_AV_Q(ntryL,G1H8(363),ex4(:),G1H4(441),m3h2x4(:,1114),heltab2x8(:,:,1927))
  call Hloop_A_Q(ntryL,G1H4(441),60,nMT,G2H4(408),n2h4(1610))
  call Hloop_AV_Q(ntryL,G1H8(309),wf4(:,18),G1H2(1594),m3h4x2(:,514),heltab2x8(:,:,1928))
  call Hloop_A_Q(ntryL,G1H2(1594),47,nMT,G2H2(113),n2h2(2277))
  call Hloop_QV_A(ntryL,G1H8(200),ex4(:),G1H4(101),m3h2x4(:,1115),heltab2x8(:,:,1929))
  call Hloop_Q_A(ntryL,G1H4(101),60,0,G2H4(304),n2h4(1611))
  call Hloop_QV_A(ntryL,G1H8(94),wf4(:,18),G1H2(1519),m3h4x2(:,515),heltab2x8(:,:,1930))
  call Hloop_Q_A(ntryL,G1H2(1519),47,0,G2H2(1858),n2h2(2278))
  call Hloop_QV_A(ntryL,G1H8(380),ex4(:),G1H4(25),m3h2x4(:,1116),heltab2x8(:,:,1931))
  call Hloop_Q_A(ntryL,G1H4(25),60,nMT,G2H4(400),n2h4(1612))
  call Hloop_QV_A(ntryL,G1H8(90),wf4(:,18),G1H2(1464),m3h4x2(:,516),heltab2x8(:,:,1932))
  call Hloop_Q_A(ntryL,G1H2(1464),47,nMT,G2H2(1744),n2h2(2279))
  call Hloop_AV_Q(ntryL,G1H8(247),ex4(:),G1H4(570),m3h2x4(:,1117),heltab2x8(:,:,1933))
  call Hloop_A_Q(ntryL,G1H4(570),60,nMB,G2H4(296),n2h4(1613))
  call Hloop_AV_Q(ntryL,G1H8(207),wf4(:,18),G1H2(1664),m3h4x2(:,517),heltab2x8(:,:,1934))
  call Hloop_A_Q(ntryL,G1H2(1664),47,nMB,G2H2(1088),n2h2(2280))
  call Hloop_QV_A(ntryL,G1H8(294),ex4(:),G1H4(26),m3h2x4(:,1118),heltab2x8(:,:,1935))
  call Hloop_Q_A(ntryL,G1H4(26),60,nMB,G2H4(404),n2h4(1614))
  call Hloop_QV_A(ntryL,G1H8(373),wf4(:,18),G1H2(1599),m3h4x2(:,518),heltab2x8(:,:,1936))
  call Hloop_Q_A(ntryL,G1H2(1599),47,nMB,G2H2(816),n2h2(2281))
  call Hloop_AV_Q(ntryL,G1H4(167),ex4(:),G1H2(1524),m3h2x2(:,2278),heltab2x4(:,:,2608))
  call Hloop_A_Q(ntryL,G1H2(1524),47,nMT,G2H2(388),n2h2(2282))
  call Hloop_QV_A(ntryL,G1H4(179),ex4(:),G1H2(1469),m3h2x2(:,2279),heltab2x4(:,:,2609))
  call Hloop_Q_A(ntryL,G1H2(1469),47,nMT,G2H2(296),n2h2(2283))
  call Hloop_AV_Q(ntryL,G1H4(331),ex4(:),G1H2(1619),m3h2x2(:,2280),heltab2x4(:,:,2610))
  call Hloop_A_Q(ntryL,G1H2(1619),47,nMB,G2H2(118),n2h2(2284))
  call Hloop_QV_A(ntryL,G1H4(228),ex4(:),G1H2(1604),m3h2x2(:,2281),heltab2x4(:,:,2611))
  call Hloop_Q_A(ntryL,G1H2(1604),47,nMB,G2H2(384),n2h2(2285))
  call Hloop_QV_A(ntryL,G1H8(330),ex3(:),G1H4(563),m3h2x4(:,1119),heltab2x8(:,:,1937))
  call Hloop_Q_A(ntryL,G1H4(563),60,0,G2H4(300),n2h4(1615))
  call Hloop_QV_A(ntryL,G1H8(246),ex3(:),G1H4(67),m3h2x4(:,1120),heltab2x8(:,:,1938))
  call Hloop_Q_A(ntryL,G1H4(67),60,nMT,G2H4(607),n2h4(1616))
  call Hloop_AV_Q(ntryL,G1H8(13),ex3(:),G1H4(68),m3h2x4(:,1121),heltab2x8(:,:,1939))
  call Hloop_A_Q(ntryL,G1H4(68),60,0,G2H4(224),n2h4(1617))
  call Hloop_AV_Q(ntryL,G1H8(41),ex3(:),G1H4(540),m3h2x4(:,1122),heltab2x8(:,:,1940))
  call Hloop_A_Q(ntryL,G1H4(540),60,nMT,G2H4(608),n2h4(1618))
  call Hloop_QV_A(ntryL,G1H8(49),ex3(:),G1H4(97),m3h2x4(:,1123),heltab2x8(:,:,1941))
  call Hloop_Q_A(ntryL,G1H4(97),60,nMB,G2H4(603),n2h4(1619))
  call Hloop_AV_Q(ntryL,G1H8(405),ex3(:),G1H4(547),m3h2x4(:,1124),heltab2x8(:,:,1942))
  call Hloop_A_Q(ntryL,G1H4(547),60,nMB,G2H4(229),n2h4(1620))
  call Hloop_AV_Q(ntryL,G1H8(417),ex5(:),G1H4(217),m3h2x4(:,1125),heltab2x8(:,:,1943))
  call Hloop_A_Q(ntryL,G1H4(217),60,0,G2H4(605),n2h4(1621))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,18),G1H2(1489),m3h4x2(:,519),heltab2x8(:,:,1944))
  call Hloop_A_Q(ntryL,G1H2(1489),55,0,G2H2(123),n2h2(2286))
  call Hloop_AV_Q(ntryL,G1H8(434),ex5(:),G1H4(218),m3h2x4(:,1126),heltab2x8(:,:,1945))
  call Hloop_A_Q(ntryL,G1H4(218),60,nMT,G2H4(239),n2h4(1622))
  call Hloop_AV_Q(ntryL,G1H8(28),wf4(:,18),G1H2(1474),m3h4x2(:,520),heltab2x8(:,:,1946))
  call Hloop_A_Q(ntryL,G1H2(1474),55,nMT,G2H2(1531),n2h2(2287))
  call Hloop_QV_A(ntryL,G1H8(455),ex5(:),G1H4(341),m3h2x4(:,1127),heltab2x8(:,:,1947))
  call Hloop_Q_A(ntryL,G1H4(341),60,0,G2H4(606),n2h4(1623))
  call Hloop_QV_A(ntryL,G1H8(45),wf4(:,18),G1H2(1634),m3h4x2(:,521),heltab2x8(:,:,1948))
  call Hloop_Q_A(ntryL,G1H2(1634),55,0,G2H2(555),n2h2(2288))
  call Hloop_QV_A(ntryL,G1H8(475),ex5(:),G1H4(318),m3h2x4(:,1128),heltab2x8(:,:,1949))
  call Hloop_Q_A(ntryL,G1H4(318),60,nMT,G2H4(604),n2h4(1624))
  call Hloop_QV_A(ntryL,G1H8(84),wf4(:,18),G1H2(1609),m3h4x2(:,522),heltab2x8(:,:,1950))
  call Hloop_Q_A(ntryL,G1H2(1609),55,nMT,G2H2(128),n2h2(2289))
  call Hloop_AV_Q(ntryL,G1H8(497),ex5(:),G1H4(687),m3h2x4(:,1129),heltab2x8(:,:,1951))
  call Hloop_A_Q(ntryL,G1H4(687),60,nMB,G2H4(244),n2h4(1625))
  call Hloop_AV_Q(ntryL,G1H8(141),wf4(:,18),G1H2(1504),m3h4x2(:,523),heltab2x8(:,:,1952))
  call Hloop_A_Q(ntryL,G1H2(1504),55,nMB,G2H2(1762),n2h2(2290))
  call Hloop_QV_A(ntryL,G1H8(514),ex5(:),G1H4(430),m3h2x4(:,1130),heltab2x8(:,:,1953))
  call Hloop_Q_A(ntryL,G1H4(430),60,nMB,G2H4(252),n2h4(1626))
  call Hloop_QV_A(ntryL,G1H8(195),wf4(:,18),G1H2(1479),m3h4x2(:,524),heltab2x8(:,:,1954))
  call Hloop_Q_A(ntryL,G1H2(1479),55,nMB,G2H2(1016),n2h2(2291))
  call Hloop_AV_Q(ntryL,G1H8(535),wf4(:,18),G1H2(1674),m3h4x2(:,525),heltab2x8(:,:,1955))
  call Hloop_A_Q(ntryL,G1H2(1674),59,0,G2H2(790),n2h2(2292))
  call Hloop_AV_Q(ntryL,G1H8(550),wf4(:,18),G1H2(1614),m3h4x2(:,526),heltab2x8(:,:,1956))
  call Hloop_A_Q(ntryL,G1H2(1614),59,nMT,G2H2(316),n2h2(2293))
  call Hloop_QV_A(ntryL,G1H8(555),wf4(:,18),G1H2(1529),m3h4x2(:,527),heltab2x8(:,:,1957))
  call Hloop_Q_A(ntryL,G1H2(1529),59,0,G2H2(300),n2h2(2294))
  call Hloop_QV_A(ntryL,G1H8(565),wf4(:,18),G1H2(1484),m3h4x2(:,528),heltab2x8(:,:,1958))
  call Hloop_Q_A(ntryL,G1H2(1484),59,nMT,G2H2(133),n2h2(2295))
  call Hloop_AV_Q(ntryL,G1H8(577),wf4(:,18),G1H2(1629),m3h4x2(:,529),heltab2x8(:,:,1959))
  call Hloop_A_Q(ntryL,G1H2(1629),59,nMB,G2H2(559),n2h2(2296))
  call Hloop_QV_A(ntryL,G1H8(586),wf4(:,18),G1H2(1499),m3h4x2(:,530),heltab2x8(:,:,1960))
  call Hloop_Q_A(ntryL,G1H2(1499),59,nMB,G2H2(138),n2h2(2297))
  call Hloop_AV_Q(ntryL,G1H8(250),ex5(:),G1H4(702),m3h2x4(:,1131),heltab2x8(:,:,1961))
  call Hloop_A_Q(ntryL,G1H4(702),58,0,G2H4(261),n2h4(1627))
  call Hloop_AV_Q(ntryL,G1H8(98),ex4(:),G1H4(23),m3h2x4(:,1132),heltab2x8(:,:,1962))
  call Hloop_A_Q(ntryL,G1H4(23),58,0,G2H4(278),n2h4(1628))
  call Hloop_QV_A(ntryL,G1H8(119),ex5(:),G1H4(717),m3h2x4(:,1133),heltab2x8(:,:,1963))
  call Hloop_Q_A(ntryL,G1H4(717),57,0,G2H4(287),n2h4(1629))
  call Hloop_QV_A(ntryL,G1H8(341),ex4(:),G1H4(131),m3h2x4(:,1134),heltab2x8(:,:,1964))
  call Hloop_Q_A(ntryL,G1H4(131),57,0,G2H4(308),n2h4(1630))
  call Hloop_AV_Q(ntryL,G1H8(193),ex5(:),G1H4(201),m3h2x4(:,1135),heltab2x8(:,:,1965))
  call Hloop_A_Q(ntryL,G1H4(201),54,0,G2H4(193),n2h4(1631))
  call Hloop_AV_Q(ntryL,G1H8(322),ex3(:),G1H4(747),m3h2x4(:,1136),heltab2x8(:,:,1966))
  call Hloop_A_Q(ntryL,G1H4(747),54,0,G2H4(313),n2h4(1632))
  call Hloop_QV_A(ntryL,G1H8(388),ex5(:),G1H4(371),m3h2x4(:,1137),heltab2x8(:,:,1967))
  call Hloop_Q_A(ntryL,G1H4(371),53,0,G2H4(127),n2h4(1633))
  call Hloop_QV_A(ntryL,G1H8(344),ex3(:),G1H4(762),m3h2x4(:,1138),heltab2x8(:,:,1968))
  call Hloop_Q_A(ntryL,G1H4(762),53,0,G2H4(318),n2h4(1634))
  call Hloop_AV_Q(ntryL,G1H8(348),ex4(:),G1H4(4),m3h2x4(:,1139),heltab2x8(:,:,1969))
  call Hloop_A_Q(ntryL,G1H4(4),46,0,G2H4(285),n2h4(1635))
  call Hloop_AV_Q(ntryL,G1H8(145),ex3(:),G1H4(28),m3h2x4(:,1140),heltab2x8(:,:,1970))
  call Hloop_A_Q(ntryL,G1H4(28),46,0,G2H4(323),n2h4(1636))
  call Hloop_QV_A(ntryL,G1H8(284),ex4(:),G1H4(94),m3h2x4(:,1141),heltab2x8(:,:,1971))
  call Hloop_Q_A(ntryL,G1H4(94),45,0,G2H4(324),n2h4(1637))
  call Hloop_QV_A(ntryL,G1H8(325),ex3(:),G1H4(933),m3h2x4(:,1142),heltab2x8(:,:,1972))
  call Hloop_Q_A(ntryL,G1H4(933),45,0,G2H4(328),n2h4(1638))
  call Hloop_AV_Q(ntryL,G1H16(236),ex4(:),G1H8(263),m3h2x8(:,691),heltab2x16(:,:,1087))
  call Hloop_A_Q(ntryL,G1H8(263),44,0,G2H8(208),n2h8(1011))
  call Hloop_AV_Q(ntryL,G1H16(242),ex4(:),G1H8(54),m3h2x8(:,692),heltab2x16(:,:,1088))
  call Hloop_A_Q(ntryL,G1H8(54),44,nMT,G2H8(209),n2h8(1012))
  call Hloop_QV_A(ntryL,G1H16(248),ex4(:),G1H8(413),m3h2x8(:,693),heltab2x16(:,:,1089))
  call Hloop_Q_A(ntryL,G1H8(413),44,0,G2H8(211),n2h8(1013))
  call Hloop_QV_A(ntryL,G1H16(251),ex4(:),G1H8(429),m3h2x8(:,694),heltab2x16(:,:,1090))
  call Hloop_Q_A(ntryL,G1H8(429),44,nMT,G2H8(212),n2h8(1014))
  call Hloop_AV_Q(ntryL,G1H16(257),ex4(:),G1H8(461),m3h2x8(:,695),heltab2x16(:,:,1091))
  call Hloop_A_Q(ntryL,G1H8(461),44,nMB,G2H8(13),n2h8(1015))
  call Hloop_QV_A(ntryL,G1H16(263),ex4(:),G1H8(477),m3h2x8(:,696),heltab2x16(:,:,1092))
  call Hloop_Q_A(ntryL,G1H8(477),44,nMB,G2H8(14),n2h8(1016))
  call Hloop_QV_A(ntryL,G1H16(266),ex3(:),G1H8(493),m3h2x8(:,697),heltab2x16(:,:,1093))
  call Hloop_Q_A(ntryL,G1H8(493),44,0,G2H8(15),n2h8(1017))
  call Hloop_QV_A(ntryL,G1H16(272),ex3(:),G1H8(525),m3h2x8(:,698),heltab2x16(:,:,1094))
  call Hloop_Q_A(ntryL,G1H8(525),44,nMT,G2H8(16),n2h8(1018))
  call Hloop_AV_Q(ntryL,G1H16(278),ex3(:),G1H8(541),m3h2x8(:,699),heltab2x16(:,:,1095))
  call Hloop_A_Q(ntryL,G1H8(541),44,0,G2H8(17),n2h8(1019))
  call Hloop_AV_Q(ntryL,G1H16(283),ex3(:),G1H8(557),m3h2x8(:,700),heltab2x16(:,:,1096))
  call Hloop_A_Q(ntryL,G1H8(557),44,nMT,G2H8(18),n2h8(1020))
  call Hloop_QV_A(ntryL,G1H16(287),ex3(:),G1H8(589),m3h2x8(:,701),heltab2x16(:,:,1097))
  call Hloop_Q_A(ntryL,G1H8(589),44,nMB,G2H8(19),n2h8(1021))
  call Hloop_AV_Q(ntryL,G1H16(293),ex3(:),G1H8(605),m3h2x8(:,702),heltab2x16(:,:,1098))
  call Hloop_A_Q(ntryL,G1H8(605),44,nMB,G2H8(20),n2h8(1022))
  call Hloop_QV_A(ntryL,G1H16(299),wf8(:,46),G1H2(1719),m3h8x2(:,245),heltab2x16(:,:,1099))
  call Hloop_Q_A(ntryL,G1H2(1719),55,0,G2H2(1804),n2h2(2298))
  call Hloop_QV_A(ntryL,G1H16(304),wf8(:,46),G1H2(1639),m3h8x2(:,246),heltab2x16(:,:,1100))
  call Hloop_Q_A(ntryL,G1H2(1639),55,nMT,G2H2(964),n2h2(2299))
  call Hloop_AV_Q(ntryL,G1H16(308),wf8(:,46),G1H2(1509),m3h8x2(:,247),heltab2x16(:,:,1101))
  call Hloop_A_Q(ntryL,G1H2(1509),55,0,G2H2(803),n2h2(2300))
  call Hloop_AV_Q(ntryL,G1H16(314),wf8(:,46),G1H2(1734),m3h8x2(:,248),heltab2x16(:,:,1102))
  call Hloop_A_Q(ntryL,G1H2(1734),55,nMT,G2H2(364),n2h2(2301))
  call Hloop_QV_A(ntryL,G1H16(320),wf8(:,46),G1H2(1644),m3h8x2(:,249),heltab2x16(:,:,1103))
  call Hloop_Q_A(ntryL,G1H2(1644),55,nMB,G2H2(304),n2h2(2302))
  call Hloop_AV_Q(ntryL,G1H16(326),wf8(:,46),G1H2(1514),m3h8x2(:,250),heltab2x16(:,:,1104))
  call Hloop_A_Q(ntryL,G1H2(1514),55,nMB,G2H2(143),n2h2(2303))
  call Hloop_QV_A(ntryL,G1H16(330),wf8(:,50),G1H2(1518),m3h8x2(:,251),heltab2x16(:,:,1105))
  call Hloop_Q_A(ntryL,G1H2(1518),47,0,G2H2(563),n2h2(2304))
  call Hloop_QV_A(ntryL,G1H16(336),wf8(:,50),G1H2(1523),m3h8x2(:,252),heltab2x16(:,:,1106))
  call Hloop_Q_A(ntryL,G1H2(1523),47,nMT,G2H2(148),n2h2(2305))
  call Hloop_AV_Q(ntryL,G1H16(342),wf8(:,50),G1H2(1528),m3h8x2(:,253),heltab2x16(:,:,1107))
  call Hloop_A_Q(ntryL,G1H2(1528),47,0,G2H2(567),n2h2(2306))
  call Hloop_AV_Q(ntryL,G1H16(348),wf8(:,50),G1H2(1533),m3h8x2(:,254),heltab2x16(:,:,1108))
  call Hloop_A_Q(ntryL,G1H2(1533),47,nMT,G2H2(153),n2h2(2307))
  call Hloop_QV_A(ntryL,G1H16(79),wf8(:,50),G1H2(1684),m3h8x2(:,255),heltab2x16(:,:,1109))
  call Hloop_Q_A(ntryL,G1H2(1684),47,nMB,G2H2(1864),n2h2(2308))
  call Hloop_AV_Q(ntryL,G1H16(319),wf8(:,50),G1H2(1534),m3h8x2(:,256),heltab2x16(:,:,1110))
  call Hloop_A_Q(ntryL,G1H2(1534),47,nMB,G2H2(1750),n2h2(2309))
  call Hloop_AV_Q(ntryL,G1H16(34),ex5(:),G1H8(95),m3h2x8(:,703),heltab2x16(:,:,1111))
  call Hloop_A_Q(ntryL,G1H8(95),50,0,G2H8(55),n2h8(1023))
  call Hloop_AV_Q(ntryL,G1H16(237),ex4(:),G1H8(27),m3h2x8(:,704),heltab2x16(:,:,1112))
  call Hloop_A_Q(ntryL,G1H8(27),42,0,G2H8(49),n2h8(1024))
  call Hloop_QV_A(ntryL,G1H16(62),wf8(:,52),G1H2(1689),m3h8x2(:,257),heltab2x16(:,:,1113))
  call Hloop_Q_A(ntryL,G1H2(1689),47,0,G2H2(1078),n2h2(2310))
  call Hloop_QV_A(ntryL,G1H16(54),wf8(:,52),G1H2(1538),m3h8x2(:,258),heltab2x16(:,:,1114))
  call Hloop_Q_A(ntryL,G1H2(1538),47,nMT,G2H2(819),n2h2(2311))
  call Hloop_AV_Q(ntryL,G1H16(115),wf8(:,52),G1H2(1744),m3h8x2(:,259),heltab2x16(:,:,1115))
  call Hloop_A_Q(ntryL,G1H2(1744),47,0,G2H2(332),n2h2(2312))
  call Hloop_AV_Q(ntryL,G1H16(145),wf8(:,52),G1H2(1694),m3h8x2(:,260),heltab2x16(:,:,1116))
  call Hloop_A_Q(ntryL,G1H2(1694),47,nMT,G2H2(308),n2h2(2313))
  call Hloop_QV_A(ntryL,G1H16(175),wf8(:,52),G1H2(1539),m3h8x2(:,261),heltab2x16(:,:,1117))
  call Hloop_Q_A(ntryL,G1H2(1539),47,nMB,G2H2(158),n2h2(2314))
  call Hloop_AV_Q(ntryL,G1H16(205),wf8(:,52),G1H2(1699),m3h8x2(:,262),heltab2x16(:,:,1118))
  call Hloop_A_Q(ntryL,G1H2(1699),47,nMB,G2H2(344),n2h2(2315))
  call Hloop_QV_A(ntryL,G1H16(235),ex5(:),G1H8(85),m3h2x8(:,705),heltab2x16(:,:,1119))
  call Hloop_Q_A(ntryL,G1H8(85),49,0,G2H8(30),n2h8(1025))
  call Hloop_QV_A(ntryL,G1H16(254),ex4(:),G1H8(262),m3h2x8(:,706),heltab2x16(:,:,1120))
  call Hloop_Q_A(ntryL,G1H8(262),41,0,G2H8(132),n2h8(1026))
  call Hloop_AV_Q(ntryL,G1H16(68),ex5(:),G1H8(69),m3h2x8(:,707),heltab2x16(:,:,1121))
  call Hloop_A_Q(ntryL,G1H8(69),52,0,G2H8(133),n2h8(1027))
  call Hloop_AV_Q(ntryL,G1H16(313),ex5(:),G1H8(316),m3h2x8(:,708),heltab2x16(:,:,1122))
  call Hloop_A_Q(ntryL,G1H8(316),52,nMT,G2H8(136),n2h8(1028))
  call Hloop_QV_A(ntryL,G1H16(85),ex5(:),G1H8(40),m3h2x8(:,709),heltab2x16(:,:,1123))
  call Hloop_Q_A(ntryL,G1H8(40),52,0,G2H8(137),n2h8(1029))
  call Hloop_QV_A(ntryL,G1H16(74),ex5(:),G1H8(335),m3h2x8(:,710),heltab2x16(:,:,1124))
  call Hloop_Q_A(ntryL,G1H8(335),52,nMT,G2H8(188),n2h8(1030))
  call Hloop_AV_Q(ntryL,G1H16(32),ex5(:),G1H8(81),m3h2x8(:,711),heltab2x16(:,:,1125))
  call Hloop_A_Q(ntryL,G1H8(81),52,nMB,G2H8(184),n2h8(1031))
  call Hloop_QV_A(ntryL,G1H16(38),ex5(:),G1H8(134),m3h2x8(:,712),heltab2x16(:,:,1126))
  call Hloop_Q_A(ntryL,G1H8(134),52,nMB,G2H8(191),n2h8(1032))
  call Hloop_QV_A(ntryL,G1H16(10),wf8(:,54),G1H2(1543),m3h8x2(:,263),heltab2x16(:,:,1127))
  call Hloop_Q_A(ntryL,G1H2(1543),47,0,G2H2(163),n2h2(2316))
  call Hloop_QV_A(ntryL,G1H16(87),wf8(:,54),G1H2(1754),m3h8x2(:,264),heltab2x16(:,:,1128))
  call Hloop_Q_A(ntryL,G1H2(1754),47,nMT,G2H2(274),n2h2(2317))
  call Hloop_AV_Q(ntryL,G1H16(7),wf8(:,54),G1H2(1704),m3h8x2(:,265),heltab2x16(:,:,1129))
  call Hloop_A_Q(ntryL,G1H2(1704),47,0,G2H2(571),n2h2(2318))
  call Hloop_AV_Q(ntryL,G1H16(39),wf8(:,54),G1H2(1544),m3h8x2(:,266),heltab2x16(:,:,1130))
  call Hloop_A_Q(ntryL,G1H2(1544),47,nMT,G2H2(166),n2h2(2319))
  call Hloop_QV_A(ntryL,G1H16(77),wf8(:,54),G1H2(1653),m3h8x2(:,267),heltab2x16(:,:,1131))
  call Hloop_Q_A(ntryL,G1H2(1653),47,nMB,G2H2(432),n2h2(2320))
  call Hloop_AV_Q(ntryL,G1H16(2),wf8(:,54),G1H2(1648),m3h8x2(:,268),heltab2x16(:,:,1132))
  call Hloop_A_Q(ntryL,G1H2(1648),47,nMB,G2H2(169),n2h2(2321))
  call Hloop_AV_Q(ntryL,G1H16(99),ex5(:),G1H8(100),m3h2x8(:,713),heltab2x16(:,:,1133))
  call Hloop_A_Q(ntryL,G1H8(100),50,0,G2H8(189),n2h8(1033))
  call Hloop_AV_Q(ntryL,G1H16(269),ex3(:),G1H8(105),m3h2x8(:,714),heltab2x16(:,:,1134))
  call Hloop_A_Q(ntryL,G1H8(105),38,0,G2H8(127),n2h8(1034))
  call Hloop_AV_Q(ntryL,G1H16(112),ex5(:),G1H8(153),m3h2x8(:,715),heltab2x16(:,:,1135))
  call Hloop_A_Q(ntryL,G1H8(153),52,0,G2H8(180),n2h8(1035))
  call Hloop_AV_Q(ntryL,G1H16(120),ex5(:),G1H8(127),m3h2x8(:,716),heltab2x16(:,:,1136))
  call Hloop_A_Q(ntryL,G1H8(127),52,nMT,G2H8(148),n2h8(1036))
  call Hloop_QV_A(ntryL,G1H16(63),ex5(:),G1H8(279),m3h2x8(:,717),heltab2x16(:,:,1137))
  call Hloop_Q_A(ntryL,G1H8(279),52,0,G2H8(181),n2h8(1037))
  call Hloop_QV_A(ntryL,G1H16(131),ex5(:),G1H8(108),m3h2x8(:,718),heltab2x16(:,:,1138))
  call Hloop_Q_A(ntryL,G1H8(108),52,nMT,G2H8(165),n2h8(1038))
  call Hloop_AV_Q(ntryL,G1H16(137),ex5(:),G1H8(6),m3h2x8(:,719),heltab2x16(:,:,1139))
  call Hloop_A_Q(ntryL,G1H8(6),52,nMB,G2H8(183),n2h8(1039))
  call Hloop_QV_A(ntryL,G1H16(146),ex5(:),G1H8(9),m3h2x8(:,720),heltab2x16(:,:,1140))
  call Hloop_Q_A(ntryL,G1H8(9),52,nMB,G2H8(182),n2h8(1040))
  call Hloop_QV_A(ntryL,G1H16(73),wf8(:,56),G1H2(1663),m3h8x2(:,269),heltab2x16(:,:,1141))
  call Hloop_Q_A(ntryL,G1H2(1663),47,0,G2H2(19),n2h2(2322))
  call Hloop_QV_A(ntryL,G1H16(156),wf8(:,56),G1H2(1658),m3h8x2(:,270),heltab2x16(:,:,1142))
  call Hloop_Q_A(ntryL,G1H2(1658),47,nMT,G2H2(577),n2h2(2323))
  call Hloop_AV_Q(ntryL,G1H16(162),wf8(:,56),G1H2(1673),m3h8x2(:,271),heltab2x16(:,:,1143))
  call Hloop_A_Q(ntryL,G1H2(1673),47,0,G2H2(172),n2h2(2324))
  call Hloop_AV_Q(ntryL,G1H16(171),wf8(:,56),G1H2(1668),m3h8x2(:,272),heltab2x16(:,:,1144))
  call Hloop_A_Q(ntryL,G1H2(1668),47,nMT,G2H2(476),n2h2(2325))
  call Hloop_QV_A(ntryL,G1H16(178),wf8(:,56),G1H2(1683),m3h8x2(:,273),heltab2x16(:,:,1145))
  call Hloop_Q_A(ntryL,G1H2(1683),47,nMB,G2H2(448),n2h2(2326))
  call Hloop_AV_Q(ntryL,G1H16(184),wf8(:,56),G1H2(1678),m3h8x2(:,274),heltab2x16(:,:,1146))
  call Hloop_A_Q(ntryL,G1H2(1678),47,nMB,G2H2(205),n2h2(2327))
  call Hloop_QV_A(ntryL,G1H16(190),ex5(:),G1H8(39),m3h2x8(:,721),heltab2x16(:,:,1147))
  call Hloop_Q_A(ntryL,G1H8(39),49,0,G2H8(186),n2h8(1041))
  call Hloop_QV_A(ntryL,G1H16(89),ex3(:),G1H8(78),m3h2x8(:,722),heltab2x16(:,:,1148))
  call Hloop_Q_A(ntryL,G1H8(78),37,0,G2H8(198),n2h8(1042))
  call Hloop_AV_Q(ntryL,G1H16(204),ex4(:),G1H8(120),m3h2x8(:,723),heltab2x16(:,:,1149))
  call Hloop_A_Q(ntryL,G1H8(120),44,0,G2H8(202),n2h8(1043))
  call Hloop_AV_Q(ntryL,G1H16(210),ex4(:),G1H8(142),m3h2x8(:,724),heltab2x16(:,:,1150))
  call Hloop_A_Q(ntryL,G1H8(142),44,nMT,G2H8(96),n2h8(1044))
  call Hloop_QV_A(ntryL,G1H16(216),ex4(:),G1H8(166),m3h2x8(:,725),heltab2x16(:,:,1151))
  call Hloop_Q_A(ntryL,G1H8(166),44,0,G2H8(93),n2h8(1045))
  call Hloop_QV_A(ntryL,G1H16(222),ex4(:),G1H8(215),m3h2x8(:,726),heltab2x16(:,:,1152))
  call Hloop_Q_A(ntryL,G1H8(215),44,nMT,G2H8(4),n2h8(1046))
  call Hloop_AV_Q(ntryL,G1H16(230),ex4(:),G1H8(232),m3h2x8(:,727),heltab2x16(:,:,1153))
  call Hloop_A_Q(ntryL,G1H8(232),44,nMB,G2H8(12),n2h8(1047))
  call Hloop_QV_A(ntryL,G1H16(118),ex4(:),G1H8(256),m3h2x8(:,728),heltab2x16(:,:,1154))
  call Hloop_Q_A(ntryL,G1H8(256),44,nMB,G2H8(41),n2h8(1048))
  call Hloop_QV_A(ntryL,G1H16(149),ex3(:),G1H8(382),m3h2x8(:,729),heltab2x16(:,:,1155))
  call Hloop_Q_A(ntryL,G1H8(382),44,0,G2H8(47),n2h8(1049))
  call Hloop_QV_A(ntryL,G1H16(352),ex3(:),G1H8(321),m3h2x8(:,730),heltab2x16(:,:,1156))
  call Hloop_Q_A(ntryL,G1H8(321),44,nMT,G2H8(10),n2h8(1050))
  call Hloop_AV_Q(ntryL,G1H16(357),ex3(:),G1H8(102),m3h2x8(:,731),heltab2x16(:,:,1157))
  call Hloop_A_Q(ntryL,G1H8(102),44,0,G2H8(99),n2h8(1051))
  call Hloop_AV_Q(ntryL,G1H16(362),ex3(:),G1H8(353),m3h2x8(:,732),heltab2x16(:,:,1158))
  call Hloop_A_Q(ntryL,G1H8(353),44,nMT,G2H8(103),n2h8(1052))
  call Hloop_QV_A(ntryL,G1H16(367),ex3(:),G1H8(121),m3h2x8(:,733),heltab2x16(:,:,1159))
  call Hloop_Q_A(ntryL,G1H8(121),44,nMB,G2H8(104),n2h8(1053))
  call Hloop_AV_Q(ntryL,G1H16(372),ex3(:),G1H8(131),m3h2x8(:,734),heltab2x16(:,:,1160))
  call Hloop_A_Q(ntryL,G1H8(131),44,nMB,G2H8(106),n2h8(1054))
  call Hloop_QV_A(ntryL,G1H16(377),wf8(:,57),G1H2(1693),m3h8x2(:,275),heltab2x16(:,:,1161))
  call Hloop_Q_A(ntryL,G1H2(1693),55,0,G2H2(175),n2h2(2328))
  call Hloop_QV_A(ntryL,G1H16(382),wf8(:,57),G1H2(1688),m3h8x2(:,276),heltab2x16(:,:,1162))
  call Hloop_Q_A(ntryL,G1H2(1688),55,nMT,G2H2(26),n2h2(2329))
  call Hloop_AV_Q(ntryL,G1H16(387),wf8(:,57),G1H2(1703),m3h8x2(:,277),heltab2x16(:,:,1163))
  call Hloop_A_Q(ntryL,G1H2(1703),55,0,G2H2(703),n2h2(2330))
  call Hloop_AV_Q(ntryL,G1H16(392),wf8(:,57),G1H2(1698),m3h8x2(:,278),heltab2x16(:,:,1164))
  call Hloop_A_Q(ntryL,G1H2(1698),55,nMT,G2H2(583),n2h2(2331))
  call Hloop_QV_A(ntryL,G1H16(397),wf8(:,57),G1H2(226),m3h8x2(:,279),heltab2x16(:,:,1165))
  call Hloop_Q_A(ntryL,G1H2(226),55,nMB,G2H2(206),n2h2(2332))
  call Hloop_AV_Q(ntryL,G1H16(402),wf8(:,57),G1H2(227),m3h8x2(:,280),heltab2x16(:,:,1166))
  call Hloop_A_Q(ntryL,G1H2(227),55,nMB,G2H2(178),n2h2(2333))
  call Hloop_AV_Q(ntryL,G1H16(301),ex4(:),G1H8(372),m3h2x8(:,735),heltab2x16(:,:,1167))
  call Hloop_A_Q(ntryL,G1H8(372),42,0,G2H8(107),n2h8(1055))
  call Hloop_AV_Q(ntryL,G1H16(96),ex3(:),G1H8(336),m3h2x8(:,736),heltab2x16(:,:,1168))
  call Hloop_A_Q(ntryL,G1H8(336),38,0,G2H8(109),n2h8(1056))
  call Hloop_AV_Q(ntryL,G1H16(415),ex4(:),G1H8(342),m3h2x8(:,737),heltab2x16(:,:,1169))
  call Hloop_A_Q(ntryL,G1H8(342),44,0,G2H8(110),n2h8(1057))
  call Hloop_AV_Q(ntryL,G1H16(420),ex4(:),G1H8(276),m3h2x8(:,738),heltab2x16(:,:,1170))
  call Hloop_A_Q(ntryL,G1H8(276),44,nMT,G2H8(112),n2h8(1058))
  call Hloop_QV_A(ntryL,G1H16(425),ex4(:),G1H8(144),m3h2x8(:,739),heltab2x16(:,:,1171))
  call Hloop_Q_A(ntryL,G1H8(144),44,0,G2H8(113),n2h8(1059))
  call Hloop_QV_A(ntryL,G1H16(430),ex4(:),G1H8(395),m3h2x8(:,740),heltab2x16(:,:,1172))
  call Hloop_Q_A(ntryL,G1H8(395),44,nMT,G2H8(115),n2h8(1060))
  call Hloop_AV_Q(ntryL,G1H16(435),ex4(:),G1H8(152),m3h2x8(:,741),heltab2x16(:,:,1173))
  call Hloop_A_Q(ntryL,G1H8(152),44,nMB,G2H8(116),n2h8(1061))
  call Hloop_QV_A(ntryL,G1H16(440),ex4(:),G1H8(241),m3h2x8(:,742),heltab2x16(:,:,1174))
  call Hloop_Q_A(ntryL,G1H8(241),44,nMB,G2H8(118),n2h8(1062))
  call Hloop_QV_A(ntryL,G1H16(445),ex3(:),G1H8(176),m3h2x8(:,743),heltab2x16(:,:,1175))
  call Hloop_Q_A(ntryL,G1H8(176),44,0,G2H8(119),n2h8(1063))
  call Hloop_QV_A(ntryL,G1H16(450),ex3(:),G1H8(187),m3h2x8(:,744),heltab2x16(:,:,1176))
  call Hloop_Q_A(ntryL,G1H8(187),44,nMT,G2H8(122),n2h8(1064))
  call Hloop_AV_Q(ntryL,G1H16(455),ex3(:),G1H8(365),m3h2x8(:,745),heltab2x16(:,:,1177))
  call Hloop_A_Q(ntryL,G1H8(365),44,0,G2H8(126),n2h8(1065))
  call Hloop_AV_Q(ntryL,G1H16(460),ex3(:),G1H8(203),m3h2x8(:,746),heltab2x16(:,:,1178))
  call Hloop_A_Q(ntryL,G1H8(203),44,nMT,G2H8(131),n2h8(1066))
  call Hloop_QV_A(ntryL,G1H16(465),ex3(:),G1H8(212),m3h2x8(:,747),heltab2x16(:,:,1179))
  call Hloop_Q_A(ntryL,G1H8(212),44,nMB,G2H8(197),n2h8(1067))
  call Hloop_AV_Q(ntryL,G1H16(470),ex3(:),G1H8(236),m3h2x8(:,748),heltab2x16(:,:,1180))
  call Hloop_A_Q(ntryL,G1H8(236),44,nMB,G2H8(161),n2h8(1068))
  call Hloop_QV_A(ntryL,G1H16(475),wf8(:,58),G1H2(232),m3h8x2(:,281),heltab2x16(:,:,1181))
  call Hloop_Q_A(ntryL,G1H2(232),55,0,G2H2(508),n2h2(2334))
  call Hloop_QV_A(ntryL,G1H16(480),wf8(:,58),G1H2(233),m3h8x2(:,282),heltab2x16(:,:,1182))
  call Hloop_Q_A(ntryL,G1H2(233),55,nMT,G2H2(372),n2h2(2335))
  call Hloop_AV_Q(ntryL,G1H16(485),wf8(:,58),G1H2(1756),m3h8x2(:,283),heltab2x16(:,:,1183))
  call Hloop_A_Q(ntryL,G1H2(1756),55,0,G2H2(340),n2h2(2336))
  call Hloop_AV_Q(ntryL,G1H16(490),wf8(:,58),G1H2(1757),m3h8x2(:,284),heltab2x16(:,:,1184))
  call Hloop_A_Q(ntryL,G1H2(1757),55,nMT,G2H2(187),n2h2(2337))
  call Hloop_QV_A(ntryL,G1H16(495),wf8(:,58),G1H2(1762),m3h8x2(:,285),heltab2x16(:,:,1185))
  call Hloop_Q_A(ntryL,G1H2(1762),55,nMB,G2H2(181),n2h2(2338))
  call Hloop_AV_Q(ntryL,G1H16(500),wf8(:,58),G1H2(1763),m3h8x2(:,286),heltab2x16(:,:,1186))
  call Hloop_A_Q(ntryL,G1H2(1763),55,nMB,G2H2(513),n2h2(2339))
  call Hloop_QV_A(ntryL,G1H16(302),ex4(:),G1H8(394),m3h2x8(:,749),heltab2x16(:,:,1187))
  call Hloop_Q_A(ntryL,G1H8(394),41,0,G2H8(195),n2h8(1069))
  call Hloop_QV_A(ntryL,G1H16(305),ex3(:),G1H8(400),m3h2x8(:,750),heltab2x16(:,:,1188))
  call Hloop_Q_A(ntryL,G1H8(400),37,0,G2H8(193),n2h8(1070))
  call Hloop_VQ_A(ntryL,G1H16(233),wf4(:,4),G1H4(244),m3h4x4(:,153),heltab2x16(:,:,1189))
  call Hloop_Q_A(ntryL,G1H4(244),53,0,G2H4(329),n2h4(1639))
  call Hloop_VA_Q(ntryL,G1H16(67),ex2(:),G1H8(265),m3h2x8(:,751),heltab2x16(:,:,1190))
  call Hloop_A_Q(ntryL,G1H8(265),50,0,G2H8(174),n2h8(1071))
  call Hloop_VA_Q(ntryL,G1H16(252),wf4(:,13),G1H4(966),m3h4x4(:,154),heltab2x16(:,:,1191))
  call Hloop_A_Q(ntryL,G1H4(966),54,0,G2H4(333),n2h4(1640))
  call Hloop_VQ_A(ntryL,G1H16(267),ex1(:),G1H8(296),m3h2x8(:,752),heltab2x16(:,:,1192))
  call Hloop_Q_A(ntryL,G1H8(296),49,0,G2H8(201),n2h8(1072))
  call Hloop_VA_Q(ntryL,G1H16(284),ex2(:),G1H8(301),m3h2x8(:,753),heltab2x16(:,:,1193))
  call Hloop_A_Q(ntryL,G1H8(301),50,0,G2H8(194),n2h8(1073))
  call Hloop_VQ_A(ntryL,G1H16(300),ex1(:),G1H8(308),m3h2x8(:,754),heltab2x16(:,:,1194))
  call Hloop_Q_A(ntryL,G1H8(308),49,0,G2H8(196),n2h8(1074))
  call Hloop_AQ_V(ntryL,G1H16(232),wf4(:,4),G1H4(262),m3h4x4(:,155),heltab2x16(:,:,1195))
  call Hloop_QA_V(ntryL,G1H32(1),wf4(:,5),G1H8(155),m3h4x8(:,67),heltab2x32(:,:,375))
  call Hloop_VA_Q(ntryL,G1H32(9),wf4(:,5),G1H8(156),m3h4x8(:,68),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G1H8(156),42,0,G2H8(210),n2h8(1075))
  call Hloop_VA_Q(ntryL,G0H8(11),wf4(:,5),G0H2(1),m3h4x2(:,531),heltab2x8(:,:,1973))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1766),n2h2(2340))
  call Hloop_QA_V(ntryL,G1H8(132),wf4(:,5),G1H2(1767),m3h4x2(:,532),heltab2x8(:,:,1974))
  call Hloop_AQ_V(ntryL,G1H32(33),wf4(:,4),G1H8(209),m3h4x8(:,69),heltab2x32(:,:,377))
  call Hloop_VQ_A(ntryL,G1H32(41),wf4(:,4),G1H8(318),m3h4x8(:,70),heltab2x32(:,:,378))
  call Hloop_Q_A(ntryL,G1H8(318),37,0,G2H8(121),n2h8(1076))
  call Hloop_VQ_A(ntryL,G0H8(55),wf4(:,4),G0H2(1),m3h4x2(:,533),heltab2x8(:,:,1975))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(1772),n2h2(2341))
  call Hloop_AQ_V(ntryL,G1H8(82),wf4(:,4),G1H2(1773),m3h4x2(:,534),heltab2x8(:,:,1976))
  call Hloop_AV_Q(ntryL,G1H32(24),wf16(:,1),G1H2(1776),m3h16x2(:,1),heltab2x32(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(1776),47,0,G2H2(793),n2h2(2342))
  call Hloop_AV_Q(ntryL,G1H32(73),wf16(:,1),G1H2(1777),m3h16x2(:,2),heltab2x32(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(1777),47,nMT,G2H2(396),n2h2(2343))
  call Hloop_QV_A(ntryL,G1H32(34),wf16(:,1),G1H2(1782),m3h16x2(:,3),heltab2x32(:,:,381))
  call Hloop_Q_A(ntryL,G1H2(1782),47,0,G2H2(348),n2h2(2344))
  call Hloop_QV_A(ntryL,G1H32(16),wf16(:,1),G1H2(1783),m3h16x2(:,4),heltab2x32(:,:,382))
  call Hloop_Q_A(ntryL,G1H2(1783),47,nMT,G2H2(191),n2h2(2345))
  call Hloop_AV_Q(ntryL,G1H32(26),wf16(:,1),G1H2(1786),m3h16x2(:,5),heltab2x32(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(1786),47,nMB,G2H2(182),n2h2(2346))
  call Hloop_QV_A(ntryL,G1H32(36),wf16(:,1),G1H2(2109),m3h16x2(:,6),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(2109),47,nMB,G2H2(416),n2h2(2347))
  call Hloop_DV_C(ntryL,G1H32(68),32,wf16(:,1),G2H2(183),m3h16x2(:,7),heltab2x32(:,:,385))
  call Hloop_CV_D(ntryL,G1H32(72),32,wf16(:,1),15,G2H2(280),m3h16x2(:,8),heltab2x32(:,:,386))
  call Hloop_UV_W(ntryL,G1H32(80),32,wf16(:,1),15,G2H2(601),m3h16x2(:,9),heltab2x32(:,:,387))
  call Hloop_AQ_V(ntryL,G1H32(82),wf8(:,9),G1H4(837),m3h8x4(:,45),heltab2x32(:,:,388))
  call Hloop_VQ_A(ntryL,G1H32(90),wf8(:,9),G1H4(345),m3h8x4(:,46),heltab2x32(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(345),45,0,G2H4(334),n2h4(1641))
  call Hloop_AQ_V(ntryL,G1H32(92),wf4(:,4),G1H8(8),m3h4x8(:,71),heltab2x32(:,:,390))
  call Hloop_VQ_A(ntryL,G1H32(112),wf4(:,4),G1H8(14),m3h4x8(:,72),heltab2x32(:,:,391))
  call Hloop_Q_A(ntryL,G1H8(14),37,0,G2H8(123),n2h8(1077))
  call Hloop_VQ_A(ntryL,G0H8(58),wf4(:,4),G0H2(1),m3h4x2(:,535),heltab2x8(:,:,1977))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(1787),n2h2(2348))
  call Hloop_QV_A(ntryL,G1H32(130),ex4(:),G1H16(306),m3h2x16(:,265),heltab2x32(:,:,392))
  call Hloop_Q_A(ntryL,G1H16(306),40,0,G2H16(91),n2h16(495))
  call Hloop_QV_A(ntryL,G1H32(120),ex4(:),G1H16(66),m3h2x16(:,266),heltab2x32(:,:,393))
  call Hloop_Q_A(ntryL,G1H16(66),40,nMT,G2H16(92),n2h16(496))
  call Hloop_AV_Q(ntryL,G1H32(150),ex4(:),G1H16(71),m3h2x16(:,267),heltab2x32(:,:,394))
  call Hloop_A_Q(ntryL,G1H16(71),40,0,G2H16(93),n2h16(497))
  call Hloop_AV_Q(ntryL,G1H32(128),ex4(:),G1H16(309),m3h2x16(:,268),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G1H16(309),40,nMT,G2H16(94),n2h16(498))
  call Hloop_QV_A(ntryL,G1H32(148),ex4(:),G1H16(310),m3h2x16(:,269),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G1H16(310),40,nMB,G2H16(95),n2h16(499))
  call Hloop_AV_Q(ntryL,G1H32(156),ex4(:),G1H16(311),m3h2x16(:,270),heltab2x32(:,:,397))
  call Hloop_A_Q(ntryL,G1H16(311),40,nMB,G2H16(96),n2h16(500))
  call Hloop_VQ_A(ntryL,G0H16(20),wf8(:,9),G0H2(1),m3h8x2(:,287),heltab2x16(:,:,1196))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(1792),n2h2(2349))
  call Hloop_AQ_V(ntryL,G1H16(234),wf8(:,9),G1H2(2115),m3h8x2(:,288),heltab2x16(:,:,1197))
  call Hloop_QV_A(ntryL,G1H16(244),wf8(:,50),G1H2(1793),m3h8x2(:,289),heltab2x16(:,:,1198))
  call Hloop_Q_A(ntryL,G1H2(1793),55,0,G2H2(184),n2h2(2350))
  call Hloop_QV_A(ntryL,G1H16(239),wf8(:,50),G1H2(1796),m3h8x2(:,290),heltab2x16(:,:,1199))
  call Hloop_Q_A(ntryL,G1H2(1796),55,nMT,G2H2(376),n2h2(2351))
  call Hloop_AV_Q(ntryL,G1H16(246),wf8(:,50),G1H2(2100),m3h8x2(:,291),heltab2x16(:,:,1200))
  call Hloop_A_Q(ntryL,G1H2(2100),55,0,G2H2(185),n2h2(2352))
  call Hloop_AV_Q(ntryL,G1H16(243),wf8(:,50),G1H2(1797),m3h8x2(:,292),heltab2x16(:,:,1201))
  call Hloop_A_Q(ntryL,G1H2(1797),55,nMT,G2H2(14),n2h2(2353))
  call Hloop_QV_A(ntryL,G1H16(245),wf8(:,50),G1H2(1802),m3h8x2(:,293),heltab2x16(:,:,1202))
  call Hloop_Q_A(ntryL,G1H2(1802),55,nMB,G2H2(607),n2h2(2354))
  call Hloop_AV_Q(ntryL,G1H16(249),wf8(:,50),G1H2(2106),m3h8x2(:,294),heltab2x16(:,:,1203))
  call Hloop_A_Q(ntryL,G1H2(2106),55,nMB,G2H2(186),n2h2(2355))
  call Hloop_QA_V(ntryL,G1H16(250),ex2(:),G1H8(36),m3h2x8(:,755),heltab2x16(:,:,1204))
  call Hloop_VA_Q(ntryL,G0H4(104),ex2(:),G0H2(1),m3h2x2(:,2282),heltab2x4(:,:,2612))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(1803),n2h2(2356))
  call Hloop_QV_A(ntryL,G1H32(183),ex4(:),G1H16(312),m3h2x16(:,271),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G1H16(312),40,0,G2H16(97),n2h16(501))
  call Hloop_QV_A(ntryL,G1H32(164),ex4(:),G1H16(315),m3h2x16(:,272),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G1H16(315),40,nMT,G2H16(98),n2h16(502))
  call Hloop_AV_Q(ntryL,G1H32(191),ex4(:),G1H16(316),m3h2x16(:,273),heltab2x32(:,:,400))
  call Hloop_A_Q(ntryL,G1H16(316),40,0,G2H16(99),n2h16(503))
  call Hloop_AV_Q(ntryL,G1H32(181),ex4(:),G1H16(317),m3h2x16(:,274),heltab2x32(:,:,401))
  call Hloop_A_Q(ntryL,G1H16(317),40,nMT,G2H16(100),n2h16(504))
  call Hloop_QV_A(ntryL,G1H32(189),ex4(:),G1H16(318),m3h2x16(:,275),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G1H16(318),40,nMB,G2H16(101),n2h16(505))
  call Hloop_AV_Q(ntryL,G1H32(197),ex4(:),G1H16(321),m3h2x16(:,276),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G1H16(321),40,nMB,G2H16(102),n2h16(506))
  call Hloop_AV_Q(ntryL,G1H32(221),wf16(:,22),G1H2(1806),m3h16x2(:,10),heltab2x32(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(1806),47,0,G2H2(560),n2h2(2357))
  call Hloop_AV_Q(ntryL,G1H32(211),wf16(:,22),G1H2(2129),m3h16x2(:,11),heltab2x32(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(2129),47,nMT,G2H2(806),n2h2(2358))
  call Hloop_QV_A(ntryL,G1H32(229),wf16(:,22),G1H2(1807),m3h16x2(:,12),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(1807),47,0,G2H2(404),n2h2(2359))
  call Hloop_QV_A(ntryL,G1H32(219),wf16(:,22),G1H2(1812),m3h16x2(:,13),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(1812),47,nMT,G2H2(380),n2h2(2360))
  call Hloop_AV_Q(ntryL,G1H32(227),wf16(:,22),G1H2(2135),m3h16x2(:,14),heltab2x32(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(2135),47,nMB,G2H2(192),n2h2(2361))
  call Hloop_QV_A(ntryL,G1H32(17),wf16(:,22),G1H2(1813),m3h16x2(:,15),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(1813),47,nMB,G2H2(188),n2h2(2362))
  call Hloop_DV_C(ntryL,G1H32(3),32,wf16(:,22),G2H2(468),m3h16x2(:,16),heltab2x32(:,:,410))
  call Hloop_CV_D(ntryL,G1H32(25),32,wf16(:,22),15,G2H2(400),m3h16x2(:,17),heltab2x32(:,:,411))
  call Hloop_UV_W(ntryL,G1H32(11),32,wf16(:,22),15,G2H2(209),m3h16x2(:,18),heltab2x32(:,:,412))
  call Hloop_QA_V(ntryL,G1H32(19),ex2(:),G1H16(322),m3h2x16(:,277),heltab2x32(:,:,413))
  call Hloop_VA_Q(ntryL,G1H32(27),ex2(:),G1H16(323),m3h2x16(:,278),heltab2x32(:,:,414))
  call Hloop_A_Q(ntryL,G1H16(323),34,0,G2H16(103),n2h16(507))
  call Hloop_VA_Q(ntryL,G0H4(80),ex2(:),G0H2(1),m3h2x2(:,2283),heltab2x4(:,:,2613))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1816),n2h2(2363))
  call Hloop_QA_V(ntryL,G1H4(317),ex2(:),G1H2(2119),m3h2x2(:,2284),heltab2x4(:,:,2614))
  call Hloop_QV_A(ntryL,G1H32(51),ex4(:),G1H16(324),m3h2x16(:,279),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G1H16(324),40,0,G2H16(104),n2h16(508))
  call Hloop_QV_A(ntryL,G1H32(35),ex4(:),G1H16(327),m3h2x16(:,280),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G1H16(327),40,nMT,G2H16(105),n2h16(509))
  call Hloop_AV_Q(ntryL,G1H32(81),ex4(:),G1H16(328),m3h2x16(:,281),heltab2x32(:,:,417))
  call Hloop_A_Q(ntryL,G1H16(328),40,0,G2H16(106),n2h16(510))
  call Hloop_AV_Q(ntryL,G1H32(43),ex4(:),G1H16(20),m3h2x16(:,282),heltab2x32(:,:,418))
  call Hloop_A_Q(ntryL,G1H16(20),40,nMT,G2H16(107),n2h16(511))
  call Hloop_QV_A(ntryL,G1H32(59),ex4(:),G1H16(18),m3h2x16(:,283),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G1H16(18),40,nMB,G2H16(108),n2h16(512))
  call Hloop_AV_Q(ntryL,G1H32(67),ex4(:),G1H16(331),m3h2x16(:,284),heltab2x32(:,:,420))
  call Hloop_A_Q(ntryL,G1H16(331),40,nMB,G2H16(109),n2h16(513))
  call Hloop_QA_V(ntryL,G1H32(89),ex2(:),G1H16(332),m3h2x16(:,285),heltab2x32(:,:,421))
  call Hloop_VA_Q(ntryL,G1H32(75),ex2(:),G1H16(333),m3h2x16(:,286),heltab2x32(:,:,422))
  call Hloop_A_Q(ntryL,G1H16(333),34,0,G2H16(110),n2h16(514))
  call Hloop_QA_V(ntryL,G1H16(69),wf4(:,13),G1H4(842),m3h4x4(:,156),heltab2x16(:,:,1205))
  call Hloop_QA_V(ntryL,G1H32(83),wf4(:,13),G1H8(37),m3h4x8(:,73),heltab2x32(:,:,423))
  call Hloop_VA_Q(ntryL,G1H32(91),wf4(:,13),G1H8(44),m3h4x8(:,74),heltab2x32(:,:,424))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(125),n2h8(1078))
  call Hloop_VA_Q(ntryL,G0H8(17),wf4(:,13),G0H2(1),m3h4x2(:,536),heltab2x8(:,:,1978))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1817),n2h2(2364))
  call Hloop_QA_V(ntryL,G1H8(123),wf4(:,13),G1H2(1822),m3h4x2(:,537),heltab2x8(:,:,1979))
  call Hloop_AQ_V(ntryL,G1H32(5),wf4(:,12),G1H8(47),m3h4x8(:,75),heltab2x32(:,:,425))
  call Hloop_VQ_A(ntryL,G1H32(2),wf4(:,12),G1H8(403),m3h4x8(:,76),heltab2x32(:,:,426))
  call Hloop_Q_A(ntryL,G1H8(403),41,0,G2H8(128),n2h8(1079))
  call Hloop_VQ_A(ntryL,G0H8(29),wf4(:,12),G0H2(1),m3h4x2(:,538),heltab2x8(:,:,1980))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(2125),n2h2(2365))
  call Hloop_AQ_V(ntryL,G1H8(237),wf4(:,12),G1H2(1823),m3h4x2(:,539),heltab2x8(:,:,1981))
  call Hloop_AV_Q(ntryL,G1H32(13),wf16(:,2),G1H2(1826),m3h16x2(:,19),heltab2x32(:,:,427))
  call Hloop_A_Q(ntryL,G1H2(1826),47,0,G2H2(189),n2h2(2366))
  call Hloop_AV_Q(ntryL,G1H32(4),wf16(:,2),G1H2(1827),m3h16x2(:,20),heltab2x32(:,:,428))
  call Hloop_A_Q(ntryL,G1H2(1827),47,nMT,G2H2(24),n2h2(2367))
  call Hloop_QV_A(ntryL,G1H32(15),wf16(:,2),G1H2(1832),m3h16x2(:,21),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(1832),47,0,G2H2(715),n2h2(2368))
  call Hloop_QV_A(ntryL,G1H32(8),wf16(:,2),G1H2(1833),m3h16x2(:,22),heltab2x32(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(1833),47,nMT,G2H2(625),n2h2(2369))
  call Hloop_AV_Q(ntryL,G1H32(10),wf16(:,2),G1H2(1836),m3h16x2(:,23),heltab2x32(:,:,431))
  call Hloop_A_Q(ntryL,G1H2(1836),47,nMB,G2H2(210),n2h2(2370))
  call Hloop_QV_A(ntryL,G1H32(18),wf16(:,2),G1H2(1837),m3h16x2(:,24),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(1837),47,nMB,G2H2(190),n2h2(2371))
  call Hloop_DV_C(ntryL,G1H32(14),32,wf16(:,2),G2H2(643),m3h16x2(:,25),heltab2x32(:,:,433))
  call Hloop_CV_D(ntryL,G1H32(20),32,wf16(:,2),15,G2H2(197),m3h16x2(:,26),heltab2x32(:,:,434))
  call Hloop_UV_W(ntryL,G1H32(21),32,wf16(:,2),15,G2H2(193),m3h16x2(:,27),heltab2x32(:,:,435))
  call Hloop_QA_V(ntryL,G1H32(23),wf4(:,13),G1H8(404),m3h4x8(:,77),heltab2x32(:,:,436))
  call Hloop_VA_Q(ntryL,G1H32(22),wf4(:,13),G1H8(408),m3h4x8(:,78),heltab2x32(:,:,437))
  call Hloop_A_Q(ntryL,G1H8(408),38,0,G2H8(138),n2h8(1080))
  call Hloop_VA_Q(ntryL,G0H8(22),wf4(:,13),G0H2(1),m3h4x2(:,540),heltab2x8(:,:,1982))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(1842),n2h2(2372))
  call Hloop_QA_V(ntryL,G1H32(28),wf8(:,27),G1H4(346),m3h8x4(:,47),heltab2x32(:,:,438))
  call Hloop_VA_Q(ntryL,G1H32(29),wf8(:,27),G1H4(1032),m3h8x4(:,48),heltab2x32(:,:,439))
  call Hloop_A_Q(ntryL,G1H4(1032),46,0,G2H4(338),n2h4(1642))
  call Hloop_QV_A(ntryL,G1H32(40),ex4(:),G1H16(334),m3h2x16(:,287),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G1H16(334),40,0,G2H16(111),n2h16(515))
  call Hloop_QV_A(ntryL,G1H32(31),ex4(:),G1H16(337),m3h2x16(:,288),heltab2x32(:,:,441))
  call Hloop_Q_A(ntryL,G1H16(337),40,nMT,G2H16(112),n2h16(516))
  call Hloop_AV_Q(ntryL,G1H32(42),ex4(:),G1H16(338),m3h2x16(:,289),heltab2x32(:,:,442))
  call Hloop_A_Q(ntryL,G1H16(338),40,0,G2H16(113),n2h16(517))
  call Hloop_AV_Q(ntryL,G1H32(37),ex4(:),G1H16(339),m3h2x16(:,290),heltab2x32(:,:,443))
  call Hloop_A_Q(ntryL,G1H16(339),40,nMT,G2H16(114),n2h16(518))
  call Hloop_QV_A(ntryL,G1H32(39),ex4(:),G1H16(340),m3h2x16(:,291),heltab2x32(:,:,444))
  call Hloop_Q_A(ntryL,G1H16(340),40,nMB,G2H16(115),n2h16(519))
  call Hloop_AV_Q(ntryL,G1H32(38),ex4(:),G1H16(343),m3h2x16(:,292),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G1H16(343),40,nMB,G2H16(116),n2h16(520))
  call Hloop_VA_Q(ntryL,G0H16(33),wf8(:,27),G0H2(1),m3h8x2(:,295),heltab2x16(:,:,1206))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1843),n2h2(2373))
  call Hloop_QA_V(ntryL,G1H16(253),wf8(:,27),G1H2(1846),m3h8x2(:,296),heltab2x16(:,:,1207))
  call Hloop_QV_A(ntryL,G1H16(261),wf8(:,52),G1H2(1847),m3h8x2(:,297),heltab2x16(:,:,1208))
  call Hloop_Q_A(ntryL,G1H2(1847),55,0,G2H2(522),n2h2(2374))
  call Hloop_QV_A(ntryL,G1H16(258),wf8(:,52),G1H2(1852),m3h8x2(:,298),heltab2x16(:,:,1209))
  call Hloop_Q_A(ntryL,G1H2(1852),55,nMT,G2H2(428),n2h2(2375))
  call Hloop_AV_Q(ntryL,G1H16(265),wf8(:,52),G1H2(1853),m3h8x2(:,299),heltab2x16(:,:,1210))
  call Hloop_A_Q(ntryL,G1H2(1853),55,0,G2H2(412),n2h2(2376))
  call Hloop_AV_Q(ntryL,G1H16(260),wf8(:,52),G1H2(1856),m3h8x2(:,300),heltab2x16(:,:,1211))
  call Hloop_A_Q(ntryL,G1H2(1856),55,nMT,G2H2(198),n2h2(2377))
  call Hloop_QV_A(ntryL,G1H16(264),wf8(:,52),G1H2(1857),m3h8x2(:,301),heltab2x16(:,:,1212))
  call Hloop_Q_A(ntryL,G1H2(1857),55,nMB,G2H2(194),n2h2(2378))
  call Hloop_AV_Q(ntryL,G1H16(75),wf8(:,52),G1H2(1862),m3h8x2(:,302),heltab2x16(:,:,1213))
  call Hloop_A_Q(ntryL,G1H2(1862),55,nMB,G2H2(653),n2h2(2379))
  call Hloop_AQ_V(ntryL,G1H16(78),ex1(:),G1H8(409),m3h2x8(:,756),heltab2x16(:,:,1214))
  call Hloop_VQ_A(ntryL,G0H4(106),ex1(:),G0H2(1),m3h2x2(:,2285),heltab2x4(:,:,2615))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(1863),n2h2(2380))
  call Hloop_QV_A(ntryL,G1H32(48),ex4(:),G1H16(344),m3h2x16(:,293),heltab2x32(:,:,446))
  call Hloop_Q_A(ntryL,G1H16(344),40,0,G2H16(117),n2h16(521))
  call Hloop_QV_A(ntryL,G1H32(47),ex4(:),G1H16(345),m3h2x16(:,294),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G1H16(345),40,nMT,G2H16(118),n2h16(522))
  call Hloop_AV_Q(ntryL,G1H32(50),ex4(:),G1H16(346),m3h2x16(:,295),heltab2x32(:,:,448))
  call Hloop_A_Q(ntryL,G1H16(346),40,0,G2H16(119),n2h16(523))
  call Hloop_AV_Q(ntryL,G1H32(46),ex4(:),G1H16(349),m3h2x16(:,296),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G1H16(349),40,nMT,G2H16(120),n2h16(524))
  call Hloop_QV_A(ntryL,G1H32(53),ex4(:),G1H16(350),m3h2x16(:,297),heltab2x32(:,:,450))
  call Hloop_Q_A(ntryL,G1H16(350),40,nMB,G2H16(43),n2h16(525))
  call Hloop_AV_Q(ntryL,G1H32(55),ex4(:),G1H16(241),m3h2x16(:,298),heltab2x32(:,:,451))
  call Hloop_A_Q(ntryL,G1H16(241),40,nMB,G2H16(44),n2h16(526))
  call Hloop_AV_Q(ntryL,G1H32(58),wf16(:,41),G1H2(1865),m3h16x2(:,28),heltab2x32(:,:,452))
  call Hloop_A_Q(ntryL,G1H2(1865),47,0,G2H2(201),n2h2(2381))
  call Hloop_AV_Q(ntryL,G1H32(54),wf16(:,41),G1H2(1953),m3h16x2(:,29),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G1H2(1953),47,nMT,G2H2(195),n2h2(2382))
  call Hloop_QV_A(ntryL,G1H32(60),wf16(:,41),G1H2(1866),m3h16x2(:,30),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(1866),47,0,G2H2(544),n2h2(2383))
  call Hloop_QV_A(ntryL,G1H32(61),wf16(:,41),G1H2(1871),m3h16x2(:,31),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(1871),47,nMT,G2H2(799),n2h2(2384))
  call Hloop_AV_Q(ntryL,G1H32(63),wf16(:,41),G1H2(1959),m3h16x2(:,32),heltab2x32(:,:,456))
  call Hloop_A_Q(ntryL,G1H2(1959),47,nMB,G2H2(444),n2h2(2385))
  call Hloop_QV_A(ntryL,G1H32(62),wf16(:,41),G1H2(1872),m3h16x2(:,33),heltab2x32(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(1872),47,nMB,G2H2(420),n2h2(2386))
  call Hloop_DV_C(ntryL,G1H32(64),32,wf16(:,41),G2H2(202),m3h16x2(:,34),heltab2x32(:,:,458))
  call Hloop_CV_D(ntryL,G1H32(69),32,wf16(:,41),15,G2H2(196),m3h16x2(:,35),heltab2x32(:,:,459))
  call Hloop_UV_W(ntryL,G1H32(66),32,wf16(:,41),15,G2H2(673),m3h16x2(:,36),heltab2x32(:,:,460))
  call Hloop_QV_A(ntryL,G1H32(77),ex4(:),G1H16(256),m3h2x16(:,299),heltab2x32(:,:,461))
  call Hloop_Q_A(ntryL,G1H16(256),40,0,G2H16(45),n2h16(527))
  call Hloop_QV_A(ntryL,G1H32(74),ex4(:),G1H16(271),m3h2x16(:,300),heltab2x32(:,:,462))
  call Hloop_Q_A(ntryL,G1H16(271),40,nMT,G2H16(46),n2h16(528))
  call Hloop_AV_Q(ntryL,G1H32(78),ex4(:),G1H16(286),m3h2x16(:,301),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G1H16(286),40,0,G2H16(47),n2h16(529))
  call Hloop_AV_Q(ntryL,G1H32(76),ex4(:),G1H16(292),m3h2x16(:,302),heltab2x32(:,:,464))
  call Hloop_A_Q(ntryL,G1H16(292),40,nMT,G2H16(48),n2h16(530))
  call Hloop_QV_A(ntryL,G1H32(79),ex4(:),G1H16(307),m3h2x16(:,303),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G1H16(307),40,nMB,G2H16(49),n2h16(531))
  call Hloop_AV_Q(ntryL,G1H32(84),ex4(:),G1H16(329),m3h2x16(:,304),heltab2x32(:,:,466))
  call Hloop_A_Q(ntryL,G1H16(329),40,nMB,G2H16(50),n2h16(532))
  call Hloop_AQ_V(ntryL,G1H32(85),ex1(:),G1H16(341),m3h2x16(:,305),heltab2x32(:,:,467))
  call Hloop_VQ_A(ntryL,G1H32(88),ex1(:),G1H16(88),m3h2x16(:,306),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G1H16(88),33,0,G2H16(51),n2h16(533))
  call Hloop_VQ_A(ntryL,G0H4(97),ex1(:),G0H2(1),m3h2x2(:,2286),heltab2x4(:,:,2616))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(1874),n2h2(2387))
  call Hloop_AQ_V(ntryL,G1H4(452),ex1(:),G1H2(1944),m3h2x2(:,2287),heltab2x4(:,:,2617))
  call Hloop_AQ_V(ntryL,G1H32(87),ex1(:),G1H16(27),m3h2x16(:,307),heltab2x32(:,:,469))
  call Hloop_VQ_A(ntryL,G1H32(86),ex1(:),G1H16(37),m3h2x16(:,308),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G1H16(37),33,0,G2H16(52),n2h16(534))
  call Hloop_AQ_V(ntryL,G1H32(93),wf8(:,34),G1H4(370),m3h8x4(:,49),heltab2x32(:,:,471))
  call Hloop_VQ_A(ntryL,G1H32(96),wf8(:,34),G1H4(942),m3h8x4(:,50),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G1H4(942),45,0,G2H4(259),n2h4(1643))
  call Hloop_AQ_V(ntryL,G1H32(95),wf4(:,12),G1H8(419),m3h4x8(:,79),heltab2x32(:,:,473))
  call Hloop_VQ_A(ntryL,G1H32(98),wf4(:,12),G1H8(424),m3h4x8(:,80),heltab2x32(:,:,474))
  call Hloop_Q_A(ntryL,G1H8(424),41,0,G2H8(141),n2h8(1081))
  call Hloop_QV_A(ntryL,G1H32(101),ex3(:),G1H16(46),m3h2x16(:,309),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G1H16(46),36,0,G2H16(53),n2h16(535))
  call Hloop_QV_A(ntryL,G1H32(97),ex3(:),G1H16(48),m3h2x16(:,310),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G1H16(48),36,nMT,G2H16(54),n2h16(536))
  call Hloop_AV_Q(ntryL,G1H32(103),ex3(:),G1H16(30),m3h2x16(:,311),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G1H16(30),36,0,G2H16(55),n2h16(537))
  call Hloop_AV_Q(ntryL,G1H32(100),ex3(:),G1H16(42),m3h2x16(:,312),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G1H16(42),36,nMT,G2H16(56),n2h16(538))
  call Hloop_QV_A(ntryL,G1H32(102),ex3(:),G1H16(5),m3h2x16(:,313),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMB,G2H16(57),n2h16(539))
  call Hloop_AV_Q(ntryL,G1H32(104),ex3(:),G1H16(12),m3h2x16(:,314),heltab2x32(:,:,480))
  call Hloop_A_Q(ntryL,G1H16(12),36,nMB,G2H16(58),n2h16(540))
  call Hloop_VQ_A(ntryL,G0H16(45),wf8(:,34),G0H2(1),m3h8x2(:,303),heltab2x16(:,:,1215))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(1875),n2h2(2388))
  call Hloop_AQ_V(ntryL,G1H16(268),wf8(:,34),G1H2(1880),m3h8x2(:,304),heltab2x16(:,:,1216))
  call Hloop_AV_Q(ntryL,G1H16(276),ex3(:),G1H8(425),m3h2x8(:,757),heltab2x16(:,:,1217))
  call Hloop_A_Q(ntryL,G1H8(425),52,0,G2H8(143),n2h8(1082))
  call Hloop_AV_Q(ntryL,G1H16(273),ex3(:),G1H8(435),m3h2x8(:,758),heltab2x16(:,:,1218))
  call Hloop_A_Q(ntryL,G1H8(435),52,nMT,G2H8(156),n2h8(1083))
  call Hloop_QV_A(ntryL,G1H16(280),ex3(:),G1H8(440),m3h2x8(:,759),heltab2x16(:,:,1219))
  call Hloop_Q_A(ntryL,G1H8(440),52,0,G2H8(162),n2h8(1084))
  call Hloop_QV_A(ntryL,G1H16(275),ex3(:),G1H8(441),m3h2x8(:,760),heltab2x16(:,:,1220))
  call Hloop_Q_A(ntryL,G1H8(441),52,nMT,G2H8(164),n2h8(1085))
  call Hloop_AV_Q(ntryL,G1H16(279),ex3(:),G1H8(451),m3h2x8(:,761),heltab2x16(:,:,1221))
  call Hloop_A_Q(ntryL,G1H8(451),52,nMB,G2H8(171),n2h8(1086))
  call Hloop_QV_A(ntryL,G1H16(86),ex3(:),G1H8(456),m3h2x8(:,762),heltab2x16(:,:,1222))
  call Hloop_Q_A(ntryL,G1H8(456),52,nMB,G2H8(173),n2h8(1087))
  call Hloop_QA_V(ntryL,G1H16(281),ex2(:),G1H8(457),m3h2x8(:,763),heltab2x16(:,:,1223))
  call Hloop_VA_Q(ntryL,G0H4(105),ex2(:),G0H2(1),m3h2x2(:,2288),heltab2x4(:,:,2618))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(1950),n2h2(2389))
  call Hloop_QV_A(ntryL,G1H32(109),ex3(:),G1H16(55),m3h2x16(:,315),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G1H16(55),36,0,G2H16(59),n2h16(541))
  call Hloop_QV_A(ntryL,G1H32(106),ex3(:),G1H16(72),m3h2x16(:,316),heltab2x32(:,:,482))
  call Hloop_Q_A(ntryL,G1H16(72),36,nMT,G2H16(60),n2h16(542))
  call Hloop_AV_Q(ntryL,G1H32(111),ex3(:),G1H16(82),m3h2x16(:,317),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G1H16(82),36,0,G2H16(61),n2h16(543))
  call Hloop_AV_Q(ntryL,G1H32(108),ex3(:),G1H16(16),m3h2x16(:,318),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G1H16(16),36,nMT,G2H16(62),n2h16(544))
  call Hloop_QV_A(ntryL,G1H32(110),ex3(:),G1H16(19),m3h2x16(:,319),heltab2x32(:,:,485))
  call Hloop_Q_A(ntryL,G1H16(19),36,nMB,G2H16(63),n2h16(545))
  call Hloop_AV_Q(ntryL,G1H32(116),ex3(:),G1H16(22),m3h2x16(:,320),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G1H16(22),36,nMB,G2H16(64),n2h16(546))
  call Hloop_AV_Q(ntryL,G1H32(119),wf16(:,60),G1H2(1881),m3h16x2(:,37),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G1H2(1881),47,0,G2H2(203),n2h2(2390))
  call Hloop_AV_Q(ntryL,G1H32(118),wf16(:,60),G1H2(1884),m3h16x2(:,38),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G1H2(1884),47,nMT,G2H2(199),n2h2(2391))
  call Hloop_QV_A(ntryL,G1H32(121),wf16(:,60),G1H2(1973),m3h16x2(:,39),heltab2x32(:,:,489))
  call Hloop_Q_A(ntryL,G1H2(1973),47,0,G2H2(578),n2h2(2392))
  call Hloop_QV_A(ntryL,G1H32(117),wf16(:,60),G1H2(1885),m3h16x2(:,40),heltab2x32(:,:,490))
  call Hloop_Q_A(ntryL,G1H2(1885),47,nMT,G2H2(813),n2h2(2393))
  call Hloop_AV_Q(ntryL,G1H32(124),wf16(:,60),G1H2(1890),m3h16x2(:,41),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G1H2(1890),47,nMB,G2H2(452),n2h2(2394))
  call Hloop_QV_A(ntryL,G1H32(126),wf16(:,60),G1H2(1979),m3h16x2(:,42),heltab2x32(:,:,492))
  call Hloop_Q_A(ntryL,G1H2(1979),47,nMB,G2H2(436),n2h2(2395))
  call Hloop_DV_C(ntryL,G1H32(123),32,wf16(:,60),G2H2(204),m3h16x2(:,43),heltab2x32(:,:,493))
  call Hloop_CV_D(ntryL,G1H32(125),32,wf16(:,60),15,G2H2(200),m3h16x2(:,44),heltab2x32(:,:,494))
  call Hloop_UV_W(ntryL,G1H32(127),32,wf16(:,60),15,G2H2(707),m3h16x2(:,45),heltab2x32(:,:,495))
  call Hloop_QA_V(ntryL,G1H32(132),ex2(:),G1H16(97),m3h2x16(:,321),heltab2x32(:,:,496))
  call Hloop_VA_Q(ntryL,G1H32(129),ex2(:),G1H16(103),m3h2x16(:,322),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G1H16(103),34,0,G2H16(65),n2h16(547))
  call Hloop_QV_A(ntryL,G1H32(136),ex3(:),G1H16(109),m3h2x16(:,323),heltab2x32(:,:,498))
  call Hloop_Q_A(ntryL,G1H16(109),36,0,G2H16(66),n2h16(548))
  call Hloop_QV_A(ntryL,G1H32(131),ex3(:),G1H16(121),m3h2x16(:,324),heltab2x32(:,:,499))
  call Hloop_Q_A(ntryL,G1H16(121),36,nMT,G2H16(67),n2h16(549))
  call Hloop_AV_Q(ntryL,G1H32(138),ex3(:),G1H16(127),m3h2x16(:,325),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G1H16(127),36,0,G2H16(68),n2h16(550))
  call Hloop_AV_Q(ntryL,G1H32(135),ex3(:),G1H16(133),m3h2x16(:,326),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G1H16(133),36,nMT,G2H16(69),n2h16(551))
  call Hloop_QV_A(ntryL,G1H32(137),ex3(:),G1H16(139),m3h2x16(:,327),heltab2x32(:,:,502))
  call Hloop_Q_A(ntryL,G1H16(139),36,nMB,G2H16(70),n2h16(552))
  call Hloop_AV_Q(ntryL,G1H32(139),ex3(:),G1H16(151),m3h2x16(:,328),heltab2x32(:,:,503))
  call Hloop_A_Q(ntryL,G1H16(151),36,nMB,G2H16(71),n2h16(553))
  call Hloop_QA_V(ntryL,G1H32(140),ex2(:),G1H16(157),m3h2x16(:,329),heltab2x32(:,:,504))
  call Hloop_VA_Q(ntryL,G1H32(141),ex2(:),G1H16(163),m3h2x16(:,330),heltab2x32(:,:,505))
  call Hloop_A_Q(ntryL,G1H16(163),34,0,G2H16(72),n2h16(554))
  call Hloop_QA_V(ntryL,G1H32(142),wf4(:,5),G1H8(467),m3h4x8(:,81),heltab2x32(:,:,506))
  call Hloop_VA_Q(ntryL,G1H32(143),wf4(:,5),G1H8(472),m3h4x8(:,82),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G1H8(472),42,0,G2H8(149),n2h8(1088))
  call Hloop_QA_V(ntryL,G1H32(144),wf8(:,42),G1H4(381),m3h8x4(:,51),heltab2x32(:,:,508))
  call Hloop_VA_Q(ntryL,G1H32(145),wf8(:,42),G1H4(856),m3h8x4(:,52),heltab2x32(:,:,509))
  call Hloop_A_Q(ntryL,G1H4(856),46,0,G2H4(343),n2h4(1644))
  call Hloop_QV_A(ntryL,G1H32(154),ex3(:),G1H16(169),m3h2x16(:,331),heltab2x32(:,:,510))
  call Hloop_Q_A(ntryL,G1H16(169),36,0,G2H16(7),n2h16(555))
  call Hloop_QV_A(ntryL,G1H32(147),ex3(:),G1H16(181),m3h2x16(:,332),heltab2x32(:,:,511))
  call Hloop_Q_A(ntryL,G1H16(181),36,nMT,G2H16(8),n2h16(556))
  call Hloop_AV_Q(ntryL,G1H32(153),ex3(:),G1H16(187),m3h2x16(:,333),heltab2x32(:,:,512))
  call Hloop_A_Q(ntryL,G1H16(187),36,0,G2H16(9),n2h16(557))
  call Hloop_AV_Q(ntryL,G1H32(149),ex3(:),G1H16(193),m3h2x16(:,334),heltab2x32(:,:,513))
  call Hloop_A_Q(ntryL,G1H16(193),36,nMT,G2H16(10),n2h16(558))
  call Hloop_QV_A(ntryL,G1H32(151),ex3(:),G1H16(199),m3h2x16(:,335),heltab2x32(:,:,514))
  call Hloop_Q_A(ntryL,G1H16(199),36,nMB,G2H16(11),n2h16(559))
  call Hloop_AV_Q(ntryL,G1H32(155),ex3(:),G1H16(211),m3h2x16(:,336),heltab2x32(:,:,515))
  call Hloop_A_Q(ntryL,G1H16(211),36,nMB,G2H16(12),n2h16(560))
  call Hloop_VA_Q(ntryL,G0H16(57),wf8(:,42),G0H2(1),m3h8x2(:,305),heltab2x16(:,:,1224))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1891),n2h2(2396))
  call Hloop_QA_V(ntryL,G1H16(285),wf8(:,42),G1H2(1894),m3h8x2(:,306),heltab2x16(:,:,1225))
  call Hloop_AV_Q(ntryL,G1H16(291),ex3(:),G1H8(473),m3h2x8(:,764),heltab2x16(:,:,1226))
  call Hloop_A_Q(ntryL,G1H8(473),52,0,G2H8(154),n2h8(1089))
  call Hloop_AV_Q(ntryL,G1H16(288),ex3(:),G1H8(483),m3h2x8(:,765),heltab2x16(:,:,1227))
  call Hloop_A_Q(ntryL,G1H8(483),52,nMT,G2H8(160),n2h8(1090))
  call Hloop_QV_A(ntryL,G1H16(295),ex3(:),G1H8(488),m3h2x8(:,766),heltab2x16(:,:,1228))
  call Hloop_Q_A(ntryL,G1H8(488),52,0,G2H8(163),n2h8(1091))
  call Hloop_QV_A(ntryL,G1H16(290),ex3(:),G1H8(489),m3h2x8(:,767),heltab2x16(:,:,1229))
  call Hloop_Q_A(ntryL,G1H8(489),52,nMT,G2H8(168),n2h8(1092))
  call Hloop_AV_Q(ntryL,G1H16(294),ex3(:),G1H8(499),m3h2x8(:,768),heltab2x16(:,:,1230))
  call Hloop_A_Q(ntryL,G1H8(499),52,nMB,G2H8(172),n2h8(1093))
  call Hloop_QV_A(ntryL,G1H16(296),ex3(:),G1H8(504),m3h2x8(:,769),heltab2x16(:,:,1231))
  call Hloop_Q_A(ntryL,G1H8(504),52,nMB,G2H8(177),n2h8(1094))
  call Hloop_AQ_V(ntryL,G1H16(297),ex1(:),G1H8(505),m3h2x8(:,770),heltab2x16(:,:,1232))
  call Hloop_VQ_A(ntryL,G0H4(107),ex1(:),G0H2(1),m3h2x2(:,2289),heltab2x4(:,:,2619))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(1963),n2h2(2397))
  call Hloop_QV_A(ntryL,G1H32(161),ex3(:),G1H16(217),m3h2x16(:,337),heltab2x32(:,:,516))
  call Hloop_Q_A(ntryL,G1H16(217),36,0,G2H16(13),n2h16(561))
  call Hloop_QV_A(ntryL,G1H32(157),ex3(:),G1H16(223),m3h2x16(:,338),heltab2x32(:,:,517))
  call Hloop_Q_A(ntryL,G1H16(223),36,nMT,G2H16(14),n2h16(562))
  call Hloop_AV_Q(ntryL,G1H32(168),ex3(:),G1H16(229),m3h2x16(:,339),heltab2x32(:,:,518))
  call Hloop_A_Q(ntryL,G1H16(229),36,0,G2H16(15),n2h16(563))
  call Hloop_AV_Q(ntryL,G1H32(159),ex3(:),G1H16(49),m3h2x16(:,340),heltab2x32(:,:,519))
  call Hloop_A_Q(ntryL,G1H16(49),36,nMT,G2H16(16),n2h16(564))
  call Hloop_QV_A(ntryL,G1H32(163),ex3(:),G1H16(247),m3h2x16(:,341),heltab2x32(:,:,520))
  call Hloop_Q_A(ntryL,G1H16(247),36,nMB,G2H16(17),n2h16(565))
  call Hloop_AV_Q(ntryL,G1H32(165),ex3(:),G1H16(14),m3h2x16(:,342),heltab2x32(:,:,521))
  call Hloop_A_Q(ntryL,G1H16(14),36,nMB,G2H16(18),n2h16(566))
  call Hloop_AV_Q(ntryL,G1H32(172),wf16(:,79),G1H2(1895),m3h16x2(:,46),heltab2x32(:,:,522))
  call Hloop_A_Q(ntryL,G1H2(1895),47,0,G2H2(207),n2h2(2398))
  call Hloop_AV_Q(ntryL,G1H32(167),wf16(:,79),G1H2(1900),m3h16x2(:,47),heltab2x32(:,:,523))
  call Hloop_A_Q(ntryL,G1H2(1900),47,nMT,G2H2(711),n2h2(2399))
  call Hloop_QV_A(ntryL,G1H32(174),wf16(:,79),G1H2(1969),m3h16x2(:,48),heltab2x32(:,:,524))



end subroutine vamp_16

end module ol_vamp_16_ppaajj_ddxaagg_1_/**/REALKIND
