
module ol_vamp_1_ppaajj2_uuxaagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaajj2_uuxaagg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaajj2_uuxaagg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppaajj2_uuxaagg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppaajj2_uuxaagg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,19) :: G0
  complex(REALKIND), dimension(4,5,4,66) :: G1
  complex(REALKIND), dimension(4,15,4,120) :: G2
  complex(REALKIND), dimension(4,35,4,144) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G5tensorhel(126,72,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,20),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-3),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,-5),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,60),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,97),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),ZERO,G5tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,24),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,28),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,97),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),ZERO,G5tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,20),MT,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-3),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,28),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-5),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,97),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-3),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,24),MT,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,28),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-5),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,97),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,16),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,20),ZERO,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,-3),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,28),ZERO,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_Q_A(G3(:,:,:,10),Q(:,60),ZERO,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,97),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),ZERO,G5tensor(:,5))
  call loop_QV_A(G1(:,:,:,7),wf(:,-3),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,24),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-2),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,28),ZERO,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,-5),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,60),ZERO,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,97),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),ZERO,G5tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MT,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-2),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,20),MT,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,-3),G2(:,:,:,14))
  call loop_Q_A(G2(:,:,:,14),Q(:,28),MT,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,-5),G3(:,:,:,14))
  call loop_Q_A(G3(:,:,:,14),Q(:,60),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,97),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G1(:,:,:,10),wf(:,-3),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,24),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-2),G2(:,:,:,16))
  call loop_Q_A(G2(:,:,:,16),Q(:,28),MT,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-5),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,60),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,97),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MT,G5tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,20),MB,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,28),MB,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-5),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,60),MB,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,97),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,24),MB,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,28),MB,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,60),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,97),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),MB,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,-2),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,20),MB,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-3),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,28),MB,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-5),G3(:,:,:,22))
  call loop_Q_A(G3(:,:,:,22),Q(:,60),MB,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,97),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_QV_A(G1(:,:,:,16),wf(:,-3),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,24),MB,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-2),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,28),MB,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-5),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,60),MB,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,97),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-2),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,12),ZERO,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,28),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,-5),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,60),ZERO,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,97),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,25),wf(:,-5),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,44),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-4),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,60),ZERO,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,97),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,24),ZERO,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-2),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,28),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,60),ZERO,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,97),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),ZERO,G5tensor(:,15))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,40),ZERO,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,-2),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,44),ZERO,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-4),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,60),ZERO,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,97),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),ZERO,G5tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,-2),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,12),MT,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,-4),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,28),MT,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,-5),G3(:,:,:,34))
  call loop_Q_A(G3(:,:,:,34),Q(:,60),MT,G4(:,:,:,33))
  call loop_QV_A(G4(:,:,:,33),wf(:,97),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,32),wf(:,-5),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,44),MT,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-4),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,60),MT,G4(:,:,:,35))
  call loop_QV_A(G4(:,:,:,35),wf(:,97),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G1(:,:,:,23),wf(:,-4),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,24),MT,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-2),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,28),MT,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,60),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,97),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G1(:,:,:,23),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,40),MT,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,44),MT,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,60),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,97),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,8),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-2),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,12),ZERO,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,28),ZERO,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-5),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,60),ZERO,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,97),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),ZERO,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-5),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,44),ZERO,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,-4),G3(:,:,:,44))
  call loop_A_Q(G3(:,:,:,44),Q(:,60),ZERO,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,97),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),ZERO,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,24),ZERO,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-2),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,28),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,60),ZERO,G4(:,:,:,45))
  call loop_AV_Q(G4(:,:,:,45),wf(:,97),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),ZERO,G5tensor(:,23))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-5),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,40),ZERO,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-2),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,44),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,60),ZERO,G4(:,:,:,47))
  call loop_AV_Q(G4(:,:,:,47),wf(:,97),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),ZERO,G5tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),MT,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-2),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,12),MT,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-4),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,28),MT,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,-5),G3(:,:,:,50))
  call loop_A_Q(G3(:,:,:,50),Q(:,60),MT,G4(:,:,:,49))
  call loop_AV_Q(G4(:,:,:,49),wf(:,97),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-5),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,44),MT,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,60),MT,G4(:,:,:,51))
  call loop_AV_Q(G4(:,:,:,51),wf(:,97),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,24),MT,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-2),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,28),MT,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-5),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,60),MT,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,97),G4(:,:,:,54))
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,40),MT,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,44),MT,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,60),MT,G4(:,:,:,55))
  call loop_AV_Q(G4(:,:,:,55),wf(:,97),G4(:,:,:,56))
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-2),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,12),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,28),MB,G3(:,:,:,57))
  call loop_QV_A(G3(:,:,:,57),wf(:,-5),G3(:,:,:,58))
  call loop_Q_A(G3(:,:,:,58),Q(:,60),MB,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,97),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MB,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,53),wf(:,-5),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,44),MB,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_Q_A(G3(:,:,:,60),Q(:,60),MB,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,97),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,24),MB,G2(:,:,:,56))
  call loop_QV_A(G2(:,:,:,56),wf(:,-2),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,28),MB,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-5),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,60),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,97),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,63),MB,G5tensor(:,31))
  call loop_QV_A(G1(:,:,:,35),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,40),MB,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,-2),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,44),MB,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,60),MB,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,97),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,63),MB,G5tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),MB,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,12),MB,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,28),MB,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-5),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,60),MB,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,97),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,63),MB,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-5),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,44),MB,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-4),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,60),MB,G4(:,:,:,67))
  call loop_AV_Q(G4(:,:,:,67),wf(:,97),G4(:,:,:,68))
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-4),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,24),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-2),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,28),MB,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,60),MB,G4(:,:,:,69))
  call loop_AV_Q(G4(:,:,:,69),wf(:,97),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MB,G5tensor(:,35))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-5),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,40),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,44),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,60),MB,G4(:,:,:,71))
  call loop_AV_Q(G4(:,:,:,71),wf(:,97),G4(:,:,:,72))
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,63),MB,G5tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,12),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-4),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,28),ZERO,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-5),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,60),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,97),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,63),ZERO,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,44),ZERO,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-4),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,60),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,97),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,63),ZERO,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,20),ZERO,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,-3),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,28),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-5),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,60),ZERO,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,97),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,63),ZERO,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,70),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,52),ZERO,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,60),ZERO,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,97),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),ZERO,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-5),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,36),ZERO,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-3),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,44),ZERO,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-4),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,60),ZERO,G4(:,:,:,81))
  call loop_AV_Q(G4(:,:,:,81),wf(:,97),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),ZERO,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-4),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,52),ZERO,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-3),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,60),ZERO,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,97),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),ZERO,G5tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-3),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,12),MT,G2(:,:,:,76))
  call loop_AV_Q(G2(:,:,:,76),wf(:,-4),G2(:,:,:,77))
  call loop_A_Q(G2(:,:,:,77),Q(:,28),MT,G3(:,:,:,85))
  call loop_AV_Q(G3(:,:,:,85),wf(:,-5),G3(:,:,:,86))
  call loop_A_Q(G3(:,:,:,86),Q(:,60),MT,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,97),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,76),wf(:,-5),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,44),MT,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,60),MT,G4(:,:,:,87))
  call loop_AV_Q(G4(:,:,:,87),wf(:,97),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,63),MT,G5tensor(:,44))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-4),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,20),MT,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-3),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,28),MT,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,60),MT,G4(:,:,:,89))
  call loop_AV_Q(G4(:,:,:,89),wf(:,97),G4(:,:,:,90))
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,45))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-5),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,52),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-3),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,60),MT,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,97),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,46))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-5),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,36),MT,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-3),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,44),MT,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,-4),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,60),MT,G4(:,:,:,93))
  call loop_AV_Q(G4(:,:,:,93),wf(:,97),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,47))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-4),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,52),MT,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-3),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,60),MT,G4(:,:,:,95))
  call loop_AV_Q(G4(:,:,:,95),wf(:,97),G4(:,:,:,96))
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,12),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-4),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,28),ZERO,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,-5),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,60),ZERO,G4(:,:,:,97))
  call loop_QV_A(G4(:,:,:,97),wf(:,97),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,63),ZERO,G5tensor(:,49))
  call loop_QV_A(G2(:,:,:,85),wf(:,-5),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,44),ZERO,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,60),ZERO,G4(:,:,:,99))
  call loop_QV_A(G4(:,:,:,99),wf(:,97),G4(:,:,:,100))
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,63),ZERO,G5tensor(:,50))
  call loop_QV_A(G1(:,:,:,51),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,20),ZERO,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,-3),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,28),ZERO,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-5),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,60),ZERO,G4(:,:,:,101))
  call loop_QV_A(G4(:,:,:,101),wf(:,97),G4(:,:,:,102))
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,63),ZERO,G5tensor(:,51))
  call loop_QV_A(G2(:,:,:,88),wf(:,-5),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,52),ZERO,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-3),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,60),ZERO,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,97),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,63),ZERO,G5tensor(:,52))
  call loop_QV_A(G1(:,:,:,51),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,36),ZERO,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-3),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,44),ZERO,G3(:,:,:,105))
  call loop_QV_A(G3(:,:,:,105),wf(:,-4),G3(:,:,:,106))
  call loop_Q_A(G3(:,:,:,106),Q(:,60),ZERO,G4(:,:,:,105))
  call loop_QV_A(G4(:,:,:,105),wf(:,97),G4(:,:,:,106))
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,63),ZERO,G5tensor(:,53))
  call loop_QV_A(G2(:,:,:,91),wf(:,-4),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,52),ZERO,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-3),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,60),ZERO,G4(:,:,:,107))
  call loop_QV_A(G4(:,:,:,107),wf(:,97),G4(:,:,:,108))
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),ZERO,G5tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,4),MT,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,-3),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,12),MT,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,-4),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,28),MT,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,60),MT,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,97),G4(:,:,:,110))
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,63),MT,G5tensor(:,55))
  call loop_QV_A(G2(:,:,:,94),wf(:,-5),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,44),MT,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,60),MT,G4(:,:,:,111))
  call loop_QV_A(G4(:,:,:,111),wf(:,97),G4(:,:,:,112))
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,63),MT,G5tensor(:,56))
  call loop_QV_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,20),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-3),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,28),MT,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-5),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,60),MT,G4(:,:,:,113))
  call loop_QV_A(G4(:,:,:,113),wf(:,97),G4(:,:,:,114))
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,63),MT,G5tensor(:,57))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,52),MT,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,-3),G3(:,:,:,116))
  call loop_Q_A(G3(:,:,:,116),Q(:,60),MT,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,97),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,55),wf(:,-5),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,36),MT,G2(:,:,:,100))
  call loop_QV_A(G2(:,:,:,100),wf(:,-3),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,44),MT,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-4),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,60),MT,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,97),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,63),MT,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,100),wf(:,-4),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,52),MT,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-3),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,60),MT,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,97),G4(:,:,:,120))
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,63),MT,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,4),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-3),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,12),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-4),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,28),MB,G3(:,:,:,121))
  call loop_AV_Q(G3(:,:,:,121),wf(:,-5),G3(:,:,:,122))
  call loop_A_Q(G3(:,:,:,122),Q(:,60),MB,G4(:,:,:,121))
  call loop_AV_Q(G4(:,:,:,121),wf(:,97),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,63),MB,G5tensor(:,61))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-5),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,44),MB,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,60),MB,G4(:,:,:,123))
  call loop_AV_Q(G4(:,:,:,123),wf(:,97),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,63),MB,G5tensor(:,62))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-4),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,20),MB,G2(:,:,:,106))
  call loop_AV_Q(G2(:,:,:,106),wf(:,-3),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,28),MB,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-5),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,60),MB,G4(:,:,:,125))
  call loop_AV_Q(G4(:,:,:,125),wf(:,97),G4(:,:,:,126))
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,63),MB,G5tensor(:,63))
  call loop_AV_Q(G2(:,:,:,106),wf(:,-5),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,52),MB,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-3),G3(:,:,:,128))
  call loop_A_Q(G3(:,:,:,128),Q(:,60),MB,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,97),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,63),MB,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-5),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,36),MB,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,-3),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,44),MB,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-4),G3(:,:,:,130))
  call loop_A_Q(G3(:,:,:,130),Q(:,60),MB,G4(:,:,:,129))
  call loop_AV_Q(G4(:,:,:,129),wf(:,97),G4(:,:,:,130))
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,63),MB,G5tensor(:,65))
  call loop_AV_Q(G2(:,:,:,109),wf(:,-4),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,52),MB,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-3),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,60),MB,G4(:,:,:,131))
  call loop_AV_Q(G4(:,:,:,131),wf(:,97),G4(:,:,:,132))
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,63),MB,G5tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,4),MB,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,-3),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,12),MB,G2(:,:,:,112))
  call loop_QV_A(G2(:,:,:,112),wf(:,-4),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,28),MB,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,-5),G3(:,:,:,134))
  call loop_Q_A(G3(:,:,:,134),Q(:,60),MB,G4(:,:,:,133))
  call loop_QV_A(G4(:,:,:,133),wf(:,97),G4(:,:,:,134))
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,63),MB,G5tensor(:,67))
  call loop_QV_A(G2(:,:,:,112),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,44),MB,G3(:,:,:,135))
  call loop_QV_A(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_Q_A(G3(:,:,:,136),Q(:,60),MB,G4(:,:,:,135))
  call loop_QV_A(G4(:,:,:,135),wf(:,97),G4(:,:,:,136))
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,63),MB,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,63),wf(:,-4),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,20),MB,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-3),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,28),MB,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,-5),G3(:,:,:,138))
  call loop_Q_A(G3(:,:,:,138),Q(:,60),MB,G4(:,:,:,137))
  call loop_QV_A(G4(:,:,:,137),wf(:,97),G4(:,:,:,138))
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,63),MB,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,115),wf(:,-5),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,52),MB,G3(:,:,:,139))
  call loop_QV_A(G3(:,:,:,139),wf(:,-3),G3(:,:,:,140))
  call loop_Q_A(G3(:,:,:,140),Q(:,60),MB,G4(:,:,:,139))
  call loop_QV_A(G4(:,:,:,139),wf(:,97),G4(:,:,:,140))
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,63),MB,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,63),wf(:,-5),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,36),MB,G2(:,:,:,118))
  call loop_QV_A(G2(:,:,:,118),wf(:,-3),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,44),MB,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-4),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,60),MB,G4(:,:,:,141))
  call loop_QV_A(G4(:,:,:,141),wf(:,97),G4(:,:,:,142))
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,63),MB,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,118),wf(:,-4),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,52),MB,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-3),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,60),MB,G4(:,:,:,143))
  call loop_QV_A(G4(:,:,:,143),wf(:,97),G4(:,:,:,144))
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,63),MB,G5tensor(:,72))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,3),T5sum(1:126,2))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,3),T5sum(1:126,2))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,5),T5sum(1:126,1))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,5),T5sum(1:126,1))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,7),T5sum(1:126,2))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,7),T5sum(1:126,2))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,9),T5sum(1:126,3))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,9),T5sum(1:126,3))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,5),T5sum(1:126,1))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,5),T5sum(1:126,1))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,11),T5sum(1:126,3))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,11),T5sum(1:126,3))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,13),T5sum(1:126,4))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,13),T5sum(1:126,4))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,17),T5sum(1:126,5))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,17),T5sum(1:126,5))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,21),T5sum(1:126,4))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,21),T5sum(1:126,4))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,25),T5sum(1:126,5))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,25),T5sum(1:126,5))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,13),T5sum(1:126,4))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,13),T5sum(1:126,4))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,29),T5sum(1:126,6))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,29),T5sum(1:126,6))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,21),T5sum(1:126,4))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,21),T5sum(1:126,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,33),T5sum(1:126,6))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,33),T5sum(1:126,6))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,6),T5sum(1:126,7))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,6),T5sum(1:126,7))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,8),T5sum(1:126,8))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,2),T5sum(1:126,7))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,2),T5sum(1:126,7))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,4),T5sum(1:126,8))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,4),T5sum(1:126,8))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,6),T5sum(1:126,7))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,6),T5sum(1:126,7))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,12),T5sum(1:126,9))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,12),T5sum(1:126,9))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,2),T5sum(1:126,7))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,2),T5sum(1:126,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,10),T5sum(1:126,9))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,10),T5sum(1:126,9))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,14),T5sum(1:126,10))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,14),T5sum(1:126,10))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,18),T5sum(1:126,11))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,18),T5sum(1:126,11))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,26),T5sum(1:126,11))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,26),T5sum(1:126,11))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,14),T5sum(1:126,10))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,14),T5sum(1:126,10))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,30),T5sum(1:126,12))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,30),T5sum(1:126,12))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,34),T5sum(1:126,12))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,34),T5sum(1:126,12))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,37),T5sum(1:126,13))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,37),T5sum(1:126,13))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,43),T5sum(1:126,14))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,43),T5sum(1:126,14))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,49),T5sum(1:126,13))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,49),T5sum(1:126,13))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,55),T5sum(1:126,14))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,55),T5sum(1:126,14))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,37),T5sum(1:126,13))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,37),T5sum(1:126,13))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,61),T5sum(1:126,15))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,61),T5sum(1:126,15))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,49),T5sum(1:126,13))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,49),T5sum(1:126,13))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,67),T5sum(1:126,15))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,67),T5sum(1:126,15))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,38),T5sum(1:126,16))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,38),T5sum(1:126,16))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,44),T5sum(1:126,17))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,44),T5sum(1:126,17))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,50),T5sum(1:126,16))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,50),T5sum(1:126,16))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,56),T5sum(1:126,17))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,56),T5sum(1:126,17))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,38),T5sum(1:126,16))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,38),T5sum(1:126,16))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,62),T5sum(1:126,18))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,62),T5sum(1:126,18))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,50),T5sum(1:126,16))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,50),T5sum(1:126,16))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,68),T5sum(1:126,18))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,68),T5sum(1:126,18))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,15),T5sum(1:126,19))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,15),T5sum(1:126,19))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,19),T5sum(1:126,20))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,19),T5sum(1:126,20))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,23),T5sum(1:126,19))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,23),T5sum(1:126,19))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,27),T5sum(1:126,20))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,27),T5sum(1:126,20))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,15),T5sum(1:126,19))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,15),T5sum(1:126,19))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,31),T5sum(1:126,21))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,31),T5sum(1:126,21))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,23),T5sum(1:126,19))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,23),T5sum(1:126,19))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,35),T5sum(1:126,21))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,35),T5sum(1:126,21))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,24),T5sum(1:126,22))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,24),T5sum(1:126,22))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,28),T5sum(1:126,23))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,28),T5sum(1:126,23))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,16),T5sum(1:126,22))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,16),T5sum(1:126,22))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,20),T5sum(1:126,23))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,20),T5sum(1:126,23))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,24),T5sum(1:126,22))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,24),T5sum(1:126,22))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,36),T5sum(1:126,24))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,36),T5sum(1:126,24))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,16),T5sum(1:126,22))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,16),T5sum(1:126,22))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,32),T5sum(1:126,24))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,32),T5sum(1:126,24))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,39),T5sum(1:126,25))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,39),T5sum(1:126,25))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,45),T5sum(1:126,26))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,45),T5sum(1:126,26))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,51),T5sum(1:126,25))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,51),T5sum(1:126,25))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,57),T5sum(1:126,26))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,57),T5sum(1:126,26))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,39),T5sum(1:126,25))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,39),T5sum(1:126,25))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,63),T5sum(1:126,27))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,63),T5sum(1:126,27))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,51),T5sum(1:126,25))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,51),T5sum(1:126,25))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,69),T5sum(1:126,27))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,69),T5sum(1:126,27))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,40),T5sum(1:126,28))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,40),T5sum(1:126,28))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,46),T5sum(1:126,29))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,46),T5sum(1:126,29))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,52),T5sum(1:126,28))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,52),T5sum(1:126,28))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,58),T5sum(1:126,29))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,58),T5sum(1:126,29))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,40),T5sum(1:126,28))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,40),T5sum(1:126,28))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,64),T5sum(1:126,30))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,64),T5sum(1:126,30))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,52),T5sum(1:126,28))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,52),T5sum(1:126,28))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,70),T5sum(1:126,30))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,70),T5sum(1:126,30))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,41),T5sum(1:126,31))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,41),T5sum(1:126,31))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,47),T5sum(1:126,32))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,47),T5sum(1:126,32))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,53),T5sum(1:126,31))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,53),T5sum(1:126,31))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,59),T5sum(1:126,32))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,59),T5sum(1:126,32))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,41),T5sum(1:126,31))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,41),T5sum(1:126,31))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,65),T5sum(1:126,33))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,65),T5sum(1:126,33))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,53),T5sum(1:126,31))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,53),T5sum(1:126,31))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,71),T5sum(1:126,33))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,71),T5sum(1:126,33))
  M(2) = M(2) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,42),T5sum(1:126,34))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,42),T5sum(1:126,34))
  M(2) = M(2) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,48),T5sum(1:126,35))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,48),T5sum(1:126,35))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,54),T5sum(1:126,34))
  M(3) = M(3) + (f(10)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,54),T5sum(1:126,34))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,60),T5sum(1:126,35))
  M(3) = M(3) + (f(9)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,60),T5sum(1:126,35))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,42),T5sum(1:126,34))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,42),T5sum(1:126,34))
  M(2) = M(2) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,66),T5sum(1:126,36))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,66),T5sum(1:126,36))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,54),T5sum(1:126,34))
  M(3) = M(3) + (f(8)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,54),T5sum(1:126,34))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(72)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,72),T5sum(1:126,36))
  M(3) = M(3) + (f(7)/6._/**/REALKIND * den(72)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,72),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppaajj2_uuxaagg_1_/**/REALKIND
