
module ol_vamp_16_ppaajj2_aagggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_16(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaajj2_aagggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaajj2_aagggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppaajj2_aagggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppaajj2_aagggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppaajj2_aagggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppaajj2_aagggg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(6,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,481),heltab2x64(:,:,481))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(481))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[32,2,1,16,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,482),heltab2x64(:,:,482))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(3),n2h32(482))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,483),heltab2x64(:,:,483))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(483))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[32,2,1,16,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,484),heltab2x64(:,:,484))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(11),n2h32(484))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,485),heltab2x64(:,:,485))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(485))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[32,2,1,16,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,486),heltab2x64(:,:,486))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(19),n2h32(486))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,487),heltab2x64(:,:,487))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(487))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[32,2,1,16,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,488),heltab2x64(:,:,488))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(27),n2h32(488))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,489),heltab2x64(:,:,489))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(489))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,12,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,490),heltab2x64(:,:,490))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(35),n2h32(490))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,491),heltab2x64(:,:,491))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(491))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,12,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,492),heltab2x64(:,:,492))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(43),n2h32(492))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,493),heltab2x64(:,:,493))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(49),n2h32(493))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,12,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,494),heltab2x64(:,:,494))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(51),n2h32(494))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,495),heltab2x64(:,:,495))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(57),n2h32(495))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,12,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,496),heltab2x64(:,:,496))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(59),n2h32(496))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,497),heltab2x64(:,:,497))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(65),n2h32(497))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,1,2,16,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,498),heltab2x64(:,:,498))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(67),n2h32(498))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,499),heltab2x64(:,:,499))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(73),n2h32(499))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[32,1,2,16,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,500),heltab2x64(:,:,500))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(75),n2h32(500))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,501),heltab2x64(:,:,501))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(81),n2h32(501))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[32,1,2,16,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,502),heltab2x64(:,:,502))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(83),n2h32(502))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,503),heltab2x64(:,:,503))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(89),n2h32(503))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[32,1,2,16,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,504),heltab2x64(:,:,504))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(91),n2h32(504))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,505),heltab2x64(:,:,505))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(97),n2h32(505))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,1,2,12,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,506),heltab2x64(:,:,506))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(99),n2h32(506))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,507),heltab2x64(:,:,507))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(105),n2h32(507))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,1,2,12,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,508),heltab2x64(:,:,508))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(107),n2h32(508))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,509),heltab2x64(:,:,509))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(113),n2h32(509))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[32,1,2,12,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,510),heltab2x64(:,:,510))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(115),n2h32(510))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,511),heltab2x64(:,:,511))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(121),n2h32(511))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[32,1,2,12,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,512),heltab2x64(:,:,512))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(123),n2h32(512))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,513),heltab2x64(:,:,513))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(129),n2h32(513))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[32,12,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,514),heltab2x64(:,:,514))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(131),n2h32(514))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,515),heltab2x64(:,:,515))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(137),n2h32(515))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,12,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,516),heltab2x64(:,:,516))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(139),n2h32(516))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,517),heltab2x64(:,:,517))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(145),n2h32(517))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[32,12,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,518),heltab2x64(:,:,518))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(147),n2h32(518))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,519),heltab2x64(:,:,519))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(153),n2h32(519))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[32,12,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,520),heltab2x64(:,:,520))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(155),n2h32(520))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,521),heltab2x64(:,:,521))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(161),n2h32(521))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[32,2,1,12,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,522),heltab2x64(:,:,522))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(163),n2h32(522))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,523),heltab2x64(:,:,523))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(169),n2h32(523))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,2,1,12,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,524),heltab2x64(:,:,524))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(171),n2h32(524))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,525),heltab2x64(:,:,525))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(177),n2h32(525))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,2,1,12,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,526),heltab2x64(:,:,526))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(179),n2h32(526))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,527),heltab2x64(:,:,527))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(185),n2h32(527))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,2,1,12,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,528),heltab2x64(:,:,528))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(187),n2h32(528))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,529),heltab2x64(:,:,529))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(193),n2h32(529))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,1,16,2,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,530),heltab2x64(:,:,530))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(195),n2h32(530))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,531),heltab2x64(:,:,531))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(201),n2h32(531))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,1,16,2,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,532),heltab2x64(:,:,532))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(203),n2h32(532))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,533),heltab2x64(:,:,533))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(209),n2h32(533))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[32,1,16,2,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,534),heltab2x64(:,:,534))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(211),n2h32(534))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[32,1,16,2,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,535),heltab2x64(:,:,535))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(217),n2h32(535))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[32,1,16,2,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,536),heltab2x64(:,:,536))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(219),n2h32(536))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,537),heltab2x64(:,:,537))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(225),n2h32(537))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[32,1,16,12,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,538),heltab2x64(:,:,538))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(227),n2h32(538))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,539),heltab2x64(:,:,539))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(233),n2h32(539))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[32,1,16,12,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,540),heltab2x64(:,:,540))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(235),n2h32(540))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,541),heltab2x64(:,:,541))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(241),n2h32(541))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[32,1,16,12,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,542),heltab2x64(:,:,542))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(243),n2h32(542))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[32,1,16,12,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,543),heltab2x64(:,:,543))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(249),n2h32(543))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[32,1,16,12,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,544),heltab2x64(:,:,544))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(251),n2h32(544))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,545),heltab2x64(:,:,545))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(257),n2h32(545))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[32,2,16,1,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,546),heltab2x64(:,:,546))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(259),n2h32(546))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,547),heltab2x64(:,:,547))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(265),n2h32(547))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[32,2,16,1,12],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,548),heltab2x64(:,:,548))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(267),n2h32(548))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,549),heltab2x64(:,:,549))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(273),n2h32(549))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[32,2,16,1,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,550),heltab2x64(:,:,550))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(275),n2h32(550))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[32,2,16,1,12],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,551),heltab2x64(:,:,551))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(281),n2h32(551))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[32,2,16,1,12],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,552),heltab2x64(:,:,552))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(283),n2h32(552))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,553),heltab2x64(:,:,553))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(289),n2h32(553))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[32,2,12,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,554),heltab2x64(:,:,554))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(291),n2h32(554))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,555),heltab2x64(:,:,555))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(297),n2h32(555))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[32,2,12,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,556),heltab2x64(:,:,556))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(299),n2h32(556))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,557),heltab2x64(:,:,557))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(305),n2h32(557))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[32,2,12,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,558),heltab2x64(:,:,558))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(307),n2h32(558))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,559),heltab2x64(:,:,559))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(313),n2h32(559))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[32,2,12,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,560),heltab2x64(:,:,560))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(315),n2h32(560))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,561),heltab2x64(:,:,561))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(321),n2h32(561))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,1,12,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,562),heltab2x64(:,:,562))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(323),n2h32(562))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,563),heltab2x64(:,:,563))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(329),n2h32(563))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,1,12,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,564),heltab2x64(:,:,564))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(331),n2h32(564))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,565),heltab2x64(:,:,565))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(337),n2h32(565))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,1,12,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,566),heltab2x64(:,:,566))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(339),n2h32(566))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,1,12,16,2],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,567),heltab2x64(:,:,567))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(345),n2h32(567))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,1,12,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,568),heltab2x64(:,:,568))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(347),n2h32(568))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,569),heltab2x64(:,:,569))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(353),n2h32(569))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[32,1,12,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,570),heltab2x64(:,:,570))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(355),n2h32(570))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,571),heltab2x64(:,:,571))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(361),n2h32(571))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[32,1,12,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,572),heltab2x64(:,:,572))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(363),n2h32(572))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,573),heltab2x64(:,:,573))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(369),n2h32(573))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(6,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[32,1,12,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,574),heltab2x64(:,:,574))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(371),n2h32(574))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,575),heltab2x64(:,:,575))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(377),n2h32(575))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[32,1,12,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,576),heltab2x64(:,:,576))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(379),n2h32(576))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,577),heltab2x64(:,:,577))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(385),n2h32(577))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[32,2,1,8,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,578),heltab2x64(:,:,578))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(387),n2h32(578))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,579),heltab2x64(:,:,579))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(393),n2h32(579))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[32,2,1,8,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,580),heltab2x64(:,:,580))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(395),n2h32(580))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,581),heltab2x64(:,:,581))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(401),n2h32(581))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[32,2,1,8,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,582),heltab2x64(:,:,582))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(403),n2h32(582))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[32,2,1,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,583),heltab2x64(:,:,583))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(409),n2h32(583))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[32,2,1,8,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,584),heltab2x64(:,:,584))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(411),n2h32(584))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,585),heltab2x64(:,:,585))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(417),n2h32(585))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[32,8,1,2,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,586),heltab2x64(:,:,586))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(419),n2h32(586))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,587),heltab2x64(:,:,587))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(425),n2h32(587))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[32,8,1,2,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,588),heltab2x64(:,:,588))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(427),n2h32(588))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,589),heltab2x64(:,:,589))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(433),n2h32(589))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[32,8,1,2,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,590),heltab2x64(:,:,590))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(435),n2h32(590))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,591),heltab2x64(:,:,591))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(441),n2h32(591))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[32,8,1,2,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,592),heltab2x64(:,:,592))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(443),n2h32(592))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,593),heltab2x64(:,:,593))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(449),n2h32(593))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[32,1,2,8,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,594),heltab2x64(:,:,594))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(451),n2h32(594))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,595),heltab2x64(:,:,595))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(457),n2h32(595))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[32,1,2,8,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,596),heltab2x64(:,:,596))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(459),n2h32(596))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,597),heltab2x64(:,:,597))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(465),n2h32(597))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[32,1,2,8,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,598),heltab2x64(:,:,598))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(467),n2h32(598))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[32,1,2,8,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,599),heltab2x64(:,:,599))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(473),n2h32(599))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[32,1,2,8,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,600),heltab2x64(:,:,600))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(475),n2h32(600))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,601),heltab2x64(:,:,601))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(601))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[32,1,2,20,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,602),heltab2x64(:,:,602))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(2),n2h32(602))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,603),heltab2x64(:,:,603))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(603))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[32,1,2,20,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,604),heltab2x64(:,:,604))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(4),n2h32(604))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,605),heltab2x64(:,:,605))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(605))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[32,1,2,20,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,606),heltab2x64(:,:,606))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(8),n2h32(606))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[32,1,2,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,607),heltab2x64(:,:,607))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(607))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[32,1,2,20,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,608),heltab2x64(:,:,608))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(10),n2h32(608))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,609),heltab2x64(:,:,609))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(609))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[32,8,2,1,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,610),heltab2x64(:,:,610))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(12),n2h32(610))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,611),heltab2x64(:,:,611))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(611))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[32,8,2,1,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,612),heltab2x64(:,:,612))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(16),n2h32(612))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,613),heltab2x64(:,:,613))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(613))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[32,8,2,1,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,614),heltab2x64(:,:,614))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(18),n2h32(614))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,615),heltab2x64(:,:,615))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(615))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[32,8,2,1,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,616),heltab2x64(:,:,616))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(20),n2h32(616))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,617),heltab2x64(:,:,617))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(617))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[32,2,1,20,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,618),heltab2x64(:,:,618))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(24),n2h32(618))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,619),heltab2x64(:,:,619))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(619))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[32,2,1,20,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,620),heltab2x64(:,:,620))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(26),n2h32(620))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,621),heltab2x64(:,:,621))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(621))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[32,2,1,20,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,622),heltab2x64(:,:,622))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(28),n2h32(622))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[32,2,1,20,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,623),heltab2x64(:,:,623))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(623))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[32,2,1,20,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,624),heltab2x64(:,:,624))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(32),n2h32(624))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,625),heltab2x64(:,:,625))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(625))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[32,1,8,2,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,626),heltab2x64(:,:,626))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(34),n2h32(626))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,627),heltab2x64(:,:,627))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(39),n2h32(627))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[32,1,8,2,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,628),heltab2x64(:,:,628))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(36),n2h32(628))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,629),heltab2x64(:,:,629))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(629))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[32,1,8,2,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,630),heltab2x64(:,:,630))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(40),n2h32(630))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[32,1,8,2,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,631),heltab2x64(:,:,631))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(631))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[32,1,8,2,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,632),heltab2x64(:,:,632))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(42),n2h32(632))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,633),heltab2x64(:,:,633))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(633))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[32,1,8,20,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,634),heltab2x64(:,:,634))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(44),n2h32(634))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,635),heltab2x64(:,:,635))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(46),n2h32(635))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[32,1,8,20,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,636),heltab2x64(:,:,636))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(48),n2h32(636))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,637),heltab2x64(:,:,637))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(637))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[32,1,8,20,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,638),heltab2x64(:,:,638))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(50),n2h32(638))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,639),heltab2x64(:,:,639))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(55),n2h32(639))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[32,1,8,20,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,640),heltab2x64(:,:,640))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(52),n2h32(640))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,641),heltab2x64(:,:,641))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(54),n2h32(641))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[32,2,8,1,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,642),heltab2x64(:,:,642))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(56),n2h32(642))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,643),heltab2x64(:,:,643))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(643))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[32,2,8,1,20],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,644),heltab2x64(:,:,644))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(58),n2h32(644))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,645),heltab2x64(:,:,645))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(63),n2h32(645))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[32,2,8,1,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,646),heltab2x64(:,:,646))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(60),n2h32(646))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[32,2,8,1,20],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,647),heltab2x64(:,:,647))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(62),n2h32(647))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[32,2,8,1,20],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,648),heltab2x64(:,:,648))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(64),n2h32(648))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,649),heltab2x64(:,:,649))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(649))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[32,2,20,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,650),heltab2x64(:,:,650))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(66),n2h32(650))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,651),heltab2x64(:,:,651))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(71),n2h32(651))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[32,2,20,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,652),heltab2x64(:,:,652))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(68),n2h32(652))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,653),heltab2x64(:,:,653))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(70),n2h32(653))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[32,2,20,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,654),heltab2x64(:,:,654))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(72),n2h32(654))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[32,2,20,1,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,655),heltab2x64(:,:,655))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(77),n2h32(655))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[32,2,20,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,656),heltab2x64(:,:,656))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(74),n2h32(656))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,657),heltab2x64(:,:,657))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(79),n2h32(657))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[32,1,20,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,658),heltab2x64(:,:,658))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(76),n2h32(658))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,659),heltab2x64(:,:,659))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(78),n2h32(659))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[32,1,20,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,660),heltab2x64(:,:,660))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(80),n2h32(660))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,661),heltab2x64(:,:,661))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(85),n2h32(661))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[32,1,20,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,662),heltab2x64(:,:,662))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(82),n2h32(662))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,663),heltab2x64(:,:,663))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(663))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[32,1,20,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,664),heltab2x64(:,:,664))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(84),n2h32(664))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,665),heltab2x64(:,:,665))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(86),n2h32(665))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[32,1,20,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,666),heltab2x64(:,:,666))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(88),n2h32(666))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,667),heltab2x64(:,:,667))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(93),n2h32(667))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[32,1,20,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,668),heltab2x64(:,:,668))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(90),n2h32(668))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,669),heltab2x64(:,:,669))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(95),n2h32(669))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(5,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[32,1,20,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,670),heltab2x64(:,:,670))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(92),n2h32(670))
Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[32,1,20,2,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,671),heltab2x64(:,:,671))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(94),n2h32(671))
Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[32,1,20,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,672),heltab2x64(:,:,672))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(96),n2h32(672))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,673),heltab2x64(:,:,673))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(101),n2h32(673))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[32,2,1,4,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,674),heltab2x64(:,:,674))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(98),n2h32(674))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,675),heltab2x64(:,:,675))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(675))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[32,2,1,4,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,676),heltab2x64(:,:,676))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(100),n2h32(676))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,677),heltab2x64(:,:,677))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(102),n2h32(677))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[32,2,1,4,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,678),heltab2x64(:,:,678))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(104),n2h32(678))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[32,2,1,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,679),heltab2x64(:,:,679))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(679))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[32,2,1,4,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,680),heltab2x64(:,:,680))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(106),n2h32(680))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,681),heltab2x64(:,:,681))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(681))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[32,4,1,2,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,682),heltab2x64(:,:,682))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(108),n2h32(682))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,683),heltab2x64(:,:,683))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(110),n2h32(683))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[32,4,1,2,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,684),heltab2x64(:,:,684))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(112),n2h32(684))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,685),heltab2x64(:,:,685))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(117),n2h32(685))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[32,4,1,2,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,686),heltab2x64(:,:,686))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(114),n2h32(686))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,687),heltab2x64(:,:,687))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(119),n2h32(687))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[32,4,1,2,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,688),heltab2x64(:,:,688))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(116),n2h32(688))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,689),heltab2x64(:,:,689))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(118),n2h32(689))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[32,1,2,4,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,690),heltab2x64(:,:,690))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(120),n2h32(690))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,691),heltab2x64(:,:,691))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(125),n2h32(691))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[32,1,2,4,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,692),heltab2x64(:,:,692))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(122),n2h32(692))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,693),heltab2x64(:,:,693))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(127),n2h32(693))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[32,1,2,4,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,694),heltab2x64(:,:,694))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(124),n2h32(694))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[32,1,2,4,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,695),heltab2x64(:,:,695))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(126),n2h32(695))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[32,1,2,4,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,696),heltab2x64(:,:,696))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(128),n2h32(696))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,697),heltab2x64(:,:,697))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(133),n2h32(697))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[32,1,2,24,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,698),heltab2x64(:,:,698))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(130),n2h32(698))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,699),heltab2x64(:,:,699))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(135),n2h32(699))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[32,1,2,24,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,700),heltab2x64(:,:,700))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(132),n2h32(700))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,701),heltab2x64(:,:,701))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(134),n2h32(701))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[32,1,2,24,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,702),heltab2x64(:,:,702))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(136),n2h32(702))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[32,1,2,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,703),heltab2x64(:,:,703))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(141),n2h32(703))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[32,1,2,24,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,704),heltab2x64(:,:,704))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(138),n2h32(704))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,705),heltab2x64(:,:,705))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(143),n2h32(705))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[32,4,2,1,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,706),heltab2x64(:,:,706))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(140),n2h32(706))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,707),heltab2x64(:,:,707))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(142),n2h32(707))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[32,4,2,1,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,708),heltab2x64(:,:,708))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(144),n2h32(708))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,709),heltab2x64(:,:,709))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(149),n2h32(709))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[32,4,2,1,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,710),heltab2x64(:,:,710))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(146),n2h32(710))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,711),heltab2x64(:,:,711))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(151),n2h32(711))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[32,4,2,1,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,712),heltab2x64(:,:,712))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(148),n2h32(712))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,713),heltab2x64(:,:,713))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(150),n2h32(713))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[32,2,1,24,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,714),heltab2x64(:,:,714))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(152),n2h32(714))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,715),heltab2x64(:,:,715))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(157),n2h32(715))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[32,2,1,24,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,716),heltab2x64(:,:,716))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(154),n2h32(716))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,717),heltab2x64(:,:,717))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(159),n2h32(717))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[32,2,1,24,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,718),heltab2x64(:,:,718))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(156),n2h32(718))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[32,2,1,24,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,719),heltab2x64(:,:,719))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(158),n2h32(719))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[32,2,1,24,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,720),heltab2x64(:,:,720))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(160),n2h32(720))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,721),heltab2x64(:,:,721))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(165),n2h32(721))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[32,1,4,2,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,722),heltab2x64(:,:,722))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(162),n2h32(722))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,723),heltab2x64(:,:,723))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(167),n2h32(723))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[32,1,4,2,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,724),heltab2x64(:,:,724))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(164),n2h32(724))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,725),heltab2x64(:,:,725))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(166),n2h32(725))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[32,1,4,2,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,726),heltab2x64(:,:,726))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(168),n2h32(726))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[32,1,4,2,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,727),heltab2x64(:,:,727))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(173),n2h32(727))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[32,1,4,2,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,728),heltab2x64(:,:,728))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(170),n2h32(728))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,729),heltab2x64(:,:,729))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(175),n2h32(729))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[32,1,4,24,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,730),heltab2x64(:,:,730))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(172),n2h32(730))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,731),heltab2x64(:,:,731))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(174),n2h32(731))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[32,1,4,24,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,732),heltab2x64(:,:,732))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(176),n2h32(732))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,733),heltab2x64(:,:,733))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(181),n2h32(733))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[32,1,4,24,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,734),heltab2x64(:,:,734))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(178),n2h32(734))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,735),heltab2x64(:,:,735))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(183),n2h32(735))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[32,1,4,24,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,736),heltab2x64(:,:,736))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(180),n2h32(736))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,737),heltab2x64(:,:,737))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(182),n2h32(737))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[32,2,4,1,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,738),heltab2x64(:,:,738))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(184),n2h32(738))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,739),heltab2x64(:,:,739))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(189),n2h32(739))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[32,2,4,1,24],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,740),heltab2x64(:,:,740))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(186),n2h32(740))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,741),heltab2x64(:,:,741))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(191),n2h32(741))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[32,2,4,1,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,742),heltab2x64(:,:,742))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(188),n2h32(742))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[32,2,4,1,24],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,743),heltab2x64(:,:,743))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(190),n2h32(743))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[32,2,4,1,24],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,744),heltab2x64(:,:,744))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(192),n2h32(744))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,745),heltab2x64(:,:,745))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(197),n2h32(745))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[32,2,24,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,746),heltab2x64(:,:,746))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(194),n2h32(746))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,747),heltab2x64(:,:,747))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(199),n2h32(747))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[32,2,24,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,748),heltab2x64(:,:,748))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(196),n2h32(748))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,749),heltab2x64(:,:,749))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(198),n2h32(749))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[32,2,24,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,750),heltab2x64(:,:,750))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(200),n2h32(750))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[32,2,24,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,751),heltab2x64(:,:,751))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(205),n2h32(751))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[32,2,24,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,752),heltab2x64(:,:,752))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(202),n2h32(752))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,753),heltab2x64(:,:,753))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(207),n2h32(753))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[32,1,24,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,754),heltab2x64(:,:,754))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(204),n2h32(754))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,755),heltab2x64(:,:,755))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(206),n2h32(755))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[32,1,24,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,756),heltab2x64(:,:,756))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(208),n2h32(756))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,757),heltab2x64(:,:,757))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(213),n2h32(757))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[32,1,24,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,758),heltab2x64(:,:,758))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(210),n2h32(758))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,759),heltab2x64(:,:,759))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(215),n2h32(759))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[32,1,24,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,760),heltab2x64(:,:,760))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(212),n2h32(760))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,761),heltab2x64(:,:,761))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(214),n2h32(761))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[32,1,24,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,762),heltab2x64(:,:,762))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(216),n2h32(762))
Gcoeff(:)%j = (c(4)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,763),heltab2x64(:,:,763))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(221),n2h32(763))
Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[32,1,24,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,764),heltab2x64(:,:,764))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(218),n2h32(764))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,765),heltab2x64(:,:,765))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(223),n2h32(765))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(3,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[32,1,24,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,766),heltab2x64(:,:,766))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(220),n2h32(766))
Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[32,1,24,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,767),heltab2x64(:,:,767))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(222),n2h32(767))
Gcoeff(:)%j = (c(1)*(M(5,:)%j-M(6,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[32,1,24,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,768),heltab2x64(:,:,768))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(224),n2h32(768))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,769))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(721))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[36,8,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,770))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(2),n2h16(722))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,771))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(4),n2h16(723))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[36,8,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,772))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(5),n2h16(724))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,773))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(6),n2h16(725))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[36,8,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,6),heltab2x64(:,:,774))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(7),n2h16(726))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[36,8,1,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,775))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(8),n2h16(727))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[36,8,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,8),heltab2x64(:,:,776))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(10),n2h16(728))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,777))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(11),n2h16(729))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[36,2,1,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,778))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(12),n2h16(730))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,779))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(13),n2h16(731))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[36,2,1,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,12),heltab2x64(:,:,780))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(14),n2h16(732))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,781))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(16),n2h16(733))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[36,2,1,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,14),heltab2x64(:,:,782))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(17),n2h16(734))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,783))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(18),n2h16(735))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[36,2,1,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,16),heltab2x64(:,:,784))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(19),n2h16(736))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,785))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(20),n2h16(737))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[36,8,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,18),heltab2x64(:,:,786))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(22),n2h16(738))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,19),heltab2x64(:,:,787))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(23),n2h16(739))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[36,8,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,788))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(24),n2h16(740))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,789))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(25),n2h16(741))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[36,8,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,790))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(26),n2h16(742))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[36,8,2,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,791))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(28),n2h16(743))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[36,8,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,792))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(29),n2h16(744))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,793))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(30),n2h16(745))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[36,2,1,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,26),heltab2x64(:,:,794))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(31),n2h16(746))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,27),heltab2x64(:,:,795))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(32),n2h16(747))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[36,2,1,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,28),heltab2x64(:,:,796))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(34),n2h16(748))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,29),heltab2x64(:,:,797))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(35),n2h16(749))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[36,2,1,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,30),heltab2x64(:,:,798))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(36),n2h16(750))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[36,2,1,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,799))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(37),n2h16(751))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[36,2,1,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,32),heltab2x64(:,:,800))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(38),n2h16(752))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,33),heltab2x64(:,:,801))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(40),n2h16(753))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[36,1,2,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,34),heltab2x64(:,:,802))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(41),n2h16(754))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,35),heltab2x64(:,:,803))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(42),n2h16(755))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[36,1,2,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,36),heltab2x64(:,:,804))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(43),n2h16(756))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,37),heltab2x64(:,:,805))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(44),n2h16(757))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[36,1,2,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,38),heltab2x64(:,:,806))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(46),n2h16(758))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,39),heltab2x64(:,:,807))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(47),n2h16(759))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[36,1,2,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,40),heltab2x64(:,:,808))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(48),n2h16(760))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,41),heltab2x64(:,:,809))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(49),n2h16(761))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[36,1,2,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,42),heltab2x64(:,:,810))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(50),n2h16(762))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,43),heltab2x64(:,:,811))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(52),n2h16(763))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[36,1,2,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,44),heltab2x64(:,:,812))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(53),n2h16(764))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,45),heltab2x64(:,:,813))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(54),n2h16(765))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[36,1,2,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,46),heltab2x64(:,:,814))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(55),n2h16(766))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[36,1,2,16,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,47),heltab2x64(:,:,815))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(56),n2h16(767))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[36,1,2,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,48),heltab2x64(:,:,816))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(58),n2h16(768))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,49),heltab2x64(:,:,817))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(59),n2h16(769))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[36,2,8,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,50),heltab2x64(:,:,818))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(60),n2h16(770))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,51),heltab2x64(:,:,819))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(61),n2h16(771))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[36,2,8,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,52),heltab2x64(:,:,820))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(62),n2h16(772))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,53),heltab2x64(:,:,821))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(64),n2h16(773))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[36,2,8,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,54),heltab2x64(:,:,822))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(65),n2h16(774))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[36,2,8,1,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,55),heltab2x64(:,:,823))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(66),n2h16(775))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[36,2,8,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,56),heltab2x64(:,:,824))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(67),n2h16(776))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,57),heltab2x64(:,:,825))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(68),n2h16(777))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[36,2,16,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,58),heltab2x64(:,:,826))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(70),n2h16(778))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,59),heltab2x64(:,:,827))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(71),n2h16(779))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[36,2,16,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,60),heltab2x64(:,:,828))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(72),n2h16(780))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,61),heltab2x64(:,:,829))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(73),n2h16(781))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[36,2,16,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,62),heltab2x64(:,:,830))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(74),n2h16(782))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,63),heltab2x64(:,:,831))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(76),n2h16(783))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[36,2,16,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,64),heltab2x64(:,:,832))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(77),n2h16(784))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,65),heltab2x64(:,:,833))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(78),n2h16(785))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[36,1,8,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,66),heltab2x64(:,:,834))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(79),n2h16(786))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,67),heltab2x64(:,:,835))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(80),n2h16(787))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[36,1,8,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,68),heltab2x64(:,:,836))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(82),n2h16(788))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,69),heltab2x64(:,:,837))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(83),n2h16(789))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[36,1,8,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,70),heltab2x64(:,:,838))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(84),n2h16(790))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[36,1,8,2,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,71),heltab2x64(:,:,839))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(85),n2h16(791))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[36,1,8,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,72),heltab2x64(:,:,840))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(86),n2h16(792))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,73),heltab2x64(:,:,841))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(88),n2h16(793))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[36,1,8,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,74),heltab2x64(:,:,842))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(89),n2h16(794))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,75),heltab2x64(:,:,843))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(90),n2h16(795))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[36,1,8,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,76),heltab2x64(:,:,844))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(91),n2h16(796))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,77),heltab2x64(:,:,845))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(92),n2h16(797))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[36,1,8,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,78),heltab2x64(:,:,846))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(94),n2h16(798))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[36,1,8,16,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,79),heltab2x64(:,:,847))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(95),n2h16(799))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[36,1,8,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,80),heltab2x64(:,:,848))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(96),n2h16(800))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,81),heltab2x64(:,:,849))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(97),n2h16(801))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[36,1,16,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,82),heltab2x64(:,:,850))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(98),n2h16(802))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,83),heltab2x64(:,:,851))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(100),n2h16(803))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[36,1,16,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,84),heltab2x64(:,:,852))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(101),n2h16(804))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,85),heltab2x64(:,:,853))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(102),n2h16(805))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[36,1,16,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,86),heltab2x64(:,:,854))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(103),n2h16(806))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,87),heltab2x64(:,:,855))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(104),n2h16(807))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[36,1,16,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,88),heltab2x64(:,:,856))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(106),n2h16(808))
Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,89),heltab2x64(:,:,857))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(107),n2h16(809))
Gcoeff(:)%j = (c(3)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[36,1,16,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,90),heltab2x64(:,:,858))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMT,G1H16(108),n2h16(810))
Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,91),heltab2x64(:,:,859))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(109),n2h16(811))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[36,1,16,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,92),heltab2x64(:,:,860))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(110),n2h16(812))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,93),heltab2x64(:,:,861))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(112),n2h16(813))
Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(6,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[36,1,16,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,94),heltab2x64(:,:,862))
  call Hloop_A_Q(ntryL,G0H16(1),36,nMB,G1H16(113),n2h16(814))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[36,1,16,8,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,95),heltab2x64(:,:,863))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(114),n2h16(815))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[36,1,16,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,96),heltab2x64(:,:,864))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMB,G1H16(115),n2h16(816))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,97),heltab2x64(:,:,865))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(116),n2h16(817))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[40,4,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,98),heltab2x64(:,:,866))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(118),n2h16(818))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,99),heltab2x64(:,:,867))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(119),n2h16(819))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[40,4,1,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,100),heltab2x64(:,:,868))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(120),n2h16(820))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,101),heltab2x64(:,:,869))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(121),n2h16(821))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[40,4,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,102),heltab2x64(:,:,870))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(122),n2h16(822))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[40,4,1,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,103),heltab2x64(:,:,871))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(124),n2h16(823))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[40,4,1,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,104),heltab2x64(:,:,872))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(125),n2h16(824))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,105),heltab2x64(:,:,873))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(126),n2h16(825))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[40,2,1,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,106),heltab2x64(:,:,874))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(127),n2h16(826))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,107),heltab2x64(:,:,875))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(128),n2h16(827))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[40,2,1,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,108),heltab2x64(:,:,876))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(130),n2h16(828))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,109),heltab2x64(:,:,877))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(131),n2h16(829))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[40,2,1,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,110),heltab2x64(:,:,878))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(132),n2h16(830))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,111),heltab2x64(:,:,879))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(133),n2h16(831))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[40,2,1,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,112),heltab2x64(:,:,880))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(134),n2h16(832))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,113),heltab2x64(:,:,881))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(136),n2h16(833))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[40,4,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,114),heltab2x64(:,:,882))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(137),n2h16(834))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,115),heltab2x64(:,:,883))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(138),n2h16(835))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[40,4,2,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,116),heltab2x64(:,:,884))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(139),n2h16(836))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,117),heltab2x64(:,:,885))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(140),n2h16(837))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[40,4,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,118),heltab2x64(:,:,886))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(142),n2h16(838))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[40,4,2,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,119),heltab2x64(:,:,887))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(143),n2h16(839))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[40,4,2,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,120),heltab2x64(:,:,888))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(144),n2h16(840))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,121),heltab2x64(:,:,889))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(145),n2h16(841))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[40,2,1,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,122),heltab2x64(:,:,890))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(146),n2h16(842))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,123),heltab2x64(:,:,891))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(148),n2h16(843))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[40,2,1,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,124),heltab2x64(:,:,892))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(149),n2h16(844))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,125),heltab2x64(:,:,893))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(150),n2h16(845))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[40,2,1,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,126),heltab2x64(:,:,894))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(151),n2h16(846))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[40,2,1,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,127),heltab2x64(:,:,895))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(152),n2h16(847))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[40,2,1,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,128),heltab2x64(:,:,896))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(154),n2h16(848))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,129),heltab2x64(:,:,897))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(155),n2h16(849))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[40,1,2,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,130),heltab2x64(:,:,898))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(156),n2h16(850))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,131),heltab2x64(:,:,899))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(157),n2h16(851))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[40,1,2,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,132),heltab2x64(:,:,900))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(158),n2h16(852))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,133),heltab2x64(:,:,901))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(160),n2h16(853))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[40,1,2,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,134),heltab2x64(:,:,902))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(161),n2h16(854))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,135),heltab2x64(:,:,903))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(162),n2h16(855))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[40,1,2,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,136),heltab2x64(:,:,904))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(163),n2h16(856))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,137),heltab2x64(:,:,905))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(164),n2h16(857))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[40,1,2,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,138),heltab2x64(:,:,906))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(166),n2h16(858))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,139),heltab2x64(:,:,907))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(167),n2h16(859))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[40,1,2,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,140),heltab2x64(:,:,908))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(168),n2h16(860))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,141),heltab2x64(:,:,909))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(169),n2h16(861))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[40,1,2,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,142),heltab2x64(:,:,910))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(170),n2h16(862))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[40,1,2,16,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,143),heltab2x64(:,:,911))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(172),n2h16(863))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[40,1,2,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,144),heltab2x64(:,:,912))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(173),n2h16(864))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,145),heltab2x64(:,:,913))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(174),n2h16(865))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[40,2,4,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,146),heltab2x64(:,:,914))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(175),n2h16(866))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,147),heltab2x64(:,:,915))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(176),n2h16(867))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[40,2,4,1,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,148),heltab2x64(:,:,916))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(178),n2h16(868))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,149),heltab2x64(:,:,917))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(179),n2h16(869))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[40,2,4,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,150),heltab2x64(:,:,918))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(180),n2h16(870))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[40,2,4,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,151),heltab2x64(:,:,919))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(181),n2h16(871))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[40,2,4,1,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,152),heltab2x64(:,:,920))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(182),n2h16(872))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,153),heltab2x64(:,:,921))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(184),n2h16(873))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[40,2,16,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,154),heltab2x64(:,:,922))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(185),n2h16(874))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,155),heltab2x64(:,:,923))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(186),n2h16(875))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[40,2,16,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,156),heltab2x64(:,:,924))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(187),n2h16(876))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,157),heltab2x64(:,:,925))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(188),n2h16(877))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[40,2,16,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,158),heltab2x64(:,:,926))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(190),n2h16(878))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,159),heltab2x64(:,:,927))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(191),n2h16(879))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[40,2,16,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,160),heltab2x64(:,:,928))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(192),n2h16(880))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,161),heltab2x64(:,:,929))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(193),n2h16(881))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[40,1,4,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,162),heltab2x64(:,:,930))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(194),n2h16(882))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,163),heltab2x64(:,:,931))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(196),n2h16(883))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[40,1,4,2,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,164),heltab2x64(:,:,932))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(197),n2h16(884))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,165),heltab2x64(:,:,933))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(198),n2h16(885))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[40,1,4,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,166),heltab2x64(:,:,934))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(199),n2h16(886))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[40,1,4,2,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,167),heltab2x64(:,:,935))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(200),n2h16(887))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[40,1,4,2,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,168),heltab2x64(:,:,936))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(202),n2h16(888))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,169),heltab2x64(:,:,937))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(203),n2h16(889))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[40,1,4,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,170),heltab2x64(:,:,938))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(204),n2h16(890))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,171),heltab2x64(:,:,939))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(205),n2h16(891))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[40,1,4,16,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,172),heltab2x64(:,:,940))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(206),n2h16(892))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,173),heltab2x64(:,:,941))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(208),n2h16(893))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[40,1,4,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,174),heltab2x64(:,:,942))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(209),n2h16(894))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[40,1,4,16,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,175),heltab2x64(:,:,943))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(210),n2h16(895))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[40,1,4,16,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,176),heltab2x64(:,:,944))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(211),n2h16(896))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,177),heltab2x64(:,:,945))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(212),n2h16(897))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[40,1,16,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,178),heltab2x64(:,:,946))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(214),n2h16(898))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,179),heltab2x64(:,:,947))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(215),n2h16(899))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[40,1,16,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,180),heltab2x64(:,:,948))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(216),n2h16(900))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,181),heltab2x64(:,:,949))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(217),n2h16(901))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[40,1,16,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,182),heltab2x64(:,:,950))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(218),n2h16(902))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,183),heltab2x64(:,:,951))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(220),n2h16(903))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[40,1,16,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,184),heltab2x64(:,:,952))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(221),n2h16(904))
Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,185),heltab2x64(:,:,953))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(222),n2h16(905))
Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[40,1,16,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,186),heltab2x64(:,:,954))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(223),n2h16(906))
Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,187),heltab2x64(:,:,955))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(224),n2h16(907))
Gcoeff(:)%j = (c(3)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[40,1,16,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,188),heltab2x64(:,:,956))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(226),n2h16(908))
Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,189),heltab2x64(:,:,957))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(227),n2h16(909))
Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(5,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[40,1,16,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,190),heltab2x64(:,:,958))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMB,G1H16(228),n2h16(910))
Gcoeff(:)%j = (c(2)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[40,1,16,4,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,191),heltab2x64(:,:,959))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(229),n2h16(911))
Gcoeff(:)%j = (c(1)*(M(3,:)%j-M(4,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[40,1,16,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,192),heltab2x64(:,:,960))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(230),n2h16(912))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,193),heltab2x64(:,:,961))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(232),n2h16(913))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[48,4,1,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,194),heltab2x64(:,:,962))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(233),n2h16(914))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,195),heltab2x64(:,:,963))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(234),n2h16(915))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(964),h0tab(:,964),[48,4,1,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,196),heltab2x64(:,:,964))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(235),n2h16(916))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(965),h0tab(:,965),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,197),heltab2x64(:,:,965))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(236),n2h16(917))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(966),h0tab(:,966),[48,4,1,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,198),heltab2x64(:,:,966))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(238),n2h16(918))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(967),h0tab(:,967),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,199),heltab2x64(:,:,967))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(239),n2h16(919))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(968),h0tab(:,968),[48,4,1,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,200),heltab2x64(:,:,968))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(240),n2h16(920))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(969),h0tab(:,969),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,201),heltab2x64(:,:,969))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(241),n2h16(921))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(970),h0tab(:,970),[48,2,1,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,202),heltab2x64(:,:,970))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(242),n2h16(922))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(971),h0tab(:,971),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,203),heltab2x64(:,:,971))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(244),n2h16(923))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(972),h0tab(:,972),[48,2,1,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,204),heltab2x64(:,:,972))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(245),n2h16(924))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(973),h0tab(:,973),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,205),heltab2x64(:,:,973))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(246),n2h16(925))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(974),h0tab(:,974),[48,2,1,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,206),heltab2x64(:,:,974))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(247),n2h16(926))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(975),h0tab(:,975),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,207),heltab2x64(:,:,975))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(248),n2h16(927))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(976),h0tab(:,976),[48,2,1,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,208),heltab2x64(:,:,976))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(250),n2h16(928))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,209),heltab2x64(:,:,977))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(251),n2h16(929))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[48,4,2,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,210),heltab2x64(:,:,978))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(252),n2h16(930))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,211),heltab2x64(:,:,979))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(253),n2h16(931))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[48,4,2,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,212),heltab2x64(:,:,980))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(254),n2h16(932))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,213),heltab2x64(:,:,981))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(256),n2h16(933))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[48,4,2,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,214),heltab2x64(:,:,982))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(257),n2h16(934))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,215),heltab2x64(:,:,983))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(258),n2h16(935))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[48,4,2,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,216),heltab2x64(:,:,984))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(259),n2h16(936))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,217),heltab2x64(:,:,985))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(260),n2h16(937))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[48,2,1,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,218),heltab2x64(:,:,986))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(262),n2h16(938))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,219),heltab2x64(:,:,987))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(263),n2h16(939))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[48,2,1,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,220),heltab2x64(:,:,988))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(264),n2h16(940))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,221),heltab2x64(:,:,989))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(265),n2h16(941))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[48,2,1,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,222),heltab2x64(:,:,990))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(266),n2h16(942))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,223),heltab2x64(:,:,991))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(268),n2h16(943))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[48,2,1,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,224),heltab2x64(:,:,992))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(269),n2h16(944))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,225),heltab2x64(:,:,993))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(270),n2h16(945))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[48,1,2,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,226),heltab2x64(:,:,994))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(271),n2h16(946))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,227),heltab2x64(:,:,995))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(272),n2h16(947))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[48,1,2,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,228),heltab2x64(:,:,996))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(274),n2h16(948))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,229),heltab2x64(:,:,997))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(275),n2h16(949))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[48,1,2,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,230),heltab2x64(:,:,998))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(276),n2h16(950))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,231),heltab2x64(:,:,999))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(277),n2h16(951))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[48,1,2,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,232),heltab2x64(:,:,1000))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(278),n2h16(952))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,233),heltab2x64(:,:,1001))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(280),n2h16(953))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[48,1,2,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,234),heltab2x64(:,:,1002))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(281),n2h16(954))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,235),heltab2x64(:,:,1003))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(282),n2h16(955))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[48,1,2,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,236),heltab2x64(:,:,1004))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(283),n2h16(956))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,237),heltab2x64(:,:,1005))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(284),n2h16(957))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[48,1,2,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,238),heltab2x64(:,:,1006))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(286),n2h16(958))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,239),heltab2x64(:,:,1007))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(287),n2h16(959))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[48,1,2,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,240),heltab2x64(:,:,1008))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(288),n2h16(960))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,241),heltab2x64(:,:,1009))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(289),n2h16(961))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[48,2,4,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,242),heltab2x64(:,:,1010))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(290),n2h16(962))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,243),heltab2x64(:,:,1011))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(292),n2h16(963))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[48,2,4,1,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,244),heltab2x64(:,:,1012))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(293),n2h16(964))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,245),heltab2x64(:,:,1013))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(294),n2h16(965))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[48,2,4,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,246),heltab2x64(:,:,1014))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(295),n2h16(966))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,247),heltab2x64(:,:,1015))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(296),n2h16(967))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[48,2,4,1,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,248),heltab2x64(:,:,1016))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(298),n2h16(968))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,249),heltab2x64(:,:,1017))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(299),n2h16(969))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[48,2,8,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,250),heltab2x64(:,:,1018))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(300),n2h16(970))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,251),heltab2x64(:,:,1019))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(301),n2h16(971))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[48,2,8,1,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,252),heltab2x64(:,:,1020))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(302),n2h16(972))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,253),heltab2x64(:,:,1021))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(304),n2h16(973))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[48,2,8,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,254),heltab2x64(:,:,1022))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(305),n2h16(974))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,255),heltab2x64(:,:,1023))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(306),n2h16(975))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[48,2,8,1,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,256),heltab2x64(:,:,1024))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(307),n2h16(976))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,257),heltab2x64(:,:,1025))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(308),n2h16(977))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[48,1,4,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,258),heltab2x64(:,:,1026))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(310),n2h16(978))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,259),heltab2x64(:,:,1027))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(311),n2h16(979))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[48,1,4,2,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,260),heltab2x64(:,:,1028))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(312),n2h16(980))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,261),heltab2x64(:,:,1029))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(313),n2h16(981))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[48,1,4,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,262),heltab2x64(:,:,1030))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(314),n2h16(982))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,263),heltab2x64(:,:,1031))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(316),n2h16(983))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[48,1,4,2,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,264),heltab2x64(:,:,1032))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(317),n2h16(984))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,265),heltab2x64(:,:,1033))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(318),n2h16(985))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[48,1,4,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,266),heltab2x64(:,:,1034))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(319),n2h16(986))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,267),heltab2x64(:,:,1035))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(320),n2h16(987))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[48,1,4,8,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,268),heltab2x64(:,:,1036))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(322),n2h16(988))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,269),heltab2x64(:,:,1037))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(323),n2h16(989))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[48,1,4,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,270),heltab2x64(:,:,1038))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(324),n2h16(990))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,271),heltab2x64(:,:,1039))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(325),n2h16(991))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[48,1,4,8,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,272),heltab2x64(:,:,1040))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(326),n2h16(992))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,273),heltab2x64(:,:,1041))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(328),n2h16(993))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[48,1,8,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,274),heltab2x64(:,:,1042))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(329),n2h16(994))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,275),heltab2x64(:,:,1043))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(330),n2h16(995))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[48,1,8,2,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,276),heltab2x64(:,:,1044))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(331),n2h16(996))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,277),heltab2x64(:,:,1045))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(332),n2h16(997))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[48,1,8,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,278),heltab2x64(:,:,1046))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(334),n2h16(998))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,279),heltab2x64(:,:,1047))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(335),n2h16(999))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[48,1,8,2,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,280),heltab2x64(:,:,1048))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(336),n2h16(1000))
Gcoeff(:)%j = (c(4)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,281),heltab2x64(:,:,1049))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(337),n2h16(1001))
Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[48,1,8,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,282),heltab2x64(:,:,1050))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(338),n2h16(1002))
Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,283),heltab2x64(:,:,1051))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(340),n2h16(1003))
Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[48,1,8,4,2],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,284),heltab2x64(:,:,1052))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(341),n2h16(1004))
Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,285),heltab2x64(:,:,1053))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(342),n2h16(1005))
Gcoeff(:)%j = (c(1)*(M(4,:)%j-M(6,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[48,1,8,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,286),heltab2x64(:,:,1054))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(343),n2h16(1006))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,287),heltab2x64(:,:,1055))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(344),n2h16(1007))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[48,1,8,4,2],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,288),heltab2x64(:,:,1056))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(346),n2h16(1008))
  call ol_merge(ntryL,G1H16(131),[G1H16(126),G1H16(3)])
  call ol_merge(ntryL,G1H16(127),[G1H16(9)])
  call ol_merge(ntryL,G1H16(133),[G1H16(128),G1H16(15)])
  call ol_merge(ntryL,G1H16(130),[G1H16(21)])
  call ol_merge(ntryL,G1H16(132),[G1H16(27)])
  call ol_merge(ntryL,G1H16(134),[G1H16(33)])
  call ol_merge(ntryL,G1H16(44),[G1H16(40),G1H16(39)])
  call ol_merge(ntryL,G1H16(41),[G1H16(45)])
  call ol_merge(ntryL,G1H16(47),[G1H16(42),G1H16(51)])
  call ol_merge(ntryL,G1H16(43),[G1H16(57)])
  call ol_merge(ntryL,G1H16(46),[G1H16(63)])
  call ol_merge(ntryL,G1H16(48),[G1H16(69)])
  call ol_merge(ntryL,G1H16(121),[G1H16(116),G1H16(75)])
  call ol_merge(ntryL,G1H16(118),[G1H16(81)])
  call ol_merge(ntryL,G1H16(124),[G1H16(119),G1H16(87)])
  call ol_merge(ntryL,G1H16(120),[G1H16(93)])
  call ol_merge(ntryL,G1H16(122),[G1H16(99)])
  call ol_merge(ntryL,G1H16(125),[G1H16(105)])
  call ol_merge(ntryL,G1H16(54),[G1H16(49),G1H16(111)])
  call ol_merge(ntryL,G1H16(50),[G1H16(117)])
  call ol_merge(ntryL,G1H16(56),[G1H16(52),G1H16(123)])
  call ol_merge(ntryL,G1H16(53),[G1H16(129)])
  call ol_merge(ntryL,G1H16(55),[G1H16(135)])
  call ol_merge(ntryL,G1H16(58),[G1H16(141)])
  call ol_merge(ntryL,G1H16(160),[G1H16(155),G1H16(219)])
  call ol_merge(ntryL,G1H16(156),[G1H16(225)])
  call ol_merge(ntryL,G1H16(162),[G1H16(157),G1H16(231)])
  call ol_merge(ntryL,G1H16(158),[G1H16(237)])
  call ol_merge(ntryL,G1H16(161),[G1H16(243)])
  call ol_merge(ntryL,G1H16(163),[G1H16(249)])
  call ol_merge(ntryL,G1H16(16),[G1H16(11),G1H16(255)])
  call ol_merge(ntryL,G1H16(12),[G1H16(261)])
  call ol_merge(ntryL,G1H16(18),[G1H16(13),G1H16(267)])
  call ol_merge(ntryL,G1H16(14),[G1H16(273)])
  call ol_merge(ntryL,G1H16(17),[G1H16(279)])
  call ol_merge(ntryL,G1H16(19),[G1H16(285)])
  call ol_merge(ntryL,G1H16(6),[G1H16(1),G1H16(291)])
  call ol_merge(ntryL,G1H16(2),[G1H16(297)])
  call ol_merge(ntryL,G1H16(8),[G1H16(4),G1H16(303)])
  call ol_merge(ntryL,G1H16(5),[G1H16(309)])
  call ol_merge(ntryL,G1H16(7),[G1H16(315)])
  call ol_merge(ntryL,G1H16(10),[G1H16(321)])
  call ol_merge(ntryL,G1H16(140),[G1H16(136),G1H16(435)])
  call ol_merge(ntryL,G1H16(137),[G1H16(441)])
  call ol_merge(ntryL,G1H16(143),[G1H16(138),G1H16(447)])
  call ol_merge(ntryL,G1H16(139),[G1H16(453)])
  call ol_merge(ntryL,G1H16(142),[G1H16(459)])
  call ol_merge(ntryL,G1H16(144),[G1H16(465)])
  call ol_merge(ntryL,G1H16(35),[G1H16(30),G1H16(471)])
  call ol_merge(ntryL,G1H16(31),[G1H16(477)])
  call ol_merge(ntryL,G1H16(37),[G1H16(32),G1H16(483)])
  call ol_merge(ntryL,G1H16(34),[G1H16(489)])
  call ol_merge(ntryL,G1H16(36),[G1H16(495)])
  call ol_merge(ntryL,G1H16(38),[G1H16(501)])
  call ol_merge(ntryL,G1H16(25),[G1H16(20),G1H16(507)])
  call ol_merge(ntryL,G1H16(22),[G1H16(513)])
  call ol_merge(ntryL,G1H16(28),[G1H16(23),G1H16(519)])
  call ol_merge(ntryL,G1H16(24),[G1H16(525)])
  call ol_merge(ntryL,G1H16(26),[G1H16(531)])
  call ol_merge(ntryL,G1H16(29),[G1H16(537)])
  call ol_merge(ntryL,G1H16(198),[G1H16(193),G1H16(867)])
  call ol_merge(ntryL,G1H16(194),[G1H16(873)])
  call ol_merge(ntryL,G1H16(200),[G1H16(196),G1H16(879)])
  call ol_merge(ntryL,G1H16(197),[G1H16(885)])
  call ol_merge(ntryL,G1H16(199),[G1H16(891)])
  call ol_merge(ntryL,G1H16(202),[G1H16(897)])
  call ol_merge(ntryL,G1H16(85),[G1H16(80),G1H16(939)])
  call ol_merge(ntryL,G1H16(82),[G1H16(945)])
  call ol_merge(ntryL,G1H16(83),[G1H16(78),G1H16(951)])
  call ol_merge(ntryL,G1H16(79),[G1H16(957)])
  call ol_merge(ntryL,G1H16(86),[G1H16(963)])
  call ol_merge(ntryL,G1H16(84),[G1H16(969)])
  call ol_merge(ntryL,G1H16(179),[G1H16(174),G1H16(1083)])
  call ol_merge(ntryL,G1H16(175),[G1H16(1089)])
  call ol_merge(ntryL,G1H16(181),[G1H16(176),G1H16(1095)])
  call ol_merge(ntryL,G1H16(178),[G1H16(1101)])
  call ol_merge(ntryL,G1H16(180),[G1H16(1107)])
  call ol_merge(ntryL,G1H16(182),[G1H16(1113)])
  call ol_merge(ntryL,G1H16(104),[G1H16(100),G1H16(1155)])
  call ol_merge(ntryL,G1H16(101),[G1H16(1161)])
  call ol_merge(ntryL,G1H16(102),[G1H16(97),G1H16(1167)])
  call ol_merge(ntryL,G1H16(98),[G1H16(1173)])
  call ol_merge(ntryL,G1H16(106),[G1H16(1179)])
  call ol_merge(ntryL,G1H16(103),[G1H16(1185)])
  call ol_merge(ntryL,G1H16(64),[G1H16(59),G1H16(1515)])
  call ol_merge(ntryL,G1H16(60),[G1H16(1521)])
  call ol_merge(ntryL,G1H16(66),[G1H16(61),G1H16(1527)])
  call ol_merge(ntryL,G1H16(62),[G1H16(1533)])
  call ol_merge(ntryL,G1H16(65),[G1H16(1539)])
  call ol_merge(ntryL,G1H16(67),[G1H16(1545)])
  call ol_merge(ntryL,G1H16(73),[G1H16(68),G1H16(1551)])
  call ol_merge(ntryL,G1H16(70),[G1H16(1557)])
  call ol_merge(ntryL,G1H16(76),[G1H16(71),G1H16(1563)])
  call ol_merge(ntryL,G1H16(72),[G1H16(1569)])
  call ol_merge(ntryL,G1H16(74),[G1H16(1575)])
  call ol_merge(ntryL,G1H16(77),[G1H16(1581)])
  call ol_merge(ntryL,G1H32(17),[G1H32(1)])
  call ol_merge(ntryL,G1H32(25),[G1H32(9)])
  call ol_merge(ntryL,G1H32(49),[G1H32(33)])
  call ol_merge(ntryL,G1H32(57),[G1H32(41)])
  call ol_merge(ntryL,G1H32(81),[G1H32(65)])
  call ol_merge(ntryL,G1H32(89),[G1H32(73)])
  call ol_merge(ntryL,G1H32(113),[G1H32(97)])
  call ol_merge(ntryL,G1H32(121),[G1H32(105)])
  call ol_merge(ntryL,G1H32(145),[G1H32(129)])
  call ol_merge(ntryL,G1H32(153),[G1H32(137)])
  call ol_merge(ntryL,G1H32(177),[G1H32(161)])
  call ol_merge(ntryL,G1H32(185),[G1H32(169)])
  call ol_merge(ntryL,G1H32(209),[G1H32(193)])
  call ol_merge(ntryL,G1H32(217),[G1H32(201)])
  call ol_merge(ntryL,G1H32(241),[G1H32(225)])
  call ol_merge(ntryL,G1H32(249),[G1H32(233)])
  call ol_merge(ntryL,G1H32(273),[G1H32(257)])
  call ol_merge(ntryL,G1H32(281),[G1H32(265)])
  call ol_merge(ntryL,G1H32(305),[G1H32(289)])
  call ol_merge(ntryL,G1H32(313),[G1H32(297)])
  call ol_merge(ntryL,G1H32(337),[G1H32(321)])
  call ol_merge(ntryL,G1H32(345),[G1H32(329)])
  call ol_merge(ntryL,G1H32(369),[G1H32(353)])
  call ol_merge(ntryL,G1H32(377),[G1H32(361)])
  call ol_merge(ntryL,G1H32(401),[G1H32(385)])
  call ol_merge(ntryL,G1H32(409),[G1H32(393)])
  call ol_merge(ntryL,G1H32(433),[G1H32(417)])
  call ol_merge(ntryL,G1H32(441),[G1H32(425)])
  call ol_merge(ntryL,G1H32(465),[G1H32(449)])
  call ol_merge(ntryL,G1H32(473),[G1H32(457)])
  call ol_merge(ntryL,G1H32(6),[G1H32(5)])
  call ol_merge(ntryL,G1H32(13),[G1H32(7)])
  call ol_merge(ntryL,G1H32(21),[G1H32(15)])
  call ol_merge(ntryL,G1H32(23),[G1H32(14)])
  call ol_merge(ntryL,G1H32(31),[G1H32(22)])
  call ol_merge(ntryL,G1H32(30),[G1H32(29)])
  call ol_merge(ntryL,G1H32(38),[G1H32(37)])
  call ol_merge(ntryL,G1H32(45),[G1H32(39)])
  call ol_merge(ntryL,G1H32(53),[G1H32(47)])
  call ol_merge(ntryL,G1H32(55),[G1H32(46)])
  call ol_merge(ntryL,G1H32(63),[G1H32(54)])
  call ol_merge(ntryL,G1H32(62),[G1H32(61)])
  call ol_merge(ntryL,G1H32(70),[G1H32(69)])
  call ol_merge(ntryL,G1H32(77),[G1H32(71)])
  call ol_merge(ntryL,G1H32(85),[G1H32(79)])
  call ol_merge(ntryL,G1H32(87),[G1H32(78)])
  call ol_merge(ntryL,G1H32(95),[G1H32(86)])
  call ol_merge(ntryL,G1H32(94),[G1H32(93)])
  call ol_merge(ntryL,G1H32(102),[G1H32(101)])
  call ol_merge(ntryL,G1H32(109),[G1H32(103)])
  call ol_merge(ntryL,G1H32(117),[G1H32(111)])
  call ol_merge(ntryL,G1H32(119),[G1H32(110)])
  call ol_merge(ntryL,G1H32(127),[G1H32(118)])
  call ol_merge(ntryL,G1H32(126),[G1H32(125)])
  call ol_merge(ntryL,G1H32(134),[G1H32(133)])
  call ol_merge(ntryL,G1H32(141),[G1H32(135)])
  call ol_merge(ntryL,G1H32(149),[G1H32(143)])
  call ol_merge(ntryL,G1H32(151),[G1H32(142)])
  call ol_merge(ntryL,G1H32(159),[G1H32(150)])
  call ol_merge(ntryL,G1H32(158),[G1H32(157)])
  call ol_merge(ntryL,G1H32(166),[G1H32(165)])
  call ol_merge(ntryL,G1H32(173),[G1H32(167)])
  call ol_merge(ntryL,G1H32(181),[G1H32(175)])
  call ol_merge(ntryL,G1H32(183),[G1H32(174)])
  call ol_merge(ntryL,G1H32(191),[G1H32(182)])
  call ol_merge(ntryL,G1H32(190),[G1H32(189)])
  call ol_merge(ntryL,G1H32(198),[G1H32(197)])
  call ol_merge(ntryL,G1H32(205),[G1H32(199)])
  call ol_merge(ntryL,G1H32(213),[G1H32(207)])
  call ol_merge(ntryL,G1H32(215),[G1H32(206)])
  call ol_merge(ntryL,G1H32(223),[G1H32(214)])
  call ol_merge(ntryL,G1H32(222),[G1H32(221)])
  call ol_merge(ntryL,G1H16(92),[G1H16(88)])
  call ol_merge(ntryL,G1H16(95),[G1H16(90)])
  call ol_merge(ntryL,G1H16(112),[G1H16(107)])
  call ol_merge(ntryL,G1H16(114),[G1H16(109)])
  call ol_merge(ntryL,G1H16(150),[G1H16(145)])
  call ol_merge(ntryL,G1H16(152),[G1H16(148)])
  call ol_merge(ntryL,G1H16(169),[G1H16(164)])
  call ol_merge(ntryL,G1H16(172),[G1H16(167)])
  call ol_merge(ntryL,G1H16(188),[G1H16(184)])
  call ol_merge(ntryL,G1H16(191),[G1H16(186)])
  call ol_merge(ntryL,G1H16(208),[G1H16(203)])
  call ol_merge(ntryL,G1H16(210),[G1H16(205)])
  call ol_merge(ntryL,G1H16(217),[G1H16(212)])
  call ol_merge(ntryL,G1H16(220),[G1H16(215)])
  call ol_merge(ntryL,G1H16(227),[G1H16(222)])
  call ol_merge(ntryL,G1H16(229),[G1H16(224)])
  call ol_merge(ntryL,G1H16(236),[G1H16(232)])
  call ol_merge(ntryL,G1H16(239),[G1H16(234)])
  call ol_merge(ntryL,G1H16(246),[G1H16(241)])
  call ol_merge(ntryL,G1H16(248),[G1H16(244)])
  call ol_merge(ntryL,G1H16(256),[G1H16(251)])
  call ol_merge(ntryL,G1H16(258),[G1H16(253)])
  call ol_merge(ntryL,G1H16(265),[G1H16(260)])
  call ol_merge(ntryL,G1H16(268),[G1H16(263)])
  call ol_merge(ntryL,G1H16(275),[G1H16(270)])
  call ol_merge(ntryL,G1H16(277),[G1H16(272)])
  call ol_merge(ntryL,G1H16(284),[G1H16(280)])
  call ol_merge(ntryL,G1H16(287),[G1H16(282)])
  call ol_merge(ntryL,G1H16(294),[G1H16(289)])
  call ol_merge(ntryL,G1H16(296),[G1H16(292)])
  call ol_merge(ntryL,G1H16(304),[G1H16(299)])
  call ol_merge(ntryL,G1H16(306),[G1H16(301)])
  call ol_merge(ntryL,G1H16(313),[G1H16(308)])
  call ol_merge(ntryL,G1H16(316),[G1H16(311)])
  call ol_merge(ntryL,G1H16(323),[G1H16(318)])
  call ol_merge(ntryL,G1H16(325),[G1H16(320)])
  call ol_merge(ntryL,G1H16(332),[G1H16(328)])
  call ol_merge(ntryL,G1H16(335),[G1H16(330)])
  call ol_merge(ntryL,G1H16(342),[G1H16(337)])
  call ol_merge(ntryL,G1H16(344),[G1H16(340)])
  call Hloop_QV_A(ntryL,G1H16(131),ex2(:),G1H8(5),m3h2x8(:,1801),heltab2x16(:,:,1801))
  call Hloop_Q_A(ntryL,G1H8(5),42,0,G2H8(1),n2h8(2521))
  call Hloop_QV_A(ntryL,G1H16(127),ex2(:),G1H8(6),m3h2x8(:,1802),heltab2x16(:,:,1802))
  call Hloop_Q_A(ntryL,G1H8(6),42,nMT,G2H8(4),n2h8(2522))
  call Hloop_AV_Q(ntryL,G1H16(133),ex2(:),G1H8(23),m3h2x8(:,1803),heltab2x16(:,:,1803))
  call Hloop_A_Q(ntryL,G1H8(23),42,0,G2H8(5),n2h8(2523))
  call Hloop_AV_Q(ntryL,G1H16(130),ex2(:),G1H8(24),m3h2x8(:,1804),heltab2x16(:,:,1804))
  call Hloop_A_Q(ntryL,G1H8(24),42,nMT,G2H8(6),n2h8(2524))
  call Hloop_QV_A(ntryL,G1H16(132),ex2(:),G1H8(41),m3h2x8(:,1805),heltab2x16(:,:,1805))
  call Hloop_Q_A(ntryL,G1H8(41),42,nMB,G2H8(9),n2h8(2525))
  call Hloop_AV_Q(ntryL,G1H16(134),ex2(:),G1H8(42),m3h2x8(:,1806),heltab2x16(:,:,1806))
  call Hloop_A_Q(ntryL,G1H8(42),42,nMB,G2H8(10),n2h8(2526))
  call Hloop_AV_Q(ntryL,G1H16(44),ex1(:),G1H8(59),m3h2x8(:,1807),heltab2x16(:,:,1807))
  call Hloop_A_Q(ntryL,G1H8(59),37,0,G2H8(11),n2h8(2527))
  call Hloop_AV_Q(ntryL,G1H16(41),ex1(:),G1H8(60),m3h2x8(:,1808),heltab2x16(:,:,1808))
  call Hloop_A_Q(ntryL,G1H8(60),37,nMT,G2H8(14),n2h8(2528))
  call Hloop_QV_A(ntryL,G1H16(47),ex1(:),G1H8(77),m3h2x8(:,1809),heltab2x16(:,:,1809))
  call Hloop_Q_A(ntryL,G1H8(77),37,0,G2H8(15),n2h8(2529))
  call Hloop_QV_A(ntryL,G1H16(43),ex1(:),G1H8(78),m3h2x8(:,1810),heltab2x16(:,:,1810))
  call Hloop_Q_A(ntryL,G1H8(78),37,nMT,G2H8(16),n2h8(2530))
  call Hloop_AV_Q(ntryL,G1H16(46),ex1(:),G1H8(95),m3h2x8(:,1811),heltab2x16(:,:,1811))
  call Hloop_A_Q(ntryL,G1H8(95),37,nMB,G2H8(19),n2h8(2531))
  call Hloop_QV_A(ntryL,G1H16(48),ex1(:),G1H8(96),m3h2x8(:,1812),heltab2x16(:,:,1812))
  call Hloop_Q_A(ntryL,G1H8(96),37,nMB,G2H8(20),n2h8(2532))
  call Hloop_AV_Q(ntryL,G1H16(121),ex3(:),G1H8(113),m3h2x8(:,1813),heltab2x16(:,:,1813))
  call Hloop_A_Q(ntryL,G1H8(113),44,0,G2H8(21),n2h8(2533))
  call Hloop_AV_Q(ntryL,G1H16(118),ex3(:),G1H8(114),m3h2x8(:,1814),heltab2x16(:,:,1814))
  call Hloop_A_Q(ntryL,G1H8(114),44,nMT,G2H8(24),n2h8(2534))
  call Hloop_QV_A(ntryL,G1H16(124),ex3(:),G1H8(131),m3h2x8(:,1815),heltab2x16(:,:,1815))
  call Hloop_Q_A(ntryL,G1H8(131),44,0,G2H8(25),n2h8(2535))
  call Hloop_QV_A(ntryL,G1H16(120),ex3(:),G1H8(132),m3h2x8(:,1816),heltab2x16(:,:,1816))
  call Hloop_Q_A(ntryL,G1H8(132),44,nMT,G2H8(26),n2h8(2536))
  call Hloop_AV_Q(ntryL,G1H16(122),ex3(:),G1H8(149),m3h2x8(:,1817),heltab2x16(:,:,1817))
  call Hloop_A_Q(ntryL,G1H8(149),44,nMB,G2H8(29),n2h8(2537))
  call Hloop_QV_A(ntryL,G1H16(125),ex3(:),G1H8(150),m3h2x8(:,1818),heltab2x16(:,:,1818))
  call Hloop_Q_A(ntryL,G1H8(150),44,nMB,G2H8(30),n2h8(2538))
  call Hloop_AV_Q(ntryL,G1H16(54),ex1(:),G1H8(167),m3h2x8(:,1819),heltab2x16(:,:,1819))
  call Hloop_A_Q(ntryL,G1H8(167),37,0,G2H8(31),n2h8(2539))
  call Hloop_AV_Q(ntryL,G1H16(50),ex1(:),G1H8(168),m3h2x8(:,1820),heltab2x16(:,:,1820))
  call Hloop_A_Q(ntryL,G1H8(168),37,nMT,G2H8(34),n2h8(2540))
  call Hloop_QV_A(ntryL,G1H16(56),ex1(:),G1H8(185),m3h2x8(:,1821),heltab2x16(:,:,1821))
  call Hloop_Q_A(ntryL,G1H8(185),37,0,G2H8(35),n2h8(2541))
  call Hloop_QV_A(ntryL,G1H16(53),ex1(:),G1H8(186),m3h2x8(:,1822),heltab2x16(:,:,1822))
  call Hloop_Q_A(ntryL,G1H8(186),37,nMT,G2H8(36),n2h8(2542))
  call Hloop_AV_Q(ntryL,G1H16(55),ex1(:),G1H8(203),m3h2x8(:,1823),heltab2x16(:,:,1823))
  call Hloop_A_Q(ntryL,G1H8(203),37,nMB,G2H8(39),n2h8(2543))
  call Hloop_QV_A(ntryL,G1H16(58),ex1(:),G1H8(204),m3h2x8(:,1824),heltab2x16(:,:,1824))
  call Hloop_Q_A(ntryL,G1H8(204),37,nMB,G2H8(40),n2h8(2544))
  call Hloop_QV_A(ntryL,G1H16(147),ex1(:),G1H8(221),m3h2x8(:,1825),heltab2x16(:,:,1825))
  call Hloop_Q_A(ntryL,G1H8(221),35,0,G2H8(41),n2h8(2545))
  call Hloop_QV_A(ntryL,G1H16(153),ex1(:),G1H8(222),m3h2x8(:,1826),heltab2x16(:,:,1826))
  call Hloop_Q_A(ntryL,G1H8(222),35,nMT,G2H8(44),n2h8(2546))
  call Hloop_AV_Q(ntryL,G1H16(159),ex1(:),G1H8(239),m3h2x8(:,1827),heltab2x16(:,:,1827))
  call Hloop_A_Q(ntryL,G1H8(239),35,0,G2H8(45),n2h8(2547))
  call Hloop_AV_Q(ntryL,G1H16(165),ex1(:),G1H8(240),m3h2x8(:,1828),heltab2x16(:,:,1828))
  call Hloop_A_Q(ntryL,G1H8(240),35,nMT,G2H8(46),n2h8(2548))
  call Hloop_QV_A(ntryL,G1H16(171),ex1(:),G1H8(257),m3h2x8(:,1829),heltab2x16(:,:,1829))
  call Hloop_Q_A(ntryL,G1H8(257),35,nMB,G2H8(49),n2h8(2549))
  call Hloop_AV_Q(ntryL,G1H16(177),ex1(:),G1H8(258),m3h2x8(:,1830),heltab2x16(:,:,1830))
  call Hloop_A_Q(ntryL,G1H8(258),35,nMB,G2H8(50),n2h8(2550))
  call Hloop_QV_A(ntryL,G1H16(183),ex1(:),G1H8(275),m3h2x8(:,1831),heltab2x16(:,:,1831))
  call Hloop_Q_A(ntryL,G1H8(275),35,0,G2H8(51),n2h8(2551))
  call Hloop_QV_A(ntryL,G1H16(189),ex1(:),G1H8(276),m3h2x8(:,1832),heltab2x16(:,:,1832))
  call Hloop_Q_A(ntryL,G1H8(276),35,nMT,G2H8(54),n2h8(2552))



end subroutine vamp_16

end module ol_vamp_16_ppaajj2_aagggg_1_/**/REALKIND
