
! **********************************************************************
module ol_tensor_sum_storage_ppaajj2_bbxaagg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,4)
  complex(REALKIND) :: momenta_2(4,4)
  complex(REALKIND) :: momenta_3(4,4)
  complex(REALKIND) :: momenta_4(4,4)
  complex(REALKIND) :: momenta_5(4,4)
  complex(REALKIND) :: momenta_6(4,4)
  complex(REALKIND) :: momenta_7(4,4)
  complex(REALKIND) :: momenta_8(4,4)
  complex(REALKIND) :: momenta_9(4,4)
  complex(REALKIND) :: momenta_10(4,4)
  complex(REALKIND) :: momenta_11(4,4)
  complex(REALKIND) :: momenta_12(4,4)

  complex(REALKIND), save :: masses2_1(5)
  complex(REALKIND), save :: masses2_2(5)
  complex(REALKIND), save :: masses2_3(5)

  complex(REALKIND), save :: T5sum(126,36) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppaajj2_bbxaagg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppaajj2_bbxaagg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T5sum(:,1), 2)
  call scale_one_tsum(T5sum(:,2), 2)
  call scale_one_tsum(T5sum(:,3), 2)
  call scale_one_tsum(T5sum(:,4), 2)
  call scale_one_tsum(T5sum(:,5), 2)
  call scale_one_tsum(T5sum(:,6), 2)
  call scale_one_tsum(T5sum(:,7), 2)
  call scale_one_tsum(T5sum(:,8), 2)
  call scale_one_tsum(T5sum(:,9), 2)
  call scale_one_tsum(T5sum(:,10), 2)
  call scale_one_tsum(T5sum(:,11), 2)
  call scale_one_tsum(T5sum(:,12), 2)
  call scale_one_tsum(T5sum(:,13), 2)
  call scale_one_tsum(T5sum(:,14), 2)
  call scale_one_tsum(T5sum(:,15), 2)
  call scale_one_tsum(T5sum(:,16), 2)
  call scale_one_tsum(T5sum(:,17), 2)
  call scale_one_tsum(T5sum(:,18), 2)
  call scale_one_tsum(T5sum(:,19), 2)
  call scale_one_tsum(T5sum(:,20), 2)
  call scale_one_tsum(T5sum(:,21), 2)
  call scale_one_tsum(T5sum(:,22), 2)
  call scale_one_tsum(T5sum(:,23), 2)
  call scale_one_tsum(T5sum(:,24), 2)
  call scale_one_tsum(T5sum(:,25), 2)
  call scale_one_tsum(T5sum(:,26), 2)
  call scale_one_tsum(T5sum(:,27), 2)
  call scale_one_tsum(T5sum(:,28), 2)
  call scale_one_tsum(T5sum(:,29), 2)
  call scale_one_tsum(T5sum(:,30), 2)
  call scale_one_tsum(T5sum(:,31), 2)
  call scale_one_tsum(T5sum(:,32), 2)
  call scale_one_tsum(T5sum(:,33), 2)
  call scale_one_tsum(T5sum(:,34), 2)
  call scale_one_tsum(T5sum(:,35), 2)
  call scale_one_tsum(T5sum(:,36), 2)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_ppaajj2_bbxaagg_1, only: channel_number_ppaajj2_bbxaagg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_ppaajj2_bbxaagg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,4)
  momenta_1(:,2) = Q(1:4,12)
  momenta_1(:,3) = Q(1:4,28)
  momenta_1(:,4) = Q(1:4,60)
  momenta_2(:,1) = Q(1:4,4)
  momenta_2(:,2) = Q(1:4,12)
  momenta_2(:,3) = Q(1:4,44)
  momenta_2(:,4) = Q(1:4,60)
  momenta_3(:,1) = Q(1:4,4)
  momenta_3(:,2) = Q(1:4,20)
  momenta_3(:,3) = Q(1:4,28)
  momenta_3(:,4) = Q(1:4,60)
  momenta_4(:,1) = Q(1:4,4)
  momenta_4(:,2) = Q(1:4,20)
  momenta_4(:,3) = Q(1:4,52)
  momenta_4(:,4) = Q(1:4,60)
  momenta_5(:,1) = Q(1:4,4)
  momenta_5(:,2) = Q(1:4,36)
  momenta_5(:,3) = Q(1:4,44)
  momenta_5(:,4) = Q(1:4,60)
  momenta_6(:,1) = Q(1:4,4)
  momenta_6(:,2) = Q(1:4,36)
  momenta_6(:,3) = Q(1:4,52)
  momenta_6(:,4) = Q(1:4,60)
  momenta_7(:,1) = Q(1:4,8)
  momenta_7(:,2) = Q(1:4,12)
  momenta_7(:,3) = Q(1:4,28)
  momenta_7(:,4) = Q(1:4,60)
  momenta_8(:,1) = Q(1:4,8)
  momenta_8(:,2) = Q(1:4,12)
  momenta_8(:,3) = Q(1:4,44)
  momenta_8(:,4) = Q(1:4,60)
  momenta_9(:,1) = Q(1:4,8)
  momenta_9(:,2) = Q(1:4,24)
  momenta_9(:,3) = Q(1:4,28)
  momenta_9(:,4) = Q(1:4,60)
  momenta_10(:,1) = Q(1:4,8)
  momenta_10(:,2) = Q(1:4,40)
  momenta_10(:,3) = Q(1:4,44)
  momenta_10(:,4) = Q(1:4,60)
  momenta_11(:,1) = Q(1:4,16)
  momenta_11(:,2) = Q(1:4,20)
  momenta_11(:,3) = Q(1:4,28)
  momenta_11(:,4) = Q(1:4,60)
  momenta_12(:,1) = Q(1:4,16)
  momenta_12(:,2) = Q(1:4,24)
  momenta_12(:,3) = Q(1:4,28)
  momenta_12(:,4) = Q(1:4,60)

  masses2_1 = [ MB2, MB2, MB2, MB2, MB2 ]
  masses2_2 = [ MT2, MT2, MT2, MT2, MT2 ]
  masses2_3 = [ ZERO2, ZERO2, ZERO2, ZERO2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call tensor_integral(5, momenta_11, masses2_3, T5sum(:,1))
  call tensor_integral(5, momenta_11, masses2_2, T5sum(:,2))
  call tensor_integral(5, momenta_11, masses2_1, T5sum(:,3))
  call tensor_integral(5, momenta_7, masses2_3, T5sum(:,4))
  call tensor_integral(5, momenta_7, masses2_2, T5sum(:,5))
  call tensor_integral(5, momenta_7, masses2_1, T5sum(:,6))
  call tensor_integral(5, momenta_12, masses2_3, T5sum(:,7))
  call tensor_integral(5, momenta_12, masses2_2, T5sum(:,8))
  call tensor_integral(5, momenta_12, masses2_1, T5sum(:,9))
  call tensor_integral(5, momenta_8, masses2_3, T5sum(:,10))
  call tensor_integral(5, momenta_8, masses2_2, T5sum(:,11))
  call tensor_integral(5, momenta_8, masses2_1, T5sum(:,12))
  call tensor_integral(5, momenta_1, masses2_3, T5sum(:,13))
  call tensor_integral(5, momenta_1, masses2_2, T5sum(:,14))
  call tensor_integral(5, momenta_1, masses2_1, T5sum(:,15))
  call tensor_integral(5, momenta_2, masses2_3, T5sum(:,16))
  call tensor_integral(5, momenta_2, masses2_2, T5sum(:,17))
  call tensor_integral(5, momenta_2, masses2_1, T5sum(:,18))
  call tensor_integral(5, momenta_9, masses2_3, T5sum(:,19))
  call tensor_integral(5, momenta_9, masses2_2, T5sum(:,20))
  call tensor_integral(5, momenta_9, masses2_1, T5sum(:,21))
  call tensor_integral(5, momenta_10, masses2_3, T5sum(:,22))
  call tensor_integral(5, momenta_10, masses2_2, T5sum(:,23))
  call tensor_integral(5, momenta_10, masses2_1, T5sum(:,24))
  call tensor_integral(5, momenta_3, masses2_3, T5sum(:,25))
  call tensor_integral(5, momenta_3, masses2_2, T5sum(:,26))
  call tensor_integral(5, momenta_3, masses2_1, T5sum(:,27))
  call tensor_integral(5, momenta_4, masses2_3, T5sum(:,28))
  call tensor_integral(5, momenta_4, masses2_2, T5sum(:,29))
  call tensor_integral(5, momenta_4, masses2_1, T5sum(:,30))
  call tensor_integral(5, momenta_5, masses2_3, T5sum(:,31))
  call tensor_integral(5, momenta_5, masses2_2, T5sum(:,32))
  call tensor_integral(5, momenta_5, masses2_1, T5sum(:,33))
  call tensor_integral(5, momenta_6, masses2_3, T5sum(:,34))
  call tensor_integral(5, momenta_6, masses2_2, T5sum(:,35))
  call tensor_integral(5, momenta_6, masses2_1, T5sum(:,36))

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppaajj2_bbxaagg_1_/**/REALKIND
