
module ol_colourmatrix_ppaajj2_uuxaagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,3), KL(0,3), KL2(69,3), KL2ct(3,3), KL2ct2(69,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [   48,   -6,   18]
  KL2( 2,:) = [   -6,   48,   18]
  KL2( 3,:) = [   18,   18,   54]
  KL2( 4,:) = [   64,   -8,   24]
  KL2( 5,:) = [   -8,   64,   24]
  KL2( 6,:) = [   24,   24,   72]
  KL2( 7,:) = [   -1,  -10,  -24]
  KL2( 8,:) = [  -10,   -1,  -24]
  KL2( 9,:) = [  -24,  -24,  -72]
  KL2(10,:) = [   64,   -8,   24]
  KL2(11,:) = [   -8,   64,   24]
  KL2(12,:) = [   24,   24,   72]
  KL2(13,:) = [    0,    0,    0]
  KL2(14,:) = [    0,    0,    0]
  KL2(15,:) = [    0,    0,    0]
  KL2(16,:) = [    0,    0,    0]
  KL2(17,:) = [    0,    0,    0]
  KL2(18,:) = [    0,    0,    0]
  KL2(19,:) = [    0,    0,    0]
  KL2(20,:) = [    0,    0,    0]
  KL2(21,:) = [    0,    0,    0]
  KL2(22,:) = [    0,    0,    0]
  KL2(23,:) = [    0,    0,    0]
  KL2(24,:) = [    0,    0,    0]
  KL2(25,:) = [    0,    0,    0]
  KL2(26,:) = [    0,    0,    0]
  KL2(27,:) = [    0,    0,    0]
  KL2(28,:) = [    0,    0,    0]
  KL2(29,:) = [    0,    0,    0]
  KL2(30,:) = [    0,    0,    0]
  KL2(31,:) = [    0,    0,    0]
  KL2(32,:) = [    0,    0,    0]
  KL2(33,:) = [    0,    0,    0]
  KL2(34,:) = [    9,    9,   27]
  KL2(35,:) = [    9,  -72,  -27]
  KL2(36,:) = [   27,  -27,    0]
  KL2(37,:) = [  -72,    9,  -27]
  KL2(38,:) = [    9,    9,   27]
  KL2(39,:) = [  -27,   27,    0]
  KL2(40,:) = [    0,    0,    0]
  KL2(41,:) = [    0,    0,    0]
  KL2(42,:) = [    0,    0,    0]
  KL2(43,:) = [    0,    0,    0]
  KL2(44,:) = [    0,    0,    0]
  KL2(45,:) = [    0,    0,    0]
  KL2(46,:) = [  144,  -18,   54]
  KL2(47,:) = [  -18,  144,   54]
  KL2(48,:) = [   54,   54,  162]
  KL2(49,:) = [  -72,    9,  -27]
  KL2(50,:) = [    9,    9,   27]
  KL2(51,:) = [  -27,   27,    0]
  KL2(52,:) = [    9,    9,   27]
  KL2(53,:) = [    9,  -72,  -27]
  KL2(54,:) = [   27,  -27,    0]
  KL2(55,:) = [    0,    0,    0]
  KL2(56,:) = [    0,    0,    0]
  KL2(57,:) = [    0,    0,    0]
  KL2(58,:) = [    0,    0,    0]
  KL2(59,:) = [    0,    0,    0]
  KL2(60,:) = [    0,    0,    0]
  KL2(61,:) = [  -81,    0,  -54]
  KL2(62,:) = [    0,  -81,  -54]
  KL2(63,:) = [  -54,  -54, -162]
  KL2(64,:) = [  144,  -18,   54]
  KL2(65,:) = [  -18,  144,   54]
  KL2(66,:) = [   54,   54,  162]
  KL2(67,:) = [    0,    0,    0]
  KL2(68,:) = [    0,    0,    0]
  KL2(69,:) = [    0,    0,    0]
  KL2 = (1._/**/REALKIND / 9) * KL2

  KL2ct(1,:) = [ 16, -2,  6]
  KL2ct(2,:) = [ -2, 16,  6]
  KL2ct(3,:) = [  6,  6, 18]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [   48,   -6,   18]
  KL2ct2( 2,:) = [   -6,   48,   18]
  KL2ct2( 3,:) = [   18,   18,   54]
  KL2ct2( 4,:) = [   64,   -8,   24]
  KL2ct2( 5,:) = [   -8,   64,   24]
  KL2ct2( 6,:) = [   24,   24,   72]
  KL2ct2( 7,:) = [   -1,  -10,  -24]
  KL2ct2( 8,:) = [  -10,   -1,  -24]
  KL2ct2( 9,:) = [  -24,  -24,  -72]
  KL2ct2(10,:) = [   64,   -8,   24]
  KL2ct2(11,:) = [   -8,   64,   24]
  KL2ct2(12,:) = [   24,   24,   72]
  KL2ct2(13,:) = [    0,    0,    0]
  KL2ct2(14,:) = [    0,    0,    0]
  KL2ct2(15,:) = [    0,    0,    0]
  KL2ct2(16,:) = [    0,    0,    0]
  KL2ct2(17,:) = [    0,    0,    0]
  KL2ct2(18,:) = [    0,    0,    0]
  KL2ct2(19,:) = [    0,    0,    0]
  KL2ct2(20,:) = [    0,    0,    0]
  KL2ct2(21,:) = [    0,    0,    0]
  KL2ct2(22,:) = [    0,    0,    0]
  KL2ct2(23,:) = [    0,    0,    0]
  KL2ct2(24,:) = [    0,    0,    0]
  KL2ct2(25,:) = [    0,    0,    0]
  KL2ct2(26,:) = [    0,    0,    0]
  KL2ct2(27,:) = [    0,    0,    0]
  KL2ct2(28,:) = [    0,    0,    0]
  KL2ct2(29,:) = [    0,    0,    0]
  KL2ct2(30,:) = [    0,    0,    0]
  KL2ct2(31,:) = [    0,    0,    0]
  KL2ct2(32,:) = [    0,    0,    0]
  KL2ct2(33,:) = [    0,    0,    0]
  KL2ct2(34,:) = [    9,    9,   27]
  KL2ct2(35,:) = [    9,  -72,  -27]
  KL2ct2(36,:) = [   27,  -27,    0]
  KL2ct2(37,:) = [  -72,    9,  -27]
  KL2ct2(38,:) = [    9,    9,   27]
  KL2ct2(39,:) = [  -27,   27,    0]
  KL2ct2(40,:) = [    0,    0,    0]
  KL2ct2(41,:) = [    0,    0,    0]
  KL2ct2(42,:) = [    0,    0,    0]
  KL2ct2(43,:) = [    0,    0,    0]
  KL2ct2(44,:) = [    0,    0,    0]
  KL2ct2(45,:) = [    0,    0,    0]
  KL2ct2(46,:) = [  144,  -18,   54]
  KL2ct2(47,:) = [  -18,  144,   54]
  KL2ct2(48,:) = [   54,   54,  162]
  KL2ct2(49,:) = [  -72,    9,  -27]
  KL2ct2(50,:) = [    9,    9,   27]
  KL2ct2(51,:) = [  -27,   27,    0]
  KL2ct2(52,:) = [    9,    9,   27]
  KL2ct2(53,:) = [    9,  -72,  -27]
  KL2ct2(54,:) = [   27,  -27,    0]
  KL2ct2(55,:) = [    0,    0,    0]
  KL2ct2(56,:) = [    0,    0,    0]
  KL2ct2(57,:) = [    0,    0,    0]
  KL2ct2(58,:) = [    0,    0,    0]
  KL2ct2(59,:) = [    0,    0,    0]
  KL2ct2(60,:) = [    0,    0,    0]
  KL2ct2(61,:) = [  -81,    0,  -54]
  KL2ct2(62,:) = [    0,  -81,  -54]
  KL2ct2(63,:) = [  -54,  -54, -162]
  KL2ct2(64,:) = [  144,  -18,   54]
  KL2ct2(65,:) = [  -18,  144,   54]
  KL2ct2(66,:) = [   54,   54,  162]
  KL2ct2(67,:) = [    0,    0,    0]
  KL2ct2(68,:) = [    0,    0,    0]
  KL2ct2(69,:) = [    0,    0,    0]
  KL2ct2 = (1._/**/REALKIND / 9) * KL2ct2

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppaajj2_uuxaagg_1_/**/REALKIND



module ol_forced_parameters_ppaajj2_uuxaagg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppaajj2_uuxaagg_1_/**/REALKIND

module ol_loop_ppaajj2_uuxaagg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(10), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:97)
  ! denominators
  complex(REALKIND), save :: den(72)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,64), Mct(3,64), Mcol_loop(3,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 2) = (4*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 3) = CI*countertermnorm*ctAAGG*eQED**2*gQCD**4
    f( 4) = (4*countertermnorm*ctGqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 5) = (4*countertermnorm*ctVqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 6) = (4*countertermnorm*ctVVV*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 7) = (eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f( 8) = (2*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f( 9) = (4*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(10) = (8*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(0), M2(3)
  complex(REALKIND) :: A(48)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_VQ_A(wf(:,-2),wf(:,0),wf(:,1))
  call counter_VGG_G(ctAGGG,wf(:,-3),wf(:,-4),wf(:,-5),wf(:,2))
  call prop_Q_A(wf(:,1),Q(:,5),ZERO,0_intkind1,wf(:,3))
  call vert_QA_V(wf(:,3),wf(:,-1),wf(:,4))
  call counter_VGG_G(ctAGGG,wf(:,-3),wf(:,-5),wf(:,-4),wf(:,5))
  call vert_AV_Q(wf(:,-1),wf(:,-2),wf(:,6))
  call prop_A_Q(wf(:,6),Q(:,6),ZERO,0_intkind1,wf(:,7))
  call vert_QA_V(wf(:,0),wf(:,7),wf(:,8))
  call vert_VQ_A(wf(:,-3),wf(:,0),wf(:,9))
  call counter_VGG_G(ctAGGG,wf(:,-2),wf(:,-4),wf(:,-5),wf(:,10))
  call prop_Q_A(wf(:,9),Q(:,9),ZERO,0_intkind1,wf(:,11))
  call vert_QA_V(wf(:,11),wf(:,-1),wf(:,12))
  call counter_VGG_G(ctAGGG,wf(:,-2),wf(:,-5),wf(:,-4),wf(:,13))
  call vert_AV_Q(wf(:,-1),wf(:,-3),wf(:,14))
  call prop_A_Q(wf(:,14),Q(:,10),ZERO,0_intkind1,wf(:,15))
  call vert_QA_V(wf(:,0),wf(:,15),wf(:,16))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,17))
  call counter_VVG_G(wf(:,-2),wf(:,-3),wf(:,-5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,17),ZERO,0_intkind1,wf(:,19))
  call vert_QA_V(wf(:,19),wf(:,-1),wf(:,20))
  call vert_AV_Q(wf(:,-1),wf(:,-4),wf(:,21))
  call prop_A_Q(wf(:,21),Q(:,18),ZERO,0_intkind1,wf(:,22))
  call vert_QA_V(wf(:,0),wf(:,22),wf(:,23))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,24))
  call counter_VVG_G(wf(:,-2),wf(:,-3),wf(:,-4),wf(:,25))
  call prop_Q_A(wf(:,24),Q(:,33),ZERO,0_intkind1,wf(:,26))
  call vert_QA_V(wf(:,26),wf(:,-1),wf(:,27))
  call vert_AV_Q(wf(:,-1),wf(:,-5),wf(:,28))
  call prop_A_Q(wf(:,28),Q(:,34),ZERO,0_intkind1,wf(:,29))
  call vert_QA_V(wf(:,0),wf(:,29),wf(:,30))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,31))
  call counter_QA_V(wf(:,3),wf(:,15),wf(:,32))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,33))
  call vert_QA_V(wf(:,3),wf(:,15),wf(:,34))
  call vert_AV_Q(wf(:,-1),wf(:,33),wf(:,35))
  call vert_VQ_A(wf(:,-3),wf(:,3),wf(:,36))
  call prop_A_Q(wf(:,35),Q(:,50),ZERO,0_intkind1,wf(:,37))
  call vert_AV_Q(wf(:,-1),wf(:,31),wf(:,38))
  call counter_VQ_A(wf(:,-3),wf(:,3),wf(:,39))
  call prop_A_Q(wf(:,38),Q(:,50),ZERO,0_intkind1,wf(:,40))
  call counter_QA_V(wf(:,11),wf(:,7),wf(:,41))
  call vert_QA_V(wf(:,11),wf(:,7),wf(:,42))
  call vert_VQ_A(wf(:,33),wf(:,0),wf(:,43))
  call vert_AV_Q(wf(:,7),wf(:,-3),wf(:,44))
  call prop_Q_A(wf(:,43),Q(:,49),ZERO,0_intkind1,wf(:,45))
  call vert_VQ_A(wf(:,31),wf(:,0),wf(:,46))
  call counter_AV_Q(wf(:,7),wf(:,-3),wf(:,47))
  call prop_Q_A(wf(:,46),Q(:,49),ZERO,0_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,-2),wf(:,11),wf(:,49))
  call vert_AV_Q(wf(:,15),wf(:,-2),wf(:,50))
  call counter_VQ_A(wf(:,-2),wf(:,11),wf(:,51))
  call counter_AV_Q(wf(:,15),wf(:,-2),wf(:,52))
  call counter_AV_Q(wf(:,-1),wf(:,31),wf(:,53))
  call prop_Q_A(wf(:,36),Q(:,13),ZERO,0_intkind1,wf(:,54))
  call counter_AV_Q(wf(:,-1),wf(:,-3),wf(:,55))
  call prop_A_Q(wf(:,55),Q(:,10),ZERO,0_intkind1,wf(:,56))
  call vert_QA_V(wf(:,3),wf(:,56),wf(:,57))
  call prop_Q_A(wf(:,49),Q(:,13),ZERO,0_intkind1,wf(:,58))
  call vert_AV_Q(wf(:,56),wf(:,-2),wf(:,59))
  call counter_AV_Q(wf(:,-1),wf(:,-2),wf(:,60))
  call prop_A_Q(wf(:,60),Q(:,6),ZERO,0_intkind1,wf(:,61))
  call vert_QA_V(wf(:,11),wf(:,61),wf(:,62))
  call vert_AV_Q(wf(:,61),wf(:,-3),wf(:,63))
  call counter_VQ_A(wf(:,31),wf(:,0),wf(:,64))
  call prop_A_Q(wf(:,44),Q(:,14),ZERO,0_intkind1,wf(:,65))
  call counter_VQ_A(wf(:,-3),wf(:,0),wf(:,66))
  call prop_Q_A(wf(:,66),Q(:,9),ZERO,0_intkind1,wf(:,67))
  call vert_QA_V(wf(:,67),wf(:,7),wf(:,68))
  call prop_A_Q(wf(:,50),Q(:,14),ZERO,0_intkind1,wf(:,69))
  call vert_VQ_A(wf(:,-2),wf(:,67),wf(:,70))
  call counter_VQ_A(wf(:,-2),wf(:,0),wf(:,71))
  call prop_Q_A(wf(:,71),Q(:,5),ZERO,0_intkind1,wf(:,72))
  call vert_QA_V(wf(:,72),wf(:,15),wf(:,73))
  call vert_VQ_A(wf(:,-3),wf(:,72),wf(:,74))
  call vert_AV_Q(wf(:,15),wf(:,31),wf(:,75))
  call counter_Q_A(ctqq,2,wf(:,3),Q(:,5),wf(:,76))
  call prop_A_Q(wf(:,75),Q(:,58),ZERO,0_intkind1,wf(:,77))
  call vert_VQ_A(wf(:,31),wf(:,3),wf(:,78))
  call counter_A_Q(ctqq,2,wf(:,15),Q(:,10),wf(:,79))
  call prop_Q_A(wf(:,78),Q(:,53),ZERO,0_intkind1,wf(:,80))
  call prop_Q_A(wf(:,76),Q(:,5),ZERO,0_intkind1,wf(:,81))
  call vert_VQ_A(wf(:,-3),wf(:,81),wf(:,82))
  call counter_A_Q(ctqq,2,wf(:,40),Q(:,50),wf(:,83))
  call vert_AV_Q(wf(:,7),wf(:,31),wf(:,84))
  call counter_Q_A(ctqq,2,wf(:,11),Q(:,9),wf(:,85))
  call prop_A_Q(wf(:,84),Q(:,54),ZERO,0_intkind1,wf(:,86))
  call vert_VQ_A(wf(:,31),wf(:,11),wf(:,87))
  call counter_A_Q(ctqq,2,wf(:,7),Q(:,6),wf(:,88))
  call prop_Q_A(wf(:,87),Q(:,57),ZERO,0_intkind1,wf(:,89))
  call counter_Q_A(ctqq,2,wf(:,48),Q(:,49),wf(:,90))
  call prop_A_Q(wf(:,88),Q(:,6),ZERO,0_intkind1,wf(:,91))
  call vert_AV_Q(wf(:,91),wf(:,-3),wf(:,92))
  call prop_Q_A(wf(:,85),Q(:,9),ZERO,0_intkind1,wf(:,93))
  call vert_VQ_A(wf(:,-2),wf(:,93),wf(:,94))
  call prop_A_Q(wf(:,79),Q(:,10),ZERO,0_intkind1,wf(:,95))
  call vert_AV_Q(wf(:,95),wf(:,-2),wf(:,96))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,97))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,56))
  den(4) = 1 / (Q(5,6))
  den(6) = 1 / (Q(5,9))
  den(7) = 1 / (Q(5,52))
  den(9) = 1 / (Q(5,10))
  den(11) = 1 / (Q(5,17))
  den(12) = 1 / (Q(5,44))
  den(14) = 1 / (Q(5,18))
  den(16) = 1 / (Q(5,33))
  den(17) = 1 / (Q(5,28))
  den(19) = 1 / (Q(5,34))
  den(21) = 1 / (Q(5,48))
  den(24) = 1 / (Q(5,50))
  den(29) = 1 / (Q(5,49))
  den(34) = 1 / (Q(5,13))
  den(39) = 1 / (Q(5,14))
  den(45) = 1 / (Q(5,58))
  den(49) = 1 / (Q(5,53))
  den(56) = 1 / (Q(5,54))
  den(60) = 1 / (Q(5,57))
  den(72) = 1 / (Q(5,3))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(13) = den(11)*den(12)
  den(15) = den(12)*den(14)
  den(18) = den(16)*den(17)
  den(20) = den(17)*den(19)
  den(22) = den(1)*den(9)
  den(23) = den(21)*den(22)
  den(25) = den(21)*den(24)
  den(26) = den(1)*den(25)
  den(27) = den(4)*den(6)
  den(28) = den(21)*den(27)
  den(30) = den(21)*den(29)
  den(31) = den(4)*den(30)
  den(32) = den(6)*den(25)
  den(33) = den(9)*den(30)
  den(35) = den(1)*den(34)
  den(36) = den(21)*den(35)
  den(37) = den(6)*den(34)
  den(38) = den(21)*den(37)
  den(40) = den(4)*den(39)
  den(41) = den(21)*den(40)
  den(42) = den(9)*den(39)
  den(43) = den(21)*den(42)
  den(44) = den(9)*den(21)
  den(46) = den(44)*den(45)
  den(47) = den(1)*den(46)
  den(48) = den(1)*den(21)
  den(50) = den(48)*den(49)
  den(51) = den(9)*den(50)
  den(52) = den(1)**2
  den(53) = den(25)*den(52)
  den(54) = den(25)*den(35)
  den(55) = den(4)*den(21)
  den(57) = den(55)*den(56)
  den(58) = den(6)*den(57)
  den(59) = den(6)*den(21)
  den(61) = den(59)*den(60)
  den(62) = den(4)*den(61)
  den(63) = den(30)*den(40)
  den(64) = den(4)**2
  den(65) = den(30)*den(64)
  den(66) = den(6)**2
  den(67) = den(25)*den(66)
  den(68) = den(25)*den(37)
  den(69) = den(30)*den(42)
  den(70) = den(9)**2
  den(71) = den(30)*den(70)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(48)


  A(1) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(3)
  A(3) = cont_VV(wf(:,2),wf(:,8)) * den(5)
  A(4) = cont_VV(wf(:,5),wf(:,8)) * den(5)
  A(5) = cont_VV(wf(:,10),wf(:,12)) * den(8)
  A(6) = cont_VV(wf(:,12),wf(:,13)) * den(8)
  A(7) = cont_VV(wf(:,10),wf(:,16)) * den(10)
  A(8) = cont_VV(wf(:,13),wf(:,16)) * den(10)
  A(9) = cont_VV(wf(:,18),wf(:,20)) * den(13)
  A(10) = cont_VV(wf(:,18),wf(:,23)) * den(15)
  A(11) = cont_VV(wf(:,25),wf(:,27)) * den(18)
  A(12) = cont_VV(wf(:,25),wf(:,30)) * den(20)
  A(13) = cont_VV(wf(:,31),wf(:,32)) * den(23)
  A(14) = cont_VV(wf(:,33),wf(:,34)) * den(23)
  A(15) = cont_QA(wf(:,36),wf(:,37)) * den(26)
  A(16) = cont_QA(wf(:,39),wf(:,40)) * den(26)
  A(17) = cont_VV(wf(:,31),wf(:,41)) * den(28)
  A(18) = cont_VV(wf(:,33),wf(:,42)) * den(28)
  A(19) = cont_QA(wf(:,44),wf(:,45)) * den(31)
  A(20) = cont_QA(wf(:,47),wf(:,48)) * den(31)
  A(21) = cont_QA(wf(:,37),wf(:,49)) * den(32)
  A(22) = cont_QA(wf(:,45),wf(:,50)) * den(33)
  A(23) = cont_QA(wf(:,40),wf(:,51)) * den(32)
  A(24) = cont_QA(wf(:,48),wf(:,52)) * den(33)
  A(25) = cont_QA(wf(:,53),wf(:,54)) * den(36)
  A(26) = cont_VV(wf(:,31),wf(:,57)) * den(23)
  A(27) = cont_QA(wf(:,53),wf(:,58)) * den(38)
  A(28) = cont_QA(wf(:,48),wf(:,59)) * den(33)
  A(29) = cont_VV(wf(:,31),wf(:,62)) * den(28)
  A(30) = cont_QA(wf(:,48),wf(:,63)) * den(31)
  A(31) = cont_QA(wf(:,64),wf(:,65)) * den(41)
  A(32) = cont_VV(wf(:,31),wf(:,68)) * den(28)
  A(33) = cont_QA(wf(:,64),wf(:,69)) * den(43)
  A(34) = cont_QA(wf(:,40),wf(:,70)) * den(32)
  A(35) = cont_VV(wf(:,31),wf(:,73)) * den(23)
  A(36) = cont_QA(wf(:,40),wf(:,74)) * den(26)
  A(37) = cont_QA(wf(:,76),wf(:,77)) * den(47)
  A(38) = cont_QA(wf(:,79),wf(:,80)) * den(51)
  A(39) = cont_QA(wf(:,40),wf(:,82)) * den(53)
  A(40) = cont_QA(wf(:,54),wf(:,83)) * den(54)
  A(41) = cont_QA(wf(:,85),wf(:,86)) * den(58)
  A(42) = cont_QA(wf(:,88),wf(:,89)) * den(62)
  A(43) = cont_QA(wf(:,65),wf(:,90)) * den(63)
  A(44) = cont_QA(wf(:,48),wf(:,92)) * den(65)
  A(45) = cont_QA(wf(:,40),wf(:,94)) * den(67)
  A(46) = cont_QA(wf(:,58),wf(:,83)) * den(68)
  A(47) = cont_QA(wf(:,69),wf(:,90)) * den(69)
  A(48) = cont_QA(wf(:,48),wf(:,96)) * den(71)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(48)
  complex(REALKIND), intent(out) :: M1(0), M2(3)


  M2(1) = ((-A(1)-A(3)-A(5)-A(7))*f(1))/2._/**/REALKIND+CI*(-A(37)-A(38)-A(39)-A(40)-A(41)-A(42)-A(43)-A(44)-A(45)-A(46)-A(47) &
       -A(48))*f(2)+(A(10)+A(11))*f(3)+CI*(A(13)+A(17)+A(25)+A(27)+A(31)+A(33))*f(4)+CI*(A(16)+A(20)+A(23)+A(24)+A(26)+A(28)+A(29) &
       +A(30)+A(32)+A(34)+A(35)+A(36))*f(5)+CI*(A(14)+A(15)+A(18)+A(19)+A(21)+A(22))*f(6)
  M2(2) = ((-A(2)-A(4)-A(6)-A(8))*f(1))/2._/**/REALKIND+CI*(A(37)+A(38)+A(39)+A(40)+A(41)+A(42)+A(43)+A(44)+A(45)+A(46)+A(47) &
       +A(48))*f(2)+(A(9)+A(12))*f(3)+CI*(-A(13)-A(17)-A(25)-A(27)-A(31)-A(33))*f(4)+CI*(-A(16)-A(20)-A(23)-A(24)-A(26)-A(28) &
       -A(29)-A(30)-A(32)-A(34)-A(35)-A(36))*f(5)+CI*(-A(14)-A(15)-A(18)-A(19)-A(21)-A(22))*f(6)
  M2(3) = ((A(1)+A(2)+A(3)+A(4)+A(5)+A(6)+A(7)+A(8))*f(1))/6._/**/REALKIND

end subroutine colourvectors

end module ol_loop_ppaajj2_uuxaagg_1_/**/REALKIND
