
module ol_vamp_1_ppaaaj2_uuxaaag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaaaj2_uuxaaag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaaaj2_uuxaaag_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppaaaj2_uuxaaag_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppaaaj2_uuxaaag_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,115) :: G0
  complex(REALKIND), dimension(4,5,4,300) :: G1
  complex(REALKIND), dimension(4,15,4,456) :: G2
  complex(REALKIND), dimension(4,35,4,342) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,108,64))
    allocate(G4tensorhel(70,108,64))
    allocate(G5tensorhel(126,72,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,20),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-3),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,-5),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,60),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,22),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),ZERO,G5tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,24),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,28),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,22),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),ZERO,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-5),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,56),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,1))
  call loop_AV_Q(G3(:,:,:,5),wf(:,7),G3(:,:,:,7))
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,63),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,48),ZERO,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,23),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,6),wf(:,27),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G2(:,:,:,6),wf(:,31),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,6),wf(:,35),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),ZERO,G3tensor(:,4))
  call loop_AV_Q(G2(:,:,:,6),wf(:,42),G2(:,:,:,11))
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),ZERO,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,6),wf(:,49),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),ZERO,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,11),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,27),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,59),ZERO,G3(:,:,:,8))
  call loop_AV_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9))
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,63),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,14),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,27),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,59),ZERO,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,-2),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,63),ZERO,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,20),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,28),MT,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,-5),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,60),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,22),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-3),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,24),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,28),MT,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-5),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,22),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-5),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,56),MT,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,4),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G3(:,:,:,16),wf(:,7),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-5),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,48),MT,G2(:,:,:,22))
  call loop_AV_Q(G2(:,:,:,22),wf(:,23),G2(:,:,:,23))
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,22),wf(:,27),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G2(:,:,:,22),wf(:,31),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,22),wf(:,35),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,22),wf(:,42),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,22),wf(:,49),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,7),wf(:,11),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,27),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,59),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,14),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,27),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,59),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-2),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,16),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,20),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-3),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,28),ZERO,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-5),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,60),ZERO,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,22),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),ZERO,G5tensor(:,5))
  call loop_QV_A(G1(:,:,:,13),wf(:,-3),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,24),ZERO,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-2),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,28),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,-5),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,60),ZERO,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,22),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),ZERO,G5tensor(:,6))
  call loop_QV_A(G2(:,:,:,35),wf(:,-5),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,56),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QV_A(G3(:,:,:,27),wf(:,7),G3(:,:,:,29))
  call check_last_Q_A(l_switch,G3(:,:,:,29),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,48),ZERO,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,23),G2(:,:,:,39))
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),ZERO,G3tensor(:,13))
  call loop_QV_A(G2(:,:,:,38),wf(:,27),G2(:,:,:,40))
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),ZERO,G3tensor(:,14))
  call loop_QV_A(G2(:,:,:,38),wf(:,31),G2(:,:,:,41))
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,63),ZERO,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,38),wf(:,35),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),ZERO,G3tensor(:,16))
  call loop_QV_A(G2(:,:,:,38),wf(:,42),G2(:,:,:,43))
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,63),ZERO,G3tensor(:,17))
  call loop_QV_A(G2(:,:,:,38),wf(:,49),G2(:,:,:,44))
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),ZERO,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,13),wf(:,11),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,27),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-5),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,59),ZERO,G3(:,:,:,30))
  call loop_QV_A(G3(:,:,:,30),wf(:,-2),G3(:,:,:,31))
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,13),wf(:,14),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,27),ZERO,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,59),ZERO,G3(:,:,:,32))
  call loop_QV_A(G3(:,:,:,32),wf(:,-2),G3(:,:,:,33))
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-2),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,20),MT,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-3),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,28),MT,G3(:,:,:,34))
  call loop_QV_A(G3(:,:,:,34),wf(:,-5),G3(:,:,:,35))
  call loop_Q_A(G3(:,:,:,35),Q(:,60),MT,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,22),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,7))
  call loop_QV_A(G1(:,:,:,19),wf(:,-3),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,24),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,28),MT,G3(:,:,:,36))
  call loop_QV_A(G3(:,:,:,36),wf(:,-5),G3(:,:,:,37))
  call loop_Q_A(G3(:,:,:,37),Q(:,60),MT,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,22),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MT,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,56),MT,G3(:,:,:,38))
  call loop_QV_A(G3(:,:,:,38),wf(:,4),G3(:,:,:,39))
  call check_last_Q_A(l_switch,G3(:,:,:,39),Q(:,63),MT,G4tensor(:,13))
  call loop_QV_A(G3(:,:,:,38),wf(:,7),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,14))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,48),MT,G2(:,:,:,54))
  call loop_QV_A(G2(:,:,:,54),wf(:,23),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,54),wf(:,27),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G2(:,:,:,54),wf(:,31),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G2(:,:,:,54),wf(:,35),G2(:,:,:,58))
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,54),wf(:,42),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),MT,G3tensor(:,23))
  call loop_QV_A(G2(:,:,:,54),wf(:,49),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,19),wf(:,11),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,27),MT,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,59),MT,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,19),wf(:,14),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,27),MT,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,59),MT,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),MB,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-2),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,20),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-3),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,28),MB,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,60),MB,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,22),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,24),MB,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-2),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,28),MB,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-5),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,60),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,22),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,56),MB,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,63),MB,G4tensor(:,17))
  call loop_AV_Q(G3(:,:,:,49),wf(:,7),G3(:,:,:,51))
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),MB,G4tensor(:,18))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,48),MB,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,23),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,63),MB,G3tensor(:,25))
  call loop_AV_Q(G2(:,:,:,70),wf(:,27),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,70),wf(:,31),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,63),MB,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,70),wf(:,35),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,70),wf(:,42),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,63),MB,G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,70),wf(:,49),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,25),wf(:,11),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,27),MB,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-5),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,59),MB,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,-2),G3(:,:,:,53))
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,63),MB,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,25),wf(:,14),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,27),MB,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,59),MB,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-2),G3(:,:,:,55))
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,63),MB,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),MB,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-2),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,20),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-3),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,28),MB,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,-5),G3(:,:,:,57))
  call loop_Q_A(G3(:,:,:,57),Q(:,60),MB,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,22),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_QV_A(G1(:,:,:,31),wf(:,-3),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,24),MB,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-2),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,28),MB,G3(:,:,:,58))
  call loop_QV_A(G3(:,:,:,58),wf(:,-5),G3(:,:,:,59))
  call loop_Q_A(G3(:,:,:,59),Q(:,60),MB,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,22),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,56),MB,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,4),G3(:,:,:,61))
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MB,G4tensor(:,21))
  call loop_QV_A(G3(:,:,:,60),wf(:,7),G3(:,:,:,62))
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MB,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,31),wf(:,-5),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,48),MB,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,23),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G2(:,:,:,86),wf(:,27),G2(:,:,:,88))
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,32))
  call loop_QV_A(G2(:,:,:,86),wf(:,31),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,63),MB,G3tensor(:,33))
  call loop_QV_A(G2(:,:,:,86),wf(:,35),G2(:,:,:,90))
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,34))
  call loop_QV_A(G2(:,:,:,86),wf(:,42),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,86),wf(:,49),G2(:,:,:,92))
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MB,G3tensor(:,36))
  call loop_QV_A(G1(:,:,:,31),wf(:,11),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,27),MB,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,59),MB,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-2),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,31),wf(:,14),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,27),MB,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,59),MB,G3(:,:,:,65))
  call loop_QV_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66))
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MB,G4tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,-2),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,12),ZERO,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,28),ZERO,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,60),ZERO,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,22),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,44),ZERO,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,60),ZERO,G4(:,:,:,27))
  call loop_QV_A(G4(:,:,:,27),wf(:,22),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,63),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,24),ZERO,G2(:,:,:,100))
  call loop_QV_A(G2(:,:,:,100),wf(:,-2),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,28),ZERO,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,60),ZERO,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,22),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),ZERO,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,100),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,56),ZERO,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,4),G3(:,:,:,74))
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),ZERO,G4tensor(:,25))
  call loop_QV_A(G3(:,:,:,73),wf(:,7),G3(:,:,:,75))
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,63),ZERO,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,40),ZERO,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,44),ZERO,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,-4),G3(:,:,:,77))
  call loop_Q_A(G3(:,:,:,77),Q(:,60),ZERO,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,22),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),ZERO,G5tensor(:,16))
  call loop_QV_A(G2(:,:,:,103),wf(:,-4),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,56),ZERO,G3(:,:,:,78))
  call loop_QV_A(G3(:,:,:,78),wf(:,4),G3(:,:,:,79))
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,63),ZERO,G4tensor(:,27))
  call loop_QV_A(G3(:,:,:,78),wf(:,7),G3(:,:,:,80))
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),ZERO,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,103),wf(:,18),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,59),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-2),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),ZERO,G4tensor(:,29))
  call loop_QV_A(G2(:,:,:,103),wf(:,21),G2(:,:,:,107))
  call loop_Q_A(G2(:,:,:,107),Q(:,59),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-2),G3(:,:,:,84))
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,63),ZERO,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,37),wf(:,18),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,27),ZERO,G2(:,:,:,108))
  call loop_QV_A(G2(:,:,:,108),wf(:,-5),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,59),ZERO,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86))
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),ZERO,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,37),wf(:,21),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,27),ZERO,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,-5),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,59),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-2),G3(:,:,:,88))
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),ZERO,G4tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,-2),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,12),MT,G2(:,:,:,112))
  call loop_QV_A(G2(:,:,:,112),wf(:,-4),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,28),MT,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,60),MT,G4(:,:,:,33))
  call loop_QV_A(G4(:,:,:,33),wf(:,22),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,112),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,44),MT,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,-4),G3(:,:,:,92))
  call loop_Q_A(G3(:,:,:,92),Q(:,60),MT,G4(:,:,:,35))
  call loop_QV_A(G4(:,:,:,35),wf(:,22),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,24),MT,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,28),MT,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-5),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,60),MT,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,22),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,115),wf(:,-5),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,56),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,4),G3(:,:,:,96))
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G3(:,:,:,95),wf(:,7),G3(:,:,:,97))
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G1(:,:,:,43),wf(:,-5),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,40),MT,G2(:,:,:,118))
  call loop_QV_A(G2(:,:,:,118),wf(:,-2),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,44),MT,G3(:,:,:,98))
  call loop_QV_A(G3(:,:,:,98),wf(:,-4),G3(:,:,:,99))
  call loop_Q_A(G3(:,:,:,99),Q(:,60),MT,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,22),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G2(:,:,:,118),wf(:,-4),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,56),MT,G3(:,:,:,100))
  call loop_QV_A(G3(:,:,:,100),wf(:,4),G3(:,:,:,101))
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G3(:,:,:,100),wf(:,7),G3(:,:,:,102))
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,118),wf(:,18),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,59),MT,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-2),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,63),MT,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,118),wf(:,21),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,59),MT,G3(:,:,:,105))
  call loop_QV_A(G3(:,:,:,105),wf(:,-2),G3(:,:,:,106))
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,63),MT,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,43),wf(:,18),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,27),MT,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,-5),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,59),MT,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-2),G3(:,:,:,108))
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,63),MT,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,43),wf(:,21),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,27),MT,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-5),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,59),MT,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110))
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MT,G4tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,8),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-2),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,12),ZERO,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-4),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,28),ZERO,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-5),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,60),ZERO,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,22),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),ZERO,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,44),ZERO,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-4),G3(:,:,:,114))
  call loop_A_Q(G3(:,:,:,114),Q(:,60),ZERO,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,22),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),ZERO,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-4),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,24),ZERO,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-2),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,28),ZERO,G3(:,:,:,115))
  call loop_AV_Q(G3(:,:,:,115),wf(:,-5),G3(:,:,:,116))
  call loop_A_Q(G3(:,:,:,116),Q(:,60),ZERO,G4(:,:,:,45))
  call loop_AV_Q(G4(:,:,:,45),wf(:,22),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),ZERO,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-5),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,56),ZERO,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,4),G3(:,:,:,118))
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,63),ZERO,G4tensor(:,41))
  call loop_AV_Q(G3(:,:,:,117),wf(:,7),G3(:,:,:,119))
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,63),ZERO,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-5),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,40),ZERO,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-2),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,44),ZERO,G3(:,:,:,120))
  call loop_AV_Q(G3(:,:,:,120),wf(:,-4),G3(:,:,:,121))
  call loop_A_Q(G3(:,:,:,121),Q(:,60),ZERO,G4(:,:,:,47))
  call loop_AV_Q(G4(:,:,:,47),wf(:,22),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),ZERO,G5tensor(:,24))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,56),ZERO,G3(:,:,:,122))
  call loop_AV_Q(G3(:,:,:,122),wf(:,4),G3(:,:,:,123))
  call check_last_A_Q(l_switch,G3(:,:,:,123),Q(:,63),ZERO,G4tensor(:,43))
  call loop_AV_Q(G3(:,:,:,122),wf(:,7),G3(:,:,:,124))
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,63),ZERO,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,133),wf(:,18),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,59),ZERO,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-2),G3(:,:,:,126))
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,63),ZERO,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,133),wf(:,21),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,59),ZERO,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-2),G3(:,:,:,128))
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,63),ZERO,G4tensor(:,46))
  call loop_AV_Q(G1(:,:,:,49),wf(:,18),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,27),ZERO,G2(:,:,:,138))
  call loop_AV_Q(G2(:,:,:,138),wf(:,-5),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,59),ZERO,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-2),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,63),ZERO,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,49),wf(:,21),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,27),ZERO,G2(:,:,:,140))
  call loop_AV_Q(G2(:,:,:,140),wf(:,-5),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,59),ZERO,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-2),G3(:,:,:,132))
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,63),ZERO,G4tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),MT,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-2),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,12),MT,G2(:,:,:,142))
  call loop_AV_Q(G2(:,:,:,142),wf(:,-4),G2(:,:,:,143))
  call loop_A_Q(G2(:,:,:,143),Q(:,28),MT,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-5),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,60),MT,G4(:,:,:,49))
  call loop_AV_Q(G4(:,:,:,49),wf(:,22),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,142),wf(:,-5),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,44),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,60),MT,G4(:,:,:,51))
  call loop_AV_Q(G4(:,:,:,51),wf(:,22),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,24),MT,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-2),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,28),MT,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-5),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,60),MT,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,22),G4(:,:,:,54))
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-5),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,56),MT,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,4),G3(:,:,:,140))
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,63),MT,G4tensor(:,49))
  call loop_AV_Q(G3(:,:,:,139),wf(:,7),G3(:,:,:,141))
  call check_last_A_Q(l_switch,G3(:,:,:,141),Q(:,63),MT,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,40),MT,G2(:,:,:,148))
  call loop_AV_Q(G2(:,:,:,148),wf(:,-2),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,44),MT,G3(:,:,:,142))
  call loop_AV_Q(G3(:,:,:,142),wf(:,-4),G3(:,:,:,143))
  call loop_A_Q(G3(:,:,:,143),Q(:,60),MT,G4(:,:,:,55))
  call loop_AV_Q(G4(:,:,:,55),wf(:,22),G4(:,:,:,56))
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G2(:,:,:,148),wf(:,-4),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,56),MT,G3(:,:,:,144))
  call loop_AV_Q(G3(:,:,:,144),wf(:,4),G3(:,:,:,145))
  call check_last_A_Q(l_switch,G3(:,:,:,145),Q(:,63),MT,G4tensor(:,51))
  call loop_AV_Q(G3(:,:,:,144),wf(:,7),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,148),wf(:,18),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,59),MT,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-2),G3(:,:,:,148))
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,63),MT,G4tensor(:,53))
  call loop_AV_Q(G2(:,:,:,148),wf(:,21),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,59),MT,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150))
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,63),MT,G4tensor(:,54))
  call loop_AV_Q(G1(:,:,:,55),wf(:,18),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,27),MT,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-5),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,59),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-2),G3(:,:,:,152))
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,63),MT,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,21),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,27),MT,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,59),MT,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,-2),G3(:,:,:,154))
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,63),MT,G4tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),MB,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,-2),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,12),MB,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,28),MB,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,-5),G3(:,:,:,156))
  call loop_Q_A(G3(:,:,:,156),Q(:,60),MB,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,22),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,63),MB,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,157),wf(:,-5),G2(:,:,:,159))
  call loop_Q_A(G2(:,:,:,159),Q(:,44),MB,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,-4),G3(:,:,:,158))
  call loop_Q_A(G3(:,:,:,158),Q(:,60),MB,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,22),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,61),wf(:,-4),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,24),MB,G2(:,:,:,160))
  call loop_QV_A(G2(:,:,:,160),wf(:,-2),G2(:,:,:,161))
  call loop_Q_A(G2(:,:,:,161),Q(:,28),MB,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-5),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,60),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,22),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,63),MB,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,160),wf(:,-5),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,56),MB,G3(:,:,:,161))
  call loop_QV_A(G3(:,:,:,161),wf(:,4),G3(:,:,:,162))
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,63),MB,G4tensor(:,57))
  call loop_QV_A(G3(:,:,:,161),wf(:,7),G3(:,:,:,163))
  call check_last_Q_A(l_switch,G3(:,:,:,163),Q(:,63),MB,G4tensor(:,58))
  call loop_QV_A(G1(:,:,:,61),wf(:,-5),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,40),MB,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,44),MB,G3(:,:,:,164))
  call loop_QV_A(G3(:,:,:,164),wf(:,-4),G3(:,:,:,165))
  call loop_Q_A(G3(:,:,:,165),Q(:,60),MB,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,22),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,63),MB,G5tensor(:,32))
  call loop_QV_A(G2(:,:,:,163),wf(:,-4),G2(:,:,:,165))
  call loop_Q_A(G2(:,:,:,165),Q(:,56),MB,G3(:,:,:,166))
  call loop_QV_A(G3(:,:,:,166),wf(:,4),G3(:,:,:,167))
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,63),MB,G4tensor(:,59))
  call loop_QV_A(G3(:,:,:,166),wf(:,7),G3(:,:,:,168))
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),MB,G4tensor(:,60))
  call loop_QV_A(G2(:,:,:,163),wf(:,18),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,59),MB,G3(:,:,:,169))
  call loop_QV_A(G3(:,:,:,169),wf(:,-2),G3(:,:,:,170))
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,63),MB,G4tensor(:,61))
  call loop_QV_A(G2(:,:,:,163),wf(:,21),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,59),MB,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-2),G3(:,:,:,172))
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,63),MB,G4tensor(:,62))
  call loop_QV_A(G1(:,:,:,61),wf(:,18),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,27),MB,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,-5),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,59),MB,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-2),G3(:,:,:,174))
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,63),MB,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,61),wf(:,21),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,27),MB,G2(:,:,:,170))
  call loop_QV_A(G2(:,:,:,170),wf(:,-5),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,59),MB,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-2),G3(:,:,:,176))
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),MB,G4tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),MB,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-2),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,12),MB,G2(:,:,:,172))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-4),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,28),MB,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,-5),G3(:,:,:,178))
  call loop_A_Q(G3(:,:,:,178),Q(:,60),MB,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,22),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,63),MB,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,44),MB,G3(:,:,:,179))
  call loop_AV_Q(G3(:,:,:,179),wf(:,-4),G3(:,:,:,180))
  call loop_A_Q(G3(:,:,:,180),Q(:,60),MB,G4(:,:,:,67))
  call loop_AV_Q(G4(:,:,:,67),wf(:,22),G4(:,:,:,68))
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,24),MB,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,28),MB,G3(:,:,:,181))
  call loop_AV_Q(G3(:,:,:,181),wf(:,-5),G3(:,:,:,182))
  call loop_A_Q(G3(:,:,:,182),Q(:,60),MB,G4(:,:,:,69))
  call loop_AV_Q(G4(:,:,:,69),wf(:,22),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MB,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-5),G2(:,:,:,177))
  call loop_A_Q(G2(:,:,:,177),Q(:,56),MB,G3(:,:,:,183))
  call loop_AV_Q(G3(:,:,:,183),wf(:,4),G3(:,:,:,184))
  call check_last_A_Q(l_switch,G3(:,:,:,184),Q(:,63),MB,G4tensor(:,65))
  call loop_AV_Q(G3(:,:,:,183),wf(:,7),G3(:,:,:,185))
  call check_last_A_Q(l_switch,G3(:,:,:,185),Q(:,63),MB,G4tensor(:,66))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,40),MB,G2(:,:,:,178))
  call loop_AV_Q(G2(:,:,:,178),wf(:,-2),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,44),MB,G3(:,:,:,186))
  call loop_AV_Q(G3(:,:,:,186),wf(:,-4),G3(:,:,:,187))
  call loop_A_Q(G3(:,:,:,187),Q(:,60),MB,G4(:,:,:,71))
  call loop_AV_Q(G4(:,:,:,71),wf(:,22),G4(:,:,:,72))
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,63),MB,G5tensor(:,36))
  call loop_AV_Q(G2(:,:,:,178),wf(:,-4),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,56),MB,G3(:,:,:,188))
  call loop_AV_Q(G3(:,:,:,188),wf(:,4),G3(:,:,:,189))
  call check_last_A_Q(l_switch,G3(:,:,:,189),Q(:,63),MB,G4tensor(:,67))
  call loop_AV_Q(G3(:,:,:,188),wf(:,7),G3(:,:,:,190))
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MB,G4tensor(:,68))
  call loop_AV_Q(G2(:,:,:,178),wf(:,18),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,59),MB,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-2),G3(:,:,:,192))
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,63),MB,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,178),wf(:,21),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,59),MB,G3(:,:,:,193))
  call loop_AV_Q(G3(:,:,:,193),wf(:,-2),G3(:,:,:,194))
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,63),MB,G4tensor(:,70))
  call loop_AV_Q(G1(:,:,:,67),wf(:,18),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,27),MB,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,59),MB,G3(:,:,:,195))
  call loop_AV_Q(G3(:,:,:,195),wf(:,-2),G3(:,:,:,196))
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,63),MB,G4tensor(:,71))
  call loop_AV_Q(G1(:,:,:,67),wf(:,21),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,27),MB,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-5),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,59),MB,G3(:,:,:,197))
  call loop_AV_Q(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198))
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,63),MB,G4tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-3),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,12),ZERO,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,28),ZERO,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,60),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,22),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,63),ZERO,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-5),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,44),ZERO,G3(:,:,:,201))
  call loop_AV_Q(G3(:,:,:,201),wf(:,-4),G3(:,:,:,202))
  call loop_A_Q(G3(:,:,:,202),Q(:,60),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,22),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,63),ZERO,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-4),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,20),ZERO,G2(:,:,:,190))
  call loop_AV_Q(G2(:,:,:,190),wf(:,-3),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,28),ZERO,G3(:,:,:,203))
  call loop_AV_Q(G3(:,:,:,203),wf(:,-5),G3(:,:,:,204))
  call loop_A_Q(G3(:,:,:,204),Q(:,60),ZERO,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,22),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,63),ZERO,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,190),wf(:,-5),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,52),ZERO,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-3),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,60),ZERO,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,22),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),ZERO,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-5),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,36),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-3),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,44),ZERO,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,60),ZERO,G4(:,:,:,81))
  call loop_AV_Q(G4(:,:,:,81),wf(:,22),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),ZERO,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-4),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,52),ZERO,G3(:,:,:,209))
  call loop_AV_Q(G3(:,:,:,209),wf(:,-3),G3(:,:,:,210))
  call loop_A_Q(G3(:,:,:,210),Q(:,60),ZERO,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,22),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),ZERO,G5tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-3),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,12),MT,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,28),MT,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,-5),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,60),MT,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,22),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-5),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,44),MT,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-4),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,60),MT,G4(:,:,:,87))
  call loop_AV_Q(G4(:,:,:,87),wf(:,22),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,63),MT,G5tensor(:,44))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,20),MT,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-3),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,28),MT,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-5),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,60),MT,G4(:,:,:,89))
  call loop_AV_Q(G4(:,:,:,89),wf(:,22),G4(:,:,:,90))
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,45))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-5),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,52),MT,G3(:,:,:,217))
  call loop_AV_Q(G3(:,:,:,217),wf(:,-3),G3(:,:,:,218))
  call loop_A_Q(G3(:,:,:,218),Q(:,60),MT,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,22),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,46))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,36),MT,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-3),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,44),MT,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-4),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,60),MT,G4(:,:,:,93))
  call loop_AV_Q(G4(:,:,:,93),wf(:,22),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,47))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-4),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,52),MT,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-3),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,60),MT,G4(:,:,:,95))
  call loop_AV_Q(G4(:,:,:,95),wf(:,22),G4(:,:,:,96))
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,-3),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,12),ZERO,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-4),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,28),ZERO,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,-5),G3(:,:,:,224))
  call loop_Q_A(G3(:,:,:,224),Q(:,60),ZERO,G4(:,:,:,97))
  call loop_QV_A(G4(:,:,:,97),wf(:,22),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,63),ZERO,G5tensor(:,49))
  call loop_QV_A(G2(:,:,:,205),wf(:,-5),G2(:,:,:,207))
  call loop_Q_A(G2(:,:,:,207),Q(:,44),ZERO,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,-4),G3(:,:,:,226))
  call loop_Q_A(G3(:,:,:,226),Q(:,60),ZERO,G4(:,:,:,99))
  call loop_QV_A(G4(:,:,:,99),wf(:,22),G4(:,:,:,100))
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,63),ZERO,G5tensor(:,50))
  call loop_QV_A(G1(:,:,:,81),wf(:,-4),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,20),ZERO,G2(:,:,:,208))
  call loop_QV_A(G2(:,:,:,208),wf(:,-3),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,28),ZERO,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-5),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,60),ZERO,G4(:,:,:,101))
  call loop_QV_A(G4(:,:,:,101),wf(:,22),G4(:,:,:,102))
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,63),ZERO,G5tensor(:,51))
  call loop_QV_A(G2(:,:,:,208),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,52),ZERO,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,-3),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,60),ZERO,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,22),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,63),ZERO,G5tensor(:,52))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,36),ZERO,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-3),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,44),ZERO,G3(:,:,:,231))
  call loop_QV_A(G3(:,:,:,231),wf(:,-4),G3(:,:,:,232))
  call loop_Q_A(G3(:,:,:,232),Q(:,60),ZERO,G4(:,:,:,105))
  call loop_QV_A(G4(:,:,:,105),wf(:,22),G4(:,:,:,106))
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,63),ZERO,G5tensor(:,53))
  call loop_QV_A(G2(:,:,:,211),wf(:,-4),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,52),ZERO,G3(:,:,:,233))
  call loop_QV_A(G3(:,:,:,233),wf(:,-3),G3(:,:,:,234))
  call loop_Q_A(G3(:,:,:,234),Q(:,60),ZERO,G4(:,:,:,107))
  call loop_QV_A(G4(:,:,:,107),wf(:,22),G4(:,:,:,108))
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),ZERO,G5tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,4),MT,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-3),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,12),MT,G2(:,:,:,214))
  call loop_QV_A(G2(:,:,:,214),wf(:,-4),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,28),MT,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,-5),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,60),MT,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,22),G4(:,:,:,110))
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,63),MT,G5tensor(:,55))
  call loop_QV_A(G2(:,:,:,214),wf(:,-5),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,44),MT,G3(:,:,:,237))
  call loop_QV_A(G3(:,:,:,237),wf(:,-4),G3(:,:,:,238))
  call loop_Q_A(G3(:,:,:,238),Q(:,60),MT,G4(:,:,:,111))
  call loop_QV_A(G4(:,:,:,111),wf(:,22),G4(:,:,:,112))
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,63),MT,G5tensor(:,56))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,20),MT,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-3),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,28),MT,G3(:,:,:,239))
  call loop_QV_A(G3(:,:,:,239),wf(:,-5),G3(:,:,:,240))
  call loop_Q_A(G3(:,:,:,240),Q(:,60),MT,G4(:,:,:,113))
  call loop_QV_A(G4(:,:,:,113),wf(:,22),G4(:,:,:,114))
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,63),MT,G5tensor(:,57))
  call loop_QV_A(G2(:,:,:,217),wf(:,-5),G2(:,:,:,219))
  call loop_Q_A(G2(:,:,:,219),Q(:,52),MT,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,-3),G3(:,:,:,242))
  call loop_Q_A(G3(:,:,:,242),Q(:,60),MT,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,22),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,36),MT,G2(:,:,:,220))
  call loop_QV_A(G2(:,:,:,220),wf(:,-3),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,44),MT,G3(:,:,:,243))
  call loop_QV_A(G3(:,:,:,243),wf(:,-4),G3(:,:,:,244))
  call loop_Q_A(G3(:,:,:,244),Q(:,60),MT,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,22),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,63),MT,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,220),wf(:,-4),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,52),MT,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-3),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,60),MT,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,22),G4(:,:,:,120))
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,63),MT,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,4),MB,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-3),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,12),MB,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-4),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,28),MB,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,-5),G3(:,:,:,248))
  call loop_A_Q(G3(:,:,:,248),Q(:,60),MB,G4(:,:,:,121))
  call loop_AV_Q(G4(:,:,:,121),wf(:,22),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,63),MB,G5tensor(:,61))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-5),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,44),MB,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,-4),G3(:,:,:,250))
  call loop_A_Q(G3(:,:,:,250),Q(:,60),MB,G4(:,:,:,123))
  call loop_AV_Q(G4(:,:,:,123),wf(:,22),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,63),MB,G5tensor(:,62))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-4),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,20),MB,G2(:,:,:,226))
  call loop_AV_Q(G2(:,:,:,226),wf(:,-3),G2(:,:,:,227))
  call loop_A_Q(G2(:,:,:,227),Q(:,28),MB,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-5),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,60),MB,G4(:,:,:,125))
  call loop_AV_Q(G4(:,:,:,125),wf(:,22),G4(:,:,:,126))
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,63),MB,G5tensor(:,63))
  call loop_AV_Q(G2(:,:,:,226),wf(:,-5),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,52),MB,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,-3),G3(:,:,:,254))
  call loop_A_Q(G3(:,:,:,254),Q(:,60),MB,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,22),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,63),MB,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-5),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,36),MB,G2(:,:,:,229))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-3),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,44),MB,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-4),G3(:,:,:,256))
  call loop_A_Q(G3(:,:,:,256),Q(:,60),MB,G4(:,:,:,129))
  call loop_AV_Q(G4(:,:,:,129),wf(:,22),G4(:,:,:,130))
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,63),MB,G5tensor(:,65))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-4),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,52),MB,G3(:,:,:,257))
  call loop_AV_Q(G3(:,:,:,257),wf(:,-3),G3(:,:,:,258))
  call loop_A_Q(G3(:,:,:,258),Q(:,60),MB,G4(:,:,:,131))
  call loop_AV_Q(G4(:,:,:,131),wf(:,22),G4(:,:,:,132))
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,63),MB,G5tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,4),MB,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,-3),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,12),MB,G2(:,:,:,232))
  call loop_QV_A(G2(:,:,:,232),wf(:,-4),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,28),MB,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,-5),G3(:,:,:,260))
  call loop_Q_A(G3(:,:,:,260),Q(:,60),MB,G4(:,:,:,133))
  call loop_QV_A(G4(:,:,:,133),wf(:,22),G4(:,:,:,134))
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,63),MB,G5tensor(:,67))
  call loop_QV_A(G2(:,:,:,232),wf(:,-5),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,44),MB,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-4),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,60),MB,G4(:,:,:,135))
  call loop_QV_A(G4(:,:,:,135),wf(:,22),G4(:,:,:,136))
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,63),MB,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,93),wf(:,-4),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,20),MB,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,-3),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,28),MB,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,60),MB,G4(:,:,:,137))
  call loop_QV_A(G4(:,:,:,137),wf(:,22),G4(:,:,:,138))
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,63),MB,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,235),wf(:,-5),G2(:,:,:,237))
  call loop_Q_A(G2(:,:,:,237),Q(:,52),MB,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-3),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,60),MB,G4(:,:,:,139))
  call loop_QV_A(G4(:,:,:,139),wf(:,22),G4(:,:,:,140))
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,63),MB,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,93),wf(:,-5),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,36),MB,G2(:,:,:,238))
  call loop_QV_A(G2(:,:,:,238),wf(:,-3),G2(:,:,:,239))
  call loop_Q_A(G2(:,:,:,239),Q(:,44),MB,G3(:,:,:,267))
  call loop_QV_A(G3(:,:,:,267),wf(:,-4),G3(:,:,:,268))
  call loop_Q_A(G3(:,:,:,268),Q(:,60),MB,G4(:,:,:,141))
  call loop_QV_A(G4(:,:,:,141),wf(:,22),G4(:,:,:,142))
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,63),MB,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,238),wf(:,-4),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,52),MB,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-3),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,60),MB,G4(:,:,:,143))
  call loop_QV_A(G4(:,:,:,143),wf(:,22),G4(:,:,:,144))
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,63),MB,G5tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,23),ZERO,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,-5),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,55),ZERO,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-3),G2(:,:,:,242))
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,63),ZERO,G3tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,23),MT,G1(:,:,:,99))
  call loop_QV_A(G1(:,:,:,99),wf(:,-5),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,55),MT,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-3),G2(:,:,:,244))
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,23),ZERO,G1(:,:,:,101))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,55),ZERO,G2(:,:,:,245))
  call loop_AV_Q(G2(:,:,:,245),wf(:,-3),G2(:,:,:,246))
  call check_last_A_Q(l_switch,G2(:,:,:,246),Q(:,63),ZERO,G3tensor(:,39))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,23),MT,G1(:,:,:,103))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-5),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,55),MT,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-3),G2(:,:,:,248))
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,23),MB,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,55),MB,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,-3),G2(:,:,:,250))
  call check_last_Q_A(l_switch,G2(:,:,:,250),Q(:,63),MB,G3tensor(:,41))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,23),MB,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,55),MB,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-3),G2(:,:,:,252))
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),MB,G3tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,23),ZERO,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,-5),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,55),ZERO,G2(:,:,:,253))
  call loop_QV_A(G2(:,:,:,253),wf(:,-3),G2(:,:,:,254))
  call check_last_Q_A(l_switch,G2(:,:,:,254),Q(:,63),ZERO,G3tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,23),MT,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,55),MT,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,-3),G2(:,:,:,256))
  call check_last_Q_A(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,44))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,23),ZERO,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,55),ZERO,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-3),G2(:,:,:,258))
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,63),ZERO,G3tensor(:,45))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,23),MT,G1(:,:,:,115))
  call loop_AV_Q(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,55),MT,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-3),G2(:,:,:,260))
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,23),MB,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,55),MB,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,-3),G2(:,:,:,262))
  call check_last_Q_A(l_switch,G2(:,:,:,262),Q(:,63),MB,G3tensor(:,47))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,23),MB,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,55),MB,G2(:,:,:,263))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-3),G2(:,:,:,264))
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,63),MB,G3tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,23),ZERO,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,55),ZERO,G2(:,:,:,265))
  call loop_QV_A(G2(:,:,:,265),wf(:,-3),G2(:,:,:,266))
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,63),ZERO,G3tensor(:,49))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,23),MT,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,-5),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,55),MT,G2(:,:,:,267))
  call loop_QV_A(G2(:,:,:,267),wf(:,-3),G2(:,:,:,268))
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,63),MT,G3tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,23),ZERO,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,55),ZERO,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-3),G2(:,:,:,270))
  call check_last_A_Q(l_switch,G2(:,:,:,270),Q(:,63),ZERO,G3tensor(:,51))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,23),MT,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,55),MT,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-3),G2(:,:,:,272))
  call check_last_A_Q(l_switch,G2(:,:,:,272),Q(:,63),MT,G3tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,23),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,-5),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,55),MB,G2(:,:,:,273))
  call loop_QV_A(G2(:,:,:,273),wf(:,-3),G2(:,:,:,274))
  call check_last_Q_A(l_switch,G2(:,:,:,274),Q(:,63),MB,G3tensor(:,53))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,23),MB,G1(:,:,:,131))
  call loop_AV_Q(G1(:,:,:,131),wf(:,-5),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,55),MB,G2(:,:,:,275))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-3),G2(:,:,:,276))
  call check_last_A_Q(l_switch,G2(:,:,:,276),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,23),ZERO,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,55),ZERO,G2(:,:,:,277))
  call loop_QV_A(G2(:,:,:,277),wf(:,-3),G2(:,:,:,278))
  call check_last_Q_A(l_switch,G2(:,:,:,278),Q(:,63),ZERO,G3tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,23),MT,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,-5),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,55),MT,G2(:,:,:,279))
  call loop_QV_A(G2(:,:,:,279),wf(:,-3),G2(:,:,:,280))
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,23),ZERO,G1(:,:,:,137))
  call loop_AV_Q(G1(:,:,:,137),wf(:,-5),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,55),ZERO,G2(:,:,:,281))
  call loop_AV_Q(G2(:,:,:,281),wf(:,-3),G2(:,:,:,282))
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,63),ZERO,G3tensor(:,57))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,23),MT,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-5),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,55),MT,G2(:,:,:,283))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-3),G2(:,:,:,284))
  call check_last_A_Q(l_switch,G2(:,:,:,284),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,23),MB,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,-5),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,55),MB,G2(:,:,:,285))
  call loop_QV_A(G2(:,:,:,285),wf(:,-3),G2(:,:,:,286))
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,63),MB,G3tensor(:,59))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,23),MB,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,55),MB,G2(:,:,:,287))
  call loop_AV_Q(G2(:,:,:,287),wf(:,-3),G2(:,:,:,288))
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,27),ZERO,G1(:,:,:,145))
  call loop_QV_A(G1(:,:,:,145),wf(:,-5),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,59),ZERO,G2(:,:,:,289))
  call loop_QV_A(G2(:,:,:,289),wf(:,-2),G2(:,:,:,290))
  call check_last_Q_A(l_switch,G2(:,:,:,290),Q(:,63),ZERO,G3tensor(:,61))
  call loop_QV_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,27),MT,G1(:,:,:,147))
  call loop_QV_A(G1(:,:,:,147),wf(:,-5),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,59),MT,G2(:,:,:,291))
  call loop_QV_A(G2(:,:,:,291),wf(:,-2),G2(:,:,:,292))
  call check_last_Q_A(l_switch,G2(:,:,:,292),Q(:,63),MT,G3tensor(:,62))
  call loop_AV_Q(G0(:,:,:,1),wf(:,39),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,27),ZERO,G1(:,:,:,149))
  call loop_AV_Q(G1(:,:,:,149),wf(:,-5),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,59),ZERO,G2(:,:,:,293))
  call loop_AV_Q(G2(:,:,:,293),wf(:,-2),G2(:,:,:,294))
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,63),ZERO,G3tensor(:,63))
  call loop_AV_Q(G0(:,:,:,1),wf(:,39),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,27),MT,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,59),MT,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-2),G2(:,:,:,296))
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,27),MB,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,59),MB,G2(:,:,:,297))
  call loop_QV_A(G2(:,:,:,297),wf(:,-2),G2(:,:,:,298))
  call check_last_Q_A(l_switch,G2(:,:,:,298),Q(:,63),MB,G3tensor(:,65))
  call loop_AV_Q(G0(:,:,:,1),wf(:,39),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,27),MB,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,59),MB,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-2),G2(:,:,:,300))
  call check_last_A_Q(l_switch,G2(:,:,:,300),Q(:,63),MB,G3tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,11),ZERO,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,-5),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,43),ZERO,G2(:,:,:,301))
  call loop_QV_A(G2(:,:,:,301),wf(:,-4),G2(:,:,:,302))
  call loop_Q_A(G2(:,:,:,302),Q(:,59),ZERO,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-2),G3(:,:,:,272))
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,63),ZERO,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,157),wf(:,-4),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,27),ZERO,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,-5),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,59),ZERO,G3(:,:,:,273))
  call loop_QV_A(G3(:,:,:,273),wf(:,-2),G3(:,:,:,274))
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,63),ZERO,G4tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,11),MT,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,-5),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,43),MT,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,-4),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,59),MT,G3(:,:,:,275))
  call loop_QV_A(G3(:,:,:,275),wf(:,-2),G3(:,:,:,276))
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,63),MT,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,160),wf(:,-4),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,27),MT,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-5),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,59),MT,G3(:,:,:,277))
  call loop_QV_A(G3(:,:,:,277),wf(:,-2),G3(:,:,:,278))
  call check_last_Q_A(l_switch,G3(:,:,:,278),Q(:,63),MT,G4tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,11),ZERO,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-5),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,43),ZERO,G2(:,:,:,309))
  call loop_AV_Q(G2(:,:,:,309),wf(:,-4),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,59),ZERO,G3(:,:,:,279))
  call loop_AV_Q(G3(:,:,:,279),wf(:,-2),G3(:,:,:,280))
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,63),ZERO,G4tensor(:,77))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-4),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,27),ZERO,G2(:,:,:,311))
  call loop_AV_Q(G2(:,:,:,311),wf(:,-5),G2(:,:,:,312))
  call loop_A_Q(G2(:,:,:,312),Q(:,59),ZERO,G3(:,:,:,281))
  call loop_AV_Q(G3(:,:,:,281),wf(:,-2),G3(:,:,:,282))
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,63),ZERO,G4tensor(:,78))
  call loop_AV_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,11),MT,G1(:,:,:,166))
  call loop_AV_Q(G1(:,:,:,166),wf(:,-5),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,43),MT,G2(:,:,:,313))
  call loop_AV_Q(G2(:,:,:,313),wf(:,-4),G2(:,:,:,314))
  call loop_A_Q(G2(:,:,:,314),Q(:,59),MT,G3(:,:,:,283))
  call loop_AV_Q(G3(:,:,:,283),wf(:,-2),G3(:,:,:,284))
  call check_last_A_Q(l_switch,G3(:,:,:,284),Q(:,63),MT,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,166),wf(:,-4),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,27),MT,G2(:,:,:,315))
  call loop_AV_Q(G2(:,:,:,315),wf(:,-5),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,59),MT,G3(:,:,:,285))
  call loop_AV_Q(G3(:,:,:,285),wf(:,-2),G3(:,:,:,286))
  call check_last_A_Q(l_switch,G3(:,:,:,286),Q(:,63),MT,G4tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,11),MB,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,43),MB,G2(:,:,:,317))
  call loop_QV_A(G2(:,:,:,317),wf(:,-4),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,59),MB,G3(:,:,:,287))
  call loop_QV_A(G3(:,:,:,287),wf(:,-2),G3(:,:,:,288))
  call check_last_Q_A(l_switch,G3(:,:,:,288),Q(:,63),MB,G4tensor(:,81))
  call loop_QV_A(G1(:,:,:,169),wf(:,-4),G1(:,:,:,171))
  call loop_Q_A(G1(:,:,:,171),Q(:,27),MB,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,59),MB,G3(:,:,:,289))
  call loop_QV_A(G3(:,:,:,289),wf(:,-2),G3(:,:,:,290))
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,63),MB,G4tensor(:,82))
  call loop_AV_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,11),MB,G1(:,:,:,172))
  call loop_AV_Q(G1(:,:,:,172),wf(:,-5),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,43),MB,G2(:,:,:,321))
  call loop_AV_Q(G2(:,:,:,321),wf(:,-4),G2(:,:,:,322))
  call loop_A_Q(G2(:,:,:,322),Q(:,59),MB,G3(:,:,:,291))
  call loop_AV_Q(G3(:,:,:,291),wf(:,-2),G3(:,:,:,292))
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,63),MB,G4tensor(:,83))
  call loop_AV_Q(G1(:,:,:,172),wf(:,-4),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,27),MB,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-5),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,59),MB,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-2),G3(:,:,:,294))
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,63),MB,G4tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,27),ZERO,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,59),ZERO,G2(:,:,:,325))
  call loop_QV_A(G2(:,:,:,325),wf(:,-2),G2(:,:,:,326))
  call check_last_Q_A(l_switch,G2(:,:,:,326),Q(:,63),ZERO,G3tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,27),MT,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,59),MT,G2(:,:,:,327))
  call loop_QV_A(G2(:,:,:,327),wf(:,-2),G2(:,:,:,328))
  call check_last_Q_A(l_switch,G2(:,:,:,328),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,27),ZERO,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,59),ZERO,G2(:,:,:,329))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-2),G2(:,:,:,330))
  call check_last_A_Q(l_switch,G2(:,:,:,330),Q(:,63),ZERO,G3tensor(:,69))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,27),MT,G1(:,:,:,181))
  call loop_AV_Q(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,59),MT,G2(:,:,:,331))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-2),G2(:,:,:,332))
  call check_last_A_Q(l_switch,G2(:,:,:,332),Q(:,63),MT,G3tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,27),MB,G1(:,:,:,183))
  call loop_QV_A(G1(:,:,:,183),wf(:,-5),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,59),MB,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,-2),G2(:,:,:,334))
  call check_last_Q_A(l_switch,G2(:,:,:,334),Q(:,63),MB,G3tensor(:,71))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,27),MB,G1(:,:,:,185))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-5),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,59),MB,G2(:,:,:,335))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-2),G2(:,:,:,336))
  call check_last_A_Q(l_switch,G2(:,:,:,336),Q(:,63),MB,G3tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,27),ZERO,G1(:,:,:,187))
  call loop_QV_A(G1(:,:,:,187),wf(:,-5),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,59),ZERO,G2(:,:,:,337))
  call loop_QV_A(G2(:,:,:,337),wf(:,-2),G2(:,:,:,338))
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),ZERO,G3tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,27),MT,G1(:,:,:,189))
  call loop_QV_A(G1(:,:,:,189),wf(:,-5),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,59),MT,G2(:,:,:,339))
  call loop_QV_A(G2(:,:,:,339),wf(:,-2),G2(:,:,:,340))
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,63),MT,G3tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,27),ZERO,G1(:,:,:,191))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-5),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,59),ZERO,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-2),G2(:,:,:,342))
  call check_last_A_Q(l_switch,G2(:,:,:,342),Q(:,63),ZERO,G3tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,27),MT,G1(:,:,:,193))
  call loop_AV_Q(G1(:,:,:,193),wf(:,-5),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,59),MT,G2(:,:,:,343))
  call loop_AV_Q(G2(:,:,:,343),wf(:,-2),G2(:,:,:,344))
  call check_last_A_Q(l_switch,G2(:,:,:,344),Q(:,63),MT,G3tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,27),MB,G1(:,:,:,195))
  call loop_QV_A(G1(:,:,:,195),wf(:,-5),G1(:,:,:,196))
  call loop_Q_A(G1(:,:,:,196),Q(:,59),MB,G2(:,:,:,345))
  call loop_QV_A(G2(:,:,:,345),wf(:,-2),G2(:,:,:,346))
  call check_last_Q_A(l_switch,G2(:,:,:,346),Q(:,63),MB,G3tensor(:,77))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,27),MB,G1(:,:,:,197))
  call loop_AV_Q(G1(:,:,:,197),wf(:,-5),G1(:,:,:,198))
  call loop_A_Q(G1(:,:,:,198),Q(:,59),MB,G2(:,:,:,347))
  call loop_AV_Q(G2(:,:,:,347),wf(:,-2),G2(:,:,:,348))
  call check_last_A_Q(l_switch,G2(:,:,:,348),Q(:,63),MB,G3tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,11),ZERO,G1(:,:,:,199))
  call loop_QV_A(G1(:,:,:,199),wf(:,-5),G1(:,:,:,200))
  call loop_Q_A(G1(:,:,:,200),Q(:,43),ZERO,G2(:,:,:,349))
  call loop_QV_A(G2(:,:,:,349),wf(:,-4),G2(:,:,:,350))
  call loop_Q_A(G2(:,:,:,350),Q(:,59),ZERO,G3(:,:,:,295))
  call loop_QV_A(G3(:,:,:,295),wf(:,-2),G3(:,:,:,296))
  call check_last_Q_A(l_switch,G3(:,:,:,296),Q(:,63),ZERO,G4tensor(:,85))
  call loop_QV_A(G1(:,:,:,199),wf(:,-4),G1(:,:,:,201))
  call loop_Q_A(G1(:,:,:,201),Q(:,27),ZERO,G2(:,:,:,351))
  call loop_QV_A(G2(:,:,:,351),wf(:,-5),G2(:,:,:,352))
  call loop_Q_A(G2(:,:,:,352),Q(:,59),ZERO,G3(:,:,:,297))
  call loop_QV_A(G3(:,:,:,297),wf(:,-2),G3(:,:,:,298))
  call check_last_Q_A(l_switch,G3(:,:,:,298),Q(:,63),ZERO,G4tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,11),MT,G1(:,:,:,202))
  call loop_QV_A(G1(:,:,:,202),wf(:,-5),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,43),MT,G2(:,:,:,353))
  call loop_QV_A(G2(:,:,:,353),wf(:,-4),G2(:,:,:,354))
  call loop_Q_A(G2(:,:,:,354),Q(:,59),MT,G3(:,:,:,299))
  call loop_QV_A(G3(:,:,:,299),wf(:,-2),G3(:,:,:,300))
  call check_last_Q_A(l_switch,G3(:,:,:,300),Q(:,63),MT,G4tensor(:,87))
  call loop_QV_A(G1(:,:,:,202),wf(:,-4),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,27),MT,G2(:,:,:,355))
  call loop_QV_A(G2(:,:,:,355),wf(:,-5),G2(:,:,:,356))
  call loop_Q_A(G2(:,:,:,356),Q(:,59),MT,G3(:,:,:,301))
  call loop_QV_A(G3(:,:,:,301),wf(:,-2),G3(:,:,:,302))
  call check_last_Q_A(l_switch,G3(:,:,:,302),Q(:,63),MT,G4tensor(:,88))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,11),ZERO,G1(:,:,:,205))
  call loop_AV_Q(G1(:,:,:,205),wf(:,-5),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,43),ZERO,G2(:,:,:,357))
  call loop_AV_Q(G2(:,:,:,357),wf(:,-4),G2(:,:,:,358))
  call loop_A_Q(G2(:,:,:,358),Q(:,59),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-2),G3(:,:,:,304))
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,63),ZERO,G4tensor(:,89))
  call loop_AV_Q(G1(:,:,:,205),wf(:,-4),G1(:,:,:,207))
  call loop_A_Q(G1(:,:,:,207),Q(:,27),ZERO,G2(:,:,:,359))
  call loop_AV_Q(G2(:,:,:,359),wf(:,-5),G2(:,:,:,360))
  call loop_A_Q(G2(:,:,:,360),Q(:,59),ZERO,G3(:,:,:,305))
  call loop_AV_Q(G3(:,:,:,305),wf(:,-2),G3(:,:,:,306))
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,63),ZERO,G4tensor(:,90))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,11),MT,G1(:,:,:,208))
  call loop_AV_Q(G1(:,:,:,208),wf(:,-5),G1(:,:,:,209))
  call loop_A_Q(G1(:,:,:,209),Q(:,43),MT,G2(:,:,:,361))
  call loop_AV_Q(G2(:,:,:,361),wf(:,-4),G2(:,:,:,362))
  call loop_A_Q(G2(:,:,:,362),Q(:,59),MT,G3(:,:,:,307))
  call loop_AV_Q(G3(:,:,:,307),wf(:,-2),G3(:,:,:,308))
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,63),MT,G4tensor(:,91))
  call loop_AV_Q(G1(:,:,:,208),wf(:,-4),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,27),MT,G2(:,:,:,363))
  call loop_AV_Q(G2(:,:,:,363),wf(:,-5),G2(:,:,:,364))
  call loop_A_Q(G2(:,:,:,364),Q(:,59),MT,G3(:,:,:,309))
  call loop_AV_Q(G3(:,:,:,309),wf(:,-2),G3(:,:,:,310))
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,63),MT,G4tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,11),MB,G1(:,:,:,211))
  call loop_QV_A(G1(:,:,:,211),wf(:,-5),G1(:,:,:,212))
  call loop_Q_A(G1(:,:,:,212),Q(:,43),MB,G2(:,:,:,365))
  call loop_QV_A(G2(:,:,:,365),wf(:,-4),G2(:,:,:,366))
  call loop_Q_A(G2(:,:,:,366),Q(:,59),MB,G3(:,:,:,311))
  call loop_QV_A(G3(:,:,:,311),wf(:,-2),G3(:,:,:,312))
  call check_last_Q_A(l_switch,G3(:,:,:,312),Q(:,63),MB,G4tensor(:,93))
  call loop_QV_A(G1(:,:,:,211),wf(:,-4),G1(:,:,:,213))
  call loop_Q_A(G1(:,:,:,213),Q(:,27),MB,G2(:,:,:,367))
  call loop_QV_A(G2(:,:,:,367),wf(:,-5),G2(:,:,:,368))
  call loop_Q_A(G2(:,:,:,368),Q(:,59),MB,G3(:,:,:,313))
  call loop_QV_A(G3(:,:,:,313),wf(:,-2),G3(:,:,:,314))
  call check_last_Q_A(l_switch,G3(:,:,:,314),Q(:,63),MB,G4tensor(:,94))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,11),MB,G1(:,:,:,214))
  call loop_AV_Q(G1(:,:,:,214),wf(:,-5),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,43),MB,G2(:,:,:,369))
  call loop_AV_Q(G2(:,:,:,369),wf(:,-4),G2(:,:,:,370))
  call loop_A_Q(G2(:,:,:,370),Q(:,59),MB,G3(:,:,:,315))
  call loop_AV_Q(G3(:,:,:,315),wf(:,-2),G3(:,:,:,316))
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,63),MB,G4tensor(:,95))
  call loop_AV_Q(G1(:,:,:,214),wf(:,-4),G1(:,:,:,216))
  call loop_A_Q(G1(:,:,:,216),Q(:,27),MB,G2(:,:,:,371))
  call loop_AV_Q(G2(:,:,:,371),wf(:,-5),G2(:,:,:,372))
  call loop_A_Q(G2(:,:,:,372),Q(:,59),MB,G3(:,:,:,317))
  call loop_AV_Q(G3(:,:,:,317),wf(:,-2),G3(:,:,:,318))
  call check_last_A_Q(l_switch,G3(:,:,:,318),Q(:,63),MB,G4tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,27),ZERO,G1(:,:,:,217))
  call loop_QV_A(G1(:,:,:,217),wf(:,-5),G1(:,:,:,218))
  call loop_Q_A(G1(:,:,:,218),Q(:,59),ZERO,G2(:,:,:,373))
  call loop_QV_A(G2(:,:,:,373),wf(:,-2),G2(:,:,:,374))
  call check_last_Q_A(l_switch,G2(:,:,:,374),Q(:,63),ZERO,G3tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,75))
  call loop_Q_A(G0(:,:,:,75),Q(:,27),MT,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,-5),G1(:,:,:,220))
  call loop_Q_A(G1(:,:,:,220),Q(:,59),MT,G2(:,:,:,375))
  call loop_QV_A(G2(:,:,:,375),wf(:,-2),G2(:,:,:,376))
  call check_last_Q_A(l_switch,G2(:,:,:,376),Q(:,63),MT,G3tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,76))
  call loop_A_Q(G0(:,:,:,76),Q(:,27),ZERO,G1(:,:,:,221))
  call loop_AV_Q(G1(:,:,:,221),wf(:,-5),G1(:,:,:,222))
  call loop_A_Q(G1(:,:,:,222),Q(:,59),ZERO,G2(:,:,:,377))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-2),G2(:,:,:,378))
  call check_last_A_Q(l_switch,G2(:,:,:,378),Q(:,63),ZERO,G3tensor(:,81))
  call loop_AV_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,77))
  call loop_A_Q(G0(:,:,:,77),Q(:,27),MT,G1(:,:,:,223))
  call loop_AV_Q(G1(:,:,:,223),wf(:,-5),G1(:,:,:,224))
  call loop_A_Q(G1(:,:,:,224),Q(:,59),MT,G2(:,:,:,379))
  call loop_AV_Q(G2(:,:,:,379),wf(:,-2),G2(:,:,:,380))
  call check_last_A_Q(l_switch,G2(:,:,:,380),Q(:,63),MT,G3tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,27),MB,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,-5),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,59),MB,G2(:,:,:,381))
  call loop_QV_A(G2(:,:,:,381),wf(:,-2),G2(:,:,:,382))
  call check_last_Q_A(l_switch,G2(:,:,:,382),Q(:,63),MB,G3tensor(:,83))
  call loop_AV_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,79))
  call loop_A_Q(G0(:,:,:,79),Q(:,27),MB,G1(:,:,:,227))
  call loop_AV_Q(G1(:,:,:,227),wf(:,-5),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,59),MB,G2(:,:,:,383))
  call loop_AV_Q(G2(:,:,:,383),wf(:,-2),G2(:,:,:,384))
  call check_last_A_Q(l_switch,G2(:,:,:,384),Q(:,63),MB,G3tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,80))
  call loop_Q_A(G0(:,:,:,80),Q(:,19),ZERO,G1(:,:,:,229))
  call loop_QV_A(G1(:,:,:,229),wf(:,-3),G1(:,:,:,230))
  call loop_Q_A(G1(:,:,:,230),Q(:,27),ZERO,G2(:,:,:,385))
  call loop_QV_A(G2(:,:,:,385),wf(:,-5),G2(:,:,:,386))
  call loop_Q_A(G2(:,:,:,386),Q(:,59),ZERO,G3(:,:,:,319))
  call loop_QV_A(G3(:,:,:,319),wf(:,-2),G3(:,:,:,320))
  call check_last_Q_A(l_switch,G3(:,:,:,320),Q(:,63),ZERO,G4tensor(:,97))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,81))
  call loop_Q_A(G0(:,:,:,81),Q(:,19),MT,G1(:,:,:,231))
  call loop_QV_A(G1(:,:,:,231),wf(:,-3),G1(:,:,:,232))
  call loop_Q_A(G1(:,:,:,232),Q(:,27),MT,G2(:,:,:,387))
  call loop_QV_A(G2(:,:,:,387),wf(:,-5),G2(:,:,:,388))
  call loop_Q_A(G2(:,:,:,388),Q(:,59),MT,G3(:,:,:,321))
  call loop_QV_A(G3(:,:,:,321),wf(:,-2),G3(:,:,:,322))
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,63),MT,G4tensor(:,98))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,82))
  call loop_A_Q(G0(:,:,:,82),Q(:,19),ZERO,G1(:,:,:,233))
  call loop_AV_Q(G1(:,:,:,233),wf(:,-3),G1(:,:,:,234))
  call loop_A_Q(G1(:,:,:,234),Q(:,27),ZERO,G2(:,:,:,389))
  call loop_AV_Q(G2(:,:,:,389),wf(:,-5),G2(:,:,:,390))
  call loop_A_Q(G2(:,:,:,390),Q(:,59),ZERO,G3(:,:,:,323))
  call loop_AV_Q(G3(:,:,:,323),wf(:,-2),G3(:,:,:,324))
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,63),ZERO,G4tensor(:,99))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,83))
  call loop_A_Q(G0(:,:,:,83),Q(:,19),MT,G1(:,:,:,235))
  call loop_AV_Q(G1(:,:,:,235),wf(:,-3),G1(:,:,:,236))
  call loop_A_Q(G1(:,:,:,236),Q(:,27),MT,G2(:,:,:,391))
  call loop_AV_Q(G2(:,:,:,391),wf(:,-5),G2(:,:,:,392))
  call loop_A_Q(G2(:,:,:,392),Q(:,59),MT,G3(:,:,:,325))
  call loop_AV_Q(G3(:,:,:,325),wf(:,-2),G3(:,:,:,326))
  call check_last_A_Q(l_switch,G3(:,:,:,326),Q(:,63),MT,G4tensor(:,100))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,19),MB,G1(:,:,:,237))
  call loop_QV_A(G1(:,:,:,237),wf(:,-3),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,27),MB,G2(:,:,:,393))
  call loop_QV_A(G2(:,:,:,393),wf(:,-5),G2(:,:,:,394))
  call loop_Q_A(G2(:,:,:,394),Q(:,59),MB,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,-2),G3(:,:,:,328))
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,63),MB,G4tensor(:,101))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,85))
  call loop_A_Q(G0(:,:,:,85),Q(:,19),MB,G1(:,:,:,239))
  call loop_AV_Q(G1(:,:,:,239),wf(:,-3),G1(:,:,:,240))
  call loop_A_Q(G1(:,:,:,240),Q(:,27),MB,G2(:,:,:,395))
  call loop_AV_Q(G2(:,:,:,395),wf(:,-5),G2(:,:,:,396))
  call loop_A_Q(G2(:,:,:,396),Q(:,59),MB,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,-2),G3(:,:,:,330))
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,63),MB,G4tensor(:,102))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,86))
  call loop_Q_A(G0(:,:,:,86),Q(:,23),ZERO,G1(:,:,:,241))
  call loop_QV_A(G1(:,:,:,241),wf(:,-5),G1(:,:,:,242))
  call loop_Q_A(G1(:,:,:,242),Q(:,55),ZERO,G2(:,:,:,397))
  call loop_QV_A(G2(:,:,:,397),wf(:,-3),G2(:,:,:,398))
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,63),ZERO,G3tensor(:,85))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,87))
  call loop_Q_A(G0(:,:,:,87),Q(:,23),MT,G1(:,:,:,243))
  call loop_QV_A(G1(:,:,:,243),wf(:,-5),G1(:,:,:,244))
  call loop_Q_A(G1(:,:,:,244),Q(:,55),MT,G2(:,:,:,399))
  call loop_QV_A(G2(:,:,:,399),wf(:,-3),G2(:,:,:,400))
  call check_last_Q_A(l_switch,G2(:,:,:,400),Q(:,63),MT,G3tensor(:,86))
  call loop_AV_Q(G0(:,:,:,1),wf(:,55),G0(:,:,:,88))
  call loop_A_Q(G0(:,:,:,88),Q(:,23),ZERO,G1(:,:,:,245))
  call loop_AV_Q(G1(:,:,:,245),wf(:,-5),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,55),ZERO,G2(:,:,:,401))
  call loop_AV_Q(G2(:,:,:,401),wf(:,-3),G2(:,:,:,402))
  call check_last_A_Q(l_switch,G2(:,:,:,402),Q(:,63),ZERO,G3tensor(:,87))
  call loop_AV_Q(G0(:,:,:,1),wf(:,55),G0(:,:,:,89))
  call loop_A_Q(G0(:,:,:,89),Q(:,23),MT,G1(:,:,:,247))
  call loop_AV_Q(G1(:,:,:,247),wf(:,-5),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,55),MT,G2(:,:,:,403))
  call loop_AV_Q(G2(:,:,:,403),wf(:,-3),G2(:,:,:,404))
  call check_last_A_Q(l_switch,G2(:,:,:,404),Q(:,63),MT,G3tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,90))
  call loop_Q_A(G0(:,:,:,90),Q(:,23),MB,G1(:,:,:,249))
  call loop_QV_A(G1(:,:,:,249),wf(:,-5),G1(:,:,:,250))
  call loop_Q_A(G1(:,:,:,250),Q(:,55),MB,G2(:,:,:,405))
  call loop_QV_A(G2(:,:,:,405),wf(:,-3),G2(:,:,:,406))
  call check_last_Q_A(l_switch,G2(:,:,:,406),Q(:,63),MB,G3tensor(:,89))
  call loop_AV_Q(G0(:,:,:,1),wf(:,55),G0(:,:,:,91))
  call loop_A_Q(G0(:,:,:,91),Q(:,23),MB,G1(:,:,:,251))
  call loop_AV_Q(G1(:,:,:,251),wf(:,-5),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,55),MB,G2(:,:,:,407))
  call loop_AV_Q(G2(:,:,:,407),wf(:,-3),G2(:,:,:,408))
  call check_last_A_Q(l_switch,G2(:,:,:,408),Q(:,63),MB,G3tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,27),ZERO,G1(:,:,:,253))
  call loop_QV_A(G1(:,:,:,253),wf(:,-5),G1(:,:,:,254))
  call loop_Q_A(G1(:,:,:,254),Q(:,59),ZERO,G2(:,:,:,409))
  call loop_QV_A(G2(:,:,:,409),wf(:,-2),G2(:,:,:,410))
  call check_last_Q_A(l_switch,G2(:,:,:,410),Q(:,63),ZERO,G3tensor(:,91))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,93))
  call loop_Q_A(G0(:,:,:,93),Q(:,27),MT,G1(:,:,:,255))
  call loop_QV_A(G1(:,:,:,255),wf(:,-5),G1(:,:,:,256))
  call loop_Q_A(G1(:,:,:,256),Q(:,59),MT,G2(:,:,:,411))
  call loop_QV_A(G2(:,:,:,411),wf(:,-2),G2(:,:,:,412))
  call check_last_Q_A(l_switch,G2(:,:,:,412),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,94))
  call loop_A_Q(G0(:,:,:,94),Q(:,27),ZERO,G1(:,:,:,257))
  call loop_AV_Q(G1(:,:,:,257),wf(:,-5),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,59),ZERO,G2(:,:,:,413))
  call loop_AV_Q(G2(:,:,:,413),wf(:,-2),G2(:,:,:,414))
  call check_last_A_Q(l_switch,G2(:,:,:,414),Q(:,63),ZERO,G3tensor(:,93))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,95))
  call loop_A_Q(G0(:,:,:,95),Q(:,27),MT,G1(:,:,:,259))
  call loop_AV_Q(G1(:,:,:,259),wf(:,-5),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,59),MT,G2(:,:,:,415))
  call loop_AV_Q(G2(:,:,:,415),wf(:,-2),G2(:,:,:,416))
  call check_last_A_Q(l_switch,G2(:,:,:,416),Q(:,63),MT,G3tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,27),MB,G1(:,:,:,261))
  call loop_QV_A(G1(:,:,:,261),wf(:,-5),G1(:,:,:,262))
  call loop_Q_A(G1(:,:,:,262),Q(:,59),MB,G2(:,:,:,417))
  call loop_QV_A(G2(:,:,:,417),wf(:,-2),G2(:,:,:,418))
  call check_last_Q_A(l_switch,G2(:,:,:,418),Q(:,63),MB,G3tensor(:,95))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,97))
  call loop_A_Q(G0(:,:,:,97),Q(:,27),MB,G1(:,:,:,263))
  call loop_AV_Q(G1(:,:,:,263),wf(:,-5),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,59),MB,G2(:,:,:,419))
  call loop_AV_Q(G2(:,:,:,419),wf(:,-2),G2(:,:,:,420))
  call check_last_A_Q(l_switch,G2(:,:,:,420),Q(:,63),MB,G3tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,98))
  call loop_Q_A(G0(:,:,:,98),Q(:,19),ZERO,G1(:,:,:,265))
  call loop_QV_A(G1(:,:,:,265),wf(:,-3),G1(:,:,:,266))
  call loop_Q_A(G1(:,:,:,266),Q(:,27),ZERO,G2(:,:,:,421))
  call loop_QV_A(G2(:,:,:,421),wf(:,-5),G2(:,:,:,422))
  call loop_Q_A(G2(:,:,:,422),Q(:,59),ZERO,G3(:,:,:,331))
  call loop_QV_A(G3(:,:,:,331),wf(:,-2),G3(:,:,:,332))
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,63),ZERO,G4tensor(:,103))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,19),MT,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,-3),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,27),MT,G2(:,:,:,423))
  call loop_QV_A(G2(:,:,:,423),wf(:,-5),G2(:,:,:,424))
  call loop_Q_A(G2(:,:,:,424),Q(:,59),MT,G3(:,:,:,333))
  call loop_QV_A(G3(:,:,:,333),wf(:,-2),G3(:,:,:,334))
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,63),MT,G4tensor(:,104))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,100))
  call loop_A_Q(G0(:,:,:,100),Q(:,19),ZERO,G1(:,:,:,269))
  call loop_AV_Q(G1(:,:,:,269),wf(:,-3),G1(:,:,:,270))
  call loop_A_Q(G1(:,:,:,270),Q(:,27),ZERO,G2(:,:,:,425))
  call loop_AV_Q(G2(:,:,:,425),wf(:,-5),G2(:,:,:,426))
  call loop_A_Q(G2(:,:,:,426),Q(:,59),ZERO,G3(:,:,:,335))
  call loop_AV_Q(G3(:,:,:,335),wf(:,-2),G3(:,:,:,336))
  call check_last_A_Q(l_switch,G3(:,:,:,336),Q(:,63),ZERO,G4tensor(:,105))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,101))
  call loop_A_Q(G0(:,:,:,101),Q(:,19),MT,G1(:,:,:,271))
  call loop_AV_Q(G1(:,:,:,271),wf(:,-3),G1(:,:,:,272))
  call loop_A_Q(G1(:,:,:,272),Q(:,27),MT,G2(:,:,:,427))
  call loop_AV_Q(G2(:,:,:,427),wf(:,-5),G2(:,:,:,428))
  call loop_A_Q(G2(:,:,:,428),Q(:,59),MT,G3(:,:,:,337))
  call loop_AV_Q(G3(:,:,:,337),wf(:,-2),G3(:,:,:,338))
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,63),MT,G4tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,19),MB,G1(:,:,:,273))
  call loop_QV_A(G1(:,:,:,273),wf(:,-3),G1(:,:,:,274))
  call loop_Q_A(G1(:,:,:,274),Q(:,27),MB,G2(:,:,:,429))
  call loop_QV_A(G2(:,:,:,429),wf(:,-5),G2(:,:,:,430))
  call loop_Q_A(G2(:,:,:,430),Q(:,59),MB,G3(:,:,:,339))
  call loop_QV_A(G3(:,:,:,339),wf(:,-2),G3(:,:,:,340))
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,63),MB,G4tensor(:,107))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,103))
  call loop_A_Q(G0(:,:,:,103),Q(:,19),MB,G1(:,:,:,275))
  call loop_AV_Q(G1(:,:,:,275),wf(:,-3),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,27),MB,G2(:,:,:,431))
  call loop_AV_Q(G2(:,:,:,431),wf(:,-5),G2(:,:,:,432))
  call loop_A_Q(G2(:,:,:,432),Q(:,59),MB,G3(:,:,:,341))
  call loop_AV_Q(G3(:,:,:,341),wf(:,-2),G3(:,:,:,342))
  call check_last_A_Q(l_switch,G3(:,:,:,342),Q(:,63),MB,G4tensor(:,108))
  call loop_QV_A(G0(:,:,:,1),wf(:,61),G0(:,:,:,104))
  call loop_Q_A(G0(:,:,:,104),Q(:,23),ZERO,G1(:,:,:,277))
  call loop_QV_A(G1(:,:,:,277),wf(:,-5),G1(:,:,:,278))
  call loop_Q_A(G1(:,:,:,278),Q(:,55),ZERO,G2(:,:,:,433))
  call loop_QV_A(G2(:,:,:,433),wf(:,-3),G2(:,:,:,434))
  call check_last_Q_A(l_switch,G2(:,:,:,434),Q(:,63),ZERO,G3tensor(:,97))
  call loop_QV_A(G0(:,:,:,1),wf(:,61),G0(:,:,:,105))
  call loop_Q_A(G0(:,:,:,105),Q(:,23),MT,G1(:,:,:,279))
  call loop_QV_A(G1(:,:,:,279),wf(:,-5),G1(:,:,:,280))
  call loop_Q_A(G1(:,:,:,280),Q(:,55),MT,G2(:,:,:,435))
  call loop_QV_A(G2(:,:,:,435),wf(:,-3),G2(:,:,:,436))
  call check_last_Q_A(l_switch,G2(:,:,:,436),Q(:,63),MT,G3tensor(:,98))
  call loop_AV_Q(G0(:,:,:,1),wf(:,61),G0(:,:,:,106))
  call loop_A_Q(G0(:,:,:,106),Q(:,23),ZERO,G1(:,:,:,281))
  call loop_AV_Q(G1(:,:,:,281),wf(:,-5),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,55),ZERO,G2(:,:,:,437))
  call loop_AV_Q(G2(:,:,:,437),wf(:,-3),G2(:,:,:,438))
  call check_last_A_Q(l_switch,G2(:,:,:,438),Q(:,63),ZERO,G3tensor(:,99))
  call loop_AV_Q(G0(:,:,:,1),wf(:,61),G0(:,:,:,107))
  call loop_A_Q(G0(:,:,:,107),Q(:,23),MT,G1(:,:,:,283))
  call loop_AV_Q(G1(:,:,:,283),wf(:,-5),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,55),MT,G2(:,:,:,439))
  call loop_AV_Q(G2(:,:,:,439),wf(:,-3),G2(:,:,:,440))
  call check_last_A_Q(l_switch,G2(:,:,:,440),Q(:,63),MT,G3tensor(:,100))
  call loop_QV_A(G0(:,:,:,1),wf(:,61),G0(:,:,:,108))
  call loop_Q_A(G0(:,:,:,108),Q(:,23),MB,G1(:,:,:,285))
  call loop_QV_A(G1(:,:,:,285),wf(:,-5),G1(:,:,:,286))
  call loop_Q_A(G1(:,:,:,286),Q(:,55),MB,G2(:,:,:,441))
  call loop_QV_A(G2(:,:,:,441),wf(:,-3),G2(:,:,:,442))
  call check_last_Q_A(l_switch,G2(:,:,:,442),Q(:,63),MB,G3tensor(:,101))
  call loop_AV_Q(G0(:,:,:,1),wf(:,61),G0(:,:,:,109))
  call loop_A_Q(G0(:,:,:,109),Q(:,23),MB,G1(:,:,:,287))
  call loop_AV_Q(G1(:,:,:,287),wf(:,-5),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,55),MB,G2(:,:,:,443))
  call loop_AV_Q(G2(:,:,:,443),wf(:,-3),G2(:,:,:,444))
  call check_last_A_Q(l_switch,G2(:,:,:,444),Q(:,63),MB,G3tensor(:,102))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,110))
  call loop_Q_A(G0(:,:,:,110),Q(:,27),ZERO,G1(:,:,:,289))
  call loop_QV_A(G1(:,:,:,289),wf(:,-5),G1(:,:,:,290))
  call loop_Q_A(G1(:,:,:,290),Q(:,59),ZERO,G2(:,:,:,445))
  call loop_QV_A(G2(:,:,:,445),wf(:,-2),G2(:,:,:,446))
  call check_last_Q_A(l_switch,G2(:,:,:,446),Q(:,63),ZERO,G3tensor(:,103))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,111))
  call loop_Q_A(G0(:,:,:,111),Q(:,27),MT,G1(:,:,:,291))
  call loop_QV_A(G1(:,:,:,291),wf(:,-5),G1(:,:,:,292))
  call loop_Q_A(G1(:,:,:,292),Q(:,59),MT,G2(:,:,:,447))
  call loop_QV_A(G2(:,:,:,447),wf(:,-2),G2(:,:,:,448))
  call check_last_Q_A(l_switch,G2(:,:,:,448),Q(:,63),MT,G3tensor(:,104))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,112))
  call loop_A_Q(G0(:,:,:,112),Q(:,27),ZERO,G1(:,:,:,293))
  call loop_AV_Q(G1(:,:,:,293),wf(:,-5),G1(:,:,:,294))
  call loop_A_Q(G1(:,:,:,294),Q(:,59),ZERO,G2(:,:,:,449))
  call loop_AV_Q(G2(:,:,:,449),wf(:,-2),G2(:,:,:,450))
  call check_last_A_Q(l_switch,G2(:,:,:,450),Q(:,63),ZERO,G3tensor(:,105))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,113))
  call loop_A_Q(G0(:,:,:,113),Q(:,27),MT,G1(:,:,:,295))
  call loop_AV_Q(G1(:,:,:,295),wf(:,-5),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,59),MT,G2(:,:,:,451))
  call loop_AV_Q(G2(:,:,:,451),wf(:,-2),G2(:,:,:,452))
  call check_last_A_Q(l_switch,G2(:,:,:,452),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,114))
  call loop_Q_A(G0(:,:,:,114),Q(:,27),MB,G1(:,:,:,297))
  call loop_QV_A(G1(:,:,:,297),wf(:,-5),G1(:,:,:,298))
  call loop_Q_A(G1(:,:,:,298),Q(:,59),MB,G2(:,:,:,453))
  call loop_QV_A(G2(:,:,:,453),wf(:,-2),G2(:,:,:,454))
  call check_last_Q_A(l_switch,G2(:,:,:,454),Q(:,63),MB,G3tensor(:,107))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,115))
  call loop_A_Q(G0(:,:,:,115),Q(:,27),MB,G1(:,:,:,299))
  call loop_AV_Q(G1(:,:,:,299),wf(:,-5),G1(:,:,:,300))
  call loop_A_Q(G1(:,:,:,300),Q(:,59),MB,G2(:,:,:,455))
  call loop_AV_Q(G2(:,:,:,455),wf(:,-2),G2(:,:,:,456))
  call check_last_A_Q(l_switch,G2(:,:,:,456),Q(:,63),MB,G3tensor(:,108))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,3),T5sum(1:126,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,5),T5sum(1:126,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,7),T5sum(1:126,2))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,9),T5sum(1:126,3))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,5),T5sum(1:126,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,11),T5sum(1:126,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,17),T5sum(1:126,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,21),T5sum(1:126,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,25),T5sum(1:126,5))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,13),T5sum(1:126,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,29),T5sum(1:126,6))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,21),T5sum(1:126,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,33),T5sum(1:126,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,6),T5sum(1:126,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,2),T5sum(1:126,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,4),T5sum(1:126,8))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,6),T5sum(1:126,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,12),T5sum(1:126,9))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,2),T5sum(1:126,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,10),T5sum(1:126,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,14),T5sum(1:126,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,18),T5sum(1:126,11))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,22),T5sum(1:126,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,26),T5sum(1:126,11))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,14),T5sum(1:126,10))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,30),T5sum(1:126,12))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,22),T5sum(1:126,10))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,34),T5sum(1:126,12))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_9,G5tensor(:,37),T5sum(1:126,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,43),T5sum(1:126,14))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_9,G5tensor(:,49),T5sum(1:126,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,55),T5sum(1:126,14))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_9,G5tensor(:,37),T5sum(1:126,13))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_7,G5tensor(:,61),T5sum(1:126,15))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_9,G5tensor(:,49),T5sum(1:126,13))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_7,G5tensor(:,67),T5sum(1:126,15))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_9,G5tensor(:,38),T5sum(1:126,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,44),T5sum(1:126,17))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_9,G5tensor(:,50),T5sum(1:126,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,56),T5sum(1:126,17))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_9,G5tensor(:,38),T5sum(1:126,16))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_7,G5tensor(:,62),T5sum(1:126,18))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_9,G5tensor(:,50),T5sum(1:126,16))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_7,G5tensor(:,68),T5sum(1:126,18))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,15),T5sum(1:126,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,19),T5sum(1:126,20))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,23),T5sum(1:126,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,27),T5sum(1:126,20))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,15),T5sum(1:126,19))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,31),T5sum(1:126,21))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,23),T5sum(1:126,19))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,35),T5sum(1:126,21))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,24),T5sum(1:126,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,28),T5sum(1:126,23))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,16),T5sum(1:126,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,20),T5sum(1:126,23))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,24),T5sum(1:126,22))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,36),T5sum(1:126,24))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,16),T5sum(1:126,22))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,32),T5sum(1:126,24))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_9,G5tensor(:,39),T5sum(1:126,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,45),T5sum(1:126,26))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_9,G5tensor(:,51),T5sum(1:126,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,57),T5sum(1:126,26))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_9,G5tensor(:,39),T5sum(1:126,25))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_7,G5tensor(:,63),T5sum(1:126,27))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_9,G5tensor(:,51),T5sum(1:126,25))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_7,G5tensor(:,69),T5sum(1:126,27))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,40),T5sum(1:126,28))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,46),T5sum(1:126,29))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,52),T5sum(1:126,28))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,58),T5sum(1:126,29))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,40),T5sum(1:126,28))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,64),T5sum(1:126,30))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,52),T5sum(1:126,28))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,70),T5sum(1:126,30))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,41),T5sum(1:126,31))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,47),T5sum(1:126,32))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,53),T5sum(1:126,31))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,59),T5sum(1:126,32))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,41),T5sum(1:126,31))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,65),T5sum(1:126,33))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,53),T5sum(1:126,31))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,71),T5sum(1:126,33))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,42),T5sum(1:126,34))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,48),T5sum(1:126,35))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,54),T5sum(1:126,34))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,60),T5sum(1:126,35))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,42),T5sum(1:126,34))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,66),T5sum(1:126,36))
  M(1) = M(1) + (f(3)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,54),T5sum(1:126,34))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,72),T5sum(1:126,36))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,39),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,13),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,17),T4sum(1:70,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,49),T4sum(1:70,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,25),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,33),T4sum(1:70,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,65),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,25),T4sum(1:70,4))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,57),T4sum(1:70,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,43),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,51),T4sum(1:70,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,27),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,35),T4sum(1:70,8))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,43),T4sum(1:70,7))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,67),T4sum(1:70,9))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,27),T4sum(1:70,7))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,59),T4sum(1:70,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,43),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,45),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,43),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,45),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,14),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,22),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,18),T4sum(1:70,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,42),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,50),T4sum(1:70,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,26),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,34),T4sum(1:70,5))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,42),T4sum(1:70,4))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,66),T4sum(1:70,6))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,26),T4sum(1:70,4))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,58),T4sum(1:70,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,44),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,52),T4sum(1:70,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,28),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,36),T4sum(1:70,8))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,44),T4sum(1:70,7))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,68),T4sum(1:70,9))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,28),T4sum(1:70,7))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,57),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,57),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,62),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,63),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,64),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,65),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,63),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,66),T3sum(1:35,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,3),T4sum(1:70,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,7),T4sum(1:70,11))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,11),T4sum(1:70,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,15),T4sum(1:70,11))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,3),T4sum(1:70,10))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,19),T4sum(1:70,12))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,11),T4sum(1:70,10))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,23),T4sum(1:70,12))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,75),T4sum(1:70,14))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,77),T4sum(1:70,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,79),T4sum(1:70,14))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,13))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,81),T4sum(1:70,15))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,77),T4sum(1:70,13))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,83),T4sum(1:70,15))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,74),T4sum(1:70,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,76),T4sum(1:70,17))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,78),T4sum(1:70,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,80),T4sum(1:70,17))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,74),T4sum(1:70,16))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,82),T4sum(1:70,18))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,78),T4sum(1:70,16))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(46)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,84),T4sum(1:70,18))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,68),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,70),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,74),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,76),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,77),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,78),T3sum(1:35,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,4),T4sum(1:70,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,8),T4sum(1:70,11))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,12),T4sum(1:70,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,16),T4sum(1:70,11))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,4),T4sum(1:70,10))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,20),T4sum(1:70,12))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,12),T4sum(1:70,10))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,24),T4sum(1:70,12))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,85),T4sum(1:70,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,87),T4sum(1:70,14))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,89),T4sum(1:70,13))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,91),T4sum(1:70,14))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,85),T4sum(1:70,13))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,93),T4sum(1:70,15))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,89),T4sum(1:70,13))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,95),T4sum(1:70,15))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,86),T4sum(1:70,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,88),T4sum(1:70,17))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,90),T4sum(1:70,16))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,92),T4sum(1:70,17))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,86),T4sum(1:70,16))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,94),T4sum(1:70,18))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,90),T4sum(1:70,16))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,96),T4sum(1:70,18))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,80),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,82),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,83),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,84),T3sum(1:35,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,47),T4sum(1:70,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,55),T4sum(1:70,20))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,31),T4sum(1:70,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,39),T4sum(1:70,20))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,47),T4sum(1:70,19))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,71),T4sum(1:70,21))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,31),T4sum(1:70,19))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,63),T4sum(1:70,21))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,53),T4sum(1:70,23))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,29),T4sum(1:70,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,37),T4sum(1:70,23))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,69),T4sum(1:70,24))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,29),T4sum(1:70,22))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,61),T4sum(1:70,24))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,97),T4sum(1:70,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,98),T4sum(1:70,26))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,99),T4sum(1:70,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,100),T4sum(1:70,26))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,97),T4sum(1:70,25))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,101),T4sum(1:70,27))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,99),T4sum(1:70,25))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,102),T4sum(1:70,27))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,92),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,94),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,95),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,96),T3sum(1:35,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,48),T4sum(1:70,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,56),T4sum(1:70,20))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,32),T4sum(1:70,19))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,40),T4sum(1:70,20))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,48),T4sum(1:70,19))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,72),T4sum(1:70,21))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,32),T4sum(1:70,19))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,64),T4sum(1:70,21))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,46),T4sum(1:70,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,54),T4sum(1:70,23))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,30),T4sum(1:70,22))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,38),T4sum(1:70,23))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,46),T4sum(1:70,22))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,70),T4sum(1:70,24))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,30),T4sum(1:70,22))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,62),T4sum(1:70,24))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,104),T4sum(1:70,26))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,106),T4sum(1:70,26))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,103),T4sum(1:70,25))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,107),T4sum(1:70,27))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,105),T4sum(1:70,25))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(66)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,108),T4sum(1:70,27))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,98),T3sum(1:35,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,100),T3sum(1:35,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,104),T3sum(1:35,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,106),T3sum(1:35,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,107),T3sum(1:35,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,108),T3sum(1:35,9))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppaaaj2_uuxaaag_1_/**/REALKIND
