
module ol_vamp_1_ppaaaj2_ddxaaag_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppaaaj2_ddxaaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppaaaj2_ddxaaag_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppaaaj2_ddxaaag_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppaaaj2_ddxaaag_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,39) :: G0
  complex(REALKIND), dimension(4,5,4,100) :: G1
  complex(REALKIND), dimension(4,15,4,152) :: G2
  complex(REALKIND), dimension(4,35,4,114) :: G3
  complex(REALKIND), dimension(4,70,4,48) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,36,64))
    allocate(G4tensorhel(70,36,64))
    allocate(G5tensorhel(126,24,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,20),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-3),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,-5),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,60),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,22),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),ZERO,G5tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,24),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,28),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,60),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,22),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),ZERO,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-5),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,56),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,1))
  call loop_AV_Q(G3(:,:,:,5),wf(:,7),G3(:,:,:,7))
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,63),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,48),ZERO,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,23),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,6),wf(:,27),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G2(:,:,:,6),wf(:,31),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,6),wf(:,35),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),ZERO,G3tensor(:,4))
  call loop_AV_Q(G2(:,:,:,6),wf(:,42),G2(:,:,:,11))
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),ZERO,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,6),wf(:,49),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),ZERO,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,11),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,27),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,59),ZERO,G3(:,:,:,8))
  call loop_AV_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9))
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,63),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,14),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,27),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,59),ZERO,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,-2),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,63),ZERO,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,20),ZERO,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-3),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,28),ZERO,G3(:,:,:,12))
  call loop_QV_A(G3(:,:,:,12),wf(:,-5),G3(:,:,:,13))
  call loop_Q_A(G3(:,:,:,13),Q(:,60),ZERO,G4(:,:,:,5))
  call loop_QV_A(G4(:,:,:,5),wf(:,22),G4(:,:,:,6))
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,63),ZERO,G5tensor(:,3))
  call loop_QV_A(G1(:,:,:,7),wf(:,-3),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,24),ZERO,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,28),ZERO,G3(:,:,:,14))
  call loop_QV_A(G3(:,:,:,14),wf(:,-5),G3(:,:,:,15))
  call loop_Q_A(G3(:,:,:,15),Q(:,60),ZERO,G4(:,:,:,7))
  call loop_QV_A(G4(:,:,:,7),wf(:,22),G4(:,:,:,8))
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,63),ZERO,G5tensor(:,4))
  call loop_QV_A(G2(:,:,:,19),wf(:,-5),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,56),ZERO,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,4),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QV_A(G3(:,:,:,16),wf(:,7),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,6))
  call loop_QV_A(G1(:,:,:,7),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,48),ZERO,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,23),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),ZERO,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,22),wf(:,27),G2(:,:,:,24))
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),ZERO,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,22),wf(:,31),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),ZERO,G3tensor(:,9))
  call loop_QV_A(G2(:,:,:,22),wf(:,35),G2(:,:,:,26))
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),ZERO,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,22),wf(:,42),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,63),ZERO,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,22),wf(:,49),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),ZERO,G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,7),wf(:,11),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,27),ZERO,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,59),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,14),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,27),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,59),ZERO,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-2),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,12),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,28),ZERO,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-5),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,60),ZERO,G4(:,:,:,9))
  call loop_QV_A(G4(:,:,:,9),wf(:,22),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),ZERO,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,33),wf(:,-5),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,44),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,-4),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,60),ZERO,G4(:,:,:,11))
  call loop_QV_A(G4(:,:,:,11),wf(:,22),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),ZERO,G5tensor(:,6))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,24),ZERO,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,-2),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,28),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-5),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,60),ZERO,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,22),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),ZERO,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,36),wf(:,-5),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,56),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,4),G3(:,:,:,30))
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QV_A(G3(:,:,:,29),wf(:,7),G3(:,:,:,31))
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,40),ZERO,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,-2),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,44),ZERO,G3(:,:,:,32))
  call loop_QV_A(G3(:,:,:,32),wf(:,-4),G3(:,:,:,33))
  call loop_Q_A(G3(:,:,:,33),Q(:,60),ZERO,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,22),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),ZERO,G5tensor(:,8))
  call loop_QV_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,56),ZERO,G3(:,:,:,34))
  call loop_QV_A(G3(:,:,:,34),wf(:,4),G3(:,:,:,35))
  call check_last_Q_A(l_switch,G3(:,:,:,35),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G3(:,:,:,34),wf(:,7),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,39),wf(:,18),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,59),ZERO,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),ZERO,G4tensor(:,13))
  call loop_QV_A(G2(:,:,:,39),wf(:,21),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,59),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-2),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),ZERO,G4tensor(:,14))
  call loop_QV_A(G1(:,:,:,13),wf(:,18),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,27),ZERO,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,-5),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,59),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),ZERO,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,13),wf(:,21),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,27),ZERO,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,-5),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,59),ZERO,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),ZERO,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,8),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,12),ZERO,G2(:,:,:,48))
  call loop_AV_Q(G2(:,:,:,48),wf(:,-4),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,28),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,60),ZERO,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,22),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),ZERO,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,48),wf(:,-5),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,44),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,60),ZERO,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,22),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),ZERO,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,24),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,28),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,-5),G3(:,:,:,50))
  call loop_A_Q(G3(:,:,:,50),Q(:,60),ZERO,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,22),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,63),ZERO,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-5),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,56),ZERO,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,4),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),ZERO,G4tensor(:,17))
  call loop_AV_Q(G3(:,:,:,51),wf(:,7),G3(:,:,:,53))
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,63),ZERO,G4tensor(:,18))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,40),ZERO,G2(:,:,:,54))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-2),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,44),ZERO,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-4),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,60),ZERO,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,22),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,63),ZERO,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-4),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,56),ZERO,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,4),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,63),ZERO,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,56),wf(:,7),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),ZERO,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,54),wf(:,18),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,59),ZERO,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-2),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,63),ZERO,G4tensor(:,21))
  call loop_AV_Q(G2(:,:,:,54),wf(:,21),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,59),ZERO,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,63),ZERO,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,19),wf(:,18),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,27),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,59),ZERO,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-2),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,19),wf(:,21),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,27),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,59),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,4),ZERO,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,12),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,28),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,60),ZERO,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,22),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,63),ZERO,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,44),ZERO,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,60),ZERO,G4(:,:,:,27))
  call loop_AV_Q(G4(:,:,:,27),wf(:,22),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),ZERO,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,20),ZERO,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-3),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,28),ZERO,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-5),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,60),ZERO,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,22),G4(:,:,:,30))
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,63),ZERO,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-5),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,52),ZERO,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-3),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,60),ZERO,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,22),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,63),ZERO,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,36),ZERO,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-3),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,44),ZERO,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-4),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,60),ZERO,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,22),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),ZERO,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,52),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-3),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,60),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,22),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),ZERO,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,4),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,-3),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,12),ZERO,G2(:,:,:,72))
  call loop_QV_A(G2(:,:,:,72),wf(:,-4),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,28),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,60),ZERO,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,22),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),ZERO,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,72),wf(:,-5),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,44),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-4),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,60),ZERO,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,22),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),ZERO,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,20),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-3),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,28),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-5),G3(:,:,:,84))
  call loop_Q_A(G3(:,:,:,84),Q(:,60),ZERO,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,22),G4(:,:,:,42))
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,63),ZERO,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,52),ZERO,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-3),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,60),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,22),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,63),ZERO,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,36),ZERO,G2(:,:,:,78))
  call loop_QV_A(G2(:,:,:,78),wf(:,-3),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,44),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,60),ZERO,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,22),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,63),ZERO,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,78),wf(:,-4),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,52),ZERO,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,60),ZERO,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,22),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,63),ZERO,G5tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,23),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,-5),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,55),ZERO,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-3),G2(:,:,:,82))
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,13))
  call loop_AV_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,23),ZERO,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,55),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-3),G2(:,:,:,84))
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,23),ZERO,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,55),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86))
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,15))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,23),ZERO,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-5),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,55),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-3),G2(:,:,:,88))
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,23),ZERO,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,-5),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,55),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-3),G2(:,:,:,90))
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,17))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,23),ZERO,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-5),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,55),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-3),G2(:,:,:,92))
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,63),ZERO,G3tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,23),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,-5),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,55),ZERO,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-3),G2(:,:,:,94))
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,63),ZERO,G3tensor(:,19))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,23),ZERO,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-5),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,55),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-3),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,63),ZERO,G3tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,27),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,-5),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,59),ZERO,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-2),G2(:,:,:,98))
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,63),ZERO,G3tensor(:,21))
  call loop_AV_Q(G0(:,:,:,1),wf(:,39),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,27),ZERO,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-5),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,59),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-2),G2(:,:,:,100))
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),ZERO,G3tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,11),ZERO,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,43),ZERO,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-4),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,59),ZERO,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,-2),G3(:,:,:,92))
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),ZERO,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,53),wf(:,-4),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,27),ZERO,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,-5),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,59),ZERO,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-2),G3(:,:,:,94))
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,63),ZERO,G4tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,11),ZERO,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-5),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,43),ZERO,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-4),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,59),ZERO,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-2),G3(:,:,:,96))
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),ZERO,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,27),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-5),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,59),ZERO,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-2),G3(:,:,:,98))
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,63),ZERO,G4tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,27),ZERO,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-5),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,59),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110))
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),ZERO,G3tensor(:,23))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,27),ZERO,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,59),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-2),G2(:,:,:,112))
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,63),ZERO,G3tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,27),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,59),ZERO,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-2),G2(:,:,:,114))
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),ZERO,G3tensor(:,25))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,27),ZERO,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-5),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,59),ZERO,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116))
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,63),ZERO,G3tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,11),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,43),ZERO,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,59),ZERO,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-2),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),ZERO,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,27),ZERO,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,59),ZERO,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-2),G3(:,:,:,102))
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,63),ZERO,G4tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,11),ZERO,G1(:,:,:,70))
  call loop_AV_Q(G1(:,:,:,70),wf(:,-5),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,43),ZERO,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-4),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,59),ZERO,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-2),G3(:,:,:,104))
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,63),ZERO,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,70),wf(:,-4),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,27),ZERO,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-5),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,59),ZERO,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-2),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,63),ZERO,G4tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,27),ZERO,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,-5),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,59),ZERO,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126))
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,63),ZERO,G3tensor(:,27))
  call loop_AV_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,27),ZERO,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),ZERO,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-2),G2(:,:,:,128))
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,63),ZERO,G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,19),ZERO,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,-3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,27),ZERO,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,-5),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,59),ZERO,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-2),G3(:,:,:,108))
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,63),ZERO,G4tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,19),ZERO,G1(:,:,:,79))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-3),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,27),ZERO,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-5),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,59),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,63),ZERO,G4tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,23),ZERO,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,55),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,-3),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),ZERO,G3tensor(:,29))
  call loop_AV_Q(G0(:,:,:,1),wf(:,55),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,23),ZERO,G1(:,:,:,83))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-5),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,55),ZERO,G2(:,:,:,135))
  call loop_AV_Q(G2(:,:,:,135),wf(:,-3),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),ZERO,G3tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,27),ZERO,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,59),ZERO,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-2),G2(:,:,:,138))
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,27),ZERO,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,-5),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,59),ZERO,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-2),G2(:,:,:,140))
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,19),ZERO,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,-3),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,27),ZERO,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,-5),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,59),ZERO,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-2),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),ZERO,G4tensor(:,35))
  call loop_AV_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,19),ZERO,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-3),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,27),ZERO,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-5),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,59),ZERO,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-2),G3(:,:,:,114))
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,63),ZERO,G4tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,61),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,23),ZERO,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,-5),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,55),ZERO,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-3),G2(:,:,:,146))
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,63),ZERO,G3tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,61),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,23),ZERO,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-5),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,55),ZERO,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-3),G2(:,:,:,148))
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),ZERO,G3tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,27),ZERO,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,-5),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,59),ZERO,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,-2),G2(:,:,:,150))
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),ZERO,G3tensor(:,35))
  call loop_AV_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,27),ZERO,G1(:,:,:,99))
  call loop_AV_Q(G1(:,:,:,99),wf(:,-5),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,59),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-2),G2(:,:,:,152))
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,63),ZERO,G3tensor(:,36))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,3),T5sum(1:126,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,3),T5sum(1:126,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,5),T5sum(1:126,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,9),T5sum(1:126,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,5),T5sum(1:126,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,9),T5sum(1:126,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,4),T5sum(1:126,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,2),T5sum(1:126,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,4),T5sum(1:126,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,2),T5sum(1:126,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,6),T5sum(1:126,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,10),T5sum(1:126,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,6),T5sum(1:126,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,10),T5sum(1:126,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_3,G5tensor(:,13),T5sum(1:126,5))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_13,masses2_3,G5tensor(:,19),T5sum(1:126,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_3,G5tensor(:,13),T5sum(1:126,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_13,masses2_3,G5tensor(:,19),T5sum(1:126,5))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_3,G5tensor(:,14),T5sum(1:126,6))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_14,masses2_3,G5tensor(:,20),T5sum(1:126,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_3,G5tensor(:,14),T5sum(1:126,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_14,masses2_3,G5tensor(:,20),T5sum(1:126,6))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,7),T5sum(1:126,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,11),T5sum(1:126,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,7),T5sum(1:126,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,11),T5sum(1:126,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,12),T5sum(1:126,8))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,12),T5sum(1:126,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_3,G5tensor(:,15),T5sum(1:126,9))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_15,masses2_3,G5tensor(:,21),T5sum(1:126,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_3,G5tensor(:,15),T5sum(1:126,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_15,masses2_3,G5tensor(:,21),T5sum(1:126,9))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,16),T5sum(1:126,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,16),T5sum(1:126,10))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,22),T5sum(1:126,10))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,17),T5sum(1:126,11))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,23),T5sum(1:126,11))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,17),T5sum(1:126,11))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,23),T5sum(1:126,11))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,18),T5sum(1:126,12))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(16)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,24),T5sum(1:126,12))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,18),T5sum(1:126,12))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(16)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,24),T5sum(1:126,12))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,17),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,17),T4sum(1:70,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,19),T4sum(1:70,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,11),T4sum(1:70,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,19),T4sum(1:70,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(24)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,11),T4sum(1:70,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(30)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,6),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,6),T4sum(1:70,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,18),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,10),T4sum(1:70,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,18),T4sum(1:70,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,10),T4sum(1:70,2))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(35)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(44)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,7),T4sum(1:70,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,7),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,25),T4sum(1:70,5))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,25),T4sum(1:70,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,27),T4sum(1:70,5))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,26),T4sum(1:70,6))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,28),T4sum(1:70,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,26),T4sum(1:70,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(46)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,28),T4sum(1:70,6))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(51)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,8),T4sum(1:70,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,8),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,29),T4sum(1:70,5))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,31),T4sum(1:70,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,29),T4sum(1:70,5))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,31),T4sum(1:70,5))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,30),T4sum(1:70,6))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,32),T4sum(1:70,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,30),T4sum(1:70,6))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,32),T4sum(1:70,6))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(59)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,15),T4sum(1:70,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,15),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,21),T4sum(1:70,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,13),T4sum(1:70,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,21),T4sum(1:70,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,13),T4sum(1:70,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,33),T4sum(1:70,9))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,34),T4sum(1:70,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,33),T4sum(1:70,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(61)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,34),T4sum(1:70,9))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,24),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,16),T4sum(1:70,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,24),T4sum(1:70,7))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,16),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,22),T4sum(1:70,8))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,14),T4sum(1:70,8))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,35),T4sum(1:70,9))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,36),T4sum(1:70,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,35),T4sum(1:70,9))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(66)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,36),T4sum(1:70,9))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(68)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (f(2)/2._/**/REALKIND * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,3))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppaaaj2_ddxaaag_2_/**/REALKIND
